local MDT = MDT
local L = MDT.L
local dungeonIndex = 18
MDT.dungeonList[dungeonIndex] = L["Shrine of the Storm"]
MDT.mapInfo[dungeonIndex] = {
  viewportPositionOverrides =
  {
    [2] = {
      zoomScale = 1.5999999046326,
      horizontalPan = 134.99547002502,
      verticalPan = 39.046512114573,
    },
  },
};

local zones = { 1039, 1040 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "ShrineOfTheStorm",
  [1] = "ShrineOfTheStorm",
  [2] = "ShrineOfTheStorm1_",
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["Shrine of the Storm Sublevel"],
  [2] = L["Storm's End"],
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 695, teeming = 834, teemingEnabled = true }
MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 472.00015734322,
      ["y"] = -457.99797251262,
      ["target"] = 2,
      ["direction"] = 2,
      ["connectionIndex"] = 1,
    },
    [2] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 376.79743477931,
      ["y"] = -44.698101078348,
      ["graveyardDescription"] = "",
    },
    [3] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "shrineSkip",
      ["x"] = 334.5590898671,
      ["y"] = -233.51734280849,
    },
    [4] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "shrineSkip",
      ["x"] = 293.50645016815,
      ["y"] = -253.51733981453,
    },
    [5] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 372.10909499504,
      ["y"] = -406.27451312521,
      ["index"] = 4,
      ["npcId"] = 161244,
      ["tooltipText"] = "Defiled Spire of Ny'alotha",
      ["weeks"] = {
        [1] = true,
        [2] = true,
        [5] = true,
        [6] = true,
        [9] = true,
        [10] = true,
      },
    },
    [6] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 436.54485983495,
      ["y"] = -103.13131615803,
      ["index"] = 1,
      ["npcId"] = 161241,
      ["tooltipText"] = "Cursed Spire of Ny'alotha",
      ["weeks"] = {
        [1] = true,
        [2] = true,
        [5] = true,
        [6] = true,
        [9] = true,
        [10] = true,
      },
    },
    [7] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 437.17700663183,
      ["y"] = -101.55790302352,
      ["index"] = 5,
      ["npcId"] = 161244,
      ["tooltipText"] = "Defiled Spire of Ny'alotha",
      ["weeks"] = {
        [3] = true,
        [4] = true,
        [7] = true,
        [8] = true,
        [11] = true,
        [12] = true,
      },
    },
    [8] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 371.293909517,
      ["y"] = -407.05966533335,
      ["index"] = 6,
      ["npcId"] = 161241,
      ["tooltipText"] = "Cursed Spire of Ny'alotha",
      ["weeks"] = {
        [3] = true,
        [4] = true,
        [7] = true,
        [8] = true,
        [11] = true,
        [12] = true,
      },
    },
    [9] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 365.05430867712,
      ["y"] = -234.78449730226,
      ["index"] = 2,
      ["npcId"] = 161124,
      ["tooltipText"] = "Brutal Spire of Ny'alotha",
      ["weeks"] = {
        [1] = true,
        [2] = true,
        [3] = true,
        [4] = true,
        [5] = true,
        [6] = true,
        [7] = true,
        [8] = true,
        [9] = true,
        [10] = true,
        [11] = true,
        [12] = true,
      },
    },
    [10] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 257.75063927047,
      ["y"] = -233.56873425269,
      ["index"] = 3,
      ["npcId"] = 161243,
      ["tooltipText"] = "Entropic Spire of Ny'alotha",
      ["weeks"] = {
        [1] = true,
        [2] = true,
        [3] = true,
        [4] = true,
        [5] = true,
        [6] = true,
        [7] = true,
        [8] = true,
        [9] = true,
        [10] = true,
        [11] = true,
        [12] = true,
      },
    },
  },
  [2] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 168.00002506189,
      ["y"] = -209.99820934608,
      ["target"] = 1,
      ["direction"] = -2,
      ["connectionIndex"] = 1,
    },
    [2] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 246.66820971448,
      ["y"] = -252.33727223727,
      ["graveyardDescription"] = "shrineGraveyardNote1",
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Shrine Templar",
    ["id"] = 134139,
    ["count"] = 10,
    ["health"] = 922194,
    ["scale"] = 1.2,
    ["stealthDetect"] = true,
    ["displayId"] = 84416,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [267977] = {
      },
      [267981] = {
      },
      [276268] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 417.31970845724,
        ["y"] = -45.143253087513,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 417.31970845724,
            ["y"] = -45.143253087513,
          },
          [2] = {
            ["x"] = 408.86584932181,
            ["y"] = -54.284238763405,
          },
          [3] = {
            ["x"] = 417.31970845724,
            ["y"] = -45.143253087513,
          },
          [4] = {
            ["x"] = 427.90429944824,
            ["y"] = -45.053479067174,
          },
        },
        ["infested"] = {
          [2] = true,
          [3] = true,
        },
      },
      [2] = {
        ["x"] = 401.3537643933,
        ["y"] = -127.71929280082,
        ["g"] = 53,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 401.3537643933,
            ["y"] = -127.71929280082,
          },
          [2] = {
            ["x"] = 398.10376360773,
            ["y"] = -116.9692877265,
          },
          [3] = {
            ["x"] = 399.10377705416,
            ["y"] = -100.4692697082,
          },
          [4] = {
            ["x"] = 398.10376360773,
            ["y"] = -116.9692877265,
          },
          [5] = {
            ["x"] = 401.3537643933,
            ["y"] = -127.71929280082,
          },
          [6] = {
            ["x"] = 409.35374321875,
            ["y"] = -135.7192823551,
          },
          [7] = {
            ["x"] = 427.60377403947,
            ["y"] = -135.46928972233,
          },
          [8] = {
            ["x"] = 437.35377639618,
            ["y"] = -129.21927005512,
          },
          [9] = {
            ["x"] = 441.60376917052,
            ["y"] = -121.71926576638,
          },
          [10] = {
            ["x"] = 442.85376452089,
            ["y"] = -109.7192653417,
          },
          [11] = {
            ["x"] = 440.85375908569,
            ["y"] = -99.969284442661,
          },
          [12] = {
            ["x"] = 442.85376452089,
            ["y"] = -109.7192653417,
          },
          [13] = {
            ["x"] = 441.60376917052,
            ["y"] = -121.71926576638,
          },
          [14] = {
            ["x"] = 437.35377639618,
            ["y"] = -129.21927005512,
          },
          [15] = {
            ["x"] = 427.60377403947,
            ["y"] = -135.46928972233,
          },
          [16] = {
            ["x"] = 409.35374321875,
            ["y"] = -135.7192823551,
          },
        },
        ["infested"] = {
          [2] = true,
        },
      },
      [3] = {
        ["x"] = 444.69923788948,
        ["y"] = -188.03778922034,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 440.52196780054,
            ["y"] = -187.91120873524,
          },
          [2] = {
            ["x"] = 454.19693752964,
            ["y"] = -188.15588859182,
          },
          [3] = {
            ["x"] = 440.52196780054,
            ["y"] = -187.91120873524,
          },
          [4] = {
            ["x"] = 428.19696418089,
            ["y"] = -192.2987571855,
          },
        },
        ["infested"] = {
          [3] = true,
        },
      },
      [4] = {
        ["x"] = 402.58362279895,
        ["y"] = -185.37106971857,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 399.00564401245,
            ["y"] = -186.65547246083,
          },
          [2] = {
            ["x"] = 408.38117141421,
            ["y"] = -184.49064798528,
          },
          [3] = {
            ["x"] = 408.77590212944,
            ["y"] = -179.35908092624,
          },
          [4] = {
            ["x"] = 408.38117141421,
            ["y"] = -184.49064798528,
          },
          [5] = {
            ["x"] = 399.00564401245,
            ["y"] = -186.65547246083,
          },
          [6] = {
            ["x"] = 378.64433536205,
            ["y"] = -194.49064899797,
          },
          [7] = {
            ["x"] = 376.93380924453,
            ["y"] = -189.88538203023,
          },
          [8] = {
            ["x"] = 378.64433536205,
            ["y"] = -194.49064899797,
          },
        },
      },
      [5] = {
        ["x"] = 421.46948565433,
        ["y"] = -162.02169713661,
        ["sublevel"] = 1,
        ["teeming"] = true,
        ["patrol"] = {
          [1] = {
            ["x"] = 421.46948565433,
            ["y"] = -162.02169713661,
          },
          [2] = {
            ["x"] = 405.49934429731,
            ["y"] = -168.14111008598,
          },
          [3] = {
            ["x"] = 421.46948565433,
            ["y"] = -162.02169713661,
          },
          [4] = {
            ["x"] = 425.49933811944,
            ["y"] = -149.4843726627,
          },
          [5] = {
            ["x"] = 438.78291543658,
            ["y"] = -146.05155577959,
          },
          [6] = {
            ["x"] = 425.49933811944,
            ["y"] = -149.4843726627,
          },
        },
      },
    },
  },
  [2] = {
    ["name"] = "Tidesage Initiate",
    ["id"] = 136347,
    ["count"] = 1,
    ["health"] = 153699,
    ["scale"] = 0.5,
    ["displayId"] = 83301,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [132951] = {
      },
      [209859] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 431.00992737763,
        ["y"] = -39.271126005296,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 436.00992391869,
        ["y"] = -38.271121547242,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 430.90992607351,
        ["y"] = -43.871117329917,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 436.10992522281,
        ["y"] = -43.071119771621,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 430.90992607351,
        ["y"] = -48.371120225025,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 436.50992185619,
        ["y"] = -48.171121908335,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 430.30992683191,
        ["y"] = -53.671116386897,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 436.30991924796,
        ["y"] = -53.271119753516,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 401.13382366944,
        ["y"] = -53.560165008672,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [10] = {
        ["x"] = 404.87510109394,
        ["y"] = -55.352122015675,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["infested"] = {
        },
      },
      [11] = {
        ["x"] = 407.49747011522,
        ["y"] = -57.406328637019,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 410.55689361033,
        ["y"] = -62.19652782812,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 408.74748119269,
        ["y"] = -65.658066090407,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 406.70202339839,
        ["y"] = -69.23324726142,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 336.76366323451,
        ["y"] = -210.62695915834,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 339.30914074176,
        ["y"] = -205.89968674677,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 348.76367092927,
        ["y"] = -217.17239941777,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [18] = {
        ["x"] = 350.58186121556,
        ["y"] = -212.62695491321,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 326.17530433152,
        ["y"] = -159.94275400391,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [20] = {
        ["x"] = 327.42529396357,
        ["y"] = -163.38024560862,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 327.89406354491,
        ["y"] = -166.81775062438,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 329.30031864478,
        ["y"] = -170.72398498835,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 329.30031864478,
            ["y"] = -170.72398498835,
          },
          [2] = {
            ["x"] = 330.70654692255,
            ["y"] = -177.7552403711,
          },
          [3] = {
            ["x"] = 333.05028754094,
            ["y"] = -187.59898583701,
          },
          [4] = {
            ["x"] = 330.70654692255,
            ["y"] = -177.7552403711,
          },
          [5] = {
            ["x"] = 327.42529396357,
            ["y"] = -163.38024560862,
          },
          [6] = {
            ["x"] = 326.80031255858,
            ["y"] = -154.78648977476,
          },
          [7] = {
            ["x"] = 331.17528968181,
            ["y"] = -149.00524414063,
          },
          [8] = {
            ["x"] = 326.80031255858,
            ["y"] = -154.78648977476,
          },
          [9] = {
            ["x"] = 327.42529396357,
            ["y"] = -163.38024560862,
          },
        },
      },
      [23] = {
        ["x"] = 310.50411564479,
        ["y"] = -138.22756832809,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 307.81182173732,
        ["y"] = -143.80449114653,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [25] = {
        ["x"] = 294.7349066657,
        ["y"] = -136.88141312141,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 298.58106204109,
        ["y"] = -129.95835160219,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 233.58358865411,
        ["y"] = -200.86770397051,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 236.51461746688,
        ["y"] = -202.24701034137,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 238.23876337905,
        ["y"] = -203.97115625354,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 239.96289449283,
        ["y"] = -205.86768863998,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 243.36482655558,
        ["y"] = -211.0755323461,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [32] = {
        ["x"] = 242.73981832851,
        ["y"] = -214.35677859956,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 241.48982869646,
        ["y"] = -216.85677798023,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 239.45856536953,
        ["y"] = -218.57553719363,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 234.45646738278,
        ["y"] = -228.56556204213,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 231.4564645944,
        ["y"] = -229.99411553039,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 228.28075352335,
        ["y"] = -230.01409097431,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 224.62690839261,
        ["y"] = -230.59099694942,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 210.03420500656,
        ["y"] = -237.65698629443,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 212.46277152037,
        ["y"] = -235.3712726674,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 214.89135029571,
        ["y"] = -233.37127707549,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 215.891326634,
        ["y"] = -230.08556258712,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [43] = {
        ["x"] = 219.76776820851,
        ["y"] = -211.80249584801,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [44] = {
        ["x"] = 218.04365189312,
        ["y"] = -208.52662009473,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [45] = {
        ["x"] = 215.45744042406,
        ["y"] = -205.59558388276,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [46] = {
        ["x"] = 212.87122895501,
        ["y"] = -204.04385404165,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [47] = {
        ["x"] = 217.78657153893,
        ["y"] = -197.73586573147,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [48] = {
        ["x"] = 220.08164155848,
        ["y"] = -195.76866185254,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [49] = {
        ["x"] = 222.04885247272,
        ["y"] = -193.96536642035,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [50] = {
        ["x"] = 225.32754201999,
        ["y"] = -191.83422595345,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Temple Attendant",
    ["id"] = 134137,
    ["count"] = 9,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 84637,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148893,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [132951] = {
      },
      [209859] = {
      },
      [255228] = {
      },
      [267969] = {
      },
      [267973] = {
      },
      [277242] = {
      },
      [277247] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 428.85410460044,
        ["y"] = -90.17926926711,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["infested"] = {
        },
      },
      [2] = {
        ["x"] = 417.29091951616,
        ["y"] = -90.530369234896,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [3] = {
        ["x"] = 416.60375487471,
        ["y"] = -131.96928557515,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 422.85377454192,
        ["y"] = -131.96928557515,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 417.15374362214,
        ["y"] = -152.96926192495,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 421.00375378157,
        ["y"] = -158.91926062956,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [7] = {
        ["x"] = 468.86870971861,
        ["y"] = -190.16236806577,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 468.67528154765,
        ["y"] = -181.60896628439,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
          [2] = true,
          [3] = true,
        },
      },
      [9] = {
        ["x"] = 436.09545104012,
        ["y"] = -198.79554581267,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 433.23829521213,
        ["y"] = -206.32364995217,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 421.34314017816,
        ["y"] = -205.32175910615,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 408.84812554784,
        ["y"] = -170.4676682523,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 408.43717301568,
        ["y"] = -177.31699077861,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 376.07741032688,
        ["y"] = -192.58021665522,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 334.67757975363,
        ["y"] = -140.07844582097,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 316.66033931211,
        ["y"] = -114.65802715898,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 236.07112848534,
        ["y"] = -188.43532679302,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 234.85293014791,
        ["y"] = -195.91714714388,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Animated Droplet",
    ["id"] = 134173,
    ["count"] = 1,
    ["health"] = 107589,
    ["scale"] = 0.5,
    ["displayId"] = 88636,
    ["creatureType"] = "Elemental",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 428.76077680616,
        ["y"] = -104.93604583807,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 424.95634875255,
        ["y"] = -105.49000741847,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 421.23677069635,
        ["y"] = -110.30917726385,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 425.35207868541,
        ["y"] = -109.99550564859,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [5] = {
        ["x"] = 431.25306668223,
        ["y"] = -101.68056075085,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 421.39219622946,
        ["y"] = -105.656856903,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 416.78506440594,
        ["y"] = -109.89649035906,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 417.44929294338,
        ["y"] = -105.26391197868,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 411.71159678861,
        ["y"] = -107.23112289292,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 411.87550523536,
        ["y"] = -103.95244741625,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 429.24147831721,
        ["y"] = -108.91580556184,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 411.87550523536,
        ["y"] = -100.18195514042,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 409.3537471317,
        ["y"] = -138.46923957153,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 413.85374326764,
        ["y"] = -137.71925094438,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 418.10373604197,
        ["y"] = -138.71925366198,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [16] = {
        ["x"] = 415.20374008138,
        ["y"] = -141.36924877162,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 411.00375691863,
        ["y"] = -141.66923599557,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 413.4037315005,
        ["y"] = -144.41924603682,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 408.2157801023,
        ["y"] = -187.42014535225,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 411.80949694169,
        ["y"] = -185.3889088474,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 415.87201018452,
        ["y"] = -185.3889088474,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 415.09076331172,
        ["y"] = -188.98265250888,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 410.40326866392,
        ["y"] = -189.92015814396,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 413.2157654526,
        ["y"] = -193.8264126245,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 384.71716718434,
        ["y"] = -184.92414425918,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 386.4923326422,
        ["y"] = -187.7575217774,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 387.15157973553,
        ["y"] = -192.15691965642,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 388.46804285823,
        ["y"] = -196.05920628817,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 385.40208620517,
        ["y"] = -195.34019371701,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 381.94999505505,
        ["y"] = -196.1424283141,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 363.39457695257,
        ["y"] = -191.73859365957,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 361.20279092232,
        ["y"] = -193.93036793219,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 361.75073155107,
        ["y"] = -197.35502919535,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 364.3534818711,
        ["y"] = -195.71118967266,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 365.72333932178,
        ["y"] = -199.27283903241,
        ["g"] = 51,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [36] = {
        ["x"] = 362.70962471197,
        ["y"] = -202.01255981259,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 369.58841038074,
        ["y"] = -213.72341148423,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 373.4066115425,
        ["y"] = -209.35977196327,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 379.0429717794,
        ["y"] = -206.45068155023,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 388.13386078853,
        ["y"] = -205.72340699627,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 392.67932870147,
        ["y"] = -207.90523065815,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 391.58840516635,
        ["y"] = -211.54159562515,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [43] = {
        ["x"] = 386.67932728619,
        ["y"] = -209.35977196327,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [44] = {
        ["x"] = 379.77023853057,
        ["y"] = -211.54159562515,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [45] = {
        ["x"] = 383.2247673028,
        ["y"] = -209.17795917688,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [46] = {
        ["x"] = 374.86114504484,
        ["y"] = -212.26887017911,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [47] = {
        ["x"] = 374.13387829367,
        ["y"] = -216.2688607189,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [48] = {
        ["x"] = 382.86114173001,
        ["y"] = -205.54158640709,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Tidesage Spiritualist",
    ["id"] = 136186,
    ["count"] = 9,
    ["health"] = 922194,
    ["scale"] = 1,
    ["displayId"] = 83304,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148893,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [268030] = {
      },
      [268050] = {
      },
      [268059] = {
      },
      [276265] = {
      },
      [276266] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 392.60375402535,
        ["y"] = -117.46926226321,
        ["g"] = 81,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 446.85375393361,
        ["y"] = -115.71927091846,
        ["g"] = 80,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 441.32022403191,
        ["y"] = -138.58889551718,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 440.7232017571,
        ["y"] = -155.90232316657,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [5] = {
        ["x"] = 439.53948597775,
        ["y"] = -168.52340977394,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 439.41775355425,
        ["y"] = -177.42809773313,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [7] = {
        ["x"] = 424.956204557,
        ["y"] = -198.46462295913,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [8] = {
        ["x"] = 381.53706407238,
        ["y"] = -190.61055329469,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [9] = {
        ["x"] = 369.59739526254,
        ["y"] = -195.17148880913,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [10] = {
        ["x"] = 406.78324788916,
        ["y"] = -123.6317142079,
        ["g"] = 53,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
      [11] = {
        ["x"] = 295.50935599068,
        ["y"] = -165.87574238589,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [6] = {
    ["name"] = "Living Current",
    ["id"] = 134144,
    ["count"] = 18,
    ["health"] = 1229592,
    ["scale"] = 1.2,
    ["stealthDetect"] = true,
    ["displayId"] = 88525,
    ["creatureType"] = "Elemental",
    ["level"] = 121,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [268027] = {
      },
      [268028] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 419.85378621419,
        ["y"] = -118.71929546533,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [2] = {
        ["x"] = 403.09472352342,
        ["y"] = -174.44027575893,
        ["g"] = 14,
        ["sublevel"] = 1,
        ["infested"] = {
        },
      },
    },
  },
  [7] = {
    ["name"] = "Aqu'sirr",
    ["id"] = 134056,
    ["count"] = 0,
    ["health"] = 6147954,
    ["scale"] = 1,
    ["displayId"] = 85628,
    ["creatureType"] = "Elemental",
    ["level"] = 122,
    ["isBoss"] = true,
    ["encounterID"] = 2153,
    ["instanceID"] = 1036,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [264101] = {
      },
      [264144] = {
      },
      [264155] = {
      },
      [264477] = {
      },
      [264560] = {
      },
      [264903] = {
      },
      [265001] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 385.31130779569,
        ["y"] = -227.4581610683,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Galecaller Apprentice",
    ["id"] = 139800,
    ["count"] = 9,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 83301,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148893,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [255228] = {
      },
      [274434] = {
      },
      [274437] = {
      },
      [276282] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 354.68746748744,
        ["y"] = -226.38323647594,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 356.2233129393,
        ["y"] = -234.12481430424,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [3] = {
        ["x"] = 335.49395218065,
        ["y"] = -146.8131417399,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 319.16033001286,
        ["y"] = -120.15801528368,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [5] = {
        ["x"] = 278.22724603976,
        ["y"] = -162.82332266677,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["infested"] = {
        },
      },
      [6] = {
        ["x"] = 282.48955511475,
        ["y"] = -166.2659558373,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [7] = {
        ["x"] = 272.54759162566,
        ["y"] = -227.46885654229,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 266.0476115122,
        ["y"] = -228.21887735596,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [9] = {
        ["x"] = 241.9166042,
        ["y"] = -185.31295423431,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [10] = {
        ["x"] = 264.00980583195,
        ["y"] = -201.2513745246,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [11] = {
        ["x"] = 231.4564645944,
        ["y"] = -217.13699312851,
        ["g"] = 34,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
    },
  },
  [9] = {
    ["name"] = "Windspeaker Heldis",
    ["id"] = 136214,
    ["count"] = 36,
    ["health"] = 2766582,
    ["scale"] = 1.2,
    ["stealthDetect"] = true,
    ["displayId"] = 84789,
    ["creatureType"] = "Humanoid",
    ["level"] = 121,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [268177] = {
      },
      [268184] = {
      },
      [268187] = {
      },
      [268188] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 343.6727832013,
        ["y"] = -212.80878282022,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
    },
  },
  [10] = {
    ["name"] = "Ironhull Apprentice",
    ["id"] = 139799,
    ["count"] = 9,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 84337,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [132951] = {
      },
      [209859] = {
      },
      [255228] = {
      },
      [274631] = {
      },
      [274633] = {
      },
      [276292] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 327.31348151023,
        ["y"] = -186.94191078847,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 342.52989365552,
        ["y"] = -182.001598542,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [3] = {
        ["x"] = 331.41228272666,
        ["y"] = -135.79272705138,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 310.16033774097,
        ["y"] = -110.90801965019,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 276.42397171347,
        ["y"] = -157.74136582852,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 287.89937809361,
        ["y"] = -167.57743447032,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 273.5476050721,
        ["y"] = -220.96885497115,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 258.43287476056,
        ["y"] = -206.44367685373,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 258.43287476056,
            ["y"] = -206.44367685373,
          },
          [2] = {
            ["x"] = 264.20215098293,
            ["y"] = -213.75137880152,
          },
          [3] = {
            ["x"] = 266.89444489039,
            ["y"] = -221.05906081005,
          },
          [4] = {
            ["x"] = 264.20215098293,
            ["y"] = -213.75137880152,
          },
          [5] = {
            ["x"] = 258.43287476056,
            ["y"] = -206.44367685373,
          },
          [6] = {
            ["x"] = 249.58677045996,
            ["y"] = -197.40523083551,
          },
          [7] = {
            ["x"] = 242.85597792064,
            ["y"] = -194.52060192454,
          },
          [8] = {
            ["x"] = 249.58677045996,
            ["y"] = -197.40523083551,
          },
        },
      },
      [9] = {
        ["x"] = 227.02789605623,
        ["y"] = -223.56555739483,
        ["g"] = 34,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 227.02789605623,
            ["y"] = -223.56555739483,
          },
          [2] = {
            ["x"] = 218.17359793711,
            ["y"] = -220.10068605712,
          },
          [3] = {
            ["x"] = 227.02789605623,
            ["y"] = -223.56555739483,
          },
          [4] = {
            ["x"] = 236.97955902689,
            ["y"] = -222.93651219515,
          },
          [5] = {
            ["x"] = 244.4422539962,
            ["y"] = -219.50367609622,
          },
          [6] = {
            ["x"] = 247.87507087931,
            ["y"] = -213.6827681273,
          },
          [7] = {
            ["x"] = 246.23329668946,
            ["y"] = -208.30965285807,
          },
          [8] = {
            ["x"] = 247.87507087931,
            ["y"] = -213.6827681273,
          },
          [9] = {
            ["x"] = 244.4422539962,
            ["y"] = -219.50367609622,
          },
          [10] = {
            ["x"] = 236.97955902689,
            ["y"] = -222.93651219515,
          },
        },
        ["infested"] = {
        },
      },
      [10] = {
        ["x"] = 310.67962976215,
        ["y"] = -118.48679467097,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Runecarver Sorn",
    ["id"] = 134150,
    ["count"] = 36,
    ["health"] = 2459184,
    ["scale"] = 1.2,
    ["stealthDetect"] = true,
    ["displayId"] = 84796,
    ["creatureType"] = "Humanoid",
    ["level"] = 121,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [268211] = {
      },
      [268214] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 303.38873562796,
        ["y"] = -136.496809138,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
    },
  },
  [12] = {
    ["name"] = "Guardian Elemental",
    ["id"] = 136249,
    ["count"] = 36,
    ["health"] = 2305485,
    ["scale"] = 1.2,
    ["stealthDetect"] = true,
    ["displayId"] = 65631,
    ["creatureType"] = "Elemental",
    ["level"] = 121,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [268233] = {
      },
      [268239] = {
      },
      [268242] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 269.77202426177,
        ["y"] = -178.40326582333,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Enchanted Emissary",
    ["id"] = 155432,
    ["count"] = 9,
    ["health"] = 15369884,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 39391,
    ["iconTexture"] = 135735,
    ["creatureType"] = "Humanoid",
    ["level"] = 121,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [290027] = {
      },
      [302415] = {
      },
      [303632] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 441.02302432584,
        ["y"] = -146.98517876452,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 334.90611554276,
        ["y"] = -183.71722324079,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [3] = {
        ["x"] = 288.21352340301,
        ["y"] = -298.05104820765,
        ["g"] = 37,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [4] = {
        ["x"] = 207.19004764257,
        ["y"] = -251.49924161924,
        ["g"] = 45,
        ["sublevel"] = 2,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [5] = {
        ["x"] = 421.65808117858,
        ["y"] = -99.337303980722,
        ["g"] = 79,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [3] = true,
          [5] = true,
          [6] = true,
          [8] = true,
          [9] = true,
          [11] = true,
          [12] = true,
        },
      },
      [6] = {
        ["x"] = 346.49972202917,
        ["y"] = -234.95956308365,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [7] = {
        ["x"] = 285.12070097385,
        ["y"] = -159.16606247148,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [8] = {
        ["x"] = 460.46093260814,
        ["y"] = -185.65608107269,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [9] = {
        ["x"] = 378.14977087516,
        ["y"] = -199.0259323507,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [10] = {
        ["x"] = 241.46159384868,
        ["y"] = -199.00336481081,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [11] = {
        ["x"] = 327.69269173714,
        ["y"] = -146.88820603051,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [12] = {
        ["x"] = 250.79577094819,
        ["y"] = -286.62478040698,
        ["g"] = 35,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [13] = {
        ["x"] = 429.48303623861,
        ["y"] = -435.35210902619,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [14] = {
        ["x"] = 530.50143481678,
        ["y"] = -283.77997186582,
        ["sublevel"] = 2,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
    },
  },
  [14] = {
    ["name"] = "Brother Ironhull",
    ["id"] = 134063,
    ["count"] = 0,
    ["health"] = 4034599,
    ["scale"] = 1,
    ["displayId"] = 84679,
    ["creatureType"] = "Humanoid",
    ["level"] = 122,
    ["isBoss"] = true,
    ["encounterID"] = 2154,
    ["instanceID"] = 1036,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [267899] = {
      },
      [267901] = {
      },
      [267905] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 199.0247610797,
        ["y"] = -229.46876711881,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Deepsea Ritualist",
    ["id"] = 134417,
    ["count"] = 12,
    ["health"] = 1690689,
    ["scale"] = 1.2,
    ["displayId"] = 79040,
    ["creatureType"] = "Humanoid",
    ["level"] = 121,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [268309] = {
      },
      [276297] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 253.69950383763,
        ["y"] = -296.30470047151,
        ["g"] = 35,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [2] = {
        ["x"] = 280.66486282689,
        ["y"] = -251.69297841231,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 296.19707806719,
        ["y"] = -299.15553063034,
        ["g"] = 37,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
    },
  },
  [16] = {
    ["name"] = "Dredged Sailor",
    ["id"] = 139626,
    ["count"] = 1,
    ["health"] = 38425,
    ["scale"] = 0.5,
    ["displayId"] = 79406,
    ["creatureType"] = "Undead",
    ["level"] = 120,
    ["reaping"] = 148893,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Root"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [274210] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 254.06583523713,
        ["y"] = -279.25843470389,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 241.80089746268,
        ["y"] = -280.47595777194,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 245.34992509916,
        ["y"] = -286.14726457122,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 245.48627471004,
        ["y"] = -281.04950058913,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 250.11572901289,
        ["y"] = -279.81676639752,
        ["g"] = 35,
        ["sublevel"] = 1,
        ["infested"] = {
        },
      },
      [6] = {
        ["x"] = 255.40003757194,
        ["y"] = -284.13978734233,
        ["g"] = 35,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [7] = {
        ["x"] = 273.84729269171,
        ["y"] = -249.5518024856,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 274.02914449205,
        ["y"] = -255.73362449006,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 270.39277952505,
        ["y"] = -253.91544200656,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 272.39275918937,
        ["y"] = -258.64273050868,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 300.13515781229,
        ["y"] = -291.57325741475,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 296.06778264887,
        ["y"] = -289.40632326674,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 291.69083602438,
        ["y"] = -291.134374781,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 296.82013326486,
        ["y"] = -306.92198380905,
        ["g"] = 37,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [15] = {
        ["x"] = 288.0936263163,
        ["y"] = -306.25584305186,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 291.25586874621,
        ["y"] = -306.84754602931,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 240.94783741623,
        ["y"] = -285.85236143355,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 258.71668934178,
        ["y"] = -281.26234226638,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Tidesage Enforcer",
    ["id"] = 134338,
    ["count"] = 9,
    ["health"] = 768495,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 84817,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [268273] = {
      },
      [268280] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 281.45963495963,
        ["y"] = -312.44706993675,
        ["g"] = 38,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [2] = {
        ["x"] = 286.11479488618,
        ["y"] = -315.8953395635,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 272.62019501559,
        ["y"] = -284.14962386962,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 272.62019501559,
            ["y"] = -284.14962386962,
          },
          [2] = {
            ["x"] = 265.89605703476,
            ["y"] = -271.04617265087,
          },
          [3] = {
            ["x"] = 266.58572131898,
            ["y"] = -257.94272143212,
          },
          [4] = {
            ["x"] = 265.89605703476,
            ["y"] = -271.04617265087,
          },
          [5] = {
            ["x"] = 272.54101239537,
            ["y"] = -283.9695154667,
          },
          [6] = {
            ["x"] = 281.06846411021,
            ["y"] = -293.97721413349,
          },
          [7] = {
            ["x"] = 285.72363883515,
            ["y"] = -307.08065795304,
          },
          [8] = {
            ["x"] = 284.502694188,
            ["y"] = -314.68801418164,
          },
          [9] = {
            ["x"] = 285.72363883515,
            ["y"] = -307.08065795304,
          },
          [10] = {
            ["x"] = 281.06846411021,
            ["y"] = -293.97721413349,
          },
        },
        ["infested"] = {
          [2] = true,
        },
      },
      [4] = {
        ["x"] = 259.50425468112,
        ["y"] = -289.09069538581,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 244.19954180462,
        ["y"] = -293.22457174853,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 282.29656910961,
        ["y"] = -287.13466298025,
        ["g"] = 55,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
      [7] = {
        ["x"] = 277.35655199735,
        ["y"] = -292.14638403617,
        ["g"] = 55,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [18] = {
    ["name"] = "Drowned Depthbringer",
    ["id"] = 134418,
    ["count"] = 9,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 84023,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148893,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [268317] = {
      },
      [268322] = {
      },
      [274212] = {
      },
      [274703] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 274.27664526829,
        ["y"] = -346.27671571553,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 268.44270423189,
        ["y"] = -357.04222279097,
        ["g"] = 39,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [3] = {
        ["x"] = 434.17311389231,
        ["y"] = -430.50492863581,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 418.59170945623,
        ["y"] = -431.90029616199,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 415.80101432512,
        ["y"] = -438.64446275508,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 411.14986908036,
        ["y"] = -432.59794998414,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Abyssal Cultist",
    ["id"] = 134514,
    ["count"] = 9,
    ["health"] = 768494,
    ["scale"] = 1,
    ["displayId"] = 87365,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148893,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [205276] = {
      },
      [268375] = {
      },
      [268391] = {
      },
      [274212] = {
      },
      [276767] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 383.16467150752,
        ["y"] = -420.43514480366,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 390.9512463233,
        ["y"] = -406.25529585723,
        ["g"] = 40,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [3] = {
        ["x"] = 445.56843571047,
        ["y"] = -436.78400266112,
        ["g"] = 41,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 445.56843571047,
            ["y"] = -436.78400266112,
          },
          [2] = {
            ["x"] = 452.13432491989,
            ["y"] = -441.00480423483,
          },
          [3] = {
            ["x"] = 464.60008886079,
            ["y"] = -440.0458993163,
          },
          [4] = {
            ["x"] = 452.13432491989,
            ["y"] = -441.00480423483,
          },
          [5] = {
            ["x"] = 445.56843571047,
            ["y"] = -436.78400266112,
          },
          [6] = {
            ["x"] = 401.67098192503,
            ["y"] = -414.43284253993,
          },
        },
        ["infested"] = {
          [2] = true,
        },
      },
      [4] = {
        ["x"] = 438.8242790977,
        ["y"] = -435.38865509556,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 441.1498716807,
        ["y"] = -430.0398161074,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 423.47545587661,
        ["y"] = -437.94679895262,
        ["g"] = 42,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 423.47545587661,
            ["y"] = -437.94679895262,
          },
          [2] = {
            ["x"] = 450.63105957217,
            ["y"] = -451.11850655221,
          },
          [3] = {
            ["x"] = 456.06582142989,
            ["y"] = -460.90110588437,
          },
          [4] = {
            ["x"] = 450.63105957217,
            ["y"] = -451.11850655221,
          },
          [5] = {
            ["x"] = 423.47545587661,
            ["y"] = -437.94679895262,
          },
          [6] = {
            ["x"] = 403.02234418302,
            ["y"] = -427.85764370225,
          },
        },
        ["infested"] = {
          [2] = true,
        },
      },
    },
  },
  [20] = {
    ["name"] = "Colossal Tentacle",
    ["id"] = 136353,
    ["count"] = 10,
    ["health"] = 845343,
    ["scale"] = 1,
    ["displayId"] = 88530,
    ["creatureType"] = "Aberration",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [268348] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 380.86371722375,
        ["y"] = -406.04780870925,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 377.60286010912,
        ["y"] = -413.65650329833,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Abyss Dweller",
    ["id"] = 134423,
    ["count"] = 1,
    ["health"] = 107589,
    ["scale"] = 0.5,
    ["displayId"] = 88530,
    ["creatureType"] = "Aberration",
    ["level"] = 120,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [205276] = {
      },
      [268315] = {
      },
      [274212] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 211.72333522933,
        ["y"] = -206.34364123709,
        ["g"] = 44,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 208.70007884386,
        ["y"] = -213.08783777112,
        ["g"] = 44,
        ["sublevel"] = 2,
      },
      [3] = {
        ["x"] = 210.32798766378,
        ["y"] = -209.83202013128,
        ["g"] = 44,
        ["sublevel"] = 2,
      },
      [4] = {
        ["x"] = 208.23499625638,
        ["y"] = -216.11107419596,
        ["g"] = 44,
        ["sublevel"] = 2,
      },
      [5] = {
        ["x"] = 217.30472549154,
        ["y"] = -207.04132500018,
        ["g"] = 44,
        ["sublevel"] = 2,
      },
      [6] = {
        ["x"] = 215.44427537789,
        ["y"] = -210.06458138565,
        ["g"] = 44,
        ["sublevel"] = 2,
      },
      [7] = {
        ["x"] = 214.04892781234,
        ["y"] = -213.32037906486,
        ["g"] = 44,
        ["sublevel"] = 2,
      },
      [8] = {
        ["x"] = 212.88616146177,
        ["y"] = -217.73898301588,
        ["g"] = 44,
        ["sublevel"] = 2,
      },
      [9] = {
        ["x"] = 228.46754593722,
        ["y"] = -214.01806282795,
        ["g"] = 44,
        ["sublevel"] = 2,
      },
      [10] = {
        ["x"] = 227.53730091977,
        ["y"] = -218.4366867396,
        ["g"] = 44,
        ["sublevel"] = 2,
      },
      [11] = {
        ["x"] = 224.97916704303,
        ["y"] = -222.39016818189,
        ["g"] = 44,
        ["sublevel"] = 2,
      },
      [12] = {
        ["x"] = 224.0489419862,
        ["y"] = -225.87851713515,
        ["g"] = 44,
        ["sublevel"] = 2,
      },
      [13] = {
        ["x"] = 231.95592483142,
        ["y"] = -216.57619670469,
        ["g"] = 44,
        ["sublevel"] = 2,
      },
      [14] = {
        ["x"] = 231.02565985334,
        ["y"] = -219.59945309016,
        ["g"] = 44,
        ["sublevel"] = 2,
      },
      [15] = {
        ["x"] = 228.70010719159,
        ["y"] = -223.78548580651,
        ["g"] = 44,
        ["sublevel"] = 2,
      },
      [16] = {
        ["x"] = 227.76986217413,
        ["y"] = -227.50643593538,
        ["g"] = 44,
        ["sublevel"] = 2,
        ["infested"] = {
          [1] = true,
        },
      },
      [17] = {
        ["x"] = 198.67887568475,
        ["y"] = -241.93019012427,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
      [18] = {
        ["x"] = 195.98656527138,
        ["y"] = -244.62250053764,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
      [19] = {
        ["x"] = 194.83270380346,
        ["y"] = -248.27636217428,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
      [20] = {
        ["x"] = 194.44811632595,
        ["y"] = -251.1609663264,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
      [21] = {
        ["x"] = 201.94810032618,
        ["y"] = -244.43020679888,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
      [22] = {
        ["x"] = 200.6019451195,
        ["y"] = -245.96865574432,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
      [23] = {
        ["x"] = 198.87118592941,
        ["y"] = -248.85327640235,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
      [24] = {
        ["x"] = 198.67887568475,
        ["y"] = -252.50713803899,
        ["g"] = 45,
        ["sublevel"] = 2,
        ["infested"] = {
          [1] = true,
        },
      },
      [25] = {
        ["x"] = 216.56349735505,
        ["y"] = -251.35327657106,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
      [26] = {
        ["x"] = 215.98656662109,
        ["y"] = -254.8148197101,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
      [27] = {
        ["x"] = 214.83272165906,
        ["y"] = -257.50713012346,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
      [28] = {
        ["x"] = 214.83272165906,
        ["y"] = -260.58405277319,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
      [29] = {
        ["x"] = 220.6019464692,
        ["y"] = -253.46866450341,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
      [30] = {
        ["x"] = 222.7173261486,
        ["y"] = -260.9686732625,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
      [31] = {
        ["x"] = 221.75579143123,
        ["y"] = -257.1225013812,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
      [32] = {
        ["x"] = 219.25579126252,
        ["y"] = -261.73789773522,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
      [33] = {
        ["x"] = 259.98416545974,
        ["y"] = -356.05513891618,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 262.71142511633,
        ["y"] = -351.62332124807,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 256.68870679467,
        ["y"] = -349.23695563752,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 258.73414909874,
        ["y"] = -343.10059458811,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 262.59779701882,
        ["y"] = -337.98696444423,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 265.89325568389,
        ["y"] = -345.94151160267,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 267.71144179293,
        ["y"] = -339.57786997452,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 268.73415319148,
        ["y"] = -349.91878274352,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 271.05483299428,
        ["y"] = -334.40086817373,
        ["g"] = 39,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [22] = {
    ["name"] = "Lord Stormsong",
    ["id"] = 134060,
    ["count"] = 0,
    ["health"] = 5379459,
    ["scale"] = 1,
    ["displayId"] = 85180,
    ["creatureType"] = "Humanoid",
    ["level"] = 122,
    ["isBoss"] = true,
    ["encounterID"] = 2155,
    ["instanceID"] = 1036,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [113746] = {
      },
      [132951] = {
      },
      [268347] = {
      },
      [268896] = {
      },
      [269097] = {
      },
      [269131] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 324.51217627448,
        ["y"] = -293.11832624724,
        ["sublevel"] = 2,
      },
    },
  },
  [23] = {
    ["name"] = "Abyssal Eel",
    ["id"] = 140038,
    ["count"] = 2,
    ["health"] = 307397,
    ["scale"] = 1,
    ["displayId"] = 74319,
    ["creatureType"] = "Beast",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [274720] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 522.80345076547,
        ["y"] = -173.18408006556,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 511.0387634825,
        ["y"] = -174.06641962072,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
      [3] = {
        ["x"] = 498.09758980021,
        ["y"] = -182.5958197942,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
      [4] = {
        ["x"] = 511.33285983801,
        ["y"] = -187.00760592518,
        ["g"] = 46,
        ["sublevel"] = 2,
        ["infested"] = {
          [3] = true,
        },
      },
      [5] = {
        ["x"] = 522.50935440997,
        ["y"] = -178.77228948505,
        ["g"] = 46,
        ["sublevel"] = 2,
        ["infested"] = {
          [1] = true,
          [2] = true,
        },
      },
      [6] = {
        ["x"] = 523.68576507632,
        ["y"] = -191.7134757895,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
      [7] = {
        ["x"] = 509.27403388352,
        ["y"] = -196.41934565382,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
      [8] = {
        ["x"] = 501.62694802089,
        ["y"] = -192.59584058899,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
      [9] = {
        ["x"] = 522.42387512259,
        ["y"] = -230.05609476578,
        ["g"] = 47,
        ["sublevel"] = 2,
      },
      [10] = {
        ["x"] = 513.12154471181,
        ["y"] = -230.28865602014,
        ["g"] = 47,
        ["sublevel"] = 2,
      },
      [11] = {
        ["x"] = 505.91222566905,
        ["y"] = -244.47470291035,
        ["g"] = 47,
        ["sublevel"] = 2,
      },
      [12] = {
        ["x"] = 518.00527117156,
        ["y"] = -241.45144652488,
        ["g"] = 47,
        ["sublevel"] = 2,
        ["infested"] = {
          [1] = true,
          [3] = true,
        },
      },
      [13] = {
        ["x"] = 525.94357150837,
        ["y"] = -238.22683189797,
        ["g"] = 47,
        ["sublevel"] = 2,
      },
      [14] = {
        ["x"] = 514.284331023,
        ["y"] = -251.68399201217,
        ["g"] = 47,
        ["sublevel"] = 2,
      },
      [15] = {
        ["x"] = 530.56339926154,
        ["y"] = -232.61422864252,
        ["g"] = 47,
        ["sublevel"] = 2,
      },
      [16] = {
        ["x"] = 499.86573285874,
        ["y"] = -231.45143235102,
        ["g"] = 47,
        ["sublevel"] = 2,
      },
      [17] = {
        ["x"] = 537.80403579589,
        ["y"] = -253.57567507968,
        ["g"] = 48,
        ["sublevel"] = 2,
      },
      [18] = {
        ["x"] = 548.50173373284,
        ["y"] = -254.0407876081,
        ["g"] = 48,
        ["sublevel"] = 2,
      },
      [19] = {
        ["x"] = 554.08312399505,
        ["y"] = -263.34311801887,
        ["g"] = 48,
        ["sublevel"] = 2,
      },
      [20] = {
        ["x"] = 547.33896738227,
        ["y"] = -268.45940573299,
        ["g"] = 48,
        ["sublevel"] = 2,
      },
      [21] = {
        ["x"] = 541.9901184138,
        ["y"] = -262.6454442361,
        ["g"] = 48,
        ["sublevel"] = 2,
        ["infested"] = {
          [1] = true,
        },
      },
      [22] = {
        ["x"] = 533.38545180549,
        ["y"] = -263.34311801887,
        ["g"] = 48,
        ["sublevel"] = 2,
      },
      [23] = {
        ["x"] = 531.29242047684,
        ["y"] = -271.94777464687,
        ["g"] = 48,
        ["sublevel"] = 2,
      },
      [24] = {
        ["x"] = 540.82729218136,
        ["y"] = -275.90125608917,
        ["g"] = 48,
        ["sublevel"] = 2,
      },
      [25] = {
        ["x"] = 588.34257670304,
        ["y"] = -264.0190377584,
        ["g"] = 49,
        ["sublevel"] = 2,
      },
      [26] = {
        ["x"] = 598.09260051742,
        ["y"] = -259.01903489924,
        ["g"] = 49,
        ["sublevel"] = 2,
      },
      [27] = {
        ["x"] = 611.59258892525,
        ["y"] = -252.26902996648,
        ["g"] = 49,
        ["sublevel"] = 2,
      },
      [28] = {
        ["x"] = 607.09257133163,
        ["y"] = -265.26903310877,
        ["g"] = 49,
        ["sublevel"] = 2,
      },
      [29] = {
        ["x"] = 599.59257777173,
        ["y"] = -281.01905177108,
        ["g"] = 49,
        ["sublevel"] = 2,
        ["infested"] = {
          [1] = true,
          [2] = true,
        },
      },
      [30] = {
        ["x"] = 594.84257827418,
        ["y"] = -271.01904605276,
        ["g"] = 49,
        ["sublevel"] = 2,
      },
      [31] = {
        ["x"] = 606.34260416215,
        ["y"] = -276.01903818308,
        ["g"] = 49,
        ["sublevel"] = 2,
      },
      [32] = {
        ["x"] = 618.59257576194,
        ["y"] = -261.76902896159,
        ["g"] = 49,
        ["sublevel"] = 2,
        ["infested"] = {
        },
      },
    },
  },
  [24] = {
    ["name"] = "Sunken Denizen",
    ["id"] = 136295,
    ["count"] = 13,
    ["health"] = 1229590,
    ["scale"] = 1.2,
    ["displayId"] = 68714,
    ["creatureType"] = "Aberration",
    ["level"] = 121,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [267548] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 562.04302185911,
        ["y"] = -217.8281232719,
        ["g"] = 50,
        ["sublevel"] = 2,
      },
    },
  },
  [25] = {
    ["name"] = "Forgotten Denizen",
    ["id"] = 136297,
    ["count"] = 9,
    ["health"] = 768494,
    ["scale"] = 1,
    ["displayId"] = 68244,
    ["creatureType"] = "Aberration",
    ["level"] = 121,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [267809] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 571.7529858213,
        ["y"] = -216.64837051778,
        ["g"] = 50,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 563.51768200333,
        ["y"] = -207.53075238896,
        ["g"] = 50,
        ["sublevel"] = 2,
      },
    },
  },
  [26] = {
    ["name"] = "Vol'zith the Whisperer",
    ["id"] = 134069,
    ["count"] = 0,
    ["health"] = 4918363,
    ["scale"] = 1,
    ["displayId"] = 84502,
    ["creatureType"] = "Aberration",
    ["level"] = 122,
    ["isBoss"] = true,
    ["encounterID"] = 2156,
    ["instanceID"] = 1036,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [205276] = {
      },
      [267034] = {
      },
      [267299] = {
      },
      [267360] = {
      },
      [267444] = {
      },
      [269399] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 589.81732816991,
        ["y"] = -191.13409884879,
        ["sublevel"] = 2,
      },
    },
  },
  [27] = {
    ["name"] = "Galecaller Faye",
    ["id"] = 134058,
    ["count"] = 0,
    ["health"] = 4034595,
    ["scale"] = 1,
    ["displayId"] = 83273,
    ["creatureType"] = "Humanoid",
    ["level"] = 122,
    ["isBoss"] = true,
    ["encounterID"] = 2154,
    ["instanceID"] = 1036,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [267818] = {
      },
      [267830] = {
      },
      [267841] = {
      },
      [267891] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 199.6913940926,
        ["y"] = -212.42248751286,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
    },
  },
  [28] = {
    ["name"] = "Emissary of the Tides",
    ["id"] = 155434,
    ["count"] = 9,
    ["health"] = 614795,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 39391,
    ["iconTexture"] = 132315,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [302415] = {
      },
      [302417] = {
      },
      [302418] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 414.07284468539,
        ["y"] = -58.264875127202,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
        ["infested"] = {
        },
      },
      [2] = {
        ["x"] = 458.9271564991,
        ["y"] = -187.21658453536,
        ["g"] = 57,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [3] = {
        ["x"] = 241.79309313123,
        ["y"] = -192.08408130241,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [4] = {
        ["x"] = 436.14115446208,
        ["y"] = -116.19949766712,
        ["g"] = 80,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [5] = {
        ["x"] = 400.27856277003,
        ["y"] = -118.78575504259,
        ["g"] = 81,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [6] = {
        ["x"] = 378.01587776818,
        ["y"] = -199.78643402212,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [7] = {
        ["x"] = 288.05349437406,
        ["y"] = -296.02940052848,
        ["g"] = 37,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [8] = {
        ["x"] = 429.91179719099,
        ["y"] = -441.97711024194,
        ["g"] = 42,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [9] = {
        ["x"] = 220.56202432903,
        ["y"] = -216.0057002051,
        ["g"] = 44,
        ["sublevel"] = 2,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [10] = {
        ["x"] = 207.88439709963,
        ["y"] = -251.98796107641,
        ["g"] = 45,
        ["sublevel"] = 2,
        ["week"] = {
          [2] = true,
          [3] = true,
          [5] = true,
          [6] = true,
          [8] = true,
          [9] = true,
          [11] = true,
          [12] = true,
        },
      },
      [11] = {
        ["x"] = 424.33129165555,
        ["y"] = -151.4620218637,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [12] = {
        ["x"] = 285.54196894203,
        ["y"] = -158.38247160855,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
    },
  },
  [29] = {
    ["name"] = "Void-Touched Emissary",
    ["id"] = 155433,
    ["count"] = 9,
    ["health"] = 999042,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 39391,
    ["iconTexture"] = 132886,
    ["creatureType"] = "Humanoid",
    ["level"] = 122,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [302415] = {
      },
      [302419] = {
      },
      [302420] = {
      },
      [302421] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 411.02835221941,
        ["y"] = -154.28379528988,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 393.59059953832,
        ["y"] = -189.87463648294,
        ["g"] = 56,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [3] = {
        ["x"] = 339.57535772991,
        ["y"] = -217.49260873194,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [4] = {
        ["x"] = 284.81297321762,
        ["y"] = -160.27065922359,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [5] = {
        ["x"] = 386.42581832808,
        ["y"] = -413.67296966993,
        ["g"] = 40,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [6] = {
        ["x"] = 566.99061858754,
        ["y"] = -223.83789076086,
        ["g"] = 50,
        ["sublevel"] = 2,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [7] = {
        ["x"] = 444.00423900297,
        ["y"] = -172.36082799716,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [8] = {
        ["x"] = 327.33995472752,
        ["y"] = -148.02851312277,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [9] = {
        ["x"] = 280.456362085,
        ["y"] = -355.15646717786,
        ["g"] = 39,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [10] = {
        ["x"] = 433.35579521398,
        ["y"] = -192.68731577298,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [11] = {
        ["x"] = 333.08160548665,
        ["y"] = -178.47419147275,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [12] = {
        ["x"] = 280.08317587993,
        ["y"] = -320.29158211182,
        ["g"] = 38,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
    },
  },
  [30] = {
    ["name"] = "Samh'rek, Beckoner of Chaos",
    ["id"] = 161243,
    ["count"] = 9,
    ["teemingCount"] = 12,
    ["health"] = 2151786,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 90742,
    ["creatureType"] = "Aberration",
    ["level"] = 122,
    ["corrupted"] = true,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [314397] = {
      },
      [314477] = {
      },
      [314483] = {
      },
      [314531] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 251.24311775575,
        ["y"] = -223.77517289712,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [3] = true,
          [4] = true,
          [5] = true,
          [6] = true,
          [7] = true,
          [8] = true,
          [9] = true,
          [10] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [31] = {
    ["name"] = "Urg'roth, Breaker of Heroes",
    ["id"] = 161124,
    ["count"] = 9,
    ["teemingCount"] = 12,
    ["health"] = 2151786,
    ["scale"] = 1.2,
    ["stealthDetect"] = true,
    ["displayId"] = 89415,
    ["creatureType"] = "Aberration",
    ["level"] = 122,
    ["corrupted"] = true,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [314308] = {
      },
      [314309] = {
      },
      [314387] = {
      },
      [314397] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 347.78223275296,
        ["y"] = -240.07051830855,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [3] = true,
          [4] = true,
          [5] = true,
          [6] = true,
          [7] = true,
          [8] = true,
          [9] = true,
          [10] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [32] = {
    ["name"] = "Voidweaver Mal'thir",
    ["id"] = 161241,
    ["count"] = 9,
    ["teemingCount"] = 12,
    ["health"] = 2151786,
    ["scale"] = 1.2,
    ["stealthDetect"] = true,
    ["displayId"] = 91910,
    ["creatureType"] = "Beast",
    ["level"] = 122,
    ["corrupted"] = true,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [314397] = {
      },
      [314406] = {
      },
      [314411] = {
      },
      [314463] = {
      },
      [314467] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 423.0286759078,
        ["y"] = -98.177785340896,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 362.15060099513,
        ["y"] = -402.43801187838,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [33] = {
    ["name"] = "Blood of the Corruptor",
    ["id"] = 161244,
    ["count"] = 9,
    ["teemingCount"] = 12,
    ["health"] = 2151786,
    ["scale"] = 1.2,
    ["stealthDetect"] = true,
    ["displayId"] = 92229,
    ["creatureType"] = "Aberration",
    ["level"] = 122,
    ["corrupted"] = true,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [314397] = {
      },
      [314565] = {
      },
      [314566] = {
      },
      [314592] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 363.08384542554,
        ["y"] = -401.84324407579,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 423.14294854196,
        ["y"] = -98.218981922135,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
};
