local MDT = MDT
local L = MDT.L
local dungeonIndex = 48
MDT.dungeonList[dungeonIndex] = L["BrackenhideHollow"]
MDT.mapInfo[dungeonIndex] = {
  viewportPositionOverrides = {
  }
};

local zones = { 2096, 2106 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "",
  [1] = { customTextures = 'BrackenhideHollow' },
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["BrackenhideHollow"],
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 723, teeming = 1000, teemingEnabled = true }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 16.985726252635,
      ["y"] = -211.92254510618,
      ["graveyardDescription"] = "",
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCage",
      ["x"] = 42.235569286122,
      ["y"] = -148.66147980926,
      ["cageIndex"] = 1,
      ["textAnchor"] = "RIGHT",
      ["textAnchorTo"] = "LEFT",
    },
    [3] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCage",
      ["x"] = 126.82807502331,
      ["y"] = -197.80800969612,
      ["cageIndex"] = 2,
      ["textAnchor"] = "CENTER",
      ["textAnchorTo"] = "BOTTOM",
    },
    [4] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCage",
      ["x"] = 205.7683928738,
      ["y"] = -229.31582116284,
      ["cageIndex"] = 3,
      ["textAnchor"] = "RIGHT",
      ["textAnchorTo"] = "LEFT",
    },
    [5] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCage",
      ["x"] = 251.57280910073,
      ["y"] = -139.99512947501,
      ["cageIndex"] = 4,
    },
    [6] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCage",
      ["x"] = 230.17715470749,
      ["y"] = -95.841033920673,
      ["cageIndex"] = 5,
    },
    [7] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCage",
      ["x"] = 161.07582704164,
      ["y"] = -113.60696849107,
      ["cageIndex"] = 6,
    },
    [8] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCage",
      ["x"] = 195.0550772337,
      ["y"] = -18.147799835749,
      ["cageIndex"] = 7,
    },
    [9] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 534.04245285223,
      ["y"] = -517.53682311324,
      ["graveyardDescription"] = "",
    },
    [10] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCauldron",
      ["x"] = 180.4793232459,
      ["y"] = -27.619276155185,
    },
    [11] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCauldron",
      ["x"] = 394.75541698158,
      ["y"] = -347.18041008767,
    },
    [12] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCauldron",
      ["x"] = 684.7420177216,
      ["y"] = -442.8435533566,
    },
    [13] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCauldron",
      ["x"] = 722.47488312314,
      ["y"] = -364.44171920595,
    },
    [14] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCauldron",
      ["x"] = 643.15406258509,
      ["y"] = -224.6883944552,
    },
    [15] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCauldron",
      ["x"] = 108.82148036608,
      ["y"] = -189.520032362,
    },
    [16] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCauldron",
      ["x"] = 155.24768300646,
      ["y"] = -106.08739195342,
    },
    [17] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCauldron",
      ["x"] = 204.36529653945,
      ["y"] = -126.94557611833,
    },
    [18] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCauldron",
      ["x"] = 456.88626967948,
      ["y"] = -381.64059917777,
    },
    [19] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCauldron",
      ["x"] = 378.86269714218,
      ["y"] = -216.4852116281,
    },
    [20] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brackenhideCauldron",
      ["x"] = 462.13348989507,
      ["y"] = -320.3265412902,
    },
  },
};

-- [19:19:30] MDT HPTRACK: Missing: Fishface id: 191926
MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Vicious Hyena",
    ["id"] = 185691,
    ["count"] = 3,
    ["health"] = 4699108,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 10270,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [368091] = {
      },
      [384970] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 60.127719520239,
        ["y"] = -185.80891376254,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 136.65628440197,
        ["y"] = -150.13374676459,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 215.38578775358,
        ["y"] = -209.72179049444,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 246.73067776436,
        ["y"] = -211.30419543238,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 248.44312340645,
        ["y"] = -219.32936654468,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 183.27790813351,
        ["y"] = -68.811268940257,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 138.1612174484,
        ["y"] = -40.319569266907,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 161.95256020058,
        ["y"] = -16.095825876018,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 80.289861967233,
        ["y"] = -125.44346517926,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 88.417851196915,
        ["y"] = -124.88684072885,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 92.988796747665,
        ["y"] = -119.29024359961,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 342.02360105828,
        ["y"] = -295.53516570405,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 339.67644893063,
        ["y"] = -310.57581896092,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 544.36862875051,
        ["y"] = -349.37296590367,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 591.64893866664,
        ["y"] = -249.26763726119,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 592.85062209046,
        ["y"] = -267.10178635875,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 599.00810411132,
        ["y"] = -253.48719623231,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 599.10243069516,
        ["y"] = -261.02653933983,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 569.91305717304,
        ["y"] = -193.13610180554,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 588.96454571905,
        ["y"] = -193.66229505245,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 584.3205926619,
        ["y"] = -186.24730774156,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 575.68093649989,
        ["y"] = -185.77153087796,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 503.81248716671,
        ["y"] = -274.08230209037,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 496.3974209985,
        ["y"] = -271.17823054053,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 490.28556082272,
        ["y"] = -276.70799310021,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 497.79270910265,
        ["y"] = -280.77577622355,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 439.76230365715,
        ["y"] = -141.4324087449,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 400.20154763889,
        ["y"] = -149.04863127665,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Bonebolt Hunter",
    ["id"] = 185534,
    ["count"] = 5,
    ["health"] = 5370409,
    ["scale"] = 1,
    ["displayId"] = 105689,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [367521] = {
      },
      [368287] = {
      },
      [368297] = {
      },
      [368299] = {
      },
      [382620] = {
      },
      [387796] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 65.973594691137,
        ["y"] = -192.03957948915,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 130.92758142059,
        ["y"] = -145.35696755828,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 130.92758142059,
            ["y"] = -145.35696755828,
          },
          [2] = {
            ["x"] = 127.78209274948,
            ["y"] = -151.82415859208,
          },
          [3] = {
            ["x"] = 127.163496471,
            ["y"] = -157.59759800707,
          },
          [4] = {
            ["x"] = 126.75111468337,
            ["y"] = -162.5462443505,
          },
          [5] = {
            ["x"] = 126.95732917422,
            ["y"] = -168.52585696153,
          },
          [6] = {
            ["x"] = 126.75111468337,
            ["y"] = -162.5462443505,
          },
          [7] = {
            ["x"] = 127.163496471,
            ["y"] = -157.59759800707,
          },
          [8] = {
            ["x"] = 127.78209274948,
            ["y"] = -151.82415859208,
          },
          [9] = {
            ["x"] = 130.92758142059,
            ["y"] = -145.35696755828,
          },
          [10] = {
            ["x"] = 136.37491637167,
            ["y"] = -142.52859082441,
          },
          [11] = {
            ["x"] = 140.94063136322,
            ["y"] = -141.87635435632,
          },
          [12] = {
            ["x"] = 145.63680857713,
            ["y"] = -143.1808496856,
          },
          [13] = {
            ["x"] = 152.55061964,
            ["y"] = -144.09398820529,
          },
          [14] = {
            ["x"] = 145.63680857713,
            ["y"] = -143.1808496856,
          },
          [15] = {
            ["x"] = 140.94063136322,
            ["y"] = -141.87635435632,
          },
          [16] = {
            ["x"] = 136.37491637167,
            ["y"] = -142.52859082441,
          },
        },
      },
      [3] = {
        ["x"] = 210.56540676903,
        ["y"] = -217.46597788598,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 255.62621657905,
        ["y"] = -210.09665593115,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 256.09323422131,
        ["y"] = -217.98280270524,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 210.2462435164,
        ["y"] = -132.21416389449,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 204.99737126475,
        ["y"] = -135.40957053913,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 189.28773120418,
        ["y"] = -75.386824906341,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 118.50074861002,
        ["y"] = -99.410684378538,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 112.16689600302,
        ["y"] = -83.237832533299,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 134.64209355348,
        ["y"] = -33.416086801918,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 134.64209355348,
            ["y"] = -33.416086801918,
          },
          [2] = {
            ["x"] = 140.5593289471,
            ["y"] = -31.43407940357,
          },
          [3] = {
            ["x"] = 145.35334553835,
            ["y"] = -31.205796631409,
          },
          [4] = {
            ["x"] = 148.32102157644,
            ["y"] = -33.945216022631,
          },
          [5] = {
            ["x"] = 145.35334553835,
            ["y"] = -39.195824283492,
          },
          [6] = {
            ["x"] = 142.61384777126,
            ["y"] = -45.816116114676,
          },
          [7] = {
            ["x"] = 137.13500898882,
            ["y"] = -52.208138236343,
          },
          [8] = {
            ["x"] = 131.88440072795,
            ["y"] = -46.729273328609,
          },
          [9] = {
            ["x"] = 128.91669856457,
            ["y"] = -42.848413951292,
          },
          [10] = {
            ["x"] = 119.55697427952,
            ["y"] = -42.163526446876,
          },
          [11] = {
            ["x"] = 112.93666938569,
            ["y"] = -42.848413951292,
          },
          [12] = {
            ["x"] = 119.32866538207,
            ["y"] = -38.054384297398,
          },
          [13] = {
            ["x"] = 125.03583918725,
            ["y"] = -34.401794629598,
          },
        },
      },
      [12] = {
        ["x"] = 159.00767662087,
        ["y"] = -8.1514107171744,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 84.768908335786,
        ["y"] = -117.95172772382,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 337.35315410521,
        ["y"] = -302.20320697027,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 537.60227841821,
        ["y"] = -346.72936298386,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 554.91084836825,
        ["y"] = -302.04348282946,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 590.479085516,
        ["y"] = -257.73970404436,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 522.14672656766,
        ["y"] = -226.33230947182,
        ["g"] = 77,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 514.96536940211,
        ["y"] = -229.45307223157,
        ["g"] = 77,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 444.34526519347,
        ["y"] = -166.59437968658,
        ["g"] = 67,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 406.25118853648,
        ["y"] = -143.64248310622,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 392.36110325475,
        ["y"] = -186.77917155263,
        ["g"] = 65,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 392.36110325475,
            ["y"] = -186.77917155263,
          },
          [2] = {
            ["x"] = 386.87491108969,
            ["y"] = -190.58264656032,
          },
          [3] = {
            ["x"] = 383.90718280102,
            ["y"] = -194.00692733067,
          },
          [4] = {
            ["x"] = 381.16773728451,
            ["y"] = -196.74635978454,
          },
          [5] = {
            ["x"] = 383.90718280102,
            ["y"] = -194.00692733067,
          },
          [6] = {
            ["x"] = 386.87491108969,
            ["y"] = -190.58264656032,
          },
          [7] = {
            ["x"] = 392.36110325475,
            ["y"] = -186.77917155263,
          },
          [8] = {
            ["x"] = 396.46297039748,
            ["y"] = -182.13602723863,
          },
          [9] = {
            ["x"] = 404.22466302682,
            ["y"] = -178.48346369612,
          },
          [10] = {
            ["x"] = 396.46297039748,
            ["y"] = -182.13602723863,
          },
        },
      },
    },
  },
  [3] = {
    ["name"] = "Cruel Bonecrusher",
    ["id"] = 186206,
    ["count"] = 5,
    ["health"] = 7384312,
    ["scale"] = 1,
    ["displayId"] = 105688,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [382593] = {
      },
      [382723] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 40.008215922995,
        ["y"] = -179.59060572484,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 84.737787705253,
        ["y"] = -179.9307178954,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 98.206234520035,
        ["y"] = -139.34213637065,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 105.77916047271,
        ["y"] = -148.50471830937,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 162.06996811859,
        ["y"] = -188.04188749951,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 204.95007250299,
        ["y"] = -166.73248666793,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 242.58131031456,
        ["y"] = -142.44154174636,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 263.28123091135,
        ["y"] = -163.6003254667,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 268.65969211555,
        ["y"] = -171.25528040478,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 229.86042885522,
        ["y"] = -78.518474212669,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 191.24220174932,
        ["y"] = -134.96289042626,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 191.88143011399,
            ["y"] = -134.55163595614,
          },
          [2] = {
            ["x"] = 185.13844968541,
            ["y"] = -134.43410915131,
          },
          [3] = {
            ["x"] = 181.71415585241,
            ["y"] = -132.15126836706,
          },
          [4] = {
            ["x"] = 179.65958477768,
            ["y"] = -128.95524424358,
          },
          [5] = {
            ["x"] = 181.71415585241,
            ["y"] = -132.15126836706,
          },
          [6] = {
            ["x"] = 185.13844968541,
            ["y"] = -134.43410915131,
          },
          [7] = {
            ["x"] = 191.88143011399,
            ["y"] = -134.71143390346,
          },
          [8] = {
            ["x"] = 196.50783907692,
            ["y"] = -138.6802746164,
          },
          [9] = {
            ["x"] = 200.50286091063,
            ["y"] = -142.35568226778,
          },
          [10] = {
            ["x"] = 196.50783907692,
            ["y"] = -138.6802746164,
          },
        },
      },
      [12] = {
        ["x"] = 122.5403338838,
        ["y"] = -88.469007413792,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 142.38282614748,
        ["y"] = -64.748498869716,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 456.40689186759,
        ["y"] = -232.3730197434,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 159.25779582161,
        ["y"] = -159.56774788432,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Claw Fighter",
    ["id"] = 185508,
    ["count"] = 5,
    ["health"] = 6041710,
    ["scale"] = 1,
    ["displayId"] = 105631,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [367481] = {
      },
      [367484] = {
      },
      [367485] = {
      },
      [384150] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 45.146877159212,
        ["y"] = -139.1287660775,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 51.536178012847,
        ["y"] = -145.00263123078,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 51.923386896163,
        ["y"] = -153.25029905194,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 102.08819800118,
        ["y"] = -183.15970723408,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 102.35391772881,
        ["y"] = -173.30909973379,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 128.25239118959,
        ["y"] = -187.53668846536,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 136.60757389069,
        ["y"] = -190.13736969737,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 165.40686606611,
        ["y"] = -194.93751444024,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 166.09330920027,
        ["y"] = -179.88821792981,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 218.28511512107,
        ["y"] = -216.32146746288,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 279.1204736701,
        ["y"] = -154.93993394803,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 282.46058726165,
        ["y"] = -162.53647614884,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 196.64521365269,
        ["y"] = -97.43879146845,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 198.13397656171,
        ["y"] = -119.42963857606,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 178.49784332181,
        ["y"] = -124.27050727478,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 137.2316486621,
        ["y"] = -93.627581719767,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 142.35435690029,
        ["y"] = -104.66703703211,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 135.19174216918,
        ["y"] = -59.991181388429,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 149.19832327475,
        ["y"] = -59.047268746308,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 166.76764540279,
        ["y"] = -9.3650180668635,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 123.96525429268,
        ["y"] = -24.891765600578,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 123.96525429268,
            ["y"] = -24.891765600578,
          },
          [2] = {
            ["x"] = 130.93236744124,
            ["y"] = -20.887232289615,
          },
          [3] = {
            ["x"] = 137.09610679074,
            ["y"] = -19.74581842881,
          },
          [4] = {
            ["x"] = 139.83552618196,
            ["y"] = -17.919543188876,
          },
          [5] = {
            ["x"] = 137.09610679074,
            ["y"] = -19.74581842881,
          },
          [6] = {
            ["x"] = 130.93236744124,
            ["y"] = -20.887232289615,
          },
          [7] = {
            ["x"] = 123.96525429268,
            ["y"] = -24.891765600578,
          },
          [8] = {
            ["x"] = 115.88227486398,
            ["y"] = -28.225112212857,
          },
          [9] = {
            ["x"] = 108.59835933004,
            ["y"] = -34.765789980961,
          },
          [10] = {
            ["x"] = 115.88227486398,
            ["y"] = -28.225112212857,
          },
        },
      },
      [22] = {
        ["x"] = 101.37920796546,
        ["y"] = -34.39829700971,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 348.72020239049,
        ["y"] = -303.13332599547,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 173.81465976822,
        ["y"] = -166.48739625354,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 151.96336810307,
        ["y"] = -159.1310746346,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Bracken Warscourge",
    ["id"] = 185529,
    ["count"] = 15,
    ["health"] = 10740817,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 105677,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [367481] = {
      },
      [367500] = {
      },
      [367510] = {
      },
      [367511] = {
      },
      [382555] = {
      },
      [382556] = {
      },
      [387796] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 61.641732405299,
        ["y"] = -141.1544225796,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 129.58693462296,
        ["y"] = -178.5657356073,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 172.26028517651,
        ["y"] = -188.62150737432,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 219.30941351321,
        ["y"] = -142.62321306499,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 272.68796855966,
        ["y"] = -162.41675592897,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 252.00111386279,
        ["y"] = -201.2405853577,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 204.28126333376,
        ["y"] = -71.158784140702,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 204.38606084393,
            ["y"] = -71.158784140702,
          },
          [2] = {
            ["x"] = 211.26136997144,
            ["y"] = -75.883752404992,
          },
          [3] = {
            ["x"] = 215.01319542616,
            ["y"] = -76.300624550352,
          },
          [4] = {
            ["x"] = 219.59878107395,
            ["y"] = -76.300624550352,
          },
          [5] = {
            ["x"] = 223.62851599146,
            ["y"] = -78.246022594583,
          },
          [6] = {
            ["x"] = 219.59878107395,
            ["y"] = -76.300624550352,
          },
          [7] = {
            ["x"] = 215.01319542616,
            ["y"] = -76.300624550352,
          },
          [8] = {
            ["x"] = 211.26136997144,
            ["y"] = -75.883752404992,
          },
          [9] = {
            ["x"] = 204.38606084393,
            ["y"] = -71.158784140702,
          },
          [10] = {
            ["x"] = 202.28610050674,
            ["y"] = -62.99484434325,
          },
          [11] = {
            ["x"] = 203.96269278235,
            ["y"] = -59.956022342694,
          },
          [12] = {
            ["x"] = 205.6392970499,
            ["y"] = -57.545913451542,
          },
          [13] = {
            ["x"] = 205.86993013525,
            ["y"] = -53.133376838211,
          },
          [14] = {
            ["x"] = 205.6392970499,
            ["y"] = -57.545913451542,
          },
          [15] = {
            ["x"] = 203.96269278235,
            ["y"] = -59.956022342694,
          },
          [16] = {
            ["x"] = 202.28610050674,
            ["y"] = -62.99484434325,
          },
        },
      },
      [8] = {
        ["x"] = 204.80650566378,
        ["y"] = -45.872438150479,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 173.46113460905,
        ["y"] = -148.60967598257,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 173.46113460905,
            ["y"] = -148.60967598257,
          },
          [2] = {
            ["x"] = 177.59588432623,
            ["y"] = -156.72547838079,
          },
          [3] = {
            ["x"] = 180.03987457572,
            ["y"] = -161.42548817849,
          },
          [4] = {
            ["x"] = 189.81590011852,
            ["y"] = -161.23748520479,
          },
          [5] = {
            ["x"] = 201.65994223584,
            ["y"] = -160.67349241989,
          },
          [6] = {
            ["x"] = 209.36792968919,
            ["y"] = -162.17748393709,
          },
          [7] = {
            ["x"] = 215.94795308769,
            ["y"] = -165.18549924389,
          },
          [8] = {
            ["x"] = 218.57998396204,
            ["y"] = -165.37350221759,
          },
          [9] = {
            ["x"] = 215.94795308769,
            ["y"] = -165.18549924389,
          },
          [10] = {
            ["x"] = 209.36792968919,
            ["y"] = -162.17748393709,
          },
          [11] = {
            ["x"] = 201.65994223584,
            ["y"] = -160.67349241989,
          },
          [12] = {
            ["x"] = 189.81590011852,
            ["y"] = -161.23748520479,
          },
          [13] = {
            ["x"] = 180.03987457572,
            ["y"] = -161.42548817849,
          },
          [14] = {
            ["x"] = 177.59588432623,
            ["y"] = -156.72547838079,
          },
          [15] = {
            ["x"] = 173.46113460905,
            ["y"] = -148.60967598257,
          },
          [16] = {
            ["x"] = 164.24781841931,
            ["y"] = -143.18944177258,
          },
          [17] = {
            ["x"] = 153.15580971175,
            ["y"] = -139.24142773348,
          },
          [18] = {
            ["x"] = 146.76380542315,
            ["y"] = -136.79742672652,
          },
          [19] = {
            ["x"] = 140.18378202465,
            ["y"] = -133.78942217718,
          },
          [20] = {
            ["x"] = 146.76380542315,
            ["y"] = -136.79742672652,
          },
          [21] = {
            ["x"] = 153.15580971175,
            ["y"] = -139.24142773348,
          },
          [22] = {
            ["x"] = 164.24781841931,
            ["y"] = -143.18944177258,
          },
        },
      },
      [10] = {
        ["x"] = 145.68915096728,
        ["y"] = -97.492256903899,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 103.37414962034,
        ["y"] = -62.622882540379,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 91.321899330667,
        ["y"] = -39.02682899205,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 581.27583482993,
        ["y"] = -317.28394656039,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 482.99915577217,
        ["y"] = -237.22075290225,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 482.99915577217,
            ["y"] = -237.22075290225,
          },
          [2] = {
            ["x"] = 483.07552985388,
            ["y"] = -229.06843384883,
          },
          [3] = {
            ["x"] = 483.48793523855,
            ["y"] = -222.67640995387,
          },
          [4] = {
            ["x"] = 482.86931536303,
            ["y"] = -217.31537592355,
          },
          [5] = {
            ["x"] = 483.48793523855,
            ["y"] = -222.67640995387,
          },
          [6] = {
            ["x"] = 483.07552985388,
            ["y"] = -229.06843384883,
          },
          [7] = {
            ["x"] = 482.99915577217,
            ["y"] = -237.22075290225,
          },
          [8] = {
            ["x"] = 483.28174434473,
            ["y"] = -244.94536864302,
          },
          [9] = {
            ["x"] = 484.93127149526,
            ["y"] = -250.71880805801,
          },
          [10] = {
            ["x"] = 483.28174434473,
            ["y"] = -244.94536864302,
          },
        },
      },
      [15] = {
        ["x"] = 668.03525110689,
        ["y"] = -206.74554621136,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 668.03525110689,
            ["y"] = -206.74554621136,
          },
          [2] = {
            ["x"] = 666.66243604484,
            ["y"] = -216.28503853387,
          },
          [3] = {
            ["x"] = 663.56952544353,
            ["y"] = -223.2956469088,
          },
          [4] = {
            ["x"] = 658.82706409466,
            ["y"] = -227.41950018067,
          },
          [5] = {
            ["x"] = 647.89878154316,
            ["y"] = -229.4814563129,
          },
          [6] = {
            ["x"] = 638.00145346074,
            ["y"] = -224.73899496403,
          },
          [7] = {
            ["x"] = 630.99084508582,
            ["y"] = -214.22310599868,
          },
          [8] = {
            ["x"] = 629.9598670197,
            ["y"] = -202.88241806251,
          },
          [9] = {
            ["x"] = 631.81565585515,
            ["y"] = -191.12937193575,
          },
          [10] = {
            ["x"] = 636.76428450081,
            ["y"] = -184.94355073313,
          },
          [11] = {
            ["x"] = 643.56867838488,
            ["y"] = -183.29398818705,
          },
          [12] = {
            ["x"] = 653.87841185196,
            ["y"] = -187.21169775918,
          },
          [13] = {
            ["x"] = 662.53854737741,
            ["y"] = -192.16033820335,
          },
        },
      },
      [16] = {
        ["x"] = 661.97625633867,
        ["y"] = -267.77181248324,
        ["g"] = 84,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 662.89697779082,
        ["y"] = -431.90298043067,
        ["g"] = 91,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 691.84267337474,
        ["y"] = -375.4495682429,
        ["g"] = 93,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 702.38914547091,
        ["y"] = -376.74482455787,
        ["g"] = 93,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 702.08031769149,
        ["y"] = -303.15785712727,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 702.08031769149,
            ["y"] = -303.15785712727,
          },
          [2] = {
            ["x"] = 709.49456676113,
            ["y"] = -300.7915408415,
          },
          [3] = {
            ["x"] = 719.08259994363,
            ["y"] = -292.57325654255,
          },
          [4] = {
            ["x"] = 723.64830763743,
            ["y"] = -286.86609580001,
          },
          [5] = {
            ["x"] = 719.08259994363,
            ["y"] = -292.57325654255,
          },
          [6] = {
            ["x"] = 709.49456676113,
            ["y"] = -300.7915408415,
          },
          [7] = {
            ["x"] = 702.08031769149,
            ["y"] = -303.15785712727,
          },
          [8] = {
            ["x"] = 692.37309759616,
            ["y"] = -305.81385326756,
          },
          [9] = {
            ["x"] = 687.35077210746,
            ["y"] = -307.18356296317,
          },
          [10] = {
            ["x"] = 683.92653052504,
            ["y"] = -299.6501269807,
          },
          [11] = {
            ["x"] = 683.24162995798,
            ["y"] = -287.55095717914,
          },
          [12] = {
            ["x"] = 683.24162995798,
            ["y"] = -280.24579090618,
          },
          [13] = {
            ["x"] = 683.24162995798,
            ["y"] = -287.55095717914,
          },
          [14] = {
            ["x"] = 683.92653052504,
            ["y"] = -299.6501269807,
          },
          [15] = {
            ["x"] = 687.35077210746,
            ["y"] = -307.18356296317,
          },
          [16] = {
            ["x"] = 692.37309759616,
            ["y"] = -305.81385326756,
          },
        },
      },
      [21] = {
        ["x"] = 723.60222401103,
        ["y"] = -225.58543421422,
        ["g"] = 87,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 723.60222401103,
            ["y"] = -225.58543421422,
          },
          [2] = {
            ["x"] = 714.94723516627,
            ["y"] = -226.17309125909,
          },
          [3] = {
            ["x"] = 709.11922407125,
            ["y"] = -227.67711494323,
          },
          [4] = {
            ["x"] = 709.72082915583,
            ["y"] = -233.95642131443,
          },
          [5] = {
            ["x"] = 709.11922407125,
            ["y"] = -227.67711494323,
          },
          [6] = {
            ["x"] = 714.94723516627,
            ["y"] = -226.17309125909,
          },
          [7] = {
            ["x"] = 723.60222401103,
            ["y"] = -225.58543421422,
          },
          [8] = {
            ["x"] = 733.22091414759,
            ["y"] = -224.5564346506,
          },
          [9] = {
            ["x"] = 740.74090347865,
            ["y"] = -232.07644549661,
          },
          [10] = {
            ["x"] = 746.00494334327,
            ["y"] = -235.46042348363,
          },
          [11] = {
            ["x"] = 740.74090347865,
            ["y"] = -232.07644549661,
          },
          [12] = {
            ["x"] = 733.22091414759,
            ["y"] = -224.5564346506,
          },
        },
      },
      [24] = {
        ["x"] = 95.836876322477,
        ["y"] = -149.88178845308,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 95.836876322477,
            ["y"] = -149.88178845308,
          },
          [2] = {
            ["x"] = 83.870074045881,
            ["y"] = -155.05350079806,
          },
          [3] = {
            ["x"] = 74.022926451816,
            ["y"] = -156.09003796759,
          },
          [4] = {
            ["x"] = 67.630889575831,
            ["y"] = -157.47209905974,
          },
          [5] = {
            ["x"] = 74.022926451816,
            ["y"] = -156.09003796759,
          },
          [6] = {
            ["x"] = 83.870074045881,
            ["y"] = -155.05350079806,
          },
          [7] = {
            ["x"] = 95.836876322477,
            ["y"] = -149.88178845308,
          },
          [8] = {
            ["x"] = 103.21886013925,
            ["y"] = -140.8874203228,
          },
          [9] = {
            ["x"] = 107.01951949307,
            ["y"] = -134.4954032173,
          },
          [10] = {
            ["x"] = 114.10257455857,
            ["y"] = -132.42231899301,
          },
          [11] = {
            ["x"] = 124.81351466003,
            ["y"] = -131.38577193824,
          },
          [12] = {
            ["x"] = 130.86002267076,
            ["y"] = -130.34922488348,
          },
          [13] = {
            ["x"] = 133.45138042244,
            ["y"] = -123.4389342506,
          },
          [14] = {
            ["x"] = 131.72379540766,
            ["y"] = -116.87417248297,
          },
          [15] = {
            ["x"] = 128.44141946647,
            ["y"] = -106.50873159103,
          },
          [16] = {
            ["x"] = 131.72379540766,
            ["y"] = -116.87417248297,
          },
          [17] = {
            ["x"] = 133.45138042244,
            ["y"] = -123.4389342506,
          },
          [18] = {
            ["x"] = 130.86002267076,
            ["y"] = -130.34922488348,
          },
          [19] = {
            ["x"] = 124.81351466003,
            ["y"] = -131.38577193824,
          },
          [20] = {
            ["x"] = 114.10257455857,
            ["y"] = -132.42231899301,
          },
          [21] = {
            ["x"] = 107.01951949307,
            ["y"] = -134.4954032173,
          },
          [22] = {
            ["x"] = 103.21886013925,
            ["y"] = -140.8874203228,
          },
        },
      },
    },
  },
  [6] = {
    ["name"] = "Trickclaw Mystic",
    ["id"] = 185528,
    ["count"] = 5,
    ["health"] = 5706059,
    ["scale"] = 1,
    ["displayId"] = 105636,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [376800] = {
      },
      [382249] = {
      },
      [382410] = {
      },
      [382412] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 96.028623753043,
        ["y"] = -178.40447241805,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 119.81159701456,
        ["y"] = -190.99339064784,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 179.82573513013,
        ["y"] = -169.70807007975,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 214.73164867369,
        ["y"] = -223.64266225036,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 210.53023915888,
        ["y"] = -174.09255603936,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 244.87918695374,
        ["y"] = -131.69176250537,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 234.36880328296,
        ["y"] = -140.56932064449,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 205.19213221564,
        ["y"] = -96.617965852312,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 227.42869437233,
        ["y"] = -86.380749349096,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 236.41960885905,
        ["y"] = -87.66386077989,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 162.8456600814,
        ["y"] = -66.779053007561,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 181.92114664158,
        ["y"] = -77.322270340907,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 155.10606324293,
        ["y"] = -92.835115815773,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 204.92439762901,
        ["y"] = -35.474153212912,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 147.60407091032,
        ["y"] = -121.57872233096,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 155.63483516654,
        ["y"] = -122.49288446323,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 124.02667893721,
        ["y"] = -67.618709021887,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 156.19072840593,
        ["y"] = -38.260050458605,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 153.67229711573,
        ["y"] = -30.389260272677,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 161.43841850155,
        ["y"] = -32.536513850402,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 144.94557050468,
        ["y"] = -16.396963064916,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 98.659145927163,
        ["y"] = -46.925917603351,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 185.7327153464,
        ["y"] = -19.874744960929,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 354.82139531775,
        ["y"] = -311.5912482771,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Bracken Warscourge",
    ["id"] = 195135,
    ["count"] = 15,
    ["health"] = 10740817,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 105677,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [367481] = {
      },
      [367500] = {
      },
      [367510] = {
      },
      [367511] = {
      },
      [382555] = {
      },
      [382556] = {
      },
    },
    ["clones"] = {
      [17] = {
        ["x"] = 495.20044684002,
        ["y"] = -170.44896131859,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Decay Speaker",
    ["id"] = 186191,
    ["count"] = 15,
    ["health"] = 8055613,
    ["scale"] = 1,
    ["displayId"] = 105637,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [367503] = {
      },
      [367504] = {
      },
      [368081] = {
      },
      [382435] = {
      },
      [382474] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 118.90713540561,
        ["y"] = -181.72116930852,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 204.14019166876,
        ["y"] = -174.52072976332,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 236.81601502418,
        ["y"] = -132.8546559791,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 213.19493486052,
        ["y"] = -65.813950213914,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 168.75922310488,
        ["y"] = -83.563292269827,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 152.42076593161,
        ["y"] = -115.06759486105,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 105.0377432547,
        ["y"] = -42.129735587603,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 190.54635492347,
        ["y"] = -26.220577527997,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 347.5494971106,
        ["y"] = -312.88373250944,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Fishface",
    ["id"] = 191926,
    ["count"] = 30,
    ["health"] = 1716607,
    ["scale"] = 1.6,
    ["displayId"] = 107685,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["clones"] = {
      [1] = {
        ["x"] = 91.91231609477,
        ["y"] = -13.988632851424,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Gashtooth",
    ["id"] = 186124,
    ["count"] = 0,
    ["health"] = 24090980,
    ["scale"] = 1,
    ["displayId"] = 105695,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2471,
    ["instanceID"] = 1196,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [377996] = {
      },
      [378020] = {
      },
      [378029] = {
      },
      [378208] = {
      },
      [378229] = {
      },
      [378230] = {
      },
      [378235] = {
      },
      [381379] = {
      },
      [381387] = {
      },
      [381694] = {
      },
      [389788] = {
      },
      [389808] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 320.67906713662,
        ["y"] = -195.33706595864,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Rira Hackclaw",
    ["id"] = 186122,
    ["count"] = 0,
    ["health"] = 24090980,
    ["scale"] = 1,
    ["displayId"] = 105696,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2471,
    ["instanceID"] = 1196,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [377807] = {
      },
      [377830] = {
      },
      [377844] = {
      },
      [381416] = {
      },
      [381419] = {
      },
      [381444] = {
      },
      [381461] = {
      },
      [381834] = {
      },
      [381835] = {
      },
      [389788] = {
      },
      [389808] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 333.24187328503,
        ["y"] = -211.71498567822,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Tricktotem",
    ["id"] = 186125,
    ["count"] = 0,
    ["health"] = 24090980,
    ["scale"] = 1,
    ["displayId"] = 105697,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2471,
    ["instanceID"] = 1196,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [377950] = {
      },
      [377965] = {
      },
      [378155] = {
      },
      [381470] = {
      },
      [389788] = {
      },
      [389808] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 314.12783546711,
        ["y"] = -215.22318032233,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Decaying Slime",
    ["id"] = 189299,
    ["count"] = 1,
    ["health"] = 1342602,
    ["scale"] = 0.6,
    ["displayId"] = 104893,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [375614] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 396.64684494387,
        ["y"] = -258.07271679494,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 391.93754475611,
        ["y"] = -259.67601864977,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 394.7619021573,
        ["y"] = -263.36121903944,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 398.76463651772,
        ["y"] = -262.07411850852,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 442.84577683039,
        ["y"] = -306.64327028726,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 453.82476754173,
        ["y"] = -317.90792087701,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 447.92189033097,
        ["y"] = -315.52035399704,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 460.66142386896,
        ["y"] = -348.80165192398,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 456.99269892553,
        ["y"] = -353.61166895683,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 445.51147140982,
        ["y"] = -371.6766822443,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 440.99888721701,
        ["y"] = -374.77714149752,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 435.9473230438,
        ["y"] = -375.60081670158,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 501.15937762987,
        ["y"] = -382.11633315697,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 496.07155910679,
        ["y"] = -383.61476244161,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 497.89907986924,
        ["y"] = -379.23012656107,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 356.35207044625,
        ["y"] = -355.05071011236,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 363.86522117457,
        ["y"] = -357.20891392429,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 423.23149169986,
        ["y"] = -358.54756022676,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 427.85084359298,
        ["y"] = -356.00080917607,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 458.39942309769,
        ["y"] = -540.51973343846,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 462.84883984051,
        ["y"] = -544.63928568903,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Brackenhide Shaper",
    ["id"] = 186220,
    ["count"] = 5,
    ["health"] = 4296324,
    ["scale"] = 1,
    ["displayId"] = 105700,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [368081] = {
      },
      [372711] = {
      },
      [373024] = {
      },
      [373698] = {
      },
      [373804] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 391.09625366362,
        ["y"] = -267.88931653301,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 385.17221261668,
        ["y"] = -261.31934403112,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 375.02754068079,
        ["y"] = -290.18030992564,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 432.22290514287,
        ["y"] = -322.89545068095,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 426.22131656175,
        ["y"] = -331.80949972198,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 440.46486171148,
        ["y"] = -347.13544579553,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 453.00068635337,
        ["y"] = -334.02941547312,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 456.36633505178,
        ["y"] = -304.63452419847,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 457.66720456835,
        ["y"] = -312.48667343562,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 359.93604247168,
        ["y"] = -348.09904201228,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 368.48572041749,
        ["y"] = -351.07814142195,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 374.31387081608,
        ["y"] = -415.40415831619,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 443.89922823409,
        ["y"] = -396.66075057758,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 451.0635573548,
        ["y"] = -395.83132045848,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 458.40625968558,
        ["y"] = -532.57467299138,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 468.73805617721,
        ["y"] = -532.02629357765,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 480.65441427491,
        ["y"] = -514.02223079961,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 477.41627348749,
        ["y"] = -522.70044810989,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 526.474234133,
        ["y"] = -373.89325233558,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 504.48713047031,
        ["y"] = -349.91325569323,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 505.53117182679,
        ["y"] = -340.83488497222,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 513.01625700514,
        ["y"] = -342.72696526405,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Decayed Elder",
    ["id"] = 189531,
    ["count"] = 5,
    ["health"] = 6713011,
    ["scale"] = 1.4,
    ["displayId"] = 107352,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [373024] = {
      },
      [373897] = {
      },
      [373899] = {
      },
      [383062] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 382.08394130362,
        ["y"] = -282.20620746498,
        ["g"] = 32,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 382.08394130362,
            ["y"] = -282.20620746498,
          },
          [2] = {
            ["x"] = 387.53444327463,
            ["y"] = -286.35568587842,
          },
          [3] = {
            ["x"] = 389.79045728591,
            ["y"] = -289.17568187757,
          },
          [4] = {
            ["x"] = 395.24249473231,
            ["y"] = -293.3116932216,
          },
          [5] = {
            ["x"] = 389.79045728591,
            ["y"] = -289.17568187757,
          },
          [6] = {
            ["x"] = 387.53444327463,
            ["y"] = -286.35568587842,
          },
          [7] = {
            ["x"] = 382.08394130362,
            ["y"] = -282.20620746498,
          },
          [8] = {
            ["x"] = 374.56243801211,
            ["y"] = -276.57967177861,
          },
          [9] = {
            ["x"] = 370.80244334658,
            ["y"] = -267.55563724846,
          },
          [10] = {
            ["x"] = 374.56243801211,
            ["y"] = -276.57967177861,
          },
        },
      },
      [2] = {
        ["x"] = 415.30764386312,
        ["y"] = -275.92974208661,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 446.08628449518,
        ["y"] = -339.73574029167,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 468.96071229757,
        ["y"] = -351.3184655331,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 462.03968985062,
        ["y"] = -359.47920251796,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 485.32312196489,
        ["y"] = -426.3307813286,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 503.47627290184,
        ["y"] = -427.83758744836,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 331.6133191614,
        ["y"] = -336.27101248685,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 341.11244195466,
        ["y"] = -334.15453840863,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 358.69517110502,
        ["y"] = -364.40822481844,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 368.24693601542,
        ["y"] = -408.17904688078,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 378.71618320324,
        ["y"] = -406.73552895513,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 448.23964927969,
        ["y"] = -387.22936713091,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Fetid Rotsinger",
    ["id"] = 186226,
    ["count"] = 15,
    ["health"] = 9398215,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 105699,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [367510] = {
      },
      [367511] = {
      },
      [374544] = {
      },
      [375065] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 422.18636443409,
        ["y"] = -322.98859284488,
        ["g"] = 40,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 422.18636443409,
            ["y"] = -322.98859284488,
          },
          [2] = {
            ["x"] = 413.46960501622,
            ["y"] = -317.12025894971,
          },
          [3] = {
            ["x"] = 405.86832633937,
            ["y"] = -313.31958995555,
          },
          [4] = {
            ["x"] = 402.93143991169,
            ["y"] = -310.03720434062,
          },
          [5] = {
            ["x"] = 405.86832633937,
            ["y"] = -313.31958995555,
          },
          [6] = {
            ["x"] = 413.46960501622,
            ["y"] = -317.12025894971,
          },
          [7] = {
            ["x"] = 422.18636443409,
            ["y"] = -322.98859284488,
          },
          [8] = {
            ["x"] = 430.74533542783,
            ["y"] = -328.6949908127,
          },
          [9] = {
            ["x"] = 434.54601430724,
            ["y"] = -331.80461200614,
          },
          [10] = {
            ["x"] = 430.74533542783,
            ["y"] = -328.6949908127,
          },
        },
      },
      [2] = {
        ["x"] = 486.35287863216,
        ["y"] = -324.56837056299,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 486.35287863216,
            ["y"] = -324.19237537306,
          },
          [2] = {
            ["x"] = 490.4915255892,
            ["y"] = -332.78662813699,
          },
          [3] = {
            ["x"] = 489.73951369439,
            ["y"] = -340.30665026779,
          },
          [4] = {
            ["x"] = 480.7155000464,
            ["y"] = -343.12664646469,
          },
          [5] = {
            ["x"] = 470.93945298865,
            ["y"] = -340.87063229522,
          },
          [6] = {
            ["x"] = 463.23144402035,
            ["y"] = -335.23062914395,
          },
          [7] = {
            ["x"] = 461.35144655575,
            ["y"] = -324.89060005878,
          },
          [8] = {
            ["x"] = 464.73546780996,
            ["y"] = -319.06258855508,
          },
          [9] = {
            ["x"] = 472.25545766835,
            ["y"] = -317.55858628042,
          },
        },
      },
      [3] = {
        ["x"] = 495.16565252198,
        ["y"] = -421.11611884314,
        ["g"] = 50,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 493.88735680061,
            ["y"] = -424.18426850906,
          },
          [2] = {
            ["x"] = 493.65509195107,
            ["y"] = -413.65096345561,
          },
          [3] = {
            ["x"] = 495.02476245874,
            ["y"] = -403.83466056359,
          },
          [4] = {
            ["x"] = 493.65509195107,
            ["y"] = -413.65096345561,
          },
          [5] = {
            ["x"] = 493.88735680061,
            ["y"] = -424.18426850906,
          },
          [6] = {
            ["x"] = 492.74193473713,
            ["y"] = -433.51186507445,
          },
          [7] = {
            ["x"] = 494.11165749539,
            ["y"] = -437.84930305873,
          },
          [8] = {
            ["x"] = 492.74193473713,
            ["y"] = -433.51186507445,
          },
        },
      },
      [4] = {
        ["x"] = 370.37260414298,
        ["y"] = -398.41288544555,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 619.62896520275,
        ["y"] = -243.1306182523,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 676.23811783499,
        ["y"] = -402.24161081792,
        ["g"] = 92,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Wilted Oak",
    ["id"] = 186229,
    ["count"] = 20,
    ["health"] = 13426021,
    ["scale"] = 1.6,
    ["stealthDetect"] = true,
    ["displayId"] = 54677,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [373936] = {
      },
      [373943] = {
      },
      [375259] = {
      },
      [382712] = {
      },
      [382805] = {
      },
      [383062] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 379.66746975896,
        ["y"] = -328.58307537676,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 379.66746975896,
            ["y"] = -328.58307537676,
          },
          [2] = {
            ["x"] = 372.79527818241,
            ["y"] = -338.02461306407,
          },
          [3] = {
            ["x"] = 369.85841152522,
            ["y"] = -341.82527217299,
          },
          [4] = {
            ["x"] = 372.79527818241,
            ["y"] = -338.02461306407,
          },
          [5] = {
            ["x"] = 379.66746975896,
            ["y"] = -328.58307537676,
          },
          [6] = {
            ["x"] = 380.2238220935,
            ["y"] = -319.36684636248,
          },
          [7] = {
            ["x"] = 380.74208570225,
            ["y"] = -311.42000918691,
          },
          [8] = {
            ["x"] = 380.2238220935,
            ["y"] = -319.36684636248,
          },
        },
      },
      [2] = {
        ["x"] = 497.92211971964,
        ["y"] = -392.60706796992,
        ["g"] = 49,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 498.61941975137,
            ["y"] = -392.37463462601,
          },
          [2] = {
            ["x"] = 490.20264584766,
            ["y"] = -385.93508028741,
          },
          [3] = {
            ["x"] = 487.29720244851,
            ["y"] = -380.24037026062,
          },
          [4] = {
            ["x"] = 496.71087257813,
            ["y"] = -374.42945021195,
          },
          [5] = {
            ["x"] = 504.49749600024,
            ["y"] = -375.7078469036,
          },
          [6] = {
            ["x"] = 506.93811261201,
            ["y"] = -376.63760022945,
          },
          [7] = {
            ["x"] = 507.63542594388,
            ["y"] = -386.51616364718,
          },
          [8] = {
            ["x"] = 507.63542594388,
            ["y"] = -392.67575366193,
          },
          [9] = {
            ["x"] = 506.47323262405,
            ["y"] = -397.55692038474,
          },
        },
      },
      [3] = {
        ["x"] = 404.60339980635,
        ["y"] = -394.72124548678,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 404.60339980635,
            ["y"] = -394.72124548678,
          },
          [2] = {
            ["x"] = 394.34501634157,
            ["y"] = -393.30651113378,
          },
          [3] = {
            ["x"] = 386.09349963134,
            ["y"] = -393.07406448973,
          },
          [4] = {
            ["x"] = 381.09610293643,
            ["y"] = -390.28482446239,
          },
          [5] = {
            ["x"] = 373.07703287026,
            ["y"] = -383.54415773794,
          },
          [6] = {
            ["x"] = 381.09610293643,
            ["y"] = -390.28482446239,
          },
          [7] = {
            ["x"] = 386.09349963134,
            ["y"] = -393.07406448973,
          },
          [8] = {
            ["x"] = 394.34501634157,
            ["y"] = -393.30651113378,
          },
          [9] = {
            ["x"] = 404.60339980635,
            ["y"] = -394.72124548678,
          },
          [10] = {
            ["x"] = 415.03190315295,
            ["y"] = -392.26054113598,
          },
          [11] = {
            ["x"] = 422.00499657124,
            ["y"] = -394.70113114746,
          },
          [12] = {
            ["x"] = 425.95642991841,
            ["y"] = -397.95524451269,
          },
          [13] = {
            ["x"] = 422.00499657124,
            ["y"] = -394.70113114746,
          },
          [14] = {
            ["x"] = 415.03190315295,
            ["y"] = -392.26054113598,
          },
        },
      },
      [4] = {
        ["x"] = 500.91367273547,
        ["y"] = -465.47284145984,
        ["g"] = 52,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 500.68538996331,
            ["y"] = -464.55969730855,
          },
          [2] = {
            ["x"] = 503.6996645526,
            ["y"] = -475.51653522167,
          },
          [3] = {
            ["x"] = 504.15625622221,
            ["y"] = -480.99540012941,
          },
          [4] = {
            ["x"] = 507.35226728304,
            ["y"] = -499.48659205263,
          },
          [5] = {
            ["x"] = 504.15625622221,
            ["y"] = -480.99540012941,
          },
          [6] = {
            ["x"] = 503.6996645526,
            ["y"] = -475.51653522167,
          },
          [7] = {
            ["x"] = 500.68538996331,
            ["y"] = -464.55969730855,
          },
          [8] = {
            ["x"] = 496.85107688661,
            ["y"] = -454.05762807242,
          },
        },
      },
      [5] = {
        ["x"] = 510.64110293522,
        ["y"] = -462.15376949831,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Monstrous Decay",
    ["id"] = 186227,
    ["count"] = 15,
    ["health"] = 8726915,
    ["scale"] = 1,
    ["displayId"] = 71690,
    ["creatureType"] = "Aberration",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [373872] = {
      },
      [374569] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 439.83520114642,
        ["y"] = -366.82558750396,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 439.27120836153,
            ["y"] = -369.08158015849,
          },
          [2] = {
            ["x"] = 443.30337622987,
            ["y"] = -363.24270109266,
          },
          [3] = {
            ["x"] = 449.13140924851,
            ["y"] = -360.04667743342,
          },
          [4] = {
            ["x"] = 450.63543303813,
            ["y"] = -354.40666352469,
          },
          [5] = {
            ["x"] = 449.13140924851,
            ["y"] = -360.04667743342,
          },
          [6] = {
            ["x"] = 443.30337622987,
            ["y"] = -363.24270109266,
          },
          [7] = {
            ["x"] = 439.27120836153,
            ["y"] = -369.08158015849,
          },
          [8] = {
            ["x"] = 431.08336043757,
            ["y"] = -372.64272068806,
          },
          [9] = {
            ["x"] = 422.81133716944,
            ["y"] = -372.07870638822,
          },
          [10] = {
            ["x"] = 431.08336043757,
            ["y"] = -372.64272068806,
          },
        },
      },
      [2] = {
        ["x"] = 449.08741238525,
        ["y"] = -308.14976212574,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 464.81857833483,
        ["y"] = -538.11244191097,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 472.23524822762,
        ["y"] = -515.05843585158,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 612.38848542583,
        ["y"] = -249.30418979961,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Infected Lasher",
    ["id"] = 189363,
    ["count"] = 1,
    ["health"] = 939822,
    ["scale"] = 0.6,
    ["displayId"] = 81391,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [372113] = {
      },
      [375416] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 482.3350824031,
        ["y"] = -376.55943469812,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 506.24905664615,
        ["y"] = -370.72429186732,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 512.32433276239,
        ["y"] = -377.21033506295,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 511.99961709712,
        ["y"] = -400.94635450295,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 506.43001494276,
        ["y"] = -402.63018771241,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 477.09512178615,
        ["y"] = -392.00642896147,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 475.07772409314,
        ["y"] = -396.15478320797,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 480.52221837507,
        ["y"] = -396.11485632935,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 361.36130766641,
        ["y"] = -326.46911639232,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 358.77079503647,
        ["y"] = -330.74346223172,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 363.43371777036,
        ["y"] = -332.16824417818,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 324.88975324324,
        ["y"] = -330.01616545022,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 323.90915186551,
        ["y"] = -335.74666027533,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 325.72892311751,
        ["y"] = -340.90322828025,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 347.78686415602,
        ["y"] = -328.28202846622,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 349.47083325801,
        ["y"] = -333.19783761241,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 348.67573159777,
        ["y"] = -337.84842370075,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 372.72869500937,
        ["y"] = -388.77929788716,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 365.4620038254,
        ["y"] = -388.329829004,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 387.41520789559,
        ["y"] = -405.31357056288,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 387.91468432379,
        ["y"] = -411.95634428046,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 384.17763847678,
        ["y"] = -417.45202612032,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 416.22736907541,
        ["y"] = -386.40959020247,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 432.62845631849,
        ["y"] = -394.25010839277,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 434.9430846624,
        ["y"] = -398.4978562633,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 437.49720777734,
        ["y"] = -394.4461721719,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 434.69867644269,
        ["y"] = -388.12209684919,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 438.45945014136,
        ["y"] = -388.4594010411,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 499.80950515896,
        ["y"] = -444.60785355311,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 494.62847989909,
        ["y"] = -447.60636339525,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 495.01859889416,
        ["y"] = -442.91109088202,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 504.13893631184,
        ["y"] = -488.82624351412,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 508.48929069511,
        ["y"] = -491.1140069286,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 504.55828169717,
        ["y"] = -493.8032766992,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 509.19534550781,
        ["y"] = -485.92652346925,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 512.05138719419,
        ["y"] = -489.64552049836,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 512.22453240228,
        ["y"] = -494.02509474055,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 377.87924500947,
        ["y"] = -420.77083112854,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Treemouth",
    ["id"] = 186120,
    ["count"] = 0,
    ["health"] = 42159216,
    ["scale"] = 1.2,
    ["displayId"] = 106294,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2473,
    ["instanceID"] = 1196,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [376231] = {
      },
      [376797] = {
      },
      [376811] = {
      },
      [376933] = {
      },
      [376934] = {
      },
      [377184] = {
      },
      [377242] = {
      },
      [377559] = {
      },
      [377859] = {
      },
      [377864] = {
      },
      [378022] = {
      },
      [378764] = {
      },
      [383875] = {
      },
      [390968] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 552.80019101859,
        ["y"] = -493.16860412863,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Stinkbreath",
    ["id"] = 187033,
    ["count"] = 25,
    ["health"] = 16111226,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 106038,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [385185] = {
      },
      [385186] = {
      },
      [385805] = {
      },
      [388046] = {
      },
      [388060] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 561.39422752371,
        ["y"] = -399.26254415312,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 561.39422752371,
            ["y"] = -399.26254415312,
          },
          [2] = {
            ["x"] = 560.43880065357,
            ["y"] = -408.27048771292,
          },
          [3] = {
            ["x"] = 560.06282697858,
            ["y"] = -413.34650883676,
          },
          [4] = {
            ["x"] = 559.49881267874,
            ["y"] = -416.73051933349,
          },
          [5] = {
            ["x"] = 559.31083659872,
            ["y"] = -422.93452602712,
          },
          [6] = {
            ["x"] = 559.49881267874,
            ["y"] = -416.73051933349,
          },
          [7] = {
            ["x"] = 560.06282697858,
            ["y"] = -413.34650883676,
          },
          [8] = {
            ["x"] = 560.43880065357,
            ["y"] = -408.27048771292,
          },
          [9] = {
            ["x"] = 561.39422752371,
            ["y"] = -399.26254415312,
          },
          [10] = {
            ["x"] = 560.62679824853,
            ["y"] = -389.65843535961,
          },
          [11] = {
            ["x"] = 561.37881014334,
            ["y"] = -380.25842652168,
          },
          [12] = {
            ["x"] = 562.31881963311,
            ["y"] = -371.23440211621,
          },
          [13] = {
            ["x"] = 561.37881014334,
            ["y"] = -380.25842652168,
          },
          [14] = {
            ["x"] = 560.62679824853,
            ["y"] = -389.65843535961,
          },
        },
      },
    },
  },
  [22] = {
    ["name"] = "Skulking Gutstabber",
    ["id"] = 186242,
    ["count"] = 4,
    ["health"] = 6041710,
    ["scale"] = 1,
    ["stealth"] = true,
    ["displayId"] = 105704,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [367481] = {
      },
      [384930] = {
      },
      [385039] = {
      },
      [385046] = {
      },
      [385058] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 559.29262510629,
        ["y"] = -361.87123129988,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 567.45279434168,
        ["y"] = -362.48067278318,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 553.64804969092,
        ["y"] = -326.55659510859,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 554.7127744573,
        ["y"] = -333.38093558791,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 404.97123003947,
        ["y"] = -172.90789425311,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 575.5832228804,
        ["y"] = -308.23772093792,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 576.3600675322,
        ["y"] = -324.50256111073,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 498.95540116936,
        ["y"] = -233.60596683345,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 498.88808921669,
        ["y"] = -225.49755252202,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 499.6731563711,
        ["y"] = -216.20920061132,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 410.32744203323,
        ["y"] = -179.4430743768,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
    },
  },
  [23] = {
    ["name"] = "Infected Bear",
    ["id"] = 189318,
    ["count"] = 0,
    ["health"] = 10740817,
    ["scale"] = 1,
    ["displayId"] = 68523,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["clones"] = {
      [1] = {
        ["x"] = 532.25506982825,
        ["y"] = -368.56389058457,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
    },
  },
  [24] = {
    ["name"] = "Rageclaw",
    ["id"] = 187192,
    ["count"] = 30,
    ["health"] = 16111226,
    ["scale"] = 1.7,
    ["stealthDetect"] = true,
    ["displayId"] = 105554,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [385824] = {
      },
      [385827] = {
      },
      [385832] = {
      },
      [385833] = {
      },
      [385834] = {
      },
      [397099] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 538.43416844608,
        ["y"] = -317.01566362072,
        ["sublevel"] = 1,
      },
    },
  },
  [25] = {
    ["name"] = "Rotbow Ranger",
    ["id"] = 186208,
    ["count"] = 15,
    ["health"] = 8726915,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 105690,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [367510] = {
      },
      [367511] = {
      },
      [367521] = {
      },
      [382620] = {
      },
      [384899] = {
      },
      [384961] = {
      },
      [384974] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 556.68595996349,
        ["y"] = -292.90904837304,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 579.18361373881,
        ["y"] = -196.43814471393,
        ["g"] = 62,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 571.1936383373,
            ["y"] = -210.36356363013,
          },
          [2] = {
            ["x"] = 569.14277533652,
            ["y"] = -220.67926778348,
          },
          [3] = {
            ["x"] = 568.22964424788,
            ["y"] = -227.52786851211,
          },
          [4] = {
            ["x"] = 565.94676427569,
            ["y"] = -232.32187204072,
          },
          [5] = {
            ["x"] = 562.5224704427,
            ["y"] = -238.48561139023,
          },
          [6] = {
            ["x"] = 560.92443878699,
            ["y"] = -240.99674800929,
          },
          [7] = {
            ["x"] = 562.5224704427,
            ["y"] = -238.48561139023,
          },
          [8] = {
            ["x"] = 565.94676427569,
            ["y"] = -232.32187204072,
          },
          [9] = {
            ["x"] = 568.22964424788,
            ["y"] = -227.52786851211,
          },
          [10] = {
            ["x"] = 569.14277533652,
            ["y"] = -220.67926778348,
          },
          [11] = {
            ["x"] = 571.1936383373,
            ["y"] = -210.36356363013,
          },
          [12] = {
            ["x"] = 570.96908976439,
            ["y"] = -201.04666199945,
          },
          [13] = {
            ["x"] = 571.42565530871,
            ["y"] = -195.33950125691,
          },
          [14] = {
            ["x"] = 571.65393808087,
            ["y"] = -185.97977697186,
          },
          [15] = {
            ["x"] = 571.42565530871,
            ["y"] = -195.33950125691,
          },
          [16] = {
            ["x"] = 570.96908976439,
            ["y"] = -201.04666199945,
          },
        },
      },
      [3] = {
        ["x"] = 522.21434209781,
        ["y"] = -246.74669148258,
        ["g"] = 76,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 522.21434209781,
            ["y"] = -246.74669148258,
          },
          [2] = {
            ["x"] = 531.04055975127,
            ["y"] = -242.60182078694,
          },
          [3] = {
            ["x"] = 539.49450438291,
            ["y"] = -237.85935943806,
          },
          [4] = {
            ["x"] = 547.74228171776,
            ["y"] = -228.99302122028,
          },
          [5] = {
            ["x"] = 539.49450438291,
            ["y"] = -237.85935943806,
          },
          [6] = {
            ["x"] = 531.04055975127,
            ["y"] = -242.60182078694,
          },
          [7] = {
            ["x"] = 522.21434209781,
            ["y"] = -246.74669148258,
          },
          [8] = {
            ["x"] = 506.9158240252,
            ["y"] = -253.9425087231,
          },
          [9] = {
            ["x"] = 497.01851953981,
            ["y"] = -256.62303753678,
          },
          [10] = {
            ["x"] = 487.94600222673,
            ["y"] = -257.24162201675,
          },
          [11] = {
            ["x"] = 497.01851953981,
            ["y"] = -256.62303753678,
          },
          [12] = {
            ["x"] = 506.9158240252,
            ["y"] = -253.9425087231,
          },
        },
      },
      [4] = {
        ["x"] = 475.03321324902,
        ["y"] = -136.12397640694,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 433.38191474201,
        ["y"] = -149.77391000064,
        ["g"] = 69,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 433.38191474201,
            ["y"] = -149.77391000064,
          },
          [2] = {
            ["x"] = 420.01289810999,
            ["y"] = -153.77145278359,
          },
          [3] = {
            ["x"] = 417.33234569927,
            ["y"] = -156.03956441408,
          },
          [4] = {
            ["x"] = 413.62086241651,
            ["y"] = -160.57584666766,
          },
          [5] = {
            ["x"] = 410.32178451842,
            ["y"] = -170.26694846071,
          },
          [6] = {
            ["x"] = 413.62086241651,
            ["y"] = -160.57584666766,
          },
          [7] = {
            ["x"] = 417.33234569927,
            ["y"] = -156.03956441408,
          },
          [8] = {
            ["x"] = 420.01289810999,
            ["y"] = -153.77145278359,
          },
          [9] = {
            ["x"] = 433.38191474201,
            ["y"] = -149.77391000064,
          },
          [10] = {
            ["x"] = 448.67383350002,
            ["y"] = -147.37942888863,
          },
          [11] = {
            ["x"] = 464.55079189124,
            ["y"] = -150.26612499909,
          },
          [12] = {
            ["x"] = 448.67383350002,
            ["y"] = -147.37942888863,
          },
        },
      },
      [6] = {
        ["x"] = 461.18442374685,
        ["y"] = -258.0575973957,
        ["g"] = 74,
        ["sublevel"] = 1,
      },
    },
  },
  [26] = {
    ["name"] = "Fleshripper Vulture",
    ["id"] = 186246,
    ["count"] = 3,
    ["health"] = 4027806,
    ["scale"] = 1,
    ["displayId"] = 10827,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [384970] = {
      },
      [385029] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 513.03622469961,
        ["y"] = -249.84264150963,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 515.65137049128,
        ["y"] = -258.08668887202,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 442.9444458098,
        ["y"] = -151.316161746,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 437.55488384135,
        ["y"] = -172.68638699757,
        ["g"] = 67,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 397.12953207404,
        ["y"] = -193.43333725826,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 600.42444723875,
        ["y"] = -147.163652251,
        ["g"] = 63,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 591.52131462332,
            ["y"] = -159.49113095002,
          },
          [2] = {
            ["x"] = 583.37239139192,
            ["y"] = -161.74355330809,
          },
          [3] = {
            ["x"] = 564.65289057124,
            ["y"] = -164.25471605244,
          },
          [4] = {
            ["x"] = 550.72740634181,
            ["y"] = -160.60211332199,
          },
          [5] = {
            ["x"] = 533.60598942742,
            ["y"] = -162.42842774986,
          },
          [6] = {
            ["x"] = 527.44222395262,
            ["y"] = -171.78816509756,
          },
          [7] = {
            ["x"] = 528.35535504127,
            ["y"] = -185.25704459473,
          },
          [8] = {
            ["x"] = 533.83427219958,
            ["y"] = -192.33392809552,
          },
          [9] = {
            ["x"] = 547.75970417843,
            ["y"] = -194.61676887978,
          },
          [10] = {
            ["x"] = 556.20627124955,
            ["y"] = -187.08333289731,
          },
          [11] = {
            ["x"] = 563.51145058515,
            ["y"] = -177.95189138442,
          },
          [12] = {
            ["x"] = 576.29549482848,
            ["y"] = -173.38617062797,
          },
          [13] = {
            ["x"] = 584.28547022999,
            ["y"] = -181.60445492693,
          },
          [14] = {
            ["x"] = 595.01494339858,
            ["y"] = -189.13793009733,
          },
          [15] = {
            ["x"] = 606.88583042798,
            ["y"] = -181.83273769909,
          },
          [16] = {
            ["x"] = 612.13643868884,
            ["y"] = -173.61446646278,
          },
          [17] = {
            ["x"] = 609.16871040017,
            ["y"] = -162.20011885241,
          },
          [18] = {
            ["x"] = 600.49380830631,
            ["y"] = -158.31925947509,
          },
        },
      },
      [7] = {
        ["x"] = 601.47101361582,
        ["y"] = -155.65548349395,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
    },
  },
  [27] = {
    ["name"] = "Gutchewer Bear",
    ["id"] = 186284,
    ["count"] = 6,
    ["health"] = 7384312,
    ["scale"] = 1.4,
    ["displayId"] = 11908,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [372151] = {
      },
      [384970] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 525.60265815991,
        ["y"] = -256.00649363628,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 450.11268393738,
        ["y"] = -256.0181501628,
        ["g"] = 74,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 454.40871866371,
        ["y"] = -266.77875493621,
        ["g"] = 74,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 458.70939214663,
        ["y"] = -222.61809568849,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 574.29162671188,
        ["y"] = -158.27027576511,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 573.37849562324,
            ["y"] = -160.3248337772,
          },
          [2] = {
            ["x"] = 572.0854421272,
            ["y"] = -170.09860962008,
          },
          [3] = {
            ["x"] = 572.0854421272,
            ["y"] = -172.38148959227,
          },
          [4] = {
            ["x"] = 571.62885045759,
            ["y"] = -176.71891451391,
          },
          [5] = {
            ["x"] = 571.40056768543,
            ["y"] = -179.23006419562,
          },
          [6] = {
            ["x"] = 571.62885045759,
            ["y"] = -176.71891451391,
          },
          [7] = {
            ["x"] = 572.0854421272,
            ["y"] = -172.38148959227,
          },
          [8] = {
            ["x"] = 572.0854421272,
            ["y"] = -170.09860962008,
          },
          [9] = {
            ["x"] = 573.37849562324,
            ["y"] = -160.3248337772,
          },
          [10] = {
            ["x"] = 573.68344765762,
            ["y"] = -152.52060103608,
          },
          [11] = {
            ["x"] = 573.45513876017,
            ["y"] = -145.6719872448,
          },
          [12] = {
            ["x"] = 573.22688211329,
            ["y"] = -139.96483956491,
          },
          [13] = {
            ["x"] = 573.45513876017,
            ["y"] = -145.6719872448,
          },
          [14] = {
            ["x"] = 573.68344765762,
            ["y"] = -152.52060103608,
          },
        },
      },
      [6] = {
        ["x"] = 468.84729765826,
        ["y"] = -129.32542361636,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
    },
  },
  [28] = {
    ["name"] = "Gutshot",
    ["id"] = 186116,
    ["count"] = 0,
    ["health"] = 37474858,
    ["scale"] = 1.2,
    ["displayId"] = 109135,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2472,
    ["instanceID"] = 1196,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [382620] = {
      },
      [383974] = {
      },
      [383979] = {
      },
      [384343] = {
      },
      [384353] = {
      },
      [384416] = {
      },
      [384425] = {
      },
      [384633] = {
      },
      [384638] = {
      },
      [384827] = {
      },
      [385356] = {
      },
      [385359] = {
      },
      [387889] = {
      },
      [387890] = {
      },
      [396124] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 552.61998969734,
        ["y"] = -101.63395538954,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
    },
  },
  [29] = {
    ["name"] = "Rotfang Hyena",
    ["id"] = 194745,
    ["count"] = 0,
    ["health"] = 5370409,
    ["scale"] = 1,
    ["displayId"] = 109883,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [384148] = {
      },
      [384529] = {
      },
      [384531] = {
      },
      [384558] = {
      },
      [384575] = {
      },
      [384577] = {
      },
      [384725] = {
      },
      [384764] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 566.24065360854,
        ["y"] = -95.971085787759,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 566.15802028056,
        ["y"] = -105.76103136342,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
    },
  },
  [30] = {
    ["name"] = "Gutstabber",
    ["id"] = 197857,
    ["count"] = 0,
    ["health"] = 6041710,
    ["scale"] = 1,
    ["displayId"] = 105704,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [367481] = {
      },
      [384930] = {
      },
      [385039] = {
      },
      [385046] = {
      },
      [385058] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 500.98959080962,
        ["y"] = -161.41123438837,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 492.32710165099,
        ["y"] = -159.9202411513,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 484.85414806896,
        ["y"] = -165.59843739669,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 487.96273962785,
        ["y"] = -179.44441326741,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 496.60147108741,
        ["y"] = -179.91769513779,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 503.24951951196,
        ["y"] = -174.75763681395,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
    },
  },
  [31] = {
    ["name"] = "Wither Biter",
    ["id"] = 187231,
    ["count"] = 1,
    ["health"] = 2013904,
    ["scale"] = 0.6,
    ["displayId"] = 106070,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [367481] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 608.14662714498,
        ["y"] = -128.33200539822,
        ["g"] = 78,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 614.62941263856,
        ["y"] = -123.40357973317,
        ["g"] = 78,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 618.9906620661,
        ["y"] = -197.39824948364,
        ["g"] = 80,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 620.72212865888,
        ["y"] = -202.86740507958,
        ["g"] = 80,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 622.9136104226,
        ["y"] = -207.95316357281,
        ["g"] = 80,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 623.59837079762,
        ["y"] = -198.52729687796,
        ["g"] = 80,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 659.24844931596,
        ["y"] = -257.63708684889,
        ["g"] = 84,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 664.60003630008,
        ["y"] = -258.30510977635,
        ["g"] = 84,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 668.82722839303,
        ["y"] = -261.81814243706,
        ["g"] = 84,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 624.29833960479,
        ["y"] = -475.68264387657,
        ["g"] = 89,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 611.86387898111,
        ["y"] = -467.00442656629,
        ["g"] = 89,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 628.31363418119,
        ["y"] = -458.19668362451,
        ["g"] = 90,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 622.48498076384,
        ["y"] = -454.5699659426,
        ["g"] = 90,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 662.63792652783,
        ["y"] = -440.45167210946,
        ["g"] = 91,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 656.16164495299,
        ["y"] = -436.95448005904,
        ["g"] = 91,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 668.72563120817,
        ["y"] = -406.64548228881,
        ["g"] = 92,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 679.21720735941,
        ["y"] = -410.01314870772,
        ["g"] = 92,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 698.28653066546,
        ["y"] = -365.56726739853,
        ["g"] = 93,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 660.67280217384,
        ["y"] = -182.15119695576,
        ["g"] = 81,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 662.62348744292,
        ["y"] = -177.40910183814,
        ["g"] = 81,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 665.3943689135,
        ["y"] = -183.53292772302,
        ["g"] = 81,
        ["sublevel"] = 1,
      },
    },
  },
  [32] = {
    ["name"] = "Filth Caller",
    ["id"] = 185656,
    ["count"] = 5,
    ["health"] = 6041710,
    ["scale"] = 1,
    ["displayId"] = 108447,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [382474] = {
      },
      [383385] = {
      },
      [383392] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 614.51017053955,
        ["y"] = -131.90445521822,
        ["g"] = 78,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 666.30906894658,
        ["y"] = -237.17523182007,
        ["g"] = 83,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 658.02240972814,
        ["y"] = -241.57542003146,
        ["g"] = 83,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 701.08104786733,
        ["y"] = -269.00872260514,
        ["g"] = 85,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 715.06377006627,
        ["y"] = -243.06879747781,
        ["g"] = 86,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 617.69253239846,
        ["y"] = -471.53782366867,
        ["g"] = 89,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 631.03367244262,
        ["y"] = -452.10897894416,
        ["g"] = 90,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 654.60733737503,
        ["y"] = -427.62863459128,
        ["g"] = 91,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 670.15041315464,
        ["y"] = -436.43637753306,
        ["g"] = 91,
        ["sublevel"] = 1,
      },
    },
  },
  [33] = {
    ["name"] = "Witherling",
    ["id"] = 187238,
    ["count"] = 1,
    ["health"] = 1342602,
    ["scale"] = 0.6,
    ["displayId"] = 106071,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [367481] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 635.82884930756,
        ["y"] = -167.00549233963,
        ["g"] = 79,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 630.02437184278,
        ["y"] = -168.34041351758,
        ["g"] = 79,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 626.19106071655,
        ["y"] = -172.14272763577,
        ["g"] = 79,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 630.92124968776,
        ["y"] = -174.62860986963,
        ["g"] = 79,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 635.18949783279,
        ["y"] = -172.23971286796,
        ["g"] = 79,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 694.43300118448,
        ["y"] = -268.05088710545,
        ["g"] = 85,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 689.76872837642,
        ["y"] = -271.55075655868,
        ["g"] = 85,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 695.07563854753,
        ["y"] = -274.0948343537,
        ["g"] = 85,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 692.26904962089,
        ["y"] = -263.43351659935,
        ["g"] = 85,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 697.59717057818,
        ["y"] = -262.62106546457,
        ["g"] = 85,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 707.48268805691,
        ["y"] = -236.45523501826,
        ["g"] = 86,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 704.84992958563,
        ["y"] = -245.07875033246,
        ["g"] = 86,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 712.68937477343,
        ["y"] = -237.93643932802,
        ["g"] = 86,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 708.37196063203,
        ["y"] = -241.40750159004,
        ["g"] = 86,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 709.83331394611,
        ["y"] = -246.67598840365,
        ["g"] = 86,
        ["sublevel"] = 1,
      },
    },
  },
  [34] = {
    ["name"] = "Vile Rothexer",
    ["id"] = 187224,
    ["count"] = 15,
    ["health"] = 9398215,
    ["scale"] = 1,
    ["displayId"] = 106068,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [382802] = {
      },
      [382883] = {
      },
      [382891] = {
      },
      [383087] = {
      },
    },
    ["clones"] = {
      [2] = {
        ["x"] = 645.62290794385,
        ["y"] = -201.1330415371,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 653.06397989124,
        ["y"] = -205.40738737649,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 643.73813442348,
        ["y"] = -210.07031011037,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 651.72109019295,
        ["y"] = -212.28795040042,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 708.58748035045,
        ["y"] = -258.7900659868,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 708.58748035045,
            ["y"] = -258.7900659868,
          },
          [2] = {
            ["x"] = 713.05459490863,
            ["y"] = -261.61890468942,
          },
          [3] = {
            ["x"] = 716.43857289565,
            ["y"] = -263.68692111891,
          },
          [4] = {
            ["x"] = 724.52261951689,
            ["y"] = -269.51493221394,
          },
          [5] = {
            ["x"] = 716.43857289565,
            ["y"] = -263.68692111891,
          },
          [6] = {
            ["x"] = 713.05459490863,
            ["y"] = -261.61890468942,
          },
          [7] = {
            ["x"] = 708.58748035045,
            ["y"] = -258.7900659868,
          },
          [8] = {
            ["x"] = 698.76656354374,
            ["y"] = -255.03886023739,
          },
          [9] = {
            ["x"] = 694.2545355212,
            ["y"] = -253.91088550417,
          },
          [10] = {
            ["x"] = 685.23052250599,
            ["y"] = -255.03886023739,
          },
          [11] = {
            ["x"] = 675.64247371555,
            ["y"] = -254.85088417055,
          },
          [12] = {
            ["x"] = 685.23052250599,
            ["y"] = -255.03886023739,
          },
          [13] = {
            ["x"] = 694.2545355212,
            ["y"] = -253.91088550417,
          },
          [14] = {
            ["x"] = 698.76656354374,
            ["y"] = -255.03886023739,
          },
        },
      },
    },
  },
  [35] = {
    ["name"] = "Disease Slasher",
    ["id"] = 187315,
    ["count"] = 5,
    ["health"] = 6041710,
    ["scale"] = 1,
    ["displayId"] = 106099,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [367481] = {
      },
      [382787] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 625.20501902527,
        ["y"] = -448.35273563076,
        ["g"] = 90,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 636.60327459698,
        ["y"] = -456.12427352056,
        ["g"] = 90,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 704.47470550127,
        ["y"] = -368.04684410278,
        ["g"] = 93,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 692.05069884931,
        ["y"] = -366.31013872563,
        ["g"] = 93,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 731.11316242678,
        ["y"] = -218.79122797455,
        ["g"] = 87,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 730.81677909915,
        ["y"] = -231.13943248258,
        ["g"] = 87,
        ["sublevel"] = 1,
      },
    },
  },
  [36] = {
    ["name"] = "Vile Rothexer",
    ["id"] = 194241,
    ["count"] = 15,
    ["health"] = 9398215,
    ["scale"] = 1,
    ["displayId"] = 106068,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [382802] = {
      },
      [382883] = {
      },
      [382891] = {
      },
      [383087] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 696.69799539776,
        ["y"] = -337.11373141853,
        ["sublevel"] = 1,
      },
    },
  },
  [37] = {
    ["name"] = "Wither Slasher",
    ["id"] = 194469,
    ["count"] = 0,
    ["health"] = 2013904,
    ["scale"] = 0.8,
    ["displayId"] = 108586,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [367481] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 741.59009875689,
        ["y"] = -295.56717667944,
        ["g"] = 88,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 730.42137267638,
        ["y"] = -290.80293021498,
        ["g"] = 88,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 735.31970357238,
        ["y"] = -294.65160960206,
        ["g"] = 88,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 737.77069734405,
        ["y"] = -288.51464775026,
        ["g"] = 88,
        ["sublevel"] = 1,
      },
    },
  },
  [38] = {
    ["name"] = "Vile Rothexer",
    ["id"] = 194487,
    ["count"] = 15,
    ["health"] = 9398215,
    ["scale"] = 1,
    ["displayId"] = 106068,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [382802] = {
      },
      [382883] = {
      },
      [382891] = {
      },
      [383087] = {
      },
    },
    ["clones"] = {
      [7] = {
        ["x"] = 739.99022659293,
        ["y"] = -282.34800564908,
        ["g"] = 88,
        ["sublevel"] = 1,
      },
    },
  },
  [39] = {
    ["name"] = "Decatriarch Wratheye",
    ["id"] = 186121,
    ["count"] = 0,
    ["health"] = 53535512,
    ["scale"] = 1.2,
    ["displayId"] = 106069,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2474,
    ["instanceID"] = 1196,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [373896] = {
      },
      [373912] = {
      },
      [373915] = {
      },
      [373917] = {
      },
      [373942] = {
      },
      [373944] = {
      },
      [373960] = {
      },
      [374186] = {
      },
      [376170] = {
      },
      [385361] = {
      },
      [387264] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 749.03152273615,
        ["y"] = -255.35954470061,
        ["sublevel"] = 1,
      },
    },
  },
};
