local MDT = MDT
local L = MDT.L

local dungeonIndex = 50
MDT.dungeonList[dungeonIndex] = L["Neltharus"]
MDT.mapInfo[dungeonIndex] = {};

local zones = { 2080, 2081 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "",
  [1] = { customTextures = 'Neltharus' },
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["Neltharus"],
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 525, teeming = 1000, teemingEnabled = true }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 254.85389818231,
      ["y"] = -505.47802554767,
      ["graveyardDescription"] = "",
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "neltharusChain",
      ["x"] = 352.63102200497,
      ["y"] = -358.40372298576,
      ["chainIndex"] = 1,
      ["textAnchor"] = "RIGHT",
      ["textAnchorTo"] = "LEFT",
    },
    [3] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "neltharusChain",
      ["x"] = 331.42114319195,
      ["y"] = -438.30389582185,
      ["chainIndex"] = 2,
      ["textAnchor"] = "RIGHT",
      ["textAnchorTo"] = "LEFT",
    },
    [4] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "neltharusChain",
      ["x"] = 407.37522261969,
      ["y"] = -415.2983267908,
      ["chainIndex"] = 3,
    },
    [5] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "neltharusChain",
      ["x"] = 395.91130110853,
      ["y"] = -324.07657372466,
      ["chainIndex"] = 4,
    },
    [6] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "neltharusChain",
      ["x"] = 387.28847341523,
      ["y"] = -277.26200786647,
      ["chainIndex"] = 5,
    },
    [7] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "neltharusChain",
      ["x"] = 401.34464163301,
      ["y"] = -243.73317212702,
      ["chainIndex"] = 6,
      ["textAnchor"] = "RIGHT",
      ["textAnchorTo"] = "LEFT",
    },
    [8] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "neltharusChain",
      ["x"] = 428.53225630169,
      ["y"] = -139.35524190798,
      ["chainIndex"] = 7,
    },
    [9] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "neltharusChain",
      ["x"] = 482.57384939016,
      ["y"] = -202.11320328069,
      ["chainIndex"] = 8,
    },
    [10] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "neltharusFood",
      ["x"] = 459.56464440828,
      ["y"] = -156.92200164094,
    },
    [11] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "neltharusShield",
      ["x"] = 696.43032468046,
      ["y"] = -354.35561935606,
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Qalashi Warden",
    ["id"] = 193293,
    ["count"] = 10,
    ["health"] = 10525850,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 111187,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [382708] = {
      },
      [384597] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 245.22633946601,
        ["y"] = -425.75299864861,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 260.38069551019,
        ["y"] = -425.64794377149,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 249.31538334381,
        ["y"] = -292.44655070611,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 263.54909069059,
        ["y"] = -292.75475803602,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 251.45137812493,
        ["y"] = -224.64554724841,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 248.41662153804,
        ["y"] = -193.67558188121,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 213.87753694932,
        ["y"] = -150.86227835292,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 195.34213381677,
        ["y"] = -118.31695193085,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 195.34213381677,
            ["y"] = -118.31695193085,
          },
          [2] = {
            ["x"] = 197.96291389402,
            ["y"] = -128.29363433084,
          },
          [3] = {
            ["x"] = 201.01116855172,
            ["y"] = -136.52394981435,
          },
          [4] = {
            ["x"] = 204.05945809406,
            ["y"] = -144.44942587823,
          },
          [5] = {
            ["x"] = 201.01116855172,
            ["y"] = -136.52394981435,
          },
          [6] = {
            ["x"] = 197.96291389402,
            ["y"] = -128.29363433084,
          },
          [7] = {
            ["x"] = 195.34213381677,
            ["y"] = -118.31695193085,
          },
          [8] = {
            ["x"] = 194.91465923631,
            ["y"] = -107.56542591225,
          },
          [9] = {
            ["x"] = 197.65809191671,
            ["y"] = -97.810965657572,
          },
          [10] = {
            ["x"] = 194.91465923631,
            ["y"] = -107.56542591225,
          },
        },
      },
      [9] = {
        ["x"] = 178.00434749561,
        ["y"] = -98.346731454384,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 296.93695451892,
        ["y"] = -154.34067445741,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 313.61011304474,
        ["y"] = -125.14340388287,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 313.61011304474,
            ["y"] = -123.6192591117,
          },
          [2] = {
            ["x"] = 310.13907600545,
            ["y"] = -131.64674585049,
          },
          [3] = {
            ["x"] = 308.61496611892,
            ["y"] = -139.57220447205,
          },
          [4] = {
            ["x"] = 305.26188948391,
            ["y"] = -145.05908727517,
          },
          [5] = {
            ["x"] = 308.61496611892,
            ["y"] = -139.57220447205,
          },
          [6] = {
            ["x"] = 310.13907600545,
            ["y"] = -131.64674585049,
          },
          [7] = {
            ["x"] = 313.61011304474,
            ["y"] = -123.6192591117,
          },
          [8] = {
            ["x"] = 314.40665345702,
            ["y"] = -113.05227383073,
          },
        },
      },
      [12] = {
        ["x"] = 311.70738084304,
        ["y"] = -103.54230828131,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Apex Blazewing",
    ["id"] = 193291,
    ["count"] = 15,
    ["health"] = 10525850,
    ["scale"] = 1.4,
    ["displayId"] = 104578,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [381662] = {
      },
      [381663] = {
      },
      [381670] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 256.65618650372,
        ["y"] = -301.77526932056,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 256.23757331073,
        ["y"] = -183.62308111181,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 192.13945955324,
        ["y"] = -86.032893925042,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 323.55131252957,
        ["y"] = -96.143839969103,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Qalashi Lavamancer",
    ["id"] = 193944,
    ["count"] = 15,
    ["health"] = 9210118,
    ["scale"] = 1.3,
    ["displayId"] = 108666,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [372213] = {
      },
      [382791] = {
      },
      [382795] = {
      },
      [383231] = {
      },
      [383651] = {
      },
      [383660] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 262.27647983061,
        ["y"] = -224.35757803452,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 264.15608789818,
        ["y"] = -193.60512544635,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 203.99682897917,
        ["y"] = -170.06066846959,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 178.55898601833,
        ["y"] = -127.18610165705,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 319.67676005477,
        ["y"] = -147.00874272336,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 331.25370954402,
        ["y"] = -132.52003437233,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Qalashi Hunter",
    ["id"] = 189227,
    ["count"] = 5,
    ["health"] = 7894387,
    ["scale"] = 1.4,
    ["displayId"] = 108349,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [372561] = {
      },
      [372566] = {
      },
      [372570] = {
      },
      [372583] = {
      },
      [372824] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 299.81343725704,
        ["y"] = -403.57660968271,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 302.87957451475,
        ["y"] = -391.280841001,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 342.50528150338,
        ["y"] = -443.25047601058,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 391.60581981412,
        ["y"] = -425.02546888977,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 408.90263179695,
        ["y"] = -403.59254187882,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 391.90294033321,
        ["y"] = -290.46710180996,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 418.2968728601,
        ["y"] = -267.20174245562,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 376.08454270404,
        ["y"] = -223.01856999344,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 368.69250186137,
        ["y"] = -229.11932630498,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 385.10304718477,
        ["y"] = -177.29720846027,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 446.74771571274,
        ["y"] = -222.44976599894,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 503.84714842175,
        ["y"] = -288.86083759643,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Tamed Phoenix",
    ["id"] = 189247,
    ["count"] = 1,
    ["health"] = 2631462,
    ["scale"] = 1,
    ["displayId"] = 109230,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
    },
    ["clones"] = {
      [1] = {
        ["x"] = 316.63731786225,
        ["y"] = -350.67014712356,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 309.77917117665,
        ["y"] = -345.3954608151,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 316.73590379898,
        ["y"] = -338.87155396055,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 321.29170940668,
        ["y"] = -376.16667555354,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 340.76729013776,
        ["y"] = -393.72739090268,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 346.32657730905,
        ["y"] = -387.724964803,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 348.9463184188,
        ["y"] = -396.81675147969,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 370.06765218223,
        ["y"] = -385.53316993435,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 376.48599133826,
        ["y"] = -378.91417637718,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 401.02711370332,
        ["y"] = -407.63829993505,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 350.29763446191,
        ["y"] = -436.22712560894,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 375.92654941767,
        ["y"] = -453.29100260137,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 383.67194392332,
        ["y"] = -448.69116378604,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 421.21013487377,
        ["y"] = -369.249369153,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 429.197193873,
        ["y"] = -363.7982475297,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 373.54833884279,
        ["y"] = -278.87539109958,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 386.17123806898,
        ["y"] = -299.36661600932,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 417.78272590435,
        ["y"] = -257.98212129418,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 415.97504128747,
        ["y"] = -241.77514921501,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 407.65009583578,
        ["y"] = -125.47149052321,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 402.17712129998,
        ["y"] = -117.0433757848,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 411.24593330591,
        ["y"] = -116.88045828051,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 462.58018023976,
        ["y"] = -227.55107467938,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 460.94436178317,
        ["y"] = -218.13197575608,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 491.90394445017,
        ["y"] = -261.11166794485,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 488.06340457216,
        ["y"] = -268.20352107684,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 496.40665261242,
        ["y"] = -269.13052498043,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 421.77512783483,
        ["y"] = -387.13453670359,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Overseer Lahar",
    ["id"] = 189235,
    ["count"] = 25,
    ["health"] = 15788774,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 108366,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [372461] = {
      },
      [372472] = {
      },
      [373406] = {
      },
      [376186] = {
      },
      [383928] = {
      },
      [395427] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 406.7850300845,
        ["y"] = -340.05221884902,
        ["sublevel"] = 1,
        ["scale"] = 1.7,
        ["patrol"] = {
          [1] = {
            ["x"] = 406.7850300845,
            ["y"] = -340.05221884902,
          },
          [2] = {
            ["x"] = 408.31945810497,
            ["y"] = -327.94218248578,
          },
          [3] = {
            ["x"] = 401.80376431902,
            ["y"] = -314.91081562663,
          },
          [4] = {
            ["x"] = 401.80376431902,
            ["y"] = -308.03316646958,
          },
          [5] = {
            ["x"] = 407.23348842789,
            ["y"] = -305.86128925369,
          },
          [6] = {
            ["x"] = 417.00696696855,
            ["y"] = -296.08774857477,
          },
          [7] = {
            ["x"] = 414.11115829769,
            ["y"] = -289.21012013047,
          },
          [8] = {
            ["x"] = 407.59546451174,
            ["y"] = -282.33249168617,
          },
          [9] = {
            ["x"] = 399.26993173202,
            ["y"] = -273.64492068433,
          },
          [10] = {
            ["x"] = 393.84020762315,
            ["y"] = -266.40529544342,
          },
          [11] = {
            ["x"] = 399.26993173202,
            ["y"] = -273.64492068433,
          },
          [12] = {
            ["x"] = 407.59546451174,
            ["y"] = -282.33249168617,
          },
          [13] = {
            ["x"] = 414.11115829769,
            ["y"] = -289.21012013047,
          },
          [14] = {
            ["x"] = 417.00696696855,
            ["y"] = -296.08774857477,
          },
          [15] = {
            ["x"] = 407.23348842789,
            ["y"] = -305.86128925369,
          },
          [16] = {
            ["x"] = 401.80376431902,
            ["y"] = -308.03316646958,
          },
          [17] = {
            ["x"] = 401.80376431902,
            ["y"] = -314.91081562663,
          },
          [18] = {
            ["x"] = 408.31945810497,
            ["y"] = -327.94218248578,
          },
          [19] = {
            ["x"] = 406.7850300845,
            ["y"] = -340.05221884902,
          },
          [20] = {
            ["x"] = 396.84088458045,
            ["y"] = -350.9667576247,
          },
          [21] = {
            ["x"] = 392.49712376839,
            ["y"] = -356.75845843387,
          },
          [22] = {
            ["x"] = 390.01495444288,
            ["y"] = -365.85971439844,
          },
          [23] = {
            ["x"] = 390.22179794139,
            ["y"] = -375.78834435703,
          },
          [24] = {
            ["x"] = 392.49712376839,
            ["y"] = -384.68276865895,
          },
          [25] = {
            ["x"] = 394.35873892666,
            ["y"] = -393.78401278766,
          },
          [26] = {
            ["x"] = 389.18758044886,
            ["y"] = -407.02219198371,
          },
          [27] = {
            ["x"] = 381.74107247234,
            ["y"] = -416.1234538662,
          },
          [28] = {
            ["x"] = 372.43299668099,
            ["y"] = -430.39586239064,
          },
          [29] = {
            ["x"] = 381.74107247234,
            ["y"] = -416.1234538662,
          },
          [30] = {
            ["x"] = 389.18758044886,
            ["y"] = -407.02219198371,
          },
          [31] = {
            ["x"] = 394.35873892666,
            ["y"] = -393.78401278766,
          },
          [32] = {
            ["x"] = 392.49712376839,
            ["y"] = -384.68276865895,
          },
          [33] = {
            ["x"] = 390.22179794139,
            ["y"] = -375.78834435703,
          },
          [34] = {
            ["x"] = 390.01495444288,
            ["y"] = -365.85971439844,
          },
          [35] = {
            ["x"] = 392.49712376839,
            ["y"] = -356.75845843387,
          },
          [36] = {
            ["x"] = 396.84088458045,
            ["y"] = -350.9667576247,
          },
        },
      },
    },
  },
  [7] = {
    ["name"] = "Qalashi Trainee",
    ["id"] = 189266,
    ["count"] = 5,
    ["health"] = 6578656,
    ["scale"] = 1.4,
    ["displayId"] = 108344,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [371875] = {
      },
      [372311] = {
      },
      [372372] = {
      },
      [372824] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 351.35829807974,
        ["y"] = -449.74484886802,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 392.01187210414,
        ["y"] = -436.97007131343,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 401.77469979502,
        ["y"] = -431.42501840434,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 388.24418062089,
        ["y"] = -332.70366780023,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 383.03457359897,
        ["y"] = -322.89689751965,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 425.91543002466,
        ["y"] = -347.77206495654,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 392.86714159436,
        ["y"] = -257.63884961171,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 395.20861682915,
        ["y"] = -229.58887766808,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 408.71271518162,
        ["y"] = -141.35061595,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 488.44166883168,
        ["y"] = -212.07671581997,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 446.17488610101,
        ["y"] = -206.39438579422,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 466.40907786426,
        ["y"] = -170.538803324,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Qalashi Bonetender",
    ["id"] = 189265,
    ["count"] = 5,
    ["health"] = 7894387,
    ["scale"] = 1.4,
    ["displayId"] = 108347,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [372223] = {
      },
      [372226] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 430.20817189533,
        ["y"] = -337.31705686407,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 382.56066744628,
        ["y"] = -253.93367475324,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 401.23249256031,
        ["y"] = -218.87744138223,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 415.93775773361,
        ["y"] = -132.23680279131,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 417.77400465779,
        ["y"] = -143.06517891313,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 451.62874336884,
        ["y"] = -166.08818703068,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Chargath, Bane of Scales",
    ["id"] = 189340,
    ["count"] = 0,
    ["health"] = 52808083,
    ["scale"] = 1.2,
    ["displayId"] = 108248,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2490,
    ["instanceID"] = 1199,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [373424] = {
      },
      [373733] = {
      },
      [373735] = {
      },
      [373742] = {
      },
      [373756] = {
      },
      [373762] = {
      },
      [374655] = {
      },
      [374704] = {
      },
      [375055] = {
      },
      [375056] = {
      },
      [375057] = {
      },
      [375397] = {
      },
      [384019] = {
      },
      [388523] = {
      },
      [389059] = {
      },
      [396332] = {
      },
      [396424] = {
      },
      [396672] = {
      },
      [414585] = {
      },
      [437458] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 355.73995925201,
        ["y"] = -205.89151016014,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Warlord Sargha",
    ["id"] = 189901,
    ["count"] = 0,
    ["health"] = 47527275,
    ["scale"] = 1.2,
    ["displayId"] = 107029,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2501,
    ["instanceID"] = 1199,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [376780] = {
      },
      [376783] = {
      },
      [376784] = {
      },
      [377014] = {
      },
      [377017] = {
      },
      [377018] = {
      },
      [377204] = {
      },
      [377473] = {
      },
      [377477] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 253.98506093332,
        ["y"] = -91.173813980314,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Qalashi Spinecrusher",
    ["id"] = 192787,
    ["count"] = 5,
    ["health"] = 9210118,
    ["scale"] = 1.4,
    ["displayId"] = 108029,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [378847] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 193.36985209268,
        ["y"] = -387.78253535692,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 202.54806098365,
        ["y"] = -380.95747735841,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 113.53225617392,
        ["y"] = -334.90608406204,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 30.905997048463,
        ["y"] = -316.41874413923,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Ore Elemental",
    ["id"] = 192781,
    ["count"] = 3,
    ["health"] = 5262925,
    ["scale"] = 1,
    ["displayId"] = 109407,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [378149] = {
      },
      [378172] = {
      },
      [378202] = {
      },
      [378221] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 206.81789841734,
        ["y"] = -389.63800123146,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 201.68831148305,
        ["y"] = -395.45854282486,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 152.62236180792,
        ["y"] = -399.857608454,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 139.82429171641,
        ["y"] = -398.85323864947,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 68.240982711293,
        ["y"] = -361.15704751108,
        ["g"] = 49,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 67.545962055823,
            ["y"] = -360.69370482615,
          },
          [2] = {
            ["x"] = 74.484257890356,
            ["y"] = -369.86929183103,
          },
          [3] = {
            ["x"] = 81.202693681364,
            ["y"] = -377.74601142545,
          },
          [4] = {
            ["x"] = 88.847708792915,
            ["y"] = -385.39105304933,
          },
          [5] = {
            ["x"] = 97.651073988698,
            ["y"] = -391.182763702,
          },
          [6] = {
            ["x"] = 103.67446261191,
            ["y"] = -393.96278004306,
          },
          [7] = {
            ["x"] = 108.77116586527,
            ["y"] = -395.81611101427,
          },
          [8] = {
            ["x"] = 103.67446261191,
            ["y"] = -393.96278004306,
          },
          [9] = {
            ["x"] = 97.651073988698,
            ["y"] = -391.182763702,
          },
          [10] = {
            ["x"] = 88.847708792915,
            ["y"] = -385.39105304933,
          },
          [11] = {
            ["x"] = 81.202693681364,
            ["y"] = -377.74601142545,
          },
          [12] = {
            ["x"] = 74.484257890356,
            ["y"] = -369.86929183103,
          },
          [13] = {
            ["x"] = 67.545962055823,
            ["y"] = -360.69370482615,
          },
          [14] = {
            ["x"] = 57.80413333166,
            ["y"] = -351.33583630112,
          },
          [15] = {
            ["x"] = 49.464150589294,
            ["y"] = -340.21575768071,
          },
          [16] = {
            ["x"] = 42.977406024993,
            ["y"] = -328.400671661,
          },
          [17] = {
            ["x"] = 49.464150589294,
            ["y"] = -340.21575768071,
          },
          [18] = {
            ["x"] = 57.80413333166,
            ["y"] = -351.33583630112,
          },
        },
      },
      [6] = {
        ["x"] = 66.124936933294,
        ["y"] = -352.25362884032,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 60.191007478107,
        ["y"] = -359.73133663595,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 45.971934063478,
        ["y"] = -301.87699218802,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 38.143305155762,
        ["y"] = -307.43218568453,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Qalashi Plunderer",
    ["id"] = 192786,
    ["count"] = 5,
    ["health"] = 8552253,
    ["scale"] = 1.4,
    ["displayId"] = 108663,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [378827] = {
      },
      [378831] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 174.55841891083,
        ["y"] = -337.6514849452,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 162.97062550261,
        ["y"] = -350.50646413369,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 112.93153806392,
        ["y"] = -367.4781204902,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 113.44418622048,
        ["y"] = -377.67852708159,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 103.37046530452,
        ["y"] = -338.64513772018,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 158.72100083127,
        ["y"] = -470.5054946421,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 139.98722102183,
        ["y"] = -463.41810838949,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 118.53980604856,
        ["y"] = -418.94302335599,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 108.36382310023,
        ["y"] = -411.68703023325,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 49.283144674618,
        ["y"] = -311.33307970471,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Qalashi Thaumaturge",
    ["id"] = 192788,
    ["count"] = 5,
    ["health"] = 6315505,
    ["scale"] = 1.4,
    ["displayId"] = 107985,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [378281] = {
      },
      [378282] = {
      },
      [378818] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 164.02860826385,
        ["y"] = -339.09874712616,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 145.0666613657,
        ["y"] = -405.29825984645,
        ["g"] = 44,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 145.0666613657,
            ["y"] = -405.29825984645,
          },
          [2] = {
            ["x"] = 143.04540019705,
            ["y"] = -409.71206590444,
          },
          [3] = {
            ["x"] = 145.67801425309,
            ["y"] = -416.55681123315,
          },
          [4] = {
            ["x"] = 149.89016058958,
            ["y"] = -424.45457808215,
          },
          [5] = {
            ["x"] = 144.36170722507,
            ["y"] = -419.45266560544,
          },
          [6] = {
            ["x"] = 138.30674310042,
            ["y"] = -412.08137938894,
          },
          [7] = {
            ["x"] = 133.3048306237,
            ["y"] = -407.07946691222,
          },
          [8] = {
            ["x"] = 125.93355947103,
            ["y"] = -404.7101383639,
          },
          [9] = {
            ["x"] = 118.0357775582,
            ["y"] = -402.60403506801,
          },
          [10] = {
            ["x"] = 124.61725244301,
            ["y"] = -401.55099848389,
          },
          [11] = {
            ["x"] = 133.04157524363,
            ["y"] = -399.97148126727,
          },
          [12] = {
            ["x"] = 139.35979474836,
            ["y"] = -396.28584569093,
          },
          [13] = {
            ["x"] = 143.5719712125,
            ["y"] = -392.33695473451,
          },
          [14] = {
            ["x"] = 148.57385356156,
            ["y"] = -389.44110036222,
          },
          [15] = {
            ["x"] = 151.99626388547,
            ["y"] = -384.70241313794,
          },
          [16] = {
            ["x"] = 148.57385356156,
            ["y"] = -389.44110036222,
          },
          [17] = {
            ["x"] = 146.20455514089,
            ["y"] = -392.60021011459,
          },
          [18] = {
            ["x"] = 145.94129976082,
            ["y"] = -394.96953866291,
          },
          [19] = {
            ["x"] = 144.01360971776,
            ["y"] = -400.82288825753,
          },
          [20] = {
            ["x"] = 145.0666613657,
            ["y"] = -405.29825984645,
          },
        },
      },
      [3] = {
        ["x"] = 103.09524101427,
        ["y"] = -381.18521247426,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 97.641071539382,
        ["y"] = -348.78239726584,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 122.55923074049,
        ["y"] = -340.24036784489,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 149.03446554798,
        ["y"] = -467.79163677629,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 131.69516286438,
        ["y"] = -454.66297959328,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 105.77410546282,
        ["y"] = -423.33133489822,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 33.981374827604,
        ["y"] = -297.84607963424,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Magmatusk",
    ["id"] = 181861,
    ["count"] = 0,
    ["health"] = 45745004,
    ["scale"] = 1.2,
    ["displayId"] = 102604,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2494,
    ["instanceID"] = 1199,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [374365] = {
      },
      [374410] = {
      },
      [375251] = {
      },
      [375436] = {
      },
      [375439] = {
      },
      [375449] = {
      },
      [375455] = {
      },
      [375535] = {
      },
      [375890] = {
      },
      [391457] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 103.89672240106,
        ["y"] = -229.39256981282,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Qalashi Lavabearer",
    ["id"] = 189472,
    ["count"] = 15,
    ["health"] = 10525850,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 108665,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [372211] = {
      },
      [372213] = {
      },
      [379404] = {
      },
      [379406] = {
      },
      [379410] = {
      },
      [381329] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 591.9625915005,
        ["y"] = -268.40870343889,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [2] = {
        ["x"] = 704.50318964804,
        ["y"] = -148.04201689736,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 694.54233791835,
        ["y"] = -144.01036127305,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 737.04560140774,
        ["y"] = -355.52385395323,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 736.78234602767,
            ["y"] = -355.52385395323,
          },
          [2] = {
            ["x"] = 730.54105746481,
            ["y"] = -346.9166352513,
          },
          [3] = {
            ["x"] = 725.5391449881,
            ["y"] = -339.28212378237,
          },
          [4] = {
            ["x"] = 718.69438459557,
            ["y"] = -334.28018117801,
          },
          [5] = {
            ["x"] = 725.5391449881,
            ["y"] = -339.28212378237,
          },
          [6] = {
            ["x"] = 730.54105746481,
            ["y"] = -346.9166352513,
          },
          [7] = {
            ["x"] = 736.78234602767,
            ["y"] = -355.52385395323,
          },
          [8] = {
            ["x"] = 738.17558399757,
            ["y"] = -366.13457927322,
          },
          [9] = {
            ["x"] = 738.96535013779,
            ["y"] = -374.03234612222,
          },
          [10] = {
            ["x"] = 738.17558399757,
            ["y"] = -366.13457927322,
          },
        },
      },
      [5] = {
        ["x"] = 654.78834620111,
        ["y"] = -355.47094147285,
        ["g"] = 32,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 654.78834620111,
            ["y"] = -355.47094147285,
          },
          [2] = {
            ["x"] = 657.67026234959,
            ["y"] = -343.01996154007,
          },
          [3] = {
            ["x"] = 661.6192135613,
            ["y"] = -336.17521621137,
          },
          [4] = {
            ["x"] = 664.7782781222,
            ["y"] = -331.17327360701,
          },
          [5] = {
            ["x"] = 661.6192135613,
            ["y"] = -336.17521621137,
          },
          [6] = {
            ["x"] = 657.67026234959,
            ["y"] = -343.01996154007,
          },
          [7] = {
            ["x"] = 654.78834620111,
            ["y"] = -355.47094147285,
          },
          [8] = {
            ["x"] = 649.77254069206,
            ["y"] = -364.60723411031,
          },
          [9] = {
            ["x"] = 649.24596967662,
            ["y"] = -371.97849019917,
          },
          [10] = {
            ["x"] = 649.77254069206,
            ["y"] = -364.60723411031,
          },
        },
      },
    },
  },
  [17] = {
    ["name"] = "Lava Flare",
    ["id"] = 189470,
    ["count"] = 3,
    ["health"] = 4210339,
    ["scale"] = 1,
    ["displayId"] = 102505,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [372538] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 602.01086855262,
        ["y"] = -272.42095346869,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [2] = {
        ["x"] = 601.66420721531,
        ["y"] = -262.80609119276,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [3] = {
        ["x"] = 605.23848418911,
        ["y"] = -194.12970848687,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 612.44872172139,
        ["y"] = -187.34019402021,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 616.87906721538,
        ["y"] = -179.40048382584,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 604.48313539147,
        ["y"] = -220.21192044884,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 617.8602877315,
        ["y"] = -228.01497716683,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 649.24129053887,
        ["y"] = -217.44650317424,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 654.26931815442,
        ["y"] = -197.63011654132,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 745.40096830209,
        ["y"] = -214.12249932436,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 740.53754582048,
        ["y"] = -192.95619324394,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 781.49215525082,
        ["y"] = -194.65462887849,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 785.61665783142,
        ["y"] = -202.36546777526,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 792.75465150154,
        ["y"] = -207.2140985303,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 712.46247011659,
        ["y"] = -276.57342237437,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 712.39781159395,
        ["y"] = -285.75194639268,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 679.77486825176,
        ["y"] = -275.68811725919,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 679.03082688513,
        ["y"] = -285.52370276475,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 723.27965684767,
        ["y"] = -384.40497081285,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 723.43727673491,
        ["y"] = -369.80575516185,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 673.58572409272,
        ["y"] = -382.23472832926,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 673.31835823238,
        ["y"] = -369.78187743687,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 759.65494243489,
        ["y"] = -337.34772036405,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 763.45382257811,
        ["y"] = -346.58355468359,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 636.31342745987,
        ["y"] = -336.97265137907,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 631.43051650323,
        ["y"] = -344.91577142682,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 746.72354588165,
        ["y"] = -480.16929144857,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 751.29207877251,
        ["y"] = -472.04410333071,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 742.6337502522,
        ["y"] = -471.61443581485,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 642.32024871512,
        ["y"] = -465.99534547609,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 651.27929308828,
        ["y"] = -468.20569137551,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 647.38782924181,
        ["y"] = -475.33140136219,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Qalashi Bonesplitter",
    ["id"] = 189467,
    ["count"] = 5,
    ["health"] = 8552253,
    ["scale"] = 1.4,
    ["displayId"] = 111189,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [372224] = {
      },
      [372225] = {
      },
      [372262] = {
      },
      [372266] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 598.85955966757,
        ["y"] = -185.77584633788,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 606.38933291404,
        ["y"] = -176.06385780207,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 658.70349357521,
        ["y"] = -215.19069784865,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 662.07600369048,
        ["y"] = -204.60841953375,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 753.00292468533,
        ["y"] = -209.42440995165,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 749.1396668019,
        ["y"] = -193.9824339145,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 790.38629777343,
        ["y"] = -190.61699578879,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 746.42799046234,
        ["y"] = -354.96376126343,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 645.27715825474,
        ["y"] = -353.18673917816,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Qalashi Irontorch",
    ["id"] = 189464,
    ["count"] = 5,
    ["health"] = 9210118,
    ["scale"] = 1.4,
    ["displayId"] = 101960,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [372201] = {
      },
      [372202] = {
      },
      [372203] = {
      },
      [384161] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 607.36308437837,
        ["y"] = -230.64511323929,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 650.66779360732,
        ["y"] = -206.9166003159,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 650.66779360732,
            ["y"] = -206.9166003159,
          },
          [2] = {
            ["x"] = 638.68485511791,
            ["y"] = -204.55187394313,
          },
          [3] = {
            ["x"] = 650.66779360732,
            ["y"] = -206.9166003159,
          },
          [4] = {
            ["x"] = 668.55783125817,
            ["y"] = -211.86770697042,
          },
        },
      },
      [3] = {
        ["x"] = 743.09804708998,
        ["y"] = -203.49990625907,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 743.09804708998,
            ["y"] = -203.49990625907,
          },
          [2] = {
            ["x"] = 727.04329315201,
            ["y"] = -205.08481444205,
          },
          [3] = {
            ["x"] = 743.09804708998,
            ["y"] = -203.49990625907,
          },
          [4] = {
            ["x"] = 762.32005637966,
            ["y"] = -199.81964658526,
          },
        },
      },
      [4] = {
        ["x"] = 690.02420422239,
        ["y"] = -311.30378249362,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 705.38203363257,
        ["y"] = -311.37415096323,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 718.64710505802,
        ["y"] = -414.85407791561,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 727.88950736766,
        ["y"] = -435.03432996952,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 663.8976384654,
        ["y"] = -431.91358495851,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 674.73195164584,
        ["y"] = -412.3301124206,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Irontorch Commander",
    ["id"] = 189466,
    ["count"] = 30,
    ["health"] = 14473043,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 111190,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [372293] = {
      },
      [372296] = {
      },
      [372542] = {
      },
      [372543] = {
      },
      [373084] = {
      },
      [373089] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 698.66041552103,
        ["y"] = -229.57432560134,
        ["sublevel"] = 1,
        ["scale"] = 1.7,
      },
    },
  },
  [21] = {
    ["name"] = "Qalashi Blacksmith",
    ["id"] = 189471,
    ["count"] = 5,
    ["health"] = 9210118,
    ["scale"] = 1.4,
    ["displayId"] = 109595,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [372971] = {
      },
      [384623] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 796.65740106003,
        ["y"] = -198.77167026539,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 697.80836173346,
        ["y"] = -300.76895527928,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 730.56579005728,
        ["y"] = -377.42807525424,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 665.20211139703,
        ["y"] = -376.39639492624,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 659.83180357048,
        ["y"] = -463.66043086187,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
    },
  },
  [22] = {
    ["name"] = "Forgemaster Gorek",
    ["id"] = 189478,
    ["count"] = 0,
    ["health"] = 41586366,
    ["scale"] = 1.2,
    ["displayId"] = 107189,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2489,
    ["instanceID"] = 1199,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [374397] = {
      },
      [374517] = {
      },
      [374533] = {
      },
      [374534] = {
      },
      [374535] = {
      },
      [374586] = {
      },
      [374635] = {
      },
      [374641] = {
      },
      [374812] = {
      },
      [374839] = {
      },
      [374842] = {
      },
      [374969] = {
      },
      [375046] = {
      },
      [375061] = {
      },
      [375291] = {
      },
      [375306] = {
      },
      [377995] = {
      },
      [392666] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 696.27921893934,
        ["y"] = -373.77819664821,
        ["sublevel"] = 1,
      },
    },
  },
  [23] = {
    ["name"] = "Forgewrought Monstrosity",
    ["id"] = 194816,
    ["count"] = 15,
    ["health"] = 7894387,
    ["scale"] = 1.4,
    ["displayId"] = 108693,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [384662] = {
      },
      [384663] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 728.69715360155,
        ["y"] = -422.29299661408,
        ["g"] = 38,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 728.69715360155,
            ["y"] = -422.55626705798,
          },
          [2] = {
            ["x"] = 737.54293297507,
            ["y"] = -416.62789676763,
          },
          [3] = {
            ["x"] = 742.54484545178,
            ["y"] = -408.73011485481,
          },
          [4] = {
            ["x"] = 737.54293297507,
            ["y"] = -416.62789676763,
          },
          [5] = {
            ["x"] = 728.69715360155,
            ["y"] = -422.55626705798,
          },
          [6] = {
            ["x"] = 718.32498895315,
            ["y"] = -427.42153305275,
          },
          [7] = {
            ["x"] = 707.26808222413,
            ["y"] = -430.31740248887,
          },
          [8] = {
            ["x"] = 718.32498895315,
            ["y"] = -427.42153305275,
          },
        },
      },
      [2] = {
        ["x"] = 665.67228029945,
        ["y"] = -420.30995433328,
        ["g"] = 37,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 665.67228029945,
            ["y"] = -421.36296078976,
          },
          [2] = {
            ["x"] = 656.72229605863,
            ["y"] = -418.20747423955,
          },
          [3] = {
            ["x"] = 651.98360883434,
            ["y"] = -414.52185372704,
          },
          [4] = {
            ["x"] = 647.24492161006,
            ["y"] = -407.67712346215,
          },
          [5] = {
            ["x"] = 651.98360883434,
            ["y"] = -414.52185372704,
          },
          [6] = {
            ["x"] = 656.72229605863,
            ["y"] = -418.20747423955,
          },
          [7] = {
            ["x"] = 665.67228029945,
            ["y"] = -421.36296078976,
          },
          [8] = {
            ["x"] = 672.51785988428,
            ["y"] = -424.78894912436,
          },
          [9] = {
            ["x"] = 683.83796173808,
            ["y"] = -428.21132932062,
          },
          [10] = {
            ["x"] = 672.51785988428,
            ["y"] = -424.78894912436,
          },
        },
      },
    },
  },
};
