local MDT = MDT
local L = MDT.L

local dungeonIndex = 43
MDT.dungeonList[dungeonIndex] = L["TheNokhudOffensive"]
MDT.mapInfo[dungeonIndex] = {};

local zones = { 2093 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "",
  [1] = { customTextures = 'NokhudOffensive' },
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["TheNokhudOffensive"],
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 520, teeming = 1000, teemingEnabled = true }

MDT.mapPOIs[dungeonIndex] = {};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Nokhud Warspear",
    ["id"] = 192791,
    ["count"] = 6,
    ["health"] = 6713011,
    ["scale"] = 1,
    ["displayId"] = 108672,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [381683] = {
      },
      [381692] = {
      },
      [384134] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 598.71144710723,
        ["y"] = -42.872146835377,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 649.83409141558,
        ["y"] = -82.420927851477,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
        ["patrol"] = {
          [1] = {
            ["x"] = 649.83409141558,
            ["y"] = -82.420927851477,
          },
          [2] = {
            ["x"] = 663.71997204344,
            ["y"] = -82.342830479489,
          },
          [3] = {
            ["x"] = 677.10613664402,
            ["y"] = -77.05062504144,
          },
          [4] = {
            ["x"] = 686.75667711359,
            ["y"] = -68.333990604612,
          },
          [5] = {
            ["x"] = 696.40714633071,
            ["y"] = -57.126975706682,
          },
          [6] = {
            ["x"] = 686.75667711359,
            ["y"] = -68.333990604612,
          },
          [7] = {
            ["x"] = 677.10613664402,
            ["y"] = -77.05062504144,
          },
          [8] = {
            ["x"] = 663.71997204344,
            ["y"] = -82.342830479489,
          },
          [9] = {
            ["x"] = 649.83409141558,
            ["y"] = -82.420927851477,
          },
          [10] = {
            ["x"] = 626.98583598801,
            ["y"] = -74.560137701643,
          },
          [11] = {
            ["x"] = 615.77874983762,
            ["y"] = -66.154840901963,
          },
          [12] = {
            ["x"] = 626.98583598801,
            ["y"] = -74.560137701643,
          },
        },
      },
      [3] = {
        ["x"] = 634.53933567402,
        ["y"] = -85.774099749332,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 541.97611481428,
        ["y"] = -147.91988218067,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 612.54094904368,
        ["y"] = -228.48903221512,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [6] = {
        ["x"] = 612.848470677,
        ["y"] = -182.37274198042,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [7] = {
        ["x"] = 617.74605315834,
        ["y"] = -155.76112850364,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [8] = {
        ["x"] = 605.12164820176,
        ["y"] = -146.70125062266,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [9] = {
        ["x"] = 724.08383879916,
        ["y"] = -153.69059736003,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [10] = {
        ["x"] = 668.64823089035,
        ["y"] = -20.773276082988,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [11] = {
        ["x"] = 708.86832518275,
        ["y"] = -79.199968816677,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [12] = {
        ["x"] = 316.89662805494,
        ["y"] = -150.11873990935,
        ["g"] = 37,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [13] = {
        ["x"] = 317.35453772128,
        ["y"] = -165.19940429269,
        ["g"] = 37,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [14] = {
        ["x"] = 302.17635515076,
        ["y"] = -108.03646269106,
        ["g"] = 38,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [15] = {
        ["x"] = 299.40074338004,
        ["y"] = -123.47351499376,
        ["g"] = 38,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [16] = {
        ["x"] = 242.93098018678,
        ["y"] = -121.26598505112,
        ["g"] = 40,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [17] = {
        ["x"] = 244.10813995752,
        ["y"] = -139.94891284002,
        ["g"] = 40,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [18] = {
        ["x"] = 197.26835998874,
        ["y"] = -172.59557719644,
        ["g"] = 45,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [19] = {
        ["x"] = 173.6433265702,
        ["y"] = -172.55786264766,
        ["g"] = 45,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [20] = {
        ["x"] = 221.75568393927,
        ["y"] = -65.657936882827,
        ["g"] = 43,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [21] = {
        ["x"] = 189.62622291607,
        ["y"] = -53.100372601536,
        ["g"] = 43,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
    },
  },
  [2] = {
    ["name"] = "Nokhud Longbow",
    ["id"] = 192789,
    ["count"] = 5,
    ["health"] = 6041710,
    ["scale"] = 1,
    ["displayId"] = 108667,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [373392] = {
      },
      [384476] = {
      },
      [384479] = {
      },
      [384868] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 589.31669476741,
        ["y"] = -57.675516129569,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 601.14986235661,
        ["y"] = -63.655659177477,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 639.78049691094,
        ["y"] = -70.939138400232,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 557.42528579674,
        ["y"] = -149.52545881423,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 555.67259085375,
        ["y"] = -166.0520044517,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [6] = {
        ["x"] = 598.42928745957,
        ["y"] = -228.36358270431,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [7] = {
        ["x"] = 617.33943719457,
        ["y"] = -193.43197823405,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [8] = {
        ["x"] = 616.83393061989,
        ["y"] = -122.40259826079,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [9] = {
        ["x"] = 603.49907781993,
        ["y"] = -129.56042622461,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [10] = {
        ["x"] = 684.98318798538,
        ["y"] = -26.401991440099,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [11] = {
        ["x"] = 672.99946949495,
        ["y"] = -36.161361067405,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [12] = {
        ["x"] = 727.10464651704,
        ["y"] = -99.223747455392,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [13] = {
        ["x"] = 691.79006569381,
        ["y"] = -195.28167950437,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [14] = {
        ["x"] = 677.97719394232,
        ["y"] = -202.9073934385,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [3] = {
    ["name"] = "Nokhud Hornsounder",
    ["id"] = 192796,
    ["count"] = 5,
    ["health"] = 4699108,
    ["scale"] = 1,
    ["displayId"] = 108597,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [373392] = {
      },
      [383823] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 611.20877118366,
        ["y"] = -53.841939841074,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 539.43905395818,
        ["y"] = -163.20615043279,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 620.9036887083,
        ["y"] = -208.32097848929,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 720.50978349733,
        ["y"] = -166.78498523819,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 724.42358695032,
        ["y"] = -82.595937770678,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [6] = {
        ["x"] = 697.63172945141,
        ["y"] = -179.2149783773,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [4] = {
    ["name"] = "Nokhud Beastmaster",
    ["id"] = 192794,
    ["count"] = 5,
    ["health"] = 6713011,
    ["scale"] = 1,
    ["displayId"] = 108670,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [383690] = {
      },
      [383693] = {
      },
      [384492] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 583.3816580044,
        ["y"] = -224.69971648376,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 741.96476963953,
        ["y"] = -147.95791098505,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 656.81122912578,
        ["y"] = -33.585134525053,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 664.58407262047,
        ["y"] = -198.10368292023,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [5] = {
    ["name"] = "Nokhud Plainstomper",
    ["id"] = 191847,
    ["count"] = 8,
    ["health"] = 12083419,
    ["scale"] = 1,
    ["displayId"] = 108673,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [384336] = {
      },
      [384365] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 622.36890405233,
        ["y"] = -220.92969410581,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 619.25584831693,
            ["y"] = -219.06181078785,
          },
          [2] = {
            ["x"] = 639.74936094053,
            ["y"] = -230.52484994159,
          },
          [3] = {
            ["x"] = 674.61568493045,
            ["y"] = -235.1944513578,
          },
          [4] = {
            ["x"] = 712.59517153447,
            ["y"] = -233.01530165515,
          },
          [5] = {
            ["x"] = 737.81102630727,
            ["y"] = -218.69517758247,
          },
          [6] = {
            ["x"] = 754.93292191755,
            ["y"] = -200.63939375256,
          },
          [7] = {
            ["x"] = 770.18693420986,
            ["y"] = -168.57478786089,
          },
          [8] = {
            ["x"] = 776.10174366974,
            ["y"] = -145.22679859293,
          },
          [9] = {
            ["x"] = 772.05474627536,
            ["y"] = -111.29434500953,
          },
          [10] = {
            ["x"] = 758.66854604855,
            ["y"] = -75.494079360625,
          },
          [11] = {
            ["x"] = 745.28234582174,
            ["y"] = -50.278260214049,
          },
          [12] = {
            ["x"] = 719.75515341178,
            ["y"] = -22.260580464296,
          },
          [13] = {
            ["x"] = 745.28234582174,
            ["y"] = -50.278260214049,
          },
          [14] = {
            ["x"] = 758.66854604855,
            ["y"] = -75.494079360625,
          },
          [15] = {
            ["x"] = 772.05474627536,
            ["y"] = -111.29434500953,
          },
          [16] = {
            ["x"] = 776.10174366974,
            ["y"] = -145.22679859293,
          },
          [17] = {
            ["x"] = 770.18693420986,
            ["y"] = -168.57478786089,
          },
          [18] = {
            ["x"] = 754.93292191755,
            ["y"] = -200.63939375256,
          },
          [19] = {
            ["x"] = 737.81102630727,
            ["y"] = -218.69517758247,
          },
          [20] = {
            ["x"] = 712.59517153447,
            ["y"] = -233.01530165515,
          },
          [21] = {
            ["x"] = 674.61568493045,
            ["y"] = -235.1944513578,
          },
          [22] = {
            ["x"] = 639.74936094053,
            ["y"] = -230.52484994159,
          },
          [23] = {
            ["x"] = 619.25584831693,
            ["y"] = -219.06181078785,
          },
          [24] = {
            ["x"] = 590.87419707573,
            ["y"] = -200.01678973073,
          },
          [25] = {
            ["x"] = 575.93148679433,
            ["y"] = -176.98006684746,
          },
          [26] = {
            ["x"] = 572.81843105893,
            ["y"] = -152.38685172271,
          },
          [27] = {
            ["x"] = 572.81843105893,
            ["y"] = -119.69964180921,
          },
          [28] = {
            ["x"] = 586.51593329666,
            ["y"] = -89.50288360927,
          },
          [29] = {
            ["x"] = 572.81843105893,
            ["y"] = -119.69964180921,
          },
          [30] = {
            ["x"] = 572.81843105893,
            ["y"] = -152.38685172271,
          },
          [31] = {
            ["x"] = 575.93148679433,
            ["y"] = -176.98006684746,
          },
          [32] = {
            ["x"] = 590.87419707573,
            ["y"] = -200.01678973073,
          },
        },
      },
      [2] = {
        ["x"] = 728.25480326721,
        ["y"] = -139.58539318033,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["scale"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 728.25480326721,
            ["y"] = -139.58539318033,
          },
          [2] = {
            ["x"] = 721.62303672975,
            ["y"] = -127.17099694991,
          },
          [3] = {
            ["x"] = 716.64216892885,
            ["y"] = -115.96398205198,
          },
          [4] = {
            ["x"] = 708.859476151,
            ["y"] = -110.6717409877,
          },
          [5] = {
            ["x"] = 696.40714633071,
            ["y"] = -97.596842771801,
          },
          [6] = {
            ["x"] = 684.57756303718,
            ["y"] = -90.436825268252,
          },
          [7] = {
            ["x"] = 669.63485275578,
            ["y"] = -87.946337928454,
          },
          [8] = {
            ["x"] = 656.87122092457,
            ["y"] = -89.191545972121,
          },
          [9] = {
            ["x"] = 640.37196496236,
            ["y"] = -96.662936739051,
          },
          [10] = {
            ["x"] = 634.14581786533,
            ["y"] = -105.37953554965,
          },
          [11] = {
            ["x"] = 632.27804142606,
            ["y"] = -116.27528406289,
          },
          [12] = {
            ["x"] = 635.07975952431,
            ["y"] = -134.64236990372,
          },
          [13] = {
            ["x"] = 638.19285088594,
            ["y"] = -149.585062372,
          },
          [14] = {
            ["x"] = 646.90944969654,
            ["y"] = -166.08435396044,
          },
          [15] = {
            ["x"] = 656.55999016612,
            ["y"] = -172.62176744216,
          },
          [16] = {
            ["x"] = 672.43660648026,
            ["y"] = -171.06525738757,
          },
          [17] = {
            ["x"] = 696.09591557226,
            ["y"] = -172.31046543124,
          },
          [18] = {
            ["x"] = 713.84037957813,
            ["y"] = -169.19742750896,
          },
          [19] = {
            ["x"] = 725.98130050881,
            ["y"] = -157.36777296296,
          },
        },
      },
    },
  },
  [6] = {
    ["name"] = "War Ohuna",
    ["id"] = 192803,
    ["count"] = 0,
    ["health"] = 2685204,
    ["scale"] = 1,
    ["displayId"] = 101437,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [334610] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 576.63149826048,
        ["y"] = -212.52531465072,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [2] = {
        ["x"] = 752.43051762366,
        ["y"] = -159.67293259539,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [3] = {
        ["x"] = 648.73196031653,
        ["y"] = -23.370931153545,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [4] = {
        ["x"] = 658.35613807881,
        ["y"] = -184.26717798472,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
    },
  },
  [7] = {
    ["name"] = "Nokhud Lancemaster",
    ["id"] = 192800,
    ["count"] = 10,
    ["health"] = 12083419,
    ["scale"] = 1,
    ["displayId"] = 108528,
    ["iconTexture"] = 135127,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [384336] = {
      },
      [384365] = {
      },
      [384510] = {
      },
      [384512] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 623.88125236757,
        ["y"] = -138.64281931434,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["scale"] = 2.6,
      },
      [2] = {
        ["x"] = 710.89088668566,
        ["y"] = -97.727944085612,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["scale"] = 2.6,
      },
      [3] = {
        ["x"] = 678.45206413343,
        ["y"] = -181.20657496265,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["scale"] = 2.6,
      },
    },
  },
  [8] = {
    ["name"] = "Granyth",
    ["id"] = 186616,
    ["count"] = 0,
    ["health"] = 50858736,
    ["scale"] = 1,
    ["displayId"] = 105823,
    ["creatureType"] = "Dragonkin",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 2498,
    ["instanceID"] = 1198,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [385916] = {
      },
      [387155] = {
      },
      [388283] = {
      },
      [388817] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 674.28886712046,
        ["y"] = -130.17610366968,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
    },
  },
  [9] = {
    ["name"] = "Primalist Arcblade",
    ["id"] = 194898,
    ["count"] = 6,
    ["health"] = 8055613,
    ["scale"] = 1,
    ["displayId"] = 109038,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [387135] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 725.86730389567,
        ["y"] = -402.81932458114,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 703.51048518282,
        ["y"] = -380.62554362137,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 588.99149656006,
        ["y"] = -355.52460871858,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 676.67786153366,
        ["y"] = -500.93901146968,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 705.01299519196,
        ["y"] = -497.81591287067,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [10] = {
    ["name"] = "Stormcaller Boroo",
    ["id"] = 194317,
    ["count"] = 10,
    ["health"] = 10740817,
    ["scale"] = 1,
    ["displayId"] = 108819,
    ["iconTexture"] = 136048,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [386012] = {
      },
      [387145] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 706.01914860866,
        ["y"] = -400.90334608501,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["scale"] = 2.4,
      },
    },
  },
  [11] = {
    ["name"] = "Stormsurge Totem",
    ["id"] = 194897,
    ["count"] = 0,
    ["health"] = 3222243,
    ["scale"] = 1,
    ["displayId"] = 107517,
    ["creatureType"] = "Not specified",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [382628] = {
      },
      [384881] = {
      },
      [386694] = {
      },
      [387146] = {
      },
      [400474] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 718.71361744441,
        ["y"] = -388.67225898447,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [2] = {
        ["x"] = 593.25898310523,
        ["y"] = -371.29445966481,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [3] = {
        ["x"] = 602.70823573467,
        ["y"] = -457.62626533584,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [4] = {
        ["x"] = 692.90422899244,
        ["y"] = -494.86171273125,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
    },
  },
  [12] = {
    ["name"] = "Primalist Thunderbeast",
    ["id"] = 195696,
    ["count"] = 12,
    ["health"] = 13426021,
    ["scale"] = 1,
    ["displayId"] = 110545,
    ["creatureType"] = "Beast",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [386028] = {
      },
      [387125] = {
      },
      [387127] = {
      },
      [399507] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 689.38820485871,
        ["y"] = -344.90824339195,
        ["sublevel"] = 1,
        ["scale"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 689.38820485871,
            ["y"] = -344.90824339195,
          },
          [2] = {
            ["x"] = 691.52174916897,
            ["y"] = -358.95211992541,
          },
          [3] = {
            ["x"] = 695.8800842005,
            ["y"] = -372.64960435003,
          },
          [4] = {
            ["x"] = 691.52174916897,
            ["y"] = -358.95211992541,
          },
          [5] = {
            ["x"] = 689.38820485871,
            ["y"] = -344.90824339195,
          },
          [6] = {
            ["x"] = 685.60701096155,
            ["y"] = -323.15185427651,
          },
          [7] = {
            ["x"] = 677.51298054656,
            ["y"] = -307.58653997328,
          },
          [8] = {
            ["x"] = 675.64516848106,
            ["y"] = -294.20030412024,
          },
          [9] = {
            ["x"] = 677.51298054656,
            ["y"] = -307.58653997328,
          },
          [10] = {
            ["x"] = 685.60701096155,
            ["y"] = -323.15185427651,
          },
        },
      },
      [2] = {
        ["x"] = 526.57888301577,
        ["y"] = -397.23291730999,
        ["sublevel"] = 1,
        ["scale"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 526.57888301577,
            ["y"] = -397.23291730999,
          },
          [2] = {
            ["x"] = 547.3867805406,
            ["y"] = -402.84636254997,
          },
          [3] = {
            ["x"] = 561.39554916302,
            ["y"] = -414.05344870036,
          },
          [4] = {
            ["x"] = 575.09305140074,
            ["y"] = -419.65695614932,
          },
          [5] = {
            ["x"] = 581.63046488246,
            ["y"] = -421.83608803886,
          },
          [6] = {
            ["x"] = 575.09305140074,
            ["y"] = -419.65695614932,
          },
          [7] = {
            ["x"] = 561.39554916302,
            ["y"] = -414.05344870036,
          },
          [8] = {
            ["x"] = 547.3867805406,
            ["y"] = -402.84636254997,
          },
          [9] = {
            ["x"] = 526.57888301577,
            ["y"] = -397.23291730999,
          },
          [10] = {
            ["x"] = 505.67166980558,
            ["y"] = -389.14889593847,
          },
          [11] = {
            ["x"] = 482.01236071359,
            ["y"] = -384.16795688511,
          },
          [12] = {
            ["x"] = 505.67166980558,
            ["y"] = -389.14889593847,
          },
        },
      },
      [3] = {
        ["x"] = 649.40299058414,
        ["y"] = -379.63730568641,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["scale"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 649.40299058414,
            ["y"] = -379.63730568641,
          },
          [2] = {
            ["x"] = 669.41902138403,
            ["y"] = -381.98882499557,
          },
          [3] = {
            ["x"] = 681.24867593002,
            ["y"] = -391.63936546515,
          },
          [4] = {
            ["x"] = 687.47478740082,
            ["y"] = -402.84636254997,
          },
          [5] = {
            ["x"] = 690.89918077337,
            ["y"] = -415.29863893091,
          },
          [6] = {
            ["x"] = 689.03133308164,
            ["y"] = -430.55266903634,
          },
          [7] = {
            ["x"] = 680.31476989727,
            ["y"] = -446.74062298763,
          },
          [8] = {
            ["x"] = 667.23987168138,
            ["y"] = -459.19289936858,
          },
          [9] = {
            ["x"] = 652.29716139998,
            ["y"] = -463.86251859791,
          },
          [10] = {
            ["x"] = 632.99611608706,
            ["y"] = -463.55119877388,
          },
          [11] = {
            ["x"] = 612.76116474138,
            ["y"] = -458.88157954455,
          },
          [12] = {
            ["x"] = 599.06366250365,
            ["y"] = -444.8727752959,
          },
          [13] = {
            ["x"] = 591.28100535204,
            ["y"] = -427.75093312497,
          },
          [14] = {
            ["x"] = 592.83755103285,
            ["y"] = -407.5159817793,
          },
          [15] = {
            ["x"] = 603.7332995461,
            ["y"] = -392.26193386075,
          },
          [16] = {
            ["x"] = 618.98727621218,
            ["y"] = -380.12101293007,
          },
          [17] = {
            ["x"] = 633.93002211981,
            ["y"] = -377.00792156844,
          },
        },
      },
    },
  },
  [13] = {
    ["name"] = "Primalist Stormspeaker",
    ["id"] = 194894,
    ["count"] = 6,
    ["health"] = 6713011,
    ["scale"] = 1,
    ["displayId"] = 108711,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [386012] = {
      },
      [386015] = {
      },
      [386022] = {
      },
      [386024] = {
      },
      [386025] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 587.01722729556,
        ["y"] = -385.83995178738,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 541.94287413513,
        ["y"] = -467.50636413763,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 602.94585110057,
        ["y"] = -473.10979319172,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 702.44519029658,
        ["y"] = -481.46154503219,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [14] = {
    ["name"] = "Unstable Squall",
    ["id"] = 194895,
    ["count"] = 0,
    ["health"] = 2685204,
    ["scale"] = 1,
    ["displayId"] = 101201,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [386018] = {
      },
      [386019] = {
      },
      [386026] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 602.80570089669,
        ["y"] = -384.05698536096,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 551.11444454937,
        ["y"] = -455.28078606648,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [3] = {
        ["x"] = 687.72399792051,
        ["y"] = -507.06620965775,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [4] = {
        ["x"] = 592.80652186748,
        ["y"] = -479.84224485441,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
    },
  },
  [15] = {
    ["name"] = "Stormcaller Arynga",
    ["id"] = 195265,
    ["count"] = 10,
    ["health"] = 10740817,
    ["scale"] = 1,
    ["displayId"] = 108819,
    ["iconTexture"] = 136048,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [386012] = {
      },
      [387145] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 577.53591711446,
        ["y"] = -371.79799989783,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["scale"] = 2.4,
      },
    },
  },
  [16] = {
    ["name"] = "Primal Stormshield",
    ["id"] = 194896,
    ["count"] = 7,
    ["health"] = 6713011,
    ["scale"] = 1,
    ["displayId"] = 108335,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [386223] = {
      },
      [386225] = {
      },
      [386227] = {
      },
      [386228] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 542.65161437896,
        ["y"] = -444.17208916018,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 590.17238896107,
        ["y"] = -448.28961115083,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 632.17570381348,
        ["y"] = -501.41172321869,
        ["g"] = 14,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 627.82732431338,
        ["y"] = -510.0516246107,
        ["g"] = 14,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 653.42142069538,
        ["y"] = -462.90970823111,
        ["g"] = 13,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [6] = {
        ["x"] = 665.57960454259,
        ["y"] = -456.19196056471,
        ["g"] = 13,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [7] = {
        ["x"] = 702.92409865973,
        ["y"] = -435.44227318791,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [8] = {
        ["x"] = 719.28492828943,
        ["y"] = -440.00443558361,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [9] = {
        ["x"] = 632.21635204639,
        ["y"] = -382.09574150537,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [10] = {
        ["x"] = 637.34575554476,
        ["y"] = -366.74862279186,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [17] = {
    ["name"] = "Nokhud Neophyte",
    ["id"] = 196263,
    ["count"] = 5,
    ["health"] = 6713011,
    ["scale"] = 1,
    ["displayId"] = 108223,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [386012] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 528.18718210083,
        ["y"] = -437.17067946461,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 529.13534322565,
        ["y"] = -475.49141908511,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 614.05875039995,
        ["y"] = -504.58515512194,
        ["g"] = 14,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 623.66032374168,
        ["y"] = -489.91050479647,
        ["g"] = 14,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 699.88535937445,
        ["y"] = -448.93149531822,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [6] = {
        ["x"] = 714.41364418207,
        ["y"] = -452.42840059021,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [18] = {
    ["name"] = "Stormcaller Solongo",
    ["id"] = 194315,
    ["count"] = 10,
    ["health"] = 10740817,
    ["scale"] = 1,
    ["displayId"] = 108818,
    ["iconTexture"] = 136048,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [386012] = {
      },
      [387145] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 587.58592676919,
        ["y"] = -465.61398435038,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["scale"] = 2.4,
      },
    },
  },
  [19] = {
    ["name"] = "Primal Gust",
    ["id"] = 195579,
    ["count"] = 0,
    ["health"] = 2685204,
    ["scale"] = 1,
    ["displayId"] = 102511,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [386319] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 601.4361340159,
        ["y"] = -431.44901261575,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [2] = {
        ["x"] = 609.49874964682,
        ["y"] = -427.11427276579,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [3] = {
        ["x"] = 604.59470579592,
        ["y"] = -416.8438760083,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [4] = {
        ["x"] = 598.19090054472,
        ["y"] = -422.54182928752,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
    },
  },
  [20] = {
    ["name"] = "Stormcaller Zarii",
    ["id"] = 194316,
    ["count"] = 10,
    ["health"] = 10740817,
    ["scale"] = 1,
    ["displayId"] = 108818,
    ["iconTexture"] = 136048,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [386012] = {
      },
      [387145] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 681.99881682077,
        ["y"] = -482.36209293677,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["scale"] = 2.4,
      },
    },
  },
  [21] = {
    ["name"] = "The Raging Tempest",
    ["id"] = 186615,
    ["count"] = 0,
    ["health"] = 66919390,
    ["scale"] = 1,
    ["displayId"] = 107145,
    ["creatureType"] = "Elemental",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 2497,
    ["instanceID"] = 1198,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [382628] = {
      },
      [384185] = {
      },
      [384186] = {
      },
      [384316] = {
      },
      [384620] = {
      },
      [384628] = {
      },
      [384686] = {
      },
      [384687] = {
      },
      [384761] = {
      },
      [386914] = {
      },
      [386915] = {
      },
      [386916] = {
      },
      [391967] = {
      },
      [394875] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 646.66698682159,
        ["y"] = -424.82493730035,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
      },
    },
  },
  [22] = {
    ["name"] = "Ukhel Corruptor",
    ["id"] = 195842,
    ["count"] = 5,
    ["health"] = 6713011,
    ["scale"] = 1,
    ["displayId"] = 109006,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [387608] = {
      },
      [387611] = {
      },
      [387613] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 325.84125926815,
        ["y"] = -408.26424068891,
        ["g"] = 29,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 318.58361165643,
        ["y"] = -422.0427368402,
        ["g"] = 29,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 206.0768102459,
        ["y"] = -474.79079543986,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 155.2382347869,
        ["y"] = -389.18803597929,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 137.43845816631,
        ["y"] = -414.5630726741,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [6] = {
        ["x"] = 171.49753868338,
        ["y"] = -329.27413392415,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [7] = {
        ["x"] = 223.17560824603,
        ["y"] = -417.04309872254,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [8] = {
        ["x"] = 237.69809084039,
        ["y"] = -423.46558211687,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [9] = {
        ["x"] = 230.79282615545,
        ["y"] = -458.28482122082,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [10] = {
        ["x"] = 177.68914621379,
        ["y"] = -342.07867944721,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
        ["patrol"] = {
          [1] = {
            ["x"] = 177.68914621379,
            ["y"] = -342.07867944721,
          },
          [2] = {
            ["x"] = 190.36039819572,
            ["y"] = -338.71716857974,
          },
          [3] = {
            ["x"] = 206.2370501361,
            ["y"] = -336.22671686617,
          },
          [4] = {
            ["x"] = 215.57621734229,
            ["y"] = -336.53805450332,
          },
          [5] = {
            ["x"] = 223.67021213106,
            ["y"] = -339.65111023872,
          },
          [6] = {
            ["x"] = 232.0754733045,
            ["y"] = -341.2076202933,
          },
          [7] = {
            ["x"] = 223.67021213106,
            ["y"] = -339.65111023872,
          },
          [8] = {
            ["x"] = 215.57621734229,
            ["y"] = -336.53805450332,
          },
          [9] = {
            ["x"] = 206.2370501361,
            ["y"] = -336.22671686617,
          },
          [10] = {
            ["x"] = 190.36039819572,
            ["y"] = -338.71716857974,
          },
          [11] = {
            ["x"] = 177.68914621379,
            ["y"] = -342.07867944721,
          },
          [12] = {
            ["x"] = 159.85230235863,
            ["y"] = -342.76418378724,
          },
          [13] = {
            ["x"] = 146.46613775805,
            ["y"] = -346.4998791707,
          },
          [14] = {
            ["x"] = 134.63644758582,
            ["y"] = -351.1694627738,
          },
          [15] = {
            ["x"] = 124.98597836871,
            ["y"] = -357.70687625552,
          },
          [16] = {
            ["x"] = 111.9110623397,
            ["y"] = -372.96094198717,
          },
          [17] = {
            ["x"] = 124.98597836871,
            ["y"] = -357.70687625552,
          },
          [18] = {
            ["x"] = 134.63644758582,
            ["y"] = -351.1694627738,
          },
          [19] = {
            ["x"] = 146.46613775805,
            ["y"] = -346.4998791707,
          },
          [20] = {
            ["x"] = 159.85230235863,
            ["y"] = -342.76418378724,
          },
        },
      },
      [11] = {
        ["x"] = 219.51216214297,
        ["y"] = -389.73198766598,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [23] = {
    ["name"] = "Soulharvester Galtmaa",
    ["id"] = 195927,
    ["count"] = 10,
    ["health"] = 10740817,
    ["scale"] = 1,
    ["displayId"] = 109014,
    ["iconTexture"] = 136214,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [387411] = {
      },
      [388318] = {
      },
      [395035] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 304.07532167275,
        ["y"] = -380.63303373332,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["scale"] = 2.4,
      },
    },
  },
  [24] = {
    ["name"] = "Ukhel Beastcaller",
    ["id"] = 195878,
    ["count"] = 6,
    ["health"] = 13426021,
    ["scale"] = 1,
    ["displayId"] = 109021,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [387440] = {
      },
      [387826] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 321.49416291281,
        ["y"] = -469.46746243925,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 289.49925279185,
        ["y"] = -490.45593250811,
        ["g"] = 32,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 190.07381309824,
        ["y"] = -507.51175883978,
        ["g"] = 34,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 247.20142269404,
        ["y"] = -318.13423855209,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [25] = {
    ["name"] = "Desecrated Ohuna",
    ["id"] = 195876,
    ["count"] = 2,
    ["health"] = 5370409,
    ["scale"] = 1,
    ["displayId"] = 109019,
    ["creatureType"] = "Undead",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Shackle Undead"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Turn Evil"] = true,
    },
    ["spells"] = {
      [387629] = {
      },
      [436841] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 305.07132274924,
        ["y"] = -363.12285707626,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [2] = {
        ["x"] = 319.80498434914,
        ["y"] = -369.48820111042,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [3] = {
        ["x"] = 333.82559176286,
        ["y"] = -465.73549656886,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [4] = {
        ["x"] = 293.67020555665,
        ["y"] = -440.77432427914,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [5] = {
        ["x"] = 282.11950555378,
        ["y"] = -431.90358344489,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [6] = {
        ["x"] = 280.50313879367,
        ["y"] = -445.41019115341,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
        ["patrol"] = {
          [1] = {
            ["x"] = 280.50313879367,
            ["y"] = -445.41019115341,
          },
          [2] = {
            ["x"] = 276.7052851747,
            ["y"] = -462.30595510398,
          },
          [3] = {
            ["x"] = 276.7052851747,
            ["y"] = -468.84340421192,
          },
          [4] = {
            ["x"] = 279.81834091009,
            ["y"] = -496.23839978082,
          },
          [5] = {
            ["x"] = 276.0826099004,
            ["y"] = -503.39847072372,
          },
          [6] = {
            ["x"] = 265.4981990243,
            ["y"] = -519.89772668593,
          },
          [7] = {
            ["x"] = 252.73460281932,
            ["y"] = -520.52033070776,
          },
          [8] = {
            ["x"] = 235.30147645059,
            ["y"] = -522.07687638858,
          },
          [9] = {
            ["x"] = 214.44392108308,
            ["y"] = -514.29419251729,
          },
          [10] = {
            ["x"] = 181.13410714775,
            ["y"] = -486.27658402,
          },
          [11] = {
            ["x"] = 166.50266325104,
            ["y"] = -460.74944504939,
          },
          [12] = {
            ["x"] = 152.49382337616,
            ["y"] = -438.33534400107,
          },
          [13] = {
            ["x"] = 146.26771190536,
            ["y"] = -395.68634504642,
          },
          [14] = {
            ["x"] = 172.41747271092,
            ["y"] = -385.10188073097,
          },
          [15] = {
            ["x"] = 200.12377919729,
            ["y"] = -379.18707127109,
          },
          [16] = {
            ["x"] = 236.85802213141,
            ["y"] = -390.08276634499,
          },
          [17] = {
            ["x"] = 258.02687950984,
            ["y"] = -367.66871873601,
          },
          [18] = {
            ["x"] = 293.51580752159,
            ["y"] = -359.57477738659,
          },
          [19] = {
            ["x"] = 303.78891638677,
            ["y"] = -379.49839109512,
          },
          [20] = {
            ["x"] = 302.23244195842,
            ["y"] = -407.5159817793,
          },
          [21] = {
            ["x"] = 296.62886325699,
            ["y"] = -420.59086218208,
          },
        },
      },
      [7] = {
        ["x"] = 244.47634510866,
        ["y"] = -377.58902732879,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [8] = {
        ["x"] = 234.10754398403,
        ["y"] = -322.72702009587,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [9] = {
        ["x"] = 259.5996534537,
        ["y"] = -323.29624407525,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [10] = {
        ["x"] = 229.8253932461,
        ["y"] = -375.66812826562,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [11] = {
        ["x"] = 296.70222939415,
        ["y"] = -504.18620207974,
        ["g"] = 32,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
    },
  },
  [26] = {
    ["name"] = "Desecrated Bakar",
    ["id"] = 195875,
    ["count"] = 1,
    ["health"] = 1678253,
    ["scale"] = 1,
    ["displayId"] = 109018,
    ["creatureType"] = "Undead",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Shackle Undead"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Turn Evil"] = true,
    },
    ["spells"] = {
    },
    ["clones"] = {
      [1] = {
        ["x"] = 326.05721945306,
        ["y"] = -481.48591022142,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [2] = {
        ["x"] = 336.57796037073,
        ["y"] = -477.09015301746,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [3] = {
        ["x"] = 194.15016177796,
        ["y"] = -522.69857049415,
        ["g"] = 34,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [4] = {
        ["x"] = 178.71544961749,
        ["y"] = -512.25211792171,
        ["g"] = 34,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [5] = {
        ["x"] = 200.95073249252,
        ["y"] = -515.38772108573,
        ["g"] = 34,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [6] = {
        ["x"] = 183.20041451236,
        ["y"] = -522.39128124109,
        ["g"] = 34,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [7] = {
        ["x"] = 241.01386478867,
        ["y"] = -333.01654870485,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [8] = {
        ["x"] = 251.67842905827,
        ["y"] = -332.80121940825,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
    },
  },
  [27] = {
    ["name"] = "Risen Mystic",
    ["id"] = 195877,
    ["count"] = 5,
    ["health"] = 6041710,
    ["scale"] = 1,
    ["displayId"] = 109020,
    ["creatureType"] = "Undead",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Shackle Undead"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Turn Evil"] = true,
    },
    ["spells"] = {
      [387596] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 270.2943799811,
        ["y"] = -411.48789422611,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 263.19659550596,
        ["y"] = -484.75613100452,
        ["g"] = 32,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 263.23751542409,
        ["y"] = -530.01198587259,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 228.05570581918,
        ["y"] = -471.40534898704,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 162.44609325213,
        ["y"] = -441.48751896995,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [6] = {
        ["x"] = 189.45759932441,
        ["y"] = -410.23961249036,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [7] = {
        ["x"] = 158.15134896274,
        ["y"] = -325.46017255917,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [8] = {
        ["x"] = 140.02121832627,
        ["y"] = -390.6476822541,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [28] = {
    ["name"] = "Ukhel Deathspeaker",
    ["id"] = 195851,
    ["count"] = 6,
    ["health"] = 8055613,
    ["scale"] = 1,
    ["displayId"] = 109035,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [387614] = {
      },
      [387615] = {
      },
      [387616] = {
      },
      [396376] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 286.51052709556,
        ["y"] = -410.42636225483,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
        ["patrol"] = {
          [1] = {
            ["x"] = 286.51052709556,
            ["y"] = -410.42636225483,
          },
          [2] = {
            ["x"] = 295.38369083956,
            ["y"] = -420.90216419299,
          },
          [3] = {
            ["x"] = 296.00625923516,
            ["y"] = -429.30744317956,
          },
          [4] = {
            ["x"] = 288.22360208354,
            ["y"] = -452.96675227155,
          },
          [5] = {
            ["x"] = 279.81834091009,
            ["y"] = -467.59819616826,
          },
          [6] = {
            ["x"] = 259.89469157534,
            ["y"] = -472.89040160631,
          },
          [7] = {
            ["x"] = 245.57458531577,
            ["y"] = -469.46602604687,
          },
          [8] = {
            ["x"] = 237.79192816416,
            ["y"] = -446.74062298763,
          },
          [9] = {
            ["x"] = 237.79192816416,
            ["y"] = -435.22228826567,
          },
          [10] = {
            ["x"] = 245.57458531577,
            ["y"] = -407.8272659771,
          },
          [11] = {
            ["x"] = 249.62154708392,
            ["y"] = -403.15766456088,
          },
          [12] = {
            ["x"] = 263.0077116845,
            ["y"] = -384.47929452225,
          },
        },
      },
      [2] = {
        ["x"] = 277.33792563429,
        ["y"] = -481.95177046,
        ["g"] = 32,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 275.18253395385,
        ["y"] = -516.67707748718,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 213.95930895535,
        ["y"] = -462.02091477102,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["scale"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 213.95930895535,
            ["y"] = -462.02091477102,
          },
          [2] = {
            ["x"] = 204.68050445528,
            ["y"] = -448.29716866845,
          },
          [3] = {
            ["x"] = 200.32220504998,
            ["y"] = -441.75973737362,
          },
          [4] = {
            ["x"] = 197.20911368835,
            ["y"] = -430.86397104726,
          },
          [5] = {
            ["x"] = 200.32220504998,
            ["y"] = -441.75973737362,
          },
          [6] = {
            ["x"] = 204.68050445528,
            ["y"] = -448.29716866845,
          },
          [7] = {
            ["x"] = 213.95930895535,
            ["y"] = -462.02091477102,
          },
          [8] = {
            ["x"] = 224.91545580096,
            ["y"] = -482.85222627369,
          },
          [9] = {
            ["x"] = 226.16066384462,
            ["y"] = -499.97409516429,
          },
          [10] = {
            ["x"] = 221.49106242841,
            ["y"] = -512.42635373212,
          },
          [11] = {
            ["x"] = 226.16066384462,
            ["y"] = -499.97409516429,
          },
          [12] = {
            ["x"] = 224.91545580096,
            ["y"] = -482.85222627369,
          },
        },
      },
      [5] = {
        ["x"] = 190.38411520345,
        ["y"] = -441.1858362484,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [6] = {
        ["x"] = 252.23674749573,
        ["y"] = -390.91719475209,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [7] = {
        ["x"] = 320.39424536316,
        ["y"] = -381.95896665073,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [29] = {
    ["name"] = "Risen Warrior",
    ["id"] = 195855,
    ["count"] = 5,
    ["health"] = 6713011,
    ["scale"] = 1,
    ["displayId"] = 109017,
    ["creatureType"] = "Undead",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Shackle Undead"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Turn Evil"] = true,
    },
    ["spells"] = {
      [388801] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 277.21002663947,
        ["y"] = -397.91961047376,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 248.70873730885,
        ["y"] = -527.60036590901,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 217.85387218231,
        ["y"] = -480.31657673017,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 176.50311920312,
        ["y"] = -443.81319583279,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 189.86983078101,
        ["y"] = -425.27781955104,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [6] = {
        ["x"] = 172.79589892653,
        ["y"] = -354.63448709313,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [7] = {
        ["x"] = 130.65521961757,
        ["y"] = -401.53392403792,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [8] = {
        ["x"] = 241.90572674634,
        ["y"] = -513.27450349811,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [9] = {
        ["x"] = 290.23066907902,
        ["y"] = -370.13714790613,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [30] = {
    ["name"] = "Soulharvester Tumen",
    ["id"] = 195929,
    ["count"] = 10,
    ["health"] = 10740817,
    ["scale"] = 1,
    ["displayId"] = 109036,
    ["iconTexture"] = 136214,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [387411] = {
      },
      [388318] = {
      },
      [395035] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 258.66919682705,
        ["y"] = -509.76228576678,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["scale"] = 2.4,
      },
    },
  },
  [31] = {
    ["name"] = "Soulharvester Mandakh",
    ["id"] = 195930,
    ["count"] = 10,
    ["health"] = 10740817,
    ["scale"] = 1,
    ["displayId"] = 109037,
    ["iconTexture"] = 136214,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [387411] = {
      },
      [388318] = {
      },
      [395035] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 151.27567764635,
        ["y"] = -405.39387324041,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["scale"] = 2.4,
      },
    },
  },
  [32] = {
    ["name"] = "Soulharvester Duuren",
    ["id"] = 195928,
    ["count"] = 10,
    ["health"] = 10740817,
    ["scale"] = 1,
    ["displayId"] = 109015,
    ["iconTexture"] = 136214,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [387411] = {
      },
      [388318] = {
      },
      [395035] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 234.75906461127,
        ["y"] = -391.03347101889,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["scale"] = 2.4,
      },
    },
  },
  [33] = {
    ["name"] = "Teera",
    ["id"] = 186339,
    ["count"] = 0,
    ["health"] = 66919390,
    ["scale"] = 1,
    ["displayId"] = 105721,
    ["creatureType"] = "Undead",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 2478,
    ["instanceID"] = 537,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [345561] = {
      },
      [382670] = {
      },
      [384808] = {
      },
      [385434] = {
      },
      [386016] = {
      },
      [386411] = {
      },
      [386547] = {
      },
      [392151] = {
      },
      [392198] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 119.56229309837,
        ["y"] = -522.44162985071,
        ["g"] = 35,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
      },
    },
  },
  [34] = {
    ["name"] = "Maruuk",
    ["id"] = 186338,
    ["count"] = 0,
    ["health"] = 66919390,
    ["scale"] = 1,
    ["displayId"] = 105722,
    ["creatureType"] = "Undead",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 2478,
    ["instanceID"] = 537,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [345561] = {
      },
      [382836] = {
      },
      [385339] = {
      },
      [386063] = {
      },
      [392198] = {
      },
      [395669] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 94.808142284973,
        ["y"] = -488.4832582642,
        ["g"] = 35,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
      },
    },
  },
  [35] = {
    ["name"] = "Batak",
    ["id"] = 193462,
    ["count"] = 16,
    ["health"] = 16111226,
    ["scale"] = 1,
    ["displayId"] = 108221,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [373395] = {
      },
      [382233] = {
      },
      [383067] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 197.16536123039,
        ["y"] = -112.6827510673,
        ["g"] = 41,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
      },
    },
  },
  [36] = {
    ["name"] = "Balara",
    ["id"] = 193457,
    ["count"] = 16,
    ["health"] = 16111226,
    ["scale"] = 1,
    ["displayId"] = 108222,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [372147] = {
      },
      [374711] = {
      },
      [382267] = {
      },
      [382274] = {
      },
      [382277] = {
      },
      [383067] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 196.45434449669,
        ["y"] = -131.95591459466,
        ["g"] = 41,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
      },
    },
  },
  [37] = {
    ["name"] = "Balakar Khan",
    ["id"] = 186151,
    ["count"] = 0,
    ["health"] = 53535512,
    ["scale"] = 1,
    ["displayId"] = 107680,
    ["creatureType"] = "Humanoid",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 2477,
    ["instanceID"] = 1198,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [375929] = {
      },
      [375937] = {
      },
      [375943] = {
      },
      [376634] = {
      },
      [376644] = {
      },
      [376660] = {
      },
      [376683] = {
      },
      [376685] = {
      },
      [376724] = {
      },
      [376727] = {
      },
      [376827] = {
      },
      [376829] = {
      },
      [376864] = {
      },
      [376865] = {
      },
      [376866] = {
      },
      [376892] = {
      },
      [376894] = {
      },
      [376896] = {
      },
      [393421] = {
      },
      [393425] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 139.81259789612,
        ["y"] = -113.56998118293,
        ["sublevel"] = 1,
        ["scale"] = 2.4,
      },
    },
  },
  [38] = {
    ["name"] = "Nokhud Defender",
    ["id"] = 199717,
    ["count"] = 10,
    ["health"] = 12419070,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 108529,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [373395] = {
      },
      [384336] = {
      },
      [384510] = {
      },
      [384512] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 349.13090828289,
        ["y"] = -145.99198890581,
        ["g"] = 36,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [2] = {
        ["x"] = 349.68471805392,
        ["y"] = -130.83256277332,
        ["g"] = 36,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [3] = {
        ["x"] = 277.34841066099,
        ["y"] = -132.82352185936,
        ["g"] = 39,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [4] = {
        ["x"] = 278.05742209925,
        ["y"] = -114.5658658061,
        ["g"] = 39,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [5] = {
        ["x"] = 252.17860318294,
        ["y"] = -130.15238436222,
        ["g"] = 40,
        ["sublevel"] = 1,
        ["scale"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 252.17860318294,
            ["y"] = -130.15238436222,
          },
          [2] = {
            ["x"] = 262.8468985228,
            ["y"] = -128.10171686617,
          },
          [3] = {
            ["x"] = 275.29915709063,
            ["y"] = -123.74341746087,
          },
          [4] = {
            ["x"] = 262.8468985228,
            ["y"] = -128.10171686617,
          },
          [5] = {
            ["x"] = 237.31977736531,
            ["y"] = -129.65826254699,
          },
          [6] = {
            ["x"] = 221.4430897987,
            ["y"] = -127.79045048149,
          },
          [7] = {
            ["x"] = 206.18907750638,
            ["y"] = -122.80951142812,
          },
          [8] = {
            ["x"] = 221.4430897987,
            ["y"] = -127.79045048149,
          },
          [9] = {
            ["x"] = 237.31977736531,
            ["y"] = -129.65826254699,
          },
        },
      },
      [6] = {
        ["x"] = 202.53091064411,
        ["y"] = -50.51336527531,
        ["g"] = 43,
        ["sublevel"] = 1,
        ["scale"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 202.53091064411,
            ["y"] = -50.51336527531,
          },
          [2] = {
            ["x"] = 204.05790047798,
            ["y"] = -39.690632879795,
          },
          [3] = {
            ["x"] = 206.54831656531,
            ["y"] = -27.238338685734,
          },
          [4] = {
            ["x"] = 204.05790047798,
            ["y"] = -39.690632879795,
          },
          [5] = {
            ["x"] = 202.53091064411,
            ["y"] = -50.51336527531,
          },
          [6] = {
            ["x"] = 197.5204157438,
            ["y"] = -63.97254599362,
          },
          [7] = {
            ["x"] = 195.96387006298,
            ["y"] = -72.3778427933,
          },
          [8] = {
            ["x"] = 196.27524332636,
            ["y"] = -78.603954264099,
          },
          [9] = {
            ["x"] = 195.96387006298,
            ["y"] = -72.3778427933,
          },
          [10] = {
            ["x"] = 197.5204157438,
            ["y"] = -63.97254599362,
          },
        },
      },
      [7] = {
        ["x"] = 201.44977480606,
        ["y"] = -18.62679742049,
        ["g"] = 44,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [8] = {
        ["x"] = 218.0008672034,
        ["y"] = -21.038536822449,
        ["g"] = 44,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [9] = {
        ["x"] = 187.11390410183,
        ["y"] = -214.72233879413,
        ["g"] = 46,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [10] = {
        ["x"] = 203.46091793465,
        ["y"] = -210.3933922836,
        ["g"] = 46,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [11] = {
        ["x"] = 185.1194794166,
        ["y"] = -180.71334987763,
        ["g"] = 45,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [12] = {
        ["x"] = 188.44963584084,
        ["y"] = -253.70259682937,
        ["g"] = 47,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [13] = {
        ["x"] = 204.9320149351,
        ["y"] = -250.39717324279,
        ["g"] = 47,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
    },
  },
  [39] = {
    ["name"] = "Nokhud Thunderfist",
    ["id"] = 193373,
    ["count"] = 5,
    ["health"] = 6713011,
    ["scale"] = 1,
    ["displayId"] = 110840,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [381530] = {
      },
      [397394] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 326.8844282343,
        ["y"] = -158.26130910202,
        ["g"] = 37,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [2] = {
        ["x"] = 234.68420946739,
        ["y"] = -147.00588781222,
        ["g"] = 40,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [3] = {
        ["x"] = 232.96708243271,
        ["y"] = -112.79089317262,
        ["g"] = 40,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [4] = {
        ["x"] = 212.57952407329,
        ["y"] = -57.397016837998,
        ["g"] = 43,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [5] = {
        ["x"] = 180.88219887877,
        ["y"] = -61.064793114656,
        ["g"] = 43,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [6] = {
        ["x"] = 204.00894112159,
        ["y"] = -164.19564220962,
        ["g"] = 45,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [7] = {
        ["x"] = 168.61859218252,
        ["y"] = -163.40795667807,
        ["g"] = 45,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [8] = {
        ["x"] = 214.9696946596,
        ["y"] = -92.551882878106,
        ["g"] = 42,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [9] = {
        ["x"] = 226.63244511729,
        ["y"] = -88.344788114942,
        ["g"] = 42,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [10] = {
        ["x"] = 310.5967180307,
        ["y"] = -118.98421896292,
        ["g"] = 38,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
    },
  },
};
