local MDT = MDT
local L = MDT.L
local dungeonIndex = 9
MDT.dungeonList[dungeonIndex] = L["Return to Karazhan Lower"]
MDT.dungeonTotalCount[dungeonIndex] = { normal = 420, teeming = 504, teemingEnabled = true }

MDT.mapInfo[dungeonIndex] = {
  viewportPositionOverrides =
  {
    [1] = {
      zoomScale = 1.2999999523163;
      horizontalPan = 78.003474839972;
      verticalPan = 32.294165083552;
    };
    [2] = {
      zoomScale = 1.2999999523163;
      horizontalPan = 137.99641255679;
      verticalPan = 85.576163891348;
    };
    [4] = {
      zoomScale = 1.5999999046326;
      horizontalPan = 145.48786850778;
      verticalPan = 191.08311735375;
    };
  }
};

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "LegionKarazhanDungeon",
  [1] = "LegionKarazhanDungeon6_",
  [2] = "LegionKarazhanDungeon5_",
  [3] = "LegionKarazhanDungeon4_",
  [4] = "LegionKarazhanDungeon3_",
  [5] = "LegionKarazhanDungeon2_",
  [6] = "LegionKarazhanDungeon1_",
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["Master's Terrace"],
  [2] = L["Opera Hall Balcony"],
  [3] = L["The Guest Chambers"],
  [4] = L["The Banquet Hall"],
  [5] = L["Upper Livery Stables"],
  [6] = L["The Servant's Quarters"],
}

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "DeathReleasePinTemplate";
      ["type"] = "graveyard";
      ["x"] = 507.90371827563;
      ["y"] = -357.94827464381;
      ["graveyardDescription"] = "";
    };
    [2] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 339.16340178117;
      ["y"] = -69.875496528164;
      ["target"] = 2;
      ["direction"] = -1;
      ["connectionIndex"] = 1;
    };
    [3] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 449.86358195137;
      ["y"] = -386.08905489225;
      ["target"] = 3;
      ["direction"] = 2;
      ["connectionIndex"] = 8;
    };
    [4] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 496.5639116014;
      ["y"] = -439.57335604034;
      ["target"] = 5;
      ["direction"] = -1;
      ["connectionIndex"] = 9;
    };
  };
  [2] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 564.18540047666;
      ["y"] = -129.30423423358;
      ["target"] = 1;
      ["direction"] = 1;
      ["connectionIndex"] = 1;
    };
    [2] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 351.95696188742;
      ["y"] = -469.33894415751;
      ["target"] = 3;
      ["direction"] = -2;
      ["connectionIndex"] = 2;
    };
  };
  [3] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 374.23500819301;
      ["y"] = -158.61765790408;
      ["target"] = 6;
      ["direction"] = -1;
      ["connectionIndex"] = 3;
    };
    [2] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 602.29275731825;
      ["y"] = -243.03997992693;
      ["target"] = 4;
      ["direction"] = -1;
      ["connectionIndex"] = 4;
    };
    [3] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 199.52760161393;
      ["y"] = -277.04345382679;
      ["target"] = 2;
      ["direction"] = 2;
      ["connectionIndex"] = 2;
    };
    [4] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 444.00087038011;
      ["y"] = -468.75267079235;
      ["target"] = 1;
      ["direction"] = -2;
      ["connectionIndex"] = 8;
    };
  };
  [4] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 595.84385510135;
      ["y"] = -210.79530111014;
      ["target"] = 3;
      ["direction"] = 1;
      ["connectionIndex"] = 4;
    };
    [2] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 440.48313904223;
      ["y"] = -512.72268264472;
      ["target"] = 6;
      ["direction"] = -1;
      ["connectionIndex"] = 5;
    };
    [3] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 333.19644588235;
      ["y"] = -483.40933116132;
      ["target"] = 5;
      ["direction"] = -1;
      ["connectionIndex"] = 7;
    };
  };
  [5] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 205.97642060718;
      ["y"] = -406.60843851149;
      ["target"] = 6;
      ["direction"] = -1;
      ["connectionIndex"] = 6;
    };
    [2] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 329.09257461962;
      ["y"] = -56.020965296348;
      ["target"] = 4;
      ["direction"] = 1;
      ["connectionIndex"] = 7;
    };
    [3] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 456.76474025589;
      ["y"] = -404.5983988518;
      ["target"] = 1;
      ["direction"] = 1;
      ["connectionIndex"] = 9;
    };
  };
  [6] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 308.57313508235;
      ["y"] = -68.33255721708;
      ["target"] = 3;
      ["direction"] = 1;
      ["connectionIndex"] = 3;
    };
    [2] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 446.93210835203;
      ["y"] = -360.293305598;
      ["target"] = 4;
      ["direction"] = 1;
      ["connectionIndex"] = 5;
    };
    [3] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["x"] = 320.29849113197;
      ["y"] = -443.54317923665;
      ["target"] = 5;
      ["direction"] = 1;
      ["connectionIndex"] = 6;
    };
  };
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Forlorn Spirit";
    ["id"] = 114626;
    ["count"] = 5;
    ["health"] = 340880;
    ["scale"] = 1;
    ["displayId"] = 26404;
    ["creatureType"] = "Undead";
    ["level"] = 111;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [228252] = {
      };
      [228254] = {
      };
      [228255] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 466.15596558832;
        ["y"] = -324.23342732763;
        ["sublevel"] = 1;
        ["scale"] = 2.5;
      };
      [2] = {
        ["x"] = 503.88323720501;
        ["y"] = -300.59703923951;
        ["sublevel"] = 1;
        ["scale"] = 2.5;
      };
    };
  };
  [2] = {
    ["name"] = "Spectral Patron";
    ["id"] = 114541;
    ["count"] = 1;
    ["health"] = 85220;
    ["scale"] = 1;
    ["displayId"] = 16555;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Root"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [227981] = {
      };
      [227983] = {
      };
      [228014] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 263.29146003598;
        ["y"] = -200.58280451202;
        ["g"] = 1;
        ["sublevel"] = 1;
        ["scale"] = 2;
        ["disguised"] = true;
      };
      [2] = {
        ["x"] = 268.3810873401;
        ["y"] = -216.82076235876;
        ["g"] = 1;
        ["sublevel"] = 1;
        ["scale"] = 2;
      };
      [3] = {
        ["x"] = 303.2948662803;
        ["y"] = -182.69864142167;
        ["g"] = 2;
        ["sublevel"] = 1;
        ["scale"] = 2;
      };
      [4] = {
        ["x"] = 317.45918868422;
        ["y"] = -199.6408785237;
        ["g"] = 2;
        ["sublevel"] = 1;
        ["scale"] = 2;
      };
      [5] = {
        ["x"] = 366.88813827893;
        ["y"] = -162.38524509567;
        ["sublevel"] = 1;
        ["scale"] = 2;
        ["patrolFacing"] = 1.9634954084936;
        ["patrolFacing2"] = 5.5959619142068;
        ["patrol"] = {
          [1] = {
            ["x"] = 349.01300707718;
            ["y"] = -185.21377354235;
          };
          [2] = {
            ["x"] = 367.83290015132;
            ["y"] = -160.48390627053;
          };
          [3] = {
            ["x"] = 367.20485826385;
            ["y"] = -119.31822251313;
          };
          [4] = {
            ["x"] = 354.28784279582;
            ["y"] = -99.318170978819;
          };
          [5] = {
            ["x"] = 312.70469236654;
            ["y"] = -77.954590426884;
          };
          [6] = {
            ["x"] = 286.98795027105;
            ["y"] = -74.772729564397;
          };
          [7] = {
            ["x"] = 312.70469236654;
            ["y"] = -77.954590426884;
          };
          [8] = {
            ["x"] = 354.28784279582;
            ["y"] = -99.318170978819;
          };
          [9] = {
            ["x"] = 367.20485826385;
            ["y"] = -119.31822251313;
          };
          [10] = {
            ["x"] = 367.83290015132;
            ["y"] = -160.48390627053;
          };
          [11] = {
            ["x"] = 349.01300707718;
            ["y"] = -185.21377354235;
          };
          [12] = {
            ["x"] = 305.17971330135;
            ["y"] = -207.60019864878;
          };
          [13] = {
            ["x"] = 268.36150577428;
            ["y"] = -204.41839630722;
          };
          [14] = {
            ["x"] = 305.17971330135;
            ["y"] = -207.60019864878;
          };
        };
      };
      [6] = {
        ["x"] = 353.69541382333;
        ["y"] = -123.55843902041;
        ["g"] = 4;
        ["sublevel"] = 1;
        ["scale"] = 2;
      };
      [7] = {
        ["x"] = 361.07475587797;
        ["y"] = -108.6375792582;
        ["g"] = 4;
        ["sublevel"] = 1;
        ["scale"] = 2;
        ["disguised"] = true;
      };
      [8] = {
        ["x"] = 442.26436254108;
        ["y"] = -117.38363990808;
        ["g"] = 5;
        ["sublevel"] = 2;
        ["scale"] = 2.3;
      };
      [9] = {
        ["x"] = 428.23115090654;
        ["y"] = -132.24205768969;
        ["g"] = 5;
        ["sublevel"] = 2;
        ["scale"] = 2.3;
      };
      [10] = {
        ["x"] = 601.99993068955;
        ["y"] = -216.49449563393;
        ["g"] = 6;
        ["sublevel"] = 2;
        ["scale"] = 2.3;
      };
      [11] = {
        ["x"] = 599.37515821756;
        ["y"] = -234.19843265543;
        ["g"] = 6;
        ["sublevel"] = 2;
        ["scale"] = 2.3;
      };
      [12] = {
        ["x"] = 610.59667885;
        ["y"] = -253.42914685998;
        ["g"] = 6;
        ["sublevel"] = 2;
        ["scale"] = 2.3;
        ["inspiring"] = true;
      };
      [13] = {
        ["x"] = 602.3413935779;
        ["y"] = -408.02521585447;
        ["g"] = 7;
        ["sublevel"] = 2;
        ["scale"] = 2.3;
      };
      [14] = {
        ["x"] = 584.17361957969;
        ["y"] = -401.50798081189;
        ["g"] = 7;
        ["sublevel"] = 2;
        ["scale"] = 2.3;
      };
      [15] = {
        ["x"] = 583.43928915368;
        ["y"] = -422.15347479669;
        ["g"] = 7;
        ["sublevel"] = 2;
        ["scale"] = 2.3;
      };
      [16] = {
        ["x"] = 495.39154491472;
        ["y"] = -478.01756356539;
        ["g"] = 8;
        ["sublevel"] = 2;
        ["scale"] = 2.3;
      };
      [17] = {
        ["x"] = 510.2889672621;
        ["y"] = -494.54177979379;
        ["g"] = 8;
        ["sublevel"] = 2;
        ["scale"] = 2.3;
        ["disguised"] = true;
      };
      [18] = {
        ["x"] = 353.03761765242;
        ["y"] = -155.22728655249;
        ["g"] = 96;
        ["sublevel"] = 1;
        ["teeming"] = true;
      };
      [19] = {
        ["x"] = 344.8557686349;
        ["y"] = -145.22729004579;
        ["g"] = 96;
        ["sublevel"] = 1;
        ["teeming"] = true;
      };
      [20] = {
        ["x"] = 353.94668164352;
        ["y"] = -135.68182553465;
        ["g"] = 96;
        ["sublevel"] = 1;
        ["teeming"] = true;
      };
      [21] = {
        ["x"] = 226.06819626393;
        ["y"] = -208.95803809844;
        ["g"] = 22;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [22] = {
        ["x"] = 223.7239846725;
        ["y"] = -216.61384697545;
        ["g"] = 22;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [23] = {
        ["x"] = 215.82901647776;
        ["y"] = -235.61144664605;
        ["g"] = 22;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [24] = {
        ["x"] = 219.23103491096;
        ["y"] = -225.95920809184;
        ["g"] = 22;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [25] = {
        ["x"] = 227.84451867223;
        ["y"] = -240.81726616443;
        ["g"] = 22;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [26] = {
        ["x"] = 231.81637423859;
        ["y"] = -232.41909656005;
        ["g"] = 22;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [27] = {
        ["x"] = 234.01660925193;
        ["y"] = -224.35635060078;
        ["g"] = 22;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [28] = {
        ["x"] = 237.93982015409;
        ["y"] = -211.38790503841;
        ["g"] = 22;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [29] = {
        ["x"] = 245.69189399888;
        ["y"] = -219.97764419581;
        ["g"] = 22;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["inspiring"] = true;
      };
      [30] = {
        ["x"] = 255.12433184584;
        ["y"] = -245.98621065886;
        ["g"] = 23;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [31] = {
        ["x"] = 258.7369137574;
        ["y"] = -235.00370975865;
        ["g"] = 23;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [32] = {
        ["x"] = 266.7145006715;
        ["y"] = -246.95088852328;
        ["g"] = 23;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [33] = {
        ["x"] = 265.70813834397;
        ["y"] = -230.0344415142;
        ["g"] = 23;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [34] = {
        ["x"] = 273.4602512027;
        ["y"] = -223.67086079283;
        ["g"] = 23;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [35] = {
        ["x"] = 275.05996850069;
        ["y"] = -239.55389185612;
        ["g"] = 23;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [36] = {
        ["x"] = 281.71041875779;
        ["y"] = -230.89469424714;
        ["g"] = 23;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["inspiring"] = true;
      };
      [37] = {
        ["x"] = 273.57533726022;
        ["y"] = -198.62133154456;
        ["g"] = 24;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [38] = {
        ["x"] = 269.10106456873;
        ["y"] = -188.88386361195;
        ["g"] = 24;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [39] = {
        ["x"] = 270.5512238892;
        ["y"] = -179.3233591568;
        ["g"] = 24;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [40] = {
        ["x"] = 276.10303875887;
        ["y"] = -169.32237107532;
        ["g"] = 24;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [41] = {
        ["x"] = 278.42600535674;
        ["y"] = -189.4342832182;
        ["g"] = 24;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [42] = {
        ["x"] = 285.6997414597;
        ["y"] = -175.19944360373;
        ["g"] = 24;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [43] = {
        ["x"] = 288.59469719282;
        ["y"] = -184.86602209885;
        ["g"] = 24;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [44] = {
        ["x"] = 288.40218235225;
        ["y"] = -197.06630852664;
        ["g"] = 24;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [45] = {
        ["x"] = 223.75761332826;
        ["y"] = -188.51366467071;
        ["g"] = 25;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [46] = {
        ["x"] = 221.79548426436;
        ["y"] = -178.01052264732;
        ["g"] = 25;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [47] = {
        ["x"] = 234.48231059003;
        ["y"] = -185.29539154011;
        ["g"] = 25;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [48] = {
        ["x"] = 239.34007351413;
        ["y"] = -176.87315976914;
        ["g"] = 25;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [49] = {
        ["x"] = 228.57537833359;
        ["y"] = -170.65414160461;
        ["g"] = 25;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [50] = {
        ["x"] = 223.00011053998;
        ["y"] = -162.3758751069;
        ["g"] = 25;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [51] = {
        ["x"] = 233.57480526345;
        ["y"] = -161.03649144035;
        ["g"] = 25;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [52] = {
        ["x"] = 241.89226531194;
        ["y"] = -168.60918695758;
        ["g"] = 25;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [53] = {
        ["x"] = 345.35966099311;
        ["y"] = -189.23519055961;
        ["g"] = 3;
        ["sublevel"] = 1;
        ["scale"] = 2;
        ["teeming"] = true;
      };
      [54] = {
        ["x"] = 310.28296471325;
        ["y"] = -221.68987574361;
        ["sublevel"] = 1;
        ["scale"] = 2;
        ["patrol"] = {
        };
      };
    };
  };
  [3] = {
    ["name"] = "Ghostly Philanthropist";
    ["id"] = 114542;
    ["count"] = 4;
    ["health"] = 213050;
    ["scale"] = 1;
    ["displayId"] = 73336;
    ["creatureType"] = "Undead";
    ["level"] = 111;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [227999] = {
      };
      [228001] = {
      };
      [228010] = {
      };
      [228014] = {
      };
      [228017] = {
      };
      [238566] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 284.44574948401;
        ["y"] = -220.06640666184;
        ["g"] = 1;
        ["sublevel"] = 1;
        ["scale"] = 2;
      };
      [2] = {
        ["x"] = 301.06062118417;
        ["y"] = -197.51548979032;
        ["g"] = 2;
        ["sublevel"] = 1;
        ["scale"] = 2;
      };
      [3] = {
        ["x"] = 318.04746767232;
        ["y"] = -184.18881016999;
        ["g"] = 2;
        ["sublevel"] = 1;
        ["scale"] = 2;
      };
      [4] = {
        ["x"] = 345.21828015181;
        ["y"] = -107.37448607166;
        ["g"] = 4;
        ["sublevel"] = 1;
        ["scale"] = 2;
      };
      [5] = {
        ["x"] = 437.86975882738;
        ["y"] = -152.34456217897;
        ["g"] = 5;
        ["sublevel"] = 2;
        ["scale"] = 2.3;
      };
      [6] = {
        ["x"] = 626.93225615805;
        ["y"] = -262.36611760533;
        ["g"] = 6;
        ["sublevel"] = 2;
        ["scale"] = 2.3;
      };
      [7] = {
        ["x"] = 569.88698338654;
        ["y"] = -430.78517365784;
        ["g"] = 7;
        ["sublevel"] = 2;
        ["scale"] = 2.3;
      };
      [8] = {
        ["x"] = 524.62023965495;
        ["y"] = -483.99552320174;
        ["g"] = 8;
        ["sublevel"] = 2;
        ["scale"] = 2.3;
      };
      [9] = {
        ["x"] = 340.03859105147;
        ["y"] = -182.60577464681;
        ["g"] = 3;
        ["sublevel"] = 1;
        ["scale"] = 2;
        ["teeming"] = true;
      };
      [10] = {
        ["x"] = 353.33339320471;
        ["y"] = -147.80470225207;
        ["g"] = 96;
        ["sublevel"] = 1;
        ["teeming"] = true;
      };
      [11] = {
        ["x"] = 353.33339320471;
        ["y"] = -141.44107875162;
        ["g"] = 96;
        ["sublevel"] = 1;
        ["teeming"] = true;
      };
      [12] = {
        ["x"] = 361.06069071971;
        ["y"] = -134.16835224611;
        ["g"] = 96;
        ["sublevel"] = 1;
        ["teeming"] = true;
      };
      [13] = {
        ["x"] = 204.10709655195;
        ["y"] = -206.92441823884;
        ["g"] = 15;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
        ["teeming"] = true;
      };
      [14] = {
        ["x"] = 208.19802150405;
        ["y"] = -176.46991292977;
        ["g"] = 15;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
        ["teeming"] = true;
      };
      [15] = {
        ["x"] = 344.19509271816;
        ["y"] = -193.00097186109;
        ["sublevel"] = 1;
        ["scale"] = 2;
        ["patrol"] = {
          [1] = {
            ["x"] = 344.19509271816;
            ["y"] = -193.00097186109;
          };
          [2] = {
            ["x"] = 359.6670656369;
            ["y"] = -178.84015282295;
          };
          [3] = {
            ["x"] = 374.61457100125;
            ["y"] = -150.25619093728;
          };
          [4] = {
            ["x"] = 373.56560588175;
            ["y"] = -123.50794051878;
          };
          [5] = {
            ["x"] = 350.22649960432;
            ["y"] = -91.514969540339;
          };
          [6] = {
            ["x"] = 319.02019994672;
            ["y"] = -80.500985839236;
          };
          [7] = {
            ["x"] = 284.66703494135;
            ["y"] = -68.438022013266;
          };
          [8] = {
            ["x"] = 319.02019994672;
            ["y"] = -80.500985839236;
          };
          [9] = {
            ["x"] = 350.22649960432;
            ["y"] = -91.514969540339;
          };
          [10] = {
            ["x"] = 372.77896457164;
            ["y"] = -122.72125419257;
          };
          [11] = {
            ["x"] = 374.35233722406;
            ["y"] = -149.46950461107;
          };
          [12] = {
            ["x"] = 359.6670656369;
            ["y"] = -178.84015282295;
          };
          [13] = {
            ["x"] = 344.19509271816;
            ["y"] = -193.00097186109;
          };
          [14] = {
            ["x"] = 314.03766814787;
            ["y"] = -209.25970613287;
          };
          [15] = {
            ["x"] = 275.75096647389;
            ["y"] = -205.58838823608;
          };
          [16] = {
            ["x"] = 314.03766814787;
            ["y"] = -209.25970613287;
          };
        };
      };
    };
  };
  [4] = {
    ["name"] = "Phantom Crew";
    ["id"] = 114584;
    ["count"] = 4;
    ["health"] = 340880;
    ["scale"] = 1;
    ["displayId"] = 73338;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [228086] = {
      };
      [228161] = {
      };
      [228164] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 104.59398235026;
        ["y"] = -141.33485383034;
        ["sublevel"] = 3;
        ["scale"] = 1.6;
        ["inspiring"] = true;
        ["patrolFacing"] = 2.9452431127404;
        ["patrolFacing2"] = 4.7123889803847;
        ["patrol"] = {
          [1] = {
            ["x"] = 101.36353088974;
            ["y"] = -138.53512683505;
          };
          [2] = {
            ["x"] = 127.72721976657;
            ["y"] = -140.22730926837;
          };
          [3] = {
            ["x"] = 149.09081443152;
            ["y"] = -146.1363465626;
          };
          [4] = {
            ["x"] = 127.72721976657;
            ["y"] = -140.22730926837;
          };
          [5] = {
            ["x"] = 101.36353088974;
            ["y"] = -138.53512683505;
          };
          [6] = {
            ["x"] = 94.736744256378;
            ["y"] = -181.61077916867;
          };
          [7] = {
            ["x"] = 86.315669109597;
            ["y"] = -207.40025969137;
          };
          [8] = {
            ["x"] = 94.736744256378;
            ["y"] = -181.61077916867;
          };
        };
      };
      [2] = {
        ["x"] = 131.81820015123;
        ["y"] = -116.89797485326;
        ["sublevel"] = 3;
        ["scale"] = 1.6;
        ["patrolFacing"] = 3.3379421944392;
        ["patrolFacing2"] = 4.7123889803847;
        ["patrol"] = {
          [1] = {
            ["x"] = 131.81820015123;
            ["y"] = -116.89797485326;
          };
          [2] = {
            ["x"] = 173.6363921881;
            ["y"] = -124.77271927251;
          };
          [3] = {
            ["x"] = 131.81820015123;
            ["y"] = -116.89797485326;
          };
          [4] = {
            ["x"] = 120.90912014646;
            ["y"] = -116.59090926894;
          };
          [5] = {
            ["x"] = 81.818134027936;
            ["y"] = -117.72712823921;
          };
          [6] = {
            ["x"] = 120.90912014646;
            ["y"] = -116.59090926894;
          };
          [7] = {
            ["x"] = 131.81820015123;
            ["y"] = -116.89797485326;
          };
          [8] = {
            ["x"] = 134.54537276978;
            ["y"] = -141.10905703147;
          };
          [9] = {
            ["x"] = 94.545352852345;
            ["y"] = -129.86452465004;
          };
          [10] = {
            ["x"] = 134.54537276978;
            ["y"] = -141.10905703147;
          };
        };
      };
    };
  };
  [5] = {
    ["name"] = "Ghostly Understudy";
    ["id"] = 114526;
    ["count"] = 3;
    ["health"] = 213050;
    ["scale"] = 1;
    ["displayId"] = 73302;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Root"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [227917] = {
      };
      [227925] = {
      };
      [227927] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 171.93890946345;
        ["y"] = -119.67627439171;
        ["g"] = 9;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [2] = {
        ["x"] = 164.90563516566;
        ["y"] = -128.01495912382;
        ["g"] = 9;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [3] = {
        ["x"] = 159.18758916671;
        ["y"] = -116.41065339353;
        ["g"] = 9;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [4] = {
        ["x"] = 155.32714443342;
        ["y"] = -125.51577954274;
        ["g"] = 9;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [5] = {
        ["x"] = 142.44106054337;
        ["y"] = -143.60248806016;
        ["g"] = 10;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [6] = {
        ["x"] = 133.03585124431;
        ["y"] = -139.18878066418;
        ["g"] = 10;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [7] = {
        ["x"] = 113.15599434458;
        ["y"] = -119.62605970411;
        ["g"] = 11;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [8] = {
        ["x"] = 109.21062510075;
        ["y"] = -110.9435981619;
        ["g"] = 11;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [9] = {
        ["x"] = 103.4497219584;
        ["y"] = -119.38259027686;
        ["g"] = 11;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [10] = {
        ["x"] = 77.797316322207;
        ["y"] = -133.97135783977;
        ["g"] = 12;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [11] = {
        ["x"] = 69.47191792085;
        ["y"] = -127.86977643415;
        ["g"] = 12;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["disguised"] = true;
      };
      [12] = {
        ["x"] = 72.462796498498;
        ["y"] = -116.91383794842;
        ["g"] = 12;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [13] = {
        ["x"] = 81.764867430803;
        ["y"] = -112.93827961448;
        ["g"] = 12;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [14] = {
        ["x"] = 88.040383810797;
        ["y"] = -166.23452620016;
        ["g"] = 13;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [15] = {
        ["x"] = 96.219672050106;
        ["y"] = -162.32226069697;
        ["g"] = 13;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [16] = {
        ["x"] = 86.099789392386;
        ["y"] = -156.43605812056;
        ["g"] = 13;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [17] = {
        ["x"] = 91.499586279066;
        ["y"] = -209.39473187963;
        ["g"] = 14;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["disguised"] = true;
      };
      [18] = {
        ["x"] = 83.164721364641;
        ["y"] = -196.94959369521;
        ["g"] = 14;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
    };
  };
  [6] = {
    ["name"] = "Backup Singer";
    ["id"] = 116549;
    ["count"] = 4;
    ["health"] = 127830;
    ["scale"] = 1;
    ["displayId"] = 74235;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [232084] = {
      };
      [232115] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 188.57236254656;
        ["y"] = -226.14846168058;
        ["g"] = 17;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [2] = {
        ["x"] = 179.44533906844;
        ["y"] = -216.92531349731;
        ["g"] = 17;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [3] = {
        ["x"] = 189.93312618893;
        ["y"] = -217.18151898171;
        ["g"] = 17;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [4] = {
        ["x"] = 177.27212040318;
        ["y"] = -227.22586864902;
        ["g"] = 17;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [5] = {
        ["x"] = 193.18700061695;
        ["y"] = -169.79468620553;
        ["g"] = 18;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [6] = {
        ["x"] = 202.62024037643;
        ["y"] = -168.61910672233;
        ["g"] = 18;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [7] = {
        ["x"] = 189.23218978457;
        ["y"] = -161.72605382784;
        ["g"] = 18;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [8] = {
        ["x"] = 194.32850162534;
        ["y"] = -155.54285440394;
        ["g"] = 18;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [9] = {
        ["x"] = 203.40086621178;
        ["y"] = -160.80683914902;
        ["g"] = 18;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [10] = {
        ["x"] = 190.81559593757;
        ["y"] = -216.80882330638;
        ["g"] = 17;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["teeming"] = true;
      };
      [11] = {
        ["x"] = 182.633785934;
        ["y"] = -205.89976280858;
        ["g"] = 17;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["teeming"] = true;
      };
    };
  };
  [7] = {
    ["name"] = "Skeletal Usher";
    ["id"] = 114544;
    ["count"] = 12;
    ["health"] = 340880;
    ["scale"] = 1;
    ["displayId"] = 73313;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [227965] = {
      };
      [227966] = {
      };
      [227977] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 337.99713421703;
        ["y"] = -195.2303715292;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
        ["patrolFacing"] = 3.1415926535898;
        ["patrolFacing2"] = 0;
        ["patrol"] = {
          [1] = {
            ["x"] = 337.22543396168;
            ["y"] = -215.68015231816;
          };
          [2] = {
            ["x"] = 336.86315493583;
            ["y"] = -234.74885959301;
          };
          [3] = {
            ["x"] = 314.06066972964;
            ["y"] = -260.26339253943;
          };
          [4] = {
            ["x"] = 285.38566516187;
            ["y"] = -275.78763848991;
          };
          [5] = {
            ["x"] = 223.63634997925;
            ["y"] = -277.84490819188;
          };
          [6] = {
            ["x"] = 285.38566516187;
            ["y"] = -275.78763848991;
          };
          [7] = {
            ["x"] = 314.06066972964;
            ["y"] = -260.26339253943;
          };
          [8] = {
            ["x"] = 336.86315493583;
            ["y"] = -234.74885959301;
          };
          [9] = {
            ["x"] = 337.22543396168;
            ["y"] = -215.68015231816;
          };
          [10] = {
            ["x"] = 337.9587465102;
            ["y"] = -180.8518785913;
          };
          [11] = {
            ["x"] = 314.61361945472;
            ["y"] = -154.88580290874;
          };
          [12] = {
            ["x"] = 272.33720943553;
            ["y"] = -134.55639158295;
          };
          [13] = {
            ["x"] = 232.72636400037;
            ["y"] = -128.90598811516;
          };
          [14] = {
            ["x"] = 272.33720943553;
            ["y"] = -134.55639158295;
          };
          [15] = {
            ["x"] = 314.61361945472;
            ["y"] = -154.88580290874;
          };
          [16] = {
            ["x"] = 337.9587465102;
            ["y"] = -180.8518785913;
          };
        };
      };
      [2] = {
        ["x"] = 325.34924333587;
        ["y"] = -214.010053158;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
      };
      [3] = {
        ["x"] = 363.42725101285;
        ["y"] = -218.47731469435;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
      };
      [4] = {
        ["x"] = 397.55130479152;
        ["y"] = -222.44850244603;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
      };
      [5] = {
        ["x"] = 211.88855019607;
        ["y"] = -253.92611638357;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
        ["disguised"] = true;
      };
      [6] = {
        ["x"] = 220.64393291811;
        ["y"] = -146.29215166546;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
        ["disguised"] = true;
      };
      [7] = {
        ["x"] = 348.21653245397;
        ["y"] = -195.68532118312;
        ["g"] = 3;
        ["sublevel"] = 1;
        ["scale"] = 2;
        ["teeming"] = true;
      };
      [8] = {
        ["x"] = 648.99973447062;
        ["y"] = -361.50004132278;
        ["sublevel"] = 2;
        ["scale"] = 1;
        ["teeming"] = true;
        ["patrolFacing"] = 2.6507188014664;
        ["patrolFacing2"] = 6.1850105367549;
        ["patrol"] = {
          [1] = {
            ["x"] = 648.99973447062;
            ["y"] = -361.50004132278;
          };
          [2] = {
            ["x"] = 653.45446107362;
            ["y"] = -269.6538466602;
          };
          [3] = {
            ["x"] = 617.37053511187;
            ["y"] = -205.4814309538;
          };
          [4] = {
            ["x"] = 653.45446107362;
            ["y"] = -269.6538466602;
          };
          [5] = {
            ["x"] = 648.99973447062;
            ["y"] = -361.50004132278;
          };
          [6] = {
            ["x"] = 631.99993706121;
            ["y"] = -394.50000905246;
          };
          [7] = {
            ["x"] = 537.99971427023;
            ["y"] = -459.49997409992;
          };
          [8] = {
            ["x"] = 451.99976975843;
            ["y"] = -468.50000821426;
          };
          [9] = {
            ["x"] = 537.99971427023;
            ["y"] = -459.49997409992;
          };
          [10] = {
            ["x"] = 631.99993706121;
            ["y"] = -394.50000905246;
          };
        };
      };
      [9] = {
        ["x"] = 344.01469741187;
        ["y"] = -215.59123526022;
        ["g"] = 97;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
        ["teeming"] = true;
      };
    };
  };
  [8] = {
    ["name"] = "Undying Servant";
    ["id"] = 114634;
    ["count"] = 3;
    ["health"] = 213050;
    ["scale"] = 1;
    ["displayId"] = 73417;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [228277] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 422.94423366057;
        ["y"] = -223.32041929031;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
        ["patrolFacing"] = 4.319689898686;
        ["patrol"] = {
          [1] = {
            ["x"] = 527.54736249614;
            ["y"] = -240.59110899057;
          };
          [2] = {
            ["x"] = 531.5603610157;
            ["y"] = -219.84193898203;
          };
          [3] = {
            ["x"] = 410.34835244501;
            ["y"] = -204.18061596697;
          };
          [4] = {
            ["x"] = 404.95290078777;
            ["y"] = -251.14399799703;
          };
          [5] = {
            ["x"] = 374.45065180923;
            ["y"] = -272.42666151314;
          };
          [6] = {
            ["x"] = 402.47321749423;
            ["y"] = -275.36095153394;
          };
          [7] = {
            ["x"] = 418.4740987581;
            ["y"] = -254.70166757007;
          };
          [8] = {
            ["x"] = 422.58950952493;
            ["y"] = -227.57702011854;
          };
          [9] = {
            ["x"] = 474.63919780784;
            ["y"] = -243.9607384373;
          };
          [10] = {
            ["x"] = 494.59829947984;
            ["y"] = -252.15108638834;
          };
        };
      };
      [2] = {
        ["x"] = 547.06403440976;
        ["y"] = -235.67952472481;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
        ["patrolFacing"] = 0.88357293382213;
        ["patrolFacing2"] = 4.4178646691106;
        ["patrol"] = {
          [1] = {
            ["x"] = 538.29288766597;
            ["y"] = -234.03492518011;
          };
          [2] = {
            ["x"] = 522.65851018744;
            ["y"] = -217.21284513563;
          };
          [3] = {
            ["x"] = 473.35844195619;
            ["y"] = -209.55401245974;
          };
          [4] = {
            ["x"] = 475.63112168721;
            ["y"] = -181.37222589564;
          };
          [5] = {
            ["x"] = 473.35844195619;
            ["y"] = -209.55401245974;
          };
          [6] = {
            ["x"] = 522.65851018744;
            ["y"] = -217.21284513563;
          };
          [7] = {
            ["x"] = 538.29288766597;
            ["y"] = -234.03492518011;
          };
          [8] = {
            ["x"] = 600.78251873604;
            ["y"] = -246.76115197568;
          };
          [9] = {
            ["x"] = 599.82059751206;
            ["y"] = -261.58517485771;
          };
          [10] = {
            ["x"] = 561.40792988632;
            ["y"] = -257.5574979106;
          };
          [11] = {
            ["x"] = 561.32966028623;
            ["y"] = -270.81535502417;
          };
          [12] = {
            ["x"] = 561.40792988632;
            ["y"] = -257.5574979106;
          };
          [13] = {
            ["x"] = 599.82059751206;
            ["y"] = -261.58517485771;
          };
          [14] = {
            ["x"] = 600.78251873604;
            ["y"] = -246.76115197568;
          };
        };
      };
      [3] = {
        ["x"] = 421.33653833537;
        ["y"] = -262.58692216013;
        ["g"] = 29;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [4] = {
        ["x"] = 482.02842538105;
        ["y"] = -238.12987177784;
        ["g"] = 30;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [5] = {
        ["x"] = 482.83164611606;
        ["y"] = -254.04157403168;
        ["g"] = 30;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [6] = {
        ["x"] = 433.1342795752;
        ["y"] = -267.45550568482;
        ["sublevel"] = 4;
        ["scale"] = 1.8;
        ["disguised"] = true;
        ["patrolFacing"] = 3.0434178831651;
        ["patrolFacing2"] = 4.7123889803847;
        ["patrol"] = {
          [1] = {
            ["x"] = 431.68705880048;
            ["y"] = -271.31479686697;
          };
          [2] = {
            ["x"] = 422.4297218147;
            ["y"] = -342.3424789402;
          };
          [3] = {
            ["x"] = 431.68705880048;
            ["y"] = -271.31479686697;
          };
          [4] = {
            ["x"] = 589.99037051703;
            ["y"] = -291.08517782603;
          };
          [5] = {
            ["x"] = 590.44488300561;
            ["y"] = -304.72154733896;
          };
          [6] = {
            ["x"] = 589.99037051703;
            ["y"] = -291.08517782603;
          };
        };
      };
      [7] = {
        ["x"] = 423.55237788783;
        ["y"] = -324.69929935128;
        ["sublevel"] = 4;
        ["scale"] = 1.8;
        ["patrolFacing"] = 6.1850105367549;
        ["patrol"] = {
          [1] = {
            ["x"] = 425.96443487667;
            ["y"] = -317.94549952678;
          };
          [2] = {
            ["x"] = 431.68705880048;
            ["y"] = -271.31479686697;
          };
          [3] = {
            ["x"] = 589.99037051703;
            ["y"] = -291.08517782603;
          };
          [4] = {
            ["x"] = 590.44488300561;
            ["y"] = -304.72154733896;
          };
          [5] = {
            ["x"] = 589.99037051703;
            ["y"] = -291.08517782603;
          };
          [6] = {
            ["x"] = 431.68705880048;
            ["y"] = -271.31479686697;
          };
        };
      };
      [8] = {
        ["x"] = 490.04065606962;
        ["y"] = -330.28034602011;
        ["sublevel"] = 4;
        ["scale"] = 1.8;
        ["patrolFacing"] = 1.5707963267949;
        ["patrol"] = {
          [1] = {
            ["x"] = 500.65373365769;
            ["y"] = -334.38084961043;
          };
          [2] = {
            ["x"] = 467.77502591413;
            ["y"] = -335.12078777668;
          };
          [3] = {
            ["x"] = 444.93155020596;
            ["y"] = -300.64376528626;
          };
          [4] = {
            ["x"] = 464.14457248101;
            ["y"] = -298.30644146321;
          };
          [5] = {
            ["x"] = 474.62074264598;
            ["y"] = -310.36288278588;
          };
          [6] = {
            ["x"] = 505.47609063337;
            ["y"] = -315.75031424546;
          };
          [7] = {
            ["x"] = 513.83146670299;
            ["y"] = -302.59988482758;
          };
          [8] = {
            ["x"] = 547.6563248724;
            ["y"] = -305.54672811165;
          };
          [9] = {
            ["x"] = 566.05543641851;
            ["y"] = -320.145324298;
          };
          [10] = {
            ["x"] = 555.20071248758;
            ["y"] = -347.99835386851;
          };
        };
      };
      [9] = {
        ["x"] = 404.43062235115;
        ["y"] = -218.7534464735;
        ["g"] = 21;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
        ["teeming"] = true;
      };
      [10] = {
        ["x"] = 403.97607084863;
        ["y"] = -225.48071647469;
        ["g"] = 21;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
        ["teeming"] = true;
      };
    };
  };
  [9] = {
    ["name"] = "Spectral Valet";
    ["id"] = 114633;
    ["count"] = 5;
    ["health"] = 340880;
    ["scale"] = 1;
    ["displayId"] = 16494;
    ["creatureType"] = "Undead";
    ["level"] = 111;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [228278] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 476.71765648384;
        ["y"] = -199.3926978692;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
      };
      [2] = {
        ["x"] = 421.92481267477;
        ["y"] = -272.98411913406;
        ["g"] = 29;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [3] = {
        ["x"] = 432.68953827544;
        ["y"] = -272.80675706624;
        ["g"] = 29;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
    };
  };
  [10] = {
    ["name"] = "Phantom Guest";
    ["id"] = 114625;
    ["count"] = 1;
    ["health"] = 85220;
    ["scale"] = 1;
    ["displayId"] = 16464;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Root"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [21910] = {
      };
      [29492] = {
      };
      [29513] = {
      };
      [29514] = {
      };
      [29579] = {
      };
      [29580] = {
      };
      [29581] = {
      };
      [29583] = {
      };
      [29928] = {
      };
      [29930] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 514.17750497089;
        ["y"] = -207.68178478495;
        ["g"] = 26;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["inspiring"] = true;
      };
      [2] = {
        ["x"] = 504.94788291929;
        ["y"] = -213.05401875723;
        ["g"] = 26;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [3] = {
        ["x"] = 521.92014324466;
        ["y"] = -216.33566824815;
        ["g"] = 26;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [4] = {
        ["x"] = 512.28758694618;
        ["y"] = -218.93020169867;
        ["g"] = 26;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [5] = {
        ["x"] = 521.86488207672;
        ["y"] = -224.4951861477;
        ["g"] = 26;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [6] = {
        ["x"] = 501.56102476707;
        ["y"] = -221.45906862692;
        ["g"] = 26;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [7] = {
        ["x"] = 506.86454322958;
        ["y"] = -226.93406014167;
        ["g"] = 26;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [8] = {
        ["x"] = 508.28918910658;
        ["y"] = -235.57858605195;
        ["g"] = 26;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [9] = {
        ["x"] = 517.45991220475;
        ["y"] = -233.39269488861;
        ["g"] = 26;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [10] = {
        ["x"] = 465.93584807772;
        ["y"] = -221.63354917457;
        ["g"] = 27;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [11] = {
        ["x"] = 464.85922875449;
        ["y"] = -232.31832796657;
        ["g"] = 27;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [12] = {
        ["x"] = 456.28986319302;
        ["y"] = -215.99077564772;
        ["g"] = 27;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [13] = {
        ["x"] = 448.62942439514;
        ["y"] = -223.30706785399;
        ["g"] = 27;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [14] = {
        ["x"] = 445.63664084099;
        ["y"] = -230.29090930983;
        ["g"] = 27;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [15] = {
        ["x"] = 456.78892199955;
        ["y"] = -233.73826364723;
        ["g"] = 27;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [16] = {
        ["x"] = 458.95123536108;
        ["y"] = -225.45764636038;
        ["g"] = 27;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [17] = {
        ["x"] = 458.57417954555;
        ["y"] = -243.02773350436;
        ["g"] = 27;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [18] = {
        ["x"] = 448.46366018117;
        ["y"] = -239.80238531383;
        ["g"] = 27;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [19] = {
        ["x"] = 482.89329270994;
        ["y"] = -273.47400509062;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["disguised"] = true;
      };
      [20] = {
        ["x"] = 515.03397887344;
        ["y"] = -274.83153428945;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [21] = {
        ["x"] = 549.17612443151;
        ["y"] = -277.31862426991;
        ["g"] = 28;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [22] = {
        ["x"] = 557.35789542113;
        ["y"] = -278.68223976353;
        ["g"] = 28;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [23] = {
        ["x"] = 539.541150496;
        ["y"] = -358.22719470822;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [24] = {
        ["x"] = 589.08656201997;
        ["y"] = -304.13630717297;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [25] = {
        ["x"] = 268.11603499628;
        ["y"] = -301.85385659515;
        ["g"] = 53;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [26] = {
        ["x"] = 274.80170475468;
        ["y"] = -292.92975476168;
        ["g"] = 53;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [27] = {
        ["x"] = 289.63498114001;
        ["y"] = -292.74235803917;
        ["g"] = 53;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
        ["disguised"] = true;
      };
      [28] = {
        ["x"] = 289.26948119799;
        ["y"] = -304.20647875305;
        ["g"] = 53;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [29] = {
        ["x"] = 286.97401260244;
        ["y"] = -316.30327228565;
        ["g"] = 53;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [30] = {
        ["x"] = 274.62349962163;
        ["y"] = -314.58559452711;
        ["g"] = 53;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [31] = {
        ["x"] = 336.28295642709;
        ["y"] = -336.29843296264;
        ["g"] = 54;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [32] = {
        ["x"] = 335.15235717034;
        ["y"] = -326.61717418899;
        ["g"] = 54;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [33] = {
        ["x"] = 346.17853506581;
        ["y"] = -318.34553075233;
        ["g"] = 54;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
        ["inspiring"] = true;
      };
      [34] = {
        ["x"] = 354.079891839;
        ["y"] = -328.86522180093;
        ["g"] = 54;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [35] = {
        ["x"] = 355.13909682166;
        ["y"] = -338.26088099103;
        ["g"] = 54;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [36] = {
        ["x"] = 344.52529328083;
        ["y"] = -343.10012134431;
        ["g"] = 54;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [37] = {
        ["x"] = 335.26806697898;
        ["y"] = -386.0291561571;
        ["g"] = 55;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [38] = {
        ["x"] = 327.27587666985;
        ["y"] = -407.6578403188;
        ["g"] = 55;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [39] = {
        ["x"] = 336.4901074167;
        ["y"] = -415.38503446069;
        ["g"] = 55;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
        ["disguised"] = true;
      };
      [40] = {
        ["x"] = 345.6358082346;
        ["y"] = -406.25074879529;
        ["g"] = 55;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [41] = {
        ["x"] = 333.43155879903;
        ["y"] = -397.92503968776;
        ["g"] = 55;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [42] = {
        ["x"] = 348.20780299328;
        ["y"] = -394.26579444346;
        ["g"] = 55;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [43] = {
        ["x"] = 272.57305417581;
        ["y"] = -423.26463304777;
        ["g"] = 56;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [44] = {
        ["x"] = 274.39128115243;
        ["y"] = -411.1906693148;
        ["g"] = 56;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
        ["inspiring"] = true;
      };
      [45] = {
        ["x"] = 272.78329716904;
        ["y"] = -399.27200033131;
        ["g"] = 56;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [46] = {
        ["x"] = 257.84951658382;
        ["y"] = -399.50499268253;
        ["g"] = 56;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [47] = {
        ["x"] = 256.31915071471;
        ["y"] = -412.72107565741;
        ["g"] = 56;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [48] = {
        ["x"] = 259.81156463652;
        ["y"] = -425.93713766577;
        ["g"] = 56;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [49] = {
        ["x"] = 294.73909258749;
        ["y"] = -446.43501113149;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [50] = {
        ["x"] = 439.91134009377;
        ["y"] = -335.14623228408;
        ["g"] = 80;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [51] = {
        ["x"] = 444.87104655286;
        ["y"] = -323.4052039711;
        ["g"] = 80;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [52] = {
        ["x"] = 450.31594162258;
        ["y"] = -331.49476672416;
        ["g"] = 80;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [53] = {
        ["x"] = 461.71705236241;
        ["y"] = -330.13979319994;
        ["g"] = 80;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [54] = {
        ["x"] = 458.61886297697;
        ["y"] = -341.21611793426;
        ["g"] = 80;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [55] = {
        ["x"] = 448.4237350083;
        ["y"] = -343.20148331582;
        ["g"] = 80;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [56] = {
        ["x"] = 499.86030311729;
        ["y"] = -350.41982268747;
        ["g"] = 81;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [57] = {
        ["x"] = 489.03649214238;
        ["y"] = -348.20570244836;
        ["g"] = 81;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [58] = {
        ["x"] = 500.59523436286;
        ["y"] = -342.24952703399;
        ["g"] = 81;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [59] = {
        ["x"] = 493.87890713896;
        ["y"] = -358.81785475775;
        ["g"] = 81;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [60] = {
        ["x"] = 505.97575495233;
        ["y"] = -359.27238066491;
        ["g"] = 81;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [61] = {
        ["x"] = 511.17082732823;
        ["y"] = -348.186496356;
        ["g"] = 81;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [62] = {
        ["x"] = 488.72755268911;
        ["y"] = -288.92323957347;
        ["g"] = 82;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [63] = {
        ["x"] = 493.11540939655;
        ["y"] = -277.41162027642;
        ["g"] = 82;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [64] = {
        ["x"] = 502.10115212282;
        ["y"] = -287.19578089725;
        ["g"] = 82;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [65] = {
        ["x"] = 498.21389493858;
        ["y"] = -297.33515614986;
        ["g"] = 82;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [66] = {
        ["x"] = 487.93626342874;
        ["y"] = -297.92904005417;
        ["g"] = 82;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [67] = {
        ["x"] = 482.1655403763;
        ["y"] = -280.31227533846;
        ["g"] = 82;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [68] = {
        ["x"] = 540.51368687488;
        ["y"] = -353.03090084738;
        ["g"] = 83;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [69] = {
        ["x"] = 563.71475224338;
        ["y"] = -347.41876104811;
        ["g"] = 83;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [70] = {
        ["x"] = 549.01307937366;
        ["y"] = -363.32649414279;
        ["g"] = 83;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [71] = {
        ["x"] = 560.2008900331;
        ["y"] = -359.6064890183;
        ["g"] = 83;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [72] = {
        ["x"] = 544.4955547041;
        ["y"] = -340.44062227967;
        ["g"] = 83;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [73] = {
        ["x"] = 552.12088685462;
        ["y"] = -350.31186234102;
        ["g"] = 83;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [74] = {
        ["x"] = 564.51529127964;
        ["y"] = -300.27440396804;
        ["g"] = 84;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [75] = {
        ["x"] = 585.25808083348;
        ["y"] = -290.92467320434;
        ["g"] = 84;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [76] = {
        ["x"] = 574.72854817943;
        ["y"] = -298.0522846171;
        ["g"] = 84;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [77] = {
        ["x"] = 586.01819250112;
        ["y"] = -301.91161605499;
        ["g"] = 84;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [78] = {
        ["x"] = 566.29589301179;
        ["y"] = -289.30446526485;
        ["g"] = 84;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [79] = {
        ["x"] = 576.00855590836;
        ["y"] = -284.97232101773;
        ["g"] = 84;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
      [80] = {
        ["x"] = 600.19481304435;
        ["y"] = -335.33908128892;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
      };
    };
  };
  [11] = {
    ["name"] = "Spectral Retainer";
    ["id"] = 114629;
    ["count"] = 3;
    ["health"] = 340880;
    ["scale"] = 1;
    ["displayId"] = 73465;
    ["creatureType"] = "Undead";
    ["level"] = 111;
    ["spells"] = {
      [241784] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 479.13696638026;
        ["y"] = -247.26425268105;
        ["g"] = 30;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [2] = {
        ["x"] = 513.29440660724;
        ["y"] = -312.61692845426;
        ["g"] = 85;
        ["sublevel"] = 4;
        ["scale"] = 1.8;
      };
      [3] = {
        ["x"] = 452.7900682245;
        ["y"] = -285.07090634806;
        ["g"] = 86;
        ["sublevel"] = 4;
        ["scale"] = 1.8;
      };
    };
  };
  [12] = {
    ["name"] = "Spectral Attendant";
    ["id"] = 114632;
    ["count"] = 3;
    ["health"] = 213050;
    ["scale"] = 1;
    ["displayId"] = 16514;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Incapacitate"] = true;
    };
    ["spells"] = {
      [228279] = {
      };
      [241788] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 436.18461918803;
        ["y"] = -264.53258398215;
        ["g"] = 29;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["disguised"] = true;
      };
      [2] = {
        ["x"] = 491.81632322975;
        ["y"] = -243.36261900494;
        ["g"] = 30;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [3] = {
        ["x"] = 492.72612514442;
        ["y"] = -253.29947516624;
        ["g"] = 30;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [4] = {
        ["x"] = 521.51704015879;
        ["y"] = -325.91238462809;
        ["g"] = 85;
        ["sublevel"] = 4;
        ["scale"] = 1.8;
      };
      [5] = {
        ["x"] = 527.93307081807;
        ["y"] = -310.45562269941;
        ["g"] = 85;
        ["sublevel"] = 4;
        ["scale"] = 1.8;
        ["inspiring"] = true;
      };
      [6] = {
        ["x"] = 453.29076167775;
        ["y"] = -302.2514150353;
        ["g"] = 86;
        ["sublevel"] = 4;
        ["scale"] = 1.8;
      };
      [7] = {
        ["x"] = 441.07374571411;
        ["y"] = -295.42365486237;
        ["g"] = 86;
        ["sublevel"] = 4;
        ["scale"] = 1.8;
      };
    };
  };
  [13] = {
    ["name"] = "Phantom Guardsman";
    ["id"] = 114636;
    ["count"] = 3;
    ["health"] = 255660;
    ["scale"] = 1;
    ["displayId"] = 16454;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [228276] = {
      };
      [241774] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 523.24587914043;
        ["y"] = -160.03097367821;
        ["g"] = 31;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [2] = {
        ["x"] = 597.34302816892;
        ["y"] = -188.43997943275;
        ["g"] = 41;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["note"] = "Random spawn sentry or guard";
      };
      [3] = {
        ["x"] = 638.21122807757;
        ["y"] = -234.3161059158;
        ["g"] = 42;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["note"] = "Random spawn sentry or guard";
      };
      [4] = {
        ["x"] = 365.99703308195;
        ["y"] = -256.4987388663;
        ["g"] = 63;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["inspiring"] = true;
        ["patrolFacing"] = 1.3744467859455;
        ["patrol"] = {
          [1] = {
            ["x"] = 365.99703308195;
            ["y"] = -256.4987388663;
          };
          [2] = {
            ["x"] = 299.33461823165;
            ["y"] = -246.78578195354;
          };
          [3] = {
            ["x"] = 234.78915618528;
            ["y"] = -298.60397611275;
          };
          [4] = {
            ["x"] = 222.06190780509;
            ["y"] = -366.78581155944;
          };
          [5] = {
            ["x"] = 279.28211937828;
            ["y"] = -444.31822444565;
          };
          [6] = {
            ["x"] = 365.64574379867;
            ["y"] = -450.68184863574;
          };
          [7] = {
            ["x"] = 417.00944492702;
            ["y"] = -404.7727661288;
          };
          [8] = {
            ["x"] = 439.55884660488;
            ["y"] = -363.98491575787;
          };
          [9] = {
            ["x"] = 430.92252317679;
            ["y"] = -304.43944275322;
          };
        };
      };
      [5] = {
        ["x"] = 393.12530770096;
        ["y"] = -331.49474923307;
        ["g"] = 64;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [6] = {
        ["x"] = 386.54409762571;
        ["y"] = -310.51364205411;
        ["g"] = 64;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [7] = {
        ["x"] = 453.18056622134;
        ["y"] = -437.4948125575;
        ["g"] = 65;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["disguised"] = true;
      };
      [8] = {
        ["x"] = 441.55737525728;
        ["y"] = -457.84755830711;
        ["g"] = 65;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [9] = {
        ["x"] = 388.55656566198;
        ["y"] = -378.8236415471;
        ["g"] = 66;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [10] = {
        ["x"] = 395.04783493084;
        ["y"] = -399.20621252362;
        ["g"] = 66;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [11] = {
        ["x"] = 295.19240973879;
        ["y"] = -278.32887518501;
        ["g"] = 68;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [12] = {
        ["x"] = 282.3460529589;
        ["y"] = -260.93610547631;
        ["g"] = 68;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [13] = {
        ["x"] = 226.02245736492;
        ["y"] = -262.56162376388;
        ["g"] = 69;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [14] = {
        ["x"] = 203.937293501;
        ["y"] = -284.88297721361;
        ["g"] = 69;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [15] = {
        ["x"] = 272.0492662458;
        ["y"] = -323.14335026665;
        ["g"] = 70;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [16] = {
        ["x"] = 246.42402712921;
        ["y"] = -341.42144253242;
        ["g"] = 70;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [17] = {
        ["x"] = 634.86002323803;
        ["y"] = -239.80266262532;
        ["g"] = 42;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["teeming"] = true;
      };
      [18] = {
        ["x"] = 647.13271873642;
        ["y"] = -222.07538811061;
        ["g"] = 42;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["teeming"] = true;
      };
      [19] = {
        ["x"] = 335.87167325016;
        ["y"] = -286.12220277265;
        ["g"] = 101;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["teeming"] = true;
      };
      [20] = {
        ["x"] = 344.81907124037;
        ["y"] = -289.28009465918;
        ["g"] = 101;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["teeming"] = true;
      };
      [21] = {
        ["x"] = 344.99962850846;
        ["y"] = -476.49996638857;
        ["g"] = 102;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["teeming"] = true;
      };
      [22] = {
        ["x"] = 344.99962850846;
        ["y"] = -494.49999170192;
        ["g"] = 102;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["teeming"] = true;
      };
      [23] = {
        ["x"] = 348.54159487738;
        ["y"] = -447.04544033469;
        ["g"] = 71;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["teeming"] = true;
      };
      [24] = {
        ["x"] = 345.35977337367;
        ["y"] = -452.95455134657;
        ["g"] = 71;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["teeming"] = true;
      };
    };
  };
  [14] = {
    ["name"] = "Reformed Maiden";
    ["id"] = 114783;
    ["count"] = 4;
    ["health"] = 170440;
    ["scale"] = 1;
    ["displayId"] = 16551;
    ["creatureType"] = "Demon";
    ["level"] = 110;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [228526] = {
      };
      [228528] = {
      };
      [241798] = {
      };
      [241801] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 537.54159433094;
        ["y"] = -137.26930764508;
        ["g"] = 32;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [2] = {
        ["x"] = 546.1589364482;
        ["y"] = -79.343067738411;
        ["g"] = 33;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [3] = {
        ["x"] = 481.32932767863;
        ["y"] = -113.86300284464;
        ["g"] = 36;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [4] = {
        ["x"] = 489.0565870171;
        ["y"] = -108.86301380292;
        ["g"] = 36;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [5] = {
        ["x"] = 556.68242392227;
        ["y"] = -187.09044607091;
        ["g"] = 38;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [6] = {
        ["x"] = 541.50808198976;
        ["y"] = -194.55365017587;
        ["g"] = 39;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [7] = {
        ["x"] = 586.40201472183;
        ["y"] = -144.3444543744;
        ["g"] = 43;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [8] = {
        ["x"] = 601.64273504447;
        ["y"] = -106.69497410194;
        ["g"] = 44;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [9] = {
        ["x"] = 559.67934312406;
        ["y"] = -136.50502755191;
        ["g"] = 46;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [10] = {
        ["x"] = 667.49234885847;
        ["y"] = -188.7896668291;
        ["g"] = 48;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["disguised"] = true;
      };
      [11] = {
        ["x"] = 691.80376495691;
        ["y"] = -161.10500223578;
        ["g"] = 50;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [12] = {
        ["x"] = 703.09368272113;
        ["y"] = -137.0508629767;
        ["g"] = 51;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [13] = {
        ["x"] = 708.54814528673;
        ["y"] = -129.32360363823;
        ["g"] = 51;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
    };
  };
  [15] = {
    ["name"] = "Wholesome Hostess";
    ["id"] = 114796;
    ["count"] = 3;
    ["health"] = 191745;
    ["scale"] = 1;
    ["displayId"] = 16543;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [228575] = {
      };
      [228576] = {
      };
      [228625] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 532.13041579922;
        ["y"] = -143.31591506306;
        ["g"] = 32;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["disguised"] = true;
      };
      [2] = {
        ["x"] = 540.73879177152;
        ["y"] = -87.370823512776;
        ["g"] = 33;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [3] = {
        ["x"] = 511.25777751427;
        ["y"] = -92.029611519258;
        ["g"] = 35;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [4] = {
        ["x"] = 464.51111605628;
        ["y"] = -90.681158072019;
        ["g"] = 37;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [5] = {
        ["x"] = 559.09945553959;
        ["y"] = -179.21599568111;
        ["g"] = 38;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["inspiring"] = true;
        ["patrolFacing"] = 1.3744467859455;
        ["patrolFacing2"] = 4.319689898686;
        ["patrol"] = {
          [1] = {
            ["x"] = 559.09945553959;
            ["y"] = -179.21599568111;
          };
          [2] = {
            ["x"] = 514.79770569277;
            ["y"] = -168.48430999373;
          };
          [3] = {
            ["x"] = 518.8885722902;
            ["y"] = -108.93892665835;
          };
          [4] = {
            ["x"] = 479.34313776595;
            ["y"] = -100.75707764083;
          };
          [5] = {
            ["x"] = 518.8885722902;
            ["y"] = -108.93892665835;
          };
          [6] = {
            ["x"] = 514.79770569277;
            ["y"] = -168.48430999373;
          };
          [7] = {
            ["x"] = 559.09945553959;
            ["y"] = -179.21599568111;
          };
          [8] = {
            ["x"] = 582.3188602114;
            ["y"] = -110.35507097078;
          };
          [9] = {
            ["x"] = 559.09945553959;
            ["y"] = -179.21599568111;
          };
          [10] = {
            ["x"] = 630.95520774428;
            ["y"] = -219.90050054887;
          };
          [11] = {
            ["x"] = 690.95522579839;
            ["y"] = -133.99139797646;
          };
          [12] = {
            ["x"] = 630.95520774428;
            ["y"] = -219.90050054887;
          };
          [13] = {
            ["x"] = 559.09945553959;
            ["y"] = -179.21599568111;
          };
          [14] = {
            ["x"] = 582.3188602114;
            ["y"] = -110.35507097078;
          };
          [15] = {
            ["x"] = 559.09945553959;
            ["y"] = -179.21599568111;
          };
          [16] = {
            ["x"] = 514.79770569277;
            ["y"] = -168.48430999373;
          };
          [17] = {
            ["x"] = 518.8885722902;
            ["y"] = -108.93892665835;
          };
          [18] = {
            ["x"] = 479.34313776595;
            ["y"] = -100.75707764083;
          };
          [19] = {
            ["x"] = 518.8885722902;
            ["y"] = -108.93892665835;
          };
          [20] = {
            ["x"] = 514.79770569277;
            ["y"] = -168.48430999373;
          };
          [21] = {
            ["x"] = 559.09945553959;
            ["y"] = -179.21599568111;
          };
          [22] = {
            ["x"] = 630.95520774428;
            ["y"] = -219.90050054887;
          };
          [23] = {
            ["x"] = 690.95522579839;
            ["y"] = -133.99139797646;
          };
          [24] = {
            ["x"] = 630.95520774428;
            ["y"] = -219.90050054887;
          };
        };
      };
      [6] = {
        ["x"] = 544.85283677316;
        ["y"] = -201.83531425276;
        ["g"] = 39;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["inspiring"] = true;
      };
      [7] = {
        ["x"] = 564.00122708666;
        ["y"] = -204.94054198286;
        ["g"] = 40;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [8] = {
        ["x"] = 577.76569129374;
        ["y"] = -145.70810902975;
        ["g"] = 43;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [9] = {
        ["x"] = 598.27242717755;
        ["y"] = -98.984137854847;
        ["g"] = 44;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [10] = {
        ["x"] = 579.48203969612;
        ["y"] = -93.202151290644;
        ["g"] = 45;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [11] = {
        ["x"] = 643.09131983527;
        ["y"] = -182.93224927212;
        ["g"] = 47;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [12] = {
        ["x"] = 663.97109735553;
        ["y"] = -196.89822281874;
        ["g"] = 48;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["disguised"] = true;
      };
      [13] = {
        ["x"] = 687.06690454009;
        ["y"] = -169.52605479554;
        ["g"] = 50;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [14] = {
        ["x"] = 685.01499605382;
        ["y"] = -124.04101030364;
        ["g"] = 52;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [15] = {
        ["x"] = 551.15056743248;
        ["y"] = -196.62557419674;
        ["g"] = 39;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["teeming"] = true;
      };
    };
  };
  [16] = {
    ["name"] = "Virtuous Lady";
    ["id"] = 114792;
    ["count"] = 3;
    ["health"] = 213050;
    ["scale"] = 1;
    ["displayId"] = 16547;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [228559] = {
      };
      [241808] = {
      };
      [241809] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 511.48084238316;
        ["y"] = -130.15790129965;
        ["g"] = 34;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [2] = {
        ["x"] = 505.04766040721;
        ["y"] = -137.24103745841;
        ["g"] = 34;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [3] = {
        ["x"] = 513.40202637714;
        ["y"] = -82.775799640546;
        ["g"] = 35;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [4] = {
        ["x"] = 469.96569566373;
        ["y"] = -85.226636985492;
        ["g"] = 37;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [5] = {
        ["x"] = 572.42375161859;
        ["y"] = -203.31076464694;
        ["g"] = 40;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["disguised"] = true;
      };
      [6] = {
        ["x"] = 572.27804168689;
        ["y"] = -98.777744121094;
        ["g"] = 45;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [7] = {
        ["x"] = 568.45327842931;
        ["y"] = -131.59027660676;
        ["g"] = 46;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [8] = {
        ["x"] = 639.15563861655;
        ["y"] = -190.0853545143;
        ["g"] = 47;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [9] = {
        ["x"] = 657.08967750494;
        ["y"] = -151.40317351643;
        ["g"] = 49;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [10] = {
        ["x"] = 655.27139346696;
        ["y"] = -160.70933560625;
        ["g"] = 49;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [11] = {
        ["x"] = 690.82090786482;
        ["y"] = -117.05086779587;
        ["g"] = 52;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [12] = {
        ["x"] = 547.05960390977;
        ["y"] = -191.62558569688;
        ["g"] = 39;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["teeming"] = true;
      };
      [13] = {
        ["x"] = 559.31193018453;
        ["y"] = -196.90215176127;
        ["g"] = 40;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["teeming"] = true;
      };
      [14] = {
        ["x"] = 565.10139111416;
        ["y"] = -197.95470710003;
        ["g"] = 40;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["teeming"] = true;
      };
    };
  };
  [17] = {
    ["name"] = "Spectral Sentry";
    ["id"] = 114637;
    ["count"] = 3;
    ["health"] = 170440;
    ["scale"] = 1;
    ["displayId"] = 16458;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [6660] = {
      };
      [228273] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 551.00652559478;
        ["y"] = -165.41656002662;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
      };
      [2] = {
        ["x"] = 571.4610723274;
        ["y"] = -171.78018421671;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
      [3] = {
        ["x"] = 606.34871111865;
        ["y"] = -193.54312890769;
        ["g"] = 41;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["note"] = "Random spawn sentry or guard";
      };
      [4] = {
        ["x"] = 642.53099855413;
        ["y"] = -227.3108040583;
        ["g"] = 42;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["note"] = "Random spawn sentry or guard";
      };
      [5] = {
        ["x"] = 361.99689394236;
        ["y"] = -274.94199131174;
        ["g"] = 63;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [6] = {
        ["x"] = 404.90135977862;
        ["y"] = -303.01164027101;
        ["g"] = 64;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [7] = {
        ["x"] = 408.54940995649;
        ["y"] = -324.76183396115;
        ["g"] = 64;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [8] = {
        ["x"] = 432.77208251458;
        ["y"] = -440.77851465873;
        ["g"] = 65;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [9] = {
        ["x"] = 408.75512302564;
        ["y"] = -424.03430930061;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["patrolFacing"] = 4.2215151282613;
        ["patrolFacing2"] = 0.88357293382213;
        ["patrol"] = {
          [1] = {
            ["x"] = 408.75512302564;
            ["y"] = -424.03430930061;
          };
          [2] = {
            ["x"] = 392.38284875864;
            ["y"] = -409.35761625324;
          };
          [3] = {
            ["x"] = 408.75512302564;
            ["y"] = -424.03430930061;
          };
          [4] = {
            ["x"] = 425.11013133361;
            ["y"] = -433.90304892401;
          };
        };
      };
      [10] = {
        ["x"] = 373.10747038177;
        ["y"] = -393.82364117635;
        ["g"] = 66;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["inspiring"] = true;
      };
      [11] = {
        ["x"] = 310.47206994794;
        ["y"] = -468.29198188808;
        ["g"] = 67;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [12] = {
        ["x"] = 314.10275631596;
        ["y"] = -447.93399155159;
        ["g"] = 67;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [13] = {
        ["x"] = 311.47501143721;
        ["y"] = -268.90546861132;
        ["g"] = 68;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [14] = {
        ["x"] = 297.1211489812;
        ["y"] = -251.84815541902;
        ["g"] = 68;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [15] = {
        ["x"] = 254.00715830469;
        ["y"] = -283.95085016049;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["inspiring"] = true;
        ["patrolFacing"] = 4.8105637508094;
        ["patrol"] = {
          [1] = {
            ["x"] = 251.63815577463;
            ["y"] = -280.7203867191;
          };
          [2] = {
            ["x"] = 279.71380387275;
            ["y"] = -277.2446260036;
          };
          [3] = {
            ["x"] = 306.72958867556;
            ["y"] = -291.68819060631;
          };
          [4] = {
            ["x"] = 307.74069072299;
            ["y"] = -236.2592572044;
          };
          [5] = {
            ["x"] = 300.34457313695;
            ["y"] = -217.75694992672;
          };
          [6] = {
            ["x"] = 228.08468774247;
            ["y"] = -287.98315892764;
          };
          [7] = {
            ["x"] = 197.27262677347;
            ["y"] = -345.52451995465;
          };
          [8] = {
            ["x"] = 235.01884885997;
            ["y"] = -346.6518670996;
          };
        };
      };
      [16] = {
        ["x"] = 211.94791200052;
        ["y"] = -270.6339571867;
        ["g"] = 69;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [17] = {
        ["x"] = 223.57750850429;
        ["y"] = -287.85805469688;
        ["g"] = 69;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [18] = {
        ["x"] = 253.15222576475;
        ["y"] = -321.49798114558;
        ["g"] = 70;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["disguised"] = true;
      };
      [19] = {
        ["x"] = 265.52518685127;
        ["y"] = -345.56603998654;
        ["g"] = 70;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [20] = {
        ["x"] = 642.13273023656;
        ["y"] = -232.0753846173;
        ["g"] = 42;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["teeming"] = true;
      };
      [21] = {
        ["x"] = 345.87171692723;
        ["y"] = -279.80644158661;
        ["g"] = 101;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["teeming"] = true;
      };
      [22] = {
        ["x"] = 335.87167325016;
        ["y"] = -277.70112762587;
        ["g"] = 101;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["teeming"] = true;
      };
      [23] = {
        ["x"] = 357.99963010103;
        ["y"] = -472.49999891035;
        ["g"] = 102;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["teeming"] = true;
      };
      [24] = {
        ["x"] = 359.99965675548;
        ["y"] = -488.49999756925;
        ["g"] = 102;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["teeming"] = true;
      };
      [25] = {
        ["x"] = 511.17363527991;
        ["y"] = -158.36548588989;
        ["g"] = 31;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
      };
    };
  };
  [18] = {
    ["name"] = "Arcane Warden";
    ["id"] = 114624;
    ["count"] = 12;
    ["health"] = 340880;
    ["scale"] = 1;
    ["displayId"] = 61125;
    ["creatureType"] = "Elemental";
    ["level"] = 111;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [228320] = {
      };
      [238606] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 363.28167879596;
        ["y"] = -430.59500450464;
        ["sublevel"] = 4;
        ["scale"] = 1.8;
      };
      [2] = {
        ["x"] = 303.99731513858;
        ["y"] = -276.49870399758;
        ["sublevel"] = 4;
        ["scale"] = 1.8;
      };
      [3] = {
        ["x"] = 406.77974060126;
        ["y"] = -311.81999755711;
        ["sublevel"] = 4;
        ["scale"] = 1.8;
      };
      [4] = {
        ["x"] = 405.50682930917;
        ["y"] = -327.88835274568;
        ["g"] = 98;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
        ["teeming"] = true;
      };
      [5] = {
        ["x"] = 408.2341383243;
        ["y"] = -295.61560571298;
        ["g"] = 98;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
        ["teeming"] = true;
      };
      [6] = {
        ["x"] = 312.60704850344;
        ["y"] = -277.64394510374;
        ["g"] = 99;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
        ["teeming"] = true;
      };
      [7] = {
        ["x"] = 363.05723929787;
        ["y"] = -440.78959614011;
        ["g"] = 100;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
        ["teeming"] = true;
      };
    };
  };
  [19] = {
    ["name"] = "Skeletal Waiter";
    ["id"] = 114628;
    ["count"] = 3;
    ["health"] = 340880;
    ["scale"] = 1;
    ["displayId"] = 73472;
    ["creatureType"] = "Undead";
    ["level"] = 111;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [230297] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 326.63012739692;
        ["y"] = -453.46619642541;
        ["sublevel"] = 4;
        ["scale"] = 1.8;
        ["patrolFacing"] = 1.3744467859455;
        ["patrolFacing2"] = 4.319689898686;
        ["patrol"] = {
          [1] = {
            ["x"] = 332.66031158643;
            ["y"] = -464.77275508932;
          };
          [2] = {
            ["x"] = 271.12902479924;
            ["y"] = -364.4142032679;
          };
          [3] = {
            ["x"] = 210.45438368497;
            ["y"] = -365.23365461759;
          };
          [4] = {
            ["x"] = 271.12902479924;
            ["y"] = -364.4142032679;
          };
          [5] = {
            ["x"] = 332.66031158643;
            ["y"] = -464.77275508932;
          };
          [6] = {
            ["x"] = 333.99956571311;
            ["y"] = -493.50000586733;
          };
          [7] = {
            ["x"] = 388.99961206503;
            ["y"] = -500.50001332723;
          };
          [8] = {
            ["x"] = 333.99956571311;
            ["y"] = -493.50000586733;
          };
        };
      };
      [2] = {
        ["x"] = 381.9973385781;
        ["y"] = -75.498648090288;
        ["g"] = 57;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [3] = {
        ["x"] = 381.9973385781;
        ["y"] = -93.905665595463;
        ["g"] = 57;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [4] = {
        ["x"] = 613.24416160501;
        ["y"] = -180.6812560768;
        ["g"] = 62;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [5] = {
        ["x"] = 599.00428925485;
        ["y"] = -164.83654225847;
        ["g"] = 62;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
    };
  };
  [20] = {
    ["name"] = "Skeletal Hound";
    ["id"] = 114794;
    ["count"] = 3;
    ["health"] = 213050;
    ["scale"] = 1.2;
    ["displayId"] = 73458;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["clones"] = {
      [1] = {
        ["x"] = 307.40393819698;
        ["y"] = -124.96717783894;
        ["g"] = 58;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [2] = {
        ["x"] = 532.99124086646;
        ["y"] = -125.30311415812;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["patrolFacing"] = 3.8288160465626;
        ["patrol"] = {
          [1] = {
            ["x"] = 533.95609049916;
            ["y"] = -139.05189937813;
          };
          [2] = {
            ["x"] = 545.09117623484;
            ["y"] = -159.31817306921;
          };
          [3] = {
            ["x"] = 571.45477324171;
            ["y"] = -163.409078071;
          };
          [4] = {
            ["x"] = 577.36386474661;
            ["y"] = -148.86364456697;
          };
          [5] = {
            ["x"] = 576.90935225804;
            ["y"] = -129.31818354913;
          };
          [6] = {
            ["x"] = 546.90930421703;
            ["y"] = -115.68183354318;
          };
        };
      };
      [3] = {
        ["x"] = 586.55846303839;
        ["y"] = -373.97545182207;
        ["sublevel"] = 4;
        ["scale"] = 1.8;
      };
    };
  };
  [21] = {
    ["name"] = "Ghostly Baker";
    ["id"] = 114716;
    ["count"] = 3;
    ["health"] = 170440;
    ["scale"] = 1;
    ["displayId"] = 16529;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["clones"] = {
      [1] = {
        ["x"] = 325.44742135712;
        ["y"] = -140.64462519373;
        ["g"] = 58;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [2] = {
        ["x"] = 419.77737212228;
        ["y"] = -136.75854132719;
        ["g"] = 59;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [3] = {
        ["x"] = 541.77862890369;
        ["y"] = -191.33087048502;
        ["g"] = 61;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
    };
  };
  [22] = {
    ["name"] = "Ghostly Chef";
    ["id"] = 114715;
    ["count"] = 3;
    ["health"] = 159788;
    ["scale"] = 1;
    ["displayId"] = 16524;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["spells"] = {
    };
    ["clones"] = {
      [1] = {
        ["x"] = 305.89671191938;
        ["y"] = -149.48480443148;
        ["g"] = 58;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [2] = {
        ["x"] = 443.09760746041;
        ["y"] = -130.25252518823;
        ["g"] = 59;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [3] = {
        ["x"] = 426.72527454426;
        ["y"] = -115.18923981587;
        ["g"] = 59;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["disguised"] = true;
      };
      [4] = {
        ["x"] = 371.61462663003;
        ["y"] = -168.34076785299;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["inspiring"] = true;
        ["patrolFacing"] = 3.8288160465626;
        ["patrol"] = {
          [1] = {
            ["x"] = 371.61462663003;
            ["y"] = -168.34076785299;
          };
          [2] = {
            ["x"] = 383.71067755711;
            ["y"] = -183.47128591208;
          };
          [3] = {
            ["x"] = 410.52886798679;
            ["y"] = -180.7440351223;
          };
          [4] = {
            ["x"] = 419.61978198061;
            ["y"] = -168.92585083173;
          };
          [5] = {
            ["x"] = 398.71068369621;
            ["y"] = -153.01676109603;
          };
        };
      };
      [5] = {
        ["x"] = 515.29395982685;
        ["y"] = -184.4752099148;
        ["g"] = 61;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [6] = {
        ["x"] = 532.47441726379;
        ["y"] = -171.69123407174;
        ["g"] = 61;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
    };
  };
  [23] = {
    ["name"] = "Ghostly Steward";
    ["id"] = 114714;
    ["count"] = 3;
    ["health"] = 14205481;
    ["scale"] = 1;
    ["displayId"] = 16535;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["clones"] = {
      [1] = {
        ["x"] = 446.61461831163;
        ["y"] = -179.70440059178;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
      [2] = {
        ["x"] = 555.09026285612;
        ["y"] = -116.28283964657;
        ["g"] = 60;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["disguised"] = true;
      };
      [3] = {
        ["x"] = 549.89517562282;
        ["y"] = -134.72510316994;
        ["g"] = 60;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
      };
    };
  };
  [24] = {
    ["name"] = "Spectral Journeyman";
    ["id"] = 114802;
    ["count"] = 4;
    ["health"] = 245008;
    ["scale"] = 1;
    ["displayId"] = 73470;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Root"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [228637] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 350.67603587466;
        ["y"] = -456.27745614261;
        ["g"] = 71;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [2] = {
        ["x"] = 353.46827623718;
        ["y"] = -447.49944618549;
        ["g"] = 71;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [3] = {
        ["x"] = 345.32054765079;
        ["y"] = -410.43947826619;
        ["g"] = 72;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
    };
  };
  [25] = {
    ["name"] = "Spectral Apprentice";
    ["id"] = 114801;
    ["count"] = 4;
    ["health"] = 202398;
    ["scale"] = 1;
    ["displayId"] = 16417;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Incapacitate"] = true;
      ["Root"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
    };
    ["clones"] = {
      [1] = {
        ["x"] = 337.00723669233;
        ["y"] = -416.63465738104;
        ["g"] = 72;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [2] = {
        ["x"] = 372.00753624996;
        ["y"] = -404.30971669491;
        ["g"] = 72;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [3] = {
        ["x"] = 358.76661937563;
        ["y"] = -405.84314277449;
        ["g"] = 72;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["disguised"] = true;
      };
      [4] = {
        ["x"] = 375.48133091261;
        ["y"] = -500.82063045226;
        ["g"] = 78;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [5] = {
        ["x"] = 337.13490235035;
        ["y"] = -489.48254312404;
        ["g"] = 79;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [6] = {
        ["x"] = 394.05460694759;
        ["y"] = -327.37198587238;
        ["g"] = 64;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["teeming"] = true;
      };
      [7] = {
        ["x"] = 401.78186544864;
        ["y"] = -321.00832335797;
        ["g"] = 64;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["teeming"] = true;
      };
      [8] = {
        ["x"] = 374.39834690511;
        ["y"] = -257.80464444771;
        ["g"] = 63;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["teeming"] = true;
      };
      [9] = {
        ["x"] = 372.58021872588;
        ["y"] = -273.71373418341;
        ["g"] = 63;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["teeming"] = true;
      };
      [10] = {
        ["x"] = 342.97797472221;
        ["y"] = -447.95454333974;
        ["g"] = 71;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["inspiring"] = true;
      };
    };
  };
  [26] = {
    ["name"] = "Spectral Charger";
    ["id"] = 114804;
    ["count"] = 5;
    ["health"] = 255660;
    ["scale"] = 1;
    ["displayId"] = 16407;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Root"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [228603] = {
      };
      [241828] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 393.37856777015;
        ["y"] = -401.63271987258;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [2] = {
        ["x"] = 394.70054302388;
        ["y"] = -431.13589934981;
        ["g"] = 73;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [3] = {
        ["x"] = 405.43372166931;
        ["y"] = -439.8097071629;
        ["g"] = 73;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [4] = {
        ["x"] = 444.01445292346;
        ["y"] = -451.63566212288;
        ["g"] = 74;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [5] = {
        ["x"] = 444.39488553816;
        ["y"] = -462.11797000888;
        ["g"] = 74;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [6] = {
        ["x"] = 432.80841388287;
        ["y"] = -504.65208099443;
        ["g"] = 76;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [7] = {
        ["x"] = 425.73940104601;
        ["y"] = -514.55021700171;
        ["g"] = 76;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [8] = {
        ["x"] = 392.45571001583;
        ["y"] = -527.7782086466;
        ["g"] = 77;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [9] = {
        ["x"] = 381.97329602297;
        ["y"] = -522.49948340368;
        ["g"] = 77;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["inspiring"] = true;
      };
      [10] = {
        ["x"] = 365.46645607242;
        ["y"] = -483.70410668799;
        ["g"] = 78;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [11] = {
        ["x"] = 363.89263569029;
        ["y"] = -497.33906248771;
        ["g"] = 78;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [12] = {
        ["x"] = 328.42184774824;
        ["y"] = -480.46289288279;
        ["g"] = 79;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [13] = {
        ["x"] = 327.36197697806;
        ["y"] = -469.62549712574;
        ["g"] = 79;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [14] = {
        ["x"] = 364.72784557708;
        ["y"] = -503.86361737811;
        ["g"] = 78;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["teeming"] = true;
      };
      [15] = {
        ["x"] = 369.27332158837;
        ["y"] = -497.95452587321;
        ["g"] = 78;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["teeming"] = true;
      };
    };
  };
  [27] = {
    ["name"] = "Spectral Stable Hand";
    ["id"] = 114803;
    ["count"] = 4;
    ["health"] = 191745;
    ["scale"] = 1;
    ["displayId"] = 16397;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Stun"] = true;
    };
    ["spells"] = {
      [6016] = {
      };
      [228606] = {
      };
      [233210] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 436.81566725941;
        ["y"] = -482.06319985091;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["patrolFacing"] = 6.0868357663302;
        ["patrolFacing2"] = 2.6507188014664;
        ["patrol"] = {
          [1] = {
            ["x"] = 435.6096320557;
            ["y"] = -485.68131888062;
          };
          [2] = {
            ["x"] = 430.95474877065;
            ["y"] = -495.68182803912;
          };
          [3] = {
            ["x"] = 435.6096320557;
            ["y"] = -485.68131888062;
          };
          [4] = {
            ["x"] = 437.31835345377;
            ["y"] = -478.40912266202;
          };
        };
      };
      [2] = {
        ["x"] = 376.97466838751;
        ["y"] = -488.6122571087;
        ["g"] = 78;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [3] = {
        ["x"] = 340.26370609731;
        ["y"] = -479.44050572748;
        ["g"] = 79;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["disguised"] = true;
      };
      [4] = {
        ["x"] = 337.34136104222;
        ["y"] = -468.12525579016;
        ["g"] = 79;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
    };
  };
  [28] = {
    ["name"] = "Coldmist Widow";
    ["id"] = 115019;
    ["count"] = 6;
    ["health"] = 11364385;
    ["scale"] = 1;
    ["displayId"] = 16050;
    ["creatureType"] = "Beast";
    ["level"] = 110;
    ["spells"] = {
    };
    ["clones"] = {
      [1] = {
        ["x"] = 513.59388039507;
        ["y"] = -259.52631965046;
        ["g"] = 87;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [2] = {
        ["x"] = 514.38960100215;
        ["y"] = -246.32027617808;
        ["g"] = 87;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [3] = {
        ["x"] = 473.75406939026;
        ["y"] = -216.29277262278;
        ["g"] = 88;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [4] = {
        ["x"] = 460.21764308376;
        ["y"] = -219.55212889676;
        ["g"] = 88;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["inspiring"] = true;
      };
      [5] = {
        ["x"] = 450.12849303752;
        ["y"] = -212.11370622;
        ["g"] = 88;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [6] = {
        ["x"] = 399.27789370087;
        ["y"] = -232.59464120509;
        ["g"] = 89;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [7] = {
        ["x"] = 391.03725290222;
        ["y"] = -225.41327646165;
        ["g"] = 89;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["disguised"] = true;
      };
      [8] = {
        ["x"] = 399.90988575157;
        ["y"] = -215.88586461555;
        ["g"] = 89;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [9] = {
        ["x"] = 578.33917374496;
        ["y"] = -155.7271314888;
        ["g"] = 90;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [10] = {
        ["x"] = 569.49148162333;
        ["y"] = -146.61492616462;
        ["g"] = 90;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [11] = {
        ["x"] = 555.57792244947;
        ["y"] = -149.50792091336;
        ["g"] = 90;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["disguised"] = true;
      };
      [12] = {
        ["x"] = 495.99602039345;
        ["y"] = -79.498658902943;
        ["g"] = 91;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [13] = {
        ["x"] = 500.51405914393;
        ["y"] = -90.436961314964;
        ["g"] = 91;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [14] = {
        ["x"] = 518.34012239097;
        ["y"] = -89.317566980285;
        ["g"] = 91;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [15] = {
        ["x"] = 552.15552620222;
        ["y"] = -125.52563466364;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [16] = {
        ["x"] = 571.10292269545;
        ["y"] = -127.63090345033;
        ["g"] = 92;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [17] = {
        ["x"] = 580.05027551162;
        ["y"] = -128.68348137612;
        ["g"] = 92;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [18] = {
        ["x"] = 566.26293693126;
        ["y"] = -80.659957755512;
        ["g"] = 93;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [19] = {
        ["x"] = 582.06060117986;
        ["y"] = -79.208152009106;
        ["g"] = 93;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [20] = {
        ["x"] = 593.55699027186;
        ["y"] = -84.806104861609;
        ["g"] = 93;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
    };
  };
  [29] = {
    ["name"] = "Coldmist Stalker";
    ["id"] = 115115;
    ["count"] = 3;
    ["health"] = 11364385;
    ["scale"] = 0.8;
    ["displayId"] = 27683;
    ["creatureType"] = "Beast";
    ["level"] = 110;
    ["clones"] = {
      [1] = {
        ["x"] = 468.55873072546;
        ["y"] = -297.01337133548;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [2] = {
        ["x"] = 455.59480628465;
        ["y"] = -261.35741292209;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [3] = {
        ["x"] = 405.61824369195;
        ["y"] = -199.3459223574;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [4] = {
        ["x"] = 412.38117688618;
        ["y"] = -256.39564395361;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [5] = {
        ["x"] = 497.33761075277;
        ["y"] = -191.42960617357;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [6] = {
        ["x"] = 560.97725988328;
        ["y"] = -172.61114208445;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [7] = {
        ["x"] = 547.58388866897;
        ["y"] = -187.51842678833;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [8] = {
        ["x"] = 490.41496570698;
        ["y"] = -107.54391288827;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [9] = {
        ["x"] = 536.19052931219;
        ["y"] = -85.515537574862;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [10] = {
        ["x"] = 531.4581142657;
        ["y"] = -120.22664982588;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [11] = {
        ["x"] = 570.27275731482;
        ["y"] = -97.044821631039;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [12] = {
        ["x"] = 635.89816466336;
        ["y"] = -114.81671107747;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [13] = {
        ["x"] = 634.55692031605;
        ["y"] = -106.08051233788;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [14] = {
        ["x"] = 629.4793186349;
        ["y"] = -96.779347092028;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [15] = {
        ["x"] = 620.15589973704;
        ["y"] = -93.664423771842;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [16] = {
        ["x"] = 606.84228673907;
        ["y"] = -106.78996060916;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [17] = {
        ["x"] = 606.56517533226;
        ["y"] = -117.5100219451;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [18] = {
        ["x"] = 616.05427996371;
        ["y"] = -126.4235827525;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [19] = {
        ["x"] = 607.10783930597;
        ["y"] = -136.33436867651;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [20] = {
        ["x"] = 513.15797901601;
        ["y"] = -160.85911612286;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [21] = {
        ["x"] = 476.15075282924;
        ["y"] = -147.74419516299;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [22] = {
        ["x"] = 422.73883980588;
        ["y"] = -177.2709185481;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [23] = {
        ["x"] = 430.94305951724;
        ["y"] = -170.99649598995;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [24] = {
        ["x"] = 437.63899721931;
        ["y"] = -177.48120979928;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [25] = {
        ["x"] = 455.36638877587;
        ["y"] = -176.57215567478;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [26] = {
        ["x"] = 408.80044343844;
        ["y"] = -129.34926718709;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [27] = {
        ["x"] = 428.81100273938;
        ["y"] = -131.10162159;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
      [28] = {
        ["x"] = 464.30188449739;
        ["y"] = -205.3480485943;
        ["g"] = 88;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
      };
    };
  };
  [30] = {
    ["name"] = "Arcanid";
    ["id"] = 115020;
    ["count"] = 7;
    ["health"] = 14030105;
    ["scale"] = 1;
    ["displayId"] = 72245;
    ["creatureType"] = "Beast";
    ["level"] = 110;
    ["clones"] = {
      [1] = {
        ["x"] = 487.50341989889;
        ["y"] = -236.16330479013;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["patrolFacing"] = 6.1850105367549;
        ["patrolFacing2"] = 1.5707963267949;
        ["patrol"] = {
          [1] = {
            ["x"] = 494.59772501279;
            ["y"] = -240.59722821976;
          };
          [2] = {
            ["x"] = 414.59774428948;
            ["y"] = -235.14266811928;
          };
          [3] = {
            ["x"] = 494.59772501279;
            ["y"] = -240.59722821976;
          };
          [4] = {
            ["x"] = 497.77958587528;
            ["y"] = -183.32447396008;
          };
        };
      };
      [2] = {
        ["x"] = 451.33181430652;
        ["y"] = -157.45797518887;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["patrolFacing"] = 4.61421420996;
        ["patrolFacing2"] = 1.5707963267949;
        ["patrol"] = {
          [1] = {
            ["x"] = 451.33181430652;
            ["y"] = -157.45797518887;
          };
          [2] = {
            ["x"] = 411.42762430493;
            ["y"] = -152.37473028432;
          };
          [3] = {
            ["x"] = 451.33181430652;
            ["y"] = -157.45797518887;
          };
          [4] = {
            ["x"] = 565.82467330989;
            ["y"] = -168.84467946338;
          };
        };
      };
      [3] = {
        ["x"] = 569.84880994341;
        ["y"] = -109.07387544441;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["patrolFacing"] = 4.7123889803847;
        ["patrolFacing2"] = 1.4726215563702;
        ["patrol"] = {
          [1] = {
            ["x"] = 569.13938140534;
            ["y"] = -106.59085582796;
          };
          [2] = {
            ["x"] = 616.15615741263;
            ["y"] = -112.36200315436;
          };
          [3] = {
            ["x"] = 569.13938140534;
            ["y"] = -106.59085582796;
          };
          [4] = {
            ["x"] = 527.51974582508;
            ["y"] = -100.99833263312;
          };
        };
      };
      [4] = {
        ["x"] = 509.05072229846;
        ["y"] = -77.012477715936;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["patrolFacing"] = 4.7123889803847;
        ["patrolFacing2"] = 3.0434178831651;
        ["patrol"] = {
          [1] = {
            ["x"] = 509.76015083653;
            ["y"] = -79.318125397963;
          };
          [2] = {
            ["x"] = 505.49475203516;
            ["y"] = -150.0395039277;
          };
          [3] = {
            ["x"] = 509.76015083653;
            ["y"] = -79.318125397963;
          };
          [4] = {
            ["x"] = 537.48740535583;
            ["y"] = -82.95445978433;
          };
        };
      };
    };
  };
  [31] = {
    ["name"] = "Shrieking Terror";
    ["id"] = 114627;
    ["count"] = 5;
    ["health"] = 382886;
    ["scale"] = 1;
    ["displayId"] = 10698;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [228239] = {
      };
      [228241] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 472.61093967535;
        ["y"] = -320.11423016035;
        ["g"] = 94;
        ["sublevel"] = 1;
        ["scale"] = 2.5;
        ["teeming"] = true;
      };
      [2] = {
        ["x"] = 496.71148751795;
        ["y"] = -299.18760712171;
        ["g"] = 95;
        ["sublevel"] = 1;
        ["scale"] = 2.5;
        ["teeming"] = true;
      };
    };
  };
  [32] = {
    ["name"] = "Opera Hall: Wikket";
    ["id"] = 114284;
    ["count"] = 0;
    ["health"] = 132731495;
    ["scale"] = 1;
    ["displayId"] = 17550;
    ["creatureType"] = "Humanoid";
    ["level"] = 112;
    ["isBoss"] = true;
    ["encounterID"] = 1820;
    ["clones"] = {
      [1] = {
        ["x"] = 146.13319650169;
        ["y"] = -191.60933722616;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
      };
    };
  };
  [33] = {
    ["name"] = "Maiden of Virtue";
    ["id"] = 113971;
    ["count"] = 0;
    ["health"] = 1491350;
    ["scale"] = 1;
    ["displayId"] = 16198;
    ["creatureType"] = "Giant";
    ["level"] = 112;
    ["isBoss"] = true;
    ["encounterID"] = 1555;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [227508] = {
      };
      [227789] = {
      };
      [227800] = {
      };
      [227809] = {
      };
      [227817] = {
      };
      [227823] = {
      };
      [227848] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 703.60465140873;
        ["y"] = -279.65159949635;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
      };
    };
  };
  [34] = {
    ["name"] = "Attumen the Huntsman";
    ["id"] = 114264;
    ["count"] = 0;
    ["health"] = 426100;
    ["scale"] = 1;
    ["displayId"] = 73811;
    ["creatureType"] = "Undead";
    ["level"] = 112;
    ["isBoss"] = true;
    ["encounterID"] = 1835;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [227339] = {
      };
      [227363] = {
      };
      [227365] = {
      };
      [227404] = {
      };
      [227645] = {
      };
      [228895] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 383.82070096933;
        ["y"] = -462.18720359513;
        ["sublevel"] = 6;
        ["scale"] = 1.3;
      };
    };
  };
  [35] = {
    ["name"] = "Moroes";
    ["id"] = 114312;
    ["count"] = 0;
    ["health"] = 1193080;
    ["scale"] = 1;
    ["displayId"] = 16540;
    ["creatureType"] = "Undead";
    ["level"] = 112;
    ["isBoss"] = true;
    ["encounterID"] = 1837;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [227736] = {
      };
      [227737] = {
      };
      [227742] = {
      };
      [227832] = {
      };
      [227851] = {
      };
      [227872] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 224.28443185713;
        ["y"] = -353.1564480984;
        ["sublevel"] = 4;
        ["scale"] = 2;
      };
    };
  };
  [36] = {
    ["name"] = "Nathrezim Infiltrator";
    ["id"] = 189878;
    ["count"] = 4;
    ["health"] = 239096;
    ["scale"] = 1.2;
    ["displayId"] = 101016;
    ["creatureType"] = "Demon";
    ["level"] = 61;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [373364] = {
      };
      [373370] = {
      };
      [373391] = {
      };
      [373429] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 361.07475587797;
        ["y"] = -108.6375792582;
        ["g"] = 4;
        ["sublevel"] = 1;
        ["scale"] = 2;
        ["shrouded"] = true;
      };
      [2] = {
        ["x"] = 510.2889672621;
        ["y"] = -494.54177979379;
        ["g"] = 8;
        ["sublevel"] = 2;
        ["scale"] = 2.3;
        ["shrouded"] = true;
      };
      [3] = {
        ["x"] = 263.29146003598;
        ["y"] = -200.58280451202;
        ["g"] = 1;
        ["sublevel"] = 1;
        ["scale"] = 2;
        ["shrouded"] = true;
      };
      [4] = {
        ["x"] = 220.64393291811;
        ["y"] = -146.29215166546;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
        ["shrouded"] = true;
      };
      [5] = {
        ["x"] = 211.88855019607;
        ["y"] = -253.92611638357;
        ["sublevel"] = 3;
        ["scale"] = 1.4;
        ["shrouded"] = true;
      };
      [6] = {
        ["x"] = 69.47191792085;
        ["y"] = -127.86977643415;
        ["g"] = 12;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["shrouded"] = true;
      };
      [7] = {
        ["x"] = 433.06231937921;
        ["y"] = -261.890644333;
        ["g"] = 29;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["shrouded"] = true;
      };
      [8] = {
        ["x"] = 482.89329270994;
        ["y"] = -273.47400509062;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["shrouded"] = true;
      };
      [9] = {
        ["x"] = 572.42375161859;
        ["y"] = -203.31076464694;
        ["g"] = 40;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["shrouded"] = true;
      };
      [10] = {
        ["x"] = 532.13041579922;
        ["y"] = -143.31591506306;
        ["g"] = 32;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["shrouded"] = true;
      };
      [11] = {
        ["x"] = 663.97109735553;
        ["y"] = -196.89822281874;
        ["g"] = 48;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["shrouded"] = true;
      };
      [12] = {
        ["x"] = 669.95439181589;
        ["y"] = -187.4218495326;
        ["g"] = 48;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["shrouded"] = true;
      };
      [13] = {
        ["x"] = 289.63498114001;
        ["y"] = -292.74235803917;
        ["g"] = 53;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
        ["shrouded"] = true;
      };
      [14] = {
        ["x"] = 336.4901074167;
        ["y"] = -415.38503446069;
        ["g"] = 55;
        ["sublevel"] = 4;
        ["scale"] = 1.4;
        ["shrouded"] = true;
      };
      [15] = {
        ["x"] = 433.1342795752;
        ["y"] = -267.45550568482;
        ["sublevel"] = 4;
        ["scale"] = 1.8;
        ["shrouded"] = true;
        ["patrolFacing"] = 3.0434178831651;
        ["patrolFacing2"] = 4.7123889803847;
        ["patrol"] = {
          [1] = {
            ["x"] = 431.68705880048;
            ["y"] = -271.31479686697;
          };
          [2] = {
            ["x"] = 422.4297218147;
            ["y"] = -342.3424789402;
          };
          [3] = {
            ["x"] = 431.68705880048;
            ["y"] = -271.31479686697;
          };
          [4] = {
            ["x"] = 589.99037051703;
            ["y"] = -291.08517782603;
          };
          [5] = {
            ["x"] = 590.44488300561;
            ["y"] = -304.72154733896;
          };
          [6] = {
            ["x"] = 589.99037051703;
            ["y"] = -291.08517782603;
          };
        };
      };
      [16] = {
        ["x"] = 426.72527454426;
        ["y"] = -115.18923981587;
        ["g"] = 59;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["shrouded"] = true;
      };
      [17] = {
        ["x"] = 555.09026285612;
        ["y"] = -116.28283964657;
        ["g"] = 60;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["shrouded"] = true;
      };
      [18] = {
        ["x"] = 253.15222576475;
        ["y"] = -321.49798114558;
        ["g"] = 76;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["shrouded"] = true;
      };
      [19] = {
        ["x"] = 453.18056622134;
        ["y"] = -437.4948125575;
        ["g"] = 65;
        ["sublevel"] = 5;
        ["scale"] = 2.6;
        ["shrouded"] = true;
      };
      [20] = {
        ["x"] = 391.03725290222;
        ["y"] = -225.41327646165;
        ["g"] = 89;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["shrouded"] = true;
      };
      [21] = {
        ["x"] = 555.57792244947;
        ["y"] = -149.50792091336;
        ["g"] = 90;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["shrouded"] = true;
      };
      [22] = {
        ["x"] = 340.26370609731;
        ["y"] = -479.44050572748;
        ["g"] = 79;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["shrouded"] = true;
      };
      [23] = {
        ["x"] = 206.20030538956;
        ["y"] = -209.63631973138;
        ["g"] = 103;
        ["sublevel"] = 3;
        ["shrouded"] = true;
      };
      [24] = {
        ["x"] = 358.76661937563;
        ["y"] = -405.84314277449;
        ["g"] = 72;
        ["sublevel"] = 6;
        ["scale"] = 1.6;
        ["shrouded"] = true;
      };
    };
  };
  [37] = {
    ["name"] = "Zul'gamux";
    ["id"] = 190128;
    ["count"] = 12;
    ["health"] = 639150;
    ["scale"] = 1.8;
    ["displayId"] = 101106;
    ["creatureType"] = "Demon";
    ["level"] = 61;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [373509] = {
      };
      [373513] = {
      };
      [373552] = {
      };
      [373570] = {
      };
      [373607] = {
      };
      [373724] = {
      };
      [373729] = {
      };
      [373744] = {
      };
      [373747] = {
      };
      [374273] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 89.261476943108;
        ["y"] = -213.64634780131;
        ["g"] = 14;
        ["sublevel"] = 3;
        ["scale"] = 1.2;
        ["shrouded"] = true;
      };
    };
  };
  [38] = {
    ["name"] = "Spectral Patron";
    ["id"] = 116550;
    ["count"] = 3;
    ["health"] = 85220;
    ["scale"] = 1;
    ["displayId"] = 16555;
    ["creatureType"] = "Undead";
    ["level"] = 110;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Root"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [227981] = {
      };
      [227983] = {
      };
      [228014] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 201.97347945815;
        ["y"] = -227.0167110551;
        ["g"] = 103;
        ["sublevel"] = 3;
      };
      [2] = {
        ["x"] = 206.87490931041;
        ["y"] = -199.94275425178;
        ["g"] = 103;
        ["sublevel"] = 3;
      };
      [3] = {
        ["x"] = 206.20030538956;
        ["y"] = -209.63631973138;
        ["g"] = 103;
        ["sublevel"] = 3;
        ["disguised"] = true;
      };
      [4] = {
        ["x"] = 204.02072423023;
        ["y"] = -217.90631114019;
        ["g"] = 103;
        ["sublevel"] = 3;
      };
      [5] = {
        ["x"] = 183.91750518535;
        ["y"] = -179.63670838954;
        ["g"] = 104;
        ["sublevel"] = 3;
      };
      [6] = {
        ["x"] = 181.8290546604;
        ["y"] = -186.52871522402;
        ["g"] = 104;
        ["sublevel"] = 3;
      };
      [7] = {
        ["x"] = 179.32282798714;
        ["y"] = -195.09155776636;
        ["g"] = 104;
        ["sublevel"] = 3;
        ["inspiring"] = true;
      };
      [8] = {
        ["x"] = 176.60778494249;
        ["y"] = -202.81900934331;
        ["g"] = 104;
        ["sublevel"] = 3;
      };
    };
  };
};
