local MDT = MDT
local L = MDT.L
local dungeonIndex = 30
MDT.dungeonList[dungeonIndex] = L["Halls of Atonement"]
MDT.mapInfo[dungeonIndex] = {
  viewportPositionOverrides =
  {
    [1] = {
      zoomScale = 1.2999999523163,
      horizontalPan = 143.9521928205,
      verticalPan = 49.148278395532,
    },
    [2] = {
      zoomScale = 1.2999999523163,
      horizontalPan = 105.03585365414,
      verticalPan = 75.538909709348,
    },
    [3] = {
      zoomScale = 1.2999999523163,
      horizontalPan = 6.4961917586812,
      verticalPan = 65.035909051372,
    },
  }
};

local zones = { 1663, 1664, 1665 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.scaleMultiplier[dungeonIndex] = 1.3

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "HallsOfAtonement_A",
  [1] = "HallsOfAttonementExterior",
  [2] = "HallsOfAtonement_A",
  [3] = "HallsOfAtonement_B",
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["HallsOfAtonementFloor1"],
  [2] = L["HallsOfAtonementFloor2"],
  [3] = L["HallsOfAtonementFloor3"],
}
MDT.dungeonTotalCount[dungeonIndex] = { normal = 273, teeming = 1000, teemingEnabled = true }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 184.47462663272,
      ["y"] = -301.64783454689,
      ["target"] = 2,
      ["direction"] = -2,
      ["connectionIndex"] = 1,
    },
  },
  [2] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 695.13567177537,
      ["y"] = -277.89614857732,
      ["target"] = 1,
      ["direction"] = 2,
      ["connectionIndex"] = 1,
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 161.51434790935,
      ["y"] = -208.22449127413,
      ["target"] = 3,
      ["direction"] = 1,
      ["connectionIndex"] = 2,
    },
  },
  [3] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 600.12888489486,
      ["y"] = -273.93754944583,
      ["target"] = 2,
      ["direction"] = -1,
      ["connectionIndex"] = 2,
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Depraved Darkblade",
    ["id"] = 165515,
    ["count"] = 4,
    ["health"] = 165195,
    ["scale"] = 1,
    ["displayId"] = 93074,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [325523] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 675.796854266,
        ["y"] = -297.35910593024,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 676.01542698674,
        ["y"] = -307.40690574765,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 590.30288607645,
        ["y"] = -292.87043645884,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 573.94718355665,
        ["y"] = -336.86604878049,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 576.15454663718,
        ["y"] = -255.61404878049,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 581.35760283899,
        ["y"] = -230.86141889029,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 458.12618706908,
        ["y"] = -213.2716097561,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 455.42271057377,
        ["y"] = -258.95108896962,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 505.27866754437,
        ["y"] = -294.59426792635,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 536.69823028185,
        ["y"] = -378.24784609825,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 457.787433329,
        ["y"] = -340.22312195122,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 456.38870820866,
        ["y"] = -368.87736585366,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 294.19118237638,
        ["y"] = -240.93071330448,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 336.22474883488,
        ["y"] = -358.90729823223,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 391.22299146831,
        ["y"] = -361.22595810492,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 285.67066055495,
        ["y"] = -341.73492921658,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 386.34577175927,
        ["y"] = -290.33029411765,
        ["g"] = 47,
        ["sublevel"] = 2,
      },
      [18] = {
        ["x"] = 386.44459528868,
        ["y"] = -264.4100672761,
        ["g"] = 47,
        ["sublevel"] = 2,
      },
    },
  },
  [2] = {
    ["name"] = "Depraved Houndmaster",
    ["id"] = 164562,
    ["count"] = 4,
    ["health"] = 148676,
    ["scale"] = 1,
    ["displayId"] = 97001,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [325535] = {
      },
      [325797] = {
      },
      [326450] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 646.58821813254,
        ["y"] = -308.53990707246,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["inspiring"] = true,
        ["patrol"] = {
          [1] = {
            ["x"] = 645.19110131685,
            ["y"] = -307.37560308638,
          },
          [2] = {
            ["x"] = 643.16688739894,
            ["y"] = -319.47146277102,
          },
          [3] = {
            ["x"] = 632.92106428629,
            ["y"] = -330.18299148889,
          },
          [4] = {
            ["x"] = 619.4152020045,
            ["y"] = -346.25031454547,
          },
          [5] = {
            ["x"] = 607.77222210315,
            ["y"] = -358.35902003856,
          },
          [6] = {
            ["x"] = 619.4152020045,
            ["y"] = -346.25031454547,
          },
          [7] = {
            ["x"] = 632.92106428629,
            ["y"] = -330.18299148889,
          },
          [8] = {
            ["x"] = 643.16688739894,
            ["y"] = -319.47146277102,
          },
          [9] = {
            ["x"] = 645.19110131685,
            ["y"] = -307.37560308638,
          },
          [10] = {
            ["x"] = 644.79692697002,
            ["y"] = -290.13114022851,
          },
          [11] = {
            ["x"] = 635.01690338856,
            ["y"] = -274.99552764464,
          },
          [12] = {
            ["x"] = 621.04535548804,
            ["y"] = -257.76391059522,
          },
          [13] = {
            ["x"] = 607.30661042388,
            ["y"] = -241.6965975319,
          },
          [14] = {
            ["x"] = 621.04535548804,
            ["y"] = -257.76391059522,
          },
          [15] = {
            ["x"] = 635.01690338856,
            ["y"] = -274.99552764464,
          },
          [16] = {
            ["x"] = 644.79692697002,
            ["y"] = -290.13114022851,
          },
        },
      },
      [2] = {
        ["x"] = 554.74781169883,
        ["y"] = -301.17153466132,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 539.49317710124,
        ["y"] = -208.37933262827,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 561.69958131078,
        ["y"] = -175.9946032744,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 561.69958131078,
            ["y"] = -175.9946032744,
          },
          [2] = {
            ["x"] = 569.67061919111,
            ["y"] = -184.72841954529,
          },
          [3] = {
            ["x"] = 577.87061835935,
            ["y"] = -194.90770375138,
          },
          [4] = {
            ["x"] = 569.67061919111,
            ["y"] = -184.72841954529,
          },
          [5] = {
            ["x"] = 561.69958131078,
            ["y"] = -175.9946032744,
          },
          [6] = {
            ["x"] = 549.8775503886,
            ["y"] = -162.39052969125,
          },
          [7] = {
            ["x"] = 538.28448075432,
            ["y"] = -148.53536454096,
          },
          [8] = {
            ["x"] = 549.8775503886,
            ["y"] = -162.39052969125,
          },
        },
      },
      [5] = {
        ["x"] = 537.70053336802,
        ["y"] = -242.07172012979,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["inspiring"] = true,
        ["patrol"] = {
          [1] = {
            ["x"] = 537.70053336802,
            ["y"] = -242.07172012979,
          },
          [2] = {
            ["x"] = 522.01634863217,
            ["y"] = -233.95697655078,
          },
          [3] = {
            ["x"] = 501.05895829822,
            ["y"] = -231.62837873515,
          },
          [4] = {
            ["x"] = 483.12876411178,
            ["y"] = -234.88840768244,
          },
          [5] = {
            ["x"] = 460.30853150104,
            ["y"] = -248.86000456948,
          },
          [6] = {
            ["x"] = 483.12876411178,
            ["y"] = -234.88840768244,
          },
          [7] = {
            ["x"] = 501.05895829822,
            ["y"] = -231.62837873515,
          },
          [8] = {
            ["x"] = 522.01634863217,
            ["y"] = -233.95697655078,
          },
          [9] = {
            ["x"] = 551.82236469656,
            ["y"] = -248.3942590239,
          },
        },
      },
      [6] = {
        ["x"] = 485.65682942298,
        ["y"] = -301.42922454067,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 526.02851684797,
        ["y"] = -358.34482947793,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [8] = {
        ["x"] = 534.76211372536,
        ["y"] = -396.37545570552,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["inspiring"] = true,
        ["patrol"] = {
          [1] = {
            ["x"] = 534.76211372536,
            ["y"] = -396.37545570552,
          },
          [2] = {
            ["x"] = 545.35742318791,
            ["y"] = -388.18727378366,
          },
          [3] = {
            ["x"] = 557.4311723645,
            ["y"] = -380.6658988613,
          },
          [4] = {
            ["x"] = 545.35742318791,
            ["y"] = -388.18727378366,
          },
          [5] = {
            ["x"] = 534.76211372536,
            ["y"] = -396.37545570552,
          },
          [6] = {
            ["x"] = 520.22020697976,
            ["y"] = -403.82378978495,
          },
          [7] = {
            ["x"] = 503.59400710056,
            ["y"] = -410.75137306795,
          },
          [8] = {
            ["x"] = 520.22020697976,
            ["y"] = -403.82378978495,
          },
        },
      },
      [9] = {
        ["x"] = 584.17451212512,
        ["y"] = -413.61894439224,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 563.16274616586,
        ["y"] = -267.4083045977,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
      [11] = {
        ["x"] = 562.6519284372,
        ["y"] = -278.90107875315,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
    },
  },
  [3] = {
    ["name"] = "Vicious Gargon",
    ["id"] = 164563,
    ["count"] = 4,
    ["health"] = 181715,
    ["scale"] = 1,
    ["displayId"] = 93163,
    ["creatureType"] = "Beast",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [329321] = {
      },
      [329324] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 640.84765817772,
        ["y"] = -300.35714016579,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 651.73909106402,
        ["y"] = -300.39815897456,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 566.00199679534,
        ["y"] = -306.64390590614,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 564.36412516004,
        ["y"] = -294.99660866381,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 561.53454842218,
        ["y"] = -164.54524832177,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 550.60399408453,
        ["y"] = -173.46245025703,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 550.30669798655,
        ["y"] = -201.8608052688,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 538.42592040053,
        ["y"] = -195.78241784573,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 546.95783337098,
        ["y"] = -237.65835871819,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 541.18412473538,
        ["y"] = -251.09752998405,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 494.47040296104,
        ["y"] = -307.73475178408,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 494.32135135225,
        ["y"] = -294.16390827852,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 537.06019176075,
        ["y"] = -360.16072454646,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 533.7011983729,
        ["y"] = -350.09830536913,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 531.59857397811,
        ["y"] = -405.78796747718,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 524.81488389306,
        ["y"] = -396.02872168711,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 575.75641594623,
        ["y"] = -406.41519204025,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 575.57717387359,
        ["y"] = -418.79342859302,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 575.3648851274,
        ["y"] = -265.37637308293,
        ["g"] = 46,
        ["sublevel"] = 2,
        ["inspiring"] = true,
      },
      [20] = {
        ["x"] = 581.24826041828,
        ["y"] = -274.70936130425,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
      [21] = {
        ["x"] = 575.09387516733,
        ["y"] = -282.24601893409,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
    },
  },
  [4] = {
    ["name"] = "Depraved Obliterator",
    ["id"] = 165414,
    ["count"] = 4,
    ["health"] = 148676,
    ["scale"] = 1,
    ["displayId"] = 93680,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [325876] = {
        ["interruptible"] = true,
      },
      [338003] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 580.78817348011,
        ["y"] = -346.06449911417,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 573.73655784318,
        ["y"] = -223.34771971453,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 592.17572292022,
        ["y"] = -304.39552790091,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 571.1144495514,
        ["y"] = -266.29534293668,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 522.28356439557,
        ["y"] = -136.46602732706,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 530.43349482162,
        ["y"] = -128.33986438525,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 451.24551776528,
        ["y"] = -248.78570290371,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 453.52140287861,
        ["y"] = -220.3605628573,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 454.00081863403,
        ["y"] = -351.01025093587,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 527.03273789242,
        ["y"] = -378.75532205403,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 505.04459473604,
        ["y"] = -307.2123267579,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 527.17112405637,
        ["y"] = -432.80854968258,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 534.99071482784,
        ["y"] = -440.87688782484,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 466.98327302905,
        ["y"] = -374.93844388111,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 608.18353818013,
        ["y"] = -368.2053924725,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 600.93838476648,
        ["y"] = -361.32942829725,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 293.8633561763,
        ["y"] = -229.66147683077,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 324.88169393225,
        ["y"] = -357.16104266027,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 386.22268518271,
        ["y"] = -353.71111772965,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 285.85691675938,
        ["y"] = -330.50119336157,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 355.20759709859,
        ["y"] = -264.46292946509,
        ["g"] = 47,
        ["sublevel"] = 2,
      },
    },
  },
  [5] = {
    ["name"] = "Loyal Stoneborn",
    ["id"] = 174175,
    ["count"] = 4,
    ["health"] = 264312,
    ["scale"] = 1,
    ["displayId"] = 95706,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Control"] = true,
    },
    ["spells"] = {
      [342021] = {
      },
      [342189] = {
      },
      [346866] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 615.82151684662,
        ["y"] = -216.24965853659,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 479.6534408742,
        ["y"] = -211.31151219512,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 527.74339496828,
        ["y"] = -302.78530208711,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 504.89584218066,
        ["y"] = -389.91413637948,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 317.66361671072,
        ["y"] = -220.81599664984,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 402.89346940425,
        ["y"] = -350.90249356632,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 380.10823529412,
        ["y"] = -345.56911764706,
        ["sublevel"] = 2,
      },
      [8] = {
        ["x"] = 379.91058823529,
        ["y"] = -204.20735294118,
        ["sublevel"] = 2,
      },
    },
  },
  [6] = {
    ["name"] = "Toiling Groundskeeper",
    ["id"] = 165415,
    ["count"] = 2,
    ["health"] = 99117,
    ["scale"] = 0.6,
    ["displayId"] = 93814,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [338004] = {
      },
      [338005] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 603.89028728108,
        ["y"] = -188.47352131828,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 596.55626382204,
        ["y"] = -190.43268292683,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 607.99143875692,
        ["y"] = -185.73675035749,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 612.1520060193,
        ["y"] = -180.83526596394,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 573.13789700157,
        ["y"] = -193.11381488317,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 573.13789700157,
            ["y"] = -193.11381488317,
          },
          [2] = {
            ["x"] = 579.00169038669,
            ["y"] = -201.97664302695,
          },
          [3] = {
            ["x"] = 579.56718999636,
            ["y"] = -212.43870130721,
          },
          [4] = {
            ["x"] = 579.28445232619,
            ["y"] = -218.94215310777,
          },
          [5] = {
            ["x"] = 579.56718999636,
            ["y"] = -212.43870130721,
          },
          [6] = {
            ["x"] = 579.00169038669,
            ["y"] = -201.97664302695,
          },
          [7] = {
            ["x"] = 573.13789700157,
            ["y"] = -193.11381488317,
          },
          [8] = {
            ["x"] = 564.29823941789,
            ["y"] = -185.01116935012,
          },
          [9] = {
            ["x"] = 547.05000380156,
            ["y"] = -162.67327949608,
          },
          [10] = {
            ["x"] = 531.21552934409,
            ["y"] = -139.20436615337,
          },
          [11] = {
            ["x"] = 517.24746003,
            ["y"] = -109.89609133071,
          },
          [12] = {
            ["x"] = 511.87503171812,
            ["y"] = -90.668510003206,
          },
          [13] = {
            ["x"] = 517.24746003,
            ["y"] = -109.89609133071,
          },
          [14] = {
            ["x"] = 531.21552934409,
            ["y"] = -139.20436615337,
          },
          [15] = {
            ["x"] = 547.05000380156,
            ["y"] = -162.67327949608,
          },
          [16] = {
            ["x"] = 564.29823941789,
            ["y"] = -185.01116935012,
          },
        },
      },
      [6] = {
        ["x"] = 510.42413415644,
        ["y"] = -79.234153205885,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 503.64067481433,
        ["y"] = -79.515783313415,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 517.0175250072,
        ["y"] = -79.252290117379,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 498.2148947787,
        ["y"] = -80.92596584992,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 520.30903515286,
        ["y"] = -204.64889966194,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 513.97229360396,
        ["y"] = -205.06302439024,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 507.94148644318,
        ["y"] = -204.9270531013,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 502.41058567532,
        ["y"] = -204.80711778103,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 514.27621357619,
        ["y"] = -212.27654630973,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 547.51366424943,
        ["y"] = -417.82554377915,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 506.27323337648,
            ["y"] = -369.89746727959,
          },
          [2] = {
            ["x"] = 491.52024093544,
            ["y"] = -376.90520715298,
          },
          [3] = {
            ["x"] = 480.04024092689,
            ["y"] = -388.97898181237,
          },
          [4] = {
            ["x"] = 491.52024093544,
            ["y"] = -376.90520715298,
          },
          [5] = {
            ["x"] = 506.27323337648,
            ["y"] = -369.89746727959,
          },
          [6] = {
            ["x"] = 517.05328992228,
            ["y"] = -377.69693217022,
          },
          [7] = {
            ["x"] = 530.11670598825,
            ["y"] = -386.40588187704,
          },
          [8] = {
            ["x"] = 538.03395616063,
            ["y"] = -403.82378978495,
          },
          [9] = {
            ["x"] = 554.66015603983,
            ["y"] = -427.97134759799,
          },
          [10] = {
            ["x"] = 538.03395616063,
            ["y"] = -403.82378978495,
          },
          [11] = {
            ["x"] = 530.11670598825,
            ["y"] = -386.40588187704,
          },
          [12] = {
            ["x"] = 517.05328992228,
            ["y"] = -377.69693217022,
          },
        },
      },
      [16] = {
        ["x"] = 472.82331784653,
        ["y"] = -393.88214634146,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 564.847406834,
        ["y"] = -427.84629700293,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 563.72802452582,
        ["y"] = -433.04126829696,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 559.06776444999,
        ["y"] = -435.71726900859,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 555.16894756986,
        ["y"] = -437.09859068471,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 478.6925883143,
        ["y"] = -398.10895619055,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 484.23463795217,
        ["y"] = -403.25513907267,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 467.3121738236,
        ["y"] = -389.1803805922,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 616.29422593083,
        ["y"] = -399.0813083538,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 610.68584391867,
        ["y"] = -404.58130566836,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 609.61297281987,
        ["y"] = -411.99135977448,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 623.67725324755,
        ["y"] = -399.35763107157,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 360.59004821766,
        ["y"] = -206.27348731991,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 377.14559687903,
        ["y"] = -205.92095170448,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 371.70416765072,
        ["y"] = -206.94852705966,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 366.13815532718,
        ["y"] = -206.79570731707,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 299.84077013139,
        ["y"] = -205.98192371675,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 294.59544297612,
        ["y"] = -205.56189429739,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 305.59429856413,
        ["y"] = -205.54744453653,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 288.96218325008,
        ["y"] = -204.81060337049,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 342.94238573298,
        ["y"] = -371.6262388418,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 348.97657616703,
        ["y"] = -373.84716750059,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 354.86874146207,
        ["y"] = -373.44917439074,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 360.53425987024,
        ["y"] = -371.75257158555,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 299.90439184667,
        ["y"] = -367.40815028176,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 304.28346942215,
        ["y"] = -370.3360351552,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 310.29484945434,
        ["y"] = -371.69251254916,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [43] = {
        ["x"] = 316.43808142088,
        ["y"] = -369.43457510995,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Depraved Collector",
    ["id"] = 165529,
    ["count"] = 4,
    ["health"] = 165195,
    ["scale"] = 1,
    ["displayId"] = 94573,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [325700] = {
        ["interruptible"] = true,
      },
      [325701] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 509.24232192489,
        ["y"] = -116.84733380362,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 523.58148021409,
        ["y"] = -445.40480682371,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 594.00432558633,
        ["y"] = -377.42466763037,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 354.37768300635,
        ["y"] = -289.1351999351,
        ["g"] = 47,
        ["sublevel"] = 2,
        ["inspiring"] = true,
      },
    },
  },
  [8] = {
    ["name"] = "Shard of Halkias",
    ["id"] = 164557,
    ["count"] = 10,
    ["health"] = 396468,
    ["scale"] = 1.5,
    ["displayId"] = 94868,
    ["creatureType"] = "Elemental",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [325509] = {
      },
      [326409] = {
      },
      [326441] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 500.56977745776,
        ["y"] = -105.20792744249,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 515.15721273458,
        ["y"] = -453.94000042869,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 584.11234047443,
        ["y"] = -384.57601943778,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Halkias",
    ["id"] = 165408,
    ["count"] = 0,
    ["health"] = 1152735,
    ["scale"] = 1,
    ["displayId"] = 98764,
    ["creatureType"] = "Elemental",
    ["level"] = 60,
    ["isBoss"] = true,
    ["encounterID"] = 2406,
    ["instanceID"] = 1185,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [322711] = {
      },
      [322936] = {
      },
      [322943] = {
      },
      [322977] = {
      },
      [323001] = {
      },
      [339235] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 444.80119681877,
        ["y"] = -299.05400138059,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Stoneborn Reaver",
    ["id"] = 167612,
    ["count"] = 6,
    ["health"] = 264312,
    ["scale"] = 1,
    ["displayId"] = 93829,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [326607] = {
        ["interruptible"] = true,
      },
      [326623] = {
      },
      [326632] = {
      },
      [326636] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 412.79937396227,
        ["y"] = -207.58864929716,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 361.57221604128,
        ["y"] = -248.77213078998,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 367.20781025633,
        ["y"] = -301.86321740141,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 337.03125324417,
        ["y"] = -301.65200070918,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 283.61837111263,
        ["y"] = -265.9072071335,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 371.59210818649,
        ["y"] = -339.27463443598,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Stonefiend Anklebiter",
    ["id"] = 167610,
    ["count"] = 1,
    ["health"] = 49559,
    ["scale"] = 0.6,
    ["displayId"] = 94765,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [326874] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 417.37974058081,
        ["y"] = -215.84945223269,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 409.95111138479,
        ["y"] = -216.86611574768,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 402.85736600558,
        ["y"] = -209.2558855613,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 404.60619504867,
        ["y"] = -203.24837037221,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 406.51541563679,
        ["y"] = -213.06585365854,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 384.0398113725,
        ["y"] = -269.43346030856,
        ["g"] = 44,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [7] = {
        ["x"] = 386.75520038075,
        ["y"] = -265.32876507851,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 379.22266388275,
        ["y"] = -264.93048818341,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 378.28110593909,
        ["y"] = -270.5563091362,
        ["g"] = 44,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 378.28110593909,
            ["y"] = -270.5563091362,
          },
          [2] = {
            ["x"] = 369.05250334558,
            ["y"] = -278.53220707483,
          },
          [3] = {
            ["x"] = 356.01236665553,
            ["y"] = -285.75087380071,
          },
          [4] = {
            ["x"] = 338.31502401438,
            ["y"] = -282.2579718357,
          },
          [5] = {
            ["x"] = 326.67204411303,
            ["y"] = -266.88923716673,
          },
          [6] = {
            ["x"] = 338.31502401438,
            ["y"] = -282.2579718357,
          },
          [7] = {
            ["x"] = 356.01236665553,
            ["y"] = -285.75087380071,
          },
          [8] = {
            ["x"] = 369.05250334558,
            ["y"] = -278.53220707483,
          },
          [9] = {
            ["x"] = 378.28110593909,
            ["y"] = -270.5563091362,
          },
          [10] = {
            ["x"] = 379.76405204997,
            ["y"] = -252.91763929995,
          },
          [11] = {
            ["x"] = 372.77828809297,
            ["y"] = -240.11036540576,
          },
          [12] = {
            ["x"] = 379.76405204997,
            ["y"] = -252.91763929995,
          },
        },
      },
      [10] = {
        ["x"] = 382.74729050909,
        ["y"] = -259.54479694761,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 342.8557421066,
        ["y"] = -312.2508621697,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 339.73388541786,
        ["y"] = -322.02347930462,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 347.71012361202,
        ["y"] = -317.10071484616,
        ["g"] = 35,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 347.71012361202,
            ["y"] = -317.10071484616,
          },
          [2] = {
            ["x"] = 356.75710150507,
            ["y"] = -317.10866592438,
          },
          [3] = {
            ["x"] = 370.03010099099,
            ["y"] = -321.76586188222,
          },
          [4] = {
            ["x"] = 378.87878730144,
            ["y"] = -337.60032214293,
          },
          [5] = {
            ["x"] = 370.03010099099,
            ["y"] = -321.76586188222,
          },
          [6] = {
            ["x"] = 356.75710150507,
            ["y"] = -317.10866592438,
          },
          [7] = {
            ["x"] = 347.71012361202,
            ["y"] = -317.10071484616,
          },
          [8] = {
            ["x"] = 333.1385237489,
            ["y"] = -324.49163180353,
          },
          [9] = {
            ["x"] = 328.34822015278,
            ["y"] = -336.4360281501,
          },
          [10] = {
            ["x"] = 330.67682812496,
            ["y"] = -345.05183167818,
          },
          [11] = {
            ["x"] = 328.34822015278,
            ["y"] = -336.4360281501,
          },
          [12] = {
            ["x"] = 333.1385237489,
            ["y"] = -324.49163180353,
          },
        },
      },
      [14] = {
        ["x"] = 340.21293432154,
        ["y"] = -316.60880923677,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 345.56557104073,
        ["y"] = -322.52886807778,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 283.09797824473,
        ["y"] = -257.26571335504,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 292.4220577532,
        ["y"] = -272.38278527081,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 291.02895169784,
        ["y"] = -259.43703184657,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 284.03186087142,
        ["y"] = -274.94387222184,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 291.78699452126,
        ["y"] = -265.30751459918,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 358.83189772963,
        ["y"] = -302.64346325962,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 368.8762614771,
        ["y"] = -310.35492710216,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 360.91126141289,
        ["y"] = -310.14367877076,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 368.50003945321,
        ["y"] = -294.51491826572,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 360.67591917998,
        ["y"] = -294.79205566701,
        ["g"] = 36,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
    },
  },
  [12] = {
    ["name"] = "Stoneborn Eviscerator",
    ["id"] = 167611,
    ["count"] = 4,
    ["health"] = 165195,
    ["scale"] = 1,
    ["displayId"] = 94724,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [326632] = {
      },
      [326638] = {
      },
      [326642] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 348.07641889049,
        ["y"] = -232.02190748765,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 336.44794334504,
        ["y"] = -231.27677501808,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 368.40404196343,
        ["y"] = -257.56939846542,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 328.1094708373,
        ["y"] = -293.86438700804,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 328.31083030046,
        ["y"] = -310.50733901424,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 369.23177693357,
        ["y"] = -326.10166420859,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Stoneborn Slasher",
    ["id"] = 167607,
    ["count"] = 7,
    ["health"] = 330390,
    ["scale"] = 1.3,
    ["displayId"] = 95707,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [326771] = {
      },
      [326997] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 322.45000427918,
        ["y"] = -251.45600405818,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 322.45000427918,
            ["y"] = -251.45600405818,
          },
          [2] = {
            ["x"] = 330.38469333919,
            ["y"] = -269.25175176363,
          },
          [3] = {
            ["x"] = 337.83618288792,
            ["y"] = -284.85333923522,
          },
          [4] = {
            ["x"] = 350.64347676862,
            ["y"] = -301.85208349551,
          },
          [5] = {
            ["x"] = 337.83618288792,
            ["y"] = -284.85333923522,
          },
          [6] = {
            ["x"] = 330.38469333919,
            ["y"] = -269.25175176363,
          },
          [7] = {
            ["x"] = 322.45000427918,
            ["y"] = -251.45600405818,
          },
          [8] = {
            ["x"] = 307.33157634584,
            ["y"] = -236.88425284785,
          },
          [9] = {
            ["x"] = 297.7843416208,
            ["y"] = -212.66684186168,
          },
          [10] = {
            ["x"] = 307.33157634584,
            ["y"] = -236.88425284785,
          },
        },
      },
      [2] = {
        ["x"] = 304.13529335241,
        ["y"] = -287.33297560976,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 328.32822879725,
        ["y"] = -335.89614373528,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 328.09534601487,
            ["y"] = -333.10184015113,
          },
          [2] = {
            ["x"] = 336.90502743085,
            ["y"] = -320.63633015862,
          },
          [3] = {
            ["x"] = 350.87661530437,
            ["y"] = -305.26759548964,
          },
          [4] = {
            ["x"] = 336.90502743085,
            ["y"] = -320.63633015862,
          },
          [5] = {
            ["x"] = 328.09534601487,
            ["y"] = -333.10184015113,
          },
          [6] = {
            ["x"] = 321.53628276862,
            ["y"] = -344.62087834892,
          },
          [7] = {
            ["x"] = 309.89330286727,
            ["y"] = -362.0853581942,
          },
          [8] = {
            ["x"] = 321.53628276862,
            ["y"] = -344.62087834892,
          },
        },
      },
      [4] = {
        ["x"] = 305.30454013269,
        ["y"] = -316.92936585366,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Echelon",
    ["id"] = 164185,
    ["count"] = 0,
    ["health"] = 1152735,
    ["scale"] = 1,
    ["displayId"] = 96260,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["isBoss"] = true,
    ["encounterID"] = 2387,
    ["instanceID"] = 1185,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [319733] = {
      },
      [319941] = {
      },
      [326389] = {
      },
      [327411] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 229.9869812246,
        ["y"] = -302.45293888567,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "High Adjudicator Aleez",
    ["id"] = 165410,
    ["count"] = 0,
    ["health"] = 1152735,
    ["scale"] = 1,
    ["displayId"] = 94503,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["isBoss"] = true,
    ["encounterID"] = 2411,
    ["instanceID"] = 1185,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [323538] = {
      },
      [323552] = {
      },
      [329340] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 163.61882352941,
        ["y"] = -275.60647058824,
        ["sublevel"] = 2,
      },
    },
  },
  [16] = {
    ["name"] = "Tormented Soul",
    ["id"] = 167892,
    ["count"] = 0,
    ["health"] = 33039,
    ["scale"] = 1,
    ["displayId"] = 90426,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
    },
    ["clones"] = {
      [1] = {
        ["x"] = 535.864,
        ["y"] = -305.44425,
        ["g"] = 49,
        ["sublevel"] = 3,
      },
      [2] = {
        ["x"] = 508.844,
        ["y"] = -305.77725,
        ["g"] = 49,
        ["sublevel"] = 3,
      },
      [3] = {
        ["x"] = 512.036,
        ["y"] = -291.486,
        ["g"] = 49,
        ["sublevel"] = 3,
      },
      [4] = {
        ["x"] = 548.016,
        ["y"] = -296.39775,
        ["g"] = 49,
        ["sublevel"] = 3,
      },
      [5] = {
        ["x"] = 524.748,
        ["y"] = -300.94875,
        ["g"] = 49,
        ["sublevel"] = 3,
      },
      [6] = {
        ["x"] = 495.768,
        ["y"] = -246.22575,
        ["g"] = 48,
        ["sublevel"] = 3,
      },
      [7] = {
        ["x"] = 507.5,
        ["y"] = -242.424,
        ["g"] = 48,
        ["sublevel"] = 3,
      },
      [8] = {
        ["x"] = 536.228,
        ["y"] = -236.208,
        ["g"] = 48,
        ["sublevel"] = 3,
      },
      [9] = {
        ["x"] = 522.816,
        ["y"] = -233.322,
        ["g"] = 48,
        ["sublevel"] = 3,
      },
      [10] = {
        ["x"] = 524.104,
        ["y"] = -244.61625,
        ["g"] = 48,
        ["sublevel"] = 3,
      },
      [11] = {
        ["x"] = 549.528,
        ["y"] = -250.8045,
        ["g"] = 48,
        ["sublevel"] = 3,
      },
      [12] = {
        ["x"] = 400.792,
        ["y"] = -238.95525,
        ["g"] = 51,
        ["sublevel"] = 3,
      },
      [13] = {
        ["x"] = 413.532,
        ["y"] = -248.418,
        ["g"] = 51,
        ["sublevel"] = 3,
      },
      [14] = {
        ["x"] = 435.092,
        ["y"] = -243.645,
        ["g"] = 51,
        ["sublevel"] = 3,
      },
      [15] = {
        ["x"] = 424.144,
        ["y"] = -249.00075,
        ["g"] = 51,
        ["sublevel"] = 3,
      },
      [16] = {
        ["x"] = 422.156,
        ["y"] = -235.56975,
        ["g"] = 51,
        ["sublevel"] = 3,
      },
      [17] = {
        ["x"] = 398.46894599542,
        ["y"] = -249.3941132059,
        ["g"] = 51,
        ["sublevel"] = 3,
      },
      [18] = {
        ["x"] = 411.124,
        ["y"] = -300.5325,
        ["g"] = 50,
        ["sublevel"] = 3,
      },
      [19] = {
        ["x"] = 398.412,
        ["y"] = -291.06975,
        ["g"] = 50,
        ["sublevel"] = 3,
      },
      [20] = {
        ["x"] = 423.248,
        ["y"] = -292.12425,
        ["g"] = 50,
        ["sublevel"] = 3,
      },
      [21] = {
        ["x"] = 436.548,
        ["y"] = -306.72075,
        ["g"] = 50,
        ["sublevel"] = 3,
      },
      [22] = {
        ["x"] = 422.268,
        ["y"] = -305.028,
        ["g"] = 50,
        ["sublevel"] = 3,
      },
      [23] = {
        ["x"] = 399.57250540886,
        ["y"] = -307.52571979574,
        ["g"] = 50,
        ["sublevel"] = 3,
      },
      [24] = {
        ["x"] = 496.384,
        ["y"] = -302.55825,
        ["g"] = 49,
        ["sublevel"] = 3,
      },
    },
  },
  [17] = {
    ["name"] = "Inquisitor Sigar",
    ["id"] = 167876,
    ["count"] = 20,
    ["health"] = 495585,
    ["scale"] = 1.5,
    ["displayId"] = 93070,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [326794] = {
      },
      [326829] = {
        ["interruptible"] = true,
      },
      [326847] = {
      },
      [326891] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 384.10689319804,
        ["y"] = -273.05809040065,
        ["sublevel"] = 3,
      },
    },
  },
  [18] = {
    ["name"] = "Lord Chamberlain",
    ["id"] = 164218,
    ["count"] = 0,
    ["health"] = 1317412,
    ["scale"] = 1,
    ["displayId"] = 95103,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["isBoss"] = true,
    ["encounterID"] = 2413,
    ["instanceID"] = 1185,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [323143] = {
      },
      [323236] = {
      },
      [323393] = {
      },
      [323437] = {
      },
      [327885] = {
      },
      [329104] = {
      },
      [329113] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 93.11379873382,
        ["y"] = -272.04936157374,
        ["sublevel"] = 3,
      },
    },
  },
  [19] = {
    ["name"] = "Executioner Varruth",
    ["id"] = 179890,
    ["count"] = 0,
    ["health"] = 336131,
    ["ignoreFortified"] = true,
    ["scale"] = 1.5,
    ["displayId"] = 92418,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 128,
    },
    ["spells"] = {
      [355714] = {
      },
      [356923] = {
      },
      [356925] = {
      },
      [358971] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 469.32919621953,
        ["y"] = -301.56258467197,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Soggodon the Breaker",
    ["id"] = 179891,
    ["count"] = 0,
    ["health"] = 358540,
    ["ignoreFortified"] = true,
    ["scale"] = 1.5,
    ["displayId"] = 98535,
    ["creatureType"] = "Humanoid",
    ["level"] = 62,
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 128,
    },
    ["spells"] = {
      [355719] = {
      },
      [355806] = {
      },
      [358784] = {
      },
      [358968] = {
      },
      [358970] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 515.79976099984,
        ["y"] = -302.15084049818,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Incinerator Arkolath",
    ["id"] = 179446,
    ["count"] = 0,
    ["health"] = 336131,
    ["ignoreFortified"] = true,
    ["scale"] = 1.5,
    ["displayId"] = 100718,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 128,
    },
    ["spells"] = {
      [355707] = {
      },
      [355732] = {
      },
      [355737] = {
      },
      [358967] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 629.42066648395,
        ["y"] = -308.23115484964,
        ["sublevel"] = 2,
      },
    },
  },
  [22] = {
    ["name"] = "Oros Coldheart",
    ["id"] = 179892,
    ["count"] = 0,
    ["health"] = 336131,
    ["ignoreFortified"] = true,
    ["scale"] = 1.5,
    ["displayId"] = 97237,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 128,
    },
    ["spells"] = {
      [355710] = {
      },
      [356414] = {
      },
      [356666] = {
      },
      [358894] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 309.80538327075,
        ["y"] = -322.8465030885,
        ["sublevel"] = 2,
      },
    },
  },
  [23] = {
    ["name"] = "Vy Relic",
    ["id"] = 185680,
    ["count"] = 0,
    ["health"] = 33022,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 103111,
    ["iconTexture"] = 4335643,
    ["creatureType"] = "Mechanical",
    ["level"] = 62,
    ["bonusSpell"] = 368240,
    ["badCreatureModel"] = true,
    ["modelPosition"] = {
      [1] = 0,
      [2] = 0,
      [3] = 0.75,
    },
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 130,
    },
    ["spells"] = {
      [366406] = {
      },
      [366409] = {
      },
      [368103] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 552.57919918131,
        ["y"] = -289.86872970874,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 539.03860635956,
        ["y"] = -120.35941358259,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 445.62009286431,
        ["y"] = -208.08813480961,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 573.52705671696,
        ["y"] = -431.54455743566,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 440.24593122942,
        ["y"] = -276.97479956142,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 220.77423218801,
        ["y"] = -281.01512911562,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 161.52794110685,
        ["y"] = -249.66400161623,
        ["sublevel"] = 2,
      },
      [8] = {
        ["x"] = 88.421115954799,
        ["y"] = -245.53830982418,
        ["sublevel"] = 3,
      },
      [9] = {
        ["x"] = 564.5265349419,
        ["y"] = -250.66598955404,
        ["sublevel"] = 2,
      },
      [10] = {
        ["x"] = 339.69178549421,
        ["y"] = -251.20595260713,
        ["sublevel"] = 2,
      },
      [11] = {
        ["x"] = 372.33880786981,
        ["y"] = -253.93294635587,
        ["sublevel"] = 3,
      },
      [12] = {
        ["x"] = 356.32380153794,
        ["y"] = -325.36060794379,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 274.31874761079,
        ["y"] = -324.5753861859,
        ["sublevel"] = 1,
      },
    },
  },
  [24] = {
    ["name"] = "Wo Relic",
    ["id"] = 185683,
    ["count"] = 0,
    ["health"] = 33022,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 101046,
    ["iconTexture"] = 4335644,
    ["creatureType"] = "Mechanical",
    ["level"] = 62,
    ["bonusSpell"] = 368241,
    ["badCreatureModel"] = true,
    ["modelPosition"] = {
      [1] = 0,
      [2] = 0,
      [3] = 0.6,
    },
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 130,
    },
    ["spells"] = {
      [366566] = {
      },
      [368078] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 543.31252051728,
        ["y"] = -300.56166623189,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 516.36417348822,
        ["y"] = -125.35942066953,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 440.79864593523,
        ["y"] = -220.94526531286,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 555.77196362598,
        ["y"] = -426.95273841799,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 421.6283750002,
        ["y"] = -300.2236343735,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 202.73852245964,
        ["y"] = -301.90801982757,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 138.1188483016,
        ["y"] = -276.70948732878,
        ["sublevel"] = 2,
      },
      [8] = {
        ["x"] = 66.808185391348,
        ["y"] = -272.15119681285,
        ["sublevel"] = 3,
      },
      [9] = {
        ["x"] = 547.10898630336,
        ["y"] = -277.76760395962,
        ["sublevel"] = 2,
      },
      [10] = {
        ["x"] = 331.29892292863,
        ["y"] = -276.20596647719,
        ["sublevel"] = 2,
      },
      [11] = {
        ["x"] = 360.37449942445,
        ["y"] = -273.04006992622,
        ["sublevel"] = 3,
      },
      [12] = {
        ["x"] = 356.18624605432,
        ["y"] = -339.29800557472,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 272.31874217559,
        ["y"] = -338.70038299775,
        ["sublevel"] = 1,
      },
    },
  },
  [25] = {
    ["name"] = "Urh Relic",
    ["id"] = 185685,
    ["count"] = 0,
    ["health"] = 33022,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 105134,
    ["iconTexture"] = 4335642,
    ["creatureType"] = "Mechanical",
    ["level"] = 62,
    ["bonusSpell"] = 368239,
    ["badCreatureModel"] = true,
    ["modelPosition"] = {
      [1] = 0,
      [2] = 0,
      [3] = 0.75,
    },
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 130,
    },
    ["spells"] = {
      [366288] = {
      },
      [366297] = {
      },
      [368243] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 551.17508881527,
        ["y"] = -312.8978252267,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 512.17813810417,
        ["y"] = -144.54545222367,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 466.33437911097,
        ["y"] = -222.90954658526,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 547.81279664885,
        ["y"] = -442.66701867755,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 441.85304955196,
        ["y"] = -320.5462118117,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 220.59564304962,
        ["y"] = -323.33657066631,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 162.46290575281,
        ["y"] = -301.13297671838,
        ["sublevel"] = 2,
      },
      [8] = {
        ["x"] = 89.243611327633,
        ["y"] = -298.33579626578,
        ["sublevel"] = 3,
      },
      [9] = {
        ["x"] = 564.77381907871,
        ["y"] = -294.20986720908,
        ["sublevel"] = 2,
      },
      [10] = {
        ["x"] = 341.65608226078,
        ["y"] = -301.92027565396,
        ["sublevel"] = 2,
      },
      [11] = {
        ["x"] = 373.94595698302,
        ["y"] = -291.96866565063,
        ["sublevel"] = 3,
      },
      [12] = {
        ["x"] = 365.25645203806,
        ["y"] = -352.72305708744,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 280.69369385694,
        ["y"] = -354.82539597363,
        ["sublevel"] = 1,
      },
    },
  },
};
