local MDT = MDT
local L = MDT.L
local dungeonIndex = 41
MDT.dungeonList[dungeonIndex] = L["IronDocks"]
MDT.dungeonMaps[dungeonIndex] = {
  [0] = "IronDocks",
  [1] = "IronDocks1_",
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["IronDocks"],
}
MDT.mapInfo[dungeonIndex] = {
  viewportPositionOverrides = {
    [1] = {
      zoomScale = 1.2999999523163,
      horizontalPan = 193.84615203593,
      verticalPan = 39.418697423882,
    },
  }
};

local zones = { 595 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonTotalCount[dungeonIndex] = { normal = 400, teeming = 1000, teemingEnabled = true }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 248.70555745877,
      ["y"] = -246.22239132748,
      ["graveyardDescription"] = "",
    },
    [2] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 724.44479173964,
      ["y"] = -427.48094307747,
      ["graveyardDescription"] = "Unlocks after defeating Grimrail Enforcers",
    },
    [3] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "ironDocksIronStar",
      ["x"] = 270.67760352742,
      ["y"] = -320.03080240584,
      ["starIndex"] = 1,
    },
    [4] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "ironDocksIronStar",
      ["x"] = 270.94430038219,
      ["y"] = -348.5158205704,
      ["starIndex"] = 2,
    },
    [5] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "ironDocksIronStar",
      ["x"] = 271.23275754648,
      ["y"] = -378.08312556949,
      ["starIndex"] = 3,
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Grom'kar Footsoldier",
    ["id"] = 81283,
    ["count"] = 4,
    ["health"] = 213361,
    ["scale"] = 1,
    ["displayId"] = 57845,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [169413] = {
      },
      [172889] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 275.38083673082,
        ["y"] = -220.31454197178,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 304.9107705924,
        ["y"] = -204.04612260176,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 303.95177951554,
        ["y"] = -212.73579142922,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 273.38142410032,
        ["y"] = -167.86145857848,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 277.48762864374,
        ["y"] = -148.47345581421,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 247.92614169931,
        ["y"] = -173.65651515678,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 277.05902181838,
        ["y"] = -158.58522258143,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 265.51307413848,
        ["y"] = -173.58267605697,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 256.52093318675,
        ["y"] = -174.2664570111,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 315.86872226815,
        ["y"] = -173.09714744276,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 306.34204874269,
        ["y"] = -160.36923404417,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [12] = {
        ["x"] = 325.0764842437,
        ["y"] = -185.40302085455,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 308.61678100503,
        ["y"] = -234.22182291638,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 356.31232785854,
        ["y"] = -206.07050743613,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 362.41271523179,
        ["y"] = -188.47947019868,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 359.65699005982,
        ["y"] = -193.03732653575,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 354.64395887507,
        ["y"] = -170.87694204124,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Nathrezim Infiltrator",
    ["id"] = 189878,
    ["count"] = 4,
    ["health"] = 239096,
    ["scale"] = 1,
    ["displayId"] = 101016,
    ["creatureType"] = "Demon",
    ["level"] = 61,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [373364] = {
      },
      [373370] = {
      },
      [373429] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 283.36211237634,
        ["y"] = -216.15368407763,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
        ["shrouded"] = true,
      },
      [2] = {
        ["x"] = 345.27201036457,
        ["y"] = -235.98737136696,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["shrouded"] = true,
      },
      [3] = {
        ["x"] = 364.11998786086,
        ["y"] = -170.17298030965,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["shrouded"] = true,
      },
      [4] = {
        ["x"] = 455.24631277868,
        ["y"] = -172.10600315323,
        ["sublevel"] = 1,
        ["shrouded"] = true,
      },
      [5] = {
        ["x"] = 469.33995752046,
        ["y"] = -429.37321658029,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["shrouded"] = true,
      },
      [6] = {
        ["x"] = 500.27144149378,
        ["y"] = -440.49954140313,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.1,
        ["shrouded"] = true,
      },
      [7] = {
        ["x"] = 624.22332428364,
        ["y"] = -443.39992903361,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["shrouded"] = true,
      },
      [8] = {
        ["x"] = 723.18269630159,
        ["y"] = -307.74318383943,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["shrouded"] = true,
      },
      [9] = {
        ["x"] = 688.8549086606,
        ["y"] = -205.17199164342,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["shrouded"] = true,
      },
      [10] = {
        ["x"] = 727.35216976352,
        ["y"] = -149.46433030339,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["shrouded"] = true,
      },
      [11] = {
        ["x"] = 566.05974543009,
        ["y"] = -145.3655314713,
        ["sublevel"] = 1,
        ["shrouded"] = true,
      },
    },
  },
  [3] = {
    ["name"] = "Grom'kar Incinerator",
    ["id"] = 86809,
    ["count"] = 5,
    ["health"] = 213361,
    ["scale"] = 1,
    ["displayId"] = 61281,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Root"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [167516] = {
      },
      [172771] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 274.59109320302,
        ["y"] = -211.37126753498,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 312.01313594507,
        ["y"] = -210.64275861384,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [3] = {
        ["x"] = 307.45900650621,
        ["y"] = -170.21685766789,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 333.73955713991,
        ["y"] = -186.96223081991,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 375.8271160523,
        ["y"] = -206.34189790394,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Grom'kar Battlemaster",
    ["id"] = 83025,
    ["count"] = 9,
    ["health"] = 341378,
    ["scale"] = 1,
    ["displayId"] = 57476,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [167232] = {
      },
      [167233] = {
      },
      [169302] = {
      },
      [172860] = {
      },
      [172889] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 288.43053341995,
        ["y"] = -194.09494064953,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [2] = {
        ["x"] = 615.56048689708,
        ["y"] = -441.01433432378,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 739.97670862418,
        ["y"] = -151.2883084387,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [4] = {
        ["x"] = 360.69842597435,
        ["y"] = -203.25326207447,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
    },
  },
  [5] = {
    ["name"] = "Grom'kar Deadeye",
    ["id"] = 83028,
    ["count"] = 3,
    ["health"] = 213361,
    ["scale"] = 1,
    ["displayId"] = 61340,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Root"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [167239] = {
      },
      [167240] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 314.36561448177,
        ["y"] = -202.28171357651,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 314.00315437399,
        ["y"] = -165.31124124412,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 373.24942218436,
        ["y"] = -171.59190161228,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [4] = {
        ["x"] = 469.25124714954,
        ["y"] = -121.1493348765,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 469.25124714954,
            ["y"] = -121.1493348765,
          },
          [2] = {
            ["x"] = 468.08500029105,
            ["y"] = -132.08540763095,
          },
          [3] = {
            ["x"] = 469.25124714954,
            ["y"] = -121.1493348765,
          },
          [4] = {
            ["x"] = 468.24090522779,
            ["y"] = -103.55111045434,
          },
          [5] = {
            ["x"] = 468.55278647814,
            ["y"] = -93.415960171968,
          },
          [6] = {
            ["x"] = 468.24090522779,
            ["y"] = -103.55111045434,
          },
        },
      },
      [5] = {
        ["x"] = 445.4602129303,
        ["y"] = -129.34952211682,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 445.4602129303,
            ["y"] = -129.34952211682,
          },
          [2] = {
            ["x"] = 426.60886915657,
            ["y"] = -141.59677226973,
          },
          [3] = {
            ["x"] = 445.4602129303,
            ["y"] = -129.34952211682,
          },
          [4] = {
            ["x"] = 458.72942598367,
            ["y"] = -117.89613483547,
          },
        },
      },
      [6] = {
        ["x"] = 283.61295902137,
        ["y"] = -215.52660334744,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
    },
  },
  [6] = {
    ["name"] = "Unruly Ogron",
    ["id"] = 87252,
    ["count"] = 9,
    ["health"] = 639150,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 57815,
    ["creatureType"] = "Giant",
    ["level"] = 61,
    ["clones"] = {
      [1] = {
        ["x"] = 258.42809947425,
        ["y"] = -151.38035173613,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
    },
  },
  [7] = {
    ["name"] = "Grom'kar Technician",
    ["id"] = 81432,
    ["count"] = 4,
    ["health"] = 213361,
    ["scale"] = 1,
    ["displayId"] = 56403,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [172636] = {
      },
      [172649] = {
      },
      [172703] = {
      },
      [178298] = {
      },
      [178299] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 335.76264900662,
        ["y"] = -154.42231788079,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 325.17152344366,
        ["y"] = -228.19017381844,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 307.11396418382,
        ["y"] = -242.18000555655,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 315.13138317635,
        ["y"] = -238.73117289963,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 340.99178807947,
        ["y"] = -228.10132450331,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 364.11998786086,
        ["y"] = -170.17298030965,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
      [7] = {
        ["x"] = 447.26535513691,
        ["y"] = -160.74801073197,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 460.34999125728,
        ["y"] = -148.34927188196,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 452.10003556125,
        ["y"] = -138.3413300154,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 491.54649006623,
        ["y"] = -98.091655629139,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 479.50026454188,
        ["y"] = -96.15667425531,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 470.76344370861,
        ["y"] = -87.638543046358,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 483.45462701887,
        ["y"] = -104.64054674859,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 556.24429339754,
        ["y"] = -456.48637440062,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 675.66359612877,
        ["y"] = -314.78461027083,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 721.0219284542,
        ["y"] = -154.54790004387,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
      [17] = {
        ["x"] = 345.27201036457,
        ["y"] = -235.98737136696,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
      [18] = {
        ["x"] = 455.24631277868,
        ["y"] = -172.10600315323,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
      [19] = {
        ["x"] = 625.77326261232,
        ["y"] = -443.22771092646,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
    },
  },
  [8] = {
    ["name"] = "Champion Druna",
    ["id"] = 81603,
    ["count"] = 9,
    ["health"] = 341378,
    ["scale"] = 1,
    ["displayId"] = 56461,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["spells"] = {
      [166923] = {
      },
      [172810] = {
      },
      [173091] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 329.20632923345,
        ["y"] = -194.45386728776,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
    },
  },
  [9] = {
    ["name"] = "Siegemaster Olugar",
    ["id"] = 83026,
    ["count"] = 9,
    ["health"] = 341378,
    ["scale"] = 1,
    ["displayId"] = 57477,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [172952] = {
      },
      [172963] = {
      },
      [172982] = {
      },
      [173455] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 343.94143272386,
        ["y"] = -214.48403065067,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
        ["patrol"] = {
          [1] = {
            ["x"] = 343.94143272386,
            ["y"] = -214.48403065067,
          },
          [2] = {
            ["x"] = 361.2000905585,
            ["y"] = -215.29338432944,
          },
          [3] = {
            ["x"] = 381.01615739729,
            ["y"] = -215.29338432944,
          },
          [4] = {
            ["x"] = 361.2000905585,
            ["y"] = -215.29338432944,
          },
          [5] = {
            ["x"] = 343.94143272386,
            ["y"] = -214.48403065067,
          },
          [6] = {
            ["x"] = 341.38405242562,
            ["y"] = -198.86362519841,
          },
          [7] = {
            ["x"] = 341.00778963455,
            ["y"] = -176.79006055448,
          },
          [8] = {
            ["x"] = 341.38405242562,
            ["y"] = -198.86362519841,
          },
        },
      },
    },
  },
  [10] = {
    ["name"] = "Zul'gamux",
    ["id"] = 190128,
    ["count"] = 12,
    ["health"] = 639150,
    ["scale"] = 1,
    ["displayId"] = 101106,
    ["creatureType"] = "Demon",
    ["level"] = 61,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [373509] = {
      },
      [373513] = {
      },
      [373552] = {
      },
      [373724] = {
      },
      [373729] = {
      },
      [373744] = {
      },
      [373747] = {
      },
      [374273] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 365.9213712246,
        ["y"] = -206.87080832128,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
        ["shrouded"] = true,
      },
    },
  },
  [11] = {
    ["name"] = "Grom'kar Technician",
    ["id"] = 83763,
    ["count"] = 2,
    ["health"] = 213361,
    ["scale"] = 1,
    ["displayId"] = 60630,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [172636] = {
      },
      [172649] = {
      },
      [172703] = {
      },
      [178298] = {
      },
      [178299] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 349.86465962322,
        ["y"] = -201.00256229522,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 352.99145238567,
        ["y"] = -327.61612334981,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 362.08362017098,
        ["y"] = -328.38870613973,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 363.10124102646,
        ["y"] = -369.65364264238,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 353.88246361377,
        ["y"] = -370.00497382291,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 451.39437278958,
        ["y"] = -368.4791190132,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 477.26689928947,
        ["y"] = -377.50860201574,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Pitwarden Gwarnok",
    ["id"] = 84520,
    ["count"] = 9,
    ["health"] = 341378,
    ["scale"] = 1,
    ["displayId"] = 58394,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["spells"] = {
      [167232] = {
      },
      [167233] = {
      },
      [172860] = {
      },
      [172889] = {
      },
      [172943] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 381.80058656667,
        ["y"] = -174.05630959732,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
    },
  },
  [13] = {
    ["name"] = "Dreadfang",
    ["id"] = 81297,
    ["count"] = 0,
    ["health"] = 681760,
    ["scale"] = 1,
    ["displayId"] = 56363,
    ["creatureType"] = "Beast",
    ["level"] = 62,
    ["isBoss"] = true,
    ["encounterID"] = 1235,
    ["instanceID"] = 558,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [164734] = {
      },
      [164835] = {
      },
      [164837] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 403.47802842464,
        ["y"] = -193.85524327546,
        ["sublevel"] = 1,
        ["scale"] = 0.6,
      },
    },
  },
  [14] = {
    ["name"] = "Fleshrender Nok'gar",
    ["id"] = 81305,
    ["count"] = 0,
    ["health"] = 852200,
    ["scale"] = 1,
    ["displayId"] = 56351,
    ["creatureType"] = "Humanoid",
    ["level"] = 62,
    ["isBoss"] = true,
    ["encounterID"] = 1235,
    ["instanceID"] = 558,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [164426] = {
      },
      [164504] = {
      },
      [166923] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 391.41270910655,
        ["y"] = -193.94661256871,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Grom'kar Deckhand",
    ["id"] = 83697,
    ["count"] = 3,
    ["health"] = 213361,
    ["scale"] = 1,
    ["displayId"] = 57894,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Disorient"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [173112] = {
      },
      [173113] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 483.18995416593,
        ["y"] = -165.18004734533,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 473.98122702385,
        ["y"] = -164.3214647472,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 478.35772619158,
        ["y"] = -170.48198796009,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 478.35772619158,
            ["y"] = -170.48198796009,
          },
          [2] = {
            ["x"] = 475.98440471193,
            ["y"] = -176.78376701476,
          },
          [3] = {
            ["x"] = 466.00518613263,
            ["y"] = -185.98336276716,
          },
          [4] = {
            ["x"] = 475.98440471193,
            ["y"] = -176.78376701476,
          },
          [5] = {
            ["x"] = 478.35772619158,
            ["y"] = -170.48198796009,
          },
          [6] = {
            ["x"] = 479.25880095628,
            ["y"] = -150.58835616306,
          },
        },
      },
      [4] = {
        ["x"] = 443.45372860777,
        ["y"] = -97.568328628715,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 451.16444234222,
        ["y"] = -98.43691592684,
        ["g"] = 14,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 451.16444234222,
            ["y"] = -98.43691592684,
          },
          [2] = {
            ["x"] = 457.7939004916,
            ["y"] = -93.104113339212,
          },
          [3] = {
            ["x"] = 458.72945502157,
            ["y"] = -71.586430526812,
          },
          [4] = {
            ["x"] = 457.7939004916,
            ["y"] = -93.104113339212,
          },
          [5] = {
            ["x"] = 451.16444234222,
            ["y"] = -98.43691592684,
          },
          [6] = {
            ["x"] = 438.30326736432,
            ["y"] = -104.17480030733,
          },
          [7] = {
            ["x"] = 436.58809892956,
            ["y"] = -114.93364171353,
          },
          [8] = {
            ["x"] = 438.30326736432,
            ["y"] = -104.17480030733,
          },
        },
      },
      [6] = {
        ["x"] = 446.60783743989,
        ["y"] = -104.88738560547,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 463.57072955317,
        ["y"] = -427.69828286365,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
      [8] = {
        ["x"] = 468.44812609896,
        ["y"] = -420.74126403845,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 460.54480946348,
        ["y"] = -427.3778656609,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 460.54480946348,
            ["y"] = -427.3778656609,
          },
          [2] = {
            ["x"] = 474.12545139311,
            ["y"] = -435.10931768493,
          },
          [3] = {
            ["x"] = 482.31406119234,
            ["y"] = -440.13411883486,
          },
          [4] = {
            ["x"] = 474.12545139311,
            ["y"] = -435.10931768493,
          },
          [5] = {
            ["x"] = 460.54480946348,
            ["y"] = -427.3778656609,
          },
          [6] = {
            ["x"] = 463.8897477134,
            ["y"] = -415.94056673965,
          },
          [7] = {
            ["x"] = 463.14532089604,
            ["y"] = -399.00508559749,
          },
          [8] = {
            ["x"] = 463.8897477134,
            ["y"] = -415.94056673965,
          },
        },
      },
      [10] = {
        ["x"] = 492.30245030585,
        ["y"] = -433.15731887602,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [11] = {
        ["x"] = 499.31548718435,
        ["y"] = -451.59905012853,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 552.09990147137,
        ["y"] = -442.4603659378,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 561.60174169022,
        ["y"] = -142.48093022407,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
    },
  },
  [16] = {
    ["name"] = "Ogron Laborer",
    ["id"] = 83578,
    ["count"] = 9,
    ["health"] = 640083,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 57815,
    ["creatureType"] = "Giant",
    ["level"] = 61,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [162281] = {
      },
      [173135] = {
      },
      [178411] = {
      },
      [178412] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 386.19231788079,
        ["y"] = -265.5178807947,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [2] = {
        ["x"] = 342.71258278146,
        ["y"] = -264.3417218543,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [3] = {
        ["x"] = 587.97774834437,
        ["y"] = -453.74741721854,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [4] = {
        ["x"] = 501.110577431,
        ["y"] = -438.08696106056,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 2,
        ["disguised"] = true,
      },
    },
  },
  [17] = {
    ["name"] = "Ogron Laborer",
    ["id"] = 83761,
    ["count"] = 9,
    ["health"] = 640083,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 57815,
    ["creatureType"] = "Giant",
    ["level"] = 61,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [162281] = {
      },
      [173135] = {
      },
      [178411] = {
      },
      [178412] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 327.59291250833,
        ["y"] = -343.69918562255,
        ["sublevel"] = 1,
        ["scale"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 327.59291250833,
            ["y"] = -343.69918562255,
          },
          [2] = {
            ["x"] = 327.6289999612,
            ["y"] = -380.59432785248,
          },
          [3] = {
            ["x"] = 327.59291250833,
            ["y"] = -343.69918562255,
          },
          [4] = {
            ["x"] = 325.99857570978,
            ["y"] = -314.87525185774,
          },
        },
      },
      [2] = {
        ["x"] = 401.93962600546,
        ["y"] = -378.48154853015,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [3] = {
        ["x"] = 388.83760168276,
        ["y"] = -355.45871988368,
        ["sublevel"] = 1,
        ["scale"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 388.83760168276,
            ["y"] = -355.45871988368,
          },
          [2] = {
            ["x"] = 389.46009289932,
            ["y"] = -381.72308751976,
          },
          [3] = {
            ["x"] = 388.83760168276,
            ["y"] = -355.45871988368,
          },
          [4] = {
            ["x"] = 387.95509914688,
            ["y"] = -319.64114434838,
          },
        },
      },
      [4] = {
        ["x"] = 464.19107607829,
        ["y"] = -374.20270238827,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["scale"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 464.19107607829,
            ["y"] = -374.20270238827,
          },
          [2] = {
            ["x"] = 463.93569959961,
            ["y"] = -397.99331868863,
          },
          [3] = {
            ["x"] = 464.19107607829,
            ["y"] = -374.20270238827,
          },
          [4] = {
            ["x"] = 462.07508847601,
            ["y"] = -348.02029070412,
          },
        },
      },
    },
  },
  [18] = {
    ["name"] = "Grom'kar Deckhand",
    ["id"] = 83762,
    ["count"] = 1,
    ["health"] = 213361,
    ["scale"] = 1,
    ["displayId"] = 57894,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [173112] = {
      },
      [173113] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 366.53326770126,
        ["y"] = -319.86541243885,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 362.27106935222,
        ["y"] = -312.94809896472,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 357.10333743114,
        ["y"] = -320.16220888856,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 357.10333743114,
            ["y"] = -320.16220888856,
          },
          [2] = {
            ["x"] = 373.3812528127,
            ["y"] = -319.82490437144,
          },
          [3] = {
            ["x"] = 387.17724417106,
            ["y"] = -319.69949540188,
          },
          [4] = {
            ["x"] = 373.3812528127,
            ["y"] = -319.82490437144,
          },
          [5] = {
            ["x"] = 357.10333743114,
            ["y"] = -320.16220888856,
          },
          [6] = {
            ["x"] = 347.16887640832,
            ["y"] = -319.82490437144,
          },
          [7] = {
            ["x"] = 336.75917840478,
            ["y"] = -320.2011671625,
          },
          [8] = {
            ["x"] = 347.16887640832,
            ["y"] = -319.82490437144,
          },
        },
      },
      [4] = {
        ["x"] = 352.40079859473,
        ["y"] = -311.86475340009,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 363.58427113498,
        ["y"] = -384.96548515299,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 367.3864748915,
        ["y"] = -377.76292184537,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 358.10773743984,
        ["y"] = -377.47381460899,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 358.10773743984,
            ["y"] = -377.47381460899,
          },
          [2] = {
            ["x"] = 384.19961951645,
            ["y"] = -378.48155671564,
          },
          [3] = {
            ["x"] = 358.10773743984,
            ["y"] = -377.47381460899,
          },
          [4] = {
            ["x"] = 335.43161153656,
            ["y"] = -377.03925067016,
          },
        },
      },
      [8] = {
        ["x"] = 354.46649510965,
        ["y"] = -384.99967874562,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 463.43185290568,
        ["y"] = -361.57443126469,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [10] = {
        ["x"] = 464.9267268261,
        ["y"] = -387.6050441818,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 476.31890556591,
        ["y"] = -366.97438279517,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 451.70118838968,
        ["y"] = -378.01058529719,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Grom'kar Footsoldier",
    ["id"] = 83765,
    ["count"] = 2,
    ["health"] = 256033,
    ["scale"] = 1,
    ["displayId"] = 57845,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [169341] = {
      },
      [169413] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 356.40173450731,
        ["y"] = -353.4809958992,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 364.37871812302,
        ["y"] = -357.5702585948,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 360.58925868528,
        ["y"] = -340.36460359504,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 353.33025647655,
        ["y"] = -345.62321386915,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 362.12509558411,
        ["y"] = -348.42385371103,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [6] = {
        ["x"] = 370.68060879259,
        ["y"] = -351.71011011236,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 414.09368499513,
        ["y"] = -325.25678954647,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Grom'kar Deadeye",
    ["id"] = 83764,
    ["count"] = 2,
    ["health"] = 213361,
    ["scale"] = 1,
    ["displayId"] = 57978,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [167239] = {
      },
      [167240] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 414.91823288264,
        ["y"] = -332.8158316452,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 408.97043736997,
        ["y"] = -335.64453053124,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 412.72113022503,
        ["y"] = -344.92288751019,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 415.77674544984,
        ["y"] = -352.47314771291,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 407.80055824204,
        ["y"] = -317.16526047008,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [6] = {
        ["x"] = 408.30992321668,
        ["y"] = -306.94484953308,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 413.71083366248,
        ["y"] = -312.60888796067,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Grom'kar Chainmaster",
    ["id"] = 86526,
    ["count"] = 9,
    ["health"] = 213361,
    ["scale"] = 1,
    ["displayId"] = 59661,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [173042] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 491.87805966061,
        ["y"] = -446.08210545886,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 551.97666590022,
        ["y"] = -449.21036879219,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
    },
  },
  [22] = {
    ["name"] = "Grom'kar Flameslinger",
    ["id"] = 81279,
    ["count"] = 5,
    ["health"] = 170689,
    ["scale"] = 1,
    ["displayId"] = 56332,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [164632] = {
      },
      [164648] = {
      },
      [167120] = {
      },
      [173148] = {
      },
      [173150] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 548.67032505199,
        ["y"] = -457.28780046627,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 543.36951607807,
        ["y"] = -446.30263650668,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 624.24291984788,
        ["y"] = -434.22736399636,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [4] = {
        ["x"] = 616.01373883062,
        ["y"] = -430.94048097294,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
    },
  },
  [23] = {
    ["name"] = "Makogg Emberblade",
    ["id"] = 80805,
    ["count"] = 0,
    ["health"] = 766980,
    ["scale"] = 1,
    ["displayId"] = 56017,
    ["creatureType"] = "Humanoid",
    ["level"] = 62,
    ["isBoss"] = true,
    ["encounterID"] = 1236,
    ["instanceID"] = 558,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [163665] = {
      },
      [163668] = {
      },
      [163705] = {
      },
      [165152] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 691.40774152129,
        ["y"] = -428.3289358027,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
    },
  },
  [24] = {
    ["name"] = "Ahri'ok Dugru",
    ["id"] = 80816,
    ["count"] = 0,
    ["health"] = 681760,
    ["scale"] = 1,
    ["displayId"] = 56033,
    ["creatureType"] = "Humanoid",
    ["level"] = 62,
    ["isBoss"] = true,
    ["encounterID"] = 1236,
    ["instanceID"] = 558,
    ["spells"] = {
      [163689] = {
      },
      [163705] = {
      },
      [163740] = {
      },
      [165122] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 700.24531372275,
        ["y"] = -415.31860769327,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
    },
  },
  [25] = {
    ["name"] = "Neesa Nox",
    ["id"] = 80808,
    ["count"] = 0,
    ["health"] = 596540,
    ["scale"] = 1,
    ["displayId"] = 56029,
    ["creatureType"] = "Humanoid",
    ["level"] = 62,
    ["isBoss"] = true,
    ["encounterID"] = 1236,
    ["instanceID"] = 558,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [163334] = {
      },
      [163376] = {
      },
      [163390] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 700.92730486279,
        ["y"] = -440.17432487965,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
    },
  },
  [26] = {
    ["name"] = "Rampaging Clefthoof",
    ["id"] = 83392,
    ["count"] = 8,
    ["health"] = 405386,
    ["scale"] = 1,
    ["displayId"] = 52377,
    ["creatureType"] = "Beast",
    ["level"] = 61,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [158337] = {
      },
      [158341] = {
      },
      [158349] = {
      },
      [173349] = {
      },
      [173351] = {
      },
      [173384] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 728.16900557601,
        ["y"] = -354.70695964658,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [2] = {
        ["x"] = 733.46438340187,
        ["y"] = -313.57917580174,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [3] = {
        ["x"] = 690.96282367789,
        ["y"] = -314.64382581595,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [4] = {
        ["x"] = 736.46117056774,
        ["y"] = -207.51769109239,
        ["g"] = 29,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
    },
  },
  [27] = {
    ["name"] = "Thunderlord Wrangler",
    ["id"] = 83390,
    ["count"] = 7,
    ["health"] = 213361,
    ["scale"] = 1,
    ["displayId"] = 59769,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [167095] = {
      },
      [167815] = {
      },
      [173307] = {
      },
      [173311] = {
      },
      [173324] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 722.70812592997,
        ["y"] = -382.29087210617,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 722.70812592997,
            ["y"] = -382.29087210617,
          },
          [2] = {
            ["x"] = 722.10927457469,
            ["y"] = -393.06963153098,
          },
          [3] = {
            ["x"] = 721.5509277963,
            ["y"] = -411.30784503275,
          },
          [4] = {
            ["x"] = 722.10927457469,
            ["y"] = -393.06963153098,
          },
          [5] = {
            ["x"] = 722.70812592997,
            ["y"] = -382.29087210617,
          },
          [6] = {
            ["x"] = 722.29533337298,
            ["y"] = -366.64281824916,
          },
          [7] = {
            ["x"] = 722.29533337298,
            ["y"] = -345.61303059,
          },
          [8] = {
            ["x"] = 722.48145606509,
            ["y"] = -331.84134638901,
          },
          [9] = {
            ["x"] = 722.29533337298,
            ["y"] = -345.61303059,
          },
          [10] = {
            ["x"] = 722.29533337298,
            ["y"] = -366.64281824916,
          },
        },
      },
      [2] = {
        ["x"] = 723.68763740816,
        ["y"] = -320.39304635762,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [3] = {
        ["x"] = 716.85933774834,
        ["y"] = -314.15205298013,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 683.50417168992,
        ["y"] = -324.51306436172,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 684.41642384106,
        ["y"] = -304.34163585558,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 737.44486042336,
        ["y"] = -253.09655455083,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 728.60821192053,
        ["y"] = -214.74345395572,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 717.86608569522,
        ["y"] = -210.12327601592,
        ["g"] = 29,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [9] = {
        ["x"] = 675.37995453941,
        ["y"] = -199.41124256786,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 723.18269630159,
        ["y"] = -307.74318383943,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
      [11] = {
        ["x"] = 685.79369059247,
        ["y"] = -203.2881563299,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
    },
  },
  [28] = {
    ["name"] = "Ironwing Flamespitter",
    ["id"] = 83389,
    ["count"] = 8,
    ["health"] = 277369,
    ["scale"] = 1,
    ["displayId"] = 58013,
    ["creatureType"] = "Beast",
    ["level"] = 61,
    ["spells"] = {
      [173480] = {
      },
      [173489] = {
      },
      [173514] = {
      },
      [173517] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 730.33642384106,
        ["y"] = -248.15483443709,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [2] = {
        ["x"] = 724.33840438331,
        ["y"] = -202.94924228094,
        ["g"] = 29,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [3] = {
        ["x"] = 679.80918256772,
        ["y"] = -214.48573488247,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [4] = {
        ["x"] = 668.97384056409,
        ["y"] = -208.32535901671,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
    },
  },
  [29] = {
    ["name"] = "Siegemaster Rokra",
    ["id"] = 84028,
    ["count"] = 9,
    ["health"] = 341378,
    ["scale"] = 1,
    ["displayId"] = 57477,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [172952] = {
      },
      [172963] = {
      },
      [172982] = {
      },
      [173455] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 732.08140920109,
        ["y"] = -157.76601316601,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
        ["patrol"] = {
          [1] = {
            ["x"] = 732.08140920109,
            ["y"] = -157.76601316601,
          },
          [2] = {
            ["x"] = 740.43145091575,
            ["y"] = -183.97380543474,
          },
          [3] = {
            ["x"] = 732.08140920109,
            ["y"] = -157.76601316601,
          },
          [4] = {
            ["x"] = 719.05139498985,
            ["y"] = -184.65253783124,
          },
        },
      },
    },
  },
  [30] = {
    ["name"] = "Oshir",
    ["id"] = 79852,
    ["count"] = 0,
    ["health"] = 1491350,
    ["scale"] = 1,
    ["displayId"] = 55352,
    ["creatureType"] = "Humanoid",
    ["level"] = 62,
    ["isBoss"] = true,
    ["encounterID"] = 1237,
    ["instanceID"] = 558,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [161256] = {
      },
      [162415] = {
      },
      [162424] = {
      },
      [178124] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 671.24378639739,
        ["y"] = -101.91671773594,
        ["sublevel"] = 1,
      },
    },
  },
  [31] = {
    ["name"] = "Skulloc",
    ["id"] = 83612,
    ["count"] = 0,
    ["health"] = 1363520,
    ["scale"] = 1,
    ["displayId"] = 57836,
    ["creatureType"] = "Giant",
    ["level"] = 62,
    ["isBoss"] = true,
    ["encounterID"] = 1238,
    ["instanceID"] = 558,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [168227] = {
      },
      [168929] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 572.12922478407,
        ["y"] = -267.93737845894,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
    },
  },
  [32] = {
    ["name"] = "Koramar",
    ["id"] = 83613,
    ["count"] = 0,
    ["health"] = 511320,
    ["scale"] = 1,
    ["displayId"] = 57837,
    ["creatureType"] = "Humanoid",
    ["level"] = 62,
    ["isBoss"] = true,
    ["encounterID"] = 1238,
    ["instanceID"] = 558,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [168399] = {
      },
      [168401] = {
      },
      [168402] = {
      },
      [168955] = {
      },
      [168965] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 586.78019331296,
        ["y"] = -262.04780947186,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["scale"] = 0.6,
      },
    },
  },
  [33] = {
    ["name"] = "Zoggosh",
    ["id"] = 83616,
    ["count"] = 0,
    ["health"] = 340880,
    ["scale"] = 1,
    ["displayId"] = 57840,
    ["creatureType"] = "Humanoid",
    ["level"] = 62,
    ["isBoss"] = true,
    ["encounterID"] = 1238,
    ["instanceID"] = 558,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["clones"] = {
      [1] = {
        ["x"] = 558.41684184762,
        ["y"] = -256.13865063963,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["scale"] = 0.6,
      },
    },
  },
  [34] = {
    ["name"] = "Iron Star",
    ["id"] = 81247,
    ["count"] = 0,
    ["health"] = 6400831,
    ["scale"] = 3.3,
    ["displayId"] = 59425,
    ["creatureType"] = "Mechanical",
    ["level"] = 61,
    ["spells"] = {
      [167299] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 254.23177295328,
        ["y"] = -377.48161154942,
        ["sublevel"] = 1,
        ["scale"] = 0.6,
      },
      [2] = {
        ["x"] = 253.74427747106,
        ["y"] = -348.96185559287,
        ["sublevel"] = 1,
        ["scale"] = 0.6,
      },
      [3] = {
        ["x"] = 253.71907248389,
        ["y"] = -320.35893382964,
        ["sublevel"] = 1,
        ["scale"] = 0.6,
      },
    },
  },
};
