local addonName = ...
local MDT = MDT
local L = MDT.L

local dungeonIndex = 113
MDT.dungeonList[dungeonIndex] = L["AraKara"]
MDT.mapInfo[dungeonIndex] = {
  teleportId = 445417,
  shortName = L["araKaraShortName"],
  englishName = "Ara-Kara",
  mapID = 503
}

local zones = { 2216, 2357, 2358 } -- TODO remove 2216 WHEN ARAKARA IS GONE FROM ROTATION
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "",
  [1] = { customTextures = 'Interface\\AddOns\\'..addonName..'\\TheWarWithin\\Textures\\AraKara' }
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["AraKara"]
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 800 }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dungeonEntrance",
      ["x"] = 784.63997675721,
      ["y"] = -484.84956747668,
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "araKaraItem",
      ["x"] = 256.71146880227,
      ["y"] = -214.10744058629,
    },
    [3] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "araKaraItem",
      ["x"] = 613.48123979832,
      ["y"] = -368.39418835502,
    },
    [4] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "araKaraItem",
      ["x"] = 101.97618526925,
      ["y"] = -307.62248048526,
    },
    [5] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "araKaraItem",
      ["x"] = 561.3345470021,
      ["y"] = -263.03563395601,
    },
    [6] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "araKaraItem",
      ["x"] = 651.41457919256,
      ["y"] = -325.35630480857,
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Ravenous Crawler",
    ["id"] = 216336,
    ["count"] = 1,
    ["health"] = 23751511,
    ["scale"] = 0.9,
    ["displayId"] = 120876,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [434083] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 686.89320437722,
        ["y"] = -236.63874903499,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 727.47966748281,
        ["y"] = -390.14581083446,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 673.45637900536,
        ["y"] = -405.21136054786,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 655.8272175064,
        ["y"] = -348.414929101,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 655.5553682407,
        ["y"] = -357.94576966991,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 664.1284168095,
        ["y"] = -353.13789212588,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 657.68674319769,
        ["y"] = -428.8220619393,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 649.99920621638,
        ["y"] = -420.54484879083,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 596.03825083394,
        ["y"] = -373.60290942857,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 603.6877740939,
        ["y"] = -376.04169559748,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 613.1713477902,
        ["y"] = -334.49916540486,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 736.85540247036,
        ["y"] = -271.97762907423,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 729.52864436805,
        ["y"] = -275.73455567739,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 722.94446648014,
        ["y"] = -280.26103755195,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 634.44367858592,
        ["y"] = -240.87388094063,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 660.47689342305,
        ["y"] = -186.62825102397,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 651.3040510821,
        ["y"] = -186.57672335998,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 654.68910542757,
        ["y"] = -179.8612709488,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 559.51884684239,
        ["y"] = -174.9371690851,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 552.28740341089,
        ["y"] = -177.40813133534,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 545.03718575464,
        ["y"] = -182.56401835847,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 485.67520393654,
        ["y"] = -259.67364845043,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 486.54699731836,
        ["y"] = -268.87663086394,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 481.4567122173,
        ["y"] = -276.03149242578,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 501.9487232472,
        ["y"] = -306.51414591687,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 507.45663168089,
        ["y"] = -314.09379735871,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 510.50996039013,
        ["y"] = -305.78765599786,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 505.64854600091,
        ["y"] = -241.72163770153,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 549.90672815051,
        ["y"] = -263.47435892343,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 550.50690133021,
        ["y"] = -272.57685098746,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 556.357398005,
        ["y"] = -277.48019555721,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 679.87564640905,
        ["y"] = -228.44652609023,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 427.28984599742,
        ["y"] = -99.397531234294,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 726.50833709194,
        ["y"] = -399.3383808352,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 733.66910578275,
        ["y"] = -397.03607239747,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 667.33701127584,
        ["y"] = -398.80691063801,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Jabbing Flyer",
    ["id"] = 216341,
    ["count"] = 2,
    ["health"] = 27833802,
    ["scale"] = 0.9,
    ["displayId"] = 120841,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [438599] = {
        ["bleed"] = true,
      },
      [1242153] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 628.54859401254,
        ["y"] = -409.98765029334,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 755.32872051431,
        ["y"] = -352.37363097555,
        ["g"] = 79,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 710.46577991993,
        ["y"] = -316.26172490684,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 704.13149625157,
        ["y"] = -311.73031921747,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 577.08565909316,
        ["y"] = -327.03829172967,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 572.10001742503,
        ["y"] = -319.83283090332,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 601.40238914032,
        ["y"] = -300.01094294245,
        ["g"] = 77,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 679.94672392847,
        ["y"] = -259.59852810616,
        ["g"] = 80,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 699.17972963508,
        ["y"] = -204.45506294355,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 699.86542449746,
        ["y"] = -211.94406896702,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 689.04913974239,
        ["y"] = -209.02822239583,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 681.31096440902,
        ["y"] = -167.33603221536,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 671.10224183794,
        ["y"] = -172.79677960432,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 679.59207911278,
        ["y"] = -174.82175171936,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 654.42793635732,
        ["y"] = -239.58122996368,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 652.93743882602,
        ["y"] = -245.88354721497,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 605.18293470763,
        ["y"] = -126.03158244992,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 613.89618582572,
        ["y"] = -126.45384393762,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 620.63566522248,
        ["y"] = -126.86582991131,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 675.11215658874,
        ["y"] = -121.64334343331,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 682.04301876396,
        ["y"] = -116.26095112925,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 688.73158679877,
        ["y"] = -118.56090130373,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 519.89137020202,
        ["y"] = -178.80903329415,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 522.19039146363,
        ["y"] = -186.12714726114,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 523.71671768166,
        ["y"] = -171.33250459813,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 544.80476218178,
        ["y"] = -303.20778993773,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 540.06549876205,
        ["y"] = -310.11200698616,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 518.74453027813,
        ["y"] = -240.1954499897,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 526.49235004057,
        ["y"] = -235.9387084263,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 615.77496189645,
        ["y"] = -258.08656396672,
        ["g"] = 84,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 614.90765397452,
        ["y"] = -266.70396742067,
        ["g"] = 84,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 618.20915749901,
        ["y"] = -275.61888582927,
        ["g"] = 84,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 581.34466791948,
        ["y"] = -201.47184343197,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 570.83023366456,
        ["y"] = -209.08085098705,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 577.79342222358,
        ["y"] = -207.89210541817,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 681.24089833909,
        ["y"] = -372.96703588928,
        ["g"] = 78,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 748.78589606478,
        ["y"] = -223.8881223208,
        ["g"] = 74,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 750.19296679359,
        ["y"] = -233.01887572496,
        ["g"] = 74,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 631.10136927782,
        ["y"] = -417.83838455747,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 620.4448183673,
        ["y"] = -412.2410305511,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 622.82495738919,
        ["y"] = -419.62047347443,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 570.35315979418,
        ["y"] = -330.00763858104,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [43] = {
        ["x"] = 565.35383951432,
        ["y"] = -322.90327150112,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [44] = {
        ["x"] = 608.50626332336,
        ["y"] = -296.59075870892,
        ["g"] = 77,
        ["sublevel"] = 1,
      },
      [45] = {
        ["x"] = 602.71753381868,
        ["y"] = -292.38077744423,
        ["g"] = 77,
        ["sublevel"] = 1,
      },
      [46] = {
        ["x"] = 685.83852133619,
        ["y"] = -382.92343753674,
        ["g"] = 78,
        ["sublevel"] = 1,
      },
      [47] = {
        ["x"] = 689.90053394379,
        ["y"] = -373.86207225573,
        ["g"] = 78,
        ["sublevel"] = 1,
      },
      [48] = {
        ["x"] = 750.20540218412,
        ["y"] = -345.11566825947,
        ["g"] = 79,
        ["sublevel"] = 1,
      },
      [49] = {
        ["x"] = 757.39207065872,
        ["y"] = -340.42873448334,
        ["g"] = 79,
        ["sublevel"] = 1,
      },
      [50] = {
        ["x"] = 761.45394986799,
        ["y"] = -347.61533625878,
        ["g"] = 79,
        ["sublevel"] = 1,
      },
      [51] = {
        ["x"] = 708.0333607907,
        ["y"] = -323.5054739212,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [52] = {
        ["x"] = 701.68337643183,
        ["y"] = -323.84816030141,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [53] = {
        ["x"] = 697.03675967457,
        ["y"] = -318.13315579124,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [54] = {
        ["x"] = 621.38249703337,
        ["y"] = -260.72000570276,
        ["g"] = 84,
        ["sublevel"] = 1,
      },
      [55] = {
        ["x"] = 622.74592505663,
        ["y"] = -269.58249401506,
        ["g"] = 84,
        ["sublevel"] = 1,
      },
      [56] = {
        ["x"] = 693.66884601122,
        ["y"] = -214.43042466153,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [57] = {
        ["x"] = 692.65543480078,
        ["y"] = -202.53388469179,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [58] = {
        ["x"] = 686.58797791397,
        ["y"] = -263.99675552354,
        ["g"] = 80,
        ["sublevel"] = 1,
      },
      [59] = {
        ["x"] = 680.23740927599,
        ["y"] = -267.78005505991,
        ["g"] = 80,
        ["sublevel"] = 1,
      },
      [60] = {
        ["x"] = 750.52591561803,
        ["y"] = -242.26306408817,
        ["g"] = 74,
        ["sublevel"] = 1,
      },
      [61] = {
        ["x"] = 747.01283785644,
        ["y"] = -215.64477352293,
        ["g"] = 74,
        ["sublevel"] = 1,
      },
      [62] = {
        ["x"] = 752.54961224041,
        ["y"] = -67.216000335512,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [63] = {
        ["x"] = 740.37477380142,
        ["y"] = -74.891504716321,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [64] = {
        ["x"] = 740.25711058008,
        ["y"] = -94.918360332597,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [65] = {
        ["x"] = 766.90073878411,
        ["y"] = -75.273745947,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [66] = {
        ["x"] = 767.66538704013,
        ["y"] = -92.977482409279,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [67] = {
        ["x"] = 753.60834890875,
        ["y"] = -101.77047589834,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Trilling Attendant",
    ["id"] = 216293,
    ["count"] = 7,
    ["health"] = 83501406,
    ["scale"] = 1.4,
    ["displayId"] = 116588,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [434786] = {
        ["interruptible"] = true,
      },
      [434793] = {
        ["interruptible"] = true,
      },
      [434796] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 729.61267305152,
        ["y"] = -356.01303365937,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 738.56246756944,
        ["y"] = -237.22597437735,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 738.01446707846,
        ["y"] = -224.48384622368,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 683.98428863059,
        ["y"] = -126.18441326797,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 502.27252860774,
        ["y"] = -251.23168726073,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 527.17901011386,
        ["y"] = -246.60852713292,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 527.17901011386,
            ["y"] = -246.60852713292,
          },
          [2] = {
            ["x"] = 532.06190117613,
            ["y"] = -255.93362372794,
          },
          [3] = {
            ["x"] = 536.81999727185,
            ["y"] = -266.45162896408,
          },
          [4] = {
            ["x"] = 538.32257354262,
            ["y"] = -276.96961987059,
          },
          [5] = {
            ["x"] = 538.0721489407,
            ["y"] = -288.48930918478,
          },
          [6] = {
            ["x"] = 535.81829886417,
            ["y"] = -302.26287723476,
          },
          [7] = {
            ["x"] = 538.0721489407,
            ["y"] = -288.48930918478,
          },
          [8] = {
            ["x"] = 538.32257354262,
            ["y"] = -276.96961987059,
          },
          [9] = {
            ["x"] = 536.81999727185,
            ["y"] = -266.45162896408,
          },
          [10] = {
            ["x"] = 532.06190117613,
            ["y"] = -255.93362372794,
          },
        },
      },
      [7] = {
        ["x"] = 585.00340164586,
        ["y"] = -278.82163047505,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 571.41854991975,
        ["y"] = -198.63760640317,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Engorged Crawler",
    ["id"] = 214840,
    ["count"] = 5,
    ["health"] = 102057275,
    ["scale"] = 1.2,
    ["displayId"] = 117840,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [438618] = {
        ["poison"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 677.25594583195,
        ["y"] = -237.34484183822,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 599.97936848837,
        ["y"] = -365.75975347885,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 661.28071014775,
        ["y"] = -317.91911172878,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 663.68732295227,
        ["y"] = -327.89491913107,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 621.74461439383,
        ["y"] = -328.7141162475,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 612.15328966504,
        ["y"] = -324.68984414351,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 730.05025068974,
        ["y"] = -266.29655078396,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 721.18327535691,
        ["y"] = -272.24124361919,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 634.27674718022,
        ["y"] = -250.77916880503,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 614.2313919899,
        ["y"] = -193.66203762997,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 608.31237939107,
        ["y"] = -185.41184902567,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 618.89507666675,
        ["y"] = -183.80872165002,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 618.89507666675,
            ["y"] = -183.80872165002,
          },
          [2] = {
            ["x"] = 628.1749221842,
            ["y"] = -176.4385370461,
          },
          [3] = {
            ["x"] = 635.43732161762,
            ["y"] = -170.92910982611,
          },
          [4] = {
            ["x"] = 642.95020297147,
            ["y"] = -160.16067998805,
          },
          [5] = {
            ["x"] = 635.43732161762,
            ["y"] = -170.92910982611,
          },
          [6] = {
            ["x"] = 628.1749221842,
            ["y"] = -176.4385370461,
          },
          [7] = {
            ["x"] = 618.89507666675,
            ["y"] = -183.80872165002,
          },
          [8] = {
            ["x"] = 609.39276178844,
            ["y"] = -190.21210509607,
          },
          [9] = {
            ["x"] = 597.12181299813,
            ["y"] = -198.72667052798,
          },
          [10] = {
            ["x"] = 589.35850704235,
            ["y"] = -201.98223334181,
          },
          [11] = {
            ["x"] = 597.12181299813,
            ["y"] = -198.72667052798,
          },
          [12] = {
            ["x"] = 609.39276178844,
            ["y"] = -190.21210509607,
          },
        },
      },
      [13] = {
        ["x"] = 724.68648997841,
        ["y"] = -152.83784339566,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 715.56332749311,
        ["y"] = -151.04749065757,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 551.55777287426,
        ["y"] = -167.6264665136,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 542.31883206351,
        ["y"] = -173.90141300957,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 590.62383450369,
        ["y"] = -258.14470386996,
        ["g"] = 13,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 606.74896040408,
            ["y"] = -262.87101632113,
          },
          [2] = {
            ["x"] = 599.42729803716,
            ["y"] = -257.4862626845,
          },
          [3] = {
            ["x"] = 589.15974606219,
            ["y"] = -256.48453561757,
          },
          [4] = {
            ["x"] = 581.64686470834,
            ["y"] = -265.24955431065,
          },
          [5] = {
            ["x"] = 582.64859177527,
            ["y"] = -270.75898153064,
          },
          [6] = {
            ["x"] = 588.65889685835,
            ["y"] = -285.78468691984,
          },
          [7] = {
            ["x"] = 593.91787081717,
            ["y"] = -286.78639965714,
          },
          [8] = {
            ["x"] = 603.68457358829,
            ["y"] = -282.52910977637,
          },
          [9] = {
            ["x"] = 606.188876926,
            ["y"] = -278.02139529369,
          },
        },
      },
      [18] = {
        ["x"] = 599.80449843937,
        ["y"] = -259.71811828409,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 538.77092156601,
        ["y"] = -217.42418596397,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 547.54517164511,
        ["y"] = -223.73661364096,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 712.95756073023,
        ["y"] = -250.71916216825,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Atik",
    ["id"] = 217533,
    ["count"] = 40,
    ["health"] = 222670417,
    ["scale"] = 2.5,
    ["stealthDetect"] = true,
    ["displayId"] = 117119,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [434824] = {
      },
      [436322] = {
        ["interruptible"] = true,
        ["poison"] = true,
      },
      [438825] = {
      },
      [438826] = {
      },
      [438827] = {
      },
      [438832] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 753.26445214587,
        ["y"] = -84.599414102321,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Nakt",
    ["id"] = 218324,
    ["count"] = 40,
    ["health"] = 185558681,
    ["scale"] = 2.5,
    ["stealthDetect"] = true,
    ["displayId"] = 117119,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [434786] = {
        ["interruptible"] = true,
      },
      [434824] = {
      },
      [438877] = {
      },
      [438879] = {
      },
      [438883] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 615.32012611191,
        ["y"] = -108.9889605934,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Ixin",
    ["id"] = 217531,
    ["count"] = 40,
    ["health"] = 222670417,
    ["scale"] = 2.5,
    ["stealthDetect"] = true,
    ["displayId"] = 117119,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [434786] = {
        ["interruptible"] = true,
      },
      [434802] = {
        ["interruptible"] = true,
      },
      [434824] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 468.64222796138,
        ["y"] = -263.67613526516,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Bloodworker",
    ["id"] = 216337,
    ["count"] = 3,
    ["health"] = 55667604,
    ["scale"] = 0.8,
    ["displayId"] = 120862,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [453583] = {
      },
      [453584] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 432.07242414567,
        ["y"] = -90.934232834209,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 434.28030076733,
        ["y"] = -105.56796603942,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 436.82029418306,
        ["y"] = -97.4954629547,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 399.1907846427,
        ["y"] = -128.00543529978,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 382.32219596108,
        ["y"] = -138.92058415002,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 332.26642602231,
        ["y"] = -129.47650255459,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 340.83953396051,
        ["y"] = -149.78978576515,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 302.19436712647,
        ["y"] = -170.9774147557,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 310.42049884608,
        ["y"] = -174.36664001346,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 328.45068180875,
        ["y"] = -174.42925575782,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 318.9586772549,
        ["y"] = -175.59789560313,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 320.77845275084,
        ["y"] = -195.52508153931,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 317.77999155821,
        ["y"] = -202.51550702211,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 304.27858891548,
        ["y"] = -201.29618196054,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 310.82984086131,
        ["y"] = -204.54189618936,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 268.70276008335,
        ["y"] = -187.51937908135,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 274.42471359708,
        ["y"] = -182.79677386794,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 266.43672280678,
        ["y"] = -194.29445778861,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 263.35734457586,
        ["y"] = -202.67468881884,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 297.20038641791,
        ["y"] = -243.4894126269,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 279.76962301568,
        ["y"] = -241.52563567111,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 295.6183957057,
        ["y"] = -250.29338943271,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 126.97886484499,
        ["y"] = -144.78251505975,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 137.83475513123,
        ["y"] = -139.6140822439,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 118.55187318,
        ["y"] = -136.68002019936,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 138.36775509978,
        ["y"] = -129.86609406616,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 121.12911401168,
        ["y"] = -125.768520496,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 130.90031474337,
        ["y"] = -122.65360486761,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 212.14635074147,
        ["y"] = -124.2595129151,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 213.65084543032,
        ["y"] = -132.72155648632,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 226.49732787119,
        ["y"] = -118.20382351324,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 217.87379248839,
        ["y"] = -118.03115264964,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 255.29244599101,
        ["y"] = -141.59330872159,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 254.2834949382,
        ["y"] = -150.04139102857,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 246.04552063769,
        ["y"] = -154.15311653921,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 227.04652450034,
        ["y"] = -188.36527198728,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 231.48751413174,
        ["y"] = -183.03467689217,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 237.22527851904,
        ["y"] = -188.99842873509,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 231.57775036121,
        ["y"] = -193.33200874607,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Bloodstained Assistant",
    ["id"] = 216333,
    ["count"] = 6,
    ["health"] = 102057275,
    ["scale"] = 1.2,
    ["displayId"] = 119391,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [433002] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 398.70269535708,
        ["y"] = -97.629519423239,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 387.89047274484,
        ["y"] = -102.23593190668,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 309.62042794416,
        ["y"] = -127.59716608861,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 279.3798799731,
        ["y"] = -251.74363748144,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 311.31465949011,
        ["y"] = -194.98124826726,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 271.6173635559,
        ["y"] = -269.82137040167,
        ["g"] = 45,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 274.13895663809,
            ["y"] = -270.13656740614,
          },
          [2] = {
            ["x"] = 287.65222826805,
            ["y"] = -270.01546609595,
          },
          [3] = {
            ["x"] = 300.73302754021,
            ["y"] = -260.55946220646,
          },
          [4] = {
            ["x"] = 284.50024117691,
            ["y"] = -270.64587715132,
          },
          [5] = {
            ["x"] = 274.13895663809,
            ["y"] = -270.13656740614,
          },
          [6] = {
            ["x"] = 263.33449756429,
            ["y"] = -283.40353035415,
          },
          [7] = {
            ["x"] = 250.93142353377,
            ["y"] = -292.23708077634,
          },
          [8] = {
            ["x"] = 234.69862012404,
            ["y"] = -302.79627844309,
          },
          [9] = {
            ["x"] = 209.79779255118,
            ["y"] = -295.54667063133,
          },
          [10] = {
            ["x"] = 193.40740342404,
            ["y"] = -288.45467410662,
          },
          [11] = {
            ["x"] = 209.79779255118,
            ["y"] = -295.54667063133,
          },
          [12] = {
            ["x"] = 234.69862012404,
            ["y"] = -302.79627844309,
          },
          [13] = {
            ["x"] = 250.93142353377,
            ["y"] = -292.23708077634,
          },
          [14] = {
            ["x"] = 263.33449756429,
            ["y"] = -283.40353035415,
          },
        },
      },
      [7] = {
        ["x"] = 216.61260634215,
        ["y"] = -286.22174111828,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 220.06061412349,
        ["y"] = -275.07008706549,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 212.91595065677,
        ["y"] = -297.1904793199,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 277.23942450991,
        ["y"] = -104.44426012351,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 245.99134596347,
        ["y"] = -143.6927869125,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 209.19124741939,
        ["y"] = -157.36224830453,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Bloodstained Webmage",
    ["id"] = 223253,
    ["count"] = 7,
    ["health"] = 83501406,
    ["scale"] = 1.2,
    ["displayId"] = 117870,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [434786] = {
        ["interruptible"] = true,
      },
      [448248] = {
        ["interruptible"] = true,
        ["poison"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 389.94740932032,
        ["y"] = -131.71278700997,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 272.72345663258,
        ["y"] = -202.58470746722,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 278.33363444496,
        ["y"] = -278.79498521088,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 299.53129221827,
        ["y"] = -133.36344016352,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 227.81113271608,
        ["y"] = -283.3337752424,
        ["g"] = 47,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 226.3927163647,
            ["y"] = -289.79538628138,
          },
          [2] = {
            ["x"] = 203.17868521339,
            ["y"] = -285.93308939734,
          },
          [3] = {
            ["x"] = 200.65709213119,
            ["y"] = -261.3474929218,
          },
          [4] = {
            ["x"] = 203.17868521339,
            ["y"] = -285.93308939734,
          },
          [5] = {
            ["x"] = 226.3927163647,
            ["y"] = -289.79538628138,
          },
          [6] = {
            ["x"] = 242.57871136335,
            ["y"] = -287.19389446165,
          },
          [7] = {
            ["x"] = 263.53951245622,
            ["y"] = -281.36269447804,
          },
          [8] = {
            ["x"] = 268.74034400053,
            ["y"] = -277.26508228063,
          },
          [9] = {
            ["x"] = 263.53951245622,
            ["y"] = -281.36269447804,
          },
          [10] = {
            ["x"] = 242.57871136335,
            ["y"] = -287.19389446165,
          },
        },
      },
      [6] = {
        ["x"] = 223.56091598276,
        ["y"] = -294.97646861545,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 183.51632368168,
        ["y"] = -219.24672627132,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 275.59378663172,
        ["y"] = -130.57396803016,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 222.14457924694,
        ["y"] = -127.94899105034,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 219.25248268507,
        ["y"] = -167.28830347632,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 288.49080773475,
        ["y"] = -256.48888746738,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Hulking Bloodguard",
    ["id"] = 216338,
    ["count"] = 30,
    ["health"] = 148446945,
    ["scale"] = 1.8,
    ["stealthDetect"] = true,
    ["displayId"] = 120856,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [453160] = {
      },
      [453161] = {
      },
      [1241693] = {
      },
      [1241694] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 336.64903693601,
        ["y"] = -139.29725904522,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 294.71914146177,
        ["y"] = -215.26670666046,
        ["g"] = 42,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 294.71914146177,
            ["y"] = -215.26670666046,
          },
          [2] = {
            ["x"] = 313.45238263786,
            ["y"] = -177.85570994609,
          },
          [3] = {
            ["x"] = 294.71914146177,
            ["y"] = -215.26670666046,
          },
          [4] = {
            ["x"] = 281.02620720972,
            ["y"] = -262.88534903723,
          },
        },
      },
      [3] = {
        ["x"] = 277.1412060035,
        ["y"] = -117.10597560631,
        ["g"] = 40,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 277.1412060035,
            ["y"] = -117.10597560631,
          },
          [2] = {
            ["x"] = 231.15510824116,
            ["y"] = -125.9809591829,
          },
          [3] = {
            ["x"] = 277.1412060035,
            ["y"] = -117.10597560631,
          },
          [4] = {
            ["x"] = 301.33011825281,
            ["y"] = -126.42511241714,
          },
          [5] = {
            ["x"] = 277.1412060035,
            ["y"] = -117.10597560631,
          },
        },
      },
      [4] = {
        ["x"] = 221.5969354068,
        ["y"] = -154.15916630405,
        ["g"] = 51,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 221.5969354068,
            ["y"] = -154.15916630405,
          },
          [2] = {
            ["x"] = 223.60464737887,
            ["y"] = -136.4183800378,
          },
          [3] = {
            ["x"] = 221.5969354068,
            ["y"] = -154.15916630405,
          },
          [4] = {
            ["x"] = 211.16857299984,
            ["y"] = -185.94063696676,
          },
        },
      },
      [5] = {
        ["x"] = 128.7124378409,
        ["y"] = -133.45847116711,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 299.22754218693,
        ["y"] = -426.83649595769,
        ["g"] = 63,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 296.74523186827,
            ["y"] = -429.56706287532,
          },
          [2] = {
            ["x"] = 310.47062948523,
            ["y"] = -418.7500791234,
          },
          [3] = {
            ["x"] = 331.14989419419,
            ["y"] = -401.70674374771,
          },
          [4] = {
            ["x"] = 310.47062948523,
            ["y"] = -418.7500791234,
          },
          [5] = {
            ["x"] = 296.74523186827,
            ["y"] = -429.56706287532,
          },
          [6] = {
            ["x"] = 277.52022151597,
            ["y"] = -446.2466052199,
          },
          [7] = {
            ["x"] = 296.74523186827,
            ["y"] = -429.56706287532,
          },
        },
      },
    },
  },
  [12] = {
    ["name"] = "Sentry Stagshell",
    ["id"] = 216340,
    ["count"] = 5,
    ["health"] = 37111736,
    ["scale"] = 1.2,
    ["stealthDetect"] = true,
    ["displayId"] = 116485,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [432967] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 315.78853305387,
        ["y"] = -165.69351467972,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 278.28348277469,
        ["y"] = -191.64828595262,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 288.41814260194,
        ["y"] = -243.58666921172,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 257.78670689633,
        ["y"] = -300.33023063913,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 242.58035850023,
        ["y"] = -126.74248227379,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 184.92086870355,
        ["y"] = -207.14098973236,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 182.06833474406,
        ["y"] = -231.19867356367,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Blood Overseer",
    ["id"] = 216364,
    ["count"] = 20,
    ["health"] = 167002813,
    ["scale"] = 1.3,
    ["stealthDetect"] = true,
    ["displayId"] = 115772,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [433841] = {
        ["interruptible"] = true,
        ["poison"] = true,
      },
      [433843] = {
      },
      [433845] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 404.86920867637,
        ["y"] = -340.6621907241,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 285.74490240035,
        ["y"] = -431.34721815572,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 294.30374968561,
        ["y"] = -441.07862720252,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 353.05574202906,
        ["y"] = -353.55097718166,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 327.02084338386,
        ["y"] = -350.73852624087,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 295.24607202796,
        ["y"] = -386.06743993276,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 348.85900822092,
        ["y"] = -436.62193114745,
        ["g"] = 62,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 348.85900822092,
            ["y"] = -436.62193114745,
          },
          [2] = {
            ["x"] = 373.8023684924,
            ["y"] = -415.57877584743,
          },
          [3] = {
            ["x"] = 329.83193583791,
            ["y"] = -452.09223470562,
          },
        },
      },
      [8] = {
        ["x"] = 337.8921395861,
        ["y"] = -443.24705687956,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Winged Carrier",
    ["id"] = 216365,
    ["count"] = 4,
    ["health"] = 64945538,
    ["scale"] = 1,
    ["displayId"] = 116349,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [433656] = {
      },
      [433821] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 340.0589965927,
        ["y"] = -382.71580880132,
        ["g"] = 59,
        ["sublevel"] = 1,
        ["patrol"] = {
        },
      },
      [2] = {
        ["x"] = 333.07822977851,
        ["y"] = -389.18577368889,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 323.97527261905,
        ["y"] = -385.60106927759,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 331.64420648494,
        ["y"] = -378.04877169763,
        ["g"] = 59,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 331.64420648494,
            ["y"] = -378.04877169763,
          },
          [2] = {
            ["x"] = 317.3684231784,
            ["y"] = -364.73486160313,
          },
          [3] = {
            ["x"] = 333.90434502337,
            ["y"] = -346.69569261278,
          },
          [4] = {
            ["x"] = 351.56771238966,
            ["y"] = -343.68917799745,
          },
          [5] = {
            ["x"] = 373.36510086637,
            ["y"] = -329.78400979294,
          },
          [6] = {
            ["x"] = 395.5380064229,
            ["y"] = -345.56828774064,
          },
          [7] = {
            ["x"] = 383.1361869867,
            ["y"] = -359.47341529597,
          },
          [8] = {
            ["x"] = 368.10355293628,
            ["y"] = -372.62700057697,
          },
          [9] = {
            ["x"] = 351.94347336453,
            ["y"] = -385.02890131152,
          },
        },
      },
      [5] = {
        ["x"] = 339.28116181188,
        ["y"] = -372.55670521138,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 330.28691790669,
        ["y"] = -420.85552419205,
        ["g"] = 60,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 330.28691790669,
            ["y"] = -420.85552419205,
          },
          [2] = {
            ["x"] = 318.87179961911,
            ["y"] = -434.71635542835,
          },
          [3] = {
            ["x"] = 297.07449244075,
            ["y"] = -439.6019188131,
          },
          [4] = {
            ["x"] = 283.92090715975,
            ["y"] = -424.56930508727,
          },
          [5] = {
            ["x"] = 285.79999657834,
            ["y"] = -408.03344421606,
          },
          [6] = {
            ["x"] = 302.71167939819,
            ["y"] = -398.26221582362,
          },
          [7] = {
            ["x"] = 325.26067112299,
            ["y"] = -396.75894835366,
          },
          [8] = {
            ["x"] = 336.91092796027,
            ["y"] = -400.51710686626,
          },
        },
      },
      [7] = {
        ["x"] = 338.70357298345,
        ["y"] = -424.64536506242,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 337.64030540964,
        ["y"] = -415.33483144791,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 346.08135667976,
        ["y"] = -419.22402004868,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 331.3258632228,
        ["y"] = -429.61887862759,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Reinforced Drone",
    ["id"] = 216363,
    ["count"] = 5,
    ["health"] = 92779340,
    ["scale"] = 0.8,
    ["displayId"] = 120860,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [433656] = {
      },
      [1241785] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 375.47624382084,
        ["y"] = -337.67218521639,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 369.0463599369,
        ["y"] = -342.45461026533,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 394.75234891772,
        ["y"] = -375.45096559068,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 400.72473311803,
        ["y"] = -371.1673725015,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 349.85580528883,
        ["y"] = -362.75427004681,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 343.88685490571,
        ["y"] = -357.5615837941,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 333.22172615607,
        ["y"] = -338.96700168234,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 340.74584353571,
        ["y"] = -335.03797108972,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 346.05298253278,
        ["y"] = -341.47173650702,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 309.73489206768,
        ["y"] = -361.59102150123,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 303.72729921183,
        ["y"] = -365.13371988856,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 285.54831448976,
        ["y"] = -388.5046897681,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 300.90314310435,
        ["y"] = -378.42044653159,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 293.56698452226,
        ["y"] = -376.23397313098,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 287.1441607779,
        ["y"] = -380.57941973225,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 373.21137169566,
        ["y"] = -390.78644113992,
        ["g"] = 81,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 378.82005930434,
        ["y"] = -396.51398080952,
        ["g"] = 81,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 370.19677497631,
        ["y"] = -420.58936150645,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 364.21002911875,
        ["y"] = -425.81982503334,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 370.93825649276,
        ["y"] = -428.39307843804,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 351.8439843041,
        ["y"] = -446.06388134438,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 345.61188422544,
        ["y"] = -450.69472469617,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Avanoxx",
    ["id"] = 213179,
    ["count"] = 0,
    ["health"] = 556926360,
    ["scale"] = 2,
    ["displayId"] = 119793,
    ["creatureType"] = "Beast",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2583,
    ["instanceID"] = 0,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [438471] = {
      },
      [438473] = {
      },
      [438476] = {
      },
      [438494] = {
      },
      [438495] = {
      },
      [438949] = {
      },
      [438960] = {
      },
      [438966] = {
      },
      [439200] = {
      },
      [446794] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 568.62198064247,
        ["y"] = -111.33400604091,
        ["g"] = 82,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Anubzekt",
    ["id"] = 215405,
    ["count"] = 0,
    ["health"] = 649747421,
    ["scale"] = 1.8,
    ["displayId"] = 115723,
    ["creatureType"] = "Humanoid",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2584,
    ["instanceID"] = 0,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [433443] = {
      },
      [433731] = {
      },
      [433740] = {
      },
      [433766] = {
      },
      [433781] = {
      },
      [434284] = {
      },
      [434408] = {
      },
      [435012] = {
      },
      [439506] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 106.91672695339,
        ["y"] = -192.1542396717,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Bloodstained Webmage",
    ["id"] = 220599,
    ["count"] = 0,
    ["health"] = 26732467,
    ["scale"] = 1.1,
    ["displayId"] = 117870,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["isBoss"] = true,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [181089] = {
      },
      [442210] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 121.23596704536,
        ["y"] = -225.35790809862,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Kikatal The Harvester",
    ["id"] = 215407,
    ["count"] = 0,
    ["health"] = 742568481,
    ["scale"] = 1.8,
    ["displayId"] = 117473,
    ["creatureType"] = "Humanoid",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2585,
    ["instanceID"] = 0,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [432117] = {
      },
      [432119] = {
      },
      [432130] = {
      },
      [432132] = {
      },
      [432227] = {
      },
      [439680] = {
      },
      [461487] = {
        ["poison"] = true,
      },
      [461507] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 253.59313965837,
        ["y"] = -470.58427905571,
        ["g"] = 83,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Bloodworker",
    ["id"] = 215826,
    ["count"] = 0,
    ["health"] = 15463225,
    ["scale"] = 1.4,
    ["displayId"] = 116347,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [431985] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 233.0863465074,
        ["y"] = -478.60514873998,
        ["g"] = 83,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 243.93917502856,
        ["y"] = -490.85334605725,
        ["g"] = 83,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Black Blood",
    ["id"] = 215968,
    ["count"] = 0,
    ["health"] = 9277936,
    ["scale"] = 1.4,
    ["displayId"] = 113940,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [432031] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 262.79681892118,
        ["y"] = -490.26584759115,
        ["g"] = 83,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 273.66061795549,
        ["y"] = -474.83891744382,
        ["g"] = 83,
        ["sublevel"] = 1,
      },
    },
  },
  [22] = {
    ["name"] = "Starved Crawler",
    ["id"] = 218961,
    ["count"] = 0,
    ["health"] = 19329031,
    ["scale"] = 1.2,
    ["displayId"] = 114552,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [439333] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 550.73287764155,
        ["y"] = -123.85571985815,
        ["g"] = 82,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 563.79192550891,
        ["y"] = -132.55811645537,
        ["g"] = 82,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 587.25041186767,
        ["y"] = -116.02177208234,
        ["g"] = 82,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 581.48206282699,
        ["y"] = -130.63529239616,
        ["g"] = 82,
        ["sublevel"] = 1,
      },
    },
  },
};
