local addonName = ...
local MDT = MDT
local L = MDT.L

local dungeonIndex = 116
MDT.dungeonList[dungeonIndex] = L["Cinderbrew Meadery"]
MDT.mapInfo[dungeonIndex] = {
  teleportId = 445440,
  shortName = L["cinderbrewShortName"],
  englishName = "Cinderbrew Meadery",
  mapID = 506
}

local zones = { 2248, 2335 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "CinderbrewMeadery",
  [1] = "Cinderbrew_Meadery",
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["Cinderbrew Meadery"]
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 587 }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dungeonEntrance",
      ["x"] = 209.16919345199,
      ["y"] = -293.26243725591,
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brewItemA",
      ["x"] = 344.84781597341,
      ["y"] = -189.58331313712,
    },
    [3] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brewItemA",
      ["x"] = 343.03240755168,
      ["y"] = -522.25720917251,
    },
    [4] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "brewItemB",
      ["x"] = 281.76231276762,
      ["y"] = -219.99146475182,
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Tasting Room Attendant",
    ["id"] = 214920,
    ["count"] = 3,
    ["health"] = 43749686,
    ["scale"] = 1.5,
    ["displayId"] = 121037,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [434695] = {
      },
      [434706] = {
      },
      [434707] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 309.61090632148,
        ["y"] = -336.6682846897,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 316.75290404434,
            ["y"] = -335.46614201406,
          },
          [2] = {
            ["x"] = 300.14260184161,
            ["y"] = -339.96808964981,
          },
          [3] = {
            ["x"] = 283.26209494212,
            ["y"] = -341.346103711,
          },
          [4] = {
            ["x"] = 300.14260184161,
            ["y"] = -339.96808964981,
          },
          [5] = {
            ["x"] = 316.75290404434,
            ["y"] = -335.46614201406,
          },
          [6] = {
            ["x"] = 330.54913125891,
            ["y"] = -338.12507140032,
          },
          [7] = {
            ["x"] = 316.75290404434,
            ["y"] = -335.46614201406,
          },
        },
      },
      [2] = {
        ["x"] = 316.99203892242,
        ["y"] = -365.47883147566,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 274.20736073636,
        ["y"] = -236.18365085075,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 274.20736073636,
            ["y"] = -236.18365085075,
          },
          [2] = {
            ["x"] = 296.27134096806,
            ["y"] = -235.54433872579,
          },
          [3] = {
            ["x"] = 274.20736073636,
            ["y"] = -236.18365085075,
          },
          [4] = {
            ["x"] = 256.10929954809,
            ["y"] = -233.81072767543,
          },
        },
      },
      [4] = {
        ["x"] = 293.60562851298,
        ["y"] = -294.24290464356,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 293.60562851298,
            ["y"] = -294.24290464356,
          },
          [2] = {
            ["x"] = 291.35475298302,
            ["y"] = -280.61831383508,
          },
          [3] = {
            ["x"] = 291.35475298302,
            ["y"] = -267.90515571512,
          },
          [4] = {
            ["x"] = 305.36813501675,
            ["y"] = -273.25046296456,
          },
          [5] = {
            ["x"] = 312.30257921819,
            ["y"] = -282.35193269844,
          },
          [6] = {
            ["x"] = 305.51259739562,
            ["y"] = -291.16445814209,
          },
          [7] = {
            ["x"] = 304.64580749644,
            ["y"] = -300.41039416133,
          },
        },
      },
    },
  },
  [2] = {
    ["name"] = "Venture Co. Pyromaniac",
    ["id"] = 218671,
    ["count"] = 5,
    ["health"] = 43749686,
    ["scale"] = 1.5,
    ["displayId"] = 119013,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [434505] = {
      },
      [437721] = {
        ["interruptible"] = true,
      },
      [437733] = {
      },
      [437956] = {
        ["magic"] = true,
      },
      [441408] = {
        ["enrage"] = true,
      },
      [453909] = {
        ["interruptible"] = true,
      },
      [453989] = {
        ["interruptible"] = true,
      },
      [454318] = {
        ["interruptible"] = true,
      },
      [454319] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 269.11692387786,
        ["y"] = -350.53600779231,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 289.40561752875,
        ["y"] = -316.71873210011,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 316.90932627489,
        ["y"] = -353.5555409957,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 250.63871461453,
        ["y"] = -227.64067175605,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 328.95421692071,
        ["y"] = -279.80372594348,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 306.05349209088,
        ["y"] = -237.30653439101,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 277.35775650277,
        ["y"] = -275.7121336445,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 270.70453837011,
        ["y"] = -196.73927420317,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 284.46610612304,
        ["y"] = -196.47458893455,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 282.38674581794,
        ["y"] = -64.71919792963,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 399.28426712252,
        ["y"] = -66.042360035098,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 412.66763309114,
        ["y"] = -66.080185583626,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 444.18471494871,
        ["y"] = -154.18149954248,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 444.01723385018,
        ["y"] = -168.57745386859,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 420.49655721181,
        ["y"] = -229.02477834046,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 370.10022908883,
        ["y"] = -216.29437437695,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 383.25127075167,
        ["y"] = -215.71961102722,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Venture Co. Patron",
    ["id"] = 214668,
    ["count"] = 3,
    ["health"] = 43749686,
    ["scale"] = 1.5,
    ["displayId"] = 119026,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [434505] = {
      },
      [434773] = {
        ["bleed"] = true,
      },
      [441408] = {
        ["enrage"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 269.19252972284,
        ["y"] = -364.5243731748,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 282.95411001392,
        ["y"] = -364.14629202313,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 276.77422358423,
        ["y"] = -329.03546824989,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 289.06233788411,
        ["y"] = -328.46326709489,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 277.01740194457,
        ["y"] = -316.57567823327,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 327.55741170508,
        ["y"] = -359.03642574041,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 317.05549281443,
        ["y"] = -296.62409472814,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 317.04224592682,
        ["y"] = -309.88400309408,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 250.82472106391,
        ["y"] = -239.9573440805,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 250.66734420083,
        ["y"] = -252.61740281196,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 327.8956184289,
        ["y"] = -266.57145948107,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 318.36834650139,
        ["y"] = -273.98149148791,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 299.33010907213,
        ["y"] = -226.33752173476,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 311.38725814564,
        ["y"] = -226.33238972736,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 293.95055638222,
        ["y"] = -255.94655766524,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 306.02818209358,
        ["y"] = -256.24286807511,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 300.62286143885,
        ["y"] = -266.24113186198,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 270.82853176473,
        ["y"] = -264.87090628031,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Hired Muscle",
    ["id"] = 210269,
    ["count"] = 10,
    ["health"] = 77777220,
    ["scale"] = 1.5,
    ["displayId"] = 118999,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [434505] = {
      },
      [434756] = {
      },
      [434758] = {
      },
      [441408] = {
        ["enrage"] = true,
      },
      [463218] = {
      },
      [463220] = {
      },
      [463223] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 283.10156419428,
        ["y"] = -350.08335468395,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 328.35956940322,
        ["y"] = -303.42926689618,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 264.49853617938,
        ["y"] = -276.53468338521,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Chef Chewie",
    ["id"] = 214697,
    ["count"] = 15,
    ["health"] = 145832288,
    ["scale"] = 2,
    ["displayId"] = 121036,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [434743] = {
      },
      [434745] = {
      },
      [434998] = {
      },
      [435000] = {
      },
      [435004] = {
      },
      [463206] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 347.10452884752,
        ["y"] = -293.00193763741,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Worker Bee",
    ["id"] = 210265,
    ["count"] = 5,
    ["health"] = 43749686,
    ["scale"] = 1.5,
    ["displayId"] = 121054,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [441410] = {
      },
      [441413] = {
      },
      [443487] = {
      },
      [443491] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 324.76749405787,
        ["y"] = -403.35908582036,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 339.58776787521,
        ["y"] = -402.72394950389,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 352.29069909106,
        ["y"] = -424.10729538057,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 352.29064184167,
        ["y"] = -438.39814602244,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 341.44875183259,
        ["y"] = -430.08316973136,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 347.00361608485,
        ["y"] = -473.37777587705,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 319.08200000162,
        ["y"] = -472.90443872533,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 375.67745141245,
        ["y"] = -483.92044938375,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 375.75226829792,
        ["y"] = -498.32675755326,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 375.82785388064,
        ["y"] = -512.44475559634,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 441.43625229948,
        ["y"] = -484.22455760004,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 442.27553854782,
        ["y"] = -508.6944250525,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 558.02249955873,
        ["y"] = -453.22911201033,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 558.45454551674,
        ["y"] = -439.19501236279,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Royal Jelly Purveyor",
    ["id"] = 220141,
    ["count"] = 7,
    ["health"] = 48610763,
    ["scale"] = 1.5,
    ["displayId"] = 118378,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [440687] = {
        ["interruptible"] = true,
      },
      [440876] = {
      },
      [440887] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 333.04284067843,
        ["y"] = -473.54291707445,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 363.82703909302,
        ["y"] = -489.98776195481,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 404.46307675433,
        ["y"] = -498.02063023921,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 510.46114300135,
        ["y"] = -485.50998232163,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 546.47287589418,
        ["y"] = -445.57641330006,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 548.1513479669,
        ["y"] = -385.58463966025,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 561.21333275007,
        ["y"] = -385.38522720336,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 487.00998040198,
        ["y"] = -421.08827394326,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 585.55656225721,
        ["y"] = -412.52798186162,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Venture Co. Honey Harvester",
    ["id"] = 220946,
    ["count"] = 10,
    ["health"] = 77777220,
    ["scale"] = 1.8,
    ["stealthDetect"] = true,
    ["displayId"] = 108585,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [442589] = {
        ["magic"] = true,
      },
      [442995] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 347.50795125399,
        ["y"] = -497.31466360342,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 347.50795125399,
            ["y"] = -497.31466360342,
          },
          [2] = {
            ["x"] = 387.14813996651,
            ["y"] = -494.25093464923,
          },
          [3] = {
            ["x"] = 347.50795125399,
            ["y"] = -497.31466360342,
          },
        },
      },
      [2] = {
        ["x"] = 331.6211465304,
        ["y"] = -453.25315559256,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 331.6211465304,
            ["y"] = -453.25315559256,
          },
          [2] = {
            ["x"] = 330.70022128065,
            ["y"] = -418.23063809768,
          },
          [3] = {
            ["x"] = 331.6211465304,
            ["y"] = -453.25315559256,
          },
          [4] = {
            ["x"] = 330.70022128065,
            ["y"] = -491.41433653736,
          },
        },
      },
      [3] = {
        ["x"] = 537.83971380323,
        ["y"] = -483.43270751028,
        ["g"] = 39,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 537.83971380323,
            ["y"] = -483.43270751028,
          },
          [2] = {
            ["x"] = 543.15986294865,
            ["y"] = -460.21199950978,
          },
          [3] = {
            ["x"] = 537.83971380323,
            ["y"] = -483.43270751028,
          },
          [4] = {
            ["x"] = 525.00578035447,
            ["y"] = -491.41433653736,
          },
        },
      },
      [4] = {
        ["x"] = 509.76590733551,
        ["y"] = -416.36740905243,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 600.26861509223,
        ["y"] = -411.60981195443,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 600.2577669273,
        ["y"] = -427.66134779702,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Bee Wrangler",
    ["id"] = 210264,
    ["count"] = 5,
    ["health"] = 46180225,
    ["scale"] = 1.5,
    ["displayId"] = 118076,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [441119] = {
      },
      [441344] = {
      },
      [441351] = {
        ["interruptible"] = true,
      },
      [441353] = {
        ["enrage"] = true,
      },
      [456891] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 331.33065468759,
        ["y"] = -390.55027234015,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 364.37794762635,
        ["y"] = -504.49463294688,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 435.78660519517,
        ["y"] = -496.94101811974,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 512.64650213794,
        ["y"] = -500.20054615879,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 529.43914529944,
        ["y"] = -471.01890048348,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 547.59463236435,
        ["y"] = -399.80150252452,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 561.05547456795,
        ["y"] = -399.82646260661,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 493.94515396989,
        ["y"] = -450.56721286838,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 585.49176642167,
        ["y"] = -425.91145454013,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Bee-let",
    ["id"] = 218865,
    ["count"] = 1,
    ["health"] = 9722152,
    ["scale"] = 1,
    ["displayId"] = 121060,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [441397] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 319.07376064341,
        ["y"] = -512.14080811542,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 310.2195952954,
        ["y"] = -512.09967985612,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 328.36631777306,
        ["y"] = -512.53015114482,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 314.60172283077,
        ["y"] = -504.27817636155,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 324.25752024273,
        ["y"] = -504.02458269794,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 398.52214008824,
        ["y"] = -488.12445231272,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 415.54752014453,
        ["y"] = -498.05385764706,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 410.14663485948,
        ["y"] = -487.40156649023,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 393.27916601065,
        ["y"] = -497.83781130095,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 398.87113306604,
        ["y"] = -508.34052793085,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 411.04391681338,
        ["y"] = -508.34052793085,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 487.32912338028,
        ["y"] = -460.33870602405,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 493.37818676857,
        ["y"] = -439.76327979214,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 501.63740058166,
        ["y"] = -460.12066881257,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 484.15921024651,
        ["y"] = -448.2116106218,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 504.80736281847,
        ["y"] = -447.35371098055,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 611.22184635888,
        ["y"] = -400.39749963735,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 611.21100987749,
        ["y"] = -409.9355364845,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 611.09221623511,
        ["y"] = -419.66798965203,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 611.40552696848,
        ["y"] = -428.35266065502,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 611.49184621736,
        ["y"] = -438.4199909063,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 620.69500938281,
        ["y"] = -400.08423826697,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 620.20901118379,
        ["y"] = -409.87069771193,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 620.57615965939,
        ["y"] = -438.17155446037,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 620.43579586947,
        ["y"] = -419.88401769956,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 620.55456731311,
        ["y"] = -428.64434058941,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 495.15112879839,
        ["y"] = -378.05922221664,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 504.24521520911,
        ["y"] = -377.96299371341,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 513.58003542643,
        ["y"] = -377.62618781361,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 509.05699525852,
        ["y"] = -386.19104709895,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 499.77037386577,
        ["y"] = -386.67220290976,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 449.19896947412,
        ["y"] = -378.2997778866,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 458.34130666254,
        ["y"] = -378.01104823053,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 467.14675728155,
        ["y"] = -378.05916248215,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 453.52953720566,
        ["y"] = -386.47969555201,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 462.7200003558,
        ["y"] = -386.19098689745,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 378.08151814327,
        ["y"] = -399.03837700213,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 378.12587554232,
        ["y"] = -409.01892370785,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 377.93338815995,
        ["y"] = -418.97921274461,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 387.63802736831,
        ["y"] = -399.21785318108,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 387.67480364311,
        ["y"] = -408.92676625401,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 405.04759468223,
        ["y"] = -372.12497652696,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [43] = {
        ["x"] = 413.61249806367,
        ["y"] = -376.64800822111,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [44] = {
        ["x"] = 404.80704287842,
        ["y"] = -390.60204910987,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [45] = {
        ["x"] = 405.09574749656,
        ["y"] = -381.6041111289,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [46] = {
        ["x"] = 413.3237126767,
        ["y"] = -386.65643010438,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [47] = {
        ["x"] = 387.76936053041,
        ["y"] = -418.61676787651,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [48] = {
        ["x"] = 378.10880066968,
        ["y"] = -428.8121958571,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [49] = {
        ["x"] = 387.83420392267,
        ["y"] = -428.650114453,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Flavor Scientist",
    ["id"] = 214673,
    ["count"] = 7,
    ["health"] = 43749686,
    ["scale"] = 1.5,
    ["displayId"] = 119436,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [441434] = {
      },
      [441627] = {
        ["interruptible"] = true,
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 277.77440882639,
        ["y"] = -183.88511342789,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 275.39261184807,
        ["y"] = -119.31171033411,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 269.26787244206,
        ["y"] = -51.902717534772,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 282.76484564162,
        ["y"] = -51.675942396048,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 319.17240384756,
        ["y"] = -63.131257525281,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 319.17240384756,
            ["y"] = -63.131257525281,
          },
          [2] = {
            ["x"] = 354.53387157815,
            ["y"] = -62.743461597657,
          },
          [3] = {
            ["x"] = 379.67025492901,
            ["y"] = -61.696064161293,
          },
          [4] = {
            ["x"] = 354.53387157815,
            ["y"] = -62.743461597657,
          },
          [5] = {
            ["x"] = 379.67025492901,
            ["y"] = -61.696064161293,
          },
          [6] = {
            ["x"] = 354.53387157815,
            ["y"] = -62.743461597657,
          },
        },
      },
      [6] = {
        ["x"] = 405.68401327458,
        ["y"] = -128.10336167984,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 433.80125664845,
        ["y"] = -229.22443342203,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Taste Tester",
    ["id"] = 220060,
    ["count"] = 5,
    ["health"] = 48610763,
    ["scale"] = 1.5,
    ["displayId"] = 118003,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [441214] = {
        ["enrage"] = true,
      },
      [441242] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 286.96139012178,
        ["y"] = -127.21321495668,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 286.69660881531,
        ["y"] = -111.25882543272,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 268.77642300973,
        ["y"] = -65.248411301448,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 399.32187158156,
        ["y"] = -52.394238258433,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 412.47859940107,
        ["y"] = -52.205202794151,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 425.48154405486,
        ["y"] = -115.82201222134,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 412.27963419312,
        ["y"] = -115.3566678423,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 398.86049536165,
        ["y"] = -115.57963634104,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 418.25407759939,
        ["y"] = -128.00155843349,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 350.73802524082,
        ["y"] = -102.89721614668,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 430.99617201279,
        ["y"] = -167.8193854296,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 420.43925520695,
        ["y"] = -214.40280096662,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 433.98075895692,
        ["y"] = -214.59963832823,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 370.75633922324,
        ["y"] = -201.91446999524,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 383.60469166743,
        ["y"] = -202.12680477454,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Careless Hopgoblin",
    ["id"] = 223423,
    ["count"] = 10,
    ["health"] = 92360449,
    ["scale"] = 1.8,
    ["stealthDetect"] = true,
    ["displayId"] = 121087,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [448619] = {
      },
      [448920] = {
      },
      [448935] = {
      },
      [448977] = {
      },
      [449090] = {
      },
      [449106] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 277.03093025247,
        ["y"] = -147.8611712795,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 278.15327779472,
            ["y"] = -157.34522489781,
          },
          [2] = {
            ["x"] = 275.86224750715,
            ["y"] = -135.57492470087,
          },
          [3] = {
            ["x"] = 275.86224750715,
            ["y"] = -90.643554152958,
          },
          [4] = {
            ["x"] = 275.86224750715,
            ["y"] = -135.57492470087,
          },
        },
      },
      [2] = {
        ["x"] = 333.99245559351,
        ["y"] = -72.242661870812,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 332.9717074561,
        ["y"] = -53.679702393122,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 379.2012099563,
        ["y"] = -170.52175034094,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 379.2012099563,
            ["y"] = -170.52175034094,
          },
          [2] = {
            ["x"] = 377.72998593564,
            ["y"] = -191.50957666536,
          },
          [3] = {
            ["x"] = 379.2012099563,
            ["y"] = -170.52175034094,
          },
          [4] = {
            ["x"] = 377.95691805696,
            ["y"] = -151.45709872584,
          },
        },
      },
      [5] = {
        ["x"] = 412.27524905682,
        ["y"] = -157.50939123559,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 412.27524905682,
            ["y"] = -157.50939123559,
          },
          [2] = {
            ["x"] = 410.78748194812,
            ["y"] = -177.84864785386,
          },
          [3] = {
            ["x"] = 411.01442617959,
            ["y"] = -200.88166477017,
          },
          [4] = {
            ["x"] = 410.78748194812,
            ["y"] = -177.84864785386,
          },
          [5] = {
            ["x"] = 412.27524905682,
            ["y"] = -157.50939123559,
          },
          [6] = {
            ["x"] = 414.07793110139,
            ["y"] = -140.29234453284,
          },
        },
      },
    },
  },
  [14] = {
    ["name"] = "Brew Drop",
    ["id"] = 210270,
    ["count"] = 1,
    ["health"] = 16527659,
    ["scale"] = 1.2,
    ["displayId"] = 117828,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [441179] = {
      },
      [449702] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 357.68787078817,
        ["y"] = -92.127022471194,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 317.35656762863,
        ["y"] = -141.03887927245,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 317.07041464272,
        ["y"] = -119.00223101048,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 317.48286036447,
        ["y"] = -130.54143775774,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 340.12787380183,
        ["y"] = -160.64953588855,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 353.26582956869,
        ["y"] = -160.86076240794,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 430.23623975823,
        ["y"] = -154.1873948485,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Yes Man",
    ["id"] = 219588,
    ["count"] = 3,
    ["health"] = 48610763,
    ["scale"] = 2,
    ["displayId"] = 121109,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [439403] = {
      },
      [439467] = {
      },
      [439468] = {
        ["bleed"] = true,
      },
      [439474] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 427.97917013427,
        ["y"] = -263.62657947038,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 428.19088445094,
        ["y"] = -283.3691155814,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 428.50850398221,
        ["y"] = -303.11164611892,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 428.19095837039,
        ["y"] = -322.90713951689,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Brewmaster Aldryr",
    ["id"] = 210271,
    ["count"] = 0,
    ["health"] = 291795727,
    ["scale"] = 2,
    ["displayId"] = 116429,
    ["creatureType"] = "Humanoid",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2586,
    ["instanceID"] = 1272,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [432179] = {
      },
      [432182] = {
      },
      [432196] = {
      },
      [432198] = {
      },
      [432229] = {
      },
      [442525] = {
      },
      [442611] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 384.671169092,
        ["y"] = -292.4004437642,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "I'pa",
    ["id"] = 210267,
    ["count"] = 0,
    ["health"] = 291795727,
    ["scale"] = 1.5,
    ["displayId"] = 117177,
    ["creatureType"] = "Elemental",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2586,
    ["instanceID"] = 1272,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [439031] = {
      },
      [439202] = {
      },
      [439325] = {
        ["magic"] = true,
      },
      [439365] = {
      },
      [439645] = {
      },
      [439991] = {
      },
      [440147] = {
      },
      [442108] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 376.52496705568,
        ["y"] = -131.47837250607,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Benk Buzzbee",
    ["id"] = 218002,
    ["count"] = 0,
    ["health"] = 306385513,
    ["scale"] = 1.9,
    ["displayId"] = 120557,
    ["iconTexture"] = 5633719,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2586,
    ["instanceID"] = 1272,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [438025] = {
      },
      [438651] = {
      },
      [439524] = {
      },
      [439586] = {
      },
      [440134] = {
      },
      [440138] = {
      },
      [440140] = {
      },
      [440141] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 454.00524958257,
        ["y"] = -421.80846250798,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Goldie Baronbottom",
    ["id"] = 214661,
    ["count"] = 0,
    ["health"] = 389060969,
    ["scale"] = 2,
    ["displayId"] = 118000,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2586,
    ["instanceID"] = 1272,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [435560] = {
      },
      [435622] = {
      },
      [435788] = {
      },
      [435789] = {
      },
      [436592] = {
      },
      [436624] = {
      },
      [436637] = {
      },
      [436640] = {
        ["magic"] = true,
      },
      [436644] = {
      },
      [442484] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 474.11988306201,
        ["y"] = -295.8210557454,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Flavor Scientist",
    ["id"] = 222964,
    ["count"] = 7,
    ["health"] = 43749686,
    ["scale"] = 1.5,
    ["displayId"] = 119436,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [441434] = {
      },
      [441627] = {
        ["interruptible"] = true,
        ["magic"] = true,
      },
      [447046] = {
      },
      [447060] = {
      },
      [447135] = {
      },
      [447136] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 346.84767602084,
        ["y"] = -150.2651063857,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 363.90670806972,
        ["y"] = -102.53801533687,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 329.77901329051,
        ["y"] = -130.74802208617,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Brew Drop",
    ["id"] = 219301,
    ["count"] = 0,
    ["health"] = 8911974,
    ["scale"] = 1.5,
    ["displayId"] = 120498,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [440082] = {
      },
      [440087] = {
      },
      [440104] = {
      },
      [441171] = {
      },
      [441179] = {
      },
      [442122] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 359.15332315308,
        ["y"] = -124.16004875461,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 358.77019797915,
        ["y"] = -137.94020498237,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
    },
  },
  [22] = {
    ["name"] = "Ravenous Cinderbee",
    ["id"] = 218016,
    ["count"] = 0,
    ["health"] = 10127243,
    ["scale"] = 2,
    ["displayId"] = 120631,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [438971] = {
      },
      [438975] = {
      },
      [439418] = {
      },
      [443983] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 436.15825385558,
        ["y"] = -442.58139094879,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 426.03875246658,
        ["y"] = -422.81151813051,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 433.65206492025,
        ["y"] = -401.76253879763,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
    },
  },
  [23] = {
    ["name"] = "Worker Bee",
    ["id"] = 223497,
    ["count"] = 5,
    ["health"] = 48610763,
    ["scale"] = 1.5,
    ["displayId"] = 121054,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [441410] = {
      },
      [441413] = {
      },
      [443487] = {
      },
      [443491] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 473.12624851785,
        ["y"] = -486.40498562502,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 472.41489871366,
        ["y"] = -501.85224970314,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
    },
  },
  [24] = {
    ["name"] = "Bee-let",
    ["id"] = 223498,
    ["count"] = 1,
    ["health"] = 9722152,
    ["scale"] = 1,
    ["displayId"] = 121060,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Silence"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [441397] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 492.74172559857,
        ["y"] = -475.87521361089,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 492.65283363995,
        ["y"] = -484.54683904897,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 492.65291249675,
        ["y"] = -492.67062980356,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 492.54876519663,
        ["y"] = -500.58610624373,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 492.7570485316,
        ["y"] = -509.23066588651,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 483.70524758512,
        ["y"] = -476.06683536459,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 483.63953893672,
        ["y"] = -484.4537079996,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 484.02184367244,
        ["y"] = -493.25509980025,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 483.48147444011,
        ["y"] = -500.89611162972,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 484.01449201719,
        ["y"] = -509.80043394773,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
    },
  },
};
