local addonName = ...
local MDT = MDT
local L = MDT.L

local dungeonIndex = 117
MDT.dungeonList[dungeonIndex] = L["Darkflame Cleft"]
MDT.mapInfo[dungeonIndex] = {
  teleportId = 445441,
  shortName = L["darkflameShortName"],
  englishName = "Darkflame Cleft",
  mapID = 504
}

local zones = { 2214, 2303 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "DarkflameCleft",
  [1] = "DarkflameCleft",
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["Darkflame Cleft"]
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 386 }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dungeonEntrance",
      ["x"] = 125.4212790233,
      ["y"] = -388.65450346876,
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "generalNote",
      ["x"] = 196.00099380441,
      ["y"] = -439.3556004923,
      ["text"] = "darkflameSpawns",
    },
    [3] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "generalNote",
      ["x"] = 189.73103611103,
      ["y"] = -233.34462517655,
      ["text"] = "darkflameDespawns",
    },
    [4] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "generalNote",
      ["x"] = 189.73103611103,
      ["y"] = -108.3944672441,
      ["text"] = "darkflameSpawns",
    },
    [5] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 593.90358545035,
      ["y"] = -421.79117560229,
    },
    [6] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 567.87566862298,
      ["y"] = -401.0842072571,
    },
    [7] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 567.58389773082,
      ["y"] = -438.60070521783,
    },
    [8] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 534.92710397453,
      ["y"] = -400.88520146364,
    },
    [9] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 535.06736465484,
      ["y"] = -438.99689080443,
    },
    [10] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 513.89271012776,
      ["y"] = -420.56145327032,
    },
    [11] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 495.70384190314,
      ["y"] = -401.46240567183,
    },
    [12] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 496.11617966092,
      ["y"] = -438.31582029135,
    },
    [13] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 462.70217456284,
      ["y"] = -401.67265378132,
    },
    [14] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 463.99380101931,
      ["y"] = -438.45084961883,
    },
    [15] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 445.42765006623,
      ["y"] = -419.99779260027,
    },
    [16] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 432.10809210435,
      ["y"] = -438.35830796597,
    },
    [17] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 432.07370550467,
      ["y"] = -400.69643608037,
    },
    [18] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 603.74151324445,
      ["y"] = -441.90152509788,
    },
    [19] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 645.11461910213,
      ["y"] = -438.87113623162,
    },
    [20] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 603.50578596286,
      ["y"] = -399.00220650767,
    },
    [21] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dfcItem",
      ["x"] = 643.66567506583,
      ["y"] = -400.27700874129,
    },
  },
};


MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Menial Laborer",
    ["id"] = 210810,
    ["count"] = 1,
    ["health"] = 8859628,
    ["scale"] = 0.8,
    ["displayId"] = 114696,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [425565] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 167.54588102631,
        ["y"] = -245.05138763633,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 191.51055448569,
        ["y"] = -380.28232981568,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 190.89770684275,
        ["y"] = -366.0264811936,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 186.8549102503,
        ["y"] = -372.90725893621,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 194.70344180661,
        ["y"] = -372.57949166377,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 205.64245380043,
        ["y"] = -357.57269397744,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 201.60954069114,
        ["y"] = -365.17427428816,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 209.31196775113,
        ["y"] = -365.53755588106,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 194.06402879736,
        ["y"] = -341.59224240044,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 201.91256035368,
        ["y"] = -341.77390824349,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 197.82438947078,
        ["y"] = -348.94698289745,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 179.40395596667,
        ["y"] = -315.12283724124,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 199.0288317181,
        ["y"] = -314.87589724107,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 197.34453314675,
        ["y"] = -326.32447416375,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 189.26463719625,
        ["y"] = -308.42370898473,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 181.54097716597,
        ["y"] = -326.81399412255,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 220.55732660493,
        ["y"] = -241.12852921842,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 220.90246283605,
        ["y"] = -256.77242404775,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 220.46770726204,
        ["y"] = -233.36925365724,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 228.33896205462,
        ["y"] = -257.21229013432,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 228.21702048229,
        ["y"] = -240.8308314037,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 227.96491529094,
        ["y"] = -232.87025242508,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 220.53725210235,
        ["y"] = -248.7311105098,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 228.4097862192,
        ["y"] = -248.37173683429,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 211.25721069524,
        ["y"] = -194.53123508683,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 196.81242803057,
        ["y"] = -194.50385898726,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 204.19055432209,
        ["y"] = -194.62360003869,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 197.6648829398,
        ["y"] = -218.68703468388,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 205.20368850318,
        ["y"] = -218.78656790292,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 212.60611302033,
        ["y"] = -218.19913320742,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 208.74419316436,
        ["y"] = -225.29507260671,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 201.40407139021,
        ["y"] = -226.07407853902,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 330.90395738776,
        ["y"] = -409.69742578297,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 325.12967418471,
        ["y"] = -419.94988909764,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 331.51043680992,
        ["y"] = -430.01253884071,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 160.81937940347,
        ["y"] = -240.55739361424,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 160.65993522392,
        ["y"] = -256.85184241948,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 160.73236623203,
        ["y"] = -248.73361028429,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 167.32847303256,
        ["y"] = -253.34361299938,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Rank Overseer",
    ["id"] = 211121,
    ["count"] = 10,
    ["health"] = 70877027,
    ["scale"] = 1.5,
    ["stealthDetect"] = true,
    ["displayId"] = 114091,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [423501] = {
      },
      [428064] = {
      },
      [428066] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 189.01954887993,
        ["y"] = -318.81360942073,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 208.82642446501,
        ["y"] = -244.41240521039,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 178.40017824647,
        ["y"] = -246.04278146831,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 188.42840937806,
        ["y"] = -180.13982940431,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Lowly Moleherd",
    ["id"] = 210818,
    ["count"] = 5,
    ["health"] = 42083234,
    ["scale"] = 1.2,
    ["displayId"] = 114721,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [424650] = {
        ["enrage"] = true,
      },
      [425536] = {
        ["interruptible"] = true,
      },
      [428089] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 172.88271830631,
        ["y"] = -287.01189873397,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 170.89747060135,
        ["y"] = -217.78448311178,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 179.57702265801,
        ["y"] = -173.87085609918,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 197.63148086861,
        ["y"] = -175.21132368574,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Pack Mole",
    ["id"] = 211977,
    ["count"] = 3,
    ["health"] = 46513049,
    ["scale"] = 1.2,
    ["displayId"] = 112394,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [425704] = {
        ["enrage"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 161.12458045389,
        ["y"] = -286.95652650699,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 161.25277401111,
        ["y"] = -275.39035567572,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 171.09845154456,
        ["y"] = -275.10749983555,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 159.79225707305,
        ["y"] = -218.13035635824,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 160.21646488714,
        ["y"] = -207.60160489065,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 183.51351429231,
        ["y"] = -157.20795308055,
        ["g"] = 14,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 183.51351429231,
            ["y"] = -157.20795308055,
          },
          [2] = {
            ["x"] = 172.39882596461,
            ["y"] = -158.95041430116,
          },
          [3] = {
            ["x"] = 168.38405738641,
            ["y"] = -163.21604130566,
          },
          [4] = {
            ["x"] = 167.63130981461,
            ["y"] = -176.76572732194,
          },
          [5] = {
            ["x"] = 173.15157353641,
            ["y"] = -186.3006734755,
          },
          [6] = {
            ["x"] = 179.17361154179,
            ["y"] = -191.56999262456,
          },
          [7] = {
            ["x"] = 187.7048655508,
            ["y"] = -191.56999262456,
          },
          [8] = {
            ["x"] = 201.25455156708,
            ["y"] = -188.55894490639,
          },
          [9] = {
            ["x"] = 207.52756286069,
            ["y"] = -183.28964011508,
          },
          [10] = {
            ["x"] = 209.28397386156,
            ["y"] = -175.00925889011,
          },
          [11] = {
            ["x"] = 207.27661828794,
            ["y"] = -166.97983659563,
          },
          [12] = {
            ["x"] = 202.76004671069,
            ["y"] = -158.69949844389,
          },
          [13] = {
            ["x"] = 199.749027708,
            ["y"] = -155.93939529847,
          },
        },
      },
      [7] = {
        ["x"] = 192.53892748637,
        ["y"] = -156.90943244181,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Royal Wicklighter",
    ["id"] = 210812,
    ["count"] = 6,
    ["health"] = 39868328,
    ["scale"] = 1.2,
    ["displayId"] = 114709,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [423479] = {
        ["interruptible"] = true,
      },
      [428019] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 198.82728936596,
        ["y"] = -203.86529203835,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 199.58003333392,
        ["y"] = -274.84704228369,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 208.98872623263,
        ["y"] = -274.80162914544,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 169.35741120901,
        ["y"] = -207.39093018737,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 209.09973535887,
        ["y"] = -203.95135952226,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 377.62760864201,
        ["y"] = -69.420376267683,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Kobold Taskworker",
    ["id"] = 212383,
    ["count"] = 4,
    ["health"] = 44298142,
    ["scale"] = 1.5,
    ["displayId"] = 114757,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [426883] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 321.78180841067,
        ["y"] = -72.583003497847,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 306.96728859064,
        ["y"] = -73.090414410364,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 397.30255307439,
        ["y"] = -141.34681788162,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 383.81586954449,
        ["y"] = -141.14710217441,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 383.38613334931,
        ["y"] = -155.37326843589,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 344.44432604103,
        ["y"] = -107.87366256984,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 344.80639040364,
        ["y"] = -121.48648570189,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 356.77148235378,
        ["y"] = -121.06102758575,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Blazing Fiend",
    ["id"] = 220815,
    ["count"] = 7,
    ["health"] = 35438513,
    ["scale"] = 1.5,
    ["displayId"] = 118916,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [424322] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 370.00081782824,
        ["y"] = -82.377323972187,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 314.42471647282,
        ["y"] = -85.767435867036,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 384.2447581675,
        ["y"] = -82.639954602464,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 356.83122706189,
        ["y"] = -107.61722583522,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Wandering Candle",
    ["id"] = 208450,
    ["count"] = 15,
    ["health"] = 70877027,
    ["scale"] = 1.7,
    ["displayId"] = 114467,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [430171] = {
      },
      [440652] = {
      },
      [440653] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 350.65617164586,
        ["y"] = -149.37888562116,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 396.86915704415,
        ["y"] = -154.01452375706,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 322.99663609099,
        ["y"] = -106.636893578,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 322.45920694254,
            ["y"] = -117.5644742747,
          },
          [2] = {
            ["x"] = 330.10182731071,
            ["y"] = -129.6453090474,
          },
          [3] = {
            ["x"] = 349.44894725884,
            ["y"] = -135.19866607643,
          },
          [4] = {
            ["x"] = 368.43779079613,
            ["y"] = -129.6453090474,
          },
          [5] = {
            ["x"] = 369.87089643952,
            ["y"] = -117.1055087222,
          },
          [6] = {
            ["x"] = 369.33349635543,
            ["y"] = -100.08722904111,
          },
          [7] = {
            ["x"] = 354.82315155027,
            ["y"] = -89.517963507746,
          },
          [8] = {
            ["x"] = 335.65517465162,
            ["y"] = -89.697096869109,
          },
          [9] = {
            ["x"] = 327.95213978127,
            ["y"] = -99.01238043233,
          },
        },
      },
      [4] = {
        ["x"] = 350.04534095035,
        ["y"] = -229.29361090496,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Kobold Flametender",
    ["id"] = 213913,
    ["count"] = 1,
    ["health"] = 8859628,
    ["scale"] = 1.2,
    ["displayId"] = 118173,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [428563] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 334.16917333389,
        ["y"] = -315.5547388441,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 334.00241123105,
        ["y"] = -327.08648588353,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 334.53170787471,
        ["y"] = -338.65369264769,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 334.41295167154,
        ["y"] = -351.02954211105,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 365.69510093962,
        ["y"] = -315.54850674198,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 365.97444699516,
        ["y"] = -327.16356847558,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 365.52847935801,
        ["y"] = -339.37895299435,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 366.25986641585,
        ["y"] = -351.14834125127,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 350.72875689655,
        ["y"] = -332.6032084369,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 344.51109887188,
        ["y"] = -362.93013516189,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 355.18020982138,
        ["y"] = -363.00727109997,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 365.90361613873,
        ["y"] = -407.33018192815,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 372.29055101441,
        ["y"] = -416.16768966516,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 373.38455068043,
        ["y"] = -426.95561536836,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 365.45758604771,
        ["y"] = -433.8425802314,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Sootsnout",
    ["id"] = 212412,
    ["count"] = 20,
    ["health"] = 132894425,
    ["scale"] = 1.5,
    ["displayId"] = 114736,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["spells"] = {
      [426261] = {
      },
      [426265] = {
      },
      [426295] = {
        ["interruptible"] = true,
        ["magic"] = true,
      },
      [426677] = {
        ["interruptible"] = true,
      },
      [1218131] = {
      },
      [1218133] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 358.91836838439,
        ["y"] = -420.26223705558,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Torchsnarl",
    ["id"] = 212411,
    ["count"] = 20,
    ["health"] = 132894425,
    ["scale"] = 2,
    ["stealthDetect"] = true,
    ["displayId"] = 114705,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [426260] = {
      },
      [426275] = {
      },
      [426277] = {
      },
      [426619] = {
      },
      [1218117] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 341.19512170397,
        ["y"] = -420.30391001614,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Skittering Darkness",
    ["id"] = 208457,
    ["count"] = 1,
    ["health"] = 8859628,
    ["scale"] = 0.8,
    ["displayId"] = 92318,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [422393] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 505.62985716713,
        ["y"] = -423.92537809853,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 416.92218602371,
        ["y"] = -409.06751664621,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 417.18962646993,
        ["y"] = -416.54579288966,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 417.426561332,
        ["y"] = -423.87545308865,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 417.93910485564,
        ["y"] = -431.58323936653,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 424.77708978518,
        ["y"] = -409.65885923431,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 424.87819734775,
        ["y"] = -416.61177492113,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 424.65365094344,
        ["y"] = -423.37099835529,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 425.22017145238,
        ["y"] = -430.69404972924,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 481.09184337368,
        ["y"] = -412.90830487061,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 483.88376978204,
        ["y"] = -421.15976702255,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 480.09801015697,
        ["y"] = -429.0936490959,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 524.43534064976,
        ["y"] = -399.88729891426,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 520.71199760539,
        ["y"] = -383.94387695209,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 525.58337408574,
        ["y"] = -391.40725493795,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 503.22047413889,
        ["y"] = -430.38178123993,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 504.92195768006,
        ["y"] = -416.26520400501,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 500.51378736368,
        ["y"] = -411.05768169744,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 547.3278014228,
        ["y"] = -446.75788896851,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 552.17469223476,
        ["y"] = -452.70372962752,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 553.78988422908,
        ["y"] = -442.17078306528,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 571.44135577265,
        ["y"] = -411.90406126141,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 568.29112718164,
        ["y"] = -419.76709684041,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 573.12608100622,
        ["y"] = -426.7425403363,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 624.63750392604,
        ["y"] = -407.07922032624,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 624.89821646987,
        ["y"] = -414.86870370414,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 624.73818946648,
        ["y"] = -423.77402536719,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 624.46777487638,
        ["y"] = -431.84391848462,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 616.863932058,
        ["y"] = -432.76992117231,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 616.73148269777,
        ["y"] = -424.05234501927,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 617.05132910195,
        ["y"] = -415.16101083858,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 617.03366739966,
        ["y"] = -406.89556646867,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 649.3326437763,
        ["y"] = -410.09855661018,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 644.2058172053,
        ["y"] = -419.75203214504,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 649.14106275848,
        ["y"] = -430.5847822482,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 229.52954086188,
        ["y"] = -141.96033408463,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 242.30346232303,
        ["y"] = -168.74210220296,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 230.87032463706,
        ["y"] = -168.88370152802,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 229.4594410416,
        ["y"] = -152.29884013314,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 219.61457052009,
        ["y"] = -168.7427491561,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 212.52124389289,
        ["y"] = -161.66646231559,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 203.59458772249,
        ["y"] = -136.70186058792,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [43] = {
        ["x"] = 217.17976891621,
        ["y"] = -137.26704985598,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [44] = {
        ["x"] = 216.79178996241,
        ["y"] = -123.99949588095,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [45] = {
        ["x"] = 159.4139641974,
        ["y"] = -122.23473958387,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [46] = {
        ["x"] = 175.7188088793,
        ["y"] = -137.30243645539,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [47] = {
        ["x"] = 175.93044625556,
        ["y"] = -122.2706145404,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [48] = {
        ["x"] = 189.974668367,
        ["y"] = -122.79957599738,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [49] = {
        ["x"] = 175.50747614758,
        ["y"] = -100.25121710423,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [50] = {
        ["x"] = 159.73415653137,
        ["y"] = -100.39283601463,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [51] = {
        ["x"] = 175.57782788268,
        ["y"] = -86.172303963474,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [52] = {
        ["x"] = 201.47770098067,
        ["y"] = -85.043383867814,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [53] = {
        ["x"] = 202.35964873071,
        ["y"] = -100.1108288245,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [54] = {
        ["x"] = 216.79188143377,
        ["y"] = -99.758103485648,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Shuffling Horror",
    ["id"] = 208456,
    ["count"] = 2,
    ["health"] = 39868328,
    ["scale"] = 1.4,
    ["displayId"] = 92318,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [422541] = {
        ["interruptible"] = true,
      },
      [422692] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 518.55027897035,
        ["y"] = -450.52197810599,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 534.71100502567,
            ["y"] = -456.32696004833,
          },
          [2] = {
            ["x"] = 519.3174563377,
            ["y"] = -454.96553892736,
          },
          [3] = {
            ["x"] = 509.34914515348,
            ["y"] = -449.33129476737,
          },
          [4] = {
            ["x"] = 507.18211554787,
            ["y"] = -442.83025282854,
          },
          [5] = {
            ["x"] = 516.42808353021,
            ["y"] = -439.65197086711,
          },
          [6] = {
            ["x"] = 525.38509548061,
            ["y"] = -436.32921088971,
          },
          [7] = {
            ["x"] = 532.60844936931,
            ["y"] = -441.09663383185,
          },
          [8] = {
            ["x"] = 533.1863145552,
            ["y"] = -447.88663180263,
          },
        },
      },
      [2] = {
        ["x"] = 473.08896889125,
        ["y"] = -420.88360446596,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 515.64067652495,
        ["y"] = -393.92654957904,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 578.58939961527,
        ["y"] = -419.42426793953,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 656.59651199282,
        ["y"] = -420.51828976615,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Corridor Creeper",
    ["id"] = 210539,
    ["count"] = 4,
    ["health"] = 59802491,
    ["scale"] = 1.7,
    ["displayId"] = 92709,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [422628] = {
      },
      [469620] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 496.37283357377,
        ["y"] = -421.67701178962,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 605.27681947128,
        ["y"] = -410.78993037556,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 605.11182595891,
        ["y"] = -427.66986638172,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 228.18917353571,
        ["y"] = -129.99739482966,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 216.72110194495,
        ["y"] = -150.39363639345,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 204.15946782633,
        ["y"] = -123.08192207608,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 160.05144596115,
        ["y"] = -85.008021780322,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 215.80382331625,
        ["y"] = -83.03251451555,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Blazing Fiend",
    ["id"] = 211228,
    ["count"] = 7,
    ["health"] = 35438513,
    ["scale"] = 1.5,
    ["displayId"] = 118916,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [424322] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 329.08999036529,
        ["y"] = -236.51362375044,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Blazing Fiend",
    ["id"] = 223770,
    ["count"] = 7,
    ["health"] = 35438513,
    ["scale"] = 1.5,
    ["displayId"] = 118916,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [424322] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 370.3419514256,
        ["y"] = -222.99352152755,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Blazing Fiend",
    ["id"] = 223772,
    ["count"] = 7,
    ["health"] = 35438513,
    ["scale"] = 1.5,
    ["displayId"] = 118916,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [424322] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 329.62205548986,
        ["y"] = -208.30606194704,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Blazing Fiend",
    ["id"] = 223773,
    ["count"] = 7,
    ["health"] = 35438513,
    ["scale"] = 1.5,
    ["displayId"] = 118916,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [424322] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 329.64576377637,
        ["y"] = -222.87460343229,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Blazing Fiend",
    ["id"] = 223774,
    ["count"] = 7,
    ["health"] = 35438513,
    ["scale"] = 1.5,
    ["displayId"] = 118916,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [424322] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 328.80700364604,
        ["y"] = -250.13042418981,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Blazing Fiend",
    ["id"] = 223775,
    ["count"] = 7,
    ["health"] = 35438513,
    ["scale"] = 1.5,
    ["displayId"] = 118916,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [424322] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 369.98156060682,
        ["y"] = -237.550111186,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Blazing Fiend",
    ["id"] = 223776,
    ["count"] = 7,
    ["health"] = 35438513,
    ["scale"] = 1.5,
    ["displayId"] = 118916,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [424322] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 369.95066764928,
        ["y"] = -251.28955624243,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
    },
  },
  [22] = {
    ["name"] = "Blazing Fiend",
    ["id"] = 223777,
    ["count"] = 7,
    ["health"] = 35438513,
    ["scale"] = 1.5,
    ["displayId"] = 118916,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [424322] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 370.01787061146,
        ["y"] = -208.68771677253,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
    },
  },
  [23] = {
    ["name"] = "Ol' Waxbeard",
    ["id"] = 210153,
    ["count"] = 0,
    ["health"] = 221649427,
    ["scale"] = 2,
    ["displayId"] = 114039,
    ["creatureType"] = "Beast",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2569,
    ["instanceID"] = 1210,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [421686] = {
      },
      [422122] = {
      },
      [422125] = {
      },
      [422245] = {
      },
      [422246] = {
      },
      [422274] = {
      },
      [423693] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 112.86349953552,
        ["y"] = -113.77314616213,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
    },
  },
  [24] = {
    ["name"] = "Blazikon",
    ["id"] = 208743,
    ["count"] = 0,
    ["health"] = 310309198,
    ["scale"] = 2,
    ["displayId"] = 115888,
    ["creatureType"] = "Elemental",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2569,
    ["instanceID"] = 1210,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [421638] = {
      },
      [421817] = {
      },
      [421910] = {
      },
      [422700] = {
      },
      [423109] = {
      },
      [424212] = {
      },
      [424223] = {
      },
      [425394] = {
      },
      [443835] = {
      },
      [443969] = {
      },
      [1218308] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 352.20470858222,
        ["y"] = -275.47338923516,
        ["sublevel"] = 1,
      },
    },
  },
  [25] = {
    ["name"] = "The Candle King",
    ["id"] = 208745,
    ["count"] = 0,
    ["health"] = 310309198,
    ["scale"] = 2,
    ["displayId"] = 114508,
    ["creatureType"] = "Humanoid",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2569,
    ["instanceID"] = 1210,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [420659] = {
      },
      [420676] = {
      },
      [420696] = {
      },
      [421146] = {
      },
      [421274] = {
      },
      [421277] = {
      },
      [421282] = {
      },
      [422648] = {
      },
      [426127] = {
      },
      [426145] = {
        ["interruptible"] = true,
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 351.51971397785,
        ["y"] = -485.62906785342,
        ["sublevel"] = 1,
      },
    },
  },
  [26] = {
    ["name"] = "The Darkness",
    ["id"] = 208747,
    ["count"] = 0,
    ["health"] = 897680180,
    ["scale"] = 2,
    ["displayId"] = 117773,
    ["creatureType"] = "Aberration",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2569,
    ["instanceID"] = 1210,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [424074] = {
      },
      [426943] = {
      },
      [427011] = {
      },
      [427015] = {
      },
      [427025] = {
      },
      [427100] = {
      },
      [427157] = {
        ["interruptible"] = true,
      },
      [427180] = {
      },
      [428266] = {
      },
      [428276] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 718.48655523821,
        ["y"] = -417.47078593602,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
    },
  },
  [27] = {
    ["name"] = "Corridor Sleeper",
    ["id"] = 220616,
    ["count"] = 4,
    ["health"] = 59802491,
    ["scale"] = 1.7,
    ["displayId"] = 92709,
    ["creatureType"] = "Beast",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [422628] = {
      },
      [442224] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 143.85905719803,
        ["y"] = -161.72912490627,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 235.84055258832,
        ["y"] = -63.891141951027,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 183.26799469897,
        ["y"] = -433.233348055,
        ["sublevel"] = 1,
      },
    },
  },
  [28] = {
    ["name"] = "Menial Laborer",
    ["id"] = 210148,
    ["count"] = 0,
    ["health"] = 7383024,
    ["scale"] = 2,
    ["displayId"] = 114170,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
    },
    ["clones"] = {
      [1] = {
        ["x"] = 81.544515711208,
        ["y"] = -119.21427679251,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 83.755854243604,
        ["y"] = -100.83095609976,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 95.102265870756,
        ["y"] = -84.038416088624,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 116.88707005029,
        ["y"] = -80.407526584266,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 92.832944792844,
        ["y"] = -136.23142032345,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
    },
  },
  [29] = {
    ["name"] = "Dynamite Mine Cart",
    ["id"] = 213751,
    ["count"] = 0,
    ["health"] = 11074536,
    ["scale"] = 2,
    ["displayId"] = 114373,
    ["creatureType"] = "Mechanical",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [429093] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 112.2764075375,
        ["y"] = -144.37614159044,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 130.50273009445,
        ["y"] = -136.23144454375,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
    },
  },
  [30] = {
    ["name"] = "Wriggling Darkspawn",
    ["id"] = 213008,
    ["count"] = 0,
    ["health"] = 2214907,
    ["scale"] = 2,
    ["displayId"] = 68714,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [427176] = {
        ["interruptible"] = true,
      },
      [439010] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 745.19863816061,
        ["y"] = -415.70188851551,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 735.48802227915,
        ["y"] = -399.91988683678,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 717.33393806187,
        ["y"] = -391.75053682885,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 739.57272755849,
        ["y"] = -431.23570633189,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 724.59557174878,
        ["y"] = -444.39744160971,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
    },
  },
};
