local addonName = ...
local MDT = MDT
local L = MDT.L

local dungeonIndex = 123
MDT.dungeonList[dungeonIndex] = L["Eco-Dome Al'dani"]
MDT.mapInfo[dungeonIndex] = {
  viewportPositionOverrides = {
    [1] = {
      zoomScale = 1.2999999523163,
      horizontalPan = 93.940380226733,
      verticalPan = 48.760507870168,
    },
  },
  teleportId = 1237215,
  shortName = L["ecoDomeAldaniShortName"],
  englishName = "Eco-Dome Al'dani",
  mapID = 542
}

local zones = { 2449, 2371 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "",
  [1] = { customTextures = 'Interface\\AddOns\\'..addonName..'\\TheWarWithin\\Textures\\EcoDomeAldani' }
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["Eco-Dome Al'dani"]
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 555 }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dungeonEntrance",
      ["x"] = 720.52081422796,
      ["y"] = -284.37412958645,
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "EDAItem1",
      ["x"] = 325.14160637362,
      ["y"] = -146.75144386654,
    },
    [3] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "EDAItem3",
      ["x"] = 351.48463704022,
      ["y"] = -161.71465149702,
    },
    [4] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "EDAItem3",
      ["x"] = 294.47694614592,
      ["y"] = -161.78314214911,
    },
    [5] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "EDAItem3",
      ["x"] = 248.89494571992,
      ["y"] = -221.37047997261,
    },
    [6] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "EDAItem3",
      ["x"] = 428.25370127309,
      ["y"] = -178.33271095755,
    },
    [7] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "EDAItem2",
      ["x"] = 646.85152360344,
      ["y"] = -332.85970682783,
    },
    [8] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "EDAItem2",
      ["x"] = 555.36841603911,
      ["y"] = -310.07648831867,
    },
    [9] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "generalNote",
      ["x"] = 535.61230396802,
      ["y"] = -232.22715982904,
      ["text"] = "eda2BossNote",
    },
  },
};



MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Ravaging Scavenger",
    ["id"] = 234912,
    ["count"] = 5,
    ["health"] = 92758701,
    ["scale"] = 1.1,
    ["displayId"] = 131383,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [1221130] = {
      },
      [1221133] = {
        ["enrage"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 691.2251354036,
        ["y"] = -267.98617636574,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 693.83665672448,
        ["y"] = -314.5506763881,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 663.54627198226,
        ["y"] = -335.53279496056,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 643.41750907101,
        ["y"] = -379.39716611477,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 652.92087543946,
        ["y"] = -378.21464232256,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 624.71886148818,
        ["y"] = -374.31318231765,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 575.04772876205,
        ["y"] = -395.18227786962,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 581.41408343643,
        ["y"] = -387.73903954683,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 562.16215837723,
        ["y"] = -359.77142084925,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 588.84880930871,
        ["y"] = -410.82058392563,
        ["g"] = 67,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 598.18676928566,
        ["y"] = -410.64442665439,
        ["g"] = 67,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Overgorged Mite",
    ["id"] = 242209,
    ["count"] = 5,
    ["health"] = 74206961,
    ["scale"] = 1.1,
    ["displayId"] = 131381,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [1220890] = {
      },
      [1220891] = {
      },
      [1229474] = {
        ["interruptible"] = true,
      },
      [1231494] = {
      },
      [1231497] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 688.77690079464,
        ["y"] = -279.17373416986,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 699.21568606582,
        ["y"] = -275.3094866761,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 682.97499488953,
        ["y"] = -313.74741882946,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 672.97656508366,
        ["y"] = -335.2892782788,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 615.23902071492,
        ["y"] = -363.68601365037,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 625.33605405311,
        ["y"] = -364.18391229301,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Invading Mite",
    ["id"] = 234870,
    ["count"] = 1,
    ["health"] = 18551740,
    ["scale"] = 0.8,
    ["displayId"] = 131382,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [1220890] = {
      },
      [1220891] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 690.42000122741,
        ["y"] = -306.60786666348,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 687.04000282171,
        ["y"] = -350.8316443518,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 679.8660608555,
        ["y"] = -351.07014479679,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 680.07041079171,
        ["y"] = -357.80259943531,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 687.36781921725,
        ["y"] = -357.68697996134,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 673.23161722178,
        ["y"] = -358.23673973655,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 673.23352461287,
        ["y"] = -351.16657920467,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 624.8696462261,
        ["y"] = -341.37140769267,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 632.15703344457,
        ["y"] = -340.57340488413,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 625.82421646808,
        ["y"] = -349.09575489504,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 633.10396097768,
        ["y"] = -347.35656054413,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 609.28532049128,
        ["y"] = -390.01348845545,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 602.64839695852,
        ["y"] = -389.92242018163,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 616.23616483189,
        ["y"] = -389.83267715232,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 605.62079440596,
        ["y"] = -395.69388137649,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 612.8038573723,
        ["y"] = -395.96576818273,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Voracious Gorger",
    ["id"] = 234883,
    ["count"] = 5,
    ["health"] = 111310441,
    ["scale"] = 1.1,
    ["displayId"] = 131385,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [1221130] = {
      },
      [1221152] = {
      },
      [1221174] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 668.29009768351,
        ["y"] = -327.33847296084,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 647.94324910294,
        ["y"] = -370.20138165293,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 614.82547651973,
        ["y"] = -373.59361298428,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 583.34126218459,
        ["y"] = -353.02536288413,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 590.5575098098,
        ["y"] = -358.77175016566,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 594.31068996894,
        ["y"] = -403.06834906456,
        ["g"] = 67,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Ravenous Destroyer",
    ["id"] = 236995,
    ["count"] = 10,
    ["health"] = 148413922,
    ["scale"] = 1.4,
    ["displayId"] = 129837,
    ["creatureType"] = "Aberration",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [1221190] = {
      },
      [1221191] = {
      },
      [1226111] = {
      },
      [1226165] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 644.12389858377,
        ["y"] = -354.55197319728,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 644.12389858377,
            ["y"] = -354.55197319728,
          },
          [2] = {
            ["x"] = 655.29062941131,
            ["y"] = -347.04394301109,
          },
          [3] = {
            ["x"] = 644.12389858377,
            ["y"] = -354.55197319728,
          },
          [4] = {
            ["x"] = 631.22374129852,
            ["y"] = -364.47170040905,
          },
          [5] = {
            ["x"] = 611.92867929762,
            ["y"] = -381.89948024788,
          },
          [6] = {
            ["x"] = 609.23148896553,
            ["y"] = -392.06569824437,
          },
          [7] = {
            ["x"] = 611.92867929762,
            ["y"] = -381.89948024788,
          },
          [8] = {
            ["x"] = 631.22374129852,
            ["y"] = -364.47170040905,
          },
        },
      },
      [2] = {
        ["x"] = 586.20735594954,
        ["y"] = -430.88379932952,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 599.68468235928,
        ["y"] = -431.35432490571,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Overcharged Sentinel",
    ["id"] = 242631,
    ["count"] = 12,
    ["health"] = 148413922,
    ["scale"] = 1.4,
    ["displayId"] = 126549,
    ["creatureType"] = "Mechanical",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [1222202] = {
      },
      [1231224] = {
      },
      [1231234] = {
      },
      [1231244] = {
      },
      [1231252] = {
      },
      [1231328] = {
      },
      [1235368] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 548.35586306859,
        ["y"] = -242.68852701964,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 564.98935378479,
        ["y"] = -376.55375830024,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 594.42996852418,
        ["y"] = -346.6715962456,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 567.85103905677,
        ["y"] = -324.71778945251,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 567.85103905677,
            ["y"] = -324.71778945251,
          },
          [2] = {
            ["x"] = 584.93476829126,
            ["y"] = -323.72632150383,
          },
          [3] = {
            ["x"] = 567.85103905677,
            ["y"] = -324.71778945251,
          },
          [4] = {
            ["x"] = 543.4401326798,
            ["y"] = -327.94059358736,
          },
          [5] = {
            ["x"] = 525.9345032918,
            ["y"] = -338.31427002215,
          },
          [6] = {
            ["x"] = 543.4401326798,
            ["y"] = -327.94059358736,
          },
        },
      },
      [5] = {
        ["x"] = 603.28373733326,
        ["y"] = -298.76200228899,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 603.28373733326,
            ["y"] = -298.76200228899,
          },
          [2] = {
            ["x"] = 606.33048689548,
            ["y"] = -278.66565681998,
          },
          [3] = {
            ["x"] = 603.28373733326,
            ["y"] = -298.76200228899,
          },
          [4] = {
            ["x"] = 590.12162404059,
            ["y"] = -316.27023827909,
          },
        },
      },
    },
  },
  [7] = {
    ["name"] = "Tamed Ruinstalker",
    ["id"] = 234960,
    ["count"] = 5,
    ["health"] = 92758701,
    ["scale"] = 1.1,
    ["displayId"] = 131397,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [1222356] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 560.31184718977,
        ["y"] = -271.59125417096,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 567.5031615046,
        ["y"] = -350.73984797713,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 607.06063058347,
        ["y"] = -327.87021967355,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 613.08661043862,
        ["y"] = -321.15278921679,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 390.98810237015,
        ["y"] = -122.72301362906,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 354.81172706327,
        ["y"] = -181.43117106247,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 352.31375860774,
        ["y"] = -104.58851366977,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 289.07861113028,
        ["y"] = -188.44279822769,
        ["g"] = 41,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 288.35312817834,
            ["y"] = -186.99184017077,
          },
          [2] = {
            ["x"] = 294.70677383684,
            ["y"] = -177.82516650176,
          },
          [3] = {
            ["x"] = 288.35312817834,
            ["y"] = -186.99184017077,
          },
          [4] = {
            ["x"] = 275.46526781582,
            ["y"] = -206.6037337639,
          },
        },
      },
      [9] = {
        ["x"] = 308.74573449223,
        ["y"] = -195.8904789764,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 314.56888854745,
        ["y"] = -204.28241298996,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 584.83413229003,
        ["y"] = -257.36443770459,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 575.86713821804,
        ["y"] = -254.40444073448,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 563.57926302197,
        ["y"] = -238.24143993617,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 522.06816359269,
        ["y"] = -209.75938357332,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Wastelander Farstalker",
    ["id"] = 234962,
    ["count"] = 5,
    ["health"] = 92758701,
    ["scale"] = 1.1,
    ["displayId"] = 123861,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [1221679] = {
      },
      [1222183] = {
      },
      [1229510] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 557.90027378011,
        ["y"] = -350.29812069434,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 534.72814486801,
        ["y"] = -311.28833902755,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 543.27681341654,
        ["y"] = -312.92145462325,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 604.64241679214,
        ["y"] = -318.53576803055,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 608.81747366615,
        ["y"] = -250.00375465578,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 617.96467170567,
        ["y"] = -249.2949948458,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 559.84995076484,
        ["y"] = -207.60783607339,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 555.71423665516,
        ["y"] = -173.75387041676,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 510.15495215347,
        ["y"] = -273.92851818898,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 550.42218381184,
        ["y"] = -281.31311355909,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 589.46480956007,
        ["y"] = -198.16268392145,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 588.5709368147,
        ["y"] = -208.7193260907,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 387.02086242522,
        ["y"] = -130.75658871163,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 361.38811706331,
        ["y"] = -108.14952830042,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 288.12936764347,
        ["y"] = -197.91075956552,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 279.96822522794,
        ["y"] = -192.30505107159,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 304.74497500426,
        ["y"] = -205.18603896887,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 213.6692980296,
        ["y"] = -181.52526441451,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 583.24529685829,
        ["y"] = -247.12068575358,
        ["g"] = 49,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 583.12198343136,
            ["y"] = -246.13401826016,
          },
          [2] = {
            ["x"] = 586.06901481718,
            ["y"] = -236.21011278101,
          },
          [3] = {
            ["x"] = 580.12009227669,
            ["y"] = -224.45735801285,
          },
          [4] = {
            ["x"] = 570.83398268391,
            ["y"] = -219.2339184243,
          },
          [5] = {
            ["x"] = 580.12009227669,
            ["y"] = -224.45735801285,
          },
          [6] = {
            ["x"] = 586.06901481718,
            ["y"] = -236.21011278101,
          },
          [7] = {
            ["x"] = 583.12198343136,
            ["y"] = -246.13401826016,
          },
          [8] = {
            ["x"] = 577.79860018982,
            ["y"] = -264.93905405893,
          },
          [9] = {
            ["x"] = 573.44570247819,
            ["y"] = -275.09575261039,
          },
          [10] = {
            ["x"] = 566.77129698576,
            ["y"] = -275.24085861713,
          },
          [11] = {
            ["x"] = 573.44570247819,
            ["y"] = -275.09575261039,
          },
          [12] = {
            ["x"] = 577.79860018982,
            ["y"] = -264.93905405893,
          },
          [13] = {
            ["x"] = 583.12198343136,
            ["y"] = -246.13401826016,
          },
        },
      },
      [20] = {
        ["x"] = 568.80260844699,
        ["y"] = -231.13176350528,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 534.50287109919,
        ["y"] = -175.16855198496,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Wastelander Phaseblade",
    ["id"] = 234872,
    ["count"] = 4,
    ["health"] = 92758701,
    ["scale"] = 1.1,
    ["displayId"] = 131410,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [1227250] = {
      },
      [1231608] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 532.63817443351,
        ["y"] = -348.55168495529,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 540.74805793198,
        ["y"] = -343.08238863206,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 524.70640844002,
        ["y"] = -331.816050484,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 515.21856995398,
        ["y"] = -334.77941755891,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 535.5057345765,
        ["y"] = -302.32978021133,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 544.59665889488,
        ["y"] = -303.24111389577,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 575.12102751028,
        ["y"] = -303.51435128871,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 584.79062056958,
        ["y"] = -305.2092697334,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 605.09985108182,
        ["y"] = -277.82106240322,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 614.41453701915,
        ["y"] = -277.29853414485,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 608.36253147365,
        ["y"] = -240.70396194535,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 617.83543662109,
        ["y"] = -239.83619570789,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 555.73339579693,
        ["y"] = -215.00777219875,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 565.53585005481,
        ["y"] = -215.40744133865,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 510.57634488589,
        ["y"] = -284.1720581183,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 559.88144659791,
        ["y"] = -281.30507506157,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 598.86917250612,
        ["y"] = -198.992940013,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 598.49730550002,
        ["y"] = -209.20478303405,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 438.08083239214,
        ["y"] = -179.47321777471,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 381.82152731683,
        ["y"] = -123.1708111007,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 362.15060879323,
        ["y"] = -148.66945935177,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 324.8708260596,
        ["y"] = -136.61072763225,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 268.21100636372,
        ["y"] = -132.96527088275,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 188.02350236749,
        ["y"] = -201.48868181238,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 208.21109751351,
        ["y"] = -190.05037332777,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 229.74233422921,
        ["y"] = -216.51752887303,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 199.10182069571,
        ["y"] = -265.2647256369,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 208.6228862858,
        ["y"] = -265.48578299888,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 244.67818806752,
        ["y"] = -238.19868108486,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 235.09996174285,
        ["y"] = -237.70771142557,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 532.67383365344,
        ["y"] = -257.24897714196,
        ["g"] = 51,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 532.67383365344,
            ["y"] = -257.24897714196,
          },
          [2] = {
            ["x"] = 536.15611101855,
            ["y"] = -265.95473333042,
          },
          [3] = {
            ["x"] = 532.67383365344,
            ["y"] = -257.24897714196,
          },
          [4] = {
            ["x"] = 516.56819686756,
            ["y"] = -246.07661501292,
          },
          [5] = {
            ["x"] = 503.07431126381,
            ["y"] = -236.0650224682,
          },
          [6] = {
            ["x"] = 516.56819686756,
            ["y"] = -246.07661501292,
          },
          [7] = {
            ["x"] = 532.67383365344,
            ["y"] = -257.24897714196,
          },
          [8] = {
            ["x"] = 536.15611101855,
            ["y"] = -265.95473333042,
          },
        },
      },
      [32] = {
        ["x"] = 539.05802713238,
        ["y"] = -241.28844636282,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 551.81279198906,
        ["y"] = -181.75590170646,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 560.77431904328,
        ["y"] = -181.48208588568,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 524.65815046136,
        ["y"] = -175.05974677521,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Wastelander Ritualist",
    ["id"] = 234957,
    ["count"] = 7,
    ["health"] = 74206961,
    ["scale"] = 1.3,
    ["displayId"] = 123820,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [1221483] = {
        ["magic"] = true,
      },
      [1221484] = {
      },
      [1222815] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 304.86227585299,
        ["y"] = -163.64208108465,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 608.86695291679,
        ["y"] = -269.04113427954,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 540.5877989399,
        ["y"] = -352.88199301661,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 550.55017208958,
        ["y"] = -271.76508002268,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 392.79336738514,
        ["y"] = -179.29928444362,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 351.44871443192,
        ["y"] = -151.47891080946,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 315.14311890344,
        ["y"] = -146.5319672681,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 345.70263788905,
        ["y"] = -192.23039988055,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 360.47860634007,
        ["y"] = -99.444142792589,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 273.96235165962,
        ["y"] = -140.60802281638,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 178.48036243969,
        ["y"] = -202.5697555068,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 231.49887889476,
        ["y"] = -206.91870402377,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 525.99942816101,
        ["y"] = -263.19789183549,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 545.44225199918,
        ["y"] = -233.01800034762,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 539.61749060336,
        ["y"] = -193.9874725532,
        ["g"] = 63,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 536.28754784231,
            ["y"] = -194.23413942656,
          },
          [2] = {
            ["x"] = 551.81279198906,
            ["y"] = -189.44597077647,
          },
          [3] = {
            ["x"] = 536.28754784231,
            ["y"] = -194.23413942656,
          },
          [4] = {
            ["x"] = 526.27593960367,
            ["y"] = -204.82610891648,
          },
        },
      },
    },
  },
  [11] = {
    ["name"] = "Wastelander Pactspeaker",
    ["id"] = 234955,
    ["count"] = 18,
    ["health"] = 148413922,
    ["scale"] = 1.2,
    ["displayId"] = 123884,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [1221532] = {
      },
      [1221533] = {
      },
      [1222815] = {
        ["interruptible"] = true,
      },
      [1226492] = {
      },
      [1248699] = {
      },
      [1248701] = {
      },
      [1248702] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 433.38360791171,
        ["y"] = -188.83284261318,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 405.88495980417,
        ["y"] = -137.4655267478,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 408.15415221573,
            ["y"] = -137.78969208319,
          },
          [2] = {
            ["x"] = 420.30038225128,
            ["y"] = -143.25724489678,
          },
          [3] = {
            ["x"] = 408.15415221573,
            ["y"] = -137.78969208319,
          },
          [4] = {
            ["x"] = 387.23429080687,
            ["y"] = -137.42202341283,
          },
          [5] = {
            ["x"] = 372.97049009201,
            ["y"] = -135.47699633665,
          },
          [6] = {
            ["x"] = 363.56930966338,
            ["y"] = -138.07038914745,
          },
          [7] = {
            ["x"] = 372.97049009201,
            ["y"] = -135.47699633665,
          },
          [8] = {
            ["x"] = 387.23429080687,
            ["y"] = -137.42202341283,
          },
        },
      },
      [3] = {
        ["x"] = 355.87311722698,
        ["y"] = -192.41922412846,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 297.04975414319,
        ["y"] = -171.93423657243,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 217.77498307714,
        ["y"] = -190.38977161076,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 182.49943414886,
        ["y"] = -211.14428229324,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = " K'aresh Elemental",
    ["id"] = 235151,
    ["count"] = 6,
    ["health"] = 83482831,
    ["scale"] = 1.1,
    ["displayId"] = 129736,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [1223000] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 392.57536298465,
        ["y"] = -169.45339721034,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 360.71473275501,
        ["y"] = -158.00550989866,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 325.58220245653,
        ["y"] = -157.01495491996,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 335.1215288402,
        ["y"] = -146.79663375008,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 345.36381620692,
        ["y"] = -182.356474163,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 264.5295594725,
        ["y"] = -141.5247592926,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 306.4100564276,
        ["y"] = -173.53500603396,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 238.95633687604,
        ["y"] = -213.2896480714,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Wastes Creeper",
    ["id"] = 234918,
    ["count"] = 9,
    ["health"] = 120586312,
    ["scale"] = 1,
    ["displayId"] = 131441,
    ["creatureType"] = "Aberration",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [1222341] = {
      },
      [1223007] = {
      },
      [1223008] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 416.16962036517,
        ["y"] = -123.33518366327,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 323.39756635556,
        ["y"] = -190.57780767286,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 327.77712489829,
        ["y"] = -98.0063812606,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 303.56114645241,
        ["y"] = -104.62234046703,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 305.50863613895,
        ["y"] = -115.29217282139,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 193.6123498795,
        ["y"] = -285.41015495278,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 209.11892729004,
        ["y"] = -284.58454382097,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 251.65655779729,
        ["y"] = -265.46866702373,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 272.76852354389,
        ["y"] = -211.52323291078,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Burrowing Creeper",
    ["id"] = 245092,
    ["count"] = 25,
    ["health"] = 240627131,
    ["scale"] = 1.5,
    ["displayId"] = 131449,
    ["creatureType"] = "Beast",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["clones"] = {
      [1] = {
        ["x"] = 229.90777985074,
        ["y"] = -258.40795524768,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 228.92112305271,
            ["y"] = -257.02663146168,
          },
          [2] = {
            ["x"] = 241.35223188346,
            ["y"] = -256.00581225156,
          },
          [3] = {
            ["x"] = 261.87457375763,
            ["y"] = -254.03251999923,
          },
          [4] = {
            ["x"] = 274.70102675712,
            ["y"] = -252.45388406299,
          },
          [5] = {
            ["x"] = 261.87457375763,
            ["y"] = -254.03251999923,
          },
          [6] = {
            ["x"] = 241.35223188346,
            ["y"] = -256.00581225156,
          },
          [7] = {
            ["x"] = 228.92112305271,
            ["y"] = -257.02663146168,
          },
          [8] = {
            ["x"] = 199.32090200896,
            ["y"] = -254.03251999923,
          },
          [9] = {
            ["x"] = 185.31046938932,
            ["y"] = -249.69125783474,
          },
          [10] = {
            ["x"] = 195.17696266658,
            ["y"] = -253.24321803891,
          },
        },
      },
      [2] = {
        ["x"] = 328.76995022686,
        ["y"] = -213.56952253702,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 328.76995022686,
            ["y"] = -213.56952253702,
          },
          [2] = {
            ["x"] = 313.13031679414,
            ["y"] = -219.46002596147,
          },
          [3] = {
            ["x"] = 302.07983322487,
            ["y"] = -218.27604634133,
          },
          [4] = {
            ["x"] = 288.46404624946,
            ["y"] = -214.921430303,
          },
          [5] = {
            ["x"] = 302.07983322487,
            ["y"] = -218.27604634133,
          },
          [6] = {
            ["x"] = 313.13031679414,
            ["y"] = -219.46002596147,
          },
          [7] = {
            ["x"] = 328.76995022686,
            ["y"] = -213.56952253702,
          },
          [8] = {
            ["x"] = 338.9805883027,
            ["y"] = -209.79082349073,
          },
          [9] = {
            ["x"] = 349.4390820619,
            ["y"] = -202.8842899357,
          },
          [10] = {
            ["x"] = 338.9805883027,
            ["y"] = -209.79082349073,
          },
        },
      },
      [3] = {
        ["x"] = 296.19271466647,
        ["y"] = -133.79037773561,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 296.19271466647,
            ["y"] = -133.79037773561,
          },
          [2] = {
            ["x"] = 287.82288077863,
            ["y"] = -147.29269660923,
          },
          [3] = {
            ["x"] = 279.71843181926,
            ["y"] = -168.04004947881,
          },
          [4] = {
            ["x"] = 287.82288077863,
            ["y"] = -147.29269660923,
          },
          [5] = {
            ["x"] = 296.19271466647,
            ["y"] = -133.79037773561,
          },
          [6] = {
            ["x"] = 313.10868859906,
            ["y"] = -123.62778559345,
          },
          [7] = {
            ["x"] = 329.64175185319,
            ["y"] = -121.68268838956,
          },
          [8] = {
            ["x"] = 341.63632509263,
            ["y"] = -110.01228048551,
          },
          [9] = {
            ["x"] = 367.89466398307,
            ["y"] = -101.90783152614,
          },
          [10] = {
            ["x"] = 384.75192763644,
            ["y"] = -98.341907645312,
          },
          [11] = {
            ["x"] = 414.57622547156,
            ["y"] = -91.534225219052,
          },
          [12] = {
            ["x"] = 384.75192763644,
            ["y"] = -98.341907645312,
          },
          [13] = {
            ["x"] = 367.89466398307,
            ["y"] = -101.90783152614,
          },
          [14] = {
            ["x"] = 341.63632509263,
            ["y"] = -110.01228048551,
          },
          [15] = {
            ["x"] = 329.64175185319,
            ["y"] = -121.68268838956,
          },
          [16] = {
            ["x"] = 313.10868859906,
            ["y"] = -123.62778559345,
          },
        },
      },
    },
  },
  [15] = {
    ["name"] = "Azhiccar",
    ["id"] = 234893,
    ["count"] = 0,
    ["health"] = 584668560,
    ["scale"] = 2,
    ["displayId"] = 131246,
    ["creatureType"] = "Aberration",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2675,
    ["instanceID"] = 1303,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [1217232] = {
      },
      [1217247] = {
      },
      [1217316] = {
      },
      [1217327] = {
      },
      [1217439] = {
      },
      [1217446] = {
      },
      [1217664] = {
      },
      [1227745] = {
      },
      [1231850] = {
      },
      [1233112] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 535.11001577445,
        ["y"] = -420.41961742206,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Taah'bat",
    ["id"] = 234933,
    ["count"] = 0,
    ["health"] = 649631734,
    ["scale"] = 1.5,
    ["displayId"] = 123825,
    ["creatureType"] = "Humanoid",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2675,
    ["instanceID"] = 1303,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [1219417] = {
      },
      [1219457] = {
      },
      [1220497] = {
      },
      [1220511] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 495.81857055565,
        ["y"] = -206.39188452891,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Soul-Scribe",
    ["id"] = 234935,
    ["count"] = 0,
    ["health"] = 779558080,
    ["scale"] = 2,
    ["displayId"] = 128654,
    ["creatureType"] = "Humanoid",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2675,
    ["instanceID"] = 1303,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [1224793] = {
      },
      [1224868] = {
      },
      [1225162] = {
      },
      [1225174] = {
      },
      [1225179] = {
      },
      [1225218] = {
      },
      [1225221] = {
      },
      [1225308] = {
      },
      [1236703] = {
      },
      [1236910] = {
      },
      [1239691] = {
      },
      [1242000] = {
      },
      [1242006] = {
      },
      [1249985] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 184.69933710096,
        ["y"] = -171.00898181405,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Frenzied Mite",
    ["id"] = 236190,
    ["count"] = 0,
    ["health"] = 7729892,
    ["scale"] = 1.5,
    ["displayId"] = 130695,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [1217381] = {
      },
      [1217383] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 530.20651380713,
        ["y"] = -448.05011966743,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 545.15800341542,
        ["y"] = -449.56805516606,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 555.56398395826,
        ["y"] = -437.60472800038,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 519.14847244123,
        ["y"] = -439.37838658923,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "A'wazj",
    ["id"] = 237514,
    ["count"] = 0,
    ["health"] = 649631734,
    ["scale"] = 1.5,
    ["displayId"] = 126474,
    ["creatureType"] = "Beast",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2675,
    ["instanceID"] = 1303,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [1219417] = {
      },
      [1219482] = {
      },
      [1219535] = {
        ["bleed"] = true,
      },
      [1219536] = {
      },
      [1219700] = {
      },
      [1219704] = {
      },
      [1220390] = {
      },
      [1227152] = {
      },
      [1227918] = {
      },
      [1236126] = {
      },
      [1236130] = {
      },
      [1239281] = {
      },
      [1239487] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 479.66936760035,
        ["y"] = -232.77954982757,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Binding Javelin",
    ["id"] = 244302,
    ["count"] = 0,
    ["health"] = 15459785,
    ["scale"] = 1.2,
    ["displayId"] = 131370,
    ["creatureType"] = "Not specified",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [1220671] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 495.76108029888,
        ["y"] = -226.4685302462,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
    },
  },
};
