local addonName = ...
local MDT = MDT
local L = MDT.L
local dungeonIndex = 30
MDT.dungeonList[dungeonIndex] = L["Halls of Atonement"]
MDT.mapInfo[dungeonIndex] = {
  teleportId = 354465,
  shortName = L["hallsOfAtonementShortName"],
  englishName = "Halls of Atonement",
  mapID = 378
};

local zones = { 1663, 1664, 1665 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "",
  [1] = { customTextures = 'Interface\\AddOns\\'..addonName..'\\TheWarWithin\\Textures\\HallsOfAtonement' }
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["Halls of Atonement"],
}
MDT.dungeonTotalCount[dungeonIndex] = { normal = 466 }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "textFrame",
      ["x"] = 357.68710131642,
      ["y"] = -253.2025611896,
      ["text"] = "",
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Depraved Darkblade",
    ["id"] = 165515,
    ["count"] = 4,
    ["health"] = 92758701,
    ["scale"] = 1.4,
    ["displayId"] = 93032,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [1235060] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 778.34661977269,
        ["y"] = -301.73734226974,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 777.44327520221,
        ["y"] = -315.79341293396,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 591.61337158768,
        ["y"] = -321.21340810395,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 669.63967465025,
        ["y"] = -220.52630880807,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 674.17486263767,
        ["y"] = -274.52646150458,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 540.38210582482,
        ["y"] = -208.30105617554,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 358.73204714125,
        ["y"] = -236.31815663476,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 594.14027777462,
        ["y"] = -404.9280799763,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 400.37566496252,
        ["y"] = -381.38572570136,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 491.89356082356,
        ["y"] = -378.925644205,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 337.39707629898,
        ["y"] = -343.50171816461,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 683.62817874975,
        ["y"] = -265.28747326384,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 633.26206883089,
        ["y"] = -132.50977318217,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 708.97238439459,
        ["y"] = -383.33150448085,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 623.22144148942,
        ["y"] = -139.77588695182,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Depraved Houndmaster",
    ["id"] = 164562,
    ["count"] = 5,
    ["health"] = 83482831,
    ["scale"] = 1.4,
    ["displayId"] = 97001,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [325535] = {
      },
      [326450] = {
        ["interruptible"] = true,
        ["enrage"] = true,
      },
      [329299] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 748.90397574844,
        ["y"] = -314.36115382238,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 748.90397574844,
            ["y"] = -314.36115382238,
          },
          [2] = {
            ["x"] = 702.76637665524,
            ["y"] = -236.63814024877,
          },
          [3] = {
            ["x"] = 748.90397574844,
            ["y"] = -314.36115382238,
          },
          [4] = {
            ["x"] = 715.76476286546,
            ["y"] = -367.12175249834,
          },
        },
      },
      [2] = {
        ["x"] = 642.12948338989,
        ["y"] = -315.70184074838,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 627.12290464396,
        ["y"] = -202.11239407478,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 654.5776368751,
        ["y"] = -168.61842497655,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 654.5776368751,
            ["y"] = -168.61842497655,
          },
          [2] = {
            ["x"] = 680.76925955296,
            ["y"] = -198.14295854263,
          },
          [3] = {
            ["x"] = 654.5776368751,
            ["y"] = -168.61842497655,
          },
          [4] = {
            ["x"] = 634.77495757233,
            ["y"] = -146.64939062626,
          },
          [5] = {
            ["x"] = 654.5776368751,
            ["y"] = -168.61842497655,
          },
        },
      },
      [5] = {
        ["x"] = 586.81861914227,
        ["y"] = -232.08454757204,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 586.81861914227,
            ["y"] = -232.08454757204,
          },
          [2] = {
            ["x"] = 545.28613151502,
            ["y"] = -252.13622432393,
          },
          [3] = {
            ["x"] = 586.81861914227,
            ["y"] = -232.08454757204,
          },
          [4] = {
            ["x"] = 643.27387161787,
            ["y"] = -246.13692810434,
          },
          [5] = {
            ["x"] = 586.81861914227,
            ["y"] = -232.08454757204,
          },
        },
      },
      [6] = {
        ["x"] = 573.96682573244,
        ["y"] = -372.36913537777,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 573.96682573244,
            ["y"] = -372.36913537777,
          },
          [2] = {
            ["x"] = 604.27865962787,
            ["y"] = -382.61980989384,
          },
          [3] = {
            ["x"] = 638.27452924732,
            ["y"] = -371.6211713037,
          },
          [4] = {
            ["x"] = 604.27865962787,
            ["y"] = -382.61980989384,
          },
          [5] = {
            ["x"] = 573.96682573244,
            ["y"] = -372.36913537777,
          },
          [6] = {
            ["x"] = 548.28583298414,
            ["y"] = -360.12264916787,
          },
          [7] = {
            ["x"] = 573.96682573244,
            ["y"] = -372.36913537777,
          },
        },
      },
      [7] = {
        ["x"] = 632.56927438659,
        ["y"] = -411.24119978935,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 632.56927438659,
            ["y"] = -411.24119978935,
          },
          [2] = {
            ["x"] = 646.77348150291,
            ["y"] = -403.11724928074,
          },
          [3] = {
            ["x"] = 632.56927438659,
            ["y"] = -411.24119978935,
          },
          [4] = {
            ["x"] = 601.2791564468,
            ["y"] = -433.11349026169,
          },
          [5] = {
            ["x"] = 632.56927438659,
            ["y"] = -411.24119978935,
          },
        },
      },
      [9] = {
        ["x"] = 592.22095789045,
        ["y"] = -308.87832826458,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 99.792428458794,
        ["y"] = -489.07458259825,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 112.02485977467,
        ["y"] = -488.71749430092,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Vicious Gargon",
    ["id"] = 164563,
    ["count"] = 4,
    ["health"] = 102034571,
    ["scale"] = 1.4,
    ["displayId"] = 93163,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [1235070] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 741.78211335136,
        ["y"] = -303.81048103476,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 755.04148413422,
        ["y"] = -303.06212318014,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 653.20897016779,
        ["y"] = -316.29985923008,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 652.94595519982,
        ["y"] = -303.15275776381,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 653.65365990802,
        ["y"] = -155.5562740942,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 642.5333618547,
        ["y"] = -163.71452682027,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 632.77373625524,
        ["y"] = -190.0869911245,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 620.66348871554,
        ["y"] = -190.89218733194,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 597.57733473128,
        ["y"] = -226.16975317461,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 597.05863864612,
        ["y"] = -240.35963803342,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 580.60147134355,
        ["y"] = -383.83705489863,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 587.00174886415,
        ["y"] = -371.41526008619,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 627.58256228516,
        ["y"] = -422.79860588375,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 620.04817600694,
        ["y"] = -412.50312201317,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 581.79222949295,
        ["y"] = -302.69969140376,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 582.08685004359,
        ["y"] = -314.44755982735,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 118.62173470908,
        ["y"] = -500.43198784135,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 93.786162097721,
        ["y"] = -499.71781124668,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 106.51877891498,
        ["y"] = -500.25344369268,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Depraved Obliterator",
    ["id"] = 165414,
    ["count"] = 5,
    ["health"] = 88120767,
    ["scale"] = 1.4,
    ["displayId"] = 93680,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [325876] = {
        ["magic"] = true,
      },
      [325879] = {
      },
      [338003] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 592.51575043511,
        ["y"] = -298.38967507309,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 671.3619357745,
        ["y"] = -262.15164390959,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 696.168735243,
        ["y"] = -316.23537080844,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 678.21534684524,
        ["y"] = -230.80061006907,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 530.57975096278,
        ["y"] = -215.52215963812,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 617.39650577714,
        ["y"] = -459.7668927246,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 626.40005482502,
        ["y"] = -468.22990319075,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 587.27882960843,
        ["y"] = -414.78395057398,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 699.24940955231,
        ["y"] = -376.0938336664,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 411.6354279247,
        ["y"] = -381.89564910021,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 483.56167438818,
        ["y"] = -369.45671906058,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 337.42569844132,
        ["y"] = -333.30352657428,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 641.63032491816,
        ["y"] = -303.3389110029,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 389.52968031721,
        ["y"] = -381.72100025627,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 401.49862729199,
        ["y"] = -309.08873947336,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 437.08834761989,
        ["y"] = -275.30541593945,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 358.69162747048,
        ["y"] = -248.94904934727,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 116.76741950512,
        ["y"] = -386.44243434201,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 696.16673460604,
        ["y"] = -304.51887069796,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 437.22044747661,
        ["y"] = -262.01841140238,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 498.71909439815,
        ["y"] = -258.42239805626,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 502.9693314342,
        ["y"] = -269.71201450269,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Toiling Groundskeeper",
    ["id"] = 165415,
    ["count"] = 2,
    ["health"] = 55655221,
    ["scale"] = 0.9,
    ["displayId"] = 93814,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [1235121] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 705.42636594496,
        ["y"] = -183.81320525194,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 698.4158224458,
        ["y"] = -188.44117275128,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 711.46847590698,
        ["y"] = -178.97375331989,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 717.48909667585,
        ["y"] = -174.47662762362,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 677.66117854148,
        ["y"] = -183.57935409658,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 677.66117854148,
            ["y"] = -183.57935409658,
          },
          [2] = {
            ["x"] = 691.41862868801,
            ["y"] = -201.75300623645,
          },
          [3] = {
            ["x"] = 715.1599303132,
            ["y"] = -190.34484744644,
          },
          [4] = {
            ["x"] = 691.41862868801,
            ["y"] = -201.75300623645,
          },
          [5] = {
            ["x"] = 677.66117854148,
            ["y"] = -183.57935409658,
          },
          [6] = {
            ["x"] = 662.74418998726,
            ["y"] = -173.69511795879,
          },
          [7] = {
            ["x"] = 642.3944742946,
            ["y"] = -149.33718253656,
          },
          [8] = {
            ["x"] = 633.76126764006,
            ["y"] = -141.01232613013,
          },
          [9] = {
            ["x"] = 612.17825100372,
            ["y"] = -117.27105785453,
          },
          [10] = {
            ["x"] = 607.55339747709,
            ["y"] = -94.146423375973,
          },
          [11] = {
            ["x"] = 601.07850916098,
            ["y"] = -79.963312450484,
          },
          [12] = {
            ["x"] = 607.55339747709,
            ["y"] = -94.146423375973,
          },
          [13] = {
            ["x"] = 612.17825100372,
            ["y"] = -117.27105785453,
          },
          [14] = {
            ["x"] = 633.76126764006,
            ["y"] = -141.01232613013,
          },
          [15] = {
            ["x"] = 642.3944742946,
            ["y"] = -149.33718253656,
          },
          [16] = {
            ["x"] = 662.74418998726,
            ["y"] = -173.69511795879,
          },
        },
      },
      [6] = {
        ["x"] = 606.59888668619,
        ["y"] = -72.688103477047,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 598.77186256138,
        ["y"] = -72.78000013031,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 614.33070904678,
        ["y"] = -72.895984104218,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 591.35378890326,
        ["y"] = -72.861997179898,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 607.29215250751,
        ["y"] = -177.62457850997,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 602.2012940281,
        ["y"] = -185.19003149349,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 598.4121677299,
        ["y"] = -176.94941493392,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 589.45658866395,
        ["y"] = -176.47396851092,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 593.13894126534,
        ["y"] = -184.87938489361,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 644.88352116469,
        ["y"] = -450.49390134093,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 644.88352116469,
            ["y"] = -450.49390134093,
          },
          [2] = {
            ["x"] = 634.82472973613,
            ["y"] = -429.54590146547,
          },
          [3] = {
            ["x"] = 620.94996905875,
            ["y"] = -400.25469556933,
          },
          [4] = {
            ["x"] = 612.62501260357,
            ["y"] = -382.98833228463,
          },
          [5] = {
            ["x"] = 592.27539695967,
            ["y"] = -388.84655345411,
          },
          [6] = {
            ["x"] = 576.5506014928,
            ["y"] = -401.79636343592,
          },
          [7] = {
            ["x"] = 564.52580890574,
            ["y"] = -412.27952150598,
          },
          [8] = {
            ["x"] = 576.5506014928,
            ["y"] = -401.79636343592,
          },
          [9] = {
            ["x"] = 592.27539695967,
            ["y"] = -388.84655345411,
          },
          [10] = {
            ["x"] = 612.62501260357,
            ["y"] = -382.98833228463,
          },
          [11] = {
            ["x"] = 620.64161881064,
            ["y"] = -399.94637867081,
          },
          [12] = {
            ["x"] = 634.82472973613,
            ["y"] = -429.54590146547,
          },
          [13] = {
            ["x"] = 644.88352116469,
            ["y"] = -450.49390134093,
          },
        },
      },
      [16] = {
        ["x"] = 558.66848970104,
        ["y"] = -413.57389975149,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 662.94325570624,
        ["y"] = -451.15964865838,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 656.24713887905,
        ["y"] = -456.24736189644,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 652.44483885229,
        ["y"] = -460.10305622556,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 646.93735413007,
        ["y"] = -464.05824644902,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 563.57253626385,
        ["y"] = -418.87315676195,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 569.43633106999,
        ["y"] = -424.66279518105,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 552.62113079732,
        ["y"] = -407.799675241,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 712.40332638626,
        ["y"] = -421.71623994024,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 707.08515636723,
        ["y"] = -427.79662200626,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 701.07899526361,
        ["y"] = -432.4498465812,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 719.35106710112,
        ["y"] = -416.47891928957,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 428.14676268352,
        ["y"] = -204.38104119701,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 453.6743819088,
        ["y"] = -203.79597931593,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 445.43268640257,
        ["y"] = -204.48995489837,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 437.09616095967,
        ["y"] = -204.45292896233,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 368.34843992677,
        ["y"] = -206.10972848526,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 360.08019482893,
        ["y"] = -206.03852019924,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 377.12482425635,
        ["y"] = -205.44275772398,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 352.12167183613,
        ["y"] = -206.33359339918,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 415.933498671,
        ["y"] = -397.06640480412,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 423.34994577163,
        ["y"] = -396.62130343771,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 430.19221838834,
        ["y"] = -396.08756047608,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 437.30569374125,
        ["y"] = -395.77843785668,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 361.87205318024,
        ["y"] = -395.88095663331,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 369.02627186542,
        ["y"] = -395.92205274299,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 376.31826065571,
        ["y"] = -395.76847934576,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [43] = {
        ["x"] = 383.18540632296,
        ["y"] = -395.64836313748,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Depraved Collector",
    ["id"] = 165529,
    ["count"] = 5,
    ["health"] = 92758701,
    ["scale"] = 1.4,
    ["displayId"] = 94573,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [325701] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 605.51195287759,
        ["y"] = -108.11925771523,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 607.33537361338,
        ["y"] = -476.23150559051,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 692.30107053675,
        ["y"] = -399.49039511361,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 95.714137777502,
        ["y"] = -387.14037025533,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 547.46950201252,
        ["y"] = -300.00962589636,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 551.78712110317,
        ["y"] = -312.7352815458,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 545.19707346526,
        ["y"] = -324.77925956497,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Shard of Halkias",
    ["id"] = 164557,
    ["count"] = 15,
    ["health"] = 222620883,
    ["scale"] = 2,
    ["displayId"] = 94868,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [325509] = {
      },
      [326409] = {
      },
      [326426] = {
      },
      [326438] = {
      },
      [326440] = {
      },
      [326441] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 594.75226858365,
        ["y"] = -95.720886752804,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 596.66139646301,
        ["y"] = -485.89157070572,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 682.40903834308,
        ["y"] = -408.96327023294,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Halkias",
    ["id"] = 165408,
    ["count"] = 0,
    ["health"] = 649631734,
    ["scale"] = 1.6,
    ["displayId"] = 98764,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2406,
    ["instanceID"] = 1185,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [322711] = {
      },
      [322936] = {
      },
      [322943] = {
      },
      [322945] = {
      },
      [323001] = {
      },
      [339235] = {
      },
      [339237] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 531.29083445854,
        ["y"] = -309.24896174494,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Stoneborn Reaver",
    ["id"] = 167612,
    ["count"] = 8,
    ["health"] = 148413922,
    ["scale"] = 1.4,
    ["displayId"] = 93829,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [1235762] = {
        ["magic"] = true,
      },
      [1235766] = {
      },
    },
    ["clones"] = {
      [2] = {
        ["x"] = 485.58503630337,
        ["y"] = -203.87180114522,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 413.66147595138,
        ["y"] = -309.900030347,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 496.3528806235,
        ["y"] = -347.10462707432,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 434.78056818527,
        ["y"] = -343.08958253813,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 435.41266395114,
        ["y"] = -356.56919269395,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 496.27952656108,
        ["y"] = -212.55237697893,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 105.3626872251,
        ["y"] = -534.45296719259,
        ["g"] = 67,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Stonefiend Anklebiter",
    ["id"] = 167610,
    ["count"] = 1,
    ["health"] = 27827610,
    ["scale"] = 0.8,
    ["displayId"] = 94765,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [326879] = {
      },
      [1235245] = {
        ["bleed"] = true,
      },
    },
    ["clones"] = {
      [10] = {
        ["x"] = 459.8528708445,
        ["y"] = -340.96518344751,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 466.68721172226,
        ["y"] = -348.0324329122,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 464.716603193,
        ["y"] = -353.00258136556,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 459.50200631928,
        ["y"] = -354.85707747859,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 459.82637740839,
        ["y"] = -348.05382854922,
        ["g"] = 58,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 458.70710790681,
            ["y"] = -346.49922945061,
          },
          [2] = {
            ["x"] = 453.5151396046,
            ["y"] = -340.02297537735,
          },
          [3] = {
            ["x"] = 445.19026652338,
            ["y"] = -333.54807038645,
          },
          [4] = {
            ["x"] = 434.09044130668,
            ["y"] = -326.14819802518,
          },
          [5] = {
            ["x"] = 424.22395038325,
            ["y"] = -325.83989780144,
          },
          [6] = {
            ["x"] = 405.10758565865,
            ["y"] = -334.16472085829,
          },
          [7] = {
            ["x"] = 399.24934781438,
            ["y"] = -346.18954679493,
          },
          [8] = {
            ["x"] = 400.17431518475,
            ["y"] = -355.74772081984,
          },
          [9] = {
            ["x"] = 399.24934781438,
            ["y"] = -346.18954679493,
          },
          [10] = {
            ["x"] = 405.10758565865,
            ["y"] = -334.16472085829,
          },
          [11] = {
            ["x"] = 424.22395038325,
            ["y"] = -325.83989780144,
          },
          [12] = {
            ["x"] = 434.09044130668,
            ["y"] = -326.14819802518,
          },
          [13] = {
            ["x"] = 445.19026652338,
            ["y"] = -333.54807038645,
          },
          [14] = {
            ["x"] = 453.5151396046,
            ["y"] = -340.02297537735,
          },
          [15] = {
            ["x"] = 458.70710790681,
            ["y"] = -346.49922945061,
          },
        },
      },
      [15] = {
        ["x"] = 464.7737896075,
        ["y"] = -342.85517831103,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 455.24801403701,
        ["y"] = -343.14823504444,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 452.97872281241,
        ["y"] = -347.77443077532,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 454.4888223697,
        ["y"] = -352.46334247127,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 347.52869221559,
        ["y"] = -284.05758567419,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 347.17230068865,
        ["y"] = -290.79911014503,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 347.1908706522,
        ["y"] = -264.99917601327,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 347.24391852089,
        ["y"] = -279.12984628525,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 347.26252565426,
        ["y"] = -272.03198975917,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 483.00254849795,
        ["y"] = -216.04006452673,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 488.34282579973,
        ["y"] = -220.99434131202,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 494.11116561227,
        ["y"] = -226.510042887,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 477.24124027044,
        ["y"] = -211.05065790014,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 471.62730625783,
        ["y"] = -205.61216220267,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 450.09756878986,
        ["y"] = -244.0748673151,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 454.54331017327,
        ["y"] = -239.73634427999,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 455.81073784269,
        ["y"] = -233.20417318638,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 451.58924681041,
        ["y"] = -227.56896865859,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 402.61597456294,
        ["y"] = -246.74892998259,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 402.18983118631,
        ["y"] = -251.75202244197,
        ["g"] = 63,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 402.18983118631,
            ["y"] = -251.75202244197,
          },
          [2] = {
            ["x"] = 397.35870084115,
            ["y"] = -259.34286936694,
          },
          [3] = {
            ["x"] = 395.8787263689,
            ["y"] = -266.37275478007,
          },
          [4] = {
            ["x"] = 396.00205312831,
            ["y"] = -274.88261466544,
          },
          [5] = {
            ["x"] = 397.97534797803,
            ["y"] = -282.89914750343,
          },
          [6] = {
            ["x"] = 405.7452272972,
            ["y"] = -289.31237910975,
          },
          [7] = {
            ["x"] = 418.44836375044,
            ["y"] = -293.62898243702,
          },
          [8] = {
            ["x"] = 431.15150020367,
            ["y"] = -294.86229005062,
          },
          [9] = {
            ["x"] = 440.89466103273,
            ["y"] = -289.18904568043,
          },
          [10] = {
            ["x"] = 446.93789902099,
            ["y"] = -279.69253837019,
          },
          [11] = {
            ["x"] = 450.39118168281,
            ["y"] = -266.98940858687,
          },
          [12] = {
            ["x"] = 446.07457168562,
            ["y"] = -256.01291346454,
          },
          [13] = {
            ["x"] = 438.05803884763,
            ["y"] = -247.37973348967,
          },
          [14] = {
            ["x"] = 427.20488382455,
            ["y"] = -244.41978454516,
          },
          [15] = {
            ["x"] = 410.80182453051,
            ["y"] = -245.89974567758,
          },
          [16] = {
            ["x"] = 402.18983118631,
            ["y"] = -251.75202244197,
          },
        },
      },
      [35] = {
        ["x"] = 396.71449050742,
        ["y"] = -251.72440471787,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 402.18546441321,
        ["y"] = -257.1080815946,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 408.57464813075,
        ["y"] = -252.01816861749,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 489.98746063236,
        ["y"] = -339.09801715122,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 486.47642730357,
        ["y"] = -345.26459717515,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 487.58043410225,
        ["y"] = -352.52520492648,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 492.71262092466,
        ["y"] = -357.04074020125,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 499.99316315111,
        ["y"] = -356.56333766457,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [43] = {
        ["x"] = 496.93969231654,
        ["y"] = -337.05908811624,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [44] = {
        ["x"] = 503.11624388121,
        ["y"] = -339.66491158183,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Stoneborn Eviscerator",
    ["id"] = 167611,
    ["count"] = 6,
    ["health"] = 92758701,
    ["scale"] = 1.4,
    ["displayId"] = 94724,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [326638] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 338.61933659448,
        ["y"] = -286.43201070975,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 338.64978798384,
        ["y"] = -272.81997959888,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 403.65870959911,
        ["y"] = -321.28525360708,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 403.01383309824,
        ["y"] = -295.7097689911,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 328.34939152954,
        ["y"] = -278.66737306282,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 488.34486131982,
        ["y"] = -261.87396627148,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 491.77304136516,
        ["y"] = -273.88589046296,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 445.6907500879,
        ["y"] = -235.31005624696,
        ["g"] = 62,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 445.6907500879,
            ["y"] = -235.31005624696,
          },
          [2] = {
            ["x"] = 467.32085544453,
            ["y"] = -228.93763094616,
          },
          [3] = {
            ["x"] = 478.42068257077,
            ["y"] = -219.42350974388,
          },
          [4] = {
            ["x"] = 467.32085544453,
            ["y"] = -228.93763094616,
          },
          [5] = {
            ["x"] = 445.6907500879,
            ["y"] = -235.31005624696,
          },
          [6] = {
            ["x"] = 421.15969805207,
            ["y"] = -239.33270517756,
          },
          [7] = {
            ["x"] = 403.36477083135,
            ["y"] = -235.632759626,
          },
          [8] = {
            ["x"] = 421.15969805207,
            ["y"] = -239.33270517756,
          },
        },
      },
      [11] = {
        ["x"] = 424.88026682813,
        ["y"] = -275.38842119184,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 424.29857142017,
        ["y"] = -261.52197029773,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 112.85643145583,
        ["y"] = -523.33660159384,
        ["g"] = 67,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 99.569705020146,
        ["y"] = -523.10653248784,
        ["g"] = 67,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Stoneborn Slasher",
    ["id"] = 167607,
    ["count"] = 15,
    ["health"] = 185517402,
    ["scale"] = 1.7,
    ["displayId"] = 95706,
    ["creatureType"] = "Humanoid",
    ["stealthDetect"] = true,
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [326997] = {
      },
      [1235326] = {
      },
      [1235808] = {
      },
      [1235809] = {
      },
      [1237071] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 363.71373560339,
        ["y"] = -302.75187585424,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 363.58483403233,
        ["y"] = -321.70281211349,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 716.39037511323,
        ["y"] = -216.38619426619,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 687.21673216384,
        ["y"] = -358.33602969558,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 541.96087398827,
        ["y"] = -385.67152510718,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 616.97064653877,
        ["y"] = -309.49359720866,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 561.60836549246,
        ["y"] = -209.2379984889,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 406.14678070507,
        ["y"] = -223.2109476862,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 141.18354537988,
        ["y"] = -396.66109132387,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 71.720675455968,
        ["y"] = -397.25452613641,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Echelon",
    ["id"] = 164185,
    ["count"] = 0,
    ["health"] = 556827200,
    ["scale"] = 1.8,
    ["displayId"] = 96260,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2387,
    ["instanceID"] = 1185,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [319592] = {
      },
      [319603] = {
      },
      [319702] = {
      },
      [319703] = {
      },
      [319733] = {
      },
      [319941] = {
      },
      [326389] = {
      },
      [328206] = {
      },
      [344874] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 282.5627831144,
        ["y"] = -310.63473917066,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "High Adjudicator Aleez",
    ["id"] = 165410,
    ["count"] = 0,
    ["health"] = 649631734,
    ["scale"] = 1.5,
    ["displayId"] = 131310,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2411,
    ["instanceID"] = 1185,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [323538] = {
        ["interruptible"] = true,
      },
      [323743] = {
      },
      [329340] = {
      },
      [1236512] = {
      },
      [1236513] = {
        ["magic"] = true,
      },
      [1236514] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 107.60519957816,
        ["y"] = -307.33882930148,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Tormented Soul",
    ["id"] = 167892,
    ["count"] = 0,
    ["health"] = 27827610,
    ["scale"] = 1,
    ["displayId"] = 90426,
    ["creatureType"] = "Undead",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Turn Evil"] = true,
    },
    ["clones"] = {
      [1] = {
        ["x"] = 94.274204733166,
        ["y"] = -144.4133533346,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 84.91842563163,
        ["y"] = -160.97833650081,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 85.405107296251,
        ["y"] = -144.61830201223,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 94.01349780169,
        ["y"] = -128.2056474606,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 93.82038979629,
        ["y"] = -160.92394793111,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 94.089798835679,
        ["y"] = -234.37838449296,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 94.037285684004,
        ["y"] = -200.43271822623,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 93.492406934755,
        ["y"] = -217.50940294371,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 84.377124434716,
        ["y"] = -217.16958996898,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 84.710302148656,
        ["y"] = -234.35192220814,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 85.065996333495,
        ["y"] = -200.52971920875,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 130.67767397632,
        ["y"] = -145.14931806874,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 121.93415532727,
        ["y"] = -160.97756145094,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 131.24057970591,
        ["y"] = -128.35554941969,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 122.20224149072,
        ["y"] = -145.01004414865,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 122.60129720587,
        ["y"] = -128.07801762463,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 130.90084142238,
        ["y"] = -160.6805811442,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 132.3837303276,
        ["y"] = -216.88566117615,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 131.93364828079,
        ["y"] = -200.76429804749,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 122.74781653559,
        ["y"] = -200.46191229235,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 132.37928524847,
        ["y"] = -233.83660034966,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 123.20008439006,
        ["y"] = -217.02583733917,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 122.61627393157,
        ["y"] = -233.72860729039,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 84.711992646647,
        ["y"] = -128.47809104047,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Inquisitor Sigar",
    ["id"] = 167876,
    ["count"] = 35,
    ["health"] = 278276103,
    ["scale"] = 1.7,
    ["displayId"] = 131309,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [326794] = {
      },
      [326806] = {
      },
      [326829] = {
        ["interruptible"] = true,
      },
      [326846] = {
      },
      [326847] = {
      },
      [1236614] = {
      },
      [1236615] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 108.20483238956,
        ["y"] = -117.40342563249,
        ["g"] = 74,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Lord Chamberlain",
    ["id"] = 164218,
    ["count"] = 0,
    ["health"] = 742436267,
    ["scale"] = 1.5,
    ["displayId"] = 131311,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2413,
    ["instanceID"] = 1185,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [323142] = {
      },
      [323143] = {
      },
      [323236] = {
      },
      [323414] = {
      },
      [323437] = {
      },
      [328791] = {
      },
      [329104] = {
      },
      [329113] = {
      },
      [329262] = {
      },
      [335338] = {
      },
      [335345] = {
      },
      [1236964] = {
      },
      [1236973] = {
      },
      [1237634] = {
      },
      [1237642] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 109.8804863577,
        ["y"] = -76.483172153053,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Undying Stonefiend",
    ["id"] = 164363,
    ["count"] = 0,
    ["health"] = 15459785,
    ["scale"] = 1.3,
    ["displayId"] = 93854,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [319724] = {
      },
      [328124] = {
      },
      [328125] = {
      },
      [328322] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 262.4922065065,
        ["y"] = -343.48206515896,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 279.99091739865,
        ["y"] = -342.99291557099,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 297.98869933875,
        ["y"] = -342.992835532,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 280.49078760451,
        ["y"] = -276.00126357947,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 297.98859262009,
        ["y"] = -276.00134361846,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 263.49295951345,
        ["y"] = -276.00126357947,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Sinstone Statue",
    ["id"] = 165737,
    ["count"] = 0,
    ["health"] = 15459785,
    ["scale"] = 1.3,
    ["displayId"] = 96853,
    ["creatureType"] = "Not specified",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [323126] = {
      },
      [329258] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 129.32144646189,
        ["y"] = -58.353948939924,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 116.6899697992,
        ["y"] = -51.656561776436,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 102.27380804554,
        ["y"] = -51.715932745586,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 87.833962478767,
        ["y"] = -59.450554958876,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Ghastly Parishioner",
    ["id"] = 165913,
    ["count"] = 0,
    ["health"] = 1545978473,
    ["scale"] = 1.3,
    ["displayId"] = 99386,
    ["creatureType"] = "Undead",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [323650] = {
      },
      [323852] = {
      },
      [323853] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 106.13571391308,
        ["y"] = -332.68376455233,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Empty Anima Vessel",
    ["id"] = 166034,
    ["count"] = 0,
    ["health"] = 10000,
    ["scale"] = 1.3,
    ["displayId"] = 96296,
    ["creatureType"] = "Not specified",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [323749] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 124.0743517101,
        ["y"] = -288.72678794204,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 123.01056914395,
        ["y"] = -322.46234179909,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 90.719495895846,
        ["y"] = -319.52890830269,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 89.457551366593,
        ["y"] = -289.44232059118,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
    },
  },
  [22] = {
    ["name"] = "Anima Fountain",
    ["id"] = 166497,
    ["count"] = 0,
    ["health"] = 10000,
    ["scale"] = 1,
    ["displayId"] = 1126,
    ["creatureType"] = "Not specified",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [338012] = {
      },
      [338013] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 106.1121684791,
        ["y"] = -276.02352068133,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
    },
  },
  [23] = {
    ["name"] = "Depraved Darkblade",
    ["id"] = 167615,
    ["count"] = 4,
    ["health"] = 92758701,
    ["scale"] = 1.4,
    ["displayId"] = 93074,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [1235060] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 116.84197623781,
        ["y"] = -410.59980887923,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 95.289032211715,
        ["y"] = -411.08424414435,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
    },
  },
  [24] = {
    ["name"] = "Manifestation of Envy",
    ["id"] = 167898,
    ["count"] = 0,
    ["health"] = 37103480,
    ["scale"] = 1,
    ["displayId"] = 94281,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [326849] = {
      },
      [326891] = {
      },
      [340446] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 112.01849527772,
        ["y"] = -106.04727835192,
        ["g"] = 74,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 119.42311690514,
        ["y"] = -112.68649675992,
        ["g"] = 74,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 103.49166877519,
        ["y"] = -106.03125600886,
        ["g"] = 74,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 97.012635319742,
        ["y"] = -112.54618512904,
        ["g"] = 74,
        ["sublevel"] = 1,
      },
    },
  },
};
