local addonName = ...
local MDT = MDT
local L = MDT.L
local dungeonIndex = 119
MDT.dungeonList[dungeonIndex] = L["Operation: Floodgate"]
MDT.mapInfo[dungeonIndex] = {
  teleportId = 1216786,
  shortName = L["operationFloodgateShortName"],
  englishName = "Operation: Floodgate",
  mapID = 525
};

local zones = { 2214, 2387, 2388 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "",
  [1] = { customTextures = 'Interface\\AddOns\\'..addonName..'\\TheWarWithin\\Textures\\OperationFloodgate' }
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["Operation: Floodgate"],
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 470 }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dungeonEntrance",
      ["x"] = 236.48816403075,
      ["y"] = -23.656916090641,
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "floodgateItem",
      ["x"] = 46.204470993745,
      ["y"] = -309.79942457667,
    },
    [3] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "floodgateItem",
      ["x"] = 465.82268471973,
      ["y"] = -416.04687541953,
    },
    [4] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "floodgateItem",
      ["x"] = 288.00293853269,
      ["y"] = -283.72654358658,
    },
    [5] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "floodgateItem",
      ["x"] = 165.51846134088,
      ["y"] = -504.54062115212,
    },
    [6] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "floodgateItem",
      ["x"] = 327.17789792626,
      ["y"] = -183.7054891314,
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Shreddinator 3000",
    ["id"] = 230740,
    ["count"] = 10,
    ["health"] = 185517402,
    ["scale"] = 1.6,
    ["stealthDetect"] = true,
    ["displayId"] = 122881,
    ["creatureType"] = "Mechanical",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [465754] = {
      },
      [474337] = {
      },
      [474350] = {
      },
      [474351] = {
      },
      [474388] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 56.886433999061,
        ["y"] = -227.30650156576,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 284.99216706359,
        ["y"] = -98.19549431264,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 346.30219153347,
        ["y"] = -169.70514630488,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 420.06015317178,
        ["y"] = -311.06481947438,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 431.22334225268,
        ["y"] = -321.2656925881,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 142.81719300489,
        ["y"] = -210.21733960229,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Darkfuse Soldier",
    ["id"] = 228144,
    ["count"] = 3,
    ["health"] = 92758701,
    ["scale"] = 1.2,
    ["displayId"] = 122752,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [462737] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 143.56852125136,
        ["y"] = -305.66376019521,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 291.93672703161,
        ["y"] = -57.316789304428,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 302.65014919537,
        ["y"] = -66.336619743002,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 305.71364772666,
        ["y"] = -14.646607182559,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 316.41294084163,
        ["y"] = -24.65405319858,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 331.84091910649,
        ["y"] = -38.487132024236,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 343.5001242532,
        ["y"] = -46.702024956941,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 335.00249202483,
        ["y"] = -88.390903880803,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 345.37851971568,
        ["y"] = -84.9180121431,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 118.93107063937,
        ["y"] = -218.97979857276,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 118.99252221217,
        ["y"] = -206.24361266029,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 32.786250194116,
        ["y"] = -359.01389914561,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 44.630259875263,
        ["y"] = -370.4535737957,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 232.89085725833,
        ["y"] = -176.42118197996,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 243.77798348209,
        ["y"] = -176.73057353418,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 184.16342787366,
        ["y"] = -217.88493657541,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 193.08805221063,
        ["y"] = -225.40092856082,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 201.01937036868,
        ["y"] = -233.92664123345,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 142.59088297229,
        ["y"] = -316.71566991039,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 133.48489744074,
        ["y"] = -308.23650680643,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 157.15438697766,
        ["y"] = -355.7547134542,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 168.75782780857,
        ["y"] = -356.0644916197,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 143.47220555859,
        ["y"] = -428.57307696788,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 152.25227744811,
        ["y"] = -420.74112951285,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 148.95153457698,
            ["y"] = -423.42297759103,
          },
          [2] = {
            ["x"] = 162.22060542956,
            ["y"] = -440.77782083046,
          },
          [3] = {
            ["x"] = 148.95153457698,
            ["y"] = -423.42297759103,
          },
          [4] = {
            ["x"] = 122.19910912639,
            ["y"] = -402.2003610011,
          },
        },
      },
      [25] = {
        ["x"] = 27.4528779957,
        ["y"] = -276.21328544314,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 35.950479101907,
        ["y"] = -267.72685354176,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 687.83070624321,
        ["y"] = -271.12496345717,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 644.69219149388,
        ["y"] = -136.12311846553,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 638.72038330492,
        ["y"] = -146.76855840826,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 650.40436439581,
        ["y"] = -146.76855840826,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Mechadrone Sniper",
    ["id"] = 229069,
    ["count"] = 5,
    ["health"] = 92758701,
    ["scale"] = 1.5,
    ["displayId"] = 126613,
    ["creatureType"] = "Mechanical",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [464655] = {
      },
      [1214468] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 131.03443354293,
        ["y"] = -235.01937859693,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 300.12383626946,
        ["y"] = -45.686019728403,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 311.11946386463,
        ["y"] = -54.90330343821,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 319.17941478173,
        ["y"] = -11.032711266295,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 344.75609596803,
        ["y"] = -32.459733066931,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 367.02997862979,
        ["y"] = -226.00970673365,
        ["g"] = 40,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 367.02997862979,
            ["y"] = -226.00970673365,
          },
          [2] = {
            ["x"] = 386.50222923179,
            ["y"] = -201.71306684509,
          },
          [3] = {
            ["x"] = 367.02997862979,
            ["y"] = -226.00970673365,
          },
          [4] = {
            ["x"] = 342.16512798286,
            ["y"] = -252.76793492781,
          },
        },
      },
      [7] = {
        ["x"] = 381.35840167516,
        ["y"] = -225.2985512191,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 374.19851221934,
        ["y"] = -239.3899264438,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 240.93629920345,
        ["y"] = -110.87090377664,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 232.67944843426,
        ["y"] = -122.51537288969,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 232.67944843426,
            ["y"] = -122.51537288969,
          },
          [2] = {
            ["x"] = 224.70636089436,
            ["y"] = -143.17261302229,
          },
          [3] = {
            ["x"] = 230.4062568726,
            ["y"] = -158.44023321322,
          },
          [4] = {
            ["x"] = 243.84176528283,
            ["y"] = -163.52943627379,
          },
          [5] = {
            ["x"] = 264.60574283431,
            ["y"] = -161.90088512924,
          },
          [6] = {
            ["x"] = 274.17342301008,
            ["y"] = -149.89035621818,
          },
          [7] = {
            ["x"] = 274.58056630083,
            ["y"] = -134.01204310958,
          },
          [8] = {
            ["x"] = 260.12723269141,
            ["y"] = -126.68358497757,
          },
          [9] = {
            ["x"] = 254.42733671317,
            ["y"] = -121.18723862625,
          },
        },
      },
      [11] = {
        ["x"] = 245.80582942659,
        ["y"] = -124.3149388215,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 192.95136119295,
        ["y"] = -277.30072384151,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 179.46059197169,
        ["y"] = -277.55925025169,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 179.10355485564,
        ["y"] = -262.62830421234,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 126.53149949444,
        ["y"] = -351.21677301204,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 127.17159152482,
        ["y"] = -336.91354582737,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 207.22075967313,
        ["y"] = -477.21053366671,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 144.30091745033,
        ["y"] = -234.67025226445,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Loaderbot",
    ["id"] = 231014,
    ["count"] = 2,
    ["health"] = 74206961,
    ["scale"] = 1.1,
    ["displayId"] = 121696,
    ["creatureType"] = "Mechanical",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [465120] = {
      },
      [465127] = {
      },
      [465128] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 305.88258151282,
        ["y"] = -127.34760062352,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 268.40749413552,
        ["y"] = -294.76705983628,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 265.03684009314,
        ["y"] = -304.45569431387,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 258.28354765591,
        ["y"] = -297.92697222448,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 310.56393154187,
        ["y"] = -118.69133084973,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 300.6023659673,
        ["y"] = -118.78825593809,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 158.80611460462,
        ["y"] = -404.5834354919,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 166.35143293756,
        ["y"] = -398.18814603202,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 174.3772572557,
        ["y"] = -390.74821461692,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 156.95342058671,
        ["y"] = -394.48094327004,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 164.72830654321,
        ["y"] = -388.44891077365,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Venture Co. Contractor",
    ["id"] = 229250,
    ["count"] = 2,
    ["health"] = 92758701,
    ["scale"] = 1.2,
    ["displayId"] = 122082,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
    },
    ["clones"] = {
      [1] = {
        ["x"] = 341.48878849032,
        ["y"] = -124.07945197872,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 604.37572217089,
        ["y"] = -257.89387439955,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 603.75606262604,
        ["y"] = -269.98800268789,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 603.82810378463,
        ["y"] = -281.58787422476,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 705.49029389834,
        ["y"] = -92.955403087099,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 704.80974588888,
        ["y"] = -108.04011863315,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 353.48757141631,
        ["y"] = -93.036607733569,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 342.74362377142,
        ["y"] = -96.691186204173,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 331.69498224986,
        ["y"] = -99.181581081593,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 87.714298725977,
        ["y"] = -232.27074718526,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 87.679195455821,
        ["y"] = -246.83215599434,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 224.62108282595,
        ["y"] = -511.68699351769,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 217.43688963605,
        ["y"] = -504.28388935343,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 232.35418049284,
        ["y"] = -504.26803056048,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 234.36799178598,
        ["y"] = -275.67990366802,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 242.326052178,
        ["y"] = -284.102109106,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 309.40820068698,
        ["y"] = -185.5694393953,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 298.82395676486,
        ["y"] = -179.83132426214,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 262.47858463193,
        ["y"] = -232.48675570753,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 276.77737293564,
        ["y"] = -239.36481206573,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 393.59566227134,
        ["y"] = -305.48320543239,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 394.48332074617,
        ["y"] = -316.66225921188,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 400.66888231914,
        ["y"] = -378.47711431792,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 388.01407090674,
        ["y"] = -378.95828007048,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 448.30610207527,
        ["y"] = -289.51576532023,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 459.29272003108,
        ["y"] = -297.73550410052,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 477.68824746074,
        ["y"] = -324.68390969797,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 478.40095937297,
        ["y"] = -336.78793583324,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 650.09880251052,
        ["y"] = -181.88037182186,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 636.86653292184,
        ["y"] = -182.14501872416,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 351.73186689789,
        ["y"] = -130.4945730633,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 224.84968788518,
        ["y"] = -497.08725233645,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 687.60011610343,
        ["y"] = -260.35106267978,
        ["g"] = 54,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 686.93269002354,
            ["y"] = -260.88499926952,
          },
          [2] = {
            ["x"] = 667.76466468428,
            ["y"] = -262.49727702675,
          },
          [3] = {
            ["x"] = 643.75994170702,
            ["y"] = -257.1230630472,
          },
          [4] = {
            ["x"] = 643.22252224669,
            ["y"] = -248.88263778089,
          },
          [5] = {
            ["x"] = 643.75994170702,
            ["y"] = -257.1230630472,
          },
          [6] = {
            ["x"] = 667.76466468428,
            ["y"] = -262.49727702675,
          },
          [7] = {
            ["x"] = 686.93269002354,
            ["y"] = -260.88499926952,
          },
        },
      },
    },
  },
  [6] = {
    ["name"] = "Darkfuse Hyena",
    ["id"] = 229252,
    ["count"] = 3,
    ["health"] = 74206961,
    ["scale"] = 1.2,
    ["displayId"] = 121293,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [463058] = {
        ["interruptible"] = true,
      },
      [463061] = {
        ["enrage"] = true,
      },
      [469771] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 169.21256702933,
        ["y"] = -35.555267753651,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 149.79471390358,
        ["y"] = -111.76026652182,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 163.11980722975,
        ["y"] = -111.44927134075,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 120.27544796533,
        ["y"] = -172.4597044383,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 120.37249349964,
        ["y"] = -186.73095853777,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 106.05721265406,
        ["y"] = -172.37165194462,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 105.98710330458,
        ["y"] = -186.60785902479,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 52.673934039066,
        ["y"] = -184.49734198716,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 59.277688562667,
        ["y"] = -171.45703275785,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 66.654962366466,
        ["y"] = -184.17211113429,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 229.7154912951,
        ["y"] = -232.44644317718,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 221.13340681553,
        ["y"] = -242.63773648032,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 232.76867989045,
        ["y"] = -188.05744365323,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 243.4685879014,
        ["y"] = -188.4401683216,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 157.18933268843,
        ["y"] = -367.10160966358,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 168.03765814954,
        ["y"] = -367.2123898556,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 157.44049301131,
        ["y"] = -45.063419225593,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 176.90969799954,
        ["y"] = -46.874537673272,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 164.23211373064,
        ["y"] = -54.571668643479,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Darkfuse Demolitionist",
    ["id"] = 229212,
    ["count"] = 7,
    ["health"] = 92758701,
    ["scale"] = 1.5,
    ["displayId"] = 124724,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [461793] = {
      },
      [461796] = {
      },
      [461805] = {
      },
      [1216039] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 155.99106417049,
        ["y"] = -98.971577645169,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 193.21353790736,
        ["y"] = -208.08024038418,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 208.00792100949,
        ["y"] = -223.46741221624,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 193.25907150279,
        ["y"] = -263.04681464858,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 195.929723029,
        ["y"] = -487.11405709191,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Darkfuse Bloodwarper",
    ["id"] = 230748,
    ["count"] = 12,
    ["health"] = 148413922,
    ["scale"] = 2,
    ["displayId"] = 126383,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [465827] = {
      },
      [465830] = {
      },
      [465871] = {
        ["interruptible"] = true,
      },
      [1216826] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 102.49859105265,
        ["y"] = -214.05551029508,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 191.46724615502,
        ["y"] = -471.43492630475,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 47.657208235582,
        ["y"] = -356.45817491775,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Darkfuse Inspector",
    ["id"] = 231385,
    ["count"] = 5,
    ["health"] = 92758701,
    ["scale"] = 1.5,
    ["displayId"] = 124177,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [465681] = {
      },
      [465682] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 692.74948300213,
        ["y"] = -100.02516899729,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 154.49777009585,
        ["y"] = -257.20007128809,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 144.096578726,
        ["y"] = -266.80106973416,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 643.4069604679,
        ["y"] = -169.70669350948,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 635.95931302303,
        ["y"] = -211.48280195388,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 712.51725565219,
        ["y"] = -251.25517393132,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 712.20396828591,
        ["y"] = -281.92160179141,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Venture Co. Surveyor",
    ["id"] = 229686,
    ["count"] = 7,
    ["health"] = 92758701,
    ["scale"] = 1.5,
    ["displayId"] = 122080,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [462771] = {
        ["interruptible"] = true,
      },
      [462776] = {
      },
      [463169] = {
      },
      [469796] = {
      },
      [472338] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 358.72543963634,
        ["y"] = -174.08937391429,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 347.07959178151,
        ["y"] = -183.35272789499,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 245.54736042512,
        ["y"] = -272.39240139032,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 264.95756984811,
        ["y"] = -244.95486089842,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 384.02029071744,
        ["y"] = -392.04620077555,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 375.21486601657,
        ["y"] = -379.1026531514,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 448.56765487182,
        ["y"] = -300.68792836598,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 488.44482013802,
        ["y"] = -330.28323126078,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Venture Co. Electrician",
    ["id"] = 231312,
    ["count"] = 7,
    ["health"] = 74206961,
    ["scale"] = 1.5,
    ["displayId"] = 124181,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [465595] = {
        ["interruptible"] = true,
      },
      [465966] = {
      },
      [469799] = {
        ["magic"] = true,
      },
      [469800] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 651.11758179362,
        ["y"] = -211.66174213499,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 592.45695680068,
        ["y"] = -263.53344729092,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 592.12155754264,
        ["y"] = -277.29966006203,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 618.2655163034,
        ["y"] = -183.27908947434,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 637.01773158817,
        ["y"] = -288.87258477459,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 650.81712897887,
        ["y"] = -288.38113561267,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 767.0342136729,
        ["y"] = -273.24772587927,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 754.39604492073,
        ["y"] = -282.31045915669,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Bombshell Crab",
    ["id"] = 231497,
    ["count"] = 3,
    ["health"] = 92758701,
    ["scale"] = 1.1,
    ["displayId"] = 120779,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [468672] = {
      },
      [468680] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 321.56196376014,
        ["y"] = -211.63989185644,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 327.99092088033,
        ["y"] = -231.07274684526,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 244.5337144035,
        ["y"] = -336.38301993082,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 262.54028809188,
        ["y"] = -331.34901043684,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 314.40725634211,
        ["y"] = -244.51335158229,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 351.61705332464,
        ["y"] = -374.28840754495,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 347.96271285909,
        ["y"] = -394.09751066235,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 363.04115250669,
        ["y"] = -389.15911828333,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 359.05252669918,
        ["y"] = -407.71471173541,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 383.02753865474,
        ["y"] = -433.92595227911,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 385.33208293236,
        ["y"] = -412.99494589279,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 374.73368484221,
        ["y"] = -403.54624107861,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 371.46675035608,
        ["y"] = -421.98277755429,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 231.23641014307,
        ["y"] = -346.46498445183,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 224.4491753704,
        ["y"] = -362.74842230425,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 220.99317446653,
        ["y"] = -381.83405851783,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Venture Co. Diver",
    ["id"] = 231496,
    ["count"] = 5,
    ["health"] = 92758701,
    ["scale"] = 1.6,
    ["displayId"] = 122887,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [468631] = {
        ["interruptible"] = true,
      },
      [468726] = {
      },
      [468727] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 336.67252584691,
        ["y"] = -277.48365234103,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 343.00643592941,
        ["y"] = -265.43722908711,
        ["g"] = 39,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 340.67768285545,
            ["y"] = -272.60283480901,
          },
          [2] = {
            ["x"] = 360.64058741825,
            ["y"] = -273.98476705081,
          },
          [3] = {
            ["x"] = 340.67768285545,
            ["y"] = -272.60283480901,
          },
          [4] = {
            ["x"] = 310.12308064223,
            ["y"] = -252.30881652375,
          },
        },
      },
      [3] = {
        ["x"] = 329.71561688324,
        ["y"] = -344.34775972938,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 336.50205704567,
        ["y"] = -331.52838617592,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 322.49235001134,
        ["y"] = -331.24008064271,
        ["g"] = 38,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 322.49235001134,
            ["y"] = -331.24008064271,
          },
          [2] = {
            ["x"] = 332.87387008995,
            ["y"] = -311.425029821,
          },
          [3] = {
            ["x"] = 322.49235001134,
            ["y"] = -331.24008064271,
          },
          [4] = {
            ["x"] = 312.98935005773,
            ["y"] = -370.54122858606,
          },
        },
      },
      [6] = {
        ["x"] = 273.1454855696,
        ["y"] = -346.08700354072,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 286.49384848015,
        ["y"] = -350.86574235285,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 284.72589502624,
        ["y"] = -336.25275906786,
        ["g"] = 37,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 284.72589502624,
            ["y"] = -336.25275906786,
          },
          [2] = {
            ["x"] = 297.87259731698,
            ["y"] = -313.34042673845,
          },
          [3] = {
            ["x"] = 271.34611309063,
            ["y"] = -361.57040652772,
          },
        },
      },
    },
  },
  [14] = {
    ["name"] = "Venture Co. Architect",
    ["id"] = 229251,
    ["count"] = 10,
    ["health"] = 120586312,
    ["scale"] = 2,
    ["stealthDetect"] = true,
    ["displayId"] = 122097,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [465408] = {
      },
      [1213803] = {
      },
      [1213805] = {
      },
      [1216894] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 620.70126624163,
        ["y"] = -269.60879980286,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 671.35097577413,
        ["y"] = -89.212691682264,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 671.04853549641,
        ["y"] = -109.43921280328,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 288.4123699419,
        ["y"] = -262.03245881251,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 378.24623158281,
        ["y"] = -330.88917759796,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 399.41776967577,
        ["y"] = -395.31813764157,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 402.35303962016,
        ["y"] = -431.79106098493,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Disturbed Kelp",
    ["id"] = 231223,
    ["count"] = 7,
    ["health"] = 92758701,
    ["scale"] = 1.5,
    ["displayId"] = 126961,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [471733] = {
        ["interruptible"] = true,
        ["magic"] = true,
      },
      [471736] = {
      },
      [1217456] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 276.00822342205,
        ["y"] = -393.10483032652,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 301.38301571288,
        ["y"] = -393.41618283721,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 328.1588152743,
        ["y"] = -394.22565857726,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 261.12589005556,
        ["y"] = -416.76721970077,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 287.59035046539,
        ["y"] = -415.14818268062,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 315.23779889561,
        ["y"] = -415.708606587,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Darkfuse Jumpstarter",
    ["id"] = 231325,
    ["count"] = 12,
    ["health"] = 148413922,
    ["scale"] = 1.7,
    ["stealthDetect"] = true,
    ["displayId"] = 122517,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [465604] = {
        ["magic"] = true,
      },
      [465666] = {
      },
      [1216607] = {
      },
      [1216610] = {
      },
      [1216611] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 762.86405849206,
        ["y"] = -334.67918900793,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 778.44039358014,
        ["y"] = -334.12821738343,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 663.56247454263,
        ["y"] = -199.33165021296,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 768.20075764216,
        ["y"] = -289.62384567127,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Big M.O.M.M.A.",
    ["id"] = 226398,
    ["count"] = 0,
    ["health"] = 1020849867,
    ["scale"] = 1.5,
    ["displayId"] = 122867,
    ["creatureType"] = "Mechanical",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2650,
    ["instanceID"] = 1298,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [460156] = {
      },
      [460158] = {
      },
      [469981] = {
      },
      [471585] = {
      },
      [471652] = {
      },
      [473220] = {
      },
      [473224] = {
      },
      [473240] = {
      },
      [473287] = {
      },
      [473351] = {
      },
      [473836] = {
      },
      [1215504] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 90.13903789467,
        ["y"] = -320.71403570728,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Bront",
    ["id"] = 226402,
    ["count"] = 0,
    ["health"] = 417620400,
    ["scale"] = 1.7,
    ["displayId"] = 122215,
    ["creatureType"] = "Humanoid",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2650,
    ["instanceID"] = 1298,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [459779] = {
      },
      [459799] = {
      },
      [460965] = {
      },
      [470022] = {
      },
      [470090] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 460.52662130646,
        ["y"] = -370.59871623715,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Keeza Quickfuse",
    ["id"] = 226403,
    ["count"] = 0,
    ["health"] = 324815867,
    ["scale"] = 1.7,
    ["displayId"] = 123036,
    ["creatureType"] = "Humanoid",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2650,
    ["instanceID"] = 1298,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [460602] = {
      },
      [460814] = {
      },
      [460867] = {
      },
      [461994] = {
      },
      [470090] = {
      },
      [472755] = {
      },
      [473526] = {
      },
      [473690] = {
      },
      [473713] = {
        ["magic"] = true,
      },
      [473719] = {
      },
      [1217653] = {
      },
      [1217751] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 436.33705078982,
        ["y"] = -395.0408435023,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Swampface",
    ["id"] = 226396,
    ["count"] = 0,
    ["health"] = 649631734,
    ["scale"] = 2,
    ["displayId"] = 124283,
    ["creatureType"] = "Elemental",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2650,
    ["instanceID"] = 1298,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [469478] = {
      },
      [469479] = {
      },
      [469480] = {
      },
      [470038] = {
      },
      [470039] = {
      },
      [472794] = {
      },
      [472819] = {
      },
      [472878] = {
      },
      [473046] = {
      },
      [473070] = {
      },
      [473081] = {
      },
      [473114] = {
      },
      [473126] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 302.68758646667,
        ["y"] = -456.21232405863,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Geezle Gigazap",
    ["id"] = 226404,
    ["count"] = 0,
    ["health"] = 742436267,
    ["scale"] = 2,
    ["displayId"] = 122475,
    ["creatureType"] = "Humanoid",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2650,
    ["instanceID"] = 1298,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [465462] = {
      },
      [465463] = {
      },
      [465982] = {
      },
      [466124] = {
      },
      [466188] = {
      },
      [466189] = {
      },
      [466190] = {
      },
      [466197] = {
      },
      [468604] = {
      },
      [468813] = {
      },
      [468815] = {
      },
      [468841] = {
      },
      [468846] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 771.77494956039,
        ["y"] = -412.0632597402,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
    },
  },
  [22] = {
    ["name"] = "Darkfuse Mechadrone",
    ["id"] = 228424,
    ["count"] = 0,
    ["health"] = 92758708,
    ["scale"] = 1.5,
    ["displayId"] = 125461,
    ["creatureType"] = "Mechanical",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [460393] = {
      },
      [472452] = {
      },
      [472454] = {
      },
      [1214780] = {
        ["interruptible"] = true,
      },
      [1214801] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 76.310542955188,
        ["y"] = -336.97506401412,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 104.14137937734,
        ["y"] = -335.85493699208,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 102.33184614386,
        ["y"] = -304.54063803712,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 76.5443217543,
        ["y"] = -304.98372831297,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
    },
  },
  [23] = {
    ["name"] = "Undercrawler",
    ["id"] = 231380,
    ["count"] = 1,
    ["health"] = 92758701,
    ["scale"] = 1.3,
    ["displayId"] = 112449,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [465813] = {
        ["interruptible"] = true,
        ["poison"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 292.03298905166,
        ["y"] = -10.342571502045,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 300.94508952478,
        ["y"] = -31.343075241227,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 131.63247926564,
        ["y"] = -112.07347546839,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 117.14377654907,
        ["y"] = -89.887666268097,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 360.73513952509,
        ["y"] = -57.288178052122,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 389.71260258634,
        ["y"] = -125.20396156754,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 407.82339527935,
        ["y"] = -102.56536051208,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 415.0678200971,
        ["y"] = -195.83638118921,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 421.40663671803,
        ["y"] = -170.93394329037,
        ["sublevel"] = 1,
      },
    },
  },
  [24] = {
    ["name"] = "Waterworks Crocolisk",
    ["id"] = 227145,
    ["count"] = 1,
    ["health"] = 92758701,
    ["scale"] = 1.3,
    ["displayId"] = 75850,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [465820] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 290.86509110898,
        ["y"] = -22.948754783961,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 288.55345750598,
        ["y"] = -36.347417416891,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 371.14881874827,
        ["y"] = -81.737845326419,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 379.75155791529,
        ["y"] = -55.476958402631,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 384.27910916963,
        ["y"] = -98.49039712962,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 395.1458198557,
        ["y"] = -79.021094195442,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 393.78754563416,
        ["y"] = -155.08692622452,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 412.80394652399,
        ["y"] = -142.40929298266,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 371.60187009001,
        ["y"] = -200.36402234608,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 397.40974478027,
        ["y"] = -208.51384722551,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 406.46508976513,
        ["y"] = -237.49136050894,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 420.9537924817,
        ["y"] = -243.83017712987,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 393.78750549623,
        ["y"] = -254.6967041673,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 411.44559203679,
        ["y"] = -260.58272893307,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
    },
  },
  [25] = {
    ["name"] = "Scaffolding",
    ["id"] = 231176,
    ["count"] = 0,
    ["health"] = 13913806,
    ["scale"] = 1,
    ["displayId"] = 124689,
    ["creatureType"] = "Not specified",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [465420] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 679.51239410046,
        ["y"] = -98.868248119345,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 390.2914311928,
        ["y"] = -333.50716666742,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 412.42947686432,
        ["y"] = -440.49705242056,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 406.01616560126,
        ["y"] = -407.937589292,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 298.4712892152,
        ["y"] = -268.32654344579,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 618.63949005085,
        ["y"] = -283.12626060653,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
    },
  },
  [26] = {
    ["name"] = "Leaping Spark",
    ["id"] = 232690,
    ["count"] = 0,
    ["health"] = 10000,
    ["scale"] = 1.5,
    ["displayId"] = 43164,
    ["iconTexture"] = 252174,
    ["creatureType"] = "Not specified",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [468616] = {
      },
      [468647] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 759.24421573403,
        ["y"] = -430.71091014252,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 789.36314744585,
        ["y"] = -428.45230416072,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 774.07676651348,
        ["y"] = -437.44451187465,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
    },
  },
  [27] = {
    ["name"] = "Ticking Time Bomb",
    ["id"] = 234528,
    ["count"] = 0,
    ["health"] = 10000,
    ["scale"] = 1.5,
    ["displayId"] = 169,
    ["iconTexture"] = 133710,
    ["creatureType"] = "Not specified",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [460781] = {
      },
      [460814] = {
      },
      [461994] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 455.58343329567,
        ["y"] = -391.41020264697,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 438.08224168258,
        ["y"] = -373.40480475167,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
    },
  },
};
