local addonName = ...
local MDT = MDT
local L = MDT.L

local dungeonIndex = 111
MDT.dungeonList[dungeonIndex] = L["The Dawnbreaker"]
MDT.mapInfo[dungeonIndex] = {
  teleportId = 445414,
  shortName = L["dawnBreakerShortName"],
  englishName = "The Dawnbreaker",
  mapID = 505
}

local zones = { 2215, 2215, 2359 } -- TODO remove 2215 WHEN DAWNBREAKER IS GONE FROM ROTATION
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "",
  [1] = { customTextures = 'Interface\\AddOns\\'..addonName..'\\TheWarWithin\\Textures\\Dawnbreaker' }
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["The Dawnbreaker"]
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 460 }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dungeonEntrance",
      ["x"] = 594.33722436621,
      ["y"] = -518.43239200431,
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Nightfall Curseblade",
    ["id"] = 213894,
    ["count"] = 5,
    ["health"] = 97396637,
    ["scale"] = 1.3,
    ["displayId"] = 121389,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [1242072] = {
      },
      [1242074] = {
        ["enrage"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 643.7891985943,
        ["y"] = -445.5955983436,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 658.52920063357,
        ["y"] = -423.17826997093,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 678.61565842672,
        ["y"] = -440.48413192566,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 654.44875876189,
        ["y"] = -194.02264423049,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 608.42569680819,
        ["y"] = -174.2717976097,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 626.99819357193,
        ["y"] = -156.69881527297,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 716.19439711502,
        ["y"] = -92.787929625161,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 736.83749396656,
        ["y"] = -108.46493257059,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 577.5176527807,
        ["y"] = -268.62884147108,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 16.922242950255,
        ["y"] = -151.75083531668,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 58.146458414675,
        ["y"] = -216.82291738734,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 244.66971736573,
        ["y"] = -359.39473139546,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 280.22491891034,
        ["y"] = -393.31697043888,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 108.73289679818,
        ["y"] = -118.4450103064,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 101.09749985513,
        ["y"] = -68.263760305476,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 182.55106144516,
        ["y"] = -167.35803712419,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 243.43233224821,
        ["y"] = -210.85457638861,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 190.5113003456,
        ["y"] = -242.56441916484,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 190.51119515404,
        ["y"] = -230.56990728715,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Nightfall Shadowmage",
    ["id"] = 213892,
    ["count"] = 5,
    ["health"] = 83482831,
    ["scale"] = 1.3,
    ["displayId"] = 121391,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [431303] = {
        ["interruptible"] = true,
      },
      [431309] = {
        ["curse"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 660.4955062504,
        ["y"] = -459.19086943476,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 667.95423348102,
        ["y"] = -432.41993910021,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 640.49872629889,
        ["y"] = -183.59443642324,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 718.35881445384,
        ["y"] = -112.11699477461,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 205.6908768358,
        ["y"] = -362.31923925004,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 238.75593229031,
        ["y"] = -349.16925030321,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 53.239666437928,
        ["y"] = -206.21951709087,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 236.63933307949,
        ["y"] = -434.34346500932,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 194.62039448393,
        ["y"] = -168.72599149091,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 322.74989580937,
        ["y"] = -368.51403319042,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Nightfall Ritualist",
    ["id"] = 214761,
    ["count"] = 12,
    ["health"] = 157689792,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 121395,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [431364] = {
      },
      [431365] = {
      },
      [432448] = {
        ["magic"] = true,
      },
      [432454] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 658.46383109568,
        ["y"] = -443.57571592443,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 618.06191548258,
        ["y"] = -165.79015776653,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 253.41877975386,
        ["y"] = -192.45419033606,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 212.79873605037,
        ["y"] = -381.20213535018,
        ["g"] = 44,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 215.77132699807,
            ["y"] = -391.74134700278,
          },
          [2] = {
            ["x"] = 211.3747910437,
            ["y"] = -382.46816589888,
          },
          [3] = {
            ["x"] = 210.45946769973,
            ["y"] = -374.99302250636,
          },
          [4] = {
            ["x"] = 210.76458098127,
            ["y"] = -371.63682591138,
          },
          [5] = {
            ["x"] = 220.83315426556,
            ["y"] = -359.12739587671,
          },
          [6] = {
            ["x"] = 226.01999754848,
            ["y"] = -356.38142584481,
          },
          [7] = {
            ["x"] = 235.17323098817,
            ["y"] = -355.46610250084,
          },
          [8] = {
            ["x"] = 251.34397089935,
            ["y"] = -357.14420904864,
          },
          [9] = {
            ["x"] = 257.59866941605,
            ["y"] = -362.78869750291,
          },
          [10] = {
            ["x"] = 257.29357263515,
            ["y"] = -373.16237581842,
          },
          [11] = {
            ["x"] = 256.07311950901,
            ["y"] = -378.806872523,
          },
          [12] = {
            ["x"] = 248.75053275726,
            ["y"] = -389.94331754172,
          },
          [13] = {
            ["x"] = 240.66518755262,
            ["y"] = -396.96079926225,
          },
          [14] = {
            ["x"] = 232.73235773716,
            ["y"] = -402.14763429485,
          },
          [15] = {
            ["x"] = 215.77132699807,
            ["y"] = -391.74134700278,
          },
        },
      },
    },
  },
  [4] = {
    ["name"] = "Nightfall Commander",
    ["id"] = 214762,
    ["count"] = 12,
    ["health"] = 157689792,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 121393,
    ["iconTexture"] = 236304,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [431491] = {
        ["bleed"] = true,
      },
      [450756] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 643.32184005986,
        ["y"] = -196.08649249482,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 565.39533581353,
        ["y"] = -271.52883944209,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 109.95414068953,
        ["y"] = -78.118750577933,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 130.09320778054,
        ["y"] = -196.02170119063,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 130.09320778054,
            ["y"] = -194.13561002761,
          },
          [2] = {
            ["x"] = 137.24647885885,
            ["y"] = -189.47247283159,
          },
          [3] = {
            ["x"] = 130.09320778054,
            ["y"] = -194.13561002761,
          },
          [4] = {
            ["x"] = 106.59698425256,
            ["y"] = -210.21983263853,
          },
          [5] = {
            ["x"] = 86.556919788428,
            ["y"] = -224.36576499574,
          },
        },
      },
      [5] = {
        ["x"] = 72.669700402537,
        ["y"] = -151.44724533907,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 201.20917717964,
        ["y"] = -236.40497974972,
        ["g"] = 51,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 201.20917717964,
            ["y"] = -236.40497974972,
          },
          [2] = {
            ["x"] = 183.23436754146,
            ["y"] = -247.56101884474,
          },
          [3] = {
            ["x"] = 175.77831938057,
            ["y"] = -260.20394028688,
          },
          [4] = {
            ["x"] = 183.23436754146,
            ["y"] = -247.56101884474,
          },
          [5] = {
            ["x"] = 201.20917717964,
            ["y"] = -236.40497974972,
          },
          [6] = {
            ["x"] = 219.21805219592,
            ["y"] = -232.97303526257,
          },
          [7] = {
            ["x"] = 238.02034292547,
            ["y"] = -230.70380778715,
          },
          [8] = {
            ["x"] = 258.44349539581,
            ["y"] = -224.54442096781,
          },
          [9] = {
            ["x"] = 270.43810369911,
            ["y"] = -215.46745847035,
          },
          [10] = {
            ["x"] = 258.44349539581,
            ["y"] = -224.54442096781,
          },
          [11] = {
            ["x"] = 238.02034292547,
            ["y"] = -230.70380778715,
          },
          [12] = {
            ["x"] = 219.21805219592,
            ["y"] = -232.97303526257,
          },
        },
      },
      [7] = {
        ["x"] = 279.81807052512,
        ["y"] = -256.9659545083,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 248.86335136401,
        ["y"] = -348.22799142534,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Sureki Webmage",
    ["id"] = 210966,
    ["count"] = 12,
    ["health"] = 185517402,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 121336,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [451104] = {
      },
      [451107] = {
      },
      [451113] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 726.12906551791,
        ["y"] = -100.85671816945,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 575.75000838754,
        ["y"] = -282.15576990657,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 362.65512497826,
        ["y"] = -129.9173149299,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 411.25168462355,
        ["y"] = -204.01612933093,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 238.99819548845,
        ["y"] = -251.56989091406,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 380.06832965117,
        ["y"] = -202.58052069593,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 380.47922564089,
            ["y"] = -202.99142399515,
          },
          [2] = {
            ["x"] = 360.21018308786,
            ["y"] = -204.2302790024,
          },
          [3] = {
            ["x"] = 380.47922564089,
            ["y"] = -202.99142399515,
          },
          [4] = {
            ["x"] = 403.59100661525,
            ["y"] = -203.05145768121,
          },
        },
      },
      [7] = {
        ["x"] = 306.1301019009,
        ["y"] = -338.60297985954,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 431.76077764858,
        ["y"] = -167.37885596683,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Nightfall Darkcaster",
    ["id"] = 213893,
    ["count"] = 5,
    ["health"] = 88120767,
    ["scale"] = 1.3,
    ["displayId"] = 121397,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [431333] = {
        ["interruptible"] = true,
      },
      [432520] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 370.5953300006,
        ["y"] = -180.33792844264,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 370.52676926092,
        ["y"] = -192.06066187968,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 213.91090391426,
        ["y"] = -198.10571875243,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 152.28250478887,
        ["y"] = -321.17410900901,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 143.93923785199,
        ["y"] = -313.08354219332,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 54.686558008175,
        ["y"] = -116.02205488386,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 194.87834531861,
        ["y"] = -155.95245852665,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 159.6204873396,
        ["y"] = -197.77530954537,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 143.50464900102,
        ["y"] = -214.65044965882,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 119.34616059636,
        ["y"] = -197.49966797388,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 126.35417863434,
        ["y"] = -205.54572357393,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 97.305132199031,
        ["y"] = -199.54100187322,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 62.042910505465,
        ["y"] = -157.28870315497,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 17.266500468957,
        ["y"] = -164.67861756171,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 243.57135308113,
        ["y"] = -132.27168506716,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 243.428033632,
        ["y"] = -108.95023625365,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 309.5435516501,
        ["y"] = -94.676435586104,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 297.97773085408,
        ["y"] = -106.85367243299,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 298.17090256489,
        ["y"] = -95.251018746383,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 350.34175101148,
        ["y"] = -111.13559009188,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 278.08770869262,
        ["y"] = -268.70038701998,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 161.02281260675,
        ["y"] = -275.00420874032,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 198.9142279029,
        ["y"] = -328.92661847885,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 212.73549341194,
        ["y"] = -353.41662041196,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 316.78158754648,
        ["y"] = -358.06909235405,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 327.26616378318,
        ["y"] = -357.80275564039,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 336.16551925009,
        ["y"] = -391.31601934274,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 215.88335206173,
        ["y"] = -420.66090374661,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 141.39041413672,
        ["y"] = -95.250678961263,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 223.4394706522,
        ["y"] = -386.97317354707,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 223.36431162279,
        ["y"] = -374.65480552438,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 247.22451617424,
        ["y"] = -389.33620292834,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 256.09006113075,
        ["y"] = -381.72008118858,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 258.60712589263,
        ["y"] = -434.36297587895,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 259.21849597226,
        ["y"] = -424.81161593634,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Nightfall Shadowalker",
    ["id"] = 213895,
    ["count"] = 5,
    ["health"] = 97396637,
    ["scale"] = 1.2,
    ["displayId"] = 115530,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [431637] = {
      },
      [1242678] = {
      },
      [1242681] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 162.5624087387,
        ["y"] = -138.84479470037,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 154.86873007846,
        ["y"] = -130.93873673359,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 371.65003700887,
        ["y"] = -154.19829481611,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 371.73501004346,
        ["y"] = -165.56449051469,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 237.49529539409,
        ["y"] = -445.05830277739,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 243.47605396955,
        ["y"] = -198.89814593348,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 243.72762163574,
        ["y"] = -186.66930930669,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 203.85498558603,
        ["y"] = -191.282035037,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 203.31627501861,
        ["y"] = -203.76215577431,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 92.404024024058,
        ["y"] = -76.427367993016,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 66.057343294922,
        ["y"] = -115.72765899479,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 165.51417369299,
        ["y"] = -187.8295727795,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 135.33202544579,
        ["y"] = -222.09722033625,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 147.74241365106,
        ["y"] = -152.50498506124,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 106.81968338432,
        ["y"] = -242.35964186646,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 243.70530161306,
        ["y"] = -120.81309061558,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 350.68786655708,
        ["y"] = -99.483849830952,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 361.77014194025,
        ["y"] = -111.50927783318,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 270.41214524034,
        ["y"] = -260.04416887009,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 286.4431624503,
        ["y"] = -276.38742065182,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 206.86342144836,
        ["y"] = -257.66445998427,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 284.02820190285,
        ["y"] = -384.0217469202,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 274.29327361897,
        ["y"] = -384.21601561315,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 291.1208472625,
        ["y"] = -360.56190839668,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 325.76208501603,
        ["y"] = -391.15634444272,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 356.34865971002,
        ["y"] = -404.93441322229,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 368.3841002033,
        ["y"] = -404.78511454712,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 354.51471213982,
        ["y"] = -442.81570113759,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 365.68874637013,
        ["y"] = -442.30871232927,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 209.39607021599,
        ["y"] = -412.64269337308,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 62.042731047953,
        ["y"] = -168.8939491679,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 62.580140820162,
        ["y"] = -145.24748322525,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 147.89592057986,
        ["y"] = -164.13458584646,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 172.80104127467,
        ["y"] = -414.18204936701,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 182.52951549572,
        ["y"] = -416.61416792227,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 188.3396261627,
        ["y"] = -408.23686386624,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 270.05916480546,
        ["y"] = -434.80838889479,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 264.16035792195,
        ["y"] = -397.82388490988,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 258.89999556414,
        ["y"] = -406.91753135931,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 269.30778738513,
        ["y"] = -406.91566965668,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 348.15209526513,
        ["y"] = -155.31005230627,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 348.34644147681,
        ["y"] = -166.19233933225,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Manifested Shadow",
    ["id"] = 211341,
    ["count"] = 8,
    ["health"] = 129862181,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 121337,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [432565] = {
      },
      [432606] = {
      },
      [453345] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 136.29116043925,
        ["y"] = -151.95319949794,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 135.92696614843,
        ["y"] = -166.52967732317,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 141.20958590757,
        ["y"] = -324.85620581368,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 60.7347807957,
        ["y"] = -104.00019012702,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 64.878264599688,
        ["y"] = -207.44300159047,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 96.030374868524,
        ["y"] = -239.29500897607,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 27.518014477023,
        ["y"] = -157.50118118879,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 230.46112913607,
        ["y"] = -220.96442783552,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 195.88990493425,
        ["y"] = -261.55128095247,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 205.43954897323,
        ["y"] = -269.83735632244,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 187.90694666126,
        ["y"] = -328.86290232033,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 360.60378676103,
        ["y"] = -453.70259956795,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 145.28275981031,
        ["y"] = -84.270539182607,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Nightfall Tactician",
    ["id"] = 213934,
    ["count"] = 10,
    ["health"] = 157689792,
    ["scale"] = 1.3,
    ["stealthDetect"] = true,
    ["displayId"] = 121398,
    ["iconTexture"] = 236296,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [431494] = {
        ["magic"] = true,
      },
      [451112] = {
        ["enrage"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 387.02533791475,
        ["y"] = -159.99755566887,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 386.98534257558,
        ["y"] = -171.8033405698,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 246.49802431125,
        ["y"] = -438.44739329685,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 254.95922427507,
        ["y"] = -206.67902417618,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 183.00633776608,
        ["y"] = -156.79818879025,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 88.329165237211,
        ["y"] = -207.32595074236,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 98.658175272593,
        ["y"] = -250.82267343867,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 253.53651852142,
        ["y"] = -114.33786617785,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 253.70739254561,
        ["y"] = -126.60035151305,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 309.29875021963,
        ["y"] = -106.55565455617,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 361.7323402959,
        ["y"] = -99.818138471671,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 289.0057497871,
        ["y"] = -264.7295969054,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 219.0775852629,
        ["y"] = -221.25639623879,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 154.24671687384,
        ["y"] = -264.51419083456,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 166.95914170636,
        ["y"] = -263.92003391816,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 215.93297874868,
        ["y"] = -363.64498652826,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 285.11903867588,
        ["y"] = -350.63587627764,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 331.38739869046,
        ["y"] = -402.63718066907,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 362.63063732963,
        ["y"] = -415.31606689896,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 133.67223749036,
        ["y"] = -86.852809932269,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 117.23020168431,
        ["y"] = -111.85388053665,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 72.620980073851,
        ["y"] = -163.13462707277,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 179.69209672653,
        ["y"] = -406.21008157851,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 269.56020660751,
        ["y"] = -424.30813096092,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 100.90219469604,
        ["y"] = -85.727510175696,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Ascendant Viscoxria",
    ["id"] = 211261,
    ["count"] = 25,
    ["health"] = 306103714,
    ["scale"] = 2.5,
    ["stealthDetect"] = true,
    ["displayId"] = 122793,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [427192] = {
      },
      [451101] = {
      },
      [451102] = {
      },
      [451119] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 406.96412370818,
        ["y"] = -164.78290120278,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Deathscreamer Ikentak",
    ["id"] = 211263,
    ["count"] = 25,
    ["health"] = 306103714,
    ["scale"] = 2.5,
    ["stealthDetect"] = true,
    ["displayId"] = 122794,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [427192] = {
      },
      [450854] = {
      },
      [450860] = {
      },
      [451119] = {
      },
      [460135] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 235.64900077313,
        ["y"] = -415.8893574137,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Ixkreten The Unbreakable",
    ["id"] = 211262,
    ["count"] = 25,
    ["health"] = 306103714,
    ["scale"] = 2.5,
    ["stealthDetect"] = true,
    ["displayId"] = 122795,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [427192] = {
      },
      [451115] = {
      },
      [451116] = {
      },
      [451117] = {
      },
      [451119] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 98.617003807979,
        ["y"] = -157.66679852851,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Nightfall Dark Architect",
    ["id"] = 213885,
    ["count"] = 30,
    ["health"] = 259724363,
    ["scale"] = 2.5,
    ["stealthDetect"] = true,
    ["displayId"] = 120116,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [431349] = {
      },
      [431350] = {
      },
      [431352] = {
      },
      [446615] = {
      },
      [452502] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 74.36274044057,
        ["y"] = -470.56586418616,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Speaker Shadowcrown",
    ["id"] = 211087,
    ["count"] = 0,
    ["health"] = 649631734,
    ["scale"] = 2,
    ["displayId"] = 114311,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2580,
    ["instanceID"] = 0,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [426734] = {
      },
      [426735] = {
        ["magic"] = true,
      },
      [426736] = {
      },
      [428086] = {
        ["interruptible"] = true,
      },
      [451026] = {
      },
      [451032] = {
      },
      [453140] = {
      },
      [453141] = {
      },
      [453173] = {
      },
      [453212] = {
      },
      [453214] = {
      },
      [453310] = {
      },
      [453859] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 705.55844883045,
        ["y"] = -232.05024268043,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Anubikkaj",
    ["id"] = 211089,
    ["count"] = 0,
    ["health"] = 649631734,
    ["scale"] = 1.2,
    ["displayId"] = 114315,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2581,
    ["instanceID"] = 0,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [426787] = {
      },
      [426793] = {
      },
      [426826] = {
      },
      [426860] = {
      },
      [427001] = {
      },
      [427002] = {
      },
      [427007] = {
      },
      [427192] = {
      },
      [427378] = {
      },
      [452127] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 186.30600051686,
        ["y"] = -376.87560028099,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Rashanan",
    ["id"] = 213937,
    ["count"] = 0,
    ["health"] = 16704816008,
    ["scale"] = 2,
    ["displayId"] = 118404,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2593,
    ["instanceID"] = 0,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [434089] = {
      },
      [434093] = {
      },
      [434096] = {
      },
      [434119] = {
      },
      [434407] = {
      },
      [434441] = {
      },
      [434576] = {
      },
      [434579] = {
      },
      [434655] = {
      },
      [438956] = {
      },
      [438957] = {
      },
      [448213] = {
      },
      [448215] = {
      },
      [448887] = {
      },
      [448888] = {
      },
      [449734] = {
        ["interruptible"] = true,
      },
      [463428] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 129.36118143511,
        ["y"] = -482.65541716317,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Unstable Darkness",
    ["id"] = 213905,
    ["count"] = 1,
    ["health"] = 35710102,
    ["scale"] = 0.8,
    ["displayId"] = 121338,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [1242993] = {
      },
      [1242994] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 286.07776751719,
        ["y"] = -466.28217381394,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 283.9380305422,
        ["y"] = -407.16479815892,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 289.69816765557,
        ["y"] = -407.1124318867,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 296.17302536025,
        ["y"] = -406.89619829086,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 297.68433944906,
        ["y"] = -430.09013037312,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 294.17279408535,
        ["y"] = -423.89859167003,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 287.19030513103,
        ["y"] = -424.43024913531,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 283.61614473151,
        ["y"] = -430.82706146838,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 290.58147057584,
        ["y"] = -430.60928927383,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 310.366028184,
        ["y"] = -430.25210492249,
        ["g"] = 67,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 310.44623911996,
        ["y"] = -423.34640450481,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 318.22872001716,
        ["y"] = -430.75204866733,
        ["g"] = 67,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 317.79774906364,
        ["y"] = -423.43669454992,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 330.08750701013,
        ["y"] = -420.19422953197,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 337.31204387432,
        ["y"] = -420.00899218958,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 330.45798169492,
        ["y"] = -427.41875637792,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 337.31202383783,
        ["y"] = -426.86303433249,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 352.3168095934,
        ["y"] = -415.93362038325,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 372.1379465796,
        ["y"] = -414.82216627416,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 158.52718896689,
        ["y"] = -344.11358296082,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 167.8089088341,
        ["y"] = -348.20848021573,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 186.6453003804,
        ["y"] = -349.02742423376,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 181.73151816237,
        ["y"] = -343.56762028213,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 194.56205449597,
        ["y"] = -337.56183888807,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 199.47592529637,
        ["y"] = -301.79993993461,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 204.93572924801,
        ["y"] = -294.42911897028,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 213.94443824842,
        ["y"] = -297.15908000101,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 212.85248336358,
        ["y"] = -305.62176726781,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 204.38973704186,
        ["y"] = -307.53272522559,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 254.03166529686,
        ["y"] = -291.67000039488,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 261.12944586693,
        ["y"] = -291.12402295246,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 269.04617045505,
        ["y"] = -291.12402295246,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 257.03454861202,
        ["y"] = -297.94880741947,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 264.1323291821,
        ["y"] = -297.12981911025,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 241.206629135,
        ["y"] = -329.56817906848,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 250.1657119776,
        ["y"] = -325.32441976211,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 419.61916762598,
        ["y"] = -197.66287401772,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 424.47727781525,
        ["y"] = -202.72042309377,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 420.78181855381,
        ["y"] = -209.4107314678,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 417.79001016814,
        ["y"] = -180.75688305256,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 426.74911851173,
        ["y"] = -181.22839628044,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 422.74107756782,
        ["y"] = -186.41524579505,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [43] = {
        ["x"] = 399.40030575407,
        ["y"] = -144.21321808786,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [44] = {
        ["x"] = 406.94479791105,
        ["y"] = -142.09130655844,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [45] = {
        ["x"] = 202.11975169037,
        ["y"] = -419.00869233568,
        ["sublevel"] = 1,
      },
      [46] = {
        ["x"] = 201.98463719762,
        ["y"] = -407.79388658717,
        ["sublevel"] = 1,
      },
      [47] = {
        ["x"] = 182.93297454799,
        ["y"] = -435.89847262626,
        ["sublevel"] = 1,
      },
      [48] = {
        ["x"] = 193.74242239681,
        ["y"] = -434.54728443444,
        ["sublevel"] = 1,
      },
      [49] = {
        ["x"] = 194.68825268894,
        ["y"] = -442.92460651727,
        ["sublevel"] = 1,
      },
      [50] = {
        ["x"] = 184.82462071082,
        ["y"] = -444.27579470909,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Animated Shadow",
    ["id"] = 224616,
    ["count"] = 0,
    ["health"] = 18551742,
    ["scale"] = 0.9,
    ["displayId"] = 114556,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [452099] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 170.64297722409,
        ["y"] = -380.02847750257,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 169.59661316023,
        ["y"] = -372.28662715304,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 173.82514994622,
        ["y"] = -365.94385055941,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 175.2346177421,
        ["y"] = -386.55781017166,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 179.63931656356,
        ["y"] = -361.18678002476,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
    },
  },
};
