local addonName = ...
local MDT = MDT
local L = MDT.L
local dungeonIndex = 120
MDT.dungeonList[dungeonIndex] = L["The MOTHERLODE!!"]
MDT.mapInfo[dungeonIndex] = {
  teleportId = 467553,
  shortName = L["motherlodeShortName"],
  englishName = "The MOTHERLODE!!",
  mapID = 247
};

local zones = { 1010 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "KezanDungeon",
  [1] = "KezanDungeon",
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["The MOTHERLODE!!"],
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 457 }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dungeonEntrance",
      ["x"] = 436.22929620774,
      ["y"] = -492.55566995818,
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "motherlodeItem",
      ["x"] = 216.15413743317,
      ["y"] = -143.32673363078,
    },
    [3] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "motherlodeItem",
      ["x"] = 231.38105298412,
      ["y"] = -156.76226729833,
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Big Money Crab",
    ["id"] = 137713,
    ["count"] = 1,
    ["health"] = 9749540,
    ["scale"] = 0.7,
    ["displayId"] = 32024,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Disorient"] = true,
    },
    ["spells"] = {
      [270866] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 480.93373258087,
        ["y"] = -478.70578679826,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 424.60733475599,
        ["y"] = -470.53162244805,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 448.2837101184,
        ["y"] = -461.04238061663,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 447.71663439488,
        ["y"] = -478.43337752976,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Off-Duty Laborer",
    ["id"] = 130436,
    ["count"] = 1,
    ["health"] = 48747699,
    ["scale"] = 0.5,
    ["displayId"] = 81226,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [258674] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 450.80979965281,
        ["y"] = -440.16736026815,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 455.68886302039,
        ["y"] = -439.82352837547,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 453.51232578575,
        ["y"] = -444.21309924598,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 477.97306881945,
        ["y"] = -437.83897910623,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 443.163449173,
        ["y"] = -348.08030768666,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 438.86796407949,
        ["y"] = -347.65035116608,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 445.35517972996,
        ["y"] = -352.22552343788,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 435.39356591546,
        ["y"] = -350.64186375131,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 443.53221864535,
        ["y"] = -356.56874195536,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 398.85639557519,
        ["y"] = -312.51963873371,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 421.29160156623,
        ["y"] = -368.71835621373,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 473.23298526173,
        ["y"] = -422.77945216378,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 473.23951566151,
        ["y"] = -427.67122655268,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 446.7644447483,
        ["y"] = -412.23531646755,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 473.33370897225,
        ["y"] = -410.84219818738,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 479.44809247429,
        ["y"] = -383.93598993279,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 479.45490852311,
        ["y"] = -378.53765791727,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 400.37155591346,
        ["y"] = -307.55014805195,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 432.09455520368,
        ["y"] = -289.59334818003,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 436.2141580714,
        ["y"] = -292.6742631129,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 469.51216257298,
        ["y"] = -291.12180707608,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 465.28872705396,
        ["y"] = -287.97420099343,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 487.20712357765,
        ["y"] = -308.67965431844,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 491.22173022767,
        ["y"] = -311.58722234835,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 499.08093525129,
        ["y"] = -313.50131864925,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 491.41315346273,
        ["y"] = -306.7755719122,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 494.68493752422,
        ["y"] = -315.24157101909,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 498.41993572023,
        ["y"] = -318.28356810021,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 505.02044386707,
        ["y"] = -336.20614900772,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 482.94880988034,
        ["y"] = -360.60465081786,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 481.71980624927,
        ["y"] = -356.15152366468,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 477.56937253181,
        ["y"] = -354.76555307928,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Refreshment Vendor",
    ["id"] = 136470,
    ["count"] = 4,
    ["health"] = 48747699,
    ["scale"] = 0.7,
    ["displayId"] = 84784,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [280604] = {
        ["interruptible"] = true,
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 474.91445711306,
        ["y"] = -442.65767661818,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 481.26737457522,
        ["y"] = -442.48060946586,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 443.95268428327,
        ["y"] = -407.52601068348,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 450.1431420219,
        ["y"] = -407.73686427972,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 470.37585352586,
        ["y"] = -405.98115462049,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 463.89010972952,
        ["y"] = -394.0423701488,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 431.78275770239,
        ["y"] = -369.07242155984,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 387.30441838636,
        ["y"] = -332.49694901728,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 403.72552036223,
        ["y"] = -314.96246398218,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 413.31821539799,
        ["y"] = -282.18494344311,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 444.66997615942,
        ["y"] = -306.5704605184,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 461.27770808561,
        ["y"] = -291.51926849562,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 465.8987369465,
        ["y"] = -306.6419734134,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 471.12058524404,
        ["y"] = -310.57884359709,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 496.16805917095,
        ["y"] = -354.00658368064,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Mech Jockey",
    ["id"] = 130488,
    ["count"] = 4,
    ["health"] = 48747699,
    ["scale"] = 0.7,
    ["displayId"] = 81265,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [262019] = {
      },
      [267433] = {
      },
      [1213893] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 468.4883134763,
        ["y"] = -425.71243428727,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 476.4366721102,
        ["y"] = -405.83463110253,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 439.96988242699,
        ["y"] = -352.37041317422,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 426.09001665239,
        ["y"] = -365.68790952118,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 408.60549343732,
        ["y"] = -332.05870698153,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 387.19480984282,
        ["y"] = -339.43187006709,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 405.99260894361,
        ["y"] = -308.42396418844,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 450.87182978199,
        ["y"] = -306.87713500979,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 509.60462464217,
        ["y"] = -339.7975368244,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 478.19124403741,
        ["y"] = -360.28605207374,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 501.74629738851,
        ["y"] = -351.37471162457,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 501.55191957501,
        ["y"] = -357.91474675283,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Addled Thug",
    ["id"] = 130435,
    ["count"] = 5,
    ["health"] = 68246778,
    ["scale"] = 0.7,
    ["stealthDetect"] = true,
    ["displayId"] = 124175,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [262092] = {
        ["enrage"] = true,
      },
      [1217279] = {
      },
      [1217280] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 457.89351783597,
        ["y"] = -394.42134273981,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 428.77750168519,
        ["y"] = -396.96825786214,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 442.41376487231,
        ["y"] = -383.97830914017,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 442.14860555445,
        ["y"] = -390.81587762243,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 425.87647827849,
        ["y"] = -372.33719850928,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 414.02114823701,
        ["y"] = -335.56569422439,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 431.42108631674,
        ["y"] = -295.31063053196,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 465.83498143027,
        ["y"] = -326.58051226623,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 466.27852444155,
        ["y"] = -295.46940443925,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 509.83389416293,
        ["y"] = -333.02271848994,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Hired Assassin",
    ["id"] = 134232,
    ["count"] = 4,
    ["health"] = 43872929,
    ["scale"] = 0.7,
    ["displayId"] = 83395,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [267354] = {
      },
      [267357] = {
      },
      [269298] = {
        ["poison"] = true,
      },
      [269302] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 474.61265619304,
        ["y"] = -381.30192213517,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 429.03095795819,
        ["y"] = -403.44401889098,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 408.35539723905,
        ["y"] = -338.89023028902,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 392.62508014141,
        ["y"] = -335.78142534829,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 402.21143273968,
        ["y"] = -293.3849939406,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 448.06824000337,
        ["y"] = -301.16834896068,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 459.90182723937,
        ["y"] = -328.32506151055,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 464.56586341111,
        ["y"] = -333.1232034743,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 465.12346362786,
        ["y"] = -312.95821853523,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 482.45460699384,
        ["y"] = -339.30213682358,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 476.50131522916,
        ["y"] = -338.6494340712,
        ["g"] = 14,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 480.17205530598,
            ["y"] = -337.36467700323,
          },
          [2] = {
            ["x"] = 476.52068246009,
            ["y"] = -326.98817317658,
          },
          [3] = {
            ["x"] = 480.17205530598,
            ["y"] = -337.36467700323,
          },
          [4] = {
            ["x"] = 475.23598415969,
            ["y"] = -345.70886235539,
          },
          [5] = {
            ["x"] = 467.52744175188,
            ["y"] = -353.96799324715,
          },
          [6] = {
            ["x"] = 464.59086536178,
            ["y"] = -358.73992253512,
          },
          [7] = {
            ["x"] = 467.52744175188,
            ["y"] = -353.96799324715,
          },
          [8] = {
            ["x"] = 475.23598415969,
            ["y"] = -345.70886235539,
          },
        },
      },
      [12] = {
        ["x"] = 493.48338020612,
        ["y"] = -320.77067607754,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 485.25916255382,
        ["y"] = -314.31283880489,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 458.84206235108,
        ["y"] = -416.57350867265,
        ["g"] = 74,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 458.84206235108,
            ["y"] = -416.57350867265,
          },
          [2] = {
            ["x"] = 457.58806286568,
            ["y"] = -409.04964296771,
          },
          [3] = {
            ["x"] = 460.27517954357,
            ["y"] = -398.83866353331,
          },
          [4] = {
            ["x"] = 457.58806286568,
            ["y"] = -409.04964296771,
          },
          [5] = {
            ["x"] = 458.84206235108,
            ["y"] = -416.57350867265,
          },
          [6] = {
            ["x"] = 459.02116850907,
            ["y"] = -427.85934345551,
          },
          [7] = {
            ["x"] = 462.42483800865,
            ["y"] = -436.27892145944,
          },
          [8] = {
            ["x"] = 459.02116850907,
            ["y"] = -427.85934345551,
          },
        },
      },
      [15] = {
        ["x"] = 463.85799991978,
        ["y"] = -416.3943365588,
        ["g"] = 74,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Mechanized Peacekeeper",
    ["id"] = 136139,
    ["count"] = 8,
    ["health"] = 87745857,
    ["scale"] = 0.9,
    ["displayId"] = 82943,
    ["creatureType"] = "Mechanical",
    ["stealthDetect"] = true,
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [257371] = {
      },
      [262066] = {
      },
      [263628] = {
      },
      [472041] = {
      },
      [1217283] = {
      },
      [1227275] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 407.8943206042,
        ["y"] = -287.64261576487,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 457.36897486549,
        ["y"] = -377.15290900738,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 448.19318350928,
        ["y"] = -337.91353273354,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 419.70262241583,
        ["y"] = -352.94485534361,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 419.70262241583,
            ["y"] = -352.94485534361,
          },
          [2] = {
            ["x"] = 427.33585683062,
            ["y"] = -356.90785828564,
          },
          [3] = {
            ["x"] = 431.92424627015,
            ["y"] = -357.74211293469,
          },
          [4] = {
            ["x"] = 427.33585683062,
            ["y"] = -356.90785828564,
          },
          [5] = {
            ["x"] = 419.70262241583,
            ["y"] = -352.94485534361,
          },
          [6] = {
            ["x"] = 417.45513080391,
            ["y"] = -345.52596646605,
          },
          [7] = {
            ["x"] = 420.20818083868,
            ["y"] = -336.28360369571,
          },
          [8] = {
            ["x"] = 417.45513080391,
            ["y"] = -345.52596646605,
          },
        },
      },
      [5] = {
        ["x"] = 448.70965034998,
        ["y"] = -319.57268684127,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 448.70965034998,
            ["y"] = -319.57268684127,
          },
          [2] = {
            ["x"] = 453.39513359342,
            ["y"] = -320.19734517176,
          },
          [3] = {
            ["x"] = 462.38841348001,
            ["y"] = -318.9125783092,
          },
          [4] = {
            ["x"] = 471.74875562076,
            ["y"] = -320.56440742593,
          },
          [5] = {
            ["x"] = 475.60300723548,
            ["y"] = -324.96926711379,
          },
          [6] = {
            ["x"] = 471.74875562076,
            ["y"] = -320.56440742593,
          },
          [7] = {
            ["x"] = 462.38841348001,
            ["y"] = -318.9125783092,
          },
          [8] = {
            ["x"] = 453.39513359342,
            ["y"] = -320.19734517176,
          },
          [9] = {
            ["x"] = 443.3871301294,
            ["y"] = -319.57268684127,
          },
          [10] = {
            ["x"] = 436.14273750697,
            ["y"] = -317.44429011415,
          },
          [11] = {
            ["x"] = 443.3871301294,
            ["y"] = -319.57268684127,
          },
        },
      },
    },
  },
  [8] = {
    ["name"] = "Coin-Operated Crowd Pummeler",
    ["id"] = 129214,
    ["count"] = 0,
    ["health"] = 487202475,
    ["scale"] = 1.5,
    ["displayId"] = 80443,
    ["creatureType"] = "Mechanical",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2109,
    ["instanceID"] = 1012,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [262347] = {
      },
      [267547] = {
      },
      [267551] = {
      },
      [269493] = {
      },
      [271903] = {
      },
      [1217294] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 385.47131010469,
        ["y"] = -266.50855813365,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Venture Co. Earthshaper",
    ["id"] = 130661,
    ["count"] = 6,
    ["health"] = 43872929,
    ["scale"] = 0.7,
    ["displayId"] = 81333,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [263202] = {
        ["interruptible"] = true,
      },
      [268722] = {
      },
      [271579] = {
        ["interruptible"] = true,
      },
      [1215934] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 343.33040183351,
        ["y"] = -246.11007011266,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 323.18476331641,
        ["y"] = -251.64736967736,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 312.2133586546,
        ["y"] = -262.67289198605,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 312.2133586546,
            ["y"] = -262.67289198605,
          },
          [2] = {
            ["x"] = 321.01251809565,
            ["y"] = -262.47528328658,
          },
          [3] = {
            ["x"] = 328.74037632129,
            ["y"] = -259.57735900531,
          },
          [4] = {
            ["x"] = 321.01251809565,
            ["y"] = -262.47528328658,
          },
          [5] = {
            ["x"] = 297.34596677823,
            ["y"] = -262.23378207869,
          },
        },
      },
      [4] = {
        ["x"] = 315.1441629175,
        ["y"] = -278.08318943849,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 318.25917651156,
        ["y"] = -283.58933026928,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 298.25183355966,
        ["y"] = -234.80245202277,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 294.29474689384,
        ["y"] = -243.41784901305,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 283.66744502225,
        ["y"] = -267.27027960346,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 269.43758224595,
        ["y"] = -255.19989023983,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 252.55951264509,
        ["y"] = -267.54272299112,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 276.72064296069,
        ["y"] = -234.98037279258,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 240.60794131556,
        ["y"] = -173.64620368888,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 247.77032186939,
        ["y"] = -173.37801834837,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Mine Rat",
    ["id"] = 130437,
    ["count"] = 2,
    ["health"] = 24373849,
    ["scale"] = 0.6,
    ["displayId"] = 114158,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [263209] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 340.82771872649,
        ["y"] = -240.75832585581,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 337.47426054162,
        ["y"] = -245.2115981618,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 342.14239851644,
        ["y"] = -267.81339388825,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 318.46094462565,
        ["y"] = -244.91747011491,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 317.57039332375,
        ["y"] = -250.77217903569,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 283.77294553134,
        ["y"] = -261.07327422562,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 269.35433572721,
        ["y"] = -249.05547449329,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 264.92688066443,
        ["y"] = -251.63664205968,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 252.84564960245,
        ["y"] = -261.53062564883,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 253.15632563894,
        ["y"] = -273.74414358775,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Wanton Sapper",
    ["id"] = 130653,
    ["count"] = 4,
    ["health"] = 48747699,
    ["scale"] = 0.7,
    ["displayId"] = 81316,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [268362] = {
      },
      [268712] = {
      },
      [269313] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 340.85570142002,
        ["y"] = -273.81037399344,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 324.62177600523,
        ["y"] = -245.39208079451,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 307.09041525916,
        ["y"] = -259.08836336264,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 306.69693574404,
        ["y"] = -265.88973006786,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 321.42440805972,
        ["y"] = -278.05536993656,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 307.03441596362,
        ["y"] = -238.53253360109,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 303.30608041968,
        ["y"] = -246.38278286178,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 270.65421387506,
        ["y"] = -275.80203549396,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 276.18028886106,
        ["y"] = -279.64660326283,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 274.46563271449,
        ["y"] = -241.42709313018,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 254.38295141553,
        ["y"] = -173.1950670296,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 261.31505479946,
        ["y"] = -172.98628270248,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Azerite Extractor",
    ["id"] = 136643,
    ["count"] = 16,
    ["health"] = 92620627,
    ["scale"] = 0.9,
    ["displayId"] = 84881,
    ["creatureType"] = "Mechanical",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [473168] = {
      },
      [473177] = {
      },
      [473198] = {
      },
      [1215411] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 353.33023138942,
        ["y"] = -250.67333666109,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 347.42177886577,
        ["y"] = -271.97565041496,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 300.79888879784,
        ["y"] = -241.76473810219,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 290.03836414224,
        ["y"] = -263.69713945507,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 246.47643634547,
        ["y"] = -263.13877035876,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 246.19269160708,
        ["y"] = -272.01944911021,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 281.84452045555,
        ["y"] = -239.8371456994,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Safety Shark",
    ["id"] = 137940,
    ["count"] = 4,
    ["health"] = 194990795,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 12207,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["spells"] = {
      [257478] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 291.83653776924,
        ["y"] = -193.78192458608,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 307.59037435544,
        ["y"] = -180.29825453032,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 320.4472979875,
        ["y"] = -168.11496885548,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 332.13981462313,
        ["y"] = -179.92295140802,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 319.82174208071,
        ["y"] = -192.97234076233,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 306.59914568448,
        ["y"] = -206.66651650773,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 346.70015962458,
        ["y"] = -191.50001432653,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 333.37162589099,
        ["y"] = -204.77067521559,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 319.87953165339,
        ["y"] = -219.42721018702,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Shalebiter",
    ["id"] = 134005,
    ["count"] = 1,
    ["health"] = 9749540,
    ["scale"] = 0.6,
    ["displayId"] = 127834,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Silence"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [263262] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 282.5468080948,
        ["y"] = -223.54387406195,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 284.0103950003,
        ["y"] = -217.58080206318,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 276.73356100816,
        ["y"] = -225.47822327467,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 258.83810167732,
        ["y"] = -200.64374502275,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 253.89354345794,
        ["y"] = -203.55309340064,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 264.65991402622,
        ["y"] = -200.47027135016,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Stonefury",
    ["id"] = 130635,
    ["count"] = 4,
    ["health"] = 48747699,
    ["scale"] = 0.7,
    ["displayId"] = 127697,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [263215] = {
        ["interruptible"] = true,
        ["magic"] = true,
      },
      [268702] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 273.57394090336,
        ["y"] = -213.32459113941,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 261.61036330994,
        ["y"] = -207.95882959492,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 254.31604570071,
        ["y"] = -189.99121090403,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Taskmaster Askari",
    ["id"] = 134012,
    ["count"] = 20,
    ["health"] = 97495397,
    ["scale"] = 0.9,
    ["displayId"] = 83286,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [263586] = {
      },
      [263601] = {
      },
      [1213139] = {
        ["enrage"] = true,
      },
      [1213140] = {
      },
      [1213141] = {
      },
      [1214751] = {
      },
      [1214752] = {
      },
      [1214754] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 252.27721245761,
        ["y"] = -166.15265229985,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Azerokk",
    ["id"] = 129227,
    ["count"] = 0,
    ["health"] = 306937559,
    ["scale"] = 1.5,
    ["displayId"] = 83891,
    ["creatureType"] = "Elemental",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2114,
    ["instanceID"] = 1012,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [257593] = {
      },
      [257596] = {
      },
      [257597] = {
      },
      [258622] = {
      },
      [258628] = {
      },
      [271698] = {
      },
      [275907] = {
      },
      [471894] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 258.95380009198,
        ["y"] = -139.91423682889,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Earthrager",
    ["id"] = 129802,
    ["count"] = 0,
    ["health"] = 81246165,
    ["scale"] = 1.2,
    ["displayId"] = 124456,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [257544] = {
        ["bleed"] = true,
      },
      [257582] = {
      },
      [258627] = {
      },
      [271526] = {
      },
      [1213142] = {
      },
      [1214673] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 279.03390733102,
        ["y"] = -141.49408983987,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 278.26917586144,
        ["y"] = -125.93412116757,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Footbomb Hooligan",
    ["id"] = 138369,
    ["count"] = 0,
    ["health"] = 9749540,
    ["scale"] = 1,
    ["displayId"] = 85829,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["spells"] = {
      [271784] = {
      },
      [278702] = {
      },
      [278706] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 350.19296026467,
        ["y"] = -308.21449351379,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 359.07097438119,
        ["y"] = -303.630628542,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 367.29040140384,
        ["y"] = -308.4516111064,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Venture Co. Mastermind",
    ["id"] = 133430,
    ["count"] = 10,
    ["health"] = 77996318,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 83136,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [262794] = {
      },
      [268880] = {
      },
      [473304] = {
      },
      [1214748] = {
      },
      [1215424] = {
      },
      [1215916] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 430.43629874428,
        ["y"] = -114.66788405428,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 406.79096043129,
        ["y"] = -170.42175532734,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 430.5097010572,
        ["y"] = -124.09783120737,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 386.50890466006,
        ["y"] = -131.46991629516,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 384.84758965854,
            ["y"] = -131.62814119434,
          },
          [2] = {
            ["x"] = 390.75563303921,
            ["y"] = -129.54052013219,
          },
          [3] = {
            ["x"] = 396.31004483198,
            ["y"] = -125.43508981149,
          },
          [4] = {
            ["x"] = 400.41547515269,
            ["y"] = -122.77861518761,
          },
          [5] = {
            ["x"] = 396.31004483198,
            ["y"] = -125.43508981149,
          },
          [6] = {
            ["x"] = 390.75563303921,
            ["y"] = -129.54052013219,
          },
          [7] = {
            ["x"] = 376.99869768678,
            ["y"] = -132.71324114061,
          },
          [8] = {
            ["x"] = 368.77122246335,
            ["y"] = -133.50434030567,
          },
          [9] = {
            ["x"] = 376.99869768678,
            ["y"] = -132.71324114061,
          },
        },
      },
      [5] = {
        ["x"] = 383.50899298769,
        ["y"] = -103.4107860461,
        ["g"] = 52,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 384.22098392497,
            ["y"] = -103.64811072945,
          },
          [2] = {
            ["x"] = 372.04232314397,
            ["y"] = -102.55236853056,
          },
          [3] = {
            ["x"] = 366.10904563156,
            ["y"] = -102.39414363138,
          },
          [4] = {
            ["x"] = 359.85931832078,
            ["y"] = -107.77364666208,
          },
          [5] = {
            ["x"] = 366.10904563156,
            ["y"] = -102.39414363138,
          },
          [6] = {
            ["x"] = 372.04232314397,
            ["y"] = -102.55236853056,
          },
          [7] = {
            ["x"] = 391.50347912635,
            ["y"] = -104.45101665904,
          },
          [8] = {
            ["x"] = 398.93986362833,
            ["y"] = -105.63767385025,
          },
          [9] = {
            ["x"] = 391.50347912635,
            ["y"] = -104.45101665904,
          },
        },
      },
      [6] = {
        ["x"] = 353.29062621837,
        ["y"] = -90.350527845502,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 345.95277005503,
        ["y"] = -95.136493770841,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Weapons Tester",
    ["id"] = 136934,
    ["count"] = 5,
    ["health"] = 48747699,
    ["scale"] = 0.8,
    ["displayId"] = 84962,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [268846] = {
        ["magic"] = true,
      },
      [268865] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 430.45184449463,
        ["y"] = -106.29695403811,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 348.05398353752,
        ["y"] = -159.73556640532,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 379.72789598865,
        ["y"] = -173.26607278664,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 412.2854056885,
        ["y"] = -147.91590191231,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 409.6990629535,
        ["y"] = -100.52034432217,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 414.45061329983,
        ["y"] = -105.81324483182,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 393.94062282956,
        ["y"] = -92.581125876376,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 345.99572275873,
        ["y"] = -86.930782855355,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 345.44580431912,
        ["y"] = -111.92598747375,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 391.73774066135,
        ["y"] = -151.8349299412,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
    },
  },
  [22] = {
    ["name"] = "Venture Co. Alchemist",
    ["id"] = 133432,
    ["count"] = 3,
    ["health"] = 48747699,
    ["scale"] = 0.8,
    ["displayId"] = 82915,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [262268] = {
        ["interruptible"] = true,
      },
      [262270] = {
        ["poison"] = true,
      },
      [268797] = {
        ["interruptible"] = true,
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 430.75642019882,
        ["y"] = -132.73490700289,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 355.27158048618,
        ["y"] = -159.63245220263,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 363.75208606276,
        ["y"] = -140.12020842839,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 368.87253017379,
        ["y"] = -155.96019515453,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 373.07153657217,
        ["y"] = -162.31295982655,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 376.27503773457,
        ["y"] = -179.83432666924,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 383.24094722657,
        ["y"] = -179.82206770681,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 400.69211738709,
        ["y"] = -177.68746831748,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 413.29720349249,
        ["y"] = -178.11309221576,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 412.34550925882,
        ["y"] = -154.74854673865,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 413.48186015221,
        ["y"] = -131.40295309618,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 409.70071964973,
        ["y"] = -137.01392265959,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 407.0008401608,
        ["y"] = -131.16747124717,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 407.7142272701,
        ["y"] = -107.43719655079,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 362.60423942002,
        ["y"] = -122.41370709889,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 370.1225840693,
        ["y"] = -89.934668451085,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 386.72308737136,
        ["y"] = -89.212896689548,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 389.58424353948,
        ["y"] = -145.21237796169,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 395.90578955763,
        ["y"] = -146.1386210858,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
    },
  },
  [23] = {
    ["name"] = "Test Subject",
    ["id"] = 133963,
    ["count"] = 1,
    ["health"] = 9749540,
    ["scale"] = 0.5,
    ["displayId"] = 1141,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [268810] = {
      },
      [268815] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 335.43701108942,
        ["y"] = -111.9923341959,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 363.0303400108,
        ["y"] = -134.40628303499,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 359.18095853378,
        ["y"] = -136.57155278031,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 367.42103633957,
        ["y"] = -135.42877612118,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 358.27876403311,
        ["y"] = -141.14271205518,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 369.10513149436,
        ["y"] = -139.45860326341,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 413.50331590862,
        ["y"] = -166.65656507425,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 399.89819467477,
        ["y"] = -166.74078726642,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 413.25072815301,
        ["y"] = -171.52847352905,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 400.0184215669,
        ["y"] = -171.49237071316,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 406.77892609065,
        ["y"] = -178.58967560752,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 406.72784404594,
        ["y"] = -148.68578583679,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 406.38220582111,
        ["y"] = -153.47343864852,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 418.37219696377,
        ["y"] = -155.85525655305,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 418.05941496315,
        ["y"] = -151.16381935799,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 417.7105705807,
        ["y"] = -146.508443664,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 383.71568319904,
        ["y"] = -117.12081090474,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 392.13621705422,
        ["y"] = -117.06066684318,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 387.68538207444,
        ["y"] = -117.12083367438,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 385.64037505554,
        ["y"] = -120.78976251126,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 389.54989099214,
        ["y"] = -120.97020214017,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 357.19106689176,
        ["y"] = -122.95507819787,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 358.39399349233,
        ["y"] = -118.4440699595,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 362.54413865869,
        ["y"] = -116.5795323923,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 366.69422519632,
        ["y"] = -118.68465745031,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 335.47010415499,
        ["y"] = -116.2823046842,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 335.47008694759,
        ["y"] = -106.94242045339,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 339.85219491695,
        ["y"] = -107.15724714128,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 339.75765649925,
        ["y"] = -111.77991866776,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 339.7404690247,
        ["y"] = -116.26513298099,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 391.91802018555,
        ["y"] = -109.73619735251,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 394.03512970083,
        ["y"] = -107.29337326111,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 395.9079576877,
        ["y"] = -104.76912492937,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 396.80365075359,
        ["y"] = -107.61908783723,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 394.76797428603,
        ["y"] = -110.46904193772,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
    },
  },
  [24] = {
    ["name"] = "Rixxa Fluxflame",
    ["id"] = 129231,
    ["count"] = 0,
    ["health"] = 306937559,
    ["scale"] = 1.5,
    ["displayId"] = 81489,
    ["creatureType"] = "Humanoid",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2115,
    ["instanceID"] = 1012,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [259474] = {
      },
      [259853] = {
        ["magic"] = true,
      },
      [259856] = {
      },
      [259940] = {
      },
      [270042] = {
      },
      [275992] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 471.2950406349,
        ["y"] = -111.09453249933,
        ["sublevel"] = 1,
      },
    },
  },
  [25] = {
    ["name"] = "Venture Co. War Machine",
    ["id"] = 133463,
    ["count"] = 22,
    ["health"] = 92620627,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 83391,
    ["creatureType"] = "Mechanical",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [262383] = {
      },
      [269099] = {
      },
      [269100] = {
      },
      [269429] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 507.54569188875,
        ["y"] = -127.31902291164,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 506.52131549527,
        ["y"] = -110.75733552797,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 583.74652469106,
        ["y"] = -135.79036460663,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 585.88409083369,
        ["y"] = -118.08818221549,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 568.4055970571,
        ["y"] = -145.83751584548,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 602.63474414813,
        ["y"] = -184.07304499536,
        ["g"] = 67,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 615.07308597277,
        ["y"] = -184.33767875485,
        ["g"] = 67,
        ["sublevel"] = 1,
      },
    },
  },
  [26] = {
    ["name"] = "Ordnance Specialist",
    ["id"] = 137029,
    ["count"] = 5,
    ["health"] = 38998159,
    ["scale"] = 0.8,
    ["displayId"] = 85024,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [269090] = {
      },
      [269092] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 501.39908264447,
        ["y"] = -133.75929871716,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 518.64374610435,
        ["y"] = -106.31814800669,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 518.81446011364,
        ["y"] = -114.68435793695,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 545.74849486773,
        ["y"] = -106.60843139191,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 558.38317830997,
        ["y"] = -117.19423277436,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 584.43285788726,
        ["y"] = -151.94227406383,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
    },
  },
  [27] = {
    ["name"] = "Mogul Razdunk",
    ["id"] = 129232,
    ["count"] = 0,
    ["health"] = 341041732,
    ["scale"] = 1.5,
    ["displayId"] = 127820,
    ["creatureType"] = "Mechanical",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2116,
    ["instanceID"] = 1012,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [260189] = {
      },
      [260190] = {
      },
      [260202] = {
      },
      [260280] = {
      },
      [260318] = {
      },
      [260323] = {
      },
      [260811] = {
      },
      [260813] = {
      },
      [270926] = {
      },
      [271456] = {
      },
      [276212] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 581.07385661522,
        ["y"] = -209.65037620789,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
    },
  },
  [28] = {
    ["name"] = "Crawler Mine",
    ["id"] = 133482,
    ["count"] = 1,
    ["health"] = 9749540,
    ["scale"] = 0.5,
    ["displayId"] = 127835,
    ["creatureType"] = "Mechanical",
    ["level"] = 81,
    ["characteristics"] = {
      ["Root"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [262348] = {
      },
      [262377] = {
      },
      [1217689] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 523.97757643873,
        ["y"] = -110.15635022701,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 522.67000629425,
        ["y"] = -91.932912844251,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 512.15565072751,
        ["y"] = -97.951957597177,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 521.546287837,
        ["y"] = -123.90426362279,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 534.86393812169,
        ["y"] = -110.41589009503,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 541.99228803956,
        ["y"] = -95.168930690175,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 547.83833118603,
        ["y"] = -112.925756741,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 551.21212975138,
        ["y"] = -100.46182424315,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 547.62658152986,
        ["y"] = -131.34979603288,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 568.28600533179,
        ["y"] = -107.63286066667,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 560.56173099766,
        ["y"] = -110.97248321372,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 554.28534662101,
        ["y"] = -126.24338174589,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 580.91424358164,
        ["y"] = -109.16375208044,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 592.02592788497,
        ["y"] = -109.93552045932,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 592.81138057589,
        ["y"] = -125.65028629827,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 600.07796299853,
        ["y"] = -118.36999308471,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 602.80977496567,
        ["y"] = -135.10238986078,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 578.59703773238,
        ["y"] = -128.7017107377,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 590.91656561722,
        ["y"] = -150.06530840805,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 570.6182361845,
        ["y"] = -154.32609582558,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 559.90010408157,
        ["y"] = -147.97460788209,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 604.6251800748,
        ["y"] = -155.25234099164,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 595.75950967928,
        ["y"] = -160.80989786207,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 608.59481039352,
        ["y"] = -146.38673500169,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 614.81398424403,
        ["y"] = -153.13518311459,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 611.10893201806,
        ["y"] = -163.72098681218,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 620.10690577231,
        ["y"] = -169.6755074301,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 603.16957119417,
        ["y"] = -171.66034763607,
        ["sublevel"] = 1,
      },
    },
  },
  [29] = {
    ["name"] = "Mechanized Peacekeeper",
    ["id"] = 130485,
    ["count"] = 8,
    ["health"] = 87745857,
    ["scale"] = 0.7,
    ["displayId"] = 82943,
    ["iconTexture"] = 133001,
    ["creatureType"] = "Mechanical",
    ["stealthDetect"] = true,
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [257371] = {
      },
      [262066] = {
      },
      [263628] = {
      },
      [267367] = {
      },
      [472041] = {
      },
      [1217283] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 460.18335503151,
        ["y"] = -458.3487362116,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 447.50631627087,
        ["y"] = -424.337096457,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 455.63999045776,
        ["y"] = -337.36593203641,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 441.05247868955,
        ["y"] = -337.48612905226,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 465.66378619597,
        ["y"] = -345.95437946839,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 431.46201278744,
        ["y"] = -331.88489484204,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 431.05438196836,
        ["y"] = -341.55118637732,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 474.92789633713,
        ["y"] = -459.10487806872,
        ["sublevel"] = 1,
      },
    },
  },
  [30] = {
    ["name"] = "Venture Co. Skyscorcher",
    ["id"] = 132056,
    ["count"] = 0,
    ["health"] = 28436157,
    ["scale"] = 1.6,
    ["displayId"] = 82922,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [260372] = {
      },
      [262513] = {
      },
      [262515] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 572.07421450663,
        ["y"] = -227.46849349805,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 591.52285444858,
        ["y"] = -227.10211590669,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
    },
  },
  [31] = {
    ["name"] = "B.O.O.M.B.A.",
    ["id"] = 141303,
    ["count"] = 0,
    ["health"] = 100000,
    ["scale"] = 1.6,
    ["displayId"] = 127819,
    ["creatureType"] = "Mechanical",
    ["level"] = 81,
    ["spells"] = {
      [276229] = {
      },
      [276234] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 600.01952806442,
        ["y"] = -208.93440409068,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 560.61938318541,
        ["y"] = -209.65113990346,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
    },
  },
  [32] = {
    ["name"] = "Azerite Footbomb",
    ["id"] = 129246,
    ["count"] = 0,
    ["health"] = 9744049,
    ["scale"] = 1,
    ["displayId"] = 85701,
    ["creatureType"] = "Not specified",
    ["level"] = 81,
    ["spells"] = {
      [256137] = {
      },
      [256493] = {
      },
      [270882] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 374.91669117438,
        ["y"] = -281.53326956665,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 402.52614196798,
        ["y"] = -262.85924259349,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 368.81946075069,
        ["y"] = -273.70194544248,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 362.69101034036,
        ["y"] = -265.6877532646,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 388.61920116629,
        ["y"] = -247.53805283001,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 396.63336784913,
        ["y"] = -254.37362134748,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
    },
  },
};
