local addonName = ...
local MDT = MDT
local L = MDT.L

local dungeonIndex = 118
MDT.dungeonList[dungeonIndex] = L["The Rookery"]
MDT.mapInfo[dungeonIndex] = {
  teleportId = 445443, --TODO
  shortName = L["rookeryShortname"],
  englishName = "The Rookery",
  mapID = 500
}

local zones = { 2315, 2316, 2317, 2318, 2319, 2320 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "",
  [1] = { customTextures = 'Interface\\AddOns\\'..addonName..'\\TheWarWithin\\Textures\\TheRookery' }
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["The Rookery"]
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 992 }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dungeonEntrance",
      ["x"] = 772.56443910914,
      ["y"] = -173.23866427385,
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "rookItem",
      ["x"] = 420.61427161837,
      ["y"] = -172.67749506966,
    },
  },
};



MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Quartermaster Koratite",
    ["id"] = 209801,
    ["count"] = 20,
    ["health"] = 77952395,
    ["scale"] = 2,
    ["displayId"] = 114849,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [426893] = {
      },
      [426968] = {
      },
      [430125] = {
      },
      [450628] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 690.64007049612,
        ["y"] = -175.64842098296,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Cursed Thunderer",
    ["id"] = 207198,
    ["count"] = 10,
    ["health"] = 43848222,
    ["scale"] = 1.5,
    ["displayId"] = 118407,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [430109] = {
        ["interruptible"] = true,
      },
      [469956] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 470.49782548194,
        ["y"] = -247.11886122194,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 666.91300329419,
        ["y"] = -199.11203741964,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 666.30402173107,
        ["y"] = -151.46756950481,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 689.52019799575,
        ["y"] = -222.42701997218,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 425.3056398841,
        ["y"] = -206.44886520213,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 482.38680122193,
        ["y"] = -244.68537744545,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 475.17356789759,
        ["y"] = -234.3301884479,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 423.39794566916,
        ["y"] = -140.89715109138,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 357.2226311031,
        ["y"] = -118.26888211161,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 372.37785333456,
        ["y"] = -105.41435604821,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Cursed Rookguard",
    ["id"] = 207197,
    ["count"] = 10,
    ["health"] = 51156260,
    ["scale"] = 1.5,
    ["displayId"] = 118393,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [469956] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 472.18944883011,
        ["y"] = -112.98919815633,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 706.32458737274,
        ["y"] = -125.85645978089,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 706.88573458556,
        ["y"] = -141.00520644269,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 721.07667524331,
        ["y"] = -140.53242863153,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 720.39520772482,
        ["y"] = -126.18421887484,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 666.52434084525,
        ["y"] = -184.70384497514,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 665.80545306708,
        ["y"] = -164.6631625804,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 425.16410120138,
        ["y"] = -221.96659198668,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 434.38748582376,
        ["y"] = -247.38467057047,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 370.05365013093,
        ["y"] = -233.19112647973,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 411.54407394391,
        ["y"] = -98.347636963755,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 106.08128961915,
        ["y"] = -129.84227052513,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 78.885964482909,
        ["y"] = -170.5272188803,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 77.614633506562,
        ["y"] = -247.85533278875,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 141.86068741488,
        ["y"] = -252.44473887038,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 426.32077248339,
        ["y"] = -126.05699006784,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 424.72235219084,
        ["y"] = -85.403681864648,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 119.53361995307,
        ["y"] = -130.08372265478,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 64.810702853709,
        ["y"] = -170.51153460927,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 71.60306714823,
        ["y"] = -117.38728996736,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 371.29826495332,
        ["y"] = -118.21959071366,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 358.38131754839,
        ["y"] = -103.46401016036,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Voidrider",
    ["id"] = 212786,
    ["count"] = 25,
    ["health"] = 87696445,
    ["scale"] = 2,
    ["displayId"] = 117707,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [427404] = {
      },
      [427439] = {
      },
      [474017] = {
      },
      [474018] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 439.04046332515,
        ["y"] = -213.05220556448,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 439.04046332515,
            ["y"] = -213.05220556448,
          },
          [2] = {
            ["x"] = 451.38824247791,
            ["y"] = -202.62013965826,
          },
          [3] = {
            ["x"] = 439.04046332515,
            ["y"] = -213.05220556448,
          },
          [4] = {
            ["x"] = 412.49567847642,
            ["y"] = -213.93436584406,
          },
          [5] = {
            ["x"] = 399.76715884387,
            ["y"] = -209.6915461979,
          },
          [6] = {
            ["x"] = 385.97803039874,
            ["y"] = -200.49878041358,
          },
          [7] = {
            ["x"] = 380.67450078321,
            ["y"] = -195.54881404405,
          },
          [8] = {
            ["x"] = 383.90773695449,
            ["y"] = -199.28081153744,
          },
          [9] = {
            ["x"] = 385.97803039874,
            ["y"] = -200.49878041358,
          },
          [10] = {
            ["x"] = 399.76715884387,
            ["y"] = -209.6915461979,
          },
          [11] = {
            ["x"] = 412.49567847642,
            ["y"] = -213.93436584406,
          },
        },
      },
      [2] = {
        ["x"] = 669.93095129105,
        ["y"] = -223.53048186704,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 437.26216219556,
        ["y"] = -137.44932420787,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 437.26216219556,
            ["y"] = -137.44932420787,
          },
          [2] = {
            ["x"] = 447.62433544774,
            ["y"] = -140.51752250204,
          },
          [3] = {
            ["x"] = 455.75645195677,
            ["y"] = -148.29599483962,
          },
          [4] = {
            ["x"] = 447.62433544774,
            ["y"] = -140.51752250204,
          },
          [5] = {
            ["x"] = 437.26216219556,
            ["y"] = -137.44932420787,
          },
          [6] = {
            ["x"] = 421.46033154151,
            ["y"] = -133.09253248503,
          },
          [7] = {
            ["x"] = 409.79254210971,
            ["y"] = -132.73896923902,
          },
          [8] = {
            ["x"] = 400.24617261666,
            ["y"] = -135.56753590115,
          },
          [9] = {
            ["x"] = 388.93202735629,
            ["y"] = -143.34600823873,
          },
          [10] = {
            ["x"] = 400.24617261666,
            ["y"] = -135.56753590115,
          },
          [11] = {
            ["x"] = 409.79254210971,
            ["y"] = -132.73896923902,
          },
          [12] = {
            ["x"] = 421.46033154151,
            ["y"] = -133.09253248503,
          },
        },
      },
    },
  },
  [5] = {
    ["name"] = "Unruly Stormrook",
    ["id"] = 207186,
    ["count"] = 12,
    ["health"] = 53592272,
    ["scale"] = 1.7,
    ["displayId"] = 117707,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [427616] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 410.99037985837,
        ["y"] = -85.159377200837,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 485.18042202558,
        ["y"] = -106.0053923532,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 422.18261827332,
        ["y"] = -263.3353105055,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 357.86485962172,
        ["y"] = -245.27574372792,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Cursed Rooktender",
    ["id"] = 207199,
    ["count"] = 10,
    ["health"] = 36540186,
    ["scale"] = 1.5,
    ["displayId"] = 114851,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [427260] = {
        ["interruptible"] = true,
        ["enrage"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 372.17645350564,
        ["y"] = -245.95492301165,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 483.30233490145,
        ["y"] = -121.14977760359,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 421.98803724414,
        ["y"] = -250.36111200284,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 356.32886270814,
        ["y"] = -231.52532084921,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 424.64276805435,
        ["y"] = -99.674235909649,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Void-Cursed Crusher",
    ["id"] = 214419,
    ["count"] = 15,
    ["health"] = 58464296,
    ["scale"] = 1.5,
    ["displayId"] = 117972,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [467907] = {
      },
      [474031] = {
      },
      [474032] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 63.79404989058,
        ["y"] = -129.48773174911,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 293.16513086734,
        ["y"] = -346.55038272979,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 148.57262524249,
        ["y"] = -319.76209704486,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 135.96484686125,
        ["y"] = -263.60798127659,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 65.145448319652,
        ["y"] = -247.78115097886,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 72.484532613045,
        ["y"] = -306.46986575395,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 79.100712786295,
        ["y"] = -319.62069171996,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 149.44689239487,
        ["y"] = -264.33451440999,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 107.27817161051,
        ["y"] = -245.63132228958,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 175.81739598212,
        ["y"] = -243.35362901213,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 174.1759128216,
        ["y"] = -279.51420407261,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 549.81163360808,
        ["y"] = -297.193369821,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 560.12369237033,
        ["y"] = -287.86692373834,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 653.58703005777,
        ["y"] = -338.21519141208,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 664.64769997148,
        ["y"] = -348.58530184032,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 598.34924078591,
        ["y"] = -439.37111209251,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 599.17551148197,
        ["y"] = -410.40384837466,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 293.16513086734,
        ["y"] = -370.73429246875,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 652.55839265014,
        ["y"] = -532.34188520682,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 672.46602346427,
        ["y"] = -532.63518781249,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Corrupted Oracle",
    ["id"] = 214439,
    ["count"] = 12,
    ["health"] = 38976198,
    ["scale"] = 1.5,
    ["displayId"] = 119838,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [430179] = {
        ["curse"] = true,
      },
      [430238] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 128.49622470293,
        ["y"] = -252.12755677303,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 77.50611180114,
        ["y"] = -129.70164073841,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 72.308988137129,
        ["y"] = -158.5057585789,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 64.431286715032,
        ["y"] = -261.79560708023,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 154.47296651572,
        ["y"] = -252.17080119867,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Coalescing Void Diffuser",
    ["id"] = 214421,
    ["count"] = 25,
    ["health"] = 73080370,
    ["scale"] = 1.5,
    ["stealthDetect"] = true,
    ["displayId"] = 117974,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [430805] = {
      },
      [430812] = {
      },
      [430814] = {
      },
      [430834] = {
      },
      [452932] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 135.80123443845,
        ["y"] = -217.28766589943,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 112.28967634034,
        ["y"] = -142.14062091182,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 77.355035657422,
        ["y"] = -262.4598830873,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 65.330703342705,
        ["y"] = -319.35450918058,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 149.67606504793,
        ["y"] = -216.93300583418,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Afflicted Civilian",
    ["id"] = 219066,
    ["count"] = 1,
    ["health"] = 9744049,
    ["scale"] = 1,
    ["displayId"] = 121686,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [443847] = {
      },
      [443854] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 571.13735217717,
        ["y"] = -347.74424974281,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 339.26861172281,
        ["y"] = -507.65317113251,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 339.66878957137,
        ["y"] = -517.53321166545,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 348.55584751581,
        ["y"] = -507.1687336791,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 349.09070915165,
        ["y"] = -517.49275444275,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 269.46137387784,
        ["y"] = -505.09838465637,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 270.08699231259,
        ["y"] = -515.76063148317,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 279.27690587053,
        ["y"] = -504.97358313571,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 279.69914023388,
        ["y"] = -515.67838609962,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 575.38997516058,
        ["y"] = -338.87406134333,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 584.26009361289,
        ["y"] = -338.85580348126,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 566.35555562918,
        ["y"] = -339.49463873732,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 580.22651821089,
        ["y"] = -347.12358560701,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 612.38768574636,
        ["y"] = -338.59337017421,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 616.15413308777,
        ["y"] = -345.313188691,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 628.93011463138,
        ["y"] = -337.98773896822,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 620.78736419016,
        ["y"] = -337.71401693268,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 624.8254399831,
        ["y"] = -344.7873639126,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 648.78416356048,
        ["y"] = -519.58185298239,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 675.6262887196,
        ["y"] = -519.54274022742,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 626.64387523269,
        ["y"] = -312.70273227808,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 671.50511602731,
        ["y"] = -509.65724127319,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 661.75550136062,
        ["y"] = -506.16397907799,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 651.89915249491,
        ["y"] = -510.84462800436,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 655.36597851549,
        ["y"] = -312.73371847125,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 657.40050788527,
        ["y"] = -379.2427105507,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 658.66216368731,
        ["y"] = -408.08676070382,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 643.26100217832,
        ["y"] = -393.89445640258,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 671.30377080958,
        ["y"] = -394.01607135631,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 667.42185051804,
        ["y"] = -384.45379299394,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 647.53566164892,
        ["y"] = -404.69024638357,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 668.51494957046,
        ["y"] = -403.41838187045,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 647.39431809348,
        ["y"] = -383.22576397094,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 667.3785782928,
        ["y"] = -428.96870149689,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 657.72680490428,
        ["y"] = -428.81303522867,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 648.41751366326,
        ["y"] = -428.75075484988,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 653.21225516911,
        ["y"] = -436.69011741023,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 662.58383036612,
        ["y"] = -436.12968409182,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 610.13253200041,
        ["y"] = -416.94213232012,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 610.17447232664,
        ["y"] = -424.98926146799,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 610.25828971244,
        ["y"] = -432.9226537044,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 610.24030206387,
        ["y"] = -441.65832736881,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [43] = {
        ["x"] = 610.51570824221,
        ["y"] = -408.54775973274,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [44] = {
        ["x"] = 653.20324133799,
        ["y"] = -487.31430638704,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [45] = {
        ["x"] = 612.42559420071,
        ["y"] = -497.29673982693,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [46] = {
        ["x"] = 612.21683953101,
        ["y"] = -506.81468117429,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [47] = {
        ["x"] = 612.03673075692,
        ["y"] = -516.64445275811,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [48] = {
        ["x"] = 612.92801157966,
        ["y"] = -526.15053305802,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [49] = {
        ["x"] = 612.29755515243,
        ["y"] = -535.67774809327,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [50] = {
        ["x"] = 662.35787376654,
        ["y"] = -486.42630720912,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [51] = {
        ["x"] = 655.2571054048,
        ["y"] = -460.39721618518,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [52] = {
        ["x"] = 669.09486835649,
        ["y"] = -480.0747031391,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [53] = {
        ["x"] = 645.7038923831,
        ["y"] = -481.59833555502,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [54] = {
        ["x"] = 643.28098524284,
        ["y"] = -472.84566041224,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [55] = {
        ["x"] = 670.06973028198,
        ["y"] = -470.57242426989,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [56] = {
        ["x"] = 646.77578612257,
        ["y"] = -464.20414336592,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [57] = {
        ["x"] = 664.55117374996,
        ["y"] = -461.84338172949,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [58] = {
        ["x"] = 627.47458919665,
        ["y"] = -303.22347559869,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [59] = {
        ["x"] = 627.0803311973,
        ["y"] = -294.26570198769,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [60] = {
        ["x"] = 635.92496688073,
        ["y"] = -312.83465761629,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [61] = {
        ["x"] = 636.2352452931,
        ["y"] = -303.55932808161,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [62] = {
        ["x"] = 636.29001383058,
        ["y"] = -293.7911572478,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [63] = {
        ["x"] = 645.90849290324,
        ["y"] = -312.45139768282,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [64] = {
        ["x"] = 664.72200145889,
        ["y"] = -313.10477633668,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [65] = {
        ["x"] = 655.40654665237,
        ["y"] = -303.23811392903,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [66] = {
        ["x"] = 664.60522319638,
        ["y"] = -303.62502907381,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [67] = {
        ["x"] = 664.58334848686,
        ["y"] = -294.05399371901,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [68] = {
        ["x"] = 654.98672445305,
        ["y"] = -294.0686024376,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [69] = {
        ["x"] = 645.53616514251,
        ["y"] = -294.30953155587,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [70] = {
        ["x"] = 645.95960457962,
        ["y"] = -303.1322269891,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Void Ascendant",
    ["id"] = 212793,
    ["count"] = 22,
    ["health"] = 82824420,
    ["scale"] = 2,
    ["displayId"] = 118418,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [430238] = {
        ["interruptible"] = true,
      },
      [1214523] = {
        ["magic"] = true,
      },
      [1214546] = {
      },
      [1214550] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 573.52129088288,
        ["y"] = -307.12048297462,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 272.68976235246,
        ["y"] = -359.04127250423,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 598.40601602158,
        ["y"] = -424.47122916484,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 598.66874870684,
        ["y"] = -507.65541242495,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 656.43499670498,
        ["y"] = -473.31589058233,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Radiating Voidstone",
    ["id"] = 212739,
    ["count"] = 25,
    ["health"] = 107184544,
    ["scale"] = 2,
    ["displayId"] = 114860,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [472547] = {
      },
      [472549] = {
      },
      [472764] = {
      },
      [1214628] = {
      },
      [1214631] = {
      },
      [1214645] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 662.03510190209,
        ["y"] = -519.35325864274,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 657.00205767568,
        ["y"] = -393.58041398839,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 599.60779802265,
        ["y"] = -526.83176827345,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Kyrioss",
    ["id"] = 209230,
    ["count"] = 0,
    ["health"] = 341320379,
    ["scale"] = 2,
    ["displayId"] = 114856,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2567,
    ["instanceID"] = 0,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [419870] = {
      },
      [419871] = {
      },
      [444034] = {
      },
      [474017] = {
      },
      [474018] = {
      },
      [1214315] = {
      },
      [1214318] = {
      },
      [1214323] = {
      },
      [1214324] = {
      },
      [1214325] = {
      },
      [1214326] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 370.17717307284,
        ["y"] = -173.61764374331,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Stormguard Gorren",
    ["id"] = 207205,
    ["count"] = 0,
    ["health"] = 341320379,
    ["scale"] = 2,
    ["displayId"] = 114403,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2567,
    ["instanceID"] = 0,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Slow"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [424737] = {
      },
      [424739] = {
      },
      [424797] = {
      },
      [424958] = {
      },
      [424966] = {
      },
      [425048] = {
      },
      [425052] = {
      },
      [425113] = {
      },
      [426136] = {
      },
      [426160] = {
      },
      [426171] = {
      },
      [451843] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 305.57901686006,
        ["y"] = -458.2425484583,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Voidstone Monstrosity",
    ["id"] = 207207,
    ["count"] = 0,
    ["health"] = 390080433,
    ["scale"] = 2,
    ["displayId"] = 114324,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2567,
    ["instanceID"] = 0,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [181089] = {
      },
      [423305] = {
      },
      [423356] = {
      },
      [423393] = {
      },
      [423839] = {
      },
      [428126] = {
      },
      [429487] = {
      },
      [429493] = {
        ["magic"] = true,
      },
      [433067] = {
      },
      [440207] = {
      },
      [445262] = {
      },
      [445457] = {
      },
      [445537] = {
      },
      [455219] = {
      },
      [455220] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 566.25073762344,
        ["y"] = -469.06973379502,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Stormrider Vokmar",
    ["id"] = 211260,
    ["count"] = 0,
    ["health"] = 101500521,
    ["scale"] = 3.3,
    ["displayId"] = 116266,
    ["creatureType"] = "Humanoid",
    ["level"] = 82,
    ["spells"] = {
      [424371] = {
      },
      [431371] = {
      },
      [442355] = {
      },
      [442456] = {
      },
      [458082] = {
      },
      [458130] = {
      },
      [460190] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 538.61694424428,
        ["y"] = -405.2493923616,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Voidstone Awakened",
    ["id"] = 213741,
    ["count"] = 0,
    ["health"] = 24360126,
    ["scale"] = 2,
    ["displayId"] = 114860,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [429028] = {
      },
      [429029] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 548.13053361079,
        ["y"] = -496.06823751078,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 538.18888554833,
        ["y"] = -473.69497334053,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 542.27354238706,
        ["y"] = -450.09461541747,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
    },
  },
};
