local E = select(2,	...):unpack()

E.spell_cdmod_talents = {

	[48982]	= {
		48985,	10,
		49488,	20,
		49489,	30,
	},
	[43265]	= {
		48963,	5,
		49564,	10,
		49565,	15,
	},
	[49576]	= {
		49588,	5,
		49589,	10,
	},
	[46584]	= {
		55620,	45,
		55623,	90,
		52143,	60,
	},
	[61999]	= {
		55620,	120,
		55623,	240,
	},
	[47476]	= {
		58618,	20,
	},

	[5211]	= {
		16940,	15,
		16941,	30,
	},
	[33878]	= {
		48532,	0.5,
		48489,	1.0,
		48491,	1.5,
	},
	[50516]	= {
		63056,	3,
	},
	[5209]	= {
		57858,	30,
	},
	[48505]	= {
		54828,	30,
	},

	[1499]	= {
		34491,	2,
		34492,	4,
		34493,	6,
	},
	[13795]	= {
		34491,	2,
		34492,	4,
		34493,	6,
	},
	[13809]	= {
		34491,	2,
		34492,	4,
		34493,	6,
	},
	[13813]	= {
		34491,	2,
		34492,	4,
		34493,	6,
	},
	[34600]	= {
		34491,	2,
		34492,	4,
		34493,	6,
	},
	[3674]	= {
		34491,	2,
		34492,	4,
		34493,	6,
	},
	[60192]	= {
		34491,	2,
		34492,	4,
		34493,	6,
	},
	[3045]	= {
		34948,	60,
		34949,	120,
	},
	[19434]	= {
		56824,	2,
	},
	[19574]	= {
		56830,	2,
	},
	[2643]	= {
		56836,	2,
	},
	[53209]	= {
		63065,	1,
	},
	[5384]	= {
		57903,	5,
	},
	[781]	= {
		19286,	2,
		19287,	4,
		56844,	5,
	},
	[19263]	= {
		56850,	10,
	},
	[19386]	= {
		56848,	6,
	},
	[53351]	= {
		63067,	6,
	},
	[34026]	= {
		34462,	10,
		34464,	20,
		34465,	30,
	},

	[2136]	= {
		11078,	1,
		11080,	2,
	},
	[12051]	= {
		44378,	60,
		44379,	120,
	},
	[31687]	= {
		56373,	30,
	},

	[1022]	= {
		20174,	60,
		20175,	120,
	},
	[498]	= {
		31848,	30,
		31849,	60,
	},
	[642]	= {
		31848,	30,
		31849,	60,
	},
	[853]	= {
		20487,	10,
		20488,	20,
		53695,	5,
		53696,	10,
	},
	[20271]	= {
		25956,	1,
		25957,	2,
	},
	[53408]	= {
		25956,	1,
		25957,	2,
	},
	[53407]	= {
		25956,	1,
		25957,	2,
	},
	[633]	= {
		20234,	120,
		20235,	240,
	},
	[31884]	= {
		53375,	30,
		53376,	60,
	},
	[2812]	= {
		56420,	15,
	},
	[26573]	= {
		54928,	2,
	},
	[20473]	= {
		63224,	1,
	},

	[586]	= {
		15274,	3,
		15311,	6,
		55684,	9,
	},
	[34433]	= {
		15274,	60,
		15311,	120,
	},
	[8092]	= {
		15273,	0.5,
		15312,	1.0,
		15313,	1.5,
		15314,	2.0,
		15316,	2.5,
	},
	[8122]	= {
		15392,	2,
		15448,	4,
		55676,	-8,
	},
	[17]	= {
		63574,	4,
	},
	[47585]	= {
		63229,	45,
	},
	[47540]	= {
		63235,	2,
	},
	[6346]	= {
		55678,	60,
	},

	[2094]	= {
		13981,	30,
		14066,	60,
	},
	[1856]	= {
		13981,	30,
		14066,	60,
	},
	[31224]	= {
		13981,	15,
		14066,	30,
	},
	[5277]	= {
		13742,	30,
		13872,	60,
	},
	[2983]	= {
		13742,	30,
		13872,	60,
	},
	[1784]	= {
		13975,	1,
		14062,	2,
		14063,	3,
	},
	[57934]	= {
		58414,	5,
		58415,	10,
	},
	[1725]	= {
		58414,	5,
		58415,	10,
	},
	[36554]	= {
		58414,	5,
		58415,	10,
	},
	[14185]	= {
		58414,	90,
		58415,	180,
	},
	[51690]	= {
		63252,	45,
	},
	[14278]	= {
		56814,	-10,
	},

	[8042]	= {
		16040,	0.2,
		16113,	0.4,
		16114,	0.6,
		16115,	0.8,
		16116,	1.0,
	},
	[8050]	= {
		16040,	0.2,
		16113,	0.4,
		16114,	0.6,
		16115,	0.8,
		16116,	1.0,
		63370,	1.0,
		63372,	2.0,
	},
	[8056]	= {
		16040,	0.2,
		16113,	0.4,
		16114,	0.6,
		16115,	0.8,
		16116,	1.0,
		63370,	1.0,
		63372,	2.0,
	},
	[57994]	= {
		16040,	0.2,
		16113,	0.4,
		16114,	0.6,
		16115,	0.8,
		16116,	1.0,
	},
	[8177]	= {
		16258,	1,
		16293,	2,
	},
	[20608]	= {
		16184,	420,
		16209,	900,
	},
	[1535]	= {
		16086,	2,
		16544,	4,
		55450,	3,
	},
	[421]	= {
		51483,	.75,
		51485,	1.5,
		51486,	2.5,
	},
	[2894]	= {
		55455,	300,
	},
	[16166]	= {
		55452,	30,
	},
	[51490]	= {
		63270,	10,
	},

	[54049]	= {
		54037,	2,
		54038,	4,
	},
	[7814]	= {
		18126,	3,
		18127,	6,
	},
	[50796]	= {
		63304,	2,
	},
	[5484]	= {
		56217,	8,
	},
	[48020]	= {
		63309,	4,
	},

	[20252]	= {
		29888,	5,
		29889,	10,
	},
	[12294]	= {
		35446,	0.3,
		35448,	0.7,
		35449,	1.0,
	},
	[1719]	= {
		12312,	30,
		12803,	60,
	},
	[20230]	= {
		12312,	30,
		12803,	60,
	},
	[871]	= {
		12312,	30,
		12803,	60,
		63329,	120,
	},
	[100]	= {
		64976,	-5,
	},
	[7384]	= {
		46859,	2,
		46860,	4,
	},
	[6572]	= {
		46859,	2,
		46860,	4,
	},
	[2565]	= {
		29598,	10,
		29599,	20,
	},
	[676]	= {
		12313,	10,
		12804,	20,
	},
	[12975]	= {
		58376,	60,
	},
	[46968]	= {
		63325,	3,
	},
	[1680]	= {
		58370,	2,
	},
	[46924]	= {
		63324,	15,
	},
	[23920]	= {
		63328,	15,
	},
}

E.spell_cdmod_talents_mult = {

	[740]	= {
		17123,	.70,
		17124,	.40,
	},
	[1850]	= {
		59219,	.80,
	},

	[19574]	= {
		53262,	.90,
		53263,	.80,
		53264,	.70,
	},
	[19577]	= {
		53262,	.90,
		53263,	.80,
		53264,	.70,
	},
	[53271]	= {
		53262,	.90,
		53263,	.80,
		53264,	.70,
	},
	[26090]	= {
		53262,	.90,
		53263,	.80,
		53264,	.70,
	},

	[120]	= {
		31670,	.93,
		31672,	.86,
		55094,	.80,
	},
	[45438]	= {
		31670,	.93,
		31672,	.86,
		55094,	.80,
	},
	[122]	= {
		31670,	.93,
		31672,	.86,
		55094,	.80,
	},
	[12472]	= {
		31670,	.93,
		31672,	.86,
		55094,	.80,
	},
	[11958]	= {
		55091,	.90,
		55092,	.80,
	},
	[11426]	= {
		55091,	.90,
		55092,	.80,
	},
	[31687]	= {
		55091,	.90,
		55092,	.80,
	},
	[12043]	= {
		44378,	.85,
		44379,	.70,
	},
	[12042]	= {
		44378,	.85,
		44379,	.70,
	},
	[66]	= {
		44378,	.85,
		44379,	.70,
	},

	[2812]	= {
		31825,	.83,
		31826,	.67,
	},
	[879]	= {
		31825,	.83,
		31826,	.67,
	},

	[14751]	= {
		47507,	.90,
		47508,	.80,
	},
	[10060]	= {
		47507,	.90,
		47508,	.80,
	},
	[33206]	= {
		47507,	.90,
		47508,	.80,
	},
	[47540]	= {
		47507,	.90,
		47508,	.80,
	},
	[33076]	= {
		47562,	.94,
		47564,	.88,
		47565,	.82,
		47566,	.76,
		47567,	.70,
	},

	[5730]	= {
		16043,	.85,
		16130,	.7,
	},
	[2484]	= {
		16043,	.85,
		16130,	.7,
	},

	[47193]	= {
		63117,	.90,
		63121,	.80,
		63123,	.70,
	},
	[47241]	= {
		63117,	.90,
		63121,	.80,
		63123,	.70,
	},
	[18708]	= {
		63117,	.90,
		63121,	.80,
		63123,	.70,
	},

	[2687]	= {
		46908,	.89,
		46909,	.78,
		56924,	.67,
	},
	[18499]	= {
		46908,	.89,
		46909,	.78,
		56924,	.67,
	},
	[1719]	= {
		46908,	.89,
		46909,	.78,
		56924,	.67,
	},
	[12292]	= {
		46908,	.89,
		46909,	.78,
		56924,	.67,
	},
	[100]	= {
		58355,	.93,
	},
}

E.spell_chmod_talents = E.BLANK
E.spell_cdmod_by_haste = E.BLANK





E.spell_cdmod_by_aura_mult = E.BLANK

E.spell_noreset_onencounterend = {
	[20608]	= true,
	[18540]	= true,
	[556]	= true,
	[633]	= true,
}


E.talentNameToRankIDs = {}

local temp = {}
for _, v in E.pairs(E.spell_cdmod_talents, E.spell_cdmod_talents_mult) do
	for k = 1, #v, 2 do
		local id = v[k]
		local name = C_Spell.GetSpellName(id)
		if name and not temp[id] then
			E.talentNameToRankIDs[name] = E.talentNameToRankIDs[name] or {}
			tinsert(E.talentNameToRankIDs[name], id)
			temp[id] = true
		end
	end
end

local itemBonus = {

	[29166]	= { 37297,	48	},
	[17116]	= { 37292,	24	},
	[20484]	= { 26106,	600	},
	[18562]	= { 38417,	2	},

	[5116]	= {
		23158,	1,
		24465,	1,
	},
	[1499]	= {
		37481,	4,
		61256,	2,
	},
	[13795]	= {
		37481,	4,
		61256,	2,
	},
	[13809]	= {
		37481,	4,
		61256,	2,
	},
	[13813]	= {
		37481,	4,
		61256,	2,
	},
	[34600]	= {
		37481,	4,
		61256,	2,
	},
	[3674]	= {
		37481,	4,
		61256,	2,
	},
	[60192]	= {
		37481,	4,
		61256,	2,
	},
	[5384]	= { 24432,	2	},
	[2643]	= { 44292,	1	},


	[1953]	= { 23025,	2	},
	[11113]	= { 37439,	4	},
	[45438]	= { 37439,	40	},
	[12043]	= { 37439,	24	},
	[12051]	= { 28763,	60	},

	[20216]	= { 37183,	15	},
	[853]	= { 23302,	10	},
	[633]	= { 28774,	720	},
	[31789]	= { 37181,	2	},
	[20271]	= { 61776,	1	},
	[53408]	= { 61776,	1	},
	[53407]	= { 61776,	1	},

	[586]	= { 18388,	2	},
	[8122]	= { 44297,	3	},

	[2094]	= { 24469,	5	},
	[5277]	= { 26112,	60	},
	[1776]	= { 23048,	1	},
	[1766]	= { 24434,	0.5	},
	[1856]	= {
		21874,	30,
		14064,	60,
	},

	[8177]	= { 44299,	1.5	},
	[16188]	= {
		37211,	24,
		38466,	24,
		38499,	24,
	},
	[20608]	= { 27797,	600	},
	[17364]	= { 33018,	2	},

	[20252]	= { 22738,	5	},
	[5246]	= { 24456,	15	},
}
local itemBonusMult = {

	[740]	= { 23556,	.85	},

	[6789]	= { 24487,	.85	},
}
local function MergeTable(src,	dest)
	for id, t in pairs(src) do
		dest[id] = dest[id] or {}
		for i = 1, #t do
			local v = t[i]
			tinsert(dest[id], v)
		end
	end
end
MergeTable(itemBonus, E.spell_cdmod_talents)
MergeTable(itemBonusMult, E.spell_cdmod_talents_mult)
itemBonus = nil
itemBonusMult = nil





E.spellcast_linked = {
	[1499]	= { 1499,	13809,	60192	},
	[13809]	= { 1499,	13809,	60192	},
	[60192]	= { 1499,	13809,	60192	},
	[13813]	= { 13813,	13795,	3674	},
	[13795]	= { 13813,	13795,	3674	},
	[3674]	= { 13813,	13795,	3674	},

	[543]	= { 543,	6143	},
	[6143]	= { 543,	6143	},
	[20271]	= { 20271,	53408,	53407	},
	[53408]	= { 20271,	53408,	53407	},
	[53407]	= { 20271,	53408,	53407	},
	[8042]	= { 8042,	8050,	8056	},
	[8050]	= { 8042,	8050,	8056	},
	[8056]	= { 8042,	8050,	8056	},
	[19434]	= { 2643,	19434	},
	[2643]	= { 2643,	19434	},
	[6552]	= { 6552,	72	},
	[72]	= { 6552,	72	},
}

E.spellcast_merged = {

	[32182]	= 2825,

	[33697]	= 20572,
	[33702]	= 20572,
	[25046]	= 28730,
	[50613]	= 28730,
	[59547]	= 28880,
	[59545]	= 28880,
	[59548]	= 28880,
	[59544]	= 28880,
	[59543]	= 28880,
	[59542]	= 28880,

	[55915]	= 44055,
	[67596]	= 44055,

	[57386]	= 26090,
	[50433]	= 26090,
	[50245]	= 26090,
	[50285]	= 26090,
	[50479]	= 26090,
	[50519]	= 26090,
	[50541]	= 26090,
	[4167]	= 26090,
	[50518]	= 26090,
	[4511]	= 19244,
	[7814]	= 19244,
	[7812]	= 19244,
	[30151]	= 19244,
}


local spellRanks = {

	{ 43265,	49936,	49937,	49938	},
	{ 57330,	57623	},

	{ 5211,	6798,	8983	},
	{ 8998,	9000,	9892,	31709,	27004,	48575	},
	{ 1850,	9821,	33357	},
	{ 22570,	49802	},
	{ 33878,	33986,	33987	},
	{ 20484,	20739,	20742,	20747,	20748,	26994,	48477	},
	{ 5217,	6793,	9845,	9846,	50212,	50213	},
	{ 740,	8918,	9862,	9863,	26983,	48446,	48447	},

	{ 3044,	14281,	14282,	14283,	14284,	14285,	14286,	14287,	27019,	49044,	49045	},
	{ 13813,	14316,	14317,	27025,	49066,	49067	},
	{ 1499,	14310,	14311	},
	{ 13795,	14302,	14303,	14304,	14305,	27023,	49055,	49056	},
	{ 1495,	14269,	14270,	14271,	36916,	53339	},
	{ 2643,	14288,	14289,	14290,	25294,	27021,	49047,	49048	},
	{ 2973,	14260,	14261,	14262,	14263,	14264,	14265,	14266,	27014,	48995,	48996	},
	{ 1513,	14326,	14327	},
	{ 3034,	14279,	14280,	27018	},
	{ 53351,	61005,	61006	},

	{ 57386,	57389,	57390,	57391,	57392,	57393	},
	{ 50433,	52395,	52396,	52397,	52398,	52399	},
	{ 50245,	53544,	53545,	53546,	53547,	53548	},
	{ 50479,	53584,	53586,	53587,	53588,	53589	},
	{ 50519,	53564,	53565,	53566,	53567,	53568	},
	{ 50541,	53537,	53538,	53540,	53542,	53543	},
	{ 50518,	53558,	53559,	53560,	53561,	53562	},
	{ 24604,	24605,	24603,	24597,	64494,	64495	},
	{ 35387,	35389,	35392,	55555,	55556,	55557	},

	{ 120,	8492,	10159,	10160,	10161,	27087,	42930,	42931	},
	{ 543,	8457,	8458,	10223,	10225,	27128,	43010	},
	{ 2136,	2137,	2138,	8412,	8413,	10197,	10199,	27078,	27079,	42872,	42873	},
	{ 122,	865,	6131,	10230,	27088,	42917	},
	{ 6143,	8461,	8462,	10177,	28609,	32796,	43012	},
	{ 43012,	58659	},

	{ 1022,	5599,	10278	},
	{ 26573,	20116,	20922,	20923,	20924,	27173,	48818	},
	{ 879,	5614,	5615,	10312,	10313,	10314,	27138,	48800,	48801	},
	{ 853,	5588,	5589,	10308	},
	{ 24275,	24274,	24239,	27180,	48805,	48806	},
	{ 2812,	10318,	27139,	48816,	48817	},
	{ 633,	2799,	10310,	27154,	48788	},
	{ 2878,	5627	},

	{ 586,	9578,	9579,	9592,	10941,	10942,	25429	},
	{ 8092,	8102,	8103,	8104,	8105,	8106,	10945,	10946,	10947,	25372,	25375,	48126,	48127	},
	{ 17,	592,	600,	3747,	6065,	6066,	10898,	10899,	10900,	10901,	25217,	25218,	48065,	48066	},
	{ 8122,	8124,	10888,	10890	},
	{ 32379,	32996,	48157,	48158	},
	{ 33076,	48112,	48113	},
	{ 14914,	15262,	15263,	15264,	15265,	15266,	15267,	15261,	25384,	48134,	48135	},

	{ 5277,	26669	},
	{ 1966,	6768,	8637,	11303,	25302,	27448,	48658,	48659	},
	{ 408,	8643	},
	{ 2983,	8696,	11305	},
	{ 1856,	1857,	26889	},

	{ 421,	930,	2860,	10605,	25439,	25442,	49270,	49271	},
	{ 8042,	8044,	8045,	8046,	10412,	10413,	10414,	25454,	49230,	49231	},
	{ 1535,	8498,	8499,	11314,	11315,	25546,	25547,	61649,	61657	},
	{ 8050,	8052,	8053,	10447,	10448,	29228,	25457,	49232,	49233	},
	{ 8056,	8058,	10472,	10473,	25464,	49235,	49236	},
	{ 5730,	6390,	6391,	6392,	10427,	10428,	25525,	58580,	58581,	58582	},
	{ 51505,	60043	},

	{ 603,	30910,	47867	},
	{ 6789,	17925,	17926,	27223,	47859,	47860	},
	{ 5484,	17928	},
	{ 6229,	11739,	11740,	28610,	47890,	47891	},
	{ 20707,	20762,	20763,	20764,	20765,	27239,	47883	},
	{ 29893,	58887	},
	{ 47897,	61290	},

	{ 19244,	19647	},
	{ 19505,	19731,	19734,	19736,	27276,	27277	},
	{ 17735,	17750,	17751,	17752,	27271,	33701	},
	{ 7812,	19438,	19440,	19441,	19442,	19443,	27273,	47985,	47986	},
	{ 7814,	7815,	7816,	11778,	11779,	11780,	27274	},
	{ 6360,	7813,	11784,	11785,	27275	},
	{ 3716,	7809,	7810,	7811,	11774,	11775,	27270	},
	{ 54049,	54050,	54051,	54052,	54053	},
	{ 30151,	30194,	30198,	47996	},
	{ 33698,	33699,	33700,	47993	},
	{ 30213,	30219,	30223,	47994	},

	{ 100,	6178,	11578	},
	{ 6572,	6574,	7379,	11600,	11601,	25288,	25269,	30357,	57823	},
	{ 6343,	8198,	8204,	8205,	11580,	11581,	25264,	47501	},
}
local talentRanks = {

	{ 49203	},
	{ 49222	},
	{ 49005	},
	{ 48982	},
	{ 51271	},
	{ 55233	},
	{ 51052	},
	{ 49158,	51325,	51326,	51327,	51328	},
	{ 49028	},
	{ 49796	},
	{ 63560	},
	{ 49184,	51409,	51410,	51411	},
	{ 49016	},
	{ 49206	},
	{ 49039	},
	{ 49588,	49589	},

	{ 33831	},
	{ 17116	},
	{ 18562	},
	{ 16689,	16810,	16811,	16812,	16813,	17329,	27009,	53312	},
	{ 50334	},
	{ 16940,	16941	},
	{ 49377	},
	{ 33917	},
	{ 33878,	33986,	33987,	48563,	48564	},
	{ 48505,	53199,	53200,	53201	},
	{ 61336	},
	{ 50516,	53223	},
	{ 48438,	53248,	53249,	53251	},

	{ 19574	},
	{ 19577	},
	{ 23989	},
	{ 19503	},
	{ 34490	},
	{ 19434,	20900,	20901,	20902,	20903,	20904,	27065,	49049,	49050	},
	{ 19306,	20909,	20910,	27067,	48998,	48999	},
	{ 19386,	24132,	24133,	27068,	49011,	49012	},
	{ 3674,	63668,	63669,	63670,	63671,	63672	},
	{ 53301,	60051,	60052,	60053	},
	{ 53209	},

	{ 12042	},
	{ 11958	},
	{ 11129	},
	{ 12472	},
	{ 12043	},
	{ 31687	},
	{ 11113,	13018,	13019,	13020,	13021,	27133,	33933,	42944,	42945	},
	{ 31661,	33041,	33042,	33043,	42949,	42950	},
	{ 11426,	13031,	13032,	13033,	27134,	33405,	43038,	43039	},
	{ 44425,	44780,	44781	},
	{ 44572	},

	{ 35395	},
	{ 20216	},
	{ 31842	},
	{ 20066	},
	{ 31935,	32699,	32700,	48826,	48827	},
	{ 20925,	20927,	20928,	27179,	48951,	48952	},
	{ 20473,	20929,	20930,	27174,	33072,	48824,	48825	},
	{ 31821	},
	{ 31850,	31851,	31852	},
	{ 64205	},
	{ 53385	},

	{ 14751	},
	{ 33206	},
	{ 10060	},
	{ 15487	},
	{ 724,	27870,	27871,	28275,	48086,	48087	},
	{ 47540,	53005,	53006,	53007	},
	{ 19236,	19238,	19240,	19241,	19242,	19243,	25437,	48172,	48173	},
	{ 34861,	34863,	34864,	34865,	34866,	48088,	48089	},
	{ 47788	},
	{ 64044	},
	{ 47585	},

	{ 13750	},
	{ 13877	},
	{ 14177	},
	{ 14278	},
	{ 14183	},
	{ 14185	},
	{ 14251	},
	{ 36554	},
	{ 51690	},
	{ 31228,	31229,	31230	},
	{ 51713	},

	{ 16166	},
	{ 16190	},
	{ 16188	},
	{ 30823	},
	{ 17364	},
	{ 51490,	59156,	59158,	59159	},
	{ 60103	},
	{ 51533	},
	{ 30881,	30883,	30884,	30885,	30886	},
	{ 61295,	61299,	61300,	61301	},
	{ 55198	},

	{ 18708	},
	{ 17877,	18867,	18868,	18869,	18870,	18871,	27263,	30546,	47826,	47827	},
	{ 30283,	30413,	30414,	47846,	47847	},
	{ 48181,	59161,	59163,	59164	},
	{ 47193	},
	{ 59672	},
	{ 50796,	59170,	59171,	59172	},
	{ 30146	},
	{ 17962	},

	{ 12809	},
	{ 12292	},
	{ 12975	},
	{ 12328	},
	{ 12294,	21551,	21552,	21553,	25248,	30330,	47485,	47486	},
	{ 23922,	23923,	23924,	23925,	25258,	30356,	47487,	47488	},
	{ 46924	},
	{ 60970	},
	{ 23881	},
	{ 46968	},
	{ 12311,	12958	},
}

for i = 1, #spellRanks do
	local t = spellRanks[i]
	local rank1 = t[1]
	rank1 = E.spellcast_merged[rank1] or rank1
	for j = 2, #t do
		local rankN = t[j]
		E.spellcast_merged[rankN] = rank1
	end
end

for i = 1, #talentRanks do
	local t = talentRanks[i]
	local rank1 = t[1]
	rank1 = E.spellcast_merged[rank1] or rank1
	local name = C_Spell.GetSpellName(rank1)
	if name then
		for j = 2, #t do
			local rankN = t[j]
			E.spellcast_merged[rankN] = rank1
			--[==[@debug@
			if not C_Spell.DoesSpellExist(rankN) then
				E.write("Invalid rank" .. j .. "talent ID:", rankN)
			end
			--@end-debug@]==]
		end


		local dupe = E.talentNameToRankIDs[name]
		if dupe then
			if type(dupe[1]) == "table" then
				tinsert(E.talentNameToRankIDs[name], t)
			else
				E.talentNameToRankIDs[name] = { dupe, t }
			end
		else
			E.talentNameToRankIDs[name] = t
		end
	--[==[@debug@
	else
		E.write("Invalid rank1 talent ID:", rank1)
	--@end-debug@]==]
	end
end

E.spellcast_merged_updateoncast = {
	[26090]={30},
	[57386]={60},	[57389]={60},	[57390]={60},	[57391]={60},	[57392]={60},	[57393]={60},
	[50245]={40},	[53544]={40},	[53545]={40},	[53546]={40},	[53547]={40},	[53548]={40},
	[50285]={40},
	[50479]={40},	[53584]={40},	[53586]={40},	[53587]={40},	[53588]={40},	[53589]={40},
	[50519]={60},	[53564]={60},	[53565]={60},	[53566]={60},	[53567]={60},	[53568]={60},
	[50541]={60},	[53537]={60},	[53538]={60},	[53540]={60},	[53542]={60},	[53543]={60},
	[4167]={40},
	[50518]={40},	[53558]={40},	[53559]={40},	[53560]={40},	[53561]={40},	[53562]={40},
	[50433]={120},	[52395]={120},	[52396]={120},	[52397]={120},	[52398]={120},	[52399]={120},
	[19244]={24},	[19647]={24},
	[7812]={60},	[19438]={60},	[19440]={60},	[19441]={60},	[19442]={60},	[19443]={60},	[27273]={60},	[47985]={60},	[47986]={60},
	[30151]={30},	[30194]={30},	[30198]={30},	[47996]={30},
	[7814]={12},	[7815]={12},	[7816]={12},	[11778]={12},	[11779]={12},	[11780]={12},	[27274]={12},
}
for k,	v in pairs(E.spellcast_merged_updateoncast) do
	if not v[2] then
		local _,	icon = C_Spell.GetSpellTexture(k)
		v[2] = icon
	end
end

E.spellcast_shared_cdstart = {
	[42292]	= { 59752,	120,	7744,	45	},
	[59752]	= { 42292,	120	},
	[7744]	= { 42292,	45	},
	[2894]	= { 2062,	120	},
	[2062]	= { 2894,	120	},
	[16979]	= { 49376,	15	},
	[49376]	= { 16979,	15	},


	[31884]	= { 642,	30,	498,	30	},
	[871]	= { 1719,	12,	20230,	12	},
	[1719]	= { 871,	12,	20230,	12	},
	[20230]	= { 1719,	12,	871,	12	},
}

E.spellcast_cdreset = {
	[23989]	= {
		nil,
		"*",
	},
	[11958]	= {
		nil,
		45438,
		11426,
		120,
		122,
		12472,
		6143,
		44572,
		31687,
	},
	[45438]	= {
		56372,
		122,
	},
	[14185]	= {
		nil,
		5277,
		2983,
		1856,
		14177,
		36554,
		{
			56819,
			13877,
			51722,
			1766,
		},
	},
	[60970]	= {
		nil,
		20252,
	}
}



E.spellcast_cdr = E.BLANK





E.spell_auraremoved_cdstart_preactive = {
	[17116]	= 17116,
	[5215]	= 5215,
	[34477]	= 34477,
	[12043]	= 12043,
	[14177]	= 14177,
	[1784]	= 1784,
	[20216]	= 20216,
	[16188]	= 16188,
	[28682]	= 11129,
	[11129]	= 11129,
	[14751]	= 14751,
	[16166]	= 16166,
	[5384]	= 0,
}

E.spell_auraapplied_processspell = {
	[66233]	= 31850,
	[45182]	= 31228,
	[31616]	= 30881,
}

E.spell_dispel_cdstart = E.BLANK

E.selfLimitedMinMaxReducer = E.BLANK
E.runeforge_bonus_to_descid = E.BLANK
E.runeforge_specid = E.BLANK
E.runeforge_desc_to_powerid = E.BLANK
E.runeforge_unity = E.BLANK
E.covenant_to_spellid = E.BLANK
E.covenant_abilities = E.BLANK
E.spell_benevolent_faerie_majorcd = E.BLANK
E.covenant_cdmod_conduits = E.BLANK
E.covenant_chmod_conduits = E.BLANK
E.covenant_cdmod_items_mult = E.BLANK
E.soulbind_conduits_rank = E.BLANK
E.soulbind_abilities = E.BLANK
E.spell_cdmod_conduits = E.BLANK
E.spell_cdmod_conduits_mult = E.BLANK
E.spell_symbol_of_hope_majorcd = E.BLANK
E.spell_major_cd = E.BLANK





E.item_merged = {

	[33046]	= 37864,
	[28235]	= 37864,
	[30348]	= 37864,
	[28238]	= 37864,
	[30351]	= 37864,
	[28236]	= 37864,
	[30349]	= 37864,
	[28234]	= 37864,
	[28237]	= 37864,
	[30350]	= 37864,
	[37865]	= 37864,
	[28240]	= 37864,
	[28243]	= 37864,
	[30345]	= 37864,
	[28241]	= 37864,
	[30343]	= 37864,
	[28239]	= 37864,
	[30346]	= 37864,
	[28242]	= 37864,
	[30344]	= 37864,
	[42123]	= 37864,
	[42124]	= 37864,
	[51377]	= 37864,
	[42122]	= 37864,
	[42126]	= 37864,
	[51378]	= 37864,
	[46081]	= 37864,
	[46082]	= 37864,
	[46083]	= 37864,
	[46084]	= 37864,
	[46085]	= 37864,

	[44098]	= 18859,
	[40476]	= 18859,
	[29593]	= 18859,
	[18857]	= 18859,
	[18864]	= 18859,
	[18854]	= 18859,
	[18862]	= 18859,
	[18858]	= 18859,
	[18856]	= 18859,
	[18863]	= 18859,
	[44097]	= 18859,
	[40477]	= 18859,
	[18850]	= 18859,
	[18845]	= 18859,
	[18849]	= 18859,
	[29592]	= 18859,
	[18834]	= 18859,
	[18851]	= 18859,
	[18852]	= 18859,
	[18846]	= 18859,
	[18853]	= 18859,

	[34049]	= 34050,
	[34578]	= 34050,
	[34163]	= 34050,
	[34579]	= 34050,
	[33832]	= 34050,
	[34576]	= 34050,
	[35326]	= 34050,
	[34580]	= 34050,
	[35327]	= 34050,
	[34162]	= 34050,
	[34577]	= 34050,

	[41588]	= 34050,
	[41587]	= 34050,
	[41590]	= 34050,
	[41589]	= 34050,

	[42129]	= 34050,
	[42130]	= 34050,
	[42132]	= 34050,
	[42131]	= 34050,
	[42128]	= 34050,

	[42133]	= 34050,
	[42134]	= 34050,
	[42136]	= 34050,
	[42137]	= 34050,
	[42135]	= 34050,
}

E.item_equip_bonus = {
	[19617]	= 24434,
	[14154]	= 18388,
	[33717]	= 44297,
	[33744]	= 44297,
	[35053]	= 44297,
	[35083]	= 44297,
	[41847]	= 44297,
	[41937]	= 44297,
	[41872]	= 44297,
	[41938]	= 44297,
	[41873]	= 44297,
	[41939]	= 44297,
	[41874]	= 44297,
	[41940]	= 44297,
	[41875]	= 44297,
	[41941]	= 44297,
	[51483]	= 44297,
	[51488]	= 44297,
	[22345]	= 20608,
	[19621]	= 24432,
}

local class_set_bonus = {
	druid	= { 38417,	4	},
	hunter	= { 61256,	4	},
	paladin	= { 61776,	4	},
	shaman	= { 44299,	4	},
	enhance	= { 33018,	4	},
	warrior	= { 22738,	4	},
}

E.item_set_bonus = {

	[16828]	= { 23556,	8	},
	[16829]	= { 23556,	8	},
	[16830]	= { 23556,	8	},
	[16833]	= { 23556,	8	},
	[16831]	= { 23556,	8	},
	[16834]	= { 23556,	8	},
	[16835]	= { 23556,	8	},
	[16836]	= { 23556,	8	},
	[29087]	= { 37292,	4	},
	[29086]	= { 37292,	4	},
	[29090]	= { 37292,	4	},
	[29088]	= { 37292,	4	},
	[29089]	= { 37292,	4	},
	[31041]	= { 38417,	2	},
	[31032]	= { 38417,	2	},
	[31037]	= { 38417,	2	},
	[31045]	= { 38417,	2	},
	[31047]	= { 38417,	2	},
	[34571]	= { 38417,	2	},
	[34445]	= { 38417,	2	},
	[34554]	= { 38417,	2	},
	[21355]	= { 26106,	5	},
	[21353]	= { 26106,	5	},
	[21354]	= { 26106,	5	},
	[21356]	= { 26106,	5	},
	[21357]	= { 26106,	5	},
	[29093]	= { 37297,	4	},
	[29094]	= { 37297,	4	},
	[29091]	= { 37297,	4	},
	[29092]	= { 37297,	4	},
	[29095]	= { 37297,	4	},

	[41268]	= class_set_bonus.druid,
	[41269]	= class_set_bonus.druid,
	[41270]	= class_set_bonus.druid,
	[41271]	= class_set_bonus.druid,
	[41272]	= class_set_bonus.druid,
	[41284]	= class_set_bonus.druid,
	[41319]	= class_set_bonus.druid,
	[41296]	= class_set_bonus.druid,
	[41273]	= class_set_bonus.druid,
	[41308]	= class_set_bonus.druid,
	[41286]	= class_set_bonus.druid,
	[41320]	= class_set_bonus.druid,
	[41297]	= class_set_bonus.druid,
	[41274]	= class_set_bonus.druid,
	[41309]	= class_set_bonus.druid,

	[41287]	= class_set_bonus.druid,
	[41321]	= class_set_bonus.druid,
	[41298]	= class_set_bonus.druid,
	[41275]	= class_set_bonus.druid,
	[41310]	= class_set_bonus.druid,

	[41288]	= class_set_bonus.druid,
	[41322]	= class_set_bonus.druid,
	[41299]	= class_set_bonus.druid,
	[41276]	= class_set_bonus.druid,
	[41311]	= class_set_bonus.druid,

	[51420]	= class_set_bonus.druid,
	[51421]	= class_set_bonus.druid,
	[51422]	= class_set_bonus.druid,
	[51424]	= class_set_bonus.druid,
	[51419]	= class_set_bonus.druid,


	[28228]	= { 37481,	2	},
	[27474]	= { 37481,	2	},
	[28275]	= { 37481,	2	},
	[27874]	= { 37481,	2	},
	[27801]	= { 37481,	2	},
	[28334]	= { 44292,	4	},
	[28335]	= { 44292,	4	},
	[28331]	= { 44292,	4	},
	[28332]	= { 44292,	4	},
	[28333]	= { 44292,	4	},
	[31960]	= { 44292,	4	},
	[31961]	= { 44292,	4	},
	[31962]	= { 44292,	4	},
	[31963]	= { 44292,	4	},
	[31964]	= { 44292,	4	},
	[33664]	= { 44292,	4	},
	[33665]	= { 44292,	4	},
	[33666]	= { 44292,	4	},
	[33667]	= { 44292,	4	},
	[33668]	= { 44292,	4	},
	[34990]	= { 44292,	4	},
	[34991]	= { 44292,	4	},
	[34992]	= { 44292,	4	},
	[34993]	= { 44292,	4	},
	[34994]	= { 44292,	4	},
	[41084]	= class_set_bonus.hunter,
	[41140]	= class_set_bonus.hunter,
	[41154]	= class_set_bonus.hunter,
	[41202]	= class_set_bonus.hunter,
	[41214]	= class_set_bonus.hunter,
	[41085]	= class_set_bonus.hunter,
	[41141]	= class_set_bonus.hunter,
	[41155]	= class_set_bonus.hunter,
	[41203]	= class_set_bonus.hunter,
	[41215]	= class_set_bonus.hunter,
	[41086]	= class_set_bonus.hunter,
	[41142]	= class_set_bonus.hunter,
	[41156]	= class_set_bonus.hunter,
	[41204]	= class_set_bonus.hunter,
	[41216]	= class_set_bonus.hunter,
	[41087]	= class_set_bonus.hunter,
	[41143]	= class_set_bonus.hunter,
	[41157]	= class_set_bonus.hunter,
	[41205]	= class_set_bonus.hunter,
	[41217]	= class_set_bonus.hunter,
	[41088]	= class_set_bonus.hunter,
	[41144]	= class_set_bonus.hunter,
	[41158]	= class_set_bonus.hunter,
	[41206]	= class_set_bonus.hunter,
	[41218]	= class_set_bonus.hunter,
	[51458]	= class_set_bonus.hunter,
	[51459]	= class_set_bonus.hunter,
	[51460]	= class_set_bonus.hunter,
	[51461]	= class_set_bonus.hunter,
	[51462]	= class_set_bonus.hunter,






	[19621]	= { 24465,	3	},
	[19953]	= { 24465,	3	},
	[19833]	= { 24465,	3	},
	[19832]	= { 24465,	3	},
	[19831]	= { 24465,	3	},
	[28613]	= { 23158,	4	},
	[28614]	= { 23158,	4	},
	[28615]	= { 23158,	4	},
	[28616]	= { 23158,	4	},
	[28617]	= { 23158,	4	},
	[28805]	= { 23158,	4	},
	[28806]	= { 23158,	4	},
	[28807]	= { 23158,	4	},
	[28808]	= { 23158,	4	},
	[28809]	= { 23158,	4	},
	[35376]	= { 23158,	4	},
	[35377]	= { 23158,	4	},
	[35378]	= { 23158,	4	},
	[35379]	= { 23158,	4	},
	[35380]	= { 23158,	4	},
	[16466]	= { 23158,	3	},
	[16465]	= { 23158,	3	},
	[16468]	= { 23158,	3	},
	[16462]	= { 23158,	3	},
	[16463]	= { 23158,	3	},
	[16467]	= { 23158,	3	},
	[16569]	= { 23158,	3	},
	[16571]	= { 23158,	3	},
	[16567]	= { 23158,	3	},
	[16565]	= { 23158,	3	},
	[16566]	= { 23158,	3	},
	[16568]	= { 23158,	3	},
	[22843]	= { 23158,	4	},
	[22862]	= { 23158,	4	},
	[23251]	= { 23158,	4	},
	[23252]	= { 23158,	4	},
	[22874]	= { 23158,	4	},
	[22875]	= { 23158,	4	},
	[23292]	= { 23158,	4	},
	[23293]	= { 23158,	4	},
	[23278]	= { 23158,	4	},
	[23279]	= { 23158,	4	},
	[23306]	= { 23158,	4	},
	[23307]	= { 23158,	4	},
	[16531]	= { 23158,	4	},
	[16530]	= { 23158,	4	},
	[16525]	= { 23158,	4	},
	[16527]	= { 23158,	4	},
	[16526]	= { 23158,	4	},
	[16528]	= { 23158,	4	},
	[16425]	= { 23158,	4	},
	[16426]	= { 23158,	4	},
	[16401]	= { 23158,	4	},
	[16403]	= { 23158,	4	},
	[16428]	= { 23158,	4	},
	[16427]	= { 23158,	4	},

	[35343]	= { 23025,	4	},
	[35344]	= { 23025,	4	},
	[35345]	= { 23025,	4	},
	[35346]	= { 23025,	4	},
	[35347]	= { 23025,	4	},
	[28714]	= { 23025,	4	},
	[28715]	= { 23025,	4	},
	[28716]	= { 23025,	4	},
	[28717]	= { 23025,	4	},
	[28718]	= { 23025,	4	},
	[28866]	= { 23025,	4	},
	[28867]	= { 23025,	4	},
	[28868]	= { 23025,	4	},
	[28869]	= { 23025,	4	},
	[28870]	= { 23025,	4	},
	[16441]	= { 23025,	3	},
	[16444]	= { 23025,	3	},
	[16443]	= { 23025,	3	},
	[16437]	= { 23025,	3	},
	[16440]	= { 23025,	3	},
	[16442]	= { 23025,	3	},
	[16536]	= { 23025,	3	},
	[16533]	= { 23025,	3	},
	[16535]	= { 23025,	3	},
	[16539]	= { 23025,	3	},
	[16540]	= { 23025,	3	},
	[16534]	= { 23025,	3	},
	[22870]	= { 23025,	4	},
	[22860]	= { 23025,	4	},
	[23263]	= { 23025,	4	},
	[23264]	= { 23025,	4	},
	[22883]	= { 23025,	4	},
	[22886]	= { 23025,	4	},
	[23304]	= { 23025,	4	},
	[23305]	= { 23025,	4	},
	[23290]	= { 23025,	4	},
	[23291]	= { 23025,	4	},
	[23318]	= { 23025,	4	},
	[23319]	= { 23025,	4	},
	[16485]	= { 23025,	4	},
	[16487]	= { 23025,	4	},
	[16491]	= { 23025,	4	},
	[16490]	= { 23025,	4	},
	[16489]	= { 23025,	4	},
	[16492]	= { 23025,	4	},
	[16369]	= { 23025,	4	},
	[16391]	= { 23025,	4	},
	[16413]	= { 23025,	4	},
	[16414]	= { 23025,	4	},
	[16416]	= { 23025,	4	},
	[16415]	= { 23025,	4	},
	[29076]	= { 37439,	4	},
	[29080]	= { 37439,	4	},
	[29078]	= { 37439,	4	},
	[29079]	= { 37439,	4	},
	[29077]	= { 37439,	4	},
	[22502]	= { 28763,	2	},
	[22503]	= { 28763,	2	},
	[22498]	= { 28763,	2	},
	[22501]	= { 28763,	2	},
	[22497]	= { 28763,	2	},
	[22496]	= { 28763,	2	},
	[22500]	= { 28763,	2	},
	[22499]	= { 28763,	2	},
	[23062]	= { 28763,	2	},

	[22430]	= { 28774,	4	},
	[22431]	= { 28774,	4	},
	[22426]	= { 28774,	4	},
	[22428]	= { 28774,	4	},
	[22427]	= { 28774,	4	},
	[22429]	= { 28774,	4	},
	[22425]	= { 28774,	4	},
	[22424]	= { 28774,	4	},
	[23066]	= { 28774,	4	},
	[27702]	= { 23302,	4	},
	[27703]	= { 23302,	4	},
	[27704]	= { 23302,	4	},
	[27705]	= { 23302,	4	},
	[27706]	= { 23302,	4	},
	[27879]	= { 23302,	4	},
	[27880]	= { 23302,	4	},
	[27881]	= { 23302,	4	},
	[27882]	= { 23302,	4	},
	[27883]	= { 23302,	4	},
	[32039]	= { 23302,	4	},
	[32040]	= { 23302,	4	},
	[32041]	= { 23302,	4	},
	[32042]	= { 23302,	4	},
	[32043]	= { 23302,	4	},
	[31992]	= { 23302,	4	},
	[31993]	= { 23302,	4	},
	[31997]	= { 23302,	4	},
	[31995]	= { 23302,	4	},
	[31996]	= { 23302,	4	},
	[33749]	= { 23302,	4	},
	[33750]	= { 23302,	4	},
	[33751]	= { 23302,	4	},
	[33752]	= { 23302,	4	},
	[33753]	= { 23302,	4	},
	[33695]	= { 23302,	4	},
	[33696]	= { 23302,	4	},
	[33697]	= { 23302,	4	},
	[33698]	= { 23302,	4	},
	[33699]	= { 23302,	4	},
	[35088]	= { 23302,	4	},
	[35089]	= { 23302,	4	},
	[35090]	= { 23302,	4	},
	[35091]	= { 23302,	4	},
	[35092]	= { 23302,	4	},
	[35027]	= { 23302,	4	},
	[35028]	= { 23302,	4	},
	[35029]	= { 23302,	4	},
	[35030]	= { 23302,	4	},
	[35031]	= { 23302,	4	},
	[40780]	= class_set_bonus.paladin,
	[40798]	= class_set_bonus.paladin,
	[40818]	= class_set_bonus.paladin,
	[40838]	= class_set_bonus.paladin,
	[40858]	= class_set_bonus.paladin,
	[40782]	= class_set_bonus.paladin,
	[40802]	= class_set_bonus.paladin,
	[40821]	= class_set_bonus.paladin,
	[40842]	= class_set_bonus.paladin,
	[40861]	= class_set_bonus.paladin,
	[40785]	= class_set_bonus.paladin,
	[40805]	= class_set_bonus.paladin,
	[40825]	= class_set_bonus.paladin,
	[40846]	= class_set_bonus.paladin,
	[40864]	= class_set_bonus.paladin,
	[40788]	= class_set_bonus.paladin,
	[40808]	= class_set_bonus.paladin,
	[40828]	= class_set_bonus.paladin,
	[40849]	= class_set_bonus.paladin,
	[40869]	= class_set_bonus.paladin,
	[40792]	= class_set_bonus.paladin,
	[40812]	= class_set_bonus.paladin,
	[40831]	= class_set_bonus.paladin,
	[40852]	= class_set_bonus.paladin,
	[40872]	= class_set_bonus.paladin,
	[51474]	= class_set_bonus.paladin,
	[51475]	= class_set_bonus.paladin,
	[51476]	= class_set_bonus.paladin,
	[51477]	= class_set_bonus.paladin,
	[51479]	= class_set_bonus.paladin,

	[35402]	= { 23302,	4	},
	[35403]	= { 23302,	4	},
	[35404]	= { 23302,	4	},
	[35405]	= { 23302,	4	},
	[35406]	= { 23302,	4	},
	[35476]	= { 23302,	4	},
	[35412]	= { 23302,	4	},
	[35413]	= { 23302,	4	},
	[35477]	= { 23302,	4	},
	[35414]	= { 23302,	4	},
	[35415]	= { 23302,	4	},
	[35416]	= { 23302,	4	},
	[28679]	= { 23302,	4	},
	[28680]	= { 23302,	4	},
	[28681]	= { 23302,	4	},
	[28724]	= { 23302,	4	},
	[28683]	= { 23302,	4	},
	[28709]	= { 23302,	4	},
	[28710]	= { 23302,	4	},
	[28711]	= { 23302,	4	},
	[28712]	= { 23302,	4	},
	[28713]	= { 23302,	4	},
	[28831]	= { 23302,	4	},
	[28832]	= { 23302,	4	},
	[28833]	= { 23302,	4	},
	[28834]	= { 23302,	4	},
	[28835]	= { 23302,	4	},
	[28861]	= { 23302,	4	},
	[28862]	= { 23302,	4	},
	[28863]	= { 23302,	4	},
	[28864]	= { 23302,	4	},
	[28865]	= { 23302,	4	},
	[16473]	= { 23302,	3	},
	[16474]	= { 23302,	3	},
	[16476]	= { 23302,	3	},
	[16472]	= { 23302,	3	},
	[16471]	= { 23302,	3	},
	[16475]	= { 23302,	3	},
	[29612]	= { 23302,	3	},
	[29613]	= { 23302,	3	},
	[29614]	= { 23302,	3	},
	[29615]	= { 23302,	3	},
	[29616]	= { 23302,	3	},
	[29617]	= { 23302,	3	},
	[29600]	= { 23302,	3	},
	[29601]	= { 23302,	3	},
	[29602]	= { 23302,	3	},
	[29603]	= { 23302,	3	},
	[29604]	= { 23302,	3	},
	[29605]	= { 23302,	3	},
	[23272]	= { 23302,	4	},
	[23273]	= { 23302,	4	},
	[23274]	= { 23302,	4	},
	[23275]	= { 23302,	4	},
	[23276]	= { 23302,	4	},
	[23277]	= { 23302,	4	},
	[16410]	= { 23302,	4	},
	[16409]	= { 23302,	4	},
	[16433]	= { 23302,	4	},
	[16435]	= { 23302,	4	},
	[16434]	= { 23302,	4	},
	[16436]	= { 23302,	4	},
	[29062]	= { 37183,	4	},
	[29061]	= { 37183,	4	},
	[29065]	= { 37183,	4	},
	[29063]	= { 37183,	4	},
	[29064]	= { 37183,	4	},
	[28203]	= { 37181,	4	},
	[27535]	= { 37181,	4	},
	[28285]	= { 37181,	4	},
	[27839]	= { 37181,	4	},
	[27739]	= { 37181,	4	},

	[28684]	= { 23048,	4	},
	[28685]	= { 23048,	4	},
	[28686]	= { 23048,	4	},
	[28687]	= { 23048,	4	},
	[28688]	= { 23048,	4	},
	[28836]	= { 23048,	4	},
	[28837]	= { 23048,	4	},
	[28838]	= { 23048,	4	},
	[28839]	= { 23048,	4	},
	[28840]	= { 23048,	4	},
	[35366]	= { 23048,	4	},
	[35367]	= { 23048,	4	},
	[35368]	= { 23048,	4	},
	[35369]	= { 23048,	4	},
	[35370]	= { 23048,	4	},
	[16453]	= { 23048,	3	},
	[16457]	= { 23048,	3	},
	[16455]	= { 23048,	3	},
	[16446]	= { 23048,	3	},
	[16454]	= { 23048,	3	},
	[16456]	= { 23048,	3	},
	[16563]	= { 23048,	3	},
	[16561]	= { 23048,	3	},
	[16562]	= { 23048,	3	},
	[16564]	= { 23048,	3	},
	[16560]	= { 23048,	3	},
	[16558]	= { 23048,	3	},
	[22864]	= { 23048,	4	},
	[22856]	= { 23048,	4	},
	[22879]	= { 23048,	4	},
	[22880]	= { 23048,	4	},
	[23257]	= { 23048,	4	},
	[23258]	= { 23048,	4	},
	[23298]	= { 23048,	4	},
	[23299]	= { 23048,	4	},
	[23284]	= { 23048,	4	},
	[23285]	= { 23048,	4	},
	[23312]	= { 23048,	4	},
	[23313]	= { 23048,	4	},
	[16498]	= { 23048,	4	},
	[16499]	= { 23048,	4	},
	[16505]	= { 23048,	4	},
	[16508]	= { 23048,	4	},
	[16506]	= { 23048,	4	},
	[16507]	= { 23048,	4	},
	[16392]	= { 23048,	4	},
	[16396]	= { 23048,	4	},
	[16417]	= { 23048,	4	},
	[16419]	= { 23048,	4	},
	[16420]	= { 23048,	4	},
	[16418]	= { 23048,	4	},
	[16827]	= { 21874,	2	},
	[16824]	= { 21874,	2	},
	[16825]	= { 21874,	2	},
	[16820]	= { 21874,	2	},
	[16821]	= { 21874,	2	},
	[16826]	= { 21874,	2	},
	[16822]	= { 21874,	2	},
	[16823]	= { 21874,	2	},
	[19617]	= { 24469,	3	},
	[19954]	= { 24469,	3	},
	[19836]	= { 24469,	3	},
	[19835]	= { 24469,	3	},
	[19834]	= { 24469,	3	},
	[21359]	= { 26112,	3	},
	[21360]	= { 26112,	3	},
	[21361]	= { 26112,	3	},
	[21362]	= { 26112,	3	},
	[21364]	= { 26112,	3	},

	[31396]	= class_set_bonus.shaman,
	[31397]	= class_set_bonus.shaman,
	[31400]	= class_set_bonus.shaman,
	[31406]	= class_set_bonus.shaman,
	[31407]	= class_set_bonus.shaman,
	[32029]	= class_set_bonus.shaman,
	[32030]	= class_set_bonus.shaman,
	[32031]	= class_set_bonus.shaman,
	[32032]	= class_set_bonus.shaman,
	[32033]	= class_set_bonus.shaman,
	[33738]	= class_set_bonus.shaman,
	[33739]	= class_set_bonus.shaman,
	[33740]	= class_set_bonus.shaman,
	[33741]	= class_set_bonus.shaman,
	[33742]	= class_set_bonus.shaman,
	[35077]	= class_set_bonus.shaman,
	[35078]	= class_set_bonus.shaman,
	[35079]	= class_set_bonus.shaman,
	[35080]	= class_set_bonus.shaman,
	[35081]	= class_set_bonus.shaman,
	[40987]	= class_set_bonus.shaman,
	[41004]	= class_set_bonus.shaman,
	[41016]	= class_set_bonus.shaman,
	[41030]	= class_set_bonus.shaman,
	[41041]	= class_set_bonus.shaman,
	[40986]	= class_set_bonus.shaman,
	[40998]	= class_set_bonus.shaman,
	[41010]	= class_set_bonus.shaman,
	[41023]	= class_set_bonus.shaman,
	[41024]	= class_set_bonus.shaman,
	[40989]	= class_set_bonus.shaman,
	[41005]	= class_set_bonus.shaman,
	[41017]	= class_set_bonus.shaman,
	[41031]	= class_set_bonus.shaman,
	[41042]	= class_set_bonus.shaman,
	[40988]	= class_set_bonus.shaman,
	[40999]	= class_set_bonus.shaman,
	[41011]	= class_set_bonus.shaman,
	[41025]	= class_set_bonus.shaman,
	[41036]	= class_set_bonus.shaman,
	[40991]	= class_set_bonus.shaman,
	[41006]	= class_set_bonus.shaman,
	[41018]	= class_set_bonus.shaman,
	[41032]	= class_set_bonus.shaman,
	[41043]	= class_set_bonus.shaman,
	[40990]	= class_set_bonus.shaman,
	[41000]	= class_set_bonus.shaman,
	[41012]	= class_set_bonus.shaman,
	[41026]	= class_set_bonus.shaman,
	[41037]	= class_set_bonus.shaman,
	[40993]	= class_set_bonus.shaman,
	[41007]	= class_set_bonus.shaman,
	[41019]	= class_set_bonus.shaman,
	[41033]	= class_set_bonus.shaman,
	[41044]	= class_set_bonus.shaman,
	[40992]	= class_set_bonus.shaman,
	[41001]	= class_set_bonus.shaman,
	[41013]	= class_set_bonus.shaman,
	[41027]	= class_set_bonus.shaman,
	[41038]	= class_set_bonus.shaman,
	[40995]	= class_set_bonus.shaman,
	[41008]	= class_set_bonus.shaman,
	[41020]	= class_set_bonus.shaman,
	[41034]	= class_set_bonus.shaman,
	[41045]	= class_set_bonus.shaman,
	[40994]	= class_set_bonus.shaman,
	[41002]	= class_set_bonus.shaman,
	[41014]	= class_set_bonus.shaman,
	[41028]	= class_set_bonus.shaman,
	[41039]	= class_set_bonus.shaman,
	[51509]	= class_set_bonus.shaman,
	[51510]	= class_set_bonus.shaman,
	[51511]	= class_set_bonus.shaman,
	[51512]	= class_set_bonus.shaman,
	[51514]	= class_set_bonus.shaman,
	[51497]	= class_set_bonus.shaman,
	[51498]	= class_set_bonus.shaman,
	[51499]	= class_set_bonus.shaman,
	[51500]	= class_set_bonus.shaman,
	[51502]	= class_set_bonus.shaman,

	[29032]	= { 37211,	4	},
	[29029]	= { 37211,	4	},
	[29028]	= { 37211,	4	},
	[29030]	= { 37211,	4	},
	[29031]	= { 37211,	4	},
	[35391]	= { 38466,	4	},
	[35392]	= { 38466,	4	},
	[35393]	= { 38466,	4	},
	[35394]	= { 38466,	4	},
	[35395]	= { 38466,	4	},
	[31640]	= { 38499,	4	},
	[31641]	= { 38499,	4	},
	[31642]	= { 38499,	4	},
	[31643]	= { 38499,	4	},
	[31644]	= { 38499,	4	},
	[31646]	= { 38499,	4	},
	[31647]	= { 38499,	4	},
	[31648]	= { 38499,	4	},
	[31649]	= { 38499,	4	},
	[31650]	= { 38499,	4	},
	[25997]	= class_set_bonus.enhance,
	[26000]	= class_set_bonus.enhance,
	[25998]	= class_set_bonus.enhance,
	[26001]	= class_set_bonus.enhance,
	[25999]	= class_set_bonus.enhance,
	[32004]	= class_set_bonus.enhance,
	[32005]	= class_set_bonus.enhance,
	[32006]	= class_set_bonus.enhance,
	[32007]	= class_set_bonus.enhance,
	[32008]	= class_set_bonus.enhance,
	[33706]	= class_set_bonus.enhance,
	[33707]	= class_set_bonus.enhance,
	[33708]	= class_set_bonus.enhance,
	[33709]	= class_set_bonus.enhance,
	[33710]	= class_set_bonus.enhance,
	[35042]	= class_set_bonus.enhance,
	[35043]	= class_set_bonus.enhance,
	[35044]	= class_set_bonus.enhance,
	[35045]	= class_set_bonus.enhance,
	[35046]	= class_set_bonus.enhance,
	[41078]	= class_set_bonus.enhance,
	[41134]	= class_set_bonus.enhance,
	[41148]	= class_set_bonus.enhance,
	[41160]	= class_set_bonus.enhance,
	[41208]	= class_set_bonus.enhance,
	[41079]	= class_set_bonus.enhance,
	[41135]	= class_set_bonus.enhance,
	[41149]	= class_set_bonus.enhance,
	[41162]	= class_set_bonus.enhance,
	[41209]	= class_set_bonus.enhance,
	[41080]	= class_set_bonus.enhance,
	[41136]	= class_set_bonus.enhance,
	[41150]	= class_set_bonus.enhance,
	[41198]	= class_set_bonus.enhance,
	[41210]	= class_set_bonus.enhance,
	[41081]	= class_set_bonus.enhance,
	[41137]	= class_set_bonus.enhance,
	[41151]	= class_set_bonus.enhance,
	[41199]	= class_set_bonus.enhance,
	[41211]	= class_set_bonus.enhance,
	[41082]	= class_set_bonus.enhance,
	[41138]	= class_set_bonus.enhance,
	[41152]	= class_set_bonus.enhance,
	[41200]	= class_set_bonus.enhance,
	[41212]	= class_set_bonus.enhance,
	[51503]	= class_set_bonus.enhance,
	[51504]	= class_set_bonus.enhance,
	[51505]	= class_set_bonus.enhance,
	[51506]	= class_set_bonus.enhance,
	[51508]	= class_set_bonus.enhance,

	[28689]	= class_set_bonus.enhance,
	[28690]	= class_set_bonus.enhance,
	[28691]	= class_set_bonus.enhance,
	[28692]	= class_set_bonus.enhance,
	[28693]	= class_set_bonus.enhance,
	[28841]	= class_set_bonus.enhance,
	[28842]	= class_set_bonus.enhance,
	[28843]	= class_set_bonus.enhance,
	[28844]	= class_set_bonus.enhance,
	[28845]	= class_set_bonus.enhance,
	[35381]	= class_set_bonus.enhance,
	[35382]	= class_set_bonus.enhance,
	[35383]	= class_set_bonus.enhance,
	[35384]	= class_set_bonus.enhance,
	[35385]	= class_set_bonus.enhance,

	[19605]	= { 24487,	5	},
	[19957]	= { 24487,	5	},
	[19848]	= { 24487,	5	},
	[19849]	= { 24487,	5	},
	[20033]	= { 24487,	5	},

	[19951]	= { 24456,	3	},
	[19577]	= { 24456,	3	},
	[19824]	= { 24456,	3	},
	[19823]	= { 24456,	3	},
	[19822]	= { 24456,	3	},
	[24544]	= class_set_bonus.warrior,
	[24549]	= class_set_bonus.warrior,
	[24545]	= class_set_bonus.warrior,
	[24547]	= class_set_bonus.warrior,
	[24546]	= class_set_bonus.warrior,
	[30486]	= class_set_bonus.warrior,
	[30487]	= class_set_bonus.warrior,
	[30488]	= class_set_bonus.warrior,
	[30489]	= class_set_bonus.warrior,
	[30490]	= class_set_bonus.warrior,
	[33728]	= class_set_bonus.warrior,
	[33729]	= class_set_bonus.warrior,
	[33730]	= class_set_bonus.warrior,
	[33731]	= class_set_bonus.warrior,
	[33732]	= class_set_bonus.warrior,
	[35066]	= class_set_bonus.warrior,
	[35067]	= class_set_bonus.warrior,
	[35068]	= class_set_bonus.warrior,
	[35069]	= class_set_bonus.warrior,
	[35070]	= class_set_bonus.warrior,
	[40778]	= class_set_bonus.warrior,
	[40797]	= class_set_bonus.warrior,
	[40816]	= class_set_bonus.warrior,
	[40836]	= class_set_bonus.warrior,
	[40856]	= class_set_bonus.warrior,
	[40783]	= class_set_bonus.warrior,
	[40801]	= class_set_bonus.warrior,
	[40819]	= class_set_bonus.warrior,
	[40840]	= class_set_bonus.warrior,
	[40859]	= class_set_bonus.warrior,
	[40786]	= class_set_bonus.warrior,
	[40804]	= class_set_bonus.warrior,
	[40823]	= class_set_bonus.warrior,
	[40844]	= class_set_bonus.warrior,
	[40862]	= class_set_bonus.warrior,
	[40789]	= class_set_bonus.warrior,
	[40807]	= class_set_bonus.warrior,
	[40826]	= class_set_bonus.warrior,
	[40847]	= class_set_bonus.warrior,
	[40866]	= class_set_bonus.warrior,
	[40790]	= class_set_bonus.warrior,
	[40810]	= class_set_bonus.warrior,
	[40829]	= class_set_bonus.warrior,
	[40850]	= class_set_bonus.warrior,
	[40870]	= class_set_bonus.warrior,
	[51541]	= class_set_bonus.warrior,
	[51542]	= class_set_bonus.warrior,
	[51543]	= class_set_bonus.warrior,
	[51544]	= class_set_bonus.warrior,
	[51545]	= class_set_bonus.warrior,

	[28699]	= class_set_bonus.warrior,
	[28700]	= class_set_bonus.warrior,
	[28701]	= class_set_bonus.warrior,
	[28702]	= class_set_bonus.warrior,
	[28703]	= class_set_bonus.warrior,
	[28851]	= class_set_bonus.warrior,
	[28852]	= class_set_bonus.warrior,
	[28853]	= class_set_bonus.warrior,
	[28854]	= class_set_bonus.warrior,
	[28855]	= class_set_bonus.warrior,
	[35407]	= class_set_bonus.warrior,
	[35408]	= class_set_bonus.warrior,
	[35409]	= class_set_bonus.warrior,
	[35410]	= class_set_bonus.warrior,
	[35411]	= class_set_bonus.warrior,
	[16477]	= { 22738,	3	},
	[16478]	= { 22738,	3	},
	[16480]	= { 22738,	3	},
	[16483]	= { 22738,	3	},
	[16484]	= { 22738,	3	},
	[16479]	= { 22738,	3	},
	[16541]	= { 22738,	3	},
	[16542]	= { 22738,	3	},
	[16544]	= { 22738,	3	},
	[16545]	= { 22738,	3	},
	[16548]	= { 22738,	3	},
	[16543]	= { 22738,	3	},
	[22868]	= class_set_bonus.warrior,
	[22858]	= class_set_bonus.warrior,
	[22872]	= class_set_bonus.warrior,
	[22873]	= class_set_bonus.warrior,
	[23244]	= class_set_bonus.warrior,
	[23243]	= class_set_bonus.warrior,
	[23300]	= class_set_bonus.warrior,
	[23301]	= class_set_bonus.warrior,
	[23286]	= class_set_bonus.warrior,
	[23287]	= class_set_bonus.warrior,
	[23314]	= class_set_bonus.warrior,
	[23315]	= class_set_bonus.warrior,
	[16509]	= class_set_bonus.warrior,
	[16510]	= class_set_bonus.warrior,
	[16513]	= class_set_bonus.warrior,
	[16515]	= class_set_bonus.warrior,
	[16514]	= class_set_bonus.warrior,
	[16516]	= class_set_bonus.warrior,
	[16405]	= class_set_bonus.warrior,
	[16406]	= class_set_bonus.warrior,
	[16430]	= class_set_bonus.warrior,
	[16431]	= class_set_bonus.warrior,
	[16429]	= class_set_bonus.warrior,
	[16432]	= class_set_bonus.warrior,
}

E.item_unity = E.BLANK





E.sync_cooldowns = E.BLANK
E.sync_in_raid = E.BLANK
E.sync_reset = E.BLANK

E:ProcessSpellDB()
