local E = select(2,	...):unpack()

E.spell_db = {
	["DEATHKNIGHT"] = {
		{ spellID = 47528,	duration = 15,	type = "interrupt",	},
		{ spellID = 108194,	duration = 30,	type = "cc",	spec = true	},
		{ spellID = 108200,	duration = 60,	type = "cc",	spec = true	},
		{ spellID = 108199,	duration = 60,	type = "aoeCC",	spec = true	},
		{ spellID = 49576,	duration = 25,	type = "disarm",	},
		{ spellID = 47476,	duration = 60,	type = "disarm",	talent = 108194	},
		{ spellID = 48707,	duration = 45,	type = "defensive",	},
		{ spellID = 49222,	duration = 60,	type = "defensive",	spec = {250}	},
		{ spellID = 49028,	duration = 90,	type = "defensive",	spec = {250}	},
		{ spellID = 48792,	duration = 180,	type = "defensive",	},
		{ spellID = 114556,	duration = 180,	type = "defensive",	spec = true	},
		{ spellID = 48982,	duration = 30,	type = "defensive",	spec = {250}	},
		{ spellID = 55233,	duration = 60,	type = "defensive",	spec = {250}	},
		{ spellID = 51052,	duration = 120,	type = "raidDefensive",	spec = true	},
		{ spellID = 48743,	duration = 120,	type = "heal",	spec = true	},
		{ spellID = 42650,	duration = 600,	type = "offensive",	},
		{ spellID = 43265,	duration = 30,	type = "offensive",	},
		{ spellID = 47568,	duration = 300,	type = "offensive",	},
		{ spellID = 57330,	duration = 20,	type = "offensive",	},
		{ spellID = 77575,	duration = {[250]=30,default=60},	type = "offensive",	},
		{ spellID = 51271,	duration = 60,	type = "offensive",	spec = {251}	},
		{ spellID = 49206,	duration = 180,	type = "offensive",	spec = {252}	},
		{ spellID = 115989,	duration = 90,	type = "offensive",	spec = true	},
		{ spellID = 49016,	duration = 180,	type = "offensive",	spec = {252}	},
		{ spellID = 108201,	duration = 120,	type = "counterCC",	spec = true	},
		{ spellID = 49039,	duration = 120,	type = "counterCC",	spec = true	},
		{ spellID = 96268,	duration = 30,	type = "movement",	spec = true	},
		{ spellID = 77606,	duration = {[250]=30,default=60},	type = "other",	},
		{ spellID = 123693,	duration = 25,	type = "other",	spec = true	},
		{ spellID = 61999,	duration = 600,	type = "other",	},
		{ spellID = 46584,	duration = {[252]=60,default=120},	type = "other",	},
		{ spellID = 56222,	duration = 8,	type = "taunt",	spec = {250}	},

		{ spellID = 113072,	duration = 180,	type = "defensive",	spec = true	},
		{ spellID = 113516,	duration = 180,	type = "defensive",	spec = true	},
	},
	["DRUID"] = {
		{ spellID = 80964,	duration = 15,	type = "interrupt",	spec = {103,104}	},
		{ spellID = 78675,	duration = 60,	type = "interrupt",	spec = {102}	},
		{ spellID = 88423,	duration = 8,	type = "dispel",	spec = {105}	},
		{ spellID = 2782,	duration = 8,	type = "dispel",	spec = {102,103,104}	},
		{ spellID = 102795,	duration = 60,	type = "cc",	spec = {104}	},
		{ spellID = 99,	duration = 30,	type = "aoeCC",	spec = true	},
		{ spellID = 22570,	duration = 10,	type = "cc",	},
		{ spellID = 5211,	duration = 50,	type = "cc",	spec = true	},
		{ spellID = 132469,	duration = 30,	type = "aoeCC",	spec = true	},
		{ spellID = 770,	duration = 0,	type = "disarm",	spec = 114237	},
		{ spellID = 106737,	duration = 20,	type = "disarm",	spec = true,	charges = 3	},
		{ spellID = 102359,	duration = 30,	type = "disarm",	spec = true	},
		{ spellID = 16689,	duration = 60,	type = "disarm",	},
		{ spellID = 102793,	duration = 60,	type = "disarm",	spec = true	},
		{ spellID = 22812,	duration = {[105]=45,[104]=30,default=60},	type = "defensive",	},
		{ spellID = 106922,	duration = 180,	type = "defensive",	},
		{ spellID = 108238,	duration = 120,	type = "defensive",	spec = true	},
		{ spellID = 62606,	duration = 9,	type = "defensive",	spec = {104},	charges = 3	},
		{ spellID = 61336,	duration = 180,	type = "defensive",	spec = {103,104}	},
		{ spellID = 102342,	duration = 60,	type = "externalDefensive",	spec = {105}	},
		{ spellID = 124974,	duration = 90,	type = "raidDefensive",	spec = true	},
		{ spellID = 740,	duration = {[105]=180,default=480},	type = "raidDefensive",	buff = 44203	},
		{ spellID = 102351,	duration = 30,	type = "heal",	spec = true	},
		{ spellID = 18562,	duration = 15,	type = "heal",	spec = {105}	},
		{ spellID = 50334,	duration = 180,	type = "offensive",	spec = {104}	},
		{ spellID = 106951,	duration = 180,	type = "offensive",	spec = {103}	},
		{ spellID = 112071,	duration = 180,	type = "offensive",	spec = {102}	},
		{ spellID = 108291,	duration = {[104]=180,default=360},	type = "offensive",	spec = 108288	},
		{ spellID = 102558,	duration = 180,	type = "offensive",	spec = 106731	},
		{ spellID = 48505,	duration = 90,	type = "offensive",	spec = {102}	},
		{ spellID = 78674,	duration = 15,	type = "offensive",	spec = {102}	},
		{ spellID = 5217,	duration = 30,	type = "offensive",	spec = {103}	},
		{ spellID = 1850,	duration = 180,	type = "movement",	},
		{ spellID = 102280,	duration = 30,	type = "movement",	spec = true	},
		{ spellID = 102417,	duration = 15,	type = "movement",	spec = 102401	},
		{ spellID = 106898,	duration = 120,	type = "raidMovement",	},
		{ spellID = 5229,	duration = 60,	type = "other",	spec = {104}	},
		{ spellID = 29166,	duration = 180,	type = "other",	},
		{ spellID = 132158,	duration = 60,	type = "other",	spec = {102,103,105}	},
		{ spellID = 5215,	duration = 10,	type = "other",	},
		{ spellID = 20484,	duration = 600,	type = "other",	},
		{ spellID = 6795,	duration = 8,	type = "taunt",	},

		{ spellID = 110570,	duration = 45,	type = "defensive",	spec = true	},
		{ spellID = 122282,	duration = 0,	type = "offensive",	spec = true	},
		{ spellID = 122285,	duration = 60,	type = "defensive",	spec = true	},
		{ spellID = 110575,	duration = 180,	type = "defensive",	spec = true	},
		{ spellID = 110588,	duration = 30,	type = "other",	spec = true	},
		{ spellID = 110597,	duration = 30,	type = "other",	spec = true	},
		{ spellID = 110600,	duration = 30,	type = "other",	spec = true	},
		{ spellID = 110617,	duration = 120,	type = "immunity",	spec = true	},
		{ spellID = 110621,	duration = 180,	type = "offensive",	spec = true	},
		{ spellID = 110693,	duration = 25,	type = "disarm",	spec = true	},
		{ spellID = 110694,	duration = 0,	type = "defensive",	spec = true	},
		{ spellID = 110696,	duration = 300,	type = "immunity",	spec = true	},
		{ spellID = 126458,	duration = 60,	type = "disarm",	spec = true	},
		{ spellID = 126449,	duration = 35,	type = "cc",	spec = true	},
		{ spellID = 126453,	duration = 60,	type = "defensive",	spec = true	},
		{ spellID = 126456,	duration = 180,	type = "defensive",	spec = true	},
		{ spellID = 110698,	duration = 60,	type = "cc",	spec = true	},
		{ spellID = 110700,	duration = 300,	type = "immunity",	spec = true	},
		{ spellID = 110701,	duration = 30,	type = "offensive",	spec = true	},
		{ spellID = 122288,	duration = 8,	type = "dispel",	spec = true	},
		{ spellID = 110707,	duration = 60,	type = "dispel",	spec = true	},
		{ spellID = 110715,	duration = 180,	type = "defensive",	spec = true	},
		{ spellID = 110717,	duration = 180,	type = "counterCC",	spec = true	},
		{ spellID = 110718,	duration = 90,	type = "movement",	spec = true	},
		{ spellID = 110788,	duration = 120,	type = "defensive",	spec = true	},
		{ spellID = 110730,	duration = 60,	type = "other",	spec = true	},
		{ spellID = 122289,	duration = 0,	type = "defensive",	spec = true	},
		{ spellID = 110791,	duration = 180,	type = "defensive",	spec = true	},
		{ spellID = 110802,	duration = 0,	type = "dispel",	spec = true	},
		{ spellID = 110807,	duration = 120,	type = "offensive",	spec = true	},
		{ spellID = 110803,	duration = 0,	type = "other",	spec = true	},
		{ spellID = 110806,	duration = 120,	type = "other",	spec = true	},
		{ spellID = 122291,	duration = 180,	type = "defensive",	spec = true	},
		{ spellID = 110810,	duration = 30,	type = "other",	spec = true	},
		{ spellID = 122290,	duration = 15,	type = "other",	spec = true	},
		{ spellID = 112970,	duration = 30,	type = "movement",	spec = true	},
		{ spellID = 122292,	duration = 60,	type = "counterCC",	spec = true	},
		{ spellID = 112997,	duration = 300,	type = "other",	spec = true	},
		{ spellID = 113002,	duration = 120,	type = "counterCC",	spec = true	},
		{ spellID = 113004,	duration = 90,	type = "cc",	spec = true	},
	},
	["HUNTER"] = {
		{ spellID = 147362,	duration = 24,	type = "interrupt",	spec = {253,255}	},
		{ spellID = 34490,	duration = 24,	type = "interrupt",	spec = {254}	},
		{ spellID = 19801,	duration = 10,	type = "dispel",	spec = 119384	},
		{ spellID = 1499,	duration = {[255]=24,default=30},	type = "cc",	},
		{ spellID = 19577,	duration = 60,	type = "cc",	spec = true	},
		{ spellID = 19503,	duration = 30,	type = "cc",	},
		{ spellID = 19386,	duration = 45,	type = "cc",	spec = true	},
		{ spellID = 109248,	duration = 45,	type = "aoeCC",	spec = true	},
		{ spellID = 19263,	duration = 180,	type = "immunity",	charges = 2	},
		{ spellID = 51753,	duration = 60,	type = "defensive",	buff = 51755	},
		{ spellID = 53480,	duration = 60,	type = "externalDefensive",	},
		{ spellID = 109304,	duration = 120,	type = "heal",	spec = true	},
		{ spellID = 131894,	duration = 120,	type = "offensive",	spec = true	},
		{ spellID = 120360,	duration = 30,	type = "offensive",	spec = true	},
		{ spellID = 19574,	duration = 60,	type = "offensive",	spec = {253}	},
		{ spellID = 3674,	duration = 24,	type = "offensive",	spec = {255}	},
		{ spellID = 120679,	duration = 30,	type = "offensive",	spec = true},
		{ spellID = 13813,	duration = {[255]=24,default=30},	type = "offensive",	},
		{ spellID = 117050,	duration = 15,	type = "offensive",	spec = true	},
		{ spellID = 120697,	duration = 90,	type = "offensive",	spec = true	},
		{ spellID = 109259,	duration = 45,	type = "offensive",	spec = true	},
		{ spellID = 3045,	duration = 180,	type = "offensive",	},
		{ spellID = 34600,	duration = {[255]=24,default=30},	type = "offensive",	},
		{ spellID = 121818,	duration = 300,	type = "offensive",	},
		{ spellID = 53271,	duration = 45,	type = "freedom",	buff = 54216	},
		{ spellID = 781,	duration = 20,	type = "movement",	},
		{ spellID = 5384,	duration = 30,	type = "other",	},
		{ spellID = 82726,	duration = 30,	type = "other",	spec = true	},
		{ spellID = 1543,	duration = 20,	type = "other",	},
		{ spellID = 13809,	duration = {[255]=24,default=30},	type = "other",	},
		{ spellID = 34477,	duration = 30,	type = "other",	},
		{ spellID = 20736,	duration = 8,	type = "taunt",	},

		{ spellID = 113073,	duration = 180,	type = "movement",	spec = true	},
	},
	["MAGE"] = {
		{ spellID = 2139,	duration = 24,	type = "interrupt",	},
		{ spellID = 475,	duration = 8,	type = "dispel",	},
		{ spellID = 44572,	duration = 30,	type = "cc",	},
		{ spellID = 31661,	duration = 20,	type = "aoeCC",	spec = {63}	},
		{ spellID = 113724,	duration = 45,	type = "aoeCC",	spec = true	},
		{ spellID = 33395,	duration = 25,	type = "disarm",	spec = {64}	},
		{ spellID = 122,	duration = 25,	type = "disarm",	},
		{ spellID = 102051,	duration = 20,	type = "disarm",	spec = true	},
		{ spellID = 111264,	duration = 20,	type = "disarm",	spec = true	},
		{ spellID = 45438,	duration = 300,	type = "immunity",	},
		{ spellID = 108978,	duration = 180,	type = "defensive",	},
		{ spellID = 86949,	duration = 120,	type = "defensive",	spec = true	},
		{ spellID = 11958,	duration = 180,	type = "defensive",	spec = true	},
		{ spellID = 110959,	duration = 90,	type = "defensive",	spec = true	},
		{ spellID = 11426,	duration = 25,	type = "defensive",	spec = true	},
		{ spellID = 115610,	duration = 25,	type = "defensive",	spec = true	},
		{ spellID = 12042,	duration = 90,	type = "offensive",	spec = {62}	},
		{ spellID = 11129,	duration = 45,	type = "offensive",	spec = {63}	},
		{ spellID = 84714,	duration = 60,	type = "offensive",	spec = {64}	},
		{ spellID = 12472,	duration = 180,	type = "offensive",	spec = {64}	},
		{ spellID = 1463,	duration = 25,	type = "offensive",	spec = true	},
		{ spellID = 55342,	duration = 180,	type = "offensive",	},
		{ spellID = 80353,	duration = 300,	type = "offensive",	},
		{ spellID = 108843,	duration = 25,	type = "movement",	spec = true	},
		{ spellID = 1953,	duration = 15,	type = "movement",	},
		{ spellID = 12051,	duration = 120,	type = "other",	talent = {114003,116011}	},
		{ spellID = 108839,	duration = 20,	type = "other",	spec = true,	charges = 3	},
		{ spellID = 66,	duration = 300,	type = "other",	talent = 110959	},
		{ spellID = 12043,	duration = 90,	type = "other",	spec = true	},
		{ spellID = 31687,	duration = 60,	type = "other",	spec = {64}	},

		{ spellID = 113074,	duration = 10,	type = "heal",	spec = true	},
	},
	["MONK"] = {
		{ spellID = 137562,	duration = 120,	type = "pvptrinket",	},
		{ spellID = 116705,	duration = 15,	type = "interrupt",	},
		{ spellID = 115450,	duration = 8,	type = "dispel",	},
		{ spellID = 119392,	duration = 30,	type = "cc",	spec = true	},
		{ spellID = 122057,	duration = 35,	type = "cc",	spec = {268}	},
		{ spellID = 115078,	duration = 15,	type = "cc",	},
		{ spellID = 119381,	duration = 45,	type = "aoeCC",	spec = true	},
		{ spellID = 116844,	duration = 45,	type = "aoeCC",	spec = true	},
		{ spellID = 117368,	duration = 60,	type = "disarm",	},
		{ spellID = 122278,	duration = 90,	type = "defensive",	spec = true	},
		{ spellID = 122783,	duration = 90,	type = "defensive",	spec = true	},
		{ spellID = 115203,	duration = 180,	type = "defensive",	buff = 120954	},
		{ spellID = 115295,	duration = 30,	type = "defensive",	sepc = {268}	},
		{ spellID = 122470,	duration = 90,	type = "defensive",	spec = {269},	buff = 125174	},
		{ spellID = 115176,	duration = 180,	type = "defensive",	},
		{ spellID = 115213,	duration = 180,	type = "externalDefensive",	spec = {268}	},
		{ spellID = 116849,	duration = 120,	type = "externalDefensive",	spec = {270}	},
		{ spellID = 115310,	duration = 180,	type = "raidDefensive",	spec = {270}	},
		{ spellID = 123986,	duration = 30,	type = "offensive",	spec = true	},
		{ spellID = 115098,	duration = 15,	type = "offensive",	spec = true	},
		{ spellID = 115072,	duration = 15,	type = "offensive",	},
		{ spellID = 113656,	duration = 25,	type = "offensive",	spec = {269}	},
		{ spellID = 123995,	duration = 180,	type = "offensive",	spec = 123904,	icon = 620832	},
		{ spellID = 115080,	duration = 90,	type = "offensive",	},
		{ spellID = 116841,	duration = 30,	type = "freedom",	spec = true	},
		{ spellID = 115008,	duration = 20,	type = "movement",	spec = true,	charges = 2	},
		{ spellID = 101545,	duration = 25,	type = "movement",	spec = {269},	},
		{ spellID = 109132,	duration = 20,	type = "movement",	charges = 2, talent = 115008	},
		{ spellID = 119996,	duration = 25,	type = "movement",	},
		{ spellID = 115399,	duration = 45,	type = "other",	spec = true,	charges = 2	},
		{ spellID = 115288,	duration = 60,	type = "other",	spec = {269},	},
		{ spellID = 115315,	duration = 30,	type = "other",	spec = {268}	},
		{ spellID = 115313,	duration = 30,	type = "other",	spec = {270}	},
		{ spellID = 116680,	duration = 45,	type = "other",	spec = {270}	},
		{ spellID = 115546,	duration = 8,	type = "taunt",	},

		{ spellID = 113306,	duration = 180,	type = "defensive",	spec = true	},
		{ spellID = 127361,	duration = 60,	type = "cc",	spec = true	},
		{ spellID = 113275,	duration = 0,	type = "disarm",	spec = true	},
	},
	["PALADIN"] = {
		{ spellID = 31935,	duration = 15,	type = "interrupt",	spec = {66}	},
		{ spellID = 96231,	duration = 15,	type = "interrupt",	},
		{ spellID = 4987,	duration = 8,	type = "dispel",	},
		{ spellID = 105593,	duration = 30,	type = "cc",	spec = true	},
		{ spellID = 853,	duration = 60,	type = "cc",	talent = 105593	},
		{ spellID = 20066,	duration = 15,	type = "cc",	spec = true	},
		{ spellID = 10326,	duration = 15,	type = "cc",	},
		{ spellID = 115750,	duration = 120,	type = "aoeCC",	},
		{ spellID = 642,	duration = 300,	type = "immunity",	},
		{ spellID = 31850,	duration = 180,	type = "defensive",	spec = {66}	},
		{ spellID = 498,	duration = 60,	type = "defensive",	},
		{ spellID = 86659,	duration = 180,	type = "defensive",	spec = {66}	},
		{ spellID = 1022,	duration = 300,	type = "externalDefensive",	},
		{ spellID = 114039,	duration = 30,	type = "externalDefensive",	spec = true	},
		{ spellID = 6940,	duration = 120,	type = "externalDefensive",	},
		{ spellID = 633,	duration = 600,	type = "externalDefensive",	},
		{ spellID = 31821,	duration = 180,	type = "raidDefensive",	},
		{ spellID = 86669,	duration = 180,	type = "heal",	spec = {65}	},
		{ spellID = 31884,	duration = 180,	type = "offensive",	},
		{ spellID = 31842,	duration = 180,	type = "offensive",	spec = {65}	},
		{ spellID = 114157,	duration = 60,	type = "offensive",	spec = true	},
		{ spellID = 879,	duration = 15,	type = "offensive",	spec = {70}	},
		{ spellID = 86698,	duration = 180,	type = "offensive",	spec = {70}	},
		{ spellID = 105809,	duration = 120,	type = "offensive",	spec = true	},
		{ spellID = 114165,	duration = 20,	type = "offensive",	spec = true	},
		{ spellID = 114158,	duration = 60,	type = "offensive",	spec = true	},
		{ spellID = 1044,	duration = 25,	type = "freedom",	},
		{ spellID = 85499,	duration = 45,	type = "movement",	spec = true	},
		{ spellID = 54428,	duration = 120,	type = "other",	spec = {65}	},
		{ spellID = 1038,	duration = 120,	type = "other",	},
		{ spellID = 62124,	duration = 8,	type = "taunt",	},

		{ spellID = 113269,	duration = 600,	type = "other",	spec = true	},
		{ spellID = 113075,	duration = 60,	type = "defensive",	spec = true	},
		{ spellID = 122287,	duration = 0,	type = "offensive",	spec = true	},
	},

	["PRIEST"] = {
		{ spellID = 15487,	duration = 45,	type = "interrupt",	spec = {258}	},
		{ spellID = 32375,	duration = 15,	type = "dispel",	},
		{ spellID = 527,	duration = 15,	type = "dispel",	spec = {256,257}	},
		{ spellID = 88625,	duration = 30,	type = "cc",	spec = {257}	},
		{ spellID = 64044,	duration = 45,	type = "cc",	spec = {258}	},
		{ spellID = 108921,	duration = 45,	type = "cc",	spec = true	},
		{ spellID = 8122,	duration = 30,	type = "aoeCC",	},
		{ spellID = 108920,	duration = 30,	type = "disarm",	spec = true	},
		{ spellID = 19236,	duration = 120,	type = "defensive",	spec = true	},
		{ spellID = 47585,	duration = 120,	type = "defensive",	spec = {258}	},
		{ spellID = 109964,	duration = 60,	type = "defensive",	spec = {256}	},
		{ spellID = 108968,	duration = 300,	type = "defensive",	spec = {256,257}	},
		{ spellID = 142723,	duration = 600,	type = "defensive",	spec = {258}	},
		{ spellID = 47788,	duration = 180,	type = "externalDefensive",	spec = {257}	},
		{ spellID = 33206,	duration = 180,	type = "externalDefensive",	spec = {256}	},
		{ spellID = 64843,	duration = 180,	type = "raidDefensive",	spec = {257}	},
		{ spellID = 126135,	duration = 180,	type = "raidDefensive",	spec = {257}	},
		{ spellID = 62618,	duration = 180,	type = "raidDefensive",	spec = {256}	},
		{ spellID = 15286,	duration = 180,	type = "raidDefensive",	spec = {258}	},
		{ spellID = 81700,	duration = 30,	type = "heal",	spec = {256}	},
		{ spellID = 121135,	duration = 25,	type = "heal",	spec = true	},
		{ spellID = 110744,	duration = 15,	type = "heal",	spec = true	},
		{ spellID = 120517,	duration = 40,	type = "heal",	spec = true	},
		{ spellID = 123040,	duration = 60,	type = "offensive",	spec = true 	},
		{ spellID = 10060,	duration = 120,	type = "offensive",	spec = true	},
		{ spellID = 34433,	duration = 180,	type = "offensive",	talent = 123040	},
		{ spellID = 6346,	duration = 180,	type = "counterCC",	},
		{ spellID = 89485,	duration = 45,	type = "counterCC",	spec = {256}	},
		{ spellID = 32379,	duration = 8,	type = "counterCC",	spec = {256,257}	},
		{ spellID = 129176,	duration = 8,	type = "counterCC",	spec = {258}	},
		{ spellID = 121536,	duration = 10,	type = "movement",	spec = true,	charges = 3	},
		{ spellID = 73325,	duration = 90,	type = "movement",	},
		{ spellID = 586,	duration = 30,	type = "other",	},
		{ spellID = 64901,	duration = 360,	type = "other",	},
		{ spellID = 112833,	duration = 30,	type = "other",	spec = true	},

		{ spellID = 113506,	duration = 0,	type = "cc",	spec = true	},
		{ spellID = 113277,	duration = 480,	type = "raidDefensive",	spec = true	},
	},
	["ROGUE"] = {
		{ spellID = 1766,	duration = 15,	type = "interrupt",	},
		{ spellID = 2094,	duration = 120,	type = "cc",	},
		{ spellID = 1776,	duration = 10,	type = "cc",	},
		{ spellID = 408,	duration = 20,	type = "cc",	},
		{ spellID = 76577,	duration = 180,	type = "cc",	},
		{ spellID = 51722,	duration = 60,	type = "disarm",	},
		{ spellID = 31230,	duration = 90,	type = "defensive",	spec = true	},
		{ spellID = 31224,	duration = 60,	type = "defensive",	},
		{ spellID = 74001,	duration = 120,	type = "defensive",	spec = true	},
		{ spellID = 5277,	duration = 120,	type = "defensive",	},
		{ spellID = 14185,	duration = 300,	type = "defensive",	},
		{ spellID = 1856,	duration = 120,	type = "defensive",	},
		{ spellID = 13750,	duration = 180,	type = "offensive",	spec = {260}	},
		{ spellID = 51690,	duration = 120,	type = "offensive",	spec = {260}	},
		{ spellID = 121471,	duration = 180,	type = "offensive",	},
		{ spellID = 51713,	duration = 60,	type = "offensive",	spec = {261}	},
		{ spellID = 79140,	duration = 120,	type = "offensive",	spec = {259}	},
		{ spellID = 36554,	duration = 20,	type = "movement",	spec = true	},
		{ spellID = 2983,	duration = 60,	type = "movement",	},
		{ spellID = 1725,	duration = 30,	type = "other",	},
		{ spellID = 137619,	duration = 60,	type = "other",	spec = true	},
		{ spellID = 14183,	duration = 20,	type = "other",	spec = {261}	},
		{ spellID = 73981,	duration = 60,	type = "other",	},
		{ spellID = 114842,	duration = 60,	type = "other",	},
		{ spellID = 114018,	duration = 300,	type = "other",	},
		{ spellID = 1784,	duration = 6,	type = "other",		},
		{ spellID = 57934,	duration = 30,	type = "other",	},

		{ spellID = 113613,	duration = 180,	type = "defensive",	spec = true	},
	},
	["SHAMAN"] = {
		{ spellID = 57994,	duration = 12,	type = "interrupt",	},
		{ spellID = 51886,	duration = 8,	type = "dispel",	spec = {262,263}	},
		{ spellID = 77130,	duration = 8,	type = "dispel",	spec = {264}	},
		{ spellID = 51514,	duration = 45,	type = "cc",	},
		{ spellID = 108269,	duration = 45,	type = "aoeCC",	},
		{ spellID = 51490,	duration = 45,	type = "aoeCC",	spec = {262}	},
		{ spellID = 51485,	duration = 30,	type = "disarm",	spec = true	},
		{ spellID = 108271,	duration = 90,	type = "defensive",	spec = true	},
		{ spellID = 108285,	duration = 180,	type = "defensive",	spec = true	},
		{ spellID = 2062,	duration = 300,	type = "defensive",	},
		{ spellID = 30884,	duration = 30,	type = "defensive",	spec = 30884	},
		{ spellID = 30823,	duration = 60,	type = "defensive",	spec = {262,263}	},
		{ spellID = 108270,	duration = 60,	type = "defensive",	spec = true	},
		{ spellID = 108281,	duration = 120,	type = "raidDefensive",	spec = true	},
		{ spellID = 108280,	duration = 180,	type = "raidDefensive",	},
		{ spellID = 98008,	duration = 180,	type = "raidDefensive",	spec = {264}	},
		{ spellID = 5394,	duration = 30,	type = "heal",	},
		{ spellID = 114049,	duration = 180,	type = "offensive",	},
		{ spellID = 2825,	duration = 300,	type = "offensive",	},

		{ spellID = 16166,	duration = 90,	type = "offensive",	spec = true	},
		{ spellID = 51533,	duration = 120,	type = "offensive",	spec = true	},
		{ spellID = 2894,	duration = 300,	type = "offensive",	},
		{ spellID = 120668,	duration = 300,	type = "offensive",	},
		{ spellID = 8177,	duration = 25,	type = "counterCC",	},
		{ spellID = 8143,	duration = 60,	type = "counterCC",	},
		{ spellID = 58875,	duration = 60,	type = "freedom",	spec = {263}	},
		{ spellID = 108273,	duration = 60,	type = "raidMovement",	spec = true	},
		{ spellID = 16188,	duration = 90,	type = "other",	spec = true	},
		{ spellID = 2484,	duration = 30,	type = "other",	talent = 51485	},
		{ spellID = 16190,	duration = 180,	type = "other",	spec = {264}	},
		{ spellID = 20608,	duration = 1800,	type = "other",	},
		{ spellID = 79206,	duration = 120,	type = "other",	},

		{ spellID = 73680,	duration = 15,	type = "other",	},

		{ spellID = 113286,	duration = 60,	type = "interrupt",	spec = true	},
		{ spellID = 113289,	duration = 8,	type = "other",	spec = true	},
	},
	["WARLOCK"] = {
		{ spellID = 108482,	duration = 60,	type = "pvptrinket",	spec = true	},


		{ spellID = 108501,	duration = 120,	type = "interrupt",	spec = true	},
		{ spellID = 19647,	duration = 24,	type = "interrupt",	},
		{ spellID = 19505,	duration = 15,	type = "dispel",	},
		{ spellID = 6789,	duration = 45,	type = "cc",	spec = true	},
		{ spellID = 5484,	duration = 40,	type = "aoeCC",	},
		{ spellID = 30283,	duration = 30,	type = "aoeCC",	spec = true	},
		{ spellID = 111397,	duration = 30,	type = "defensive",	spec = true	},
		{ spellID = 110913,	duration = 180,	type = "defensive",	spec = true	},
		{ spellID = 108416,	duration = 60,	type = "defensive",	spec = true	},
		{ spellID = 6229,	duration = 30,	type = "defensive",	},
		{ spellID = 104773,	duration = 180,	type = "defensive",	talent = 148683	},
		{ spellID = 148683,	duration = 180,	type = "defensive",	spec = 148683,
			disabledSpec={
				[265]={arena=false,pvp=false,party=true,raid=true,scenario=true,none=true},
				[266]={arena=false,pvp=false,party=true,raid=true,scenario=true,none=true},
				[267]={arena=false,pvp=false,party=true,raid=true,scenario=true,none=true},
			},
		},
		{ spellID = 108359,	duration = 120,	type = "heal",	spec = true	},
		{ spellID = 113858,	duration = 120,	type = "offensive",	spec = {267}	},
		{ spellID = 113861,	duration = 120,	type = "offensive",	spec = {266}	},
		{ spellID = 113860,	duration = 120,	type = "offensive",	spec = {265}	},
		{ spellID = 105174,	duration = 15,	type = "offensive",	spec = {266},	charges = 2	},
		{ spellID = 104316,	duration = 120,	type = "offensive",	spec = 56242	},
		{ spellID = 108508,	duration = 60,	type = "offensive",	spec = true	},
		{ spellID = 18540,	duration = 600,	type = "offensive",	},
		{ spellID = 1122,	duration = 600,	type = "offensive",	},
		{ spellID = 48020,	duration = 30,	type = "movement",	},
		{ spellID = 47897,	duration = 20,	type = "other",	spec = true	},
		{ spellID = 109151,	duration = 10,	type = "other",	spec = {266}	},
		{ spellID = 120451,	duration = 60,	type = "other",	spec = {267}	},
		{ spellID = 108503,	duration = 30,	type = "other",	spec = true	},
		{ spellID = 80240,	duration = 25,	type = "other",	spec = {267}	},
		{ spellID = 29858,	duration = 120,	type = "other",	},
		{ spellID = 20707,	duration = 600,	type = "other",	buff = 0	},

		{ spellID = 113295,	duration = 10,	type = "heal",	spec = true	},
	},
	["WARRIOR"] = {
		{ spellID = 102060,	duration = 40,	type = "interrupt",	spec = true	},
		{ spellID = 6552,	duration = 15,	type = "interrupt",	},
		{ spellID = 5246,	duration = 90,	type = "cc",	},
		{ spellID = 46968,	duration = 40,	type = "cc",	spec = true	},
		{ spellID = 107570,	duration = 30,	type = "cc",	spec = true	},
		{ spellID = 118000,	duration = 60,	type = "aoeCC",	spec = true	},
		{ spellID = 676,	duration = 60,	type = "disarm",	},
		{ spellID = 57755,	duration = 30,	type = "disarm",	spec = 58357,
			disabledSpec={
				[71]={arena=true,pvp=true,party=false,raid=false,scenario=false,none=false},
				[72]={arena=true,pvp=true,party=false,raid=false,scenario=false,none=false},
				[73]={arena=true,pvp=true,party=false,raid=false,scenario=false,none=false},
			},
		},
		{ spellID = 107566,	duration = 40,	type = "disarm",	spec = true	},
		{ spellID = 114203,	duration = 180,	type = "defensive",	},
		{ spellID = 118038,	duration = 120,	type = "defensive",	spec = {71,72}	},
		{ spellID = 12975,	duration = 180,	type = "defensive",	spec = {73}	},
		{ spellID = 2565,	duration = 9,	type = "defensive",	spec = {73},	charges = 2	},
		{ spellID = 871,	duration = 180,	type = "defensive",	},
		{ spellID = 114030,	duration = 120,	type = "externalDefensive",	spec = true	},
		{ spellID = 97462,	duration = 180,	type = "raidDefensive",	buff = 97463	},
		{ spellID = 55694,	duration = 60,	type = "heal",	spec = true	},
		{ spellID = 103840,	duration = 30,	type = "heal",	spec = true	},
		{ spellID = 107574,	duration = 180,	type = "offensive",	spec = true	},
		{ spellID = 46924,	duration = 60,	type = "offensive",	spec = true	},
		{ spellID = 12292,	duration = 60,	type = "offensive",	spec = true	},
		{ spellID = 86346,	duration = 20,	type = "offensive",	spec = {71,72}	},
		{ spellID = 1719,	duration = 180,	type = "offensive",	},
		{ spellID = 114207,	duration = 180,	type = "offensive",	buff = 114206	},

		{ spellID = 18499,	duration = 30,	type = "counterCC",	},
		{ spellID = 3411,	duration = 30,	type = "counterCC",	talent = 114029	},
		{ spellID = 114028,	duration = 60,	type = "counterCC",	spec = true	},
		{ spellID = 114029,	duration = 30,	type = "counterCC",	spec = true	},
		{ spellID = 23920,	duration = 25,	type = "counterCC",	},
		{ spellID = 1250619,	duration = 20,	type = "movement",	},
		{ spellID = 6544,	duration = 45,	type = "movement",	},
		{ spellID = 114192,	duration = 180,	type = "other",	},
		{ spellID = 64382,	duration = 300,	type = "other",	},
		{ spellID = 355,	duration = 8,	type = "taunt",		},

		{ spellID = 122294,	duration = 300,	type = "raidMovement",	spec = true	},
		{ spellID = 122286,	duration = 60,	type = "defensive",	spec = true	},
	},
	["PVPTRINKET"] = {
		{ spellID = 42292,	duration = 120,	type = "pvptrinket",	item = 37864	},
		{ spellID = 126697,	duration = 120,	type = "trinket",	item = 64740,	icon = 132344	},
		{ spellID = 126690,	duration = 60,	type = "trinket",	item = 64687,	icon = 135884	},
	},
	["RACIAL"] = {
		{ spellID = 28730,	duration = 120,	type = "racial",	race = 10	},
		{ spellID = 26297,	duration = 180,	type = "racial",	race = 8	},
		{ spellID = 20572,	duration = 120,	type = "racial",	race = 2	},
		{ spellID = 68992,	duration = 120,	type = "racial",	race = 22	},
		{ spellID = 20589,	duration = 90,	type = "racial",	race = 7	},
		{ spellID = 28880,	duration = 180,	type = "racial",	race = 11	},
		{ spellID = 69070,	duration = 120,	type = "racial",	race = 9	},
		{ spellID = 107079,	duration = 120,	type = "racial",	race = {25,26}	},
		{ spellID = 58984,	duration = 120,	type = "racial",	race = 4	},
		{ spellID = 20594,	duration = 120,	type = "racial",	race = 3	},
		{ spellID = 20549,	duration = 120,	type = "racial",	race = 6	},
		{ spellID = 7744,	duration = 120,	type = "racial",	race = 5	},
		{ spellID = 59752,	duration = 120,	type = "racial",	race = 1	},
	},
	["TRINKET"] = {
		{ spellID = 113942,	duration = 60,	type = "consumable",	item = 0,	icon = 607512	},
		{ spellID = 6262,	duration = 120,	type = "consumable",	item = 5512	},
		{ spellID = 105708,	duration = 60,	type = "consumable",	item = nil,	icon = 609894	},
		{ spellID = 105709,	duration = 60,	type = "consumable",	item = nil,	icon = 650641	},
		{ spellID = 105701,	duration = 60,	type = "consumable",	item = nil,	icon = 609893	},
		{ spellID = 105702,	duration = 60,	type = "consumable",	item = nil,	icon = 609895	},
		{ spellID = 105706,	duration = 60,	type = "consumable",	item = nil,	icon = 609896	},
		{ spellID = 105697,	duration = 60,	type = "consumable",	item = nil,	icon = 609897	},
		{ spellID = 11392,	duration = 600,	type = "consumable",	item = nil,	icon = 650637	},

	},
}

E.buffFix = E.BLANK

E.buffFixNoCLEU = {
	[125174]	= 10,
}

E.summonedBuffDuration = E.BLANK

E.spellDefaults = {
	42292,
	59752,
	20589,
	58984,
	20594,
	20549,
	7744,

	47528,
	108194,
	108200,
	47476,
	49576,
	108199,
	48707,
	48792,
	114556,
	51052,
	48743,
	42650,
	49028,
	47568,
	49206,
	49016,
	51271,
	108201,
	49039,
		113072,


	80964,
	78675,
	88423,
	2782,
	99,
	5211,
	132469,
	102342,
	22812,
	106922,
	108238,
	61336,
	124974,
	740,
	50334,
	106951,
	112071,
	102558,
	132158,
	29166,
		110570,
		110575,
		110617,
		110696,
		126458,
		126449,
		126456,
		110698,
		110700,
		122288,
		110707,
		110715,
		110718,
		110788,
		110791,
		122291,
		112970,
		113004,

	147362,
	34490,
	109248,
	1499,
	19577,
	19503,
	19386,
	19263,
	53480,
	51753,
	109304,
	19574,
	131894,
	121818,
	3045,
	53271,


	2139,
	475,
	44572,
	31661,
	113724,
	45438,
	108978,
	11958,
	86949,
	110959,
	115610,
	12042,
	11129,
	12472,
	55342,
	12043,

	137562,
	116705,
	115450,
	119381,
	116844,
	115078,
	117368,
	115213,
	116849,
	122278,
	122783,
	115203,
	122470,
	115176,
	115310,
	123995,
	119996,
	116841,
		113306,
		127361,
	96231,
	4987,
	115750,
	853,
	105593,
	20066,
	642,
	1022,
	114039,
	6940,
	633,
	31850,
	498,
	86659,
	31821,
	86669,
	31884,
	31842,
	114157,
	86698,
	1044,

		113075,

	527,
	32375,
	88625,
	64044,
	8122,
	108921,
	15487,
	47788,
	33206,
	19236,
	47585,
	108968,
	142723,
	64843,
	126135,
	62618,
	15286,
	10060,
	34433,
	6346,
	89485,
	32379,
	129176,
	64901,
	73325,
		113277,

	1766,
	2094,
	408,
	76577,
	51722,
	31230,
	31224,
	74001,
	5277,
	14185,
	1856,
	13750,
	51690,
	121471,
	51713,
	79140,

	57994,
	77130,
	51886,
	108269,
	51514,
	51490,
	108271,
	108285,
	2062,
	30884,
	30823,
	108270,
	108281,
	108280,
	98008,
	114049,
	16166,
	51533,
	2894,
	120668,
	8177,
	8143,
	16190,
	16188,
	58875,
		113286,

	108482,
	19647,
	108501,
	19505,
	6789,
	5484,
	30283,
	110913,
	108359,
	108416,
	104773,
	113860,
	113861,
	113858,
	18540,
	1122,
	48020,

	6552,
	102060,
	5246,
	46968,
	107570,
	676,
	118000,
	57755,
	114030,
	114203,
	118038,
	55694,
	12975,
	871,
	97462,
	107574,
	86346,
	1719,
	114207,
	18499,
	3411,
	114029,
	114028,
	23920,
	64382,

		122286,
}
