-- Pseudo Data Provider and Event Trigger


local _, addon = ...
local RemixAPI = addon.RemixAPI
if not RemixAPI then return end;

local type = type;

local DataProvider = RemixAPI.DataProvider;
local CommitUtil = RemixAPI.CommitUtil;


local TraitNodeXEntryDB = {
    --nodeID = entryID or {entryID1, entryID2}
    [108102] = 133485,
    [108103] = {133486, 133508},
    [108104] = {133487, 135715},
    [108105] = 133488,
    [108106] = 133489,
    [108107] = 133490,
    [108108] = 133491,
    [108110] = 133493,
    [108111] = 133494,
    [108112] = 133495,
    [108113] = 133496,
    [108114] = 133497,
    [108115] = 133498,
    [108118] = 133504,
    [108119] = 133505,
    [108120] = 133506,
    [108121] = 133507,
    [108132] = 133525,
    [108165] = 133564,
    [108166] = 133565,
    [108169] = 133568,
    [108172] = 133571,
    [108180] = 133581,
    [108181] = 133582,
    [108182] = 133583,
    [108213] = 133644,
    [108214] = 133645,
    [108215] = 133646,
    [108216] = 133647,
    [108217] = 133648,
    [108218] = 133649,
    [108219] = 133650,
    [108220] = 133651,
    [108221] = 133652,
    [108222] = 133653,
    [108223] = 133654,
    [108224] = 133655,
    [108225] = 133656,
    [108226] = 133657,
    [108227] = 133658,
    [108228] = 133659,
    [108229] = 133660,
    [108230] = 133661,
    [108231] = 133662,
    [108232] = 133663,
    [108233] = 133664,
    [108234] = 133665,
    [108235] = 133666,
    [108236] = 133667,
    [108237] = 133668,
    [108238] = 133669,
    [108239] = 133670,
    [108240] = 133671,
    [108241] = 133672,
    [108242] = 133673,
    [108243] = 133674,
    [108244] = 133675,
    [108245] = 133676,
    [108246] = 133677,
    [108247] = 133678,
    [108248] = 133679,
    [108249] = 133680,
    [108250] = 133681,
    [108251] = 133682,
    [108252] = 133683,
    [108253] = 133684,
    [108254] = 133685,
    [108255] = 133686,
    [108256] = 133687,
    [108257] = 133688,
    [108258] = 133689,
    [108259] = 133690,
    [108260] = 133691,
    [108523] = 133999,
    [108694] = 134237,
    [108695] = 134238,
    [108699] = 134245,
    [108700] = 134246,
    [108701] = 134247,
    [108702] = 134248,
    [108868] = 134442,
    [108869] = 134443,
    [108870] = 134444,
    [108873] = 134447,
    [108874] = 134448,
    [108875] = 134449,
    [108878] = 134454,
    [108975] = 134745,
    [109259] = 135320,
    [109260] = 135321,
    [109261] = 135322,
    [109262] = 135323,
    [109263] = 135324,
    [109264] = 135325,
    [109265] = 135326,
    [109266] = 135327,
    [109267] = 135328,
    [109268] = 135329,
    [109269] = 135330,
    [109270] = 135331,
    [109271] = 135332,
    [109272] = 135333,
    [109273] = 135334,
    [109274] = 135335,
};

local TraitNodeEntryDB = {
    --[entryID] = {definitionID, maxRanks, entryType}
    [133485] = {138271, 3, 2},
    [133486] = {138272, 1, 2},
    [133487] = {138273, 3, 2},
    [133488] = {138274, 3, 2},
    [133489] = {138275, 3, 2},
    [133490] = {138276, 3, 2},
    [133491] = {138277, 3, 2},
    [133493] = {138279, 3, 2},
    [133494] = {138280, 1, 1},
    [133495] = {138281, 1, 1},
    [133496] = {138282, 1, 1},
    [133497] = {138283, 1, 1},
    [133498] = {138284, 1, 2},
    [133504] = {138290, 1, 2},
    [133505] = {138291, 1, 2},
    [133506] = {138292, 1, 2},
    [133507] = {138293, 1, 2},
    [133508] = {138294, 1, 2},
    [133525] = {138311, 3, 2},
    [133564] = {138350, 1, 3},
    [133565] = {138351, 1, 3},
    [133568] = {138354, 1, 3},
    [133571] = {138357, 1, 3},
    [133581] = {138367, 1, 2},
    [133582] = {138368, 1, 3},
    [133583] = {138369, 1, 3},
    [133644] = {138430, 1, 3},
    [133645] = {138431, 1, 3},
    [133646] = {138432, 1, 3},
    [133647] = {138433, 1, 3},
    [133648] = {138434, 1, 3},
    [133649] = {138435, 1, 3},
    [133650] = {138436, 1, 3},
    [133651] = {138437, 1, 3},
    [133652] = {138438, 1, 3},
    [133653] = {138439, 1, 3},
    [133654] = {138440, 1, 3},
    [133655] = {138441, 1, 3},
    [133656] = {138442, 1, 3},
    [133657] = {138443, 1, 3},
    [133658] = {138444, 1, 3},
    [133659] = {138445, 1, 3},
    [133660] = {138446, 1, 3},
    [133661] = {138447, 1, 3},
    [133662] = {138448, 1, 3},
    [133663] = {138449, 1, 3},
    [133664] = {138450, 1, 3},
    [133665] = {138451, 1, 3},
    [133666] = {138452, 1, 3},
    [133667] = {138453, 1, 3},
    [133668] = {138454, 1, 3},
    [133669] = {138455, 1, 3},
    [133670] = {138456, 1, 3},
    [133671] = {138457, 1, 3},
    [133672] = {138458, 1, 3},
    [133673] = {138459, 1, 3},
    [133674] = {138460, 1, 3},
    [133675] = {138461, 1, 3},
    [133676] = {138462, 1, 3},
    [133677] = {138463, 1, 3},
    [133678] = {138464, 1, 3},
    [133679] = {138465, 1, 3},
    [133680] = {138466, 1, 3},
    [133681] = {138467, 1, 3},
    [133682] = {138468, 1, 3},
    [133683] = {138469, 1, 3},
    [133684] = {138470, 1, 3},
    [133685] = {138471, 1, 3},
    [133686] = {138472, 1, 3},
    [133687] = {138473, 1, 3},
    [133688] = {138474, 1, 3},
    [133689] = {138475, 1, 3},
    [133690] = {138476, 1, 3},
    [133691] = {138477, 1, 3},
    [133999] = {138785, 1, 2},
    [134237] = {139013, 1, 3},
    [134238] = {139014, 1, 3},
    [134245] = {139021, 1, 2},
    [134246] = {139022, 999, 10},
    [134247] = {139023, 1, 2},
    [134248] = {139024, 3, 2},
    [134442] = {139213, 1, 3},
    [134443] = {139214, 1, 3},
    [134444] = {139215, 1, 2},
    [134447] = {139218, 1, 2},
    [134448] = {139219, 1, 3},
    [134449] = {139220, 1, 1},
    [134454] = {139225, 1, 3},
    [134745] = {139513, 1, 2},
    [135320] = {140087, 1, 3},
    [135321] = {140088, 1, 2},
    [135322] = {140089, 1, 3},
    [135323] = {140090, 1, 2},
    [135324] = {140091, 1, 3},
    [135325] = {140092, 1, 3},
    [135326] = {140093, 3, 2},
    [135327] = {140094, 1, 3},
    [135328] = {140095, 1, 3},
    [135329] = {140096, 1, 3},
    [135330] = {140097, 1, 3},
    [135331] = {140098, 1, 3},
    [135332] = {140099, 1, 3},
    [135333] = {140100, 1, 2},
    [135334] = {140101, 1, 3},
    [135335] = {140102, 1, 3},
    [135715] = {140470, 3, 2},
};

local NextNodeDB = {
    --[leftNodeID] = rightNodeID,
    [109264] = 109272,
    [109268] = 109264,
    [109269] = 109268,
    [109262] = 109269,
    [109261] = 109262,
    [109273] = 109261,
    [109263] = 109273,
    [109260] = 109263,
    [109270] = 109260,
    [109259] = 109270,
    [109271] = 109259,
    [109265] = 109271,
    [109274] = 109266,
    [109266] = 109265,
    [108226] = 108699,
    [108228] = 108226,
    [108225] = 108228,
    [108119] = 108225,
    [108227] = 108119,
    [108230] = 108227,
    [108229] = 108230,
    [108104] = 108229,
    [108695] = 108104,
    [108254] = 108695,
    [108250] = 108254,
    [108108] = 108250,
    [108253] = 108108,
    [108252] = 108253,
    [108249] = 108252,
    [108112] = 108249,
    [108222] = 108118,
    [108220] = 108222,
    [108224] = 108220,
    [108107] = 108224,
    [108223] = 108107,
    [108221] = 108223,
    [108219] = 108221,
    [108103] = 108219,
    [108246] = 108103,
    [108247] = 108246,
    [108245] = 108247,
    [108102] = 108245,
    [108243] = 108102,
    [108248] = 108243,
    [108244] = 108248,
    [108111] = 108244,
    [108694] = 108975,
    [108231] = 108694,
    [108236] = 108231,
    [108132] = 108236,
    [108232] = 108132,
    [108234] = 108232,
    [108233] = 108234,
    [108105] = 108233,
    [108235] = 108105,
    [108257] = 108235,
    [108255] = 108257,
    [108702] = 108255,
    [108258] = 108702,
    [108256] = 108258,
    [108259] = 108256,
    [108113] = 108259,
    [108217] = 108121,
    [108218] = 108217,
    [108213] = 108218,
    [108120] = 108213,
    [108216] = 108120,
    [108214] = 108216,
    [108215] = 108214,
    [108110] = 108215,
    [108240] = 108110,
    [108238] = 108240,
    [108239] = 108238,
    [108106] = 108239,
    [108241] = 108106,
    [108237] = 108241,
    [108242] = 108237,
    [108114] = 108242,
    [108869] = 108114,
    [108251] = 108111,
    [108870] = 108251,
    [108169] = 108112,
    [108868] = 108169,
    [108874] = 108869,
    [108701] = 108869,
    [108172] = 108523,
    [108166] = 108873,
    [108873] = 108868,
    [108260] = 108166,
    [108180] = 108165,
    [108523] = 108874,
    [108165] = 108172,
    [108878] = 108180,
    [108181] = 108878,
    [108182] = 108181,
    [108115] = 108182,
    [109267] = 109274,
    [108875] = 109267,
};

local TrackNodes = {
    {
        108114,
        108242,
        108237,
        108241,
        108106,
        108239,
        108238,
        108240,
        108110,
        108215,
        108214,
        108216,
        108120,
        108213,
        108218,
        108217,
        108121,
    },
    {
        108113,
        108259,
        108256,
        108258,
        108702,
        108255,
        108257,
        108235,
        108105,
        108233,
        108234,
        108232,
        108132,
        108236,
        108231,
        108694,
        108975,
    },
    {
        108111,
        108244,
        108248,
        108243,
        108102,
        108245,
        108247,
        108246,
        108103,
        108219,
        108221,
        108223,
        108107,
        108224,
        108220,
        108222,
        108118,
    },
    {
        108112,
        108249,
        108252,
        108253,
        108108,
        108250,
        108254,
        108695,
        108104,
        108229,
        108230,
        108227,
        108119,
        108225,
        108228,
        108226,
        108699,
    },
    {
        108875,
        109267,
        109274,
        109266,
        109265,
        109271,
        109259,
        109270,
        109260,
        109263,
        109273,
        109261,
        109262,
        109269,
        109268,
        109264,
        109272,
    },
};

local ItemXEntry = {
    --[itemID] = entryID
    [246195] = 135715,  --Brewing
    [246191] = 133493,  --Highmountain
    [246196] = 135326,  --Lights
    [246192] = 133489,  --Caw
    [246194] = 133487,  --Surger
    [246193] = 133490,  --Temp Ret
    [246190] = 134248,  --Malice
    [245996] = 133485,  --Volatile

    [245998] = 133486,  --Aegis
    [246197] = 133508,  --Ward
    [246202] = 135715,
    [246200] = 133493,
    [246198] = 133488,  --Scars
    [246201] = 133490,
    [245997] = 133491,  --Terror
    [246199] = 133485,

    [246204] = 133486,
    [246206] = 133508,
    [246208] = 133488,
    [246207] = 135326,
    [246203] = 133489,
    [246205] = 133487,
    [246000] = 133491,
    [245999] = 134248,

    --Test
    --[230633] = 133486,
    --[242397] = 133488,
};

local ItemXIcon = {
    --[itemID] = icon
    [246200] = 1322283,
    [246204] = 4638528,
    [246208] = 236415,
    [245999] = 1380367,
    [246193] = 610472,
    [246197] = 4638530,
    [246201] = 610472,
    [246205] = 136099,
    [245996] = 4226154,
    [246000] = 463487,
    [246190] = 1380367,
    [246194] = 136099,
    [246198] = 236415,
    [246202] = 136014,
    [246206] = 4638530,
    [245997] = 463487,
    [246191] = 1322283,
    [246195] = 136014,
    [246199] = 4226154,
    [246203] = 136126,
    [246207] = 5764906,
    [245998] = 4638528,
    [246192] = 136126,
    [246196] = 5764906,

    --Test
    [230633] = 4638528,
    [242397] = 236415,
};

--[[
do  --For debug on Retail
    local debugNodeID = 93179;
    local debugEntryID = 115462;
    NextNodeDB[debugNodeID] = debugNodeID;
    TraitNodeXEntryDB[debugNodeID] = debugEntryID;
    TraitNodeEntryDB[debugEntryID] = {120474, 3, 2};

    local tbl = {};
    for i = 1, #TrackNodes do
        tbl[i] = {};
        for j = 1, #TrackNodes[i] do
            tbl[i][j] = debugNodeID;
        end
    end
    TrackNodes = tbl;

    local tbl = {};
    for i = 1, #DataProvider.ArtifactTracks do
        tbl[i] = {};
        for j = 1, #DataProvider.ArtifactTracks[i] do
            tbl[i][j] = debugNodeID;
        end
    end
    DataProvider.ArtifactTracks = tbl;
end
--]]

function DataProvider:GetNodeEntryID(nodeID)
    return TraitNodeXEntryDB[nodeID]
end


function DataProvider:LocalGetNodeInfo(nodeID)
    local v = TraitNodeXEntryDB[nodeID];
    local info = {};
    info.ID = nodeID;
    if type(v) == "number" then
        info.type = 0;  --Enum.TraitNodeType.Single
        info.entryID = v;
    else
        info.type = 2;  --Enum.TraitNodeType.Selection
        info.entryIDs = v;
    end
    return info
end

--[[
function DataProvider:GetEntryInfo(entryID)
    local v = TraitNodeEntryDB[entryID]
    return {
        definitionID = v[1],
        maxRanks = v[2],
        type = v[3],
    };
end
--]]

function DataProvider:GetRightNodeInfo(leftNodeID)
    local nodeID = NextNodeDB[leftNodeID]
    if nodeID then
        return self:LocalGetNodeInfo(nodeID)
    end
end

--[[
function DataProvider:IsNodeActive(nodeID)
    if not self.activeNodeIDs then
        self.activeNodeIDs = {};
        local threshold = 20;
        for trackIndex, nodeIDs in ipairs(TrackNodes) do
            for i, _nodeID in ipairs(nodeIDs) do
                if i <= threshold then
                    self.activeNodeIDs[_nodeID] = true;
                end
            end
        end
    end
    return self.activeNodeIDs[nodeID]
end
--]]

function DataProvider:GetItemTraitEntry(itemID)
    return ItemXEntry[itemID]
end

--[[
function DataProvider:GetItemTraitTexture(itemID)
    local entryID = ItemXEntry[itemID];
    if not entryID then return end;

    if not self.itemTraitTextures then
        self.itemTraitTextures = {};
    end

    if not self.itemTraitTextures[itemID] then
        local definitionID = TraitNodeEntryDB[entryID][1];
        local spellID = C_Traits.GetDefinitionInfo(definitionID).spellID;
        local iconID, originalIconID = C_Spell.GetSpellTexture(spellID);
        self.itemTraitTextures[itemID] = originalIconID or iconID;
    end

    return self.itemTraitTextures[itemID]
end
--]]

function DataProvider:GetItemTraitTexture(itemID)
    return ItemXIcon[itemID]
end

function DataProvider:GetArtifactTrackNodeIDs(artifactTrackIndex)
    return TrackNodes[artifactTrackIndex]
end

function DataProvider:GetNodeArtifactTrack(nodeID)
    if not self.NodeIDXTrack then
        self.NodeIDXTrack = {};
        for artifactTrackIndex, nodes in ipairs(TrackNodes) do
            for _, _nodeID in ipairs(nodes) do
                self.NodeIDXTrack[_nodeID] = artifactTrackIndex;
            end
        end
    end
    return self.NodeIDXTrack[nodeID]
end


--[[
function CommitUtil:TryPurchaseArtifactTrack(index)
    local function OnUpdate(self, elapsed)
        self.t = self.t + elapsed;
        if self.t > 1 then
            self.t = nil;
            self:SetScript("OnUpdate", nil);
            DataProvider.artifactTrackIndex = index;
            local success = true;
            addon.CallbackRegistry:Trigger("LegionRemix.CommitFinished", success);
        end
    end
    self.t = 0;
    self:SetScript("OnUpdate", OnUpdate);
end

function CommitUtil:IsCommitingInProcess()
    return self.t ~= nil
end
--]]


--[[
function YeetItemTraitIcons()
    if not PlumberDevData.ItemTraitIcons then
        PlumberDevData.ItemTraitIcons = {};
    end

    for itemID, entryID in pairs(ItemXEntry) do
        local definitionID = TraitNodeEntryDB[entryID][1];
        local spellID = C_Traits.GetDefinitionInfo(definitionID).spellID;
        local iconID, originalIconID = C_Spell.GetSpellTexture(spellID);
        PlumberDevData.ItemTraitIcons[itemID] = originalIconID or iconID;
    end
end
--]]