
--[=[
for this example, let's consider the name of your addon is "Slice And Dance"
addon folder name on World of Warcraft/_retail_/Interface/AddOns/SliceAndDance/
toc file example /World of Warcraft/_retail_/Interface/AddOns/SliceAndDance/SliceAndDance.toc:
    ## Interface: 100107
    ## Title: "Slice And Dance"
    ## Notes: Show a slice and dice bar for rogues
    ## SavedVariables: SliceAndDanceDatabase
    SliceAndDance_Core.lua
--]=]

--create a new file on your addon folder called "SliceAndDance_Core.lua"
--this are the contents to add to the file

--each file of your addon receives a payload with the addon name and a private table
--this private table is shared between all files of your addon and cannot be accessed by other addons or scripts
--the addon name is the ToC name of your addon, the toc is also the folder name of your addon in the addons folder
local addonName, priviteTable = ...

--saved variables name
--this is the name of the global table where your addon will store it's saved variables
--you define this on the addon.toc file under the line "## SavedVariables: SliceAndDanceDatabase"
local savedVariablesName = "SliceAndDanceDatabase"

--default settings
--a simple table with default settings for your addon, any value modified by the user will be stored in the saved variables table
--if your addon doesn't have any settings, you can just pass an empty table
local defaultSettingsExample = {
    width = 500,
    height = 500,
    name = "John",
}

local detailsFramework = DetailsFramework
--create the core addon object, this is a table which will all public functions of your addon
local myNewAddonObject = detailsFramework:CreateNewAddOn(addonName, savedVariablesName, defaultSettingsExample)

--by default, the table generated by the CreateNewAddOn() isn't placed in the global environment
--if this is desired for some reason, you can do it manually
_G.MyNewAddon = myNewAddonObject

--this function is called when the savedVariables of your addon is ready to be used
function myNewAddonObject.OnLoad(self, profile)
    --self is: myNewAddonObject
    --profile is a table with defaultSettingsExample
end

--this function is called when when the loading screen is done and the player character is ready to play
function myNewAddonObject.OnInit(self, profile) --fired from detailsFramework at PLAYER_LOGIN
    --self is: myNewAddonObject
    --profile is a table with defaultSettingsExample
end