﻿----------------------------------------------------------------------
-- 	Leatrix Maps Locale
----------------------------------------------------------------------

-- Create locale structure
local GameLocale = GetLocale()
local void, Leatrix_Maps = ...
local function localeFunc(L, key) return key end
local L = setmetatable({}, {__index = localeFunc})
Leatrix_Maps.L = L

if LeatrixGlobalDisableLocalisation then return end

-- Locale override (enUS, zhCN, zhTW, ruRU, koKR, deDE, esMX, frFR, itIT, ptBR)
-- GameLocale = "enUS"

-- zhCN: Simplified Chinese (People's Republic of China)
if GameLocale == "zhCN" then
L["(destination only)"] = "(仅目的地)"
L["(inside Caverns of Time)"] = "(时光之穴内部)"
L["/ltm help - Show this information."] = "/ltm help - 显示帮助信息"
L["/ltm reset - Reset the panel position."] = "/ltm reset - 重置面板位置"
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - 清空所有设置并重载插件"
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "出现了一个无关痛痒的报错，它并不会影响到你的体验，你可以点击重载按钮来解决这个问题。"
L["A stop error has occurred but no need to worry. It can happen from time to time. Click the reload button to resolve it."] = "发生了停止错误，但无需担心。它可能不时发生。点击重载按钮来解决它。"
L["Acherus: The Ebon Hold"] = "阿彻鲁斯：黑锋要塞"
L["Aerie Peak"] = "鹰巢山"
L["Agmar's Hammer"] = "阿格玛之锤"
L["Ahn'Qiraj"] = "安其拉"
L["Aldor"] = "奥尔多"
L["Allerian Stronghold"] = "奥蕾莉亚要塞"
L["Alliance Cities"] = "联盟城市"
L["Alpha"] = "透明"
L["Altar of Sha'tar"] = "沙塔尔祭坛"
L["Alterac Mountains"] = "奥特兰克山脉"
L["Always"] = "总是"
L["Amber Lodge"] = "琥珀崖"
L["Amberpine Lodge"] = "琥珀松木营地"
L["Apothecary Camp"] = "药剂师营地"
L["Appearance"] = "外观"
L["Arathi Highlands"] = "阿拉希高地"
L["Area 52"] = "52区"
L["Argent Tournament Grounds"] = "银色比武场"
L["Ashenvale"] = "灰谷"
L["Astranaar"] = "阿斯特兰纳"
L["Auberdine"] = "奥伯丁"
L["Auchenai Crypts"] = "奥金尼地穴"
L["Auto change zones"] = "自动切换区域"
L["Azeroth"] = "艾泽拉斯"
L["Azjol-Nerub"] = "艾卓-尼鲁布"
L["Azshara"] = "艾萨拉"
L["Azuremyst Isle"] = "秘蓝岛"
L["Back to Main Menu"] = "返回主菜单"
L["Badlands"] = "荒芜之地"
L["Battlegrounds"] = "战场"
L["Black Morass"] = "幽暗沼泽"
L["Black Temple"] = "黑暗神殿"
L["Blackfathom Deeps"] = "黑暗深渊"
L["Blackrock Depths"] = "黑石深渊"
L["Blackrock Mountain"] = "黑石山"
L["Blackwing Lair"] = "黑翼之巢"
L["Blade Tooth Canyon"] = "剑齿峡谷"
L["Blade's Edge Mountains"] = "刀锋山"
L["Blades' Run"] = "熔铸刀刃"
L["Blasted Lands"] = "诅咒之地"
L["Blood Watch"] = "秘血岗哨"
L["Bloodmyst Isle"] = "秘血岛"
L["Bloodvenom Post"] = "血毒岗哨"
L["Blue"] = "蓝色"
L["Boat to"] = "乘船前往"
L["Booty Bay"] = "藏宝海湾"
L["Borean Tundra"] = "北风苔原"
L["Bor'gorok Outpost"] = "博古洛克前哨站"
L["Bouldercrag's Refuge"] = "布德克拉格庇护所"
L["Brackenwall Village"] = "蕨墙村"
L["Burning Crusade Classic"] = "燃烧的远征-旧世经典"
L["Burning Steppes"] = "燃烧平原"
L["Camp Mojache"] = "莫沙彻营地"
L["Camp Oneqwah"] = "欧尼瓦营地"
L["Camp Taurajo"] = "陶拉祖营地"
L["Camp Tunka'lo"] = "唐卡洛营地"
L["Camp Winterhoof"] = "冬蹄营地"
L["Caverns of Time"] = "时光之穴"
L["Cenarion Hold"] = "塞纳里奥要塞"
L["Center map on player"] = "为玩家居中地图"
L["Central Mesa"] = "中部高台"
L["Chillwind Camp"] = "冰风岗"
L["Choose where the zone map should be shown."] = "选择地图显示区域"
L["Class colored icons"] = "职业颜色图标"
L["Classic"] = "经典旧世"
L["Click to configure the settings for this option."] = "点击可调整此选项的更多设置。"
L["Click to reset the position and scale of the map frame."] = "点击重置地图的尺寸和位置。"
L["Click to reset the settings on this page."] = "点击重置本页的设置。"
L["Click to return to the main menu."] = "点击返回主菜单。"
L["Coilfang Reservoir"] = "盘牙水库"
L["Coldarra"] = "考达拉"
L["Configuration Panel"] = "设置面板"
L["Conquest Hold"] = "征服堡"
L["Cosmic"] = "宇宙"
L["Cosmowrench"] = "扳钳镇"
L["Crusaders' Pinnacle"] = "北伐军之峰"
L["Crystalsong Forest"] = "晶歌森林"
L["Culling of Stratholme"] = "净化斯坦索姆"
L["Cursor"] = "光标"
L["Dalaran"] = "达拉然"
L["Dalaran Crater"] = "达拉然巨坑"
L["Darkshire"] = "夜色镇"
L["Darkshore"] = "黑海岸"
L["Darnassus"] = "达纳苏斯"
L["Deadwind Pass"] = "逆风小径"
L["Death's Rise"] = "死亡高地"
L["Desolace"] = "凄凉之地"
L["Dire Maul (East)"] = "厄运之槌（东）"
L["Dire Maul (East) (side entrance)"] = "厄运之槌（东）（后门）"
L["Dire Maul (North)"] = "厄运之槌（北）"
L["Dire Maul (West)"] = "厄运之槌（西）"
L["Disable reading emote when opening the map"] = "禁用阅读地图时的表情动作"
L["Drag"] = "拖拽"
L["Drag to set the amount of blue."] = "拖拽调整蓝色数值。"
L["Drag to set the amount of green."] = "拖拽调整绿色数值。"
L["Drag to set the amount of red."] = "拖拽调整红色数值。"
L["Drag to set the battlefield map opacity."] = "拖动以调整区域地图透明度"
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "拖动以设置战场地图尺寸。|n|n如果地图解锁了，你也可以点击它的右下角来改变尺寸。"
L["Drag to set the group icon size."] = "拖动以调整队友图标大小。"
L["Drag to set the map opacity for when your character is moving."] = "拖拽调整当你移动时，地图淡化的透明度。"
L["Drag to set the map opacity for when your character is stationary."] = "拖拽调整当你站定时，地图的透明度。"
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "拖动以设置最大缩放等级。|n|n当你拖动战场地图上的滑块时，可以看到当前的最大缩放等级。"
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "拖动以设置最大缩放等级。|n|n当你拖动地图上的滑块时，可以看到当前的最大缩放等级。"
L["Drag to set the opacity."] = "拖拽调整透明度。"
L["Drag to set the player arrow size."] = "拖动以设置玩家箭头尺寸。"
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "拖动以调整玩家箭头大小。|n|n怀旧服版本游戏默认尺寸是16。|n正式服版本游戏默认为27。"
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "拖动以设置世界地图缩放。|n|n您也可以通过拖动右下角来重新调整世界地图的大小。"
L["Dragonblight"] = "龙骨荒野"
L["Drak'Tharon Keep"] = "达克萨隆要塞"
L["Druid only flight point to Darnassus"] = "至达纳苏斯（德鲁伊专属）"
L["Druid only flight point to Thunder Bluff"] = "至雷霆崖（德鲁伊专属）"
L["Dun Algaz"] = "丹奥加斯"
L["Dun Morogh"] = "丹莫罗"
L["Dun Nifflelem"] = "丹尼芬雷"
L["Dungeon"] = "地下城"
L["Dungeon (requires Crescent Key)"] = "地下城（需要月牙钥匙）"
L["Durotar"] = "杜隆塔尔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "尘泥沼泽"
L["Dwarven District"] = "矮人区"
L["Eastern Plaguelands"] = "东瘟疫之地"
L["Ebon Watch"] = "黑锋哨站"
L["Elements"] = "其他功能"
L["Elwynn Forest"] = "艾尔文森林"
L["Emerald Sanctuary"] = "翡翠圣地"
L["Enhance battlefield map"] = "增强战场地图"
L["Enlarge player arrow"] = "放大玩家指针"
L["Enter"] = "输入"
L["Evergrove"] = "常青林"
L["Everlook"] = "永望镇"
L["Eversong Woods"] = "永歌森林"
L["Exodar"] = "埃索达"
L["Falcon Watch"] = "鹰隼岗哨"
L["Feathermoon Stronghold"] = "羽月要塞"
L["Felwood"] = "费伍德森林"
L["Feralas"] = "菲拉斯"
L["Fishing"] = "钓鱼"
L["Fizzcrank Airstrip"] = "菲兹兰克机场"
L["Flame Crest"] = "烈焰峰"
L["Fordragon Hold"] = "弗塔根要塞"
L["Forest Song"] = "林歌神殿"
L["Fort Wildervar"] = "维德瓦堡垒"
L["Freewind Post"] = "乱风岗"
L["Frosthold"] = "冰霜堡"
L["Gadgetzan"] = "加基森"
L["Garadar"] = "加拉达尔"
L["Ghostlands"] = "幽魂之地"
L["Gnomeregan"] = "诺莫瑞根"
L["Green"] = "绿色"
L["Grizzly Hills"] = "灰熊丘陵"
L["Grom'arsh Crash Site"] = "格罗玛什坠毁点"
L["Grom'gol Base Camp"] = "格罗姆高营地"
L["Group Icons"] = "队友图标调整"
L["Gruul's Lair"] = "格鲁尔的巢穴"
L["Gundrak"] = "古达克"
L["Gundrak (rear entrance)"] = "古达克（后门）"
L["Halls of Lightning"] = "闪电大厅"
L["Halls of Stone"] = "岩石大厅"
L["Hammerfall"] = "落锤镇"
L["Head down the mountain from here."] = "从这里下山。"
L["Head southeast from here and go up the mountain."] = "从这里向东南走，然后上山。"
L["Hellfire Peninsula"] = "地狱火半岛"
L["Hellfire Ramparts"] = "地狱火城墙"
L["Hide town and city icons"] = "隐藏城镇图标"
L["Hillsbrad Foothills"] = "希尔斯布莱德丘陵"
L["Honor Hold"] = "荣耀堡"
L["Horde Cities"] = "部落城市"
L["Howling Fjord"] = "嚎风峡湾"
L["Hyjal Summit"] = "海加尔山"
L["Icecrown"] = "冰冠冰川"
L["Icecrown Citadel"] = "冰冠堡垒"
L["Icons"] = "图标"
L["If checked, archaeology digsites will be shown."] = "勾选后，会在地图上显示考古挖掘点。"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "勾选后，会在地图上标记显示船舶港口，飞艇塔楼和地铁站。"
L["If checked, coordinates will be shown."] = "勾选后，会在地图上显示坐标。"
L["If checked, dungeons and raids will be shown."] = "勾选后，会在地图上标记显示地下城和团队副本入口。"
L["If checked, group icons will use a modern, class-colored design."] = "勾选后，地图上的队友图标会修改成职业颜色。"
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "勾选后，当你所处区域未发生变化时，打开地图会自动跳转最后一次的区域。"
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "勾选后，当你在移动中指向地图时，会停止地图的渐隐，并使用设置的站定透明度。"
L["If checked, points of interest will be shown."] = "勾选后，显示地图的标记点。"
L["If checked, quest objectives will be shown."] = "如果勾选，将显示任务目标。"
L["If checked, spirit healers will be shown."] = "勾选后，显示灵魂医者的位置。"
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "勾选后，当你不在副本中时，战场地图会始终以你当前位置居中。|n|n你可以按住Shift键来停止本次居中设置。"
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "勾选后，将启用默认的全屏地图。|n|n请注意，启用这个选项将锁定部分选项设置。"
L["If checked, the map border will be removed."] = "勾选后，移除地图的黑色边框。"
L["If checked, the map frame will remain open until you close it."] = "勾选后，世界地图将只能被你手动关闭。"
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "勾选后，当你不在副本中时，地图会始终以你当前位置居中。|n|n你可以按住Shift键来停止本次居中设置。"
L["If checked, the minimap button will be shown."] = "勾选后，会启用小地图图标。"
L["If checked, the minimum fishing skill levels will be shown."] = "勾选后，会显示所需要的最低钓鱼等级。"
L["If checked, town and city icons will not be shown on the continent maps."] = "勾选后，将隐藏大陆地图上的城镇图标。"
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "勾选后，显示对立阵营的旅行点标记。|n|n这些包括了飞行点、船舶点、飞艇塔以及火车站等。"
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "勾选后，显示你所处阵营的旅行点标记。|n|n这些包括了飞行点、船舶点、飞艇塔以及火车站等。"
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "勾选后，未探索区域的地图会显示在世界地图及战场地图。"
L["If checked, unexplored areas will be tinted."] = "勾选后，对未探索区域进行染色。"
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "勾选后，当你改变区域时，地图将自动切换至当前区域。"
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "勾选后，你可以拖动区域地图的边框来移动它。|n|n你可以拖动区域地图的右下角来调整它的大小。"
L["If checked, you will be able to customise the battlefield map."] = "勾选后，你可以自定义战场地图。"
L["If checked, you will be able to enlarge the player arrow."] = "勾选后，你可以增大玩家的箭头大小。"
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "如果勾选，您将能够通过拖动右下角的比例手柄来调整地图的大小。|n|n您可以通过拖动任何边框来移动地图。|n|n您始终可以拖动顶部边框来移动地图，而不受此设置的影响。"
L["If checked, you will be able to set the opacity of the map."] = "勾选后，你可以设置地图的透明度。"
L["If checked, you will be able to zoom further into the world map."] = "勾选后，你可以更大限度的缩放世界地图。"
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "勾选后，将在地图框架上显示大陆和区域的下拉菜单。"
L["If checked, zone and dungeon levels will be shown."] = "勾选后，将会显示区域和副本的等级。"
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "勾选后，显示区域中转点。|n|n这些是可供点击的箭头，显示离开区域的捷径。"
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "勾选后，会在地图上显示区域、副本和钓鱼的相关等级。"
L["Increase zoom level"] = "提到缩放等级"
L["Invalid command.  Enter /ltm help for help."] = "无效的命令。输入/ltm help来获取帮助信息。"
L["Invalid command. Enter /ltm help for help."] = "无效的命令。输入/ltm help来获取帮助信息。"
L["Invalid map ID."] = "无效地图ID"
L["Ironforge"] = "铁炉堡"
L["Isle of Quel'Danas"] = "奎尔丹纳斯岛"
L["K3"] = "K3"
L["Kamagua"] = "卡玛古"
L["Karazhan"] = "卡拉赞"
L["Kargath"] = "卡加斯"
L["Kor'kron Vanguard"] = "库卡隆先锋营地"
L["Lake Elune'ara"] = "月神湖"
L["Lake Everstill"] = "湖畔镇"
L["Large Scarab Coffer"] = "大型圣甲虫箱"
L["Leads to Tirisfal Glades"] = "通往提瑞斯法林地"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "警告：你使用了错误的LeatrixMaps版本。"
L["Light's Breach"] = "圣光据点"
L["Light's Hope Chapel"] = "圣光之愿礼拜堂"
L["Loch Modan"] = "洛克莫丹"
L["Lower Blackrock Spire"] = "黑石塔下层"
L["Magisters' Terrace"] = "魔导师平台"
L["Magtheridon's Lair"] = "玛瑟里顿的巢穴"
L["Mana-Tombs"] = "法力陵墓"
L["Map frame scale"] = "地图面板缩放"
L["Map Opacity"] = "地图透明度"
L["Map Scale"] = "地图缩放"
L["Map Size"] = "地图尺寸"
L["MapScale"] = "地图缩放"
L["Maraudon"] = "玛拉顿"
L["Marshal's Refuge"] = "马绍尔营地"
L["Max Zoom"] = "最大缩放"
L["Maximum"] = "最大"
L["Mechanics"] = "地图结构"
L["Memory Usage"] = "内存占用"
L["Menethil Harbor"] = "米奈希尔港"
L["Miscellaneous"] = "杂项"
L["Moa'ki"] = "莫亚基"
L["Moa'ki Harbor"] = "莫亚基港口"
L["Mok'Nathal Village"] = "摩克纳萨尔村"
L["Molten Core"] = "熔火之心"
L["Moonglade"] = "月光林地"
L["More"] = "更多"
L["Morgan's Vigil"] = "摩根的岗哨"
L["Moving"] = "移动"
L["Mudsprocket"] = "泥链镇"
L["Mulgore"] = "莫高雷"
L["Nagrand"] = "纳格兰"
L["Naxxramas"] = "纳克萨玛斯"
L["Nesingwary Base Camp"] = "奈辛瓦里营地"
L["Nethergarde Keep"] = "守望堡"
L["Netherstorm"] = "虚空风暴"
L["Never"] = "从不"
L["New Agamand"] = "新阿加曼德"
L["Nighthaven"] = "永夜港"
L["Nijel's Point"] = "尼耶尔前哨站"
L["North"] = "北方"
L["North Gate Pass"] = "北门小径"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "注意！|n你必须重新启动你的游戏客户端才能正确加载新版本的Leatrix Maps。"
L["Old Hillsbrad"] = "旧希尔斯布莱德"
L["Old Hillsbrad Foothills"] = "旧希尔斯布莱德丘陵"
L["Onyxia's Lair"] = "奥妮克希亚的巢穴"
L["Opacity"] = "透明度"
L["or click the minimap button to open Leatrix Maps."] = "或者点击小地图按钮打开LeatrixMaps。"
L["Orb of Translocation"] = "传送宝珠"
L["Orebor Harborage"] = "奥雷伯尔港"
L["Orgrimmar"] = "奥格瑞玛"
L["Player"] = "玩家"
L["Player Arrow"] = "玩家箭头"
L["Portal"] = "传送门"
L["Portal from Zephyr"] = "从塞菲尔传送"
L["Portals"] = "传送门"
L["Preview"] = "预览"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "团队副本"
L["Ratchet"] = "棘齿城"
L["Ravenholdt Manor"] = "拉文霍德庄园"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼泽"
L["Razorthorn Trail"] = "刺棘蔓"
L["Rebel Camp"] = "反抗军营地"
L["Red"] = "红色"
L["Redridge Mountains"] = "赤脊山"
L["Refuge Pointe"] = "避难谷地"
L["Reload"] = "重载插件"
L["Remember zoom level"] = "保存缩放等级"
L["Remove map border"] = "移除地图边框"
L["req"] = "需要"
L["Requires Key to Searing Gorge"] = "需要前往灼热峡谷的钥匙"
L["Requires UI reload."] = "需要重载插件。"
L["Reset"] = "重置"
L["Reset Map Layout"] = "重置地图设置"
L["Revantusk Village"] = "恶齿村"
L["River's Heart"] = "河流之心"
L["Ruins of Ahn'Qiraj"] = "安其拉废墟"
L["Ruins of Elune'eth"] = "艾露尼斯废墟"
L["Rut'theran Village"] = "鲁瑟兰村"
L["Rut'Theran Village"] = "鲁瑟兰村"
L["Sanctum of the Stars"] = "星光圣所"
L["Scale"] = "缩放"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通灵学院"
L["Searing Gorge"] = "灼热峡谷"
L["Seat of the Naaru"] = "纳鲁之座"
L["Sentinel Hill"] = "哨兵岭"
L["Serpentshrine Cavern"] = "毒蛇神殿"
L["Set map opacity"] = "设置地图透明度"
L["Set map opacity while stationary and while moving."] = "设置当站定和移动时的地图透明度。"
L["Set the group icon size."] = "设置队友图标尺寸。"
L["Set the maximum zoom scale."] = "设置最大缩放尺寸。"
L["Set the player arrow size."] = "设置玩家箭头大小。"
L["Sethekk Halls"] = "塞泰克大厅"
L["Settings"] = "设置"
L["Sewers"] = "下水道"
L["Shadow Labyrinth"] = "暗影迷宫"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowmoon Valley"] = "影月谷"
L["Shadowmoon Village"] = "影月村"
L["Shadowprey Village"] = "葬影村"
L["Shatter Point"] = "破碎岗哨"
L["Shattrath"] = "沙塔斯"
L["Shattrath City"] = "沙塔斯城"
L["Sholazar Basin"] = "索拉查盆地"
L["Show boats, zeppelins and trams"] = "显示港口/飞艇/地铁站"
L["Show coordinates"] = "显示坐标"
L["Show digsites"] = "显示挖掘点"
L["Show dungeons and raids"] = "标记副本入口"
L["Show minimap button"] = "显示小地图按钮"
L["Show minimum fishing skill levels"] = "显示最低钓鱼等级"
L["Show objectives"] = "显示目标"
L["Show points of interest"] = "启用地图的标记点"
L["Show scale handle"] = "允许缩放地图框体"
L["Show spirit healers"] = "显示灵魂医者"
L["Show travel points for opposing faction"] = "对立阵营旅行点"
L["Show travel points for same faction"] = "同阵营旅行点"
L["Show unexplored areas"] = "显示未探索区域"
L["Show zone crossings"] = "显示区域中转点"
L["Show zone levels"] = "显示区域等级"
L["Show zone menus"] = "显示区域菜单"
L["Silithus"] = "希利苏斯"
L["Silvermoon"] = "银月城"
L["Silvermoon City"] = "银月城"
L["Silverpine Forest"] = "银松森林"
L["Slave Pens"] = "奴隶围栏"
L["South"] = "南方"
L["South Gate Pass"] = "南门小径"
L["Southfury River"] = "怒水河"
L["Southshore"] = "南海镇"
L["Spinebreaker Ridge"] = "断脊山"
L["Spirit Healer"] = "灵魂医者"
L["Splintertree Post"] = "碎木岗哨"
L["Stars' Rest"] = "群星之墓"
L["Stationary"] = "站定"
L["Steamvault"] = "蒸汽地窟"
L["Sticky map frame"] = "世界地图锁定"
L["Stonard"] = "斯通纳德"
L["Stonebreaker Hold"] = "裂石堡"
L["Stonetalon Mountains"] = "石爪山脉"
L["Stonetalon Peak"] = "石爪峰"
L["Stormwind"] = "暴风城"
L["Stormwind City"] = "暴风城"
L["Stranglethorn Vale"] = "荆棘谷"
L["Stratholme (Main Gate)"] = "斯坦索姆（前门）"
L["Stratholme (Service Gate)"] = "斯坦索姆（侧门）"
L["sum"] = "召唤"
L["Sun Rock Retreat"] = "烈日石居"
L["Sunreaver's Command"] = "夺日者指挥站"
L["Sun's Reach Harbor"] = "阳湾港口"
L["Sunwell Plateau"] = "太阳之井高地"
L["Swamp of Sorrows"] = "悲伤沼泽"
L["Swamprat Post"] = "斯瓦姆普拉特营地"
L["Sylvanaar"] = "希尔瓦娜岗哨"
L["System"] = "系统"
L["Talonbranch Glade"] = "刺枝林地"
L["Talrendis Point"] = "塔伦迪斯营地"
L["Tanaris"] = "塔纳利斯"
L["Tarren Mill"] = "塔伦米尔"
L["Taunka'le Village"] = "牦牛村"
L["Telaar"] = "泰拉尔"
L["Teldrassil"] = "泰达希尔"
L["Teleport Crystal"] = "传送水晶"
L["Telredor"] = "泰雷多尔"
L["Tempest Keep"] = "风暴要塞"
L["Temple of Ahn'Qiraj"] = "安其拉神殿"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神庙"
L["Temple of Telhamat"] = "特尔哈曼神庙"
L["Terokkar Forest"] = "泰罗卡森林"
L["Thalanaar"] = "萨兰纳尔"
L["Thandol Span"] = "萨多尔大桥"
L["The Arcatraz"] = "禁魔监狱"
L["The Argent Stand"] = "银色前沿"
L["The Argent Vanguard"] = "银色前线基地"
L["The Barrens"] = "贫瘠之地"
L["The Blood Furnace"] = "鲜血熔炉"
L["The Botanica"] = "生态船"
L["The Bulwark"] = "亡灵壁垒"
L["The Crossroads"] = "十字路口"
L["The Dark Portal"] = "黑暗之门"
L["The Deadmines"] = "死亡矿井"
L["The Exodar"] = "埃索达"
L["The Eye"] = "风暴要塞"
L["The Eye of Eternity"] = "永恒之眼"
L["The Forge of Souls"] = "灵魂洪炉"
L["The Forgotten Coast"] = "被遗忘的海岸"
L["The Frozen Halls"] = "冰封大殿"
L["The Great Forge"] = "大锻炉"
L["The Great Lift"] = "升降梯"
L["The Halls of Reflection"] = "映像大厅"
L["The Hinterlands"] = "辛特兰"
L["The Mechanar"] = "能源舰"
L["The Nexus"] = "魔枢"
L["The Obsidian Sanctum"] = "黑曜石圣殿"
L["The Oculus"] = "魔环"
L["The Old Kingdom"] = "古代王国"
L["The Pit of Saron"] = "萨隆矿坑"
L["The Ruby Sanctum"] = "红玉圣殿"
L["The Sepulcher"] = "瑟伯切尔"
L["The Shadow Vault"] = "暗影拱顶"
L["The Shattered Halls"] = "破碎大厅"
L["The Stockade"] = "监狱"
L["The Storm Peaks"] = "风暴峭壁"
L["The Stormspire"] = "风暴尖塔"
L["The Talondeep Path"] = "石爪小径"
L["The Vault of Lights"] = "圣光大厅"
L["The Violet Hold"] = "紫罗兰监狱"
L["The Zoram Strand"] = "佐拉姆海岸"
L["Thelsamar"] = "塞尔萨玛"
L["Theramore Isle"] = "塞拉摩岛"
L["Thorium Point"] = "瑟银哨塔"
L["Thousand Needles"] = "千针石林"
L["Thrallmar"] = "萨尔玛"
L["Thunder Bluff"] = "雷霆崖"
L["Thunderlord Stronghold"] = "雷霆王村"
L["Timbermaw Hold"] = "木喉要塞"
L["Tinker Town"] = "工匠区"
L["Tint unexplored areas"] = "未探索区域染色"
L["Tirisfal Glades"] = "提瑞斯法林地"
L["Toggle panel"] = "切换面板"
L["Toshley's Station"] = "托斯雷工作站"
L["Trade District"] = "贸易区"
L["Trade Quarter"] = "贸易区"
L["Tram to"] = "乘地铁前往"
L["Tranquillien"] = "塔奎林"
L["Transitus Shield"] = "永生之盾"
L["Transparency"] = "透明度"
L["Trial of the Champion"] = "冠军的试炼"
L["Trial of the Crusader"] = "十字军的试炼"
L["Twilight Shore"] = "暮光海岸"
L["Twilight Vale"] = "暮光谷"
L["Uldaman"] = "奥达曼"
L["Uldaman (side entrance)"] = "奥达曼（后门）"
L["Ulduar"] = "奥杜尔"
L["Underbog"] = "幽暗沼泽"
L["Undercity"] = "幽暗城"
L["Un'Goro Crater"] = "安戈洛环形山"
L["Unlock battlefield map"] = "解锁区域地图"
L["Unlock map frame"] = "解锁地图框体"
L["Unu'pe"] = "乌努比"
L["Upper Blackrock Spire"] = "黑石塔上层"
L["Use default map"] = "使用默认地图"
L["Use stationary opacity while pointing at map"] = "指向地图时取消渐隐"
L["Utgarde Keep"] = "乌特加德城堡"
L["Utgarde Pinnacle"] = "乌特加德之巅"
L["Valaar's Berth"] = "瓦拉尔港口"
L["Valgarde"] = "瓦加德"
L["Valgarde Port"] = "瓦加德"
L["Valiance Keep"] = "无畏要塞"
L["Valiance Landing Camp"] = "无畏港营地"
L["Valley of Strength"] = "力量谷"
L["Valormok"] = "瓦罗莫克"
L["Vault of Archavon"] = "阿尔卡冯的宝库"
L["Vengeance Landing"] = "复仇港"
L["Venomspite"] = "怨毒镇"
L["Version"] = "版本"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Warsong Camp"] = "战歌营地"
L["Warsong Hold"] = "战歌要塞"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Westfall Brigade"] = "月溪旅营地"
L["Westguard Keep"] = "西部卫戍要塞"
L["Wetlands"] = "湿地"
L["Wildhammer Stronghold"] = "蛮锤要塞"
L["Windrunner's Overlook"] = "风行者观察站"
L["Wintergarde Keep"] = "暮冬要塞"
L["Wintergrasp"] = "冬拥湖"
L["Winterspring"] = "冬泉谷"
L["Wrath of the Lich King Classic"] = "巫妖王之怒旧世经典"
L["Wyrmrest Temple"] = "龙眠神殿"
L["You will die!"] = "你会死的！"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "为了让部分功能生效，你的插件需要重新载入。|n|n你无需立即点击重载插件按钮。可以根据自己的情况或者设置完毕后，再进行重载插件的操作。"
L["Your UI needs to be reloaded."] = "插件需要重新载入。"
L["Zabra'jin"] = "萨布拉金"
L["Zangarmarsh"] = "赞加沼泽"
L["Zeb'Sora"] = "塞布索雷"
L["Zeppelin to"] = "乘飞艇前往"
L["Zim'Torga"] = "希姆托加"
L["Zone Map"] = "区域地图"
L["Zoom"] = "缩放"
L["Zoram'gar Outpost"] = "佐拉姆加前哨站"
L["Zul'Aman"] = "祖阿曼"
L["Zul'Drak"] = "祖达克"
L["Zul'Farrak"] = "祖尔法拉克"
L["Zul'Gurub"] = "祖尔格拉布"

end

-- zhTW: Traditional Chinese (Taiwan)
if GameLocale == "zhTW" then
L["(destination only)"] = "（僅限目的地）"
L["(inside Caverns of Time)"] = "（時光之穴內）"
L["/ltm help - Show this information."] = "/ltm help - 顯示插件資訊。"
L["/ltm reset - Reset the panel position."] = "/ltm reset - 重設面板位置。"
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - 清除所有設定並重載。"
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "一個停止錯誤發生了，但無需擔心，三不五時會發生，請點擊重載按鈕來解決它。"
L["A stop error has occurred but no need to worry. It can happen from time to time. Click the reload button to resolve it."] = "發生了停止錯誤，但無需擔心。它可能不時發生。點擊重載按鈕來解決它。"
L["Acherus: The Ebon Hold"] = "亡靈壁壘：黑暗堡壘"
L["Aerie Peak"] = "應巢山"
L["Agmar's Hammer"] = "艾卡瑪之錘"
L["Ahn'Qiraj"] = "安其拉"
L["Aldor"] = "奧多爾"
L["Allerian Stronghold"] = "艾蘭里堡壘"
L["Alliance Cities"] = "聯盟城市"
L["Alpha"] = "透明"
L["Altar of Sha'tar"] = "薩塔祭壇"
L["Alterac Mountains"] = "奧特蘭山脈"
L["Always"] = "總是"
L["Amber Lodge"] = "琥珀小屋"
L["Amberpine Lodge"] = "琥珀松小屋"
L["Apothecary Camp"] = "藥劑師營地"
L["Appearance"] = "外觀"
L["Arathi Highlands"] = "阿拉希高地"
L["Area 52"] = "52區"
L["Argent Tournament Grounds"] = "銀白錦標賽場地"
L["Ashenvale"] = "梣谷"
L["Astranaar"] = "阿斯特蘭納"
L["Auberdine"] = "奧伯丁"
L["Auchenai Crypts"] = "奧奇奈地穴"
L["Auto change zones"] = "自動變換區域"
L["Azeroth"] = "艾澤拉斯"
L["Azjol-Nerub"] = "亞茲歐-奈幽"
L["Azshara"] = "艾薩拉"
L["Azuremyst Isle"] = "藍謎島"
L["Back to Main Menu"] = "回到主選單"
L["Badlands"] = "荒蕪之地"
L["Battlegrounds"] = "戰場"
L["Black Morass"] = "黑暗沼澤"
L["Black Temple"] = "黑暗神廟"
L["Blackfathom Deeps"] = "黑澗深淵"
L["Blackrock Depths"] = "黑石深淵"
L["Blackrock Mountain"] = "黑石山"
L["Blackwing Lair"] = "黑翼之巢"
L["Blade Tooth Canyon"] = "劍牙峽谷"
L["Blade's Edge Mountains"] = "劍刃山脈"
L["Blades' Run"] = "刃刀小道"
L["Blasted Lands"] = "詛咒之地"
L["Blood Watch"] = "血色守望"
L["Bloodmyst Isle"] = "血謎島"
L["Bloodvenom Post"] = "血毒崗哨"
L["Blue"] = "藍色"
L["Boat to"] = "船到"
L["Booty Bay"] = "藏寶海灣"
L["Borean Tundra"] = "北風凍原"
L["Bor'gorok Outpost"] = "博古洛克前哨站"
L["Bouldercrag's Refuge"] = "礫石巨克的避難所"
L["Brackenwall Village"] = "蕨牆村"
L["Burning Crusade Classic"] = "經典-燃燒的遠征"
L["Burning Steppes"] = "燃燒平原"
L["Camp Mojache"] = "莫沙澈營地"
L["Camp Oneqwah"] = "奧尼克瓦營地"
L["Camp Taurajo"] = "陶拉祖營地"
L["Camp Tunka'lo"] = "坦卡洛營地"
L["Camp Winterhoof"] = "冬蹄營地"
L["Caverns of Time"] = "時光之穴"
L["Cenarion Hold"] = "賽納里奧要塞"
L["Center map on player"] = "地圖以玩家為中心"
L["Central Mesa"] = "中部高台"
L["Chillwind Camp"] = "冰風崗哨"
L["Choose where the zone map should be shown."] = "選擇區域地圖的顯示位置。"
L["Class colored icons"] = "職業著色圖示"
L["Classic"] = "經典"
L["Click to configure the settings for this option."] = "點擊來設置此選項的設定。"
L["Click to reset the position and scale of the map frame."] = "點擊來重設地圖框架的位置與大小。"
L["Click to reset the settings on this page."] = "點擊來重設此頁的設定。"
L["Click to return to the main menu."] = "點擊來重返主選單。"
L["Coilfang Reservoir"] = "盤牙水庫"
L["Coldarra"] = "寒冰之地"
L["Configuration Panel"] = "設置面板"
L["Conquest Hold"] = "征服堡"
L["Cosmic"] = "宇宙"
L["Cosmowrench"] = "扭曲太空"
L["Crusaders' Pinnacle"] = "十字軍之巔"
L["Crystalsong Forest"] = "晶歌森林"
L["Culling of Stratholme"] = "斯坦索姆的抉擇"
L["Cursor"] = "鼠標"
L["Dalaran"] = "達拉然"
L["Dalaran Crater"] = "達拉然陷坑"
L["Darkshire"] = "夜色鎮"
L["Darkshore"] = "黑海岸"
L["Darnassus"] = "達納蘇斯"
L["Deadwind Pass"] = "逆風小徑"
L["Death's Rise"] = "死亡高地"
L["Desolace"] = "淒涼之地"
L["Dire Maul (East)"] = "厄運之槌 (東)"
L["Dire Maul (East) (side entrance)"] = "厄運之槌（東）（側面入口）"
L["Dire Maul (North)"] = "厄運之槌 (北)"
L["Dire Maul (West)"] = "厄運之槌 (西)"
L["Disable reading emote when opening the map"] = "當開啟地圖時取消閱讀表情"
L["Drag"] = "拖動"
L["Drag to set the amount of blue."] = "拖拉來設定藍色的數值。"
L["Drag to set the amount of green."] = "拖拉來設定綠色的數值。"
L["Drag to set the amount of red."] = "拖拉來設定紅色的數值。"
L["Drag to set the battlefield map opacity."] = "拖動以設置戰場地圖的透明度。"
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "拖動以設置戰場地圖大小。n|n如果地圖已解鎖，您還可以通過拖動右下角來調整戰場地圖的大小。"
L["Drag to set the group icon size."] = "拖拉來設定隊伍圖示大小。"
L["Drag to set the map opacity for when your character is moving."] = "拖拉來設定當您角色移動時地圖的透明度。"
L["Drag to set the map opacity for when your character is stationary."] = "拖拉來設定當您角色靜止時地圖的透明度。"
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "拖動以設置最大縮放等級。|n|n打開戰場地圖以查看拖動卷軸時最大縮放等級的變化。"
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "拖動以設置最大縮放等級。|n|n打開地圖以查看在拖動卷軸時最大縮放等級的變化。"
L["Drag to set the opacity."] = "拖拉來設定透明度。"
L["Drag to set the player arrow size."] = "拖拉來設定玩家箭頭大小。"
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "拖拉以設置玩家箭頭大小。|n|n魔獸世界經典版預設為16。|n魔獸世界正式版預設為27。"
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "拖動以設置世界地圖縮放。|n|n您也可以通過拖動右下角來重新調整世界地圖的大小。"
L["Dragonblight"] = "龍骨荒野"
L["Drak'Tharon Keep"] = "德拉克薩隆要塞"
L["Druid only flight point to Darnassus"] = "到達納蘇斯的德魯伊專用鳥點"
L["Druid only flight point to Thunder Bluff"] = "到雷霆崖的德魯伊專用鳥點"
L["Dun Algaz"] = "丹奧加茲"
L["Dun Morogh"] = "丹莫洛"
L["Dun Nifflelem"] = "丹尼弗雷倫"
L["Dungeon"] = "地下城"
L["Dungeon (requires Crescent Key)"] = "地城（需要新月鑰匙）"
L["Durotar"] = "杜洛塔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "塵泥沼澤"
L["Dwarven District"] = "矮人區"
L["Eastern Plaguelands"] = "東瘟疫之地"
L["Ebon Watch"] = "黑錶哨站"
L["Elements"] = "元素"
L["Elwynn Forest"] = "艾爾文森林"
L["Emerald Sanctuary"] = "翡翠聖地"
L["Enhance battlefield map"] = "增強戰場地圖"
L["Enlarge player arrow"] = "放大玩家箭頭"
L["Enter"] = "輸入"
L["Evergrove"] = "永恆樹林"
L["Everlook"] = "永望鎮"
L["Eversong Woods"] = "永歌森林"
L["Exodar"] = "艾克索達"
L["Falcon Watch"] = "獵鷹哨站"
L["Feathermoon Stronghold"] = "羽月要塞"
L["Felwood"] = "費伍德森林"
L["Feralas"] = "菲拉斯"
L["Fishing"] = "釣魚"
L["Fizzcrank Airstrip"] = "飛翎煙霧平臺"
L["Flame Crest"] = "烈焰峰"
L["Fordragon Hold"] = "福德拉格之堡"
L["Forest Song"] = "森林之歌"
L["Fort Wildervar"] = "威德瓦堡壘"
L["Freewind Post"] = "亂風崗"
L["Frosthold"] = "霜堡"
L["Gadgetzan"] = "加基森"
L["Garadar"] = "卡拉達爾"
L["Ghostlands"] = "鬼魂之地"
L["Gnomeregan"] = "諾姆瑞根"
L["Green"] = "綠色"
L["Grizzly Hills"] = "灰熊丘陵"
L["Grom'arsh Crash Site"] = "格羅瑪爾墜毀地"
L["Grom'gol Base Camp"] = "格羅姆高營地"
L["Group Icons"] = "隊伍圖示"
L["Gruul's Lair"] = "戈魯爾之巢"
L["Gundrak"] = "剛德拉克"
L["Gundrak (rear entrance)"] = "剛德拉克（後方入口）"
L["Halls of Lightning"] = "雷光大廳"
L["Halls of Stone"] = "石之大廳"
L["Hammerfall"] = "落錘鎮"
L["Head down the mountain from here."] = "從這裡下山。"
L["Head southeast from here and go up the mountain."] = "從這裡向東南走，然後上山。"
L["Hellfire Peninsula"] = "地獄火半島"
L["Hellfire Ramparts"] = "地獄火壁壘"
L["Hide town and city icons"] = "隱藏城鎮與都市圖示"
L["Hillsbrad Foothills"] = "希爾斯布萊德丘陵"
L["Honor Hold"] = "榮譽堡"
L["Horde Cities"] = "部落城市"
L["Howling Fjord"] = "凜風峽灣"
L["Hyjal Summit"] = "海加爾山之戰"
L["Icecrown"] = "寒冰皇冠"
L["Icecrown Citadel"] = "冰冠城寨"
L["Icons"] = "圖示"
L["If checked, archeaology digsites will be shown."] = "勾選後，將顯示考古挖掘點。"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "勾選後，船舶碼頭、飛艇塔樓以及地鐵站都將顯示。"
L["If checked, coordinates will be shown."] = "勾選後，將顯示座標。"
L["If checked, dungeons and raids will be shown."] = "勾選後，將顯示地下城與團隊副本。"
L["If checked, group icons will use a modern, class-colored design."] = "勾選後，隊伍圖示將使用更為摩登且職業著色的設計。"
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "勾選後，開啟地圖時會使用最後關閉地圖時的縮放等級，如果地圖區域並未改變。"
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "勾選後，當角色移動時指向地圖將會套用靜止的透明度設置。"
L["If checked, points of interest will be shown."] = "勾選後，將顯示關注點。"
L["If checked, quest objectives will be shown."] = "如果選中，將顯示任務目標。"
L["If checked, spirit healers will be shown."] = "勾選後，靈魂醫者將會顯示。"
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "勾選後，只要您不在地城中，戰場地圖就會以您所在的位置為中心。|n|n您可以在平移地圖時按住 shift 以暫時防止其居中。"
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "勾選後，將使用預設的全屏地圖。|n|n請注意，啟用此選項將鎖定其他某些選項。"
L["If checked, the map border will be removed."] = "勾選後，將會移除地圖外框。"
L["If checked, the map frame will remain open until you close it."] = "勾選後，則地圖框將保持打開狀態，直到您將其關閉。"
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "勾選後，只要您不在地城中，地圖就會以您所在的位置為中心。|n|n您可以在平移地圖時按住 shift 以暫時防止其居中。"
L["If checked, the minimap button will be shown."] = "勾選後，會顯示小地圖按鈕。"
L["If checked, the minimum fishing skill levels will be shown."] = "勾選後，將顯示最低釣魚需求技能等級。"
L["If checked, town and city icons will not be shown on the continent maps."] = "勾選後，大陸地圖將不會顯示城鎮與都市圖示。"
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "勾選後，將顯示敵對陣營的旅行點。|n|n這包括鳥點、港口、飛艇塔和電車站。"
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "勾選後，將顯示相同陣營的旅行點。|n|n這包括鳥點、港口、飛艇塔和電車站。"
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "勾選後，地圖的未探索區域將顯示在世界地圖和戰場地圖上。"
L["If checked, unexplored areas will be tinted."] = "勾選後，未探索區域將會著色。"
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "勾選後，當角色變換區域時，地圖將自動更改為新區域。"
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "勾選後，您可以通過拖動任何邊界來移動戰場地圖。|n|n您可以通過拖動右下角來調整戰場地圖的大小。"
L["If checked, you will be able to customise the battlefield map."] = "勾選後，您將可以自訂戰場地圖。"
L["If checked, you will be able to enlarge the player arrow."] = "勾選後，您將可以放大玩家箭頭。"
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "如果選中，您將能夠通過拖動右下角的縮放手柄來調整地圖的比例。|n|n您可以通過拖動任何邊框來移動地圖。|n|n您始終可以拖動頂部邊框來移動地圖，而不受此設置的影響。"
L["If checked, you will be able to set the opacity of the map."] = "勾選後，您將可以設定地圖的透明度。"
L["If checked, you will be able to zoom further into the world map."] = "勾選後，您將能夠進一步放大世界地圖。"
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "勾選後，區域和大陸下拉選單將顯示在地圖框中。"
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "勾選後，將顯示區域交叉口。|n|n這些是指示區域出口路徑的可點擊箭頭。"
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "勾選後，將顯示區域、地下城以及釣魚技能等級。"
L["Increase zoom level"] = "增加縮放等級"
L["Invalid command.  Enter /ltm help for help."] = "無效的指令。輸入 /ltm help 取得幫助。"
L["Invalid command. Enter /ltm help for help."] = "無效的指令。輸入 /ltm help 以獲得幫助。"
L["Invalid map ID."] = "無效地圖ID"
L["Ironforge"] = "鐵爐堡"
L["Isle of Quel'Danas"] = "奎爾達納斯之島"
L["K3"] = "K3"
L["Kamagua"] = "卡瑪古阿"
L["Karazhan"] = "卡拉贊"
L["Kargath"] = "卡加斯"
L["Kor'kron Vanguard"] = "科爾克隆先遣鏢局"
L["Lake Elune'ara"] = "月神湖"
L["Lake Everstill"] = "湖畔鎮"
L["Large Scarab Coffer"] = "大型聖甲蟲箱"
L["Leads to Tirisfal Glades"] = "通往提里斯法林地"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: 安裝了錯誤的版本！"
L["Light's Breach"] = "聖光之斷"
L["Light's Hope Chapel"] = "聖光之願大教堂"
L["Loch Modan"] = "洛克莫丹"
L["Lower Blackrock Spire"] = "黑石塔下層"
L["Magisters' Terrace"] = "博學者殿堂"
L["Magtheridon's Lair"] = "馬瑟里頓的巢穴"
L["Mana-Tombs"] = "法力墓地"
L["Map frame scale"] = "地圖框架縮放"
L["Map Opacity"] = "地圖透明度"
L["Map Scale"] = "地圖縮放大小"
L["Map Size"] = "地圖大小"
L["MapScale"] = "地圖縮放"
L["Maraudon"] = "瑪拉頓"
L["Marshal's Refuge"] = "馬紹爾營地"
L["Max Zoom"] = "最大縮放"
L["Maximum"] = "最大"
L["Mechanics"] = "地圖結構"
L["Memory Usage"] = "記憶體使用量"
L["Menethil Harbor"] = "米奈希爾港"
L["Miscellaneous"] = "雜項"
L["Moa'ki"] = "莫亞基"
L["Moa'ki Harbor"] = "莫亞基港"
L["Mok'Nathal Village"] = "摩克納薩爾村"
L["Molten Core"] = "熔火之心"
L["Moonglade"] = "月光林地"
L["More"] = "更多"
L["Morgan's Vigil"] = "摩根的崗哨"
L["Moving"] = "移動"
L["Mudsprocket"] = "泥鏈營地"
L["Mulgore"] = "莫高雷"
L["Nagrand"] = "納葛蘭"
L["Naxxramas"] = "納克薩瑪斯"
L["Nesingwary Base Camp"] = "奈辛瓦里營地"
L["Nethergarde Keep"] = "守望堡"
L["Netherstorm"] = "虛空風暴"
L["Never"] = "從不"
L["New Agamand"] = "新阿加曼德"
L["Nighthaven"] = "永夜港"
L["Nijel's Point"] = "尼耶爾前哨站"
L["North"] = "北方"
L["North Gate Pass"] = "北門小徑"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "注意！|n您必須完全重新啟動遊戲客戶端才能使用此版本的Leatrix Maps。"
L["Old Hillsbrad"] = "希爾斯布萊德舊世"
L["Old Hillsbrad Foothills"] = "希爾斯布萊德丘陵舊址"
L["Onyxia's Lair"] = "奧妮克希亞的巢穴"
L["Opacity"] = "透明度"
L["or click the minimap button to open Leatrix Maps."] = "或是點擊小地圖按鈕來開啟Leatrix Maps。"
L["Orb of Translocation"] = "傳送水晶球"
L["Orebor Harborage"] = "奧雷伯爾港"
L["Orgrimmar"] = "奧格瑪"
L["Player"] = "玩家"
L["Player Arrow"] = "玩家箭頭"
L["Portal"] = "傳送門"
L["Portal from Zephyr"] = "西風之門"
L["Portals"] = "傳送門"
L["Preview"] = "預覽"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "團隊副本"
L["Ratchet"] = "棘齒城"
L["Ravenholdt Manor"] = "拉文霍德莊園"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼澤"
L["Razorthorn Trail"] = "劍刺小徑"
L["Rebel Camp"] = "反抗軍營地"
L["Red"] = "紅色"
L["Redridge Mountains"] = "赤脊山"
L["Refuge Pointe"] = "避難谷地"
L["Reload"] = "重載"
L["Remember zoom level"] = "記憶縮放等級"
L["Remove map border"] = "移除地圖外框"
L["req"] = "需要"
L["Requires Key to Searing Gorge"] = "需要灼熱峽谷的鑰匙"
L["Requires UI reload."] = "需要介面重載。"
L["Reset"] = "重置"
L["Reset Map Layout"] = "重設地圖佈局"
L["Revantusk Village"] = "惡齒村"
L["River's Heart"] = "河流之心"
L["Ruins of Ahn'Qiraj"] = "安琪拉廢墟"
L["Ruins of Elune'eth"] = "伊露恩斯遺址"
L["Rut'theran Village"] = "魯瑟蘭村"
L["Rut'Theran Village"] = "魯瑟蘭村"
L["Sanctum of the Stars"] = "星光聖所"
L["Scale"] = "縮放比例"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通靈學院"
L["Searing Gorge"] = "灼熱峽谷"
L["Seat of the Naaru"] = "納魯之座"
L["Sentinel Hill"] = "哨兵嶺"
L["Serpentshrine Cavern"] = "毒蛇神殿洞穴"
L["Set map opacity"] = "設定地圖透明度"
L["Set map opacity while stationary and while moving."] = "設定當移動或靜止時地圖的透明度。"
L["Set the group icon size."] = "設定隊伍圖示大小。"
L["Set the maximum zoom scale."] = "設置最大縮放比例。"
L["Set the player arrow size."] = "設置玩家箭頭大小。"
L["Sethekk Halls"] = "塞司克大廳"
L["Settings"] = "設置"
L["Sewers"] = "下水道"
L["Shadow Labyrinth"] = "暗影迷宮"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowmoon Valley"] = "影月谷"
L["Shadowmoon Village"] = "影月村"
L["Shadowprey Village"] = "葬影村"
L["Shatter Point"] = "碎裂地點"
L["Shattrath"] = "撒塔斯"
L["Shattrath City"] = "撒塔斯城"
L["Sholazar Basin"] = "索拉查盆地"
L["Show boats, zeppelins and trams"] = "顯示船舶、飛艇以及地鐵"
L["Show coordinates"] = "顯示座標"
L["Show dungeons and raids"] = "顯示地下城與團隊副本"
L["Show minimap button"] = "顯示小地圖按鈕"
L["Show minimum fishing skill levels"] = "顯示最低釣魚技能等級"
L["Show objectives"] = "顯示目標"
L["Show points of interest"] = "顯示關注站點"
L["Show scale handle"] = "顯示縮放控制"
L["Show spirit healers"] = "顯示靈魂醫者"
L["Show travel points for opposing faction"] = "顯示敵對陣營的旅行點"
L["Show travel points for same faction"] = "顯示相同陣營的旅行點"
L["Show unexplored areas"] = "顯露未探索區域"
L["Show zone crossings"] = "顯示區域交叉口"
L["Show zone levels"] = "顯示區域等級"
L["Show zone menus"] = "顯示區域選單"
L["Silithus"] = "希利蘇斯"
L["Silvermoon"] = "銀月城"
L["Silvermoon City"] = "銀月城"
L["Silverpine Forest"] = "銀松森林"
L["Slave Pens"] = "奴隸監牢"
L["South"] = "南方"
L["South Gate Pass"] = "南門小徑"
L["Southfury River"] = "南怒之河"
L["Southshore"] = "南海鎮"
L["Spinebreaker Ridge"] = "斷脊山脈"
L["Spirit Healer"] = "靈魂醫者"
L["Splintertree Post"] = "碎木崗哨"
L["Stars' Rest"] = "星光之息"
L["Stationary"] = "靜止"
L["Steamvault"] = "蒸氣洞窟"
L["Sticky map frame"] = "黏附地圖框架"
L["Stonard"] = "斯通納德"
L["Stonebreaker Hold"] = "碎石堡"
L["Stonetalon Mountains"] = "石爪山脈"
L["Stonetalon Peak"] = "石爪峰"
L["Stormwind"] = "暴風城"
L["Stormwind City"] = "暴風城"
L["Stranglethorn Vale"] = "荊棘谷"
L["Stratholme (Main Gate)"] = "斯坦索姆 (正門)"
L["Stratholme (Service Gate)"] = "斯坦索姆 (側門)"
L["sum"] = "召喚"
L["Sun Rock Retreat"] = "烈日石居"
L["Sunreaver's Command"] = "逐日者指揮部"
L["Sun's Reach Harbor"] = "日境港"
L["Sunwell Plateau"] = "太陽之井高地"
L["Swamp of Sorrows"] = "悲傷沼澤"
L["Swamprat Post"] = "斯溫派特崗哨"
L["Sylvanaar"] = "希爾瓦納"
L["System"] = "系統"
L["Talonbranch Glade"] = "刺枝林地"
L["Talrendis Point"] = "塔倫迪斯營地"
L["Tanaris"] = "塔納利斯"
L["Tarren Mill"] = "塔倫米爾"
L["Taunka'le Village"] = "唐卡雷村"
L["Telaar"] = "泰拉"
L["Teldrassil"] = "泰達希爾"
L["Teleport Crystal"] = "傳送水晶"
L["Telredor"] = "泰倫多爾"
L["Tempest Keep"] = "風暴要塞"
L["Temple of Ahn'Qiraj"] = "安琪拉神廟"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神廟"
L["Temple of Telhamat"] = "特爾哈曼神廟"
L["Terokkar Forest"] = "泰洛卡森林"
L["Thalanaar"] = "薩蘭納爾"
L["Thandol Span"] = "湯德爾之橋"
L["The Arcatraz"] = "亞克崔茲"
L["The Argent Stand"] = "銀白看臺"
L["The Argent Vanguard"] = "銀白先鋒"
L["The Barrens"] = "貧瘠之地"
L["The Blood Furnace"] = "血熔爐"
L["The Botanica"] = "波塔尼卡"
L["The Bulwark"] = "堡壘"
L["The Crossroads"] = "十字路口"
L["The Dark Portal"] = "黑暗之門"
L["The Deadmines"] = "死亡礦坑"
L["The Exodar"] = "艾克索達"
L["The Eye"] = "暴風之眼"
L["The Eye of Eternity"] = "永恆之眼"
L["The Forge of Souls"] = "靈魂熔爐"
L["The Forgotten Coast"] = "被遺忘的海岸"
L["The Frozen Halls"] = "冰凍大廳"
L["The Great Forge"] = "大鍛爐"
L["The Great Lift"] = "大升降梯"
L["The Halls of Reflection"] = "倒映大廳"
L["The Hinterlands"] = "辛特蘭"
L["The Mechanar"] = "麥克納爾"
L["The Nexus"] = "魔枢"
L["The Obsidian Sanctum"] = "黑曜聖所"
L["The Oculus"] = "奧核之眼"
L["The Old Kingdom"] = "古王國"
L["The Pit of Saron"] = "薩倫之淵"
L["The Ruby Sanctum"] = "晶紅聖所"
L["The Sepulcher"] = "瑟伯切爾"
L["The Shadow Vault"] = "影牢"
L["The Shattered Halls"] = "破碎大廳"
L["The Stockade"] = "監獄"
L["The Storm Peaks"] = "風暴群山"
L["The Stormspire"] = "風暴之尖"
L["The Talondeep Path"] = "鷹巢小徑"
L["The Vault of Lights"] = "光之聖匣"
L["The Violet Hold"] = "紫羅蘭堡"
L["The Zoram Strand"] = "佐拉姆海灘"
L["Thelsamar"] = "塞爾薩瑪"
L["Theramore Isle"] = "賽拉摩島"
L["Thorium Point"] = "瑟銀哨站"
L["Thousand Needles"] = "千針石林"
L["Thrallmar"] = "索爾瑪"
L["Thunder Bluff"] = "雷霆崖"
L["Thunderlord Stronghold"] = "雷霆王要塞"
L["Timbermaw Hold"] = "木喉要塞"
L["Tinker Town"] = "地精區"
L["Tint unexplored areas"] = "未探索區域色調"
L["Tirisfal Glades"] = "提瑞斯法林地"
L["Toggle panel"] = "切換面板"
L["Toshley's Station"] = "托斯利基地"
L["Trade District"] = "貿易區"
L["Trade Quarter"] = "貿易區"
L["Tram to"] = "地鐵到"
L["Tranquillien"] = "安寧地"
L["Transitus Shield"] = "轉移之盾"
L["Transparency"] = "透明度"
L["Trial of the Champion"] = "勇士試煉"
L["Trial of the Crusader"] = "十字軍的試煉"
L["Twilight Shore"] = "暮光海岸"
L["Twilight Vale"] = "暮光谷"
L["Uldaman"] = "奧達曼"
L["Uldaman (side entrance)"] = "奧達曼（側面入口）"
L["Ulduar"] = "奧杜亞"
L["Underbog"] = "深幽泥沼"
L["Undercity"] = "幽暗城"
L["Un'Goro Crater"] = "安戈落環形山"
L["Unlock battlefield map"] = "解鎖戰場地圖"
L["Unlock map frame"] = "解鎖地圖框架"
L["Unu'pe"] = "烏努佩"
L["Upper Blackrock Spire"] = "黑石塔上層"
L["Use default map"] = "使用預設地圖"
L["Use stationary opacity while pointing at map"] = "指向地圖時使用固定的透明度"
L["Utgarde Keep"] = "守望堡"
L["Utgarde Pinnacle"] = "守望堡尖塔"
L["Valaar's Berth"] = "瓦拉船台"
L["Valgarde"] = "瓦加德"
L["Valgarde Port"] = "瓦加德港口"
L["Valiance Keep"] = "驍勇堡"
L["Valiance Landing Camp"] = "勇氣臨港營地"
L["Valley of Strength"] = "力量之谷"
L["Valormok"] = "菲歐莫克"
L["Vault of Archavon"] = "亞夏梵穹殿"
L["Vengeance Landing"] = "復仇臨港"
L["Venomspite"] = "毒害之地"
L["Version"] = "版本"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Warsong Camp"] = "戰歌營地"
L["Warsong Hold"] = "戰歌堡"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Westfall Brigade"] = "西荒兵團"
L["Westguard Keep"] = "西衛要塞"
L["Wetlands"] = "濕地"
L["Wildhammer Stronghold"] = "蠻錘要塞"
L["Windrunner's Overlook"] = "風行者的瞭望台"
L["Wintergarde Keep"] = "寒冰堡"
L["Wintergrasp"] = "冬之握"
L["Winterspring"] = "冬泉谷"
L["Wrath of the Lich King Classic"] = "巫妖王之怒經典版"
L["Wyrmrest Temple"] = "龍眠神殿"
L["You will die!"] = "你將死亡！"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "您的UI需要重載以讓某些更動生效。|n|n您不用立刻點擊重載按鈕，但當您做了些更動並想要更動生效的話，需要馬上重載。"
L["Your UI needs to be reloaded."] = "您的UI需要重載。"
L["Zabra'jin"] = "薩布拉金"
L["Zangarmarsh"] = "贊格沼澤"
L["Zeb'Sora"] = "澤布索拉"
L["Zeppelin to"] = "飛船到"
L["Zim'Torga"] = "辛托爾加"
L["Zone Map"] = "區域地圖"
L["Zoom"] = "縮放"
L["Zoram'gar Outpost"] = "佐拉姆加前哨站"
L["Zul'Aman"] = "祖阿曼"
L["Zul'Drak"] = "祖爾德拉克"
L["Zul'Farrak"] = "祖爾法拉克"
L["Zul'Gurub"] = "祖爾格拉布"

end

-- ruRU: Russian
if GameLocale == "ruRU" then
L["(destination only)"] = "(только пункт назначения)"
L["(inside Caverns of Time)"] = "(внутри Пещер Времени)"
L["/ltm help - Show this information."] = "/ltm help - Показать эту информацию."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Сбросить положение панели."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Удалить все настройки и перезагрузить."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Возникла ошибка, но не беспокойтесь. Такое бывает время от времени. Перезагрузите интерфейс, чтобы исправить её."
L["A stop error has occurred but no need to worry. It can happen from time to time. Click the reload button to resolve it."] = "Возникла ошибка, но не беспокойтесь. Такое бывает время от времени. Перезагрузите интерфейс, чтобы исправить её."
L["Acherus: The Ebon Hold"] = "Акерус: Черный оплот"
L["Aerie Peak"] = "Заоблачный пик"
L["Agmar's Hammer"] = "Молот Агмара"
L["Ahn'Qiraj"] = "Ан'Кираж"
L["Aldor"] = "Алдоры"
L["Allerian Stronghold"] = "Бастион Аллерии"
L["Alliance Cities"] = "Города Альянса"
L["Alpha"] = "Альфа"
L["Altar of Sha'tar"] = "Алтарь Ша'тар"
L["Alterac Mountains"] = "Альтеракские горы"
L["Always"] = "Всегда"
L["Amber Lodge"] = "Янтарная гряда"
L["Amberpine Lodge"] = "Приют Янтарной Сосны"
L["Apothecary Camp"] = "Аптекарский поселок"
L["Appearance"] = "Внешний вид"
L["Arathi Highlands"] = "Нагорье Арати"
L["Area 52"] = "Зона 52"
L["Argent Tournament Grounds"] = "Ристалище Серебряного турнира"
L["Ashenvale"] = "Ясеневый лес"
L["Astranaar"] = "Астранаар"
L["Auberdine"] = "Аубердин"
L["Auchenai Crypts"] = "Аукенайские гробницы"
L["Auto change zones"] = "Авто-смена зоны"
L["Azeroth"] = "Азерот"
L["Azjol-Nerub"] = "Азжол-Неруб"
L["Azshara"] = "Азшара"
L["Azuremyst Isle"] = "Остров Лазурной Дымки"
L["Back to Main Menu"] = "В главное меню"
L["Badlands"] = "Бесплодные земли"
L["Battlegrounds"] = "Поля боя"
L["Black Morass"] = "Черные топи"
L["Black Temple"] = "Черный храм"
L["Blackfathom Deeps"] = "Непроглядная Пучина"
L["Blackrock Depths"] = "Глубины Черной горы"
L["Blackrock Mountain"] = "Черная гора"
L["Blackwing Lair"] = "Логово Крыла Тьмы"
L["Blade Tooth Canyon"] = "Каньон Острого Зуба"
L["Blade's Edge Mountains"] = "Острогорье"
L["Blades' Run"] = "Скалистая тропа"
L["Blasted Lands"] = "Выжженные земли"
L["Blood Watch"] = "Кровавая застава"
L["Bloodmyst Isle"] = "Остров Кровавой Дымки"
L["Bloodvenom Post"] = "Застава Отравленной Крови"
L["Blue"] = "Синий"
L["Boat to"] = "Корабль в"
L["Booty Bay"] = "Пиратская Бухта"
L["Borean Tundra"] = "Борейская тундра"
L["Bor'gorok Outpost"] = "Застава Бор'горока"
L["Bouldercrag's Refuge"] = "Приют Глыбоскала"
L["Brackenwall Village"] = "Деревня Гиблотопь"
L["Burning Crusade Classic"] = "Burning Crusade Classic"
L["Burning Steppes"] = "Пылающие степи"
L["Camp Mojache"] = "Лагерь Мохаче"
L["Camp Oneqwah"] = "Лагерь Уанква"
L["Camp Taurajo"] = "Лагерь Таурахо"
L["Camp Tunka'lo"] = "Лагерь Тунка'ло"
L["Camp Winterhoof"] = "Лагерь Заиндевевшего Копыта"
L["Caverns of Time"] = "Пещеры Времени"
L["Cenarion Hold"] = "Крепость Кенария"
L["Center map on player"] = "Центрировать по игроку"
L["Central Mesa"] = "Центральная меза"
L["Chillwind Camp"] = "Лагерь Промозглого Ветра"
L["Choose where the zone map should be shown."] = "Выберите, где должна отображаться карта зоны."
L["Class colored icons"] = "Классовые цветные значки"
L["Classic"] = "Классик"
L["Click to configure the settings for this option."] = "Нажмите, чтобы перейти к интерфейсу дополнительных параметров этой настройки."
L["Click to reset the position and scale of the map frame."] = "Нажмите, чтобы сбросить положение и масштаб окна карты."
L["Click to reset the settings on this page."] = "Нажмите, чтобы сбросить настройки на этой странице."
L["Click to return to the main menu."] = "Нажмите, чтобы вернуться в главное меню."
L["Coilfang Reservoir"] = "Резервуар Кривого Клыка"
L["Coldarra"] = "Хладарра"
L["Configuration Panel"] = "Панель настроек"
L["Conquest Hold"] = "Крепость Завоевателей"
L["Cosmic"] = "Космос"
L["Cosmowrench"] = "Космоворот"
L["Crusaders' Pinnacle"] = "Вершина Рыцарей"
L["Crystalsong Forest"] = "Лес Хрустальной Песни"
L["Culling of Stratholme"] = "Очищение Стратхольма"
L["Cursor"] = "Курсор"
L["Dalaran"] = "Даларан"
L["Dalaran Crater"] = "Даларанский кратер"
L["Darkshire"] = "Темнолесье"
L["Darkshore"] = "Темные берега"
L["Darnassus"] = "Дарнас"
L["Deadwind Pass"] = "Перевал Мертвого Ветра"
L["Death's Rise"] = "Уступ Смерти"
L["Desolace"] = "Пустоши"
L["Dire Maul (East)"] = "Забытый Город (Восток)"
L["Dire Maul (East) (side entrance)"] = "Забытый Город (Восток) (боковой вход)"
L["Dire Maul (North)"] = "Забытый Город (Север)"
L["Dire Maul (West)"] = "Забытый Город (Запад)"
L["Disable reading emote when opening the map"] = "Отключить эмоцию открытия карты"
L["Drag"] = "Переместить"
L["Drag to set the amount of blue."] = "Переместите ползунок влево или вправо, чтобы установить уровень синего цвета."
L["Drag to set the amount of green."] = "Переместите ползунок влево или вправо, чтобы установить уровень зеленого цвета."
L["Drag to set the amount of red."] = "Переместите ползунок влево или вправо, чтобы установить уровень красного цвета."
L["Drag to set the battlefield map opacity."] = "Переместите ползунок влево или вправо, чтобы установить прозрачность карты поля боя."
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "Переместите ползунок влево или вправо, чтобы установить размер карты поля боя.|n|nЕсли карта разблокирована, вы также можете изменить размер карты, потянув за её правый нижний угол."
L["Drag to set the group icon size."] = "Переместите ползунок влево или вправо, чтобы установить размер значка."
L["Drag to set the map opacity for when your character is moving."] = "Переместите ползунок влево или вправо, чтобы установить прозрачность карты, когда ваш персонаж находится в движении."
L["Drag to set the map opacity for when your character is stationary."] = "Переместите ползунок влево или вправо, чтобы установить непрозрачность карты, когда ваш персонаж неподвижен."
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "Переместите ползунок влево или вправо, чтобы установить максимальный уровень приближения (масштабирования) карты в процентах.|n|nОткройте карту поля боя, чтобы увидеть изменение в уровне максимального приближения при перемещении ползунка."
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "Переместите ползунок влево или вправо, чтобы установить максимальный уровень приближения (масштабирования) карты в процентах.|n|nОткройте карту мира, чтобы увидеть изменение в уровне максимального приближения при перемещении ползунка."
L["Drag to set the opacity."] = "Переместите ползунок влево или вправо, чтобы установить уровень прозрачности."
L["Drag to set the player arrow size."] = "Переместите ползунок влево или вправо, чтобы установить размер стрелки игрока."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Переместите ползунок влево или вправо, чтобы установить желаемый размер указателя вашего персонажа.|n|nClassic по умолчанию 16 .|nАктуальная версия по умолчанию - 27."
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "Переместите ползунок влево или вправо, чтобы установить становить масштаб карты мира.|n|nМожно также изменить масштаб карты мира, перетаскивая нижний правый угол."
L["Dragonblight"] = "Драконий Погост"
L["Drak'Tharon Keep"] = "Крепость Драк'Тарон"
L["Druid only flight point to Darnassus"] = "Пункт перелета в Дарнас (только для Друида)"
L["Druid only flight point to Thunder Bluff"] = "Пункт перелета в Громовой Утес (только для Друида)"
L["Dun Algaz"] = "Дун Альгаз"
L["Dun Morogh"] = "Дун Морог"
L["Dun Nifflelem"] = "Дун Ниффелем"
L["Dungeon"] = "Подземелье"
L["Dungeon (requires Crescent Key)"] = "Подземелье (требуется Серповидный ключ)"
L["Durotar"] = "Дуротар"
L["Duskwood"] = "Сумеречный лес"
L["Dustwallow Marsh"] = "Пылевые топи"
L["Dwarven District"] = "Подземный поезд"
L["Eastern Plaguelands"] = "Восточные Чумные земли"
L["Ebon Watch"] = "Черная застава"
L["Elements"] = "Элементы"
L["Elwynn Forest"] = "Элвиннский лес"
L["Emerald Sanctuary"] = "Изумрудное святилище"
L["Enhance battlefield map"] = "Улучшить карту поля боя"
L["Enlarge player arrow"] = "Размер указателя игрока"
L["Enter"] = "Введите"
L["Evergrove"] = "Вечная роща"
L["Everlook"] = "Круговзор"
L["Eversong Woods"] = "Леса Вечной Песни"
L["Exodar"] = "Экзодар"
L["Falcon Watch"] = "Соколиный Дозор"
L["Feathermoon Stronghold"] = "Крепость Оперенной Луны"
L["Felwood"] = "Оскверненный лес"
L["Feralas"] = "Фералас"
L["Fishing"] = "Рыбалка"
L["Fizzcrank Airstrip"] = " Взлетная полоса Выкрутеня"
L["Flame Crest"] = "Пламенеющий Стяг"
L["Fordragon Hold"] = "Крепость Фордрагона"
L["Forest Song"] = "Лесная Песнь"
L["Fort Wildervar"] = " Крепость Вилдервар"
L["Freewind Post"] = "Застава Вольного Ветра"
L["Frosthold"] = "Ледяная крепость"
L["Gadgetzan"] = "Прибамбасск"
L["Garadar"] = "Гарадар"
L["Ghostlands"] = "Призрачные земли"
L["Gnomeregan"] = "Гномреган"
L["Green"] = "Зеленый"
L["Grizzly Hills"] = "Седые холмы"
L["Grom'arsh Crash Site"] = "Место крушения Гром'арша"
L["Grom'gol Base Camp"] = "Гром'гол"
L["Group Icons"] = "Значки Группы"
L["Gruul's Lair"] = "Логово Груула"
L["Gundrak"] = "Гундрак"
L["Gundrak (rear entrance)"] = "Гундрак (задний вход)"
L["Halls of Lightning"] = "Чертоги Молний"
L["Halls of Stone"] = "Чертоги Камня"
L["Hammerfall"] = "Павший Молот"
L["Head down the mountain from here."] = "Спуститесь с горы отсюда."
L["Head southeast from here and go up the mountain."] = "Направляйтесь отсюда на юго-восток и поднимитесь на гору."
L["Hellfire Peninsula"] = "Полуостров Адского Пламени"
L["Hellfire Ramparts"] = "Бастионы Адского Пламени"
L["Hide town and city icons"] = "Скрыть значки городов"
L["Hillsbrad Foothills"] = "Предгорья Хилсбрада"
L["Honor Hold"] = "Оплот Чести"
L["Horde Cities"] = "Города Орды"
L["Howling Fjord"] = "Ревущий фьорд"
L["Hyjal Summit"] = "Вершина Хиджала"
L["Icecrown"] = "Ледяная Корона"
L["Icecrown Citadel"] = "Цитадель Ледяной Короны"
L["Icons"] = "Иконки"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "Если установлен этот флажок, на карте будут отмечаться порты и их направления, башни дирижаблей и их направления, а также входы в подземный поезд."
L["If checked, coordinates will be shown."] = "Если установлен этот флажок, на карте будут отображаться координаты."
L["If checked, dungeons and raids will be shown."] = "Если установлен этот флажок, на карте будут отображаться входы в подземелья и рейдовые подземелья."
L["If checked, group icons will use a modern, class-colored design."] = "Если установлен этот флажок, то значки места нахождения участников вашей группы на карте - будут отображаться цветом класса этих персонажей."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Если установлен этот флажок, то при открытии карты будет использоваться тот же уровень масштабирования, что и при последнем закрытии карты, если зона карты не изменилась."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Если установлен этот флажок, то при наведении курсора мыши на карту во время движения вашего персонажа отменит установленный уровень прозрачности. Карта станет непрозрачной."
L["If checked, points of interest will be shown."] = "Если установлен этот флажок, на карте будут отображаться различные полезные достопримечательности."
L["If checked, quest objectives will be shown."] = "Если флажок установлен, то будут показаны цели квеста."
L["If checked, spirit healers will be shown."] = "Если флажок установлен, то будут отображаться духовные целители."
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Если флажок установлен, карта поля боя будет оставаться отцентрированной по вашему местоположению, пока вы не находитесь в подземелье.|n|nВы можете удерживать shift при панорамировании карты, чтобы временно предотвратить ее центрирование."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Если установлен этот флажок, всегда будет использоваться по умолчанию карта открываемая на весь экран.|n|nПримечание: Включение данной настройки заблокирует некоторые другие."
L["If checked, the map border will be removed."] = "Если установлен этот флажок, граница окна карты будет удалена."
L["If checked, the map frame will remain open until you close it."] = "Если установлен этот флажок, окно карты будет всегда оставаться открытым до тех пор, пока вы сами не закроете его."
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Если флажок установлен, карта будет оставаться отцентрированной по вашему местоположению, пока вы не находитесь в подземелье.|n|nВы можете удерживать shift при панорамировании карты, чтобы временно предотвратить ее центрирование."
L["If checked, the minimap button will be shown."] = "Если установлен этот флажок, у мини-карты будет отображаться кнопка аддона."
L["If checked, the minimum fishing skill levels will be shown."] = "Если установлен этот флажок, будут показаны минимальные уровни навыка рыбной ловли."
L["If checked, town and city icons will not be shown on the continent maps."] = "Если установлен этот флажок, на картах континентов не будут отображаться значки городов и поселков."
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Если установлен этот флажок, то будут отображаться все путевые точки для персонажей противоположной фракции.|n|nСюда входят точки полета, лодочные гавани, башни дирижаблей и трамвайные остановки."
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Если установлен этот флажок, то будут отображаться все путевые точки для персонажей вашей фракции.|n|nСюда входят точки полета, лодочные гавани, башни дирижаблей и трамвайные остановки."
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "Если установлен этот флажок, то неисследованные области на карте мира и на карте поля - будут открыты (будут отображаться без дымки)."
L["If checked, unexplored areas will be tinted."] = "Если установлен этот флажок, неисследованные области будут отображаться на карте, но будут отдельно затемнены."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Если установлен этот флажок, то когда ваш персонаж будет переходить из одной зоны в другую, карта будет автоматически меняться, чтобы показывать всегда актуальную местность нахождения вашего персонажа."
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "Если установлен этот флажок, вы можете перемещать карту поля боя, перетаскивая любую из ее границ.|n|nВы можете изменять размер карты поля боя, перетаскивая правый нижний угол."
L["If checked, you will be able to customise the battlefield map."] = "Если установлен этот флажок, вы сможете настраивать карту поля боя"
L["If checked, you will be able to enlarge the player arrow."] = "Если установлен этот флажок, вы сможете установить размер указателя (стрелки), которым обозначается расположение вашего персонажа на карте."
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "Если флажок установлен, вы сможете масштабировать карту, перетаскивая ручку масштаба в правом нижнем углу.|n|nВы сможете перемещать карту, перетаскивая любую границу.|n|nВы всегда можете перетащить верхнюю границу для перемещения карты независимо от этого параметра."
L["If checked, you will be able to set the opacity of the map."] = "Если установлен этот флажок, у вас появится возможность изменять прозрачность карты."
L["If checked, you will be able to zoom further into the world map."] = "Если установлен этот флажок, вы сможете сильнее масштабировать карту мира."
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "Если установлен этот флажок, выпадающие меню зон и континентов будут отображаться в окне карты."
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "Если флажок установлен, будут показаны пересечения зон.|n|nЭто стрелки, по которым можно выполнить щелчок мышью, указывают пути выхода из зоны."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Если установлен этот флажок, на карте будут отображаться зоны, подземелья и минимальный необходимый уровень рыбной ловли."
L["Increase zoom level"] = "Уровень масштабирования"
L["Invalid command.  Enter /ltm help for help."] = "Неверная команда. Введите /ltm help для помощи."
L["Invalid command. Enter /ltm help for help."] = "Неверная команда. Введите /ltm help для помощи."
L["Invalid map ID."] = "Неверный ID карты"
L["Ironforge"] = "Стальгорн"
L["Isle of Quel'Danas"] = "Остров Кель'Данас"
L["K3"] = "K-3"
L["Kamagua"] = "Камагуа"
L["Karazhan"] = "Каражан"
L["Kargath"] = "Каргат"
L["Kor'kron Vanguard"] = "Авангард кор'крона"
L["Lake Elune'ara"] = "Озеро Элуне'ара"
L["Lake Everstill"] = "Озеро Безмолвия"
L["Large Scarab Coffer"] = "Большой сундук Скарабея"
L["Leads to Tirisfal Glades"] = "Ведёт в Тирисфальские леса"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: УСТАНОВЛЕНА НЕПРАВИЛЬНАЯ ВЕРСИЯ!"
L["Light's Breach"] = "Разлом Света"
L["Light's Hope Chapel"] = "Часовня Последней Надежды"
L["Loch Modan"] = "Лок Модан"
L["Lower Blackrock Spire"] = "Нижняя часть пика Черной горы"
L["Magisters' Terrace"] = "Терраса Магистров"
L["Magtheridon's Lair"] = "Логово Магтеридона"
L["Mana-Tombs"] = "Гробницы Маны"
L["Map frame scale"] = "Масштабирование карты"
L["Map Opacity"] = "Прозрачность карты"
L["Map Scale"] = "Размер карты"
L["Map Size"] = "Размер карты"
L["MapScale"] = "Размер карты"
L["Maraudon"] = "Мародон"
L["Marshal's Refuge"] = "Укрытие Маршалла"
L["Max Zoom"] = "Приближение"
L["Maximum"] = "Максимум"
L["Mechanics"] = "Механика"
L["Memory Usage"] = "Использование памяти"
L["Menethil Harbor"] = "Гавань Менетилов"
L["Miscellaneous"] = "Прочее"
L["Moa'ki"] = "Моа'ки"
L["Moa'ki Harbor"] = "Гавань Моа'ки"
L["Mok'Nathal Village"] = "Деревня Мок'Натал"
L["Molten Core"] = "Огненные Недра"
L["Moonglade"] = "Лунная поляна"
L["More"] = "Больше"
L["Morgan's Vigil"] = "Дозор Морганы"
L["Moving"] = "В движении"
L["Mudsprocket"] = "Шестермуть"
L["Mulgore"] = "Мулгор"
L["Nagrand"] = "Награнд"
L["Naxxramas"] = "Наксрамас"
L["Nesingwary Base Camp"] = "Лагерь Эрнестуэя"
L["Nethergarde Keep"] = "Крепость Стражей Пустоты"
L["Netherstorm"] = "Пустоверть"
L["Never"] = "Никогда"
L["New Agamand"] = "Новый Агамонд"
L["Nighthaven"] = "Ночная Гавань"
L["Nijel's Point"] = "Высота Найджела"
L["North"] = "Север"
L["North Gate Pass"] = "Перевал Северных врат"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "ВНИМАНИЕ! Вы должны полностью перезапустить свой игровой клиент, прежде чем использовать эту версию Leatrix Maps."
L["Old Hillsbrad"] = "Старый Хилсбрад"
L["Old Hillsbrad Foothills"] = "Старые предгорья Хилсбрада"
L["Onyxia's Lair"] = "Логово Ониксии"
L["Opacity"] = "Затемнение"
L["or click the minimap button to open Leatrix Maps."] = "или нажмите на кнопку у миникарты для открытия окна Leatrix Maps."
L["Orb of Translocation"] = "Шар транслокации"
L["Orebor Harborage"] = "Прибежище Оребор"
L["Orgrimmar"] = "Оргриммар"
L["Player"] = "Персонаж"
L["Player Arrow"] = "Указатель"
L["Portal"] = "Портал"
L["Portal from Zephyr"] = "Портал от Зефир"
L["Portals"] = "Порталы"
L["Preview"] = "Превью"
L["Ragefire Chasm"] = "Огненная Пропасть"
L["Raid"] = "Рейд"
L["Ratchet"] = "Кабестан"
L["Ravenholdt Manor"] = "Поместье Черный Ворон"
L["Razorfen Downs"] = "Курганы Иглошкурых"
L["Razorfen Kraul"] = "Лабиринты Иглошкурых"
L["Razorthorn Trail"] = "Дорога Острого Шипа"
L["Rebel Camp"] = "Лагерь повстанцев"
L["Red"] = "Красный"
L["Redridge Mountains"] = "Красногорье"
L["Refuge Pointe"] = "Опорный пункт"
L["Reload"] = "Перезагрузка"
L["Remember zoom level"] = "Запоминать масштаб"
L["Remove map border"] = "Убрать границы карты"
L["req"] = "Требует"
L["Requires Key to Searing Gorge"] = "Требуется ключ к Тлеющему ущелью"
L["Requires UI reload."] = "Требуется перезагрузка UI"
L["Reset"] = "Сброс настроек"
L["Reset Map Layout"] = "Сброс настроек"
L["Revantusk Village"] = "Деревня Сломанного Клыка"
L["River's Heart"] = "Слияние рек"
L["Ruins of Ahn'Qiraj"] = "Руины Ан'Киража"
L["Ruins of Elune'eth"] = "Руины Элун'ета"
L["Rut'theran Village"] = "Деревня Рут'теран"
L["Rut'Theran Village"] = "Деревня Рут'теран"
L["Sanctum of the Stars"] = "Святилище звезд"
L["Scale"] = "Масштаб"
L["Scarlet Monastery"] = "Монастырь Алого ордена"
L["Scholomance"] = "Некроситет"
L["Searing Gorge"] = "Тлеющее ущелье"
L["Seat of the Naaru"] = "Трон Наару"
L["Sentinel Hill"] = "Сторожевой холм"
L["Serpentshrine Cavern"] = "Змеиное святилище"
L["Set map opacity"] = "Прозрачность карты"
L["Set map opacity while stationary and while moving."] = "Настройка прозрачности карты для двух различных состояний:|nкогда вы стоите и когда вы движетесь."
L["Set the group icon size."] = "Установите размер значка, которым следует отображать|nучастник вашей группы на карте."
L["Set the maximum zoom scale."] = "Установите максимально допустимый уровень приближения карты"
L["Set the player arrow size."] = "Установите желаемый размер указателя (стрелки), которым|nобозначается расположение вашего персонажа на карте."
L["Sethekk Halls"] = "Сетеккские залы"
L["Settings"] = "Настройки"
L["Sewers"] = "Канализация"
L["Shadow Labyrinth"] = "Темный лабиринт"
L["Shadowfang Keep"] = "Крепость Темного Клыка"
L["Shadowmoon Valley"] = "Долина Призрачной Луны"
L["Shadowmoon Village"] = "Деревня Призрачной Луны"
L["Shadowprey Village"] = "Деревня Ночных Охотников"
L["Shatter Point"] = "Парящая застава"
L["Shattrath"] = "Шаттрат"
L["Shattrath City"] = "Шаттрат"
L["Sholazar Basin"] = "Низина Шолазар"
L["Show boats, zeppelins and trams"] = "Отмечать на карте порты, башни дирижаблей и подземный поезд"
L["Show coordinates"] = "Показать координаты"
L["Show dungeons and raids"] = "Отмечать на карте входы в подземелья и рейдовые подземелья"
L["Show minimap button"] = "Кнопка у миникарты"
L["Show minimum fishing skill levels"] = "Показать минимальный уровень рыбной ловли"
L["Show objectives"] = "Показать задачи"
L["Show points of interest"] = "Показать достопримечательности"
L["Show scale handle"] = "Показать шкалу масштабирования"
L["Show spirit healers"] = "Показывать духовных целителей"
L["Show travel points for opposing faction"] = "Путевые точки противоположной фракции"
L["Show travel points for same faction"] = "Путевые точки вашей фракции"
L["Show unexplored areas"] = "Показать неисследованные области"
L["Show zone crossings"] = "Показывать переходы зон"
L["Show zone levels"] = "Показать уровни локаций"
L["Show zone menus"] = "Показать меню зон"
L["Silithus"] = "Силитус"
L["Silvermoon"] = "Луносвет"
L["Silvermoon City"] = "Луносвет"
L["Silverpine Forest"] = "Серебряный бор"
L["Slave Pens"] = "Узилище"
L["South"] = "Юг"
L["South Gate Pass"] = "Перевал Южных врат"
L["Southfury River"] = "Река Строптивая"
L["Southshore"] = "Южнобережье"
L["Spinebreaker Ridge"] = "Гребень Хребтолома"
L["Spirit Healer"] = "Духовный целитель"
L["Splintertree Post"] = "Застава Расщепленного Дерева"
L["Stars' Rest"] = "Покой Звезд"
L["Stationary"] = "В покое"
L["Steamvault"] = "Паровое подземелье"
L["Sticky map frame"] = "Закрепить окно карты"
L["Stonard"] = "Каменор"
L["Stonebreaker Hold"] = "Форт Камнеломов"
L["Stonetalon Mountains"] = "Когтистые горы"
L["Stonetalon Peak"] = "Пик Каменного Когтя"
L["Stormwind"] = "Штормград"
L["Stormwind City"] = "Штормград"
L["Stranglethorn Vale"] = "Тернистая долина"
L["Stratholme (Main Gate)"] = "Стратхольм (Главные ворота)"
L["Stratholme (Service Gate)"] = "Стратхольм (Сервисные ворота)"
L["sum"] = "вызывать"
L["Sun Rock Retreat"] = "Приют у Солнечного Камня"
L["Sunreaver's Command"] = "Лагерь Похитителя Солнца"
L["Sun's Reach Harbor"] = "Гавань Солнечного Края"
L["Sunwell Plateau"] = "Плато Солнечного Колодца"
L["Swamp of Sorrows"] = "Болото Печали"
L["Swamprat Post"] = "Застава Болотной Крысы"
L["Sylvanaar"] = "Сильванаар"
L["System"] = "Системное"
L["Talonbranch Glade"] = "Поляна Когтистых Ветвей"
L["Talrendis Point"] = "Застава Талрендис"
L["Tanaris"] = "Танарис"
L["Tarren Mill"] = "Мельница Таррен"
L["Taunka'le Village"] = "Деревня Таунка'ле"
L["Telaar"] = "Телаар"
L["Teldrassil"] = "Тельдрассил"
L["Teleport Crystal"] = "Кристалл телепортации"
L["Telredor"] = "Телредор"
L["Tempest Keep"] = "Крепость Бурь"
L["Temple of Ahn'Qiraj"] = "Храм Ан'Кираж"
L["Temple of Atal'Hakkar"] = "Затонувший храм"
L["Temple of Telhamat"] = "Храм Телхамата"
L["Terokkar Forest"] = "Лес Тероккар"
L["Thalanaar"] = "Таланаар"
L["Thandol Span"] = "Мост Тандола"
L["The Arcatraz"] = "Аркатрац"
L["The Argent Stand"] = "Серебряная застава"
L["The Argent Vanguard"] = "Оплот Серебряного Авангарда"
L["The Barrens"] = "Степи"
L["The Blood Furnace"] = "Кузня Крови"
L["The Botanica"] = "Ботаника"
L["The Bulwark"] = "Бастион"
L["The Crossroads"] = "Перекресток"
L["The Dark Portal"] = "Темный портал"
L["The Deadmines"] = "Мертвые копи"
L["The Exodar"] = "Экзодар"
L["The Eye"] = "Око"
L["The Eye of Eternity"] = "Око Вечности"
L["The Forge of Souls"] = "Кузня Душ"
L["The Forgotten Coast"] = "Забытый берег"
L["The Frozen Halls"] = "Ледяные залы"
L["The Great Forge"] = "Великая Кузня"
L["The Great Lift"] = "Великий подъемник"
L["The Halls of Reflection"] = "Залы Отражений"
L["The Hinterlands"] = "Внутренние земли"
L["The Mechanar"] = "Механар"
L["The Nexus"] = "Нексус"
L["The Obsidian Sanctum"] = "Обсидиановое святилище"
L["The Oculus"] = "Окулус"
L["The Old Kingdom"] = "Старое Королевство"
L["The Pit of Saron"] = "Яма Сарона"
L["The Ruby Sanctum"] = "Рубиновое святилище"
L["The Sepulcher"] = "Гробница"
L["The Shadow Vault"] = "Мрачный Свод"
L["The Shattered Halls"] = "Разрушенные залы"
L["The Stockade"] = "Тюрьма"
L["The Storm Peaks"] = "Грозовая Гряда"
L["The Stormspire"] = "Штормовая вершина"
L["The Talondeep Path"] = "Тоннель Когтя"
L["The Vault of Lights"] = "Чертог Света"
L["The Violet Hold"] = "Аметистовая крепость"
L["The Zoram Strand"] = "Зорамское взморье"
L["Thelsamar"] = "Телcамар"
L["Theramore Isle"] = "Остров Терамор"
L["Thorium Point"] = "Лагерь Братства Тория"
L["Thousand Needles"] = "Тысяча Игл"
L["Thrallmar"] = "Траллмар"
L["Thunder Bluff"] = "Громовой Утес"
L["Thunderlord Stronghold"] = "Оплот громоборцев"
L["Timbermaw Hold"] = "Крепость Древобрюхов"
L["Tinker Town"] = "Город механиков"
L["Tint unexplored areas"] = "Цвет неразведанных участков"
L["Tirisfal Glades"] = "Тирисфальские леса"
L["Toggle panel"] = "Панель переключения"
L["Toshley's Station"] = "Станция Тошли"
L["Trade District"] = "Торговый квартал"
L["Trade Quarter"] = "Торговый квартал"
L["Tram to"] = "Поезд в"
L["Tranquillien"] = "Транквиллион"
L["Transitus Shield"] = "Маскировочный щит"
L["Transparency"] = "Прозрачность"
L["Trial of the Champion"] = "Испытание чемпиона"
L["Trial of the Crusader"] = "Испытание крестоносца"
L["Twilight Shore"] = "Сумрачная Излучина"
L["Twilight Vale"] = "Сумеречная долина"
L["Uldaman"] = "Ульдаман"
L["Uldaman (side entrance)"] = "Ульдаман (боковой вход)"
L["Ulduar"] = "Ульдуар"
L["Underbog"] = "Нижетопь"
L["Undercity"] = "Подгород"
L["Un'Goro Crater"] = "Кратер Ун'Горо"
L["Unlock battlefield map"] = "Разблокировать карту поля боя"
L["Unlock map frame"] = "Открепить окно карты"
L["Unu'pe"] = "Уну'пе"
L["Upper Blackrock Spire"] = "Верхняя часть пика Черной горы"
L["Use default map"] = "Карта на весь экран"
L["Use stationary opacity while pointing at map"] = "Карта всегда непрозрачна если над ней курсор"
L["Utgarde Keep"] = "Крепость Утгард"
L["Utgarde Pinnacle"] = "Вершина Утгард"
L["Valaar's Berth"] = "Причал Валаара"
L["Valgarde"] = "Валгард"
L["Valgarde Port"] = "Валгардский порт"
L["Valiance Keep"] = "Крепость Отваг"
L["Valiance Landing Camp"] = "Лагерь Отваги"
L["Valley of Strength"] = "Аллея Силы"
L["Valormok"] = "Храбростан"
L["Vault of Archavon"] = "Склеп Аркавона"
L["Vengeance Landing"] = "Лагерь Возмездия"
L["Venomspite"] = "Ядозлобь"
L["Version"] = "Версия"
L["Wailing Caverns"] = "Пещеры Стенаний"
L["Warsong Camp"] = "Лагерь Песни Войны"
L["Warsong Hold"] = "Крепость Песни Войны"
L["Western Plaguelands"] = "Западные Чумные земли"
L["Westfall"] = "Западный Край"
L["Westfall Brigade"] = "Дружина Западного Края"
L["Westguard Keep"] = "Крепость Западной Стражи"
L["Wetlands"] = "Болотина"
L["Wildhammer Stronghold"] = "Цитадель Громового Молота"
L["Windrunner's Overlook"] = "Дозор Ветрокрылой"
L["Wintergarde Keep"] = "Крепость Стражей Зимы"
L["Wintergrasp"] = "Озеро Ледяных Оков"
L["Winterspring"] = "Зимние Ключи"
L["Wrath of the Lich King Classic"] = "Wrath of the Lich King Classic"
L["Wyrmrest Temple"] = "Храм Драконьего Покоя"
L["You will die!"] = "Вы умрёте!"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Чтобы некоторые изменения вступили в силу, необходимо перезагрузить Ваш пользовательский интерфейс|n|nНе требуется нажимать кнопку перезагрузки интерфейса сразу после каждого изменения, но её потребуется нажать тогда, когда вы закончите вносить все изменения и захотите, чтобы они вступили в силу."
L["Your UI needs to be reloaded."] = "Вам необходимо перезагрузить UI."
L["Zabra'jin"] = "Забра'джин"
L["Zangarmarsh"] = "Зангартопь"
L["Zeb'Sora"] = "Зеб'Сора"
L["Zeppelin to"] = "Дирижабль в"
L["Zim'Torga"] = "Зим'Торга"
L["Zone Map"] = "Карта зоны"
L["Zoom"] = "Масштабирование"
L["Zoram'gar Outpost"] = "Застава Зорам'гар"
L["Zul'Aman"] = "Зул'Аман"
L["Zul'Drak"] = "Зул'Драк"
L["Zul'Farrak"] = "Зул'Фаррак"
L["Zul'Gurub"] = "Зул'Гуруб"

end

-- koKR: Korean
if GameLocale == "koKR" then
L["(destination only)"] = " (목적지만）"
L["(inside Caverns of Time)"] = "（시간의 동굴 내부）"
L["/ltm help - Show this information."] = "/ltm help - 정보 표시."
L["/ltm reset - Reset the panel position."] = "/ltm reset - 패널 위치 재설정."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - 모든 설정 지우고 리로드."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "정지 오류가 발생했지만 걱정할 필요가 없습니다. 때때로 발생할 수 있습니다. 문제를 해결하려면 리로드 버튼을 클릭하십시오."
L["A stop error has occurred but no need to worry. It can happen from time to time. Click the reload button to resolve it."] = "정지 오류가 발생했지만 걱정할 필요가 없습니다. 때때로 발생할 수 있습니다. 문제를 해결하려면 리로드 버튼을 클릭하십시오."
L["Acherus: The Ebon Hold"] = "아케루스: 칠흑의 요새"
L["Aerie Peak"] = "맹금의 봉우리"
L["Agmar's Hammer"] = "아그마르의 망치"
L["Ahn'Qiraj"] = "안퀴라즈"
L["Aldor"] = "알도르 마루"
L["Allerian Stronghold"] = "알레리아 성채"
L["Alliance Cities"] = "얼라이언스 대도시"
L["Alpha"] = "투명도"
L["Altar of Sha'tar"] = "샤타르 제단"
L["Alterac Mountains"] = "알터랙 산맥"
L["Always"] = "항상"
L["Amber Lodge"] = "호박석 절벽"
L["Amberpine Lodge"] = "호박빛소나무 오두막"
L["Apothecary Camp"] = "연금술사 야영지"
L["Appearance"] = "외형"
L["Arathi Highlands"] = "아라시 고원"
L["Area 52"] = "52번 구역"
L["Argent Tournament Grounds"] = "은빛십자군 마상시합 광장"
L["Ashenvale"] = "잿빛 골짜기"
L["Astranaar"] = "아스트라나르"
L["Auberdine"] = "아우버다인"
L["Auchenai Crypts"] = "아키나이 납골당"
L["Auto change zones"] = "지역 변경 자동"
L["Azeroth"] = "아제로스"
L["Azjol-Nerub"] = "아졸네룹"
L["Azshara"] = "아즈샤라"
L["Azuremyst Isle"] = "하늘안개 섬"
L["Back to Main Menu"] = "주 메뉴로 돌아가기"
L["Badlands"] = "황야의 땅"
L["Battlegrounds"] = "전장"
L["Black Morass"] = "검은늪"
L["Black Temple"] = "검은사원"
L["Blackfathom Deeps"] = "검은 심연 나락"
L["Blackrock Depths"] = "검은바위 나락"
L["Blackrock Mountain"] = "검은바위 산"
L["Blackwing Lair"] = "검은날개 둥지"
L["Blade Tooth Canyon"] = "칼날이빨 대협곡"
L["Blade's Edge Mountains"] = "칼날산맥"
L["Blades' Run"] = "칼날 고개"
L["Blasted Lands"] = "저주받은 땅"
L["Blood Watch"] = "핏빛 감시초소"
L["Bloodmyst Isle"] = "핏빛안개 섬"
L["Bloodvenom Post"] = "피멍울초소"
L["Blue"] = "블루"
L["Boat to"] = "연결된 항구:"
L["Booty Bay"] = "무법항"
L["Borean Tundra"] = "북풍의 땅"
L["Bor'gorok Outpost"] = "보르고로크 전초기지"
L["Bouldercrag's Refuge"] = "볼더크랙의 은거처"
L["Brackenwall Village"] = "담쟁이 마을"
L["Burning Crusade Classic"] = "불타는 성전 클래식"
L["Burning Steppes"] = "불타는 평원"
L["Camp Mojache"] = "모자케 야영지"
L["Camp Oneqwah"] = "원크와 야영지"
L["Camp Taurajo"] = "타우라조 야영지"
L["Camp Tunka'lo"] = "툰카로 야영지"
L["Camp Winterhoof"] = "겨울발굽 야영지"
L["Caverns of Time"] = "시간의 동굴"
L["Cenarion Hold"] = "세나리온 요새"
L["Center map on player"] = "플레이어 중심 지도"
L["Central Mesa"] = "중앙 봉우리"
L["Chillwind Camp"] = "서리바람 야영지"
L["Choose where the zone map should be shown."] = "지도 표시 영역 선택."
L["Class colored icons"] = "직업색상 아이콘"
L["Classic"] = "클래식"
L["Click to configure the settings for this option."] = "이 옵션의 설정을 구성하려면 클릭하십시오."
L["Click to reset the position and scale of the map frame."] = "지도 프레임의 위치와 크기를 재설정하려면 클릭하십시오."
L["Click to reset the settings on this page."] = "이 페이지의 설정을 재설정하려면 클릭하십시오."
L["Click to return to the main menu."] = "클릭하면 주 메뉴로 돌아갑니다."
L["Coilfang Reservoir"] = "갈퀴송곳니 저수지"
L["Coldarra"] = "콜다라"
L["Configuration Panel"] = "설정창"
L["Conquest Hold"] = "정복의 요새"
L["Cosmic"] = "세계지도"
L["Cosmowrench"] = "코스모렌치"
L["Crusaders' Pinnacle"] = "십자군 봉우리"
L["Crystalsong Forest"] = "수정노래 숲"
L["Culling of Stratholme"] = "옛 스트라솔름"
L["Cursor"] = "커서"
L["Dalaran"] = "달라란"
L["Dalaran Crater"] = "달라란 구덩이"
L["Darkshire"] = "다크샤이어"
L["Darkshore"] = "어둠의 해안"
L["Darnassus"] = "다르나서스"
L["Deadwind Pass"] = "죽음의 고개"
L["Death's Rise"] = "죽음의 마루"
L["Desolace"] = "잊혀진 땅"
L["Dire Maul (East)"] = "혈투의 전장(동쪽)"
L["Dire Maul (East) (side entrance)"] = "혈투의 전장(동쪽-후문)"
L["Dire Maul (North)"] = "혈투의 전장(북쪽)"
L["Dire Maul (West)"] = "혈투의 전장(서쪽)"
L["Disable reading emote when opening the map"] = "지도 볼때 감정표현(모션) 사용안함"
L["Drag"] = "이동"
L["Drag to set the amount of blue."] = "블루 색상을 드레그 설정 하세요."
L["Drag to set the amount of green."] = "그린 색상을 드레그 설정 하세요."
L["Drag to set the amount of red."] = "레드 색상을 드레그 설정 하세요."
L["Drag to set the battlefield map opacity."] = "드래그하여 전장 지도 불투명도를 설정합니다."
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "드래그하여 전장 지도 크기를 설정합니다.|n|n지도가 잠금 해제된 경우 오른쪽 하단 모서리를 드래그하여 전장 지도의 크기를 조정할 수도 있습니다."
L["Drag to set the group icon size."] = "그룹 아이콘 크기를 설정하려면 드래그하십시오."
L["Drag to set the map opacity for when your character is moving."] = "캐릭터가 움직일 때의 맵 불투명도를 드레그 설정하세요."
L["Drag to set the map opacity for when your character is stationary."] = "캐릭터가 정지되어있을 때의 맵 불투명도를 설정하십시오."
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "드래그하여 최대 확대/축소 수준을 설정합니다.|n|n슬라이더를 드래그할 때 최대 확대/축소 수준이 변경되는 것을 보려면 전장 지도를 엽니다."
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "드래그하여 최대 확대/축소 수준을 설정합니다.|n|n슬라이더를 드래그할 때 최대 확대/축소 수준이 변경되는 것을 보려면 지도를 엽니다."
L["Drag to set the opacity."] = "불투명도를 드레그 설정하세요."
L["Drag to set the player arrow size."] = "플레이어 화살표 크기를 설정하려면 드래그하십시오."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "드래그하여 플레이어 화살표 크기를 설정합니다. Wow Classic 기본값:16. Wow Retail 기본값: 27."
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "드래그하여 세계 지도 축척을 설정합니다.|n|n오른쪽 하단 모서리를 끌어 세계 지도의 축척을 조정할 수도 있습니다."
L["Dragonblight"] = "용의 안식처"
L["Drak'Tharon Keep"] = "드락타론 성채"
L["Druid only flight point to Darnassus"] = "드루이드 전용 비행지점"
L["Druid only flight point to Thunder Bluff"] = "드루이드 전용 비행지점"
L["Dun Algaz"] = "던 알가즈"
L["Dun Morogh"] = "던 모로"
L["Dun Nifflelem"] = "던 니펠렘"
L["Dungeon"] = "던전"
L["Dungeon (requires Crescent Key)"] = "던전 진입 (초승달 열쇠 필요)"
L["Durotar"] = "듀로타"
L["Duskwood"] = "그늘숲"
L["Dustwallow Marsh"] = "먼지진흙 습지대"
L["Dwarven District"] = "드워프 지구"
L["Eastern Plaguelands"] = "동부 역병지대"
L["Ebon Watch"] = "칠흑의 감시초소"
L["Elements"] = "기타 기능"
L["Elwynn Forest"] = "엘원 숲"
L["Emerald Sanctuary"] = "에메랄드 성소"
L["Enhance battlefield map"] = "전장지도 설정"
L["Enlarge player arrow"] = "플레이어 화살표 크게"
L["Enter"] = "Enter"
L["Evergrove"] = "영원의 숲"
L["Everlook"] = "눈망루 마을"
L["Eversong Woods"] = "영원노래 숲"
L["Exodar"] = "엑소다르"
L["Falcon Watch"] = "매의 감시탑"
L["Feathermoon Stronghold"] = "페더문 요새"
L["Felwood"] = "악령의 숲"
L["Feralas"] = "페랄라스"
L["Fishing"] = "낚시"
L["Fizzcrank Airstrip"] = "피즈크랭크 비행장"
L["Flame Crest"] = "화염 마루"
L["Fordragon Hold"] = "폴드라곤 요새"
L["Forest Song"] = "숲의 노래"
L["Fort Wildervar"] = "빌더바르 요새"
L["Freewind Post"] = "늪새바람 봉우리"
L["Frosthold"] = "서리요새"
L["Gadgetzan"] = "가젯잔"
L["Garadar"] = "가라다르"
L["Ghostlands"] = "유령의 땅"
L["Gnomeregan"] = "놈리건"
L["Green"] = "그린"
L["Grizzly Hills"] = "회색 구릉지"
L["Grom'arsh Crash Site"] = "그롬아쉬 추락 지점"
L["Grom'gol Base Camp"] = "그룸골 주둔지"
L["Group Icons"] = "그룹 아이콘"
L["Gruul's Lair"] = "그룰의 둥지"
L["Gundrak"] = "군드락"
L["Gundrak (rear entrance)"] = "군드락 (후문)"
L["Halls of Lightning"] = "번개의 전당"
L["Halls of Stone"] = "돌의 전당"
L["Hammerfall"] = "해머폴"
L["Head down the mountain from here."] = "산 아래 방향으로 이동"
L["Head southeast from here and go up the mountain."] = "남동쪽 산을 통해 이동"
L["Hellfire Peninsula"] = "지옥불 반도"
L["Hellfire Ramparts"] = "지옥불 성루"
L["Hide town and city icons"] = "도시와 타운 아이콘 숨김"
L["Hillsbrad Foothills"] = "힐스브래드 구릉지"
L["Honor Hold"] = "명예의 요새"
L["Horde Cities"] = "호드 대도시"
L["Howling Fjord"] = "울부짖는 협만"
L["Hyjal Summit"] = "하이잘 정상"
L["Icecrown"] = "얼음왕관"
L["Icecrown Citadel"] = "얼음왕관 성채"
L["Icons"] = "아이콘"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "여객 항구, 비행선 타워 및 지하철역이 표시됩니다."
L["If checked, coordinates will be shown."] = "좌표가 표시됩니다."
L["If checked, dungeons and raids will be shown."] = "던전과 공격대가 표시됩니다."
L["If checked, group icons will use a modern, class-colored design."] = "그룹 아이콘은 현대적인 직업색상 디자인을 사용합니다."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "지도를 열면 지도영역이 변경되지 않은 한 마지막으로 닫을 때와 동일한 확대 / 축소 수준이 사용됩니다."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "캐릭터가 움직이는 동안 지도를 가리키면 불투명 적용되지 않습니다."
L["If checked, points of interest will be shown."] = "주요지점이 표시됩니다."
L["If checked, quest objectives will be shown."] = "체크하면 퀘스트 목표가 표시됩니다."
L["If checked, spirit healers will be shown."] = "영혼의 치유사가 표시됩니다."
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "던전에 있지 않는 한 전장 지도가 내 위치의 중앙에 유지됩니다.|n|n Shift 키를 누른 상태에서 지도를 패닝하여 일시적으로 중앙에 맞추는 것을 방지할 수 있습니다."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "전체 화면 맵이 기본 사용됩니다. |n|n이 옵션을 활성화하면 다른 옵션 중 일부가 잠깁니다."
L["If checked, the map border will be removed."] = "지도 테두리가 제거됩니다."
L["If checked, the map frame will remain open until you close it."] = "맵 프레임은 닫을 때까지 열린 상태로 유지됩니다."
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "던전에 있지 않는 한 지도가 내 위치의 중앙에 유지됩니다.|n|n Shift 키를 누른 상태에서 지도를 패닝하여 일시적으로 중앙에 맞추는 것을 방지할 수 있습니다."
L["If checked, the minimap button will be shown."] = "미니 맵 버튼이 표시됩니다."
L["If checked, the minimum fishing skill levels will be shown."] = "최소 낚시 숙련도가 표시됩니다."
L["If checked, town and city icons will not be shown on the continent maps."] = "대도시와 마을 아이콘은 대륙지도에 표시되지 않습니다."
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "상대 진영의 이동 지점이 표시됩니다.|n|n여기에는 비행 지점, 보트 항구, 비행선 탑승장 및 지하철 정류장이 포함됩니다."
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "같은 진영의 이동 지점이 표시됩니다.|n|n비행 지점, 보트 항구, 비행선 탑승장 및 지하철 정류장이 포함됩니다."
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "지도의 미개척 지역이 세계지도와 전장 지도에 표시됩니다."
L["If checked, unexplored areas will be tinted."] = "미탐험 지역의 색상을 설정합니다."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "캐릭터의 지역이 변경되면, 지도가 새 지역으로 자동 변경됩니다."
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "전장 지도의 테두리를 드래그하여 이동할 수 있습니다.|n|n오른쪽 하단 모서리를 드래그하여 전장 지도의 크기를 조정할 수 있습니다."
L["If checked, you will be able to customise the battlefield map."] = "전장지도를 사용자 설정 할 수 있습니다."
L["If checked, you will be able to enlarge the player arrow."] = "플레이어 화살표를 확대 할 수 있습니다."
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "체크하면 오른쪽 하단 모서리에 있는 크기 조절 핸들을 끌어서 지도 크기를 조절할 수 있습니다. |n|n모든 테두리를 드래그하여 지도를 이동할 수 있습니다. |n|n이 설정에 관계없이 지도를 이동하려면 항상 상단 테두리를 드래그할 수 있습니다."
L["If checked, you will be able to set the opacity of the map."] = "지도의 불투명도를 설정할 수 있습니다."
L["If checked, you will be able to zoom further into the world map."] = "세계지도를 더 확대할 수 있습니다."
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "지도 프레임에 지역 및 대륙 드롭다운 메뉴가 표시됩니다."
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "구역 교차점이 표시됩니다.|n|n구역 출구 경로를 나타내는 클릭 가능한 화살표입니다."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "지역, 던전 및 낚시 레벨이 표시됩니다."
L["Increase zoom level"] = "확대/축소 수준 올리기"
L["Invalid command.  Enter /ltm help for help."] = "잘못된 명령입니다.도움말을 확인하세요. /ltm help"
L["Invalid command. Enter /ltm help for help."] = "잘못된 명령입니다. /ltm help를 입력하여 명령어를 확인하세요."
L["Invalid map ID."] = "잘못된 지도 ID입니다."
L["Ironforge"] = "아이언포지"
L["Isle of Quel'Danas"] = "쿠엘다나스 섬"
L["K3"] = "K3"
L["Kamagua"] = "카마구아"
L["Karazhan"] = "카라잔"
L["Kargath"] = "카르가스"
L["Kor'kron Vanguard"] = "코르크론 선봉대"
L["Lake Elune'ara"] = "엘룬아라 호수"
L["Lake Everstill"] = "영원의 호수"
L["Large Scarab Coffer"] = "큰 스카라베 상자"
L["Leads to Tirisfal Glades"] = "티리스팔 숲 방향"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS : 잘못된 버전이 설치되었습니다!"
L["Light's Breach"] = "빛의 틈"
L["Light's Hope Chapel"] = "희망의 빛 예배당"
L["Loch Modan"] = "모단 호수"
L["Lower Blackrock Spire"] = "검은바위 첨탑 하층"
L["Magisters' Terrace"] = "마법학자의 정원"
L["Magtheridon's Lair"] = "마그테리돈의 둥지"
L["Mana-Tombs"] = "마나 무덤"
L["Map frame scale"] = "지도 크기 변경"
L["Map Opacity"] = "지도 불투명도"
L["Map Scale"] = "지도 크기"
L["Map Size"] = "지도 크기"
L["MapScale"] = "지도 크기"
L["Maraudon"] = "마라우돈"
L["Marshal's Refuge"] = "마샬의 야영지"
L["Max Zoom"] = "최대 줌"
L["Maximum"] = "최대"
L["Mechanics"] = "이거"
L["Memory Usage"] = "메모리 사용량"
L["Menethil Harbor"] = "메네실 항구"
L["Miscellaneous"] = "기타"
L["Moa'ki"] = "모아키 항구"
L["Moa'ki Harbor"] = "모아키 항구"
L["Mok'Nathal Village"] = "모그나탈 마을"
L["Molten Core"] = "화산 심장부"
L["Moonglade"] = "달의 숲"
L["More"] = "그외"
L["Morgan's Vigil"] = "모건의 망루"
L["Moving"] = "이동할 때"
L["Mudsprocket"] = "진흙톱니 거점"
L["Mulgore"] = "멀고어"
L["Nagrand"] = "나그란드"
L["Naxxramas"] = "낙스라마스"
L["Nesingwary Base Camp"] = "네싱워리 주둔지"
L["Nethergarde Keep"] = "네더가드 요새"
L["Netherstorm"] = "황천의 폭풍"
L["Never"] = "끔"
L["New Agamand"] = "신 아가만드"
L["Nighthaven"] = "나이트헤이븐"
L["Nijel's Point"] = "나이젤의 야영지"
L["North"] = "북쪽"
L["North Gate Pass"] = "북쪽 관문 통행로"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "주의!|nLeatrix Maps 이 버전을 적용하려면 게임 클라이언트를 다시 시작해야합니다."
L["Old Hillsbrad"] = "옛 힐스브래드 구릉지"
L["Old Hillsbrad Foothills"] = "옛 언덕마루 구릉지"
L["Onyxia's Lair"] = "오닉시아의 둥지"
L["Opacity"] = "불투명"
L["or click the minimap button to open Leatrix Maps."] = "미니맵 버튼을 클릭하여 Leatrix Maps를 엽니다."
L["Orb of Translocation"] = "순간이동의 보주"
L["Orebor Harborage"] = "오레보르 피난처"
L["Orgrimmar"] = "오그리마"
L["Player"] = "플레이어"
L["Player Arrow"] = "플레이어 화살표"
L["Portal"] = "차원문"
L["Portal from Zephyr"] = "제피르와 대화를 통해 이동 (시간의 수호자 평판 매우호 필요)"
L["Portals"] = "차원문"
L["Preview"] = "미리보기"
L["Ragefire Chasm"] = "성난불길 협곡"
L["Raid"] = "공격대"
L["Ratchet"] = "톱니항"
L["Ravenholdt Manor"] = "라벤홀트 장원"
L["Razorfen Downs"] = "가시덩굴 구릉"
L["Razorfen Kraul"] = "가시덩굴 우리"
L["Razorthorn Trail"] = "서슬가시 고개"
L["Rebel Camp"] = "반란군 야영지"
L["Red"] = "레드"
L["Redridge Mountains"] = "붉은마루 산맥"
L["Refuge Pointe"] = "임시주둔지"
L["Reload"] = "리로드"
L["Remember zoom level"] = "확대/축소 기억"
L["Remove map border"] = "지도 테두리 제거"
L["req"] = "입장가능 레벨"
L["Requires Key to Searing Gorge"] = "이글거리는 협곡 열쇠 필요"
L["Requires UI reload."] = "UI를 리로드 해야합니다."
L["Reset"] = "리셋"
L["Reset Map Layout"] = "지도 레이아웃 초기화"
L["Revantusk Village"] = "레반터스크 마을"
L["River's Heart"] = "강의 심장부"
L["Ruins of Ahn'Qiraj"] = "안퀴라즈 폐허"
L["Ruins of Elune'eth"] = "엘룬에스의 페허"
L["Rut'theran Village"] = "루테란 마을"
L["Rut'Theran Village"] = "루테란 마을"
L["Sanctum of the Stars"] = "별의 성소"
L["Scale"] = "크기"
L["Scarlet Monastery"] = "붉은십자군 수도원"
L["Scholomance"] = "스칼로맨스"
L["Searing Gorge"] = "이글거리는 협곡"
L["Seat of the Naaru"] = "나루의 보좌"
L["Sentinel Hill"] = "감시의 언덕"
L["Serpentshrine Cavern"] = "불뱀 제단"
L["Set map opacity"] = "지도 불투명도 설정"
L["Set map opacity while stationary and while moving."] = "플레이어가 맵을 열고 이동할때와 고정일때의 맵 불투명도를 설정합니다."
L["Set the group icon size."] = "그룹아이콘 크기 설정"
L["Set the maximum zoom scale."] = "최대 줌 배율을 설정하십시오."
L["Set the player arrow size."] = "플레이어 화살표 크기를 설정하십시오."
L["Sethekk Halls"] = "세데크 전당"
L["Settings"] = "설정"
L["Sewers"] = "하수구"
L["Shadow Labyrinth"] = "어둠의 미궁"
L["Shadowfang Keep"] = "그림자송곳니 성채"
L["Shadowmoon Valley"] = "어둠달 골짜기"
L["Shadowmoon Village"] = "어둠달 마을"
L["Shadowprey Village"] = "그늘수렵 마을"
L["Shatter Point"] = "징검다리 거점"
L["Shattrath"] = "샤트라스"
L["Shattrath City"] = "샤트라스"
L["Sholazar Basin"] = "숄라자르 분지"
L["Show boats, zeppelins and trams"] = "여객선,비행선,지하철 표시"
L["Show coordinates"] = "좌표 표시"
L["Show dungeons and raids"] = "던전 및 공격대 표시"
L["Show minimap button"] = "미니맵 버튼 표시"
L["Show minimum fishing skill levels"] = "최소 낚시 숙련도 표시"
L["Show objectives"] = "목표 표시"
L["Show points of interest"] = "주요 지점 표시"
L["Show scale handle"] = "크기 설정 표시"
L["Show spirit healers"] = "영혼의 치유사를 표시"
L["Show travel points for opposing faction"] = "적대 세력의 이동 지점 표시"
L["Show travel points for same faction"] = "같은 진영의 이동 포인트 표시"
L["Show unexplored areas"] = "미탐험 지역 표시"
L["Show zone crossings"] = "영역 교차 표시"
L["Show zone levels"] = "지역 레벨 표시"
L["Show zone menus"] = "지역 메뉴 표시"
L["Silithus"] = "실리더스"
L["Silvermoon"] = "실버문"
L["Silvermoon City"] = "실버문"
L["Silverpine Forest"] = "은빛소나무 숲"
L["Slave Pens"] = "강제 노역소"
L["South"] = "남쪽"
L["South Gate Pass"] = "남쪽 관문 통행로"
L["Southfury River"] = "분노의 강"
L["Southshore"] = "사우스쇼어"
L["Spinebreaker Ridge"] = "지옥절단기 함락지"
L["Spirit Healer"] = "영혼의 치유사"
L["Splintertree Post"] = "토막나무 주둔지"
L["Stars' Rest"] = "별의 쉼터"
L["Stationary"] = "움직이지 않을 때"
L["Steamvault"] = "증기 저장고"
L["Sticky map frame"] = "지도 프레임 지속됨."
L["Stonard"] = "스토나드"
L["Stonebreaker Hold"] = "돌망치 요새"
L["Stonetalon Mountains"] = "돌발톱 산맥"
L["Stonetalon Peak"] = "돌발톱 봉우리"
L["Stormwind"] = "스톰윈드"
L["Stormwind City"] = "스톰윈드"
L["Stranglethorn Vale"] = "가시덤불 골짜기"
L["Stratholme (Main Gate)"] = "스트라솔름(정문)"
L["Stratholme (Service Gate)"] = "스트라솔름(후문)"
L["sum"] = "만남의 돌"
L["Sun Rock Retreat"] = "해바위 야영지"
L["Sunreaver's Command"] = "선리버 지휘초소"
L["Sun's Reach Harbor"] = "태양너울 항구"
L["Sunwell Plateau"] = "태양샘 고원"
L["Swamp of Sorrows"] = "슬픔의 늪"
L["Swamprat Post"] = "늪쥐 감시초소"
L["Sylvanaar"] = "실바나르"
L["System"] = "설정"
L["Talonbranch Glade"] = "바람속삭임 숲"
L["Talrendis Point"] = "탈렌디스 초소"
L["Tanaris"] = "타나리스"
L["Tarren Mill"] = "타렌 밀농장"
L["Taunka'le Village"] = "타운카르 마을"
L["Telaar"] = "텔라아르"
L["Teldrassil"] = "텔드랏실"
L["Teleport Crystal"] = "순간이동 크리스털"
L["Telredor"] = "텔레도르"
L["Tempest Keep"] = "폭풍우 요새"
L["Temple of Ahn'Qiraj"] = "안퀴라즈"
L["Temple of Atal'Hakkar"] = "아탈학카르 신전"
L["Temple of Telhamat"] = "텔하마트 사원"
L["Terokkar Forest"] = "테로카르 숲"
L["Thalanaar"] = "탈라나르"
L["Thandol Span"] = "탄돌 교각"
L["The Arcatraz"] = "알카트라즈"
L["The Argent Stand"] = "은빛십자군 격전지"
L["The Argent Vanguard"] = "은빛십자군 선봉기지"
L["The Barrens"] = "불모의 땅"
L["The Blood Furnace"] = "피의 용광로"
L["The Botanica"] = "신록의 정원"
L["The Bulwark"] = "보루"
L["The Crossroads"] = "크로스로드"
L["The Dark Portal"] = "어둠의 문"
L["The Deadmines"] = "죽음의 폐광"
L["The Exodar"] = "엑소다르"
L["The Eye"] = "폭풍우 요새"
L["The Eye of Eternity"] = "영원의 눈"
L["The Forge of Souls"] = "영혼의 제련소"
L["The Forgotten Coast"] = "잊혀진 해안"
L["The Frozen Halls"] = "얼어붙은 전당"
L["The Great Forge"] = "대용광로"
L["The Great Lift"] = "구름 승강장"
L["The Halls of Reflection"] = "투영의 전당"
L["The Hinterlands"] = "동부 내륙지"
L["The Mechanar"] = "메카나르"
L["The Nexus"] = "마력의 탑"
L["The Obsidian Sanctum"] = "흑요석 성소"
L["The Oculus"] = "마력의 눈"
L["The Old Kingdom"] = "안카헤트: 고대왕국"
L["The Pit of Saron"] = "사론의 구덩이"
L["The Ruby Sanctum"] = "루비 성소"
L["The Sepulcher"] = "공동묘지"
L["The Shadow Vault"] = "어둠의 무기고"
L["The Shattered Halls"] = "으스러진 손의 전당"
L["The Stockade"] = "스톰윈드 지하감옥"
L["The Storm Peaks"] = "폭풍우 봉우리"
L["The Stormspire"] = "폭풍 첨탑"
L["The Talondeep Path"] = "돌발톱 토굴길"
L["The Vault of Lights"] = "빛의 전당"
L["The Violet Hold"] = "보라빛 요새"
L["The Zoram Strand"] = "조람 해안"
L["Thelsamar"] = "텔사마"
L["Theramore Isle"] = "테라모어"
L["Thorium Point"] = "토륨 조합 거점"
L["Thousand Needles"] = "버섯구름 봉우리"
L["Thrallmar"] = "스랄마"
L["Thunder Bluff"] = "썬더 블러프"
L["Thunderlord Stronghold"] = "천둥군주 요새"
L["Timbermaw Hold"] = "나무구렁 요새"
L["Tinker Town"] = "땜장이 마을"
L["Tint unexplored areas"] = "미탐험지역 색상"
L["Tirisfal Glades"] = "티리스팔 숲"
L["Toggle panel"] = "스위치 패널"
L["Toshley's Station"] = "토쉴리의 연구기지"
L["Trade District"] = "상업지구"
L["Trade Quarter"] = "상업지구"
L["Tram to"] = "지하철 이동:"
L["Tranquillien"] = "트랜퀼리엔"
L["Transitus Shield"] = "변위의 보호막"
L["Transparency"] = "투명도"
L["Trial of the Champion"] = "용사의 시험장"
L["Trial of the Crusader"] = "십자군의 시험장"
L["Twilight Shore"] = "황혼의 해안"
L["Twilight Vale"] = "황혼의 계곡"
L["Uldaman"] = "울다만"
L["Uldaman (side entrance)"] = "울다만 (후문)"
L["Ulduar"] = "울두아르"
L["Underbog"] = "지하수렁"
L["Undercity"] = "언더시티"
L["Un'Goro Crater"] = "운고로 분화구"
L["Unlock battlefield map"] = "전장 지도 잠금 해제"
L["Unlock map frame"] = "세계지도 잠금해제"
L["Unu'pe"] = "우누페"
L["Upper Blackrock Spire"] = "검은바위 첨탑 상층"
L["Use default map"] = "기본 지도 사용"
L["Use stationary opacity while pointing at map"] = "지도를 가리키는 동안 불투명도 사용 안함"
L["Utgarde Keep"] = "우트가드 성채"
L["Utgarde Pinnacle"] = "우트가드 첨탑"
L["Valaar's Berth"] = "발라르의 나루"
L["Valgarde"] = "발가드"
L["Valgarde Port"] = "발가드"
L["Valiance Keep"] = "용맹의 성채"
L["Valiance Landing Camp"] = "용맹의 주둔지"
L["Valley of Strength"] = "힘의 골짜기"
L["Valormok"] = "발로르모크"
L["Vault of Archavon"] = "아카본 석실"
L["Vengeance Landing"] = "복수의 상륙지"
L["Venomspite"] = "원한의 초소"
L["Version"] = "버전"
L["Wailing Caverns"] = "통곡의 동굴"
L["Warsong Camp"] = "전쟁노래 야영지"
L["Warsong Hold"] = "전쟁노래 요새"
L["Western Plaguelands"] = "서부 역병지대"
L["Westfall"] = "서부 몰락지대"
L["Westfall Brigade"] = "서부 몰락지대"
L["Westguard Keep"] = "서부 몰락지대 여단 야영지"
L["Wetlands"] = "저습지"
L["Wildhammer Stronghold"] = "와일드해머 성채"
L["Windrunner's Overlook"] = "윈드러너 전망대"
L["Wintergarde Keep"] = "윈터가드 성채"
L["Wintergrasp"] = "겨울손아귀"
L["Winterspring"] = "여명의 설원"
L["Wrath of the Lich King Classic"] = "리치 왕의 분노 클래식"
L["Wyrmrest Temple"] = "고룡쉼터 사원"
L["You will die!"] = "무덤 이동 장소"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "일부 변경 사항을(*) 적용하려면 UI를 리로드 해야합니다."
L["Your UI needs to be reloaded."] = "UI를 리로드 해야 합니다."
L["Zabra'jin"] = "자브라진"
L["Zangarmarsh"] = "장가르 습지대"
L["Zeb'Sora"] = "제브소라"
L["Zeppelin to"] = "연결된 비행선 지점:"
L["Zim'Torga"] = "짐토르가"
L["Zone Map"] = "지역 지도(작은 지도)"
L["Zoom"] = "확대/축소"
L["Zoram'gar Outpost"] = "조람가르 전초기지"
L["Zul'Aman"] = "줄아만"
L["Zul'Drak"] = "줄드락"
L["Zul'Farrak"] = "줄파락"
L["Zul'Gurub"] = "줄구룹"

end

-- deDE: German
if GameLocale == "deDE" then
	L["(destination only)"] = "(nur Ziel)"
L["(inside Caverns of Time)"] = "(in den Höhlen der Zeit)"
L["/ltm help - Show this information."] = "/ltm help - Informationen anzeigen."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Panelposition Zurücksetzen."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - ALLE Einstellungen zurücksetzen und Interface neu laden."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Ein Stopp-Fehler ist aufgetreten aber keine Sorge.  Das kann von Zeit zu Zeit passieren.  Klicke auf den Reload Button und das Problem sollte behoben sein."
L["A stop error has occurred but no need to worry. It can happen from time to time. Click the reload button to resolve it."] = "Ein Haltefehler ist aufgetreten, aber keine Sorge. Das kann von Zeit zu Zeit passieren. Klicke auf die Aktualisierungsschaltfläche, um es zu beheben."
L["Acherus: The Ebon Hold"] = "Acherus: Die Ebonfaust"
L["Aerie Peak"] = "Aerie Peak"
L["Agmar's Hammer"] = "Agmars Hammer"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Aldor"] = "Aldor"
L["Allerian Stronghold"] = "Allerias Feste"
L["Alliance Cities"] = "Allianz Städte"
L["Alpha"] = "Alpha"
L["Altar of Sha'tar"] = "Altar der Sha'tar"
L["Alterac Mountains"] = "Alteracgebirge"
L["Always"] = "Immer"
L["Amber Lodge"] = "Bernsteinlager"
L["Amberpine Lodge"] = "Bernsteinfichtenlager"
L["Apothecary Camp"] = "Apothekerlager"
L["Appearance"] = "Aussehen"
L["Arathi Highlands"] = "Arathihochland"
L["Area 52"] = "Area 52"
L["Argent Tournament Grounds"] = "Argentumturniergelände"
L["Ashenvale"] = "Eschental"
L["Astranaar"] = "Astranaar"
L["Auberdine"] = "Auberdine"
L["Auchenai Crypts"] = "Auchenaikrypta"
L["Auto change zones"] = "Automatische Zonenwechsel"
L["Azeroth"] = "Azeroth"
L["Azjol-Nerub"] = "Azjol-Nerub"
L["Azshara"] = "Azshara"
L["Azuremyst Isle"] = "Azurmythosinsel"
L["Back to Main Menu"] = "Zurück zum Hauptmenü"
L["Badlands"] = "Ödland"
L["Battlegrounds"] = "Schlachtfelder"
L["Black Morass"] = "Schwarze Morast"
L["Black Temple"] = "Der Schwarze Tempel"
L["Blackfathom Deeps"] = "Blackfathom-Tiefe"
L["Blackrock Depths"] = "Blackrocktiefen"
L["Blackrock Mountain"] = "Der Blackrock"
L["Blackwing Lair"] = "Pechschwingenhort"
L["Blade Tooth Canyon"] = "Klingenzahnschlucht"
L["Blade's Edge Mountains"] = "Schergrat"
L["Blades' Run"] = "Klingenjagd"
L["Blasted Lands"] = "Verwüstete Lande"
L["Blood Watch"] = "Blutwacht"
L["Bloodmyst Isle"] = "Blutmythosinsel"
L["Bloodvenom Post"] = "Blutgiftposten"
L["Blue"] = "Blau"
L["Boat to"] = "Boot nach"
L["Booty Bay"] = "Booty Bay"
L["Borean Tundra"] = "Boreanische Tundra"
L["Bor'gorok Outpost"] = "Außenposten Bor'gorok"
L["Bouldercrag's Refuge"] = "Felskluft Zuflucht"
L["Brackenwall Village"] = "Brackenwall"
L["Burning Crusade Classic"] = "Burning Crusade Classic"
L["Burning Steppes"] = "Brennende Steppe"
L["Camp Mojache"] = "Camp Mojache"
L["Camp Oneqwah"] = "Lager Oneqwah"
L["Camp Taurajo"] = "Camp Taurajo"
L["Camp Tunka'lo"] = "Lager Tunka'lo"
L["Camp Winterhoof"] = "Lager Winterhuf"
L["Caverns of Time"] = "Höhlen der Zeit"
L["Cenarion Hold"] = "Burg Cenarius"
L["Center map on player"] = "Karte auf Spieler zentrieren"
L["Central Mesa"] = "Die große Anhöhe"
L["Chillwind Camp"] = "Chillwind-Lager"
L["Choose where the zone map should be shown."] = "Wähle, wo die Zonenkarte angezeigt werden soll."
L["Class colored icons"] = "Symbole in Klassenfarbe"
L["Classic"] = "Classic"
L["Click to configure the settings for this option."] = "Klicken um die Einstellung dieser Option zu verändern."
L["Click to reset the position and scale of the map frame."] = "Klicken zum zurücksetzen der Position und Größe des Weltkartenfensters."
L["Click to reset the settings on this page."] = "Klicken zum zurücksetzen der Einstellungen dieses Fensters."
L["Click to return to the main menu."] = "Klicken um zurück ins Hauptmenü zu gelangen."
L["Coilfang Reservoir"] = "Der Echsenkessel"
L["Coldarra"] = "Kaltarra"
L["Configuration Panel"] = "Einstellungsfenster"
L["Conquest Hold"] = "Eroberungsfeste"
L["Cosmic"] = "Kosmisch"
L["Cosmowrench"] = "Kosmozang"
L["Crusaders' Pinnacle"] = "Scharlachrotes Scharnier"
L["Crystalsong Forest"] = "Kristallsangwald"
L["Culling of Stratholme"] = "Säuberung von Stratholme"
L["Cursor"] = "Cursor"
L["Dalaran"] = "Dalaran"
L["Dalaran Crater"] = "Dalarankrater"
L["Darkshire"] = "Dunkelhain"
L["Darkshore"] = "Dunkelküste"
L["Darnassus"] = "Darnassus"
L["Deadwind Pass"] = "Gebirgspass der Totenwinde"
L["Death's Rise"] = "Anstieg des Todes"
L["Desolace"] = "Desolace"
L["Dire Maul (East)"] = "Düsterbruch (Ost)"
L["Dire Maul (East) (side entrance)"] = "Düsterbruch (Ost) (Seiteneingang)"
L["Dire Maul (North)"] = "Düsterbruch (Nord)"
L["Dire Maul (West)"] = "Düsterbruch (West)"
L["Disable reading emote when opening the map"] = "Deaktiviert die Leseanimation wenn die Weltkarte geöffnet wird"
L["Drag"] = "Verschieben"
L["Drag to set the amount of blue."] = "Verschiebe den Regler für die Menge an blau."
L["Drag to set the amount of green."] = "Verschiebe den Regler für die Menge an grün."
L["Drag to set the amount of red."] = "Verschiebe den Regler für die Menge an rot."
L["Drag to set the battlefield map opacity."] = "Ziehen Sie, um die transparenz der Schlachtfeldkarte festzulegen."
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "Zum Einstellen der Größe der Schlachtfeldkarte ziehen.|n|nWenn die Karte entsperrt ist, kannst du die Größe auch ändern, indem du die untere rechte Ecke ziehst."
L["Drag to set the group icon size."] = "Ziehen zum ändern der Gruppenicongröße"
L["Drag to set the map opacity for when your character is moving."] = "Verschiebe den Regler für die Transparenz der Weltkarte wenn sich dein Charakter bewegt."
L["Drag to set the map opacity for when your character is stationary."] = "Verschiebe den Regler für die Transparenz der Weltkarte wenn dein Charakter steht."
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "Zum Einstellen des maximalen Zoomlevels ziehen.|n|nÖffne die Schlachtfeldkarte, um zu sehen, wie sich das maximale Zoomlevel ändert, wenn du den Schieberegler ziehst."
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "Zum Einstellen des maximalen Zoomlevels ziehen.|n|nÖffne die Karte, um zu sehen, wie sich das maximale Zoomlevel ändert, wenn du den Schieberegler ziehst."
L["Drag to set the opacity."] = "Verschiebe den Regler für die Transparenz."
L["Drag to set the player arrow size."] = "Ziehen Sie, um die Pfeilgröße des Spielers festzulegen"
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Verschieben um die Größe des Spielerpfeils einzustellen.|n|nWoW Classic größe ist 16.|nWoW Live größe ist 27."
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "Zum Einstellen der Weltkarten-Skala ziehen.|n|nDu kannst die Weltkarte auch neu skalieren, indem du die untere rechte Ecke ziehst."
L["Dragonblight"] = "Drachenöde"
L["Drak'Tharon Keep"] = "Feste Drak'Tharon"
L["Druid only flight point to Darnassus"] = "Flugpunkt nach Darnassus, nur für Druiden"
L["Druid only flight point to Thunder Bluff"] = "Flugpunkt nach Thunder Bluff, nur für Druiden"
L["Dun Algaz"] = "Dun Algaz"
L["Dun Morogh"] = "Dun Morogh"
L["Dun Nifflelem"] = "Dun Nifflelem"
L["Dungeon"] = "Instanz"
L["Dungeon (requires Crescent Key)"] = "Dungeon (benötigt Halbmond-Schlüssel)"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Dämmerwald"
L["Dustwallow Marsh"] = "Marschen von Dustwallow"
L["Dwarven District"] = "Der Zwergendistrikt"
L["Eastern Plaguelands"] = "Östliche Pestländer"
L["Ebon Watch"] = "Ebonwacht"
L["Elements"] = "Elemente"
L["Elwynn Forest"] = "Wald von Elwynn"
L["Emerald Sanctuary"] = "Das Smaragdrefugium"
L["Enhance battlefield map"] = "Verbessere die Schlachtfeldkarte"
L["Enlarge player arrow"] = "Vergrößerter spielerpfeil"
L["Enter"] = "Eingeben"
L["Evergrove"] = "Der Ewige Hain"
L["Everlook"] = "Everlook"
L["Eversong Woods"] = "Immersangwald"
L["Exodar"] = "Die Exodar"
L["Falcon Watch"] = "Falkenwacht"
L["Feathermoon Stronghold"] = "Festung Feathermoon"
L["Felwood"] = "Teufelswald"
L["Feralas"] = "Feralas"
L["Fishing"] = "Fischen"
L["Fizzcrank Airstrip"] = "Spritzkühlnordpiste"
L["Flame Crest"] = "Flammenkamm"
L["Fordragon Hold"] = "Festung Fordragon"
L["Forest Song"] = "Waldeslied"
L["Fort Wildervar"] = "Festung Wildervar"
L["Freewind Post"] = "Freiwindposten"
L["Frosthold"] = "Frostfeste"
L["Gadgetzan"] = "Gadgetzan"
L["Garadar"] = "Garadar"
L["Ghostlands"] = "Geisterlande"
L["Gnomeregan"] = "Gnomeregan"
L["Green"] = "Grün"
L["Grizzly Hills"] = "Grizzlyhügel"
L["Grom'arsh Crash Site"] = "Absturzstelle von Grom'arsh"
L["Grom'gol Base Camp"] = "Das Basislager von Grom'gol"
L["Group Icons"] = "Gruppenicons"
L["Gruul's Lair"] = "Gruuls Unterschlupf"
L["Gundrak"] = "Gundrak"
L["Gundrak (rear entrance)"] = "Gundrak (Hintereingang)"
L["Halls of Lightning"] = "Hall der Blitze"
L["Halls of Stone"] = "Hallen des Steins"
L["Hammerfall"] = "Hammerfall"
L["Head down the mountain from here."] = "Gehe von hier aus den Berg hinunter."
L["Head southeast from here and go up the mountain."] = "Gehe von hier aus nach Südosten und gehe den Berg hinauf."
L["Hellfire Peninsula"] = "Höllenfeuerhalbinsel"
L["Hellfire Ramparts"] = "Höllenfeuerbollwerk"
L["Hide town and city icons"] = "Verstecke Stadticons"
L["Hillsbrad Foothills"] = "Vorgebirge von Hillsbrad"
L["Honor Hold"] = "Ehrenfeste"
L["Horde Cities"] = "Horde Städte"
L["Howling Fjord"] = "Heulender Fjord"
L["Hyjal Summit"] = "Hyjalgipfel"
L["Icecrown"] = "Eiskrone"
L["Icecrown Citadel"] = "Eiskronenzitadelle"
L["Icons"] = "Symbole"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "Zeigt Schiffsanlegestellen, Zeppelintürme und Bahnstationen an wenn aktiviert."
L["If checked, coordinates will be shown."] = "Zeigt die Koordinaten an wenn aktiviert."
L["If checked, dungeons and raids will be shown."] = "Zeigt Instanz- und Schlachtzugseingänge an wenn aktiviert."
L["If checked, group icons will use a modern, class-colored design."] = "Gruppensymbole nutzen das moderne und, nach Klassenfarben, eingefärbte Aussehen wenn aktiviert."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Wenn aktiviert, öffnet sich die Weltkarte mit der selben Zoomstufe mit der Du sie zuletzt verlassen hast. Funktioniert nur solange Du nicht die Zone wechselst."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Nutzt die Transparenzeinstellung aus der 'Stehend' voreinstellung sobald sich euer Mauszeiger auf der Weltkarte befindet wenn aktiviert."
L["If checked, points of interest will be shown."] = "POI - interessante Punkte werden auf der Weltkarte mit Symbolen dargestellt wenn aktiviert."
L["If checked, quest objectives will be shown."] = "Wenn ausgewählt, werden Questziele angezeigt."
L["If checked, spirit healers will be shown."] = "Geistheiler werden angezeigt wenn aktiviert"
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Wenn ausgewählt, bleibt die Schlachtfeldkarte auf deinem Standort zentriert, solange du nicht in einem Dungeon bist.|n|nDu kannst die Umschalttaste gedrückt halten, während du die Karte verschiebst, um zu verhindern, dass sie sich vorübergehend zentriert."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Wenn aktiviert, wird die standard Vollbild-Karte genutzt.|n|n Hinweis - Das aktivieren dieser Option sperrt einige andere Funktionen."
L["If checked, the map border will be removed."] = "Der Fensterrand der Weltkarte wird entfernt wenn aktiviert."
L["If checked, the map frame will remain open until you close it."] = "Das Kartenfenster bleibt offen bis es manuell geschlossen wird, wenn aktiviert."
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Wenn ausgewählt, bleibt die Karte auf deinem Standort zentriert, solange du nicht in einem Dungeon bist.|n|nDu kannst die Umschalttaste gedrückt halten, während du die Karte verschiebst, um zu verhindern, dass sie sich vorübergehend zentriert."
L["If checked, the minimap button will be shown."] = "Zeigt den Button an der Minikarte wenn aktiviert."
L["If checked, the minimum fishing skill levels will be shown."] = "Zeigt die benötigte Angelfertigkeit des Gebietes an wenn aktiviert."
L["If checked, town and city icons will not be shown on the continent maps."] = " Stadtsymbole werden nicht gezeigt wenn aktiviert."
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Wenn ausgewählt, werden Reisepunkte für die gegnerische Fraktion angezeigt.|n|nDies beinhaltet Flugpunkte, Bootshäfen, Zeppelintürme und Straßenbahnstationen."
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Wenn ausgewählt, werden Reisepunkte für die gleiche Fraktion angezeigt.|n|nDies beinhaltet Flugpunkte, Bootshäfen, Zeppelintürme und Straßenbahnstationen."
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "Wenn ausgewählt, werden unerforschte Gebiete der Karte auf der Weltkarte und der Schlachtfeldkarte angezeigt."
L["If checked, unexplored areas will be tinted."] = "Färbt die unentdeckten Gebiete auf der Weltkarte ein wenn aktiviert"
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Wenn aktiviert, wechselt die Karte automatisch die Zone sobald der Charakter die neue Zone betritt."
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "Wenn ausgewählt, kannst du die Schlachtfeldkarte verschieben, indem du einen ihrer Ränder ziehst.|n|nDu kannst die Schlachtfeldkarte vergrößern, indem du die untere rechte Ecke ziehst."
L["If checked, you will be able to customise the battlefield map."] = "Wenn diese Option aktiviert ist, können Sie die Schlachtfeldkarte anpassen."
L["If checked, you will be able to enlarge the player arrow."] = "Ermöglicht die Anpassug der Größe des Spielerpfeils wenn aktiviert."
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "Wenn ausgewählt, kannst du die Karte vergrößern, indem du den Skalenhandgriff in der unteren rechten Ecke ziehst.|n|nDu kannst die Karte verschieben, indem du einen beliebigen Rand ziehst.|n|nDu kannst immer den oberen Rand ziehen, um die Karte zu verschieben, unabhängig von dieser Einstellung."
L["If checked, you will be able to set the opacity of the map."] = "Ermöglicht die Transparenz der Weltkarte einzustellen wenn aktiviert."
L["If checked, you will be able to zoom further into the world map."] = "Wenn ausgewählt, kannst du weiter in die Weltkarte zoomen."
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "Wenn ausgewählt, werden die Dropdown-Menüs für Zone und Kontinent im Kartenrahmen angezeigt."
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "Wenn ausgewählt, werden Zonenübergänge angezeigt.|n|nDies sind anklickbare Pfeile, die die Wege zum Verlassen der Zone anzeigen."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Zeigt den Levelbereich für Zonen, Instanzen und Angelfertigkeiten an wenn aktiviert."
L["Increase zoom level"] = "Zoomstufe erhöhen"
L["Invalid command.  Enter /ltm help for help."] = "Unbekannter Befehl.  Schreibe  /ltm help  für weitere Befehle und hilfe."
L["Invalid command. Enter /ltm help for help."] = "Ungültiger Befehl. Gib /ltm help für Hilfe ein."
L["Invalid map ID."] = "Unbekannter Weltkarten-ID."
L["Ironforge"] = "Ironforge"
L["Isle of Quel'Danas"] = "Insel von Quel'Danas"
L["K3"] = "K3"
L["Kamagua"] = "Kamagua"
L["Karazhan"] = "Karazhan"
L["Kargath"] = "Kargath"
L["Kor'kron Vanguard"] = "Kor'kron Vorhut"
L["Lake Elune'ara"] = "Der Elune'ara See"
L["Lake Everstill"] = "Der Immerruhsee"
L["Large Scarab Coffer"] = "Großer Skarabäuskasten"
L["Leads to Tirisfal Glades"] = "Führt zu Tirisfal"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: FALSCHE VERSION INSTALLIERT!"
L["Light's Breach"] = "Lichtes Brachland"
L["Light's Hope Chapel"] = "Kapelle des hoffnungsvollen Lichts"
L["Loch Modan"] = "Loch Modan"
L["Lower Blackrock Spire"] = "Untere Blackrockspitze"
L["Magisters' Terrace"] = "Terrasse der Magister"
L["Magtheridon's Lair"] = "Magtheridons Kammer"
L["Mana-Tombs"] = "Managruft"
L["Map frame scale"] = "Kartenrandgröße"
L["Map Opacity"] = "Kartentransparenz"
L["Map Scale"] = "Kartenskalierung"
L["Map Size"] = "Kartengröße"
L["MapScale"] = "KartenSkalierung"
L["Maraudon"] = "Maraudon"
L["Marshal's Refuge"] = "Marshals Zuflucht"
L["Max Zoom"] = "Maximaler Zoom"
L["Maximum"] = "Maximum"
L["Mechanics"] = "Funktionen"
L["Memory Usage"] = "Speicherauslastung"
L["Menethil Harbor"] = "Der Hafen von Menethil"
L["Miscellaneous"] = "Sonstiger"
L["Moa'ki"] = "Moa'ki"
L["Moa'ki Harbor"] = "Hafen von Moa'ki"
L["Mok'Nathal Village"] = "Dorf der Mok'Nathal"
L["Molten Core"] = "Geschmolzener Kern"
L["Moonglade"] = "Moonglade"
L["More"] = "Mehr"
L["Morgan's Vigil"] = "Morgans Wacht"
L["Moving"] = "In Bewegung"
L["Mudsprocket"] = "Morastwinkel"
L["Mulgore"] = "Mulgore"
L["Nagrand"] = "Nagrand"
L["Naxxramas"] = "Naxxramas"
L["Nesingwary Base Camp"] = "Nesingwary-Basislager"
L["Nethergarde Keep"] = "Burg Nethergarde"
L["Netherstorm"] = "Nethersturm"
L["Never"] = "Nie"
L["New Agamand"] = "Neu-Agamand"
L["Nighthaven"] = "Nighthaven"
L["Nijel's Point"] = "Die Nijelspitze"
L["North"] = "Norden"
L["North Gate Pass"] = "Nordtorpass"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "HINWEIS!|nDu musst dein Spiel komplett neu bevor Du diese Version von Leatrix Maps benutzen kannst."
L["Old Hillsbrad"] = "Alt-Hügelbrad"
L["Old Hillsbrad Foothills"] = "Vorgebirge des Alten Hügellands"
L["Onyxia's Lair"] = "Onyxias Hort"
L["Opacity"] = "Transparenz"
L["or click the minimap button to open Leatrix Maps."] = "oder klicke auf den Button an der Minikarte."
L["Orb of Translocation"] = "Orb der Translokation"
L["Orebor Harborage"] = "Oreborzuflucht"
L["Orgrimmar"] = "Orgrimmar"
L["Player"] = "Spieler"
L["Player Arrow"] = "Spielerpfeil"
L["Portal"] = "Portal"
L["Portal from Zephyr"] = "Portal von Zephyr"
L["Portals"] = "Portale"
L["Preview"] = "Vorschau"
L["Ragefire Chasm"] = "Ragefireabgrund"
L["Raid"] = "Schlachtzug"
L["Ratchet"] = "Ratchet"
L["Ravenholdt Manor"] = "Rabenholdt-Anwesen"
L["Razorfen Downs"] = "Die Hügel von Razorfen"
L["Razorfen Kraul"] = "Der Kral von Razorfen"
L["Razorthorn Trail"] = "Dornenschlucht-Pfad"
L["Rebel Camp"] = "Rebellenlager"
L["Red"] = "Rot"
L["Redridge Mountains"] = "Rotkammgebirge"
L["Refuge Pointe"] = "Die Zuflucht"
L["Reload"] = "Neu laden (UI)"
L["Remember zoom level"] = "Zoomstufe merken"
L["Remove map border"] = "Kartenrand entfernen"
L["req"] = "Erfordert"
L["Requires Key to Searing Gorge"] = "Benötigt Schlüssel für Sengende Schlucht"
L["Requires UI reload."] = "Benötigt UI-Neuladen"
L["Reset"] = "Zurücksetzen"
L["Reset Map Layout"] = "Karte Zurücksetzen"
L["Revantusk Village"] = "Revantusk"
L["River's Heart"] = "Herz des Flusses"
L["Ruins of Ahn'Qiraj"] = "Ruinen von Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruinen von Elune'eth"
L["Rut'theran Village"] = "Rut'theran"
L["Rut'Theran Village"] = "Dorf Rut'theran"
L["Sanctum of the Stars"] = "Sanktum der Sterne"
L["Scale"] = "Größe"
L["Scarlet Monastery"] = "Das scharlachrote Kloster"
L["Scholomance"] = "Scholomance"
L["Searing Gorge"] = "Sengende Schlucht"
L["Seat of the Naaru"] = "Sitz der Naaru"
L["Sentinel Hill"] = "Späherkuppe"
L["Serpentshrine Cavern"] = "Höhle des Schlangenschreins"
L["Set map opacity"] = "Kartentransparenz"
L["Set map opacity while stationary and while moving."] = "Einstellung für die Transparenz der Weltkarte beim stehen und bewegen."
L["Set the group icon size."] = "Setzt die Gruppenicongröße"
L["Set the maximum zoom scale."] = "Stelle die maximale Zoomskala ein."
L["Set the player arrow size."] = "Stellt die Größe des Spielerpfeils ein."
L["Sethekk Halls"] = "Sethekkhallen"
L["Settings"] = "Einstellungen"
L["Sewers"] = "Kanäle"
L["Shadow Labyrinth"] = "Schattenlabyrinth"
L["Shadowfang Keep"] = "Burg Shadowfang"
L["Shadowmoon Valley"] = "Schattenmondtal"
L["Shadowmoon Village"] = "Schattenmond"
L["Shadowprey Village"] = "Shadowprey"
L["Shatter Point"] = "Bruchpunkt"
L["Shattrath"] = "Shattrath"
L["Shattrath City"] = "Shattrath Stadt"
L["Sholazar Basin"] = "Sholazarbecken"
L["Show boats, zeppelins and trams"] = "Boot, Zeppeline und Bahnen"
L["Show coordinates"] = "Zeige Koordinaten"
L["Show dungeons and raids"] = "Instanzen und Schlachtzüge"
L["Show minimap button"] = "Zeige minikarten button"
L["Show minimum fishing skill levels"] = "Zeige Angelfertigkeiten"
L["Show objectives"] = "Ziele anzeigen"
L["Show points of interest"] = "Zeige POI"
L["Show scale handle"] = "Zeige Größenregler"
L["Show spirit healers"] = "Zeige Geistheiler"
L["Show travel points for opposing faction"] = "Reisepunkte der gegnerischen Fraktion anzeigen"
L["Show travel points for same faction"] = "Reisepunkte der gleichen Fraktion anzeigen"
L["Show unexplored areas"] = "Zeige unentdeckte Gebiete"
L["Show zone crossings"] = "Zonenübergänge anzeigen"
L["Show zone levels"] = "Zeige Gebietsstufe"
L["Show zone menus"] = "Zonenmenüs anzeigen"
L["Silithus"] = "Silithus"
L["Silvermoon"] = "Silbermond"
L["Silvermoon City"] = "Silbermond"
L["Silverpine Forest"] = "Silberwald"
L["Slave Pens"] = "Sklavenunterkünfte"
L["South"] = "Süden"
L["South Gate Pass"] = "Südtorpass"
L["Southfury River"] = "Südstrom"
L["Southshore"] = "Southshore"
L["Spinebreaker Ridge"] = "Rückenbrechergrat"
L["Spirit Healer"] = "Geistheiler"
L["Splintertree Post"] = "Splintertreeposten"
L["Stars' Rest"] = "Sternenruh"
L["Stationary"] = "Stehend"
L["Steamvault"] = "Dampfkammer"
L["Sticky map frame"] = "Angeheftete Karte"
L["Stonard"] = "Stonard"
L["Stonebreaker Hold"] = "Steinbrecherfeste"
L["Stonetalon Mountains"] = "Steinkrallengebirge"
L["Stonetalon Peak"] = "Der Steinkrallengipfel"
L["Stormwind"] = "Stormwind"
L["Stormwind City"] = "Sturmwind"
L["Stranglethorn Vale"] = "Schlingendorntal"
L["Stratholme (Main Gate)"] = "Stratholme: Haupttor"
L["Stratholme (Service Gate)"] = "Stratholme: Dienstboteneingang"
L["sum"] = "Beschwörung"
L["Sun Rock Retreat"] = "Sonnenfels"
L["Sunreaver's Command"] = "Befehl der Sonnenhäscher"
L["Sun's Reach Harbor"] = "Hafen der Sonnenweiten"
L["Sunwell Plateau"] = "Sonnenbrunnenplateau"
L["Swamp of Sorrows"] = "Sümpfe des Elends"
L["Swamprat Post"] = "Sumpfrattenposten"
L["Sylvanaar"] = "Sylvanaar"
L["System"] = "System"
L["Talonbranch Glade"] = "Nachtlaublichtung"
L["Talrendis Point"] = "Talrendisspitze"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Tarrens Mühle"
L["Taunka'le Village"] = "Taunka'le-Dorf"
L["Telaar"] = "Telaar"
L["Teldrassil"] = "Teldrassil"
L["Teleport Crystal"] = "Teleportkristall"
L["Telredor"] = "Telredor"
L["Tempest Keep"] = "Die Festung der Stürme"
L["Temple of Ahn'Qiraj"] = "Tempel von Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Tempel von Atal'Hakkar"
L["Temple of Telhamat"] = "Tempel von Telhamat"
L["Terokkar Forest"] = "Wälder von Terokkar"
L["Thalanaar"] = "Thalanaar"
L["Thandol Span"] = "Thandol-Span"
L["The Arcatraz"] = "Die Arkatraz"
L["The Argent Stand"] = "Der Silberne Wachturm"
L["The Argent Vanguard"] = "Die Silberne Vorhut"
L["The Barrens"] = "Das Brachland"
L["The Blood Furnace"] = "Der Blutkessel"
L["The Botanica"] = "Die Botanika"
L["The Bulwark"] = "Die Barrikade"
L["The Crossroads"] = "Crossroads"
L["The Dark Portal"] = "Das Dunkle Portal"
L["The Deadmines"] = "Die Todesminen"
L["The Exodar"] = "Die Exodar"
L["The Eye"] = "Festung der Stürme"
L["The Eye of Eternity"] = "Das Auge der Ewigkeit"
L["The Forge of Souls"] = "Die Schmiede der Seelen"
L["The Forgotten Coast"] = "Die vergessene Küste"
L["The Frozen Halls"] = "Die Eiskronenzitadelle"
L["The Great Forge"] = "Die große Schmiede"
L["The Great Lift"] = "Der Große Aufzug"
L["The Halls of Reflection"] = "Die Hallen der Reflexion"
L["The Hinterlands"] = "Hinterland"
L["The Mechanar"] = "Die Mechanar"
L["The Nexus"] = "Der Nexus"
L["The Obsidian Sanctum"] = "Das Obsidiansanktum"
L["The Oculus"] = "Das Oculus"
L["The Old Kingdom"] = "Das Alte Königreich"
L["The Pit of Saron"] = "Die Grube von Saron"
L["The Ruby Sanctum"] = "Das Rubinheiligtum"
L["The Sepulcher"] = "Das Grabmal"
L["The Shadow Vault"] = "Das Schattengewölbe"
L["The Shattered Halls"] = "Die Zerschmetterten Hallen"
L["The Stockade"] = "Das Verlies"
L["The Storm Peaks"] = "Die Sturmgipfel"
L["The Stormspire"] = "Die Sturmsäule"
L["The Talondeep Path"] = "Der Talondeep-Pfad"
L["The Vault of Lights"] = "Der Lichterschrein"
L["The Violet Hold"] = "Die Violette Festung"
L["The Zoram Strand"] = "Der Zoramstrand"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Die Insel Theramore"
L["Thorium Point"] = "Thoriumspitze"
L["Thousand Needles"] = "Tausend Nadeln"
L["Thrallmar"] = "Thrallmar"
L["Thunder Bluff"] = "Thunder Bluff"
L["Thunderlord Stronghold"] = "Donnerfeste"
L["Timbermaw Hold"] = "Holzschlundfeste"
L["Tinker Town"] = "Tüftlerstadt"
L["Tint unexplored areas"] = "Färbung unentdeckter Gebiete"
L["Tirisfal Glades"] = "Tirisfal"
L["Toggle panel"] = "Schaltfläche umschalten"
L["Toshley's Station"] = "Toshleys Station"
L["Trade District"] = "Der Handelsdistrikt"
L["Trade Quarter"] = "Das Handelsviertel"
L["Tram to"] = "Bahn nach"
L["Tranquillien"] = "Tristessa"
L["Transitus Shield"] = "Transitus-Schild"
L["Transparency"] = "Transparenz"
L["Trial of the Champion"] = "Prüfung des Champions"
L["Trial of the Crusader"] = "Prüfung des Kreuzfahrers"
L["Twilight Shore"] = "Zwielichtstrand"
L["Twilight Vale"] = "Zwielichttal"
L["Uldaman"] = "Uldaman"
L["Uldaman (side entrance)"] = "Uldaman (Seiteneingang)"
L["Ulduar"] = "Ulduar"
L["Underbog"] = "Tiefensumpf"
L["Undercity"] = "Undercity"
L["Un'Goro Crater"] = "Un'Goro-Krater"
L["Unlock battlefield map"] = "Schlachtfeldkarte entsperren"
L["Unlock map frame"] = "Löst den Kartenrand"
L["Unu'pe"] = "Unu'pe"
L["Upper Blackrock Spire"] = "Obere Blackrockspitze"
L["Use default map"] = "Benutzt die standard karte"
L["Use stationary opacity while pointing at map"] = "Nutzt die 'Stehend'-Transparenz wenn euer Mauszeiger auf der Weltkarte ist."
L["Utgarde Keep"] = "Burg Utgarde"
L["Utgarde Pinnacle"] = "Spitze von Utgarde"
L["Valaar's Berth"] = "Valaars Steg"
L["Valgarde"] = "Valgarde"
L["Valgarde Port"] = "Hafen von Valgarde"
L["Valiance Keep"] = "Valianzfeste"
L["Valiance Landing Camp"] = "Valianzlandelager"
L["Valley of Strength"] = "Tal der Stärke"
L["Valormok"] = "Valormok"
L["Vault of Archavon"] = "Archavons Kammer"
L["Vengeance Landing"] = "Vengeance-Landung"
L["Venomspite"] = "Gallgrimm"
L["Version"] = "Version"
L["Wailing Caverns"] = "Die Höhlen des Wehklagens"
L["Warsong Camp"] = "Warsonglager"
L["Warsong Hold"] = "Warsongfeste"
L["Western Plaguelands"] = "Westliche Pestländer"
L["Westfall"] = "Westfall"
L["Westfall Brigade"] = "Westfallbrigade"
L["Westguard Keep"] = "Westwacht"
L["Wetlands"] = "Sumpfland"
L["Wildhammer Stronghold"] = "Wildhammerfeste"
L["Windrunner's Overlook"] = "Windläuferaussichtspunkt"
L["Wintergarde Keep"] = "Wintergarde"
L["Wintergrasp"] = "Wintergrasp"
L["Winterspring"] = "Winterspring"
L["Wrath of the Lich King Classic"] = "Der Zorn des Lichkönigs Klassik"
L["Wyrmrest Temple"] = "Tempel des Wyrmruh"
L["You will die!"] = "Du wirst sterben!"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Deine Benutzeroberfläche (UI) muss neu gestartet werden damit einige Einstellung in kraft treten.|n|nDu musst nicht sofort auf 'Neu laden (UI)' klicken aber am ende deiner Einstellungen solltest Du auf 'Neu laden (UI)' klicken damit alle Einstellungen auch wirksam werden."
L["Your UI needs to be reloaded."] = "UI neu laden."
L["Zabra'jin"] = "Zabra'jin"
L["Zangarmarsh"] = "Zangarmarschen"
L["Zeb'Sora"] = "Zeb'Sora"
L["Zeppelin to"] = "Zeppelin nach"
L["Zim'Torga"] = "Zim'Torga"
L["Zone Map"] = "Zonekarte"
L["Zoom"] = "Zoom"
L["Zoram'gar Outpost"] = "Zoram'gar-Außenposten"
L["Zul'Aman"] = "Zul'Aman"
L["Zul'Drak"] = "Zul'Drak"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end

-- esMX: Spanish (Mexico)
if GameLocale == "esMX" then
L["(destination only)"] = "(solo destino)"
L["(inside Caverns of Time)"] = "(dentro de Cavernas de Tiempo)"
L["/ltm help - Show this information."] = "/ltm help - Mostrar información."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Restablecer la posición del panel."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Borrar la configuración y recargar."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Se ha producido un error de detención, pero no hay que preocuparse. Puede suceder de vez en cuando. Haga clic en el botón de recarga para resolverlo."
L["A stop error has occurred but no need to worry. It can happen from time to time. Click the reload button to resolve it."] = "Se ha producido un error, pero no hay necesidad de preocuparse. Puede ocurrir de vez en cuando. Haz clic en el botón de recarga para resolverlo."
L["Acherus: The Ebon Hold"] = "Acherus: El Bastión de Ébano"
L["Aerie Peak"] = "Pico Nidal"
L["Agmar's Hammer"] = "El Martillo de Agmar"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Aldor"] = "Aldor"
L["Allerian Stronghold"] = "Bastión Allerian"
L["Alliance Cities"] = "Ciudades de la Alianza"
L["Alpha"] = "Alfa"
L["Altar of Sha'tar"] = "Altar de Sha'tar"
L["Alterac Mountains"] = "Montañas de Alterac"
L["Always"] = "Siempre"
L["Amber Lodge"] = "Refugio Ámbar"
L["Amberpine Lodge"] = "Refugio Pino Ámbar"
L["Apothecary Camp"] = "Campamento de los Alquimistas"
L["Appearance"] = "Apariencia"
L["Arathi Highlands"] = "Tierras Altas de Arathi"
L["Area 52"] = "Área 52"
L["Argent Tournament Grounds"] = "Campos de Torneo Argenta"
L["Ashenvale"] = "Vallefresno"
L["Astranaar"] = "Astranaar"
L["Auberdine"] = "Auberdine"
L["Auchenai Crypts"] = "Criptas Auchenai"
L["Auto change zones"] = "Cambiar zonas"
L["Azeroth"] = "Azeroth"
L["Azjol-Nerub"] = "Azjol-Nerub"
L["Azshara"] = "Azshara"
L["Azuremyst Isle"] = "Isla Bruma Azur"
L["Back to Main Menu"] = "Volver a menú principal"
L["Badlands"] = "Tierras Inhóspitas"
L["Battlegrounds"] = "Campos de Batalla"
L["Black Morass"] = "La Ciénaga Negra"
L["Black Temple"] = "Templo Oscuro"
L["Blackfathom Deeps"] = "Cavernas de Brazanegra"
L["Blackrock Depths"] = "Profundidades de Roca Negra"
L["Blackrock Mountain"] = "Montaña Roca Negra"
L["Blackwing Lair"] = "Guarida de Alanegra"
L["Blade Tooth Canyon"] = "Cañón Colmillo Cortante"
L["Blade's Edge Mountains"] = "Montañas Filospada"
L["Blades' Run"] = "Carrera de las Cuchillas"
L["Blasted Lands"] = "Las Tierras Devastadas"
L["Blood Watch"] = "Avanzada de Sangre"
L["Bloodmyst Isle"] = "Isla Bruma de Sangre"
L["Bloodvenom Post"] = "Puesto del Veneno"
L["Blue"] = "Azul"
L["Boat to"] = "Barco a"
L["Booty Bay"] = "Bahía del Botín"
L["Borean Tundra"] = "Tundra Boreal"
L["Bor'gorok Outpost"] = "Avanzada Bor'gorok"
L["Bouldercrag's Refuge"] = "Refugio de Peñapedriza"
L["Brackenwall Village"] = "Poblado Murohelecho"
L["Burning Crusade Classic"] = "Burning Crusade Clásico"
L["Burning Steppes"] = "Las Estepas Ardientes"
L["Camp Mojache"] = "Campamento Mojache"
L["Camp Oneqwah"] = "Campamento Oneqwah"
L["Camp Taurajo"] = "Campamento Taurajo"
L["Camp Tunka'lo"] = "Campamento Tunka'lo"
L["Camp Winterhoof"] = "Campamento Pezuña Invernal"
L["Caverns of Time"] = "Cavernas del Tiempo"
L["Cenarion Hold"] = "Fuerte Cenarion"
L["Center map on player"] = "Centrar mapa en el jugador"
L["Central Mesa"] = "Meseta Central"
L["Chillwind Camp"] = "Campamento del Orvallo"
L["Choose where the zone map should be shown."] = "Elige dónde se debe mostrar el mapa de zona."
L["Class colored icons"] = "Iconos coloreados"
L["Classic"] = "Clásico"
L["Click to configure the settings for this option."] = "Haga clic para configurar los ajustes para esta opción."
L["Click to reset the position and scale of the map frame."] = "Haga clic para restablecer la posición y la escala del marco del mapa."
L["Click to reset the settings on this page."] = "Haga clic para restablecer la configuración en esta página."
L["Click to return to the main menu."] = "Haga clic para volver al menú principal."
L["Coilfang Reservoir"] = "Reserva Colmillo Torcido"
L["Coldarra"] = "Frondavil"
L["Configuration Panel"] = "Panel de Configuración"
L["Conquest Hold"] = "Bastión de la Conquista"
L["Cosmic"] = "Cósmico"
L["Cosmowrench"] = "Cosmotirón"
L["Crusaders' Pinnacle"] = "Pináculo de los Cruzados"
L["Crystalsong Forest"] = "Bosque Canto de Cristal"
L["Culling of Stratholme"] = "Matanza de Stratholme"
L["Cursor"] = "Cursor"
L["Dalaran"] = "Dalaran"
L["Dalaran Crater"] = "Cráter de Dalaran"
L["Darkshire"] = "Villa Oscura"
L["Darkshore"] = "Costa Oscura"
L["Darnassus"] = "Darnassus"
L["Deadwind Pass"] = "Paso de la Muerte"
L["Death's Rise"] = "Alto de la Muerte"
L["Desolace"] = "Desolace"
L["Dire Maul (East)"] = "La Masacre (Este)"
L["Dire Maul (East) (side entrance)"] = "La Masacre (Este) (entrada lateral)"
L["Dire Maul (North)"] = "La Masacre (Norte)"
L["Dire Maul (West)"] = "La Masacre (Oeste)"
L["Disable reading emote when opening the map"] = "Deshabilita la lectura de emoticones al abrir el mapa"
L["Drag"] = "Arrastrar"
L["Drag to set the amount of blue."] = "Arrastra para establecer la cantidad de azul."
L["Drag to set the amount of green."] = "Arrastra para establecer la cantidad de verde."
L["Drag to set the amount of red."] = "Arrastra para establecer la cantidad de rojo."
L["Drag to set the battlefield map opacity."] = "Arrastra para establecer la opacidad del mapa de campo de batalla."
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "Arrastra para establecer el tamaño del mapa de campo de batalla.|n|nSi el mapa está desbloqueado, también puedes cambiar el tamaño del mapa de campo de batalla arrastrando la esquina inferior derecha."
L["Drag to set the group icon size."] = "Arrastra para establecer el tamaño del icono de grupo."
L["Drag to set the map opacity for when your character is moving."] = "Arrastra para establecer la opacidad del mapa para cuando su personaje se esté moviendo."
L["Drag to set the map opacity for when your character is stationary."] = "Arrastra para establecer la opacidad del mapa para cuando su personaje esté estacionario."
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "Arrastra para establecer el nivel máximo de zoom.|n|nAbre el mapa de campo de batalla para ver cómo cambia el nivel máximo de zoom mientras arrastras el control deslizante."
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "Arrastra para establecer el nivel máximo de zoom.|n|nAbre el mapa para ver cómo cambia el nivel máximo de zoom mientras arrastras el control deslizante."
L["Drag to set the opacity."] = "Arrastra para establecer la opacidad."
L["Drag to set the player arrow size."] = "Arrastra para establecer el tamaño de la flecha del jugador."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Arrastra para establecer el tamaño de la flecha del jugador.|n|nEl valor predeterminado de WoW Classic es 16.|nEl valor predeterminado de WoW Retail es 27."
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "Arrastra para establecer la escala del mapa del mundo.|n|nTambién puedes cambiar la escala del mapa del mundo arrastrando la esquina inferior derecha."
L["Dragonblight"] = "Cementerio de Dragones"
L["Drak'Tharon Keep"] = "Fortaleza de Drak'Tharon"
L["Druid only flight point to Darnassus"] = "Punto de vuelo a Darnassus solo para druidas"
L["Druid only flight point to Thunder Bluff"] = "Punto de vuelo a Cima del Trueno solo para druidas"
L["Dun Algaz"] = "Dun Algaz"
L["Dun Morogh"] = "Dun Morogh"
L["Dun Nifflelem"] = "Dun Niffelem"
L["Dungeon"] = "Calabozo"
L["Dungeon (requires Crescent Key)"] = "Mazmorra (requiere Llave Creciente)"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bosque del Ocaso"
L["Dustwallow Marsh"] = "Marjal Revolcafango"
L["Dwarven District"] = "Distrito de los Enanos"
L["Eastern Plaguelands"] = "Tierras de la Peste del Este"
L["Ebon Watch"] = "Vigía Ébano"
L["Elements"] = "Visibilidad"
L["Elwynn Forest"] = "Bosque de Elwynn"
L["Emerald Sanctuary"] = "Santuario Esmeralda"
L["Enhance battlefield map"] = "Mejorar el mapa del campo de batalla"
L["Enlarge player arrow"] = "Flecha de jugador"
L["Enter"] = "Entrar"
L["Evergrove"] = "Soto Eterno"
L["Everlook"] = "Vista Eterna"
L["Eversong Woods"] = "Bosque Canción Eterna"
L["Exodar"] = "El Exodar"
L["Falcon Watch"] = "Avanzada del Halcón"
L["Feathermoon Stronghold"] = "Bastión Plumaluna"
L["Felwood"] = "Frondavil"
L["Feralas"] = "Feralas"
L["Fishing"] = "Pesca"
L["Fizzcrank Airstrip"] = "Aeródromo Trinquete"
L["Flame Crest"] = "Peñasco Llamarada"
L["Fordragon Hold"] = "Fortaleza Fordragón"
L["Forest Song"] = "Canción del Bosque"
L["Fort Wildervar"] = "Fortaleza Varabarba"
L["Freewind Post"] = "Poblado Viento Libre"
L["Frosthold"] = "Bastión de Escarcha"
L["Gadgetzan"] = "Gadgetzan"
L["Garadar"] = "Garadar"
L["Ghostlands"] = "Tierras Fantasma"
L["Gnomeregan"] = "Gnomeregan"
L["Green"] = "Verde"
L["Grizzly Hills"] = "Colinas Pardas"
L["Grom'arsh Crash Site"] = "Lugar del Accidente de Grom'arsh"
L["Grom'gol Base Camp"] = "Campamento Grom'gol"
L["Group Icons"] = "Iconos de grupo"
L["Gruul's Lair"] = "Guarida de Gruul"
L["Gundrak"] = "Gundrak"
L["Gundrak (rear entrance)"] = "Gundrak (entrada trasera)"
L["Halls of Lightning"] = "Salones Relámpago"
L["Halls of Stone"] = "Salones de Piedra"
L["Hammerfall"] = "Sentencia"
L["Head down the mountain from here."] = "Dirígete hacia abajo desde la montaña aquí."
L["Head southeast from here and go up the mountain."] = "Dirígete al sureste desde aquí y sube la montaña."
L["Hellfire Peninsula"] = "Península del Fuego Infernal"
L["Hellfire Ramparts"] = "Murallas del Fuego Infernal"
L["Hide town and city icons"] = "Pueblos y ciudades"
L["Hillsbrad Foothills"] = "Laderas de Trabalomas"
L["Honor Hold"] = "Bastión del Honor"
L["Horde Cities"] = "Ciudades de la Horda"
L["Howling Fjord"] = "Fiordo Aquilonal"
L["Hyjal Summit"] = "La Cima Hyjal"
L["Icecrown"] = "Corona de Hielo"
L["Icecrown Citadel"] = "Ciudadela de la Corona de Hielo"
L["Icons"] = "Iconos"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "Si está seleccionado, se mostrarán los puertos de los barcos, las torres de los zepelines y las estaciones de tranvía."
L["If checked, coordinates will be shown."] = "Si está seleccionado, se mostrarán las coordenadas."
L["If checked, dungeons and raids will be shown."] = "Si está seleccionado, se mostrarán calabozos y bandas."
L["If checked, group icons will use a modern, class-colored design."] = "Si está seleccionado, los iconos de grupo usarán un diseño moderno, de color de clase."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Si está seleccionado, al abrir el mapa se usará el mismo nivel de zoom desde la última vez que lo cerró, siempre que la zona del mapa no haya cambiado."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Si está seleccionado, apuntar al mapa mientras tu personaje se mueve hará que se aplique la configuración de opacidad estacionaria."
L["If checked, points of interest will be shown."] = "Si está seleccionado, se mostrarán puntos de interés."
L["If checked, quest objectives will be shown."] = "Si está marcado, se mostrarán los objetivos de misión."
L["If checked, spirit healers will be shown."] = "Si está seleccionado, se mostrarán los Ángeles de la Resurrección."
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Si está marcado, el mapa de campo de batalla se mantendrá centrado en tu ubicación siempre que no estés en una mazmorra.|n|nPuedes mantener presionada la tecla Mayús mientras desplazas el mapa para evitar que se centre temporalmente."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Si está seleccionado, se usará el mapa predeterminado de pantalla completa.|n|nTenga en cuenta que habilitar esta opción bloqueará algunas de las otras opciones."
L["If checked, the map border will be removed."] = "Si está seleccionado, se eliminará el borde del mapa."
L["If checked, the map frame will remain open until you close it."] = "Si está seleccionado, el marco del mapa permanecerá abierto hasta que lo cierre."
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Si está marcado, el mapa se mantendrá centrado en tu ubicación siempre que no estés en una mazmorra.|n|nPuedes mantener presionada la tecla Mayús mientras desplazas el mapa para evitar que se centre temporalmente."
L["If checked, the minimap button will be shown."] = "Si está seleccionado, se mostrará el botón del minimapa."
L["If checked, the minimum fishing skill levels will be shown."] = "Si está seleccionado, se mostrarán los niveles mínimos de habilidad de pesca."
L["If checked, town and city icons will not be shown on the continent maps."] = "Si está seleccionado, los iconos de pueblos y ciudades no se mostrarán en los mapas continentes."
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Si está marcado, se mostrarán los puntos de viaje de la facción opuesta.|n|nEsto incluye puntos de vuelo, puertos de barcos, torres de zepelín y estaciones de tranvía."
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Si está marcado, se mostrarán los puntos de viaje para la misma facción.|n|nEsto incluye puntos de vuelo, puertos de barcos, torres de zepelín y estaciones de tranvía."
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "Si está marcado, se mostrarán áreas inexploradas del mapa en el mapa del mundo y en el mapa de campo de batalla."
L["If checked, unexplored areas will be tinted."] = "Si está seleccionado, las áreas inexploradas se teñirán."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Si está seleccionado, cuando tu personaje cambia de zona, el mapa cambiará automáticamente a la nueva zona."
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "Si está marcado, puedes mover el mapa de campo de batalla arrastrando cualquiera de sus bordes.|n|nPuedes cambiar el tamaño del mapa de campo de batalla arrastrando la esquina inferior derecha."
L["If checked, you will be able to customise the battlefield map."] = "Si está seleccionado, podrás personalizar el mapa del campo de batalla."
L["If checked, you will be able to enlarge the player arrow."] = "Si está seleccionado, podrá ampliar la flecha del jugador."
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "Si está marcado, podrás cambiar la escala del mapa arrastrando la manija de escala en la esquina inferior derecha.|n|nPuedes mover el mapa arrastrando cualquier borde.|n|nSiempre puedes arrastrar el borde superior para mover el mapa independientemente de esta configuración."
L["If checked, you will be able to set the opacity of the map."] = "Si está seleccionado, podrá establecer la opacidad del mapa."
L["If checked, you will be able to zoom further into the world map."] = "Si está marcado, podrás acercarte más al mapa del mundo."
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "Si está marcado, se mostrarán los menús desplegables de zona y continente en el marco del mapa."
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "Si está marcado, se mostrarán los cruces de zona.|n|nEstas son flechas clicables que indican las salidas de la zona."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Si está seleccionado, se mostrarán los niveles de zona, calabozo y habilidad de pesca."
L["Increase zoom level"] = "Aumentar nivel de zoom"
L["Invalid command.  Enter /ltm help for help."] = "Comando inválido. Escribe / ltm help para obtener ayuda."
L["Invalid command. Enter /ltm help for help."] = "Comando inválido. Ingresa /ltm ayuda para obtener ayuda."
L["Invalid map ID."] = "ID de mapa inválido."
L["Ironforge"] = "Forjaz"
L["Isle of Quel'Danas"] = "Isla de Quel'Danas"
L["K3"] = "K3"
L["Kamagua"] = "Kamagua"
L["Karazhan"] = "Karazhan"
L["Kargath"] = "Kargath"
L["Kor'kron Vanguard"] = "Vanguardia Kor'kron"
L["Lake Elune'ara"] = "Lago Elune'ara"
L["Lake Everstill"] = "Lago Sempiterno"
L["Large Scarab Coffer"] = "Arca del escarabajo grande"
L["Leads to Tirisfal Glades"] = "Conduce a Claros de Tirisfal"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: ¡VERSIÓN INCORRECTA INSTALADA!"
L["Light's Breach"] = "Brecha de la Luz"
L["Light's Hope Chapel"] = "Capilla de la Esperanza de la Luz"
L["Loch Modan"] = "Loch Modan"
L["Lower Blackrock Spire"] = "Cumbre de Roca Negra Inferior"
L["Magisters' Terrace"] = "Bancal del Magister"
L["Magtheridon's Lair"] = "Guarida de Magtheridon"
L["Mana-Tombs"] = "Tumbas de Maná"
L["Map frame scale"] = "Escala del marco del mapa"
L["Map Opacity"] = "Opacidad de mapa"
L["Map Scale"] = "Escala del Mapa"
L["Map Size"] = "Tamaño de mapa"
L["MapScale"] = "Escala del Mapa"
L["Maraudon"] = "Maraudon"
L["Marshal's Refuge"] = "Refugio de Marshal"
L["Max Zoom"] = "Zoom Máximo"
L["Maximum"] = "Máximo"
L["Mechanics"] = "Mecánicas"
L["Memory Usage"] = "Uso de memoria"
L["Menethil Harbor"] = "Puerto de Menethil"
L["Miscellaneous"] = "Miscelánea"
L["Moa'ki"] = "Moa'ki"
L["Moa'ki Harbor"] = "Puerto de Moa'ki"
L["Mok'Nathal Village"] = "Aldea Mok'Nathal"
L["Molten Core"] = "Núcleo de Magma"
L["Moonglade"] = "Claro de la Luna"
L["More"] = "Más"
L["Morgan's Vigil"] = "Vigilia de Morgan"
L["Moving"] = "Movimiento"
L["Mudsprocket"] = "Piñón de Barro"
L["Mulgore"] = "Mulgore"
L["Nagrand"] = "Nagrand"
L["Naxxramas"] = "Naxxramas"
L["Nesingwary Base Camp"] = "Campamento Base de Nesingwary"
L["Nethergarde Keep"] = "Castillo de Nethergarde"
L["Netherstorm"] = "Tormenta Abisal"
L["Never"] = "Nunca"
L["New Agamand"] = "Nuevo Agamand"
L["Nighthaven"] = "Amparo de la Noche"
L["Nijel's Point"] = "Punta de Nijel"
L["North"] = "Norte"
L["North Gate Pass"] = "Paso de la Puerta Norte"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "¡ATENCIÓN!|nDebes reiniciar completamente tu cliente de juego antes de poder usar esta versión de Leatrix Maps."
L["Old Hillsbrad"] = "Antiguo Hillsbrad"
L["Old Hillsbrad Foothills"] = "Antiguas Laderas de Trabalomas"
L["Onyxia's Lair"] = "Guarida de Onyxia"
L["Opacity"] = "Opacidad"
L["or click the minimap button to open Leatrix Maps."] = "o haga clic en el botón de minimapa para abrir Leatrix Maps."
L["Orb of Translocation"] = "Orbe de Translocación"
L["Orebor Harborage"] = "Puerto Orebor"
L["Orgrimmar"] = "Orgrimmar"
L["Player"] = "Jugador"
L["Player Arrow"] = "Flecha de jugador"
L["Portal"] = "Portal"
L["Portal from Zephyr"] = "Portal de Céfiro"
L["Portals"] = "Portales"
L["Preview"] = "Prevista"
L["Ragefire Chasm"] = "Sima Ígnea"
L["Raid"] = "Banda"
L["Ratchet"] = "Trinquete"
L["Ravenholdt Manor"] = "Mansión Ravenholdt"
L["Razorfen Downs"] = "Zahúrda Rajacieno"
L["Razorfen Kraul"] = "Horado Rajacieno"
L["Razorthorn Trail"] = "Senda Espina Afilada"
L["Rebel Camp"] = "Asentamiento Rebelde"
L["Red"] = "Rojo"
L["Redridge Mountains"] = "Montañas Crestagrana"
L["Refuge Pointe"] = "Refugio de la Zaga"
L["Reload"] = "Recargar"
L["Remember zoom level"] = "Recordar nivel de zoom"
L["Remove map border"] = "Borde del mapa"
L["req"] = "req"
L["Requires Key to Searing Gorge"] = "Requiere Llave para La Garganta de Fuego"
L["Requires UI reload."] = "Requiere recargar la IU"
L["Reset"] = "Restablecer"
L["Reset Map Layout"] = "Restablecer el diseño del mapa"
L["Revantusk Village"] = "Poblado Sañadiente"
L["River's Heart"] = "Corazón del Río"
L["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruinas de Elune'eth"
L["Rut'theran Village"] = "Aldea Rut'theran"
L["Rut'Theran Village"] = "Poblado Rut'theran"
L["Sanctum of the Stars"] = "Sagrario de las Estrellas"
L["Scale"] = "Escala"
L["Scarlet Monastery"] = "Monasterio Escarlata"
L["Scholomance"] = "Scholomance"
L["Searing Gorge"] = "La Garganta de Fuego"
L["Seat of the Naaru"] = "Asiento de los Naaru"
L["Sentinel Hill"] = "Colina del Centinela"
L["Serpentshrine Cavern"] = "Caverna Santuario Serpiente"
L["Set map opacity"] = "Opacidad del mapa"
L["Set map opacity while stationary and while moving."] = "Establece la opacidad del mapa mientras está parado y en movimiento."
L["Set the group icon size."] = "Establece el tamaño del icono de grupo."
L["Set the maximum zoom scale."] = "Establece la escala máxima de zoom."
L["Set the player arrow size."] = "Establece el tamaño de la flecha del jugador."
L["Sethekk Halls"] = "Salas Sethekk"
L["Settings"] = "Configuración"
L["Sewers"] = "Cloacas"
L["Shadow Labyrinth"] = "Laberinto de las Sombras"
L["Shadowfang Keep"] = "Castillo de Colmillo Oscuro"
L["Shadowmoon Valley"] = "Valle Sombraluna"
L["Shadowmoon Village"] = "Aldea Sombraluna"
L["Shadowprey Village"] = "Aldea Cazasombras"
L["Shatter Point"] = "Punto de Ruptura"
L["Shattrath"] = "Shattrath"
L["Shattrath City"] = "Ciudad de Shattrath"
L["Sholazar Basin"] = "Cuenca de Sholazar"
L["Show boats, zeppelins and trams"] = "Mostrar barcos, zepelines y tranvías"
L["Show coordinates"] = "Coordenadas"
L["Show dungeons and raids"] = "Mostrar calabozos y bandas"
L["Show minimap button"] = "Botón del minimapa"
L["Show minimum fishing skill levels"] = "Mostrar niveles mínimos de habilidad de pesca"
L["Show objectives"] = "Mostrar objetivos"
L["Show points of interest"] = "Puntos de interés"
L["Show scale handle"] = "Mostrar asa de escala"
L["Show spirit healers"] = "Mostrar Ángel de la Resurrección"
L["Show travel points for opposing faction"] = "Mostrar puntos de viaje de la facción opuesta"
L["Show travel points for same faction"] = "Mostrar puntos de viaje para la misma facción"
L["Show unexplored areas"] = "Áreas inexploradas"
L["Show zone crossings"] = "Mostrar cruces de zona"
L["Show zone levels"] = "Nivel de zona"
L["Show zone menus"] = "Mostrar menús de zona"
L["Silithus"] = "Silithus"
L["Silvermoon"] = "Entrañas"
L["Silvermoon City"] = "Ciudad de Lunargenta"
L["Silverpine Forest"] = "Bosque de Argénteos"
L["Slave Pens"] = "Recinto de los Esclavos"
L["South"] = "Sur"
L["South Gate Pass"] = "Paso de la Puerta Sur"
L["Southfury River"] = "Río Furia del Sur"
L["Southshore"] = "Costasur"
L["Spinebreaker Ridge"] = "Cresta Rompeloma"
L["Spirit Healer"] = "Ángel de la Resurrección"
L["Splintertree Post"] = "Puesto del Hachazo"
L["Stars' Rest"] = "Reposo de las Estrellas"
L["Stationary"] = "Estacionario"
L["Steamvault"] = "La Cámara de Vapor"
L["Sticky map frame"] = "Mapa pegajoso"
L["Stonard"] = "Rocal"
L["Stonebreaker Hold"] = "Bastión Rompepedras"
L["Stonetalon Mountains"] = "Sierra Espolón"
L["Stonetalon Peak"] = "Cima del Espolón"
L["Stormwind"] = "Ventormenta"
L["Stormwind City"] = "Ciudad de Ventormenta"
L["Stranglethorn Vale"] = "Vega de Tuercespina"
L["Stratholme (Main Gate)"] = "Stratholme: Entrada Principal"
L["Stratholme (Service Gate)"] = "Stratholme: Entrada de Servicio"
L["sum"] = "invo"
L["Sun Rock Retreat"] = "Refugio Roca del Sol"
L["Sunreaver's Command"] = "Mando de los Atracasol"
L["Sun's Reach Harbor"] = "Puerto Alcance del Sol"
L["Sunwell Plateau"] = "Meseta de La Fuente del Sol"
L["Swamp of Sorrows"] = "Pantanos de las Penas"
L["Swamprat Post"] = "Avanzada Rata del Pantano"
L["Sylvanaar"] = "Sylvanaar"
L["System"] = "Sistema"
L["Talonbranch Glade"] = "Claro Ramaespolón"
L["Talrendis Point"] = "Punta Talrendis"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Molino Tarren"
L["Taunka'le Village"] = "Poblado Taunka'le"
L["Telaar"] = "Telaar"
L["Teldrassil"] = "Teldrassil"
L["Teleport Crystal"] = "Cristal de Teletransporte"
L["Telredor"] = "Telredor"
L["Tempest Keep"] = "El Castillo de la Tempestad"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Temple of Telhamat"] = "Templo de Telhamat"
L["Terokkar Forest"] = "Bosque de Terokkar"
L["Thalanaar"] = "Thalanaar"
L["Thandol Span"] = "Puente Thandol"
L["The Arcatraz"] = "El Arcatraz"
L["The Argent Stand"] = "El Bastión Argenta"
L["The Argent Vanguard"] = "La Vanguardia Argenta"
L["The Barrens"] = "Los Baldíos"
L["The Blood Furnace"] = "El Horno de Sangre"
L["The Botanica"] = "El Invernáculo"
L["The Bulwark"] = "El Bastión"
L["The Crossroads"] = "El Cruce"
L["The Dark Portal"] = "El Portal Oscuro"
L["The Deadmines"] = "Las Minas de la Muerte"
L["The Exodar"] = "El Exodar"
L["The Eye"] = "El Ojo"
L["The Eye of Eternity"] = "El Ojo de la Eternidad"
L["The Forge of Souls"] = "La Forja de Almas"
L["The Forgotten Coast"] = "La Costa Olvidada"
L["The Frozen Halls"] = "Las Cámaras Heladas"
L["The Great Forge"] = "La Gran Fundición"
L["The Great Lift"] = "El Gran Ascensor"
L["The Halls of Reflection"] = "Las Cámaras de Reflexión"
L["The Hinterlands"] = "Tierras del Interior"
L["The Mechanar"] = "El Mechanar"
L["The Nexus"] = "El Nexo"
L["The Obsidian Sanctum"] = "El Sagrario Obsidiana"
L["The Oculus"] = "El Oculus"
L["The Old Kingdom"] = "El Reino Viejo"
L["The Pit of Saron"] = "El Foso de Saron"
L["The Ruby Sanctum"] = "El Sagrario Rubí"
L["The Sepulcher"] = "El Sepulcro"
L["The Shadow Vault"] = "La Bóveda de las Sombras"
L["The Shattered Halls"] = "Las Salas Arrasadas"
L["The Stockade"] = "Las Mazmorras"
L["The Storm Peaks"] = "Las Cumbres Tormentosas"
L["The Stormspire"] = "Flecha de la Tormenta"
L["The Talondeep Path"] = "El Sendero Talondeep"
L["The Vault of Lights"] = "La Bóveda de las Luces"
L["The Violet Hold"] = "El Bastión Violeta"
L["The Zoram Strand"] = "La Playa de Zoram"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Isla Theramore"
L["Thorium Point"] = "Puesto del Torio"
L["Thousand Needles"] = "Las Mil Agujas"
L["Thrallmar"] = "Thrallmar"
L["Thunder Bluff"] = "Cima del Trueno"
L["Thunderlord Stronghold"] = "Bastión Señor del Trueno"
L["Timbermaw Hold"] = "El Bastión Fauces de Madera"
L["Tinker Town"] = "Ciudad Manitas"
L["Tint unexplored areas"] = "Teñir áreas inexploradas"
L["Tirisfal Glades"] = "Claros de Tirisfal"
L["Toggle panel"] = "Alternar panel"
L["Toshley's Station"] = "Estación de Toshley"
L["Trade District"] = "Distrito de Mercaderes"
L["Trade Quarter"] = "Barrio del Comercio"
L["Tram to"] = "Tranvía a"
L["Tranquillien"] = "Tranquillien"
L["Transitus Shield"] = "Escudo de Transitus"
L["Transparency"] = "Transparencia"
L["Trial of the Champion"] = "Prueba del Campeón"
L["Trial of the Crusader"] = "Prueba del Cruzado"
L["Twilight Shore"] = "Costa Crepuscular"
L["Twilight Vale"] = "Valle Crepuscular"
L["Uldaman"] = "Uldaman"
L["Uldaman (side entrance)"] = "Uldaman (entrada lateral)"
L["Ulduar"] = "Ulduar"
L["Underbog"] = "La Sotiénaga"
L["Undercity"] = "Entrañas"
L["Un'Goro Crater"] = "Cráter de Un'Goro"
L["Unlock battlefield map"] = "Desbloquear mapa de campo de batalla"
L["Unlock map frame"] = "Desbloquear mapa"
L["Unu'pe"] = "Unu'pe"
L["Upper Blackrock Spire"] = "Cumbre de Roca Negra Superior"
L["Use default map"] = "Mapa predeterminado"
L["Use stationary opacity while pointing at map"] = "Usa opacidad estacionaria mientras apunta al mapa"
L["Utgarde Keep"] = "Fortaleza Utgarde"
L["Utgarde Pinnacle"] = "Pináculo de Utgarde"
L["Valaar's Berth"] = "Atracadero de Valaar"
L["Valgarde"] = "Valgarde"
L["Valgarde Port"] = "Puerto Valgarde"
L["Valiance Keep"] = "Fortaleza de Valiance"
L["Valiance Landing Camp"] = "Campamento de Aterrizaje de Valiance"
L["Valley of Strength"] = "El Valle de la Fuerza"
L["Valormok"] = "Valormok"
L["Vault of Archavon"] = "La Cámara de Archavon"
L["Vengeance Landing"] = "Desembarco de la Venganza"
L["Venomspite"] = "Peste Venenosa"
L["Version"] = "Versión"
L["Wailing Caverns"] = "Cuevas de los Lamentos"
L["Warsong Camp"] = "Campamento Grito de Guerra"
L["Warsong Hold"] = "Bastión Grito de Guerra"
L["Western Plaguelands"] = "Tierras de la Peste del Oeste"
L["Westfall"] = "Páramos de Poniente"
L["Westfall Brigade"] = "Brigada Trabaloma"
L["Westguard Keep"] = "Fortaleza de la Guardia Oeste"
L["Wetlands"] = "Los Humedales"
L["Wildhammer Stronghold"] = "Bastión Martillo Salvaje"
L["Windrunner's Overlook"] = "Mirador de Brisaveloz"
L["Wintergarde Keep"] = "Fortaleza de Invierno"
L["Wintergrasp"] = "Cuenca de Invierno"
L["Winterspring"] = "Cuna del Invierno"
L["Wrath of the Lich King Classic"] = "Clásico: Ira del Rey Exánime"
L["Wyrmrest Temple"] = "Templo del Reposo del Dragón"
L["You will die!"] = "¡Morirás!"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Su IU necesita ser recargada para que algunos de los cambios surtan efecto.|n|nNo tiene que hacer clic en el botón de recarga de inmediato, pero debe hacer clic en él cuando haya terminado de hacer cambios y desea que los cambios surtan efecto."
L["Your UI needs to be reloaded."] = "La IU necesita ser recargada."
L["Zabra'jin"] = "Zabra'jin"
L["Zangarmarsh"] = "Marisma de Zangar"
L["Zeb'Sora"] = "Zeb'Sora"
L["Zeppelin to"] = "Zepelín a"
L["Zim'Torga"] = "Zim'Torga"
L["Zone Map"] = "Mapa de Zona"
L["Zoom"] = "Zoom"
L["Zoram'gar Outpost"] = "Ensenada de Zoram'gar"
L["Zul'Aman"] = "Zul'Aman"
L["Zul'Drak"] = "Zul'Drak"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end

-- esES: Spanish (Spain)
if GameLocale == "esES" then
L["(destination only)"] = "(solo destino)"
L["(inside Caverns of Time)"] = "(dentro de Cavernas de Tiempo)"
L["/ltm help - Show this information."] = "/ltm help - Mostrar información."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Restablecer la posición del panel."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Borrar la configuración y recargar."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Se ha producido un error de detención, pero no hay que preocuparse. Puede suceder de vez en cuando. Haga clic en el botón de recarga para resolverlo."
L["A stop error has occurred but no need to worry. It can happen from time to time. Click the reload button to resolve it."] = "Ha ocurrido un error de detención, pero no te preocupes. Puede suceder de vez en cuando. Haz clic en el botón de recarga para resolverlo."
L["Acherus: The Ebon Hold"] = "Acherus: El Bastión de Ébano"
L["Aerie Peak"] = "Pico Nidal"
L["Agmar's Hammer"] = "Martillo de Agmar"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Aldor"] = "Aldor"
L["Allerian Stronghold"] = "Bastión Allerian"
L["Alliance Cities"] = "Ciudades de la Alianza"
L["Alpha"] = "Alfa"
L["Altar of Sha'tar"] = "Altar de Sha'tar"
L["Alterac Mountains"] = "Montañas de Alterac"
L["Always"] = "Siempre"
L["Amber Lodge"] = "Refugio Ámbar"
L["Amberpine Lodge"] = "Refugio Pino Ámbar"
L["Apothecary Camp"] = "Campamento del Apotecario"
L["Appearance"] = "Apariencia"
L["Arathi Highlands"] = "Tierras Altas de Arathi"
L["Area 52"] = "Área 52"
L["Argent Tournament Grounds"] = "Campos del Torneo Argenta"
L["Ashenvale"] = "Vallefresno"
L["Astranaar"] = "Astranaar"
L["Auberdine"] = "Auberdine"
L["Auchenai Crypts"] = "Criptas Auchenai"
L["Auto change zones"] = "Cambiar zonas"
L["Azeroth"] = "Azeroth"
L["Azjol-Nerub"] = "Azjol-Nerub"
L["Azshara"] = "Azshara"
L["Azuremyst Isle"] = "Isla Bruma Azur"
L["Back to Main Menu"] = "Volver a menú principal"
L["Badlands"] = "Tierras Inhóspitas"
L["Battlegrounds"] = "Campos de Batalla"
L["Black Morass"] = "La Ciénaga Negra"
L["Black Temple"] = "Templo Oscuro"
L["Blackfathom Deeps"] = "Cavernas de Brazanegra"
L["Blackrock Depths"] = "Profundidades de Roca Negra"
L["Blackrock Mountain"] = "Montaña Roca Negra"
L["Blackwing Lair"] = "Guarida de Alanegra"
L["Blade Tooth Canyon"] = "Cañón Colmillo Afilado"
L["Blade's Edge Mountains"] = "Montañas Filospada"
L["Blades' Run"] = "Tramo de las Hojas"
L["Blasted Lands"] = "Las Tierras Devastadas"
L["Blood Watch"] = "Avanzada de Sangre"
L["Bloodmyst Isle"] = "Isla Bruma de Sangre"
L["Bloodvenom Post"] = "Puesto del Veneno"
L["Blue"] = "Azul"
L["Boat to"] = "Barco a"
L["Booty Bay"] = "Bahía del Botín"
L["Borean Tundra"] = "Tundra Boreal"
L["Bor'gorok Outpost"] = "Avanzada Bor'gorok"
L["Bouldercrag's Refuge"] = "Refugio Rocañón"
L["Brackenwall Village"] = "Poblado Murohelecho"
L["Burning Crusade Classic"] = "Burning Crusade Clásico"
L["Burning Steppes"] = "Las Estepas Ardientes"
L["Camp Mojache"] = "Campamento Mojache"
L["Camp Oneqwah"] = "Campamento Oneqwah"
L["Camp Taurajo"] = "Campamento Taurajo"
L["Camp Tunka'lo"] = "Campamento Tunka'lo"
L["Camp Winterhoof"] = "Campamento Pezuña Invernal"
L["Caverns of Time"] = "Cavernas del Tiempo"
L["Cenarion Hold"] = "Fuerte Cenarion"
L["Center map on player"] = "Centrar mapa en el jugador"
L["Central Mesa"] = "Meseta Central"
L["Chillwind Camp"] = "Campamento del Orvallo"
L["Choose where the zone map should be shown."] = "Elige dónde se debe mostrar el mapa de la zona."
L["Class colored icons"] = "Iconos coloreados"
L["Classic"] = "Clásico"
L["Click to configure the settings for this option."] = "Haga clic para configurar los ajustes para esta opción."
L["Click to reset the position and scale of the map frame."] = "Haga clic para restablecer la posición y la escala del marco del mapa."
L["Click to reset the settings on this page."] = "Haga clic para restablecer la configuración en esta página."
L["Click to return to the main menu."] = "Haga clic para volver al menú principal."
L["Coilfang Reservoir"] = "Reserva Colmillo Torcido"
L["Coldarra"] = "Gelidar"
L["Configuration Panel"] = "Panel de Configuración"
L["Conquest Hold"] = "Fortaleza Conquista"
L["Cosmic"] = "Cósmico"
L["Cosmowrench"] = "Cosmotirón"
L["Crusaders' Pinnacle"] = "Cima de los Cruzados"
L["Crystalsong Forest"] = "Bosque Canto Cristalino"
L["Culling of Stratholme"] = "El Asedio de Stratholme"
L["Cursor"] = "Cursor"
L["Dalaran"] = "Dalaran"
L["Dalaran Crater"] = "Cráter de Dalaran"
L["Darkshire"] = "Villa Oscura"
L["Darkshore"] = "Costa Oscura"
L["Darnassus"] = "Darnassus"
L["Deadwind Pass"] = "Paso de la Muerte"
L["Death's Rise"] = "Ascenso de la Muerte"
L["Desolace"] = "Desolace"
L["Dire Maul (East)"] = "La Masacre (Este)"
L["Dire Maul (East) (side entrance)"] = "La Masacre (Este) (entrada lateral)"
L["Dire Maul (North)"] = "La Masacre (Norte)"
L["Dire Maul (West)"] = "La Masacre (Oeste)"
L["Disable reading emote when opening the map"] = "Deshabilita la lectura de emoticones al abrir el mapa"
L["Drag"] = "Arrastrar"
L["Drag to set the amount of blue."] = "Arrastra para establecer la cantidad de azul."
L["Drag to set the amount of green."] = "Arrastra para establecer la cantidad de verde."
L["Drag to set the amount of red."] = "Arrastra para establecer la cantidad de rojo."
L["Drag to set the battlefield map opacity."] = "Arrastra para establecer la opacidad del mapa de campo de batalla."
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "Arrastra para establecer el tamaño del mapa de campo de batalla.|n|nSi el mapa está desbloqueado, también puedes redimensionar el mapa de campo de batalla arrastrando la esquina inferior derecha."
L["Drag to set the group icon size."] = "Arrastra para establecer el tamaño del icono de grupo."
L["Drag to set the map opacity for when your character is moving."] = "Arrastra para establecer la opacidad del mapa para cuando su personaje se esté moviendo."
L["Drag to set the map opacity for when your character is stationary."] = "Arrastra para establecer la opacidad del mapa para cuando su personaje esté estacionario."
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "Arrastra para establecer el nivel máximo de zoom.|n|nAbre el mapa de campo de batalla para ver cómo cambia el nivel máximo de zoom mientras arrastras el control deslizante."
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "Arrastra para establecer el nivel máximo de zoom.|n|nAbre el mapa para ver cómo cambia el nivel máximo de zoom mientras arrastras el control deslizante."
L["Drag to set the opacity."] = "Arrastra para establecer la opacidad."
L["Drag to set the player arrow size."] = "Arrastra para establecer el tamaño de la flecha del jugador."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Arrastra para establecer el tamaño de la flecha del jugador.|n|nEl valor predeterminado de WoW Classic es 16.|nEl valor predeterminado de WoW Retail es 27."
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "Arrastra para establecer la escala del mapa del mundo.|n|nTambién puedes cambiar la escala del mapa del mundo arrastrando la esquina inferior derecha."
L["Dragonblight"] = "Cementerio de Dragones"
L["Drak'Tharon Keep"] = "Fortaleza de Drak'Tharon"
L["Druid only flight point to Darnassus"] = "Punto de vuelo a Darnassus solo para druidas"
L["Druid only flight point to Thunder Bluff"] = "Punto de vuelo a Cima del Trueno solo para druidas"
L["Dun Algaz"] = "Dun Algaz"
L["Dun Morogh"] = "Dun Morogh"
L["Dun Nifflelem"] = "Dun Nifflelem"
L["Dungeon"] = "Calabozo"
L["Dungeon (requires Crescent Key)"] = "Mazmorra (requiere Llave de la Cosecha)"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bosque del Ocaso"
L["Dustwallow Marsh"] = "Marjal Revolcafango"
L["Dwarven District"] = "Distrito de los Enanos"
L["Eastern Plaguelands"] = "Tierras de la Peste del Este"
L["Ebon Watch"] = "Vigía Ébano"
L["Elements"] = "Visibilidad"
L["Elwynn Forest"] = "Bosque de Elwynn"
L["Emerald Sanctuary"] = "Santuario Esmeralda"
L["Enhance battlefield map"] = "Mejorar el mapa del campo de batalla"
L["Enlarge player arrow"] = "Flecha de jugador"
L["Enter"] = "Entrar"
L["Evergrove"] = "Soto Eterno"
L["Everlook"] = "Vista Eterna"
L["Eversong Woods"] = "Bosque Canción Eterna"
L["Exodar"] = "El Exodar"
L["Falcon Watch"] = "Avanzada del Halcón"
L["Feathermoon Stronghold"] = "Bastión Plumaluna"
L["Felwood"] = "Frondavil"
L["Feralas"] = "Feralas"
L["Fishing"] = "Pesca"
L["Fizzcrank Airstrip"] = "Aeropuerto Fizzcrank"
L["Flame Crest"] = "Peñasco Llamarada"
L["Fordragon Hold"] = "Fortaleza Fordragón"
L["Forest Song"] = "Canción del Bosque"
L["Fort Wildervar"] = "Fuerte Frondavara"
L["Freewind Post"] = "Poblado Viento Libre"
L["Frosthold"] = "Fuerte Escarcha"
L["Gadgetzan"] = "Gadgetzan"
L["Garadar"] = "Garadar"
L["Ghostlands"] = "Tierras Fantasma"
L["Gnomeregan"] = "Gnomeregan"
L["Green"] = "Verde"
L["Grizzly Hills"] = "Colinas Pardas"
L["Grom'arsh Crash Site"] = "Lugar del Accidente de Grom'arsh"
L["Grom'gol Base Camp"] = "Campamento Grom'gol"
L["Group Icons"] = "Iconos de grupo"
L["Gruul's Lair"] = "Guarida de Gruul"
L["Gundrak"] = "Gundrak"
L["Gundrak (rear entrance)"] = "Gundrak (entrada trasera)"
L["Halls of Lightning"] = "Cámaras de Relámpagos"
L["Halls of Stone"] = "Cámaras de Piedra"
L["Hammerfall"] = "Sentencia"
L["Head down the mountain from here."] = "Baja de la montaña desde aquí."
L["Head southeast from here and go up the mountain."] = "Ve al sureste desde aquí y sube la montaña."
L["Hellfire Peninsula"] = "Península del Fuego Infernal"
L["Hellfire Ramparts"] = "Murallas del Fuego Infernal"
L["Hide town and city icons"] = "Pueblos y ciudades"
L["Hillsbrad Foothills"] = "Laderas de Trabalomas"
L["Honor Hold"] = "Bastión del Honor"
L["Horde Cities"] = "Ciudades de la Horda"
L["Howling Fjord"] = "Fiordo Aquilonal"
L["Hyjal Summit"] = "La Cima Hyjal"
L["Icecrown"] = "Corona de Hielo"
L["Icecrown Citadel"] = "Ciudadela de la Corona de Hielo"
L["Icons"] = "Iconos"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "Si está seleccionado, se mostrarán los puertos de los barcos, las torres de los zepelines y las estaciones de tranvía."
L["If checked, coordinates will be shown."] = "Si está seleccionado, se mostrarán las coordenadas."
L["If checked, dungeons and raids will be shown."] = "Si está seleccionado, se mostrarán calabozos y bandas."
L["If checked, group icons will use a modern, class-colored design."] = "Si está seleccionado, los iconos de grupo usarán un diseño moderno, de color de clase."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Si está seleccionado, al abrir el mapa se usará el mismo nivel de zoom desde la última vez que lo cerró, siempre que la zona del mapa no haya cambiado."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Si está seleccionado, apuntar al mapa mientras tu personaje se mueve hará que se aplique la configuración de opacidad estacionaria."
L["If checked, points of interest will be shown."] = "Si está seleccionado, se mostrarán puntos de interés."
L["If checked, quest objectives will be shown."] = "Si está marcado, se mostrarán los objetivos de las misiones."
L["If checked, spirit healers will be shown."] = "Si está seleccionado, se mostrarán los Ángeles de la Resurrección."
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Si está marcado, el mapa de campo de batalla permanecerá centrado en tu ubicación siempre que no estés en una mazmorra.|n|nPuedes mantener presionado Shift mientras desplazas el mapa para evitar temporalmente que se centre."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Si está seleccionado, se usará el mapa predeterminado de pantalla completa.|n|nTenga en cuenta que habilitar esta opción bloqueará algunas de las otras opciones."
L["If checked, the map border will be removed."] = "Si está seleccionado, se eliminará el borde del mapa."
L["If checked, the map frame will remain open until you close it."] = "Si está seleccionado, el marco del mapa permanecerá abierto hasta que lo cierre."
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Si está marcado, el mapa permanecerá centrado en tu ubicación siempre que no estés en una mazmorra.|n|nPuedes mantener presionado Shift mientras desplazas el mapa para evitar temporalmente que se centre."
L["If checked, the minimap button will be shown."] = "Si está seleccionado, se mostrará el botón del minimapa."
L["If checked, the minimum fishing skill levels will be shown."] = "Si está seleccionado, se mostrarán los niveles mínimos de habilidad de pesca."
L["If checked, town and city icons will not be shown on the continent maps."] = "Si está seleccionado, los iconos de pueblos y ciudades no se mostrarán en los mapas continentes."
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Si está marcado, se mostrarán los puntos de viaje de la facción opuesta.|n|nEsto incluye puntos de vuelo, puertos de barco, torres de zepelín y estaciones de tranvía."
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Si está marcado, se mostrarán los puntos de viaje de la misma facción.|n|nEsto incluye puntos de vuelo, puertos de barco, torres de zepelín y estaciones de tranvía."
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "Si está marcado, se mostrarán las áreas inexploradas del mapa en el mapa del mundo y en el mapa de campo de batalla."
L["If checked, unexplored areas will be tinted."] = "Si está seleccionado, las áreas inexploradas se teñirán."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Si está seleccionado, cuando tu personaje cambia de zona, el mapa cambiará automáticamente a la nueva zona."
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "Si está marcado, puedes mover el mapa de campo de batalla arrastrando cualquiera de sus bordes.|n|nPuedes cambiar el tamaño del mapa de campo de batalla arrastrando la esquina inferior derecha."
L["If checked, you will be able to customise the battlefield map."] = "Si está seleccionado, podrás personalizar el mapa del campo de batalla."
L["If checked, you will be able to enlarge the player arrow."] = "Si está seleccionado, podrá ampliar la flecha del jugador."
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "Si está marcado, podrás cambiar la escala del mapa arrastrando el control de escala en la esquina inferior derecha.|n|nPodrás mover el mapa arrastrando cualquier borde.|n|nPuedes arrastrar siempre el borde superior para mover el mapa, independientemente de esta configuración."
L["If checked, you will be able to set the opacity of the map."] = "Si está seleccionado, podrá establecer la opacidad del mapa."
L["If checked, you will be able to zoom further into the world map."] = "Si está marcado, podrás hacer zoom aún más en el mapa del mundo."
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "Si está marcado, se mostrarán los menús desplegables de zona y continente en el marco del mapa."
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "Si está marcado, se mostrarán los cruces de zona.|n|nEstas son flechas clicables que indican las salidas de la zona."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Si está seleccionado, se mostrarán los niveles de zona, calabozo y habilidad de pesca."
L["Increase zoom level"] = "Aumentar nivel de zoom"
L["Invalid command.  Enter /ltm help for help."] = "Comando inválido. Escribe / ltm help para obtener ayuda."
L["Invalid command. Enter /ltm help for help."] = "Comando no válido. Ingresa /ltm help para obtener ayuda."
L["Invalid map ID."] = "ID de mapa inválido."
L["Ironforge"] = "Forjaz"
L["Isle of Quel'Danas"] = "Isla de Quel'Danas"
L["K3"] = "K3"
L["Kamagua"] = "Kamagua"
L["Karazhan"] = "Karazhan"
L["Kargath"] = "Kargath"
L["Kor'kron Vanguard"] = "Vanguardia Kor'kron"
L["Lake Elune'ara"] = "Lago Elune'ara"
L["Lake Everstill"] = "Lago Sempiterno"
L["Large Scarab Coffer"] = "Arca del escarabajo grande"
L["Leads to Tirisfal Glades"] = "Conduce a Claros de Tirisfal"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: ¡VERSIÓN INCORRECTA INSTALADA!"
L["Light's Breach"] = "Brecha de la Luz"
L["Light's Hope Chapel"] = "Capilla de la Esperanza de la Luz"
L["Loch Modan"] = "Loch Modan"
L["Lower Blackrock Spire"] = "Cumbre de Roca Negra Inferior"
L["Magisters' Terrace"] = "Bancal del Magister"
L["Magtheridon's Lair"] = "Guarida de Magtheridon"
L["Mana-Tombs"] = "Tumbas de Maná"
L["Map frame scale"] = "Escala del marco del mapa"
L["Map Opacity"] = "Opacidad de mapa"
L["Map Scale"] = "Escala de Mapa"
L["Map Size"] = "Tamaño de mapa"
L["MapScale"] = "EscalaMapa"
L["Maraudon"] = "Maraudon"
L["Marshal's Refuge"] = "Refugio de Marshal"
L["Max Zoom"] = "Zoom Máximo"
L["Maximum"] = "Máximo"
L["Mechanics"] = "Mecánicas"
L["Memory Usage"] = "Uso de memoria"
L["Menethil Harbor"] = "Puerto de Menethil"
L["Miscellaneous"] = "Miscelánea"
L["Moa'ki"] = "Moa'ki"
L["Moa'ki Harbor"] = "Puerto Moa'ki"
L["Mok'Nathal Village"] = "Aldea Mok'Nathal"
L["Molten Core"] = "Núcleo de Magma"
L["Moonglade"] = "Claro de la Luna"
L["More"] = "Más"
L["Morgan's Vigil"] = "Vigilia de Morgan"
L["Moving"] = "Movimiento"
L["Mudsprocket"] = "Piñón de Barro"
L["Mulgore"] = "Mulgore"
L["Nagrand"] = "Nagrand"
L["Naxxramas"] = "Naxxramas"
L["Nesingwary Base Camp"] = "Campamento Base de Nesingwary"
L["Nethergarde Keep"] = "Castillo de Nethergarde"
L["Netherstorm"] = "Tormenta Abisal"
L["Never"] = "Nunca"
L["New Agamand"] = "Nuevo Agamand"
L["Nighthaven"] = "Amparo de la Noche"
L["Nijel's Point"] = "Punta de Nijel"
L["North"] = "Norte"
L["North Gate Pass"] = "Paso de la Puerta Norte"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "¡ATENCIÓN!|nDebes reiniciar completamente tu cliente de juego antes de poder usar esta versión de Leatrix Maps."
L["Old Hillsbrad"] = "Antiguas Colinasbrad"
L["Old Hillsbrad Foothills"] = "Antiguas Laderas de Trabalomas"
L["Onyxia's Lair"] = "Guarida de Onyxia"
L["Opacity"] = "Opacidad"
L["or click the minimap button to open Leatrix Maps."] = "o haga clic en el botón de minimapa para abrir Leatrix Maps."
L["Orb of Translocation"] = "Orbe de Translocación"
L["Orebor Harborage"] = "Puerto Orebor"
L["Orgrimmar"] = "Orgrimmar"
L["Player"] = "Jugador"
L["Player Arrow"] = "Flecha de jugador"
L["Portal"] = "Portal"
L["Portal from Zephyr"] = "Portal desde Zephyr"
L["Portals"] = "Portales"
L["Preview"] = "Prevista"
L["Ragefire Chasm"] = "Sima Ígnea"
L["Raid"] = "Banda"
L["Ratchet"] = "Trinquete"
L["Ravenholdt Manor"] = "Mansión Ravenholdt"
L["Razorfen Downs"] = "Zahúrda Rajacieno"
L["Razorfen Kraul"] = "Horado Rajacieno"
L["Razorthorn Trail"] = "Senda de Espinaguda"
L["Rebel Camp"] = "Asentamiento Rebelde"
L["Red"] = "Rojo"
L["Redridge Mountains"] = "Montañas Crestagrana"
L["Refuge Pointe"] = "Refugio de la Zaga"
L["Reload"] = "Recargar"
L["Remember zoom level"] = "Recordar nivel de zoom"
L["Remove map border"] = "Borde del mapa"
L["req"] = "req"
L["Requires Key to Searing Gorge"] = "Requiere Llave para la Garganta Abrasadora"
L["Requires UI reload."] = "Requiere recargar la IU"
L["Reset"] = "Restablecer"
L["Reset Map Layout"] = "Restablecer el diseño del mapa"
L["Revantusk Village"] = "Poblado Sañadiente"
L["River's Heart"] = "Corazón del Río"
L["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruinas de Elune'eth"
L["Rut'theran Village"] = "Aldea Rut'theran"
L["Rut'Theran Village"] = "Aldea Rut'Theran"
L["Sanctum of the Stars"] = "Sagrario de las Estrellas"
L["Scale"] = "Escala"
L["Scarlet Monastery"] = "Monasterio Escarlata"
L["Scholomance"] = "Scholomance"
L["Searing Gorge"] = "La Garganta de Fuego"
L["Seat of the Naaru"] = "Asiento de los Naaru"
L["Sentinel Hill"] = "Colina del Centinela"
L["Serpentshrine Cavern"] = "Caverna Santuario Serpiente"
L["Set map opacity"] = "Opacidad del mapa"
L["Set map opacity while stationary and while moving."] = "Establece la opacidad del mapa mientras está parado y en movimiento."
L["Set the group icon size."] = "Establece el tamaño del icono de grupo."
L["Set the maximum zoom scale."] = "Establece la escala máxima de zoom."
L["Set the player arrow size."] = "Establece el tamaño de la flecha del jugador."
L["Sethekk Halls"] = "Salas Sethekk"
L["Settings"] = "Configuración"
L["Sewers"] = "Cloacas"
L["Shadow Labyrinth"] = "Laberinto de las Sombras"
L["Shadowfang Keep"] = "Castillo de Colmillo Oscuro"
L["Shadowmoon Valley"] = "Valle Sombraluna"
L["Shadowmoon Village"] = "Aldea Sombraluna"
L["Shadowprey Village"] = "Aldea Cazasombras"
L["Shatter Point"] = "Punto de Fragmentación"
L["Shattrath"] = "Shattrath"
L["Shattrath City"] = "Ciudad de Shattrath"
L["Sholazar Basin"] = "Cuenca de Sholazar"
L["Show boats, zeppelins and trams"] = "Mostrar barcos, zepelines y tranvías"
L["Show coordinates"] = "Coordenadas"
L["Show dungeons and raids"] = "Mostrar calabozos y bandas"
L["Show minimap button"] = "Botón del minimapa"
L["Show minimum fishing skill levels"] = "Mostrar niveles mínimos de habilidad de pesca"
L["Show objectives"] = "Mostrar objetivos"
L["Show points of interest"] = "Puntos de interés"
L["Show scale handle"] = "Mostrar asa de escala"
L["Show spirit healers"] = "Mostrar Ángel de la Resurrección"
L["Show travel points for opposing faction"] = "Mostrar puntos de viaje para la facción opuesta"
L["Show travel points for same faction"] = "Mostrar puntos de viaje para la misma facción"
L["Show unexplored areas"] = "Áreas inexploradas"
L["Show zone crossings"] = "Mostrar cruces de zona"
L["Show zone levels"] = "Nivel de zona"
L["Show zone menus"] = "Mostrar menús de zona"
L["Silithus"] = "Silithus"
L["Silvermoon"] = "Entrañas"
L["Silvermoon City"] = "Ciudad de Lunargenta"
L["Silverpine Forest"] = "Bosque de Argénteos"
L["Slave Pens"] = "Recinto de los Esclavos"
L["South"] = "Sur"
L["South Gate Pass"] = "Paso de la Puerta Sur"
L["Southfury River"] = "Río Furia del Sur"
L["Southshore"] = "Costasur"
L["Spinebreaker Ridge"] = "Cresta Rompeloma"
L["Spirit Healer"] = "Ángel de la Resurrección"
L["Splintertree Post"] = "Puesto del Hachazo"
L["Stars' Rest"] = "Reposo Estelar"
L["Stationary"] = "Estacionario"
L["Steamvault"] = "La Cámara de Vapor"
L["Sticky map frame"] = "Mapa pegajoso"
L["Stonard"] = "Rocal"
L["Stonebreaker Hold"] = "Bastión Rompepedras"
L["Stonetalon Mountains"] = "Sierra Espolón"
L["Stonetalon Peak"] = "Cima del Espolón"
L["Stormwind"] = "Ventormenta"
L["Stormwind City"] = "Ciudad de Ventormenta"
L["Stranglethorn Vale"] = "Vega de Tuercespina"
L["Stratholme (Main Gate)"] = "Stratholme: Entrada Principal"
L["Stratholme (Service Gate)"] = "Stratholme: Entrada de Servicio"
L["sum"] = "invo"
L["Sun Rock Retreat"] = "Refugio Roca del Sol"
L["Sunreaver's Command"] = "Mando de los Atracasol"
L["Sun's Reach Harbor"] = "Puerto Alcance del Sol"
L["Sunwell Plateau"] = "Meseta de La Fuente del Sol"
L["Swamp of Sorrows"] = "Pantanos de las Penas"
L["Swamprat Post"] = "Avanzada Rata del Pantano"
L["Sylvanaar"] = "Sylvanaar"
L["System"] = "Sistema"
L["Talonbranch Glade"] = "Claro Ramaespolón"
L["Talrendis Point"] = "Punta Talrendis"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Molino Tarren"
L["Taunka'le Village"] = "Aldea Taunka'le"
L["Telaar"] = "Telaar"
L["Teldrassil"] = "Teldrassil"
L["Teleport Crystal"] = "Cristal de Teleportación"
L["Telredor"] = "Telredor"
L["Tempest Keep"] = "El Castillo de la Tempestad"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Temple of Telhamat"] = "Templo de Telhamat"
L["Terokkar Forest"] = "Bosque de Terokkar"
L["Thalanaar"] = "Thalanaar"
L["Thandol Span"] = "Puente Thandol"
L["The Arcatraz"] = "El Arcatraz"
L["The Argent Stand"] = "El Bastión Argenta"
L["The Argent Vanguard"] = "La Vanguardia Argenta"
L["The Barrens"] = "Los Baldíos"
L["The Blood Furnace"] = "El Horno de Sangre"
L["The Botanica"] = "El Invernáculo"
L["The Bulwark"] = "La Muralla"
L["The Crossroads"] = "El Cruce"
L["The Dark Portal"] = "El Portal Oscuro"
L["The Deadmines"] = "Las Minas de la Muerte"
L["The Exodar"] = "El Exodar"
L["The Eye"] = "El Ojo"
L["The Eye of Eternity"] = "El Ojo de la Eternidad"
L["The Forge of Souls"] = "Forja de Almas"
L["The Forgotten Coast"] = "La Costa Olvidada"
L["The Frozen Halls"] = "Las Salas Heladas"
L["The Great Forge"] = "La Gran Fundición"
L["The Great Lift"] = "El Gran Ascensor"
L["The Halls of Reflection"] = "Las Salas de la Reflexión"
L["The Hinterlands"] = "Tierras del Interior"
L["The Mechanar"] = "El Mechanar"
L["The Nexus"] = "El Nexo"
L["The Obsidian Sanctum"] = "El Sagrario Obsidiana"
L["The Oculus"] = "El Oculus"
L["The Old Kingdom"] = "El Antiguo Reino"
L["The Pit of Saron"] = "La Fosa de Saron"
L["The Ruby Sanctum"] = "El Sagrario Rubí"
L["The Sepulcher"] = "El Sepulcro"
L["The Shadow Vault"] = "La Bóveda de las Sombras"
L["The Shattered Halls"] = "Las Salas Arrasadas"
L["The Stockade"] = "Las Mazmorras"
L["The Storm Peaks"] = "Las Cumbres Tormentosas"
L["The Stormspire"] = "Flecha de la Tormenta"
L["The Talondeep Path"] = "El Sendero Talondeep"
L["The Vault of Lights"] = "La Bóveda de las Luces"
L["The Violet Hold"] = "El Bastión Violeta"
L["The Zoram Strand"] = "La Playa de Zoram"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Isla Theramore"
L["Thorium Point"] = "Puesto del Torio"
L["Thousand Needles"] = "Las Mil Agujas"
L["Thrallmar"] = "Thrallmar"
L["Thunder Bluff"] = "Cima del Trueno"
L["Thunderlord Stronghold"] = "Bastión Señor del Trueno"
L["Timbermaw Hold"] = "Bastión Fauces de Madera"
L["Tinker Town"] = "Ciudad Manitas"
L["Tint unexplored areas"] = "Teñir áreas inexploradas"
L["Tirisfal Glades"] = "Claros de Tirisfal"
L["Toggle panel"] = "Alternar panel"
L["Toshley's Station"] = "Estación de Toshley"
L["Trade District"] = "Distrito de Mercaderes"
L["Trade Quarter"] = "Barrio del Comercio"
L["Tram to"] = "Tranvía a"
L["Tranquillien"] = "Tranquillien"
L["Transitus Shield"] = "Escudo de Transitus"
L["Transparency"] = "Transparencia"
L["Trial of the Champion"] = "Prueba del Campeón"
L["Trial of the Crusader"] = "Prueba del Cruzado"
L["Twilight Shore"] = "Costa Crepuscular"
L["Twilight Vale"] = "Valle Crepuscular"
L["Uldaman"] = "Uldaman"
L["Uldaman (side entrance)"] = "Uldaman (entrada lateral)"
L["Ulduar"] = "Ulduar"
L["Underbog"] = "La Sotiénaga"
L["Undercity"] = "Entrañas"
L["Un'Goro Crater"] = "Cráter de Un'Goro"
L["Unlock battlefield map"] = "Desbloquear mapa de campo de batalla"
L["Unlock map frame"] = "Desbloquear mapa"
L["Unu'pe"] = "Unu'pe"
L["Upper Blackrock Spire"] = "Cumbre de Roca Negra Superior"
L["Use default map"] = "Mapa predeterminado"
L["Use stationary opacity while pointing at map"] = "Usa opacidad estacionaria mientras apunta al mapa"
L["Utgarde Keep"] = "Fortaleza de Utgarde"
L["Utgarde Pinnacle"] = "Pico de Utgarde"
L["Valaar's Berth"] = "Atracadero de Valaar"
L["Valgarde"] = "Valgarde"
L["Valgarde Port"] = "Puerto Valgarde"
L["Valiance Keep"] = "Fortaleza de la Valentía"
L["Valiance Landing Camp"] = "Campamento de Aterrizaje de la Valentía"
L["Valley of Strength"] = "El Valle de la Fuerza"
L["Valormok"] = "Valormok"
L["Vault of Archavon"] = "La Cámara de Archavon"
L["Vengeance Landing"] = "Desembarco de la Venganza"
L["Venomspite"] = "Veneno Filspanto"
L["Version"] = "Versión"
L["Wailing Caverns"] = "Cuevas de los Lamentos"
L["Warsong Camp"] = "Campamento Grito de Guerra"
L["Warsong Hold"] = "Bastión Grito de Guerra"
L["Western Plaguelands"] = "Tierras de la Peste del Oeste"
L["Westfall"] = "Páramos de Poniente"
L["Westfall Brigade"] = "Brigada de los Páramos de Poniente"
L["Westguard Keep"] = "Fortaleza de la Guardia Oeste"
L["Wetlands"] = "Los Humedales"
L["Wildhammer Stronghold"] = "Bastión Martillo Salvaje"
L["Windrunner's Overlook"] = "Mirador de Brisaveloz"
L["Wintergarde Keep"] = "Fortaleza de Guardia Invernal"
L["Wintergrasp"] = "Cuenca de Sholazar"
L["Winterspring"] = "Cuna del Invierno"
L["Wrath of the Lich King Classic"] = "Ira del Rey Exánime Clásica"
L["Wyrmrest Temple"] = "Templo del Reposo del Dragón"
L["You will die!"] = "¡Morirás!"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Su IU necesita ser recargada para que algunos de los cambios surtan efecto.|n|nNo tiene que hacer clic en el botón de recarga de inmediato, pero debe hacer clic en él cuando haya terminado de hacer cambios y desea que los cambios surtan efecto."
L["Your UI needs to be reloaded."] = "La IU necesita ser recargada."
L["Zabra'jin"] = "Zabra'jin"
L["Zangarmarsh"] = "Marisma de Zangar"
L["Zeb'Sora"] = "Zeb'Sora"
L["Zeppelin to"] = "Zepelín a"
L["Zim'Torga"] = "Zim'Torga"
L["Zone Map"] = "Mapa de Zona"
L["Zoom"] = "Zoom"
L["Zoram'gar Outpost"] = "Ensenada de Zoram'gar"
L["Zul'Aman"] = "Zul'Aman"
L["Zul'Drak"] = "Zul'Drak"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end

-- frFR: French
if GameLocale == "frFR" then
L["(destination only)"] = "(destination seulement)"
L["(inside Caverns of Time)"] = "(à l'intérieur de la Grotte du Temps)"
L["/ltm help - Show this information."] = "/ltm help - Affiche ces informations."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Réinitialise la position du panneau."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Effacez tous les paramètres et rechargez."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Une erreur d'arrêt s'est produite mais ne vous inquiétez pas. Cela peut arriver de temps en temps. Cliquez sur le bouton de rechargement pour le résoudre."
L["A stop error has occurred but no need to worry. It can happen from time to time. Click the reload button to resolve it."] = "Une erreur d'arrêt s'est produite, mais pas besoin de s'inquiéter. Cela peut arriver de temps en temps. Cliquez sur le bouton de rechargement pour la résoudre."
L["Acherus: The Ebon Hold"] = "Achérus : le fort d'Ébène"
L["Aerie Peak"] = "Nid-de-l'Aigle"
L["Agmar's Hammer"] = "Marteau d'Agmar"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Aldor"] = "Aldor"
L["Allerian Stronghold"] = "Bastion allérien"
L["Alliance Cities"] = "Villes de l'Alliance"
L["Alpha"] = "Alpha"
L["Altar of Sha'tar"] = "Autel de Sha'tar"
L["Alterac Mountains"] = "Montagnes d'Alterac"
L["Always"] = "Toujours"
L["Amber Lodge"] = "Pavillon d'Ambre"
L["Amberpine Lodge"] = "Pavillon de Pinambre"
L["Apothecary Camp"] = "Camp d'Apothicaire"
L["Appearance"] = "Apparence"
L["Arathi Highlands"] = "Hautes-terres d'Arathi"
L["Area 52"] = "Zone 52"
L["Argent Tournament Grounds"] = "Enceinte du tournoi d'Argent"
L["Ashenvale"] = "Orneval"
L["Astranaar"] = "Astranaar"
L["Auberdine"] = "Auberdine"
L["Auchenai Crypts"] = "Cryptes Auchenaï"
L["Auto change zones"] = "Changer les zones"
L["Azeroth"] = "Azeroth"
L["Azjol-Nerub"] = "Azjol-Nérub"
L["Azshara"] = "Azshara"
L["Azuremyst Isle"] = "Île de Brume-Azur"
L["Back to Main Menu"] = "Retour au menu principal"
L["Badlands"] = "Terres ingrates"
L["Battlegrounds"] = "Champs de bataille"
L["Black Morass"] = "Le Noir marécage"
L["Black Temple"] = "Le Temple noir"
L["Blackfathom Deeps"] = "Profondeurs de Brassenoire"
L["Blackrock Depths"] = "Profondeurs de Blackrock"
L["Blackrock Mountain"] = "Mont Blackrock"
L["Blackwing Lair"] = "Repaire de l'Aile noire"
L["Blade Tooth Canyon"] = "Canyon Croc-Lame"
L["Blade's Edge Mountains"] = "Les Tranchantes"
L["Blades' Run"] = "Piste des Lames"
L["Blasted Lands"] = "Terres foudroyées"
L["Blood Watch"] = "Guet du sang"
L["Bloodmyst Isle"] = "Île de Brume-Sang"
L["Bloodvenom Post"] = "Poste de la Vénéneuse"
L["Blue"] = "Bleu"
L["Boat to"] = "Bateau à"
L["Booty Bay"] = "Baie-du-Butin"
L["Borean Tundra"] = "Toundra Boréenne"
L["Bor'gorok Outpost"] = "Avant-poste Bor'gorok"
L["Bouldercrag's Refuge"] = "Refuge de Rochéchine"
L["Brackenwall Village"] = "Mur-de-Fougères"
L["Burning Crusade Classic"] = "Burning Crusade Classic"
L["Burning Steppes"] = "Steppes ardentes"
L["Camp Mojache"] = "Camp Mojache"
L["Camp Oneqwah"] = "Camp Oneqwah"
L["Camp Taurajo"] = "Camp Taurajo"
L["Camp Tunka'lo"] = "Camp Tunka'lo"
L["Camp Winterhoof"] = "Camp Sabot-d'Hiver"
L["Caverns of Time"] = "Grottes du temps"
L["Cenarion Hold"] = "Fort Cénarien"
L["Center map on player"] = "Centrer la carte sur le joueur"
L["Central Mesa"] = "Mesa centrale"
L["Chillwind Camp"] = "Camp du Noroît"
L["Choose where the zone map should be shown."] = "Choisissez où la carte de zone doit être affichée."
L["Class colored icons"] = "Icônes colorées"
L["Classic"] = "Classique"
L["Click to configure the settings for this option."] = "Cliquez pour configurer les paramètres de cette option."
L["Click to reset the position and scale of the map frame."] = "Cliquez pour réinitialiser la position et l'échelle du cadre de la carte."
L["Click to reset the settings on this page."] = "Cliquez pour réinitialiser les paramètres de cette page."
L["Click to return to the main menu."] = "Cliquez pour revenir au menu principal."
L["Coilfang Reservoir"] = "Réservoir de Glissecroc"
L["Coldarra"] = "Gelarra"
L["Configuration Panel"] = "Panneau de configuration"
L["Conquest Hold"] = "Bastion de la Conquête"
L["Cosmic"] = "Cosmique"
L["Cosmowrench"] = "Cosmovrille"
L["Crusaders' Pinnacle"] = "Pinacle des Croisés"
L["Crystalsong Forest"] = "Forêt du Chant de cristal"
L["Culling of Stratholme"] = "Le Purge d'Stratholme"
L["Cursor"] = "Curseur"
L["Dalaran"] = "Dalaran"
L["Dalaran Crater"] = "Cratère de Dalaran"
L["Darkshire"] = "Darkshire"
L["Darkshore"] = "Sombrivage"
L["Darnassus"] = "Darnassus"
L["Deadwind Pass"] = "Défilé de Deuillevent"
L["Death's Rise"] = "Ascension de la Mort"
L["Desolace"] = "Désolace"
L["Dire Maul (East)"] = "Hache-tripes (Est)"
L["Dire Maul (East) (side entrance)"] = "Hache-tripes (est) (entrée latérale)"
L["Dire Maul (North)"] = "Hache-tripes (Nord)"
L["Dire Maul (West)"] = "Hache-tripes (Ouest)"
L["Disable reading emote when opening the map"] = "Désactiver l'emote lors de l'ouverture de la carte"
L["Drag"] = "Faites glisser"
L["Drag to set the amount of blue."] = "Faites glisser pour définir la quantité de bleu."
L["Drag to set the amount of green."] = "Faites glisser pour définir la quantité de vert."
L["Drag to set the amount of red."] = "Faites glisser pour définir la quantité de rouge."
L["Drag to set the battlefield map opacity."] = "Faites glisser pour définir l'opacité de la carte du champ de bataille."
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "Faites glisser pour définir la taille de la carte de champ de bataille. |n|nSi la carte n'est pas verrouillée, vous pouvez également redimensionner la carte du champ de bataille en faisant glisser le coin inférieur droit."
L["Drag to set the group icon size."] = "Faites glisser pour définir la taille de l'icône du groupe."
L["Drag to set the map opacity for when your character is moving."] = "Faites glisser pour définir l'opacité de la carte lorsque votre personnage se déplace."
L["Drag to set the map opacity for when your character is stationary."] = "Faites glisser pour définir l'opacité de la carte lorsque votre personnage est à l'arrêt."
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "Faites glisser pour définir le niveau de zoom maximal. |n|nOuvrez la carte du champ de bataille pour voir le changement de niveau de zoom maximal lorsque vous faites glisser le curseur."
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "Faites glisser pour définir le niveau de zoom maximal. |n|nOuvrez la carte pour voir le changement de niveau de zoom maximal lorsque vous faites glisser le curseur."
L["Drag to set the opacity."] = "Faites glisser pour définir l'opacité."
L["Drag to set the player arrow size."] = "Faites glisser pour définir la taille de la flèche du lecteur."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Faites glisser pour définir la taille de la flèche du lecteur.|n|nLa valeur par défaut de Wow Classic est 16.|nLa valeur par défaut de Wow Retail est 27."
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "Faites glisser pour définir l'échelle de la carte du monde. |n|nVous pouvez également redimensionner la carte du monde en faisant glisser le coin inférieur droit."
L["Dragonblight"] = "Désolation des dragons"
L["Drak'Tharon Keep"] = "Donjon de Drak'Tharon"
L["Druid only flight point to Darnassus"] = "Point de vol réservé aux druides vers Darnassus"
L["Druid only flight point to Thunder Bluff"] = "Point de vol réservé aux druides vers Thunder Bluff"
L["Dun Algaz"] = "Dun Algaz"
L["Dun Morogh"] = "Dun Morogh"
L["Dun Nifflelem"] = "Dun Niffelem"
L["Dungeon"] = "Donjon"
L["Dungeon (requires Crescent Key)"] = "Donjon (nécessite la Clé du croissant)"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bois de la Pénombre"
L["Dustwallow Marsh"] = "Marécage d'Âprefange"
L["Dwarven District"] = "Quartier des Nains"
L["Eastern Plaguelands"] = "Maleterres de l'est"
L["Ebon Watch"] = "Guette-ébène"
L["Elements"] = "Visibilité"
L["Elwynn Forest"] = "Forêt d'Elwynn"
L["Emerald Sanctuary"] = "Sanctuaire d'émeraude"
L["Enhance battlefield map"] = "Améliorer la carte du champ de bataille"
L["Enlarge player arrow"] = "Flèche du joueur"
L["Enter"] = "Entrer"
L["Evergrove"] = "Bosquet éternel"
L["Everlook"] = "Long-guet"
L["Eversong Woods"] = "Bois des Chants éternels"
L["Exodar"] = "L'Exodar"
L["Falcon Watch"] = "Guet de l'épervier"
L["Feathermoon Stronghold"] = "Bastion de Feathermoon"
L["Felwood"] = "Gangrebois"
L["Feralas"] = "Féralas"
L["Fishing"] = "Pêche"
L["Fizzcrank Airstrip"] = "Piste de la Foudreflèche"
L["Flame Crest"] = "Corniche des Flammes"
L["Fordragon Hold"] = "Fort-de-Dragon"
L["Forest Song"] = "Chant de la forêt"
L["Fort Wildervar"] = "Fort-Viridien"
L["Freewind Post"] = "Poste de Librevent"
L["Frosthold"] = "Halte d'Angrathar"
L["Gadgetzan"] = "Gadgetzan"
L["Garadar"] = "Garadar"
L["Ghostlands"] = "Les terres Fantômes"
L["Gnomeregan"] = "Gnomeregan"
L["Green"] = "Vert"
L["Grizzly Hills"] = "Les Grisonnes"
L["Grom'arsh Crash Site"] = "Site du crash de Grom'arsh"
L["Grom'gol Base Camp"] = "Campement Grom'Gol"
L["Group Icons"] = "Icônes de groupe"
L["Gruul's Lair"] = "Repaire de Gruul"
L["Gundrak"] = "Gundrak"
L["Gundrak (rear entrance)"] = "Gundrak (entrée arrière)"
L["Halls of Lightning"] = "Salles de Foudre"
L["Halls of Stone"] = "Salles de Pierre"
L["Hammerfall"] = "Trépas-d'Orgrim"
L["Head down the mountain from here."] = "Descendez la montagne à partir d'ici."
L["Head southeast from here and go up the mountain."] = "Dirigez-vous vers le sud-est à partir d'ici et montez la montagne."
L["Hellfire Peninsula"] = "Péninsule des Flammes infernales"
L["Hellfire Ramparts"] = "Remparts des Flammes infernales"
L["Hide town and city icons"] = "Villes et cités"
L["Hillsbrad Foothills"] = "Contreforts d'Hillsbrad"
L["Honor Hold"] = "Bastion de l'Honneur"
L["Horde Cities"] = "Villes de la Horde"
L["Howling Fjord"] = "Fjord Hurlant"
L["Hyjal Summit"] = "Sommet d’Hyjal"
L["Icecrown"] = "Couronne de glace"
L["Icecrown Citadel"] = "Citadelle de la Couronne de glace"
L["Icons"] = "Icônes"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "Si cette option est cochée, les ports pour bateaux, les tours zeppelin et les stations de tram seront affichés."
L["If checked, coordinates will be shown."] = "Si cette option est cochée, les coordonnées seront affichées."
L["If checked, dungeons and raids will be shown."] = "Si cette option est cochée, les donjons et les raids seront affichés."
L["If checked, group icons will use a modern, class-colored design."] = "Si cette option est cochée, les icônes de groupe utiliseront un design moderne de couleur de classe."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Si cette option est cochée, l'ouverture de la carte utilisera le même niveau de zoom que lors de sa dernière fermeture tant que la zone de la carte n'a pas changé."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Si cette option est cochée, le fait de pointer la carte pendant le déplacement de votre personnage entraînera l'application du paramètre d'opacité stationnaire."
L["If checked, points of interest will be shown."] = "Si cette option est cochée, les points d'intérêt seront affichés."
L["If checked, quest objectives will be shown."] = "Si coché, les objectifs de quête seront affichés."
L["If checked, spirit healers will be shown."] = "Si cette option est cochée, les Gardien des âmes seront affichés."
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Si coché, la carte de champ de bataille restera centrée sur votre position tant que vous n'êtes pas dans un donjon. |n|nVous pouvez maintenir la touche Maj en faisant glisser la carte pour l'empêcher temporairement de se recentrer."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Si cette option est cochée, la carte plein écran par défaut sera utilisée.|n|nNotez que l'activation de cette option bloquera certaines des autres options."
L["If checked, the map border will be removed."] = "Si cette option est cochée, la bordure de la carte sera supprimée."
L["If checked, the map frame will remain open until you close it."] = "Si cette option est cochée, le cadre de la carte restera ouvert jusqu'à ce que vous le fermiez."
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Si coché, la carte restera centrée sur votre position tant que vous n'êtes pas dans un donjon. |n|nVous pouvez maintenir la touche Maj en faisant glisser la carte pour l'empêcher temporairement de se recentrer."
L["If checked, the minimap button will be shown."] = "Si cette option est cochée, le bouton de la mini-carte sera affiché."
L["If checked, the minimum fishing skill levels will be shown."] = "Si cette option est cochée, les niveaux de compétence de pêche minimum seront affichés."
L["If checked, town and city icons will not be shown on the continent maps."] = "Si cette option est cochée, les icônes de ville et de cité ne seront pas affichées sur les cartes du continent."
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Si coché, les points de déplacement pour la faction adverse seront affichés. |n|nCela inclut les points de vol, les ports de bateau, les tours de zeppelin et les stations de tramway."
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Si coché, les points de déplacement pour la même faction seront affichés. |n|nCela inclut les points de vol, les ports de bateau, les tours de zeppelin et les stations de tramway."
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "Si coché, les zones inexplorées de la carte seront affichées sur la carte du monde et la carte de champ de bataille."
L["If checked, unexplored areas will be tinted."] = "Si cette option est cochée, les zones inexplorées seront teintées."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Si cette option est cochée, lorsque votre personnage change de zone, la carte passe automatiquement à la nouvelle zone."
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "Si coché, vous pouvez déplacer la carte de champ de bataille en faisant glisser l'un de ses bords. |n|nVous pouvez redimensionner la carte de champ de bataille en faisant glisser le coin inférieur droit."
L["If checked, you will be able to customise the battlefield map."] = "Si cette option est cochée, vous pourrez personnaliser la carte du champ de bataille."
L["If checked, you will be able to enlarge the player arrow."] = "Si cette option est cochée, vous pourrez agrandir la flèche du joueur."
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "Si coché, vous pourrez mettre à l'échelle la carte en faisant glisser la poignée d'échelle dans le coin inférieur droit. |n|nVous pourrez déplacer la carte en faisant glisser n'importe quel bord. |n|nVous pouvez toujours faire glisser le bord supérieur pour déplacer la carte indépendamment de ce paramètre."
L["If checked, you will be able to set the opacity of the map."] = "Si cette option est cochée, vous pourrez définir l'opacité de la carte."
L["If checked, you will be able to zoom further into the world map."] = "Si coché, vous pourrez zoomer davantage dans la carte du monde."
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "Si coché, les menus déroulants des zones et des continents seront affichés dans le cadre de la carte."
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "Si coché, les passages de zone seront affichés. |n|nCe sont des flèches cliquables qui indiquent les voies de sortie de la zone."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Si cette option est cochée, les niveaux de compétence de zone, de donjon et de pêche seront affichés."
L["Increase zoom level"] = "Augmenter le niveau de zoom"
L["Invalid command.  Enter /ltm help for help."] = "Commande non valide. Entrez /ltm help pour obtenir de l'aide."
L["Invalid command. Enter /ltm help for help."] = "Commande invalide. Entrez /ltm help pour obtenir de l'aide."
L["Invalid map ID."] = "ID de carte non valide."
L["Ironforge"] = "Ironforge"
L["Isle of Quel'Danas"] = "Île de Quel'Danas"
L["K3"] = "K3"
L["Kamagua"] = "Kamagua"
L["Karazhan"] = "Karazhan"
L["Kargath"] = "Kargath"
L["Kor'kron Vanguard"] = "Vanguard Kor'kron"
L["Lake Elune'ara"] = "Lac Elune'ara"
L["Lake Everstill"] = "Lac Placide"
L["Large Scarab Coffer"] = "Grand coffre de scarabées"
L["Leads to Tirisfal Glades"] = "Mène à Clairières de Tirisfal"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS : UNE VERSION INCORRECTE EST INSTALLÉE !"
L["Light's Breach"] = "Brèche de la Lumière"
L["Light's Hope Chapel"] = "Chapelle de l'Espoir de Lumière"
L["Loch Modan"] = "Loch Modan"
L["Lower Blackrock Spire"] = "Pic Blackrock Inférieur"
L["Magisters' Terrace"] = "Terrasse des Magistères"
L["Magtheridon's Lair"] = "Le repaire de Magtheridon"
L["Mana-Tombs"] = "Tombes-mana"
L["Map frame scale"] = "Échelle du cadre de la carte"
L["Map Opacity"] = "Opacité de la carte"
L["Map Scale"] = "Échelle de la carte"
L["Map Size"] = "Taille de la carte"
L["MapScale"] = "ÉchelleCarte"
L["Maraudon"] = "Maraudon"
L["Marshal's Refuge"] = "Refuge des Marshal"
L["Max Zoom"] = "Zoom Max"
L["Maximum"] = "Maximum"
L["Mechanics"] = "Mécanique"
L["Memory Usage"] = "Utilisation de la mémoire"
L["Menethil Harbor"] = "Port de Menethil"
L["Miscellaneous"] = "Divers"
L["Moa'ki"] = "Moa'ki"
L["Moa'ki Harbor"] = "Port Moa'ki"
L["Mok'Nathal Village"] = "Mok'Nathal"
L["Molten Core"] = "Cœur du Magma"
L["Moonglade"] = "Reflet-de-Lune"
L["More"] = "Plus"
L["Morgan's Vigil"] = "Veille de Morgan"
L["Moving"] = "En mouvement"
L["Mudsprocket"] = "Bourbe-à-Brac"
L["Mulgore"] = "Mulgore"
L["Nagrand"] = "Nagrand"
L["Naxxramas"] = "Naxxramas"
L["Nesingwary Base Camp"] = "Camp de base de Nesingwary"
L["Nethergarde Keep"] = "Rempart-du-Néant"
L["Netherstorm"] = "Raz-de-Néant"
L["Never"] = "Jamais"
L["New Agamand"] = "Nouvelle-Agamand"
L["Nighthaven"] = "Havrenuit"
L["Nijel's Point"] = "Combe de Nijel"
L["North"] = "Nord"
L["North Gate Pass"] = "Col du Nord"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "AVIS!|nVous devez redémarrer complètement votre client de jeu avant de pouvoir utiliser cette version de Leatrix Maps."
L["Old Hillsbrad"] = "Vieil Hillsbrad"
L["Old Hillsbrad Foothills"] = "Contreforts de Hautebrande d’antan"
L["Onyxia's Lair"] = "Repaire d'Onyxia"
L["Opacity"] = "Opacité"
L["or click the minimap button to open Leatrix Maps."] = "ou cliquez sur le bouton de la mini-carte pour ouvrir Leatrix Maps."
L["Orb of Translocation"] = "Orbe de translocation"
L["Orebor Harborage"] = "Havre d'Orebor"
L["Orgrimmar"] = "Orgrimmar"
L["Player"] = "Joueur"
L["Player Arrow"] = "Flèche du joueur"
L["Portal"] = "Portail"
L["Portal from Zephyr"] = "Portail de Zephyr"
L["Portals"] = "Portails"
L["Preview"] = "Voir en avant-première"
L["Ragefire Chasm"] = "Gouffre de Ragefeu"
L["Raid"] = "Raid"
L["Ratchet"] = "Ratchet"
L["Ravenholdt Manor"] = "Manoir de Ravenholdt"
L["Razorfen Downs"] = "Souilles de Tranchebauge"
L["Razorfen Kraul"] = "Kraal de Tranchebauge"
L["Razorthorn Trail"] = "Sentier de Rasoir"
L["Rebel Camp"] = "Camp rebelle"
L["Red"] = "Rouge"
L["Redridge Mountains"] = "Les Carmines"
L["Refuge Pointe"] = "Refuge de l'Ornière"
L["Reload"] = "Recharger"
L["Remember zoom level"] = "Niveau de zoom"
L["Remove map border"] = "Bordure de la carte"
L["req"] = "exige"
L["Requires Key to Searing Gorge"] = "Nécessite la clé des Gorges de la Searing"
L["Requires UI reload."] = "Nécessite le rechargement de l'interface utilisateur."
L["Reset"] = "Réinitialiser"
L["Reset Map Layout"] = "Réinitialiser la disposition de la carte"
L["Revantusk Village"] = "Village des Revantusk"
L["River's Heart"] = "Cœur de la Rivière"
L["Ruins of Ahn'Qiraj"] = "Ruines d'Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruines d’Elune’eth"
L["Rut'theran Village"] = "Village de Rut'theran"
L["Rut'Theran Village"] = "Village de Rut'Theran"
L["Sanctum of the Stars"] = "Sanctum des étoiles"
L["Scale"] = "Échelle"
L["Scarlet Monastery"] = "Monastère écarlate"
L["Scholomance"] = "Scholomance"
L["Searing Gorge"] = "Gorge des Vents brûlants"
L["Seat of the Naaru"] = "Siège des Naaru"
L["Sentinel Hill"] = "Colline des Sentinelles"
L["Serpentshrine Cavern"] = "Caverne du sanctuaire du Serpent"
L["Set map opacity"] = "Opacité de la carte"
L["Set map opacity while stationary and while moving."] = "Définissez l'opacité de la carte à l'arrêt et en mouvement."
L["Set the group icon size."] = "Définissez la taille de l'icône du groupe."
L["Set the maximum zoom scale."] = "Définir l'échelle de zoom maximale."
L["Set the player arrow size."] = "Définissez la taille de la flèche du lecteur."
L["Sethekk Halls"] = "Les salles des Sethekk"
L["Settings"] = "Paramètres"
L["Sewers"] = "Égouts"
L["Shadow Labyrinth"] = "Labyrinthe des Ombres"
L["Shadowfang Keep"] = "Donjon d'Ombrecroc"
L["Shadowmoon Valley"] = "Vallée d’Ombrelune"
L["Shadowmoon Village"] = "Village d'Ombrelune"
L["Shadowprey Village"] = "Proie-de-l'Ombre"
L["Shatter Point"] = "Point de Rupture"
L["Shattrath"] = "Shattrath"
L["Shattrath City"] = "Cité de Shattrath"
L["Sholazar Basin"] = "Bassin de Sholazar"
L["Show boats, zeppelins and trams"] = "Afficher les bateaux, les zeppelins et les trams"
L["Show coordinates"] = "Coordonnées"
L["Show dungeons and raids"] = "Afficher les donjons et les raids"
L["Show minimap button"] = "Bouton de la mini-carte"
L["Show minimum fishing skill levels"] = "Afficher les niveaux de compétence de pêche minimum"
L["Show objectives"] = "Afficher les objectifs"
L["Show points of interest"] = "Points d'intérêt"
L["Show scale handle"] = "Afficher la poignée de l'échelle"
L["Show spirit healers"] = "Afficher les Gardiens des âmes"
L["Show travel points for opposing faction"] = "Afficher les points de voyage pour la faction opposée"
L["Show travel points for same faction"] = "Afficher les points de voyage pour la même faction"
L["Show unexplored areas"] = "Zones inexplorées"
L["Show zone crossings"] = "Afficher les passages de zone"
L["Show zone levels"] = "Niveaux de zone"
L["Show zone menus"] = "Afficher les menus de zone"
L["Silithus"] = "Silithus"
L["Silvermoon"] = "Lune-d'Argent"
L["Silvermoon City"] = "Lune-d’Argent"
L["Silverpine Forest"] = "Forêt des Pins argentés"
L["Slave Pens"] = "Les enclos aux esclaves"
L["South"] = "Sud"
L["South Gate Pass"] = "Passe de la Porte du Sud"
L["Southfury River"] = "Rivière Furie-du-Sud"
L["Southshore"] = "Southshore"
L["Spinebreaker Ridge"] = "Crête Brise-échine"
L["Spirit Healer"] = "Gardien des âmes"
L["Splintertree Post"] = "Poste de Bois-brisé"
L["Stars' Rest"] = "Repos des Étoiles"
L["Stationary"] = "Stationnaire"
L["Steamvault"] = "Le caveau de la Vapeur"
L["Sticky map frame"] = "Carte collante"
L["Stonard"] = "Stonard"
L["Stonebreaker Hold"] = "Fort des Brise-Pierres"
L["Stonetalon Mountains"] = "Les Serres-Rocheuses"
L["Stonetalon Peak"] = "Pic des Serres-Rocheuses"
L["Stormwind"] = "Stormwind"
L["Stormwind City"] = "Hurlevent"
L["Stranglethorn Vale"] = "Vallée de Strangleronce"
L["Stratholme (Main Gate)"] = "Stratholme (Porte Principale)"
L["Stratholme (Service Gate)"] = "Stratholme (Porte de Service)"
L["sum"] = "convoquer"
L["Sun Rock Retreat"] = "Retraite de Roche-Soleil"
L["Sunreaver's Command"] = "Commandement de la Saccage-soleil"
L["Sun's Reach Harbor"] = "Port du Brasier solaire"
L["Sunwell Plateau"] = "Plateau du Puits de soleil"
L["Swamp of Sorrows"] = "Marais des Chagrins"
L["Swamprat Post"] = "Poste du Rat des marais"
L["Sylvanaar"] = "Sylvanaar"
L["System"] = "Système"
L["Talonbranch Glade"] = "Clairière de Griffebranche"
L["Talrendis Point"] = "Halte de Talrendis"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Moulin-de-Tarren"
L["Taunka'le Village"] = "Village de Taunka'le"
L["Telaar"] = "Telaar"
L["Teldrassil"] = "Teldrassil"
L["Teleport Crystal"] = "Cristal de téléportation"
L["Telredor"] = "Telredor"
L["Tempest Keep"] = "Donjon de la Tempête"
L["Temple of Ahn'Qiraj"] = "Temple d'Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Le temple d'Atal'Hakkar"
L["Temple of Telhamat"] = "Temple de Telhamat"
L["Terokkar Forest"] = "Forêt de Terokkar"
L["Thalanaar"] = "Thalanaar"
L["Thandol Span"] = "Pont de Thandol"
L["The Arcatraz"] = "L’Arcatraz"
L["The Argent Stand"] = "Le Séjour d'Argent"
L["The Argent Vanguard"] = "L'Avant-garde d'Argent"
L["The Barrens"] = "Les Tarides"
L["The Blood Furnace"] = "La Fournaise du sang"
L["The Botanica"] = "La Botanica"
L["The Bulwark"] = "Le Rempart"
L["The Crossroads"] = "La Croisée"
L["The Dark Portal"] = "Porte des ténèbres"
L["The Deadmines"] = "Les Mortemines"
L["The Exodar"] = "L'Exodar"
L["The Eye"] = "L'Œil"
L["The Eye of Eternity"] = "L'Œil de l'Éternité"
L["The Forge of Souls"] = "La Forge des Âmes"
L["The Forgotten Coast"] = "La Côte oubliée"
L["The Frozen Halls"] = "Les Halls Gelés"
L["The Great Forge"] = "La Grande Forge"
L["The Great Lift"] = "La Grande Ascenseur"
L["The Halls of Reflection"] = "Les Salles des Reflets"
L["The Hinterlands"] = "Les Hinterlands"
L["The Mechanar"] = "Le Méchanar"
L["The Nexus"] = "Le Nexus"
L["The Obsidian Sanctum"] = "Le Sanctum Obsidien"
L["The Oculus"] = "L'Oculus"
L["The Old Kingdom"] = "L'Ancien royaume"
L["The Pit of Saron"] = "La Fosse de Saron"
L["The Ruby Sanctum"] = "Le Sanctum Rubis"
L["The Sepulcher"] = "Le Sépulcre"
L["The Shadow Vault"] = "La Voûte de l'Ombre"
L["The Shattered Halls"] = "Les salles Brisées"
L["The Stockade"] = "La Prison"
L["The Storm Peaks"] = "Les pics Foudroyés"
L["The Stormspire"] = "La Foudreflèche"
L["The Talondeep Path"] = "Le Sentier des Serres-profondes"
L["The Vault of Lights"] = "Le Caveau des Lumières"
L["The Violet Hold"] = "L'Étage Violet"
L["The Zoram Strand"] = "La grève de Zoram"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Ile de Theramore"
L["Thorium Point"] = "Halte du Thorium"
L["Thousand Needles"] = "Mille pointes"
L["Thrallmar"] = "Thrallmar"
L["Thunder Bluff"] = "Thunder Bluff"
L["Thunderlord Stronghold"] = "Bastion des Sire-tonnerre"
L["Timbermaw Hold"] = "Fort cénarien"
L["Tinker Town"] = "Brikabrok"
L["Tint unexplored areas"] = "Teinter des zones inexplorées"
L["Tirisfal Glades"] = "Clairières de Tirisfal"
L["Toggle panel"] = "Basculer le panneau"
L["Toshley's Station"] = "Poste de Toshley"
L["Trade District"] = "Quartier Commercant"
L["Trade Quarter"] = "Quartier des Marchands"
L["Tram to"] = "Tram à"
L["Tranquillien"] = "Tranquillien"
L["Transitus Shield"] = "Bouclier de Transitus"
L["Transparency"] = "Transparence"
L["Trial of the Champion"] = "L'Épreuve du Champion"
L["Trial of the Crusader"] = "L'Épreuve du Croisé"
L["Twilight Shore"] = "Rivage du Crépuscule"
L["Twilight Vale"] = "Vallée du Crépuscule"
L["Uldaman"] = "Uldaman"
L["Uldaman (side entrance)"] = "Uldaman (entrée latérale)"
L["Ulduar"] = "Ulduar"
L["Underbog"] = "La Basse-tourbière"
L["Undercity"] = "Undercity"
L["Un'Goro Crater"] = "Cratère d'Un'Goro"
L["Unlock battlefield map"] = "Déverrouiller la carte du champ de bataille"
L["Unlock map frame"] = "Déverrouiller la carte"
L["Unu'pe"] = "Unu'pe"
L["Upper Blackrock Spire"] = "Pic Blackrock Supérieur"
L["Use default map"] = "Carte par défaut"
L["Use stationary opacity while pointing at map"] = "Utilisez l'opacité stationnaire tout en pointant sur la carte"
L["Utgarde Keep"] = "Donjon d'Utgarde"
L["Utgarde Pinnacle"] = "Cime d'Utgarde"
L["Valaar's Berth"] = "Amarrage de Valaar"
L["Valgarde"] = "Valgarde"
L["Valgarde Port"] = "Port de Valgarde"
L["Valiance Keep"] = "Donjon de la Vaillance"
L["Valiance Landing Camp"] = "Camp d'atterrissage de la Vaillance"
L["Valley of Strength"] = "Vallée de la Force"
L["Valormok"] = "Valormok"
L["Vault of Archavon"] = "Caveau d'Archavon"
L["Vengeance Landing"] = "Halte de la Vengeance"
L["Venomspite"] = "Venimspire"
L["Version"] = "Version"
L["Wailing Caverns"] = "Cavernes des lamentations"
L["Warsong Camp"] = "Camp Chanteguerre"
L["Warsong Hold"] = "Bastion Chanteguerre"
L["Western Plaguelands"] = "Maleterres de l'ouest"
L["Westfall"] = "Marche de l'Ouest"
L["Westfall Brigade"] = "Brigade de la marche de l'Ouest"
L["Westguard Keep"] = "Donjon de la Garde de l'Ouest"
L["Wetlands"] = "Les Paluns"
L["Wildhammer Stronghold"] = "Bastion Marteau-Hardi"
L["Windrunner's Overlook"] = "Surplomb de Coursevent"
L["Wintergarde Keep"] = "Donjon de Garde-hiver"
L["Wintergrasp"] = "Joug-d'hiver"
L["Winterspring"] = "Berceau-de-l'Hiver"
L["Wrath of the Lich King Classic"] = "Classique : Wrath of the Lich King"
L["Wyrmrest Temple"] = "Temple du Repos du Ver"
L["You will die!"] = "Vous allez mourir !"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Votre interface utilisateur doit être rechargée pour que certaines des modifications prennent effet.|n|nVous n'avez pas besoin de cliquer immédiatement sur le bouton de rechargement, mais vous devez le cliquer lorsque vous avez terminé d'apporter des modifications et que vous souhaitez que les modifications prennent effet."
L["Your UI needs to be reloaded."] = "Votre interface utilisateur doit être rechargée."
L["Zabra'jin"] = "Zabra'jin"
L["Zangarmarsh"] = "Marécage de Zangar"
L["Zeb'Sora"] = "Zeb'Sora"
L["Zeppelin to"] = "Zeppelin à"
L["Zim'Torga"] = "Zim'Torga"
L["Zone Map"] = "Carte de la zone"
L["Zoom"] = "Zoom"
L["Zoram'gar Outpost"] = "L’Avant-poste de Zoram'gar"
L["Zul'Aman"] = "Zul'Aman"
L["Zul'Drak"] = "Zul'Drak"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end

-- itIT: Italian
if GameLocale == "itIT" then

end

-- ptBR: Portugese (Brazil)
if GameLocale == "ptBR" then
L["(destination only)"] = "(apenas destino)"
L["(inside Caverns of Time)"] = "(dentro de Cavernas do Tempo)"
L["/ltm help - Show this information."] = "/ltm help - Mostra essas informações."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Redefine a posição do painel."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Limpe todas as configurações e recarregue."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Ocorreu um erro de parada, mas não precisa se preocupar. Isso pode acontecer de tempos em tempos. Clique no botão recarregar para resolvê-lo."
L["A stop error has occurred but no need to worry. It can happen from time to time. Click the reload button to resolve it."] = "Ocorreu um erro, mas não se preocupe. Isso pode acontecer de vez em quando. Clique no botão de recarregar para resolvê-lo."
L["Acherus: The Ebon Hold"] = "Acherus: O Forte Ébano"
L["Aerie Peak"] = "Ninho da Águia"
L["Agmar's Hammer"] = "Martelo de Agmar"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Aldor"] = "Aldor"
L["Allerian Stronghold"] = "Fortaleza Alleriana"
L["Alliance Cities"] = "Cidades da Aliança"
L["Alpha"] = "Alfa"
L["Altar of Sha'tar"] = "Altar de Sha'tar"
L["Alterac Mountains"] = "Montanhas de Alterac"
L["Always"] = "Sempre"
L["Amber Lodge"] = "Lodgmento Âmbar"
L["Amberpine Lodge"] = "Lodgmento Pinhoâmbar"
L["Apothecary Camp"] = "Acampamento de Alquimistas"
L["Appearance"] = "Aparência"
L["Arathi Highlands"] = "Planalto Arathi"
L["Area 52"] = "Área 52"
L["Argent Tournament Grounds"] = "Campo de Torneio Argênteo"
L["Ashenvale"] = "Vale Gris"
L["Astranaar"] = "Astranaar"
L["Auberdine"] = "Auberdine"
L["Auchenai Crypts"] = "Catacumbas Auchenai"
L["Auto change zones"] = "Alterar zonas"
L["Azeroth"] = "Azeroth"
L["Azjol-Nerub"] = "Azjol-Nerub"
L["Azshara"] = "Azshara"
L["Azuremyst Isle"] = "Ilha Névoa Lazúli"
L["Back to Main Menu"] = "Voltar ao menu principal"
L["Badlands"] = "Ermos"
L["Battlegrounds"] = "Campos de Batalha"
L["Black Morass"] = "Lamaçal Negro"
L["Black Temple"] = "Templo Negro"
L["Blackfathom Deeps"] = "Profundezas Negras"
L["Blackrock Depths"] = "Abismo Rocha Negra"
L["Blackrock Mountain"] = "Montanha Rocha Negra"
L["Blackwing Lair"] = "Covil Asa Negra"
L["Blade Tooth Canyon"] = "Cânion Presadentada"
L["Blade's Edge Mountains"] = "Montanhas da Lâmina Afiada"
L["Blades' Run"] = "Trilha das Lâminas"
L["Blasted Lands"] = "Barreira do Inferno"
L["Blood Watch"] = "Entreposto Rubro"
L["Bloodmyst Isle"] = "Ilha Névoa Rubra"
L["Bloodvenom Post"] = "Posto Peçonha"
L["Blue"] = "Azul"
L["Boat to"] = "Barco para"
L["Booty Bay"] = "Angra do Butim"
L["Borean Tundra"] = "Tundra Boreana"
L["Bor'gorok Outpost"] = "Posto Avançado Bor'gorok"
L["Bouldercrag's Refuge"] = "Refúgio de Rochapedra"
L["Brackenwall Village"] = "Aldeia Muralha Verde"
L["Burning Crusade Classic"] = "Burning Crusade Classic"
L["Burning Steppes"] = "Estepes Ardentes"
L["Camp Mojache"] = "Aldeia Mojache"
L["Camp Oneqwah"] = "Acampamento Ôniqwah"
L["Camp Taurajo"] = "Acampamento Taurajo"
L["Camp Tunka'lo"] = "Acampamento Tunka'lo"
L["Camp Winterhoof"] = "Acampamento Cascogelado"
L["Caverns of Time"] = "Cavernas do Tempo"
L["Cenarion Hold"] = "Forte Cenariano"
L["Center map on player"] = "Centralizar mapa no jogador"
L["Central Mesa"] = "Mesa Central"
L["Chillwind Camp"] = "Acampamento Ventogelante"
L["Choose where the zone map should be shown."] = "Escolha onde o mapa da zona deve ser exibido."
L["Class colored icons"] = "Ícones coloridos"
L["Classic"] = "Clássico"
L["Click to configure the settings for this option."] = "Clique para definir as configurações para esta opção."
L["Click to reset the position and scale of the map frame."] = "Clique para redefinir a posição e a escala do quadro do mapa."
L["Click to reset the settings on this page."] = "Clique para redefinir as configurações nesta página."
L["Click to return to the main menu."] = "Clique para retornar ao menu principal."
L["Coilfang Reservoir"] = "Reservatório Presacurva"
L["Coldarra"] = "Ferra Fria"
L["Configuration Panel"] = "Painel de Configuração"
L["Conquest Hold"] = "Fortaleza Conquista"
L["Cosmic"] = "Cósmico"
L["Cosmowrench"] = "Chave do Cosmos"
L["Crusaders' Pinnacle"] = "Pináculo dos Cruzados"
L["Crystalsong Forest"] = "Floresta Canção Cristalina"
L["Culling of Stratholme"] = "Purificação de Stratholme"
L["Cursor"] = "Cursor"
L["Dalaran"] = "Dalaran"
L["Dalaran Crater"] = "Cratera de Dalaran"
L["Darkshire"] = "Vila Sombria"
L["Darkshore"] = "Costa Negra"
L["Darnassus"] = "Darnassus"
L["Deadwind Pass"] = "Trilha do Vento Morto"
L["Death's Rise"] = "Elevação da Morte"
L["Desolace"] = "Desolação"
L["Dire Maul (East)"] = "Gládio Cruel (Leste)"
L["Dire Maul (East) (side entrance)"] = "Maraudon (Leste) (entrada lateral)"
L["Dire Maul (North)"] = "Gládio Cruel (Norte)"
L["Dire Maul (West)"] = "Gládio Cruel (Oeste)"
L["Disable reading emote when opening the map"] = "Desabilitar a leitura de emote ao abrir o mapa"
L["Drag"] = "Arrastrar"
L["Drag to set the amount of blue."] = "Arraste para definir a quantidade de azul."
L["Drag to set the amount of green."] = "Arraste para definir a quantidade de verde."
L["Drag to set the amount of red."] = "Arraste para definir a quantidade de vermelho."
L["Drag to set the battlefield map opacity."] = "Arraste para definir a opacidade do mapa do campo de batalha."
L["Drag to set the battlefield map size.|n|nIf the map is unlocked, you can also resize the battlefield map by dragging the bottom-right corner."] = "Arraste para definir o tamanho do mapa do campo de batalha.|n|nSe o mapa estiver desbloqueado, você também pode redimensioná-lo arrastando o canto inferior direito."
L["Drag to set the group icon size."] = "Arraste para definir o tamanho do ícone do grupo."
L["Drag to set the map opacity for when your character is moving."] = "Arraste para definir a opacidade do mapa para quando seu personagem estiver em movimento."
L["Drag to set the map opacity for when your character is stationary."] = "Arraste para definir a opacidade do mapa quando seu personagem estiver parado."
L["Drag to set the maximum zoom level.|n|nOpen the battlefield map to see the maximum zoom level change as you drag the slider."] = "Arraste para definir o nível máximo de zoom.|n|nAbra o mapa do campo de batalha para ver a mudança no nível máximo de zoom conforme você arrasta o controle deslizante."
L["Drag to set the maximum zoom level.|n|nOpen the map to see the maximum zoom level change as you drag the slider."] = "Arraste para definir o nível máximo de zoom.|n|nAbra o mapa para ver a mudança no nível máximo de zoom conforme você arrasta o controle deslizante."
L["Drag to set the opacity."] = "Arraste para definir a opacidade."
L["Drag to set the player arrow size."] = "Arrasta para definir o tamanho da seta do jogador."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Arraste para definir o tamanho da flecha do jogador.|n|nO WoW clássico do Wow é 16.|nO WoW Retail é 27."
L["Drag to set the world map scale.|n|nYou can also rescale the world map by dragging the bottom-right corner."] = "Arraste para definir a escala do mapa-múndi.|n|nVocê também pode redimensionar o mapa-múndi arrastando o canto inferior direito."
L["Dragonblight"] = "Ermo das Serpes"
L["Drak'Tharon Keep"] = "Forte Drak'Tharon"
L["Druid only flight point to Darnassus"] = "Druida apenas ponto de voo para Darnassus"
L["Druid only flight point to Thunder Bluff"] = "Druida apenas ponto de voo para Penhasco do Trovão"
L["Dun Algaz"] = "Dun Algaz"
L["Dun Morogh"] = "Dun Morogh"
L["Dun Nifflelem"] = "Dun Nifflelem"
L["Dungeon"] = "Masmorra"
L["Dungeon (requires Crescent Key)"] = "Masmorra (requer Chave Crescente)"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Floresta do Crepúsculo"
L["Dustwallow Marsh"] = "Pântano Vadeoso"
L["Dwarven District"] = "Distrito dos Anões"
L["Eastern Plaguelands"] = "Terras Pestilentas Orientais"
L["Ebon Watch"] = "Vigília Ébano"
L["Elements"] = "Visibilidade"
L["Elwynn Forest"] = "Floresta de Elwynn"
L["Emerald Sanctuary"] = "Santuário Esmeralda"
L["Enhance battlefield map"] = "Melhorar o mapa do campo de batalha"
L["Enlarge player arrow"] = "Flecha do jogador"
L["Enter"] = "Entrar"
L["Evergrove"] = "Arvoredo Eterno"
L["Everlook"] = "Visteterna"
L["Eversong Woods"] = "Floresta do Canto Eterno"
L["Exodar"] = "Exodar"
L["Falcon Watch"] = "Vigília do Falcão"
L["Feathermoon Stronghold"] = "Domínio de Plumaluna"
L["Felwood"] = "Selva Maleva"
L["Feralas"] = "Feralas"
L["Fishing"] = "Pesca"
L["Fizzcrank Airstrip"] = "Pista de Pouso Aeronauta"
L["Flame Crest"] = "Monte Candente"
L["Fordragon Hold"] = "Fortaleza Fordragon"
L["Forest Song"] = "Canto da Floresta"
L["Fort Wildervar"] = "Fortaleza Gelo Selvagem"
L["Freewind Post"] = "Aldeia Vento Livre"
L["Frosthold"] = "Vigília Glacial"
L["Gadgetzan"] = "Geringontzan"
L["Garadar"] = "Garadar"
L["Ghostlands"] = "Terra Fantasma"
L["Gnomeregan"] = "Gnomeregan"
L["Green"] = "Verde"
L["Grizzly Hills"] = "Serra Gris"
L["Grom'arsh Crash Site"] = "Local da Queda de Grom'arsh"
L["Grom'gol Base Camp"] = "Acampamento Grom'gol"
L["Group Icons"] = "Ícones de grupo"
L["Gruul's Lair"] = "Covil de Gruul"
L["Gundrak"] = "Gundrak"
L["Gundrak (rear entrance)"] = "Gundrak (entrada traseira)"
L["Halls of Lightning"] = "Salões Relampejantes"
L["Halls of Stone"] = "Salões de Pedra"
L["Hammerfall"] = "Ruína do Martelo"
L["Head down the mountain from here."] = "Desça a montanha daqui."
L["Head southeast from here and go up the mountain."] = "Siga sudeste daqui e suba a montanha."
L["Hellfire Peninsula"] = "Península Fogo do Inferno"
L["Hellfire Ramparts"] = "Muralha Fogo do Inferno"
L["Hide town and city icons"] = "Vilas e cidades"
L["Hillsbrad Foothills"] = "Contraforte de Eira dos Montes"
L["Honor Hold"] = "Fortaleza da Honra"
L["Horde Cities"] = "Cidades da Horda"
L["Howling Fjord"] = "Fiorde Uivante"
L["Hyjal Summit"] = "Pico Hyjal"
L["Icecrown"] = "Coroa de Gelo"
L["Icecrown Citadel"] = "Cidadela da Coroa de Gelo"
L["Icons"] = "Ícones"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "Se marcado, serão exibidos portos de barcos, torres zepelin e estações de metrô."
L["If checked, coordinates will be shown."] = "Se marcado, as coordenadas serão mostradas."
L["If checked, dungeons and raids will be shown."] = "Se marcado, masmorras e raides serão mostrados."
L["If checked, group icons will use a modern, class-colored design."] = "Se marcado, os ícones de grupo usarão um design moderno e colorido em classe."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Se marcado, a abertura do mapa usará o mesmo nível de zoom desde a última vez que você o fechou, desde que a zona do mapa não tenha sido alterada."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Se marcado, apontar para o mapa enquanto seu personagem estiver em movimento fará com que a configuração de opacidade estacionária seja aplicada."
L["If checked, points of interest will be shown."] = "Se marcado, os pontos de interesse serão mostrados."
L["If checked, quest objectives will be shown."] = "Se marcado, os objetivos da missão serão exibidos."
L["If checked, spirit healers will be shown."] = "Se marcada, os Anjos da Cura serão mostrados."
L["If checked, the battlefield map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Se marcado, o mapa do campo de batalha permanecerá centrado em sua localização, desde que você não esteja em uma masmorra.|n|nVocê pode segurar shift enquanto movimenta o mapa para evitar temporariamente que ele se centralize."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Se marcado, o mapa padrão em tela cheia será usado.|n|nObserve que ativar essa opção bloqueará algumas das outras opções."
L["If checked, the map border will be removed."] = "Se marcado, a borda do mapa será removida."
L["If checked, the map frame will remain open until you close it."] = "Se marcado, o quadro do mapa permanecerá aberto até você fechá-lo."
L["If checked, the map will stay centered on your location as long as you are not in a dungeon.|n|nYou can hold shift while panning the map to temporarily prevent it from centering."] = "Se marcado, o mapa permanecerá centrado em sua localização, desde que você não esteja em uma masmorra.|n|nVocê pode segurar shift enquanto movimenta o mapa para evitar temporariamente que ele se centralize."
L["If checked, the minimap button will be shown."] = "Se marcado, o botão minimapa será mostrado."
L["If checked, the minimum fishing skill levels will be shown."] = "Se marcado, os níveis mínimos de habilidade de pesca serão mostrados."
L["If checked, town and city icons will not be shown on the continent maps."] = "Se marcado, os ícones de vila e cidade não serão mostrados nos mapas do continente."
L["If checked, travel points for the opposing faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Se marcado, os pontos de viagem para a facção oposta serão exibidos.|n|nIsso inclui pontos de voo, portos de barcos, torres de zepelim e estações de bonde."
L["If checked, travel points for the same faction will be shown.|n|nThis includes flight points, boat harbors, zeppelin towers and tram stations."] = "Se marcado, os pontos de viagem para a mesma facção serão exibidos.|n|nIsso inclui pontos de voo, portos de barcos, torres de zepelim e estações de bonde."
L["If checked, unexplored areas of the map will be shown on the world map and the battlefield map."] = "Se marcado, as áreas inexploradas do mapa serão exibidas no mapa-múndi e no mapa do campo de batalha."
L["If checked, unexplored areas will be tinted."] = "Se marcada, áreas inexploradas serão matizadas."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Se marcado, quando seu personagem muda de zona, o mapa muda automaticamente para a nova zona."
L["If checked, you can move the battlefield map by dragging any of its borders.|n|nYou can resize the battlefield map by dragging the bottom-right corner."] = "Se marcado, você pode mover o mapa do campo de batalha arrastando qualquer uma de suas bordas.|n|nPode redimensionar o mapa do campo de batalha arrastando o canto inferior direito."
L["If checked, you will be able to customise the battlefield map."] = "Se marcado, você poderá personalizar o mapa do campo de batalha."
L["If checked, you will be able to enlarge the player arrow."] = "Se marcado, você poderá ampliar a flecha do jogador."
L["If checked, you will be able to scale the map by dragging the scale handle in the bottom-right corner.|n|nYou will be able to move the map by dragging any border.|n|nYou can always drag the top border to move the map regardless of this setting."] = "Se marcado, você poderá dimensionar o mapa arrastando a alça de escala no canto inferior direito.|n|nVocê poderá mover o mapa arrastando qualquer borda.|n|nVocê sempre pode arrastar a borda superior para mover o mapa, independentemente dessa configuração."
L["If checked, you will be able to set the opacity of the map."] = "Se marcado, você poderá definir a opacidade do mapa."
L["If checked, you will be able to zoom further into the world map."] = "Se marcado, você poderá aumentar mais o zoom no mapa-múndi."
L["If checked, zone and continent dropdown menus will be shown in the map frame."] = "Se marcado, os menus suspensos de zona e continente serão exibidos no quadro do mapa."
L["If checked, zone crossings will be shown.|n|nThese are clickable arrows that indicate the zone exit pathways."] = "Se marcado, as travessias de zona serão exibidas.|n|nEstas são setas clicáveis que indicam os caminhos de saída da zona."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Se marcado, os níveis de zona, masmorra e habilidade de pesca serão mostrados."
L["Increase zoom level"] = "Aumentar nível de zoom"
L["Invalid command.  Enter /ltm help for help."] = "Comando inválido. Digite /ltm help para obter ajuda."
L["Invalid command. Enter /ltm help for help."] = "Comando inválido. Digite /ltm ajuda para obter ajuda."
L["Invalid map ID."] = "ID de mapa inválido."
L["Ironforge"] = "Altaforja"
L["Isle of Quel'Danas"] = "Ilha de Quel'Danas"
L["K3"] = "K3"
L["Kamagua"] = "Kamagua"
L["Karazhan"] = "Karazhan"
L["Kargath"] = "Karrath"
L["Kor'kron Vanguard"] = "Vanguarda Kor'kron"
L["Lake Elune'ara"] = "Lago Eluna'ara"
L["Lake Everstill"] = "Lago Plácido"
L["Large Scarab Coffer"] = "Grande Arca do Escaravelho"
L["Leads to Tirisfal Glades"] = "Leva para Clareiras de Tirisfal"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: VERSÃO ERRADA INSTALADA!"
L["Light's Breach"] = "Brecha da Luz"
L["Light's Hope Chapel"] = "Capela Esperança da Luz"
L["Loch Modan"] = "Loch Modan"
L["Lower Blackrock Spire"] = "Pico da Rocha Negra Inferior"
L["Magisters' Terrace"] = "Terraço dos Magísteres"
L["Magtheridon's Lair"] = "Covil de Magtheridon"
L["Mana-Tombs"] = "Tumbas de Mana"
L["Map frame scale"] = "Escala de quadro do mapa"
L["Map Opacity"] = "Opacidade do mapa"
L["Map Scale"] = "Escala do Mapa"
L["Map Size"] = "Tamanho do mapa"
L["MapScale"] = "EscalaMapa"
L["Maraudon"] = "Maraudon"
L["Marshal's Refuge"] = "Refúgio do Marshal"
L["Max Zoom"] = "Zoom Máximo"
L["Maximum"] = "Máximo"
L["Mechanics"] = "Mecânico"
L["Memory Usage"] = "Uso de memória"
L["Menethil Harbor"] = "Porto de Menethil"
L["Miscellaneous"] = "Diversos"
L["Moa'ki"] = "Moa'ki"
L["Moa'ki Harbor"] = "Porto Moa'ki"
L["Mok'Nathal Village"] = "Vila de Mok'Nathal"
L["Molten Core"] = "Núcleo Derretido"
L["Moonglade"] = "Clareira da Lua"
L["More"] = "Mais"
L["Morgan's Vigil"] = "Vigia de Morgan"
L["Moving"] = "Movendo"
L["Mudsprocket"] = "Coroa de Barro"
L["Mulgore"] = "Mulgore"
L["Nagrand"] = "Nagrand"
L["Naxxramas"] = "Naxxramas"
L["Nesingwary Base Camp"] = "Acampamento Base de Nesingwary"
L["Nethergarde Keep"] = "Bastilha de Etergarde"
L["Netherstorm"] = "Eternévoa"
L["Never"] = "Nunca"
L["New Agamand"] = "Novo Agamand"
L["Nighthaven"] = "Refúgio Noturno"
L["Nijel's Point"] = "Posto do Nijel"
L["North"] = "Norte"
L["North Gate Pass"] = "Passe Norte"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "AVISO PRÉVIO!|nVocê deve reiniciar completamente o cliente do jogo antes de poder usar esta versão do Leatrix Maps."
L["Old Hillsbrad"] = "Antiga Colina do Sílio"
L["Old Hillsbrad Foothills"] = "Antigo Contraforte de Eira dos Montes"
L["Onyxia's Lair"] = "Covil da Onyxia"
L["Opacity"] = "Opacidade"
L["or click the minimap button to open Leatrix Maps."] = "ou clique no botão minimapa para abrir o Leatrix Maps."
L["Orb of Translocation"] = "Orbe de Translocação"
L["Orebor Harborage"] = "Porto Orebor"
L["Orgrimmar"] = "Orgrimmar"
L["Player"] = "Jogador"
L["Player Arrow"] = "Flecha do Jogador"
L["Portal"] = "Portal"
L["Portal from Zephyr"] = "Portal de Zéfiro"
L["Portals"] = "Portais"
L["Preview"] = "Pré-visualização"
L["Ragefire Chasm"] = "Cavernas Ígneas"
L["Raid"] = "Raide"
L["Ratchet"] = "Vila Catraca"
L["Ravenholdt Manor"] = "Solar dos Corvoforte"
L["Razorfen Downs"] = "Urzal dos Mortos"
L["Razorfen Kraul"] = "Urzal dos Tuscos"
L["Razorthorn Trail"] = "Trilha Espinho Cortante"
L["Rebel Camp"] = "Acampamento dos Rebeldes"
L["Red"] = "Vermelho"
L["Redridge Mountains"] = "Montanhas Cristarrubra"
L["Refuge Pointe"] = "Ponta do Refúgio"
L["Reload"] = "Recarregar"
L["Remember zoom level"] = "Nível de zoom"
L["Remove map border"] = "Borda do mapa"
L["req"] = "requer"
L["Requires Key to Searing Gorge"] = "Requer Chave para Garganta Abrasadora"
L["Requires UI reload."] = "Requer atualização da interface do usuário."
L["Reset"] = "Redefinir"
L["Reset Map Layout"] = "Redefinir disposição do mapa"
L["Revantusk Village"] = "Aldeia Revatusco"
L["River's Heart"] = "Coração do Rio"
L["Ruins of Ahn'Qiraj"] = "Ruínas de Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruínas de Elune'eth"
L["Rut'theran Village"] = "Vila de Rut'theran"
L["Rut'Theran Village"] = "Vila Rut'theran"
L["Sanctum of the Stars"] = "Sacrário Estelar"
L["Scale"] = "Escala"
L["Scarlet Monastery"] = "Monastério Escarlate"
L["Scholomance"] = "Scolomântia"
L["Searing Gorge"] = "Garganta Abrasadora"
L["Seat of the Naaru"] = "Trono dos Naarus"
L["Sentinel Hill"] = "Morro da Sentinela"
L["Serpentshrine Cavern"] = "Caverna do Serpentário"
L["Set map opacity"] = "Opacidade do mapa"
L["Set map opacity while stationary and while moving."] = "Defina a opacidade do mapa enquanto estiver parado e em movimento."
L["Set the group icon size."] = "Defina o tamanho do ícone do grupo."
L["Set the maximum zoom scale."] = "Defina a escala máxima de zoom."
L["Set the player arrow size."] = "Defina o tamanho da flecha do jogador."
L["Sethekk Halls"] = "Salões dos Sethekk"
L["Settings"] = "Configurações"
L["Sewers"] = "Esgotos"
L["Shadow Labyrinth"] = "Labirinto Soturno"
L["Shadowfang Keep"] = "Bastilha da Presa Negra"
L["Shadowmoon Valley"] = "Vale da Lua Negra"
L["Shadowmoon Village"] = "Aldeia Lua Negra"
L["Shadowprey Village"] = "Aldeia Pescassombra"
L["Shatter Point"] = "Ponto de Estilhaçamento"
L["Shattrath"] = "Shattrath"
L["Shattrath City"] = "Cidade de Shattrath"
L["Sholazar Basin"] = "Bacia Sholazar"
L["Show boats, zeppelins and trams"] = "Mostrar barcos, zepelins e metrô"
L["Show coordinates"] = "Coordenadas"
L["Show dungeons and raids"] = "Mostrar masmorras e raides"
L["Show minimap button"] = "Botão minimapa"
L["Show minimum fishing skill levels"] = "Mostrar níveis mínimos de habilidade de pesca"
L["Show objectives"] = "Mostrar objetivos"
L["Show points of interest"] = "Pontos de interesse"
L["Show scale handle"] = "Mostrar alça de escala"
L["Show spirit healers"] = "Mostrar Anjo da Cura"
L["Show travel points for opposing faction"] = "Mostrar pontos de viagem para a facção oposta"
L["Show travel points for same faction"] = "Mostrar pontos de viagem para a mesma facção"
L["Show unexplored areas"] = "Áreas inexploradas"
L["Show zone crossings"] = "Mostrar travessias de zona"
L["Show zone levels"] = "Níveis da zona"
L["Show zone menus"] = "Mostrar menus de zona"
L["Silithus"] = "Silithus"
L["Silvermoon"] = "Luaprata"
L["Silvermoon City"] = "Luaprata"
L["Silverpine Forest"] = "Floresta de Pinhaprata"
L["Slave Pens"] = "Pátio dos Escravos"
L["South"] = "Sul"
L["South Gate Pass"] = "Passe Sul da Porta"
L["Southfury River"] = "Rio Fúria do Sul"
L["Southshore"] = "Costa Sul"
L["Spinebreaker Ridge"] = "Cordilheira Quebra-Espinha"
L["Spirit Healer"] = "Anjo da Cura"
L["Splintertree Post"] = "Posto Machadada"
L["Stars' Rest"] = "Repouso das Estrelas"
L["Stationary"] = "Estacionário"
L["Steamvault"] = "Câmara dos Vapores"
L["Sticky map frame"] = "Mapa pegajoso"
L["Stonard"] = "Pedregal"
L["Stonebreaker Hold"] = "Vila de Quebrapedra"
L["Stonetalon Mountains"] = "Cordilheira das Torres de Pedra"
L["Stonetalon Peak"] = "Morro das Torres de Pedra"
L["Stormwind"] = "Ventobravo"
L["Stormwind City"] = "Cidade de Ventobravo"
L["Stranglethorn Vale"] = "Selva do Espinhaço"
L["Stratholme (Main Gate)"] = "Stratholme (Portão Principal)"
L["Stratholme (Service Gate)"] = "Stratholme (Portão de Serviço)"
L["sum"] = "convocar"
L["Sun Rock Retreat"] = "Retiro Rocha do Sol"
L["Sunreaver's Command"] = "Comando dos Fendessol"
L["Sun's Reach Harbor"] = "Porto Alcance do Sol"
L["Sunwell Plateau"] = "Platô da Nascente do Sol"
L["Swamp of Sorrows"] = "Pântano das Mágoas"
L["Swamprat Post"] = "Mocó do Rato Lamacento"
L["Sylvanaar"] = "Sylvanaar"
L["System"] = "Sistema"
L["Talonbranch Glade"] = "Clareira da Galhaça"
L["Talrendis Point"] = "Campo Talrendis"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Serraria Tarren"
L["Taunka'le Village"] = "Vila Taunka'le"
L["Telaar"] = "Telaar"
L["Teldrassil"] = "Teldrassil"
L["Teleport Crystal"] = "Cristal de Teleporte"
L["Telredor"] = "Telredor"
L["Tempest Keep"] = "Bastilha da Tormenta"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Temple of Telhamat"] = "Templo de Telhamat"
L["Terokkar Forest"] = "Mata Terokkar"
L["Thalanaar"] = "Thalanaar"
L["Thandol Span"] = "Vão Thandol"
L["The Arcatraz"] = "Arcatraz"
L["The Argent Stand"] = "O Posto Argênteo"
L["The Argent Vanguard"] = "A Vanguarda Argêntea"
L["The Barrens"] = "Sertões"
L["The Blood Furnace"] = "Fornalha de Sangue"
L["The Botanica"] = "Jardim Botânico"
L["The Bulwark"] = "O Antro"
L["The Crossroads"] = "A Encruzilhada"
L["The Dark Portal"] = "Portal Negro"
L["The Deadmines"] = "Minas Mortas"
L["The Exodar"] = "Exodar"
L["The Eye"] = "O olho"
L["The Eye of Eternity"] = "O Olho da Eternidade"
L["The Forge of Souls"] = "A Forja das Almas"
L["The Forgotten Coast"] = "Costa Esquecida"
L["The Frozen Halls"] = "Os Salões Congelados"
L["The Great Forge"] = "A Grande Forja"
L["The Great Lift"] = "O Grande Elevador"
L["The Halls of Reflection"] = "Os Salões da Reflexão"
L["The Hinterlands"] = "Terras Agrestes"
L["The Mechanar"] = "Mecanar"
L["The Nexus"] = "O Nexus"
L["The Obsidian Sanctum"] = "O Santuário Obsidiano"
L["The Oculus"] = "O Oculus"
L["The Old Kingdom"] = "O Reino Antigo"
L["The Pit of Saron"] = "A Fossa de Saron"
L["The Ruby Sanctum"] = "O Santuário Rubi"
L["The Sepulcher"] = "O Sepulcro"
L["The Shadow Vault"] = "O Alçapão Sombrio"
L["The Shattered Halls"] = "Salões Despedaçados"
L["The Stockade"] = "O Cárcere"
L["The Storm Peaks"] = "As Cimeiras Tempestuosas"
L["The Stormspire"] = "Pináculo da Tempestade"
L["The Talondeep Path"] = "O Caminho Profundo Talonclaw"
L["The Vault of Lights"] = "O Cofre das Luzes"
L["The Violet Hold"] = "O Cubo Violeta"
L["The Zoram Strand"] = "A Praia de Zoram"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Ilha Theramore"
L["Thorium Point"] = "Posto de Tório"
L["Thousand Needles"] = "Mil Agulhas"
L["Thrallmar"] = "Thrallmar"
L["Thunder Bluff"] = "Penhasco do Trovão"
L["Thunderlord Stronghold"] = "Cidadela do Senhor do Trovão"
L["Timbermaw Hold"] = "Domínio dos Presamatos"
L["Tinker Town"] = "Beco da Gambiarra"
L["Tint unexplored areas"] = "Matizar áreas inexploradas"
L["Tirisfal Glades"] = "Clareiras de Tirisfal"
L["Toggle panel"] = "Alternar painel"
L["Toshley's Station"] = "Estação do Tocha"
L["Trade District"] = "Distrito Comercial"
L["Trade Quarter"] = "Centro Comercial"
L["Tram to"] = "Metrô para"
L["Tranquillien"] = "Tranquillien"
L["Transitus Shield"] = "Escudo de Transição"
L["Transparency"] = "Transparência"
L["Trial of the Champion"] = "Prova do Campeão"
L["Trial of the Crusader"] = "Prova do Cruzado"
L["Twilight Shore"] = "Costa Crepuscular"
L["Twilight Vale"] = "Vale Crepuscular"
L["Uldaman"] = "Uldaman"
L["Uldaman (side entrance)"] = "Uldaman (entrada lateral)"
L["Ulduar"] = "Ulduar"
L["Underbog"] = "Brejo Oculto"
L["Undercity"] = "Cidade Baixa"
L["Un'Goro Crater"] = "Cratera Un'Goro"
L["Unlock battlefield map"] = "Desbloquear mapa do campo de batalha"
L["Unlock map frame"] = "Desbloquear mapa"
L["Unu'pe"] = "Unu'pe"
L["Upper Blackrock Spire"] = "Pico da Rocha Negra Superior"
L["Use default map"] = "Mapa predefinição"
L["Use stationary opacity while pointing at map"] = "Use opacidade estacionária enquanto aponta para o mapa"
L["Utgarde Keep"] = "Bastilha Utgarde"
L["Utgarde Pinnacle"] = "Pináculo Utgarde"
L["Valaar's Berth"] = "Atracadouro de Valaar"
L["Valgarde"] = "Valgarde"
L["Valgarde Port"] = "Porto Valgarde"
L["Valiance Keep"] = "Fortaleza da Bravura"
L["Valiance Landing Camp"] = "Campo de Pouso da Bravura"
L["Valley of Strength"] = "Vale da Força"
L["Valormok"] = "Valormok"
L["Vault of Archavon"] = "Câmara de Archavon"
L["Vengeance Landing"] = "Campo Vingança"
L["Venomspite"] = "Esporâmpia"
L["Version"] = "Versão"
L["Wailing Caverns"] = "Caverna Ululante"
L["Warsong Camp"] = "Campo Cantonegro"
L["Warsong Hold"] = "Fortaleza Cantonegro"
L["Western Plaguelands"] = "Terras Pestilentas Ocidentais"
L["Westfall"] = "Cerro Oeste"
L["Westfall Brigade"] = "Brigada do Oeste"
L["Westguard Keep"] = "Fortaleza Guarda Ocidental"
L["Wetlands"] = "Pantanal"
L["Wildhammer Stronghold"] = "Fortaleza Martelo Feroz"
L["Windrunner's Overlook"] = "Mirante de Correventos"
L["Wintergarde Keep"] = "Fortaleza Invernáutica"
L["Wintergrasp"] = "Razões do Inverno"
L["Winterspring"] = "Hibérnia"
L["Wrath of the Lich King Classic"] = "Clássico: Wrath of the Lich King"
L["Wyrmrest Temple"] = "Templo do Repouso do Dragão"
L["You will die!"] = "Você vai morrer!"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Sua interface do usuário precisa ser recarregada para que algumas alterações entrem em vigor.|n|nVocê não precisa clicar no botão recarregar imediatamente, mas precisa clicar nele quando concluir as alterações e desejar que as alterações entrem em vigor."
L["Your UI needs to be reloaded."] = "Sua interface do usuário precisa ser recarregada."
L["Zabra'jin"] = "Zabra'jin"
L["Zangarmarsh"] = "Pântano Zíngaro"
L["Zeb'Sora"] = "Zeb'Sora"
L["Zeppelin to"] = "Zepelin para"
L["Zim'Torga"] = "Zim'Torga"
L["Zone Map"] = "Mapa de Zona"
L["Zoom"] = "Zoom"
L["Zoram'gar Outpost"] = "Assentamento Zoram'gar"
L["Zul'Aman"] = "Zul'Aman"
L["Zul'Drak"] = "Zul'Drak"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end
