---@type SeasonOfDiscovery
local SeasonOfDiscovery = QuestieLoader:ImportModule("SeasonOfDiscovery")
---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB")

--- Load the base quests for Season of Discovery
--- These are generated, do NOT EDIT the data entries here.
--- If you want to edit an item, do so in sodItemFixes.lua
function SeasonOfDiscovery:LoadBaseItems()
    local itemKeys = QuestieDB.itemKeys

    return {
        [202251] = {
            [itemKeys.name] = "Bag of Pet Treats",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [202254] = {
            [itemKeys.name] = "Bracers of Redirection",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [202256] = {
            [itemKeys.name] = "Privateer's Ornate Pistol",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [202316] = {
            [itemKeys.name] = "Runecarving Test - Crippling Poison",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [202641] = {
            [itemKeys.name] = "Mud-covered notebook",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203723] = {
            [itemKeys.name] = "Cutty's Note",
            [itemKeys.npcDrops] = {103,473},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203726] = {
            [itemKeys.name] = "Cutty's Rune",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203745] = {
            [itemKeys.name] = "Spell Notes: Ice Lance",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [203746] = {
            [itemKeys.name] = "Spell Notes: Living Flame",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [203747] = {
            [itemKeys.name] = "Spell Notes: Fingers of Frost",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [203748] = {
            [itemKeys.name] = "Spell Notes: Burnout",
            [itemKeys.npcDrops] = {202060,208275,208752},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [203749] = {
            [itemKeys.name] = "Spell Notes: Enlightenment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [203750] = {
            [itemKeys.name] = "Elwynn Treasure Map",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203751] = {
            [itemKeys.name] = "Spell Notes: CALE ENCI",
            [itemKeys.npcDrops] = {38,1507},
            [itemKeys.objectDrops] = {404695,405633},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203752] = {
            [itemKeys.name] = "Spell Notes: MILEGIN VALF",
            [itemKeys.npcDrops] = {476,1124,1397,1535,1536,1537,3195,3196,3197,3198,3199},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203753] = {
            [itemKeys.name] = "Spell Notes: RING SEFF OSTROF",
            [itemKeys.npcDrops] = {448,1119,1130,1132,1137,1260,1271,1388,1961,3203,3204,3205,5808,5822,6113,6124,8503,208196,208638},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203754] = {
            [itemKeys.name] = "Archmage Antonidas: The Unabridged Autobiography",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {386691},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203755] = {
            [itemKeys.name] = "Archmage Theocritus's Research Journal",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {386759},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203756] = {
            [itemKeys.name] = "Azora Apprentice Notes: Page 1",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203784] = {
            [itemKeys.name] = "Top-Right Map Piece",
            [itemKeys.npcDrops] = {6,40,80,257,327,475,476},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203785] = {
            [itemKeys.name] = "Top-Left Map Piece",
            [itemKeys.npcDrops] = {38,94,103,116,473,474,6866,6927},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203786] = {
            [itemKeys.name] = "Bottom-Right Map Piece",
            [itemKeys.npcDrops] = {46,285,732,735},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203787] = {
            [itemKeys.name] = "Bottom-Left Map Piece",
            [itemKeys.npcDrops] = {97,448,478},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203960] = {
            [itemKeys.name] = "Azora Apprentice Notes: Page 2",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203961] = {
            [itemKeys.name] = "Azora Apprentice Notes: Page 3",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203962] = {
            [itemKeys.name] = "Azora Apprentice Notes: Page 4",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203990] = {
            [itemKeys.name] = "Rune of Mutilation",
            [itemKeys.npcDrops] = {2038},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [203991] = {
            [itemKeys.name] = "Rune of Quick Draw",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {386675},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [203992] = {
            [itemKeys.name] = "Rune of Trickery",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203993] = {
            [itemKeys.name] = "Rune of Slaughter",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {387466,404941,407734},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [203994] = {
            [itemKeys.name] = "Rune of Deadly Brew",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [204174] = {
            [itemKeys.name] = "Rune of Precision",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {386777,404830,405201,405946,407352},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [204270] = {
            [itemKeys.name] = "Fathom Core",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204441] = {
            [itemKeys.name] = "Rune of Blood Frenzy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {392029},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [204476] = {
            [itemKeys.name] = "Severed Kobold Head",
            [itemKeys.npcDrops] = {40,327,475,476},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204477] = {
            [itemKeys.name] = "Severed Murloc Head",
            [itemKeys.npcDrops] = {46,285,732,735,1543,1544,1545},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204478] = {
            [itemKeys.name] = "Severed Gnoll Head",
            [itemKeys.npcDrops] = {97,448,478,1674,1675,1941,2949,2950,2951},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204688] = {
            [itemKeys.name] = "Monster Hunter's First Rune Fragment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204689] = {
            [itemKeys.name] = "Monster Hunter's Second Rune Fragment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204690] = {
            [itemKeys.name] = "Monster Hunter's Third Rune Fragment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204703] = {
            [itemKeys.name] = "Rune of Devastate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [204716] = {
            [itemKeys.name] = "Rune of Frenzied Assault",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [204795] = {
            [itemKeys.name] = "Rune of Shadowstrike",
            [itemKeys.npcDrops] = {1506},
            [itemKeys.objectDrops] = {387477,404911,405628,406006},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [204804] = {
            [itemKeys.name] = "Hydraxian Bangles",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204806] = {
            [itemKeys.name] = "Rune of Victory Rush",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {397987,403102,404911,406736},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [204807] = {
            [itemKeys.name] = "Fathomblade",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204809] = {
            [itemKeys.name] = "Rune of Furious Thunder",
            [itemKeys.npcDrops] = {79,100,327,448,471,1130,1137,1260,1271,1388,1961,3056,3058,3068,3131,3204,3205,3281,5785,5786,5807,5822,5823,5826,6113,207515,208196,208638},
            [itemKeys.objectDrops] = {407734},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [204864] = {
            [itemKeys.name] = "Azora Apprentice Notes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204905] = {
            [itemKeys.name] = "Ominous Tome",
            [itemKeys.npcDrops] = {474,476,881},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204906] = {
            [itemKeys.name] = "Gnoll Blood",
            [itemKeys.npcDrops] = {97,478,1674,1675,1941},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204907] = {
            [itemKeys.name] = "Wolf Jawbone",
            [itemKeys.npcDrops] = {69,118,299,525,704,705,1131,1133,1138,1922},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204910] = {
            [itemKeys.name] = "Monster - Trident, Naga (Gold)",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204912] = {
            [itemKeys.name] = "Rune of Grace",
            [itemKeys.npcDrops] = {204070},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [205019] = {
            [itemKeys.name] = "Tainted Soul Shard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205020] = {
            [itemKeys.name] = "Pure Soul Shard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205022] = {
            [itemKeys.name] = "Rune of Soul Siphon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [205181] = {
            [itemKeys.name] = "Unidentified Artifact",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {205364,208223},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205182] = {
            [itemKeys.name] = "Powerless Artifact",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205183] = {
            [itemKeys.name] = "Fel-Powered Artifact",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205184] = {
            [itemKeys.name] = "Acolyte's Note",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {205364},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205215] = {
            [itemKeys.name] = "Rune of Tactics",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [205218] = {
            [itemKeys.name] = "Libram of Discovery",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205228] = {
            [itemKeys.name] = "Rune of Chaos Bolt",
            [itemKeys.npcDrops] = {202060,208275,208752},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [205230] = {
            [itemKeys.name] = "Rune of Haunting",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {387477,404695,405633,406736},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [205364] = {
            [itemKeys.name] = "Acolyte's Knapsack",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205420] = {
            [itemKeys.name] = "Libram of Judgement",
            [itemKeys.npcDrops] = {38,706},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335},
            [itemKeys.startQuest] = nil,
        },
        [205683] = {
            [itemKeys.name] = "Rune of Rebuke",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335},
            [itemKeys.startQuest] = nil,
        },
        [205685] = {
            [itemKeys.name] = "Rune of Aegis",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335},
            [itemKeys.startQuest] = nil,
        },
        [205863] = {
            [itemKeys.name] = "Corrupted Libram",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205864] = {
            [itemKeys.name] = "Charred Note",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205897] = {
            [itemKeys.name] = "Rune of Divine Light",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335},
            [itemKeys.startQuest] = nil,
        },
        [205905] = {
            [itemKeys.name] = "Memory of a Devout Champion",
            [itemKeys.npcDrops] = {210537,212809},
            [itemKeys.objectDrops] = {414663},
            [itemKeys.itemDrops] = {208766},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [205932] = {
            [itemKeys.name] = "Prophecy of a King's Demise",
            [itemKeys.npcDrops] = {572,209742},
            [itemKeys.objectDrops] = {411674,414646},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [205940] = {
            [itemKeys.name] = "Memory of a Dark Purpose",
            [itemKeys.npcDrops] = {327,1211,3128,3129,208196},
            [itemKeys.objectDrops] = {407734},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [205942] = {
            [itemKeys.name] = "Chimaeric Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205943] = {
            [itemKeys.name] = "Prophecy of a Desecrated Citadel",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205944] = {
            [itemKeys.name] = "Reciprocal Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [205945] = {
            [itemKeys.name] = "Memory of an Imprisoned Savior",
            [itemKeys.npcDrops] = {40,43,60,471,476,1119,1260,1934,1935,2038,3204,3205,5808,5822,5826,6124,8503,13157},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [205946] = {
            [itemKeys.name] = "Memory of a Leader's Betrayal",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205947] = {
            [itemKeys.name] = "Prophecy of a Desecrated Citadel",
            [itemKeys.npcDrops] = {474,1124,1397,1535,1536,1537,2002,2003,2004,2005,3113,3118,3206,3207},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [205948] = {
            [itemKeys.name] = "Anodyne Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205949] = {
            [itemKeys.name] = "Manifold Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [205950] = {
            [itemKeys.name] = "Tenebrous Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [205951] = {
            [itemKeys.name] = "Memory of a Troubled Acolyte",
            [itemKeys.npcDrops] = {80},
            [itemKeys.objectDrops] = {405633},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [205952] = {
            [itemKeys.name] = "Memory of a Shattered World",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205953] = {
            [itemKeys.name] = "Prophecy of a Broken Vow",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205961] = {
            [itemKeys.name] = "Mulgore Bird Meat",
            [itemKeys.npcDrops] = {2956,2957,2969,2970,2971},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205979] = {
            [itemKeys.name] = "Rune of Flanking",
            [itemKeys.npcDrops] = {205382,208124,208812,209928},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [205995] = {
            [itemKeys.name] = "Prairie Dog Musk",
            [itemKeys.npcDrops] = {2949,2950,2951,207515},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206032] = {
            [itemKeys.name] = "Rune of Carve",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [206155] = {
            [itemKeys.name] = "Rune of Marksmanship",
            [itemKeys.npcDrops] = {205700,208180,209812},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [206157] = {
            [itemKeys.name] = "Seaforium Mining Charge",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206159] = {
            [itemKeys.name] = "Venture Co Disguise",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206168] = {
            [itemKeys.name] = "Rune of the Chimera",
            [itemKeys.npcDrops] = {1994,2954,3124},
            [itemKeys.objectDrops] = {405628},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [206169] = {
            [itemKeys.name] = "Rune of Explosive Shot",
            [itemKeys.npcDrops] = {1130,1132,1137,1271,1388,1961,3056,3058,3068,3281,5807,7318,208638},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [206170] = {
            [itemKeys.name] = "Windfury Cone",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206175] = {
            [itemKeys.name] = "Pine Salve",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206176] = {
            [itemKeys.name] = "Mortar and Pestle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206177] = {
            [itemKeys.name] = "Pine Nut Butter",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206264] = {
            [itemKeys.name] = "Rune of Inspiration",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335},
            [itemKeys.startQuest] = nil,
        },
        [206344] = {
            [itemKeys.name] = "Knife Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206345] = {
            [itemKeys.name] = "Fish Chunks",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206376] = {
            [itemKeys.name] = "Bulwark Icon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206381] = {
            [itemKeys.name] = "Dyadic Icon",
            [itemKeys.npcDrops] = {2953,3124},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [206382] = {
            [itemKeys.name] = "Tempest Icon",
            [itemKeys.npcDrops] = {1972},
            [itemKeys.objectDrops] = {3642,152608,152618},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [206383] = {
            [itemKeys.name] = "Lithic Icon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206384] = {
            [itemKeys.name] = "Astral Icon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206385] = {
            [itemKeys.name] = "Clastic Icon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206386] = {
            [itemKeys.name] = "Galvanic Icon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [206387] = {
            [itemKeys.name] = "Kajaric Icon",
            [itemKeys.npcDrops] = {2373},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [206388] = {
            [itemKeys.name] = "Sulfurous Icon",
            [itemKeys.npcDrops] = {208275},
            [itemKeys.objectDrops] = {404352},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [206389] = {
            [itemKeys.name] = "Brimstone Icon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206390] = {
            [itemKeys.name] = "Ichthyan Icon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206391] = {
            [itemKeys.name] = "Syzygic Icon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206466] = {
            [itemKeys.name] = "Prairie Crown",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206469] = {
            [itemKeys.name] = "Prairie Flower",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206954] = {
            [itemKeys.name] = "Idol of Ursine Rage",
            [itemKeys.npcDrops] = {2960,2964,2965,2971,2979,3232,3566,7318},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [206963] = {
            [itemKeys.name] = "Rune of Natural Potential",
            [itemKeys.npcDrops] = {206245},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [206966] = {
            [itemKeys.name] = "Satyrweed Bulb",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206970] = {
            [itemKeys.name] = "Rune of Life",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [206975] = {
            [itemKeys.name] = "Artifact Storage Key",
            [itemKeys.npcDrops] = {2989,2990},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206985] = {
            [itemKeys.name] = "Echo of the Alpha",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206989] = {
            [itemKeys.name] = "Rune of the Sun",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {404433},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [206992] = {
            [itemKeys.name] = "Rune of Skull Bash",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [206994] = {
            [itemKeys.name] = "Severed Quilboar Head",
            [itemKeys.npcDrops] = {3111,3112,3113,3114,3232,5826},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206995] = {
            [itemKeys.name] = "Severed Harpy Head",
            [itemKeys.npcDrops] = {2962,2963,2964,2965,3115,3116,3117,3118},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207062] = {
            [itemKeys.name] = "Severed Centaur Head",
            [itemKeys.npcDrops] = {3119,3120},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207098] = {
            [itemKeys.name] = "Note from Ba'so",
            [itemKeys.npcDrops] = {3183,3195,3196,3197,3198,3199,3203},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207106] = {
            [itemKeys.name] = "Bottom-Left Map Piece",
            [itemKeys.npcDrops] = {3206,3207},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207107] = {
            [itemKeys.name] = "Bottom-Right Map Piece",
            [itemKeys.npcDrops] = {3111,3112,3113,3114},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207108] = {
            [itemKeys.name] = "Top-Left Map Piece",
            [itemKeys.npcDrops] = {3195,3196,3197,3198,3199},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207109] = {
            [itemKeys.name] = "Top-Right Map Piece",
            [itemKeys.npcDrops] = {3128,3129},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207110] = {
            [itemKeys.name] = "Durotar Treasure Map",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207590] = {
            [itemKeys.name] = "Durotar Pig Meat",
            [itemKeys.npcDrops] = {3099,3100,3225},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207631] = {
            [itemKeys.name] = "Adder Pheromone",
            [itemKeys.npcDrops] = {3111,3112,3113,3114,5824,5826},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207731] = {
            [itemKeys.name] = "Ominous Tome",
            [itemKeys.npcDrops] = {3113,3118,3198,3206,3207},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207732] = {
            [itemKeys.name] = "Makrura Leg",
            [itemKeys.npcDrops] = {3103,3104,3105},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207733] = {
            [itemKeys.name] = "Kul Tiran Skull",
            [itemKeys.npcDrops] = {3128,3129},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207972] = {
            [itemKeys.name] = "The Lessons of Ta'zo",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207973] = {
            [itemKeys.name] = "Hound Jawbone",
            [itemKeys.npcDrops] = {1547,1548,1549},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207974] = {
            [itemKeys.name] = "Ominous Tome",
            [itemKeys.npcDrops] = {1522},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207975] = {
            [itemKeys.name] = "Severed Bat Head",
            [itemKeys.npcDrops] = {1553,1554},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208005] = {
            [itemKeys.name] = "Agamand Relic Coffer Key",
            [itemKeys.npcDrops] = {1501,1502,1520,1522,1523,1525,1526,1527,1528,1529,1530,1534,1656,1657,1674,1675,1753,1890,1916,1917,1918,1919,1941},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208007] = {
            [itemKeys.name] = "Shipwreck Cache Key",
            [itemKeys.npcDrops] = {1543,1544,1545},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208034] = {
            [itemKeys.name] = "Tirisfal Treasure Map",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208035] = {
            [itemKeys.name] = "Top-Right Map Piece",
            [itemKeys.npcDrops] = {1535,1536,1537,1538,1539,1540},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208036] = {
            [itemKeys.name] = "Top-Left Map Piece",
            [itemKeys.npcDrops] = {1934,1935},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208037] = {
            [itemKeys.name] = "Bottom-Right Map Piece",
            [itemKeys.npcDrops] = {1543,1544,1545},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208038] = {
            [itemKeys.name] = "Bottom-Left Map Piece",
            [itemKeys.npcDrops] = {1674,1675,1941},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208085] = {
            [itemKeys.name] = "Scarlet Lieutenant Signet Ring",
            [itemKeys.npcDrops] = {1662,1664},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208086] = {
            [itemKeys.name] = "Forged Scarlet Memorandum",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208139] = {
            [itemKeys.name] = "Ominous Tome",
            [itemKeys.npcDrops] = {1124,1397},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208140] = {
            [itemKeys.name] = "Wendigo Blood",
            [itemKeys.npcDrops] = {1134,1135},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208158] = {
            [itemKeys.name] = "Pristine Trogg Heart",
            [itemKeys.npcDrops] = {1115,1116,1117},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208159] = {
            [itemKeys.name] = "Severed Troll Head",
            [itemKeys.npcDrops] = {1120,1121,1122,1123,1124,1397},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208160] = {
            [itemKeys.name] = "Severed Wendigo Paw",
            [itemKeys.npcDrops] = {1134,1135},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208180] = {
            [itemKeys.name] = "Rabbit Musk",
            [itemKeys.npcDrops] = {1115,1116,1117,1118},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208183] = {
            [itemKeys.name] = "Apothecary Notes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208185] = {
            [itemKeys.name] = "The Apothecary's Metaphysical Primer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {405879},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208192] = {
            [itemKeys.name] = "Dun Morogh Pig Meat",
            [itemKeys.npcDrops] = {1125,1126,1127,1689,208638},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208205] = {
            [itemKeys.name] = "Blackrat's Note",
            [itemKeys.npcDrops] = {6123},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208213] = {
            [itemKeys.name] = "Top-Right Map Piece",
            [itemKeys.npcDrops] = {706,946,1120,1121,1122,1123,1124,1397},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208215] = {
            [itemKeys.name] = "Top-Left Map Piece",
            [itemKeys.npcDrops] = {707,724,1115,1116,1718},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208218] = {
            [itemKeys.name] = "Bottom-Right Map Piece",
            [itemKeys.npcDrops] = {1211},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208219] = {
            [itemKeys.name] = "Bottom-Left Map Piece",
            [itemKeys.npcDrops] = {6123},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208220] = {
            [itemKeys.name] = "Dun Morogh Treasure Map",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208222] = {
            [itemKeys.name] = "Old Guard Retaliator",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208223] = {
            [itemKeys.name] = "Acolyte's Knapsack",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208224] = {
            [itemKeys.name] = "Acolyte's Note",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {208223},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208414] = {
            [itemKeys.name] = "Lunar Idol",
            [itemKeys.npcDrops] = {1989},
            [itemKeys.objectDrops] = {403102},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [208424] = {
            [itemKeys.name] = "Sun Shades",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208484] = {
            [itemKeys.name] = "Sunlight",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208601] = {
            [itemKeys.name] = "Top-Right Map Piece",
            [itemKeys.npcDrops] = {2022,2025,2027,2029,2030},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208602] = {
            [itemKeys.name] = "Top-Left Map Piece",
            [itemKeys.npcDrops] = {2009,2010,2011,2012,2013,2014,2152},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208603] = {
            [itemKeys.name] = "Bottom-Right Map Piece",
            [itemKeys.npcDrops] = {2015,2017,2018,2019,2020,2021},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208604] = {
            [itemKeys.name] = "Bottom-Left Map Piece",
            [itemKeys.npcDrops] = {2002,2003,2004,2005},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208605] = {
            [itemKeys.name] = "Teldrassil Treasure Map",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208607] = {
            [itemKeys.name] = "Deer Musk",
            [itemKeys.npcDrops] = {2009,2010,2011,2012,2013,2014,2152},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208608] = {
            [itemKeys.name] = "Teldrassil Bird Meat",
            [itemKeys.npcDrops] = {1995,1996,1997},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208609] = {
            [itemKeys.name] = "Glade Flower",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208610] = {
            [itemKeys.name] = "Severed Owl Head",
            [itemKeys.npcDrops] = {1995,1996,1997},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208611] = {
            [itemKeys.name] = "Severed Tiger Head",
            [itemKeys.npcDrops] = {2033,2042,2043},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208612] = {
            [itemKeys.name] = "Severed Spider Head",
            [itemKeys.npcDrops] = {1998,1999,2001},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208682] = {
            [itemKeys.name] = "Abandoned Snapjaw Egg",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208687] = {
            [itemKeys.name] = "Rune of Lacerate",
            [itemKeys.npcDrops] = {210483},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [208689] = {
            [itemKeys.name] = "Ferocious Idol",
            [itemKeys.npcDrops] = {117,124,452,500,1065,1972,6788},
            [itemKeys.objectDrops] = {3642,152608,152618,408004},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [208701] = {
            [itemKeys.name] = "Rune of Beast Mastery",
            [itemKeys.npcDrops] = {209524,210533,211736},
            [itemKeys.objectDrops] = {407918},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [208739] = {
            [itemKeys.name] = "Horde Warbanner",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208741] = {
            [itemKeys.name] = "Rune of Endless Rage",
            [itemKeys.npcDrops] = {391,506,519,520,1424,2478,209607,210451,211146},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [208743] = {
            [itemKeys.name] = "Soul of Greed",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208744] = {
            [itemKeys.name] = "Rune of Shadowbolts",
            [itemKeys.npcDrops] = {2191,3662,10373,209958,210487,212753},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [208749] = {
            [itemKeys.name] = "Gnarlpine Stash Key",
            [itemKeys.npcDrops] = {2011,2012,2013,2014},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208750] = {
            [itemKeys.name] = "Rune of Channeling",
            [itemKeys.npcDrops] = {2336,2337,210501,212763},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [208753] = {
            [itemKeys.name] = "Spell Notes: Regeneration",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [208754] = {
            [itemKeys.name] = "Spell Notes: TENGI RONEERA",
            [itemKeys.npcDrops] = {589,1867},
            [itemKeys.objectDrops] = {3642,152608,152618,407983},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208758] = {
            [itemKeys.name] = "Earthen Rune",
            [itemKeys.npcDrops] = {209742,211875},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [208760] = {
            [itemKeys.name] = "Glade Crown",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208764] = {
            [itemKeys.name] = "Rune of the Mind",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208765] = {
            [itemKeys.name] = "Helping Hand",
            [itemKeys.npcDrops] = {3265,3266,3267,3268,3269,3271,3456,3457,3458,3459},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208766] = {
            [itemKeys.name] = "Helping Hand",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208767] = {
            [itemKeys.name] = "Rune of Mending",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208768] = {
            [itemKeys.name] = "Buccaneer's Matchbox",
            [itemKeys.npcDrops] = {3381,3382,3383,3384},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208771] = {
            [itemKeys.name] = "Rune of Blade Dance",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {414532},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [208772] = {
            [itemKeys.name] = "Rune of Saber Slash",
            [itemKeys.npcDrops] = {210549},
            [itemKeys.objectDrops] = {407731,409131,414624},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [208773] = {
            [itemKeys.name] = "Fishing Harpoon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {3497},
            [itemKeys.startQuest] = nil,
        },
        [208777] = {
            [itemKeys.name] = "Rune of the Sniper",
            [itemKeys.npcDrops] = {209797,210107,210482,210549},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [208778] = {
            [itemKeys.name] = "Rune of Quick Strike",
            [itemKeys.npcDrops] = {209797,210482,210487},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {208848},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [208799] = {
            [itemKeys.name] = "Spell Notes: Living Bomb",
            [itemKeys.npcDrops] = {210501},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [208800] = {
            [itemKeys.name] = "Baxtan: On Destructive Magics",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {407566},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208823] = {
            [itemKeys.name] = "Offering Coin",
            [itemKeys.npcDrops] = {1174,1175,1177},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208828] = {
            [itemKeys.name] = "Memory of a Broken Vow",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208833] = {
            [itemKeys.name] = "Malevolent Pie",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {3291},
            [itemKeys.startQuest] = nil,
        },
        [208838] = {
            [itemKeys.name] = "Dark Iron Lockbox",
            [itemKeys.npcDrops] = {1169,1222},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208843] = {
            [itemKeys.name] = "Battle Totem",
            [itemKeys.npcDrops] = {1178,1179,1180,1181,1183},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208847] = {
            [itemKeys.name] = "Skull-Shaped Geode",
            [itemKeys.npcDrops] = {1161,1162,1163,1164,1165,1166,1167,1197},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208848] = {
            [itemKeys.name] = "Cracked Skull-Shaped Geode",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208849] = {
            [itemKeys.name] = "Libram of Blessings",
            [itemKeys.npcDrops] = {210537},
            [itemKeys.objectDrops] = {407844},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335},
            [itemKeys.startQuest] = nil,
        },
        [208851] = {
            [itemKeys.name] = "Libram of Justice",
            [itemKeys.npcDrops] = {572,846,7050},
            [itemKeys.objectDrops] = {407850},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335},
            [itemKeys.startQuest] = nil,
        },
        [208853] = {
            [itemKeys.name] = "Spell Notes: Brain Freeze",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {212553},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [208854] = {
            [itemKeys.name] = "Chewed Spell Notes",
            [itemKeys.npcDrops] = {1166},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208855] = {
            [itemKeys.name] = "Rainbow Fin Albacore Chum",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1684},
            [itemKeys.startQuest] = nil,
        },
        [208860] = {
            [itemKeys.name] = "Rumi of Gnomeregan: The Collected Works",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {408014},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209027] = {
            [itemKeys.name] = "Crab Treats",
            [itemKeys.npcDrops] = {2167,2168,2169,2170,2171,2324},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209028] = {
            [itemKeys.name] = "Spell Notes: BIVOLG NIMB",
            [itemKeys.npcDrops] = {210451},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209029] = {
            [itemKeys.name] = "Message from Emily",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {209031},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209030] = {
            [itemKeys.name] = "Equipment Stash Key",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {209031},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209031] = {
            [itemKeys.name] = "Discreet Envelope",
            [itemKeys.npcDrops] = {95,121,122,449,481,504,589,590},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209041] = {
            [itemKeys.name] = "Magic Pumpkin Seeds",
            [itemKeys.npcDrops] = {95,121,122,449,481,504,589,590},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209042] = {
            [itemKeys.name] = "Fishy Bonemeal",
            [itemKeys.npcDrops] = {830,831,1216},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209043] = {
            [itemKeys.name] = "Fertile Soil Sample",
            [itemKeys.npcDrops] = {1236},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209045] = {
            [itemKeys.name] = "Soul of the Sea",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209047] = {
            [itemKeys.name] = "Gnarled Harpoon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {408802},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209056] = {
            [itemKeys.name] = "Spare Reaper Parts",
            [itemKeys.npcDrops] = {36,114,115,480,573},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209057] = {
            [itemKeys.name] = "Prototype Engine",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209058] = {
            [itemKeys.name] = "Elemental Core",
            [itemKeys.npcDrops] = {832},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209059] = {
            [itemKeys.name] = "Goretusk Haunch",
            [itemKeys.npcDrops] = {157,454},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209418] = {
            [itemKeys.name] = "Adamantine Tortoise Armor",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209420] = {
            [itemKeys.name] = "Gillsbane",
            [itemKeys.npcDrops] = {95,121,122,449,481,504,589,590},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209421] = {
            [itemKeys.name] = "Cord of Aquanis",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209422] = {
            [itemKeys.name] = "High Tide Choker",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209423] = {
            [itemKeys.name] = "Flowing Scarf",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209424] = {
            [itemKeys.name] = "Shell Plate Barrier",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209432] = {
            [itemKeys.name] = "Ghamoo-ra's Cinch",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209436] = {
            [itemKeys.name] = "Chipped Bite of Serra'kis",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209523] = {
            [itemKeys.name] = "Shimmering Thresher Cape",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209524] = {
            [itemKeys.name] = "Bindings of Serra'kis",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209525] = {
            [itemKeys.name] = "Honed Darkwater Talwar",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209526] = {
            [itemKeys.name] = "TEST Darkwater Talwar",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209527] = {
            [itemKeys.name] = "Naga Battle Gauntlets",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209534] = {
            [itemKeys.name] = "Azshari Arbalest",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209559] = {
            [itemKeys.name] = "Twilight Sage's Walking Stick",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209560] = {
            [itemKeys.name] = "Hammer of Righteous Judgement",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209561] = {
            [itemKeys.name] = "Rod of the Ancient Sleepwalker",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209562] = {
            [itemKeys.name] = "Deadly Strike of the Hydra",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209563] = {
            [itemKeys.name] = "Naga Heartrender",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209564] = {
            [itemKeys.name] = "Guardian's Trident",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209565] = {
            [itemKeys.name] = "Band of Deep Places",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209566] = {
            [itemKeys.name] = "Leggings of the Faithful",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209567] = {
            [itemKeys.name] = "Coral Reef Axe",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209568] = {
            [itemKeys.name] = "Algae Gauntlets",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209569] = {
            [itemKeys.name] = "Murloc Hide Kneeboots",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209570] = {
            [itemKeys.name] = "Tome of Cavern Lore",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209571] = {
            [itemKeys.name] = "Deadlight",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209572] = {
            [itemKeys.name] = "Black Boiled Leathers",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209573] = {
            [itemKeys.name] = "Wrathful Spire",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209574] = {
            [itemKeys.name] = "Discarded Tenets of the Silver Hand",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209575] = {
            [itemKeys.name] = "Carved Driftwood Icon",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209576] = {
            [itemKeys.name] = "Mind-Expanding Mushroom",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209577] = {
            [itemKeys.name] = "Fist of the Wild",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209578] = {
            [itemKeys.name] = "Glowing Leather Bands",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209579] = {
            [itemKeys.name] = "Crashing Thunder",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209580] = {
            [itemKeys.name] = "Gusting Wind",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209581] = {
            [itemKeys.name] = "Silver Hand Sabatons",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209590] = {
            [itemKeys.name] = "Cracked Water Globe",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209608] = {
            [itemKeys.name] = "Captain's Skeleton Key",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209667] = {
            [itemKeys.name] = "Gaze Dreamer Leggings",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209668] = {
            [itemKeys.name] = "Signet of the Twilight Lord",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209669] = {
            [itemKeys.name] = "Twilight Invoker's Shoes",
            [itemKeys.npcDrops] = {204921,207356,209678,213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209670] = {
            [itemKeys.name] = "Skinwalkers",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209671] = {
            [itemKeys.name] = "Twilight Invoker's Robes",
            [itemKeys.npcDrops] = {204921,207356,209678,213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209672] = {
            [itemKeys.name] = "Black Fingerless Gloves",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209673] = {
            [itemKeys.name] = "Glowing Fetish Amulet",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209674] = {
            [itemKeys.name] = "Phoenix Ignition",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209675] = {
            [itemKeys.name] = "Clamweave Tunic",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209676] = {
            [itemKeys.name] = "Shoulderguards of Crushing Depths",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209677] = {
            [itemKeys.name] = "Loop of Swift Currents",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209678] = {
            [itemKeys.name] = "Mantle of the Thresher Slayer",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209679] = {
            [itemKeys.name] = "Azshari Novice's Shoulderpads",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209680] = {
            [itemKeys.name] = "Waterproof Scarf",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209681] = {
            [itemKeys.name] = "Black Murloc Egg",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209682] = {
            [itemKeys.name] = "Sturdy Hood",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209683] = {
            [itemKeys.name] = "Twilight Invoker's Shawl",
            [itemKeys.npcDrops] = {204921,207356,209678,213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209684] = {
            [itemKeys.name] = "Soul Leech Pants",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209685] = {
            [itemKeys.name] = "Ancient Moss Cinch",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209686] = {
            [itemKeys.name] = "Jagged Bone Necklace",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209687] = {
            [itemKeys.name] = "Hydra Hide Cuirass",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209688] = {
            [itemKeys.name] = "Bael Modan Blunderbuss",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209689] = {
            [itemKeys.name] = "Crabshell Waders",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209690] = {
            [itemKeys.name] = "Shadowscale Coif",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209691] = {
            [itemKeys.name] = "Vampiric Boot Knife",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209692] = {
            [itemKeys.name] = "Sentinel Pauldrons",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209693] = {
            [itemKeys.name] = "Perfect Blackfathom Pearl",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 78916,
        },
        [209694] = {
            [itemKeys.name] = "Blackfathom Ritual Dagger",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209748] = {
            [itemKeys.name] = "Althalaxx Orb",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209778] = {
            [itemKeys.name] = "Summoner's Salt",
            [itemKeys.npcDrops] = {334,435,436,615,4065,4462,4463,4464},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209779] = {
            [itemKeys.name] = "Mote of Mannoroth",
            [itemKeys.npcDrops] = {6071,6073,6115,11697},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209800] = {
            [itemKeys.name] = "Orb Fragments",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209816] = {
            [itemKeys.name] = "Fetish of Mischief",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209817] = {
            [itemKeys.name] = "Voidwalker Brooch",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209818] = {
            [itemKeys.name] = "Sun-Touched Crescent",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209819] = {
            [itemKeys.name] = "Wyvern Taming Wand",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209820] = {
            [itemKeys.name] = "Black Shroud Choker",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209821] = {
            [itemKeys.name] = "Ring of Shadowsight",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209822] = {
            [itemKeys.name] = "Strength of Purpose",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209823] = {
            [itemKeys.name] = "Signet of Beasts",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209824] = {
            [itemKeys.name] = "Shimmering Shoulderpads",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209825] = {
            [itemKeys.name] = "Droplet Choker",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209828] = {
            [itemKeys.name] = "Sub-Zero Pauldrons",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209830] = {
            [itemKeys.name] = "Ironhide Arbalest",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209836] = {
            [itemKeys.name] = "Althalaxx Orb",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409289},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209838] = {
            [itemKeys.name] = "Hypnotic Crystal",
            [itemKeys.npcDrops] = {3654},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209840] = {
            [itemKeys.name] = "Gnarled Wand of Wild Magic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209841] = {
            [itemKeys.name] = "Wild Magic Essence",
            [itemKeys.npcDrops] = {3748,3750,3922,3924},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209843] = {
            [itemKeys.name] = "Nar'thalas Almanac, Vol. 74",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409496},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209844] = {
            [itemKeys.name] = "The Dalaran Digest, Vol. 23",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409501},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209845] = {
            [itemKeys.name] = "Bewitchments and Glamours",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409562},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209846] = {
            [itemKeys.name] = "Secrets of the Dreamers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209847] = {
            [itemKeys.name] = "Arcanic Systems Manual",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409700},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209848] = {
            [itemKeys.name] = "Goaz Scrolls",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409717},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209849] = {
            [itemKeys.name] = "Crimes Against Anatomy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409735},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209850] = {
            [itemKeys.name] = "Runes of the Sorcerer-Kings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409731},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209851] = {
            [itemKeys.name] = "Fury of the Land",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409711},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209852] = {
            [itemKeys.name] = "Rune of Kill Command",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [209872] = {
            [itemKeys.name] = "Dragonslayer's Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409758},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209873] = {
            [itemKeys.name] = "Dragonslayer's Shield",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409754},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209874] = {
            [itemKeys.name] = "Dragonslayer's Lance",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {3180},
            [itemKeys.startQuest] = nil,
        },
        [210015] = {
            [itemKeys.name] = "Rune of Raging Blow",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210026] = {
            [itemKeys.name] = "Symbol of the Third Owl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210043] = {
            [itemKeys.name] = "Symbol of the Second Owl",
            [itemKeys.npcDrops] = {211200},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210044] = {
            [itemKeys.name] = "Symbol of the First Owl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210045] = {
            [itemKeys.name] = "Shadeleaf",
            [itemKeys.npcDrops] = {3780,3781,3782,3783,3784},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210053] = {
            [itemKeys.name] = "Dire Wolf Paw",
            [itemKeys.npcDrops] = {213,565,628,923},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210055] = {
            [itemKeys.name] = "Hillsbrad Human Bones",
            [itemKeys.npcDrops] = {2265,2266,2267,2268,2360,2387},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210056] = {
            [itemKeys.name] = "Tincture of Waking Death",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210080] = {
            [itemKeys.name] = "Voodoo Offering",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210137] = {
            [itemKeys.name] = "Rune of Wild Growth",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210138] = {
            [itemKeys.name] = "Dark Iron Ordinance",
            [itemKeys.npcDrops] = {1051,1052,1053,1054},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210146] = {
            [itemKeys.name] = "Shredder Turbocharger",
            [itemKeys.npcDrops] = {642,4073,4074,4260,11684,214129},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210147] = {
            [itemKeys.name] = "Shredder Autosalvage Unit",
            [itemKeys.npcDrops] = {3988,3992,4070},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210177] = {
            [itemKeys.name] = "Ataeric: On Arcane Curiosities",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {410299},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210178] = {
            [itemKeys.name] = "Schematic: Shredder Autosalvage Unit",
            [itemKeys.npcDrops] = {643},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210179] = {
            [itemKeys.name] = "Spell Notes: ILMEGAI SARRBES",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210183] = {
            [itemKeys.name] = "Horn of Xelthos",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {410528},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210186] = {
            [itemKeys.name] = "Breaching Charge",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210187] = {
            [itemKeys.name] = "Venture Co. Work Order",
            [itemKeys.npcDrops] = {3988,3992,3993,4070,4202},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210188] = {
            [itemKeys.name] = "Shredded Work Order",
            [itemKeys.npcDrops] = {3988,3992,3993,4070,4202},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210195] = {
            [itemKeys.name] = "Unbalanced Idol",
            [itemKeys.npcDrops] = {1769,1770,1782,1924},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210209] = {
            [itemKeys.name] = "Twin Key",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210210] = {
            [itemKeys.name] = "Grizzwerks Defense Industries Founder's Certificate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210212] = {
            [itemKeys.name] = "Brother's Half-Key",
            [itemKeys.npcDrops] = {211764},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210213] = {
            [itemKeys.name] = "Sister's Half-Key",
            [itemKeys.npcDrops] = {211765},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210229] = {
            [itemKeys.name] = "Rune of Mutilation",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210250] = {
            [itemKeys.name] = "Engraved Gold Ring",
            [itemKeys.npcDrops] = {215,909,910},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210251] = {
            [itemKeys.name] = "Engraved Silver Ring",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {410779},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210252] = {
            [itemKeys.name] = "Rune of Shiving",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210253] = {
            [itemKeys.name] = "Rot Totem",
            [itemKeys.npcDrops] = {1773,1940},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210322] = {
            [itemKeys.name] = "Rune of Venom",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {410847},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210323] = {
            [itemKeys.name] = "Safe Combination",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {210330},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210329] = {
            [itemKeys.name] = "Hillsbrad Treasure Map",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {210330},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210330] = {
            [itemKeys.name] = "Hot Tip",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {3536},
            [itemKeys.startQuest] = nil,
        },
        [210410] = {
            [itemKeys.name] = "Freshwater Snapper Bait",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {3537},
            [itemKeys.startQuest] = nil,
        },
        [210499] = {
            [itemKeys.name] = "Marshroom",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210500] = {
            [itemKeys.name] = "Rune of the Stars",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210534] = {
            [itemKeys.name] = "Idol of the Wild",
            [itemKeys.npcDrops] = {11910,11911,11912,11913},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210568] = {
            [itemKeys.name] = "Decrepit Phylactery",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {411348},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210569] = {
            [itemKeys.name] = "Rune of Flagellation",
            [itemKeys.npcDrops] = {212261},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210573] = {
            [itemKeys.name] = "Rune of Consuming Rage",
            [itemKeys.npcDrops] = {211965},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210589] = {
            [itemKeys.name] = "Echo of the Ancestors",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [210596] = {
            [itemKeys.name] = "Rune of Cobra Strikes",
            [itemKeys.npcDrops] = {211951},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210653] = {
            [itemKeys.name] = "Rune of Main Gauche",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {211653,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210654] = {
            [itemKeys.name] = "Spell Notes: Rewind Time",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {211653,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210655] = {
            [itemKeys.name] = "Spell Notes: TERWEM DINI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210665] = {
            [itemKeys.name] = "Mote of Torrential Rage",
            [itemKeys.npcDrops] = {3917},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210667] = {
            [itemKeys.name] = "Mote of Infernal Rage",
            [itemKeys.npcDrops] = {4036,4037,4038},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210668] = {
            [itemKeys.name] = "Mote of Seismic Rage",
            [itemKeys.npcDrops] = {4034,4035},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210696] = {
            [itemKeys.name] = "Rot Bane",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210708] = {
            [itemKeys.name] = "Elixir of Coalesced Regret",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210709] = {
            [itemKeys.name] = "Recipe: Elixir of Coalesced Regret",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {3134,3537},
            [itemKeys.startQuest] = nil,
        },
        [210712] = {
            [itemKeys.name] = "Elixir of Insight",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210713] = {
            [itemKeys.name] = "Tortured Soul",
            [itemKeys.npcDrops] = {1973,1974},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210724] = {
            [itemKeys.name] = "Hirzek's Staff",
            [itemKeys.npcDrops] = {212694},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210741] = {
            [itemKeys.name] = "Automatic Crowd Pummeler",
            [itemKeys.npcDrops] = {215728},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210746] = {
            [itemKeys.name] = "Rune of Earth Shield",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [210763] = {
            [itemKeys.name] = "Bough of Altek",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {411715},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210765] = {
            [itemKeys.name] = "Orb of Des",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {411710},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210771] = {
            [itemKeys.name] = "Waylaid Supplies: Copper Bars",
            [itemKeys.npcDrops] = {36,46,60,95,327,456,471,473,480,481,502,504,515,550,589,590,712,732,735,822,830,880,881,1115,1116,1118,1120,1122,1126,1135,1162,1163,1164,1166,1174,1176,1190,1196,1236,1397,1426,1523,1527,1529,1532,1534,1535,1538,1539,1543,1544,1549,1555,1655,1656,1662,1674,1767,1768,1772,1773,1778,1779,1782,1866,1867,1868,1869,1912,1934,2000,2001,2005,2014,2021,2025,2030,2034,2039,2063,2069,2162,2167,2176,2189,2191,2204,2212,2232,2321,2324,2963,2965,2970,2979,2989,2990,3056,3099,3103,3104,3107,3111,3112,3114,3115,3118,3119,3120,3123,3126,3130,3192,3195,3196,3197,3198,3199,3206,3207,3225,3227,3231,3234,3243,3246,3255,3265,3267,3268,3269,3274,3276,3282,3285,3380,3381,3384,3397,3438,3535,5807,6123,6466,6789,6866,7235,7318,10160,10358,11911,12138,14431},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210772] = {
            [itemKeys.name] = "Supply Shipment: Copper Bars",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210773] = {
            [itemKeys.name] = "Mantle of the Second War",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210779] = {
            [itemKeys.name] = "Plans: Mantle of the Second War",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [210781] = {
            [itemKeys.name] = "Phoenix Bindings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210794] = {
            [itemKeys.name] = "Shifting Silver Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210795] = {
            [itemKeys.name] = "Extraplanar Spidersilk Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210811] = {
            [itemKeys.name] = "Rune of Primordial Fury",
            [itemKeys.npcDrops] = {212837},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [210817] = {
            [itemKeys.name] = "Rune of Survival",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {211653,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210818] = {
            [itemKeys.name] = "Rune of Lone Wolf",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {211653,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210820] = {
            [itemKeys.name] = "Rune of Sacrifice",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {211653,233335},
            [itemKeys.startQuest] = nil,
        },
        [210822] = {
            [itemKeys.name] = "Harmonious Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {211653,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210823] = {
            [itemKeys.name] = "Rune of Dual Wield Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {211653,233428},
            [itemKeys.startQuest] = nil,
        },
        [210824] = {
            [itemKeys.name] = "Rune of the Pact",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {211653,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210825] = {
            [itemKeys.name] = "Rune of the Warbringer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {211653,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210953] = {
            [itemKeys.name] = "Eye of Bhossca",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {412261},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210955] = {
            [itemKeys.name] = "Scarlet Initiate's Uniform",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {412147},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210963] = {
            [itemKeys.name] = "Scryer's Key",
            [itemKeys.npcDrops] = {4293},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210966] = {
            [itemKeys.name] = "Blood of the Legion",
            [itemKeys.npcDrops] = {6071,6073,6115,11697},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210967] = {
            [itemKeys.name] = "Confidential Message",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {412759},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210968] = {
            [itemKeys.name] = "Reliquary Key",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {412198},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210979] = {
            [itemKeys.name] = "Rune of Shadowstep",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [210980] = {
            [itemKeys.name] = "Rune of Metamorphosis",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [211205] = {
            [itemKeys.name] = "Rune of Cobra Slayer",
            [itemKeys.npcDrops] = {211965},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [211247] = {
            [itemKeys.name] = "Pattern: Phoenix Bindings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [211263] = {
            [itemKeys.name] = "Judgement Chestguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211269] = {
            [itemKeys.name] = "Primitive Drawing",
            [itemKeys.npcDrops] = {2701,2715,2716,2717,2718,2720,2892,2893,2894,2906,2907},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 78823,
        },
        [211272] = {
            [itemKeys.name] = "Empty Bait Cage",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211273] = {
            [itemKeys.name] = "Trapped Critter",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211293] = {
            [itemKeys.name] = "Crimson Trophy Quill",
            [itemKeys.npcDrops] = {213795},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211301] = {
            [itemKeys.name] = "Rune of Expose Weakness",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211315] = {
            [itemKeys.name] = "Waylaid Supplies: Light Leather",
            [itemKeys.npcDrops] = {46,61,95,114,116,117,119,285,471,474,480,481,501,502,515,524,550,712,830,880,1109,1121,1122,1161,1163,1172,1173,1175,1176,1177,1184,1186,1211,1426,1523,1529,1532,1533,1534,1535,1536,1537,1538,1539,1540,1543,1545,1548,1554,1664,1675,1765,1766,1768,1769,1770,1773,1779,1782,1797,1865,1866,1867,1869,1971,1981,2004,2008,2009,2010,2011,2012,2014,2015,2018,2019,2027,2029,2030,2033,2038,2039,2062,2065,2069,2070,2176,2179,2190,2201,2202,2204,2212,2321,2324,2951,2957,2962,2964,2976,2977,2978,2989,2990,3035,3051,3056,3068,3099,3104,3107,3111,3113,3114,3115,3116,3119,3120,3121,3129,3131,3196,3197,3198,3204,3205,3206,3231,3242,3243,3266,3267,3268,3269,3272,3273,3274,3282,3284,3285,3379,3380,3382,3383,3384,3385,3566,5865,6123,6466,6866,7235,7318,10157,10356,10358,11910,11911,14431,207515,208196},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211316] = {
            [itemKeys.name] = "Waylaid Supplies: Peacebloom",
            [itemKeys.npcDrops] = {40,79,95,97,99,100,117,123,126,199,471,472,474,476,500,501,515,524,589,590,712,732,735,834,880,1065,1109,1117,1121,1123,1124,1131,1132,1161,1166,1174,1175,1176,1177,1188,1236,1522,1523,1528,1531,1532,1534,1536,1537,1540,1544,1545,1655,1656,1657,1660,1662,1664,1674,1675,1689,1753,1770,1772,1779,1780,1782,1797,1865,1868,1870,1912,1922,1993,1996,2004,2010,2011,2013,2014,2018,2025,2029,2030,2033,2061,2066,2152,2162,2163,2167,2179,2189,2201,2212,2234,2322,2324,2951,2959,2962,2963,2971,2976,2989,2990,3035,3056,3068,3103,3104,3107,3111,3114,3115,3117,3118,3120,3127,3129,3195,3196,3199,3206,3231,3232,3242,3246,3248,3265,3266,3267,3268,3269,3272,3273,3274,3275,3282,3284,3285,3379,3380,3381,3383,3384,4316,6466,6846,6866,6927,7235,7318,10160,11910,11911,11913,12432,13157,14432,209742},
            [itemKeys.objectDrops] = {17189,106318,106319,404352},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211317] = {
            [itemKeys.name] = "Waylaid Supplies: Silverleaf",
            [itemKeys.npcDrops] = {46,116,117,118,285,327,330,390,456,473,476,480,481,500,501,502,513,515,524,589,732,822,881,1065,1116,1117,1118,1122,1123,1131,1132,1135,1162,1166,1174,1175,1176,1195,1196,1260,1520,1522,1523,1526,1527,1529,1530,1535,1536,1537,1540,1543,1544,1549,1555,1654,1693,1753,1766,1767,1768,1769,1770,1773,1779,1868,1910,1936,1941,1993,2001,2005,2009,2010,2011,2012,2013,2014,2018,2027,2029,2030,2033,2034,2062,2152,2176,2177,2189,2191,2201,2202,2212,2324,2950,2951,2960,2962,2963,2964,2971,2974,2977,2979,2989,2990,3035,3056,3068,3107,3111,3112,3114,3116,3119,3120,3127,3129,3192,3195,3197,3199,3206,3234,3243,3254,3265,3271,3273,3282,3284,3380,3383,3425,3438,6093,6466,6494,6866,6927,7234,7235,7318,8503,10157,10158,11911,11912,11913,12138,12320,12432,14430,202060,209742,210537,210549},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211318] = {
            [itemKeys.name] = "Waylaid Supplies: Minor Healing Potions",
            [itemKeys.npcDrops] = {36,61,95,97,99,117,121,124,126,285,327,390,423,456,471,473,474,500,501,504,524,589,590,732,735,824,833,881,1065,1116,1117,1120,1121,1131,1137,1161,1162,1163,1164,1166,1172,1174,1184,1188,1190,1201,1202,1236,1380,1426,1522,1526,1528,1530,1535,1537,1539,1543,1544,1545,1549,1555,1658,1662,1664,1689,1753,1765,1769,1770,1773,1779,1866,1870,1912,1934,2004,2008,2010,2011,2018,2019,2020,2027,2029,2030,2038,2043,2065,2152,2163,2167,2179,2212,2324,2950,2956,2965,2968,2970,2976,2978,2979,2990,3056,3103,3112,3113,3114,3115,3116,3119,3122,3129,3195,3196,3197,3198,3204,3205,3206,3207,3267,3268,3269,3271,3272,3276,3277,3285,3379,3384,3397,3415,3438,3566,4316,5786,5787,6927,7234,7319,9523,10157,10158,10159,10356,11910,11911,12320,12431,12432,12433,14431,202060,208875,210549},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211319] = {
            [itemKeys.name] = "Waylaid Supplies: Copper Shortswords",
            [itemKeys.npcDrops] = {40,43,97,99,116,118,124,126,171,285,327,330,456,474,476,478,481,501,502,515,583,590,822,824,880,1065,1116,1117,1123,1127,1133,1138,1161,1163,1166,1172,1175,1194,1195,1196,1197,1202,1236,1380,1426,1522,1523,1526,1527,1528,1530,1531,1533,1534,1535,1537,1540,1544,1545,1548,1554,1654,1655,1656,1662,1665,1674,1675,1689,1766,1767,1768,1769,1773,1781,1782,1797,1865,1869,1912,1924,1934,1993,1999,2004,2005,2009,2010,2011,2012,2014,2019,2020,2021,2030,2152,2173,2178,2189,2191,2202,2203,2204,2231,2234,2324,2950,2964,2977,2979,3068,3103,3107,3110,3111,3112,3113,3115,3120,3129,3195,3196,3198,3199,3206,3226,3227,3231,3232,3234,3244,3246,3265,3266,3268,3269,3271,3272,3275,3285,3379,3380,3382,3383,3397,3415,4316,5865,6466,6494,6789,6846,6909,7234,7319,10158,11913,12432,14428,208638},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211320] = {
            [itemKeys.name] = "Waylaid Supplies: Runed Copper Pants",
            [itemKeys.npcDrops] = {36,61,97,114,118,124,126,157,199,285,327,330,473,474,476,478,481,501,513,515,524,550,590,732,735,822,834,1109,1115,1116,1121,1133,1135,1163,1173,1175,1176,1186,1191,1193,1195,1196,1202,1211,1236,1425,1520,1526,1528,1530,1531,1534,1536,1538,1544,1553,1662,1664,1665,1675,1689,1766,1769,1772,1779,1797,1865,1866,1867,1870,1912,1914,1924,1941,1972,1983,2008,2011,2012,2013,2019,2025,2027,2029,2030,2039,2060,2061,2152,2164,2177,2201,2205,2212,2950,2951,2959,2964,2968,2970,2973,2976,2977,2978,3056,3058,3104,3112,3113,3116,3127,3129,3197,3198,3199,3203,3205,3206,3207,3225,3232,3242,3246,3255,3265,3267,3269,3271,3273,3275,3276,3282,3284,3380,3383,3384,3461,5809,6093,6123,6866,7234,7235,9523,10158,10160,10357,11910,11911,202060,208196,208638,209742,210537},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211321] = {
            [itemKeys.name] = "Waylaid Supplies: Lesser Magic Wands",
            [itemKeys.npcDrops] = {36,43,46,79,95,97,116,117,118,285,330,390,454,456,471,474,478,480,481,502,504,513,524,712,735,824,830,833,846,1065,1117,1120,1121,1123,1126,1135,1138,1163,1172,1174,1175,1177,1196,1197,1202,1211,1236,1520,1522,1526,1527,1530,1531,1533,1535,1536,1537,1540,1543,1553,1554,1654,1662,1664,1665,1674,1675,1753,1769,1770,1772,1773,1778,1779,1780,1797,1867,1868,1869,1870,1912,1941,1993,1996,1997,2004,2005,2008,2010,2011,2012,2013,2014,2019,2021,2025,2029,2030,2033,2034,2043,2067,2070,2152,2164,2177,2178,2231,2322,2324,2950,2951,2962,2965,2967,2972,2974,2976,2978,3099,3105,3107,3110,3112,3113,3114,3115,3116,3117,3118,3119,3129,3131,3196,3198,3199,3203,3206,3207,3227,3234,3254,3265,3267,3268,3269,3271,3273,3276,3285,3379,3384,3438,3535,3566,4127,4263,4316,6093,6124,6866,7319,10157,10160,11911,12138,12321,14268},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211322] = {
            [itemKeys.name] = "Waylaid Supplies: Minor Wizard Oil",
            [itemKeys.npcDrops] = {36,40,43,46,97,114,116,119,121,124,126,157,285,330,390,423,454,456,476,478,480,504,513,515,524,550,589,590,712,732,735,822,833,834,1115,1117,1121,1123,1124,1135,1138,1161,1162,1163,1166,1172,1174,1175,1177,1188,1190,1197,1201,1202,1211,1236,1380,1426,1522,1523,1526,1527,1529,1530,1531,1532,1533,1534,1535,1536,1537,1538,1540,1544,1548,1553,1554,1662,1674,1693,1753,1765,1766,1767,1768,1769,1770,1772,1779,1781,1782,1866,1868,1912,1941,1953,1997,2001,2004,2005,2008,2010,2011,2012,2015,2018,2019,2020,2025,2027,2033,2039,2070,2152,2164,2167,2177,2178,2185,2189,2190,2203,2204,2212,2234,2324,2950,2951,2956,2957,2960,2962,2964,2965,2976,2978,3035,3058,3099,3103,3107,3110,3111,3113,3114,3115,3116,3117,3118,3119,3120,3122,3126,3127,3129,3192,3196,3197,3198,3203,3204,3205,3207,3226,3232,3234,3244,3246,3265,3267,3268,3269,3271,3272,3273,3274,3275,3276,3277,3282,3284,3379,3380,3381,3382,3397,4316,6123,6789,7235,7318,10159,11911},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211323] = {
            [itemKeys.name] = "Waylaid Supplies: Rough Copper Bombs",
            [itemKeys.npcDrops] = {36,40,43,46,95,114,117,118,123,126,285,471,473,480,513,515,712,732,735,822,880,1116,1117,1120,1121,1124,1132,1135,1162,1175,1176,1184,1188,1190,1202,1211,1236,1426,1526,1530,1531,1532,1533,1534,1535,1536,1537,1538,1540,1543,1544,1549,1553,1656,1658,1662,1675,1689,1693,1767,1769,1770,1772,1773,1779,1782,1867,1912,1922,1924,1934,1941,1971,1996,2005,2011,2012,2013,2014,2015,2019,2020,2025,2027,2038,2039,2043,2066,2069,2167,2178,2179,2189,2190,2203,2231,2234,2322,2324,2950,2951,2956,2963,2965,2970,2976,2978,2979,2989,2990,3099,3111,3112,3115,3116,3123,3129,3131,3192,3195,3198,3199,3206,3207,3232,3234,3248,3254,3265,3266,3267,3271,3272,3273,3276,3277,3284,3285,3381,3382,3383,3397,3438,4316,5826,6123,6466,6494,6497,6846,7235,7318,10157,10159,10358,11911,12138,12320,14428,208124,210537},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211324] = {
            [itemKeys.name] = "Waylaid Supplies: Rough Boomsticks",
            [itemKeys.npcDrops] = {43,97,114,117,123,157,199,285,327,442,456,473,478,500,501,513,732,735,822,824,830,1115,1116,1118,1122,1123,1124,1126,1132,1138,1161,1162,1163,1166,1173,1174,1176,1193,1196,1202,1236,1397,1526,1529,1534,1535,1539,1540,1544,1548,1549,1554,1555,1655,1656,1657,1658,1675,1693,1769,1770,1772,1773,1778,1779,1781,1797,1866,1868,1869,1870,1914,2008,2009,2010,2012,2013,2018,2019,2020,2021,2025,2029,2030,2060,2064,2067,2070,2152,2164,2167,2176,2178,2190,2201,2204,2234,2235,2324,2951,2956,2957,2962,2963,2964,2965,2970,2976,2979,2989,3056,3103,3104,3110,3111,3113,3114,3116,3117,3118,3126,3127,3195,3198,3203,3206,3207,3232,3234,3244,3255,3269,3271,3272,3275,3284,3380,3382,3383,3397,3438,6846,6866,7235,7318,10158,10159,10160,10358,11911,202116,208638},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211325] = {
            [itemKeys.name] = "Waylaid Supplies: Handstitched Leather Belts",
            [itemKeys.npcDrops] = {40,46,61,116,117,119,126,157,199,285,456,471,474,481,500,501,504,515,519,589,732,830,880,1065,1115,1117,1118,1122,1131,1133,1135,1162,1163,1166,1172,1176,1177,1184,1188,1193,1196,1201,1236,1397,1523,1530,1532,1536,1537,1544,1545,1548,1554,1655,1662,1664,1674,1675,1693,1766,1767,1769,1773,1779,1780,1781,1866,1912,1914,1934,1936,1941,2000,2001,2005,2008,2010,2012,2013,2015,2017,2019,2020,2025,2029,2030,2034,2066,2152,2163,2177,2178,2185,2189,2190,2212,2231,2232,2234,2950,2951,2962,2965,2971,2976,2977,2978,2979,3068,3099,3103,3104,3107,3111,3112,3113,3116,3117,3119,3120,3122,3195,3198,3199,3204,3205,3206,3225,3232,3243,3244,3246,3265,3266,3267,3268,3269,3271,3276,3285,3379,4316,5826,6123,6128,6866,6927,7235,9523,10159,10160,11910,11911,12138,14428,14432,202060,208638,210549},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211326] = {
            [itemKeys.name] = "Waylaid Supplies: Embossed Leather Vests",
            [itemKeys.npcDrops] = {36,40,43,46,60,79,97,114,116,118,123,126,171,285,327,454,472,474,478,480,481,500,501,515,550,589,735,830,831,880,881,1109,1115,1116,1117,1118,1120,1121,1124,1135,1161,1162,1163,1166,1173,1174,1176,1177,1186,1188,1202,1236,1380,1424,1426,1522,1527,1528,1529,1531,1534,1544,1656,1660,1674,1766,1769,1770,1773,1780,1782,1865,1866,1867,1870,1912,1936,1941,1993,1997,1999,2000,2004,2005,2008,2011,2012,2014,2020,2025,2027,2030,2033,2043,2061,2069,2149,2152,2163,2175,2176,2177,2185,2201,2202,2204,2212,2231,2321,2324,2950,2951,2956,2957,2959,2962,2967,2970,2973,2974,2976,2977,2978,2990,3035,3056,3068,3099,3103,3111,3113,3115,3116,3117,3119,3129,3196,3197,3198,3203,3207,3232,3234,3254,3265,3266,3267,3269,3273,3276,3284,3380,3382,3383,4316,6123,6494,7234,7235,10159,10160,11910,12432,14428,209742,210107},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211327] = {
            [itemKeys.name] = "Waylaid Supplies: Brown Linen Pants",
            [itemKeys.npcDrops] = {36,43,60,95,97,99,121,123,124,199,285,390,442,456,550,583,712,732,735,822,830,881,1117,1122,1123,1130,1131,1133,1161,1164,1172,1173,1174,1175,1176,1184,1190,1196,1211,1380,1522,1527,1529,1530,1533,1534,1535,1536,1537,1538,1539,1540,1544,1549,1655,1657,1662,1664,1675,1768,1769,1770,1773,1797,1868,1912,1934,1972,1993,2000,2004,2009,2011,2012,2013,2015,2017,2018,2019,2021,2029,2030,2066,2069,2152,2163,2176,2177,2178,2179,2189,2190,2212,2232,2321,2324,2950,2957,2963,2968,2972,2977,2979,3068,3104,3111,3112,3113,3114,3115,3116,3117,3119,3120,3121,3129,3141,3195,3197,3207,3227,3232,3244,3246,3255,3266,3267,3268,3269,3276,3277,3282,3284,3384,3397,3470,3566,4263,5786,5865,6123,6466,6866,7318,10158,10160,11910,11913,12320,12432,12433,14428,14431,208638,210537},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211328] = {
            [itemKeys.name] = "Waylaid Supplies: Brown Linen Robes",
            [itemKeys.npcDrops] = {36,40,43,46,79,97,114,116,117,118,119,123,157,171,199,285,476,478,480,481,500,501,504,513,550,589,590,712,732,735,830,880,1117,1118,1120,1121,1122,1123,1127,1135,1163,1173,1174,1175,1176,1177,1191,1196,1197,1380,1426,1522,1523,1526,1527,1530,1531,1534,1535,1537,1538,1543,1544,1545,1549,1554,1658,1664,1689,1693,1767,1768,1778,1779,1782,1867,1914,1981,1983,1993,2004,2005,2008,2010,2012,2014,2020,2025,2027,2029,2030,2060,2152,2167,2176,2178,2185,2190,2201,2202,2204,2234,2324,2950,2959,2960,2965,2971,2976,2977,2979,2990,3051,3056,3068,3100,3103,3104,3107,3110,3111,3114,3115,3119,3127,3129,3196,3198,3199,3204,3206,3225,3232,3254,3265,3267,3269,3271,3274,3277,3284,3380,3383,3385,3397,3415,5807,6494,6866,6927,10159,10160,11913,14429,202060,208876,209742},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211329] = {
            [itemKeys.name] = "Waylaid Supplies: Herb Baked Eggs",
            [itemKeys.npcDrops] = {36,40,46,99,116,285,454,473,476,500,501,502,504,524,732,735,880,881,1115,1116,1117,1118,1119,1120,1122,1123,1131,1133,1135,1137,1161,1162,1172,1190,1194,1196,1202,1211,1236,1380,1397,1520,1527,1529,1531,1534,1537,1543,1544,1545,1554,1555,1655,1657,1658,1675,1689,1753,1766,1769,1772,1779,1780,1781,1782,1865,1867,1868,1869,1912,1924,1941,1981,1993,1999,2004,2008,2011,2013,2014,2017,2021,2027,2030,2039,2060,2061,2149,2152,2163,2164,2167,2176,2177,2189,2201,2202,2203,2232,2321,2324,2950,2951,2956,2959,2963,2964,2965,2968,2970,2971,2976,2977,2978,2989,3051,3058,3068,3099,3104,3107,3111,3112,3113,3114,3116,3117,3119,3126,3130,3195,3196,3197,3199,3206,3207,3232,3265,3267,3268,3269,3274,3276,3277,3282,3284,3285,3379,3380,3381,3384,3397,3438,3566,4008,6123,6789,6846,7235,10159,10160,10356,11913,14429,14432,208196},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211330] = {
            [itemKeys.name] = "Waylaid Supplies: Spiced Wolf Meat",
            [itemKeys.npcDrops] = {40,97,116,119,121,124,171,330,390,423,454,471,500,502,513,519,589,590,834,880,1065,1109,1116,1121,1122,1127,1131,1164,1174,1175,1176,1193,1201,1236,1520,1522,1530,1531,1532,1535,1537,1539,1543,1554,1654,1658,1662,1664,1693,1766,1769,1770,1782,1797,1865,1866,1867,1912,1922,1924,1953,1972,2005,2008,2010,2011,2012,2013,2020,2021,2025,2029,2030,2063,2065,2069,2149,2152,2167,2174,2176,2177,2179,2189,2190,2191,2201,2202,2203,2232,2324,2950,2951,2957,2959,2960,2962,2964,2971,2973,2976,2977,2979,3100,3103,3104,3107,3110,3111,3112,3114,3115,3116,3117,3119,3121,3129,3131,3195,3197,3198,3205,3206,3207,3231,3241,3244,3248,3265,3268,3271,3272,3379,3381,3382,3397,3566,5786,5823,5826,6123,6124,6866,7234,7235,7319,9523,10356,208638,209928},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211331] = {
            [itemKeys.name] = "Waylaid Supplies: Brilliant Smallfish",
            [itemKeys.npcDrops] = {36,43,95,97,118,119,121,199,330,390,442,473,476,480,513,515,550,590,712,735,822,830,833,834,880,881,1116,1117,1118,1120,1121,1123,1162,1163,1174,1175,1190,1202,1236,1380,1425,1426,1522,1526,1528,1529,1530,1537,1543,1545,1554,1656,1658,1665,1674,1675,1693,1765,1766,1767,1769,1772,1773,1779,1866,1914,1922,1936,1941,1972,1983,1993,2001,2004,2005,2010,2012,2015,2021,2025,2027,2030,2039,2067,2152,2163,2167,2174,2176,2177,2178,2179,2189,2190,2201,2202,2203,2232,2321,2324,2959,2960,2962,2963,2964,2965,2967,2972,2977,2978,2979,2989,2990,3056,3100,3104,3111,3112,3113,3114,3116,3117,3120,3122,3129,3130,3192,3197,3206,3207,3226,3267,3269,3274,3282,3284,3285,3379,3380,3381,3383,3384,3397,3425,3461,3566,4127,4316,5807,5865,6124,6846,7235,7318,7319,10158,10160,12138,14430,202060,208638,209742},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211332] = {
            [itemKeys.name] = "Waylaid Supplies: Heavy Linen Bandages",
            [itemKeys.npcDrops] = {43,95,97,99,118,119,121,123,423,473,474,476,478,481,712,732,830,834,881,1117,1121,1130,1133,1162,1163,1164,1166,1173,1175,1177,1201,1202,1211,1236,1397,1426,1520,1522,1528,1529,1535,1536,1537,1545,1549,1555,1657,1662,1664,1675,1689,1765,1766,1767,1768,1770,1779,1782,1865,1866,1867,1868,1934,1953,1981,1999,2001,2008,2009,2010,2012,2014,2017,2019,2021,2027,2029,2039,2061,2062,2067,2070,2149,2152,2177,2189,2190,2201,2203,2212,2231,2234,2321,2322,2324,2964,2970,2971,2974,2976,2977,2979,2989,3051,3103,3113,3114,3115,3116,3120,3123,3129,3192,3196,3197,3198,3199,3205,3207,3226,3227,3232,3242,3246,3254,3267,3268,3269,3272,3273,3274,3276,3284,3285,3381,3382,3438,3535,4008,4316,5786,5787,6123,6133,6494,6927,7234,7318,11911,14431,208638,210549},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211365] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211367] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211368] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211382] = {
            [itemKeys.name] = "Small Courier Satchel",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [211384] = {
            [itemKeys.name] = "Sturdy Courier Bag",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [211385] = {
            [itemKeys.name] = "Rune of Serpent Spread",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [211386] = {
            [itemKeys.name] = "Spell Notes: Arcane Surge",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [211387] = {
            [itemKeys.name] = "Rune of Beckoning Light",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101,233335},
            [itemKeys.startQuest] = nil,
        },
        [211390] = {
            [itemKeys.name] = "Rune of Teasing",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [211391] = {
            [itemKeys.name] = "Rune of Healing Rain",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101,233428},
            [itemKeys.startQuest] = nil,
        },
        [211392] = {
            [itemKeys.name] = "Rune of Everlasting Affliction",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [211393] = {
            [itemKeys.name] = "Rune of Single-Minded Fury",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [211419] = {
            [itemKeys.name] = "Handful of Shifting Scales",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211420] = {
            [itemKeys.name] = "Shifting Scale Talisman",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {214954},
            [itemKeys.startQuest] = nil,
        },
        [211421] = {
            [itemKeys.name] = "The Box",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211422] = {
            [itemKeys.name] = "Shard of the Void",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211423] = {
            [itemKeys.name] = "Void-Touched Leather Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211426] = {
            [itemKeys.name] = "Bough of Shadows",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {414197},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211427] = {
            [itemKeys.name] = "Soul Vessel",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211443] = {
            [itemKeys.name] = "Blade of Rage",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211444] = {
            [itemKeys.name] = "Summoner's Cloak",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211445] = {
            [itemKeys.name] = "Barbaric Recurve",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211447] = {
            [itemKeys.name] = "Arms Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211448] = {
            [itemKeys.name] = "Signed Procurement Contract",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211449] = {
            [itemKeys.name] = "Avenger's Void Pearl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {214954},
            [itemKeys.startQuest] = nil,
        },
        [211450] = {
            [itemKeys.name] = "Invoker's Void Pearl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {214954},
            [itemKeys.startQuest] = nil,
        },
        [211451] = {
            [itemKeys.name] = "Acolyte's Void Pearl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {214954},
            [itemKeys.startQuest] = nil,
        },
        [211452] = {
            [itemKeys.name] = "Perfect Blackfathom Pearl",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 78917,
        },
        [211454] = {
            [itemKeys.name] = "Strange Water Globe",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 78920,
        },
        [211455] = {
            [itemKeys.name] = "Slick Fingerless Gloves",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211456] = {
            [itemKeys.name] = "Dagger of Willing Sacrifice",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211457] = {
            [itemKeys.name] = "Twilight Defender's Girdle",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211458] = {
            [itemKeys.name] = "Tome of Shadow Warding",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211460] = {
            [itemKeys.name] = "Ancient Arctic Buckler",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211461] = {
            [itemKeys.name] = "Inscribed Gravestone Scepter",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211462] = {
            [itemKeys.name] = "Ever-Sustaining Ring",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211463] = {
            [itemKeys.name] = "Chittering Beetle Clasps",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211464] = {
            [itemKeys.name] = "Worn Prelacy Cape",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211465] = {
            [itemKeys.name] = "Nimbus Boots of Insight",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211466] = {
            [itemKeys.name] = "Tender's Heartwood Girdle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211467] = {
            [itemKeys.name] = "Band of the Iron Fist",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211468] = {
            [itemKeys.name] = "Frayed Chestnut Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211471] = {
            [itemKeys.name] = "Cliffspring Key",
            [itemKeys.npcDrops] = {2179,2180},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211472] = {
            [itemKeys.name] = "Libram of Banishment",
            [itemKeys.npcDrops] = {215,909,910},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335},
            [itemKeys.startQuest] = nil,
        },
        [211476] = {
            [itemKeys.name] = "Rune of Fires Wake",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {414713},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [211477] = {
            [itemKeys.name] = "Rune of Incinerate",
            [itemKeys.npcDrops] = {214519},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [211482] = {
            [itemKeys.name] = "Shatterspear Offering",
            [itemKeys.npcDrops] = {2181,2182,2183},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211487] = {
            [itemKeys.name] = "Demolition Explosives",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {3537},
            [itemKeys.startQuest] = nil,
        },
        [211488] = {
            [itemKeys.name] = "Rune of the Avenger",
            [itemKeys.npcDrops] = {214456},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335},
            [itemKeys.startQuest] = nil,
        },
        [211490] = {
            [itemKeys.name] = "Prophecy of a Thousand Lights",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211491] = {
            [itemKeys.name] = "Bottomless Murloc Skin Bag",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211492] = {
            [itemKeys.name] = "Kelris's Satchel",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211498] = {
            [itemKeys.name] = "Trainee's Sentinel Nightsaber",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {14753},
            [itemKeys.startQuest] = nil,
        },
        [211499] = {
            [itemKeys.name] = "Trainee's Outrider Wolf",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {14754},
            [itemKeys.startQuest] = nil,
        },
        [211500] = {
            [itemKeys.name] = "Resilient Cloth Headband",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {14753,14754},
            [itemKeys.startQuest] = nil,
        },
        [211501] = {
            [itemKeys.name] = "Chestguard of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211502] = {
            [itemKeys.name] = "Void-Touched Leather Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211504] = {
            [itemKeys.name] = "Twilight Avenger's Chain",
            [itemKeys.npcDrops] = {204921,207356,209678,213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211505] = {
            [itemKeys.name] = "Twilight Avenger's Helm",
            [itemKeys.npcDrops] = {204921,207356,209678,213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211506] = {
            [itemKeys.name] = "Twilight Avenger's Boots",
            [itemKeys.npcDrops] = {204921,207356,209678,213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211507] = {
            [itemKeys.name] = "Twilight Elementalist's Cowl",
            [itemKeys.npcDrops] = {204921,207356,209678,213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211508] = {
            [itemKeys.name] = "Twilight Elementalist's Footpads",
            [itemKeys.npcDrops] = {204921,207356,209678,213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211509] = {
            [itemKeys.name] = "Twilight Elementalist's Robe",
            [itemKeys.npcDrops] = {204921,207356,209678,213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211510] = {
            [itemKeys.name] = "Twilight Slayer's Cowl",
            [itemKeys.npcDrops] = {204921,207356,209678,213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211511] = {
            [itemKeys.name] = "Twilight Slayer's Footpads",
            [itemKeys.npcDrops] = {204921,207356,209678,213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211512] = {
            [itemKeys.name] = "Twilight Slayer's Tunic",
            [itemKeys.npcDrops] = {204921,207356,209678,213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211514] = {
            [itemKeys.name] = "Spell Notes: Mass Regeneration",
            [itemKeys.npcDrops] = {212261},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [211527] = {
            [itemKeys.name] = "Cozy Sleeping Bag",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {214954},
            [itemKeys.startQuest] = nil,
        },
        [211528] = {
            [itemKeys.name] = "Dark Insight",
            [itemKeys.npcDrops] = {215,909,910},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211530] = {
            [itemKeys.name] = "Prophecy of a City Enthralled",
            [itemKeys.npcDrops] = {436,214519},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [211531] = {
            [itemKeys.name] = "Prophecy of Seven Visitors",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [211534] = {
            [itemKeys.name] = "Primal Insight",
            [itemKeys.npcDrops] = {3748,3750,3922,3924},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211691] = {
            [itemKeys.name] = "Spell Notes: Arcane Blast",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [211777] = {
            [itemKeys.name] = "Naga Manuscript",
            [itemKeys.npcDrops] = {3715,3717},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211779] = {
            [itemKeys.name] = "Comprehension Charm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,12784,12795,13476,14739,15175,16015},
            [itemKeys.startQuest] = nil,
        },
        [211780] = {
            [itemKeys.name] = "Scroll: KWYJIBO",
            [itemKeys.npcDrops] = {36,46,61,97,117,118,126,285,330,473,474,500,504,513,515,524,589,732,735,822,824,834,1109,1117,1120,1121,1122,1124,1127,1131,1135,1138,1161,1162,1163,1172,1173,1174,1175,1176,1177,1186,1188,1195,1197,1211,1397,1426,1520,1523,1526,1527,1530,1532,1533,1534,1535,1537,1538,1540,1543,1544,1545,1548,1549,1553,1554,1555,1654,1662,1664,1665,1674,1675,1693,1765,1766,1767,1769,1770,1772,1773,1779,1780,1782,1866,1867,1868,1912,1922,1934,1941,1949,1981,1983,1996,1997,2001,2005,2010,2012,2027,2149,2167,2178,2189,2190,2212,2962,2964,2970,2979,2989,2990,3056,3103,3104,3107,3111,3112,3113,3114,3121,3198,3207,3225,3227,3255,3265,3267,3268,3271,3272,3275,3284,3285,3379,3535,4263,4316,5787,6494,6866,6927,7319,10159,11910,208196,208638,210537,210549,223340},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211784] = {
            [itemKeys.name] = "Scroll: WUBBA WUBBA",
            [itemKeys.npcDrops] = {98,121,171,218,232,423,424,428,430,431,432,434,437,441,445,449,453,517,531,533,544,568,578,598,615,819,832,898,920,930,1007,1011,1012,1013,1026,1031,1032,1033,1038,1040,1042,1044,1083,1164,1167,1169,1197,1206,1222,1353,1487,1727,1888,1889,1908,1915,1939,1940,1942,1943,1954,1955,1973,2054,2103,2156,2158,2168,2183,2206,2260,2261,2264,2265,2267,2268,2270,2323,2336,2337,2338,2339,2349,2351,2360,2387,2427,2449,2450,3240,3245,3252,3256,3257,3260,3263,3279,3282,3286,3374,3375,3377,3386,3393,3394,3395,3434,3435,3436,3445,3452,3454,3456,3457,3458,3476,3713,3715,3717,3737,3748,3750,3758,3762,3767,3772,3780,3783,3817,3833,3879,3925,3988,4001,4003,4006,4007,4012,4015,4016,4018,4021,4023,4026,4031,4036,4051,4053,4054,4073,4094,4096,4101,4104,4627,9523,9524,10323,10758,11714,11858,11912,11913,11917,12856,12896,221226},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = {223148},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211785] = {
            [itemKeys.name] = "Scroll: CWAL",
            [itemKeys.npcDrops] = {40,95,97,99,116,117,126,330,473,474,478,513,524,550,589,590,735,822,824,830,834,880,881,1115,1117,1120,1121,1122,1123,1126,1133,1138,1161,1162,1163,1166,1173,1174,1177,1186,1190,1195,1201,1202,1211,1424,1425,1426,1522,1523,1526,1528,1530,1531,1532,1533,1534,1535,1536,1537,1538,1540,1543,1545,1549,1553,1654,1656,1660,1664,1665,1674,1767,1769,1770,1772,1779,1782,1797,1865,1866,1867,1869,1912,1922,1934,1941,1953,2004,2008,2009,2010,2017,2018,2029,2030,2043,2063,2070,2149,2152,2167,2176,2179,2189,2191,2201,2202,2204,2231,2232,2951,2971,2978,2990,3056,3108,3110,3111,3113,3114,3120,3130,3195,3197,3198,3204,3207,3242,3246,3265,3268,3274,3276,3277,3284,3379,3381,3383,3397,3438,4008,6093,7235,10358,11910,11911,12433,202060,208196,209742,223340},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211786] = {
            [itemKeys.name] = "Scroll: CHAP BALK WELLES",
            [itemKeys.npcDrops] = {46,95,97,116,117,118,121,126,157,171,199,285,423,474,476,478,480,500,504,583,589,590,712,732,830,880,881,1115,1117,1120,1121,1123,1124,1126,1127,1138,1163,1164,1166,1173,1175,1176,1184,1190,1195,1196,1236,1380,1397,1520,1522,1523,1527,1529,1530,1532,1534,1535,1537,1538,1540,1543,1544,1545,1548,1554,1654,1656,1658,1674,1675,1766,1768,1769,1770,1772,1780,1782,1797,1865,1867,1869,1870,1911,1922,1936,1941,1971,1972,1999,2015,2018,2019,2021,2029,2060,2061,2062,2069,2070,2167,2176,2177,2179,2185,2190,2204,2232,2324,2951,2962,2971,2977,3103,3108,3111,3114,3116,3117,3118,3120,3126,3130,3192,3198,3203,3206,3207,3234,3243,3255,3265,3266,3267,3269,3271,3272,3275,3284,3379,3380,3381,3382,3415,6124,6466,6866,6927,10158,10159,11910,11911,11912,12431,207515,208875},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211787] = {
            [itemKeys.name] = "Scroll: LOWER PING WHOMEVER",
            [itemKeys.npcDrops] = {36,46,116,117,121,123,157,171,285,330,423,442,474,476,478,480,481,501,550,590,712,732,735,822,824,830,880,881,1065,1118,1120,1121,1122,1123,1124,1126,1127,1161,1163,1166,1174,1175,1176,1184,1186,1188,1191,1196,1197,1202,1380,1397,1426,1520,1523,1526,1528,1530,1532,1534,1537,1538,1539,1545,1553,1555,1656,1657,1662,1664,1675,1753,1769,1770,1773,1778,1779,1780,1781,1797,1866,1867,1914,1922,1941,1972,2011,2015,2017,2019,2020,2021,2030,2034,2039,2043,2061,2063,2067,2070,2152,2164,2177,2201,2204,2324,2950,2951,2963,3103,3104,3110,3111,3116,3118,3119,3120,3127,3129,3192,3197,3205,3206,3207,3228,3231,3243,3246,3265,3266,3268,3269,3271,3273,3274,3276,3284,3285,3381,3382,3383,4008,4316,5807,6789,7235,12138,14428,14432,208196,210107},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211789] = {
            [itemKeys.name] = "Artemis Cowl",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211799] = {
            [itemKeys.name] = "Sack of Stolen Goods",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211800] = {
            [itemKeys.name] = "Scroll of Reintegration",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211809] = {
            [itemKeys.name] = "Comprehension Primer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211813] = {
            [itemKeys.name] = "Silverwing Sentinel Charm",
            [itemKeys.npcDrops] = {212699,212703,212706,212707,212803,212804},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 79098,
        },
        [211814] = {
            [itemKeys.name] = "Warsong Outrider Mark",
            [itemKeys.npcDrops] = {212727,212728,212729,212730,212801,212802},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 79090,
        },
        [211815] = {
            [itemKeys.name] = "Silverwing Battle Hymn",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211816] = {
            [itemKeys.name] = "Warsong Battle Drum",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211818] = {
            [itemKeys.name] = "Strange Water Globe",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211819] = {
            [itemKeys.name] = "Waylaid Supplies: Bronze Bars",
            [itemKeys.npcDrops] = {98,121,203,217,232,423,424,426,429,432,434,435,437,440,441,445,446,450,453,505,531,544,547,568,573,578,580,598,832,891,923,1007,1008,1009,1011,1016,1027,1039,1042,1069,1167,1169,1185,1400,1417,1727,1889,1913,1974,2053,2103,2156,2157,2159,2160,2168,2180,2181,2187,2206,2207,2244,2260,2261,2265,2268,2269,2338,2349,2354,2356,2372,2373,2403,2428,2450,2503,3235,3245,3249,3263,3277,3278,3374,3376,3393,3394,3395,3424,3436,3445,3455,3456,3457,3467,3472,3474,3662,3664,3711,3712,3721,3725,3727,3728,3743,3746,3748,3749,3762,3772,3781,3783,3808,3817,3893,3924,3928,3944,3986,3988,3989,3991,3993,3998,3999,4001,4003,4014,4015,4018,4019,4020,4022,4026,4028,4054,4057,4067,4073,4094,4096,4099,4114,4129,4264,4416,4463,5053,5682,5834,6020,6547,6668,6788,7016,9336,10758,11680,11858,11917,12856,12897,14280,210487,211965},
            [itemKeys.objectDrops] = {1721,2849,2850,3714,3715,111095},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211820] = {
            [itemKeys.name] = "Waylaid Supplies: Silver Bars",
            [itemKeys.npcDrops] = {48,122,171,203,213,217,315,433,434,435,441,445,449,453,458,485,517,545,548,565,579,598,909,920,1008,1010,1012,1016,1020,1024,1026,1027,1028,1030,1040,1042,1043,1069,1164,1167,1169,1197,1206,1222,1487,1915,1924,1940,1942,1943,1973,1974,2103,2120,2157,2159,2160,2169,2170,2171,2180,2183,2206,2235,2250,2261,2265,2268,2269,2270,2305,2323,2332,2336,2338,2339,2349,2360,2373,2384,2427,2448,2449,2451,2503,3235,3236,3247,3252,3260,3279,3286,3374,3375,3385,3394,3395,3424,3455,3457,3459,3472,3473,3475,3713,3717,3727,3732,3734,3735,3737,3745,3750,3757,3772,3780,3781,3783,3806,3819,3893,3921,3922,3923,3925,3932,3986,3987,3989,3999,4001,4005,4012,4018,4021,4026,4028,4029,4044,4051,4053,4067,4070,4112,4114,4126,4416,4627,4969,5834,6170,6180,6547,10760,11681,11858,11917,12856,14270,14271,14425,185333,211965,214129},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211821] = {
            [itemKeys.name] = "Waylaid Supplies: Medium Leather",
            [itemKeys.npcDrops] = {115,122,218,424,428,429,430,431,434,435,437,440,445,446,450,485,518,520,531,544,569,578,579,598,831,889,920,923,1008,1012,1025,1033,1038,1039,1042,1043,1044,1069,1165,1205,1207,1216,1224,1258,1400,1727,1755,1888,1913,1915,1940,1942,1943,1953,1955,1973,1974,2054,2102,2156,2165,2168,2169,2170,2171,2174,2180,2182,2187,2207,2208,2244,2260,2261,2265,2269,2270,2336,2338,2349,2360,2372,2384,2403,2451,2503,3236,3251,3261,3275,3280,3283,3286,3377,3396,3416,3426,3434,3454,3457,3458,3461,3471,3473,3664,3713,3715,3733,3743,3750,3758,3762,3783,3789,3814,3816,3820,3823,3879,3898,3899,3917,3922,3924,3925,3928,3943,3944,3989,3991,3992,3993,3999,4002,4003,4009,4020,4023,4036,4053,4093,4094,4096,4113,4120,4129,4250,4264,4416,4627,5053,5683,6180,6547,6606,8886,10323,10760,11656,11680,11912,12856,12860,212837},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = {223148},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211822] = {
            [itemKeys.name] = "Waylaid Supplies: Bruiseweed",
            [itemKeys.npcDrops] = {3,115,121,122,202,422,423,424,428,430,431,432,435,437,440,441,453,458,531,544,572,578,628,1007,1008,1011,1012,1016,1028,1030,1039,1040,1042,1165,1169,1185,1189,1192,1206,1216,1259,1727,1913,1943,1957,1958,1973,2120,2157,2158,2160,2172,2179,2182,2183,2186,2206,2208,2260,2269,2270,2323,2336,2338,2339,2351,2360,2384,2403,2428,2449,2503,3235,3237,3245,3248,3249,3253,3257,3258,3282,3283,3374,3375,3376,3377,3386,3394,3424,3452,3455,3456,3457,3467,3474,3660,3662,3717,3727,3730,3732,3734,3739,3740,3748,3750,3772,3782,3783,3819,3824,3833,3879,3893,3899,3925,3926,3943,3986,3987,3989,3991,3992,3993,3999,4001,4003,4004,4006,4007,4018,4019,4020,4021,4023,4029,4036,4037,4051,4053,4057,4067,4094,4096,4097,4099,4111,4126,4416,4541,5830,6547,6606,9456,9524,10323,10757,10760,11858,11915,12896,14272,185334,210107,210482,212837,214129},
            [itemKeys.objectDrops] = {2849,2850,3714,3715,111095},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211823] = {
            [itemKeys.name] = "Waylaid Supplies: Swiftthistle",
            [itemKeys.npcDrops] = {48,98,202,217,218,232,345,422,429,432,434,435,437,441,449,452,517,531,539,547,568,569,578,579,703,889,920,948,949,1012,1016,1024,1031,1038,1040,1042,1043,1044,1069,1167,1185,1189,1194,1206,1224,1727,1755,1870,1888,1909,1939,1943,1955,2102,2103,2158,2160,2165,2171,2187,2208,2236,2251,2261,2264,2265,2269,2270,2338,2354,2372,2387,2403,2427,2450,2451,2503,3240,3245,3247,3250,3374,3375,3376,3377,3424,3435,3467,3472,3619,3662,3664,3713,3721,3728,3732,3733,3739,3742,3745,3746,3749,3750,3772,3774,3780,3781,3783,3799,3801,3803,3809,3817,3823,3919,3924,3925,3926,3928,3944,3986,3987,3993,3998,3999,4002,4013,4014,4016,4023,4028,4051,4053,4067,4094,4096,4097,4104,4110,4117,4129,4416,5863,6180,6547,9524,10373,10617,10758,10760,11858,11918,11921,12678,12856,12897,14424,15692,185333,209524,209797,210107,210451,210482,221227},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = {223148},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211824] = {
            [itemKeys.name] = "Waylaid Supplies: Lesser Mana Potions",
            [itemKeys.npcDrops] = {3,48,115,121,122,218,424,432,434,441,449,458,485,518,545,579,580,598,615,628,948,1007,1008,1009,1027,1028,1038,1040,1043,1044,1069,1164,1192,1206,1216,1222,1258,1393,1400,1666,1888,1913,1924,1940,1942,1958,1974,2102,2103,2156,2157,2168,2169,2170,2171,2180,2233,2236,2250,2251,2260,2265,2268,2269,2270,2332,2338,2339,2354,2427,2428,2503,2760,3240,3241,3250,3251,3260,3275,3277,3282,3286,3376,3377,3393,3394,3398,3454,3455,3457,3459,3467,3471,3472,3473,3664,3711,3721,3725,3732,3743,3745,3748,3750,3772,3780,3781,3783,3797,3799,3802,3808,3810,3812,3815,3816,3820,3823,3824,3833,3893,3899,3921,3926,3986,3987,3988,3989,3991,3992,3999,4009,4012,4014,4016,4017,4020,4021,4022,4026,4028,4040,4051,4053,4054,4073,4093,4110,4463,4969,6180,6668,6788,8886,9456,9524,11681,11714,11917,12677,12678,12856,12860,12896,12940,185334,210697,211965,221227},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = {223148},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211825] = {
            [itemKeys.name] = "Waylaid Supplies: Rough Bronze Boots",
            [itemKeys.npcDrops] = {3,48,98,115,122,154,202,206,212,218,315,424,426,429,430,433,435,437,440,441,445,446,449,450,485,518,544,568,579,615,711,891,909,1007,1009,1010,1012,1013,1015,1016,1027,1028,1029,1030,1032,1038,1040,1041,1042,1043,1044,1069,1189,1205,1222,1224,1353,1727,1755,1888,1908,1913,1924,1939,1958,2071,2102,2120,2157,2158,2165,2168,2179,2187,2206,2235,2236,2237,2244,2250,2260,2264,2269,2270,2336,2339,2360,2387,2428,2451,2503,3253,3257,3258,3374,3375,3377,3386,3394,3396,3434,3445,3458,3466,3473,3662,3667,3713,3715,3727,3737,3743,3745,3749,3750,3772,3781,3783,3784,3804,3823,3899,3921,3923,3924,3926,3931,3993,3998,3999,4002,4003,4004,4007,4012,4022,4025,4029,4034,4037,4040,4051,4053,4054,4067,4074,4100,4416,4463,4541,5053,6180,9336,9456,9523,10373,10896,11681,11858,11914,11917,11921,12856,12896,12897,14270,14281,212837},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = {223148},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211826] = {
            [itemKeys.name] = "Waylaid Supplies: Silver Skeleton Keys",
            [itemKeys.npcDrops] = {98,213,218,345,424,426,431,445,452,458,505,539,544,565,579,580,598,615,628,832,1009,1010,1027,1030,1040,1042,1205,1258,1259,1889,1923,1943,1957,1973,1974,2053,2156,2169,2180,2244,2260,2265,2269,2270,2336,2339,2349,2373,2404,2449,3250,3260,3279,3396,3459,3664,3712,3728,3743,3746,3749,3750,3772,3799,3806,3817,3879,3893,3899,3900,3921,3922,3925,3944,3991,4001,4002,4012,4020,4022,4074,4110,4416,4627,5830,5863,6180,8886,9456,10761,11714,11858,12856,12896,185333,210487},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = {223148},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211827] = {
            [itemKeys.name] = "Waylaid Supplies: Runed Silver Rods",
            [itemKeys.npcDrops] = {48,98,122,127,202,213,215,232,422,423,424,426,428,429,430,431,432,433,434,435,440,441,446,449,453,458,485,505,518,531,545,547,548,565,568,578,580,598,615,711,824,889,909,923,930,948,1007,1008,1017,1020,1021,1022,1024,1025,1027,1028,1040,1083,1111,1164,1165,1167,1194,1197,1400,1417,1727,1888,1889,1914,1915,1939,1940,1942,1953,1974,2071,2156,2157,2159,2169,2180,2181,2182,2187,2207,2208,2233,2235,2237,2244,2260,2261,2266,2267,2268,2322,2323,2336,2338,2339,2350,2351,2384,3239,3240,3245,3249,3256,3258,3260,3263,3275,3277,3278,3279,3280,3282,3283,3286,3374,3376,3385,3394,3396,3457,3458,3459,3461,3713,3721,3725,3732,3739,3743,3750,3762,3772,3774,3781,3809,3814,3816,3824,3921,3928,3944,3988,3989,3991,3992,4003,4004,4005,4006,4007,4012,4013,4014,4022,4024,4025,4036,4040,4044,4051,4074,4094,4096,4112,4416,4463,4627,5053,8886,9523,9524,11912,11917,214129},
            [itemKeys.objectDrops] = {2849,2850,111095},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211828] = {
            [itemKeys.name] = "Waylaid Supplies: Minor Mana Oil",
            [itemKeys.npcDrops] = {121,122,127,171,213,422,424,426,428,429,430,431,432,434,435,437,440,441,442,446,449,485,505,531,539,547,548,565,568,598,615,819,948,1007,1008,1010,1011,1020,1021,1024,1025,1028,1040,1083,1111,1164,1165,1167,1189,1192,1194,1205,1216,1393,1400,1417,1908,1939,1940,1973,2089,2157,2158,2165,2168,2170,2179,2180,2182,2183,2233,2235,2237,2244,2260,2261,2266,2267,2268,2332,2336,2338,2339,2349,2356,2360,2384,3239,3240,3241,3245,3252,3256,3257,3258,3260,3261,3263,3277,3278,3280,3282,3283,3286,3374,3375,3385,3393,3394,3416,3426,3435,3457,3459,3461,3466,3467,3667,3711,3712,3713,3717,3728,3730,3739,3743,3746,3748,3749,3762,3817,3819,3823,3917,3921,3944,3988,3989,3991,3999,4002,4003,4005,4007,4012,4013,4019,4020,4022,4025,4040,4051,4067,4070,4093,4127,4128,4129,4416,4463,4627,5053,6180,8886,9336,9523,10323,11912,11913,11917,11918,12856,214129},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211829] = {
            [itemKeys.name] = "Waylaid Supplies: Small Bronze Bombs",
            [itemKeys.npcDrops] = {3,48,98,127,213,218,232,424,426,429,432,433,435,437,440,441,445,449,452,485,517,518,579,580,598,615,628,889,909,923,948,1009,1015,1025,1028,1030,1032,1039,1040,1041,1042,1043,1069,1083,1111,1169,1189,1206,1393,1399,1888,1889,1908,1914,1924,1942,1943,1953,1954,1973,1974,2054,2157,2158,2159,2168,2180,2183,2186,2206,2208,2244,2251,2264,2265,2267,2269,2270,2323,2354,2372,2403,2427,2451,2503,3249,3256,3257,3260,3283,3374,3376,3377,3386,3393,3395,3396,3416,3434,3457,3463,3466,3471,3472,3713,3727,3730,3734,3737,3746,3748,3749,3750,3765,3770,3772,3774,3780,3804,3807,3814,3815,3816,3820,3821,3900,3922,3923,3926,3988,3999,4003,4004,4007,4014,4021,4026,4031,4057,4093,4095,4096,4110,4116,4273,4463,4627,6547,6606,10639,10644,10756,10758,10759,11680,11858,11912,11918,12896,12897,12918,221227},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211830] = {
            [itemKeys.name] = "Waylaid Supplies: Ornate Spyglasses",
            [itemKeys.npcDrops] = {122,127,171,203,206,215,217,218,232,345,426,429,430,432,434,435,437,440,441,446,450,453,458,505,518,533,547,548,578,579,598,832,909,910,920,923,1007,1009,1011,1012,1021,1033,1042,1169,1192,1205,1393,1399,1720,1727,1754,1870,1913,1914,1915,1923,1924,1940,1942,1955,1956,1958,1973,1974,2054,2103,2156,2157,2168,2169,2170,2171,2180,2206,2235,2250,2251,2261,2265,2269,2270,2323,2338,2339,2360,2372,2428,2449,2503,3238,3245,3257,3261,3277,3278,3280,3282,3283,3374,3376,3377,3385,3386,3426,3454,3457,3458,3467,3713,3721,3730,3732,3733,3745,3746,3748,3749,3750,3762,3772,3781,3782,3783,3815,3819,3879,3922,3932,3987,3988,3989,3992,3993,3998,3999,4003,4011,4012,4016,4020,4023,4025,4035,4040,4042,4051,4054,4067,4070,4073,4074,4094,4097,4114,4127,4129,4250,4273,4416,5053,5829,5836,6180,6606,6788,7017,8886,9523,10759,10760,11681,11912,11915,11917,11918,12896,12897,14270,210451,210697,211965},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = {223148},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211831] = {
            [itemKeys.name] = "Waylaid Supplies: Dark Leather Cloaks",
            [itemKeys.npcDrops] = {3,115,122,127,154,213,218,232,422,424,426,428,433,435,437,440,441,445,449,452,453,485,518,539,547,579,598,824,889,1007,1008,1010,1011,1012,1024,1026,1028,1030,1032,1038,1039,1042,1043,1069,1165,1167,1189,1206,1216,1400,1666,1727,1754,1888,1909,1915,1923,1924,1939,1940,1956,1973,1974,2102,2103,2120,2156,2157,2158,2159,2168,2169,2182,2183,2184,2205,2244,2260,2265,2266,2268,2269,2270,2336,2338,2339,2360,2369,2372,2384,2449,2450,2451,2503,3235,3237,3240,3250,3279,3280,3283,3286,3375,3377,3385,3386,3395,3396,3424,3434,3436,3455,3459,3467,3503,3717,3721,3728,3732,3733,3734,3736,3740,3743,3750,3757,3772,3780,3781,3783,3784,3799,3806,3817,3823,3833,3925,3931,3943,3989,3999,4001,4009,4012,4022,4026,4054,4070,4073,4074,4096,4099,4112,4264,4416,4541,4627,4969,5835,5836,9523,10896,11656,11680,11714,12897,14271,185333,209524,209797,221226,221227},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211832] = {
            [itemKeys.name] = "Waylaid Supplies: Hillman's Shoulders",
            [itemKeys.npcDrops] = {3,98,115,122,127,202,203,213,300,424,428,429,430,432,434,435,446,449,450,452,453,458,485,505,568,569,580,615,628,824,831,898,909,949,1007,1010,1012,1013,1030,1031,1032,1039,1040,1042,1043,1044,1083,1111,1140,1189,1216,1258,1353,1487,1888,1889,1914,1924,1939,1940,1942,1943,1953,1958,1973,1974,2053,2103,2120,2156,2158,2159,2165,2168,2169,2171,2180,2182,2187,2205,2208,2235,2260,2261,2264,2267,2269,2270,2336,2372,2373,2387,2403,2503,3249,3251,3252,3256,3275,3278,3282,3283,3375,3376,3394,3395,3416,3424,3455,3457,3461,3467,3471,3664,3717,3733,3745,3746,3757,3758,3763,3772,3782,3791,3802,3807,3809,3893,3924,3986,3993,4003,4004,4005,4007,4012,4014,4021,4023,4042,4053,4057,4073,4074,4094,4096,4099,4112,4129,4250,4416,4463,4541,4627,4969,5053,5847,6167,6180,6606,10373,10761,11656,11680,11697,11714,11917,11918,12940,211965},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211833] = {
            [itemKeys.name] = "Waylaid Supplies: Gray Woolen Shirts",
            [itemKeys.npcDrops] = {98,115,121,122,127,154,202,203,215,217,218,232,428,430,432,433,434,435,441,458,548,568,578,580,598,615,628,1007,1008,1012,1024,1026,1031,1032,1033,1035,1040,1043,1044,1069,1083,1111,1169,1216,1755,1888,1889,1908,1909,1913,1924,1939,1940,1942,1943,1953,1955,2089,2102,2103,2120,2157,2160,2168,2169,2170,2179,2181,2182,2183,2207,2233,2260,2261,2265,2266,2267,2269,2270,2323,2338,2339,2349,2351,2360,2370,2403,2404,2449,2503,3235,3239,3240,3245,3251,3260,3263,3278,3295,3374,3377,3386,3393,3395,3396,3435,3445,3454,3455,3458,3459,3473,3475,3712,3715,3721,3725,3727,3730,3743,3745,3748,3750,3771,3772,3780,3781,3782,3783,3791,3806,3817,3819,3823,3879,3893,3922,3924,3943,3986,3988,3989,3998,4002,4003,4004,4007,4014,4016,4026,4057,4074,4093,4099,4113,4117,4416,5832,5834,6606,6788,9523,9524,10323,10617,10760,11858,11917,11918,12677,12860,211965},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211834] = {
            [itemKeys.name] = "Waylaid Supplies: Pearl-clasped Cloaks",
            [itemKeys.npcDrops] = {121,122,124,125,127,202,217,218,423,424,426,431,432,434,441,446,449,485,505,506,531,545,568,569,580,615,819,891,1008,1009,1010,1024,1027,1032,1039,1040,1042,1043,1044,1165,1185,1189,1192,1216,1222,1259,1393,1400,1754,1755,1870,1889,1908,1913,1915,1923,1939,1943,1953,1955,2054,2120,2156,2158,2160,2165,2168,2179,2180,2233,2237,2244,2261,2264,2265,2266,2268,2269,2270,2335,2337,2338,2349,2372,2373,2387,2451,2503,3239,3252,3275,3279,3282,3374,3375,3376,3377,3386,3416,3445,3455,3457,3459,3467,3715,3721,3725,3727,3732,3734,3739,3748,3749,3750,3772,3780,3781,3783,3789,3797,3802,3804,3823,3893,3925,3928,3943,3991,3992,4002,4004,4007,4020,4025,4036,4040,4053,4073,4094,4095,4097,4111,4128,4273,4416,4463,5683,5829,5863,6020,6547,6606,6668,9524,10373,10758,10760,10761,11714,11858,11912,11918,12856,209797,210697},
            [itemKeys.objectDrops] = {2849,2850,3714,3715,111095},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211835] = {
            [itemKeys.name] = "Waylaid Supplies: Smoked Sagefish",
            [itemKeys.npcDrops] = {98,115,122,124,127,154,206,215,232,424,428,431,432,435,440,445,446,449,452,453,531,544,547,565,568,579,598,615,628,711,889,891,1007,1008,1010,1011,1015,1030,1032,1033,1039,1043,1044,1083,1140,1192,1205,1207,1251,1399,1720,1909,1939,1940,1943,1954,1956,1957,2054,2103,2157,2158,2165,2168,2169,2171,2180,2182,2183,2244,2251,2260,2261,2265,2268,2269,2270,2336,2337,2356,2360,2372,2373,2387,2403,2427,2428,2449,2451,2503,3235,3236,3252,3275,3280,3374,3377,3386,3393,3394,3395,3445,3456,3457,3471,3473,3662,3713,3715,3733,3734,3737,3740,3743,3772,3780,3783,3784,3797,3804,3806,3811,3819,3879,3922,3987,3989,3992,3998,4003,4004,4005,4006,4008,4014,4015,4022,4025,4028,4034,4036,4044,4053,4054,4057,4094,4095,4096,4100,4112,4116,4416,4627,4711,5053,5847,6167,6547,6606,9336,9523,9524,10373,10760,11858,11913,12678,12860,12940,209797,221227},
            [itemKeys.objectDrops] = {2849,2850,3714,3715,111095},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211836] = {
            [itemKeys.name] = "Waylaid Supplies: Smoked Bear Meat",
            [itemKeys.npcDrops] = {115,122,202,203,422,424,426,429,431,432,433,434,435,437,441,445,446,453,458,505,517,531,568,569,598,615,819,824,892,909,910,1007,1008,1009,1011,1028,1032,1039,1043,1069,1165,1169,1189,1206,1216,1720,1727,1888,1914,1915,1939,1942,1954,1957,2054,2103,2157,2168,2169,2171,2183,2244,2260,2261,2264,2265,2266,2269,2270,2322,2336,2338,2373,2404,2427,2450,2476,2503,3237,3240,3251,3282,3374,3375,3376,3386,3394,3398,3426,3452,3455,3456,3457,3459,3472,3475,3662,3664,3725,3732,3734,3739,3743,3745,3746,3749,3750,3783,3820,3823,3879,3893,3922,3924,3925,3989,3999,4004,4008,4011,4015,4018,4019,4020,4021,4022,4024,4028,4032,4051,4054,4070,4094,4096,4112,4113,4463,4627,6606,9336,9456,9523,10758,10760,11714,11858,11917,11921,12856,12897,12940,209797,210107,210451,210487,223340},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211837] = {
            [itemKeys.name] = "Waylaid Supplies: Goblin Deviled Clams",
            [itemKeys.npcDrops] = {48,98,121,122,124,171,202,205,206,218,424,430,432,433,434,441,445,449,450,505,544,547,548,568,598,615,832,910,923,948,949,1009,1010,1011,1025,1038,1039,1040,1042,1044,1069,1165,1185,1207,1216,1393,1400,1720,1727,1754,1913,1915,1939,1940,1956,1958,1974,2054,2102,2103,2158,2179,2182,2206,2207,2208,2237,2244,2250,2260,2261,2265,2266,2267,2268,2269,2270,2336,2338,2354,2373,2384,2387,2449,2503,3238,3239,3240,3247,3251,3277,3278,3283,3374,3386,3396,3414,3416,3426,3434,3455,3457,3458,3459,3466,3662,3711,3713,3717,3725,3727,3730,3734,3737,3743,3746,3750,3752,3758,3772,3802,3808,3824,3879,3893,3900,3923,3932,3989,3993,3998,4002,4004,4007,4022,4025,4028,4031,4036,4037,4054,4094,4096,4097,4114,4202,4416,4463,4664,5053,6180,6547,6606,7015,8886,9456,9523,9524,10760,11714,11858,11915,11917,12860,12896,185333,209797,210482,211965,212837,221226},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211838] = {
            [itemKeys.name] = "Waylaid Supplies: Heavy Wool Bandages",
            [itemKeys.npcDrops] = {115,122,202,218,300,426,430,433,434,437,445,446,453,505,531,544,565,628,889,949,1007,1008,1010,1022,1024,1025,1033,1038,1040,1043,1083,1169,1192,1205,1393,1398,1487,1666,1727,1754,1888,1889,1909,1913,1924,1939,1942,1954,1956,1957,1973,1974,2053,2156,2157,2165,2168,2169,2170,2171,2180,2182,2206,2207,2233,2235,2244,2264,2265,2269,2270,2322,2323,2336,2339,2350,2356,2360,2387,2403,2404,2450,2451,2503,3239,3245,3247,3249,3252,3257,3279,3280,3283,3374,3377,3385,3393,3394,3395,3416,3455,3457,3459,3467,3715,3725,3732,3734,3737,3739,3740,3746,3749,3780,3781,3782,3783,3799,3804,3809,3819,3820,3824,3879,3893,3921,3924,3940,3989,3992,3999,4002,4004,4012,4014,4018,4019,4020,4021,4023,4025,4032,4036,4040,4044,4057,4094,4096,4097,4101,4129,4416,4627,4711,5682,6180,6547,9336,9523,9524,10373,10758,11917,12856,210451,210697,212837,221226},
            [itemKeys.objectDrops] = {2849,2850,3714,3715,111095},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211839] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211840] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211841] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211842] = {
            [itemKeys.name] = "Rakkamar's Tattered Thinking Cap",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211843] = {
            [itemKeys.name] = "Mask of Scorn",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211845] = {
            [itemKeys.name] = "Blackfathom Sharpening Stone",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211846] = {
            [itemKeys.name] = "Plans: Blackfathom Sharpening Stone",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {415614},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211848] = {
            [itemKeys.name] = "Blackfathom Mana Oil",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211849] = {
            [itemKeys.name] = "Formula: Blackfathom Mana Oil",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {415614},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211852] = {
            [itemKeys.name] = "Handwraps of Befouled Water",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211853] = {
            [itemKeys.name] = "Scroll: VOCE WELL",
            [itemKeys.npcDrops] = {3,98,115,121,122,124,127,202,203,232,345,422,428,429,432,433,435,437,440,441,445,452,458,517,531,545,547,548,578,579,580,598,615,785,824,832,920,923,930,1007,1008,1009,1013,1024,1040,1043,1165,1167,1189,1197,1353,1727,1754,1913,1914,1942,1943,1956,1958,1973,1974,2054,2103,2157,2158,2159,2168,2169,2180,2207,2236,2244,2260,2261,2265,2266,2267,2269,2270,2332,2336,2338,2350,2354,2360,2387,2403,2427,2503,3250,3258,3263,3275,3280,3282,3374,3375,3377,3386,3393,3394,3434,3436,3452,3456,3457,3467,3472,3476,3503,3667,3711,3721,3732,3733,3734,3735,3739,3743,3746,3748,3750,3759,3780,3781,3783,3817,3820,3824,3879,3923,3925,3926,3988,3998,4002,4007,4020,4022,4026,4032,4044,4051,4053,4067,4093,4094,4095,4101,4126,4128,4129,4416,4463,4627,6020,6180,6547,9524,10758,11697,11858,11913,11917,12897},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = {223148},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211854] = {
            [itemKeys.name] = "Scroll: OMIT KESA",
            [itemKeys.npcDrops] = {48,98,115,122,125,127,202,213,423,424,428,429,430,432,440,441,442,445,449,453,485,531,545,547,568,578,579,615,889,891,920,930,1007,1008,1011,1020,1021,1024,1029,1031,1032,1035,1036,1039,1040,1069,1083,1164,1167,1169,1192,1666,1727,1888,1908,1913,1940,1942,1954,1955,1956,1973,1974,2102,2156,2158,2160,2165,2170,2171,2206,2244,2260,2264,2265,2267,2270,2336,2337,2338,2339,2350,2354,2360,2387,2404,2427,3237,3240,3253,3263,3275,3278,3283,3286,3374,3375,3377,3386,3424,3434,3436,3455,3456,3457,3467,3471,3473,3662,3664,3713,3715,3728,3732,3733,3734,3743,3758,3780,3781,3782,3804,3812,3814,3834,3879,3893,3926,3944,3986,3987,3999,4002,4006,4013,4016,4018,4022,4025,4026,4034,4051,4054,4057,4073,4093,4094,4095,4096,4099,4116,4416,4463,5053,5832,6180,6547,9524,10760,11917,11921,12856,12940,14270,223340},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = {223148},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211855] = {
            [itemKeys.name] = "Scroll: STHENIC LUNATE",
            [itemKeys.npcDrops] = {3,48,121,122,202,424,431,432,440,441,442,445,446,449,453,505,517,531,545,565,578,579,598,819,831,892,920,930,1007,1008,1010,1011,1015,1021,1026,1027,1030,1035,1040,1069,1157,1158,1165,1167,1169,1189,1727,1888,1889,1913,1939,1940,1942,1943,1956,1973,2071,2102,2160,2182,2183,2206,2244,2261,2266,2267,2269,2270,2337,2354,2360,2404,2451,2503,3237,3240,3248,3250,3256,3257,3260,3261,3263,3277,3278,3374,3375,3378,3386,3395,3436,3445,3456,3457,3459,3466,3467,3503,3727,3728,3730,3737,3746,3750,3780,3781,3783,3789,3814,3898,3900,3923,3986,3987,3999,4001,4002,4005,4018,4019,4020,4025,4026,4032,4040,4051,4054,4057,4067,4070,4073,4074,4094,4097,4100,4116,4264,4416,4463,5848,6547,6606,12856,12860,12897,14271,210451,210697,223340},
            [itemKeys.objectDrops] = {2849,2850,3714,3715,111095},
            [itemKeys.itemDrops] = {223148},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211856] = {
            [itemKeys.name] = "Resilient Mail Coif",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {14753,14754},
            [itemKeys.startQuest] = nil,
        },
        [211857] = {
            [itemKeys.name] = "Resilient Leather Mask",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {14753,14754},
            [itemKeys.startQuest] = nil,
        },
        [211933] = {
            [itemKeys.name] = "Waylaid Supplies: Rough Stone",
            [itemKeys.npcDrops] = {46,79,95,97,119,121,285,471,473,474,476,480,481,500,501,502,513,735,830,846,880,881,1115,1117,1121,1123,1127,1130,1132,1135,1161,1163,1166,1172,1173,1174,1175,1176,1184,1190,1193,1197,1260,1380,1397,1424,1426,1520,1522,1523,1530,1531,1533,1534,1538,1539,1540,1555,1658,1660,1662,1674,1675,1767,1769,1772,1779,1782,1865,1866,1867,1912,1914,1924,1934,1936,1941,1971,1981,1997,1999,2004,2005,2010,2013,2018,2020,2025,2027,2029,2030,2033,2038,2064,2152,2163,2167,2178,2190,2201,2202,2203,2950,2957,2965,2973,2974,2979,2990,3056,3103,3104,3112,3113,3114,3116,3119,3120,3122,3126,3129,3196,3197,3198,3199,3206,3225,3227,3232,3254,3265,3267,3269,3276,3284,3285,3381,3382,3384,3385,4316,5787,5808,5809,6123,6494,6866,6927,7235,7318,7319,9523,10159,11910,11911,13157,14429,202060,202116,207515,208071,208196},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211934] = {
            [itemKeys.name] = "Waylaid Supplies: Healing Potions",
            [itemKeys.npcDrops] = {46,97,114,116,118,123,124,157,199,327,330,423,474,476,481,500,501,502,515,712,732,735,822,824,830,881,1109,1116,1122,1123,1124,1126,1132,1133,1135,1161,1163,1166,1174,1184,1186,1190,1191,1193,1195,1201,1202,1236,1380,1523,1526,1527,1528,1530,1535,1537,1540,1544,1654,1658,1660,1662,1664,1674,1675,1693,1770,1780,1782,1797,1867,1868,1869,1912,1914,1922,1924,1934,1941,1996,1999,2008,2009,2013,2015,2021,2025,2030,2038,2039,2060,2067,2069,2152,2167,2177,2178,2185,2189,2190,2201,2203,2232,2322,2324,2950,2959,2962,2965,2971,2972,2976,2977,2978,3035,3103,3104,3110,3111,3112,3113,3114,3117,3120,3126,3129,3192,3198,3204,3207,3227,3232,3241,3265,3266,3267,3269,3272,3276,3285,3381,3382,3397,3415,3470,4316,6466,6494,6497,6866,7234,7235,7318,9523,10157,10158,10160,11910,14428,202060,208196,209742},
            [itemKeys.objectDrops] = {106318,106319,404352},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211935] = {
            [itemKeys.name] = "Waylaid Supplies: Elixir of Firepower",
            [itemKeys.npcDrops] = {3,48,115,121,122,125,127,203,215,217,345,423,424,426,428,429,430,432,433,434,435,437,440,441,445,446,449,452,453,485,517,521,544,573,578,580,598,615,831,889,923,949,1009,1011,1016,1021,1022,1024,1027,1032,1039,1069,1160,1164,1222,1727,1888,1908,1909,1913,1914,1920,1942,1955,1958,1973,2054,2103,2157,2159,2171,2233,2244,2260,2261,2267,2269,2270,2338,2356,2370,2373,2427,2428,2449,2503,3240,3258,3275,3279,3280,3374,3375,3376,3393,3396,3434,3445,3454,3457,3475,3662,3713,3717,3721,3728,3733,3742,3743,3745,3746,3750,3757,3791,3806,3817,3824,3899,3919,3922,3923,3926,3943,3989,3991,3993,4004,4007,4011,4016,4021,4022,4053,4054,4057,4067,4070,4093,4094,4099,4113,4202,4416,4463,4627,6547,6788,8886,9523,9524,10373,10758,10760,10761,11682,11858,11921,12759,12896,12897,14271,210107,211965},
            [itemKeys.objectDrops] = {2849,2850,3715,111095},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211940] = {
            [itemKeys.name] = "Ecks'av's Tribal Guardian",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211941] = {
            [itemKeys.name] = "Windwalker's Yari",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211944] = {
            [itemKeys.name] = "Tojara's Karma",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211953] = {
            [itemKeys.name] = "Scroll of Arcane Recovery I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211954] = {
            [itemKeys.name] = "Scroll of Arcane Accuracy I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211955] = {
            [itemKeys.name] = "Scroll of Arcane Protection - Fire I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211956] = {
            [itemKeys.name] = "Scroll of Arcane Protection - Frost I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211957] = {
            [itemKeys.name] = "Scroll of Arcane Power I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [212160] = {
            [itemKeys.name] = "Chronoboon Displacer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,12784,12795,13476,14739,15175,16015},
            [itemKeys.startQuest] = nil,
        },
        [212225] = {
            [itemKeys.name] = "Neverending Soul Vessel",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [212230] = {
            [itemKeys.name] = "Schematic: Soul Vessel",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [212347] = {
            [itemKeys.name] = "Illari's Key",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {423569},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [212548] = {
            [itemKeys.name] = "Rune of Eclipse",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {212553},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [212549] = {
            [itemKeys.name] = "Rune of the Trapper",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {212553},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [212550] = {
            [itemKeys.name] = "Spell Notes: Frostfire Bolt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [212551] = {
            [itemKeys.name] = "Rune of Warfare",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {212553},
            [itemKeys.vendors] = {233335},
            [itemKeys.startQuest] = nil,
        },
        [212552] = {
            [itemKeys.name] = "Psychosophic Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {212553},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [212553] = {
            [itemKeys.name] = "Jewel-Encrusted Box",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [212559] = {
            [itemKeys.name] = "Rune of the Poisoned Blade",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {212553},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [212560] = {
            [itemKeys.name] = "Rune of Ancestral Awakening",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {212553},
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [212561] = {
            [itemKeys.name] = "Rune of Burning Darkness",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {212553},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [212562] = {
            [itemKeys.name] = "Rune of Healing Rage",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {212553},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [212568] = {
            [itemKeys.name] = "Wolfshead Trophy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [212580] = {
            [itemKeys.name] = "Lorekeeper's Staff",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {14753},
            [itemKeys.startQuest] = nil,
        },
        [212581] = {
            [itemKeys.name] = "Outrunner's Bow",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {14753},
            [itemKeys.startQuest] = nil,
        },
        [212582] = {
            [itemKeys.name] = "Protector's Sword",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {14753},
            [itemKeys.startQuest] = nil,
        },
        [212583] = {
            [itemKeys.name] = "Sentinel's Blade",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {14753},
            [itemKeys.startQuest] = nil,
        },
        [212584] = {
            [itemKeys.name] = "Advisor's Gnarled Staff",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {14754},
            [itemKeys.startQuest] = nil,
        },
        [212585] = {
            [itemKeys.name] = "Outrider's Bow",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {14754},
            [itemKeys.startQuest] = nil,
        },
        [212586] = {
            [itemKeys.name] = "Legionnaire's Sword",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {14754},
            [itemKeys.startQuest] = nil,
        },
        [212587] = {
            [itemKeys.name] = "Scout's Blade",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {14754},
            [itemKeys.startQuest] = nil,
        },
        [212588] = {
            [itemKeys.name] = "Provisioner's Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [212589] = {
            [itemKeys.name] = "Courier Treads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [212590] = {
            [itemKeys.name] = "Hoist Strap",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [212693] = {
            [itemKeys.name] = "Rotten Seed",
            [itemKeys.npcDrops] = {216310},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 79348,
        },
        [212723] = {
            [itemKeys.name] = "Rumbling Essence",
            [itemKeys.npcDrops] = {92,2735,2736},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [212724] = {
            [itemKeys.name] = "Whirling Essence",
            [itemKeys.npcDrops] = {11576,11577,11578},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [212726] = {
            [itemKeys.name] = "Rushing Essence",
            [itemKeys.npcDrops] = {4382,4385,4386,4387},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [212748] = {
            [itemKeys.name] = "Tattered Note",
            [itemKeys.npcDrops] = {4421,7873},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 79358,
        },
        [212792] = {
            [itemKeys.name] = "Eye of the Tempest",
            [itemKeys.npcDrops] = {216474},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [212982] = {
            [itemKeys.name] = "Squall-breakers Potion",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [212994] = {
            [itemKeys.name] = "Stormchaser's Bindings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [212996] = {
            [itemKeys.name] = "Lightningcaller's Bindings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [212997] = {
            [itemKeys.name] = "Tidecaller's Bindings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213036] = {
            [itemKeys.name] = "Water of Elune'ara",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213074] = {
            [itemKeys.name] = "Rune of Nourishing",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213086] = {
            [itemKeys.name] = "Rune of the Storm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [213087] = {
            [itemKeys.name] = "Sergeant's Cloak",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12805},
            [itemKeys.startQuest] = nil,
        },
        [213088] = {
            [itemKeys.name] = "Sergeant's Cloak",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12799},
            [itemKeys.startQuest] = nil,
        },
        [213092] = {
            [itemKeys.name] = "Rune of the Alpha",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {421568},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [213093] = {
            [itemKeys.name] = "Rune of Power",
            [itemKeys.npcDrops] = {217302},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [213094] = {
            [itemKeys.name] = "Rune of Fire Nova",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [213096] = {
            [itemKeys.name] = "Rune of Decoys",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [213098] = {
            [itemKeys.name] = "Rune of Invocation",
            [itemKeys.npcDrops] = {217605},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213100] = {
            [itemKeys.name] = "Rune of Forbidden Knowledge",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {217014},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213101] = {
            [itemKeys.name] = "Rune of Shadowflames",
            [itemKeys.npcDrops] = {217580},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213102] = {
            [itemKeys.name] = "Rune of Wickedness",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213103] = {
            [itemKeys.name] = "Rune of Blood Surge",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213104] = {
            [itemKeys.name] = "Rune of Ruthless Precision",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {217014},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213105] = {
            [itemKeys.name] = "Shawarmageddon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213109] = {
            [itemKeys.name] = "Rune of Focused Rage",
            [itemKeys.npcDrops] = {218032},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213110] = {
            [itemKeys.name] = "Rune of the Commander",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {424110},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213111] = {
            [itemKeys.name] = "Rune of Intervention",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {423920},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213112] = {
            [itemKeys.name] = "Spell Notes: Missile Barrage",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {217014},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213113] = {
            [itemKeys.name] = "Spell Notes: Hot Streak",
            [itemKeys.npcDrops] = {2760,217305},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213114] = {
            [itemKeys.name] = "Spell Notes: Spellfrost Bolt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213115] = {
            [itemKeys.name] = "Spell Notes: Spell Power",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213116] = {
            [itemKeys.name] = "Spell Notes: Chronostatic Preservation",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213117] = {
            [itemKeys.name] = "Rune of Berserk",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213118] = {
            [itemKeys.name] = "Rune of the Jungle King",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {217014},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213119] = {
            [itemKeys.name] = "Rune of Instinct",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213120] = {
            [itemKeys.name] = "Rune of the Dreamer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {404402},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213121] = {
            [itemKeys.name] = "Preserved Holly",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {213443},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213122] = {
            [itemKeys.name] = "Rune of Steady Shot",
            [itemKeys.npcDrops] = {217836},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213123] = {
            [itemKeys.name] = "Rune of Exposure",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213124] = {
            [itemKeys.name] = "Rune of Close Combat",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {217014},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213125] = {
            [itemKeys.name] = "Rune of Invigoration",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213126] = {
            [itemKeys.name] = "Rune of the Scrapper",
            [itemKeys.npcDrops] = {217783},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213127] = {
            [itemKeys.name] = "Spell Notes: PELFRB STOLLOTS",
            [itemKeys.npcDrops] = {780},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213128] = {
            [itemKeys.name] = "Rune of Piety",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335},
            [itemKeys.startQuest] = nil,
        },
        [213129] = {
            [itemKeys.name] = "Rune of Light's Embrace",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335},
            [itemKeys.startQuest] = nil,
        },
        [213130] = {
            [itemKeys.name] = "Rune of Infusions",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {217014},
            [itemKeys.vendors] = {233335},
            [itemKeys.startQuest] = nil,
        },
        [213131] = {
            [itemKeys.name] = "Rune of Sacred Shields",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335},
            [itemKeys.startQuest] = nil,
        },
        [213132] = {
            [itemKeys.name] = "Rune of the Guardian",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335},
            [itemKeys.startQuest] = nil,
        },
        [213136] = {
            [itemKeys.name] = "Rune of Subtlety",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {216618},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213137] = {
            [itemKeys.name] = "Rune of the Assailant",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {217014},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213138] = {
            [itemKeys.name] = "Rune of the Southpaw",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {215453},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213139] = {
            [itemKeys.name] = "Rune of the Assassin",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {428228},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213140] = {
            [itemKeys.name] = "Prophecy of the Quickened Path",
            [itemKeys.npcDrops] = {2252,2253,10758,10759,10760,10761},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213141] = {
            [itemKeys.name] = "Rune of Hope",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213142] = {
            [itemKeys.name] = "Prophecy of Imprisoned Malice",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {428144},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213143] = {
            [itemKeys.name] = "Apocryphal Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {424373},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213144] = {
            [itemKeys.name] = "Luminous Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {217014},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [213165] = {
            [itemKeys.name] = "Basilisks: Should Petrification be Feared?",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {421526},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213168] = {
            [itemKeys.name] = "Copper Blood Coin",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {216971},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213169] = {
            [itemKeys.name] = "Silver Blood Coin",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {216972},
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [213170] = {
            [itemKeys.name] = "Gold Blood Coin",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [213278] = {
            [itemKeys.name] = "Bonk-Maestro's Handguards",
            [itemKeys.npcDrops] = {215728},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213279] = {
            [itemKeys.name] = "Reflective Skullcap",
            [itemKeys.npcDrops] = {220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213280] = {
            [itemKeys.name] = "Marksman's Scopevisor",
            [itemKeys.npcDrops] = {218242},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213281] = {
            [itemKeys.name] = "Electromagnetic Hyperflux Reactivator",
            [itemKeys.npcDrops] = {218537},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213282] = {
            [itemKeys.name] = "Hypercharged Gear of Innovation",
            [itemKeys.npcDrops] = {218537},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213283] = {
            [itemKeys.name] = "Hypercharged Gear of Conflagration",
            [itemKeys.npcDrops] = {218537},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213284] = {
            [itemKeys.name] = "Hypercharged Gear of Devastation",
            [itemKeys.npcDrops] = {218537},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213285] = {
            [itemKeys.name] = "Lev's Oil-Stained Bindings",
            [itemKeys.npcDrops] = {220007},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213286] = {
            [itemKeys.name] = "Electrocutioner's Needle",
            [itemKeys.npcDrops] = {220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213287] = {
            [itemKeys.name] = "Electrocutioner Hexnut",
            [itemKeys.npcDrops] = {220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213288] = {
            [itemKeys.name] = "Grubbis Grubby Gauntlets",
            [itemKeys.npcDrops] = {217280},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213289] = {
            [itemKeys.name] = "Hydrostaff",
            [itemKeys.npcDrops] = {220007},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213290] = {
            [itemKeys.name] = "Acidic Waders",
            [itemKeys.npcDrops] = {220007},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213291] = {
            [itemKeys.name] = "Toxic Revenger II",
            [itemKeys.npcDrops] = {220007},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213292] = {
            [itemKeys.name] = "Gizmotron Gigachopper",
            [itemKeys.npcDrops] = {215728},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213293] = {
            [itemKeys.name] = "Hi-tech Supergun Mk.VII",
            [itemKeys.npcDrops] = {220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213294] = {
            [itemKeys.name] = "Caverndeep Sabatons",
            [itemKeys.npcDrops] = {217280},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213295] = {
            [itemKeys.name] = "Ultrasonic Vibroblade",
            [itemKeys.npcDrops] = {215728},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213296] = {
            [itemKeys.name] = "Supercharged Headchopper",
            [itemKeys.npcDrops] = {218242},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213297] = {
            [itemKeys.name] = "Oscillating Blasthammer",
            [itemKeys.npcDrops] = {218242},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213298] = {
            [itemKeys.name] = "Mechbuilder's Overalls",
            [itemKeys.npcDrops] = {220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213299] = {
            [itemKeys.name] = "Petrolspill Pants",
            [itemKeys.npcDrops] = {220007},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213300] = {
            [itemKeys.name] = "Fighter Ace Gloves",
            [itemKeys.npcDrops] = {220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213301] = {
            [itemKeys.name] = "Synthetic Mantle",
            [itemKeys.npcDrops] = {220007},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213302] = {
            [itemKeys.name] = "Mantle of the Cunning Negotiator",
            [itemKeys.npcDrops] = {220007},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213303] = {
            [itemKeys.name] = "Lightning Rod Spaulders",
            [itemKeys.npcDrops] = {218242},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213304] = {
            [itemKeys.name] = "Troggslayer Pauldrons",
            [itemKeys.npcDrops] = {217280},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213305] = {
            [itemKeys.name] = "Machined Alloy Shoulderplates",
            [itemKeys.npcDrops] = {215728},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213306] = {
            [itemKeys.name] = "Ingenuity's Cover",
            [itemKeys.npcDrops] = {218242},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213307] = {
            [itemKeys.name] = "Drape of Dismantling",
            [itemKeys.npcDrops] = {220007},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213308] = {
            [itemKeys.name] = "Prototype Parachute Cloak",
            [itemKeys.npcDrops] = {218242},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213309] = {
            [itemKeys.name] = "Cloak of Invention",
            [itemKeys.npcDrops] = {220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213310] = {
            [itemKeys.name] = "Hyperconductive Shimmershirt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213311] = {
            [itemKeys.name] = "Hyperconductive Robe",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213312] = {
            [itemKeys.name] = "Insulated Apron",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213313] = {
            [itemKeys.name] = "Insulated Chestguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213314] = {
            [itemKeys.name] = "Electromantic Chainmail",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213315] = {
            [itemKeys.name] = "Electromantic Chainshirt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213316] = {
            [itemKeys.name] = "H.A.Z.A.R.D. Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213317] = {
            [itemKeys.name] = "Experimental Aim Stabilizers",
            [itemKeys.npcDrops] = {215728},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213318] = {
            [itemKeys.name] = "Ornate Dark Iron Bangles",
            [itemKeys.npcDrops] = {218242},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213319] = {
            [itemKeys.name] = "Machinist's Gloves",
            [itemKeys.npcDrops] = {220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213320] = {
            [itemKeys.name] = "Fingers of Arcane Accuracy",
            [itemKeys.npcDrops] = {218242},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213321] = {
            [itemKeys.name] = "Volatile Concoction Belt",
            [itemKeys.npcDrops] = {217280},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213322] = {
            [itemKeys.name] = "Skullduggery Waistband",
            [itemKeys.npcDrops] = {217280},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213323] = {
            [itemKeys.name] = "Cord of Deep Earth",
            [itemKeys.npcDrops] = {217280},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213324] = {
            [itemKeys.name] = "Electromagnetic Waistcord",
            [itemKeys.npcDrops] = {217280},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213325] = {
            [itemKeys.name] = "Darkvision Girdle",
            [itemKeys.npcDrops] = {218242},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213326] = {
            [itemKeys.name] = "Girdle of Reclamation",
            [itemKeys.npcDrops] = {217280},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213327] = {
            [itemKeys.name] = "Belt of the Trogg Berserker",
            [itemKeys.npcDrops] = {217280},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213328] = {
            [itemKeys.name] = "Hyperconductive Pantaloons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213329] = {
            [itemKeys.name] = "Hyperconductive Skirt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213330] = {
            [itemKeys.name] = "H.A.Z.A.R.D. Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213331] = {
            [itemKeys.name] = "Insulated Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213332] = {
            [itemKeys.name] = "Insulated Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213333] = {
            [itemKeys.name] = "Electromantic Chausses",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213334] = {
            [itemKeys.name] = "Electromantic Gambeson",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213335] = {
            [itemKeys.name] = "H.A.Z.A.R.D. Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213336] = {
            [itemKeys.name] = "Hyperconductive Walkers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213337] = {
            [itemKeys.name] = "Hyperconductive Sandals",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213338] = {
            [itemKeys.name] = "Electromantic Grounding Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213339] = {
            [itemKeys.name] = "Electromantic Grounding Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213340] = {
            [itemKeys.name] = "Gnomebot Operators Boots",
            [itemKeys.npcDrops] = {215728},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213341] = {
            [itemKeys.name] = "Insulated Workboots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213342] = {
            [itemKeys.name] = "Insulated Galoshes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [213343] = {
            [itemKeys.name] = "Justice Badge",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213344] = {
            [itemKeys.name] = "Gnomeregan Peace Officer's Torque",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213345] = {
            [itemKeys.name] = "Piston Pendant",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213346] = {
            [itemKeys.name] = "Pendant of Homecoming",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213347] = {
            [itemKeys.name] = "Miniaturized Combustion Chamber",
            [itemKeys.npcDrops] = {218537},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213348] = {
            [itemKeys.name] = "Gyromatic Experiment 420b",
            [itemKeys.npcDrops] = {218537},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213349] = {
            [itemKeys.name] = "Gniodine Pill Bottle",
            [itemKeys.npcDrops] = {218537},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213350] = {
            [itemKeys.name] = "Wirdal's Hardened Core",
            [itemKeys.npcDrops] = {218537},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213351] = {
            [itemKeys.name] = "Irradiated Tower Shield",
            [itemKeys.npcDrops] = {217280},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213352] = {
            [itemKeys.name] = "Gear-Mender's Grace",
            [itemKeys.npcDrops] = {220007},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213353] = {
            [itemKeys.name] = "Defibrillating Staff",
            [itemKeys.npcDrops] = {220007},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213354] = {
            [itemKeys.name] = "Staff of the Evil Genius",
            [itemKeys.npcDrops] = {220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213355] = {
            [itemKeys.name] = "Falco's Sting",
            [itemKeys.npcDrops] = {220007},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213356] = {
            [itemKeys.name] = "Thermaplugg's Custom Blaster",
            [itemKeys.npcDrops] = {218537},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213369] = {
            [itemKeys.name] = "Faintly Glowing Leather",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213370] = {
            [itemKeys.name] = "Irradiated Leather Scraps",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {213641},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213371] = {
            [itemKeys.name] = "Crate of Tainted Gniodine Solution",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {213641},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213372] = {
            [itemKeys.name] = "Insulating Gniodine",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213373] = {
            [itemKeys.name] = "Reflective Scrapmetal",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {213641},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213376] = {
            [itemKeys.name] = "Low-Background Truesilver Plates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213378] = {
            [itemKeys.name] = "Unstable Microfilament",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {213641},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213379] = {
            [itemKeys.name] = "Hyperconductive Arcano-Filament",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213381] = {
            [itemKeys.name] = "Pile of Tarnished Gears",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {213641},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213383] = {
            [itemKeys.name] = "Polished Truesilver Gears",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213390] = {
            [itemKeys.name] = "Whirling Truesilver Gearwall",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213391] = {
            [itemKeys.name] = "UNUSED Electrified Mithril Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213407] = {
            [itemKeys.name] = "Catnip",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [213408] = {
            [itemKeys.name] = "Gyromatic Macro-Adjustor",
            [itemKeys.npcDrops] = {215728},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213409] = {
            [itemKeys.name] = "Mekkatorque's Arcano-Shredder",
            [itemKeys.npcDrops] = {218537},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213410] = {
            [itemKeys.name] = "Glimmering Gizmoblade",
            [itemKeys.npcDrops] = {218242},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213411] = {
            [itemKeys.name] = "Izzleflick's Inextinguishable Igniter",
            [itemKeys.npcDrops] = {218242},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213412] = {
            [itemKeys.name] = "Dielectric Safety Shield",
            [itemKeys.npcDrops] = {215728},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213413] = {
            [itemKeys.name] = "Generously Padded Shoulderpads",
            [itemKeys.npcDrops] = {220007},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213414] = {
            [itemKeys.name] = "Mech-Mender's Sash",
            [itemKeys.npcDrops] = {220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213415] = {
            [itemKeys.name] = "Tinker's Wrist Wraps",
            [itemKeys.npcDrops] = {215728},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213416] = {
            [itemKeys.name] = "Thermaplugg's Rocket Cleaver",
            [itemKeys.npcDrops] = {218537},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213417] = {
            [itemKeys.name] = "Truesilver Filament Coif",
            [itemKeys.npcDrops] = {218242},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213418] = {
            [itemKeys.name] = "Welded Truesilver Ringlets",
            [itemKeys.npcDrops] = {220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213419] = {
            [itemKeys.name] = "9-60 Repair Manual",
            [itemKeys.npcDrops] = {215728},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213421] = {
            [itemKeys.name] = "Singed Note",
            [itemKeys.npcDrops] = {2318,2319},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213422] = {
            [itemKeys.name] = "Illegible Recipe",
            [itemKeys.npcDrops] = {2254,2255,2256,2287,2569,2570,2571},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 79624,
        },
        [213426] = {
            [itemKeys.name] = "Ogre Lightning Rod",
            [itemKeys.npcDrops] = {2562,2564,2566},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213427] = {
            [itemKeys.name] = "Grime-Encrusted Salvage",
            [itemKeys.npcDrops] = {6206,6207,6211,6220,6226,6227,6228,6230,6232,6233,6234,6329,215728,216668,217280,218242,218243,218244,218245,218537,220007,220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213442] = {
            [itemKeys.name] = "Cogmaster's Claw",
            [itemKeys.npcDrops] = {215728},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213443] = {
            [itemKeys.name] = "Ticking Present",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213444] = {
            [itemKeys.name] = "Tarnished Prayer Bead I",
            [itemKeys.npcDrops] = {2552,2553,2554,2555,2556,2557,2562,2564,2566,2567,2569,2572,2573,2574,2575,2577,2586,2587,2588,2589,2590,2595,2618,2619,4062},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213445] = {
            [itemKeys.name] = "Tarnished Prayer Bead II",
            [itemKeys.npcDrops] = {2552,2553,2554,2555,2556,2557,2562,2564,2566,2567,2569,2572,2573,2574,2575,2577,2586,2587,2588,2589,2590,2591,2595,2618,2619,4062},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213446] = {
            [itemKeys.name] = "Tarnished Prayer Bead III",
            [itemKeys.npcDrops] = {2552,2553,2554,2555,2556,2557,2562,2564,2566,2567,2569,2572,2573,2574,2575,2577,2586,2587,2588,2589,2590,2595,2618,2619,4062},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213447] = {
            [itemKeys.name] = "Rosary of the Light",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213448] = {
            [itemKeys.name] = "Divine Prayer Bead I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213449] = {
            [itemKeys.name] = "Divine Prayer Bead II",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213450] = {
            [itemKeys.name] = "Divine Prayer Bead III",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213451] = {
            [itemKeys.name] = "Corrupted Fire Totem",
            [itemKeys.npcDrops] = {217392},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213452] = {
            [itemKeys.name] = "Dormant Holy Rune",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {423841},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213513] = {
            [itemKeys.name] = "Libram of Deliverance",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {423695},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213526] = {
            [itemKeys.name] = "Hybrid Haunch",
            [itemKeys.npcDrops] = {2347,2473,2474},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213527] = {
            [itemKeys.name] = "Smuggler's Spice Blend",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {422911},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213528] = {
            [itemKeys.name] = "Balmy Brew",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {422919},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213529] = {
            [itemKeys.name] = "Viscous Venom",
            [itemKeys.npcDrops] = {769},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213542] = {
            [itemKeys.name] = "The Necro-Gnomicon",
            [itemKeys.npcDrops] = {217280},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213543] = {
            [itemKeys.name] = "Scroll: UPDOG",
            [itemKeys.npcDrops] = {205,533,667,696,703,741,752,760,762,766,767,780,787,909,910,920,938,939,940,948,1038,1062,1094,1108,1158,1353,1487,1491,1563,1653,1663,1666,1754,1787,1795,1804,1808,1812,1817,1824,1833,2240,2241,2243,2249,2250,2271,2337,2369,2371,2431,2521,2536,2554,2556,2581,2582,2619,2640,2692,2693,2731,2735,2740,2830,2893,2927,2944,3414,3755,3757,3770,3799,3801,3804,3808,3811,3833,3941,4017,4029,4041,4095,4133,4154,4329,4358,4360,4362,4377,4467,4481,4505,4506,4634,4646,4666,4677,4711,4969,5057,5236,5240,5251,5297,5308,5336,5366,5427,5471,5473,5622,5771,5839,6010,6011,6069,6135,6136,6138,6193,6196,6198,6348,6507,7034,7037,7092,7097,7138,7139,7154,7346,7369,7379,7442,7450,7727,7803,7858,8522,8525,8526,8539,8543,8546,8561,8563,8896,8913,8957,9462,9683,9684,9691,9697,9698,10221,10442,10480,10485,10660,10882,11290,11291,11686,11883,12248,14123,14188,14400,14458,216665,217711,221169,221260,221262,221263,221326,221365,221369,221371,223542,224243},
            [itemKeys.objectDrops] = {2852,2855,2857,4096,4149,105578,105579,105581,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213544] = {
            [itemKeys.name] = "Scroll: TOPAZ YORAK",
            [itemKeys.npcDrops] = {205,315,503,511,533,570,588,667,670,671,681,690,730,745,747,780,898,920,937,939,941,949,979,1057,1094,1110,1270,1490,1787,1789,1802,1804,1806,1812,1831,1884,2241,2247,2249,2252,2253,2270,2304,2305,2318,2371,2408,2474,2545,2552,2555,2556,2557,2562,2581,2582,2586,2587,2618,2619,2640,2651,2654,2693,2694,2720,2723,2733,2739,2760,2831,2927,2945,3801,3806,4095,4097,4107,4120,4144,4147,4154,4308,4328,4331,4378,4398,4401,4404,4412,4458,4493,4646,4654,4665,4672,4684,4697,5057,5234,5236,5239,5254,5288,5293,5299,5306,5428,5452,5466,5472,5474,5485,5602,5840,5979,6005,6006,6116,6117,6137,6188,6195,6196,6200,6201,6218,6372,6375,6507,6509,6517,6520,6648,7025,7033,7036,7038,7049,7086,7098,7112,7369,7452,7453,7455,7457,7805,7855,7856,7858,8337,8527,8528,8562,8563,8837,8900,8913,8916,8920,8922,9396,9462,9697,10316,10580,10605,10659,10660,10896,10919,11291,11516,11559,11611,11789,12216,12250,14400,217711,221170,221261,221324,224244,228612},
            [itemKeys.objectDrops] = {2852,2855,2857,4096,4149,105578,105579,105581,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213545] = {
            [itemKeys.name] = "Scroll: PEATCHY ATTAX",
            [itemKeys.npcDrops] = {205,206,212,315,397,511,595,669,675,694,747,750,755,765,780,898,920,978,1038,1044,1142,1150,1251,1565,1653,1785,1787,1795,1804,1812,1816,1831,1883,1884,1907,2240,2246,2247,2248,2348,2358,2374,2452,2546,2554,2556,2557,2560,2564,2567,2573,2586,2649,2650,2659,2692,2693,2721,2732,2764,2927,3378,3759,3763,3784,3919,4041,4097,4111,4139,4142,4329,4331,4334,4343,4361,4362,4386,4399,4411,4466,4474,4641,4643,4652,4660,4663,4666,4685,4690,4711,5046,5229,5232,5236,5238,5239,5240,5251,5255,5258,5278,5293,5296,5297,5305,5307,5364,5423,5441,5475,5643,5840,5850,6010,6116,6125,6127,6135,6137,6138,6198,6199,6224,6370,7026,7031,7033,7038,7039,7049,7115,7155,7333,7376,7379,7460,7523,7668,7727,7803,7848,7857,7858,7864,8524,8527,8530,8543,8555,8560,8606,8637,8916,8920,9416,9696,10411,10442,10481,10648,10660,11291,11476,11611,11740,12380,12977,13160,14123,14283,14458,217703,218249,221170,221230,221263,221330,221356,221371,221375,221740,222580,224243,229802},
            [itemKeys.objectDrops] = {2852,2855,2857,4096,4149,105578,105579,105581,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213546] = {
            [itemKeys.name] = "Scroll: SHOOBEEDOOP",
            [itemKeys.npcDrops] = {206,210,533,674,743,744,747,750,759,762,775,780,782,898,920,940,941,942,1081,1084,1095,1157,1488,1663,1666,1754,1785,1795,1804,1835,2240,2248,2249,2271,2272,2319,2337,2404,2503,2535,2544,2550,2554,2556,2562,2573,2595,2618,2640,2686,2692,2693,2721,2735,2739,2740,2742,2793,2928,3414,3799,3942,4027,4038,4062,4095,4112,4119,4140,4143,4147,4328,4351,4359,4360,4361,4362,4378,4382,4385,4402,4457,4467,4472,4479,4541,4654,4662,4671,4679,4692,4695,5232,5236,5237,5238,5239,5246,5255,5274,5278,5295,5336,5363,5364,5422,5428,5450,5473,5474,5477,5485,5601,5616,5617,5618,5840,6010,6011,6135,6137,6138,6170,6184,6194,6196,6198,6199,6517,6520,6551,6556,7035,7038,7048,7086,7109,7118,7268,7344,7346,7371,7376,7396,7397,7432,7442,7444,7460,7524,7902,8504,8521,8523,8532,8542,8557,8560,8578,9454,9462,9545,9547,10040,10316,10411,10442,10485,10617,10660,10916,11291,11476,11598,11783,11873,12046,12217,12250,14455,14460,14661,217669,221176,221260,221326,221369,222702,224257},
            [itemKeys.objectDrops] = {2852,2855,2857,4096,4149,105578,105579,105581,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213547] = {
            [itemKeys.name] = "Scroll: THAW WORDS",
            [itemKeys.npcDrops] = {205,315,533,604,703,747,750,751,761,762,764,775,782,785,856,920,938,977,1035,1110,1142,1144,1152,1487,1653,1808,2240,2241,2242,2269,2271,2272,2337,2359,2369,2374,2375,2377,2408,2450,2552,2556,2557,2563,2589,2618,2619,2651,2723,2728,2730,2732,2735,2736,2739,2743,2945,3757,3763,3799,3802,4027,4097,4099,4142,4308,4352,4362,4376,4392,4397,4405,4411,4461,4466,4504,4505,4506,4644,4665,4667,4676,4678,4716,5045,5234,5236,5237,5238,5246,5253,5254,5297,5299,5331,5332,5359,5364,5420,5421,5425,5427,5456,5471,5616,5771,5839,5850,5933,5998,6004,6007,6068,6135,6136,6138,6194,6201,6521,6527,6559,6575,7011,7025,7026,7033,7035,7047,7091,7153,7370,7379,7396,7405,7442,7448,7449,7725,7808,8337,8524,8530,8532,8534,8535,8540,8551,8561,8562,8596,8763,8897,8902,8913,8916,8959,9164,9454,9477,9545,9622,10316,10481,10896,11562,11680,11681,11682,12179,12378,13276,14460,216667,217669,217703,221176,221223,221260,221261,221263,221369,221377,223542,223543,224243,228726},
            [itemKeys.objectDrops] = {2852,2855,2857,4096,4149,105570,105578,105579,105581,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213548] = {
            [itemKeys.name] = "Scroll of Liminal Passage",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213549] = {
            [itemKeys.name] = "Scroll of Arcane Angling",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213550] = {
            [itemKeys.name] = "Scroll of Polymorph: Odd Melon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213551] = {
            [itemKeys.name] = "Scroll of Controlled Displacement",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213552] = {
            [itemKeys.name] = "Tear of Theradras",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213553] = {
            [itemKeys.name] = "Tear of Theradras",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {422896},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213554] = {
            [itemKeys.name] = "Vial of Crystal Water",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {422902},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213558] = {
            [itemKeys.name] = "Elemental Salve",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213559] = {
            [itemKeys.name] = "Mechanostrider Gear Shifter",
            [itemKeys.npcDrops] = {220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213560] = {
            [itemKeys.name] = "Mechanostrider Muffler",
            [itemKeys.npcDrops] = {220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213562] = {
            [itemKeys.name] = "Bug Catching Net",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {213565},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213563] = {
            [itemKeys.name] = "Field Guide",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {213565},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213564] = {
            [itemKeys.name] = "Scroll of Minor Evocation",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213565] = {
            [itemKeys.name] = "Entomology Starter Kit",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217412},
            [itemKeys.startQuest] = nil,
        },
        [213566] = {
            [itemKeys.name] = "Arbor Tarantula Specimen",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213567] = {
            [itemKeys.name] = "Flesh Picker Specimen",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213568] = {
            [itemKeys.name] = "Hay Weevil Specimen",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213572] = {
            [itemKeys.name] = "Soul of the Void",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213573] = {
            [itemKeys.name] = "Conjuror's Pendant",
            [itemKeys.npcDrops] = {2590},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213574] = {
            [itemKeys.name] = "Desiccated Seed Pod",
            [itemKeys.npcDrops] = {4632,4633,4634,4635,4636,4637,12976,12977},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213583] = {
            [itemKeys.name] = "Brimstone Carving",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213594] = {
            [itemKeys.name] = "Idol of the Heckler",
            [itemKeys.npcDrops] = {217418},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213599] = {
            [itemKeys.name] = "Unsettling Vision",
            [itemKeys.npcDrops] = {4711,4712,4713,4714,4715,4716,4718,4719,218249},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213632] = {
            [itemKeys.name] = "Partial Spell Notes",
            [itemKeys.npcDrops] = {217669},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213633] = {
            [itemKeys.name] = "Partial Spell Notes",
            [itemKeys.npcDrops] = {217703},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213634] = {
            [itemKeys.name] = "Partial Spell Notes",
            [itemKeys.npcDrops] = {217711},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213641] = {
            [itemKeys.name] = "Box of Gnomeregan Salvage",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213701] = {
            [itemKeys.name] = "Strong Harpy Feather",
            [itemKeys.npcDrops] = {4100,4101,4104,4490},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213709] = {
            [itemKeys.name] = "Cloud Serpent Fang",
            [itemKeys.npcDrops] = {4117,4118,4119},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213735] = {
            [itemKeys.name] = "Pristine G-7 C.O.R.E. Processor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213736] = {
            [itemKeys.name] = "Corroded G-7 C.O.R.E. Processor",
            [itemKeys.npcDrops] = {216666},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 79981,
        },
        [213737] = {
            [itemKeys.name] = "Offering to the Wind Spirit",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [214435] = {
            [itemKeys.name] = "Cougar Cage Key",
            [itemKeys.npcDrops] = {4095,4097,4099},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215111] = {
            [itemKeys.name] = "Gneuro-Linked Arcano-Filament Monocle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215112] = {
            [itemKeys.name] = "UNUSED - Cloak of Arcane Insulation",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215113] = {
            [itemKeys.name] = "UNUSED - Razor-Lined Shoulderpads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215114] = {
            [itemKeys.name] = "Glowing Hyperconductive Scale Coif",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215115] = {
            [itemKeys.name] = "Hyperconductive Goldwrap",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215116] = {
            [itemKeys.name] = "UNUSED - Hyperconductive Speed Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215126] = {
            [itemKeys.name] = "UNUSED Flask of Merciless Pursuit",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215127] = {
            [itemKeys.name] = "High-Yield Radiation Bomb",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215129] = {
            [itemKeys.name] = "Formula: Enchant Weapon - Dismantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215138] = {
            [itemKeys.name] = "Formula: Enchant Chest - Retricutioner",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215141] = {
            [itemKeys.name] = "Enchanted Sigil: Innovation",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215149] = {
            [itemKeys.name] = "Pattern: Gneuro-Linked Arcano-Filament Monocle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215152] = {
            [itemKeys.name] = "Pattern: Glowing Gneuro-Linked Cowl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215153] = {
            [itemKeys.name] = "Schematic: Whirling Truesilver Gearwall",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215155] = {
            [itemKeys.name] = "Plans: Temepered Interference-Negating Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215156] = {
            [itemKeys.name] = "Schematic: Hyperconductive Goldwrap",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215161] = {
            [itemKeys.name] = "Tempered Interference-Negating Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215162] = {
            [itemKeys.name] = "Mildly Irradiated Rejuvenation Potion",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215163] = {
            [itemKeys.name] = "Recipe: Mildly-Irradiated Rejuvenation Potion",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215166] = {
            [itemKeys.name] = "Glowing Gneuro-Linked Cowl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215167] = {
            [itemKeys.name] = "Reflective Truesilver Braincage",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215168] = {
            [itemKeys.name] = "Ez-Thro Radiation Bomb",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215235] = {
            [itemKeys.name] = "2hander Animation as 1hander test copy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215257] = {
            [itemKeys.name] = "Scroll of Comprehension",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215367] = {
            [itemKeys.name] = "Pattern: Faintly Glowing Leather",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215368] = {
            [itemKeys.name] = "Pattern: Hyperconductive Arcano-Filament",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215369] = {
            [itemKeys.name] = "Pattern: Invoker's Cord",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {3364,4168},
            [itemKeys.startQuest] = nil,
        },
        [215370] = {
            [itemKeys.name] = "Pattern: Invoker's Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {3364,4168},
            [itemKeys.startQuest] = nil,
        },
        [215371] = {
            [itemKeys.name] = "Jani's Charm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {216618},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215373] = {
            [itemKeys.name] = "Silver Hand Training Hammer",
            [itemKeys.npcDrops] = {4280,4281,4283,4284,4285,4286,4287,4288,4289,4290,4291,4292,4293,4294,4295,4296,4297,4298,4299,4300,4301,4302,4303,4306,4540},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215374] = {
            [itemKeys.name] = "Ancestral Sword",
            [itemKeys.npcDrops] = {4280,4281,4282,4283,4284,4285,4286,4287,4288,4289,4290,4291,4292,4293,4294,4295,4296,4297,4298,4299,4300,4301,4302,4303,4306,4540},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215375] = {
            [itemKeys.name] = "Tactician's Staff",
            [itemKeys.npcDrops] = {4281,4283,4284,4285,4286,4287,4288,4289,4290,4291,4292,4293,4294,4295,4296,4297,4298,4299,4300,4301,4302,4303,4306,4540},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215376] = {
            [itemKeys.name] = "Crusader's Mace",
            [itemKeys.npcDrops] = {4280,4281,4283,4285,4286,4287,4288,4289,4290,4291,4292,4293,4294,4295,4296,4297,4298,4299,4300,4301,4302,4303,4306,4540},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215377] = {
            [itemKeys.name] = "Irradiated Robe",
            [itemKeys.npcDrops] = {218242,218537,220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215378] = {
            [itemKeys.name] = "Irradiated Boots",
            [itemKeys.npcDrops] = {218242,218537,220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215379] = {
            [itemKeys.name] = "Irradiated Trousers",
            [itemKeys.npcDrops] = {218242,218537,220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215380] = {
            [itemKeys.name] = "Power-Assisted Lifting Belt",
            [itemKeys.npcDrops] = {218242},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215381] = {
            [itemKeys.name] = "Gneuro-Conductive Channeler's Hood",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215382] = {
            [itemKeys.name] = "Rad-Resistant Scale Hood",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215383] = {
            [itemKeys.name] = "Plans: Reflective Truesilver Braincage",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215384] = {
            [itemKeys.name] = "Plans: Low-Background Truesilver Plates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215385] = {
            [itemKeys.name] = "Waylaid Supplies: Gold Bars",
            [itemKeys.npcDrops] = {92,587,588,595,597,682,685,688,691,696,697,699,701,740,747,755,757,764,765,782,783,858,905,920,937,938,941,942,943,1062,1082,1096,1097,1144,1151,1562,2240,2241,2242,2245,2246,2248,2249,2250,2251,2252,2253,2271,2272,2319,2358,2359,2369,2371,2377,2406,2408,2411,2545,2554,2555,2556,2562,2564,2566,2572,2575,2580,2581,2582,2586,2589,2618,2619,2628,2716,2728,2739,2743,4110,4130,4133,4140,4150,4151,4154,4308,4329,4343,4351,4357,4359,4360,4361,4396,4399,4411,4413,4415,4479,4481,4490,4633,4634,4635,4636,4637,4638,4640,4641,4642,4644,4648,4664,4666,4670,4672,4673,4674,4675,4679,4696,4697,4701,4702,4711,4712,4713,4714,4715,4719,4726,4728,4729,4834,5229,5232,5238,5253,5300,5334,5335,5616,6218,6222,6224,7078,7175,7333,7344,7346,7603,7725,11561,11562,11563,11686,12347,12976,217305},
            [itemKeys.objectDrops] = {2855,105578,105579},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215386] = {
            [itemKeys.name] = "Waylaid Supplies: Mithril Bars",
            [itemKeys.npcDrops] = {92,587,588,595,597,685,694,696,697,699,701,702,728,736,740,741,747,750,767,775,780,905,920,921,937,938,940,941,977,1082,1084,1094,1095,1097,1108,1142,1150,2240,2241,2242,2249,2250,2251,2252,2304,2306,2318,2319,2369,2371,2377,2440,2554,2555,2556,2557,2559,2560,2562,2563,2564,2565,2572,2575,2577,2586,2589,2619,2628,2651,2657,2721,2727,2742,2761,2764,2894,2906,2929,2932,4062,4130,4133,4139,4140,4142,4143,4144,4150,4151,4154,4308,4329,4331,4351,4359,4376,4382,4385,4387,4396,4402,4405,4461,4619,4633,4636,4638,4639,4642,4643,4646,4647,4648,4651,4653,4654,4662,4664,4665,4666,4667,4670,4672,4673,4675,4689,4700,4712,4713,4715,4718,4723,4834,5240,5600,5844,6170,6218,6224,7011,7078,7175,7603,7848,11562,11576,12976,12977,13019,216667,218249,221283},
            [itemKeys.objectDrops] = {2855,105578,105579},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215387] = {
            [itemKeys.name] = "Waylaid Supplies: Heavy Hide",
            [itemKeys.npcDrops] = {205,206,210,212,300,533,587,604,681,694,697,736,740,755,785,787,889,898,909,910,920,941,1023,1035,1044,1110,1157,1160,1251,1270,1418,1421,1666,2089,2241,2248,2251,2269,2356,2358,2370,2373,2374,2375,2377,2404,2408,2448,2552,2554,2559,2562,2714,2727,2739,3378,3696,3752,3754,3755,3757,3758,3763,3765,3767,3770,3771,3782,3789,3801,3802,3808,3810,3818,3834,3919,3941,4027,4028,4029,4038,4041,4062,4093,4095,4097,4099,4100,4104,4110,4111,4114,4116,4119,4126,4142,4147,4248,4249,4273,4308,4382,4461,4541,4663,4665,4674,4696,4697,4712,6073,6115,6575,10617,10756,10757,10758,10759,10760,10761,10882,10896,11562,11578,12918,12977,13019,221168,221170,221171,221172,221176,221223},
            [itemKeys.objectDrops] = {2852,4096},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215388] = {
            [itemKeys.name] = "Waylaid Supplies: Thick Leather",
            [itemKeys.npcDrops] = {522,587,588,595,667,671,672,675,682,686,689,694,696,697,699,701,702,729,736,740,750,757,760,762,764,858,937,938,940,941,942,977,978,979,1085,1094,1151,1152,1491,1558,1754,2240,2241,2242,2248,2249,2250,2251,2252,2271,2272,2319,2359,2371,2376,2377,2407,2408,2544,2553,2554,2555,2556,2557,2560,2562,2563,2564,2573,2577,2579,2581,2582,2587,2589,2595,2618,2628,2701,2723,2739,2742,2743,2831,2906,3941,4062,4110,4131,4133,4142,4147,4150,4154,4308,4323,4324,4334,4359,4387,4398,4412,4413,4479,4480,4490,4619,4632,4634,4635,4637,4638,4639,4640,4641,4644,4645,4647,4651,4653,4656,4659,4664,4665,4666,4668,4670,4673,4674,4675,4676,4677,4684,4692,4696,4712,4714,4729,5234,5334,5422,6170,6218,6219,6224,7078,7175,7333,7397,7603,11562,12347,12977,13019,217305,217392,217836,218249,221283},
            [itemKeys.objectDrops] = {2855,105578,105579},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215389] = {
            [itemKeys.name] = "Waylaid Supplies: Fadeleaf",
            [itemKeys.npcDrops] = {205,206,212,300,315,397,533,570,588,595,604,683,740,755,785,787,891,898,909,910,920,948,1034,1035,1036,1038,1044,1057,1069,1094,1110,1150,1157,1158,1270,1418,1663,1666,1720,1755,2240,2248,2249,2250,2268,2269,2356,2371,2372,2373,2374,2385,2404,2413,2448,2503,2552,2553,2554,2562,2563,2564,2582,2586,2721,3696,3752,3758,3759,3762,3765,3771,3782,3789,3797,3801,3803,3804,3806,3808,3818,3821,3932,3940,4023,4027,4029,4030,4038,4041,4062,4093,4095,4097,4099,4100,4101,4104,4107,4109,4113,4114,4119,4120,4124,4147,4249,4541,4633,4643,4664,4666,4667,4670,4671,4719,4834,4969,6073,6575,10756,10759,10760,10761,10992,11680,11681,11682,11697,12977,221169,221170,221171,221172,221176,221223},
            [itemKeys.objectDrops] = {2852,4096},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215390] = {
            [itemKeys.name] = "Waylaid Supplies: Khadgar's Whisker",
            [itemKeys.npcDrops] = {92,522,587,588,595,671,681,685,688,694,697,699,702,736,740,741,744,755,764,765,775,905,920,921,937,938,940,941,943,978,1061,1094,1096,1108,1144,1150,1487,1558,1564,2240,2241,2248,2249,2250,2251,2252,2253,2271,2318,2358,2369,2371,2376,2377,2406,2407,2408,2411,2413,2440,2544,2554,2555,2556,2557,2562,2564,2566,2573,2581,2582,2587,2589,2618,2628,2720,2728,2729,2739,2740,2743,2761,2893,2906,2927,3660,4131,4142,4143,4150,4308,4328,4331,4351,4352,4359,4361,4376,4378,4392,4458,4460,4505,4619,4634,4635,4636,4637,4638,4639,4640,4641,4642,4644,4645,4648,4651,4665,4666,4671,4672,4675,4678,4686,4711,4712,4714,4715,4719,5251,5286,5426,6068,6218,6224,7078,7175,7333,7344,7346,7603,7725,9377,11559,11561,11562,11563,11576,11937,12977},
            [itemKeys.objectDrops] = {2855,105578,105579},
            [itemKeys.itemDrops] = {223149},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215391] = {
            [itemKeys.name] = "Waylaid Supplies: Wintersbite",
            [itemKeys.npcDrops] = {205,206,212,397,429,511,522,533,587,588,604,694,740,755,775,785,787,891,892,898,909,910,920,940,948,949,1013,1018,1019,1023,1034,1036,1038,1044,1069,1085,1110,1157,1270,1353,1418,1663,2248,2249,2250,2269,2305,2319,2335,2337,2356,2370,2373,2374,2375,2387,2404,2448,2559,2572,2586,2618,2619,2714,3378,3752,3754,3755,3757,3762,3763,3767,3784,3791,3797,3801,3802,3803,3804,3806,3807,3821,3919,3932,3941,4027,4028,4029,4041,4093,4095,4097,4099,4100,4104,4107,4109,4110,4111,4114,4116,4117,4119,4126,4130,4139,4158,4202,4249,4359,4458,4541,4635,4639,4640,4643,4646,4663,4672,4674,4689,4718,4969,6115,6575,7175,10617,10757,10758,10759,10761,10992,12347,12976,217703,217711,217836,218249,221169,221170,221171,221172,221176,221223},
            [itemKeys.objectDrops] = {2852,4096},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215392] = {
            [itemKeys.name] = "Waylaid Supplies: Purple Lotus",
            [itemKeys.npcDrops] = {588,595,667,677,682,685,686,689,690,694,697,701,702,728,736,740,757,759,760,761,762,920,921,937,938,941,943,976,977,1061,1097,1108,1144,2240,2241,2246,2248,2249,2250,2251,2318,2319,2358,2371,2376,2377,2407,2408,2413,2552,2554,2555,2556,2562,2563,2564,2565,2566,2567,2579,2581,2582,2587,2589,2592,2596,2618,2619,2654,2701,2716,2717,2723,2727,2739,2740,2742,2743,2906,4110,4140,4144,4147,4150,4154,4158,4308,4355,4361,4362,4385,4397,4413,4461,4481,4634,4635,4637,4639,4640,4641,4642,4644,4645,4647,4649,4652,4654,4655,4664,4665,4666,4667,4670,4671,4672,4674,4676,4677,4685,4693,4697,4711,4713,4718,4719,4727,4729,4834,5234,5255,5278,5295,5643,6218,6219,6222,7078,7175,7333,7344,7603,7725,11562,11563,12976,12977,14233,14661,218249,221282,221283},
            [itemKeys.objectDrops] = {2855,105578},
            [itemKeys.itemDrops] = {223149},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215393] = {
            [itemKeys.name] = "Waylaid Supplies: Greater Healing Potions",
            [itemKeys.npcDrops] = {92,588,595,597,667,681,682,683,685,690,694,697,699,701,702,736,740,741,742,745,757,759,766,775,854,856,858,861,905,920,922,938,939,940,941,942,943,1085,1094,1096,1097,1144,1152,1487,2240,2241,2242,2243,2248,2249,2250,2251,2252,2271,2318,2319,2359,2371,2377,2408,2414,2552,2553,2554,2556,2557,2559,2562,2563,2564,2566,2567,2573,2574,2575,2579,2581,2586,2589,2618,2619,2716,2721,2723,2742,2906,2907,2926,4131,4139,4140,4142,4143,4144,4147,4150,4154,4158,4308,4328,4331,4344,4351,4355,4358,4376,4412,4413,4461,4481,4635,4638,4639,4640,4641,4642,4645,4646,4655,4665,4666,4667,4670,4673,4675,4700,4712,4713,4715,4719,4726,4834,5251,5292,5293,5337,6218,6224,7011,7175,7333,7346,7603,11686,12676,12976,217305,221282,221292},
            [itemKeys.objectDrops] = {2855,105578,105579},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215394] = {
            [itemKeys.name] = "Waylaid Supplies: Lesser Stoneshield Potions",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215395] = {
            [itemKeys.name] = "Waylaid Supplies: Elixirs of Agility",
            [itemKeys.npcDrops] = {522,587,588,597,676,682,685,688,690,697,699,701,702,729,730,736,740,741,743,750,757,855,920,921,922,937,938,939,940,976,978,979,1094,1096,1097,1151,1152,1421,1490,2240,2248,2249,2250,2251,2252,2272,2304,2318,2319,2358,2369,2371,2376,2377,2406,2407,2412,2554,2556,2557,2562,2563,2564,2567,2572,2575,2581,2582,2589,2618,2619,2635,2723,2740,2743,2762,2829,2831,4131,4133,4139,4140,4144,4151,4308,4344,4358,4376,4385,4388,4391,4411,4457,4461,4504,4619,4633,4634,4635,4636,4637,4638,4640,4641,4642,4644,4647,4649,4656,4657,4663,4665,4666,4667,4670,4673,4675,4679,4689,4700,4712,4714,4715,4718,4719,4726,4729,4834,5184,5238,5240,5292,5295,5299,5332,5337,5843,6170,6219,7011,7078,7175,7333,7344,7603,11561,11562,11563,11576,11686,12976,213795,217305,221282,221283},
            [itemKeys.objectDrops] = {2855,105578,105579},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215396] = {
            [itemKeys.name] = "Waylaid Supplies: Elixirs of Greater Defense",
            [itemKeys.npcDrops] = {597,660,667,670,671,672,674,675,676,686,696,729,743,744,750,759,760,762,764,765,766,772,780,783,814,858,939,942,978,979,1061,1062,1114,1142,1491,1557,1562,1564,1565,1653,2245,2246,2247,2320,2415,2431,2474,2530,2535,2536,2557,2566,2567,2573,2574,2596,2653,2657,2715,2716,2723,2735,2739,2740,2742,2743,2773,2793,2830,2906,2927,2932,4260,4328,4329,4331,4342,4345,4352,4359,4361,4362,4363,4379,4382,4387,4389,4391,4392,4393,4396,4399,4401,4405,4412,4461,4504,4506,4644,4652,4655,4656,4659,4668,4678,4682,4685,4693,4834,5045,5046,5229,5236,5237,5238,5245,5249,5251,5255,5274,5278,5292,5293,5295,5299,5308,5328,5332,5426,5459,5616,5622,5771,5843,5850,6069,6118,6218,6219,6222,6224,7011,7344,7346,7397,7603,7858,8391,11561,14230,216667,221282,221283},
            [itemKeys.objectDrops] = {2857,105581},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215397] = {
            [itemKeys.name] = "Waylaid Supplies: Massive Iron Axes",
            [itemKeys.npcDrops] = {92,660,667,670,671,674,696,742,745,747,760,761,762,764,765,766,768,772,854,862,939,942,978,979,1061,1081,1082,1096,1114,1142,1144,1551,1561,1563,1713,2245,2247,2253,2318,2320,2347,2415,2423,2561,2572,2573,2574,2592,2649,2651,2701,2716,2723,2728,2730,2733,2734,2740,2742,2743,2761,2793,2906,2907,2925,2926,2927,2945,4063,4260,4329,4334,4342,4343,4345,4356,4357,4360,4361,4362,4363,4385,4396,4397,4411,4412,4457,4459,4504,4654,4656,4659,4662,4668,4677,4681,4682,4684,4685,4695,4699,4702,4705,4716,4723,4834,5044,5045,5046,5057,5184,5229,5232,5234,5238,5245,5249,5253,5258,5278,5292,5295,5327,5335,5451,5456,5485,5490,5771,5854,6069,6218,6219,6222,6224,7011,7334,7344,7346,7397,7603,11561,11687,213795,216667,221282,221283,221292},
            [itemKeys.objectDrops] = {2857,105581},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215398] = {
            [itemKeys.name] = "Waylaid Supplies: Green Iron Bracers",
            [itemKeys.npcDrops] = {205,206,210,212,300,429,533,570,604,701,736,755,785,787,855,856,898,910,920,938,947,948,949,1018,1034,1035,1038,1044,1057,1069,1096,1110,1157,1159,1160,1258,1353,1418,1663,2240,2248,2269,2270,2272,2305,2319,2337,2348,2368,2370,2372,2373,2374,2375,2377,2404,2406,2408,2450,2552,2553,2555,2559,2562,2564,2566,2575,2582,2721,2739,3752,3755,3759,3767,3770,3782,3784,3799,3802,3803,3804,3806,3807,3808,3810,3811,3815,3821,3825,3833,3919,3940,4027,4035,4038,4041,4093,4097,4099,4100,4101,4104,4107,4114,4116,4118,4119,4124,4130,4131,4202,4248,4249,4308,4413,4479,4541,4633,4642,4653,4672,4674,4834,6115,6575,7404,10617,10756,10758,10759,10760,10761,10992,11563,11684,11697,13019,14276,15749,217703,217711,221168,221169,221170,221171,221172,221176,221223},
            [itemKeys.objectDrops] = {2852,4096},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215399] = {
            [itemKeys.name] = "Waylaid Supplies: Heavy Mithril Gauntlets",
            [itemKeys.npcDrops] = {694,740,760,920,922,941,2551,2563,2566,2743,3941,4131,4133,4308,4344,4401,4632,4634,4639,4643,4652,4662,4673,5045,5046,5306,7334,11562,11686,12977},
            [itemKeys.objectDrops] = {2855,105570,105578,105579},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215400] = {
            [itemKeys.name] = "Waylaid Supplies: Solid Grinding Stones",
            [itemKeys.npcDrops] = {205,206,212,429,431,533,604,683,699,736,755,757,785,855,891,892,909,910,920,940,943,948,1014,1034,1035,1036,1038,1044,1057,1069,1096,1110,1157,1158,1160,1251,1663,1666,1755,2089,2241,2248,2249,2252,2253,2268,2269,2270,2319,2335,2337,2348,2356,2359,2368,2370,2371,2372,2373,2374,2375,2376,2377,2387,2408,2450,2503,2552,2562,2578,2582,2721,3754,3757,3763,3765,3767,3771,3784,3789,3797,3799,3801,3802,3803,3804,3807,3808,3818,3931,4028,4042,4093,4097,4099,4101,4104,4107,4111,4113,4116,4119,4124,4147,4248,4249,4308,4358,4479,4541,4633,4640,4648,4649,4651,4663,4695,4696,4701,5184,5600,6068,6115,6575,10756,10757,10759,10760,11563,11578,11680,11683,11697,12347,12677,12976,217669,221168,221170,221171,221172,221176,221223},
            [itemKeys.objectDrops] = {2852,4096},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215401] = {
            [itemKeys.name] = "Waylaid Supplies: Compact Harvest Reaper Kits",
            [itemKeys.npcDrops] = {522,588,595,670,671,683,688,689,694,697,701,702,736,740,755,757,759,764,780,921,937,939,940,941,978,979,1082,1085,1097,1142,1150,1489,1561,2240,2241,2242,2245,2249,2250,2252,2253,2271,2272,2304,2319,2358,2371,2376,2377,2406,2407,2408,2413,2544,2545,2552,2554,2555,2556,2557,2564,2572,2578,2581,2589,2618,2649,2714,2715,2721,2723,2739,2743,2773,2906,2907,4062,4110,4130,4133,4139,4140,4142,4143,4147,4150,4151,4158,4308,4358,4359,4361,4376,4378,4398,4457,4461,4481,4506,4619,4633,4634,4637,4638,4639,4640,4642,4644,4649,4654,4656,4659,4663,4665,4666,4670,4671,4673,4680,4692,4712,4719,4726,4728,5238,5249,5258,5332,5423,5426,6218,6219,6224,7175,7333,7346,7603,7848,8337,9377,11561,11562,11563,11576,11686,12976,12977,13019,216667,218249,221292},
            [itemKeys.objectDrops] = {2855,105579},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215402] = {
            [itemKeys.name] = "Waylaid Supplies: Big Iron Bombs",
            [itemKeys.npcDrops] = {205,206,210,212,429,533,570,588,604,701,703,741,785,787,889,891,898,909,910,920,938,943,948,949,1022,1023,1036,1044,1084,1110,1157,1158,1251,1663,1666,1755,2248,2249,2251,2268,2269,2270,2271,2337,2348,2371,2372,2373,2374,2375,2385,2404,2407,2408,2448,2503,2555,2562,2572,2582,2618,2619,2628,3378,3476,3752,3755,3757,3763,3765,3770,3782,3784,3799,3801,3802,3806,3808,3810,3818,3932,4017,4023,4024,4041,4062,4095,4097,4099,4100,4101,4104,4107,4110,4112,4114,4124,4142,4150,4248,4358,4479,4480,4632,4641,4643,4646,4663,4670,4671,4675,4696,4700,4712,4713,4714,6068,6115,6575,7078,7404,10617,10756,10757,10758,10759,10760,10761,10992,11697,12759,221168,221170,221171,221172,221176,221223},
            [itemKeys.objectDrops] = {2852,4096},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215403] = {
            [itemKeys.name] = "Waylaid Supplies: Deadly Scopes",
            [itemKeys.npcDrops] = {205,206,210,212,300,431,522,533,570,588,604,681,694,697,701,741,785,787,898,909,920,921,938,1017,1019,1023,1033,1034,1035,1036,1038,1044,1069,1097,1110,1140,1157,1158,1160,1251,1270,1418,1663,1666,1720,2242,2248,2249,2268,2269,2270,2304,2337,2368,2370,2372,2374,2375,2376,2387,2404,2406,2408,2411,2450,2503,2562,2564,2572,2582,2586,2628,3476,3696,3752,3754,3755,3757,3762,3763,3765,3767,3770,3782,3791,3797,3804,3806,3807,3808,3811,3818,3825,3919,3932,4029,4035,4062,4095,4097,4099,4100,4101,4104,4107,4109,4114,4118,4119,4124,4147,4249,4308,4541,4632,4642,4645,4649,4651,4663,4664,4696,4712,6115,6575,7333,10617,10756,10757,10758,10759,10760,10761,10896,11562,11563,11576,11680,11681,11697,12918,13019,15749,221168,221170,221171,221172,221176,221223},
            [itemKeys.objectDrops] = {2852,4096},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215404] = {
            [itemKeys.name] = "Waylaid Supplies: Mithril Blunderbuss",
            [itemKeys.npcDrops] = {597,660,671,672,677,690,696,728,742,743,744,750,751,759,760,764,765,766,772,858,862,939,942,978,979,1062,1081,1087,1096,1144,1488,1565,1653,2246,2247,2306,2320,2474,2536,2547,2557,2567,2572,2573,2574,2580,2592,2595,2596,2635,2649,2701,2716,2717,2719,2723,2728,2729,2731,2732,2733,2739,2740,2742,2743,2760,2761,2765,2829,2893,2907,2944,4260,4328,4329,4331,4334,4352,4355,4360,4361,4362,4363,4386,4387,4391,4392,4393,4402,4405,4412,4414,4504,4505,4654,4655,4656,4657,4658,4659,4660,4662,4668,4677,4681,4685,4705,4834,5045,5046,5184,5229,5232,5236,5239,5240,5246,5249,5254,5258,5286,5292,5293,5295,5331,5332,5419,5426,5623,5643,5850,5992,6069,6070,6218,6219,6222,6224,7011,7078,7091,7334,7344,7346,7603,7727,7848,7855,8337,11561,11685,11686,11937,216667,221282,221283,221292},
            [itemKeys.objectDrops] = {2857,105581},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215405] = {
            [itemKeys.name] = "Waylaid Supplies: Gnomish Rocket Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215406] = {
            [itemKeys.name] = "Waylaid Supplies: Goblin Mortars",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215407] = {
            [itemKeys.name] = "Waylaid Supplies: Barbaric Shoulders",
            [itemKeys.npcDrops] = {522,588,595,660,675,682,685,688,689,694,697,701,702,740,743,750,755,759,762,764,767,920,921,937,940,941,943,1062,1085,1094,1095,1097,1108,1144,1421,1488,1490,1562,1754,2240,2242,2249,2250,2251,2252,2272,2318,2358,2359,2369,2377,2406,2413,2554,2555,2556,2562,2563,2564,2565,2566,2572,2581,2582,2587,2589,2618,2619,2635,2701,2717,2721,2728,2735,2907,4130,4140,4147,4308,4355,4358,4359,4362,4386,4387,4390,4393,4413,4457,4505,4634,4635,4637,4639,4640,4641,4642,4647,4648,4649,4651,4656,4664,4665,4666,4667,4670,4671,4672,4673,4674,4682,4692,4712,4714,4715,4718,4719,4834,5044,5232,5234,5240,5251,5292,5293,5305,5307,5477,5616,5622,6219,6222,6224,7091,7175,7334,7344,7396,7603,11561,11563,11576,11577,11686,12676,12977,13019,217836,218249},
            [itemKeys.objectDrops] = {2855,105578,105579},
            [itemKeys.itemDrops] = {223149},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215408] = {
            [itemKeys.name] = "Waylaid Supplies: Guardian Gloves",
            [itemKeys.npcDrops] = {205,206,210,212,429,431,533,587,604,681,685,689,697,703,785,787,891,892,898,910,920,921,938,941,949,1019,1023,1034,1036,1044,1057,1069,1110,1157,1251,1270,1418,1663,1666,1755,2248,2252,2253,2268,2269,2270,2318,2337,2358,2368,2371,2372,2373,2374,2375,2387,2404,2412,2448,2450,2503,2553,2554,2555,2556,2562,2564,2581,2582,2586,2589,2721,3696,3754,3755,3757,3762,3767,3770,3771,3784,3791,3797,3806,3807,3808,3810,3811,3821,3825,3833,3834,3932,4029,4035,4041,4062,4093,4095,4097,4099,4101,4104,4109,4114,4124,4131,4147,4248,4249,4308,4341,4632,4633,4637,4640,4663,4689,4696,4711,6167,6575,7333,7404,10617,10756,10758,10759,11680,12759,14280,221169,221170,221171,221172,221176,221223},
            [itemKeys.objectDrops] = {2852,4096},
            [itemKeys.itemDrops] = {223149},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215409] = {
            [itemKeys.name] = "Waylaid Supplies: Turtle Scale Bracers",
            [itemKeys.npcDrops] = {597,660,667,671,684,690,696,731,741,744,751,757,759,762,763,764,765,766,768,772,854,939,1062,1081,1082,1114,1142,1144,1489,1562,1563,1564,1713,2243,2246,2247,2306,2318,2423,2431,2557,2574,2592,2595,2596,2651,2686,2691,2716,2718,2723,2727,2729,2739,2740,2742,2743,2764,2893,2906,2907,2928,2944,2945,4260,4341,4344,4359,4360,4361,4362,4363,4376,4378,4379,4382,4391,4393,4396,4397,4399,4402,4403,4411,4414,4459,4460,4461,4467,4505,4653,4654,4655,4656,4658,4659,4668,4676,4677,4680,4681,4682,4684,4685,4693,4705,4834,5044,5045,5046,5229,5234,5237,5238,5239,5244,5245,5246,5251,5258,5272,5278,5287,5292,5293,5295,5296,5421,5422,5426,5601,5622,5643,6069,6117,6195,6218,6219,6222,6224,6239,7011,7344,7346,7603,7726,7848,7856,7857,11559,11561,11687,216667,221282,221283,223543},
            [itemKeys.objectDrops] = {2857,105581},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215410] = {
            [itemKeys.name] = "Waylaid Supplies: Dusky Belts",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215411] = {
            [itemKeys.name] = "Waylaid Supplies: Frost Leather Cloaks",
            [itemKeys.npcDrops] = {205,206,212,300,397,533,570,587,604,740,741,785,787,898,909,910,920,1014,1018,1029,1034,1035,1038,1044,1069,1110,1150,1157,1158,1270,1418,1663,1666,1755,2108,2248,2251,2269,2271,2348,2356,2359,2368,2369,2372,2373,2375,2387,2404,2448,2554,2555,2582,2586,2628,3237,3378,3752,3754,3755,3757,3758,3763,3765,3770,3782,3784,3789,3791,3801,3802,3803,3807,3808,3810,3818,3821,3833,3919,3942,4017,4023,4024,4027,4028,4035,4041,4062,4095,4097,4100,4104,4107,4111,4114,4116,4117,4124,4140,4142,4143,4154,4249,4457,4638,4641,4642,4664,4666,4672,4696,4711,4715,4718,6071,6238,6575,7333,10759,10760,10761,11563,11684,11697,12347,12676,12976,12977,217669,217703,221168,221169,221170,221171,221172,221176,221223,223543},
            [itemKeys.objectDrops] = {2852},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215412] = {
            [itemKeys.name] = "Waylaid Supplies: Shadowskin Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215413] = {
            [itemKeys.name] = "Waylaid Supplies: Formal White Shirts",
            [itemKeys.npcDrops] = {205,206,210,212,300,429,511,533,570,604,688,697,703,785,787,855,898,920,921,938,1022,1034,1036,1038,1044,1108,1110,1157,1158,1159,1160,1258,1353,1663,1720,1755,2241,2248,2249,2251,2269,2270,2305,2335,2337,2368,2369,2371,2372,2374,2376,2377,2387,2406,2407,2408,2450,2552,2557,2562,2564,2582,2586,2587,2618,2619,2714,3378,3476,3660,3752,3757,3759,3763,3765,3770,3771,3784,3789,3791,3799,3803,3807,3808,3825,3919,3932,4027,4062,4095,4097,4100,4104,4113,4114,4116,4117,4119,4133,4142,4147,4154,4308,4541,4548,4632,4638,4639,4646,4647,4663,4664,4673,4696,4712,4719,4834,5600,5827,6071,6073,6115,6575,7175,10617,10757,10758,10759,10760,10761,10992,11576,11656,11680,12677,14426,15749,217711,221169,221170,221171,221172,221176,221223},
            [itemKeys.objectDrops] = {2852,4096},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215414] = {
            [itemKeys.name] = "Waylaid Supplies: Crimson Silk Pantaloons",
            [itemKeys.npcDrops] = {92,522,587,588,595,671,688,694,701,702,736,740,741,744,751,757,780,783,854,855,856,905,920,937,938,940,941,977,978,1081,1082,1085,1094,1114,1142,1151,1152,1489,1490,1551,2240,2241,2242,2246,2248,2249,2250,2251,2252,2253,2271,2319,2359,2376,2377,2407,2408,2552,2554,2555,2556,2559,2562,2564,2573,2574,2579,2586,2587,2589,2595,2618,2628,2701,2727,2740,2743,2761,2829,2923,3941,4139,4140,4144,4147,4308,4334,4355,4386,4397,4403,4414,4415,4458,4619,4632,4634,4637,4638,4640,4641,4642,4645,4646,4648,4649,4651,4653,4656,4657,4663,4664,4666,4667,4670,4671,4673,4675,4682,4685,4692,4695,4711,4712,4713,4714,4715,4728,4834,5229,5237,5260,5295,5622,6068,6170,6218,6219,6222,7011,7078,7175,7333,7344,7603,7725,7848,9377,11559,11561,11562,11576,11578,216667,221282},
            [itemKeys.objectDrops] = {2855,105578,105579},
            [itemKeys.itemDrops] = {223149},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215415] = {
            [itemKeys.name] = "Waylaid Supplies: Rich Purple Silk Shirts",
            [itemKeys.npcDrops] = {587,588,595,683,685,699,701,730,736,740,741,743,745,757,764,769,781,920,921,937,938,940,941,942,979,1084,1085,1094,1097,1140,1151,1421,1561,1713,2241,2242,2243,2245,2248,2249,2250,2251,2252,2271,2318,2319,2358,2359,2371,2377,2407,2412,2413,2434,2554,2555,2556,2559,2560,2562,2563,2564,2573,2575,2582,2586,2717,2721,2727,2731,2743,2760,2906,4110,4131,4133,4139,4140,4143,4144,4150,4154,4158,4308,4329,4331,4343,4358,4461,4480,4481,4619,4634,4636,4639,4640,4641,4645,4646,4649,4651,4652,4655,4660,4664,4666,4667,4668,4670,4672,4674,4675,4682,4684,4693,4697,4711,4712,4713,4715,4719,4834,5236,5247,5293,5327,5600,5622,6068,7011,7175,7333,7346,7603,11559,11561,11562,11576,11687,12976,216665,218249,223543},
            [itemKeys.objectDrops] = {2855,105578,105579},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215416] = {
            [itemKeys.name] = "Waylaid Supplies: White Bandit Masks",
            [itemKeys.npcDrops] = {597,660,670,671,672,674,677,729,741,742,743,744,745,750,751,759,760,761,762,764,765,766,768,780,854,858,861,939,978,979,1061,1062,1081,1095,1114,1142,1144,1562,1653,2243,2246,2247,2253,2318,2320,2431,2557,2561,2567,2572,2573,2574,2624,2635,2649,2656,2715,2716,2718,2723,2728,2729,2742,2743,2760,2761,2829,2893,2906,2907,2924,2932,2945,4260,4329,4331,4352,4356,4357,4360,4361,4362,4363,4378,4386,4387,4396,4397,4401,4415,4505,4506,4654,4657,4658,4659,4660,4668,4676,4677,4679,4681,4684,4687,4690,4705,5044,5184,5229,5237,5241,5245,5246,5249,5255,5292,5293,5295,5422,5426,5477,5601,5602,5760,6218,6219,6222,6224,7011,7344,7346,7396,7584,7603,7726,7727,11559,11561,11577,11685,11686,11687,216310,216667,221282,221283},
            [itemKeys.objectDrops] = {2857},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215417] = {
            [itemKeys.name] = "Waylaid Supplies: Soothing Turtle Bisque",
            [itemKeys.npcDrops] = {522,587,588,595,667,677,682,686,690,694,697,701,702,740,741,757,759,760,764,766,769,775,854,855,858,920,921,937,938,940,941,943,977,1096,1097,1114,2240,2241,2246,2248,2250,2251,2252,2304,2318,2319,2358,2371,2376,2377,2406,2407,2408,2411,2552,2555,2556,2557,2560,2564,2565,2566,2567,2572,2575,2577,2581,2582,2587,2589,2618,2635,2649,2657,2714,2716,2727,2728,2742,2829,2894,2907,3940,4130,4131,4139,4140,4154,4308,4329,4357,4358,4360,4382,4386,4392,4398,4400,4458,4459,4479,4634,4635,4639,4640,4642,4643,4644,4645,4646,4647,4651,4652,4656,4662,4664,4666,4667,4670,4671,4672,4673,4679,4680,4689,4693,4702,4711,4712,4713,4714,4715,4727,4728,4834,5296,5332,5334,6218,6219,6222,7011,7175,7333,7344,7346,7848,7858,11563,11686,11937,15749,218029,218249,221292},
            [itemKeys.objectDrops] = {2855,105578,105579},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215418] = {
            [itemKeys.name] = "Waylaid Supplies: Spider Sausages",
            [itemKeys.npcDrops] = {522,587,588,595,670,671,681,689,694,696,697,699,701,740,741,743,747,755,760,854,905,920,937,938,939,940,941,943,978,1085,1114,1152,1490,1754,2240,2241,2243,2245,2247,2249,2250,2251,2253,2272,2359,2371,2376,2408,2423,2431,2440,2553,2554,2555,2560,2562,2564,2566,2572,2573,2577,2581,2587,2589,2596,2619,2628,2701,2717,2720,2727,2731,2739,2740,2742,2762,2793,2829,3660,4062,4130,4131,4139,4144,4151,4154,4158,4308,4351,4352,4358,4362,4376,4398,4412,4414,4459,4480,4634,4636,4638,4639,4640,4644,4646,4648,4649,4651,4657,4663,4664,4665,4666,4667,4671,4672,4674,4676,4684,4696,4697,4711,4712,4713,4715,4719,4728,5229,5236,5422,5855,6170,6218,6219,6222,7154,7175,7333,7344,7346,7603,7857,11563,11578,217392,221282},
            [itemKeys.objectDrops] = {2855,105578,105579},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215419] = {
            [itemKeys.name] = "Waylaid Supplies: Heavy Silk Bandages",
            [itemKeys.npcDrops] = {588,595,669,682,685,686,688,694,697,699,701,702,736,740,747,750,755,757,759,761,765,766,780,782,856,905,920,921,937,938,940,978,1084,1108,1142,1150,1151,1152,1563,1713,2240,2241,2242,2246,2248,2249,2250,2251,2252,2253,2271,2272,2304,2358,2377,2406,2407,2440,2553,2554,2555,2556,2557,2559,2560,2562,2564,2566,2572,2574,2579,2580,2587,2589,2628,2714,2717,2727,2760,2762,2765,2830,2907,2944,3942,4131,4142,4143,4147,4150,4151,4158,4308,4328,4329,4341,4344,4351,4376,4379,4413,4415,4481,4634,4635,4636,4637,4638,4639,4641,4642,4644,4645,4647,4649,4653,4655,4663,4664,4666,4668,4670,4671,4673,4674,4677,4679,4692,4697,4701,4711,4712,4714,4719,4729,5260,5287,5292,5299,5300,5332,5334,5335,6218,6219,6224,7011,7175,7333,7344,7346,7603,11562,11563,11578,12347,217305,217836,218249},
            [itemKeys.objectDrops] = {2855,105578,105579},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215420] = {
            [itemKeys.name] = "Waylaid Supplies: Rockscale Cod",
            [itemKeys.npcDrops] = {205,206,210,212,429,511,533,570,587,588,595,604,689,694,699,702,703,740,757,785,787,856,892,898,909,910,920,921,938,1018,1034,1035,1036,1038,1044,1057,1096,1097,1110,1157,1158,1251,1258,1270,1353,1418,1421,1663,1666,2240,2248,2251,2268,2305,2335,2337,2356,2359,2368,2369,2370,2373,2374,2375,2387,2404,2553,2554,2559,2562,2564,2566,2581,2619,2721,2906,3378,3696,3752,3755,3757,3759,3763,3765,3767,3770,3771,3789,3791,3799,3802,3803,3804,3806,3808,3810,3818,3821,3825,3833,3834,3932,4023,4035,4042,4062,4099,4100,4101,4104,4107,4113,4116,4118,4119,4140,4147,4154,4248,4308,4541,4548,4632,4633,4648,4649,4666,4671,4712,4834,6073,6115,6170,6575,7404,10758,10759,10760,10761,10882,11684,11697,12677,15749,217669,221170,221171,221172,221176,221223},
            [itemKeys.objectDrops] = {2852,4096},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215421] = {
            [itemKeys.name] = "Waylaid Supplies: Fire Oil",
            [itemKeys.npcDrops] = {205,206,212,397,533,570,587,604,694,757,785,787,892,898,909,910,920,937,948,1018,1023,1033,1034,1035,1036,1038,1044,1069,1110,1150,1157,1158,1251,1270,1663,1666,2248,2250,2304,2335,2337,2348,2372,2373,2375,2387,2404,2448,2450,2503,2552,2554,2555,2557,2582,2586,2618,2619,2628,2721,3378,3414,3755,3757,3759,3770,3771,3784,3789,3791,3797,3799,3801,3802,3803,3806,3811,3833,3834,3919,3931,3932,4023,4027,4029,4038,4093,4095,4100,4101,4104,4107,4109,4113,4119,4124,4126,4142,4147,4249,4382,4541,4638,4640,4643,4648,4663,4672,4675,4692,4697,4711,5933,6073,6115,6575,7404,10617,10758,10759,10760,10761,10992,11562,11680,11681,11697,12759,13019,217711,217836,221168,221169,221170,221171,221172,221176,221223},
            [itemKeys.objectDrops] = {2852,4096},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215422] = {
            [itemKeys.name] = "Pattern: Glowing Hyperconductive Scale Coif",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215423] = {
            [itemKeys.name] = "Pattern: Gneuro-Conductive Channeler's Hood",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215424] = {
            [itemKeys.name] = "Pattern: Rad-Resistant Scale Hood",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215425] = {
            [itemKeys.name] = "Swamp Echo",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {424265},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215426] = {
            [itemKeys.name] = "Graveyard Echo",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {424266},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215427] = {
            [itemKeys.name] = "Arathi Echo",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {424267},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215428] = {
            [itemKeys.name] = "Theramore Echo",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {424264},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215429] = {
            [itemKeys.name] = "Schematic: Polished Truesilver Gears",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215430] = {
            [itemKeys.name] = "Gnomeregan Fallout",
            [itemKeys.npcDrops] = {6206,6207,6211,6220,6226,6227,6230,6232,6233,6234,6329,215728,216668,217280,218242,218537,220007,220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215431] = {
            [itemKeys.name] = "Schematic: High-Yield Radiation Bomb",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215432] = {
            [itemKeys.name] = "Schematic: Ez-Thro Radiation Bomb",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215433] = {
            [itemKeys.name] = "Recipe: Insulating Gniodine",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [215434] = {
            [itemKeys.name] = "UNUSED",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215435] = {
            [itemKeys.name] = "Libram of Benediction",
            [itemKeys.npcDrops] = {217280},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215436] = {
            [itemKeys.name] = "Totem of Invigorating Flame",
            [itemKeys.npcDrops] = {217280},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215437] = {
            [itemKeys.name] = "Trogg Transfigurator 3000",
            [itemKeys.npcDrops] = {217280},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {235251},
            [itemKeys.startQuest] = nil,
        },
        [215441] = {
            [itemKeys.name] = "Broken Hammer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {423703},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 79939,
        },
        [215443] = {
            [itemKeys.name] = "Shattered Orb Fragment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215444] = {
            [itemKeys.name] = "Monster - Mace - Broken Pipes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215449] = {
            [itemKeys.name] = "World Shrinker",
            [itemKeys.npcDrops] = {215728},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {235251},
            [itemKeys.startQuest] = nil,
        },
        [215450] = {
            [itemKeys.name] = "Tabard Project (Aidan)",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215451] = {
            [itemKeys.name] = "Large Strongbox",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {423930},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215452] = {
            [itemKeys.name] = "Medium Strongbox",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {215451},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215453] = {
            [itemKeys.name] = "Small Strongbox",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {215452},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215454] = {
            [itemKeys.name] = "Tiny Strongbox",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {215453},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215456] = {
            [itemKeys.name] = "Singed Message",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {215465},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215458] = {
            [itemKeys.name] = "Enclosed Message",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {215453},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215459] = {
            [itemKeys.name] = "Enclosed Message",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {215452},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215460] = {
            [itemKeys.name] = "Enclosed Message",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {215451},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215461] = {
            [itemKeys.name] = "Domesticated Attack Chicken",
            [itemKeys.npcDrops] = {218537},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215465] = {
            [itemKeys.name] = "Exploded Strongbox",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215468] = {
            [itemKeys.name] = "Orders from the Grand Crusader",
            [itemKeys.npcDrops] = {218908},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 79945,
        },
        [215683] = {
            [itemKeys.name] = "Geomancy: The Stone-Cold Truth",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {423895},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215815] = {
            [itemKeys.name] = "Defensive Magics 101",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {423896},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215816] = {
            [itemKeys.name] = "A Web of Lies: Debunking Myths and Legends",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {423897},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215817] = {
            [itemKeys.name] = "Demons and You",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {423898},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215820] = {
            [itemKeys.name] = "Mummies: A Guide to the Unsavory Undead",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {423899},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215822] = {
            [itemKeys.name] = "RwlRwlRwlRwl!",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {423900},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [215824] = {
            [itemKeys.name] = "A Ludite's Guide to Caring for Your Demonic Pet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {423901},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216483] = {
            [itemKeys.name] = "Witherbark Mallet",
            [itemKeys.npcDrops] = {2552,2553,2554,2555,2556,2557},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216484] = {
            [itemKeys.name] = "Shockforged Battleboots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [216485] = {
            [itemKeys.name] = "Shockforged Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [216486] = {
            [itemKeys.name] = "Shockforged Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [216490] = {
            [itemKeys.name] = "Idol of Wrath",
            [itemKeys.npcDrops] = {217280},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216491] = {
            [itemKeys.name] = "Shipment of Stranglethorn Lumber",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216492] = {
            [itemKeys.name] = "Whistle of the Mottled Blood Raptor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216494] = {
            [itemKeys.name] = "Aragriar's Whimsical World Warper",
            [itemKeys.npcDrops] = {220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {235251},
            [itemKeys.startQuest] = nil,
        },
        [216495] = {
            [itemKeys.name] = "Sanguine Crusher",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216496] = {
            [itemKeys.name] = "Sanguine Skullcrusher",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216497] = {
            [itemKeys.name] = "Exsanguinar",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216498] = {
            [itemKeys.name] = "Enchanted Sanguine Grimoire",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216499] = {
            [itemKeys.name] = "Bloodbark Crusher",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216500] = {
            [itemKeys.name] = "Bloodbonded Grove Talisman",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216501] = {
            [itemKeys.name] = "Bloodstorm Barrier",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216502] = {
            [itemKeys.name] = "Bloodstorm War Totem",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216503] = {
            [itemKeys.name] = "Bloodstorm Jewel",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216504] = {
            [itemKeys.name] = "Eclipsed Bloodlight Saber",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216505] = {
            [itemKeys.name] = "Bloodlight Crusader's Radiance",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216506] = {
            [itemKeys.name] = "Bloodlight Avenger's Edge",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216507] = {
            [itemKeys.name] = "Umbral Bloodseal",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216508] = {
            [itemKeys.name] = "Infernal Bloodcoil Band",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216509] = {
            [itemKeys.name] = "Infernal Pact Essence",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216510] = {
            [itemKeys.name] = "Blood Resonance Circle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216511] = {
            [itemKeys.name] = "Emberblood Seal",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216512] = {
            [itemKeys.name] = "Loop of Chilled Veins",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216513] = {
            [itemKeys.name] = "Tigerblood Talisman",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216514] = {
            [itemKeys.name] = "Sanguine Quiver",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216515] = {
            [itemKeys.name] = "Sanguine Ammo Pouch",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216516] = {
            [itemKeys.name] = "Bloodlash Bow",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216517] = {
            [itemKeys.name] = "Sanguine Sanctuary",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216518] = {
            [itemKeys.name] = "Blood Covenant Seal",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216519] = {
            [itemKeys.name] = "Sanguine Shadow Band",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216520] = {
            [itemKeys.name] = "Bloodharvest Blade",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216521] = {
            [itemKeys.name] = "Swift Sanguine Strikers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216522] = {
            [itemKeys.name] = "Blood Spattered Stiletto",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216523] = {
            [itemKeys.name] = "Rusted Cage Key",
            [itemKeys.npcDrops] = {759,762},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216549] = {
            [itemKeys.name] = "Reins of the Bengal Tiger",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216570] = {
            [itemKeys.name] = "Reins of the Golden Sabercat",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216606] = {
            [itemKeys.name] = "Rune of Two-Handed Mastery",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {217014},
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [216607] = {
            [itemKeys.name] = "Bloodlight Offering",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216608] = {
            [itemKeys.name] = "Radiant Ray Reflectors",
            [itemKeys.npcDrops] = {218537},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {235251},
            [itemKeys.startQuest] = nil,
        },
        [216610] = {
            [itemKeys.name] = "Orders from the Grand Crusader",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216615] = {
            [itemKeys.name] = "Ancestral Bloodstorm Beacon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216616] = {
            [itemKeys.name] = "Compound Cage Key",
            [itemKeys.npcDrops] = {939,978},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216617] = {
            [itemKeys.name] = "Kurzen Fighter's Uniform",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {424002},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216618] = {
            [itemKeys.name] = "Captain Aransas' Reward",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216619] = {
            [itemKeys.name] = "Student Fodder",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216620] = {
            [itemKeys.name] = "Bloodrot Cloak",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216621] = {
            [itemKeys.name] = "Blooddrenched Drape",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216622] = {
            [itemKeys.name] = "Coagulated Cloak",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216623] = {
            [itemKeys.name] = "Cape of Hemostasis",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216633] = {
            [itemKeys.name] = "Hydraulic Truesilver Strut",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216634] = {
            [itemKeys.name] = "GG12-082 Cartridge Fuse",
            [itemKeys.npcDrops] = {6224,6225,6226,6227,6230,6232,6233,6234,215728,218242,220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216635] = {
            [itemKeys.name] = "Spent Voidcore",
            [itemKeys.npcDrops] = {2596,5335,5336,5337},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216636] = {
            [itemKeys.name] = "Charged Voidcore",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216637] = {
            [itemKeys.name] = "A Pile of Random Parts",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {213641},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216645] = {
            [itemKeys.name] = "Mote of Darkness",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216646] = {
            [itemKeys.name] = "Ziri's Mystery Crate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {217689},
            [itemKeys.startQuest] = nil,
        },
        [216661] = {
            [itemKeys.name] = "Grime-Encrusted Ring",
            [itemKeys.npcDrops] = {6212,6228},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 79986,
        },
        [216662] = {
            [itemKeys.name] = "Brilliant Gold Ring",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216673] = {
            [itemKeys.name] = "Talvash's Brilliant Gold Ring",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216674] = {
            [itemKeys.name] = "Nogg's Brilliant Gold Ring",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216675] = {
            [itemKeys.name] = "Pristine Civinad Robes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216676] = {
            [itemKeys.name] = "Nimble Triprunner Dungarees",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216678] = {
            [itemKeys.name] = "Triple Reinforced Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216679] = {
            [itemKeys.name] = "Shoni's Dismantling Tool",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216680] = {
            [itemKeys.name] = "Shilly Mittens",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216698] = {
            [itemKeys.name] = "Sergeant Major's Dragonhide Armsplints",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12805},
            [itemKeys.startQuest] = nil,
        },
        [216699] = {
            [itemKeys.name] = "Sergeant Major's Chain Armguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12805},
            [itemKeys.startQuest] = nil,
        },
        [216700] = {
            [itemKeys.name] = "Sergeant Major's Leather Armsplints",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12805},
            [itemKeys.startQuest] = nil,
        },
        [216701] = {
            [itemKeys.name] = "Sergeant Major's Plate Wristguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12805},
            [itemKeys.startQuest] = nil,
        },
        [216702] = {
            [itemKeys.name] = "Sergeant Major's Silk Cuffs",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12805},
            [itemKeys.startQuest] = nil,
        },
        [216703] = {
            [itemKeys.name] = "First Sergeant's Mail Wristguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12799},
            [itemKeys.startQuest] = nil,
        },
        [216704] = {
            [itemKeys.name] = "First Sergeant's Dragonhide Armguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12799},
            [itemKeys.startQuest] = nil,
        },
        [216705] = {
            [itemKeys.name] = "First Sergeant's Plate Bracers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12799},
            [itemKeys.startQuest] = nil,
        },
        [216706] = {
            [itemKeys.name] = "First Sergeant's Leather Armguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12799},
            [itemKeys.startQuest] = nil,
        },
        [216707] = {
            [itemKeys.name] = "First Sergeant's Silk Cuffs",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12799},
            [itemKeys.startQuest] = nil,
        },
        [216738] = {
            [itemKeys.name] = "Manual of Redirect",
            [itemKeys.npcDrops] = {3974,3975,3976,3977,3983,4542,4543,4854,6487,6488,6489,6490,6906,6910,7228,7291,7354,7355,7356,7357,7358,8567},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [216740] = {
            [itemKeys.name] = "Tome of Expanded Intellect",
            [itemKeys.npcDrops] = {2748,3974,3975,3976,3977,3983,4542,4543,4854,6487,6488,6489,6490,6906,6910,7206,7228,7291,7354,7355,7356,7357,7358,8567,14693},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [216744] = {
            [itemKeys.name] = "Scroll of Increased Fortitude",
            [itemKeys.npcDrops] = {2748,3974,3975,3976,3977,3983,4542,4543,4854,6487,6488,6489,6490,6906,6910,7206,7228,7355,7356,7357,7358,8567},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [216745] = {
            [itemKeys.name] = "Scroll of Shadowfiend",
            [itemKeys.npcDrops] = {2748,3974,3975,3976,3977,3983,4542,4543,6487,6488,6489,6490,6906,6910,7228,7291,7355,7356,7357,7358,8567},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [216746] = {
            [itemKeys.name] = "Handbook of Commanding Shout",
            [itemKeys.npcDrops] = {2748,3974,3975,3976,3977,3983,4542,4543,4854,6487,6488,6489,6490,6906,6910,7228,7355,7356,7357,7358,8567},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [216747] = {
            [itemKeys.name] = "Grimoire of Soul Harvesting",
            [itemKeys.npcDrops] = {3974,3975,3976,3977,3983,4542,4543,4854,6487,6488,6489,6490,6910,7355,7356,7357,7358,8567},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [216748] = {
            [itemKeys.name] = "Grimoire of Portal of Summoning",
            [itemKeys.npcDrops] = {3974,3975,3976,3977,3983,4542,4543,6487,6488,6489,6490,6910,7228,7291,7356,7357,7358},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [216764] = {
            [itemKeys.name] = "Leaflet of Deeper Wilds",
            [itemKeys.npcDrops] = {2748,3974,3975,3976,3977,3983,4542,4543,4854,6487,6488,6489,6490,6910,7228,7291,7355,7356,7357,7358,8567},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [216767] = {
            [itemKeys.name] = "Leaflet of Revive",
            [itemKeys.npcDrops] = {3974,3975,3976,3977,3983,4542,4543,4854,6487,6488,6489,6490,6910,7206,7228,7291,7354,7355,7357,7358,8567},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [216768] = {
            [itemKeys.name] = "Testament of Enhanced Blessings",
            [itemKeys.npcDrops] = {2748,3974,3975,3976,3977,3983,4542,4543,4854,6487,6488,6489,6490,7206,7228,7355,7356,7358,8567},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,233335},
            [itemKeys.startQuest] = nil,
        },
        [216769] = {
            [itemKeys.name] = "Revelation of Totemic Projection",
            [itemKeys.npcDrops] = {3974,3975,3976,3977,3983,4542,4543,6487,6488,6489,6490,6910,7206,7355,7356,7358,8567},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {4047,233428},
            [itemKeys.startQuest] = nil,
        },
        [216770] = {
            [itemKeys.name] = "Treatise on Aspect of the Viper",
            [itemKeys.npcDrops] = {2748,3974,3975,3976,3977,3983,4542,4543,4854,6487,6488,6489,6490,6910,7206,7228,7291,7354,7355,7356,7357,7358,8567},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [216771] = {
            [itemKeys.name] = "Leaflet of Enhanced Restoration",
            [itemKeys.npcDrops] = {2748,3974,3975,3976,3977,3983,4542,4543,4854,6487,6488,6489,6490,6906,6910,7206,7228,7355,7356,7357,7358,8567},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [216879] = {
            [itemKeys.name] = "Mysterious Troll Scroll",
            [itemKeys.npcDrops] = {587,588,595,597,660,667,669,670,671,694,696,697,699,701,702,780,782,784,1490},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216880] = {
            [itemKeys.name] = "Deciphered Troll Scroll",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 79731,
        },
        [216884] = {
            [itemKeys.name] = "Bloodthirst Blade",
            [itemKeys.npcDrops] = {218690},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216914] = {
            [itemKeys.name] = "Tarnished Commendation",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115},
            [itemKeys.startQuest] = nil,
        },
        [216918] = {
            [itemKeys.name] = "Felheart Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [216919] = {
            [itemKeys.name] = "Felheart Sash",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [216920] = {
            [itemKeys.name] = "Felheart Bindings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [216921] = {
            [itemKeys.name] = "Felheart Grips",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [216922] = {
            [itemKeys.name] = "Felheart Crown",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [216923] = {
            [itemKeys.name] = "Felheart Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [216924] = {
            [itemKeys.name] = "Felheart Embrace",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [216925] = {
            [itemKeys.name] = "Felheart Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [216938] = {
            [itemKeys.name] = "Greater Insignia of the Alliance",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12805},
            [itemKeys.startQuest] = nil,
        },
        [216939] = {
            [itemKeys.name] = "Greater Insignia of the Horde",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12799},
            [itemKeys.startQuest] = nil,
        },
        [216941] = {
            [itemKeys.name] = "Ariden's Sigil",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216945] = {
            [itemKeys.name] = "Curious Dalaran Relic",
            [itemKeys.npcDrops] = {218931},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216946] = {
            [itemKeys.name] = "Glittering Dalaran Relic",
            [itemKeys.npcDrops] = {218931},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216947] = {
            [itemKeys.name] = "Whirring Dalaran Relic",
            [itemKeys.npcDrops] = {218931},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216948] = {
            [itemKeys.name] = "Odd Dalaran Relic",
            [itemKeys.npcDrops] = {218931},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216949] = {
            [itemKeys.name] = "Heavy Dalaran Relic",
            [itemKeys.npcDrops] = {218931},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216950] = {
            [itemKeys.name] = "Creepy Dalaran Relic",
            [itemKeys.npcDrops] = {218931},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216951] = {
            [itemKeys.name] = "Slippery Dalaran Relic",
            [itemKeys.npcDrops] = {218931},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216956] = {
            [itemKeys.name] = "Torn Letter",
            [itemKeys.npcDrops] = {4668,4705},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [216971] = {
            [itemKeys.name] = "Satchel of Copper Blood Coins",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [216972] = {
            [itemKeys.name] = "Satchel of Silver Blood Coins",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [217005] = {
            [itemKeys.name] = "Repairman's Cape",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217006] = {
            [itemKeys.name] = "Mechanic's Pipehammer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217007] = {
            [itemKeys.name] = "Power Depleted Boots",
            [itemKeys.npcDrops] = {218242,218537,220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217008] = {
            [itemKeys.name] = "Power Depleted Chest",
            [itemKeys.npcDrops] = {218242,218537,220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217009] = {
            [itemKeys.name] = "Power Depleted Legs",
            [itemKeys.npcDrops] = {218242,218537,220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217014] = {
            [itemKeys.name] = "Supply Bag",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217017] = {
            [itemKeys.name] = "Fishing Tournament!",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217161] = {
            [itemKeys.name] = "Spell Notes: TROFF IRESTBOL",
            [itemKeys.npcDrops] = {780},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217244] = {
            [itemKeys.name] = "Pattern: Crimson Silk Robe",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {6568},
            [itemKeys.startQuest] = nil,
        },
        [217245] = {
            [itemKeys.name] = "Crimson Silk Robe",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217246] = {
            [itemKeys.name] = "Black Mageweave Vest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217247] = {
            [itemKeys.name] = "Black Mageweave Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217248] = {
            [itemKeys.name] = "Earthen Silk Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217249] = {
            [itemKeys.name] = "Pattern: Earthen Silk Belt",
            [itemKeys.npcDrops] = {92,587,595,671,684,688,690,691,696,697,741,747,762,764,766,772,780,875,879,937,1085,1096,1561,2242,2247,2254,2256,2257,2376,2545,2570,2587,2588,2592,2726,2729,2762,2829,3974,3983,4143,4283,4286,4287,4288,4289,4290,4291,4292,4293,4294,4295,4296,4297,4298,4299,4300,4301,4302,4303,4304,4308,4323,4329,4344,4352,4414,4540,4542,4656,4846,4850,4851,4855,4860,5046,5240,5251,5253,5278,5335,5336,5649,6206,6207,6212,6223,6226,6232,6233,6234,6329,6426,6427,6487,6910,7078,7246,7286,7337,7342,7346,7347,7348,7349,7351,7352,7353,7355,7603,7858,11561,11781,14123,215728,216669,221282,221283,221292},
            [itemKeys.objectDrops] = {2857,75296,75300},
            [itemKeys.itemDrops] = {4634,4636,20767,21150,21228},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217250] = {
            [itemKeys.name] = "Crimson Silk Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217251] = {
            [itemKeys.name] = "Pattern: Crimson Silk Shoulders",
            [itemKeys.npcDrops] = {667,671,691,709,766,772,780,977,978,1096,1152,1557,1562,2246,2253,2256,2287,2556,2557,2561,2588,2590,2649,2723,2735,2740,2742,2762,3975,3976,3983,4283,4286,4287,4288,4290,4291,4292,4294,4295,4296,4298,4299,4300,4301,4302,4303,4304,4308,4359,4361,4377,4378,4539,4540,4543,4674,4693,4697,4712,4844,4850,4851,4852,4853,4856,5292,5335,5648,5649,5650,5856,6206,6212,6222,6223,6230,6233,6329,6426,6427,6489,7078,7269,7328,7329,7337,7342,7346,7347,7348,7351,7352,7353,7603,7873,8759,11561,11563,11577,11686,11787,215728,216668,216669,221259,221263},
            [itemKeys.objectDrops] = {75299,75300,141596},
            [itemKeys.itemDrops] = {4634,4636,21150,21228},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217252] = {
            [itemKeys.name] = "Long Silken Cloak",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217253] = {
            [itemKeys.name] = "Boots of the Enchanter",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217254] = {
            [itemKeys.name] = "Pattern: Boots of the Enchanter",
            [itemKeys.npcDrops] = {92,686,691,740,741,759,785,937,938,940,1054,1096,1097,1715,2241,2252,2287,2318,2371,2377,2387,2406,2559,2561,2565,2589,2595,2743,3378,3752,3757,3974,3983,4097,4104,4107,4133,4140,4143,4283,4286,4287,4288,4290,4291,4292,4293,4294,4295,4296,4298,4299,4300,4301,4302,4304,4306,4308,4359,4376,4436,4523,4525,4531,4540,4543,4623,4632,4634,4646,4665,4674,4676,4681,4711,4718,4726,4728,4729,4863,6220,6223,6233,6329,6426,6427,7078,7328,7329,7332,7335,7341,7342,7347,7349,7352,7603,7873,11561,11563,11577,204645,216666,216669,221282},
            [itemKeys.objectDrops] = {74448,75296,75299,75300},
            [itemKeys.itemDrops] = {4634,4636,16883,19425,21150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217255] = {
            [itemKeys.name] = "Crimson Silk Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217256] = {
            [itemKeys.name] = "Earthen Vest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217257] = {
            [itemKeys.name] = "Enchanter's Cowl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217258] = {
            [itemKeys.name] = "Pattern: Enchanter's Cowl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {2670,12246},
            [itemKeys.startQuest] = nil,
        },
        [217259] = {
            [itemKeys.name] = "Big Voodoo Mask",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217260] = {
            [itemKeys.name] = "Pattern: Big Voodoo Mask",
            [itemKeys.npcDrops] = {667,709,744,767,780,782,1491,1563,2256,2287,2569,2590,2592,2645,2652,2725,2783,2831,2924,4286,4290,4292,4295,4298,4299,4300,4301,4302,4323,4357,4399,4540,4716,4846,4852,5226,5255,5268,5278,5287,5336,5337,5426,5485,5617,5618,5648,5649,5650,5708,5839,5843,5844,5846,5855,6125,6193,6206,6207,6212,6218,6223,6224,6226,6227,6232,6233,6234,6509,7023,7153,7246,7269,7286,7320,7335,7337,7341,7344,7351,7353,7603,7604,7605,7856,8095,8336,8890,8891,8921,11783,11785,11793,12206,12207,12217,12220,13323,216666,220072,221259,221263,221264,221267,221283,221292,221407,224244,224386},
            [itemKeys.objectDrops] = {4149,141979},
            [itemKeys.itemDrops] = {4636,4637,4638,9265,19035,20767,21228},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217261] = {
            [itemKeys.name] = "Big Voodoo Robe",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217262] = {
            [itemKeys.name] = "Pattern: Big Voodoo Robe",
            [itemKeys.npcDrops] = {597,674,687,772,871,875,1490,1558,1562,1563,2570,2574,2640,2648,2649,2725,2894,2926,2927,2928,4286,4289,4290,4292,4294,4295,4299,4300,4301,4302,4363,4399,4506,4540,4845,4850,4855,5226,5229,5246,5251,5254,5255,5296,5333,5336,5425,5431,5648,5649,5650,5708,5843,5853,5861,5984,6206,6207,6211,6212,6222,6224,6226,6227,6232,6233,6234,7011,7012,7030,7033,7206,7246,7269,7286,7320,7321,7337,7341,7342,7346,7348,7358,7396,7603,8637,8890,8891,8921,10082,11561,11783,11785,11786,12206,12216,12220,12222,13323,13718,14123,203138,217280,218242,218537,220007,221259,221260,221261,221262,221263,221264,221282,221283,221371,221406,224256,224257,224386},
            [itemKeys.objectDrops] = {2560},
            [itemKeys.itemDrops] = {4636,4637,9265,21228},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217263] = {
            [itemKeys.name] = "Guardian Leather Bracers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217264] = {
            [itemKeys.name] = "Pattern: Guardian Leather Bracers",
            [itemKeys.npcDrops] = {588,660,687,690,691,696,736,937,1097,2241,2256,2287,2377,2553,2572,2573,2588,2595,2716,2723,2726,2731,2735,2893,4140,4286,4287,4288,4289,4290,4291,4292,4294,4295,4298,4299,4300,4301,4302,4303,4304,4308,4328,4359,4393,4532,4540,4542,4655,4679,4705,4719,4845,4846,4850,4851,4852,4855,4861,4863,5622,5649,5650,6206,6207,6212,6218,6219,6220,6222,6223,6226,6232,6233,6234,6329,6426,6427,7022,7078,7175,7286,7320,7329,7341,7342,7348,7353,7357,7603,11561,12219,216667,216669,217280,220072,221261,221263,221264,221283},
            [itemKeys.objectDrops] = {2857,75296,75299},
            [itemKeys.itemDrops] = {4634,4636,4637,21150,21228,223149},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217265] = {
            [itemKeys.name] = "Guardian Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217266] = {
            [itemKeys.name] = "Pattern: Guardian Belt",
            [itemKeys.npcDrops] = {1715,4283,4295,4296,6426,221171},
            [itemKeys.objectDrops] = {75299},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217267] = {
            [itemKeys.name] = "Guardian Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217268] = {
            [itemKeys.name] = "Turtle Scale Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217270] = {
            [itemKeys.name] = "Turtle Scale Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217271] = {
            [itemKeys.name] = "Pattern: Turtle Scale Gloves",
            [itemKeys.npcDrops] = {687,691,1082,1557,1563,1907,2545,2561,2651,2907,4286,4292,4295,4298,4299,4301,4302,4323,4352,4362,4506,4540,4656,4845,4851,4855,4857,5232,5255,5295,5296,5335,5337,5618,5623,5649,5650,5861,5984,6234,6329,7246,7247,7269,7286,7321,7328,7329,7855,7858,8637,8891,8921,8958,10043,11791,12216,12241,14123,221259,224256},
            [itemKeys.objectDrops] = {2560,4149,75300,141596,141979},
            [itemKeys.itemDrops] = {4636,4637,4638,19425,21228},
            [itemKeys.vendors] = {7852,7854},
            [itemKeys.startQuest] = nil,
        },
        [217273] = {
            [itemKeys.name] = "Golden Scale Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217274] = {
            [itemKeys.name] = "Plans: Golden Scale Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217275] = {
            [itemKeys.name] = "Golden Scale Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217276] = {
            [itemKeys.name] = "Plans: Golden Scale Boots",
            [itemKeys.npcDrops] = {4287,4292,4294,4641,6233,7603},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {4634},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217277] = {
            [itemKeys.name] = "Golden Scale Cuirass",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217278] = {
            [itemKeys.name] = "Plans: Golden Scale Cuirass",
            [itemKeys.npcDrops] = {597,667,682,689,764,769,780,1114,1142,1489,1563,2240,2358,2408,2557,2558,2559,2561,2566,2567,2569,2571,2574,2585,2588,2725,2743,2761,2928,4151,4283,4286,4287,4288,4289,4290,4291,4292,4294,4295,4296,4298,4299,4300,4301,4302,4303,4304,4308,4357,4396,4397,4539,4540,4543,4623,4639,4642,4651,4684,4845,4851,4852,4855,4861,5229,5234,5255,5422,5649,5650,6206,6207,6211,6212,6218,6220,6223,6224,6226,6227,6233,6234,6329,6427,6487,7022,7030,7078,7246,7286,7328,7332,7341,7342,7344,7345,7346,7347,7349,7352,7353,7358,7603,7856,11561,11785,13718,215728,216667,216669,221259,221262,221283},
            [itemKeys.objectDrops] = {2857,75299,75300},
            [itemKeys.itemDrops] = {4634,4636,4637,10569,16883},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217279] = {
            [itemKeys.name] = "Golden Scale Coif",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217280] = {
            [itemKeys.name] = "Plans: Golden Scale Coif",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {5411},
            [itemKeys.startQuest] = nil,
        },
        [217281] = {
            [itemKeys.name] = "Moonsteel Broadsword",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217282] = {
            [itemKeys.name] = "Plans: Moonsteel Broadsword",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {2482},
            [itemKeys.startQuest] = nil,
        },
        [217283] = {
            [itemKeys.name] = "Golden Scale Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217284] = {
            [itemKeys.name] = "Plans: Golden Scale Shoulders",
            [itemKeys.npcDrops] = {588,595,597,686,701,736,920,938,1096,2251,2358,2377,2559,2565,2572,2590,2618,4139,4150,4286,4287,4288,4291,4292,4293,4295,4298,4299,4304,4306,4308,4540,4543,4663,4846,4851,6206,6426,6427,6487,7329,7333,7347,11561,11563},
            [itemKeys.objectDrops] = {74448,75296,75299,75300},
            [itemKeys.itemDrops] = {4633,4634,4636,21113,21150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217285] = {
            [itemKeys.name] = "Golden Scale Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217286] = {
            [itemKeys.name] = "Plans: Golden Scale Leggings",
            [itemKeys.npcDrops] = {205,667,683,694,702,736,879,920,938,939,941,1053,1085,2240,2241,2249,2287,2318,2369,2377,2406,2407,2556,2587,2618,2732,3802,3983,4101,4124,4140,4283,4286,4287,4288,4289,4290,4291,4293,4294,4295,4296,4297,4298,4299,4300,4301,4302,4303,4304,4306,4308,4359,4421,4436,4440,4515,4538,4539,4540,4541,4623,4633,4634,4640,4647,4668,4672,4673,4700,4844,4851,6206,6220,6233,6329,6426,6427,7327,7328,7329,7333,7335,7342,7347,7603,7873,7874,12676,215108,221175,221282,221283},
            [itemKeys.objectDrops] = {2852,75296,75299,75300},
            [itemKeys.itemDrops] = {4634,4636,21113,21150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217287] = {
            [itemKeys.name] = "Greater Mystic Wand",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217288] = {
            [itemKeys.name] = "Robes of the Lich",
            [itemKeys.npcDrops] = {7358},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217289] = {
            [itemKeys.name] = "Deathchill Armor",
            [itemKeys.npcDrops] = {7358},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217290] = {
            [itemKeys.name] = "Glowing Eye of Mordresh",
            [itemKeys.npcDrops] = {7357},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217291] = {
            [itemKeys.name] = "Mordresh's Lifeless Skull",
            [itemKeys.npcDrops] = {7357},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217292] = {
            [itemKeys.name] = "Deathmage Sash",
            [itemKeys.npcDrops] = {7357},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217293] = {
            [itemKeys.name] = "Silky Spider Cape",
            [itemKeys.npcDrops] = {7355},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217294] = {
            [itemKeys.name] = "Embalmed Shroud",
            [itemKeys.npcDrops] = {6488},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217295] = {
            [itemKeys.name] = "Necrotic Wand",
            [itemKeys.npcDrops] = {6490},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217296] = {
            [itemKeys.name] = "Ghostshard Talisman",
            [itemKeys.npcDrops] = {6490},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217297] = {
            [itemKeys.name] = "Robe of Doan",
            [itemKeys.npcDrops] = {6487},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217298] = {
            [itemKeys.name] = "Mantle of Doan",
            [itemKeys.npcDrops] = {6487},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217299] = {
            [itemKeys.name] = "Illusionary Rod",
            [itemKeys.npcDrops] = {6487},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217300] = {
            [itemKeys.name] = "Whitemane's Chapeau",
            [itemKeys.npcDrops] = {3977},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217301] = {
            [itemKeys.name] = "Triune Amulet",
            [itemKeys.npcDrops] = {3977},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217302] = {
            [itemKeys.name] = "Mograine's Might",
            [itemKeys.npcDrops] = {3976},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217303] = {
            [itemKeys.name] = "Stoneweaver Leggings",
            [itemKeys.npcDrops] = {7228},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217304] = {
            [itemKeys.name] = "Revelosh's Gloves",
            [itemKeys.npcDrops] = {6910},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217305] = {
            [itemKeys.name] = "Revelosh's Armguards",
            [itemKeys.npcDrops] = {6910},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217306] = {
            [itemKeys.name] = "Revelosh's Boots",
            [itemKeys.npcDrops] = {6910},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217307] = {
            [itemKeys.name] = "Revelosh's Spaulders",
            [itemKeys.npcDrops] = {6910},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217308] = {
            [itemKeys.name] = "Enchanted Sigil: Innovation",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217314] = {
            [itemKeys.name] = "Moonsight Rifle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217315] = {
            [itemKeys.name] = "Precision Bow",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217336] = {
            [itemKeys.name] = "Monster - Incubus Whip Mace1H",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217337] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217338] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217339] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217345] = {
            [itemKeys.name] = "Sebacious Poison",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217346] = {
            [itemKeys.name] = "Numbing Poison",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217347] = {
            [itemKeys.name] = "Atrophic Poison",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217350] = {
            [itemKeys.name] = "Thermaplugg's Engineering Notes",
            [itemKeys.npcDrops] = {218537},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 80324,
        },
        [217351] = {
            [itemKeys.name] = "Thermaplugg's Engineering Notes",
            [itemKeys.npcDrops] = {218537},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 80325,
        },
        [217398] = {
            [itemKeys.name] = "Lesser Arcane Elixir",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217399] = {
            [itemKeys.name] = "Recipe: Lesser Arcane Elixir",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [217495] = {
            [itemKeys.name] = "Scroll of Cryoblast",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217496] = {
            [itemKeys.name] = "Scroll of the Blade",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217497] = {
            [itemKeys.name] = "Narpas Sword",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217609] = {
            [itemKeys.name] = "Talisman of Kazdor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {433596},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217693] = {
            [itemKeys.name] = "Invisibility Potion",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217704] = {
            [itemKeys.name] = "Ironshod Bludgeon",
            [itemKeys.npcDrops] = {7228},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217716] = {
            [itemKeys.name] = "Vile Concoction",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {433067},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217717] = {
            [itemKeys.name] = "Hollow Emblem",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {433066},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217718] = {
            [itemKeys.name] = "Emblem of Blood Magic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217719] = {
            [itemKeys.name] = "Blood Magic Essence",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217720] = {
            [itemKeys.name] = "Offering of Flesh",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {433591},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217721] = {
            [itemKeys.name] = "Offering of Bone",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {433594},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217727] = {
            [itemKeys.name] = "Ward of the Dead",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {433593},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [217736] = {
            [itemKeys.name] = "Rune of the Coterie",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [217737] = {
            [itemKeys.name] = "Modified Talisman",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [218083] = {
            [itemKeys.name] = "Tail of Eranikus",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219147] = {
            [itemKeys.name] = "Rune of Grace",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {214954,233335},
            [itemKeys.startQuest] = nil,
        },
        [219223] = {
            [itemKeys.name] = "Blademaster's Fury",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219326] = {
            [itemKeys.name] = "Seed of Renewal",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219343] = {
            [itemKeys.name] = "Filcher's Cowl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219345] = {
            [itemKeys.name] = "Infernal Lasso",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219399] = {
            [itemKeys.name] = "Nightmare Moss",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {439557},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219401] = {
            [itemKeys.name] = "Cold Iron Ore",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {439558},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219402] = {
            [itemKeys.name] = "Dream-Touched Dragonscale",
            [itemKeys.npcDrops] = {221176,221200,221204},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219404] = {
            [itemKeys.name] = "Shadowscythe",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441114},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219405] = {
            [itemKeys.name] = "Ogre Magi Text",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441113},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219406] = {
            [itemKeys.name] = "Unhatched Green Dragon Egg",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441119},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219414] = {
            [itemKeys.name] = "Shattered Eggshells",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219444] = {
            [itemKeys.name] = "Dreamroot",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {439627},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219445] = {
            [itemKeys.name] = "Fool's Gold Dust",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {439628},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219446] = {
            [itemKeys.name] = "Dream-Infused Dragonscale",
            [itemKeys.npcDrops] = {221259,221260,221265},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219447] = {
            [itemKeys.name] = "Dream-Touched Dragon Egg",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441124},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219448] = {
            [itemKeys.name] = "Dreamengine",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441128},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219449] = {
            [itemKeys.name] = "Azsharan Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441129},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219454] = {
            [itemKeys.name] = "Star Lotus",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {439762},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219486] = {
            [itemKeys.name] = "Starsilver Ore",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {439778},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219487] = {
            [itemKeys.name] = "Starshell",
            [itemKeys.npcDrops] = {221328,221334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219488] = {
            [itemKeys.name] = "Star-Touched Dragonegg",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441133},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219490] = {
            [itemKeys.name] = "Elunar Relic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441140},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219491] = {
            [itemKeys.name] = "Dreampearl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441141},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219514] = {
            [itemKeys.name] = "Moonroot",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {439810},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219515] = {
            [itemKeys.name] = "Greater Moonstone",
            [itemKeys.npcDrops] = {222789},
            [itemKeys.objectDrops] = {439815},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219517] = {
            [itemKeys.name] = "Moondragon Scale",
            [itemKeys.npcDrops] = {221367,221369,221393},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219518] = {
            [itemKeys.name] = "Harpy Screed",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441314},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219519] = {
            [itemKeys.name] = "Mad Keeper's Notes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441312},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219520] = {
            [itemKeys.name] = "Moonglow Dragonegg",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441310},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219526] = {
            [itemKeys.name] = "Mission Brief: Duskwood",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219759] = {
            [itemKeys.name] = "Charla's Field Report",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219770] = {
            [itemKeys.name] = "Gemeron's Field Report",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219771] = {
            [itemKeys.name] = "Thandros' Field Report",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219772] = {
            [itemKeys.name] = "Fallia's Field Report",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219773] = {
            [itemKeys.name] = "Mission Brief: Ashenvale",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219774] = {
            [itemKeys.name] = "Mission Brief: Hinterlands",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219775] = {
            [itemKeys.name] = "Mission Brief: Feralas",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219776] = {
            [itemKeys.name] = "Intelligence Report: Vul'gol Ogre Mound",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219778] = {
            [itemKeys.name] = "Intelligence Report: Rotting Orchard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219803] = {
            [itemKeys.name] = "Intelligence Report: Yorgen Farmstead",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219918] = {
            [itemKeys.name] = "Bloody Missive",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219924] = {
            [itemKeys.name] = "Intelligence Report: Forest Song",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219925] = {
            [itemKeys.name] = "Intelligence Report: Satyrnaar",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219926] = {
            [itemKeys.name] = "Intelligence Report: Warsong Lumber Camp",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219927] = {
            [itemKeys.name] = "Emerald Chip",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219928] = {
            [itemKeys.name] = "Intelligence Report: Agol'watha",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219929] = {
            [itemKeys.name] = "Bloody Missive",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219930] = {
            [itemKeys.name] = "Bloody Missive",
            [itemKeys.npcDrops] = {221575},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81766,
        },
        [219935] = {
            [itemKeys.name] = "Kajind's Blade",
            [itemKeys.npcDrops] = {221651},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219937] = {
            [itemKeys.name] = "Intelligence Report: Shaol'watha",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219938] = {
            [itemKeys.name] = "Intelligence Report: Skulk Rock",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219957] = {
            [itemKeys.name] = "Intelligence Report: Oneiros",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219958] = {
            [itemKeys.name] = "Intelligence Report: Twin Colossals",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219959] = {
            [itemKeys.name] = "Intelligence Report: Ruins of Ravenwind",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219962] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81730,
        },
        [219963] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219965] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission II",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219966] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission II",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81731,
        },
        [219967] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission III",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81732,
        },
        [219968] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission IV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81733,
        },
        [219969] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission V",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81734,
        },
        [219970] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission VI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81735,
        },
        [219971] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission VII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81736,
        },
        [219972] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission VIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81737,
        },
        [219973] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission IX",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81738,
        },
        [219974] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission X",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81739,
        },
        [219975] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission XI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81740,
        },
        [219976] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission XII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81741,
        },
        [219977] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission XIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81742,
        },
        [219978] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission XIV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81743,
        },
        [219979] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission XV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81744,
        },
        [219980] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission XVI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81745,
        },
        [219981] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission XVII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81746,
        },
        [219982] = {
            [itemKeys.name] = "Nightmare Incursions: Duskwood Mission XVIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81747,
        },
        [219983] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission III",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219984] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission IV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219985] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission V",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219986] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission VI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219987] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission VII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219988] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission VIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219989] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission IX",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219990] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission X",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219991] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission XI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219992] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission XII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219993] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission XIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219994] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission XIV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219995] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission XV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219996] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission XVI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219997] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission XVII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219998] = {
            [itemKeys.name] = "Deputization Authorization: Duskwood Mission XVIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219526},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [219999] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81768,
        },
        [220000] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission II",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81769,
        },
        [220001] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission III",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81770,
        },
        [220002] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission IV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81771,
        },
        [220003] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission V",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81772,
        },
        [220004] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission VI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81773,
        },
        [220005] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission VII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81774,
        },
        [220006] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission VIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81775,
        },
        [220007] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission IX",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81776,
        },
        [220008] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission X",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81777,
        },
        [220009] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission XI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81778,
        },
        [220010] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission XII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81779,
        },
        [220011] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission XIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81780,
        },
        [220012] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission XIV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81781,
        },
        [220013] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission XV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81782,
        },
        [220014] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission XVI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81783,
        },
        [220015] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission XVII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81784,
        },
        [220016] = {
            [itemKeys.name] = "Nightmare Incursions: Ashenvale Mission XVIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81785,
        },
        [220017] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81786,
        },
        [220018] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission II",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81787,
        },
        [220019] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission III",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81788,
        },
        [220020] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission IV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81789,
        },
        [220021] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission V",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81817,
        },
        [220022] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission VI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81820,
        },
        [220023] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission VII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81826,
        },
        [220024] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission VIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81830,
        },
        [220025] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission IX",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81832,
        },
        [220026] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission X",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81833,
        },
        [220027] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission XI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81834,
        },
        [220028] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission XII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81835,
        },
        [220029] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission XIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81837,
        },
        [220030] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission XIV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81838,
        },
        [220031] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission XV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81839,
        },
        [220032] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission XVI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81850,
        },
        [220033] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission XVII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81851,
        },
        [220034] = {
            [itemKeys.name] = "Nightmare Incursions: Hinterlands Mission XVIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81852,
        },
        [220035] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81855,
        },
        [220036] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission II",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81856,
        },
        [220037] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission III",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81857,
        },
        [220038] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission IV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81858,
        },
        [220039] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission V",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81859,
        },
        [220040] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission VI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81860,
        },
        [220041] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission VII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81861,
        },
        [220042] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission VIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81863,
        },
        [220043] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission IX",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81864,
        },
        [220044] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission X",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81865,
        },
        [220045] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission XI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81866,
        },
        [220046] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission XII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81867,
        },
        [220047] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission XIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81868,
        },
        [220048] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission XIV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81870,
        },
        [220049] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission XV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81871,
        },
        [220050] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission XVI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81872,
        },
        [220051] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission XVII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81873,
        },
        [220052] = {
            [itemKeys.name] = "Nightmare Incursions: Feralas Mission XVIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81874,
        },
        [220053] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220054] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission II",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220055] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission III",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220056] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission IV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220057] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission V",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220058] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission VI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220059] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission VII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220060] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission VIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220061] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission IX",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220062] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission X",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220063] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission XI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220064] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission XII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220065] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission XIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220066] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission XIV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220067] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission XV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220068] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission XVI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220069] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission XVII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220070] = {
            [itemKeys.name] = "Deputization Authorization: Ashenvale Mission XVIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220071] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220072] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission II",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220073] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission III",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220074] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission IV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220075] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission V",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220076] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission VI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220077] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission VII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220078] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission VIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220079] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission IX",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220080] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission X",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220081] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission XI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220082] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission XII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220083] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission XIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220084] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission XIV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220085] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission XV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220086] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission XVI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220087] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission XVII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220088] = {
            [itemKeys.name] = "Deputization Authorization: Hinterlands Mission XVIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219774},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220089] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220090] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission II",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220091] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission III",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220092] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission IV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220093] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission V",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220094] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission VI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220095] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission VII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220096] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission VIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220097] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission IX",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220098] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission X",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220099] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission XI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220100] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission XII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220101] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission XIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220102] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission XIV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220103] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission XV",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220104] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission XVI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220105] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission XVII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220106] = {
            [itemKeys.name] = "Deputization Authorization: Feralas Mission XVIII",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {219775},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220164] = {
            [itemKeys.name] = "Rune of the Gladiator",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [220165] = {
            [itemKeys.name] = "Rune of Wrath",
            [itemKeys.npcDrops] = {221828},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335},
            [itemKeys.startQuest] = nil,
        },
        [220166] = {
            [itemKeys.name] = "Fiery Infernal Core",
            [itemKeys.npcDrops] = {7135,7136,9878,9879},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220167] = {
            [itemKeys.name] = "Shimmering Grave Dust",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441222},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220168] = {
            [itemKeys.name] = "Triple-Brewed Molten Lager",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {9499},
            [itemKeys.startQuest] = nil,
        },
        [220169] = {
            [itemKeys.name] = "Symbol of Faith",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220170] = {
            [itemKeys.name] = "Note from Gregory",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220173] = {
            [itemKeys.name] = "Parasomnia",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [220213] = {
            [itemKeys.name] = "Fel Lifeblood",
            [itemKeys.npcDrops] = {221740},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220214] = {
            [itemKeys.name] = "Infernal Chain Link",
            [itemKeys.npcDrops] = {6004,6005,6006,6007,6008,6009},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220216] = {
            [itemKeys.name] = "Infernal Lasso",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220217] = {
            [itemKeys.name] = "Rune of the Ravenous",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [220345] = {
            [itemKeys.name] = "Sanguine Sorcery",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220346] = {
            [itemKeys.name] = "Legends of the Tidesages",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441248},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220347] = {
            [itemKeys.name] = "The Liminal and the Arcane",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441249},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220348] = {
            [itemKeys.name] = "Everyday Etiquette",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441250},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220349] = {
            [itemKeys.name] = "Stonewrought Design",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220350] = {
            [itemKeys.name] = "Venomous Journeys",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441252},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220351] = {
            [itemKeys.name] = "Murky Air Sapta",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220352] = {
            [itemKeys.name] = "A Mind of Metal",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441253},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220353] = {
            [itemKeys.name] = "Conjurer's Codex",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441254},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220360] = {
            [itemKeys.name] = "Rune of Efflorescence",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [220375] = {
            [itemKeys.name] = "Fragment of Air",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220379] = {
            [itemKeys.name] = "Torn Shaman's Notes",
            [itemKeys.npcDrops] = {2655,2656},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81960,
        },
        [220446] = {
            [itemKeys.name] = "Otherworldly Treasure",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220510] = {
            [itemKeys.name] = "Elemental Essence",
            [itemKeys.npcDrops] = {5461,5462},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220511] = {
            [itemKeys.name] = "Greathelm of the Nightmare",
            [itemKeys.npcDrops] = {218624},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220512] = {
            [itemKeys.name] = "Immaculate Goldsteel Helmet",
            [itemKeys.npcDrops] = {221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220514] = {
            [itemKeys.name] = "Visor of Verdant Feathers",
            [itemKeys.npcDrops] = {221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220515] = {
            [itemKeys.name] = "Enchanted Emerald Helmet",
            [itemKeys.npcDrops] = {218721},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220516] = {
            [itemKeys.name] = "Gasher's Forgotten Visor",
            [itemKeys.npcDrops] = {221637},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220518] = {
            [itemKeys.name] = "Ba'ham's Dusty Hat",
            [itemKeys.npcDrops] = {218819},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220519] = {
            [itemKeys.name] = "Voodoo Feathered Headdress",
            [itemKeys.npcDrops] = {220833},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220521] = {
            [itemKeys.name] = "Hakkari Ritualist's Headdress",
            [itemKeys.npcDrops] = {220833},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220522] = {
            [itemKeys.name] = "Soulcatcher Crown",
            [itemKeys.npcDrops] = {221637},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220523] = {
            [itemKeys.name] = "Visage of the Exiled",
            [itemKeys.npcDrops] = {218571},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220525] = {
            [itemKeys.name] = "Glowing Fragment of Air",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220526] = {
            [itemKeys.name] = "Sludge-Covered G-7 C.O.R.E. Processor",
            [itemKeys.npcDrops] = {215728,218242,220072},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 81974,
        },
        [220527] = {
            [itemKeys.name] = "Atal'ai Berserker's Mantle",
            [itemKeys.npcDrops] = {218624},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220528] = {
            [itemKeys.name] = "Atal'ai Huntsman's Shoulders",
            [itemKeys.npcDrops] = {221637},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220529] = {
            [itemKeys.name] = "Spaulders of Fanaticism",
            [itemKeys.npcDrops] = {218624},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220530] = {
            [itemKeys.name] = "Will of the Atal'ai Warrior",
            [itemKeys.npcDrops] = {221394},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220531] = {
            [itemKeys.name] = "Undulating Purple Flower",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220532] = {
            [itemKeys.name] = "Reinforced Atal'ai Spaulders",
            [itemKeys.npcDrops] = {221637},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220533] = {
            [itemKeys.name] = "Reforged Atal'ai Breastplate",
            [itemKeys.npcDrops] = {221637},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220534] = {
            [itemKeys.name] = "Eternal Embrace of the Wind Serpent",
            [itemKeys.npcDrops] = {221394},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220535] = {
            [itemKeys.name] = "Garments of the Atal'ai Prophet",
            [itemKeys.npcDrops] = {218721},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220536] = {
            [itemKeys.name] = "Atal'ai Medicine Man's Wrists",
            [itemKeys.npcDrops] = {220833},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220537] = {
            [itemKeys.name] = "Dreamer's Darkwater Bracers",
            [itemKeys.npcDrops] = {218624},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220538] = {
            [itemKeys.name] = "Cursed Slimescale Bracers",
            [itemKeys.npcDrops] = {218819},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220539] = {
            [itemKeys.name] = "Warbands of Sacrifice",
            [itemKeys.npcDrops] = {218624},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220540] = {
            [itemKeys.name] = "Corruption Laden Handguards",
            [itemKeys.npcDrops] = {218819},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220541] = {
            [itemKeys.name] = "Disease-Ridden Plate Fists",
            [itemKeys.npcDrops] = {218819},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220542] = {
            [itemKeys.name] = "Polluted Murkwater Gauntlets",
            [itemKeys.npcDrops] = {218819},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220543] = {
            [itemKeys.name] = "Emerald Scalemail Gloves",
            [itemKeys.npcDrops] = {221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220544] = {
            [itemKeys.name] = "Bloodflare Talons",
            [itemKeys.npcDrops] = {220833},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220545] = {
            [itemKeys.name] = "Foul Smelling Fighter's Gloves",
            [itemKeys.npcDrops] = {218819},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220546] = {
            [itemKeys.name] = "Hands of the Tormented",
            [itemKeys.npcDrops] = {218819},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220547] = {
            [itemKeys.name] = "Gloves of the Fallen Atal'ai Prophet",
            [itemKeys.npcDrops] = {218721},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220548] = {
            [itemKeys.name] = "Atal'ai Hexxer's Gloves",
            [itemKeys.npcDrops] = {221637},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220549] = {
            [itemKeys.name] = "Dawnspire Strap",
            [itemKeys.npcDrops] = {220833},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220550] = {
            [itemKeys.name] = "Temple Looter's Waistband",
            [itemKeys.npcDrops] = {218819},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220551] = {
            [itemKeys.name] = "Devotee's Sash of the Emerald Dream",
            [itemKeys.npcDrops] = {220833},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220552] = {
            [itemKeys.name] = "Waistguard of Pain",
            [itemKeys.npcDrops] = {218819},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220553] = {
            [itemKeys.name] = "Belt of the Forsaken Worshipper",
            [itemKeys.npcDrops] = {221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220554] = {
            [itemKeys.name] = "Atal'alarion's Tusk Band",
            [itemKeys.npcDrops] = {218624},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220555] = {
            [itemKeys.name] = "Atal'ai Serpentscale Girdle",
            [itemKeys.npcDrops] = {221637},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220556] = {
            [itemKeys.name] = "Kilt of the Fallen Atal'ai Prophet",
            [itemKeys.npcDrops] = {218721},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220557] = {
            [itemKeys.name] = "Cursed Windscale Sarong",
            [itemKeys.npcDrops] = {221394},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220558] = {
            [itemKeys.name] = "Atal'ai Assassin's Leggings",
            [itemKeys.npcDrops] = {221637},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220559] = {
            [itemKeys.name] = "Revitalized Drake Scale Leggings",
            [itemKeys.npcDrops] = {221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220560] = {
            [itemKeys.name] = "Silvershell Legplates",
            [itemKeys.npcDrops] = {221637},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220561] = {
            [itemKeys.name] = "Tenacious Troll Kickers",
            [itemKeys.npcDrops] = {218624},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220562] = {
            [itemKeys.name] = "Bloodshot Battle Greaves",
            [itemKeys.npcDrops] = {221394},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220563] = {
            [itemKeys.name] = "Boots of the Atal'ai Blood Shaman",
            [itemKeys.npcDrops] = {221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220564] = {
            [itemKeys.name] = "Restored Slitherscale Boots",
            [itemKeys.npcDrops] = {218571},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220565] = {
            [itemKeys.name] = "Ethereal Mistwalker Boots",
            [itemKeys.npcDrops] = {218819},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220566] = {
            [itemKeys.name] = "Smolder Claw",
            [itemKeys.npcDrops] = {220833},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220567] = {
            [itemKeys.name] = "Bloodied Headspike",
            [itemKeys.npcDrops] = {218624},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220568] = {
            [itemKeys.name] = "Temple Explorer's Gun Axe",
            [itemKeys.npcDrops] = {218624},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220569] = {
            [itemKeys.name] = "Blistering Ragehammer",
            [itemKeys.npcDrops] = {218819},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220570] = {
            [itemKeys.name] = "Mantle of Nightmares",
            [itemKeys.npcDrops] = {222198},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220571] = {
            [itemKeys.name] = "Stinging Longbow",
            [itemKeys.npcDrops] = {218819},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220572] = {
            [itemKeys.name] = "Rinzo's Rapid Repeater",
            [itemKeys.npcDrops] = {221637},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220573] = {
            [itemKeys.name] = "Dreadstalker's Hunting Bow",
            [itemKeys.npcDrops] = {218571},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220574] = {
            [itemKeys.name] = "Sharpened Tooth of Eranikus",
            [itemKeys.npcDrops] = {218571},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220575] = {
            [itemKeys.name] = "Eater of the Damned",
            [itemKeys.npcDrops] = {218721},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220576] = {
            [itemKeys.name] = "Axe of the Atal'ai Executioner",
            [itemKeys.npcDrops] = {218721},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220577] = {
            [itemKeys.name] = "Might of the Blood Loa",
            [itemKeys.npcDrops] = {221394},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220578] = {
            [itemKeys.name] = "Fist of the Forsaken",
            [itemKeys.npcDrops] = {218721},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220579] = {
            [itemKeys.name] = "Witch Doctor's Stick of Mojo",
            [itemKeys.npcDrops] = {218571},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220580] = {
            [itemKeys.name] = "Madness of the Avatar",
            [itemKeys.npcDrops] = {218624},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220581] = {
            [itemKeys.name] = "Snake Clobberer",
            [itemKeys.npcDrops] = {220833},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220582] = {
            [itemKeys.name] = "Dragon's Cry",
            [itemKeys.npcDrops] = {218571},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220583] = {
            [itemKeys.name] = "Vile Blade of the Wretched",
            [itemKeys.npcDrops] = {218721},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220584] = {
            [itemKeys.name] = "Flamebreath Blade",
            [itemKeys.npcDrops] = {220833},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220585] = {
            [itemKeys.name] = "Degraded Dire Nail",
            [itemKeys.npcDrops] = {218571},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220586] = {
            [itemKeys.name] = "Hubris, the Bandit Brander",
            [itemKeys.npcDrops] = {218721},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220587] = {
            [itemKeys.name] = "Sacrificial Dream Dagger",
            [itemKeys.npcDrops] = {220833},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220588] = {
            [itemKeys.name] = "Cobra Fang Claw",
            [itemKeys.npcDrops] = {221394},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220589] = {
            [itemKeys.name] = "Serpent's Striker",
            [itemKeys.npcDrops] = {221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413},
            [itemKeys.startQuest] = nil,
        },
        [220590] = {
            [itemKeys.name] = "Spire of Hakkari Worship",
            [itemKeys.npcDrops] = {221394},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220591] = {
            [itemKeys.name] = "Mijan's Restorative Rod",
            [itemKeys.npcDrops] = {221637},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220594] = {
            [itemKeys.name] = "Scythe of the Dream",
            [itemKeys.npcDrops] = {220833},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220595] = {
            [itemKeys.name] = "Nightmare Focus Staff",
            [itemKeys.npcDrops] = {218571},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220596] = {
            [itemKeys.name] = "Ancient Divining Rod",
            [itemKeys.npcDrops] = {221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220597] = {
            [itemKeys.name] = "Drakestone of the Dream Harbinger",
            [itemKeys.npcDrops] = {221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [220598] = {
            [itemKeys.name] = "Drakestone of the Nightmare Harbinger",
            [itemKeys.npcDrops] = {221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [220599] = {
            [itemKeys.name] = "Drakestone of the Blood Prophet",
            [itemKeys.npcDrops] = {221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [220600] = {
            [itemKeys.name] = "Crest of Preeminence",
            [itemKeys.npcDrops] = {218571},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220601] = {
            [itemKeys.name] = "Hakkari Witch Doctor's Guard",
            [itemKeys.npcDrops] = {218721},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220602] = {
            [itemKeys.name] = "Sewer Turtle Half-Shell",
            [itemKeys.npcDrops] = {218624},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220603] = {
            [itemKeys.name] = "Rod of Irreversible Corrosion",
            [itemKeys.npcDrops] = {218571},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220604] = {
            [itemKeys.name] = "Nightmare Trophy",
            [itemKeys.npcDrops] = {218571},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220605] = {
            [itemKeys.name] = "Libram of Sacrilege",
            [itemKeys.npcDrops] = {218721},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220606] = {
            [itemKeys.name] = "Idol of the Dream",
            [itemKeys.npcDrops] = {221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220607] = {
            [itemKeys.name] = "Totem of Tormented Ancestry",
            [itemKeys.npcDrops] = {221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220608] = {
            [itemKeys.name] = "Featherskin Drape",
            [itemKeys.npcDrops] = {221394},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220609] = {
            [itemKeys.name] = "Drape of Nightfall",
            [itemKeys.npcDrops] = {220833},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220610] = {
            [itemKeys.name] = "Rune of Mental Dexterity",
            [itemKeys.npcDrops] = {222897},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [220611] = {
            [itemKeys.name] = "Hukku's Hex Cape",
            [itemKeys.npcDrops] = {221637},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220612] = {
            [itemKeys.name] = "Rune of Tidal Waves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [220613] = {
            [itemKeys.name] = "Rune of Rolling Thunder",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {442728},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [220615] = {
            [itemKeys.name] = "Panther Fur Cloak",
            [itemKeys.npcDrops] = {218624},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220616] = {
            [itemKeys.name] = "Rune of Overcharged",
            [itemKeys.npcDrops] = {222044},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [220617] = {
            [itemKeys.name] = "Rune of Pandemic",
            [itemKeys.npcDrops] = {223123},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [220618] = {
            [itemKeys.name] = "Rune of Immolation Aura",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [220619] = {
            [itemKeys.name] = "Atal'ai Blood Ceremony",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {235251},
            [itemKeys.startQuest] = nil,
        },
        [220620] = {
            [itemKeys.name] = "Wind Serpent Skull",
            [itemKeys.npcDrops] = {221394},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220621] = {
            [itemKeys.name] = "Nightmare Resonance Crystal",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [220622] = {
            [itemKeys.name] = "Perfectly Preserved Dragon's Eye",
            [itemKeys.npcDrops] = {218571},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220623] = {
            [itemKeys.name] = "Jin'do's Lost Locket",
            [itemKeys.npcDrops] = {218721},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220624] = {
            [itemKeys.name] = "Bloodstained Charm of Valor",
            [itemKeys.npcDrops] = {218721},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220625] = {
            [itemKeys.name] = "Resilience of the Exiled",
            [itemKeys.npcDrops] = {218721},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220626] = {
            [itemKeys.name] = "Drakeclaw Band of the Berserker",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220627] = {
            [itemKeys.name] = "Drakeclaw Band of the Stalker",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220628] = {
            [itemKeys.name] = "Drakeclaw Band of the Harbinger",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220629] = {
            [itemKeys.name] = "Drakeclaw Band of the Blood Prophet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220630] = {
            [itemKeys.name] = "Drakeclaw Band of the Juggernaut",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220632] = {
            [itemKeys.name] = "Atal'ai Blood Ritual Medallion",
            [itemKeys.npcDrops] = {221394},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220633] = {
            [itemKeys.name] = "Atal'ai Blood Ritual Badge",
            [itemKeys.npcDrops] = {221394},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220634] = {
            [itemKeys.name] = "Atal'ai Blood Ritual Charm",
            [itemKeys.npcDrops] = {221394},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220635] = {
            [itemKeys.name] = "Atal'alarion's Enchanted Boulder",
            [itemKeys.npcDrops] = {218624},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {235251},
            [itemKeys.startQuest] = nil,
        },
        [220636] = {
            [itemKeys.name] = "Atal'ai Blood Icon",
            [itemKeys.npcDrops] = {218571,218624,218721,218819,220833,221394,221637,221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220637] = {
            [itemKeys.name] = "Atal'ai Ritual Token",
            [itemKeys.npcDrops] = {218571,218624,218721,218819,220833,221394,221637,221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220638] = {
            [itemKeys.name] = "Unorthodox Hex Stick",
            [itemKeys.npcDrops] = {221637},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {235251},
            [itemKeys.startQuest] = nil,
        },
        [220639] = {
            [itemKeys.name] = "Lledra's Inanimator",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101,235251},
            [itemKeys.startQuest] = nil,
        },
        [220642] = {
            [itemKeys.name] = "Banished Martyr's Plate Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220643] = {
            [itemKeys.name] = "Banished Martyr's Plate Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220648] = {
            [itemKeys.name] = "Banished Martyr's Plate Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220649] = {
            [itemKeys.name] = "Merithra's Inheritence",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [220650] = {
            [itemKeys.name] = "Obsessed Prophet's Chestplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220651] = {
            [itemKeys.name] = "Obsessed Prophet's Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220652] = {
            [itemKeys.name] = "Obsessed Prophet's Ornate Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220653] = {
            [itemKeys.name] = "Wailing Berserker's Chestplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220654] = {
            [itemKeys.name] = "Wailing Berserker's Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220656] = {
            [itemKeys.name] = "Wailing Berserker's Battleboots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220657] = {
            [itemKeys.name] = "Ostracized Berserker's Hauberk",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220658] = {
            [itemKeys.name] = "Ostracized Berserker's Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220659] = {
            [itemKeys.name] = "Ostracized Berserker's Chain Greaves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220660] = {
            [itemKeys.name] = "Shunned Devotee's Chainshirt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220661] = {
            [itemKeys.name] = "Shunned Devotee's Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220662] = {
            [itemKeys.name] = "Shunned Devotee's Scale Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220663] = {
            [itemKeys.name] = "Corrupted Spiritweaver's Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220664] = {
            [itemKeys.name] = "Corrupted Spiritweaver's Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220665] = {
            [itemKeys.name] = "Corrupted Spiritweaver's Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220666] = {
            [itemKeys.name] = "Dread Hunter's Chainmail",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220667] = {
            [itemKeys.name] = "Dread Hunter's Chausses",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220668] = {
            [itemKeys.name] = "Dread Hunter's Greaves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220669] = {
            [itemKeys.name] = "Exiled Prophet's Jerkin",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220670] = {
            [itemKeys.name] = "Exiled Prophet's Slippers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220671] = {
            [itemKeys.name] = "Exiled Prophet's Leather Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220672] = {
            [itemKeys.name] = "Lost Worshipper's Harness",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220673] = {
            [itemKeys.name] = "Lost Worshipper's Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220674] = {
            [itemKeys.name] = "Debased Stealthblade",
            [itemKeys.npcDrops] = {221637},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220675] = {
            [itemKeys.name] = "Lost Worshipper's Treads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220676] = {
            [itemKeys.name] = "Blood Corrupted Tunic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220677] = {
            [itemKeys.name] = "Blood Corrupted Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220678] = {
            [itemKeys.name] = "Blood Corrupted Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220679] = {
            [itemKeys.name] = "Malevolent Prophet's Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220680] = {
            [itemKeys.name] = "Malevolent Prophet's Vest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220681] = {
            [itemKeys.name] = "Malevolent Prophet's Sandals",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220682] = {
            [itemKeys.name] = "Rune of the Unbridled",
            [itemKeys.npcDrops] = {222233},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [220683] = {
            [itemKeys.name] = "Benevolent Prophet's Vest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220684] = {
            [itemKeys.name] = "Benevolent Prophet's Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220685] = {
            [itemKeys.name] = "Benevolent Prophet's Sandals",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220686] = {
            [itemKeys.name] = "Chieftain's Bane",
            [itemKeys.npcDrops] = {221394},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220687] = {
            [itemKeys.name] = "Rune of the Raptor",
            [itemKeys.npcDrops] = {222243},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [220688] = {
            [itemKeys.name] = "Inert Mantle of Nightmares",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {214954},
            [itemKeys.startQuest] = nil,
        },
        [220689] = {
            [itemKeys.name] = "Void-Powered Vambraces",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220738] = {
            [itemKeys.name] = "Shoulderplates of Dread",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220739] = {
            [itemKeys.name] = "Baleful Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220740] = {
            [itemKeys.name] = "Fearmonger's Shoulderguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220741] = {
            [itemKeys.name] = "Screaming Chain Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220742] = {
            [itemKeys.name] = "Shrieking Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220743] = {
            [itemKeys.name] = "Cacophonous Chain Shoulderguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220744] = {
            [itemKeys.name] = "Wailing Chain Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220745] = {
            [itemKeys.name] = "Membrane of Dark Neurosis",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220747] = {
            [itemKeys.name] = "Paranoia Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220748] = {
            [itemKeys.name] = "Shoulderpads of Obsession",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220749] = {
            [itemKeys.name] = "Mantle of Insanity",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220750] = {
            [itemKeys.name] = "Fractured Mind Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220751] = {
            [itemKeys.name] = "Shoulderpads of the Deranged",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220754] = {
            [itemKeys.name] = "Rune of the Windstorm",
            [itemKeys.npcDrops] = {222286},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [220775] = {
            [itemKeys.name] = "Engineering Exchange Ticket",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220778] = {
            [itemKeys.name] = "Coagulated Bloodguard Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220779] = {
            [itemKeys.name] = "Coagulated Bloodguard Tunic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220780] = {
            [itemKeys.name] = "Coagulated Bloodguard Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220781] = {
            [itemKeys.name] = "Nightmare Prophet's Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220783] = {
            [itemKeys.name] = "Nightmare Prophet's Vestments",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220784] = {
            [itemKeys.name] = "Nightmare Prophet's Sandals",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222413,224328},
            [itemKeys.startQuest] = nil,
        },
        [220791] = {
            [itemKeys.name] = "Rune of the Jungle Cat",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [220792] = {
            [itemKeys.name] = "Scroll of Spatial Mending",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220794] = {
            [itemKeys.name] = "Knight's Plate Hauberk",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220795] = {
            [itemKeys.name] = "Knight-Lieutenant's Plate Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220796] = {
            [itemKeys.name] = "Blood Guard's Plate Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220797] = {
            [itemKeys.name] = "Knight's Plate Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220798] = {
            [itemKeys.name] = "Stone Guard's Plate Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220799] = {
            [itemKeys.name] = "Sergeant Major's Plate Greaves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220800] = {
            [itemKeys.name] = "First Sergeant's Plate Greaves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220801] = {
            [itemKeys.name] = "Stone Guard's Plate Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220803] = {
            [itemKeys.name] = "Blood Guard's Plate Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220804] = {
            [itemKeys.name] = "Knight-Lieutenant's Plate Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220806] = {
            [itemKeys.name] = "Sergeant Major's Plate Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220807] = {
            [itemKeys.name] = "First Sergeant's Plate Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220808] = {
            [itemKeys.name] = "Knight-Lieutenant's Imbued Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220809] = {
            [itemKeys.name] = "Knight's Imbued Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220810] = {
            [itemKeys.name] = "Knight-Lieutenant's Imbued Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220811] = {
            [itemKeys.name] = "Sergeant Major's Imbued Greaves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220812] = {
            [itemKeys.name] = "Sergeant Major's Imbued Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220813] = {
            [itemKeys.name] = "Knight's Imbued Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220814] = {
            [itemKeys.name] = "Sergeant Major's Lamellar Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220815] = {
            [itemKeys.name] = "Knight's Lamellar Chestplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220816] = {
            [itemKeys.name] = "Knight's Lamellar Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220817] = {
            [itemKeys.name] = "Sergeant Major's Lamellar Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220818] = {
            [itemKeys.name] = "Knight-Lieutenant's Lamellar Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220819] = {
            [itemKeys.name] = "Knight-Lieutenant's Lamellar Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220820] = {
            [itemKeys.name] = "Blood Guard's Mail Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220821] = {
            [itemKeys.name] = "Blood Guard's Chain Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220822] = {
            [itemKeys.name] = "Knight-Lieutenant's Chain Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220823] = {
            [itemKeys.name] = "Blood Guard's Mail Epaulets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220824] = {
            [itemKeys.name] = "Blood Guard's Chain Epaulets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220825] = {
            [itemKeys.name] = "Knight-Lieutenant's Chain Epaulets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220826] = {
            [itemKeys.name] = "Stone Guard's Mail Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220827] = {
            [itemKeys.name] = "Stone Guard's Chain Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220828] = {
            [itemKeys.name] = "Knight's Chain Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220829] = {
            [itemKeys.name] = "Sergeant Major's Chain Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220830] = {
            [itemKeys.name] = "First Sergeant's Chain Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220831] = {
            [itemKeys.name] = "First Sergeant's Mail Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220832] = {
            [itemKeys.name] = "Knight's Chain Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220833] = {
            [itemKeys.name] = "Stone Guard's Chain Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220834] = {
            [itemKeys.name] = "Stone Guard's Mail Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220835] = {
            [itemKeys.name] = "First Sergeant's Mail Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220836] = {
            [itemKeys.name] = "First Sergeant's Chain Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220837] = {
            [itemKeys.name] = "Sergeant Major's Chain Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220838] = {
            [itemKeys.name] = "Stone Guard's Inscribed Chestpiece",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220839] = {
            [itemKeys.name] = "Stone Guard's Inscribed Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220840] = {
            [itemKeys.name] = "First Sergeant's Inscribed Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220841] = {
            [itemKeys.name] = "Blood Guard's Inscribed Shoulder Pads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220842] = {
            [itemKeys.name] = "Blood Guard's Inscribed Skullcap",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220843] = {
            [itemKeys.name] = "First Sergeant's Inscribed Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220844] = {
            [itemKeys.name] = "Stone Guard's Pulsing Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220845] = {
            [itemKeys.name] = "First Sergeant's Pulsing Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220846] = {
            [itemKeys.name] = "First Sergeant's Pulsing Greaves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220847] = {
            [itemKeys.name] = "Stone Guard's Pulsing Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220848] = {
            [itemKeys.name] = "Blood Guard's Pulsing Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220849] = {
            [itemKeys.name] = "Blood Guard's Pulsing Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220850] = {
            [itemKeys.name] = "Knight-Lieutenant's Leather Headband",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220851] = {
            [itemKeys.name] = "Blood Guard's Leather Headband",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220852] = {
            [itemKeys.name] = "Knight-Lieutenant's Leather Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220853] = {
            [itemKeys.name] = "Blood Guard's Leather Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220854] = {
            [itemKeys.name] = "Knight's Leather Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220855] = {
            [itemKeys.name] = "Stone Guard's Leather Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220856] = {
            [itemKeys.name] = "Sergeant Major's Leather Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220857] = {
            [itemKeys.name] = "First Sergeant's Leather Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220858] = {
            [itemKeys.name] = "Knight's Leather Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220859] = {
            [itemKeys.name] = "Stone Guard's Leather Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220860] = {
            [itemKeys.name] = "Sergeant Major's Leather Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220861] = {
            [itemKeys.name] = "First Sergeant's Leather Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220862] = {
            [itemKeys.name] = "Sergeant Major's Crackling Leather Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220863] = {
            [itemKeys.name] = "First Sergeant's Crackling Leather Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220864] = {
            [itemKeys.name] = "Knight's Crackling Leather Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220865] = {
            [itemKeys.name] = "Stone Guard's Crackling Leather Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220866] = {
            [itemKeys.name] = "Sergeant Major's Crackling Leather Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220867] = {
            [itemKeys.name] = "First Sergeant's Crackling Leather Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220868] = {
            [itemKeys.name] = "Knight's Crackling Leather Tunic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220869] = {
            [itemKeys.name] = "Stone Guard's Crackling Leather Tunic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220870] = {
            [itemKeys.name] = "Knight-Lieutenant's Crackling Leather Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220871] = {
            [itemKeys.name] = "Blood Guard's Crackling Leather Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220872] = {
            [itemKeys.name] = "Knight-Lieutenant's Crackling Leather Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220873] = {
            [itemKeys.name] = "Blood Guard's Crackling Leather Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220874] = {
            [itemKeys.name] = "Knight-Lieutenant's Restored Leather Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220875] = {
            [itemKeys.name] = "Blood Guard's Restored Leather Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220876] = {
            [itemKeys.name] = "Knight-Lieutenant's Restored Leather Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220877] = {
            [itemKeys.name] = "Blood Guard's Restored Leather Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220878] = {
            [itemKeys.name] = "Knight's Restored Leather Jerkin",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220879] = {
            [itemKeys.name] = "Stone Guard's Restored Leather Jerkin",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220880] = {
            [itemKeys.name] = "Sergeant Major's Restored Leather Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220881] = {
            [itemKeys.name] = "First Sergeant's Restored Leather Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220882] = {
            [itemKeys.name] = "Knight's Restored Leather Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220883] = {
            [itemKeys.name] = "Stone Guard's Restored Leather Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220884] = {
            [itemKeys.name] = "Sergeant Major's Restored Leather Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220885] = {
            [itemKeys.name] = "First Sergeant's Restored Leather Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220886] = {
            [itemKeys.name] = "Knight's Dreadweave Vest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220887] = {
            [itemKeys.name] = "Knight-Lieutenant's Dreadweave Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220888] = {
            [itemKeys.name] = "Knight's Dreadweave Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220889] = {
            [itemKeys.name] = "Knight-Lieutenant's Dreadweave Hat",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220890] = {
            [itemKeys.name] = "Sergeant Major's Dreadweave Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220891] = {
            [itemKeys.name] = "Sergeant Major's Dreadweave Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220892] = {
            [itemKeys.name] = "Knight's Satin Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220893] = {
            [itemKeys.name] = "Knight's Satin Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220894] = {
            [itemKeys.name] = "Knight-Lieutenant's Satin Pads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220895] = {
            [itemKeys.name] = "Sergeant Major's Satin Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220896] = {
            [itemKeys.name] = "Knight-Lieutenant's Satin Cover",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [220897] = {
            [itemKeys.name] = "Sergeant Major's Satin Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [220898] = {
            [itemKeys.name] = "First Sergeant's Satin Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220899] = {
            [itemKeys.name] = "Blood Guard's Satin Cover",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220900] = {
            [itemKeys.name] = "First Sergeant's Satin Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220901] = {
            [itemKeys.name] = "Blood Guard's Satin Pads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220902] = {
            [itemKeys.name] = "Stone Guard's Satin Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220903] = {
            [itemKeys.name] = "Stone Guard's Satin Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220904] = {
            [itemKeys.name] = "Stone Guard's Dreadweave Vest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220905] = {
            [itemKeys.name] = "Blood Guard's Dreadweave Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220906] = {
            [itemKeys.name] = "Stone Guard's Dreadweave Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220907] = {
            [itemKeys.name] = "Blood Guard's Dreadweave Hat",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [220908] = {
            [itemKeys.name] = "First Sergeant's Dreadweave Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220909] = {
            [itemKeys.name] = "First Sergeant's Dreadweave Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792,12799},
            [itemKeys.startQuest] = nil,
        },
        [220912] = {
            [itemKeys.name] = "Geode Hammer",
            [itemKeys.npcDrops] = {2649,2650,2651,2652,2653,2654},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220913] = {
            [itemKeys.name] = "Rune of Demolition",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {220914},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [220914] = {
            [itemKeys.name] = "Broken Geode Hammer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220915] = {
            [itemKeys.name] = "Idol of the Raging Shambler",
            [itemKeys.npcDrops] = {5465,5481,5485,5490,9396},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [220916] = {
            [itemKeys.name] = "Thunderstomp Stegodon Horn",
            [itemKeys.npcDrops] = {6504},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220917] = {
            [itemKeys.name] = "Box of Scarlet Dye",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {442742},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220918] = {
            [itemKeys.name] = "Waylaid Supplies: Undermine Clam Chowder",
            [itemKeys.npcDrops] = {1488,1489,1490,1550,1551,1784,1795,1804,1812,1813,1816,1833,1835,2522,2546,2656,2691,2692,2894,2925,2929,4324,4328,4331,4334,4475,4494,5237,5240,5245,5246,5253,5254,5260,5295,5299,5300,5305,5332,5333,5424,5450,5451,5471,5472,5485,5616,5617,5839,5840,5979,5988,5996,6007,6116,6117,6135,6137,6138,6194,6195,6196,6199,6200,6222,6350,6505,6509,6516,6521,6527,6559,7011,7028,7034,7036,7038,7047,7098,7101,7112,7114,7120,7139,7153,7154,7155,7268,7369,7371,7372,7379,7396,7397,7405,7431,7438,7441,7442,7458,7459,7855,7858,8301,8504,8520,8528,8532,8541,8542,8546,8560,8566,8766,8896,8900,8902,8904,8913,8926,9398,9416,9454,9545,9622,9683,9690,9701,9862,9956,10040,10177,10316,10390,10442,10481,10661,10801,10816,10919,11291,11476,11516,11737,12216,12378,12387,13276,221258,221260,221261,221262,221263,221312,221324,221326,221328,221361,221364,221365,221369,221370,221371,221375,224243,224244,224257,228612,228719,228747,228909,229802},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220919] = {
            [itemKeys.name] = "Waylaid Supplies: Nightfin Soup",
            [itemKeys.npcDrops] = {730,752,1088,1488,1491,1565,1802,1804,1812,1813,1815,1816,1821,1822,1826,1835,2550,2655,2725,2929,4328,4329,4466,4467,4475,5232,5240,5253,5278,5295,5297,5331,5335,5421,5423,5428,5452,5471,5473,5474,5475,5852,5854,5858,5988,6005,6006,6117,6126,6137,6193,6196,6198,6224,6349,6375,6506,6518,6527,6559,7011,7026,7028,7033,7034,7035,7038,7097,7114,7115,7118,7120,7138,7155,7268,7269,7371,7405,7431,7434,7438,7439,7440,7454,7458,7459,7523,7524,7668,7670,7727,7864,7902,8504,8519,8523,8525,8532,8534,8542,8545,8546,8548,8550,8551,8560,8566,8598,8601,8603,8759,8897,8900,8902,8904,8915,8916,8920,8928,8960,9398,9547,9701,9862,9916,10078,10177,10221,10316,10375,10411,10442,10480,10481,10485,10659,10660,10678,10916,11360,11368,11476,11735,11873,12051,12203,13276,13617,14460,221257,221258,221260,221262,221326,221330,221361,221369,221370,221371,221407,221408,224243,224244,224257,228909},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220920] = {
            [itemKeys.name] = "Waylaid Supplies: Tender Wolf Steaks",
            [itemKeys.npcDrops] = {669,784,1490,1785,1787,1802,1812,1826,1835,2651,2694,2716,2718,2928,2929,2944,4323,4324,4331,4334,4389,4472,4475,4493,4494,4506,5236,5240,5247,5253,5254,5260,5278,5292,5293,5295,5296,5299,5307,5334,5336,5361,5362,5451,5458,5474,5481,5490,5840,5976,5977,5978,5979,5991,6004,6005,6006,6010,6188,6196,6222,6375,6505,6506,6510,6517,6527,6551,6555,7011,7026,7027,7034,7035,7037,7038,7047,7055,7092,7110,7112,7149,7369,7371,7372,7396,7440,7444,7458,7460,7523,7855,7857,8337,8504,8521,8525,8532,8539,8540,8541,8545,8546,8550,8555,8556,8837,8900,8902,8904,8913,8915,8916,8920,8925,8927,8928,8932,8957,9376,9462,9683,9691,9861,9877,10177,10221,10411,10442,10605,10660,10678,10801,10919,11360,11476,11477,11598,11736,12053,12216,12248,12380,13136,13276,13358,14185,14400,221258,221260,221261,221262,221263,221326,221330,221369,221371,221375,221377,224243,224244,224257,228747,228909},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220921] = {
            [itemKeys.name] = "Waylaid Supplies: Heavy Mageweave Bandages",
            [itemKeys.npcDrops] = {766,1087,1491,1561,1564,1791,1793,1795,1806,1808,1812,1815,1821,1883,2522,2649,2651,2691,2692,2725,2734,2736,2925,4323,4334,4466,4494,4841,5229,5232,5237,5260,5278,5292,5293,5297,5336,5361,5421,5428,5429,5454,5471,5472,5490,5615,5999,6005,6010,6126,6135,6138,6190,6196,6198,6199,6200,6202,6224,6352,6370,6375,6509,6513,6516,6517,6518,6527,6553,6559,7025,7028,7033,7034,7035,7038,7047,7091,7092,7099,7100,7105,7112,7115,7126,7155,7269,7369,7379,7396,7438,7441,7447,7450,7453,7457,7458,7459,7523,7808,7809,7855,7856,8337,8504,8519,8523,8535,8543,8545,8548,8556,8561,8562,8603,8637,8766,8896,8897,8900,8902,8915,8916,8920,8926,8957,9462,9545,9862,9877,10316,10390,10411,10442,10480,10605,10659,10816,10916,11196,11291,11368,11476,11477,11553,11686,11687,11738,11741,12203,12216,12380,13276,13332,13599,14188,15542,221260,221261,221262,221263,221326,221330,221369,221371,221375,221377,224243,224244,224256,224257,228719,228726,228747},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220922] = {
            [itemKeys.name] = "Waylaid Supplies: Sungrass",
            [itemKeys.npcDrops] = {731,745,746,783,1551,1558,1562,1564,1653,1793,1802,1813,1817,1821,1833,2530,2534,2547,2652,2694,2924,4323,4324,4334,4474,4475,4494,5237,5240,5255,5278,5287,5293,5295,5333,5360,5364,5424,5425,5430,5460,5472,5474,5485,5618,5840,5844,5857,5978,5982,5991,5999,6189,6193,6194,6196,6200,6201,6224,6506,6514,6518,6527,6551,6554,6557,7011,7026,7027,7028,7035,7047,7100,7101,7106,7109,7112,7115,7120,7153,7154,7157,7158,7369,7371,7396,7405,7438,7443,7449,7450,7458,7726,7848,7855,7856,8527,8531,8532,8535,8540,8545,8546,8551,8561,8562,8566,8600,8603,8607,8761,8766,8896,8897,8900,8902,8904,8913,8915,8920,8926,8928,9462,9464,9543,9547,9701,9879,9956,10177,10391,10411,10442,10481,10485,10648,10659,11290,11368,11476,11611,11686,11741,11789,12046,12216,12217,12218,12250,13276,14187,15756,221258,221260,221262,221263,221326,221369,221375,221377,224243,224244,224257},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220923] = {
            [itemKeys.name] = "Waylaid Supplies: Dreamfoil",
            [itemKeys.npcDrops] = {744,1551,1562,1563,1565,1783,1789,1806,1808,1812,1813,1816,1822,1826,1831,1883,1907,2536,2640,2655,2692,2694,2730,2736,2791,2925,2929,4323,4329,4404,4466,4472,4474,4493,5232,5236,5244,5245,5249,5254,5268,5274,5278,5292,5293,5296,5334,5335,5336,5420,5461,5473,5474,5475,5481,5485,5490,5617,5623,5840,5850,5855,5981,5985,5988,6005,6116,6117,6125,6127,6188,6195,6196,6198,6199,6200,6202,6224,6349,6371,6377,6551,6559,7011,7026,7028,7029,7035,7039,7047,7048,7098,7100,7114,7153,7376,7397,7438,7439,7442,7445,7449,7450,7452,7456,7457,7459,7524,7725,7727,7855,7856,7899,8519,8521,8526,8532,8535,8538,8540,8557,8558,8560,8562,8600,8603,8606,8897,8902,8904,8916,8920,8926,8928,9166,9545,9622,9878,10316,10411,10442,10481,10485,10605,10916,11368,11516,11598,11611,11738,11741,12262,13358,14188,14282,221258,221260,221261,221262,221263,221324,221326,221330,221360,221361,221364,221365,221369,221371,221377,224243,224244,224257,228747},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220924] = {
            [itemKeys.name] = "Waylaid Supplies: Truesilver Bars",
            [itemKeys.npcDrops] = {672,675,730,747,766,782,1490,1491,1552,1562,1564,1653,1783,1787,1794,1806,1808,1817,1822,1826,1833,1848,1883,2535,2650,2651,2652,2654,2694,2717,2725,2736,2831,4405,4472,4474,4505,4506,5236,5238,5278,5293,5295,5299,5307,5333,5366,5419,5421,5422,5427,5430,5471,5474,5485,5856,5881,5999,6004,6117,6125,6137,6193,6194,6198,6199,6200,6512,6518,6519,7011,7034,7037,7038,7092,7093,7105,7108,7113,7114,7115,7139,7153,7157,7371,7430,7439,7440,7444,7448,7453,7457,7458,7459,7460,7523,7726,7856,7857,8521,8522,8525,8528,8530,8535,8540,8542,8557,8562,8598,8761,8837,8896,8897,8900,8902,8904,8915,8916,8927,8933,8958,9165,9166,9462,9464,9543,9547,9701,9862,10177,10221,10316,10411,10480,10605,10661,10916,11290,11476,11477,11613,11686,11737,11744,11746,11789,12053,12199,12216,12217,12248,12263,14342,221260,221261,221262,221263,221324,221326,221369,221375,221377,222243,224243,224244,224257,228729,228909,229802,232558},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = {228615},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220925] = {
            [itemKeys.name] = "Waylaid Supplies: Thorium Bars",
            [itemKeys.npcDrops] = {669,750,751,752,1784,1785,1787,1791,1802,1804,1806,1813,1816,1817,1835,1883,2522,2546,2549,2650,2655,2736,2745,2831,2945,4324,4331,4334,4399,4493,4494,4506,4841,5232,5236,5241,5253,5260,5278,5295,5299,5300,5308,5420,5421,5428,5461,5474,5475,5481,5485,5490,5615,5839,5850,5977,5993,5999,6004,6005,6117,6125,6126,6127,6190,6196,6198,6511,6518,7011,7025,7028,7029,7035,7036,7038,7047,7098,7100,7108,7110,7112,7153,7154,7156,7372,7396,7405,7434,7439,7443,7447,7460,7584,7671,7727,7808,7883,8504,8521,8524,8530,8532,8542,8546,8550,8551,8578,8596,8598,8637,8667,8759,8761,8896,8900,8902,8904,8913,8915,8920,8922,8927,8932,9162,9396,9416,9462,9464,9477,9545,9547,9701,10177,10316,10375,10411,10442,10480,10485,10605,10659,10660,10801,10919,11368,11476,11739,11783,11880,11881,12203,13136,13257,13276,14400,221260,221261,221262,221263,221312,221326,221328,221361,221369,221371,221375,221407,224243,224244},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220926] = {
            [itemKeys.name] = "Waylaid Supplies: Rugged Leather",
            [itemKeys.npcDrops] = {746,747,752,1087,1558,1802,1808,1812,1813,1821,1835,1884,2521,2537,2656,2657,2659,2692,2693,2725,2736,2925,4324,4334,4405,4467,4475,4494,4505,5229,5234,5251,5253,5255,5292,5293,5299,5304,5305,5331,5333,5334,5364,5366,5424,5453,5455,5461,5471,5472,5481,5840,5853,5855,5977,5979,5984,5988,6004,6006,6007,6116,6125,6189,6193,6194,6196,6514,6555,6559,7011,7026,7027,7028,7033,7035,7086,7091,7105,7106,7107,7108,7110,7115,7120,7138,7157,7369,7371,7376,7438,7439,7440,7450,7454,7458,7459,7460,7668,7725,7727,7848,7858,7864,8337,8442,8521,8527,8529,8530,8540,8541,8542,8565,8896,8902,8904,8913,8916,8920,8927,8959,9462,9464,9518,9605,9683,9695,9696,9878,9956,10177,10316,10391,10411,10442,10481,10605,10678,11291,11598,11611,11613,11685,11741,11880,12053,12203,12217,12218,12418,14400,14564,221260,221261,221263,221326,221330,221369,221371,221375,221377,221406,221408,222243,224243,224244,224257,228727,229802},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220927] = {
            [itemKeys.name] = "Waylaid Supplies: Thick Hide",
            [itemKeys.npcDrops] = {752,1551,1565,1653,1784,1796,1808,1812,1831,1833,1835,1883,1884,2541,2640,2656,2658,2692,2693,2694,2717,2720,2791,2945,4329,4331,4472,4474,4505,5232,5234,5239,5246,5247,5254,5255,5260,5293,5295,5296,5299,5300,5336,5361,5419,5420,5421,5426,5428,5461,5474,5475,5623,5839,5857,5881,5990,5991,5993,6006,6009,6127,6136,6137,6138,6185,6194,6195,6347,6350,6370,6377,6507,6508,6527,7011,7025,7026,7029,7032,7033,7034,7036,7048,7092,7099,7111,7112,7114,7120,7138,7153,7369,7371,7372,7396,7405,7433,7438,7439,7459,7460,7808,7858,7864,8523,8525,8527,8540,8541,8548,8556,8560,8766,8897,8900,8902,8904,8913,8916,8920,8927,8977,9416,9462,9464,9545,9683,9701,9862,10316,10411,10480,10481,10605,10660,10801,10916,11290,11477,11685,11686,11687,11737,11873,12046,12179,13036,221260,221262,221263,221324,221326,221361,221364,221370,221371,221377,221406,221407,224243,224244,224257},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220928] = {
            [itemKeys.name] = "Waylaid Supplies: Enchanted Thorium Bars",
            [itemKeys.npcDrops] = {675,742,750,752,766,1061,1488,1489,1793,1806,1808,1812,1813,1815,1822,1831,2640,2650,2691,2717,2725,2929,4393,4404,4475,4494,5232,5246,5249,5253,5255,5258,5260,5274,5278,5304,5333,5360,5361,5366,5471,5472,5485,5490,5623,5840,5850,5854,5858,5977,5978,6126,6135,6189,6195,6196,6200,6201,6222,6224,6349,6377,6518,6555,6556,7011,7025,7026,7029,7033,7035,7047,7097,7100,7101,7105,7115,7138,7153,7156,7157,7369,7370,7371,7372,7396,7431,7439,7440,7444,7453,7454,7459,7460,7524,7725,7856,7857,7883,8519,8520,8521,8526,8531,8532,8541,8548,8551,8556,8561,8562,8566,8897,8902,8913,8917,8920,8922,8927,8928,8932,9454,9462,9545,9547,9696,9701,9956,10177,10316,10442,10480,10481,10485,10605,10661,11290,11368,11477,11598,11613,11739,11741,11783,12046,12051,12217,12379,13160,13328,14400,14491,15542,221230,221260,221263,221326,221330,221360,221361,221369,221375,221377,221651,224243,224244,224257,228727,228729,229802},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220929] = {
            [itemKeys.name] = "Waylaid Supplies: Superior Mana Potions",
            [itemKeys.npcDrops] = {750,1488,1552,1561,1565,1653,1787,1791,1802,1817,1824,1826,1884,2521,2535,2536,2537,2651,2654,2656,2657,2691,2692,2693,2694,2716,2717,2718,2725,2924,4323,4328,4331,4493,4505,5232,5237,5255,5262,5268,5299,5334,5357,5422,5426,5428,5461,5473,5475,5485,5490,5623,5846,5985,5990,6126,6127,6190,6193,6195,6196,6198,6199,6202,6222,6348,6510,6517,6518,6551,6552,6553,6555,6557,6559,7011,7025,7027,7028,7029,7033,7034,7035,7036,7037,7106,7107,7111,7112,7114,7126,7154,7156,7371,7405,7431,7449,7452,7460,7808,7847,7848,7855,7856,7857,8504,8520,8528,8532,8535,8550,8560,8596,8603,8637,8667,8766,8897,8902,8913,8917,8926,8928,9163,9477,9545,9683,9690,9878,10316,10390,10411,10442,10480,10485,10580,10678,10801,10916,11290,11291,11368,11476,11611,11737,11738,11746,11783,12203,12217,12380,13036,13276,15752,221257,221258,221260,221262,221263,221326,221330,221333,221361,221369,221377,222243,224243,224244,224257,228727,228909,229802},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220930] = {
            [itemKeys.name] = "Waylaid Supplies: Major Healing Potions",
            [itemKeys.npcDrops] = {675,676,746,784,1087,1491,1561,1787,1795,1802,1806,1813,1815,1835,1883,2639,2649,2655,2656,2693,2694,2924,4331,4334,4389,4402,4405,4467,4475,4493,4506,5232,5236,5239,5241,5244,5249,5251,5255,5276,5295,5299,5308,5334,5336,5419,5424,5425,5462,5475,5485,5616,5854,5858,5977,5984,5990,5993,6004,6005,6125,6135,6137,6138,6190,6200,6224,6370,6511,6517,6519,6527,6556,6557,7033,7034,7035,7036,7037,7038,7039,7047,7048,7093,7099,7109,7114,7118,7126,7139,7155,7156,7157,7269,7371,7372,7431,7439,7452,7459,7523,7584,7668,7727,7809,7883,8337,8442,8504,8528,8529,8538,8539,8555,8562,8598,8675,8897,8900,8902,8904,8916,8932,8960,9165,9416,9462,9547,9690,9696,9698,10177,10221,10316,10411,10442,10481,10605,10648,10659,10678,10816,10919,11290,11368,11476,11611,11686,11687,11741,12203,12217,12250,12380,13036,221261,221262,221263,221312,221326,221330,221360,221369,221371,221375,221377,224243,224244,224257,228726,228727,228909},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = {228615},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220931] = {
            [itemKeys.name] = "Waylaid Supplies: Hi-Explosive Bombs",
            [itemKeys.npcDrops] = {1488,1489,1491,1558,1565,1653,1784,1785,1806,1808,1812,1826,1831,1884,2505,2535,2547,2653,2655,2656,2657,2692,2736,2929,4331,4405,4494,4505,4506,5229,5232,5239,5247,5251,5276,5278,5286,5293,5299,5333,5335,5336,5356,5361,5364,5366,5425,5431,5485,5490,5839,5846,5855,5858,5979,5991,5999,6004,6005,6010,6116,6184,6187,6196,6198,6199,6200,6371,6375,6378,6520,6521,6527,6551,6552,6559,7011,7026,7028,7029,7039,7047,7086,7099,7108,7113,7115,7120,7153,7156,7372,7405,7438,7439,7440,7448,7450,7457,7669,7848,7856,7857,7858,8136,8442,8522,8524,8528,8531,8532,8546,8548,8558,8766,8896,8897,8900,8915,8917,8920,8925,8926,8927,8928,8933,9164,9416,9547,9691,9696,9862,10041,10177,10411,10442,10480,10481,10485,11368,11476,11477,11741,11789,11883,12217,13160,13276,14458,15542,221257,221260,221261,221262,221263,221312,221326,221330,221356,221361,221369,221377,223068,224243,224244,224256,224257,228726,228727},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220932] = {
            [itemKeys.name] = "Waylaid Supplies: Thorium Grenades",
            [itemKeys.npcDrops] = {674,950,1488,1557,1562,1563,1653,1783,1787,1806,1812,1821,1831,1833,1835,1883,2534,2547,2652,2655,2658,2659,2691,2926,2928,4328,4400,4466,4474,4475,4493,4506,5229,5232,5236,5239,5254,5276,5292,5331,5361,5421,5423,5424,5426,5462,5471,5623,5839,5853,5854,5974,5977,5984,5992,6005,6116,6125,6126,6127,6136,6137,6187,6188,6190,6195,6196,6198,6199,6200,6201,6350,6507,6511,6518,6520,6527,6551,6559,7011,7028,7029,7035,7036,7037,7038,7047,7048,7086,7097,7112,7126,7154,7156,7369,7438,7440,7441,7445,7452,7453,7454,7460,7524,7803,7864,8337,8504,8520,8525,8529,8538,8542,8546,8551,8560,8637,8897,8900,8902,8913,8917,8920,8926,8928,8932,8933,8956,9165,9416,9462,9545,9547,10221,10316,10375,10411,10442,10480,10678,10919,11598,11613,11736,11789,12127,12216,12218,12248,13276,15685,221260,221261,221262,221263,221326,221328,221361,221369,221371,221375,221377,221408,222243,224243,224244,228718,228726,229802},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220933] = {
            [itemKeys.name] = "Waylaid Supplies: Thorium Rifles",
            [itemKeys.npcDrops] = {687,1490,1653,1785,1791,1794,1812,1817,1831,1833,1835,1884,1907,2522,2691,2692,2929,2944,4328,4494,5229,5234,5240,5274,5292,5296,5331,5335,5424,5428,5460,5472,5485,5490,5615,5617,5618,5839,5850,5853,5857,5975,5979,5982,5991,5993,6004,6005,6006,6116,6136,6137,6193,6194,6195,6196,6198,6199,6202,6222,6375,6506,6527,6556,7026,7029,7034,7035,7098,7101,7105,7106,7107,7108,7111,7113,7114,7118,7139,7153,7154,7157,7268,7269,7371,7372,7405,7438,7439,7443,7448,7458,7460,7523,7668,7725,7847,7857,7858,7864,8526,8542,8560,8566,8597,8601,8761,8766,8897,8900,8913,8915,8916,8920,8922,8927,8932,8933,8956,8959,9166,9167,9462,9464,9547,9691,9701,9862,10177,10375,10391,10411,10442,10481,10485,10678,10801,10816,11360,11368,11477,11736,11746,12380,12418,13276,13359,13599,14462,221230,221257,221258,221261,221262,221324,221326,221357,221369,221370,221371,221377,221406,221408,224243,224244,224257,228718,228719,228729},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220934] = {
            [itemKeys.name] = "Waylaid Supplies: Mithril Coifs",
            [itemKeys.npcDrops] = {743,744,750,1488,1550,1562,1564,1565,1802,1812,1815,1816,1817,1821,1826,1883,2650,2654,2659,2691,2694,2716,2929,4323,4329,4466,5236,5245,5246,5247,5255,5258,5286,5299,5300,5304,5308,5333,5363,5364,5419,5425,5441,5455,5458,5460,5471,5473,5474,5485,5618,5840,5858,5976,5988,5996,6011,6116,6117,6125,6135,6190,6196,6200,6201,6202,6222,6224,6349,6511,6514,6518,6527,6557,6559,7028,7035,7036,7049,7055,7107,7109,7110,7114,7139,7154,7155,7369,7371,7434,7438,7439,7443,7450,7452,7453,7455,7457,7458,7459,7460,7584,7725,7803,7856,7857,8337,8522,8529,8530,8532,8542,8548,8551,8603,8637,8675,8896,8900,8902,8913,8917,8920,8925,8926,8928,8978,9162,9416,9545,9547,9695,9696,10221,10316,10442,10481,10485,10605,10660,10678,10916,11291,11476,11746,11747,12217,12248,12380,13036,13599,14188,14282,14460,14479,15213,221260,221261,221263,221326,221330,221369,221370,222726,224243,224244,224257,228719,228726,228727,228729,228747,230146},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220935] = {
            [itemKeys.name] = "Waylaid Supplies: Thorium Belts",
            [itemKeys.npcDrops] = {674,676,747,751,1087,1490,1561,1563,1785,1791,1793,1806,1808,1812,1822,1826,1835,2537,2680,2692,2693,2926,4324,4328,4403,4467,4475,4505,5229,5232,5234,5240,5262,5274,5278,5292,5293,5297,5364,5427,5455,5459,5460,5472,5475,5481,5485,5490,5616,5843,5850,5857,5977,5981,5999,6004,6006,6011,6117,6125,6138,6190,6193,6194,6198,6199,6200,6201,6202,6527,6553,6555,7025,7027,7029,7033,7035,7036,7047,7105,7108,7110,7113,7114,7115,7120,7153,7154,7157,7369,7371,7372,7376,7379,7397,7405,7431,7440,7445,7449,7452,7453,7458,7460,7524,7725,7726,7727,7855,7857,7858,7864,7883,8279,8523,8526,8530,8546,8548,8550,8551,8566,8606,8896,8900,8904,8913,8915,8916,8925,8926,8927,9416,9462,9543,9545,9694,9701,9862,9956,10040,10177,10316,10411,10485,10605,10648,10801,10916,11477,11611,11740,11741,11881,12046,12217,12218,13276,13599,221260,221261,221263,221324,221326,221328,221361,221365,221369,224243,224244,224257,229802},
            [itemKeys.objectDrops] = {4149},
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220936] = {
            [itemKeys.name] = "Waylaid Supplies: Truesilver Gauntlets",
            [itemKeys.npcDrops] = {687,750,752,1088,1490,1491,1558,1561,1783,1794,1795,1802,1806,1808,1812,1835,2521,2536,2640,2651,2656,2929,4329,4403,4466,4472,4475,4493,4494,5234,5238,5239,5246,5254,5292,5297,5299,5305,5358,5362,5423,5426,5427,5475,5485,5490,5615,5839,5840,5843,5992,6004,6005,6006,6117,6127,6190,6194,6195,6200,6222,6371,6506,6509,6510,6511,6512,6518,6519,6551,6552,7011,7026,7028,7033,7037,7047,7049,7092,7100,7101,7106,7110,7111,7112,7114,7139,7155,7156,7157,7158,7269,7379,7397,7405,7434,7438,7439,7441,7442,7443,7447,7450,7451,7453,7458,7855,7856,8528,8531,8543,8598,8605,8896,8900,8904,8913,8915,8916,8920,8921,8922,8925,8927,8932,8956,8957,8961,8977,9164,9167,9416,9545,9696,9956,10177,10316,10411,10442,10660,10661,10678,11477,11611,11686,12050,12179,12216,12380,13136,13276,13359,15213,221257,221258,221260,221261,221262,221263,221326,221330,221356,221357,221361,221369,221371,221375,221377,222699,223544,224243,224244,224256,224257,228723,229802},
            [itemKeys.objectDrops] = {4149},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220937] = {
            [itemKeys.name] = "Waylaid Supplies: Rugged Armor Kits",
            [itemKeys.npcDrops] = {672,676,731,750,752,1061,1551,1561,1784,1794,1795,1806,1826,1831,1833,1835,1847,1883,2505,2521,2537,2640,2649,2658,2659,2692,2725,2745,2919,2926,4323,4404,4475,4505,5232,5240,5241,5274,5296,5300,5335,5336,5423,5425,5427,5455,5459,5471,5474,5485,5490,5615,5623,5839,5852,5858,5978,5991,6005,6126,6135,6137,6194,6198,6199,6200,6201,6202,6506,6517,6553,6559,6649,7011,7035,7047,7092,7100,7101,7107,7109,7110,7111,7112,7113,7120,7126,7154,7372,7405,7433,7439,7450,7451,7454,7456,7459,7460,7726,7803,7809,7855,7856,7858,7864,8504,8524,8525,8528,8538,8546,8550,8551,8555,8556,8558,8566,8759,8761,8896,8904,8915,8916,8926,8932,8961,8977,9416,9545,10041,10177,10316,10390,10391,10411,10442,10480,10481,10678,10916,11290,11477,11598,11611,11613,11686,11736,12050,12203,12216,12379,12380,13276,14564,221230,221260,221261,221262,221263,221326,221330,221356,221375,221377,221407,221408,222243,224243,224244,224257,228727,228909,229802},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220938] = {
            [itemKeys.name] = "Waylaid Supplies: Wicked Leather Bracers",
            [itemKeys.npcDrops] = {675,751,752,784,1489,1562,1563,1565,1653,1787,1804,1806,1808,1813,1815,1817,1884,2522,2640,2650,2651,2653,2656,2680,2693,2745,2925,4400,4467,4472,4474,4494,4505,5232,5238,5251,5258,5278,5295,5299,5362,5364,5423,5430,5473,5474,5481,5490,5615,5616,5617,5623,5850,5853,5982,5999,6004,6005,6006,6007,6009,6117,6138,6196,6198,6201,6369,6508,6517,7011,7025,7031,7047,7092,7106,7108,7109,7112,7113,7114,7371,7372,7396,7405,7439,7443,7445,7448,7458,7459,7460,7523,7668,7669,7883,8520,8523,8528,8532,8550,8562,8565,8601,8607,8766,8896,8900,8902,8904,8913,8915,8920,8922,8925,8927,8956,8959,9462,9545,9547,9622,9690,9691,9696,9862,10177,10221,10316,10480,10659,10678,10816,10916,11290,11368,11476,11477,11598,11685,11687,11738,11739,11741,11873,12050,12051,12218,13160,13359,13617,15541,221230,221260,221261,221263,221312,221326,221328,221360,221361,221364,221369,221370,221375,221377,222243,222702,224243,224257},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220939] = {
            [itemKeys.name] = "Waylaid Supplies: Runic Leather Bracers",
            [itemKeys.npcDrops] = {747,769,1087,1491,1550,1562,1564,1565,1785,1787,1791,1794,1806,1821,1884,2656,2692,2752,2923,2924,2925,2927,2928,4329,4388,4474,5232,5234,5238,5240,5253,5262,5268,5292,5293,5296,5331,5336,5423,5425,5429,5459,5461,5462,5471,5474,5490,5618,5839,5840,5844,5846,5854,5857,5858,5974,5978,5991,5999,6004,6006,6125,6127,6137,6138,6194,6195,6198,6199,6200,6380,6507,6509,6518,6521,6551,6556,7027,7029,7036,7038,7039,7047,7092,7107,7109,7110,7118,7126,7139,7155,7268,7372,7379,7396,7438,7439,7440,7441,7445,7448,7454,7457,7460,7726,7855,7858,7864,8337,8524,8528,8541,8542,8558,8566,8759,8766,8837,8896,8897,8900,8904,8913,8915,8916,8920,8921,8926,8933,8957,8958,8961,9163,9416,9462,9691,9696,10316,10411,10481,10485,10660,10678,11476,11477,11611,11744,12216,12378,12380,13036,13276,13599,14400,16184,221230,221260,221261,221262,221263,221326,221328,221330,221361,221369,221370,221375,221406,222580,224243,224244,224256,224257,228719,228723,228727,228729,228909},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220940] = {
            [itemKeys.name] = "Waylaid Supplies: Black Mageweave Headbands",
            [itemKeys.npcDrops] = {670,676,784,1087,1488,1551,1565,1785,1787,1789,1794,1802,1812,1821,1822,2530,2659,2693,2716,2717,2736,2919,2926,2929,4324,4331,4467,4474,4493,5232,5240,5244,5253,5258,5262,5292,5295,5296,5364,5431,5454,5458,5460,5471,5472,5474,5481,5485,5490,5617,5623,5839,5850,5854,5855,5999,6004,6006,6009,6117,6126,6135,6137,6190,6195,6196,6199,6200,6201,6222,6377,6380,6512,6519,6527,7011,7028,7031,7034,7035,7036,7038,7039,7047,7086,7098,7100,7106,7108,7110,7112,7118,7120,7371,7372,7379,7396,7439,7441,7444,7451,7453,7458,7459,7460,7524,7726,7847,7864,8519,8526,8527,8532,8535,8540,8541,8542,8548,8561,8605,8896,8897,8900,8902,8904,8913,8916,8926,8928,8958,8960,9163,9416,9462,9543,9622,9695,9696,9862,9879,10177,10316,10442,10480,10481,10678,10816,11476,11477,11613,11740,11746,12178,12179,12218,12378,12380,13599,14400,221257,221260,221262,221263,221312,221326,221330,221361,221369,221370,221377,221651,224243,224244,224257,228747,228909,229802},
            [itemKeys.objectDrops] = {4149,153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220941] = {
            [itemKeys.name] = "Waylaid Supplies: Runecloth Belts",
            [itemKeys.npcDrops] = {674,745,782,1488,1490,1563,1564,1783,1785,1794,1796,1808,1824,1831,1883,2505,2522,2649,2654,2692,2717,2736,2925,4331,4357,4405,4466,4474,4493,4494,5234,5236,5239,5245,5293,5295,5296,5307,5308,5335,5360,5420,5421,5429,5431,5453,5457,5460,5471,5490,5617,5623,5854,5856,5988,6004,6006,6008,6011,6116,6136,6188,6194,6195,6201,6222,6224,6377,6505,6517,6519,6521,6553,6559,7025,7026,7029,7033,7034,7035,7047,7086,7106,7109,7111,7112,7120,7139,7153,7155,7269,7372,7438,7439,7440,7442,7443,7524,7855,7856,7857,8526,8534,8539,8540,8542,8546,8566,8600,8602,8637,8766,8896,8897,8904,8913,8916,8920,8921,8922,8926,8927,8933,8956,8958,9416,9545,9690,9695,9696,9701,10375,10390,10391,10442,10480,10481,10678,10916,11290,11368,11611,11687,11727,11744,11880,12127,12179,12203,12218,12378,13160,13276,13359,13599,221230,221260,221263,221324,221326,221330,221356,221361,221365,221369,221370,221371,221375,221377,224243,224244,224257,228719,228723,228727,228747,228909},
            [itemKeys.objectDrops] = {4149},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220942] = {
            [itemKeys.name] = "Waylaid Supplies: Tuxedo Shirts",
            [itemKeys.npcDrops] = {744,750,751,783,1489,1785,1789,1795,1806,1808,1822,1824,1835,1883,2547,2640,2652,2655,2656,2658,2692,2693,2694,2707,2736,2929,2945,4323,4331,4475,4493,5236,5240,5278,5287,5292,5295,5299,5300,5333,5335,5362,5462,5472,5474,5490,5617,5623,5844,5853,5854,5858,5999,6004,6006,6116,6117,6135,6184,6190,6193,6194,6195,6198,6199,6200,6201,6224,6348,6351,6510,6512,6517,6557,7025,7027,7028,7029,7036,7039,7047,7048,7092,7101,7109,7110,7112,7113,7115,7118,7157,7371,7372,7379,7440,7441,7443,7457,7523,7524,7666,7725,7727,7855,8442,8520,8526,8528,8532,8541,8542,8543,8601,8603,8837,8896,8897,8900,8913,8916,8932,8956,9162,9464,9547,9622,9683,9694,9698,9862,9956,10177,10316,10375,10442,10480,10605,10659,10661,10678,10816,10916,11291,11368,11476,11685,11741,11789,12046,12178,12217,12218,12380,13257,13276,13599,14188,221260,221261,221263,221326,221328,221369,221375,224243,224244,224257,228726,228909,229802},
            [itemKeys.objectDrops] = {153451},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220964] = {
            [itemKeys.name] = "Decharged Void-Powered Vambraces",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [220965] = {
            [itemKeys.name] = "Scalebane Greataxe",
            [itemKeys.npcDrops] = {221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221008] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221009] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221010] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221017] = {
            [itemKeys.name] = "Keldara's Log",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441865},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221018] = {
            [itemKeys.name] = "Field Medicine Kit",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441865},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221019] = {
            [itemKeys.name] = "Satyrweed Sample",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441870},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221020] = {
            [itemKeys.name] = "Rune of the Moon Goddess",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221021] = {
            [itemKeys.name] = "Nightmare Seed",
            [itemKeys.npcDrops] = {218571,218819,220833,221394,221637,221943,224253,224254,224255,224256},
            [itemKeys.objectDrops] = {442722},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221024] = {
            [itemKeys.name] = "Flask of Everlasting Nightmares",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221025] = {
            [itemKeys.name] = "Void-Powered Invoker's Vambraces",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221026] = {
            [itemKeys.name] = "Void-Powered Slayer's Vambraces",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221027] = {
            [itemKeys.name] = "Void-Powered Protector's Vambraces",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221028] = {
            [itemKeys.name] = "Enchanted Sigil: Living Dreams",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221030] = {
            [itemKeys.name] = "Atal'ai Mojo of Forbidden Magic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221191] = {
            [itemKeys.name] = "Dreamstone",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221192] = {
            [itemKeys.name] = "Dream Journal",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221193] = {
            [itemKeys.name] = "Emerald Ring",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221196] = {
            [itemKeys.name] = "Atal'ai Mojo of War",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221199] = {
            [itemKeys.name] = "Satyrweed Tincture",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221256] = {
            [itemKeys.name] = "Right Arm of the Obliterator",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441914},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221257] = {
            [itemKeys.name] = "Left Arm of the Obliterator",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441915},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221258] = {
            [itemKeys.name] = "Right Foot of the Obliterator",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441912},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221259] = {
            [itemKeys.name] = "Left Foot of the Obliterator",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {441913},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221260] = {
            [itemKeys.name] = "Head of the Obliterator",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221261] = {
            [itemKeys.name] = "Wildwhisper Draught",
            [itemKeys.npcDrops] = {2641,2642,2643,2644,2645,2646,2647,2648,4465},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221262] = {
            [itemKeys.name] = "Wild Offering",
            [itemKeys.npcDrops] = {222573,223264,223265},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221267] = {
            [itemKeys.name] = "Rune of the Bloodthirsty",
            [itemKeys.npcDrops] = {222546},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221271] = {
            [itemKeys.name] = "Ace of Wilds",
            [itemKeys.npcDrops] = {12201,222573,223264,223265},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221272] = {
            [itemKeys.name] = "Wilds Deck",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 82058,
        },
        [221273] = {
            [itemKeys.name] = "Two of Wilds",
            [itemKeys.npcDrops] = {1563,1565,1783,1784,1787,1791,1794,1833,1884,2649,2650,2720,5238,5472,5615,5616,5839,5844,5846,5977,6125,6126,6201,6202,7034,7035,7036,7107,7108,7109,7114,7118,7153,7154,7155,7156,7157,7158,7440,7442,7524,7726,7856,7857,8524,8525,8541,8566,8896,8897,8900,8902,8904,8913,8915,8916,8920,9462,9545,9547,9956,10411,12179,12217,221357,221360,221370,221371,221375,221377,221407,222573,224257},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221274] = {
            [itemKeys.name] = "Three of Wilds",
            [itemKeys.npcDrops] = {783,1563,1783,1784,1787,1789,1791,1793,1794,1795,1826,4474,4475,5255,5366,5615,5843,5846,5977,6005,6117,6126,6198,6200,6201,6202,7034,7035,7036,7038,7107,7108,7109,7110,7111,7112,7115,7153,7155,7156,7157,7158,7396,7397,7440,7441,7442,7855,7856,7858,8524,8540,8551,8566,8896,8897,8900,8902,8904,8913,8915,8920,9462,9543,9547,9956,10411,10605,221261,221262,221357,221370,221377,222573},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221275] = {
            [itemKeys.name] = "Four of Wilds",
            [itemKeys.npcDrops] = {1783,1784,1785,1787,1791,1793,1794,1795,1796,1831,1883,1884,2649,2692,2694,2718,4466,4467,4474,4475,5240,5253,5258,5359,5366,5472,5843,5844,5846,5974,5999,6005,6011,6126,6200,6201,7033,7034,7035,7107,7108,7109,7110,7111,7115,7118,7120,7153,7154,7155,7156,7157,7158,7440,7441,7442,7523,7524,7855,7858,8337,8541,8566,8896,8897,8900,8904,8913,8915,8920,9545,9547,9956,10411,10605,12179,221261,221262,221356,221370,221371,221375,221377,222573,224257},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221276] = {
            [itemKeys.name] = "Five of Wilds",
            [itemKeys.npcDrops] = {1783,1791,1795,1827,1831,1834,1884,2643,2645,2646,2647,4853,5617,5648,5649,5843,5846,6007,7107,7153,7156,7157,7246,7286,7604,7797,7858,8889,8890,8891,8892,8893,8894,8895,8896,8897,8898,8899,8900,8902,8904,8912,8914,8920,9043,9044,9045,9046,9097,9098,9198,9199,9200,9201,9240,9257,9258,9267,9452,9541,9547,9554,10411,11440,11443,11454,11791,11794,11887,218624,218718,221370,221375,221639,224250,224258,224259,224260,224262,228916,228919},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221277] = {
            [itemKeys.name] = "Six of Wilds",
            [itemKeys.npcDrops] = {1784,1789,1791,1794,1795,1827,1884,2642,2643,2646,2648,4853,4855,5263,5648,5649,5650,5843,5846,6202,7012,7035,7107,7115,7154,7156,7246,7275,7286,7440,7442,7796,8889,8890,8891,8892,8893,8894,8895,8896,8897,8898,8899,8900,8902,8903,8904,8912,8915,8920,9030,9045,9097,9098,9200,9240,9257,9258,9541,9545,9547,11440,218624,218819,218922,221262,222525,224257,224258,224259,224260,224263,228916,228918},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221278] = {
            [itemKeys.name] = "Seven of Wilds",
            [itemKeys.npcDrops] = {709,1787,1834,2692,2694,5615,5649,5650,5844,5846,6199,6200,6202,7035,7109,7111,7115,7120,7156,7157,7246,7286,7320,7397,7440,7442,7524,7858,8889,8890,8891,8892,8893,8894,8895,8897,8898,8899,8904,8912,8913,8914,8920,9045,9046,9097,9098,9198,9199,9200,9240,9257,9267,9447,9450,9537,9541,9677,10605,11440,11454,11516,12179,203138,218624,221264,222525,224250,224258,224259,224260,224263,228918,228919},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221279] = {
            [itemKeys.name] = "Eight of Wilds",
            [itemKeys.npcDrops] = {1783,1784,1785,1791,1884,2642,2644,2647,2691,4855,5263,5648,5649,5650,5843,5844,5846,5860,5978,6201,7107,7108,7156,7157,7158,7246,7286,7440,7523,7524,8889,8890,8891,8892,8893,8894,8895,8896,8897,8898,8899,8903,8904,8912,8913,9019,9043,9045,9046,9097,9098,9199,9200,9201,9240,9257,9258,9267,9447,9541,11442,11455,11793,218718,221371,221638,224250,224258,224259,224260,224262,224263,228916,228918,228919},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221280] = {
            [itemKeys.name] = "Plagues Deck",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 82057,
        },
        [221281] = {
            [itemKeys.name] = "Ace of Plagues",
            [itemKeys.npcDrops] = {1815,1816,1817,7093,7132,7138,7139,13282,218819,229802},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221282] = {
            [itemKeys.name] = "Two of Plagues",
            [itemKeys.npcDrops] = {783,1059,1783,1784,1787,1789,1791,1794,1795,1831,1883,2537,2640,2650,4474,4475,5255,5472,5843,5844,5846,6006,6116,6126,6199,6201,6202,7026,7034,7035,7036,7107,7108,7109,7110,7111,7114,7153,7156,7157,7440,7442,7524,7883,8504,8524,8525,8566,8896,8897,8900,8902,8904,8913,8915,8916,8920,9398,9464,9545,9547,9956,12179,12216,221261,221262,221356,221360,221375,221377,221407,222573,224257},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221283] = {
            [itemKeys.name] = "Three of Plagues",
            [itemKeys.npcDrops] = {1490,1564,1783,1784,1787,1789,1791,1793,1794,1796,1833,1883,4467,4474,4475,4505,5234,5253,5472,5474,5616,5623,5843,5844,5846,6004,6005,6006,6009,6125,6126,6184,6199,6200,6201,6202,7011,7033,7036,7107,7109,7110,7112,7120,7153,7154,7156,7157,7158,7440,7442,7523,8530,8637,8896,8897,8900,8902,8904,8913,8915,8920,9454,9462,9543,9545,9547,10411,10648,221261,221370,221371,221375,221377,221407,221408,222573},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221284] = {
            [itemKeys.name] = "Four of Plagues",
            [itemKeys.npcDrops] = {1489,1490,1783,1784,1787,1789,1791,1794,1795,1796,1833,1835,1883,1884,2649,2651,4466,4474,4475,5232,5239,5615,5840,5843,5844,5846,6004,6006,6116,6198,6200,6201,7011,7033,7035,7105,7107,7108,7110,7118,7120,7153,7154,7155,7156,7157,7158,7396,7440,7855,7858,8538,8896,8897,8900,8904,8913,8915,8916,8920,9028,9545,9547,9956,10605,12179,221261,221262,221356,221370,221371,221375,221407,221408,222573},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221285] = {
            [itemKeys.name] = "Five of Plagues",
            [itemKeys.npcDrops] = {1563,1783,1789,2644,2646,2647,2648,4465,4466,4853,5236,5263,5617,5648,5649,5650,5844,5846,5862,6201,6202,7012,7037,7110,7153,7155,7156,7157,7158,7246,7276,7286,7440,7441,7523,7795,7796,8541,8889,8890,8891,8892,8893,8894,8895,8896,8897,8898,8899,8900,8903,8904,8912,8913,8920,8929,9030,9045,9097,9098,9198,9199,9200,9201,9239,9240,9257,9258,9267,9541,9547,11355,11442,11443,11451,11455,11794,15162,218819,221637,224250,224258,224259,224260,224263},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221286] = {
            [itemKeys.name] = "Six of Plagues",
            [itemKeys.npcDrops] = {1756,1784,1795,1833,2643,2647,2648,4465,4855,5254,5263,5615,5647,5649,5650,5843,5844,5861,6200,7034,7038,7109,7113,7153,7155,7156,7246,7272,7286,7320,7857,8889,8890,8891,8892,8893,8894,8895,8896,8897,8898,8903,8904,8912,8920,9019,9045,9056,9097,9098,9199,9200,9201,9239,9240,9257,9258,9447,9450,9452,9541,11442,11443,11455,218624,218868,221264,221370,221640,224250,224258,224259,224260,228918},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221287] = {
            [itemKeys.name] = "Seven of Plagues",
            [itemKeys.npcDrops] = {1783,1784,1785,1787,1789,1834,2643,2647,2648,5649,5650,5843,5844,5846,5861,7034,7156,7157,7158,7246,7286,7290,7606,7668,7856,8889,8890,8891,8892,8893,8894,8895,8896,8898,8899,8900,8904,8912,8913,8915,8920,9033,9045,9097,9098,9200,9201,9239,9240,9257,9258,9267,9541,9678,10411,11290,11440,11454,218922,221264,221377,224258,224259,224260,224263},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221288] = {
            [itemKeys.name] = "Eight of Plagues",
            [itemKeys.npcDrops] = {1784,1791,1827,2643,2644,2645,2647,4475,4855,5232,5471,5618,5648,5649,5650,5843,5846,5861,6005,7011,7108,7109,7112,7154,7156,7158,7246,7247,7276,7286,7320,7440,7442,7604,7856,8889,8890,8891,8892,8893,8894,8895,8896,8897,8898,8899,8902,8904,8912,8913,8914,8915,8920,9045,9046,9097,9098,9200,9201,9239,9257,9258,9267,9447,9541,9554,10580,11442,11443,11451,12179,218819,222525,224258,224259,224260,224263,228916},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221289] = {
            [itemKeys.name] = "Dunes Deck",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 82055,
        },
        [221290] = {
            [itemKeys.name] = "Ace of Dunes",
            [itemKeys.npcDrops] = {5645,7267,7274,222573},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221291] = {
            [itemKeys.name] = "Two of Dunes",
            [itemKeys.npcDrops] = {676,782,1563,1783,1784,1785,1787,1789,1791,1793,1794,1796,1833,1883,2550,4467,4474,4475,4505,5240,5255,5363,5472,5474,5617,5843,5844,5846,5977,5981,6006,6199,6200,6201,6202,7033,7034,7035,7036,7107,7108,7110,7111,7113,7118,7120,7153,7154,7155,7156,7157,7158,7441,7442,7855,7856,8523,8551,8566,8896,8897,8900,8902,8904,8913,8915,8916,8920,9545,9547,9956,10411,12179,221356,221357,221370,221371,221375,221377,221406,222573},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221292] = {
            [itemKeys.name] = "Three of Dunes",
            [itemKeys.npcDrops] = {1490,1756,1783,1784,1791,1793,1794,1833,1884,2640,4467,4474,5232,5240,5254,5472,5615,5618,5623,5843,5844,5846,6005,6199,6200,7033,7037,7038,7106,7107,7108,7109,7110,7118,7153,7154,7156,7157,7158,7397,7440,7441,7442,7855,7856,7858,8896,8897,8900,8902,8904,8915,8916,8920,9462,9545,9547,9862,9956,10816,221261,221262,221357,221370,221371,221377,222573},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221293] = {
            [itemKeys.name] = "Four of Dunes",
            [itemKeys.npcDrops] = {1783,1784,1785,1789,1791,1795,1831,1833,1884,2536,2720,4467,4474,4475,5234,5253,5255,5366,5472,5474,5615,5843,5844,5846,6006,6116,6117,6125,6127,6198,6201,6202,7026,7033,7035,7036,7106,7107,7108,7109,7111,7112,7120,7153,7154,7155,7156,7157,7158,7397,7440,7441,7442,7524,7726,7855,7858,8540,8541,8566,8637,8896,8897,8902,8904,8913,8915,8916,8920,9462,9543,9545,9547,9956,10411,10919,221261,221262,221357,221370,221371,221375,221377,221407,224257},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221294] = {
            [itemKeys.name] = "Five of Dunes",
            [itemKeys.npcDrops] = {709,1756,1783,1795,2645,2646,2648,4853,4855,5232,5234,5243,5269,5648,5649,5650,5843,5860,5981,7034,7035,7109,7153,7156,7157,7246,7276,7286,7442,7726,8889,8890,8891,8892,8893,8894,8895,8896,8897,8898,8899,8900,8902,8903,8904,8912,8914,8915,8916,8920,9024,9041,9045,9046,9097,9098,9198,9199,9200,9201,9240,9257,9258,9267,9452,9537,9541,9545,9554,10411,11443,203138,218819,222525,224258,224259,224260,224263,228916,228918,228919},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221295] = {
            [itemKeys.name] = "Six of Dunes",
            [itemKeys.npcDrops] = {1783,1784,1785,1791,1795,1884,2644,2645,2646,2647,2648,2717,4474,4855,5261,5263,5649,5650,5843,6005,6009,6202,7035,7111,7113,7115,7153,7155,7156,7157,7158,7246,7272,7274,7286,7320,7796,8530,8636,8889,8890,8891,8892,8893,8894,8897,8898,8899,8903,8904,8912,8913,8920,9045,9097,9098,9198,9200,9201,9239,9240,9257,9258,9462,9554,10802,11440,11443,11451,218624,218868,221370,221638,221639,224250,224258,224259,224260,224262,224263,228916},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221296] = {
            [itemKeys.name] = "Seven of Dunes",
            [itemKeys.npcDrops] = {1787,1791,1794,2643,2645,4465,5243,5249,5269,5360,5647,5648,5649,5650,5843,5844,5846,5861,7153,7157,7158,7247,7275,7286,7320,7440,7857,8889,8890,8891,8892,8893,8894,8895,8896,8897,8898,8899,8900,8902,8903,8904,8912,8915,8916,8920,9030,9044,9045,9097,9098,9199,9201,9240,9257,9258,9267,9447,9541,10411,11355,218624,218718,218721,221264,221370,221371,221637,224258,224259,224260,224263,228612,228916,228918},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221297] = {
            [itemKeys.name] = "Eight of Dunes",
            [itemKeys.npcDrops] = {709,1783,1784,1787,1793,1833,1884,2645,2647,2691,4855,5362,5649,5650,5843,5844,5860,5977,6006,6200,7035,7106,7107,7111,7112,7153,7156,7157,7246,7272,7286,7397,8551,8889,8890,8891,8892,8893,8894,8895,8896,8897,8898,8899,8903,8904,8912,8913,8915,8916,8920,9045,9097,9098,9198,9200,9201,9240,9257,9267,9447,9541,9545,9862,9956,10919,11443,11451,11792,218624,218868,224250,224258,224259,224260,224263,228916,228919},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221298] = {
            [itemKeys.name] = "Ace of Nightmares",
            [itemKeys.npcDrops] = {218571,220833,221943},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221299] = {
            [itemKeys.name] = "Nightmares Deck",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 82056,
        },
        [221300] = {
            [itemKeys.name] = "Two of Nightmares",
            [itemKeys.npcDrops] = {1489,1783,1784,1785,1787,1791,1793,1795,1796,1833,1884,2691,2944,4474,4475,5229,5236,5240,5360,5472,5475,5616,5617,5839,5843,5844,5846,5978,6004,6005,6116,6198,6200,6201,6202,7011,7033,7034,7035,7036,7105,7106,7107,7108,7110,7111,7113,7114,7115,7120,7153,7154,7155,7156,7157,7158,7396,7440,7441,7442,7856,7857,8504,8541,8896,8897,8900,8902,8904,8913,8915,8916,8920,9028,9543,9545,9547,10411,11290,12179,221261,221370,221371,221375,221377,221407,221408,222573,224257},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221301] = {
            [itemKeys.name] = "Three of Nightmares",
            [itemKeys.npcDrops] = {1488,1563,1783,1791,1793,1794,1795,1884,2640,4466,4474,4475,4505,5234,5251,5253,5364,5472,5616,5618,5843,5844,5846,5978,6004,6200,6201,6202,7026,7033,7036,7037,7107,7108,7111,7112,7114,7153,7155,7156,7157,7158,7440,7442,7856,7857,7864,8523,8524,8530,8541,8551,8566,8896,8897,8900,8902,8904,8913,8915,8920,9176,9462,9545,9956,10816,10919,11290,221261,221262,221357,221360,221370,221371,221375,221406,222573,224257},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221302] = {
            [itemKeys.name] = "Four of Nightmares",
            [itemKeys.npcDrops] = {669,783,1490,1653,1783,1784,1785,1787,1789,1791,1793,1794,1826,1835,1883,1884,2653,2692,4467,4475,5251,5255,5258,5364,5472,5475,5617,5844,5846,6199,6200,6201,6202,7033,7035,7108,7109,7111,7120,7153,7154,7156,7157,7158,7440,7524,7725,7858,8504,8566,8896,8897,8900,8902,8904,8913,8915,8917,8920,9398,9545,9547,10411,221261,221370,221371,221375,221377,221407,222573,224257},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221303] = {
            [itemKeys.name] = "Five of Nightmares",
            [itemKeys.npcDrops] = {1783,1787,1794,1795,2645,2646,2648,4465,5251,5263,5648,5649,5843,5860,6005,7012,7108,7115,7118,7153,7154,7157,7158,7246,7247,7286,7440,7442,7858,8524,8889,8890,8891,8892,8893,8894,8895,8896,8899,8900,8902,8903,8904,8912,8914,8915,8920,9097,9098,9199,9200,9239,9240,9257,9258,9447,9541,9678,9956,10043,11355,11443,11451,11455,218624,218922,221261,224250,224257,224258,224259,224262,228916,228918},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221304] = {
            [itemKeys.name] = "Six of Nightmares",
            [itemKeys.npcDrops] = {1488,1489,1784,1787,1834,1835,1883,2643,2648,4474,4855,5472,5649,5650,5840,5843,7026,7035,7036,7109,7113,7153,7156,7246,7274,7286,7320,7995,8523,8889,8890,8891,8892,8893,8894,8895,8896,8897,8898,8899,8902,8904,8912,8915,8920,9045,9046,9097,9098,9198,9199,9200,9201,9239,9240,9258,9267,9445,9541,9554,10043,11440,11791,11794,12179,221637,221639,224258,224259,224260,224262,224263,228916,228919},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221305] = {
            [itemKeys.name] = "Seven of Nightmares",
            [itemKeys.npcDrops] = {1787,1791,1884,2643,4475,5229,5263,5623,5648,5649,5650,5861,6201,7107,7109,7155,7156,7247,7286,7440,7524,7796,7797,7857,8889,8890,8891,8892,8893,8894,8896,8897,8898,8899,8903,8904,8912,8913,8915,8916,8920,9045,9097,9098,9198,9199,9200,9240,9441,9449,9545,9554,10082,11443,11455,11552,218721,218868,221357,221407,221638,222525,224258,224259,224260,224263},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221306] = {
            [itemKeys.name] = "Eight of Nightmares",
            [itemKeys.npcDrops] = {1783,1789,2644,2647,2648,4465,4475,4855,5471,5648,5649,5650,5844,5846,5860,6202,7033,7038,7108,7153,7155,7157,7158,7246,7286,7320,7440,8889,8890,8891,8892,8893,8894,8895,8896,8898,8899,8904,8912,8913,8914,8915,8920,9043,9045,9097,9098,9200,9201,9239,9240,9257,9258,9267,9451,9462,9547,10411,11443,11887,218718,218721,224250,224258,224259,224260,224262,224263,228918,228919},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221491},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221307] = {
            [itemKeys.name] = "Darkmoon Card: Decay",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221308] = {
            [itemKeys.name] = "Darkmoon Card: Overgrowth",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221309] = {
            [itemKeys.name] = "Darkmoon Card: Sandstorm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221310] = {
            [itemKeys.name] = "Darkmoon Card: Torment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221311] = {
            [itemKeys.name] = "Atal'ai Mojo of Life",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221312] = {
            [itemKeys.name] = "Flask of Atal'ai Mojo",
            [itemKeys.npcDrops] = {5243,5261,5263,5269,218624,218718,218721,218819,221394,221924,224250,224258,224259,224260,224262,224263},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221313] = {
            [itemKeys.name] = "Flask of Nightmarish Mojo",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221314] = {
            [itemKeys.name] = "Wanted Notice",
            [itemKeys.npcDrops] = {222525},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221315] = {
            [itemKeys.name] = "Rainbow Generator",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221316] = {
            [itemKeys.name] = "Premo's Poise-Demanding Uniform",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221317] = {
            [itemKeys.name] = "Feralas Leycryst",
            [itemKeys.npcDrops] = {222407},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221318] = {
            [itemKeys.name] = "Azshara Leycryst",
            [itemKeys.npcDrops] = {222407},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221319] = {
            [itemKeys.name] = "Blackrock Leycryst",
            [itemKeys.npcDrops] = {222407},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221320] = {
            [itemKeys.name] = "Hinterlands Leycryst",
            [itemKeys.npcDrops] = {222407},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221321] = {
            [itemKeys.name] = "Atal'ai Signet of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221322] = {
            [itemKeys.name] = "Atal'ai Signet of Mojo",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221323] = {
            [itemKeys.name] = "Atal'ai Signet of Serenity",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221324] = {
            [itemKeys.name] = "Brittle Shadowforge Key",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221325] = {
            [itemKeys.name] = "EZ-Splode Blasting Charge",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221326] = {
            [itemKeys.name] = "Sacred Stag Heart",
            [itemKeys.npcDrops] = {222580},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221327] = {
            [itemKeys.name] = "Schematic: Gnomish Shrink Ray",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222316},
            [itemKeys.startQuest] = nil,
        },
        [221328] = {
            [itemKeys.name] = "Schematic: Gnomish Goggles",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222316},
            [itemKeys.startQuest] = nil,
        },
        [221329] = {
            [itemKeys.name] = "Schematic: Gnomish Net-o-matic Projector",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222316},
            [itemKeys.startQuest] = nil,
        },
        [221330] = {
            [itemKeys.name] = "Schematic: Gnomish Harm Prevention Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222316},
            [itemKeys.startQuest] = nil,
        },
        [221331] = {
            [itemKeys.name] = "Schematic: Gnomish Rocket Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222316},
            [itemKeys.startQuest] = nil,
        },
        [221332] = {
            [itemKeys.name] = "Schematic: Gnomish Battle Chicken",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222316},
            [itemKeys.startQuest] = nil,
        },
        [221333] = {
            [itemKeys.name] = "Schematic: Gnomish Mind Control Cap",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222316},
            [itemKeys.startQuest] = nil,
        },
        [221334] = {
            [itemKeys.name] = "Schematic: Gnomish Death Ray",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222316},
            [itemKeys.startQuest] = nil,
        },
        [221335] = {
            [itemKeys.name] = "Schematic: Goblin Construction Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222261},
            [itemKeys.startQuest] = nil,
        },
        [221336] = {
            [itemKeys.name] = "Schematic: Goblin Mining Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222261},
            [itemKeys.startQuest] = nil,
        },
        [221337] = {
            [itemKeys.name] = "Schematic: Goblin Mortar",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222261},
            [itemKeys.startQuest] = nil,
        },
        [221338] = {
            [itemKeys.name] = "Schematic: Goblin Sapper Charge",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222261},
            [itemKeys.startQuest] = nil,
        },
        [221339] = {
            [itemKeys.name] = "Schematic: Goblin Rocket Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222261},
            [itemKeys.startQuest] = nil,
        },
        [221340] = {
            [itemKeys.name] = "Schematic: Goblin Bomb Dispenser",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222261},
            [itemKeys.startQuest] = nil,
        },
        [221341] = {
            [itemKeys.name] = "Schematic: The Big One",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221342] = {
            [itemKeys.name] = "Schematic: Goblin Dragon Gun",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222261},
            [itemKeys.startQuest] = nil,
        },
        [221343] = {
            [itemKeys.name] = "Schematic: Goblin Rocket Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222261},
            [itemKeys.startQuest] = nil,
        },
        [221344] = {
            [itemKeys.name] = "Personal Spellbook",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221345] = {
            [itemKeys.name] = "Corrupted Blood of Eranikus",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221346] = {
            [itemKeys.name] = "Scapula of the Fallen Avatar",
            [itemKeys.npcDrops] = {221394},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 82081,
        },
        [221347] = {
            [itemKeys.name] = "Murky Fire Sapta",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221348] = {
            [itemKeys.name] = "Murky Water Sapta",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221349] = {
            [itemKeys.name] = "Murky Earth Sapta",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221350] = {
            [itemKeys.name] = "Charred Shaman's Notes",
            [itemKeys.npcDrops] = {5852,5855},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 82071,
        },
        [221351] = {
            [itemKeys.name] = "Waterlogged Shaman's Notes",
            [itemKeys.npcDrops] = {6125,6126,6127},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 82073,
        },
        [221352] = {
            [itemKeys.name] = "Smudged Shaman's Notes",
            [itemKeys.npcDrops] = {5420,5426,5465},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 82072,
        },
        [221353] = {
            [itemKeys.name] = "Fragment of Fire",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221354] = {
            [itemKeys.name] = "Fragment of Water",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221355] = {
            [itemKeys.name] = "Fragment of Earth",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221356] = {
            [itemKeys.name] = "Glowing Fragment of Fire",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221357] = {
            [itemKeys.name] = "Glowing Fragment of Water",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221358] = {
            [itemKeys.name] = "Glowing Fragment of Earth",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221359] = {
            [itemKeys.name] = "Pristine Owlbeast Quill",
            [itemKeys.npcDrops] = {2927,2928,2929},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221360] = {
            [itemKeys.name] = "Farraki Papyrus",
            [itemKeys.npcDrops] = {7286},
            [itemKeys.objectDrops] = {128308,128403},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221361] = {
            [itemKeys.name] = "Zukk'ash Resin",
            [itemKeys.npcDrops] = {5244,5245,5246,5247},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221362] = {
            [itemKeys.name] = "Weapon Cleaning Cloth",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221363] = {
            [itemKeys.name] = "Scapula of the Fallen Avatar",
            [itemKeys.npcDrops] = {221394},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 82083,
        },
        [221364] = {
            [itemKeys.name] = "Copper Massacre Coin",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221367},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221365] = {
            [itemKeys.name] = "Silver Massacre Coin",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221366] = {
            [itemKeys.name] = "Gold Massacre Coin",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221367] = {
            [itemKeys.name] = "Satchel of Copper Massacre Coins",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221368] = {
            [itemKeys.name] = "Satchel of Silver Massacre Coins",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221369] = {
            [itemKeys.name] = "Nightmare Siphon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221370] = {
            [itemKeys.name] = "Precious Medallion",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {221371},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221371] = {
            [itemKeys.name] = "Kidnapper's Coin Purse",
            [itemKeys.npcDrops] = {7855,7856,7858},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221372] = {
            [itemKeys.name] = "Mangled Coin Purse",
            [itemKeys.npcDrops] = {7855,7856,7858},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221374] = {
            [itemKeys.name] = "Anguish of the Dream",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221376] = {
            [itemKeys.name] = "Emerald Dream Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221377] = {
            [itemKeys.name] = "Emerald Dream Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221378] = {
            [itemKeys.name] = "Emerald Dream Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221379] = {
            [itemKeys.name] = "Emerald Dream Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221380] = {
            [itemKeys.name] = "Emerald Dream Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221381] = {
            [itemKeys.name] = "Emerald Dream Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221382] = {
            [itemKeys.name] = "Emerald Encrusted Battleplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221383] = {
            [itemKeys.name] = "Emerald Encrusted Handguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221384] = {
            [itemKeys.name] = "Emerald Encrusted Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221385] = {
            [itemKeys.name] = "Emerald Encrusted Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221386] = {
            [itemKeys.name] = "Emerald Encrusted Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221387] = {
            [itemKeys.name] = "Emerald Encrusted Plate Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221388] = {
            [itemKeys.name] = "Emerald Scalemail Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221389] = {
            [itemKeys.name] = "Emerald Scalemail Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221390] = {
            [itemKeys.name] = "Emerald Scalemail Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221391] = {
            [itemKeys.name] = "Emerald Scalemail Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221392] = {
            [itemKeys.name] = "Emerald Scalemail Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221393] = {
            [itemKeys.name] = "Emerald Scalemail Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221394] = {
            [itemKeys.name] = "Emerald Laden Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221395] = {
            [itemKeys.name] = "Emerald Laden Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221396] = {
            [itemKeys.name] = "Emerald Laden Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221397] = {
            [itemKeys.name] = "Emerald Laden Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221398] = {
            [itemKeys.name] = "Emerald Laden Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221399] = {
            [itemKeys.name] = "Emerald Laden Shoudlers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221400] = {
            [itemKeys.name] = "Emerald Chain Shoudlers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221401] = {
            [itemKeys.name] = "Emerald ChainLeggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221402] = {
            [itemKeys.name] = "Emerald Chain Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221403] = {
            [itemKeys.name] = "Emerald Chain Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221404] = {
            [itemKeys.name] = "Emerald Chain Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221405] = {
            [itemKeys.name] = "Emerald Chain Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221406] = {
            [itemKeys.name] = "Emerald Leather Vest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221407] = {
            [itemKeys.name] = "Emerald Leather Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221408] = {
            [itemKeys.name] = "Emerald Leather Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221409] = {
            [itemKeys.name] = "Emerald Leather Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221410] = {
            [itemKeys.name] = "Emerald Leather Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221411] = {
            [itemKeys.name] = "Emerald Leather Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221412] = {
            [itemKeys.name] = "Emerald Dreamkeeper Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221413] = {
            [itemKeys.name] = "Emerald Dreamkeeper Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221414] = {
            [itemKeys.name] = "Emerald Dreamkeeper Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221415] = {
            [itemKeys.name] = "Emerald Dreamkeeper Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221416] = {
            [itemKeys.name] = "Emerald Dreamkeeper Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221417] = {
            [itemKeys.name] = "Emerald Dreamkeeper Chest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221418] = {
            [itemKeys.name] = "Agamaggan's Roar",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {214954},
            [itemKeys.startQuest] = nil,
        },
        [221419] = {
            [itemKeys.name] = "Emerald Watcher Vest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221420] = {
            [itemKeys.name] = "Emerald Watcher Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221421] = {
            [itemKeys.name] = "Emerald Watcher Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221422] = {
            [itemKeys.name] = "Emerald Watcher Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221423] = {
            [itemKeys.name] = "Emerald Watcher Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221424] = {
            [itemKeys.name] = "Emerald Watcher Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221425] = {
            [itemKeys.name] = "Emerald Enchanted Circlet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221426] = {
            [itemKeys.name] = "Emerald Enchanted Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221427] = {
            [itemKeys.name] = "Emerald Enchanted Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221428] = {
            [itemKeys.name] = "Rune of Foul Play",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221429] = {
            [itemKeys.name] = "Emerald Enchanted Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221430] = {
            [itemKeys.name] = "Emerald Enchanted Robes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221431] = {
            [itemKeys.name] = "Emerald Enchanted Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221432] = {
            [itemKeys.name] = "Emerald Woven Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221433] = {
            [itemKeys.name] = "Rune of Focus",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {442398},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221434] = {
            [itemKeys.name] = "Emerald Woven Robes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221435] = {
            [itemKeys.name] = "Emerald Woven Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221436] = {
            [itemKeys.name] = "Emerald Woven Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221437] = {
            [itemKeys.name] = "Emerald Woven Circlet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221438] = {
            [itemKeys.name] = "Emerald Woven Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221439] = {
            [itemKeys.name] = "Armor of the Emerald Slumber",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221440] = {
            [itemKeys.name] = "Roar of the Dream",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221441] = {
            [itemKeys.name] = "Warden of the Dream",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221442] = {
            [itemKeys.name] = "Roar of the Guardian",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221443] = {
            [itemKeys.name] = "Roar of the Grove",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [221444] = {
            [itemKeys.name] = "Jungle Durian",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221445] = {
            [itemKeys.name] = "Rune of Focused Fire",
            [itemKeys.npcDrops] = {222699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221446] = {
            [itemKeys.name] = "Ritualist's Hammer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221447] = {
            [itemKeys.name] = "Ritualist's Bloodmoon Grimoire",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221448] = {
            [itemKeys.name] = "Talisman of the Corrupted Grove",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221450] = {
            [itemKeys.name] = "Gurubashi Pit Fighter's Bow",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221451] = {
            [itemKeys.name] = "Bloodthirst Crossbow",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221452] = {
            [itemKeys.name] = "Bloodfocused Arcane Band",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221453] = {
            [itemKeys.name] = "Band of Boiling Blood",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221454] = {
            [itemKeys.name] = "Glacial Blood Band",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221455] = {
            [itemKeys.name] = "Bloodlight Reverence",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221456] = {
            [itemKeys.name] = "Eclipsed Sanguine Saber",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221457] = {
            [itemKeys.name] = "Libram of Draconic Destruction",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221458] = {
            [itemKeys.name] = "Shadowy Band of Victory",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221459] = {
            [itemKeys.name] = "Seal of the Sacrificed",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221460] = {
            [itemKeys.name] = "Gurubashi Backstabber",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221461] = {
            [itemKeys.name] = "Rune of Carnage",
            [itemKeys.npcDrops] = {222702},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221462] = {
            [itemKeys.name] = "Bloodied Sword of Speed",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221463] = {
            [itemKeys.name] = "Ancestral Voodoo Doll",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221464] = {
            [itemKeys.name] = "Totem of Fiery Precision",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221465] = {
            [itemKeys.name] = "Corrupted Smashbringer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221466] = {
            [itemKeys.name] = "Loop of Burning Blood",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221467] = {
            [itemKeys.name] = "Eye of the Bloodmoon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221468] = {
            [itemKeys.name] = "Wall of Whispers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221469] = {
            [itemKeys.name] = "Headhunter's Barbed Spear",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [221470] = {
            [itemKeys.name] = "Dream Emerald",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221471] = {
            [itemKeys.name] = "Emerald Wardens Chest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221473] = {
            [itemKeys.name] = "Rune of the Watchman",
            [itemKeys.npcDrops] = {222726},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221474] = {
            [itemKeys.name] = "Chained Essence of Eranikus",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221475] = {
            [itemKeys.name] = "Essence of Eranikus",
            [itemKeys.npcDrops] = {218571},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 82102,
        },
        [221480] = {
            [itemKeys.name] = "Spell Notes: Molten Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221481] = {
            [itemKeys.name] = "Nihilist Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221482] = {
            [itemKeys.name] = "Rune of Affliction",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221483] = {
            [itemKeys.name] = "Rune of Burn",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687,233428},
            [itemKeys.startQuest] = nil,
        },
        [221484] = {
            [itemKeys.name] = "Witch Doctor's Hex Stick",
            [itemKeys.npcDrops] = {218819},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {235251},
            [itemKeys.startQuest] = nil,
        },
        [221487] = {
            [itemKeys.name] = "Spell Notes: Advanced Warding",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221488] = {
            [itemKeys.name] = "Resolute Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221489] = {
            [itemKeys.name] = "Rune of Vengeance",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221490] = {
            [itemKeys.name] = "Rune of Riptide",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [221491] = {
            [itemKeys.name] = "Shadowtooth Bag",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222408},
            [itemKeys.startQuest] = nil,
        },
        [221497] = {
            [itemKeys.name] = "Old Key",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {442688},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221498] = {
            [itemKeys.name] = "Sturdy Lunchbox",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221499] = {
            [itemKeys.name] = "Rune of the Felguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {220446,223148,223149,223150},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221510] = {
            [itemKeys.name] = "Rune of the Knight",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221511] = {
            [itemKeys.name] = "Rune of the Protector",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221512] = {
            [itemKeys.name] = "Rune of Alacrity",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221513] = {
            [itemKeys.name] = "Rune of Potency",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221514] = {
            [itemKeys.name] = "Rune of Firepower",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221515] = {
            [itemKeys.name] = "Rune of Detonation",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221516] = {
            [itemKeys.name] = "Rune of Primal Energy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221517] = {
            [itemKeys.name] = "Rune of Bloodshed",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221518] = {
            [itemKeys.name] = "Whisper",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221519] = {
            [itemKeys.name] = "Mannoroc Orb",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221544] = {
            [itemKeys.name] = "Stormcrow Egg",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {442404},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221545] = {
            [itemKeys.name] = "Deciphered Warlock Notes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221547] = {
            [itemKeys.name] = "Coded Warlock Notes",
            [itemKeys.npcDrops] = {5617},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221549] = {
            [itemKeys.name] = "Wastewander Cipher",
            [itemKeys.npcDrops] = {5616},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221780] = {
            [itemKeys.name] = "Princess Theradras' Scepter",
            [itemKeys.npcDrops] = {12201},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221781] = {
            [itemKeys.name] = "Avenguard Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221782] = {
            [itemKeys.name] = "Helm of Exile",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221783] = {
            [itemKeys.name] = "Lawbringer Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [221785] = {
            [itemKeys.name] = "Cenarion Vestments",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [221971] = {
            [itemKeys.name] = "Dreamsworn Horn",
            [itemKeys.npcDrops] = {221282},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221972] = {
            [itemKeys.name] = "Dreampyre Fire",
            [itemKeys.npcDrops] = {221283},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221973] = {
            [itemKeys.name] = "Dreamhunter Fang",
            [itemKeys.npcDrops] = {221292},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221974] = {
            [itemKeys.name] = "Grimtotem Necklace",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {443727},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221975] = {
            [itemKeys.name] = "Broken Woodpaw Staff",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {443728},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221976] = {
            [itemKeys.name] = "Diseased Nature Staff",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221978] = {
            [itemKeys.name] = "Explorer's Soul",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [221979] = {
            [itemKeys.name] = "Prophecy of Verdant Winter",
            [itemKeys.npcDrops] = {222897},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221980] = {
            [itemKeys.name] = "Prophecy of Awakened Chaos",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [221981] = {
            [itemKeys.name] = "Prophecy of the Lost Tribe",
            [itemKeys.npcDrops] = {223591},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [222952] = {
            [itemKeys.name] = "Flask of Restless Dreams",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [222962] = {
            [itemKeys.name] = "Hyjal's Wisdom",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223073] = {
            [itemKeys.name] = "Knight-Lieutenant's Mail Epaulets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [223074] = {
            [itemKeys.name] = "Knight's Mail Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [223075] = {
            [itemKeys.name] = "Knight-Lieutenant's Mail Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [223076] = {
            [itemKeys.name] = "Sergeant Major's Mail Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [223077] = {
            [itemKeys.name] = "Sergeant Major's Mail Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777,12805},
            [itemKeys.startQuest] = nil,
        },
        [223078] = {
            [itemKeys.name] = "Knight's Mail Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [223147] = {
            [itemKeys.name] = "Spell Notes: Balefire Bolt",
            [itemKeys.npcDrops] = {223340,223542,223543,223544,230146},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [223148] = {
            [itemKeys.name] = "Otherworldly Treasure",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223149] = {
            [itemKeys.name] = "Otherworldly Treasure",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223150] = {
            [itemKeys.name] = "Otherworldly Treasure",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223151] = {
            [itemKeys.name] = "Otherworldly Treasure",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223160] = {
            [itemKeys.name] = "Bargain Bush",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101,235251},
            [itemKeys.startQuest] = nil,
        },
        [223161] = {
            [itemKeys.name] = "Empty Supply Crate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101,235251},
            [itemKeys.startQuest] = nil,
        },
        [223162] = {
            [itemKeys.name] = "Handy Courier Haversack",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [223163] = {
            [itemKeys.name] = "Formula: Scroll of Spatial Mending",
            [itemKeys.npcDrops] = {223340,223544,230146},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {220446,223148,223149,223150,228615},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223164] = {
            [itemKeys.name] = "Curiosity Cowl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [223167] = {
            [itemKeys.name] = "Initiative Cap",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [223168] = {
            [itemKeys.name] = "Worldcore Fragment",
            [itemKeys.npcDrops] = {222407,223544},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223150,224848,224850,228615},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223169] = {
            [itemKeys.name] = "Tenacity Cap",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [223171] = {
            [itemKeys.name] = "Scroll of Geomancy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223172] = {
            [itemKeys.name] = "Tenacity Chain",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [223173] = {
            [itemKeys.name] = "Geomancer's Cord",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223174] = {
            [itemKeys.name] = "Geomancer's Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223175] = {
            [itemKeys.name] = "Geomancer's Cloak",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223177] = {
            [itemKeys.name] = "Geomancer's Cap",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223178] = {
            [itemKeys.name] = "Geomancer's Bracers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223180] = {
            [itemKeys.name] = "Geomancer's Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223181] = {
            [itemKeys.name] = "Geomancer's Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223182] = {
            [itemKeys.name] = "Geomancer's Trousers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223183] = {
            [itemKeys.name] = "Geomancer's Wraps",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223186] = {
            [itemKeys.name] = "Supply Expediter",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [223192] = {
            [itemKeys.name] = "Cord of the Untamed",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222408},
            [itemKeys.startQuest] = nil,
        },
        [223193] = {
            [itemKeys.name] = "Crown of the Dreamweaver",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222408},
            [itemKeys.startQuest] = nil,
        },
        [223194] = {
            [itemKeys.name] = "Band of the Wilds",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222408},
            [itemKeys.startQuest] = nil,
        },
        [223195] = {
            [itemKeys.name] = "Breadth of the Beast",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222408},
            [itemKeys.startQuest] = nil,
        },
        [223196] = {
            [itemKeys.name] = "Godslayer's Greaves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222408},
            [itemKeys.startQuest] = nil,
        },
        [223197] = {
            [itemKeys.name] = "Defender of the Wilds",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222408},
            [itemKeys.startQuest] = nil,
        },
        [223198] = {
            [itemKeys.name] = "Modas Karkun",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223150,224851},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223214] = {
            [itemKeys.name] = "Zila Gular",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223150,224851},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223215] = {
            [itemKeys.name] = "Orah Raka",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223216] = {
            [itemKeys.name] = "Rakkan Archim",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223148},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223217] = {
            [itemKeys.name] = "Rakkas Lek",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223149},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223218] = {
            [itemKeys.name] = "Tor Kieldaz",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223219] = {
            [itemKeys.name] = "Fel Cloth Wristbands",
            [itemKeys.npcDrops] = {223340},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223221] = {
            [itemKeys.name] = "Fel Leather Wristbands",
            [itemKeys.npcDrops] = {223340},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223222] = {
            [itemKeys.name] = "Fel Mail Wristbands",
            [itemKeys.npcDrops] = {223340},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {220446},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223237] = {
            [itemKeys.name] = "Fel Cloth Shoulder Pads",
            [itemKeys.npcDrops] = {223542},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223148},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223238] = {
            [itemKeys.name] = "Fel Leather Shoulder Pads",
            [itemKeys.npcDrops] = {223542},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223148},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223239] = {
            [itemKeys.name] = "Fel Mail Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223148},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223240] = {
            [itemKeys.name] = "Fel Cloth Hood",
            [itemKeys.npcDrops] = {223543},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223149},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223241] = {
            [itemKeys.name] = "Fel Leather Hat",
            [itemKeys.npcDrops] = {223543},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223149},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223242] = {
            [itemKeys.name] = "Fel Mail Coif",
            [itemKeys.npcDrops] = {223543},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223149},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223248] = {
            [itemKeys.name] = "Fel Cloth Legs",
            [itemKeys.npcDrops] = {223544},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223249] = {
            [itemKeys.name] = "Fel Leather Legs",
            [itemKeys.npcDrops] = {223544},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223250] = {
            [itemKeys.name] = "Fel Mail Legs",
            [itemKeys.npcDrops] = {223544},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223251] = {
            [itemKeys.name] = "Fel Plate Legs",
            [itemKeys.npcDrops] = {223544},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223256] = {
            [itemKeys.name] = "Fel Cloth Robes",
            [itemKeys.npcDrops] = {223544},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223261] = {
            [itemKeys.name] = "Fel Leather Chest",
            [itemKeys.npcDrops] = {223544},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223262] = {
            [itemKeys.name] = "Fel Mail Chest",
            [itemKeys.npcDrops] = {223544},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223263] = {
            [itemKeys.name] = "Fel Plate Chest",
            [itemKeys.npcDrops] = {223544},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223150},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223283] = {
            [itemKeys.name] = "Bloodstained Commendation",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {218115,222413},
            [itemKeys.startQuest] = nil,
        },
        [223288] = {
            [itemKeys.name] = "Rune of the Hammer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687,233335},
            [itemKeys.startQuest] = nil,
        },
        [223323] = {
            [itemKeys.name] = "Premo's Poise-Demanding Uniform",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223324] = {
            [itemKeys.name] = "Rainstrider Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223325] = {
            [itemKeys.name] = "Hakkari Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {10773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223326] = {
            [itemKeys.name] = "Hakkari Shroud",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {10773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223327] = {
            [itemKeys.name] = "Mark of Hakkar",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {10773},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223328] = {
            [itemKeys.name] = "Gemburst Circlet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223329] = {
            [itemKeys.name] = "Lifeforce Dirk",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223330] = {
            [itemKeys.name] = "Pulsating Eye",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {445036},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223331] = {
            [itemKeys.name] = "Pulsating Eye",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223332] = {
            [itemKeys.name] = "Vibrating Eye",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {445037},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223333] = {
            [itemKeys.name] = "Baleful Eye",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {445044},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223334] = {
            [itemKeys.name] = "Glowing Eye",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {445039},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223335] = {
            [itemKeys.name] = "Oozing Eye",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {445040},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223336] = {
            [itemKeys.name] = "Piercing Eye",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {445042},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223337] = {
            [itemKeys.name] = "Burning Eye",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {445041},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223518] = {
            [itemKeys.name] = "Charstone Dirk",
            [itemKeys.npcDrops] = {12201},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223519] = {
            [itemKeys.name] = "Eye of Theradras",
            [itemKeys.npcDrops] = {12201},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223520] = {
            [itemKeys.name] = "Inventor's Focal Sword",
            [itemKeys.npcDrops] = {13601},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223521] = {
            [itemKeys.name] = "Rotgrip Mantle",
            [itemKeys.npcDrops] = {13596},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223522] = {
            [itemKeys.name] = "Helm of the Mountain",
            [itemKeys.npcDrops] = {12203},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223523] = {
            [itemKeys.name] = "Cloud Stone",
            [itemKeys.npcDrops] = {12203},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223524] = {
            [itemKeys.name] = "Fist of Stone",
            [itemKeys.npcDrops] = {12203},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223525] = {
            [itemKeys.name] = "Soothsayer's Headdress",
            [itemKeys.npcDrops] = {12225},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223526] = {
            [itemKeys.name] = "Sul'thraze the Lasher",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223527] = {
            [itemKeys.name] = "Gahz'rilla Fang",
            [itemKeys.npcDrops] = {7273},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223528] = {
            [itemKeys.name] = "Gahz'rilla Scale Armor",
            [itemKeys.npcDrops] = {7273},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223529] = {
            [itemKeys.name] = "Jinxed Hoodoo Skin",
            [itemKeys.npcDrops] = {7275},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223530] = {
            [itemKeys.name] = "Jinxed Hoodoo Kilt",
            [itemKeys.npcDrops] = {7275},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223531] = {
            [itemKeys.name] = "Big Bad Pauldrons",
            [itemKeys.npcDrops] = {7267},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223532] = {
            [itemKeys.name] = "Lifeblood Amulet",
            [itemKeys.npcDrops] = {8127},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223533] = {
            [itemKeys.name] = "Desertwalker Cane",
            [itemKeys.npcDrops] = {10081},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223534] = {
            [itemKeys.name] = "Jumanza Grips",
            [itemKeys.npcDrops] = {7271,220076},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223535] = {
            [itemKeys.name] = "Grimlok's Tribal Vestments",
            [itemKeys.npcDrops] = {4854},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223536] = {
            [itemKeys.name] = "Grimlok's Charge",
            [itemKeys.npcDrops] = {4854},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223537] = {
            [itemKeys.name] = "Skullplate Bracers",
            [itemKeys.npcDrops] = {4857},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223538] = {
            [itemKeys.name] = "Kindling Stave",
            [itemKeys.npcDrops] = {9024},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223539] = {
            [itemKeys.name] = "Enthralled Sphere",
            [itemKeys.npcDrops] = {9018},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223540] = {
            [itemKeys.name] = "Houndmaster's Bow",
            [itemKeys.npcDrops] = {9319},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223541] = {
            [itemKeys.name] = "Gemshard Heart",
            [itemKeys.npcDrops] = {12201},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223542] = {
            [itemKeys.name] = "Megashot Rifle",
            [itemKeys.npcDrops] = {13601},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223543] = {
            [itemKeys.name] = "Vinerot Sandals",
            [itemKeys.npcDrops] = {12258},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223544] = {
            [itemKeys.name] = "Dregmetal Spaulders",
            [itemKeys.npcDrops] = {9028},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223545] = {
            [itemKeys.name] = "Gizlock's Hypertech Buckler",
            [itemKeys.npcDrops] = {13601},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223648] = {
            [itemKeys.name] = "Dream Imbued Arrow",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [223912] = {
            [itemKeys.name] = "Purification Potion",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [223913] = {
            [itemKeys.name] = "Major Healing Potion",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [223914] = {
            [itemKeys.name] = "Greater Healing Potion",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [223962] = {
            [itemKeys.name] = "Sandstalker Ankleguards",
            [itemKeys.npcDrops] = {10082},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223963] = {
            [itemKeys.name] = "Embrace of the Lycan",
            [itemKeys.npcDrops] = {7267},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223964] = {
            [itemKeys.name] = "Blade of Eternal Darkness",
            [itemKeys.npcDrops] = {12201},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223980] = {
            [itemKeys.name] = "Searingscale Leggings",
            [itemKeys.npcDrops] = {9024},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223981] = {
            [itemKeys.name] = "Flamestrider Robes",
            [itemKeys.npcDrops] = {9024},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223982] = {
            [itemKeys.name] = "Houndmaster's Rifle",
            [itemKeys.npcDrops] = {9319},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223983] = {
            [itemKeys.name] = "Arbiter's Blade",
            [itemKeys.npcDrops] = {9041},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223984] = {
            [itemKeys.name] = "Silkweb Gloves",
            [itemKeys.npcDrops] = {9032},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223985] = {
            [itemKeys.name] = "Cyclopean Band",
            [itemKeys.npcDrops] = {9030},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223986] = {
            [itemKeys.name] = "Graverot Cape",
            [itemKeys.npcDrops] = {9031},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [223987] = {
            [itemKeys.name] = "Splinthide Shoulders",
            [itemKeys.npcDrops] = {9029},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [224004] = {
            [itemKeys.name] = "Emerald Ring",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [224005] = {
            [itemKeys.name] = "Emerald Ring",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [224006] = {
            [itemKeys.name] = "Emerald Ring",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {222684,222685,222686,222687},
            [itemKeys.startQuest] = nil,
        },
        [224122] = {
            [itemKeys.name] = "Dream Eater",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [224279] = {
            [itemKeys.name] = "Terrestris",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [224280] = {
            [itemKeys.name] = "Suzerain, Defender of the Dragonflights",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [224281] = {
            [itemKeys.name] = "Gla'sir",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [224282] = {
            [itemKeys.name] = "Rae'lar",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [224806] = {
            [itemKeys.name] = "Legion Portal Tuner",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {223150,224836,224848,224849,224850,224851,228615},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [224836] = {
            [itemKeys.name] = "Otherworldly Treasure",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [224848] = {
            [itemKeys.name] = "Otherworldly Treasure",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [224849] = {
            [itemKeys.name] = "Otherworldly Treasure",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [224850] = {
            [itemKeys.name] = "Otherworldly Treasure",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [224851] = {
            [itemKeys.name] = "Otherworldly Treasure",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [224893] = {
            [itemKeys.name] = "Overcharged Portal Tuner",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [224912] = {
            [itemKeys.name] = "Portal Tuner Tuner",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {224836,224848,224849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [225675] = {
            [itemKeys.name] = "Sooty Obsidian Core",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [225676] = {
            [itemKeys.name] = "Molten Obsidian Core",
            [itemKeys.npcDrops] = {7031,7032,228723},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [225686] = {
            [itemKeys.name] = "Rune of Decimation",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {224850,224851},
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [225687] = {
            [itemKeys.name] = "Rune of Infernal Armor",
            [itemKeys.npcDrops] = {228414},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [225688] = {
            [itemKeys.name] = "Rune of Mark of Chaos",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [225690] = {
            [itemKeys.name] = "Spell Notes: Frozen Orb",
            [itemKeys.npcDrops] = {228891},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [225691] = {
            [itemKeys.name] = "Spell Notes: Overheat",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [225740] = {
            [itemKeys.name] = "Rune of Composure",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [225838] = {
            [itemKeys.name] = "Voltaic Icon",
            [itemKeys.npcDrops] = {7158},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [225893] = {
            [itemKeys.name] = "Epoch's End",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [225914] = {
            [itemKeys.name] = "Rune of the Bound Spirit",
            [itemKeys.npcDrops] = {226982},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233428},
            [itemKeys.startQuest] = nil,
        },
        [225929] = {
            [itemKeys.name] = "Plagued Soul Shard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [225938] = {
            [itemKeys.name] = "Torn Spell Notes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [225939] = {
            [itemKeys.name] = "Torn Spell Notes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [225940] = {
            [itemKeys.name] = "Torn Spell Notes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [225941] = {
            [itemKeys.name] = "Torn Spell Notes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [225942] = {
            [itemKeys.name] = "Tainted Boar Meat",
            [itemKeys.npcDrops] = {16117},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [225943] = {
            [itemKeys.name] = "Rancid Hunk of Flesh",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [225954] = {
            [itemKeys.name] = "Charred Spell Notes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [225955] = {
            [itemKeys.name] = "Rune of the Resourceful",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {455023},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226122] = {
            [itemKeys.name] = "Dalton's Horn",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226201] = {
            [itemKeys.name] = "Squire Cuthbert's Blade",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {455812},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226207] = {
            [itemKeys.name] = "Echo of Anastari",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226208] = {
            [itemKeys.name] = "Echo of Barthilas",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226209] = {
            [itemKeys.name] = "Echo of Dathrohan",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226210] = {
            [itemKeys.name] = "Echo of Maleki",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226211] = {
            [itemKeys.name] = "Echo of Nerub'enkan",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226212] = {
            [itemKeys.name] = "Echo of Ramstein",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226213] = {
            [itemKeys.name] = "Echo of Rivendare",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226214] = {
            [itemKeys.name] = "Echo of Willey",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226252] = {
            [itemKeys.name] = "Rune of the Guerrilla",
            [itemKeys.npcDrops] = {227746},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226374] = {
            [itemKeys.name] = "Occult Poison I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226394] = {
            [itemKeys.name] = "Manual of Atrophic Poison",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047},
            [itemKeys.startQuest] = nil,
        },
        [226395] = {
            [itemKeys.name] = "Manual of Numbing Poison",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047},
            [itemKeys.startQuest] = nil,
        },
        [226396] = {
            [itemKeys.name] = "Manual of Occult Poison",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047},
            [itemKeys.startQuest] = nil,
        },
        [226397] = {
            [itemKeys.name] = "Manual of Sebacious Poison",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047},
            [itemKeys.startQuest] = nil,
        },
        [226398] = {
            [itemKeys.name] = "Testament of Martyrdom",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,233335},
            [itemKeys.startQuest] = nil,
        },
        [226399] = {
            [itemKeys.name] = "Testament of Avenging Wrath",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226400] = {
            [itemKeys.name] = "Testament of the Exorcist",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,233335},
            [itemKeys.startQuest] = nil,
        },
        [226401] = {
            [itemKeys.name] = "Treatise on the Heart of the Lion",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226402] = {
            [itemKeys.name] = "Revelation of Shamanistic Rage",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {4047,233428},
            [itemKeys.startQuest] = nil,
        },
        [226403] = {
            [itemKeys.name] = "Handbook of Meathook",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {1440,4047,233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226404] = {
            [itemKeys.name] = "Tarnished Undermine Real",
            [itemKeys.npcDrops] = {1853,6109,8983,9016,9017,9019,9033,9056,9156,9196,9236,9237,9502,9537,9568,9816,9938,10184,10220,10268,10363,10429,10430,10432,10433,10435,10436,10437,10438,10439,10440,10502,10503,10504,10505,10506,10507,10508,10516,10584,10596,10808,10811,10812,10901,10997,11032,11058,11143,11261,11380,11382,11486,11487,11488,11489,11490,11492,11496,11501,11583,11622,11981,11983,12017,12435,13020,13280,14020,14327,14354,14507,14509,14510,14515,14517,14601,14684,14690,14695,14834,15082,15083,15084,15085,15114,226922,226923,227019,227028,227140,228022,228429,228430,228431,228432,228433,228434,228435,228436,228438,230302,231494,232632,237439,237964,238024,238055,238213,238233,238234},
            [itemKeys.objectDrops] = {176215,179703,456775},
            [itemKeys.itemDrops] = {237263},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226405] = {
            [itemKeys.name] = "Damaged Undermine Supply Crate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226406] = {
            [itemKeys.name] = "Rune of Sword Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {457088},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226407] = {
            [itemKeys.name] = "Rune of Axe Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {457101},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226408] = {
            [itemKeys.name] = "Rune of Mace Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {457093},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226409] = {
            [itemKeys.name] = "Rune of Dagger Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {457100},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226410] = {
            [itemKeys.name] = "Rune of Ranged Weapon Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {457090},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226411] = {
            [itemKeys.name] = "Rune of Fist Weapon Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {457096},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226412] = {
            [itemKeys.name] = "Rune of Pole Weapon Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {457091},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226413] = {
            [itemKeys.name] = "Rune of Arcane Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {457102},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226414] = {
            [itemKeys.name] = "Rune of Fire Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {457097},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226415] = {
            [itemKeys.name] = "Rune of Frost Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {457095},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226416] = {
            [itemKeys.name] = "Rune of Nature Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {457092},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226417] = {
            [itemKeys.name] = "Rune of Shadow Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {457089},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226418] = {
            [itemKeys.name] = "Rune of Holy Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {457094},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226419] = {
            [itemKeys.name] = "Rune of Feral Combat Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {457098},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226420] = {
            [itemKeys.name] = "Finely Crafted Bust",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226421] = {
            [itemKeys.name] = "PLACEHOLDER_ASHBRINGER_QUESTITEM_01",
            [itemKeys.npcDrops] = {227866},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226440] = {
            [itemKeys.name] = "Nightslayer Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226441] = {
            [itemKeys.name] = "Nightslayer Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226442] = {
            [itemKeys.name] = "Nightslayer Bracelets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226443] = {
            [itemKeys.name] = "Nightslayer Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226444] = {
            [itemKeys.name] = "Nightslayer Shoulder Pads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226445] = {
            [itemKeys.name] = "Nightslayer Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226446] = {
            [itemKeys.name] = "Nightslayer Cover",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226447] = {
            [itemKeys.name] = "Nightslayer Chestpiece",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226472] = {
            [itemKeys.name] = "Stratholme Shadow Jar",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {176360},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226473] = {
            [itemKeys.name] = "Nightslayer Cuirass",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226474] = {
            [itemKeys.name] = "Nightslayer Waistguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226475] = {
            [itemKeys.name] = "Nightslayer Handguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226476] = {
            [itemKeys.name] = "Nightslayer Bracers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226477] = {
            [itemKeys.name] = "Nightslayer Tabi",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226478] = {
            [itemKeys.name] = "Nightslayer Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226479] = {
            [itemKeys.name] = "Nightslayer Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226480] = {
            [itemKeys.name] = "Nightslayer Hood",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226484] = {
            [itemKeys.name] = "Bracers of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226485] = {
            [itemKeys.name] = "Belt of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226486] = {
            [itemKeys.name] = "Gauntlets of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226487] = {
            [itemKeys.name] = "Sabatons of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226488] = {
            [itemKeys.name] = "Helm of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226489] = {
            [itemKeys.name] = "Breastplate of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226490] = {
            [itemKeys.name] = "Legplates of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226491] = {
            [itemKeys.name] = "Shoulderplates of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226492] = {
            [itemKeys.name] = "Pauldrons of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226493] = {
            [itemKeys.name] = "Leggings of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226494] = {
            [itemKeys.name] = "Hauberk of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226495] = {
            [itemKeys.name] = "Jaws of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226496] = {
            [itemKeys.name] = "Treads of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226497] = {
            [itemKeys.name] = "Hands of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226498] = {
            [itemKeys.name] = "Sash of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226499] = {
            [itemKeys.name] = "Armguards of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226500] = {
            [itemKeys.name] = "Chipped Drakefire Amulet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {3144,17804},
            [itemKeys.startQuest] = nil,
        },
        [226523] = {
            [itemKeys.name] = "Dalton's Horn",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226526] = {
            [itemKeys.name] = "Busted Gizmo",
            [itemKeys.npcDrops] = {11698,11722,11723,11724,11727,11730,11734,11735,11736,11737,11738,11739,11740,11744,11746,11880,11881,11882,12178,12179,15213},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226527] = {
            [itemKeys.name] = "Giantstalker's Epaulets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226528] = {
            [itemKeys.name] = "Giantstalker's Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226529] = {
            [itemKeys.name] = "Giantstalker's Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226530] = {
            [itemKeys.name] = "Giantstalker's Bracers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226531] = {
            [itemKeys.name] = "Giantstalker's Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226532] = {
            [itemKeys.name] = "Giantstalker's Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226533] = {
            [itemKeys.name] = "Giantstalker's Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226534] = {
            [itemKeys.name] = "Giantstalker's Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226535] = {
            [itemKeys.name] = "Giantstalker's Chainmail",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226536] = {
            [itemKeys.name] = "Giantstalker's Guise",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226537] = {
            [itemKeys.name] = "Giantstalker's Chain Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226538] = {
            [itemKeys.name] = "Giantstalker's Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226540] = {
            [itemKeys.name] = "Giantstalker's Handguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226541] = {
            [itemKeys.name] = "Giantstalker's Wristguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226542] = {
            [itemKeys.name] = "Giantstalker's Girdle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226543] = {
            [itemKeys.name] = "Giantstalker's Spauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226545] = {
            [itemKeys.name] = "Dalton's Horn",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226546] = {
            [itemKeys.name] = "Desert Sonar",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226547] = {
            [itemKeys.name] = "Felheart Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226548] = {
            [itemKeys.name] = "Felheart Robes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226549] = {
            [itemKeys.name] = "Felheart Horns",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226550] = {
            [itemKeys.name] = "Felheart Shoulder Pads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226551] = {
            [itemKeys.name] = "Felheart Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226552] = {
            [itemKeys.name] = "Felheart Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226553] = {
            [itemKeys.name] = "Felheart Bracers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226554] = {
            [itemKeys.name] = "Felheart Slippers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226555] = {
            [itemKeys.name] = "Arcanist Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226556] = {
            [itemKeys.name] = "Arcanist Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226557] = {
            [itemKeys.name] = "Arcanist Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226558] = {
            [itemKeys.name] = "Arcanist Bindings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226559] = {
            [itemKeys.name] = "Arcanist Robes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226560] = {
            [itemKeys.name] = "Arcanist Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226561] = {
            [itemKeys.name] = "Arcanist Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226562] = {
            [itemKeys.name] = "Arcanist Crown",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226563] = {
            [itemKeys.name] = "Arcanist Garments",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226564] = {
            [itemKeys.name] = "Arcanist Headdress",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226565] = {
            [itemKeys.name] = "Arcanist Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226566] = {
            [itemKeys.name] = "Arcanist Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226567] = {
            [itemKeys.name] = "Arcanist Wristwraps",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226568] = {
            [itemKeys.name] = "Arcanist Sandals",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226569] = {
            [itemKeys.name] = "Arcanist Handguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226570] = {
            [itemKeys.name] = "Arcanist Cord",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226571] = {
            [itemKeys.name] = "Boots of Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226572] = {
            [itemKeys.name] = "Gloves of Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226573] = {
            [itemKeys.name] = "Circlet of Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226574] = {
            [itemKeys.name] = "Pants of Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226575] = {
            [itemKeys.name] = "Robes of Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226576] = {
            [itemKeys.name] = "Mantle of Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226577] = {
            [itemKeys.name] = "Girdle of Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226578] = {
            [itemKeys.name] = "Vambraces of Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226579] = {
            [itemKeys.name] = "Wristwraps of Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226580] = {
            [itemKeys.name] = "Belt of Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226581] = {
            [itemKeys.name] = "Shoulderpads of Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226582] = {
            [itemKeys.name] = "Garments of Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226583] = {
            [itemKeys.name] = "Leggings of Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226584] = {
            [itemKeys.name] = "Crown of Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226585] = {
            [itemKeys.name] = "Hands of Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226586] = {
            [itemKeys.name] = "Sandals of Prophecy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226587] = {
            [itemKeys.name] = "Rune of Shelling",
            [itemKeys.npcDrops] = {227493},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226588] = {
            [itemKeys.name] = "Lawbringer Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226589] = {
            [itemKeys.name] = "Lawbringer Bracers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226590] = {
            [itemKeys.name] = "Lawbringer Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226591] = {
            [itemKeys.name] = "Lawbringer Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226592] = {
            [itemKeys.name] = "Lawbringer Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226593] = {
            [itemKeys.name] = "Lawbringer Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226594] = {
            [itemKeys.name] = "Lawbringer Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226595] = {
            [itemKeys.name] = "Lawbringer Chestguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226596] = {
            [itemKeys.name] = "Lawbringer Warbands",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226597] = {
            [itemKeys.name] = "Lawbringer Girdle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226598] = {
            [itemKeys.name] = "Lawbringer Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226599] = {
            [itemKeys.name] = "Lawbringer Crown",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226600] = {
            [itemKeys.name] = "Lawbringer Grips",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226601] = {
            [itemKeys.name] = "Lawbringer Battleboots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226602] = {
            [itemKeys.name] = "Lawbringer Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226603] = {
            [itemKeys.name] = "Lawbringer Vambraces",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226604] = {
            [itemKeys.name] = "Lawbringer Battlebelt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226605] = {
            [itemKeys.name] = "Lawbringer Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226606] = {
            [itemKeys.name] = "Lawbringer Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226607] = {
            [itemKeys.name] = "Lawbringer Headguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226608] = {
            [itemKeys.name] = "Lawbringer Handguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226609] = {
            [itemKeys.name] = "Lawbringer Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226610] = {
            [itemKeys.name] = "Lawbringer Chestplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226611] = {
            [itemKeys.name] = "Earthfury Epaulets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226612] = {
            [itemKeys.name] = "Earthfury Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226613] = {
            [itemKeys.name] = "Earthfury Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226614] = {
            [itemKeys.name] = "Earthfury Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226615] = {
            [itemKeys.name] = "Earthfury Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226616] = {
            [itemKeys.name] = "Earthfury Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226617] = {
            [itemKeys.name] = "Earthfury Vestments",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226618] = {
            [itemKeys.name] = "Earthfury Bracers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226619] = {
            [itemKeys.name] = "Earthfury Ringmail",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226620] = {
            [itemKeys.name] = "Earthfury Walkers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226621] = {
            [itemKeys.name] = "Earthfury Hands",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226622] = {
            [itemKeys.name] = "Earthfury Visor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226623] = {
            [itemKeys.name] = "Earthfury Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226624] = {
            [itemKeys.name] = "Earthfury Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226625] = {
            [itemKeys.name] = "Earthfury Cord",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226626] = {
            [itemKeys.name] = "Earthfury Wristbands",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226627] = {
            [itemKeys.name] = "Earthfury Scalemail",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226628] = {
            [itemKeys.name] = "Earthfury Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226629] = {
            [itemKeys.name] = "Earthfury Handguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226630] = {
            [itemKeys.name] = "Earthfury Greathelm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226631] = {
            [itemKeys.name] = "Earthfury Scaled Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226632] = {
            [itemKeys.name] = "Earthfury Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226633] = {
            [itemKeys.name] = "Earthfury Waistguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226634] = {
            [itemKeys.name] = "Earthfury Wristguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226635] = {
            [itemKeys.name] = "Earthfury Chainmail",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226636] = {
            [itemKeys.name] = "Earthfury Battleboots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226637] = {
            [itemKeys.name] = "Earthfury Grips",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226638] = {
            [itemKeys.name] = "Earthfury Headpiece",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226639] = {
            [itemKeys.name] = "Earthfury Chain Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226640] = {
            [itemKeys.name] = "Earthfury Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226641] = {
            [itemKeys.name] = "Earthfury Girdle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226642] = {
            [itemKeys.name] = "Earthfury Bindings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226644] = {
            [itemKeys.name] = "Cenarion Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226645] = {
            [itemKeys.name] = "Cenarion Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226646] = {
            [itemKeys.name] = "Cenarion Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226647] = {
            [itemKeys.name] = "Cenarion Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226648] = {
            [itemKeys.name] = "Cenarion Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226649] = {
            [itemKeys.name] = "Cenarion Bracers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226650] = {
            [itemKeys.name] = "Cenarion Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226651] = {
            [itemKeys.name] = "Cenarion Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226652] = {
            [itemKeys.name] = "Cenarion Sandals",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226653] = {
            [itemKeys.name] = "Cenarion Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226654] = {
            [itemKeys.name] = "Cenarion Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226655] = {
            [itemKeys.name] = "Cenarion Wrists",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226656] = {
            [itemKeys.name] = "Cenarion Embrace",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226657] = {
            [itemKeys.name] = "Cenarion Cord",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226658] = {
            [itemKeys.name] = "Cenarion Antlers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226659] = {
            [itemKeys.name] = "Cenarion Horns",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226660] = {
            [itemKeys.name] = "Cenarion Girdle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226661] = {
            [itemKeys.name] = "Cenarion Tunic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226662] = {
            [itemKeys.name] = "Cenarion Bands",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226663] = {
            [itemKeys.name] = "Cenarion Treads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226664] = {
            [itemKeys.name] = "Cenarion Fists",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226665] = {
            [itemKeys.name] = "Cenarion Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226666] = {
            [itemKeys.name] = "Cenarion Trousers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226667] = {
            [itemKeys.name] = "Cenarion Waistguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226668] = {
            [itemKeys.name] = "Cenarion Wristguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226669] = {
            [itemKeys.name] = "Cenarion Grips",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226670] = {
            [itemKeys.name] = "Cenarion Crown",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226671] = {
            [itemKeys.name] = "Cenarion Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226673] = {
            [itemKeys.name] = "Cenarion Walkers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226674] = {
            [itemKeys.name] = "Cenarion Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226675] = {
            [itemKeys.name] = "Cenarion Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227819,231178},
            [itemKeys.startQuest] = nil,
        },
        [226678] = {
            [itemKeys.name] = "Premonition and Combat Foresight",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226679] = {
            [itemKeys.name] = "Timeless Wanderer's Insights",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226680] = {
            [itemKeys.name] = "Rune of the First Warrior",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226694] = {
            [itemKeys.name] = "Rune of Defense Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [226697] = {
            [itemKeys.name] = "Red Bag",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226698] = {
            [itemKeys.name] = "Vertically Composited Patch Hampler",
            [itemKeys.npcDrops] = {228230,228231,228232,228609,228610},
            [itemKeys.objectDrops] = {456814},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226699] = {
            [itemKeys.name] = "Brass-fitted Flam-Tamp Flange",
            [itemKeys.npcDrops] = {228231,228232,228233,228609,228610},
            [itemKeys.objectDrops] = {456815},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226700] = {
            [itemKeys.name] = "Shadowcraft Tunic",
            [itemKeys.npcDrops] = {10363},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226701] = {
            [itemKeys.name] = "Shadowcraft Belt",
            [itemKeys.npcDrops] = {9097,9259,9260,9265,9716,9736,10318},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226702] = {
            [itemKeys.name] = "Shadowcraft Gloves",
            [itemKeys.npcDrops] = {9236},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226703] = {
            [itemKeys.name] = "Shadowcraft Boots",
            [itemKeys.npcDrops] = {11622},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226704] = {
            [itemKeys.name] = "Shadowcraft Bracers",
            [itemKeys.npcDrops] = {10405,10472,10488,10505},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226705] = {
            [itemKeys.name] = "Shadowcraft Pants",
            [itemKeys.npcDrops] = {10440},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226706] = {
            [itemKeys.name] = "Shadowcraft Spaulders",
            [itemKeys.npcDrops] = {10997},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226707] = {
            [itemKeys.name] = "Shadowcraft Cap",
            [itemKeys.npcDrops] = {1853},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226708] = {
            [itemKeys.name] = "Wildheart Cowl",
            [itemKeys.npcDrops] = {1853},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226709] = {
            [itemKeys.name] = "Wildheart Kilt",
            [itemKeys.npcDrops] = {10440},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226710] = {
            [itemKeys.name] = "Wildheart Spaulders",
            [itemKeys.npcDrops] = {10268},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226711] = {
            [itemKeys.name] = "Wildheart Gloves",
            [itemKeys.npcDrops] = {10516},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226712] = {
            [itemKeys.name] = "Wildheart Belt",
            [itemKeys.npcDrops] = {9258,9692,9736,10499,10500,10507,11257},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226713] = {
            [itemKeys.name] = "Wildheart Boots",
            [itemKeys.npcDrops] = {10596},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226714] = {
            [itemKeys.name] = "Wildheart Bracers",
            [itemKeys.npcDrops] = {10426,10463,10464,10495},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226715] = {
            [itemKeys.name] = "Wildheart Vest",
            [itemKeys.npcDrops] = {10363},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226716] = {
            [itemKeys.name] = "Beaststalker's Mantle",
            [itemKeys.npcDrops] = {9568},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226717] = {
            [itemKeys.name] = "Beaststalker's Bindings",
            [itemKeys.npcDrops] = {9096,10406,10407,10421},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226718] = {
            [itemKeys.name] = "Beaststalker's Belt",
            [itemKeys.npcDrops] = {9241,9258,9259,9260,9692,9736,10366},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226719] = {
            [itemKeys.name] = "Beaststalker's Pants",
            [itemKeys.npcDrops] = {10440},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226720] = {
            [itemKeys.name] = "Beaststalker's Cap",
            [itemKeys.npcDrops] = {1853},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226721] = {
            [itemKeys.name] = "Beaststalker's Gloves",
            [itemKeys.npcDrops] = {9237},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226722] = {
            [itemKeys.name] = "Beaststalker's Boots",
            [itemKeys.npcDrops] = {10437},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226723] = {
            [itemKeys.name] = "Beaststalker's Tunic",
            [itemKeys.npcDrops] = {10363},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226724] = {
            [itemKeys.name] = "Magister's Belt",
            [itemKeys.npcDrops] = {9239,10398,10400,10419,10422,10425,10469},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226725] = {
            [itemKeys.name] = "Magister's Bindings",
            [itemKeys.npcDrops] = {9098,9262,9264,9693,9736,10372},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226726] = {
            [itemKeys.name] = "Magister's Mantle",
            [itemKeys.npcDrops] = {10508},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226727] = {
            [itemKeys.name] = "Magister's Leggings",
            [itemKeys.npcDrops] = {10440},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226728] = {
            [itemKeys.name] = "Magister's Crown",
            [itemKeys.npcDrops] = {1853},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226729] = {
            [itemKeys.name] = "Magister's Robes",
            [itemKeys.npcDrops] = {10363},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226730] = {
            [itemKeys.name] = "Magister's Boots",
            [itemKeys.npcDrops] = {10558},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226731] = {
            [itemKeys.name] = "Magister's Gloves",
            [itemKeys.npcDrops] = {11261},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226732] = {
            [itemKeys.name] = "Lightforge Belt",
            [itemKeys.npcDrops] = {10408,10409,10418,10424},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226733] = {
            [itemKeys.name] = "Lightforge Helm",
            [itemKeys.npcDrops] = {1853},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226734] = {
            [itemKeys.name] = "Lightforge Breastplate",
            [itemKeys.npcDrops] = {10363},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226735] = {
            [itemKeys.name] = "Lightforge Spaulders",
            [itemKeys.npcDrops] = {10430},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226736] = {
            [itemKeys.name] = "Lightforge Legplates",
            [itemKeys.npcDrops] = {10440},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226737] = {
            [itemKeys.name] = "Lightforge Gauntlets",
            [itemKeys.npcDrops] = {10808},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226738] = {
            [itemKeys.name] = "Lightforge Boots",
            [itemKeys.npcDrops] = {10812},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226739] = {
            [itemKeys.name] = "Lightforge Bracers",
            [itemKeys.npcDrops] = {10486,10487,10504},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226740] = {
            [itemKeys.name] = "Devout Gloves",
            [itemKeys.npcDrops] = {10811},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226741] = {
            [itemKeys.name] = "Devout Mantle",
            [itemKeys.npcDrops] = {10264},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226742] = {
            [itemKeys.name] = "Devout Bracers",
            [itemKeys.npcDrops] = {10398,10400,10419,10420,10423},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226743] = {
            [itemKeys.name] = "Devout Sandals",
            [itemKeys.npcDrops] = {10438},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226744] = {
            [itemKeys.name] = "Devout Belt",
            [itemKeys.npcDrops] = {9098,9240,9261,9263,9717,9736,9818},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226745] = {
            [itemKeys.name] = "Devout Robe",
            [itemKeys.npcDrops] = {10363},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226746] = {
            [itemKeys.name] = "Devout Crown",
            [itemKeys.npcDrops] = {1853},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226747] = {
            [itemKeys.name] = "Devout Skirt",
            [itemKeys.npcDrops] = {10440},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226748] = {
            [itemKeys.name] = "Gauntlets of Elements",
            [itemKeys.npcDrops] = {9816},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226749] = {
            [itemKeys.name] = "Vest of Elements",
            [itemKeys.npcDrops] = {10363},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226750] = {
            [itemKeys.name] = "Kilt of Elements",
            [itemKeys.npcDrops] = {10440},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226751] = {
            [itemKeys.name] = "Bindings of Elements",
            [itemKeys.npcDrops] = {10412,10413,10478,11043},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226752] = {
            [itemKeys.name] = "Boots of Elements",
            [itemKeys.npcDrops] = {9196},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226753] = {
            [itemKeys.name] = "Pauldrons of Elements",
            [itemKeys.npcDrops] = {10339},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226754] = {
            [itemKeys.name] = "Cord of Elements",
            [itemKeys.npcDrops] = {9257,9262,9264,9266,9693,9736,10083},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226755] = {
            [itemKeys.name] = "Coif of Elements",
            [itemKeys.npcDrops] = {1853},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226756] = {
            [itemKeys.name] = "Dreadmist Mantle",
            [itemKeys.npcDrops] = {10503},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226757] = {
            [itemKeys.name] = "Dreadmist Robe",
            [itemKeys.npcDrops] = {10363},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226758] = {
            [itemKeys.name] = "Dreadmist Wraps",
            [itemKeys.npcDrops] = {10901},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226759] = {
            [itemKeys.name] = "Dreadmist Bracers",
            [itemKeys.npcDrops] = {9257,9261,9263,9269,9717,9736,9817},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226760] = {
            [itemKeys.name] = "Dreadmist Leggings",
            [itemKeys.npcDrops] = {10440},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226761] = {
            [itemKeys.name] = "Dreadmist Belt",
            [itemKeys.npcDrops] = {10398,10400,10419,10477},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226762] = {
            [itemKeys.name] = "Dreadmist Mask",
            [itemKeys.npcDrops] = {1853},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226763] = {
            [itemKeys.name] = "Dreadmist Sandals",
            [itemKeys.npcDrops] = {10436},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226764] = {
            [itemKeys.name] = "Boots of Valor",
            [itemKeys.npcDrops] = {10506},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226765] = {
            [itemKeys.name] = "Belt of Valor",
            [itemKeys.npcDrops] = {9268,10414,10416,10417},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226766] = {
            [itemKeys.name] = "Bracers of Valor",
            [itemKeys.npcDrops] = {9097,9259,9260,9267,9716,9736,10319},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226767] = {
            [itemKeys.name] = "Legplates of Valor",
            [itemKeys.npcDrops] = {10440},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226768] = {
            [itemKeys.name] = "Spaulders of Valor",
            [itemKeys.npcDrops] = {10429},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226769] = {
            [itemKeys.name] = "Helm of Valor",
            [itemKeys.npcDrops] = {1853},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226770] = {
            [itemKeys.name] = "Breastplate of Valor",
            [itemKeys.npcDrops] = {10363},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226771] = {
            [itemKeys.name] = "Gauntlets of Valor",
            [itemKeys.npcDrops] = {10439},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [226772] = {
            [itemKeys.name] = "Feralheart Sash",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227338},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226773] = {
            [itemKeys.name] = "Feralheart Cowl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227384},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226774] = {
            [itemKeys.name] = "Feralheart Galoshes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227360},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226775] = {
            [itemKeys.name] = "Feralheart Wraps",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226776] = {
            [itemKeys.name] = "Feralheart Vest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227384},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226777] = {
            [itemKeys.name] = "Feralheart Hands",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227338},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226778] = {
            [itemKeys.name] = "Feralheart Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227360},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226779] = {
            [itemKeys.name] = "Feralheart Kilt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227360},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226780] = {
            [itemKeys.name] = "Feralheart Cord",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227340},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226781] = {
            [itemKeys.name] = "Feralheart Sandals",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227365},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226782] = {
            [itemKeys.name] = "Feralheart Bindings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226783] = {
            [itemKeys.name] = "Feralheart Embrace",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227387},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226784] = {
            [itemKeys.name] = "Feralheart Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227340},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226785] = {
            [itemKeys.name] = "Feralheart Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227365},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226786] = {
            [itemKeys.name] = "Feralheart Headdress",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227387},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226787] = {
            [itemKeys.name] = "Feralheart Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227365},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226788] = {
            [itemKeys.name] = "Feralheart Bands",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226789] = {
            [itemKeys.name] = "Feralheart Girdle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227337},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226790] = {
            [itemKeys.name] = "Feralheart Epaulets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227359},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226791] = {
            [itemKeys.name] = "Feralheart Trousers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227359},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226792] = {
            [itemKeys.name] = "Feralheart Cap",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227383},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226793] = {
            [itemKeys.name] = "Feralheart Fists",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227337},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226794] = {
            [itemKeys.name] = "Feralheart Walkers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227359},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226795] = {
            [itemKeys.name] = "Feralheart Tunic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227383},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226796] = {
            [itemKeys.name] = "Feralheart Wristguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226797] = {
            [itemKeys.name] = "Feralheart Waistguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227339},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226798] = {
            [itemKeys.name] = "Feralheart Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226799] = {
            [itemKeys.name] = "Feralheart Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226801] = {
            [itemKeys.name] = "Feralheart Faceguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226802] = {
            [itemKeys.name] = "Feralheart Grips",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227339},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226803] = {
            [itemKeys.name] = "Feralheart Treads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226804] = {
            [itemKeys.name] = "Feralheart Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226815] = {
            [itemKeys.name] = "Feralheart Wrists",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226816] = {
            [itemKeys.name] = "Feralheart Waist",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226817] = {
            [itemKeys.name] = "Feralheart Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226818] = {
            [itemKeys.name] = "Feralheart Legs",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226819] = {
            [itemKeys.name] = "Feralheart Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226820] = {
            [itemKeys.name] = "Feralheart Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226821] = {
            [itemKeys.name] = "Feralheart Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226822] = {
            [itemKeys.name] = "Feralheart Chest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226825] = {
            [itemKeys.name] = "Darkmantle Tunic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227395},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226826] = {
            [itemKeys.name] = "Darkmantle Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227373},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226827] = {
            [itemKeys.name] = "Darkmantle Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227373},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226828] = {
            [itemKeys.name] = "Darkmantle Grips",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227348},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226829] = {
            [itemKeys.name] = "Darkmantle Cap",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227395},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226830] = {
            [itemKeys.name] = "Darkmantle Bracers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226831] = {
            [itemKeys.name] = "Darkmantle Footpads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227373},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226832] = {
            [itemKeys.name] = "Darkmantle Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227348},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226835] = {
            [itemKeys.name] = "Darkmantle Wristguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226836] = {
            [itemKeys.name] = "Darkmantle Waistguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226837] = {
            [itemKeys.name] = "Darkmantle Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226838] = {
            [itemKeys.name] = "Darkmantle Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226840] = {
            [itemKeys.name] = "Darkmantle Handguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226841] = {
            [itemKeys.name] = "Darkmantle Faceguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226842] = {
            [itemKeys.name] = "Darkmantle Treads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226843] = {
            [itemKeys.name] = "Darkmantle Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226845] = {
            [itemKeys.name] = "Darkmantle Wrists",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226846] = {
            [itemKeys.name] = "Darkmantle Waist",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226847] = {
            [itemKeys.name] = "Darkmantle Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226848] = {
            [itemKeys.name] = "Darkmantle Legs",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226849] = {
            [itemKeys.name] = "Darkmantle Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226850] = {
            [itemKeys.name] = "Darkmantle Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226851] = {
            [itemKeys.name] = "Darkmantle Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226852] = {
            [itemKeys.name] = "Darkmantle Chest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226856] = {
            [itemKeys.name] = "Guided Buoyancy Accelerant",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {214954},
            [itemKeys.startQuest] = nil,
        },
        [226857] = {
            [itemKeys.name] = "Battleboots of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227382},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226858] = {
            [itemKeys.name] = "Spaulders of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227382},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226859] = {
            [itemKeys.name] = "Legplates of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227382},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226860] = {
            [itemKeys.name] = "Crown of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227404},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226861] = {
            [itemKeys.name] = "Gauntlets of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227357},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226862] = {
            [itemKeys.name] = "Breastplate of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227404},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226863] = {
            [itemKeys.name] = "Bracers of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226864] = {
            [itemKeys.name] = "Belt of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227357},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226865] = {
            [itemKeys.name] = "Wristguards of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226866] = {
            [itemKeys.name] = "Waistguard of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227356},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226867] = {
            [itemKeys.name] = "Pauldrons of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227381},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226868] = {
            [itemKeys.name] = "Legguards of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227381},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226869] = {
            [itemKeys.name] = "Faceguard of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227403},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226870] = {
            [itemKeys.name] = "Handguards of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227356},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226871] = {
            [itemKeys.name] = "Sabatons of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227381},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226872] = {
            [itemKeys.name] = "Chestguard of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227403},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226873] = {
            [itemKeys.name] = "Wrists of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226874] = {
            [itemKeys.name] = "Waist of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226875] = {
            [itemKeys.name] = "Shoulders of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226876] = {
            [itemKeys.name] = "Legs of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226877] = {
            [itemKeys.name] = "Helm of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226878] = {
            [itemKeys.name] = "Gloves of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226879] = {
            [itemKeys.name] = "Boots of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226880] = {
            [itemKeys.name] = "Chest of Heroism",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226881] = {
            [itemKeys.name] = "Beastmaster's Treads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227366},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226882] = {
            [itemKeys.name] = "Beastmaster's Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227366},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226883] = {
            [itemKeys.name] = "Beastmaster's Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227341},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226884] = {
            [itemKeys.name] = "Beastmaster's Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227366},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226885] = {
            [itemKeys.name] = "Beastmaster's Bindings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226886] = {
            [itemKeys.name] = "Beastmaster's Tunic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227388},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226887] = {
            [itemKeys.name] = "Beastmaster's Cap",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227388},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226888] = {
            [itemKeys.name] = "Beastmaster's Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227341},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226889] = {
            [itemKeys.name] = "Beastmaster's Bracers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226890] = {
            [itemKeys.name] = "Beastmaster's Waistwrap",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227342},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226891] = {
            [itemKeys.name] = "Beastmaster's Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226892] = {
            [itemKeys.name] = "Beastmaster's Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226893] = {
            [itemKeys.name] = "Beastmaster's Coif",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226894] = {
            [itemKeys.name] = "Beastmaster's Fists",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227342},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226895] = {
            [itemKeys.name] = "Beastmaster's Greaves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226896] = {
            [itemKeys.name] = "Beastmaster's Chain",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226897] = {
            [itemKeys.name] = "Beastmaster's Wrists",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226898] = {
            [itemKeys.name] = "Beastmaster's Waist",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226899] = {
            [itemKeys.name] = "Beastmaster's Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226900] = {
            [itemKeys.name] = "Beastmaster's Legs",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226901] = {
            [itemKeys.name] = "Beastmaster's Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226902] = {
            [itemKeys.name] = "Beastmaster's Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226903] = {
            [itemKeys.name] = "Beastmaster's Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226904] = {
            [itemKeys.name] = "Beastmaster's Chest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226905] = {
            [itemKeys.name] = "Deathmist Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227354},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226906] = {
            [itemKeys.name] = "Deathmist Robe",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227401},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226907] = {
            [itemKeys.name] = "Deathmist Bracers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226908] = {
            [itemKeys.name] = "Deathmist Sandals",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227379},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226909] = {
            [itemKeys.name] = "Deathmist Mask",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227401},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226910] = {
            [itemKeys.name] = "Deathmist Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227379},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226911] = {
            [itemKeys.name] = "Deathmist Wraps",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227354},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226912] = {
            [itemKeys.name] = "Deathmist Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227379},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226913] = {
            [itemKeys.name] = "Deathmist Bindings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226914] = {
            [itemKeys.name] = "Deathmist Cord",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227355},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226915] = {
            [itemKeys.name] = "Deathmist Epaulets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227380},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226916] = {
            [itemKeys.name] = "Deathmist Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227380},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226917] = {
            [itemKeys.name] = "Deathmist Hood",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227402},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226918] = {
            [itemKeys.name] = "Deathmist Grasps",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227355},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226919] = {
            [itemKeys.name] = "Deathmist Treads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227380},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226920] = {
            [itemKeys.name] = "Deathmist Embrace",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227402},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226921] = {
            [itemKeys.name] = "Deathmist Wrists",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226922] = {
            [itemKeys.name] = "Deathmist Waist",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226923] = {
            [itemKeys.name] = "Deathmist Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226924] = {
            [itemKeys.name] = "Deathmist Legs",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226925] = {
            [itemKeys.name] = "Deathmist Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226926] = {
            [itemKeys.name] = "Deathmist Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226927] = {
            [itemKeys.name] = "Deathmist Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226928] = {
            [itemKeys.name] = "Deathmist Chest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226929] = {
            [itemKeys.name] = "Sorcerer's Bindings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226930] = {
            [itemKeys.name] = "Sorcerer's Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226931] = {
            [itemKeys.name] = "Sorcerer's Sandals",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226932] = {
            [itemKeys.name] = "Sorcerer's Robes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226933] = {
            [itemKeys.name] = "Sorcerer's Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226934] = {
            [itemKeys.name] = "Sorcerer's Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226935] = {
            [itemKeys.name] = "Sorcerer's Crown",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226936] = {
            [itemKeys.name] = "Sorcerer's Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226937] = {
            [itemKeys.name] = "Sorcerer's Wrists",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226938] = {
            [itemKeys.name] = "Sorcerer's Waist",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226939] = {
            [itemKeys.name] = "Sorcerer's Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226940] = {
            [itemKeys.name] = "Sorcerer's Legs",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226941] = {
            [itemKeys.name] = "Sorcerer's Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226942] = {
            [itemKeys.name] = "Sorcerer's Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226943] = {
            [itemKeys.name] = "Sorcerer's Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226944] = {
            [itemKeys.name] = "Sorcerer's Chest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226945] = {
            [itemKeys.name] = "Virtuous Robe",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227393},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226946] = {
            [itemKeys.name] = "Virtuous Skirt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227371},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226947] = {
            [itemKeys.name] = "Virtuous Crown",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227393},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226948] = {
            [itemKeys.name] = "Virtuous Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227346},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226949] = {
            [itemKeys.name] = "Virtuous Bracers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226950] = {
            [itemKeys.name] = "Virtuous Mitts",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227346},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226951] = {
            [itemKeys.name] = "Virtuous Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227371},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226952] = {
            [itemKeys.name] = "Virtuous Sandals",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227371},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226953] = {
            [itemKeys.name] = "Virtuous Wraps",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226954] = {
            [itemKeys.name] = "Virtuous Cord",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227347},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226955] = {
            [itemKeys.name] = "Virtuous Epaulets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227372},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226956] = {
            [itemKeys.name] = "Virtuous Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227372},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226957] = {
            [itemKeys.name] = "Virtuous Cowl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227394},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226958] = {
            [itemKeys.name] = "Virtuous Hands",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227347},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226959] = {
            [itemKeys.name] = "Virtuous Slippers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227372},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226960] = {
            [itemKeys.name] = "Virtuous Gown",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227394},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226961] = {
            [itemKeys.name] = "Virtuous Wrists",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226962] = {
            [itemKeys.name] = "Virtuous Waist",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226963] = {
            [itemKeys.name] = "Virtuous Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226964] = {
            [itemKeys.name] = "Virtuous Legs",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226965] = {
            [itemKeys.name] = "Virtuous Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226966] = {
            [itemKeys.name] = "Virtuous Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226967] = {
            [itemKeys.name] = "Virtuous Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226968] = {
            [itemKeys.name] = "Virtuous Chest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226969] = {
            [itemKeys.name] = "Soulforge Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227369},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226970] = {
            [itemKeys.name] = "Soulforge Bracers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226971] = {
            [itemKeys.name] = "Soulforge Belt",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227344},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226972] = {
            [itemKeys.name] = "Soulforge Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227369},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226973] = {
            [itemKeys.name] = "Soulforge Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227391},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226974] = {
            [itemKeys.name] = "Soulforge Warboots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227369},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226975] = {
            [itemKeys.name] = "Soulforge Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227344},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226976] = {
            [itemKeys.name] = "Soulforge Greathelm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227391},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226977] = {
            [itemKeys.name] = "Soulforge Bindings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226978] = {
            [itemKeys.name] = "Soulforge Cord",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227343},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226979] = {
            [itemKeys.name] = "Soulforge Epaulets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227368},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226980] = {
            [itemKeys.name] = "Soulforge Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227368},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226981] = {
            [itemKeys.name] = "Soulforge Crown",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227390},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226982] = {
            [itemKeys.name] = "Soulforge Fists",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227343},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226983] = {
            [itemKeys.name] = "Soulforge Treads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227368},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226984] = {
            [itemKeys.name] = "Soulforge Embrace",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227390},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226985] = {
            [itemKeys.name] = "Soulforge Wristguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226986] = {
            [itemKeys.name] = "Soulforge Waistguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227345},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226987] = {
            [itemKeys.name] = "Soulforge Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227370},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226988] = {
            [itemKeys.name] = "Soulforge Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227370},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226989] = {
            [itemKeys.name] = "Soulforge Faceguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227392},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226990] = {
            [itemKeys.name] = "Soulforge Handguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227345},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226991] = {
            [itemKeys.name] = "Soulforge Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227370},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226992] = {
            [itemKeys.name] = "Soulforge Chestguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227392},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [226993] = {
            [itemKeys.name] = "Soulforge Wrists",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226994] = {
            [itemKeys.name] = "Soulforge Waist",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226995] = {
            [itemKeys.name] = "Soulforge Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226996] = {
            [itemKeys.name] = "Soulforge Legs",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226997] = {
            [itemKeys.name] = "Soulforge Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226998] = {
            [itemKeys.name] = "Soulforge Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [226999] = {
            [itemKeys.name] = "Soulforge Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227000] = {
            [itemKeys.name] = "Soulforge Chest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227001] = {
            [itemKeys.name] = "Bindings of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227002] = {
            [itemKeys.name] = "Coif of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227398},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227003] = {
            [itemKeys.name] = "Pauldrons of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227376},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227004] = {
            [itemKeys.name] = "Vest of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227398},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227005] = {
            [itemKeys.name] = "Kilt of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227376},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227006] = {
            [itemKeys.name] = "Gauntlets of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227351},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227007] = {
            [itemKeys.name] = "Slippers of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227376},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227008] = {
            [itemKeys.name] = "Cord of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227351},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227009] = {
            [itemKeys.name] = "Bracers of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227010] = {
            [itemKeys.name] = "Sash of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227350},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227011] = {
            [itemKeys.name] = "Mantle of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227375},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227012] = {
            [itemKeys.name] = "Leggings of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227375},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227013] = {
            [itemKeys.name] = "Crown of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227397},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227014] = {
            [itemKeys.name] = "Grasp of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227350},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227015] = {
            [itemKeys.name] = "Greaves of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227375},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227016] = {
            [itemKeys.name] = "Tunic of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227397},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227017] = {
            [itemKeys.name] = "Bands of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227018] = {
            [itemKeys.name] = "Girdle of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227352},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227019] = {
            [itemKeys.name] = "Spaulders of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227377},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227020] = {
            [itemKeys.name] = "Legplates of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227377},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227021] = {
            [itemKeys.name] = "Face of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227399},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227022] = {
            [itemKeys.name] = "Fists of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227352},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227023] = {
            [itemKeys.name] = "Treads of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227377},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227024] = {
            [itemKeys.name] = "Chain of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227399},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227025] = {
            [itemKeys.name] = "Wristguards of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227026] = {
            [itemKeys.name] = "Waistguard of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227353},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227027] = {
            [itemKeys.name] = "Shoulderguards of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227378},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227028] = {
            [itemKeys.name] = "Legguards of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227378},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227029] = {
            [itemKeys.name] = "Headpiece of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227400},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227030] = {
            [itemKeys.name] = "Handguards of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227353},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227031] = {
            [itemKeys.name] = "Sabatons of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227378},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227032] = {
            [itemKeys.name] = "Chestguard of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = {227400},
            [itemKeys.vendors] = {230317,230319,230565,230566},
            [itemKeys.startQuest] = nil,
        },
        [227033] = {
            [itemKeys.name] = "Wrists of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227034] = {
            [itemKeys.name] = "Waist of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227035] = {
            [itemKeys.name] = "Shoulders of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227036] = {
            [itemKeys.name] = "Legs of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227037] = {
            [itemKeys.name] = "Helm of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227038] = {
            [itemKeys.name] = "Gloves of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227039] = {
            [itemKeys.name] = "Boots of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227040] = {
            [itemKeys.name] = "Chest of The Five Thunders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227041] = {
            [itemKeys.name] = "Scourge Shadow Scalpel",
            [itemKeys.npcDrops] = {8528,8550},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227042] = {
            [itemKeys.name] = "Champion's Plate Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227043] = {
            [itemKeys.name] = "Champion's Plate Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227044] = {
            [itemKeys.name] = "Lieutenant Commander's Plate Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227045] = {
            [itemKeys.name] = "Lieutenant Commander's Plate Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227046] = {
            [itemKeys.name] = "Knight-Captain's Plate Hauberk",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227047] = {
            [itemKeys.name] = "Knight-Captain's Plate Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227048] = {
            [itemKeys.name] = "Legionnaire's Plate Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227049] = {
            [itemKeys.name] = "Legionnaire's Plate Hauberk",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227050] = {
            [itemKeys.name] = "Blood Guard's Plate Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227051] = {
            [itemKeys.name] = "Blood Guard's Plate Greaves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227052] = {
            [itemKeys.name] = "Knight-Lieutenant's Plate Greaves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227053] = {
            [itemKeys.name] = "Knight-Lieutenant's Plate Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227054] = {
            [itemKeys.name] = "Lieutenant Commander's Leather Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227055] = {
            [itemKeys.name] = "Lieutenant Commander's Leather Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227056] = {
            [itemKeys.name] = "Champion's Leather Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227057] = {
            [itemKeys.name] = "Champion's Leather Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227058] = {
            [itemKeys.name] = "Knight-Captain's Leather Chestpiece",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227059] = {
            [itemKeys.name] = "Legionnaire's Leather Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227060] = {
            [itemKeys.name] = "Legionnaire's Leather Chestpiece",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227061] = {
            [itemKeys.name] = "Knight-Captain's Leather Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227062] = {
            [itemKeys.name] = "Blood Guard's Leather Walkers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227063] = {
            [itemKeys.name] = "Blood Guard's Leather Grips",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227064] = {
            [itemKeys.name] = "Knight-Lieutenant's Leather Walkers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227065] = {
            [itemKeys.name] = "Knight-Lieutenant's Leather Grips",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227066] = {
            [itemKeys.name] = "Lieutenant Commander's Chain Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227067] = {
            [itemKeys.name] = "Champion's Chain Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227068] = {
            [itemKeys.name] = "Lieutenant Commander's Chain Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227069] = {
            [itemKeys.name] = "Champion's Chain Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227070] = {
            [itemKeys.name] = "Knight-Captain's Chain Hauberk",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227071] = {
            [itemKeys.name] = "Legionnaire's Chain Hauberk",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227072] = {
            [itemKeys.name] = "Knight-Captain's Chain Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227073] = {
            [itemKeys.name] = "Legionnaire's Chain Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227074] = {
            [itemKeys.name] = "Blood Guard's Chain Greaves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227075] = {
            [itemKeys.name] = "Blood Guard's Chain Vices",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227076] = {
            [itemKeys.name] = "Knight-Lieutenant's Chain Greaves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227077] = {
            [itemKeys.name] = "Knight-Lieutenant's Chain Vices",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227078] = {
            [itemKeys.name] = "Champion's Chain Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227079] = {
            [itemKeys.name] = "Legionnaire's Chain Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227080] = {
            [itemKeys.name] = "Champion's Chain Greathelm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227081] = {
            [itemKeys.name] = "Blood Guard's Chain Grips",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227082] = {
            [itemKeys.name] = "Blood Guard's Chain Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227083] = {
            [itemKeys.name] = "Legionnaire's Chain Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227084] = {
            [itemKeys.name] = "Lieutenant Commander's Chain Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227085] = {
            [itemKeys.name] = "Knight-Captain's Chain Legplates",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227086] = {
            [itemKeys.name] = "Lieutenant Commander's Chain Greathelm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227087] = {
            [itemKeys.name] = "Knight-Lieutenant's Chain Grips",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227088] = {
            [itemKeys.name] = "Knight-Lieutenant's Chain Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227089] = {
            [itemKeys.name] = "Knight-Captain's Chain Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227090] = {
            [itemKeys.name] = "Champion's Dreadweave Cowl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227091] = {
            [itemKeys.name] = "Lieutenant Commander's Dreadweave Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227092] = {
            [itemKeys.name] = "Champion's Dreadweave Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227093] = {
            [itemKeys.name] = "Lieutenant Commander's Dreadweave Cowl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227094] = {
            [itemKeys.name] = "Legionnaire's Dreadweave Tunic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227095] = {
            [itemKeys.name] = "Knight-Captain's Dreadweave Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227096] = {
            [itemKeys.name] = "Knight-Captain's Dreadweave Tunic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227097] = {
            [itemKeys.name] = "Legionnaire's Dreadweave Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227098] = {
            [itemKeys.name] = "Blood Guard's Dreadweave Walkers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227099] = {
            [itemKeys.name] = "Blood Guard's Dreadweave Handwraps",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227100] = {
            [itemKeys.name] = "Knight-Lieutenant's Dreadweave Handwraps",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227101] = {
            [itemKeys.name] = "Knight-Lieutenant's Dreadweave Walkers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227102] = {
            [itemKeys.name] = "Lieutenant Commander's Silk Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227103] = {
            [itemKeys.name] = "Lieutenant Commander's Silk Cowl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227104] = {
            [itemKeys.name] = "Champion's Silk Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227105] = {
            [itemKeys.name] = "Champion's Silk Cowl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227106] = {
            [itemKeys.name] = "Legionnaire's Silk Tunic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227107] = {
            [itemKeys.name] = "Legionnaire's Silk Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227108] = {
            [itemKeys.name] = "Knight-Captain's Silk Tunic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227109] = {
            [itemKeys.name] = "Knight-Captain's Silk Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227110] = {
            [itemKeys.name] = "Blood Guard's Silk Walkers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227111] = {
            [itemKeys.name] = "Blood Guard's Silk Handwraps",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227112] = {
            [itemKeys.name] = "Knight-Lieutenant's Silk Walkers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227113] = {
            [itemKeys.name] = "Knight-Lieutenant's Silk Handwraps",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227114] = {
            [itemKeys.name] = "Knight-Lieutenant's Silk Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227115] = {
            [itemKeys.name] = "Blood Guard's Silk Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227116] = {
            [itemKeys.name] = "Knight-Lieutenant's Silk Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227117] = {
            [itemKeys.name] = "Blood Guard's Silk Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227118] = {
            [itemKeys.name] = "Champion's Satin Hood",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227119] = {
            [itemKeys.name] = "Lieutenant Commander's Satin Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227120] = {
            [itemKeys.name] = "Champion's Satin Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227121] = {
            [itemKeys.name] = "Lieutenant Commander's Satin Hood",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227122] = {
            [itemKeys.name] = "Knight-Captain's Satin Tunic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227123] = {
            [itemKeys.name] = "Legionnaire's Satin Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227124] = {
            [itemKeys.name] = "Legionnaire's Satin Tunic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227125] = {
            [itemKeys.name] = "Knight-Captain's Satin Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227126] = {
            [itemKeys.name] = "Blood Guard's Satin Handwraps",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227127] = {
            [itemKeys.name] = "Blood Guard's Satin Walkers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227128] = {
            [itemKeys.name] = "Knight-Lieutenant's Satin Handwraps",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227129] = {
            [itemKeys.name] = "Knight-Lieutenant's Satin Walkers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227130] = {
            [itemKeys.name] = "Champion's Satin Epaulets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227131] = {
            [itemKeys.name] = "Legionnaire's Satin Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227132] = {
            [itemKeys.name] = "Champion's Satin Crown",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227133] = {
            [itemKeys.name] = "Blood Guard's Satin Grips",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227134] = {
            [itemKeys.name] = "Blood Guard's Satin Treads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227135] = {
            [itemKeys.name] = "Legionnaire's Satin Robe",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227136] = {
            [itemKeys.name] = "Lieutenant Commander's Satin Epaulets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227137] = {
            [itemKeys.name] = "Knight-Captain's Satin Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227138] = {
            [itemKeys.name] = "Lieutenant Commander's Satin Crown",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227139] = {
            [itemKeys.name] = "Knight-Lieutenant's Satin Grips",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227140] = {
            [itemKeys.name] = "Knight-Lieutenant's Satin Treads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227141] = {
            [itemKeys.name] = "Knight-Captain's Satin Robe",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227142] = {
            [itemKeys.name] = "Knight-Captain's Lamellar Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227143] = {
            [itemKeys.name] = "Knight-Captain's Lamellar Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227144] = {
            [itemKeys.name] = "Lieutenant Commander's Lamellar Headguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227145] = {
            [itemKeys.name] = "Lieutenant Commander's Lamellar Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227146] = {
            [itemKeys.name] = "Knight-Lieutenant's Lamellar Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227147] = {
            [itemKeys.name] = "Knight-Lieutenant's Lamellar Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227148] = {
            [itemKeys.name] = "Lieutenant Commander's Lamellar Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227149] = {
            [itemKeys.name] = "Lieutenant Commander's Lamellar Helmet",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227150] = {
            [itemKeys.name] = "Knight-Captain's Lamellar Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227151] = {
            [itemKeys.name] = "Knight-Captain's Lamellar Chestplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227152] = {
            [itemKeys.name] = "Knight-Lieutenant's Lamellar Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227153] = {
            [itemKeys.name] = "Knight-Lieutenant's Lamellar Greaves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227154] = {
            [itemKeys.name] = "Champion's Mail Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227155] = {
            [itemKeys.name] = "Champion's Mail Headguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227156] = {
            [itemKeys.name] = "Legionnaire's Mail Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227157] = {
            [itemKeys.name] = "Legionnaire's Mail Hauberk",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227158] = {
            [itemKeys.name] = "Blood Guard's Mail Greaves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227159] = {
            [itemKeys.name] = "Blood Guard's Mail Vices",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227160] = {
            [itemKeys.name] = "Champion's Mail Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227161] = {
            [itemKeys.name] = "Legionnaire's Mail Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227162] = {
            [itemKeys.name] = "Champion's Mail Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227163] = {
            [itemKeys.name] = "Blood Guard's Mail Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227164] = {
            [itemKeys.name] = "Blood Guard's Mail Sabatons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227165] = {
            [itemKeys.name] = "Legionnaire's Mail Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227166] = {
            [itemKeys.name] = "Champion's Mail Epaulets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227167] = {
            [itemKeys.name] = "Legionnaire's Mail Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227168] = {
            [itemKeys.name] = "Champion's Mail Skullcap",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227169] = {
            [itemKeys.name] = "Blood Guard's Mail Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227170] = {
            [itemKeys.name] = "Blood Guard's Mail Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227171] = {
            [itemKeys.name] = "Legionnaire's Mail Chestguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227172] = {
            [itemKeys.name] = "Lieutenant Commander's Dragonhide Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227173] = {
            [itemKeys.name] = "Lieutenant Commander's Dragonhide Headguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227174] = {
            [itemKeys.name] = "Champion's Dragonhide Headguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227175] = {
            [itemKeys.name] = "Champion's Dragonhide Shoulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227176] = {
            [itemKeys.name] = "Knight-Captain's Dragonhide Chestpiece",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227177] = {
            [itemKeys.name] = "Legionnaire's Dragonhide Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227178] = {
            [itemKeys.name] = "Knight-Captain's Dragonhide Leggings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227179] = {
            [itemKeys.name] = "Legionnaire's Dragonhide Chestpiece",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227180] = {
            [itemKeys.name] = "Blood Guard's Dragonhide Grips",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227181] = {
            [itemKeys.name] = "Blood Guard's Dragonhide Treads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227182] = {
            [itemKeys.name] = "Knight-Lieutenant's Dragonhide Treads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227183] = {
            [itemKeys.name] = "Knight-Lieutenant's Dragonhide Grips",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227184] = {
            [itemKeys.name] = "Champion's Dragonhide Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227185] = {
            [itemKeys.name] = "Legionnaire's Dragonhide Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227186] = {
            [itemKeys.name] = "Champion's Dragonhide Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227187] = {
            [itemKeys.name] = "Blood Guard's Dragonhide Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227188] = {
            [itemKeys.name] = "Blood Guard's Dragonhide Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227189] = {
            [itemKeys.name] = "Legionnaire's Dragonhide Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227190] = {
            [itemKeys.name] = "Lieutenant Commander's Dragonhide Spaulders",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227191] = {
            [itemKeys.name] = "Knight-Captain's Dragonhide Pants",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227192] = {
            [itemKeys.name] = "Lieutenant Commander's Dragonhide Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227193] = {
            [itemKeys.name] = "Knight-Lieutenant's Dragonhide Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227194] = {
            [itemKeys.name] = "Knight-Lieutenant's Dragonhide Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227195] = {
            [itemKeys.name] = "Knight-Captain's Dragonhide Armor",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227196] = {
            [itemKeys.name] = "Knight-Captain's Dragonhide Tunic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227197] = {
            [itemKeys.name] = "Knight-Lieutenant's Dragonhide Greaves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227198] = {
            [itemKeys.name] = "Knight-Lieutenant's Dragonhide Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227199] = {
            [itemKeys.name] = "Lieutenant Commander's Dragonhide Headdress",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227200] = {
            [itemKeys.name] = "Knight-Captain's Dragonhide Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227201] = {
            [itemKeys.name] = "Lieutenant Commander's Dragonhide Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12777},
            [itemKeys.startQuest] = nil,
        },
        [227202] = {
            [itemKeys.name] = "Legionnaire's Dragonhide Tunic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227203] = {
            [itemKeys.name] = "Blood Guard's Dragonhide Greaves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227204] = {
            [itemKeys.name] = "Blood Guard's Dragonhide Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227205] = {
            [itemKeys.name] = "Champion's Dragonhide Headdress",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227206] = {
            [itemKeys.name] = "Legionnaire's Dragonhide Legguards",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227207] = {
            [itemKeys.name] = "Champion's Dragonhide Pauldrons",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {12792},
            [itemKeys.startQuest] = nil,
        },
        [227279] = {
            [itemKeys.name] = "Loop of the Magister",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [227280] = {
            [itemKeys.name] = "Craft of the Shadows",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [227282] = {
            [itemKeys.name] = "Ring of the Dreaded Mist",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [227284] = {
            [itemKeys.name] = "Band of the Beast",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [227285] = {
            [itemKeys.name] = "Structural Dynamics of Flow",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227286] = {
            [itemKeys.name] = "Warmed Rumsey Rum with Cream",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227337] = {
            [itemKeys.name] = "Feline Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227338] = {
            [itemKeys.name] = "Astral Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227339] = {
            [itemKeys.name] = "Guardian's Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227340] = {
            [itemKeys.name] = "Mender's Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227341] = {
            [itemKeys.name] = "Pursuer's Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227342] = {
            [itemKeys.name] = "Prowler's Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227343] = {
            [itemKeys.name] = "Merciful Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227344] = {
            [itemKeys.name] = "Radiant Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227345] = {
            [itemKeys.name] = "Divine Will Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227346] = {
            [itemKeys.name] = "Dawn Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227347] = {
            [itemKeys.name] = "Twilight Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227348] = {
            [itemKeys.name] = "Thrill's Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227349] = {
            [itemKeys.name] = "Battle's Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227350] = {
            [itemKeys.name] = "Relief's Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227351] = {
            [itemKeys.name] = "Eruption's Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227352] = {
            [itemKeys.name] = "Impact's Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227353] = {
            [itemKeys.name] = "Resolve's Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227354] = {
            [itemKeys.name] = "Corrupted Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227355] = {
            [itemKeys.name] = "Wicked Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227356] = {
            [itemKeys.name] = "Immoveable Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227357] = {
            [itemKeys.name] = "Unstoppable Gloves and Belt Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227359] = {
            [itemKeys.name] = "Feline Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227360] = {
            [itemKeys.name] = "Astral Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227361] = {
            [itemKeys.name] = "Guardian's Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227365] = {
            [itemKeys.name] = "Mender's Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227366] = {
            [itemKeys.name] = "Pursuer's Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227367] = {
            [itemKeys.name] = "Prowler's Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227368] = {
            [itemKeys.name] = "Merciful Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227369] = {
            [itemKeys.name] = "Radiant Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227370] = {
            [itemKeys.name] = "Divine Will Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227371] = {
            [itemKeys.name] = "Dawn Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227372] = {
            [itemKeys.name] = "Twilight Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227373] = {
            [itemKeys.name] = "Thrill's Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227374] = {
            [itemKeys.name] = "Battle's Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227375] = {
            [itemKeys.name] = "Relief's Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227376] = {
            [itemKeys.name] = "Eruption's Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227377] = {
            [itemKeys.name] = "Impact's Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227378] = {
            [itemKeys.name] = "Resolve's Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227379] = {
            [itemKeys.name] = "Corrupted Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227380] = {
            [itemKeys.name] = "Wicked Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227381] = {
            [itemKeys.name] = "Immoveable Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227382] = {
            [itemKeys.name] = "Unstoppable Boots, Legs, and Shoulders Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227383] = {
            [itemKeys.name] = "Feline Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227384] = {
            [itemKeys.name] = "Astral Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227385] = {
            [itemKeys.name] = "Guardian's Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227387] = {
            [itemKeys.name] = "Mender's Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227388] = {
            [itemKeys.name] = "Pursuer's Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227389] = {
            [itemKeys.name] = "Prowler's Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227390] = {
            [itemKeys.name] = "Merciful Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227391] = {
            [itemKeys.name] = "Radiant Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227392] = {
            [itemKeys.name] = "Divine Will Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227393] = {
            [itemKeys.name] = "Dawn Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227394] = {
            [itemKeys.name] = "Twilight Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227395] = {
            [itemKeys.name] = "Thrill's Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227396] = {
            [itemKeys.name] = "Battle's Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227397] = {
            [itemKeys.name] = "Relief's Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227398] = {
            [itemKeys.name] = "Eruption's Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227399] = {
            [itemKeys.name] = "Impact's Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227400] = {
            [itemKeys.name] = "Resolve's Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227401] = {
            [itemKeys.name] = "Corrupted Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227402] = {
            [itemKeys.name] = "Wicked Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227403] = {
            [itemKeys.name] = "Immoveable Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227404] = {
            [itemKeys.name] = "Unstoppable Helm and Chestpiece Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227444] = {
            [itemKeys.name] = "Idol of the Huntress",
            [itemKeys.npcDrops] = {6505,6506,6507,6508},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [227451] = {
            [itemKeys.name] = "Sending Sigil",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227454] = {
            [itemKeys.name] = "Tidal Loop",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227455] = {
            [itemKeys.name] = "Ocean's Breeze",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227456] = {
            [itemKeys.name] = "Rune of the Crimson Tempest",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {461633},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [227530] = {
            [itemKeys.name] = "Incandescent Belt",
            [itemKeys.npcDrops] = {10184,228433,228435,228436,228438},
            [itemKeys.objectDrops] = {179703},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [227531] = {
            [itemKeys.name] = "Incandescent Bindings",
            [itemKeys.npcDrops] = {10184,228434,228435,228436,228438},
            [itemKeys.objectDrops] = {179703},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [227532] = {
            [itemKeys.name] = "Incandescent Hood",
            [itemKeys.npcDrops] = {10184,228432,228435,228436,228438},
            [itemKeys.objectDrops] = {179703},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [227533] = {
            [itemKeys.name] = "Incandescent Gloves",
            [itemKeys.npcDrops] = {10184,227939,228429,228435,228436,228438},
            [itemKeys.objectDrops] = {179703},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [227534] = {
            [itemKeys.name] = "Incandescent Leggings",
            [itemKeys.npcDrops] = {10184,228430,228435,228436,228438},
            [itemKeys.objectDrops] = {179703},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [227535] = {
            [itemKeys.name] = "Incandescent Robe",
            [itemKeys.npcDrops] = {10184,228435,228436,228438},
            [itemKeys.objectDrops] = {179703},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [227536] = {
            [itemKeys.name] = "Incandescent Boots",
            [itemKeys.npcDrops] = {10184,227939,228431,228435,228436,228438},
            [itemKeys.objectDrops] = {179703},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [227537] = {
            [itemKeys.name] = "Incandescent Shoulderpads",
            [itemKeys.npcDrops] = {10184,227939,228435,228436,228438},
            [itemKeys.objectDrops] = {179703},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {227853},
            [itemKeys.startQuest] = nil,
        },
        [227549] = {
            [itemKeys.name] = "Scrap of Parchment",
            [itemKeys.npcDrops] = {7440},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227552] = {
            [itemKeys.name] = "Shredded Parchment",
            [itemKeys.npcDrops] = {7439,7440},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227658] = {
            [itemKeys.name] = "Shadowsworn Note",
            [itemKeys.npcDrops] = {6004,6005,6006,6007,6008,6009},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227683] = {
            [itemKeys.name] = "Sulfuras, Hand of Ragnaros",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227684] = {
            [itemKeys.name] = "Sulfuron Hammer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227685] = {
            [itemKeys.name] = "Modified Shadow Scalpel",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227686] = {
            [itemKeys.name] = "Ornate Warhammer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {461639},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227687] = {
            [itemKeys.name] = "Orthas' Favorite Gold Tooth",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {214954},
            [itemKeys.startQuest] = nil,
        },
        [227688] = {
            [itemKeys.name] = "Gorehowl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227689] = {
            [itemKeys.name] = "Partially-Digested Plate Armor",
            [itemKeys.npcDrops] = {8543,8545},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227690] = {
            [itemKeys.name] = "Necrotic Runestone",
            [itemKeys.npcDrops] = {10438},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227691] = {
            [itemKeys.name] = "Blade of Hanna",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227724] = {
            [itemKeys.name] = "Bloodstained Commendation",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227727] = {
            [itemKeys.name] = "Plans: Sulfuron Hammer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227728] = {
            [itemKeys.name] = "Eye of Sulfuras",
            [itemKeys.npcDrops] = {228438},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227730] = {
            [itemKeys.name] = "Thorium Brotherhood Contract",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 84338,
        },
        [227743] = {
            [itemKeys.name] = "Obsidian Power Core",
            [itemKeys.npcDrops] = {228724},
            [itemKeys.objectDrops] = nil,
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227745] = {
            [itemKeys.name] = "Family Heirloom",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {457387},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [227746] = {
            [itemKeys.name] = "Rune of the World Tree",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {464128},
            [itemKeys.itemDrops] = nil,
            [itemKeys.vendors] = {233335,233428},
            [itemKeys.startQuest] = nil,
        },
        [227747] = {
            [itemKeys.name] = "Family Records",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {457389},
            [itemKeys.itemDrops] = nil,
    