---@type ContentPhases
local ContentPhases = QuestieLoader:ImportModule("ContentPhases")

-- This function blacklists any quests in phases LATER than the currentPhase value
-- so in Phase 1, quests in phases 2+ are blacklisted, in phase 2, phases 3+ are blacklisted, etc
-- Phase 1 is omitted, because everything not in this list is supposed to be available in Phase 1
local questsToBlacklistByPhase = {
    [1] = { -- SoD Phase 1: level cap 25 (this is required for counting, but should stay empty)
    },
    [2] = { -- SoD Phase 2: level cap 40
        [1152] = true, -- Test of Lore; minLevel raised to 26 in P1 for some reason, might be retooled as part of P2?
        [1488] = true, -- The Corruptor; minLevel raised to 26 in P1
        [8370] = true, -- Conquering Arathi Basin
        [8374] = true, -- Conquering Arathi Basin
        [8171] = true, -- The Battle for Arathi Basin!
        [8168] = true, -- The Battle for Arathi Basin!
    },
    [3] = { -- SoD Phase 3: level cap 50
        [2847] = true, -- Wild Leather Armor
        [2854] = true, -- Wild Leather Armor
        [3526] = true, -- Goblin Engineering
        [3629] = true, -- Goblin Engineering
        [3630] = true, -- Gnome Engineering
        [3632] = true, -- Gnome Engineering
        [3633] = true, -- Goblin Engineering
        [3634] = true, -- Gnome Engineering
        [3635] = true, -- Gnome Engineering
        [3637] = true, -- Gnome Engineering
        [4181] = true, -- Goblin Engineering
        [5284] = true, -- The Way of the Weaponsmith
        [5302] = true, -- The Way of the Weaponsmith
        [6607] = true, -- Nat Pagle, Angler Extreme (Fishing 225+ quest)
        [6608] = true, -- You Too Good. (Fishing 225+ quest)
        [6609] = true, -- I Got Nothin' Left! (Fishing 225+ pre quest)
        [6610] = true, -- Clamlette Surprise (Cooking 225+ quest)
        [6611] = true, -- To Gadgetzan You Go! (Cooking 225+ pre quest)
        [6612] = true, -- I Know A Guy... (Cooking 225+ pre quest)
        [6622] = true, -- Horde Triage
        [6623] = true, -- Horde Trauma
        [6624] = true, -- Alliance Triage
        [6625] = true, -- Alliance Trauma
    },
    [4] = { -- SoD Phase 4 == Era Phase 1+2: level cap 60, MC, Ony, world bosses
    },
    [5] = { -- SoD Phase 5 == Era Phase 3: BWL + Zul'Gurub
        [4788] = true, -- The Final Tablets
        [5065] = true, -- The Lost Tablets of Mosh'aru
        [7761] = true, -- Blackhand's Command; BWL attune
        [7783] = true, -- The Lord of Blackrock Part 1
        [7784] = true, -- The Lord of Blackrock Part 2
        [7787] = true, -- Rise, Thunderfury!
        [8181] = true, -- Confront Yeh'kinya
        [8182] = true, -- The Hand of Rastakhan
        [8411] = true,
        [8056] = true,
        [8057] = true,
        [8064] = true,
        [8065] = true,
        [8074] = true,
        [8075] = true,
        [8110] = true,
        [8111] = true,
        [8112] = true,
        [8116] = true,
        [8117] = true,
        [8118] = true,
        [8041] = true,
        [8042] = true,
        [8043] = true,
        [8045] = true,
        [8046] = true,
        [8047] = true,
        [8049] = true,
        [8050] = true,
        [8051] = true,
        [8053] = true,
        [8054] = true,
        [8055] = true,
        [8058] = true,
        [8059] = true,
        [8060] = true,
        [8061] = true,
        [8062] = true,
        [8063] = true,
        [8066] = true,
        [8067] = true,
        [8068] = true,
        [8069] = true,
        [8070] = true,
        [8071] = true,
        [8072] = true,
        [8073] = true,
        [8076] = true,
        [8077] = true,
        [8078] = true,
        [8079] = true,
        [8101] = true,
        [8102] = true,
        [8103] = true,
        [8106] = true,
        [8107] = true,
        [8108] = true,
        [8141] = true,
        [8142] = true,
        [8143] = true,
        [8145] = true,
        [8146] = true,
        [8147] = true,
        [8195] = true,
        [8196] = true,
        [8201] = true,
        [8227] = true,
        [8238] = true,
        [8239] = true,
        [8240] = true,
        [8243] = true,
        [8246] = true,
        [8447] = true,
        [9208] = true,
        [9209] = true,
        [9210] = true,
        [8307] = true,
        [8313] = true,
        [8317] = true,
        [8282] = true,
        [8278] = true,
        [8323] = true,
        [8324] = true,
        [8275] = true, -- Taking Back Silithus
        [8276] = true, -- Taking Back Silithus
        [8309] = true,
        [8310] = true,
        [8315] = true,
        [8319] = true,
        [8341] = true,
        [8342] = true,
        [8343] = true,
        [8331] = true,
        [8332] = true,
        [8333] = true,
        [8306] = true,
        [8321] = true,
        [8362] = true,
        [8364] = true,
        [9248] = true,
        [8281] = true,
        [8285] = true,
        [8279] = true,
        [8287] = true,
        [8314] = true,
        [9415] = true,
        [9416] = true,
        [9419] = true,
        [9422] = true,
    },
    [6] = { -- SoD Phase 6 == Era Phase 5: AQ
        [8286] = true, -- Shifting Sands questline - What Tomorrow Brings
        [8288] = true, -- Shifting Sands questline - Only One May Rise
        [8301] = true, -- Shifting Sands questline - The Path of the Righteous
        [8302] = true, -- Shifting Sands questline - The Hand of the Righteous
        [8303] = true, -- Shifting Sands questline - Anachronos
        [8305] = true, -- Shifting Sands questline - Long Forgotten Memories
        [8519] = true, -- Shifting Sands questline - A Pawn on the Eternal Board
        [8555] = true, -- Shifting Sands questline - The Charge of the Dragonflights
        [8730] = true, -- Shifting Sands questline - Nefarius's Corruption
        [8733] = true, -- Shifting Sands questline - Eranikus, Tyrant of the Dream
        [8734] = true, -- Shifting Sands questline - Tyrande and Remulos
        [8735] = true, -- Shifting Sands questline - The Nightmare's Corruption
        [8736] = true, -- Shifting Sands questline - The Nightmare Manifests
        [8741] = true, -- Shifting Sands questline - The Champion Returns
        [8575] = true, -- Shifting Sands questline - Azuregos's Magical Ledger
        [8576] = true, -- Shifting Sands questline - Translating the Ledger
        [8577] = true, -- Shifting Sands questline - Stewvul, Ex-B.F.F.
        [8578] = true, -- Shifting Sands questline - Scrying Goggles? No Problem!
        [8584] = true, -- Shifting Sands questline - Never Ask Me About My Business
        [8585] = true, -- Shifting Sands questline - The Isle of Dread!
        [8586] = true, -- Shifting Sands questline - Dirge's Kickin' Chimaerok Chops
        [8587] = true, -- Shifting Sands questline - Return to Narain
        [8597] = true, -- Shifting Sands questline - Draconic for Dummies
        [8598] = true, -- Shifting Sands questline - rAnS0m
        [8599] = true, -- Shifting Sands questline - Love Song for Narain
        [8606] = true, -- Shifting Sands questline - Decoy!
        [8620] = true, -- Shifting Sands questline - The Only Prescription
        [8728] = true, -- Shifting Sands questline - The Good News and The Bad News
        [8729] = true, -- Shifting Sands questline - The Wrath of Neptulon
        [8742] = true, -- Shifting Sands questline - The Might of Kalimdor
        [8743] = true, -- Shifting Sands questline - Bang a Gong!
        [8745] = true, -- Shifting Sands questline - Treasure of the Timeless One

        [8579] = true, -- Mortal Champions
        [8789] = true, -- Imperial Qiraji Armaments
        [8790] = true, -- Imperial Qiraji Regalia
        [8791] = true, -- The Fall of Ossirian
        [8801] = true, -- C'Thun's Legacy
    },
    [7] = { -- SoD Phase 7 == Era Phase 6: Naxxramas
        [9142] = true,
        [9165] = true,
        [9141] = true,
        [9033] = true,
        [9034] = true,
        [9036] = true,
        [9037] = true,
        [9038] = true,
        [9039] = true,
        [9040] = true,
        [9041] = true,
        [9042] = true,
        [9043] = true,
        [9044] = true,
        [9045] = true,
        [9046] = true,
        [9047] = true,
        [9048] = true,
        [9049] = true,
        [9050] = true,
        [9054] = true,
        [9055] = true,
        [9056] = true,
        [9057] = true,
        [9058] = true,
        [9059] = true,
        [9060] = true,
        [9061] = true,
        [9068] = true,
        [9069] = true,
        [9070] = true,
        [9071] = true,
        [9072] = true,
        [9073] = true,
        [9074] = true,
        [9075] = true,
        [9077] = true,
        [9078] = true,
        [9079] = true,
        [9080] = true,
        [9081] = true,
        [9082] = true,
        [9083] = true,
        [9084] = true,
        [9086] = true,
        [9087] = true,
        [9088] = true,
        [9089] = true,
        [9090] = true,
        [9091] = true,
        [9092] = true,
        [9093] = true,
        [9095] = true,
        [9096] = true,
        [9097] = true,
        [9098] = true,
        [9099] = true,
        [9100] = true,
        [9101] = true,
        [9102] = true,
        [9103] = true,
        [9104] = true,
        [9105] = true,
        [9106] = true,
        [9107] = true,
        [9108] = true,
        [9109] = true,
        [9110] = true,
        [9111] = true,
        [9112] = true,
        [9113] = true,
        [9114] = true,
        [9115] = true,
        [9116] = true,
        [9117] = true,
        [9118] = true,
        [9121] = true,
        [9122] = true,
        [9123] = true,
        [9124] = true,
        [9125] = true,
        [9126] = true,
        [9127] = true,
        [9128] = true,
        [9129] = true,
        [9131] = true,
        [9132] = true,
        [9136] = true,
        [9137] = true,
        [9154] = true,
        [9260] = true,
        [9261] = true,
        [9262] = true,
        [9263] = true,
        [9264] = true,
        [9265] = true,
        [9211] = true,
        [9213] = true,
        [9229] = true,
        [9230] = true,
        [9233] = true,
        [9234] = true,
        [9235] = true,
        [9236] = true,
        [9237] = true,
        [9238] = true,
        [9239] = true,
        [9240] = true,
        [9241] = true,
        [9242] = true,
        [9243] = true,
        [9244] = true,
        [9245] = true,
        [9246] = true,
        [9250] = true,
        [9251] = true,
        -- Silithus/EPL PvP
        [9248] = true,
        [87360] = true, -- The Fall of Kel'Thuzad
        [87361] = true, -- Laid to Rest
        [87362] = true, -- Hope Begins in the Dark
        [87364] = true, -- Seal the Deal
        [88721] = true, -- Superior Armaments of Battle - Friend of the Dawn
        [88722] = true, -- Superior Armaments of Battle - Honored Amongst the Dawn
        [88723] = true, -- Superior Armaments of Battle - Revered Amongst the Dawn
        [88724] = true, -- Superior Armaments of Battle - Exalted Amongst the Dawn
        [88725] = true, -- Epic Armaments of Battle - Friend of the Dawn
        [88726] = true, -- Epic Armaments of Battle - Honored Amongst the Dawn
        [88727] = true, -- Epic Armaments of Battle - Revered Amongst the Dawn
        [88728] = true, -- Epic Armaments of Battle - Exalted Amongst the Dawn
        [88730] = true, -- The Only Song I Know...
        [88744] = true, -- Under the Shadow
        [88745] = true, -- Shadows of Doom
        [88748] = true, -- Cracked Necrotic Crystal
    },
    [8] = { -- Never appearing in Season of Discovery
        [1203] = true, -- Jarl Needs a Blade - Replaced by 81570
        [1878] = true, -- Water Pouch Bounty - Replaced by 82209
        [2758] = true, -- The Origins of Smithing - Replaced by 80241
        [2849] = true, -- Wild Leather Vest - Replaced by 82657
        [2856] = true, -- Wild Leather Vest - Replaced by 82656
        [2881] = true, -- Troll Necklace Bounty - Replaced by 82210
        [2950] = true, -- Nogg's Ring Redo - Replaced by 80141
        [3446] = true, -- Into the Depths - Replaced by 82096
        [4146] = true, -- Zapper Fuel - Replcaed by 82101
        [4148] = true, -- Bloodpetal Zapper
        [5283] = true, -- The Art of the Armorsmith -- Replaced by 85713
        [5301] = true, -- The Art of the Armorsmith -- Replaced by 85712
        [5124] = true, -- Fiery Plate Gauntlets -- Replaced by 84495
        [5141] = true, -- Dragonscale Leatherworking -- Replaced by 85702
        [5143] = true, -- Tribal Leatherworking -- Replaced by 85705
        [5144] = true, -- Elemental Leatherworking -- Replaced by 85703
        [5145] = true, -- Dragonscale Leatherworking -- Replaced by 85701
        [5146] = true, -- Elemental Leatherworking -- Replaced by 85704
        [5148] = true, -- Tribal Leatherworking -- Replaced by 85706
        [5284] = true, -- The Way of the Weaponsmith - Replaced by 82662
        [5302] = true, -- The Way of the Weaponsmith - Replaced by 82665
        [5305] = true, -- Sweet Serenity - Replaced by 85700
        [5306] = true, -- Snakestone of the Shadow Huntress - Replaced by 85700
        [5307] = true, -- Corruption - Replaced by 85700
        [7604] = true, -- A Binding Contract - Replaced by 84338
        [7636] = true, -- Stave of the Ancients - Replaced by 84546
        [7486] = true, -- A Hero's Reward - Replaced by 84545
        [7782] = true, -- The Lord of Blackrock - Replaced by 85643
        [7784] = true, -- The Lord of Blackrock - Replaced by 85644
        [8467] = true, -- Feathers for Nafien - Replaced by 84777
        [8769] = true, -- A Ticking Present - Replaced by 79637
        [8781] = true, -- Arms for the Field - Replaced by 85798
        [7622] = true, -- The Balance of Light and Shadow - Replaced by 84590
        [7785] = true, -- Examine the Vessel - Replaced by 85442
        [7786] = true, -- Thunderaan the Windseeker - Replaced by 85441
        [7787] = true, -- Rise, Thunderfury! - Replaced by 85443
        [8446] = true, -- Shrouded in Nightmare (Emerald Dream Dragons) - Replaced by 86679
        [8447] = true, -- Waking Legends (Emerald Dream Dragons) - Replaced by 86680
        [8620] = true, -- The Only Prescription - Replaced by 86444
        [9023] = true, -- The Perfect Poison - Replaced by 86674
        [8729] = true, -- The Wrath of Neptulon - Replaced by 86445
        [8730] = true, -- Nefarius's Corruption - Replaced by 86442
        [8736] = true, -- The Nightmare Manifests - Replaced by 86443
        [8745] = true, -- Treasure of the Timeless One - Replaced by 86449
        [8791] = true, -- The Fall of Ossirian - Replaced by 86673
        [8802] = true, -- The Savior of Kalimdor - Replaced by 86670
        [85643] = true, -- The Lord of Blackrock - Replaced by 88969
        [85644] = true, -- The Lord of Blackrock - Replaced by 88968

        -- Original Blackfathom Deeps quests (instance reworked to raid, new quest IDs)
        [909] = true,
        [971] = true,
        [1198] = true,
        [1199] = true,
        [1200] = true,
        [1275] = true,
        [6561] = true,
        [6565] = true,
        [6921] = true,
        [6922] = true,

        -- Original Gnomeregan quests (instance reworked to raid, new quest IDs)
        [2841] = true,
        [2842] = true,
        [2843] = true,
        [2904] = true,
        [2922] = true,
        [2923] = true,
        [2924] = true,
        [2925] = true,
        [2926] = true,
        [2927] = true,
        [2928] = true,
        [2929] = true,
        [2930] = true,
        [2931] = true,
        [2945] = true,
        [2947] = true,
        [2949] = true,
        [2951] = true,
        [2952] = true,
        [2953] = true,
        [2962] = true,
        [4601] = true,
        [4602] = true,
        [4603] = true,
        [4604] = true,
        [4605] = true,
        [4606] = true,
        [81975] = true, -- Never was made available as it seems

        -- Original Sunken Temple quests (instance reworked to raid, new quest IDs)
        [1445] = true,
        [1446] = true,
        [1475] = true,
        [3373] = true,
        [3374] = true,
        [3447] = true,
        [3512] = true,
        [3528] = true,
        [4143] = true,
        [8232] = true,
        [8236] = true,
        [8253] = true,
        [8257] = true,
        [8413] = true,
        [8418] = true,
        [8422] = true,
        [8425] = true,
        [9053] = true,

        -- Original Dire Maul Book quests
        [7498] = true, -- Replaced by 84548
        [7499] = true, -- Replaced by 84550
        [7500] = true, -- Replaced by 84549
        [7501] = true, -- Replaced by 84551

        -- Original ZG quests
        [8044] = true, -- The Rage of Mugamba - Replaced by 85612
        [8048] = true, -- The Hero's Brand - Replaced by 85617
        [8052] = true, -- The All-Seeing Eye of Zuldazar - Replaced by 85616
        [8104] = true, -- The Jewel of Kajaro - Replaced by 85629
        [8109] = true, -- Kezan's Unstoppable Taint - Replaced by 85625
        [8113] = true, -- Pristine Enchanted South Seas Kelp - Replaced by 85608
        [8119] = true, -- The Unmarred Vision of Voodress - Replaced by 85604
        [8144] = true, -- Zandalarian Shadow Mastery Talisman - Replaced by 85633
        [8148] = true, -- Maelstrom's Wrath - Replaced by 85637
        [8183] = true, -- The Heart of Hakkar - Replaced by 85660
        [8184] = true, -- Presence of Might - Replaced by 85595
        [8185] = true, -- Syncretist's Sigil - Replaced by 85601
        [8186] = true, -- Death's Embrace - Replaced by 85596
        [8187] = true, -- Falcon's Call - Replaced by 85597
        [8188] = true, -- Vodouisant's Vigilant Embrace - Replaced by 85603
        [8189] = true, -- Presence of Sight - Replaced by 85600
        [8190] = true, -- Hoodoo Hex - Replaced by 85599
        [8191] = true, -- Prophetic Aura - Replaced by 85598
        [8192] = true, -- Animist's Caress - Replaced by 85602

        -- Old T0.5 exchange quests
        [8905] = true, -- An Earnest Proposition
        [8906] = true, -- An Earnest Proposition
        [8907] = true, -- An Earnest Proposition
        [8908] = true, -- An Earnest Proposition
        [8909] = true, -- An Earnest Proposition
        [8910] = true, -- An Earnest Proposition
        [8911] = true, -- An Earnest Proposition
        [8912] = true, -- An Earnest Proposition
        [8913] = true, -- An Earnest Proposition
        [8914] = true, -- An Earnest Proposition
        [8915] = true, -- An Earnest Proposition
        [8916] = true, -- An Earnest Proposition
        [8917] = true, -- An Earnest Proposition
        [8918] = true, -- An Earnest Proposition
        [8919] = true, -- An Earnest Proposition
        [8920] = true, -- An Earnest Proposition
        [8926] = true, -- Just Compensation
        [8927] = true, -- Just Compensation
        [8931] = true, -- Just Compensation
        [8932] = true, -- Just Compensation
        [8933] = true, -- Just Compensation
        [8934] = true, -- Just Compensation
        [8935] = true, -- Just Compensation
        [8936] = true, -- Just Compensation
        [8937] = true, -- Just Compensation
        [8938] = true, -- Just Compensation
        [8939] = true, -- Just Compensation
        [8940] = true, -- Just Compensation
        [8941] = true, -- Just Compensation
        [8942] = true, -- Just Compensation
        [8943] = true, -- Just Compensation
        [8944] = true, -- Just Compensation
        [8951] = true, -- Anthion's Parting Words
        [8952] = true, -- Anthion's Parting Words
        [8953] = true, -- Anthion's Parting Words
        [8954] = true, -- Anthion's Parting Words
        [8955] = true, -- Anthion's Parting Words
        [8956] = true, -- Anthion's Parting Words
        [8957] = true, -- Anthion's Parting Words
        [8958] = true, -- Anthion's Parting Words
        [8959] = true, -- Anthion's Parting Words
        [8999] = true, -- Saving the Best for Last
        [9000] = true, -- Saving the Best for Last
        [9001] = true, -- Saving the Best for Last
        [9002] = true, -- Saving the Best for Last
        [9003] = true, -- Saving the Best for Last
        [9004] = true, -- Saving the Best for Last
        [9005] = true, -- Saving the Best for Last
        [9006] = true, -- Saving the Best for Last
        [9007] = true, -- Saving the Best for Last
        [9008] = true, -- Saving the Best for Last
        [9009] = true, -- Saving the Best for Last
        [9010] = true, -- Saving the Best for Last
        [9011] = true, -- Saving the Best for Last
        [9012] = true, -- Saving the Best for Last
        [9013] = true, -- Saving the Best for Last
        [9014] = true, -- Saving the Best for Last
        [9016] = true, -- Anthion's Parting Words
        [9017] = true, -- Anthion's Parting Words
        [9018] = true, -- Anthion's Parting Words
        [9019] = true, -- Anthion's Parting Words
        [9020] = true, -- Anthion's Parting Words
        [9021] = true, -- Anthion's Parting Words
        [9022] = true, -- Anthion's Parting Words

        -- Darkmoon Faire quests
        [7902] = true, -- Vibrant Plumes
        [7903] = true, -- Evil Bat Eyes
        [8222] = true, -- Glowing Scorpid Blood
        [7901] = true, -- Soft Bushy Tails
        [7899] = true, -- Small Furry Paws
        [7900] = true, -- Torn Bear Pelts
        [7946] = true, -- Spawn of Jubjub
        [8223] = true, -- More Glowing Scorpid Blood
        [7943] = true, -- More Bat Eyes
        [7894] = true, -- Copper Modulator
        [7898] = true, -- Thorium Widget
        [7885] = true, -- Armor Kits
        [7942] = true, -- More Thorium Widgets
        [7883] = true, -- The World's Largest Gnome!
        [7892] = true, -- Big Black Mace
        [7939] = true, -- More Dense Grinding Stones
        [7893] = true, -- Rituals of Strength
        [7891] = true, -- Green Iron Bracers
        [7896] = true, -- Green Fireworks
        [7884] = true, -- Crocolisk Boy and the Bearded Murloc
        [7882] = true, -- Carnival Jerkins
        [7897] = true, -- Mechanical Repair Kits
        [7895] = true, -- Whirring Bronze Gizmo
        [7941] = true, -- More Armor Kits
        [7881] = true, -- Carnival Boots
        [7890] = true, -- Heavy Grinding Stone
        [7889] = true, -- Coarse Weightstone
        [7907] = true, -- Darkmoon Beast Deck
        [7927] = true, -- Darkmoon Warlords Deck
        [7928] = true, -- Darkmoon Elementals Deck
        [7929] = true, -- Darkmoon Portals Deck

        -- ZG quests
        [8053] = true, -- Paragons of Power: The Freethinker's Armguards
        [8054] = true, -- Paragons of Power: The Freethinker's Belt
        [8055] = true, -- Paragons of Power: The Freethinker's Breastplate
        [8056] = true, -- Paragons of Power: The Augur's Bracers
        [8057] = true, -- Paragons of Power: The Haruspex's Bracers
        [8058] = true, -- Paragons of Power: The Vindicator's Armguards
        [8059] = true, -- Paragons of Power: The Demoniac's Wraps
        [8060] = true, -- Paragons of Power: The Illusionist's Wraps
        [8061] = true, -- Paragons of Power: The Confessor's Wraps
        [8062] = true, -- Paragons of Power: The Predator's Bracers
        [8063] = true, -- Paragons of Power: The Madcap's Bracers
        [8064] = true, -- Paragons of Power: The Haruspex's Belt
        [8065] = true, -- Paragons of Power: The Haruspex's Tunic
        [8066] = true, -- Paragons of Power: The Predator's Belt
        [8067] = true, -- Paragons of Power: The Predator's Mantle
        [8068] = true, -- Paragons of Power: The Illusionist's Mantle
        [8069] = true, -- Paragons of Power: The Illusionist's Robes
        [8070] = true, -- Paragons of Power: The Confessor's Bindings
        [8071] = true, -- Paragons of Power: The Confessor's Mantle
        [8072] = true, -- Paragons of Power: The Madcap's Mantle
        [8073] = true, -- Paragons of Power: The Madcap's Tunic
        [8074] = true, -- Paragons of Power: The Augur's Belt
        [8075] = true, -- Paragons of Power: The Augur's Hauberk
        [8076] = true, -- Paragons of Power: The Demoniac's Mantle
        [8077] = true, -- Paragons of Power: The Demoniac's Robes
        [8078] = true, -- Paragons of Power: The Vindicator's Belt
        [8079] = true, -- Paragons of Power: The Vindicator's Breastplate

        -- AQ War Efforts
        [8548] = true, -- Volunteer's Battlegear - Replaced by 86675
        [8572] = true, -- Veteran's Battlegear - Replaced by 86676
        [8573] = true, -- Champion's Battlegear - Replaced by 86677
        [8574] = true, -- Stalwart's Battlegear - Replaced by 86678
        [8792] = true, -- The Horde Needs Your Help!
        [8793] = true, -- The Horde Needs Your Help!
        [8794] = true, -- The Horde Needs Your Help!
        [8795] = true, -- The Alliance Needs Your Help!
        [8796] = true, -- The Alliance Needs Your Help!
        [8797] = true, -- The Alliance Needs Your Help!

        -- AQ Raid quests
        [8789] = true, -- Imperial Qiraji Armaments - Replaced by 86672
        [8790] = true, -- Imperial Qiraji Regalia - Replaced by 86671

        [78265] = true, -- Fish Oil (replaced by 82850)
        [78266] = true, -- Dark Iron Ordinance (replaced by 82851)
        [78267] = true, -- Shredder Turbochargers (replaced by 82853)

        [81716] = true, -- Recover Incursion Field Report: Duskwood
        [81727] = true, -- Recover Incursion Field Report: Ashenvale
        [81728] = true, -- Recover Incursion Field Report: Hinterlands
        [81729] = true, -- Recover Incursion Field Report: Feralas

        -- AQ Brood of Nozdormu Rings (replaced with vendor)
        [8747] = true, -- The Path of the Protector
        [8748] = true, -- The Path of the Protector
        [8749] = true, -- The Path of the Protector
        [8750] = true, -- The Path of the Protector
        [8751] = true, -- The Protector of Kalimdor
        [8752] = true, -- The Path of the Conqueror
        [8753] = true, -- The Path of the Conqueror
        [8754] = true, -- The Path of the Conqueror
        [8755] = true, -- The Path of the Conqueror
        [8756] = true, -- The Qiraji Conqueror
        [8757] = true, -- The Path of the Invoker
        [8758] = true, -- The Path of the Invoker
        [8759] = true, -- The Path of the Invoker
        [8760] = true, -- The Path of the Invoker
        [8761] = true, -- The Grand Invoker
        [8764] = true, -- The Changing of Paths - Protector No More
        [8765] = true, -- The Changing of Paths - Invoker No More
        [8766] = true, -- The Changing of Paths - Conqueror No More

        -- AQ Tier 2.5 Gear (replaced with vendor)
        [8556] = true, -- Signet of Unyielding Strength
        [8557] = true, -- Drape of Unyielding Strength
        [8558] = true, -- Sickle of Unyielding Strength
        [8689] = true, -- Shroud of Infinite Wisdom
        [8690] = true, -- Cloak of the Gathering Storm
        [8691] = true, -- Drape of Vaulted Secrets
        [8692] = true, -- Cloak of Unending Life
        [8693] = true, -- Cloak of Veiled Shadows
        [8694] = true, -- Shroud of Unspoken Names
        [8695] = true, -- Cape of Eternal Justice
        [8696] = true, -- Cloak of the Unseen Path
        [8697] = true, -- Ring of Infinite Wisdom
        [8698] = true, -- Ring of the Gathering Storm
        [8699] = true, -- Band of Vaulted Secrets
        [8700] = true, -- Band of Unending Life
        [8701] = true, -- Band of Veiled Shadows
        [8702] = true, -- Ring of Unspoken Names
        [8703] = true, -- Ring of Eternal Justice
        [8704] = true, -- Signet of the Unseen Path
        [8705] = true, -- Gavel of Infinite Wisdom
        [8706] = true, -- Hammer of the Gathering Storm
        [8707] = true, -- Blade of Vaulted Secrets
        [8708] = true, -- Mace of Unending Life
        [8709] = true, -- Dagger of Veiled Shadows
        [8710] = true, -- Kris of Unspoken Names
        [8711] = true, -- Blade of Eternal Justice
        [8712] = true, -- Scythe of the Unseen Path

        -- Original Naxxramas quests
        [9120] = true, -- The Fall of Kel'Thuzad - Replaced by 87360
        [9230] = true, -- Ramaladni's Icy Grasp - Replaced by 88729
        [9232] = true, -- The Only Song I Know... - Replaced by 88730

        -- Invasion quests
        [9094] = true, -- Argent Dawn Gloves
        [9085] = true, -- Shadows of Doom
        [9153] = true, -- Under the Shadow
        [9292] = true, -- Cracked Necrotic Crystal
        [9310] = true, -- Faint Necrotic Crystal
        [9318] = true, -- Blessed Wizard Oil
        [9317] = true, -- Consecrated Sharpening Stones
        [9333] = true, -- Argent Dawn Gloves
        [9334] = true, -- Blessed Wizard Oil
        [9335] = true, -- Consecrated Sharpening Stones

        [9221] = true, -- Superior Armaments of Battle - Friend of the Dawn
        [9222] = true, -- Epic Armaments of Battle - Friend of the Dawn
        [9223] = true, -- Superior Armaments of Battle - Honored Amongst the Dawn
        [9224] = true, -- Epic Armaments of Battle - Honored Amongst the Dawn
        [9225] = true, -- Epic Armaments of Battle - Revered Amongst the Dawn
        [9226] = true, -- Superior Armaments of Battle - Revered Amongst the Dawn
        [9227] = true, -- Superior Armaments of Battle - Exalted Amongst the Dawn
        [9228] = true, -- Epic Armaments of Battle - Exalted Amongst the Dawn

        [78506] = true, -- Elemental Distress - Replaced by 85772

        [88713] = true, -- Never at Rest - Same as 87377 but in a different catch-up version
        [88714] = true, -- Never at Rest - Same as 87377 but in a different catch-up version
        [88715] = true, -- Never at Rest - Same as 87377 but in a different catch-up version
        [88716] = true, -- Never at Rest - Same as 87377 but in a different catch-up version
        [88717] = true, -- Never at Rest - Same as 87377 but in a different catch-up version
        [88718] = true, -- Never at Rest - Same as 87377 but in a different catch-up version

        -- Tier 3 quests
        [9034] = true, -- Warrior
        [9036] = true, -- Warrior
        [9037] = true, -- Warrior
        [9038] = true, -- Warrior
        [9039] = true, -- Warrior
        [9040] = true, -- Warrior
        [9041] = true, -- Warrior
        [9042] = true, -- Warrior
        [9043] = true, -- Paladin
        [9044] = true, -- Paladin
        [9045] = true, -- Paladin
        [9046] = true, -- Paladin
        [9047] = true, -- Paladin
        [9048] = true, -- Paladin
        [9049] = true, -- Paladin
        [9050] = true, -- Paladin
        [9054] = true, -- Hunter
        [9055] = true, -- Hunter
        [9056] = true, -- Hunter
        [9057] = true, -- Hunter
        [9058] = true, -- Hunter
        [9059] = true, -- Hunter
        [9060] = true, -- Hunter
        [9061] = true, -- Hunter
        [9068] = true, -- Shaman
        [9069] = true, -- Shaman
        [9070] = true, -- Shaman
        [9071] = true, -- Shaman
        [9072] = true, -- Shaman
        [9073] = true, -- Shaman
        [9074] = true, -- Shaman
        [9075] = true, -- Shaman
        [9077] = true, -- Rogue
        [9078] = true, -- Rogue
        [9079] = true, -- Rogue
        [9080] = true, -- Rogue
        [9081] = true, -- Rogue
        [9082] = true, -- Rogue
        [9083] = true, -- Rogue
        [9084] = true, -- Rogue
        [9086] = true, -- Druid
        [9087] = true, -- Druid
        [9088] = true, -- Druid
        [9089] = true, -- Druid
        [9090] = true, -- Druid
        [9091] = true, -- Druid
        [9092] = true, -- Druid
        [9093] = true, -- Druid
        [9095] = true, -- Mage
        [9096] = true, -- Mage
        [9097] = true, -- Mage
        [9098] = true, -- Mage
        [9099] = true, -- Mage
        [9100] = true, -- Mage
        [9101] = true, -- Mage
        [9102] = true, -- Mage
        [9103] = true, -- Warlock
        [9104] = true, -- Warlock
        [9105] = true, -- Warlock
        [9106] = true, -- Warlock
        [9107] = true, -- Warlock
        [9108] = true, -- Warlock
        [9109] = true, -- Warlock
        [9110] = true, -- Warlock
        [9111] = true, -- Priest
        [9112] = true, -- Priest
        [9113] = true, -- Priest
        [9114] = true, -- Priest
        [9115] = true, -- Priest
        [9116] = true, -- Priest
        [9117] = true, -- Priest
        [9118] = true, -- Priest

        -- Atiesh
        [9257] = true,
        [9269] = true,
        [9270] = true,
        [9271] = true,
    },
}

---@return table<number, table<number, boolean>> @All quests that should be blacklisted separated by phase
function ContentPhases.BlacklistSoDQuestsByPhase(questsToBlacklist, contentPhase)
    for phase = contentPhase + 1, #questsToBlacklistByPhase do
        for questId in pairs(questsToBlacklistByPhase[phase]) do
            questsToBlacklist[questId] = true
        end
    end

    return questsToBlacklist
end
