-- AUTO GENERATED FILE! DO NOT EDIT!

---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB");

QuestieDB.npcKeys = {
    ['name'] = 1, -- string
    ['minLevelHealth'] = 2, -- int
    ['maxLevelHealth'] = 3, -- int
    ['minLevel'] = 4, -- int
    ['maxLevel'] = 5, -- int
    ['rank'] = 6, -- int, see https://github.com/cmangos/issues/wiki/creature_template#rank
    ['spawns'] = 7, -- table {[zoneID(int)] = {coordPair(floatVector2D),...},...}
    ['waypoints'] = 8, -- table {[zoneID(int)] = {coordPair(floatVector2D),...},...}
    ['zoneID'] = 9, -- guess as to where this NPC is most common
    ['questStarts'] = 10, -- table {questID(int),...}
    ['questEnds'] = 11, -- table {questID(int),...}
    ['factionID'] = 12, -- int, see https://github.com/cmangos/issues/wiki/FactionTemplate.dbc
    ['friendlyToFaction'] = 13, -- string, Contains "A" and/or "H" depending on NPC being friendly towards those factions. nil if hostile to both.
    ['subName'] = 14, -- string, The title or function of the NPC, e.g. "Weapon Vendor"
    ['npcFlags'] = 15, -- int, Bitmask containing various flags about the NPCs function (Vendor, Trainer, Flight Master, etc.).
                       -- For flag values see https://github.com/cmangos/mangos-classic/blob/172c005b0a69e342e908f4589b24a6f18246c95e/src/game/Entities/Unit.h#L536
}

QuestieDB.npcData = [[ return {
[1] = {'Waypoint (Only GM can see it)',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH","Visual",0},
[3] = {'Flesh Eater',651,651,24,25,0,{[10]={{16.97,28.77},{16.77,27.94},{16.57,29.75},{22.66,37.15},{17.66,42.94},{23.78,42.6},{24.41,40.8},{23.97,38.77},{17.79,47.83},{25.48,37.19},{16.61,43.46},{21.48,43.07},{22.69,47.74},{15,39.2},{18.55,35.25},{20.24,35.88},{16.67,36.93},{17.51,38.62},{14.16,36.15},{13.56,33.96},{17.22,36.97},{16.47,38.07},{13.53,36.06},{15.59,36.64},{13.97,36.84},{16.58,37.37},{16.89,37.51},{16.31,32.86},{16.07,31.64},{18.59,35.47},{15.31,33.25},{15.92,33.78},{13.7,32.48},{18.23,35.93},{13.13,36.55},{12.93,36.16},{17.74,37.13},{16.92,37.94},{15.1,36.7},{15.79,34.61},{16.48,35.19},{15.41,37.31},{14.68,33.6},{14.51,36.54},{13.07,35.37},{15.1,34.64},{17.78,35.92},{14.87,34.34},{16.75,34.8},{18.53,36.04},{15.86,34.81},{17.33,37.53},{13.6,36.75},{12.8,36.56},{13.91,33.79},{16.53,37.8},{14.28,41.46},{18.12,31.32},{19.12,33.35},{16.99,33.52},{19.1,37.39},{22.69,47.95},{14.94,39.3},{20.63,35.69},{16.78,37.18},{14.25,41.31},{17.7,31.57},{18.14,33.64},{16.96,33.45},{19.11,37.39},{16.71,32.41},{18.26,35.89},{13.61,32.95},{17.3,38.16},{15.63,36.65},{16.51,34.25},{13.96,32.69},{16.35,38.1},{17.41,34.72},{15.31,36.94},{13.95,33.8},{15.91,34.89},{16.48,37.66},{13.06,36.59},{14.65,33.09},{17.84,37.91},{14.56,36.09},{14.17,36.51},{18.3,35.57},{13.04,35.72},{13.45,36.32},{17.52,38.41},{14.28,32.76},{16.51,35.51},{16.35,37.24},{16.66,37.47},{16.46,32.89},{17.21,37.49},{16.85,34.39},{17.93,37.43},{16.56,36.87},{17.68,38.06},{14.65,33.85},{15.87,32.27},{13.5,33.97},{14,33.41},{17.66,37.62},{16.02,37.37},{16.55,35.16}}},nil,10,nil,nil,21,nil,nil,0},
[6] = {'Kobold Vermin',42,55,1,2,0,nil,nil,0,nil,nil,25,nil,nil,0},
[19] = {'Benny Questgiver',25,27,1,1,0,nil,nil,0,nil,{5053,5101,11578,11579,34617},35,"AH","NPC",0},
[25] = {'Mithril Mechanical Dragonling',2972,2972,45,45,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[29] = {'Kanrethad',25,27,90,90,0,{[4384]={{52.86,89.58}}},nil,4384,nil,{1,9065},35,"AH","Master of Death",0},
[30] = {'Forest Spider',120,120,5,6,0,{[12]={{38.48,62.45},{35.9,62.97},{36.36,56.22},{32.9,58.16},{38.16,62.76},{31.93,68.52},{38.01,70.1},{36.2,62.75},{36.15,69.28},{33.57,73.73},{31.98,56.99},{38.27,72.83},{32.21,68.4},{28.25,66.8},{33.94,72.94},{37.98,62.75},{38.12,69.59},{35.03,69.27},{33.51,73.65},{38.52,73.63},{38.04,72.44},{43.85,69.16},{43.62,59.43},{44.76,71.03},{43.7,72.22},{43.86,69.14},{40.01,69.38},{44.68,70.96},{43.78,72.28},{41.06,76.85},{41.59,77.86},{38.52,78.47},{44.78,70.92},{43.74,72.23},{40.52,77.9},{41.34,78.63},{38.88,78.71},{44.55,71.58},{38.4,69.58},{43.67,72.14},{35.63,69.46},{40.91,75.28}}},nil,12,nil,nil,22,nil,nil,0},
[31] = {'Furbolg',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[36] = {'Harvest Golem',190,247,11,12,0,nil,nil,0,nil,nil,14,nil,nil,0},
[38] = {'Two-Bit Thug',71,86,3,4,0,{[12]={{53.47,46.2},{52.01,51.01},{53.22,51.14},{56.08,40.56}}},nil,12,nil,nil,7,"AH",nil,0},
[40] = {'Kobold Miner',120,120,6,7,0,{[12]={{41.47,77.92},{41.04,78.12},{41.44,79.8},{41.64,80.08},{40.24,79.61},{62.62,53.97},{39.91,80.14},{41.08,80.94},{40.99,79.87},{40.94,80.5},{41.07,80.3},{41.26,80.36},{40.96,80.66},{40.45,80.26},{39.87,81.03},{40.74,81.48},{40.33,77.69},{39.94,78.62},{39.76,79.11},{64.9,59.44},{64.01,61.02},{63.95,58.44},{64.3,56.73},{61.21,49.69},{61.14,49.87},{60.24,49.62},{62.62,54.18},{61.55,50.06},{60.92,49.5},{61.88,55.53},{61.02,49.21},{60.58,50.84},{61.14,50.94},{61.51,51.95},{61.42,51.52},{62.77,53.71},{60.69,52.83},{63.83,55.42},{61.51,53.27},{61.5,51.94},{63.02,56.72},{63,59.49},{61.93,55.45},{61.12,56.4},{61.08,49.06},{61.93,58.59},{60.9,49.5},{61.51,50.15},{61.26,49.67},{61.06,59.87},{60.13,58.04},{58.2,59.51}}},nil,12,nil,nil,26,nil,nil,0},
[43] = {'Mine Spider',176,176,8,9,0,{[12]={{59.98,48.64},{60.26,47.56},{60.53,46.9},{61.75,47.57},{62.01,47.9},{60.21,47.6},{61.12,47.29},{60.52,46.88},{61.61,46.86},{61.89,47.09},{59.97,48.63}}},nil,12,nil,nil,22,nil,nil,0},
[46] = {'Murloc Forager',198,198,10,10,0,{[12]={{67.52,83.71},{56.49,85.8},{57.42,83.61},{64.97,82.61},{68.72,85.56},{65.66,84.38},{63.29,82.25},{61.19,82.58},{69.51,84.3},{70.63,85.29},{72.69,85.83},{74.8,85.13},{59.24,82.38},{75.56,86.58},{76.57,85.57},{76.79,85.94},{75.95,86.04},{76.27,86.46},{79.42,47.96},{79.46,48.2},{79.48,45.36},{79.34,45.25},{78.78,48.86},{78.9,48.85},{79.19,47.39},{78.65,45.43},{78.94,45.51},{80.05,46.27},{79.57,47.35},{78.9,48.87},{80.11,45.38},{79.2,45.74},{79.17,44.19},{79.35,46.25},{78.71,42.11},{77.9,44.36},{77.64,44.1},{78.71,44.51},{77.23,43.9},{78.66,43.07},{79.35,47.49},{79.16,56.36},{79.43,50.85},{76.55,59.63},{79.34,57.2},{78.3,58.01},{78.4,56.76},{79.13,56.92},{79.66,54.98},{79.04,54.43},{78.8,55.73},{78.65,55.4},{79.65,55.22},{78.68,45.9},{77.95,45.11},{79.39,47.59},{78.87,45.59},{79.81,46.33},{78.22,44.92},{80.47,44.7},{79.24,46.26},{79.46,43.86},{78.61,42.1},{77.54,44.29},{78.47,43.65},{79.48,50.77},{79.3,47.64},{79.69,46.28},{79.4,46.24},{77.56,85.95},{77.75,85.92},{78.17,58.05},{78.5,56.92},{77.76,57.74},{79.34,54.08},{78.93,55.01},{80.18,56.84},{80.19,53.82},{77.22,85.01},{72.82,85.2},{75.86,85.94},{75.96,84.92},{76.75,85.53},{76.72,82.77},{74.7,85.23},{75.91,86.08},{65.74,84.13},{67.43,83.41},{68.42,85.43},{64.73,82.46},{72.45,85.85},{70.52,85.25},{69.82,84.16},{52.33,86.78},{57.1,83.77},{56.2,85.66},{61.36,82.25},{61.7,80.47},{62.91,82.26},{59,82.36},{76.18,84.71},{76.61,85.53},{74.58,85.23},{65.71,84.32},{67.78,83.81},{68.17,85.55},{70.54,85.27},{69.78,84.19},{52.13,87.31},{57.2,83.91},{56.38,85.35},{61.35,81.72},{61.7,80.62},{63.03,82.33},{59.13,81.89},{65.97,84.17},{67.61,83.72},{68.3,85.25},{72.57,85.59},{70.65,85.42},{69.84,84.15},{76.19,84.85},{76.59,85.32},{74.82,85.04},{76.59,85.56},{77.78,86.13}}},nil,12,nil,nil,18,nil,nil,0},
[48] = {'Skeletal Warrior',562,562,21,22,0,{[10]={{76.99,69.72},{81.7,68.81},{80.37,74.35},{80.79,70},{80.53,68.92},{78.17,66.1},{80.76,66.81},{78.78,69.47},{79.03,67.71},{80.09,72.02},{79.74,72.96},{77.67,71.81},{78.23,70.19}}},nil,10,nil,nil,21,nil,nil,0},
[49] = {'Lesser Succubus',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[54] = {'Corina Steele',198,198,10,10,0,{[12]={{41.53,65.88},{41.32,65.7}}},nil,12,nil,nil,12,"A","Weaponsmith",4224},
[55] = {'Mean Ed the Blacksmith',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[60] = {'Ruklar the Trapper',148,148,8,8,0,{[12]={{64.5,56.72}}},nil,12,nil,nil,26,nil,nil,0},
[61] = {'Thuros Lightfingers',264,264,9,9,4,{[12]={{52.66,58.91},{28.84,59.4},{50.69,83.06},{89.32,79.45},{50.66,83.14}}},nil,12,nil,nil,17,nil,nil,0},
[62] = {'Gug Fatcandle',0,0,4,4,4,{[6170]={{31.59,16.71}}},nil,6170,nil,nil,26,nil,nil,0},
[65] = {'Peasant Woman',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[66] = {'Tharynn Bouden',198,198,10,10,0,{[12]={{41.89,67.09}}},nil,12,nil,nil,12,"A","Trade Supplies",128},
[68] = {'Stormwind City Guard',116235,116235,85,85,0,{[12]={{33.2,51.62},{32.79,49.55},{32.09,50.39},{41.64,67.44},{32.5,50.21}},[1519]={{67.96,72.27},{63.83,71.58},{73.81,93.46},{74.98,92.06},{72.77,88.58},{72.36,89.71},{71.43,88.27},{69.88,82.41},{72.25,87.25},{68.23,82.43},{70.4,86.31},{70.29,83.59},{69.29,81.2},{61.56,31.94},{68.01,74.08},{61.86,28.71},{71.24,85.33},{59.16,64.06},{48.63,62.71},{59.82,71.57},{66.06,77.65},{61.86,72.48},{65.61,59.33},{70.44,53.49},{58.83,64.43},{61.55,72.72},{64.16,29.66},{52.93,70.59},{65.78,59.1},{59.82,49.86},{66.57,77.06},{52.58,70.97},{67.98,72.23},{49.35,69.43},{62.4,58.55},{62.56,76.96},{66.34,34.44},{64.19,66.45},{62.53,58.81},{62.31,77.16},{60.32,67.45},{61.47,31.42},{59.7,41.02},{71.74,60.64},{63.93,29.19},{55.62,76.77},{48.81,63.13},{60.77,66.94},{66.74,35.19},{61.57,29.07},{57.96,60.24},{49.52,69.72},{70.25,46.94},{37.51,34.43},{44.91,72.67},{45.99,60.92},{45.21,72.37},{46.69,22.3},{57.84,72.91},{42.78,42.25},{36.41,43.44},{40.73,78.83},{46.2,22.18},{60.25,49.34},{41.04,77.85},{35.25,29.21},{46.03,76.19},{50.47,56.81},{46.38,60.49},{55.01,77.5},{56.6,57.71},{47.96,23.14},{44.2,70.96},{44.36,70.97},{44.5,71.42},{44.48,71.63},{44.47,56.15},{44.53,55.92},{44.38,55.84},{45.13,58.67}}},nil,1519,nil,nil,11,"A",nil,1},
[69] = {'Diseased Timber Wolf',55,55,2,2,0,nil,nil,0,nil,nil,32,"AH",nil,0},
[71] = {'Rankist',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[73] = {'Veraina the Apothecary',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Questgiver",0},
[74] = {'Kurran Steele',198,198,10,10,0,{[12]={{41.37,65.59}}},nil,12,nil,nil,12,"A","Cloth & Leather Armor Merchant",4224},
[78] = {'Janos Hammerknuckle',0,0,5,5,0,{[6170]={{30.11,52.43}}},nil,6170,nil,nil,12,"A","Weaponsmith",4224},
[79] = {'Narg the Taskmaster',180,180,6,6,4,{[12]={{40.93,77.53},{38.24,83.4}}},nil,12,nil,nil,26,nil,nil,0},
[80] = {'Kobold Laborer',71,86,3,4,0,nil,nil,0,nil,nil,25,nil,nil,0},
[82] = {'Crazy Leonetti',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[87] = {'Forest Troll Berserker',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[89] = {'Infernal',6116,6116,66,66,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[90] = {'Sea Giant',1524,1524,40,40,0,{[405]={{37.54,44.4},{29.44,40.81},{36.32,41.14},{34.97,39.15},{34.7,45.56},{34.57,45.5}}},nil,405,nil,nil,14,nil,nil,0},
[92] = {'Rock Elemental',1919,1919,45,46,0,{[3]={{48.14,71.35},{17.11,28.8},{35.3,46.97},{51.56,68.65},{40.54,72.74},{50.99,72.03},{18.14,28.76},{41.58,70.75},{49.23,68.15},{40.56,69.34},{39.62,69.76},{50.58,69.84},{31.89,57.76},{19.03,31.38},{49.52,71.13},{41.74,67.96},{33.79,50.09},{31.35,51.84},{30.43,58.71},{16.8,32.1},{31.84,49.9},{37.5,44.43},{34.65,53.97},{33.63,55.93},{17.68,35.69},{19.34,36.38},{16.59,30.7},{41.77,43.65},{31.56,54.98},{38.24,46.62},{35.35,50.35},{29.39,58.11},{39.66,45.59},{34.45,51.27},{29.49,58.09},{32.18,53.83},{37.05,48.27},{33.74,53.51},{30.14,56.5},{16.19,31.09},{16.98,28.68},{18.96,31.72},{16.5,29.54},{18.24,28.96},{17.67,35.38}}},nil,3,nil,nil,91,nil,nil,0},
[93] = {'Centaur',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[94] = {'Cutpurse',102,102,5,5,0,{[12]={{39.93,55.12},{42.68,52.05},{41.74,54.6},{41.7,52.67},{41.8,52.83},{41.51,52.84},{42.34,52.34},{39.12,54.03},{36.97,55.23},{41.06,53.88},{40.57,56.4},{36.22,58.74},{38.3,57.86},{31.33,57.98},{40.22,55.69},{35.23,66.72},{36.25,65.92},{31.13,66.82},{30.56,67.82},{40.77,56.4},{30.21,65.16},{29.41,66.59},{36.25,58.12},{31.98,65.81},{30.61,66.56},{36.99,67.08},{36.17,65.93},{38.01,58.01},{31.54,58.43},{35.25,66.71},{31.07,66.93},{30.15,68.25},{30.2,66.16},{29.03,66.91},{32.03,65.33},{30.62,66.59},{34.96,66.59},{36.26,65.89},{37.2,66.69},{36.21,66.89},{40.01,54.98},{42.93,51.11},{42.45,52.1},{41.87,54.64},{43.59,51.23},{42.98,53.51},{41.94,53.51},{39.08,54.14},{44.45,56.36},{44.15,54.85},{43.1,56.65},{36.89,55.07},{40.83,53.72},{40.59,56.54},{38.36,57.9},{37.02,66.79}}},nil,12,nil,nil,17,nil,nil,0},
[95] = {'Defias Smuggler',222,247,11,12,0,nil,nil,0,nil,nil,17,nil,nil,0},
[97] = {'Riverpaw Runt',176,176,8,9,0,{[12]={{31.53,80.03},{30.91,88.71},{31.28,81.97},{26.11,92.1},{26.07,91.71},{24.39,92.77},{25.14,89.24},{27.7,86.13},{26.32,86.84},{70.76,39.33},{67.56,46.44},{68.91,46.75},{68.1,45.13},{68.41,44.9},{70.49,39.66},{69.61,38.66},{68.56,39.52},{67.62,39.24},{68.48,38.22},{66.4,41.32},{66.67,40.95},{66.84,39.39},{70.87,39.55},{68.77,39.42},{67.72,46.16},{66.21,39.22},{68.8,37.79},{68.77,46.4},{31.2,88.23},{30.53,83.52},{31.02,80.28},{30.6,88.56},{30.97,82.74},{31.49,80.07},{25.31,89.11}}},nil,12,nil,nil,20,nil,nil,0},
[98] = {'Riverpaw Taskmaster',300,300,13,14,0,{[40]={{61.65,69.22},{63.22,68.82},{61.84,69.45},{64.81,73.09},{65.97,76.06},{60.67,70.69},{61.56,73.14},{64.62,76.51},{66.57,75.27},{63.07,68.43},{63.83,73.01},{60.43,77.22},{65.32,75.16},{60.81,74.47},{60.59,75.16},{59.29,74.08},{59.46,74.19},{65.74,72.16},{64.92,70.92},{62.72,75.27},{62.48,70.66},{63.11,76.19},{63.79,70.04},{63.42,78.39},{61.67,76.79},{60.92,77.52},{63.52,77.5},{62.47,77.49}}},nil,40,nil,nil,20,nil,nil,0},
[99] = {'Morgaine the Sly',264,264,9,9,4,{[12]={{30.69,64.74},{30.83,64.66}}},nil,12,nil,nil,17,nil,nil,0},
[100] = {'Gruff Swiftbite',264,264,9,9,4,{[12]={{25.39,89.75},{27.76,88.44}}},nil,12,nil,nil,20,nil,nil,0},
[102] = {'Bronze Dragonspawn',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[103] = {'Garrick Padfoot',102,102,5,5,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[105] = {'Tall Strider',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[106] = {'Kodo Beast',0,0,1,1,0,{[6452]={{31.04,48.5}}},nil,6452,nil,nil,35,"AH",nil,0},
[107] = {'Raptor',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[108] = {'Green Dragonspawn',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[109] = {'White Dragonspawn',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[111] = {'Priest',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[112] = {'Priestess',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[113] = {'Stonetusk Boar',120,120,5,6,0,{[12]={{41.82,69.47},{40.92,69.51},{31.6,79.61},{37.08,77.13},{38.92,68.27},{31.78,80.06},{31.02,81.47},{34.03,80.91},{32.39,81.25},{31.44,80.89},{30.62,84.08},{31,81.47},{31.09,82.02},{33.36,80.41},{33.89,79.66},{36.9,77.41},{37.91,75.46},{32.11,83.46},{31.73,85.5},{40.5,70.76},{38.93,68.45},{40.73,71.12},{39.04,68.17},{42.62,73.28},{40.84,73.68},{40.72,92.12},{37.87,90.99},{36.31,91.5},{37.3,90.03},{38.4,90.34},{40.96,89.66},{42.52,91.18},{39.68,89.98},{38.04,75.52},{41.91,85.15},{36.78,88.66},{39.67,88.46},{41.88,86.56},{40.92,88.26},{40.76,85.22},{41.72,87.38},{43.69,76.81},{42.83,86.98},{40,75.62},{41.1,87.11},{38.14,88.76},{38.44,85.92},{40.89,75.21},{43.9,69.35},{39.22,76.96},{32.77,89.6},{33.81,88.78},{35.24,89.94},{33.1,86.76},{38.19,90.76},{36.26,91.01},{36.97,89.86},{38.71,90.29},{33.19,86.31},{37.1,76.96},{37.98,75.73},{41.74,85.47},{36.46,89.22},{35.35,87.68},{39.7,87.66},{40.53,71.17},{41.19,85.48},{43.44,77.21},{42.68,73.24},{40.99,74.27},{41.94,72.14},{39.81,75.62},{38.26,72.79},{41.13,87.09},{38.96,74.1},{38.24,88.94},{39.11,86.74},{42.62,71.18},{41.88,76.14},{33.42,85.69},{43.96,69.4},{39.66,78.01},{41,86.96},{41.91,86.74},{32.45,82.78},{31.85,79.91},{33.3,89.9},{33.96,88.29},{35.72,89.78},{30.78,84},{30.49,81.01},{31.29,81.56},{37.4,91.02},{35.89,90.86},{36.99,89.67},{33.22,79.97},{34.16,80.32},{33.1,86.47},{36.83,77.37},{32.18,86.35},{38.21,75.53},{36.82,89.11},{34.98,87.5},{32.44,83.97},{31.16,85.31},{40.78,71.05},{40.7,74.01},{40.26,75.09},{38.18,72.88},{38.38,73.7},{42.05,75.26},{33.5,85.74},{32.18,85.86},{39.39,77.08},{32.32,81.32},{31.55,80.21},{33.17,90.02},{34,88.69},{40.71,92.4},{35.15,89.78},{30.27,82.73},{30.83,80.78},{31.68,81.67},{37.37,91.01},{36.29,91.45},{37.43,89.99},{38.66,91.48},{42.77,91.32},{32.75,80.8},{34.05,79.88},{39.87,89.81},{33.18,86.81},{37.09,76.92},{32.32,86.69},{37.91,75.51},{35.78,88.66},{35.3,87.94},{31.86,83.87},{31.09,85.74},{40.48,71.2},{39.15,67.88},{42.6,73.3},{40.45,74.31},{41.91,72.03},{39.94,75.42},{38.14,72.76},{38.36,73.15},{38.21,88.86},{42.72,70.83},{42.28,75.5},{31.92,85.88},{44.06,69.66},{39.24,77.52},{38.3,78.86},{41.86,72.15},{42.59,73.25},{43.63,72.24},{43.05,70.87},{43.94,69.3},{39.95,69.6}}},nil,12,nil,nil,189,"AH",nil,0},
[114] = {'Harvest Watcher',247,247,11,12,0,{[40]={{56.51,35.12},{56.26,35.69},{57.22,33.92},{52.45,32.5},{57.06,36.15},{54.98,36.75},{54.14,36.47},{55.38,33.5},{55.47,36.09},{53.47,30.93},{54.33,30.49},{54.29,33.69},{54.39,32.39},{53.08,35.5},{54.29,35.18},{52.11,34.47},{53.5,31.91},{51.55,29.55},{51.44,33.11},{53.33,33.66}}},nil,40,nil,nil,14,nil,nil,0},
[115] = {'Harvest Reaper',273,273,12,13,0,{[40]={{62.8,60.81},{61.91,62.06},{62.7,57.91}}},nil,40,nil,nil,14,nil,nil,0},
[116] = {'Bandit',176,176,8,9,0,{[12]={{29.15,58.64},{31.34,64.88},{31.23,65.08},{30.34,64.53},{30.59,65.04},{30.7,64.89},{29.16,58.17},{29.9,58.07},{30.58,58.77},{29.29,57.79},{30.88,57.59},{29.05,58.93},{30.92,65.16},{30.23,64.73},{29.14,58.3},{29.9,58.5},{30.64,58.88},{29.48,57.89},{31.08,57.6},{29.27,58.37},{55,59.15},{52.58,59.53},{52.27,58.91},{52.63,59.08},{52.07,59.7},{88.91,78.07},{89.31,80.22},{90,79.92},{89.57,79.59},{89.09,79.12},{88.74,79.92},{90.21,79.15},{89.88,78.12},{71.33,76.67},{70.89,79.71},{71.66,78.35},{70.53,76.82},{70.46,77.14},{71.08,77.21},{70.96,78.05},{45.62,73.36},{68.28,82.35},{71.34,76.61},{49.44,83.8},{46.72,85.91},{67.92,78.26},{68.33,77.7},{44.4,74.8},{46.8,83},{47.8,80.68},{48.83,82.38},{47.73,83.27},{45.65,76.87},{49.23,80.85},{50.54,83.11},{50.65,83.23},{68.12,80.58},{68.47,77.38},{68.39,76.93},{46.5,75.39},{46,73.21},{70.7,79.65},{70.6,79.05},{71.77,78.6},{70.72,81.59},{70.69,80.79},{70.48,76.76},{70.44,77.12},{71.06,77.19},{70.86,78.11},{47.57,73.75},{44.37,75.22},{45.54,76.65},{46.22,75.44},{45.51,73.7},{47.61,73.95},{68.43,81.99},{46.67,85.47},{44.06,74.5},{68.06,81.27},{45.69,73.41},{68.38,81.99},{88.87,78.2},{89.35,80.28},{89.93,79.97},{89.57,79.38},{89.18,79.15},{88.76,79.99},{90.25,79.1},{89.95,78.14}}},nil,12,nil,nil,17,nil,nil,0},
[117] = {'Riverpaw Gnoll',176,176,9,10,0,{[40]={{45.6,12.86},{41.92,20.53},{46.89,15.42},{42.5,19.46},{57.1,15.08},{57.74,13.97},{56.87,14.44},{56.28,15.45},{56.64,12.82},{57.33,12.39},{50.75,14.87},{40.76,20.02},{51.19,13.51},{41.22,21.83},{45.37,12.64},{56.4,12.31},{57.4,12.53},{51.55,13.37}}},nil,40,nil,nil,20,nil,nil,0},
[118] = {'Prowler',198,198,9,10,0,{[12]={{76.58,39.99},{70.79,39.35},{66.63,43.56},{74.81,39.13},{66.52,43.56},{75.29,40.58},{77.8,40.95},{71.88,40.72},{73.36,41.29},{72.73,40.27},{70.57,41.81},{69.87,40.93},{73.73,38.81},{72.26,64.82},{72.39,65.15},{71.83,65.31},{72.33,65.75},{75.59,76.63},{75.66,74.5},{80.55,58.63},{80.73,59.65},{78.22,63.67},{79.52,61.99},{77.1,61.71},{76.55,63.75},{80.13,60.39},{76.88,39.74},{70.76,39.32},{74.65,39.22},{75.24,40.43},{79.16,41.08},{75.2,37.59},{71.89,40.67},{73.72,40.9},{72.78,40.86},{70.53,42.29},{69.9,41.49},{71.55,37.44},{73.47,37.66},{73.84,38.71},{79.63,39.9},{70.65,39.46},{65.95,43.52},{66.5,44.32},{71.95,40.53},{72.82,39.56},{86.1,85.62},{70.6,41.96},{69.9,41.12},{71.25,37.01},{87.43,81.77},{87.58,81.47},{89.36,76.04},{81.17,77.96},{80.45,83.02},{80.18,77.63},{78.96,75.64},{87.19,79.94},{77.94,79.69},{79.44,79.28},{89.16,71.33},{80.56,80.23},{80.87,81.62},{90.24,80.69},{88.31,78.46},{90.03,81.32},{80.41,83.12},{90.5,78.02},{79.14,81.8},{82.04,82.05},{80.47,80.7},{80.34,81.11},{84.8,83.24},{85.27,83.69},{81.56,76.65},{87.26,77.19},{85.87,72.31},{86.04,66.31},{86.87,65.88},{89.96,75.2},{82.81,85.25},{83.8,84.36},{82.11,84.89},{77.53,74.42},{87.53,69.73},{86.95,69.25},{88.95,67.64},{87.27,62.76},{88.97,68.37},{85,63.82},{85.09,63.1},{83.3,60.78},{85.88,60.25},{84.67,61.07},{88.03,72.29},{86.85,70.92},{84.73,72.19},{76.26,63.5},{79.92,60.54},{81.06,61.5},{79.24,62.25},{81.05,60.11},{76.45,78.06},{75.47,76.44},{81.16,77.97},{80.6,79.15},{80.76,77.72},{79.16,76.77},{75.49,74.29},{77.91,79.37},{79.42,78.79},{79.39,81.25},{79.51,83.68},{79.32,82.04},{81.59,82.38},{80.43,80.81},{80.27,81.08},{81.44,76.29},{82.67,84.37},{83.43,83.65},{81.94,85.05},{76.33,75.88},{77.42,74.45},{77.13,75.65},{76.44,78.04},{75.31,76.57},{85.91,85.15},{87.34,82.26},{87.82,81.44},{90.86,80.01},{88.26,79.42},{90.12,81.46},{80.41,83.55},{90.65,76.92},{85.52,83.3},{89.93,75.31},{82.77,84.92},{81.93,84.94},{89.33,75.39},{88.88,71.02},{89.77,80.59},{85.75,85.24},{82.67,85.07}}},nil,12,nil,nil,38,nil,nil,0},
[119] = {'Longsnout',198,198,10,11,0,{[12]={{25.48,82.24},{25.7,79.76},{25.01,84.77},{24.65,86.95},{24.33,83.75},{25.76,79.21},{25.54,82.34},{24.88,87.19},{24.97,85.8}}},nil,12,nil,nil,189,"AH",nil,0},
[120] = {'Forest Stalker',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[121] = {'Defias Pathstalker',330,356,15,16,0,nil,nil,0,nil,nil,17,nil,nil,0},
[122] = {'Defias Highwayman',400,410,16,18,0,nil,nil,0,nil,nil,17,nil,nil,0},
[123] = {'Riverpaw Mongrel',273,273,12,13,0,{[40]={{33.99,29.2},{33.22,29.19},{34.73,28.35},{34.33,26.6},{32.43,30.23},{33.71,27.78},{36.63,32.13},{37.31,31.92},{38.17,31.11},{38.92,32.35},{38.13,28.41},{37.38,31},{37.01,29.3},{39.09,31.75},{35.21,26.45},{28.82,43.23},{38.72,29.61},{34.17,29.11},{33.24,29.19},{34.12,29.09},{34.26,25.64},{32.37,30.29},{33.74,27.95},{30.06,58.43},{31.26,57.58},{29.37,63.61},{29.87,66.6},{29.23,66.09},{28.61,65.51},{28.98,64.56},{29.39,65.47},{32.54,50.71},{28.38,48.85},{30.45,51.99},{28.94,57.7},{30.4,57.79},{32.09,53.73},{29.38,45},{29.31,53.33},{35.94,61.59},{28.92,68.04},{27.04,64.2},{29.64,50.52},{29.23,51.81},{31.53,50.91},{31.29,52.59},{27.61,61.37},{27.86,65.39},{35.22,26.53},{29.53,47.13},{30.59,46.56},{30.41,53.68},{28.8,50.64},{29.56,48.94},{30.33,49.59},{28.47,43.39},{35.51,61.52}}},nil,40,nil,nil,20,nil,nil,0},
[124] = {'Riverpaw Brute',273,273,13,13,0,{[40]={{51.27,39.19},{51.1,39.08},{50.77,40.08},{48.23,46.61},{47.58,47.61},{48.23,47.03},{48.86,45.27},{51.3,53.85},{51.21,52.58},{51.35,53.38},{53.77,48.14},{53.94,47.22},{53.81,49.27},{54.18,44.36},{54.71,49.97},{51.89,50.76},{54.51,43.71},{32.37,74.02},{31.36,72.4},{49.38,61.92},{48.35,60.85},{30.74,67.18},{52.12,63.31},{53.11,62.69},{52.89,62.8},{52.96,62.29},{54.11,62.24},{32.37,72.47},{30.31,74.8},{63.95,74.72},{33.38,68.89},{63.21,71.97},{51.17,52.6},{47.61,62.17},{47.76,60.24},{51.36,53.39},{31.71,67.5},{31.56,68.21},{31.56,70.91},{32.16,68.93},{32.55,68.59},{31.26,73.45},{31.41,75.12},{30.56,70.78}}},nil,40,nil,nil,20,nil,nil,0},
[125] = {'Riverpaw Overseer',449,484,19,20,0,nil,nil,0,nil,nil,20,nil,nil,0},
[126] = {'Murloc Coastrunner',198,198,11,11,0,{[40]={{40.58,10.57},{56.87,10.26},{53.39,11.53},{40.79,10.56},{43.96,8.29},{47.31,9.72},{45.74,7.97},{55.74,9.57},{56.88,10.37},{49.54,10.4}}},nil,40,nil,nil,18,nil,nil,0},
[127] = {'Murloc Tidehunter',253,253,13,14,0,{[40]={{25.67,57.47},{26.33,60.94},{26.77,58.05},{27.31,56.82},{27.57,57.84},{27.6,53.66},{27.98,74.87},{27.46,71.16},{27.83,70.43},{27.81,59.83},{27.31,69.72},{27.62,68.05},{26.94,75.79},{25.93,73.64},{27.01,74.35},{26.44,74.54},{28.02,69.33},{26.9,53.14},{28.85,69.9},{26.51,53.79},{34.2,84.26},{34.12,84.23},{34.4,82.31},{35.06,86.71},{34.9,83.95},{32.85,83.18},{34.17,84.43},{33.55,83.09},{35,84.54},{35.26,87.01},{34.65,83.49},{34.35,82.05}}},nil,40,nil,nil,18,nil,nil,0},
[128] = {'Angry Programmer Tweedle Dee',3900,3900,59,59,0,nil,nil,0,nil,nil,18,nil,"Testing",0},
[129] = {'Angry Programmer Tweedle Dum',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[130] = {'Programmer Vendor',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[138] = {'out Captain Lolo Longstriker',0,0,1,1,0,nil,nil,0,nil,nil,35,"AH","The Thorium Brotherhood",0},
[151] = {'Brog Hamfist',198,198,10,10,0,{[12]={{43.96,65.92}}},nil,12,nil,nil,12,"A","General Supplies",640},
[152] = {'Brother Danil',0,0,5,5,0,{[6170]={{30.99,51.21}}},nil,6170,nil,nil,12,"A","General Supplies",640},
[153] = {'Bethina',1,1,1,1,0,nil,nil,0,nil,{8022},35,"AH","Baby Murloc Redemption Merchant",0},
[154] = {'Greater Fleshripper',273,273,12,13,0,{[40]={{64.85,62.67},{61.05,60.67},{63.69,59.14},{63.83,62.36},{63.98,60.63},{61.9,49.05},{62.86,50.57},{60.28,52.73},{60.6,64.55},{59.12,61.23},{62.87,63.32},{59.98,54.93},{63.41,56.1},{58.83,58.25},{61.92,59.29},{58.58,63.76},{65.14,61.69},{34.81,64.78},{26.49,43.65},{39.19,67.51},{39.99,69.24},{62.84,63.69},{39.07,66.21},{37.57,69.48},{42.49,59.23},{40.81,61.62},{39.87,59.12},{27.04,42.97},{27.25,43.38},{34.92,73.32},{37.21,59.87},{65.02,62.34},{60.71,63.45},{32.56,62.25},{40.9,69.2},{33.85,61.19},{39.96,66.31},{37.21,66.45},{40.74,69.21}}},nil,40,nil,nil,73,nil,nil,0},
[157] = {'Goretusk',247,247,12,13,0,{[40]={{37.39,31.08},{34.5,30.83},{30.72,38.68},{35.47,37.58},{33.22,38.56},{48.65,42.8},{49.5,37.86},{46.55,43.04},{44.7,29.86},{47.88,40.38},{47.68,50.87},{44.31,50.56},{44.88,47.85},{49.57,43.52},{42.2,31.71},{44.43,52.37},{44.68,45.1},{46.49,44.94},{45.7,43.28},{45.78,53.22},{52.13,42.32},{52.08,44.01},{48.75,51.1},{55.89,39.03},{50.43,37.76},{54.48,42.01},{52.38,40.78},{52.16,39.15},{57.23,26.36},{57.23,31.27},{51.59,35.17},{38.23,26.95},{56.96,29.63},{51.21,33.86},{50.93,31.03},{51.32,31.08},{55.99,60.23},{52.72,29.1},{43.52,47.43},{55.91,63.37},{33.56,34.53},{35.4,33.73},{56.76,31.77},{57.19,32.58},{43.24,40.23},{54.91,28.45},{55.49,28.25},{54.88,27.58},{55.56,27.33},{56.56,28.02},{51.47,57.12},{53.24,34.43},{52.69,35.1},{51.53,33.96},{52.31,33.48},{49.54,56.62},{34.95,29.8},{31.13,38.85},{29.75,62.67},{31.39,55.57},{46.91,62.13},{53.47,64.89},{47.55,49.51},{43.95,50.68},{45.02,47.28},{42.45,55.08},{38.93,60.33},{41.03,58.11},{32.6,47.51},{30.8,59.7},{45.86,63.36},{51.4,62.18},{45.87,60.64},{49.21,61.74},{44.23,52.25},{38.47,63.69},{35.46,58.86},{34.27,54.94},{34.12,52.43},{35.01,49.28},{45.9,53.25},{48.94,51.8},{56.25,59.89},{43.62,47.9},{55.98,63.13},{36.42,62.5},{44.56,58.78},{51.35,57.56},{46.72,56.46},{44.85,60.61},{43.06,62.68},{44.76,57.84},{45.66,57.52},{47.66,57.72},{45.1,55.58},{54.26,59.27},{50.11,58.47},{40.95,64.05}}},nil,40,nil,nil,189,"AH",nil,0},
[167] = {'Morhan Coppertongue',273,273,13,13,0,{[38]={{34.02,46.54}}},nil,38,nil,nil,55,"A","Metalsmith",4224},
[171] = {'Murloc Warrior',273,273,12,13,0,{[40]={{35.6,22.31},{35.87,20.39},{28.56,34.5},{28,39.14},{29.19,35.36},{28.45,35.43},{29.64,32.41},{29.32,33.92},{29.7,27.04},{30.57,26.23},{26.61,38.02},{27.46,33.75},{35.92,20.24},{31.9,27.04},{26.4,40.48},{24.68,48.9},{25,48.67},{32.92,26.89},{28.42,34.59},{28.11,39.11},{29.16,35.49},{28.86,31.81},{28.41,28.5},{25.91,50.07},{27.78,35.07},{30.37,29.14},{29.62,32.57},{29.3,33.91},{34.3,22.31},{25.9,47.9}}},nil,40,nil,nil,18,nil,nil,0},
[190] = {'Dermot Johns',0,0,5,5,0,{[6170]={{31.26,50.61}}},nil,6170,nil,nil,12,"A","Cloth & Leather Armor Merchant",4224},
[192] = {'Ice Troll',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[193] = {'Blue Dragonspawn',6645,6876,50,51,1,nil,nil,0,nil,nil,60,nil,nil,0},
[196] = {'Eagan Peltskinner',0,0,3,3,0,{[6170]={{36.21,46.2}}},nil,6170,nil,nil,12,"A",nil,2},
[197] = {'Marshal McBride',0,0,20,20,0,{[6170]={{33.54,52.99}}},nil,6170,{54,3100,3101,3102,3103,3104,3105,26389,26390,26910,28757,28759,28762,28763,28764,28765,28766,28767,28769,28770,28771,28772,28773,28774,28780,28784,28785,28786,28787,28788,28789,29078,29079,29080,31139,31140,31141,31143},{26389,26390,28757,28759,28762,28763,28764,28765,28766,28767,28769,28770,28771,28772,28773,28774,28817,28818,28819,28820,28821,28822,28823,29078,29079,29083,31139,31140,31145},12,"A",nil,3},
[198] = {'Khelden Bremen',0,0,5,5,0,{[6170]={{38.79,43.47}}},nil,6170,{26916,28784},{3104,26916},12,"A","Mage Trainer",2},
[199] = {'Young Fleshripper',222,222,10,11,0,{[40]={{59.53,13.27},{62.89,35.04},{62.79,28},{60.25,24.62},{59.36,33.88},{62.47,34.7},{60.69,28.05},{38.26,19.22},{62.96,28.07},{60.95,30.81},{42.05,38.17},{42.88,18},{41.99,15.45},{47.55,17.87},{59.43,13.02},{45.83,29.88},{36.74,27.57},{43.08,25.43},{55.77,23.76},{41.02,34.99},{44.63,19.82},{55.4,19.22},{52.79,19.11},{51.25,24.76},{52.36,36.82},{53,28.83},{48.46,31.61},{48.85,27.56},{49.93,26.81},{45.74,26.66},{49.59,16.18},{48.88,25.18},{52.54,22.62},{52.72,28.79},{38.28,20},{42.13,15.49}}},nil,40,nil,nil,73,nil,nil,0},
[200] = {'Shambling Skeleton UNUSED',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[201] = {'Brittlebones Skeleton',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[202] = {'Rotting Horror',484,484,20,21,0,{[10]={{82.37,61.01},{82.22,59.9},{80.08,58.06},{81.64,61.81},{81.2,59.41},{81.29,57.81},{82.29,56.42},{80.13,60.29},{81.2,56.04},{81.03,60.65},{79.33,59.46},{81.93,58.66},{82.45,60.8},{82.04,60.15},{79.84,58.07},{81.69,60.95},{81.05,59.42},{81.24,57.76},{82.18,56.64},{79.93,60.27},{81.06,55.96},{80.86,60.81},{79.28,59.7},{81.91,58.5}}},nil,10,nil,nil,21,nil,nil,0},
[203] = {'Skeletal Mage',463,463,22,22,0,{[10]={{81.95,71.97},{79.2,73.9},{79.74,69.59},{78.74,71.59},{79.31,65.89},{78.12,68.17},{79.34,70.89},{78.68,73.15},{80.93,72.79},{76.96,68.31}}},nil,10,nil,nil,21,nil,nil,0},
[205] = {'Nightbane Dark Runner',521,521,21,22,0,{[10]={{63.19,31.2},{64.4,48.24},{60.41,38.47},{64.43,37.96}}},nil,10,nil,nil,24,nil,nil,0},
[206] = {'Nightbane Vile Fang',562,562,22,23,0,{[10]={{72.4,65.69},{74.33,74},{75.12,67.58},{72.43,67.37},{73.01,73.51},{73.06,75.59},{71.94,72.17},{72.34,73.56},{72.14,74.69},{73.27,71.82},{72.95,69.58},{74.28,70.05},{73.72,68.6},{73.52,73.17},{74.18,71.82}}},nil,10,nil,nil,2375,nil,nil,0},
[210] = {'Bone Chewer',699,699,24,25,0,{[10]={{16.96,27.53},{21.89,38.28},{25.37,38.81},{21.4,32.75},{22.43,33.67},{19.01,39.56},{19.45,41.66},{14.34,43.5},{25.21,35.52},{24.55,36.87},{20.35,46.17},{19.25,48.09},{17.06,31.69},{20.52,47.96},{20.49,33.6},{17.37,35.72},{15.67,41.55},{17.37,34.17},{15.57,33.99},{16.27,34.87},{16.07,32.73},{13.41,36.43},{14.05,35.76},{13.4,36.77},{16.03,33.9},{17.49,38.41},{14.56,37.2},{18.26,37.32},{16.3,32.41},{14.46,34.67},{16.38,37.16},{14.93,33.16},{13.64,33.01},{14.32,32.71},{16.09,36.95},{15.45,34.44},{16.06,37.29},{17.29,38.16},{13.53,33.42},{15.83,36.94},{14.13,36.5},{14.59,34.3},{17.89,35.7},{17.72,34.87},{17.14,37.84},{14.94,37.06},{14.27,34.07},{15.18,34.24},{13.31,36.06},{13.89,35.01},{15.75,34.97},{17.17,37.42},{16.31,37.55},{15.38,37.4},{15.72,34.27},{17.69,37.58},{14.06,34.6},{15.94,33.92},{13.09,33.77},{14.97,34},{21.24,32.85},{22.37,34.02},{14.27,43.41},{15.56,45.76},{14.47,46.81},{14.17,45.06},{17.52,31.47},{21.31,47.84},{18.13,33.67},{17.49,35.75},{17.85,47.85},{15.12,37.11},{15.03,34.12},{16.89,37.93},{16.94,37.09},{14.93,36.81},{13.4,36.94},{17.1,37.78},{16.34,32.12},{16.12,34},{16.95,38.25},{13.91,36.42},{17.78,35.56},{15.33,33.28},{14.35,33.37},{16.77,47.89},{16.58,32.42},{15.09,34.64},{16.85,34.81},{13.69,32.44},{17.52,35.88},{14.41,34.66},{15.94,34.34},{15.08,36.74},{16.55,32.16},{18.14,38.16},{17.45,37.27},{18.01,38.69},{14,34.5},{17.13,44.81},{15.86,33.97},{13.89,36.11},{14.65,34.24},{15.73,35.03},{18.55,35.85},{17.23,35.64},{17.8,38.23},{17.93,35.17},{17.51,42.48},{13.45,36.06},{16.33,37.52},{13.41,34.52},{16.9,37.52},{14.52,37.21},{16.68,38.29},{13.73,33.56},{16.78,46.59},{15.47,48.05}}},nil,10,nil,nil,21,nil,nil,0},
[211] = {'Ogre',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[212] = {'Splinter Fist Warrior',605,605,22,23,0,{[10]={{39.29,72.8},{39.48,74.59},{35.75,69.63},{34.95,70.66},{33.54,73.6},{37.32,84.42},{35.19,79.44},{33.25,68.64},{32.78,71.9},{40.18,70.52},{32.34,70.45},{37.2,72.99},{37.27,70.95},{38.57,70.55},{33.19,74.9},{34.06,75.71},{37.91,71.87}}},nil,10,nil,nil,45,nil,nil,0},
[213] = {'Starving Dire Wolf',449,484,19,20,0,nil,nil,0,nil,nil,38,nil,nil,0},
[215] = {'Defias Night Runner',664,713,24,25,0,nil,nil,0,nil,nil,17,nil,nil,0},
[217] = {'Venom Web Spider',484,484,19,19,0,{[10]={{66.98,52.77},{65.98,54.4},{83.71,18},{81.74,17.4},{78.46,22.04},{44.72,17.37},{65.83,15.82},{61.19,15.76},{66.24,49.84},{64.96,20.64},{67.23,38.96},{56.06,12.95},{68.97,19.06},{70.28,16.42},{56.82,16.05},{48.33,14.1},{64.39,30.17},{69.27,31.19},{69.43,21.73},{65.79,23.72},{51.68,10.78},{63.91,26.27},{62.81,25.58},{61.47,26.78},{60.16,23.55},{58.53,20.41},{54.62,16.42},{66.28,42.59},{66.91,46.94},{66.16,32.51},{67.06,29.65},{68.67,27.59},{70.79,25.57},{75.76,16.82},{75.06,19.57},{75.67,24.64},{72.44,23.87},{42.26,20.68},{38.04,22.56},{36.43,21.81},{39.64,20.84},{39.68,24.55},{75.74,16.65},{88.82,14.43},{75.79,16.7},{69.97,16.9},{51.72,11.18},{44.87,17.21},{47.88,14.37},{56.36,13.4},{51.84,10.59},{44.92,16.44},{48.07,13.75},{61.41,15.34},{56.16,13.29},{65.83,15.79},{75.04,16.22},{69.94,16.39},{61.24,15.57},{93.92,13.81},{94.01,13.68},{94.1,17.86},{84.12,18.25},{81.87,18.35},{79.23,22.64},{88.25,14.14},{70.03,16.24},{70.92,25.35},{75.58,16.71},{74.61,20.26},{75.38,24.82},{72.54,23.51}},[44]={{14.52,80.67},{10.43,82.73},{13.98,80.3},{10.84,82.32}}},nil,10,nil,nil,22,nil,nil,0},
[218] = {'Grave Robber',713,713,24,25,0,{[10]={{7.76,33.63},{7.71,34.07}}},nil,10,nil,nil,17,nil,nil,0},
[221] = {'Dannus',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Merchant",0},
[222] = {'Nillen Andemar',449,449,19,19,0,{[38]={{42.99,9.93}}},nil,38,nil,nil,55,"A","Macecrafter",4224},
[223] = {'Dan Golthas',617,617,23,23,0,{[1497]={{70.93,58.41}}},nil,1497,nil,nil,68,"H","Apprentice Leatherworker",1},
[224] = {'Zek Marston',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Weapon Peddler",0},
[225] = {'Gavin Gnarltree',1003,1003,30,30,0,{[10]={{73.6,50.04}}},{[10]={{{73.48,50},{73.64,49.6},{73.73,49.37},{73.81,49.09},{73.69,48.86},{73.61,48.9},{73.79,49.17},{73.71,49.41},{73.65,49.61},{73.6,50.04}}}},10,nil,nil,12,"A","Weaponsmith",4224},
[226] = {'Morg Gnarltree',1003,1003,30,30,0,{[10]={{73.97,48.89},{73.71,48.55}}},{[10]={{{73.98,48.87},{73.71,48.55},{73.68,48.55},{73.68,48.53},{73.97,48.89}}}},10,nil,nil,12,"A","Armorer",4224},
[227] = {'Mabel Solaj',787,787,26,26,0,{[10]={{73.97,45.27}}},nil,10,nil,nil,12,"A","General Goods",640},
[228] = {'Avette Fellwood',664,664,24,24,0,{[10]={{73.01,44.1}}},{[10]={{{73.27,44.76},{73.27,44.81},{73.03,44.47}}}},10,nil,nil,12,"A","Bowyer",4224},
[229] = {'Vaious',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[230] = {'Thornton Fellwood',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Woodcrafter",0},
[232] = {'Farmer Ray',617,617,23,23,0,nil,nil,0,nil,nil,88,"A",nil,0},
[233] = {'Farmer Saldean',484,484,20,20,0,{[40]={{56.04,31.23}}},nil,40,{26237,26257,26270},{9,26236,26237,26252,26257},12,"A",nil,643},
[234] = {'Marshal Gryan Stoutmantle',9304,9304,75,75,1,{[40]={{56.33,47.52}}},nil,40,{26286,26289,26292,26322,26761},{12,13,14,109,132,141,142,143,155,166,26286,26291,26320,26370},11,"A","The Westfall Brigade",3},
[235] = {'Salma Saldean',484,484,20,20,0,{[40]={{56.42,30.52}}},nil,40,{26241,26266},{22,36,38,26241,26270},12,"A",nil,2},
[237] = {'Farmer Furlbrow',484,484,20,20,0,{[40]={{60.05,19.38}}},nil,40,nil,{64},12,"A",nil,2},
[238] = {'Verna Furlbrow',484,484,20,20,0,{[40]={{60.03,19.44}}},nil,40,nil,{151},12,"A",nil,0},
[239] = {'Grimbooze Thunderbrew',484,484,20,20,0,{[40]={{44.62,80.25}}},nil,40,nil,{48,49,50,51,53,117,12764},55,"A",nil,0},
[240] = {'Marshal Dughan',713,713,25,25,0,{[12]={{42.11,65.93}}},nil,12,{35,62,76,239,26378},{39,40,54,62,76,176},12,"A",nil,3},
[241] = {'Remy "Two Times"',102,102,5,5,0,{[12]={{42.14,67.26}}},nil,12,{40,47},{47},12,"A",nil,2},
[242] = {'Horras Brackwell',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[244] = {'Ma Stonefield',71,71,3,3,0,{[12]={{34.66,84.48}}},nil,12,{88},{88},12,"A",nil,2},
[246] = {'"Auntie" Bernice Stonefield',120,120,6,6,0,{[12]={{34.49,84.25}}},nil,12,{84,85},{86,87},12,"A",nil,2},
[247] = {'Billy Maclure',42,42,1,1,0,{[12]={{43.13,85.72}}},nil,12,{86,87},{84,85},12,"A",nil,2},
[248] = {'Gramma Stonefield',71,71,3,3,0,{[12]={{34.94,83.86}}},nil,12,{107},{111},12,"A",nil,2},
[250] = {'Pa Maclure',120,120,6,6,0,{[12]={{42.72,89.24}}},nil,12,nil,nil,12,"A",nil,0},
[251] = {'Maybell Maclure',55,55,2,2,0,{[12]={{43.15,89.62}}},nil,12,{106},{114,26150},12,"A",nil,2},
[252] = {'Tommy Joe Stonefield',55,55,2,2,0,{[12]={{29.84,86}}},nil,12,{111},{106},12,"A",nil,2},
[253] = {'William Pestle',120,120,6,6,0,{[12]={{43.32,65.7}}},nil,12,{60,112,114,26150},{60,107,112},12,"A",nil,2},
[255] = {'Gerard Tiller',120,120,6,6,0,{[12]={{43.1,85.5}}},nil,12,{16},{16},12,"A",nil,2},
[257] = {'Kobold Worker',71,71,3,3,0,nil,nil,0,nil,nil,25,nil,nil,0},
[258] = {'Joshua Maclure',102,102,5,5,0,{[12]={{42.36,89.38}}},nil,12,nil,nil,12,"A","Vintner",640},
[261] = {'Guard Thomas',1003,1003,30,30,0,{[12]={{73.97,72.18}}},nil,12,{37,52,59,26378},{35,46,52,71},12,"A",nil,2},
[262] = {'Half-eaten body',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[263] = {'Lord Ello Ebonlocke',1003,1003,30,30,0,{[10]={{71.93,46.44}}},nil,10,{26727},{145,160,252,253,26681,26727},12,"A","Mayor of Darkshire",2},
[264] = {'Commander Althea Ebonlocke',5544,5544,45,45,0,{[10]={{73.52,46.92}}},nil,10,{26618,26627,26645,26686,26795,26796},{56,57,58,79,97,227,228,26618,26645,26686,26728,26794,26795,28564},53,"A","Leader of The Night Watch",2},
[265] = {'Madame Eva',713,713,25,25,0,{[10]={{75.81,45.3}}},nil,10,{26652,26655,26674},{98,101,148,154,262,26653,26654,26672,26673},12,"A",nil,2},
[266] = {'Wiley the Black',787,787,26,26,0,{[44]={{25.94,41.87}}},nil,44,nil,{65},12,"A",nil,0},
[267] = {'Clerk Daltry',1107,1107,31,31,0,{[10]={{72.45,46.91}}},nil,10,{26667,26669,26670,26671},{66,68,80,265,1041,26666,26667,26669,26670},12,"A",nil,2},
[268] = {'Sirra Von\'Indi',664,664,24,24,0,{[10]={{72.6,47.76}}},nil,10,{26794},{225,251,401,402,26793},12,"A","Historian of Darkshire",2},
[269] = {'Role Dreuger',1753,1753,40,40,0,{[10]={{72.05,46.32}}},nil,10,nil,nil,12,"A","Deputy Mayor of Darkshire",0},
[270] = {'Councilman Millstipe',896,896,28,28,0,{[10]={{72.06,46.8}}},nil,10,nil,{377},12,"A","Council of Darkshire",0},
[271] = {'Ambassador Berrybuck',1003,1003,30,30,0,{[10]={{71.95,47.01}}},nil,10,nil,nil,12,"A","Council of Darkshire",0},
[272] = {'Chef Grual',1003,1003,30,30,0,{[10]={{73.89,43.45}}},{[10]={{{73.83,43.19},{73.84,43.44},{73.89,43.45},{73.87,43.45},{73.9,43.95},{73.83,44.06},{73.85,44.05},{73.89,43.92},{73.8,43.48},{73.75,43.48}}}},10,{26620,26623},{5,90,93,26620,26623},12,"A",nil,2},
[273] = {'Tavernkeep Smitts',573,573,22,22,0,{[10]={{74.08,44.71}}},nil,10,{26661,26676},{78,156,158,266,26660,26661},12,"A",nil,2},
[274] = {'Barkeep Hann',787,787,26,26,0,{[10]={{73.81,43.99}}},nil,10,nil,nil,12,"A","Bartender",640},
[275] = {'Whit Wantmal',840,840,27,27,0,nil,nil,0,nil,nil,12,"A",nil,0},
[276] = {'Viktori Prism\'Antras',896,896,28,28,0,{[10]={{79.53,47.47}}},nil,10,{26683,26685},{174,177,181,26684,26685},12,"A",nil,2},
[277] = {'Roberto Pupellyverbos',1003,1003,30,30,0,{[1519]={{60,77.01}}},nil,1519,nil,nil,12,"A","Merlot Connoisseur",641},
[278] = {'Sara Timberlain',102,102,5,5,0,{[12]={{79.46,68.71}}},nil,12,{83},{59,83},12,"A",nil,2},
[279] = {'Morgan Pestle',1003,1003,30,30,0,{[1519]={{63.16,74.4}}},nil,1519,nil,{61,9024},12,"A",nil,0},
[280] = {'Placeholder - Jasperlode Mine',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Area Trigger",0},
[281] = {'Kobold Tank',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[282] = {'Kobold Spellcaster',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[283] = {'Kobold Healer',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[284] = {'Brown Horse',42,42,2,2,0,{[1519]={{76.67,67.65}},[5034]={{26.96,7.39}}},nil,1519,nil,nil,35,"AH",nil,0},
[285] = {'Murloc',137,137,6,7,0,{[12]={{56.89,67.33},{56.45,66.32},{56.53,65.49},{56.65,66.54},{55.94,67.67},{56.85,66.86},{56.4,66.77},{53.7,66.76},{56.08,67.34},{55.64,66.73},{55.43,66.8},{55.17,66.14},{55.3,66.16},{56.19,69.06},{53.83,65.53},{54.59,66.51},{53.97,66.36},{54.89,65.31},{54.65,66.52},{55,66.81},{55.1,66.61},{54.44,66.79},{54.58,66.87},{54.33,66.81},{55.64,63.26},{50.17,66.6},{50.7,67.13},{51.18,66.83},{50.54,66.24},{50.31,67.71},{50.3,67.33}}},nil,12,nil,nil,18,nil,nil,0},
[286] = {'Old Rotten Gill',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[287] = {'Placeholder - Darkhollow Mine',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[288] = {'Jitters',713,713,25,25,0,{[10]={{18.62,58.36}}},nil,10,{26721,26787},{163,240,453,26721,26787},12,"A",nil,2},
[289] = {'Abercrombie',1342,1342,35,35,0,{[10]={{87.43,35.21}}},nil,10,{26653,26660,26677,26680,26681},{133,134,157,159,165,26627,26655,26676,26677,26680},12,"A","The Hermit",2},
[290] = {'Placeholder - Fargodeep Mine',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Area Trigger",0},
[291] = {'Placeholder Chest of Drawers',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Placeholder!",0},
[294] = {'Marshal Haggard',484,484,20,20,0,{[12]={{84.61,69.38}}},nil,12,{26378},{74,75,1666,1667},12,"A",nil,2},
[295] = {'Innkeeper Farley',1003,1003,30,30,0,{[12]={{43.77,65.8}}},nil,12,nil,{69,2158,37112},12,"A","Innkeeper",66179},
[297] = {'Caretaker Folsom',1003,1003,30,30,0,{[1519]={{42.52,72.36}}},nil,1519,nil,{70},12,"A",nil,0},
[299] = {'Young Wolf',42,42,1,1,0,{[12]={{41.86,58.09},{42.24,55.56},{41.28,58.3},{42.77,61.01},{42.74,62.28},{42.73,60.66},{42.45,62.27},{41.48,58.33},{44.83,57.98},{42.77,55.35},{45.81,55.33},{42.94,60.92},{43.94,59.34},{42.71,62.75}}},nil,12,nil,nil,32,"AH",nil,0},
[300] = {'Zzarc\' Vul',1210,1210,23,23,0,{[10]={{37.87,84.35}}},nil,10,nil,nil,45,nil,nil,0},
[302] = {'Blind Mary',1753,1753,40,40,0,{[10]={{82.02,59.32},{81.92,58.99}}},{[10]={{{81.77,59.37},{81.99,59.09},{82.01,59.41}}}},10,{26654,26684},{149,175,26652,26683},12,"A",nil,2},
[303] = {'Placeholder Interactive Doodad - jk',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Use Your Imagination",0},
[304] = {'Felsteed',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[305] = {'White Stallion',55,55,1,1,0,{[5034]={{26.99,7.43}}},nil,5034,nil,nil,35,"AH",nil,0},
[306] = {'Palomino',42,42,1,1,0,{[4]={{45.98,85.15}}},nil,4,nil,nil,35,"AH",nil,0},
[307] = {'Pinto',55,55,2,2,0,{[4]={{45.99,85.06}}},nil,4,nil,nil,35,"AH",nil,0},
[308] = {'Black Stallion',42,42,2,2,0,{[1519]={{76.73,67.78}}},nil,1519,nil,nil,35,"AH",nil,0},
[309] = {'Rolf\'s corpse',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[311] = {'Sven Yorgen',484,484,20,20,0,nil,nil,0,nil,{55,164,230,268,323,325},12,"A",nil,2},
[313] = {'Theocritus',664,664,24,24,0,{[12]={{65.22,69.71}}},nil,12,nil,{178,249},12,"A","Mage of Tower Azora",0},
[314] = {'Eliza',737,737,30,30,0,nil,nil,0,nil,nil,14,nil,"Bride of the Embalmer",0},
[315] = {'Stalvan Mistmantle',1815,1815,23,23,0,{[10]={{77.23,36.39}}},nil,10,nil,nil,14,nil,nil,0},
[325] = {'Hogan Ference',484,484,20,20,0,{[10]={{72.28,48.16}}},nil,10,nil,nil,12,"A",nil,0},
[327] = {'Goldtooth',156,156,8,8,0,{[12]={{40.1,80.63}}},nil,12,nil,nil,26,nil,nil,0},
[328] = {'Zaldimar Wefhellt',273,273,13,13,0,{[12]={{43.25,66.19}}},nil,12,nil,nil,12,"A","Mage Trainer",49},
[329] = {'Earth Elemental',2745,2745,54,55,0,nil,nil,0,nil,nil,16,nil,nil,0},
[330] = {'Princess',176,176,9,9,0,{[12]={{32.43,86.59}}},{[12]={{{69.68,79.9},{69.77,79.47},{69.82,78.84},{69.7,78.48},{69.24,78.4},{68.96,78.87},{68.9,79.52},{69.06,79.88},{69.39,80.13}}}},12,nil,nil,7,"AH",nil,0},
[331] = {'Maginor Dumas',4120,4120,60,60,0,{[1519]={{49.25,87.77}}},nil,1519,{27354,28398},{27271,28263,28398},12,"A","Master Mage",51},
[332] = {'Master Mathias Shaw',4370,4370,62,62,0,{[1519]={{81.32,63.52}}},nil,1519,{2206,27072},{135,393,394,2205,2206,2359,6182,6183,27675,28807},12,"A","Leader of SI:7",3},
[334] = {'Gath\'Ilzogg',5210,5210,21,21,1,{[44]={{62.4,50.7}}},nil,44,nil,nil,40,nil,"Warlord of the Blackrock Clan",0},
[335] = {'Singe',1584,1584,24,24,1,nil,nil,0,nil,nil,40,nil,nil,0},
[338] = {'Mazen Mac\'Nadir',2138,2138,44,44,0,{[1519]={{51.8,74.23}}},nil,1519,nil,nil,12,"A","Academy of Arcane Arts and Sciences",0},
[340] = {'Kendor Kabonka',2769,2769,50,50,0,{[1519]={{76.6,52.86}}},nil,1519,nil,nil,12,"A","Master of Cooking Recipes",128},
[341] = {'Foreman Oslow',484,484,20,20,0,{[44]={{31.48,44.34}}},nil,44,nil,{89,125,345},12,"A",nil,0},
[342] = {'Martie Jainrose',484,484,20,20,0,{[44]={{22.04,42.7}}},nil,44,{26509},{34,130,26509},12,"A",nil,2},
[343] = {'Chef Breanna',449,449,19,19,0,{[44]={{22.73,40.59}}},nil,44,nil,{92},12,"A",nil,0},
[344] = {'Magistrate Solomon',1469,1469,36,36,0,{[44]={{28.91,41.11}}},nil,44,{26510,26512,26514,26544,26545},{121,144,146,169,180,4183,4186,26505,26510,26512,26514,26520,26544,26545,26726,26761},12,"A",nil,2},
[345] = {'Bellygrub',623,623,16,16,0,{[44]={{17.47,44.8}}},nil,44,nil,nil,14,nil,nil,0},
[346] = {'Barkeep Daniels',531,531,21,21,0,{[44]={{25.95,40.7}}},nil,44,nil,{116},12,"A",nil,0},
[347] = {'Grizzle Halfmane',3874500,3874500,85,85,1,{[1497]={{56.19,85.41}}},nil,1497,nil,nil,1214,"H","Alterac Valley Battlemaster",1048577},
[348] = {'Zem Leeward',713,713,25,25,0,{[44]={{25.75,46.49}}},nil,44,nil,nil,12,"A",nil,0},
[349] = {'Corporal Keeshan',1398,1398,25,25,1,nil,nil,0,nil,nil,12,"A",nil,0},
[351] = {'Peasant',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[352] = {'Dungar Longdrink',232470,232470,85,85,1,{[1519]={{70.94,72.47}}},nil,1519,{26396},{6261,26395},12,"A","Gryphon Master",8195},
[353] = {'Antonia Dart',5400,5400,55,55,0,nil,nil,0,nil,{8021},12,"A","Baby Murloc Redemption Merchant",8192},
[356] = {'Black Wolf',198,198,10,10,0,{[1637]={{60.82,35.67}}},nil,1637,nil,nil,35,"AH",nil,0},
[358] = {'Timber Wolf',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[359] = {'Winter Wolf',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[361] = {'Saytr',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[364] = {'Slime',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[365] = {'Scott\'s Flying Mount',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[370] = {'Boy',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[371] = {'Girl',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[372] = {'Karm Ironquill',356,356,16,16,0,{[38]={{37.13,47.16}}},nil,38,nil,nil,12,"A","Mining Supplies",128},
[373] = {'Murak Winterborn',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Shaman Trainer",32},
[374] = {'Cog Glitzspinner',1003,1003,30,30,0,{[10]={{77.33,48.71}}},nil,10,nil,nil,875,"A",nil,0},
[375] = {'Priestess Anetta',0,0,5,5,0,{[6170]={{39.31,43.78}}},nil,6170,{26919,28786},{3103,26919},12,"A","Priest Trainer",2},
[376] = {'High Priestess Laurena',4120,4120,60,60,0,{[1519]={{49.53,44.6}}},nil,1519,{27361,28328},{5634,5635,5636,5637,5638,5639,5640,5669,5670,5671,5676,5677,5678,5686,5687,5699,5700,27268,28285,28328},12,"A","Priest Trainer",51},
[377] = {'Priestess Josetta',273,273,13,13,0,{[12]={{43.28,65.72}}},nil,12,nil,{5623,5624},12,"A","Priest Trainer",51},
[379] = {'Darcy Parker',328,328,15,15,0,{[44]={{15.62,65.33}}},{[44]={{{26.89,44.39},{26.91,44.82},{26.9,45.37},{27.09,45.65},{26.91,45.43},{26.59,45.44},{26.53,45.44},{26.91,45.44},{26.9,45.1},{27.03,45},{27.12,45.03},{27.15,45.05},{26.93,44.79},{26.9,44.46},{26.73,44.27},{26.62,44.3}}}},44,{26506},{131,26506},12,"A",nil,2},
[381] = {'Dockmaster Baren',484,484,20,20,0,{[44]={{27,43.59}}},nil,44,nil,{127,150},12,"A",nil,0},
[382] = {'Marshal Marris',1342,1342,35,35,0,{[44]={{31.86,44.89}}},nil,44,{26513,26570},{19,20,115,219,26513,26570},12,"A",nil,2},
[383] = {'Jason Mathers',137,137,7,7,0,{[12]={{47.46,62.18}}},nil,12,nil,nil,12,"A","Fishmonger",0},
[384] = {'Katie Hunter',198,198,10,10,0,{[12]={{84.15,65.49}}},nil,12,nil,nil,12,"A","Horse Breeder",131},
[385] = {'Horse',102,102,5,5,0,{[12]={{83.48,63.78}},[44]={{78.11,63.15},{77.95,63.03}},[394]={{32.64,59.45},{32.56,59.42},{26.37,31.13},{26.28,31.1}},[3519]={{56.59,53.7},{56.73,53.76}},[4714]={{42.57,47.35},{29.33,62.17},{29.91,62.06}}},nil,394,nil,nil,35,"AH",nil,0},
[387] = {'Lord Sammuel',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Master Paladin",0},
[388] = {'Bromos Murphy',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Master Paladin",0},
[389] = {'Lord Lantinga',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Master Paladin",0},
[390] = {'Porcine Entourage',137,137,7,7,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[391] = {'Old Murk-Eye',394,394,15,15,0,{[40]={{32.76,83.68},{34.14,84.12},{33.39,83.59}}},{[40]={{{29.27,75.95},{29.41,76.95},{29.42,77.81},{29.61,79.15},{29.68,79.66},{29.81,80.14},{30.05,80.73},{30.46,81.31},{30.74,81.62},{31.36,82.09},{31.79,82.32},{32.47,82.56},{32.68,82.67},{33.21,83.03},{33.39,83.23},{34.08,84.15},{34.47,84.79},{34.67,85.2},{34.96,85.47},{35.18,85.5},{35.34,85.29},{35.38,85.13},{35.36,84.61},{35.06,84.15},{34.74,84},{34.51,83.95},{34.24,83.65},{33.74,83.23},{33.1,82.87},{32.54,82.71},{32.1,82.51},{31.65,82},{30.93,81.48},{30.46,80.97},{30.16,80.46},{29.87,79.72},{29.37,78.32},{29.28,77.31},{29.22,76.62},{29.04,75.09},{28.95,74.24},{28.88,73.56},{28.83,72.7},{28.37,71.96},{27.93,71.41},{27.66,70.86},{27.49,70.41},{27.38,69.92},{27.16,68.95},{27.08,68.1},{27.1,67.41},{27.04,66.92},{26.76,66.17},{26.49,65.88},{26.24,66.05},{26.49,67.15},{26.69,67.56},{27.02,68.02},{27.54,68.37},{27.98,68.51},{28.38,68.77},{28.55,69.2},{28.56,69.7},{28.55,70.38},{28.74,71.54},{28.84,72.22},{28.76,72.7},{28.75,73.89},{28.86,74.57},{28.97,75.24},{29.2,75.81}}}},40,nil,nil,18,nil,nil,0},
[392] = {'Captain Grayson',1003,1003,30,30,0,{[40]={{30.5,85.62}}},nil,40,{26347,26348,26349},{103,104,152,26347,26348,26349,26371},35,"AH",nil,2},
[393] = {'Tame Wolf',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[395] = {'Markus',42,42,1,1,0,{[12]={{34.26,57.87}}},nil,12,nil,nil,12,"A",nil,0},
[397] = {'Grand Magus Doane',866,866,20,20,0,{[44]={{71.26,45.4}}},nil,44,{26694},nil,39,nil,nil,0},
[399] = {'Boy - placeholder 05',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[400] = {'Boy - placeholder 06',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[401] = {'Boy - placeholder 07',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[402] = {'Boy - placeholder 08',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[403] = {'Boy - placeholder 09',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[404] = {'Girl - placeholder 01',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[405] = {'Girl - placeholder 02',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[406] = {'Girl - placeholder 03',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[407] = {'Girl - placeholder 04',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[408] = {'Girl - placeholder 05',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[409] = {'Girl - placeholder 06',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[410] = {'Girl - placeholder 07',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[411] = {'Girl - placeholder 08',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[412] = {'Stitches',12200,12200,35,35,1,nil,nil,0,nil,nil,14,nil,"Gift from the Embalmer",0},
[415] = {'Verner Osgood',713,713,25,25,0,{[44]={{29.74,43.5}}},nil,44,nil,{119,122,124,126,1618},12,"A",nil,2},
[416] = {'Imp',40,40,5,5,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[417] = {'Felhunter',11970,11970,80,80,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[418] = {'Lesser Voidwalker',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[421] = {'Murphestos',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[422] = {'Murloc Flesheater',328,328,15,16,0,{[44]={{43.18,61.61},{43.52,63.23},{41.66,46.95},{38.4,42.73},{38.64,45.1},{37.82,45.25},{36.76,50.2},{37.93,40.97},{38.76,41.62},{38.1,42.74},{38.76,42.81},{46.12,63.71}}},nil,44,nil,nil,18,nil,nil,0},
[423] = {'Redridge Mongrel',328,328,15,16,0,{[44]={{15.63,54.02},{18.52,58.02},{16.47,57.41},{16.68,59.13},{15.76,56.77},{15.77,58.62},{40.14,63.31},{39.04,63.06},{32.86,73.79},{30.8,61.18},{31.68,58.4},{32.22,58.87},{32.15,60.91},{15.58,54.28},{18.24,58.22},{29.68,74.5},{30.7,73.65},{31.15,74.23},{31.73,59.42},{30.25,64.25},{32.92,63.16},{30.79,64.49},{30.43,71.75},{30.59,71.64},{30.16,72.38},{28.96,71.85},{28.89,74.67},{25.01,57.28},{29.66,61.04}}},nil,44,nil,nil,19,nil,nil,0},
[424] = {'Redridge Poacher',356,356,16,17,0,{[44]={{40.14,63.94},{40.6,63.48},{37.74,64.89},{40.44,62.81}}},nil,44,nil,nil,19,nil,nil,0},
[426] = {'Redridge Brute',328,328,15,15,0,{[44]={{17.31,55},{17.68,57.11},{18.17,56.04},{16.28,56.31},{16.2,56.45},{34.7,58.12},{33.74,57.58},{30.17,60.49},{32.86,58.87},{33.36,59.35},{16.84,54.81},{18.11,55.73},{32.13,56.9},{19.07,59.19},{19.22,59.31},{25.65,58.44},{25.22,58.01},{30.58,63.62},{32.03,63.14},{27.67,72.1},{29.86,71.36},{28.43,74.91}}},nil,44,nil,nil,19,nil,nil,0},
[428] = {'Dire Condor',356,356,15,16,0,{[44]={{9.73,70.88},{13.31,68.69},{11.22,66.13},{13.26,62.48},{12.12,64.35},{16.92,63.62},{17.19,55.52},{16.3,59.57},{22.27,63.89},{24.47,61.8},{20.12,66.61},{16.25,71.53},{12.1,66.81},{20.93,57.51},{20.88,65.32},{17.3,63.86},{50.18,65.49},{52.09,66.39},{55.27,67.84},{57.18,69.75},{44.98,32.56},{46.35,33.11},{45.31,34.24},{54.29,67.71},{17.17,55.2},{24.6,60.72},{15.04,73.4},{23.78,56.83},{41.27,36.87},{46.72,67.85},{42.73,69.22},{41.09,31.13},{20.88,65.32},{20.37,66.1},{24.94,57.02},{20.95,68.14}}},nil,44,nil,nil,2200,"AH",nil,0},
[429] = {'Shadowhide Darkweaver',424,424,19,19,0,{[44]={{66.02,33.92},{70.62,41.67},{72.94,48.54},{70.39,44.53},{75.02,52.23},{74.62,52.59},{69.09,50.42},{70.45,44.11}}},nil,44,nil,nil,39,nil,nil,0},
[430] = {'Redridge Mystic',325,325,15,16,0,{[44]={{25.76,28.5},{25.39,35.67},{20.18,36.74},{22.41,33.09},{28,34.85},{26.69,32.87},{28.77,36.14},{36.13,30.39},{31.3,24.25},{36.53,30.86},{32.33,25},{27.73,23.86},{24.8,24.21},{23.74,25.96},{22.9,31.52},{21.28,32.57},{23.33,32.03},{28.43,35.53},{31.04,37.59}}},nil,44,nil,nil,19,nil,nil,0},
[431] = {'Shadowhide Slayer',471,471,18,19,0,{[44]={{66.36,33.32},{71.36,48.13},{74.25,51.88},{74.36,51.97},{73.54,53.64},{72.36,50.32},{73.05,51.28},{72.13,42.86},{70.96,43.97},{70.69,44.49},{70.95,45.36},{72.12,44.84},{66.51,34.09},{76.31,49.08}}},nil,44,nil,nil,39,nil,nil,0},
[432] = {'Shadowhide Brute',539,539,18,19,0,{[44]={{68.5,42.14},{71.01,33.99},{72.2,34.22},{70.22,36.18},{69.25,32.92},{70.22,34.82},{74.47,46.35},{69.69,37.15},{66.84,36.41},{68.22,42.4},{68.01,35.51}}},nil,44,nil,nil,39,nil,nil,0},
[433] = {'Shadowhide Gnoll',425,425,18,19,0,{[44]={{65.43,52.88},{64.87,53.37},{66.69,40.84},{66.31,45.1},{66.88,47.63},{67.6,41.35}}},nil,44,nil,nil,39,nil,nil,0},
[434] = {'Rabid Shadowhide Gnoll',394,394,17,18,0,{[44]={{65.04,49.89},{65,52.64},{63.87,49.39},{64,53.33},{65.71,50.11},{65.85,38.47},{64.16,40.46},{64.64,37.66},{64.65,47.05},{67.01,45.8},{68.31,48.39},{67.73,46.7},{67.68,43.64}}},nil,44,nil,nil,39,nil,nil,0},
[435] = {'Blackrock Champion',2420,2420,19,20,1,nil,nil,0,nil,nil,40,nil,nil,0},
[436] = {'Blackrock Shadowcaster',1215,1215,19,20,1,nil,nil,0,nil,nil,40,nil,nil,0},
[437] = {'Blackrock Renegade',394,394,16,17,0,{[44]={{55.36,36.89},{43.56,34.73},{48.88,34.11},{50.31,35.48},{44.04,32.71},{45.32,31.63},{41.62,36.52},{49.26,43},{46.73,35.89},{42.87,35.33},{44.7,38.02},{51.51,39.72}}},nil,44,nil,nil,40,nil,nil,0},
[440] = {'Blackrock Grunt',450,484,19,20,0,nil,nil,0,nil,nil,40,nil,nil,0},
[441] = {'Black Dragon Whelp',330,354,17,18,0,nil,nil,0,nil,nil,14,nil,nil,0},
[442] = {'Tarantula',300,300,14,15,0,{[44]={{11.11,75.92},{12.56,68.43},{10.83,66.84},{13.97,66.94},{10.79,67.76},{13.46,65.99},{15.24,81.66},{13.1,82.66},{11.08,67.24},{11.89,71.76},{15.06,73.1},{11.75,68.22},{14.45,74.37},{12.16,69.75},{14.31,71.41},{13.6,66.35},{18.42,65.58},{20.41,59.25},{14.76,81.38},{13.08,82.52},{14.96,73.98},{14.17,75.17},{26.65,67.62},{20.62,58.84},{14.2,71.05},{12.49,71.86},{19.26,65.62},{22.9,68.03},{18.58,63.95}}},nil,44,nil,nil,22,nil,nil,0},
[445] = {'Redridge Alpha',363,363,16,16,0,{[44]={{25.91,34.31},{20.77,36.29},{27.31,27.09},{39.54,30.53},{30.85,38.44},{37.8,30.73}}},nil,44,nil,nil,19,nil,nil,0},
[446] = {'Redridge Basher',328,328,15,16,0,{[44]={{18.47,20.3},{20.02,15.03},{21.66,34.62},{20.81,34.63},{21.86,33.83},{21.39,34.02},{28.38,37.23},{27.44,27.85},{29.73,28.34},{27.61,30.64},{27.62,36.92},{37.13,33.07},{32.84,24.89},{31.08,21.42},{31.44,26.38},{29.78,22.41},{20.09,21.84},{23.92,29.71},{23.24,25.98},{23.5,26.62},{22.16,16.4},{19.94,25.41},{21.17,28.35},{20.77,36.29},{32.6,36.91},{26.68,36.81},{24.61,35.06},{32.05,37.66},{35.5,28.91},{35.62,33.56}}},nil,44,nil,nil,19,nil,nil,0},
[448] = {'Hogger',666,666,11,11,1,{[12]={{24.88,94.98}}},nil,12,nil,nil,20,nil,nil,0},
[449] = {'Defias Knuckleduster',273,273,13,14,0,{[40]={{54.98,44.65},{58.54,42.5},{58.31,42.4},{57.94,40.81},{57.11,42.69},{57.42,42.39},{58.4,42.33},{58.27,42.36},{53.97,48.97},{54.79,49.87},{57.14,50.73}}},nil,40,nil,nil,17,nil,nil,0},
[450] = {'Defias Renegade Mage',354,379,18,19,0,nil,nil,0,nil,nil,17,nil,nil,0},
[452] = {'Riverpaw Bandit',273,273,12,13,0,{[40]={{59.87,69.06},{50.33,40.82},{50.64,39.32},{51.24,40.44},{46.81,46.41},{46.7,52.51},{61.05,67.6},{62.08,67.65},{54.52,44.12},{48.85,46.02},{51.44,46.66},{51.26,53.21},{50.93,52.2},{51.2,52.53},{57.43,69.52},{51.22,54.42},{53.98,46.97},{53.01,50.28},{53.36,49.35},{54.83,43.49},{59.04,70.53},{59.82,69.25},{49.27,60.78},{48.45,61.04},{53.49,63.26},{53.21,60.81},{55.99,68.94},{64.76,69.16},{61.11,67.73},{57.49,74.46},{59.13,72.68},{62.33,67.47},{61.68,71.86},{56.31,71.24},{56.37,70.16},{48.75,62.4},{56.5,70.11},{48.07,61.2},{50.11,60.39},{50.92,52.2},{51.19,52.47},{55.13,71.12},{57.28,69.08},{51.18,54.43},{58.72,74.07},{55.95,73.2},{56.5,75.27},{57.41,72.9},{56.4,74.5},{56.27,74.28},{59.23,75.24}}},nil,40,nil,nil,20,nil,nil,0},
[453] = {'Riverpaw Mystic',253,253,13,14,0,{[40]={{60.51,72.9},{60.44,70.82},{63.66,72.71},{65.7,73.6},{65.28,75.46},{60.68,74.27},{63.95,70.07},{62.8,73.86},{64.03,77.85},{57.89,71},{59.69,76.67},{60.91,77.81},{61.14,77.76},{62.2,78.99},{61.87,78.03},{63.38,77.5}}},nil,40,nil,nil,20,nil,nil,0},
[454] = {'Young Goretusk',198,198,10,11,0,{[40]={{59.62,16.38},{62.01,22.12},{63.07,24.94},{39.02,33.67},{39.87,31.3},{39.25,27.64},{42.91,28.05},{35.15,29.27},{38.27,33.49},{46.7,19.37},{48.87,16.53},{63.16,24.64},{62.87,43.6},{61.75,39.37},{62.87,46.33},{59.42,32.71},{47.21,31.34},{61.93,22.33},{55.31,19.28},{60.42,27.38},{61.68,33.47},{59.44,35.57},{60.37,36.76},{59.98,29.43},{58.15,12.03},{56.41,21.05},{53.07,17.71},{41.81,23.72},{58.11,15.14},{59.17,13.07},{56.27,17.57},{57.07,16.38},{55.24,16.27},{59.77,17.42},{56.93,22.53},{47.23,21.95},{47.53,23.69},{53.71,25.56},{54.48,21.17},{50.43,20.69},{49.37,23.35},{46.79,27.95},{51.37,24.92},{51.84,20.39},{53.6,24.36},{55.02,24.46},{35.43,27.76},{58.21,12.1}}},nil,40,nil,nil,189,"AH",nil,0},
[456] = {'Murloc Minor Oracle',186,186,10,11,0,{[40]={{33.48,16.99},{34.18,15.99},{32.86,17.42},{33.89,16.72},{34.56,15.77},{34.22,16.01},{33.72,17.41},{33.1,15.91},{42.73,8.66},{39.12,14.27},{33.86,16.89},{34.01,17.41},{34.48,15.6},{33.51,17.02},{33.71,16.45},{34.15,17.06},{34.66,18.49},{33.94,16.12},{34.25,16.67},{38.46,13.96},{33.94,15.46},{44.77,8.06},{45.18,7.94},{43.2,8.36},{33.93,18.68},{38.6,17.13},{37.79,15.5},{55.92,7.72},{55.65,8.23},{55.45,9},{55.85,8.9}}},nil,40,nil,nil,18,nil,nil,0},
[458] = {'Murloc Hunter',247,247,12,13,0,{[40]={{27.38,40.46},{27.49,37.99},{28.48,36.62},{29.76,26.1},{28.46,29.67},{28.75,27.17},{25.25,56.23},{24.8,47.13},{25.34,50.58},{24.72,48.42},{23.66,57.09},{25.4,48.27},{23.68,49.23},{25.21,55.03},{25.19,55.33},{26.61,39.11},{27.46,40.59},{25.42,48.84},{28.69,78.32},{27.67,38.01},{28.43,36.51},{25.8,49.06},{30.7,27.42},{27.08,36.16},{27.79,35.24},{29.21,28.94},{26.34,46.37},{25.75,47.47},{26.58,49.66},{26.78,47.84}}},nil,40,nil,nil,18,nil,nil,0},
[459] = {'Drusilla La Salle',0,0,5,5,0,{[6170]={{39.54,55.11}}},nil,6170,{26914,28788},{3105,26914},12,"A","Warlock Trainer",3},
[460] = {'Alamar Grimm',0,0,5,5,0,{[6457]={{37.68,37.96}}},nil,6457,{26201,26424},{26201,26202},875,"A","Warlock Trainer",3},
[461] = {'Demisette Cloyce',4120,4120,60,60,0,{[1519]={{39.24,84.97}}},nil,1519,{27355,28399},{27272,28259,28399},12,"A","Warlock Trainer",51},
[462] = {'Vultros',297,297,10,10,4,{[40]={{50.64,43.55},{51.08,23.81},{54.8,23.2},{40.62,60.52},{36.77,62.52},{46.12,57.69},{45.66,60.08},{44.15,46.17},{45.44,43.95},{46.81,44.19},{63.25,57.03},{63.93,58.17},{65.52,58.72},{62.05,75.5},{61.53,73.9},{62.59,74.19},{57.09,19.94}}},nil,40,nil,nil,73,nil,nil,0},
[464] = {'Watch Captain Parker',1910,1910,30,30,0,{[44]={{15.32,64.6}}},{[44]={{{15.27,71.46},{15.26,71.78},{15.45,72.52},{15.61,72.32},{16.52,70.67},{17.14,69.96},{17.36,69.55},{16.44,69.52},{15.14,70.07},{14.21,70.58}}}},44,{26503,26505},{129,26365,26503,26504,28563},11,"A",nil,2},
[465] = {'Barkeep Dobbins',198,198,10,10,0,{[12]={{44,65.69}}},nil,12,nil,nil,12,"A","Bartender",640},
[466] = {'General Marcus Jonathan',829940,829940,87,87,1,{[1519]={{69.17,82.72}}},nil,1519,nil,{120,137,26054,27207},12,"A","High Commander of Stormwind Defense",2},
[467] = {'The Defias Traitor',328,328,15,15,0,nil,nil,0,nil,nil,10,"A",nil,0},
[468] = {'Town Crier',1342,1342,35,35,0,{[10]={{74.82,46.6}}},{[10]={{{74.93,46.78},{74.94,45.58},{75.42,45.4},{74.94,45.5},{74.6,46.58},{73.85,46.37},{73.81,45.58},{73.84,46.14},{73.71,46.66},{73.33,46.72},{73.14,46.76},{72.56,46.87},{73.14,46.76},{73.33,46.72},{73.59,46.72},{74.12,47.84},{74.97,47.32},{75.13,47.57},{75.2,48.1},{75.14,47.02}}}},10,nil,nil,12,"A",nil,0},
[469] = {'Lieutenant Doren',61040,61040,60,60,1,{[33]={{47.57,10.25}}},nil,33,{26735,26736,26737},{202,215,329,331,574,26735,26736,26737,26838,28699},12,"A",nil,2},
[471] = {'Mother Fang',264,264,9,9,4,{[12]={{62.13,48.06},{62.14,48.05}}},nil,12,nil,nil,22,nil,nil,0},
[472] = {'Fedfennel',264,264,9,9,4,{[12]={{67.95,39.51},{69.39,38.61}}},nil,12,nil,nil,20,nil,nil,0},
[473] = {'Morgan the Collector',198,198,10,10,0,{[12]={{71.01,80.77}}},nil,12,nil,nil,17,nil,nil,0},
[474] = {'Rogue Wizard',178,178,10,10,0,{[12]={{28.89,62.18},{29.01,62.62},{29.12,60.89},{29.71,61.06},{28.33,59.68},{28.87,62.17},{29.01,62.62},{29.12,60.9},{28.89,62.16},{29.01,62.61},{29.1,60.88},{28.33,59.7},{29.72,61.03},{52.51,59.06},{71.76,52.26},{71.64,49.8},{72.67,46.26},{72.14,55.16},{76.62,48.35},{76.13,47.57},{72.49,56.54},{77.29,51.63},{76.72,53.29},{76.18,54.82},{71.52,52.01},{71.73,49.74},{72.48,47.13},{72.25,54.83},{73.19,54.09},{76.67,48.28},{76.53,49.67},{76.07,47.58},{73.95,55.6},{72.6,56.78},{74.03,51.84},{74.91,51.96},{74.54,53.92},{77.21,51.62},{76.63,53.34},{76.04,54.04},{75.23,52.54},{50.6,82.99}}},nil,12,nil,nil,17,nil,nil,0},
[475] = {'Kobold Tunneler',120,120,5,6,0,{[12]={{37.83,78.5},{36.26,79.24},{39.41,80.35},{35.91,82.91},{36.75,83.71},{41.9,79.96},{38.97,85.12},{40.28,78.57},{39.76,83.99},{40.74,81.37},{37.66,84.99},{37.38,83.4},{39.7,82.86},{37.65,78.93},{40.34,82.52},{40.49,81.23},{38.48,81.5},{36.94,81.21},{38.76,83.82},{38.01,81.62},{37.97,83.93},{39.02,81.32},{39.6,82.14},{39.03,80.68},{41.16,78.73},{38.75,77.9},{41.12,80.23},{40.84,77.48},{38.51,82.26},{39.04,81.33},{39.07,82.63},{38.11,82.58},{38.62,84.01},{38.81,81.86},{39.71,82.61},{39.33,83.19},{38.86,81.53},{41.16,78.2},{40.33,78.26},{41.83,81.36},{40.73,78.32},{36.14,82.42},{36.57,84.02},{41.82,79.58},{39.02,85.15},{40.55,77.98},{39.74,83.62},{40.83,81.2},{37.69,84.98},{37.41,83.41},{39.72,82.88},{37.72,78.69},{40.34,82.54},{40.52,81.26},{38.5,81.49},{37.28,80.74},{38.75,83.8},{38.01,81.63},{37.96,83.93},{39.26,80.41},{39.6,82.17},{39.02,80.65},{41.52,79.92},{38.9,78.68},{41.08,80.27},{40.82,77.47},{38.51,82.26},{39.04,81.38},{39.07,82.63},{38.1,82.61},{38.53,84.12},{38.81,81.85},{39.78,82.45},{39.32,83.21},{38.88,81.54},{40.31,78.19},{36.15,79.43},{41.86,81.38},{40.73,78.31},{36.25,82.3},{36.78,83.61},{37.76,85.03},{37.4,83.44},{37.43,78.98},{37.23,80.76},{41.05,78.15},{40.83,77.45},{40.83,78.37},{40.35,78.17},{36.22,79.15},{40.71,78.3},{35.91,82.29},{37.77,78.76},{38.5,81.48},{37.15,80.67},{38.02,81.62},{40.84,77.48},{40.31,78.19},{36.1,79.33}}},nil,12,nil,nil,26,nil,nil,0},
[476] = {'Kobold Geomancer',126,126,7,8,0,{[12]={{62.55,54.08},{62.31,55.57},{60.88,56.33},{61.31,52.41},{62.59,54.21},{62.23,55.56},{62.32,58.03},{63.44,58.58},{61.26,51.66}}},nil,12,nil,nil,26,nil,nil,0},
[478] = {'Riverpaw Outrunner',198,198,9,10,0,{[12]={{26.35,95.65},{27.59,95.57},{25.33,96.36},{24.45,96.25},{23.36,94.43},{23.95,89.46},{23.76,91.17},{23.87,88.02},{27.92,84.11},{28.28,87.09},{26.74,82.95},{26.5,89.86},{25.56,91.09},{25.41,88.46},{27.66,88.32},{28.03,88.22},{27.63,95.09},{25.37,86.61},{25.31,96.18},{25.31,89.11},{26.32,88.58},{26.31,95.69},{24.29,87.98},{27.45,79.72},{25.89,85.39},{27.05,85.62},{27.83,81.38},{26.46,86.65},{26.23,81.46},{28.22,90.85},{27.58,89.12},{27.12,87.38},{28.4,92.53},{27.19,94.37},{26.62,92.85},{26.87,91.39},{67.83,44.94},{67.88,45.57},{66.62,43.57},{68.83,43.12},{68.91,45.25},{68.37,45.35},{72.76,38.91},{68.13,48.97},{67.56,42.32},{68.26,50.79},{68.55,54.34},{76.51,40.18},{69.63,39.25},{68.88,38.8},{68.21,38.68},{69.24,38.98},{69.23,38.37},{67.97,40.48},{68.09,39.41},{67.99,39.75},{73.03,38.6},{68.63,41.01},{76.59,39.94},{67.82,45.59},{66.93,40.59},{66.65,41.33},{66.33,40.62},{66.61,40.35},{66.05,41.03},{66.02,42.29},{66.57,43.36},{69.66,39.27},{68.87,38.86},{68.16,38.72},{67.9,40.32},{68.85,43.06},{68.87,45.35},{72.82,38.24},{68.21,48.73},{68.76,40.56},{67.75,42.27},{68.2,50.59},{68.57,54.33},{28.32,91.31},{28.52,93.24},{27.74,83.72},{28.34,86.98},{27.26,79.9},{28.27,91.31},{27.93,89.36},{27.63,81.4},{26.9,84.05},{27.15,87.09},{26.98,85.47},{23.89,91.3},{25.41,87.05},{23.35,94.53},{25.42,88.47},{23.86,89.78},{23.87,87.9},{24.52,88.18},{25.14,89.24}}},nil,12,nil,nil,20,nil,nil,0},
[480] = {'Rusty Harvest Golem',176,198,9,10,0,nil,nil,0,nil,nil,14,nil,nil,0},
[481] = {'Defias Footpad',198,222,10,11,0,nil,nil,0,nil,nil,17,nil,nil,0},
[482] = {'Elling Trias',1003,1003,30,30,0,{[1519]={{66.03,74.1}}},nil,1519,nil,{350,434,1242,1245,1247},12,"A","Master of Cheese",0},
[483] = {'Elaine Trias',1003,1003,30,30,0,{[1519]={{66.56,73.37}}},nil,1519,nil,nil,12,"A","Mistress of Cheese",641},
[485] = {'Blackrock Outrunner',490,531,20,21,0,nil,nil,0,nil,nil,40,nil,nil,0},
[486] = {'Tharil\'zun',5196,5196,20,20,1,{[44]={{62.1,54.17}}},nil,44,nil,nil,40,nil,nil,0},
[487] = {'Protector Bialon',1910,1910,30,30,0,{[40]={{55.71,47.41}}},nil,40,nil,nil,11,"A","The Westfall Brigade",0},
[488] = {'Protector Weaver',1910,1910,30,30,0,{[40]={{56.95,46.87}}},{[40]={{{57,47.44},{56.84,47.49},{56.69,47.31},{56.68,47.06},{56.8,46.89},{56.96,46.87},{57.07,47.03},{57.09,47.28}}}},40,nil,nil,11,"A","The Westfall Brigade",0},
[489] = {'Protector Dutfield',1910,1910,30,30,0,{[40]={{56.48,47.85}}},{[40]={{{56.62,47.95},{56.88,48},{57.27,47.87},{57.47,47.28},{57.35,46.63},{56.83,46.31},{56.37,46.8},{56.32,47.33},{56.56,47.88}}}},40,nil,nil,11,"A","The Westfall Brigade",0},
[490] = {'Protector Gariel',1910,1910,30,30,0,{[40]={{55.96,48.2}}},nil,40,nil,nil,11,"A","The Westfall Brigade",0},
[491] = {'Quartermaster Lewis',484,484,20,20,0,{[40]={{57,47.17}},[1581]={{-1,-1}}},nil,40,nil,{6285},12,"A","Quartermaster",4737},
[494] = {'Watcher Bukouris',1536,1536,37,37,0,{[10]={{72.8,45.89},{73.11,46}}},nil,10,nil,nil,11,"A","The Night Watch",0},
[495] = {'Watcher Keefer',1753,1753,40,40,0,{[10]={{74.28,46.1}}},nil,10,nil,nil,11,"A","The Night Watch",0},
[499] = {'Watcher Paige',950,950,29,29,0,{[10]={{45.01,67.66}}},nil,10,nil,nil,56,"A","The Night Watch",0},
[500] = {'Riverpaw Scout',198,198,9,10,0,{[40]={{45.79,14.36},{41.66,20.77},{44.1,15.09},{44.99,15.38},{58.2,13.02},{58.36,11.38},{57.01,13.29},{55.99,13.41},{51.46,16.28},{43.63,16.33},{45.89,13.84},{58.37,11.12},{57.18,13.54},{56.04,13.42}}},nil,40,nil,nil,20,nil,nil,0},
[501] = {'Riverpaw Herbalist',273,273,12,13,0,{[40]={{34.95,27.96},{32.24,29.01},{36.55,31.63},{46.6,53.36},{49.08,47.89},{34.2,26.92},{38.24,33.29},{48.34,46.77},{47.81,45.95},{49.05,46.07},{50.62,47.36},{50.9,52.03},{51.32,53.32},{51.29,54.54},{54.41,48.09},{54.43,48.17},{54.63,49.89},{54.77,43.57},{52.48,50.07},{52.53,50.13},{52.45,50.99},{52.01,49.62},{54.22,44.13},{52.49,50.16},{35.02,28.05},{32.37,29},{31.51,72.42},{29.8,61.69},{30.11,56.64},{30.35,58.06},{29.18,65.46},{30.46,67.86},{31.5,52.61},{30.66,52.06},{29.27,58.81},{29.76,60.33},{35.75,61.14},{29.36,69.45},{28.18,67.02},{30.41,50.78},{28.55,61.86},{28.78,45.96},{51.05,51.96},{28.22,47.73},{31.02,47.78},{31.27,49.4},{30.19,49.59},{51.3,53.28},{51.27,54.58},{31.38,66.42},{32.66,68.28},{32.6,67.45},{31.01,69.37},{31.24,69.36},{30.31,72.52},{52.54,50.13}}},nil,40,nil,nil,20,nil,nil,0},
[502] = {'Benny Blaanco',328,328,15,15,0,nil,nil,0,nil,nil,14,nil,nil,0},
[503] = {'Lord Malathrom',935,935,31,31,4,{[10]={{20.28,28.69}}},nil,10,nil,nil,14,nil,nil,0},
[504] = {'Defias Trapper',250,273,12,13,0,nil,nil,0,nil,nil,17,nil,nil,0},
[505] = {'Greater Tarantula',449,484,19,20,0,{[44]={{59.99,67.92}}},nil,44,nil,nil,22,nil,nil,0},
[506] = {'Sergeant Brashclaw',410,410,13,13,4,{[40]={{34.8,38.57},{63.55,73.14}}},nil,40,nil,nil,20,nil,nil,0},
[507] = {'Fenros',843,843,22,22,4,{[10]={{60.75,40.69},{63.62,50.3}}},nil,10,nil,nil,24,nil,nil,0},
[510] = {'Water Elemental',4700,4700,36,36,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[511] = {'Insane Ghoul',1124,1124,22,22,0,{[10]={{80.92,71.39}}},{[10]={{{80.9,71.96},{80.85,71.75},{80.8,71.53},{80.77,71.41},{80.77,71.41},{80.78,71.72},{80.74,71.49},{80.84,71.59},{80.88,71.56},{80.79,71.32},{80.8,71.32},{80.92,71.46},{80.85,71.37},{80.8,71.32},{80.88,71.21},{80.93,71.47},{80.78,71.49},{80.82,71.46},{80.84,71.57},{80.86,71.59},{80.97,71.77},{80.84,71.92},{80.77,71.75},{80.76,71.29},{80.79,71.3},{80.82,71.35},{80.88,71.42},{81.07,71.71},{80.86,71.75},{80.49,71.25},{79.95,70.8},{79.74,69.89},{79.16,69.5},{78.82,68.61},{78.2,69.95},{78.22,71.07},{78.7,71.47},{78.57,71.95},{79.11,72.86},{79.75,73.03},{80.03,72.59},{79.65,72},{80.01,70.88},{80.57,71.29}}}},10,nil,nil,21,nil,nil,0},
[513] = {'Murloc Netter',247,247,11,12,0,{[40]={{35.34,21.96},{35.71,21.74},{35.1,21.03},{35.44,22.78},{39.26,15.76},{28.83,35.52},{32.25,26.73},{34.56,15.89},{33.54,17.93},{34.03,17.38},{33.43,17.75},{33.7,16.46},{34.19,16.78},{33.46,17.26},{34.87,23.22},{35.15,20.89},{34.94,22.64},{39.17,15.23},{38.3,15.35},{37.16,16.53},{32.54,26.64},{32.24,25.61},{28.47,33.19},{34.99,16.7},{37.98,16.19}}},nil,40,nil,nil,18,nil,nil,0},
[514] = {'Smith Argus',664,664,24,24,0,{[12]={{41.71,65.54}}},nil,12,{1097,26393},{118,26396},12,"A","Blacksmithing Trainer",83},
[515] = {'Murloc Raider',176,176,9,10,0,{[40]={{42.2,10.57},{42.51,12.3},{55.96,10.9},{56.28,8.98},{56.01,9.49},{43.37,11.11},{44.62,9},{42.18,10.76},{42.95,9.77},{37.16,16.01},{42.44,12.41},{48.3,9.23},{46.34,8.72},{45.4,8.94},{46.9,9.06},{49.02,9.62},{43.75,9.18},{43.87,10.19},{55.95,10.81},{56.38,8.87},{44.78,9.51},{50.52,9.86},{53.16,9},{43.36,11.12},{54.85,9.76},{53.66,9.71},{53.28,11.72},{52.77,10.17},{52.15,9.64}}},nil,40,nil,nil,18,nil,nil,0},
[517] = {'Murloc Oracle',253,253,13,14,0,{[40]={{25.22,56.56},{23.69,57.32},{28.08,59.42},{27.38,58.88},{26.63,73.84},{25.92,71.91},{25.8,60.77},{25.99,58.92},{27.96,54.22},{27.46,56.32},{28.34,56.57},{27.45,59.75},{26.58,59.77},{27.9,53.98},{27.11,72.74},{25.31,73.99},{26.66,72.09},{27.99,75.67},{26.47,73.15},{28.02,68.98},{27.92,72.51},{27.78,52.3},{27.34,54.69},{26.86,54.21},{35,83.7},{32.67,83.73},{35.02,85.77},{35.01,84.82},{33.69,84.42},{34.4,84.96},{34.17,85.49},{35.03,85.22},{34.8,84.53},{33.15,84.1},{32.87,83.97},{35.03,86.13},{34.91,85.35},{34.07,84.67},{32.72,83.18},{34.51,86.49},{34.24,85.92}}},nil,40,nil,nil,18,nil,nil,0},
[518] = {'Yowler',712,712,16,16,0,{[44]={{26.87,21.98}}},nil,44,{26545},nil,19,nil,nil,0},
[519] = {'Slark',279,279,10,10,4,{[40]={{52.46,10.37},{55.24,11.09}}},{[40]={{{47.01,10.94},{46.37,10.56},{45.4,10.07},{44.31,10},{43.6,10.11},{42.59,10.73},{42.27,11},{42.33,11.92},{41.98,11.96},{41.26,12.16},{40.16,12.4},{39.6,12.98},{39.16,14.43},{39.02,15.51},{38.32,16.6},{37.66,17.06},{36.94,18.24},{36.03,19.1},{35.7,19.3},{35.17,19.9},{34.69,21.97},{33.86,22.94},{32.82,23.38},{32.08,24.36},{31.63,25.86},{31.06,27.26},{30.73,28.22},{30.57,29.24},{30.27,30.69},{29.77,31.5},{29.33,32.92},{29.21,34},{29.14,34.55},{28.57,35.9},{28.06,37.36},{27.69,38.91},{27.55,39.99},{27.37,41.61},{27.06,43.75},{26.92,44.81},{26.91,45.9},{26.92,46.99},{26.76,48.62},{27.18,49.8},{27.46,50.13},{27.72,51.11},{27.76,52.2},{27.81,52.74},{27.8,53.69},{27.89,53.72},{27.54,53.56},{27.29,53.74},{27.04,55.35},{26.99,56.43},{27.32,57.39},{27.24,58.87},{26.67,60.26},{26.43,61.24},{26.44,62.31},{26.43,62.81},{26.19,64.24},{26.57,65.58},{27,66.45},{27.35,67.93},{27.38,68.47},{27.42,69.45},{28.27,70.46},{28.76,71.23},{29.03,72.77},{29.07,74.44},{29.13,76.09},{29.22,77.73},{29.39,78.79},{29.73,79.77},{30.19,80.61},{30.98,81.76},{31.59,82.14},{32.3,82.2},{32.99,82.56},{33.33,82.7},{33.96,83.21},{34.28,83.41},{34.63,83.5},{34.93,83.8},{35.19,84.19},{35.44,85.18},{35.2,85.65},{34.97,85.37},{34.24,85.24},{33.92,85.2},{32.99,84.32},{32.69,84.04},{32.1,83.42},{31.27,82.43},{30.78,81.59},{30,80.55},{29.08,79.67},{28.59,78.91},{28.52,77.96},{28.69,77.57},{28.5,76.52},{28.13,75.57},{27.73,74.65},{27.48,73.64},{27.51,72.56},{27.66,71.48},{27.45,69.99},{27.02,68.48},{26.39,67.16},{26.21,66.16},{26.21,65.61},{26.22,63.69},{26.26,62.66},{26.48,61.04},{26.73,60.03},{27.08,59.05},{27.58,57.6},{27.9,56.6},{27.91,55.67},{27.36,54.26},{27,52.7},{26.89,51.6},{26.64,49.44},{26.58,48.35},{26.74,46.74},{26.68,45.1},{26.8,44.66},{27.07,44.28},{27.27,43.26},{27.27,42.72},{27.58,41.14},{27.59,40.61},{27.31,39.6},{27.14,38.53},{27.11,37.46},{27.29,36.38},{27.36,35.85},{27.26,34.91},{27.41,34.41},{28.3,33.9},{28.78,33.29},{28.96,32.81},{29.4,31.32},{30,29.94},{30.12,28.92},{30.14,28.39},{30.19,27.86},{30.64,27.06},{31.24,26.47},{31.92,25.2},{32.24,24.24},{32.64,23.37},{33.22,22.69},{33.88,22.43},{34.74,21.66},{35.2,20.82},{35.34,20.34},{35.47,19.27},{35.84,18.35},{36.12,17.99},{36.8,16.8},{37.29,16},{37.8,15.23},{38.42,14.74},{39.22,13.79},{39.66,12.89},{40.57,12.16},{41.24,11.77},{42.23,11.08},{42.58,10.9},{43.3,10.7},{43.93,10.2},{44.98,10.04},{45.33,10.12},{46.2,11},{47.18,11.4},{47.83,11.03},{48.84,11.04},{49.16,11.26},{49.78,11.7},{50.78,11.16},{51.72,10.27},{52.41,10.09},{53.12,10.27},{53.75,10.8},{54.09,11.7},{54.22,12.19},{54.48,12.58},{55.11,12.16},{55.38,11.79},{55.67,11.45},{56.02,11.33},{56.12,10.81},{55.95,10.46},{55.24,10.76},{54.52,10.94},{54.15,10.95},{53.79,10.87},{53.09,10.6},{52.36,10.56},{51.27,10.77},{50.56,11.07},{49.84,11.2},{48.78,10.81},{48.09,10.79},{47.01,10.94},{47.74,10.97}}}},40,nil,nil,18,nil,nil,0},
[520] = {'Brack',450,450,14,14,4,{[40]={{55.64,9.39},{32.68,82.38}}},{[40]={{{27.28,44.53},{27.03,45.15},{26.91,46.19},{26.85,46.81},{26.98,47.44},{26.93,47.82},{26.85,48.42},{26.83,48.93},{26.89,49.33},{27,49.78},{27.08,50.21},{27.22,50.7},{27.4,51.63},{27.41,52.07},{27.36,52.53},{27.31,53.03},{27.28,54.5},{27.27,54.85},{27.2,55.38},{27.11,55.8},{27.05,56.2},{27.01,56.78},{26.94,57.62},{26.92,57.93},{26.89,58.48},{26.61,58.61},{26.2,58.79},{26.34,58.23},{26.39,57.79},{26.4,57.12},{26.36,55.87},{26.68,55.24},{27.03,54.55},{27.09,54.24},{27.05,53.78},{26.95,53.23},{26.94,52.54},{26.87,52.27},{26.77,51.92},{26.82,51.57},{26.89,51.14},{26.95,50.83},{26.98,50.5},{26.99,50.24},{26.98,49.88},{26.96,49.5},{26.92,49.28},{26.81,48.9},{26.8,48.48},{26.8,47.79},{26.84,47.46},{27.05,46.91},{27.15,46.45},{27.24,45.83},{27.32,45.24},{27.35,44.88},{27.36,44.39},{27.33,43.8},{27.3,43.2},{27.32,42.78},{27.4,42.03},{27.54,41.32},{27.73,40.74},{27.71,40.13},{28,39.22},{28.1,38.83},{28.22,38.44},{28.22,37.79},{28.27,36.85},{27.9,36.9},{27.51,37.15},{27.35,37.62},{27.17,39.12},{27.19,39.98},{27.38,40.86},{27.34,41.37},{27.29,41.99},{27.27,42.44},{27.22,43.25},{27.21,43.55},{27.11,44.42}}}},40,nil,nil,18,nil,nil,0},
[521] = {'Lupos',726,726,20,20,4,{[10]={{72.01,25.8},{40.19,24.77},{69.74,24.59}}},nil,10,nil,nil,38,nil,nil,0},
[522] = {'Mor\'Ladim',1830,1830,25,25,1,{[10]={{18.46,35.21},{17.92,33.6},{16.36,39.48},{17.71,29.15}}},{[10]={{{16.57,36.95},{16.17,36.76},{15.81,37.07},{15.47,37.56},{15.13,38.11},{14.91,39.19},{14.96,40},{14.82,40.92},{14.58,41.87},{14.59,42.14},{14.82,42.6},{15.1,42.84},{15.45,43.04},{16.29,43.36},{17.3,43.32},{17.98,42.86},{18.73,42.09},{19.32,41.67},{19.68,40.72},{19.82,39.96},{19.59,38.89},{19.3,38.45},{18.96,38.29},{18.47,38.25},{18.05,38.24},{17.52,37.92},{17.29,37.96},{17.07,38.26},{16.95,38.54},{16.8,38.65},{16.67,38.58},{16.62,38.45},{16.73,37.94},{16.69,37.51}}}},10,nil,nil,21,nil,nil,0},
[523] = {'Thor',232470,232470,85,85,1,{[40]={{56.64,49.44}}},nil,40,nil,{6181},12,"A","Gryphon Master",8193},
[524] = {'Rockhide Boar',156,156,7,8,0,{[12]={{56.38,83.77},{55.33,85.25},{44.91,89.31},{49.35,73.78},{58.41,74.61},{51.97,74.14},{60.03,75.33},{59.2,74.22},{61.04,74.03},{55.37,73.92},{57.08,74.21},{53.3,74},{58.31,72.04},{72.7,76.66},{70,75.26},{66.66,76.44},{65.65,74.8},{64.34,75.17},{61.9,74.92},{67.9,75.32},{71.86,75.09},{59.46,74.08},{61.25,73.58},{70.78,73.61},{69.74,72.67},{73.38,83.45},{74.3,81.79},{72.12,83.93},{72.57,82.39},{72.75,79.58},{73.41,80.66},{72.8,76.76},{73.45,78.35},{74.36,80.2},{71.84,75.38},{70.97,73.46},{73.62,83.85},{74.37,81.99},{70.59,82.82},{72.06,83.73},{72.61,82.62},{72.95,79.43},{73.74,80.88},{72.61,76.72},{44.83,89.23},{49.83,78.62},{48.38,75.98},{49.68,79.71},{50.08,76.66},{47.77,78.24},{48.83,80.96},{47.65,78.53},{57.14,82.49},{58.14,81.33},{45.49,88.47},{67.23,76.77},{64.8,77.01},{65.6,75.22},{64.38,75.15},{66.92,79.85},{65.96,81.65},{64.32,81.25},{65.95,78.25},{64.56,79.53},{73.7,78.53},{74.5,79.73},{64.13,78.51},{66.86,82.29},{62.86,76.89},{63.1,79.57},{61.94,78.2},{62.16,75.11},{56.31,75.03},{55.22,76.58},{54.64,83.42},{52.44,83.92},{68.22,75.7},{71.99,75.28},{60.45,75.12},{59.21,74.21},{61.29,74.05},{60.48,78.35},{59.87,81.44},{60.97,76.77},{55.8,73.41},{60.94,78.75},{59.1,76.52},{57.27,76.66},{58.42,72.13},{46.01,85.01},{43.41,81.06},{43.12,77.37},{44.47,83.58},{44.08,80.28},{45.34,87.11},{47.45,76.16},{45.9,82.69},{46.46,77.22},{45.6,79.9},{46.68,81.23},{44,79.37},{44.51,78.85},{70.69,73.62},{69.56,72.59},{52.4,74.82},{54.28,77.61},{52.99,73.31},{52.38,81.05},{54.52,81.17},{49.5,73.78},{51.86,74.67},{53.36,79.57},{55.28,79.82},{53.48,76.29},{53.82,85.47},{56.35,83.49},{53.06,82.97},{55.26,85.39},{52.29,77.98},{54.41,74.8},{58.63,74.79},{57.06,73.87},{69.91,75.67},{48.31,76.02},{47.51,78.41},{42.99,81.19},{43.12,77.15},{44.35,83.13},{44.26,80.26},{47.55,76.72},{45.68,82.5},{46.4,77.16},{45.47,80.01},{47.11,80.82},{43.54,79.34},{43.87,78.35},{44.82,89.23},{57.46,82.78},{58.25,81.23},{65.88,81.05},{66.67,82.35},{46.06,85.51},{44.98,87.55},{56.23,83.64},{53.47,85.24},{55.49,85.09},{54.45,83.55},{45.54,88.3},{63.1,79.68},{61.09,79.53},{60.19,80.99},{64.17,81.1},{71.4,83.6},{65.75,81.27},{66.65,81.96},{70.77,82.38},{72.97,82.72},{73.58,83.9}}},nil,12,nil,nil,189,"AH",nil,0},
[525] = {'Mangy Wolf',102,102,5,6,0,{[12]={{33.04,57.8},{37.27,63.58},{41.57,57.98},{35,63.51},{42.13,54.82},{33.13,57.84},{35.99,62.59},{34.21,59.41},{36.76,61.14},{38.35,62.26},{32.01,55.02},{35.32,61.27},{34.79,62.58},{32.18,75.76},{35.02,74.97},{33.44,75.8},{33.3,75.44},{37.03,63.75},{34.45,65.46},{41.54,58.38},{35.04,67.43},{35.36,67.77},{35.07,64.09},{35.54,73.97},{29.2,72.85},{29.56,72.24},{29.41,73.64},{29.3,72.2},{33.24,57.79},{36.12,62.41},{38.29,64.02},{34.2,59.46},{37.91,65.31},{35.07,70},{37.22,60.7},{36.22,69.01},{35.41,72.46},{32.92,66.97},{34.24,72.49},{34.3,73.99},{30.92,71.23},{30.4,72.11},{30.28,72.14},{38.38,62.22},{31.99,77.12},{35.08,70.35},{35.41,61.25},{34.77,62.18},{42.76,60.75},{31.97,76.08},{34.92,75.08},{32.83,75.96},{33.27,75.58},{21.76,77.27},{34.5,65.4},{34.58,67.72},{34.67,67.29},{35.02,63.96},{21.77,74.02},{35.29,73.39},{27.54,74.23},{29.23,72.77},{28.95,72.24},{29.3,73.78},{26.65,75.5},{28.44,73.01},{28.98,69.48},{22.86,75.69},{28.31,67.66},{27.34,73.77},{27.15,70.4},{32.96,67.05},{34.31,72.47},{33.92,73.52},{22.5,75.47},{30.89,71.85},{30.59,72.33},{29.48,73.1},{28.16,74.94},{32.53,77.13},{34.4,62.29},{23.56,76.97},{32.08,75.83},{35.06,74.93},{33.96,75.49},{33.33,75.85},{36.84,63.55},{21.76,77.26},{34.92,68.03},{34.99,67.64},{21.64,74.18},{35.04,73.08},{28.48,74.83},{29.41,73.62},{26.58,75.96},{28.36,73.58},{38.24,63.77},{22.54,75.51},{38.05,64.98},{35.08,70.89},{37.12,60.99},{36.15,69.47},{27.54,74.16},{27.5,70.99},{33.86,73.7},{34.76,74.02},{23.01,76.26},{28.76,75.41},{38.21,62.37},{32.37,76.84},{35.08,70.93},{42.62,61.74},{22.66,78.34},{34.97,72.67},{41.77,58.86},{49.73,69.35},{56.83,60.34},{44.4,57.83},{49.55,60.89},{52.16,62.31},{42.45,54.71},{50.03,62.11},{53.92,60.92},{49.79,58.43},{51,62.18},{57.36,58.83},{52.35,62.62},{54.99,61.29},{54.8,60.23},{58.22,60.83},{56.61,61.26},{52.09,62.96},{56.21,58.8},{54.17,71.23},{38.49,64.34},{37.91,65.3},{43.92,59.43},{52.06,63.55},{45.34,55.97},{52.17,70.84},{42.82,60.86},{56.16,71.11},{55.17,69.87},{51.34,69.77},{50.81,70.81},{53.39,69.59},{57.14,70.12},{45.87,68.58},{47.53,68.04},{47.5,68.03},{42.62,62.2},{58.13,62.06},{54.02,71.17},{55.13,69.9},{51.32,69.75},{49.54,69.53},{56.12,71.08},{45.87,68.72},{47.51,68.22},{47.5,68.05},{31.99,77.15},{35.04,74.62},{34.05,75.49},{33.46,75.02},{32.35,76.74},{31.96,76.11},{33.53,76.2},{33.34,75.19},{35.59,72.65},{35.34,70.68},{36.17,69.16},{32.43,77.6},{35.02,72.74},{35.3,70.55}}},nil,12,nil,nil,38,nil,nil,0},
[531] = {'Skeletal Fiend',713,720,24,25,0,nil,nil,0,nil,nil,21,nil,nil,0},
[533] = {'Nightbane Shadow Weaver',498,498,22,23,0,{[10]={{65.51,67.61},{62.33,81.25},{62.74,79.96},{63.81,76.17},{61.32,70.64},{62.71,74.86},{61.27,75.2},{62.87,72.93},{64.11,73.03},{61.04,73.22},{65.36,67.75},{63.67,65.4},{62.5,71.07},{65.28,66.51},{62.98,67.84},{64.67,74.8},{66.1,76.35},{65.34,73.37},{66.43,72.34},{66.32,76.45},{64.31,70.65},{65.87,69.38},{66.2,70.19},{63.77,67.89},{66.55,68.71}}},nil,10,nil,nil,24,nil,nil,0},
[534] = {'Nefaru',976,976,24,24,4,{[10]={{63.53,83.85},{61.85,81.38},{73.97,79.12}}},nil,10,nil,nil,24,nil,"The Den Mother",0},
[539] = {'Pygmy Venom Web Spider',440,449,18,19,0,nil,nil,0,nil,nil,22,nil,nil,0},
[541] = {'Riding Gryphon',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[542] = {'Califex of the Deep Wood',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Druid Trainer",32},
[543] = {'Nalesette Wildbringer',1753,1753,40,40,0,{[361]={{61.62,25.44}}},nil,361,nil,nil,80,"A","Stable Master",129},
[544] = {'Murloc Nightcrawler',425,425,17,18,0,{[44]={{75.19,56.07},{71.41,56.57},{72.09,55.44},{71.79,56.05},{72.03,58.19},{72.19,54.72},{72.25,54}}},nil,44,nil,nil,18,nil,nil,0},
[545] = {'Murloc Tidecaller',325,325,16,16,0,{[44]={{49.28,48.13},{51.53,49.69},{50.61,49.03},{50.79,47.09},{52.77,46.82},{52.76,47.35}}},nil,44,nil,nil,18,nil,nil,0},
[547] = {'Great Goretusk',328,328,14,15,0,{[44]={{42.97,11},{43.32,15.4},{11.5,75.9},{13.22,67.34},{12.93,76.26},{11.09,75.77},{13.51,67.31},{18.57,63.76},{44.65,26.43},{42.44,16.99},{43.32,15.85},{39.9,14.48},{12.67,77.29},{11.08,76.52},{41.72,10.11},{41.86,21.76},{30.11,64.61},{34.28,56.96},{29.35,56.48},{31.77,55.33},{32.38,54.54},{29.08,56.51},{32.26,63.81},{37.68,65.86},{35.52,63.93},{26.64,59.5},{29.16,70.7},{28.25,71.42},{22.92,60.5}}},nil,44,nil,nil,189,"AH",nil,0},
[548] = {'Murloc Minor Tidecaller',150,150,15,15,0,{[44]={{44.58,63.95},{45.92,62.73},{44.11,64.1},{44.81,62.78}}},nil,44,nil,nil,18,nil,nil,0},
[550] = {'Defias Messenger',300,328,14,15,0,nil,{[40]={{{45.1,69.33},{45.59,68.72},{45.82,68.16},{45.86,67.68},{45.5,66.54},{45.48,65.86},{45.6,64.98},{44.81,64.29},{44.43,63.5},{44.02,61.83},{43.71,60.33},{43.47,59.15},{43.31,57.58},{43.23,56.35},{43.19,54.62},{42.99,54.02},{42.34,53.21},{42.07,52.61},{41.84,51.89},{41.72,51.27},{41.67,50.35},{41.11,49.3},{40.79,48.46},{40.06,47.56},{38.97,46.27},{38.71,45.64},{38.48,45.34},{37.82,45.59},{37.29,44.79},{36.59,44.37},{35.7,44.04},{34.83,43.49},{33.98,43.11},{33.03,42.96},{32.09,43.34},{31.68,43.86},{31.24,44.87},{30.76,45.87},{30.47,45.81},{30.32,45.62},{29.68,46.18},{29.85,46.74},{29.87,47.3},{30.12,47.65},{30.54,47.88},{30.69,48.33},{30.54,49.03},{30.16,49.68},{29.71,50.26},{29.65,50.08},{30.22,49.53},{30.54,48.96},{30.69,48.21},{30.51,47.85},{29.82,47.28},{29.76,46.1},{30.25,45.6},{30.81,45.93},{30.98,45.34},{31.44,44.43},{31.78,43.65},{32.25,43.28},{32.54,43.15},{32.94,42.88},{33.85,43.06},{34.57,43.42},{35.56,43.89},{36.26,43.94},{36.61,43.34},{36.88,42.34},{36.91,40.81},{37.08,39.59},{37.44,38.56},{37.83,37.11},{38.33,36.3},{39.27,35.29},{40.33,34.5},{40.87,33.67},{41.27,32.75},{41.75,31.01},{42.14,30.36},{42.87,29.36},{43.73,28.62},{44.26,27.98},{44.49,26.34},{44.52,25.35},{44.56,24.69},{44.63,23.49},{45,22.85},{44.95,22.45},{44.53,21.44},{44.76,20.65},{44.75,20.37},{44.53,19.7},{44.65,19.28},{44.88,19.01},{45.52,18.16},{45.83,18.08},{46,18.28},{46.13,18.68},{46.3,18.95},{45.86,18.13},{45.6,18.1},{45.17,18.63},{44.59,19.42},{44.61,20.15},{44.8,20.67},{44.57,21.37},{44.63,21.71},{45.01,22.83},{44.59,23.61},{44.59,24.3},{44.52,25.34},{44.29,26.24},{44.17,27.89},{43.62,28.71},{42.8,29.55},{41.81,30.92},{41.34,32.51},{40.92,33.66},{40.32,34.46},{39.53,35.09},{38.49,36.1},{37.92,36.95},{37.61,37.82},{37.29,39.05},{36.99,40.11},{36.85,42.07},{36.96,43.24},{37.39,43.94},{37.94,44.61},{38.66,45.55},{39.09,46.39},{39.94,47.42},{40.67,48.25},{40.99,49},{41.19,49.46},{41.7,50.43},{41.75,51.49},{42.02,52.51},{42.38,53.27},{43.04,54.15},{43.19,54.7},{43.22,55.98},{42.84,56.38},{42.43,56.36},{42.1,55.87},{41.78,54.16},{41.8,53.34},{41.94,52.98},{42.23,53},{42.85,53.82},{43.15,54.48},{43.25,55.31},{43.23,56.54},{43.3,57.5},{43.46,59.1},{43.77,60.62},{44.09,62.03},{44.4,63.23},{44.63,63.92},{44.97,64.48},{45.34,64.81},{45.62,64.98},{45.48,66.11},{45.56,66.76},{45.86,67.7},{45.83,68.24},{45.43,69.06},{44.98,69.49},{44.48,69.61}}}},0,nil,nil,17,nil,nil,0},
[564] = {'Kobold Slave',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[565] = {'Rabid Dire Wolf',494,531,20,21,0,nil,nil,0,nil,nil,38,nil,nil,0},
[566] = {'V\'rex',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[567] = {'Blacknails',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[568] = {'Shadowhide Warrior',425,425,18,18,0,{[44]={{71.02,42.71},{70.21,43.58},{67.81,39.03},{71.41,33.21},{71.85,36.61},{69.04,37.34},{71.1,41.82},{70.29,37.72},{72.3,39.86},{71.44,37.84},{75.8,44.17},{72.68,37.67},{67.73,34.6},{73.02,43.93},{73.22,48.64},{70.51,40.67},{71.55,50.17},{77.01,51.18},{71.41,49.44},{74.29,51.87},{73.76,51.2},{69.26,41.55},{69.98,48.3},{76.06,53.09},{73.71,50.69}}},nil,44,nil,nil,39,nil,nil,0},
[569] = {'Green Recluse',531,573,21,22,0,nil,nil,0,nil,nil,22,nil,nil,0},
[570] = {'Brain Eater',896,950,28,29,0,nil,nil,0,nil,nil,14,nil,nil,0},
[572] = {'Leprithus',345,345,12,12,4,{[40]={{41.67,29.33},{56.99,80.46},{41.71,29.31}}},{[40]={{{57.96,79.59},{58.7,79.05},{59.08,78.88},{59.87,77.68},{60.61,76.91},{61.14,75.97},{61.45,74.84},{61.86,73.97},{62.34,72.29},{62,71.12},{62.1,70.25},{62.99,69.1},{63.66,68.69},{64.43,67.83},{65.14,66.97},{65.56,64.88},{65.56,64.88}}}},40,nil,nil,21,nil,nil,0},
[573] = {'Foe Reaper 4000',370,370,12,12,4,{[40]={{44.82,35.38},{50.52,69.26},{47.67,68.93},{53.94,63.06},{46.94,35.53},{46.4,66.04},{63.78,59.55},{49.24,27.43},{61.25,60.14},{54.3,25.78},{51.09,22.2},{50.66,19.3},{51.39,25.42},{63.38,62.02},{40.61,49.56},{38.39,54.29},{43.92,36.71},{44.47,45.52},{44.7,32.66},{33.24,52.89},{36.03,51.34},{63.6,60.86}}},nil,40,nil,nil,14,nil,nil,0},
[574] = {'Naraxis',782,782,21,21,4,{[10]={{86.22,47.51}}},{[10]={{{86.33,47.27},{86.35,47.6},{86.51,48.96},{86.67,49.86},{86.17,50.88},{86.96,51.3},{87.26,50.64},{86.57,49.85}}}},10,nil,nil,22,nil,nil,0},
[575] = {'Fire Elemental',1403,1403,35,35,0,nil,nil,0,nil,nil,67,nil,nil,0},
[576] = {'Watcher Ladimore',896,896,28,28,0,{[10]={{74.02,47.82}}},{[10]={{{74.3,48.05},{74.59,48.19},{74.78,47.61},{75,47.41},{75.28,47.36},{75.52,46.37},{75.05,46.26},{75.05,45.47},{74.54,46.09},{74.12,46.18},{73.58,46.53},{73.61,47.18},{74.02,47.82}}}},10,{26797},{229,26796},12,"A","The Night Watch",2},
[578] = {'Murloc Scout',328,328,15,16,0,{[44]={{51.66,48.18},{49.3,49.44},{51.48,46.09},{52.35,48.84},{51.32,47.27},{51.85,46.78},{52.81,47.81},{52.5,47.43},{54.17,51.12},{40.37,49.05},{37.5,50.07},{39.31,46.82},{40.61,45.27},{36.34,45.99},{38.72,42.84}}},nil,44,nil,nil,18,nil,nil,0},
[579] = {'Shadowhide Assassin',458,458,18,18,0,{[44]={{69.74,36.49},{66.56,42.88}}},nil,44,nil,nil,39,nil,nil,0},
[580] = {'Redridge Drudger',335,335,15,16,0,{[44]={{17.64,22.11},{22.31,20.79},{21.8,23.48},{19.34,16.47},{19.47,24.08},{20.43,26.76}}},nil,44,nil,nil,19,nil,nil,0},
[582] = {'Old Blanchy',55,55,2,2,0,{[40]={{60.22,19.31}},[394]={{59.07,26.51}}},nil,40,nil,nil,35,"AH",nil,0},
[583] = {'Ambusher',176,176,9,9,0,{[12]={{34.44,55.57}}},nil,12,nil,nil,27,nil,nil,0},
[584] = {'Kazon',579,579,17,17,4,{[44]={{34.68,10.87},{33.92,10.2}}},nil,44,nil,nil,40,nil,nil,0},
[587] = {'Bloodscalp Warrior',699,699,25,25,0,{[33]={{34.05,33.61},{34.21,36.37},{34.29,35.8}}},nil,33,nil,nil,28,nil,nil,0},
[588] = {'Bloodscalp Scout',750,750,26,27,0,{[33]={{23.93,20.16},{24.07,22.72},{24.74,22.41},{25.4,20.15},{25.6,21.09},{27.34,20.32},{27.98,20.53},{28.99,19.47},{29.03,21.28},{28.24,19.75},{28.39,21.2},{28.64,22.74},{27.4,21.75},{24.05,24.6},{24.41,23.84},{24.74,26.16},{25.99,23.07},{26.34,25.33},{26.8,23.46},{28.75,24.53},{28.84,24.99},{28.98,24.83},{30.68,23.05},{29.39,26.18}},[5339]={{40.94,17.62}}},nil,33,nil,nil,28,nil,nil,0},
[589] = {'Defias Pillager',263,263,13,14,0,{[40]={{55.73,44.96},{55.45,46.17},{54.61,44.78},{58.29,42.46},{56,51.41}}},nil,40,nil,nil,17,nil,nil,0},
[590] = {'Defias Looter',250,300,13,14,0,{[40]={{60.76,58.23},{60.61,58.2}}},nil,40,nil,nil,17,nil,nil,0},
[594] = {'Defias Henchman',300,300,13,14,0,{[40]={{54.86,44.7},{54.85,44.62},{54.75,43.47},{55.59,45},{55.53,45.05},{53.86,44.35},{58.37,42.42},{58.36,42.39},{58.37,42.34},{58.31,41.26},{55.13,48.58},{53.9,48.83},{55.1,48.54},{53.96,48.93},{53.93,48.87},{55.57,50.29}}},nil,40,nil,nil,17,nil,nil,0},
[595] = {'Bloodscalp Hunter',750,750,26,27,0,{[33]={{24.92,19.84},{24.81,19.16},{28.04,19.56},{26.55,19.71},{25.31,22.17},{28.59,19.49},{26.3,24.54},{25.62,24.55},{26.95,24.52},{26.74,25.27},{27.07,25.28},{28.82,23.45},{28.69,25.28},{29.26,24.49},{29.25,24.85},{31.31,23.7},{29.05,25.33},{25.84,26.31},{29,26.42}},[5339]={{40.94,17.62}}},nil,33,nil,nil,28,nil,nil,0},
[596] = {'Brainwashed Noble',428,428,15,15,4,{[33]={{6.5,7.77},{5.06,6.1}}},nil,33,nil,nil,17,nil,nil,0},
[597] = {'Bloodscalp Berserker',750,750,25,26,0,{[33]={{22.27,27.14},{19.64,27.06},{20.79,27.14},{19.31,24.01},{19.29,24.45},{19.54,23.71},{20.25,27.78},{20.91,29.36},{21.81,24.83},{17.64,24.17},{18.53,24.39}}},nil,33,nil,nil,28,nil,nil,0},
[598] = {'Defias Miner',386,417,17,18,0,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[599] = {'Marisa du\'Paige',428,428,15,15,4,{[40]={{42.2,80.09}}},nil,40,nil,nil,17,nil,nil,0},
[603] = {'Grimtooth',16172,16172,60,60,0,{[2597]={{-1,-1}}},nil,2597,nil,nil,14,nil,nil,0},
[604] = {'Plague Spreader',699,699,24,25,0,{[10]={{16.4,30.57},{16.33,29.28},{17.57,43.71},{21.65,44.67},{22.58,35.55},{15.68,35.56},{22.8,41.94},{23.3,44.18},{22.92,39.01},{16.98,45.01},{18.95,45.95},{21.52,46.5},{15.61,37.39},{19.32,31.7},{17.79,40.67},{17.06,33.44},{18.17,37.9},{13.11,33.39},{17.56,37.96},{17.02,35.71},{15.42,37.37},{18.07,38.64},{14.26,33.96},{16.85,34.37},{14.67,33.89},{16.52,35.53},{16.45,32.93},{16.2,32.48},{17.06,38.3},{15.92,35.2},{14.81,36.42},{13.79,32.06},{13.92,36.07},{15.2,33.8},{15.52,37.38},{13.92,36.52},{17.9,37.91},{16.29,32.14},{12.88,33.6},{16.67,32.43},{16.47,34.31},{14.95,36.81},{17.78,38.33},{13.68,36.4},{15.44,34.08},{17.59,35.49},{14.6,33.15},{18.13,38.22},{18.74,35.9},{13.82,33.52},{13.98,33.4},{17.93,37.45},{16.5,32.19},{16.11,34.52},{18.24,32.81},{18.7,40.41},{13.68,36.81},{22.72,35.47},{15.8,35.69},{21.96,47.15},{15.61,37.38},{19.11,31.37},{18.13,33.41},{13.64,36.81},{13.49,33.42},{14.76,36.45},{14.8,34.97},{20.45,46.47},{17.72,34.82},{16.04,32.11},{15.94,35.24},{15.46,34.45},{13.73,34.39},{16.97,35.54},{14.99,36.37},{12.89,33.69},{18.56,35.52},{13.3,32.82},{16.12,37},{17.73,37.12},{16.85,35.36},{14.81,37.14},{14.27,33.95},{17.32,35.37},{17.17,36.97},{16.24,32.45},{12.81,36.74},{16.03,31.56},{17.81,36},{14.98,33.56},{12.99,35.31},{15.66,34.35},{13.32,36.09},{17,35.06},{14.95,33.14},{14.36,35.9},{15.26,33.74},{16.04,37.54},{16.03,34.49},{16.19,32.44},{14.22,36.89},{14.52,36.71},{15.99,33.65},{15.59,33.91},{18.2,37.83},{13.74,32.07},{13.78,34.88},{15.94,41.36}}},nil,10,nil,nil,21,nil,nil,0},
[615] = {'Blackrock Tracker',394,394,16,17,0,{[44]={{41.73,11.95},{42.04,14.04},{44.26,13.93},{40.28,16.3},{45.16,23.97},{43.37,17.95},{25.93,14.45},{26.94,13.44},{25.54,16.4},{29.93,14.13},{29.91,12.15},{28.88,17.52},{27.54,16.85},{42.81,23.33},{38.72,17.97},{42.79,21.5},{41.16,17.88},{41.18,19.99},{36.27,15.98},{35.1,13.02},{34.19,14.04},{28.09,10.94},{29.84,9.5},{30.87,9.21},{29.19,11.2},{25.82,14.12}},[46]={{67.01,77.68}}},nil,44,nil,nil,40,nil,nil,0},
[616] = {'Chatter',534,534,16,16,4,{[44]={{48.66,36.81}}},nil,44,nil,nil,22,nil,nil,0},
[619] = {'Defias Conjurer',285,285,15,15,0,nil,{[40]={{{43.7,74.32},{43.85,74.18},{43.91,73.96},{43.9,73.73},{43.9,73.63},{43.91,73.81},{43.9,73.98},{43.84,74.19},{43.69,74.31},{43.51,74.28},{43.44,74.22},{43.17,73.99},{43.09,73.89},{42.94,73.53},{42.82,73.28},{42.73,73.12},{42.65,72.91},{42.75,73.13},{42.85,73.34},{42.96,73.58},{43.05,73.81},{43.1,73.95},{43.19,74.01},{43.42,74.23},{43.47,74.28},{43.54,74.33}}}},0,nil,nil,17,nil,nil,0},
[620] = {'Chicken',1,1,1,1,0,{[10]={{72.73,54.36},{73.6,53.07},{72.68,54.16},{75.78,56.3},{78.16,48.06},{76.4,53.92},{79.94,46.47},{77.1,55.11},{73.79,52.86},{77.87,44.22},{72.6,54.09},{75.6,56.16},{76.37,53.87},{77.29,55.3},{73.58,53.04}},[11]={{25.52,68.72},{17.15,72.15},{16.96,71.72},{25.87,67.88},{21.3,69.81},{25.74,68.02},{27.39,65.77},{20.92,70.11},{21.55,70.5},{26.97,66.98},{17.23,71.66}},[12]={{35.95,60.38},{35.91,60.52},{36.42,59.91},{36.36,60.15},{36.52,59.92},{40.53,64.3},{40.53,64.35},{35.89,60.13},{35.94,60.52},{36.34,59.89},{36.48,59.97},{36.77,59.83},{40.3,64.33},{40.45,64.63},{42.65,66.15},{42.76,66.19},{40.47,64.31},{40.54,64.36},{42.76,65.87},{42.71,66.29},{77.57,66.09},{77.74,66.51},{77.74,66.53},{77.75,66.24},{77.61,65.43},{78.2,66.13},{78.23,66.19},{77.7,65.35},{77.63,66.31},{77.81,66.53},{77.76,66.41},{77.73,66.34},{77.64,65.53},{79.09,67.88},{78.11,66.25},{78.22,65.8},{79.21,67.65},{77.7,65.28},{48.34,86.75},{48.41,86.65},{48.47,86.6},{48.38,86.75},{48.37,86.62},{48.5,86.62},{42.75,66.17},{42.77,66.04}},[15]={{64.13,50.41},{65.09,50.74},{64.43,47.65},{66.55,49.01},{65.64,49.32},{64.01,50.17},{66.59,46.31},{67.7,50.72},{65.53,49.49}},[17]={{54.83,41.12},{54.82,41.24},{54.76,41.26},{66.01,47.29},{66.31,47.38},{65.71,48.07},{65.65,47.15},{54.75,41},{54.81,41.26},{54.8,41.28},{53.32,42.63},{52.85,40.87},{52.25,41.78},{53.51,43.25},{52.57,43.11},{53.41,43.1},{52.63,42.24}},[40]={{45.65,39.63},{45.78,38.81},{49.31,19.77},{49.2,20.39},{45.77,39.2},{55.64,31.47},{49,20.91},{51.48,31.24},{51.68,31.33},{51.51,31.65},{49.74,19.42},{49.88,19.05},{55.89,31.93},{56.31,31.88},{56.37,30.17},{56.27,29.58},{56.1,30.03},{56.04,30.04},{56.09,29.62},{56.25,29.66},{55.64,30.96},{48.75,21.41},{44.75,68.32},{44.81,68.13},{45.12,69.93},{38.22,57},{45.42,69.73},{38.54,56.69},{38.78,56.98},{45.36,69.44},{38.93,56.68}},[44]={{22.42,42.29},{22.38,42.32},{21.01,43.33},{20.71,42.68},{21.14,42.17},{20.71,43.38}},[85]={{53.21,56.03},{61.53,57.23},{37.95,49.3},{58.87,50.17},{37.03,50.41},{38.62,51.61},{52.43,56.24},{58.89,50.51}},[267]={{49.04,71.27}},[495]={{32.2,42.52},{31.52,43.79}},[3524]={{47.4,69.15},{47.87,69.66},{47.14,68.11}},[4714]={{41.94,44.22},{41.96,44.15},{41.88,44.16},{41.94,44.04}}},nil,12,{3861},{3861,13840},31,"AH",nil,2},
[621] = {'Chicken',64,64,1,1,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[622] = {'Goblin Engineer',1200,1347,18,19,1,nil,nil,0,nil,nil,14,nil,nil,0},
[623] = {'Skeletal Miner',300,300,14,14,0,{[40]={{42.11,82.94},{42.46,83.32},{41.99,82.47},{41.23,81.09},{40.87,81.47},{40.55,81.2}}},nil,40,nil,nil,21,nil,nil,0},
[624] = {'Undead Excavator',328,328,14,15,0,{[40]={{40.77,82.51},{41.01,82.75},{41.28,83.21},{42.1,83.41},{41.53,82.57}}},nil,40,nil,nil,21,nil,nil,0},
[625] = {'Undead Dynamiter',300,300,14,15,0,{[40]={{41.74,83.33},{40.71,82.34},{41.75,82.58},{42.29,82.89},{40.86,80.86},{41.04,80.91},{41.5,81.31},{40.66,81.85},{40.55,80.95},{41.81,81.44},{41.64,81.69},{41.91,81.4}}},nil,40,nil,nil,21,nil,nil,0},
[626] = {'Foreman Thistlenettle',394,394,15,15,0,{[40]={{42.22,82.56}}},nil,40,nil,nil,21,nil,nil,0},
[628] = {'Black Ravager',605,605,22,23,0,{[10]={{53.73,65.09},{60.84,59.21},{56.19,61.32},{59.95,57.92},{54.92,62.98},{59.51,61.4},{57.12,62.35},{52.45,63.66},{50.14,61.54},{53.87,60.69},{50.86,60.66},{52.84,59.62},{58.03,57.05},{56.29,58.82},{58.28,59.11},{54.21,57.31},{54.97,59.36},{55.73,57.16},{42.72,78.64},{43.9,76.74},{49.71,61.86},{41.91,66.34},{36.53,63.95},{32.56,61.51},{37.74,66.4},{39.11,66.09},{27.24,61.65},{30.2,62.24},{28.96,62.36},{39.71,58.71},{41.5,61.37},{49.8,61.81},{35.09,63.14},{50.86,60.64},{42.54,66.14},{23.94,63.03},{28.94,68.8},{25.09,65.9},{25.14,75.18},{36.45,63.94},{32.34,62.37},{25.22,72.61},{37.7,66.6},{39.18,65.96},{28.21,74.46},{22.32,76.72},{26.15,68.64},{24.93,78.26},{26.59,77.71},{26.9,75.03},{27.67,72.04},{42.53,78.1},{43.62,76.7},{26.87,64.32},{26.89,62.19},{27.43,67.62},{28.81,65.01},{30.46,62.8},{28.84,62.36},{35.06,63.27},{23.63,63.26},{42.49,66.25}}},nil,10,nil,nil,38,nil,nil,0},
[631] = {'pnagle\'s test dude',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[633] = {'Elaine Carevin',417,417,18,18,0,{[10]={{75.38,48.95}}},nil,10,nil,nil,12,"A",nil,0},
[634] = {'Defias Overseer',1158,1251,17,18,1,nil,nil,0,nil,nil,17,nil,nil,0},
[636] = {'Defias Blackguard',1347,1452,19,19,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[638] = {'Goblin Mercenary',75,80,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[639] = {'Edwin VanCleef',3800,3872,20,20,1,nil,nil,0,nil,nil,17,nil,"Defias Kingpin",0},
[641] = {'Goblin Woodcarver',1200,1347,18,19,1,nil,nil,0,nil,nil,14,nil,nil,0},
[642] = {'Sneed\'s Shredder',3872,3872,20,20,1,nil,nil,0,nil,nil,14,nil,"Lumbermaster",0},
[643] = {'Sneed',2420,2420,20,20,1,nil,nil,0,nil,nil,14,nil,"Lumbermaster",0},
[644] = {'Rhahk\'Zor',4490,4490,19,19,1,nil,nil,0,nil,nil,14,nil,"The Foreman",0},
[645] = {'Cookie',2316,2316,17,17,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,"The Ship's Cook",0},
[646] = {'Mr. Smite',3088,3088,17,17,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,"The Ship's First Mate",0},
[647] = {'Captain Greenskin',2316,2316,17,17,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[648] = {'Bridge Worker Trent',102,102,5,5,0,{[44]={{31.38,44.78},{31.58,44.57}}},nil,44,nil,nil,12,"A",nil,0},
[649] = {'Bridge Worker Dmitri',198,198,10,10,0,{[44]={{31.69,44.86},{31.57,44.18}}},nil,44,nil,nil,12,"A",nil,0},
[650] = {'Bridge Worker Jess',120,120,6,6,0,{[44]={{31.6,44.83},{31.62,44.29}}},nil,44,nil,nil,12,"A",nil,0},
[651] = {'Bridge Worker Daniel',120,120,6,6,0,{[44]={{31.47,44.8},{31.5,44.54}}},nil,44,nil,nil,12,"A",nil,0},
[652] = {'Bridge Worker Matthew',120,120,6,6,0,{[44]={{31.3,44.74},{31.43,44.5}}},nil,44,nil,nil,12,"A",nil,0},
[653] = {'Bridge Worker Alex',120,120,6,6,0,{[44]={{31.23,44.69},{31.5,44.17}}},nil,44,nil,nil,12,"A",nil,0},
[656] = {'Wilder Thistlenettle',484,484,20,20,0,{[1519]={{66.53,43.54}}},nil,1519,nil,{167,168},55,"A",nil,0},
[657] = {'Defias Pirate',1068,1068,16,16,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[658] = {'Sten Stoutarm',0,0,5,5,0,{[6176]={{65.5,43.12}}},nil,6176,{24471},{24471},55,"A",nil,3},
[659] = {'El Pollo Grande',1300,1300,50,50,0,nil,nil,0,nil,nil,14,nil,"The Black Chicken of Death",0},
[660] = {'Bloodscalp Witch Doctor',651,651,25,26,0,{[33]={{20.75,22.8},{19.03,22.71},{18.35,24},{18.84,23.01},{17.91,24.51},{19.62,24.15},{20.14,25.71},{19.89,24.52},{19.84,28.79},{19.37,27.08},{20.94,26.91},{20.29,27.92},{21.63,29.26},{19.62,24.17},{23.27,29.81},{19.47,24.36},{19.89,23.94},{19.29,24.45},{22.01,26.19}}},nil,33,nil,nil,28,nil,nil,0},
[661] = {'Jonathan Carevin',713,713,25,25,0,{[10]={{75.39,49}}},nil,10,nil,{223,1042,1043,26691},12,"A",nil,2},
[663] = {'Calor',484,484,20,20,0,{[10]={{75.33,48.01}}},{[10]={{{75.31,48.07},{75.3,48.05},{75.75,47.57}}}},10,{26688,26689,26690,26691},{173,221,222,26688,26689,26690},12,"A",nil,2},
[664] = {'Benjamin Carevin',55,55,2,2,0,{[10]={{75.31,49.14}}},nil,10,nil,nil,12,"A",nil,0},
[667] = {'Skullsplitter Warrior',750,750,26,27,0,{[33]={{56.89,61.21},{54.4,57.47},{55.89,62},{54.15,61.82},{55.11,58.48},{53.59,61.51},{59.96,55.88},{58.46,56.24},{60.05,55.4},{54.39,60.1}},[5339]={{58.94,41.75}}},nil,33,nil,nil,30,nil,nil,0},
[669] = {'Skullsplitter Hunter',853,853,28,29,0,{[33]={{56.51,68.07},{63.88,69.18},{57.3,67.33},{56.49,66.9},{61.47,67.44},{64.1,68.05},{61.65,70.59},{59.98,71.92},{57.36,71.24},{59.81,71.47},{59.33,72.12},{57.33,70.44},{57.4,71.99},{57.57,70.86},{57.69,71.53},{58.49,74.22},{57.68,73.29},{57.61,69.24},{57.85,70.92},{57.71,70.31},{58.46,71.87}},[5339]={{57.38,41.97},{55.28,41.48},{53.81,41.68}}},nil,33,nil,nil,30,nil,nil,0},
[670] = {'Skullsplitter Witch Doctor',732,732,28,29,0,{[33]={{62.43,65.92},{56.98,67.93},{63.77,70.28},{58.35,68.21},{63.24,67.15},{62.51,69.4},{59.94,72.63},{60.09,70.75},{59.89,72.03},{57.68,70.66},{58.36,70.49}},[5339]={{53.79,43.09}}},nil,33,nil,nil,30,nil,nil,0},
[671] = {'Bloodscalp Headhunter',750,750,25,26,0,{[33]={{22.11,25.52},{22.01,26.19},{21.09,25.7},{19.91,23.94},{18.69,25.54},{21.04,24.53},{19.47,24.36},{22.37,29.17},{23.32,29.78},{21.67,29.16},{21.57,21.45},{21.75,21.59},{21.64,28.33},{21.8,23.23},{23.76,18.99},{20.11,28.8},{20.9,29.37},{19.32,24.04},{18.5,25.44},{21.73,28.2},{21.74,24.72}}},nil,33,nil,nil,28,nil,nil,0},
[672] = {'Skullsplitter Spiritchaser',773,773,28,29,0,{[33]={{63.16,72.84},{62.55,74.53},{61.89,74.08}}},nil,33,nil,nil,30,nil,nil,0},
[674] = {'Venture Co. Strip Miner',853,853,29,29,0,{[5339]={{52.39,46.65},{51.89,47.35},{51.76,47.14},{52.09,45.87},{51.66,46.67},{52.55,45.37},{52.03,45},{52.73,48.59},{52.25,48.03},{52.47,49.76},{52.61,49.68},{52.51,49.58},{52.22,48.66},{51.66,46.97}}},nil,5339,nil,nil,47,nil,nil,0},
[675] = {'Venture Co. Foreman',905,905,28,29,0,{[5339]={{52.64,48.26},{51.52,47.13},{52.56,49.39},{52.28,48.03}}},nil,5339,nil,nil,47,nil,nil,0},
[676] = {'Venture Co. Surveyor',773,773,29,29,0,{[5339]={{52.28,45.2}}},nil,5339,nil,nil,47,nil,nil,0},
[677] = {'Venture Co. Tinkerer',704,704,28,28,0,{[5339]={{52.27,45.2},{52.26,46.24},{52.55,48.5},{52.64,48.28}}},nil,5339,nil,nil,47,nil,nil,0},
[678] = {'Mosh\'Ogg Mauler',905,905,28,29,0,{[33]={{69.32,47.12},{68.31,48.98},{68.58,48.01},{69.56,48.57},{69.06,48.82}}},nil,33,nil,nil,45,nil,nil,0},
[679] = {'Mosh\'Ogg Shaman',732,732,28,29,0,{[33]={{68.51,49.99},{66.75,49.18},{66.48,49.02},{67.51,47.77},{68.49,47.8},{67.74,46.98},{67.37,48.72},{69.68,48.6},{68.89,48.18},{67.76,46.98},{67.52,47.81},{66.85,49.15},{67.38,48.68},{68.35,48.97},{66.47,49.04}}},nil,33,nil,nil,45,nil,nil,0},
[680] = {'Mosh\'Ogg Lord',905,905,28,29,0,{[33]={{69.48,47.05},{67.12,54.06},{67.09,54.26}}},nil,33,nil,nil,45,nil,nil,0},
[681] = {'Young Stranglethorn Tiger',651,651,24,25,0,{[33]={{46.23,23.2},{41.23,25.72},{49.49,33.5},{42.11,26.4},{42.91,25.42},{45.38,24.03},{41.21,23.14},{40.68,24.3},{42,24.24},{44.33,24.78},{44.46,25.7},{43.92,25.84}},[5339]={{45.63,19.41},{46.47,21.44},{47.26,20.84},{49.28,22.51},{48.6,21.75},{48.7,20.34},{48.16,22.35},{45.37,21.52},{49.77,20.36},{45.63,18.78},{47.7,19.99},{43.58,15.51},{43.76,15.13},{43.59,14.22},{47.06,18.03},{48.33,20.86},{49.4,21.1},{45.8,20.94}}},nil,5339,nil,nil,16,nil,nil,0},
[682] = {'Stranglethorn Tiger',699,699,25,26,0,{[33]={{59.64,21.59},{59.9,31.71},{60.86,32.72}},[5339]={{57.03,20.14},{56.82,17.21},{57.32,19.37},{56.75,18.73},{56.2,19.56},{50.67,14.3},{57.44,22.49},{55.89,18.49},{57.38,20.98}}},nil,5339,{186},nil,16,nil,nil,0},
[683] = {'Young Panther',651,651,24,25,0,{[5339]={{47.75,18.63},{46.76,19.42},{48.28,18.83},{47.84,12.81},{46.79,11.8},{49.6,11.26},{53.32,16.62},{52.91,14},{52.79,15.67},{50.88,12.5},{53.28,14.84},{49.95,12.74},{52.29,14.95},{51.35,14.94},{51.92,13.96},{51.78,12.67}}},nil,5339,nil,nil,16,nil,nil,0},
[684] = {'Shadowmaw Panther',750,750,27,27,0,{[33]={{61.7,41.38},{66.58,44.06}},[5339]={{58.13,31.52},{57.34,31.68},{58.06,31.41},{52.85,41.49},{50.25,39.01},{56.75,32.56},{58.98,25.07},{49.72,37.12}}},nil,5339,{192},nil,16,nil,nil,0},
[685] = {'Stranglethorn Raptor',699,699,24,25,0,{[5339]={{34.96,20.45},{35.81,20.17},{35.88,19.71},{38.51,21.73},{38.53,18.68},{37.11,19.79},{38.1,18.57},{38.88,20.07},{38,20.26},{39.09,19.26},{38.09,19.37},{38.52,20.86},{37.5,20.41},{37.62,19.68},{37.49,21.89},{36.38,20.23},{36.69,20.9},{38.41,21.75},{37.67,20.85},{37.61,19.61},{38.13,18.52},{37.42,20.53},{37.07,20.24},{37.93,20.2},{39.09,20.17},{39.06,19.1},{38.45,20.78}}},nil,5339,nil,nil,48,nil,nil,0},
[686] = {'Lashtail Raptor',699,699,25,26,0,{[33]={{35.36,43.69}},[5339]={{49.85,23.27},{49.06,23.8},{41.09,26.31},{46.17,30.29},{46.67,29.45},{48.68,23.4},{41.41,27.12},{47.38,28.73},{44.81,29.63},{46.63,31.08},{47.72,27.83},{45.6,30.81}}},nil,5339,{195},nil,48,nil,nil,0},
[687] = {'Jungle Stalker',750,750,26,27,0,{[33]={{60.01,51.54},{57.58,62.31},{63.18,55.97},{63.14,58.34},{60.84,57.21}},[5339]={{54.99,30.99},{54.82,41.31},{55.87,40.09},{56.35,40.68},{57.52,40.64},{58.06,41.65},{54.4,30.38},{50.97,33.92},{51.29,33.37},{51.25,31.87},{54.83,37.01},{52.75,35.48},{58.51,40.67},{58.42,39.33},{58.84,39.82},{59.46,39.31},{52.42,30.01},{53.32,31.43},{55.34,31.66},{56.04,32.62},{54.86,32.6},{55.29,33.22},{54.31,34.82},{52.71,32.69},{53.78,32.58},{52.35,36.17},{53.34,34.86},{51.73,32.61},{52.26,31.73},{52.9,30.97},{53.96,35.78},{52.42,34.65},{53.4,30.19},{59.38,37.84},{59.36,36.37},{58.83,41.71},{59.44,40.89}}},nil,5339,{196},nil,48,nil,nil,0},
[688] = {'Stone Maw Basilisk',651,651,24,25,0,{[5339]={{41.54,7.11},{47.12,12.59}}},nil,5339,nil,nil,49,nil,nil,0},
[689] = {'Crystal Spine Basilisk',699,699,25,26,0,{[33]={{63.19,22.41},{64.2,21.5},{60.91,20.59},{60.25,22.72},{62.69,23.1},{60.51,23.7},{61.28,22.33},{61.9,22.25},{61.51,23.28}},[5339]={{59.24,19.58},{58.63,20.76},{58.49,19.37},{58.81,17.12},{58.47,18.25},{58.7,18.68},{57.95,17.14},{58.47,16.51}}},nil,33,nil,nil,49,nil,nil,0},
[690] = {'Cold Eye Basilisk',905,905,29,30,0,{[5287]={{44.56,10.41},{42.96,12.87},{41.93,17.51},{47.94,8.84},{42.02,15.18},{47.13,8.7},{42.97,16.37},{43.55,14.87},{43.82,11.39}}},nil,5287,nil,nil,49,nil,nil,0},
[691] = {'Lesser Water Elemental',651,651,25,26,0,{[33]={{19.21,42.5},{19.17,44.19},{23.48,41.85},{21.06,41.58},{22.53,40.22},{21.98,40.28},{20.88,43.46},{19.85,43.76},{22.68,42.49},{22.31,43.5},{21.84,44.11},{22.61,41.45},{20.91,42.77},{21.8,42.64},{20.83,41.38},{20.18,41.38},{20.2,42.84},{19.51,39.11},{18.46,41.63},{20.06,40.23},{21.93,41.47},{20.02,38.89},{18.51,40.1},{19.56,41.16}}},nil,33,nil,nil,91,nil,nil,0},
[693] = {'Secondary Skill Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Trainer",0},
[694] = {'Bloodscalp Axe Thrower',699,699,26,26,0,{[33]={{35.73,33.69},{34.89,36.26},{34.14,38.19},{33.32,35.57},{33.43,35.67}},[5339]={{41.69,23.22}}},nil,33,nil,nil,28,nil,nil,0},
[696] = {'Skullsplitter Axe Thrower',800,800,26,26,0,{[33]={{63.07,66.58},{55.8,57.14},{56.85,63.71},{56.85,58.68},{53.61,62.02},{54.42,60.47},{54.38,60.08},{60.32,56.07}}},nil,33,nil,nil,30,nil,nil,0},
[697] = {'Bloodscalp Shaman',610,610,25,25,0,{[33]={{35.67,37.85},{34.04,36.74},{34.69,39.46},{34.54,35.32}},[5339]={{40.29,21.87}}},nil,33,nil,nil,28,nil,nil,0},
[698] = {'Bloodscalp Tiger',800,800,26,27,0,nil,nil,0,nil,nil,28,nil,nil,0},
[699] = {'Bloodscalp Beastmaster',750,750,26,27,0,{[33]={{23.47,18.59},{27.69,19.65},{27.43,22.09},{23.93,23.31},{31.23,23.18},{29.55,27.01}},[5339]={{40.81,17.45}}},nil,33,nil,nil,28,nil,nil,0},
[700] = {'Bloodscalp Panther',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[701] = {'Bloodscalp Mystic',651,651,26,27,0,{[33]={{23.72,21.18},{24.9,20.38},{26.77,21.9},{26.84,20.16},{25.24,22.47},{25.8,20.8},{25.9,20.67},{28.28,21.9},{29.05,20.08},{28.69,18.69},{29.01,18.69},{27.88,21.05},{31.3,22.68},{23.23,25.49},{24.28,24.22},{24.21,25.11},{24.71,24.52},{24.33,24.67},{23.68,24.17},{22.91,26.06},{24.37,26.01},{24.68,25.16},{26.61,23.63},{27.55,22.88},{26.96,24.74},{27.76,24.62},{27.51,25.01},{27.74,25.49},{27.31,26.3},{28.15,26.12},{23.45,26.38},{27.99,26.45}},[5339]={{40.9,17.66},{39.72,15.76}}},nil,33,nil,nil,28,nil,nil,0},
[702] = {'Bloodscalp Scavenger',699,699,25,26,0,{[33]={{40.6,32.16},{40.26,30.38},{40.22,31.15},{41.65,28.25},{40.38,27.02},{40.59,29.06},{41.23,29.42},{40.87,29.96},{41.24,30.42},{42.19,30.58},{39.77,30.22},{41.33,31.57}}},nil,33,nil,nil,28,nil,nil,0},
[703] = {'General Fangore',898,898,19,19,0,{[44]={{67.54,28.9}}},nil,44,nil,nil,39,nil,nil,0},
[704] = {'Ragged Timber Wolf',0,0,3,3,0,{[6176]={{53.13,59.81},{51.19,64.93},{46.84,60},{48.52,63.53},{32.99,73.69},{34.57,76.42},{36.93,84.35},{40.84,76.15},{58.48,63.9},{43.94,81.68},{51.55,75.55},{54.95,70.88},{59.1,77.73},{61.4,70.08},{71.57,63.73}}},nil,6176,nil,nil,32,"AH",nil,0},
[705] = {'Ragged Young Wolf',0,0,3,3,0,{[6176]={{77.94,27.78},{75.86,33.13},{76.43,38.72},{72.69,31.11},{72,24.62},{57.46,55.73},{57.13,53.88},{56.74,32.32},{50.95,37.86},{43.27,25.95},{44.99,34.32},{49.27,55.69},{47.74,55.54},{26.34,35.57},{27.39,51.02},{25.16,56.22},{23.64,56.77},{36.18,72.68},{45.67,75.06},{50.75,71.24},{56.04,75.47},{60.25,62.64},{61.52,67.68},{63,73.66},{64.04,72.44},{67.3,69.87},{71.84,60.37},{68.79,64.89},{72.36,68.35},{76,65.77},{79.07,61.24},{75.99,51.77},{81.31,58.54},{78.52,57.1},{78.32,43.6},{79.31,25.53},{83.37,30.42}}},nil,6176,nil,nil,32,"AH",nil,0},
[706] = {'Frostmane Troll Whelp',0,0,3,4,0,{[6176]={{17.34,62.74},{18.38,71.08},{21.23,66.65},{20.96,66.48},{22.78,65.38},{22.29,63.77},{20.41,64.62},{20.28,61.25},{23.33,63.6},{21.85,60.2},{24.19,68.19},{23.38,73.3},{28.8,75.1},{27.87,77.83},{30.56,85.16},{31.36,83.89},{30.34,84.95},{31.69,84.21},{30.88,87.03},{28.76,80.64},{29.35,82.59},{30.65,81.86},{30.31,78.65},{31.97,80.85},{35.94,85.78},{33.89,83.94},{44.52,71.9},{46.32,79.25},{49.21,80.62},{49.42,80.58},{51.78,79.06},{48.16,83.82},{46.64,75.29},{49.07,76.22},{53.47,76.51},{55.77,77.6},{70.17,83.54}}},nil,6176,{182},nil,190,"AH",nil,2},
[707] = {'Rockjaw Trogg',42,55,1,2,0,nil,nil,0,nil,nil,36,"AH",nil,0},
[708] = {'Small Crag Boar',0,0,3,3,0,{[6176]={{74.64,30.21},{71.81,49.92},{58.1,60.64},{57.21,49.01},{54.27,66.25},{55.44,40.43},{51.62,52.95},{44.64,39.92},{49.84,25.6},{46.31,32.07},{40.77,28.41},{29.16,46.45},{51.55,60.18},{46.68,56.89},{40.25,66.28},{37.3,44.84},{41.95,45.33},{41.03,39.17},{33.95,28},{17.24,38.6},{19.1,43.78},{29.52,33.54},{26.89,38.89},{23.45,28.71},{19.85,34.53},{20.64,40.97},{20.96,28.73},{33.78,40.3},{31.27,49.21},{35.92,59.43},{27.33,55.12},{17.06,57.23},{16.61,65.96},{19.93,54.28},{30.19,60.8},{26.29,64.47},{25.76,60.87},{18.73,71.42},{23.64,75.57},{33.91,67.08},{31.05,74.98},{37.18,77.69},{64.1,61.08},{76.67,45.14},{76.19,51.64},{79.35,41}}},nil,6176,nil,nil,189,"AH",nil,0},
[709] = {'Mosh\'Ogg Warmonger',853,853,27,28,0,{[33]={{60.55,44.97},{61.59,44.04},{64.07,55.03},{65.46,52.51},{65.96,50.21},{64.28,52.74},{63.43,53.61},{63.03,51.9},{63.13,51.66},{64.38,49.88},{64.14,46.5},{67.07,46.64},{65,47.8},{66.45,54.1},{64.93,53.72}}},nil,33,nil,nil,45,nil,nil,0},
[710] = {'Mosh\'Ogg Spellcrafter',669,669,29,29,0,{[33]={{66.81,52.89},{68.9,48.18},{66.66,52.96},{66.71,53.27},{66.84,53.12},{65.53,53.72},{69.57,48.56},{68.51,47.8},{68.57,48.37}}},nil,33,nil,nil,45,nil,nil,0},
[711] = {'Ardo Dirtpaw',650,650,16,16,0,{[44]={{17.94,18.57}}},nil,44,nil,nil,19,nil,nil,0},
[712] = {'Redridge Thrasher',300,300,14,15,0,{[44]={{25.81,57.65},{18.44,59.8},{16.92,56.15},{16.1,59.97},{17,60.43},{16.13,55.21},{31.56,73.81},{33.51,61.12},{18.74,59.84},{29.66,61.04},{31.53,71.02},{31.85,62.36},{31.05,71.74},{33.77,62.61},{32.28,59.78},{32.34,59.98},{26.71,72.34},{35.12,57.83},{28.31,74.27},{26.7,74.13},{27.72,75.09},{30.23,62.63}}},nil,44,nil,nil,19,nil,nil,0},
[713] = {'Balir Frosthammer',102,102,5,5,0,nil,nil,0,nil,{170},55,"A",nil,0},
[714] = {'Talin Keeneye',102,102,5,5,0,nil,nil,0,nil,{183,233},55,"A",nil,0},
[715] = {'Hemet Nesingwary Jr.',1524,1524,40,40,0,{[33]={{44.02,23.3}}},nil,33,{194,195,196,197,208},{194,195,196,197,208,583,5762,5763},35,"AH",nil,3},
[716] = {'Barnil Stonepot',1753,1753,40,40,0,{[33]={{44.24,22.13}}},nil,33,{583,26269},{338,339,340,341,342,26269,26340,26741},35,"AH",nil,2},
[717] = {'Ajeck Rouack',1753,1753,40,40,0,{[33]={{44.5,22.67}}},nil,33,{185,186,187,188},{185,186,187,188},35,"AH",nil,2},
[718] = {'Sir S. J. Erlgadin',3048,3048,40,40,0,{[33]={{43.73,22.31}}},nil,33,{190,191,192,193},{190,191,192,193},35,"AH",nil,2},
[721] = {'Rabbit',1,1,1,1,0,{[1]={{54.71,38.36},{54.73,37.75},{55.63,36.49},{28.68,69.89},{29.29,70.82},{30.63,71.19},{32.38,69.66},{32.45,71.89},{34.84,68.48},{37.14,72.61},{37.93,72.61},{34.93,69.31},{35.93,72.9},{31.93,74.72},{31.67,74.52},{37.38,74.1},{37.62,70.79},{37.37,70.12},{33.94,72.59},{35.31,74.05},{34.72,74.38},{36.18,71.54},{34.92,71.61},{35.54,68.72},{36.19,69.46},{36.02,69.7},{77.33,17.6},{74.84,14.18},{78.39,27.46},{75.51,15.31},{77.62,23.34},{77.3,17.36},{78.15,27.66},{75.46,15.06},{77.71,22.97}},[10]={{55.44,14.45},{63.73,16.53},{47.86,42.05},{17.79,22.86},{45.64,44.38},{22.07,25.47},{13.52,27.26},{46,40.6},{44.01,38.74},{48.78,40.79},{49.65,44.86},{43.28,18.07},{31.27,23.59},{18.12,22.69},{22.49,25.47},{13.62,27.44},{6.44,36.71},{9.64,29.74},{8.73,30.82},{7.66,29.95},{68.31,16.29},{68.29,16.14},{27.37,25.72},{46.87,16.04},{41.05,18.06},{90.39,11.79},{92.52,16.99}},[11]={{21.29,68.09},{14.63,73.13},{16.72,70.66},{23.35,66.58},{26.55,65.9}},[12]={{41.65,68.94},{56.18,83.77},{73.45,85.16},{42.88,91.02},{27.21,96.15},{37.89,59.21},{38.42,55.48},{30.66,53.21},{36.37,55.7},{34.56,55.35},{32.13,52.27},{33.32,49.11},{41.01,54.62},{35.17,58.38},{34.04,51.73},{36.53,59.3},{30.32,66.73},{40.74,61.31},{37.85,58.55},{38.91,55.25},{34.67,58.54},{36.1,58.52},{35.61,61.66},{30.67,67.29},{20.99,75.91},{31.07,80.51},{26.74,78.57},{21.99,73.42},{24.29,76.02},{21.95,78.75},{27.26,75.27},{33.9,76.7},{28.5,66.83},{29.41,68.62},{26.41,91.3},{32.68,81.28},{28.05,90.92},{26.17,83.3},{27.16,96.84},{31.34,80.75},{40.77,61.51},{37.98,59.4},{26.5,85.79},{39.27,69.45},{40.62,70.59},{44.54,64.92},{27.37,93.9},{27.01,77.77},{24.7,75.66},{41.58,68.96},{33.61,76.23},{35.44,69.22},{52.94,32.42},{44.25,35.14},{52.31,35.97},{51.02,36.58},{46.05,34.1},{46.67,31.91},{50.26,33.2},{58.91,57.29},{44.66,34.92},{52.68,34.84},{44.12,38.07},{50.26,43.25},{43.81,39.88},{52.86,40.45},{48.76,40.16},{49.77,31.98},{40.73,61.33},{49.89,44.3},{49.93,35.16},{37.78,58.38},{51.3,38.87},{51.67,38.79},{48.45,42.93},{44.36,38.71},{50.29,38.44},{43.84,70.77},{39.01,69.48},{44.31,46.44},{48.96,34.42},{50.41,35.26},{40.39,70.61},{44.94,65.42},{61.11,68.45},{54.51,72.74},{41.62,54.94},{38.92,55.24},{58.45,62.63},{51.58,71.83},{59.78,63.51},{62.56,66.84},{58.94,57.37},{61.13,68.31},{68.3,56.44},{67.09,60.41},{65.52,60.13},{70.4,61.83},{59.23,60.84},{62.05,61.04},{60.72,61.25},{63.05,63.22},{64.27,63.89},{62.51,66.77},{68.97,62.61},{68.53,56.41},{79.02,42.49},{79.13,41.37},{79.04,42.05},{79.04,40.41},{73.12,46.45},{72.94,52.07},{82.7,69.67},{84.2,66.87},{80.45,71.43},{86.11,82.25},{87.05,75.61},{87.54,62.74},{85.09,71.04},{83.41,83.73},{87.83,79.41},{86.73,77.83},{72.41,80.01},{73.76,84.54},{60.8,79.26},{56.9,75.04},{55.51,76.02},{56.34,83.69},{36.43,90.3},{62.79,78.45},{54.66,79.63},{72.27,80.79},{53.34,78.5},{67.01,82.04},{47.85,85.55},{54.35,85.89},{67.49,77.99},{69.08,81.32},{73.55,84.91},{41.84,86.96},{69,78.08},{36.06,86.5},{43.91,70.89},{39.26,90.1},{42.39,85.98},{54.11,72.81},{36.44,90.23},{32.24,87.34},{35.88,86.05},{43.77,71.19},{40.71,70.95},{42.38,86.06},{36.13,90.19},{32.95,80.73},{32.6,86.72},{30.98,81.41},{32.5,84.97},{36.08,85.73},{56.34,83.48},{36.32,90.26},{32.75,81.27},{67.05,81.75},{26.44,83.28},{54.45,85.67},{32.57,86.81},{69.25,81.72},{31.19,81.25},{32.35,85.17},{43.83,70.83},{39.22,69.62},{40.7,70.5},{39.92,89.6},{42.43,70.18},{33.9,77.12},{66.77,81.37},{73.72,84.71},{88.94,72.04},{93.19,73.57}},[16]={{36.38,64.67},{52.63,72.34},{32.3,68.88},{26.59,73.15},{24.04,73.98},{30.57,71.57},{30.54,68.59},{29.85,69.98},{33.09,70.31},{13.67,67.86},{10.19,73.45},{15.44,61.71},{15.18,58.59},{14.63,60.68},{11.24,71.82},{11.14,72.84},{15.5,48.06},{13.69,59.63},{15.74,63.88},{27.79,60.34},{25.45,45.95},{28.72,62.95},{32.79,37.45},{31.09,65.76},{26.97,65.16},{17.65,64.74},{17.68,67.65},{13.69,67.72},{28.18,57.47},{26.08,42.45},{14.52,67.29},{18.59,75.24},{20.28,74.81},{35.37,38.77},{45.86,29.8},{32.03,40.33},{19.68,63.66},{24.9,63.41},{36.14,34.86},{12.22,65.63},{20.91,73.64},{27.53,40.07},{21.99,65.22},{29.16,60.85},{38.82,34.39},{28.06,41.41},{14.22,59.51},{34.39,36.36},{31.06,68.44},{30.52,71.58},{32.67,76.05},{28.24,68.71},{30.8,76.09},{29.94,78.12},{29.29,75.77},{24.46,73.9},{34.45,51.75},{27.78,60.21},{50.64,78.55},{38.33,71.44},{28.73,62.08},{31.03,65.98},{40.98,74.41},{53.34,76.18},{27.98,57.31},{32.91,70.57},{31.5,70.79},{38.2,76.46},{52.07,78.27},{36.9,68.24},{37.72,78.01},{47.08,73.62},{29.4,60.88},{52.77,72.5},{43.96,72.66},{30.49,71.87},{32.47,75.87},{30.57,76.03},{27.89,68.09},{30.65,68.58},{38.5,23.85},{41.49,29.84},{52.5,27.53},{32.96,37.54},{51.82,26.17},{35.58,38.74},{46.09,29.85},{43.33,19.58},{39.76,22.85},{32.39,40.49},{47.84,29.64},{36.58,33.69},{40.7,20.78},{38.93,33.82},{28.31,41.46},{36.97,25.05},{44.31,28.08},{33.98,35.26},{49.76,18.58},{38.41,24.18},{49.86,17.02},{37.24,18.55},{45.58,24.48},{45.14,29.95},{43.18,20.17},{49.02,15.65},{40.12,22.73},{51.04,18.04},{40.69,20.78},{45.88,17.69},{60.23,23.39},{52.84,18.59},{44.37,27.71},{49.88,18.56},{41.64,18.76},{64.79,24.43},{76.31,18.18},{76.1,20.07},{68.26,22.76},{62.53,26.18},{75.43,23.4},{64.76,29.64},{60.31,23.46},{25.74,74.97},{25.83,73.97}},[28]={{32.16,60.37},{30.83,54.56},{34.91,63.34},{48.41,40.32},{57.92,64.72},{57.21,64.25},{59.17,59.69},{40.85,54.07},{33.17,56.87},{32.63,71.93},{32.23,71.22},{35.72,63.2},{43.25,54.91},{32.07,60.94},{36.21,67.05},{34.06,75.62},{51.4,51.24},{56.71,51.92},{56.92,51.61}},[40]={{60.3,10.64},{63.8,24.44},{64.68,45.88},{59.97,10.45},{65.17,47.42}},[44]={{30.35,42.45},{28.82,56.78},{32.76,54.34},{32.29,36.56},{35.36,39.76}},[85]={{61.47,38.59},{56.95,36.52},{51.53,53.69},{36.95,63.96},{62.41,58.33},{30.65,64.87},{56.65,59.12},{60.61,32.43},{46.13,58.08},{64.48,33.89},{56.74,58.52}},[130]={{48.99,41.16},{48.84,67.36},{43.21,85.28},{67.64,82.32},{60.06,76.51},{49.87,81.94},{69.4,78.68},{55.23,37.9},{53.4,34.08},{44.12,52.47},{67.65,82.54},{59.71,77},{68.78,79.02},{67.65,82.89}},[141]={{63.21,36.45},{56.94,29.01},{57.67,40.36},{55.1,38.36},{58.85,34.03},{54.54,36.7},{56.1,34.04},{55.02,40.07},{58.16,36.69},{58.66,40.39},{59.94,31.57},{61.19,38.64},{62.24,32.8},{60.39,29.69},{58.78,28.64},{60.28,35.02},{58.14,38.32},{59.99,38.34}},[148]={{40.76,67.4},{40.62,78.45},{63.8,8.3},{40.08,69.56},{39.22,73.38},{41.92,74.1},{44.43,89.82},{60.39,24.57},{40.22,73.84},{46.06,78.38},{40.37,51.78},{44.06,62.27},{45.75,88.48},{43.65,74.14},{41.7,48.74},{42.27,58.55},{43.93,69.94},{45.99,27.01},{42.02,78.53},{43.43,68.22},{48.44,29.44},{42.41,89.04},{39.74,58.09},{62.95,13.3},{47.51,54.01},{41.78,92.06},{43.44,34.55},{44.26,44.01},{59.24,14.29},{62.74,7.01},{40.25,47.01},{57.42,19.77},{44.16,74.63},{62.66,22.18},{44.93,55.25},{51.14,22.82},{43.8,82.37},{45.41,74.78},{45.87,45.39},{42.33,62.6},{41.19,35.89},{46.1,28.88},{45.58,78.02},{62.92,19.38},{48.17,21.17},{44.46,75.61},{49.45,32.92},{49.2,23.18},{48.45,23.13},{44.94,23.81},{44.93,23.26},{56.63,18.53},{57.9,18.34},{58.39,17.18},{63.79,6.57},{42.14,38.61},{45.86,23.45},{48.86,28.56},{61.92,13.56},{47.27,30.99},{48,24.72},{50.09,22.74},{56.17,19.28},{59.23,16.41},{45.92,31.96},{44.73,35.13},{48.46,26.2},{53.57,23.69},{54.87,23.81},{56.12,21.5},{54.83,28.27},{53.19,24.4}},[215]={{49.41,37.92},{60.8,60.78},{50.51,72.57},{33.07,25.29},{62.92,69.46},{40.25,40.78},{53.53,61.07},{65.88,62.04},{53.67,60.49},{49.9,22.41},{49.46,23.09}},[267]={{47.05,73.38},{28.28,68.1},{36.82,77.27},{28.17,62.06},{30.44,60.77},{28.18,62.04},{67.17,31.64}},[357]={{41.75,8.95},{49.58,31.5},{48.93,25.3},{38.25,22.78},{49.76,34.3},{44.67,10.39},{40.13,18.64},{49.11,28.53},{48.74,37.57},{46.11,15.4},{39.37,15.2},{41.61,21.13},{39.17,13.79},{40.26,14.63},{51.71,15.91},{50.56,51.39},{74.35,58.77},{61.46,55.45},{80.25,42.18},{34.47,31.98},{56.46,60.07},{79.13,43.18},{73.53,39.29},{56.06,74.73},{72.95,57.86},{77.77,45.23},{72.3,50.91},{55.23,60.08},{58.42,55.98},{37.47,33.41},{71.32,53.64},{55.47,63.7},{48.76,37.08},{47.05,58.18},{86.8,45.57},{57.09,51.72},{60.17,59.21},{69.23,60.2},{50.42,51.53}},[406]={{73.98,53.99},{64.11,61.89},{71.03,83.22},{60.31,71.35},{61.27,52.94},{60.8,79.48},{60.76,75.95},{69.34,45.98},{74.7,57.12},{63.53,81.99},{68.25,85.91},{71.33,83.84},{73.22,81.8},{48.51,60.4},{36.94,20.2},{51.02,62.33},{49.23,75.49},{38.79,22.29},{44.3,31.64},{41.25,20.85},{63.5,81.36},{71.26,83.69},{60.96,76.13},{44.73,23.3},{72.94,83.54},{80.64,82.74},{50.86,42.19},{41.84,67.06},{75.58,83.29},{66.98,83.31},{60.7,79.42},{78.16,83.5},{80.49,82.67},{67.55,85.63},{64.03,93.94},{38.59,22.52},{38.48,33.57},{41.32,35.86},{33.53,59.57},{32.98,58.86},{39.32,59}},[493]={{34.76,40.77},{48.95,70.63},{54,30.61},{41.32,44.5},{32.87,45.88},{61.99,47.39},{64.27,50.18},{49.43,65.54},{41.55,53.69},{61.49,67.51},{66.19,62.97},{36.09,29.64},{59.1,71.67},{38.73,61.9},{68.94,53.83},{65.31,44.09},{33.94,59.4},{63.35,64.18},{37.77,40.37},{65.43,70.01},{37.65,30.34},{35.58,40.38},{40.93,68.47},{44.42,70.25},{36.59,57.45},{37.16,51.34},{59.54,65.94},{50.86,31.07},{67.3,55.69},{64.04,66.19},{63.88,60.15},{57.49,72.65},{55.42,31.6},{45.03,42.53},{48.75,32.05},{50.97,39.27}},[495]={{71.55,57.08},{72.02,48.19},{76.29,35.25},{31.42,68.7},{32.37,66.14}},[616]={{18.58,33.03},{19.86,37.28},{18.81,38.11},{19.63,37.97},{19.23,34.45},{20.08,38.67},{19.41,35.63},{18.92,36.1},{19.42,37.8},{19.7,38.88},{19.07,39.52},{19.81,36.7},{18.78,38.16},{19.61,37.96},{20.17,38.6},{19.07,35.52},{19.17,36.42},{19.62,37.97},{19.66,38.58},{19.12,39.52}},[796]={{-1,-1}},[1519]={{60.96,79.65},{77.65,35.7},{71.94,28.36},{81.38,64.54},{52.02,81.37},{60.6,79.83},{53.93,91.61},{43.86,35.74},{42.09,32.15},{74.06,7.33},{79.26,9.39},{71.73,28.94},{45.25,33.73},{46.57,35.21},{46.84,37.3},{80.72,10.12},{82.01,14.07},{66.39,17.52},{43.87,78.55},{50.64,87.98},{47.69,88.02},{46.07,87.55},{53.69,15.62},{52.12,81.29},{63.23,3.95},{58.6,27.46},{56.55,11.25},{53.85,20.83},{78.75,9.87},{80.28,10.1},{81.74,14.96}},[2557]={{-1,-1}},[3430]={{34.27,20.98},{35.05,20.64},{35.9,21.77},{36.8,23.86},{36.92,27.29},{37.55,28.81},{33.84,26.2},{32.79,24.67},{30.76,20.85},{38.6,21.96},{37.95,21.59},{53.78,86.21},{60.34,72.52},{53.44,75.92},{56.37,69.38},{63.66,66.56},{68.06,59.16}},[3487]={{87.92,54.47},{87.36,63.76},{88.04,54.35}},[3518]={{46.71,66.87},{43.63,54.47},{43.64,54.6},{32.23,61.53},{36.26,62.6},{40.35,68.31},{40.58,67.85},{40.94,68.56},{40.83,67.95},{41,78.69},{34.55,78.02},{32.72,76.7},{32.35,61.25},{25.75,54.92},{25.64,51.6},{26.79,47.7},{27.46,41.34},{27.32,41.41},{28.53,34.16},{28.24,34.14},{35.65,33.53},{32.94,27.68},{38.2,30.38},{40.06,24.58},{39.99,24.73},{40.14,21.63},{49.61,31.67},{63.68,36.48},{66.09,45.32},{66.55,48.79},{72.27,59.38},{72.4,59.66},{50.44,57.97},{34.93,38.83}},[3522]={{36.72,73.87},{37.94,73.12},{36.91,69.36},{39.63,69.2},{38.84,69.61},{36.81,70},{41.78,68.41},{41.96,65.82}},[3524]={{83,60.94},{57.15,14.78},{51.26,55.34},{73.96,46.7},{83.52,60.78}},[4100]={{-1,-1}},[4395]={{34.63,57.58},{46.43,19.81},{67.48,47.7},{35.6,43.84},{49.37,46.22},{45.89,19.48},{67.53,44.82},{36.42,44.5},{48.59,44.53},{46.28,19.77},{67.66,46.86},{48.8,44.29},{44.93,19.74},{68.44,45.01},{49.53,43.86},{44.83,21.09},{36.33,41.94},{49.11,44.42},{33.45,59.52},{44.6,20.76},{36.09,43.66},{49.16,44.41},{36.39,78.45},{29.98,61.72},{36.8,43.11},{49.09,45.02},{44.71,20.23},{67.84,46.95},{37.86,44.28},{48.2,43.77},{29.21,61.81},{66.97,45.9},{36.74,42.84},{48.48,44.46},{35.85,77.69},{29.88,61.65},{36.8,44.17},{48.79,44.04}}},nil,12,nil,nil,31,"AH",nil,0},
[723] = {'Mosh\'Ogg Butcher',905,905,29,29,0,{[33]={{67.09,54.26},{67.12,54.06}}},nil,33,nil,nil,45,nil,nil,0},
[724] = {'Burly Rockjaw Trogg',55,55,2,2,0,nil,nil,0,nil,nil,36,"AH",nil,0},
[727] = {'Ironforge Mountaineer',656,656,15,15,0,{[1]={{53.27,39.48},{51.9,37.55},{54.29,43.66},{54.76,43.86},{57.26,47.47},{53.12,50.44},{59.22,45.95},{59.92,45.51},{53.65,51.13},{55.12,39.36},{54.12,40.63},{54.64,55.89},{54.09,40.52},{53.26,49.74},{53.64,50.54},{50.45,63.53},{55.13,53.69},{54.04,46.19},{53.08,49.3},{52.43,61.41},{65.12,50.88},{56.71,44.9},{45.03,60.27},{55.57,43.72},{55.26,43.48},{77.34,23.05},{77.68,23.92},{75.82,16.84},{77.87,23.53},{77.24,24.82},{78.39,30.5},{78.89,21.44},{79.07,29.01},{64.4,48.43},{64.46,48.63},{77.56,22.76},{75.85,17.06},{78.69,22.15},{77.82,26.31},{77.64,26.79},{78.7,22.28},{83.8,48.01},{81.73,48.09},{81.73,48.14},{79.03,28.98},{76.91,28.47},{76.92,28.26},{78.23,20.37},{78.11,28.08},{77.36,23.93},{80.39,48.14},{80.38,48.11},{80.38,48.16},{78.1,28.05}},[11]={{27.02,66.73},{27.18,66.2}}},nil,1,nil,nil,57,"A",nil,1},
[728] = {'Bhag\'thera',1706,1706,28,28,0,{[33]={{65.67,43.59}}},nil,33,nil,nil,16,nil,nil,0},
[729] = {'Sin\'Dall',1706,1706,28,28,0,{[5339]={{42.93,21.56}}},nil,5339,nil,nil,16,nil,nil,0},
[730] = {'Tethis',1706,1706,28,28,0,{[5339]={{59.37,37.68}}},nil,5339,nil,nil,48,nil,nil,0},
[731] = {'King Bangalash',905,905,29,29,0,{[5339]={{49.33,37.67}}},nil,5339,nil,nil,16,nil,nil,0},
[732] = {'Murloc Lurker',176,176,9,9,0,{[12]={{85.23,87.31},{81.54,87.22},{76.91,86.43},{77.08,86.06},{75.86,85.94},{79.16,47.39},{78.17,46.76},{78.17,44.65},{79.51,46.31},{77.74,44.28},{78.83,44.53},{79.26,57.97},{78.45,60.19},{79.26,56.87},{77.81,58.04},{79.33,56.7},{77.69,56.28},{78.96,55.27},{78.4,56.81},{77.7,56.87},{78.37,56.06},{79.68,58.16},{79.43,54.96},{78.08,45.34},{78.5,44.9},{84.77,86.87},{83.18,86.94},{86.67,85.89},{79.63,85.16},{81.09,87.09},{80.28,85.37},{88.57,84.1},{79.18,45.4},{91.58,81.75},{89.77,82.43},{78.47,83.4},{78,80.89},{77.78,86.13},{77.07,85.87},{79.49,58.24},{78.29,59.59},{78.27,57.48},{79.24,54.22},{78.75,56.37},{78.47,55.8},{79.3,56.64},{79.32,55.23},{77.25,85.18},{78.26,82.5},{84.9,86.72},{82.92,87.18},{79.38,85.34},{80.79,86.96},{80.19,85.63},{75.95,86.04},{75.85,83.67},{76.46,81.97},{76.91,82.66},{77.58,81.95},{77.72,80.98},{76.57,79.47},{76.95,86.24},{76.29,84.55},{78.16,82.74},{77.05,83.99},{77.78,80.92},{76.74,78.89},{77.08,86.21},{76.29,84.42},{78.42,82.45},{77.01,84.52},{84.85,87.08},{83.39,86.76},{87.09,84.92},{79.55,85.29},{81.04,86.72},{80.27,85.26},{88.66,83.72},{91.87,82.23},{89.79,83.26},{78.43,83.92},{77.12,85.76},{76.32,84.49},{77.16,84.1},{91.87,82.23},{87.03,85.27},{91.78,82.48},{88.74,83.53},{90.14,82.96},{83.43,86.79},{84.88,87.14},{81.47,87.27},{80.18,85.26},{76.88,86.03},{77.56,85.95}}},nil,12,nil,nil,18,nil,nil,0},
[733] = {'Sergeant Yohwa',1524,1524,40,40,0,{[33]={{47.53,10.75}}},nil,33,{26751},{203,204,26751},12,"A",nil,2},
[734] = {'Corporal Bluth',1524,1524,40,40,0,{[33]={{47.44,10.21}}},nil,33,nil,nil,12,"A","Camp Trader",640},
[735] = {'Murloc Streamrunner',120,120,6,7,0,{[12]={{58.29,64.73},{55.45,63.69},{50.1,61.81},{57.13,61.99},{57.27,63.7},{56.37,69.02},{56.21,69.13},{57.54,67.04},{56.24,63.57},{51.71,69.7},{55.19,69.01},{58.13,68.47},{57.23,69.39},{53.5,69.73},{50.73,66.07},{51.57,65.08},{52.98,63.6},{52.33,64.63},{54.24,62.36},{58.3,64.68},{57.15,61.75},{58.48,68.4},{49.74,68.71},{51.64,70.18}}},nil,12,nil,nil,18,nil,nil,0},
[736] = {'Panther',750,750,25,26,0,{[33]={{59.48,21.63},{59.48,21.63}},[5339]={{38.96,14.73},{38.52,14.08},{39.07,13.48},{39.95,13.27},{39.53,14.27},{41.55,14.02},{40.14,14.81},{40.56,12.15},{41.06,13.5},{40.66,14.27},{41.17,14.82},{39.53,17.33},{38.97,16.3},{40.48,15.6},{41.63,15.64},{39.15,18.1},{41.08,17.95},{40,17.93},{41.18,17.13},{39.51,18.71},{39.84,19.41},{40.09,19.32},{41.73,18.85},{41.09,19.59},{39.61,20.04},{39.02,20.79},{40.74,20.08},{41.58,20.19}}},nil,5339,{191},nil,16,nil,nil,0},
[737] = {'Kebok',1220,1220,35,35,0,{[5287]={{40.4,73.46}}},nil,5287,nil,{189,209,213},120,"AH",nil,1},
[738] = {'Private Thorsen',1003,1003,30,30,0,nil,{[33]={{{37.98,3.41},{37.98,3.41},{38.03,3.6},{38.2,3.71},{38.3,3.81},{38.34,4.08},{38.14,4.29},{38.13,4.54},{38.21,4.83},{38.36,4.94},{38.56,4.95},{38.75,5.02},{38.99,5.08},{39.09,5.19},{39.31,5.94},{39.3,6.4},{39.3,6.75},{39.32,7.14},{39.5,7.58},{39.78,8.04},{39.88,8.29},{40.07,8.45},{40.34,8.44},{40.34,8.44},{40.34,8.44},{39.95,8.29},{39.6,7.73},{39.33,7.17},{39.31,6.54},{39.31,5.8},{39.28,5.3},{38.84,5.08},{38.66,5.03},{38.53,5.02},{38.42,5.01},{38.33,4.97},{38.26,4.89},{38.16,4.78},{38.11,4.61},{38.1,4.46},{38.11,4.32},{38.11,4.14},{38.1,3.99},{38.06,3.85},{38.02,3.68},{37.96,3.47},{37.98,3.41}}}},0,nil,{198},11,"A",nil,1},
[739] = {'Brother Nimetz',1753,1753,40,40,0,{[33]={{47.25,11.1}}},nil,33,{26732,26733,26734},{205,206,207,26732,26733,26734},12,"A",nil,2},
[740] = {'Adolescent Whelp',954,992,34,35,0,nil,nil,0,nil,nil,50,nil,nil,0},
[741] = {'Dreaming Whelp',1037,1075,35,36,0,nil,nil,0,nil,nil,50,nil,nil,0},
[742] = {'Green Wyrmkin',1902,1981,41,42,0,nil,nil,0,nil,nil,50,nil,nil,0},
[743] = {'Wyrmkin Dreamwalker',1585,1648,42,43,0,nil,nil,0,nil,nil,50,nil,nil,0},
[744] = {'Green Scalebane',1981,2059,42,43,0,nil,nil,0,nil,nil,50,nil,nil,0},
[745] = {'Scalebane Captain',2059,2138,43,44,0,nil,nil,0,nil,nil,50,nil,nil,0},
[746] = {'Elder Dragonkin',2218,2218,45,45,0,nil,nil,0,nil,nil,50,nil,nil,0},
[747] = {'Marsh Murloc',1902,1981,41,42,0,nil,nil,0,nil,nil,18,nil,nil,0},
[749] = {'Marsh Murkdweller',5000,5000,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[750] = {'Marsh Inkspewer',1981,2059,42,43,0,nil,nil,0,nil,nil,18,nil,nil,0},
[751] = {'Marsh Flesheater',2059,2138,43,44,0,nil,nil,0,nil,nil,18,nil,nil,0},
[752] = {'Marsh Oracle',1711,1774,44,45,0,nil,nil,0,nil,nil,18,nil,nil,0},
[754] = {'Rebel Watchman',2440,2440,35,35,0,{[33]={{47.74,11.24}}},{[33]={{{38.15,3.65},{38.13,3.72},{38.09,3.9},{38.11,4.09},{38.11,4.19},{38.1,4.37},{38.14,4.66},{38.16,4.74},{38.24,4.88},{38.35,4.96},{38.52,5},{38.7,5.03},{38.58,5.01},{38.41,4.96},{38.35,4.94},{38.24,4.86},{38.19,4.8},{38.14,4.63},{38.12,4.35},{38.12,4.16},{38.11,3.97},{38.1,3.87}}}},33,nil,nil,11,"A",nil,0},
[755] = {'Lost One Mudlurker',1279,1342,34,35,0,nil,nil,0,nil,nil,51,nil,nil,0},
[756] = {'Skullsplitter Panther',853,853,28,29,0,nil,nil,0,nil,nil,30,nil,nil,0},
[757] = {'Lost One Fisherman',1403,1469,35,36,0,nil,nil,0,nil,nil,51,nil,nil,0},
[758] = {'Skullsplitter Tiger',138,138,4,4,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[759] = {'Lost One Hunter',2453,2453,53,54,0,{[8]={{55.7,29.03},{64.73,23.74},{60.02,24.27},{57.43,31.66},{63.17,28.2},{62.05,26.91},{62.93,27.11},{61.87,28.08},{62.07,25.87},{60.64,29.6},{58.64,26.88},{56.32,32.65},{56.65,31.73},{58.72,29.06},{58.54,28.09},{57.44,28.08},{57.96,27.37},{55.54,29.77},{64.77,23.13},{57.34,31.69},{63.27,27.88},{62.13,26.98},{62.95,27.12},{61.21,28.3},{62.1,25.94},{60.64,29.62},{58.67,26.79},{56.33,32.79},{58.72,29.53},{58.43,27.96},{57.97,27.45},{60.75,24.13},{57.51,28.15}}},nil,8,nil,nil,51,nil,nil,0},
[760] = {'Lost One Muckdweller',2533,2533,53,54,0,{[8]={{54.78,33.12},{55.77,32.5},{63.69,25.94},{60.47,30.87},{63.8,21.08},{63.03,22.73},{57.39,33.2},{58.34,31.69},{59.99,26.33},{61.09,29.46},{45.93,33.75},{50.15,32.93},{57.54,30.09},{59.37,30.43},{51.91,34.66},{64.12,26.13},{64.14,20.46},{62.92,22.79},{58.31,32.09},{59.46,26.17},{61.2,29.36},{59.3,30.93}}},nil,8,nil,nil,51,nil,nil,0},
[761] = {'Lost One Seer',2330,2330,53,54,0,{[8]={{44.9,36.38},{47.76,30.9},{53.2,31.08},{60.5,25.69},{60.75,24.23},{62.26,24.21},{50.51,34.4},{61.38,26.91},{48.23,34.32},{46.81,38.65},{50.98,31.18},{51.5,36.17},{52.96,34.66},{45.32,36.64},{47.91,30.99},{52.72,30.55},{50.94,34.24},{47.66,33.59},{46.94,38.93},{50.79,31.96},{51.73,36.37},{53.35,35.25}}},nil,8,nil,nil,51,nil,nil,0},
[762] = {'Lost One Riftseeker',1116,1155,37,38,0,nil,nil,0,nil,nil,51,nil,nil,0},
[763] = {'Lost One Chieftain',5228,5228,55,55,4,{[8]={{61.94,25.74}}},nil,8,nil,nil,51,nil,nil,0},
[764] = {'Swampwalker',1305,1357,38,39,0,nil,nil,0,nil,nil,14,nil,nil,0},
[765] = {'Swampwalker Elder',1357,1410,39,40,0,nil,nil,0,nil,nil,14,nil,nil,0},
[766] = {'Tangled Horror',1471,1522,40,41,0,nil,nil,0,nil,nil,14,nil,nil,0},
[767] = {'Swamp Jaguar',1500,1536,36,37,0,nil,nil,0,nil,nil,14,nil,nil,0},
[768] = {'Shadow Panther',1678,1753,39,40,0,{[8]={{67.88,40.92}}},nil,8,nil,nil,14,nil,nil,0},
[769] = {'Deathstrike Tarantula',1829,1902,40,41,0,nil,nil,0,nil,nil,22,nil,nil,0},
[770] = {'Corporal Kaleb',1524,1524,40,40,0,{[33]={{47.1,10.7}}},nil,33,{26740},{622,26765},12,"A",nil,2},
[771] = {'Commander Felstrom',1163,1163,32,32,4,{[10]={{18.69,35.85}}},nil,10,nil,nil,14,nil,nil,0},
[772] = {'Stranglethorn Tigress',955,955,29,30,0,{[5287]={{50.34,15.03},{40.66,27.33},{50.23,12.43},{51.3,14.14},{51.26,11.57},{48.71,14.94},{47.25,17.57},{49.54,13.7}}},nil,5287,nil,nil,16,nil,nil,0},
[773] = {'Krazek',1220,1220,35,35,0,{[33]={{43.6,23.13}}},nil,33,{26763,26765},{201,210,627,1115,1116,26740,26763,26764},120,"AH",nil,3},
[775] = {'Kurzen\'s Agent',1163,1221,32,33,0,nil,nil,0,nil,nil,14,nil,nil,0},
[777] = {'Amy Davenport',484,484,20,20,0,{[44]={{28.18,43.54}}},{[44]={{{29.13,47.34},{28.96,47.43},{29.17,47.46}}}},44,nil,nil,12,"A","Tradeswoman",128},
[780] = {'Skullsplitter Mystic',690,690,26,27,0,{[33]={{61.7,53.83},{61.44,56.23},{60.87,52.38},{62.55,67.55},{53.93,62.04},{54.02,61.22},{56.08,59.84},{59.32,54.75},{53.77,60.25},{60.61,55.34},{54.02,61.23}}},nil,33,nil,nil,30,nil,nil,0},
[781] = {'Skullsplitter Headhunter',905,905,28,29,0,{[33]={{60.17,75.23},{57.92,74.6}}},nil,33,nil,nil,30,nil,nil,0},
[782] = {'Skullsplitter Scout',853,853,28,29,0,{[33]={{58.51,67.27},{57.11,67},{62.73,69.95},{62.23,67.46},{60.28,71.91},{58.36,70.52},{58.91,72.35},{59.65,70.61},{59.25,71.27},{62.69,68.08}},[5339]={{56.24,41.66},{56.28,42.41}}},nil,33,nil,nil,30,nil,nil,0},
[783] = {'Skullsplitter Berserker',853,853,28,29,0,{[33]={{60.81,75.2},{62.25,74.55},{62.63,72.86},{62.83,72.42},{60.78,75.17},{61.33,75.71},{62.64,71.88},{62.55,71.21},{57.76,74.37},{62.88,73.57},{62.38,73.68}}},nil,33,nil,nil,30,nil,nil,0},
[784] = {'Skullsplitter Beastmaster',853,853,28,29,0,{[33]={{59.35,72.45}}},nil,33,nil,nil,30,nil,nil,0},
[785] = {'Skeletal Warder',769,812,28,29,0,nil,nil,0,nil,nil,21,nil,nil,0},
[786] = {'Grelin Whitebeard',0,0,5,5,0,{[6176]={{42.72,62.21}}},nil,6176,{182,218,24490},{182,218,24487},55,"A",nil,3},
[787] = {'Skeletal Healer',684,724,26,27,0,nil,nil,0,nil,nil,21,nil,nil,0},
[789] = {'Kimberly Hiett',484,484,20,20,0,{[44]={{26.46,42.04}}},nil,44,nil,nil,12,"A","Bowyer",4224},
[790] = {'Karen Taylor',573,573,22,22,0,{[44]={{28.84,43.57}}},nil,44,nil,nil,12,"A","Blacksmithing & Mining Supplies",128},
[791] = {'Lindsay Ashlock',484,484,20,20,0,{[44]={{27.88,43.54}}},nil,44,nil,nil,12,"A","General Supplies",640},
[793] = {'Kara Adams',713,713,25,25,0,{[44]={{29.4,42.81}}},nil,44,nil,nil,12,"A","Shield Crafter",4224},
[794] = {'Matt',42,42,1,1,0,{[12]={{47.45,62.25}}},{[12]={{{47.62,62.55},{47.6,62.49},{47.55,62.44},{47.55,62.35},{47.41,62.23},{47.07,62.33},{46.85,62.62},{46.79,62.9},{46.75,63.49},{46.7,63.82},{46.62,64},{46.43,64.12},{46.07,64.15},{45.41,64.04},{44.54,64.05},{44.01,64.31},{43.74,64.49},{43.35,64.55},{42.7,64.5},{42.39,64.61},{42.05,64.5},{41.54,64.09},{41.29,64},{40.98,63.65},{40.49,63.55},{40.1,63.65},{40,64.08},{39.9,64.47},{40.12,63.95},{40.35,63.57},{40.82,63.46},{41.21,63.89},{41.65,64.16},{41.87,64.64},{42.37,64.61},{42.58,64.49},{43.43,64.55},{43.73,64.5},{44.91,63.98},{45.82,64.13},{46.32,64.32},{46.69,64},{46.76,63.6},{46.75,62.98},{46.81,62.7},{47.08,62.32},{47.38,62.23},{47.56,62.34},{47.56,62.43},{47.64,62.5},{47.62,62.55}}}},12,nil,nil,12,"A",nil,0},
[795] = {'Mark',42,42,1,1,0,{[12]={{40.55,64.23}}},nil,12,nil,nil,12,"A",nil,0},
[796] = {'Joshua',42,42,1,1,0,{[12]={{40.52,64.06}}},nil,12,nil,nil,12,"A",nil,0},
[797] = {'Bo',42,42,1,1,0,{[12]={{40.67,64.42}}},{[12]={{{40.32,65.02},{40.79,65.9},{40.96,65.92},{41.41,65.84},{41.56,65.66},{41.47,65.65},{41.45,65.77},{41.52,65.62},{41.51,65.77},{41.41,65.79},{41.43,65.67},{41.53,65.68},{41.42,65.68},{41.48,65.79},{41.4,65.91},{41.36,65.73},{41.4,65.64},{41.51,65.74},{41.54,65.63},{41.42,65.73},{41.32,65.86},{40.73,65.91},{40.4,65.09},{40.52,64.07},{40.46,63.74},{40.54,63.8},{40.55,63.97},{40.35,64.04},{40.31,63.84},{40.45,63.91},{40.64,63.98}}}},12,nil,nil,12,"A",nil,0},
[798] = {'Solomon',42,42,1,1,0,{[12]={{80.92,67.48}}},nil,12,nil,nil,12,"A",nil,0},
[799] = {'Kevin',42,42,1,1,0,{[12]={{80.79,67.33}}},nil,12,nil,nil,12,"A",nil,0},
[800] = {'Kyle',42,42,1,1,0,{[12]={{81.11,67.9}}},nil,12,nil,nil,12,"A",nil,0},
[801] = {'Eric',42,42,1,1,0,{[12]={{81.11,67.66}}},nil,12,nil,nil,12,"A",nil,0},
[802] = {'Jay',42,42,1,1,0,{[12]={{81.13,67.53}}},nil,12,nil,nil,12,"A",nil,0},
[804] = {'Dana',42,42,1,1,0,{[12]={{46.29,61.85}}},nil,12,nil,nil,12,"A",nil,0},
[805] = {'Cameron',42,42,1,1,0,{[12]={{46.15,61.73}}},nil,12,nil,nil,12,"A",nil,0},
[806] = {'John',42,42,1,1,0,{[12]={{46.19,61.95}}},nil,12,nil,nil,12,"A",nil,0},
[807] = {'Lisa',42,42,1,1,0,{[12]={{46.19,62.12}}},nil,12,nil,nil,12,"A",nil,0},
[808] = {'Grik\'nir the Cold',0,0,5,5,0,{[6176]={{69.93,83.87},{68.28,82.76}}},nil,6176,{218},nil,2136,"AH",nil,2},
[810] = {'Aaron',42,42,1,1,0,{[12]={{46.04,62.02}}},nil,12,nil,nil,12,"A",nil,0},
[811] = {'Jose',42,42,1,1,0,{[12]={{46.12,61.9}}},nil,12,nil,nil,12,"A",nil,0},
[812] = {'Alma Jainrose',484,484,20,20,0,{[44]={{21.65,42.09}}},{[44]={{{21.69,45.77},{21.32,45.53}}}},44,nil,nil,12,"A","Herbalism Trainer",81},
[813] = {'Colonel Kurzen',2286,2286,40,40,0,nil,nil,0,nil,nil,46,nil,nil,0},
[814] = {'Sergeant Malthus',1305,1305,38,38,0,nil,nil,0,nil,nil,46,nil,nil,0},
[815] = {'Bookie Herod',992,992,35,35,0,nil,nil,0,nil,nil,46,nil,nil,0},
[818] = {'Mai\'Zoth',1546,1546,29,29,0,{[33]={{70.77,48.48}}},nil,33,nil,nil,45,nil,nil,0},
[819] = {'Servant of Ilgalar',582,622,24,25,0,nil,nil,0,nil,nil,14,nil,nil,0},
[820] = {'Scout Riell',1003,1003,30,30,0,{[40]={{56.67,47.35}}},nil,40,nil,{214},12,"A","The Westfall Brigade",0},
[821] = {'Captain Danuvin',1221,1221,33,33,0,{[40]={{56.46,47.57}}},nil,40,{26287,26288,26365},{102,26287,26288},12,"A","The Westfall Brigade",2},
[822] = {'Young Forest Bear',220,220,8,9,0,{[12]={{22.91,75.72},{22.56,75.45},{25.17,83.66},{25.3,90.1},{28.63,80.39},{59.16,68.1},{63.93,65.23},{60.71,75.4},{68.51,66.57},{69.28,64},{71.43,60.52},{59.45,67.84},{64.69,64.08},{74.97,66.92},{78.03,61.55},{82.18,59.75},{87.53,81.72},{74.65,67.02},{78.37,78.49},{79.69,83.52},{88.63,77.23},{81.15,77.44},{86.07,77.71},{82.98,83.4},{86.84,68.66},{86.69,65.58},{87.8,66.39},{82.18,59.96},{78.79,60.85},{72.83,80.79},{69.93,74.91},{77.84,79.68},{77.43,77.28},{79.39,84.37},{81.45,77.52},{83.01,83.51},{73.73,80.5},{38.91,89.43},{66,77.78},{63.57,79.84},{62.78,77.21},{60.65,75.91},{57.18,76.65},{35.47,88.41},{43.91,79.46},{44.38,76.76},{46.04,84.57},{43.17,90.96},{60.6,79.09},{46.66,81.28},{49.28,81.68},{45.1,75.12},{47.77,75.97},{49.51,74.18},{53.49,84.5},{70.44,74.39},{53.58,75.48},{38.79,89.59},{35.79,89.3},{44.06,80.76},{44.83,78.08},{46.54,81.97},{45.47,75.5},{35.75,88.65},{38.72,89.74},{36.78,88.57},{45.96,85.47},{42.7,90.71},{27.92,81.42},{53.37,84.11},{63.42,79.22},{87.03,82.26},{88.96,77.98}}},nil,12,nil,nil,44,nil,nil,0},
[823] = {'Sergeant Willem',0,0,18,18,0,{[6170]={{35.73,39.79}}},nil,6170,{28791,28792,28793,28794,28795,28796,28797,28817,28818,28819,28820,28821,28822,28823,29081,29083,31144,31145},{28780,28784,28785,28786,28787,28788,28789,28791,28792,28793,28794,28795,28796,28797,29080,29081,31143,31144},12,"A",nil,2},
[824] = {'Defias Digger',356,356,16,16,0,nil,nil,0,nil,nil,17,nil,nil,0},
[826] = {'Watcher Jan',1678,1678,39,39,0,{[10]={{76.93,47.31}}},nil,10,nil,nil,11,"A","The Night Watch",0},
[827] = {'Watcher Mocarski',1604,1604,38,38,0,{[10]={{74.16,51.98},{74.37,51.36}}},nil,10,nil,nil,11,"A","The Night Watch",0},
[828] = {'Watcher Petras',2790,2790,38,38,0,{[10]={{78.56,45.39}}},{[10]={{{81.94,45.72},{80.29,46.11},{79.29,45.4},{78.46,45.39},{77.62,46.24},{77.17,46.5},{76.38,46.54},{77.17,46.5},{77.62,46.24},{78.46,45.39},{79.29,45.4},{80.29,46.11}}}},10,nil,nil,56,"A","The Night Watch",0},
[829] = {'Adlin Pridedrift',0,0,5,5,0,{[6176]={{68.3,40.81}}},nil,6176,nil,nil,55,"A","General Supplies",642},
[830] = {'Sand Crawler',176,176,10,10,0,{[16]={{58.77,85.7},{56.16,90.29},{54.62,90.69},{57.03,88.87},{56.66,78.33},{58.55,78.16},{53.35,91.48},{55.99,74.45},{56.18,77.17}},[40]={{54.29,15.96},{54.48,13.24},{55.04,11.37},{48.8,11.52},{55.01,14.68},{40.15,12.2},{39.41,12.33},{39.63,14.51},{40.22,11.18},{42.18,12.34},{39.26,17.54},{43.18,12.28},{40.97,12.35},{39.46,16.5},{41.1,11.07},{47.28,11.75},{40.65,11.82},{50.37,11.66},{48.71,10.52},{49.86,13.2},{47.84,11.29},{51.42,10.82},{49.63,11.16},{52.28,7.81},{48.64,8.18},{44.96,6.58},{50.97,8.9},{46.04,7.5},{46.9,7.58},{38.94,10.39},{42.44,7.94},{43.49,7.61},{38.25,12.74},{41.22,9.69},{53.87,8.67},{44.39,7.13},{49.58,8.2},{47.91,7.96},{52.95,7.67},{54.85,8.8},{54.29,15.97},{54.44,13.07},{40.12,9.85},{55.11,11.04},{54.18,10.85},{48.89,11.69},{54.91,14.78},{40.14,12.3},{39.56,11.22},{39.41,12.31},{36.94,18.21},{39.6,14.47},{40.33,11.03},{39.84,10.49},{38.92,12},{42.14,12.33},{39.23,17.61},{41.76,9.99},{43.1,12.3},{41.12,12.18},{39.41,16.57},{41.16,11.32},{46.74,10.76},{47.34,11.78},{40.7,11.98},{50.5,11.56},{48.63,10.64},{49.85,12.92},{47.9,11.21},{46.22,11.32},{51.25,10.65},{47.89,10.48},{49.57,11.28},{52.22,10.82}}},nil,40,nil,nil,7,"AH",nil,0},
[831] = {'Sea Crawler',247,247,11,12,0,{[40]={{28.75,40.53},{29.06,41.5},{31.28,30.79},{37.09,19.64},{36.29,19.22},{38.67,8.72},{36.36,15.08},{36.1,16.87},{23.91,70.59},{32.57,86.57},{37.1,93.79},{37.41,12.68},{37.98,13.88},{31.91,21.84},{33.36,20.11},{30.63,15.29},{28.43,80.42},{41.32,8.17},{37.24,11},{23.69,55.48},{25.64,18.24},{38.38,11.51},{26.04,70.84},{31.53,19.15},{26.7,81.83},{25.82,37.96},{23.8,16.27},{38.01,91.95},{28.58,82.37},{33.96,13.11},{22.8,59.56},{25.16,44.72},{26.68,30.47},{33.94,87.51},{24.58,19.44},{26.27,31.31},{25.36,45.91},{30.23,83.85},{24.35,35.25},{37.24,90.42},{39.14,6.47},{25.07,75.88},{24.99,69.41},{25.42,43.63},{26.62,14.89},{23.88,71.88},{23.11,51.06},{43.21,4.52},{25.09,70.93},{23.76,45.07},{28.39,26.01},{44.89,4.84},{25.88,13.26},{33.48,90.98},{23.89,50.93},{34.54,88.1},{24.07,73.65},{32.18,19.8},{30.58,24.45},{47.59,4.83},{27.26,31.66},{29.59,18.97},{35.12,92.26},{24.01,62.2},{25.84,41.17},{25.2,30.98},{33.12,13.86},{37.16,9.05},{26.74,34.95},{26.38,83.9},{24.62,58.35},{23.46,48.06},{24.13,63.76},{36.46,91.68},{24.35,56.2},{26.65,78.81},{23.94,69.18},{25.81,77.13},{32.22,15.05},{23.98,46.97},{23.65,53.22},{24.72,72.35},{24.5,54.95},{25.69,33.44},{23.71,65.56},{29.1,25.23},{44.15,5.95},{32.77,84.82},{25.68,79.45},{35.46,88.85},{27.62,26.77},{30.61,20.44},{48.57,6.17},{30.65,17.58},{28.68,15.1},{33.11,88.96},{25.57,51.12},{26.79,28.22},{40.35,8.82},{25,37.51},{24.54,17.37},{24.89,67.43},{25.13,39.12},{22.39,53.29},{31.76,17.71},{29.6,21.79},{25.61,85.57},{39.3,9.22},{46.75,6.19},{28.21,79.06},{35.43,89.71},{25.39,35},{35.05,12.48},{38.11,6.28},{28.32,88.2},{26.62,33.59},{41.82,5.94},{54.33,5.16},{27.32,21.86},{36.35,12.47},{25.39,59.43},{23.68,67.12},{42.78,5.85},{29.51,89.7},{27.04,32.99},{30.99,84.09},{27.74,78.42},{40.81,5.98},{24.82,43.19},{29.71,23.73},{45.92,5.53},{26.57,87.7},{28.89,84.15},{24.83,41.12},{27.97,83.01},{30.53,23.32},{22.75,55.12},{37.05,13.89},{25.62,29.6},{35.38,10.51},{27.71,19.86},{24.68,63.8},{25.31,61.15},{25.16,62.57},{54.32,7.98},{52.47,6.19},{51.67,5.17},{51.43,6.7},{49.81,6.4},{31.17,28.27},{27.78,50.45},{26.76,51.63},{27.71,44.69},{27.27,45.96},{25.18,53.13},{27.91,45.49},{26.38,55.54},{25.92,52.6},{26.45,56.91},{28.81,55.48},{25.92,54.6},{28.67,40.56},{28.9,41.57},{29.53,30.4},{35.45,15.31},{32.58,23.55},{31.35,25.03},{31.63,22.81},{31.18,31.05},{31.54,23.97},{32.2,22.95},{33.1,22.29},{36.45,17.48},{36.98,19.79},{33.42,23.13},{32.66,21.28},{34.43,23.98},{35.67,18.42},{35.52,18.27},{36.34,19.11}}},nil,40,nil,nil,7,"AH",nil,0},
[832] = {'Unbound Cyclone',273,273,13,14,0,{[40]={{68.95,73.5},{34.23,66.73},{38.29,61.89},{41.97,59.57},{42.01,58.29},{63.04,53.31},{45.62,49.29},{46.69,47.31},{54.89,44.01},{43.16,41.87},{54.36,40.54},{53.96,40.11},{61.1,35.01},{34.35,34.89},{39.21,22.16},{39.57,21.64},{58.02,69.3},{53.56,57.98},{61.11,34.58},{68.99,74.53},{62.86,53.57},{60.83,34.64},{60.15,34.98},{42.01,59.49},{39.98,20.7},{35.47,34.81},{69,74.25},{54.01,40.81},{46.38,49.75},{62.5,51.97},{42.03,41.76},{34.45,49.52},{42.44,59.49},{39.64,23},{36.22,35.05},{38.56,61.74},{68.22,72.96},{46.11,49.31},{33.92,67.76},{42.15,41.61},{33.71,49.23}}},nil,40,nil,nil,7,"AH",nil,0},
[833] = {'Coyote Packleader',247,247,11,12,0,{[40]={{65.77,59.33},{60.73,39.09},{64.23,47.96},{65.87,54.66},{53.5,37.29},{40.07,25.44},{65.97,59.62},{31.35,39.34},{38.29,23.14},{31.69,39.39},{37.85,22.58}}},nil,40,nil,nil,38,nil,nil,0},
[834] = {'Coyote',198,198,10,11,0,{[40]={{66.56,50.56},{67.11,56.01},{67.5,64.76},{69.35,69.15},{68.33,68.86},{68.15,66.14},{66.67,60.93},{69.08,70.14},{59.68,15.29},{59.82,12.38},{63.09,36.76},{61.95,20.69},{38,20.91},{62.73,36.63},{63.15,53.73},{60.65,41.11},{64.91,50.51},{65.96,51.67},{66.5,50.92},{66.15,56.62},{58.43,10.28},{60.85,33.84},{61.85,29.22},{62.16,31.82},{61.55,26.25},{59.96,12.55},{47.79,15.49},{47.73,13.76},{53.85,17.78},{61.94,56.23},{59.77,15.38},{67.34,55.81},{67.46,64.55},{68.43,66.1},{66.78,60.9},{66.77,58.38},{59.14,28.14},{51.21,34.15},{61.86,20.73},{62.08,23.68},{58.84,23.87},{56.1,28.03},{59.67,38.76},{50.17,25.47},{41.5,26.22},{45.96,18.66},{58.92,30.88},{53.96,27.8},{41.18,26.88},{48.16,26.06},{52.71,21.84},{50.4,23.87},{51.38,25.35},{40.65,23.38},{48.4,22.44},{54.34,29.28},{50.99,30.69},{40.88,18.26},{51.08,19.94},{51.49,17.69},{51.59,21.3},{52.91,24.73},{51.3,23.1},{51.79,24.46},{52.68,22.5},{50.18,22.38},{49.68,23.54},{55.15,22.21},{52.71,24.88},{55.25,29.34},{38.32,20.95},{58.77,10.53},{47.8,14.04},{67.46,64.65},{69.34,69.16},{68.28,68.18},{68.28,66.14},{67.09,60.63},{69.3,70.49}}},nil,40,nil,nil,38,nil,nil,0},
[836] = {'Durnan Furcutter',0,0,5,5,0,{[6176]={{61.58,14.58}}},nil,6176,nil,nil,55,"A","Cloth & Leather Armor Merchant",4227},
[837] = {'Branstock Khalder',0,0,5,5,0,{[6176]={{60.71,14.64}}},nil,6176,{24533},{3110,24533},55,"A","Priest Trainer",3},
[840] = {'Watcher Backus',3302,3302,42,42,0,{[10]={{74.68,42.6}}},{[10]={{{74.83,44.22},{74.63,42.1},{74.54,41.1},{74.09,39.88},{73.33,39.16},{72.98,38.79},{72.56,38.36},{72.27,37.49},{72.27,37.25},{72.24,35.61},{72.23,35.51},{72.23,35.29},{72.53,33.67},{73.32,32.53},{73.32,32.53},{72.53,33.67},{72.23,35.29},{72.23,35.51},{72.24,35.61},{72.27,37.25},{72.27,37.49},{72.51,38.31},{72.98,38.79},{73.33,39.16},{74.09,39.88},{74.54,41.1},{74.63,42.1},{74.83,44.22}}}},10,nil,{1243,1244},56,"A","The Night Watch",0},
[841] = {'Harl Cutter',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Woodcrafting Supplies",0},
[842] = {'Lumberjack',102,102,5,5,0,{[40]={{53.58,53.36},{53.16,52.29},{52.93,51.9},{53.03,51.34},{53.03,51.34},{54.53,53.14},{53.58,53.37},{52.47,52.15}}},nil,40,nil,nil,12,"A",nil,0},
[843] = {'Gina MacGregor',328,328,15,15,0,{[40]={{57.6,53.99}}},nil,40,nil,nil,12,"A","Trade Supplies",128},
[844] = {'Antonio Perelli',1342,1342,35,35,0,{[10]={{72.22,37.11}},[40]={{57.36,52.18}}},{[40]={{{62.31,17.29},{61.55,18.25},{60.85,18.85},{60.31,19.24},{59.63,20.16},{59.19,20.27},{58.67,20.31},{58.09,21.01},{58,21.53},{57.99,22.11},{57.69,23.25},{57.54,23.59},{57.49,24.27},{57.64,25.03},{58.01,26.25},{58.15,27.09},{57.86,27.79},{57.5,28.53},{57.39,29.05},{57.5,29.64},{57.7,30.11},{57.9,30.64},{57.91,31.66},{58.01,33.13},{58.01,34},{57.79,35.09},{57.8,36.41},{57.94,36.9},{58.39,37.48},{58.64,38},{58.54,38.94},{58.23,39.93},{58.16,41.85},{57.81,42.94},{57.82,43.5},{58.09,44.22},{58.94,45.95},{58.92,47.55},{58.51,49.25},{58.19,50.24},{57.54,52.37},{57.43,53.04},{57.61,53.65},{57.59,53.85},{57.33,53.96},{56.86,54.04},{56.51,53.74},{55.75,52.9},{55,52.79},{54.68,52.43},{53.49,52.87},{53.08,53.22},{53,53.36},{52.9,53.53},{53,53.36},{53.05,53.27},{53.51,52.87},{54.63,52.44},{55.02,52.81},{55.72,52.92},{56.74,54.04},{56.61,56.06},{56.93,57.3},{57.12,57.96},{57.13,60.31},{57.37,61.3},{57.45,62.73},{57.49,63.67},{57.67,64.41},{57.81,65.1},{58.46,65.98},{59.1,66.36},{59.43,66.37},{59.78,65.9},{60.29,64.99},{60.81,64.84},{61.43,65.04},{61.89,65.42},{62.45,65.51},{62.92,65.37},{63.51,64.91},{64.27,63.96},{64.87,63.37},{67.08,62.85}}},[10]={{{7.58,63.81},{8.97,63.76},{10.43,63.3},{12.32,62.45},{13.79,61.68},{15.64,61.25},{17.55,61.03},{19.04,60.9},{19.98,60.54},{21.29,60.25},{23.1,59.64},{23.81,59.24},{24.7,58.62},{25.76,57.77},{26.33,57.6},{27.56,57.61},{28.1,57.7},{29.29,58.3},{30.75,59.22},{31.98,59.75},{33.39,60.38},{35.16,61.37},{35.72,61.64},{36.43,61.99},{36.89,62.19},{37.62,62.5},{38.85,62.96},{40.15,63.32},{41.27,63.74},{42.29,64.32},{43.13,64.85},{43.51,65.08},{44.59,65.91},{45.87,65.99},{46.87,66.02},{47.89,66.27},{49.46,66.36},{50.21,66.52},{51.13,66.86},{52.03,67.5},{52.94,68.52},{54.01,69.03},{54.86,68.91},{56.01,67.74},{57.31,66.63},{58.29,65.66},{59.96,63.2},{61.06,62.14},{62.06,61.41},{63.19,60.73},{64.71,60.07},{65.64,60.09},{66.72,60.6},{67.66,60.61},{68.99,60.53},{69.8,60.18},{70.58,59.57},{72.18,59.1},{73.05,58.21},{74,56.41},{74.79,54.36},{75.06,53.01},{75.03,51.89},{74.6,49.24},{74.48,48.2},{74.16,47.64},{73.79,47.01},{73.83,46.12},{73.82,45.56},{74.1,45.46},{74.02,45.14},{74.01,44.87},{73.98,44.5},{73.99,44.74},{74.02,45.13},{74.1,45.47},{73.81,45.53},{73.84,46.2},{74.46,46.71},{74.87,46.43},{74.81,44.55},{74.62,41.72},{74.16,40.05},{73.72,39.47},{72.85,38.8},{72.45,38.11},{72.22,37.3},{72.2,35.42},{72.52,33.95},{73.29,32.47},{73.6,31.21},{73.65,29.15},{73.58,28.21},{73.33,26.72},{73.39,25.07},{73.78,23.81},{74.39,22.91},{74.99,22.64},{75.87,21.84},{77.77,20.66},{78.57,20.46},{79.63,20.34},{81.62,19.99},{82.41,20.35},{83.38,20.41},{85.32,20.31},{85.97,19.86},{86.66,19.39},{87.64,18.05},{88.22,16.99},{89.45,16.02},{90.83,14.91},{92.62,13.04},{93.69,11.62}}},[12]={{{78.12,72.96},{77.74,72.69},{76.81,72.41},{75.5,72.34},{74.77,72.44},{74.61,72.46},{74.33,72.5},{73.94,72.56},{73.21,72.66},{72.63,72.64},{72.1,72.3},{70.94,71.1},{69.88,70.89},{69.14,71.28},{68.01,72.79},{67.15,73.8},{66.81,73.93},{65.6,74.1},{65.12,74.06},{63.69,73.6},{63.16,73.35},{62.73,72.97},{62.21,72.7},{61.09,72.63},{60.01,72.41},{59.05,71.71},{58.39,71.29},{57.81,71.31},{56.61,72.18},{55.87,72.48},{54.33,72.64},{53.02,72.56},{52.59,72.43},{51.94,72.21},{50.98,71.78},{50.3,71.46},{48.93,70.57},{48.27,69.84},{47.69,69.6},{46.31,69.48},{45.29,69.12},{44.01,68.14},{42.97,67.43},{42.58,66.99},{42.42,66.47},{42.48,65.84},{42.71,65.63},{43.19,65.71},{43.18,66},{43.36,66.01},{43.5,66.02},{43.68,66.06},{43.79,65.97},{43.7,66.07},{43.55,66.03},{43.37,66.01},{43.2,66.04},{43.19,65.71},{42.77,65.62},{42.5,65.74},{42.25,66.75},{41.94,66.87},{40.88,66.63},{39.68,66.63},{38.97,66.76},{38.11,67.54},{37.45,68.45},{37.11,69.26},{37.02,71.75},{36.86,73.91},{36.44,74.95},{35.87,75.82},{34.98,76.79},{33.95,77.64},{32.61,78.34},{31.53,78.51},{30.28,78.19},{29.42,78.02},{28.71,77.92},{28.26,77.85},{26.85,77.76},{25.17,78.48},{24.65,78.63},{23.84,78.52},{23.27,78.31},{22.46,78.39},{21.4,79.01},{20.79,79.7}}},[44]={{{6.45,91.31},{7.13,89.38},{8.36,88.2},{9.73,86.45},{10.67,83.94},{11.99,81.53},{13.32,80.11},{14.2,79.05},{14.78,77.43},{15.14,75},{15.49,72.45},{16.65,70.55},{17.81,69.21},{18.9,69.37},{20.14,70.12},{22.41,69.9},{22.77,70.33},{23.12,72.11},{23.71,72.86},{24.48,72.39},{26.19,69.78},{27.21,68.91},{28.69,68.02},{29.19,67.58},{29.73,67.01},{31.14,64.97},{31.7,63.55},{32.38,59.53},{32.45,57.32},{32.59,54.72},{32.71,51.66},{32.8,49.44},{32.6,48.38},{31.44,48.11},{30.97,48.1},{29.37,48.02},{29.12,47.63},{28.58,47.62},{27.8,46.98},{26.83,46.97},{26.62,46.42},{26.62,45.8},{27,45.75},{26.93,45.34},{26.92,44.99},{26.91,44.55},{26.85,44.27},{26.91,44.53},{26.92,44.92},{26.92,45.32},{26.99,45.74},{26.62,45.8},{26.61,46.56},{27.01,47.15},{27.97,47.21},{28.58,47.64},{30.92,48.13},{31.96,48.21},{32.57,48.32},{32.84,49.4},{32.71,51.66},{32.56,54.49},{32.41,57.24},{32.24,59.48},{31.85,62.22},{31.13,64.68},{29.52,67.02},{29.23,67.33},{28.75,67.73},{26.65,69.11},{25.76,70.19},{24.21,72.49},{23.73,72.59},{23.39,72.21},{22.85,70.28},{22.39,69.73},{20.17,69.91},{18.57,69.12},{17.65,69.09},{15.7,69.67},{13.14,71.06},{11.98,71.79},{10.34,71.95},{8.61,71.62},{7.88,71.55}}}},10,nil,nil,12,"A","Traveling Salesman",128},
[846] = {'Rotten Ghoul',198,198,10,11,0,{[40]={{41.63,29.33},{41.72,29.25},{57.11,80.64},{56.97,80.39},{40.26,67.9},{40.24,67.29},{39.85,67.46},{40.17,67.34},{40.45,66.9},{40.55,67.69},{39.69,67.69},{40.17,68.28}}},nil,40,nil,nil,21,nil,nil,0},
[847] = {'Nathan',102,102,5,5,0,{[44]={{28.57,46.03}}},nil,44,nil,nil,35,"AH",nil,0},
[848] = {'Madison',102,102,5,5,0,{[44]={{28.15,47.47}}},{[44]={{{29.08,51.98},{29.34,49.28},{27.86,48.9},{25.74,47.46},{25.3,46.7},{24.67,46.35},{22.49,46.04},{21.87,46.47},{20.41,46.42},{21.29,46.5},{22.41,46.02},{24.14,46.05},{26.14,46.95},{28.12,46.97},{28.59,47.96},{29.47,48.71},{29.37,51.05}}}},44,nil,nil,35,"AH",nil,0},
[849] = {'Rachel',71,71,3,3,0,{[44]={{28.57,46.1}}},{[44]={{{29.19,47.44},{29.19,47.44},{29.44,48.89},{29.59,50.16},{29.6,50.83},{29.6,51.15},{29.48,52.16},{29.31,52.89},{28.86,53.04},{28.41,53.1},{28.37,52.63},{29,52.83},{29.45,52.42},{29.48,52.18},{29.5,51.56},{29.46,50.23},{29.42,49.84},{29.19,49.28},{28.44,49.07},{28.25,49.03},{27.65,48.58},{26.43,47.87},{25.93,47.59},{25.84,47.2},{25.73,45.87},{25.66,45.07},{25.83,44.45},{25.97,43.95},{26.05,43.3},{26.04,43.13},{26,42.63},{26.07,42.54},{26.76,42.03},{26.86,42.01},{27.65,41.85},{27.74,41.84},{28.86,42.33},{28.94,42.41},{28.61,42.73},{28.53,42.75},{27.94,43.41},{27.9,43.51},{27.79,44.01},{27.79,44.12},{27.79,44.64},{27.8,45.35},{27.8,45.46},{27.82,46.12},{28.32,47.05},{28.36,47.12},{28.75,47.45},{29.16,47.64}}}},44,nil,nil,35,"AH",nil,0},
[850] = {'Erin',102,102,5,5,0,{[44]={{26.5,44.62}}},{[44]={{{24.82,41.39},{24.32,42.65},{23.94,43.73},{23.9,44.61},{23.71,45.58},{24.2,46.1},{25.4,46.6},{26.21,47.04},{26.58,46.92},{26.63,45.85},{26.8,45.76},{26.93,44.47},{26.77,44.3},{26.57,44.29},{26.57,44.29},{26.9,44.44},{26.92,45.37},{27.04,45.72},{26.66,45.78},{26.61,46.53},{26.15,47.06},{25.37,46.69},{24.95,46.84},{24.7,47.38},{25,46.74},{25.65,46.37},{26.03,46.52},{26.6,46.92},{27.09,48.08},{27.04,48.55},{26.61,50.76},{26.75,50.11},{27.05,48.57},{27.02,47.41},{26.21,46.79},{25.3,46.25},{24.17,46.07},{23.7,45.49},{23.92,44.53},{23.93,43.66},{24.02,43.08},{24.82,41.39}}}},44,nil,nil,12,"A",nil,0},
[851] = {'Hannah',102,102,5,5,0,{[44]={{21.61,42.26}}},nil,44,nil,nil,12,"A",nil,0},
[852] = {'Feral Spirit',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[853] = {'Coldridge Mountaineer',0,0,90,90,1,{[6176]={{69.72,46.44},{69.22,46.18},{69.17,46.22},{69.12,46.29},{62.92,23.7},{62.51,34.27},{60.53,42.25},{60.73,32.33},{61.71,27.45},{60.98,19.27},{60.16,23.1},{88.47,43.85},{87.7,40.87},{88.34,40.95},{89.31,42.13},{89.02,41.56}}},nil,6176,nil,nil,57,"A",nil,0},
[854] = {'Young Jungle Stalker',1469,1536,36,37,0,nil,nil,0,nil,nil,48,nil,nil,0},
[855] = {'Young Stranglethorn Raptor',1050,1107,30,31,0,nil,nil,0,nil,nil,48,nil,nil,0},
[856] = {'Young Lashtail Raptor',1221,1279,33,34,0,nil,nil,0,nil,nil,48,nil,nil,0},
[857] = {'Donal Osgood',3874500,3874500,85,85,1,{[1537]={{69.89,88.9}}},nil,1537,nil,nil,1577,"A","Arathi Basin Battlemaster",1048577},
[858] = {'Sorrow Spinner',2533,2533,54,55,0,{[8]={{65.74,66.76},{60.14,59.45},{61.55,60.95},{65.29,70.97},{33.39,52.41},{31.85,54.26},{45.1,46.62},{38.86,47.28},{39.75,33.67},{30.7,48.97},{43.44,46.96},{35.79,44.96},{41.48,46.88},{42.14,33.51},{38.68,41.39},{45.49,43.67},{41.5,41.34},{41.91,38.01},{40.09,39.15},{31.23,45.57},{31.84,46.92},{29.1,50.86},{25.05,44.08},{32.1,54.09},{36.46,38.1},{41.37,48.9},{40.05,48.39},{46.59,44.81},{61.81,61.08},{68.76,69.21},{69.43,68.26},{65.91,66.78},{65.58,71.24},{60.07,58.73},{45.27,46.55},{33.08,52.25},{38.29,48.2},{42.66,47.85},{36.22,45.51},{41.47,46.96},{39.19,41.3},{45.45,43.96},{41.54,41.39},{41.76,39},{40.06,39.53},{31.12,44.86},{31.67,47.14},{29.6,50.38},{34.88,49.85},{25.15,44.93},{31.62,52.89},{35.7,52.91},{41.43,48.92},{40.15,48.37},{46.86,44.32},{68.71,65.93},{30.89,49.18},{29.05,50.47},{32.17,54.14},{42.88,46.71},{25.21,45.05}}},nil,8,nil,nil,22,nil,nil,0},
[859] = {'Guard Berton',2220,2220,33,33,0,{[44]={{25.76,42.91}}},nil,44,nil,{386},11,"A",nil,0},
[860] = {'Pet Wolf',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[861] = {'Stonard Scout',1469,1536,36,37,0,nil,nil,0,nil,nil,29,"H",nil,0},
[862] = {'Stonard Explorer',1536,1604,37,38,0,nil,nil,0,nil,nil,125,"H",nil,0},
[863] = {'Stonard Hunter',2980,2980,50,51,0,{[8]={{80.36,77.8},{81.06,78.11},{79.79,79.35},{80.81,79.27},{79.68,78.37}}},nil,8,nil,nil,125,"H",nil,0},
[864] = {'Stonard Orc',2769,2769,50,50,0,{[8]={{49.86,57.87},{46.45,54.82},{44.95,56.09},{48.9,52.11},{45.04,53.93},{46.28,55.28},{46.27,55.67}}},{[8]={{{44.42,54.9},{44.37,54.75},{44.2,54.94},{44.23,55.13},{44.32,55.27},{44.42,55.32},{44.42,55.42},{43.24,55.11},{43.05,55.53},{42.97,55.71},{42.98,55.64},{43.18,55.56},{43.55,54.98},{44.32,54.65}}}},8,nil,nil,125,"H",nil,0},
[865] = {'Stonard Wayfinder',2880,2980,50,51,0,nil,nil,0,nil,nil,125,"H",nil,0},
[866] = {'Stonard Grunt',6104,6104,60,60,0,{[8]={{45.24,54.87},{45.3,55.84},{50.33,53.17},{43.68,57.63},{49.56,58.23},{49.17,58.51},{21.11,52.17},{21.41,51.2},{21.24,51.94},{44.04,58.03},{43.78,52.97},{21.33,51.69},{50.33,53.15},{46.26,50.34},{46.69,49.94},{48.61,50.89},{43.47,55.75},{43.95,52.83},{21.17,51.88},{21.08,52.23},{50.36,52.02},{49.66,50.49}}},nil,8,nil,nil,85,"H",nil,0},
[867] = {'Stonard Cartographer',3082,3082,52,52,0,nil,nil,0,nil,nil,125,"H",nil,0},
[868] = {'Stonard Shaman',2551,2551,53,53,0,{[8]={{80.34,79.01}}},nil,8,nil,nil,125,"H",nil,0},
[869] = {'Protector Dorana',1910,1910,30,30,0,{[40]={{58.55,37.7}}},{[40]={{{57.14,53.26},{57.59,52.29},{57.96,51.17},{58.31,49.91},{58.71,48.55},{58.97,47.15},{58.94,45.72},{58.13,44.28},{57.77,43.31},{57.83,42.87},{58.07,42.29},{58.17,41.46},{58.23,40.01},{58.6,38.58},{58.65,37.95},{58.46,37.45},{58.09,37.18},{57.91,36.9},{57.73,35.74},{57.78,34.97},{57.92,34.29},{58.05,33.86},{58,32.86},{57.89,31.44},{57.9,30.72},{57.64,30.01},{57.9,30.72},{57.89,31.44},{58,32.86},{58.05,33.86},{57.92,34.29},{57.78,34.97},{57.73,35.74},{57.91,36.9},{58.09,37.18},{58.46,37.45},{58.65,37.95},{58.6,38.58},{58.23,40.01},{58.17,41.46},{58.07,42.29},{57.83,42.87},{57.77,43.31},{58.13,44.28},{58.94,45.72},{58.97,47.15},{58.71,48.55},{58.31,49.91},{57.96,51.17},{57.59,52.29},{57.14,53.26},{57.27,53.46}}}},40,nil,nil,11,"A","The Westfall Brigade",0},
[870] = {'Protector Deni',1910,1910,30,30,0,{[40]={{54.86,54.01}}},nil,40,nil,nil,11,"A","The Westfall Brigade",0},
[871] = {'Saltscale Warrior',699,699,25,26,0,{[33]={{27.77,52.23},{27.85,51.58}}},nil,33,nil,nil,18,nil,nil,0},
[873] = {'Saltscale Oracle',651,651,25,26,0,{[33]={{27.5,42.76},{26.13,43.36},{26.53,42.89}}},nil,33,nil,nil,18,nil,nil,0},
[874] = {'Protector Korelor',1910,1910,30,30,0,{[40]={{56.33,53.58},{61.29,64.98}}},{[40]={{{55.56,52.89},{56,53.18},{56.51,53.79},{56.79,54.15},{56.66,55.71},{56.69,56.56},{56.85,57.11},{57.09,57.72},{57.13,58.66},{57.09,59.73},{57.34,61.43},{57.43,62.76},{57.63,64.23},{57.81,65.13},{58.54,66.11},{59.31,66.39},{59.5,66.29},{60.43,64.91},{61.37,64.98},{61.84,65.41},{62.4,65.54},{63.33,65.13},{63.97,64.32},{64.78,63.44},{65.25,63.3},{66.2,63.07},{67.18,62.87},{66.2,63.07},{65.25,63.3},{64.78,63.44},{63.97,64.32},{63.33,65.13},{62.4,65.54},{61.84,65.41},{61.37,64.98},{60.43,64.91},{59.5,66.29},{59.31,66.39},{58.54,66.11},{57.81,65.13},{57.63,64.23},{57.43,62.76},{57.34,61.43},{57.09,59.74},{57.13,58.66},{57.09,57.72},{56.85,57.11},{56.69,56.56},{56.66,55.71},{56.79,54.15},{56.51,53.79},{56,53.18},{55.56,52.89},{55.17,52.89}}}},40,nil,nil,11,"A","The Westfall Brigade",0},
[875] = {'Saltscale Tide Lord',651,651,26,27,0,{[33]={{26.63,44.42}}},nil,33,nil,nil,18,nil,nil,0},
[876] = {'Protector Leick',1910,1910,30,30,0,{[40]={{54.82,53.19}}},nil,40,nil,nil,11,"A","The Westfall Brigade",0},
[877] = {'Saltscale Forager',699,699,25,26,0,{[33]={{28.11,52.22},{27,53.76},{27.62,52.24},{27.42,49.11},{28.02,51.15}}},nil,33,nil,nil,18,nil,nil,0},
[878] = {'Scout Galiaan',1003,1003,30,30,0,{[40]={{56.39,47.34}}},nil,40,{26371},{153},12,"A","The Westfall Brigade",2},
[879] = {'Saltscale Hunter',699,699,25,26,0,{[33]={{27.26,52.63},{27.55,51.35}}},nil,33,nil,nil,18,nil,nil,0},
[880] = {'Erlan Drudgemoor',156,156,8,8,0,{[12]={{71.09,80.65}}},nil,12,nil,nil,17,nil,nil,0},
[881] = {'Surena Caledon',160,160,9,9,0,{[12]={{70.95,80.63}}},nil,12,nil,nil,17,nil,nil,0},
[882] = {'Bone Caster',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[883] = {'Deer',100,100,5,5,0,{[12]={{36.31,55.54},{40.14,57.02},{30.97,58.33},{36.88,56.01},{35.59,77.84},{40.03,56.96},{35.81,66.29},{34.94,77.16},{30.47,81.03},{30.65,88.88},{25.03,82.84},{35.72,78.23},{30.63,80.62},{39.55,68.99},{36.42,66.51},{42.49,69.55},{46.83,32.87},{43.89,40.53},{61.01,57.22},{52.33,36.84},{37.4,54.26},{40.58,56.91},{44.51,38.25},{39.33,69.02},{44.58,67.04},{60.42,57.6},{76.58,71.11},{76.96,70.84},{80.83,63.76},{76.83,70.66},{76.77,70.64},{80.42,58.1},{77.56,71.5},{70.79,82.95},{50.02,75.2},{52.88,83.61},{51.52,78.24},{54.16,77.47},{46.05,80.89},{35.67,87.86},{54.14,79.59},{54.15,79.44},{45.36,87.02},{36.8,80.61},{46.43,79.24},{37.97,88.54},{46.55,80.28},{35.07,79.05},{35.26,87.86},{36.46,81.38},{46.72,79.36},{37.52,88.57},{30.55,88.66},{35.29,78.13},{35.31,87.99},{31.24,80.49},{36.81,81.36},{30.55,88.65},{53,84.74},{35.55,77.84},{34.99,88.71},{30.83,80.67},{45.75,86.8},{38.81,69.13},{36.22,80.34},{37.82,88.64},{42.01,69.74},{36.99,66.8},{70.81,82.82}},[28]={{30.96,55.34},{35.1,64.79},{48.66,39.31},{43.74,83.27},{53.68,50.26},{53.65,47.57},{57.07,52.13},{50.55,47.89},{56.66,51.25},{56.88,51.47},{47.15,47.34}},[40]={{59.87,21.6}},[47]={{65.16,25.79},{59.54,49.08},{29.37,57.18},{78.35,58.67},{76.09,65.47},{59.47,30.11},{41.44,50.99},{24.95,60.33},{54.11,34.65},{61.24,56.73},{59.91,31.9},{59.68,46.33},{61.98,43.37},{33.68,45.75},{56.14,35.58},{75.45,84.49},{64.81,31.96},{67.09,45.71},{46.84,51.37},{75.61,83.1},{62.37,18.39},{54.17,52.39},{46.32,45.25},{67.29,29.12},{26.11,56.96},{34.7,62.37},{49.55,41.52},{33.29,43.25},{13.55,52.42},{27.57,66.65},{17.58,53.94},{42.37,56.73},{14.78,50.39},{58.9,48.18},{13.53,52.68},{52.27,41.43},{51.75,62.14},{51.45,59.5},{68.74,43.87},{37.13,49.85},{35.57,51.11},{15.14,54.11},{39.08,56.97},{19.97,55.28},{77.57,51.18},{36.69,49.29},{35.2,44.69},{52.11,41.25},{43.44,44.37},{50.72,42.35},{74,50.76},{73.9,55.67},{71.93,57.29},{24.19,35.8},{22.02,50.82},{19.61,48.19}},[130]={{62.97,74.73},{49.6,75.34},{67.93,84.67},{64.86,75.24},{48.68,78.59},{49.48,86},{49.3,81.81},{62.43,74.77},{64.97,75.91},{63.19,74.85},{67.78,85.24},{65.03,75.82}},[141]={{55.29,35.8},{56.69,40.28},{57.2,40.17},{55.43,34.05},{62.01,31.16},{62.01,32.48},{62.62,32.49},{61.12,31.35},{63.34,35.64},{62.27,32.66},{63.16,35.46},{62.47,34.85},{62.37,34.95},{62.66,35.13},{62.22,37.98},{61.5,38.51},{62.52,32.69},{61.67,38.56},{60.14,36.64},{61.83,38.15},{59.64,36.44},{61.96,38.45},{58.99,35.34},{59.63,30.52},{58.22,29.92},{59.74,26.91},{59.76,29.03},{59.75,27.27},{59.39,29.64},{58.83,29.63},{58.61,28.75},{58.72,28.67},{58.67,29.63},{59.55,29.53},{58.14,33.5},{59.54,27.19},{59.52,29.22},{59.57,28.56},{59.3,28.47},{57.89,33.59},{57.25,34.98},{57.58,33.85},{57.83,36.44},{57.58,34.25},{58.15,33.46},{57.12,34.22},{58.9,29.79},{57.03,35.1},{59.16,35.64},{56.96,32.47},{57.3,36.86},{57.41,33.88},{57.37,40.23},{57.49,34.06},{57.15,32.79},{57.03,32.96},{57.18,35.38},{56.97,34.49},{58.41,38.14},{58.39,37.68},{57.92,38.2},{57.43,37.46},{58.9,37.67},{55.43,39.43},{56.99,34.6},{57.76,36.79},{57.28,36.69}},[148]={{38.5,93.52},{39.31,93.9},{38.96,96.67},{41.9,76.23},{63.32,15.17},{40.3,52.78},{46.46,91.44},{46.34,89.48},{61.7,22.69},{63.84,19.01},{45.03,73.53},{39.03,48.34},{63.52,17.84},{60.47,12.82},{40.94,92.79},{40.7,81.79},{38.26,94.02},{46.54,22.7},{45.5,51.73},{46.76,31.98},{43.91,77.98},{40.09,34.38},{47.79,32.75},{44.02,49.81},{46.72,46.79},{55.48,22.44},{41.25,34.08},{44.07,48.04},{43.82,86.26},{49.72,24.17},{43.98,76.59},{39.01,96.5},{42.85,84.31},{59.33,13.23},{49.39,31.49},{45.88,25.88},{41.39,37.47},{45.7,48.89},{49.28,21.99},{43.04,40.31},{44,40.32},{47.65,19.71},{50.81,19.41},{53.97,27.38},{54.71,26.1}},[267]={{31.22,52.28},{29.34,31.51},{38.85,48.09},{30.33,46.49},{58.2,51.46},{50.19,49.82},{46.99,63.57},{44.59,52.9},{39.19,50.01},{72.38,53.98},{64.7,33.83},{58.57,30.32},{66.36,74.73},{56.1,52.57},{65.65,70.63},{53.97,37.34},{66.88,75.78},{66.55,71.06},{74.07,52.67},{58.32,64.89},{43.94,68.96},{54.77,33.64},{65.05,55.28},{58.21,30.65},{69.7,57.38},{62.94,57.63},{63.01,62.45},{63.88,47.81},{61.55,71.13},{37.9,38.97},{38.61,42.13},{55.38,34.06},{68.6,67.24},{30.69,60.83},{45.31,48.96},{53.12,38.86},{64.62,54.69},{54.98,33.2},{36.29,35.63},{43.86,50.3},{42.4,61.42},{39.2,43.93},{34.39,76.74},{52.46,64.33},{39.48,75.21},{36.39,73.51},{35.68,68.8},{37.01,69.85},{38.02,75.44},{42.45,65.69},{33.11,58.29},{37.11,47.35},{37.02,46.08},{30.64,48.67},{33.19,52.11},{38.47,45.47},{33.49,52.06},{28.59,67.83},{28.82,67.71},{73.86,52.64},{71.89,53.8},{66.83,25.46},{69.47,36.15},{67.8,29.07},{60.95,42.25},{64.59,34.09},{64.46,35.58},{68.08,21.34}},[331]={{69.99,59.6},{69.79,62.99},{81.3,60.85},{89.67,46.59},{86.34,43.48},{86.66,49.26},{72.23,67.01},{83.63,49.09},{68.35,61.87},{71.46,57.5},{72.97,50.38},{81.82,61.65},{73.57,46.92},{91.05,62.29},{89.35,43.86},{89.96,60.53},{76.62,69.5},{71.91,70.23},{83.92,47.94},{84.49,46.19},{72.24,66.96},{75.16,70.32},{76.77,72.86},{63.08,82.64},{72.1,71.05},{73.07,70.97},{72.1,72.8},{74.05,70.51},{66.98,86.23},{66.38,85.46},{74.69,73.62},{64.89,85.18},{64.52,71.53},{61.31,79.99},{63.15,82.56},{65.61,72.22},{55.94,54.76},{64.49,71.52},{70.6,59.84},{62.11,68.19},{61.28,56.81},{62.05,55.94},{68.86,52.79},{58.23,54.13},{59.45,64.82},{56.51,56.72},{61.98,58.84},{60.95,64.4},{66.18,45.76},{68.28,60.99},{71.54,57.45},{72.92,50.59},{73.42,47.12},{66.82,47.86},{69.83,51.07},{71.8,49.33},{63.13,51.25},{67.1,62.08},{64.36,56.82},{55.99,54.87},{61.91,49.89},{62.28,68.07},{60.83,56.43},{60.89,46.58},{58.11,41.14},{62.51,55.79},{58.85,54.27},{57.99,34.88},{52.54,61.05},{59.41,64.9},{56.45,55.87},{61.61,58.73},{61.06,65.09},{52.63,61.23},{51.22,63.52},{44.44,68.16},{63.09,51.19},{55.11,77.83},{42.34,61.49},{43.52,56.36},{48.74,66.71},{57.54,41.3},{45.98,55.81},{57.14,63.79},{58.01,64.87},{58.39,66.85},{56.36,69.46},{42.67,45.59},{33.03,37.09},{36.02,69.38},{30.31,40.22},{31.93,46.19},{22.23,26.95},{40.84,70.83},{42.05,71.56},{43.51,41.58},{40.31,65.63},{27.05,41.85},{43.41,46.91},{40.19,54.77},{40.57,57.92},{37.13,71.52},{21.46,55.56},{22.85,47.4},{44.09,45.44},{39.98,71.4},{33.06,63.93},{30.07,32.5},{26.37,34.3},{40.81,43.28},{40.44,66.62},{40.05,58.14},{27.13,21.64},{35.49,64.88},{38.11,67.04},{41.63,69.11},{19.72,53.38},{31.53,63.95},{31.95,59.41},{50.89,63.49},{38.27,36.59},{44.53,67.87},{39.26,70.71},{44.75,42.17},{42.82,46.45},{32.43,72.55},{41.81,44.02},{25.59,50.64},{31.74,46.39},{27.34,45.79},{33.49,47.51},{25.27,24.6},{26.39,27.14},{43.33,56.13},{39.65,69.21},{48.81,66.35},{40.87,52.38},{25.53,25.44},{31.41,57.55},{29.97,54.15},{30.78,49.66},{25.41,15.83},{28.77,55.1},{26.29,52.65},{36.65,45.61},{22.78,33.66},{22.85,28.62},{26.51,20.12},{18.3,24.66},{24.96,21.19},{26.53,17.94},{39.63,63.83},{27.29,25.94},{26.87,15.74},{18.5,19.61},{56.94,33.73},{57.64,32.48}},[357]={{45.25,5.55},{41.13,10.94},{50.93,23.99},{43.4,24.74},{46.27,13.19},{44.72,8.23},{39.35,22.5},{46.15,25.19},{43.66,12.66},{38.53,24.03},{42.67,22.92},{44.28,21.52},{40.44,23.89},{84.47,39.68},{75.76,57.15},{54.69,64.6},{73.75,54.31},{72.38,55.93},{47.27,50.73},{55.21,54.24},{41.37,36.5},{45.44,67.39},{58.85,54.47},{77.27,46.69},{42.62,38.14},{75.83,56.37},{57.58,64.12},{75.48,51.76},{56.78,56.64},{53.96,70.05},{43.52,36.45},{78.7,40.91},{75.03,56.44},{70.67,61.6},{55.9,67.56},{56.05,62.06},{28,51.2},{85.66,43.49},{46.9,63.55}},[394]={{19.18,76.05},{17.69,75.57},{20.45,76.49},{20.17,77.43},{16.81,74.63},{16.77,74.82}},[493]={{37.69,53.9},{41.86,40.7},{58.28,75.44},{61.4,67.06},{45.83,63.62},{62.85,61.62},{37.38,27.42},{39.59,61},{31.59,49.41},{40.2,56.12},{67.83,54.83},{68.27,56.78},{46.66,69.99},{65.04,51.31},{64.46,54.43},{48.64,71.28},{65.31,67.63},{34.43,38.36},{66.68,46.87},{40.07,46.99},{64.81,64.14},{69.67,52.47},{39.51,29.24},{33.17,43.5},{65.15,53.1},{32.09,38.13},{69.59,53.78},{34.47,42.86},{63.67,49.84},{65.24,71.48},{37.51,65.73},{32.38,32.89},{51.66,66},{31.17,59.75},{68.02,63.52},{33.64,35.76},{42.05,60.63},{47.24,66.1},{60.51,74.13},{45.9,61.24},{63.83,68.69},{49.5,63.33},{63.9,69.68},{66.06,68.19},{40.57,42.25},{61.74,53.37},{36.52,36.95},{37.98,35.21},{35.34,43.99},{35.07,55.87},{39.8,66.76},{36.19,60.04},{31.93,53.41},{35.69,62.52},{33.64,51.47},{35.98,50.81},{44.31,54.27},{41.1,67.99},{43.64,56.54},{64.69,47.44},{65.63,48.83},{63.45,44.2},{60.8,47.88},{66.19,55.88},{66.77,56.31},{64.76,60.11},{65.02,59.85},{63.83,57.89},{42.37,44.36},{57.51,67.09},{59.35,73.77},{58.08,69.97},{64.57,64.51},{55.2,32.14},{42.26,33.58},{34.45,61.25},{57.11,30.75},{43.74,47.68},{47.86,32.77},{38.28,46.67},{65.25,69.57}},[1657]={{45.12,18.3},{49.21,86.22},{30.06,70.87},{53.97,80.37},{30.16,72.33},{62.72,60.56},{56.32,66.7},{68.81,60.24},{51.93,21.81},{54.28,28.36},{44.11,36.25},{62.46,37.39},{41.29,35.21},{35.94,48},{54.68,34.53},{48.52,26.67},{50.67,26.69},{34.64,80.1},{62.51,45.28}},[2557]={{-1,-1}},[3522]={{57.86,38.87},{59.14,38.29},{59.99,41.02},{63.53,35.1},{62,33.11},{62.53,34.67},{62.59,29.99},{62.7,27.6},{62.36,30.24},{59.74,38.97},{58.93,40.98},{59.96,38.82},{59.83,38.25},{62.19,35.36},{62.15,33.68},{62.34,29.51}},[3524]={{37.13,14.33},{25.12,70.65},{42.01,33.01},{39.91,23.26},{37.23,14.29},{71.86,59.21},{54.38,63.9}},[4100]={{-1,-1}},[4714]={{39.2,70.78},{76.17,45},{71.54,47.42},{35.74,71.22},{47.09,42.55},{44.97,48.7},{76.31,43.11},{71.89,44.93},{76.12,37.72},{75.73,39.34},{73.69,44.22},{73.8,42.69},{73.42,44.27},{73.56,44.89},{77.63,36.05},{72.09,43.77},{75.53,49.28},{72.11,43.34},{72.21,43.99}}},nil,331,nil,nil,31,"AH",nil,0},
[885] = {'Watcher Keller',1678,1678,39,39,0,{[10]={{77.98,44.8}}},nil,10,nil,nil,11,"A","The Night Watch",0},
[886] = {'Watcher Hartin',1604,1604,38,38,0,{[10]={{75.39,44.94}}},nil,10,nil,nil,11,"A","The Night Watch",0},
[887] = {'Watcher Jordan',2918,2918,39,39,0,{[10]={{71.59,59.32},{75,51.68},{71.69,59.26}}},{[10]={{{74.77,50.44},{74.99,51.63},{75.01,51.77},{75.04,53.07},{75.06,53.59},{75.06,53.62},{74.51,54.97},{74.48,55.05},{74.43,55.16},{74.37,55.31},{73.76,56.73},{73.35,57.51},{73.12,57.89},{72.79,58.33},{72.7,58.45},{72.57,58.56},{72.13,58.95},{72.05,59.02},{71.99,59.07},{71.87,59.15},{71.68,59.26},{70.86,59.47},{71.68,59.26},{71.87,59.15},{71.99,59.07},{72.05,59.02},{72.13,58.95},{72.57,58.56},{72.7,58.45},{72.79,58.33},{73.12,57.89},{73.35,57.51},{73.76,56.73},{74.37,55.31},{74.43,55.16},{74.48,55.05},{74.51,54.97},{75.06,53.62},{75.06,53.59},{75.04,53.07},{75.01,51.77},{74.99,51.63}}}},10,nil,nil,56,"A","The Night Watch",0},
[888] = {'Watcher Dodds',950,950,29,29,0,{[10]={{45.12,67.03}}},nil,10,{25235},{245,25235},53,"A","The Night Watch",2},
[889] = {'Splinter Fist Ogre',562,562,22,23,0,{[10]={{40.03,72.97},{34.12,71.79},{31.97,68.72},{34.97,72.41},{37.86,73.39},{38.45,74.9},{37.3,84.56}}},nil,10,nil,nil,45,nil,nil,0},
[890] = {'Fawn',8,8,1,1,0,{[12]={{36.92,55.89},{35.49,77.87},{34.95,77.2},{35.8,78.27},{25.14,82.85},{43.83,40.18},{44.55,67.13},{76.89,70.86},{76.78,70.63},{46.09,80.78},{46.48,80.18},{35.12,78.96},{35.28,78.15},{35.74,77.54}},[141]={{54.65,34.62},{52.86,57.95},{44.68,64.49},{53.41,58.84},{52.47,57.36},{46.35,46.06},{42.61,33.73},{42.17,47.02},{54.88,61.48},{62.27,56.54},{53.01,57.95},{43.46,62.2},{43.29,62.93},{43.12,66.81},{52.22,57.99},{55.8,58.89},{40.88,39.87},{55.28,33.52},{55.6,33.58},{41.86,48.06},{47.03,47.27},{44.34,62.34},{41.9,61.89},{60.37,31.53},{60.89,32.14},{61.2,31.29},{61.18,36.31},{60.77,36.84},{63.34,53.87},{53.76,67.01},{48.67,64.93},{47.66,40.4},{59.38,53.61},{58.64,51.52},{42.34,33.16},{59.43,65.36},{46.66,46.83},{42.23,32.95},{42.36,33.31},{48.32,64.97},{53.8,51.84},{41.54,52.42},{55.48,62.53},{55.64,61.57},{41.92,48.48},{42.59,52.62},{42.15,52.13},{63.98,45.92},{41.89,48.67},{58.86,51.68},{41.9,48.45},{58.59,52.77},{48.14,65.35},{47.88,65.62},{47.03,65.27},{42.3,35.7},{46.43,32.24},{42.16,36.35},{47.4,28.84},{40.67,23.88},{40.57,24.58},{40.79,24.53},{40.22,23.88},{40.15,25.29},{47.87,40.17},{47.47,39.51},{61.3,52.77},{58.88,53.42},{62.16,62.52},{55.34,62.85},{66.05,47.21},{47.59,39.69},{53.1,54.81},{41.83,47.91},{41.77,48.38},{41.67,48.36},{42.13,35.54}},[394]={{19.94,77.24}},[4100]={{-1,-1}}},nil,141,nil,nil,31,"AH",nil,0},
[891] = {'Splinter Fist Fire Weaver',628,665,26,27,0,nil,nil,0,nil,nil,45,nil,nil,0},
[892] = {'Splinter Fist Taskmaster',840,896,27,28,0,nil,nil,0,nil,nil,45,nil,nil,0},
[893] = {'Lars',417,417,18,18,0,nil,nil,0,nil,{226},12,"A",nil,0},
[894] = {'Homer Stonefield',102,102,5,5,0,{[12]={{33.69,82.9}}},nil,12,nil,nil,12,"A","Fruit Seller",640},
[895] = {'Thorgas Grimson',0,0,5,5,0,{[6176]={{63.66,20.08}}},nil,6176,{24530},{3108,24530},55,"A","Hunter Trainer",3},
[896] = {'Veldan Lightfoot',198,198,10,10,0,{[12]={{25.18,73.89}}},nil,12,nil,nil,12,"A","Leather Armor Merchant",4224},
[898] = {'Nightbane Worgen',562,562,21,22,0,{[10]={{61.29,51.56},{58.01,30.53},{57.26,27.96},{59.58,45.86},{59.88,29.29},{57.79,29.86},{65.54,39.63},{63.59,51.64},{60.55,48.02},{63.46,48.54},{62.76,50.38},{64.16,51.64},{60.04,49.74},{60.84,30.84},{60.76,30.68},{64.69,46.83},{60.04,43.29},{62.59,32.46},{62.05,43.83},{62.22,46.6},{60.86,41.61},{63.36,44.42},{61.93,43.91},{64.61,42.95},{62.23,41.22},{65.06,35.4},{60.86,40.14},{63.78,36.98},{63.84,40.28}}},nil,10,nil,nil,24,nil,nil,0},
[900] = {'Bailiff Conacher',1003,1003,30,30,0,{[44]={{28.68,40.95}}},nil,44,{26511,26728},{91,26511},11,"A",nil,2},
[903] = {'Guard Howe',1910,1910,30,30,0,{[44]={{30.22,52.44}}},nil,44,nil,{128},11,"A",nil,0},
[905] = {'Sharptooth Frenzy',699,699,25,27,0,{[33]={{43.75,57.3},{51.11,39.04},{53.51,36.52}},[5339]={{46.72,36.91},{47.16,13.72}}},nil,33,nil,nil,1878,nil,nil,0},
[906] = {'Maximillian Crowe',198,198,10,10,0,{[12]={{44.39,66.24}}},nil,12,nil,nil,12,"A","Warlock Trainer",49},
[907] = {'Keras Wolfheart',3874500,3874500,85,85,1,{[1657]={{56.7,47.55}}},nil,1657,nil,nil,1577,"A","Arathi Basin Battlemaster",1048577},
[908] = {'Flora Silverwind',1782,1782,44,44,0,{[5287]={{41.98,74.66}}},nil,5287,nil,nil,120,"AH","Herbalism Trainer",80},
[909] = {'Defias Night Blade',734,787,25,26,0,nil,nil,0,nil,nil,17,nil,nil,0},
[910] = {'Defias Enchanter',628,665,26,27,0,nil,nil,0,nil,nil,17,nil,nil,0},
[911] = {'Llane Beshere',0,0,5,5,0,{[6170]={{40.87,53.81}}},nil,6170,{26913,28789},{3100,26913},12,"A","Warrior Trainer",2},
[912] = {'Thran Khorman',0,0,5,5,0,{[6176]={{61.89,18.99}}},nil,6176,{24531},{3106,24531},55,"A","Warrior Trainer",3},
[913] = {'Lyria Du Lac',247,247,12,12,0,{[12]={{41.07,65.83}}},nil,12,nil,nil,12,"A","Warrior Trainer",49},
[914] = {'Ander Germaine',4120,4120,60,60,0,{[1519]={{79.44,68.88}}},nil,1519,{27337,28393},{27225,28258,28393},12,"A","Warrior Trainer",51},
[915] = {'Jorik Kerridan',0,0,5,5,0,{[6170]={{41.13,45.31}}},nil,6170,{26915,28787},{3102,26915},12,"A","Rogue Trainer",2},
[916] = {'Solm Hargrin',0,0,5,5,0,{[6176]={{59.53,20.39}}},nil,6176,{24532},{3109,24532},55,"A","Rogue Trainer",3},
[917] = {'Keryn Sylvius',222,222,11,11,0,{[12]={{43.87,65.94}}},nil,12,nil,nil,12,"A","Rogue Trainer",49},
[918] = {'Osborne the Night Man',4120,4120,60,60,0,{[1519]={{77.5,65.36}}},nil,1519,nil,{27267},12,"A","Rogue Trainer",51},
[920] = {'Nightbane Tainted One',498,498,22,23,0,{[10]={{74.23,78.14},{73.84,77.26},{73.3,76.69},{72.07,74.77},{74.16,79.62},{73.12,75.62},{73.47,73.36},{73.54,79.04},{73.08,74.18},{72.4,73.52}}},nil,10,nil,nil,2375,nil,nil,0},
[921] = {'Venture Co. Lumberjack',853,853,29,29,0,{[33]={{55.77,35.98},{55.78,35.28}}},nil,33,nil,nil,47,nil,nil,0},
[922] = {'Silt Crawler',2292,2292,51,52,0,{[8]={{75.37,9.58},{77.85,12.14},{85.57,22.98},{86.73,3.48},{89.03,22.72},{85.51,21.46},{84.14,22.24},{81.68,14.27},{75.46,9.89},{84.14,20.12},{80.89,17.24},{76.99,4.98},{75.96,2.44},{79.22,4.64},{82.54,8.69},{84,7.06},{78.87,4.13},{78,6.77},{78.68,5.98},{81.79,3.03},{82.75,20.31},{80.98,18.56},{76.97,12.25},{79.72,14.66},{88.15,26.94},{77.53,8.4},{78.41,7.2},{82.44,14.74}}},nil,8,nil,nil,7,"AH",nil,0},
[923] = {'Young Black Ravager',617,664,23,24,0,nil,nil,0,nil,nil,38,nil,nil,0},
[925] = {'Brother Sammuel',0,0,5,5,0,{[6170]={{41.55,53.22}}},nil,6170,{26918,28785},{3101,26918},12,"A","Paladin Trainer",2},
[926] = {'Bromos Grummner',0,0,5,5,0,{[6176]={{61.9,24.57}}},nil,6176,{24528},{3107,24528},55,"A","Paladin Trainer",3},
[927] = {'Brother Wilhelm',222,222,11,11,0,{[12]={{41.08,65.95}}},nil,12,nil,nil,12,"A","Paladin Trainer",49},
[928] = {'Lord Grayson Shadowbreaker',3297,3297,60,60,0,{[1519]={{52.85,44.91}}},nil,1519,{27343,28405},{7638,7639,7640,7644,7646,7648,7666,7670,27265,28268,28405},12,"A","Paladin Trainer",51},
[929] = {'Dreadlord Malganis',15150,16589,83,83,3,nil,nil,0,nil,nil,35,"AH","Overfiend",0},
[930] = {'Black Widow Hatchling',562,562,21,22,0,{[10]={{72.77,61.95},{85.28,52.77},{72.67,62.25},{86.1,50.14},{86.2,54.15},{73.86,61.49},{77.33,61.53},{75.44,61.27},{82,54.3},{87.33,50.49},{79.11,53.7},{75.88,59.72},{78.83,56.15},{79.9,52.2},{81.97,51.15},{73.86,61.27},{84.4,56.54},{85.41,52.19},{72.66,62.19},{85.96,49.79},{86.48,54.21},{75.86,63.64},{77.22,61.72},{75.08,61.4},{81.74,53.55},{87.42,51.21},{79.37,54.07},{75.89,59.3},{78.73,55.92},{81.52,51.11},{84.51,56.67},{74.11,64.53},{73.6,59.61},{74.18,61.5}}},nil,10,nil,nil,22,nil,nil,0},
[931] = {'Ariena Stormfeather',232470,232470,85,85,1,{[44]={{29.42,53.76}}},nil,44,nil,nil,12,"A","Gryphon Master",8193},
[932] = {'Guard Ashlock',2440,2440,35,35,0,{[44]={{30.59,52.38}}},{[44]={{{31.9,57.77},{32.43,57.86},{32.52,56.49},{32.6,55.39},{32.68,53.92},{32.79,51.92},{32.87,50.39},{32.95,48.91},{33.07,48.16},{32.96,48.75},{32.87,50.28},{32.79,51.81},{32.69,53.79},{32.6,55.3},{32.11,56.9},{31.95,57.27}}}},44,nil,nil,11,"A",nil,0},
[933] = {'Guard Hiett',2440,2440,35,35,0,{[44]={{31.61,53.08}}},nil,44,nil,nil,11,"A",nil,0},
[934] = {'Guard Clarke',2440,2440,35,35,0,{[44]={{30.74,44.55}}},{[44]={{{28.98,47.88},{30.02,47.98},{31.09,48.04},{32.02,48.07},{32.37,48.37},{31.77,48.77},{31,48.94},{30.22,48.97},{29.72,49.05},{29.57,49.82},{29.47,50.86},{29.44,51.62},{29.35,52.49},{29.28,53.14},{29.35,52.49},{29.44,51.62},{29.47,50.86},{29.57,49.88},{29.72,49.05},{30.22,48.97},{31,48.94},{31.77,48.77},{32.37,48.37},{32.02,48.07},{31.09,48.04},{30.02,47.98},{28.98,47.88},{28.16,47.75}}}},44,nil,nil,11,"A",nil,0},
[935] = {'Guard Pearce',2440,2440,35,35,0,{[44]={{31.56,52.67}}},nil,44,nil,nil,11,"A",nil,0},
[936] = {'Guard Adams',2440,2440,35,35,0,{[44]={{26.8,42.69}}},{[44]={{{27.47,46.87},{26.03,46.9},{25.08,46.38},{24.33,46.17},{23.25,45.92},{23.13,45.54},{23.62,45.52},{23.87,44.59},{23.87,43.62},{24.12,42.41},{23.78,45.59},{24.33,46.33},{25.24,46.38},{25.79,45.39},{26.01,44.01},{26.15,42.3},{27.17,42.28},{27.79,44.04},{27.66,46.29},{27.48,46.32}}}},44,nil,nil,11,"A",nil,0},
[937] = {'Kurzen Jungle Fighter',699,699,24,25,0,{[33]={{58.44,18.59},{58.15,18.97},{58.63,22.21},{58.2,20.4},{57.81,21.77},{57.89,22.74},{57.7,23.46},{58.12,23.45},{58.88,23.14},{57.55,20.8},{56.8,22.12},{57,22.98},{57.03,20.58}},[5339]={{56.5,17.06}}},nil,33,nil,nil,46,nil,nil,0},
[938] = {'Kurzen Commando',699,699,25,25,0,{[33]={{61.88,17.45},{59.81,19.07}}},nil,33,nil,nil,46,nil,nil,0},
[939] = {'Kurzen Elite',750,750,25,26,0,{[33]={{65.13,17.77},{64.5,18.94},{63.72,18.86},{62.91,15.39}}},nil,33,nil,nil,46,nil,nil,0},
[940] = {'Kurzen Medicine Man',610,610,24,25,0,{[33]={{57.93,20.37},{56.37,20.43},{56.45,19.66},{56.78,20.21},{56.67,20.8},{56.84,20.81},{58.16,22.23},{55.85,20.94},{56.69,24.24}}},nil,33,nil,nil,46,nil,nil,0},
[941] = {'Kurzen Headshrinker',610,610,25,26,0,{[33]={{63.2,16.88},{62.7,17.57},{63.16,18.69}}},nil,33,nil,nil,46,nil,nil,0},
[942] = {'Kurzen Witch Doctor',651,651,25,26,0,{[33]={{63.33,18.21},{65.15,16.96},{62.51,15.84},{64.61,18.58},{65.47,18.5},{63,16.85}}},nil,33,nil,nil,46,nil,nil,0},
[943] = {'Kurzen Wrangler',571,571,24,24,0,{[33]={{59.57,21.73},{59.68,20.25},{59.28,21.32},{59.72,21.03}}},nil,33,nil,nil,46,nil,nil,0},
[944] = {'Marryk Nurribit',102,102,5,5,0,nil,nil,0,nil,{3111,3114},875,"A","Mage Trainer",49},
[945] = {'Rybrad Coldbank',0,0,5,5,0,{[6176]={{61.02,21.53}}},nil,6176,nil,nil,55,"A","Weaponsmith",4224},
[946] = {'Frostmane Novice',0,0,4,4,0,{[6176]={{68.43,96.15},{62.41,96.87},{63,90.06},{64.71,89.49},{70.17,87.93},{66.21,85.61},{69.5,85.99},{65.89,83.81},{68.73,84.13},{65.67,81.7},{70.26,81.8},{68.59,81.8},{67.07,80.58}}},nil,6176,nil,nil,190,"AH","Grik'nir's Servant",0},
[947] = {'Rohh the Silent',626,626,18,18,4,{[44]={{70.61,44.46},{67.54,29.72}}},nil,44,nil,nil,39,nil,nil,0},
[948] = {'Rotted One',651,651,24,25,0,{[10]={{16.54,30.12},{24.83,33.84},{16.72,30.48},{17.22,27.66},{17.4,29.17},{21.52,34.89},{19.18,41.87},{16.11,33.7},{20.57,39.08},{23.71,33.59},{15.96,42.44},{23.35,40.28},{16.84,47.96},{22.38,43.76},{22.74,46.06},{20.96,40.22},{21.51,48.21},{17.07,40.28},{18.85,36.82},{25.92,36.07},{26.84,34.16},{17.43,33.28},{16.59,36.77},{17.28,35.74},{17.39,34.86},{13.7,34.55},{13.26,32.86},{13.38,34.46},{14.64,36.23},{14.28,36.05},{15.59,37.44},{14.24,36.97},{16.57,34.56},{14.99,36.4},{15.85,32.26},{16.11,33.34},{13.45,35.59},{16.45,32.51},{16.91,37.08},{14.37,33.35},{14.86,34.86},{16.2,33.17},{16.03,37.59},{16,32.2},{16.93,35},{17.42,37.16},{14.99,33.51},{18.31,35.62},{16.1,34.06},{14.52,36.77},{14.96,33.91},{12.97,35.56},{17.94,35.07},{16.59,38.21},{13.97,32.7},{13.75,35.8},{17.27,35.26},{17.52,35.88},{16.75,35.22},{15.97,34.29},{18.24,34.56},{17.28,34.19},{18.92,35.76},{15.59,37.12},{15.79,37.35},{17.41,33.3},{18.66,42.19},{24.87,33.93},{21.77,34.96},{16.29,33.81},{20.36,38.7},{23.84,33.39},{21.16,40.47},{21.96,47.29},{16.74,40.28},{18.07,33.74},{17.23,34.2},{18.82,35.43},{15.74,37.36},{17.36,33.41},{17.39,39.81},{15.17,34.27},{16.1,32.77},{16.17,33.4},{14.06,36.15},{14.81,34.34},{16.28,34.88},{14.47,36.39},{15.44,34.12},{13.47,35.61},{17.29,37.65},{19,48.39},{15.42,37.32},{18.68,35.74},{14.69,33.5},{18.93,46.24},{17.45,35.35},{13.65,36.41},{16.13,34.06},{18.21,37.35},{16.51,34.62},{13.16,33.33},{13.69,35.79},{12.84,36.12},{15.79,34.61},{13.94,36.95},{15.8,36.78},{16.19,33.15},{14.21,34.29},{13.99,35.69},{16.29,32.83},{13.07,33.76},{16.61,43.3}}},nil,10,nil,nil,21,nil,nil,0},
[949] = {'Carrion Recluse',734,787,25,26,0,nil,nil,0,nil,nil,22,nil,nil,0},
[950] = {'Swamp Talker',2880,2880,50,50,0,nil,nil,0,nil,nil,14,nil,nil,0},
[951] = {'Brother Paxton',0,0,4,4,0,{[6170]={{35.59,37.7}}},nil,6170,{28806,28808,28809,28810,28811,28812,28813,29082},{28806,28808,28809,28810,28811,28812,28813,29082},12,"A",nil,2},
[952] = {'Brother Neals',0,0,50,50,0,{[6170]={{38.11,51.3}}},nil,6170,nil,nil,12,"A",nil,2},
[953] = {'Spawn Test One',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","TEST MOB",0},
[954] = {'Kat Sampson',386,386,17,17,0,{[38]={{82.65,64.11}}},nil,38,nil,nil,55,"A","Leather Armor Merchant",4224},
[955] = {'Sergeant De Vries',198,198,10,10,0,{[12]={{24.08,73.2}}},nil,12,nil,nil,12,"A","Morale Officer",640},
[956] = {'Dorin Songblade',573,573,22,22,0,{[44]={{29.79,42.96}}},nil,44,nil,nil,12,"A","Armorer",4224},
[957] = {'Dane Lindgren',1003,1003,30,30,0,{[1519]={{64.12,36.98}}},nil,1519,nil,nil,12,"A","Apprentice Blacksmith",1},
[958] = {'Dawn Brightstar',1342,1342,35,35,0,{[12]={{64.88,69.19}}},nil,12,nil,nil,12,"A","Arcane Goods",2176},
[959] = {'Morley Eberlein',198,198,10,10,0,{[12]={{64.69,69.51}}},nil,12,nil,nil,12,"A","Clothier",4224},
[960] = {'Gunder Thornbush',1003,1003,30,30,0,{[10]={{73.77,45.14}}},nil,10,nil,nil,12,"A","Tradesman",128},
[963] = {'Deputy Rainer',198,198,10,10,0,{[12]={{24.23,74.45}}},nil,12,{11,26378},{11,239},12,"A",nil,3},
[976] = {'Kurzen War Tiger',651,651,25,25,0,{[33]={{59.57,20.24},{59.25,21.17},{59.78,21.08}}},nil,33,nil,nil,46,nil,nil,0},
[977] = {'Kurzen War Panther',651,651,25,25,0,{[33]={{59.25,21.17}}},nil,33,nil,nil,46,nil,nil,0},
[978] = {'Kurzen Subchief',610,610,25,26,0,{[33]={{65.13,16.17}}},nil,33,nil,nil,46,nil,nil,0},
[979] = {'Kurzen Shadow Hunter',699,699,25,26,0,{[33]={{65.61,14.56},{63.99,14.32},{66.25,11.16},{63.92,14.2}}},nil,33,nil,nil,46,nil,nil,0},
[980] = {'Grimnal',3137,3137,55,55,0,{[8]={{46.87,51.2}}},nil,8,nil,nil,29,"H","Mail & Plate Merchant",4224},
[981] = {'Hartash',3137,3137,55,55,0,{[8]={{47.41,51.65}}},nil,8,nil,nil,29,"H","Weapon Merchant",4224},
[982] = {'Thultash',3137,3137,55,55,0,{[8]={{48.19,54.73}}},nil,8,nil,nil,29,"H","Food & Drink Vendor",640},
[983] = {'Thultazor',3137,3137,55,55,0,{[8]={{47.51,53.39}}},nil,8,nil,nil,29,"H","Alchemy Supplies & Reagents",2176},
[984] = {'Thralosh',3137,3137,55,55,0,{[8]={{46.86,52.09}}},nil,8,nil,nil,29,"H","Cloth & Leather Armor Merchant",4224},
[985] = {'Malosh',3268,3268,55,55,0,{[8]={{46.7,57.78}}},nil,8,nil,nil,29,"H","Warrior Trainer",49},
[986] = {'Haromm',3268,3268,55,55,0,{[8]={{49.71,58.07}}},nil,8,nil,nil,29,"H","Shaman Trainer",49},
[987] = {'Ogromm',3268,3268,55,55,0,{[8]={{48.87,53.94}}},nil,8,nil,nil,29,"H","Hunter Trainer",49},
[988] = {'Kartosh',3268,3268,55,55,0,{[8]={{50.14,55.97}}},nil,8,nil,nil,29,"H","Warlock Trainer",49},
[989] = {'Banalash',3268,3268,55,55,0,{[8]={{46.59,56.87}}},nil,8,nil,nil,29,"H","Trade Supplies",128},
[994] = {'Nahr\'ek da Howler',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[995] = {'Nahr\'ek\'s Pack',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[996] = {'Eric Dodds the Third',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Tailoring Trainer",64},
[999] = {'Watcher Royce',1536,1536,37,37,0,{[10]={{79.37,46.08}}},nil,10,nil,nil,11,"A","The Night Watch",0},
[1000] = {'Unkillable Test Dummy',480,480,20,20,0,nil,nil,0,nil,nil,56,"A",nil,0},
[1001] = {'Watcher Hutchins',484,484,20,20,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1007] = {'Mosshide Gnoll',494,531,20,21,0,nil,nil,0,nil,nil,61,nil,nil,0},
[1008] = {'Mosshide Mongrel',531,573,21,22,0,nil,nil,0,nil,nil,61,nil,nil,0},
[1009] = {'Mosshide Mistweaver',472,504,22,23,0,nil,nil,0,nil,nil,61,nil,nil,0},
[1010] = {'Mosshide Fenrunner',573,617,22,23,0,nil,nil,0,nil,nil,61,nil,nil,0},
[1011] = {'Mosshide Trapper',617,664,23,24,0,nil,nil,0,nil,nil,61,nil,nil,0},
[1012] = {'Mosshide Brute',664,713,24,25,0,nil,nil,0,nil,nil,61,nil,nil,0},
[1013] = {'Mosshide Mystic',640,684,25,26,0,nil,nil,0,nil,nil,61,nil,nil,0},
[1014] = {'Mosshide Alpha',840,840,27,27,0,nil,nil,0,nil,nil,61,nil,nil,0},
[1015] = {'Highland Raptor',617,664,23,24,0,nil,nil,0,nil,nil,48,nil,nil,0},
[1016] = {'Highland Lashtail',651,651,24,25,0,{[11]={{68.04,35.37},{70.02,39.82},{68.93,36.78},{67.52,33.68},{70.04,37.2},{67.85,32.45},{71.18,39.12},{72.5,39.95},{70.14,39.36},{69.17,32.96},{70.78,30.93},{70.06,32},{68.74,27.8},{67.89,30.68},{69.45,40.32},{69.49,38.98},{70.36,36.94},{71.39,39.24},{72.25,39.84},{73.64,41.19},{66.25,32.25},{66.6,37.09},{67.8,33.86},{69.69,30.23},{69.26,36.5},{65.2,31.63},{67.82,32.37},{69.1,31.51},{67.93,35.53},{68.64,31.33},{69.16,32.86},{67.36,28.61},{70.77,30.93},{69.26,35.01}}},nil,11,nil,nil,2358,nil,nil,0},
[1017] = {'Highland Scytheclaw',734,787,25,26,0,nil,nil,0,nil,nil,22,nil,nil,0},
[1018] = {'Highland Razormaw',840,896,27,28,0,nil,nil,0,nil,nil,22,nil,nil,0},
[1019] = {'Elder Razormaw',699,699,25,25,0,{[11]={{68.68,31.31},{69.1,31.57},{69.69,30.25},{69.25,34.99},{67.07,30.88},{70.08,31.92},{70.68,29.26}}},nil,11,nil,nil,2358,nil,nil,0},
[1020] = {'Mottled Raptor',573,617,22,23,0,nil,nil,0,nil,nil,48,nil,nil,0},
[1021] = {'Mottled Screecher',664,713,24,25,0,nil,nil,0,nil,nil,48,nil,nil,0},
[1022] = {'Mottled Scytheclaw',734,787,25,26,0,nil,nil,0,nil,nil,48,nil,nil,0},
[1023] = {'Mottled Razormaw',787,840,26,27,0,nil,nil,0,nil,nil,22,nil,nil,0},
[1024] = {'Bluegill Murloc',494,531,20,21,0,nil,nil,0,nil,nil,18,nil,nil,0},
[1025] = {'Bluegill Puddlejumper',531,573,21,22,0,nil,nil,0,nil,nil,18,nil,nil,0},
[1026] = {'Bluegill Forager',573,617,22,23,0,nil,nil,0,nil,nil,18,nil,nil,0},
[1027] = {'Bluegill Warrior',664,713,24,25,0,nil,nil,0,nil,nil,18,nil,nil,0},
[1028] = {'Bluegill Muckdweller',504,539,23,24,0,nil,nil,0,nil,nil,18,nil,nil,0},
[1029] = {'Bluegill Oracle',640,684,25,26,0,nil,nil,0,nil,nil,18,nil,nil,0},
[1030] = {'Black Slime',494,531,20,21,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1031] = {'Crimson Ooze',664,713,24,25,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1032] = {'Black Ooze',605,605,23,24,0,{[11]={{47.88,25.09},{43.87,25.33},{42.83,23.53},{42.52,25.31},{44.7,24.43},{43.88,24.17},{44.71,25.43},{45.22,23.95},{47.48,23.24},{46.16,23.49},{48.93,24.44},{46.46,25.24},{45.43,29.03},{42.26,26.94},{42.6,28.86},{47.99,27.39},{44.02,26.54},{44.39,28.08},{44.97,26.77},{43.43,27.21},{46.4,27.82},{43.47,29.32},{44.25,23.81},{45.98,26.44},{42.95,26.15},{44.69,25.64},{43.75,24.83},{43.72,26.74}}},nil,11,nil,nil,14,nil,nil,0},
[1033] = {'Monstrous Ooze',734,787,25,26,0,nil,nil,0,nil,nil,22,nil,nil,0},
[1034] = {'Dragonmaw Raider',605,605,23,23,0,{[11]={{49.27,46.28},{44.04,43.39},{46.3,46.58},{46.78,46.58},{45.54,42.14},{47.7,47.37},{47.36,46.98}}},nil,11,nil,nil,2273,nil,nil,0},
[1035] = {'Dragonmaw Swamprunner',605,605,23,23,0,{[11]={{50.59,50.83},{52.77,47.65},{48.91,50.36},{52.58,48.89},{49.91,44.53},{44.77,40.92},{47.23,44.29},{44.26,45.6},{47.7,42.49},{47.57,48.72},{41.41,46.2},{48.12,45.08},{48.93,45.04},{45.56,41.33},{44.64,46.49},{45.38,47.55},{44.95,42.07}}},nil,11,nil,nil,2273,nil,nil,0},
[1036] = {'Dragonmaw Centurion',651,651,23,24,0,{[11]={{49.08,48.47},{49.16,48.55},{48.31,47.28},{48.23,47.21},{52.64,53.15},{52.03,53.14},{49.46,48.23},{52.11,48.76},{51.09,47.32},{51.15,50.66},{51.2,46.27},{48.78,47.08},{45.89,45.19},{42.69,42.89},{42.82,41.46},{45.48,43.06},{43.15,41.37},{45.7,43.55},{45.48,45.42}}},nil,11,nil,nil,2273,nil,nil,0},
[1037] = {'Dragonmaw Battlemaster',684,734,29,30,4,{[11]={{49.46,46.59}}},{[11]={{{45.34,44.41},{45.55,44.69},{45.8,44.89},{46.11,45.14},{46.18,45.57},{46.24,45.93},{46.45,46.12},{46.73,46.23},{47.01,46.34},{47.28,46.53},{47.47,46.67},{47.68,46.82},{47.84,47.17},{47.97,47.44},{48.15,47.82},{48.33,48.07},{48.54,48.35},{48.76,48.66},{48.97,48.94},{49.19,49.13},{49.37,49.29},{49.59,49.48},{49.81,49.66},{50.04,49.86},{50.2,50.01},{50.45,50.22},{50.66,50.4},{50.86,50.57},{50.96,50.77},{51.09,51.01},{51.07,51.34},{51.08,51.63},{51.12,51.88},{51.23,52.08},{51.36,52.32},{51.48,52.53},{51.58,52.8},{51.74,53.04},{51.91,53.15},{52.1,53.25},{52.26,53.33},{52.44,53.38},{52.57,53.45},{52.71,53.64},{52.82,53.84},{52.86,53.98},{52.77,54.28},{52.87,54.43},{52.95,54.39},{53.15,54.19},{53.23,53.99},{53.19,53.81},{53.09,53.69},{52.89,53.46},{52.67,53.33},{52.41,53.23},{52.21,53.15},{52.03,53.03},{51.86,52.92},{51.71,52.82},{51.63,52.69},{51.52,52.45},{51.35,52.18},{51.27,51.97},{51.28,51.65},{51.23,51.27},{51.19,50.97},{51.21,50.68},{51.1,50.42},{50.93,50.19},{50.74,49.92},{50.56,49.68},{50.38,49.32},{50.25,49.07},{50.08,48.85},{49.94,48.67},{49.76,48.45},{49.6,48.23},{49.44,48.03},{49.36,47.88},{49.23,47.61},{49.14,47.34},{49.09,47.04},{49.04,46.77},{49,46.52},{48.78,46.34},{48.56,46.34},{48.39,46.35},{48.18,46.43},{47.96,46.41},{47.77,46.14},{47.59,45.86},{47.38,45.68},{47.17,45.5},{46.85,45.21},{46.58,44.97},{46.39,44.58},{46.32,44.22},{46.25,43.86},{46.08,43.47},{45.91,43.12},{45.8,42.93},{45.62,43.06},{45.39,43.21},{45.24,43.19},{44.98,43.15},{44.73,43.11},{44.42,43.06},{44.19,42.93},{43.98,42.92},{43.82,42.83},{43.61,42.72},{43.41,42.61},{43.25,42.52},{42.98,42.46},{42.81,42.45},{42.6,42.65},{42.55,42.82},{42.5,43.07},{42.46,43.31},{42.49,43.6},{42.58,43.83},{42.67,44.08},{42.86,44.1},{43.05,44.03},{43.21,43.98},{43.42,43.91},{43.61,43.84},{43.8,44.02},{43.96,44.17},{44.19,44.25},{44.41,44.33},{44.62,44.5},{44.79,44.53},{45.05,44.53},{45.21,44.45}}}},11,nil,nil,62,nil,nil,0},
[1038] = {'Dragonmaw Shadowwarder',494,494,23,24,0,{[11]={{53.18,54.49},{53.65,54.42},{49.75,50.42},{48.88,46.25},{45.97,45.8},{49.56,46.87},{44.3,44.25},{45.59,42.52},{42.38,42.51},{39.47,46.94},{49.7,47.6},{46.33,43.99}}},nil,11,nil,nil,2273,nil,nil,0},
[1039] = {'Fen Dweller',494,765,20,21,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1040] = {'Fen Creeper',664,713,24,25,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1041] = {'Fen Lord',734,787,25,26,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1042] = {'Red Whelp',617,664,23,24,0,nil,nil,0,nil,nil,60,nil,nil,0},
[1043] = {'Lost Whelp',582,622,24,25,0,nil,nil,0,nil,nil,60,nil,nil,0},
[1044] = {'Flamesnorting Whelp',684,724,26,27,0,nil,nil,0,nil,nil,60,nil,nil,0},
[1045] = {'Red Dragonspawn',8352,8613,57,58,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1046] = {'Red Wyrmkin',6891,7107,58,59,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1047] = {'Red Scalebane',8883,9156,59,60,1,nil,nil,0,nil,nil,60,nil,nil,0},
[1048] = {'Scalebane Lieutenant',9156,9432,60,61,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1049] = {'Wyrmkin Firebrand',7545,7770,61,62,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1050] = {'Scalebane Royal Guard',9432,9711,61,62,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1051] = {'Dark Iron Dwarf',800,853,27,28,0,nil,nil,0,nil,nil,54,nil,nil,0},
[1052] = {'Dark Iron Saboteur',853,905,28,29,0,nil,nil,0,nil,nil,54,nil,nil,0},
[1053] = {'Dark Iron Tunneler',905,955,29,30,0,nil,nil,0,nil,nil,54,nil,nil,0},
[1054] = {'Dark Iron Demolitionist',955,1006,30,31,0,nil,nil,0,nil,nil,54,nil,nil,0},
[1055] = {'Dreamhunter',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1056] = {'Emerald Sentinel',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1057] = {'Dragonmaw Bonewarder',494,494,23,24,0,{[11]={{51.64,48.82},{50.54,49.51},{49.16,45.25},{47.33,45.47},{42.36,45.37},{45.01,42.85},{48.77,49.35},{42.71,43.56}}},nil,11,nil,nil,2273,nil,nil,0},
[1059] = {'Ana\'thek the Cruel',1146,1146,30,30,0,{[33]={{57.39,75.32}}},nil,33,nil,nil,30,nil,"Skullsplitter Chief",0},
[1060] = {'Mogh the Undying',4278,4278,44,44,1,nil,nil,0,nil,nil,30,nil,"Skullsplitter Clan Witchdoctor",0},
[1061] = {'Gan\'zulah',1600,1600,27,27,0,{[33]={{24.85,18.21}}},nil,33,nil,nil,28,nil,"Bloodscalp Chief",0},
[1062] = {'Nezzliok the Dire',1380,1380,27,27,0,{[33]={{26.75,19.53}}},nil,33,nil,nil,28,nil,"Bloodscalp Clan Witchdoctor",0},
[1063] = {'Jade',3921,3921,55,55,4,{[8]={{69.48,54.43},{30.92,46.88}}},nil,8,nil,nil,50,nil,nil,0},
[1064] = {'Grom\'gol Grunt',2440,2440,35,35,0,{[33]={{38.82,49.39},{39.34,49.71},{38.94,50.04},{37.88,48.15},{38.03,49.66},{39.31,50.43},{39.31,50.21},{38.16,49.61},{36.82,49.7},{36.82,49.98},{37.76,50.31},{37.07,49.4},{37.78,48.77},{38.22,48.21},{38.35,48.19}}},nil,33,nil,nil,85,"H",nil,0},
[1065] = {'Riverpaw Shaman',186,186,11,11,0,{[40]={{45.01,13.74},{44.75,13.95},{52.23,14.88},{51.94,15.13}}},nil,40,nil,nil,20,nil,nil,0},
[1066] = {'Mottled Riptooth',1380,1380,27,27,0,nil,nil,0,nil,nil,35,"AH","UNUSED",0},
[1067] = {'Riverpaw Scavenger',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1068] = {'Gorn',3202,3202,57,57,0,{[3]={{17.68,43.96}}},nil,3,{27880},{782,793,27880},29,"H",nil,2},
[1069] = {'Crimson Whelp',640,684,25,26,0,nil,nil,0,nil,nil,60,nil,nil,0},
[1070] = {'Deputy Feldon',1221,1221,33,33,0,{[44]={{29.54,54.25}}},nil,44,nil,{244,246},11,"A",nil,0},
[1071] = {'Longbraid the Grim',1342,1342,35,35,0,{[11]={{49.8,18.26}}},nil,11,{26327},{304,472,26196},55,"A",nil,2},
[1072] = {'Roggo Harlbarrow',1003,1003,30,30,0,{[11]={{49.85,18.09}}},nil,11,nil,nil,55,"A",nil,0},
[1073] = {'Ashlan Stonesmirk',840,840,27,27,0,{[38]={{64.31,26.61},{64.19,26.67}}},nil,38,{27075,27077,27078,27115},{161,278,25117,26155,26156,27074,27075,27077,27078},55,"A","Gunsmith",3},
[1074] = {'Motley Garmason',1003,1003,30,30,0,{[11]={{49.66,18.23}}},nil,11,nil,{303,378},55,"A",nil,0},
[1075] = {'Rhag Garmason',713,713,25,25,0,{[11]={{49.92,18.22}}},nil,11,nil,{632,633},55,"A",nil,0},
[1076] = {'Merrin Rockweaver',1003,1003,30,30,0,nil,nil,0,nil,{305},55,"A","Explorers' League",0},
[1077] = {'Prospector Whelgar',1003,1003,30,30,0,nil,nil,0,nil,{299},55,"A","Explorers' League",0},
[1078] = {'Ormer Ironbraid',713,713,25,25,0,nil,nil,0,nil,{294,295,296},55,"A",nil,0},
[1081] = {'Mire Lord',2476,2476,42,42,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1082] = {'Sawtooth Crocolisk',1604,1678,38,39,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1083] = {'Murloc Shorestriker',328,328,15,16,0,{[44]={{45.69,64.47},{44.82,62.09},{43.42,64.39},{45.46,60.55},{44.94,59.16},{44.07,60.33},{43.16,59.04},{45.23,64.74},{46.65,61.55}}},nil,44,nil,nil,18,nil,nil,0},
[1084] = {'Young Sawtooth Crocolisk',1403,1469,35,36,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1085] = {'Elder Stranglethorn Tiger',800,800,26,27,0,{[33]={{38.99,29.24},{43.81,64.27}},[5339]={{48.69,38.94},{42.63,20.18},{51.59,39.94},{51.79,35.45},{41.47,21.82},{42.08,20.94},{42.27,24.05},{42.07,22.36},{42.68,23.32},{43.17,24.16},{47.16,38.65},{50.97,35.63},{43.76,21.92},{45.77,23.46},{46.26,22.82},{50.58,36.2},{49.21,36.67},{46.23,24.15},{43.26,22.56}}},nil,5339,{187},nil,16,nil,nil,0},
[1087] = {'Sawtooth Snapper',1902,1981,41,42,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1088] = {'Monstrous Crawler',2453,2453,53,53,0,{[4]={{72.2,24.37}},[8]={{77.81,9.93},{76.51,9.87},{75.18,7.86},{73.21,10.28},{83.12,17.79},{90.84,39.37},{91.5,35.9},{91.93,44.65},{91.06,37.49},{91.75,47.65},{92.43,41.76},{85.81,19.81},{94.17,46.31},{95.65,38.78},{80.49,13.85},{90.25,34.08},{87.12,21.82},{73.97,10.06},{72.98,8.15},{93.06,59.25},{86.49,90.7},{78.82,90.76},{80.54,83.71},{90.7,61.71},{83.63,94.99},{73.73,95.34},{91.47,68.14},{77.32,94.56},{87.87,83.29},{90.23,70.97},{92.1,71.13},{93.09,56.55},{88.13,74.06},{84.25,84.25},{82.92,80.88}}},nil,8,nil,nil,7,"AH",nil,0},
[1089] = {'Mountaineer Cobbleflint',1398,1398,25,25,0,{[38]={{23.33,74.93}}},nil,38,{26145},{224,912,26145},55,"A",nil,2},
[1090] = {'Mountaineer Wallbang',1398,1398,25,25,0,{[38]={{23.3,75.06}}},nil,38,{26147},{263,26147},55,"A",nil,2},
[1091] = {'Mountaineer Gravelgaw',1910,1910,30,30,0,nil,nil,0,nil,{237,13638},55,"A",nil,0},
[1092] = {'Captain Rugelfuss',1753,1753,40,40,0,{[38]={{23.38,75.05}}},nil,38,{26146,26148,26176},{217,267,13635,26146,26148},55,"A",nil,2},
[1093] = {'Chief Engineer Hinderweir VII',1753,1753,40,40,0,nil,nil,0,nil,{199,274,283,13652},55,"A",nil,0},
[1094] = {'Venture Co. Miner',853,853,28,29,0,{[5339]={{39.55,11.35},{40.11,11.88},{39.73,11.85}}},nil,5339,nil,nil,47,nil,nil,0},
[1095] = {'Venture Co. Workboss',853,853,28,28,0,{[5339]={{39.65,11.4}}},nil,5339,nil,nil,47,nil,nil,0},
[1096] = {'Venture Co. Geologist',773,773,28,29,0,{[33]={{59.17,39.93},{58.94,42.69},{60.58,38.07},{61.41,36.47},{60.01,39.5},{59.63,35.19},{58.84,37.23},{57.3,38.74},{58.98,32.93},{57.86,32.4},{58.4,31.99},{56.04,39.92},{60.12,41.61},{57.69,42.84},{56.87,36.72},{56.76,41.4},{55.54,39.27},{58.33,39.22},{58.25,41.66},{61.05,42.56},{57.98,37.34},{57.35,35.16},{55.41,35.92},{55.54,35.64},{55.35,35.22},{54.45,35.29},{59.91,36.72},{61.19,35.51},{58.32,37.16},{54.59,40.44},{59.69,34.08}},[5339]={{53.87,27.61},{53.02,27.35},{57.68,23.26}}},nil,33,nil,nil,47,nil,nil,0},
[1097] = {'Venture Co. Mechanic',905,905,28,29,0,{[33]={{55.36,35.62},{55.49,35.49},{53.8,34.05},{53.82,34.31}}},nil,33,nil,nil,47,nil,nil,0},
[1098] = {'Watcher Merant',484,484,20,20,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1099] = {'Watcher Gelwin',484,484,20,20,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1100] = {'Watcher Selkin',484,484,20,20,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1101] = {'Watcher Thayer',484,484,20,20,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1103] = {'Eldrin',573,573,22,22,0,{[12]={{79.22,69.03}}},nil,12,nil,nil,12,"A","Tailoring Trainer",81},
[1104] = {'Grundel Harkin',0,0,5,5,0,{[6176]={{61.7,22.06}}},nil,6176,{24477,24486},{24477,24486},55,"A","Armorer",4226},
[1105] = {'Jern Hornhelm',328,328,15,15,0,{[38]={{37.24,47.38}}},nil,38,{273,301,13639},{298,302},55,"A","Explorers' League",2},
[1106] = {'Lost One Cook',3039,3039,54,54,4,{[8]={{62.18,24.72},{62.78,26.41}}},nil,8,nil,nil,51,nil,nil,0},
[1108] = {'Mistvale Gorilla',1427,1498,32,33,0,nil,nil,0,nil,nil,72,nil,nil,0},
[1109] = {'Fleshripper',222,222,11,12,0,{[40]={{35.51,29.35},{33.01,39.87},{31.26,36.38},{55,60.99},{62.89,42.77},{61.21,42.8},{62.32,46.5},{61.97,41.09},{62.32,44.79},{62.66,48.62},{62.09,43.66},{63.62,45.61},{63.72,46.46},{46.59,50.47},{37.02,36.61},{39.2,23.32},{43.82,49.13},{42.98,50.95},{48.72,50.67},{45.78,46.77},{44.98,42.03},{32.9,36.53},{43.44,47},{43.98,44.42},{57.3,35.58},{53.53,37.07},{53.21,24.58},{54.89,24.06},{54.65,25.78},{39.98,20.62},{54.43,25.41},{50.31,30.64},{33.53,40.22},{31.23,37.11},{54.81,60.57},{46.23,50.39},{43.89,49.54},{42.8,50.63},{47.69,54.36},{44.62,53.94},{48.33,50.01},{48.58,56.31},{52,59.33},{50.76,59.82}}},nil,40,nil,nil,73,nil,nil,0},
[1110] = {'Skeletal Raider',840,896,27,28,0,nil,nil,0,nil,nil,21,nil,nil,0},
[1111] = {'Leech Stalker',484,484,20,21,0,{[11]={{56.4,65.16},{56.3,60.84},{55.56,61.53},{57.72,65.62},{55.47,66.7},{56.31,67.86},{57.09,66.82},{57.01,64.16},{55.34,64.35},{57,61.82},{56.32,63.06},{53.32,63.52},{53.28,65.44},{53.71,64.15},{54.7,63.06},{54.71,65.54},{54.01,66.12}}},nil,11,nil,nil,22,nil,nil,0},
[1112] = {'Leech Widow',782,782,21,21,4,{[11]={{47.41,65.64},{46.82,63.86}}},nil,11,nil,nil,22,nil,nil,0},
[1114] = {'Jungle Thunderer',1804,1883,26,27,0,nil,nil,0,nil,nil,72,nil,nil,0},
[1115] = {'Rockjaw Skullthumper',156,156,8,9,0,{[1]={{79.33,50.91},{78.51,49.82},{78.35,56.3},{77.86,56.63},{78.31,56.74},{75.92,58.09},{76.1,58.17},{76.92,58.11},{77.24,58.08},{77.55,57.86},{78.32,48.9},{78.11,51.09},{77.7,56.76},{74.2,57.63},{74.6,57.63},{75.16,57.68},{74.73,57.85},{75.19,57.68},{75.13,58.42},{75.15,58.91},{74.91,59.21},{76.99,56.86},{75.84,56.64},{75.6,57.28},{76.53,57.51},{76.2,57.48},{76.18,57.71},{76.57,56.64},{76.42,58.1},{78.42,53.21},{77.84,55.66},{78.06,52.1},{77.48,56.22},{77.37,55.12},{77.11,55.78},{76.73,55.57},{76.89,55.43},{78.12,53.32},{78.65,50.31},{78.07,51.03},{79.03,49.72}}},nil,1,nil,nil,59,nil,nil,0},
[1116] = {'Rockjaw Ambusher',176,198,9,10,0,nil,nil,0,nil,nil,36,"AH",nil,0},
[1117] = {'Rockjaw Bonesnapper',198,198,9,10,0,{[1]={{80.16,51.8},{79.41,51.6},{79.86,51.87},{80.34,50.66},{79.76,50.91},{79.34,48.15},{79.57,50.27},{77.65,50.54},{78.97,49.38},{78.61,50.05},{78.83,50.11},{79.66,49.62},{77.53,51.65},{77.31,50.99},{75.22,56.71},{74.76,56.88},{77.85,53.91},{78.46,53.2},{77.92,53.09},{78.36,52.16},{78.48,53.18},{77.94,51.61},{77.94,54.93},{78.69,53.57},{78.7,50.34},{78.75,49.79},{78.89,48.77},{78.32,48.9},{79.76,52.02},{79.72,51.11},{80.46,50.65},{77.75,51.64},{78.2,50.49}}},nil,1,nil,nil,59,nil,nil,0},
[1118] = {'Rockjaw Backbreaker',247,247,11,12,0,{[1]={{78.28,56.11},{78.29,56.16}}},nil,1,nil,nil,594,nil,nil,0},
[1119] = {'Hammerspine',264,264,9,9,4,{[1]={{78.7,49.6},{79.34,50.39}}},nil,1,nil,nil,59,nil,nil,0},
[1120] = {'Frostmane Troll',137,156,7,8,0,nil,nil,0,nil,nil,37,nil,nil,0},
[1121] = {'Frostmane Snowstrider',148,166,8,9,0,nil,nil,0,nil,nil,37,nil,nil,0},
[1122] = {'Frostmane Hideskinner',176,198,9,10,0,nil,nil,0,nil,nil,37,nil,nil,0},
[1123] = {'Frostmane Headhunter',156,176,8,9,0,nil,nil,0,nil,nil,37,nil,nil,0},
[1124] = {'Frostmane Shadowcaster',160,178,9,10,0,nil,nil,0,nil,nil,37,nil,nil,0},
[1125] = {'Crag Boar',120,120,5,6,0,{[1]={{43.35,60.74},{42.22,58.92},{43.12,60.17},{42.94,58.24},{43.05,58.32},{46.61,60.62},{58.68,47.6},{45.74,62.71},{54.71,56.94},{58.8,49.84},{47.21,56.6},{51.38,61.58},{51.98,62.34},{46.53,58.22},{58.67,58.1},{62.53,43.16},{59.92,42.33},{47.59,57.2},{54.28,61.41},{47.83,66.85},{53.85,59.79},{56.97,60.32},{53.27,59.84},{48.34,55.61},{46.45,62.67},{47.3,59.34},{52.82,61.63},{51.74,36.55},{51.45,50.52},{50.24,63.87},{49.61,55.07},{44.84,58.36},{52.42,65.66},{52.78,64.36},{49.12,63.18},{52.93,62.15},{49.36,65.6},{59,51.62},{61.95,46.57},{43.6,61.22},{48.53,67.16},{54.41,62.36},{51.45,65.55},{42.45,57.5},{52,60.44},{53.34,63.79},{49.5,65.29},{58.73,51.89},{57.73,41},{45.13,58.87},{59.41,47.32},{43,60.61},{43.09,58.72},{52,63.39},{51.02,64.42},{55.2,56.77},{58.85,48.85},{55,56.98},{58.38,51.35},{58.29,50.88},{42.55,58.61},{61.53,42.85},{46.35,58.23},{51.93,63.39},{47.35,59.77},{54.92,58.91},{60.54,46},{52.01,60.1},{58.66,51.97},{58.76,51.87},{44.09,59.14},{50.9,53.72},{51.3,50.9},{58.37,40.87},{50.91,54.06},{52.8,45.01},{51.67,43.95},{52.23,37.49},{54.62,42.23},{53.55,39.55},{53.36,58.26},{53.56,55.16},{57.3,49.94},{56.39,49.08},{55.93,49.13},{53.91,55},{62.58,46.47},{51.85,55.93},{48.91,58.35},{48.86,58.46},{51.36,57.23},{51.99,54.68},{50.96,56.67},{50.56,58.21},{48.61,58.99},{53.1,58.27},{57.39,44},{52.94,42.76},{52.59,41.35},{56.61,52.95},{55.79,53.55},{55.2,54.07},{57.49,51.98},{55.21,47.37},{50.53,54.72},{56.53,60.47},{56.05,57.51},{55.74,58.71},{62.71,44.36},{59.79,44.15},{58.87,43.82},{55.92,42.84},{60.18,42.38},{61.73,45.1},{57.8,40.78},{61.39,43.25},{60.61,45.92},{52.96,44.62},{51.6,43.48},{63.27,46.84},{57.35,44.13},{52.82,43.1},{63.47,44.37},{60.15,43.92},{58.47,43.35},{56,42.8},{54.95,41.96}}},nil,1,nil,nil,189,"AH",nil,0},
[1126] = {'Large Crag Boar',120,137,6,7,0,nil,nil,0,nil,nil,189,"AH",nil,0},
[1127] = {'Elder Crag Boar',156,156,7,8,0,nil,nil,0,nil,nil,189,"AH",nil,0},
[1128] = {'Young Black Bear',120,144,5,6,0,nil,nil,0,nil,nil,44,nil,nil,0},
[1129] = {'Black Bear',144,164,6,7,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1130] = {'Bjarn',234,234,8,8,4,{[1]={{62.79,56.86},{66.34,59.93}}},nil,1,nil,nil,44,nil,nil,0},
[1131] = {'Winter Wolf',156,156,7,8,0,{[1]={{53.69,38.39}}},nil,1,nil,nil,38,nil,nil,0},
[1132] = {'Timber',0,0,5,5,4,{[6457]={{66.5,36.43}}},nil,6457,nil,nil,38,nil,nil,0},
[1133] = {'Starving Winter Wolf',156,176,8,9,0,nil,nil,0,nil,nil,38,nil,nil,0},
[1134] = {'Young Wendigo',102,120,5,6,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1135] = {'Wendigo',120,137,6,7,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1137] = {'Edan the Howler',274,274,7,7,4,{[1]={{46.05,45.78},{49.29,47.73},{46.3,47.44}}},{[1]={{{38.98,47.47},{39.15,47.46},{39.49,47.43},{39.75,47.41},{40.01,47.34},{40.24,47.12},{40.34,46.76},{40.41,46.53},{40.5,46.24},{40.64,46.01},{40.77,45.84},{40.9,45.68},{41.03,45.52},{40.9,45.83},{40.75,45.96},{40.7,46.04},{40.56,46.24},{40.51,46.62},{40.46,46.93},{40.41,47.17},{40.34,47.5},{40.32,47.73},{40.3,47.95},{40.19,48.05},{40.06,48.18},{39.88,48.38},{39.63,48.53},{39.4,48.66},{39.14,48.81},{38.98,48.9},{38.82,48.8},{38.69,48.52},{38.67,48.18},{38.75,47.89},{38.87,47.67}}}},1,nil,nil,24,nil,nil,0},
[1138] = {'Snow Tracker Wolf',100,137,6,7,0,nil,nil,0,nil,nil,38,nil,nil,0},
[1139] = {'Magistrate Bluntnose',484,484,20,20,0,{[38]={{34.69,43.18}}},nil,38,nil,{256,13648},55,"A",nil,2},
[1140] = {'Razormaw Matriarch',1048,1048,25,25,4,{[11]={{69.98,29.36},{69.92,29.33}},[4922]={{16.01,22.68}}},{[11]={{{69.93,29.21},{69.73,28.98},{69.32,28.78},{69.08,28.77},{68.76,28.75},{68.59,28.43},{68.62,28.1},{68.67,27.66},{68.41,27.54},{68.08,27.65},{67.95,27.69},{67.79,27.83},{67.63,28.13},{67.45,28.47},{67.35,28.85},{67.18,29.36},{67.29,29.8},{67.4,30.28},{67.41,30.62},{67.18,30.74},{67.1,31.06},{67.21,31.36},{67.35,31.53},{67.52,31.8},{67.7,32.19},{67.75,32.26},{67.74,32.06},{67.72,31.79},{67.83,31.49},{67.87,31.15},{67.91,30.85},{67.9,30.41},{67.89,30.07},{67.85,29.92},{67.78,29.82},{67.64,29.61},{67.44,29.2},{67.41,29.03},{67.45,28.67},{67.47,28.57},{67.57,28.34},{67.85,27.73},{68.08,27.6},{68.3,27.68},{68.58,27.82},{68.64,28.04},{68.6,28.31},{68.72,28.82},{69.03,28.88},{69.32,28.94},{69.55,29.08},{69.76,29.21},{69.95,29.33}}}},11,nil,nil,48,nil,nil,0},
[1141] = {'Angus Stern',4120,4120,60,60,0,{[1519]={{51.79,93.6}}},nil,1519,{1271},{212,1271},12,"A","Head Chef",2},
[1142] = {'Mosh\'Ogg Brute',699,699,25,26,0,{[33]={{46.14,53.28},{46.22,53.51},{44.96,54.87},{46.47,54.32},{46.72,53.64}}},nil,33,nil,nil,45,nil,nil,0},
[1144] = {'Mosh\'Ogg Witch Doctor',610,610,25,26,0,{[33]={{44.32,55.51},{45.57,50.13},{44.79,52.55},{46.14,53.88},{46.71,53.88},{45.61,50.88},{46.37,51.1},{44.83,50.88}},[5339]={{46.18,34.88},{46.2,34}}},nil,33,nil,nil,45,nil,nil,0},
[1146] = {'Vharr',1524,1524,40,40,0,{[33]={{38.74,49.07}}},nil,33,nil,nil,29,"H","Superior Weaponsmith",4224},
[1147] = {'Hragran',16764,16764,40,40,0,{[33]={{37.56,50.98}}},nil,33,nil,nil,29,"H","Cloth & Leather Armor Merchant",4224},
[1148] = {'Nerrist',1524,1524,40,40,0,{[33]={{39.26,51.06}}},nil,33,nil,nil,29,"H","Trade Goods",128},
[1149] = {'Uthok',1524,1524,40,40,0,{[33]={{37.47,49.07}}},nil,33,nil,nil,29,"H","General Supplies",640},
[1150] = {'River Crocolisk',750,750,25,26,0,{[33]={{45.75,21.78},{42.09,21.94},{41.3,20.63}},[5339]={{46.1,13.05},{44.66,13.56},{46.21,12.76},{45.16,12.59},{47.7,14.1}}},nil,5339,nil,nil,14,nil,nil,0},
[1151] = {'Saltwater Crocolisk',1403,1469,35,36,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1152] = {'Snapjaw Crocolisk',800,800,26,27,0,{[33]={{45.57,56.35},{51.81,40.16},{53.97,38.55},{52.74,39.25},{52.63,37.67},{52.63,35.45},{51.5,29.01},{52.62,29.4},{50.32,30.4},{54.47,31.46},{53.59,30.3},{53.56,32.73},{52.01,33.12},{50.3,32.94},{52.61,35.47},{51.24,35.72},{52.69,37.76},{50.1,38.95},{53.98,38.59},{52.78,39.27},{51.81,40.13},{52.76,39.26},{51.83,40.13},{45.57,56.49}},[5339]={{50.61,26.93},{50.65,26.97},{50.08,32.6},{49.05,35.18}}},nil,33,nil,nil,14,nil,nil,0},
[1153] = {'Torren Squarejaw',328,328,15,15,0,{[38]={{37.27,47.77}}},nil,38,nil,{13655,13656,13657,13658,13659,13660,13661},55,"A","Explorers' League",2},
[1154] = {'Marek Ironheart',328,328,15,15,0,{[38]={{81.76,61.66}}},nil,38,{27028,27030},{327,385,13647,27028,27030},55,"A",nil,3},
[1155] = {'Kelt Thomasin',328,328,15,15,0,{[38]={{64.39,27.03}}},nil,38,nil,{255,259,260,25119},55,"A",nil,0},
[1156] = {'Vyrin Swiftwind',328,328,15,15,0,{[38]={{81.91,64.62}}},nil,38,{27036},{531,27037},371,"A","Innkeeper",66179},
[1157] = {'Cursed Sailor',787,840,26,27,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1158] = {'Cursed Marine',840,896,27,28,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1159] = {'First Mate Snellig',950,950,29,29,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1160] = {'Captain Halyndor',1003,1003,30,30,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1161] = {'Stonesplinter Trogg',247,247,11,12,0,{[38]={{36.2,83.45},{35.31,82.49},{35.73,80.53},{36.89,84.43},{35.51,84.63},{32,87.1},{34.9,76.68},{34.32,79.45},{35.36,71.07},{29.57,72.84},{31.27,77.35},{31.63,75.46},{31.55,69.53},{29.12,87.26},{32.14,79.55},{30.85,73.91},{32.62,79.84},{29.08,81},{27.99,83.15},{33.95,71.34},{28.24,86.83},{27.95,81.44},{31.44,80.89}}},nil,38,nil,nil,59,nil,nil,0},
[1162] = {'Stonesplinter Scout',247,247,11,12,0,{[38]={{36.38,78.7},{39.18,73.3},{40.1,69.03},{40.43,71.87},{42.21,70.13},{33.22,88.25},{37.53,74.76},{35.03,72.73},{30.85,71.93},{33.57,74.14},{28.78,85.52},{32.11,75.78},{32.32,71.94},{33.43,77.64},{30.19,84.06},{30.11,80.07}}},nil,38,nil,nil,59,nil,nil,0},
[1163] = {'Stonesplinter Skullthumper',273,300,13,14,0,nil,nil,0,nil,nil,59,nil,nil,0},
[1164] = {'Stonesplinter Bonesnapper',247,247,11,12,0,{[38]={{35.58,61.74},{34.65,62.11},{33.82,66.89},{36.06,58.31},{35.25,61.66},{35.08,59.65},{33.28,59.06},{35.88,62.85},{36.78,60.41}}},nil,38,nil,nil,59,nil,nil,0},
[1165] = {'Stonesplinter Geomancer',307,307,15,16,0,{[38]={{65.18,62.8},{72.58,63.38},{72.63,61.87},{66.71,57.47},{68.93,62.98},{72.68,64.18},{66.99,63.49},{72.55,68.83},{70.63,64.78},{68.02,66.07},{69.05,59.73},{71.85,68.81},{65.15,57.59},{72.58,63.33},{73.07,63.35},{67.09,58.71},{68.97,62.95},{72.94,64.14},{66.9,63.43},{72.54,68.76},{68.76,56.52},{69.42,67.94},{65.09,57.5},{67.26,58.99},{69.4,58.84}}},nil,38,nil,nil,59,nil,nil,0},
[1166] = {'Stonesplinter Seer',253,276,13,14,0,nil,nil,0,nil,nil,59,nil,nil,0},
[1167] = {'Stonesplinter Digger',356,356,15,16,0,{[38]={{72.42,66.55},{68.69,62.41},{69.39,67.19},{70.17,59.74},{65.21,63.12},{72.52,66.73},{71.35,63.96},{70.61,59.97},{70.04,62.96},{68.46,59.76},{67.44,63.22},{66.51,68.78},{72.59,64.81},{70.47,65.31},{69.02,66.06},{66.88,59.89},{71.01,68.32},{68.6,68.43},{72.53,66.52},{70.09,59.64},{65.36,60.72},{72.5,66.88},{68.46,59.74},{67.24,63.22},{72.62,64.95},{69.94,65.41},{67.29,59.86},{71.22,67.81},{68.62,68.41},{69.83,60.23},{65.3,61.1},{68.43,60.14},{67.11,60.34}}},nil,38,nil,nil,59,nil,nil,0},
[1169] = {'Dark Iron Insurgent',417,449,18,19,0,nil,nil,0,nil,nil,54,nil,nil,0},
[1171] = {'Dark Iron Guerrilla',5000,5000,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1172] = {'Tunnel Rat Vermin',273,273,12,13,0,{[38]={{23.02,29.7},{23.42,28.03},{24.63,23.22},{24.92,34.12},{24.53,32.1},{24.24,29.03},{26.29,26.99},{25.4,29.44},{25.85,24.7},{24.58,30.42},{26.39,27.11},{25.79,24.67}}},nil,38,nil,nil,26,nil,nil,0},
[1173] = {'Tunnel Rat Scout',273,273,12,13,0,{[38]={{22.29,28.89},{24.14,25.01},{23.66,21.85},{23.03,23.51},{26.06,35.99},{28.94,38.11},{24.8,36.01},{28.77,36.09},{25.19,26.79},{26.37,32.55},{27.2,28.76},{26.64,30.39},{24.08,26.6},{25.14,26.82},{27.32,28.68}}},nil,38,nil,nil,26,nil,nil,0},
[1174] = {'Tunnel Rat Geomancer',241,241,12,13,0,{[38]={{36.65,20.86},{35.83,24.47},{35.22,24.91},{36.27,23.19},{35.62,20.8},{34.81,26.3},{35.66,22.82},{35.76,18.35},{34.31,26.94},{35.73,19.42},{36.05,22.2},{36.46,26.19},{35.19,27.74},{35.04,23.7},{35.51,24.1}}},nil,38,nil,nil,26,nil,nil,0},
[1175] = {'Tunnel Rat Digger',247,273,12,13,0,nil,nil,0,nil,nil,26,nil,nil,0},
[1176] = {'Tunnel Rat Forager',247,247,12,13,0,{[38]={{37.26,24.36},{37.83,25.71},{39.96,12.14},{38.49,19.19},{38.68,16.26},{37.42,18.13},{30.84,24.39},{31.32,26.67},{39.16,12.83},{32.42,26.22},{38.18,23.13},{37.03,26.58},{30.75,16.32},{32.16,14.12},{29.76,12.54},{35.51,17.39},{36.58,14.34},{38.56,14.61},{36.73,12.54},{29.3,10.37},{35.1,10.95},{39.96,12.23},{38.67,16.48},{39.15,12.95},{38.43,14.63},{36.73,12.7},{30.94,24.6},{31.32,26.63},{32.43,26.22},{30.69,16.21},{29.74,12.63},{29.25,10.34}}},nil,38,nil,nil,26,nil,nil,0},
[1177] = {'Tunnel Rat Surveyor',273,273,12,13,0,{[38]={{36.9,24.86},{36.35,23.39},{37.87,13.06},{31.72,23.62},{35.47,13.08},{30.7,22.82},{33.7,27.5},{37.52,16.25},{37.27,16.26},{28.85,16.42},{31.34,11.25},{32.35,16.37},{32.28,12.35},{29.71,14.68},{31.67,18.34},{31.11,14.23},{33,18.15},{34.27,17.7},{35.57,14.6},{34.91,16.26},{33.67,11.64},{37.9,12.97},{31.71,23.63},{30.68,22.83},{33.68,27.55},{28.82,16.75},{29.73,14.52}}},nil,38,nil,nil,26,nil,nil,0},
[1178] = {'Mo\'grosh Ogre',417,449,18,19,0,nil,nil,0,nil,nil,45,nil,nil,0},
[1179] = {'Mo\'grosh Enforcer',377,404,18,19,0,nil,nil,0,nil,nil,45,nil,nil,0},
[1180] = {'Mo\'grosh Brute',449,484,19,20,0,{[38]={{72.59,20.9}}},nil,38,nil,nil,45,nil,nil,0},
[1181] = {'Mo\'grosh Shaman',377,404,18,19,0,nil,nil,0,nil,nil,45,nil,nil,0},
[1182] = {'Brother Anton',1848,1848,45,45,0,{[405]={{62.06,91.21}}},nil,405,nil,{261,6141},12,"A","Scarlet Crusade Emissary",0},
[1183] = {'Mo\'grosh Mystic',404,433,19,20,0,nil,nil,0,nil,nil,45,nil,nil,0},
[1184] = {'Cliff Lurker',273,300,13,14,0,nil,nil,0,nil,nil,22,nil,nil,0},
[1185] = {'Wood Lurker',386,417,17,18,0,nil,nil,0,nil,nil,22,nil,nil,0},
[1186] = {'Black Bear',247,247,11,12,0,{[38]={{40.36,10.29},{37.22,9.3},{40.87,16.06},{42.24,65.28},{24.86,14.39},{46.47,65.19},{45.41,68.98},{35.37,33.15},{37.61,55.82},{41.84,54.02},{42.58,59.77},{40.47,49.92},{39.2,50.71},{38.13,38.29},{38.1,31.22},{40.2,30.54},{39.86,33.08},{30.34,27.69},{36.73,29.21},{39.96,24.41},{40.29,26.59},{32.63,28.42},{30.52,20.56},{29.52,24.79},{34.91,28.7},{27.63,20.59},{29.12,22.29},{37.67,33.48},{27.61,13.91},{28.79,33.95},{28.43,31.15},{28.88,50.76},{28.97,46.57},{30.13,56.43},{37.21,39.45},{32.07,34.38},{36.43,36.8},{33.89,35.67},{36.92,36.31},{37.97,49.59},{37.99,49.43},{46.53,65.2},{40.33,10.34},{37.43,9.16},{40.97,16.27},{46.31,65.26},{24.87,14.32},{34.93,32.83},{38.07,38.21},{38.37,31.06},{40.17,30.81},{39.7,33.25},{36.72,29.01},{40.33,26.5},{30.53,20.56},{29.61,24.97},{34.67,28.56},{27.54,20.82},{29.03,22.14},{37.51,33.43},{27.72,14.07},{37.24,39.2},{31.95,34.34},{36.3,37.27},{33.92,35.61},{37.24,36.21}}},nil,38,nil,nil,44,nil,nil,0},
[1187] = {'Daryl the Youngling',328,328,15,15,0,{[38]={{83.49,65.4}}},nil,38,{27016,27037},{257,258,271,27016,27036},55,"A",nil,2},
[1188] = {'Grizzled Black Bear',328,360,13,14,0,nil,nil,0,nil,nil,44,nil,nil,0},
[1189] = {'Black Bear Patriarch',427,463,16,17,0,nil,nil,0,nil,nil,44,nil,nil,0},
[1190] = {'Mountain Boar',198,222,10,11,0,nil,nil,0,nil,nil,189,"AH",nil,0},
[1191] = {'Mangy Mountain Boar',300,328,14,15,0,nil,nil,0,nil,nil,189,"AH",nil,0},
[1192] = {'Elder Mountain Boar',356,386,16,17,0,nil,nil,0,nil,nil,189,"AH",nil,0},
[1193] = {'Loch Frenzy',247,273,12,13,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1194] = {'Mountain Buzzard',328,356,15,16,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1195] = {'Forest Lurker',247,247,11,12,0,{[38]={{40.57,19.01},{39.02,11.11},{37.5,11.32},{40.9,51.93},{27.72,11.04},{32.67,31.19},{37.33,52.5},{43.8,62.65},{43.02,56.14},{47.34,67.76},{38.75,40},{44.27,66.23},{33.39,54.36},{33.38,33.51},{33.76,30.59},{34.44,39.53},{39.59,28.58},{35.5,30.24},{31.64,30.24},{40.79,57.39},{39.76,53.35},{40.18,36.13},{40.56,22.2},{27.29,16.92},{27.76,33.17},{30.39,51.75},{25.97,38.36},{30.21,47.01},{30.11,54.1},{29.03,48.8},{30.77,41.82},{32.49,36.94},{29.87,44.48},{34.78,52.77},{35.27,42},{36.11,50.83},{39.13,47.8},{33.72,42.2},{39.11,44.43},{36.08,50.98},{34.75,52.65},{34.98,41.76},{33.74,41.79},{39.28,47.89},{38.9,43.95},{43.94,62.74},{40.54,19.09},{39.06,11.1},{37.44,11.1},{40.33,22.18},{27.71,11.07},{32.52,31.46},{38.85,40.3},{33.12,33.36},{33.83,30.48},{35.76,30.47},{31.57,30.07},{40.2,35.74},{27.16,16.68}}},nil,38,nil,nil,22,nil,nil,0},
[1196] = {'Ice Claw Bear',164,164,7,8,0,{[1]={{73.32,47.5},{66.35,60.65},{68.53,58.14},{66.53,58.57},{70.68,58.71},{73.93,47.87},{65.13,56.67},{67,54.71},{72.08,58.31},{66.14,55.76},{69.23,56.5},{67.17,56.36},{65.71,57.18},{68.63,54.83},{67.64,58.48},{67.72,57.02},{69.74,54.44},{70.77,54.88},{70.63,52.54},{70.08,56.66},{72.91,49.74},{69.32,53.91}}},nil,1,nil,nil,44,nil,nil,0},
[1197] = {'Stonesplinter Shaman',208,208,11,11,0,{[38]={{36.59,64.35},{34.05,68.34},{33.84,59.47},{33.21,61.39},{32.03,61.74},{34.92,60.74},{35.27,65.04},{34.27,66.31},{35.65,61.02}}},nil,38,nil,nil,59,nil,nil,0},
[1198] = {'Rallic Finn',417,417,18,18,0,{[12]={{83.28,66.09}}},nil,12,nil,nil,12,"A","Bowyer",4224},
[1199] = {'Juvenile Snow Leopard',102,120,5,6,0,nil,nil,0,nil,nil,66,nil,nil,0},
[1200] = {'Morbent Fel',3609,3609,32,32,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1201] = {'Snow Leopard',156,156,7,8,0,{[1]={{54.52,38.54},{89.41,36.37}}},nil,1,nil,nil,66,nil,nil,0},
[1202] = {'Tunnel Rat Kobold',222,247,11,12,0,nil,nil,0,nil,nil,26,nil,nil,0},
[1203] = {'Watcher Sarys',2300,2300,35,35,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1204] = {'Watcher Corwin',4185,4185,38,38,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1205] = {'Grawmug',386,386,17,17,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1206] = {'Gnasher',356,356,16,16,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1207] = {'Brawler',356,356,16,16,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1210] = {'Chok\'sul',1686,1686,22,22,1,nil,nil,0,nil,nil,45,nil,nil,0},
[1211] = {'Leper Gnome',150,200,8,10,0,nil,nil,0,nil,nil,63,nil,nil,0},
[1212] = {'Bishop Farthing',1753,1753,40,40,0,{[1519]={{49.93,45.99}}},nil,1519,{270},{269},12,"A",nil,3},
[1213] = {'Godric Rothgar',0,0,5,5,0,{[6170]={{31.73,50.69}}},nil,6170,nil,nil,12,"A","Armorer & Shieldcrafter",4224},
[1214] = {'Aldren Cordon',417,417,18,18,0,{[38]={{64.82,66.05}}},nil,38,nil,nil,55,"A","Clothier",4224},
[1215] = {'Alchemist Mallory',787,787,26,26,0,{[12]={{39.84,48.24}}},nil,12,nil,nil,12,"A","Alchemy Trainer",81},
[1216] = {'Shore Crawler',300,300,13,14,0,{[40]={{29.51,79.55},{28.73,76.99},{37.59,88.8},{29.21,81.06},{29.32,82.74},{29.48,71.97},{28.49,71.81},{29.22,78.28},{29.19,73.27},{30.18,79.29},{29.25,75.29},{28.7,74.7},{29.24,76.74},{29.96,81.81},{30.2,80.37},{36.58,88.73},{36.79,87.68},{26.29,69.06},{25.65,67.07},{27,66.67},{26.29,66.93},{26.48,67.57},{26.76,62.73},{26.08,62.73},{25.57,65.29},{25.53,64.05},{24.87,65.51},{26.11,65.18},{30.77,81.53},{30.78,82.78},{31.41,82.08},{35.68,88.03},{32.14,81.79},{32.01,83.48}}},nil,40,nil,nil,7,"AH",nil,0},
[1217] = {'Glorin Steelbrow',713,713,25,25,0,{[11]={{10.58,60.59}}},nil,11,nil,{270,292,324,526,25819},55,"A",nil,2},
[1218] = {'Herbalist Pomeroy',198,198,10,10,0,{[12]={{39.96,48.39}}},nil,12,nil,nil,12,"A","Herbalism Trainer",81},
[1222] = {'Dark Iron Sapper',386,386,17,17,0,nil,nil,0,nil,nil,54,nil,nil,0},
[1224] = {'Young Threshadon',449,484,19,20,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1225] = {'Ol\' Sooty',772,772,17,17,0,{[38]={{80.38,52.23}}},{[38]={{{42.47,64.67},{41.82,65},{40.5,66.79},{39.85,66.79},{39.75,66.58},{39.83,66.21},{40.49,64.92},{40.91,63.71},{41,62.63},{40.5,61.46},{39.97,61.64},{39.33,62.23},{38.51,62.1},{37.82,62.77},{36.73,60.99},{37.8,62.85},{38.55,62.12},{38.85,62.1},{39.32,62.37},{40.14,61.59},{40.72,61.81},{41.01,62.92},{40.89,63.78},{40.53,64.62},{40.21,65.47},{39.69,66.55},{40.07,66.87},{41.28,66.19},{41.82,65},{42.47,64.67},{43.19,64.77}}}},38,nil,nil,44,nil,nil,0},
[1226] = {'Maxan Anvol',198,198,10,10,0,{[1]={{54.45,50.51}}},nil,1,nil,{5625,5626},55,"A","Priest Trainer",51},
[1227] = {'Rygal Rocknell',25,27,1,1,0,nil,nil,0,nil,{8026},35,"AH","Baby Murloc Redemption Merchant",0},
[1228] = {'Magis Sparkmantle',178,178,10,10,0,{[1]={{54.61,50.4}}},nil,1,nil,nil,875,"A","Mage Trainer",49},
[1229] = {'Granis Swiftaxe',247,247,11,11,0,{[1]={{54.47,50.97}}},nil,1,nil,nil,55,"A","Warrior Trainer",49},
[1231] = {'Grif Wildheart',176,176,12,12,0,{[1]={{52.91,51.37}}},nil,1,nil,{6064,6074,6075,6076,6084,6085},55,"A","Hunter Trainer",51},
[1232] = {'Azar Stronghammer',247,247,12,12,0,{[1]={{54.71,50.39}}},nil,1,nil,nil,55,"A","Paladin Trainer",51},
[1234] = {'Hogral Bakkan',247,247,12,12,0,{[1]={{54.67,50.93}}},nil,1,nil,nil,55,"A","Rogue Trainer",49},
[1236] = {'Kobold Digger',176,176,9,10,0,{[40]={{43.42,25.07},{43.74,25.38},{45.1,22.64},{45.36,20.41},{44.57,24.11},{44.81,22.21},{44.31,25.41},{44.79,23.26},{45.53,21.74},{44.82,19},{44.62,21.08},{45.26,21.14},{44.53,19.57},{45.6,18.16},{46.06,18.26},{44.07,23.33},{44.69,25.84},{44.12,26.18},{44.66,26.72},{45.16,25.49}}},nil,40,nil,nil,26,nil,nil,0},
[1237] = {'Kazan Mogosh',156,156,8,8,0,{[1]={{75.84,52.98}}},nil,1,nil,nil,55,"A","Food & Drink Merchant",640},
[1238] = {'Gamili Frosthide',176,176,9,9,0,{[1]={{52.28,50.25}}},nil,1,nil,nil,55,"A","Cloth & Leather Armor Merchant",4224},
[1239] = {'First Mate Fitzsimmons',1003,1003,30,30,0,{[11]={{10.95,59.74}}},nil,11,{25815,25816},{288,289,25815},12,"A",nil,2},
[1240] = {'Boran Ironclink',156,156,11,11,0,{[1]={{52.26,50.07}}},nil,1,nil,nil,55,"A","Armorer",4224},
[1241] = {'Tognus Flintfire',1003,1003,30,30,0,{[1]={{52.44,50.26}}},{[1]={{{45.34,51.94},{45.32,51.92}}}},1,nil,nil,55,"A","Blacksmithing Trainer",81},
[1242] = {'Karl Boran',1003,1003,30,30,0,nil,nil,0,nil,{279,286},12,"A",nil,0},
[1243] = {'Hegnar Rumbleshot',176,176,8,8,0,{[1]={{47.76,63.53}}},nil,1,nil,{5541},55,"A","Gunsmith",4227},
[1244] = {'Rethiel the Greenwarden',1003,1003,30,30,0,nil,nil,0,nil,{275,276,277,463},12,"A",nil,0},
[1245] = {'Kogan Forgestone',156,156,8,8,0,{[1]={{52.42,50.07}}},{[1]={{{45.35,51.73},{45.32,51.75}}}},1,nil,nil,57,"A",nil,0},
[1246] = {'Vosur Brakthel',1003,1003,30,30,0,{[1537]={{66.33,55.69}}},nil,1537,nil,nil,55,"A","Apprentice Alchemist",1},
[1247] = {'Innkeeper Belm',1003,1003,30,30,0,{[1]={{54.49,50.85}}},nil,1,nil,{26380},55,"A","Innkeeper",66179},
[1249] = {'Quartermaster Hudson',198,198,10,10,0,{[12]={{25.23,74.07}}},nil,12,nil,nil,12,"A","Armorer & Shieldcrafter",4224},
[1250] = {'Drake Lindgren',198,198,10,10,0,{[12]={{83.31,66.69}}},nil,12,nil,nil,12,"A","General & Trade Supplies",640},
[1251] = {'Splinter Fist Firemonger',494,494,22,23,0,{[10]={{38,79.97},{36.78,79.09},{36.69,77.36},{40.21,75.12},{35.21,78.3},{36.48,80.02},{36.04,81.05},{35.1,81.25},{33.64,70.6},{34.31,68.98},{35.71,73.62},{35.99,70.99},{34.68,73.74},{36.89,84.66}}},nil,10,nil,nil,45,nil,nil,0},
[1252] = {'Senir Whitebeard',222,222,9,9,0,{[1]={{53.97,52.08}}},nil,1,nil,{287,420},55,"A",nil,2},
[1253] = {'Father Gavin',328,328,15,15,0,{[1]={{64.9,43.18}}},nil,1,nil,nil,794,"AH","The Argent Dawn",0},
[1254] = {'Foreman Stonebrow',247,247,12,12,0,{[1]={{76.31,54.68}}},nil,1,{432},{432,25933},55,"A","Miners' League",2},
[1255] = {'Prospector Gehn',156,247,11,12,0,nil,nil,0,nil,nil,55,"A","Explorers' League",0},
[1256] = {'Quarrymaster Thesten',198,198,10,10,0,{[1]={{76.39,53.14}}},nil,1,nil,nil,55,"A","Miners' League",0},
[1257] = {'Keldric Boucher',1003,1003,30,30,0,{[1519]={{62.8,75.04}}},nil,1519,nil,nil,12,"A","Alchemy Supplies & Reagents",2177},
[1258] = {'Black Ravager Mastiff',734,787,25,26,0,nil,nil,0,nil,nil,38,nil,nil,0},
[1259] = {'Gobbler',996,996,22,22,0,{[11]={{13.93,37.56}}},nil,11,nil,nil,18,nil,nil,0},
[1260] = {'Great Father Arctikus',0,0,6,6,4,{[6457]={{29.74,68.05}}},nil,6457,nil,nil,37,nil,nil,0},
[1261] = {'Veron Amberstill',198,198,10,10,0,{[1]={{70.64,48.95}}},{[1]={{{63.47,50.56},{63.46,50.63}}}},1,{25905},{25905},55,"A","Ram Breeder",131},
[1262] = {'White Ram X',1605,1605,30,30,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1263] = {'Yarlyn Amberstill',42,42,1,1,0,{[1]={{70.68,49.29}}},nil,1,nil,nil,55,"A",nil,128},
[1265] = {'Rudra Amberstill',198,198,10,10,0,{[1]={{70.28,48.16}}},nil,1,{314},{314},55,"A",nil,2},
[1266] = {'Tundra MacGrann',484,484,20,20,0,nil,nil,0,nil,{312},57,"A",nil,2},
[1267] = {'Ragnar Thunderbrew',1003,1003,30,30,0,{[1]={{53.93,50.68}}},nil,1,{384},{384,4126,4128},55,"A",nil,2},
[1268] = {'Ozzie Togglevolt',198,198,10,10,0,{[1]={{52.98,47.68}}},nil,1,nil,{2926,2927,2962},875,"A",nil,0},
[1269] = {'Razzle Sprysprocket',484,484,20,20,0,{[1]={{53.26,51.92}}},nil,1,{412},{412},875,"A",nil,2},
[1270] = {'Fetid Corpse',562,562,22,22,0,{[10]={{74.98,34.41},{75.12,38.15},{76.46,36.73},{74.78,36.4},{76.73,30.62},{76.43,35.24},{77.43,33.65},{81.5,32.79},{80.55,33.94},{78.17,32.09},{79.06,31.45},{79.85,34.89},{78.48,34.98},{78.42,36.32},{76.72,32.59},{75.14,32.56},{78.81,33.68},{79.84,32.75},{75,34.51},{75.18,37.92},{76.52,36.91},{74.86,36.16},{76.63,30.45},{75.99,34.87},{77.52,33.9},{81.37,32.56},{80.9,33.96},{78.17,32.04},{79.49,31.31},{80.05,34.97},{78.46,35.11},{78.42,36.33},{76.83,32.66},{75.75,33.22},{80.03,32.86}}},nil,10,nil,nil,21,nil,nil,0},
[1271] = {'Old Icebeard',666,666,11,11,1,nil,{[1]={{{38.52,54.16},{38.25,53.98},{37.78,53.69},{37.3,53.28},{37.14,53.23},{37.2,52.91},{37.22,52.51},{37.32,51.92},{37.55,51.61},{37.81,51.16},{37.97,50.82},{37.68,51.36},{37.4,51.75},{37.32,52.18},{37.29,52.57},{37.37,52.94},{37.48,53.44},{37.59,53.54},{37.8,53.68},{38.05,53.84},{38.47,54.12},{38.59,54.23},{38.52,54.17},{38.45,54.13}}}},0,nil,nil,14,nil,nil,0},
[1273] = {'Grawn Thromwyn',198,198,10,10,0,{[1]={{52.39,50.51}}},nil,1,nil,nil,55,"A","Weaponsmith",4224},
[1274] = {'Senator Barin Redstone',6678,6678,80,80,1,{[1537]={{40.37,55.9}}},nil,1537,nil,{291},55,"A",nil,2},
[1275] = {'Kyra Boucher',1003,1003,30,30,0,{[1519]={{63.14,74.84}}},nil,1519,nil,nil,12,"A","Reagents",2177},
[1276] = {'Mountaineer Brokk',1398,1398,25,25,0,{[38]={{26.79,23.09},{25.66,10.65}}},{[38]={{{25.89,10.62},{25.66,10.65},{25.56,11.31},{25.56,11.65},{25.58,12.26},{25.57,12.96},{25.64,13.4},{25.73,14},{25.88,14.71},{25.95,15.11},{25.99,16.01},{26,16.95},{26,17.84},{26.02,18.76},{26.05,19.38},{26.16,20.12},{26.32,21.08},{26.45,21.7},{26.6,22.38},{26.81,23.13},{26.63,22.39},{26.49,21.72},{26.36,21.13},{26.19,20.17},{26.09,19.39},{26.05,18.77},{26.03,17.87},{26.02,16.97},{26.03,16.05},{25.97,15.22},{25.86,14.53},{25.72,13.92},{25.65,13.28},{25.64,12.95},{25.59,12.31},{25.56,11.44},{25.66,11.02}}}},38,nil,nil,57,"A",nil,0},
[1277] = {'Mountaineer Ganin',1398,1398,25,25,0,{[38]={{21.26,17.89}}},{[38]={{{24.27,20.35},{24.81,20.92},{25.48,21.66},{25.97,22.33},{26.65,23.16},{26.03,22.44},{25.38,21.67},{24.89,21.1},{24.3,20.38},{23.65,19.82},{22.83,19.18},{22.18,18.59},{21.35,17.96},{20.48,17.27},{20.03,17.08},{19.46,17.08},{20.04,17.03},{20.92,17.66},{21.56,18.18},{22.66,19.02},{23.48,19.69},{24.07,20.16}}}},38,nil,nil,57,"A",nil,0},
[1278] = {'Mountaineer Stenn',1398,1398,25,25,0,{[38]={{32.25,42.53}}},{[38]={{{31.95,48.81},{32.28,49.27},{32.46,49.42},{32.52,49.61},{32.28,49.74},{32.19,49.44},{31.94,48.82},{31.68,48.31},{31.46,47.83},{31.37,47.33},{31.33,46.71},{31.44,45.39},{31.56,44.77},{31.78,44.02},{32.04,43.39},{32.22,42.82},{32.27,42.15},{32.28,41.32},{32.16,40.91},{31.63,39.88},{31.24,39.04},{31.05,38.28},{30.85,36.92},{31.05,38.29},{31.22,38.91},{31.46,39.53},{31.81,40.25},{32.2,40.97},{32.26,41.28},{32.31,41.83},{32.24,42.64},{32.17,43.08},{31.96,43.57},{31.74,44.11},{31.4,45.69},{31.34,46.66},{31.4,47.43},{31.44,47.77},{31.58,48.1}}}},38,nil,nil,57,"A",nil,0},
[1279] = {'Mountaineer Flint',1398,1398,25,25,0,{[38]={{29.93,31.25},{30.34,33.13},{28.93,28.46}}},{[38]={{{29.59,30.25},{29.81,30.83},{30,31.54},{30.37,33.41},{30.49,34.59},{30.66,35.78},{30.85,37.03},{31.07,38.38},{31.34,39.27},{31.51,39.63},{31.16,38.99},{31,38.05},{30.89,37.31},{30.57,35.08},{30.39,33.48},{30.25,32.74},{29.96,31.3},{29.72,30.63},{29.07,29},{28.69,27.67},{28.54,26.95},{28.09,25.44},{27.78,24.84},{27.22,23.84},{26.89,23.25},{26.68,22.75},{26.5,22.67},{26.54,23.03},{26.85,23.64},{27.37,24.42},{27.86,25.39},{28.18,26.25},{28.54,27.48},{28.89,28.73},{29.37,29.7}}}},38,nil,nil,57,"A",nil,0},
[1280] = {'Mountaineer Droken',1398,1398,25,25,0,{[38]={{30.41,58.31}}},{[38]={{{32.11,52.65},{31.99,53.28},{31.93,53.77},{31.88,54.36},{31.79,54.99},{31.69,55.57},{31.62,56.13},{31.53,56.53},{31.45,56.88},{31.21,57.28},{30.99,57.54},{30.76,57.84},{30.41,58.31},{30.08,58.77},{29.9,59.07},{29.75,59.4},{29.53,60},{30.01,58.89},{30.5,58.21},{31.07,57.53},{31.43,57.01},{31.54,56.65},{31.77,55.03},{31.89,53.98},{32.09,52.75},{32.28,51.43},{32.29,50.58},{32.37,50.36},{32.48,50.26},{32.37,50.36},{32.29,50.58},{32.28,51.43}}}},38,nil,nil,57,"A",nil,0},
[1281] = {'Mountaineer Zaren',1398,1398,25,25,0,{[38]={{25.19,67.71}}},{[38]={{{22.91,70.62},{23.26,70.4},{23.63,69.87},{24.08,69.18},{24.58,68.43},{24.31,68.83},{23.82,69.58},{23.45,70.12},{23.13,70.57},{22.66,70.4},{22.39,70.13},{22.51,70.71},{22.38,71.46},{21.96,72.12},{21.55,72.82},{21.17,73.59},{20.52,75.04},{20.89,74.28},{21.33,73.27},{21.76,72.49},{22.24,71.83},{22.93,70.85}}}},38,nil,nil,57,"A",nil,0},
[1282] = {'Mountaineer Veek',1398,1398,25,25,0,{[38]={{21.37,65.58}}},{[38]={{{21.46,67.04},{21.54,66.52},{21.5,65.92},{21.23,65.03},{20.93,64.4},{20.73,64.11},{20.3,63.49},{20.03,63.1},{19.82,62.9},{20.26,63.39},{20.56,63.85},{20.93,64.33},{21.21,64.83},{21.41,65.66},{21.53,66.25},{21.51,66.77},{21.35,67.59},{21.33,68.22},{21.52,68.73},{21.95,69.21},{22.24,69.94},{22.06,69.45},{21.64,68.81},{21.32,68.11},{21.36,67.55}}}},38,nil,nil,57,"A",nil,0},
[1283] = {'Mountaineer Kalmir',1398,1398,25,25,0,{[38]={{21.02,73.89}}},{[38]={{{21.6,72.77},{21.96,72.2},{22.45,71.52},{21.86,72.34},{21.41,73.12},{21.16,73.54},{20.72,74.63},{20.46,75.17},{20.13,75.75},{19.88,76.28},{19.73,76.71},{19.64,77.1},{19.55,77.79},{19.52,78.51},{19.46,79.13},{19.36,79.94},{19.23,80.69},{19.09,81.42},{18.87,82.22},{18.62,82.78},{18.41,83.22},{18.04,83.47},{18.38,83.31},{18.73,82.57},{18.91,82.05},{19.07,81.47},{19.24,80.55},{19.42,79.41},{19.52,78.59},{19.55,77.63},{19.64,77.06},{19.76,76.62},{19.9,76.19},{20.46,75.18},{20.75,74.58},{21.02,73.89},{21.31,73.29}}}},38,nil,nil,57,"A",nil,0},
[1284] = {'Archbishop Benedictus',106800,106800,60,60,1,{[1519]={{50.31,45.48}}},nil,1519,nil,{293,3636},12,"A",nil,0},
[1285] = {'Thurman Mullby',1003,1003,30,30,0,{[1519]={{64.84,72.17}}},nil,1519,nil,nil,12,"A","General Goods",641},
[1286] = {'Edna Mullby',1003,1003,30,30,0,{[1519]={{64.73,71.26}}},nil,1519,nil,nil,12,"A","Trade Supplies",129},
[1287] = {'Marda Weller',1003,1003,30,30,0,{[1519]={{64.07,68.36}}},nil,1519,nil,nil,12,"A","Weapons Merchant",4481},
[1289] = {'Gunther Weller',1003,1003,30,30,0,{[1519]={{64.21,68.6}}},nil,1519,nil,nil,12,"A","Weapons Merchant",4225},
[1291] = {'Carla Granger',1003,1003,30,30,0,{[1519]={{62.02,67.79}}},nil,1519,nil,nil,12,"A","Cloth Armor Merchant",4224},
[1292] = {'Maris Granger',1342,1342,35,35,0,{[1519]={{72.14,62.21}}},nil,1519,nil,nil,12,"A","Skinning Trainer",81},
[1293] = {'Ambo Cash',14357,14357,75,75,0,{[65]={{85.94,50.87}}},nil,65,{12455,12457,12463,12466},{12326,12455,12457,12465},1892,"A",nil,2},
[1294] = {'Aldric Moore',1003,1003,30,30,0,{[1519]={{61.91,67.18}}},nil,1519,nil,nil,12,"A","Mail Armor Merchant",4225},
[1295] = {'Lara Moore',1003,1003,30,30,0,{[1519]={{61.97,67.47}}},nil,1519,nil,nil,12,"A","Leather Armor Merchant",4225},
[1296] = {'Felder Stover',3293,3293,54,54,0,{[46]={{72.9,65.76}}},nil,46,nil,nil,12,"A","Weaponsmith",4224},
[1297] = {'Lina Stover',1003,1003,30,30,0,{[1519]={{58.72,68.72}}},nil,1519,nil,nil,12,"A","Bow & Gun Merchant",4225},
[1298] = {'Frederick Stover',1003,1003,30,30,0,{[1519]={{58.35,69.03}}},nil,1519,nil,{27344},12,"A","Bow Merchant",4227},
[1299] = {'Lisbeth Schneider',1003,1003,30,30,0,{[1519]={{58.3,67.15}}},nil,1519,nil,nil,12,"A","Clothier",4225},
[1300] = {'Lawrence Schneider',713,713,25,25,0,{[1519]={{53.48,81.47}}},nil,1519,nil,nil,12,"A","Apprentice Tailor",1},
[1301] = {'Julia Gallina',1003,1003,30,30,0,{[1519]={{59.93,77.7}}},nil,1519,nil,nil,12,"A","Wine Vendor",641},
[1302] = {'Bernard Gump',1003,1003,30,30,0,{[1519]={{69.24,71.84}}},nil,1519,nil,nil,12,"A","Florist",129},
[1303] = {'Felicia Gump',1003,1003,30,30,0,{[1519]={{69.37,71.3}}},nil,1519,nil,nil,12,"A","Herbalism Supplies",129},
[1304] = {'Darian Singh',1003,1003,30,30,0,{[1519]={{42.44,76.93}}},nil,1519,nil,nil,12,"A","Fireworks Vendor",129},
[1305] = {'Jarel Moor',1003,1003,30,30,0,{[1519]={{41.97,82.73}}},nil,1519,nil,nil,12,"A","Bartender",641},
[1307] = {'Charys Yserian',2769,2769,50,50,0,{[1519]={{44.58,86.23}}},nil,1519,nil,nil,12,"A","Arcane Trinkets Vendor",2177},
[1308] = {'Owen Vaughn',1003,1003,30,30,0,{[1519]={{47.44,82.46}}},nil,1519,nil,nil,12,"A","Reagents",2177},
[1309] = {'Wynne Larson',1003,1003,30,30,0,{[1519]={{51.84,83.51}}},nil,1519,nil,{1921,1940,1941,1942},12,"A","Robe Merchant",4227},
[1310] = {'Evan Larson',1003,1003,30,30,0,{[1519]={{52.66,83.68}}},nil,1519,nil,nil,12,"A","Hatter",4225},
[1311] = {'Joachim Brenlow',1003,1003,30,30,0,{[1519]={{51.45,94.1}}},nil,1519,nil,nil,12,"A","Bartender",641},
[1312] = {'Ardwyn Cailen',1003,1003,30,30,0,{[1519]={{52.86,74.82}}},nil,1519,nil,nil,12,"A","Wand Merchant",4225},
[1313] = {'Maria Lumere',1003,1003,30,30,0,{[1519]={{55.89,85.63}}},nil,1519,nil,nil,12,"A","Alchemy Supplies",129},
[1314] = {'Duncan Cullen',1003,1003,30,30,0,{[1519]={{53.18,82.04}}},nil,1519,nil,nil,12,"A","Light Armor Merchant",4225},
[1315] = {'Allan Hafgan',1003,1003,30,30,0,{[1519]={{53.01,74.9}}},nil,1519,nil,nil,12,"A","Staves Merchant",4225},
[1316] = {'Adair Gilroy',4120,4120,60,60,0,{[1519]={{51.83,75.08}}},nil,1519,nil,nil,12,"A","Librarian",128},
[1317] = {'Lucan Cordell',1342,1342,35,35,0,{[1519]={{52.9,74.46}}},nil,1519,nil,{27354,27355,27361,27362,27363},12,"A","Enchanting Trainer",83},
[1318] = {'Jessara Cordell',1003,1003,30,30,0,{[1519]={{52.8,74.25}}},nil,1519,nil,nil,12,"A","Enchanting Supplies",129},
[1319] = {'Bryan Cross',1003,1003,30,30,0,{[1519]={{69.19,57.64}}},nil,1519,nil,nil,12,"A","Shield Merchant",4225},
[1320] = {'Seoman Griffith',1003,1003,30,30,0,{[1519]={{71.86,61.98}}},nil,1519,nil,nil,12,"A","Leather Armor Merchant",4225},
[1321] = {'Alyssa Griffith',1003,1003,30,30,0,{[1519]={{71.69,62.21}}},nil,1519,nil,nil,12,"A","Bag Vendor",129},
[1322] = {'Maxton Strang',1524,1524,40,40,0,{[405]={{67.93,8.31}}},nil,405,nil,nil,12,"A","Mail Armor Merchant",4224},
[1323] = {'Osric Strang',1003,1003,30,30,0,{[1519]={{77.17,60.99}}},nil,1519,{26395},{6281,26394},12,"A","Heavy Armor Merchant",4227},
[1324] = {'Heinrich Stone',1003,1003,30,30,0,{[1519]={{77.22,57.36}}},nil,1519,nil,nil,12,"A","Blade Merchant",4225},
[1325] = {'Jasper Fel',1003,1003,30,30,0,{[1519]={{80.41,60.86}}},nil,1519,nil,nil,12,"A","Shady Dealer",1153},
[1326] = {'Sloan McCoy',713,713,25,25,0,{[1519]={{81.27,62.92}}},nil,1519,nil,nil,12,"A","Poison Supplies",1153},
[1327] = {'Reese Langston',1003,1003,30,30,0,{[1519]={{76.29,53.03}}},nil,1519,nil,nil,12,"A","Tavernkeeper",641},
[1328] = {'Elly Langston',4120,4120,60,60,0,{[1519]={{75.64,53.23}}},{[1519]={{{76.83,53.01},{77.06,53.45},{76.94,53.83},{76.44,54.3},{76.48,54.54},{76.71,54.56},{77.07,54.11},{77.46,53.65},{77.58,53.51},{77.55,53.13},{76.88,52.16},{76.75,52.13},{76.4,52.54},{75.98,53.11},{75.94,53.48},{76.11,53.51},{76.61,52.93}}}},1519,nil,nil,12,"A","Barmaid",640},
[1329] = {'Mountaineer Naarh',1398,1398,25,25,0,{[38]={{21.74,76.84}}},{[38]={{{23.24,76.04},{23.17,76.49},{22.82,77.12},{22.29,77.31},{21.96,77.07},{21.58,76.58},{21.19,76.07},{20.69,75.46},{21.22,76.13},{21.55,76.54},{22.06,77.2},{22.44,77.32},{22.76,77.15},{23.24,76.49}}}},38,nil,nil,57,"A",nil,0},
[1330] = {'Mountaineer Tyraw',1398,1398,25,25,0,{[38]={{22.85,74.06}}},{[38]={{{22.85,74.06},{22.8,74.36},{22.86,74.55},{23,74.57},{23.31,74.25},{23.37,74.03},{23.23,73.7},{23.08,73.63},{22.98,73.71},{23,73.94},{23.3,74.54},{23.84,75.75},{23.31,74.55},{23.01,73.94},{22.99,73.75},{23.11,73.63},{23.24,73.72},{23.37,74},{23.31,74.24},{23,74.57},{22.85,74.54},{22.8,74.33}}}},38,nil,nil,57,"A",nil,0},
[1331] = {'Mountaineer Luxst',1398,1398,25,25,0,{[38]={{24.17,17.57}}},nil,38,nil,nil,57,"A",nil,0},
[1332] = {'Mountaineer Morran',1398,1398,25,25,0,{[38]={{23.63,16.75},{23.91,16.53}}},{[38]={{{23.35,17.03},{23.49,16.83},{23.67,16.67},{24.01,16.43},{24.4,16.34},{24.79,16.42},{25.05,16.56},{25.29,16.76},{25.52,16.99},{25.72,17.16},{25.52,16.99},{25.29,16.76},{25.08,16.58},{24.79,16.43},{24.42,16.34},{24.03,16.42},{23.7,16.65},{23.51,16.81},{23.36,16.99},{23.29,17.12},{23.28,17.29},{23.29,17.76},{23.5,17.88},{23.64,17.91},{24,17.94},{24.24,17.95},{24.46,17.96},{24.74,18},{24.76,18},{24.82,17.92},{24.8,17.75},{24.74,17.58},{24.67,17.49},{24.74,17.58},{24.8,17.75},{24.83,17.9},{24.77,18},{24.57,17.99},{24.25,17.95},{24,17.93},{23.72,17.91},{23.43,17.93},{23.3,17.8},{23.27,17.6},{23.28,17.3},{23.28,17.15}}}},38,nil,nil,57,"A",nil,0},
[1333] = {'Gerik Koen',1003,1003,30,30,0,{[1519]={{73.01,57.45}}},nil,1519,nil,nil,12,"A","Two Handed Weapon Merchant",4225},
[1334] = {'Mountaineer Hammerfall',1398,1398,25,25,0,{[38]={{24.49,18.5}}},nil,38,nil,nil,57,"A",nil,0},
[1335] = {'Mountaineer Yuttha',1398,1398,25,25,0,{[38]={{24.74,17.71}}},nil,38,nil,nil,57,"A",nil,0},
[1336] = {'Mountaineer Zwarn',1398,1398,25,25,0,{[38]={{25.62,18.11}}},nil,38,nil,nil,57,"A",nil,0},
[1337] = {'Mountaineer Gwarth',1398,1398,25,25,0,{[38]={{35.93,44.49}}},nil,38,nil,nil,57,"A",nil,0},
[1338] = {'Mountaineer Dalk',1398,1398,25,25,0,{[38]={{36.44,41.27}}},nil,38,nil,nil,57,"A",nil,0},
[1339] = {'Mayda Thane',1003,1003,30,30,0,{[1519]={{71.69,58.19}}},nil,1519,nil,nil,12,"A","Cobbler",4225},
[1340] = {'Mountaineer Kadrell',1398,1398,25,25,0,{[38]={{35.07,46.58}}},{[38]={{{34.17,47.84},{33.61,48.68},{33.19,49.21},{32.93,49.47},{32.67,49.72},{32.97,49.5},{33.33,49.12},{33.79,48.49},{34.25,47.72},{34.67,47.22},{35.1,46.96},{35.62,46.73},{36.06,46.39},{36.45,46.25},{36.83,46.18},{37.17,45.97},{37.29,45.73},{37.34,45.27},{37.37,44.54},{37.31,43.42},{36.98,42.5},{36.73,41.98},{37.06,42.69},{37.25,43.18},{37.31,43.77},{37.35,44.52},{37.39,45.07},{37.36,45.55},{37.22,45.89},{36.96,46.16},{36.54,46.25},{36.09,46.33},{35.84,46.54},{35.51,46.79},{35.06,46.92},{34.55,47.29}}}},38,{13636,26842,26927,26932},{414,26176,26842,26864,26932},55,"A",nil,3},
[1341] = {'Wilhelm Strang',1003,1003,30,30,0,{[1519]={{77.51,61.3}}},nil,1519,nil,nil,12,"A","Mail Armor Merchant",4225},
[1342] = {'Mountaineer Rockgar',1398,1398,25,25,0,{[38]={{25.44,10.38}}},nil,38,nil,{468},55,"A",nil,0},
[1343] = {'Mountaineer Stormpike',1398,1398,25,25,0,{[38]={{25.45,17.96}}},nil,38,{1338,26137,26843,26844,26845,26863,26864},{307,353,416,1339,13636,26843,26844,26845,26863,27116},55,"A",nil,2},
[1344] = {'Prospector Ironband',328,328,15,15,0,{[38]={{65.34,65.98}}},nil,38,{298,13650},{309,704,707,739,13650},55,"A",nil,2},
[1345] = {'Magmar Fellhew',328,328,15,15,0,{[38]={{64.9,66.66}}},nil,38,{13647,26961},{297,436,26961},55,"A",nil,2},
[1346] = {'Georgio Bolero',2399,2399,46,46,0,{[1519]={{53.08,81.35}}},nil,1519,nil,nil,12,"A","Tailoring Trainer",81},
[1347] = {'Alexandra Bolero',1003,1003,30,30,0,{[1519]={{53.14,81.76}}},nil,1519,nil,nil,12,"A","Tailoring Supplies",129},
[1348] = {'Gregory Ardus',1003,1003,30,30,0,{[1519]={{48.13,55.11}}},nil,1519,nil,nil,12,"A","Staff & Mace Merchant",4225},
[1349] = {'Agustus Moulaine',1003,1003,30,30,0,{[1519]={{53.51,57.56}}},nil,1519,nil,nil,12,"A","Mail Armor Merchant",4225},
[1350] = {'Theresa Moulaine',1003,1003,30,30,0,{[1519]={{53.21,57.93}}},nil,1519,nil,nil,12,"A","Robe Vendor",4225},
[1351] = {'Brother Cassius',1003,1003,30,30,0,{[1519]={{52.41,45.79}}},nil,1519,nil,nil,12,"A","Reagents",2177},
[1352] = {'Fluffy',8,8,1,1,0,{[1]={{70.62,49.33}}},{[1]={{{62.9,50.92},{62.72,51.11},{62.61,51.37},{62.66,51.61},{62.83,51.69},{63.32,50.97},{63.38,50.63},{63.3,50.27},{63.19,49.75},{63.14,49.32},{63.33,49},{63.57,48.91},{64.02,49.34},{64.24,49.62},{64.63,49.81},{64.78,50.15},{64.85,50.41},{65.02,50.54},{65.17,50.47},{65.22,50.23},{65.13,49.93},{64.62,49.8},{64.24,49.6},{64.02,49.34},{63.57,48.91},{63.33,49},{63.15,49.31},{63.19,49.76},{63.3,50.27},{63.3,50.56},{63.17,50.75}}}},1,nil,nil,35,"AH",nil,0},
[1353] = {'Sarltooth',950,950,29,29,0,nil,nil,0,nil,nil,22,nil,nil,0},
[1354] = {'Apprentice Soren',0,0,3,3,0,{[6176]={{43.24,63.11}}},nil,6176,{24489},{24489},55,"A",nil,2},
[1355] = {'Cook Ghilm',176,176,10,10,0,{[1]={{75.62,52.79}}},{[1]={{{68.4,54.45},{68.38,54.49}}}},1,nil,{29347},55,"A","Cooking Trainer",83},
[1356] = {'Prospector Stormpike',1003,1003,30,30,0,{[1537]={{74.64,11.74}}},nil,1537,{302},{301,514,554,2240},55,"A",nil,2},
[1358] = {'Miner Grothor',198,198,9,9,0,{[1]={{76.38,53.54}}},nil,1,nil,nil,57,"A",nil,0},
[1360] = {'Miner Grumnal',156,156,9,9,0,{[1]={{75.76,53.27}}},nil,1,nil,nil,57,"A",nil,0},
[1362] = {'Gothor Brumn',484,484,20,20,0,{[38]={{24.13,18.21}}},nil,38,nil,nil,55,"A","Armorer",4224},
[1364] = {'Balgaras the Foul',850,850,31,31,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1365] = {'Goli Krumn',198,198,10,10,0,{[1537]={{30.26,59.38}}},nil,1537,{7062},nil,55,"A",nil,3},
[1366] = {'Adam',42,42,1,1,0,{[1519]={{54.74,69.05}}},nil,1519,nil,nil,12,"A",nil,0},
[1367] = {'Billy',42,42,1,1,0,{[1519]={{54.74,68.88}}},nil,1519,nil,nil,12,"A",nil,0},
[1368] = {'Justin',42,42,1,1,0,{[1519]={{62.66,50.6},{62.71,50.62},{46.72,58.34}}},nil,1519,nil,nil,12,"A",nil,0},
[1370] = {'Brandon',42,42,1,1,0,{[1519]={{62.61,50.48},{62.67,50.45},{46.61,58.34}}},nil,1519,nil,nil,12,"A",nil,0},
[1371] = {'Roman',42,42,1,1,0,{[1519]={{62.68,50.78},{62.75,50.78},{46.59,58.22}}},nil,1519,nil,nil,12,"A",nil,0},
[1373] = {'Jarven Thunderbrew',328,328,15,15,0,{[1]={{54.76,50.98}}},{[1]={{{47.58,52.52},{47.6,52.41},{47.73,52.41},{47.74,52.64},{47.69,52.7},{47.53,52.4},{47.36,52.4},{47.35,52.59},{47.35,52.59},{47.36,52.4},{47.53,52.4},{47.69,52.7},{47.74,52.64},{47.73,52.41},{47.6,52.41},{47.58,52.52},{47.65,52.66},{47.65,52.66}}}},1,nil,{308},55,"A",nil,2},
[1374] = {'Rejold Barleybrew',198,198,10,10,0,{[1]={{54.2,51.17}}},nil,1,{315},{315,318,319,415},55,"A",nil,2},
[1375] = {'Marleth Barleybrew',247,247,12,12,0,{[1]={{54.27,51.28}}},nil,1,nil,{311},55,"A",nil,2},
[1376] = {'Beldin Steelgrill',247,247,12,12,0,{[1]={{57.57,47.4}}},nil,1,nil,{400},55,"A",nil,2},
[1377] = {'Pilot Stonegear',484,484,20,20,0,{[1]={{53.26,51.83}}},nil,1,{313},{466,467},55,"A",nil,2},
[1378] = {'Pilot Bellowfiz',417,417,18,18,0,{[1]={{53.21,51.94}}},nil,1,nil,{317,320},55,"A",nil,2},
[1379] = {'Miran',494,494,12,12,0,{[38]={{56.38,66.09}}},nil,38,nil,{454},1618,"A",nil,2},
[1380] = {'Saean',247,247,12,12,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1381] = {'Krakk',1524,1524,40,40,0,{[33]={{39.06,49.06}}},nil,33,nil,nil,29,"H","Superior Armorer",4224},
[1382] = {'Mudduk',1753,1753,40,40,0,{[33]={{37.14,49.1}}},nil,33,nil,nil,29,"H","Cooking Trainer",81},
[1383] = {'Snarl',1107,1107,31,31,0,{[1637]={{76.29,35.04}}},nil,1637,nil,nil,29,"H","Apprentice Blacksmith",1},
[1384] = {'Z\'tark',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Mining Trainer",64},
[1385] = {'Brawn',1342,1342,35,35,0,{[33]={{37.78,50.49}}},nil,33,nil,nil,29,"H","Leatherworking Trainer",81},
[1386] = {'Rogvar',3398,3398,55,55,0,{[8]={{50.02,56.16}}},nil,8,nil,nil,29,"H","Alchemy Trainer",81},
[1387] = {'Thysta',232470,232470,85,85,1,{[33]={{39.01,51.25}}},nil,33,nil,nil,29,"H","Wind Rider Master",8193},
[1388] = {'Vagash',352,352,9,9,0,{[1]={{69.65,47.32},{69.79,44.37}}},{[1]={{{62.59,46.09},{62.43,46.41},{62.28,46.73},{62.18,47.06},{62.11,47.28},{62.39,48.45},{62.32,48.89},{62.4,48.23},{62.22,47.6},{62.16,47.4},{61.89,47.17},{61.59,47.11},{62.05,47.13},{62.22,46.89},{62.44,46.4},{62.53,46.19},{62.65,45.99}}}},1,nil,nil,24,nil,nil,0},
[1392] = {'Xon',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1393] = {'Berserk Trogg',449,484,19,20,0,nil,nil,0,nil,nil,59,nil,nil,0},
[1395] = {'Ol\' Beasley',198,198,10,10,0,{[1519]={{73.59,60.09}}},nil,1519,nil,nil,12,"A",nil,0},
[1397] = {'Frostmane Seer',148,166,8,9,0,nil,nil,0,nil,nil,37,nil,nil,0},
[1398] = {'Boss Galgosh',534,534,16,16,4,{[38]={{67.95,66.02},{70.37,63.04},{69.49,67.21}}},nil,38,nil,nil,59,nil,"Stonesplinter Chieftain",0},
[1399] = {'Magosh',312,312,11,11,4,{[38]={{68.49,62.47},{30.66,75.46}}},nil,38,nil,nil,59,nil,"Stonesplinter Tribal Shaman",0},
[1400] = {'Wetlands Crocolisk',617,664,23,24,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1401] = {'Test Squirrel',1,1,1,1,0,nil,nil,0,nil,{316,11425},35,"AH",nil,0},
[1402] = {'Topper McNabb',42,42,1,1,0,{[1519]={{60.3,69.01}}},nil,1519,nil,nil,12,"A",nil,0},
[1403] = {'Mogwah',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Warrior Trainer",32},
[1404] = {'Kragg',1524,1524,40,40,0,{[33]={{36.98,50.2}}},nil,33,nil,nil,29,"H","Hunter Trainer",49},
[1405] = {'Morris Lawry',42,42,1,1,0,{[1519]={{53.05,61.97}}},nil,1519,nil,nil,12,"A",nil,0},
[1406] = {'Ghok',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Shaman Trainer",32},
[1407] = {'Sranda',1753,1753,40,40,0,{[3]={{17.42,42.08}}},nil,3,nil,nil,29,"H","Light Armor & Weapons Merchant",4224},
[1408] = {'Thragg',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Warlock Trainer",32},
[1409] = {'Moorah Stormhoof',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Druid Trainer",32},
[1410] = {'Firewing Bloodwarder',4422,4422,63,64,0,{[3519]={{72.18,40.07},{72.42,39.73},{72.58,39.6},{71.09,40.3},{71.43,39.31},{72.93,39.27},{72.48,38.96},{72.75,37.82},{72.58,36.27},{72.18,35.08},{73.73,35.23},{72.75,34.85},{71.7,34.69},{71.45,34.99},{71.59,34.45},{70.08,35.72},{70.22,37.09},{69.55,35.94},{72.03,38.79},{68.58,36.89},{68.08,36.34}}},nil,3519,nil,nil,16,nil,nil,0},
[1411] = {'Ian Strom',1990,1990,47,47,0,{[5287]={{40.52,73.51}}},nil,5287,nil,nil,120,"AH","Rogue Trainer",49},
[1412] = {'Squirrel',8,8,1,1,0,{[10]={{48.23,14.81},{60.09,15.12},{41.32,17.92},{59.95,16.97},{46.85,16.17},{68.41,16.29},{68.28,16.16},{62.9,16.65},{73.36,17.63},{47.58,39.49},{44.05,43},{44.65,35.46},{43.68,34.94},{27.36,25.23},{16.65,23.21},{49.05,34.75},{32.4,24.37},{8.8,30.7},{6.61,34.02},{5.77,36.75},{16.19,23.31},{7.8,45.02},{13.62,25.64},{7.56,29.32},{13.96,25.64},{9.42,30.36},{55.99,14.47},{22.31,25.54},{48.64,14.92},{41.59,18.24},{40.63,19.26},{43.32,18.09},{17.79,22.47},{55.99,14.7},{21.81,25.3},{17.74,22.46},{48.61,14.31},{60.1,14.63},{90.53,11.9},{8.11,44.96}},[11]={{34.3,60.82},{41.98,55.96},{30.41,59.49},{45.25,54.43},{30.7,63.82},{24.2,67.08},{48.53,61.32},{46.08,56.94},{34.64,60.99},{36.65,59.49},{77.73,43.76},{41.9,51.88}},[12]={{54.31,85.7},{58.55,83.16},{35.36,69.14},{32.42,67.16},{32.97,80.74},{26.79,70.42},{24.43,91.16},{28.29,94.01},{33.45,80.95},{23.64,83.02},{59.1,57.64},{43.88,69.35},{54.53,59.57},{62.28,64.98},{55.88,69.88},{59.11,64.23},{60.76,64.35},{64.14,76.21},{67.99,49.74},{71.96,47.58},{59.14,57.71},{64.11,62},{64.25,64.78},{63.69,61.28},{73.15,69.45},{62.06,65},{71.63,41.02},{69.93,42.65},{67.6,62.35},{62.05,60.47},{61.62,65.7},{71.49,65.83},{73.37,62.55},{72.93,38.62},{71.65,37.68},{73.1,38.83},{68.14,49.57},{72.11,47.67},{92.99,74.22},{87.25,62.52},{88.44,69.25},{83.35,83.53},{82.38,81.37},{64.13,75.73},{56.51,82.51},{42.72,91.25},{66.51,81.52},{64.42,79.68},{58.46,82.88},{62.68,77.15},{44.44,69.58},{33.16,80.64},{56.59,82.25},{33.23,80.53},{42.93,91.19},{67.05,81.45},{58.49,82.82},{66.63,81.35},{93.11,73.74},{24.3,91.03},{20.98,75.56},{44.1,67.51}},[15]={{66.48,52.22},{65.3,52.26},{65.91,44.6},{63.75,49.76},{65.8,52.51},{66.45,52.29},{65.3,52.23},{64.18,47.37},{66.91,45.54},{65.91,44.6},{63.68,49.9},{64.89,50.6},{64.74,46.98},{66.92,50.87},{68.31,49.6},{67.04,49.17},{65.83,52.48},{67.95,47.03},{65.81,50.45}},[16]={{35.67,66.02},{29.88,68.61},{31.46,70.46},{50.9,72.05},{29.27,73.26},{26.14,73.45},{32.83,68.57},{34.5,67.65},{25.84,75.07},{24.27,75.2},{33.02,66.4},{14.65,53.7},{14.84,49.13},{17.55,67.35},{15.98,50.91},{12.55,46.35},{14.78,56.8},{12.32,64.7},{13.77,51.26},{13.33,48.02},{13.14,62.61},{14.54,66.36},{10.66,69.99},{31.46,79.45},{27.67,49.83},{14.46,61.01},{26.61,66.23},{13.11,62.18},{23.01,72.77},{26.88,51.74},{17.49,63.24},{26.64,45.44},{27.52,68.39},{15.88,61.36},{25.73,64.1},{15.8,64.39},{29.39,73.49},{27.35,43.31},{31.3,74.56},{28.51,47.32},{24.81,49.98},{32.12,41.39},{27.41,65.23},{25.74,47.03},{30.68,64.08},{29.88,69.21},{29.73,63.24},{26.64,73.08},{29.68,70.31},{37.54,35.96},{22.25,74.45},{23.95,75.69},{24.26,74.33},{22.41,75.31},{25.81,75.1},{25.49,66.23},{25.56,73.51},{33.36,50.84},{33.67,47.7},{27.6,49.75},{37.06,71.45},{34.5,67.34},{26.77,58.72},{39.99,74.68},{52.28,79.03},{34.41,78.47},{36.01,70.42},{39.33,77.12},{27.02,52.22},{40.63,78.88},{39.58,70.87},{44.67,70.76},{32.03,66.48},{43.96,78.98},{46.22,71.69},{32.41,68.98},{31.13,74.43},{48.4,76.76},{50.99,72.55},{35.25,78.54},{24.63,49.94},{25.93,46.95},{32.78,68.49},{31.38,64.45},{40.82,73.1},{29.61,68.68},{42.72,81.02},{30.19,63.53},{29.86,69.88},{46.59,76.66},{48.07,27.25},{52.08,29.31},{35.71,29.17},{43.31,30.51},{44.48,31.23},{40.74,32.36},{50.43,21.66},{41.7,20.98},{34.12,33.15},{40.32,24.96},{41.94,18.79},{42.37,28.68},{43.67,16.31},{45.73,26.38},{35.26,31.68},{43.83,22.29},{32.08,41.42},{46.07,27.68},{38.2,35.26},{44.26,31.15},{38.11,21.83},{50.28,21.91},{42.35,21.77},{39.4,19.78},{58.16,25.25},{42.4,28.27},{60.39,26.51},{45.53,15.24},{58.77,24.25},{43.76,16.04},{45.49,26.35},{62.79,28.4},{66.97,32.57},{43.76,22.1},{59.06,26.58},{46.1,27.33},{55.78,23.31},{61.39,23.74},{64.43,21.84},{77.41,19.44},{63.41,23.29},{63.71,22.34},{74.88,22.94},{57.48,25.12},{60.99,25.75},{68,21.53},{58.67,24.18},{62.5,28.97},{65.12,27.03},{66.73,32.58},{74.4,25.1},{59.3,26.18},{65.45,30.79}},[17]={{41.05,12.66}},[28]={{51.72,40.4},{37.89,67.1},{38.11,66.53},{52.45,27.88},{40.6,53.8},{57.41,63.38},{43.32,51.94},{43.3,51.63},{30.55,60.62},{51.88,50.57},{47.02,47.27},{47.54,46.66},{47.48,46.67}},[38]={{28.77,39.89},{69.49,70.98},{38.84,42.41},{39.21,72.73},{30.82,79.26},{39.9,46.81},{59.78,62.96},{33.64,87.83},{74.25,53.4},{40.88,52.3},{40.06,13.69},{39.33,75.91},{39.99,73.46},{66.12,51.48},{39.41,48.82},{38.71,36.07},{39.44,23.65},{30.06,75.31},{36.35,47.03},{40.01,70.58},{36.27,79.37},{31.95,16.39},{31.12,32.22},{29.01,86.95},{84.47,61.76},{39.3,48.53},{33.5,51.68},{37.72,41.21},{42.44,70.57},{78.45,69.8},{39.73,45.65},{33.24,79.36},{29.65,84.83},{58.34,67.98},{48.64,71.25},{34.72,74.92},{80.56,58.55},{34.47,52.29},{24.78,14.12},{37.58,43.3},{37.43,47.86},{64,53.18},{28.11,83.23},{68.16,72.58},{30.15,27.18},{73.12,71.87},{19.53,82.79},{35.51,50.93},{36.39,45.21},{34.32,81.5},{35.85,73.51},{28.67,12.12},{29.54,57.76},{80.38,64.43},{36.22,44.46},{46.54,64.96},{41.4,70},{58.68,64.73},{64.21,69.01},{55.38,67.94},{61.16,64.99},{20.67,72.09},{25.88,36.43},{36.58,77.88},{71.28,72.02},{27.87,59.19},{40.57,26.76},{30.07,40.88},{20.84,71.33},{65.22,72.71},{64.58,57.22},{36.8,83.81},{64.42,76.59},{74.35,67.33},{33.75,10.58},{38.58,33.1},{33.89,49.78},{31.83,57.95},{34.62,46.35},{33.62,45.78},{29.27,23.93},{79.98,60.95},{32.35,56.17},{68.53,69.71},{77.63,67.63},{70.89,50.6},{36.44,81.98},{31.97,71.47},{32.54,34.67},{39.07,53.35},{30.89,13.03},{24.01,22.84},{20.37,16.32},{32.3,74.03},{32.45,12.88},{29.43,72.18},{43.87,58.43},{76.06,73.06},{28.95,66.43},{26.17,67.45},{31.97,69.25},{69.85,70.4},{59.33,62.4},{66.13,51.59},{64.83,52.48},{72.84,72.42},{47.05,63.65},{58.19,66.21},{64.16,68.89},{54.95,67.97},{71.25,72.27},{64.34,56.52},{74.26,67.31},{69.5,70},{39.54,13.29},{55.27,37.75},{55.62,33.15},{63.73,48.67},{64.87,52.31},{60.02,36.02},{46.99,66.4},{60.27,37.58},{60.08,41.1},{55.38,40.81},{59,19.57},{74.12,54.35},{65.99,52.39},{39.04,35.05},{30.15,31.97},{64.05,43.39},{38.6,40.92},{64.2,48.6},{24.46,14.37},{64.15,53.71},{30.18,27.17},{27.31,12.44},{60.39,36.24},{60.16,37.7},{60.39,41.43},{64.37,56.2},{59.75,34.67},{39.19,32.79},{29.1,24.86},{70.12,51.3},{33.73,34.88},{58.78,21.23}},[40]={{63.66,24.69},{63.61,45.11},{60.24,11.11},{64.34,46.89}},[130]={{59.65,80.39},{69.07,6.66},{48.75,85.77},{54.53,12.92},{36.19,15.63},{66.49,80.91},{52.9,36.51},{59.73,79.51},{66.33,80.51},{66.43,80.14}},[148]={{41.9,91.05},{40.95,92.56},{39.18,91.33},{40.73,65.97},{40.27,54.92},{42.95,48.12},{39.58,35.81},{49.31,28.97},{43,74.31},{46.57,21.62},{43.6,64.77},{43.2,61.78},{43.89,43.76},{44.46,74.11},{45.53,44.47},{41.75,87.69},{60.3,15.41},{44.51,46.5},{40.92,48.11},{40.36,66.25},{39.33,70.46},{41.54,30.82},{41.81,64.6},{45.84,50.73},{44.29,87.81},{41.87,79.56},{43.17,64.02},{44.01,45.3},{39.84,49.68},{48.63,32.77},{45.95,47.6},{43.41,67.99},{39.97,93.87},{44.15,68.39},{41.71,51.44},{41.35,50.74},{47.29,29.36},{46.21,25.37},{60.17,13.76},{43.25,90.77},{42.89,46.08},{40.64,35.57},{48.83,30.13},{43.07,49.8},{39.76,56.57},{41.26,53.78},{41.74,53.51},{46.49,50.16},{49.21,34.77},{47.37,22.49},{44.53,36.51},{42.39,76.35},{47.97,22.46},{57.1,25.65},{41.26,35.97},{44.9,51.68},{38.06,90.41},{47.08,28.57},{44.33,79.03},{44.96,32.38},{49.02,25.75},{59.91,14.54},{41.21,77.52},{45.25,28.26},{48.73,20.02},{42.24,46.73},{43.25,44.89},{50.54,20.23},{44.26,80.89},{38.68,91.4},{41.02,57.89},{39.5,43.75},{41.88,39.25},{46.79,26.92},{51.51,19.21},{54.57,25.2},{53.96,25.66},{52.81,25.85}},[331]={{88.59,66.78},{87.87,68.84},{75.92,65.86},{76.11,52.08},{80.87,45.6},{90.8,45.85},{85.78,46.2},{86.98,46.21},{90.25,45.41},{88.28,41.18},{90.63,45.41},{81.58,46.41},{82.73,48.75},{77.78,65.59},{90.57,64.92},{90.55,67.58},{86.33,45.07},{72.57,55.95},{75.99,65.63},{64.21,84.66},{76.19,71.12},{63.93,86.04},{74.59,78.47},{78.28,65.71},{73.57,77.6},{61.82,82.83},{67.1,86.87},{65.25,85.69},{64.49,83.73},{61.61,78.77},{63.12,75.78},{61.97,82.66},{65.8,74.12},{67.79,51.39},{66.2,61.04},{67.2,48.98},{63.4,43.68},{71.06,50.23},{63.41,49.68},{63.41,53.71},{58.48,62.97},{66.08,62.71},{64.25,49.46},{65.21,44.05},{56.15,54.18},{69.06,51.74},{66.5,51.89},{66.58,50.89},{64.77,65.34},{55.1,55.19},{62.2,55.11},{66.65,46.84},{59.7,61.99},{69.49,50.15},{63.73,54.32},{64.29,58.43},{57.91,55.61},{64.8,60.04},{62.93,45.8},{43.97,61.42},{63.88,50.19},{63.46,54.11},{58.51,62.99},{64.38,49.7},{42.4,57.72},{44.08,63.37},{56.16,54.16},{55.15,55.27},{62.15,54.71},{60.3,61.59},{63.86,54.34},{58.19,55.53},{55.33,62.58},{56.29,65.31},{54,33.08},{55.87,33.89},{46.76,61.44},{54.35,69.69},{62.72,46.33},{56.5,75.04},{40.37,55.92},{37.85,26.87},{28.84,39.72},{28.52,22.02},{42.17,43.63},{33.93,37.09},{43.76,55.75},{39.16,66.68},{21.94,19.76},{39.82,38.2},{18.3,50.08},{34.75,42.86},{28.96,25.71},{30.24,38.98},{42.55,57.77},{36,69.33},{39.08,67.98},{32.52,27.82},{19.98,49.23},{21.21,47.98},{52.2,66.08},{15.96,45.22},{39.45,41.14},{40.36,71.99},{31.97,29.13},{26.96,49.51},{45.56,43.1},{40.28,69.75},{30.36,26.56},{26.5,47.21},{28.26,43.59},{28.21,18.18},{30.16,16.41},{31.11,43.69},{34.24,45.42},{20.09,17.38},{32.26,40.64},{32.69,26.62},{34.07,34.27},{26.69,16.91},{32.81,39.86},{25.74,22.48},{18.9,22.31},{21.07,30.79},{18.78,34.43},{17.66,20.21},{28.06,27.73},{23.17,34.93},{29.82,18.8},{56.94,30.66}},[357]={{41.46,17.85},{46.81,7.99},{45.22,5.68},{54.03,10.07},{49.8,25.96},{54.06,53.25},{54.42,7.65},{38.27,17.97},{43.05,9.53},{47.31,37.04},{46.19,29.21},{40.3,12.57},{46.62,10.96},{52.61,16.22},{39.82,9.22},{49.54,35.53},{73.95,52.58},{47.28,59.98},{75.63,57.36},{75.51,57.05},{56.19,44.73},{83.44,40.75},{54.76,74},{53.78,71.83},{57.46,65.86},{73.36,35.44},{54.08,66.64},{83.79,42.13},{73.07,49.15},{71.2,57.23},{69.14,56.62},{61.94,69.65},{54.09,53.55},{80.96,44.68},{45.94,38.58},{75.5,56.76},{74.23,50.78},{47.45,37.06},{68.5,59.03},{35.95,32.43},{45.34,35.95},{68.56,55.09},{69.39,50.46},{46.09,66.33},{75.48,58.96},{29.34,52.15},{69.93,41.29}},[493]={{36.03,59.84},{36.75,56.85},{43.33,33.58},{35.03,50.78},{32.08,57.65},{46.06,44},{32.8,60.91},{65.63,57.55},{39.16,48.33},{35.9,65.23},{39.45,33.5},{33.57,58.16},{39.59,55.29},{38.62,64.99},{47.91,65.71},{51.06,46.51},{37.62,45.42},{50.66,36.83},{41.69,42.1},{36.96,66.89},{63.76,65.98},{66.27,50.08},{41.99,61.14},{36.03,47.16},{71.52,60.66},{68.5,54.18},{33.11,44.74},{39.57,29.3},{45.2,59.66},{64.34,69.14},{32.9,40.02},{34.91,65.48},{42.28,52.85},{70.59,57.07},{35.54,54.59},{47.22,64.31},{49.03,43.48},{35.19,33.63},{70.45,50.57},{37.01,36.18},{31.21,49.14},{52.48,71.6},{41.03,40.64},{40.19,60.48},{35.28,39.76},{31.65,32.24},{43.95,35.95},{41.35,57.65},{65.23,50.59},{65.59,56.72},{37.04,54.34},{51.6,66.03},{34.54,44.2},{43.62,58.65},{51.79,66.28},{41.01,63.66},{34.53,61.49},{61.46,66.56},{37.21,43.49},{44.61,56.08},{40.97,56.96},{42.32,35.19},{37.1,69.56},{38.65,31.38},{40.88,44.55},{61.83,50.69},{32.12,52.62},{41.99,32.15},{59.48,33.29},{64.62,62.87},{57.74,28.8},{32.06,56.06},{39.01,68.18},{38.76,47.45},{47.99,62.54},{53.11,30.65},{38.99,44.78},{35.14,54.1},{37.97,62.8},{34.53,58.69},{31.09,53.68},{33.38,55.01},{30.29,54.4},{35.98,50.56},{48.74,32.07},{48.04,33.05},{63.89,46.1},{50.29,33.19},{64.24,60.81},{65.27,61.68},{51.78,64.52},{57.22,65.63},{51.23,62.45},{51.43,63.56},{61.96,69.66},{62.86,64.32},{54.7,29.95},{51.69,38.62}},[495]={{39.85,41.49},{49.13,46.12},{40.99,57.61},{69.72,71.85},{80.47,46.2},{75.55,46.46},{49.51,75.21},{53.45,61.08},{60.63,32.47},{71.78,56.75},{55.7,68.18},{48.93,71.96},{76.55,35.3},{48.77,62.56},{53.21,32.89},{65.69,68.35},{67.92,63.36},{72.64,53.69},{57.44,71.24},{51.43,18.39},{48.1,19.95},{44.12,43.47},{67.07,71.27},{71.86,40.95},{50.64,42.61},{73,65.8},{49.27,64.45},{66.18,36.12},{76.46,67.96},{49.87,60},{50.91,72.25},{30.04,70.4},{30.3,60.45},{76.1,62.85}},[1519]={{76.72,48.24},{59.53,82.96},{69.71,23.78},{85.59,20.35},{58.57,27.14},{49.89,78.25},{54.48,83.74},{53.55,40.92},{79.46,64.44},{51.29,81.09},{47.52,80.4},{46.1,25.96},{42.04,27.93},{49.13,8.05},{43.7,31.57},{48.25,20.82},{41.41,88.69},{44.84,94.77},{39.62,92.76},{46.72,29.44},{57.09,92.78},{48.95,21.81},{59.61,82.87},{46.85,14.19},{48.11,84.71},{77.32,5.88},{77.39,5.77},{46.83,97.82},{45.97,31.76},{51.37,96.27},{55.16,4.86},{85.93,15.15},{69.76,23.86},{84.94,20.99},{69.84,8.67},{43.82,83.5},{44.14,83.24},{50.17,85.27},{43.41,81.9},{44.96,81.36},{50.05,23.34},{44.1,23.43},{63.99,5.89},{69.72,6.51},{49.86,77.85},{39.37,87.01},{54.46,84.66},{53.6,40.96},{51.81,80.57},{50.43,16.97},{49.47,16.63},{48.43,10.92},{56.39,2.09},{53,2.29},{59.64,3.72},{54.28,15.86},{85.33,15.68},{70.65,24.37},{85.09,21.18}},[1657]={{47.15,18.7},{43.19,28.49},{57.14,57.86},{55.24,54.92},{55.97,72.14},{51.37,83.31},{51.9,79.85},{58.9,72.49},{45.08,21.37},{50.12,43.9},{57.8,27.12},{52.19,81.58},{50.89,73.47},{63.23,57.59},{37.13,70.8},{49.63,41},{61.03,66.21},{62.18,60.14},{63.64,62.25},{49.52,68.56},{61.76,72.76},{60.42,72.54},{62.18,62.41},{57.43,42.61},{55.66,29.58},{40.29,31.42},{65.96,54.63},{59.51,29.51},{44.43,47.98},{56.58,66.8},{67,44.57},{55.63,71.37},{54.08,71.09},{49.23,74.98},{42.59,52.36},{36.83,48.4},{41.45,32.25},{47.3,36.88},{44.01,33.69},{50.74,29.55},{57.54,40.27},{53.03,35.34},{61.65,42.28},{43.4,48.47},{43.67,50.78},{52.66,42.94},{53.04,34.28},{39.3,62.03},{40.62,57.67},{53.26,27.37},{51.42,35.55},{57.37,60.94},{53.35,70.46}},[2557]={{-1,-1}},[3518]={{50.19,67.89},{49.59,64.54},{49.54,64.55},{48.13,58.87},{46.54,58.06},{40.39,55.62},{41.14,56.24},{43.74,53.95},{42.47,51.21},{40.35,55.66},{37.53,53.2},{37.06,55.71},{32.26,59.01},{34.26,56.72},{30.81,59.97},{32.38,59.21},{32.26,59.02},{30.82,59.94},{28.32,63.08},{30.79,59.93},{28.19,63.03},{30.78,60.05},{29.18,54.37},{32.27,59.04},{32.38,59.11},{30.83,59.81},{28.32,63.06},{25.06,55.91},{25.19,58.4},{26.08,58.41},{26.98,54.24},{25.05,56.11},{23.86,48.33},{29.47,39.68},{31.06,40.38},{31.11,40.19},{33.64,37.2},{31.12,40.25},{26.96,38.97},{26.83,38.9},{26.83,38.79},{27.85,37.33},{28.39,31.76},{29.55,33.13},{29.88,31.78},{33.77,37.15},{37.12,33.67},{36.3,30.1},{33.73,28.88},{32,30.33},{32.15,25.34},{33.36,23.06},{33.3,22.83},{32.01,20.61},{35.04,17.83},{33.38,23.02},{41,28.02},{38.73,24.95},{38.79,24.91},{38.04,20.32},{47.75,28.38},{49.18,36.96},{64.93,38.05},{66.41,37.5},{72.27,35.8},{72.93,38.43},{70.13,42.21},{69.95,42.93},{66.82,47.64},{67.75,50.3},{64.36,55.37},{73.11,47.78},{73.24,47.66},{70.65,48.21},{70.68,48.29},{70.33,55.39},{74.38,59.36},{74.3,59.3},{74.36,59.29},{69.87,65.17},{69.89,65.24},{72.29,65.2},{74.34,59.21},{72.27,65.22},{69.9,65.26},{72.23,65.24},{76.51,72.47},{68.53,70.03},{68.81,74.05},{54.72,79.27},{55.51,81.24},{52.41,79.16},{51.87,82.17},{52.53,79.29},{51.91,82.07},{55.63,81.09},{52.46,79.25},{54.75,79.34},{52.74,60.03},{52.6,60.05},{48.08,58.77},{42.34,51.16},{37.42,35.49},{35.94,36.18},{35.3,38.08},{37.71,40.23},{45.47,36.21},{68.91,74.1},{72.27,35.49},{72.89,38.38},{74,36.46},{70.66,48.24},{73.28,47.33},{72.32,45.42},{72.89,38.34},{74.06,36.44},{72.28,35.36},{70.11,42.18},{69.92,42.87},{69.45,49.87},{67.52,50.72},{70.15,55.28},{69.25,59.66},{74.38,59.31},{72.24,65.23},{76.46,72.45},{68.94,74.09},{68.5,70.26},{65.57,66.25},{59.92,69.95},{59.81,73.07},{49.36,72.94},{52.4,79.21},{51.88,82.16},{54.74,79.21},{55.46,81.22},{32.37,59.06},{30.78,59.99},{28.23,63.01},{29.18,54.33},{31.12,40.23},{34.26,56.7},{37.47,53.32},{40.27,55.78},{41.21,56.3},{42.5,51.3},{43.86,53.69},{46.57,58.11},{48.26,58.78},{52.23,52.76},{52.76,60.08},{49.48,64.53},{50.15,68.05},{56.68,51.13},{57.5,55.86},{59.06,58.13},{60.98,64.43},{59.71,62.9},{64.42,55.37},{63.28,50.1},{69.27,59.45},{69.9,65.31},{66.4,37.48},{64.9,38.01},{59.73,40.02},{59.25,47.24},{49.25,36.92},{45.46,36.22},{41.03,28.15},{42.19,31.47},{36.34,30.15},{39.02,31.78},{37.27,33.64},{37.44,35.42},{37.85,40.37},{35.3,38.14},{35.82,36.18},{33.39,22.89},{38.12,20.31},{38.8,24.94},{42.72,25.72},{45.4,27.86},{47.74,28.41},{52.54,23.27},{55.48,20.94},{32.16,20.6},{29.85,31.58},{28.39,31.72},{29.74,33.15},{33.79,37.18},{31.93,30.37},{33.72,28.87},{32.18,25.23},{29.04,35.33},{29.54,39.71},{27.85,37.31},{26.81,38.99},{23.9,48.36},{26.87,52.15},{26.95,54.31},{25.06,56.08},{26.09,58.24},{25.18,58.3}},[3519]={{46.94,32.89},{50.03,34.64},{57.91,35.74},{56.6,60.96},{34.05,42.55},{38.27,29.37},{55.52,56.68},{56.62,60.87},{55.43,56.9},{49.7,27.08},{56.83,42.35},{61.06,43.97},{68.5,49.7},{70.82,44.69},{69.57,33.86},{69.65,40.54},{68.34,41.84},{60.76,43.54},{55.2,56.19},{64.49,33.52},{62.29,27.6},{17.91,71.36},{18.34,78.12},{21.8,68.03},{50.59,82},{53.41,78.4},{34.48,35.27},{42.47,34.06},{44.2,29.84},{40.55,26.6},{49.76,27.25},{47.62,23.35},{46.12,12.64},{68.72,88.04}},[3522]={{36.66,74.74},{36.24,70.26},{37.91,70.15},{36.4,70.3},{37.35,77.76},{36.69,74.77},{35.58,72.74},{36.53,70.28},{38.03,70.29}},[3524]={{79.77,59.33},{41.59,65.97},{36.48,73.61},{43.63,23.04},{42.8,23.27},{53.12,41.78},{25.29,53.34},{26.12,54.08},{71.87,59.37},{26.22,61.62},{30.04,73.41},{41.41,71.91},{79.7,59.61},{86.43,61.38},{74.17,45.9},{57.5,25.05},{57.71,14.41},{46.44,8.14},{39.66,11.96},{34.72,30.32},{41.42,39.44},{47.68,34.58},{49.18,21.64},{33.58,36.7},{41.62,40.01},{50.58,36.71},{26.08,62.63},{41.32,69.57},{54.4,63.97}},[3711]={{54.89,31.35},{47.07,35.59},{51.9,82.72},{59.44,44.18},{68.2,69.81},{41.47,79.72},{56.19,83.27},{55.97,27.61},{57.27,44.91},{54.88,45.56},{43.28,81.13},{45.86,85.54},{53.58,21.95},{66.16,68},{58.46,65.84},{47.27,79.42},{68.84,70.52},{62.3,47.71},{58.51,41.07},{67.06,70.38},{50.82,79.28},{28.57,83.27},{52.53,29.7},{58.78,82.41},{62.9,83.02},{46.38,41.75},{38.52,83.96},{43.47,35.36},{56.98,37.99},{39.45,26.93},{32.72,79.24},{50.33,44.4},{40.57,30.39},{21.74,59.05},{62.86,33.24},{33.5,83.54},{36.68,80.47},{58.81,26.77},{37.09,31.21},{30.48,74.92},{55.11,65.8},{42.62,28.85},{39.6,87.23},{48.02,44.82},{26.4,82.65},{42.89,24.79},{41.55,34.4},{57.72,69.78},{22.27,64.83},{25.99,65.22},{26.41,63.93},{28.27,45.12},{31.94,37.34},{30.62,40.34},{23.43,51.51},{31.97,56.32},{28.56,44.93},{32.05,37.13},{38.82,42.81}},[3805]={{-1,-1}},[4131]={{-1,-1}},[4395]={{76.54,43.36},{41.28,72.62},{32.21,33.89},{76.56,45.04},{59.49,27.32},{50.15,50.68},{49.27,63.88},{48.67,33.06}},[4714]={{38.79,71.3},{59.84,79.09},{31.82,65.42},{62.66,78.02},{40.11,76.09},{59.58,73.95},{36.27,73.11},{34.21,71.39},{60.84,75.92},{64.43,74.16},{62.29,73.81}},[5389]={{50.46,56.48},{70.69,46.26},{73.12,60.88},{71.82,57.29},{47.12,47.57},{43.98,44.68},{32.74,47.32},{47.19,71.75},{43.08,59.01},{53.55,70.74},{45.52,65.08},{66.18,46.2},{37.71,61.68},{53.07,71.1},{45.37,66.43},{52.92,69.74},{46.06,65.61},{38.56,44.08},{42.86,60.3},{61.11,52.9},{37.39,62.05},{60.34,62.97},{57.89,53.96},{52.98,70.53},{47.01,71.48},{42.92,60.05},{45.97,65.38}},[5788]={{-1,-1}}},nil,3518,nil,nil,31,"AH",nil,0},
[1413] = {'Janey Anship',713,713,25,25,0,{[1519]={{49.72,86.04},{60.6,67.17},{49.72,86.02}}},{[1519]={{{49.52,82.71},{49.78,80.83},{50.23,78.84},{49.33,77.76},{48.4,77.21},{47.72,77.04},{46.8,77.55},{46.02,75.49},{45.57,74.25},{45.43,73.22},{44.29,70.86},{47.62,66.62},{47.82,65.41},{47.73,64.27},{48.67,63.09},{49.7,61.81},{50.14,62.01},{51.1,62.91},{51.96,63.17},{52.66,62.81},{53.37,62.33},{54.02,62.59},{54.85,63.42},{55.33,63.38},{55.77,63.04},{56.69,62.04},{57.43,63.27},{57.98,64.08},{58.32,64.48},{58.84,64},{60.57,67.37},{61.92,66.01},{63.03,65.89},{63.69,66.25},{64.49,67.7},{65.18,68.85},{63.74,70.79},{61.2,73.72},{60.46,72.4},{60.19,71.63},{58.36,72.73},{56.75,73.86},{55.42,75.52},{55.59,76.41},{53.68,78.89},{54.01,79.62},{54.66,80.68},{54.8,83.34},{54.09,85.05},{53.08,85.86},{51.78,86.26},{50.25,85.87},{49.72,86.04},{49.72,86.04},{49.72,86.04},{49.72,86.04},{49.72,86.04},{49.72,86.04},{49.72,86.04},{49.72,86.04},{49.72,86.04},{49.72,86.04},{49.72,86.04}}}},1519,nil,nil,12,"A",nil,0},
[1414] = {'Lisan Pierce',713,713,25,25,0,{[1519]={{49.77,85.79},{60.63,66.88},{49.78,85.79}}},nil,1519,nil,nil,12,"A",nil,0},
[1415] = {'Suzanne',713,713,25,25,0,{[1519]={{49.88,86.06},{60.5,67.09},{49.89,85.98}}},nil,1519,nil,nil,12,"A",nil,0},
[1416] = {'Grimand Elmore',2769,2769,50,50,0,{[1519]={{59.72,33.78}}},{[1519]={{{59.6,34.3},{59.92,34.94},{61.93,33.92},{63.59,36.81},{63.6,36.79},{61.93,33.92},{59.92,34.94},{59.6,34.3},{59.72,33.77},{59.72,33.77}}}},1519,{325,353},{322,1097,1700,1705,1706,7641,7642},55,"A",nil,3},
[1417] = {'Young Wetlands Crocolisk',530,573,21,22,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1418] = {'Bluegill Raider',896,950,28,29,0,nil,nil,0,nil,nil,18,nil,nil,0},
[1419] = {'Fizzles',8,8,1,1,0,{[1519]={{44.65,86.19}}},nil,1519,nil,nil,12,"A",nil,0},
[1420] = {'Toad',8,8,1,1,0,{[8]={{64.88,73.62},{64.18,69.4},{37.23,55.56},{20.39,59.28},{18.9,55.75},{38.08,45.52},{69.55,28.48},{74.92,16.47},{58.38,29.23},{42.86,45.96},{45.14,36.74},{59.15,29.01},{87.18,37.06},{47.42,43.01},{45.87,42.86},{64.38,28.27},{33,38.42},{61.27,27.74},{75.23,40.15},{77.99,24.56},{16.11,37.91},{25.58,42.49},{72.18,37.23},{36.51,55.21},{78.35,15.56},{81.59,30.47},{31.34,45.2},{79.4,22.56},{33.74,44.27},{20.23,58.48},{18.22,56.87},{37.43,42.97},{69.88,27.57},{58.13,30.75},{64.94,73.52},{43.05,45.76},{45.09,36.92},{59.74,29.06},{76.91,60.96},{68.68,72.85},{46.46,42.71},{46.72,43.07},{64.31,27.98},{32.81,37.47},{61.42,29.82},{63.89,66.93},{72.58,37.9},{88.01,64.4},{37,55.07},{31.8,46.21},{84.85,72.86},{33.81,43.58},{18.49,56.65}},[11]={{46.46,65.55},{60.25,64.74},{24.63,44.82},{22.66,70.41},{16.6,39.92},{60.62,66.63},{39.34,23.06},{21.16,50.44},{46.46,64.64},{67.18,72.08},{14.89,41.31},{22.29,69.46},{45.8,62.68},{48.29,61.92},{22.59,68.77},{14.81,35.4},{37.04,21.43},{22.86,47.19},{57.19,60.77},{63.65,71.21},{55.12,68.45},{13.8,45.59},{17.79,48.39},{56.3,74.18},{58.24,66.51},{38.6,30.33},{30.56,37.9},{62.99,51.28},{54.22,42.4},{16.77,28.97},{22.39,22},{47.76,35.92},{32.7,26.88},{58.54,46.68},{53.95,38.16},{46.36,30.27},{53.88,29.51},{38.75,33.59},{50.99,28.05},{59.98,51.66},{50.79,30.98},{36.08,33.06},{37.83,27.75},{41.34,33.78},{48.02,30.92},{17.86,36.46},{19.69,32.54},{65.07,62.69},{25,32.39},{35.16,30.84},{46.63,34.03},{16.91,32.07},{28.95,28.98},{35.22,26.91},{33,34.62},{24.91,40.03},{23.28,28.06},{21.04,33.06},{31.14,22.64},{42.7,29.28}},[14]={{34.8,31.51},{37.03,34.43},{35.74,29.61},{35.03,32.55},{34.85,36.23},{34.9,28.68},{35.09,36.51},{36.11,31.89},{37.34,32.04},{36.87,37.97},{44.35,33.8},{35.52,28.83},{35.22,36.15},{42.03,39.12},{43.83,36.44},{35.01,53.27},{36.63,52.85},{38.18,38.47},{44.03,38.56},{35.22,50.28},{43.79,36.09},{43.68,44.81},{39.49,43.49},{38.03,40.03},{45.67,46.05},{44.33,39.5},{40.83,39.62},{41.63,44.24},{34.82,52.69},{43.11,46.7},{44.58,37.98},{46.26,44.73},{35.44,41.6},{39.08,46.12},{42.85,43.62},{36.84,42.07},{40.78,46.09},{42.49,36.66},{38.4,48.74},{37.22,46.2},{46.65,44.14},{44.42,45.38},{37.43,42.95},{37.09,38.59},{44.14,34.38},{39.6,38.12},{40.59,37.35},{35.84,42.02},{34.75,53.25},{34.56,45.12},{34.82,52.62},{35.46,41.64},{36.51,42.16},{34.82,43.52},{35.81,42.01},{35.67,41.68},{34.91,31.2}},[15]={{43.9,57.13},{53.45,20.74},{47.41,17.9},{41.48,21.03},{43.53,76.88},{36.64,25.13},{42.79,38.7},{51.09,19.02},{40.61,46.24},{37.17,51.03},{49.97,57.63},{52.51,53.11},{47.7,76.54},{50.89,65.71},{39.58,49.56},{38.02,31},{40.66,21.52},{39.23,68.75},{38.27,19.09},{37.48,18.82},{40.72,31.99},{45.11,19.73},{38.9,60.67},{43.19,19.43},{45.8,53.46},{54.24,73.34},{54.94,70.2},{42.38,45.54},{50.52,73.19},{34.4,47.6},{40.39,58.69},{41.89,18.67},{43.31,73.12},{35.5,71.41},{55.77,27.78},{59.63,34.88},{35.82,46.3},{57.62,28.66},{45.9,77.49},{36.28,20.35},{46.09,78.23},{55.19,74.82},{39.02,52.88},{43.55,50.71},{36.71,42.97},{42.76,60.6},{34.82,49.91},{41.96,63.97},{45.26,49.01},{50.51,56.04},{43.48,70.56},{50.23,77.14},{48.18,50.04},{45.89,70.14},{43.03,68.87},{44.38,74.26},{55.39,72.49},{34.86,59.31},{52.57,69.79},{40.93,51.69},{38.72,40.98},{46.98,63.56},{48.38,60.36},{42.16,47.29},{37.55,36.08},{47.52,21.57},{34.2,41.98},{38.69,74.61},{46.45,19.45},{40.03,35.26},{43.76,78.41},{36.93,21.75},{35.47,27.29},{45.97,80.26},{48.79,22.31},{50.97,21.08},{50.28,52.92},{52.29,56.52},{44.49,42.92},{48.35,65.92},{47.38,17.67},{47.28,72.85},{43.29,77.14}},[17]={{69.51,31.42},{69.33,31.56},{69.64,33.96}},[28]={{59.02,86.97},{52.46,95.09},{55.66,91.08},{58.17,85.24},{55.03,91.77},{57.18,89.47}},[130]={{42.73,84.78},{40.15,82.82},{64.84,36.09},{74.31,35.88},{41.06,81.83},{64.8,35.5},{75.27,31.86},{60.01,37.67},{39.67,82.71},{57.22,30.66},{78.64,26.75},{77.51,27.91},{59.57,36.18},{47.77,83.44},{79.29,28.4},{46.18,78.92},{79.01,31.95},{72.35,38.03},{56.37,26.93},{69.44,21.24},{43.91,82.38},{68.32,29.29},{56.91,27.31},{66.79,12.41},{66.07,18.06},{69.91,19.91},{47.11,82.59},{56.38,20.99},{71.45,34.52},{57.58,29.25},{76.22,30.6},{47.28,79.84},{42.68,83.58},{57.37,23.71},{41.79,83.3},{78.41,28.33},{54.64,30.39},{69.97,18.37},{59.39,36.78},{38.71,82.17},{67.98,38.6},{71.47,37.67},{63.42,31.61},{77.67,24.58},{76.79,19.31},{66.69,9.84},{67.25,38.05},{78.58,25.83},{75.49,17.59},{67.93,18.48},{73.78,17.39},{71.57,18.24},{73.66,18.16},{57.38,18.08},{65.25,12.65},{47.85,85.26},{72.85,18.38},{57.31,17.63},{61.95,13.27},{76.12,30.29},{45.89,76.86},{46.72,78.42},{57.02,24.57},{66.03,36.1},{75.16,34.35},{75.36,19.52},{47.86,81.11},{59.53,17.3},{61.57,14.2},{46.26,83.65},{46.05,77.48},{46.19,78.3},{46.29,77.52},{44.44,79.41},{78.53,23.02},{66.84,44.26},{65.39,44.68},{75.13,16.4}},[141]={{57.93,32.06},{56.9,34.02},{57.3,33.5},{56.58,32.78}},[267]={{69.69,29.67},{62.43,40.22},{64.24,38.5},{67.67,33.23},{61.83,42.8},{66.69,35.31},{65.01,37.39},{67.61,35.55}},[331]={{92.09,60.57},{78.44,51.54},{71.98,54.94},{69.44,60.76},{91.55,62.01},{70.18,56.35},{73.24,51.46},{91.73,65.53},{79.22,55.97},{70.2,58.56},{72.16,53.28},{69.31,58.98},{78.88,56.45},{71.25,54.08},{91.49,63.56},{69.62,61.89},{73.85,52.34},{77.72,50.17},{79.29,61.35},{85.72,66.76},{80.83,63.83},{78.7,52.11},{70.62,55},{70.72,57.13},{84.99,67.93},{70.02,59.87},{78.82,53.95},{81.81,64.71},{78.76,70.19},{80.26,71.4},{78.23,72.93},{79.68,74.28},{61.41,74.55},{62.88,70.57},{64.14,69.89},{60.95,75.77},{61.95,75.72},{63.33,71.54},{59.61,77.9},{60.02,77.13},{68.14,63.92},{71.93,54.96},{69.45,60.76},{62.93,70.54},{69.94,56.53},{66.09,65.23},{73.2,51.62},{70.29,58.6},{64.08,69.63},{72.13,52.83},{69.34,59.09},{71.29,54.22},{69.62,61.76},{73.82,52.43},{65.95,64.47},{63.34,71.91},{70.62,55.05},{70.63,57.13},{70.05,59.91},{67.58,64.21},{69.07,62.8},{68.29,62.26},{74.9,46.49},{53.13,71.44},{58.97,78.32},{52.82,70.08},{44.37,55.31},{44.18,52.83},{48.84,69.21},{48.25,69.47}},[361]={{49.66,24.61},{48.24,83.32},{49.84,27.21},{45.89,78.77},{42.4,66.02},{41.84,70.1},{41.65,65.27},{45.69,70.8},{48.04,24.07},{41.52,47.39},{40.8,64.62},{42.26,45.76},{48.56,25.74},{40.86,55.25},{39.02,49.11},{41.79,48.91},{46.73,80.9},{61.76,13.67},{45.36,78.75},{39.96,48.36},{61.58,11.33},{47.85,82.71},{48.87,23.21},{44.15,73.39},{46.4,80.97},{42.49,48.79},{47.98,27.13},{44.89,72.32},{44.06,76.36},{43.34,48.32},{43.48,74.99},{42.46,49.79},{40.34,54.92},{40.6,54.89},{60.87,11.82},{61.93,13.02},{61.31,9.71},{61.91,10.98},{60.55,10.57},{60.95,25.02},{60.25,26.12},{45.56,70.51},{40.57,55.59},{41.85,48.92},{61.55,13.64},{42.37,48.66},{43.31,48.06},{42.3,49.61},{62.05,12.81},{60.94,25.37},{61.36,9.77},{36.13,49.07},{40.74,64.89},{40.7,55.35},{39.08,49.05},{61.59,13.67},{40.02,48.19},{38.14,48.41},{37.34,48.28},{40.29,55.08},{40.58,54.84},{60.84,11.58},{60.65,10.75}},[495]={{53.04,67.21},{53.03,66.61},{53.81,68.15},{51.69,67.24},{52.53,66.68},{53.07,66.4},{53.12,66.89}},[1637]={{48.19,46.13},{48.2,46.48},{57.54,55.04},{63.04,44.48},{56.51,52.68},{47.17,50.68},{46.89,50.5},{45.48,47.91},{46.74,51.65},{35.23,63.79},{33.23,66.49},{35.63,64.16},{34.87,72.88},{35.29,75.42},{37.17,76.12},{75.16,41.18},{33.71,71.88},{35.66,80.1},{36.57,78.88},{35.13,67.97},{35.46,76.61},{35.76,81.75},{30.41,61.18},{33.5,61.43},{33.34,60.72},{24.39,66.15},{32.79,69.39},{47.07,50.57},{30.83,66.36},{33.67,66.41},{35.66,81.54},{31.59,61.26},{33.77,72.7},{29.46,66.94},{30.8,67.35},{48.77,49.02},{33.5,76.51},{36.08,66.9},{35.11,67.62},{36.56,71.89},{73.56,37.85},{48.62,49.09},{32.88,73.7},{34.25,74.47},{31.59,67.33},{62.96,44.01}},[1657]={{48.05,42.07},{47.83,54.64},{47.7,60.16},{48.22,42.8},{50.13,51.08},{33.53,42.45},{52.46,55.46},{50.15,49.04},{53.53,47.05},{53.31,53.82},{48.57,59.51},{43.1,55.92},{35.85,39.63},{36.72,39.17},{57.27,43.56},{34.78,54.1},{38.31,52.71},{39.36,52.01},{48.65,55.25},{53.43,61.86},{42.15,45.95},{48.55,56.81},{45.18,38.58},{37.65,47.74},{53.62,55.67},{46.58,37.52},{47.04,37.63},{41.71,47.44},{51.99,43.84},{52.44,44.06},{55.32,40.28},{51.88,69.5},{47.19,59.45}},[3430]={{58.26,65.86},{58.7,62.42},{58.23,65.93},{60.66,67.52},{56.91,57.94}},[3433]={{71.3,23.93},{71.3,20.77},{68.62,19.43}},[3518]={{38.26,51.54},{30.49,55.06},{30.46,55.04},{30.52,55.19},{30.44,55.04},{24.61,53.29},{23.69,52.82},{24.03,54.34},{23.57,52.84},{22.93,44.23},{23.56,44.93},{24.6,53.14},{23.66,52.8},{25.75,45.76},{27.21,44.14},{34.39,44.41},{31.66,46.76},{32.86,46.91},{30.23,45.38},{27.29,44.18},{47.55,31.99},{54.33,36.49},{56.26,39.68},{58.93,35.33},{58.36,37.58},{57.41,38.16},{54.19,34.1},{55.18,32.55},{58.94,35.3},{58.29,33.34},{57.63,32.64},{56.26,32.08},{54.2,36.58},{56.18,32.15},{55.22,32.71},{54.15,34.28},{57.73,32.41},{55.22,32.62},{58.2,33.32},{57.71,32.4},{56.05,32.18},{56.82,23.21},{60.52,26.09},{58.78,24.29},{58.45,22.47},{61.02,19.64},{62.79,23.4},{60.6,26.01},{61.99,27.09},{61.21,35.79},{62.03,34.79},{61.23,35.74},{64.71,60.05},{72.6,49.36},{72.61,51.76},{72,50.23},{72.14,54.78},{72.7,49.21},{72.6,51.87},{72.11,54.65},{71.97,56.07},{75.83,54.92},{74.45,55},{74.38,55.06},{75.85,55.09},{75.89,55.04},{74.38,55.02},{74.83,77.45},{76.6,77.09},{74.53,74.53},{74.84,77.26},{74.04,75.83},{65.78,74.33},{64.39,73.61},{64.39,73.54},{65.82,74.24},{64.33,73.75},{58.81,75.8},{57.46,77.08},{55.03,66.15},{55.05,65.73},{55.52,60.46},{55.6,60.55},{45.73,50.31},{42.6,48.39},{43.54,49.22},{45.67,50.39},{44.45,49.41},{43.46,49.43},{42.41,48.32},{40.76,48.4},{39.82,44.36},{39.9,44.51},{40.7,42.49},{40.83,39.95},{40.06,38.55},{40.56,42.39},{43.16,39.63},{44.37,41}},[3715]={{-1,-1}},[3716]={{-1,-1}},[3959]={{-1,-1}},[4714]={{50.3,69.06},{52.47,67.89},{52.41,71.41},{53.73,72.38},{52.56,74.99},{50.81,71.97}}},nil,3518,nil,nil,188,"AH",nil,0},
[1421] = {'Private Merle',1107,1107,31,31,0,nil,{[33]={{{38.69,3.81},{38.63,3.77},{38.57,3.76},{38.45,3.72},{38.39,3.74},{38.34,3.79},{38.28,3.79},{38.23,3.75},{38.11,3.78},{38.05,3.8},{37.96,3.79},{38.07,3.9},{38.12,3.95},{38.18,3.98},{38.36,3.97},{38.34,3.89},{38.39,3.82},{38.44,3.78},{38.51,3.77},{38.57,3.8}}}},0,nil,nil,11,"A","Rebel Soldier",0},
[1422] = {'Corporal Sethman',1524,1524,40,40,0,{[33]={{46.98,10.84}}},nil,33,{26738,26739,26744},{330,26738,26739,26744},11,"A",nil,2},
[1423] = {'Stormwind Guard',656,656,15,15,0,{[12]={{35.3,53.66},{24.94,72.01},{20.91,79.84},{25.87,72.21},{25.15,72.71},{25.89,72.23},{24.71,72.91},{25.28,72.69},{25.66,72.43},{20.74,79.48},{28.17,77.8},{28.14,77.98},{24.32,74.38},{24.55,74.53},{23.6,80.53},{24.47,80.56},{23.57,80.71},{23.79,80.18},{24.35,81.03},{25.48,73.19},{24.26,72.65},{25,71.78},{25.44,72.85},{23.15,80.83},{24.49,71.45},{24.35,72.89},{24.62,71.49},{25.03,72.32},{24.93,71.99},{25.88,72.23},{25.14,72.7},{25.87,72.22},{24.74,72.88},{25.03,72.52},{25.66,72.43},{42.11,65.49},{42.11,66.7},{23.6,80.52},{23.68,79.94},{25.46,73.26},{24.24,72.74},{25.01,71.77},{24.9,72.37},{24.04,80.94},{24.49,71.42},{24.36,72.89},{24.66,71.47},{25.05,72.31},{46.17,57.99},{60.11,72.43},{74.17,72.41},{75.12,72.21},{71.39,71.65},{74.17,72.66},{75.04,72.54},{83.92,78.44},{83.68,78.95},{84.41,80.23},{84.5,79.72},{84.75,79.59},{84.57,79.88},{53.26,72.52}}},nil,12,nil,nil,11,"A",nil,1},
[1424] = {'Master Digger',333,333,11,11,4,{[40]={{46.42,19.07},{46.4,18.89}}},nil,40,nil,nil,26,nil,nil,0},
[1425] = {'Kubb',410,410,13,13,4,{[38]={{34.38,26.83},{24.97,29.86}}},nil,38,nil,nil,26,nil,"Master of Meats and Fishes",0},
[1426] = {'Riverpaw Miner',300,328,14,15,0,nil,nil,0,nil,nil,20,nil,nil,0},
[1427] = {'Harlan Bagley',247,247,12,12,0,{[1519]={{62.32,67.95}}},nil,1519,{333},nil,12,"A",nil,2},
[1428] = {'Rema Schneider',1342,1342,35,35,0,{[1519]={{58.1,67.49}}},nil,1519,{334},{333},12,"A",nil,2},
[1429] = {'Thurman Schneider',55,55,2,2,0,{[1519]={{52.59,83.4}}},nil,1519,nil,{334},12,"A",nil,2},
[1430] = {'Tomas',198,198,10,10,0,{[12]={{44.37,65.99}}},nil,12,nil,nil,12,"A","Cooking Trainer",81},
[1431] = {'Suzetta Gallina',1003,1003,30,30,0,{[1519]={{60.28,76.75}}},nil,1519,nil,{332},12,"A",nil,2},
[1432] = {'Renato Gallina',2218,2218,45,45,0,{[1519]={{63.77,73.59}}},nil,1519,{332},nil,12,"A",nil,3},
[1433] = {'Corbett Schneider',102,102,5,5,0,{[1519]={{65.58,74.84}}},nil,1519,nil,nil,12,"A",nil,0},
[1434] = {'Menethil Sentry',2790,3302,41,42,0,nil,nil,0,nil,nil,57,"A",nil,0},
[1435] = {'Zardeth of the Black Claw',4120,4120,60,60,0,{[1519]={{40.14,85.28}}},nil,1519,nil,{335,24428},12,"A",nil,2},
[1436] = {'Watcher Cutford',1536,1536,37,37,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1437] = {'Thomas Booker',484,484,20,20,0,{[11]={{13.07,49.45}}},{[11]={{{8.83,54.31},{8.85,54.54},{8.76,54.67},{8.62,54.7},{8.42,54.56},{8.33,54.45},{8.46,54.08}}}},11,nil,nil,11,"A",nil,0},
[1439] = {'Lord Baurles K. Wishock',198,198,10,10,0,{[1519]={{80.62,32.97}}},nil,1519,nil,{336},12,"A","House of Nobles",2},
[1440] = {'Milton Sheaf',328,328,15,15,0,{[1519]={{86.12,24.43}}},nil,1519,nil,{337,343,542},12,"A","Librarian",0},
[1441] = {'Brak Durnad',713,713,25,25,0,{[11]={{11.59,59.52}}},{[11]={{{11.44,59.69},{11.58,59.54}}}},11,nil,nil,55,"A","Weaponsmith",4224},
[1442] = {'Helgrum the Swift',4120,4120,60,60,0,{[8]={{21.16,51.69}}},nil,8,nil,{1420},29,"H",nil,0},
[1443] = {'Fel\'zerul',4120,4120,60,60,0,nil,nil,0,nil,{1424,1444,1445},29,"H",nil,0},
[1444] = {'Brother Kristoff',1753,1753,40,40,0,{[1519]={{55.05,54.18}}},nil,1519,nil,{346},12,"A",nil,0},
[1445] = {'Jesse Halloran',55,55,2,2,0,{[11]={{11.83,57.54}}},nil,11,nil,nil,12,"A",nil,0},
[1446] = {'Regina Halloran',55,55,2,2,0,{[11]={{11.85,57.56}}},nil,11,nil,nil,12,"A",nil,0},
[1447] = {'Gimlok Rumdnul',55,55,2,2,0,{[11]={{11.88,57.55}}},nil,11,nil,nil,55,"A",nil,0},
[1448] = {'Neal Allen',484,484,20,20,0,{[11]={{11.92,52.74}}},nil,11,nil,nil,11,"A","Engineering Supplies & General Goods",640},
[1449] = {'Witch Doctor Unbagwa',1057,1057,32,32,0,{[5287]={{54.19,46.44}}},nil,5287,nil,{349,26598},35,"AH",nil,2},
[1450] = {'Brahnmar',713,713,25,25,0,{[11]={{11.56,59.87}}},{[11]={{{11.54,59.86},{11.47,59.77}}}},11,nil,nil,55,"A","Armorer",4224},
[1451] = {'Camerick Jongleur',713,713,25,25,0,{[11]={{10.65,58.76}}},{[11]={{{9.87,59.09},{9.95,59.17},{10.1,59.16},{10.12,59.07},{10.08,59.04},{10.11,58.96},{10.05,58.87},{9.91,58.8},{9.85,58.93},{9.79,58.86},{9.74,58.94},{9.73,59.03},{9.76,59.09},{9.88,59.05}}}},11,nil,nil,12,"A","Wandering Minstrel",0},
[1452] = {'Gruham Rumdnul',713,713,25,25,0,{[11]={{12.09,57.98}}},nil,11,nil,nil,55,"A","General Supplies",640},
[1453] = {'Dewin Shimmerdawn',713,713,25,25,0,{[11]={{11.38,51.9}}},nil,11,nil,nil,55,"A","Alchemy Supplies",128},
[1454] = {'Jennabink Powerseam',713,713,25,25,0,{[11]={{10.06,59.05}}},nil,11,nil,nil,875,"A","Tailoring Supplies & Specialty Goods",4224},
[1456] = {'Kersok Prond',713,713,25,25,0,{[11]={{10.38,60.62}}},nil,11,nil,nil,55,"A","Tradesman",128},
[1457] = {'Samor Festivus',713,713,25,25,0,{[11]={{10.5,60.2}}},nil,11,nil,nil,12,"A","Shady Dealer",1152},
[1458] = {'Telurinon Moonshadow',713,713,25,25,0,{[11]={{11.25,52.13}}},{[11]={{{7.99,55.84},{7.86,55.8},{7.96,55.95}}}},11,nil,nil,55,"A","Herbalism Trainer",81},
[1459] = {'Naela Trance',713,713,25,25,0,{[11]={{11.07,57.9}}},{[11]={{{11.27,58.43},{11.26,58.41},{11.32,58.31},{11.24,58.16},{11.22,58.18},{11.31,58.27},{11.26,58.41}}}},11,nil,nil,12,"A","Bowyer",4224},
[1460] = {'Unger Statforth',713,713,25,25,0,{[11]={{9.36,56.4}}},nil,11,nil,nil,12,"A","Horse Breeder",129},
[1461] = {'Murndan Derth',713,713,25,25,0,{[11]={{11.34,59.58}}},nil,11,nil,nil,55,"A","Gunsmith",4224},
[1462] = {'Edwina Monzor',713,713,25,25,0,{[11]={{11.06,57.96}}},nil,11,nil,nil,12,"A","Bowyer",4224},
[1463] = {'Falkan Armonis',713,713,25,25,0,{[11]={{9.37,56.09}}},nil,11,nil,nil,12,"A","Reagents",2176},
[1464] = {'Innkeeper Helbrek',1003,1003,30,30,0,{[11]={{10.73,60.85}}},nil,11,nil,nil,55,"A","Innkeeper",66177},
[1465] = {'Drac Roughcut',328,328,15,15,0,{[38]={{35.57,49.16}}},nil,38,nil,nil,55,"A","Tradesman",128},
[1466] = {'Gretta Finespindle',664,664,24,24,0,{[1537]={{38.81,32.88}}},nil,1537,nil,nil,55,"A","Apprentice Leatherworker",1},
[1468] = {'Kargh Steelspine',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Armorer",0},
[1469] = {'Vrok Blunderblast',328,328,15,15,0,{[38]={{35.27,42.51}}},nil,38,nil,nil,55,"A","Gunsmith",4224},
[1470] = {'Ghak Healtouch',713,713,25,25,0,{[38]={{37.07,49.38}}},nil,38,nil,{17,2500,2501},55,"A","Alchemy Trainer",81},
[1471] = {'Jannos Ironwill',2399,2399,46,46,0,{[45]={{40.82,48.14}}},nil,45,nil,nil,55,"A","Superior Macecrafter",4224},
[1472] = {'Morgg Stormshot',3189,3189,53,53,0,{[1519]={{65.24,40.31}}},nil,1519,nil,nil,55,"A",nil,0},
[1473] = {'Kali Healtouch',300,300,14,14,0,{[38]={{36.47,48.54}}},nil,38,nil,nil,55,"A","Herbalism Trainer",80},
[1474] = {'Rann Flamespinner',328,328,15,15,0,{[38]={{35.95,45.87}}},nil,38,nil,nil,55,"A","Tailoring Supplies",128},
[1475] = {'Menethil Guard',3184,3184,47,47,0,nil,nil,0,nil,nil,57,"A",nil,1},
[1476] = {'Hargin Mundar',484,484,20,20,0,{[11]={{10.64,59.7}}},{[11]={{{10.63,60.52},{10.63,60.75},{10.74,60.92},{10.63,60.75},{10.63,60.52},{10.68,60.52},{10.67,60.53},{10.42,60.47},{10.45,60.48},{10.63,60.56},{10.63,60.33},{10.62,60.1},{10.78,60.09},{10.79,59.76},{10.78,60.09},{10.62,60.1},{10.63,60.33}}}},11,nil,nil,55,"A",nil,0},
[1477] = {'Christoph Faral',1003,1003,30,30,0,{[1519]={{64.76,65.79}}},nil,1519,nil,nil,12,"A",nil,0},
[1478] = {'Aedis Brom',1003,1003,30,30,0,{[1519]={{64.78,65.89}}},nil,1519,nil,nil,12,"A",nil,0},
[1479] = {'Timothy Clark',484,484,20,20,0,nil,nil,0,nil,nil,11,"A",nil,0},
[1480] = {'Caitlin Grassman',484,484,20,20,0,{[11]={{11.87,58.79}}},nil,11,nil,nil,12,"A",nil,0},
[1481] = {'Bart Tidewater',484,484,20,20,0,{[11]={{8.38,59.31}}},{[11]={{{9.05,59.35},{9,59.19},{9.17,58.92},{8.37,58.52},{8.02,57.75},{7.92,57.51},{7.92,57.64}}}},11,nil,nil,12,"A","Captain of the Maiden's Virtue",0},
[1482] = {'Andrea Halloran',484,484,20,20,0,{[11]={{10.89,60.25}}},nil,11,nil,nil,11,"A",nil,0},
[1483] = {'Murphy West',484,484,20,20,0,{[11]={{11.09,56.28}}},{[11]={{{9.73,57.75},{9.61,57.69},{9.76,57.26},{9.81,57.15},{10.08,57.33},{9.61,57.69},{9.73,57.75},{9.9,57.69}}}},11,nil,nil,11,"A",nil,0},
[1484] = {'Derina Rumdnul',484,484,20,20,0,{[11]={{11.86,57.9}}},nil,11,{25820},{25820},55,"A",nil,2},
[1487] = {'Splinter Fist Enslaver',1050,1107,30,31,0,nil,nil,0,nil,nil,45,nil,nil,0},
[1488] = {'Zanzil Zombie',1006,1006,30,31,0,{[5287]={{54.34,30.32},{53.3,30.4},{53.04,31.26},{53.8,29.03},{53.83,29.7},{53.47,29.56},{53.85,31.35}}},nil,5287,nil,nil,16,nil,nil,0},
[1489] = {'Zanzil Hunter',1006,1006,31,31,0,{[5287]={{63.12,41.41},{63.72,40.86},{60.43,43.63},{60.64,43.78},{63.35,42.81},{61.39,41.89},{60.04,40.15},{62.2,41.75},{63.16,44.56},{61.81,40.94},{60.52,41.35},{61.01,42.81},{61.24,44.56},{61,41.83},{60.68,46.37}}},nil,5287,nil,nil,16,nil,nil,0},
[1490] = {'Zanzil Witch Doctor',850,850,32,32,0,{[5287]={{61.6,43.56}}},nil,5287,nil,nil,16,nil,nil,0},
[1491] = {'Zanzil Naga',1006,1006,31,32,0,{[5287]={{64.34,40.35},{59.99,45.35},{61.94,42.39},{60.43,43.05},{60.39,42.95}}},nil,5287,nil,nil,16,nil,nil,0},
[1492] = {'Gorlash',2220,2220,33,33,0,{[5287]={{54.74,65.85}}},nil,5287,nil,nil,778,nil,nil,0},
[1493] = {'Mok\'rash the Cleaver',3330,3330,33,33,0,{[5287]={{34.78,65.49}}},nil,5287,nil,nil,778,nil,nil,0},
[1494] = {'Negolash',2220,2220,33,33,0,{[5287]={{50.75,79.65}}},nil,5287,nil,nil,778,nil,nil,0},
[1495] = {'Deathguard Linnea',1124,1124,22,22,0,{[85]={{65.49,60.25}}},nil,85,{24989},{359,24983},68,"H",nil,2},
[1496] = {'Deathguard Dillinger',1124,1124,22,22,0,{[85]={{52.55,54.82}}},nil,85,{24982,25090},{404,426,1818,1819,25090},68,"H",nil,3},
[1497] = {'Gunther Arcanus',3189,3189,53,53,0,{[85]={{68.2,41.92}}},nil,85,nil,{366,409,24984,24985},68,"H",nil,0},
[1498] = {'Bethor Iceshard',4120,4120,60,60,0,{[1497]={{84.17,17.43}}},nil,1497,nil,{357,405,411,444,491,24986},68,"H",nil,0},
[1499] = {'Magistrate Sevren',300,300,14,14,0,{[85]={{61.08,50.64}}},nil,85,{24983,25006,25007},{355,358,360,408,440,24982,24989,25005,25006},68,"H",nil,2},
[1500] = {'Coleman Farthing',328,328,15,15,0,{[85]={{54.59,29.89}}},nil,85,{25003,25004,25005,25029},{354,362,1820,1821,1822,25003,25004,25029,25030,25031},68,"H",nil,2},
[1501] = {'Mindless Zombie',0,0,1,1,0,{[6454]={{39.75,74.63},{39.27,71.29},{40.67,81.85},{41.29,81.76},{40.99,72.64},{41.52,74.15},{42.66,74.75},{43.25,75.65},{42.28,71},{44.4,76.21},{44.44,73.08},{45.01,74.54},{44.8,72.32},{45.44,75.79},{45.63,73.06},{46.4,73.79},{48.88,75.36},{50.09,78.33},{48.74,69.74},{51.41,73.38},{51.27,70.38},{51.79,72.25}}},nil,6454,nil,nil,7,"AH",nil,0},
[1502] = {'Wretched Ghoul',0,0,1,2,0,{[6454]={{44.58,47.75},{46.19,39.9},{48.25,47.72},{47.42,45.73},{49.64,47.02},{49.21,42.25},{49.72,43.91},{49.23,41.68},{50.84,44.81},{50.48,42.26},{50,42.2},{50.27,40.88},{48.97,38.26},{51.12,38.37},{52.27,35.5},{53.3,36.02},{53.93,42.86},{54.65,42.16},{54.09,44.87},{52.16,46.22},{52.2,46.31},{51.51,48.26},{57.98,40.42},{55.1,47.26},{57.58,45.7},{56.43,49.27},{56.54,53.49},{57.17,52.15},{56.61,55.73},{57.6,52.54},{56.99,56.97},{58.86,57.51},{52.85,50.81},{58.92,55.06},{60.71,56.88},{59.01,51.13},{60.12,51.43},{59.23,50.88},{60.33,50.78},{59.27,49.25},{59.21,46.94},{58.87,44.93},{60.68,47.97},{61.1,41.55},{61.7,43.55},{63.59,45.1},{53.79,50.05}}},nil,6454,nil,nil,7,"AH",nil,0},
[1503] = {'Wretched Zombie',0,0,1,2,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1504] = {'Young Night Web Spider',0,0,2,3,0,{[6454]={{32.17,24.73},{34.28,35.57},{35.49,33.19},{32.96,28.47},{31.09,29.92},{33.52,31.4},{35.26,30.13},{35.6,22.48},{35.46,20.67},{33.24,20.77},{31.52,19.32},{32.59,17.35},{30.04,18.35},{34.13,12.77},{35.65,15.01},{38.96,20.61},{39.63,22.68},{39.95,14.86},{39.29,17.5},{36.45,26.2},{36.67,18.57},{40.08,30.28},{38.65,31.04},{39.7,25.33},{37.11,29.25},{41.98,26.92},{42.9,22.93},{42.11,21.08},{42.26,16.05},{45.57,18.07}}},nil,6454,nil,nil,7,"AH",nil,0},
[1505] = {'Night Web Spider',0,0,3,4,0,{[6454]={{16.26,26.3},{15.8,28.44},{15.74,26.49},{15.98,29.76},{14.99,33.21},{14.8,31.7},{15.87,34.18},{18.97,36.55},{20.09,35.97},{18.45,35.56},{20.49,32.12},{17.94,26.56},{17.42,26.47},{21.64,34.31},{20.65,33.32},{23.11,31.45},{21.54,30.35},{21.35,31.76},{23.13,34.36},{22.35,30.24},{24.25,32.3},{26.26,30.95},{24.97,31.03},{26.98,34.89},{27.42,34.11},{31.75,29.03},{28.95,31.19}}},nil,6454,nil,nil,7,"AH",nil,0},
[1506] = {'Scarlet Convert',71,71,3,3,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1507] = {'Scarlet Initiate',67,81,3,4,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1508] = {'Young Scavenger',0,0,2,3,0,{[6454]={{40.63,56.94},{38.64,52.24},{38.74,67.18},{41.53,63.03},{43.94,50.11},{43.25,44.22},{40.87,33.13},{46.07,41.23},{45.32,36.68},{51.23,31.51},{49.29,26.86},{51.14,24.1},{47.27,13.8},{55.75,63.86},{58.14,68.68},{60.55,19.51},{50.92,31.32},{63.5,24.15},{51.72,23.81},{49.29,26.15}}},nil,6454,nil,nil,32,"AH",nil,0},
[1509] = {'Ragged Scavenger',0,0,3,4,0,{[6454]={{62.08,46.13},{62.17,41.32},{61.4,27.71},{61.7,17.78},{64.01,22.95},{66.78,29.74},{70.82,36.99},{72.35,19.86},{67.9,21.19},{67.6,16.12},{74.56,16.66},{72.77,28.41},{75.27,46.63},{74.94,35.73},{76.6,50.77}}},nil,6454,nil,nil,32,"AH",nil,0},
[1511] = {'Enraged Silverback Gorilla',1006,1006,31,31,0,{[5287]={{53.08,50.18},{53.08,50.18},{53.08,50.19}}},nil,5287,nil,nil,41,nil,nil,0},
[1512] = {'Duskbat',0,0,2,3,0,{[6454]={{31.2,85.85},{36.93,71.39},{34.24,63.6},{34.42,54.14},{36.31,43.95},{34.15,47.76},{36.07,49.26},{36.47,47.42},{39.91,60.76},{39.1,64.33},{40.07,84.6},{43.15,59.27},{43.78,56.25},{41.88,47.45},{41.41,51.54},{43.37,39.51},{42.19,42.41},{40.9,37.36},{49.09,85.87},{51.98,81},{46.78,32.16},{47.61,24.47},{49.49,17.7},{55.22,25.17},{53.76,18.19},{57.4,61.27},{61.54,77.09},{61.76,72.18},{60.26,26.41},{58.67,22.18},{63.74,72.93},{66.61,80.43},{64.9,76.57},{64.24,81.09},{67.05,77.02},{66.72,72.38}}},nil,6454,nil,nil,7,"AH",nil,0},
[1513] = {'Mangy Duskbat',0,0,3,4,0,{[6454]={{60.55,56.04},{60.19,39.53},{60.59,31.52},{59.43,20.61},{64.53,18.56},{64.24,30.06},{66.39,25.83},{64.36,39.39},{66.55,39.06},{65.33,45.96},{71.44,40.86},{69.81,26.25},{72.36,31.38},{69.97,17.95},{75.2,24.81},{74.51,31.06},{75.17,41.26}}},nil,6454,nil,nil,7,"AH",nil,0},
[1514] = {'Mokk the Savage',2114,2114,32,32,0,{[5287]={{52.99,50.22}}},nil,5287,nil,nil,41,nil,nil,0},
[1515] = {'Executor Zygand',300,300,14,14,0,{[85]={{60.54,51.86}}},nil,85,{24981,24993,26964},{370,371,372,383,398,427,24981,24992,24993,25012,25039},68,"H",nil,2},
[1516] = {'Konda',1006,1006,31,31,0,{[5287]={{52.98,50.23}}},nil,5287,nil,nil,41,nil,nil,0},
[1518] = {'Apothecary Johaan',484,484,20,20,0,{[85]={{44.61,53.79}}},nil,85,{24975,24976,24977},{365,367,368,369,24975,24976},68,"H","Royal Apothecary Society",2},
[1519] = {'Deathguard Simmer',1210,1210,23,23,0,{[85]={{44.75,53.67}}},nil,85,{24978,24980},{24972,24978,24979,24980},68,"H",nil,3},
[1520] = {'Rattlecage Soldier',176,176,8,9,0,{[85]={{47.69,37.04},{49.11,38.3},{45.98,36.35},{49.88,37.62},{46.12,34.12},{49.14,35.98}}},nil,85,nil,nil,21,nil,nil,0},
[1521] = {'Gretchen Dedmar',156,156,8,8,0,{[85]={{65.25,60.42}}},nil,85,{24988},{375,24988},68,"H",nil,2},
[1522] = {'Darkeye Bonecaster',143,143,8,9,0,{[85]={{47.66,30.85},{49.05,33.86},{45.38,32.88},{51.01,34},{49.88,36.82},{46.98,31.96},{48.22,37.53},{48.25,30.49},{45.45,35.13},{49.12,28.19},{47.09,32.28},{47.3,30.06},{46.77,36.96},{46.79,33.19},{47.31,36.67},{46.87,34.9},{46.02,31.53},{45.47,30.6},{51.36,32.82},{50.44,31.64},{49.11,31.61},{48.84,34.37},{49.82,36.21},{49.03,35.23},{47.31,31.93},{49.59,36.02},{46.2,29.36},{47.6,29.38},{51.31,32.74},{47.34,30.06},{50.52,31.7}}},nil,85,nil,nil,21,nil,nil,0},
[1523] = {'Cracked Skull Soldier',148,148,8,9,0,{[85]={{47.86,34},{46.91,28.46},{48.64,29.26},{45.36,28.44},{48.91,33.72},{44.81,29.36},{49.15,33.28},{49.22,33.58},{48.33,28.22},{47.64,34.36},{48.38,35.13},{45.45,35.05},{49.55,34.95},{46.04,33.94},{44.83,31.82},{49.91,32.64},{48.41,32.93},{48.23,32.94},{48.19,33.61},{46.82,30.62},{49.43,31.69},{48.18,33.23},{48.39,32.84},{46.81,30.53}}},nil,85,nil,nil,21,nil,nil,0},
[1525] = {'Rotting Dead',102,102,5,6,0,{[85]={{53.04,56.47},{52.79,59.81},{54.81,59.39},{53.54,56.13},{53.54,56.86},{55.65,57.02},{51.27,51.61},{53.25,54.14},{53.12,53.93},{55.37,51.36},{54.93,50.51},{53.35,50.23},{54.63,49.63},{52.1,50.39},{51.55,53.62},{52.9,53.1},{53.18,54.24},{54.48,56.08},{53.39,55.91}}},nil,85,nil,nil,21,nil,nil,0},
[1526] = {'Ravaged Corpse',137,137,6,7,0,{[85]={{51.98,58.3},{53.76,57.64},{55.12,57.11},{54.37,59.26},{52.02,59.51},{51.77,56},{52.73,57.27},{54.12,57.28},{54.11,55.96},{53.84,61.1},{53.92,45.15},{53.57,54.17},{54.42,50.51},{54.27,51.31},{52.7,50.27},{52.1,52.08},{51.64,56.1},{52.15,53.59},{51.57,53.44},{54.75,54.15},{52.92,52.76},{53.78,58.37},{52.16,56.73},{53.59,54.07},{54.61,54.26},{53.37,60.61},{55.01,59.35}}},nil,85,nil,nil,21,nil,nil,0},
[1527] = {'Hungering Dead',137,137,7,8,0,{[85]={{69.68,41.11},{67.81,42.47},{68.3,42.39},{69.55,41.7},{67.39,42.35},{68.16,43.47},{67.46,42.93}}},nil,85,nil,nil,21,nil,nil,0},
[1528] = {'Shambling Horror',176,176,8,9,0,{[85]={{68.7,43.44},{68.44,41.5},{66.71,45.16},{67.54,43.66},{67.83,42.12},{67.75,41.5},{67.96,44.07}}},nil,85,nil,nil,21,nil,nil,0},
[1529] = {'Bleeding Horror',176,176,9,10,0,{[85]={{78.62,60.5},{76.96,61.31},{76.61,59.67},{77.85,59.4},{74.08,62.76},{76.77,60.2},{76.3,62.58},{76.89,62.8}}},nil,85,nil,nil,21,nil,nil,0},
[1530] = {'Rotting Ancestor',176,176,8,9,0,{[85]={{51.66,33.79},{51.89,25.83},{51.79,26.96},{52.53,25.93},{52.39,25.98},{51.91,26.74},{52.57,26.79},{52.63,27},{52.68,26.05},{52.26,26.35},{52.64,26.29},{51.33,28.12},{52.07,32.59},{53.39,31.59},{51.46,31.03},{50.7,28.83},{53.04,30.59},{49.69,28.63},{52.39,26.43},{51.89,26.78},{52.56,26.77},{52.34,26.88},{51.87,26.74},{52.4,26.92},{52.25,26.33},{52.51,25.92},{51.31,28.1},{52.64,26.67},{51.4,31.49},{52.03,32.69}}},nil,85,nil,nil,21,nil,nil,0},
[1531] = {'Lost Soul',120,120,6,7,4,{[85]={{53.34,45.6},{53.18,48.37},{48.46,39}}},{[85]={{{44.6,40.51},{44.61,40.42},{44.67,40.45},{45,41.08},{44.74,40.54},{44.65,40.52},{44.47,40.82},{44.55,40.58},{44.02,40.97},{43.77,41.31},{43.79,42.04},{44.05,42.37},{44.81,42.71},{45.33,42.85},{45.76,42.79},{46.29,42.7},{46.93,42.59},{47.16,42.27},{47.27,41.94},{47.37,41.3},{47.23,40.71},{47.05,40.42},{46.88,40.1},{46.76,39.61},{46.68,38.95},{46.31,38.23},{45.94,37.86},{45.53,37.61},{45.1,37.38},{44.69,37.19},{44.25,36.73},{44.5,37.27},{44.77,37.22},{44.83,37.16},{44.74,37.15},{44.42,36.69},{44.87,36.65},{44.79,37.03},{44.79,37.03},{44.73,37.13},{45.43,37.5},{46.11,37.81},{46.58,38.4},{46.78,39.29},{46.85,40.03},{47.23,40.78},{46.53,40.54},{46.47,40.02},{46.79,40.26},{46.82,40.13},{46.55,40.49},{46.55,40.49},{46.8,40.11},{46.21,40.24},{45.78,40.44},{45.34,40.43}}}},85,nil,nil,21,nil,nil,0},
[1532] = {'Wandering Spirit',222,222,10,11,0,{[85]={{78.49,59.58},{77.7,61.55},{76.73,60.49},{77.39,58.62},{75.82,61.68},{77.47,61.53}}},nil,85,nil,nil,21,nil,nil,0},
[1533] = {'Tormented Spirit',211,211,9,9,4,{[85]={{43.97,32.13},{47.66,32.64}}},{[85]={{{44.16,31.71},{44.37,31.39},{44.78,31.21},{45.55,31.18},{45.93,31.16},{46.15,31.09},{46.5,30.85},{46.61,30.84},{46.74,30.97},{46.87,31.19},{46.94,31.39},{47.48,32.3},{47.8,32.91},{47.99,33.69},{48.07,34.27},{48.02,34.68},{47.95,34.91},{47.56,35.64},{47.21,36.03},{46.92,36.26},{46.27,36.57},{46.05,36.63},{45.78,36.63},{45.61,36.56},{45.43,36.16},{45.25,35.77},{45.05,35.53},{44.87,35.43},{44.62,35.34},{44.39,35.31},{44.06,34.76},{44.15,34.11},{44.17,33.63},{44.16,33.13},{44.07,32.67},{44.04,32.4},{44.16,31.71}}}},85,nil,nil,21,nil,nil,0},
[1534] = {'Wailing Ancestor',176,176,8,9,0,{[85]={{51.96,26.97},{52.51,26.43},{52.71,26.45},{52.66,26.68},{51.8,26.03},{52.05,25.79},{52.69,25.73},{52.95,26.98},{52.49,26.32},{52.03,27.92},{53.6,28.58},{52.57,29.16},{51.76,31.45},{52.31,28.08},{49.98,30.35},{51.47,29.24},{51.97,26.97},{52.51,26.43},{52.52,26.4},{52.64,26.65},{51.71,26.11},{51.82,27},{53.53,28.41},{52.93,26.94},{51.97,28.44},{52.31,27.36},{52.62,29.29},{52.06,25.72},{52.64,25.75},{51.87,25.85},{52.7,26.4},{51.95,27},{51.58,33.46},{51.89,31.49}}},nil,85,nil,nil,21,nil,nil,0},
[1535] = {'Scarlet Warrior',137,137,6,7,0,{[85]={{32.1,44.89},{33.77,44.79},{31.39,50.4},{31.08,46.55},{30.42,49.04},{36.66,48.19},{34.55,52.44},{37.05,47.82},{33.73,49.42},{32.62,50.79},{31.11,49.3},{31.62,49.41},{31.54,49.61},{30.9,48.17},{30.9,48.31},{32.68,48.23},{30.63,47.91},{36.05,47.41},{34.45,48.17},{34.44,49.1},{34.11,47.93},{33.86,47.47},{33.01,46.32},{32.08,47.41},{33.07,46.37},{32.21,46.72},{31.88,45.81},{31.73,46.42},{33.55,51.01},{31.98,45.92},{34.08,48.5}}},nil,85,nil,nil,67,nil,nil,0},
[1536] = {'Scarlet Missionary',143,143,7,8,0,{[85]={{52.8,69.31},{53.5,68.28},{53.96,66.76},{50.33,66.93},{48.85,66.77},{50.12,68.82},{50.54,67.75},{50.43,64.74},{51.09,65.59},{52.79,69.31},{54.16,69.19},{52.77,68.24},{51.65,66.7},{50.48,64.49},{50.28,66.95},{50.11,68.77},{54.22,69.31},{51.2,65.79}}},nil,85,nil,nil,67,nil,nil,0},
[1537] = {'Scarlet Zealot',156,156,8,8,0,{[85]={{54.22,69.03},{48.8,66.28},{51.16,67.6},{48.79,67.42},{80.95,56.93},{50.6,67.96},{79.98,57.13},{51.18,69.63},{51.78,66.11},{51.52,67.59},{52.13,68.54},{51.96,69.65},{53.62,66.04},{52.78,67.06},{53.32,67.78},{52.16,67.17},{53.66,67.8},{51.15,67.59},{76.98,56.2},{77.14,55.17},{79.65,55.19},{77.18,56.77},{78.38,56.03},{80.03,56.33},{80.29,57.09},{79.64,55.21},{80,56.34},{80.92,56.92},{79.95,56.37},{79.62,55.11},{79.63,55.28},{79.98,56.32},{79.99,56.33},{52.22,68.57},{52.05,69.51},{52.81,69.34},{51.27,69.68},{51.79,66.03},{53.68,65.99},{52.15,67.12}}},nil,85,nil,nil,67,nil,nil,0},
[1538] = {'Scarlet Friar',186,186,9,10,0,{[85]={{78.88,36.1},{81.11,56.9},{78.86,56.23},{81.31,56.11},{78.49,56.04},{79.45,55.51},{77.1,54.88},{79.4,56.24},{78.46,33.95},{79.59,26.91},{79.17,30.41},{79.02,31.23},{79.49,29.41},{78.94,28.29},{79.29,26.57}}},nil,85,nil,nil,67,nil,nil,0},
[1539] = {'Scarlet Neophyte',186,186,10,11,0,{[85]={{77.73,33.72},{78.46,36.19},{79.18,30.55},{78.46,32.49},{79.02,28.53},{79.33,28.35},{79.23,31.92},{79.12,27.09},{79.46,30.58},{79.22,30.08}}},nil,85,nil,nil,67,nil,nil,0},
[1540] = {'Scarlet Vanguard',198,198,10,11,0,{[85]={{78,35.91},{77.61,34.71},{78.67,36.09},{78.23,36.03},{77.65,32.79},{79.83,23.83},{77.91,34.71},{79.18,27.02},{78.88,32.78},{78.68,32.5},{78.35,32.88},{78.27,31.99},{78.02,34.18},{79.04,27.59},{79.42,29.61},{79.58,30.34},{79.78,26.55},{79.48,27.99},{79.53,27.14},{78.8,28.12},{77.84,35.73},{79.18,27.02},{78.93,31.37},{79.38,29.2}}},nil,85,nil,nil,67,nil,nil,0},
[1541] = {'Vile Fin Murloc',176,176,8,9,0,{[85]={{60.87,25.95},{57.73,26.56},{61.68,24.92},{62.96,28.79},{57.9,26.35},{62.85,29.28},{60.83,27.41},{59.93,28.91},{58.51,28.79},{61.3,30}}},nil,85,nil,nil,18,nil,nil,0},
[1543] = {'Vile Fin Puddlejumper',102,102,5,6,0,{[85]={{36.9,43.35},{34.84,42.35},{34.37,43.71},{34.96,45.1},{34.59,43.66},{34.9,44.96},{35.8,43.65}}},nil,85,nil,nil,18,nil,nil,0},
[1544] = {'Vile Fin Minor Oracle',131,131,6,7,0,{[85]={{64.51,29.83},{64.66,30.38},{64.82,29.78},{31.49,43.68},{36.41,38.38},{36.54,40.75},{35.92,43.99},{35.7,41.77},{34.73,44.86},{35.86,44.58},{35.12,42.59},{35.88,43.68}}},nil,85,nil,nil,18,nil,nil,0},
[1545] = {'Vile Fin Muckdweller',176,176,8,9,0,{[85]={{62.39,26.12},{63.23,27.97},{61.54,27.06},{57.7,28.3},{67.75,28.54},{62.72,28.18},{65.24,26.11},{66.11,27.11},{64.72,30.36},{62.76,27.29},{63.37,27.81},{63.09,26.34},{63.1,27.5},{67.39,29.28},{66.87,30.49},{57.69,26.06},{64.63,27.34},{64.95,30.84},{65.55,28.21},{64.86,30.95},{63.95,30.36},{65.34,30.54},{60.84,27.54},{58.58,26.86},{60.09,29.49},{62.36,30.46},{58.57,28.83},{58.38,28.18},{59.46,29.24},{61.13,28.5}}},nil,85,nil,nil,18,nil,nil,0},
[1547] = {'Decrepit Darkhound',120,120,5,6,0,{[85]={{41.33,48.17},{46.19,57.66},{62.28,39.6},{64.76,62.69},{66.78,63.7},{40.12,45.94},{40.65,45.9},{50.56,51.03},{63.02,40.52},{60.93,44.62},{70.31,64.65},{61.82,45.39},{69.71,63.65},{41.78,55.84},{65.9,62.49},{40.31,41.37},{39.65,40.8},{35.87,45.83},{42.65,48.12},{40.3,44.24},{60.33,40.23},{69,64.84},{39.28,44.95},{47.69,58.48},{41.28,55.73},{40.63,47.4},{38.12,40.44},{38.65,43.76},{38.83,39.32},{41.46,49.08},{38.79,41.27},{63.53,45.33},{57.67,52.61},{43.44,55.83},{62.8,37.94},{62.49,48.56},{62.44,46.73},{57.09,53.45},{55.02,53.35},{61.3,43.06},{39.05,47.16},{43.11,51.3},{38.84,42.56},{42.66,53.71},{61.18,55.6},{59.96,55.6},{39,47.14},{44.69,56.63},{40.89,43.8},{39.31,52.24},{40.87,53.03},{38.09,45.32},{63.01,54.27},{59.27,56.97},{41.16,49.17},{40.57,47.12},{58.43,54.04},{66.1,55.96},{63.21,51.03},{67.9,55.61},{63.11,54.06},{60.97,55.75},{58.5,53.47},{57.89,53},{56.39,53.73},{64.22,56.33},{64.28,58.99},{59.24,56.89},{65.78,57.16},{59.09,53.88},{59.05,54.25},{59.9,55.6},{66.88,63.94},{68.95,64.94}}},nil,85,nil,nil,38,nil,nil,0},
[1548] = {'Cursed Darkhound',156,156,7,8,0,{[85]={{52.4,71.35},{52.84,73.58},{53.44,72.55},{51.8,72.44},{56.4,64.12},{54.44,71.89},{47.64,59.34},{48.22,59.94},{46.98,60.23},{64.54,33.82},{42.33,46.48},{51.92,72.52},{67.5,31.43},{55.71,73.86},{44.03,58.85},{51.15,62.38},{76.43,31.32},{47.89,51.67},{51.12,59.55},{40.78,57.71},{41.38,44.23},{52.9,73.35},{49.75,64.78},{49.98,60.26},{63.05,34.03},{50.6,71.42},{52.98,62.46},{45.51,60.06},{41.91,46.04},{65.44,32.99},{77.6,31.91},{57.42,62.81},{58.35,61.16},{58.68,62.29},{57.37,61.88},{60.3,61.74},{59.3,62.49},{54.22,65.83},{58.58,58.37},{53.95,61.27},{54.92,62.75},{55.81,61.72},{40.19,42.46},{54.16,63.99},{57.27,59.83},{53.12,62.56},{59.26,60.19},{55.88,60.59},{54.34,66.9},{57.86,59.76},{56.46,59.48},{58.6,58.37},{76.88,34.56},{51.19,70.22},{53.58,72.49},{58.5,62.11},{54.33,71.66},{58.35,59.76},{58.02,61.49},{57.36,61.89},{56.64,63.97},{57.53,62.98},{54.25,61.17},{54.88,62.88},{58.62,58.42},{53.54,63.57},{56.04,60.91},{55.59,73.82}}},nil,85,nil,nil,38,nil,nil,0},
[1549] = {'Ravenous Darkhound',198,198,9,10,0,{[85]={{85.43,41.43},{83.78,41.61},{86.82,46.32},{81.56,45.06},{83.13,46.98},{88.72,47.38},{82.38,50.13},{82.85,49.68},{85.85,40.35},{83.67,44.05},{88.05,43.69},{83.05,40.6},{88.39,47.87},{83.34,46.09},{81.98,46.88},{80.69,42.71},{85.05,44.05},{82.59,51.69},{88.95,44.72},{87.46,46.89},{85.78,45.08},{89.67,43.97},{88.47,41.61},{89.63,46.07},{81.99,48.4},{89.5,47.7},{81.19,51.1},{82.07,44.11},{88.18,46.16}}},nil,85,nil,nil,38,nil,nil,0},
[1550] = {'Thrashtail Basilisk',905,905,29,30,0,{[5287]={{63.21,31.45},{63.75,30.54},{62.4,27.98},{63.11,29.26},{62.22,30.72},{59.91,20.87},{60.32,24.88},{59.08,30.48},{58.01,28.93},{60.7,30.54},{62.68,30.47},{60.68,28.81},{64.07,30.38},{63.47,28.95},{63.27,31.45},{62.38,28.01},{62.25,32.7},{64.04,30.63}}},nil,5287,nil,nil,49,nil,nil,0},
[1551] = {'Ironjaw Basilisk',905,905,30,30,0,{[5287]={{66.16,26.83},{65.78,28.28},{66.29,22.88},{64.96,25.68},{67.17,22.56},{65.88,23.61},{68.07,28.14},{64.66,29.74},{66.66,28.22},{65.63,29.03},{67.32,26.21},{68.54,25.73},{67.6,26.96},{67.72,23.51},{68.03,26.08},{67.71,24.32},{67.43,24.83},{66.16,26.83},{68.53,25.73},{67.7,24.33},{67.6,26.95},{67.32,26.23},{65.73,28.2},{67.73,23.46},{68.07,28.14},{66.72,28.25},{66.22,22.91},{64.89,25.71},{65.8,23.59},{67.18,22.58},{68.02,26.06},{65.67,29},{64.7,29.84}}},nil,5287,nil,nil,49,nil,nil,0},
[1552] = {'Scale Belly',2012,2012,31,31,4,{[5287]={{66.15,26.23},{67.85,25.44}}},nil,5287,nil,nil,49,nil,nil,0},
[1553] = {'Greater Duskbat',137,137,6,7,0,{[85]={{55.9,69.76},{54.75,66.16},{37.39,38.24},{40.32,51.65},{38.34,38.55},{45.43,49.71},{46.19,56.07},{45.43,55.18},{46.15,54.5},{60.33,43},{59.89,41.55},{62.88,43.96},{62.89,50.2},{57.26,60.47},{59.39,61.55},{42.84,46.96},{39.58,49.91},{39.17,47.19},{44.12,49.06},{46.07,52.34},{56.7,62.92},{46.98,58},{42.72,56.68},{43.39,52.11},{47.06,51.27},{47.53,56.33},{60.98,41.36},{60.8,39.42},{59.37,57.96},{54.3,61.05},{41.21,56.89},{59.92,56.42},{50.14,59.3},{44.08,55.67},{61.78,38.03},{62.03,37.24},{63.24,55.16},{60.27,60.75},{54.95,64.02},{57.73,56.2},{39.41,42.47},{40.88,42.12},{37.85,42.94},{45.33,58.36},{60.77,57.1},{37.57,47.21},{64.04,51.73},{64.65,50.2},{63.24,47.84},{37.49,46.34},{40.59,56.28},{63.65,49.25},{62.03,43.02},{69.72,56.17},{36.5,47.25},{41.78,52.61},{47.12,59.56},{37.27,43.67},{62.21,41.59},{62.48,46},{41.96,51.46},{42.95,50.7},{41.42,47.49},{42.52,53.63},{39.97,48.54},{45.3,57.14},{48.62,59.15},{55.79,60.51},{52.89,64.38},{43.35,57.62},{63.87,46.93},{63.69,52.76},{62.28,43.94},{62.77,36.13},{47.17,52.79},{58.64,56.91},{57.28,58.35},{55.75,62.6},{56.69,58.42},{53.45,64.96},{53.05,62.64},{71.36,63.66},{55.93,53.42},{68.83,61.38},{68.74,56.37},{54.86,65.7},{66.68,61.69},{63.94,61.73},{53.78,62.23},{67.81,63.69},{65.36,59.38},{65.34,56.66},{40.35,51.76},{57.4,53.34},{58.66,55.64},{41.75,53.97},{40.89,51.42},{41.8,52.39},{39.55,47.37},{64.42,54.84},{57.96,56.27},{52.97,62.69},{54.66,60.67},{60.05,56.68},{54.24,62.44},{55.75,60.86},{67.22,55.6},{59.11,58.4},{58.59,54.84},{63.62,54.67},{59.97,56.83},{60.59,57.26},{59.32,61.56},{58.75,57.09},{62.32,57.42},{57.24,60.39},{65.14,58.06},{56.98,62.93},{59.23,58.47},{57.31,53.67},{58.59,57.09},{68.15,63.91}}},nil,85,nil,nil,15,"AH",nil,0},
[1554] = {'Vampiric Duskbat',176,176,8,9,0,{[85]={{78.24,69.44},{77.63,66.14},{81.36,49.19},{46,59.32},{78.47,71.68},{84.64,44.7},{52.01,62.96},{79.33,59.21},{71.95,59.3},{79.91,64.67},{82.95,44.53},{63.84,32.83},{74.73,65.91},{69.91,60.01},{79.96,44.36},{82.38,45.99},{76.15,34.18},{48.99,59.39},{53.83,61.21},{50.72,61.52},{74.27,69.36},{78.54,62.44},{79.33,68.33},{84.6,40.82},{76.9,30.87},{73.26,63.49},{73,62.74},{88.59,43.06},{83.01,42.66},{78.59,64.7},{80.64,46.1},{80.71,47.54},{87.02,40.69},{82.21,41.97},{79.46,72.82},{76.59,72.4},{78.58,73.63},{82.14,63.9},{82.27,66.25},{79.34,70.78},{83.54,50.07},{82.31,52.82},{74.9,63.66},{69.08,59.26},{81.73,74.32},{75.37,69.53},{84.36,42.94},{83.78,48.11},{79.14,44.55},{83,65.11},{80.7,70.48},{51.82,60.75},{73.93,67.16},{79.21,70.77},{75.66,71.4},{76.33,66.11},{76.12,63.94},{80.67,59.47},{71.31,58.47},{80.74,66.48},{72.65,65.23},{80.8,68.16},{80.16,62.61},{70.53,60.7},{67.43,58.74},{55.22,60.19},{49.46,68.45},{52.82,64.06},{77.02,71.15},{81.52,67.24},{83.58,66.09},{70.57,60.81},{67.87,59.36},{69.76,60.53},{78.59,69.05},{79.23,68.62},{53.93,61.13},{52.24,62.79}}},nil,85,nil,nil,16,nil,nil,0},
[1555] = {'Vicious Night Web Spider',198,198,9,10,0,{[85]={{87.44,49.54},{86.98,53.94},{85.18,48.37},{86.69,52.89},{86.76,50.81},{85.96,54.16},{85.06,54.8},{84.54,47.07},{87.25,51.3},{83.75,52.61},{84.38,51.23},{87.61,53.29},{88.02,52.62},{89.75,50.48},{90.25,49.16},{88.85,49.47},{88.14,50.92},{83.6,55.16},{84.42,53.54},{85.15,52.87},{85.81,51.4},{83.08,56.12},{85.41,50.66},{82.48,54.75},{85.78,48.95},{86.71,48.33},{82.46,54.79},{84.53,53.5},{85.12,52.5},{83.74,52.74},{85.9,51.68},{85.27,50.49}}},nil,85,nil,nil,22,nil,nil,0},
[1557] = {'Elder Mistvale Gorilla',1006,1006,31,31,0,{[5287]={{51.49,57.02},{47.63,54.42},{50.32,57.78},{49.12,59.31},{51.23,54.57},{49.01,56.31},{48.61,58.12},{52.8,52.88},{49.66,57.27},{50.74,53.58},{48.61,56.53},{49.86,55.96},{52.49,52.39},{50.52,55.53},{53.14,54.5},{50.86,51.71},{52.75,49.6}}},nil,5287,nil,nil,72,nil,nil,0},
[1558] = {'Silverback Patriarch',1057,1057,32,33,0,{[5287]={{57.95,49.15},{54.1,49.73},{57.22,49.52},{54.19,51.4},{58.42,47.26},{56.11,49.93},{58.69,46.63},{55.72,51.55},{54.92,51.67},{54.78,51.16},{55.65,51.38}}},nil,5287,nil,nil,72,nil,nil,0},
[1559] = {'King Mukla',2220,2220,33,33,0,{[5287]={{62.54,83.28}}},nil,5287,nil,nil,16,nil,nil,0},
[1560] = {'Yvette Farthing',328,328,15,15,0,{[85]={{61.75,52.66}}},nil,85,nil,{361},68,"H",nil,0},
[1561] = {'Bloodsail Raider',1057,1057,31,32,0,{[5287]={{42.61,62.48},{39.31,57.41},{41.27,58.96},{49.82,66.79},{48.98,66.01},{49.51,64.75},{50.38,68.26},{48.03,64.39}}},nil,5287,nil,nil,119,nil,nil,0},
[1562] = {'Bloodsail Mage',802,802,31,32,0,{[5287]={{40.54,57.47},{41.66,61.25},{41.29,61.84},{42.08,60.25},{38.69,55.58}}},nil,5287,nil,nil,119,nil,nil,0},
[1563] = {'Bloodsail Swashbuckler',955,955,30,31,0,{[5287]={{35.37,38.1},{33.98,35.93},{35,35.81},{36.36,33.97},{36.68,35.82}}},nil,5287,nil,nil,119,nil,nil,0},
[1564] = {'Bloodsail Warlock',737,737,30,31,0,{[5287]={{34.4,36.72},{36.16,39.2},{34.47,33.89},{34.11,35.11},{36.5,35.9},{36.55,37.03},{36.25,38.28}}},nil,5287,nil,nil,119,nil,nil,0},
[1565] = {'Bloodsail Sea Dog',1057,1057,32,33,0,{[5287]={{40.57,84.58},{51.4,88.85},{40.58,82.32},{40.25,82.76}}},nil,5287,nil,nil,119,nil,nil,0},
[1568] = {'Undertaker Mordo',0,0,5,5,0,{[6454]={{43.42,79.93}}},nil,6454,{26799,28608,28652},{24959,26799,28608},68,"H",nil,2},
[1569] = {'Shadow Priest Sarvis',0,0,5,5,0,{[6454]={{46.62,58.8}}},nil,6454,{3095,3096,3097,3098,3099,24962,24972,26801},{24971,26801,28653},68,"H",nil,2},
[1570] = {'Executor Arren',0,0,5,5,0,{[6454]={{55.47,37.79}}},nil,6454,{24970,24973,26802},{24973,26802,28672},68,"H",nil,2},
[1571] = {'Shellei Brondir',232470,232470,85,85,1,{[11]={{9.45,59.58}}},nil,11,nil,nil,12,"A","Gryphon Master",8193},
[1572] = {'Thorgrum Borrelson',232470,232470,85,85,1,{[38]={{33.94,50.95}}},nil,38,nil,nil,55,"A","Gryphon Master",8195},
[1573] = {'Gryth Thurden',232470,232470,85,85,1,{[1537]={{55.5,47.74}}},nil,1537,{6392},{6388},55,"A","Gryphon Master",8195},
[1574] = {'Mage 1',8700,8700,65,65,0,nil,nil,0,nil,nil,55,"A",nil,8192},
[1575] = {'Mage 5',11000,11000,65,65,0,nil,nil,0,nil,nil,55,"A",nil,8192},
[1576] = {'Mage 10',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1577] = {'Mage 15',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1578] = {'Mage 20',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1579] = {'Mage 30',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1580] = {'Mage 40',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1581] = {'Warlock 1',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1582] = {'Warlock 5',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1583] = {'Warlock 10',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1584] = {'Warlock 15',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1585] = {'Warlock 20',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1586] = {'Warlock 30',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1587] = {'Warlock 40',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1588] = {'Shaman 1',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1589] = {'Shaman 5',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1590] = {'Shaman 10',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1591] = {'Shaman 15',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1592] = {'Shaman 20',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1593] = {'Shaman 30',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1594] = {'Shaman 40',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1595] = {'Rogue 1',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1596] = {'Rogue 5',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1597] = {'Rogue 10',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1598] = {'Rogue 15',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1599] = {'Rogue 20',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1600] = {'Rogue 30',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1601] = {'Slim\'s Test Rogue',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1602] = {'Paladin 1',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1603] = {'Paladin 5',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1604] = {'Druid 1',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1605] = {'Paladin 10',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1606] = {'Paladin 15',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1607] = {'Druid 5',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1608] = {'Druid 10',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1609] = {'Druid 15',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1613] = {'Paladin 20',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1614] = {'Paladin 30',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1615] = {'Paladin 40',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1616] = {'Druid 20',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1617] = {'Druid 30',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1618] = {'Hunter 1',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1619] = {'Druid 40',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1620] = {'Hunter 5',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1621] = {'Hunter 10',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1622] = {'Priest 1',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1623] = {'Hunter 15',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1624] = {'Priest 5',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1625] = {'Hunter 20',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1626] = {'Priest 10',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1627] = {'Priest 15',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1628] = {'Hunter 30',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1629] = {'Priest 20',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1631] = {'Hunter 40',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1632] = {'Adele Fielder',573,573,22,22,0,{[12]={{46.38,62.05}}},nil,12,nil,nil,12,"A","Leatherworking Trainer",81},
[1633] = {'Priest 30',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1634] = {'Priest 40',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1635] = {'Warrior 1',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1636] = {'Warrior 5',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1637] = {'Warrior 10',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1638] = {'Warrior 15',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1639] = {'Warrior 20',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1640] = {'Warrior 30',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1641] = {'Warrior 40',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1642] = {'Northshire Guard',0,0,90,90,1,{[12]={{44.03,47.31}},[6170]={{24.94,67.93},{29.81,73.82},{23.98,73.6},{23.4,75.81},{24.19,75.94}}},nil,6170,nil,nil,11,"A",nil,0},
[1645] = {'Quartermaster Hicks',198,198,10,10,0,{[12]={{25.37,74}}},nil,12,nil,nil,12,"A","Master Weaponsmith",4224},
[1646] = {'Baros Alexston',1003,1003,30,30,0,{[1519]={{57.74,47.86}}},nil,1519,nil,{373,392,395,399},12,"A","City Architect",0},
[1649] = {'UNUSED Jordan Croft',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Reuse Me",0},
[1650] = {'Terry Palin',222,222,11,11,0,{[12]={{82.95,63.31}}},nil,12,nil,nil,12,"A","Lumberjack",128},
[1651] = {'Lee Brown',156,156,8,8,0,{[12]={{47.61,62.32}}},nil,12,nil,nil,12,"A","Fishing Trainer",81},
[1652] = {'Deathguard Burgess',154980,154980,85,85,0,{[85]={{60.93,52.05}}},nil,85,nil,{374},68,"H",nil,1},
[1653] = {'Bloodsail Elder Magus',802,802,32,33,0,{[5287]={{45.01,90.22},{45.41,90.85},{51.81,88.2},{45.56,89.85},{40.11,83.8},{41.95,82.44},{42.58,81.73},{41.41,83.4},{40.76,82.99},{41.14,82.59}}},nil,5287,nil,nil,119,nil,nil,0},
[1654] = {'Gregor Agamand',229,229,9,9,0,{[85]={{46.07,29.4}}},{[85]={{{46.74,29.31},{46.29,29.11},{46,29.04},{45.85,29.03},{45.62,28.99},{45.33,29.11},{45.14,29.4},{44.93,29.78},{44.84,30.05},{44.79,30.34},{44.79,30.61},{44.83,30.87},{44.87,31.14},{44.98,31.43},{45,31.6},{45,31.83},{44.63,32.53},{45,31.83},{45,31.6},{44.98,31.43},{44.87,31.14},{44.83,30.87},{44.79,30.61},{44.79,30.34},{44.84,30.05},{44.93,29.78},{45.14,29.4},{45.33,29.11},{45.62,28.99},{45.85,29.03},{46,29.04},{46.29,29.11},{46.74,29.31}}}},85,nil,nil,21,nil,nil,0},
[1655] = {'Nissa Agamand',229,229,9,9,0,{[85]={{49.68,36.17}}},{[85]={{{49.74,36.34},{49.65,36.18},{49.48,36.1},{49.45,35.97},{49.45,35.88},{49.51,35.64},{49.55,35.62},{49.61,35.68},{49.63,35.81},{49.59,36.03},{49.42,36.06},{49.35,36.03},{49.64,36.15},{49.79,36.22},{49.64,36.15},{49.42,36.06},{49.35,36.03},{49.59,36.03},{49.63,35.81},{49.61,35.68},{49.55,35.62},{49.51,35.64},{49.45,35.88},{49.45,35.97},{49.48,36.1},{49.65,36.18},{49.74,36.34}}}},85,nil,nil,21,nil,nil,0},
[1656] = {'Thurman Agamand',229,229,9,9,0,{[85]={{45.95,30.2}}},{[85]={{{43.2,34.69},{43.25,34.52},{43.34,34.43},{43.58,34.45},{43.81,34.05},{43.86,33.61},{43.76,32.72},{43.7,32.25},{43.36,31.88},{43.01,31.7},{42.81,31.74},{42.7,31.88},{42.67,32.13},{42.73,32.33},{42.78,32.46},{42.86,32.55},{42.76,32.4},{42.67,32.14},{42.7,31.89},{42.77,31.74},{42.95,31.64},{43.1,31.68},{43.27,31.84},{43.52,32.01},{43.68,32.18},{43.75,32.46},{43.86,33.32},{43.91,33.93},{43.87,34.84},{43.97,35.01},{44.02,35.13},{44.01,35.22},{43.97,35.29},{43.49,35.47},{43.97,35.29},{44.01,35.22},{44.02,35.13},{43.97,35.01},{43.87,34.84},{43.58,34.45},{43.34,34.43},{43.25,34.52}}}},85,nil,nil,21,nil,nil,0},
[1657] = {'Devlin Agamand',216,216,9,9,0,{[85]={{48.95,33.92},{48.93,34.24}}},nil,85,nil,nil,21,nil,nil,0},
[1658] = {'Captain Dargol',273,273,13,13,0,{[85]={{52.81,26.35}}},nil,85,nil,nil,21,nil,nil,0},
[1660] = {'Scarlet Bodyguard',156,156,8,8,0,{[85]={{79.46,25.25}}},nil,85,nil,nil,67,nil,nil,0},
[1661] = {'Novice Elreth',0,0,3,3,0,{[6454]={{46.74,58.19}}},nil,6454,{24961,28672},{24961,28651},68,"H",nil,2},
[1662] = {'Captain Perrine',176,176,9,9,0,{[85]={{51.15,67.81},{51.16,67.8}}},nil,85,nil,nil,67,nil,nil,0},
[1663] = {'Dextren Ward',2097,2200,25,25,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1664] = {'Captain Vachon',222,222,11,11,0,{[85]={{78.82,56.13}}},nil,85,nil,nil,67,nil,nil,0},
[1665] = {'Captain Melrache',247,247,12,12,0,{[85]={{79.53,25.13}}},nil,85,nil,nil,67,nil,nil,0},
[1666] = {'Kam Deepfury',2097,2097,25,25,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1667] = {'Meven Korgal',102,102,5,5,0,nil,{[85]={{{36.57,68.54},{36.48,68.85}}}},0,nil,nil,7,"AH",nil,0},
[1668] = {'William MacGregor',328,328,15,15,0,{[40]={{57.72,53.71}}},nil,40,nil,nil,12,"A","Bowyer",4224},
[1669] = {'Defias Profiteer',484,484,20,20,0,nil,nil,0,nil,nil,1802,"A","Free Wheeling Merchant",4224},
[1670] = {'Mike Miller',484,484,20,20,0,{[40]={{57.53,54}}},nil,40,nil,nil,12,"A","Bread Merchant",640},
[1671] = {'Lamar Veisilli',713,713,25,25,0,{[44]={{21.38,42.63}}},nil,44,nil,nil,12,"A","Fruit Seller",640},
[1672] = {'Lohgan Eva',102,102,5,5,0,{[10]={{75.73,44.54}}},nil,10,nil,nil,12,"A","Tailoring Supplies",128},
[1673] = {'Alyssa Eva',137,137,7,7,0,{[10]={{76.12,45.44}}},nil,10,nil,nil,12,"A","Reagents",2176},
[1674] = {'Rot Hide Gnoll',137,137,6,7,0,{[85]={{59.54,44.16},{55.5,44.86},{58.52,42.82},{58.56,42.05},{58.47,40.41},{58.68,33.84},{56.66,35.07},{56.86,38.43},{58.84,38.04},{59.3,39.35},{58.01,39.29},{58.67,36.19},{60.05,34.34},{57.29,36.01},{57.95,37.3},{58.02,37.12},{57.19,33.95},{57.3,35.93},{58.56,34.4}}},nil,85,nil,nil,70,nil,nil,0},
[1675] = {'Rot Hide Mongrel',137,137,7,8,0,{[85]={{57.91,32.51},{59.47,33.24},{56.87,32.81},{59.01,36.17},{57.04,33.67},{56.34,33.73},{56.74,35.89},{58.63,32.82},{57.87,31.79},{59.99,37.94},{57.66,32.59},{60.82,31.95},{59.37,35.5},{59.17,30.63},{58.51,30.99},{58.73,31.02},{60.45,37.42},{59.51,32.88},{58.61,32.83},{59.83,34.24},{60.54,36.82},{58.44,31.75},{59.42,35.51},{57.19,35.46},{57.96,31.86},{58.63,32.81},{58.41,31.66}}},nil,85,nil,nil,70,nil,nil,0},
[1676] = {'Finbus Geargrind',1107,1107,31,31,0,{[10]={{77.39,48.8}}},nil,10,nil,nil,875,"A","Engineering Trainer",81},
[1678] = {'Vernon Hale',198,198,10,10,0,{[44]={{26.82,43.99}}},nil,44,nil,nil,12,"A","Fishing Supplies",640},
[1679] = {'Avarus Kharag',622,622,25,25,0,{[1]={{75.36,54.45}}},nil,1,nil,nil,57,"A",nil,0},
[1680] = {'Matthew Hooper',198,198,10,10,0,{[44]={{26.38,46.76}}},{[44]={{{26.99,51.13},{26.26,50.65},{26.54,51.26}}}},44,nil,nil,12,"A","Fishing Trainer",81},
[1681] = {'Brock Stoneseeker',328,328,15,15,0,{[38]={{37.02,47.81}}},nil,38,nil,nil,55,"A","Mining Trainer",83},
[1682] = {'Yanni Stoutheart',328,328,15,15,0,{[38]={{34.76,48.62}}},nil,38,nil,nil,55,"A","General Supplies",640},
[1683] = {'Warg Deepwater',328,328,15,15,0,{[38]={{40.56,39.66}}},nil,38,nil,nil,55,"A","Fishing Trainer",81},
[1684] = {'Khara Deepwater',328,328,15,15,0,{[38]={{40.28,39.28}}},nil,38,nil,nil,55,"A","Fishing Supplies",640},
[1685] = {'Xandar Goodbeard',328,328,15,15,0,{[38]={{82.48,63.34}}},nil,38,nil,nil,55,"A","General Supplies",640},
[1686] = {'Irene Sureshot',328,328,15,15,0,{[38]={{83.17,63.45}}},nil,38,nil,nil,55,"A","Gunsmith",4224},
[1687] = {'Cliff Hadin',328,328,15,15,0,{[38]={{83.02,62.9}}},nil,38,nil,nil,55,"A","Bowyer",4224},
[1688] = {'Night Web Matriarch',0,0,5,5,0,{[6454]={{18.16,25.62}}},nil,6454,nil,nil,7,"AH",nil,0},
[1689] = {'Scarred Crag Boar',176,176,9,10,0,{[1]={{80.69,51.25},{80.13,58.55},{87.26,55.22},{78.25,60.83},{88.39,53.62},{88.14,41.7},{82.17,58.97},{86.16,56.4},{89.36,36.24},{86.57,47.7},{82.64,55.29},{80.38,53.64},{86.5,53.48},{81.56,47.12},{82.55,47.45},{88.72,51.48},{86.94,50.36},{87.47,45.34},{87.06,41.83},{90.33,36.13},{80.89,49.47},{81.39,49.4},{87.47,45.31},{78.46,51.66},{81.05,51.36},{82.19,58.99},{82.8,56.18},{80.53,52.91},{81.22,47.48},{81.6,48.98},{78.66,52.24},{80.52,49.17},{88.11,53.69},{86.61,54.03},{87.22,50.49},{88.47,51.56}},[38]={{13.9,52.79},{13.42,57.3},{16.82,55.12},{13.85,52.77},{17.17,50.57},{17.31,56.46},{17.44,53.53},{13.59,57.28}}},nil,1,nil,nil,189,"AH",nil,0},
[1690] = {'Thrawn Boltar',950,950,29,29,0,{[1]={{52.4,49.85}}},nil,1,nil,nil,55,"A","Blacksmithing Supplies",4224},
[1691] = {'Kreg Bilmn',198,198,10,10,0,{[1]={{54.3,50.73}}},nil,1,nil,nil,55,"A","General Supplies",640},
[1692] = {'Golorn Frostbeard',198,198,10,10,0,{[1]={{53.78,51.82}}},{[1]={{{46.66,53.57},{46.72,53.74},{46.77,53.72},{46.72,53.74},{46.68,53.7},{46.66,53.57},{46.67,53.49},{46.67,53.49}}}},1,nil,nil,55,"A","Tradesman",128},
[1693] = {'Loch Crocolisk',300,300,14,15,0,{[38]={{56.29,57.79},{48.91,64.47},{52.7,66.56},{55.04,60.03},{51.49,63.72},{50,63.46},{50.32,66.43},{53.82,63.15},{52.74,60.81},{53.62,57.98},{59.9,53.97},{58.68,57.7},{57.58,54.31},{55.96,57.99},{48,61.3},{48.54,63.82},{52.82,66.63},{55.29,59.83},{50.37,60.25},{51.56,63.53},{50.39,66.28},{53.95,63.16},{52.6,60.83},{61.2,46.88},{62.39,48.72},{60.24,53.87},{57.75,51.07},{55.2,52.34},{55.05,49.39},{60.31,50.56},{58.88,48.9},{52.76,56.22},{48.32,61.69},{48.7,64.37},{50.4,60.12},{51.48,63.84},{54.71,55.41},{53.75,57.87},{56.69,49.26},{61.07,46.88},{62.43,48.71}}},nil,38,nil,nil,14,nil,nil,0},
[1694] = {'Loslor Rudge',198,198,10,10,0,{[1]={{57.21,47.73}}},nil,1,nil,nil,55,"A","Engineering Supplies",131},
[1695] = {'[Deprecated for 4.x]Rendow',1848,1848,45,45,0,nil,nil,0,nil,nil,1076,"A","Leather Armor Merchant",4224},
[1696] = {'Targorr the Dread',1953,1953,24,24,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1697] = {'Keeg Gibn',0,0,10,10,0,{[6457]={{48.79,53.4}}},nil,6457,nil,nil,55,"A","Ale & Wine",640},
[1698] = {'Frast Dokner',198,198,10,10,0,{[1]={{76.23,54.24}}},{[1]={{{69,55.89},{68.95,55.84},{68.88,55.86},{68.86,55.95},{68.88,55.87},{68.95,55.85}}}},1,nil,nil,55,"A","Apprentice Weaponsmith",4224},
[1699] = {'Gremlock Pilsnor',198,198,10,10,0,{[1]={{54.78,50.63}}},nil,1,{6387},{6392},55,"A","Cooking Trainer",83},
[1700] = {'Paxton Ganter',0,0,10,10,0,{[6457]={{62.24,38.16}}},nil,6457,nil,nil,55,"A","Fishing Trainer",81},
[1701] = {'Dank Drizzlecut',198,198,10,10,0,{[1]={{76.56,53.8}}},nil,1,nil,nil,55,"A","Mining Trainer",81},
[1702] = {'Bronk Guzzlegear',664,664,24,24,0,{[1]={{57.3,48.69}}},nil,1,nil,nil,55,"A","Engineering Trainer",81},
[1703] = {'Uthrar Threx',664,664,24,24,0,{[1537]={{43.82,27.86}}},nil,1537,nil,nil,55,"A","Apprentice Tailor",1},
[1706] = {'Prisoner',1815,1815,23,23,1,{[1519]={{44.25,70.9},{44.64,56.69}}},nil,1519,nil,nil,290,"AH",nil,0},
[1707] = {'Defias Captive',1815,1815,22,23,1,nil,nil,0,nil,nil,17,nil,nil,0},
[1708] = {'Defias Inmate',1953,2100,23,24,1,{[717]={{-1,-1}}},nil,717,nil,nil,17,nil,nil,0},
[1711] = {'Convict',1900,1953,23,24,1,nil,nil,0,nil,nil,17,nil,nil,0},
[1713] = {'Elder Shadowmaw Panther',905,905,29,30,0,{[5287]={{52.34,10.89},{49.46,11.3},{48.66,12.77},{39.46,28.95},{47.86,14.27}}},nil,5287,nil,nil,16,nil,nil,0},
[1714] = {'SAVE Defias Lifer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1715] = {'Insurgent',1953,1953,24,24,1,nil,nil,0,nil,nil,17,nil,nil,0},
[1716] = {'Bazil Thredd',2097,2097,25,25,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1717] = {'Hamhock',1830,1830,25,25,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1718] = {'Rockjaw Raider',71,71,3,4,0,{[1]={{42.65,67.71},{42.8,65.24},{42.72,66.38},{42,66.83},{41.6,69.33},{41.88,67.77},{42.66,64.15},{40.86,68.22},{42.65,64.09}}},nil,1,nil,nil,59,nil,nil,0},
[1719] = {'Warden Thelwater',1003,1003,30,30,0,nil,nil,0,nil,{387,389,391},12,"A",nil,0},
[1720] = {'Bruegal Ironknuckle',2097,2097,25,25,2,{[717]={{-1,-1}}},nil,717,nil,nil,14,nil,nil,0},
[1721] = {'Nikova Raskol',102,102,5,5,0,{[1519]={{73.26,55.51}}},nil,1519,nil,{388},12,"A",nil,0},
[1722] = {'Andr\'e',166,166,5,5,0,nil,nil,0,nil,nil,73,nil,nil,0},
[1723] = {'Stormwind Citizen',166,166,5,5,0,nil,nil,0,nil,nil,73,nil,"Placeholder",0},
[1724] = {'Stormwind Citizen Masculine',166,166,5,5,0,nil,nil,0,nil,nil,73,nil,"Placeholder",0},
[1725] = {'Defias Watchman',356,386,16,17,0,nil,nil,0,nil,nil,17,nil,nil,0},
[1726] = {'Defias Magician',910,980,16,17,0,nil,nil,0,nil,nil,17,nil,nil,0},
[1727] = {'Defias Worker',350,380,16,17,0,nil,nil,0,nil,nil,17,nil,nil,0},
[1729] = {'Defias Evoker',990,1062,17,18,1,nil,nil,0,nil,nil,17,nil,nil,0},
[1730] = {'Goblin Buzzcutter',75,80,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[1731] = {'Goblin Craftsman',1200,1347,18,19,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1732] = {'Defias Squallshaper',921,921,16,16,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[1733] = {'Zggi',102,102,5,5,0,{[1519]={{40.21,85.3}}},nil,1519,nil,{397},12,"A","Zardeth's Minion",2},
[1735] = {'Deathguard Abraham',154980,154980,85,85,0,{[85]={{53.63,53.02}}},nil,85,nil,nil,71,"H",nil,0},
[1736] = {'Deathguard Randolph',0,0,90,90,0,{[6454]={{51.13,53.35}}},nil,6454,nil,nil,71,"H",nil,0},
[1737] = {'Deathguard Oliver',0,0,90,90,0,{[6454]={{46.22,61.12}}},nil,6454,nil,nil,71,"H",nil,0},
[1738] = {'Deathguard Terrence',656,656,15,15,0,{[85]={{63.59,59.19}}},{[85]={{{63.47,56.55},{63.57,56.87},{63.66,57.27},{63.7,57.49},{63.72,57.75},{63.73,58.1},{63.73,58.33},{63.72,58.63},{63.68,58.88},{63.58,59.28},{63.68,58.86},{63.72,58.64},{63.74,58.14},{63.71,57.56},{63.66,57.25},{63.57,56.86},{63.49,56.58},{63.36,56.21},{63.26,55.95},{63.15,55.72},{62.98,55.63},{62.75,55.63},{62.59,55.62},{62.38,55.59},{62.25,55.46},{62.03,55.08},{61.86,54.69},{61.75,54.38},{61.65,54.03},{61.58,53.83},{61.52,53.5},{61.49,53.62},{61.58,53.84},{61.66,54.11},{61.72,54.32},{61.88,54.72},{62.07,55.15},{62.21,55.41},{62.34,55.55},{62.5,55.6},{62.76,55.63},{62.9,55.63},{63.05,55.66},{63.22,55.84},{63.35,56.16}}}},85,nil,nil,71,"H",nil,1},
[1739] = {'Deathguard Phillip',0,0,90,90,0,{[6454]={{51.36,53.77}}},nil,6454,nil,nil,71,"H",nil,0},
[1740] = {'Deathguard Saltain',0,0,90,90,0,{[6454]={{49.87,56.1}}},nil,6454,{26800,28653},{25089,26800},68,"H",nil,2},
[1741] = {'Deathguard Bartrand',0,0,90,90,0,{[6454]={{51.67,54.09}}},nil,6454,nil,nil,232,"H",nil,0},
[1742] = {'Deathguard Bartholomew',656,656,15,15,0,{[85]={{59.31,49.31}}},{[85]={{{58.47,51.39},{58.47,51.39},{58.36,51.19},{58.32,50.52},{58.34,49.81},{58.52,49.61},{58.79,49.33},{58.94,49.27},{59.15,49.29},{59.41,49.34},{59.59,49.37},{59.76,49.41},{59.86,49.43},{59.98,49.26},{60.1,49.07},{60.21,48.85},{60.29,48.62},{60.33,48.46},{60.26,48.1},{60.2,47.84},{60.07,47.48},{59.9,47.28},{59.75,47.18},{59.6,47.05},{59.44,46.94},{59.25,46.79},{59.1,47.07},{59.01,47.22},{58.81,47.45},{58.57,47.67},{58.37,47.83},{58.14,47.97},{57.99,48.05},{57.8,48.2},{57.66,48.47},{57.59,48.76},{57.47,48.84},{57.37,48.96},{57.3,49.14},{57.43,49.32},{57.63,49.32},{57.78,49.53},{57.92,49.68},{58.11,49.75},{58.26,49.81},{58.3,50.03},{58.31,50.44},{58.33,50.89},{58.36,51.19}}}},85,nil,nil,71,"H",nil,1},
[1743] = {'Deathguard Lawrence',656,656,15,15,0,{[85]={{58.49,51.48}}},nil,85,nil,nil,71,"H",nil,1},
[1744] = {'Deathguard Mort',656,656,15,15,0,{[85]={{60.07,52.81}}},{[85]={{{61.43,53.05},{61.49,53.24},{61.75,53.3},{61.96,53.3},{62.33,53.17},{62.48,53.03},{62.57,52.6},{62.57,52.1},{62.45,51.51},{62.28,50.97},{62.1,50.46},{61.93,49.94},{61.79,49.51},{61.7,49.01},{61.62,48.55},{61.55,47.9},{61.34,47.34},{61.07,46.73},{60.85,46.28},{60.72,45.98},{60.93,46.46},{61.21,47.04},{61.38,47.43},{61.52,47.98},{61.64,48.7},{61.73,49.22},{61.88,49.76},{62.16,50.59},{62.37,51.21},{62.52,51.83},{62.56,52.43},{62.51,52.94},{62.32,53.19},{62.02,53.32},{61.77,53.35},{61.45,53.25}}}},85,nil,nil,71,"H",nil,1},
[1745] = {'Deathguard Morris',656,656,15,15,0,{[85]={{60.13,52.39}}},nil,85,{6321},{6324},71,"H",nil,3},
[1746] = {'Deathguard Cyrus',656,656,15,15,0,{[85]={{60.71,51.97}}},nil,85,nil,nil,71,"H",nil,1},
[1747] = {'Anduin Wrynn',102,102,5,5,0,{[1519]={{85.72,31.56}}},nil,1519,{27044,27064},nil,12,"A","Prince of Stormwind",3},
[1748] = {'Highlord Bolvar Fordragon',1055700,1055700,73,73,3,nil,nil,0,nil,{4185,6403},12,"A",nil,0},
[1749] = {'Lady Katrana Prestor',120000,120000,72,72,0,nil,nil,0,nil,nil,12,"A",nil,1},
[1750] = {'Grand Admiral Jes-Tereth',4370,4370,62,62,0,{[1519]={{86.58,35.92}}},nil,1519,{26370,27241,29547},{26322,27240,29831},12,"A",nil,0},
[1751] = {'Mithras Ironhill',4370,4370,62,62,0,{[1519]={{86.79,35.68}}},nil,1519,nil,nil,12,"A",nil,0},
[1752] = {'Caledra Dawnbreeze',4120,4120,60,60,0,{[1519]={{80.46,35.52}}},nil,1519,nil,nil,1576,"A",nil,0},
[1753] = {'Maggot Eye',312,312,8,8,0,{[85]={{58.66,30.77}}},nil,85,nil,nil,70,nil,nil,0},
[1754] = {'Lord Gregor Lescovar',1107,1107,31,31,0,nil,{[1519]={{{76.24,29.4},{75.94,29.44},{75.28,30.26},{75.59,31.26},{73.5,33.78},{73.13,34.24},{72.49,34.97},{73.5,33.77},{75.53,31.28},{75.32,30.18},{76.01,29.37},{76.44,29.2}}}},0,nil,nil,12,"A",nil,0},
[1755] = {'Marzon the Silent Blade',1003,1003,30,30,0,nil,nil,0,nil,nil,12,"A",nil,0},
[1756] = {'Stormwind Royal Guard',154980,154980,85,85,1,{[1519]={{73.32,34.37},{73.09,33.94},{85.83,33.35},{81.86,35.56},{72.63,46.45},{84.18,31.98},{84.53,33.93},{82.92,34.62},{84.33,25.35},{86.06,32.44},{80.71,37.27},{85.37,31.16},{85.26,34.03},{84.74,31.31},{84.07,33.06},{74.99,44.52},{81.48,36.02},{73.08,47.38},{84.68,25.99},{81.03,37.89},{83.26,35.27},{83.27,34.62}}},nil,1519,nil,nil,11,"A",nil,0},
[1757] = {'Mega Rabbit',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1758] = {'Warlock (TEST)',1,1,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[1759] = {'Mage (TEST)',1,1,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[1760] = {'Warrior (TEST)',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1761] = {'Priest (TEST)',1,1,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[1762] = {'Rogue (TEST)',1,1,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[1763] = {'Gilnid',2904,2904,20,20,1,nil,nil,0,nil,nil,14,nil,"The Smelter",0},
[1764] = {'Greater Feral Spirit',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1765] = {'Worg',198,198,9,10,0,{[130]={{66.22,12.39},{63.81,5.49},{61.19,6.78},{60.7,9.83},{61.97,8.5},{60.38,7.1},{52.3,12.45},{64.69,5.86},{59.42,8.18},{56.51,19.87},{65.44,12.92},{59.5,10.39},{57.17,17.3},{58.16,17.33},{56.15,18.7},{67.08,8.31},{64.04,11.09},{60.54,12.64},{61.16,13.79},{58.7,16.02},{53.02,23.42},{56.52,25.2},{55.53,24.66},{52.22,24.42},{54,22.47},{54.77,23.64},{56.4,21.81},{55.47,21.94},{54.54,25.55}}},nil,130,nil,nil,38,nil,nil,0},
[1766] = {'Rabid Worg',222,222,11,11,0,{[130]={{67.16,53.72},{48.16,24.79},{48.29,24.17},{50.93,27.64},{47.3,33.45},{68.01,21.68},{69.73,19.75},{51.04,18.61},{51.1,20.71},{68.6,32.37},{51.46,54.67},{70.32,20.09},{44.27,30.69},{67.89,37.83},{71.68,37.52},{72.79,37.01},{73.09,34.78},{71.61,34.66},{67.75,33.45},{52.24,20.23},{52.27,18.28},{50.02,20.21},{50.52,14.34},{47.83,15.97},{66.98,19.92},{71.2,18.73},{43.73,18.33},{45.1,17.08},{49.37,16.21},{50.08,18.17},{50.88,17.44},{41.57,18.23},{40.83,19.39},{39.72,18.12},{41.44,20.21},{47.09,18.61},{50.62,61.3},{49.19,57.39},{52.24,58.04},{52.57,59.25},{53.02,30.13},{50.05,40.8},{51.04,56.47},{45.2,29.41},{46.63,28.5},{54.62,42.69},{44.55,25.74},{53.76,46.47},{44.87,52.52},{53.05,26.88},{52.06,28.15},{49.16,22.81},{50.69,58.14},{42.3,28.55},{54.21,39.69},{42.64,30.61},{48.59,28.59},{54.09,26.7},{48.09,34.49},{48.77,33.56},{37.95,24.16},{36.6,25.45},{49.02,31.24},{47.11,32.47},{38.06,22.68},{51.12,40.35},{51.72,39.65},{52.18,44.79},{51.63,42.63},{52.87,48.95},{54.07,51.09},{53.52,53.96},{55.25,52.25},{53.99,55.44},{55.35,58.63},{55.83,56.8},{55.35,55.88},{54.16,58.67},{51.81,35.36},{46.63,25.89},{41.54,21.85},{42.36,21.28},{49.27,24.35},{48.3,23.67},{48.9,26.34},{44.7,27.55},{50.6,45.84},{48.14,47.12},{53.8,45.05},{51.02,38.38},{46.6,45.43},{65.19,48.46},{67.43,48.04},{65.54,47.23},{66.59,57.42},{67.17,49.82},{68.14,51.56}}},nil,130,nil,nil,38,nil,nil,0},
[1767] = {'Vile Fin Shredder',247,273,12,13,0,nil,nil,0,nil,nil,18,nil,nil,0},
[1768] = {'Vile Fin Tidehunter',230,230,11,12,0,{[130]={{76.65,32.96},{79.56,28.81},{75.35,34},{76.37,33.91},{80.69,30.07},{75.67,32.65},{75.61,34.25},{74.71,32.87},{76.3,32.64},{77.47,30.55},{80.28,30.15},{80.33,28.99},{80.47,28.85},{80.6,28.84},{78.6,30.02},{78.14,30.41},{80.1,28.07},{80.28,28.48},{80.22,28.35},{80.2,28.83},{78.34,30.7},{78.14,30.72},{78.24,31.12},{77.66,31.64},{78.22,30.78},{77.33,33.73},{77.2,33.84},{77.61,33.55},{78.65,29.38},{79.66,31.08},{79.48,31.95},{77.5,31.42},{77.66,31.64},{77.49,30.8},{77.37,30.98},{75.59,31.69},{76.18,33.02},{76.29,32.74},{74.79,33.35},{76.38,31.75},{80.02,28.48},{79.9,28.18},{80.1,28.07},{80.05,29.31},{80.09,28.32},{80.2,28.81},{80.33,30.15},{80.34,28.53},{77.47,31.26},{77.51,31.41},{78.22,30.78},{78.32,30.72},{77.37,30.97},{77.67,31.62},{78.24,31.15},{76.97,32.08},{75.3,33.71},{77.61,33.54},{77.64,33.19},{78.56,31.5},{77.24,34.13},{77.27,33.49},{76.8,33.66},{77.25,33.84},{75.32,21.12},{79.5,28.79},{74.1,20.3},{72.8,18.38},{74.86,20.42},{76.89,19.26},{77.11,19.95},{75.74,21.05},{75.48,20.38},{73.96,16.31},{73.37,16.16},{74.99,17.02},{74.31,17.8},{76.41,20.58},{74.31,17.12},{77.12,20.26},{76.88,21.09},{75.11,19.53},{75.08,20.76},{73.08,16.48},{72.99,16.4},{73.15,16.32},{73.3,16.46},{73.18,17.58},{72.94,16.48},{77.3,32.78},{77.22,28.6},{77.92,32.42},{80.29,29.46},{75.66,22.09},{74.72,21.66},{75.25,21.61},{74,21.13},{77.49,26.72},{79.1,30.77},{76.92,27.55},{79.02,23.88},{76.24,22.24},{79.89,28.16},{78.41,30.09},{78.47,22.99},{78.37,24.54},{78.61,23.95},{78.74,24.84},{78.89,25.13},{80.61,28.85},{78.07,28.75},{80.32,28.52},{80.27,30.17},{80.22,28.35},{80.3,28.78},{80.33,31.25},{80.11,28.35},{78.06,30.56},{78.32,30.74},{80.68,30.62},{77.83,25.96},{79.55,30.16},{77.51,30.83},{77.37,30.98},{77.49,31.23},{77.49,31.36},{75.97,30.66},{75.69,31.56},{74.73,32.98},{76.84,30.68},{77.1,25.14},{77.85,24.37},{77.9,24.36},{77.68,24.65},{78.31,24.18},{77.09,26.02},{74.7,19.77},{75.15,19.72},{72.86,17.96},{72.28,17.19},{72.15,17.24},{74.28,17.67},{76.89,19.34},{75.61,19.93},{73.35,16.18},{74.43,17.15},{74.88,17.71},{73.06,16.32},{72.99,16.33},{72.95,16.55},{73.28,16.45},{73.09,16.41},{73.89,17.23},{73.87,16.01},{74.62,16.71},{76.43,19.82},{76.47,19.19},{76.83,20.29},{77.1,19.86},{76.76,19.95}}},nil,130,nil,nil,18,nil,nil,0},
[1769] = {'Moonrage Whitescalp',186,208,10,11,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1770] = {'Moonrage Darkrunner',222,247,11,12,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1772] = {'Rot Hide Gladerunner',222,247,11,12,0,nil,nil,0,nil,nil,70,nil,nil,0},
[1773] = {'Rot Hide Mystic',230,253,12,13,0,nil,nil,0,nil,nil,70,nil,nil,0},
[1775] = {'Zun\'dartha',4120,4120,60,60,0,nil,nil,0,nil,nil,29,"H",nil,0},
[1776] = {'Magtoor',2614,2614,55,55,0,{[8]={{26.94,33.55}}},nil,8,nil,{1389,1392},35,"AH",nil,2},
[1777] = {'Dakk Blunderblast',328,328,15,15,0,{[38]={{35.43,42.82}}},nil,38,{25118},{25118},57,"A",nil,2},
[1778] = {'Ferocious Grizzled Bear',222,222,10,11,0,{[130]={{52.13,10.65},{56.96,23.12},{56.2,29.41},{63.26,8.29},{64.19,7.04},{60.47,8.43},{60.63,16.27},{57.2,15.62},{56.24,17.38},{65.51,9.91},{66.91,9.19},{60.74,15.08},{61.53,12.73},{59.54,17.22},{58.86,14.35},{55.44,26.69},{53.82,24.95},{54.09,20.83},{55.7,23.39}}},nil,130,nil,nil,44,nil,nil,0},
[1779] = {'Moonrage Glutton',247,273,12,13,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1780] = {'Skitterweb Striker',247,247,11,12,0,{[130]={{34.96,12.75},{36.05,18.45},{36.99,18.19},{35.78,17.41},{35.41,19.39},{34.6,18.06},{34.37,14.51},{39.15,14.55},{36.69,16.89},{34.32,9.1},{39.13,16.9},{38.21,14.05},{35.49,13.01},{35.13,11.43},{35.54,9.26},{36.37,13.89},{35.51,14.97}}},nil,130,nil,nil,22,nil,nil,0},
[1781] = {'Skitterweb Lurker',247,247,11,11,0,{[130]={{32.9,15.65},{33.98,17.1},{34.78,15.97},{34.03,16.06},{37.86,16.8},{35.86,16.3},{37.99,18.21},{39.85,15.84},{37,13.76},{35.03,13.5},{35.55,10.38},{34.88,10.12},{37.53,15.1},{36.55,14.98},{38.24,15.6}}},nil,130,nil,nil,22,nil,nil,0},
[1782] = {'Moonrage Darksoul',273,300,13,14,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1783] = {'Skeletal Flayer',1220,1220,35,36,0,{[28]={{54.62,80.06},{54.59,81.21},{54.59,80.38},{54.3,79.84},{53.23,78.1},{53.6,78.93},{53.79,79.93}}},nil,28,nil,nil,21,nil,nil,0},
[1784] = {'Skeletal Sorcerer',1009,1009,35,36,0,{[28]={{54.09,80.9},{53.87,81.02},{54.18,81.01},{53.91,80},{54.89,80.83},{54.12,80.48},{54.13,80.88},{54.6,80.42},{54.18,80.98},{54.15,79.88},{54.89,79.68},{54.12,79.29},{54.13,79.91},{53,79.47},{54.02,79.92}}},nil,28,nil,nil,21,nil,nil,0},
[1785] = {'Skeletal Terror',3082,3293,36,38,0,nil,nil,0,nil,nil,974,nil,nil,0},
[1786] = {'Skeletal Aberration',0,0,52,54,1,nil,nil,0,nil,nil,32,"AH",nil,0},
[1787] = {'Skeletal Executioner',3293,3398,54,55,0,nil,nil,0,nil,nil,974,nil,nil,0},
[1788] = {'Skeletal Warlord',3480,3480,56,57,0,nil,nil,0,nil,nil,974,nil,nil,0},
[1789] = {'Skeletal Acolyte',2823,2915,55,56,0,nil,nil,0,nil,nil,974,nil,nil,0},
[1790] = {'Corpse Eater',64,64,1,1,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1791] = {'Slavering Ghoul',2800,3082,50,52,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1792] = {'Hissing Ghoul',1782,1782,26,26,1,nil,nil,0,nil,nil,7,"AH",nil,0},
[1793] = {'Rotting Ghoul',3293,3398,54,55,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1794] = {'Soulless Ghoul',2634,2718,54,55,0,{[28]={{44.32,73.59}}},nil,28,nil,nil,14,nil,nil,0},
[1795] = {'Searing Ghoul',2823,2915,55,56,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1796] = {'Freezing Ghoul',3529,3644,55,56,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1797] = {'Giant Rabid Bear',222,222,11,12,0,{[130]={{68.29,51.86},{67.42,50.46},{48.65,24.38},{72.34,35.54},{70.59,35.51},{43.63,48.99},{68.35,30.07},{69.24,36.18},{67.97,36.15},{43.96,48.16},{69.17,21.53},{66.41,21.33},{44.18,46.8},{52.74,60.91},{69.22,33.63},{38.77,21.09},{46.46,29.81},{68.34,19.8},{65.81,35.88},{66.64,36.56},{74.07,35.94},{68.76,34.43},{67.42,34.95},{69.62,34.35},{67.24,21.66},{49.6,14.29},{46.25,17.56},{67.74,18.48},{70.21,18.29},{43.92,16.85},{42.8,17.41},{50.6,15.8},{49.02,18.73},{48.01,17.8},{48.27,19.31},{66.34,19.87},{40.71,16.89},{43.07,19.62},{42.41,18.86},{42.23,17.48},{69.05,18.43},{44.07,52.14},{51.8,56.02},{51.54,60.19},{51.61,61.62},{56.41,58.73},{45.84,24.81},{54.96,41.51},{50.9,38.73},{53.79,43.68},{51.42,53.27},{51.79,47.31},{53.87,41.97},{55.1,44.15},{41.62,30.87},{52.09,26.03},{45.74,27.17},{50.15,51.86},{55.97,42.23},{49.72,36.04},{48.32,32.61},{48.84,36.95},{49.1,35.27},{46.15,33.35},{39.05,23.34},{40.19,23.35},{35.86,24.15},{50.68,33.08},{50.9,44.29},{50.12,42.37},{52.12,44.16},{50.04,23.42},{36,23.02},{50.85,47.09},{51.14,48.43},{50.8,50.05},{54.2,49.48},{55.02,50.3},{53.15,52.8},{54.35,56.82},{54.55,53.87},{53.25,50.68},{47.29,24.51},{47.89,26.3},{46.9,23.4},{40.95,26.53},{48.29,21.64},{42.98,23.03},{51.51,45.64},{54.61,45.18},{46.22,44.39},{53.91,39.72},{51.93,35.55},{49.47,39.99},{46.73,44.25},{66.11,51.09},{64.77,50.17},{67.43,50.93},{64.59,55.3},{65.74,49.85},{65.11,52.61},{64.98,53.48},{65.74,55.59},{65.15,62.66},{66.5,53.96},{67.16,53.67}}},nil,130,nil,nil,44,nil,nil,0},
[1798] = {'Tortured Soul',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1799] = {'Lost Wraith',0,0,54,55,1,nil,nil,0,nil,nil,51,nil,nil,0},
[1800] = {'Cold Wraith',9298,9298,58,58,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1801] = {'Blood Wraith',8519,8519,55,55,0,nil,nil,0,nil,nil,67,nil,nil,0},
[1802] = {'Hungering Wraith',1395,1395,38,38,0,{[28]={{64.28,55.9},{64.43,57.46},{64.28,57.51},{61.77,57.47},{62.9,58},{62.11,60.48},{62.16,58.36},{60.8,57.92},{62.1,60.53},{63.73,58.48},{62.94,57.04},{63.54,57.67},{63.02,59.71},{61.79,59.2}}},nil,28,nil,nil,21,nil,nil,0},
[1804] = {'Wailing Death',1336,1336,37,38,0,{[28]={{63.21,56.05},{63.49,57.62},{62.75,60.19},{63.68,58.59},{63.16,59.57},{64.85,59.63},{63.24,56.01},{61.84,58.96},{62.92,58.04},{62.16,58.33},{64.56,57.38}}},nil,28,nil,nil,21,nil,nil,0},
[1805] = {'Flesh Golem',8097,8352,56,57,1,nil,{[28]={{{47.61,69.2},{47.6,68.99},{47.6,68.7},{47.7,68.52},{47.83,68.35},{48.03,68.31},{48.24,68.33},{48.36,68.55},{48.29,68.37},{48.35,68.18},{48.49,68},{48.39,68.13},{48.24,68.33},{48.05,68.26},{47.87,68.28},{47.75,68.41},{47.63,68.6},{47.59,68.8},{47.59,69.04},{47.57,69.3},{47.5,69.46},{47.37,69.53},{47.21,69.63},{47.02,69.77},{47.08,69.97},{47.18,70.14},{47.31,70.31},{47.47,70.53},{47.61,70.8},{47.71,70.97},{47.86,71.07},{48.01,71.24},{48.11,71.37},{48.34,71.69},{48.17,71.41},{47.94,71.14},{47.76,71.05},{47.62,70.82},{47.51,70.56},{47.3,70.29},{47.03,70.05},{46.91,69.64},{46.73,69.53},{46.47,69.68},{46.48,70.3},{46.49,69.61},{46.3,69.21},{46.48,69.05},{46.68,68.83},{46.74,68.48},{46.74,68.11},{46.68,67.73},{46.6,67.43},{46.43,67.15},{46.24,66.87},{46.09,66.65},{45.96,66.27},{46.12,66.09},{45.96,66.23},{45.98,66.48},{46.09,66.66},{46.24,66.89},{46.41,67.17},{46.61,67.49},{46.68,67.72},{46.71,68.05},{46.73,68.38},{46.71,68.69},{46.55,68.93},{46.36,69.23},{46.48,69.54},{46.67,69.52},{46.86,69.57},{47.13,69.61},{47.35,69.61},{47.51,69.5}}}},0,nil,nil,14,nil,nil,0},
[1806] = {'Vile Slime',3293,3398,40,41,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1808] = {'Devouring Ooze',3529,3644,55,56,0,nil,nil,0,nil,nil,67,nil,nil,0},
[1809] = {'Carrion Vulture',2880,3082,50,52,0,nil,nil,0,nil,nil,73,nil,nil,0},
[1810] = {'Rotting Condor',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1811] = {'Plaguewing Vulture',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1812] = {'Rotting Behemoth',3529,3644,40,41,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1813] = {'Decaying Horror',3644,3758,56,57,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1815] = {'Diseased Black Bear',1277,1277,35,36,0,{[28]={{30.1,65.85},{33.85,52.46},{33.43,67.18},{31.78,63.27},{31.95,55.55},{33.35,57.54},{29.97,61.2},{34.69,64.35},{34.27,63.9},{33.64,65.13},{34.95,67.01},{36.17,63.7},{35.66,67.85},{36.97,65.49},{31.92,55.16},{34.02,56.27},{33.06,57.68}}},nil,28,nil,nil,44,nil,nil,0},
[1816] = {'Diseased Grizzly',3921,4048,55,56,0,nil,nil,0,nil,nil,44,nil,nil,0},
[1817] = {'Diseased Wolf',1336,1336,36,37,0,{[28]={{39.63,48.63},{42.83,46.91},{41.19,48.85},{47.29,45.01},{45.8,46.37},{63.65,44.87},{61.26,51.2},{50.95,47.05},{66.69,54.47},{66.91,52.75},{67.11,43.07},{62.96,47.98},{62.41,50.68},{65.95,57.1},{62.01,46.69},{62.33,51.1},{60.52,52.04},{57.18,53.55},{55.1,53.53},{58.91,54.01},{61.12,53.35},{52.43,53.89},{68.54,45.36},{65.18,54.16},{45.29,47.85},{42.89,48.42},{46.73,47.08},{47.23,48.35},{47.47,46.08},{53.39,50.59},{57.7,52.67},{55.13,51.09},{55.77,49.64},{53.74,48.39},{55.87,51.77},{56.39,51.14},{58.34,51.13},{54.35,47},{52.74,51.8},{54.45,49.33},{56.5,53.12},{55.23,53.55},{64.25,49.91},{65.31,55.05},{55.27,52.99},{57.2,53.53},{52.21,53.9},{56.54,52.93}}},nil,28,nil,nil,38,nil,nil,0},
[1819] = {'Foulmaw Hydra',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1820] = {'Elder Foulmaw Hydra',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1821] = {'Carrion Lurker',3082,3189,52,53,0,nil,nil,0,nil,nil,22,nil,nil,0},
[1822] = {'Venom Mist Lurker',1277,1277,36,37,0,{[28]={{53.95,60.11},{60.27,60.37},{58.23,63.5},{51.09,57.82},{48.87,58.44},{57.03,60.03},{52.68,58.64},{56.11,58.1},{57.82,65.03},{54.96,62.4},{55.8,63.75},{51.57,60.44},{42.46,56.13},{44.14,57.05},{44.95,59.83},{49.51,61.81},{50.21,63.27},{52.02,60.69},{56.84,58.09},{42.82,54.36},{48.98,58.81},{43.94,56.93},{58.36,60.23},{58.95,57.48},{59.25,62.25},{58.58,57.7},{52.58,58.6},{48.71,58.85},{56.64,57.67},{49.41,59.33}}},nil,28,nil,nil,22,nil,nil,0},
[1823] = {'Giant Venom Mist Lurker',0,0,52,53,0,nil,nil,0,nil,nil,778,nil,nil,0},
[1824] = {'Plague Lurker',1660,1660,36,37,0,{[28]={{59.01,62.36},{57.14,61.97},{58.85,57.45},{58.08,60.41},{59.51,59.49},{56.11,60.94},{54.13,61.22},{52.93,60.8},{43.56,55.46},{46.56,59.78},{49.68,59.66},{49.1,61.48},{43.59,55.39},{51.71,58.04},{42.87,56.79},{56.66,57.47},{59.48,59.14},{55.89,58.84},{55.97,58.62},{59.44,59.33},{51.15,57.92}}},nil,28,nil,nil,312,nil,nil,0},
[1825] = {'Giant Plague Lurker',0,0,55,56,0,nil,nil,0,nil,nil,778,nil,nil,0},
[1826] = {'Scarlet Mage',2470,2550,55,56,0,nil,nil,0,nil,nil,89,nil,nil,0},
[1827] = {'Scarlet Sentinel',3268,3374,55,56,0,nil,nil,0,nil,nil,89,nil,nil,0},
[1831] = {'Scarlet Hunter',3189,3189,53,53,0,{[28]={{40.69,52.14},{40.35,51.7},{41.51,52.93},{40.88,52.02}}},nil,28,nil,nil,67,nil,nil,0},
[1832] = {'Scarlet Magus',2361,2436,56,57,0,nil,nil,0,nil,nil,89,nil,nil,0},
[1833] = {'Scarlet Knight',3293,3398,54,55,0,nil,nil,0,nil,nil,89,nil,nil,0},
[1834] = {'Scarlet Paladin',2614,2699,55,56,0,nil,nil,0,nil,nil,89,nil,nil,0},
[1835] = {'Scarlet Invoker',2551,2551,53,54,0,{[28]={{40.9,51.77},{41.33,53.03},{40.69,52.5},{41.18,52.56}}},nil,28,nil,nil,67,nil,nil,0},
[1836] = {'Scarlet Cavalier',8352,8613,57,58,1,nil,nil,0,nil,nil,89,nil,nil,0},
[1837] = {'Scarlet Judge',1702,1702,38,38,4,{[28]={{42.18,18.07},{69.28,49.58}}},nil,28,nil,nil,16,nil,nil,0},
[1838] = {'Scarlet Interrogator',2004,2004,37,37,4,{[28]={{42.25,18.21},{44.93,52.05}}},nil,28,nil,nil,16,nil,nil,0},
[1839] = {'Scarlet High Clerist',1575,1575,36,36,4,{[28]={{44.5,19.3},{42.34,18.9},{41.38,53.02}}},nil,28,nil,nil,16,nil,nil,0},
[1840] = {'Grand Inquisitor Isillien',66625,66625,63,63,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1841] = {'Scarlet Executioner',2004,2004,37,37,4,{[28]={{42.13,18.4},{50.99,40.5}}},nil,28,nil,nil,16,nil,nil,0},
[1842] = {'Highlord Taelan Fordring',26650,26650,63,63,1,nil,nil,0,nil,{5862},67,nil,"Highlord of the Scarlet Crusade",0},
[1843] = {'Foreman Jerris',2574,2574,43,43,4,{[28]={{45.74,16.11}},[139]={{55.26,68.65}}},nil,28,nil,nil,16,nil,nil,0},
[1844] = {'Foreman Marcrid',2060,2060,43,43,4,{[28]={{44.67,34.19}},[139]={{53.88,68.37}}},nil,28,nil,nil,16,nil,nil,0},
[1845] = {'High Protector Tarsen',3198,3198,59,59,0,nil,{[28]={{{48.83,33.71},{48.67,33.75},{48.46,33.61},{48.19,33.44},{48.03,33.17},{47.81,32.96},{47.6,32.76},{47.33,32.65},{47.09,32.68},{46.84,32.71},{46.58,32.82},{46.31,32.97},{46.09,33.22},{45.95,33.52},{45.93,33.99},{45.96,34.33},{46.02,34.79},{46.17,35.11},{46.43,35.19},{46.76,35.35},{47.04,35.39},{47.22,35.36},{47.51,35.37},{47.75,35.52},{47.91,35.78},{48.11,35.99},{48.33,36.25},{48.55,36.37},{48.84,36.49},{49,36.22},{49.15,35.71},{49.23,35.43},{49.32,34.86},{49.16,34.5},{48.96,34.42},{48.89,34.07}}}},0,nil,nil,67,nil,nil,0},
[1846] = {'High Protector Lorik',7545,7545,61,61,1,nil,{[28]={{{44.91,17.72},{44.77,17.62},{44.56,17.51},{44.43,17.79},{44.3,18.09},{44.27,18.41},{44.34,18.98},{44.14,18.9},{43.98,18.7},{43.86,18.48},{43.69,18.23},{43.55,18.02},{43.39,17.78},{43.31,17.51},{43.28,17.21},{43.31,16.87},{43.34,16.51},{43.38,16.25},{43.41,15.99},{43.31,15.78},{43.17,15.68},{43.28,15.78},{43.47,15.98},{43.61,15.92},{43.79,15.84},{44.05,15.73},{44.22,16},{44.39,16.24},{44.57,16.43},{44.6,16.74},{44.59,17.06},{44.6,17.37},{44.74,17.55},{45.01,17.8},{45.14,17.93},{45.28,18.07},{45.42,18.22},{45.29,18.07},{45.02,17.76}}}},0,nil,nil,67,nil,nil,0},
[1847] = {'Foulmane',1916,1916,36,36,4,{[28]={{46.06,55.74}}},nil,28,nil,nil,21,nil,nil,0},
[1848] = {'Lord Maldazzar',1506,1506,38,38,4,{[28]={{54.81,79.83},{65.37,47.61}}},nil,28,nil,nil,16,nil,nil,0},
[1849] = {'Dreadwhisper',1506,1506,38,38,4,{[28]={{64,56.26}}},nil,28,nil,nil,21,nil,nil,0},
[1850] = {'Putridius',2286,2286,40,40,4,{[28]={{44.85,73.77}}},nil,28,nil,nil,16,nil,nil,0},
[1851] = {'The Husk',1830,1830,35,35,4,{[28]={{61.88,35.18},{63.29,82.97}}},nil,28,nil,nil,14,nil,nil,0},
[1852] = {'Araj the Summoner',2018,2018,35,35,1,{[28]={{45.22,69.26}}},nil,28,nil,nil,21,nil,nil,0},
[1853] = {'Darkmaster Gandling',41190,41190,43,43,1,{[2057]={{-1,-1}}},nil,2057,nil,nil,21,nil,nil,0},
[1854] = {'High Priest Thel\'danis',3101,3101,58,58,0,{[28]={{52.02,82.9}}},{[28]={{{52.01,83.34},{51.92,83.52},{51.91,83.76},{52.01,83.94},{52.15,84.04},{52.29,83.95},{52.4,83.76},{52.4,83.52},{52.31,83.34},{52.16,83.31},{52.03,83.36}}}},28,{27170},{8414,27169},12,"A",nil,2},
[1855] = {'Tirion Fordring',25150,25150,61,61,1,nil,nil,0,nil,{5542,5543,5544,5742,5781,5845,5848},250,"AH",nil,1},
[1857] = {'Pissed Vendor',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Pissed Vendor",0},
[1858] = {'Pissed not a Vendor',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Pissed Vendor",0},
[1860] = {'Voidwalker',716,716,17,17,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1861] = {'Greater Voidwalker',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1862] = {'Lesser Netherwalker',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1863] = {'Succubus',20000,20000,70,70,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1864] = {'Greater Succubus',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1865] = {'Ravenclaw Raider',247,273,12,13,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1866] = {'Ravenclaw Slave',222,247,11,12,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1867] = {'Dalaran Apprentice',241,263,13,14,0,nil,nil,0,nil,nil,76,"AH",nil,0},
[1868] = {'Ravenclaw Servant',253,276,13,14,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1869] = {'Ravenclaw Champion',300,328,14,15,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1870] = {'Hand of Ravenclaw',356,356,16,16,0,{[130]={{49.93,60.15}}},nil,130,nil,nil,21,nil,nil,0},
[1871] = {'Eliza\'s Guard',326,326,24,24,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1872] = {'Tharek Blackstone',247,247,12,12,0,{[1]={{53.12,49.99}}},nil,1,nil,{24493},55,"A",nil,2},
[1879] = {'Noma Bluntnose',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1880] = {'Berte',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1881] = {'Evalyn',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1883] = {'Scarlet Worker',3529,3758,55,57,0,nil,nil,0,nil,nil,67,nil,nil,0},
[1884] = {'Scarlet Lumberjack',3420,3644,54,56,0,{[28]={{45.83,16.22}}},nil,28,nil,nil,89,nil,nil,0},
[1885] = {'Scarlet Smith',2004,2004,37,37,4,{[28]={{44.43,13.64},{53.96,44.11}}},nil,28,nil,nil,16,nil,nil,0},
[1888] = {'Ambermill Watcher',350,350,17,18,0,{[130]={{57.72,65.67},{58.21,66.35},{60.25,66.28},{61.8,62.06},{61.32,63.49},{62.49,60.86},{60.61,62.98},{61.23,61.36},{62.69,63.47},{63.27,63.12},{63.53,63.13}}},nil,130,nil,nil,76,"AH",nil,0},
[1889] = {'Ambermill Witchalok',566,566,18,18,0,{[130]={{59.55,62.94},{59.03,61.87},{58.23,61.83},{58.73,62.75},{59.86,62.23},{57.8,62.92}}},nil,130,nil,nil,76,"AH",nil,0},
[1890] = {'Rattlecage Skeleton',0,0,2,3,0,{[6454]={{46.12,50.47},{51.32,52.94},{49.82,49.5},{46.91,42.26},{51.1,47.16},{49.84,42.47},{49.38,42.21},{47.29,38.79},{48.5,38.21},{47.44,36.85},{49.13,34.53},{51.62,37.39},{51.6,33.6},{53.28,30},{56.18,31.44},{55.1,35.16},{57.23,34.15},{51.25,39.59},{52.39,39.27},{55.14,40.94},{52.57,45.55},{56.88,39.99},{55.3,45.82},{53.04,48.71},{58.13,43.65},{57.31,48.64},{55.63,51.82},{59.96,51.21},{61.03,52.5},{61.81,54.33},{61.8,51.46},{60.79,45.06},{59.42,39.78},{59.55,36.31},{63.81,50.21},{63.4,52.73}}},nil,6454,nil,nil,7,"AH",nil,0},
[1891] = {'Pyrewood Watcher',273,300,13,14,0,nil,nil,0,nil,nil,123,"A",nil,0},
[1892] = {'Moonrage Watcher',273,300,13,14,0,nil,nil,0,nil,nil,16,nil,nil,0},
[1893] = {'Moonrage Sentry',300,328,14,15,0,nil,nil,0,nil,nil,16,nil,nil,0},
[1894] = {'Pyrewood Sentry',300,328,14,15,0,nil,nil,0,nil,nil,123,"A",nil,0},
[1895] = {'Pyrewood Elder',276,301,14,15,0,nil,nil,0,nil,nil,123,"A",nil,0},
[1896] = {'Moonrage Elder',276,301,14,15,0,nil,nil,0,nil,nil,16,nil,nil,0},
[1897] = {'Scourge Necromancer',96,96,1,1,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1901] = {'Kelstrum Stonebreaker',2218,2218,45,45,0,{[1537]={{66.97,90.15}}},nil,1537,nil,nil,55,"A","Warrior Trainer",49},
[1907] = {'Naga Explorer',905,905,29,30,0,{[5287]={{38.92,45.11},{42.33,48.32},{37.65,46.61},{37.06,48.23},{37.68,51.66},{37.59,44.02},{36.84,45.44},{37.05,50.55},{39.44,49.57},{39.55,46.86},{38.62,48.08},{38.54,50.86},{40.69,44.47},{42.72,52.88},{42.22,49.55},{41.03,50.64},{42.48,50.38},{42.34,53.06},{41.93,50.5},{42.53,51.21},{40.85,46.38},{40.8,51.85},{39.78,45.75},{40.83,47.97}}},nil,5287,nil,nil,74,nil,nil,0},
[1908] = {'Vile Fin Oracle',208,208,10,11,0,{[130]={{77.32,32.59},{77.55,32.45},{76.96,32.07},{77.61,33.2},{79.07,30.2},{79.44,31.91},{78.65,31.35},{79.7,30.3},{76.11,33.37},{76.66,33.7},{79.73,31.33},{80.71,30.53},{80.33,31.27},{80.05,29.32},{78.05,30.22},{80.3,28.77},{79.88,27.79},{80.11,28.33},{80.01,28.46},{80.32,28.52},{78.4,31.02},{78.06,30.56},{77.61,31.42},{77.5,31.42},{77.3,33.45},{77.44,33.83},{77.24,34.18},{77.34,34.01},{77.14,34.06},{79.13,28.88},{79.79,31.44},{77.47,31.27},{77.63,31.18},{77.62,31.43},{75.25,32.25},{75.6,34.24},{75.69,32.65},{80.32,29},{80.23,28.45},{80.67,29.92},{80.22,28.35},{79.72,31.31},{80.38,31.31},{80.28,28.75},{79.42,31.76},{79.5,31.15},{78.64,31.4},{77.51,30.84},{78.14,30.72},{78.4,31.02},{77.61,31.41},{77.62,31.15},{79.04,25.98},{77.4,33.88},{77.32,34.05},{77.45,30.58},{77.11,34.07},{77.32,33.7},{73.43,18.05},{73.77,20.93},{74.35,20.39},{77.54,28.19},{73.87,17.48},{74.67,16.71},{73.81,18.09},{76.41,19.31},{72.27,17.18},{72.17,17.21},{76.74,20.16},{74.79,17.51},{75.88,20.22},{76.42,20.06},{76.83,20.44},{73.61,16.45},{73.99,17.33},{73.76,17.09},{73.95,16.88},{74.34,16.44},{75.87,20.68},{74.58,20.99},{75.57,19.85},{74.77,19.93},{74.36,19.98},{72.57,17.8},{72.79,16.43},{72.82,17.09},{73.2,16.13},{73.14,17},{73.06,16.33},{72.86,17.94},{76.3,33.88},{78.7,29.37},{75.16,32.18},{75.69,34.14},{76.74,32.94},{76.17,33.09},{75.56,22.85},{74.89,22.3},{77.12,27.86},{78.39,26.11},{79.47,31.01},{79.85,31.43},{78.72,23.47},{78.74,24.49},{78.39,23.55},{79.04,29.03},{76.92,21.78},{78.08,25.23},{80.01,28.5},{80.27,28.48},{80.2,28.81},{80.71,30.01},{80.32,28.99},{78.14,30.43},{78.14,30.75},{78.35,30.99},{80.49,28.82},{78.24,30.77},{78.24,31.12},{80.11,28.06},{78.09,30.24},{77.74,25.5},{78.74,27.09},{78.42,26.81},{78.26,27.52},{79.19,31.83},{77.66,31.63},{77.61,31.18},{77.6,31.43},{75.69,32.66},{76.3,31.68},{76.16,32.63},{77.73,23.52},{77.31,26.07},{77.21,25.44},{77.51,24.11},{78.04,23.53},{77.94,22.84},{74.34,19.77},{72.7,18.11},{72.53,17.74},{73.18,18.1},{73.86,18.22},{73.72,17.37},{73.24,17.51},{75.04,17.07},{75.87,20.41},{73.18,16.92},{72.8,16.42},{73.17,16.29},{73.2,16.17},{74.01,16.8},{73.67,17.24},{74.29,16.43},{73.55,16.38},{72.81,17.08}}},nil,130,nil,nil,18,nil,nil,0},
[1909] = {'Vile Fin Lakestalker',377,404,18,19,0,nil,nil,0,nil,nil,18,nil,nil,0},
[1910] = {'Muad',172,172,6,6,4,{[85]={{36.49,42.39},{35.94,42.85}}},{[85]={{{36.51,42.38},{36.08,42.07},{35.5,41.76},{35.04,41.28},{35.11,41.03},{35.29,40.63},{35.3,40.26},{34.73,40.23},{34.34,40.46},{34.5,41},{34.74,40.99},{34.49,41.41},{33.78,42.25},{33.57,43.01},{33.67,43.59},{34.34,44.27},{34.64,44.3},{34.67,44.66},{34.95,44.79},{35.48,44.58},{36.3,44.49},{35.73,43.53},{35.83,43.26},{35.97,43.13},{36.05,42.97},{36.08,43.07},{36,43.04},{36.08,42.87},{36.22,42.81},{36.41,42.54},{36.41,42.25},{36.32,42.67},{36.47,42.75},{36.54,42.44}}}},85,nil,nil,18,nil,nil,0},
[1911] = {'Deeb',249,249,9,9,4,{[85]={{59,27.37},{72.68,25.83}}},nil,85,nil,nil,14,nil,nil,0},
[1912] = {'Ambermill Protector',300,328,14,15,0,nil,nil,0,nil,nil,76,"AH",nil,0},
[1913] = {'Ambermill Warder',386,386,12,18,0,{[130]={{63.47,65.56},{63.24,65.27},{63.47,65.3},{56.61,66.45},{56.96,66},{63.4,61.27},{62.73,60.26},{61.03,62.33},{61.24,62.41},{57.28,61.19},{56.9,62.06},{57.29,62.43},{56.69,62.88},{62.69,63.09},{61.95,63.92},{62.54,64.07},{62.01,64.5},{61.63,66.45},{62,68.6},{61.66,66.73},{62.02,68.7},{59.27,64.33}}},nil,130,nil,nil,76,"AH",nil,0},
[1914] = {'Ambermill Magister',377,377,17,18,0,{[130]={{58.97,66.56},{60.4,66.35},{62.98,67.39},{63,62.14},{61.74,61.61},{60.39,61.44},{60.11,65.12},{60.88,65.15},{58.42,65.62},{59.34,65.29},{62.91,66.42},{62.19,65.87},{61,66.71}}},nil,130,nil,nil,76,"AH",nil,0},
[1915] = {'Ambermill Conjuror',330,354,17,18,0,nil,nil,0,nil,nil,76,"AH",nil,0},
[1916] = {'Stephen Bhartec',0,0,2,3,0,{[6454]={{69.71,41.56}}},nil,6454,nil,nil,7,"AH",nil,0},
[1917] = {'Daniel Ulfman',0,0,2,3,0,{[6454]={{70.92,41.18}}},nil,6454,nil,nil,7,"AH",nil,0},
[1918] = {'Karrel Grayves',0,0,2,2,0,{[6454]={{71.37,40.75}}},nil,6454,nil,nil,7,"AH",nil,0},
[1919] = {'Samuel Fipps',0,0,5,5,0,{[6454]={{70.85,40.19}}},nil,6454,nil,nil,7,"AH",nil,0},
[1920] = {'Ambermill Spellscribe',441,441,21,21,4,{[130]={{63.51,63.42}}},nil,130,nil,nil,76,"AH",nil,0},
[1921] = {'Combat Dummy',42,42,1,1,0,{[495]={{79.09,31.14}}},nil,495,nil,nil,1703,"AH",nil,0},
[1922] = {'Gray Forest Wolf',137,137,7,8,0,{[12]={{60.06,64.39},{59.88,65.2},{59.63,65.45},{60.11,65.78},{60.07,60.83},{61.22,63.83},{60.91,64.25},{59.76,69.4},{61.96,70.98},{60.09,70.9},{59.1,69.41},{61.04,63.43},{60.79,67.08},{60.2,67.21},{61.92,66.65},{61.29,65.62},{58.73,63.34},{62.08,61.89},{61.14,62.38},{59.53,64.81},{60.58,63.7},{59.19,63.41},{61.18,62.42},{60.06,64.42},{59.7,65.43},{60.13,65.81},{59.34,60.93},{61.2,63.87},{60.92,64.26},{62.97,63.23},{59.86,68.51},{63.02,68.31},{62.17,71.07},{70.46,64.17},{68.35,58.75},{68.36,58.5},{68.82,56.38},{65.52,60.08},{66.39,58.43},{68.78,65.81},{68.25,65.5},{66.13,63.61},{67.53,63.32},{66.27,65.01},{69.3,63.9},{68.99,62.49},{67.62,61.69},{67.48,64.12},{70.34,61.97},{71.65,61.22},{69.61,63.38},{70.2,63.42},{71.72,63.45},{60.22,71.23},{59.34,69.42},{61.06,63.51},{60.83,67.19},{59.9,66.94},{62.34,67.52},{61.27,66.85},{58.74,63.22},{61.89,61.44},{60.78,61.56},{59.74,64.46},{59.24,62.92},{61.08,63.59},{64.83,65.17},{67.41,67.6},{72.82,62.09},{74.14,62.93},{73.86,66.44},{74.67,64.91},{69.68,69.39},{72.34,66.42},{73.06,67.2},{73.44,68.15},{73.55,62.69},{73.26,63},{73.88,66.34},{74.45,65.5},{74.57,67.92},{60.04,70.7},{61.78,71.12}}},nil,12,nil,nil,38,nil,nil,0},
[1923] = {'Bloodsnout Worg',356,386,16,17,0,nil,nil,0,nil,nil,38,nil,nil,0},
[1924] = {'Moonrage Bloodhowler',328,356,15,16,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1925] = {'Heat Miser',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Immune to Fire",0},
[1926] = {'Snow Miser',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Immune to Frost",0},
[1927] = {'Good Miser',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Immune to Holy",0},
[1928] = {'Bad Miser',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Immune to Shadow",0},
[1929] = {'Earth Miser',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Immune to Nature",0},
[1930] = {'Steel Miser',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Immune to Physical",0},
[1931] = {'Captured Scarlet Zealot',156,156,8,8,0,{[85]={{44.7,52.62}}},nil,85,nil,{407,24977},68,"H",nil,2},
[1932] = {'Black Sheep',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1933] = {'Sheep',14,14,3,3,0,{[12]={{41.87,69.78},{34.03,55.04},{39.71,61.91},{40.08,61.8},{56.83,73.8},{56.88,74.29},{44.59,70.96},{39.63,62.15},{64.66,75.72},{77.52,61.21},{56.55,73.72},{57.08,74.11},{42.69,78.4},{63.77,75.87},{65.96,79.07},{40.17,91.15},{44.14,70.7},{48.23,83.46},{42.97,79.75},{44.04,70.83},{39.35,73.7},{38.64,74.99},{39.93,90.38},{43.92,70.4},{39.27,73.75}},[38]={{82.63,57.62},{25.7,32.23},{25.05,36.19},{57.44,69.33},{30.55,36.19},{61.92,61.6},{27.74,11.95},{40.77,18.18},{64.3,57.17},{68.3,74.95},{79.35,66.78},{68.79,72.37},{70.99,51.43},{21.89,16.89},{28.03,43.39},{24.87,37.36},{58.85,77.69},{34.37,30.03},{75.68,70.86},{80.27,59.87},{29.41,18.94},{28.19,18.83},{22.17,19.53},{30.3,11.83},{20.83,74.87},{20.99,71.29},{30.36,50.68},{25.55,28.11},{61.84,60.69},{64.71,56.14},{53.98,42.74},{40.33,18.16},{64.57,55.5},{55.59,42.93},{58.58,20.67},{33.03,36.66},{62.4,37.54},{62.21,41.32},{27.66,11.11},{64.67,56.43},{71.11,50.28},{58.11,20.26},{60.55,36.05},{34.53,29.53},{29.44,18.81},{28.8,16.78},{30.21,12.83},{25.79,27.75}},[44]={{24.36,53.44},{32.16,56.41},{30.7,40.21},{29.11,54.8},{19.86,43.32},{24.33,53.51},{29.34,54.47}},[267]={{50.66,72.5},{43.73,74.7}},[495]={{33.8,78.38},{33.71,78.43},{33.8,78.45},{33.76,78.36}},[4100]={{-1,-1}},[4714]={{42.76,45.19},{76.55,65.86},{75.25,53.59},{42.63,45.12},{42.42,45.01},{76.17,65.7},{76.3,65.38},{74.58,64.29},{76.32,64.85},{74.62,64.07},{74.93,53.12},{76.37,67.07},{42.27,45.65},{42.86,45.47},{75.23,53.75},{74.56,64.85},{80.05,66.12},{76.25,64.76},{80.59,65.7},{76.33,65.44},{74.72,53.2},{76.6,65.98},{79.74,66.89},{74.95,53.21},{80.51,66.22},{74.56,53.37},{76.31,65.88},{74.99,64.25},{76.3,65.27},{75.05,64.6},{76.16,65.56},{76.29,65.8},{76.23,65.39},{74.76,64.51},{74.68,52.91},{74.79,53.6},{74.95,53.55},{74.45,53.37},{74.89,53.72},{74.6,53.53},{81.97,65.89},{82.03,65.39},{81.74,65.17},{81.84,64.86},{82.11,65.05},{82.22,65.58},{81.9,65.38},{81.55,64.49},{81.96,65.79},{81.7,64.61},{81.88,66.1},{81.98,64.91},{82.01,65.08},{81.88,65.25},{81.95,64.7},{81.69,64.67},{82.02,64.91},{81.91,65.86},{81.84,65.75},{81.94,65.45},{81.9,64.86},{82.1,65.22},{81.97,65.28},{82.16,65.26},{81.91,65.38},{82.1,65.62},{81.82,64.95},{81.96,64.94},{81.7,65.05},{82.13,66.66},{74.63,54.25}},[5034]={{51.62,50.41},{51.61,49.52},{51.62,49.52},{51.72,49.45},{51.55,49.4},{51.33,50.61},{51.58,50.26},{51.72,49.64},{51.49,49.57},{51.64,49.46},{51.75,49.59},{51.42,49.52},{51.62,50.46},{51.36,50.32},{51.46,50.32},{51.42,50.35},{51.66,50.47},{51.38,50.24},{51.41,50.42},{51.49,50.33},{51.56,50.6},{51.34,49.53},{51.56,50.66},{51.61,49.67},{57.32,56.07},{57.59,55.56},{57.27,56.03},{57.32,55.96},{57.6,55.51},{57.59,55.55},{57.33,55.94},{57.28,55.93},{57.33,56.06},{57.28,56.02},{57.62,55.54},{57.59,55.55},{57.6,55.5},{57.56,55.39},{57.36,55.98},{57.56,55.39},{51.63,50.48},{51.58,49.54},{51.63,49.6},{51.78,49.51},{51.56,49.41},{51.32,50.64},{51.57,50.2},{51.74,49.67},{51.42,49.54},{51.61,49.47},{51.72,49.52},{51.43,49.53},{51.63,50.49},{51.35,50.3},{51.44,50.32},{51.42,50.4},{51.7,50.46},{51.43,50.23},{51.43,50.42},{51.48,50.34},{51.55,50.47},{51.35,49.48},{51.58,50.62},{51.61,49.68},{57.27,55.95},{57.59,55.57},{57.35,55.94},{57.34,56.01},{57.56,55.52},{57.57,55.55},{57.28,55.97},{57.28,55.92},{57.35,56.06},{57.28,55.98},{57.55,55.49},{57.54,55.55},{57.56,55.48},{57.56,55.46},{57.31,55.92}}},nil,5034,nil,nil,31,"AH",nil,0},
[1934] = {'Tirisfal Farmer',120,120,6,7,0,{[85]={{37.97,49.93},{35.59,52.35},{35.82,50.56},{35.29,51.42},{37.58,51.47},{40.42,51.98},{40.26,51.71},{38.82,52.55},{39.72,52.36},{37.69,51.59},{37.65,51.46},{37.49,51.55},{36.97,49.3},{39.41,52.38},{37.48,49.72},{40.25,51.92},{39.64,51.18},{35.75,50.65},{35.27,51.66},{38.1,50.35},{34.38,50.55}}},nil,85,nil,nil,67,nil,nil,0},
[1935] = {'Tirisfal Farmhand',120,120,5,6,0,{[85]={{39.59,51.33},{38.52,50.78},{37.94,51.25},{36.78,51.62},{34.38,50.55},{34.84,49.03},{39.92,50.77}}},nil,85,nil,nil,67,nil,nil,0},
[1936] = {'Farmer Solliden',156,156,8,8,4,{[85]={{38.04,49.61},{38.03,52.21}}},nil,85,nil,nil,67,nil,nil,0},
[1937] = {'Apothecary Renferrel',300,300,14,14,0,{[130]={{47.01,43.17}}},nil,130,nil,{429,443,445,446,450,3221},68,"H","Royal Apothecary Society",0},
[1938] = {'Dalar Dawnweaver',531,531,21,21,0,{[130]={{47.08,43.22}}},nil,130,{27478,27483,27484},{99,421,422,423,424,481,1014,27476,27478,27480,27483},68,"H",nil,2},
[1939] = {'Rot Hide Brute',356,386,16,17,0,nil,nil,0,nil,nil,70,nil,nil,0},
[1940] = {'Rot Hide Plague Weaver',350,377,17,18,0,nil,nil,0,nil,nil,70,nil,nil,0},
[1941] = {'Rot Hide Graverobber',137,137,6,7,0,{[85]={{53.28,41.87},{53.48,43.6},{57.9,41.48},{54.22,42.44},{55,41.53},{56.44,43.87},{56.09,43.97},{55.21,43.88},{56.61,39.7},{56.88,40.38},{55.48,42.76},{56.38,41.29},{55.8,40.62},{55.22,42.56},{54.88,42.48},{55.44,41.9},{55.19,42.2},{53.99,44.49},{55.48,39.13}}},nil,85,nil,nil,70,nil,nil,0},
[1942] = {'Rot Hide Savage',417,449,18,19,0,nil,nil,0,nil,nil,70,nil,nil,0},
[1943] = {'Raging Rot Hide',417,449,18,19,0,nil,nil,0,nil,nil,70,nil,nil,0},
[1944] = {'Rot Hide Bruiser',573,573,22,22,4,{[130]={{64.64,23.75},{65.22,24.98}}},nil,130,nil,nil,70,nil,nil,0},
[1945] = {'Tree Form 0.33',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1946] = {'Lillith Nefara',247,247,12,12,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1947] = {'Thule Ravenclaw',405,405,20,20,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1948] = {'Snarlmane',726,726,23,23,4,{[130]={{66.29,24.84}}},nil,130,nil,nil,14,nil,nil,0},
[1949] = {'Servant of Azora',156,156,8,9,0,{[12]={{64.73,70.68},{65.11,69.46},{65.39,70.05},{65.34,69.75},{64.44,69.98},{63.99,69.63},{64.74,69.61},{64.45,68.4},{64.78,69.94},{65.06,70.11}}},nil,12,nil,nil,12,"A",nil,0},
[1950] = {'Rane Yorick',328,328,15,15,0,nil,nil,0,nil,{425,428,435},68,"H","Deathstalker",0},
[1951] = {'Quinn Yorick',300,300,14,14,0,nil,nil,0,nil,{430},68,"H","Deathstalker",0},
[1952] = {'High Executor Hadrec',1003,1003,30,30,0,{[130]={{43.42,40.86}}},nil,130,nil,{437,439,442,448,449},68,"H",nil,0},
[1953] = {'Lake Skulker',328,356,15,16,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1954] = {'Elder Lake Skulker',325,350,16,17,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1955] = {'Lake Creeper',386,417,17,18,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1956] = {'Elder Lake Creeper',417,449,18,19,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1957] = {'Vile Fin Shorecreeper',356,386,16,17,0,nil,nil,0,nil,nil,18,nil,nil,0},
[1958] = {'Vile Fin Tidecaller',350,377,17,18,0,nil,nil,0,nil,nil,18,nil,nil,0},
[1959] = {'Mountaineer Barleybrew',726,726,20,20,0,{[1537]={{41.44,52.28}}},nil,1537,{26131},{413},57,"A",nil,2},
[1960] = {'Pilot Hammerfoot',386,386,17,17,0,{[38]={{14.01,56.48}}},nil,38,{13635,26854},{417,13637,26131,26855,28567},55,"A",nil,2},
[1961] = {'Mangeclaw',289,289,11,11,0,{[1]={{87.36,49.21}}},nil,1,nil,nil,44,nil,nil,0},
[1963] = {'Vidra Hearthstove',198,198,10,10,0,{[38]={{34.83,49.28}}},nil,38,{26860},{418,26860},55,"A",nil,2},
[1964] = {'Treant',5600,7000,69,70,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1965] = {'Mountaineer Thalos',0,0,15,15,0,{[6176]={{85.65,42.47}}},nil,6176,nil,nil,55,"A",nil,2},
[1971] = {'Ivar the Foul',273,273,13,13,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1972] = {'Grimson the Pale',328,328,15,15,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1973] = {'Ravenclaw Guardian',494,531,20,21,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1974] = {'Ravenclaw Drudger',449,484,19,20,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1975] = {'Eastvale Lumberjack',137,137,7,8,0,{[12]={{83.13,63.57},{82.74,63.14},{82.56,63.88},{83.04,63.46},{82.62,63.4}}},{[12]={{{82.69,63.66},{82.78,63.48},{82.77,63.33},{82.76,63.13},{82.77,63.32},{82.78,63.47},{82.69,63.64},{82.58,63.84},{82.46,64.01},{82.38,64.22}}}},12,nil,nil,11,"A",nil,0},
[1976] = {'Stormwind City Patroller',116235,116235,85,85,0,{[1519]={{70.5,37.02},{56.13,84.02},{72.11,67.84},{67.51,81.15},{63.97,71.77},{58.8,44.67},{57.01,51},{58.61,76.78},{77.93,64.29},{62.87,84.18},{65.39,51.2},{70.64,74.19},{52.97,66.08},{56.28,56.4},{49.74,66.3},{65.63,58.12},{62.85,55.77},{64.03,37.76},{49.26,77.76},{58.86,37.94},{73.2,44.51},{67.25,83.83},{68.28,35.51},{40.19,32.56},{55.41,86.27},{44.81,31.65},{44.68,56.6},{50.46,21.83},{50.59,43.29},{54.06,54.84},{44.84,87.37},{57.07,71.79},{41.05,78.76},{40.28,25.88},{62.66,47.09},{51.71,65.4},{49.68,53.08},{52.36,90.05},{50.66,69.74},{63.55,58.62},{63.34,53.92},{62.9,30.49},{46.99,77.45},{58.18,36.67},{45.9,90.19}}},nil,1519,nil,nil,11,"A",nil,1},
[1977] = {'Senator Mehr Stonehallow',2769,2769,50,50,0,{[1]={{75.9,54.31}}},nil,1,{433,25986},{433},55,"A",nil,2},
[1978] = {'Deathstalker Erland',222,222,11,11,0,nil,nil,0,nil,nil,68,"H",nil,0},
[1979] = {'TEST WOLF (ALPHA FIRST)',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1980] = {'TEST WOLF (ALPHA SECOND)',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1981] = {'Dark Iron Ambusher',273,273,13,13,0,nil,nil,0,nil,nil,54,nil,nil,0},
[1983] = {'Nightlash',300,300,14,14,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1984] = {'Young Thistle Boar',0,0,1,2,0,{[6450]={{36.65,65.41},{33.11,67.59},{37.09,73.42},{46.32,79.11},{43.03,72.99},{39.14,62.81},{59.35,66.15},{55.44,63.32},{53.9,68.05},{57.72,73.36},{52.91,77.8}}},nil,6450,nil,nil,189,"AH",nil,0},
[1985] = {'Thistle Boar',0,0,2,3,0,{[6450]={{59.18,51.73},{58.21,43.39},{56.9,41.35},{55.82,39.78},{51.16,36.79},{52.28,37.91},{53.29,36.31},{51.05,29.19},{48.89,39.79},{46.89,32.36},{37.52,31.37},{40.8,31.08},{36.72,32.67},{37.06,33.06},{38.47,34.14},{43.11,35.08},{44.27,39.78},{38.09,35.86},{40.04,37.14},{38.53,39.07},{39.66,43.14},{37.44,46.77},{35.21,49.95},{35.05,56.69},{37.28,50.06},{37.38,53.34},{51.1,43.23},{47.74,44.84},{55.79,53.46},{50.9,55.13}}},nil,6450,nil,nil,189,"AH",nil,0},
[1986] = {'Webwood Spider',86,86,3,4,0,{[141]={{56.47,25.19},{57.14,24.21},{56.94,25.69},{56.72,26.35},{57.25,25.03},{57.47,25.22},{56.82,24.19},{56.79,24.24},{56.8,23.12},{57.3,22.96},{57.32,23.39},{57.32,23.85},{57.62,23.9},{55.41,22.14},{56.43,23.99},{55.95,23.33},{55.54,23.23},{56.06,22.83},{56.35,27.39},{56.19,26.85},{56.04,26.1},{55.74,25.52},{55.5,25.18},{56.22,22.83},{55.53,25.16},{56.53,22.58},{55.57,24.08},{55.79,23.78}}},nil,141,nil,nil,22,nil,nil,0},
[1987] = {'Webwood Creeper UNUSED',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1988] = {'Grell',0,0,2,3,0,{[6450]={{36.35,79.27},{35.93,78.79},{35.84,77.56},{36.2,75.85},{36.45,78.56},{35.18,78.77},{35.26,80.6},{36.16,79.46},{37.49,77.73},{37.15,79.88},{37.84,79.39}}},nil,6450,nil,nil,189,"AH",nil,0},
[1989] = {'Grellkin',0,0,3,4,0,{[6450]={{65.15,62.83},{59.2,44.77},{55.69,39.52},{44.34,36.43},{38.5,41.35},{29.42,51.91},{29.46,54.34},{29.37,56.97},{30.6,53.48},{32.9,53.37},{31.61,52.15},{30.28,55.52},{30.47,54.59},{30.01,55.03},{29.89,55.49},{36.22,51.73},{32.65,56.62},{30.87,55.88},{30.85,70.43},{31.72,69.86},{31.38,71.31},{31.37,72.64},{32.61,72.4},{32.66,70.73},{31.41,74.72},{31.79,72.59},{32.13,71.95},{32.62,74.2},{49.98,41.42},{56.9,55.16}}},nil,6450,nil,nil,189,"AH",nil,0},
[1990] = {'Gremlin',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1991] = {'Jaxil Rye',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1992] = {'Tarindrella',137,137,7,7,0,{[141]={{42.52,58.18}}},nil,141,{935,14005},{458,933,13939,14005},80,"A",nil,2},
[1993] = {'Greenpaw',148,148,8,8,0,{[141]={{45.64,54.22}}},nil,141,nil,nil,82,nil,nil,0},
[1994] = {'Githyiss the Vile',255,255,5,5,0,{[141]={{56.32,23.33}}},nil,141,nil,nil,22,nil,nil,0},
[1995] = {'Strigid Owl',102,102,5,6,0,{[141]={{47.11,42.83},{64,46.09},{65.48,53.63},{66.2,54.54},{66.53,54.52},{53.93,49.59},{52.8,49.57},{52.77,55.33},{58,49.06},{57.07,49.05},{63.22,45.24},{54.26,55.24},{55.15,57.33},{52.66,51.65},{50.97,51.7},{61.99,46.81},{60.06,44.3},{62.3,45.27},{60.95,44.97},{63.22,53.4},{65.57,46.75},{57.6,53.21},{63.77,47.56},{62.65,47.49},{58.14,52.67},{50.13,50.4},{46.68,41.64},{62.8,56.22},{61.23,54.97},{61.74,56.32},{53.25,48.31},{53.98,52.4}}},nil,141,nil,nil,15,"AH",nil,0},
[1996] = {'Strigid Screecher',156,156,7,8,0,{[141]={{57.56,65.89},{48.6,64.79},{46.76,66.84},{56.93,64.98},{57.63,67.12},{58.18,67.14},{47.41,66.18},{40.86,54.9},{53.08,67.7},{52.02,67.39},{52.87,67.72},{53.7,66.92},{53.28,66.94},{45.16,59.27},{40.8,55.25},{43.64,42.81},{44.23,60.62},{41.18,56.95},{62.5,58.89},{62.72,60.41},{64.09,58.37},{63.63,57.88},{42.8,59.71},{43.39,58.52},{39.89,44.8},{40.18,44.19},{41.51,47.24},{41.95,46.29},{42.02,47.04},{42.93,43.13},{41.27,44.89},{40.04,48.67},{44.18,45.61},{45.21,44.43}}},nil,141,nil,nil,15,"AH",nil,0},
[1997] = {'Strigid Hunter',176,176,8,9,0,{[141]={{40.95,26.8},{42.65,27.28},{39.14,25.39},{40.56,28.28},{41.22,28.09},{47.45,28.92},{46.95,28.05},{46.38,27.81},{45.39,35.13},{39.46,27.27},{40.17,33.25},{40.06,34.74},{47.28,34.87},{41.74,33.15},{46.77,35.62},{41.78,40.06},{43.37,38.91},{40.33,33.95},{40.86,41.66}}},nil,141,nil,nil,15,"AH",nil,0},
[1998] = {'Webwood Lurker',102,102,5,6,0,{[141]={{68.27,52.51},{67.37,52.34},{65.38,58.09},{67.45,50.14},{52.92,58.59},{66.43,55.61},{66.6,55.97},{53.08,58.22},{51.97,57.79},{51.02,56.63},{54.24,56.06},{53.54,55.96},{52.37,48.73},{65.23,54.11},{59.61,47.83},{60.66,47.35},{60.01,48.07},{51.25,46.8},{59.84,48.37},{52.1,51.28},{57.2,49.08},{58.94,52.38},{58.47,51.26},{59.86,53.64},{47.63,40.89},{47,41.75},{62.16,56.03},{54.06,54.51},{62.52,54.08},{62.32,53.43},{60,50.07},{59.18,50.9}}},nil,141,nil,nil,22,nil,nil,0},
[1999] = {'Webwood Venomfang',137,137,7,8,0,{[141]={{63.24,60.9},{59.13,66.87},{48.91,64.94},{54.92,64.07},{60.48,65.51},{47.13,68.49},{45.86,63.38},{54.37,67.44},{49.5,66.07},{46.24,67.46},{46.21,63.72},{54.23,64.71},{42,42.89},{59.72,64.7},{41.09,53.89},{41.08,52.67},{41.22,52.73},{46.19,61.23},{45.7,60.42},{44.75,47.44},{47.16,62.23},{42.38,53.45},{44.09,46.83},{59.79,65.41},{54.15,66.33},{45.82,61.82},{45.68,61.43},{42.43,42.83},{45.17,61.17},{42.27,54.8}}},nil,141,nil,nil,22,nil,nil,0},
[2000] = {'Webwood Silkspinner',176,176,8,9,0,{[141]={{48.55,28.36},{43.67,40.36},{46.71,30.91},{35.81,27.61},{48.63,38.69},{49.22,39.33},{47.81,29.55},{42.88,29.71},{42.8,33.84},{42.42,34.84},{37.04,29.09},{36.23,28.31},{42.85,33.07},{39.93,30.71},{38.24,28.09},{46.73,37.9},{45.19,40.83}}},nil,141,nil,nil,22,nil,nil,0},
[2001] = {'Giant Webwood Spider',222,222,10,11,0,{[141]={{47.19,25.99},{47.23,25.87},{42.35,25.25},{42.66,24.52},{48.03,23.84},{47.92,24.59},{40.11,25.59},{40.23,21.78}}},nil,141,nil,nil,22,nil,nil,0},
[2002] = {'Rascal Sprite',98,98,5,6,0,{[141]={{53.24,42.72},{53.05,45.07},{53.63,45.02},{54.01,44.75},{53.33,44.39},{53.44,45.28},{53.08,44.04}}},nil,141,nil,nil,90,nil,nil,0},
[2003] = {'Shadow Sprite',115,115,5,6,0,{[141]={{53.61,42.74},{53.71,43.97},{53.6,43.75},{52.96,45.58},{53,45.55},{53.8,44.41},{54.59,44.95},{54.4,45.36},{53.56,44.73},{53.06,44.49},{54.48,46.01}}},nil,141,nil,nil,90,nil,nil,0},
[2004] = {'Dark Sprite',120,120,6,7,0,{[141]={{52.76,43.58},{52.43,44.68},{52.03,44.19},{51.78,44.97}}},nil,141,nil,nil,90,nil,nil,0},
[2005] = {'Vicious Grell',137,137,7,7,0,{[141]={{52.7,43.21},{51.7,43.7},{52.59,43.92},{52.01,42.82},{51.84,42.75},{52.27,42.48},{52.82,43.28},{52.23,44.23},{51.88,44.21},{51.92,45.17},{52.32,45.57},{51.63,44.23}}},nil,141,nil,nil,90,nil,nil,0},
[2006] = {'Gnarlpine Ursa',102,102,5,6,0,{[141]={{63.7,57.22},{64.95,56.02},{64.94,55.3},{65.6,48.7},{63.27,49.86}}},nil,141,nil,nil,82,nil,nil,0},
[2007] = {'Gnarlpine Gardener',120,120,5,6,0,{[141]={{64.06,56.64},{63.92,55.18},{66.47,50.9},{65.06,52.72},{63.38,55.41},{65.43,52.02},{63.87,50.74},{65.43,52.73},{63.91,54.19},{63.92,56},{64.93,49.2},{63.95,50.12},{66.32,50.92}}},nil,141,nil,nil,82,nil,nil,0},
[2008] = {'Gnarlpine Warrior',120,120,6,7,0,{[141]={{68.55,45.24},{64.13,56.53},{67.11,48.21},{50.45,57.4},{50.63,58.46},{51.35,55.17},{50.8,57.66},{50.26,59.67},{67.75,46.05},{64.33,52.14},{65.62,45.38},{65.95,52.45},{64.83,50.91},{64.64,51.4},{64.58,51.15},{64.64,51.54},{64.24,55.58},{66.66,47.02},{66.32,45.8},{51.22,54.32},{50.28,53.57},{50.82,54.62},{64.82,50.04},{66.16,51.91},{65.61,49.84}}},nil,141,nil,nil,82,nil,nil,0},
[2009] = {'Gnarlpine Shaman',131,131,7,7,0,{[141]={{49.64,68.15},{48.3,68.5},{49.45,68.7},{48.47,67.15},{46.26,50.95},{50.47,54.75},{49.9,59.01},{49.96,58.16},{51.01,54.98},{45.71,52.83},{57.01,66.36},{49.65,67.12},{47.4,67.63},{48.07,67.62},{50.49,54.55},{44.7,54.02},{45.13,54},{44.3,53.53},{45.01,52.83},{45.34,53.36},{45.58,52.89},{46.06,48.99},{46.22,51.15},{46.62,51.5},{45.64,53.16},{45.35,53.36},{45.19,50.15},{45.36,52.08},{45.03,52.87},{44.94,52.39},{44.75,54.07},{45.72,52.82},{44.43,51.62},{45.13,53.56},{45.25,52.62}}},nil,141,nil,nil,82,nil,nil,0},
[2010] = {'Gnarlpine Defender',137,137,6,7,0,{[141]={{48.27,47.34},{45.32,49.48},{47.67,68.28},{47.56,66.97},{54.74,65.33},{56.48,65.53},{56.24,67.4},{56.6,66.9},{55.8,66.65},{45.95,51.29},{48.01,67.76},{48.71,67.94},{46.83,67.95},{48,66.51},{47.26,45.27},{46.95,45.88},{46.18,51.05},{45.56,53.91},{45.03,51.15},{44.41,51.61},{48.65,46.8},{49.21,47.69},{46.75,47.73},{47.19,51.03},{46.11,52.49},{45.62,51.15},{45.19,50.68},{45.64,49.86},{46.6,52.27},{46.19,51.07},{45.19,50.58},{46.59,50.75},{45.01,51.18},{44.32,53.48},{45.11,53.96},{44.64,53.04},{45.55,53.92}}},nil,141,nil,nil,82,nil,nil,0},
[2011] = {'Gnarlpine Augur',131,131,7,8,0,{[141]={{55.97,65.68},{56.18,65.83},{46.62,46.32},{47.17,44.71},{45.8,53.6},{46.18,53.53},{45.7,48.12},{48.09,46.46},{45.88,51.54},{46.84,49.92},{46.48,50.75},{47.25,50.49},{45.57,53.72}}},nil,141,nil,nil,82,nil,nil,0},
[2012] = {'Gnarlpine Pathfinder',166,186,9,10,0,nil,nil,0,nil,nil,82,nil,nil,0},
[2013] = {'Gnarlpine Avenger',176,198,9,10,0,nil,nil,0,nil,nil,82,nil,nil,0},
[2014] = {'Gnarlpine Totemic',186,208,10,11,0,nil,nil,0,nil,nil,82,nil,nil,0},
[2015] = {'Bloodfeather Harpy',176,176,8,9,0,{[141]={{36.02,31.53},{39.5,33.33},{38.68,33.43},{37.92,33.15},{38.39,33.25},{36.8,30.53},{36.76,31.13},{37.66,30.83},{37.15,30.65},{36.95,30.78},{39.87,38.47},{39.84,35.99},{39.44,35.79},{38.89,34.84}}},nil,141,nil,nil,514,nil,nil,0},
[2017] = {'Bloodfeather Rogue',176,176,8,9,0,{[141]={{38.39,34.13},{36.4,31.09},{39.56,37.92},{38.96,36.54},{36.9,30.25},{38.04,33.92},{36.99,31.19},{39.57,36.46},{40.62,37.44},{38.81,33.93},{40.53,35.62}}},nil,141,nil,nil,514,nil,nil,0},
[2018] = {'Bloodfeather Sorceress',160,160,9,9,0,{[141]={{39.51,38.32},{37.72,34.07},{38.17,32.72},{37.53,34.49},{37.19,29.87},{37.53,30.76},{37.85,32.2},{37.85,30.64},{39.56,37.46},{39.05,32.97},{39.98,39.07},{39.9,37.22},{39.62,36.03}}},nil,141,nil,nil,514,nil,nil,0},
[2019] = {'Bloodfeather Fury',198,198,9,10,0,{[141]={{36.76,24.06},{37.12,24.77},{36.09,25.82},{35.7,25.39},{35.64,26.4},{35.47,26.01},{35.55,28.16},{39.53,24.74}}},nil,141,nil,nil,514,nil,nil,0},
[2020] = {'Bloodfeather Wind Witch',176,176,9,10,0,{[141]={{36.87,24.67},{36.16,26.26},{35.85,25.84},{35.61,26.81},{36.73,26.44},{34.7,28.36},{35.41,28.66},{34.42,27.78},{38.54,24.88},{37.13,23.86},{38.58,22.83}}},nil,141,nil,nil,514,nil,nil,0},
[2021] = {'Bloodfeather Matriarch',208,208,11,11,0,{[141]={{36.68,24.39},{36.89,24.97},{36.18,26.29},{35.12,28.38},{35.06,28.93},{36.9,25.5},{38.72,24.17},{38.92,24.62},{37.7,23.15}}},nil,141,nil,nil,514,nil,nil,0},
[2022] = {'Timberling',156,156,8,9,0,{[141]={{61.16,59.93},{55.16,59.62},{54.77,58.72},{54.36,57.61},{59.43,57.66},{60.35,58.69},{60.51,57.72},{60.24,57.08},{57.69,56.22},{56.95,57.57},{55.03,58},{56.32,57.23},{57.13,56.68},{56.69,56.62},{55.55,58.64},{60.56,60.4},{59.97,61.97},{59.44,62.84},{59.82,58.6},{59.91,61.07},{58.24,62.78},{57.2,62.29},{57.71,62.05},{57.58,61},{58.83,62.96},{57.71,63.83},{57.09,61.34},{57.1,60.32},{59.38,61.11},{58.8,56.22},{59.95,57.73},{59.36,56.89},{59.31,56.08}}},nil,141,nil,nil,14,nil,nil,0},
[2025] = {'Timberling Bark Ripper',137,137,7,8,0,{[141]={{53.22,59.56},{52.61,60.24},{49.23,63.23},{48.45,63.48},{51.84,61.23},{52.98,63.96},{52.86,63.07},{53.73,61.97},{54.54,60.83},{51.66,64.26},{52.51,64.77},{50.6,62.87}}},nil,141,nil,nil,14,nil,nil,0},
[2027] = {'Timberling Trampler',176,176,8,9,0,{[141]={{53.71,65.68},{53.34,65.21},{52.96,65.1},{53.08,64.67},{43.92,35.57},{45,37.5},{45.11,35.89},{45.2,34.33},{43.55,36.73},{43.87,37.19},{44.18,34.07},{43.31,33.36}}},nil,141,nil,nil,14,nil,nil,0},
[2029] = {'Timberling Mire Beast',198,198,9,9,0,{[141]={{43.95,30.61},{44.54,26.22},{43.68,29.09},{43.38,29.82},{44,32.32},{44.65,31.45},{44.61,27.97},{45.05,30.75},{44.55,29.75}}},nil,141,nil,nil,14,nil,nil,0},
[2030] = {'Elder Timberling',208,208,11,11,0,{[141]={{45.66,24.55},{44.02,25.43},{45.2,23.8},{44.61,22.98},{45.2,22.9},{45.73,22.96},{46.19,23.45},{44.61,24.61},{45.17,25.49}}},nil,141,nil,nil,14,nil,nil,0},
[2031] = {'Young Nightsaber',0,0,1,1,0,{[6450]={{47.29,80.83},{48.11,79.47},{60.35,67.29},{65.29,64.78},{60.91,65.7},{63.22,64.7},{61.35,63.87},{65.98,61.8},{59.44,62.24},{35.56,64.11},{34.76,65.1},{34.06,67.63},{35.61,68.12},{34.73,70.04},{34.75,75.52},{36.2,71.86},{35.31,73.06},{40.08,77.89},{45.43,80.56},{44.36,82.31},{44.75,80.82},{46.84,80.37},{47.79,79.31},{47.34,75.46},{45.76,76.94},{39.14,74.73},{43.79,76.74},{40.66,76.17},{43.06,77.47},{42.56,75.59},{42.09,73.98},{41.59,71.13},{37.78,62.76},{39.45,64.17},{40,65.04},{57.4,63.82},{56.41,67.38},{48.25,75.62},{55.35,66.77},{48.06,77.27},{55.68,70.01},{57.01,70.24},{57.42,67.27},{52.31,73.36},{50.45,78.57},{50.67,77.71},{56.36,73.88},{52.73,75.1},{57.03,76.33},{56.71,78.39},{52.39,78.99}}},nil,6450,nil,nil,7,"AH",nil,0},
[2032] = {'Mangy Nightsaber',0,0,2,2,0,{[6450]={{60.26,53.52},{62.51,53.62},{59.91,50.09},{58.16,53.47},{57.99,46.58},{59.2,48.09},{58.17,49.93},{60.33,43.15},{60.19,46.56},{54.63,41.38},{55.66,42.97},{58.07,39.7},{53.51,39.72},{52.34,41.38},{51.2,39.67},{50,37.92},{48.76,27.76},{44.02,32.97},{42.78,31.79},{41.78,31.91},{37.46,34.75},{40.92,38},{46.64,43.3},{48.75,43.07},{48.8,46.67},{48.93,49.73},{53.49,54.01}}},nil,6450,nil,nil,7,"AH",nil,0},
[2033] = {'Elder Nightsaber',156,156,8,9,0,{[141]={{37.38,26.6},{46.28,32.34},{46.58,29.49},{45.52,33.91},{46.95,33.36},{41.75,30.98},{37.68,25.61},{38.08,26.58},{47.33,38.84},{41.74,33.01},{41.78,39.71},{42.58,35.61},{42.12,39.71},{42.63,29.78},{46.69,37.46}}},nil,141,nil,nil,66,nil,nil,0},
[2034] = {'Feral Nightsaber',222,222,10,11,0,{[141]={{43.1,21.95},{48.6,23.68},{47.06,25.16},{48.36,22.09},{47.85,23.27},{42.16,23.14},{39.95,21.65},{42.95,25.47}}},nil,141,nil,nil,66,nil,nil,0},
[2038] = {'Lord Melenas',131,131,7,7,0,{[141]={{52.95,43.95}}},nil,141,nil,nil,90,nil,nil,0},
[2039] = {'Ursal the Mauler',176,176,9,9,0,{[141]={{51.7,39.43}}},{[141]={{{38.82,79.69},{38.8,79.58},{38.79,79.48},{38.81,79.56},{38.85,79.8},{38.92,79.91},{39.11,80.03},{39.24,80.1},{39.24,80.14},{39.04,80.18},{38.92,80.32},{38.77,80.45},{38.71,80.32},{38.76,80.2},{38.85,79.89}}}},141,nil,nil,82,nil,nil,0},
[2040] = {'Haggatha the Crone',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2041] = {'Ancient Protector',154980,154980,85,85,0,{[141]={{55.4,51.06},{39.09,48.32}},[1657]={{68.25,51.09}}},{[141]={{{57.16,57.31},{56.9,57.42},{56.74,57.53},{56.52,57.73},{56.3,57.96},{56.08,58.18},{55.75,58.38},{55.41,58.48},{55.14,58.51},{54.88,58.52},{54.66,58.5},{54.4,58.42},{54.15,58.3},{54.25,58.34},{54.51,58.44},{54.81,58.89},{54.9,59.17},{54.96,59.55},{54.98,59.81},{55,59.93},{55.13,60.26},{55.47,60.66},{55.83,61.04},{56.13,61.3},{56.37,61.48},{56.53,61.56},{56.73,61.43},{56.88,61.1},{57.03,60.63},{57.08,60.11},{57.09,59.59},{57.05,59.07},{57.06,58.68},{57.12,58.44},{57.19,58.22},{57.28,57.74},{57.37,57.57},{57.72,57.54},{58.25,57.6},{57.97,57.53},{57.8,57.47},{57.46,57.31},{57.29,57.29}}},[1657]={{{84.66,40.4},{84.31,36.17},{81.8,38.88},{80.64,38.81},{78.96,38.58},{77.27,38.68},{73.96,38.23},{73.73,41.96},{76.7,42.23},{78.82,42.15},{81.32,42.76}}}},141,nil,nil,80,"A",nil,0},
[2042] = {'Nightsaber',120,120,6,6,0,{[141]={{66.57,48.24},{66.03,47.13},{54.71,56.9},{63.58,48.13},{53.68,55.32},{52.94,51.22},{51.19,50.04},{51.43,51.87},{57.61,47.99},{64.19,47.54},{64.74,44.84},{51.55,52.58},{58.81,53.96},{53.52,49.16},{58.74,54.46},{53.09,54.43},{52.06,55.04},{51.13,53.94},{60.99,52.15},{61.18,53.35},{60.36,51.66},{58.57,50.42},{61.33,52.73},{65.2,47.54},{50.27,48.48},{50.07,45.61}}},nil,141,nil,nil,66,nil,nil,0},
[2043] = {'Nightsaber Stalker',137,137,7,8,0,{[141]={{62.08,62.47},{40.02,50.37},{48.3,62.04},{46.99,62.18},{46.76,63.17},{46,64.63},{47.4,65.36},{47.96,65.39},{50.83,66.82},{51.25,67.58},{50.31,67.27},{51.09,68.26},{50.46,69.01},{55.6,63.23},{55.86,63.69},{56,64.73},{40.73,50.73},{43.07,57.2},{40.51,49.22},{61.56,62.98},{61.97,61.87},{62.21,61.13},{60.35,63.88},{61.57,62.89},{42.91,56.09},{42.3,51.92},{42.94,55.42},{42.61,50.71},{42.48,49.91},{42.14,49.15},{42.3,48.67},{53.67,62.59}}},nil,141,nil,nil,66,nil,nil,0},
[2044] = {'Forlorn Spirit',590,628,25,26,0,nil,nil,0,nil,nil,77,nil,nil,0},
[2045] = {'Gunther\'s Minion',334,334,8,8,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2046] = {'Andrew Krighton',156,156,8,8,0,{[12]={{41.68,65.86}}},{[12]={{{41.7,65.86},{41.67,65.87},{41.67,65.87}}}},12,nil,nil,12,"A","Armorer & Shieldcrafter",4224},
[2050] = {'Raleigh Andrean',300,300,14,14,0,{[1497]={{62.01,42.75}}},nil,1497,nil,{441,530},68,"H","Ex-Chef",0},
[2051] = {'Twain The Tester FOO',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Model and Texture",0},
[2052] = {'Nag',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2053] = {'Haggard Refugee',417,449,18,19,0,nil,nil,0,nil,nil,1802,"A",nil,0},
[2054] = {'Sickly Refugee',404,433,19,20,0,nil,nil,0,nil,nil,11,"A",nil,0},
[2055] = {'Master Apothecary Faranell',2215,2215,50,50,0,{[1497]={{48.82,69.28}}},nil,1497,nil,{447,451,513,1109,1113,2938,12787,24899,29317},68,"H","Royal Apothecary Society",3},
[2056] = {'Ravenclaw Apparition',664,664,24,24,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2057] = {'Huldar',247,247,12,12,0,{[38]={{56.36,65.98}}},nil,38,{309,454},{273,13639},57,"A",nil,3},
[2058] = {'Deathstalker Faerleia',1251,1251,18,18,0,nil,nil,0,nil,{452},68,"H",nil,0},
[2060] = {'Councilman Smithers',247,247,12,12,0,nil,nil,0,nil,nil,16,nil,"Pyrewood Council",0},
[2061] = {'Councilman Thatcher',273,273,13,13,0,nil,nil,0,nil,nil,16,nil,"Pyrewood Council",0},
[2062] = {'Councilman Hendricks',273,273,13,13,0,nil,nil,0,nil,nil,16,nil,"Pyrewood Council",0},
[2063] = {'Councilman Wilhelm',273,273,13,13,0,nil,nil,0,nil,nil,16,nil,"Pyrewood Council",0},
[2064] = {'Councilman Hartin',273,273,13,13,0,nil,nil,0,nil,nil,16,nil,"Pyrewood Council",0},
[2065] = {'Councilman Cooper',273,273,13,13,0,nil,nil,0,nil,nil,16,nil,"Pyrewood Council",0},
[2066] = {'Councilman Higarth',273,273,13,13,0,nil,nil,0,nil,nil,16,nil,"Pyrewood Council",0},
[2067] = {'Councilman Brunswick',273,273,13,13,0,nil,nil,0,nil,nil,16,nil,"Pyrewood Council",0},
[2068] = {'Lord Mayor Morrison',328,328,15,15,0,nil,nil,0,nil,nil,16,nil,"Pyrewood Council Leader",0},
[2069] = {'Moonstalker',300,328,14,15,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2070] = {'Moonstalker Runt',66,66,15,16,0,nil,nil,0,nil,nil,2153,nil,nil,0},
[2071] = {'Moonstalker Matriarch',449,449,18,19,0,{[148]={{38.4,91.35},{47.22,90.13},{39.84,69},{38.69,70.99},{39.51,66.47},{44.82,62.4},{39.64,65.73},{41.89,63.72},{43.06,64.32},{40.82,89.05},{39.49,90.63},{41.21,65.57}}},nil,148,nil,nil,2153,nil,nil,0},
[2077] = {'Melithar Staghelm',0,0,5,5,0,{[6450]={{45.95,72.86}}},nil,6450,{3116,3117,3118,3119,3120,26841,28715,31168},{28715,28734},80,"A",nil,2},
[2078] = {'Athridas Bearmantle',222,222,11,11,0,{[141]={{55.69,52}}},nil,141,{475,483,486},{476,483,486},80,"A",nil,2},
[2079] = {'Ilthalaine',0,0,4,4,0,{[6450]={{45.54,74.62}}},nil,6450,{3116,3117,3118,3119,3120,26841,28713,28714,28734},{28713,28714},80,"A",nil,2},
[2080] = {'Denalan',222,222,11,11,0,{[141]={{59.93,59.76},{43.94,44.2}}},nil,141,{918,919,922,941,2499},{918,919,927,930,931,997,2498,2499},80,"A",nil,2},
[2081] = {'Sentinel Kyra Starsong',247,247,12,12,0,{[141]={{55.66,51.99}}},nil,141,{13945},{13945},80,"A",nil,2},
[2082] = {'Gilshalan Windwalker',0,0,9,9,0,{[6450]={{49.86,65.89}}},nil,6450,nil,nil,80,"A",nil,2},
[2083] = {'Syral Bladeleaf',247,247,12,12,0,{[141]={{55.76,50.44}}},nil,141,{489,997,1581,13946},{1581,13946},80,"A",nil,2},
[2084] = {'Natheril Raincaller',3758,3758,57,57,0,{[618]={{48.42,41.95}}},nil,618,nil,nil,35,"AH","General Goods",640},
[2086] = {'Valstag Ironjaw',713,713,25,25,0,{[11]={{10.57,55.69}}},nil,11,nil,{455,462},55,"A",nil,0},
[2089] = {'Giant Wetlands Crocolisk',734,787,25,26,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2090] = {'Ma\'ruk Wyrmscale',726,726,20,20,4,{[11]={{48.22,74.06},{48.16,73.99}}},nil,11,nil,nil,62,nil,"Dragonmaw Warlord",0},
[2091] = {'Chieftain Nek\'rosh',750,750,26,26,0,nil,nil,0,nil,nil,62,nil,nil,0},
[2092] = {'Pilot Longbeard',617,617,23,23,0,{[1537]={{72.73,94.01}}},nil,1537,nil,{708,740},55,"A","Ironforge Siege Brigade",2},
[2093] = {'Einar Stonegrip',484,484,20,20,0,nil,nil,0,nil,nil,55,"A",nil,0},
[2094] = {'James Halloran',713,713,25,25,0,nil,nil,0,nil,{469,471,484},12,"A",nil,0},
[2095] = {'Billy the Street Urchin',25,27,1,1,0,nil,nil,0,nil,{241,8459},35,"AH","Don't trust me! I'm named Billy!",0},
[2096] = {'Tarrel Rockweaver',713,713,25,25,0,{[11]={{12.97,49.58}}},nil,11,nil,{306},55,"A",nil,0},
[2097] = {'Harlo Barnaby',713,713,25,25,0,nil,nil,0,nil,nil,55,"A",nil,0},
[2098] = {'Ram',102,102,5,5,0,{[11]={{47.69,79.01},{49.28,74.75},{51.11,78.17},{50.36,77.3},{49.97,68.03},{50.32,75.21},{51.74,78.49},{51.47,70.47},{48.47,65.88},{55.85,82.65},{48.39,67.19},{47.28,73.21},{49.57,77.2},{48.88,77},{50.05,72.33},{48.95,69.16},{47.56,66.67},{48.03,67.15},{16.29,71.98},{16.19,72.45}},[38]={{49.47,70.88},{19.05,75.54},{78.79,70.36},{75.89,55.84},{52.4,72.59},{76.83,63.39},{64.99,72.66},{77.24,56.11},{70.9,72.18},{28.17,43.05},{50.75,71.03},{52.69,71.98},{30.71,30.03},{65.89,58.75},{34.8,36.16},{75.89,54.42},{31.15,27.6},{58.44,66.46},{38.75,18.31},{61.13,59.06},{21.07,76.59},{67.96,47.65},{74.94,50.47},{68.83,48.99},{75.33,49.4},{40.79,54.09},{27.81,29.14},{73.91,48.89},{78.59,70.98},{84.49,62.22},{27.11,21.96},{43.4,64.92},{30.98,12.69},{30.37,10.53},{25.1,32.49},{47.25,71.97},{40.34,29.33},{32.58,34.35},{75.15,57.47},{28.94,66.17},{29.89,31.67},{71.11,70.86},{51.56,70.31},{64.58,58.96},{58.55,66.45},{60.78,58.95},{62.6,28.9},{57.52,21.21},{61.79,23.57},{58.82,16.25},{61.08,22.67},{60.6,19.41},{60.94,27.29},{60.93,27.42},{59.91,16.74},{58.57,15.73},{71.77,36.46},{75.52,57.41},{77.39,39.82},{67.47,47.04},{62.92,29.73},{77.23,55.84},{71.04,42.55},{30.95,29.28},{75.65,45.99},{58.83,32.3},{63.69,31.55},{57.71,21.03},{65.14,59.03},{75.65,38.14},{35.69,36.18},{76.02,41.87},{76.32,54.21},{30.95,28.39},{61.95,23.64},{66.28,36.71},{66.01,41.28},{67.65,35.94},{68.02,40.3},{75.36,48.5},{76.65,43.65},{61.31,23.2},{73.43,42.94},{60.8,19.52},{68,47.85},{69.51,38.37},{60.62,27.28},{76.06,50.69},{68.35,48.88},{60.62,27.87},{60.14,18.1},{67.06,35.66},{75.72,50.06},{28.24,28.29},{75.26,49.3},{74.06,39.95},{71.5,39.34},{61.92,30.12},{73.5,42.76},{73.2,40.4},{76.87,35.98},{73.57,39.3},{77.36,34.62},{76.27,46.66},{78.29,39.85},{77.89,40.06},{27.56,21.35},{30.01,12.68},{41.15,28.6},{33.44,34.02},{75.73,56.63}},[267]={{46.96,6.35},{63.6,24.18},{57.58,16.25},{60.93,24.7},{49.4,15.86},{45.19,19.68},{60.3,30.62},{42.95,24.72},{61.03,23.5},{63.49,24.15}}},nil,38,nil,nil,2136,"AH",nil,0},
[2099] = {'Maiden\'s Virtue Crewman',484,484,20,20,0,{[11]={{8.3,59.2},{6.51,61.18},{6.59,61.4},{8.57,61.65},{7.48,57.45},{8.4,59.22},{8.74,59.42},{8.45,59.39},{5.84,55.46},{6.96,57.86},{8.36,61.78},{5.59,55.49},{7.37,62.89}}},nil,11,nil,nil,57,"A",nil,0},
[2102] = {'Dragonmaw Grunt',494,531,20,21,0,nil,nil,0,nil,nil,62,nil,nil,0},
[2103] = {'Dragonmaw Scout',449,484,19,20,0,nil,nil,0,nil,nil,62,nil,nil,0},
[2104] = {'Captain Stoutfist',1342,1342,35,35,0,{[11]={{10.52,55.71}}},nil,11,{25780,26980},{464,473,474,25777,25780},55,"A",nil,3},
[2105] = {'Mountaineer Dokkin',1398,1398,25,25,0,{[38]={{25.4,4.18}}},{[38]={{{25.29,0.12},{25.3,0.61},{25.32,1.32},{25.35,2.33},{25.37,3.33},{25.39,4.16},{25.43,5.13},{25.46,6.13},{25.48,7.08},{25.5,8.01},{25.53,8.91},{25.55,9.64},{25.56,10.2},{25.55,9.61},{25.53,8.97},{25.51,8.11},{25.48,7.14},{25.45,6.11},{25.42,5.17},{25.4,4.26},{25.37,3.21},{25.34,2.23},{25.32,1.28}}}},38,nil,nil,57,"A",nil,0},
[2106] = {'Apothecary Berard',356,356,16,16,0,{[130]={{43.03,73.35}}},nil,130,nil,nil,14,nil,nil,0},
[2107] = {'Gaerolas Talvethren',137,137,7,7,0,{[141]={{64.59,51.13}}},nil,141,{476},{475},80,"A",nil,2},
[2108] = {'Garneg Charskull',915,915,25,25,4,{[11]={{38.56,46.17},{38.42,46.03}}},nil,11,nil,nil,62,nil,nil,0},
[2109] = {'Steam Tank',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2110] = {'Black Rat',1,1,1,1,0,{[3]={{27.4,37.34},{50.98,34.63},{32.73,40.17},{32.65,40.03},{11.25,78.06},{38.54,25.09},{34.72,14.67},{22.25,58.7},{51.08,34.35},{51.65,68.08},{33.43,21.11},{12.06,76.25},{33.65,12.22},{13.82,73.28},{39.04,24},{39.8,23.56},{36.21,10.44},{37.32,10.87},{39.66,23.83},{47.22,57.5},{39.66,26.7},{13.5,74.07},{13.75,74.72},{38.52,22.85},{13,74.78},{49.19,29.64},{39.75,25.4},{17.11,62.55},{12.06,74.01},{38.9,25.44},{39,24.56},{39.82,24.5},{39.9,23.58},{39.18,24.37},{11.66,72.24},{19.37,50.88},{50.98,34.1},{51.79,34.53},{51.38,34.39},{19.32,51.04},{36.65,14.26},{38.43,12.57},{18.42,50.56},{46.99,57.02},{47.21,56.9},{12.15,79.02},{11.22,78.05},{12.25,79.05},{36.46,14.73},{34.54,14.8},{33.61,12.01},{36.26,10.57},{37.27,10.95}},[10]={{64.98,59.54},{66.49,54.82},{51.04,67.53},{74.23,30.79},{73.71,54.34},{70.07,61.11},{78.1,35.67},{71.8,37.55},{68.45,51.47},{78.76,33.84},{73.63,50.57},{74.01,42.47},{76.07,48.2},{74.21,30.8},{77.11,53.95},{73.74,54.49},{78.08,35.82},{71.72,37.51},{75.64,57.8},{68.71,51.59},{78.85,33.77},{73.56,50.76},{59.03,69.76},{43.8,71.48},{57.31,78.69},{51.21,67.1},{73.65,79.12},{77.25,54.01},{73.56,54.5},{65.59,67.35},{78.61,71.56},{78.83,68.66},{69.96,61.44},{65.85,70.19},{75.67,58.01},{63.01,70.32},{64.95,67.8},{61.27,70.6},{73.26,76.72},{80.95,71.31},{74.22,78.74},{41.84,64.37},{16.24,29.88},{16.64,32.44},{21.91,54.19},{16.47,31.25},{15.57,42.38},{15.64,35.19},{15.11,33},{18.73,35.49},{26.17,34.44},{19.37,60.41},{23.64,33.84},{24.39,31.47},{17.26,35.58},{22.76,27.36},{21.75,35.44},{16.46,37.15},{13.78,32.79},{25.82,29.52},{16.75,38.22},{25.66,32.29},{23.22,43.1},{21.6,29.14},{16.66,27.59},{13.34,35.83},{16.33,28.74},{16.89,34.27},{21.83,36.92},{21.24,29.86},{24.46,60.09},{14.71,34.17},{16.46,47.74},{14.98,36.47},{13.8,37.05},{22.01,26.99},{16.3,33.06},{21.26,28.67},{15.23,38.52},{17.12,36.86},{12.93,33.77},{17.89,38.24},{20.13,28.06},{24.06,29.9},{18.01,40.03},{24.02,27.32},{25.38,34.46},{25.51,29.07},{30.69,61.36},{41.67,64.22},{43.8,71.48},{16.15,29.69},{16.71,32.26},{21.9,54.54},{16.48,31.39},{15.77,42.44},{15.87,34.82},{15.02,33.5},{18.63,35.82},{19.31,60.43},{23.58,33.93},{24.42,31.54},{17.16,35.61},{15.74,63.57},{22.36,27.42},{21.72,35.74},{16.55,36.99},{13.67,32.57},{25.9,29.54},{16.67,38.27},{25.49,32.75},{21.46,28.91},{16.77,27.39},{13.3,36},{16.48,28.81},{16.76,34.3},{21.48,29.9},{24.5,60.63},{14.69,34.29},{16.1,47.08},{14.97,36.26},{13.81,36.71},{21.87,26.99},{16.03,33.37},{21.14,28.66},{15.23,38.48},{17.39,36.77},{13.02,33.72},{18.06,37.9},{20.36,28.05},{24.09,29.42},{18.03,40.08},{23.82,27.25},{25.35,34.16},{25.39,29.22},{21.55,73.34},{30.82,61.43},{41.73,64.36},{23.93,27.48}},[11]={{34.16,54.15},{75.31,45.78},{20.36,69.33},{10.48,59.83},{41.74,22.01},{12.89,50.82},{10.27,57.18},{10.38,57.36},{32.82,51.04},{10.66,57.31},{10.66,61.64},{43.11,26.17},{46.82,47.01},{37.87,29.17},{46.36,45.95},{26.84,25.2},{33.89,46.4},{48.83,47.55},{49.46,41.17},{34.74,48.49},{35.29,46.2},{5.5,56.07},{33.94,48.07}},[15]={{46.02,56.78},{45.83,67.61},{44.5,65.22},{54.15,56.05},{56.77,86.55},{68.85,56.65},{63.61,48.49},{66.15,49.41},{67.59,46.34},{68.36,48.59},{67.25,57.73},{67.55,58.06}},[28]={{43.99,12.68},{48.42,70.68},{47.37,13.4},{65.44,76.48},{47.43,14.92},{68.62,78.16},{47.85,69.31},{49.83,78.52},{52.33,78.32},{49.85,77.83},{65.43,76.64},{43.82,10.85},{69,76.96},{50.38,77.1},{50.1,75.75},{70.66,74.4},{54.1,66.53},{45.24,12.43},{63.72,58.09},{68,48.08},{62.84,55.98},{53.35,66.3},{53.57,44.44},{63.17,58.45},{43.05,61.74},{43.59,65.57},{49.27,66.55},{37.19,55.08},{49.52,66.79},{37.02,57.65},{37.53,55.69},{54.07,45.04},{52.99,65.56},{51.39,77.13},{61.51,58.5},{65.34,39.5},{46.87,52},{46.18,53.5},{46.16,54.28},{49.91,79.97},{51.77,44.73},{66.51,50.1},{49.9,75.47},{64.76,48.42},{65.79,54.2},{63.04,49.03},{65.9,54.01},{59.34,52.59},{49.77,46.21},{65.33,53.24},{67.64,44.41},{66.09,42.09},{59.62,53.35},{61.53,51.39},{61.81,51.15},{59.67,52.93},{49.7,46.7},{59.37,52.76},{59.63,53.29},{61.47,51.52},{65.2,53.27},{65.59,54.58},{61.82,51.25}},[139]={{11.62,64.74},{32.73,71.4},{23.48,67.18},{23.27,67.98},{28.44,59.83},{30.63,59.82},{41.7,60.06},{34.4,64.36},{29.65,67.81},{31.29,68.94},{30.86,60.54},{30.16,68.27},{19.63,62.01},{18.93,60.26},{33.67,63.36},{19.56,61.98},{24.14,79.43},{24.51,79.69},{49.69,43.88},{68.81,73.37},{45.33,38.31},{48.85,44.21},{70.38,76.32},{49.52,45.36},{23.51,78.87},{53.82,64.74},{47.61,57.01},{56.05,57.42},{56.61,73.77},{56.43,55.7},{32.47,71.3},{34.76,85.36},{34.84,85.57},{33.05,84.16},{34.87,84.72},{67.71,75.85},{66.6,72.41},{55.96,58.91},{55.21,68.82},{53.95,69.5},{46.94,58.81},{34.6,82.34},{48.41,67.27},{59.04,69.41},{50.01,44.08},{69.68,73.82},{42.34,39.71},{86.99,83.98},{87.18,84.9},{44.42,38.13},{74.39,58.56},{45.48,38.31},{51.04,27.13},{70.38,77.01},{69.62,71.72},{14.18,30.28},{46.54,34.15},{73.85,51.24},{75.16,58.64},{75.56,50.93},{54.19,64.92},{56.06,56.47},{54.65,26.44},{54.61,43.09},{54.64,27.44},{60.72,19.51},{56.28,55.74},{56.93,42.91},{61.07,61.34},{56.81,44.31},{59.27,22.68},{63.26,25.65},{12.73,27.25},{12.85,25.68},{70.85,45.76},{57.61,28.93},{87.7,83.6},{64.86,24.88},{70.52,46.42},{86.64,50.16},{86.72,49.77},{14.28,28.29},{66.63,73.46},{56.18,58.81},{55.86,63.23},{54.94,68.78},{53.94,69.1},{66.49,25.31},{76.72,50.49},{11.17,28.58},{71.33,43.39},{67.59,75.62},{62.56,34.74},{30.63,59.41},{45.92,36.94},{28.73,60.97},{61.56,32.33},{61.33,32.31},{33.69,62.3},{30.44,60.37},{11.03,28.68},{11.33,64.9},{12.54,26.74},{12.83,26.69},{14,67.43}},[206]={{-1,-1}},[209]={{-1,-1}},[400]={{94.13,76.58},{92.6,75.93},{91.81,78.76},{91.76,79.09},{91.52,78.72},{92.26,79.08},{94.19,76.76},{92.67,75.81}},[722]={{-1,-1}},[1196]={{-1,-1}},[1583]={{-1,-1}},[2057]={{-1,-1}},[3714]={{-1,-1}},[3717]={{-1,-1}},[4075]={{-1,-1}},[4196]={{-1,-1}},[4264]={{-1,-1}},[4415]={{-1,-1}},[4494]={{-1,-1}},[4737]={{67.74,84.47},{61.32,97.16},{49.13,33.91},{41.68,69.46},{39.25,67.77},{67.57,84.43},{73.23,84.2},{45.64,35.62},{38.69,44.84},{68.7,77.89},{42.58,76.95},{69.95,77.59},{72.57,72.76},{42.09,78.69},{32.81,74.06},{49.11,33.88},{34.85,59.73},{33.56,76.33},{41.95,69.86},{39.07,67.57},{40.18,79.8},{43.37,81.37},{35.16,63},{32.76,77.39},{45.77,35.66},{37.61,49.02},{35.25,69.04},{38.44,45.31},{36.99,80.04},{68.76,77.79},{42.81,77.37},{36.71,69.04},{62.78,92.64},{40.54,68.05},{68.31,84.05},{68.81,77.83},{70.24,75.57},{41.76,69.42},{37.61,50.71},{33.52,76.97},{35.33,63.02},{40.27,67.68},{35.37,69.34},{38.96,45.15},{37.39,49.3},{38.88,44.52},{32.42,73.72},{33.45,72.51},{45.07,76.04},{41.77,69.49},{37.65,50.61},{39.03,45.59},{37.52,48.94},{45.79,35.67},{27.97,44.92},{35.12,59.51},{69.79,77.53},{62.84,92.96},{67.67,84.38},{67.73,83.81},{40.31,67.72},{73.34,83.85},{38.25,51.01},{74.67,69.54},{69.58,77.44},{38.08,49.09},{72.57,72.71}},[4809]={{-1,-1}},[4812]={{-1,-1}},[4813]={{-1,-1}},[4922]={{29.58,41.2},{28.26,39.29},{25.14,38.14},{27.79,39.56},{26.09,37.31},{20.65,15.72},{19.43,16.87}}},nil,10,nil,nil,31,"AH",nil,0},
[2111] = {'Sida',484,484,20,20,0,nil,nil,0,nil,{470},55,"A",nil,0},
[2112] = {'Farrin Daris',417,417,19,19,0,{[10]={{73.63,43.46}}},{[10]={{{73.69,44.34},{73.63,43.46},{73.69,44.34},{73.63,43.46}}}},10,nil,nil,12,"A",nil,0},
[2113] = {'Archibald Kava',0,0,5,5,0,{[6454]={{53.17,56.56}}},nil,6454,nil,nil,68,"H","Cloth & Leather Armor Merchant",4224},
[2114] = {'Faruza',102,102,5,5,0,{[85]={{59.39,52.05}}},nil,85,nil,nil,68,"H","Herbalism Trainer",80},
[2115] = {'Joshua Kien',0,0,5,5,0,{[6454]={{52.63,55.68}}},nil,6454,nil,nil,68,"H","General Supplies",640},
[2116] = {'Blacksmith Rand',0,0,5,5,0,{[6454]={{53.02,58.92}}},nil,6454,nil,nil,68,"H","Apprentice Armorer",4224},
[2117] = {'Harold Raims',0,0,5,5,0,{[6454]={{53.19,59.76}}},nil,6454,nil,nil,68,"H","Apprentice Weaponsmith",4224},
[2118] = {'Abigail Shiel',176,176,9,9,0,{[85]={{61.17,50.97}}},nil,85,nil,nil,68,"H","Trade Supplies",128},
[2119] = {'Dannal Stern',0,0,5,5,0,{[6454]={{54.2,56.39}}},nil,6454,{24969},{3095,24969},68,"H","Warrior Trainer",2},
[2120] = {'Archmage Ataeric',2245,2245,19,19,1,{[130]={{56.64,64.36}}},nil,130,nil,nil,76,"AH",nil,0},
[2121] = {'Shadow Priest Allister',484,484,20,20,0,{[130]={{44.85,42.43}}},nil,130,nil,{478,479,480,482,516},68,"H",nil,0},
[2122] = {'David Trias',0,0,5,5,0,{[6454]={{53.66,56.55}}},nil,6454,{24967,28651},{3096,24967},68,"H","Rogue Trainer",2},
[2123] = {'Dark Cleric Duesten',0,0,5,5,0,{[6454]={{47.75,58.11}}},nil,6454,{24966,28651},{3097,24966},68,"H","Priest Trainer",2},
[2124] = {'Isabella',0,0,5,5,0,{[6454]={{47.03,58.24}}},nil,6454,{24965,28651},{3098,24965},68,"H","Mage Trainer",3},
[2126] = {'Maximillion',0,0,5,5,0,{[6454]={{46.93,59.39}}},nil,6454,{24968,28651},{3099,24968},68,"H","Warlock Trainer",2},
[2127] = {'Rupert Boch',328,328,15,15,0,{[85]={{61,50.37}}},nil,85,nil,nil,68,"H","Warlock Trainer",49},
[2128] = {'Cain Firesong',300,300,14,14,0,{[85]={{60.16,53.08}}},nil,85,nil,nil,68,"H","Mage Trainer",49},
[2129] = {'Dark Cleric Beryl',386,386,17,17,0,{[85]={{62.02,52.78}}},nil,85,nil,{5650,5651},68,"H","Priest Trainer",51},
[2130] = {'Marion Call',273,273,13,13,0,{[85]={{61.23,51.26}}},nil,85,nil,nil,68,"H","Rogue Trainer",49},
[2131] = {'Austil de Mon',356,356,16,16,0,{[85]={{60.32,51.58}}},nil,85,nil,nil,68,"H","Warrior Trainer",49},
[2132] = {'Carolai Anise',713,713,25,25,0,{[85]={{59.51,52.16}}},nil,85,nil,nil,68,"H","Alchemy Trainer",80},
[2134] = {'Mrs. Winters',198,198,10,10,0,{[85]={{60.75,50.85}}},nil,85,nil,nil,68,"H","General Supplies",640},
[2135] = {'Abe Winters',300,300,14,14,0,{[85]={{62.41,51.33}}},nil,85,nil,nil,68,"H","Apprentice Armorer",4224},
[2136] = {'Oliver Dwor',273,273,13,13,0,{[85]={{62.48,51.47}}},nil,85,nil,nil,68,"H","Apprentice Weaponsmith",4224},
[2137] = {'Eliza Callen',247,247,12,12,0,{[85]={{60.74,50.94}}},nil,85,nil,nil,68,"H","Leather Armor Merchant",4224},
[2138] = {'Warrior 25',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2140] = {'Edwin Harly',449,449,18,18,0,{[130]={{44.06,39.68}}},nil,130,nil,nil,68,"H","General Supplies",640},
[2142] = {'Watcher Callahan',1163,1163,32,32,0,{[10]={{81.92,19.69}}},nil,10,nil,nil,12,"A","The Night Watch",0},
[2149] = {'Dark Iron Raider',300,300,14,14,0,nil,nil,0,nil,nil,54,nil,nil,0},
[2150] = {'Zenn Foulhoof',137,137,7,7,0,{[141]={{59.47,49.16}}},nil,141,{488},{488,489},80,"A",nil,2},
[2151] = {'Moon Priestess Amara',713,713,25,25,0,{[141]={{49.35,44.67}}},nil,141,{487},{487},79,"A",nil,2},
[2152] = {'Gnarlpine Ambusher',137,137,7,8,0,{[141]={{49.3,43.25},{50.64,38.44},{49.44,43.3},{51.95,39.08},{49.84,41.39},{49.75,42.17},{50.16,35.2},{49.57,32.78},{49.06,32.65},{49.87,33.08},{50.02,34.64},{50.14,35.04},{49.71,33.63},{51.07,36.88},{51.43,37.37},{51.73,37.96},{49.8,41.35},{49.89,40.74},{49.73,42.21},{49.33,43.31},{50.45,36.34}}},nil,141,nil,nil,82,nil,nil,0},
[2153] = {'Terl Arakor',713,713,25,25,0,{[11]={{27.43,41.2}}},nil,11,nil,nil,123,"A",nil,1},
[2154] = {'Jesse The Tester',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Model and Texture",0},
[2155] = {'Sentinel Shayla Nightbreeze',156,156,8,8,0,{[141]={{40.75,46.93}}},{[141]={{{42.29,51.38},{42.1,51.33},{41.81,51.17},{41.43,50.96},{41,50.8},{40.55,50.76},{40.15,50.85},{39.85,51.24},{39.58,51.67},{39.39,52.24},{39.19,52.82},{38.96,53.3},{38.6,53.94},{38.18,54.42},{37.84,54.51},{37.33,54.45},{36.77,54.47},{36.49,54.5},{36.48,54.41},{36.93,54.38},{37.46,54.4},{37.9,54.43},{38.36,54.24},{38.73,53.67},{39.08,53.12},{39.32,52.4},{39.43,51.93},{39.66,51.46},{39.95,51.05},{40.17,50.77},{40.44,50.74},{40.84,50.75},{41.32,50.89},{41.73,51.1},{42.02,51.26}}}},141,nil,{490},80,"A",nil,0},
[2156] = {'Cracked Golem',354,382,18,19,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2157] = {'Stone Behemoth',382,411,19,20,0,nil,{[148]={{{36.25,85.92},{36.23,86.09},{36.13,86.22},{36.02,86.19},{36.02,86.19},{35.89,85.93},{35.68,85.5},{35.68,85.5},{35.82,85.75},{36.04,86.17},{36.15,86.23},{36.21,86.09},{36.22,85.9},{36.2,85.64},{36.23,85.71}}}},0,nil,nil,14,nil,nil,0},
[2158] = {'Gravelflint Scout',417,449,18,19,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2159] = {'Gravelflint Bonesnapper',449,484,19,20,0,nil,nil,0,nil,nil,22,nil,nil,0},
[2160] = {'Gravelflint Geomancer',413,441,20,21,0,nil,nil,0,nil,nil,22,nil,nil,0},
[2162] = {'Agal',352,352,9,9,4,{[141]={{47.26,44.64}}},nil,141,nil,nil,82,nil,nil,0},
[2163] = {'Thistle Bear',278,309,11,12,0,nil,nil,0,nil,nil,44,nil,nil,0},
[2164] = {'Rabid Thistle Bear',341,375,13,14,0,nil,nil,0,nil,nil,44,nil,nil,0},
[2165] = {'Grizzled Thistle Bear',482,482,17,18,0,{[148]={{44.22,88.26},{43.94,89.23},{45.74,89.74},{44.3,88.03},{40.29,79.57},{46.1,76.49},{39.26,75.65},{40.23,74.18},{40.99,74.72},{40.73,75.14},{41.12,79.32},{43.77,87.84},{45.76,89.78},{40.59,79.25},{40.7,76.57},{39.19,78.58},{40.37,77.31},{40.17,77.42},{39.03,72.82},{40.55,81.73},{39.6,81.1},{41.06,81.98},{46.51,79.78},{44.22,89.03},{44.25,77.73},{41.98,78.68},{44.03,80.29}}},nil,148,nil,nil,2154,nil,nil,0},
[2166] = {'Oakenscowl',198,198,10,10,0,{[141]={{47.38,35.2}}},nil,141,nil,nil,14,nil,nil,0},
[2167] = {'Blackwood Pathfinder',230,253,12,13,0,nil,nil,0,nil,nil,82,nil,nil,0},
[2168] = {'Blackwood Warrior',356,386,16,17,0,nil,nil,0,nil,nil,82,nil,nil,0},
[2169] = {'Blackwood Totemic',350,377,17,18,0,nil,nil,0,nil,nil,82,nil,nil,0},
[2170] = {'Blackwood Ursa',377,404,18,19,0,nil,nil,0,nil,nil,82,nil,nil,0},
[2171] = {'Blackwood Shaman',404,433,19,20,0,nil,nil,0,nil,nil,82,nil,nil,0},
[2172] = {'Strider Clutchmother',450,450,14,14,4,{[148]={{41.56,90.15},{40.66,48.59}}},{[148]={{{35.63,87.4},{36.19,87.35},{36.59,87.65},{36.9,88.15},{37.33,88.35},{37.48,88.65},{37.52,88.98},{37.6,89.73},{37.82,90.64},{38.18,91.18},{38.5,91.31},{38.74,91.46},{38.84,91.85},{38.74,92.37},{38.6,92.74},{38.32,92.91},{38.07,92.87},{37.55,92.38},{36.66,90.77},{36.29,89.98},{35.96,89.49},{35.65,89.38},{35.37,89.22},{35.14,88.81},{34.73,88.36},{34.31,87.79},{34.13,87.47},{34.16,87.14},{34.37,86.98},{34.83,87.32}}}},148,nil,nil,7,"AH",nil,0},
[2173] = {'Reef Frenzy',328,328,14,15,0,{[130]={{33.92,23.1},{35.8,34.24},{30.91,19.79},{31.63,21.48},{30.64,17.92},{34.25,26.93}}},nil,130,nil,nil,1878,nil,nil,0},
[2174] = {'Coastal Frenzy',300,356,14,16,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2175] = {'Shadowclaw',410,410,13,13,4,{[148]={{41.98,38.49},{41.16,36.51}}},{[148]={{{40.16,40.61},{40.02,40.57},{39.91,40.42},{39.73,40.37},{39.51,40.33},{39.06,39.84},{38.86,39.72},{38.52,39.64},{38.45,39.55},{38.42,39.33},{38.51,38.86},{38.66,38.39},{38.65,37.96},{38.74,37.51},{39.21,37.5},{39.58,37.64},{39.97,37.61},{40.12,37.83},{40.7,38.15},{41.13,38.12},{41.38,37.95},{41.37,37.66},{41.23,37.35},{41.25,36.8},{40.83,36.19},{40.61,36.12},{40.45,35.93},{40.24,35.39},{39.97,34.98},{39.77,35.01},{39.34,35.26},{39.1,35.52},{38.94,35.88},{38.92,36.54},{39.12,36.79},{39.26,36.87},{39.42,36.92},{39.29,37.19},{39.25,37.54},{39.37,37.86},{39.72,38.32},{39.71,38.88},{39.69,39.32},{40.04,39.68},{40.19,39.98},{40.27,40.27},{40.33,40.45}}}},148,nil,nil,14,nil,nil,0},
[2176] = {'Cursed Highborne',198,222,10,11,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2177] = {'Writhing Highborne',222,247,11,12,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2178] = {'Wailing Highborne',247,273,12,13,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2179] = {'Stormscale Wave Rider',328,356,15,16,0,nil,nil,0,nil,nil,74,nil,nil,0},
[2180] = {'Stormscale Siren',325,350,16,17,0,nil,nil,0,nil,nil,74,nil,nil,0},
[2181] = {'Stormscale Myrmidon',417,449,18,19,0,nil,nil,0,nil,nil,74,nil,nil,0},
[2182] = {'Stormscale Sorceress',379,405,19,20,0,nil,nil,0,nil,nil,74,nil,nil,0},
[2183] = {'Stormscale Warrior',494,531,20,21,0,nil,nil,0,nil,nil,74,nil,nil,0},
[2184] = {'Lady Moongazer',534,534,16,16,4,{[148]={{44.65,59.38},{44.81,56.79}}},nil,148,nil,nil,14,nil,nil,0},
[2185] = {'Darkshore Thresher',273,273,12,14,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2186] = {'Carnivous the Breaker',674,674,19,19,4,{[148]={{41.05,51.61},{41.56,76.6},{45.98,82.66},{44.35,83.04}}},nil,148,nil,nil,82,nil,nil,0},
[2187] = {'Elder Darkshore Thresher',356,417,16,18,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2188] = {'Deep Sea Threshadon',620,713,25,25,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2189] = {'Vile Sprite',198,222,10,11,0,nil,nil,0,nil,nil,81,nil,nil,0},
[2190] = {'Wild Grell',222,247,11,12,0,nil,nil,0,nil,nil,81,nil,nil,0},
[2191] = {'Licillin',394,394,14,14,4,{[148]={{49.54,34.55},{57.38,32.94}}},nil,148,nil,nil,81,nil,nil,0},
[2192] = {'Firecaller Radison',568,568,19,19,4,{[148]={{40.36,86.23},{40.06,83.07}}},{[148]={{{38.7,87.72},{38.54,87.68},{38.42,87.57},{38.24,87.4},{37.95,87.08},{37.96,86.76},{37.92,87.07},{37.92,87.07},{38.2,87.41},{38.38,87.53},{38.63,87.77},{38.91,87.94},{39.19,87.9},{39.19,87.9},{38.83,87.85}}}},148,nil,nil,16,nil,nil,0},
[2198] = {'Crier Goodman',71,71,3,3,0,{[1519]={{64.02,70.85},{56.82,62.33}}},{[1519]={{{56.28,74.15},{55.36,75.54},{55.76,76.33},{53.65,78.83},{54.69,81.04},{54.77,81.87},{54.63,83.72},{54.04,84.79},{53.62,85.43},{52.59,85.96},{51.16,86.59},{50.51,85.1},{49.74,84.66},{48.73,84.6},{47.31,87.05},{45.97,87.98},{45.04,87.68},{44.2,87.08},{43.89,85.72},{43.92,84.65},{44.11,82.04},{44.14,81.07},{44.19,80.34},{45.39,78.91},{46.48,77.9},{46.39,76.74},{45.53,74.36},{45.22,72.83},{44.21,70.86},{45.49,69.31},{46.87,67.58},{47.85,66.23},{47.81,64.19},{48.64,62.93},{49.68,61.65},{48.66,59.36},{50.88,56.67},{51.27,56.24},{53.75,55.08},{55.19,57.69},{56.9,55.75},{55.39,53.02},{55.52,51.34},{56.69,50.37},{57.89,51.83},{60.39,48.85},{59.5,46.83},{60.5,45.64},{61.74,44.39},{62.79,46.65},{63.73,48.62},{64.74,50.49},{66.43,51.13},{67.75,50.1},{67.75,50.1},{68.72,49.08},{69.7,48.1},{71.11,46.5},{72.13,47.67},{72.35,49.16},{71.45,50.64},{69.96,52.77},{71.69,56.21},{72.63,55.1},{73.59,55.04},{74.81,56.62},{76.2,59.03},{76.24,60.22},{75.31,61.41},{74.29,62.76},{72.84,61.75},{71.84,60.31},{69.7,62.72},{69.12,62.13},{68.25,63.23},{66.91,64.93},{66.06,64.07},{64.1,66.93},{65.28,69.08},{63.12,71.94},{61.25,73.98},{60.43,72.33},{60.13,71.67},{59.01,72.4},{57.55,73.37}}}},1519,nil,nil,12,"A",nil,1},
[2201] = {'Greymist Raider',222,247,11,12,0,nil,nil,0,nil,nil,18,nil,nil,0},
[2202] = {'Greymist Coastrunner',247,273,12,13,0,nil,nil,0,nil,nil,18,nil,nil,0},
[2203] = {'Greymist Seer',253,276,13,14,0,nil,nil,0,nil,nil,18,nil,nil,0},
[2204] = {'Greymist Netter',300,328,14,15,0,nil,nil,0,nil,nil,18,nil,nil,0},
[2205] = {'Greymist Warrior',330,356,15,16,0,nil,nil,0,nil,nil,18,nil,nil,0},
[2206] = {'Greymist Hunter',356,356,16,17,0,{[148]={{37.83,75.3},{38.06,74.83},{38.04,75.04},{38.21,75.05},{38.07,75.3},{38.15,74.91}}},nil,148,nil,nil,18,nil,nil,0},
[2207] = {'Greymist Oracle',404,404,18,19,0,{[148]={{37.96,83.59},{38.07,84.86},{37.75,84.06},{37.4,84.77},{37.08,83.26},{37.42,85},{36.61,83},{36.75,83.4},{36.52,84.38},{36.56,83.21}}},nil,148,nil,nil,18,nil,nil,0},
[2208] = {'Greymist Tidehunter',404,433,19,20,0,nil,nil,0,nil,nil,18,nil,nil,0},
[2209] = {'Deathguard Gavin',656,656,15,15,0,{[85]={{62.08,50.42}}},nil,85,nil,nil,71,"H",nil,1},
[2210] = {'Deathguard Royann',656,656,15,15,0,{[85]={{61.89,50.42}}},nil,85,nil,nil,71,"H",nil,1},
[2211] = {'Captured Mountaineer',176,176,9,9,0,{[85]={{60.04,52.87}}},nil,85,nil,{492,24996},68,"H",nil,2},
[2212] = {'Deth\'ryll Satyr',247,273,12,13,0,nil,nil,0,nil,nil,90,nil,nil,0},
[2213] = {'Deth\'ryll Shadowstalker',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2214] = {'Deathstalker Lesh',713,713,25,25,0,nil,nil,0,nil,nil,68,"H",nil,0},
[2215] = {'High Executor Darthalia',61040,61040,60,60,1,{[267]={{29.24,63.34}}},nil,267,{14351,28096,28111,28168},{494,527,528,529,532,539,541,549,566,567,27746,28089,28096,28571},68,"H",nil,3},
[2216] = {'Apothecary Lydon',1342,1342,35,35,0,nil,nil,0,nil,{493,496,501,509,515,517,1065,1066,2933,2934,2937},68,"H","Royal Apothecary Society",0},
[2217] = {'Undead Druid Trainer',25,27,1,1,0,nil,nil,0,nil,nil,21,nil,"Druid Trainer",32},
[2218] = {'Undead Hunter Trainer',25,27,1,1,0,nil,nil,0,nil,nil,21,nil,"Hunter Trainer",32},
[2219] = {'Undead Shaman Trainer',25,27,1,1,0,nil,nil,0,nil,nil,21,nil,"Shaman Trainer",32},
[2221] = {'Undead Tailor Trainer',25,27,1,1,0,nil,nil,0,nil,nil,21,nil,"Tailor Trainer",0},
[2222] = {'Undead Mining Trainer',25,27,1,1,0,nil,nil,0,nil,nil,21,nil,"Mining Trainer",64},
[2224] = {'Wind Rider',2320,2900,29,29,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2225] = {'Zora Guthrek',57150,57150,60,60,0,{[2597]={{-1,-1}}},nil,2597,nil,nil,1215,"H","Trade Goods",128},
[2226] = {'Karos Razok',232470,232470,85,85,1,{[130]={{45.41,42.49}}},nil,130,nil,nil,68,"H","Bat Handler",8195},
[2227] = {'Sharlindra',713,713,25,25,0,{[1497]={{57.63,93.8}}},nil,1497,{495},{521},68,"H",nil,2},
[2228] = {'Lieutenant Farren Orinelle',713,713,25,25,0,nil,nil,0,nil,{536,559,561,562},12,"A",nil,0},
[2229] = {'Krusk',713,713,25,25,0,{[267]={{57.68,46.9}}},nil,267,{28620},{497,498,506,508,533},29,"H",nil,2},
[2230] = {'Umpi',42,42,1,1,0,nil,nil,0,nil,{499},68,"H",nil,0},
[2231] = {'Pygmy Tide Crawler',176,198,9,10,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2232] = {'Tide Crawler',247,300,12,14,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2233] = {'Encrusted Tide Crawler',484,484,18,20,0,{[148]={{35.62,69.8},{35.12,69.03},{35.58,66.51},{37.27,75.08},{37.1,76.3},{34.22,79.35},{35.95,68.01},{34.27,79.07},{34.46,70.76},{34.52,87.72},{35.09,83.13},{36.07,80.15},{35.72,80.89},{35.53,86.45},{35.23,87.38},{36.72,86.21},{35.72,85.66},{36.26,80.73},{35.72,84.1},{37.04,81.97},{36.12,84.5},{34.41,82.66},{38.73,78.41},{37.77,77.72},{38.14,79.01},{37.59,79.75},{37.43,79.32},{38.09,80.51},{39.13,74.87},{39.41,73.95},{35.7,71.31},{39.56,74.01},{36.29,87.59},{37.53,67.18},{36.32,69.12},{37.52,69.36},{38.12,68.73},{37.79,69.36},{37.66,69.17},{36.95,71.51},{37.22,74.19},{35.21,73.77},{37.59,71.39},{37.57,76.99},{38.53,76.28},{35.84,83.16},{39.04,77.58},{37.69,65.89},{38.2,64.47},{36.46,65.22},{36.86,64.26},{36.14,66.67},{33.96,85.95},{34.69,85.81},{36.53,79.93}}},nil,148,nil,nil,7,"AH",nil,0},
[2234] = {'Young Reef Crawler',198,222,10,11,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2235] = {'Reef Crawler',328,386,15,17,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2236] = {'Raging Reef Crawler',494,531,20,21,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2237] = {'Moonstalker Sire',417,417,17,18,0,{[148]={{41.86,92.29},{40.8,93.32},{38.25,93.85},{39.78,91.19},{39.75,94.31},{38.34,92.8},{46.49,91.56},{46.8,89.69},{45.39,88.49},{45.9,90.63},{42.75,91.26},{40.92,93.4},{39.75,94.2},{41.85,92.55},{43.13,90.49},{39.17,65.25},{39.63,70.21},{41.11,69.48},{41.44,70.6},{44.69,61.44},{44.54,62.49},{43.72,62.61},{40.68,66.76},{41.75,69.04},{42.78,61.81},{43.28,62.97},{43.18,64.45},{42.68,63.43},{40.51,66.03},{40.8,88.62},{41.66,86.88},{39.89,88.64},{41.29,88.18},{38.39,91.53},{38.23,93.96},{39.56,90.06},{38.48,92.91},{41.57,65.79},{41.7,65.07},{41.75,63.58}}},nil,148,nil,nil,2153,nil,nil,0},
[2238] = {'Tog\'thar',713,713,25,25,0,{[267]={{60.03,63.78}}},nil,267,nil,nil,29,"H",nil,0},
[2239] = {'Drull',713,713,25,25,0,{[267]={{59.97,63.71}}},nil,267,nil,nil,29,"H",nil,1},
[2240] = {'Syndicate Footpad',1163,1221,32,33,0,nil,nil,0,nil,nil,87,nil,nil,0},
[2241] = {'Syndicate Thief',1221,1279,36,37,0,nil,nil,0,nil,nil,87,nil,nil,0},
[2242] = {'Syndicate Spy',651,651,24,24,0,{[267]={{55.76,23.23},{55.73,24.11},{52.66,12.04},{57.55,23.11},{55.96,17.11},{58.38,24.81},{55.77,25.46},{55.48,17.46},{58.3,24.72},{58.52,24.59},{54.56,26.42},{55.07,24.72},{49.72,10.03},{55.28,27.5},{53.68,14.55},{54.65,25.48},{56.85,24.72},{52.34,11.09},{58.46,24.61},{57.45,22.56},{53.87,15.24},{55.2,23.38},{55.11,16.81},{56.47,26.08},{58.45,25.36},{57.08,24.5},{56.58,24.56},{56.93,24.65},{56.42,24.46},{56.6,23.45},{58.22,23.65},{57.29,25.7},{58.82,24.99},{57.82,25.44},{49.23,9.95},{48.84,9.3},{58.82,25.82}}},nil,267,nil,nil,87,nil,nil,0},
[2243] = {'Syndicate Sentry',1469,1536,36,37,0,nil,nil,0,nil,nil,87,nil,nil,0},
[2244] = {'Syndicate Shadow Mage',441,472,21,22,0,nil,nil,0,nil,nil,472,nil,nil,0},
[2245] = {'Syndicate Saboteur',1536,1604,37,38,0,nil,nil,0,nil,nil,87,nil,nil,0},
[2246] = {'Syndicate Assassin',1604,1678,38,39,0,nil,nil,0,nil,nil,87,nil,nil,0},
[2247] = {'Syndicate Enforcer',1678,1753,39,40,0,nil,nil,0,nil,nil,87,nil,nil,0},
[2248] = {'Cave Yeti',666,666,22,23,0,{[267]={{43.73,55.07},{44.3,54.21},{43.88,54.42},{45.65,49.88},{47.42,53.4},{46.87,53.53},{46,55.35},{46.59,55.42},{44.83,50.99},{46.79,54.59},{45.45,52.61},{45.07,53.76},{45.44,53.9},{45.08,52.45},{45.14,51.58},{45.64,52},{45.03,51.36},{44.78,52.92},{45.84,53.81},{46.8,54.65},{47.28,54.45},{45.64,49.87},{43.73,54.93},{45.84,53.83},{45.64,49.85},{46.59,54.3},{45.03,53.76},{45.31,49.84},{44.79,52.97},{45,51.36},{43.84,54.06},{45.66,52},{45.4,52.69},{44.3,54.24}}},nil,267,nil,nil,16,nil,nil,0},
[2250] = {'Mountain Yeti',769,769,24,25,0,{[267]={{43.39,40.05},{44.49,41.21},{45.22,40.04},{44.9,37.45},{41.67,40.82},{39.61,33.07},{43.95,42.18},{39.18,35.75},{41.82,38.49},{44.52,39.23},{45.35,41.97},{43.15,41.12},{39.57,36.87},{39.71,34.94},{40.48,38.3},{44.47,37.94},{41.05,38.07}}},nil,267,nil,nil,16,nil,nil,0},
[2251] = {'Giant Yeti',769,769,25,26,0,{[267]={{46.04,35.21},{40.52,27.59},{42.22,41.95},{39,31.61},{42.62,19.88},{39.76,30.78},{40.51,30.3},{47.19,36.72},{39.07,29.77},{39.81,28.62},{45.22,35.94},{41.35,22.23},{45.93,36.99},{46.71,37.74},{43.1,20.43},{42.36,21.4},{42.61,40.08},{44.63,37.02},{38.96,27.66},{43.09,38.87},{45.74,39.24},{41.05,27.75},{46.52,35.47},{39.19,33.91},{40.58,25.34},{45.14,38.06},{39.91,26.99}}},nil,267,nil,nil,16,nil,nil,0},
[2252] = {'Crushridge Ogre',699,699,25,26,0,{[267]={{48.65,22.46},{51.66,25.54},{50.66,29.81},{50.76,23.72},{48.73,18.31},{53.56,30.76},{50.22,21.73},{50.74,21.41},{47.89,21.53},{50.09,34.88},{48.07,16.28},{49.26,35.79},{52.12,22.49},{50.83,33.83},{48.04,34.79},{50.69,19.48},{51.35,31.72},{50.19,20.56},{53.35,29.6},{52.49,25.72},{50.82,17.5},{52.81,20.34},{51.36,22.75},{50.78,18.5},{52.71,23.58},{52.88,30.92},{45.87,17.23},{49.16,34.06},{52.2,29.76},{53.32,24.59},{52.32,23.8},{47.11,18.41},{52.16,21.66},{50.11,30.69},{50.18,24.39},{51.52,20.58},{51.28,19.61},{48.84,19.66},{47.25,20.56},{52.17,24.65},{52.32,26.43},{52.47,25.28},{48.6,35.65},{47.78,34.11},{54.07,30.67},{53.84,23.07},{51.39,25.18},{51.48,26.11},{51.34,25.28},{52.35,26.62},{52.6,25.42},{50.4,25.02},{52.15,25.91}}},nil,267,nil,nil,45,nil,nil,0},
[2253] = {'Crushridge Brute',699,699,25,26,0,{[267]={{49.64,27.72},{49.35,20.39},{49.42,21.38},{49.31,22.61},{47.95,17.42},{47.37,19.6},{51.47,32.67},{48,18.78},{51.53,21.51},{49.74,32.35},{46.55,17.33},{50.84,22.73},{50.14,33.87},{48.71,32.93},{49.82,34.51},{52.41,30.29},{52.7,27.26},{51.47,29.7},{49.54,19.53},{51.57,26.93},{51.35,25.25},{51.48,26.11},{52.13,25.71},{50.66,25.4},{50.15,23.49},{49.17,25.41},{50.7,25.42},{51.42,26.23},{52.72,27.36}}},nil,267,nil,nil,45,nil,nil,0},
[2254] = {'Crushridge Mauler',750,750,25,26,0,{[267]={{48.61,26.42},{47.22,26.27},{47.25,27.38},{46.39,26.73},{48.42,25.83},{44.66,25.76},{44.02,23.73},{48.36,26.88},{45.17,25.72},{46.73,26.5},{47.27,29.03},{46.03,24.43},{45.77,27.47},{45.11,23.77},{44.59,22.52},{45.9,26.81}}},nil,267,nil,nil,45,nil,nil,0},
[2255] = {'Crushridge Mage',610,610,25,25,0,{[267]={{46.52,25.82},{45.81,22.29},{44.31,27.78},{45.29,26.74},{45.22,24.41},{44.06,22.77},{46.88,27.02},{48.22,26.3}}},nil,267,nil,nil,45,nil,nil,0},
[2256] = {'Crushridge Enforcer',699,699,25,26,0,{[267]={{43.95,33.75},{42.45,27.78},{44.25,29.14},{44.08,28.92},{45.19,30.72},{44.68,31.73},{43.12,31.84},{44.75,27.77},{45.28,28.93},{43.72,27.77},{41.98,28.78},{43.1,28.93},{43.92,30.98}}},nil,267,nil,nil,45,nil,nil,0},
[2257] = {'Mug\'thol',1500,1500,26,26,0,{[267]={{42.48,30.66}}},nil,267,nil,nil,45,nil,nil,0},
[2258] = {'Stone Fury',1706,1706,28,28,4,{[267]={{58.85,26.5}}},{[36]={{{64.68,44.77},{64.85,45.32},{65.17,46.36},{65.67,47.02},{67.79,47.13},{68.39,46.76},{69.02,46.5},{70.56,46.61},{71.87,46.39},{73.38,46.35},{75.18,46.75},{77.1,46.64},{78.29,45.86},{79.32,44.55},{79.97,42.39},{80.11,40.41},{79.97,42.39},{79.31,44.58},{78.28,45.87},{77.09,46.65},{75.18,46.75},{73.38,46.35},{71.85,46.39},{70.54,46.61},{69.01,46.5},{68.37,46.76},{67.79,47.14},{65.65,47.02},{65.16,46.35},{64.85,45.33}}}},267,nil,nil,91,nil,nil,0},
[2260] = {'Syndicate Rogue',531,573,21,22,0,nil,nil,0,nil,nil,472,nil,nil,0},
[2261] = {'Syndicate Watchman',494,531,20,21,0,nil,nil,0,nil,nil,472,nil,nil,0},
[2263] = {'Marshal Redpath',1902,1902,41,41,0,nil,nil,0,nil,{500,504,560},12,"A",nil,0},
[2264] = {'Hillsbrad Tailor',664,713,24,25,0,nil,nil,0,nil,nil,123,"A",nil,129},
[2265] = {'Hillsbrad Apprentice Blacksmith',664,713,24,25,0,nil,nil,0,nil,nil,123,"A",nil,128},
[2266] = {'Hillsbrad Farmer',617,664,23,24,0,nil,nil,0,nil,nil,123,"A",nil,0},
[2267] = {'Hillsbrad Peasant',664,664,24,25,0,{[2367]={{-1,-1}}},nil,2367,nil,nil,123,"A",nil,0},
[2268] = {'Hillsbrad Footman',734,787,25,26,0,nil,nil,0,nil,nil,123,"A",nil,0},
[2269] = {'Hillsbrad Miner',471,471,19,19,0,{[267]={{33.87,71.54},{33.8,72.19}}},nil,267,nil,nil,12,"A",nil,0},
[2270] = {'Hillsbrad Sentry',471,471,19,20,0,{[267]={{33.64,72.64},{33.46,73.25},{33.79,72.65},{33.52,71.89},{33,72.88},{34.21,72.99},{33.06,72.5}}},nil,267,nil,nil,12,"A",nil,0},
[2271] = {'Dalaran Shield Guard',1107,1163,31,32,0,nil,nil,0,nil,nil,76,"AH",nil,0},
[2272] = {'Dalaran Theurgist',882,918,32,33,0,nil,nil,0,nil,nil,76,"AH",nil,0},
[2274] = {'Stanley',664,664,24,24,0,nil,nil,0,nil,{502},1801,"H",nil,0},
[2275] = {'Enraged Stanley',660,660,24,24,0,nil,nil,0,nil,nil,38,nil,nil,0},
[2276] = {'Magistrate Henry Maleb',48840,48840,60,60,1,nil,nil,0,nil,{505,510,512,522,523,525,537},96,"A",nil,0},
[2277] = {'Loremaster Dibbs',1003,1003,30,30,0,nil,nil,0,nil,{511,538,540,551},12,"A",nil,0},
[2278] = {'Melisara',713,713,25,25,0,{[267]={{57.27,46.34}}},nil,267,{28538,28566,28603,28605},{495,518,519,520,28538,28566,28603,28605},68,"H",nil,2},
[2279] = {'Alliance Battleguard',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2280] = {'Horde Battleguard',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2281] = {'Baelish Frostbane',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[2282] = {'[PH] Orgrun Iceflow',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[2283] = {'Ravenclaw Regent',508,508,22,22,4,{[405]={{71.42,28.66}}},nil,405,nil,nil,14,nil,nil,0},
[2284] = {'Captured Farmer',86,86,4,4,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2285] = {'Count Remington Ridgewell',1753,1753,40,40,0,{[1519]={{81.56,34.06}}},nil,1519,{543},{543,4765},12,"A","House of Nobles",2},
[2286] = {'Bow Guy',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2287] = {'Crushridge Warmonger',699,699,25,26,0,{[267]={{43.92,31.62},{42.88,29.54},{42.63,31.44},{43.22,30.8},{42.14,30.13},{42.5,31.43},{42.07,30.19},{42.86,29.64},{44.16,32.6},{43.09,32.88},{42.8,31.11},{43.11,27.55},{45.23,29.88},{44.47,30.83},{44.53,33.8},{42.49,28.85},{43.27,30.04},{42.39,30.08},{42.54,30.39},{42.57,30.69},{42.84,30.4},{42.86,30.51},{42.44,30.1},{42.59,29.81},{42.8,31.08},{42.77,30.3}}},nil,267,nil,nil,45,nil,nil,0},
[2288] = {'Skracher Mudmuzzle',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2289] = {'Connor McCoy',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[2290] = {'Bertran Keldrake',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[2291] = {'Corbin Halman',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[2292] = {'Reginald Berry',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[2294] = {'Jaynice Sillestan',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[2298] = {'Dolthar Stonefoot',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[2299] = {'Borgus Stoutarm',232470,232470,85,85,1,{[46]={{72.09,65.7}}},nil,46,nil,nil,55,"A","Gryphon Master",8193},
[2302] = {'Aethalas',3874500,3874500,85,85,1,{[1657]={{56.7,47.55}}},nil,1657,nil,nil,1514,"A","Warsong Gulch Battlemaster",1048577},
[2303] = {'Lyranne Feathersong',3529,3529,55,55,0,{[618]={{49.01,40.16}}},nil,618,nil,nil,35,"AH","Food & Drink",640},
[2304] = {'Captain Ironhill',1057,1057,32,32,0,nil,nil,0,nil,nil,88,"A",nil,128},
[2305] = {'Foreman Bonds',852,852,30,30,0,nil,nil,0,nil,nil,88,"A",nil,0},
[2306] = {'Baron Vardus',1239,1239,40,40,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2307] = {'Caretaker Caice',0,0,5,5,0,{[6454]={{45.92,80.48}}},nil,6454,{24960,25089},{24960,28652},68,"H",nil,2},
[2308] = {'Andrew Brownell',1753,1753,40,40,0,{[1497]={{74.05,33.31}}},nil,1497,nil,{3341},68,"H",nil,0},
[2309] = {'Thomas Arlento',102,102,5,5,0,{[85]={{62.12,52.13}}},nil,85,nil,nil,68,"H",nil,0},
[2310] = {'Jamie Nore',102,102,5,5,0,{[85]={{61.02,49.82}}},nil,85,nil,nil,68,"H",nil,0},
[2311] = {'Doreen Beltis',102,102,5,5,0,{[85]={{60.83,53.74}}},nil,85,nil,nil,68,"H",nil,0},
[2314] = {'Sahvan Bloodshadow',102,102,5,5,0,{[85]={{58.34,50.58}}},{[85]={{{59.62,51.68},{59.89,51.86},{60.3,52.16},{60.43,52.4},{60.41,52.93},{60.33,53.07},{60.22,53.26},{60.35,53.04},{60.43,52.92},{60.73,52.94},{61.04,52.88},{61.02,52.49},{60.75,52.14},{60.23,51.78},{59.8,51.67},{59.51,51.7},{58.56,51.54},{58.4,51.47},{58.29,50.71},{58.31,49.9},{58.34,49.37},{58.33,48.84},{58.34,48.69},{58.32,50.02},{58.37,51.36},{58.37,51.45},{58.45,51.52},{59.32,51.58},{60.32,52.14},{61.08,52.86},{61.34,52.83},{61.27,52.91},{61.13,52.88},{61.04,52.63},{60.79,52.46},{60.28,52.2},{59.97,52.34},{59.85,52.15}}}},85,nil,nil,68,"H",nil,0},
[2315] = {'Maquell Ebonwood',0,0,5,5,0,{[6454]={{47.18,58.84}}},nil,6454,nil,nil,68,"H",nil,0},
[2316] = {'Gol\'dir',713,713,25,25,0,{[267]={{58.14,26.45}}},nil,267,nil,{503},29,"H",nil,0},
[2317] = {'Elysa',713,713,25,25,0,nil,nil,0,nil,{507},35,"AH",nil,0},
[2318] = {'Argus Shadow Mage',607,607,24,24,0,{[267]={{55.5,16.75},{54.22,14.82},{52.76,11.29},{57.78,22.79},{56.65,24.75},{49.47,9.4},{55.02,25.98},{58.63,24.58},{54.35,14.81},{55.33,16.6},{52.85,11.42},{57.22,25.84},{49.41,9.23},{54.19,15.13}}},nil,267,nil,nil,16,nil,nil,0},
[2319] = {'Syndicate Wizard',618,618,24,25,0,{[267]={{57.83,23.12},{57.77,24.77},{57.26,24.37},{57.22,24.72},{57.27,24.21}}},nil,267,nil,nil,87,nil,nil,0},
[2320] = {'Nagaz',1753,1753,40,40,0,nil,nil,0,nil,nil,74,nil,nil,0},
[2321] = {'Foreststrider Fledgling',124,124,12,12,0,{[148]={{40.66,48.61},{40.68,48.6}}},nil,148,nil,nil,189,"AH",nil,0},
[2322] = {'Foreststrider',300,356,14,16,0,nil,nil,0,nil,nil,189,"AH",nil,0},
[2323] = {'Giant Foreststrider',386,449,17,19,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2324] = {'Blackwood Windtalker',273,300,13,14,0,nil,nil,0,nil,nil,82,nil,nil,0},
[2325] = {'Undead First Aid Trainer',25,27,1,1,0,nil,nil,0,nil,nil,21,nil,"First Aid Trainer",64},
[2326] = {'Thamner Pol',247,247,9,9,0,{[1]={{54.29,50.94}}},nil,1,nil,nil,55,"A","First Aid Trainer",81},
[2327] = {'Shaina Fuller',1342,1342,35,35,0,nil,nil,0,nil,nil,12,"A","First Aid Trainer",81},
[2329] = {'Michelle Belle',222,222,11,11,0,{[12]={{43.39,65.55}}},nil,12,nil,nil,12,"A","First Aid Trainer",81},
[2330] = {'Karlee Chaddis',713,713,25,25,0,{[1519]={{47.41,67.44},{68.08,63.38},{47.78,71.71}}},{[1519]={{{56.46,74.28},{56.11,74.63},{55.63,75.14},{55.4,75.51},{55.64,76.29},{55.52,76.63},{53.79,78.7},{53.44,78.6},{53.05,77.98},{52.25,78.05},{51.58,77.98},{50.74,78.55},{50.48,78.52},{49.44,77.9},{48.91,77.49},{47.98,77.07},{47.5,77.09},{46.6,77.74},{45.85,78.43},{44.57,79.73},{44.25,83.79},{43.54,85.17},{43.62,86.64},{44.28,87.76},{44.76,87.42},{45.01,86.76},{45.07,86.55},{44.76,86.37},{45.03,86.61},{44.96,86.92},{44.62,87.76},{44.39,87.77},{43.79,87.11},{43.57,86.57},{43.54,85.3},{43.6,84.96},{44.29,83.05},{44.62,79.84},{46.18,78.14},{46.7,77.59},{46.16,76.12},{45.44,74.17},{45.59,73.64},{45.01,72.41},{44.3,71},{44.33,70.73},{44.93,69.77},{45.23,69.63},{46.83,67.46},{47.71,66.55},{47.78,63.99},{48.15,63.55},{48.8,62.79},{49.57,61.85},{50.03,61.84},{51.13,63.02},{52.34,63.09},{53.36,62.27},{54.12,62.67},{55.07,63.57},{55.91,62.94},{57,61.94},{57.97,60.71},{56.3,57.48},{55.08,57.36},{53.84,55.12},{53.84,54.96},{55.35,52.69},{55.61,51.47},{56.7,50.41},{57.85,51.69},{59.01,50.58},{60.38,48.8},{59.44,46.68},{60.07,45.98},{61.01,45.04},{61.66,44.42},{62.13,44.97},{63.75,48.47},{63.74,49.02},{65.42,50.76},{66.89,50.81},{67.88,50.28},{68.6,51.58},{69.49,53.01},{69.37,53.61},{67.33,57.12},{67.34,58.51},{69.24,61.97},{68.95,62.28},{67.1,64.71},{66.58,64.68},{65.98,64.08},{64.16,66.83},{65.22,69.04},{62.88,72.24},{61.11,73.87},{60.1,71.56},{57.33,73.51}}}},1519,nil,nil,12,"A",nil,0},
[2331] = {'Paige Chaddis',42,42,1,1,0,{[1519]={{47.45,67.35},{68.16,63.51},{47.72,71.56}}},nil,1519,nil,nil,12,"A",nil,0},
[2332] = {'Valdred Moray',531,531,21,21,0,nil,nil,0,nil,nil,1802,"A",nil,0},
[2333] = {'Henchman Valik',990,1003,30,30,0,nil,nil,0,nil,{535},1801,"H",nil,0},
[2334] = {'Event Generator 001',166,166,5,5,0,{[1519]={{67.48,72.11},{63.12,35.71},{63.14,35.59},{48.46,82.76}},[3487]={{82.47,42.97},{59.61,20},{58.61,28.19}},[3523]={{43.14,34.88}}},nil,1519,nil,nil,12,"A",nil,0},
[2335] = {'Magistrate Burnside',774,774,30,30,0,nil,nil,0,nil,nil,88,"A",nil,0},
[2336] = {'Dark Strand Fanatic',356,386,16,17,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2337] = {'Dark Strand Voidcaller',702,739,28,29,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2338] = {'Twilight Disciple',250,350,16,17,0,nil,nil,0,nil,nil,74,nil,nil,0},
[2339] = {'Twilight Thug',417,417,17,18,0,nil,nil,0,nil,nil,74,nil,nil,0},
[2344] = {'Dun Garok Mountaineer',732,773,28,29,0,{[267]={{63.84,87.12},{62.32,84.61},{64.01,86.87},{62.97,86.15},{63.93,85.95},{61.44,85.7},{63.61,86.38},{62.4,84.14},{63.59,85.36},{63.19,85.14},{63.23,86.88},{61.87,85.55},{62.88,86.27},{63.75,86.72},{63.48,85.87},{62.62,85.08},{62.8,85.54},{61.93,84.76},{63.22,85.72},{63.85,85.75},{61.47,84.45},{62.16,82.71},{63.38,85.58},{63.16,85.08}}},nil,267,nil,nil,88,"A",nil,0},
[2345] = {'Dun Garok Rifleman',905,955,29,30,0,{[267]={{63.15,86.07},{62.52,85.82},{63.9,86.15},{63.16,85.08},{63.15,86.13},{63.02,82.29},{62.15,83.72},{62.87,84.78},{63.59,86.75},{62.66,84.4},{63.62,85.83},{62.25,84.98},{62.19,85.6},{63.22,86.9},{62.94,83.54},{62.63,83.31},{62.8,85.54},{63.19,85.14},{62.62,85.08},{61.47,84.45}}},nil,267,nil,nil,88,"A",nil,0},
[2346] = {'Dun Garok Priest',773,811,29,30,0,{[267]={{63.55,86.04},{62.64,83.22},{63.35,86.3},{63.93,86.44},{62.97,85.34},{63.79,86.47}}},nil,267,nil,nil,88,"A",nil,0},
[2347] = {'Wild Gryphon',1753,1753,40,40,0,nil,nil,0,nil,nil,15,"AH",nil,0},
[2348] = {'Elder Moss Creeper',787,840,26,27,0,nil,nil,0,nil,nil,22,nil,nil,0},
[2349] = {'Domesticated Creeper',458,458,19,20,0,{[267]={{32.34,68.77},{31.66,70.52},{29.08,68.27},{30.95,69.16},{28.21,68.3},{32.23,67.3},{27.88,68.45},{29.43,68.64},{31.58,70.57},{31.17,69.31},{30.13,69.61}}},nil,267,nil,nil,2213,"H",nil,0},
[2350] = {'Forest Creeper',531,531,20,21,0,{[267]={{63.9,37.23},{37.42,76.41},{31.58,61.51},{70.25,36.35},{70.05,32.65},{70.7,31.32},{68.1,28.69},{69.56,37.43},{69.74,27.58},{68.38,38.76},{69.92,36.23},{67.76,29.1},{70.75,32.23},{68.66,25.29},{67.77,27.02},{60.56,42.17},{60.56,40.72},{60.58,42.47},{61.56,39.7},{62.55,38.49},{63.87,36.87},{60.1,43.65}},[2367]={{-1,-1}}},nil,267,nil,nil,22,nil,nil,0},
[2351] = {'Blighted Bear',677,731,21,22,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2352] = {'Innkeeper Anderson',1003,1003,30,30,0,nil,nil,0,nil,nil,12,"A","Innkeeper",66177},
[2354] = {'Vicious Gray Bear',742,742,22,23,0,{[2367]={{-1,-1}}},nil,2367,nil,nil,44,nil,nil,0},
[2356] = {'Elder Gray Bear',606,606,19,20,0,{[267]={{40.62,76.15},{38.18,75.93}}},nil,267,nil,nil,2030,nil,nil,0},
[2357] = {'Merideth Carlson',1163,1163,32,32,0,nil,nil,0,nil,{7645},12,"A","Horse Breeder",131},
[2358] = {'Dalaran Summoner',350,350,16,17,0,{[267]={{32.37,41.85},{31.94,42.15},{29.95,42.46},{30.79,42.53},{31.33,42.42},{29.03,42},{29.49,42.28},{27.33,39.48},{27.59,41.62},{27.94,40.81},{29.05,32.16},{31.31,31.75},{33.17,33.26},{30.68,31.64},{32.74,32.7},{34.12,38.43},{34.22,37.53},{33.74,34.37},{34.01,35.26},{33.93,39.23},{33.41,40.51},{32.95,41.25}}},nil,267,nil,nil,76,"AH",nil,0},
[2359] = {'Elemental Slave',1221,1279,33,34,0,nil,nil,0,nil,nil,76,"AH",nil,0},
[2360] = {'Hillsbrad Farmhand',573,617,22,23,0,nil,nil,0,nil,nil,123,"A",nil,0},
[2361] = {'Tamara Armstrong',328,328,15,15,0,nil,nil,0,nil,nil,11,"A",nil,0},
[2362] = {'Hemmit Armstrong',328,328,15,15,0,nil,nil,0,nil,nil,11,"A",nil,0},
[2363] = {'Apprentice Honeywell',950,950,29,29,0,nil,nil,0,nil,nil,11,"A",nil,0},
[2364] = {'Neema',1221,1221,33,33,0,nil,nil,0,nil,nil,11,"A","Waitress",640},
[2365] = {'Bront Coldcleave',1678,1678,39,39,0,nil,nil,0,nil,nil,12,"A","Butcher",640},
[2366] = {'Barkeep Kelly',1753,1753,40,40,0,nil,nil,0,nil,nil,12,"A","Bartender",640},
[2367] = {'Donald Rabonne',1107,1107,31,31,0,nil,nil,0,nil,nil,12,"A","Fishing Trainer",81},
[2368] = {'Daggerspine Shorestalker',547,547,21,22,0,{[267]={{60.35,90.67},{60.22,90.31},{56.81,83.54},{59.87,90.01},{59.75,88.36},{56.03,83.92},{58.93,86.22},{58.49,85.16},{58.51,84.43},{55.62,83.17},{60.15,85.55},{56.79,85.41},{59.69,89.96},{57.1,84.05},{56.85,83.82},{59.55,87.2},{59.78,88.32},{59.64,87.54},{56.73,83.55},{58.39,84.19},{56.78,85.19},{56.8,83.52},{56.11,84.07},{56.88,87.48},{60.14,85.73},{58.91,86.42},{58.39,85.12},{59,86.34}}},nil,267,nil,nil,74,nil,nil,0},
[2369] = {'Daggerspine Shorehunter',618,618,22,22,0,{[267]={{51.87,75.58},{50.72,78.15},{49.93,77.04},{52.64,77.16},{50.62,76.22},{51.55,76.93},{51.57,74.75},{54.65,84.27}}},nil,267,nil,nil,74,nil,nil,0},
[2370] = {'Daggerspine Screamer',487,487,21,22,0,{[267]={{55.59,85.31},{57.58,84.27},{58.3,83.84},{60.02,86.29},{58.61,90.45},{59.4,85.7},{58.18,89.3},{59.72,85.78},{58.08,84},{57.59,88.27},{57.29,88.01},{59.72,85.71},{58.11,84.02},{59.13,86.58},{55.8,85.63},{56.1,86.59},{57.33,84.29}}},nil,267,nil,nil,74,nil,nil,0},
[2371] = {'Daggerspine Siren',510,510,21,21,0,{[267]={{52.44,73.78},{52.48,75.43},{52.01,74.22},{58.48,87.1},{53.4,84.4}}},nil,267,nil,nil,74,nil,nil,0},
[2372] = {'Mudsnout Gnoll',590,590,21,22,0,{[267]={{57.96,76.14},{58.89,74.06},{58.9,74.92},{58.24,74.94},{57.22,74.6},{57.8,74.64},{58.1,76.15},{58.26,73.08},{56.92,74.79},{57.27,74.05},{57.67,72.85},{57.78,72.41}}},nil,267,{28355},nil,95,nil,nil,2},
[2373] = {'Mudsnout Shaman',486,486,22,22,0,{[267]={{57.27,75.18},{59.19,72.91},{58.36,72.49},{59.72,73.57},{57.54,75.28},{57.48,73.78},{58.27,73.99},{58.04,72.33}}},nil,267,nil,nil,95,nil,nil,0},
[2374] = {'Torn Fin Muckdweller',438,438,18,19,0,{[267]={{30.07,77.13},{29.52,76.09},{32.87,83.17},{31.59,81.06},{31.35,75.61},{33.32,79.7},{34.47,81.06},{32.79,80.21},{34.83,81.87},{35.7,81.79},{37.23,81.11},{38.6,79.32},{37.87,79.43},{35.93,81.99},{32.33,76.9},{32.2,75.27},{32.34,75.39},{31.56,75.99},{32.69,76.03},{33.02,83.12},{33.67,82.07}}},nil,267,nil,nil,18,nil,nil,0},
[2375] = {'Torn Fin Coastrunner',471,471,19,20,0,{[267]={{33.55,81.95},{30.9,75.88},{30.79,78.1},{30.96,80.01},{38.45,81.3},{39.29,82.3},{37.02,83.18},{32.17,82.28},{34.43,83.41},{31.65,78.83},{37.88,82.29},{32.4,80.25},{31.23,75.56},{32.61,78.22},{32.92,81.21},{32.28,79.69},{33.87,80.6},{33.02,79.81},{35.71,81.25},{34.57,81.3},{34.24,81.01},{36.06,81.59},{36.59,82.05},{36.78,81.28},{37.51,81.28},{37.69,80.63},{39.12,80.6},{37.83,81.08},{37.61,80.93},{38.02,79.25},{32.64,79.03},{35.55,83.39},{31.81,77.3},{32.17,76.32},{34.3,83.17},{39.05,82.39},{32.22,82.27},{35.61,82.75},{36.85,83.41},{34.92,82.12}}},nil,267,nil,nil,18,nil,nil,0},
[2376] = {'Torn Fin Oracle',417,417,19,19,0,{[267]={{45.49,78.54},{45.34,77.84},{44.26,79.18},{40.72,76.91},{43.16,78.07},{41.1,79.14},{47.29,78.28},{46.54,74.84},{46.45,75.28},{45.3,80.08},{40.15,79.03},{43.02,78.64},{46.83,79.02},{45.94,77.08},{41.18,81.14},{39.84,78.59},{40.34,82.02},{48.01,76.91},{42.91,79.93},{39.94,77.33},{40.54,82.86}}},nil,267,nil,nil,18,nil,nil,0},
[2377] = {'Torn Fin Tidehunter',444,444,19,19,0,{[267]={{45.76,77.7},{46.72,77.08},{43.8,81.17},{44.49,79.53},{44.38,78.33},{45.63,78.03},{45.22,77.04},{47.56,75.73},{43.07,79.03},{42.88,78.9},{48.74,77.88},{40.31,78.97},{46.41,75.45},{39.93,79.27},{39.15,78.17},{45.41,77.4},{39.82,79.83},{42.56,81.14},{46.19,78.49},{42.36,79.16},{40.68,79.6},{45.02,77.55},{42.6,78.6},{41.42,80.27},{48.18,75.83},{48.3,75.76}}},nil,267,nil,nil,18,nil,nil,0},
[2378] = {'Kundric Zanden',1279,1279,34,34,0,nil,nil,0,nil,nil,11,"A","Town Historian",0},
[2379] = {'Caretaker Smithers',1342,1342,35,35,0,nil,nil,0,nil,nil,12,"A",nil,0},
[2380] = {'Nandar Branson',1279,1279,34,34,0,nil,nil,0,nil,nil,12,"A","Alchemy Supplies",128},
[2381] = {'Micha Yance',1753,1753,40,40,0,nil,nil,0,nil,nil,12,"A","Trade Goods",128},
[2382] = {'Darren Malvew',1003,1003,30,30,0,nil,nil,0,nil,{564},12,"A","Stablehand",0},
[2383] = {'Lindea Rabonne',950,950,29,29,0,nil,nil,0,nil,nil,12,"A","Fishing Supplies",128},
[2384] = {'Starving Mountain Lion',620,664,23,24,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2385] = {'Foothill Stalker',562,562,22,23,0,{[267]={{44.64,59.12},{41.73,62.61},{50.37,53.41},{50.3,54.73},{45.97,58.68},{44.65,58.87},{51.08,54.89},{50.65,53.61},{46.24,58.78},{41.24,54.93},{42.89,56.93},{44.4,58.38},{43.01,57.93},{47.67,54.54},{44.89,58.35},{44.33,58.41},{41.47,56.69},{42.77,57.96},{48.54,56.26},{43.36,57.41},{50.15,55.4},{41.82,61.43},{51.15,54.35},{51.21,54.25}},[2367]={{-1,-1}}},nil,267,nil,nil,1711,nil,nil,0},
[2386] = {'Alliance Guard',2310,2310,45,45,0,{[267]={{45.28,45.25},{44.64,46.32}}},nil,267,nil,nil,1216,"A",nil,0},
[2387] = {'Hillsbrad Councilman',590,628,25,26,0,nil,nil,0,nil,nil,123,"A",nil,0},
[2388] = {'Innkeeper Shay',1003,1003,30,30,0,{[267]={{57.95,47.3}}},nil,267,nil,nil,68,"H","Innkeeper",66177},
[2389] = {'Zarise',232470,232470,85,85,1,{[267]={{56.06,46.08}}},nil,267,nil,nil,68,"H","Bat Handler",8193},
[2390] = {'Aranae Venomblood',950,950,29,29,0,{[267]={{57.19,47.62}}},nil,267,nil,nil,68,"H","Herbalism Trainer",80},
[2391] = {'Serge Hinott',1163,1163,32,32,0,{[267]={{49.1,66.36}}},nil,267,{28324,28325,28330},{2479,2480,28251,28324,28325,28329,28330},68,"H","Alchemy Trainer",83},
[2392] = {'Delia Verana',1163,1163,32,32,0,{[267]={{58.24,47.57}}},nil,267,nil,nil,71,"H",nil,0},
[2393] = {'Christoph Jeffcoat',1163,1163,32,32,0,{[267]={{57.51,47.77}}},nil,267,nil,{7321},68,"H","Tradesman",129},
[2394] = {'Mallen Swain',1163,1163,32,32,0,{[267]={{58.06,47.93}}},nil,267,nil,nil,68,"H","Tailoring Supplies",128},
[2395] = {'Vinna Wayne',1163,1163,32,32,0,{[267]={{57.26,47.64}}},nil,267,nil,nil,68,"H",nil,0},
[2396] = {'Hans Zandin',1163,1163,32,32,0,{[267]={{56.71,49.07}}},{[267]={{{61.31,24.17},{61.18,24.94},{61.65,25.29},{61.72,24.39},{61.58,23.82},{61.3,23.21},{60.77,23.04},{60.67,23.31},{61.09,23.62}}}},267,nil,nil,71,"H",nil,0},
[2397] = {'Derak Nightfall',1163,1163,32,32,0,{[267]={{57.7,45.21}}},nil,267,{28489},{28489},68,"H","Cook",131},
[2398] = {'Tara Coldgaze',1163,1163,32,32,0,{[267]={{58.17,45.83}}},nil,267,nil,nil,71,"H",nil,0},
[2399] = {'Daryl Stack',2495,2495,45,45,0,{[267]={{58.1,47.97}}},nil,267,nil,nil,68,"H","Tailoring Trainer",81},
[2400] = {'Craig Hewitt',1163,1163,32,32,0,{[267]={{56.64,49.62}}},nil,267,nil,nil,71,"H",nil,0},
[2401] = {'Kayren Soothallow',1003,1003,30,30,0,{[267]={{56.71,47.36}}},nil,267,nil,nil,68,"H","General Goods",640},
[2402] = {'Shara Blazen',1163,1163,32,32,0,{[267]={{56.58,47.41}}},nil,267,nil,nil,68,"H",nil,0},
[2403] = {'Farmer Getz',664,664,24,24,0,nil,nil,0,nil,nil,88,"A",nil,0},
[2404] = {'Blacksmith Verringtan',787,787,26,26,0,nil,nil,0,nil,nil,88,"A",nil,0},
[2405] = {'Tarren Mill Deathguard',3696,3696,45,45,0,nil,nil,0,nil,nil,71,"H",nil,0},
[2406] = {'Mountain Lion',1163,1221,32,33,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2407] = {'Hulking Mountain Lion',1200,1279,33,34,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2408] = {'Snapjaw',618,618,22,23,0,{[130]={{80.31,34.3},{79.44,35.22},{77.66,36.13},{81.05,32.92}},[267]={{52.85,70.93},{38.69,21.47},{38.5,21.82},{38.96,20.59},{33.41,26.4},{32.03,28.77},{32.23,27.73},{31.52,28.75},{32.84,27.61},{36.18,24.59},{38.28,22.68},{36.99,23.84},{38.07,22.78},{68.64,31.52},{68.29,32.99},{67.27,34.87},{64.21,37.91},{64.81,36.93},{63.69,38.84},{65.87,36.03},{62.29,41.4},{61.59,42.51},{71.82,27.74},{66.35,35.97},{69.69,29.71},{73.24,27.02},{68.12,32.97},{70.94,28.83},{67.8,33.81},{69.12,30.89},{74.27,26.03}},[2367]={{-1,-1}}},nil,267,nil,nil,7,"AH",nil,0},
[2409] = {'Felicia Maline',232470,232470,85,85,1,{[10]={{77.49,44.29}}},nil,10,nil,nil,12,"A","Gryphon Master",8193},
[2410] = {'Magus Wordeen Voidglare',1981,1981,42,42,0,{[267]={{57.11,45.13}}},nil,267,nil,{544,545},68,"H",nil,0},
[2411] = {'Ricter',1221,1221,33,33,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2412] = {'Alina',1221,1221,33,33,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2413] = {'Dermot',1279,1279,34,34,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2414] = {'Kegan Darkmar',1342,1342,35,35,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2415] = {'Warden Belamoore',1075,1075,36,36,0,nil,nil,0,nil,nil,76,"AH",nil,0},
[2416] = {'Crushridge Plunderer',699,699,26,26,0,{[267]={{43.33,30.62},{43.33,30.86}}},nil,267,nil,nil,45,nil,nil,0},
[2417] = {'Grel\'borg the Miser',1220,1220,25,25,0,{[267]={{44.3,29.19}}},{[36]={{{35.55,54.46},{35.29,54.41},{35.21,54.16},{35.32,54.07},{35.42,53.99},{35.54,53.89},{35.62,53.83},{35.77,53.71},{35.96,54.24},{36.25,55.05},{36.45,54.98},{36.66,54.82},{36.46,54.26},{36.32,53.88},{36.55,53.59},{37.28,52.95},{37.89,52.43},{38.46,52.19},{38.81,51.52},{39.19,51.27},{39.39,50.57},{39.68,49.52},{39.99,48.81},{40.15,47.77},{40.31,47.1},{40.56,46.68},{40.77,46.6},{40.82,46.23},{40.5,46.37},{40.32,47.22},{40.07,48.16},{39.83,49.1},{39.51,49.94},{39.3,50.5},{39.11,51.21},{38.94,51.48},{38.56,51.94},{38.16,52.43},{37.72,52.67},{37.37,52.85},{36.92,53.18},{36.26,53.73},{36.18,53.43},{36.1,53.18},{35.95,52.68},{35.55,52.93},{35.72,53.57},{35.78,53.73},{35.62,53.85},{35.48,53.96},{35.35,54.06},{35.21,54.17},{35.29,54.41}}}},267,nil,nil,45,nil,nil,0},
[2418] = {'Deathguard Samsa',2114,2114,32,32,0,{[267]={{57.19,45.52}}},nil,267,{28485},{546,28485},68,"H",nil,2},
[2419] = {'Deathguard Humbert',2114,2114,32,32,0,{[267]={{57.16,45.53}}},nil,267,{28487},{547,28487},68,"H",nil,2},
[2420] = {'Targ',1500,1500,25,25,0,{[267]={{44.64,29.67},{44.71,29.83}}},nil,267,nil,nil,45,nil,nil,0},
[2421] = {'Muckrake',1398,1398,26,26,0,{[267]={{44.19,26.39},{44.21,26.38}}},nil,267,nil,nil,45,nil,nil,0},
[2422] = {'Glommus',1398,1398,25,25,0,{[267]={{44.68,23.5},{44.71,23.51}}},nil,267,nil,nil,45,nil,nil,0},
[2423] = {'Lord Aliden Perenolde',1522,1522,41,41,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2424] = {'Guild Banker',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Guild Banker",0},
[2425] = {'Varimathras',684400,684400,73,73,3,nil,nil,0,nil,{1048,1978,5725},68,"H",nil,1},
[2427] = {'Jailor Eston',664,664,24,24,0,nil,nil,0,nil,nil,472,nil,nil,0},
[2428] = {'Jailor Marlgen',664,664,24,24,0,nil,{[267]={{{79.68,40.55},{79.8,40.65},{80.06,40.52},{80.21,40.04},{80.18,39.66},{80.13,39.51},{80.01,39.38},{79.84,39.19},{79.82,39.13},{79.52,39.03},{79.37,39.3},{79.38,39.67},{79.36,39.79},{79.23,40.11},{79.28,40.6},{79.48,40.61}}}},0,nil,nil,472,nil,nil,0},
[2429] = {'Novice Thaivand',1003,1003,30,30,0,{[267]={{57.16,45.13}}},nil,267,nil,{552},68,"H",nil,0},
[2430] = {'Chef Jessen',1342,1342,35,35,0,nil,nil,0,nil,{555},12,"A",nil,0},
[2431] = {'Jailor Borhuin',1536,1536,37,37,0,nil,nil,0,nil,nil,87,nil,nil,0},
[2432] = {'Darla Harris',10572,10572,65,65,1,nil,nil,0,nil,nil,12,"A","Gryphon Master",8193},
[2433] = {'Helcular\'s Remains',4278,4278,44,44,1,nil,nil,0,nil,nil,1801,"H",nil,0},
[2434] = {'Shadowy Assassin',1536,1604,37,38,0,nil,nil,0,nil,nil,108,"AH",nil,0},
[2435] = {'Southshore Crier',1163,1163,32,32,0,nil,nil,0,nil,nil,96,"A",nil,0},
[2436] = {'Farmer Kent',713,713,25,25,0,nil,{[267]={{{53.5,58.21},{53.19,57.74},{52.84,57.17},{52.53,56.86},{52.24,56.81},{52.04,56.97},{51.84,57.18},{51.73,57.16},{51.65,56.93},{51.56,56.4},{51.37,56.24},{50.97,56.33},{50.59,56.51},{50.5,56.74},{50.45,57.14},{50.16,57.71},{49.86,57.99},{49.76,57.93},{49.73,57.63},{49.75,57.17},{50,56.54},{50.26,55.8},{50.42,55.24},{50.44,54.61},{50.28,54.37},{49.98,54.4},{49.76,54.51},{49.94,54.41},{50.25,54.36},{50.36,54.62},{50.27,55.19},{50.13,55.7},{49.85,56.39},{49.61,57.12},{49.61,57.46},{49.41,57.68},{49.25,57.82},{49.09,57.95},{49.37,57.7},{49.59,57.77},{49.66,58.04},{49.92,58.79},{50.2,59.69},{50.2,60.54},{50.13,61.59},{50.2,60.58},{50.2,59.74},{49.95,58.84},{49.8,58.28},{49.93,58.09},{50.19,57.75},{50.43,57.19},{50.51,56.66},{50.98,56.43},{51.36,56.31},{51.5,56.51},{51.59,56.94},{51.7,57.11},{51.98,57},{52.18,56.84},{52.48,56.83},{52.81,57.12},{53.15,57.68}}}},0,nil,nil,96,"A",nil,0},
[2437] = {'Keeper Bel\'varil',1279,1279,34,34,0,{[267]={{56.99,45.72}}},nil,267,{28484},{556,557,28484},68,"H",nil,2},
[2438] = {'Bartolo Ginsetti',1163,1163,32,32,0,nil,nil,0,nil,{565},12,"A",nil,0},
[2439] = {'Major Samuelson',193488,193488,84,84,0,{[1519]={{85.12,31.03}}},nil,1519,{26997},{563,26977},12,"A","Stormwind City Guard",3},
[2440] = {'Drunken Footpad',1163,1221,32,33,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2442] = {'Cow',100,100,5,5,0,{[11]={{20.39,68.88},{19.32,69.18},{21,69.17}},[12]={{35.45,62.96},{37.47,62.81},{35.39,60.22},{31.58,54.92},{31.06,58.16},{32.81,68.05},{33.31,74.93},{34.44,64.03},{38,63.83},{31.93,77.64},{35.36,60.13},{30.72,58.54},{28.9,70.24},{32.59,68.36},{29.24,74.09},{33.51,75.46},{22.81,76.45},{27.21,75.83},{32.03,76.75},{28.65,75.01},{33.32,74.58},{22.49,77.62},{37.68,62.98},{27.28,75.45},{32.18,77.53},{38.83,74.33},{56.63,74.42},{59.78,69.62},{53.1,70.06},{43.82,52.88},{43.92,52.56},{42.09,55.6},{44.82,49.84},{56.95,71.49},{47.12,58.92},{61.63,71.34},{45.73,55.83},{42.64,63.55},{77.2,39.22},{60.41,75.58},{80.17,52.79},{69.03,60.76},{59.74,69.73},{67.18,44.52},{70.56,40.04},{67.2,66.37},{74.75,67.1},{70.8,62.06},{69.8,72.65},{62.24,72.09},{62.41,70.28},{71.77,67.7},{77.63,61.78},{80.79,58.12},{76.66,39.73},{70.68,40.58},{81.53,84.39},{79.88,52.32},{86.07,64.81},{88.56,81.29},{89.36,76.04},{87.17,83.32},{80,78.27},{67.1,44.88},{70.35,39.85},{74.74,68.16},{86.94,70.8},{86.78,72.03},{87.61,65.15},{80.97,64.19},{81.76,84.01},{79.61,77.29},{73.42,80.77},{78.27,81.14},{53.24,75.87},{60.3,75.34},{55.93,75.03},{73.23,80.33},{46.41,76.48},{69.48,72.22},{61.93,71.81},{65.74,78.88},{62.32,79.26},{56.48,70.67},{62.14,70.71},{45.76,86.69},{41.07,80},{46.51,76.39},{41,79.94},{33.47,75.02},{32.07,77.27},{34.17,75.52},{61.99,79.73},{32.22,76.95},{45.43,86.99},{81.04,84.41},{88.59,81.34},{89.48,76.95},{86.59,83.97},{88.65,81.44},{87.29,84.06}},[40]={{59.47,15.23},{59.71,24.03},{59.82,15.22}},[44]={{46.42,66.83},{19.19,43.57}},[45]={{26.31,30.02},{26.51,29.04},{25.91,28.32},{25.77,30.25},{26.42,29.19},{25.8,29.3}},[267]={{51.39,70.82},{51.83,70.36}},[1519]={{52.27,5.1},{52.75,3.73},{52.05,4.03},{51.96,2.94},{52.52,2.55}}},nil,12,nil,nil,190,"AH",nil,0},
[2447] = {'Narillasanz',12121,12121,44,44,2,{[267]={{64.38,37.05}}},{[36]={{{73.66,65.44},{73.24,65.89},{72.78,66.38},{72.18,66.87},{71.63,67.65}}},[267]={{{71.11,8.37},{70.7,9.05},{70.08,9.88},{69.55,10.52},{69.04,10.92},{68.52,10.92},{67.96,10.17},{67.75,9.81},{67.48,9.37},{67.25,9.05},{67.14,8.86},{66.87,8.39},{66.51,7.86},{66.39,6.94},{66.26,6.04},{66.07,4.73},{65.93,4.28},{65.58,3.7}}}},267,nil,nil,60,nil,nil,0},
[2448] = {'Clerk Horrace Whitesteed',787,787,26,26,0,nil,nil,0,nil,nil,88,"A",nil,0},
[2449] = {'Citizen Wilkes',713,713,25,25,0,nil,{[267]={{{32.53,39.81},{32.54,39.32},{32.54,39.32},{32.56,38.34},{32.65,37.7},{32.68,37.05},{32.68,36.52},{32.56,35.76},{32.56,35.76},{32.67,36.37},{32.69,37.05},{32.59,37.98},{32.56,38.63},{32.54,38.97},{32.55,39.85},{32.85,39.7},{32.91,39.65},{33.56,39},{34.13,38.65},{34.13,38.65},{35,38.68},{35.44,38.71},{35.9,38.89},{36.15,39.17},{36.42,39.45},{36.19,39.2},{35.83,38.85},{35.45,38.71},{35.01,38.67},{34.36,38.66},{33.93,38.69},{33.56,39.08},{33.09,39.51},{32.69,39.99}}}},0,nil,nil,88,"A",nil,0},
[2450] = {'Miner Hackett',950,950,29,29,0,nil,nil,0,nil,nil,88,"A",nil,0},
[2451] = {'Farmer Kalaba',713,713,25,25,0,nil,{[267]={{{35.9,46.58},{35.95,46.27},{35.98,46},{36.02,45.51},{35.9,45.21},{35.62,44.76},{35.47,44.7},{35.23,45.23},{34.98,45.58},{34.69,45.88},{34.47,46.23},{34.24,46.59},{34.05,46.94},{34.1,47.14},{34.33,47.07},{34.58,47.54},{34.85,47.55},{35.05,47.71},{35.33,47.54},{35.57,47.43},{35.82,46.97},{36.04,46.74}}}},0,nil,nil,88,"A",nil,0},
[2452] = {'Skhowl',1600,1600,27,27,4,{[267]={{45.74,35.58},{40.31,29.44},{44.89,22.32},{43.2,39.09}}},{[36]={{{31.44,51.65},{31.87,51.17},{31.94,50.39},{31.95,49.62},{31.88,49.29},{31.61,48.9},{31.13,49.07},{30.29,49.48},{29.99,50.09},{29.6,51},{29.28,51.86},{29.28,51.86},{28.88,53.03},{28.44,54.95},{28.7,55.85},{28.92,56.63},{29.12,57.17},{29.02,58.36},{28.95,59.08},{28.93,59.92},{28.87,60.69},{28.93,61.77},{29.45,62.63},{29.7,63.3},{30.18,64.05},{30.3,64.47},{30.65,64.98},{30.14,64.58},{30.14,63.95},{29.86,63.58},{29.39,63.17},{29.22,62.12},{29.05,61.06},{28.97,60.24},{28.98,59.47},{29,58.49},{29,57.23},{28.76,56.56},{28.69,56.11},{28.54,54.94},{28.67,53.84},{29.24,53.34},{29.45,52.49},{29.94,52.28},{30.79,51.93},{31.14,52.06}}}},267,nil,nil,16,nil,nil,0},
[2453] = {'Lo\'Grosh',1266,1266,27,27,4,{[267]={{53.06,25.98},{49.34,17.97},{49.36,18.21}}},{[36]={{{52.1,47.32},{52.39,47.56},{52.82,47.66},{53.13,47.85},{53.36,48.21},{53.55,48.87},{53.9,49.47},{53.6,48.95},{53.42,48.44},{53.33,48.16},{52.99,47.75},{52.85,47.46},{52.76,46.85},{52.51,46.42},{52.23,46.53},{52.09,46.93}}}},267,nil,nil,45,nil,nil,0},
[2454] = {'Skeletal Fiend (Enraged Form)',300,400,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2455] = {'Olivia Burnside',5544,5544,45,45,0,{[1519]={{62.55,79.23}}},nil,1519,nil,nil,12,"A","Banker",131073},
[2456] = {'Newton Burnside',5544,5544,45,45,0,{[1519]={{62.37,78.78}}},nil,1519,nil,nil,12,"A","Banker",131073},
[2457] = {'John Burnside',5544,5544,45,45,0,{[1519]={{62.22,78.32}}},nil,1519,nil,nil,12,"A","Banker",131073},
[2458] = {'Randolph Montague',5544,5544,45,45,0,{[1497]={{65.93,43.43}}},nil,1497,nil,nil,68,"H","Banker",131072},
[2459] = {'Mortimer Montague',5544,5544,45,45,0,{[1497]={{66.41,44.06}}},nil,1497,nil,nil,68,"H","Banker",131072},
[2460] = {'Barnum Stonemantle',5544,5544,45,45,0,{[1537]={{34.97,58.41}}},nil,1537,nil,nil,55,"A","Banker",131072},
[2461] = {'Bailey Stonemantle',5544,5544,45,45,0,{[1537]={{35.92,60.14}}},nil,1537,nil,nil,55,"A","Banker",131072},
[2462] = {'Flesh Eating Worm',30,30,23,23,0,{[10]={{17.43,33.28},{15.59,37.44},{17.9,35.14},{17.52,35.88},{15.96,34.2},{17.33,34.82},{17.27,35.69},{17.27,35.26},{17,35.06},{16.8,35.41},{16.48,34.67},{13.97,32.69},{13.26,32.86},{13.38,34.46},{13.7,34.55},{14.34,33.39},{14.24,36.97},{14.28,36.05},{14.64,36.23},{14.52,36.77},{14.99,36.4},{12.97,35.56},{13.45,35.59},{13.75,35.8},{16.91,37.08},{16.55,36.75},{16.03,37.59},{18.31,35.62},{17.42,37.16},{16.59,38.21},{16.13,34.22},{16.14,33.42},{14.99,33.58},{14.97,34.01},{14.81,34.92},{16.18,33.17},{15.89,32.32},{16.56,32.47},{16.09,32.24},{15.56,37.2},{15.96,42.44},{15.42,37.32},{17.39,39.81},{18.07,33.74}}},nil,10,nil,nil,21,nil,nil,0},
[2464] = {'Commander Aggro\'gosh',61040,61040,60,60,1,{[33]={{38.42,50.46}}},nil,33,{26278,26279,26280,26281},{568,569,26278,26279,26280,26281,26417,28688},29,"H",nil,3},
[2465] = {'Far Seer Mok\'thardin',1848,1848,45,45,0,{[33]={{38.35,51.08}}},nil,33,{26317,26321,26338},{570,571,572,573,26317,26321,26338,26407},29,"H",nil,3},
[2466] = {'Mountaineer Grugelm',1910,1910,30,30,0,nil,{[11]={{{52.64,82.99},{52.48,82.96},{52.01,82.87},{51.62,82.79},{51.2,82.7},{50.66,82.58},{51.23,82.71},{51.62,82.78},{52.05,82.87},{52.45,82.96},{52.9,83.05},{53.3,83.14},{53.71,83.22},{54.14,83.31},{54.55,83.4},{54.85,83.47},{55.12,83.53},{54.76,83.46},{54.18,83.33},{53.77,83.24},{53.31,83.14},{52.89,83.04}}}},0,nil,nil,57,"A",nil,0},
[2468] = {'Mountaineer Thar',1398,1398,25,25,0,{[11]={{55.72,84.73}}},nil,11,nil,nil,57,"A",nil,0},
[2469] = {'Mountaineer Rharen',1910,1910,30,30,0,nil,nil,0,nil,nil,57,"A",nil,0},
[2470] = {'Watcher Fraizer',2672,2672,37,37,0,{[10]={{74.52,47.91},{74.56,47.79}}},nil,10,nil,nil,56,"A","The Night Watch",0},
[2472] = {'Flamescale Drake',75,80,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[2473] = {'Granistad',1753,1753,40,40,0,{[267]={{71.53,54.93}}},nil,267,nil,nil,122,"A",nil,0},
[2474] = {'Kurdros',1753,1753,40,40,0,{[267]={{71.42,54.47}}},nil,267,nil,nil,122,"A",nil,0},
[2475] = {'Sloth',1,1,31,31,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2476] = {'Gosh-Haldir',492,492,15,15,4,{[38]={{58.63,37.26},{54.43,53.61}}},nil,38,nil,nil,14,nil,"The Clutch Mother",0},
[2477] = {'Gradok',1347,1563,19,21,1,nil,nil,0,nil,nil,1801,"H","Horde Runner",0},
[2478] = {'Haren Swifthoof',1347,1563,19,21,1,nil,{[38]={{{55.79,66.73},{56.05,66.39},{56.39,65.71},{56.89,65.7},{57.47,65.02},{58.17,64.46},{58.91,64.21},{59.36,63.57},{59.96,62.52},{60.16,62.02},{60.53,61.1},{60.95,60.44},{61.23,60.11},{61.59,59.58},{62.54,58.21},{62.94,57.6},{63.19,56.8},{63.42,56.06},{63.59,55.46},{63.6,54.82},{63.74,54.27},{63.87,53.38},{64.16,51.78},{64.25,50.98},{64.3,50.52},{64.37,49.88},{64.35,48.58},{64.51,47.68},{64.49,46.1},{64.56,44.89},{64.56,43.86},{64.52,43.27},{64.43,42.54},{64.19,41.58},{64.21,40.34},{64.03,39.27},{63.96,38.51},{64.31,37.71},{64.57,37.2},{64.44,36.58},{64.19,35.86},{64.1,35.5},{63.98,34.99},{63.7,34.22},{63.44,33.67},{63.39,32.8},{63.21,32.12},{63.11,31.65},{62.76,31.01},{62.38,30.44},{61.84,29.77},{61.66,29.49},{61.41,28.89},{61.11,28.16},{60.8,27.48},{60.57,26.95},{60.38,26.48},{60.16,25.97},{59.89,25.31},{59.3,24.41},{58.8,23.43},{58.52,22.94},{58.29,22.39},{57.95,21.54},{57.75,21.05},{57.49,20.19},{57.27,19.36},{56.97,18.16},{57.13,17.47},{57.64,17.39},{58.26,17.65},{58.7,18.06},{59.37,18.88},{59.5,19.73},{59.66,20.77},{59.79,21.54},{60.21,22.39},{60.4,23.02},{61.07,24.29},{61.17,25.19},{61.6,26.08},{61.98,26.81},{62.25,27.51},{62.39,28.56},{62.59,29.04},{63.11,30.19},{63.44,30.93},{63.82,31.89},{64.01,32.56},{64.4,34.46},{64.63,35.35},{64.99,36.36},{65.36,37.2},{65.76,38.32},{65.63,39.02},{66.08,39.96},{65.66,40.96},{65.64,41.75},{65.71,42.55},{65.69,43.34},{65.51,44.34},{65.61,45.28},{65.78,45.9},{66.09,47.09},{66.38,48.09},{66.36,49.22},{66.66,50.26},{66.55,50.97},{66.38,51.86},{65.58,52.24},{65.14,52.42},{64.66,53.02},{64.03,54.05},{63.9,54.52},{63.65,55.15},{63.44,55.77},{63.3,56.56},{63.02,57.79},{62.54,58.44},{61.64,59.62},{61.16,59.72},{60.39,59.76},{59.78,60.41},{59.13,61.19},{58.53,62.01},{58.17,62.75},{57.89,63.49},{57.17,64.26},{56.56,65.01},{56.15,65.8},{55.49,66.69}}}},0,nil,nil,1801,"H","Horde Runner",0},
[2479] = {'Sludge',1,1,31,31,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2480] = {'Bro\'kin',2672,2672,49,49,0,{[267]={{43.96,21.8}}},nil,267,nil,nil,120,"AH","Alchemy Supplies",128},
[2481] = {'Bliztik',1469,1469,36,36,0,nil,nil,0,nil,nil,120,"AH","Alchemy Supplies",128},
[2482] = {'Zarena Cromwind',1716,1716,43,43,0,{[5287]={{42.97,70.78}}},nil,5287,nil,nil,120,"AH","Superior Weaponsmith",4224},
[2483] = {'Jaquilina Dramet',1459,1459,39,39,0,{[33]={{43.69,23.19}}},nil,33,nil,nil,35,"AH","Superior Axecrafter",4224},
[2485] = {'Larimaine Purdue',2769,2769,50,50,0,{[1519]={{50.38,85.99}}},nil,1519,nil,nil,12,"A","Portal Trainer",49},
[2486] = {'Fin Fizracket',1651,1651,42,42,0,{[5287]={{41.8,72.84}}},nil,5287,{26597},{348,26597},120,"AH","Blackwater Raiders",2},
[2487] = {'Fleet Master Seahorn',3052,3052,60,60,0,{[5287]={{41.09,73.27}}},nil,5287,{26630,26699,26700},{599,604,608,669,26617,26630,26698},390,"AH","Blackwater Raiders",3},
[2488] = {'Deeg',1279,1279,34,34,0,{[5287]={{40.68,73.83}}},nil,5287,{26613},{587,26613},120,"AH","Blackwater Raiders",2},
[2489] = {'Milstaff Stormeye',2218,2218,45,45,0,{[1537]={{25.5,7.07}}},nil,1537,nil,nil,55,"A","Portal Trainer",49},
[2490] = {'First Mate Crazz',1782,1782,44,44,0,{[5287]={{42.59,72}}},nil,5287,{26609,26611},{597,26610},120,"AH","Blackwater Raiders",2},
[2491] = {'Whiskey Slim',1395,1395,38,38,0,{[5287]={{41.03,73.99}}},nil,5287,nil,{580},120,"AH","Blackwater Raiders",129},
[2492] = {'Lexington Mortaim',1342,1342,35,35,0,{[1497]={{84.19,15.58}}},nil,1497,nil,nil,68,"H","Portal Trainer",49},
[2493] = {'Dizzy One-Eye',1585,1585,41,41,0,{[5287]={{43.39,71.49}}},nil,5287,{26614},{576,26614},120,"AH","Blackwater Raiders",2},
[2494] = {'Privateer Bloads',1524,1524,40,40,0,{[5287]={{40.42,72.27}}},nil,5287,nil,{617},120,"AH",nil,0},
[2495] = {'Drizzlik',2218,2218,45,45,0,{[33]={{43.66,23.46}}},nil,33,{26343,26344,26345},{575,577,628,26343,26344,26345},120,"AH",nil,2},
[2496] = {'Baron Revilgaz',4120,4120,60,60,0,{[5287]={{41.18,73.06}}},nil,5287,{26612,26624,26678,26695,26697,26698,26703,29153,29155,29251,29253},{578,601,611,616,1181,1182,26611,26612,26665,26679,26695,26697,26699,26700,26703,29153,29154,29251,29252},120,"AH",nil,3},
[2497] = {'Nimboya',1585,1585,41,41,0,{[33]={{38.42,48.71}}},nil,33,{26298,26299,26300,26350},{581,582,592,2932,26298,26299,26305,26323},126,"H",nil,3},
[2498] = {'Crank Fizzlebub',1279,1279,34,34,0,{[5287]={{41.01,73.61}}},nil,5287,nil,{600,605,621,1118,1122,1127},120,"AH",nil,2},
[2499] = {'Markel Smythe',1395,1395,38,38,0,{[5287]={{42.45,69.9}}},nil,5287,nil,nil,120,"AH",nil,0},
[2500] = {'Captain Hecklebury Smotts',1336,1336,37,37,0,{[5287]={{40.32,67.79}}},nil,5287,{26599,26600,26601,26602},{614,618,620,8551,8552,8554,26599,26600,26601,26602},120,"AH",nil,2},
[2501] = {'"Sea Wolf" MacKinley',2138,2138,44,44,0,{[5287]={{42.08,73.38}}},nil,5287,{26593,26595},{607,609,613,2874,26594,26595},120,"AH",nil,2},
[2502] = {'"Shaky" Phillipe',2138,2138,44,44,0,{[5287]={{40.5,67.7}}},nil,5287,{26594},{606,26593},120,"AH",nil,2},
[2503] = {'Hillsbrad Foreman',508,508,20,20,0,{[267]={{34.95,71.04},{35,70.44},{37.1,67.81},{35.73,69.94},{36.68,71.96},{36.35,70.45},{37.36,69.7},{35.57,68.25},{34.5,68.78},{34.2,72.4}}},nil,267,nil,nil,12,"A",nil,0},
[2504] = {'Donyal Tovald',328,328,15,15,0,{[1519]={{84.09,24.35}}},nil,1519,nil,{579},12,"A","Librarian",2},
[2505] = {'Saltwater Snapjaw',955,955,30,31,0,{[47]={{79.83,65.84},{82.6,43.36},{83.27,47.9},{82.15,85.1},{80.81,77.47},{81.47,63.17},{81.59,44.6},{83.47,42.64},{82.46,40.66},{80.52,72.12},{85.09,45.16},{85.28,42.57},{80.82,61.89},{79.86,73.3},{83.3,44.93},{82.55,38.22},{81.68,42.25},{80.73,66.81},{83.29,39.54},{79.01,85.31},{80.71,74.8},{81.66,39.03},{77.57,72.37},{77.26,89.17},{77.72,69.77},{76.4,83.62},{76.62,67.93},{78.65,69.57},{78.17,70.35},{77.34,86.52},{76.75,73.21},{74.57,68.34},{75.6,66.91},{76.28,70.82},{76.32,65.72},{78.08,68.05},{75.65,69.6},{77.51,66.43},{75.58,71.89},{82.51,46.11},{81.74,60.24},{79.71,60.47},{79.06,61.84},{82.39,54.08},{83.29,52.63},{82.59,59.17},{80.76,69.5},{78.25,63.22},{77.13,64.5},{78.21,65.49},{77.49,62.01},{79.96,57.76},{83.25,55.23}}},nil,47,nil,nil,7,"AH",nil,0},
[2506] = {'Mountaineer Harn',1398,1398,25,25,0,{[38]={{35.95,50.4}}},nil,38,nil,nil,57,"A",nil,0},
[2507] = {'Mountaineer Uthan',1398,1398,25,25,0,{[38]={{37.86,41.67}}},nil,38,nil,nil,57,"A",nil,0},
[2508] = {'Mountaineer Wuar',1398,1398,25,25,0,{[38]={{34.92,41.86}}},nil,38,nil,nil,57,"A",nil,0},
[2509] = {'Mountaineer Cragg',1398,1398,25,25,0,{[38]={{33.72,42.75}}},nil,38,nil,nil,57,"A",nil,0},
[2510] = {'Mountaineer Ozmok',1398,1398,25,25,0,{[38]={{32.78,50.7}}},nil,38,nil,nil,57,"A",nil,0},
[2511] = {'Mountaineer Bludd',1398,1398,25,25,0,{[38]={{38.99,43.85}}},nil,38,nil,nil,57,"A",nil,0},
[2512] = {'Mountaineer Roghan',1398,1398,25,25,0,{[38]={{35.09,51.26}}},nil,38,nil,nil,57,"A",nil,0},
[2513] = {'Mountaineer Janha',1398,1398,25,25,0,{[38]={{35.41,44.48}}},{[38]={{{35.41,44.48},{35.27,43.75}}}},38,nil,nil,57,"A",nil,0},
[2514] = {'Mountaineer Modax',1398,1398,25,25,0,{[38]={{37.49,44.66}}},nil,38,nil,nil,57,"A",nil,0},
[2515] = {'Mountaineer Fazgard',1398,1398,25,25,0,{[38]={{38.62,46.91}}},nil,38,nil,nil,57,"A",nil,0},
[2516] = {'Mountaineer Kamdar',1398,1398,25,25,0,{[38]={{33.31,44.76}}},nil,38,nil,nil,57,"A",nil,0},
[2517] = {'Mountaineer Langarr',1398,1398,25,25,0,{[38]={{35.69,46.76}}},nil,38,nil,nil,57,"A",nil,0},
[2518] = {'Mountaineer Swarth',1398,1398,25,25,0,{[38]={{37.65,49.44}}},nil,38,nil,nil,57,"A",nil,0},
[2519] = {'Kin\'weelay',1459,1459,39,39,0,{[33]={{63.08,41.52}}},nil,33,{26303,26305},{588,589,591,596,598,629,1240,26302,26303},126,"H",nil,2},
[2520] = {'Remote-Controlled Golem',1251,1347,18,18,1,nil,nil,0,nil,nil,14,nil,nil,0},
[2521] = {'Skymane Gorilla',1057,1057,32,32,0,{[5287]={{62.14,77.49},{62.21,73.29},{62.6,84.14},{59.86,88.62},{64.82,79.99},{60.59,76.07},{63.19,74.85}}},nil,5287,nil,nil,72,nil,nil,0},
[2522] = {'Jaguero Stalker',1207,1207,31,32,0,{[5287]={{57.96,87.43},{56.73,86.79},{59.77,74.67},{56.47,75.93},{58.17,75.31},{58.52,79.8},{58.98,79.86},{58.42,78.64},{59.8,77.25},{56.25,79.63},{57.37,81.3},{58.07,83.43},{57.99,84.95},{56.1,83.86},{56.4,86.92}}},nil,5287,nil,nil,16,nil,nil,0},
[2523] = {'Searing Totem',5,5,85,85,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2524] = {'Mountaineer Haggis',1910,1910,30,30,0,nil,nil,0,nil,nil,57,"A",nil,0},
[2525] = {'Mountaineer Barn',1910,1910,30,30,0,nil,{[38]={{{43.33,11.21},{42.81,10.33},{42.42,10.82},{40.99,12.64},{41.37,12.14},{42.81,10.43},{43.18,10.94},{43.94,11.95},{44.73,12.9},{45.56,13.74},{46.31,14.23},{46.82,14.29},{47.99,14.39},{48.96,14.29},{49.66,13.98},{50.5,13.39},{51.37,12.6},{52.2,11.74},{53.2,10.56},{53.51,11.16},{54.64,12.63},{55.26,13.89},{55.01,13.23},{54.44,12.32},{53.69,11.29},{53.1,10.54},{52.36,11.59},{51.56,12.52},{50.68,13.27},{48.85,14.27},{47.72,14.38},{46.71,14.28},{45.66,13.96},{44.86,13.02},{44.08,12.04},{43.31,11.05},{42.71,10.29}}}},0,nil,nil,57,"A",nil,0},
[2526] = {'Mountaineer Morlic',1910,1910,30,30,0,nil,nil,0,nil,nil,57,"A",nil,0},
[2527] = {'Mountaineer Angst',1910,1910,30,30,0,nil,nil,0,nil,nil,57,"A",nil,0},
[2528] = {'Mountaineer Haggil',1910,1910,30,30,0,nil,nil,0,nil,nil,57,"A",nil,0},
[2529] = {'Son of Arugal',1452,1452,20,20,1,nil,nil,0,nil,nil,14,nil,nil,0},
[2530] = {'Yenniku',955,955,30,30,0,{[33]={{57.27,75.36}}},nil,33,nil,{593},28,nil,"Envoy of Zanzil",0},
[2531] = {'Minion of Doane',726,726,20,20,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2532] = {'Donna',42,42,1,1,0,{[1519]={{67.42,64.27},{59.45,65.12},{60.94,45.08}}},nil,1519,nil,nil,12,"A",nil,0},
[2533] = {'William',42,42,1,1,0,{[1519]={{61.09,45.03}}},{[1519]={{{67.87,63.68},{68.38,62.98},{69.15,62.02},{68.99,61.41},{68.61,60.55},{67.92,59.75},{67.4,58.65},{67.33,57.16},{67.63,56.31},{69.08,54.3},{69.58,53.1},{69.21,52.58},{68.85,52.26},{68.57,51.36},{68.08,50.54},{67.7,50.36},{66.97,50.46},{66.06,51.21},{65.25,50.67},{63.98,49.29},{62.58,46.42},{62.1,44.73},{61.4,44.42},{60.83,45.01},{60.44,45.4},{60.27,45.63},{59.71,46.23},{59.57,47.14},{59.87,48.07},{61.09,50.18},{61.47,52.86},{61.55,54.68},{61.16,56.87},{60.57,57.83},{59.73,58.44},{58.07,60.65},{57.25,61.5},{56.89,62.4},{57.51,63.44},{57.58,63.87},{58.14,64.49},{58.85,64.11},{60.52,67.11},{60.91,67.08},{61.65,66.15},{62.58,65.84},{63.43,65.97},{64.18,66.71},{65.25,69.32},{64.31,70.22},{63.18,72.1},{62.33,72.08},{62.07,71.31},{62.3,70.57},{62.78,70.34},{63.3,70.87},{63.11,72.04},{61.99,73.44},{61.14,73.77},{60.42,72.18},{59.97,71.54},{57.67,73.3},{57.08,71.86},{56.27,69.51},{56.42,67.42},{57.02,66.17},{58.54,64.29},{59.35,63.43},{60.18,63.03},{60.86,61.91},{63.01,61.35},{63.93,61.08},{64.91,61.7},{65.33,62.95},{66.85,65.05},{67.16,64.91},{67.47,64.18}}}},1519,nil,nil,12,"A",nil,0},
[2534] = {'Zanzil the Outcast',1919,1919,46,46,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2535] = {'Maury "Club Foot" Wilkins',2114,2114,32,32,0,{[5287]={{59.6,49.18}}},nil,5287,nil,nil,16,nil,nil,0},
[2536] = {'Jon-Jon the Crow',2059,2138,43,44,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2537] = {'Chucky "Ten Thumbs"',2059,2138,43,44,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2540] = {'Ambermill Serpent',1,1,14,15,0,nil,nil,0,nil,nil,76,"AH",nil,0},
[2541] = {'Lord Sakrasis',1509,1509,31,31,4,{[5287]={{43.81,49.08},{43.79,49.11}}},{[33]={{{28.85,62.03},{28.82,62.07},{28.7,62.19},{28.59,62.3},{28.49,62.4},{28.39,62.5},{28.27,62.62},{28.17,62.71},{28.14,62.74},{28.17,62.71},{28.27,62.61},{28.4,62.49},{28.51,62.38},{28.63,62.26},{28.73,62.16},{28.82,62.07},{28.85,62.03}}}},5287,nil,nil,74,nil,nil,0},
[2542] = {'Catelyn the Blade',2769,2769,50,50,0,{[5287]={{41.27,74.12}}},nil,5287,nil,{603,610,612,38399},120,"AH","Blackwater Raiders",0},
[2543] = {'Archmage Ansirem Runeweaver',1239,1239,40,40,0,nil,nil,0,nil,{602},2006,"AH","Kirin Tor",0},
[2544] = {'Southern Sand Crawler',1220,1220,35,35,0,{[5287]={{40.57,85.36},{42.13,87.27},{45.52,89.9},{54.35,66.55},{43.55,91.43},{41.74,87.08},{39.63,84.84},{46.49,90.12},{52.46,67.41},{56.86,54.15},{52.05,87.92}}},nil,5287,nil,nil,7,"AH",nil,0},
[2545] = {'"Pretty Boy" Duncan',1403,1403,35,35,0,{[5287]={{44.43,92.85}}},nil,5287,{1036,26635},{26635},119,nil,nil,3},
[2546] = {'Fleet Master Firallon',2440,2440,35,35,0,{[5287]={{46.7,95.34}}},nil,5287,{4621,9272,26650},{1036,4621,9272,26644},119,nil,nil,2},
[2547] = {'Ironpatch',1464,1464,35,35,0,{[5287]={{46.58,94.99}}},nil,5287,{26647,26649},{26647,26649},119,nil,nil,2},
[2548] = {'Captain Keelhaul',1220,1220,35,35,0,{[5287]={{44.41,91.44}}},nil,5287,{26633,26644},{26631,26633},119,nil,nil,2},
[2549] = {'Garr Salthoof',1220,1220,35,35,0,{[5287]={{44.45,91.89}}},nil,5287,{26634},{26634},119,nil,nil,2},
[2550] = {'Captain Stillwater',1651,1651,42,42,0,nil,nil,0,nil,nil,119,nil,nil,0},
[2551] = {'Brutus',1952,1952,35,35,0,{[5287]={{50.39,91.48}}},nil,5287,nil,nil,119,nil,nil,0},
[2552] = {'Witherbark Troll',750,750,25,26,0,{[45]={{69.84,39.91},{69.62,39.96},{31.27,41.87},{28.37,40.42},{29.61,50.62},{24.57,43.6},{69.83,43.77},{69.89,43.79},{69.95,43.74},{28.85,47.41}}},nil,45,nil,nil,654,nil,nil,0},
[2553] = {'Witherbark Shadowcaster',562,562,25,25,0,{[45]={{69.64,39.81},{25.73,47.67},{28.85,47.42},{69.8,43.67},{25.7,47.62},{24.42,43.32}}},{[45]={{{74.08,45.83},{74.08,45.83},{74.08,45.83},{74.9,42.9},{74.55,37.48}}}},45,nil,nil,654,nil,nil,0},
[2554] = {'Witherbark Axe Thrower',750,750,25,26,0,{[45]={{60.43,66.3},{59.29,74.87},{58.31,74.91},{56.72,74.39},{59.89,76.33},{59.92,75.19},{55.98,73.31},{58.92,75.82},{54.39,76.45},{56.41,75.28},{55.1,74.85},{56.91,73.27},{60.89,64.75},{68.86,65.55},{57.54,69.61},{58.24,69.09},{61.1,66.42},{62.17,65.3},{60.04,69.43},{68.1,66.61},{58.71,70.19},{57.65,70.57},{61.9,63.77},{66.95,60.88},{66.75,62.34},{68.3,62.2},{68.31,67.86},{65.71,60.58},{63.13,62.51},{64.19,60.92},{65.76,63.57},{60.06,69.41}}},nil,45,nil,nil,654,nil,nil,0},
[2555] = {'Witherbark Witch Doctor',671,671,26,26,0,{[45]={{64.05,82.14},{65.21,80.03},{25.14,47.08},{24.36,43.94},{26.29,45.61},{61.38,84.85},{63.89,83.53},{62.28,83.13},{61.58,83.14},{61.1,71.12},{61.16,73.79},{59.83,75.63},{55.74,74.34},{57.85,69.86},{61.15,65.72},{59.85,71.12},{68.88,66.57},{68.33,67.24},{64.61,68.42},{63.04,73.54},{59.39,73.96},{65.57,72.59},{59.19,75.24},{66.85,63.68},{66.86,66.53},{68.08,67.83},{66.51,68.93},{64.95,63.42},{64.31,69.26},{24.36,43.94},{25.15,47.09},{26.28,45.6}}},nil,45,nil,nil,654,nil,nil,0},
[2556] = {'Witherbark Headhunter',699,699,25,26,0,{[45]={{69.86,39.79},{65.68,80.35},{65.54,81.41},{62.44,84.88},{65.04,79.75},{62.77,80.49},{62.84,78.82},{61.2,82.63},{61.5,85},{60.7,84.42},{63.21,81.88},{63.34,82.78},{62.42,83.16},{63.86,83.58},{64.82,84.53},{64.74,83.69},{64.17,85.29},{63.54,78.82},{54.67,74.08},{57.31,75.25},{64.09,75.63},{65.64,71.76},{64.1,74.05},{64.98,74.07},{61.92,72.02},{59.07,70.89},{58.19,73.71},{67.7,66.3},{66.86,65.06},{65.98,69.3},{66.21,67.93},{64.71,70.31},{66.99,64.95},{69.89,43.66}}},nil,45,nil,nil,654,nil,nil,0},
[2557] = {'Witherbark Shadow Hunter',702,702,25,26,0,{[45]={{64.65,81.89},{64.84,81.27},{61.61,83.1},{61.5,83.87},{63.15,84.9},{64.8,80.38},{61.99,84.85},{61.78,81.44},{63.61,83.92}}},nil,45,nil,nil,654,nil,nil,0},
[2558] = {'Witherbark Berserker',699,699,25,26,0,{[45]={{16.2,66.98},{17.4,67.8},{17.69,66.6},{17.61,68.14}}},nil,45,nil,nil,654,nil,nil,0},
[2559] = {'Highland Strider',769,769,25,26,0,{[45]={{11.3,40.79},{10.7,41.97},{64.15,54.23},{62.34,56.59},{14.92,47.11},{46.07,33.31},{13.46,43.03},{12.14,42.21},{14.17,44.8},{26.57,37.56},{32.69,37.3},{46.49,45.9},{45.68,47.77},{41.72,35.06},{40.91,35.68},{32.95,35.12},{22.75,20.5},{32.23,33.67},{19.91,25.12},{24.74,19.94},{23.66,19.17},{23.66,21.68},{45.6,40.81},{65.04,31.05},{35.07,76.79},{36.11,48.59},{34.01,60.39},{43.77,50.46},{43.73,53.46},{41.19,55.19},{41.13,51.71},{33.03,30.78},{30.45,25.77},{59.35,51.89},{63.86,49.91},{31.13,34.91},{69.26,49.51},{32.82,39.4},{30.51,30},{30.48,33.52},{30.56,35.94},{31.25,37.73},{29.57,37.02},{30.35,39.32},{43.77,42.5},{41.19,41.12},{41.83,42.28},{40.06,56.43},{54.57,38.67},{54.87,38.91},{18.57,38},{19.86,37.03},{20.74,37.71},{35.1,54.87},{18.91,40.55},{17.94,36.47},{17.86,41.95},{48.08,46.82},{45.75,42.02},{47.45,47.62},{40.72,65.43},{47.62,45.04},{34.14,63.51},{40.93,57.68},{64.97,28.25},{36.19,53.47},{37.34,44.04},{36.02,50.81},{34.9,52.63},{36.21,45.15},{37.48,40.6},{38.14,41.94},{37.8,39.7},{20.5,21.09},{22.14,19.3},{27.72,36.36},{65.06,33.81},{55.73,44.98},{53.19,44.7},{54.22,43.43},{49.62,48.09},{49.73,50.78},{51.61,48.11},{53.41,41.95},{54.29,46.57},{50.58,49.77},{48.53,49.84},{40.85,40.74},{71.42,32.22},{65.65,53.23},{60.99,42.14},{59.98,43.64},{63.91,37.9},{61.19,44.8},{61,36.21},{65.12,36.83},{62.12,37.72},{63.75,40.84},{56.27,43.58},{58.21,43.67},{55.48,42.09},{55.06,38.11},{53.47,42},{56.13,46.47},{55.27,44.83},{53.9,44.2},{57.22,47.82},{59.22,47.54},{53.47,43.95},{54.43,45.82},{59.21,42.15},{60.19,40.65},{58.17,46.63},{60,46.45},{60.23,37.72},{60.99,39.77},{62.16,34.81},{62.18,40.92},{62.96,39.28},{61.85,43.04},{57.38,48},{58.95,47.31},{59.96,46.27},{41.9,42.81},{18.26,42.34},{18.82,40.8},{40.74,65.29},{14.82,45.24},{14.99,46.5},{41.07,54.91},{40.7,58.17},{39.98,56.24},{36.2,45.39},{38.09,42.41},{40.43,40.49},{36.32,53.35},{35.16,51.81},{35.93,47.81},{40.97,51.88},{13.31,43.28},{12.32,42.54},{9.95,42.07},{11.46,40.25},{36.3,50.63}}},nil,45,nil,nil,48,nil,nil,0},
[2560] = {'Highland Thrasher',853,853,27,28,0,{[45]={{13.04,46.36},{11.32,49.37},{50.34,70.8},{33.25,66.4},{33.45,68.85},{31.26,67.26},{32.23,68.1},{14.94,51.82},{12.37,57.46},{11.67,50.91},{27.76,63.74},{15.3,56.09},{34.47,67.43},{15.87,50.36},{34.4,70.8},{13.13,49.34},{13.26,58.14},{48.63,57.58},{13.85,57.39},{34.98,66.9},{14.31,50},{15.09,49.23},{28.27,64.09},{48.66,62.13},{30.88,65.1},{12.17,47.77},{30.46,67.78},{57.07,66.65},{29.09,67.25},{34.97,72.48},{33.43,73.01},{32.9,70.71},{31.24,69.8},{29.73,69.99},{53.23,68.33},{13.11,46.28}}},nil,45,nil,nil,38,nil,nil,0},
[2561] = {'Highland Fleshstalker',905,905,28,29,0,{[45]={{43.13,81.51},{41.82,84.89},{41.81,82.42},{40.06,79.44},{39.88,82.17},{48.47,69.58},{47.13,70.21},{47.35,70.35},{45.26,71.3},{44.68,72.21},{43.88,70.96},{49.52,68.03},{48.99,65.68},{41.82,76.47},{40.63,78.32},{40.92,80.24},{40.97,83.68},{41.68,82.16},{41.83,85.11},{40.9,83.1},{40.77,77.97},{41.03,80.94},{39.66,79.07},{40.12,82.11}}},nil,45,nil,nil,38,nil,nil,0},
[2562] = {'Boulderfist Ogre',699,699,25,26,0,{[45]={{24.95,49.49},{24.7,46.44},{25.49,49.47},{29.41,46.33},{30.31,49.42},{29.76,47.42},{28.82,42.02},{29.59,44.75},{31.5,44.96},{29.87,43.1},{31.48,47.96},{28.41,50.81},{26.86,41.36},{26.13,41.7},{25.59,49.37},{25.53,41.18},{24.58,46.3},{27.1,48.71},{28.43,49.25},{24.82,49.57},{29.6,41.79},{30.39,43.29},{24.55,46.61},{31.6,48.13},{29.54,46.48},{27.38,48.38},{25.47,49.4},{28.56,49.08},{30.33,49.18},{30.07,48.1},{26.76,42.09},{29.3,45.06},{30.29,43.41},{31.5,44.74}}},nil,45,nil,nil,45,nil,nil,0},
[2563] = {'Plains Creeper',750,750,26,27,0,{[45]={{10.27,47.8},{42.59,37.23},{39.1,40.57},{43.64,31.25},{12.14,45.18},{31.45,23.1},{66.75,51.98},{63.25,55.48},{61.92,53.65},{33.39,23.22},{42.96,38.79},{65.03,51.91},{20.58,26.31},{41.98,39.06},{66.15,56.46},{42.02,37.21},{41.69,34.3},{11.14,46.38},{10.39,44.29},{31.81,24.79},{61.8,50.58},{38.13,21.4},{63.94,47.94},{11.68,43},{65.73,47.99},{38.72,33.33},{61.04,52.16},{62.98,52.12},{22.62,35.06},{59.47,44.72},{64.94,49.51},{13.9,41.42},{40.41,37.14},{40.13,42.49},{43.48,37.06},{43.5,37.43},{22.29,22.5},{15.78,47.77},{11.4,52.28},{16.81,49.13},{26.58,62.28},{32.92,64.82},{34.12,54.26},{10.48,51},{37.51,62.14},{16.13,54.01},{35.98,61.2},{35.89,63.54},{12.01,53.58},{13.98,53.46},{39.94,67.87},{35.57,64.72},{13.03,52.68},{41.53,59.44},{13.47,55.39},{15.98,56.8},{35.05,62.06},{35.53,70.22},{42.74,36.08},{42.99,52.34},{35.12,49.27},{26.18,56.17},{31.25,25.65},{63.26,49.14},{63.69,35.01},{62.59,36.21},{69.37,48.64},{18.05,39.13},{32.3,36.25},{29.47,35.14},{31.38,29.54},{31.21,31.84},{27.27,65.59},{40.14,37.29},{37.12,33.01},{65,39.19},{19.98,39.32},{13.09,40.85},{35.17,59.21},{37.11,59.32},{43.7,63.47},{41.73,63.21},{33.78,73.63},{28.99,68.24},{62.97,57.87},{64.67,57.65},{67.02,48.98},{67.96,47.82},{65.8,50.8},{64,56.48},{63.86,58.74},{38.66,33.36},{36.05,20.99},{37.09,33.22},{10.22,44.9},{39.57,68.23},{16.06,47.91},{41.63,59.19},{41.94,63.83},{13.24,40.94},{14.1,42.06},{12.1,45.05},{11.12,46.33},{11.01,42.71},{35.14,49.07},{40.06,41.66}},[47]={{23.31,80.88},{23.39,80.63},{22.78,81.5}}},nil,45,nil,nil,22,nil,nil,0},
[2564] = {'Boulderfist Enforcer',750,750,26,27,0,{[45]={{26.68,47.88},{25.27,47.01},{25.56,47.31},{24.75,44.89},{25.28,45.4},{28.66,45.38},{27.57,45.95},{27.62,45.81},{27.31,47.21},{26.07,45.92},{26.48,46.66},{25.28,47.1},{26.98,45.06},{26.2,45.06},{26.46,44.29},{26.18,45.08},{26.48,44.27},{24.75,44.88},{25.28,45.39},{28.24,45.37},{26.75,47.3},{27.29,46.12},{27.31,47.18},{26.08,45.93},{26.47,46.67},{26.04,47.25},{27.62,45.82},{27.01,45.05},{25.54,47.28}}},nil,45,nil,nil,45,nil,nil,0},
[2565] = {'Giant Plains Creeper',800,800,27,28,0,{[45]={{31.28,24.71},{39.4,34.7},{40.25,37.43},{55.48,69.64},{56.08,67.23},{48.33,56.12},{51.39,72.12},{47.39,60.69},{52.39,70.89},{42.1,79.08},{40.25,76.57},{49.38,57.94},{47.57,67.1},{50.61,56.25},{47.58,57.98},{52.69,66.1},{54.29,71.05},{55.12,66.9},{56.17,70.92},{34.14,29.28},{33.46,27.02},{32.17,25.34},{50.53,62.24},{50.46,59.42},{49.78,61.46},{31.26,27.87},{32.23,29.19},{46.47,62.25},{51.36,69.31},{54.18,67.84},{52.3,67.91},{34.07,29.25},{40.34,77.11}}},nil,45,nil,nil,22,nil,nil,0},
[2566] = {'Boulderfist Brute',750,750,25,26,0,{[45]={{44.97,82.38},{46.74,73.45},{47.24,76.32},{47.38,74.74},{43.68,77.7},{43.62,80.74},{46.29,79.19},{45.35,78.86},{46.33,76.35},{45.66,75.17},{48.92,76.18},{47.4,78.31},{49.5,75.08},{48.24,76.85},{47.97,78.46},{48.65,77.93},{49.13,82.86},{48.74,83.49},{48.55,81.6},{49.12,80.71}}},nil,45,nil,nil,45,nil,nil,0},
[2567] = {'Boulderfist Magus',646,646,25,26,0,{[45]={{47.48,76.69},{44.63,76.49},{48.52,73.74},{46.01,80.4},{46.75,77.88},{47.41,79.25},{48.67,80.1},{49.04,83.79},{48.06,82.41}}},nil,45,nil,nil,45,nil,nil,0},
[2569] = {'Boulderfist Mauler',750,750,26,27,0,{[45]={{10.87,71.13},{14.07,71.08},{15.13,67.42},{15.51,69.63},{13.2,68.77},{10.64,70.42},{12.96,67.75},{16.91,68.4},{17.71,64.81},{15.11,69.06},{17.31,67.96},{17.7,66.59},{16.59,68.34},{17.52,67.95},{16.34,68.87},{15.51,69.63}}},nil,45,nil,nil,45,nil,nil,0},
[2570] = {'Boulderfist Shaman',651,651,26,27,0,{[45]={{12.91,67.77},{12.64,66.53},{14.8,70.35},{13.63,68.68},{13.8,67.06},{11.85,68.38},{11.15,68.73},{11.14,70.54},{10.75,70.1},{14.87,68.96},{13.04,70.55},{13.45,71.27},{14.2,69.43},{11.01,71.1},{11.08,70.03}}},nil,45,nil,nil,45,nil,nil,0},
[2571] = {'Boulderfist Lord',800,800,27,27,0,{[45]={{13.16,67.7},{11.48,69.45},{12.16,67.92},{12.72,71.12},{11.81,71.33},{11.06,70.55},{13.89,70.38},{12.35,69.56},{11.24,71.02},{10.84,71.1},{10.86,70.13}}},nil,45,nil,nil,45,nil,nil,0},
[2572] = {'Drywhisker Kobold',905,905,28,29,0,{[45]={{72.45,45.12},{71.15,45.45},{72.18,45.53},{71.68,43.93},{75.37,41.09},{72.74,36.56},{73.47,40.61},{74.73,42.5},{73.59,37.83},{73.7,38.94},{72.76,42.53},{74.15,35.15},{74.73,35.94},{74.38,36.4},{73.57,42.41},{77.21,36.71},{77.05,38.15},{71.41,43.66},{73.67,42.45},{74.77,42.46},{72.45,36.12},{72.26,44.84},{73.58,37.78},{73.79,38.76},{73.62,40.52},{74.76,35.81},{77.73,38.59},{75.4,40.99},{71.2,45.8},{74.41,36.2},{72.21,45.48},{77.91,39.83},{77.69,38.71},{77.2,36.74}}},nil,45,nil,nil,26,nil,nil,0},
[2573] = {'Drywhisker Surveyor',669,669,28,29,0,{[45]={{79.24,34.38},{78.4,32.99},{78.78,32.91},{81.02,33.62},{80.88,30.79},{80.54,30.51},{78.44,32.97},{79.47,33.95},{78.39,33.03},{79.47,35},{77.67,37.62}}},nil,45,nil,nil,26,nil,nil,0},
[2574] = {'Drywhisker Digger',853,853,28,29,0,{[45]={{78.31,36.82},{79.19,34.92},{81.1,34.06},{80.15,32.32},{79.75,35.19},{80.07,32.24},{82.85,31.35},{79.75,33.34},{80.61,31.99},{78.23,34.08},{81.41,30.48},{78.19,36.88},{78.96,36.29},{79.2,34.95},{80.07,31.91},{80.65,31.89},{80.34,35.32},{81.36,31.68},{79.21,32.31},{78.17,34.02},{78.96,36.3},{78.2,36.81}},[47]={{60.41,89.4}}},nil,45,nil,nil,26,nil,nil,0},
[2575] = {'Dark Iron Supplier',935,977,31,32,0,nil,nil,0,nil,nil,54,nil,nil,0},
[2577] = {'Dark Iron Shadowcaster',847,882,31,32,0,nil,{[45]={{{48.24,88.09},{48.15,88.09},{47.97,88.1},{47.5,88.13},{47.13,88.14},{46.76,88.15},{46.43,88.15},{46.12,88.13},{46.44,88.15},{46.77,88.16},{47.19,88.15},{47.52,88.14},{47.85,88.13},{48.13,88.12}}}},0,nil,nil,54,nil,nil,0},
[2578] = {'Young Mesa Buzzard',699,699,25,26,0,{[45]={{54.54,41.39},{63.23,53.97},{68.81,49.68},{12.32,47.49},{11.41,45.64},{21.69,34.67},{13.36,40.02},{22.82,21.71},{20.38,24.87},{37.6,63.41},{62.04,36.95},{64.81,54.79},{45.43,45.66},{25.2,37.55},{19.04,35.61},{59.14,39.24},{33.98,60.8},{66.31,50.56},{13.47,39.93},{10.25,44.75}}},nil,45,nil,nil,7,"AH",nil,0},
[2579] = {'Mesa Buzzard',880,880,28,28,0,{[45]={{33.76,33.2},{42.52,69.67},{33.9,67.3},{13.37,53.8},{51.14,73.55},{26.56,58.58},{35.45,32.95},{51.26,60.96},{34.75,69.35},{29.38,64.42},{54.01,72.73},{43.56,68},{36.21,32.06}}},nil,45,nil,nil,7,"AH",nil,0},
[2580] = {'Elder Mesa Buzzard',981,981,27,28,0,{[45]={{44.37,82.45},{10.38,65.37},{9.65,70.47},{9.68,73.25},{25.13,70.88},{16.79,73.49},{14.98,74.29},{15.69,75.79},{42.02,85.1}}},nil,45,nil,nil,7,"AH",nil,0},
[2581] = {'Dabyrie Militia',750,750,26,26,0,{[45]={{51.33,41.76},{51.76,38.5},{50.45,36.19},{52.07,40.04},{50.05,43.36},{47.77,39.09},{50.31,42.57},{47.49,39.58},{50.02,38.23}}},nil,45,nil,nil,123,"A",nil,0},
[2582] = {'Dabyrie Laborer',825,825,26,26,0,{[45]={{49.49,41.88},{49.82,41},{49.69,42.05},{49.89,41.62},{51.56,41.01},{51.86,40.66},{50.33,41.6},{51.64,40.63},{49.88,40.48},{51.4,40.6},{50.19,40.99},{49.78,41.37},{49.09,41.12},{49.45,40.36},{50.89,40.4},{48.98,38.77},{49.25,38.72},{50.67,36.57},{51.13,41},{49.86,37.43},{50.08,37.29},{48.45,40.01},{48.78,39.46},{49.14,40.39},{49.63,39.74},{50.94,37.41},{50.66,37.34},{49.9,41.49},{49.47,40.95}}},nil,45,nil,nil,123,"A",nil,0},
[2583] = {'Stromgarde Troll Hunter',690,690,27,27,0,{[45]={{16.6,64.99},{14.47,65.12},{15.3,64.97},{18.53,60.47},{17.72,60.49},{17.14,58.78},{15.11,63.17},{15.33,61.38},{16.29,62.1}}},nil,45,nil,nil,123,"A",nil,0},
[2584] = {'Stromgarde Defender',800,800,27,27,0,{[45]={{15.84,61.13},{20.86,59.84},{16.81,62.22},{16.45,61.4},{17.73,62.2},{16.7,60.81},{17.06,62.5},{18.3,62.05}}},nil,45,nil,nil,123,"A",nil,0},
[2585] = {'Stromgarde Soldier',800,800,27,27,0,{[45]={{15.38,60.63},{21.75,59.96},{21.53,59.64},{20.84,59.18},{18.23,58.71},{16.13,59.72},{14.4,62.45},{20.51,60.52},{21.17,60.4},{16.15,59.74}}},nil,45,nil,nil,123,"A",nil,0},
[2586] = {'Syndicate Highwayman',699,699,24,25,0,{[45]={{25.91,25.72},{25.9,32.63},{27.72,26.59},{28.56,27.57},{25.33,24.4},{27.61,27.1},{28.47,30.36},{23.81,24.73},{27.91,27.6},{28.42,31.91},{26.82,24.86},{24.49,24.53},{27.51,29.76},{27.49,31.49},{24.07,29.59},{24.22,26.2},{24.82,25.99},{25.21,31.92},{28.57,29.14},{24.58,30.4},{26.22,26.62},{27.23,32.25},{27.76,33.48},{22.76,27.51},{23.68,31.86},{25.52,33.71},{26.49,26.14},{27.71,30.24},{24.61,30.46}}},nil,45,nil,nil,87,nil,nil,0},
[2587] = {'Syndicate Pathstalker',699,699,25,25,0,{[45]={{24.29,28.97},{25.71,28.38},{27.09,28.27},{27.06,31.38},{26.29,31.92},{25.08,28.94},{24.88,26.73},{25.09,27.29},{25.06,28.95},{24.31,28.99},{27.05,31.32}}},nil,45,nil,nil,87,nil,nil,0},
[2588] = {'Syndicate Prowler',699,699,25,26,0,{[45]={{21.04,63.77},{19.96,65.31},{22.5,66.58},{19.47,63.25},{18.88,66.49},{20.52,67.32},{21.8,62.86},{22.84,64.04},{20.06,67.54},{22.54,62.35},{22.69,64.09},{19.48,63.38},{21.81,65.18},{22.95,66.93},{23.11,66.27},{18.93,66.58},{22.1,67.65}}},nil,45,nil,nil,87,nil,nil,0},
[2589] = {'Syndicate Mercenary',699,699,25,25,0,{[45]={{24.53,28.58},{25.41,27.04},{24.07,29.45},{25.94,26.96},{27.19,29.23},{25.74,26.92},{27.23,29.96},{26.66,31.77},{25.71,31.59},{25.3,30.46},{24.5,26.72},{25.95,31.91},{24.59,28.48},{25.19,30.73},{24.65,29.41},{27.3,29.9},{26.65,31.72}}},nil,45,nil,nil,87,nil,nil,0},
[2590] = {'Syndicate Conjuror',562,562,25,26,0,{[45]={{22.46,67.78},{18.81,67.22},{19.83,61.95},{20.96,62.51},{22.67,67},{21.6,64.05},{19.04,64.03},{23,67.07},{20.92,66.89},{20.15,64},{21.07,62.06},{18.62,64.31},{22.51,66.66},{20.35,63.99},{21.32,63.94},{18.79,67.81},{19.88,62.56},{22.53,66.97}}},nil,45,nil,nil,87,nil,nil,0},
[2591] = {'Syndicate Magus',598,598,25,26,0,{[45]={{22.71,64.61},{22.08,62.65},{22.87,64.21},{20,66.74},{19.4,67.36},{19.98,67.14},{19.55,67.22},{21.66,62.32},{22.86,64.24},{19.99,67.14},{19.98,66.32},{22.79,64.86},{19.74,66.95},{19.5,66.79}}},nil,45,nil,nil,87,nil,nil,0},
[2592] = {'Rumbling Exile',905,905,29,29,0,{[45]={{28.39,60.89},{28.39,62.21},{30.52,62.37},{29.54,62.08},{28.6,59.11},{31.31,60.8},{28.47,57.88},{29.24,57.48},{30.29,57.72},{31.18,57.78},{30.23,60.62},{29.49,61.03},{31.49,62.23},{30.36,58.9},{31.4,59.23},{29.55,59.28}}},nil,45,nil,nil,91,nil,nil,0},
[2593] = {'Rough Stone Elemental',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2594] = {'Sprogger',1336,1336,37,37,0,{[5287]={{40.26,67.84}}},nil,5287,nil,{615,8553},120,"AH",nil,2},
[2595] = {'Daggerspine Raider',920,920,27,27,0,{[45]={{18.73,93.98},{13.23,86.52},{12.29,86.42},{12.07,87.86},{18.48,92.36},{15.93,95.5},{14.46,92.62},{16.77,89.22},{18.85,87.97},{18.05,87.88},{15.13,89.35},{14.27,89.5},{14.48,86.91},{12.27,89.4},{13.23,89.55},{16.05,89.77},{13.89,87.95},{15.22,86.5},{17.83,89.05},{14.55,86.92},{16.78,87.61},{17.07,87.32},{16.28,86.91},{16.75,87.38},{15.21,87.99},{16.38,93.29},{14.41,92.21},{17.61,90.86},{18.86,89.78},{16.47,90.89},{15.69,92.79},{12.96,93.95},{14.33,94.54},{16.06,95.61},{18.57,94.1},{16.42,93.54}}},nil,45,nil,nil,74,nil,nil,0},
[2596] = {'Daggerspine Sorceress',633,633,27,27,0,{[45]={{17.76,95.13},{11.18,89.53},{15.12,92.69},{13.86,87.63},{14.54,86.68},{13.8,87.53},{15.74,86.92},{17.18,87.55},{17.02,92.44},{15.95,87.16},{12.25,92.27},{17.64,95.03}}},nil,45,nil,nil,74,nil,nil,0},
[2597] = {'Lord Falconcrest',1200,1200,27,27,0,{[45]={{19.46,67.62}}},nil,45,nil,nil,16,nil,"Syndicate Leader",0},
[2598] = {'Darbel Montrose',897,897,26,26,4,{[45]={{21.68,66.13},{19.38,64.26}}},nil,45,nil,nil,16,nil,"Shadow Council Warlock",0},
[2599] = {'Otto',1040,1040,27,27,0,{[45]={{19.66,67.49}}},nil,45,nil,nil,16,nil,"Bodyguard",0},
[2600] = {'Singer',1035,1035,27,27,4,{[45]={{27.49,27.92},{27.57,27.77}}},nil,45,nil,nil,16,nil,nil,0},
[2601] = {'Foulbelly',1035,1035,27,27,4,{[45]={{12.94,67.34},{14.16,67.89}}},nil,45,nil,nil,45,nil,nil,0},
[2602] = {'Ruul Onestone',1408,1408,29,29,4,{[45]={{11.19,70.87},{18.79,30.67}}},nil,45,nil,nil,45,nil,nil,0},
[2603] = {'Kovork',1500,1500,26,26,4,{[45]={{24.21,44.43},{24.08,44.67}}},nil,45,nil,nil,45,nil,nil,0},
[2604] = {'Molok the Crusher',1125,1125,26,26,4,{[45]={{47.68,82.62},{47.8,76.5}}},nil,45,nil,nil,45,nil,nil,0},
[2605] = {'Zalas Witherbark',1380,1380,27,27,4,{[45]={{62.42,82.89},{62.9,81.15}}},nil,45,nil,nil,654,nil,"Warband Leader",0},
[2606] = {'Nimar the Slayer',1125,1125,26,26,4,{[45]={{68.62,66.99},{68.59,66.75}}},nil,45,nil,nil,654,nil,"Warband Leader",0},
[2607] = {'Prince Galen Trollbane',1640,1640,44,44,0,nil,nil,0,nil,nil,11,"A",nil,0},
[2608] = {'Commander Amaren',2138,2138,44,44,0,{[45]={{39.97,47.73},{39.93,48.31}}},nil,45,{26113},{26117},123,"A",nil,2},
[2609] = {'Geomancer Flintdagger',1056,1056,29,29,4,{[45]={{19,30.8}}},nil,45,nil,nil,14,nil,nil,0},
[2610] = {'Shakes O\'Breen',1753,1753,40,40,0,{[45]={{25.93,83.86}}},nil,45,{26628},{663,667,668,670,26052,26109,26336,26628},390,"AH","Blackwater Raiders",2},
[2611] = {'Fozruk',1910,1910,30,30,0,{[45]={{43.67,67.08}}},{[45]={{{67.8,37.66},{67.28,38.15},{66.29,39.16},{65.44,40.06},{65.06,41.04},{64.69,41.25},{63.55,43.23},{63.66,41.81},{63.07,42.32},{62.21,42.87},{61.51,43.39},{60.49,44.35},{59.67,45.28},{58.86,46},{58.3,47.66},{57.13,47.69},{55.8,47.39},{54.74,47.76},{53.7,48.61},{52.76,49.96},{52.48,51.49},{52.42,52.68},{52.29,53.93},{51.82,55},{51.6,56.3},{51.45,57.5},{50.89,58.5},{50.16,59.57},{48.9,60.41},{48.28,61.82},{46.87,61.76},{45.97,61.44},{45.12,60.56},{44.2,59.76},{42.84,59.19},{41.91,58.86},{40.81,58.52},{40.23,58.18},{39.58,56.3},{38.78,56.06},{37.78,56.11},{36.12,55.69},{34.79,55.55},{33.57,55.63},{32.14,55.76},{31.14,55.53},{30.34,54.64},{30.21,53.89},{29.99,52.1},{29.91,51.07},{27.06,49.57},{25.99,48.1},{25.03,45.68},{23.65,43.11},{23.86,43.3},{23.6,42.17},{23.34,40.97},{23.13,39.69},{22.97,38.53},{22.93,36.92},{23.2,35.78},{23.36,35.26},{23.56,34.73},{23.93,33.59},{24.22,32.92},{24.6,31.7},{24.47,30.74},{25.06,30.54},{25.6,30.23},{25.56,29.97},{26.64,29.87},{26.86,29.42},{27.64,28.55},{28.11,28.97},{28.8,29.62},{29.67,30.93},{29.8,31.94},{31.77,33.37},{32.65,33.5},{33.67,33.39},{34.26,32.49},{34.93,30.97},{35.55,29.95},{35.98,29.05},{36.5,28.72},{37.2,28.35},{38.04,28.12},{38.82,28.36},{39.29,28.87},{39.91,29.2},{40.64,29.63},{41.18,29.99},{41.9,30.4},{42.41,31.18},{42.93,32.02},{43.78,32.66},{44.36,33.42},{44.94,33.93},{45.49,34.16},{45.91,34.29},{46.61,34.46},{47.59,34.89},{48.49,35.25},{48.93,35.64},{49.31,36.43},{49.85,37.07},{50.35,37.14},{51.23,37.24},{52.03,37.21},{53.18,36.17},{53.77,35.24},{54.5,34.52},{55.16,34.34},{55.95,34.26},{56.51,34.17},{57.24,33.96},{57.63,34.3},{58.19,34.93},{59.31,36.12},{60.25,36.07},{60.76,35.12},{61,34.73},{61.4,34.17},{62.14,33.7},{62.59,34.41},{63.39,35.36},{63.92,35.92},{64.83,36.44},{65.71,36.94},{66.51,37.41},{67.05,37.77},{67.46,38.3}}}},45,nil,nil,15,"AH",nil,0},
[2612] = {'Lieutenant Valorcall',1380,1380,27,27,0,{[45]={{37.8,55.93}}},{[45]={{{33.45,52.12},{34.15,52.21},{34.62,52.26},{35.29,52.4},{35.84,52.55},{36.55,52.76},{37.33,53.06},{38.18,53.44},{38.79,54.09},{39.24,54.53},{39.71,54.85},{40.38,54.88},{40.79,54.91},{41.18,54.9},{41.72,54.9},{42.16,54.92},{42.94,54.96},{43.48,55.68},{43.64,55.08},{43.89,54.25},{44.01,53.86},{44.32,53.36},{44.34,53.01},{44.3,52.62},{44.26,52.38},{44.19,51.98},{44.03,51.63},{44,51.22},{43.95,50.76},{43.92,50.35},{44.11,49.64},{44.22,49.25},{44.33,48.83},{44.46,48.38},{44.69,48.09},{44.91,47.75},{45.12,47.44},{45.5,47},{45.89,46.67},{46.14,46.44},{46.48,46.17},{46.98,45.94},{47.18,45.81},{47.4,45.63},{47.77,45.3},{48.06,45.04},{48.38,44.77},{48.73,44.28},{49.08,43.97},{49.38,44.12},{49.73,44.31},{50.27,44.63},{50.47,44.71},{50.77,44.56},{51.07,44.42},{51.37,44.35},{51.59,44.12},{51.8,43.49},{52.02,42.76},{52.18,42.31},{52.29,41.85},{52.4,41.48},{52.49,41.18},{52.6,40.94},{52.74,40.66},{52.99,40.6},{53.32,40.79},{53.71,40.88},{54.04,40.7},{53.76,40.92},{53.49,40.82},{53.12,40.61},{52.8,40.57},{52.56,40.93},{52.43,41.35},{52.29,41.88},{52.14,42.48},{51.92,42.97},{51.79,43.44},{51.54,44.13},{51.16,44.32},{50.8,44.49},{50.39,44.6},{49.94,44.35},{49.39,44.07},{48.93,43.98},{48.65,44.4},{48.36,44.72},{48.14,44.92},{47.85,45.18},{47.59,45.49},{47.28,45.72},{46.9,45.94},{46.53,46.18},{45.67,46.82},{45.32,47.17},{45.02,47.52},{44.64,48.11},{44.32,48.91},{44.14,49.43},{43.94,50.11},{43.92,50.61},{44.01,51.36},{44.21,52.04},{44.31,52.54},{44.38,53.15},{44.07,53.75},{43.82,54.3},{43.64,55.14},{43.35,55.37},{42.81,55},{42.23,54.9},{41.58,54.88},{40.78,54.86},{39.97,54.84},{39.24,54.51},{38.65,53.89},{37.91,53.28},{37.36,53.03},{36.78,52.77},{35.92,52.52},{35.36,52.38},{34.84,52.26},{34.24,52.19},{33.56,52.11},{33.01,52.07},{32.48,52.02},{31.63,51.88},{31.03,51.84},{30.51,51.52},{29.74,51.04},{29.05,50.65},{28.05,50.09},{27.18,49.89},{26.98,50.49},{26.74,51.29},{26.41,52.35},{26.15,53.41},{25.98,54.24},{25.94,54.75},{25.98,55.24},{26.07,55.81},{26.07,56.83},{26.06,57.56},{26.07,58.53},{26.08,59.12},{26.09,59.7},{25.59,60.05},{24.86,60.3},{24.22,60.53},{23.73,60.56},{22.95,60.48},{22.59,61.13},{22.26,61.94},{22.06,62.13},{20.99,62.29},{20.99,62.31},{22.01,62.21},{22.26,61.76},{22.82,60.47},{23.36,60.5},{23.96,60.52},{23.96,60.52},{24.4,60.48},{24.65,60.38},{25.13,60.27},{26,59.83},{26.08,59.04},{26.08,58.17},{26.08,57.57},{26.08,56.96},{26.05,55.59},{26.03,55.3},{25.94,54.58},{25.95,54.25},{26.2,53.15},{26.43,52.22},{26.71,51.29},{26.97,50.34},{27.18,49.75},{27.56,49.89},{28.11,50.17},{28.66,50.47},{29.21,50.76},{29.75,51.08},{30.2,51.35},{30.93,51.75},{31.6,51.91},{32.09,51.99},{32.57,52.06},{32.87,52.08}}}},45,nil,nil,123,"A",nil,0},
[2614] = {'Air Force Alarm Bot (Alliance)',5600,7000,70,70,0,{[3483]={{23.81,37.21},{22.96,37.2},{55.41,59.63},{56.27,59.84},{56.82,61.18},{57.41,62.46},{55.02,60.73},{54.29,60.3},{53.68,61.55},{53.24,62.98},{55.43,61.64},{57.65,64.02},{57.01,63.19},{56.58,65.32},{53.35,65.67},{56.63,64.31},{54.17,62.56},{55.71,62.95},{54.82,63.24},{54.22,63.25},{53.88,65.12},{53.89,63.65},{55.9,63.76},{54.78,63.8},{54.04,64.71},{54.24,65.93},{53.71,66.5},{55.97,65.05},{54.63,65.56},{55.85,65.97},{57.42,65.55},{56.27,67},{56.99,66.34}},[3518]={{53.17,69.63},{53.05,70.79},{54.96,69.58},{54.26,70.71},{52.87,72.35},{54.33,72.68},{53.85,76.15},{56.2,73.85},{55.84,70.65}},[3519]={{55.48,54.07},{56.3,56.24},{55.73,55},{56.78,57.23},{57.63,55.48},{57.45,56.13},{60.07,55.98},{59.19,55.83},{56.59,54.91},{57.39,55.63},{57.1,52.57},{56.64,53.12},{58.84,53.05},{57.91,52.84}},[3520]={{35.97,57.47},{37.07,57.5},{36.49,56.64},{36.13,54.79},{37.08,53.47},{38.3,52.61},{38.85,55.25},{39.28,54.42},{37.59,53.35},{40.54,54.45}},[3521]={{43.05,27.27},{40.83,28.67},{40.75,27.63},{41.96,26.43},{70.02,49.29},{68.16,47.21},{69.18,49.34},{68.93,50.31},{66.88,48.27},{68.3,48.58},{67.25,49.35},{67.79,51.68},{67.95,50.93},{66.77,49.35},{67.09,50.65},{69.72,48.6},{68.77,50.22},{70.34,50.5}},[3522]={{60.99,67.88},{61.32,68.88},{60.36,68.56},{60.83,69.62},{60.84,71.14},{36.19,64.41},{35.93,65.9},{35.75,63.8},{36.25,66.09},{36.29,65.58},{35.94,67.75},{37.39,64.85},{37.71,65.88},{37.69,63.83},{38.23,64.83},{39.37,64.74},{37.04,68.7}}},nil,3483,nil,nil,11,"A",nil,0},
[2615] = {'Air Force Alarm Bot (Horde)',7685,7685,70,70,0,{[3483]={{28.29,60.24},{54.36,41.57},{54.16,41.33},{56.3,37.95},{53.08,38.29},{55.38,38.21},{55.12,37.01},{54.16,37.91},{54.94,35.08},{54.44,36.28},{55.75,35.97},{57.09,36.62},{57.26,37.91}},[3518]={{54.8,32.78},{53.3,33.02},{52.49,36.1},{52.85,35.05},{53.26,37.54},{55.14,34.8},{54.76,39.65},{60.32,35.51},{59.58,37.49},{58.2,35.62},{56.54,34.99},{57.18,34.78},{58.89,35.23},{57.04,33.81},{56.38,34.03},{57.2,41.42}},[3519]={{48.5,45.72},{48.08,44.89},{48.96,46.74},{48.63,44.28},{49.54,45.15},{49.04,45.1},{50.03,46.32},{49.77,43.21},{50.67,43.1},{51.12,43.95}},[3520]={{31.07,31.14},{29.64,31.26},{28.82,28.83},{29.07,29.27},{28.47,26.4}},[3521]={{32.29,47.09},{30.16,52.06},{30.33,48.99},{31.15,49.02},{31.31,51.09},{31.63,49.88},{32.19,52.6},{32.31,48.95},{32.38,49.87},{32.57,50.68},{33.51,50.15},{85.48,54.59},{86.25,53.77},{84.9,54.59},{84.32,54.37}},[3522]={{52.39,59.26},{53.47,58.77},{53.04,52.96},{53.84,54.81},{53.77,55.99},{53.16,54.93},{53.24,55.94},{50.76,54.53},{51.1,57.53}}},nil,3518,nil,nil,125,"H",nil,0},
[2616] = {'Privateer Groy',1981,1981,42,42,0,{[15]={{67.72,51.71}}},nil,15,nil,{623},120,"AH",nil,0},
[2618] = {'Hammerfall Peon',600,600,26,27,0,{[45]={{57.85,59.07},{58.4,60.37},{58.11,60.94},{57.42,59.59},{56.05,58.45},{56.7,58.49},{55.4,58.85},{56.16,59.41},{55.93,59},{56.11,57.32},{58.28,59.22},{54.41,57.94},{57.21,57.32},{57.92,60.41},{56.91,57.8},{57.32,57.61},{58.29,59.62},{56.23,56.9},{56.59,57.21},{54.07,58.83},{57.41,61.04},{55.84,60.65},{54.26,60.14},{54.93,57.61},{55.32,59.52},{55.82,60.63},{54.5,58.85},{55.23,60.97},{54.43,57.99},{55.31,58.96},{55.31,59.59},{55.23,60.84},{54.07,58.88},{54.47,58.84}}},nil,45,nil,nil,83,"H",nil,0},
[2619] = {'Hammerfall Grunt',853,853,27,28,0,{[45]={{59.68,60.89},{59.86,61.59},{55.61,57.77},{57.52,57.26},{54.28,58.77},{58.12,57.33},{56.79,58.46},{56.16,61.94},{58.79,60.13},{57.92,62.73},{56.19,61.74},{53.3,58.63},{52.83,57.77},{55.37,53.54},{54.37,56.77},{54.94,53.56},{56.79,55.82},{56.61,62.48},{55.59,61.51}}},nil,45,nil,nil,83,"H",nil,0},
[2620] = {'Prairie Dog',8,8,1,1,0,{[17]={{70.66,59.03},{58.43,41.33},{65.31,49.92},{64.63,46.44},{65.73,42.65},{67.08,44.97},{66.4,61.12},{53.55,54.98},{46.62,53.96},{56.21,58.21},{46.82,58.5},{47.74,44},{67.18,63.58},{52.42,59.16},{51.29,61.61},{48.26,52.07},{43.41,51.3},{47.3,53.62},{61.17,48.64},{64.39,59.86},{58.24,49.07},{57.8,45.77},{53.17,53.94},{52.73,53.52},{64.15,68.69},{66.07,61.32},{56.99,62.21},{46.8,66.55},{65.33,67.18},{53.27,68.84},{45.54,68.34},{66.97,64.37},{52.23,64.6},{51.9,63.36},{48.93,64.85},{38.67,52.02},{42.78,40.09},{25.92,32.86},{39.39,60.05},{48.81,40.72},{39.38,32.71},{48,43.81},{42.99,68.48},{33.94,33.72},{41.29,45.85},{47.77,70.49},{38.07,35.37},{45.72,67.97},{36.02,41.14},{30.38,39.15},{42.29,70.06},{34.83,54.34},{26.93,30.47},{34.42,54.02},{33.4,52.15},{37.35,63.1},{37.52,61.45},{39.79,48.65},{65.45,27.08},{61.04,30.15},{57.97,16.87},{61.88,19.71},{57.74,16.38},{57.83,16.54},{53.18,31.17},{61.74,19.76},{51.91,72.4},{52.39,88.53},{66.59,77.35},{61.01,79.02},{47.81,70.35},{55.28,87.35},{61.36,79.11},{60.21,74.79},{67.36,78.06},{51.92,87.85},{51.38,85.11},{50.3,67.3},{60.05,74.67},{50.31,71.44},{48.98,64.29}},[40]={{57.82,66.62},{63.86,68.26},{44.29,39.39},{57.92,36.82},{63.35,43.69},{49.02,51.76},{45.97,53.19},{33.28,39.58},{55.49,62.15},{39.91,33.01},{57.79,59.38},{49.95,56.4},{47.73,37.38},{53.89,34.66},{59.33,64.31},{57.08,67.82},{64.71,67.81},{31.46,59.85},{57.23,71.7},{68.01,74.9},{39.3,79.59},{39.05,69.09},{46.84,56.59},{49.22,51.64},{46.27,53.44},{33.43,40.19},{55.01,61.06},{35.89,61.34},{47.12,72.92},{29.63,63.05},{51.22,62.98},{50.65,56.43},{59.12,65.07},{36.44,52.11}},[45]={{55.31,51.69},{55.84,51.3},{55.32,51.54},{19.1,25.33},{18.99,25},{18.92,24.84},{65.72,47.77},{64.98,47.89},{65.72,47.13},{25.71,40.03},{25.71,40.59},{26.48,40.6},{25.51,40.74},{25.82,40.23},{47.56,45.39},{47.74,45.29},{48.62,46.25},{47.97,47.17},{48.52,46.38},{30.79,39.38},{31.06,39.17},{31.3,39.27},{31.26,39.05},{19.17,24.35},{18.84,26},{18.81,24.52},{21.9,22.02},{21.97,21.66},{22.58,23.06},{31.4,37.97},{37.2,40.63},{37.11,39.62},{36.69,40.19},{47.67,45.46},{47.55,46.62},{48.05,46.21},{53.43,52.92},{53.6,52.35},{53.27,52.54},{23.23,21.61},{23.22,21.96},{23.47,22.04},{22.9,21.91},{22.92,21.94},{65.88,46.79},{65.21,47.39},{65.61,47.48},{66,47.74},{65.99,46.25},{61.25,52.63},{61.8,52.39},{61.21,52.19},{62.08,52.31},{61.62,52.7},{37.15,39.25},{37.14,39.38},{37.43,39.29},{57.22,39.31},{58,39.09},{57.9,38.96},{57.28,39},{21.29,34.59},{21,33.56},{20.92,33.36},{21.44,33.16},{20.96,33.33},{57.41,39.03},{57.45,38.96},{12.84,44.05},{12.62,44.17},{12.77,43.94},{57.87,39.18},{57.33,39.24},{35.27,64.06},{35.3,64.31},{34.68,64.38},{52.59,62.18},{52.87,62.97},{52.48,62.08},{52.67,62.15},{52.32,62.05},{40.58,55.08},{40.42,55.06},{40.69,55.06},{36.93,61.76},{37.05,62.97},{36.56,62.24},{54.22,52.06},{53.6,53.21},{35.26,53.09},{35.19,52.65},{35.35,53.75},{52.12,66.77},{47.77,56.56},{35.37,53.35},{30.48,38.97},{31.03,38.12},{30.82,40.03},{30.76,39.14},{30.95,39.03},{52.15,67.18},{49.34,57.87},{35.49,52.81},{48.65,55.94},{13.14,45.12},{13.49,46.2},{12.08,43.77},{12.13,44.11},{48.47,56.79},{16.16,49.22},{13.13,45.01},{15.62,49.22},{52.32,67.79},{48.07,56.51},{26.98,65.32},{27.43,64.12},{27.3,64.18},{27.85,65.12},{27.47,64.64},{27.47,64.37},{27.99,64.83},{27.48,64.4},{27.45,63.9},{42.56,79.07},{43.43,78.24},{43,77.94},{47.73,69.53},{47.84,69.65},{47.85,69.48},{42.69,79.92},{43.19,81.47},{43.07,81.17},{43.23,81.45},{43.26,81.65},{41.14,78.31},{41.13,78.32},{41.12,78.36},{43.13,78.01},{43.18,77.4},{47.98,69.81},{48,69.79},{48.01,69.81},{47.99,69.82},{48,69.84},{47.61,69.52},{47.71,69.54},{25.84,41.72},{12.17,44.17},{36.83,63.43},{35.2,52.5},{35.23,52.15},{35.32,53.07},{36.09,53.26},{40.52,54.66},{40.63,54.94},{40.85,54.87},{12.67,43.66},{12.84,43.46},{12.22,44.43},{13.28,43.41},{13.34,45.65}},[215]={{40.28,66.68},{55.34,86.58},{53.16,13.28},{49.92,46.5},{57.48,48.07},{45.07,51.59},{44.06,90.35},{40.05,36.09},{43.05,74.16},{49.85,74.78},{52.36,77.85},{41.3,70.61},{59.11,24.95},{51,11.05},{51.68,20.51},{56.34,50.7},{47.47,80.32},{50,87.91},{48.06,63.04},{36.81,77.43},{43.47,18.83},{50.36,57.29},{45.34,81.86},{43.75,78.25},{52,58.52},{43.01,52.94},{43.78,65.78},{46.17,68.21},{54.27,49.65},{42.97,80.03},{43.72,65.85},{57.41,60.75},{55.36,29.12},{57.65,61.12},{54.15,48.77},{53.44,32.87},{50.4,14.38},{45.85,46.99},{53.13,32.74},{51.1,63.86},{49.35,22.86},{51.86,17.1},{50.38,14.74}},[406]={{63.74,94.37},{63.87,94.37}},[1638]={{31.95,38.96}},[3518]={{49.2,61.49},{49.83,61.85},{32.63,64.75},{37.01,64.25},{43.3,63.22},{40.76,73.03},{41.24,72.1},{39.15,76.63},{36.45,78.59},{35.54,79.26},{29.27,71.49},{30.99,70.37},{29.92,64.13},{32.8,65.85},{29.85,63.78},{28.01,56.9},{27.96,57.03},{31.08,34.04},{34.01,25.71},{33.85,25.84},{67.59,39.41},{67.69,39.73},{71.15,62.03},{71.42,62.95},{62.04,73.96},{61.83,73.89},{35.98,40.7},{35.93,40.69}},[4709]={{66.73,38.27},{43.15,75.77},{49.61,46.26},{48.11,73.09},{44.65,87.51},{43.52,80.81},{51.84,49.19},{43.38,44.83},{51.44,51.83},{49.14,80.03},{56.47,39.27},{43.63,55.95},{48.79,83.32},{41.51,54.84},{42.75,73.44},{49.57,79.13},{48.63,59.21},{48.85,47.68},{46.25,56.52},{44.1,79.27},{51.43,49.81},{50.88,54.35},{40.68,81.14},{51.27,54.77},{45.47,48.04},{44.38,81.34},{40.95,48.67},{43.17,48.98},{48.81,56.47},{44.14,76.78},{51.47,53.61},{50.21,52.47},{51.27,51.64},{46.4,79.39},{41.89,50.02},{44.67,74.51},{49.89,54.23},{51.49,53.59},{51.84,38.88},{43.13,52.92},{42.65,84.3},{44.92,42.87},{40.29,18.37}}},nil,45,nil,nil,31,"AH",nil,0},
[2621] = {'Hammerfall Guardian',1525,1525,35,35,0,{[45]={{69.94,35.96},{69.38,31.01},{68.8,32.86},{68.8,32.46},{68.41,31.01},{68.78,29.73},{68.28,30.33},{69.44,29.71},{69.35,29.63},{68.73,31.02},{70,35.96},{68.3,31.09},{69.63,35.6},{69.87,31},{68.36,37.35},{67.57,36.1},{68.05,34.28},{69.88,39.36},{69.47,39.19},{69.58,38.39},{69.41,37.41},{69.8,38.69}}},nil,45,nil,nil,85,"H",nil,0},
[2622] = {'Sly Garrett',1919,1919,46,46,0,{[5287]={{43.09,72.99}}},nil,5287,nil,nil,120,"AH","Shady Goods",1152},
[2623] = {'Spirit of Old',1,1,32,33,0,nil,nil,0,nil,nil,76,"AH",nil,0},
[2624] = {'Gazban',1075,1075,40,40,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2625] = {'Viznik Goldgrubber',7842,7842,55,55,0,{[5287]={{40.07,72.57}}},nil,5287,nil,nil,120,"AH","Banker",131072},
[2626] = {'Old Man Heming',1716,1716,43,43,0,{[5287]={{41.49,73.53}}},nil,5287,nil,nil,120,"AH","Fishing Supplies",128},
[2627] = {'Grarnik Goodstitch',1163,1163,34,34,0,{[5287]={{43.68,73.01}}},nil,5287,nil,nil,120,"AH","Tailoring Trainer",81},
[2628] = {'Dalaran Worker',356,356,16,16,0,{[267]={{32.91,42.43},{28.28,44.2},{32.77,30.57},{28.71,45.41},{34.68,32.73},{30.73,44.91},{33.76,41.22},{34.82,31.69},{33.86,30.17},{33.55,31.34},{33.87,31.68},{34.41,33.6},{33.35,33.44},{33.87,32.65},{32.96,31.67},{31.98,43.16},{31.03,43.37},{28.46,43.64},{31.41,44.02},{31.62,44.54},{33.14,42.82},{32.61,43.29},{34.43,36.3},{35.02,34.36},{34.6,34.94},{32.69,44.12},{29.26,42.69},{27.5,41.18},{28.02,41.95},{28.58,42.86},{27.83,42.95},{29.97,44.41},{29.48,43.28},{28.92,43.58},{30.5,43.69},{29.58,44.86},{31.91,31.91},{32.41,32.06},{34.3,35.6},{34.98,35.68},{33.37,32.92},{27.57,41.58}}},nil,267,nil,nil,76,"AH",nil,0},
[2630] = {'Earthbind Totem',5,5,35,85,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2634] = {'Princess Poobah',1651,1651,42,42,0,{[5287]={{59.46,79.05}}},nil,5287,{26604,26605,26606},{594,630,26603,26604,26605,26606},35,"AH",nil,2},
[2635] = {'Elder Snapjaw Crocolisk',853,853,27,28,0,{[5339]={{48.44,36.44},{50.38,34.57},{49.69,35.73}}},nil,5339,nil,nil,14,nil,nil,0},
[2636] = {'Blackwater Deckhand',1604,1678,38,39,0,{[45]={{25.03,83.17},{26.89,83.95},{26.48,84.47},{26.87,83.93},{25.03,83.16},{26.48,84.49},{26.87,83.96},{26.89,83.95},{26.88,83.96},{26.88,83.96},{26.88,83.95},{26.88,83.96},{26.87,83.95},{26.89,83.95},{25.24,83.18},{26.1,82.63},{25.94,82.89},{26.88,83.97},{26.88,83.97},{26.46,84.52},{26.49,84.52},{26.87,83.96},{26.48,84.5},{26.47,84.52},{26.9,83.96},{26.88,83.96},{26.88,83.95},{26.47,84.52}}},nil,45,nil,nil,121,"AH",nil,0},
[2637] = {'Syndicate Bomb',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2638] = {'Syndicate Spectre',1037,1037,35,35,0,nil,nil,0,nil,nil,87,nil,nil,0},
[2639] = {'Vilebranch Axe Thrower',1163,1163,34,35,0,{[47]={{43.43,68.36},{45.32,69.56},{48.64,63.11},{43.48,65.43},{43.57,66.97},{46.22,66.82},{47.66,63.14},{50.31,64.34},{46.84,61.84}}},nil,47,nil,nil,795,nil,nil,0},
[2640] = {'Vilebranch Witch Doctor',888,888,32,33,0,{[47]={{68.94,69.35},{47.57,69.52},{65.06,68.35},{68.52,70.25},{65.7,70.39},{67.35,68.71},{65.9,68.6},{65.84,68.58},{67.38,68.75},{68.9,69.37},{65.61,70.2},{65.06,68.37}}},nil,47,nil,nil,795,nil,nil,0},
[2641] = {'Vilebranch Headhunter',1110,1110,32,33,0,{[47]={{68.76,70.65},{66.16,70.89},{66.62,70.66},{66.61,71.03},{64.88,69.55},{65.23,68.42},{65.97,70.64},{67.71,70.81},{65.32,67.46},{68.35,70.85},{66.15,70.88},{66.6,71.05},{67.68,70.83},{66.64,70.64},{67.9,70.63},{65.32,67.43}}},nil,47,nil,nil,795,nil,nil,0},
[2642] = {'Vilebranch Shadowcaster',835,835,32,33,0,{[47]={{67.99,73.25},{64.19,72.21},{64.26,65.75},{63.65,67.66},{63.69,71.36},{63.49,65.73},{65.28,73.35},{64.98,71.25},{65.68,72.21},{63.67,67.66}}},nil,47,nil,nil,795,nil,nil,0},
[2643] = {'Vilebranch Berserker',1110,1110,32,33,0,{[47]={{66.25,71.98},{67.11,71.94},{63.83,66.78},{63.23,66.59},{64.58,72.77},{64.22,71.65},{68.13,71.78},{64.52,70.55},{64,70.59},{66.53,72.86},{64.23,69.85},{66.09,73.44},{63.34,70.48},{64.33,66.65},{63.48,68.12},{64.34,67.58},{68.2,72.61},{63.8,66.79},{68.19,72.59},{63.48,68.12}}},nil,47,nil,nil,795,nil,nil,0},
[2644] = {'Vilebranch Hideskinner',1110,1110,33,33,0,{[47]={{62.09,69.21},{62.07,66.43},{68.31,75.23},{65.43,75.59},{67.49,76.21},{64,78.57},{59.2,70.21},{66.03,74.53},{64.41,74.07},{62.73,70.82},{63.56,73.12},{59.95,66.73},{57.23,72.97},{65.04,77.08},{61.27,68.33}}},nil,47,nil,nil,795,nil,nil,0},
[2645] = {'Vilebranch Shadow Hunter',928,928,33,33,0,{[47]={{62.72,68.69},{62.05,68.25},{65.03,75.83},{66.58,74.37},{62.47,65.34},{62.57,66.01},{68.01,74.69},{62.18,70.21},{68,75.79},{57.73,69.38},{63.67,73.64},{62.43,72.21},{65.98,75.57},{64.91,74.39},{63.19,73.03},{62.4,71.54},{64.89,81.11},{64.92,81.15},{58.24,66.27}}},nil,47,nil,nil,795,nil,nil,0},
[2646] = {'Vilebranch Blood Drinker',1110,1110,33,33,0,{[47]={{58.41,68.1},{67.06,80.91},{60.4,73.97},{58.79,68.25},{67.83,77.52},{66.59,81.29},{66.81,79.95},{67.04,78.04},{58.41,67.12},{60.79,67.83},{64.59,82.18},{63.57,84.04},{63.13,83.37},{65.99,82.37},{65.87,80.42},{60.75,68.72},{62.9,77.81},{65.18,82.14},{63.51,79.77},{62.86,78.17},{64.14,83.24},{61.62,72.45},{63.51,82.19},{61.3,72.14},{67.24,77.54},{58.29,72.78},{60.43,68.2},{60.43,64.53}}},nil,47,nil,nil,795,nil,nil,0},
[2647] = {'Vilebranch Soul Eater',928,928,33,33,0,{[47]={{67.71,78.02},{58.76,67.11},{67.36,80.26},{60.54,67.59},{60.77,64.55},{66.11,79.92},{65.63,82.49},{59.94,74.16},{63.3,82.61},{63.34,80.26},{61.43,72.81},{57.96,71.71},{57.99,72.82},{60.21,71.56},{60.8,65.62},{60.76,64.56}}},nil,47,nil,nil,795,nil,nil,0},
[2648] = {'Vilebranch Aman\'zasi Guard',1110,1110,33,33,0,{[47]={{60.26,78.69},{57.12,67.98},{57.05,68.76}}},nil,47,nil,nil,795,nil,nil,0},
[2649] = {'Witherbark Scalper',1900,1902,40,41,0,nil,nil,0,nil,nil,654,nil,nil,0},
[2650] = {'Witherbark Zealot',1981,2800,41,42,0,nil,nil,0,nil,nil,654,nil,nil,0},
[2651] = {'Witherbark Hideskinner',2000,2059,42,43,0,nil,nil,0,nil,nil,654,nil,nil,0},
[2652] = {'Witherbark Venomblood',2000,2059,43,43,0,nil,nil,0,nil,nil,654,nil,nil,0},
[2653] = {'Witherbark Sadist',2100,2218,44,45,0,nil,nil,0,nil,nil,654,nil,nil,0},
[2654] = {'Witherbark Caller',1618,1679,35,35,0,nil,nil,0,nil,nil,654,nil,nil,0},
[2655] = {'Green Sludge',1258,1258,31,31,0,{[47]={{59.97,41.37},{59.41,42.01},{55.74,44.62},{59.81,43.01},{56.9,43.65},{60.34,41.87},{56.93,44.32},{55.55,44.04},{56.19,39.06},{58.33,42.04},{58.28,41.92},{58.83,45.52},{58.38,41.61},{58.12,40.73},{57.41,42.6},{58.91,43.36},{57.93,42.52},{57.43,38.9},{57.73,43.58},{55.51,44.05},{55.71,44.56},{55.85,42.89}}},nil,47,nil,nil,14,nil,nil,0},
[2656] = {'Jade Ooze',1258,1258,31,32,0,{[47]={{60.29,42.57},{56.51,40.78},{59.2,43.16},{58.98,39.44},{57.82,42.63},{59.78,44.34},{57.89,43.98},{56.53,44.42},{57.27,44.39},{57.53,46.04},{58.03,45.37},{56.49,43.6},{55.76,41.06},{56.71,42.57},{59.24,41.7},{59.97,42.85},{58.09,41.92},{58.09,40.79},{58.6,39.77},{58.36,38.59},{57.67,40.01},{56.76,42.6},{57.37,43.61},{56.93,42.11},{55.97,42.69},{56.27,42.46},{56.52,45.06},{56.87,43.03},{60.12,42.66},{59.83,44.37}}},nil,47,nil,nil,14,nil,nil,0},
[2657] = {'Trained Razorbeak',1464,1464,35,35,0,{[47]={{27.75,60.29},{25.41,58.02},{23.83,56.06},{27.04,56.43},{17.8,48.24},{17.36,50.52},{16.78,50.15},{20.93,55.25},{22.01,51.46},{18.22,53.46},{17.94,53.17},{20.75,55.11},{19.72,53.1},{22,51.43},{18.69,52.96},{23.84,56.17},{25.35,57.84},{12.32,51.81},{21.92,51.41},{19.99,50.42}}},nil,47,nil,nil,84,"A",nil,0},
[2658] = {'Razorbeak Gryphon',1110,1110,33,33,0,{[47]={{35.13,45.76},{47.04,48.47},{26.81,56.84},{50.78,58.62},{43.3,60.41},{38.38,47.33}}},nil,47,nil,nil,1055,"A",nil,0},
[2659] = {'Razorbeak Skylord',1454,1454,34,34,0,{[47]={{56.24,51.86},{53.96,47.99},{63.09,48.6}}},{[47]={{{54.24,49.46},{54.08,49.68},{54.09,50.11},{54.16,50.65},{54.12,51.08},{54.1,51.67},{54.3,51.92},{54.52,52.32},{54.8,52.84},{54.47,53.07},{54.22,53.16},{53.91,52.97},{53.52,52.87},{53.3,52.64},{52.99,52.34},{52.54,52.04},{52.5,51.59},{52.41,51.08},{52.21,50.63},{52.09,50.35},{51.97,50.01},{51.76,49.34},{51.73,48.96},{51.71,48.38},{51.7,47.94},{51.56,47.6},{51.27,46.85},{51.09,46.35},{51.13,45.83},{51.22,45.74},{51.67,45.52},{51.93,45.43},{52.3,45.46},{52.88,45.6},{53.23,45.91},{53.54,46.33},{53.67,46.71},{53.82,47.15},{53.94,47.61},{54.08,48.17},{54.22,48.96}}}},47,nil,nil,1055,"A",nil,0},
[2662] = {'Port Master Szik',2666,2666,42,42,0,nil,nil,0,nil,nil,1080,"AH","Boat Vendor",0},
[2663] = {'Narkk',1651,1651,42,42,0,{[5287]={{42.64,69.1}}},nil,5287,nil,nil,120,"AH","Pirate Supplies",129},
[2664] = {'Kelsey Yance',1716,1716,43,43,0,{[5287]={{42.81,68.96}}},nil,5287,nil,nil,120,"AH","Cook",128},
[2665] = {'Proximity Bomb',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2667] = {'Ward of Laze',12,12,25,26,0,nil,nil,0,nil,nil,45,nil,nil,0},
[2668] = {'Danielle Zipstitch',840,840,27,27,0,{[10]={{75.87,45.56}}},nil,10,nil,nil,12,"A","Tailoring Supplies",128},
[2669] = {'Sheri Zipstitch',1107,1107,31,31,0,{[10]={{75.68,45.56}}},nil,10,nil,nil,12,"A","Tailoring Supplies",128},
[2670] = {'Xizk Goodstitch',1716,1716,43,43,0,{[5287]={{43.58,73.08}}},nil,5287,nil,{4781,4785},120,"AH","Tailoring Supplies",131},
[2671] = {'Mechanical Squirrel',644,644,15,15,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2672] = {'Cowardly Crosby',1753,1753,40,40,0,{[5287]={{40.81,82.12}}},nil,5287,nil,nil,35,"AH","Tailoring Supplies",128},
[2673] = {'Target Dummy',64,64,17,17,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2674] = {'Advanced Target Dummy',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2675] = {'Explosive Sheep',405,405,14,17,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2676] = {'Compact Harvest Reaper',100,100,17,29,0,nil,nil,0,nil,nil,47,nil,nil,0},
[2678] = {'Mechanical Dragonling',3184,3184,47,47,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2679] = {'Wenna Silkbeard',1003,1003,28,28,0,{[11]={{25.61,25.8}}},nil,11,nil,nil,55,"A","Special Goods Dealer",4224},
[2680] = {'Vilebranch Wolf Pup',634,634,32,32,0,{[47]={{44.59,65.77},{44.46,64.91},{65.13,70.25},{65.2,72.08},{64.15,66.78},{68.39,68.97},{47.89,65.09},{48.85,63.77},{67.57,70.69},{67.22,72.76},{50.28,65.76},{46.37,69.52},{66.31,69.23},{67.15,70.05}}},nil,47,nil,nil,38,nil,nil,0},
[2681] = {'Vilebranch Raiding Wolf',1110,1110,33,33,0,{[47]={{58.83,64.96},{58.75,64.53}}},nil,47,nil,nil,38,nil,nil,0},
[2682] = {'Fradd Swiftgear',664,664,24,24,0,nil,nil,0,nil,nil,875,"A","Engineering Supplies",128},
[2683] = {'Namdo Bizzfizzle',660,664,24,24,0,{[1]={{28.83,30.07}}},nil,1,nil,nil,875,"A","Engineering Supplies",128},
[2684] = {'Rizz Loosebolt',1107,1107,31,31,0,nil,nil,0,nil,nil,1080,"AH","Engineering Supplies",128},
[2685] = {'Mazk Snipeshot',1277,1277,36,36,0,{[5287]={{43.24,70.23}}},nil,5287,nil,nil,120,"AH","Engineering Supplies",128},
[2686] = {'Witherbark Broodguard',2138,2218,44,45,0,nil,nil,0,nil,nil,312,nil,nil,0},
[2687] = {'Gnaz Blunderflame',1651,1651,42,42,0,{[5339]={{61.04,39.51}}},nil,5339,nil,nil,35,"AH","Engineering Supplies",128},
[2688] = {'Ruppo Zipcoil',3082,3082,52,52,0,{[47]={{34.33,37.76}}},nil,47,nil,nil,35,"AH","Engineering Supplies",128},
[2689] = {'Hill Giant',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2690] = {'Hill Giant Warden',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2691] = {'Highvale Outrunner',2059,2138,43,44,0,nil,nil,0,nil,nil,1802,"A",nil,0},
[2692] = {'Highvale Scout',2138,2218,44,45,0,nil,nil,0,nil,nil,1802,"A",nil,0},
[2693] = {'Highvale Marksman',2399,2400,45,46,0,nil,nil,0,nil,nil,1802,"A",nil,0},
[2694] = {'Highvale Ranger',1800,1990,46,47,0,nil,nil,0,nil,nil,1802,"A",nil,0},
[2695] = {'Sara Balloo',328,328,15,15,0,{[1537]={{63.5,67.3}}},nil,1537,nil,{637},55,"A",nil,0},
[2696] = {'Foggy MacKreel',1003,1003,30,30,0,nil,nil,0,nil,nil,55,"A",nil,2},
[2697] = {'Clyde Ranthal',1107,1107,31,31,0,{[44]={{78.8,63.44}}},nil,44,nil,nil,12,"A","Leatherworking Supplies",4224},
[2698] = {'George Candarte',1107,1107,31,31,0,{[267]={{76.67,58.51}}},nil,267,nil,nil,68,"H","Leatherworking Supplies",128},
[2699] = {'Rikqiz',1716,1716,43,43,0,{[5287]={{43.22,71.73}}},nil,5287,nil,nil,120,"AH","Leatherworking Supplies",128},
[2700] = {'Captain Nials',1902,1902,41,41,0,{[45]={{39.96,48.86}}},nil,45,{26093,26095,26542,26982},{634,681,682,684,685,26024,26079,26093,26095,26139,28573},12,"A",nil,3},
[2701] = {'Dustbelcher Ogre',1604,1678,38,39,0,nil,nil,0,nil,nil,45,nil,nil,0},
[2702] = {'Felhunter Trainer',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","UNUSED",0},
[2703] = {'Zengu',1753,1753,40,40,0,nil,nil,0,nil,{638,639,641,643,644,646},126,"H",nil,0},
[2704] = {'Hanashi',15505,15505,50,50,0,nil,nil,0,nil,nil,876,"H","Weapon Master",81},
[2705] = {'Brewmeister Bilger',1221,1221,33,33,0,nil,nil,0,nil,{647},55,"A",nil,2},
[2706] = {'Tor\'gan',1753,1753,40,40,0,nil,nil,0,nil,{640,655,671,672,673,675,701,847},126,"H",nil,0},
[2707] = {'Shadra',18298,18298,55,55,1,nil,nil,0,nil,nil,22,nil,"The Venom Queen",0},
[2708] = {'Archmage Malin',1753,1753,40,40,0,{[1519]={{50.51,87.47}}},nil,1519,nil,{697},12,"A",nil,1},
[2709] = {'Imp Trainer',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","UNUSED",0},
[2710] = {'Voidwalker Trainer',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","UNUSED",0},
[2711] = {'Phin Odelic',1469,1469,36,36,0,nil,nil,0,nil,{661},123,"A",nil,0},
[2712] = {'Quae',1604,1604,38,38,0,{[45]={{54.82,55.38}}},nil,45,{26110,26114,26117},{658,659,660,26110,26113,26116},123,"A",nil,2},
[2713] = {'Kinelory',1546,1546,29,29,0,{[45]={{54.88,55.45}}},nil,45,{26116},{657,26114},231,"A",nil,2},
[2714] = {'Forsaken Courier',1600,1600,27,27,0,{[45]={{52.75,64.78},{53.05,64.84}}},{[45]={{{52.47,61.53},{52.01,61.26},{51.36,60.59},{50.99,59.85},{50.59,59.7},{50.09,59.38},{49.69,59.28},{49.06,59.24},{48.38,59.35},{47.82,59.55},{47.25,59.75},{46.63,59.72},{46.34,59.57},{45.72,59.15},{45.19,58.78},{44.64,57.76},{44.08,56.76},{43.42,55.63},{43.01,55.08},{42.5,54.92},{41.34,54.87},{40.66,54.87},{39.88,54.81},{39.49,54.78},{38.93,54.22},{38.25,53.48},{37.42,53.06},{36.26,52.63},{35.59,52.45},{34.91,52.29},{34.04,52.17},{33.17,52.07},{32.3,52.02},{31.12,51.8},{30.65,51.6},{29.84,51.12},{29.15,50.7},{28.33,50.24},{27.63,49.84},{27.16,49.68},{26.51,49.11},{26.16,48.41},{25.84,47.68},{25.3,46.29},{25.08,45.83},{24.43,44.74},{24.04,44.1},{23.62,42.98},{23.33,41.74},{23.14,40.87},{22.97,39.88},{22.81,38.81},{22.77,38.08},{22.75,37.03},{22.73,36.01},{22.63,34.65},{22.51,33.62},{22.29,33.14},{22.71,36.29},{22.63,34.37},{22.54,33.65},{22.25,33},{21.87,32.24},{21.39,31.36},{21.09,30.89},{20.93,30.64},{20.16,29.56}}},[267]={{{82.59,57.61},{82.11,57.07},{81.64,56.58},{81.25,56.13},{80.87,55.75},{80.16,55.16},{79.48,54.86},{78.88,54.44},{78.24,53.98},{77.68,53.6},{77.3,53.32},{76.7,52.63},{76.4,52.26},{76.09,51.87},{75.32,50.98},{74.6,50.15},{73.56,49.12},{72.47,48.18},{71,47.18},{70.04,46.57},{68.96,46.05},{68.01,45.41},{67.48,44.83},{67.08,44.29},{66.73,43.76},{66.54,43.51},{66.11,42.97},{65.5,42.34},{64.64,42.08},{64,41.94},{63.27,41.76},{62.82,41.58},{62.32,41.39},{61.68,40.96},{61.16,40.48},{60.89,40.15},{60.52,39.71},{60.23,39.35},{59.75,38.77},{58.71,37.61},{57.72,36.61},{57.41,35.65},{57.27,35.15},{57,34.18},{56.76,33.11},{56.53,32.03},{56.34,30.99},{56.1,29.92},{55.97,28.94},{55.84,27.87},{55.76,26.65},{55.74,25.48},{55.69,24.43},{55.66,23.59},{55.72,22.68},{55.77,21.36},{55.75,20.52},{55.7,19.73},{56.37,19.66},{56.91,19.85},{57.53,19.71},{58.27,19.49},{58.71,20.02},{59.04,20.69},{59.28,21.06},{59.88,21.28},{60.41,21.13},{60.82,20.54},{61.37,20.02},{62.26,20.35},{61.58,20.14},{61.41,20.01},{61.01,20.24},{60.77,20.63},{60.45,21.07},{60.04,21.26},{59.64,21.18},{59.33,21.03},{59.05,20.68},{58.82,20.17},{58.54,19.81},{58.16,19.52},{57.64,19.67},{57.29,19.76},{57.02,19.79},{56.77,19.81},{56.32,19.59},{56,19.6},{55.75,20.73},{55.76,21.5},{55.74,22.72},{55.64,23.57},{55.69,24.9},{55.7,25.89},{55.76,27.22},{55.85,28.02},{56.07,29.88},{56.24,30.5},{56.42,31.53},{56.58,32.4},{56.82,33.49},{57.01,34.19},{57.18,34.78},{57.36,35.45},{57.57,36.11},{57.75,36.71},{58.13,37.09},{59.03,37.98},{59.43,38.4},{60.02,39.17},{60.77,40.07},{61.13,40.49},{61.52,40.87},{62.05,41.26},{62.42,41.45},{62.85,41.62},{63.28,41.78},{63.68,41.89},{64.73,42.09},{65.75,42.6},{66.52,43.48},{66.79,43.94},{67.26,44.6},{67.81,45.24},{68.82,45.93},{69.77,46.41},{70.3,46.7},{71.5,47.55},{72.42,48.14},{73.05,48.68},{73.83,49.38},{74.46,49.93},{75.05,50.64},{75.49,51.18},{75.94,51.68},{76.38,52.15},{76.98,52.92},{77.45,53.42},{78.22,53.98},{78.71,54.34},{79.44,54.83},{79.34,55.12},{80.26,55.3},{80.86,55.74},{81.39,56.29},{82.1,57.05}}}},45,nil,nil,83,"H",nil,0},
[2715] = {'Dustbelcher Brute',1678,1753,39,40,0,nil,nil,0,nil,nil,45,nil,nil,0},
[2716] = {'Dustbelcher Wyrmhunter',1829,1902,40,41,0,nil,nil,0,nil,nil,45,nil,nil,0},
[2717] = {'Dustbelcher Mauler',2388,2388,46,47,0,{[3]={{13.52,69.78},{14.66,68.33},{13.34,63.28},{12.38,61.2},{12.35,60.59},{15.98,59.14},{17.06,63.3},{16.71,62.91},{17.03,61.71},{16.92,65.23},{12.21,68.13},{13.39,66.57},{15.54,60.25},{15.66,63.64},{13.39,63.18},{14.6,61.7},{16.66,65.47}}},nil,3,nil,nil,45,nil,nil,0},
[2718] = {'Dustbelcher Shaman',1910,1910,46,47,0,{[3]={{12.24,64.92},{13.59,71.36},{12.33,63.45},{14.56,64.73},{14.52,61.71},{19.96,66.3},{15.79,63.5},{18.86,65.14},{17.7,66.91},{16.83,62.5},{15.76,66.68}}},nil,3,nil,nil,45,nil,nil,0},
[2719] = {'Dustbelcher Lord',2138,2218,44,45,0,nil,nil,0,nil,nil,45,nil,nil,0},
[2720] = {'Dustbelcher Ogre Mage',1441,1496,43,44,0,nil,nil,0,nil,nil,45,nil,nil,0},
[2721] = {'Forsaken Bodyguard',610,610,35,35,0,nil,nil,0,nil,nil,1801,"H",nil,0},
[2723] = {'Stone Golem',1919,1919,46,46,0,{[3]={{38.65,25.05},{37.97,24.11},{38.71,23.15},{39.55,23.35}}},nil,3,nil,nil,54,nil,nil,0},
[2725] = {'Scalding Whelp',1426,1426,44,45,0,{[3]={{70,49.99},{70.02,47.14},{74.11,46.75},{72.89,45.38},{72.23,47.17},{72.1,44.08},{73.04,48.47},{71.17,48.96},{68.1,53.66},{68.04,46.81},{69.15,51.59},{68.89,48.49},{65.72,50.22},{66.86,52.19},{66.71,48.91},{69.87,44.44},{67.64,50.13},{71.03,42.41},{68.86,45.39},{72.88,41.98},{71.1,45.48},{70.88,38.81},{72.12,40.5},{69.94,40.74}}},nil,3,nil,nil,16,nil,nil,0},
[2726] = {'Scorched Guardian',1782,1782,44,45,0,{[3]={{72.35,50.1},{68.21,49.28},{73.82,43.57},{73.49,42.64},{70.86,38.19},{66.11,47.41},{69.84,44.4},{71.39,41.33}}},nil,3,nil,nil,16,nil,nil,0},
[2727] = {'Crag Coyote',1400,1469,35,36,0,nil,nil,0,nil,nil,38,nil,nil,0},
[2728] = {'Feral Crag Coyote',2125,2125,44,44,0,{[3]={{54.28,51.95},{85.32,37.57},{89.4,39.45},{71.37,33.09},{70.81,29.48},{68.25,29.25}}},nil,3,nil,nil,38,nil,nil,0},
[2729] = {'Elder Crag Coyote',2207,2207,45,46,0,{[3]={{14.62,53.47},{38.8,58.26},{38.66,61.37},{43.42,61.9},{43.02,58.44},{40.5,58.84},{46.88,13.24},{56.09,57.89},{47.45,47.46},{41.52,63.46},{37.2,60.09},{35.08,59.89},{47.81,21.13},{49.62,19.14},{37.25,34.18},{49.48,22.54},{55.84,36.98},{46.05,11.08},{48.27,51.49},{46.31,8.21},{56.6,32.94},{55.77,39.1},{44.93,34.17},{47.27,50.34},{53.23,42.06},{55.06,42.93},{52.83,43.31},{54.58,47.07},{50.61,17.94},{54.7,53.28}}},nil,3,nil,nil,38,nil,nil,0},
[2730] = {'Rabid Crag Coyote',2388,2388,47,47,0,{[3]={{14.11,52.46},{14.1,50.17},{11.5,52.96},{18.12,56.58},{15.67,56.72},{16.35,52.47},{19.91,52.9},{18.88,52.39},{18.84,55.32},{11.27,50.13}}},nil,3,nil,nil,38,nil,nil,0},
[2731] = {'Ridge Stalker',2125,2125,44,44,0,{[3]={{77.41,28.99},{79.81,32.52},{75.55,30.01},{76.44,27.28},{70.15,30.92},{76.82,30.55}}},nil,3,nil,nil,16,nil,nil,0},
[2732] = {'Ridge Huntress',2125,2125,45,46,0,{[3]={{50.18,14.08},{53.48,58.62},{54.78,56.73},{51.92,54.62},{41.73,60.26},{40.68,61.54},{48.21,14.53},{49.05,15.85},{55.95,55.67},{36.21,58.49},{48.57,17.7},{34.38,36.93},{50.5,20.72},{40.27,33.68},{35.29,33.69},{48.31,24.12},{56.65,30},{35.33,35.45},{54.03,45.17},{43.92,35.76},{54.61,50.25},{43.21,34.07},{53.49,48.63},{44.29,32.23},{43.08,37.29}}},nil,3,nil,nil,16,nil,nil,0},
[2733] = {'Apothecary Jorell',1706,1706,28,28,0,{[45]={{54.73,61.04}}},nil,45,nil,nil,83,"H",nil,0},
[2734] = {'Ridge Stalker Patriarch',1990,1990,47,47,0,{[3]={{23.84,64.46},{14.86,58.61},{11.42,50.42},{21.44,65.71},{25.21,63.01},{22.52,64.57},{10.18,52.01},{12.44,52.38},{16.44,55.45},{17.74,53.4},{19.07,55.31},{16.71,58.58},{16.7,54.91},{15.47,56.86},{18.05,56.5},{12.88,52.62},{18.8,52.4}}},nil,3,nil,nil,16,nil,nil,0},
[2735] = {'Lesser Rock Elemental',1600,1678,37,39,0,nil,nil,0,nil,nil,91,nil,nil,0},
[2736] = {'Greater Rock Elemental',1981,2138,42,44,0,nil,nil,0,nil,nil,91,nil,nil,0},
[2737] = {'Durtham Greldon',1753,1753,40,40,0,{[1537]={{51.26,14.97}}},nil,1537,nil,nil,55,"A",nil,0},
[2738] = {'Stromgarde Cavalryman',958,1002,36,37,0,nil,nil,0,nil,nil,11,"A",nil,0},
[2739] = {'Shadowforge Tunneler',1848,1848,45,46,0,{[3]={{48.4,23.96},{50.24,24.18},{49.95,29.19},{48.14,32.63},{49.14,26.56},{44.97,29.41},{48.25,27},{48.34,28.18},{49.03,28.86},{47.21,28.81},{49.56,29.41},{47.8,27.51},{48.35,28.18},{49.14,26.56},{49.93,27.21},{49.29,30.9}}},nil,3,nil,nil,54,nil,nil,0},
[2740] = {'Shadowforge Darkweaver',1294,1294,46,46,0,{[3]={{49.38,22.62},{45.96,30.32},{46.05,27.29},{46.99,32.36},{46.98,25.86},{47.44,29.53},{48.94,29.56},{48.36,29.02},{49.22,27.15},{47.46,29.54},{49.29,27.95}}},nil,3,nil,nil,54,nil,nil,0},
[2741] = {'Shadowforge Excavator',5000,5000,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2742] = {'Shadowforge Chanter',1535,1535,45,46,0,{[3]={{39.83,26.68},{39.73,24.63},{39.03,24.19},{39.64,26.42},{38.28,23.85},{39.9,23.46},{38.78,22.53},{39.31,23.62},{39.44,24.62},{40.89,24.77}}},nil,3,nil,nil,54,nil,nil,0},
[2743] = {'Shadowforge Warrior',1848,1848,45,45,0,{[3]={{39.42,29.05},{40.47,28.46},{38.98,30.33},{38.88,25.25},{38.92,25.13},{41.65,24.96},{42.61,26.16},{37.96,24.03},{40.75,26.21},{40.38,25.79},{41.88,27.64},{40.04,24.06},{38.71,22.57},{39.32,25.8},{40.38,24.21},{38.72,24.59},{43.5,29.83},{41.64,29.22},{42.91,29.04}}},nil,3,nil,nil,54,nil,nil,0},
[2744] = {'Shadowforge Commander',3980,3980,47,47,4,{[3]={{40.41,25.85},{39.79,24.54}}},{[3]={{{40.93,29.1},{40.47,28.48},{39.76,27.65},{40.04,26.96},{40.49,26.15},{40.79,25.72},{41.5,26.58},{42,27.19},{42.48,27.79},{42,27.19},{41.5,26.58},{40.79,25.72},{40.49,26.15},{40.04,26.96},{39.76,27.65},{40.47,28.48},{40.93,29.1},{41.47,29.71}}}},3,nil,nil,54,nil,nil,0},
[2745] = {'Ambassador Infernus',3070,3070,46,46,0,{[3]={{39.87,25.14}}},nil,3,nil,nil,54,nil,nil,0},
[2746] = {'Stonevault Warden',5000,5000,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[2748] = {'Archaedas',45720,45720,40,40,1,{[1337]={{-1,-1}}},nil,1337,{27677,27680},nil,14,nil,"Ancient Stone Watcher",0},
[2749] = {'Barricade',5155,5155,48,48,4,{[3]={{12.08,51.41},{9.07,48.61}}},nil,3,nil,nil,189,"AH",nil,0},
[2751] = {'War Golem',2878,2878,46,46,4,{[3]={{41.32,10.32},{47.3,29.33},{39.6,29.1},{49.07,25.84}}},nil,3,nil,nil,54,nil,nil,0},
[2752] = {'Rumbler',3838,3838,46,46,4,{[3]={{18.81,71.88},{7.37,67},{15.68,29.51}}},nil,3,nil,nil,14,nil,nil,0},
[2753] = {'Barnabus',2878,2878,46,46,4,{[3]={{36.86,58.84},{51,56.65},{43.23,61.98},{37.27,56.84},{40.19,60.25}}},nil,3,nil,nil,38,nil,nil,0},
[2754] = {'Anathemus',6186,6186,48,48,4,{[3]={{52.65,54.44},{8.34,66.85}}},{[3]={{{25.72,72.72},{27.21,71.02},{28.6,69.22},{30.4,68.08},{31.77,66.03},{32.6,63.24},{34.15,61.29},{36.4,58.2},{37.2,57.1},{40.13,55.38},{42.23,54.14},{44.09,52.73},{45.54,51.63},{47.04,49.39},{49.35,48.5},{51.65,50.09},{52.89,53.33},{53.17,57.73},{53.39,61.29},{53.01,64.63},{52.75,66.92},{52.98,69.35},{53.13,70.83},{52.1,73.64},{49.97,73.8},{48.46,72.89},{46.91,72.73},{45.17,72.13},{42.83,71.32},{41,70.69},{38.64,67.92},{36.26,65.18},{33.24,63},{31.46,61.72},{30.01,59.41},{28.02,58.51},{25.68,57.44},{23.66,57.7},{21.24,58},{19.6,58.04},{18.95,59.77},{17.41,62.18},{15.3,64.37},{14.35,65.08},{13.99,66.07},{13.06,68.91},{13.15,71.2},{12.69,74.93},{12.83,76.91},{13.96,78.32},{15.93,78.66},{17.86,78.85},{19.16,78.17},{20.7,78.5},{22.54,77.53},{23.16,76.9},{23.51,75.63},{23.64,74.24}}}},3,nil,nil,778,nil,nil,0},
[2755] = {'Myzrael',2433,2433,30,30,1,nil,nil,0,nil,nil,7,"AH",nil,0},
[2756] = {'UNUSED Grund Drokda',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Reuse Me",0},
[2757] = {'Blacklash',2215,2215,50,50,0,nil,nil,0,nil,nil,103,nil,nil,0},
[2759] = {'Hematus',2215,2215,50,50,0,nil,nil,0,nil,nil,103,nil,nil,0},
[2760] = {'Burning Exile',905,905,29,29,0,{[45]={{18.9,28.97},{19.97,32.63},{19.8,29.32},{20.75,32.03},{19.93,31.67},{19.82,30.22},{17.75,31.25},{18.24,33.08},{18.1,33.24},{18.6,31.25},{19.23,31.43},{17.76,30.15},{18.02,28.94},{19.09,30.53}}},nil,45,nil,nil,16,nil,nil,0},
[2761] = {'Cresting Exile',773,773,29,29,0,{[45]={{59.91,30.33},{60.24,28.69},{61.17,28.74},{60.11,32.26},{61.85,31.9},{62.82,32.1},{62.02,28.95},{62.83,28.98},{61.81,31.86},{61.12,31.76},{61.94,30.48},{61.41,30.72},{61.65,29.91},{62.76,30.4}}},nil,45,nil,nil,16,nil,nil,0},
[2762] = {'Thundering Exile',773,773,29,29,0,{[45]={{46.69,49.19},{46.81,53.76},{44.75,54.97},{45.24,51.04},{44.71,52.04},{46.63,51},{45.75,53.3},{47.74,50.98},{46.3,51.82},{47.77,52.01},{46.61,52.15},{46.16,52.41}}},nil,45,nil,nil,16,nil,nil,0},
[2763] = {'Thenan',1810,1810,29,29,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2764] = {'Sleeby',184,184,40,40,0,nil,nil,0,nil,nil,15,"AH",nil,0},
[2765] = {'Znort',219,219,39,39,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2766] = {'Lolo the Lookout',1678,1678,39,39,0,{[45]={{25.42,85.29}}},nil,45,nil,{26083},390,"AH","Blackwater Raiders",2},
[2767] = {'First Mate Nilzlix',1678,1678,39,39,0,{[45]={{26.44,83.95}}},nil,45,nil,{662},120,"AH","Blackwater Raiders",0},
[2768] = {'Professor Phizzlethorpe',1604,1604,38,38,0,{[45]={{27.58,83.01}}},nil,45,{26050},nil,35,"AH","Blackwater Raiders",2},
[2769] = {'Captain Steelgut',1678,1678,39,39,0,{[45]={{27.72,83.27}}},nil,45,{26055},{664,26055},120,"AH","Blackwater Raiders",2},
[2770] = {'Tallow',840,840,27,27,0,{[267]={{57.96,46.64}}},nil,267,nil,nil,68,"H",nil,0},
[2771] = {'Drum Fel',1003,1003,30,30,0,{[45]={{68.98,34.82}}},nil,45,{26429,26430},{676,677,678,679,26429},125,"H",nil,3},
[2772] = {'Korin Fel',1342,1342,35,35,0,{[45]={{68.9,34.82}}},nil,45,nil,{680},125,"H",nil,0},
[2773] = {'Or\'Kalar',1600,1600,27,27,0,{[45]={{14.7,67.44}}},nil,45,nil,nil,45,nil,nil,0},
[2774] = {'Doctor Draxlegauge',1604,1604,38,38,0,{[45]={{27.56,82.91}}},nil,45,{26051,26052},{665,666,26050,26051},120,"AH","Blackwater Raiders",2},
[2775] = {'Daggerspine Marauder',853,853,28,28,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2776] = {'Vengeful Surge',853,853,28,28,0,nil,nil,0,nil,nil,41,nil,nil,0},
[2778] = {'Deckhand Moishe',1536,1536,37,37,0,{[45]={{26.46,82.47},{26.28,82.51},{26.28,82.51}}},nil,45,nil,nil,120,"AH","Blackwater Raiders",0},
[2779] = {'Prince Nazjak',1024,1024,28,28,4,{[45]={{12.57,92.95},{16.6,91.49}}},nil,45,nil,nil,74,nil,nil,0},
[2780] = {'Caretaker Nevlin',920,920,27,27,0,{[45]={{22.76,61.22}}},nil,45,nil,nil,123,"A",nil,0},
[2781] = {'Caretaker Weston',920,920,27,27,0,{[45]={{22.66,61.92}}},nil,45,nil,nil,123,"A",nil,0},
[2782] = {'Caretaker Alaric',920,920,27,27,0,{[45]={{22.51,61.34}}},nil,45,nil,nil,123,"A",nil,0},
[2783] = {'Marez Cowl',1302,1302,26,26,0,{[45]={{23.22,64.81}}},nil,45,nil,nil,16,nil,nil,0},
[2784] = {'King Magni Bronzebeard',5578000,5578000,88,88,3,nil,nil,0,nil,{683,700,4361,4363,8484,12771},55,"A","Lord of Ironforge",2},
[2785] = {'Theldurin the Lost',2090,2090,47,47,0,{[3]={{26.21,62.29}}},nil,3,{27713},{687,692,709,737,27713,27927},35,"AH",nil,3},
[2786] = {'Gerrig Bonegrip',1003,1003,30,30,0,{[1537]={{50.83,5.62}}},nil,1537,nil,{653,727,735,968},55,"A",nil,0},
[2787] = {'Zaruk',4120,4120,60,60,0,{[45]={{69.69,36.53}}},nil,45,{26909,26912},{688,26911},83,"H",nil,2},
[2788] = {'Apprentice Kryten',1003,1003,30,30,0,nil,nil,0,nil,{691,694},12,"A",nil,1},
[2789] = {'Skuerto',1469,1469,36,36,0,{[45]={{40.34,49.14}}},nil,45,{26035,26036,26037,26049,26336,26341,26943},{690,693,695,696,26035,26036,26038,26346},55,"A",nil,3},
[2790] = {'Grand Mason Marblesten',2138,2138,44,44,0,{[1537]={{38.65,87.66}}},{[1537]={{{38.09,87.72},{37.4,87.4},{37.19,87.08},{37.37,86.16},{37.49,85.94},{38.6,86.82},{37.49,85.94},{37.37,86.16},{37.19,87.08},{37.4,87.4},{38.09,87.72}}}},1537,nil,{686,689},55,"A","Royal Stonecutters Union",0},
[2791] = {'Enraged Rock Elemental',1981,2059,42,43,0,nil,nil,0,nil,nil,91,nil,nil,0},
[2792] = {'Gor\'mul',1753,1753,40,40,0,nil,{[45]={{{72.77,33.66},{72.54,34.01},{72.61,34.16},{72.82,34.22},{72.8,34.14},{72.8,34.14}}}},0,nil,{674,702},29,"H",nil,0},
[2793] = {'Kor\'gresh Coldrage',1380,1380,27,27,0,{[45]={{49.2,84.38}}},nil,45,nil,nil,45,nil,nil,0},
[2794] = {'Summoned Guardian',1604,1604,38,38,0,nil,nil,0,nil,nil,10,"A",nil,0},
[2795] = {'Lenny "Fingers" McCoy',1342,1342,35,35,0,{[1519]={{72.79,58.91}}},nil,1519,nil,nil,12,"A",nil,0},
[2796] = {'Faelyssa',1342,1342,35,35,0,{[1657]={{38.53,36.66}}},nil,1657,nil,nil,80,"A",nil,0},
[2797] = {'Hovrak Gutrender',25,27,1,1,0,nil,nil,0,nil,{8024},35,"AH","Baby Murloc Redemption Merchant",0},
[2798] = {'Pand Stonebinder',1342,1342,35,35,0,{[1638]={{29.69,21.18}}},nil,1638,nil,nil,104,"H","First Aid Trainer",81},
[2799] = {'Lucian Fenner',1342,1342,35,35,0,{[1497]={{76.78,75.18}}},nil,1497,nil,nil,68,"H",nil,0},
[2801] = {'Tresa MacGregor',2972,2972,45,45,0,nil,nil,0,nil,{8023},55,"A","Baby Murloc Redemption Merchant",1},
[2802] = {'Susan Tillinghast',3398,3398,55,55,0,{[1497]={{86.04,61.9},{87.19,76.67}}},{[1497]={{{85.18,78},{82.33,77.29},{80.89,74.7},{76.32,71.86},{75.39,69.36},{76.72,67.22},{78.41,65},{79.42,64.52},{80.79,62.24},{81.15,61.41},{82.54,58.98},{86.04,61.9},{87.24,68.02},{88.8,72.1},{88.54,73.78},{87.19,76.67}}}},1497,nil,nil,68,"H",nil,0},
[2803] = {'Malygen',3398,3398,55,55,0,{[361]={{61.33,26.94},{61.28,26.6}}},nil,361,nil,nil,80,"A","General Goods",896},
[2804] = {'Kurden Bloodclaw',3874500,3874500,85,85,1,{[1497]={{56.19,85.41}}},nil,1497,nil,nil,1515,"H","Warsong Gulch Battlemaster",1048577},
[2805] = {'Deneb Walker',960,960,27,27,0,{[45]={{20.43,60.54}}},nil,45,nil,nil,12,"A","Reagents",2176},
[2806] = {'Bale',3398,3398,55,55,0,nil,nil,0,nil,nil,105,"H","General Goods",896},
[2807] = {'Daggerspine Wavecaller',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2808] = {'Vikki Lonsav',1469,1469,36,36,0,{[45]={{39.9,49.04}}},nil,45,nil,nil,12,"A","Innkeeper",66177},
[2809] = {'Boar',21000,21000,69,70,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2810] = {'Hammon Karwn',1342,1342,35,35,0,{[45]={{40.53,48.88}}},nil,45,nil,nil,12,"A","Superior Tradesman",128},
[2812] = {'Drovnar Strongbrew',1678,1678,39,39,0,{[45]={{40.58,48.33}}},nil,45,nil,nil,55,"A","Alchemy Supplies",128},
[2814] = {'Narj Deepslice',1678,1678,39,39,0,{[45]={{39.67,48.94}}},nil,45,nil,nil,55,"A","Butcher",640},
[2816] = {'Androd Fadran',1536,1536,37,37,0,{[45]={{39.19,48.22}}},nil,45,nil,nil,12,"A","Leatherworking Supplies",128},
[2817] = {'Rigglefuzz',1536,1536,37,37,0,nil,nil,0,nil,{703,705,1559,2418},120,"AH",nil,0},
[2818] = {'Slagg',1604,1604,38,38,0,{[45]={{69.21,34.64}}},nil,45,nil,nil,29,"H","Superior Butcher",81},
[2819] = {'Tunkk',1279,1279,34,34,0,{[45]={{70.05,35.4}}},nil,45,nil,nil,29,"H","Leatherworking Supplies",128},
[2820] = {'Graud',1107,1107,31,31,0,{[45]={{69.25,33.15}}},nil,45,nil,nil,29,"H","General Goods",640},
[2821] = {'Keena',1221,1221,33,33,0,{[45]={{69.22,33.52}}},nil,45,nil,nil,29,"H","Trade Goods",128},
[2829] = {'Starving Buzzard',2049,2049,44,44,0,{[3]={{77.08,30.37},{80.78,30.55}}},nil,3,nil,nil,73,nil,nil,0},
[2830] = {'Parched Buzzard',2207,2207,45,46,0,{[3]={{50.96,50.53},{46.47,62.16},{50.43,56.35},{44.97,12.77},{48.63,25.62},{54.35,39.54},{42.88,35.1},{53.86,54.28},{42.24,62},{38.79,61.22},{44.89,27.96},{49.65,17.29},{47.91,50.46},{52.7,43.33},{54.77,51.89}}},nil,3,nil,nil,73,nil,nil,0},
[2831] = {'Giant Buzzard',2303,2303,47,47,0,{[3]={{15.5,54.47},{15.58,56.79},{17.97,53.31},{13.26,54.21}}},nil,3,nil,nil,73,nil,nil,0},
[2832] = {'Nixxrax Fillamug',1395,1395,38,38,0,{[5287]={{40.88,73.54}}},nil,5287,nil,nil,120,"AH","Food & Drink",641},
[2833] = {'DEBUG - Gossip Gryphon Master',75,80,65,65,1,nil,nil,0,nil,nil,35,"AH","Gryphon Master",0},
[2834] = {'Myizz Luckycatch',1716,1716,43,43,0,{[5287]={{41.56,73.45}}},nil,5287,nil,nil,120,"AH","Fishing Trainer",81},
[2835] = {'Cedrik Prose',89114,89114,85,85,1,{[45]={{39.88,47.35}}},nil,45,nil,nil,12,"A","Gryphon Master",8193},
[2836] = {'Brikk Keencraft',3293,3293,54,54,0,{[5287]={{44.04,70.93}}},nil,5287,nil,nil,120,"AH","Blacksmithing Trainer",81},
[2837] = {'Jaxin Chong',2399,2399,46,46,0,{[5287]={{42.5,74.87}}},nil,5287,nil,nil,120,"AH","Alchemy Trainer",81},
[2838] = {'Crazk Sparks',2399,2399,46,46,0,{[5287]={{43.02,72.72}}},nil,5287,nil,nil,120,"AH","Fireworks Merchant",128},
[2839] = {'Haren Kanmae',17435,17435,41,41,0,{[5287]={{42.92,69.32}}},nil,5287,nil,nil,120,"AH","Superior Bowyer",4224},
[2840] = {'Kizz Bluntstrike',1651,1651,42,42,0,{[5287]={{42.87,70.38}}},nil,5287,nil,nil,120,"AH","Macecrafter",4224},
[2842] = {'Wigcik',1716,1716,43,43,0,{[5287]={{42.44,73.25}}},nil,5287,nil,nil,120,"AH","Superior Fisherman",640},
[2843] = {'Jutak',1716,1716,43,43,0,{[5287]={{41.56,74.15}}},nil,5287,nil,nil,120,"AH","Blade Trader",4224},
[2844] = {'Hurklor',1919,1919,46,46,0,{[5287]={{44,70.13}}},nil,5287,nil,nil,120,"AH","Blacksmithing Supplies",4224},
[2845] = {'Fargon Mortalak',1651,1651,42,42,0,{[5287]={{44.12,70.02}}},nil,5287,nil,nil,120,"AH","Superior Armorer",4224},
[2846] = {'Blixrez Goodstitch',2059,2059,43,43,0,{[5287]={{42.83,74.14}}},nil,5287,nil,nil,120,"AH","Leatherworking Supplies",129},
[2847] = {'Jansen Underwood',2138,2138,49,49,0,{[5287]={{44.17,70.82}}},nil,5287,nil,nil,120,"AH","Blacksmithing Supplies",4224},
[2848] = {'Glyx Brewright',1848,1848,45,45,0,{[5287]={{42.66,75.06}}},nil,5287,nil,nil,120,"AH","Alchemy Supplies",129},
[2849] = {'Qixdi Goodstitch',1782,1782,44,44,0,{[5287]={{42.67,74.17}}},nil,5287,nil,nil,120,"AH","Cloth Armor & Accessories",4224},
[2850] = {'Broken Tooth',2985,2985,47,47,4,{[3]={{42.2,39.93},{54.12,25.54},{49.22,14.32},{22.7,61.09}}},nil,3,nil,nil,16,nil,nil,0},
[2851] = {'Urda',232470,232470,85,85,1,{[45]={{68.17,33.39}}},nil,45,nil,nil,29,"H","Wind Rider Master",8193},
[2852] = {'Enslaved Druid of the Talon',198,198,10,10,0,{[141]={{51.76,40.09},{51.67,40.11},{51.72,40.13},{51.64,40.07}}},nil,141,nil,nil,35,"AH",nil,0},
[2853] = {'Freed Druid of the Talon',98,98,10,10,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2855] = {'Snang',664,664,24,24,0,{[1637]={{61.49,58.3},{61.27,57.79}}},nil,1637,nil,nil,29,"H","Apprentice Tailor",1},
[2856] = {'Angrun',1753,1753,40,40,0,{[33]={{38.55,48.25}}},nil,33,nil,nil,29,"H","Herbalism Trainer",80},
[2857] = {'Thund',617,617,23,23,0,{[1637]={{56.51,57.05}}},nil,1637,nil,nil,29,"H","Apprentice Engineer",1},
[2858] = {'Gringer',232470,232470,85,85,1,{[5287]={{40.6,73.42}}},nil,5287,nil,nil,29,"H","Wind Rider Master",8193},
[2859] = {'Gyll',232470,232470,85,85,1,{[5287]={{41.67,74.54}}},nil,5287,nil,nil,55,"A","Gryphon Master",8193},
[2860] = {'Sigrun Ironhew',2288,2288,47,47,0,{[3]={{49.49,36.99}}},nil,3,{27823,27824},{706,718,733,27823,27824},55,"A",nil,2},
[2861] = {'Gorrik',232470,232470,85,85,1,{[3]={{17.19,40.01}}},nil,3,nil,nil,29,"H","Wind Rider Master",8193},
[2862] = {'Warrior 21',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2863] = {'Warrior 22',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2864] = {'Warrior 23',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2865] = {'Warrior 24',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2866] = {'Warrior 26',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2867] = {'Warrior 27',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2868] = {'Warrior 28',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2869] = {'Warrior 29',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2871] = {'[PH] Tallstrider Trainer',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2873] = {'[PH] Raptor Trainer',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2874] = {'[PH] Horse Trainer',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2875] = {'[PH] Gorilla Trainer',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2876] = {'Grunenstur Balindom',3517,3517,50,50,0,nil,nil,0,nil,nil,1802,"A","Crocilisk Trainer",0},
[2877] = {'[PH] Crawler Trainer',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2878] = {'Peria Lamenur',1753,1753,40,40,0,{[1]={{53.79,52.33}}},nil,1,nil,nil,55,"A","Pet Trainer",1},
[2879] = {'Karrina Mekenda',1753,1753,40,40,0,{[1519]={{67.34,36.81}}},nil,1519,nil,nil,55,"A","Pet Trainer",1},
[2886] = {'Ranged Skills Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Ranged Skills Trainer",0},
[2887] = {'Prismatic Exile',41,41,30,30,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2888] = {'Garek',2769,2769,50,50,0,nil,nil,0,nil,{717,732},1802,"A",nil,0},
[2889] = {'Stonevault Trogg',5000,5000,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[2890] = {'Stonevault Scout',5000,5000,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[2891] = {'Stonevault Skullthumper',5000,5000,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2892] = {'Stonevault Seer',1200,1300,37,40,0,nil,nil,0,nil,nil,59,nil,nil,0},
[2893] = {'Stonevault Bonesnapper',1678,1753,39,40,0,nil,nil,0,nil,nil,59,nil,nil,0},
[2894] = {'Stonevault Shaman',1471,1522,40,41,0,nil,nil,0,nil,nil,59,nil,nil,0},
[2896] = {'[PH] Alliance Magic Skills Trainer',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Magic Skill Trainer *Temp*",0},
[2899] = {'[PH] Alliance Toughness/Resist Trainer',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Toughness/Resist Trainer *Temp*",0},
[2906] = {'Dustbelcher Warrior',1403,1536,35,37,0,nil,nil,0,nil,nil,45,nil,nil,0},
[2907] = {'Dustbelcher Mystic',1208,1257,36,37,0,nil,nil,0,nil,nil,45,nil,nil,0},
[2908] = {'Grawl',2138,2138,44,44,0,{[3]={{18.65,41.73}}},nil,3,nil,nil,29,"H","General Goods",640},
[2909] = {'Hammertoe Grez',1600,1604,38,40,0,nil,nil,0,nil,{721,722},55,"A",nil,0},
[2910] = {'Prospector Ryedol',2111,2111,46,46,0,{[3]={{48.93,37.17}}},nil,3,nil,{719,720,723},55,"A","Explorers' League",0},
[2911] = {'Archaeologist Flagongut',2138,2138,44,44,0,{[11]={{10.84,60.43}}},nil,11,nil,{942,943},55,"A","Explorers' League",0},
[2912] = {'Chief Archaeologist Greywhisker',1753,1753,40,40,0,{[1657]={{37.66,80.09}}},nil,1657,nil,{741},55,"A","Explorers' League",0},
[2913] = {'[Deprecated for 4.x]Archaeologist Hollee',247,247,12,12,0,nil,nil,0,nil,{730,731},55,"A","Explorers' League",0},
[2914] = {'Snake',8,8,1,1,0,{[15]={{47.17,75.36},{46.46,45.62},{38.79,16.26},{62.9,41.22},{51.35,16.21},{49.64,73.91},{56.44,21.88},{34.79,38.84},{48.71,75.76},{56.56,69.39},{52.06,72.73},{47.64,53.5},{39.37,64.4},{47.65,53.99},{40.77,38.57},{34.12,64.56},{53.01,75.88},{40.45,71.9},{41.38,70.59},{53.31,71.89},{41.68,67.71},{38.18,54.06},{49.2,52.14},{36.97,70.17},{43.56,63.06},{56.28,30.82},{35.63,57.4},{46.23,74.48},{35.83,67.45},{45.77,18.97},{44,40.1},{42.83,42.59},{51.35,61.16},{48.62,70.38},{39.6,72.42},{41.11,14.3},{41.12,61.71},{45.48,61.92},{60.09,33.97},{35.79,41.07},{36.71,60.04},{38.74,45.93},{59.29,30.23},{42.43,75.76},{34.85,44.36},{44.36,51.3},{38.36,71.54},{35.32,50.21},{49.95,62.94},{41.22,41.57},{33.11,44.48},{44.31,48.04},{58.43,30.82},{37.57,13.3},{37.95,16.34},{48.8,20.99},{54.23,23.98},{36.42,27.84},{45.62,73.24},{45.13,70.68},{50.87,68.71},{47.96,66.83},{55,21.79},{44.26,78.84}},[38]={{51.15,60.01},{42.58,30.07},{44.47,16.32},{44.93,23.32},{42.55,23.37},{45.28,37.44},{46.29,34.51},{42.38,45.47},{51.24,60.02},{58.84,55.79},{48.79,57.39},{55.28,54.34},{51.5,16.43},{51.23,60.36},{58.88,54.8},{44.28,30.61},{52.77,42.68},{45.05,16.38},{45.22,23.68},{56.49,46.09},{43.24,23.19},{57.3,33.23},{45.17,38.84},{48.93,57.77},{54.35,19.2},{46.33,34.61},{50.81,54.27},{54.09,50.56},{42.94,45.67},{51.53,16.91},{43.85,30.7},{44.82,16.99},{45.56,23.32},{43.22,23.45},{55.03,19.84},{45.59,34.1}},[40]={{66.69,64.98},{34.37,29.11},{63.6,46.8},{33.09,37.01},{52.55,54.22},{52.4,17.51},{62.74,49.4},{46.31,16.31},{46.71,27.74},{42.79,27.37},{44.3,46.27},{61.2,54.03},{31.56,43.22},{53.72,39.29},{43.05,17.7},{65.45,56.31},{51.44,37.22},{61.21,40.31},{49.61,25.03},{47.71,22.23},{61.87,27.91},{61.66,36.97},{51.74,24.47},{56.52,30.02},{58.14,15.19},{59.38,33.42},{43.34,50.96},{56.39,32.31},{64.69,49.41},{37.08,48.28},{40.09,27.72},{58.98,27.92},{66.2,64.61},{49.42,30.82},{41.36,23.32},{53.4,20.78},{34.51,28.17},{32.21,52.05},{62.85,73.5},{35.41,73.41},{34.29,59.19},{52.77,54.94},{51.18,75.86},{41.03,57.89},{48.05,78.3},{32.48,70.81},{31.99,43.41},{51.74,58.8},{46.38,78.81},{32.18,46.95},{42.89,51.76},{67.2,71.45},{37.19,48.66},{66.63,64.99},{36.13,76.79}},[130]={{67.7,82.59},{48.48,34.44},{54.83,51.46},{52.48,57.83},{54.4,60.22},{55.48,59.57},{47.91,86.52},{54.04,43.31},{53.3,50.26},{52.89,50.14},{44.56,28.62},{51.26,62.03},{44.45,47.3},{55.04,42.02},{47.03,19.54},{47.77,31.83},{50.95,42.67},{49.37,57.45},{49.21,14.88},{47.54,34.02},{50.95,43.42},{50.23,15.57},{56.05,42.11},{51.42,54.53},{53.77,39.66},{51.63,12.15},{48.88,25.41},{55.55,23.2},{45.09,17},{49.19,17.76},{59.46,9.1},{55.44,24.27},{38.67,22.37},{54.97,56.29},{41.46,23.95},{49.96,19.12},{60.19,7.55},{50.63,73.22},{59.48,9.19},{42.71,20.33},{56.43,34.7},{55.24,22.2},{42.17,29.02},{48.21,47.85},{49.84,47.79},{53.4,23.54},{56.16,78.33},{46.7,28.3},{50.25,38.93},{46.79,24.38},{67.37,82.46},{56.56,77.87},{66.07,52},{67.56,82.48},{67.32,53.27},{66.19,57.77},{65.06,48.73},{65.94,56.67},{55.74,77.62}},[357]={{46.25,3.48},{50.52,27.99},{46.25,3.02},{41.33,13.72},{41.72,25.37},{38.47,20.58},{46.9,6.4},{51.01,21.73},{46.99,41.89},{48.71,44.52},{38.96,11.84},{45.88,21.5},{47.79,8},{51.13,33.89},{50.94,19.03},{47.43,56.17},{72.12,61.44},{70.35,47.24},{76.73,40.05},{54.92,75.13},{46.85,48.51},{31.3,52.62},{25.4,50.42},{52.76,49.46},{26.87,48.58},{72.2,63.06},{71.37,35.83},{28.78,53.45},{54.99,58.48},{27.67,44.07},{71.66,59.52},{71.84,43.49},{56.74,69.01},{73.12,41.57},{71.11,64.27},{57.64,61.27},{54.27,47.26},{32.79,43.08},{25.39,54.56},{69.95,54.06},{68.42,52.74},{32.03,47.85},{27.48,46.53},{67.63,45.36},{82.51,45.47},{59.29,48.37},{70.27,58.91},{54.89,71.36},{82.97,43.4},{71.2,43.11},{46.85,42.04},{76.45,48.3},{48.45,44.43},{70.8,49.87},{69.91,43.53},{80.48,46.58},{79.62,45.18},{70.04,39.58},{68.75,47.89},{54.57,50},{57.34,47.5},{28.97,45.92},{72.24,46.59},{66.95,48.11},{58.94,60.84},{30.38,48.2},{60.63,61.22},{57.87,58.62},{71.7,38.75},{70.5,37.59},{82.25,39.39},{79.09,37.76},{80.19,39.09},{77.4,38.65},{55.46,47.14},{31.94,51.06},{72.77,37.04},{75.38,36.29},{29.65,50.08},{85.09,37.32},{29.46,43.88},{53.53,48.32},{28.54,48.37},{57.63,50.78},{58.5,52.04},{71.64,41.13},{47.4,55.31},{69.3,45.99},{48.85,49.94},{75.56,37.91}},[495]={{51.45,27.47},{33.19,20.8},{68.33,56.98},{33.21,20.62},{33.21,20.88}},[718]={{-1,-1}},[1477]={{-1,-1}},[2100]={{-1,-1}},[2366]={{-1,-1}},[2557]={{-1,-1}},[3430]={{69.37,70.43},{65.53,66.4}},[3433]={{64.03,65.24},{66.05,58.94}},[3518]={{71.19,41.37},{71.2,41.33}},[3521]={{79.94,65.44},{76.81,54.28},{76.29,59.55},{77.55,57.88},{75.74,54.84},{72.96,50.36},{74.43,44.56},{75.75,45.89},{77.13,46.04},{77.96,44.56},{79.4,40.02},{77.1,41.25},{75.39,38.28},{75.88,39.02},{76.25,36.64},{76.82,32.45},{76.97,34.07},{78.83,36.14},{77.58,32.18},{78.46,32.1},{79.91,30.29},{84.82,29.28},{85.11,30.05},{84.44,31.16},{85.36,32.41},{83.09,34.43},{85.15,41.63},{84.01,43.49},{86.02,43.76},{86,45.06},{84.97,47.93},{83.15,48.34},{84.88,50.07},{85.22,50.49},{81.99,51.6},{82.86,57.43},{82.94,57.44},{77.57,57.51},{80.29,67.33},{78.59,70.26},{79.94,74.12},{80.91,78.83},{83.16,86.79},{83.81,86.47},{83.16,86.85},{82.16,85.64},{82.07,88.07},{77.29,85.26},{75.02,85.43},{71.94,85.87},{70.82,83.84},{69.27,86.32},{67.74,84.21},{69.99,78.8},{67.54,69.47},{66.74,71.61},{67.37,65.88},{65.4,67.07},{63.8,60.17},{62.83,57.2},{56.15,55.19},{53.52,56.9},{54.86,56.44},{51,58.32},{52.19,61.44},{50.79,63.44},{49.99,60.41},{48.4,57.88},{46.74,62.39},{44.63,59.38},{45.34,60.68},{38.28,60.06},{34.62,61.06},{35.21,64.73},{36.26,62.52},{38.39,59.98},{45.36,60.61},{44.81,59.47},{44.36,51.25},{38.72,48.17},{36.83,42.65},{37.14,38.75},{44.38,33.21},{44.09,35.34},{46.19,34.33},{44.42,33.25},{37.01,34.93},{36.03,34.01},{35.4,31.77},{34.81,28.35},{31.23,30.57},{31.03,27.55},{25.51,20.65},{26.53,23.65},{31,27.46},{31.09,30.66},{27.9,31.86},{29.3,38.03},{29.08,38.2},{28.54,39.67},{29.2,41.58},{31.6,41.67},{31.73,44.41},{30.76,46.45},{30.7,48.18},{29.01,51.07},{28.28,47.76},{23.39,55.26},{21.19,54.16},{18.72,47.44},{16.71,45.97},{14.9,43.35},{17.76,55.51},{20.11,59.09},{20.89,54.5},{23.56,55.48},{28.46,47.5},{28.97,50.71},{31.25,44.6},{30.84,46.39},{30.83,48.28},{31.09,48.52},{31.44,51.2},{33.81,48.94},{19.2,26.48},{16.58,36.39},{19.16,26.57},{31.09,27.54},{31.13,27.37},{34.83,28.3},{35.48,31.32},{29.14,38.25},{29.07,41.43},{16.54,36.32},{14.74,43.4},{16.52,46.45},{18.75,47.37},{18.37,52.37},{17.52,52.97},{18.65,47.64},{18.51,52.53},{17.74,52.95},{19.14,56.16},{23.7,55.25},{26.99,52.63},{27.58,51.08},{26.59,47.89},{27.61,51.18},{30.83,48.39},{34.75,53},{34.92,50.71},{30.79,48.43},{31.6,51.22},{33.76,48.89},{34.81,53.52},{34.22,52.42},{35.38,49.17},{35.11,50.95},{31.61,51.32},{33.79,49.05},{30.75,46.37},{30.89,48.2},{31.57,44.6},{31.42,41.93},{33.75,42.72},{34.9,42.24},{36.54,42.68},{38.39,48.31},{44.32,50.87},{50.86,54.99},{53.74,53.05},{61.33,35.86},{62.69,34.31},{68.8,38.19},{66.98,40.98},{66.03,40.28},{65.39,42.31},{64.21,39.96},{61.31,44.21},{64.09,40.01},{66.19,40.5},{65.21,42.44},{64.46,48.32},{66.19,51.35},{69.23,51.22},{70.32,50.28},{70.11,46.51},{69.74,48.4},{66.02,51.08},{69.63,48.36},{69.33,51.56},{70.17,52.28},{70.37,50.04},{70.13,46.41},{69.75,48.15},{68.92,44.23},{68.71,41.51},{77.02,33.93},{76.88,35.46},{76.49,36.69},{76.84,38.31},{75.64,38.12},{76.05,38.84},{78.99,38.17},{79.39,40.68},{80.46,42.34},{85.19,40.09},{84.78,38.32},{84.48,34.04},{83.88,36.72},{82.96,34.41},{81.75,32.83},{78.99,38.07},{80.99,33.71},{77.04,38.12},{79.02,36.6},{74.84,33.94},{76.48,36.62},{76.85,35.39},{76.62,33.48},{76.82,32.14},{76.85,33.94},{78,32.45},{78.48,32.04},{79.79,30.31},{81.09,33.58},{81.78,32.78},{81.61,30.72},{84.27,31.37},{83.53,31.33},{84.94,29.58},{84.74,30.19},{84.42,31.53},{85.54,32.36},{86.92,29.99},{87.9,33.27},{86.73,35.09},{86.57,37.3},{86.89,38.46},{87.37,41.37},{86.15,43.43},{84.92,50.44},{85.12,50.88},{85.13,51.08},{79.63,61.98},{80.84,60.85},{79.42,62.4},{79.99,63.8},{80.69,68.96},{80.49,67.41},{79.78,74.02},{82.3,74.11},{80.66,79.41},{82.19,78.32},{81.15,79.25},{82.08,82.73},{82.32,87.92},{85.75,90.94},{38.81,29.18},{69.42,60.53},{75.94,84.31},{82.21,88.36}},[3714]={{-1,-1}},[3715]={{-1,-1}},[3791]={{-1,-1}},[3959]={{-1,-1}},[4416]={{-1,-1}},[4714]={{54.01,67.21},{54.09,66.83},{51.27,67.23},{52.98,69.43},{51.15,68.79},{54.06,71.57},{53.15,68.37},{50.01,68.98},{50.87,72.4},{53.04,72.45},{54.86,74.09}},[5095]={{47.95,49.66}}},nil,3521,nil,nil,190,"AH",nil,0},
[2915] = {'Hammertoe\'s Spirit',1753,1753,40,40,0,nil,nil,0,nil,nil,55,"A",nil,0},
[2916] = {'Historian Karnik',484,484,20,20,0,{[1537]={{77.54,11.82}}},nil,1537,{7063},{724,726,2963,2977,7062},55,"A",nil,3},
[2917] = {'Prospector Remtravel',356,356,16,16,0,nil,nil,0,nil,{729},55,"A","Explorers' League",0},
[2918] = {'Advisor Belgrum',1753,1753,40,40,0,{[1537]={{77.34,9.71}}},nil,1537,nil,{725,762,1139,25180},55,"A",nil,3},
[2919] = {'Fam\'retor Guardian',2218,2218,45,45,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2920] = {'Lucien Tosselwrench',2189,2189,47,47,0,{[3]={{26.28,62.54}}},nil,3,{27714},{715,716,734,27714},35,"AH",nil,3},
[2921] = {'Lotwil Veriatus',1469,1469,36,36,0,nil,nil,0,nil,{710,711,712,713,714,777,778,4062,4063},35,"AH",nil,0},
[2922] = {'Servo',102,102,5,5,0,nil,{[3]={{{26.04,44.73},{25.69,44.84},{25.36,45.55},{25.42,46.23},{25.8,46.92},{26.23,46.99},{26.59,46.57},{26.76,45.9},{26.73,45.37},{26.47,45.11},{26.17,44.78},{26.24,44.64},{26.24,44.46},{26.12,44.4},{26.03,44.67},{26.15,44.97},{26.34,45.18},{26.6,45.77},{26.99,46.19},{26.99,46.19},{26.68,45.83},{26.4,45.91},{26.4,46.43},{26.23,46.99},{26.02,47.1},{25.56,46.29},{25.5,45.73},{25.62,45.14},{25.87,44.94},{25.87,44.94},{25.87,44.76},{25.89,44.59},{26.09,44.45},{26.43,44.26},{26.7,44.36},{27.15,44.98},{27.12,45.82},{27,46.12},{26.55,45.87},{26.03,46.16},{25.59,46.01},{25.69,45.58},{25.55,44.94},{25.5,44.59},{25.52,44.41},{25.74,44.62}}}},0,nil,nil,42,"AH",nil,0},
[2923] = {'Mangy Silvermane',955,955,30,30,0,{[47]={{20.38,57.44},{16.64,54.88},{15.91,54.3},{19.47,56.77},{21.89,47.42},{17.58,56.56},{18.8,48.12},{21.99,55.72},{20.2,52.37},{69.41,44.77},{20.23,55.09},{14.34,54.3},{22.51,51.28},{18.52,55.78},{68.58,51.2},{17.78,50.22},{21.08,50.62},{19.97,49.64},{17.27,49.24},{17.57,48.36},{16.44,50.33},{17.41,51.67},{19.37,51.36},{18.58,47.69},{18.36,49.93},{17.46,53.75},{14.55,54.21},{20.2,52.35},{17.57,56.37},{17.43,51.76},{15.62,54.04},{18.7,55.43},{17.61,48.71},{66.29,48.45},{67.66,48.66},{20.19,50.09},{20.9,51.14},{22.65,51.22},{21.67,47.63}}},nil,47,nil,nil,38,nil,nil,0},
[2924] = {'Silvermane Wolf',1220,1220,34,35,0,{[47]={{30.21,65.71},{23.71,49.36},{28.51,65.71},{29.75,66.67},{37.61,47.59},{31.48,61.72},{35.02,43.73},{35.5,44.78},{36.75,53.33},{33.85,51.43},{25.57,66.83},{33.01,64.62},{24.75,52.56},{36.14,43.29},{36.52,48.88},{34.84,51.56},{37.22,50.32},{31.49,64.67},{29.56,64.22},{23.66,49.56}}},nil,47,nil,nil,38,nil,nil,0},
[2925] = {'Silvermane Howler',1321,1321,32,33,0,{[47]={{45.3,56.58},{42.66,55.23},{44.43,57.84},{46.1,57.84},{51.38,62.84},{44.46,54.95},{42.64,62.82},{43.55,56.56},{40.23,63.87},{40.88,42.82},{43.34,62.08},{43.55,45.45},{40.67,47.03},{39.09,44.93},{51.32,41.97},{39.09,57.58},{42.53,47.35},{50.39,59},{41.91,67.32},{45.56,58.96},{45.74,55.32},{40.94,54.92},{44.55,52.32},{44.33,44.76},{38.33,61.65},{48.68,59.05},{47.96,58.36},{50.02,42.35}}},nil,47,nil,nil,38,nil,nil,0},
[2926] = {'Silvermane Stalker',1057,1057,31,32,0,{[47]={{70.23,60.38},{76.47,51.27},{73.77,50.17},{76.39,54.06},{73.46,57.94},{77.98,51.56},{70.86,55.34},{74.88,50.95},{77.35,49.95},{66.79,60.31},{77.47,52.44},{72.19,57.49},{74.5,54.18},{75.78,49.65},{72.95,59.07},{76.28,49.13},{75.63,52.77},{73.31,56.68},{65.85,56.44},{74.95,48.8},{71.27,56.42},{73.8,55.23},{78.28,48.54},{67.72,59.25},{75.78,55.23},{66.87,57.65},{67.66,56.85},{68.81,55.07},{69.17,53.75},{67.81,53.79},{68.71,60.15},{71.17,61.72},{71.95,60.41},{69.39,59.49},{70.37,60.7},{70.43,57.51},{68.78,58.28},{69.73,56.7},{71.57,59.47}}},nil,47,nil,nil,38,nil,nil,0},
[2927] = {'Vicious Owlbeast',1057,1057,31,32,0,{[47]={{28.88,67.28},{25.48,52.79},{25.99,54.15},{26.92,52.82},{35.92,47.23},{37.39,44.88},{35.81,49.94},{36.61,46.12},{32.28,63.51},{28.88,67.65},{30.62,63.09},{36.58,51.31},{34.67,45.93},{28.93,63.21},{38.17,53.34}}},nil,47,nil,nil,14,nil,nil,0},
[2928] = {'Primitive Owlbeast',1268,1268,31,32,0,{[47]={{49.15,60.49},{40.66,63.4},{49.54,57.83},{41.83,64.31},{46.85,59.11},{45.99,49.85},{41.67,61.59},{40.88,50.25},{50.26,46.17},{38.44,46.28},{42.03,48.35},{39.69,43.3},{38.31,48.87},{38.63,58.99},{46.97,56.31},{41.5,56.74},{39.31,47.17},{37.47,60.66},{51.29,50.05},{40.95,52.52},{40.36,45.99},{46.19,60.58},{51.46,60.36},{51.15,58.02},{40.89,44.9},{38.7,43.59},{47.53,47.23},{45.36,51.19},{51.45,47.33},{43.68,59.54},{45.25,53.64}}},nil,47,nil,nil,14,nil,nil,0},
[2929] = {'Savage Owlbeast',1057,1057,32,32,0,{[47]={{52.2,59.15},{58.34,52.77},{53.8,48.86},{60.8,55.97},{60.27,54.98},{55.34,53.79},{58.3,47.24},{62.37,40.64},{58.52,55},{59.02,48.8},{60.67,53.94},{52.85,47.44},{51.7,46.35},{56.49,47.42},{61.3,41.93},{54.62,44.67},{64.22,51.07},{55.38,51.4},{54.39,43.76},{53.08,50.1},{54.58,50.52},{52.22,56.32},{60.94,48.92},{54.74,53.26},{53.83,54.15},{55.78,43.56},{56,45.35},{52.3,61.83},{62.7,46.05},{53.18,57.65},{53.75,56.55},{52.99,52.99},{52.04,53.68},{53.7,50.93},{53.16,55.62},{65.01,50.72},{57.53,54.28},{63.45,50.22},{56.87,51.46},{61.68,44.26},{51.8,48.82},{54.74,42.3},{64.38,48.89},{56.4,52.78},{52.21,51.88},{59.13,54.12},{64.35,56.24}}},nil,47,nil,nil,14,nil,nil,0},
[2930] = {'Sentinel Glynda Nal\'Shea',2218,2218,45,45,0,nil,nil,0,nil,{4740,4811,4813},80,"A",nil,0},
[2931] = {'Zaricotl',4124,4124,48,48,4,{[3]={{33.21,51.22},{34.29,54.98},{51.21,51.77},{56.12,43.91}}},nil,3,nil,nil,14,nil,nil,0},
[2932] = {'Magregan Deepshadow',1500,1536,37,38,0,nil,{[38]={{{38.22,93.98},{38.12,93.76},{38.09,93.5},{38.09,93.27},{38.02,92.92},{38.02,92.6},{38.01,92.26},{38.09,91.97},{38.13,91.7},{38.12,91.4},{38.16,91.14},{38.3,91.02},{38.45,91},{38.57,90.94},{38.78,90.63},{38.94,90.48},{39.12,90.28},{39.29,90.15},{39.44,90.14},{39.5,90.22},{39.5,90.37},{39.4,90.43},{39.26,90.42},{39.07,90.46},{38.76,90.59},{38.6,90.66},{38.39,90.63},{38.22,90.63},{38.08,90.53},{37.95,90.3},{37.85,90.1},{37.78,89.89},{37.52,89.56},{37.74,89.87},{37.9,90.2},{38.02,90.44},{38.12,90.55},{38.27,90.62},{38.44,90.63},{38.57,90.68},{38.63,90.83},{38.56,91},{38.42,91.04},{38.26,91.07},{38.14,91.14},{38.06,91.35},{38.11,91.52},{38.24,91.57},{38.4,91.68},{38.56,91.84},{38.67,92.11},{38.92,92.25},{39.05,92.4},{39.07,92.74},{39.04,93}}},[3]={{{39.75,18.87}}}},0,nil,nil,14,nil,nil,0},
[2934] = {'Keeper Bel\'dugur',1981,1981,42,42,0,{[85]={{59.21,76.62}}},nil,85,nil,{728,736,1013},68,"H",nil,0},
[2935] = {'[PH] Demon Master',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Demon Trainer",0},
[2937] = {'Dagun the Ravenous',5148,5148,43,43,1,nil,nil,0,nil,nil,14,nil,nil,0},
[2938] = {'Aldric Hunter',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Bear Trainer",0},
[2939] = {'Jackson Bayne',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Boar Trainer",0},
[2941] = {'Lanie Reed',232470,232470,85,85,1,{[51]={{37.94,30.86}}},nil,51,nil,nil,55,"A","Gryphon Master",8193},
[2942] = {'Dylan Bissel',166,166,5,5,0,nil,nil,0,nil,nil,1080,"AH","Wolf Trainer",0},
[2943] = {'Ransin Donner',1220,1220,35,35,0,{[1537]={{50.14,12.69}}},nil,1537,nil,nil,55,"A",nil,1},
[2944] = {'Boss Tho\'grun',1902,1981,41,42,0,nil,{[3]={{{12.72,75.48},{13.32,76.41},{13.93,77.28},{14.68,78.03},{16.11,78.29},{16.95,78.41},{18.21,78.5},{19.37,78.3},{20.12,78.49},{21.58,77.97},{22.23,77.17},{23.51,75.51},{24.77,73.83},{26.07,72.85},{27.1,72.89},{28.32,73.45},{30.15,73.53},{31.41,73.34},{33.08,72.99},{34.34,72.72},{35.33,72.52},{37.01,72.17},{38.27,72.11},{39.96,72.13},{41.65,72.17},{43.33,72.26},{44.46,72.58},{45.91,72.71},{46.8,71.75},{48.15,72.73},{49.22,73.74},{50.39,73.71},{51.21,73.4},{53.28,72.8},{54.95,72.53},{56.63,72.31},{58.31,72.06},{59.15,71.91},{60.75,70.77},{61.54,69.91},{61.45,69.3},{61.14,67.46},{60.14,65.45},{59.13,64.3},{57.78,62.79},{56.77,61.64},{55.75,60.51},{54.74,59.37},{54.05,58.64},{52.72,57.35},{52.24,54.92},{52.56,53.09},{52.49,51.29},{51.81,50.2},{50.76,49.14},{49.68,48.82},{48.84,48.67},{47.5,49.11},{46.55,50.22},{45.61,51.5},{44.09,52.75},{42.92,53.48},{41.75,54.22},{40.59,54.96},{38.78,56.1},{37.31,57.34},{36.61,58.07},{35.42,59.31},{34.59,60.09},{33.8,59.64},{33.01,59.19},{32.62,58.97},{31.51,58.66},{31,58.69},{30.33,58.49},{29.04,57.78},{28.22,57.47},{26.99,57.02},{26.21,56.84},{25.37,56.74},{24.72,56.74},{23.95,56.89},{23.12,57.11},{21.68,58.19},{20.84,58.1},{19.38,57.97},{19.19,58.54},{18.76,59.89},{18.16,60.77},{17.46,62.09},{16.1,63.49},{16.1,63.49},{15.4,64.21},{14.22,65.19},{13.29,65.17},{13.17,65.53},{12.5,67.46},{11.53,69.16},{11.66,70.97},{11.58,73.38},{11.78,73.83},{12.05,74.36}}}},0,nil,nil,14,nil,nil,0},
[2945] = {'Murdaloc',1981,1981,42,42,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2946] = {'Puppet of Helcular',178,178,42,42,0,nil,nil,0,nil,nil,1801,"H",nil,0},
[2947] = {'Harken Windtotem',531,531,21,21,0,{[215]={{48.79,58.79}}},nil,215,{761},{761},83,"H",nil,2},
[2948] = {'Mull Thunderhorn',713,713,25,25,0,{[215]={{48.62,59.8}}},nil,215,{20440,24440,24441,24456,24457},{748,754,756,758,759,760,20440,24440,24441,24456},104,"H",nil,2},
[2949] = {'Palemane Tanner',98,98,5,6,0,{[215]={{33.04,59.18},{33.76,61.16},{48.29,70.95},{47.68,70.62},{49.09,71.4},{53.62,72.53},{36.38,61.73},{36.57,60.25},{33.73,60.66},{36.28,61.34},{36.38,63.49},{35.66,62},{34.43,60.45},{34.09,61.72},{34.02,60.57},{32.9,60.09},{49.28,70.29},{48.89,69.9},{48.44,70.53},{49.28,70.29},{48.82,69.84},{49.1,71.3},{48.44,70.53},{48.26,70.97},{47.66,70.77},{48.86,69.79},{36.4,63.44},{36.37,61.73},{36.59,60.3},{36.37,61.73},{36.28,61.34},{36.6,60.33},{36.28,61.35}}},nil,215,nil,nil,39,nil,nil,0},
[2950] = {'Palemane Skinner',115,115,5,6,0,{[215]={{32.57,59.47},{30.81,59.78},{31.48,59.21},{32,61.74},{30.94,59.78},{31.82,59.97},{33.38,60.59},{49.67,70.66},{48.69,72.15},{47.79,71.74},{48.52,71.77},{36.03,61.14},{36.35,62.61},{34.06,60.8},{33.28,59.85},{32.7,60.17},{48.12,69.97},{47.14,70.87},{47.05,70.68},{47.81,71.66},{48.07,69.95},{36.28,62.64}}},nil,215,nil,nil,39,nil,nil,0},
[2951] = {'Palemane Poacher',120,120,5,6,0,{[215]={{31.95,59.83},{32.06,60.89},{51.86,69.82},{31.31,60.91},{31.47,60.52},{32.35,61.58},{31.73,61.92},{32.31,61.49},{31.3,59.9},{31.67,61.29},{36.93,62.18},{37.01,61.2},{34.98,61.37},{31.89,59.89},{36.87,62.32},{36.99,61.24},{36.95,62.12},{36.99,61.21}},[357]={{71.87,0.04}}},nil,215,nil,nil,39,nil,nil,0},
[2952] = {'Bristleback Invaders',0,0,1,2,0,{[6452]={{52.32,41.04},{52.33,39.32},{51.33,38.49},{51.39,43.4},{52.17,33.5},{52.15,35.13},{55.31,23.75},{54.53,25.41},{54.57,26.94},{53.82,28.11},{53.91,28.6},{55.7,26},{56.44,25.66},{53.87,30.66},{53.87,32.28},{53.14,34.42},{52.95,32.41},{58.02,27.01},{55.17,29.37},{55.85,27.98},{57.04,26.94},{59,25.34},{59.77,26.14},{57,29.4},{57.71,29.3},{56.76,28.36},{56.98,30.6},{53.67,35.2},{55.36,34.93},{54.97,32.79},{55.45,34.72},{55.99,32.7},{57.8,30.56},{56.55,34.03},{57.05,32.52},{58.3,34.3},{58.08,35.33},{56.09,37.66},{57.18,34.88},{57.49,34.18},{56.42,35.32},{58.97,33.45},{59.92,32.19},{59.76,33.37},{58.18,37.58},{57.09,37.32},{57.48,36.62},{59.57,35.19},{61.51,40.41},{69.1,63.57},{68.56,62.33},{68.39,60.37},{67.49,59.59},{66.51,58.01},{65.51,56.52},{66.18,52.45},{66.57,56.26},{64.53,52.21},{65.05,51.25},{65.08,54.46},{60.34,40.48},{63.6,52.82},{63.11,49.97},{62.92,51.77},{63.5,51.28},{64.21,50.59},{61.84,42.66},{60.65,47.6},{60.83,45.77},{56.69,39.22},{57.13,39.38},{57.54,40.46},{59.31,42.01},{58.84,42.83},{60.04,48.32},{59.24,43.16},{59.57,47.37},{60.52,45.77},{59.6,45.68},{50.98,38.83},{52.09,39.34},{56.71,41.77},{58.12,45.55},{58.12,49.77},{57.83,42.15},{57.33,48.52},{57.72,48.67},{57.16,51},{57.9,47.82},{58.09,43.82},{52.29,41.14},{55.81,49.02},{55.16,46.7},{56.04,46.25},{55.98,48.07},{55.43,48.54},{53.9,43.44},{54.65,42.77},{53.38,42.34},{54.54,44.3},{51.7,45.41},{51.88,43.24},{55.23,50.51},{53.59,46.34},{54.18,48.78},{48.23,48.99},{52.18,46.83},{50.87,45.69},{50.61,46.43},{49.57,46.57},{51,47.72},{51.57,46.43},{49.73,48.64},{50.09,49.23},{49.03,50.53},{50.37,51.63},{45.39,55.18},{45.54,54.04},{45.94,54.57},{51.34,50.57},{52.02,51.09},{48.22,53.18},{48.19,54.42},{47.8,54.26},{47.46,56.12},{45.74,58.02},{45.01,57.41},{45,58.33},{45.29,60.22},{43.34,60.3},{42.34,59.82},{42.18,61.47}}},nil,6452,nil,nil,189,"AH",nil,0},
[2953] = {'Bristleback Shaman',69,83,3,4,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2954] = {'Bristleback Battleboar',86,102,4,5,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2955] = {'Plainstrider',0,0,1,2,0,{[6452]={{29.51,35.65},{32.98,27.64},{29.13,42.71},{27.39,46.32},{29.04,57.54},{33.35,56.83},{28.22,51.54},{31.32,54.15},{41.99,43.64},{34.59,49.82},{37.96,48.98},{34.42,46.12},{36.58,40.53},{30.06,42.45},{32.8,38.98},{29.84,38.77},{32.6,26.59},{33.23,21.54},{38.54,32.49},{34.71,26.49},{35.84,22.47},{40.25,28.39},{36.76,26.18},{40.9,23.95},{42.54,20.39},{47.25,16.95},{42.76,26.31},{48.06,21.35},{45.69,24.03},{32.55,57.5},{27.87,62.76},{27.63,76.78},{21.41,77.97},{24.5,73.41},{16.74,66.07},{24.04,64.9},{21.49,65.48},{17.7,64.54},{25.19,54.79},{20.08,59.16},{21.8,56.08},{26.8,45.97},{20.11,52.29},{24.32,48.86},{8.42,33.42},{9.17,30.79},{10.21,33.64},{12.37,35.07},{13.68,37.99},{14.31,33.8},{15.99,33.64},{19.95,41.78},{21.21,37.61},{23.92,40.02},{20.37,27.41},{21.16,23.82},{29.67,19.06},{32.25,26.77},{24.79,35.31},{29.14,35.19},{23.66,31.33},{25.44,23.72}}},nil,6452,nil,nil,189,"AH",nil,0},
[2956] = {'Adult Plainstrider',120,120,5,6,0,{[215]={{64.54,59.31},{66.08,59.12},{62.13,57.46},{46.75,35.07},{60.91,57.03},{36.45,71.28},{49.64,36.17},{65.82,64.3},{43.64,39},{65.47,57.17},{45.42,37.93},{57.81,48.94},{35.39,76.39},{40.15,68.71},{62.17,60.02},{51.81,35.19},{35.88,73.27},{65.83,61.87},{37.69,70.2},{43.13,64.36},{38.78,69.92},{40.79,69.17},{37.71,68.33},{36.31,77.34},{37.86,55.45},{38.92,67.57},{43.08,61.57},{36.62,66.7},{63.98,64.65},{37.34,77.2},{38.9,56.38},{37.19,60.05},{62.9,63.02},{61.66,66.21},{62.83,64.57},{61.6,64.69},{59.08,51.79},{52.32,37.92},{38.33,36.41},{36.98,34.1},{56.69,58.27},{59.58,68.47},{43.29,66.38},{42.54,64.94},{42.02,68.16},{41.18,66.46},{39.61,66.48},{40.29,64.58},{36.68,64.7},{37.43,62.72},{38.93,66.01},{37.9,65.52},{40.28,62.42},{40.23,55.25},{40.11,52.83},{44.33,53.75},{39.23,54.46},{43.07,53.65},{38.63,63.82},{56.45,46.3},{56.91,65.49},{42.31,51.79},{43.23,55.3},{67.16,61.4},{45.42,52.39},{64.06,66.93},{45.82,68.71},{40.77,52.77},{41.32,56.57},{58.84,65.32},{42.69,60.09},{37.74,58.2},{56.65,62.28},{55.42,62.95},{52.32,67.17},{46.31,43.79},{57.88,62.14},{59.08,63.52},{62.09,68.24},{57.98,50.74},{59.67,52.76},{55.39,47.17},{43.87,52.16},{41.32,54.67},{49,66.62},{50.73,68.91},{48.65,48.2},{51.23,41.7},{52.98,62.68},{54.21,61.33},{51.73,69.24},{49.88,45.31},{43.3,70.22},{51.1,64.47},{57.35,67.36},{57.72,69.46},{47.47,69.08},{47.86,67.3},{51.82,57.26},{54.14,58.18},{54.3,55.66},{52.98,61.02},{47.39,64.27},{47.15,65.23},{43.88,65.14},{41.27,61.13},{40.75,60.06},{38.83,61.74},{37.72,38.23},{43.79,69.19},{45.88,65.52},{45.11,51.65},{41.33,58.72},{40.19,57.35},{53.25,58.32},{50.74,64.56},{47.13,63.55},{52.37,67.27},{54.2,63.06},{37.72,62.61},{52.3,46.57},{55.46,50.86},{46.97,50.09},{54.11,55.77},{54.42,58.28},{53.05,58.88},{51.14,63.7},{51.97,57.32},{57.87,56.32},{45.13,51.51},{45.31,52.61},{35.77,35.2}},[1638]={{32.81,37.75}}},nil,215,nil,nil,189,"AH",nil,0},
[2957] = {'Elder Plainstrider',156,156,8,9,0,{[215]={{53.46,15.29},{53.73,31.59},{58.99,24.45},{47.51,37.91},{61.49,54.56},{53.63,23.99},{57.78,23.53},{51.25,16.88},{52.72,16.29},{49.72,15.58},{52.34,34.33},{49.35,27.06},{56.81,43.29},{49.11,38.96},{47.61,27.82},{55.38,30.78},{55,25.19},{54.78,29.76},{56.72,29.1},{45.53,33.18},{61.06,59.22},{57.27,26.89},{47.45,13.07},{51.15,11.65},{49.26,23.83},{48.65,12.31},{56.94,31.31},{45.26,18.17},{47.16,29.41},{44.29,12.56},{59.42,26.15},{50.61,10.34},{43.71,44.48},{46.76,42.46},{48.61,40.86},{59.33,53.95},{57.66,56.24},{60.52,26.82},{59.21,28.02},{53.67,35.65},{51.57,21.25},{57.64,47.01},{48.51,18.57},{38.71,41.08},{52.24,13.61},{57.19,53.59},{54.24,21.93},{46.18,20.64},{46.69,15.53},{58.76,22.51},{56.9,20.37},{53.49,19.71},{46.24,12.67},{50.62,25.04},{48.39,46.58},{52.4,19.76},{45,30.19},{48.32,28.82},{51.92,24.06},{53.02,26.2},{51.84,28.92},{51.08,27.76},{49.94,34.34},{45.04,41.66},{45.07,36.86},{44.25,32.45},{59.26,56.31},{47.58,20.67},{43.31,19.63},{55.34,22.36},{51.83,40.18},{50.69,19.34},{54.95,56.36},{48.04,15.72},{46.22,48.27},{55.24,56.23},{56.54,58.16},{56.8,21.66},{44.43,47.65},{56.13,58.18},{46.42,50.66},{52.51,13.6},{53.6,15.09},{49.05,18.6},{47.22,16.14},{47.55,20.52},{48.05,15.79},{48.77,18.88},{35.29,36.59}},[1638]={{76.28,45.05},{35,25.03},{62.7,36.31},{21.5,6.04},{68.07,42.3},{31.08,78.18}}},nil,215,nil,nil,189,"AH",nil,0},
[2958] = {'Prairie Wolf',120,120,6,6,0,{[215]={{36.68,66.59},{43.94,70.86},{35.64,64.73},{35.37,70.76},{35.56,69.86},{37.46,67.04},{39.18,73.74},{41.27,72.7},{66.56,64.44},{35.08,73.48},{36.07,64.01},{35.46,68.25},{38.88,69.82},{39.47,73.18},{34.73,72.65},{35.79,65.66},{38.31,75.73},{38.11,66.97},{36.39,72.76},{36.14,66.73},{35.16,71.99},{39.05,70.96},{38.64,74.44},{35.75,72.21},{35.96,73.63},{39.95,70.03},{35.93,74.96},{37.66,76.68},{36.33,69.88},{35.98,71.09},{36.6,78.74},{39.36,69.44},{36.48,65.09},{37.8,68.12},{39.77,63.09},{35.93,75.99},{42.55,72.47},{58.75,70.35},{65.1,63.96},{66.28,65.77},{42.64,71.23},{38.64,63.52},{39.33,63.91},{58.03,70.24},{66.35,63.79},{66.03,64.96},{67.1,63.55},{67.43,62.67},{43.27,71.58},{41.91,72.17},{40.39,72.74},{63.88,63.6},{35.89,57.68},{36.42,58.27},{60.4,69.33},{63.18,67.62},{63.28,67.81},{58.64,69.44},{48.22,66.78},{44.93,68.91},{49.29,65.16},{35.15,65.28},{50.53,64.69},{35.35,57.83},{35.82,59.76},{43.55,68.87},{59.04,65.62},{47.47,68.25},{49.82,69.61},{51.07,68.49},{51.2,69.52},{42.78,55.97},{41.84,53.59},{41.99,55.37},{42.19,56.28},{49.67,66.37},{57.75,64.42},{57.12,62.94},{56.62,64.5},{37.35,71.99},{55,64.93},{54.9,66.43},{50.31,66.19},{50.36,64.35},{44.99,65.73},{44.28,66.17},{41.92,62.94},{41.84,63.88},{41.14,63.58},{41.13,62.43},{39.11,62.52},{39.73,62.02},{38.65,60.34},{39.09,58.04},{39,59.65},{39.75,58.99},{39.01,60.97},{39.65,59.45},{52.1,61.3},{51.33,63.24},{52.23,63.5},{51.97,62.06},{52.29,61.96},{56.12,61.71},{58,63.25},{59.79,65.88},{53.67,57.19},{52.87,57.65},{53.74,58.51},{44.41,70.05},{46.74,69.91},{48.29,67.96},{50.62,69.31},{50.37,64.28},{49.84,69.49},{44.4,69.41},{43.64,69.06},{46.81,69.96},{62.73,63.76},{49.4,66.33},{49.77,65.5},{52.24,63.59},{49.81,69.62},{54.96,65.18},{55.74,65.32},{56.58,66.27},{65.38,62.85},{64.73,63.01},{63.49,64.8},{60.53,66.55},{60.22,67.72},{59.56,66.86},{59.03,66.82},{54.89,61.91},{54.93,66.27},{55.41,62.11},{51.47,63.05},{41.53,52.63},{39.11,60.87},{52.42,62.21},{52.08,61.12},{60.24,69.36},{53.72,58.39},{50.32,64.73},{52.17,60.89},{54.79,61.7},{56.09,61.9},{57.05,63.08},{51.89,62.1},{52.44,62.16}}},nil,215,nil,nil,38,nil,nil,0},
[2959] = {'Prairie Stalker',156,156,7,8,0,{[215]={{51.78,36.22},{51.06,37.16},{46.86,38.02},{52.83,38.23},{53.08,36.36},{67.03,58.28},{50.53,37.99},{48.17,41.64},{58.99,54.42},{56.17,44.5},{44.37,38.07},{58.45,55.48},{51.28,40.8},{63.47,58.79},{65.16,59.89},{57.94,58.17},{46.8,43.53},{41.89,39.73},{41.77,37.74},{42.61,40.77},{35.2,26.13},{59.2,58.31},{58.43,58.99},{37.78,35.17},{51.15,48.12},{50.54,43.42},{49.2,49.13},{49.43,45.29},{46.87,45.18},{59.02,52.82},{58.49,53.19},{39.57,37.9},{36.35,38.6},{38.86,37.21},{36.33,35.69},{41.21,40.98},{46.98,40},{48.72,38.99},{48.18,39.75},{48.81,35.31},{55.63,55.78},{55.48,53.78},{55.9,59.29},{55.3,58.23},{45.19,48.33},{48.05,49.07},{47.53,50.99},{46.99,47.38},{45.01,42.54},{47.46,49.9},{51.13,46.25},{57.9,60.05},{58.99,60.2},{60.26,58.09},{61.5,57.22},{60.91,55.41},{62.65,58.28},{53.65,46.21},{55.01,49.89},{45.7,47.1},{56.12,59.05},{67.07,58.01},{61.44,57.24},{57.8,43.44},{59.18,58.04},{59.34,46.08},{54.98,48.01},{61.85,51},{55.51,53.59},{57.28,51.47},{56.57,47.1},{58.03,50.94},{56.19,48.18},{57.47,46.33},{42.94,45.19},{58.42,55.54},{58.49,59.18},{58.03,58.36},{57.95,60.13},{54.95,49.84},{56.14,48.02},{54.92,48.12},{43.84,48.04},{56.51,47.34},{59.37,45.95},{47.56,50.83},{57.88,60.06},{48.1,43.65},{48,46.93},{47.6,46.27},{50.04,44.43},{49.46,43.4},{55.2,58.48},{56.04,59.09},{45.76,34.5},{45.61,32.57},{45.68,36.21}}},nil,215,nil,nil,38,nil,nil,0},
[2960] = {'Prairie Wolf Alpha',198,198,9,10,0,{[215]={{55.95,28.04},{45.73,10.81},{55.51,32.66},{56.15,29.56},{53.6,27.82},{54.34,32.66},{44.99,11.46},{56.59,30.88},{52.24,31.17},{53.05,34.43},{52.96,28.79},{54.3,34.39},{49.98,11.16},{50.65,34.22},{54.85,33.41},{56.61,25.25},{49.05,14.11},{48.16,14},{50.49,14.32},{44.46,30.54},{57.27,26.21},{57.87,27.09},{47.05,16.71},{43.85,31.44},{45.26,15.3},{45.15,20.68},{47.58,26.78},{51.73,26.98},{50.44,27.12},{57.35,20.48},{61.55,25.19},{55.49,23.38},{54.84,23.85},{54.14,23.43},{52.99,23.48},{52.92,24.98},{57.93,28.79},{60.2,28.67},{59.09,28.8},{49.41,20.68},{48.02,19.64},{48.7,20.8},{48.95,20.32},{51.24,22.27},{45.61,17.09},{52.34,15.02},{48.74,24.39},{46.8,30.71},{46.92,28.6},{44.97,28.03},{51.28,18.18},{48.1,19.5},{46.79,18.85},{48.59,20.63},{49.25,21.64},{51.22,22.27},{49.94,20.58},{47.92,19.51},{50.03,24.35},{49.35,21.47},{49.85,20.63},{49.93,20.58},{49.28,21.56},{47.1,13.92},{48.64,20.66},{45.63,17.03},{47.48,16.73},{48.8,20.41},{47.96,19.5},{49.91,24.3},{49.24,21.38},{50.01,20.68},{54.26,19.78},{51.12,17.97},{48.75,20.47},{48.03,19.6},{49.32,21.39},{54.95,20.75},{49.98,20.65},{54.97,20.71},{48.62,20.46},{51.17,17.99}},[1638]={{29.63,3.69},{38.95,23.54},{77.94,14.76},{77.85,14.94},{64.6,25.01},{66.15,38.84}}},nil,215,nil,nil,38,nil,nil,0},
[2961] = {'Mountain Cougar',71,71,3,3,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2962] = {'Windfury Harpy',137,137,7,8,0,{[215]={{61.78,70.3},{63.77,68.09},{62.77,69.03},{62.17,69.5},{62.9,71.12},{63.86,69.92},{63.31,69.39},{61.76,70.19},{62.12,69.33},{62.75,69.21}}},nil,215,nil,nil,514,nil,nil,0},
[2963] = {'Windfury Wind Witch',148,148,7,8,0,{[215]={{61.79,70.94},{62.78,70.05},{64.4,67.96},{64.43,69.28},{61.78,70.97},{62.85,70.04}}},nil,215,nil,nil,514,nil,nil,0},
[2964] = {'Windfury Sorceress',178,178,10,10,0,{[215]={{31.05,26.04},{34.77,26.34},{52.52,11.18},{53.22,8.93},{55.43,19.91},{55.03,14.42},{32.71,23.7},{32.92,21.79},{54.21,13.31},{53.81,14.75},{51.75,9.76},{53.78,12.49},{51.17,9.67},{51.71,7.96},{54.23,13.55},{53.74,14.45},{54.98,17.89},{55.93,18.42},{56.01,16.35},{55.83,17.16},{55,14.32},{54.19,13.45},{55.42,19.89}},[1638]={{12.8,29.88}}},nil,215,nil,nil,514,nil,nil,0},
[2965] = {'Windfury Matriarch',186,186,9,10,0,{[215]={{32.74,25.17},{33.6,25.57},{53.37,9.69},{52.58,8.06},{53.45,10.82},{55.56,14.75},{32.53,22.5},{32.14,23.38},{55.9,15.34},{54.88,13.24},{54.9,12.89},{54.76,11.56},{51.79,11.31},{53.42,13.28},{51.93,8.9},{52.44,12.37},{50.99,8.45},{53.3,13.25},{55.35,18.93},{55.9,15.41},{55.51,14.5},{55.06,12.62},{54.85,13.21}},[1638]={{15.24,25},{16.48,32.95}}},nil,215,nil,nil,514,nil,nil,0},
[2966] = {'Young Battleboar',0,0,1,2,0,{[6452]={{50.78,37.87},{46.82,46.03},{51.68,34.46},{52.41,27.88},{51.81,31.01},{53.09,24.23},{54.03,26.14},{57.9,24.56},{55.37,29.18},{53.66,33.5},{57.8,31.4},{56.73,32.45},{55.72,37.87},{59.59,36.91},{61.54,48.19},{58.74,47.45},{59.81,43.35},{55.58,40.18},{57.07,46.43},{56.96,44.25},{51.42,41.05},{53.6,40.27},{53.26,44.8},{54.01,48.37},{48.41,46.72},{50.44,48.22},{47.33,50.44},{49.39,51.22},{43.15,56.42},{43.84,56.03},{42.5,57.27}}},nil,6452,nil,nil,7,"AH",nil,0},
[2967] = {'Galak Centaur',156,176,8,9,0,nil,nil,0,nil,nil,131,nil,nil,0},
[2968] = {'Galak Outrunner',176,198,9,10,0,nil,nil,0,nil,nil,131,nil,nil,0},
[2969] = {'Wiry Swoop',120,120,6,6,0,{[215]={{66.1,58.83},{52.22,35.28},{61.44,59.03},{43.18,46.23},{52.28,37.34},{57.82,52.68},{65.1,57.92},{38.26,42.91},{44.56,36.55},{46.28,33.25},{57.21,54.03},{49.95,35.56},{56.61,45.26},{59.06,58.98},{62.94,57.54},{61,61.16},{49.85,38.92},{49.34,41.61},{48.07,37.85},{47.4,42.41},{51.18,42.96},{55.37,57.36},{48.29,50.14},{49.97,46.39},{59.71,54.45},{57.33,48.12},{63.17,57.55},{59.02,59.28},{55.41,57.21}}},nil,215,nil,nil,73,nil,nil,0},
[2970] = {'Swoop',120,120,5,6,0,{[215]={{38.85,67.3},{37.64,74.53},{38.65,68.49},{37.16,70.85},{66.44,62.63},{35.8,77.55},{38.38,71.17},{37.06,65.48},{37.01,68.44},{37.83,69.44},{40.89,69.4},{35.26,75.6},{37.63,63.72},{35.93,68.15},{37.55,75.47},{38.41,73.24},{39.93,67.4},{35.11,76.63},{35.84,77.56},{41.49,67.87},{40.75,56.35},{65.06,65.58},{37.66,59.2},{38.28,58.1},{64.47,67.18},{62.65,66.23},{44.57,53.37},{43.37,52.58},{61.03,65.4},{53.35,61.1},{53.93,62.04},{53.15,62.76},{51.83,66.45},{57.79,65.47},{58.54,64.58},{61.05,68.42},{53.49,67.55},{52.42,68.96},{37.63,56.51},{37,57.34},{40.5,53.43},{39.53,55.4},{38.28,55.35},{43.63,54.34},{56.1,63},{55.55,64.04},{54.65,63.42},{51.09,67.45},{41.36,65.63},{43.1,64.71},{42.61,66.55},{42.65,62.86},{42.01,60.77},{40.73,60.9},{37.98,61.2},{51.4,64.37},{40.79,58.97},{49.97,68.25},{63.44,66.24},{51.78,64.55},{51.83,66.6},{53.56,67.57},{57.92,68.47},{57.95,67.15},{59,68.5},{61.49,67.3},{62.05,64.76},{37.95,61.16},{53.47,61.04},{56.22,63.08},{53.92,62.04},{53.53,61.15},{54.04,61.91},{53.49,61}}},nil,215,nil,nil,73,nil,nil,0},
[2971] = {'Taloned Swoop',176,176,8,9,0,{[215]={{48.92,25.89},{59.63,29.68},{55.47,27.08},{48.12,23.7},{54.26,28.75},{56.04,31.62},{46.43,14.75},{51.31,13.39},{50.7,20.37},{43.77,13.25},{58.15,20.62},{42.09,14.12},{52.25,26.26},{51.74,23.23},{52.23,29.4},{49.95,33.61},{58.89,21.28},{48.95,22.7},{52.86,21.81},{52.35,33.32},{56.63,19.81},{53.63,16.51},{51.28,13.28},{48.93,22.6},{46.45,14.83},{48.92,22.74},{54.27,18.39},{48.92,22.67},{51.21,20.37},{48.81,22.66},{50.7,20.41}},[1638]={{72.95,13.89},{60.71,33.38},{85.57,20.54},{67.57,12.47},{85.75,21.72},{72.56,13.51},{65.72,18.86},{67.61,12.67}}},nil,215,nil,nil,73,nil,nil,0},
[2972] = {'Kodo Calf',156,156,7,8,0,{[215]={{53.76,37.16},{53.25,37.13},{64.85,64.56},{64.88,64.05},{48.24,48.91},{48.08,48.59},{57.58,23.98}}},nil,215,nil,nil,15,"AH",nil,0},
[2973] = {'Kodo Bull',198,198,10,11,0,{[215]={{61.36,60.33},{47.63,49.3},{57.04,22.4},{57.27,24.23}}},nil,215,nil,nil,15,"AH",nil,0},
[2974] = {'Kodo Matriarch',247,247,11,12,0,{[215]={{53.47,37.36},{38.68,61.97},{38.69,55.22},{64.96,64.15},{48.2,48.75},{57.48,24.43}}},nil,215,nil,nil,15,"AH",nil,0},
[2975] = {'Venture Co. Hireling',102,120,5,6,0,nil,nil,0,nil,nil,47,nil,nil,0},
[2976] = {'Venture Co. Laborer',137,137,6,7,0,{[215]={{52.68,48.69},{52.64,49.56},{53.2,47.47},{54.33,48.22},{53.46,47.9},{53.28,48.52},{53.59,47.3},{54.22,48.95},{52.63,49.51},{54.29,48.23},{53.27,48.51},{54.21,48.92},{53.46,47.91},{54.31,48.27},{54.22,48.92}}},nil,215,nil,nil,47,nil,nil,0},
[2977] = {'Venture Co. Taskmaster',156,156,7,8,0,{[215]={{53.1,49.34},{53.89,47.78},{52.96,47.99},{53.74,49.2},{53.95,49.11},{53.19,49.28},{53.81,49.12},{53.79,48.51},{53.87,47.82}}},nil,215,nil,nil,47,nil,nil,0},
[2978] = {'Venture Co. Worker',137,137,7,8,0,{[215]={{62.62,41.8},{61.88,42.72},{64.47,41.23},{62.41,41.73},{62.34,43.08},{64.56,41.71},{62.17,40.61},{62.21,41.38},{62.53,42.19},{64.75,41.19},{62.58,40.69},{61.6,42.8},{60.44,40.38},{61.59,41.38},{61.19,42.42},{60.94,42.06},{64.68,41.62},{61.87,40.48},{63.22,40.95},{62.52,42.74},{64.88,43.59},{61.19,42.77},{63.36,40.66},{61.72,41.93},{62.23,42.66},{60.03,42.42},{64.01,44.94},{63.74,43.18},{64.13,43.39},{63.41,42.74},{64.24,43.81},{64.6,43.74},{63.41,43.1},{62.21,43.92},{62.2,44.37},{61.98,44.15},{62.48,43.74},{60.89,43.08},{59.42,43.32},{61.8,44.75},{61.28,43.59},{59.57,43.56},{61.6,44.4},{60.48,43.06},{60.9,43.5},{60.39,41.13},{61.68,42.32},{63.73,40.45},{61.66,40.97},{59.13,47.36},{59.37,48.9},{61.41,48.3},{58.24,47.28},{59.48,46.23},{58.09,48.08},{58.49,48.66},{61.16,49.47},{59.01,48.15},{59.83,51.51},{59.89,49.4},{59.37,50.62},{59.9,50.47},{58.85,49.73},{60.53,49.67},{61.47,46.31},{60.72,47.77},{59.88,50.49},{59.86,51.48},{61.19,49.4},{59.91,49.43},{60.52,49.63},{58.87,49.7},{60.72,47.66},{61.42,48.3},{61.36,45.83},{62.37,45.72},{62.72,45.16},{62.01,46.1},{59.48,46.24},{59.91,49.42},{59.35,48.84},{61.21,49.44},{60.55,49.61}}},nil,215,nil,nil,47,nil,nil,0},
[2979] = {'Venture Co. Supervisor',137,137,7,8,0,{[215]={{62.1,41.81},{61.92,41.1},{60.43,42.07},{62.8,41.45},{61.49,40.15},{60.25,42.38},{62.31,40.06},{60.99,41.54},{62.71,40.82},{61.94,42.29},{63.74,44.89},{63.59,43.53},{63.94,44.44},{63.96,44.09},{60.72,41.78},{62.21,45.14},{60.44,41.66},{60.71,41.29},{60.64,42.55},{60.23,42.96},{59.75,43.02},{60.73,40.5},{61.38,41.59},{61.46,42.51},{61.66,45.84},{59.79,48.66},{59.64,48.38},{59.41,45.29},{60.96,46.6},{60.88,47.14},{60.96,46.52},{61.93,45.52},{59.4,45.33},{59.79,48.64},{60.96,46.54},{61.65,45.81},{61.94,45.53},{63.73,44.85},{62.21,45.13}}},nil,215,nil,nil,47,nil,nil,0},
[2980] = {'Grull Hawkwind',0,0,4,4,0,{[6452]={{39.45,37.26}}},nil,6452,{14452,14458,24852},{14449,14452,24852},104,"H",nil,3},
[2981] = {'Chief Hawkwind',0,0,36,36,0,{[6452]={{27.73,28.28}}},nil,6452,{14449,23733,24861},{14460,24861},104,"H",nil,3},
[2982] = {'Seer Graytongue',156,156,8,8,0,nil,nil,0,nil,{755},104,"H",nil,0},
[2983] = {'The Plains Vision',137,137,7,7,0,nil,nil,0,nil,nil,1801,"H",nil,0},
[2984] = {'Seer Wiserunner',222,222,11,11,0,nil,nil,0,nil,{772},104,"H",nil,0},
[2985] = {'Ruul Eagletalon',176,176,9,9,0,{[215]={{47.5,61.33}}},nil,215,{743},{743},104,"H",nil,2},
[2986] = {'[Deprecated for 4.x]Dorn Plainstalker',950,950,29,29,0,nil,nil,0,nil,{1149,1150,1151,1394},104,"H",nil,0},
[2987] = {'Eyahn Eagletalon',247,247,12,12,0,{[215]={{49.59,17.59}}},nil,215,{744},{744},83,"H",nil,2},
[2988] = {'Morin Cloudstalker',198,198,10,10,0,{[215]={{57.06,60.43}}},{[215]={{{57.2,61.22},{57.55,61.32},{57.99,61.54},{58.31,61.72},{58.64,61.89},{58.96,62.06},{59.28,62.24},{59.6,62.41},{59.92,62.59},{60.24,62.76},{60.56,62.93},{60.99,63.17},{61.42,63.34},{61.84,63.43},{62.62,63.39},{62.82,63.37},{63.22,63.3},{63.97,63},{64.61,62.68},{64.81,62.59},{65.46,62.31},{65.79,62.16},{66.12,62.02},{66.4,61.9},{66.77,61.69},{67.08,61.47},{67.39,61.25},{67.68,61.04},{68.04,60.85},{68.58,60.64},{69.08,60.52},{69.42,60.51},{68.89,60.5},{68.45,60.64},{68.22,60.72},{67.52,61.09},{67.11,61.4},{66.93,61.54},{66.47,61.83},{66.08,62},{65.75,62.14},{65.43,62.28},{65.1,62.43},{64.77,62.57},{64.44,62.71},{64.12,62.85},{63.79,63},{63.46,63.14},{63.02,63.33},{62.59,63.44},{62.16,63.46},{61.82,63.41},{61.37,63.33},{61.01,63.2},{60.69,63},{60.37,62.81},{60.06,62.62},{59.74,62.43},{59.43,62.24},{58.6,61.79},{58.39,61.67},{58.07,61.52},{57.59,61.29},{57.26,61.2},{56.89,61.1},{56.55,61.06},{56.18,61.02},{55.79,60.91},{55.37,60.69},{54.94,60.54},{54.51,60.45},{53.97,60.45},{53.53,60.4},{53.09,60.28},{52.45,59.94},{52.03,59.72},{51.82,59.51},{52.25,59.83},{52.63,60.09},{53,60.25},{53.2,60.33},{53.63,60.44},{53.97,60.47},{54.31,60.51},{54.65,60.55},{55.02,60.6},{55.43,60.73},{55.88,60.97},{56.32,61.09},{56.94,61.13}}}},215,{749,764,765,26179,26180},{751,764,765,24459,26179,26180},104,"H",nil,2},
[2989] = {'Bael\'dun Digger',137,156,7,8,0,nil,nil,0,nil,nil,57,"A",nil,0},
[2990] = {'Bael\'dun Appraiser',143,160,8,9,0,nil,nil,0,nil,nil,57,"A",nil,0},
[2991] = {'Greatmother Hawkwind',176,176,9,9,0,nil,nil,0,nil,{752,14453},104,"H",nil,0},
[2992] = {'Healing Ward V',20,20,33,54,0,nil,nil,0,nil,nil,154,nil,nil,0},
[2993] = {'Baine Bloodhoof',198,198,10,10,0,nil,nil,0,nil,{745,746,763},104,"H",nil,2},
[2994] = {'Ancestral Spirit',176,176,9,9,0,{[215]={{60.79,22.68}}},nil,215,nil,{773},104,"H",nil,2},
[2995] = {'Tal',232470,232470,85,85,1,{[1638]={{47.04,49.59}}},nil,1638,{6364},{6363},104,"H","Wind Rider Master",8195},
[2996] = {'Torn',5544,5544,45,45,0,{[1638]={{47.63,58.58}}},nil,1638,nil,nil,104,"H","Banker",131073},
[2997] = {'Jyn Stonehoof',1003,1003,30,30,0,{[1638]={{41.42,62.36}}},nil,1638,nil,nil,104,"H","Weapons Merchant",4480},
[2998] = {'Karn Stonehoof',1342,1342,35,35,0,{[1638]={{39.38,55.09}}},nil,1638,nil,nil,104,"H","Blacksmithing Trainer",81},
[2999] = {'Taur Stonehoof',1003,1003,30,30,0,{[1638]={{39.82,55.65}}},nil,1638,nil,nil,104,"H","Blacksmithing Supplies",4224},
[3000] = {'Gibbert',2218,2218,45,45,0,{[490]={{54.99,61.81}}},nil,490,nil,nil,2263,"AH","Weapon Merchant",4224},
[3001] = {'Brek Stonehoof',1342,1342,35,35,0,{[1638]={{34.37,57.9}}},nil,1638,nil,nil,104,"H","Mining Trainer",81},
[3002] = {'Kurm Stonehoof',1753,1753,40,40,0,{[1638]={{34.35,56.56}}},nil,1638,nil,nil,104,"H","Mining Supplies",128},
[3003] = {'Fyr Mistrunner',1003,1003,30,30,0,{[1638]={{41.44,53.19}}},nil,1638,nil,nil,104,"H","Bread Vendor",640},
[3004] = {'Tepa',1342,1342,35,35,0,{[1638]={{44.52,45.35}}},nil,1638,nil,nil,104,"H","Tailoring Trainer",81},
[3005] = {'Mahu',1003,1003,30,30,0,{[1638]={{43.8,45.12}}},nil,1638,nil,nil,104,"H","Tailoring Supplies",128},
[3007] = {'Una',2399,2399,46,46,0,{[1638]={{41.5,42.57}}},nil,1638,nil,{2860},104,"H","Leatherworking Trainer",81},
[3008] = {'Mak',664,664,24,24,0,{[1638]={{42.06,43.45}}},nil,1638,nil,nil,104,"H","Leatherworking Supplies",129},
[3009] = {'Bena Winterhoof',1342,1342,35,35,0,{[1638]={{46.62,33.17}}},nil,1638,nil,{2440,29067,29481,29482},104,"H","Alchemy Trainer",81},
[3010] = {'Mani Winterhoof',1003,1003,30,30,0,{[1638]={{47.41,33.74}}},nil,1638,nil,nil,104,"H","Alchemy Supplies",128},
[3011] = {'Teg Dawnstrider',1342,1342,35,35,0,{[1638]={{45.31,38.44}}},nil,1638,nil,nil,104,"H","Enchanting Trainer",81},
[3012] = {'Nata Dawnstrider',1003,1003,30,30,0,{[1638]={{44.9,37.66}}},nil,1638,nil,nil,104,"H","Enchanting Supplies",128},
[3013] = {'Komin Winterhoof',1342,1342,35,35,0,{[1638]={{49.95,40.41}}},nil,1638,nil,nil,104,"H","Herbalism Trainer",81},
[3014] = {'Nida Winterhoof',1003,1003,30,30,0,{[1638]={{49.57,39.57}}},nil,1638,nil,nil,104,"H","Herbalism Supplies",128},
[3015] = {'Kuna Thunderhorn',1003,1003,30,30,0,{[1638]={{47,45.7}}},nil,1638,nil,nil,104,"H","Bowyer & Fletching Goods",4480},
[3016] = {'Tand',1003,1003,30,30,0,{[1638]={{49.05,34.24}}},nil,1638,nil,nil,104,"H","Basket Weaver",128},
[3017] = {'Nan Mistrunner',1003,1003,30,30,0,{[1638]={{47.34,42.49}}},nil,1638,nil,nil,104,"H","Fruit Vendor",640},
[3018] = {'Hogor Thunderhoof',1003,1003,30,30,0,{[1638]={{55.55,57.07}}},nil,1638,nil,nil,104,"H","Guns Merchant",4480},
[3019] = {'Delgo Ragetotem',1003,1003,30,30,0,{[1638]={{54.07,57.23}}},nil,1638,nil,nil,104,"H","Axe Merchant",4225},
[3020] = {'Etu Ragetotem',1003,1003,30,30,0,{[1638]={{53.19,58.29}}},nil,1638,nil,nil,104,"H","Mace & Staff Merchant",4225},
[3021] = {'Kard Ragetotem',1003,1003,30,30,0,{[1638]={{52.98,56.63}}},nil,1638,nil,nil,104,"H","Sword & Dagger Merchant",4225},
[3022] = {'Sunn Ragetotem',1003,1003,30,30,0,{[1638]={{49.63,48.71}}},nil,1638,nil,nil,104,"H","Staff Merchant",4224},
[3023] = {'Sura Wildmane',1003,1003,30,30,0,{[1638]={{51.59,55.02}}},nil,1638,nil,nil,104,"H","War Harness Vendor",4224},
[3024] = {'Tah Winterhoof',1003,1003,30,30,0,{[1638]={{54.14,47.05}}},nil,1638,nil,nil,104,"H",nil,0},
[3025] = {'Kaga Mistrunner',1003,1003,30,30,0,{[1638]={{52.3,47.79}}},nil,1638,nil,nil,104,"H","Meat Vendor",640},
[3026] = {'Aska Mistrunner',2218,2218,45,45,0,{[1638]={{50.72,53.11}}},nil,1638,{29358,29362,29363,29364,29365},{29358,29362,29363,29364,29365},104,"H","Cooking Trainer",83},
[3027] = {'Naal Mistrunner',1753,1753,40,40,0,{[1638]={{50.99,52.45}}},nil,1638,nil,nil,104,"H","Cooking Supplies",128},
[3028] = {'Kah Mistrunner',2218,2218,45,45,0,{[1638]={{56.13,46.38}}},nil,1638,{29345,29346,29348,29349,29354},{29345,29348,29349},104,"H","Fishing Trainer",83},
[3029] = {'Sewa Mistrunner',1753,1753,40,40,0,{[1638]={{55.79,47.02}}},nil,1638,nil,nil,104,"H","Fishing Supplies",640},
[3030] = {'Siln Skychaser',2769,2769,50,50,0,{[1638]={{22.82,21.11}}},nil,1638,nil,nil,104,"H","Shaman Trainer",49},
[3031] = {'Tigor Skychaser',1753,1753,40,40,0,{[1638]={{23.64,18.79}}},nil,1638,nil,nil,104,"H","Shaman Trainer",49},
[3032] = {'Beram Skychaser',4120,4120,60,60,0,{[1638]={{21.99,18.8}}},nil,1638,{27280,28301},nil,104,"H","Shaman Trainer",51},
[3033] = {'Turak Runetotem',2769,2769,50,50,0,{[1638]={{76.48,27.22}}},nil,1638,nil,{31,5926,5927,5928,5932,6002,6130},104,"H","Druid Trainer",51},
[3034] = {'Sheal Runetotem',4120,4120,60,60,0,{[1638]={{77.14,27.02}}},nil,1638,{27283,28289},nil,104,"H","Druid Trainer",51},
[3035] = {'Flatland Cougar',156,156,7,8,0,{[215]={{65.88,57.2},{51.6,34.39},{53.68,37.22},{49.98,40.87},{51.38,38.86},{51.79,41.67},{59.14,44.68},{50.51,39.85},{51.13,35.47},{37.59,40.18},{49.26,39.87},{41.34,38.85},{44.36,50.97},{59.72,55.25},{63.83,58.11},{39.06,40.51},{57.27,55.48},{57.04,44.32},{57.76,56.59},{58.6,57.25},{47.54,44.3},{43.52,37.65},{42.47,38.09},{35.25,31.57},{59.72,59.02},{59.65,57.45},{57.89,45.28},{49.35,47.11},{48.69,44.44},{49.96,47.94},{51.15,44.34},{50.42,41.57},{56.06,46.05},{58.02,54.56},{46.23,39},{37.7,38.17},{36.93,37.03},{37.13,34.21},{46.36,42.73},{45.04,41.06},{46.25,40.77},{44.4,39.85},{47.38,39.04},{48.6,37.01},{47.98,36.26},{45.71,39.88},{47.51,36.92},{46.17,35.17},{55.45,52.32},{55.23,54.8},{58.41,51.91},{56.03,57.47},{45.61,43.43},{46.41,46.41},{39.51,41.7},{43.22,47.23},{51.81,47.07},{60.19,59.81},{60.25,55.11},{59.59,60.95},{60.48,56.65},{62.47,56.46},{62.01,60.45},{55.92,51.39},{46.21,48.12},{59.68,57.26},{61.96,52.38},{55.11,54.81},{56.77,49.01},{57.16,50.2},{54.27,47.05},{54.87,46.34},{52.53,47.16},{44.33,43.44},{43.91,46.46},{47.51,48.21},{55.92,57.4},{58.56,57.36},{57.79,56.49},{57.8,54.57},{60.29,55.29},{58.52,57.33},{45.79,49.19},{44.49,48.84},{46.28,50.07},{39.82,42.77},{40.06,39.19},{59.44,44.75},{47.59,48.01},{47.58,44.18},{50.66,45.23},{48.65,42.58},{46.13,31.47},{45.12,35.53}},[1638]={{27.69,72.1},{28.88,39.55},{25.5,42.86}}},nil,215,nil,nil,14,nil,nil,0},
[3036] = {'Kym Wildmane',1753,1753,40,40,0,{[1638]={{76.78,31.8}}},nil,1638,nil,nil,104,"H","Druid Trainer",49},
[3037] = {'Sheza Wildmane',1003,1003,30,30,0,{[1638]={{69.72,26.74}}},nil,1638,nil,nil,104,"H",nil,0},
[3038] = {'Kary Thunderhorn',2769,2769,50,50,0,{[1638]={{58.49,88.33}}},nil,1638,nil,nil,104,"H","Hunter Trainer",49},
[3039] = {'Holt Thunderhorn',4120,4120,60,60,0,{[1638]={{57.3,89.79}}},nil,1638,{27278,28297},{6089},104,"H","Hunter Trainer",51},
[3040] = {'Urek Thunderhorn',1753,1753,40,40,0,{[1638]={{59.13,86.87}}},nil,1638,nil,nil,104,"H","Hunter Trainer",49},
[3041] = {'Torm Ragetotem',2769,2769,50,50,0,{[1638]={{57.24,87.37}}},nil,1638,nil,nil,104,"H","Warrior Trainer",49},
[3042] = {'Sark Ragetotem',4120,4120,60,60,0,{[1638]={{56.99,89.51}}},nil,1638,{27281,28290},nil,104,"H","Warrior Trainer",51},
[3043] = {'Ker Ragetotem',1753,1753,40,40,0,{[1638]={{57.58,85.5}}},nil,1638,nil,nil,104,"H","Warrior Trainer",49},
[3044] = {'Miles Welsh',1753,1753,40,40,0,{[1638]={{21.68,18.89}}},nil,1638,nil,nil,68,"H","Priest Trainer",177},
[3045] = {'Malakai Cross',2769,2769,50,50,0,{[1638]={{24.56,22.57}}},nil,1638,{27331,27334,28304,28307,28323},nil,68,"H","Priest Trainer",51},
[3046] = {'Father Cobb',4120,4120,60,60,0,{[1638]={{25.64,20.7}}},nil,1638,nil,nil,68,"H","Priest Trainer",49},
[3047] = {'Archmage Shymm',4120,4120,60,60,0,{[1638]={{22.76,14.53}}},nil,1638,{27277,28300},nil,68,"H","Mage Trainer",51},
[3048] = {'Ursyn Ghull',1753,1753,40,40,0,{[1638]={{27.46,16.47}}},nil,1638,nil,nil,68,"H","Mage Trainer",49},
[3049] = {'Thurston Xane',2769,2769,50,50,0,{[1638]={{25.18,20.96}}},nil,1638,nil,nil,68,"H","Mage Trainer",49},
[3050] = {'Veren Tallstrider',531,531,21,21,0,{[1638]={{44.39,44.7}}},nil,1638,{768,769},{768,769},104,"H",nil,2},
[3051] = {'Supervisor Fizsprocket',156,156,8,8,0,{[215]={{61.24,46.32},{61.23,46.26},{61.2,46.31}}},nil,215,nil,nil,47,nil,nil,0},
[3052] = {'Skorn Whitecloud',531,531,21,21,0,{[215]={{49.68,17.23}}},nil,215,{861},{770,774,861},104,"H",nil,4227},
[3053] = {'[Deprecated for 4.x]Synge',1003,1003,30,30,0,nil,nil,0,nil,nil,1801,"H","Gun Merchant",4480},
[3054] = {'Zarlman Two-Moons',137,137,7,7,0,{[215]={{47.89,57.1}}},nil,215,{20441},{767,771,24457},104,"H",nil,2},
[3055] = {'Maur Raincaller',198,198,10,10,0,{[215]={{47.15,56.66}}},nil,215,{26188},{766,26188},104,"H",nil,2},
[3056] = {'Ghost Howl',312,312,8,8,0,{[215]={{38.02,16.23},{36.23,17.56},{39.13,43.28},{43.1,14.81}}},{[215]={{{33.17,25.23},{33.15,24.93},{33.1,24.46},{33.06,24.17}}},[1638]={{{15.4,33.72},{14.85,32.26},{13.5,29.6},{12.88,28.42},{12,26.79}}}},215,nil,nil,38,nil,nil,0},
[3057] = {'Cairne Bloodhoof',5578000,5578000,73,73,3,nil,nil,0,nil,{775,776},104,"H","High Chieftain",3},
[3058] = {'Arra\'chea',240,240,6,6,4,{[215]={{54.41,62.12}}},{[215]={{{53.12,14.24},{53.23,14.62},{53.23,14.62},{53.36,14.98},{53.48,15.34},{53.6,15.71},{53.72,16.07},{53.84,16.44},{53.84,16.44},{53.97,16.8},{54.09,17.17},{54.22,17.53},{54.31,17.89},{54.39,18.28},{54.49,18.84},{54.51,18.95},{54.53,19.25},{54.52,19.43},{54.49,19.83},{54.43,20.23},{54.39,20.64},{54.34,21.04},{54.29,21.44},{54.25,21.85},{54.21,22.25},{54.21,22.25},{54.17,22.65},{54.12,23.05},{54.07,23.46},{54.02,23.86},{53.97,24.26},{53.91,24.66},{53.79,25.46},{53.71,25.85},{53.63,26.24},{53.55,26.74},{53.6,27.12},{53.7,27.5},{53.83,27.86},{53.97,28.21},{54.28,28.88},{54.44,29.21},{54.67,29.72},{54.82,30.23},{54.89,30.6},{54.96,31.28},{54.95,31.57},{54.82,31.96},{54.55,32.38},{54.33,32.61},{54.15,32.73},{53.65,32.73},{53.41,32.55},{53.16,32.37},{52.93,32.16},{52.61,31.83},{52.39,31.41},{52.26,30.9},{52.27,30.44},{52.27,30.44},{52.31,29.62},{52.32,29.21},{52.32,28.53},{52.32,28.17},{52.26,27.38},{52.21,26.98},{52.16,26.58},{52.08,26.18},{51.94,25.4},{51.87,25},{51.8,24.6},{51.74,24.21},{51.61,23.41},{51.55,23.01},{51.51,22.61},{51.46,22.21},{51.34,21.49},{51.25,21.1},{51.15,20.72},{50.95,20.01},{50.74,19.76},{50.37,19.18},{50.31,19.05},{50.18,18.69},{49.94,17.96},{49.88,17.7},{49.72,17.36},{49.56,17.03},{49.43,16.4},{49.52,16.07},{49.79,15.51},{49.92,15.33},{50.14,15.08},{50.57,14.59},{50.79,14.34},{51.05,14.04},{51.17,13.57},{51.31,13.22},{51.68,12.5},{52.04,12.44},{52.34,12.68},{52.53,13.13},{52.72,13.42}}}},215,nil,nil,15,"AH",nil,0},
[3059] = {'Harutt Thunderhorn',0,0,10,10,0,{[6452]={{27.23,28.49}}},nil,6452,{27020},{3091,27020},104,"H","Warrior Trainer",3},
[3060] = {'Gart Mistrunner',0,0,9,9,0,{[6452]={{27.94,27.31}}},nil,6452,{27067},{3094,27067},104,"H","Druid Trainer",3},
[3061] = {'Lanka Farshot',0,0,11,11,0,{[6452]={{28.11,27.85}}},nil,6452,{27021},{3092,27021},104,"H","Hunter Trainer",3},
[3062] = {'Meela Dawnstrider',0,0,10,10,0,{[6452]={{27.54,27.08}}},nil,6452,{27027},{3093,27027},104,"H","Shaman Trainer",3},
[3063] = {'Krang Stonehoof',300,300,14,14,0,{[215]={{49.54,59.98}}},nil,215,nil,nil,104,"H","Warrior Trainer",49},
[3064] = {'Gennia Runetotem',247,247,12,12,0,{[215]={{48.57,59.09}}},nil,215,nil,nil,104,"H","Druid Trainer",49},
[3065] = {'Yaw Sharpmane',222,222,11,11,0,{[215]={{47.94,55.36}}},nil,215,nil,{6061,6065,6066,6067,6087,6088},104,"H","Hunter Trainer",51},
[3066] = {'Narm Skychaser',273,273,13,13,0,{[215]={{48.48,58.63}}},nil,215,nil,nil,104,"H","Shaman Trainer",49},
[3067] = {'Pyall Silentstride',247,247,12,12,0,{[215]={{45.67,57.65}}},nil,215,nil,nil,104,"H","Cooking Trainer",81},
[3068] = {'Mazzranache',206,206,7,7,4,{[215]={{55.71,44.07},{43.28,46.87}}},{[215]={{{50.58,42.31},{50.94,41.83},{51.38,41.14},{51.62,40.58},{51.68,39.91},{51.8,39.22},{51.9,38.63},{51.87,38.01},{51.66,37.31},{51.47,36.92},{51.27,36.79},{50.89,36.77},{50.36,36.89},{50.04,36.79},{49.72,36.49},{49.36,36.4},{48.96,36.53},{48.12,36.61},{47.62,36.74},{47.16,36.96},{46.76,37.15},{46.4,37.37},{45.95,37.77},{45.63,38.29},{45.28,38.67},{44.88,39.06},{44.47,39.36},{43.88,39.82},{43.33,40.15},{42.84,40.39},{42.33,40.44},{41.77,40.75},{41.35,41.14},{40.98,41.68},{40.79,42.24},{40.76,43.06},{40.84,43.79},{41,44.54},{41.23,44.93},{41.69,45.19},{42.05,45.23},{42.26,45.59},{42.39,46.08},{42.53,46.57},{42.8,46.87},{43.23,47.14},{43.69,47.2},{44.1,47.04},{44.62,46.82},{45.04,46.47},{45.4,46.08},{45.77,45.48},{46.06,45.03},{46.41,44.61},{46.79,44.08},{47.22,43.33},{47.69,42.99},{48.11,42.86},{48.67,42.36},{48.85,41.86},{49.21,41.71},{49.75,41.95},{50.15,42.53},{50.42,42.59}}}},215,nil,nil,14,nil,nil,0},
[3069] = {'Chaw Stronghide',617,617,23,23,0,{[215]={{45.7,57.41}}},nil,215,nil,nil,104,"H","Leatherworking Trainer",81},
[3072] = {'Kawnie Softbreeze',0,0,8,8,0,{[6452]={{29.02,26.9}}},nil,6452,nil,nil,104,"H","General Goods",640},
[3073] = {'Marjak Keenblade',0,0,9,9,0,{[6452]={{25.42,29.67}}},nil,6452,nil,nil,104,"H","Weaponsmith",4224},
[3074] = {'Varia Hardhide',0,0,7,7,0,{[6452]={{25.64,29.03}}},nil,6452,nil,nil,104,"H","Leather Armor Merchant",4224},
[3075] = {'Bronk Steelrage',0,0,10,10,0,{[6452]={{25.84,29.75}}},nil,6452,nil,nil,104,"H","Armorer & Shieldcrafter",4224},
[3076] = {'Moorat Longstride',247,247,12,12,0,{[215]={{46.1,57.22}}},nil,215,nil,nil,104,"H","General Goods",896},
[3077] = {'Mahnott Roughwound',222,222,11,11,0,{[215]={{45.91,58.11}}},nil,215,nil,nil,104,"H","Weaponsmith",4224},
[3078] = {'Kennah Hawkseye',198,198,10,10,0,{[215]={{45.75,57.98}}},nil,215,nil,nil,104,"H","Gunsmith",4480},
[3079] = {'Varg Windwhisper',300,300,14,14,0,{[215]={{46.06,58.2}}},nil,215,{6361},{6364},104,"H","Leather Armor Merchant",4227},
[3080] = {'Harant Ironbrace',273,273,13,13,0,{[215]={{46.14,58.23}}},nil,215,nil,nil,104,"H","Armorer & Shieldcrafter",4224},
[3081] = {'Wunna Darkmane',198,198,10,10,0,{[215]={{46.39,57.77}}},nil,215,nil,nil,104,"H","Trade Goods",128},
[3083] = {'Honor Guard',154980,154980,85,85,1,{[1638]={{61.6,52.82},{61.14,55.05},{53.52,49.52},{59.76,52.26},{61.69,50.78},{59.83,51.08}}},nil,1638,nil,nil,105,"H",nil,0},
[3084] = {'Bluffwatcher',116235,116235,85,85,0,{[17]={{44.69,48.6},{44.59,48.51},{48.43,38.41},{48.33,38.31},{64.29,34.47},{64.38,34.6},{59.59,22.5}},[1638]={{44.37,61.71},{45.12,61.32},{43.32,61.49},{80.85,30.76},{35.66,63.09},{43.12,40.01},{43.3,38.63},{41.74,54.82},{26.59,16.92},{58.59,55.33},{50.62,37.78},{51.18,31.51},{30.53,31.05},{38,61.6},{58.81,47.89},{19.22,24.65},{36.28,51.51},{57.74,55.94},{58.05,47.12},{50.44,36.45},{42.71,35.56},{31.01,29.46},{36.97,50.58},{57.11,78},{52.29,23.28}}},nil,1638,nil,nil,83,"H",nil,1},
[3085] = {'Gloria Femmel',484,484,20,20,0,{[44]={{26.06,40.29}}},nil,44,nil,nil,12,"A","Cooking Supplies",128},
[3086] = {'Gretchen Vogel',484,484,20,20,0,{[44]={{22.85,40.93}}},nil,44,nil,nil,12,"A","Waitress",640},
[3087] = {'Crystal Boughman',573,573,22,22,0,{[44]={{22.83,40.31}}},nil,44,nil,nil,12,"A","Cooking Trainer",81},
[3088] = {'Henry Chapal',713,713,25,25,0,{[44]={{23.71,38.47}}},nil,44,nil,nil,12,"A","Gunsmith",4224},
[3089] = {'Sherman Femmel',531,531,21,21,0,{[44]={{26.16,40.09}}},nil,44,nil,nil,12,"A","Butcher",640},
[3090] = {'Gerald Crawley',713,713,25,25,0,{[44]={{24.75,38.32}}},nil,44,nil,nil,12,"A","Poison Supplies",1152},
[3091] = {'Franklin Hamar',787,787,26,26,0,{[44]={{26.51,42.04}}},nil,44,nil,nil,12,"A","Tailoring Supplies",128},
[3092] = {'Tagain',1003,1003,30,30,0,{[1638]={{43.44,44.34}}},nil,1638,nil,nil,104,"H","Cloth Armor Merchant",4224},
[3093] = {'Grod',1003,1003,30,30,0,{[1638]={{42.66,43.51}}},nil,1638,nil,nil,104,"H","Leather Armor Merchant",4224},
[3094] = {'Unseen',2138,2292,49,51,0,{[10]={{17.53,54.79},{19.23,55.04},{66.44,76.67},{55.14,60.21},{54.39,59.23},{53.69,60.55},{52.11,62.25},{51.79,61.46},{14.34,67.07},{21.34,57.25},{18.13,57.94},{17.38,56.38},{17.98,54.71},{18.12,54.34},{21.12,55.5},{18.06,54.34},{66.2,76.4},{65.53,67.84},{66.02,69.3},{65.26,67.68},{65.56,67.39},{54.41,60.1},{53.7,61.86},{19.22,53.39},{19.21,53.76},{77.47,36.22},{78.54,35.04},{78.64,36.22}}},nil,10,nil,nil,15,"AH",nil,0},
[3095] = {'Fela',1003,1003,30,30,0,{[1638]={{42.75,44.8}}},nil,1638,nil,nil,104,"H","Heavy Armor Merchant",4224},
[3096] = {'Captured Servant of Azora',573,573,22,22,0,nil,nil,0,nil,nil,35,"AH","Specialist Tailoring Supplies",128},
[3097] = {'Bernard Brubaker',484,484,20,20,0,nil,nil,0,nil,nil,12,"A","Leather Armor Merchant",4224},
[3098] = {'Mottled Boar',0,0,1,1,0,{[6451]={{52.17,52.45},{52.29,53.53},{51.77,53.77},{51.21,54.13},{51.06,55.23},{52.31,54.47},{52,55.16},{52.94,53.73},{52.49,52.61},{47.42,46.24},{47.12,47.04},{48.38,46.21},{47.18,48.3},{45.68,52.74},{45.9,51.46},{48.33,47.62},{46.83,49.62},{47.22,49.4},{48.04,48.48},{47.47,49.21},{46.96,51.16},{47.87,49.66},{48.18,49.7},{47.11,52.51},{47.76,50.66},{52.58,53.46},{51.87,53.89},{51.81,53.83},{51.59,52.27},{51.78,53.77},{51.27,54.32},{52.39,53.92},{51.95,54.59},{51.6,54.94},{52.53,55.67},{46.69,53.1},{51.93,56.84},{50.66,55.18},{51.23,55.74},{52.28,56.91},{46.11,53.72},{46.81,54.29}}},nil,6451,{25126},nil,189,"AH",nil,0},
[3099] = {'Dire Mottled Boar',120,120,7,7,0,{[14]={{55.59,35.49},{54.57,34.91},{55.5,32.07},{56.02,36.54},{54.96,33.11},{43.04,31.24},{43.08,31.51},{43.44,31.85},{43.17,31.66},{43.36,31.37},{54.57,30.91},{53.39,31.75},{54.22,35.81},{53.36,32.84},{53.3,34.4},{45.76,34.58},{41.98,30.02},{52.88,30.85},{50.95,32.68},{51.4,34.22},{49.59,35.15},{45.81,36.59},{51.02,34.74},{53.48,31.63},{53.38,32.8},{45.79,34.57},{52.71,30.26},{51.97,59.05},{50.96,32.82},{51.21,66.33},{55.34,59.08},{52.77,64.23},{53.41,61.46},{49.66,74.17},{50.61,67.59},{52.55,57.69},{51.83,57.26},{54.01,56.59},{54.81,51.39},{55.29,52.97},{55.8,54.09},{54.41,53.86},{50.91,51.67},{51.2,69.62},{51.52,69.56},{50.57,72.64},{51.73,67.09},{50.61,53.69},{52.76,71.74},{51.95,61.11},{52.8,60.43},{51.66,65.2},{51.58,62.32},{52.48,63.28},{51.83,55.93},{57.5,71.92},{54.77,67.76},{53.69,69.88},{53.82,80.57},{52.39,78.16},{53.32,79.64},{52.61,79.99},{54.18,62.9},{52.88,59.47},{52.92,57.03},{53.85,58.63},{51.43,64.63},{57.37,73.51},{52.2,76.42},{50.1,69.38},{51.85,77.19},{52.7,76.97},{51.4,76.39},{54.37,70.84},{54.21,66.03},{53.01,69.94},{54.29,66.02},{53.12,61.32},{53.96,62.03},{55.16,56.2},{50,71.22},{54.49,58.47},{51.96,53.76},{53.19,68.21},{54.49,57.48},{50.97,56.14},{51.25,56.3},{49.1,41.33},{51.3,33.57},{55,56.39},{38.47,49.83},{46.34,41.11},{47.22,41.01},{55.15,39.57},{53.31,55.34},{54.43,38.71},{51.52,37.72},{43.4,44.44},{49.57,38.58},{49.72,35.21},{42.5,43.36},{45.56,36.65},{51.18,34.47},{50.79,36.22},{51.37,35.78},{55.17,43.34},{53.39,31.77},{40.15,48.88},{42.01,44.72},{51.87,51.09},{45.86,38.59},{46.35,39.55},{53.84,37.61},{53.18,37.37},{53.41,32.53},{53.25,34.46},{51.96,50.06},{53.35,49.01},{55.9,51.48},{51.38,49.47},{44.69,43.51},{42.44,46.76},{56.16,41.2},{51.45,47.12},{53.36,45.82},{50.83,46.2},{52.27,47.75},{45.73,34.83},{53.96,48.02},{45.69,44.12},{47.88,42.97},{54.18,49.99},{52.1,46.05},{55.17,40.99},{48.2,40.37},{47.33,42.21},{48.93,39.59},{47.05,38.54},{53.05,30.94},{49.6,45.55},{47.25,46.05},{48.19,45.74},{46.48,47.16},{45.44,45.34},{44.09,48.37},{43.44,49.25},{45.43,48.03},{41.78,49.75},{40.26,50.44},{45.43,48.54},{40.93,46.63},{41.76,48.11},{41.38,45.17},{49.68,45.49},{48.3,45.98},{45.74,47.95},{43.19,49.53}}},nil,14,nil,nil,7,"AH",nil,0},
[3100] = {'Elder Mottled Boar',176,176,8,8,0,{[14]={{44.95,17.67},{44.15,17.32},{45.13,16.57},{56.41,13.31},{53.13,10.36},{54.91,12.32},{54.64,13.71},{53.6,12.85},{54.99,28},{55.07,19.39},{56.52,17.05},{53.36,10.32},{53.33,12.56},{55.03,16.11},{53.95,15.5},{57.25,18.33},{57.01,15.38},{57.49,20.51},{57.68,16.74},{57.53,18.56},{57.16,19.21},{56.34,13.21},{53.7,16.73},{54.9,13.54},{56.03,18.9},{55.04,12.87},{55.28,20.49},{55.06,18.96},{54.85,19.26},{43.85,15.7},{53.25,17.27},{54.15,17.48},{53.42,14.37},{57.04,16.11},{57.67,16.96},{56.42,13.35},{56.9,18.07},{57.14,19.52},{56.44,16.99},{57.61,18.6},{57.75,27.99},{38.09,28.95},{37.57,27.8},{54.63,28.87},{38.25,23.27},{37.73,25.84},{56.71,24.56},{56.92,23.47},{56.5,25.9},{56.5,28.09},{56.17,29.86},{44.6,25.3},{43.96,28.09},{45.67,27.24},{55.65,21.66},{43.12,27.92},{43.91,26.22},{42.33,28.06},{55.05,28.03},{54.72,19.69},{54.6,29.14},{55.86,21.72},{37.46,51.58},{35.13,50.75},{35.6,52.85},{36.48,50.8},{37.54,56.6},{38.31,56.16}}},nil,14,nil,nil,189,"AH",nil,0},
[3101] = {'Vile Familiar',0,0,3,4,0,{[14]={{42.99,55.31},{42.63,54.66},{42.85,52.31},{42.84,52.51},{44.48,52.68},{43.78,52.61},{44.76,53.71},{43.53,53.49},{43.93,53.55},{44.76,54.02},{43.86,53.79},{45.13,55.07},{43.94,54.25},{43.25,54.31},{45.37,56.32},{43.84,54.97},{44.18,55.26},{43.39,55.62},{43.96,55.25}},[6451]={{59.36,32.36},{54.46,34.21},{43.94,9.07},{54.32,28.46},{55.16,30.85},{52.26,30.78},{57.67,23.54},{57.03,26.47},{59.73,22.29},{59.65,28.49},{56.85,31.61},{56.5,18.48},{55.12,20.73},{55.05,24.25},{52.47,28.23},{52.84,23.7},{52.33,21.04},{52.12,21.15},{44.72,27.45},{44.78,24.66},{45.54,33.45},{49.57,21.56},{50.2,18.44},{49.33,23.17},{47.81,28.74},{50.37,29.11},{47.1,23.96},{47.4,17.48},{46.9,32.52},{49.79,31.72},{42.36,29.51},{40.43,28.44}}},nil,6451,{25131},nil,7,"AH",nil,0},
[3102] = {'Felstalker',86,86,3,4,0,{[14]={{44.87,53.07},{44.86,52.47},{44.11,52.89},{45.28,55.68},{45.53,55.27},{44.76,54.6},{44.53,55},{44.26,54.06},{43.85,54.84},{43.58,52.13},{43.02,52.07},{42.7,52.95},{43.27,53.81},{42.42,54.11},{42.99,55.35}}},nil,14,nil,nil,7,"AH",nil,0},
[3103] = {'Makrura Clacker',100,137,6,7,0,nil,nil,0,nil,nil,129,nil,nil,0},
[3104] = {'Makrura Shellhide',137,140,6,7,0,nil,nil,0,nil,nil,129,nil,nil,0},
[3105] = {'Makrura Snapclaw',156,176,8,9,0,nil,nil,0,nil,nil,129,nil,nil,0},
[3106] = {'Surf Crawler',120,120,5,6,0,{[14]={{62.63,58.6},{62.13,52.71},{61.48,51.74},{60.47,47.05},{63.05,62.26},{60.76,48.23},{63.45,63.11},{63.36,60.94},{61.61,61.82},{54.67,83.95},{55.42,81.76},{54.58,83.05},{55.23,80.08},{53.71,83.05},{54.41,81.27},{52.64,83.13},{52.06,83.12},{52.08,84.7},{58.85,74.31},{58.89,74.67},{58.44,75.34},{59.7,73.46},{59.08,73.17},{59.78,71.42},{55.82,80.49},{56.52,81.12},{56.38,80},{58.41,77.25},{53.95,82.25},{53.42,81.99},{52.86,82.21},{53.34,83.09},{54.68,82.23},{56.34,78.38},{57.87,78.22},{57.78,77.34},{58.21,79.17},{55.94,79.33},{57.34,78.12},{57.72,77.23},{57.62,77.38},{57.11,79.27},{57.77,78.35},{56.39,78.98},{59.02,75.3},{58.52,75.31},{51.45,84.41},{60.38,48.71},{60.93,44.47},{61.03,49.94},{60.02,50.83},{60.94,49.14},{60.37,43.44}}},nil,14,nil,nil,7,"AH",nil,0},
[3107] = {'Mature Surf Crawler',137,137,7,8,0,{[14]={{59.73,27.31},{59.15,25.99},{70.95,73.78},{63.83,80.47},{72.29,70.13},{59.08,85.74},{60.17,85.35},{67.86,68.46},{63.96,78.92},{67.31,75.75},{62.93,76.07},{71.04,68.65},{66.47,68.99},{70.5,76.08},{62.91,67.09},{69.78,68.44},{61.81,81.73},{65.08,72.7},{64.4,72.62},{63.02,70.36},{62.57,74.48},{61.58,84.73},{65.26,65.79},{57.74,82.92},{65.29,75.33},{65,76.59},{59.57,80.75},{65.23,78.34},{66.61,72.66},{62.48,79.35}}},nil,14,nil,nil,7,"AH",nil,0},
[3108] = {'Encrusted Surf Crawler',198,198,9,10,0,{[14]={{57.12,11.46},{56.25,10.88},{56.76,9.13},{57.15,10.16},{57.3,12.24},{57.26,13.3},{56.87,12.33},{57.66,7.21},{60.23,20.07},{59.66,10.18},{58.2,12.72},{57.4,11.43},{57.98,13.1},{58.1,15.1},{56.45,9.02},{56.93,12.46},{58.16,15.3},{57.39,12.19},{56.39,11.18},{57.7,13.69},{57.25,13.22},{58.44,13.08},{58.79,15.94},{57.13,7.06},{58.41,8.22},{57.75,7.55},{57.27,10.46},{57.41,13.21},{58.29,13.9},{57.88,13.06},{57.99,15.05},{57.62,14.15},{58.2,15.46},{57.75,11.11},{57.02,12.61},{56,9.12},{58.42,12.07},{58.6,16.24},{56.06,10.71},{57.11,10.23},{57.72,8.32},{57.19,12.31},{57.28,13.24}}},nil,14,nil,nil,7,"AH",nil,0},
[3110] = {'Dreadmaw Crocolisk',198,198,10,10,0,{[14]={{36.76,20.84},{36.87,16.48},{36.72,18.4},{35.17,26.33},{35.36,28.12},{35.29,24.63},{34.92,55.52},{36.21,61.18},{35.56,57.14},{34.85,55.32},{36.15,61.44},{37.21,63.76},{35.72,57.37},{36.98,62.25},{37.35,66.07},{37.68,68.04},{38.69,71.82},{36.81,16.65},{36.7,18.86},{36.68,13.49},{34.89,26.55},{34.25,39.56},{35.31,24.31},{37.7,68.15},{38.64,71.6},{37.94,69.78}},[17]={{69.48,27.41},{70.38,19.92},{69.53,28.41},{69.54,34.58},{69.25,30.08},{70.64,21.2},{68.92,48.02},{68.8,50.26},{70.51,54.57},{69.25,53.16},{68.62,43.43},{72.53,64.06},{70.69,54.95},{69.56,53.28},{68.47,41.95},{68.78,50.04},{68.85,45.32},{68.75,47.96},{68.91,45.65},{71.07,9.87},{71.26,8.55},{69.28,27.13},{69.54,28.29},{69.44,23.81},{69.14,29.73},{70.58,21.29},{70.4,19.77},{69.53,34.81}}},nil,17,nil,nil,14,nil,nil,0},
[3111] = {'Razormane Quilboar',120,120,6,7,0,{[14]={{38.17,54.19},{44.58,48.88},{49.22,49.48},{50.73,48.79},{50.97,48.01},{48.2,45.88},{48.06,46.9},{45.3,48.23},{46.48,48.58},{44.7,50.45},{44.56,50.56},{46.68,48.66},{43.14,50.66},{44.35,49.91},{43.57,50.29},{45.99,49.03},{48.59,49.23},{48.05,48.99},{44.88,47.81},{47.56,49.07},{47.6,49.84},{47.37,49.52},{47.2,49.57},{47.63,49.02},{49.29,48.68},{49.22,48.91},{43.9,49.02},{50.4,50.89},{47.44,48.6}}},nil,14,nil,nil,109,nil,nil,0},
[3112] = {'Razormane Scout',120,120,6,7,0,{[14]={{49.79,49.31},{50.3,49.61},{43.85,49.77},{46.94,47.39},{47.67,48.98},{47.52,47.56},{44.5,48.93},{49.54,47.58},{49.03,48.12},{49.13,49.1},{50.91,48.74},{47.59,49.01}}},nil,14,nil,nil,109,nil,nil,0},
[3113] = {'Razormane Dustrunner',166,166,8,9,0,{[14]={{36.87,57.13},{42.04,39.31},{44.34,38.28},{43.11,38.87},{44.09,39.11},{38.22,57.24},{37.51,56.49},{36.32,56.38},{41.41,40.37},{44.52,40.16},{42.5,36.51},{41.88,36.93},{43.9,37.46},{39.61,53.21},{38.05,56.1},{38.18,55.32},{38.62,53.45},{38.74,55.27},{36.25,57.11}}},nil,14,nil,nil,109,nil,nil,0},
[3114] = {'Razormane Battleguard',156,156,8,9,0,{[14]={{44.53,37.64},{44.26,39.18},{43.63,38.3},{43.02,38.04},{45.31,37.66},{43.91,40.11},{42.77,39.69},{43.08,37.09},{41.75,38.14},{39.01,53.75},{39.39,53.77},{39.2,52.93},{38.79,52.79},{38.3,54.28},{39.99,52.44},{37.67,55.49},{36.96,56.54},{38.88,56.2},{42.6,38.93},{36.25,57.33}}},nil,14,nil,nil,109,nil,nil,0},
[3115] = {'Dustwind Harpy',137,137,7,7,0,{[14]={{47.13,32.03},{46.39,33.66},{45.89,29.29},{46.04,31},{50.12,25.11},{51.26,27.07},{50.64,27.01},{47.24,32.22},{47.72,33.08},{48.38,30.33},{48.16,33.01},{47.36,33.67},{46.39,33.83},{48.32,31.68},{50.12,25.08},{51.21,27.03},{49.77,28.08},{50.61,27.01},{49.99,26.87},{48.21,31.97},{49.58,33.01},{50.45,32.12},{48.83,33.57},{48.25,33.95},{47.02,34.68},{47.71,33.1},{48.39,30.32},{46.37,33.83},{50.15,25.1},{50.03,26.88},{50.41,32.14},{47.46,33.62},{48.22,34.11},{47.02,34.65},{51.26,27.16},{50.61,27.03},{49.81,28.18}}},nil,14,nil,nil,514,nil,nil,0},
[3116] = {'Dustwind Pillager',137,137,8,8,0,{[14]={{47.71,30.25},{47.13,29.81},{47.07,30.81},{47.48,30.72},{46.58,30.22},{50.69,25.9},{51.94,27.4},{47.71,30.27},{47.18,29.82},{48.04,31.33},{47.51,30.79},{49.74,24.21},{50.71,25.94},{51.92,27.35},{49.81,23.31},{47.06,30.8},{48.65,32.31},{47.72,30.23},{48.06,31.28},{49.47,22.31},{48.76,22.01},{49.67,24.18},{50.72,25.97},{49.77,23.3},{49.49,21.67}}},nil,14,nil,nil,514,nil,nil,0},
[3117] = {'Dustwind Savage',176,176,8,9,0,{[14]={{53.9,26.38},{53.43,25.06},{54.04,27.29},{54.07,24.5},{54.06,23.48},{52.35,24.01},{51.87,23.84},{51.98,20.77},{54.09,26.1},{53.48,25.09},{54.02,27.31},{53.97,24.56},{54.07,23.07},{52.69,21.16},{53.69,21.86},{52.35,24.03},{51.91,23.85}}},nil,14,nil,nil,514,nil,nil,0},
[3118] = {'Dustwind Storm Witch',166,166,8,9,0,{[14]={{51.36,23.07},{53.33,23.73},{51.87,23.53},{53.01,23.87},{51.21,23.7},{52.92,24.05},{50.98,19.56},{52.02,20.05},{51.57,18.88},{51.4,21},{51.17,19.19},{51.24,20.13},{51.79,19.93},{51.37,23.06},{53.35,23.76},{51.87,23.53},{53.01,23.85},{51.58,21.65},{51.28,23.7},{52.96,24.2},{53.11,21.82},{52.01,21.6},{54.09,22.32},{51.36,23.08},{51.21,23.7}}},nil,14,nil,nil,514,nil,nil,0},
[3119] = {'Kolkar Drudge',120,137,6,7,0,nil,nil,0,nil,nil,130,nil,nil,0},
[3120] = {'Kolkar Outrunner',131,148,7,8,0,nil,nil,0,nil,nil,130,nil,nil,0},
[3121] = {'Durotar Tiger',140,156,7,8,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3122] = {'Bloodtalon Taillasher',120,120,6,7,0,{[14]={{45,20.89},{58.35,26.23},{44.69,32.71},{55.81,28.76},{57.19,25.23},{57.23,27.26},{44.62,26.75},{54.75,37.15},{54.5,32.37},{54.14,30.18},{42.57,32.62},{45.54,24.43},{50.16,35.31},{48.9,35.22},{54.1,29.72},{35.47,51.78},{38.23,47.17},{47.86,37.03},{46.31,37.91},{48.74,35.06},{49.65,36.76},{45.39,35.53},{45.39,24.59},{54.33,32.47},{39.42,51.59},{42.79,46.02},{44.91,46.02},{40.63,50.06},{40.63,47.65},{39.47,44.39},{39.83,40.59},{39.99,37.24}}},nil,14,nil,nil,14,nil,nil,0},
[3123] = {'Bloodtalon Scythemaw',176,176,8,9,0,{[14]={{43.01,20.56},{52.65,15.56},{40.52,18.89},{51.69,16.9},{54.98,19.7},{51.25,14.74},{43.94,20.61},{37.6,24.25},{37.78,31.74},{35.93,34.29},{48.14,20.72},{35.59,31.46},{43.43,22.23},{44.51,23.84},{35.18,29.24},{36.14,28.72},{47.79,20.85},{35.65,39.87},{38.37,39.87},{37.99,38.69},{35.75,40.46},{34.96,44.23},{35.09,29.01}}},nil,14,nil,nil,48,nil,nil,0},
[3124] = {'Scorpid Worker',0,0,3,3,0,{[6451]={{60.17,68.95},{58.45,71.87},{57.11,53.69},{60.15,54.23},{59.95,49.9},{52.43,45.78},{55.37,46.18},{59.82,46.26},{57.42,46.43},{52.58,42.67},{59.49,43.17},{52.28,39.1},{55.31,42.31},{54.68,38.29},{59.73,38.66},{57.44,39.25},{35.46,36.51},{40,35.26},{37.19,32.2},{37.81,35.55},{32.54,39.03},{30,38.77},{30.47,42.75},{29.96,47.03},{33.05,42.61},{32.32,47.07},{35.38,42.35},{32.54,49.86},{35.4,46.19},{37.82,46.4},{42.83,46.14},{42.48,50.6},{57.56,57.98},{57.61,60.89},{57.39,68.96},{56.67,62.13},{55.21,68.95},{42.79,53.2},{40.09,50.48},{37.64,50.18},{40.06,53.37},{34.66,51.03},{39.2,56.94},{37.51,56.58},{34.96,57.12},{32.27,58.18},{37.08,60.46},{34.9,60.5},{32.48,61.34},{37.26,65.51},{32.3,65.23},{34.92,65.13},{32.52,68.11},{35.04,67.92}}},nil,6451,nil,nil,7,"AH",nil,0},
[3125] = {'Clattering Scorpid',120,120,6,6,0,{[14]={{54.13,64.27},{52.92,59.69},{54.6,63.11},{53.96,69.72},{54.38,60.88},{53.97,69.7},{53.29,66.93},{51.73,53.28},{51.98,54.93},{57.8,71.69},{57.08,70.78},{58.23,70.05},{58.37,72.66},{55.35,70.15},{54.31,69.21},{54.13,65.83},{53.82,52.47},{54.96,54.79},{54.5,64.98},{50.09,73.58},{55.66,70.76},{56.59,71.22},{55.26,67.7},{54.07,67.91},{53.55,53.65},{52.37,63.32},{53.74,75.02},{50.92,70.81},{51.24,72.35},{51.83,76.51},{51.09,72.51},{53.32,78.41},{53.91,79.06},{52.41,75.43},{51.8,74.06},{53.25,73.79},{52.17,72.19},{54.51,67.06},{54.65,59.25},{54.57,70.59},{49.96,71.93},{56.19,68.84},{52.84,59.96},{53.61,75.62},{54.14,76.1},{50.74,74.75},{51.44,75.3},{49.55,74.52},{50.14,75.11},{54.02,75.36},{49.63,72.81},{55.32,77.28},{54.31,75.93},{56.56,72.58},{53.96,75.73},{54.61,78.27},{56.53,77.4},{53.65,74.24},{56.64,72.94},{55.97,70.65},{56.45,77.53},{56.43,72.39},{54.44,57.23},{56.77,48.88},{55.32,49.49},{55.9,44.39},{54.14,50.67},{54.6,50.13},{56.43,45.35},{54.35,48.09},{55.71,48.68},{56.92,43.26},{57.72,41.35}}},nil,14,nil,nil,413,nil,nil,0},
[3126] = {'Armored Scorpid',156,156,7,8,0,{[14]={{54.85,23.32},{58.28,28.97},{54.99,22.36},{51.64,17.61},{46.85,25.79},{46.96,26.29},{58.46,25.1},{57.19,28.61},{57.82,30.18},{41.72,29.18},{40.02,31.51},{39.95,30.37},{36.53,33.64},{55.92,30.93},{44.5,29.97},{45.67,26.55},{45.31,28.1},{45.04,30.87},{56.82,22.09},{43.12,28.58},{41.24,32.15},{55.99,24.19},{43.31,32.18},{36.17,31.93},{53.53,33.55},{54.05,36.54},{46.81,24.74},{35.37,35.87},{35.73,38.61},{55.4,29.83},{54.93,23.09},{54.68,22.01},{51.67,17.88},{50.56,22.21},{50.5,19.37},{52.59,19.05},{47.97,35.16},{46.35,35.68},{46.57,26.02},{50.66,22.3},{39.35,49.9},{36.3,52.42},{50.28,37.18},{38.97,41.44},{37.71,41.61},{43.83,43.9},{44.35,36.28},{37.38,45.23},{43.79,46.1},{42.81,45.39},{47.8,38.57},{48.58,37.55},{40.79,48.69},{41.53,41.48},{53.58,33.66},{53.85,36.6},{40.8,39.71},{47.8,35.62},{39.92,37.33},{46.93,24.41},{37.02,41.43},{51.09,38.2},{38.91,46.03},{46.35,35.81},{40.41,41.17},{35.64,38.62},{41.29,51.21},{40.94,51.79},{42.04,45.99},{38.34,44.36},{37.02,38.57},{40.1,37.75}}},nil,14,nil,nil,413,nil,nil,0},
[3127] = {'Venomtail Scorpid',176,176,9,9,0,{[14]={{43.94,18.38},{43.89,16.97},{52.57,13.39},{52.81,10.74},{56.62,14.81},{56.01,14.88},{52.54,13.83},{53.52,15.85},{55.86,15.85},{41.33,17.83},{52.6,10.85},{55.35,15.22},{52.68,16.87},{55.69,17.74},{48.75,20.29},{48.89,20.86},{39.87,19.62},{38.02,30.23},{37.09,27.16},{36.61,29.88},{43.97,21.55},{42.67,23.02},{45.29,23.14},{35.8,33.01},{40.58,22.9},{38.7,22.2},{49.45,20.27},{48.81,20.8},{45.26,22.37}}},nil,14,nil,nil,413,nil,nil,0},
[3128] = {'Kul Tiras Sailor',100,120,5,6,0,nil,nil,0,nil,nil,1802,"A",nil,0},
[3129] = {'Kul Tiras Marine',137,137,7,7,0,{[14]={{57.22,51.47},{60.8,52.13}}},nil,14,nil,nil,123,"A",nil,0},
[3130] = {'Thunder Lizard',176,198,9,10,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3131] = {'Lightning Hide',198,222,10,11,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3133] = {'Herble Baubbletump',1003,1003,30,30,0,{[10]={{77.29,48.82}}},nil,10,nil,nil,875,"A","Engineering & Mining Supplies",128},
[3134] = {'Kzixx',713,713,25,25,0,{[10]={{81.82,19.77}}},nil,10,nil,nil,120,"AH","Rare Goods",128},
[3135] = {'Malissa',664,664,24,24,0,{[10]={{79.38,44.77}}},nil,10,nil,nil,12,"A","Poison Supplies",1152},
[3136] = {'Clarise Gnarltree',1107,1107,31,31,0,{[10]={{74.05,48.59}}},nil,10,nil,nil,12,"A","Blacksmithing Trainer",81},
[3137] = {'Matt Johnson',484,484,20,20,0,{[10]={{73.99,49.71},{73.92,49.7}}},nil,10,nil,nil,12,"A","Mining Trainer",81},
[3138] = {'Scott Carevin',713,713,25,25,0,{[10]={{75.71,47.51}}},nil,10,nil,nil,12,"A","Mushroom Seller",640},
[3139] = {'Gar\'Thok',198,198,10,10,0,{[14]={{51.95,43.5}}},nil,14,{25173,25177,26806},{784,825,830,837,25171,25173,25177,25179,26804},29,"H",nil,3},
[3140] = {'Lar Prowltusk',137,137,7,7,0,{[14]={{55.42,75.1}}},{[14]={{{54.18,73.3},{54.24,73.36},{54.39,73.79},{54.44,74.29},{54.37,74.4},{54.42,74.33},{54.56,74.52},{54.55,74.87},{54.52,74.93},{54.58,74.88},{54.64,75.16},{54.36,76.15},{54.08,76.49},{54.37,75.78},{54.62,74.99},{54.55,74.88},{54.52,74.94},{54.57,74.86},{54.58,74.65},{54.41,74.3},{54.38,74.39},{54.4,74.33},{54.31,73.7},{54.24,73.27}}}},14,{25169},{785,786,25169},126,"H",nil,2},
[3141] = {'Makrura Elder',156,176,8,9,0,nil,nil,0,nil,nil,129,nil,nil,0},
[3142] = {'Orgnil Soulscar',417,417,18,18,0,{[14]={{52.24,43.15}}},nil,14,{25196,25232},{806,807,823,25232},29,"H",nil,2},
[3143] = {'Gornek',0,0,5,5,0,{[6451]={{44.93,66.42}}},nil,6451,{2383,3087,3088,3089,3090,25126,25127,25138,25172},{25126,25127,25130,25152,25172},29,"H",nil,3},
[3144] = {'Eitrigg',484,484,20,20,0,{[1637]={{49.21,72.28}}},nil,1637,{26803},{26807},29,"H",nil,3},
[3145] = {'Zureetha Fargaze',0,0,12,12,0,{[6451]={{45.79,63.34}}},nil,6451,{25131,25132,25133},{25131,25132},29,"H",nil,2},
[3146] = {'Gurek',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[3147] = {'Furl Scornbrow',120,120,6,6,0,nil,nil,0,nil,{791},29,"H",nil,0},
[3149] = {'Nez\'raz',1848,1848,45,45,0,{[33]={{37.29,52.12}}},nil,33,nil,{798,799},29,"H","Durotar Zeppelin Master",1},
[3150] = {'Hin Denburg',2218,2218,45,45,0,{[85]={{61.78,59.18}}},nil,85,nil,{800,801},29,"H","Stranglethorn Vale Zeppelin Master",1},
[3151] = {'Captain Obvious',25,27,1,1,0,nil,nil,0,nil,{797},35,"AH","Boat Operator",0},
[3152] = {'Cap\'n Copyright',25,27,1,1,0,nil,nil,0,nil,{796},35,"AH","Boat Operator",0},
[3153] = {'Frang',0,0,11,11,0,{[6451]={{43.57,71.12}}},nil,6451,{25147},{2383,25147},29,"H","Warrior Trainer",3},
[3154] = {'Jen\'shan',156,156,8,8,0,nil,nil,0,nil,nil,126,"H","Hunter Trainer",51},
[3155] = {'Rwag',0,0,8,8,0,{[6451]={{41.55,68.56}}},nil,6451,{25141},{3088,25141},29,"H","Rogue Trainer",3},
[3156] = {'Nartok',0,0,9,9,0,{[6451]={{41.62,65.64}}},nil,6451,{25145},{3090,25145},29,"H","Warlock Trainer",3},
[3157] = {'Shikrik',0,0,10,10,0,{[6451]={{41.65,69.33}}},nil,6451,{25143},{3089,25143},29,"H","Shaman Trainer",3},
[3158] = {'Duokna',0,0,10,10,0,{[6451]={{42.39,62.82}}},nil,6451,nil,nil,29,"H","General Goods",640},
[3159] = {'Kzan Thornslash',0,0,34,34,0,{[6451]={{43.16,65.59}}},nil,6451,nil,nil,29,"H","Weaponsmith",4224},
[3160] = {'Huklah',0,0,11,11,0,{[6451]={{43.38,65.59}}},nil,6451,nil,nil,29,"H","Cloth & Leather Armor Merchant",4224},
[3161] = {'Rarc',0,0,10,10,0,{[6451]={{43.3,65.28}}},nil,6451,nil,nil,29,"H","Armorer & Shieldcrafter",4224},
[3162] = {'Burdrak Harglhelm',0,0,12,12,0,{[6457]={{49.65,51.93}}},nil,6457,nil,nil,55,"A","Leather Armor Merchant",4224},
[3163] = {'Uhgar',328,328,15,15,0,{[14]={{52,40.47}}},nil,14,nil,nil,29,"H","Weaponsmith",4224},
[3164] = {'Jark',300,300,14,14,0,{[14]={{54.39,42.18}}},nil,14,nil,nil,29,"H","General Goods",640},
[3165] = {'Ghrawt',273,273,13,13,0,{[14]={{52.98,41.03}}},nil,14,nil,nil,29,"H","Bowyer",4224},
[3166] = {'Cutac',300,300,14,14,0,{[14]={{53.11,40.86}}},nil,14,nil,nil,29,"H","Cloth & Leather Armor Merchant",4224},
[3167] = {'Wuark',356,356,16,16,0,{[14]={{51.9,41.14}}},nil,14,nil,nil,29,"H","Armorer & Shieldcrafter",4224},
[3168] = {'Flakk',328,328,15,15,0,{[14]={{53,42.01}}},nil,14,nil,nil,29,"H","Trade Supplies",128},
[3169] = {'Tarshaw Jaggedscar',2059,2059,43,43,0,{[14]={{54.19,42.47}}},nil,14,nil,nil,29,"H","Warrior Trainer",49},
[3170] = {'Kaplak',300,300,14,14,0,{[14]={{51.98,43.69}}},nil,14,nil,nil,29,"H","Rogue Trainer",49},
[3171] = {'Thotar',356,356,16,16,0,{[14]={{51.85,43.49}}},nil,14,nil,{6062,6068,6069,6070,6082,6083},29,"H","Hunter Trainer",51},
[3172] = {'Dhugru Gorelust',1536,1536,37,37,0,{[14]={{54.38,41.2}}},nil,14,nil,nil,29,"H","Warlock Trainer",49},
[3173] = {'Swart',328,328,15,15,0,{[14]={{54.42,42.59}}},nil,14,nil,nil,29,"H","Shaman Trainer",49},
[3174] = {'Dwukk',840,840,27,27,0,{[14]={{52.03,40.72}}},nil,14,nil,nil,29,"H","Blacksmithing Trainer",81},
[3175] = {'Krunn',356,356,16,16,0,{[14]={{51.81,40.88}}},nil,14,nil,nil,29,"H","Mining Trainer",80},
[3177] = {'Turuk Amberstill',198,198,10,10,0,{[1]={{70.1,48.19}}},nil,1,nil,nil,55,"A","Dwarven Weaponsmith",4224},
[3178] = {'Stuart Fleming',713,713,25,25,0,{[11]={{6.27,57.45}}},nil,11,nil,nil,12,"A","Fishing Supplies",640},
[3179] = {'Harold Riggs',713,713,25,25,0,{[11]={{8.08,58.62}}},nil,11,nil,nil,12,"A","Fishing Trainer",81},
[3180] = {'Dark Iron Entrepreneur',1050,1050,30,30,0,{[45]={{42.7,90.34}}},nil,45,nil,nil,35,"AH","Speciality Goods",128},
[3181] = {'Fremal Doohickey',1003,1003,30,30,0,{[11]={{10.51,60.23}}},nil,11,nil,nil,875,"A","First Aid Trainer",81},
[3182] = {'Junder Brokk',484,484,20,20,0,{[11]={{10.68,59.69}}},nil,11,nil,nil,55,"A",nil,0},
[3183] = {'Yarrog Baneshadow',118,118,5,5,0,{[14]={{42.43,53.49}}},nil,14,nil,nil,7,"AH",nil,0},
[3184] = {'Miao\'zan',713,713,25,25,0,{[14]={{55.41,73.95}}},nil,14,nil,nil,126,"H","Alchemy Trainer",80},
[3185] = {'Mishiki',300,300,14,14,0,{[14]={{55.63,75.41}}},nil,14,nil,nil,126,"H","Herbalism Trainer",80},
[3186] = {'K\'waii',222,222,11,11,0,{[14]={{56.29,73.4}}},nil,14,nil,nil,126,"H","General Goods",640},
[3187] = {'Tai\'tasi',247,247,12,12,0,{[14]={{56.41,73.79}}},nil,14,nil,nil,126,"H","Trade Supplies",128},
[3188] = {'Master Gadrin',247,247,12,12,0,{[14]={{55.95,74.72}}},nil,14,{25167,25168,25171,26951},{805,808,826,2935,2936,25073,25133,25167,25168,26951},126,"H",nil,2},
[3189] = {'Kor\'ghan',137,137,7,7,0,{[1637]={{44.82,58.76}}},nil,1637,nil,{810,811,813},126,"H",nil,0},
[3190] = {'Rhinag',156,156,8,8,0,nil,nil,0,nil,{812},126,"H",nil,0},
[3191] = {'Cook Torka',120,120,6,6,0,{[14]={{50.74,42.71}}},{[14]={{{51.11,42.45},{51.08,42.51},{51.06,42.44}}}},14,nil,{814,815},29,"H",nil,0},
[3192] = {'Lieutenant Benedict',156,156,8,8,0,nil,nil,0,nil,nil,1802,"A",nil,0},
[3193] = {'Misha Tor\'kren',102,102,5,5,0,{[14]={{43.38,30.63}}},nil,14,{25193},{816,25193},29,"H",nil,2},
[3194] = {'Vel\'rin Fang',137,137,7,7,0,{[14]={{55.96,73.93}}},nil,14,nil,{817},126,"H",nil,0},
[3195] = {'Burning Blade Thug',176,176,8,9,0,{[14]={{52.77,28.4},{53.06,29.15},{52.91,27.82},{52.66,29.14},{53.43,26.98},{52.9,27.78},{53.4,26.95},{52.91,27.81}}},nil,14,nil,nil,554,nil,nil,0},
[3196] = {'Burning Blade Neophyte',166,166,8,9,0,{[14]={{51.88,24.6},{53.14,27.25},{52.17,26.93},{52.77,26.72},{51.89,26},{51.88,24.61},{52.19,26.91},{51.88,26},{53.15,27.28},{52.78,26.71},{51.88,24.62},{52.18,26.91},{51.9,26.01},{53.15,27.26},{52.79,26.69}}},nil,14,nil,nil,554,nil,nil,0},
[3197] = {'Burning Blade Fanatic',166,166,9,10,0,{[14]={{51.85,10.85},{55.08,9.84},{54.91,10.21},{55.31,9.93},{52.51,10.12},{52.72,9.14},{55.34,9.92},{54.89,10.22},{55.08,9.83},{51.87,10.85},{53.8,9.66},{53.39,10.3},{52.39,9.25},{54.69,8.63},{52.71,9.1},{52.28,8.34},{51.42,8.67},{54.87,10.21},{55.08,9.83},{55.34,9.95},{54.69,8.63},{53.79,9.67},{53.39,10.29},{52.41,9.21},{52.53,10.13},{51.85,10.59},{53.25,8.12}}},nil,14,nil,nil,554,nil,nil,0},
[3198] = {'Burning Blade Apprentice',160,160,9,10,0,{[14]={{54.08,8.97},{53.69,8.65},{53.21,9.26},{54.8,9.33},{53.11,11.05},{51.52,10.21},{52.14,9.81},{52.54,10.96},{52.71,7.93},{51.77,8.09},{53.14,11.03},{53.2,9.26},{52.88,7},{54.05,8.98},{53.69,8.65},{54.77,9.36},{52.13,9.84},{51.56,10.23},{52.53,10.98}}},nil,14,nil,nil,554,nil,nil,0},
[3199] = {'Burning Blade Cultist',160,160,8,9,0,{[14]={{52.19,24.43},{52.41,24.87},{52.03,25.32},{52.68,25.42},{52.22,24.43},{52.43,24.89},{52.01,25.32},{52.68,25.38},{52.43,24.92},{51.98,25.35},{52.69,25.36}}},nil,14,nil,nil,554,nil,nil,0},
[3200] = {'Eric\'s AAA Special Vendor',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3201] = {'Scott Mercer',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3203] = {'Fizzle Darkclaw',164,164,12,12,0,{[14]={{42.11,26.66}}},{[14]={{{42.12,26.66},{42.31,26.63},{42.45,26.56},{42.53,26.52},{42.61,26.48},{42.52,26.54},{42.44,26.57},{42.26,26.63}}}},14,nil,nil,35,"AH",nil,1},
[3204] = {'Gazz\'uz',178,178,10,10,0,{[14]={{51.8,10.02},{51.52,9.61}}},nil,14,nil,nil,14,nil,nil,0},
[3205] = {'Zalazane',186,186,10,10,0,nil,{[14]={{{67.56,87.75},{67.54,87.59},{67.56,87.15},{67.4,87.03},{67.13,87.03},{67.15,86.88},{67.29,86.72},{67.42,86.61},{67.59,86.29},{67.75,86.15},{67.72,86.34},{67.4,86.69},{67.36,87.02},{67.54,87.21},{67.54,87.56}}}},0,nil,nil,14,nil,nil,0},
[3206] = {'Voodoo Troll',148,166,8,9,0,nil,nil,0,nil,nil,16,nil,nil,0},
[3207] = {'Hexed Troll',148,166,8,9,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3208] = {'Margoz',417,417,18,18,0,{[14]={{56.41,20.04}}},nil,14,{25262,25263},{827,828,25261,25262},29,"H",nil,2},
[3209] = {'Brave Windfeather',0,0,13,13,0,{[6452]={{31.59,30.37}}},nil,6452,nil,nil,105,"H",nil,2},
[3210] = {'Brave Proudsnout',0,0,5,5,1,{[6452]={{22.36,29.89}}},nil,6452,nil,nil,105,"H",nil,0},
[3211] = {'Brave Lightninghorn',0,0,5,5,1,{[6452]={{27.43,19.14}}},nil,6452,nil,nil,105,"H",nil,0},
[3212] = {'Brave Ironhorn',656,656,15,15,0,{[215]={{46.13,57.77}}},{[215]={{{46.7,59.13},{46.55,58.94},{46.3,58.67},{45.91,58.26},{46.29,58.65},{46.54,58.94},{46.84,59.31}}}},215,nil,nil,105,"H",nil,1},
[3213] = {'Brave Running Wolf',0,0,5,5,1,{[6452]={{29.52,32.19}}},nil,6452,nil,nil,105,"H",nil,0},
[3214] = {'Brave Greathoof',0,0,5,5,1,{[6452]={{24.67,38.17}}},nil,6452,nil,nil,105,"H",nil,0},
[3215] = {'Brave Strongbash',656,656,15,15,0,{[215]={{48.81,56.65}}},nil,215,nil,nil,105,"H",nil,1},
[3216] = {'Neeru Fireblade',1536,1536,37,37,0,{[1637]={{49.91,59.17}}},nil,1637,{25264},{829,832,5729,5761,24429,25263},29,"H",nil,3},
[3217] = {'Brave Dawneagle',656,656,15,15,0,{[215]={{51.16,60.02}}},nil,215,nil,nil,105,"H",nil,1},
[3218] = {'Brave Swiftwind',656,656,15,15,0,{[215]={{49.72,56.78}}},nil,215,nil,nil,105,"H",nil,1},
[3219] = {'Brave Leaping Deer',656,656,15,15,0,{[215]={{49.7,55.32}}},{[215]={{{50.93,58.39},{50.75,58},{50.53,57.45},{50.33,57.03},{50.13,56.62},{49.98,56.28},{49.82,55.95},{49.66,55.62},{49.38,55.17},{49.14,54.77},{48.9,54.43},{48.71,54.14},{48.63,53.74},{48.7,54.11},{48.88,54.4},{49.13,54.75},{49.37,55.14},{49.64,55.59},{49.81,55.91},{49.96,56.25},{50.11,56.58},{50.3,56.97},{50.51,57.4},{50.74,57.97},{50.92,58.36},{51.09,58.6},{51.25,58.81},{51.09,58.59}}}},215,nil,nil,105,"H",nil,1},
[3220] = {'Brave Darksky',656,656,15,15,0,{[215]={{48.24,53.28}}},{[215]={{{48.11,54.67},{48.25,54.46},{48.32,54.05},{48.29,53.71},{48.15,53.46},{48.07,53.36},{47.83,53.13},{47.55,52.82},{47.25,52.49},{46.98,52.19},{46.78,51.95},{46.61,51.8},{46.31,51.51},{46.59,51.78},{46.77,51.94},{46.97,52.17},{47.24,52.48},{47.53,52.8},{47.82,53.11},{48.06,53.35},{48.13,53.43},{48.27,53.67},{48.32,54.02},{48.26,54.43},{48.13,54.65},{47.97,54.76}}}},215,nil,nil,105,"H",nil,1},
[3221] = {'Brave Rockhorn',656,656,15,15,0,{[215]={{50.08,61.87}}},nil,215,nil,nil,105,"H",nil,1},
[3222] = {'Brave Wildrunner',656,656,15,15,0,{[215]={{47.68,59.94}}},{[215]={{{47.46,61},{47.42,61.39},{47.45,61.02},{47.67,60.55},{47.87,60.76},{48.09,61.15},{48.33,61.6},{48.11,61.17},{47.88,60.79},{47.68,60.55},{47.52,60.85},{47.46,60.99},{47.43,61.37},{47.46,61},{47.54,60.55},{47.58,59.9},{47.53,59.64},{47.39,59.49},{47.21,59.33},{47.17,59.03},{47.17,58.79},{47.32,58.42},{47.44,58.16},{47.41,57.74},{47.37,57.35},{47.38,56.87},{47.42,56.44},{47.47,56.16},{47.49,55.65},{47.57,56.16},{47.65,56.59},{48.03,57.04},{48.35,57.45},{48.55,57.74},{48.72,58.01},{48.79,58.15},{48.78,58.32},{48.72,58.57},{48.64,58.82},{48.55,59.12},{48.47,59.39},{48.25,59.53},{48.06,59.61},{47.84,59.7},{47.67,59.78},{47.34,59.7},{46.89,59.59},{46.67,59.73},{46.49,59.95},{46.25,60.11},{46.04,60.26},{46.24,60.13},{46.47,59.97},{46.66,59.75},{46.87,59.6},{47.33,59.69},{47.67,59.79},{47.83,59.71},{48.05,59.62},{48.22,59.54},{48.46,59.41},{48.54,59.16},{48.64,58.82},{48.72,58.58},{48.78,58.35},{48.79,58.17},{48.73,58.03},{48.57,57.77},{48.37,57.47},{48.05,57.06},{47.67,56.6},{47.57,56.18},{47.5,55.65},{47.48,56.11},{47.38,56.82},{47.37,57.33},{47.41,57.67},{47.44,58.15},{47.33,58.41},{47.17,58.77},{47.16,59.01},{47.19,59.31},{47.4,59.49},{47.53,59.64},{47.58,59.87},{47.58,60.05},{47.52,60.69}}}},215,nil,nil,105,"H",nil,1},
[3223] = {'Brave Rainchaser',656,656,15,15,0,{[215]={{48.34,62.26}}},nil,215,nil,nil,105,"H",nil,1},
[3224] = {'Brave Cloudmane',656,656,15,15,0,{[215]={{45.99,57.59}}},{[215]={{{45.69,58.02},{45.76,58.05},{45.82,58.03},{45.95,57.95},{45.94,58.17},{46.01,58.39},{45.87,58.33},{45.72,58.45},{45.73,58.34},{45.75,58.23},{45.71,58.12},{45.63,58}}}},215,nil,nil,105,"H",nil,1},
[3225] = {'Corrupted Mottled Boar',198,222,10,10,0,{[1637]={{61.32,54.71}}},nil,1637,nil,nil,35,"AH",nil,0},
[3226] = {'Corrupted Scorpid',198,222,10,11,0,nil,nil,0,nil,nil,413,nil,nil,0},
[3227] = {'Corrupted Bloodtalon Scythemaw',198,222,10,11,0,{[14]={{44.04,17.61}}},nil,14,nil,nil,48,nil,nil,0},
[3228] = {'Corrupted Surf Crawler',198,222,10,11,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3229] = {'"Squealer" Thornmantle',102,102,5,5,0,nil,nil,0,nil,nil,111,nil,nil,0},
[3230] = {'Nazgrel',647400,647400,62,62,0,{[3483]={{54.99,35.89}}},nil,3483,{9400,9405,10121,10136,10390,10391,10392,10876},{9401,9406,9495,9588,9608,10046,10135,10136,10291,10388,10390,10391,10392,10401,10755,10875,10876,11003},1074,"H","Advisor to Thrall",3},
[3231] = {'Corrupted Dreadmaw Crocolisk',222,247,11,12,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3232] = {'Bristleback Interloper',198,198,9,10,0,{[215]={{61.16,25.71},{61.43,22.61},{60.58,23.55},{60.38,23.01},{60,22.75},{61.05,21.73},{60.99,23.73},{59.9,24.58},{60.39,25.24},{61.68,23.6},{60.02,23.73},{61.41,24.49},{60.43,24.54},{61.91,22.96},{60.96,25.05},{61.14,25.73},{59.81,21.18},{59.61,23.97},{60.47,24.52},{59.92,24.61},{59.45,23.24},{60.11,23.65},{60.58,23.51},{60.43,25.32},{60.97,23.76},{61.1,23.06},{60.49,21.92},{59.85,22.07},{59.27,22.49},{60.14,21.74},{59.52,21.73},{60.28,21.22}}},nil,215,nil,nil,111,nil,nil,0},
[3233] = {'Lorekeeper Raintotem',156,156,8,8,0,{[215]={{49.52,17.09}}},nil,215,{833},{833},104,"H",nil,3},
[3234] = {'Lost Barrens Kodo',328,328,15,15,0,{[17]={{31.62,43.36},{32.32,41.98},{58.86,36.36},{29.25,47.88},{35.74,39.05},{45.17,78.14},{58.74,33.58},{54.23,24.74},{54.72,28.11},{50.84,28.71},{52.55,26.78},{57.81,87.71},{48.42,81.26},{66.42,81.1},{62.95,78.87},{57.05,76.05},{64.81,79.32},{52.46,85.5},{63.56,78.01},{66.33,79.23},{53.56,78.59},{53.47,84.05},{50.76,81.52},{54.8,85.87},{54.64,76.1},{45.38,78.1}}},nil,17,nil,nil,15,"AH",nil,0},
[3235] = {'Greater Barrens Kodo',664,713,24,25,0,nil,nil,0,nil,nil,15,"AH",nil,0},
[3236] = {'Barrens Kodo',449,484,19,20,0,nil,nil,0,nil,nil,15,"AH",nil,0},
[3237] = {'Wooly Kodo',734,787,25,26,0,nil,{[17]={{{47.1,66.66},{46.97,66.85},{46.73,67.11},{46.32,67.2},{46.12,67.22},{46.03,67.19},{45.96,67.14},{45.89,67.02},{45.83,66.87},{45.79,66.73},{45.73,66.52},{45.71,66.39},{45.72,66.2},{45.69,66.06},{45.64,65.87},{45.36,65.28},{45.18,64.95},{45.17,64.87},{45.18,64.38},{45.22,63.99},{45.36,63.36},{45.45,63.08},{45.51,62.94},{45.67,62.55},{46.03,61.68},{46.26,61.25},{46.37,61.17},{46.53,61.14},{46.8,61.18},{46.93,61.22},{47.18,61.22},{47.49,61.07},{47.62,61.04},{47.67,61.04},{47.8,61.06},{47.95,61.12},{48.14,61.26},{48.27,61.35},{48.36,61.49},{48.47,61.83},{48.57,62.32},{48.53,62.7},{48.4,63.13},{48.17,63.94},{48.12,64.02},{48.08,64.12},{48.06,64.17},{48.03,64.24},{47.87,64.46},{47.66,64.61},{47.44,65.11},{47.36,65.7},{47.34,65.8},{47.32,65.9},{47.3,66.05},{47.23,66.41}}}},0,nil,nil,15,"AH",nil,0},
[3238] = {'Stormhide',573,617,22,23,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3239] = {'Thunderhead',494,531,20,21,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3240] = {'Stormsnout',1006,1006,30,31,0,{[4709]={{49.19,56.21},{51.8,53.78},{49.66,52.9},{42.43,53.82},{43.29,54.32},{51.69,49.45},{50.83,51.88},{43.92,56},{44.5,57.6},{49.06,52.49},{51.42,51.64},{43.81,59.03},{43.57,49.87},{50.4,51.64},{48.62,54.42},{51.25,52.96},{44.64,48.98},{50.98,48.74},{43.24,48.85},{51.45,55.19},{51.34,50.23},{43.76,44.4},{44.57,59.21},{44.63,56.51},{45,58.35},{43.11,52.76},{45.2,57.32},{45.53,56.4},{45.83,58.43},{46.07,46.05},{41.45,53.09},{46.93,48.92},{45,48.35},{46.32,49},{45.54,48.4},{42.85,46.92},{50.59,55.71},{50.03,47.62},{43.37,41.24},{49.55,45.55},{49.18,46.96},{45.07,44.24}}},nil,4709,nil,nil,14,nil,nil,0},
[3241] = {'Savannah Patriarch',356,356,15,16,0,{[17]={{66.57,62.89},{67.5,62.95},{66.56,62.87},{67.5,62.96},{35.13,34.54},{36.52,30.16},{34.18,32.08},{38.51,30.24},{36.59,32.98}}},nil,17,nil,nil,16,nil,nil,0},
[3242] = {'Zhevra Runner',273,273,13,13,0,{[17]={{72.48,66.05},{67.59,50.01},{71.07,60.61},{69.85,59.09},{70.9,60.07},{70.56,58.06},{71.4,61.57},{68.01,50.63},{66.54,49.24},{51.5,46.83},{49.6,40.69},{49.06,45.94},{51.41,45.19},{53.17,44.13},{48.36,45.84},{52.01,44.33},{49.29,39.61},{55.37,47.39},{55.22,48.49},{53.17,54.66},{55.95,49.42},{49.05,44.21},{48.97,38.31},{49.08,44.23},{50.88,43.24},{56.59,47.65},{54.44,47.6},{54.43,46.05},{55.76,48.59},{50.15,43.56},{54.37,61.69},{50.86,54.84},{49.7,54.73},{50.88,53.05},{51.08,53.75},{51.52,55.39},{51.82,56.29},{47.93,53.02},{48.49,54.46},{48.87,51.5},{49.74,50.03},{49.56,52.88},{43.38,46.75},{45.06,45.9},{43.84,46.61},{44.35,47.83},{46.23,58.28},{44.2,51.43},{44.2,49.11},{48.44,61.73},{49.04,53.13},{46.7,59.01},{47.95,53.62},{43.17,48.49},{43.26,53.91},{45.52,57.2},{47.3,59.71},{53.15,59.11},{51.6,58.77},{43.3,50.2},{43.28,55.51},{47.97,60.9},{51.41,58.96},{52.68,55.5},{52.57,58.55},{52.01,58.6},{50.89,63.65},{47.34,54.56},{56.73,63.61},{56.86,62.37},{56.53,64.19},{55.93,63.91},{55.23,65.13},{56.04,65.96},{56.63,66.86},{45.58,69.44},{54.91,68.57},{54.37,68.96},{54.84,67.69},{49.08,67.92},{49.72,66.89},{50.3,68.27},{54.22,67.25},{49.03,68.54},{53.77,68.31},{50.74,68.47},{47.8,64.48},{48.18,63.22},{53.72,69.3},{52.56,69.36},{51.94,68.53},{53.02,70.17},{47.32,65.13},{46.37,64.3},{52.43,64.93},{51.97,66.81},{53.16,63.23},{51.8,63.57},{50.77,67.55},{51.42,66.67},{52.04,65.13},{56.57,65.09},{48.41,62.44},{57.71,66.83},{51.79,67.61},{52.59,67.64},{52.96,65.33},{47.32,68.65},{41.51,72.01},{42.1,72.9},{36.45,50.97},{36.31,52.26},{49.62,40.68},{48.1,35.52},{44.36,68.57},{49.35,44.62},{42.97,73.02},{43.17,72.62},{43.73,71.14},{42.6,71.66},{41.92,70.73},{41.42,69.58},{47.34,34.67},{48.76,39.88},{48.19,37.59},{47.86,36.07},{47.15,31.8},{38.61,52.06},{48.39,44.12},{49.03,38.18},{49.93,41.99},{49.39,43.3},{47.71,40.44},{44.93,30.37},{48.58,39.04},{45.53,29.37},{47.38,72.24},{38.25,53.86},{39.66,54.06},{37.43,64.36},{34.4,56.32},{40.88,70.71},{31.66,46.61},{36.09,63.8},{47.98,32.89},{35.7,55.41},{45.49,69.45},{44.7,70.28},{35.42,50.91},{46.12,72.09},{46.12,72.98},{43.26,53.61},{47.39,69.25},{36.83,63.32},{44.97,73.08},{44.98,72.1},{47.24,30.46},{47.39,32.13},{46.69,29.38},{71.85,63.14},{70.59,68.26},{72.45,66.06},{71.66,66.79},{49.04,69.47},{71.03,61.66},{56.65,66.66},{55.09,67.87},{55.53,69.54},{48.5,70.47},{55.82,70.98},{54.28,65.11},{54.86,69.48},{57.74,65.92},{49.75,68.56},{49.66,67.02},{54.9,68.21},{54.28,68.83},{53.11,70.22},{53.66,69.46},{55.44,72.05},{54.39,71.86},{56,73.36},{47.26,68.52},{47.85,67.74},{53.09,73.43},{51.93,73.55},{70.79,67.69},{50.86,68.62},{47.58,72.1},{51.94,67.21},{51.34,67.68},{53.12,72.92},{53.08,72.09},{49.6,70.3},{49.08,71.12},{50.76,72.16},{50.16,69.49},{50.22,71.11},{51.85,68.47},{44.99,73.82},{51.41,72.86},{53.75,65.95},{50.74,72.09},{57.73,66.6},{57.74,65.5}}},nil,17,nil,nil,189,"AH",nil,0},
[3243] = {'Savannah Highmane',247,247,12,13,0,{[17]={{54.77,58.96},{55.5,58.69},{49.15,51.37},{44.87,53.56},{46.8,64.99},{46.3,33.07},{47.3,41.58},{45.45,33.54}}},nil,17,nil,nil,16,nil,nil,0},
[3244] = {'Greater Plainstrider',247,247,11,12,0,{[17]={{68.14,31.78},{68.57,30.38},{68.34,33.99},{70.38,55.42},{69.86,56.5},{68.52,57.14},{68.92,56.86},{70.39,57.12},{69.63,58.17},{70.46,55.39},{68.88,55.42},{69.4,56.35},{67.8,52.19},{64.36,44.96},{62.34,44.12},{65.31,42.48},{64.44,43.41},{64.25,42.64},{65.56,38.55},{65.24,41.49},{66.19,38.57},{67.31,36.98},{66.45,36.72},{68.05,47},{65.99,39.82},{67.07,37.34},{65.3,41.75},{66.46,37.8},{65.14,41.22},{64.16,45.21},{64.67,43.35},{64.13,43.31},{63.87,39.82},{65.37,39.14},{65.38,41.52},{65.27,42.09},{51.47,60.64},{52.94,56.06},{54.91,47.33},{46.62,53.31},{44.2,46.88},{42.78,53.03},{48.46,37.23},{42.64,52.39},{67.75,33.53},{68.5,33.45},{68.55,30.16},{67.49,31.71},{68.22,31.77},{67.76,31.37},{67.44,29.04},{67.96,26.41},{67.52,37.18},{66.56,34.41},{66.38,36.67},{68.24,35.78}}},nil,17,nil,nil,7,"AH",nil,0},
[3245] = {'Ornery Plainstrider',356,356,17,17,0,{[17]={{68.36,64.56},{65.36,58.73},{65.74,65.11},{65.82,59.76},{65.79,65.91},{63.95,62.53},{65.3,64.09},{68.47,64.37},{64.71,61.67},{65.28,61.62},{62.91,60.91},{68.24,64.18},{65.92,65.22},{64.83,65.35},{64.76,67.77},{65.32,65.3},{65.81,66.81},{65.43,64.07},{68.7,64.19},{62.79,64.22},{34.61,31.9},{37.78,28.79},{34.11,33.22},{35.64,32.98},{33.41,32.33},{32.85,32.54},{35.75,33.63},{34.92,34.47},{35.6,35.41},{36.23,33.05},{36.1,32.06},{32.03,33.1},{34.29,31.57},{39.74,30.09},{39.23,28.8},{42.75,28.41},{36.59,30.58},{36.56,30.67},{36.1,30.62},{39.11,32.45},{38.36,31.14},{36.89,29.35},{32.14,31.79},{39.61,31.58},{66.07,28.94},{60.34,18.71},{60.88,18.01},{63.81,17.87},{61.17,19.2},{60.26,17.51},{57.62,12.84},{56.7,14.6},{56.58,16.33},{65.32,24.32},{65.34,28.43},{65.87,24.47},{64.82,21.55},{64.23,20.04},{62.49,19.63},{56.64,14.21},{56.58,16.2},{60.97,18.57},{61.2,18},{61.29,19.67},{60.72,17.32},{56.71,16.11},{62.69,19.35},{55.81,88.54},{52.53,89.73},{57.65,90.96},{56.21,89.88},{56.86,88.18}},[4709]={{49.53,54.98}}},nil,17,nil,nil,7,"AH",nil,0},
[3246] = {'Fleeting Plainstrider',247,247,12,13,0,{[17]={{69.96,55.19},{71.6,66.66},{72.04,63.55},{70.99,68.1},{71.39,65.41},{70.53,68.59},{60.99,41.61},{69.97,61.66},{69.92,60.8},{69.95,54.56},{58.24,43.54},{67.61,49.37},{57.85,54.65},{59.36,60.52},{57.97,52.37},{58,56.26},{57.65,60.18},{60.44,56.09},{51.6,37.17},{59.6,54.12},{59.62,59.07},{58.76,60.08},{56.26,57.35},{60.17,59.98},{58.42,60.59},{57.12,55.43},{59.96,57.72},{57.4,58.31},{59.52,55.65},{58.21,53.54},{58.84,52.87},{58.18,57.29},{58.89,58.1},{58.38,55.38},{58.94,56.66},{51.37,38.14},{58.17,59.01},{50.9,38.93},{51.05,42.7},{59.95,51.14},{55.38,46.21},{58.52,43.49},{41.72,60.9},{41.84,63.25},{60.82,61.54},{41.61,62.24},{42.63,62.53},{43.62,61.15},{59.45,60.66},{57.72,60.15},{43.36,63.31},{44.37,65.01},{45.27,65.67},{58.91,60.08},{58.26,60.89},{44.58,63.47},{42.63,60.2},{43.95,61.84},{41.93,65.27},{41.35,64.25},{44.92,68},{46.18,68.03},{46.79,69.31},{47.43,67.53},{47.88,66.65},{41.64,60.9},{42.03,63.52},{44.05,39.98},{40.17,39.31},{45.16,37.19},{41.68,62.66},{43.38,40.52},{43.26,39.04},{42.67,62.65},{41.88,67.58},{43.76,61.07},{42.87,41.56},{32.76,46.88},{41.59,66.33},{49.68,34.43},{42.27,40.88},{45.23,39.28},{43.67,41.88},{36.87,49.4},{51.23,34.5},{50.8,35.59},{46.19,70.46},{43.25,63.55},{42.67,39.92},{43.36,37.34},{51.91,37.19},{44.39,64.92},{44.27,40.59},{41.13,41.22},{44.68,63.31},{46.02,35.87},{42.78,60.18},{43.96,61.65},{41.99,65.41},{35.7,49.4},{41.43,64.19},{43.85,38.15},{45.6,40.87},{36.66,50.1},{50.75,33.63},{39.48,59.38},{35.04,49.04},{43.79,33.09},{43.26,35.46},{42.6,70.75},{40.37,65.68},{32.85,49.43},{49.24,32.22},{49.77,35.68},{38.6,57.02},{37.71,52.52},{45.05,69},{42.97,69.62},{46.19,68.59},{44.31,71.31},{45.52,70.86},{37.53,50.44},{43.67,70.32},{32.27,46.08},{44.4,69.42},{39.19,52.81},{44.08,71.94},{52.4,34.71},{34.04,50.39},{51.05,38.91},{37.99,59.49},{39.23,56.57},{39.91,55.5},{38.21,58.2},{46.27,69.44},{39.11,58.28},{36.32,62.61},{36.84,65.89},{34.45,54.21},{36.91,62.14},{32.22,51.09},{38.68,62.88},{36.76,67.1},{33.41,53.79},{37.16,60.36},{39.63,64.88},{33.04,54.09},{35.2,56.44},{34.52,58.28},{37.32,67.56},{37.29,62.47},{34.17,48.43},{41,52.89},{39.9,52.43},{39.98,48.53},{41.07,50.08},{51.33,32.03},{49.71,32.08},{46.68,28.55},{47.88,28.73},{49.13,31.11},{60.69,40.47},{62.19,41.34},{60.4,40.7},{48.31,65.88},{47.43,66.56},{46.78,68.91},{71.95,65.16}},[4709]={{43.82,17.78}}},nil,17,nil,nil,189,"AH",nil,0},
[3247] = {'Thunderhawk Hatchling',302,346,18,20,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3248] = {'Barrens Giraffe',328,328,15,16,0,{[17]={{65.25,56.98},{64.18,54.23},{64.41,55.83},{64.16,53.78},{65.33,62.65},{63.72,61.25},{64.46,60.21},{64.82,60.2},{64.78,60.16},{64.76,60.23},{64.73,60.19},{63.54,65.41},{62.31,64.61},{62.23,68.75},{63.14,69.29},{61.57,68.93},{59.76,70.15},{59.1,68.12},{58.26,35.5},{31.69,43.31},{33.42,39.97},{55.21,34.72},{57.99,33.67},{59.96,37.19},{58.32,36.41},{29.68,47.92},{35.57,38.94},{32.57,40.67},{35.78,36.27},{36.99,38.48},{43.7,76.88},{45.05,77.25},{69.29,17.13},{65.45,31.63},{64.11,33.72},{69.41,20},{66.72,21.13},{65.86,19.79},{54.06,17.99},{53.82,18.31},{53.75,24.06},{50.91,30.21},{48.99,27.43},{50.32,27.57},{66.29,66.63},{52.95,79.2},{58.31,80.69},{54.59,76.83},{55.44,88.18},{64.78,77.44},{56.57,72.02},{56.02,76.51},{58.29,80.55},{64.93,77.69},{60.67,68.52},{58.36,65.94},{59.44,65.93},{59.56,65.69},{59.57,66.06},{59.71,65.77},{59.57,65.85},{59.7,65.98},{60.23,65.79}},[4709]={{47.77,30.72}}},nil,17,nil,nil,189,"AH",nil,0},
[3249] = {'Greater Thunderhawk',544,582,23,24,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3250] = {'Silithid Creeper',494,531,20,21,0,nil,nil,0,nil,nil,413,nil,nil,0},
[3251] = {'Silithid Grub',484,484,20,20,0,nil,nil,0,nil,nil,413,nil,nil,0},
[3252] = {'Silithid Swarmer',211,211,31,32,0,{[4709]={{41.33,66.97},{41.15,66.89},{41.05,67.04},{41.22,67.43},{41.17,67.39},{41.24,67.31},{42.44,67.27},{42.48,67.28},{42.32,67.11},{42.25,67.7}}},nil,4709,nil,nil,310,nil,nil,0},
[3253] = {'Silithid Harvester',1744,1744,34,34,4,{[4709]={{43.44,70.67},{41.31,66.93}}},nil,4709,nil,nil,310,nil,nil,0},
[3254] = {'Sunscale Lashtail',218,218,11,13,0,{[17]={{47.38,73.12},{50.66,74},{47.67,73.46},{50.84,74.66},{47.37,73.1},{48,73.67},{47.79,71.44},{48.62,73.55},{49.14,75.43},{49.53,75.2},{49.53,74.54},{48.59,74.86},{48.53,74.64},{48.76,74.14},{47.97,73.21},{48.07,76.12},{49.25,75.24},{47.91,76.04},{47.97,71.47},{49.09,71.16},{48.16,71.69},{48.76,71.43},{48.66,73.59},{48.4,74.65},{48.06,73.68}}},nil,17,nil,nil,48,nil,nil,0},
[3255] = {'Sunscale Screecher',300,300,13,14,0,{[17]={{64.3,54.33},{65.36,57.35},{63.9,53.01},{63.61,57.55},{64.63,62.48},{64.62,54.66},{65.87,59.76},{65.3,56.58},{64.21,53.78},{64.8,58.42},{65.83,61.49},{63.33,57.68},{60.08,65.29},{64.15,68.59},{65.06,66.56},{57.96,65.43},{60.67,66.1},{58.94,68.24},{59.71,69.94},{60.62,70.94},{61.29,65.97},{61.14,65.91},{61.44,64.09},{61.9,72.07},{57.19,65.84},{58.37,65.61},{60.65,31.7},{62.28,32.92},{61.74,31.85},{62.69,32},{44.98,72.13},{33.97,40.74},{45.59,74.65},{33.36,39.92},{32.18,42.23},{36.25,39.89},{28.79,47.63},{29.33,45.03},{35.19,38.23},{34.67,40.29},{30.68,40.88},{30.39,48.93},{37.47,38.1},{32.89,43.22},{31.03,42.32},{44.51,76.34},{44.8,77.24},{63.23,30.01},{62.19,27.93},{62.7,29.02},{60.8,31.94},{62.29,33.31},{61.73,32.21},{62.78,31.95},{62.81,23.9},{69.9,15.58},{60.53,30.06},{64.3,26.17},{64.25,30.22},{60.79,28.78},{59.69,26.73},{59.39,28.42},{61.19,29.47},{58.93,27.77},{61.22,27.53},{62.04,26.91},{60.6,26.86},{60.13,27.8},{59.98,29.24},{61.65,30.44},{57.13,24.91},{51.93,82.85},{54.99,85.25},{54.25,75.62},{45.54,74.29},{56.98,76.54},{62.3,87.03},{52.29,83.99},{53.66,79.88},{44.77,75.43},{50.26,81.71},{53.16,75.46},{60.75,71.08},{59.64,77.22},{47.79,81.95},{51.24,74.27},{57.33,78.19},{60.14,78.3},{63.04,84.31},{54.87,83.38},{51.04,81.45},{52.16,85.85},{62.92,77.34},{64.72,79.27},{65.67,78.43},{66.81,79.03},{64.66,81.98},{58.24,74.61},{61.24,68.99},{63.01,85.91},{63.53,84.91},{57.18,76.44},{61.66,87.79},{55.97,74.82},{43.92,76.95},{56.61,72.1},{66.09,78.27},{58.86,78.89},{59.58,82.98},{51.94,85.98},{60.72,75.23},{62.35,85.22},{61.33,88.38},{58.34,74.61},{57.84,74.83},{59.58,78.05},{61.45,86.88},{53.43,77.24},{54.22,84.82},{60.68,82.9},{56.68,83.6},{53.64,86.02},{61.82,75.53},{53.66,76.33},{58.24,69.4},{64.33,84.22},{51.26,80.95},{62.24,83.59},{63.8,83.55},{48.99,81.53},{57.77,73.85},{59.3,85.61},{47.16,75.62},{54.32,84.14},{48.58,81.77},{63.78,80.78},{45.03,77.33},{59.4,79.97},{59.57,71.99},{54.8,86.02},{56.17,75.24},{57.17,87.76},{56.12,83.71},{51.99,87.09},{54.56,86.66},{47.73,74.84},{55.12,73.83},{60.82,75.48},{54.34,84.12},{63.29,82.62},{47.34,81.09},{61.95,86.19},{59.19,76.78},{62.39,72.42},{49.64,74.92},{60.81,68.66},{59.05,68},{58.46,65.72},{58.91,64.86},{48.52,73.07}},[4709]={{47.29,28.06},{67.2,35.31},{37.85,11.24}}},nil,17,nil,nil,48,nil,nil,0},
[3256] = {'Sunscale Scytheclaw',356,356,16,16,0,{[17]={{64.3,55.55},{63.67,55.61},{66.32,65.97},{64.69,55.47},{68.09,63.08},{64.36,56.81},{63.38,59.58},{63.95,60.47},{63.68,58.88},{62.61,58.66},{65.16,58.02},{66.06,65.92},{64.3,63.71},{64.65,66.63},{68.3,63.76},{63.68,63.75},{37.75,31.89},{58.76,33.07},{57.66,32.26},{58.91,35.54},{58.64,37.32},{63.04,36.28},{63.58,35.51},{57.57,37.14},{62.43,36.8},{37.02,32.94},{36.37,29.68},{37.96,30.3},{54.81,32.89},{61.02,36.29},{56.63,32.12},{59.49,36.57},{60.06,16.33},{64.65,25.13},{62.71,36.49},{63.28,35.64},{65.29,22.45},{62.31,37.4},{59.88,19.75},{63.35,20.02},{63.6,21.54},{55.33,21.5},{54.25,21.47},{59.62,16.23},{52.01,30.34},{49.69,28.6},{51.37,29.26},{50.33,29.55},{60.03,19.8},{55.4,21.72},{54.35,21.51},{54.48,29.33},{49.53,29.53},{56.09,22.42},{53.35,23.44},{52.31,89.99},{57.2,90},{55.07,89.61},{52.04,88.57},{66.43,66.25}},[4709]={{67.12,38.65},{66.81,38.24}}},nil,17,{14067},nil,48,nil,nil,0},
[3257] = {'Ishamuhale',449,449,19,19,0,nil,nil,0,nil,nil,48,nil,nil,0},
[3258] = {'Bristleback Hunter',386,417,17,18,0,{[4709]={{38.92,33.35}}},nil,4709,nil,nil,111,nil,nil,0},
[3259] = {'Bristleback Defender',5000,5000,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3260] = {'Bristleback Water Seeker',325,350,16,17,0,nil,nil,0,nil,nil,111,nil,nil,0},
[3261] = {'Bristleback Thornweaver',888,888,31,32,0,{[4709]={{39.44,34.31},{39.83,33.04},{44.98,45.77},{38.83,33.26},{42.05,42.92},{47.59,44.63},{46.96,44.71},{44.81,45.74},{41.37,38.54},{42.03,42.42},{44.35,41.78},{44.14,42},{41.99,37.31},{42.61,37.86},{42.13,36.95}}},nil,4709,nil,nil,111,nil,nil,0},
[3262] = {'Bristleback Mystic',5000,5000,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3263] = {'Bristleback Geomancer',379,405,19,20,0,nil,nil,0,nil,nil,111,nil,nil,0},
[3265] = {'Razormane Hunter',222,222,11,11,0,{[17]={{69.39,55.62},{68.89,52.09},{70.33,57.57},{68.04,51.69},{69.4,54.61},{68.16,52.46},{67.17,52.5},{66.16,46.09},{66.49,49.25},{66.13,50.95},{68.37,48.76},{67.93,46.66},{68.2,50.16},{66.48,50.96},{67.45,53.41},{66.83,50.41},{68.24,50.32},{66.11,46.59},{55.44,51.72},{53.75,50.69},{54.4,51.47},{54.96,52.52},{61.95,52.28},{60.18,48.58},{61.37,47.52},{56.35,48.37},{61.81,47.65}}},nil,17,nil,nil,109,nil,nil,0},
[3266] = {'Razormane Defender',247,247,11,12,0,{[17]={{63.04,48.32},{65.28,56.26},{65.19,54.06},{65.12,53.88},{64.28,54.68},{64.24,55.58},{63.77,54.4},{66.12,52.2},{66.04,52.19},{64.94,52.21},{63.87,55.36},{66.05,52.43},{64.36,54.28},{65.23,54.48},{63.95,53.95},{66.08,52.52},{65,53.19},{65.02,52.77},{63.75,54.38},{64.51,54.48},{66.15,52.31},{64.91,53.95},{64.15,55.48},{65.4,54.7},{65.25,54.28},{64.97,52.63}}},nil,17,nil,nil,109,nil,nil,0},
[3267] = {'Razormane Plunderer',198,198,10,11,0,{[17]={{68.85,50.66},{68.02,48.22},{66.79,54.21},{67.88,52.55},{68.82,50.71},{68.25,53.33},{68.34,54.72},{66.81,52.14},{66.63,45.97},{66.56,48.75},{67.29,47.83},{67.12,50.07},{65.82,46.96},{66.92,48.9},{67.61,50.01},{67.73,51.05},{66.3,47.02},{66.73,46.76},{66.92,49.06},{67.65,49.94},{67.14,49.98},{67.65,50.8},{67.21,47.71},{66.43,49.39},{66.98,51.57},{68.08,47.55},{68.08,53.21},{66.88,54.01},{66.97,49.1},{67.67,49.42},{67.1,50.01},{67.14,46.62},{67.23,47.6}}},nil,17,nil,nil,109,nil,nil,0},
[3268] = {'Razormane Thornweaver',186,186,10,11,0,{[17]={{65.03,56.23},{65.44,56.35},{65.24,53.68},{63.01,54.13},{65.13,53.83},{64.86,55.15},{64.19,53.21},{63.13,56.55},{65.51,52.74},{63.4,54.78},{63.23,56.53},{65.3,54.05},{64.93,55.24},{64.67,52.95},{64.89,55.26},{63.21,56.48},{65.57,52.85},{64.2,53.36},{65.51,52.87},{65.27,53.76},{65.25,53.89},{63.14,54.21},{65.04,56.22},{63.18,55.91},{65.28,53.63},{65.31,53.84},{63.28,54.36},{65.56,52.82}}},nil,17,nil,nil,109,nil,nil,0},
[3269] = {'Razormane Geomancer',241,241,12,13,0,{[17]={{63.05,50.42},{63.04,48.3},{62.84,50.76},{55.4,50.44},{54.79,51.38},{54.29,51.06},{63.04,48.31},{54.53,49.17},{55.47,51.97},{56.31,51.46},{56.27,51.99},{55.75,52.81},{61.79,50.22},{53.87,48},{62.37,50.2},{59.39,49.57},{58.37,49.35},{58.79,49.19},{62.65,48.35},{59.25,47.85}}},nil,17,nil,nil,109,nil,nil,0},
[3270] = {'Elder Mystic Razorsnout',380,380,13,13,4,{[17]={{62.57,48.51},{60.71,52.62}}},nil,17,nil,nil,109,nil,nil,0},
[3271] = {'Razormane Mystic',253,253,12,13,0,{[17]={{53.38,49.41},{60.82,51.28},{61.23,52.13},{61.04,53.18},{61.22,53.29}}},nil,17,nil,nil,109,nil,nil,0},
[3272] = {'Kolkar Wrangler',273,273,13,13,0,{[17]={{53.05,78.65},{42.79,48.65},{43.1,48.73},{51.66,69.46},{52.75,70.4},{52.27,70.27},{35.05,51.5},{34.41,42.17},{34.71,50.83},{34.56,51.89},{34.61,51.58},{37.47,40.43},{39.37,46.58},{31.62,48.6},{31.9,48.87},{39.23,46.84},{32.44,52.82},{36.74,41.2},{38.78,50.66},{32.17,49},{32.13,49.12},{38.79,49.99},{38.44,50.15},{38.79,50.51},{38.49,50.72},{35.91,42.05},{35.86,43.08},{35.05,43.05},{34.94,42.43},{38.55,44.76},{38.2,44.17},{36.36,44.93},{33.29,46.9},{36.19,46.93},{34.71,46.43},{34.75,51.77},{34.59,51.55},{38.2,49.65},{36.27,44.92},{38.05,49.85},{38.77,49.96},{40.4,45.99},{38.42,50.15},{40.05,45.95},{40.04,45.28},{35.88,43.19},{55.47,70.8},{54.66,70.96},{52.09,70.88},{54.73,71.03},{51.32,69.78}},[4709]={{40.28,8.39},{40.73,8.89}}},nil,17,nil,nil,130,nil,nil,0},
[3273] = {'Kolkar Stormer',253,253,13,14,0,{[17]={{43.18,48.01},{34.82,51.32},{30.92,48.46},{32.05,48.56},{31.99,53.32},{39.3,46.86},{32.21,52.5},{36.75,39.72},{37.43,41.86},{37.15,40.38},{32.16,49.14},{35.36,43.14},{34.96,42.75},{35.32,42.17},{38.57,45.13},{36.36,44.16},{35.01,46.03},{38.59,44.75},{38.06,47.78},{36.79,44.01},{33.72,46.54},{36.21,45.86},{36.91,47.95},{34.52,46.69},{38.07,47.77},{38.07,49.89},{36.36,44.21},{39.79,45.67},{37.43,41.67},{37.18,40.37},{58.85,77.03},{52.31,75.79},{52.51,71.67},{51,69.78},{54.47,70.65},{58.42,77.86},{52.06,76.13}}},nil,17,nil,nil,130,nil,nil,0},
[3274] = {'Kolkar Pack Runner',328,328,14,15,0,{[17]={{55.92,89.62},{54.21,76.94},{53.13,79.73},{55.48,86.83},{51.02,84.58},{57.17,78},{55.53,87.55},{58.5,82.08},{52.53,78.16},{52.65,77.99},{53.21,80.57}}},nil,17,nil,nil,130,nil,nil,0},
[3275] = {'Kolkar Marauder',417,417,17,17,0,{[17]={{43.96,74.71},{43.81,74.27},{43.33,75.65},{43.22,76.51},{42.6,77.16},{40.87,76.59},{38,74.63},{40.17,71.2},{42.08,74.63},{41.58,73.71},{40.37,72.29},{40.35,73},{38.45,72.89},{38.53,71.19},{56.37,87.99},{43.39,76.33},{43.94,74.71},{43.79,74.29},{43.33,75.72}},[4709]={{47.68,27.34}}},nil,17,nil,nil,130,nil,nil,0},
[3276] = {'Witchwing Harpy',417,417,17,18,0,{[17]={{42.33,30.24},{30.82,34.69},{31.09,32.47},{29.32,39.36},{28.85,33.56},{41.61,28.98},{28.32,39.67},{31.64,38.25},{31.69,39.28},{30.94,38.06},{30.35,36.24},{29.99,37.12},{29.16,37.14},{29.39,39.03},{28.31,38.34},{28.97,39.3},{28.85,34.53},{30.87,30.95},{29.35,31.01},{29.41,33.72},{30.41,30.32},{29.3,32.96},{29.11,37.14},{42.97,27.98}}},nil,17,nil,nil,514,nil,nil,0},
[3277] = {'Witchwing Roguefeather',386,386,17,18,0,{[17]={{27.97,31.74},{31.23,29.97},{30.39,32.65},{31.48,32.56},{40.55,32.77},{31.75,38.35},{30.02,34.79},{29.75,39.91},{31.08,39.73},{28.45,31.59},{29.36,37.88},{30.88,37.18},{30.51,39.92},{29.39,36.31},{30.08,30.81},{30.52,32.98},{29.51,35.26},{29.95,33.39},{28.88,32.16},{30.88,29.56},{31.67,31.06},{29.94,31.94}}},nil,17,nil,nil,514,nil,nil,0},
[3278] = {'Witchwing Slayer',417,417,18,18,0,{[17]={{26.85,32.5},{27.03,29.66},{23.47,33.71},{23.52,33.05},{28.25,26.02},{27.82,25.8},{25.17,27.11},{24.78,29},{26.82,33.87},{26.5,28.52},{28.47,33.12},{27.42,28.49},{25.21,29.53},{25.72,29.94},{26.96,27.04},{26.25,25.8},{28.03,34.51},{27.08,35.59},{27.68,34.79},{28.17,32.35},{27.73,33.99},{27.2,26.7},{28.34,31.27},{28.78,33.5},{25.42,32.69},{25.77,33.62},{27.59,31.11},{26.99,32.88},{27.96,32.7},{25.22,31.02},{27.05,31.21},{26.31,34.73},{26.31,31.84},{26.85,29.7},{26.08,31.53},{24.87,31.22}}},nil,17,nil,nil,514,nil,nil,0},
[3279] = {'Witchwing Ambusher',193,193,17,18,0,{[17]={{26.22,29.98},{23.38,32.8},{25.32,27.46},{26.06,31.47},{25.56,34.5}}},nil,17,nil,nil,514,nil,nil,0},
[3280] = {'Witchwing Windcaller',350,350,17,17,0,{[17]={{26.9,32.39},{26.2,30.3},{27.31,27.32},{27.69,26.34},{25.8,28.22},{30.35,38.07},{25.08,28.48},{30.54,33.13},{25.72,35.42},{24.44,33.88},{25.18,34.04},{26.26,35.63},{24.83,33.53},{26.01,36.42},{26.36,26.98},{27.44,27.84},{26.41,29.75},{29.4,36.22}}},nil,17,nil,nil,514,nil,nil,0},
[3281] = {'Sarkoth',0,0,4,4,0,{[6451]={{34.48,62.13}}},nil,6451,nil,nil,7,"AH",nil,0},
[3282] = {'Venture Co. Mercenary',386,386,16,17,0,{[17]={{56.78,18.63},{57.16,17.66},{56.36,17.81},{57.21,19.6},{58.56,18.34},{59.15,19.72},{57.58,18.47},{57.42,20.02},{56.36,20.02},{56.72,18.66},{57.14,17.6},{56.34,17.74},{57.2,19.58},{57.53,18.44},{56.97,19.87},{59.69,17.68},{59.61,17.66},{56.34,20.04},{57.21,21.44},{56.79,18.74},{57.13,17.65},{56.33,17.73},{57.2,19.6},{58.54,18.36},{58.37,20.49},{59.13,19.78},{57.67,18.42},{56.97,19.87},{56.77,18.66},{57.59,18.48}}},nil,17,nil,nil,47,nil,nil,0},
[3283] = {'Venture Co. Enforcer',356,356,16,17,0,{[17]={{67.46,11.41},{66.55,11.44},{67.48,13.88},{67.67,15.01},{67.1,13.2},{67.11,12.04},{65.55,12.11},{66.07,12.18},{65.53,11.53},{66.24,14.96},{64.45,12.29},{65.11,11.87},{66.91,11.75},{66.25,13.11},{67,15.01},{65.71,14.09},{63.23,11.91},{64.07,11.27},{63.34,11.34},{66.28,13.17},{67.08,13.15},{65.73,14.16},{67.1,12.03},{66.88,11.77},{65.11,11.84},{65.57,12.11},{66.07,12.22},{65.1,11.85},{64.44,12.28},{63.01,10.19},{64.16,11.89},{63.39,10.96},{63.3,10.4},{63.46,11.76},{66.53,11.48},{64.21,11.56},{65.53,11.55},{64.44,12.29},{63.6,12.21},{64.17,12.32},{63.93,10.86}}},nil,17,nil,nil,47,nil,nil,0},
[3284] = {'Venture Co. Drudger',386,386,16,17,0,{[17]={{59.32,17.92},{59.48,18.98},{56.92,18.26},{56.51,18.16},{56.11,17.98},{56.27,17.38},{57.12,18.48},{57.79,17.78},{58.78,17.75},{59.04,18.82},{58.96,18.26},{56.98,17.12},{56.51,17.02},{56.13,19.96},{56.26,19.49},{56.37,20.99},{55.81,20.86},{56.81,21.16},{56.16,18.81},{56.95,18.25},{56.5,18.17},{56.1,18},{56.21,17.39},{57.23,20.63},{57.21,18.49},{57.83,17.75},{56.99,17.15},{56.44,17.04},{57.26,20.23},{56.66,19.97},{56.79,20.31},{59.34,17.94},{59.56,18.91},{59.46,19.03},{58.87,20.88},{51.32,23.63},{50.85,24.48},{59.23,20.57},{58.52,21.02},{56.08,19.9},{57.09,21.92},{56.25,19.39},{56.79,22.4},{56.35,20.98},{50.44,24.07},{55.83,20.85},{56.78,21.21},{56.11,21.88},{55.43,18.31},{57.63,21.34},{51.28,23.25},{56.94,18.27},{56.46,18.19},{56.11,17.98},{56.21,17.41},{57.22,20.66},{57.12,18.47},{57.76,17.72},{58.76,17.82},{59.11,17.99},{58.98,18.19},{56.95,17.18},{56.47,17.03},{58.79,20.48},{57.85,20.69},{58,21.3},{57.25,20.23},{56.65,19.96},{56.79,20.32},{56.14,18.75},{56.98,18.27},{57.15,18.46},{58.97,17.65},{58.04,21.19},{57.89,20.75},{56.65,19.95}}},nil,17,nil,nil,47,nil,nil,0},
[3285] = {'Venture Co. Peon',356,356,16,17,0,{[17]={{51.46,24.26},{49.55,25.19},{50.64,23.43},{50.88,25.89},{50.31,24.9},{50.23,26.03},{51.82,23.57},{51.04,24.32},{52.06,26.77},{49.73,26.02}}},nil,17,nil,nil,47,nil,nil,0},
[3286] = {'Venture Co. Overseer',386,386,17,18,0,{[17]={{66.19,14.51},{67.04,12.66},{67.13,11.58},{64.29,12.49},{67.68,10.89},{66.56,14.04},{66.73,11.04},{67.02,14.69},{66.76,11.89},{67,13.72},{65.8,14.41},{63.63,11.81},{63.34,11.21},{64.29,12.49},{64.36,11.48},{62.94,10.51},{63.38,12.07},{66.46,13.89},{67.06,12.64},{67.02,13.8},{66.94,13.55},{66.85,12.08},{67.11,11.63},{66.75,11.03},{63.56,10.7},{65.92,12.35},{63.03,10.04},{62.87,10.56},{63.04,11.86}}},nil,17,nil,nil,47,nil,nil,0},
[3287] = {'Hana\'zua',0,0,2,2,0,{[6451]={{34.62,44.2}}},nil,6451,{25129,25130},{25128,25129},126,"H",nil,2},
[3289] = {'Spirit of Minshina',222,222,11,11,0,nil,nil,0,nil,nil,1801,"H",nil,0},
[3290] = {'Deek Fizzlebizz',840,840,27,27,0,{[38]={{42.81,9.96}}},nil,38,nil,nil,875,"A","Engineering Trainer",81},
[3291] = {'Greishan Ironstove',664,664,24,24,0,{[38]={{34.09,45.15}}},{[38]={{{25.56,10.49},{25.6,12.71},{25.69,13.73},{25.88,14.71},{25.9,15.33},{25.97,16.04},{25.99,18.7},{26.13,20.53},{26.68,22.96},{26.96,23.68},{28.05,25.67},{28.44,27.16},{28.95,28.85},{29.64,30.47},{30.22,32.73},{30.39,33.87},{30.43,34.62},{30.83,37.18},{31.07,38.76},{31.26,39.28},{31.85,40.32},{32.16,41.03},{32.21,41.35},{32.17,42.61},{32.01,43.31},{31.67,44.06},{31.38,45.3},{31.29,46.77},{31.39,47.77},{31.65,48.32},{32,48.97},{32.19,49.7},{32.38,49.85},{32.61,49.79},{33.12,49.33},{33.96,48.13},{34.82,47.08},{35.53,46.77},{36,46.42},{36.27,46.3},{36.91,46.18},{37.32,45.68},{37.4,44.56},{37.23,42.93},{36.76,41.95},{37.15,42.94},{37.35,44.53},{37.26,45.6},{36.89,46.11},{36.14,46.31},{35.46,46.71},{35.01,46.85},{34.51,47.3},{33.18,49.22},{32.34,50.21},{32.27,51.4},{31.87,53.56},{31.5,56.13},{31.31,57.02},{30.6,58.02},{29.9,58.99},{29.39,60.31},{29.18,60.85},{28.73,62.37},{28.15,64.72},{28,65.4},{27.65,65.84},{26.95,66.15},{25.61,67.42},{25.09,67.7},{24.72,68.13},{23.66,69.68},{22.89,70.76},{21.82,72.41},{21.4,72.95},{20.61,74.75},{20.48,75.04},{21,75.84},{21.76,76.77},{22.33,77.26},{22.79,77.12},{23.17,76.68},{23.4,76.25},{22.99,76.93},{22.36,77.31},{22.05,77.15},{21.34,76.2},{20.62,75.25},{20.68,74.66},{21.4,73.14},{22.15,72.1},{23,70.87},{24.01,69.42},{24.85,68.14},{25.44,67.55},{25.85,67.35},{26.72,66.46},{27.47,65.99},{27.88,65.74},{28.14,65.35},{28.48,63.79},{28.83,62.45},{29.36,60.76},{29.9,59.03},{30.91,57.8},{31.39,57.09},{31.56,56.74},{31.89,54.41},{32.15,52.67},{32.29,50.88},{32.28,49.7},{32.15,49.19},{31.87,48.55},{31.5,47.72},{31.36,46.73},{31.45,45.49},{31.63,44.67},{31.91,43.78},{32.17,43.17},{32.32,42.24},{32.34,41.06},{31.93,40.34},{31.48,39.49},{31.15,38.59},{30.97,37.55},{30.74,35.81},{30.46,33.67},{30.07,31.46},{29.4,29.65},{28.93,28.4},{28.28,26.15},{28.03,25.37},{27.22,23.91},{26.9,23.33},{26.43,21.6},{26.18,19.78},{26.16,18.06},{26.14,15.83},{26.05,15.01},{25.76,13.72},{25.62,11.67}}}},38,nil,nil,55,"A","Traveling Merchant",640},
[3292] = {'Brewmaster Drohn',176,176,9,9,0,{[17]={{67.68,72.87}}},nil,17,nil,{819,821,822},29,"H",nil,0},
[3293] = {'Rezlak',102,102,5,5,0,{[14]={{46.37,22.94}}},nil,14,{834,835},{834,835},69,"AH","Tinkers' Union",3},
[3294] = {'Ophek',198,198,10,10,0,{[14]={{54.37,41.29}}},nil,14,nil,nil,29,"H",nil,0},
[3295] = {'Sludge Anomaly',674,674,19,19,4,{[17]={{56.92,20.5},{57.77,19.17},{57.98,19.97}}},nil,17,nil,nil,14,nil,nil,0},
[3296] = {'Orgrimmar Grunt',116235,116235,85,85,0,{[14]={{45.09,12.16},{45.09,12.45},{45.91,12},{45.9,12.32},{44.75,13.95},{44.99,13.99},{45.5,11.71},{45.34,12.01},{45.7,11.95},{36.91,3.52},{37.14,4.56},{35.91,1.84},{37.07,3.29},{37.02,3.34},{37.22,3.2},{37.58,5.16},{36.38,2.43}},[16]={{27.12,77.02},{26.54,77.98},{26.78,76.68},{26.9,78.06}},[17]={{70.25,4.24},{70.37,4.45}},[1637]={{63.54,51.58},{50.75,85.18},{64.97,40.09},{64.93,39.85},{44.77,64.46},{44.5,64.85},{44.62,64.7},{53.08,79.4},{43.92,73.44},{47.12,72.03},{47.52,81.7},{47.38,81.9},{45.76,62.75},{62.96,50.13},{74.78,43.31},{50.86,55.42},{51.1,55.74},{52.46,55.65},{50.92,53.52},{46.92,80.69},{53.2,69.94},{64.85,39.38},{57.91,47.98},{63.56,51.48},{47.74,71.02},{44.53,67.11},{53.21,79.54},{48.59,70.4},{50.65,78.54},{60.34,49.32},{60.7,50.09},{75.14,44.39},{66.51,37.19},{66.91,39.6},{55.45,50.86},{51.2,78.09},{49,45.62},{50.37,52.22},{49.77,52.37},{49.61,41.98},{75.03,44.23},{46.8,81.58},{62.67,49.84},{75.68,46.51},{70.35,30.68},{46.84,80.88},{67.29,38.9},{55.45,51.88},{50.17,65.17},{64.7,49.16},{48.98,41.73},{67.14,36.85},{43.67,66},{49.14,80.94},{61.36,47.7},{61.25,47.81},{61.33,48},{61.45,47.89},{61.42,48.17},{61.53,48.06},{61.5,48.36},{61.62,48.24},{56.74,63.12},{44.79,65.21},{53.29,70.09},{46.41,73.2},{49.41,51.09},{60.5,47.26},{48.08,59.59},{53.76,69.64},{45.88,76.53},{41.71,71.89},{52.17,81.66},{41.63,72.55},{62.35,49.66},{49.4,45.51},{64.63,23.17},{49.82,64.44},{52.49,66.49},{52.81,66.18},{50.91,62.5},{45.13,75.19},{48.38,61.56},{65.06,49.95},{44.54,68.93},{43.81,72.6},{63.54,49.42},{52.73,48.37},{46.12,67.31},{53.08,76.06},{70.06,40.83},{60.55,47.51},{50.63,61.09},{51.26,81.79},{71.53,11.44},{51.72,57.95},{52,58.81},{51.18,55.45},{61.09,47.2},{46.13,62.5},{51.95,93.57},{50.49,60.96},{50.65,45.9},{46.18,65.66},{51.61,90.35},{51.52,90.56},{52.83,86.39},{51.99,86.55},{51.68,88.75},{51.43,90.79},{55.81,48.38},{49.79,71.04},{52.32,89.33},{49.32,41.81},{45.82,63.91},{43.18,62.65},{44.5,64.85},{52.66,68.01},{45.46,53.3},{45.1,52.63},{44.92,52.06},{40.99,65.07},{53.08,76.06},{47.09,81.09},{49.1,73.26},{51.05,74.16},{45.55,52.79},{45.85,48.38},{41.82,58.63},{42.15,59.99},{44.41,65.88},{49.07,92.7},{50.23,91.62},{52.92,93.17},{22.85,67.81},{40.43,76.9},{73.87,45.18},{75.14,44.39},{75.18,47.57},{67.26,53.01},{67.93,52.17},{66.23,48.96},{75.53,47.64},{75.09,47.33},{73.31,45.28},{73.29,45.54},{73.14,45.02},{73.11,45.5},{73.12,45.26},{73.31,45.02},{23.76,66.88},{20.78,62.42},{67.88,53.08},{75.74,43.47},{75,47.58},{73.86,45.54},{75.63,44.18},{72.66,36.34},{54.1,48.23},{47.95,73.35},{49.73,76.44},{53.6,91.94},{50.35,49.94},{71.05,44},{24.75,70.46},{73.49,43.52},{49.55,60.91},{50.42,64.79},{70.82,31.1},{40.98,77.84},{69.13,35.16},{41.84,58.38},{38.99,76.46},{62.67,49.84},{55.73,87.07},{57.5,50.47},{60.57,49.61},{70.84,46.21},{49.17,42.83},{48.47,46.23},{60.95,47.28},{71.47,48.71},{68.24,14.29}}},nil,1637,nil,nil,85,"H",nil,1},
[3297] = {'Sen\'jin Watcher',656,656,15,15,0,{[14]={{57.77,75.56},{57.21,74.96},{55.21,74.78},{56.61,74.55},{56.56,73.36},{56.34,76.09},{56.02,75.25},{57.13,77.27},{57.86,75.35},{55.55,73.5},{56.6,74.77},{57.27,74.86},{56.24,74.92},{56,74.46},{57.2,75.1}}},nil,14,nil,nil,877,"H",nil,0},
[3298] = {'Gabrielle Chase',3066,3066,53,53,0,{[46]={{72,65.19}}},nil,46,nil,nil,12,"A","Food & Drink",640},
[3300] = {'Adder',1,1,1,1,0,{[4]={{48.45,25.66},{61.54,39.36},{61.16,33.09},{44.79,38.69},{55.32,38.48},{64.27,34.68},{67.66,40.32},{45.37,86.99},{65.1,41.53},{48.93,82.42},{57.99,24.97},{64.76,27.22},{34.02,74.14},{49.02,36.42},{45.97,20.78},{66.13,78.22},{50.48,33.12}},[14]={{50.08,12.25},{50.97,13.8},{54.37,37.51},{54.29,30.15},{55.97,22.68},{38.41,29.25},{57.31,17.42},{46.47,33.83},{53.48,9.96},{55.73,32.18},{57.45,25.77},{53.26,17.81},{55.56,18.78},{54.8,14.05},{39.22,16.33},{40.59,16.23},{40.41,19.11},{55.73,16.73},{49.96,18.09},{36.25,25.86},{44.09,26.63},{44.13,29.87},{47.28,30.6},{47.4,22.42},{47.68,24.85},{51.88,32.58},{53.06,35.88},{53.04,29.83},{57.54,21.81},{54.52,30.04},{46.97,34.11},{53.01,19.3},{47.35,30.13},{51.93,32.25},{53.12,30.15},{46.26,47.58},{49.96,74.08},{53.51,50.53},{51.06,64.2},{52.09,58.53},{53.29,67.48},{51.24,48.22},{46.81,33.95},{48.21,44.97},{54.13,70.69},{52.79,81.18},{45.16,62.21},{46.07,66.61},{50.55,72},{57.74,57.47},{44.1,65.82},{44.37,64.5},{40.31,61.53},{56.07,57.63},{55.6,69.01},{55.26,72.63},{50.04,39.93},{54.18,63.31},{50.72,45.8},{53.75,53.73},{53.91,65.81},{55.35,48.3},{50.81,67.84},{52.24,65.24},{41.61,71.92},{46.69,22.53},{47.75,25.23},{51.82,31.98},{47.58,47.66},{53.4,48.04},{53.33,36.16},{52.07,39.1},{52.32,37.43},{47.38,12.22}},[17]={{69.88,60.66},{68.41,57.84},{63.29,44.99},{63.05,53.32},{64.88,55.31},{61.4,44.48},{59.85,39.69},{67.84,55.55},{52.08,47.43},{59.11,46.09},{52.03,36.7},{55.57,56.67},{62.75,52.05},{56.08,48.31},{64.23,55.59},{47.96,53.7},{55.92,46.09},{48.73,50.12},{51.93,66.41},{61.54,66.16},{56.97,62.72},{50.3,68.62},{64.56,66.03},{59.34,65.67},{54.91,66.88},{62.9,37.03},{52.44,35.29},{40.1,56.76},{60.06,36.35},{38.16,37.52},{45.36,32.67},{51.8,37.87},{32.26,32.34},{41.55,49.44},{38.13,57.42},{48.69,36.16},{42.64,28.47},{31.7,42.49},{58.72,33.62},{35.02,38.04},{54.32,33.95},{33.75,39.88},{57.14,33.08},{47.02,31.51},{39.82,58.15},{35.43,36.78},{52.79,32.54},{47.2,30.96},{38.56,52.2},{28.95,43.67},{29.23,44.92},{47.31,31.16},{44.68,30.88},{28.86,40.94},{62.9,36.28},{58.11,13.86},{60.91,27.59},{65.13,28.68},{62.89,21.15},{56.54,13.62},{59.84,27.75},{54.42,20.05},{54.45,19.66},{58.85,22.86},{47.3,31.22},{54.32,29.39},{55.64,23.84},{50.26,29.51},{55.4,27.82},{49.17,27.75},{46.83,31.19},{52.03,27.36},{47.51,30.88},{53.7,22.9},{59.53,40.07},{46.91,66.87},{52.89,66.76},{53.15,69.46},{53.98,85.03},{57.51,90.4},{58.05,87.48},{64.43,79.29},{50.11,81.68},{66.06,83.18},{58.86,65.56},{55.82,73.44},{55.42,87.81},{57.93,88.08},{47.96,81.27},{54.85,66.49},{63.67,78.3},{59.85,82.16},{53.51,77.54}},[3483]={{40.55,68.71},{54.16,72.07},{55.46,29.84},{55.48,29.71},{61.72,72.41},{60.4,80.06},{70.21,65.7},{54.13,46.03},{59.77,41.69},{43.02,45.62},{26.25,65.52},{30.29,49.49},{33.71,34.85},{34.09,35.31},{27.39,39.69},{25.35,45.79},{28.94,79.58},{24.63,70.53}},[3518]={{40.84,53.92},{40.63,54.01},{40.28,53.76},{37.17,58.33},{35.85,82.15},{35.63,82.38},{35.84,82.46},{29.79,81.13},{27.69,74.27},{27.99,77.16},{29.16,61.42},{30.83,36.02},{30.52,36.07},{32.87,32.53},{33.07,32.6},{35.99,32.47},{37.03,24.33},{47.87,27.42},{72.45,40.09},{64.33,48.52},{67.13,51.49},{67.23,62.28},{67.04,52.58},{70,52.76},{70.92,49.45},{70.2,53.17},{71.08,49.45},{69.07,72.86},{67.26,75.48},{66.97,75.16},{63.51,79.91},{61.85,80.94},{60.32,76.44},{59.46,81.17},{60.13,76.15},{59.36,81.04},{67.23,75.37}},[3716]={{-1,-1}},[3717]={{-1,-1}},[3791]={{-1,-1}},[3792]={{-1,-1}},[4709]={{41.06,49.01},{39.55,5.71},{40.98,38.24},{41.31,53.67},{48.19,53.41},{40.36,23.35},{43.69,56.46},{46.42,79.21},{49.88,80.63},{45.97,62.75},{51.03,47.21},{44.97,82},{44.48,59.26},{53.12,38.67},{45.58,55.71},{41.9,82.81},{42.72,53.08},{48.65,54.42},{47.79,43.45},{45.87,35.13},{44.12,42.9},{42.28,79.46},{39.38,33.34},{47.82,74.64},{43.18,52.88},{39.7,80.89},{49.64,76.88},{48.39,54.49},{49.45,56.73},{43.26,86.75},{45.88,54.42},{44.21,55},{44.61,80.37},{34.23,8.83},{41.53,19.88},{52.91,35.27},{46.95,82.02},{42.05,53.96},{50.25,76.06},{37.68,11.96},{44.47,56.5},{48.99,79.88},{45.4,47.68},{53.64,48.72},{64.55,43.53},{47.21,47.6},{47.51,47.57},{39.69,15.35},{46.04,41.08},{46.01,43.54},{41.22,23.72},{42.01,24.79},{45.42,40.3},{58.64,40.89},{58.14,41.31},{57.82,43.66},{45.04,43.6},{46.04,45.4},{41.12,20.83},{46.37,44.87},{40.12,38.1},{40.34,18},{44.87,42.57},{37.34,16.87},{40.28,23.49},{34.28,9.27}}},nil,17,nil,nil,7,"AH",nil,0},
[3301] = {'Morgan Ladimore',64,64,35,35,0,{[10]={{17.77,28.95}}},nil,10,nil,nil,123,"A",nil,0},
[3304] = {'Master Vornal',222,222,11,11,0,{[14]={{55.94,74.39}}},nil,14,nil,{818,820},126,"H",nil,0},
[3305] = {'Grisha',232470,232470,85,85,1,{[51]={{34.84,30.88}}},nil,51,nil,nil,29,"H","Wind Rider Master",8193},
[3306] = {'Keldas',1753,1753,40,40,0,{[141]={{56.38,52.23}}},nil,141,nil,nil,80,"A","Pet Trainer",1},
[3309] = {'Karus',5544,5544,45,45,0,nil,nil,0,nil,nil,29,"H","Banker",131075},
[3310] = {'Doras',232470,232470,85,85,1,{[1637]={{49.66,59.22}}},nil,1637,{6386,26804},{6385,26803},29,"H","Wind Rider Master",8195},
[3312] = {'Olvia',2769,2769,50,50,0,{[1637]={{50.69,72.15}}},nil,1637,nil,nil,29,"H","Meat Vendor",640},
[3313] = {'Trak\'gen',1003,1003,30,30,0,{[1637]={{53.84,82.6}}},nil,1637,nil,nil,29,"H","General Goods",640},
[3314] = {'Urtharo',1003,1003,30,30,0,{[1637]={{46.59,73.04}}},nil,1637,nil,nil,29,"H","Weapon Merchant",4225},
[3315] = {'Tor\'phan',1003,1003,30,30,0,{[1637]={{60.92,59.97}}},nil,1637,nil,nil,29,"H","Cloth & Leather Armor Merchant",4224},
[3316] = {'Handor',1003,1003,30,30,0,{[1637]={{60.89,53.73}}},nil,1637,nil,nil,29,"H","Cloth & Leather Armor Merchant",4224},
[3317] = {'Ollanus',1003,1003,30,30,0,{[1637]={{60.75,57.94}}},nil,1637,nil,nil,29,"H","Cloth Armor Merchant",4224},
[3318] = {'Koma',5544,5544,45,45,0,nil,nil,0,nil,nil,29,"H","Banker",131073},
[3319] = {'Sana',1003,1003,30,30,0,{[1637]={{44.99,77.87}}},nil,1637,nil,nil,29,"H","Mail Armor Merchant",4224},
[3320] = {'Soran',5544,5544,45,45,0,nil,nil,0,nil,nil,29,"H","Banker",131073},
[3321] = {'Morgum',1003,1003,30,30,0,{[1637]={{60.15,55.77}}},nil,1637,nil,nil,29,"H","Leather Armor Merchant",4224},
[3322] = {'Kaja',1003,1003,30,30,0,{[1637]={{40.87,49.86}}},nil,1637,nil,nil,29,"H","Bow & Rifle Vendor",4225},
[3323] = {'Horthus',1003,1003,30,30,0,{[1637]={{50.38,70.14}}},nil,1637,nil,nil,29,"H","Reagents",2176},
[3324] = {'Grol\'dar',2769,2769,50,50,0,{[1637]={{48.72,55.43}}},nil,1637,nil,nil,29,"H","Warlock Trainer",49},
[3325] = {'Mirket',1905,1905,40,40,0,{[1637]={{49.16,56.05}}},nil,1637,nil,nil,29,"H","Warlock Trainer",49},
[3326] = {'Zevrost',3815,3815,60,60,0,{[1637]={{49.12,55.01}}},nil,1637,{27402,28459},nil,29,"H","Warlock Trainer",51},
[3327] = {'Gest',1753,1753,40,40,0,{[1637]={{44.5,61.18}}},nil,1637,nil,nil,29,"H","Rogue Trainer",49},
[3328] = {'Ormok',2769,2769,50,50,0,{[1637]={{44.36,61.59}}},nil,1637,nil,nil,29,"H","Rogue Trainer",49},
[3329] = {'Kor\'jus',1003,1003,30,30,0,{[1637]={{49.69,61.83}}},nil,1637,nil,nil,29,"H","Mushroom Vendor",640},
[3330] = {'Muragus',1003,1003,30,30,0,{[1637]={{45.84,57.04}}},nil,1637,nil,nil,29,"H","Staff Merchant",4224},
[3331] = {'Kareth',1003,1003,30,30,0,{[1637]={{47.03,63.23}}},nil,1637,nil,nil,29,"H","Blade Merchant",4224},
[3332] = {'Lumak',1342,1342,35,35,0,{[1637]={{66.44,41.93}}},nil,1637,{6608},nil,29,"H","Fishing Trainer",83},
[3333] = {'Shankys',1003,1003,30,30,0,{[1637]={{66.75,41.85}}},nil,1637,nil,nil,29,"H","Fishing Supplies",128},
[3334] = {'Rekkul',1003,1003,30,30,0,{[1637]={{43.96,58.28}}},nil,1637,nil,nil,29,"H","Poison Supplies",1152},
[3335] = {'Hagrus',1003,1003,30,30,0,{[1637]={{47.01,55.24}}},nil,1637,nil,nil,29,"H","Reagents",2176},
[3336] = {'Takrin Pathseeker',1003,1003,30,30,0,{[14]={{50.84,43.59}}},nil,14,{840},nil,29,"H",nil,2},
[3337] = {'Kargal Battlescar',328,328,15,15,0,{[17]={{67.66,39.39}}},nil,17,{871,872},{840,871,872,26642,28494},29,"H",nil,2},
[3338] = {'Sergra Darkthorn',61040,61040,60,60,1,{[17]={{49.99,59.85}}},nil,17,{844,845,881,903,905,13991},{842,845,860,881,903,905},125,"H",nil,2},
[3339] = {'Captain Thalo\'thas Brightsun',713,713,25,25,0,{[17]={{67.72,74}}},nil,17,{891},{891,898},69,"AH",nil,2},
[3340] = {'Mandrik Wife',5000,5000,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3341] = {'Gann Stonespire',1277,1277,36,36,0,{[4709]={{49.22,82.38}}},{[17]={{{45.89,77.03},{45.89,77.03},{45.94,76.84},{46.05,76.52},{46.07,76.43},{46.08,76.01},{46.09,75.81},{46.11,75.62},{46.14,75.37},{46.14,75.37},{46.1,75.69},{46.1,75.89},{46.09,76.1},{46.07,76.39},{46.03,76.62},{45.9,76.95},{45.84,77.24},{45.8,77.81},{45.8,78.22},{45.82,78.51},{45.86,78.76},{45.97,78.99},{46.05,79.16},{46.13,79.37},{46.15,79.57},{46.13,79.96},{46.11,80.17},{46.1,80.37},{46.12,80.79},{46.12,80.99},{46.12,81.2},{46.11,81.41},{46.12,81.62},{46.11,82.03},{46.09,82.38},{46.1,82.59},{46.11,82.8},{46.12,83.21},{46.12,83.42},{46.12,83.62},{46.07,84.19},{45.98,84.38},{45.9,84.54},{45.74,84.88},{45.68,84.98},{45.75,84.8},{45.93,84.48},{46.04,84.24},{46.1,84},{46.12,83.61},{46.12,83.29},{46.12,83.09},{46.1,82.67},{46.1,82.48},{46.11,82.27},{46.13,81.88},{46.13,81.67},{46.12,81.46},{46.12,81.05},{46.12,81.05},{46.11,80.54},{46.11,80.33},{46.12,80.13},{46.14,79.69},{46.14,79.48},{46.08,79.19},{46,79.02},{45.92,78.85},{45.82,78.61},{45.79,78.16},{45.79,77.95},{45.8,77.46},{45.83,77.22}}}},4709,{24684},{843,846,849,24632,24747},104,"H",nil,3},
[3342] = {'Shan\'ti',1342,1342,35,35,0,{[1637]={{50.58,74.05}}},nil,1637,nil,nil,29,"H","Fruit Vendor",640},
[3343] = {'Grelkor',104325,104325,60,60,0,{[2597]={{-1,-1}}},nil,2597,nil,nil,1215,"H","Blacksmithing Supplies",4224},
[3344] = {'Kardris Dreamseeker',4120,4120,60,60,0,{[1637]={{38.93,47.27}}},nil,1637,{27397,28465},nil,29,"H","Shaman Trainer",51},
[3345] = {'Godan',1342,1342,35,35,0,{[1637]={{53.49,49.56}}},nil,1637,nil,{27400,27402,27435,27436,27437,27439,27441},29,"H","Enchanting Trainer",83},
[3346] = {'Kithas',1342,1342,35,35,0,{[1637]={{53.34,48.94}}},nil,1637,nil,nil,29,"H","Enchanting Supplies",128},
[3347] = {'Yelmak',1342,1342,35,35,0,{[1637]={{54.87,45.13}}},nil,1637,{29067,29481,29482},{29067,29481,29482},29,"H","Alchemy Trainer",83},
[3348] = {'Kor\'geld',1003,1003,33,34,0,{[1637]={{55.24,45.84}}},nil,1637,nil,nil,29,"H","Alchemy Supplies",128},
[3349] = {'Ukra\'nor',1003,1003,30,30,0,nil,nil,0,nil,nil,29,"H","Staff Merchant",4224},
[3350] = {'Asoran',1003,1003,30,30,0,{[1637]={{57.09,46.95}}},nil,1637,nil,nil,29,"H","General Goods",640},
[3351] = {'Magenius',1003,1003,30,30,0,{[1637]={{57.19,46.49}}},nil,1637,nil,nil,29,"H","Reagents",2176},
[3352] = {'Ormak Grimshot',4120,4120,60,60,0,{[1637]={{63.83,32.75}}},nil,1637,{27395,28461},{6081,27278,28297,28461},29,"H","Hunter Trainer",51},
[3353] = {'Grezz Ragefist',4120,4120,60,60,0,{[1637]={{73.84,45.64}}},nil,1637,{27365,28457},{27281,28290,28457},29,"H","Warrior Trainer",51},
[3354] = {'Sorek',2769,2769,50,50,0,{[1637]={{73.88,45.09}}},nil,1637,nil,nil,29,"H","Warrior Trainer",49},
[3355] = {'Saru Steelfury',2218,2218,45,45,0,{[1637]={{76.51,34.52}}},nil,1637,nil,{27365,27395,27396,27397,27403,27434},29,"H","Blacksmithing Trainer",83},
[3356] = {'Sumi',1003,1003,30,30,0,{[1637]={{75.99,35.43}}},nil,1637,nil,nil,29,"H","Blacksmithing Supplies",4224},
[3357] = {'Makaru',1342,1342,35,35,0,{[1637]={{72.31,34.9}}},nil,1637,nil,nil,29,"H","Mining Trainer",81},
[3358] = {'Gorina',1003,1003,30,30,0,{[1637]={{72.62,34.42}}},nil,1637,nil,nil,29,"H","Mining Supplies",128},
[3359] = {'Kiro',1003,1003,30,30,0,{[1637]={{66.85,50.74}}},nil,1637,nil,nil,29,"H","War Harness Maker",4224},
[3360] = {'Koru',1003,1003,30,30,0,{[1637]={{76.38,37.82}}},nil,1637,nil,nil,29,"H","Mace & Staves Vendor",4224},
[3361] = {'Shoma',1003,1003,30,30,0,{[1637]={{76.15,38.02}}},nil,1637,nil,nil,29,"H","Weapon Vendor",4224},
[3362] = {'Ogunaro Wolfrunner',2218,2218,45,45,0,{[1637]={{60.98,35.32}}},nil,1637,nil,nil,29,"H","Kennel Master",131},
[3363] = {'Magar',1342,1342,35,35,0,{[1637]={{60.75,59.13}}},nil,1637,nil,nil,29,"H","Tailoring Trainer",81},
[3364] = {'Borya',1003,1003,30,30,0,{[1637]={{60.75,58.61}}},nil,1637,nil,nil,29,"H","Tailoring Supplies",128},
[3365] = {'Karolek',1342,1342,35,35,0,{[1637]={{60.9,54.89}}},nil,1637,nil,nil,29,"H","Leatherworking Trainer",81},
[3366] = {'Tamar',1003,1003,30,30,0,{[1637]={{60.34,54.3}}},nil,1637,nil,nil,29,"H","Leatherworking Supplies",128},
[3367] = {'Felika',1003,1003,30,30,0,{[1637]={{56.62,50.91}}},{[1637]={{{60.62,50.34},{60.71,52.34},{60.4,54.34},{59.38,56.14},{58.02,58.23},{56.89,58.3},{55.16,57.51},{54.01,57.03},{52.88,57.19},{52.06,57.98},{51.44,58.53},{50.83,58.73},{51.33,57.82},{51.9,57.4},{52.62,57.05},{53.71,56.81},{55.2,57.56},{56.5,58.54},{57.98,57.71},{59.31,56.34},{60.39,54.16},{60.51,51.35},{60.35,48.34},{61.09,45.98},{60.62,43.4},{60.36,41.01},{60.03,40.58},{59.14,39.42},{57.52,37.83},{55.53,36.27},{53.95,35.4},{52.04,35.63},{49.82,36.13},{49.08,36.26},{48.34,36.39},{46.51,36.62},{48.22,36.38},{48.96,36.23},{49.7,36.09},{50.52,35.94},{51.26,35.8},{53.33,35.55},{55.45,36.17},{57.24,38.16},{57.4,39.71},{56.75,41.34},{57.11,42.79},{57.42,43.81},{58.63,45.69},{59.29,47.25},{60.63,48.28}}}},1637,nil,nil,29,"H","Trade Supplies",128},
[3368] = {'Borstan',1003,1003,30,30,0,{[1637]={{56.56,61.49}}},nil,1637,nil,nil,29,"H","Meat Vendor",640},
[3369] = {'Gotri',1003,1003,30,30,0,{[1637]={{57.44,61.04}}},nil,1637,nil,nil,29,"H","Bag Vendor",128},
[3370] = {'Urtrun Clanbringer',2218,2218,45,45,0,{[1637]={{48.91,76.15}}},nil,1637,nil,nil,29,"H","Guild Master",786433},
[3371] = {'Tamaro',1003,1003,30,30,0,{[1637]={{55.72,55.34}}},nil,1637,nil,nil,29,"H",nil,0},
[3372] = {'Sarlek',1003,1003,30,30,0,{[1637]={{55.55,55.27}}},nil,1637,nil,nil,29,"H",nil,0},
[3373] = {'Arnok',1342,1342,35,35,0,nil,nil,0,nil,nil,29,"H","First Aid Trainer",83},
[3374] = {'Bael\'dun Excavator',1132,1132,32,33,0,{[4709]={{48.59,88.31},{48.39,88.83},{46.92,87.12},{48.59,89.13},{48.2,89.13},{48.31,89.03},{47.9,86.72},{47.76,88.37},{48.37,88.07},{48.1,87.8},{48.29,87.69},{47.57,87.23},{47.05,87.06},{47.06,87.13},{47.03,87.22},{47.35,86.91},{47.2,87.58},{47.36,86.81}}},nil,4709,nil,nil,122,"A",nil,1},
[3375] = {'Bael\'dun Foreman',1163,1163,33,34,0,{[4709]={{48.41,88.69},{48.72,89.05},{47.77,88.38},{48.29,88.12},{48.29,88.14},{48.31,88.11},{47.06,87.16},{47.86,88.27},{47.34,86.83},{49.05,89.55}}},nil,4709,nil,nil,122,"A",nil,0},
[3376] = {'Bael\'dun Soldier',1244,1244,34,35,0,{[4709]={{50.82,86.07},{50.81,86.12},{50.86,86.23},{50.66,85.79},{49.59,87.45},{49.63,86.82},{49.71,87.1},{50.37,86.47},{50.83,85.98},{49.07,86.53},{48.81,85.32},{50.28,86.63},{50.26,87.11},{50.91,86.26},{50.48,86.93}}},nil,4709,nil,nil,122,"A",nil,0},
[3377] = {'Bael\'dun Rifleman',1244,1244,34,35,0,{[4709]={{50.38,86.91},{50.64,86.78},{50.42,85.94},{49.76,86.35},{49.99,87.64},{49.61,85.51},{49.74,85.04},{49.95,86.82},{50.52,86.8},{50.53,86.37},{48.85,87.25}}},nil,4709,nil,nil,122,"A",nil,0},
[3378] = {'Bael\'dun Officer',1281,1281,35,35,0,{[4709]={{50.73,85.78},{50.92,86.5},{50.1,86.23},{50.24,86.09},{49.4,86.68},{50.35,86.24},{50.38,86.5}}},nil,4709,nil,nil,122,"A",nil,0},
[3379] = {'Burning Blade Bruiser',356,356,16,18,0,{[17]={{41.9,36.68},{42.32,33.08},{42.13,37.07},{43.15,38.23},{42.28,37.2},{41.06,38.82},{42.11,36.72},{41.11,38.05},{42.88,31.83},{41.78,36.97},{42.44,36.97},{41.4,38.78},{41.25,33.83},{40.74,33.08},{41.74,31.56},{42.63,38.43},{43.35,38.64},{41.43,39.46},{41.68,39.04},{42.25,38.96},{42,38.99},{42.33,31.6},{42.64,38.43}}},nil,17,nil,nil,554,nil,nil,0},
[3380] = {'Burning Blade Acolyte',330,330,16,18,0,{[17]={{42.21,36.99},{41.59,37.11},{43.03,32.42},{42.31,36.71},{41.33,39.19},{41.94,36.97},{41.77,32.37},{43.16,38.05},{41.63,39.45},{41.69,38.69},{41.88,38.28},{41.98,39.51},{40.61,33.09},{42.58,38.74},{43.33,38.69},{42.77,39.27},{42.38,32.26}}},nil,17,nil,nil,554,nil,nil,0},
[3381] = {'Southsea Brigand',247,273,12,13,0,nil,nil,0,nil,nil,230,nil,nil,0},
[3382] = {'Southsea Cannoneer',300,300,14,15,0,{[17]={{70.03,85.54},{79.87,91.32},{79.83,91.47},{79.75,90.89},{79.63,91.32}}},nil,17,nil,nil,190,"AH",nil,0},
[3383] = {'Southsea Cutthroat',295,295,14,14,0,{[17]={{70.08,85.02},{70.09,84.99},{79.73,91},{79.77,91.37},{76.89,91.24},{76.88,91.38},{76.61,90.62},{77.11,90.4},{78.02,88.61},{77.61,90.1},{77.85,90.62},{77.48,89.28},{76.04,89.33},{77.76,89.49},{77.71,89.52},{77.14,90.11},{75.6,89.58},{75.65,89.65},{76.45,90.16},{77.77,88.19},{75.25,89.75},{75.65,89.67},{76.25,90.15},{76.9,91.22},{76.87,91.27}}},nil,17,nil,nil,190,"AH",nil,0},
[3384] = {'Southsea Privateer',328,328,14,15,0,{[17]={{79.74,90.38},{79.85,90.69},{76.54,89.71},{76.94,90.29},{78.14,91.08},{77.92,89.46},{77.41,90.96},{77.18,89.13},{76.99,89.09},{75.91,89.76},{76.13,90.06},{77.38,90.85}}},nil,17,nil,nil,230,nil,nil,0},
[3385] = {'Theramore Marine',328,328,15,16,0,{[17]={{68.89,82.75},{70.38,90.97},{71.26,90.96},{70.62,90.1},{69.92,81.51},{69.4,81.8},{69.74,81.83},{69.38,83.13},{70.07,83.11},{71.5,82.85},{71.1,84.2},{71.39,83.77},{71,81.52},{70.94,84.72},{70.43,84.95},{70.12,81.04},{70.01,86.46},{71.23,88.33},{70.97,85.6},{70.57,89.47},{69.7,85.81},{70.69,88.23},{70.16,90.39},{70.97,91.02},{70.08,90.09},{71.44,86.36},{69.36,83.13},{71.32,83.78},{70.39,85.47},{70.5,90.04}}},nil,17,nil,nil,1077,"A",nil,0},
[3386] = {'Theramore Preserver',350,350,16,17,0,{[17]={{70.44,89.7},{69.72,82.42},{70.88,89.97},{70.12,83.72},{71.53,84.17},{70.54,89.31},{70,86.58},{70.83,90.82},{70.01,90.09},{71.29,83.83},{70.84,86.71},{70.5,90.13}}},nil,17,nil,nil,1077,"A",nil,0},
[3387] = {'Jorn Skyseer',1279,1279,34,34,0,{[4709]={{41.52,47.19}}},nil,4709,{24552},{882,883,884,885,897,904,907,913,3261,24552},83,"H",nil,3},
[3388] = {'Mahren Skyseer',1163,1163,32,32,0,{[17]={{73.97,82.51}}},nil,17,nil,{873,874},35,"AH",nil,0},
[3389] = {'Regthar Deathgate',896,896,28,28,0,{[17]={{37.84,55.27}}},nil,17,{850,851,852,855,4021},{852,855,1361,4021,14073},125,"H",nil,3},
[3390] = {'Apothecary Helbrim',573,573,22,22,0,{[17]={{48.59,58.33}}},nil,17,{848,13998,13999},{848,1358,13998},68,"H",nil,2},
[3391] = {'Gazlowe',4120,4120,60,60,0,{[17]={{68.41,69.06}}},nil,17,{887,14034,14038,14042,14045,14050,26701,26702,26769},{888,892,895,1178,14034,14038,14042,14049,14050,26596,26696},69,"AH",nil,2},
[3392] = {'Prospector Khazgorm',600,600,24,24,0,nil,nil,0,nil,nil,1926,"A","Explorers' League",4224},
[3393] = {'Captain Fairmount',484,484,20,20,0,nil,nil,0,nil,nil,1077,"A",nil,0},
[3394] = {'Barak Kodobane',300,300,14,14,0,{[17]={{33.35,46.7}}},{[17]={{{42.81,23.52},{42.86,23.49},{42.96,23.48},{42.87,23.48},{42.82,23.5},{42.75,23.59},{42.66,23.73},{42.5,24.05},{42.59,23.9},{42.65,23.76},{42.73,23.61},{42.8,23.5}}}},17,nil,nil,16,nil,nil,0},
[3395] = {'Verog the Dervish',356,356,16,16,0,{[17]={{52.25,77.97}}},nil,17,nil,nil,16,nil,nil,0},
[3396] = {'Hezrul Bloodmark',449,449,19,19,0,{[17]={{38.41,72.45}}},{[17]={{{45.88,40.83},{45.62,40.29},{45.25,39.68},{45.09,39.42},{44.99,39.08},{45.1,38.68},{45.28,38.51},{45.52,38.3},{45.8,37.88},{45.85,37.39},{45.97,37.14},{46.15,37.01},{46.28,36.91},{46.47,37.13},{46.63,37.48},{46.65,37.76},{46.74,38.33},{46.9,38.61},{47.27,39.08},{47.82,39.44},{48.24,39.58},{48.51,39.84},{48.56,40.41},{48.36,40.71},{47.97,40.97},{47.38,41.5},{47.01,41.88},{46.75,42.06},{46.48,41.91},{46.24,41.66},{46.04,41.14}}}},17,nil,nil,16,nil,nil,0},
[3397] = {'Kolkar Bloodcharger',256,256,14,15,0,{[17]={{57.13,79.08},{58.65,77.52},{53.96,87.95},{55.79,75.94},{57.96,81.71},{53.5,77.45},{52.59,80.88},{57.27,79.8},{55.5,82.61},{54.08,87.55},{56.56,82.54},{54.27,80.78},{54.58,76.18},{51.34,79.79},{52,79.09},{52.19,77.19},{52.2,76.67},{58.1,82.12},{57.3,80.86},{57.67,82.29},{56.39,86.06},{51.21,84.27},{56.48,86.22},{51.5,83.85},{51.1,83.66},{52.99,80.95}}},nil,17,nil,nil,130,nil,nil,0},
[3398] = {'Gesharahan',492,492,15,15,4,{[17]={{39.51,75.08},{39.86,74.95}}},nil,17,nil,nil,16,nil,nil,0},
[3399] = {'Zamja',1342,1342,35,35,0,{[1637]={{32.24,69.66}}},nil,1637,{6611},nil,126,"H","Cooking Trainer",83},
[3400] = {'Xen\'to',1003,1003,30,30,0,{[1637]={{32.15,69.15}}},nil,1637,nil,nil,126,"H","Cooking Supplies",128},
[3401] = {'Shenthul',4120,4120,60,60,0,nil,nil,0,nil,{2378,2380,2460,2478,10794},126,"H","Rogue Trainer",35},
[3402] = {'Zando\'zan',1342,1342,35,35,0,nil,nil,0,nil,{2379},126,"H",nil,2},
[3403] = {'Sian\'tsu',1753,1753,40,40,0,{[1637]={{39.05,47.71}}},nil,1637,nil,nil,29,"H","Shaman Trainer",49},
[3404] = {'Jandi',1342,1342,35,35,0,{[1637]={{34.83,62.84}}},nil,1637,nil,nil,126,"H","Herbalism Trainer",81},
[3405] = {'Zeal\'aya',1003,1003,30,30,0,{[1637]={{34.84,63.21}}},nil,1637,nil,nil,126,"H","Reagents & Poisons",3200},
[3406] = {'Xor\'juul',2769,2769,50,50,0,nil,nil,0,nil,nil,29,"H","Hunter Trainer",49},
[3407] = {'Sian\'dur',1753,1753,40,40,0,nil,nil,0,nil,nil,29,"H","Hunter Trainer",49},
[3408] = {'Zel\'mak',1753,1753,40,40,0,nil,nil,0,nil,nil,29,"H","Warrior Trainer",49},
[3409] = {'Zendo\'jian',1003,1003,30,30,0,{[1637]={{75.09,36.14}}},nil,1637,nil,nil,29,"H","Weapon Vendor",4224},
[3410] = {'Jin\'sora',1003,1003,30,30,0,nil,nil,0,nil,nil,29,"H","Bow Merchant",4480},
[3411] = {'Denni\'ka',713,713,25,25,0,{[406]={{72.05,91.2}}},nil,406,{26064},{26064},126,"H","Butcher",643},
[3412] = {'Nogg',1342,1342,35,35,0,{[1637]={{56.28,56.36},{56.74,57.02}}},nil,1637,{2950},{2841,2949,2950},29,"H","Apprentice Engineer",3},
[3413] = {'Sovik',1003,1003,30,30,0,{[1637]={{56.75,56.26}}},nil,1637,nil,nil,29,"H","Engineering Supplies",129},
[3414] = {'General Twinbraid (Deprecated in 4.x)',1003,1003,30,30,0,nil,nil,0,nil,nil,122,"A",nil,0},
[3415] = {'Savannah Huntress',222,222,11,12,0,{[17]={{48.36,51.4},{47.28,46.87},{55.04,57.29},{53.07,53.28},{54.42,55.82},{54.9,58.25},{51.91,54.59},{53.75,57.36},{49.14,50.46},{49.13,51.02},{49.59,51.58},{49.28,51.43},{55.24,59.35},{55.49,59.7},{54.67,60.05},{51.77,61.7},{46.49,46.47},{46.69,46.66},{48.36,47.52},{44.33,46.07},{43.79,46.65},{43.15,49.63},{53.96,59.04},{47.88,44.96},{46.18,45.31},{54.3,46.27},{46.56,45.78},{44.73,52.93},{43.86,47.1},{46.14,54.64},{42.36,50.57},{45.21,53.85},{44.35,53.11},{47.84,52.79},{44.9,52.63},{43.87,52.92},{52.93,59.91},{54.09,60.43},{54.25,59.6},{54.45,58.91},{53.64,58.18},{52.55,56.48},{57.22,66.83},{56.61,65.07},{50.3,68.67},{51.48,63.3},{52.02,65.32},{52.75,66.16},{54.47,67.72},{46.13,68.6},{52.63,68.37},{46.72,66.79},{51.8,63.57},{47.24,65.07},{47.76,66.96},{46.63,64.61},{46.21,64.2},{45.41,73.2},{44.34,69.89},{45.63,32.13},{45.54,31.37},{44.85,34.34},{47.8,41},{46.43,32.47},{48.1,41.83},{46.03,32.44},{39.61,57.73},{40.58,50.02},{42.15,30.23},{48.93,40.55},{41.98,51.58},{48.28,42.98},{49.12,37.58},{45.65,34.3},{45.39,32.64},{46.3,33.95},{45.01,33.22},{46.8,32.6},{36.86,64.26},{33.4,51.3},{37.34,60.78},{46.02,69.62},{34.01,51.85},{35.39,55.6},{36.11,50.98},{42.11,71.18},{42.4,52.24},{49.04,41.65},{46.79,66.89},{46.12,73.78},{51.96,71.95},{57.54,66.69},{51.91,72.2},{47.01,65.32},{52.61,67.67},{54.21,68.43},{52.74,68.62},{48.66,71.8}}},nil,17,nil,nil,16,nil,nil,0},
[3416] = {'Savannah Matriarch',417,417,17,18,0,{[17]={{66.71,63.46},{67.08,62.16},{66.71,63.46},{68.09,64.27},{66.68,62.35},{66,65.83},{67.34,62.39},{66.98,64.07},{63.15,61.62},{67.51,63.36},{64.27,64.14},{67.07,62.16},{66.72,63.48},{68.32,64.44},{66.69,62.35},{65.9,65.73},{67.36,62.41},{66.98,64.04},{67.52,63.37}}},nil,17,nil,nil,16,nil,nil,0},
[3417] = {'Living Flame',70,76,16,17,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3418] = {'Kirge Sternhorn',573,573,22,22,0,{[4709]={{41.62,46.51}}},nil,4709,{24546},{24543,24546},104,"H",nil,3},
[3419] = {'Apothecary Zamah',573,573,22,22,0,{[1638]={{22.81,20.89}}},nil,1638,nil,{853,962,1064,1067,1086},68,"H","Royal Apothecary Society",0},
[3421] = {'Feegly the Exiled (Old)',617,617,23,23,0,nil,nil,0,nil,{857},29,"H",nil,0},
[3424] = {'Thunderhawk Cloudscraper',442,508,20,22,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3425] = {'Savannah Prowler',328,328,14,15,0,{[17]={{63.13,65.89},{63.09,66.32},{63.13,66.81},{61.36,67.73},{61.22,68.44},{61.68,67.09},{61.74,67.65},{61.91,69.5},{61.37,68.34},{61.68,68.1},{61.2,70.17},{61.42,70.48},{61.33,69.36},{62.01,70.61},{61.71,71.09},{61.66,70.47},{61.49,69.76},{61.77,69.51},{63.47,66.58},{63.44,67.05},{28.91,41.38},{53.51,32.33},{53.1,32.61},{52.55,32.85},{54.83,31.9},{51.62,32.51},{53.09,32},{51.6,33.16},{52.15,32.28},{52.67,32.12},{51.86,33.58},{52.32,33.26},{30,41.92},{29.52,41.55},{30.1,43.06},{55.93,33.94},{30.17,42.62},{29.58,42.15},{28.96,41.66},{56.31,33.66},{55.72,32.9},{29.17,40.75},{30.22,42.24},{30.7,48.03},{30.46,48.31},{29.35,45.44},{35.77,62.99},{30.55,42.79},{29.79,45.47},{36.16,60.62},{56.1,33.26},{29.46,44.86},{68.99,17.35},{69.92,16.78},{70.08,13.99},{67.1,19.78},{52.89,30.02},{54.05,30.78},{53.45,31.77},{53.95,31.48},{51.85,31.87},{53.11,32.01},{52.67,32.1},{51.38,32.04},{53.09,28.94},{52.64,29.07},{62.33,77.48},{62.88,77.29},{60.52,77.62},{62.51,77.16},{61.18,77.59},{60.38,76.58},{60.91,77.8},{62.77,77.82},{59.68,74.96},{60.34,76.27},{62.48,77.88},{60.8,78.33},{59.42,74.35},{60.72,77.15},{59.69,74.45},{61.19,77.08},{61.2,70.17},{62.03,70.61},{61.66,70.45},{61.72,71.1},{61.3,69.34},{61.49,69.75},{61.42,70.47},{61.36,67.73},{61.36,68.33}},[4709]={{42.99,16.51},{42.93,16.26}}},nil,17,nil,nil,16,nil,nil,0},
[3426] = {'Zhevra Charger',417,417,17,17,0,{[17]={{62.5,19.49},{35.35,29.53},{36.93,28.24},{34.49,33},{35.18,30.71},{32.87,31.36},{37.43,31.12},{53.04,89.09},{58.32,88.63},{57.88,89.39},{56.61,88.8},{52.71,88.18}},[4709]={{59.44,37.89},{43.27,30.07}}},nil,17,nil,nil,189,"AH",nil,0},
[3428] = {'Korran',247,247,12,12,0,{[17]={{47.93,57.41}}},nil,17,nil,{868,1148},126,"H",nil,0},
[3429] = {'Thork',1981,1981,42,42,0,{[17]={{48.69,59.61}}},nil,17,{872,14073,28876,29109},{854,906,13975,29095},29,"H",nil,3},
[3430] = {'Mangletooth',386,386,17,17,0,nil,nil,0,nil,{878,879,889,5042,5043,5044,5045,5046,5052},29,"H",nil,1},
[3431] = {'Grenthar',198,198,10,10,0,{[17]={{48.93,57.75}}},nil,17,nil,nil,126,"H",nil,0},
[3432] = {'Mankrik',328,328,15,15,0,{[17]={{55.17,41.02}}},nil,17,{899},{899,4921},29,"H",nil,3},
[3433] = {'Tatternack Steelforge',300,300,14,14,0,{[4709]={{41.73,46.64}}},nil,4709,{24551},{893,1153},29,"H",nil,3},
[3434] = {'Nak',544,544,23,23,0,nil,{[17]={{{43.75,83.26},{43.73,83.45},{43.74,83.61},{43.81,83.8},{43.92,83.98},{44.05,84.18},{44.13,84.27},{44.33,84.42},{44.52,84.39},{44.64,84.25},{44.63,83.99},{44.53,83.76},{44.43,83.56},{44.31,83.33},{44.17,83.12},{44.06,83.04},{43.9,83.02},{43.79,83.13}}}},0,nil,nil,110,nil,nil,0},
[3435] = {'Lok Orcbane',713,713,25,25,0,nil,nil,0,nil,nil,110,nil,nil,0},
[3436] = {'Kuz',864,864,21,21,0,nil,{[17]={{{45.12,80.07},{45.06,79.73},{44.84,79.46},{44.64,79.36},{44.42,79.29},{44.21,79.2},{44.07,79.15},{43.86,79.08},{43.64,79.01},{43.48,79.09},{43.36,79.38},{43.31,79.6},{43.29,79.87},{43.3,80.15},{43.34,80.36},{43.38,80.61},{43.43,80.83},{43.5,81.06},{43.62,81.36},{43.8,81.53},{43.99,81.53},{44.13,81.46},{44.21,81.4},{44.3,81.34},{44.45,81.2},{44.61,81.05},{44.81,80.99},{45.06,80.89},{45.24,80.83},{45.3,80.62},{45.24,80.34},{45.18,80.18}}}},0,nil,nil,110,nil,nil,0},
[3437] = {'Crekori Mudwater',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3438] = {'Kreenig Snarlsnout',247,247,12,12,0,{[17]={{64.45,55.05}}},{[17]={{{58.77,27.09},{58.86,27.2},{58.88,27.38},{58.78,27.49},{58.69,27.49},{58.47,27.35},{58.47,27.15},{58.47,27.15}}}},17,nil,nil,109,nil,nil,0},
[3439] = {'Wizzlecrank\'s Shredder',417,417,18,18,0,{[17]={{57.54,18.3}}},nil,17,{858,863},{858},69,"AH",nil,2},
[3441] = {'Melor Stonehoof',4370,4370,62,62,0,{[1638]={{61.54,80.92}}},nil,1638,{1205},{1130,1131,1136,1205},83,"H",nil,2},
[3442] = {'Sputtervalve',328,328,15,15,0,{[17]={{62.29,17.47}}},nil,17,{14003,14006,29021,29086,29094},{859,863,902,1094,14004,14006,29024,29086},2160,"H","Independent Contractor",3},
[3443] = {'Grub',273,273,13,13,0,{[17]={{55.42,61.22}}},nil,17,nil,{862},29,"H",nil,129},
[3444] = {'Dig Rat',40,40,1,1,0,{[4709]={{48.52,88.77},{50.51,86.95},{50.67,86.13},{49.56,87.47},{50.94,86.49},{47.59,87.87},{49.58,88.3},{50.49,86.89},{50.29,86.05},{47.6,86.86},{50.29,86.29},{48.13,88.06},{47.83,88.72}}},nil,4709,nil,nil,7,"AH",nil,0},
[3445] = {'Supervisor Lugwizzle',386,386,17,17,0,{[17]={{57.11,20.68}}},{[17]={{{56.26,8.59},{56.36,8.53},{56.44,8.44},{56.45,8.33},{56.41,8.19},{56.34,8.16},{56.21,8.21},{56.19,8.36},{56.23,8.48}}}},17,nil,nil,47,nil,nil,0},
[3446] = {'Mebok Mizzyrix',386,386,17,17,0,{[17]={{67.86,71.5}}},nil,17,{865,866},{865,866,1069,1221,1270,1491,24900},69,"AH",nil,2},
[3447] = {'Pawe Mistrunner',664,664,24,24,0,{[1638]={{25.69,27.14}}},nil,1638,nil,nil,104,"H",nil,0},
[3448] = {'Tonga Runetotem',573,573,22,22,0,{[17]={{49.49,58.66}}},nil,17,{870,877,880,13988,26878},{870,877,880,886,3241,6127,6128},104,"H",nil,3},
[3449] = {'Darsok Swiftdagger',300,300,14,14,0,{[17]={{30.58,45.93}}},nil,17,{867,875,876,29095},{867,875,876,28877,29094},29,"H",nil,2},
[3450] = {'Defias Companion',300,328,14,15,0,nil,nil,0,nil,nil,17,nil,nil,0},
[3451] = {'Pilot Wizzlecrank',328,328,15,15,0,nil,nil,0,nil,nil,69,"AH",nil,0},
[3452] = {'Serena Bloodfeather',968,968,20,20,0,{[17]={{26.94,26.62}}},nil,17,nil,nil,514,nil,nil,0},
[3453] = {'Wharfmaster Dizzywig',328,328,15,15,0,{[17]={{69.59,72.98}}},nil,17,{887,14052},{887,890,1039,1111,1492,14063},69,"AH",nil,2},
[3454] = {'Cannoneer Smythe',1146,1146,30,30,0,{[4709]={{68.63,44.47}}},nil,4709,{24939},{24938,24939},1077,"A",nil,3},
[3455] = {'Cannoneer Whessan',1086,1086,29,29,0,{[4709]={{68.74,44.93}}},nil,4709,nil,nil,1077,"A",nil,0},
[3456] = {'Razormane Pathfinder',494,531,20,21,0,nil,nil,0,nil,nil,109,nil,nil,0},
[3457] = {'Razormane Stalker',506,544,22,23,0,nil,nil,0,nil,nil,109,nil,nil,0},
[3458] = {'Razormane Seer',544,582,23,24,0,{[4709]={{39.64,79.11}}},nil,4709,nil,nil,109,nil,nil,0},
[3459] = {'Razormane Warfrenzy',664,713,24,25,0,nil,nil,0,nil,nil,109,nil,nil,0},
[3460] = {'Mud Crawler',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3461] = {'Oasis Snapjaw',300,300,14,15,0,{[17]={{39.6,75.03},{42.17,76.33},{42.55,76.61},{42.6,75.39},{42.48,75.98},{41.49,75.63},{39.53,73.05},{40.68,75.14},{39.77,74.53},{38.58,74.03},{39.75,73.73},{40.63,76.22},{41.04,75.58},{39.3,75.4},{39.24,73.73},{40.28,75.65},{38.85,74.75},{39.8,75.53},{39.25,74.61},{40.28,74.56},{40.02,75.17},{41.82,74.76},{39.89,76.27},{38.5,73.97},{54.94,79.85},{56.63,80.68},{56.43,79.24},{56.61,79.98},{56.08,82.15},{56.1,81.47},{55.01,80.72},{55.88,78.43},{55.43,79.91},{55.39,80.8},{55.94,79.91},{55.63,78.96},{56.47,81.65},{56.03,80.83}},[4709]={{46.13,26.63}}},nil,17,nil,nil,14,nil,nil,0},
[3462] = {'Elder Barrens Giraffe',617,617,22,22,0,{[17]={{64.37,56.21},{64.74,60.12}}},nil,17,nil,nil,189,"AH",nil,0},
[3463] = {'Wandering Barrens Giraffe',417,449,18,19,0,nil,nil,0,nil,nil,189,"AH",nil,0},
[3464] = {'Gazrog',713,713,25,25,0,{[17]={{66.86,72.79}}},nil,17,{869,14066,14067},{869,1509,3281,13991,14066,14067},2028,"AH",nil,2},
[3465] = {'Gilthares Firebough',386,386,17,17,0,{[4709]={{67.62,46.65}}},nil,4709,nil,nil,35,"AH",nil,0},
[3466] = {'Zhevra Courser',494,531,20,21,0,nil,nil,0,nil,nil,189,"AH",nil,0},
[3467] = {'Baron Longshore',356,356,16,16,0,{[17]={{69.91,85.2}}},nil,17,{14046,14049},{14045,14046},2028,"AH","Southsea Freebooters",3},
[3468] = {'Ancient of Lore',154980,154980,85,85,0,{[1657]={{49.56,24.5}}},nil,1657,nil,nil,79,"A",nil,0},
[3469] = {'Ancient of War',154980,154980,85,85,0,{[1657]={{62.41,53.36}}},nil,1657,nil,nil,79,"A",nil,0},
[3470] = {'Rathorian',626,626,18,18,4,{[17]={{42.44,38.96}}},nil,17,nil,nil,16,nil,nil,0},
[3471] = {'Tinkerer Sniggles',712,712,16,16,0,{[17]={{51.06,23.49}}},nil,17,nil,nil,16,nil,nil,0},
[3472] = {'Washte Pawne',713,713,25,25,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3473] = {'Owatanka',664,664,24,24,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3474] = {'Lakota\'mani',573,573,22,22,0,nil,nil,0,nil,nil,15,"AH",nil,0},
[3475] = {'Echeyakee',328,328,15,15,0,{[17]={{44.07,46.47}}},nil,17,nil,nil,16,nil,nil,0},
[3476] = {'Isha Awak',840,840,27,27,0,{[17]={{76.19,92.57}}},{[17]={{{63.55,52.72},{63.87,51.63},{64.12,50.63},{64.55,50.04},{64.96,49.44},{64.99,48.78},{64.96,49.44},{64.55,50.04},{64.12,50.63},{63.87,51.63},{63.55,52.72},{63.53,53.85}}}},17,nil,nil,16,nil,nil,0},
[3477] = {'Hraq',417,417,18,18,0,{[17]={{48.04,56.23}}},nil,17,nil,nil,29,"H","Blacksmithing Supplies",4224},
[3478] = {'Traugh',1107,1107,31,31,0,{[17]={{48.33,56.15}}},nil,17,nil,nil,29,"H","Blacksmithing Trainer",81},
[3479] = {'Nargal Deatheye',1342,1342,35,35,0,{[17]={{48.23,56.57}}},nil,17,nil,nil,29,"H","Weaponsmith",4224},
[3480] = {'Moorane Hearthgrain',417,417,18,18,0,{[17]={{50.23,59.03}}},nil,17,nil,nil,29,"H","Baker",640},
[3481] = {'Barg',300,300,14,14,0,{[17]={{48.99,57.98}}},nil,17,nil,nil,29,"H","General Supplies",640},
[3482] = {'Tari\'qa',300,300,14,14,0,{[17]={{49.02,58.14}}},nil,17,nil,nil,126,"H","Trade Supplies",128},
[3483] = {'Jahan Hawkwing',531,531,21,21,0,{[17]={{48.19,56.39}}},nil,17,nil,nil,29,"H","Leather & Mail Armor Merchant",4227},
[3484] = {'Kil\'hala',713,713,25,25,0,{[17]={{49.93,61.07}}},nil,17,nil,{1945,1946},126,"H","Tailoring Trainer",83},
[3485] = {'Wrahk',417,417,18,18,0,{[17]={{50.01,61.06}}},nil,17,nil,nil,29,"H","Tailoring Supplies",128},
[3486] = {'Halija Whitestrider',449,449,19,19,0,{[17]={{50.02,61.34}}},nil,17,nil,nil,29,"H","Clothier",4224},
[3487] = {'Kalyimah Stormcloud',617,617,23,23,0,{[17]={{50.04,61.63}}},nil,17,nil,nil,126,"H","Bags & Sacks",128},
[3488] = {'Uthrok',356,356,16,16,0,{[17]={{48.01,56.42}}},nil,17,nil,nil,29,"H","Bowyer & Gunsmith",4224},
[3489] = {'Zargh',356,356,16,16,0,{[17]={{50.67,57.79}}},nil,17,{6365},nil,29,"H","Butcher",643},
[3490] = {'Hula\'mahi',1003,1003,30,30,0,{[17]={{48.5,58.43}}},nil,17,nil,nil,126,"H","Reagents, Herbs & Poison Supplies",3200},
[3491] = {'Ironzar',617,617,23,23,0,{[17]={{67.08,73.59}}},nil,17,nil,nil,69,"AH","Weaponsmith",4224},
[3492] = {'Vexspindle',664,664,24,24,0,{[17]={{67.49,72.97}}},nil,17,nil,nil,69,"AH","Cloth & Leather Armor Merchant",4224},
[3493] = {'Grazlix',713,713,25,25,0,{[17]={{67.57,72.9}}},nil,17,nil,nil,69,"AH","Armorer & Shieldcrafter",4224},
[3494] = {'Tinkerwiz',713,713,25,25,0,{[17]={{68.38,69.2}}},nil,17,nil,nil,69,"AH","Engineering Trainer",83},
[3495] = {'Gagsprocket',484,484,20,20,0,{[17]={{68.35,69.12}}},nil,17,nil,nil,69,"AH","Engineering Supplies",128},
[3496] = {'Fuzruckle',5544,5544,45,45,0,{[17]={{68.34,71.16}}},nil,17,nil,nil,69,"AH","Banker",131072},
[3497] = {'Kilxx',664,664,24,24,0,{[17]={{68.57,72.6}}},nil,17,nil,nil,69,"AH","Fisherman",640},
[3498] = {'Jazzik',573,573,22,22,0,{[17]={{67.65,71.26}}},nil,17,nil,nil,69,"AH","General Supplies",640},
[3499] = {'Ranik',573,573,22,22,0,{[17]={{67.08,73.41}}},nil,17,nil,nil,69,"AH","Trade Supplies",128},
[3500] = {'Tarhus',2845,2845,52,52,0,{[357]={{74.64,44.92}}},nil,357,nil,nil,104,"H","Reagents",2176},
[3501] = {'Horde Guard',1398,1398,25,25,0,{[17]={{66.48,39.92},{67.51,40.43},{67.97,39.76},{67.3,39.52},{56.68,43.01},{67.64,41.45},{67.05,41.36},{55.67,43.39},{56.28,42.73},{54.73,41.93},{56.83,40.67},{48.72,60.08},{56.36,42.72},{47.23,56.09},{48.41,59.6},{49.02,48.22},{49.13,48.2},{50.43,45.81},{50.3,56.88},{50.2,45.75},{48.99,48.27},{50.05,56.71},{48.85,60.82},{49.86,62.15},{50.09,56.6},{49.5,61.95},{47.21,56.67},{54.96,42.48},{56.88,40.57},{50.45,60.02},{50.64,59.51},{49.35,59.27},{49.23,58.74},{58.39,60.84},{59.94,63.92},{59.99,63.92},{59.05,64.2},{58.59,63.93},{47.14,76.94},{47.17,76.92}}},nil,17,nil,nil,85,"H",nil,0},
[3502] = {'Ratchet Bruiser',464940,464940,85,85,0,{[17]={{70.12,72.98},{68.87,68.57},{65.6,71.18},{70.22,73.11},{67.96,74.79},{69.31,69.22},{70.07,73.45},{65.86,72.91},{66.65,70.28}}},nil,17,nil,nil,637,"AH",nil,0},
[3503] = {'Silithid Protector',417,449,18,19,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3504] = {'Gil',42,42,1,1,0,{[1519]={{47.39,67.7},{68.17,63.27},{55.41,75.24}}},nil,1519,nil,nil,12,"A",nil,0},
[3505] = {'Pat',42,42,1,1,0,{[1519]={{64.21,73.24},{56.76,67.18}}},{[1519]={{{60.26,71.41},{59.95,71.41},{57.69,72.92},{57.57,72.53},{56.61,69.26},{56.86,66.83},{58,64.8},{58.05,63.81},{57.1,62.1},{58.22,60.7},{56.47,57.37},{55.14,57.03},{54.01,54.91},{52,57.04},{51.95,57.14},{51.93,57.07},{51.72,56.64},{49.81,52.86},{50.3,52.47},{50.88,53.79},{51.94,55.56},{54.24,54.9},{54.77,53.99},{54.66,53.98},{54.66,53.98},{54.66,53.98},{54.66,53.98},{55.79,51.69},{56.71,50.69},{57.68,51.92},{60.42,49.15},{59.56,46.59},{60.61,45.65},{61.79,44.5},{63.64,48.54},{63.79,49.41},{64.9,50.68},{66.62,51.22},{68.16,50.01},{71.05,46.86},{71.48,47.13},{72.37,47.86},{72.47,47.66},{72.47,47.66},{72.47,47.66},{72.47,47.66},{72.21,49.08},{71.43,50.49},{70.01,52.49},{68.34,54.86},{67.27,56.77},{67.21,58.47},{69.09,61.91},{68,63.16},{66.83,64.85},{66.19,63.89},{64.03,66.72},{65.15,69.14},{63.14,71.59},{67.82,80.61},{69.95,79.09},{70.89,81.05},{70.89,81.05},{70.89,81.05},{70.28,78.94},{68.04,80.17},{63.54,72.22},{61.14,73.87},{60.77,72.75}}}},1519,nil,nil,12,"A",nil,0},
[3507] = {'Andi',42,42,1,1,0,{[1519]={{64.22,73.35},{56.7,67.12}}},{[1519]={{{60.19,71.37},{57.82,72.99},{57.5,72.61},{56.61,69.67},{56.56,69.07},{56.79,66.8},{57.98,64.97},{58.02,63.83},{57,62.13},{58.09,60.78},{56.42,57.43},{55.13,57.18},{54.06,55.05},{52.05,57.14},{51.89,57.08},{51.7,56.75},{49.78,52.97},{50.22,52.4},{50.89,53.59},{51.94,55.42},{54.16,54.91},{54.71,54.11},{54.67,54.11},{54.67,54.11},{54.67,54.11},{54.67,54.11},{55.63,51.77},{56.66,50.63},{57.69,51.81},{60.36,49.1},{59.55,46.68},{60.56,45.62},{61.73,44.49},{63.66,48.47},{63.81,49.33},{64.89,50.63},{66.57,51.18},{68.09,50},{70.99,46.8},{71.43,47.02},{72.26,47.89},{72.4,47.64},{72.4,47.64},{72.4,47.64},{72.4,47.64},{72.28,48.98},{71.51,50.39},{70.09,52.49},{68.45,54.82},{67.31,56.73},{67.2,58.23},{69.11,61.84},{68.09,63.18},{66.9,64.9},{66.2,64.01},{64.09,66.72},{65.16,69.01},{63.22,71.59},{67.82,80.48},{69.84,79.02},{70.9,80.88},{70.9,80.88},{70.9,80.88},{70.27,79.09},{68.05,80.32},{63.57,72.36},{61.19,73.89},{60.78,72.92}}}},1519,nil,nil,12,"A",nil,0},
[3508] = {'Mikey',42,42,1,1,0,{[1519]={{64.07,73.58},{56.51,66.96}}},{[1519]={{{60.09,71.77},{57.86,73.28},{57.41,72.85},{56.14,69.09},{56.62,66.62},{58.08,64.73},{57.79,64.1},{56.71,62.08},{57.85,60.71},{56.26,57.64},{54.99,57.45},{53.92,55.3},{52.16,57.35},{51.92,57.49},{51.54,57.03},{49.53,53.18},{50.03,52.07},{51.03,53.37},{52.12,55.12},{54.05,54.74},{54.48,54.36},{54.48,54.35},{54.48,54.35},{54.48,54.35},{54.48,54.35},{55.47,51.52},{56.57,50.43},{57.82,51.66},{60.28,48.89},{59.41,46.75},{60.5,45.47},{61.64,44.33},{63.75,48.39},{63.89,49.21},{64.94,50.42},{66.52,50.91},{67.95,49.8},{70.94,46.59},{71.52,46.76},{72.15,47.61},{72.27,47.44},{72.27,47.44},{72.27,47.44},{72.27,47.44},{72.48,48.95},{71.62,50.56},{70.24,52.62},{68.54,54.98},{67.44,56.62},{67.31,58.12},{69.25,61.7},{68.15,63.39},{67.04,65.12},{66.1,64.16},{64.23,66.86},{65.31,68.87},{63.34,71.77},{68,80.3},{69.67,78.72},{71.06,80.66},{71.06,80.66},{71.06,80.66},{70.14,79.34},{67.94,80.51},{63.48,72.64},{61.31,74.11},{60.58,73.03}}}},1519,nil,nil,12,"A",nil,0},
[3509] = {'Geoff',42,42,1,1,0,{[1519]={{64.05,73.32},{56.67,66.86}}},nil,1519,nil,nil,12,"A",nil,0},
[3510] = {'Twain',40,40,1,1,0,{[1519]={{64.2,73.46},{56.62,67.11}}},{[1519]={{{60.16,71.5},{57.78,73.06},{57.52,72.67},{56.5,69.57},{56.44,69.06},{56.73,66.77},{58.13,64.8},{57.96,63.9},{56.9,62.13},{58.02,60.75},{56.35,57.52},{55.11,57.3},{53.97,55.06},{52.09,57.21},{51.95,57.24},{51.7,56.96},{49.74,53.14},{50.14,52.36},{50.9,53.45},{51.95,55.22},{54.07,54.93},{54.65,54.25},{54.64,54.21},{54.68,54.26},{54.68,54.26},{54.68,54.26},{55.54,51.77},{56.57,50.63},{57.71,51.7},{60.31,49.07},{59.52,46.73},{60.52,45.59},{61.68,44.48},{63.68,48.41},{63.8,49.23},{64.85,50.51},{66.5,51.09},{68,49.97},{70.94,46.78},{71.41,46.92},{72.15,47.87},{72.32,47.61},{72.32,47.61},{72.32,47.61},{72.32,47.61},{72.36,48.93},{71.58,50.37},{70.17,52.48},{68.52,54.79},{67.36,56.58},{67.24,58.08},{69.14,61.74},{68.15,63.2},{66.97,64.94},{66.2,64.1},{64.17,66.71},{65.16,68.9},{63.32,71.59},{67.87,80.33},{69.72,78.97},{70.89,80.71},{70.89,80.71},{70.89,80.71},{70.25,79.24},{68.07,80.44},{63.58,72.51},{61.26,73.91},{60.73,72.99}}}},1519,nil,nil,12,"A",nil,0},
[3511] = {'Steven',42,42,1,1,0,{[1519]={{64.14,73.54},{56.55,67.06}}},{[1519]={{{60.14,71.67},{57.84,73.2},{57.48,72.77},{56.28,69.06},{56.7,66.7},{58.05,64.9},{57.87,64},{56.82,62.13},{57.94,60.74},{56.31,57.58},{55.07,57.36},{53.95,55.16},{52.13,57.28},{51.93,57.37},{51.64,57.03},{49.66,53.23},{50.08,52.24},{50.95,53.38},{52.02,55.13},{54.03,54.85},{54.57,54.35},{54.56,54.3},{54.56,54.3},{54.56,54.3},{54.56,54.3},{55.49,51.72},{56.55,50.59},{57.74,51.66},{60.29,49.01},{59.46,46.78},{60.5,45.54},{61.65,44.4},{63.71,48.36},{63.84,49.19},{64.87,50.44},{66.49,51},{67.96,49.9},{70.89,46.68},{71.45,46.81},{72.1,47.76},{72.27,47.52},{72.27,47.52},{72.27,47.52},{72.27,47.52},{72.44,48.93},{71.62,50.44},{70.21,52.53},{68.58,54.85},{67.41,56.55},{67.29,58.06},{69.2,61.69},{68.17,63.23},{67.02,65.02},{66.16,64.15},{64.22,66.79},{65.22,68.83},{63.36,71.65},{67.92,80.26},{69.67,78.85},{70.97,80.64},{70.97,80.64},{70.97,80.64},{70.19,79.31},{68.02,80.5},{63.54,72.59},{61.3,73.99},{60.65,73.01}}}},1519,nil,nil,12,"A",nil,0},
[3512] = {'Jimmy',42,42,1,1,0,{[1519]={{63.99,73.57},{56.5,66.85}}},{[1519]={{{60.1,71.89},{57.81,73.42},{57.29,72.81},{56.02,69.11},{56.56,66.51},{57.99,64.69},{57.73,64.17},{56.62,62.08},{57.79,60.71},{56.2,57.69},{54.92,57.53},{53.83,55.37},{52.22,57.46},{51.88,57.62},{51.43,57.03},{49.4,53.18},{50.07,51.87},{51.11,53.37},{52.23,55.14},{54.12,54.62},{54.4,54.36},{54.41,54.31},{54.41,54.31},{54.41,54.31},{54.41,54.31},{54.41,54.31},{55.44,51.42},{56.61,50.25},{57.9,51.7},{60.3,48.8},{59.37,46.75},{60.51,45.37},{61.66,44.24},{63.79,48.42},{63.93,49.3},{65.01,50.42},{66.58,50.75},{67.97,49.69},{70.97,46.48},{71.6,46.68},{72.19,47.51},{72.29,47.36},{72.29,47.36},{72.29,47.36},{72.29,47.36},{72.49,49.06},{71.62,50.71},{70.21,52.8},{68.42,55.17},{67.47,56.73},{67.35,58.27},{69.33,61.75},{68.15,63.48},{67.02,65.22},{66.03,64.15},{64.22,66.99},{65.43,68.9},{63.35,71.92},{68.08,80.31},{69.7,78.57},{71.16,80.7},{71.16,80.7},{71.16,80.7},{70.05,79.33},{67.81,80.37},{63.4,72.61},{61.31,74.23},{60.51,73.02}}}},1519,nil,nil,12,"A",nil,0},
[3513] = {'Miss Danna',713,713,25,25,0,{[1519]={{63.93,73.51},{56.52,66.74}}},{[1519]={{{60.18,71.55},{57.65,73.23},{56.24,68.96},{56.72,66.46},{58.2,64.6},{57.86,63.91},{56.82,62.01},{58.03,60.69},{56.11,57.13},{54.97,57.22},{53.84,55.14},{51.9,57.53},{51.58,56.78},{49.56,52.9},{50.24,52.19},{50.94,53.55},{52.14,55.39},{54.16,54.71},{54.56,54.22},{54.53,54.17},{54.53,54.17},{54.53,54.17},{54.53,54.17},{54.53,54.17},{55.55,51.65},{56.69,50.34},{57.87,51.88},{60.41,48.9},{59.43,46.68},{60.56,45.45},{61.74,44.28},{63.76,48.5},{63.86,49.41},{65.03,50.53},{66.77,50.92},{68.03,49.87},{71.07,46.61},{71.57,46.87},{72.26,47.69},{72.45,47.4},{72.45,47.4},{72.45,47.4},{72.45,47.4},{72.34,49.07},{71.48,50.71},{70.1,52.68},{68.38,55.02},{67.35,56.99},{67.27,58.33},{69.24,61.96},{67.97,63.48},{66.83,65.11},{66.09,63.97},{64.09,66.88},{65.32,69.07},{63.21,71.82},{68.05,80.56},{69.86,78.72},{71.07,80.92},{71.07,80.92},{71.07,80.92},{70.06,79.06},{67.89,80.24},{63.43,72.3},{61.17,74.14},{60.58,72.75}}}},1519,nil,nil,12,"A","School Mistress",0},
[3514] = {'Tenaron Stormgrip',0,0,10,10,0,{[6450]={{47.2,55.95}}},nil,6450,{28731},{28730},80,"A",nil,2},
[3515] = {'Corithras Moonrage',198,198,10,10,0,{[141]={{55.82,53.9},{41.03,45.62}}},nil,141,{929,933,7383,14039},{928,929,934,935,7383,28731},80,"A",nil,2},
[3516] = {'Arch Druid Fandral Staghelm',5578000,5578000,73,73,3,nil,nil,0,nil,{940,1015,1019,1047,3763,3789,3790,4902,5253,10520},79,"A",nil,3},
[3517] = {'Rellian Greenspyre',386,386,17,17,0,{[141]={{43.96,44.16}}},nil,141,{923},{922,923},80,"A",nil,2},
[3518] = {'Thomas Miller',328,328,15,15,0,{[1519]={{64.08,72.88}}},{[1519]={{{67.91,72.17},{67.26,71.48},{66.72,70.82},{66.05,70.48},{65.31,69.29},{64.57,67.82},{64.1,66.9},{63.61,66.14},{62.98,65.77},{62.18,65.9},{61.07,66.89},{60.01,68.31},{59.83,69.78},{60,70.78},{60.36,72.15},{60.76,73.15},{61.22,73.93},{62.45,73.03},{62.63,72.36},{62.25,70.98},{62.64,70.45},{63.17,70.59},{63.46,71.81},{64.54,73.45},{65.26,74.53},{66.22,75.9},{66.23,76.61},{65.83,76.93},{65.47,77.14},{64.82,75.42},{64.52,74.64},{64.02,73.51},{63.63,72.62},{63.57,72.42},{63.41,71.83},{64.43,70.22},{64.99,70},{66.16,71.18},{67,72.07},{67.51,72.36},{67.9,72.12}}}},1519,nil,{27675},12,"A","Baker",643},
[3519] = {'Sentinel Arynia Cloudsbreak',198,198,10,10,0,{[141]={{39.5,29.86}}},nil,141,{937},{937,938},80,"A",nil,2},
[3520] = {'Ol\' Emma',55,55,2,2,0,{[1519]={{60.19,57},{59.65,65.53}}},{[1519]={{{60.21,57.02},{60.61,56.47},{60.24,55.73},{60.12,55.82},{60.29,56.91},{60.58,57.62},{57.1,61.71},{57.03,62.4},{58.06,64.4},{58.93,64.31},{60.57,67.13},{61.96,66.14},{63.38,65.93},{66.58,71.12},{64.33,67.28},{64.32,66.54},{65.87,64.29},{65.89,63.69},{64.71,61.62},{63.67,61.15},{61.62,61.74},{58.59,64.3},{58.08,64.31},{57.09,62.52},{57.14,61.75},{60.51,57.72},{60.55,57.45},{60.13,56.62},{60.13,55.74},{60.28,55.74},{60.61,56.37},{60.58,56.55},{60.21,57.02}}}},1519,nil,{5048},12,"A",nil,0},
[3521] = {'Ak\'Zeloth',573,573,22,22,0,{[17]={{67.81,40.57}}},nil,17,nil,{809,924,25264},29,"H",nil,2},
[3522] = {'Constance Brisboise',222,222,11,11,0,{[85]={{52.6,55.77}}},nil,85,nil,nil,68,"H","Apprentice Clothier",4224},
[3523] = {'Bowen Brisboise',664,664,24,24,0,{[85]={{52.59,55.52}}},nil,85,nil,nil,68,"H","Tailoring Trainer",81},
[3524] = {'Spirit Wolf',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3527] = {'Healing Stream Totem',5,5,13,85,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3528] = {'Pyrewood Armorer',300,328,14,15,0,nil,nil,0,nil,nil,123,"A",nil,4224},
[3529] = {'Moonrage Armorer',300,328,14,15,0,nil,nil,0,nil,nil,16,nil,nil,0},
[3530] = {'Pyrewood Tailor',300,328,14,15,0,nil,nil,0,nil,nil,123,"A",nil,4224},
[3531] = {'Moonrage Tailor',300,328,14,15,0,nil,nil,0,nil,nil,16,nil,nil,0},
[3532] = {'Pyrewood Leatherworker',300,328,14,15,0,nil,nil,0,nil,nil,123,"A",nil,4224},
[3533] = {'Moonrage Leatherworker',300,328,14,15,0,nil,nil,0,nil,nil,16,nil,nil,0},
[3534] = {'Wallace the Blind',449,449,19,19,0,{[130]={{33.02,17.8}}},nil,130,nil,nil,35,"AH","Weaponsmith",4224},
[3535] = {'Blackmoss the Fetid',234,234,8,8,4,{[141]={{45.15,25.86},{52.04,63.66}}},nil,141,nil,nil,14,nil,nil,0},
[3536] = {'Kris Legace',1163,1163,32,32,0,{[267]={{68.85,58.95}}},nil,267,nil,nil,35,"AH","Freewheeling Tradeswoman",4224},
[3537] = {'Zixil',1163,1163,32,32,0,{[267]={{52.99,52.78}}},{[267]={{{61.97,20.45},{61.53,20.09},{61.36,19.98},{59.48,21.16},{58.42,19.55},{55.8,19.73},{55.61,25.75},{55.92,29.34},{56.9,34.01},{57.6,36.46},{54.61,37.65},{54.31,34.29},{55.62,34.75},{55.58,34.72},{54.51,34},{54.37,34.68},{54.75,36.83},{53.86,38.14},{51.64,39.41},{50.8,43.17},{51.07,45.43},{51.33,46.62},{50.85,49.25},{51.1,51.17},{50.91,51.9},{50.5,52.72},{50.28,56.77},{49.99,57.07},{50.28,56.77},{50.5,52.72},{50.91,51.9},{51.1,51.17},{50.85,49.25},{51.33,46.62},{51.07,45.43},{50.8,43.17},{51.64,39.41},{53.86,38.14},{54.75,36.83},{54.37,34.68},{54.51,34},{55.58,34.72},{55.62,34.75},{54.31,34.29},{54.61,37.65},{57.6,36.46},{56.9,34.01},{55.92,29.34},{55.61,25.75},{55.8,19.73},{58.42,19.55},{59.48,21.16},{61.36,19.98},{61.53,20.09},{61.99,20.58}}}},267,nil,nil,120,"AH","Merchant Supreme",4224},
[3538] = {'Overwatch Mark I',1163,1163,32,32,0,{[267]={{52.98,52.63}}},nil,267,nil,nil,120,"AH","Protector",0},
[3539] = {'Ott',1163,1163,32,32,0,{[267]={{57.67,47.54}}},nil,267,nil,nil,29,"H","Weaponsmith",4224},
[3540] = {'Hal McAllister',1753,1753,40,40,0,nil,nil,0,nil,nil,12,"A","Fish Merchant",640},
[3541] = {'Sarah Raycroft',1753,1753,40,40,0,nil,nil,0,nil,nil,12,"A","General Goods",384},
[3542] = {'Jaysin Lanyda',1753,1753,40,40,0,nil,nil,0,nil,nil,12,"A","Poisons & Reagents",3200},
[3543] = {'Robert Aebischer',1753,1753,40,40,0,nil,nil,0,nil,nil,12,"A","Superior Armorsmith",4224},
[3544] = {'Jason Lemieux',1753,1753,40,40,0,{[267]={{56.65,50.18}}},{[267]={{{60.51,19.53},{60.64,19.89},{60.76,20.55},{60.82,20.97},{60.87,21.38},{60.96,21.78},{61.04,22.18},{61.1,22.6},{61.13,22.74},{61.32,23.22},{61.39,23.29},{61.58,23.28},{61.64,23.27},{61.89,23.01},{61.94,22.95},{61.94,22.66},{61.93,22.38},{62.03,21.69},{62.22,21.2},{62.27,20.8},{62.04,20.42},{61.69,20.23},{61.52,20.11},{61.43,20.05},{61.04,20.35},{60.67,20.8},{60.35,21.1},{59.89,21.21},{59.7,21.2},{59.34,21.02},{59.13,20.75},{59.01,20.52},{59.03,20.15},{59.16,19.78},{59.34,19.45},{59.54,19.17},{59.81,19.08},{60.15,19.23}}}},267,nil,nil,68,"H","Mushroom Seller",640},
[3545] = {'Claude Erksine',1753,1753,40,40,0,{[38]={{82.22,62.84}}},nil,38,nil,nil,55,"A","Pet Trainer",1},
[3546] = {'Bernie Heisten',2218,2218,45,45,0,{[4]={{59.4,14.88}}},nil,4,nil,nil,12,"A","Food & Drink",640},
[3547] = {'Hamlin Atkins',198,198,10,10,0,{[85]={{60,52.15}}},{[85]={{{58.34,50.7},{58.33,50.3},{58.33,50.03},{58.38,49.78},{58.51,49.61},{58.72,49.39},{58.85,49.21},{59,49.1},{59.18,49.07},{59.35,49.03},{59.44,49},{59.52,48.93},{59.34,48.94},{59.09,49.07},{58.93,49.17},{58.72,49.41},{58.57,49.55},{58.43,49.71},{58.37,49.81},{58.33,50.2},{58.31,50.6},{58.34,51},{58.36,51.26},{58.33,51.52},{58.28,51.62},{57.85,51.79},{56.76,52.23},{56.96,52.16},{57.48,51.96},{57.83,51.85},{58.18,51.74},{58.36,51.68},{58.53,51.63},{58.71,51.6},{58.98,51.58},{59.25,51.57},{59.51,51.62},{59.84,51.81},{60.25,52.08},{60.66,52.36},{60.82,52.49},{61.01,52.76},{61.2,53.06},{61.36,53.38},{61.62,53.93},{61.79,54.4},{61.67,54.14},{61.42,53.59},{61.31,53.37},{61.2,53.16},{61.02,52.86},{60.96,52.76},{60.82,52.59},{60.67,52.45},{60.59,52.39},{60.18,52.1},{59.87,51.85},{59.54,51.64},{59.27,51.58},{59,51.58},{58.74,51.58},{58.56,51.61},{58.48,51.59},{58.41,51.5},{58.36,51.25},{58.34,50.85}}}},85,nil,nil,68,"H","Mushroom Farmer",640},
[3548] = {'Selina Weston',247,247,12,12,0,{[85]={{59.63,52.26}}},nil,85,nil,nil,68,"H","Alchemy & Herbalism Supplies",128},
[3549] = {'Shelene Rhobart',713,713,25,25,0,{[85]={{65.41,60.09}}},nil,85,nil,nil,68,"H","Leatherworking Trainer",81},
[3550] = {'Martine Tramblay',328,328,15,15,0,{[85]={{65.86,59.64}}},nil,85,nil,nil,68,"H","Fishing Supplies",128},
[3551] = {'Patrice Dwyer',484,484,20,20,0,{[130]={{42.91,41.81}}},nil,130,nil,nil,68,"H","Poison Supplies",1152},
[3552] = {'Alexandre Lefevre',417,417,18,18,0,{[130]={{44.61,39.25}}},nil,130,nil,nil,68,"H","Leather Armor Merchant",4224},
[3553] = {'Sebastian Meloche',417,417,18,18,0,{[130]={{43.33,41.35}}},nil,130,nil,nil,68,"H","Armorer",4224},
[3554] = {'Andrea Boynton',484,484,18,18,0,{[130]={{44.73,39.15}}},nil,130,nil,nil,68,"H","Clothier",4224},
[3555] = {'Johan Focht',449,449,19,19,0,{[130]={{43.41,40.45}}},nil,130,nil,nil,68,"H","Mining Trainer",80},
[3556] = {'Andrew Hilbert',484,484,19,19,0,{[130]={{43.22,40.66}}},nil,130,nil,nil,68,"H","Trade Supplies",128},
[3557] = {'Guillaume Sorouy',896,896,28,28,0,{[130]={{42.88,40.95}}},nil,130,nil,nil,68,"H","Blacksmithing Trainer",81},
[3559] = {'Temp Poisoning Vendor Dwarf',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Poison Supplies",0},
[3560] = {'Healing Ward',5,5,17,37,0,nil,nil,0,nil,nil,654,nil,nil,0},
[3561] = {'Kyrai',1003,1003,30,30,0,{[1657]={{38.55,35.57}}},nil,1657,nil,nil,80,"A","Poison Supplies",1152},
[3562] = {'Alaindia',1003,1003,30,30,0,{[1657]={{38.98,73.97}}},nil,1657,nil,nil,80,"A","Reagents",2176},
[3564] = {'Temp Reagent Vendor Dwarf',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Reagents",0},
[3566] = {'Flatland Prowler',176,176,9,9,0,{[215]={{50.42,30.5},{45,33.52},{53.15,30.62},{53.13,32.28},{51.84,32.69},{58.39,26.14},{57.39,29.6},{56.68,26.71},{50.53,28.81},{43.66,11.36},{45.12,12.64},{58.56,29.74},{43.12,14.13},{51.68,16.22},{45.41,13.75},{46.27,11.34},{54.87,27.97},{54.82,31.31},{52.28,27.89},{60.88,26.38},{48.71,14.91},{48.7,13.22},{49.28,12.32},{57.27,24.22},{59.95,25.88},{47.36,15},{45.59,28.83},{54.31,25.17},{45.02,31.55},{46.28,29.82},{44.46,14.22},{46.35,16.08},{56.07,24.35},{51.2,29.45},{47.94,29.07},{48.22,21.59},{52.38,24.14},{53.64,22.29},{55.43,29.01},{55.42,25.23},{51.71,19.76},{52.43,20.67},{50.72,23.89},{49.9,26.1},{51,26.19},{56.06,20.7},{49.46,19.44},{33.49,20.7},{44.56,18.07},{43.81,18.56},{51.23,15.13},{53.47,18.74},{50.74,21.98},{48.17,25.13},{60.88,26.38},{46.32,27.91},{51.76,16.2},{48.77,15.17},{51.15,24.25},{49.33,19.65},{51.26,26.14},{47.97,21.63},{50.32,21.91},{48.65,15.29},{49.48,19.94},{46.47,16.36},{52.95,17.45},{46.35,16.09},{49.24,19.39},{48.69,14.95},{56.7,21.46},{59.83,26},{48.03,25.09}},[1638]={{36.12,9.27},{83.61,14.49},{24.52,5.82},{83.28,14.44},{83.22,14.25},{69.9,44.67},{65.81,31.14}}},nil,215,nil,nil,16,nil,nil,0},
[3567] = {'Tallonkai Swiftroot',222,222,11,11,0,{[141]={{55.55,49.99}}},nil,141,{932,2438,2459},{932,2438,2459},80,"A",nil,2},
[3568] = {'Mist',198,198,10,10,0,{[141]={{35.43,28.66}}},nil,141,{938},nil,80,"A",nil,2},
[3569] = {'Bogling',48,48,5,5,0,{[141]={{59.8,59.83},{59.81,59.84},{59.83,59.84}}},nil,141,nil,nil,16,nil,nil,0},
[3570] = {'Cleansed Timberling',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3571] = {'Teldrassil Sentinel',656,656,15,15,0,{[141]={{55.6,52.05},{55.26,49.95},{55.36,49.6},{55.61,52.01},{55.52,51.26},{55.91,54.11},{55.56,51.82},{55.56,50.22},{55.73,52.04},{55.76,51.16},{55.82,52.08}}},nil,141,nil,nil,79,"A",nil,1},
[3572] = {'Zizzek',573,573,22,22,0,{[17]={{67.2,74.19}}},nil,17,nil,nil,69,"AH","Fishing Supplies",128},
[3573] = {'Mana Spring Totem',5,5,85,85,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3574] = {'Riding Bat',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3575] = {'Praenus Raxxeus',75,80,65,65,1,nil,nil,0,nil,nil,35,"AH","Bat Handler",0},
[3577] = {'Ambermill Brewmaster',356,356,11,16,0,{[130]={{62.53,64.98}}},nil,130,nil,nil,76,"AH",nil,640},
[3578] = {'Ambermill Miner',356,356,16,16,0,{[130]={{62.57,62.68}}},nil,130,nil,nil,76,"AH",nil,128},
[3579] = {'Stoneclaw Totem',50,50,85,85,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3580] = {'Crafticus Rabbitus',75,80,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[3581] = {'Sewer Beast',17720,17720,50,50,4,{[1519]={{71.15,48.76},{71.11,68.01},{69.07,50.71}}},nil,1519,nil,nil,14,nil,nil,0},
[3582] = {'Aman',2769,2769,50,50,0,nil,nil,0,nil,nil,1802,"A",nil,0},
[3583] = {'Barithras Moonshade',300,300,14,14,0,nil,nil,0,nil,{947},1076,"A",nil,0},
[3584] = {'Therylune',386,386,17,17,0,nil,{[148]={{{38.54,87.35},{38.68,87.5},{38.93,87.58},{39.12,87.58},{39.24,87.55},{39.27,87.43},{39.22,87.02},{39.24,86.37},{39.27,85.78},{39.35,85.35},{39.44,85.23},{39.53,85.27},{39.56,85.33},{39.58,85.7},{39.58,85.98},{39.61,86.16},{39.69,86.5},{39.73,86.55},{39.78,86.52},{39.89,86.39},{40.04,86.29},{40.22,86.25},{40.33,86.29},{40.38,86.4},{40.53,86.7},{40.57,87.5},{40.83,88.22},{40.89,88.56}}}},0,nil,nil,124,"A",nil,0},
[3585] = {'Therysil',386,386,17,17,0,nil,nil,0,nil,{945},79,"A",nil,0},
[3586] = {'[UNUSED 4.x ]Miner Johnson',1347,1347,19,19,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,14,nil,nil,0},
[3587] = {'Lyrai',0,0,9,9,0,{[6450]={{48.81,61.08}}},nil,6450,nil,nil,80,"A","General Supplies",640},
[3588] = {'Khardan Proudblade',0,0,8,8,0,{[6450]={{47.86,61.69}}},nil,6450,nil,nil,80,"A","Weaponsmith",4224},
[3589] = {'Keina',0,0,10,10,0,{[6450]={{48.64,60.25}}},nil,6450,nil,nil,80,"A","Bowyer",4224},
[3590] = {'Janna Brightmoon',0,0,9,9,0,{[6450]={{48.58,61.58}}},nil,6450,nil,nil,80,"A","Clothier",4224},
[3591] = {'Freja Nightwing',0,0,9,9,0,{[6450]={{48.81,60.28}}},nil,6450,nil,nil,80,"A","Leather Armor Merchant",4224},
[3592] = {'Andiss',0,0,10,10,0,{[6450]={{50.06,62.41}}},nil,6450,nil,nil,80,"A","Armorer & Shieldcrafter",4224},
[3593] = {'Alyissia',0,0,11,11,0,{[6450]={{49.21,52.42}}},nil,6450,{26945,28723},{3116,26945},80,"A","Warrior Trainer",3},
[3594] = {'Frahun Shadewhisper',0,0,11,11,0,{[6450]={{49.22,53.19}}},nil,6450,{26946,28723},{3118,26946},80,"A","Rogue Trainer",3},
[3595] = {'Shanda',0,0,10,10,0,{[6450]={{47.59,59.43}}},nil,6450,{26949,28723},{3119,26949},80,"A","Priest Trainer",3},
[3596] = {'Ayanna Everstride',0,0,10,10,0,{[6450]={{49.22,60.54}}},nil,6450,{26947,28723},{3117,26947},80,"A","Hunter Trainer",3},
[3597] = {'Mardant Strongoak',0,0,11,11,0,{[6450]={{46.6,56.62}}},nil,6450,{26948,28723},{3120,26948},80,"A","Druid Trainer",3},
[3598] = {'Kyra Windblade',449,449,19,19,0,{[141]={{55.89,51.72}}},nil,141,nil,nil,80,"A","Warrior Trainer",49},
[3599] = {'Jannok Breezesong',484,484,20,20,0,{[141]={{56.03,52.53}}},nil,141,nil,nil,80,"A","Rogue Trainer",49},
[3600] = {'Laurna Morninglight',531,531,21,21,0,{[141]={{55.32,49.6}}},nil,141,nil,{5621,5622},80,"A","Priest Trainer",51},
[3601] = {'Dazalar',484,484,20,20,0,{[141]={{56.28,51.97}}},nil,141,nil,{6063,6071,6072,6073,6101,6102,6721,6722},80,"A","Hunter Trainer",51},
[3602] = {'Kal',573,573,22,22,0,{[141]={{55.65,53.77}}},nil,141,nil,nil,80,"A","Druid Trainer",49},
[3603] = {'Cyndra Kindwhisper',896,896,28,28,0,{[141]={{57.12,53.11}}},nil,141,nil,nil,80,"A","Alchemy Trainer",81},
[3604] = {'Malorne Bladeleaf',386,386,17,17,0,{[141]={{57.19,52.97}}},nil,141,nil,nil,80,"A","Herbalism Trainer",80},
[3605] = {'Nadyia Maneweaver',1003,1003,30,30,0,{[141]={{43.46,43.27}}},nil,141,nil,nil,80,"A","Leatherworking Trainer",81},
[3606] = {'Alanna Raveneye',950,950,29,29,0,{[141]={{38.98,30.03}}},nil,141,nil,nil,80,"A","Enchanting Trainer",81},
[3607] = {'Androl Oakhand',1536,1536,37,37,0,{[141]={{53.91,89.94}}},nil,141,nil,nil,80,"A","Fishing Trainer",81},
[3608] = {'Aldia',386,386,17,17,0,{[141]={{55.27,49.94}}},nil,141,nil,nil,80,"A","General Supplies",640},
[3609] = {'Shalomon',417,417,18,18,0,{[141]={{55.96,51.97}}},nil,141,nil,nil,80,"A","Weaponsmith",4224},
[3610] = {'Jeena Featherbow',449,449,19,19,0,{[141]={{55.6,51.43}}},nil,141,nil,nil,80,"A","Bowyer",4224},
[3611] = {'Brannol Eaglemoon',356,356,16,16,0,{[141]={{55.8,52.64}}},nil,141,nil,nil,80,"A","Clothier",4224},
[3612] = {'Sinda',484,484,20,20,0,{[141]={{55.98,52.06}}},nil,141,nil,nil,80,"A","Leather Armor Merchant",4224},
[3613] = {'Meri Ironweave',449,449,19,19,0,{[141]={{55.95,51.88}}},nil,141,nil,nil,80,"A","Armorer & Shieldcrafter",4224},
[3614] = {'Narret Shadowgrove',356,356,16,16,0,{[141]={{55.07,49.95}}},nil,141,nil,nil,80,"A","Trade Supplies",128},
[3615] = {'Devrak',232470,232470,85,85,1,{[17]={{48.7,58.66}}},nil,17,{6384},nil,29,"H","Wind Rider Master",8195},
[3616] = {'Onu',3398,3398,55,55,0,nil,nil,0,nil,{948,950,951,952,960,961},79,"A","Ancient of Lore",2},
[3617] = {'Lordaeron Citizen',328,328,15,15,0,{[85]={{61.62,66.5},{61.53,66.84},{61.39,66.66},{61.28,66.99},{61.25,67.42},{60.91,67.07},{60.88,66.6},{60.97,66.19},{60.84,67.83},{60.82,68.63},{61.51,67.44},{61.2,68.21},{61.57,68.17},{62.11,68.21},{62.47,68.13},{62.46,67.44},{62.86,67.53},{62.85,66.99},{62.77,66.27},{62.85,68.03},{62.85,68.69},{62.05,66.43},{62.4,66.63},{62.14,67.06},{61.58,66.97},{60.67,67.46},{61.12,66.1},{60.01,67.72},{59.67,67.78},{59.61,67.1},{59.94,67.03},{59.91,67.42},{59.66,67.42},{62.51,68.31},{61.86,68.49},{61.85,68.14},{61.83,66.93},{61.86,66.38}}},nil,85,nil,nil,7,"AH",nil,0},
[3619] = {'Ghost Saber',449,449,19,20,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3620] = {'Harruk',1753,1753,40,40,0,{[14]={{52.03,43.55}}},nil,14,nil,nil,29,"H","Pet Trainer",1},
[3621] = {'Kurll',2769,2769,50,50,0,nil,nil,0,nil,nil,29,"H","Food & Drink",640},
[3622] = {'Grokor',3006,3006,55,55,0,{[8]={{48.95,53.45}}},nil,8,nil,nil,29,"H","Pet Trainer",1},
[3624] = {'Zudd',1524,1524,40,40,0,{[33]={{36.79,50.6}}},nil,33,nil,nil,29,"H","Pet Trainer",1},
[3625] = {'Rarck',17820,17820,60,60,0,{[2597]={{-1,-1}}},nil,2597,nil,nil,1215,"H","General Goods",640},
[3626] = {'Jenn Langston',102,102,5,5,0,{[1519]={{73.74,55.32}}},{[1519]={{{72.55,55.09},{72.84,54.92},{73.34,54.98},{73.58,55.09},{73.99,55.48},{75.29,57.11},{76.06,58.64},{76.24,59.07},{76.38,59.68},{76.29,60.27},{76.08,60.83},{75.84,61.34},{75.8,61.8},{75.85,62.25},{75.78,62.69},{75.66,62.93},{75.4,63.09},{75.11,63.11},{74.81,62.87},{74.59,62.58},{73.7,62.73},{73.3,62.5},{72.81,61.86},{71.32,59.33},{71.16,59.19},{70.81,58.61},{70.56,58.04},{70.61,57.44},{71.27,56.6},{71.66,56.14}}}},1519,nil,nil,12,"A",nil,0},
[3627] = {'Erich Lohan',102,102,5,5,0,{[1519]={{47.98,89.17},{47.83,77.06},{50.57,78.78}}},{[1519]={{{48.67,89.64},{49.62,89.79},{50.35,89.62},{51.26,88.72},{51.62,88.1},{51.74,87.8},{51.38,87.15},{51.06,86.24},{50.98,85.82},{50.6,85.21},{50.27,84.86},{49.97,84.64},{49.55,82.8},{49.56,81.84},{49.87,80},{50.31,79.16},{51.15,78.22},{51.56,77.98},{52.7,77.95},{53.13,78.23},{54.3,79.96},{54.53,80.55},{54.74,81.68},{54.8,83.05},{54.56,83.99},{53.92,85.19},{53.31,85.72},{52.85,85.94},{51.58,86.25},{51.07,85.85},{50.49,85.05},{49.93,84.67},{49.3,84.57},{48.56,84.74},{47.86,85.67},{47.32,86.9},{46.01,88.02},{45.05,87.71},{44.27,87.18},{43.93,85.79},{43.94,84.61},{44.4,82.58},{44.53,81.45},{44.5,80.25},{44.95,79.44},{46.17,78.14},{47.6,77.1},{48.06,77.11},{49.61,78.06},{50.17,78.63},{50.24,78.95},{49.71,80.88},{49.52,82.4},{49.94,84.5},{50.52,85.04},{50.97,85.82},{51.06,86.42},{51.32,87.05},{51.69,87.79},{51.53,88.35},{50.98,89.2},{49.82,89.69},{49.14,89.75},{48.28,89.27}}}},1519,nil,nil,12,"A",nil,0},
[3628] = {'Steven Lohan',102,102,5,5,0,{[1519]={{51.74,93.94}}},nil,1519,nil,nil,12,"A","Innkeeper",65537},
[3629] = {'David Langston',102,102,5,5,0,{[1519]={{76.4,53.26}}},nil,1519,nil,nil,12,"A",nil,0},
[3630] = {'Deviate Coiler',328,328,15,16,0,{[17]={{38.91,64.37},{39.23,65.56},{38.96,67.35},{39.2,66.28}}},nil,17,nil,nil,14,nil,nil,0},
[3631] = {'Deviate Stinglash',356,356,16,17,0,{[17]={{44.38,61.89}}},nil,17,nil,nil,14,nil,nil,0},
[3632] = {'Deviate Creeper',328,328,15,16,0,{[17]={{39.5,62.33},{39.32,66.6},{38.85,67.96},{38.81,64.32},{38.72,63.5},{39.07,62.56},{40.01,65.52},{39.37,65.58},{39.98,66.49},{38.58,65.32}}},nil,17,nil,nil,270,nil,nil,0},
[3633] = {'Deviate Slayer',356,356,16,17,0,{[17]={{43.35,61.96},{43.96,61.59},{43.84,62.5},{44.62,62.8},{44.56,63.89},{44.2,65.11},{43.1,65.62},{42.64,61.83},{42.36,62.68},{41.9,63.04},{41.9,62.23},{41.4,62.88}}},nil,17,nil,nil,270,nil,nil,0},
[3634] = {'Deviate Stalker',356,356,15,16,0,{[17]={{39.94,66.58},{41.01,62.85},{43.95,62.28},{40.19,65.74},{38.65,65.32}}},nil,17,nil,nil,270,nil,nil,0},
[3636] = {'Deviate Ravager',1796,1796,18,19,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,nil,0},
[3637] = {'Deviate Guardian',1668,1668,18,19,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,nil,0},
[3638] = {'Devouring Ectoplasm',356,356,16,17,0,{[17]={{43.1,62.26},{42.81,66.03}}},nil,17,nil,nil,14,nil,nil,0},
[3639] = {'Sentinel Tysha Moonblade',198,198,10,10,0,nil,nil,0,nil,{953},80,"A",nil,0},
[3640] = {'Evolving Ectoplasm',1544,1544,17,18,1,{[718]={{-1,-1}}},nil,718,nil,nil,14,nil,nil,0},
[3641] = {'Deviate Lurker',386,386,16,17,0,{[17]={{43.48,64.14},{42.38,64.12},{42.7,63.6},{42.6,64.43},{43.01,64.21},{43.15,63.58},{40.28,62.53},{40.3,62.25}}},nil,17,nil,nil,14,nil,nil,0},
[3642] = {'Deviate Horror',5000,5000,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[3644] = {'Cerellean Whiteclaw',328,328,15,15,0,nil,nil,0,nil,{963},80,"A",nil,0},
[3649] = {'Thundris Windweaver',328,328,15,15,0,nil,nil,0,nil,{958,1442,4761,4762,4763,9633},80,"A",nil,2},
[3650] = {'Asterion',328,328,15,15,0,nil,nil,0,nil,{954,955,956,957},80,"A",nil,0},
[3652] = {'Trigore the Lasher',482,482,17,17,4,{[14]={{5.53,69.43}}},nil,14,nil,nil,14,nil,nil,0},
[3653] = {'Kresh',4840,4840,20,20,1,{[718]={{-1,-1}}},nil,718,nil,nil,7,"AH",nil,0},
[3654] = {'Mutanus the Devourer',12100,12100,20,20,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,nil,0},
[3655] = {'Mad Magglish',386,386,17,17,0,{[14]={{2.35,73.53}}},nil,14,nil,nil,14,nil,nil,0},
[3657] = {'[Deprecated for 4.x]Sentinel Elissa Starbreeze',484,484,20,20,0,nil,nil,0,nil,nil,80,"A",nil,0},
[3658] = {'Lizzarik',449,449,19,19,0,{[17]={{50.35,59.3},{62.32,73.69}}},{[17]={{{61.78,38.24},{61.57,37.89},{61.43,37.9},{61.18,37.94},{61.01,38.08},{60.81,38.34},{60.47,38.4},{60.32,38.52},{60.19,38.8},{59.89,38.84},{59.62,38.9},{59.42,38.87},{59.02,38.75},{58.84,38.59},{58.46,38.33},{58.06,38.03},{57.77,37.82},{57.54,37.4},{57.21,37.05},{56.84,36.91},{56.43,36.89},{56.29,36.62},{56.21,36.1},{55.98,35.62},{55.81,35.42},{55.46,34.97},{55.27,34.49},{55.06,34.31},{54.91,33.65},{54.68,33.31},{54.38,32.89},{54.15,32.53},{53.73,31.83},{53.4,31.31},{53.21,31.08},{52.87,31.01},{52.5,30.92},{52.48,30.65},{52.46,30.68},{52.4,30.87},{52.57,30.99},{52.96,31.03},{53.29,31.19},{53.79,31.9},{54.09,32.42},{54.32,32.82},{54.93,33.7},{55.05,34.3},{55.26,34.46},{55.42,34.94},{55.73,35.35},{56,35.68},{56.21,36.09},{56.33,36.75},{56.49,36.91},{56.95,36.96},{57.46,37.31},{57.63,37.52},{57.74,37.79},{58.03,38.01},{58.4,38.29},{58.71,38.47},{59,38.74},{59.33,38.86},{59.69,38.92},{60,38.84},{60.12,38.86},{60.36,38.48},{60.61,38.36},{60.83,38.31},{61.12,37.96},{61.53,37.88},{61.7,38.11},{61.8,38.26},{61.74,38.33},{61.75,38.28}}}},17,nil,nil,69,"AH","Weapon Dealer",4224},
[3659] = {'Jorb',1536,1536,37,37,0,{[17]={{50.39,59.31},{62.33,73.62}}},nil,17,nil,nil,474,"AH","Lizzarik's Bodyguard",0},
[3660] = {'Athrikus Narassin',1107,1107,31,31,0,nil,nil,0,nil,nil,14,nil,"Cult of the Dark Strand",0},
[3661] = {'Balthule Shadowstrike',328,328,15,15,0,nil,nil,0,nil,{965,966,1143,1167},80,"A",nil,0},
[3662] = {'Delmanis the Hated',330,330,17,17,0,nil,{[148]={{{56.84,27.51},{56.83,27.5},{56.83,27.55},{56.94,27.53},{57.11,27.5},{57.27,27.48},{57.51,27.5},{57.67,27.42},{57.67,27.2},{57.6,27},{57.64,26.46},{57.69,26.21},{57.61,26.06},{57.44,25.99},{57.28,26.06},{57.09,26.09},{57.04,26.22},{57.03,26.49},{56.94,26.62},{56.73,26.69},{56.65,26.78},{56.47,26.85},{56.39,27},{56.42,27.19},{56.55,27.16},{56.74,26.72},{56.96,26.64},{57.05,26.42},{57.05,26.13},{57.2,26.02},{57.57,26.06},{57.7,26.26},{57.83,26.52},{57.88,26.73},{57.75,26.9},{57.63,27.04},{57.56,27.39},{57.32,27.36},{56.93,27.34},{56.81,27.52},{56.84,27.5},{56.81,27.51},{56.83,27.52},{56.82,27.52},{56.84,27.5},{56.82,27.51},{56.84,27.5},{56.84,27.51},{56.81,27.51},{56.83,27.52}}}},0,nil,nil,90,nil,nil,0},
[3663] = {'[Deprecated for 4.x]Delgren the Purifier',449,449,19,19,0,nil,nil,0,nil,{967,970,973,976,981,1140},123,"A",nil,2},
[3665] = {'Crane Operator Bigglefuzz',417,417,18,18,0,{[17]={{69.13,71.48}}},nil,17,nil,{959},69,"AH",nil,2},
[3666] = {'Wizbang Cranktoggle',328,328,15,15,0,nil,nil,0,nil,{1579,1580},64,"A",nil,0},
[3667] = {'Anaya Dawnrunner',356,356,16,16,0,nil,{[148]={{{41.8,60.74},{41.83,60.46},{42,60.52},{42.23,60.63},{42.44,60.73},{42.66,60.85},{42.79,61.07},{42.87,61.44},{42.91,61.78},{43,61.91},{43.16,62.15},{43.06,62.48},{42.9,62.64},{42.7,62.75},{42.5,62.78},{42.28,62.8},{42.13,62.6},{41.98,62.39},{41.83,62.11},{41.66,61.93},{41.36,61.81},{41.83,61.96},{41.87,61.69},{41.85,61.39},{41.82,61.01}}}},0,nil,nil,7,"AH",nil,0},
[3668] = {'Tortured Highborne Soul',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3669] = {'Lord Cobrahn',10825,10825,20,20,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,"Fanglord",0},
[3670] = {'Lord Pythas',10825,10825,20,20,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,"Fanglord",0},
[3671] = {'Lady Anacondra',10825,10825,20,20,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,"Fanglord",0},
[3672] = {'Boahn',525,525,17,17,4,{[17]={{44.02,62.59}}},nil,17,nil,nil,270,nil,"Druid of the Fang",0},
[3673] = {'Lord Serpentis',10825,10825,20,20,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,"Fanglord",0},
[3674] = {'Skum',12100,12100,20,20,1,{[718]={{-1,-1}}},nil,718,nil,nil,14,nil,nil,0},
[3678] = {'Muyoh',1732,1732,20,20,1,{[718]={{-1,-1}}},nil,718,nil,{999,1500,26874},35,"AH","Disciple of Naralex",1},
[3679] = {'Naralex',2796,2796,25,25,0,{[718]={{-1,-1}}},nil,718,nil,nil,35,"AH",nil,1},
[3680] = {'Serpentbloom Snake',8,8,1,1,0,{[718]={{-1,-1}}},nil,718,nil,nil,7,"AH",nil,0},
[3681] = {'Wisp',42,42,1,1,0,{[141]={{52.08,90.15},{52.07,89.67}},[1657]={{40.43,62.83},{67.22,36.47},{44.37,51.28},{57.66,61},{30.85,68.29},{34.73,33.4},{51.97,82.49},{48.09,55.1},{57.08,68.73},{42.87,85.42},{49.82,18.1},{54.16,15.46},{44.43,20.03},{45.57,35.17},{67.66,56.18},{57.23,38.38},{39.08,24.25},{52.87,26.44},{61,73.83},{41.42,80.02},{47.29,34.32},{38.27,47.83},{52.77,33.29},{63.75,54.78},{62.91,46.6},{43.47,47.46},{35.12,31.36},{46.55,7.86},{31.18,80.56},{66.98,51.19},{43.31,18.72},{46.66,22.83},{44.42,81.44},{72.43,49.8},{34.64,25.83},{29.47,38.65},{68.95,46.15},{63.24,47.78},{60.8,33.35},{56.43,81.66},{38.22,83.27},{33.33,41.54},{39.59,58.33}},[3522]={{49.11,36.08},{49.01,35.75},{48.88,36.04},{61.63,40.82},{60.53,39.86},{61.32,38.84},{62.23,38.62},{61.1,38.11},{62.46,37.59},{61.82,36.85},{61.03,39.85},{61.26,39.03},{61.6,40.83},{62.47,37.59},{60.63,39.62},{62.26,38.52},{61.32,37.79},{61.3,38.84},{61.65,40.86},{60.66,40.1},{61.62,40.87},{61.8,36.79},{61.62,37.49},{62.4,37.62},{61.82,36.84},{60.84,39.69},{61.49,37.58},{61.1,38.72},{61.78,37.54},{61.81,36.83}}},nil,1657,nil,nil,80,"A",nil,0},
[3682] = {'Vrang Wildgore',2578,2578,48,48,0,{[17]={{35.11,26.7}}},nil,17,nil,nil,29,"H","Weaponsmith & Armorcrafter",4224},
[3683] = {'Kiknikle',1163,1163,32,32,0,nil,nil,0,nil,nil,69,"AH","Stylish Clothier",4224},
[3684] = {'Pizznukle',1221,1221,33,33,0,nil,nil,0,nil,nil,69,"AH","Leather Armor Merchant",4224},
[3685] = {'Harb Clawhoof',2218,2218,45,45,0,{[215]={{47.64,58.1}}},nil,215,nil,nil,104,"H","Kodo Mounts",131},
[3688] = {'Reban Freerunner',1753,1753,40,40,0,{[215]={{47.84,55.4}}},nil,215,nil,nil,104,"H","Pet Trainer",1},
[3689] = {'Laer Stepperunner',1981,1981,42,42,0,nil,nil,0,nil,nil,104,"H","Food & Drink",640},
[3690] = {'Kar Stormsinger',2138,2138,44,44,0,{[215]={{47.78,57.99}}},nil,215,nil,{14087,32670},104,"H","Riding Trainer",83},
[3691] = {'Raene Wolfrunner',61040,61040,60,60,1,{[331]={{36.62,49.58}}},nil,331,{13867,13872,26476,26480,26898},{990,1025,1029,1046,1054,10752,13645,13867,13868,26479,26482},124,"A",nil,3},
[3692] = {'Volcor',449,449,19,19,0,nil,nil,0,nil,{988,989,993},10,"A",nil,0},
[3693] = {'Terenthis',328,328,15,15,0,nil,nil,0,nil,{984,985,986,994,995},79,"A",nil,0},
[3694] = {'Sentinel Selarin',2420,2420,20,20,1,{[148]={{42.51,45.15}}},nil,148,{13542},{13542},80,"A",nil,3},
[3695] = {'Grimclaw',273,273,13,13,0,nil,nil,0,nil,nil,79,"A",nil,0},
[3696] = {'Ran Bloodtooth',1500,1500,26,26,0,{[331]={{54.75,79.62}}},nil,331,nil,nil,14,nil,nil,0},
[3697] = {'Kyln Longclaw',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Boar Trainer",0},
[3698] = {'Bolyun',1753,1753,40,40,0,{[331]={{17.98,60.04}}},nil,331,{13982},{13976,13982},80,"A","Pet Trainer",3},
[3699] = {'Nerra',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Cat Trainer",0},
[3700] = {'Jadenvis Seawatcher',2750,2750,51,51,0,{[357]={{45.47,41.16}}},nil,357,nil,nil,80,"A","Reagents",2176},
[3701] = {'Tharnariun Treetender',417,417,18,18,0,nil,nil,0,nil,{2118,2138,2139},79,"A",nil,1},
[3702] = {'Alanndarian Nightsong',417,562,21,22,0,nil,nil,0,nil,{2178,6122,6123},80,"A",nil,3},
[3703] = {'Krulmoo Fullmoon',1981,1981,42,42,0,{[4709]={{44.35,50.88}}},nil,4709,nil,nil,104,"H","Leatherworking Trainer",1},
[3704] = {'Mahani',1107,1107,31,31,0,{[4709]={{41.47,47.08}}},nil,4709,nil,nil,104,"H","Tailoring Trainer",81},
[3705] = {'Gahroot',713,713,25,25,0,{[4709]={{44.1,33.22}}},nil,4709,nil,nil,104,"H","Butcher",640},
[3706] = {'Tai\'jin',417,417,18,18,0,{[14]={{54.26,42.93}}},nil,14,nil,{5648,5649},126,"H","Priest Trainer",51},
[3707] = {'Ken\'jai',198,198,10,10,0,nil,nil,0,nil,nil,126,"H","Priest Trainer",49},
[3708] = {'Gruna',2964,2964,52,52,0,{[46]={{54.13,24.13}}},nil,46,nil,nil,29,"H","Food & Drink",640},
[3711] = {'Wrathtail Myrmidon',484,484,20,21,0,{[331]={{5.97,11.19},{5.11,14.99},{6.64,16.09},{5.67,12.48},{7.22,12.81},{7.19,15.24},{6.02,14.15},{6.56,14.43},{7.7,11.86},{7.22,11.91},{6.62,11.83},{7.24,13.62},{7.26,14.4}}},nil,331,nil,nil,74,nil,nil,0},
[3712] = {'Wrathtail Razortail',404,404,19,20,0,nil,nil,0,nil,nil,74,nil,nil,0},
[3713] = {'Wrathtail Wave Rider',484,484,19,20,0,{[331]={{10.32,11.79},{9.54,16.98},{9.78,11.54},{11,11.95},{9.44,12.28},{9.36,10.75},{12.34,11.74},{10.88,17.16},{8.34,15.17},{8.14,12.46},{11.72,17.17},{13.23,17.57},{9.48,14.85},{10.02,14.41},{7.67,28.15},{8.9,28.91},{8.53,28.64},{12.42,17.21},{9.37,13.99},{13.23,22.94},{11.83,14.44},{13.55,16.26},{12,19.16},{12.54,21.65},{12.03,23.74},{12.05,22.6},{12.46,23.55},{11.96,26.06},{11.66,26.03},{15.52,22.4},{15.14,23.31},{15.36,21.89},{7.89,29.46},{6.89,29.93},{9.37,30.71},{6.99,29.22},{14.2,20.5},{14.38,17.76},{13.76,15.33},{16,18.93},{16.24,19.46},{13.29,14.23},{14.26,16.82},{12.88,24.2},{15.52,23.23},{14.87,19.99},{13.97,27.76},{12.75,26.55},{13.71,24.19},{13.5,26.99},{11.72,13.36},{15.2,19.94},{15.4,20.88},{12.34,13.08},{13.11,31.2},{12.64,30.82},{11.08,30.19},{10.55,29.84},{11.78,28.67},{12.75,29.09},{14.11,28.92},{12.04,27.66},{11.37,29.1},{14.17,26.36},{10.79,29.12},{14.76,28.32},{14.86,27.22},{15.52,27.62},{15.27,25.78},{15.48,24.08},{14.79,24.8},{14.26,25.1},{14.61,21.04},{14.18,15.12},{15.12,17.11},{11.62,11.56},{11.73,13.46},{10.88,12.1},{9.78,11.59},{9.48,10.67},{12.33,13.03}}},nil,331,nil,nil,74,nil,nil,0},
[3715] = {'Wrathtail Sea Witch',433,433,19,20,0,nil,nil,0,nil,nil,74,nil,nil,0},
[3717] = {'Wrathtail Sorceress',379,379,19,20,0,{[148]={{29.32,91.58},{29.25,91.57}},[331]={{11.26,10.87},{11.63,11.52},{10.2,12.81},{8.99,15.99},{8.91,11.96},{10.89,28.05},{11.09,26.34},{10.96,27.12},{10.75,25.6},{5.41,28.9},{5.91,28.32},{11.47,26.89},{8.43,11.09},{10.7,14.54},{9.6,29.14},{9.85,13.32},{14.03,22.05},{10.73,15.73},{13.41,18.94},{8.54,13.51},{12.1,18.11},{12.32,20.53},{11.73,24.67},{15.34,18.82},{15.86,19.62},{12.48,14.54},{8.09,28.87},{9.97,26.83},{12.9,20.14},{13.26,21.32},{8.62,30.2},{13.51,19.79},{12.58,25.1},{12.87,15.96},{14.77,22.19},{13.4,15.23},{13.08,13.05},{14.32,18.96},{12.08,30.5},{13.7,30.19},{13.4,25.49},{12.93,25.93},{14.25,24.16},{12.55,29.96},{12.97,28.23},{12.2,29.29},{12.47,28.21},{13.42,29.51},{13.56,28.52},{14.63,26.01},{14.79,18.46},{15.44,17.92},{11.06,13.45},{14.51,23.25},{10.21,12.6},{10.35,11.63},{11.32,10.9},{12.32,11.72},{13.07,13.06},{11.16,13.45}}},nil,331,nil,nil,74,nil,nil,0},
[3718] = {'Wrathtail Tide Princess',225,239,1,1,4,nil,nil,0,nil,nil,35,"AH",nil,0},
[3721] = {'Mystlash Hydra',449,449,19,20,0,{[331]={{4.83,11.14},{9.06,13.13},{11.33,24.01},{10.05,15.16},{9.52,32.08},{10.03,33.03},{9.69,35.07},{8.91,35.02},{10.14,19.89},{9.21,17.42},{11.66,15.33},{8.86,25.19},{8.37,31.87},{7.29,31.1},{9.22,33.4},{8.24,33.61}}},nil,331,nil,nil,74,nil,nil,0},
[3722] = {'Mystlash Flayer',494,531,20,21,0,nil,nil,0,nil,nil,74,nil,nil,0},
[3725] = {'Dark Strand Cultist',354,379,18,19,0,{[331]={{27.65,33.37},{28.96,32.13},{31.49,30.08},{29.21,32.43},{32.1,30.04},{28.74,33.02},{29.57,30.29},{32.58,29.21},{28.96,29.94},{28.64,29.66},{30.06,31.36},{30.32,30.95},{30.33,31.84}}},nil,331,nil,nil,21,nil,nil,0},
[3727] = {'Dark Strand Enforcer',494,531,20,21,0,{[331]={{31.73,31.4},{28.36,33.21},{31.79,31.11},{31.6,31.18},{28.27,30.49},{31.62,30.72},{31.27,31.5}}},nil,331,nil,nil,21,nil,nil,0},
[3728] = {'Dark Strand Adept',354,379,18,19,0,{[331]={{28.43,31.68},{30.84,31.71},{28.27,32.63},{30.89,30.93},{31.05,30.26},{27.87,34.14},{29.67,31.9},{32.07,29.21},{31.5,29.23},{27.92,31.97},{27.45,31.12}}},nil,331,nil,nil,21,nil,nil,0},
[3730] = {'Dark Strand Excavator',449,484,19,20,0,{[331]={{28.01,31.11},{27.25,32.46},{30.91,29.67},{29.34,33.06},{31.32,30.96},{33.05,28.78},{29.9,30.43},{30.62,31.17}}},nil,331,nil,nil,21,nil,nil,0},
[3733] = {'Forsaken Herbalist',484,484,20,21,0,{[331]={{31.6,20.38},{31.21,21.07},{32.9,22.69},{32.02,24.94},{31.49,21.39},{31.66,23.24},{32.1,20.94},{30.89,22.12},{32.76,21.37},{30.29,22.75},{29.67,23.54},{30.98,23.13},{31.62,23.96},{32.15,23.82},{32.07,22.27},{32.23,21.69},{30.95,25.61},{29.78,25.8},{30.76,24.06},{30.06,23.9},{30.57,24.92},{31.48,22.69},{30,24.68},{32.16,23.38},{32.43,22.19},{32.94,21.85}}},nil,331,nil,nil,83,"H",nil,0},
[3734] = {'Orc Overseer',521,521,20,21,0,{[331]={{31.32,19.87},{30.97,21.31},{31.56,25.77},{32.28,24.21},{30.02,24.43},{29.78,22.75},{31.58,22.67},{32.42,23.23},{30.49,26.4},{29.31,25.81},{32.04,22.78},{30.5,23.63},{31.21,24.43},{32.69,21.54},{32.5,21.28}}},nil,331,nil,nil,83,"H",nil,0},
[3735] = {'Apothecary Falthis',694,694,22,22,4,{[331]={{32.15,23.36},{31.46,22.51}}},{[406]={{{71.57,96.04},{71.07,95.23},{70.6,93.6},{70.81,93.71},{71.05,95.06},{71.53,95.81},{72.47,96.57},{72.56,96.32}}}},331,nil,nil,118,"H",nil,0},
[3736] = {'Darkslayer Mordenthal',782,782,21,21,4,{[331]={{75.08,70.95}}},nil,331,nil,nil,118,"H",nil,0},
[3737] = {'Saltspittle Puddlejumper',449,484,19,20,0,nil,nil,0,nil,nil,18,nil,nil,0},
[3739] = {'Saltspittle Warrior',449,484,19,20,0,nil,nil,0,nil,nil,18,nil,nil,0},
[3740] = {'Saltspittle Muckdweller',494,531,20,21,0,nil,nil,0,nil,nil,18,nil,nil,0},
[3742] = {'Saltspittle Oracle',442,473,20,21,0,nil,nil,0,nil,nil,18,nil,nil,0},
[3743] = {'Foulweald Warrior',605,605,23,24,0,{[331]={{50.03,62.12},{50.6,60.44},{50.01,61.32},{51.15,60.53},{50.58,61.31},{49.42,61.41},{57.95,64.51},{57.41,65.48},{55.55,62.03},{54.4,61.56},{54.56,63.04},{56.44,64.89},{56.87,64.78},{53.97,62.46},{53.72,61.15},{53.58,63.74},{55.9,62.87}}},nil,331,nil,nil,82,nil,nil,0},
[3745] = {'Foulweald Pathfinder',605,605,23,23,0,{[331]={{50.65,59.71},{55.29,62.32},{56.84,65.52},{53.93,61.52}}},{[331]={{{53.84,61.29},{54.04,61.45},{54.15,61.57},{54.29,61.84},{54.13,61.96},{53.97,61.62},{53.77,61.2},{53.61,60.97},{53.41,60.77},{53.23,60.63},{53.17,60.26},{53.27,60.64},{53.52,60.84},{53.66,61.03}}}},331,nil,nil,82,nil,nil,0},
[3746] = {'Foulweald Den Watcher',664,713,24,25,0,nil,nil,0,nil,nil,82,nil,nil,0},
[3748] = {'Foulweald Shaman',582,622,24,25,0,nil,nil,0,nil,nil,82,nil,nil,0},
[3749] = {'Foulweald Ursa',664,713,24,25,0,nil,nil,0,nil,nil,82,nil,nil,0},
[3750] = {'Foulweald Totemic',571,571,23,24,0,{[331]={{49.92,60.18},{50,60.24},{51.72,60.51},{52.9,63.05},{49.42,60.4},{49.97,60.2},{56.71,65.74},{56.27,62.05},{54.07,63.26},{54.17,64.09},{53.91,64.36},{54.87,62.01},{56.19,65.05},{56.93,62.49},{57.35,64.18},{54.2,61.33},{53.39,62.97},{55.22,63.14}}},nil,331,nil,nil,82,nil,nil,0},
[3752] = {'Xavian Rogue',521,521,20,21,0,{[331]={{78.1,45.33},{78,44.29},{78.09,44.86},{78.66,45.34},{78.34,43.69},{78.53,44.79}}},nil,331,nil,nil,90,nil,nil,0},
[3754] = {'Xavian Betrayer',521,521,20,21,0,{[331]={{77.25,45.33},{78.4,46.46},{77.79,46.67},{78.56,47.55},{78.01,47.49},{79.61,45.94}}},nil,331,nil,nil,90,nil,nil,0},
[3755] = {'Xavian Felsworn',464,464,20,21,0,{[331]={{77.77,45.74},{78.3,45.6},{79.55,46.89},{78.96,46.63},{78.72,46.01}}},nil,331,nil,nil,90,nil,nil,0},
[3757] = {'Xavian Hellcaller',433,433,21,21,0,{[331]={{79.46,45.43},{77.54,46.19},{77.68,44.78},{79.07,45.56}}},nil,331,nil,nil,90,nil,nil,0},
[3758] = {'Felmusk Satyr',605,605,22,23,0,{[331]={{68.21,53.87},{66.33,54.25},{66.69,56.23},{67.07,55.81},{66.92,55.04}}},nil,331,nil,nil,90,nil,nil,0},
[3759] = {'Felmusk Rogue',521,521,21,22,0,{[331]={{66.18,56.37},{66.52,56.74}}},nil,331,nil,nil,90,nil,nil,0},
[3762] = {'Felmusk Felsworn',533,533,22,23,0,{[331]={{68.53,54.1},{67.51,54.86},{67.95,54.3},{66.25,55.72},{66.45,53.38},{66.18,53.44},{66.34,54.9}}},nil,331,nil,nil,90,nil,nil,0},
[3763] = {'Felmusk Shadowstalker',562,562,21,22,0,{[331]={{66.85,54.48},{66.87,56.86},{67.17,56.41},{66,55.3},{66.64,55.39},{66.72,57.15}}},nil,331,nil,nil,90,nil,nil,0},
[3765] = {'Bleakheart Satyr',484,484,19,20,0,{[331]={{79.59,49.26},{81.71,48.36},{80.09,49.43},{82.15,49.8},{82.74,50.14},{80.09,50.63},{80.46,48.56}}},nil,331,nil,nil,90,nil,nil,0},
[3767] = {'Bleakheart Trickster',484,484,19,20,0,{[331]={{81.13,48.48},{81.81,49.26},{80.72,49.08},{81.01,48.97},{81.72,49.17},{81.94,48.94},{80.72,49.69},{80.69,48.91},{81.46,51.15},{81.29,50.4}}},nil,331,nil,nil,90,nil,nil,0},
[3770] = {'Bleakheart Shadowstalker',404,404,19,20,0,{[331]={{81.31,49.3},{81.61,49.9},{80.5,49.74},{80.82,49.34},{81.23,51.51},{81.16,50.31}}},nil,331,nil,nil,90,nil,nil,0},
[3771] = {'Bleakheart Hellcaller',404,404,19,20,0,{[331]={{82.27,51.47},{80.77,51.36},{79.48,50.15},{80.77,50.29}}},nil,331,nil,nil,90,nil,nil,0},
[3772] = {'Lesser Felguard',610,610,24,25,0,{[331]={{28.64,60.22}}},nil,331,nil,nil,90,nil,nil,0},
[3773] = {'Akkrilus',976,976,26,26,4,{[331]={{25.62,63.54}}},{[331]={{{25.62,63.54},{25.94,63.69},{26.25,63.7},{26.61,63.69},{26.97,63.59},{27.24,63.44},{27.68,63.11},{28,62.8},{28.2,62.46},{28.35,62.01},{28.38,61.63},{28.4,61.09},{28.41,61.34},{28.36,61.88},{28.2,62.39},{27.99,62.71},{27.82,63.01},{27.57,63.39},{27.32,63.62},{26.99,63.74},{26.63,63.82},{26.28,63.86},{26.04,63.84},{25.67,63.81},{25.24,63.76},{24.95,63.7},{24.6,63.56},{24.25,63.39},{24.02,63.27},{23.67,63.11},{23.45,62.98},{23.12,62.73},{22.8,62.49},{22.55,62.25},{22.33,61.9},{22.18,61.62},{21.97,61.18},{21.83,60.79},{21.67,60.29},{21.59,60.03},{21.69,60.35},{21.78,60.69},{21.88,61.02},{22.05,61.47},{22.21,61.76},{22.37,62.03},{22.64,62.39},{22.84,62.59},{23.16,62.84},{23.38,62.99},{23.72,63.17},{23.95,63.28},{24.19,63.38},{24.54,63.51},{24.78,63.54},{25.1,63.56},{25.35,63.6}}}},331,nil,nil,90,nil,nil,0},
[3774] = {'Felslayer',699,699,24,25,0,{[331]={{27.39,64.25},{26.96,64.13},{28.61,61.54},{28.09,64.69},{26.43,63.89},{25.33,61.09},{24.61,63.56},{28.45,62.94},{21.57,59.82},{21.8,60.34},{28.33,62.52},{21.73,62.06},{23.36,63.28}}},nil,331,nil,nil,90,nil,nil,0},
[3777] = {'Aelyssa',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[3778] = {'Myielea Starwhisper',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[3779] = {'Syurana',3398,3398,55,55,0,{[618]={{48.55,40.76}}},nil,618,nil,nil,35,"AH","Trade Supplies",128},
[3780] = {'Singed Shambler',562,562,21,22,0,{[331]={{47.84,48.52},{45.96,48.22},{45.75,47.87},{46.64,44.02},{47.06,49.42},{47.04,45.09},{46.72,47.55},{47.5,47.9},{44.97,45.62},{47.05,46.21},{44.71,46.21},{44.74,45.27},{46.31,45.76},{48.2,46.29},{45.86,47.02},{45.33,45.88}}},nil,331,nil,nil,16,nil,nil,0},
[3781] = {'Shadethicket Wood Shaper',533,533,23,24,0,{[331]={{34.91,64.86},{33.86,64.95},{33.22,72.41},{32.17,64.88},{33.82,72.76},{32.04,69.31},{31.18,68.74},{31.58,67.69},{35.17,65.86},{33.58,70.1},{34.11,70.31},{33.38,69.36},{31.44,65.98},{33.75,68.21},{33.93,67.19},{35.36,67.4},{33.41,66.53}}},nil,331,nil,nil,16,nil,nil,0},
[3782] = {'Shadethicket Stone Mover',562,562,21,22,0,{[331]={{76.63,45.4},{85.34,67.63},{75.16,49.46},{76.72,49.13},{68.62,62.87},{84.08,64.87},{75.36,48.61},{78.79,53.45},{77.96,51.02},{85.77,68.15},{78.92,72.53},{79.9,72.7},{60.82,76.7},{62.05,74.95},{63.05,71.65},{75.26,49.54},{68.66,62.86},{75.35,48.6},{71.93,54.27},{75.76,42.71},{63.07,71.65},{74.25,46.41},{64.49,67.32}}},nil,331,nil,nil,16,nil,nil,0},
[3783] = {'Shadethicket Raincaller',533,533,22,23,0,{[331]={{32.7,72.4},{31.38,71.5},{32.86,71.09},{33.07,64.53},{32.98,68.39},{32.9,72.2},{33.96,67.4},{32.69,67.63},{35.62,67.24}}},nil,331,nil,nil,16,nil,nil,0},
[3784] = {'Shadethicket Bark Ripper',521,521,21,22,0,{[331]={{86.04,69.08},{69.89,57.95},{75.21,46.83},{74.37,47.92},{73.93,46.68},{70.74,56.01},{75.72,45.44},{73.05,52.54},{69.72,60.3},{82.32,64.09},{76.47,41.85},{74.26,50.73},{78.93,57.88},{72.18,54.57},{76.24,47.7},{79.41,61.85},{85.2,68.92},{81.35,63.67},{80.56,62.51},{79.29,73.73},{79.27,66.38},{80.54,73.34},{79.3,70.07},{59.64,78.41},{69.89,57.92},{69.68,60.35},{74.22,50.8},{66.71,64.41},{75.59,45.46},{75.54,43.62},{75.22,46.81},{76.11,47.72},{70.78,55.99},{65.55,65.45},{73.14,52.55},{74.52,47.98}}},nil,331,nil,nil,16,nil,nil,0},
[3789] = {'Terrowulf Fleshripper',896,950,28,29,0,nil,nil,0,nil,nil,38,nil,nil,0},
[3791] = {'Terrowulf Shadow Weaver',950,1003,29,30,0,nil,nil,0,nil,nil,38,nil,nil,0},
[3792] = {'Terrowulf Packlord',1048,1048,25,25,4,{[331]={{49.77,39.61},{53.08,37.51}}},{[331]={{{49.77,39.61},{49.89,39.61},{50.02,39.58},{50.21,39.52},{50.3,39.43},{50.35,39.29},{50.33,39.17},{50.29,39.1},{50.14,38.99},{50.01,38.94},{49.87,38.95},{49.78,39.08},{49.71,39.22},{49.66,39.44}}}},331,nil,nil,16,nil,nil,0},
[3793] = {'Initiate Druid',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3794] = {'Druid of the Talon',33534,33534,70,70,0,{[3606]={{-1,-1}}},nil,3606,nil,nil,1718,"AH",nil,0},
[3795] = {'Druid of the Claw',33534,33534,70,70,0,{[3606]={{-1,-1}}},nil,3606,nil,nil,1718,"AH",nil,0},
[3796] = {'Druid of the Wild',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3797] = {'Cenarion Protector',498,498,22,23,0,{[331]={{62.25,50.87},{62.13,51.01},{61.97,50.84},{62.04,50.76},{61.93,51.73},{62.18,51.16}}},nil,331,nil,nil,124,"A",nil,0},
[3799] = {'Severed Druid',433,433,20,21,0,{[331]={{74.3,78.89},{76.1,72.29},{74.77,74.19},{77.39,72.64},{75.41,72.95},{76.47,73.57},{76.74,72.41},{77.82,74.32},{76.26,74.54},{75.77,74.52},{74.41,77.39},{73.61,76.72},{74.87,76.86},{74.62,73.33},{75.09,73.78},{74.74,75.23},{75.47,75.09},{75.91,74.71},{75.04,75.93},{76.69,75.97},{77.33,75.26},{77.3,72.95},{78.32,75.29},{77.37,75.9},{77.23,74.7},{78.4,75.01},{76.74,74.15},{77.92,73.4},{76.07,73.17},{75.42,75.14},{76.73,75.99},{76.19,75.4},{77.96,73.97},{75.25,73.97},{77.29,72.98},{76.72,74.1},{77.49,74.77},{77.29,72.97},{75.31,73.39},{74.41,77.37},{75.78,74.48}}},nil,331,nil,nil,16,nil,nil,0},
[3801] = {'Severed Sleeper',769,812,28,29,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3802] = {'Severed Dreamer',739,774,29,30,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3803] = {'Severed Keeper',464,464,20,21,0,{[331]={{75.74,73.63},{76.93,73.39},{73.76,78.55},{73.9,74.22},{75.26,73.95},{74.14,76.54},{74.6,76.15},{74.23,74.41},{75.65,76.36},{74.01,75.49},{76.36,75.19},{77.44,74.55},{77.96,73.93},{77.34,73.93},{75.27,73.11},{76.66,73.53},{76.92,74.89},{75.45,74.65},{75.27,73.1},{75.73,76.14},{76.14,75.37},{75.76,74.49},{76.26,74.56},{76.07,73.2},{76.65,73.5},{75.27,73.09},{75.41,73.85},{73.74,78.5},{77.32,73.88},{76.2,75.38},{75.42,75.15},{76.88,74.88},{75.79,76.18},{73.92,74.27},{74.46,74.45},{78.32,75.27},{74.04,75.49},{76.08,73.15},{75.26,73.96},{74.73,74.15},{74.14,76.5}}},nil,331,nil,nil,16,nil,nil,0},
[3804] = {'Forsaken Intruder',896,950,28,29,0,nil,nil,0,nil,nil,118,"H",nil,0},
[3806] = {'Forsaken Infiltrator',950,1003,29,30,0,nil,nil,0,nil,nil,118,"H",nil,0},
[3807] = {'Forsaken Assassin',950,1003,29,30,0,nil,nil,0,nil,nil,118,"H",nil,0},
[3808] = {'Forsaken Dark Stalker',896,950,28,29,0,nil,nil,0,nil,nil,118,"H",nil,0},
[3809] = {'Ashenvale Bear',484,484,19,20,0,{[331]={{33.68,31.52},{45.17,42.33},{30.2,46.3},{39.12,55.26},{39.45,56.71}}},nil,331,nil,nil,44,nil,nil,0},
[3810] = {'Elder Ashenvale Bear',562,562,21,22,0,{[331]={{73.66,47.45},{73.2,50.82},{87.73,68.4},{68.75,60.92},{69.3,58.16},{69.02,59.48},{69.48,56.58},{71.42,53.55},{70.72,54.72},{72.08,52.21},{69.2,52.43},{64.5,54.28},{66.9,49.03},{53.98,56.43},{55.17,54.21},{55.03,56.14},{54.73,53.47},{56.95,55.34},{62.13,66.6},{63.86,56.36},{63.44,68.02},{56.16,54.46},{64.32,66.19},{66.07,63.56},{73.13,50.86},{69.61,50.13},{69.09,50.87},{63.75,55.3},{67.01,51.38},{63.87,53.44},{61.21,60.13},{65.42,64.77},{70.2,50.83},{70.79,49.6},{71.33,49.19},{67.38,50.03},{58.16,53.56},{69.74,51.68},{66.29,62.26},{65.36,62.53},{65.94,60.58},{64.42,59.4},{66.77,62.87},{64.45,64.87},{64.98,63.86},{69.21,58.47},{68.63,60.73},{71.98,52.59},{70.27,55.22},{70.74,54.68},{71.37,53.48},{59.02,53.91},{41.78,60.44},{44.01,58.36},{54.87,50.83},{56,50.78},{64.34,54.42},{44.79,58.05},{53.81,56.68},{55.56,51.68},{55.24,54.28},{54.97,56.05},{54.73,53.4},{56.99,55.39},{56.21,54.42},{63.84,55.28},{63.91,53.61},{61.18,59.85},{58.26,53.77},{44.12,58.64},{44.91,58.32},{41.46,69.61},{37.91,68.36},{40.73,65.69},{41.51,66.57},{36.11,70.35},{41.86,68.99},{38.45,70.7},{36.9,68.4},{40.37,66.75},{40.32,71.95},{37.37,71.14},{37.78,59.92}}},nil,331,nil,nil,44,nil,nil,0},
[3811] = {'Giant Ashenvale Bear',1176,1242,29,30,0,{[331]={{82.1,46.61},{82.62,46.89},{81.53,46.61},{82.74,47.9},{82.55,47.51}}},nil,331,nil,nil,44,nil,nil,0},
[3812] = {'Clattering Crawler',449,449,20,20,0,{[148]={{26.24,90.87},{27.82,90.6}},[331]={{7.77,17.87},{9.57,32.61},{6.04,15.83},{8.89,16.36},{9.6,17.22},{8.37,16.98},{10.2,33.39},{10.2,25.19},{7.2,16.9},{5.91,31.01},{8.49,19.08},{5.65,28.3},{9.09,29.35},{13.02,22.18},{8.43,11.94},{12.52,23.11},{13.53,29.89},{10.42,27.15},{14.27,27.58},{13.68,23.42},{12.5,19.49},{8.42,13.5},{7.15,28.03},{12.49,21.35},{13.82,21.07},{10.36,21.14},{10.14,16.07},{12.94,18.79},{13.75,28.25},{6.4,13.71},{14.19,22.35},{9.45,27.25},{14.81,18.02},{9.16,11.64},{12.55,12.75},{10.22,14.62},{13.65,19.74},{10.62,15.31},{6.56,12.69},{7.38,13.95},{9.53,34.52},{10.02,35.06},{9.01,33.57},{8.41,34.86},{7.7,33.54},{7.76,31.74},{8.7,29.82},{9.37,30.8},{7.5,29.57},{10.93,30.84},{10.03,31.45},{13.51,14.64},{14.1,18.75},{14.7,14.57},{14.19,17.04},{12.84,30.78},{12.39,31.54},{12.54,30.1},{13,30.08},{11.26,28.28},{11.87,29.17},{12.56,28.4},{14.7,28.07},{15.05,24.79},{15.02,25.86},{11.92,13.54},{12.27,12.55}}},nil,331,nil,nil,7,"AH",nil,0},
[3814] = {'Spined Crawler',484,484,20,21,0,{[331]={{9.12,18.15},{10.58,18.71},{10.72,16.93},{7.81,10.99},{8.78,35.45},{9.04,14.49},{6.66,30.1},{9.27,31.64},{9.66,19.52},{11.84,17.01},{7.88,35.41},{8.84,19.44},{4.32,12.73},{8.27,15.66},{11.22,30.4},{9.17,28.47},{8.81,26.44},{7.73,26.88},{10.23,28.52},{10.41,26},{5.25,13.44},{6.14,11.35},{11.29,21.6},{13.06,20.67},{11.93,20.84},{10.71,24.28},{11.95,22.14},{11.2,23.26},{11.03,24.72},{11.25,16.05},{9.61,15.79},{14.52,16.59},{12.43,14.84},{13.55,16.39},{13.01,17},{13.53,17.84},{15.54,15.64},{11.94,15.76},{12.78,27.59},{9.39,13.45},{12.86,25.94},{14.14,29.26},{15.36,22.67},{15.29,22.06},{11.99,31.17},{15.35,21.28},{11.2,14.44},{11.74,13.76},{13.09,15.62},{14.06,15.46},{12.39,16.16},{12.02,27.34},{11.88,19.03},{10.28,30.04},{12.77,29.35},{15.41,27.47},{13.98,25.25},{9.32,11.64}}},nil,331,nil,nil,7,"AH",nil,0},
[3815] = {'Blink Dragon',562,562,22,23,0,{[331]={{53.4,45.62},{52.68,45.8},{61.93,51.17},{53.14,46.61},{52.98,46.01},{53.48,46.24},{62.12,50.84},{61.96,50.97},{60.17,71.52},{62.14,51.31}}},nil,331,nil,nil,2136,"AH",nil,0},
[3816] = {'Wild Buck',484,484,19,20,0,{[148]={{45.69,92.5},{46.11,93.55},{45.34,92.43},{44.4,92.44},{45.91,93.48}},[331]={{25.64,15.44},{27.92,18.43},{28.23,17.02},{28.77,18.04},{26.93,15.4},{27.52,18},{29.42,20.62},{29.86,17.96},{30.79,19.49},{30.07,16.75},{28.8,15.92},{32.73,26.73},{31.97,26.75},{16.57,16.98},{28.81,22.01},{27.36,23.37},{26.38,35.1},{31.04,27.32},{30.23,27.32},{19.7,17.15},{28.42,26.61},{23.91,26.42},{24.66,25.99},{22.13,26.77},{23.92,23.76},{21.76,19.55},{22.85,38.68},{24.68,37.65},{23.91,38.5},{25.03,36.23},{29.08,27.29},{17.8,36.18},{16.35,35.81},{17.55,37.65},{17.1,37.05},{17.06,38.83},{21.67,37.02},{22.11,35.74},{23.44,31},{21.49,32.5},{22.83,33.39},{23.48,35.95},{22.39,34.39},{23.38,34.5},{22.17,33.29},{23.43,32.5},{23.87,36.81},{22.38,21.09},{19.94,19.47},{24.71,21.99},{28.69,22.97},{26.82,20.67},{26.39,16.28},{18.7,32.65},{19.9,32.7},{20.04,34.34},{19.37,35.33},{19.82,27.46},{18.79,34.52},{19.64,36.31},{18.69,25.8},{18.33,23.7},{19.15,21.92},{20.47,29.13},{17.04,28.16},{20.31,31.1},{17.67,31.33},{18.73,29.09},{22.11,30.84},{22.86,29.92},{25.04,28.62},{22.87,28.38},{22.38,29.04},{25.09,24.84},{26.86,17.21},{26.23,19.68},{26.43,17.61},{16.08,24.96},{16.57,21.43},{18.5,18.06},{16.36,23.54},{17.2,20.68},{28.92,16.1}}},nil,331,nil,nil,31,"AH",nil,0},
[3817] = {'Shadowhorn Stag',521,521,21,22,0,{[331]={{70.08,61.46},{85.66,44.76},{71.48,56.3},{72.37,56.15},{86.06,42.32},{88.7,40.71},{90.09,48.3},{71,57.25},{72.65,54.5},{70.11,62.9},{83.33,48.13},{70.36,58.28},{75.98,56.02},{85.64,45.99},{69.18,63.32},{72.05,57.69},{86.94,42.33},{78.19,56.83},{76.69,55.03},{75.49,53.83},{86.73,46.6},{83.55,50.49},{73.91,56},{72.92,56.61},{87.21,45.83},{70.29,68.58},{94.51,46.51},{70.45,60.11},{90.67,50.79},{86.87,45.64},{71.88,56.56},{85.35,45.2},{74.73,56.15},{85.98,43.66},{76.62,56.58},{75.94,52.74},{86.22,46.73},{70.92,62.21},{84.07,47.98},{76.55,53.56},{87.36,49.13},{93.62,46.01},{91.45,45.41},{92.3,45.47},{93.1,47.45},{92.45,47.26},{90.64,45.18},{86.55,49.59},{86.86,44.18},{86.91,44.6},{83.88,45.58},{84.58,44.87},{84.08,44.45},{84.69,46.21},{84.2,46.57},{77.07,58.75},{76.12,57.73},{87.42,43.86},{88.28,43.27},{89.15,41.56},{70.91,70.46},{70.67,70.53},{71.49,70.2},{66.33,69.22},{67.49,69.49},{71.47,56.46},{70.99,57.34},{70.29,58.13},{70.47,59.61},{71.93,56.84},{65.83,66.76},{70.13,61.26},{69.24,63.55},{72.63,54.53},{53.34,48.1},{53.93,50.93},{53.74,49.12}}},nil,331,nil,nil,189,"AH",nil,0},
[3818] = {'Elder Shadowhorn Stag',605,605,23,24,0,{[331]={{54.09,52.57},{64.63,44},{65.51,43.66},{58.12,57.32},{64.34,50.86},{66.68,45.99},{55.99,52.98},{66.21,45.19},{64.12,46.51},{66.55,47.4},{62.3,47.45},{61.08,45.68},{61.58,46.37},{54.53,55.31},{56.28,56.2},{54.07,54.23},{55.71,55.13},{56.32,57.84},{41.35,63.79},{52.57,35.36},{48.27,63.29},{53.37,32.86},{44.75,59.21},{49.43,62.97},{54.08,32.71},{41.4,61.79},{58.16,57.31},{64.33,50.42},{41.55,59.62},{54.84,32.05},{56.02,52.92},{64.08,46.52},{61.67,41.36},{55.85,42.72},{45.74,66.18},{54.45,29.81},{62.35,47.34},{55.25,33.63},{52.93,36.85},{60.34,44.7},{44.27,57.69},{56.44,34.39},{60.99,45.61},{52.16,64.13},{53.01,37.29},{60.78,47.24},{59.14,35.83},{54.11,31.02},{56.54,36.74},{61.6,46.32},{59.31,43.08},{59.91,38.51},{57.8,36.47},{60.33,39.59},{58.34,34.88},{59,37.19},{58.77,33.62},{56.81,29.41},{56.26,29.4},{59.49,37.62},{56.28,30.8},{58.07,30.91},{57.18,34.53},{56.52,35.24},{57.41,30.85},{57.76,32.54},{56.51,31.88},{54.1,34.74},{56.87,37.82},{55.59,34.82},{57.04,39.89},{57.8,38.64},{56.6,42.02},{57.63,42.34},{54.74,55.41},{56.19,55.72},{54.07,54.09},{55.79,55.06},{56.24,57.96},{41.27,63.65},{38.49,60.07},{41.41,59.35},{41.2,67.77},{37.73,71.4},{40.8,72.65},{41.51,71.26},{40.87,70.93},{45.96,66.16},{44.31,57.82},{39.29,69.78},{38.13,66.52},{38.82,66.38},{42.56,68.18},{42.42,70.09},{40.13,69.86},{44.02,70.06},{36.25,65.01},{38.51,67.28},{36.66,62.01},{35.46,63.93},{36.66,66.61},{52.36,64.33},{36.03,68.8},{38.7,58.82},{37.04,67.27},{41.84,65.59},{35.11,69.27},{39.46,58.69},{36.82,71.48},{38.58,69.03},{37.32,60.48},{37.3,62.25},{39.57,65.72},{57.43,32.45},{57.84,30.89},{56.78,29.46},{57.31,30.83},{56.77,33.31}}},nil,331,nil,nil,189,"AH",nil,0},
[3819] = {'Wildthorn Stalker',449,449,20,20,0,{[331]={{47.39,57.43},{43.2,55.9},{48.11,55.47},{42.2,57.61},{16.65,44.73},{24.48,53.6},{33.54,41.12},{42.43,46.99},{18.78,48.16},{40.92,54.2},{41.66,54.77},{27.4,52.7},{25.86,51.85},{20.99,49.88},{18.3,47.39},{22.18,48.29},{22.16,57.11},{23.91,52.31},{35.14,57.04},{32.47,37.73},{43.13,55.87},{37.91,40.79},{22.92,47.6},{23.42,46.61},{45.44,52.49},{42.02,42.82},{33,32.21},{33.93,60.72},{23.74,47.74},{24.51,55.12},{22.28,46.35},{26.99,51.58},{23.25,48.81},{20.72,49.2},{22.81,56.07},{34.44,31.15},{46.05,51.83},{24.77,50.59},{45.3,44.04},{19.61,50.7},{19.61,48.16},{31.47,42.27},{41.21,44.01},{19.47,49.36},{17.15,45.98},{25.52,53.41},{32,37.33},{40.02,57.01},{19.5,54.2},{43.49,41.55},{40.49,55.41},{44.28,42.1},{39.27,38.89},{44.35,50.23},{42.84,43.57},{27.83,55.59},{33.3,53.61},{27.53,54.2},{34.8,60.24},{37.39,57.6},{32.09,52.65},{33.83,58.73},{34.35,57.89},{32.51,59.35},{28.66,54.47},{33.34,59.83},{17.71,46.52},{31.33,58.05},{30.3,58.62},{40.08,50.06},{35.06,55.31},{32.77,36.54},{43.63,47.39},{18.54,51.87},{34.31,59.33},{30.36,54.87},{41.45,51.6},{31.79,59.65},{30.63,56.21},{26.21,49.28},{25.23,42.86},{29.58,57.98},{29.94,56.53},{30.27,51.85},{31.42,51.72},{17.54,51.5},{21.62,49.27},{29.84,50.25},{41,49.96},{36.05,56.83},{31.04,49.07},{42.87,44.46},{43.28,45.91},{37.99,38.73},{41.97,57.88},{36.04,39.72},{41.32,40.62},{32.2,49.41},{28.29,57.75},{39.49,37.59},{41.71,39.48},{26.27,43.46},{27.34,46.95},{20.6,52.06},{31.65,50.22},{17.12,47.54},{30.3,50.02},{31.34,48.06},{39.55,41.46},{45.16,55.12},{30.48,41.08},{38.46,56.22},{38.85,40.41}},[406]={{49.26,29.54}}},nil,331,nil,nil,22,nil,nil,0},
[3820] = {'Wildthorn Venomspitter',521,521,21,22,0,{[331]={{72.31,51.73},{90.99,48.4},{88.63,44.03},{91.38,50.49},{92.95,56.26},{90.13,67.53},{88.59,66.34},{93.2,52.84},{88.8,68.33},{86.98,68.49},{80.62,45.75},{88.17,42.22},{87.68,40.45},{70.24,55.05},{92.82,44.36},{93.24,53.84},{89.98,46.42},{92.24,50.67},{88.73,42.9},{89.42,45.45},{89.76,68.16},{90.83,55.34},{81.23,44.92},{73.75,50.19},{82.9,62.67},{82.41,47.53},{89.08,47.05},{92.95,51.93},{89.96,60.6},{81.66,60.63},{82.29,62.09},{81.12,61.83},{89.75,44.25},{82.35,46.72},{82.59,48.93},{81.26,46.43},{88.32,48.06},{65.07,79.45},{65.94,78.07},{62.83,81.76},{66.7,79.89},{65.34,79.76},{64.78,79.32},{65.9,77.66},{66.62,80.11},{65.41,79.58},{64.95,76.01},{62.86,77.55},{63.37,79.35},{61.29,77.66},{63.97,75.78},{62.62,80.58},{62.14,78.7},{63.29,77},{64.63,79.28},{65.89,77.66},{62.7,81.78},{66.6,76.92},{62.94,74.75},{66.68,79.87},{63.76,68.06},{65.36,79.52},{72.35,51.72},{66.44,50.3},{67.88,50.79},{72.49,49.66},{73.65,47.45},{68.98,59.73},{62.59,55.71},{68.53,51.66},{62.77,68.05},{64.36,57.78},{63.56,52.26},{63.93,67},{72.13,48.54},{63.32,54.5},{74.23,45.4},{73.11,46.61},{72.5,47.32},{68.31,50.22},{68.14,61.64},{67.73,62.71},{65.01,60.14},{69.6,56.38},{62.49,55.54},{63.36,52.07},{63.21,54.47}}},nil,331,nil,nil,22,nil,nil,0},
[3821] = {'Wildthorn Lurker',605,605,23,24,0,{[331]={{80.69,74.25},{71.2,82.65},{68.73,80.62},{69.18,79.45},{70.18,80.9},{71.24,82.62},{57.76,73.65},{57.1,74.05},{56.85,75.92},{57.42,77.28},{53.29,72.53},{58.71,71.8},{54.13,70},{55.27,68.57},{55.18,69.79}}},nil,331,nil,nil,22,nil,nil,0},
[3823] = {'Ghostpaw Runner',449,449,19,20,0,{[331]={{23.35,55.21},{26.94,18.71},{29.83,52.91},{26.42,14.28},{29.86,13.44},{22.87,43.89},{32.14,50.89},{17.14,23.09},{27.68,27.94},{27.36,25.48},{16.73,19.86},{23.58,37.76},{18.15,35.25},{17.5,39.61},{23.28,29.28},{21.64,29.59},{24.25,28.47},{17.96,27.35},{20.82,32.3},{23.88,35.77},{22.79,35.23},{25.32,20.24},{25.62,22.36},{29.71,19.19},{20.64,19.51},{17.24,25.15},{29.18,53.62},{18.27,26.14},{18.14,31.93},{16.49,27.56},{19.35,33.63},{17.67,18.7},{30.06,13.47},{26.55,14.15}}},nil,331,nil,nil,38,nil,nil,0},
[3824] = {'Ghostpaw Howler',562,562,21,22,0,{[331]={{72.19,55.76},{74.54,55.41},{70.27,64.54},{73.08,55.09},{75.85,54.55},{78.83,51.19},{77.8,55.25},{77.93,49.06},{78.19,49.73},{65.15,69.07},{66.49,69.95},{65.22,69.19},{72.13,55.2},{68.67,63.96}}},nil,331,nil,nil,38,nil,nil,0},
[3825] = {'Ghostpaw Alpha',605,605,23,24,0,{[331]={{64.92,78.01},{73.83,80.7},{71.49,84.21},{79.64,74.55},{71.09,83.69},{71.39,79.26},{67.4,83.43},{70.69,81.19},{72.01,82.28},{66.88,78.69},{71.47,84.15},{70.9,83.96},{71.76,79.56},{68.35,79.27},{70.89,80.97},{71.92,82.42},{67.51,83.13},{59.09,78.23},{63.82,77.74},{60.07,76.77},{64.8,77.98},{66.9,78.26},{65.79,76.42},{66.72,74.45},{63.5,73.27},{68.57,79.32},{61.99,70.54},{68.22,75.98},{67.77,74.89},{68.28,74.2},{67.32,83.24},{62.04,70.27},{62.85,44.75},{52.92,34.06},{59.31,72.66},{56.86,77.68},{57.39,78.48},{59.07,78.16},{51.74,77.06},{55.79,74.27},{54.7,71.15},{53.94,73.35},{56.45,75.06},{56.89,69.06},{59.21,67.48},{57.64,68.22},{55.89,70.66},{58.11,70.65},{54.73,69.14},{58.15,72.24},{60.4,71.28},{54.01,71.63},{58.05,65.33},{55.9,69.11},{53.64,70.92},{60.29,43.33},{56.48,33.33},{57.18,39.56},{59.13,41.25},{62.7,44.93},{56.38,69.91},{58.63,66.28},{60.76,71.6},{59.18,73.77},{56.51,68.3},{58.7,33.76}}},nil,331,nil,nil,38,nil,nil,0},
[3826] = {'Rabid Ghostpaw',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3831] = {'Shade of Shadumbra',6050,6050,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[3832] = {'Cenarion Steward',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3833] = {'Cenarion Vindicator',533,533,22,23,0,{[331]={{62.22,51.23},{61.96,51.1}}},nil,331,nil,nil,124,"A",nil,0},
[3834] = {'Crazed Ancient',562,562,22,23,0,{[331]={{64.43,49.48},{58.41,36.36},{54.69,36.56},{54.76,34.99},{62.19,44.65},{60.32,38.6},{54.5,39.55},{54.39,40.58},{54.46,39.48},{57.63,39.16},{58.63,41.78},{54.96,40.6},{59.58,43.59},{57.97,34.25}}},nil,331,nil,nil,91,nil,nil,0},
[3835] = {'Biletoad',8,8,1,1,0,{[718]={{-1,-1}},[3711]={{42.91,56.89},{39.01,58.78},{45.38,53.86},{40.3,52.85},{46.6,57.52},{50.86,49.59},{46.08,57.68},{53.28,53.45},{42.95,52.48},{37.56,66.93},{45.32,56.26},{39.74,54.77},{45.58,51.96},{51.34,53.79},{48.03,55.14},{43.41,57.07},{49.8,70.42},{48.18,75.22},{49.85,74.47},{46.24,63.05},{49.16,71.77},{46.36,57.65},{46.17,64.75},{46.92,66.49},{50.01,64.91},{45.96,58.4},{42.92,52.37},{46.63,71.08},{44.91,55.57},{45.61,51.59},{47.61,55.97},{47.78,61.04},{37.44,67.06},{50.93,49.7},{46.51,71.19},{46.92,66.51},{45.33,69.78},{45.21,68.96},{51.15,58.52},{54.37,58.33},{46.72,64.72},{41.82,69.74},{45.65,53.22},{40.87,72.69},{48.15,55.04},{52.73,56.35},{53.54,57.55},{36.24,59.84},{50.3,62.97},{50.96,53.21},{46.11,57.43},{50.01,64.71},{43.03,60.26},{46.37,63.16},{47.83,60.83},{46.37,57.71},{49.81,61.95},{45.26,56.24},{52.52,60.94},{52.98,53.22},{49.63,70.23},{50.19,62.85},{49.2,71.72},{46.15,64.2},{51.11,53.99},{46.05,63.11},{47.79,60.81},{49.94,64.84},{45.26,53.25},{44.89,55.22},{51.95,67.78},{47.94,55.72},{45.33,51.96},{46.5,58.43},{45.98,58.49},{50.03,74.47},{47.09,66.42},{53.28,65.28},{53.23,53.15},{51.49,71.37},{43.26,56.7},{43.82,59.94},{50.88,49.93},{49.54,61.53},{43.67,74.96},{49.61,70.31},{50.27,63.32},{48.47,75.47},{49.59,71.82},{46.57,70.93},{46.4,64.12},{51.11,53.86},{46,63.29},{54.67,58.18},{47.97,60.65},{49.81,64.76},{45.67,53.32},{44.96,55.9},{52.11,67.55},{48.31,54.82},{45.36,52.18},{53.97,61.23},{46.51,58.05},{46.01,57.33},{50.11,73.7},{51.08,58.99},{47.42,66.28},{53.74,65.32},{53.38,53.18},{46.58,75.21},{52.12,71.62},{52.49,61.34},{43.06,56.32},{43.95,59.93},{50.92,49.98},{49.91,62},{49.17,72.5},{50.3,62.94},{42.32,63.21},{46.32,64.27},{52,67.84},{41.58,58.34},{52.21,71.22},{49.59,69.62},{53.78,65.31},{43.6,75.01},{48.51,75.6},{40.72,60.21},{46.53,75.78},{43.26,60.39},{37.61,67.15},{47.79,60.58},{49.58,61.08},{50.26,65.26},{45.99,63.42},{47.14,66.45}}},nil,3711,nil,nil,7,"AH",nil,0},
[3836] = {'Mountaineer Pebblebitty',2138,2138,44,44,0,{[38]={{18.19,84.03}}},nil,38,nil,{3181,3201},55,"A",nil,1},
[3837] = {'Riding Hippogryph',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3838] = {'Vesprystus',232470,232470,85,85,1,{[141]={{55.41,88.4}}},nil,141,nil,{26757},80,"A","Hippogryph Master",8195},
[3839] = {'Voidlasher',75,80,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[3840] = {'Druid of the Fang',1616,1616,19,19,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,nil,0},
[3841] = {'Teldira Moonfeather',232470,232470,85,85,1,{[148]={{51.72,17.65}}},nil,148,nil,nil,80,"A","Hippogryph Master",8193},
[3842] = {'Brombar Higgleby',1753,1753,40,40,0,{[1537]={{52.57,37.26}}},nil,1537,nil,nil,55,"A","The Keymaster",0},
[3843] = {'Anaya',5900,5900,70,70,0,{[148]={{50.85,17.88}}},nil,148,nil,nil,80,"A",nil,0},
[3844] = {'Healing Ward IV',12,12,21,22,0,nil,nil,0,nil,nil,109,nil,nil,0},
[3845] = {'Shindrell Swiftfire',3050,3050,25,25,1,{[331]={{18.23,20.42}}},nil,331,{13602,26897},{1008,1133,1134,13602},1076,"A",nil,3},
[3846] = {'Talen',2605,2605,21,21,1,{[331]={{18.22,20.52}}},nil,331,{26465,26466},{1007,1009,13617,26465,26466},1076,"A",nil,3},
[3847] = {'Orendil Broadleaf',690,690,27,27,0,{[331]={{26.84,36.64}}},nil,331,{13642,13645,26463,26474},{1023,13623,13642,26464},1076,"A",nil,2},
[3848] = {'Kayneth Stillwind',1006,1006,31,31,0,{[331]={{85.21,44.4}}},{[331]={{{85.24,44.71},{85.25,44.44},{85.21,44.4},{85.23,44.57},{85.24,44.71}}}},331,{26455},{1011,4261,4581,9519,26455},80,"A",nil,3},
[3849] = {'Deathstalker Adamant',1251,1251,18,18,1,nil,nil,0,nil,{1005},68,"H",nil,1},
[3850] = {'Sorcerer Ashcrombe',1062,1062,18,18,1,nil,nil,0,nil,{1006},12,"A",nil,1},
[3851] = {'Shadowfang Whitescalp',1100,1212,18,19,1,nil,nil,0,nil,nil,14,nil,nil,0},
[3853] = {'Shadowfang Moonwalker',1200,1212,19,19,1,nil,nil,0,nil,nil,14,nil,nil,0},
[3854] = {'Shadowfang Wolfguard',1452,1452,20,20,1,nil,nil,0,nil,nil,14,nil,nil,0},
[3855] = {'Shadowfang Darksoul',1212,1212,19,19,1,nil,nil,0,nil,nil,14,nil,nil,0},
[3857] = {'Shadowfang Glutton',1347,1347,19,19,1,nil,nil,0,nil,nil,14,nil,nil,0},
[3859] = {'Shadowfang Ragetooth',1452,1452,20,20,1,nil,nil,0,nil,nil,14,nil,nil,0},
[3861] = {'Bleak Worg',1300,1563,18,19,1,nil,nil,0,nil,nil,24,nil,nil,0},
[3862] = {'Slavering Worg',1200,1563,18,19,1,nil,nil,0,nil,nil,24,nil,nil,0},
[3863] = {'Lupine Horror',1452,1563,20,20,1,nil,nil,0,nil,nil,14,nil,nil,0},
[3864] = {'Fel Steed',1796,1796,19,19,1,{[209]={{-1,-1}}},nil,209,nil,nil,15,"AH",nil,0},
[3865] = {'Shadow Charger',1668,1668,18,19,1,{[209]={{-1,-1}}},nil,209,nil,nil,15,"AH",nil,0},
[3866] = {'Vile Bat',1452,1452,20,20,1,nil,nil,0,nil,nil,14,nil,nil,0},
[3868] = {'Blood Seeker',328,328,15,15,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3869] = {'Lesser Gargoyle',750,800,20,20,1,{[209]={{-1,-1}}},nil,209,nil,nil,16,nil,nil,0},
[3870] = {'Stone Sleeper',1936,1936,20,20,1,{[209]={{-1,-1}}},nil,209,nil,nil,16,nil,nil,0},
[3872] = {'Deathsworn Captain',3126,3126,21,21,2,{[209]={{-1,-1}}},nil,209,nil,nil,16,nil,nil,0},
[3873] = {'Tormented Officer',1936,1936,20,20,1,{[209]={{-1,-1}}},nil,209,nil,nil,16,nil,nil,0},
[3875] = {'Haunted Servitor',1936,1936,19,20,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3877] = {'Wailing Guardsman',1796,1796,19,19,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3878] = {'Magthrull\'s Doomguard',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3879] = {'Dark Strand Assassin',531,531,21,21,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3880] = {'Sentinel Melyria Frostshadow',699,699,25,25,0,{[331]={{59,58.75}}},nil,331,{13928,26456},{1022,13935},80,"A",nil,2},
[3881] = {'Grimtak',300,300,14,14,0,{[14]={{50.73,42.83}}},nil,14,{6365},{6386},29,"H","Butcher",643},
[3882] = {'Zlagk',0,0,9,9,0,{[6451]={{42.63,62.24}}},nil,6451,nil,nil,29,"H","Butcher",640},
[3883] = {'Moodan Sungrain',0,0,11,11,0,{[6452]={{26.98,31.01}}},nil,6452,nil,nil,104,"H","Baker",640},
[3884] = {'Jhawna Oatwind',273,273,13,13,0,{[215]={{47.77,60.83}}},nil,215,nil,nil,104,"H","Baker",640},
[3885] = {'Sentinel Velene Starstrike',699,699,25,25,0,{[331]={{35.63,71.49}}},nil,331,{26470,26838},{1016,1017,13964,26470},80,"A",nil,3},
[3886] = {'Razorclaw the Butcher',1936,1936,20,20,1,nil,nil,0,nil,nil,14,nil,nil,0},
[3887] = {'Baron Silverlaine',13025,13025,21,21,1,{[209]={{-1,-1}}},nil,209,nil,nil,16,nil,nil,0},
[3888] = {'Korra',484,484,20,20,0,{[331]={{36.97,50.36}}},{[331]={{{36.61,49.55},{36.61,49.55},{36.54,49.59},{36.46,49.69},{36.4,49.68},{36.36,49.69},{36.75,49.86},{36.86,49.92},{37.03,50.07},{36.97,50.37},{36.97,50.37},{37,50.19},{36.92,49.98},{36.69,49.79},{36.68,49.56}}}},331,nil,nil,80,"A",nil,0},
[3890] = {'Brakgul Deathbringer',3874500,3874500,85,85,1,{[1637]={{73.93,44.59}}},nil,1637,nil,nil,1515,"H","Warsong Gulch Battlemaster",1048577},
[3891] = {'Teronis\' Corpse',484,484,20,20,0,{[331]={{20.25,38.77}}},nil,331,{26464},{991,26463},80,"A",nil,2},
[3892] = {'Relara Whitemoon',42,42,1,1,0,{[331]={{37.4,51.71}}},nil,331,nil,nil,80,"A",nil,0},
[3893] = {'Forsaken Scout',617,617,23,23,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3894] = {'Pelturas Whitemoon',531,531,21,21,0,{[331]={{37.37,51.79}}},nil,331,{13919,26475},{1020,1033,1034,1035,13924,26474,26475},124,"A",nil,2},
[3895] = {'Captain Noteo',3857,3857,60,60,0,nil,nil,0,nil,nil,80,"A","Boat Operator",0},
[3896] = {'Captain Hart',2471,2471,40,40,0,nil,nil,0,nil,nil,57,"A","Boat Operator",0},
[3897] = {'Krolg',651,651,24,24,0,{[331]={{50.84,75.08}}},nil,331,{13989,26481,26482},{1030,1045,13989,26480,26481},934,nil,nil,3},
[3898] = {'Aligar the Tormentor',664,664,24,24,0,nil,nil,0,nil,nil,22,nil,nil,0},
[3899] = {'Balizar the Umbrage',539,539,24,24,0,nil,nil,0,nil,nil,22,nil,nil,0},
[3900] = {'Caedakar the Vicious',582,582,24,24,0,nil,nil,0,nil,nil,22,nil,nil,0},
[3901] = {'Illiyana',750,750,26,26,0,{[331]={{86.71,42.71}}},nil,331,{26467,26469},{1031,1032,26468,26469},80,"A",nil,2},
[3902] = {'zzOLDSearing Totem II',5,5,23,24,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3903] = {'zzOLDSearing Totem III',5,5,36,39,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3904] = {'zzOLDSearing Totem IV',5,5,1,80,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3906] = {'zzOLDHealing Stream Totem II',5,5,1,80,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3907] = {'zzOLDHealing Stream Totem III',5,5,1,80,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3908] = {'zzOLDHealing Stream Totem IV',5,5,1,80,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3909] = {'zzOLDHealing Stream Totem V',5,5,1,80,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3911] = {'zzOLDStoneclaw Totem II',150,150,1,80,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3912] = {'zzOLDStoneclaw Totem III',220,220,1,80,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3913] = {'zzOLDStoneclaw Totem IV',280,280,1,80,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3914] = {'Rethilgore',1936,1936,20,20,1,nil,nil,0,nil,nil,14,nil,"The Cell Keeper",0},
[3915] = {'Dagri',605,605,23,23,0,{[331]={{36.67,49.68}}},nil,331,nil,nil,80,"A","Raene's Pet",0},
[3916] = {'Shael\'dryn',651,651,24,24,0,{[331]={{59.13,59.71},{59.18,59.6}}},nil,331,{26477,26478,26479},{1024,1026,1027,1055,26476,26477,26478},80,"A",nil,3},
[3917] = {'Befouled Water Elemental',571,571,23,24,0,{[331]={{51.25,71.78},{52.7,71.2},{51.81,72.69},{50.91,72.24},{51.26,73.71},{52.23,71.51},{51.72,70.53},{51.72,69.4},{48.65,68.63},{47.75,68.57},{46.47,68.05},{48.88,68.1},{51.67,68.57},{51.42,67.1},{51.25,71.69},{45.38,70.5},{51.67,72.73},{50.82,72.37},{52,71.36},{50.06,71.92},{48.17,71.02},{50.96,68.2},{51.64,70.32},{50.42,69.51},{51.82,69.29},{50.42,71.01},{51.23,69.84},{49.56,68.22},{49.65,70.89},{49.38,69.92},{47.82,71.92},{49.23,71.64},{48.33,72.58},{48.63,68.48},{47.74,68.41},{47.64,70.66},{48.72,69.62},{47.16,70.9},{47.73,69.46},{46.24,70.25},{46.28,71.22},{45.86,69.1},{46.9,69.3},{46.83,72.02},{46.35,67.82},{48.88,68.1}}},nil,331,nil,nil,91,nil,nil,0},
[3919] = {'Withered Ancient',562,562,22,23,0,{[331]={{63.42,46.92},{57.83,33.76},{55.25,32.42},{54.48,34.07},{54.38,30.37},{54.16,36.72},{62.51,44.88},{58.61,36.5},{56.78,29.88}}},nil,331,nil,nil,91,nil,nil,0},
[3920] = {'Anilia',699,699,25,25,0,{[331]={{78.33,44.82}}},nil,331,{26468},{1021,26467},1076,"A",nil,2},
[3921] = {'Thistlefur Ursa',605,605,22,23,0,{[331]={{42.42,33.56},{40.31,34.67},{40.67,34.16},{39.44,33.55},{40.39,33.92},{40.96,32.15},{41.26,32.08},{42.59,33.88},{40.96,31.68},{41.7,32.89},{38.25,30.66},{39.37,30.82},{39.44,30.92},{41.12,33.86},{40.41,32.15},{40.38,33.42}}},nil,331,nil,nil,82,nil,nil,0},
[3922] = {'Thistlefur Totemic',498,498,22,23,0,{[331]={{40.76,32.59},{42.97,33.84},{40.49,31.64},{42.81,34.51},{39.72,33.39},{41.42,32.44},{41.15,33.14},{42.31,34.89},{42.28,34.24},{41.68,33.6},{42.34,34.4},{40.98,33.02},{39.34,30.81},{39.98,32.92},{41.04,34.92},{40.13,32.47}}},nil,331,nil,nil,82,nil,nil,0},
[3923] = {'Thistlefur Den Watcher',617,664,23,24,0,nil,nil,0,nil,nil,82,nil,nil,0},
[3924] = {'Thistlefur Shaman',498,498,21,22,0,{[331]={{30.6,38.48},{30.87,43.15},{31.42,45.26},{38.58,39.3},{39.76,36.36},{31.73,37.97},{30.94,44.6},{38.53,35.93},{36.69,36.99},{36.63,35.56},{39.57,36.17},{35.6,32.02},{36.34,32.56},{38.95,36.21},{37.91,34.21},{38.03,35.12},{32.55,42.83},{31.73,43.23},{32.83,41.93},{34.19,38.87},{32.76,40.35},{32.52,39.07},{34,39.9},{39.91,31.89},{37.1,34.63},{35.17,32.74}}},nil,331,nil,nil,82,nil,nil,0},
[3925] = {'Thistlefur Avenger',521,521,21,22,0,{[331]={{30.23,43.36},{35.96,28.81},{29.93,39.08},{29.8,38.11},{31.64,46.25},{33.79,33.44},{38.51,37.69},{30.76,45.08},{37.65,36.24},{37.1,34.69},{36.22,36.33},{37.74,33.92},{36.87,33.74},{35.81,32.09},{37.37,32.64},{37.5,34.14},{30.33,38.13},{31.78,39.85},{34.11,38.4},{32.17,41.14},{31.05,40.65},{31.12,39.23},{31.87,39.24},{33.43,37.3},{33.34,38.91},{34.75,34.3},{33.8,35.66},{39.91,31.87},{34.12,35.81},{34.23,34.27}}},nil,331,nil,nil,82,nil,nil,0},
[3926] = {'Thistlefur Pathfinder',562,562,21,22,0,{[331]={{34.55,30.43},{38.4,39.58},{31.22,44.61},{35.92,31.88},{36.7,36.29},{33.03,39.98},{35.78,32.82},{34.2,34.98},{39.87,32.05}}},nil,331,nil,nil,82,nil,nil,0},
[3927] = {'Wolf Master Nandos',3126,3126,21,21,1,nil,nil,0,nil,nil,14,nil,nil,0},
[3928] = {'Rotting Slime',449,449,19,20,0,{[331]={{76.67,68.55},{72.75,70.06},{71.98,71.09},{76.38,68.38},{77.35,71.91},{75.33,69.39},{75.91,72.43},{73.98,70.07},{74.83,69.54},{75.2,71.83},{74.56,71.13},{77.3,73.26},{76.34,73.1},{76.55,71.63},{75.84,70.76},{78.25,73.33},{73.17,70.81},{72.73,70.05},{72.62,73.54},{72.1,73.22},{72.59,74.34},{74.84,73.16},{74.62,74.23},{74.16,75.79},{74.13,76.76},{73.83,74.48},{73.72,78.2},{72.52,71.72},{71.95,71.07},{74.02,73.57},{73.69,72.99},{73.6,78.47},{72.45,77.86},{73.76,79.72},{72.93,76.91},{74.38,75.73},{74.09,77.27},{69.05,76.11}}},nil,331,nil,nil,14,nil,nil,0},
[3931] = {'Shadethicket Oracle',1003,1003,30,30,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3932] = {'Bloodtooth Guard',651,651,24,25,0,{[331]={{54.78,79.06},{54.87,78.79},{55.62,75.44},{55.42,76.61},{54.76,75.14},{54.62,75.25},{54.4,78.74},{54.73,77.76}}},nil,331,nil,nil,82,nil,nil,0},
[3933] = {'Hai\'zan',300,300,14,14,0,{[14]={{55.66,73.63}}},nil,14,nil,nil,126,"H","Butcher",640},
[3934] = {'Innkeeper Boorand Plainswind',1003,1003,30,30,0,{[17]={{49.55,57.88}}},nil,17,nil,nil,29,"H","Innkeeper",66177},
[3935] = {'Toddrick',198,198,10,10,0,{[12]={{44.24,65.97}}},nil,12,nil,nil,12,"A","Butcher",640},
[3936] = {'Shandris Feathermoon',68713600,68713600,88,88,1,{[357]={{46.03,49.12}}},nil,357,{25304,25463,26985,27133},{2867,4266,25399,25458,26402},124,"A","General of the Sentinel Army",3},
[3937] = {'Kira Songshine',247,247,12,12,0,{[12]={{42.22,65.17}}},{[12]={{{42.32,65.45},{41.74,63.77},{41.53,63.21},{41.21,62.39},{41.02,61.48},{40.65,60.39},{40.32,59.49},{40.11,58.7},{39.88,57.61},{39.65,56.91},{39.22,56.31},{38.87,55.85},{38.37,55.22},{37.9,54.52},{37.41,53.95},{36.87,53.72},{36.31,53.69},{35.56,53.63},{34.93,53.51},{34.56,53.33},{34.24,53.1},{33.76,52.56},{33.41,51.97},{33,51.23},{33.39,52.04},{33.56,52.31},{33.9,52.72},{34.23,53.15},{34.55,53.44},{34.9,53.55},{35.29,53.66},{35.62,53.69},{36,53.75},{36.76,53.77},{37.33,53.91},{37.66,54.19},{38.35,55.19},{38.72,55.75},{39.01,56.15},{39.61,56.74},{39.84,57.5},{39.9,58},{40.12,58.93},{40.39,59.92},{40.6,60.43},{40.93,61.24},{41.19,62.06},{41.36,62.94},{41.64,63.78},{41.95,64.39},{42.25,64.91},{42.45,65.65},{42.4,66.2},{42.54,67.11},{43.06,67.51},{43.78,68.01},{44.13,68.28},{44.48,68.57},{45.04,68.95},{45.78,69.36},{46.67,69.6},{47.52,69.61},{46.57,69.54},{45.76,69.32},{45.12,69.02},{44.67,68.68},{44.37,68.39},{43.98,68.17},{43.42,67.76},{42.79,67.25},{42.3,67.14},{41.65,66.85},{41.29,66.72},{40.6,66.56},{40.05,66.68},{39.41,66.79},{39.05,66.76},{38.56,67.12},{37.95,67.78},{37.26,68.85},{37.54,68.25},{37.68,68.09},{38,67.58},{38.41,67.33},{38.95,66.81},{39.45,66.71},{39.9,66.62},{40.25,66.63},{40.81,66.71},{41.35,66.83},{41.88,66.88},{42.17,66.78},{42.3,66.54},{42.47,66.03}}}},12,nil,nil,12,"A","Traveling Baker",640},
[3938] = {'Roth Bluntblade',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Kira's Guard",0},
[3939] = {'Razormane Wolf',68,68,7,7,0,{[17]={{67.28,49.9},{52.9,50.64},{52.66,50.02}}},nil,17,nil,nil,109,nil,nil,0},
[3940] = {'Taneel Darkwood',498,498,22,22,0,{[331]={{77.11,74.03}}},nil,331,nil,nil,16,nil,nil,0},
[3941] = {'Uthil Mooncall',498,498,22,22,0,{[331]={{78.12,72.84}}},nil,331,nil,nil,16,nil,nil,0},
[3942] = {'Mavoris Cloudsbreak',498,498,22,22,0,{[331]={{75.09,74.21}}},nil,331,nil,nil,16,nil,nil,0},
[3943] = {'Ruuzel',1124,1124,22,22,0,{[331]={{6.64,13.29}}},{[331]={{{7.26,13.13},{7.41,13.41},{7.49,14.42},{7.32,14.9},{6.68,15.15},{6.03,14.94},{5.84,14.47},{5.63,14.03},{5.71,12.91},{6.26,11.73},{6.64,11.64},{7.19,12.13},{7.3,12.67}}}},331,nil,nil,74,nil,nil,0},
[3944] = {'Wrathtail Priestess',433,433,20,21,0,{[331]={{6.68,10.95},{7.27,10.71},{7.87,15.22},{5.93,15.1},{6.66,15.29},{5.5,13.67},{6.09,11.87},{7.21,16.21},{6.17,12.88},{7.72,12.66},{7.76,14.4},{7.76,13.64}}},nil,331,nil,nil,74,nil,nil,0},
[3945] = {'Caravaneer Ruzzgot',955,955,31,31,0,{[5287]={{41.41,68.55}}},nil,5287,nil,{1040},120,"AH",nil,0},
[3946] = {'Velinde Starsong',64,64,40,40,0,{[10]={{73.56,79.14}}},nil,10,nil,nil,35,"AH",nil,0},
[3947] = {'Goblin Shipbuilder',1068,1068,16,16,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[3948] = {'Honni Goldenoat',198,198,10,10,0,{[38]={{35.32,49.73}}},nil,38,nil,nil,55,"A","Baker",640},
[3950] = {'Minor Water Guardian',280,280,25,25,0,nil,nil,0,nil,nil,91,nil,nil,0},
[3951] = {'Bhaldaran Ravenshade',1163,1163,34,34,0,{[331]={{34.74,71.27}}},nil,331,nil,nil,80,"A","Bowyer",4224},
[3952] = {'Aeolynn',562,562,22,22,0,{[331]={{34.47,49.52}}},nil,331,nil,nil,80,"A","Clothier",4224},
[3953] = {'Tandaan Lightmane',605,605,23,23,0,{[331]={{34.55,49.9}}},nil,331,nil,nil,80,"A","Leather Armor Merchant",4224},
[3954] = {'Dalria',651,651,24,24,0,{[331]={{35.12,52.12}}},nil,331,nil,nil,80,"A","Trade Goods",128},
[3955] = {'Shandrina',651,651,24,24,0,{[331]={{50.42,65.56}}},nil,331,nil,nil,80,"A","Trade Goods",0},
[3956] = {'Harklan Moongrove',651,651,24,24,0,{[331]={{50.08,65.34}}},nil,331,nil,nil,80,"A","Alchemy Supplies",0},
[3957] = {'Jainay Featherbreeze',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Cooking Supplies",0},
[3958] = {'Lardan',699,699,25,25,0,{[331]={{34.79,49.84}}},nil,331,nil,nil,80,"A","Leatherworking Supplies",128},
[3959] = {'Nantar',521,521,21,21,0,{[331]={{36.82,50.15}}},nil,331,nil,nil,80,"A","Baker",640},
[3960] = {'Ulthaan',750,750,26,26,0,{[331]={{48.51,64.12}}},nil,331,nil,nil,80,"A","Butcher",0},
[3961] = {'Maliynn',449,449,19,19,0,{[331]={{36.62,49.98}}},nil,331,nil,nil,80,"A","Food & Drink Vendor",640},
[3962] = {'Haljan Oakheart',750,750,26,26,0,{[331]={{34.85,50.87}}},nil,331,nil,nil,80,"A","General Goods",640},
[3963] = {'Danlaar Nightstride',1220,1220,35,35,0,{[331]={{50.15,65.98}}},nil,331,nil,nil,80,"A","Hunter Trainer",1},
[3964] = {'Kylanna',1006,1006,31,31,0,{[331]={{49.93,65.93}}},nil,331,nil,nil,80,"A","Alchemy Trainer",1},
[3965] = {'Cylania Rootstalker',651,651,24,24,0,{[331]={{49.05,65.87}}},nil,331,nil,nil,80,"A","Herbalism Trainer",0},
[3966] = {'Kaleem',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Cooking Trainer",64},
[3967] = {'Aayndia Floralwind',1336,1336,37,37,0,{[331]={{35.98,52.1}}},nil,331,nil,nil,80,"A","Leatherworking Trainer",81},
[3968] = {'Sentry Totem',1935,1935,40,40,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3969] = {'Fahran Silentblade',853,853,28,28,0,{[331]={{36.49,49.46}}},nil,331,nil,nil,80,"A","Poison Vendor",1152},
[3970] = {'Llana',699,699,25,25,0,{[331]={{34.98,48.46}}},nil,331,nil,nil,80,"A","Reagent Supplies",2176},
[3971] = {'Agro 5',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3972] = {'Agro 7',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3973] = {'Agro 10',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3974] = {'Houndmaster Loksey',19340,19340,34,34,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[3975] = {'Herod',33400,33400,37,37,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,"The Scarlet Champion",0},
[3976] = {'Scarlet Commander Mograine',9808,9808,40,40,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[3977] = {'High Inquisitor Whitemane',9808,9808,40,40,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[3978] = {'Sage Truthseeker',1003,1003,30,30,0,{[1638]={{34.4,46.87}}},nil,1638,{2965},{1049,2968},104,"H",nil,2},
[3979] = {'Librarian Mae Paledust',1003,1003,30,30,0,{[1537]={{74.97,12.48}}},nil,1537,nil,{1050},55,"A","Explorers' League",0},
[3980] = {'Raleigh the Devout',1003,1003,30,30,0,nil,nil,0,nil,{1052,1053},12,"A",nil,0},
[3981] = {'Vorrel Sengutz',156,156,8,8,0,{[796]={{-1,-1}}},nil,796,nil,nil,68,"H",nil,0},
[3982] = {'Monika Sengutz',137,137,7,7,0,{[267]={{57.94,46.73}}},nil,267,nil,{1051},68,"H",nil,0},
[3983] = {'Interrogator Vishas',17000,17000,31,31,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[3984] = {'Nancy Vishas',3330,3330,33,33,1,nil,{[36]={{{32.33,32.78},{32.1,32.61},{31.99,32.49},{31.78,32.27},{31.57,32.01},{31.35,31.78},{31.21,31.64},{31.21,31.64},{31.47,31.9},{31.69,32.14},{31.91,32.41},{32.06,32.58},{32.33,32.78}}}},0,nil,nil,14,nil,nil,0},
[3985] = {'Grandpa Vishas',3489,3489,34,34,1,nil,nil,0,nil,nil,14,nil,nil,0},
[3986] = {'Sarilus Foulborne',573,573,25,25,0,{[17]={{42.92,38.93}}},nil,17,nil,nil,118,"H",nil,0},
[3987] = {'Dal Bloodclaw',1302,1302,24,24,0,{[331]={{41.66,35.7}}},nil,331,nil,nil,82,nil,nil,0},
[3988] = {'Venture Co. Operator',449,484,28,29,0,nil,nil,0,nil,nil,47,nil,nil,0},
[3989] = {'Venture Co. Logger',417,449,28,29,0,nil,nil,0,nil,nil,47,nil,nil,0},
[3990] = {'Venture Co. Cutter',748,748,17,17,0,nil,nil,0,nil,nil,47,nil,nil,0},
[3991] = {'Venture Co. Deforester',379,405,19,20,0,{[406]={{67.2,49.94}}},nil,406,nil,nil,47,nil,nil,0},
[3992] = {'Venture Co. Holdout',713,713,25,26,0,{[406]={{64.35,44.62},{64.12,44.49}}},nil,406,nil,nil,47,nil,nil,0},
[3993] = {'Venture Co. Machine Smith',765,765,26,26,0,{[406]={{64.56,45.29},{63.59,45.48}}},nil,406,nil,nil,47,nil,nil,0},
[3994] = {'Keeper Albagorm',1003,1003,30,30,0,nil,nil,0,nil,{1056,1057},80,"A",nil,0},
[3995] = {'Witch Doctor Jin\'Zil',974,974,30,30,0,{[406]={{71.12,91.23}}},{[406]={{{74.54,97.83},{74.62,97.8},{74.68,97.94},{74.66,98.03},{74.64,98.09},{74.61,98.15},{74.58,98.15},{74.52,98.06},{74.51,97.96},{74.54,97.94}}}},406,{26060,26061,26062,26067,26069,26073},{1058,1060,26059,26060,26061,26062,26067},29,"H",nil,2},
[3996] = {'Faldreas Goeth\'Shael',449,449,19,19,0,{[331]={{35.77,49.1}}},nil,331,{13965},nil,80,"A",nil,2},
[3997] = {'Venture Co. Overboss',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3998] = {'Windshear Vermin',494,531,20,21,0,nil,nil,0,nil,nil,22,nil,nil,0},
[3999] = {'Windshear Digger',531,573,27,28,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4001] = {'Windshear Tunnel Rat',449,484,19,20,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4002] = {'Windshear Stonecutter',573,617,22,23,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4003] = {'Windshear Geomancer',413,441,26,27,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4004] = {'Windshear Overlord',531,573,26,27,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4005] = {'Deepmoss Creeper',750,750,26,27,0,{[406]={{61.21,74.79},{61.4,71.67},{59.17,71.87},{61,73.76},{59.57,76.79},{55.15,70.64},{55.87,69.78},{54.65,74.34},{56.47,70.19},{58.67,70.99},{57.84,71.45},{54.09,74.24},{56.96,76.65},{58.49,75.63},{61.4,71.62},{55.33,75.63},{56.78,76.75},{56.29,75.28},{58.27,75.69},{57.01,75.68},{57.55,75.69},{58.54,76.21},{55.82,76.49},{54.95,72.93},{54.93,71.97},{56.17,72.85},{61.13,74.79},{61.12,73.7},{59.19,71.95},{56.8,71.58},{58.31,68.74},{57.22,70.04},{56.28,69.16},{57,68.54},{58.01,70.07},{59.51,76.85},{58.52,73.44},{57.24,73.33},{57.92,74.38},{56.99,72.69}}},nil,406,nil,nil,22,nil,nil,0},
[4006] = {'Deepmoss Webspinner',750,750,26,26,0,{[406]={{60.2,76.55},{60.7,75.66},{59.2,75.16},{55.22,72.57}}},nil,406,nil,nil,22,nil,nil,0},
[4007] = {'Deepmoss Venomspitter',562,562,26,27,0,{[406]={{59.26,73.24},{59.2,71.05},{59.3,74.64},{56.47,66.57},{55.94,74.64},{58.11,72.28},{56.97,70.63},{57.3,74.82},{54.94,75.07},{56.07,70.71},{54.46,73.46},{55.54,71.5},{59.2,71.1},{58.56,74.46},{57.52,69},{57.21,67.3},{58.64,69.97},{59.29,74.71},{58.61,72.94},{59.21,73.1},{57.69,70.69},{57.85,73.48},{56.9,73.69},{56.99,72.22}}},nil,406,nil,nil,22,nil,nil,0},
[4008] = {'Cliff Stormer',905,905,29,29,0,{[406]={{67.76,81.76},{59.83,79.22},{63.69,81.74},{60.16,79.55},{67.51,83.44},{62.3,79.59},{63.06,81.47},{69.14,85.24},{73.9,81.57},{67.3,82.37},{75.01,84.68},{76.07,87.26},{74.5,81.65},{79.22,87.92},{74.11,81.38},{80.02,86.44},{73.3,85.57},{75.22,91.09},{77.69,83.09},{67.25,83.29},{62.79,81.12},{63.67,81.99},{59.93,79.1},{60.14,80.06},{60.29,82.56},{61.45,83.76},{74.53,91.7},{62.95,86.24},{69.21,86.28},{64.58,88.18},{62.31,79.7}}},nil,406,nil,nil,14,nil,nil,0},
[4009] = {'Raging Cliff Stormer',417,449,28,29,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4011] = {'Young Pridewing',449,484,29,30,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4012] = {'Pridewing Wyvern',923,923,28,29,0,{[406]={{55.85,47.23},{55.03,46.48},{54.73,47.76},{54.95,45.13},{55.23,42.79},{55.9,45.56}}},nil,406,nil,nil,16,nil,nil,0},
[4013] = {'Pridewing Skyhunter',617,664,23,24,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4014] = {'Pridewing Consort',923,923,28,29,0,{[406]={{55.2,40.34},{55.57,41.24},{54.64,44.74},{56.55,45.78},{54.43,43.69}}},nil,406,nil,nil,16,nil,nil,0},
[4015] = {'Pridewing Patriarch',713,713,28,29,4,{[406]={{51.3,53.6},{47.86,52.13},{51.79,51.59},{57.25,48.35},{54.4,47.71},{51.37,45.13},{47,44.62},{56.5,43.65}}},nil,406,nil,nil,22,nil,nil,0},
[4016] = {'Fey Dragon',622,622,24,25,0,{[406]={{42.19,28.56}}},nil,406,nil,nil,124,"A",nil,0},
[4017] = {'Wily Fey Dragon',724,724,26,27,0,{[406]={{44.96,23.08},{37.3,20.57},{39.71,26.06},{40.36,27.71}}},nil,406,nil,nil,93,nil,nil,0},
[4018] = {'Antlered Courser',573,573,22,23,0,{[406]={{43.87,19.98},{44.9,17.23},{44.66,22.71},{44.37,20.6},{44.39,19.13},{43.7,18.46},{43.88,21.66}}},nil,406,nil,nil,1999,"AH",nil,0},
[4019] = {'Great Courser',713,713,24,25,0,{[406]={{39.84,20.94},{45.41,22.09},{43.32,17.37},{43.36,19.02},{42.75,25.13}}},nil,406,nil,nil,1999,"AH",nil,0},
[4020] = {'Sap Beast',617,617,22,23,0,{[406]={{37.97,25.97},{38.73,26.51},{38.31,26.19},{39.09,25.39},{44.14,23.57},{43.33,22.5},{39.24,21.89},{44.42,24.03},{42.75,25.24},{43.94,26.7},{39.08,27.82},{38.76,29.03},{37.79,26.08},{38.36,26.09},{39.16,26.57},{38.68,25.71},{39.16,25.72},{40.59,28.84},{40.36,27.04},{40.91,27.35},{39.32,21.74},{39.64,29.2},{40.51,28.41},{40.98,27.51},{42.67,27.7},{42.58,29.94},{42.69,27.29},{42,28.49},{43.97,26.65}}},nil,406,nil,nil,16,nil,nil,0},
[4021] = {'Corrupted Sap Beast',664,664,24,25,0,{[406]={{43.28,20.68},{42.14,20.69},{40,27.5},{41.96,28.1}}},nil,406,nil,nil,16,nil,nil,0},
[4022] = {'Bloodfury Harpy',617,664,23,24,0,nil,nil,0,nil,nil,514,nil,nil,0},
[4023] = {'Bloodfury Roguefeather',734,787,25,26,0,nil,nil,0,nil,nil,514,nil,nil,0},
[4024] = {'Bloodfury Slayer',640,684,25,26,0,nil,nil,0,nil,nil,514,nil,nil,0},
[4025] = {'Bloodfury Ambusher',426,457,23,24,0,nil,nil,0,nil,nil,514,nil,nil,0},
[4026] = {'Bloodfury Windcaller',582,622,24,25,0,nil,nil,0,nil,nil,514,nil,nil,0},
[4027] = {'Bloodfury Storm Witch',684,724,26,27,0,nil,nil,0,nil,nil,514,nil,nil,0},
[4028] = {'Charred Ancient',640,684,25,26,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4029] = {'Blackened Ancient',840,896,27,28,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4030] = {'Vengeful Ancient',950,1003,29,30,4,{[406]={{38.48,70.77},{36.07,68.51}}},nil,406,nil,nil,14,nil,nil,0},
[4031] = {'Fledgling Chimaera',734,840,25,27,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4032] = {'Young Chimaera',544,622,23,25,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4033] = {'Charred Stone Spirit',1042,1042,22,22,0,nil,nil,0,nil,nil,92,nil,nil,0},
[4034] = {'Enraged Stone Spirit',664,713,24,25,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4035] = {'Furious Stone Spirit',787,840,26,27,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4036] = {'Rogue Flame Spirit',544,582,23,24,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4037] = {'Burning Ravager',664,713,24,25,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4038] = {'Burning Destroyer',684,724,26,27,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4039] = {'Dinnis',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[4040] = {'Cave Stalker',484,484,20,21,0,{[11]={{49.57,58.96},{50.37,59.28},{49.77,60.19},{50.2,60.87},{45.72,64.19},{49.03,61.41},{51.46,62.17},{47.91,59.77},{48.57,62.68},{46.9,63.71},{46.94,59.27},{46.01,60.5},{46.13,64.92},{49.72,63.09},{47.05,61.66},{46.1,62.29},{50.77,62.18},{47.1,61.68},{46.47,62.12}}},nil,11,nil,nil,312,nil,nil,0},
[4041] = {'Scorched Basilisk',840,896,27,28,0,{[406]={{40.9,69.88},{40.87,73.14}}},nil,406,nil,nil,49,nil,nil,0},
[4042] = {'Singed Basilisk',734,787,25,26,0,nil,nil,0,nil,nil,49,nil,nil,0},
[4043] = {'Galthuk',156,156,8,8,0,{[1637]={{76.23,36.81}}},nil,1637,nil,nil,29,"H","Two-Handed Weapons Merchant",4224},
[4044] = {'Blackened Basilisk',617,664,27,28,0,nil,nil,0,nil,nil,49,nil,nil,0},
[4045] = {'JEFF CHOW TEST',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","No Clothes NPC",0},
[4046] = {'Magatha Grimtotem',4370,4370,62,62,0,nil,nil,0,nil,{1063,3518,5062},104,"H","Elder Crone",2},
[4047] = {'Zor Lonetree',4370,4370,62,62,0,{[1637]={{48.64,72.99}}},nil,1637,nil,{1262,7541},29,"H","Elder Far Seer",0},
[4048] = {'[Deprecated for 4.x]Falfindel Waywarder',896,896,28,28,0,nil,{[357]={{{89.56,46.57},{89.45,46.49},{89.39,46.36},{89.43,46.12},{89.35,45.79},{89.42,46.03},{89.39,46.35},{89.45,46.49},{89.56,46.56},{89.64,46.56},{89.64,46.56}}}},0,nil,{1059,1100,1101,4281},80,"A",nil,0},
[4049] = {'Seereth Stonebreak',787,787,26,26,0,{[4709]={{39.39,20.09}}},nil,4709,nil,{1061,1062,1068},29,"H",nil,0},
[4050] = {'Cenarion Caretaker',732,732,28,29,0,{[406]={{35.75,25.04},{35.36,25.67},{35.13,25.28},{35.82,25.23},{35.12,25.52},{35.5,26.06},{35.47,25.34},{34.88,26.65}}},nil,406,nil,nil,124,"A",nil,0},
[4051] = {'Cenarion Botanist',582,582,23,24,0,{[406]={{42.23,21.8},{39.74,22.48},{40.39,23.33},{41,20.89},{41.07,24.33}}},nil,406,nil,nil,124,"A",nil,0},
[4052] = {'Cenarion Druid',690,690,27,28,0,{[406]={{36.11,25.25},{36.18,25.21},{36.23,25.27},{34.87,24.22},{34.3,22.89},{35.61,25.83},{35.26,24.93},{34.78,22.2},{34.51,23.31},{35.72,25.52},{34.37,23.55},{34.15,23.45},{34.98,24.66},{34.8,23.93},{36.15,25.1}}},nil,406,nil,nil,124,"A",nil,0},
[4053] = {'Daughter of Cenarius',582,582,23,25,0,{[406]={{40.43,24.98},{40.62,23.3},{40.62,25.17},{41.12,24.35},{41.32,23.23},{40.56,22.76}}},nil,406,nil,nil,124,"A",nil,0},
[4054] = {'Laughing Sister',422,422,21,22,0,{[331]={{61.04,56.09},{61,56.99},{60.41,56.13},{61.08,54.57},{59.13,56.23},{58.74,55.12},{58.64,56.02},{60.39,55.3},{58.59,57.88},{58.13,56.02},{58.66,56.87},{59.26,56.98},{59.82,56.19},{59.25,54.41},{60.62,54.49},{60.98,55.41},{59.91,55.21},{58.6,54.52},{59.91,54.44},{61.22,53.27},{62.75,51.09},{60.36,56.03},{61.25,53.14},{59.82,52.81},{60.65,54.35},{60.4,51.15},{59.84,53.44},{61.02,51.93},{61.66,51.76},{61.55,49.14},{60.52,51.99},{61.49,49.94},{60.98,52.6},{62.21,50.12},{60.9,50.12},{60.94,50.8},{60.38,52.72},{60.92,49.18},{62.76,51.01},{62.26,49.11},{61.61,48.37},{61.08,54.51},{61.01,56.03},{61.17,53.23},{60.45,55.97},{61.07,55.4},{61.03,56.91},{59.26,56.99},{58.72,56.88},{58.63,57.92},{58.13,56.01},{58.69,56.14},{60.32,55.31},{59.89,56.1},{58.66,55.23},{59.13,56.24},{58.7,54.53},{59.85,55.31},{59.83,52.79},{60.37,56.07},{60.62,54.46},{60.32,55.31},{61.05,54.55},{60.53,51.9},{60.46,52.72},{62.64,50.7},{60.93,52.59},{60.45,51.17},{62.07,50.08},{62.17,49.17},{61.39,53.23},{60.88,50.06},{61.53,49.17},{61.01,50.82},{61.52,50.01},{61.65,52.51},{61.03,48.35},{62.8,51}}},nil,331,nil,nil,124,"A",nil,0},
[4055] = {'Mirkfallon Glade Strider',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4056] = {'Mirkfallon Keeper',750,800,28,29,0,{[406]={{32.6,21.86},{32.66,21.06},{32.87,22.41},{32.31,22.62},{33.04,22.92},{33.51,23.55}}},nil,406,nil,nil,79,"A",nil,0},
[4057] = {'Son of Cenarius',664,664,24,25,0,{[406]={{41.65,25.02},{41.65,25}}},nil,406,nil,nil,124,"A",nil,0},
[4059] = {'Forest Spirit',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4061] = {'Mirkfallon Dryad',800,800,27,28,0,{[406]={{35.47,23.67},{35.75,24.1},{34.04,22.53},{33.85,21.55},{33.73,20.75},{33.58,23.07},{35.46,23.53},{35.74,24.13},{34.36,22.95},{34.96,23.23},{33.73,22.53}}},nil,406,nil,nil,79,"A",nil,0},
[4062] = {'Dark Iron Bombardier',1050,1107,30,31,0,nil,nil,0,nil,nil,54,nil,nil,0},
[4063] = {'Feeboz',156,156,39,39,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[4064] = {'Blackrock Scout',386,386,16,17,0,{[44]={{45.24,41.55},{53.11,41.36},{51.81,42.58},{50.59,43.16},{44.6,36.18},{47.83,33.68},{44.45,30.69},{48.23,39.88},{48.54,41.66},{47.18,40.57},{47.43,41.71},{45.04,39.35},{52.34,38.16}}},nil,44,nil,nil,40,nil,nil,0},
[4065] = {'Blackrock Sentry',1796,1796,18,19,1,nil,nil,0,nil,nil,40,nil,nil,0},
[4066] = {'Nal\'taszar',1035,1035,27,27,4,{[406]={{36.18,24.99},{48.36,73.49}}},nil,406,nil,nil,189,"AH",nil,0},
[4067] = {'Twilight Runner',664,664,23,24,0,{[406]={{41.66,27.18},{36.93,20.33},{38.24,20.12},{37.2,22.32},{38.31,21.5},{37.7,22.42},{39.51,23.54},{39.62,25.68},{38.29,20.18},{39.72,19.93},{38.67,22.74},{37.91,20.91},{39.91,19.4},{38.2,19.14},{37.12,21.38},{37.04,23.2},{41.09,26.04},{39.47,23.88},{39.79,25.98},{42.1,26.11},{41.13,25.66},{42.15,26.01}}},nil,406,nil,nil,1999,"AH",nil,0},
[4068] = {'Serpent Messenger',40,40,10,10,0,nil,nil,0,nil,nil,1801,"H",nil,0},
[4069] = {'Venture Co. Planner',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4070] = {'Venture Co. Builder',765,765,26,26,0,{[406]={{65.97,50.17},{63.61,45.68},{64.16,45.06},{63.6,46.06},{63.15,46.21}}},{[406]={{{63.39,40.71},{63.14,40.77},{62.85,40.82},{62.85,40.78},{62.81,40.43},{62.8,40.23},{62.81,40.44},{62.85,40.76},{62.86,40.83},{63.03,40.76},{63.26,40.72},{63.41,40.69},{63.43,40.63},{63.4,40.31},{63.46,39.94},{63.54,39.71},{63.64,39.7},{63.81,39.79},{63.95,39.9},{63.82,39.78},{63.64,39.69},{63.52,39.73},{63.49,39.85},{63.41,40.31},{63.42,40.63},{63.42,40.72}}}},406,nil,nil,47,nil,nil,0},
[4071] = {'Venture Co. Grinder',804,804,18,18,0,nil,nil,0,nil,nil,47,nil,nil,0},
[4072] = {'Prisoner of Jin\'Zil',484,484,20,20,0,nil,nil,0,nil,nil,80,"A",nil,0},
[4073] = {'XT:4',617,617,23,23,0,nil,{[406]={{{64.12,46.3},{64.08,45.87},{64.13,45.3},{64.32,45.02},{64.58,44.85},{64.82,44.89},{65.1,45},{65.1,45.62},{65.02,46.11},{65.25,46.52},{65.41,47.08},{65.46,47.74},{65.37,48.04},{65.16,48.12},{65,47.94},{64.91,47.7},{64.7,47.58},{64.52,47.82},{64.27,48.28},{64.08,48.2},{63.84,47.9},{63.89,47.43},{63.75,46.98},{63.51,46.65},{63.37,46.33},{63.37,45.99},{63.49,45.73},{63.69,45.57},{63.97,45.79},{64.07,46.01}}}},0,nil,nil,14,nil,nil,0},
[4074] = {'XT:9',617,617,23,23,0,nil,{[406]={{{64.22,56.54},{64.43,56.41},{64.53,56.09},{64.7,55.84},{64.99,55.77},{65.4,56.04},{65.61,56.05},{65.89,56.26},{66.18,56.29},{66.36,56.22},{66.67,56.37},{66.97,56.14},{67.28,56.19},{67.48,56.13},{67.75,56.01},{68.02,55.93},{68.33,56.15},{68.75,56.2},{69.25,56.53},{69.74,56.54},{70.09,56.65},{70.59,56.6},{70.8,56.68},{71.2,56.52},{71.47,55.79},{71.43,55.12},{71.3,54.73},{70.89,54.48},{70.59,54.55},{70.24,54.76},{69.97,54.39},{69.68,54.14},{69.39,54.42},{69.2,55.09},{68.73,55.01},{68.39,55.1},{67.99,54.87},{67.73,54.73},{67.46,54.64},{67.26,54.91},{67.03,55.11},{66.8,55.15},{66.51,54.97},{66.25,55.29},{66.13,55.66},{65.78,55.75},{65.56,55.17},{65.22,54.79},{64.89,54.74},{64.61,54.59},{64.18,54.73},{63.76,55.01},{63.25,54.93},{62.88,55.14},{62.52,55.06},{61.97,54.5},{61.53,54.17},{61.13,54.04},{60.83,54.08},{60.54,54.07},{60.38,54.35},{60.51,54.79},{60.9,54.93},{61.38,55.1},{61.7,55.46},{61.81,56.08},{62.02,56.44},{62.45,56.38},{62.72,56.34},{63.09,56.46},{63.46,56.57},{63.84,56.75},{64.06,56.69}}}},0,nil,nil,14,nil,nil,0},
[4075] = {'Rat',8,8,1,1,0,{[8]={{62.32,79.3},{63.47,82.45},{61.4,82.66},{63.12,84.47},{65.91,76.88},{62.24,78.6},{62,81.77},{66.43,84.21},{64.9,86.37}},[16]={{61.47,77.59},{62.32,78.05},{63.44,80.08},{62.67,76.12},{61.62,78.47},{31.1,34.01},{30.5,39.02},{33.56,33.11},{30.91,35.33},{31.6,29.53},{30.55,38.4},{30.92,38.34},{29.94,38.85},{30.96,29.23},{32.38,31.61},{31.04,29.3},{32.09,33.29},{31.37,30.83},{30.56,37.06},{31.15,29.97},{30.74,31.09},{31.83,30.16}},[38]={{29.11,87.7},{24.8,30.46},{26.15,49.31},{68.78,59.05},{35.12,76.53},{35.85,61.31},{74.21,76.74},{27.93,83.23},{30.74,76.02},{35.19,61.26},{37.56,16.29},{35.39,24.96},{77.38,77.29},{35.18,61.26},{36.5,20.64},{34.24,68.38},{34.89,76.71},{36.58,25.86},{34.4,26.84},{76.52,81.86},{76.41,81.75},{70.87,69.26},{26.05,42.58},{37.97,62.2},{75.88,78.14},{75.9,78.2},{34.13,67.47},{35.49,14.97},{34.73,27.21},{35.48,21.94},{26.68,57.4},{32.04,61.76},{34.2,61.52},{35.24,23.54},{35,23.23},{35.68,18.24},{26.34,56.71},{26.3,44.24},{71.21,68.5},{32.33,79.81},{34.92,26.2},{31.55,75.72},{71.21,63.85},{73.56,78.22},{77.72,80.49},{76.08,80.28},{77.48,80.9},{73.47,78.46},{75.85,78.49},{78.15,78.02},{36.17,58.43},{34.31,61.3},{34.72,62.51},{36.04,58.22},{31.96,61.9},{68.47,59.96},{30.89,74.76},{72.61,69.16},{72.35,67.41},{28.46,80.01},{25.4,29.97},{35.8,62.97},{35.32,64.82},{70.12,63.01},{69.6,62.92},{33.37,68.01},{25.51,43.97},{68.77,59.04},{71.35,68.53},{71.32,63.84},{68.46,59.74},{72.71,69.17},{72.34,67.4},{70.22,63.14},{69.75,63.02},{66.73,22.58},{68.23,18.72},{70.36,20.45},{70.26,19.74},{68.86,24.6},{68.8,25.4},{71.3,22.91},{69.27,22.21},{70.68,22.85},{66.81,22.75},{73.38,26.75},{75.92,29.51},{68.77,59.03},{76.38,15.92},{68.17,28.25},{73.57,24.73},{68.42,18.56},{75.77,15.4},{73.84,18.94},{70.43,20.34},{69.99,19.68},{77.47,17.4},{74.43,28.32},{77.5,14.05},{79.35,16.38},{34.39,26.8},{77.68,17.18},{76.21,18.4},{68.97,24.91},{68.93,25.85},{75.19,16.63},{75.05,16.2},{34.92,26.21},{71.51,23.3},{69.29,21.73},{70.24,23.22},{79.87,14.48},{79.7,14.3},{68.58,59.89}},[45]={{14.35,34.1},{80.52,29.56},{49.75,42},{25.1,28.67},{12.61,35.97},{70.09,37.52},{69.58,29.63},{69.52,35.42},{24.46,44.07},{26.59,26.36},{79.22,36.1},{25.78,30.98},{49.77,40.04},{79.25,36.31},{24.11,44.26},{69.08,35.64},{25.33,26.84},{46.57,78.48},{49.02,83.38},{48.88,77.93},{64.87,80.03},{13.19,69.18},{51.15,79.44},{26.03,46.11},{63,80.83},{26.49,44.84},{27.63,45.58},{29.62,45.08},{17.04,68.15},{22.12,67.73},{25.4,46.99},{29.77,47.94},{48.22,76.82},{20.99,64.08},{25.56,47.44},{12.16,66.41},{16.56,58.63},{27.32,45.61},{64.45,82.07},{26.58,47.75},{14.25,63.72},{48.36,81.25},{13.99,70.54},{29.3,45.45},{26.63,47.11},{25.73,47.39},{26.7,47.03},{49.21,82.42},{80.18,31.72},{79.65,31.88},{19.52,59.3},{48.38,39.95},{48.25,40.43},{70.28,37.13},{18.55,64.83},{25.23,45.18},{20.73,66.33},{69.6,32.71},{27.66,31.14},{26.56,44.05},{47.69,79.12},{20.1,63.03},{23.06,63.67},{80.46,34.93},{78.96,34.85},{17.49,62.1},{62.41,84.09},{62.21,83.92},{19.3,60.99},{63.94,84.4},{48.91,80.21},{48.61,81.67},{49,82.8},{78.19,34.02},{79.78,30.03},{78.16,37.18},{81.49,31.04},{81.51,30.72},{80.73,34.72},{78.36,33.77},{24.24,43.97},{26.65,44.85},{26.15,45.75},{29.72,47.41},{23.85,44.84},{27.34,45.85},{26.76,47.07},{26.69,47.41},{29.63,45.31},{26.24,45.11},{29.16,45.43},{25.63,47.33},{25.24,45.19},{25.64,47.51},{25.58,47.43},{27.85,45.32},{26.61,47.69}},[47]={{57.42,68.77},{64.52,75.63},{67.38,65.78},{32.17,57.9},{61.91,75.18},{53.65,66.18},{55.66,84.4},{78.78,69.1},{48.94,51.07},{49.54,53.54},{63.25,60.33},{66.22,81.25},{78.25,79.35},{44.69,41.03},{62.4,66.78},{62.47,76.13},{65.71,81.39},{71.09,48.2},{61.43,72.82},{63.72,58.94},{53.39,38.57},{45.54,38.44},{64.18,83.09},{79.59,79.91},{77.38,81.11},{57.63,83.12},{57.83,79.99},{56.24,85.22},{62.91,75.64},{72.99,53.65},{60.42,64.76}},[85]={{52.13,69.63},{52.26,69.7},{61.49,78.24},{74.7,65.24},{54.68,41.77},{30.9,59.65},{60.21,34.05},{52.13,69.74},{81.8,69.7},{59.75,49.75},{39.82,53.65},{78.66,68.16},{79.62,41.25},{56.89,48.69},{32.39,55.87},{48.23,37.33},{60.88,76.96},{63.3,71.71},{29.81,71.41},{31.93,71.26},{47.06,53.06},{32.36,71.25},{47.72,30.66},{59.54,47.06},{63.22,75.15},{29.56,71.02},{47.77,29.57},{66.87,58.4},{58.02,31.75},{76.87,61.26},{47.02,53.93},{35.32,68.33},{30.52,56.98},{53.97,57.58},{59.52,73.1},{77.86,60.17},{81.89,68.86},{48.01,30.22},{60.32,71.47},{53.43,56.38},{45.06,53.39},{58.03,69.65},{49.63,37.39},{32.3,69.25},{80.29,47.87},{57.98,72.34},{61.36,68.13},{83.37,66.36},{31.28,67.25},{33.19,64.67},{53.12,53.74},{32.31,62.92},{58.8,34.05},{33.44,57.69},{47.65,37.06},{54.92,56.16},{58.67,37.24},{30.26,56.57},{77.89,61.88},{57.56,70.99},{59.04,34.57},{56.33,42.89},{46.14,32.03},{52.51,29.25},{58.69,33.14},{52.37,30.13},{58.71,36.24},{31.21,72.02},{57.97,74.23},{59.76,50.44},{33.26,57.64},{32.86,57.28},{32.17,61.12},{31.83,69.43},{29.68,69.03},{30.67,69.43},{60.11,70.98},{33.62,63.12},{79.21,40.92},{57.85,50.04},{63.28,75.06},{37.59,38.08},{55.84,41.17},{45.96,33.03},{62.46,77.28},{82.23,69.95},{59.51,37.67},{59.9,77.35},{58.77,36.14},{55.85,49.58},{58.82,48.26},{52.64,53.41},{56.7,48.9},{52.29,69.45},{65.14,34.15},{80.57,72.91},{39.48,48.13},{51.86,50.16},{33.31,61.04},{59.71,34.62},{62.02,40.43},{29.09,60.21},{32.25,59.56},{39.64,56.28},{40.76,56.85},{65.09,58.58},{34.35,62.29},{30.89,62.09},{50.72,60.6},{34.32,63.14},{51.37,50.06},{57.64,38.18},{29.8,71.41},{29.38,66.81},{30.47,60.56},{33.68,63.34},{30.32,60.26},{30.96,61.91},{31.77,59.63},{34.55,63.06},{34.33,62.31},{29.54,66.68},{31.06,58.96},{29.09,65.86},{30.71,62.24},{31.6,59.52},{34.33,63.18},{30.44,60.48},{34.37,62.3},{35.8,56.91},{35.58,56.22},{40.7,58.36},{37.15,56.97},{41.16,56.71},{40.83,58.25},{31.2,59.25},{29.57,66.81},{34.36,62.4},{31.5,59.42},{34.57,63.05},{30.47,60.9},{30.93,62},{39.27,44},{39.23,43.86},{67.37,63.34},{86.9,45.22},{58.03,53.02},{58.99,54.44},{56.63,63.54},{61.89,46.26},{59.05,54.47},{50.35,64.51},{53.96,61.15},{59.1,54.5},{58.1,53.22},{66.88,62.79},{58.24,52.9},{83.93,40.64},{66.88,62.81},{58.81,54.12},{89.03,44.02},{67.37,63.46},{66.89,62.77},{65.99,71.89},{59.76,71.16},{63.41,75.03},{65.67,70.67},{61.36,68.14},{60.22,71.36},{60.83,77.07},{63.26,75.6},{59.83,77.51},{58.73,76.61},{62.23,66.48},{58.01,69.92},{63.3,70.2},{64.53,68.17},{65.96,70.17},{58.08,74.08},{58.33,66.76},{59.51,73.05},{58.96,77.3},{62.27,77.23},{65.36,68.27},{63.35,71.56},{60.24,79.63},{58.05,72.41},{61.41,78.19},{57.73,70.63},{65.3,74.51},{62.2,66.68}},[130]={{51.77,77.63},{48.58,76.38},{59.83,81.15},{53.5,35.83},{54.68,68.3},{59.96,80.43},{55.34,68.7},{55.54,68.23}},[148]={{60.72,21.96},{59.79,24.02},{43.8,59.95},{38.83,43.9},{43.31,55.77},{46.16,86.61},{40.02,83.62},{44.84,60.44},{45.01,86.03},{41.84,84.65},{45.56,86.47},{43.77,60.73},{39.87,42.09},{40.48,83.54},{61.2,12.47},{62.21,19.96},{42.84,31.18},{61.68,10.66},{44.9,59.46},{61.28,11.52},{59.76,18.79},{47,56.74},{42.36,31.16},{43.31,31.88},{70.23,17.09},{44.67,31.13},{70.97,18.02},{45.63,57.21},{60.71,18.52},{41.58,83.84},{45.72,83.72},{69.83,21},{38.49,39.49},{38.93,42.82},{42.38,60.72},{45.39,31.37},{44.99,30.11},{57.92,24.59},{48.19,55.97},{39.88,85.31},{58.51,22.44},{44.48,56.8},{39.78,39.84},{44.34,57.81},{44.18,82.38},{43.29,57.45},{63.06,8.05},{45.22,58.55},{57.36,23.05},{48.1,55.89},{48.45,55.18},{48.64,55.07},{58.94,20.71},{62.51,9.1},{59.52,20.59},{58.88,18.8},{57.54,24.09},{43.79,32.81},{43.73,33.18},{59.06,20.03},{60.18,22.6},{60.48,21.2},{64.53,19.94},{61.8,20.99},{44.58,55.9},{62.94,10.65},{57.6,21.74},{58.77,24.92},{59.67,19.73},{61.42,19.3},{66.21,19.39},{59.9,18.01},{62.16,11.98},{45.55,83.31},{47.71,55.82},{48.58,55.64},{43.25,58.23}},[267]={{49.28,73.15},{49.85,72.09},{50.09,72.09},{50.11,72.03},{49.9,72.04},{50.8,72.4},{50.22,71.78},{50.13,71.88},{48.07,71.67},{49.76,72.1},{47.77,72.31},{48.53,73.18},{48.72,72.1},{47.89,72.55}},[331]={{86.25,54.25},{73.1,60.52},{88.22,50.64},{83.91,60.24},{74.17,62.54},{83.74,61.18},{86.3,60.32},{85.82,60.76},{73.72,62.73},{85.99,57.73},{72.97,57.93},{85.09,60.35},{85.69,58.9},{87.24,57.39},{72.52,58.61},{87.85,58.52},{87.5,62.06},{88.35,62.6},{90.09,50.6},{86.03,56.35},{89.51,49.34},{87.97,63.4},{73.3,59.95},{72.86,55.87},{89.28,51.61},{88.65,55.34},{90.65,53.55},{73.03,55.78},{87.44,63.24},{84.25,59.77},{86.87,61.06},{72.7,56.76},{78.28,75.3},{75.27,74.24},{78.1,74.05},{77.21,74.63},{75.84,76.12},{77.71,74.19},{75.76,74.2},{76.14,75.86},{75.43,74.23},{76.17,74.64},{76.16,73.12},{75.31,73.85},{75.73,73.5},{76.69,76.02},{76.45,73.39},{77.4,75.95},{75.29,75.39},{76.28,74.68},{75.44,74.3},{76.87,74.98},{75.59,76.05},{76.14,75.19},{66.3,56.19},{67.87,54.75},{66.38,55.03},{68.44,53.63},{60.62,51.77},{46.51,60.1},{45.94,60.03},{45.95,64.89},{51.27,64.14},{60.87,52.16},{12.79,35.43},{11.07,35.03},{12.45,35.54},{41.88,34.19},{11.94,34.71},{12.98,34.08},{40.47,31.34},{42.47,34.3},{39.89,33.48},{11.71,32.48},{39.98,34.22},{31.09,20.33},{31.6,23.01},{50.97,64.24},{11.45,34.55},{40.49,32.54},{12.57,34.18},{12.65,33.19},{41.93,33.39},{42.62,33.6},{41.45,33.05},{41.34,35.33},{38.77,30.51},{11.42,33.74},{11.85,33.79},{41.38,34.67},{31.13,23.55},{41.09,33.69},{42.46,33.88},{40.03,33.8},{40.15,32.65},{41.24,32.85},{39.91,32.23}},[405]={{54.96,67.13},{51.15,76.56},{53.21,80.47},{50.4,55.92},{72.13,69.89},{81.45,79.71},{70.84,75.48},{53.18,71.32},{47.73,57.48},{56.5,78.26},{52.43,58.48},{54.71,62.24},{39.51,95.18},{38.28,97.05},{60.41,65.37},{75.93,76.55},{46.2,40.64},{72.74,74.41},{52.71,59.49},{51.89,59.45},{54.63,37.79},{54.02,76.33},{52.76,61.5},{51.59,71.6},{50.31,73.83},{38.72,93.64},{49.19,57.4},{39.79,47.7},{56.42,72.1},{74.55,21.94},{51.1,58.04},{51.6,59.8},{41.26,78.69},{38.95,93.51},{40.25,91.97},{70.23,78.39},{73.78,74},{57.46,12.5},{69.1,77.15},{50.71,60.12},{71.67,76.4},{69.85,77.49},{57.53,47.66},{48.73,75.92},{38.75,95.31},{50.26,63.58},{56.69,39.03},{73.98,73.29},{53.15,59.63},{50.72,81.05},{80.26,78.83},{61.14,18.39},{58.53,14.45}},[406]={{75.71,74.42},{75.56,74.66},{37.49,71.95},{40.39,66.68},{44.38,31.99},{38.35,66.75},{39.35,71.39},{40.21,62.08},{36.44,74.52},{34.08,69.29},{36.91,72.05},{38.45,61.89},{40.26,62.57}},[495]={{46.73,27.93},{46.99,33.67},{43.45,33.07},{46.17,27.73},{37.71,10.22},{72.48,69.99},{47.24,36.06},{58.95,79.94},{64.92,53.79},{57.66,78.05},{47.3,32.14},{43.71,36.45},{59.27,76.49},{65.68,53.83},{43.25,31.56},{44.42,36.46},{46.79,31.66},{67.88,55.25},{57.98,75.72},{46.28,29.95},{46.73,30.55},{57.82,75.93},{68.9,52.66},{71.66,70.28},{45.61,34.09},{45.82,26.99},{46.13,26.43},{46.23,33.61},{46.43,37.09},{44.68,27.69},{67.88,52.14},{43.57,29.27},{69.39,55.39},{44.62,33.99},{43.73,30.57},{45.65,35.77},{44.37,29.04},{46.76,28.55},{65.59,56.07},{46.23,32.35},{45.73,29.27},{60.43,78.33},{43.57,34.39},{44.8,32.15},{60.65,80.26},{36.04,10.46},{45.45,28.68},{65.37,56.68},{70.83,71.57},{71.32,70.21},{34.2,9.99},{57.46,77.95},{58.51,78.47},{58.86,80.21},{60.07,79.42},{45.71,34.98},{43.98,35.21},{34.42,11.5},{45.06,27.04},{45.28,31.31},{44.61,29.73},{45.05,36.06},{60.5,80.72},{58.97,76.95},{38.34,12.31},{39.18,11.08},{59.32,77.16},{65.39,56.53},{62.21,80.19},{61.92,79.45},{61.77,79.71},{60,79.66},{57.71,77.51},{59.74,79.3},{61.86,80.28},{60.63,78.82},{58.89,77.87}},[796]={{-1,-1}},[1477]={{-1,-1}},[1519]={{70.7,70.66},{77.13,53.41},{61.33,69.28},{60.52,68.75},{77.55,53.1},{71.88,65.63},{61.81,69.38},{73.47,59.31},{73.44,58.72},{61,68.84},{42.55,43.82},{39.31,51.37},{35.58,32.6},{30.39,14.39},{33.36,12.62},{36.96,27.34},{37.2,26.94},{26.56,5.39},{39.99,85.99},{40.34,84.83},{23.68,33.08},{44.73,57.43},{21.75,33.6},{30.4,51.17},{35.56,32.48},{33.06,39.14},{42.88,73.09},{39.4,84.8},{24.06,32.77}},[1581]={{-1,-1}},[2057]={{-1,-1}},[2557]={{-1,-1}},[3433]={{47.52,35.38},{60.63,58.09},{47.51,34.98},{65.31,28.49},{64.16,28.37},{62.92,31.44},{63.13,30.07},{62.68,28.51},{62.55,31.84},{61.2,29.99},{61.3,28.4},{59.87,29.96},{59.66,28.6},{58.59,28.16},{28.03,14.85},{24.66,15.2},{27.64,38.94},{33.55,31.3},{20.96,44.59},{32.97,45.06},{36.77,78.15},{37.55,84.43},{32.61,84.78},{30.66,89.41}},[3456]={{-1,-1}},[3457]={{-1,-1}},[3518]={{49.08,56.4},{49.16,54.1},{43.37,22.29},{42.97,21.22},{44.19,20.17},{43.19,21.41},{44.81,21.89},{44.68,22.28},{44.73,20.02},{48.13,22.57},{46.74,19.9},{48.05,22.69},{47.85,22.85},{49.38,21.53},{72.89,67.87},{73.27,71},{73.08,68.38},{74.68,68.71},{75.39,68.73},{74.36,61.69},{74.91,64.46},{74.89,64.17},{75.74,62.12},{73.76,62.37},{75.77,61.51},{74.9,64.75},{75.63,62.21},{74.58,64.27},{74.02,62.22},{72.96,67.51},{74.48,68.83},{74.64,68.92},{73.4,70.92},{75.5,68.95},{73.11,71.08},{75.17,71.47},{74.48,71.88},{49.45,56.44},{48.95,54.31},{74.4,62.36},{73.09,67.63},{73.08,70.58},{74.1,71.64},{75.49,71.65},{75.62,68.73},{74.74,68.67},{75.2,65.08},{74.61,64.31},{75.76,62.28},{49,54.34},{49.08,56.41},{40.93,34.47},{40.95,31.76},{42.95,21.31},{43.36,22.44},{44.79,19.86},{44.81,22.2},{45.48,23.48},{46.6,19.89},{47.44,24.31},{48.25,23.49},{47.97,23.09},{49.57,21.1}},[3519]={{52.18,30.69},{52.38,28.88},{53.78,29.49},{52.24,32.11},{54.35,32.99},{49.61,66.93},{48.93,68.18},{49.24,68.42},{50.06,68.26},{49.95,67.23},{50.38,67.92},{48.9,67.27},{47.96,66.51},{48.16,67.73},{48.98,65.48},{49.05,66.06},{48.93,68.15},{48.87,67.3},{49.56,66.93},{48.17,67.8},{50.08,68.26},{50.39,67.92},{49.94,67.18},{49.21,68.44},{44.04,77.41},{43.8,77.66},{43.81,78.98},{42.65,75.1},{43.26,75.35},{43.42,74.94},{43.41,74.92},{42.56,53.1},{42.77,52.73},{43.66,52.41},{43.4,51.49},{43.96,52.62},{43.43,51.41},{43.11,50.26},{43.33,49.71},{43.89,51.26},{44.12,49.32},{43.93,50.85},{52.4,28.67},{51.81,30.85},{52.44,32.15},{64.63,52.66},{64.16,55.99},{67.09,53.73},{68.42,53.79},{53.72,29.55},{52.38,28.91},{51.94,30.53},{52.18,32.01},{54.23,32.96},{43.93,50.85},{43.91,51.22},{44.12,49.34},{43.31,49.8},{43.42,51.42},{43.12,50.27},{42.42,51.02},{42.07,51.3},{37.54,49.81},{37.33,49.82},{35.98,49.42},{36.96,49.87},{37.51,52.19},{36.47,51.83},{42.26,74.38},{43.42,74.94},{43.24,75.39},{42.69,75.09},{43.82,77.68},{44.01,76.75},{43.79,79.01},{48.16,67.72},{47.99,66.45},{48.92,68.17},{48.87,67.32},{49.22,68.43},{49.97,67.23},{50.08,68.27},{49.57,67},{48.96,65.42},{49.04,66.06},{50.4,67.87},{42.57,53.08},{41.26,40.7},{39.59,42.23},{37.89,41.42},{38.26,39.29}},[3524]={{47.46,70.06},{46.13,69.8},{45.71,71.35},{47.26,68.26},{46.94,68.76}},[3525]={{67.98,72.05},{61.23,87.86},{62.06,88.15},{38.05,41.38},{45.78,34.39},{45.47,28.36},{47.24,56.12},{46.05,60.74},{70.82,80.86},{67.47,72.3},{51.04,71.2},{51.77,80.12},{49.82,85.24},{37.97,89.11},{32.99,63.27},{32.96,58.83},{53.5,67.83},{56.22,64.38},{57.64,50.6},{59.88,39.85},{45.23,33.44},{35.1,44.84},{25.5,48.07},{28.33,61.03},{45.28,45.2},{47.07,54.96}},[3703]={{49.27,16.32},{50.56,16.89},{48.94,16.57},{48.82,16.39},{48.96,16.57},{49.06,16.52},{50.66,16.83},{48.87,16.43},{50.63,16.75},{47.56,17.24},{48.77,16.31},{50.28,18.03},{49.7,17.54},{49.92,16.19},{49.3,16.27},{50.6,16.73},{48.37,17.29},{48.85,16.44},{49.91,17.61},{49.8,16.28},{49.57,16.98},{50.76,17.26},{50.32,17.17},{50.52,16.67},{46.03,17.59},{45.01,18.16}},[3714]={{-1,-1}},[3791]={{-1,-1}},[3792]={{-1,-1}},[4100]={{-1,-1}},[4196]={{-1,-1}},[4395]={{63.46,55.71},{62.91,58.3}},[4415]={{-1,-1}},[4714]={{49.9,50.89},{42.64,47.11},{37.85,67.19},{28.88,69.3},{36.38,61.63},{37.84,67.36},{47.45,50.31},{49.82,50.74},{40.08,79.67},{38.56,64.37},{47.52,50.27},{41.79,36.12},{44.85,40.69},{29.16,80.54},{27.93,68.25},{37.15,65.75},{33.16,66.91},{48.51,56.59},{27.95,68.26},{78.98,28.35},{36.54,61.59},{46.21,87.72},{36.42,61.67},{26.76,67.47},{38.06,67.14},{71.87,29.78},{36.39,65.49},{80.64,31.99},{36.4,61.83},{33.01,67.18},{36.35,65.62},{32.96,66.85},{29.04,69.14},{24.02,75.57},{27.3,80.08},{33.42,76.81},{28.75,53.92},{51.35,79.83},{36.42,65.58},{75.91,31.11},{74.2,28.05},{85.16,75.56},{77.78,71.19},{81.75,26.12},{81.47,30.49},{48.61,56.72},{77.91,23},{72.93,29.97}},[4720]={{31.46,75.1},{30.96,74.01},{33.6,74.88},{31.35,74.58},{31.76,75.42},{33.13,74.68},{31.45,75.22},{31.45,75.22},{31.52,75.03},{33.73,74.71},{32.44,80.13},{30.83,74.04},{32.15,76.74},{31.79,76.39},{31.37,78.37},{33.4,76.15},{31.22,75.14},{30.75,74.46},{31.2,68.45},{35.45,77.36},{31.9,59.75},{32.51,76.12},{30.17,61.49},{35.88,68.18},{35.27,77.25},{32.43,80.16},{32.08,76.62},{34.79,67.38},{33.34,68.49},{30.85,67.15},{33.38,76.16},{35.01,62.59},{30.86,74.15},{34.67,81.23},{35.38,79.43},{35.01,70.95},{36.6,81.59},{35.32,82.94},{36.7,80.3},{35.09,64.5},{34.45,78.66},{33.5,75.79},{31.04,74.78},{33.88,79.56},{37.74,74.95},{36.5,72.6},{36.98,71.83},{35.85,73.03},{37.12,69.89},{36.21,70.37},{33.13,67.44},{35.91,72.99},{28.91,65.36},{36.45,72.67},{37.76,75.05},{30.91,63.8},{30.71,65.47},{29.99,65.55},{29.87,63.36},{32.56,61.55},{32.63,60.53},{30.91,63.99},{31.15,62.42},{30.77,65.44},{33.49,63.45},{30.92,63.9},{31.91,65.53},{31.04,62.87},{27.13,60.57},{24.94,63.37},{28.85,59.27},{34.14,64.17},{27.58,60.15},{28.59,60.48},{31.14,57.5},{26.55,59.9},{28.71,61.65},{30.17,61.72},{28.47,59.14},{24.9,63.43},{36.05,68.05},{33.35,63.48},{26.77,62.56},{30.83,66.78},{27.2,60.24},{35.96,68.26},{34.89,67.54},{30.86,67.13},{27.55,63.09},{31.08,62.84},{26.7,63.94},{35.32,64.24},{30.89,65.68},{30.13,58.31},{27.57,62.88},{29.08,57.9},{35.33,64.22},{32.45,66.24},{37.11,69.96},{29.84,63.28},{36.28,70.37},{35.81,65.2},{31.26,68.43},{33.47,68.84},{33.01,67.35},{31.72,65.5},{29.78,63.22},{32.62,60.53},{33.76,63.25},{32.53,62.9},{36.01,68.46},{35.38,69.66},{55.74,19.92},{53.35,25.46},{49.34,23.54},{49.16,23.12},{40.02,38.22},{52.82,18.49},{40.54,36.39},{50.48,27},{38.81,40.5},{40.95,32.54},{42.63,30.96},{49.31,23.48},{43.73,31.19},{47.31,19.71},{52.86,31.43},{54.62,28.48},{55.48,19.75},{40.51,27.97},{53.32,25.68},{55.21,30.19},{49,20.7},{46.53,21.52},{52.89,18.65},{40.18,36.07},{51.02,27.15},{43.47,20.72},{39.98,29.29}},[4755]={{50.47,81.58},{58.52,28.17},{36.15,29.3},{27.93,39.32},{29.22,65.3},{41.65,25.62},{32.41,70.73},{35.86,62.51},{29.15,66.51},{35.37,63.2},{59.62,39.82},{65.08,66.6},{37.63,55.49},{28.55,67.44},{24.97,53.99},{34.79,68.2},{35.15,61.94},{31.92,64.47},{61.01,44.56},{63.27,55.02},{31.28,73.72},{66.66,64.55},{60.71,82.62},{66.76,33.13},{68.96,42.97},{69.94,44.09},{51.28,71.55},{58.67,42.71},{34.62,45.24},{29.04,36.64},{64.17,20.7},{60.71,28.08},{59.26,83.56},{70.63,56.49},{62.87,76.08},{66.34,64.15},{50.78,80.29},{62.6,81.34},{51.1,85.22},{41.19,76.97},{32.28,73.89},{47.54,72.09},{38.56,24.4},{45.46,20.09},{56.02,38.56},{65.5,32.67},{43.12,30.79},{66.18,77.36},{47.42,80.45},{34.44,44.95},{50.37,82.64}},[5287]={{41.57,73.01},{40.07,67.75}}},nil,85,nil,nil,31,"AH",nil,0},
[4076] = {'Roach',8,8,1,1,0,{[10]={{85.94,31.54},{87.27,36.86},{88.66,39.78},{87.33,32.89},{85.96,31.32},{64.31,61.51},{53.96,23.07},{48.28,20.27},{75.76,32.66},{74.58,25.22},{48.58,60.84},{82.27,34.01},{47.37,68.27},{71.76,61.32},{72.81,52.54},{58.35,59.83},{56.55,22.92},{70.61,48.26},{49.05,65.41},{71.35,31.51},{61.73,65.16},{78.59,36.76},{88.62,31.03},{44.1,64.58},{54.86,65.77},{57.58,56.41},{59.76,61.74},{72.3,27.16},{59.74,57.88},{85.88,31.15},{75.99,32.62},{81.56,33.99},{71.93,60.39},{72.31,52.36},{70.84,48.39},{86.14,47.9},{71.38,31.15},{79.2,36.29},{75.03,71.65},{64.53,61.62},{67.1,76.96},{67.21,73.76},{70.33,72.28},{43.04,74.49},{72.42,65.57},{57.82,72.49},{63.75,74.79},{48.73,60.63},{47.2,68.14},{71.78,60.95},{68.01,71.46},{86.03,47.56},{48.75,65.05},{69.39,70.95},{51.88,78.42},{62.09,64.45},{64.57,78.59},{81.89,67.82},{44.4,64.3},{72.47,67.45},{53.55,79.29},{34.05,37.97},{22.35,27.46},{25.7,60.78},{20.5,29.95},{35.52,44.74},{26.81,34.52},{48.79,60.55},{47.62,68.16},{39.65,59.22},{48.91,64.52},{34.92,47.84},{39.9,25.21},{44.13,65.11},{40.32,61.35},{22.64,66.39},{34.33,75.31},{22.12,27.36},{25.7,60.67},{42.86,74.52},{20.51,30.08},{25.49,79.05},{23.21,79.24},{32.27,73.3},{39.16,72.11},{36.71,70.02},{37.45,74.27},{34.71,68.81},{25.25,27.1},{25.17,26.88},{74.42,24.41},{71.87,27.24}},[16]={{62.44,80.41},{63.8,83.36},{63.05,84.72},{60.85,78.11},{61.96,77.03},{60.02,77.02},{54.63,24.97},{71.98,16.54},{66.92,18.33},{65.86,17.58},{68.38,15.92},{66.03,17.31}},[33]={{68.45,48.36},{68.61,49.71},{67.91,47.28},{70.37,49.18},{67.54,47.91},{70.18,49.14},{68.72,48.85},{69.34,48.57},{70.58,48.89},{68.35,47.74},{67.06,54.35}},[44]={{16.35,55.04},{15.97,55.62},{16.39,57.41},{19.95,21},{19.98,22.11},{17.57,19.93},{19.32,16.54},{55.45,40.33},{50.57,41.69},{70.52,37.61},{39.82,63.45},{19.47,18.04},{18.61,18.38},{21.88,20.12},{49.21,38.15},{30.11,60.83},{78.48,64.52},{67.16,43.18},{54.68,39.68},{68.19,34.94},{67.53,30.13},{16.34,55.03},{23.04,25.85},{70.42,38.38},{19.52,24.5},{30.21,63.68},{74.11,52.58},{32.67,63.56},{48.25,38.46},{20.1,25.86}},[331]={{89.51,62.42},{84.42,62.33},{85.7,64.57},{72.32,56.78},{89.49,53.93},{89.09,53.68},{72.24,57.27},{73.18,62.47},{73.61,61.49},{85.47,56.72},{89.07,60.3},{73.88,62.3},{73.71,61.02},{73.14,56.75},{73.19,62.72},{72.92,58.6},{85.95,62.67},{73.29,57.62},{73.29,61.39},{72.26,57.82},{88.99,56.99},{89.63,58.04},{74.12,60.78},{73.21,59.19},{73.37,60.47},{72.94,58.2},{77.65,74.17},{77.26,73.07},{77.13,74.21},{75.79,76.36},{77.38,73.77},{76.34,75.66},{72.64,80.79},{76.51,74.81},{77.92,75.27},{78.36,74.25},{77.55,74.83},{77.05,74.1},{78.14,72.77},{77,74.94},{72.42,80.03},{75.27,72.91},{74.73,74.17},{77.38,74.22},{73.04,80.27},{77.83,73.57},{76.19,75.29},{72.93,80.84},{77.38,75.32},{77.07,76.26},{77.98,74},{77.29,73.07},{76.8,74.19},{77.36,74.18},{75.87,76.22},{78.38,75.12},{72.57,80.78},{67.73,54.44},{66.43,56.41},{66.24,52.37},{66.57,55.21},{66.65,54.61},{50.43,61.24},{60.89,53.01},{49.35,61.84},{45.18,61.65},{48.94,62.48},{47.15,64.94},{48.65,64.83},{50.34,64.93},{46.65,60.02},{60.86,52.11},{50.45,65.09},{46.45,66.41},{46.95,61.99},{45.62,62.42},{61.52,51.8},{42.08,33.76},{42.69,34.4},{50,64.85},{40.3,31.62},{31.58,20.39},{40.12,33.21},{50.31,65.11},{46.78,66.57},{40.75,31.73},{32.65,21.7},{42.87,34.67},{40.56,33.21},{40.27,33.55},{39.79,32.57},{39.28,30.7},{39.59,33.45},{40.29,34.19},{41.63,33.13},{41.45,32.43},{42.91,33.88},{42.28,35.12},{40.78,32.88},{41.08,34.36},{32.07,21.61},{31.3,23.14},{38.4,30.63},{31.16,22.47},{39.69,31.17},{40.54,33.93},{41.03,32.19},{42.45,34.85},{39.73,31.71},{38.94,30.69}},[400]={{14.53,8.31},{55.4,41.35},{6.23,24.86},{67.24,94.03},{6.9,40.28},{7.86,32.81},{18.47,45.78},{63.47,71.08},{20.9,49.17},{65.02,92.64},{34.96,40.11},{74.37,47.03},{89.44,51.6},{65.69,74.29},{40.43,62.52},{7.16,25.62},{19.01,46.44},{6.83,36.09},{15.95,44.09},{17.51,41.87},{40.68,63.43},{65.63,73.81},{56.23,41.87},{42.41,63.33},{45.88,63.85},{8.21,32.05},{55.39,41.43},{47.46,64.64},{63.77,79.51},{42.14,64.04},{65.3,44},{5.61,41.97},{65.46,69.83},{14.06,43.15},{64.04,71.86},{65.85,69.94},{21.42,47.31},{64.56,78.11},{66.17,72.09},{8.61,25.99},{63.95,70.08},{7.65,33.1},{60.82,49.87},{66.91,72.15},{65.51,66.62},{34.34,36.71},{70.54,95.37},{63.92,70.61},{9.67,43.51},{78.61,46.85},{71.09,48.7},{11.9,44.15},{9.5,26.96},{83.3,48.64},{7.68,43.01},{45.13,49.63},{17.22,46.53},{87.07,46.94},{64.28,70.39},{92.5,54.55},{82.51,47.5},{65.75,71.82},{8.79,42.21},{17.47,42.51},{9.03,26.07},{24.59,50.22},{91.5,77.49},{90.1,48.82},{74.24,47.06},{91.16,76.64},{65.4,43.71},{78.61,47.38},{70.84,48.8},{83.54,48.67},{90.77,44.01},{92.11,78.28},{86.96,46.66},{92.27,54.62},{82.17,47.47},{94.64,75.22},{91.44,77.74},{79.17,93.52},{91.47,77.06},{94.09,83.5},{95.56,82.36},{81.49,96.8},{88.41,89.51},{86.07,89.04},{92.17,78.65},{81.65,94.72},{94.9,81.29},{94.55,75.39},{79.73,94.87},{94.15,82.35},{93.28,82.5},{94.91,79.29}},[405]={{56.39,18.19},{59.27,31.55},{67.3,65.33},{54.13,62.66},{49.69,57.78},{51.99,57.2},{55.57,72.29},{72.4,78.45},{51.68,85.9},{51.85,75.89},{40.43,93.31},{53.44,32.96},{65.32,18.15},{73.46,71.91},{79.97,77.46},{38.46,95.49},{49.24,77.55},{73.04,35.75},{38.93,95.7},{48.9,48.93},{63.84,58.49},{71.4,71.99},{40.33,95.62},{79.29,77.58},{58.63,14.3},{41.24,41.72},{52.68,56.98},{52.18,46.63},{75.75,72.36},{30.68,78.84},{50.02,55.9},{56.58,76.24},{57.31,75.49},{79.4,79.2},{50.6,72.54},{53.17,79.17},{48.89,59.99},{50.43,63.01},{53.09,61.43},{72.08,77.96},{52.64,60.69},{49.42,56.67},{54.35,59.56},{40.13,95.18},{38.47,92.43},{70.37,74.85},{38.59,75.91},{55,77.54},{69.49,70.51},{53.94,59.65},{73.45,77.69},{56.62,17.66},{44.64,27.44},{44.1,45.93},{69.67,20.4},{54.02,7.98},{57.28,12.58},{54.16,7.85}},[406]={{75.97,77.34},{75.84,77.55},{41.05,72.85},{42.18,47.11},{45.52,33.66},{37.42,68.46},{42.49,47.24}},[440]={{43.69,17.53}},[495]={{36.27,15.49},{32.96,10.15},{33.07,9.13},{34.19,9.99},{34.42,11.47},{35.96,16.75},{37.01,9.36},{35.64,16.17},{33.92,14.01},{33.56,10.3},{36.25,11.22}},[722]={{-1,-1}},[1497]={{48.75,65.99},{48.64,69.1},{47.58,76.11},{48.96,66.18},{52.69,74.02},{58.71,98.06},{52.74,73.7},{59.25,89.65},{51.99,76.26},{52.72,75.1},{54.59,88.16},{72.04,36.98},{63.09,35.52},{60.67,41.96},{69.35,38.17},{54.65,30.39},{69.78,43.19},{61.26,34.8},{61.34,49.99},{67.76,36.52},{54.25,88.65},{69.25,53.36},{53.96,93.56},{83.88,65.52},{58.49,23.93},{83.57,32.91},{83.64,65.94},{62.75,35.17},{60.55,43},{49,56.13},{69.75,38.75},{47.93,71.06},{60.69,42.05},{58.75,88.99},{75.37,74.68},{48.39,66.05},{58.79,24.55},{70.05,33.37},{74.92,73.58},{62.19,61.24},{61.65,52.75}},[1583]={{-1,-1}},[2100]={{-1,-1}},[2557]={{-1,-1}},[3428]={{-1,-1}},[3429]={{-1,-1}},[3791]={{-1,-1}},[3792]={{-1,-1}},[4100]={{-1,-1}},[4277]={{-1,-1}},[4494]={{-1,-1}},[4714]={{29.22,76.2},{33.92,71.98},{68.8,54.07},{37.79,70.4},{34.85,68.47},{25.17,70.53},{34.91,72.67},{35.57,67.79},{28.7,66.23},{29.2,71.16},{68.18,57.61},{27.28,76.34},{28.23,79.17}},[4737]={{62.81,92.68},{63.56,97.84},{64.79,94.93},{62.7,92.73},{38.98,69.59},{36.86,69.45},{74.6,69.66},{44.11,74.27},{40.82,67.52},{45.06,76.07},{38.79,45.09},{73.89,81.6},{38.06,50.47},{37.52,84.36},{39.06,69.78},{36.78,69.41},{28.17,44.87},{39.05,83.49},{44.29,74.42},{39.33,79.11},{40.48,67.99},{45.07,76.04},{33.54,71.72},{40.48,83.51},{35.15,59.38},{38.87,45},{44.26,74.25},{27.86,45.41},{36.93,69.81},{39,69.94},{38.72,67.78},{44.27,74.38},{34.51,60},{42.72,77.37},{35.16,59.39},{32.55,76.85},{49.11,33.78},{27.95,45.01},{35.21,62.62},{39.18,45.54},{34.98,60.03},{38.91,44.57},{73.95,81.25},{68.78,77.75},{64.7,94.75}},[4755]={{35.8,79.25},{54.12,78.59},{28.08,65.58},{33.08,65.88},{64.63,63.46}},[4812]={{-1,-1}},[5287]={{64.64,27.03},{65.57,24.03},{65.94,24.43},{65.52,27.73},{64.82,25.45},{66.41,28.42},{65.85,28.77},{65.86,28.8},{67.34,24.79},{66.3,22.93},{65.5,24.03},{66.14,23.34},{65.55,27.75},{41.77,75.24},{67.51,22.91},{65.64,29.16},{42.25,73.11},{43.54,66.76},{65.93,28.81},{65.75,23.51},{66.65,28.33},{66.36,22.81},{40.03,67.49},{41.19,74.09}}},nil,331,nil,nil,188,"AH",nil,0},
[4077] = {'Gaxim Rustfizzle',1003,1003,30,30,0,nil,nil,0,nil,{1071,1074,1077,1079,1080,1085},64,"A",nil,0},
[4078] = {'Collin Mauren',1163,1163,32,32,0,{[1519]={{53.02,86.64}}},nil,1519,nil,{1075,1076,1078},12,"A",nil,0},
[4079] = {'Sentinel Thenysil',605,605,23,23,0,{[331]={{34.89,49.79}}},nil,331,{13849,13853,13964},{1082,13849,13853},80,"A",nil,2},
[4080] = {'Kaela Shadowspear',617,617,23,23,0,nil,nil,0,nil,{1070,1083,1084,1091},80,"A",nil,0},
[4081] = {'Lomac Gearstrip',950,950,29,29,0,{[1537]={{72.08,51.88}}},nil,1537,nil,{1072,1073},875,"A",nil,0},
[4082] = {'Grawnal',1163,1163,32,32,0,{[406]={{49.1,60.96}}},nil,406,nil,nil,29,"H","General Goods",640},
[4083] = {'Jeeda',664,664,24,24,0,{[406]={{50.53,63.38}}},nil,406,nil,nil,29,"H","Apprentice Witch Doctor",2176},
[4084] = {'Chylina',664,664,24,24,0,nil,nil,0,nil,nil,80,"A","General Supplies",896},
[4085] = {'Nizzik',664,664,24,24,0,nil,nil,0,nil,nil,31,"AH","Venture Armor Salesman",4224},
[4086] = {'Veenix',664,664,24,24,0,nil,nil,0,nil,nil,1801,"H","Venture Co. Merchant",4224},
[4087] = {'Arias\'ta Bladesinger',4120,4120,60,60,0,{[1657]={{56.54,46.01}}},nil,1657,{27225,28258},nil,80,"A","Warrior Trainer",51},
[4088] = {'Elanaria',4370,4370,62,62,0,{[1657]={{55.57,45.8}}},nil,1657,nil,{1683,1684,1686},80,"A",nil,2},
[4089] = {'Sildanair',1753,1753,40,40,0,{[1657]={{58.65,51.04}}},nil,1657,nil,nil,80,"A","Warrior Trainer",49},
[4090] = {'Astarii Starseeker',2884,2884,60,60,0,{[1657]={{43.35,77.9}}},nil,1657,nil,{3378},80,"A","Priest Trainer",51},
[4091] = {'Jandria',1939,1939,50,50,0,{[1657]={{42.23,78.88}}},nil,1657,nil,nil,80,"A","Priest Trainer",49},
[4092] = {'Lariia',1239,1239,40,40,0,{[1657]={{43.92,82.96}}},nil,1657,nil,nil,80,"A","Priest Trainer",49},
[4093] = {'[Deprecated for 4.x]Galak Wrangler',734,787,25,26,0,nil,nil,0,nil,nil,131,nil,nil,0},
[4094] = {'[Deprecated for 4.x]Galak Scout',664,713,24,25,0,nil,nil,0,nil,nil,131,nil,nil,0},
[4095] = {'[Deprecated for 4.x]Galak Mauler',840,896,27,28,0,nil,nil,0,nil,nil,131,nil,nil,0},
[4096] = {'[Deprecated for 4.x]Galak Windchaser',582,622,24,25,0,nil,nil,0,nil,nil,131,nil,nil,0},
[4097] = {'[Deprecated for 4.x]Galak Stormer',586,621,26,27,0,nil,nil,0,nil,nil,131,nil,nil,0},
[4098] = {'[Deprecated for 4.x]Galak Pack Runner',1172,1172,24,24,0,nil,nil,0,nil,nil,131,nil,nil,0},
[4099] = {'[Deprecated for 4.x]Galak Marauder',787,840,26,27,0,nil,nil,0,nil,nil,131,nil,nil,0},
[4100] = {'Screeching Harpy',768,814,28,29,0,nil,nil,0,nil,nil,514,nil,nil,0},
[4101] = {'Screeching Roguefeather',950,1003,29,30,0,nil,nil,0,nil,nil,514,nil,nil,0},
[4104] = {'Screeching Windcaller',1003,1003,30,30,0,nil,nil,0,nil,nil,514,nil,nil,0},
[4107] = {'Highperch Wyvern',896,950,28,29,0,{[400]={{13.29,38.43}}},nil,400,nil,nil,14,nil,nil,0},
[4109] = {'Highperch Consort',896,950,28,29,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4110] = {'Highperch Patriarch',1146,1207,30,31,0,nil,{[400]={{{10.04,33.88},{10.04,33.88},{9.74,34.01},{9.28,34.39},{9.13,35.09},{9.32,35.57},{9.6,35.68},{10.16,35.6},{10.46,35.34},{10.53,34.71},{10.43,34.32},{10.37,34.22}}}},0,nil,nil,14,nil,nil,0},
[4111] = {'Gravelsnout Kobold',787,840,26,27,0,nil,nil,0,nil,nil,26,nil,nil,0},
[4112] = {'Gravelsnout Vermin',734,787,25,26,0,nil,nil,0,nil,nil,26,nil,nil,0},
[4113] = {'Gravelsnout Digger',896,950,28,29,0,nil,nil,0,nil,nil,26,nil,nil,0},
[4114] = {'Gravelsnout Forager',840,896,27,28,0,nil,nil,0,nil,nil,26,nil,nil,0},
[4115] = {'[Deprecated for 4.x] Gravelsnout Ambusher',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","<Needs Scale>",0},
[4116] = {'Gravelsnout Surveyor',739,774,29,30,0,nil,nil,0,nil,nil,26,nil,nil,0},
[4117] = {'Cloud Serpent',1226,1226,40,40,0,{[400]={{29.25,25.79},{89.47,57.75},{92.8,57.54},{47.77,44.59},{60.95,49.05},{91.61,59.24},{16.92,33.59},{57.45,48.04},{47.76,56.89},{87.41,55.54},{95.71,60.01},{92.69,57.42},{94.74,57.5},{96.18,63.62},{97.63,58.94}}},nil,400,nil,nil,14,nil,nil,0},
[4118] = {'Venomous Cloud Serpent',1524,1524,40,40,0,{[400]={{30.02,30.47},{92.14,60.09},{43.52,56.63},{61.63,49.76},{43.21,55.43},{57.16,53.58},{61.29,51.53},{47.01,57.15},{60.81,50.63},{50.15,48.78},{87.62,53.85},{29.8,30.43},{61.8,52.72},{26.42,43.32},{61.83,51.43},{47.08,45.04},{62.15,56.99},{49.27,49.67},{49.41,44.64},{94.75,62.42},{93.93,58.9}}},nil,400,nil,nil,14,nil,nil,0},
[4119] = {'Elder Cloud Serpent',724,812,27,29,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4120] = {'Thundering Boulderkin',896,950,28,29,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4121] = {'Wandering Boulderkin',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4124] = {'Needles Cougar',840,896,27,28,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4126] = {'Crag Stalker',734,787,25,26,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4127] = {'Hecklefang Hyena',356,356,16,16,0,{[17]={{31.66,41.74},{34.18,39.66},{53.24,34.03},{54.59,34.12},{56.82,34.95},{56.56,32.85},{57.17,36.35},{57.81,35.38},{63.46,35.81},{61.71,36.57},{35.24,41.85},{35.71,40.68},{35.48,37.55},{32.76,41.51},{29.94,40.72},{30.42,46.61},{35.17,39.87},{65.38,18.86},{64.03,19.4},{63.74,36.42},{64.76,34.15},{61.98,36.58},{64.35,31.53},{65.86,19.85},{51.96,28.58},{52.48,28.46},{54.37,28.47},{55.16,26.23},{54.86,23.25},{54.44,25.09},{54.87,24.55},{57.2,22.45},{54.81,27.57},{52.97,26.32},{50.88,28.73}},[4709]={{38.3,14.6},{37.02,14.01}}},nil,17,nil,nil,38,nil,nil,0},
[4128] = {'Hecklefang Stalker',573,617,22,23,0,nil,nil,0,nil,nil,38,nil,nil,0},
[4129] = {'Hecklefang Snarler',417,449,18,19,0,nil,nil,0,nil,nil,38,nil,nil,0},
[4130] = {'[Deprecated for 4.x]Silithid Searcher',1163,1221,32,33,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4131] = {'[Deprecated for 4.x]Silithid Invader',1279,1342,34,35,0,nil,nil,0,nil,nil,310,nil,nil,0},
[4132] = {'Silithid Ravager',3302,3302,42,42,4,{[400]={{65.83,86.26},{70.4,86.16},{63.83,86.09},{68.42,82.34},{69.67,85.85}}},nil,400,nil,nil,310,nil,nil,0},
[4133] = {'[Deprecated for 4.x]Silithid Hive Drone',1221,1279,33,34,0,nil,nil,0,nil,nil,311,nil,nil,0},
[4138] = {'Jeen\'ra Nightrunner',2884,2884,60,60,0,{[1657]={{43.49,25.73}}},nil,1657,{27266,28260},nil,80,"A","Hunter Trainer",51},
[4139] = {'[Deprecated for 4.x]Scorpid Terror',1221,1279,33,34,0,{[400]={{87.47,73.51}}},nil,400,nil,nil,413,nil,nil,0},
[4140] = {'[Deprecated for 4.x]Scorpid Reaver',1107,1163,31,32,0,{[400]={{71.83,73.65}}},nil,400,nil,nil,413,nil,nil,0},
[4142] = {'[Deprecated for 4.x]Sparkleshell Tortoise',1050,1107,30,31,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[4143] = {'[Deprecated for 4.x]Sparkleshell Snapper',1279,1342,34,35,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[4144] = {'[Deprecated for 4.x]Sparkleshell Borer',1163,1221,32,33,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[4146] = {'Jocaste',1239,1239,40,40,0,{[1657]={{43.94,27.89}}},nil,1657,nil,{6103},80,"A","Hunter Trainer",51},
[4147] = {'[Deprecated for 4.x]Saltstone Basilisk',1050,1107,30,31,0,nil,nil,0,nil,nil,49,nil,nil,0},
[4149] = {'Kesteryth',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Foraging Trainer",0},
[4150] = {'[Deprecated for 4.x]Saltstone Gazer',1279,1342,34,35,0,nil,nil,0,nil,nil,49,nil,nil,0},
[4151] = {'[Deprecated for 4.x]Saltstone Crystalhide',977,1021,32,33,0,nil,nil,0,nil,nil,49,nil,nil,0},
[4153] = {'Kysandia',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Cat Trainer",0},
[4154] = {'Salt Flats Scavenger',1050,1163,30,32,0,nil,nil,0,nil,nil,73,nil,nil,0},
[4155] = {'Idriana',5544,5544,45,45,0,{[1657]={{43.26,51.19}}},nil,1657,nil,{4510},80,"A","Banker",131075},
[4156] = {'Astaia',1342,1342,35,35,0,{[1657]={{49.1,60.96}}},nil,1657,{29321,29323,29324,29325,29359},{29321,29323,29324,29325,29359},80,"A","Fishing Trainer",83},
[4157] = {'zzOLDKitari Farseeker',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4158] = {'[Deprecated for 4.x]Salt Flats Vulture',1163,1279,32,34,0,nil,nil,0,nil,nil,73,nil,nil,0},
[4159] = {'Me\'lynn',1342,1342,35,35,0,{[1657]={{59.77,37.41}}},nil,1657,nil,nil,80,"A","Tailoring Trainer",81},
[4160] = {'Ainethil',2399,2399,46,46,0,{[1657]={{53.91,38.52}}},nil,1657,nil,{29067,29481,29482},80,"A","Alchemy Trainer",81},
[4161] = {'Lysheana',4120,4120,60,60,0,{[1657]={{64.16,37.84}}},nil,1657,nil,nil,80,"A","Guild Master",786433},
[4163] = {'Syurna',1753,1753,40,40,0,{[1657]={{41.61,37.08}}},nil,1657,nil,{2241,2242},80,"A","Rogue Trainer",51},
[4164] = {'Cylania',1003,1003,30,30,0,{[1657]={{56.91,53.88}}},nil,1657,nil,nil,80,"A","Night Elf Armorer",4224},
[4165] = {'Elissa Dumas',992,992,35,35,0,{[1657]={{44.06,78.49}}},nil,1657,nil,nil,80,"A","Portal Trainer",177},
[4166] = {'Gazelle',14,14,3,3,0,{[17]={{49.13,43.97},{49.4,44.27},{63,61.98},{49.15,44.11},{49.53,44.21},{51.91,54.87},{63.06,62.15},{52,54.82},{51.95,54.73},{51.85,55.58},{62.54,61.53},{63.13,62.23},{65.25,65.26},{65.66,64.73},{65.45,65.11},{65.43,65.07},{65.46,65.42},{65.5,65.39},{47.13,65.16},{47.36,64.16},{47.34,65.76},{47.23,64.18},{48.73,43.89},{49,43.63},{49.05,44.14},{37.33,41.71},{35.43,35.87},{35.36,35.62},{37.19,41.58},{35.46,35.54},{39.61,57.73},{39.92,58.04},{39.2,45.57},{37.98,49.73},{50.16,28.58},{49.92,30.19},{50.13,29.4},{50.34,28.5},{50.49,28.59},{50.38,28.45},{52.86,85.99},{52.93,86.31},{52.98,86.09}},[215]={{38.32,60.01},{59.7,50.6},{50.38,31.75},{63.47,60.35},{35.96,33.59},{38.68,71.69},{45.61,12},{38.88,55.44},{51.79,40.86},{40.08,62},{43.12,12.72},{56.9,26.81},{66.13,58.4},{36.83,73.99},{48.26,43.57},{36.73,70.13},{46.6,30.84},{44.09,15.19},{47.95,49.25},{63.93,64.66},{42.84,39.58},{59.16,58.37},{58.79,29.53},{52.93,36.99},{42.97,71.62},{38.24,67.88},{62.64,57.22},{60.41,67.87},{56.15,64.55},{60.78,27.69},{59.03,62.64},{51.72,46.88},{48.54,65.95},{52.51,68.18},{35.4,75.7},{55.25,57.58},{50.45,68.44},{48.6,12.38},{57.36,20.84},{53.49,19.69},{47.18,70},{46.15,21.01},{42.37,62.77},{43.06,45.12},{47.79,39.9},{53.59,57.21},{41.77,15.45},{54.57,22.66},{45.24,42.58},{44.49,32.71},{46.55,16},{52.02,28.8},{50.7,64},{52.38,23.63},{49.43,26.49},{45.62,27.47},{51.09,16.99},{35.73,33.93}},[405]={{55.88,39.01},{67.72,47.95},{65.14,37.74},{61.46,41.13},{60.72,50.41},{62.56,50.68},{58.01,36.44},{53.33,39.37},{58.74,36.15},{63.31,54.71},{64,39.08},{56.27,48.42},{64.42,57.01},{59.77,54.97},{51.59,50.41},{54.98,47.33},{63.53,37.09},{62.15,53.5},{61.36,48.54},{65.72,39.94},{56.62,44.44},{51.39,47.37},{65.05,41.39},{58.02,41.03},{62.03,57.89},{60.66,48.52},{64.02,51.61},{59.75,40.71},{66.53,48.15},{59.28,45.27},{60.54,43.74},{54.37,43.61},{60.97,46.61},{60.09,57.51},{50.98,50.91},{63.82,50.2},{53.38,51.52},{61.05,45.42},{52.26,51.34},{64.12,42.37},{62.17,36.92},{58.74,54.24},{66.98,49.7},{50.58,50.44},{50.95,45.62},{66.39,43.42},{53.08,44.6},{55.11,41.08},{54.54,49.79},{59.53,53.08},{66.13,42.25},{65.28,41.02},{59.53,35.68},{67.63,45.85}},[1638]={{28.32,2.82},{39.67,22.27}},[4709]={{43.19,18.88},{50.42,35.42},{50.64,35.42},{50.55,35.57},{50.56,35.58},{42.81,32.15},{42.79,31.56},{43.47,35.29},{43.58,35.28},{43.64,35.81},{43.31,35.5},{46.27,38.71},{46.19,38.74},{45.97,38.85},{46.99,32.48},{47.06,32.43},{47.27,32.74},{42.46,49.02},{42.41,48.8},{42.3,48.91},{42.35,49.33},{42.15,49.25},{42.25,49.11},{42.1,48.99},{51.02,53.97},{49.83,52.02},{50.93,53.92},{50.9,54.11},{48.41,49.34},{45.87,55.01},{46.92,48.94},{42.78,31.17},{46.12,38.75}}},nil,215,nil,nil,188,"AH",nil,0},
[4167] = {'Dendrythis',1003,1003,30,30,0,{[1657]={{48.09,38.15},{48,37.99}}},{[1657]={{{33.62,15.91},{34.46,14.99},{35.24,14.07},{36.54,13.52},{37.07,15.12},{37.57,16.85},{37.78,19.46},{38.6,21.24},{39.85,20.36},{41.58,19.02},{42.92,18.45},{44.2,18.89},{45.12,19.83},{45.72,21.46},{46.26,23.2},{45.53,20.89},{44.88,19.32},{43.27,18.42},{42.04,18.72},{38.67,21.3},{37.93,19.85},{37.46,16.94},{36.65,13.72},{35.32,14}}}},1657,nil,nil,80,"A","Food & Drink Vendor",640},
[4168] = {'Elynna',1003,1003,30,30,0,{[1657]={{60.57,36.86}}},nil,1657,nil,nil,80,"A","Tailoring Supplies",128},
[4169] = {'Jaeana',1003,1003,30,30,0,{[1657]={{61.12,60.23}}},{[1657]={{{64.55,71.66},{65.15,69.08},{65.71,67},{66.59,64.89},{67.33,63.24},{67.83,61.59},{68.02,59.82},{67.8,57.5},{66.73,56.29},{65.29,55.51},{63.99,55.09},{62.54,55.13},{62.38,56.78},{62.35,58.23},{62.1,59.87},{61.82,61.54},{61.48,63.4},{60.77,65.5},{60.98,66.79},{61.65,68.1},{62.5,69.32},{63.54,70.57}}}},1657,nil,nil,80,"A","Meat Vendor",640},
[4170] = {'Ellandrieth',1003,1003,30,30,0,{[1657]={{60.68,58.42}}},nil,1657,nil,nil,80,"A","General Goods",640},
[4171] = {'Merelyssa',1003,1003,30,30,0,{[1657]={{61.11,63.08}}},nil,1657,nil,nil,80,"A","Blade Merchant",4224},
[4172] = {'Anadyia',1003,1003,30,30,0,{[1657]={{54.46,83.85}}},nil,1657,nil,nil,80,"A","Robe Vendor",4224},
[4173] = {'Landria',1003,1003,30,30,0,{[1657]={{59.67,67.56}}},nil,1657,nil,nil,80,"A","Bow Merchant",4224},
[4174] = {'Siannai',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Arrow Merchant",0},
[4175] = {'Vinasia',1003,1003,30,30,0,{[1657]={{57.89,71.83}}},nil,1657,nil,nil,80,"A","Cloth Armor Merchant",4224},
[4176] = {'Ki\'rasia',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Cloth Armor Merchant",0},
[4177] = {'Melea',1003,1003,30,30,0,{[1657]={{55.45,74.92}}},nil,1657,nil,nil,80,"A","Mail Armor Merchant",4224},
[4178] = {'Shaia',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Mail Armor Merchant",0},
[4179] = {'Freillania',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Shield Merchant",0},
[4180] = {'Ealyshia Dewwhisper',2769,2769,50,50,0,{[1657]={{57.84,71.56}}},nil,1657,nil,nil,80,"A","Two Handed Weapon Merchant",4224},
[4181] = {'Fyrenna',1003,1003,30,30,0,{[1657]={{63.86,52.96}}},nil,1657,nil,nil,80,"A","Food & Drink Vendor",640},
[4182] = {'Dalmond',386,386,17,17,0,nil,nil,0,nil,nil,80,"A","General Goods",384},
[4183] = {'Naram Longclaw',484,484,20,20,0,nil,nil,0,nil,nil,80,"A","Weaponsmith",4224},
[4184] = {'Geenia Sunshadow',2980,2980,51,51,0,{[493]={{52,32.89}}},nil,493,nil,nil,994,"AH","Speciality Dress Maker",4224},
[4185] = {'Shaldyn',328,328,15,15,0,nil,nil,0,nil,nil,80,"A","Clothier",4224},
[4186] = {'Mavralyn',417,417,18,18,0,nil,nil,0,nil,nil,80,"A","Leather Armor & Leatherworking Supplies",4224},
[4187] = {'Harlon Thornguard',713,713,25,25,0,{[148]={{50.76,19.22}}},nil,148,nil,nil,80,"A","Armorer & Shieldsmith",4224},
[4188] = {'Illyanie',713,713,25,25,0,nil,nil,0,nil,nil,80,"A","Cloth Armor Merchant",4224},
[4189] = {'Valdaron',300,300,14,14,0,nil,nil,0,nil,nil,80,"A","Tailoring Supplies",128},
[4190] = {'Kyndri',273,273,13,13,0,{[148]={{42.65,45.03}}},nil,148,nil,nil,80,"A","Baker",640},
[4191] = {'Allyndia',328,328,15,15,0,nil,nil,0,nil,nil,80,"A","Food & Drink Vendor",640},
[4192] = {'Taldan',356,356,16,16,0,nil,nil,0,nil,nil,80,"A","Drink Vendor",640},
[4193] = {'Grondal Moonbreeze',950,950,29,29,0,nil,nil,0,nil,nil,80,"A","Tailoring Trainer",81},
[4194] = {'Ullanna',328,328,15,15,0,{[148]={{42.58,44.96}}},nil,148,nil,nil,80,"A","Trade Supplies",128},
[4195] = {'Tiyani',328,328,15,15,0,nil,nil,0,nil,nil,80,"A","Food & Drink Vendor",640},
[4196] = {'Silithid Swarm',1,1,46,47,0,{[440]={{52.31,75.52}}},nil,440,nil,nil,310,nil,nil,0},
[4197] = {'Ken\'zigla',484,484,20,20,0,{[406]={{71.74,91.15}}},nil,406,nil,{1510},126,"H",nil,2},
[4198] = {'Braelyn Firehand',774,774,30,30,0,nil,nil,0,nil,{1087,1088},1801,"H",nil,0},
[4200] = {'Laird',300,300,14,14,0,nil,nil,0,nil,{26758},80,"A","Fish Vendor",643},
[4201] = {'Ziz Fizziks',484,484,20,20,0,nil,nil,0,nil,{1092,1093,1095,1096,1483},35,"AH",nil,0},
[4202] = {'Gerenzo Wrenchwhistle',1600,1600,27,27,0,{[406]={{63.06,45.76}}},nil,406,{25729},nil,47,nil,nil,0},
[4203] = {'Ariyell Skyshadow',1003,1003,30,30,0,{[1657]={{56.58,52.6}}},nil,1657,nil,nil,80,"A","Weapon Merchant",4224},
[4204] = {'Firodren Mooncaller',1342,1342,35,35,0,{[1657]={{49.14,68.77}}},nil,1657,nil,nil,80,"A","Herbalism Trainer",81},
[4205] = {'Dorion',1939,1939,50,50,0,{[1657]={{45.2,27.03}}},nil,1657,nil,nil,80,"A","Hunter Trainer",49},
[4206] = {'Talar',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Bear Trainer",0},
[4207] = {'Valyen Wolfsong',2471,2471,40,40,0,nil,nil,0,nil,nil,80,"A","Wolf Trainer",0},
[4208] = {'Lairn',5544,5544,45,45,0,{[1657]={{43.46,50.57}}},nil,1657,nil,nil,80,"A","Banker",131072},
[4209] = {'Garryeth',5544,5544,45,45,0,{[1657]={{43.41,50.88}}},nil,1657,nil,nil,80,"A","Banker",131072},
[4210] = {'Alegorn',1342,1342,35,35,0,{[1657]={{49.89,36.63}}},nil,1657,{29313,29314,29316,29318,29357},{29313,29316,29318,29357},80,"A","Cooking Trainer",83},
[4211] = {'Dannelor',1342,1342,35,35,0,{[1657]={{51.73,30.42}}},nil,1657,nil,nil,80,"A","First Aid Trainer",81},
[4212] = {'Telonis',2399,2399,46,46,0,{[1657]={{60.47,36.82}}},nil,1657,nil,{2853},80,"A","Leatherworking Trainer",83},
[4213] = {'Taladan',1342,1342,35,35,0,{[1657]={{56.41,31.01}}},nil,1657,nil,nil,80,"A","Enchanting Trainer",81},
[4214] = {'Erion Shadewhisper',4120,4120,60,60,0,{[1657]={{39.91,39.85}}},nil,1657,{27267,28262},{2259},80,"A","Rogue Trainer",51},
[4215] = {'Anishar',2769,2769,50,50,0,{[1657]={{42.25,36.4}}},nil,1657,nil,nil,80,"A","Rogue Trainer",49},
[4216] = {'Chardryn',1003,1003,30,30,0,{[1657]={{49.54,69.43}}},nil,1657,nil,nil,80,"A","Herbalism Supplies",128},
[4217] = {'Mathrengyl Bearwalker',2884,2884,60,60,0,{[1657]={{40.5,27.81}}},nil,1657,{27273,28289},{3370,3781,3785,3803,4986,5061,5923,5924,5925,5931,6001,6125,6761},80,"A","Druid Trainer",179},
[4218] = {'Denatharion',1939,1939,50,50,0,{[1657]={{40.08,27.09}}},nil,1657,nil,nil,80,"A","Druid Trainer",49},
[4219] = {'Fylerian Nightwing',1239,1239,40,40,0,{[1657]={{39.22,27.76}}},nil,1657,nil,nil,80,"A","Druid Trainer",49},
[4220] = {'Cyroen',1003,1003,30,30,0,{[1657]={{39.45,28.56}}},nil,1657,nil,nil,80,"A","Reagents",2176},
[4221] = {'Talaelar',1003,1003,30,30,0,{[1657]={{48.81,61.5}}},nil,1657,nil,nil,80,"A","Fish Vendor",640},
[4222] = {'Voloren',1003,1003,30,30,0,{[1657]={{48.45,61.2}}},nil,1657,nil,nil,80,"A","Fishing Supplies",128},
[4223] = {'Fyldan',1003,1003,30,30,0,{[1657]={{49.55,36.87}}},nil,1657,nil,nil,80,"A","Cooking Supplies",128},
[4224] = {'Talegon',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Cartography Supplies",0},
[4225] = {'Saenorion',1003,1003,30,30,0,{[1657]={{59.96,37.33}}},nil,1657,nil,nil,80,"A","Leatherworking Supplies",128},
[4226] = {'Ulthir',1003,1003,30,30,0,{[1657]={{54.57,38.85}}},nil,1657,nil,nil,80,"A","Alchemy Supplies",128},
[4228] = {'Vaean',1003,1003,30,30,0,{[1657]={{56.45,32.15}}},nil,1657,nil,nil,80,"A","Enchanting Supplies",128},
[4229] = {'Mythrin\'dir',1003,1003,30,30,0,{[1657]={{58.09,34.16}}},nil,1657,nil,nil,80,"A","Trade Supplies",128},
[4230] = {'Yldan',1003,1003,30,30,0,{[1657]={{61.05,58.46}}},nil,1657,nil,nil,80,"A","Bag Merchant",128},
[4231] = {'Kieran',1003,1003,30,30,0,{[1657]={{60.86,63.4}}},nil,1657,nil,nil,80,"A","Weapon Merchant",4224},
[4232] = {'Glorandiir',1003,1003,30,30,0,{[1657]={{60.31,62.62}}},nil,1657,nil,nil,80,"A","Axe Merchant",4224},
[4233] = {'Mythidan',1003,1003,30,30,0,{[1657]={{61,63.75}}},nil,1657,nil,nil,80,"A","Mace & Staff Merchant",4224},
[4234] = {'Andrus',1003,1003,30,30,0,{[1657]={{54.77,83.12}}},nil,1657,nil,nil,80,"A","Staff Merchant",4224},
[4235] = {'Turian',1003,1003,30,30,0,{[1657]={{59.27,67.09}}},nil,1657,nil,nil,80,"A","Thrown Weapons Merchant",4224},
[4236] = {'Cyridan',1003,1003,30,30,0,{[1657]={{52.55,77.34}}},nil,1657,nil,nil,80,"A","Leather Armor Merchant",4224},
[4237] = {'Urthoniir',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Leather Armor Merchant",0},
[4239] = {'Lewin Starfeather',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Leather Armor Merchant",0},
[4240] = {'Caynrus',1003,1003,30,30,0,{[1657]={{55.31,74.48}}},nil,1657,nil,nil,80,"A","Shield Merchant",4224},
[4241] = {'Mydrannul',1003,1003,30,30,0,{[1657]={{64.77,53.21}}},nil,1657,nil,nil,80,"A","General Goods",643},
[4242] = {'Frostsaber Companion',2769,2769,50,50,0,{[1657]={{32,81.15},{52.66,17.11},{35.75,22.66},{32.19,83.47},{42.1,17.66}}},nil,1657,nil,nil,80,"A",nil,0},
[4243] = {'Nightshade',2769,2769,50,50,0,{[1657]={{43.61,25.71}}},nil,1657,nil,nil,80,"A","Jeen'ra's Pet",0},
[4244] = {'Shadow',1003,1003,30,30,0,{[1657]={{45.39,27.06}}},nil,1657,nil,nil,80,"A","Dorion's Pet",0},
[4245] = {'Mistrunner',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Valyen's Pet",0},
[4246] = {'Moonprowler',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Kysandia's Pet",0},
[4247] = {'Stonepaw',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Talar's Pet",0},
[4248] = {'Pesterhide Hyena',787,840,26,27,0,nil,nil,0,nil,nil,38,nil,nil,0},
[4249] = {'Pesterhide Snarler',896,950,28,29,0,nil,nil,0,nil,nil,38,nil,nil,0},
[4250] = {'Galak Packhound',381,381,40,40,0,{[400]={{69.62,49.91},{69.59,49.62},{69.78,49.72}}},nil,400,nil,nil,131,nil,nil,0},
[4251] = {'Goblin Racer',1163,1163,32,32,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4252] = {'Gnome Racer',1163,1163,32,32,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4253] = {'Bear Form (Night Elf Druid)',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4254] = {'Geofram Bouldertoe',1342,1342,35,35,0,{[1537]={{50,26.29}}},nil,1537,nil,nil,55,"A","Mining Trainer",81},
[4255] = {'Brogus Thunderbrew',12665,12665,60,60,0,{[2597]={{-1,-1}}},nil,2597,nil,nil,1217,"A","Food & Drink",640},
[4256] = {'Golnir Bouldertoe',1003,1003,30,30,0,{[1537]={{51.52,26.31}}},nil,1537,{6388},{6391},55,"A","Mining Supplies",131},
[4257] = {'Lana Thunderbrew',21380,21380,60,60,0,{[2597]={{-1,-1}}},nil,2597,nil,nil,1217,"A","Blacksmithing Supplies",4224},
[4258] = {'Bengus Deepforge',2218,2218,45,45,0,{[1537]={{52.55,41.46}}},nil,1537,nil,nil,55,"A","Blacksmithing Trainer",81},
[4259] = {'Thurgrum Deepforge',1003,1003,30,30,0,{[1537]={{51.74,42.78}}},nil,1537,nil,nil,55,"A","Blacksmithing Supplies",4224},
[4260] = {'Venture Co. Shredder',905,905,29,29,0,{[33]={{57.04,41.95},{55.57,39.05}}},{[33]={{{44.13,23.39},{44.39,23.37},{44.62,23.46},{44.72,23.24},{44.84,23.04},{44.99,22.72},{45.1,22.61},{45.24,22.57},{45.38,22.71},{45.64,22.89},{45.72,23.06},{45.86,23.16},{46.02,23.17},{46.18,23.17},{46.34,22.91},{46.44,22.67},{46.54,22.39},{46.6,22.13},{46.6,21.99},{46.53,21.62},{46.35,21.52},{46.13,21.49},{46.01,21.48},{45.8,21.35},{45.73,21.13},{45.67,20.89},{45.5,20.82},{45.4,20.79},{45.29,20.75},{44.97,20.65},{44.91,20.85},{44.85,21.02},{44.78,21.23},{44.79,21.41},{44.82,21.67},{44.79,21.9},{44.76,22.08},{44.58,22.42},{44.39,22.53},{44.23,22.64},{44.02,22.76},{43.91,22.98},{43.89,23.18}}}},33,nil,nil,47,nil,nil,0},
[4261] = {'Bear Form (Tauren Druid)',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4262] = {'Darnassus Sentinel',116235,116235,85,85,0,{[141]={{54,89.61},{53.99,89.25},{55.22,91.31},{55.15,88.4},{55.39,89.04},{55.26,88.41},{56.97,89.45},{38.43,47.39},{38.42,47.69},{54.73,90.24},{55.02,88.52}},[1657]={{42.22,77.03},{58.98,45.15},{44.53,51.27},{59.42,50.36},{58.34,45.12},{43.91,84.7},{42.47,77.9},{37.12,50.02},{48.99,19.63},{49.36,19.3},{59.13,54.72},{44.19,85.15},{58.52,54.7},{38.65,79.07},{40.46,82.41},{59.4,49.44},{50.11,22.93},{48.46,18.71},{44.04,84.96},{42.56,74.38},{44.42,51.94},{45.85,79.59},{43.82,77},{45.88,82.1},{43.6,85.13},{37.11,50.94},{43.66,77.85},{40.38,79.85},{47.6,78.69},{43.45,74.31}}},nil,1657,nil,nil,79,"A",nil,1},
[4263] = {'Deepmoss Hatchling',300,300,14,14,0,nil,nil,0,nil,nil,312,nil,nil,0},
[4264] = {'Deepmoss Matriarch',573,573,22,22,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4265] = {'Nyoma',484,484,20,20,0,{[141]={{56.73,53.51}}},nil,141,{6344},{6343},80,"A","Cooking Supplies",131},
[4266] = {'Danlyia',386,386,17,17,0,{[141]={{55.16,49.99}}},nil,141,nil,nil,80,"A","Food & Drink Vendor",640},
[4267] = {'Daelyshia',232470,232470,85,85,1,{[331]={{34.41,47.99}}},nil,331,nil,nil,80,"A","Hippogryph Master",8193},
[4268] = {'Gray Wolf',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4269] = {'Chestnut Mare',55,55,2,2,0,{[1519]={{77.13,67.11}}},nil,1519,nil,nil,35,"AH",nil,0},
[4270] = {'Red Wolf',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4271] = {'Dire Wolf',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4272] = {'Brown Wolf',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4273] = {'Keeper Ordanus',571,571,24,24,0,{[331]={{62.05,51.37}}},nil,331,nil,nil,79,"A",nil,0},
[4274] = {'Fenrus the Devourer',2605,2605,21,21,1,nil,nil,0,nil,nil,14,nil,nil,0},
[4275] = {'Archmage Arugal',4640,4640,21,21,1,nil,nil,0,nil,nil,14,nil,nil,0},
[4276] = {'Piznik',484,484,20,20,0,nil,nil,0,nil,{1090},35,"AH","Venture Co.",0},
[4277] = {'Eye of Kilrogg',3400,3400,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4278] = {'Commander Springvale',11600,11600,21,21,1,{[209]={{-1,-1}}},nil,209,nil,nil,16,nil,nil,0},
[4279] = {'Odo the Blindwatcher',2605,2605,21,21,1,nil,nil,0,nil,nil,14,nil,nil,0},
[4280] = {'Scarlet Preserver',773,773,29,30,0,{[85]={{83.68,28.85},{82.75,29.83},{83.64,34.04}}},nil,85,nil,nil,67,nil,nil,0},
[4281] = {'Scarlet Scout',905,905,29,30,0,{[85]={{83.64,37},{81.58,30.33},{83.14,37.42},{80.9,29.56},{81.48,29.72},{82.33,36.95}}},nil,85,nil,nil,67,nil,nil,0},
[4282] = {'Scarlet Magician',704,704,29,30,0,{[85]={{80.29,32.42},{82.04,35.93}}},nil,85,nil,nil,67,nil,nil,0},
[4283] = {'Scarlet Sentry',955,955,29,30,0,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4284] = {'Scarlet Augur',811,811,30,31,0,{[85]={{83.85,32.67},{83.81,32.53},{85.07,31.43},{84.58,31.63},{84.61,31.74},{83.63,31.93},{83.59,31.8},{85.04,31.31}}},nil,85,nil,nil,67,nil,nil,0},
[4285] = {'Scarlet Disciple',850,850,31,31,0,{[85]={{83.68,31.87},{83.59,31.8},{85.04,31.31},{83.85,32.67},{83.81,32.53},{84.61,31.74},{85.07,31.43}}},nil,85,nil,nil,67,nil,nil,0},
[4286] = {'Scarlet Soldier',4880,4880,35,35,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4287] = {'Scarlet Gallant',3712,3712,32,33,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4288] = {'Scarlet Beastmaster',4440,4440,32,33,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4289] = {'Scarlet Evoker',3740,3740,35,35,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4290] = {'Scarlet Guardsman',4880,4880,35,36,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4291] = {'Scarlet Diviner',3712,3712,33,33,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4292] = {'Scarlet Protector',4200,4200,35,36,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4293] = {'Scarlet Scryer',3092,3092,29,30,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4294] = {'Scarlet Sorcerer',4016,4016,37,38,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4295] = {'Scarlet Myrmidon',5108,5108,36,36,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4296] = {'Scarlet Adept',3712,3712,32,33,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4297] = {'Scarlet Conjuror',3608,3608,35,35,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4298] = {'Scarlet Defender',5108,5108,36,36,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4299] = {'Scarlet Chaplain',3712,3712,33,33,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4300] = {'Scarlet Wizard',4160,4160,38,39,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4301] = {'Scarlet Centurion',5836,5836,38,39,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4302] = {'Scarlet Champion',4720,4720,39,39,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4303] = {'Scarlet Abbot',4720,4720,39,39,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4304] = {'Scarlet Tracking Hound',4228,4228,32,32,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4305] = {'Kriggon Talsone',699,699,25,25,0,{[40]={{36.23,90.18}}},nil,40,nil,nil,12,"A","Fisherman",640},
[4306] = {'Scarlet Torturer',3820,3820,29,30,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4307] = {'Heldan Galesong',713,713,25,25,0,nil,nil,0,nil,nil,80,"A","Fisherman",640},
[4308] = {'Unfettered Spirit',905,905,29,30,0,{[796]={{-1,-1}}},nil,796,nil,nil,21,nil,nil,0},
[4309] = {'Gorm Grimtotem',6474,6474,62,62,0,nil,nil,0,nil,nil,105,"H",nil,0},
[4310] = {'Cor Grimtotem',6474,6474,62,62,0,nil,nil,0,nil,nil,105,"H",nil,0},
[4311] = {'Holgar Stormaxe',1003,1003,30,30,0,{[14]={{46.03,12.93}}},nil,14,nil,{43926},29,"H",nil,0},
[4312] = {'Tharm',232470,232470,85,85,1,{[406]={{48.47,61.93}}},nil,406,nil,nil,104,"H","Wind Rider Master",8193},
[4314] = {'Gorkas',232470,232470,85,85,1,{[47]={{81.7,81.76}}},nil,47,nil,nil,29,"H","Wind Rider Master",8193},
[4316] = {'Kolkar Packhound',273,273,13,13,0,{[17]={{56.29,88.05},{56.36,88.09},{54.22,76.86},{53.05,80},{55.54,86.83},{51.02,84.66},{57.24,77.99},{58.49,82.13},{52.56,78.09},{55.99,86.91},{52.6,77.98},{54.38,81.65}}},nil,17,nil,nil,130,nil,nil,0},
[4317] = {'[Deprecated for 4.x]Nyse',10572,10572,65,65,1,nil,nil,0,nil,nil,104,"H","Wind Rider Master",8193},
[4318] = {'[Deprecated for 4.x] Delyka',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[4319] = {'[Deprecated for 4.x]Thyssiana',10572,10572,65,65,1,nil,nil,0,nil,nil,80,"A","Hippogryph Master",8193},
[4320] = {'Caelyb',1524,1524,40,40,0,{[331]={{47.86,66.2}}},nil,331,nil,nil,80,"A","Pet Trainer",1},
[4321] = {'Baldruc',232470,232470,85,85,1,{[15]={{67.48,51.3}}},nil,15,nil,nil,894,"A","Gryphon Master",8193},
[4322] = {'Corthryn',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[4323] = {'Searing Hatchling',1751,1751,39,40,0,{[15]={{39.37,72.85},{56.13,71.2},{41.8,65.85},{45.78,72.96},{43.9,78.11},{45.05,79.14},{50.04,69.45},{46.84,80.18},{45.64,82.29},{53.65,82.21},{54.63,72.8},{52.55,70.18},{49.25,67.37},{48.86,66.49},{47.7,66.31},{44.84,64.59},{46.25,67.38},{46.11,69.64},{45.3,71.17},{45.88,82.38},{43.97,78.56}}},nil,15,nil,nil,103,nil,nil,0},
[4324] = {'Searing Whelp',1362,1362,38,39,0,{[15]={{54.95,84.42},{51.71,67.46},{44.68,74.41},{43.08,69.14},{43.69,79.85},{44.68,76.79},{45.07,75.59},{47.42,81.34},{48.1,80.7},{48.55,78.61},{47.22,77.96},{44.15,66.52},{54.65,70.19},{51.41,71.37},{47.13,67.49},{46.95,65.92},{45.02,67.96},{43.96,64.4},{45.62,65.08},{47.64,70.41},{46.76,71.5},{51,74.63},{48.93,70.17},{43.58,79.91}}},nil,15,nil,nil,103,nil,nil,0},
[4328] = {'Firemane Scalebane',1135,1135,37,38,0,{[15]={{57.25,76.98},{56.89,75.75},{51.52,81.59},{50.11,83.23},{56.6,73.65},{57.29,78.59},{50.38,81.43},{56.61,79.51},{56.6,77.71},{55.95,81.58},{54.65,74.64},{53.97,72.64},{56.56,75.66},{53.33,82.65},{52.47,83.41},{37.21,67.26},{36.65,69.44},{37.83,67.3},{36.69,69.38},{37.49,67.98},{36.67,69.32},{53.91,72.05},{38.59,68.08},{37.86,69.46},{48.76,73.9},{48.52,73.12},{50.93,75.67},{50.97,76.62},{51.58,75.57},{52.31,75.01},{52.69,75.39},{51.64,74.83},{48.13,73.62},{48.77,75.57},{48.13,75.53},{36.6,69.61},{37.43,68.51}}},nil,15,nil,nil,103,nil,nil,0},
[4329] = {'Firemane Scout',1395,1395,37,38,0,{[15]={{48.02,77.44},{44.62,67.29},{48.96,67.34},{45.36,67.2},{38.95,64.54},{38.96,67.08},{38.76,65.81},{38.81,65.85},{37.95,68.24},{44.03,65.3},{51.94,70.68},{43.24,65.08},{42.82,66.37},{44.55,64.76},{45.67,65.85},{45.21,65.28},{49.49,68.38}}},nil,15,nil,nil,103,nil,nil,0},
[4331] = {'Firemane Ash Tail',1135,1135,37,38,0,{[15]={{48.04,77.19},{48.88,67.29},{36.66,69.42},{39.36,65.32},{39.42,64.46},{40.02,65.31},{42.17,67.18},{39.49,66.15},{38.75,65.71},{38.83,65.65},{38.99,65.82},{44.61,66.35},{45.15,66.21},{43.91,66.08},{44.7,65.45},{51.93,70.63},{43.13,65.89},{49.72,67.98},{37.84,68.22}}},nil,15,nil,nil,103,nil,nil,0},
[4333] = {'Firemane Devourer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4334] = {'Firemane Flamecaller',1135,1135,38,39,0,{[15]={{54.12,84.2},{56.37,82.01},{50.9,82.32},{52.61,84.09},{57.76,79.51},{56.97,75.2},{56.43,75.11},{51.99,83.47},{57.84,77.56},{53.07,84.63},{53.27,72.8},{52.15,84.44},{56.11,82.51},{54.31,83.61},{55.66,81.67},{48.4,74.78},{51.61,67.74},{48.06,76.24},{48.72,76.36},{50.96,78.34},{50.39,79.53},{50.39,77.7}}},nil,15,nil,nil,103,nil,nil,0},
[4339] = {'Brimgore',2188,2188,39,39,4,{[15]={{39.18,74},{50.14,75.67}}},{[15]={{{42.15,76.44},{42.19,77.01},{42.11,77.42},{42.03,78.14},{42.18,78.59},{42.12,79.09},{42.17,79.68},{42.2,80.4},{42.52,80.56},{42.88,80.65},{43.23,80.63},{43.8,80.3},{44.23,80.74},{44.59,81.17},{45.11,81.42},{45.61,81.52},{46.18,81.08},{46.63,81.25},{47.24,81.37},{47.94,81.89},{47.34,82.18},{47.16,82.19},{46.88,82.05},{46.63,81.94},{46.21,80.92},{45.66,81.38},{45.19,81.53},{44.72,81.16},{44.25,80.77},{43.81,80.33},{43.6,80.08},{43.09,79.66},{42.54,79.46},{42.11,79.4},{42.12,78.57},{42.18,77.87},{42.13,77.28},{42.21,76.52}}}},15,nil,nil,103,nil,nil,0},
[4340] = {'Mirallia',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[4341] = {'Drywallow Crocolisk',1220,1220,35,36,0,{[15]={{50.34,20.14},{44.56,18.63},{45.26,19.61},{37.01,26},{36,25.81},{37.28,25.2},{36.98,28.17},{59.76,34.91},{36.48,27.59},{59.48,34.24},{38.18,29.38},{52.03,20.18},{49.41,22.36},{48.3,22.32},{51.61,19.55},{45.99,20.53},{46.49,22.15}}},nil,15,nil,nil,16,nil,nil,0},
[4342] = {'Drywallow Vicejaw',1500,1500,36,37,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4343] = {'Drywallow Snapper',1220,1220,35,36,0,{[15]={{36.98,41.9},{42.08,39.5},{39.89,34.55},{35.91,43.4},{38.77,35.31},{34.36,33.97},{35.64,35.93},{36.52,44.12},{38.73,42.76},{40.14,44.32},{44.79,41.47},{44.52,39.77},{40.72,32},{40.39,41.95},{43.21,39.71},{39.31,44.89},{42.47,41.34},{33.41,42.74},{39.31,41.28},{44.15,43.26},{42.04,45.8},{42.02,37.58},{38.13,42.13},{34.42,41.51},{35.13,44.03},{41.05,44.66},{42.81,36.67},{41.26,33.26},{34.82,45.15},{40.58,41.51},{43.55,44.11},{33.71,42.27},{43.17,45.45},{35.4,34.57},{34.14,40.56},{36.32,42.58},{38.29,45.01},{40.13,32.86},{40.06,38.07},{37.55,35.06},{36.15,34.77},{40.94,33.62},{41.24,38.85},{40.85,37.65}}},nil,15,nil,nil,16,nil,nil,0},
[4344] = {'Mottled Drywallow Crocolisk',1208,1208,36,37,0,{[15]={{40.53,49.28},{37.74,56.94},{35.69,48.98},{35.94,58.35},{43.8,57.8},{45.83,53.17},{44.71,49.21},{35.05,48.79},{45.58,49.22},{40.15,47.75},{37.13,51.17},{35.28,55.5},{35.7,50.11},{36.38,59.36},{34.82,58.35},{45.43,48},{44.69,51.29},{40.84,60.56},{36.92,60.6},{44.57,46.84},{37.82,59.58},{38.86,59.84},{43.65,58.45},{35.75,61.14},{36.7,59.2},{45.28,51.72},{35.15,57.48},{37.22,45.63},{43.46,56.56},{38.55,46.8},{34.87,50.77},{40.91,55.17},{34.84,60.51},{42.65,55.87},{42.54,50.19},{43.34,47.12},{42.32,48.89},{43.08,48.44},{39.55,53.08},{37.68,46.34},{39.04,47.81},{39.1,47.81},{43.77,49.93},{40.21,51.27},{41.85,54.86},{41.8,55.84},{42.44,53.21},{42.69,52.49},{41.49,57.5},{40.53,58.36},{39.19,58.78},{38.53,54.23},{39.03,53.54},{37.83,53.62},{38.77,57.75},{38.4,49.93}}},nil,15,nil,nil,16,nil,nil,0},
[4345] = {'Drywallow Daggermaw',1395,1395,38,39,0,{[15]={{52.38,70.94},{43.81,62.03},{38.39,70.78},{50.78,52.47},{43.52,60.74},{41.29,66.16},{41.42,63.19},{55.86,72.74},{50.49,69.98},{38.48,72.53},{50.55,80.92},{46.47,63.2},{52.15,69.19},{54.86,70.74},{48.46,49.1},{45.96,74.89},{50.54,62.29},{50.25,56.29},{42.5,61.64},{44.56,62.46},{51.05,74.84},{48.44,68.83},{41.91,64.72},{51.02,72.68},{45.5,77.71},{50.44,62.82},{49.78,64.4},{56.52,71.8},{37.67,57.04},{48.4,50.04},{54.42,69.11},{55.07,69.57},{43.16,78.74},{49.85,79.94},{41.38,69.13},{55.48,71.81},{50.57,54.62},{50.56,69.25},{56.82,69.52},{51.01,70.6},{50.33,68.04},{49.43,52.99},{56.08,68.74},{50.76,76.53},{45.38,61.82},{46.39,75.89},{54.17,72.2},{48.39,64.51},{50.35,59.87},{43.18,63.67},{43.44,76.6},{45.71,62.68},{44.51,72.97},{50.92,61.14},{47.18,78.38},{45.85,76.24},{44.37,79.43},{45.05,79.69},{37.55,71.73},{43.96,68.23},{47.24,64.6},{47.28,51.61},{48.77,57.32},{39.72,71.75},{47.9,79.26},{49.86,70.97},{49.42,57.94},{43.86,75.77},{50.18,73.65},{49.78,74.73},{49.3,73.83},{52.49,72.85},{52.78,71.67},{39.1,69.71},{53.58,70.78},{46.55,78.91},{55.55,73.55},{49.76,56.56},{48.69,65.34},{49.25,79.7},{48.37,70.89},{49.08,72.08},{42.58,70.06},{42.2,69.35},{46.95,69.24},{44.88,69.82},{46.38,69.83},{44.56,70.76},{47.28,71.28},{47.63,71.61},{47.19,73.01},{46.56,74},{47.55,75.83},{49.08,77.9},{47.91,77.37},{46.47,59.88},{46.33,61.46},{47.9,55.4},{45.98,60.11},{47.54,54.1},{46.73,54.64},{46.28,53.88},{47.21,74.64},{49.85,57.8},{46.97,54.67},{49.88,58.35},{43.48,77.17},{43.16,78.32},{43.89,79.41}}},nil,15,nil,nil,16,nil,nil,0},
[4346] = {'Noxious Flayer',1277,1277,35,36,0,{[15]={{51.11,13.09},{55.28,18.98},{60.27,27.29},{60.13,25.18},{38.13,23.55},{52.69,17.2},{59.8,21.51},{59.39,30.19},{37.01,12.37},{52.43,14.12},{62.16,38.01},{58.5,28.85},{61.1,34.82},{58.62,20.73},{63.51,40.21},{52.72,12.66}}},nil,15,nil,nil,14,nil,nil,0},
[4347] = {'Noxious Reaver',1395,1395,37,38,0,{[15]={{43.46,35.2},{35.32,41.19},{40.75,43.51},{45.3,41.99},{40.14,40.04},{43.31,43.36},{35.79,45.28},{34.66,41.77},{41.76,43.7},{37.55,44.91},{37.65,43.15},{41.27,39.86},{38.14,40.99},{42.18,42.8}}},nil,15,nil,nil,14,nil,nil,0},
[4348] = {'Noxious Shredder',1336,1336,36,37,0,{[15]={{43.5,61.74},{44.41,53.66},{43.41,48.2},{38.98,51.81},{42.98,55.1},{41.46,47.68},{41.23,54.27},{34.71,49.41},{43.77,52.97},{42.16,63.26},{41.61,48.94},{41.94,46.76},{37.72,54.94},{37.16,52.03},{33.28,57.99},{36.24,51.33},{36.53,56.62},{38.09,55.82},{36.49,49.42},{43.93,48.71},{42.15,57.83},{40.36,56.58},{40.74,53.54},{37.05,54.2},{38.61,52.5},{47.21,62.04},{49.85,59.72},{48.01,59.92},{49.8,61.42},{49.06,60.19}}},nil,15,nil,nil,14,nil,nil,0},
[4351] = {'Bloodfen Raptor',1277,1277,36,37,0,{[15]={{52.28,17.12},{51.02,16.05},{45.87,16.67},{49.62,20.39},{50.87,21.28},{51.52,20.46},{49.12,15.81},{48.2,15.32},{48.96,19.93},{46.93,18.62},{47.79,19.77},{48.35,18.9},{49.7,18.43},{47.05,17.81},{48.88,17.6},{48,17.43},{46.69,15.63},{46.69,16.59},{47.16,18.53}}},nil,15,nil,nil,48,nil,nil,0},
[4352] = {'Bloodfen Screecher',1336,1336,36,37,0,{[15]={{52.26,19.12},{47.89,14.25},{47.3,14.63},{50.55,15.67},{52.11,15.33},{50.25,19.61},{51.94,21.29},{51.63,21.88},{49.61,16.61},{48.54,20.78},{46.65,17.91},{50.41,17.7},{47.22,17.77},{47.18,17.62},{45.86,19.37},{45.14,20.83},{46.35,17.87},{47.34,16.61},{48.24,16.59},{47.87,17.65},{47.69,15.74},{48.5,14.87},{47.28,14.72},{47.92,14.14}}},nil,15,nil,nil,48,nil,nil,0},
[4355] = {'Bloodfen Scytheclaw',1500,1600,37,38,0,nil,nil,0,nil,nil,48,nil,nil,0},
[4356] = {'Bloodfen Razormaw',1395,1395,38,39,0,{[15]={{32.47,64.28},{34.64,66.46},{37.87,70.2},{31.99,66.56},{31.77,64.98},{31.71,65.75},{34.32,68.23},{32.81,65.24},{32.62,64.67},{33.63,65.33}}},nil,15,nil,nil,48,nil,nil,0},
[4357] = {'Bloodfen Lashtail',1336,1336,38,38,0,{[15]={{36.18,66.06},{33.87,64.14},{32.72,66.14},{32.04,64.32},{32.18,66.37},{31.36,65.85},{31.22,66.06},{36.76,68.94},{34.75,70.65},{36.14,69.38},{33.07,64.19},{34.01,65.01},{33.32,64.64},{38.08,68.61},{37.66,68.51}}},nil,15,nil,nil,48,nil,nil,0},
[4358] = {'Mirefin Puddlejumper',1400,1400,35,36,0,nil,nil,0,nil,nil,18,nil,nil,0},
[4359] = {'Mirefin Murloc',1277,1277,35,36,0,{[15]={{58.96,15.39},{54.05,14.51},{54.63,15.45},{54.36,16.06},{55.36,16.62},{54.69,16.53},{54.22,15.45},{54.36,15.08},{57.48,16.65},{57.4,16.12},{57.85,16.33},{57.8,15.77},{58.67,15},{57.94,15.44},{57.09,15.08},{58.19,15.73},{58.2,16.26},{57.9,14.68},{57.53,15.38},{54.37,16.16},{54.1,14.43},{54.32,15.05},{54.2,15.35},{54.64,15.62}}},nil,15,nil,nil,18,nil,nil,0},
[4360] = {'Mirefin Warrior',1500,1600,37,38,0,nil,nil,0,nil,nil,18,nil,nil,0},
[4361] = {'Mirefin Muckdweller',1277,1277,35,36,0,{[15]={{58.23,8.75},{59.88,9.95},{57.94,9.88},{62.97,9.1},{58.08,11.05},{63.6,6.33},{58.46,7.5},{58.67,10.82},{63.66,8.3},{58.61,9.25},{63.16,8.46},{59.16,8.27},{63.04,6.92},{57.23,10.62},{60.07,11.09},{57.13,11.32},{57.96,8.24},{58.69,8.91},{62.89,6.26},{62.24,8.29},{58.69,11.62},{59.24,9.39}}},nil,15,nil,nil,18,nil,nil,0},
[4362] = {'Mirefin Coastrunner',1277,1277,35,36,0,{[15]={{54.84,14.83},{54.21,13.96},{53.97,15.19},{56.08,16.63},{57.32,16.41},{57.79,17.79},{58.62,16.38},{58.46,15.33},{58.39,17.05},{56.74,16.3},{56.81,14.67},{57.03,15.72},{57.9,15.1},{58.98,15.79},{57.28,14.82},{57.89,16.51},{54.35,13.89},{55,14.88}}},nil,15,nil,nil,18,nil,nil,0},
[4363] = {'Mirefin Oracle',1009,1009,35,36,0,{[15]={{60.38,10.23},{63.31,7.36},{59.37,11.53},{58.36,8.25},{63.23,6.74},{62.62,7.36},{58.37,10.03},{62.17,7.61},{63.04,7.72},{57.7,10.58},{59.61,9.55},{59.66,7.52},{59.08,10.06},{62.85,8.31},{59.77,8.9},{58.27,9.47},{59.24,10.66},{57.92,10.3},{60.08,8.69},{63.79,7.06},{62.2,7.05}}},nil,15,nil,nil,18,nil,nil,0},
[4364] = {'Strashaz Warrior',8883,8883,59,60,1,{[15]={{77.25,19.24}}},nil,15,nil,nil,74,nil,nil,0},
[4366] = {'Strashaz Serpent Guard',9156,9156,59,61,1,{[15]={{76.33,19.46},{77.37,19.04},{75.11,14.21},{73.25,18.45},{74.63,15.15},{75.47,21.5},{77.37,20.13},{75.75,18.39},{76.55,22.22},{76.49,17.4}}},nil,15,nil,nil,74,nil,nil,0},
[4368] = {'Strashaz Myrmidon',9156,9156,60,61,1,{[15]={{77.21,18.85},{76.93,18.43},{75.03,14.86},{75.27,14.49},{76.42,18.44},{76.49,17.72},{76.62,17.62}}},nil,15,nil,nil,74,nil,nil,0},
[4370] = {'Strashaz Sorceress',7545,7545,60,61,1,{[15]={{77.12,19.57},{76.7,20.28},{75.33,21.82},{77.4,19.04},{74.2,18.69}}},nil,15,nil,nil,74,nil,nil,0},
[4371] = {'Strashaz Siren',7107,7107,59,60,1,{[15]={{75.43,14.61},{77.42,19.01},{75.15,17.97},{74.29,16.72},{76.86,17.09},{75.68,22.01}}},nil,15,nil,nil,74,nil,nil,0},
[4374] = {'Strashaz Hydra',9432,9432,59,61,1,{[15]={{69.38,18.83},{69.97,17.72},{76.54,20.08},{69.38,20.09},{70.69,18.24},{69.93,21.45},{70.37,16.93},{69.66,19.73},{70.67,20.62},{70.51,22.27},{71.09,17.22},{71.94,18.48},{73.83,18.76}}},nil,15,nil,nil,74,nil,nil,0},
[4376] = {'Darkmist Spider',1220,1220,35,36,0,{[15]={{31.71,21.7},{31.53,21.86},{32.48,23.2},{35.36,20.31},{34.48,25.7},{32.29,22.31},{32.56,22.65},{31.3,21.79},{31.08,22.48},{31.52,22.55},{30.81,20.15},{33.56,21.23},{33.98,22.68},{35.06,24.32},{35.27,23.6},{34.99,21.29},{34.83,22.76},{34.32,21.75},{31.48,21.96},{31.07,22.48},{30.82,20.21},{31.28,21.92}}},nil,15,nil,nil,22,nil,nil,0},
[4377] = {'Darkmist Hatchling',67,70,37,38,0,nil,nil,0,nil,nil,312,nil,nil,0},
[4378] = {'Darkmist Recluse',1277,1277,36,37,0,{[15]={{31.29,21.38},{30.7,22.39},{32.35,22.27},{30.88,20.56},{34.2,22.75},{34.67,22.67},{31.29,21.32},{30.59,20.48},{30.45,21.96}}},nil,15,nil,nil,22,nil,nil,0},
[4379] = {'Darkmist Silkspinner',1277,1277,35,36,0,{[15]={{33.06,21.49},{33.82,20.49},{35.76,20.5},{32.02,22.5},{30.73,22.45},{33.67,22.76},{30.23,21.27},{30.64,20.92},{34.33,20.91},{34.5,24.19},{34.78,22.65},{35.16,22.26},{34.94,22.96},{30.79,22.46},{30.16,21.21},{30.63,20.86}}},nil,15,nil,nil,22,nil,nil,0},
[4380] = {'Darkmist Widow',2004,2004,37,37,4,{[15]={{33.48,22.89}},[4709]={{53.53,59.72}}},nil,4709,nil,nil,22,nil,nil,0},
[4382] = {'Withervine Creeper',1220,1220,35,36,0,{[15]={{38.77,17},{36.86,18.46},{37.42,13.4},{38.78,23.37},{37.4,22.51},{37.61,21.52},{37.62,23.29},{38.54,15.38},{41.93,14.76},{39.66,14.49},{42.86,18.35},{42.13,18.39},{41.38,21.69},{40.6,20.45},{39,13.38},{43.72,17.51},{37.45,19.54},{36.84,16.7},{42.85,16.71},{40.35,21.05},{39.92,13.46},{41.58,14.53},{40.21,19.66},{42.91,19.38},{42.63,15.88},{38.54,22.75},{38.93,19.44}}},nil,15,nil,nil,14,nil,nil,0},
[4385] = {'Withervine Rager',1469,1469,35,36,0,{[15]={{41.05,18.33},{36.7,14.99},{38.51,23.04},{36.48,25.71},{40.53,23.54},{41.22,17.64},{41.33,19.42},{39.59,18.51},{38.2,18.53},{40.27,17.63},{39.35,22.78},{38.76,21.1}}},nil,15,nil,nil,14,nil,nil,0},
[4386] = {'Withervine Bark Ripper',1500,1500,36,37,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4387] = {'Withervine Mire Beast',1536,1604,37,38,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4388] = {'Young Murk Thresher',1532,1532,35,36,0,{[15]={{67.49,56.61},{66.73,57.64},{66.77,56.79},{67.52,56.8},{73.16,53.76},{69.37,56.83},{67.43,58.38},{69.83,55.55},{70.57,57.03},{67.91,58.79},{68.64,59.55},{70.82,56.85},{69.43,54.92},{68.79,57.59},{73.91,54.7},{69.44,58.57},{71.22,57.38},{73.44,55.66},{70.66,46.27},{73.19,52.95},{69.38,57.75},{68.07,59.56},{66.73,57.49},{66.72,56.76},{72.9,57.05},{71.8,56.65},{72.6,55.77},{69.4,56.06},{70.08,45.47},{70.47,53.87},{70.02,57.79},{70.05,56.51},{72.57,54.59},{69.93,58.41},{72.3,58.19},{73.88,52.87},{70.55,58.58},{71.82,59.68},{74.36,46.11},{73.84,45.31},{73.83,47.09},{71.73,52.47},{71.96,53.66},{71.67,55.42},{71.34,53.73},{70.52,55},{70.58,55.97},{72.13,54.75},{71.1,55.1},{71.32,56.24},{70.65,53.13},{71.24,53.07},{71.38,51.89},{73.82,50.88},{74.38,47.97},{73.79,49.02},{73.16,48.13},{71.24,49.1},{72.25,51.21},{72.66,48.82},{71.33,51.06},{71.87,50.06},{72.5,51.53},{71.24,49.91},{73.05,49.84},{72.39,50.78}}},nil,15,nil,nil,7,"AH",nil,0},
[4389] = {'Murk Thresher',1277,1277,36,37,0,{[15]={{59.22,48.54},{54.39,47.66},{56.07,48.38}}},nil,15,nil,nil,16,nil,nil,0},
[4390] = {'Elder Murk Thresher',1674,1674,37,38,0,{[15]={{51.82,38.48},{52.56,42.2}}},nil,15,nil,nil,16,nil,nil,0},
[4391] = {'Swamp Ooze',1500,1700,37,39,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4392] = {'Corrosive Swamp Ooze',1600,1700,38,40,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4393] = {'Acidic Swamp Ooze',1395,1395,37,38,0,{[15]={{55.43,53.62},{54.05,56.76},{54.65,52.58},{54.74,54.06},{50.44,53.66},{53.98,53.69},{52.4,52.75},{51.47,52.8},{49.69,54.91},{53.24,54.9},{52.75,54.14},{54.02,55.08},{51.37,59.27},{52.18,58.68},{51.04,58.25},{51.44,56.8},{52.82,57.79},{52.22,56.77},{52.68,58.8},{53.42,57.63},{53.42,58.2}}},nil,15,nil,nil,14,nil,nil,0},
[4394] = {'Bubbling Swamp Ooze',1336,1336,37,38,0,{[15]={{49.04,48.38},{48.87,53.74},{53.34,53.07},{51.53,52.25},{52.83,52.09},{47.85,53.92},{49.02,55.67},{53.39,54.33},{54.58,54.55},{52,54.62},{51.57,55.62},{51.84,57.5},{50.34,57.44},{54.25,57.56},{53.15,56.02},{48.49,54.88}}},nil,15,nil,nil,16,nil,nil,0},
[4395] = {'Blistering Swamp Ooze',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4396] = {'Mudrock Tortoise',1500,1500,36,37,0,nil,nil,0,nil,nil,15,"AH",nil,0},
[4397] = {'Mudrock Spikeshell',1220,1220,35,36,0,{[15]={{60.44,18.25},{54.3,11.19},{65.71,40.74},{64.99,36.63},{63.99,20.38},{64.29,18.81},{54.46,12.48},{62.33,15.77},{62.92,29.87},{55.1,15.56},{65.93,38.59},{60.59,19.01},{65.06,25.73},{56.08,15.8},{54.91,13.38},{63.25,16.81},{59.92,16.08},{65.32,40.27},{65.47,42.35},{54.31,12.86},{63.46,20.54},{59.72,15.63},{65.36,29.69},{65.37,41.49},{62.67,29.28},{64.74,38.7},{64.98,40.81},{64.55,39.56},{65.74,27.8},{65.52,26.63},{63.9,37.77},{63.46,38.02},{64.38,34.2},{63.68,36.69},{64.82,35.97},{63.21,33.65},{62.78,36.14},{63.33,31.86},{63.39,38.22},{63.12,23.46},{63.66,25.24},{61.97,25.07},{62.5,24.95},{61.74,28.31},{62.61,26.81},{61.6,30.7},{54.57,12.21},{57.41,8.4},{54.89,13.62},{62.94,5.58},{62.52,9.74},{61.85,5.38},{61.94,7.47},{60.27,9.02},{60.74,7.74},{61.51,7.9},{62.03,8.53},{64.38,8.46},{60.41,11.05},{55.33,15.04},{54.15,11.19},{57.78,7.4},{64.28,7.54},{56.35,9.31},{64.84,5.28},{58.73,6.92},{54.02,12.74}}},nil,15,nil,nil,15,"AH",nil,0},
[4398] = {'Mudrock Burrower',1700,1700,39,40,0,nil,nil,0,nil,nil,15,"AH",nil,0},
[4399] = {'Mudrock Borer',2000,2000,42,43,0,nil,nil,0,nil,nil,15,"AH",nil,0},
[4400] = {'Mudrock Snapjaw',1900,2000,41,42,0,nil,nil,0,nil,nil,15,"AH",nil,0},
[4401] = {'Muckshell Clacker',1220,1220,35,36,0,{[15]={{59.21,47.26},{58.57,47.78}}},nil,15,nil,nil,129,nil,nil,0},
[4402] = {'Muckshell Snapclaw',1800,1900,40,41,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4403] = {'Muckshell Pincer',1277,1277,35,36,0,{[15]={{61.28,68.95},{62.4,66.2},{63.27,67.07},{62.21,69.82},{59.11,67.29},{59.8,68.03},{59.92,66.3},{61.03,67.18},{59.89,69.25},{60.5,67.18},{60.55,68.12},{61.17,66.09},{61.35,64.64},{59.25,69.11}}},nil,15,nil,nil,129,nil,nil,0},
[4404] = {'Muckshell Scrabbler',1009,1009,35,36,0,{[15]={{50.57,41.96},{53.25,41.12}}},nil,15,nil,nil,129,nil,nil,0},
[4405] = {'Muckshell Razorclaw',2000,2100,43,44,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4407] = {'Teloren',232470,232470,85,85,1,{[406]={{40.12,31.96}}},nil,406,nil,nil,80,"A","Hippogryph Master",8193},
[4408] = {'Aquatic Form (Night Elf Druid)',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4409] = {'Gatekeeper Kordurus',955,955,30,30,0,{[406]={{35.32,25.56}}},nil,406,nil,nil,79,"A",nil,0},
[4410] = {'Aquatic Form (Tauren Druid)',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4411] = {'Darkfang Lurker',1500,1500,36,37,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4412] = {'Darkfang Creeper',1220,1220,35,36,0,{[15]={{38.47,46.62},{40.32,52.39},{35.59,59.74},{38.47,51.27},{39.41,39.63},{38.27,44.15},{35.32,45.92},{42.82,44.19},{36.86,52.47},{33.82,54.82},{41.34,34.54},{42.77,48.19},{36.6,44.41},{33.91,52.45},{43.78,54.56},{43.58,32.6},{43.1,41.45},{44.88,48.27},{41.3,48.41},{43.96,46.28},{40.1,54.71},{43.7,34.78},{42.66,42.58},{43.64,53.89},{37.05,57.68},{39.84,60.21},{35.77,55.74},{35.73,51.34},{39.78,46.17},{36.83,55.5},{39.69,57.86},{39.74,55.6},{38.01,36.59},{37.4,38.74},{44.01,38.36},{41.51,42.92},{41.47,52.57},{48.27,59.66},{49.46,63.25},{48.82,62.17},{48.22,63.39},{48.11,62.7},{47.92,57.18},{46.91,55.61}}},nil,15,nil,nil,22,nil,nil,0},
[4413] = {'Darkfang Spider',1400,1500,35,36,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4414] = {'Darkfang Venomspitter',1277,1277,36,37,0,{[15]={{60.16,23.1},{61.48,36.78},{59.31,32.01},{51,15.45},{51.61,12.05},{62.79,39.18},{34.24,28.26},{59.44,26.18},{56.02,19.2},{60.47,31.02},{52.55,12.47},{52.97,15.21},{35.81,14.89},{49.63,23.26}}},nil,15,nil,nil,22,nil,nil,0},
[4415] = {'Giant Darkfang Spider',1395,1395,37,38,0,{[15]={{52.82,61.46},{50.94,48.01},{53.58,60.6},{52.5,48.51},{55.5,52.67},{51.43,63.54},{56.02,53.94},{53.52,66.38},{53.97,67.8},{52.34,62.15},{51.83,64.95},{52.53,66.61},{52.12,53.4}}},nil,15,nil,nil,22,nil,nil,0},
[4416] = {'Defias Strip Miner',420,449,18,19,0,nil,nil,0,nil,nil,17,nil,nil,0},
[4417] = {'Defias Taskmaster',1300,1347,18,19,1,nil,nil,0,nil,nil,17,nil,nil,0},
[4418] = {'Defias Wizard',1062,1137,18,19,1,nil,nil,0,nil,nil,17,nil,nil,0},
[4419] = {'[Deprecated for 4.x]Race Master Kronkrider',1342,1342,35,35,0,nil,nil,0,nil,nil,1801,"H",nil,0},
[4420] = {'Overlord Ramtusk',30500,30500,35,35,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4421] = {'Charlga Razorflank',30270,30270,35,35,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,"The Crone",0},
[4422] = {'Agathelos the Raging',30500,30500,35,35,1,{[491]={{-1,-1}}},nil,491,nil,nil,16,nil,nil,0},
[4423] = {'Darnassian Protector',154980,154980,85,85,0,{[1657]={{41.7,31.16},{40.16,30.49},{41.48,30.38},{48.19,37.63},{43.41,36.65},{46.64,34.64}}},nil,1657,nil,nil,79,"A",nil,0},
[4424] = {'Aggem Thorncurse',25225,25225,35,35,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,"Death's Head Prophet",0},
[4425] = {'Blind Hunter',9760,9760,32,33,2,{[491]={{-1,-1}}},nil,491,nil,nil,411,nil,nil,0},
[4427] = {'Ward Guardian',3868,3868,34,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4428] = {'Death Speaker Jargba',25225,25225,35,35,1,{[491]={{-1,-1}}},nil,491,nil,nil,16,nil,"Death's Head Captain",0},
[4429] = {'Goblin Pit Crewman',1003,1003,30,30,0,nil,nil,0,nil,nil,35,"AH",nil,1},
[4430] = {'Gnome Pit Crewman',1003,1003,30,30,0,nil,nil,0,nil,nil,35,"AH",nil,1},
[4435] = {'Razorfen Warrior',4440,4440,32,33,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4436] = {'Razorfen Quilguard',4440,4440,33,33,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4437] = {'Razorfen Warden',4440,4440,33,33,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4438] = {'Razorfen Spearhide',2220,2220,33,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4439] = {'Voliboar',75,80,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[4440] = {'Razorfen Totemic',3712,3712,33,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4442] = {'Razorfen Defender',4440,4440,33,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4443] = {'Wazza',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Totem Merchent",0},
[4444] = {'Deathstalker Vincent',531,531,21,21,0,nil,nil,0,nil,{1098},714,"H",nil,0},
[4445] = {'[Deprecated for 4.x]Griznak',2016,2016,35,35,0,nil,nil,0,nil,nil,1080,"AH","Race Vendor",0},
[4446] = {'[Deprecated for 4.x]Mazzer Stripscrew',64,64,1,1,0,nil,nil,0,nil,nil,1080,"AH","Race Vendor",0},
[4449] = {'[Deprecated for 4.x]Crazzle Sprysprocket',2016,2016,35,35,0,nil,nil,0,nil,{1174},1080,"AH","Gnome Ticket Redeemer",0},
[4450] = {'[Deprecated for 4.x]Rugfizzle',2016,2016,35,35,0,nil,nil,0,nil,{1099},31,"AH","Goblin Ticket Redeemer",0},
[4451] = {'Auld Stonespire',896,896,28,28,0,nil,nil,0,nil,{1102},104,"H",nil,0},
[4452] = {'[Deprecated for 4.x]Kravel Koalbeard',950,950,29,29,0,nil,nil,0,nil,{1110,1112,1117,1119,3482},35,"AH",nil,2},
[4453] = {'[Deprecated for 4.x]Wizzle Brassbolts',1107,1107,31,31,0,nil,nil,0,nil,{1105,1107,1179,2769,2770},35,"AH",nil,129},
[4454] = {'[Deprecated for 4.x]Fizzle Brassbolts',1003,1003,30,30,0,nil,nil,0,nil,{1104,1114,1137,1165},35,"AH",nil,0},
[4455] = {'Red Jack Flint',573,573,22,22,0,{[11]={{8.4,59.39}}},nil,11,nil,nil,12,"A",nil,0},
[4456] = {'Fiora Longears',787,787,26,26,0,nil,nil,0,nil,{1132,1135},1802,"A",nil,0},
[4457] = {'Murkgill Forager',699,699,25,26,0,{[33]={{40.77,38.75}},[5339]={{43.87,23.54},{45.04,24.6},{44.64,24.84},{43.79,22.93}}},{[33]={{{36.18,23.54},{36.09,23.42},{35.88,23.24},{35.99,23.31},{36.08,23.42},{36.18,23.54},{36.42,23.63},{36.58,23.5},{36.77,23.25},{36.8,23.11},{36.85,22.96},{37.13,22.58},{36.94,22.83},{36.85,22.95},{36.79,23.18},{36.69,23.38},{36.48,23.6},{36.3,23.6}}}},5339,nil,nil,18,nil,nil,0},
[4458] = {'Murkgill Hunter',699,699,25,26,0,{[33]={{43.95,39.83}}},nil,33,nil,nil,18,nil,nil,0},
[4459] = {'Murkgill Oracle',610,610,25,26,0,{[33]={{43.1,42.78},{42.39,42.85},{42.96,41.87}}},nil,33,nil,nil,18,nil,nil,0},
[4460] = {'Murkgill Coldbringer',598,598,26,27,0,{[33]={{42.71,41.65},{42.34,42.86},{43.49,40.98}}},nil,33,nil,nil,18,nil,nil,0},
[4461] = {'Murkgill Warrior',699,699,25,26,0,{[33]={{44.78,42.27},{43.11,42.67},{43.38,41.98},{42.04,39.17},{43.8,43.37}},[5339]={{43.95,22.23}}},nil,33,nil,nil,18,nil,nil,0},
[4462] = {'Blackrock Hunter',386,386,17,18,0,{[44]={{49.22,67.89},{41.46,69.82},{43.37,66.81},{48.47,65.93},{46.85,67.78},{45.28,67.46},{55.57,66.67},{47.88,63.13},{50.21,61.52},{51.87,69.59},{50.32,66.03},{55.37,68.85},{45.94,67.03},{53.61,69.85},{50.35,65.31},{56.81,67.57},{43.4,69.94},{42.41,68.34},{48.02,68.81},{39.32,69.36}}},nil,44,nil,nil,40,nil,nil,0},
[4463] = {'Blackrock Summoner',313,313,16,16,0,{[44]={{34.67,9.67},{28.48,13.03},{26.72,17.11},{27.88,16},{40.75,13.19},{41.75,11.9},{32.66,9.91},{34.18,11.44},{38.48,13.49},{35.93,15.18},{26.61,10.55}}},nil,44,nil,nil,40,nil,nil,0},
[4464] = {'Blackrock Gladiator',1796,1796,19,19,1,nil,nil,0,nil,nil,40,nil,nil,0},
[4465] = {'Vilebranch Warrior',1110,1110,32,33,0,{[47]={{66.47,69.24},{68.47,67.92},{68.56,68.11},{68.24,69.26},{66.69,68.16},{68.28,68.24},{66.5,69.24},{68.28,68.25},{66.69,68.16},{68.49,67.91},{68.57,68.1},{68.23,69.26}}},nil,47,nil,nil,795,nil,nil,0},
[4466] = {'Vilebranch Scalper',1454,1454,34,35,0,{[47]={{50.28,63.17},{50.29,65.7},{45.31,68.19},{44.46,67.09},{46.04,64.39},{49.61,65.47},{45.1,62.9}}},nil,47,nil,nil,795,nil,nil,0},
[4467] = {'Vilebranch Soothsayer',802,802,32,33,0,{[47]={{49.23,68.32},{48.79,69.01},{49.57,62.99},{44.33,65.43},{48.94,64.33},{46.01,68.32},{45.34,66.69},{46.84,63.05},{47.24,65.34},{48.15,65.71},{47.92,66.28},{47.4,67.04}}},nil,47,nil,nil,795,nil,nil,0},
[4468] = {'Jade Sludge',1990,2062,47,48,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4469] = {'Emerald Ooze',1535,1592,34,35,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4472] = {'Haunting Vision',1135,1135,37,38,0,{[28]={{63.24,56.28},{65.09,59.66},{62.89,57.92},{61.78,59.22},{62.48,59.72},{64.82,59.36},{64.38,58.63},{62.74,60.12},{63.23,56.28},{64.4,58.62}}},nil,28,nil,nil,21,nil,nil,0},
[4473] = {'Skeletal Adept',96,96,1,1,1,nil,nil,0,nil,nil,21,nil,nil,0},
[4474] = {'Rotting Cadaver',3189,3293,53,54,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4475] = {'Blighted Zombie',3082,3189,52,53,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4476] = {'Screaming Haunt',9034,9034,57,57,0,nil,nil,0,nil,nil,67,nil,nil,0},
[4479] = {'Fardel Dabyrie',1500,1500,26,26,0,{[45]={{48.94,39.5}}},nil,45,nil,nil,123,"A",nil,0},
[4480] = {'Kenata Dabyrie',1500,1500,26,26,0,{[45]={{50.49,37.35}}},nil,45,nil,nil,123,"A",nil,0},
[4481] = {'Marcel Dabyrie',1500,1500,26,26,0,{[45]={{48.6,39.12}}},nil,45,nil,nil,123,"A",nil,0},
[4482] = {'Vilebranch Wolf',1,1,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[4483] = {'[Deprecated for 4.x]Moktar Krin',1342,1342,35,35,0,nil,nil,0,nil,{1146,1147},29,"H",nil,0},
[4484] = {'Feero Ironhand',484,484,20,20,0,nil,nil,0,nil,nil,11,"A",nil,2},
[4485] = {'Belgrom Rockmaul',1110,1110,35,35,0,{[1637]={{72.14,45.92}}},nil,1637,nil,{1145,1184,2976,3507},29,"H",nil,0},
[4486] = {'Genavie Callow',1163,1163,32,32,0,{[45]={{13.77,33.91}}},nil,45,{26428},{1164,26428},118,"H",nil,2},
[4487] = {'Kodiak',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4488] = {'Parqual Fintallas',1342,1342,35,35,0,{[1497]={{57.8,65.42}}},nil,1497,nil,{1159,1160,6628},68,"H",nil,1},
[4489] = {'Braug Dimspirit',1110,1110,35,35,0,{[406]={{76.34,50.22}}},nil,406,nil,{1152,1154,1157,6627},104,"H",nil,1},
[4490] = {'Grenka Bloodscreech',1050,1050,30,30,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4491] = {'Woof',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4493] = {'Scarlet Avenger',3644,3758,56,57,0,nil,nil,0,nil,nil,89,nil,nil,0},
[4494] = {'Scarlet Spellbinder',2631,2714,57,58,0,nil,nil,0,nil,nil,89,nil,nil,0},
[4495] = {'Gnome Pit Boss',1342,1342,35,35,0,nil,nil,0,nil,{1120,1128},35,"AH",nil,0},
[4496] = {'Goblin Pit Boss',1003,1003,30,30,0,nil,nil,0,nil,{1121,1129},35,"AH",nil,0},
[4497] = {'Captain Quirk',2471,2471,40,40,0,nil,nil,0,nil,nil,47,nil,"Boat Operator",0},
[4498] = {'Maurin Bonesplitter',1220,1220,35,35,0,{[405]={{52.25,53.44}}},nil,405,{14339,14343},{1433,1435,1480,1481,1482,8458,14338,14339},68,"H",nil,2},
[4499] = {'Rok\'Alim the Pounder',1146,1146,30,30,0,nil,{[400]={{{25.74,42.21},{25.51,42.54},{25.3,43.09},{25.17,43.46},{25.02,44},{24.92,44.43},{24.83,44.85},{24.76,45.06},{24.33,45.01},{23.83,44.44},{23.36,43.9},{22.94,43.45},{22.33,42.78},{21.87,42.01},{21.39,41.42},{20.82,41.01},{20.34,40.48},{19.92,39.77},{19.82,39.62},{19.25,39.21},{18.57,38.73},{18.06,38.37},{17.36,37.6},{17.08,37.37},{16.65,36.59},{16.49,35.79},{16.05,35.44},{15.73,34.95},{15.22,33.89},{14.98,33.41},{14.88,32.78},{14.9,32.21},{14.81,31.57},{14.45,30.54},{14.2,29.83},{14.13,29.53},{13.79,28.76},{13.35,27.76},{13.13,27.17},{12.96,26.56},{12.63,26.08},{12.19,25.62},{11.8,25.08},{11.59,24.57},{11.48,24.19},{11.28,23.78},{10.98,22.91},{10.66,22.48},{10.2,22.17},{9.48,21.5},{9.6,20.91},{9.88,21.25},{10.37,21.65},{10.64,21.77},{11.02,21.95},{11.33,21.82},{11.63,21.49},{11.87,20.97},{12.12,20.64},{12.59,20.24},{12.95,19.6},{13.14,19.98},{13.24,20.02},{13.63,19.95},{14.04,20.05},{14.3,20.79},{14.52,21.45},{14.79,22.07},{15.07,22.79},{15.52,23.47},{15.41,23.98},{15.12,24.89},{15.09,25.31},{15.42,25.93},{15.96,26.03},{16.21,26.16},{16.38,26.45},{16.6,26.65},{17.02,26.81},{17.7,26.87},{18.54,26.57},{18.92,26.6},{19.47,26.86},{19.8,27.19},{20.32,27.36},{20.63,27.56},{21.28,27.67},{21.46,27.94},{21.31,28.56},{21.42,29.43},{22.25,30.59},{22.51,31.01},{23.18,31.27},{24.01,30.97},{24.25,30.76},{24.71,30.59},{25.16,29.79},{25.68,28.86},{26.2,28.35},{26.77,28.32},{27.37,28.5},{28,28.79},{28.16,29.43},{28.27,30.12},{28.37,30.73},{28.47,31.34},{28.6,32.09},{28.9,32.6},{29.39,33.1},{29.92,34.18},{30.23,35.05},{30.26,36.21},{30.14,37.48},{30.39,38.42},{30.5,38.83},{30.9,39.45},{31.2,40.33},{31.78,41.14},{32.67,41.57},{33.46,41.95},{34.01,42.45},{34.77,42.65},{35.5,42.51},{36.19,42.9},{36.69,44.35},{36.85,45.4},{36.54,46.65},{36.57,47.87},{36.6,49},{36.48,49.82},{36.11,50.36},{35.48,50.91},{35.14,51.53},{34.47,52.33},{34.19,53.12},{33.74,53.43},{33.12,53.33},{32.56,52.96},{32.17,52.84},{31.75,52.5},{31.76,51.99},{31.97,51.25},{31.73,50.81},{31.45,51.03},{31.2,51.64},{30.86,51.7},{30.37,51.61},{30.14,51.43},{29.88,51.29},{29.73,51.22},{29.44,51.11},{29.07,50.67},{28.67,50.18},{28,49.38},{27.66,49.01},{26.97,48.25},{26.1,47.47},{25.42,46.65},{24.85,45.71},{24.02,44.68},{23.5,43.9},{22.78,43.23},{22.16,42.35},{21.44,41.6},{20.63,40.75},{20.96,39.03},{21.54,38.45},{21.91,37.75},{22.59,37.43},{23.46,37.02},{24.08,36.38},{24.79,36.75},{25.17,37.48},{25.49,38.12},{25.72,38.81},{25.87,39.65},{26.02,40.51},{25.97,41.4}}}},0,nil,nil,14,nil,nil,0},
[4500] = {'Overlord Mok\'Morokk',2918,2918,39,39,0,{[15]={{36.29,31.41}}},nil,15,{27417,27418,27424},{1166,1170,27416,27424},29,"H",nil,2},
[4501] = {'Draz\'Zilb',1753,1753,40,40,0,{[15]={{37.15,33.09}}},nil,15,{27182,27414,27415,27416},{1169,1171,1172,1173,27414,27415,27417,27418},29,"H",nil,3},
[4502] = {'Tharg',2138,2138,44,44,0,{[15]={{37.37,31.39}}},nil,15,{1168},{1168,27419},29,"H",nil,2},
[4503] = {'Mudcrush Durtfeet',1981,1981,42,42,0,{[15]={{35.15,38.26}}},nil,15,nil,{1177},35,"AH",nil,0},
[4504] = {'Frostmaw',1536,1536,37,37,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4505] = {'Bloodsail Deckhand',1110,1110,32,33,0,{[5287]={{50.76,91.22},{44.81,92.65},{46.84,95.06},{44.48,92.72},{46.6,93.48},{50.61,91.29},{46.79,95.07},{50.5,91.38},{51.15,91.22},{46.75,94.5},{46.89,94.5},{46.79,93.61}}},nil,5287,nil,nil,119,nil,nil,0},
[4506] = {'Bloodsail Swabby',1006,1006,31,32,0,{[5287]={{50.73,91.18},{44.6,93.48},{44.44,92.14},{51.49,91.25},{46.65,94.93},{44.86,93.22},{46.6,94.86},{51.53,91.54},{51.18,91.44},{44.65,92.65},{46.68,94.02},{44.78,93.26}}},nil,5287,nil,nil,119,nil,nil,0},
[4507] = {'[Deprecated for 4.x]Daisy',328,328,15,15,0,nil,nil,0,nil,nil,35,"AH","Race Starter Girl",0},
[4508] = {'Willix the Importer',3660,3660,35,35,1,{[491]={{-1,-1}}},nil,491,{26903},{1144,26903},69,"AH",nil,2},
[4509] = {'Sargath',484,484,20,20,0,nil,nil,0,nil,nil,1802,"A",nil,0},
[4510] = {'Heralath Fallowbrook',1132,1132,33,33,0,{[491]={{-1,-1}}},nil,491,nil,nil,80,"A",nil,0},
[4511] = {'Agam\'ar',4440,4440,32,33,1,{[491]={{-1,-1}}},nil,491,nil,nil,16,nil,nil,0},
[4512] = {'Rotting Agam\'ar',4652,4652,34,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,16,nil,nil,0},
[4514] = {'Raging Agam\'ar',4440,4440,33,33,1,{[491]={{-1,-1}}},nil,491,nil,nil,16,nil,nil,0},
[4515] = {'Death\'s Head Acolyte',3868,3868,33,33,1,{[491]={{-1,-1}}},nil,491,nil,nil,154,nil,nil,0},
[4516] = {'Death\'s Head Adept',3340,3340,33,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,154,nil,nil,0},
[4517] = {'Death\'s Head Priest',4792,4792,33,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,154,nil,nil,0},
[4518] = {'Death\'s Head Sage',3712,3712,33,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,154,nil,nil,0},
[4519] = {'Death\'s Head Seer',3712,3712,33,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,154,nil,nil,0},
[4520] = {'Razorfen Geomancer',3712,3712,33,33,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4521] = {'Treshala Fallowbrook',484,484,20,20,0,{[1657]={{63.98,68.58}}},nil,1657,nil,{1142},80,"A",nil,0},
[4522] = {'Razorfen Dustweaver',3712,3712,33,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4523] = {'Razorfen Groundshaker',3712,3712,33,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4525] = {'Razorfen Earthbreaker',3868,3868,34,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4526] = {'Wind Howler',764,764,30,31,1,nil,nil,0,nil,nil,152,nil,nil,0},
[4528] = {'Stone Rumbler',955,955,29,31,1,nil,nil,0,nil,nil,152,nil,nil,0},
[4530] = {'Razorfen Handler',4440,4440,33,33,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4531] = {'Razorfen Beast Trainer',4652,4652,33,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4532] = {'Razorfen Beastmaster',4652,4652,34,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4534] = {'Tamed Hyena',805,805,31,31,1,nil,nil,0,nil,nil,152,nil,nil,0},
[4535] = {'Tamed Battleboar',1006,1006,30,31,1,nil,nil,0,nil,nil,152,nil,nil,0},
[4538] = {'Kraul Bat',4652,4652,34,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,16,nil,nil,0},
[4539] = {'Greater Kraul Bat',5815,5815,34,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,16,nil,nil,0},
[4540] = {'Scarlet Monk',4440,4440,33,33,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4541] = {'Blood of Agamaggan',4652,4652,34,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,16,nil,nil,0},
[4542] = {'High Inquisitor Fairbanks',30650,30650,40,40,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4543] = {'Bloodmage Thalnos',21250,21250,31,31,1,{[796]={{-1,-1}}},nil,796,nil,nil,21,nil,nil,0},
[4544] = {'Krueg Skullsplitter',1536,1536,37,37,0,{[357]={{74.85,43.33}}},nil,357,{25361,25362},{2973,2974,25361,25362},29,"H",nil,2},
[4545] = {'[Deprecated for 4.x]Nag\'zehn',1342,1342,35,35,0,nil,nil,0,nil,nil,1801,"H",nil,0},
[4546] = {'[Deprecated for 4.x]Bor\'zehn',1342,1342,35,35,0,nil,nil,0,nil,nil,1801,"H",nil,0},
[4547] = {'Tarkreu Shadowstalker',1342,1342,35,35,0,nil,nil,0,nil,nil,1801,"H",nil,0},
[4548] = {'Steelsnap',1003,1003,30,30,0,nil,{[400]={{{17.68,19.63},{17.53,19.38},{17.39,19.15},{17.22,18.95},{17.04,18.76},{16.8,18.64},{16.48,18.59},{16.17,18.5},{15.85,18.51},{15.65,18.57},{15.48,18.89},{15.33,19.09},{15.15,19.24},{14.95,19.41},{14.79,19.65},{14.64,19.75},{14.45,19.8},{14.26,19.72},{14.1,19.73},{14.04,19.82},{13.93,19.92},{13.72,19.91},{13.43,19.79},{13.29,19.69},{13.08,19.43},{12.88,19.32},{12.59,19.4},{12.55,19.65},{12.57,20.05},{12.52,20.34},{12.38,20.54},{12.17,20.67},{12,20.86},{11.87,21.07},{11.73,21.31},{11.59,21.56},{11.46,21.76},{11.29,22.02},{11.14,22.35},{11.1,22.72},{11.17,23.19},{11.26,23.57},{11.39,23.87},{11.48,24.08},{11.51,24.41},{11.64,24.63},{11.9,25},{12.17,25.34},{12.36,25.57},{12.36,25.57},{12.86,26.16},{12.93,26.23},{13.12,26.54},{13.29,26.94},{13.44,27.34},{13.58,27.77},{13.7,28.21},{13.97,29.08},{14.11,29.5},{14.19,29.75},{14.36,30.16},{14.53,30.55},{14.82,31.27},{15.02,31.62},{15.21,31.68},{15.32,31.71},{15.37,31.74},{15.43,31.73},{15.58,31.62},{15.58,31.62},{16.08,31.02},{16.33,30.72},{16.57,30.41},{16.87,29.94},{17.12,29.64},{17.42,29.07},{17.45,28.69},{17.48,28.21},{17.52,27.77},{17.76,27.22},{17.93,26.82},{18.11,26.44},{18.4,25.81},{18.55,25.38},{18.72,24.72},{18.74,24.53},{18.68,23.95},{18.52,23.54},{18.39,23.1},{18.16,22.37},{18.09,21.86},{18.09,21.46},{18.02,20.5},{17.92,20.11}}}},0,nil,nil,38,nil,nil,0},
[4549] = {'William Montague',5544,5544,45,45,0,{[1497]={{65.97,44.75}}},nil,1497,nil,nil,68,"H","Banker",131072},
[4550] = {'Ophelia Montague',5544,5544,45,45,0,{[1497]={{65.56,44.07}}},nil,1497,nil,nil,68,"H","Banker",131072},
[4551] = {'Michael Garrett',232470,232470,85,85,1,{[1497]={{63.25,48.56}}},nil,1497,{6324},{6322},68,"H","Bat Handler",8195},
[4552] = {'Eunice Burch',1342,1342,35,35,0,{[1497]={{62.14,44.91}}},nil,1497,{29315,29332,29333,29334,29360},{29315,29332,29333,29360},68,"H","Cooking Trainer",83},
[4553] = {'Ronald Burch',1003,1003,30,30,0,{[1497]={{62.31,43.09}}},nil,1497,nil,nil,68,"H","Cooking Supplies",128},
[4554] = {'Tawny Grisette',1003,1003,30,30,0,{[1497]={{62.39,42.02}}},{[1497]={{{63.47,39.37},{64.56,38.44},{66.73,38.21},{68.05,39.14},{69.75,41.97},{69.76,46.47},{67.59,49.71},{64.59,49.8},{62.46,46.75},{62.16,44.53},{62.36,41.73}}}},1497,nil,nil,68,"H","Mushroom Vendor",640},
[4555] = {'Eleanor Rusk',1003,1003,30,30,0,{[1497]={{69.17,48.93}}},nil,1497,nil,nil,68,"H","General Goods",640},
[4556] = {'Gordon Wendham',1003,1003,30,30,0,{[1497]={{61.49,41.79}}},nil,1497,{6322},{6323},68,"H","Weapons Merchant",4227},
[4557] = {'Louis Warren',1003,1003,30,30,0,{[1497]={{61.15,40.88}}},nil,1497,nil,nil,68,"H","Weapons Merchant",4224},
[4558] = {'Lauren Newcomb',1003,1003,30,30,0,{[1497]={{63.83,37.97}}},nil,1497,nil,nil,68,"H","Light Armor Merchant",4224},
[4559] = {'Timothy Weldon',1003,1003,30,30,0,{[1497]={{62.62,39.71}}},nil,1497,nil,nil,68,"H","Heavy Armor Merchant",4224},
[4560] = {'Walter Ellingson',1003,1003,30,30,0,{[1497]={{62.34,38.67}}},nil,1497,nil,nil,68,"H","Heavy Armor Merchant",4224},
[4561] = {'Daniel Bartlett',1003,1003,30,30,0,{[1497]={{64.05,37.37}}},nil,1497,nil,nil,68,"H","Trade Supplies",128},
[4562] = {'Thomas Mordan',1003,1003,30,30,0,{[1497]={{69.69,39.05}}},nil,1497,nil,nil,68,"H","Reagents",2176},
[4563] = {'Kaal Soulreaper',4120,4120,60,60,0,{[1497]={{86.21,15.93}}},nil,1497,{27282,28299},{32307,32309},68,"H","Warlock Trainer",51},
[4564] = {'Luther Pickman',2769,2769,50,50,0,{[1497]={{86.43,15.25}}},nil,1497,nil,nil,68,"H","Warlock Trainer",49},
[4565] = {'Richard Kerwin',1753,1753,40,40,0,{[1497]={{88.91,15.86}}},nil,1497,nil,nil,68,"H","Warlock Trainer",49},
[4566] = {'Kaelystia Hatebringer',4120,4120,60,60,0,{[1497]={{85.02,14.02}}},nil,1497,{27277,28300},nil,68,"H","Mage Trainer",51},
[4567] = {'Pierce Shackleton',2769,2769,50,50,0,{[1497]={{85.45,13.51}}},nil,1497,nil,nil,68,"H","Mage Trainer",49},
[4568] = {'Anastasia Hartwell',1753,1753,40,40,0,{[1497]={{85.14,10.03}}},nil,1497,nil,{1881,1882,1959,1960},68,"H","Mage Trainer",51},
[4569] = {'Charles Seaton',1003,1003,30,30,0,{[1497]={{77.08,49.4}}},nil,1497,nil,nil,68,"H","Blade Merchant",4224},
[4570] = {'Sydney Upton',1003,1003,30,30,0,{[1497]={{69.46,27.44}}},nil,1497,nil,nil,68,"H","Staff Merchant",4224},
[4571] = {'Morley Bates',1003,1003,30,30,0,{[1497]={{78.08,23.4}}},{[1497]={{{76.46,29.02},{76.58,28.62},{76.99,27.98},{77.36,27.39},{77.68,26.87},{78.05,26.34},{78.44,25.79},{78.89,25.11},{79.34,25.31},{80,26.21},{80.74,27.07},{80.92,27.41},{81.67,28.39},{82.58,28.82},{83.24,28.59},{83.83,27.19},{83.97,25.17},{83.35,23.59},{80.84,20.53},{79.32,18.12},{78.25,17.69},{77.42,18.09},{76.85,18.92},{76.67,20.27},{76.8,21.13},{77.33,22.01},{77.53,22.32},{78.12,23.49},{78.71,24.4},{78.81,25.13},{78.42,25.72},{78.11,26.29},{77.69,26.87},{77.36,27.36},{76.98,27.92},{76.56,28.56},{76.25,28.64},{76.06,28.44},{75.37,27.51},{74.52,27.63},{73.13,27.05},{72.75,27.65},{72.64,28.72},{73.88,31.09},{75.62,33.84},{76.25,34.61},{77.46,34.34},{77.65,34.04},{77.79,32.39},{77.78,32.02},{77.3,30.31},{76.67,29.35}}}},1497,nil,nil,68,"H","Fungus Vendor",640},
[4572] = {'Silas Zimmer',1003,1003,30,30,0,{[1497]={{84.96,19.21}}},nil,1497,nil,nil,68,"H",nil,0},
[4573] = {'Armand Cromwell',1342,1342,35,35,0,{[1497]={{80.7,31.26}}},nil,1497,{29317,29319,29320,29322,29361},{29319,29320,29322,29361},68,"H","Fishing Trainer",83},
[4574] = {'Lizbeth Cromwell',1003,1003,30,30,0,{[1497]={{81.04,30.75}}},nil,1497,nil,nil,68,"H","Fishing Supplies",128},
[4575] = {'Hannah Akeley',1003,1003,30,30,0,{[1497]={{82.78,15.83}}},nil,1497,nil,nil,68,"H","Reagents",2176},
[4576] = {'Josef Gregorian',2218,2218,45,45,0,{[1497]={{70.76,30.69}}},nil,1497,nil,{1961,1962},68,"H","Tailoring Trainer",83},
[4577] = {'Millie Gregorian',1003,1003,30,30,0,{[1497]={{70.59,30.14}}},nil,1497,nil,nil,68,"H","Tailoring Supplies",128},
[4578] = {'Josephine Lister',2218,2218,45,45,0,{[1497]={{86.65,22.08}}},nil,1497,nil,nil,68,"H","Tailoring Trainer",80},
[4579] = {'zzOLDAlexander Lister',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4580] = {'Lucille Castleton',1003,1003,30,30,0,{[1497]={{71.18,29.59}}},nil,1497,nil,nil,68,"H","Robe Vendor",4224},
[4581] = {'Salazar Bloch',1003,1003,30,30,0,{[1497]={{77.42,39.26}}},nil,1497,nil,nil,68,"H","Book Dealer",128},
[4582] = {'Carolyn Ward',1753,1753,40,40,0,{[1497]={{83.86,72.07}}},nil,1497,nil,nil,68,"H","Rogue Trainer",49},
[4583] = {'Miles Dexter',2769,2769,50,50,0,{[1497]={{85.21,71.57}}},nil,1497,nil,nil,68,"H","Rogue Trainer",49},
[4584] = {'Gregory Charles',4120,4120,60,60,0,{[1497]={{84.88,73.53}}},nil,1497,{27279,28298},nil,68,"H","Rogue Trainer",51},
[4585] = {'Ezekiel Graves',1003,1003,30,30,0,{[1497]={{75.2,51.18}}},nil,1497,nil,nil,68,"H","Poison Supplies",1152},
[4586] = {'Graham Van Talen',787,787,26,26,0,{[1497]={{75.34,73.13}}},nil,1497,nil,nil,68,"H","Apprentice Engineer",3},
[4587] = {'Elizabeth Van Talen',1003,1003,30,30,0,{[1497]={{75.48,74.34}}},nil,1497,nil,nil,68,"H","Engineering Supplies",128},
[4588] = {'Arthur Moore',1342,1342,35,35,0,{[1497]={{70.18,57.42}}},nil,1497,nil,nil,68,"H","Leatherworking Trainer",81},
[4589] = {'Joseph Moore',1003,1003,30,30,0,{[1497]={{70.07,58.45}}},nil,1497,nil,nil,68,"H","Leatherworking Supplies",128},
[4590] = {'Jonathan Chambers',1003,1003,30,30,0,{[1497]={{69.24,61.21}}},nil,1497,nil,nil,68,"H","Bag Vendor",128},
[4591] = {'Mary Edras',1342,1342,35,35,0,{[1497]={{73.16,55.15}}},nil,1497,nil,nil,68,"H","First Aid Trainer",81},
[4592] = {'Nathaniel Steenwick',1003,1003,30,30,0,{[1497]={{77.49,49.63}}},nil,1497,nil,nil,68,"H","Thrown Weapons Merchant",4224},
[4593] = {'Christoph Walker',4120,4120,60,60,0,{[1497]={{46.93,15.23}}},nil,1497,{27281,28290},nil,68,"H","Warrior Trainer",51},
[4594] = {'Angela Curthas',2769,2769,50,50,0,{[1497]={{48.32,15.96}}},nil,1497,nil,nil,68,"H","Warrior Trainer",49},
[4595] = {'Baltus Fowler',1753,1753,40,40,0,{[1497]={{47.4,17.29}}},nil,1497,nil,nil,68,"H","Warrior Trainer",49},
[4596] = {'James Van Brunt',1342,1342,35,35,0,{[1497]={{61.26,30.63}}},nil,1497,nil,nil,68,"H","Blacksmithing Trainer",81},
[4597] = {'Samuel Van Brunt',1003,1003,30,30,0,{[1497]={{61.41,30.08}}},nil,1497,nil,nil,68,"H","Blacksmithing Supplies",4224},
[4598] = {'Brom Killian',1342,1342,35,35,0,{[1497]={{56.03,37.45}}},nil,1497,nil,nil,68,"H","Mining Trainer",81},
[4599] = {'Sarah Killian',1003,1003,30,30,0,{[1497]={{56.72,36.94}}},nil,1497,nil,nil,68,"H","Mining Supplies",128},
[4600] = {'Geoffrey Hartwell',1003,1003,30,30,0,{[1497]={{58.67,33.06}}},nil,1497,nil,nil,68,"H","Weapon Merchant",4224},
[4601] = {'Francis Eliot',1003,1003,30,30,0,{[1497]={{59,32.58}}},nil,1497,nil,nil,68,"H","Weapon Merchant",4224},
[4602] = {'Benijah Fenner',1003,1003,30,30,0,{[1497]={{58.82,32.82}}},nil,1497,nil,nil,68,"H","Weapon Merchant",4480},
[4603] = {'Nicholas Atwood',1003,1003,30,30,0,{[1497]={{62.72,26.76}}},nil,1497,nil,nil,68,"H","Gun Merchant",4224},
[4604] = {'Abigail Sawyer',1003,1003,30,30,0,{[1497]={{54.7,38.76}}},nil,1497,nil,nil,68,"H","Bow Merchant",4224},
[4605] = {'Basil Frye',787,787,26,26,0,{[1497]={{60.17,29.09}}},nil,1497,nil,nil,68,"H","Apprentice Blacksmith",1},
[4606] = {'Aelthalyste',4120,4120,60,60,0,{[1497]={{49.26,17.12}}},nil,1497,{27331,27332,27334,27335,28164,28304,28307,28309,28323},{5644,5646,5658,5659,5660,5661,5662,5663,5679,5692,5693,5705,5706,5708,5709},68,"H","Priest Trainer",51},
[4607] = {'Father Lankester',1753,1753,40,40,0,{[1497]={{49.14,14.61}}},nil,1497,nil,nil,68,"H","Priest Trainer",49},
[4608] = {'Father Lazarus',2769,2769,50,50,0,{[1497]={{47.57,18.9}}},nil,1497,nil,nil,68,"H","Priest Trainer",49},
[4609] = {'Doctor Marsh',1342,1342,35,35,0,{[1497]={{50.93,74.56}}},nil,1497,nil,nil,68,"H","Apprentice Alchemist",1},
[4610] = {'Algernon',1003,1003,30,30,0,{[1497]={{51.71,74.67}}},nil,1497,nil,nil,68,"H","Alchemy Supplies",128},
[4611] = {'Doctor Herbert Halsey',2769,2769,50,50,0,{[1497]={{47.77,73.34}}},nil,1497,nil,{29067,29481,29482},68,"H","Alchemy Trainer",81},
[4612] = {'Boyle',1003,1003,30,30,0,{[1497]={{55.5,64.1}}},nil,1497,nil,nil,68,"H",nil,0},
[4613] = {'Christopher Drakul',2769,2769,50,50,0,{[1497]={{69.7,44.79}}},nil,1497,nil,nil,68,"H","Guild Master",786433},
[4614] = {'Martha Alliestar',1342,1342,35,35,0,{[1497]={{54,49.55}}},nil,1497,nil,nil,68,"H","Herbalism Trainer",81},
[4615] = {'Katrina Alliestar',1003,1003,30,30,0,{[1497]={{54.73,48.92}}},nil,1497,nil,nil,68,"H","Herbalism Supplies",128},
[4616] = {'Lavinia Crowe',1342,1342,35,35,0,{[1497]={{61.87,61.39}}},nil,1497,nil,nil,68,"H","Enchanting Trainer",81},
[4617] = {'Thaddeus Webb',1003,1003,30,30,0,{[1497]={{62.38,60.98}}},nil,1497,nil,nil,68,"H","Enchanting Supplies",128},
[4618] = {'Martek the Exiled',2388,2388,47,47,0,{[3]={{26.19,62.45}}},nil,3,{27715},{1106,1108,27715},35,"AH",nil,3},
[4619] = {'Geltharis',747,747,22,22,0,{[331]={{78.41,42.53}}},nil,331,nil,nil,90,nil,nil,0},
[4620] = {'[Deprecated for 4.x]Fobeed',1342,1342,35,35,0,nil,nil,0,nil,nil,35,"AH","Race Announcer",0},
[4621] = {'Rebald Yorglun',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Raptor Trainer",0},
[4623] = {'Quilguard Champion',4652,4652,34,34,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4624] = {'Booty Bay Bruiser',464940,464940,85,85,0,{[5287]={{42.55,73.43},{41.71,74.22},{41.76,74.94},{42.53,72.92},{41.86,72.61},{40.69,73.89},{39.65,71.93},{41.91,73.2},{43.31,71.04},{41.08,73.3},{42.64,73.69},{41.56,74.29},{39.7,71.99},{41.91,73.52},{41.24,73.17},{43.05,73.42},{43.84,69.78},{42,73.86},{39.3,67.52},{42.48,70.28},{42.21,67.9},{43.65,70.69},{41.4,74.05},{42.45,67.97},{42.19,73.49},{42.48,70.58},{42.92,71.23},{41.7,73},{42.43,72.25},{40.28,73.31},{42.08,74.11},{42.02,69.44},{41.63,74.67},{42.86,68.5},{40.7,73.98},{42.35,74.67},{43.47,73.26},{40.16,72.59},{42.09,69.22},{39.41,66.95},{41.17,74.31},{39.73,67.26},{42.38,73.44},{40.28,72.18},{41.31,73.92},{40.89,73.75},{41.05,73.78},{42.61,70.29},{41.91,73.54},{42.43,73.61},{43.03,71.78},{42.68,72.54},{42.37,73.06}}},nil,5287,nil,nil,121,"AH",nil,0},
[4625] = {'Death\'s Head Ward Keeper',605,605,23,23,0,{[491]={{-1,-1}}},nil,491,nil,nil,153,nil,nil,0},
[4626] = {'CHOW Guard',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4627] = {'Arugal\'s Voidwalker',484,484,20,20,0,nil,nil,0,nil,nil,90,nil,nil,0},
[4629] = {'[Deprecated for 4.x]Trackmaster Zherin',1003,1003,30,30,0,nil,nil,0,nil,{1175},35,"AH",nil,0},
[4630] = {'[Deprecated for 4.x]Pozzik',1003,1003,30,30,0,nil,nil,0,nil,{1176,1183,1192,1194},35,"AH",nil,2},
[4631] = {'Wharfmaster Lozgil',1220,1220,35,35,0,{[5287]={{39.76,67.71}}},nil,5287,nil,{1180},120,"AH",nil,1},
[4632] = {'Kolkar Centaur',1050,1107,30,31,0,nil,nil,0,nil,nil,130,nil,nil,0},
[4633] = {'Kolkar Scout',1050,1107,30,31,0,nil,nil,0,nil,nil,130,nil,nil,0},
[4634] = {'Kolkar Mauler',1107,1163,31,32,0,nil,nil,0,nil,nil,130,nil,nil,0},
[4635] = {'Kolkar Windchaser',935,977,31,32,0,nil,nil,0,nil,nil,130,nil,nil,0},
[4636] = {'Kolkar Battle Lord',1163,1221,32,33,0,nil,nil,0,nil,nil,130,nil,nil,0},
[4637] = {'Kolkar Destroyer',977,1021,32,33,0,nil,nil,0,nil,nil,130,nil,nil,0},
[4638] = {'Magram Scout',1057,1057,32,33,0,{[405]={{68.51,40.75},{68.16,44.51},{69.55,56.34},{68.79,47.09},{68.33,50.4},{69.25,45.57},{75.09,67.97},{66.34,75.61},{68.84,44.3},{70.84,47.53},{72.09,49.03},{73.59,47.96},{68.33,41.76},{68.73,48.83}}},nil,405,nil,nil,2184,nil,nil,0},
[4639] = {'Magram Outrunner',1163,1221,32,33,0,{[405]={{72.22,69.13},{64.92,77.88}}},nil,405,nil,nil,2184,nil,nil,0},
[4640] = {'Magram Wrangler',1110,1110,33,34,0,{[405]={{74.31,44.75},{65.67,74.58},{69.38,70.17},{70.73,73.46},{70.04,81.06},{73.78,65.73},{76.03,71.25},{65.72,70.26},{66.24,78.95},{68.62,81.19},{69.33,48.99},{73.03,72.3},{65.09,75.7},{76,75.68},{70.09,68.98},{71.61,66.91},{70.79,80.23},{72.13,55.66},{71.03,55.27}}},nil,405,nil,nil,2184,nil,nil,0},
[4641] = {'Magram Windchaser',835,835,33,33,0,{[405]={{74.41,51.07},{69.3,82.16},{70.78,68.05},{67.86,82.29},{73.19,55.71},{70.47,43.54},{73.95,54.77},{73.07,43.07},{72.98,66.75},{69.99,77.8},{70.92,50.6},{72.91,73.54},{65.82,72.33},{73.71,67.72},{72.88,48.04},{70.18,41.94},{67.12,83.43},{72.5,78.74},{67.81,80.07},{74.5,69.02},{74.37,46.46},{73.99,47.94},{70.84,44.3},{70.29,44.77}}},nil,405,nil,nil,2184,nil,nil,0},
[4642] = {'Magram Stormer',850,850,31,32,0,{[405]={{73.11,54.61},{73.31,43.79},{75.35,69.96},{68.55,83.28},{71.43,48.88},{73.56,43.01},{72.95,77.87},{70.83,48.9},{73.27,40.71},{74.64,48.9},{65.64,78.98},{70.01,76.8},{72.94,50.12},{76.02,73.44},{71.52,79.06},{72.01,40.95},{70.93,41.09},{72.25,46.49},{73.13,45.72},{73.3,52.17},{70.81,75.81},{73.01,51.37},{72.22,44.52},{68.6,76.72},{72.77,42.37},{71.1,42.92},{72.02,42.14},{67.15,81.21},{66.08,79.65},{71.68,50.57},{73.9,50.5}}},nil,405,nil,nil,2184,nil,nil,0},
[4643] = {'Magram Pack Runner',1279,1342,34,35,0,{[405]={{68.51,84.74},{67.22,76.1},{73.95,77.69}}},{[405]={{{72.36,78.18},{72.88,78.17},{73.11,78.18},{73.32,78.41},{73.51,78.33},{73.56,78.32},{73.84,78.4},{74,78.56},{74.12,78.48},{74.29,78.32},{74.52,78.23},{74.64,78.06},{74.67,77.83},{74.68,77.59},{74.76,77.24},{74.9,76.91},{75,76.76},{75.04,76.42},{75.09,76.19},{75.21,75.92},{75.36,75.79},{75.53,75.79},{75.72,75.82},{75.89,75.86},{76.01,75.58},{76.15,74.99},{76.18,74.29},{76.1,73.3},{76.03,72.84},{75.9,71.93},{75.75,71.27},{75.52,70.4},{75.31,69.77},{74.98,69.29},{74.6,69.2},{74.05,69.17},{73.93,68.69},{74.16,69.07},{74.53,69.16},{74.89,69.29},{75.33,69.85},{75.44,70.35},{75.61,71.01},{75.75,71.67},{75.89,72.34},{76.06,73.24},{76.13,73.87},{76.16,74.56},{76.09,75.18},{75.88,75.86},{75.53,75.77},{75.37,75.8},{75.15,76},{75,76.32},{74.94,76.75},{74.79,77.48},{74.66,77.79},{74.65,77.97},{74.59,78.24},{74.38,78.34},{74.18,78.38},{74.05,78.48},{73.96,78.57},{73.82,78.47},{73.53,78.27},{73.31,78.36},{73.13,78.2},{72.8,78}}}},405,nil,nil,2184,nil,nil,0},
[4644] = {'Magram Marauder',1403,1469,35,36,0,{[405]={{66.4,80.06},{69.34,77.75},{65.96,80.55},{73.62,72.66},{73.39,73.4},{69.69,78.36},{71.31,71.42},{70.99,75.12}}},nil,405,nil,nil,2184,nil,nil,0},
[4645] = {'Magram Mauler',1057,1057,32,33,0,{[405]={{69.33,48.34},{70.89,40.71},{73.37,54.2},{73.15,74.56},{68.86,50.85},{69.48,42.2},{69.93,49.85},{69.96,38.84},{73.23,42.62},{68.95,43.31},{69.14,39.17},{66.59,80.61},{72.19,78.41},{70.49,40.3},{72.23,39.48},{70.04,47.78},{69,41.36},{70.55,75.15},{70.36,43.29},{71.59,50.08},{72.87,46.63},{74.4,46.71},{74.2,49.93},{70.11,46.74}}},nil,405,nil,nil,2184,nil,nil,0},
[4646] = {'Gelkis Outrunner',1057,1057,32,33,0,{[405]={{39.11,79.09},{39.9,90.92},{41.86,84.43},{34.56,81.42},{34.57,85.86},{35.03,82.39},{40.45,84.84},{35.98,81.05},{34.49,82.28},{38.23,82.27},{40.39,81.42},{38.02,80.97},{41.12,82.43},{37.4,81.46},{39.04,80.94},{37.36,82.03},{38.73,80.01},{35.92,85.75},{35.7,83.19},{35.44,84.5},{35.3,88.03},{35.96,82.21},{35.25,85.57}}},nil,405,nil,nil,2183,nil,nil,0},
[4647] = {'Gelkis Scout',1163,1221,32,33,0,nil,nil,0,nil,nil,132,nil,nil,0},
[4648] = {'Gelkis Stamper',1163,1163,33,34,0,{[405]={{34.59,84.76},{42.64,85.04},{36.71,82.67},{35.08,80.38},{41.57,83.44},{37.97,96.93},{37.29,89.35},{34.38,83.53},{38.37,95.55},{41.36,85.82},{39.05,85},{36.98,85.79},{37.29,84.18},{35.34,83.45},{34.57,88.81},{38.88,89.36},{40.32,87.78},{34.6,90.44},{40.32,85.83},{35.37,90.32},{38.23,94.07},{35.05,91.66},{39.04,81.87},{39.78,83.14},{35.24,88.93},{36.4,81.41},{38.9,92.01}}},nil,405,nil,nil,2183,nil,nil,0},
[4649] = {'Gelkis Windchaser',1021,1064,33,34,0,nil,nil,0,nil,nil,132,nil,nil,0},
[4651] = {'Gelkis Earthcaller',867,867,33,34,0,{[405]={{38.6,96.58},{36.22,91.47},{38,96.2},{40.71,86.69},{40.44,92.99},{38.53,97.33},{36.22,86.84},{40.18,91.82},{34.53,87.02},{39.19,88.38},{38.7,95.83},{36.26,90.01},{40.53,92.33},{38.5,81.8},{35.81,90.34},{38.37,89.63},{37.8,87.95},{38.37,90.61},{39.28,94.18},{38.79,93.57}}},nil,405,nil,nil,2183,nil,nil,0},
[4652] = {'Gelkis Mauler',1403,1469,35,36,0,nil,nil,0,nil,nil,132,nil,nil,0},
[4653] = {'Gelkis Marauder',1163,1163,33,34,0,{[405]={{34.82,91.06},{40.24,94.1},{39.93,94.01},{36.31,90.72},{40.29,91.66},{38.91,95.53},{38.87,95.3},{38.94,93.82}}},nil,405,nil,nil,2183,nil,nil,0},
[4654] = {'Maraudine Scout',1110,1110,33,33,0,{[405]={{30.1,55.47},{35.27,61.41},{32.37,62.64},{31.24,66.21},{37.2,60.98},{34.28,54.43},{34.52,55.63},{39.63,61.12},{36.76,60.74}}},nil,405,nil,nil,134,nil,nil,0},
[4655] = {'Maraudine Wrangler',1110,1110,33,33,0,{[405]={{32.86,52.55},{30.09,66.06},{31.71,53.52},{35.17,53.58},{33.01,49.83},{32.75,65.73},{29.58,67.5},{32.02,60.87},{34.72,58.2},{30.28,68.37},{30.11,61.29},{34.04,56.56},{35.88,61.31},{36.01,59.05}}},nil,405,nil,nil,134,nil,nil,0},
[4656] = {'Maraudine Mauler',1054,1054,33,34,0,{[405]={{33.83,51.53},{31.6,66.25},{35.11,61.12},{28.79,54.39},{29.37,54.44},{33.07,64.74},{28.64,67.95},{34.73,60.23},{33.23,51.02},{31.51,51.15},{30.78,53.38},{33.02,54.87},{34.21,53.18},{30.53,54.71},{33.34,54.94},{30.97,65.16},{32.23,60.28},{30.49,57.09},{29.82,57.78},{29.94,62.71},{29.97,62.23},{31.46,58.91},{33.82,53.28},{32.46,60.98},{30.72,59.37},{30.24,57.79},{39.53,61.85},{29.49,60.64}}},nil,405,nil,nil,134,nil,nil,0},
[4657] = {'Maraudine Windchaser',928,928,33,33,0,{[405]={{31.2,54.91},{30.56,52.03},{29.4,52.36},{32.13,55.52},{32.56,55.01},{30,54.66},{34,50.19},{32.05,59.8},{29.69,58.1},{29.96,58.35},{32.58,59.78},{28.82,53.58},{31.28,60.99}}},nil,405,nil,nil,134,nil,nil,0},
[4658] = {'Maraudine Stormer',835,835,33,34,0,{[405]={{29.33,55.49},{28.88,58.06},{28.77,60.83},{29.06,50.69}}},nil,405,nil,nil,134,nil,nil,0},
[4659] = {'Maraudine Marauder',1110,1110,33,34,0,{[405]={{30.53,50.63},{29.3,50.59}}},nil,405,nil,nil,134,nil,nil,0},
[4660] = {'Maraudine Bonepaw',1536,1604,37,38,0,nil,nil,0,nil,nil,134,nil,nil,0},
[4661] = {'Gelkis Rumbler',213,213,28,29,0,nil,nil,0,nil,nil,2183,nil,nil,0},
[4662] = {'Magram Bonepaw',1536,1604,37,38,0,{[405]={{68.46,84.83},{68.44,84.76},{67.13,76.34},{67.09,76.2},{73.86,77.68},{73.86,77.57}}},nil,405,nil,nil,133,nil,nil,0},
[4663] = {'Burning Blade Augur',770,770,30,31,0,{[405]={{55.18,30.06},{56.05,25.95},{52.3,29.74},{52.02,28.83},{57.43,26.32},{54.59,24.72},{52.93,32.37},{57.3,22.42},{57.27,25.29},{53.09,32.27},{56.73,23.68},{56.67,22.05},{56.81,24.64},{54.06,27.79},{53.16,27.5},{56.75,22.7},{56.09,22.23},{54.21,27.99},{57.09,23.21},{55.39,32},{55.14,28.62},{53.03,28.43},{55.97,27.42},{55.48,26.12}}},nil,405,nil,nil,554,nil,nil,0},
[4664] = {'Burning Blade Reaver',955,955,30,31,0,{[405]={{54.03,30.39},{55.88,25.17},{56.18,22.62},{53.29,29.94},{57.7,26.3},{52.44,32.54},{52.66,32.01},{54.46,33.14},{57.61,26.32},{52.64,32},{56.63,25.81},{52.9,26.77},{52.6,27.13},{56.4,21.55},{57.49,26},{57.29,28.31},{54.6,28.6},{54.53,28.54},{55.95,31.55},{55.56,30.42},{56.7,30.01},{55.99,31.51},{55.98,31.5},{56.01,31.48},{58.12,30.96}}},nil,405,nil,nil,554,nil,nil,0},
[4665] = {'Burning Blade Adept',802,802,31,32,0,{[405]={{54.99,26.67},{51.88,29},{55.36,21.33},{54.97,23.94},{52.23,28.07},{57.82,22.67},{57.8,26.67},{52.23,33.2},{52.38,28.86},{52.49,29.33},{52.77,28.22},{54.66,26.66},{55.23,26.89},{55,27.12},{55.05,26.19}}},nil,405,nil,nil,554,nil,nil,0},
[4666] = {'Burning Blade Felsworn',1057,1057,31,32,0,{[405]={{55.35,30.19},{53.48,26.25},{55.41,30.04},{55.34,22.28},{52.63,30.01},{55.14,30.38},{55.69,28.32},{54.47,29.85},{55.13,25.7},{54.2,26.46},{55.44,27.75},{53.83,32.8},{53.91,32.55},{53.94,28.08},{53.17,29.32},{52.47,28.47},{53.29,28.52},{55.62,28.66},{54.21,29.42},{54.21,29.45},{55.43,27.54},{55.64,26.35},{55.99,28.26},{55.33,27.64},{54.79,27.58},{53.88,29.34},{53.01,29.61}}},nil,405,nil,nil,554,nil,nil,0},
[4667] = {'Burning Blade Shadowmage',835,835,32,33,0,{[405]={{54.96,26.68},{52.79,28.87},{54.95,26.66}}},{[405]={{{55.23,26.7},{55.09,27},{55,26.99},{54.79,26.87},{54.76,26.71},{54.79,26.39},{54.92,26.32},{55.12,26.44}}}},405,nil,nil,554,nil,nil,0},
[4668] = {'Burning Blade Summoner',867,867,34,35,0,{[405]={{81.91,80.42},{82.12,80.66},{50.46,76.86},{51.31,70.3},{52.85,79.62}}},nil,405,nil,nil,554,nil,nil,0},
[4669] = {'Burning Blade Conjuror',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4670] = {'Hatefury Rogue',1006,1006,30,31,0,{[405]={{71.18,15.07},{71.61,20.06},{79.43,18.84},{74.48,21.99},{78.95,20.17}}},nil,405,nil,nil,90,nil,nil,0},
[4671] = {'Hatefury Trickster',1006,1006,30,31,0,{[405]={{75.07,25.83},{78.94,24.5},{73.69,19.16},{74.98,27.47},{78.99,17.96},{74.88,23.78},{75.81,22.03},{74.52,19.91},{76.75,25.63}}},nil,405,nil,nil,90,nil,nil,0},
[4672] = {'Hatefury Felsworn',1006,1006,30,31,0,{[405]={{77.34,20.28},{79.42,14.46},{70.16,15.51},{70.77,16.84},{74.44,26.45},{73.11,22.08},{73.06,24.46},{72.35,21.29},{71.64,17.57},{74.35,12.54},{75.47,16.39},{76.12,26.69},{75.88,26.24},{78.39,23.16}}},nil,405,nil,nil,90,nil,nil,0},
[4673] = {'Hatefury Betrayer',1006,1006,30,31,0,{[405]={{79.3,15.8},{72.27,19.18},{72.57,13.04},{77.55,26.83},{74.72,17.39},{72.2,17.18},{75.27,21.31},{76.61,14.64},{74.21,23.59},{74.54,21.81},{73.79,20.95},{77.57,24.72},{75.88,23.92}}},nil,405,nil,nil,90,nil,nil,0},
[4674] = {'Hatefury Shadowstalker',1006,1006,30,31,0,{[405]={{77.15,23.11},{76.54,15.2},{72.94,12.49},{78.39,14.21},{79.38,16.23},{73.74,23.58},{72.82,16.82},{73.82,16.82},{73.09,20.21},{78.28,18.76},{78.33,25.64},{75.54,23},{79.26,21.23},{76.79,21.07},{79.39,20.98}}},nil,405,nil,nil,90,nil,nil,0},
[4675] = {'Hatefury Hellcaller',850,850,30,31,0,{[405]={{80.53,17.72},{72.25,18.88},{80.22,16.34},{72.89,17.78},{72.47,23.27},{72.16,14.58},{72.68,16.86},{78.42,16.7},{77.26,16.58},{76.33,22.25},{74.36,23.64},{73.83,14.49},{74.55,18.88},{75.71,23.47},{75.2,23.35},{76.58,19.18},{78.32,22.06}}},nil,405,nil,nil,90,nil,nil,0},
[4676] = {'Lesser Infernal',1469,1536,36,37,0,{[405]={{50.75,73.39},{52.14,70.09},{48.57,76.82},{54.55,71.2},{56.64,71.26},{54.51,73.52},{51.46,75.71}}},nil,405,nil,nil,90,nil,nil,0},
[4677] = {'Doomwarder',1163,1163,34,35,0,{[405]={{54.36,74.07},{52.04,83.99},{51.31,82.72},{55.31,73.21},{52.09,83.12},{52.1,73.2},{50.25,74.55},{54.83,78.53},{53.91,80.01},{51.29,76.84},{50.07,74.66},{52.71,83.25},{54.26,76.35}}},nil,405,nil,nil,90,nil,nil,0},
[4678] = {'Mana Eater',1257,1305,37,38,0,nil,nil,0,nil,nil,90,nil,nil,0},
[4679] = {'Nether Maiden',967,967,34,35,0,{[405]={{51.89,84.77},{54.26,70.57},{54.85,76.63},{48.75,79.04},{52.68,84.86},{48.76,77.47},{51.14,70.08},{49.98,73.21},{50.14,71.36},{52.25,72.52},{52.61,83.92},{50.97,83.37},{50.63,76.88},{50.35,77.12},{51.41,81.94}}},nil,405,nil,nil,90,nil,nil,0},
[4680] = {'Doomwarder Captain',1604,1678,38,39,0,nil,nil,0,nil,nil,90,nil,nil,0},
[4681] = {'Mage Hunter',967,967,34,35,0,{[405]={{56.19,71.64},{51.46,68.7},{56,78.86},{57.01,77.75},{52.4,86.05},{56.97,76.03},{56.53,73.17},{51.43,85.66},{58.12,75.76},{53.68,84.32},{53.37,71.82},{50.14,81.34},{50.52,72.75},{52.85,68.13}}},nil,405,nil,nil,90,nil,nil,0},
[4682] = {'Nether Sister',1305,1357,38,39,0,nil,nil,0,nil,nil,90,nil,nil,0},
[4683] = {'Doomwarder Lord',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4684] = {'Nether Sorceress',1077,1077,39,40,0,nil,nil,0,nil,nil,90,nil,nil,0},
[4685] = {'Ley Hunter',1357,1410,39,40,0,nil,nil,0,nil,nil,90,nil,nil,0},
[4686] = {'Deepstrider Giant',4185,4377,38,39,1,nil,{[405]={{{66.26,32.86},{66.17,33.07},{65.89,33.6},{65.79,34.05},{65.61,34.94},{65.52,35.39},{65.52,35.39},{65.38,36.3},{65.31,36.75},{65.25,37.21},{65.21,37.74},{65.23,38.21},{65.27,38.67},{65.27,38.67},{65.35,39.33},{65.53,39.71},{65.81,40.42},{65.92,40.86},{65.92,40.86},{66.02,41.3},{66.12,41.74},{66.27,42.29},{66.46,42.57},{66.73,42.72},{66.94,42.93},{66.94,42.93},{67.24,43.3},{67.45,43.65},{67.45,43.65},{67.71,44.13},{67.79,44.48},{67.84,45.41},{67.86,45.86},{67.99,46.6},{68.04,46.74},{68.15,47.01},{68.22,47.29},{68.34,47.96},{68.47,48.25},{68.53,48.52},{68.55,48.78},{68.63,49.42},{68.74,49.71},{68.89,49.91},{69.01,49.94},{69.19,49.84},{69.65,49.36},{69.85,49},{69.8,48.75},{69.38,48.28},{69.09,47.61},{69.22,46.95},{69.56,46.69},{69.81,45.97},{69.8,45.41},{69.81,44.43},{69.78,44.01},{69.76,43.79},{69.76,43.79},{69.71,43.33},{69.5,42.31},{69.42,42.16},{69.01,41.68},{68.73,41.48},{68.61,41.37},{68.22,40.81},{68.22,40.81},{67.99,40.51},{67.59,39.86},{67.31,39.15},{67.23,38.74},{67.2,38.28},{67.2,38.28},{67.18,37.81},{67.12,36.88},{67.06,36.34},{66.9,35.74},{66.72,35.36},{66.39,34.6},{66.27,34.07},{66.28,33.88},{66.5,33.56},{66.89,32.93},{66.89,32.93},{67.02,32.5},{67.2,31.89},{67.22,31.26},{67.1,30.82},{66.89,30.48},{66.81,30.38},{66.69,30.23},{66.41,30.02},{65.85,29.62},{65.34,29.28},{65.41,29.43},{65.63,29.76},{65.83,30.11},{66.05,30.56},{66.13,30.94},{66.18,31.4},{66.19,32.13},{66.25,32.52}}}},0,nil,nil,778,nil,nil,0},
[4687] = {'Deepstrider Searcher',4377,4572,39,40,1,nil,{[405]={{{32.06,24.65},{32.25,24.72},{32.56,24.91},{32.71,24.98},{32.89,25.01},{33.25,25.11},{33.47,25.22},{33.73,25.52},{33.82,25.83},{33.87,26.07},{33.94,26.33},{34.13,26.71},{34.35,27},{34.55,27.13},{34.83,27.23},{35.03,27.27},{35.3,27.26},{35.5,27.1},{35.61,26.87},{35.82,26.36},{35.92,26},{35.97,25.48},{36.02,25.06},{36.1,24.81},{36.23,24.57},{36.49,24.1},{36.65,23.78},{36.74,23.42},{36.67,23.11},{36.59,22.93},{36.52,22.65},{36.56,22.42},{36.58,22},{36.39,21.78},{36.32,21.76},{36,21.8},{35.74,21.9},{35.6,21.99},{35.34,22.19},{35.21,22.34},{35.07,22.53},{34.78,22.95},{34.64,23.17},{34.51,23.38},{34.29,23.7},{34.16,23.85},{33.84,24.17},{33.6,24.38},{33.46,24.42},{33.21,24.44},{33.05,24.36},{32.78,24.41},{32.56,24.37},{32.18,24.22},{31.81,24.02},{31.46,23.71},{31.19,23.33},{31.11,22.96},{31.18,22.43},{31.22,22.17},{31.26,21.64},{31.25,21.39},{31.22,20.87},{31.21,20.33},{31.17,20.05},{31.13,19.62},{31.07,19.08},{30.73,18.76},{30.37,18.59},{30.05,18.46},{29.65,18.41},{29.5,18.43},{29.06,18.58},{28.92,18.69},{28.69,19.13},{28.79,19.4},{28.94,19.45},{29.28,19.43},{29.59,19.5},{29.75,19.53},{30.17,19.6},{30.42,19.71},{30.73,19.88},{30.95,20.18},{31.02,20.34},{31.14,20.7},{31.21,21.02},{31.27,21.41},{31.32,21.75},{31.33,22.16},{31.35,22.49},{31.35,22.86},{31.37,23.09},{31.48,23.64},{31.76,24.2},{31.9,24.4}}}},0,nil,nil,778,nil,nil,0},
[4688] = {'Bonepaw Hyena',264,264,31,32,0,{[405]={{45.36,30.4},{45.09,30.08},{45.05,30.21},{45.05,30.31},{44.99,30.31}}},nil,405,nil,nil,38,nil,nil,0},
[4689] = {'Starving Bonepaw',239,239,30,30,0,{[405]={{69.5,31.12},{69.97,30.48},{69.95,30.54},{69.9,30.55},{69.99,30.52},{60.33,19.7},{60.63,20.34},{60.33,19.79},{61.11,21.81},{60.54,20.16}}},nil,405,nil,nil,38,nil,nil,0},
[4690] = {'Rabid Bonepaw',278,278,32,33,0,{[405]={{41.8,35.35},{44.48,40.41},{44.44,40.32},{44.42,40.56},{44.41,40.43}}},nil,405,nil,nil,38,nil,nil,0},
[4691] = {'Murderous Bonepaw',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4692] = {'Dread Swoop',955,955,30,31,0,{[405]={{64.61,61.11},{68.68,59.29},{60.13,64.93},{46.93,14.5},{47.89,32.17},{51.84,19.99},{43.85,16.76},{73.95,58},{65.78,57.68},{47.9,65.62},{74.06,60.64},{72.35,63.57},{39.53,69.07},{63.79,66.06},{58.96,32.43},{73.13,35.74},{50.2,26.94},{46.27,35.36},{48.78,34.03},{39.74,65.99},{74.09,64.26},{66.86,62.62},{55.3,66.84},{43.36,37.95},{48.02,27.9},{43.01,28.93},{74.79,56.34},{69.14,55.55},{61.68,65.33},{56.6,18.87},{43.5,31.99},{39.49,36.22},{44.99,25.03},{44.73,39.69},{45.31,20.47},{42.73,30.23},{56.89,33.08},{69.08,52.78},{55.13,12.23},{55.51,12.39},{59.03,65.36},{49.6,33.48},{48.02,24.74},{43.34,43.49},{48.5,38.82},{46.33,33.29},{72.3,59},{69.43,61.01},{39.87,73.8},{45.38,71.33},{40.37,69.89},{58.17,32.45},{52.43,37.95},{45.42,21.57},{47.42,30.78},{69.36,65.61},{55.08,67.42},{52.94,17.36},{56.65,18.17},{48.45,11.74},{51.08,20.49},{52.88,21.94},{72.59,34.28},{48.7,21.18},{41.14,35.59},{50.81,23.04},{57.95,70.4},{53.53,34.59},{64.67,26},{70.13,35.37},{75.17,34.42},{57.36,20.08},{62.38,18.05},{59.73,13.07},{59.11,31.23},{51.52,66.84},{76.1,33.43},{55.47,14.32},{52.89,20.28},{65.31,18.25},{69.45,20.46},{69.55,20.5},{65.86,20.23},{64.87,27.35},{62.92,30.82},{63.47,29.04},{62.68,28.26},{59.75,24.74},{60.95,18.14},{58.92,23.49},{59.86,23.96},{61.2,18.61},{48.22,15.79},{49.06,28.76},{45.01,37.75},{45.44,15.88},{33.81,75.73},{41.23,75.46},{65.64,59.32},{38.34,76.3},{55.99,9.17},{56.28,6.99},{51.49,4.82},{52.11,4.39},{53.04,4.42},{49.82,11.24},{47.3,8.29},{50.18,8.52},{55.16,12.14},{55.95,9.44},{57.35,7.37},{55.47,14.15},{56.45,7.67},{56.38,6.87},{51.46,5.01},{51.98,4.64},{53.12,4.34},{50.24,4.53},{48.34,5.97},{55.56,12.79}}},nil,405,nil,nil,73,nil,nil,0},
[4693] = {'Dread Flyer',1163,1163,33,33,0,{[405]={{63.55,60.33},{42.06,42.17},{76.64,44.44},{41.71,59.82},{42.07,37.07},{33.8,68.09},{42.63,57.93},{42.58,63.36},{37.67,58.19},{37.98,51.44},{40.31,36.86},{41.88,57.84},{39.46,48.8},{45.44,64.25},{37.38,67.57},{33.92,69.94},{44.87,63.41},{27.86,52.51}}},nil,405,nil,nil,73,nil,nil,0},
[4694] = {'Dread Ripper',1220,1220,34,35,0,{[405]={{56.71,85.47},{61.11,73.46},{62.53,82.33},{59.7,81.28},{63.59,68.63},{58.48,80.26},{56.47,81.17},{65.21,77.82},{55.11,83.31}}},nil,405,nil,nil,73,nil,nil,0},
[4695] = {'Carrion Horror',1110,1110,32,33,0,{[405]={{54.9,59.69},{54.71,62.24},{49.05,60.29},{51.85,56.98},{51.26,61.07},{51.42,56.52},{50.29,56.18},{49.35,57.96},{49.24,56.5},{53.03,60.93},{53.9,59.62},{53.06,56.43},{52.07,60.98},{52.24,58.8},{53.78,62.37}}},nil,405,nil,nil,73,nil,nil,0},
[4696] = {'Scorpashi Snapper',955,955,30,31,0,{[405]={{52.88,11.97},{64.88,35.83},{76.02,34.62},{54.35,22.45},{56.67,14.6},{73.13,35.26},{62.39,13.79},{52.12,10.37},{70.05,19.12},{63.34,62.81},{56.54,16.48},{74.38,30.58},{78.26,35.16},{54.23,65.83},{54.73,13.21},{64.9,16.65},{78.41,33.02},{53.28,13.53},{61.23,15.54},{58.31,12.81},{69.23,17.98},{74.41,35},{72.26,35.51},{68.59,33.54},{75.12,33.94},{60.99,65.47},{56.19,20.07},{53.1,66.12},{77.01,35.84},{68.14,18.56},{68.31,34.7},{54.53,19.14},{59.5,27.08},{68.23,33.98},{57.05,11.33},{63.05,18.89},{73.78,33.34},{77.08,33.13},{55.93,65.09},{54.37,68.04},{72.38,26.51},{70.23,20.32},{68.74,21.09},{65.72,27.97},{71.3,23.5},{64.51,28.71},{73.08,30.31},{67.68,22.5},{71.31,32.56},{59.11,22.33},{61.09,23.68},{61.96,24.97},{65.33,19.32},{64.68,20.08},{64.87,22.19},{66.65,22.49},{63.79,22.23},{67.73,25.53},{67.52,24.65},{65.19,24.54},{69.33,26.95},{70.59,25.93},{71.58,29.92},{70.94,31.01},{63.47,34.07},{69.19,22.46},{58.87,21.23},{64.25,30.33},{70.29,28.95},{52.16,7.74},{57.06,11.53},{58.97,10.3},{52.77,12.06},{52.19,9.9},{54.88,13.73},{52.16,7.77},{49.9,6.51},{56.59,14.7},{61.01,13.03}}},nil,405,nil,nil,413,nil,nil,0},
[4697] = {'Scorpashi Lasher',1110,1110,32,33,0,{[405]={{41.88,52.4},{44.35,60.91},{71.5,64.11},{69.16,62.88},{68.18,60.76},{70.68,58.99},{72.62,60.58},{38.67,73.93},{72.4,57.79},{43.77,79.06},{44.01,72.03}}},nil,405,nil,nil,413,nil,nil,0},
[4699] = {'Scorpashi Venomlash',1163,1163,34,35,0,{[405]={{62.45,70.06},{43.52,83.53},{62.68,78.85},{64.01,74.29},{62.91,66.55},{31.34,69.84},{51.07,87.77},{61.27,68.54},{44.69,88.15},{43.54,85.74},{60.01,73.12},{59.05,71.73},{64.65,72.6}}},nil,405,nil,nil,413,nil,nil,0},
[4700] = {'Aged Kodo',1057,1057,31,32,0,{[405]={{50.67,59.18},{50.21,58.14},{51.72,58.01},{50.01,60.27},{55.02,58.3},{48.7,57.67},{46.58,59.09},{52.92,58.02},{54.56,57.49},{53.53,64.29},{51.35,59.22},{52.82,33.96},{53.11,34.56},{44.86,31.14},{43.96,35.07},{47.93,51.39},{50.55,43.3},{50.28,44.72},{44.02,35.61},{54.87,68.45},{71.91,59.35},{72.77,58.33},{72.4,58.22},{56.85,83.49},{57.31,85.35},{57.56,85.5}}},nil,405,nil,nil,15,"AH",nil,0},
[4701] = {'Dying Kodo',1057,1057,32,33,0,{[405]={{48.61,56.27},{46.98,60.92},{48.29,60.2},{52.47,62.1},{55.41,62.07},{53.99,61.37},{51.91,55.73},{55.52,64.23},{52.86,59.95},{53.05,33.58},{44.7,32.48},{72.02,59.17},{57.57,79.14}}},nil,405,nil,nil,15,"AH",nil,0},
[4702] = {'Ancient Kodo',1057,1057,32,33,0,{[405]={{50.93,56.7},{53.49,57.47},{52.32,57.18},{54.26,63.46}}},nil,405,nil,nil,15,"AH",nil,1},
[4703] = {'Raging Kodo',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4704] = {'Maraudine Pack Runner',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4705] = {'Burning Blade Invoker',1040,1040,39,39,0,{[405]={{82.47,80.99}}},nil,405,nil,nil,554,nil,nil,0},
[4706] = {'[Deprecated for 4.x]Razzeric',1003,1003,30,30,0,nil,nil,0,nil,{1186,1187,1189},35,"AH",nil,0},
[4707] = {'[Deprecated for 4.x]Zuzubee',1342,1342,35,35,0,nil,nil,0,nil,nil,35,"AH","Race Announcer",0},
[4708] = {'Shreev',1678,1678,39,39,0,{[440]={{50.92,28.23}}},nil,440,nil,{1188},474,"AH",nil,0},
[4709] = {'[Deprecated for 4.x]Zamek',1003,1003,30,30,0,nil,{[400]={{{79.05,77.4},{78.32,78.09},{77.67,78.44},{77.57,78.39},{77.67,78.44},{78.32,78.09},{79.05,77.4},{79.81,77.03}}}},0,nil,{1191},35,"AH",nil,0},
[4710] = {'Gray Ram',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4711] = {'Slitherblade Naga',1057,1057,31,32,0,{[405]={{33.85,21.43},{37.57,22.74},{37.91,37.27},{35.76,33.87},{37.62,21.51},{35.8,26.63},{35.23,30.17},{39.68,20.09},{37.28,35.89},{34.47,26.54},{39.96,27.21},{41.08,27.21},{41.04,25.68},{40.8,23.78},{41.82,25.56},{41.73,26.95},{37.4,31.9},{38.26,32.28},{38.02,34.25},{38.22,35.42},{36.81,24.43},{39.51,24.77},{35.17,21.28},{32.55,23.89}}},nil,405,nil,nil,74,nil,nil,0},
[4712] = {'Slitherblade Sorceress',802,802,31,32,0,{[405]={{36.21,36.2},{36.48,36.83},{39.4,22.31},{38.57,23.47},{40.13,22.3},{41.38,22.42},{40.91,22.28},{38.06,24.37},{37.05,25.64},{36.48,26.48},{36.12,29.17},{36.12,30.97},{35.37,31.65},{36.51,33.17},{37.58,24.98}}},nil,405,nil,nil,74,nil,nil,0},
[4713] = {'Slitherblade Warrior',1006,1006,31,32,0,{[405]={{42.18,18.81},{33.74,25.64},{42.53,24.78},{38.67,38.02},{32.03,21.97},{32.62,21.49},{33.08,22.33},{38.87,21.03},{36.49,35.87},{39,18.66},{39.85,22.97},{41.75,23.72},{41.47,25.43},{41.93,27.91},{41.78,28.06},{36.34,28.66},{36.38,27.68},{38.95,32.02},{38.94,32.32},{36.57,29.48},{36.45,32.06},{38.82,34.25},{36.56,34.56},{37.42,34.42},{38.51,25.3},{40.5,27.35},{31.62,23.11},{37.19,25.98},{36.65,20.54},{39.84,25.48},{37.77,25.75}}},nil,405,nil,nil,74,nil,nil,0},
[4714] = {'Slitherblade Myrmidon',1057,1057,31,32,0,{[405]={{33.97,13.49},{38.06,16.81},{37.22,19.44},{26.33,10.97},{34.76,12.45},{34.67,17.71},{35.54,16.25},{36.61,15.21},{40.62,15.07},{26.36,9.57},{27.26,4.95},{41.06,16.76},{36.93,12.8},{36.28,12.36},{34.82,16.86},{34.31,14.97},{33.08,11.08},{34.09,8.67},{33.2,10.18},{36.17,17.89},{32.82,12.44},{37.06,11.57},{41.84,15.11},{35.53,14.02},{37.12,14.44},{37.49,13.89},{35.31,8.44},{41.79,21.1},{33.54,15.65},{29.14,8.45},{40.53,18.86},{34.47,24.68},{34.75,28.17},{34.22,10.58},{26.45,7.52},{34.83,22.78}}},nil,405,nil,nil,74,nil,nil,0},
[4715] = {'Slitherblade Razortail',1220,1220,35,36,0,{[405]={{27.9,26.67},{27.87,30.67},{27.21,31.35},{31.93,33.5},{31.35,28.94},{28,32.92},{31.2,27.27},{29.64,33.88},{29.52,29.87},{30.56,34.83},{26.6,30.71},{28.69,27.68},{26.47,32.81},{32.19,27.95},{29.04,31.43},{29.59,32.16},{32.33,30.06},{31.37,30.98}}},nil,405,nil,nil,74,nil,nil,0},
[4716] = {'Slitherblade Tidehunter',888,888,32,32,0,{[405]={{27.8,12.19},{28.37,12.02},{29.94,11.32},{32.21,14.17},{30.58,18.56},{31.12,8.07},{31.49,5.45},{29.88,15.97},{26.59,8.81},{29.34,18.75},{31.87,19.86},{29.23,19},{31.76,19.96}}},nil,405,nil,nil,74,nil,nil,0},
[4717] = {'Slitherblade Tide Priestess',5000,5000,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4718] = {'Slitherblade Oracle',1009,1009,35,36,0,{[405]={{27.12,28.99},{29.76,27.61},{28.59,32.66},{26.84,27.56},{33,28.96},{30.57,33.18},{27.17,32.95},{33.33,32.76},{30.49,28.28},{32.12,29.13},{30.52,29.51},{32.83,31.39},{29.04,31.32}}},nil,405,nil,nil,74,nil,nil,0},
[4719] = {'Slitherblade Sea Witch',888,888,32,33,0,{[405]={{26.94,11.53},{28.56,16.62},{31.85,18.22},{31.5,10.7},{29.55,5.19},{28.69,14.37},{30.77,3.31},{29.92,12.13},{31.7,6.6},{30.37,13.76},{29.29,22.22},{33.08,5.75},{30.64,20.96},{31.36,15.57},{28.91,8.69},{31.54,16.05}}},nil,405,nil,nil,74,nil,nil,0},
[4720] = {'[Deprecated for 4.x]Rizzle Brassbolts',1003,1003,30,30,0,nil,{[400]={{{77.56,77.62},{77.59,77.86},{77.73,78.01},{77.69,78.26},{77.57,78.39},{77.69,78.26},{77.73,78.01},{77.59,77.86},{77.56,77.62},{77.22,77.4}}}},0,nil,nil,35,"AH",nil,0},
[4721] = {'Zangen Stonehoof',713,713,25,25,0,{[1638]={{54.97,51.41}}},nil,1638,nil,{1195},104,"H",nil,0},
[4722] = {'[Deprecated for 4.x]Rau Cliffrunner',1003,1003,30,30,0,nil,nil,0,nil,{1196,1197},104,"H",nil,0},
[4723] = {'Foreman Cozzle',1464,1464,28,28,0,{[33]={{54.74,34.13}}},nil,33,nil,nil,47,nil,nil,0},
[4724] = {'Sandstrider',1605,1605,30,30,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[4725] = {'Crazed Sandstrider',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4726] = {'Raging Thunder Lizard',1057,1057,31,32,0,{[405]={{77.53,57.25},{49.3,66.78},{74.36,59.1},{67.33,67.75},{37.49,75.48},{68.34,58.46},{46.29,16.12},{44.68,26.57},{50.35,30.39},{68.34,56.86},{70.03,62.14},{50.91,35.5},{46.42,28.93},{49.47,23.78},{53.05,24.32},{53.45,23.63},{40.04,76.72},{65.15,63.39},{71.54,57.77},{65.58,74.7},{73.47,58.85},{71.01,60.24},{68.49,66.78},{43.52,27.53},{47.49,22.28},{75.43,56.06},{69.84,60.26},{49.86,28.6},{72.22,62.43},{50.7,25.31},{43.37,41.81},{52,24.54},{47.75,29.33},{40.45,34.19},{46.27,38.84},{46.46,17.62},{45.02,17.32},{74.58,62.86},{68.96,53.71}}},nil,405,nil,nil,14,nil,nil,0},
[4727] = {'Elder Thunder Lizard',1110,1110,33,33,0,{[405]={{55.35,88.09},{59.67,79.13},{41.44,41.11},{62.83,80.36},{32.72,69.95},{55.89,82.77},{62.58,72.4},{49.32,88},{64.07,77.33},{45.52,87},{50.78,90.17},{58.7,83.69},{41.73,46.65},{42.9,45.7},{47.15,86.69},{57.71,87.04},{63.99,70.86},{58.16,91.58},{77.39,53.17}}},nil,405,nil,nil,14,nil,nil,0},
[4728] = {'Gritjaw Basilisk',1006,1006,30,31,0,{[405]={{69.9,29.97},{62.79,14.92},{45.49,31.95},{49.98,35.53},{53.6,20.9},{69.78,27.9},{63.37,15.32},{49.76,25.65},{72.04,30.9},{43.86,22.91},{74.72,32.58},{59.48,16.42},{56.89,68.92},{47.06,39.13},{60.46,32.86},{57.36,17.98},{59.27,31.41},{75.19,35.71},{59.94,14.28},{75.94,32.39},{53.63,12.49},{68.83,35.82},{57.89,16.29},{71.66,34.55},{69.97,36.9},{71.16,36.14},{61.17,30.22},{75.57,31.43},{56.31,17.73},{58.67,18.95},{72.61,37.08},{64.89,34.47},{55.07,15.6},{57.94,65.88},{54.59,17.67},{77.41,34.93},{56.59,63.92},{72.98,27.78},{70.71,22.45},{69.89,25.26},{67.18,19.17},{72.26,29.21},{71.42,26.06},{70.98,24.14},{67.71,20.24},{68.77,19.78},{68.58,23.32},{64.03,19.03},{61.83,22.42},{61.07,27.07},{60.15,25.23},{60.54,22.26},{59.71,18.93},{65.55,21.06},{67.12,23.36},{66.52,24.9},{65.74,25.75},{65.57,24.17},{67.81,27.54},{64,23.63},{66.88,26.71},{51.49,5.84},{48.75,7.84},{60.32,14.51},{56.53,10.91},{57.32,9.28},{51.14,9.21},{50.6,7.49},{55.35,15.33},{51.58,6.8}}},nil,405,nil,nil,49,nil,nil,0},
[4729] = {'Hulking Gritjaw Basilisk',1110,1110,32,32,0,{[405]={{41.15,39.4},{42.02,40.87},{77.5,53.41},{76.77,54.91},{41.88,44.26},{42.98,50.33},{41.88,55.47},{43.71,57.7},{41.05,63.38},{42.76,59.03}}},nil,405,nil,nil,49,nil,nil,0},
[4730] = {'Lelanai',1342,1342,35,35,0,{[1657]={{42.5,32.59}}},nil,1657,nil,nil,80,"A","Saber Handler",131},
[4731] = {'Zachariah Post',1003,1003,30,30,0,{[85]={{61.91,51.78}}},nil,85,nil,nil,68,"H","Undead Horse Merchant",129},
[4732] = {'Randal Hunter',198,198,10,10,0,{[12]={{84.32,64.87}}},nil,12,nil,{14079,32618},12,"A","Riding Trainer",82},
[4752] = {'Kildar',2769,2769,50,50,0,{[1637]={{61.32,34.61}}},nil,1637,nil,{14086,32669},29,"H","Riding Trainer",83},
[4753] = {'Jartsam',2218,2218,45,45,0,{[1657]={{42.78,32.92}}},nil,1657,nil,{14085,32664},80,"A","Riding Trainer",83},
[4772] = {'Ultham Ironhorn',198,198,10,10,0,{[1]={{71.15,48.41}}},nil,1,nil,{14083,32662},55,"A","Riding Trainer",83},
[4773] = {'Velma Warnam',1003,1003,30,30,0,{[85]={{61.88,51.86}}},nil,85,nil,{14089,32672},68,"H","Riding Trainer",82},
[4775] = {'Felicia Doan',1003,1003,30,30,0,{[1497]={{64.13,50.56}}},nil,1497,nil,nil,68,"H","Trade Supplies",128},
[4777] = {'White Ram',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4778] = {'Frost Ram',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4779] = {'Brown Ram',55,55,2,2,0,{[618]={{58.82,50.05}}},nil,618,nil,nil,35,"AH",nil,0},
[4780] = {'Black Ram',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4781] = {'Snufflenose Gopher',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4782] = {'Truk Wildbeard',2769,2769,50,50,0,{[47]={{14.36,42.31}}},nil,47,nil,nil,694,"A","Bartender",640},
[4783] = {'Dawnwatcher Selgorm',713,713,25,25,0,{[1657]={{54.79,38.79}}},nil,1657,nil,nil,814,"AH","The Argent Dawn",0},
[4784] = {'Argent Guard Manados',617,617,23,23,0,{[1657]={{54.15,38.52}}},nil,1657,nil,nil,814,"AH","The Argent Dawn",0},
[4785] = {'Illusionary Nightmare',950,1003,29,30,0,nil,nil,0,nil,nil,73,nil,nil,0},
[4786] = {'Dawnwatcher Shaedlass',573,573,22,22,0,{[1657]={{54.24,39.23}}},nil,1657,nil,nil,814,"AH","The Argent Dawn",0},
[4787] = {'Scout Thaelrid',484,484,20,20,0,{[719]={{-1,-1}}},nil,719,{26882},{1198,26460},80,"A",nil,2},
[4788] = {'Fallenroot Satyr',1400,1500,20,21,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4789] = {'Fallenroot Rogue',521,521,21,22,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4791] = {'Nazeer Bloodpike',2578,2578,48,48,0,{[15]={{35.21,30.66}}},nil,15,{1201,1202,11213,11215,26991},{1201,1202,1238,1239,1261,11186,27244},125,"H",nil,2},
[4792] = {'"Swamp Eye" Jarl',1981,1981,42,42,0,{[15]={{55.44,26.27}}},nil,15,{27183,27184,27186,27191},{1203,1206,1218,11177,11225,27182,27183,27184,27186,27191,27215},35,"AH",nil,2},
[4794] = {'Morgan Stern',1469,1469,36,36,0,{[15]={{68.27,48.72}}},nil,15,{1204,1258},{1204,1222,1258,1260},894,"A",nil,3},
[4795] = {'Force of Nature',334,334,37,38,0,nil,nil,0,nil,nil,1802,"A",nil,0},
[4798] = {'Fallenroot Shadowstalker',2420,2420,23,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4799] = {'Fallenroot Hellcaller',2284,2284,23,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4802] = {'Blackfathom Tide Priestess',404,404,19,20,0,{[331]={{14.15,8.62},{14.55,8.8},{13.59,9.04},{13.9,9.21},{13.04,9.36},{13.26,9.38},{14.49,9.45},{13.93,9.93},{12.55,9.98},{14.73,10.1},{13.05,10.2},{14.76,10.21},{14.9,10.43},{13.89,10.6},{17.93,10.89},{15.23,10.96},{17.69,11.08},{15.73,11.39},{15.75,11.41},{13.75,11.71},{13.67,11.8},{16.55,12.01},{17.04,12.04},{13.41,12.06},{13.31,12.64},{13.25,13.22},{17.69,11.06},{17.92,10.89}}},nil,331,nil,nil,128,nil,nil,0},
[4803] = {'Blackfathom Oracle',464,464,21,22,0,nil,nil,0,nil,nil,128,nil,nil,0},
[4805] = {'Blackfathom Sea Witch',2132,2132,23,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4807] = {'Blackfathom Myrmidon',2420,2420,23,23,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4809] = {'Twilight Acolyte',2284,2284,23,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4810] = {'Twilight Reaver',2604,2604,24,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4811] = {'Twilight Aquamancer',2284,2284,24,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4812] = {'Twilight Loreseeker',2132,2132,23,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4813] = {'Twilight Shadowmage',2112,2112,24,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4814] = {'Twilight Elementalist',2112,2112,24,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4815] = {'Murkshallow Snapclaw',2420,2420,23,23,1,{[719]={{-1,-1}}},nil,719,nil,nil,129,nil,nil,0},
[4816] = {'Murkshallow Shellhide',75,80,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[4818] = {'Blindlight Murloc',2420,2420,23,23,1,{[719]={{-1,-1}}},nil,719,nil,nil,18,nil,nil,0},
[4819] = {'Blindlight Muckdweller',2604,2604,24,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,18,nil,nil,0},
[4820] = {'Blindlight Oracle',2112,2112,24,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,18,nil,nil,0},
[4821] = {'Skittering Crustacean',2420,2420,23,23,1,{[719]={{-1,-1}}},nil,719,nil,nil,350,nil,nil,0},
[4822] = {'Snapping Crustacean',2420,2420,23,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,350,nil,nil,0},
[4823] = {'Barbed Crustacean',1953,1953,24,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4824] = {'Aku\'mai Fisher',2420,2420,24,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,350,nil,nil,0},
[4825] = {'Aku\'mai Snapjaw',2604,2604,24,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4827] = {'Deep Pool Threshfin',2420,2420,23,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,16,nil,nil,0},
[4829] = {'Aku\'mai',20970,20970,25,25,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4830] = {'Old Serra\'kis',17475,17475,25,25,1,{[719]={{-1,-1}}},nil,719,nil,nil,16,nil,nil,0},
[4831] = {'Lady Sarevess',14275,14275,24,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4832] = {'Twilight Lord Kelris',15250,15250,25,25,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4834] = {'Theramore Infiltrator',1220,1220,35,36,0,{[15]={{38.05,23.6},{42.81,31.16},{42.59,30.53},{39.68,23.9},{38.93,22.33},{38.04,33.98},{36.57,35.56},{40.53,32.61},{40.53,35.57},{36.24,37.69},{37.04,38.47},{38.03,37.41},{37.76,28.74},{38.96,21.64}}},nil,15,nil,nil,1077,"A",nil,0},
[4841] = {'Deadmire',1902,1902,41,41,0,{[15]={{47.12,57.48}}},{[15]={{{47.25,54.56},{47.27,54.57},{47.48,54.71},{47.56,54.77},{47.7,54.86},{47.7,54.86}}}},15,nil,nil,16,nil,nil,0},
[4842] = {'Earthcaller Halmgar',8072,8072,35,35,2,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4844] = {'Shadowforge Surveyor',1050,1050,35,36,0,{[3]={{34.26,14.73},{41.16,10.41},{37.04,11.9},{34.88,11.48},{34.79,12.87},{41.35,10.2},{41.7,9.76},{42.75,8.87},{37.83,17.65},{37.82,16.31},{42.05,11.03},{43.4,11.9},{44.05,12.38},{39.99,11.07},{37.92,10.66},{35.24,11.97},{43.4,8.34},{43.01,9.88},{43.22,8.58},{42.19,11.77},{43.59,10.78},{42.99,11.55},{42.3,10.21},{44.31,9.37},{42.12,11.83},{37.91,10.73},{37.17,11.21},{37.8,12.64},{36.07,10.77},{36.31,11.22},{35.41,14.46},{34.24,14.71},{34.77,12.85},{34.38,12.48},{34.89,11.52},{33.73,13.69},{33.83,13.07}},[38]={{38.6,87.72}}},nil,3,nil,nil,54,nil,nil,0},
[4845] = {'Shadowforge Ruffian',1220,1220,35,36,0,{[3]={{34.44,14.67},{34.8,15},{33.75,12.05},{33.8,13.14},{40.11,10.27},{37.01,12.1},{34.89,12.23},{37.68,17.99},{38.65,10.63},{37.4,11.09},{37.02,12.11},{35.24,11.96},{34.81,15.02},{34.43,14.71},{34.92,12.28},{33.73,11.98}}},nil,3,nil,nil,54,nil,nil,0},
[4846] = {'Shadowforge Digger',1220,1220,35,36,0,{[3]={{35.02,13.46},{44.6,9.92},{42.05,8.97},{41.96,9.08},{42.45,8.57},{41.6,9.47},{38.56,11.69},{36.55,11.68},{38.08,16.15},{37.85,16.01},{37.4,17.1},{37.42,16.76},{39.03,10.96},{43.63,10.11},{43.86,10.59},{44.83,10.66},{43.44,11.15},{42.46,9.78},{37.18,12.53},{37.46,12.85},{37.88,11.77},{37.55,11.02},{37.21,10.92},{35.53,12.93},{35.95,12.81},{36.31,12.66},{36.41,12.87},{36.84,13.3},{36.73,13.04},{37.02,14.22},{37.18,14.72},{37.19,14.36},{35.45,14.65},{35.08,13.44}}},nil,3,nil,nil,54,nil,nil,0},
[4847] = {'Shadowforge Relic Hunter',4720,4720,38,39,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,54,nil,nil,0},
[4848] = {'Shadowforge Darkcaster',4540,4540,38,38,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,54,nil,nil,0},
[4849] = {'Shadowforge Archaeologist',5836,5836,39,39,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,54,nil,nil,0},
[4850] = {'Stonevault Cave Lurker',5344,5344,37,38,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,59,nil,nil,0},
[4851] = {'Stonevault Rockchewer',1336,1336,36,37,0,{[3]={{35.5,15.49},{35.92,15.34},{36.4,14.94},{35.77,16.24},{35.56,16.37},{35.95,15.9},{32.89,13.68},{32.65,13.18},{31.91,14.32},{32.94,15.36},{32.76,15.63}}},nil,3,nil,nil,59,nil,nil,0},
[4852] = {'Stonevault Oracle',4372,4372,37,37,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,59,nil,nil,0},
[4853] = {'Stonevault Geomancer',4016,4016,38,39,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,59,nil,nil,0},
[4854] = {'Grimlok',24520,24520,40,40,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,59,nil,"Stonevault Chieftain",0},
[4855] = {'Stonevault Brawler',5580,5580,38,39,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,59,nil,nil,0},
[4856] = {'Stonevault Cave Hunter',1277,1277,36,37,0,{[3]={{33.57,15.68},{33.21,19.48},{34.92,20.39},{35.93,15.31},{35.48,15.48},{32.24,13.69},{32.05,14.51},{33.34,15.74},{33.62,15.77},{32.95,16.15},{32.98,16.45}}},nil,3,nil,nil,59,nil,nil,0},
[4857] = {'Stone Keeper',6096,6096,40,40,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,416,nil,nil,0},
[4860] = {'Stone Steward',5836,5836,39,39,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,415,nil,nil,0},
[4861] = {'Shrike Bat',5580,5580,37,38,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,411,nil,nil,0},
[4862] = {'Rabid Shrike Bat',1,1,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[4863] = {'Jadespine Basilisk',5344,5344,37,38,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,49,nil,nil,0},
[4872] = {'Obsidian Golem',1336,1336,37,37,0,{[3]={{37.91,17.91}}},nil,3,nil,nil,54,nil,nil,0},
[4875] = {'Turhaw',1753,1753,40,40,0,nil,nil,0,nil,nil,29,"H","Butcher",640},
[4876] = {'[Deprecated for 4.x]Jawn Highmesa',1342,1342,35,35,0,nil,nil,0,nil,nil,104,"H","General Goods",384},
[4877] = {'Jandia',1536,1536,37,37,0,nil,nil,0,nil,nil,104,"H","Trade Supplies",128},
[4878] = {'[Deprecated for 4.x]Montarr',1469,1469,36,36,0,nil,nil,0,nil,nil,104,"H","Lorekeeper",2176},
[4879] = {'Ogg\'marr',1753,1753,40,40,0,{[15]={{36.7,30.97}}},nil,15,nil,nil,29,"H","Butcher",640},
[4880] = {'"Stinky" Ignatz',1342,1342,35,35,0,{[15]={{46.88,17.52}}},nil,15,{1222,1270},nil,35,"AH",nil,2},
[4881] = {'Varng',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Turtle Trainer",0},
[4883] = {'Krak',2059,2059,43,43,0,{[15]={{36.4,30.85}}},nil,15,nil,nil,29,"H","Armorer",4224},
[4884] = {'Zulrg',2059,2059,43,43,0,{[15]={{36.17,31.8}}},nil,15,nil,nil,29,"H","Weaponsmith",4224},
[4885] = {'Gregor MacVince',1342,1342,35,35,0,{[15]={{65.19,51.5}}},nil,15,nil,nil,894,"A","Horse Breeder",129},
[4886] = {'Hans Weston',1536,1536,37,37,0,{[15]={{64.63,50.42}}},nil,15,nil,nil,894,"A","Armorer & Weaponsmith",4224},
[4887] = {'Ghamoo-Ra',13020,13020,24,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4888] = {'Marie Holdston',1536,1536,37,37,0,{[15]={{64.61,50.07}}},nil,15,nil,nil,894,"A","Blacksmithing Trainer",4305},
[4889] = {'Torq Ironblast',1753,1753,40,40,0,{[15]={{67.51,47.98}}},nil,15,nil,nil,55,"A","Gunsmith",4224},
[4890] = {'Piter Verance',1902,1902,41,41,0,{[15]={{67.39,47.86}}},nil,15,nil,nil,894,"A","Weaponsmith & Armorer",4224},
[4891] = {'Dwane Wertle',896,896,28,28,0,{[15]={{68.17,47.35}}},nil,15,nil,nil,894,"A","Chef",640},
[4892] = {'Jensen Farran',1536,1536,37,37,0,{[15]={{67.95,49.89}}},nil,15,nil,nil,894,"A","Hunter Trainer & Bowyer",4241},
[4893] = {'Bartender Lillian',2218,2218,45,45,0,{[15]={{66.67,45.21}}},nil,15,nil,nil,894,"A","Bartender",640},
[4894] = {'Craig Nollward',1163,1163,32,32,0,{[15]={{66.9,45.25}}},nil,15,nil,nil,894,"A","Cooking Trainer",721},
[4895] = {'Smiling Jim',1342,1342,35,35,0,{[15]={{66.17,45.8}}},nil,15,nil,{1281},1075,"A",nil,1},
[4896] = {'Charity Mipsy',1342,1342,35,35,0,{[15]={{67.45,51.72}}},nil,15,nil,nil,894,"A","General Goods & Reagents",2688},
[4897] = {'Helenia Olden',1279,1279,34,34,0,{[15]={{66.44,51.46}}},nil,15,nil,nil,894,"A","Trade Supplies",128},
[4898] = {'Brant Jasperbloom',1536,1536,37,37,0,{[15]={{64.01,47.53}}},nil,15,nil,nil,894,"A","Herbalism Trainer",80},
[4899] = {'Uma Bartulm',1536,1536,37,37,0,{[15]={{64.07,47.67}}},nil,15,nil,nil,894,"A","Herbalism & Alchemy Supplies",128},
[4900] = {'Alchemist Narett',1536,1536,37,37,0,{[15]={{63.94,47.64}}},nil,15,nil,nil,894,"A","Alchemy Trainer",81},
[4901] = {'Sara Pierce',58,58,2,2,0,{[15]={{66.6,45.12}}},nil,15,nil,nil,894,"A",nil,0},
[4902] = {'Mikal Pierce',1604,1604,38,38,0,{[15]={{66.85,45.22}}},nil,15,nil,nil,894,"A",nil,0},
[4921] = {'Guard Byron',1753,1753,40,40,0,{[15]={{66.15,46.07}}},nil,15,{11212,27251},nil,150,"A",nil,3},
[4922] = {'Guard Edward',2769,2769,50,50,0,{[15]={{67.16,46.04}}},nil,15,nil,nil,151,"A",nil,0},
[4923] = {'Guard Jarad',2769,2769,50,50,0,{[15]={{67.43,46.27}}},nil,15,nil,nil,1622,"A",nil,0},
[4924] = {'Combat Master Criton',3398,3398,55,55,0,{[15]={{67.39,46.07}}},nil,15,nil,nil,894,"A",nil,0},
[4926] = {'Krog',1753,1753,40,40,0,{[15]={{36.42,31.88}}},nil,15,{25051,26682,27253,27255,27258,27293,27294,27295,27306},{1251,1263,1268,1269,1272,1273,1323,1443,11200,11201,11204,11206,25051,26682,26701,27229,27254,27257,27259,27260,27261,27292,27293,27294,27297,27309,28554},83,"H",nil,3},
[4941] = {'Caz Twosprocket',1342,1342,35,35,0,{[15]={{64.75,50.43}}},nil,15,{27285},{1319,27284},64,"A","Engineering Trainer",211},
[4942] = {'Test Petition Giver',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","Test",0},
[4943] = {'Mosarn',1003,1003,30,30,0,{[1638]={{54.01,80.77}}},nil,1638,{27292},{1276,27258},83,"H",nil,2},
[4944] = {'Captain Garran Vimes',2769,2769,50,50,0,{[15]={{68.21,48.62}}},nil,15,{27249,27264,27284,27287,27291,27425},{1220,1252,1253,1282,1283,1284,1285,1287,1289,1320,11151,11152,26687,27247,27251,27252,27262,27263,27285,27286,27288,27291,27430},1077,"A",nil,3},
[4945] = {'Goblin Drag Car',1163,1163,32,32,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4946] = {'Gnome Drag Car',1163,1163,32,32,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4947] = {'Theramore Lieutenant',2800,2800,52,52,0,nil,nil,0,nil,nil,11,"A",nil,0},
[4948] = {'Adjutant Tesoran',1342,1342,35,35,0,{[15]={{68.05,48.11}}},nil,15,{27286},{1259,27264},1075,"A",nil,2},
[4949] = {'Thrall',5578000,5578000,73,73,3,nil,nil,0,{7784},{4001,4002,4004,4941,4974,5726,5727,5728,5730,6566,9438,10175,11589,25351},1734,"H","Warchief",3},
[4950] = {'Spot',1342,1342,35,35,0,{[15]={{67.96,46.7}}},nil,15,nil,nil,150,"A",nil,0},
[4951] = {'Theramore Practicing Guard',2138,2138,48,51,0,{[15]={{67.18,47.34},{67.33,47.3}}},nil,15,nil,nil,1096,"A",nil,0},
[4952] = {'Theramore Combat Dummy',1,1,1,1,0,{[15]={{67.19,47.19},{67.26,47.19},{67.33,47.19},{67.19,47.44},{67.34,47.45},{67.26,47.44}}},nil,15,nil,nil,1095,"AH",nil,0},
[4953] = {'Moccasin',8,8,1,1,0,{[8]={{61.36,60.09},{48.17,59.54},{66.8,67.36},{63.03,64.86},{55.75,53.46},{76.14,15.29},{74.72,16.46},{65.08,19.96},{29.47,52.61},{28.46,57.45},{30.14,52.99},{32.7,60.66},{32.96,56.12},{32.01,53.87},{39.42,50.62},{66.96,37.29},{70.9,29.26},{47.98,60.28},{79.89,32.61},{46.32,38.09},{51.21,33.63},{27.24,42.11},{38.91,37.91},{29.54,52.63},{83.26,44.51},{81.02,41.29},{48.19,38.14},{65.74,29.83},{82.6,36.53},{39.6,31.9},{79.64,20.11},{72.86,31.09},{85.27,42.49},{36.32,48.12},{86.07,38.24},{33.84,40.72},{67.95,25.22},{73.96,22.4},{28.29,58.11},{30.26,53.35},{43.27,51.81},{46.54,48.51},{24.01,48.25},{75.87,29.58},{77.72,39.86},{80.65,24.53},{32.84,60.45},{74.28,35.1},{75.84,16.17},{77.01,34.73},{41.68,37.15},{44.11,38.68},{70.9,24.24},{39.28,52.31},{73.92,25.35},{41.01,53.87},{32.15,41.61},{32.77,56.24},{55.69,35.31},{36.48,37.52},{14.4,34.76},{78.01,28.97},{31.87,54.39},{39.36,49.09},{61.84,61.23},{71.7,29.11},{48.32,59.79},{46.95,38.61},{78.23,70.99},{51.11,33.49},{28.09,42.64},{78.91,66.16},{38.83,38.44},{30.14,53.1},{66.99,66.95},{34.7,48.71},{62.68,62.91},{69.76,73.31},{54.15,49.86},{47.67,39.26},{72.72,70.89},{66.28,30.31},{52.79,42.89},{55.52,51.92},{49.34,42.59},{82.22,62.94},{55.72,54.99},{36.69,48.17},{33.44,40.38},{68.33,26.38},{28.55,57.57},{30.34,52.87},{58.41,37.66},{43.38,50.11},{46.75,47.47},{50.25,45},{24.15,47.64},{52.6,38.07},{59.49,46.59},{81.37,70.79},{30.95,60.49},{63.81,31.06},{32.97,49.32},{76.41,78.9},{83.37,66.65},{57.64,50.93},{58.89,53.41},{34.84,51.3},{74.16,72.88},{79.03,77.8},{43.76,39},{39,53.14},{79.22,78.37},{76.2,73.17},{40.26,53.83},{56.85,43.04},{31.64,41.72},{33.05,55.98},{55.57,35.15},{32.56,53.06},{50.41,48.18}},[11]={{55.25,68.54},{23.52,69.78},{33.34,16.01},{47.04,24.28},{19.98,46.22},{18.92,41.44},{52.11,25.06},{16.32,47.25},{14.36,38.23},{29.41,19.44},{22.21,54.56},{65.86,67.52},{59.14,70.17},{34.04,20.46},{57.04,50.37},{59.5,39.91},{32.02,30.58},{28.07,38.63},{15.05,32.94},{27.33,21.83},{53.25,32.58},{29.53,25.66},{22.58,37.18},{64.62,54.63},{41.28,29.21},{65.46,59.97},{58.79,58.33},{28.26,34.33},{21.26,26.1},{61.17,56.31},{23.39,26.67},{30.51,42.07},{19.88,30.9},{27.62,43.64},{51.44,35.08},{34.59,24.04},{56.94,45.95},{27.13,30.41},{22.04,39.77},{44.11,34.75},{20.77,30.24},{23.56,23.66},{17.8,25.8},{62.97,51.12}},[14]={{37.56,36.22},{36.38,30.5},{34.9,32.25},{42.06,33.21},{36.36,29.48},{36.44,35.82},{34.93,29.77},{35.9,37.66},{44.31,33.96},{35.89,38.47},{38.55,49.06},{37.25,36.44},{41.53,37.77},{38.77,47.26},{37.09,45.95},{38.5,41.8},{42.07,41.89},{45.35,42.53},{44.29,43.02},{37.06,50.5},{39.35,48.23},{42.79,46.88},{46.25,42.17},{38.83,44.15},{40.01,44.37},{35.7,52.69},{44.71,44.38},{44.02,46.88},{35.66,39.45},{44.15,34.52},{38.07,50.62},{39.6,37.09},{41.64,42.86},{37.66,42.58},{36.85,40.57},{40.73,39.37},{35.85,37.78},{35.72,39.51},{35.89,38.53},{41.92,45.98},{41.13,42.38},{42.15,47.62},{35.63,41.43},{34.59,44.92},{35.27,43.62},{34.91,43.45},{34.82,29.41}},[17]={{69.49,30.01}},[1637]={{63.18,43.68},{48.68,49.13},{34.16,61.04},{48.61,49.16},{47.9,46.12},{33.05,73.77},{31.94,70.4},{35.9,74.72},{24.4,66.2},{47.18,50.88},{63.02,43.36},{62.76,43.95},{36.46,72.08},{73,37.39},{48.78,46.55}},[4922]={{21.62,18.13},{21.65,16.91},{20.68,16.58}}},nil,8,nil,nil,7,"AH",nil,0},
[4954] = {'Uttnar',1469,1469,36,36,0,{[45]={{69.32,34.79}}},nil,45,nil,nil,29,"H","Butcher",640},
[4955] = {'Theramore Archery Target 1',25,27,1,1,0,{[17]={{70.26,84.09},{71.46,89.39}}},nil,17,nil,nil,151,"A",nil,0},
[4957] = {'Theramore Combat Dummy 4',2200,3200,35,37,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[4958] = {'Haunting Spirit',10,10,20,20,0,{[209]={{-1,-1}}},nil,209,nil,nil,16,nil,nil,0},
[4959] = {'Jorgen',328,328,15,15,0,{[1519]={{76.29,85.12}}},nil,1519,nil,{1241},12,"A",nil,0},
[4960] = {'Bishop DeLavey',1163,1163,32,32,0,{[1519]={{80.2,34.54}}},nil,1519,nil,{1274},12,"A",nil,0},
[4961] = {'Dashel Stonefist',787,787,26,26,0,{[1519]={{74.27,59.17}}},nil,1519,nil,{1246,1447},122,"A",nil,0},
[4962] = {'Tapoke "Slim" Jahn',1279,1279,34,34,0,{[11]={{10.54,60.26}}},nil,11,nil,nil,123,"A",nil,0},
[4963] = {'Mikhail',1003,1003,30,30,0,{[11]={{10.6,60.77}}},nil,11,nil,{1248,1249,1250},12,"A","Bartender",128},
[4964] = {'Commander Samaul',1753,1753,40,40,0,{[15]={{68.02,48.7}}},nil,15,nil,{1264},894,"A",nil,0},
[4965] = {'Pained',2218,2218,45,45,0,{[15]={{66.15,49.05}}},nil,15,nil,nil,1077,"A",nil,0},
[4966] = {'Private Hendel',1342,1342,35,35,0,{[15]={{45.21,24.63}}},nil,15,nil,{1266},1077,"A",nil,0},
[4967] = {'Archmage Tervosh',1604,1604,38,38,0,{[15]={{66.42,49.26}}},{[15]={{{45.17,24.23}}}},15,nil,{1265,1324,7070},1077,"A",nil,1},
[4968] = {'Lady Jaina Proudmoore',54971200,54971200,88,88,1,{[15]={{66.26,49.04}}},nil,15,{27239,27240},{1267,1288,11141,11142,11223,27238,27239,27241,27289},1096,"A","Ruler of Theramore",3},
[4969] = {'Old Town Thug',734,787,25,26,0,nil,nil,0,nil,nil,12,"A",nil,0},
[4970] = {'Defias Agent',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4971] = {'Slim\'s Friend',1015,1015,34,34,0,{[11]={{6.1,61.22},{6.25,61.15},{6.26,61.23},{6.14,61.25},{7.03,62.81},{7.07,62.79},{6.57,62.16},{6.54,62.15},{7.63,62.25},{7.65,62.22}}},nil,11,nil,nil,34,nil,nil,0},
[4972] = {'Kagoro',1753,1753,40,40,0,nil,nil,0,nil,nil,85,"H",nil,0},
[4973] = {'Guard Lasiter',2769,2769,50,50,0,{[15]={{67.75,49.62}}},{[15]={{{67.78,49.69},{67.75,49.62}}}},15,nil,nil,1077,"A",nil,0},
[4974] = {'Aldwin Laughlin',2769,2769,50,50,0,{[1519]={{64.21,77.18}}},nil,1519,nil,nil,12,"A","Guild Master",786433},
[4975] = {'Theramore Archery Target 2',25,27,1,1,0,{[17]={{70.24,83.96}}},nil,17,nil,nil,151,"A",nil,0},
[4976] = {'Elise Laughlin',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Guild Tabard Designer",1},
[4977] = {'Murkshallow Softshell',195,195,24,24,0,{[719]={{-1,-1}}},nil,719,nil,nil,129,nil,nil,0},
[4978] = {'Aku\'mai Servant',2284,2284,24,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4979] = {'Theramore Guard',3696,3696,45,45,0,{[15]={{62.97,49.68},{61.99,50.26},{63.97,44.76},{63.8,44.98},{64.52,45.6},{64.21,45.98},{62,49.68},{65.88,52.04},{62.98,50.26},{63.73,49.78},{71.64,54.26},{71.39,56.55},{65.63,48.61},{66.82,50.1},{69.65,50.06},{64.53,46.09},{64.56,46.05},{67.74,51.02},{67.76,50.94},{67.56,50.85},{67.59,50.8},{68.15,52.62},{65.73,48.46},{64.87,48.57},{71.05,56.04},{64.77,46.95},{71.64,56.15},{65.02,46.59},{69.6,49.79},{65.66,50.49},{68.39,52.21},{70.56,57.17},{71.28,55.65},{68.58,51.62},{69.29,50.16}}},nil,15,nil,nil,150,"A",nil,1},
[4980] = {'Paval Reethe',1110,1110,35,35,0,{[15]={{42.65,38.07}}},nil,15,nil,nil,35,"AH",nil,0},
[4981] = {'Ben Trias',713,713,25,25,0,{[1519]={{66.36,73.51}}},nil,1519,nil,nil,12,"A","Apprentice of Cheese",641},
[4982] = {'Thomas',42,42,1,1,0,{[1519]={{49.88,44.55}}},{[1519]={{{49.83,44.61},{49.79,44.96},{50.14,45.63},{51.93,49.06},{52.51,48.96},{53,50.03},{52.25,50.86},{51.65,49.78},{51.91,49.17},{49.79,44.94},{49.79,44.62},{49.64,44.47},{49.66,44.51}}}},1519,nil,nil,12,"A","Altar Boy",0},
[4983] = {'Ogron',3660,3660,35,35,0,{[15]={{40.96,36.69}}},nil,15,{27261},{27306},232,"H",nil,2},
[4984] = {'Argos Nightwhisper',484,484,20,20,0,{[1519]={{27.86,50.82}}},nil,1519,nil,nil,80,"A",nil,1},
[4985] = {'World Druid Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Druid Trainer",32},
[4986] = {'World Hunter Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Hunter Trainer",32},
[4987] = {'World Mage Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Mage Trainer",32},
[4988] = {'World Paladin Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Paladin Trainer",32},
[4989] = {'World Priest Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Priest Trainer",32},
[4990] = {'World Rogue Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Rogue Trainer",32},
[4991] = {'World Shaman Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Shaman Trainer",32},
[4992] = {'World Warrior Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Warrior Trainer",32},
[4993] = {'World Warlock Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Warlock Trainer",32},
[4994] = {'World Wolf Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Wolf Pet Trainer",0},
[4995] = {'Stockade Guard',3696,3696,45,45,0,nil,nil,0,nil,nil,11,"A",nil,0},
[4996] = {'Injured Stockade Guard',3696,3696,45,45,0,nil,nil,0,nil,nil,11,"A",nil,0},
[4997] = {'World Fishing Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Fishing Trainer",64},
[4998] = {'World Herbalism Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Herbalism Trainer",64},
[4999] = {'World Mining Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Mining Trainer",64},
[5000] = {'World Hunter Beast Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Hunter Beast Trainer",0},
[5001] = {'World Bird Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Bird Pet Trainer",0},
[5002] = {'World Boar Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Boar Pet Trainer",0},
[5003] = {'World Cat Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Cat Pet Trainer",0},
[5004] = {'World Crawler Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Crawler Pet Trainer",0},
[5005] = {'World Crocodile Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Crocodile Pet Trainer",0},
[5006] = {'World Demon Trainer - old',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[5007] = {'World Felhunter Trainer',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","UNUSED",0},
[5008] = {'World Gorilla Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Gorilla Pet Trainer",0},
[5009] = {'World Horse Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Horse Pet Trainer",0},
[5010] = {'World Imp Trainer',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","UNUSED",0},
[5011] = {'World Raptor Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Raptor Pet Trainer",0},
[5012] = {'World Scorpid Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Scorpid Pet Trainer",0},
[5013] = {'World Spider Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Spider Pet Trainer",0},
[5014] = {'World Succubus Trainer',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","UNUSED",0},
[5015] = {'World Tallstrider Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Tallstrider Pet Trainer",0},
[5016] = {'World Voidwalker Trainer',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH","UNUSED",0},
[5017] = {'World Turtle Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Turtle Pet Trainer",0},
[5018] = {'World Portal: Darnassus Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Portal: Darnassus Trainer",0},
[5019] = {'World Portal: Ironforge Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Portal: Ironforge Trainer",0},
[5020] = {'World Portal: Orgrimmar Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Portal: Orgrimmar Trainer",0},
[5021] = {'World Portal: Stormwind Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Portal: Stormwind Trainer",0},
[5022] = {'World Portal: Thunder Bluff Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Portal: Thunder Bluff Trainer",0},
[5023] = {'World Portal: Undercity Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Portal: Undercity Trainer",0},
[5024] = {'World First Aid Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","First Aid Trainer",64},
[5026] = {'World Horse Riding Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Horse Riding Trainer",0},
[5027] = {'World Lockpicking Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Lockpicking Trainer",0},
[5028] = {'World Ram Riding Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Ram Riding Trainer",0},
[5029] = {'World Survival Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Survival Trainer",0},
[5030] = {'World Tiger Riding Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Tiger Riding Trainer",0},
[5031] = {'World Wolf Riding Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Wolf Riding Trainer",0},
[5032] = {'World Alchemy Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Alchemy Trainer",64},
[5033] = {'World Blacksmith Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Blacksmithing Trainer",64},
[5034] = {'World Brewing Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Brewing Trainer",0},
[5035] = {'zzOLDWorld Cartography Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[5036] = {'World Cooking Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Cooking Trainer",64},
[5037] = {'World Engineering Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Engineering Trainer",64},
[5038] = {'World Enchanting Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Enchanting Trainer",64},
[5039] = {'World Warlock Trainer DEPRECATED',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Warlock Trainer",32},
[5040] = {'World Leatherworking Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Leatherworking Trainer",64},
[5041] = {'World Tailoring Trainer',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Tailoring Trainer",64},
[5042] = {'Nurse Lillian',1003,1003,30,30,0,nil,{[1519]={{{52.41,65.94},{52.51,66.11},{52.47,66.15},{52.58,66.41},{52.31,66.73},{52.16,66.45},{52.19,66.45},{52.21,66.5},{52.06,66.22},{52.13,65.73},{52.24,65.58},{52.25,65.6},{52.22,65.59},{51.96,66.5},{51.96,66.52}}}},0,nil,nil,12,"A",nil,0},
[5043] = {'Rioter',480,484,20,20,0,{[1519]={{50.41,66.39},{50.42,66.33},{50.46,66.33},{50.49,66.24}}},nil,1519,nil,nil,17,nil,nil,0},
[5044] = {'Theramore Skirmisher',1469,1469,36,36,0,nil,nil,0,nil,nil,151,"A",nil,0},
[5045] = {'Private Hallan',1469,1469,36,36,0,nil,nil,0,nil,nil,151,"A",nil,0},
[5046] = {'Lieutenant Caldwell',1536,1536,37,37,0,nil,nil,0,nil,nil,151,"A",nil,0},
[5047] = {'Ellaercia',1003,1003,30,30,0,{[1657]={{64.45,37.05}}},nil,1657,nil,nil,80,"A","Guild Tabard Designer",524288},
[5048] = {'Deviate Adder',1668,1668,18,19,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,nil,0},
[5049] = {'Lyesa Steelbrow',713,713,25,25,0,{[1537]={{36.43,85.33}}},nil,1537,nil,nil,55,"A","Tabard Vendor",129},
[5052] = {'Edward Remington',713,713,25,25,0,{[1497]={{69.81,44.28}}},nil,1497,nil,nil,68,"H","Guild Tabard Designer",524416},
[5053] = {'Deviate Crocolisk',449,449,18,19,0,{[718]={{-1,-1}}},nil,718,nil,nil,16,nil,nil,0},
[5054] = {'Krumn',2769,2769,50,50,0,{[1638]={{37.45,63.47}}},nil,1638,nil,nil,104,"H","Guild Master",786433},
[5055] = {'Deviate Lasher',135,135,19,19,0,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,nil,0},
[5056] = {'Deviate Dreadfang',1796,1796,19,19,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,nil,0},
[5057] = {'Theramore Deserter',1220,1220,35,36,0,{[15]={{35.73,53.3},{35.62,54.7},{36.27,53.33},{35.94,53.24},{36.5,53.65},{36.27,54.88},{36.55,54.32},{35.42,54.29},{36.23,54.51},{36.39,54.15},{36.07,53.5},{35.95,54.62},{35.92,54.73},{36.34,53.73},{34.71,54.66},{34.41,54.75},{34.52,53.7},{35.11,52.91},{35.28,53.52},{35.62,53.92},{35.28,53.15},{35.49,52.75},{35.68,54.34},{35.16,54.17},{35.78,53.59},{35.89,54.22},{35.85,53.86},{36.06,53.87}}},nil,15,nil,nil,1883,nil,nil,0},
[5058] = {'Wolfguard Worg',494,494,20,20,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5059] = {'Galthogran the Callous',25,27,1,1,0,nil,nil,0,nil,{1277},35,"AH",nil,0},
[5060] = {'World Banker',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Banker",1},
[5061] = {'World Guild Tabard Vendor',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Guild Tabard Vendor",0},
[5062] = {'World Reagent Vendor',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Reagents/Totems Vendor",0},
[5063] = {'Pat\'s Test Kobold',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[5064] = {'World Trade Supplies',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Trade Supplies",0},
[5081] = {'Connor Rivers',713,713,25,25,0,{[1519]={{51.12,95.52}}},nil,1519,nil,nil,12,"A","Apprentice Chef",128},
[5082] = {'Vincent Hyal',1003,1003,30,30,0,{[11]={{8.68,61.58}}},nil,11,nil,{1301,27250},12,"A",nil,0},
[5083] = {'Paymaster Lendry',484,484,20,20,0,{[15]={{67.88,48.24}}},nil,15,nil,{1302},894,"A","Banker",131072},
[5084] = {'Ironforge Zinn',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[5085] = {'Sentry Point Guard',1221,1221,32,33,0,{[15]={{59.9,40.81},{60.43,40.7},{59.99,40.92},{59.79,41.22},{59.8,41.15},{60.24,40.12},{59.66,40.93},{59.75,41.03},{59.84,41.33},{60.1,40.87}}},nil,15,nil,nil,150,"A",nil,0},
[5086] = {'Captain Wymor',1342,1342,34,34,0,{[15]={{59.67,41.07}}},nil,15,{27234,27235},{11136,11137,27214,27234},11,"A",nil,3},
[5087] = {'Do\'gol',1003,1003,30,30,0,{[15]={{36.53,30.79}}},nil,15,{27256,27257},{1321,1322,27255,27256},83,"H",nil,2},
[5088] = {'Falgran Hastil',1604,1604,38,38,0,{[15]={{67.65,48.03}}},nil,15,nil,{1390},35,"AH",nil,0},
[5089] = {'Balos Jacken',1536,1536,37,37,0,{[15]={{36.09,54.31}}},nil,15,{27288},{1286,27287},14,nil,nil,2},
[5090] = {'Combat Master Szigeti',3398,3398,55,55,0,{[15]={{67.21,46.35}}},nil,15,nil,nil,894,"A",nil,0},
[5091] = {'Guard Kahil',2769,2769,50,50,0,{[15]={{67.15,46.08}}},nil,15,nil,nil,151,"A",nil,0},
[5092] = {'Guard Lana',2769,2769,50,50,0,{[15]={{67.53,46.23}}},nil,15,nil,nil,151,"A",nil,0},
[5093] = {'Guard Narrisha',2769,2769,50,50,0,{[15]={{67.16,46.13}}},nil,15,nil,nil,151,"A",nil,0},
[5094] = {'Guard Tark',2769,2769,50,50,0,{[15]={{67.52,46.19}}},nil,15,nil,nil,151,"A",nil,0},
[5095] = {'Captain Andrews',3189,3189,53,53,0,{[15]={{67.5,46.32}}},nil,15,nil,nil,894,"A","Red Team Captain",0},
[5096] = {'Captain Thomas',3189,3189,53,53,0,{[15]={{67.17,45.99}}},nil,15,nil,nil,894,"A","Blue Team Captain",0},
[5097] = {'Lupine Delusion',484,521,20,20,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5099] = {'Soleil Stonemantle',5544,5544,45,45,0,{[1537]={{36.82,61.86}}},nil,1537,nil,nil,55,"A","Banker",131072},
[5100] = {'Fillius Fizzlespinner',1003,1003,30,30,0,{[1537]={{38.14,73.7}}},nil,1537,nil,nil,875,"A","Trade Supplies",128},
[5101] = {'Bryllia Ironbrand',1003,1003,30,30,0,{[1537]={{39.23,74.46}}},nil,1537,nil,nil,55,"A","General Goods",640},
[5102] = {'Dolman Steelfury',1003,1003,30,30,0,{[1537]={{35.8,65.72}}},nil,1537,nil,nil,55,"A","Weapon Merchant",4224},
[5103] = {'Grenil Steelfury',1003,1003,30,30,0,{[1537]={{35.98,65.37}}},nil,1537,nil,nil,55,"A","Weapon Merchant",4224},
[5104] = {'Laene Thundershot',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Gun Trainer",0},
[5105] = {'Gilbin',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH","Light Armor Merchant",0},
[5106] = {'Bromiir Ormsen',1003,1003,30,30,0,{[1537]={{31.72,58.27}}},nil,1537,nil,nil,55,"A","Heavy Armor Merchant",4224},
[5107] = {'Mangorn Flinthammer',1003,1003,30,30,0,{[1537]={{31.95,57.93}}},nil,1537,nil,nil,55,"A","Heavy Armor Merchant",4224},
[5108] = {'Raena Flinthammer',1003,1003,30,30,0,{[1537]={{32.62,57.39}}},nil,1537,nil,nil,55,"A","Light Armor Merchant",4224},
[5109] = {'Myra Tyrngaarde',1003,1003,30,30,0,{[1537]={{29.9,67.86}}},{[1537]={{{29.52,66.36},{33.64,74},{31.59,78.42},{27.09,70.87},{23.29,62.78},{26.8,60.44}}}},1537,nil,nil,55,"A","Bread Vendor",640},
[5110] = {'Barim Jurgenstaad',1003,1003,30,30,0,{[1537]={{19.19,56.1}}},nil,1537,nil,nil,55,"A","Reagents",2176},
[5111] = {'Innkeeper Firebrew',1003,1003,30,30,0,{[1537]={{18.15,51.45}}},nil,1537,{8353},{8353},55,"A","Innkeeper",66179},
[5112] = {'Gwenna Firebrew',1003,1003,30,30,0,{[1537]={{18.64,51.76}}},nil,1537,nil,nil,55,"A","Barmaid",640},
[5113] = {'Kelv Sternhammer',2218,2218,45,45,0,{[1537]={{70.34,90.65}}},nil,1537,nil,nil,55,"A","Warrior Trainer",49},
[5114] = {'Bilban Tosslespanner',2218,2218,45,45,0,{[1537]={{65.9,88.41}}},nil,1537,nil,nil,875,"A","Warrior Trainer",49},
[5115] = {'Daera Brightspear',4120,4120,60,60,0,{[1537]={{70.97,89.8}}},nil,1537,{27266,28260},nil,55,"A","Hunter Trainer",51},
[5116] = {'Olmin Burningbeard',2769,2769,50,50,0,{[1537]={{70.89,83.61}}},nil,1537,nil,nil,55,"A","Hunter Trainer",49},
[5117] = {'Regnus Thundergranite',1753,1753,40,40,0,{[1537]={{69.87,82.9}}},nil,1537,nil,nil,55,"A","Hunter Trainer",49},
[5118] = {'Brogun Stoneshield',3874500,3874500,85,85,1,{[1657]={{56.7,47.55}}},nil,1657,nil,nil,1216,"A","Alterac Valley Battlemaster",1048577},
[5119] = {'Hegnar Swiftaxe',1003,1003,30,30,0,{[1537]={{62.19,88.16}}},nil,1537,nil,nil,55,"A","Axe Merchant",4224},
[5120] = {'Brenwyn Wintersteel',1003,1003,30,30,0,{[1537]={{62.37,88.68}}},nil,1537,nil,nil,55,"A","Blade Merchant",4224},
[5121] = {'Kelomir Ironhand',1003,1003,30,30,0,{[1537]={{62.55,88.71}}},nil,1537,nil,nil,55,"A","Maces & Staves",4224},
[5122] = {'Skolmin Goldfury',1003,1003,30,30,0,{[1537]={{71.76,66.7}}},nil,1537,nil,nil,55,"A","Bow Merchant",4224},
[5123] = {'Bretta Goldfury',1003,1003,30,30,0,{[1537]={{72.21,65.24}}},nil,1537,nil,nil,55,"A","Gun Merchant",4224},
[5124] = {'Sognar Cliffbeard',1003,1003,30,30,0,{[1537]={{56.84,78.04}}},{[1537]={{{57.01,84.48},{58.71,84.94},{61,82.91},{63.42,79.94},{65.75,77.19},{67.79,74.66},{69.26,72.34},{68.9,68.93},{67.26,67.48},{65.88,67.79},{64.1,70.63},{62.2,71.72},{60.66,73.63},{59.49,76.9},{57.61,78.5},{56.56,82.16}}}},1537,nil,nil,55,"A","Meat Vendor",640},
[5125] = {'Dolkin Craghelm',1003,1003,30,30,0,{[1537]={{53.85,87.89}}},nil,1537,nil,nil,55,"A","Mail Armor Merchant",4224},
[5126] = {'Olthran Craghelm',1003,1003,30,30,0,{[1537]={{54.86,87.41}}},nil,1537,nil,nil,55,"A","Heavy Armor Merchant",4224},
[5127] = {'Fimble Finespindle',1342,1342,35,35,0,{[1537]={{40.24,33.68}}},nil,1537,nil,nil,875,"A","Leatherworking Trainer",81},
[5128] = {'Bombus Finespindle',1003,1003,30,30,0,{[1537]={{39.62,34.49}}},nil,1537,nil,nil,55,"A","Leatherworking Supplies",128},
[5129] = {'Lissyphus Finespindle',1003,1003,30,30,0,{[1537]={{54.7,87.97}}},nil,1537,nil,nil,55,"A","Light Armor Merchant",4224},
[5130] = {'Jondor Steelbrow',4120,4120,60,60,0,{[1537]={{35.9,84.71}}},nil,1537,nil,nil,55,"A","Guild Master",786433},
[5132] = {'Pithwick',1003,1003,30,30,0,{[1537]={{38.02,74.74}}},nil,1537,nil,nil,875,"A","Bag Vendor",128},
[5133] = {'Harick Boulderdrum',1003,1003,30,30,0,{[1537]={{23.13,15.94}}},nil,1537,nil,nil,55,"A","Wands Merchant",4224},
[5134] = {'Jonivera Farmountain',25330,25330,60,60,0,{[2597]={{-1,-1}}},nil,2597,nil,nil,1217,"A","General Goods",640},
[5135] = {'Svalbrad Farmountain',25330,25330,60,60,0,{[2597]={{-1,-1}}},nil,2597,nil,nil,1217,"A","Trade Goods",128},
[5137] = {'Reyna Stonebranch',1342,1342,35,35,0,{[1537]={{55.9,59.13}}},nil,1537,nil,nil,55,"A","Herbalism Trainer",81},
[5138] = {'Gwina Stonebranch',1003,1003,30,30,0,{[1537]={{55.08,59.51}}},nil,1537,nil,nil,55,"A","Herbalism Supplies",128},
[5139] = {'Kurdrum Barleybeard',25330,25330,60,60,0,{[2597]={{-1,-1}}},nil,2597,nil,nil,1217,"A","Reagents & Poison Supplies",3200},
[5140] = {'Edris Barleybeard',1003,1003,30,30,0,{[1537]={{72.25,75.79}}},nil,1537,nil,nil,55,"A","Barmaid",640},
[5141] = {'Theodrus Frostbeard',4120,4120,60,60,0,{[1537]={{24.08,8.41}}},nil,1537,nil,nil,55,"A","Priest Trainer",49},
[5142] = {'Braenna Flintcrag',2769,2769,50,50,0,{[1537]={{24.42,9.17}}},nil,1537,nil,nil,55,"A","Priest Trainer",49},
[5143] = {'Toldren Deepiron',1753,1753,40,40,0,{[1537]={{25.21,10.76}}},nil,1537,nil,nil,55,"A","Priest Trainer",49},
[5144] = {'Bink',1753,1753,40,40,0,{[1537]={{27.25,8.3}}},nil,1537,nil,{1879,1880},875,"A","Mage Trainer",51},
[5145] = {'Juli Stormkettle',2769,2769,50,50,0,{[1537]={{26.3,6.77}}},nil,1537,nil,nil,875,"A","Mage Trainer",51},
[5146] = {'Nittlebur Sparkfizzle',4120,4120,60,60,0,{[1537]={{25.93,6.17}}},nil,1537,{27271,28263},nil,55,"A","Mage Trainer",51},
[5147] = {'Valgar Highforge',4120,4120,60,60,0,{[1537]={{23.7,5.1}}},nil,1537,{27265,28268},nil,55,"A","Paladin Trainer",51},
[5148] = {'Beldruk Doombrow',2769,2769,50,50,0,{[1537]={{24.55,4.47}}},nil,1537,nil,nil,55,"A","Paladin Trainer",49},
[5149] = {'Brandur Ironhammer',2769,2769,50,50,0,{[1537]={{23.13,6.14}}},nil,1537,nil,nil,55,"A","Paladin Trainer",49},
[5150] = {'Nissa Firestone',1342,1342,35,35,0,{[1537]={{55.09,58.26}}},nil,1537,{6625},nil,55,"A","First Aid Trainer",83},
[5151] = {'Ginny Longberry',1003,1003,30,30,0,{[1537]={{31.32,27.79}}},nil,1537,nil,nil,875,"A","Reagents",2176},
[5152] = {'Bingus',1003,1003,30,30,0,{[1537]={{22.77,15.92}}},nil,1537,nil,nil,875,"A","Weapon Merchant",4224},
[5153] = {'Jormund Stonebrow',1342,1342,35,35,0,{[1537]={{43.15,29.36}}},nil,1537,nil,nil,55,"A","Tailoring Trainer",81},
[5154] = {'Poranna Snowbraid',1003,1003,30,30,0,{[1537]={{42.94,28.31}}},nil,1537,nil,nil,55,"A","Tailoring Supplies",128},
[5155] = {'Ingrys Stonebrow',1003,1003,30,30,0,{[1537]={{38.25,5.15}}},nil,1537,nil,nil,55,"A","Cloth Armor Merchant",4224},
[5156] = {'Maeva Snowbraid',1003,1003,30,30,0,{[1537]={{38.68,5.99}}},nil,1537,nil,nil,55,"A","Robe Merchant",4224},
[5157] = {'Gimble Thistlefuzz',1342,1342,35,35,0,{[1537]={{60.11,45.32}}},nil,1537,nil,nil,875,"A","Enchanting Trainer",81},
[5158] = {'Tilli Thistlefuzz',1003,1003,30,30,0,{[1537]={{61.03,44}}},nil,1537,nil,nil,875,"A","Enchanting Supplies",128},
[5159] = {'Daryl Riknussun',1342,1342,35,35,0,{[1537]={{60.08,36.43}}},nil,1537,{6612,29351,29352,29353,29355,29356},{29351,29352,29353,29355,29356},55,"A","Cooking Trainer",83},
[5160] = {'Emrul Riknussun',1003,1003,30,30,0,{[1537]={{59.88,37.37}}},nil,1537,nil,nil,55,"A","Cooking Supplies",128},
[5161] = {'Grimnur Stonebrand',1342,1342,35,35,0,{[1537]={{48.07,6.91}}},nil,1537,{6609,29342,29343,29344,29347,29350},{29342,29343,29344,29350},55,"A","Fishing Trainer",83},
[5162] = {'Tansy Puddlefizz',1003,1003,30,30,0,{[1537]={{48.18,6.51}}},nil,1537,nil,nil,875,"A","Fishing Supplies",128},
[5163] = {'Burbik Gearspanner',1003,1003,30,30,0,{[1537]={{46.4,26.88}}},nil,1537,nil,nil,875,"A","Trade Supplies",128},
[5164] = {'Grumnus Steelshaper',4120,4120,60,60,0,{[1537]={{49.96,42.81}}},nil,1537,nil,{5283},55,"A","Blacksmithing Trainer",83},
[5165] = {'Hulfdan Blackbeard',4120,4120,60,60,0,{[1537]={{51.96,14.84}}},nil,1537,{27267,28262},{2218,2239,2299},55,"A","Rogue Trainer",51},
[5166] = {'Ormyr Flinteye',2769,2769,50,50,0,{[1537]={{52.89,15.01}}},nil,1537,nil,nil,55,"A","Rogue Trainer",49},
[5167] = {'Fenthwick',1753,1753,40,40,0,{[1537]={{51.5,15.33}}},nil,1537,nil,nil,875,"A","Rogue Trainer",49},
[5169] = {'Tynnus Venomsprout',1003,1003,30,30,0,{[1537]={{52.95,13.71}}},nil,1537,nil,nil,875,"A","Shady Dealer",1152},
[5170] = {'Hjoldir Stoneblade',1003,1003,30,30,0,{[1537]={{44.99,6.79}}},nil,1537,nil,nil,55,"A","Blade Merchant",4224},
[5171] = {'Thistleheart',1753,1753,40,40,0,{[1537]={{51.03,6.5}}},nil,1537,nil,nil,55,"A","Warlock Trainer",49},
[5172] = {'Briarthorn',2769,2769,50,50,0,{[1537]={{50.35,5.66}}},nil,1537,nil,nil,875,"A","Warlock Trainer",49},
[5173] = {'Alexander Calder',4120,4120,60,60,0,{[1537]={{50.08,7.45}}},nil,1537,{27272,28259},{32307,32310},55,"A","Warlock Trainer",51},
[5174] = {'Springspindle Fizzlegear',2218,2218,45,45,0,{[1537]={{68.46,43.54}}},nil,1537,nil,{29475},55,"A","Engineering Trainer",19},
[5175] = {'Gearcutter Cogspinner',1003,1003,30,30,0,{[1537]={{67.84,42.5}}},nil,1537,nil,nil,875,"A","Engineering Supplies",128},
[5177] = {'Tally Berryfizz',1342,1342,35,35,0,{[1537]={{66.62,55.69}}},nil,1537,nil,{29067,29481,29482},875,"A","Alchemy Trainer",17},
[5178] = {'Soolie Berryfizz',1003,1003,30,30,0,{[1537]={{66.23,54.52}}},nil,1537,nil,nil,875,"A","Alchemy Supplies",128},
[5184] = {'Theramore Sentry',1403,1403,35,36,0,{[15]={{46.93,49.67},{46.69,50.04},{47.05,50.11},{46.7,49.89},{45.55,50.47},{46.71,49.54},{46.72,23.41},{46.99,24.08}}},nil,15,nil,nil,150,"A",nil,0},
[5185] = {'Hammerhead Shark',2097,2097,25,25,1,{[267]={{49.1,89.51}}},nil,267,nil,nil,16,nil,nil,0},
[5186] = {'Basking Shark',5778,5778,41,42,1,nil,nil,0,nil,nil,16,nil,nil,0},
[5187] = {'Southsea Cannon',5000,5000,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[5188] = {'Garyl',1003,1003,30,30,0,{[1637]={{47.61,74.76}}},nil,1637,nil,nil,29,"H","Tabard Vendor",129},
[5189] = {'Thrumn',713,713,25,25,0,{[1638]={{37.78,63.18}}},nil,1638,nil,nil,104,"H","Tabard Vendor",129},
[5190] = {'Merill Pleasance',713,713,25,25,0,{[1497]={{69.33,44.82}}},nil,1497,nil,nil,68,"H","Tabard Vendor",129},
[5191] = {'Shalumon',713,713,25,25,0,{[1657]={{64.58,38.1}}},nil,1657,nil,nil,80,"A","Tabard Vendor",129},
[5193] = {'Rebecca Laughlin',713,713,25,25,0,{[1519]={{64.05,77.42}}},nil,1519,nil,nil,12,"A","Tabard Designer",524417},
[5194] = {'Black Riding Wolf',413,413,10,10,0,nil,nil,0,nil,nil,1074,"H",nil,0},
[5195] = {'Brown Riding Wolf',198,198,10,10,0,{[1637]={{61.76,35.82}}},nil,1637,nil,nil,35,"AH",nil,0},
[5196] = {'Gray Riding Wolf',413,413,10,10,0,nil,nil,0,nil,nil,1074,"H",nil,0},
[5197] = {'Red Riding Wolf',413,413,10,10,0,nil,nil,0,nil,nil,1074,"H",nil,0},
[5198] = {'Arctic Riding Wolf',198,198,10,10,0,{[618]={{58.83,50.21}}},nil,618,nil,nil,35,"AH",nil,0},
[5199] = {'Medic Tamberlyn',2980,2980,51,51,0,{[15]={{67.3,45.89}}},nil,15,nil,nil,894,"A",nil,0},
[5200] = {'Medic Helaina',2980,2980,51,51,0,{[15]={{67.35,46.41}}},nil,15,nil,nil,894,"A",nil,0},
[5201] = {'Pat\'s Test Human',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[5202] = {'Archery Target',42,42,1,1,0,{[15]={{68.22,49.28},{68.19,49.44},{68.28,49.45},{68.11,49.27}},[495]={{76.52,27.23},{76.24,27.42},{76.38,27.32}},[3703]={{53.71,62.92},{53.44,62.97},{53.96,62.93}}},nil,15,nil,nil,168,"AH",nil,0},
[5204] = {'Apothecary Zinge',950,950,29,29,0,{[1497]={{50.14,67.97}}},nil,1497,nil,{238,864,1359,8979},68,"H","Royal Apothecary Society",0},
[5224] = {'Murk Slitherer',2300,2300,45,46,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5225] = {'Murk Spitter',2292,2292,51,52,0,{[8]={{76.73,43.13},{77.17,40.43},{78,40.96},{77.72,42.95},{77.65,42.94},{76.71,42.96},{76.65,42.65},{76.15,42.39},{76.07,42.35}}},nil,8,nil,nil,14,nil,nil,0},
[5226] = {'Murk Worm',5970,6186,47,48,1,nil,nil,0,nil,nil,14,nil,nil,0},
[5228] = {'Saturated Ooze',5970,6186,47,48,1,nil,nil,0,nil,nil,14,nil,nil,0},
[5229] = {'Gordunni Ogre',1829,1902,40,41,0,nil,nil,0,nil,nil,45,nil,nil,0},
[5231] = {'Gordunni Enforcer',5000,5000,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[5232] = {'Gordunni Brute',1981,2059,42,43,0,nil,nil,0,nil,nil,45,nil,nil,0},
[5234] = {'Gordunni Mauler',1336,1336,37,37,0,{[357]={{62.07,71.06},{61.48,72.97},{62.83,71.29},{61.08,73.7},{62.02,68.76},{61.16,71.41},{57.34,71.09},{60.42,73.87},{62.06,67.4},{58.1,69.98},{57.46,69.69},{61.28,72.23},{61.99,72.17},{62.86,69.45},{61.92,73.44},{62.14,68.51},{58.7,65.04},{59.03,64.98},{59.48,64.5},{58.1,66.43},{60.47,64.66},{61.08,69.28},{60.41,67.89},{60.46,69.46},{59.2,70.46},{60.83,66.88},{59.66,56.24},{60.94,58.45},{61.47,55.51},{61.58,54.43},{60.36,62.66},{60.83,56.78},{61.37,54.92},{61.8,55.05}}},nil,357,nil,nil,45,nil,nil,0},
[5235] = {'Fungal Ooze',5400,5600,45,46,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5236] = {'Gordunni Shaman',1093,1093,37,37,0,{[357]={{59.5,71.6},{62.05,73.13},{60.66,73.05},{61.45,69.28},{60.39,72.43},{61.46,70.67},{57.27,72.57},{62.23,69.56},{61.92,73.48},{62.49,69.07},{60.99,67.86},{60.13,70.05},{60,67.43},{59.53,68.45},{58.43,67.62},{58.44,67.86},{59.34,65.67},{61.04,69.03},{59.95,65.42},{62.14,68.68},{63.02,67.81},{62.85,68.56},{59.62,68.65},{61.9,53.91},{61.35,54.92},{59.5,62.1},{61.59,54.51},{61.1,57.8},{60.81,55.2}}},nil,357,nil,nil,45,nil,nil,0},
[5237] = {'Gordunni Ogre Mage',1522,1585,41,42,0,nil,nil,0,nil,nil,45,nil,nil,0},
[5238] = {'Gordunni Battlemaster',2310,2399,45,46,0,nil,nil,0,nil,nil,45,nil,nil,0},
[5239] = {'Gordunni Mage-Lord',1618,1679,45,46,0,nil,nil,0,nil,nil,45,nil,nil,0},
[5240] = {'Gordunni Warlock',970,970,37,37,0,{[357]={{62.93,69.03},{62.45,73.79},{62.92,73.07},{62.6,71.91},{60.74,72.16},{59.32,64.42},{59.02,68.09},{62.41,68.08},{60.41,54.46},{60.73,66.6},{59.45,57.02},{60.51,58.81},{59.7,57.21},{59.21,63.79},{59.83,63.68},{59.92,62.57},{60,62.57},{58.87,63.08},{60.93,56.11},{60.81,55.17},{61.92,53.92},{60.41,54.46},{61.1,55.44},{61.46,55.43},{61.36,56.17}}},nil,357,nil,nil,45,nil,nil,0},
[5241] = {'Gordunni Warlord',2399,2488,46,47,0,nil,nil,0,nil,nil,45,nil,nil,0},
[5243] = {'Cursed Atal\'ai',2452,2452,53,53,0,{[8]={{79.89,45.37},{73.65,48.33},{72.43,49.15},{73.79,49.34}}},nil,8,nil,nil,37,nil,nil,0},
[5244] = {'Zukk\'ash Stinger',1395,1395,38,39,0,{[357]={{77.14,65.01},{78.52,64.19},{78.58,63.69},{73.37,65.13},{73.68,63.07},{77.29,62.52},{78.61,63.8},{77.46,62.05},{74.02,62.79},{72.22,63.98}}},nil,357,nil,nil,310,nil,nil,0},
[5245] = {'Zukk\'ash Wasp',1459,1459,38,39,0,{[357]={{72.7,64.17},{73.11,60.58},{72.53,62.85},{76.59,60.08},{76.06,59.24},{75.69,60.65},{75.6,61.92},{75.59,58.47},{73.33,62.17},{74.58,59.8},{74.3,60.77}}},nil,357,nil,nil,310,nil,nil,0},
[5246] = {'Zukk\'ash Worker',1459,1459,38,39,0,{[357]={{76.74,63.09},{75.76,62.98},{72.79,61.22},{75.13,61.76},{74.33,63.31},{75.55,59.57},{73.53,61.26},{74.22,62.11}}},nil,357,nil,nil,310,nil,nil,0},
[5247] = {'Zukk\'ash Tunneler',1459,1459,38,39,0,{[357]={{76.54,66.61},{77.88,64.73},{74.46,64.75},{74.28,65.08},{71.85,63.48},{74.55,65.11},{77.31,64.27},{77.19,65.33},{76.53,66.12},{76.76,66.38},{78.98,62.64},{78.65,64.38},{72.77,64.61},{73.6,64.57},{78.41,63.07},{77.96,62.79},{78.29,62.48},{77.42,62.05},{77.1,62.89},{78.2,63.93},{77.73,63.34},{72.31,63.61},{72.02,64},{74.29,62.24},{74.55,62.08},{73.56,63.53},{73.7,62.81},{74.28,61.76}}},nil,357,nil,nil,310,nil,nil,0},
[5249] = {'Woodpaw Mongrel',1395,1395,38,38,0,{[357]={{76.21,53.96},{74.55,46.08},{69.74,50.87},{70.36,53.92},{70.33,51.35},{71.96,37.61},{72.87,38.59},{71.87,37.35},{69.57,53.67},{73.3,35.56},{70.84,50.59},{75.57,54.33},{74.96,53.4},{75.13,54.08},{75.72,53.22},{72.48,37.15}}},nil,357,nil,nil,61,nil,nil,0},
[5251] = {'Woodpaw Trapper',1395,1395,38,38,0,{[357]={{69.82,51.13},{71.62,54.17},{76.2,54.15},{76.93,54.21},{74.98,46.18},{75.09,46.18},{76.88,54.07},{70.48,52.25},{71.06,52.98},{73.14,36.41},{72.6,35.65},{71.73,35.45},{72.87,39.87},{69.32,51.02},{72.97,37.63},{74.32,43.93},{75.51,55.12},{74.51,43.76}}},nil,357,nil,nil,61,nil,nil,0},
[5253] = {'Woodpaw Brute',1395,1395,38,38,0,{[357]={{71.5,54.16},{71.94,53.82},{71.17,51.83},{71.13,54.62},{71.99,55.06},{69.74,50.27},{72.62,36.13},{73.44,39.18},{73.34,37.03},{73.82,37.32},{72.3,37.7},{69.56,52.32},{70.41,53.1},{70.57,53.38},{75.59,53.58},{75.44,54.84},{74.12,45.45}}},nil,357,nil,nil,61,nil,nil,0},
[5254] = {'Woodpaw Mystic',1135,1135,38,38,0,{[357]={{83.2,46.28},{83.09,46.51},{68.56,54.42},{69.1,55.95},{68.93,52.82},{73.04,56.85},{73.06,56.46},{71.58,56.1},{73.27,56.19},{71.74,56.74},{72.22,55.88},{72.23,57.32},{70.52,57.01},{71.14,57.48},{70.06,56.59},{69.96,55.85},{75.59,56.13},{74.46,56.89}}},nil,357,nil,nil,61,nil,nil,0},
[5255] = {'Woodpaw Reaver',1395,1395,38,38,0,{[357]={{68.79,55.73},{83.29,46.6},{68.56,53.8},{68.6,56.59},{68.16,57.44},{68.51,55.76},{71.23,56.51},{69.28,56.44},{68.66,54.96},{68.98,54.42},{71.57,55.87},{69.93,54.81},{69.35,55},{75.61,56.33},{74.07,57.52},{74.39,55.07},{75.35,55.68},{72.81,56.34},{72.86,55.25},{72.85,57.26},{72.42,56.75},{72.39,56.54}}},nil,357,nil,nil,61,nil,nil,0},
[5256] = {'Atal\'ai Warrior',6186,6600,48,48,1,nil,nil,0,nil,nil,14,nil,nil,0},
[5258] = {'Woodpaw Alpha',1459,1459,39,39,0,{[357]={{65.65,52.72},{65.74,52.6},{66.31,50.98},{65.46,52.01},{65.16,51.96},{65.3,51.87},{65.15,52.67},{65.03,53.84},{65.02,53.17},{66,52.78},{65.9,51.66},{67.32,55.68},{67.61,53.06},{66.05,52.09},{66.41,51.57},{66.08,51.55}}},nil,357,nil,nil,61,nil,nil,0},
[5259] = {'Atal\'ai Witch Doctor',4776,4950,47,48,1,nil,nil,0,nil,nil,14,nil,nil,0},
[5260] = {'Groddoc Ape',1277,1277,36,37,0,{[357]={{69.19,52.28},{68.16,51.88},{73.15,51.24},{71.72,50.96},{73.68,51.89},{72.36,50.69},{74.64,51.5},{68.2,52.91},{68.3,50.8},{72.89,49.47},{75.32,52.42},{71.79,49.81},{73.43,48.45},{74.21,52.77},{74.99,49.37},{74.56,50.52},{73.46,49.4},{73.88,50.43},{70.44,49.95},{74.63,53.54},{74.12,52.7}}},nil,357,nil,nil,72,nil,nil,0},
[5261] = {'Enthralled Atal\'ai',3066,3066,52,53,0,{[8]={{80.09,44.14},{72.74,48.02},{74.73,48.66},{74.14,48.67},{72.36,49},{74.33,49.71},{73.03,49.31}}},nil,8,nil,nil,37,nil,nil,0},
[5262] = {'Groddoc Thunderer',2672,2769,49,50,0,nil,nil,0,nil,nil,72,nil,nil,0},
[5263] = {'Mummified Atal\'ai',3066,3066,52,53,0,{[8]={{78,40.96},{80.14,44.01},{79.89,45.37},{79.27,48.64},{78.08,40.76},{77.84,41.69},{79.37,48.69},{79.65,47.07},{76.38,39.95},{76.28,40.98},{76.73,43.13}}},nil,8,nil,nil,37,nil,nil,0},
[5264] = {'Groddoc Chestpounder',1,1,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[5267] = {'Unliving Atal\'ai',6100,6186,47,48,1,nil,nil,0,nil,nil,14,nil,nil,0},
[5268] = {'Ironfur Bear',1336,1336,36,37,0,{[357]={{53.54,50.24},{55.08,52.76},{79.64,47.07},{80.85,46.56},{81.85,45.5},{81.2,45.82},{68.68,45.38},{56.77,60.86},{56.49,59.34},{58.53,55.29},{83.23,45.89},{56.51,58.43},{61.63,62.06},{58.38,60.84},{69.49,42.6},{70.56,37.25},{71.18,46.82},{71.74,47.01},{67.96,47.72},{69.74,47.92},{53.53,50.22},{55.02,49.97},{56.54,49.33},{61.23,50.98},{60.26,52.04},{54.93,53.04},{72.38,43.57},{71.86,41.31},{70.31,41.43},{72.74,46.29},{61.16,60.64},{60.11,59.82},{58.03,57.38},{59.17,59.39},{64.54,48.98},{65.59,47.62},{59.98,54.28},{59.98,54.88},{59.67,50.66},{57,49.94},{58.13,50.89},{56.9,48.29},{56.93,46.57},{68.41,48.85}}},nil,357,nil,nil,44,nil,nil,0},
[5269] = {'Atal\'ai Priest',2452,2452,53,53,0,{[8]={{79.51,47.16},{72.61,48.06}}},nil,8,nil,nil,37,nil,nil,0},
[5270] = {'Atal\'ai Corpse Eater',9812,9812,53,53,1,{[1477]={{-1,-1}}},nil,1477,nil,nil,37,nil,nil,0},
[5271] = {'Atal\'ai Deathwalker',8104,8104,53,54,1,{[1477]={{-1,-1}}},nil,1477,nil,nil,37,nil,nil,0},
[5272] = {'Grizzled Ironfur Bear',2138,2218,44,45,0,nil,nil,0,nil,nil,44,nil,nil,0},
[5273] = {'Atal\'ai High Priest',7092,7092,53,54,1,{[1477]={{-1,-1}}},nil,1477,nil,nil,37,nil,nil,0},
[5274] = {'Ironfur Patriarch',2578,2672,48,49,0,nil,nil,0,nil,nil,44,nil,nil,0},
[5276] = {'Sprite Dragon',1990,2215,35,39,0,nil,nil,0,nil,nil,93,nil,nil,0},
[5277] = {'Nightmare Scalebane',10132,10132,54,54,1,{[1477]={{-1,-1}}},nil,1477,nil,nil,50,nil,nil,0},
[5278] = {'Sprite Darter',1093,1093,37,37,0,{[357]={{74.49,40.94},{74.46,39.56},{73.05,41.91},{69.36,44.93},{70.89,47.78},{72.08,47.73},{70.94,39.15},{69.52,43.46},{70.89,42},{70.86,43.48},{71.79,42.12},{72.31,41.17},{71.36,40.74},{73.14,40.47},{71.65,43.64},{72.7,43.04},{70.48,45.33},{69.93,46.45},{72.15,45.67},{70.96,45.84}}},nil,357,nil,nil,534,"A",nil,0},
[5280] = {'Nightmare Wyrmkin',8104,8104,53,54,1,{[1477]={{-1,-1}}},nil,1477,nil,nil,50,nil,nil,0},
[5283] = {'Nightmare Wanderer',10132,10132,53,54,1,{[1477]={{-1,-1}}},nil,1477,nil,nil,50,nil,nil,0},
[5286] = {'Longtooth Runner',1277,1277,36,36,0,{[357]={{54.59,52.15},{66.66,48.21},{26.98,44},{26.35,46.18},{26.6,47.55},{29.6,47.45},{29.08,45.75},{32.58,51.3},{32.74,47.13},{28.15,47.92},{29.82,49.59},{27.59,46.36},{70.04,42.96},{70.71,44.35},{31.16,50.82},{32.28,49.44},{25.4,47.95},{30.73,47.74},{31.12,52.79},{28.19,44.18},{29.54,44},{59.44,60.64},{68.92,44.35},{80.37,45.65},{68.87,47.74},{69.38,46.85},{74.8,40.7},{57.68,59.97},{71.89,39.84},{64.21,48.24},{61.72,52.02},{73.59,43.39},{58.52,62.05},{70.27,44.8},{70.54,39.46},{70.77,40.65},{67.62,47.68},{69.24,48.81},{60.89,63.63},{73.55,42.06},{52.6,49.85},{53.4,48.84},{57.8,47.73},{59.81,48.14},{60.39,50.73},{60.74,50.25},{58.71,52.17},{85.03,46.28},{84.68,45.25},{80.09,46.81},{70.73,45.54},{68.16,44.64},{72.36,42.09},{71.24,43.28},{60.02,61.12},{58.25,58.79},{65.05,48.28},{59.92,55.61},{71.23,42.26},{57.65,50.17},{56.17,47.09},{58.7,49.6},{57.07,49.09},{54.09,48.35},{54.63,52.22},{54.45,49.11},{55.46,47.1},{55.4,49.15},{60.39,49.13},{61.91,51.98}}},nil,357,nil,nil,38,nil,nil,0},
[5287] = {'Longtooth Howler',2059,2138,43,44,0,nil,nil,0,nil,nil,38,nil,nil,0},
[5288] = {'Rabid Longtooth',2488,2578,35,39,0,nil,nil,0,nil,nil,38,nil,nil,0},
[5291] = {'Hakkari Frostwing',16208,16208,53,54,1,{[1477]={{-1,-1}}},nil,1477,nil,nil,16,nil,nil,0},
[5292] = {'Feral Scar Yeti',1802,1802,43,44,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5293] = {'Hulking Feral Scar',2495,2591,45,46,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5295] = {'Enraged Feral Scar',2200,2218,44,45,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5296] = {'Rage Scar Yeti',2400,2488,46,47,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5297] = {'Elder Rage Scar',2578,2672,48,49,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5299] = {'Ferocious Rage Scar',2500,2578,47,48,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5300] = {'Frayfeather Hippogryph',1093,1093,37,37,0,{[357]={{57.13,72.77},{58.69,74.02},{54.72,75.64},{56.34,64.42},{56.13,69.61},{55.51,67.62},{53.3,69.51},{53.82,70.88},{56.06,66.74},{56.29,68.45},{53.99,65.88},{54.39,69.49},{54.81,74.6},{55.55,75.26},{56.45,73.44},{55.51,73.84},{54.85,72.53},{56.03,71.64},{54.39,70.92},{55.2,59.84},{56.53,62.16},{57.79,62.05},{56.04,61.19},{55.44,63.88}}},nil,357,nil,nil,84,"A",nil,0},
[5304] = {'Frayfeather Stagwing',1336,1336,37,37,0,{[357]={{56.56,74.34},{59.68,73.71},{57.62,73.77},{53.27,67.61},{57.72,64.59},{57.3,66.17},{54.56,68.01},{57.37,67.24},{55.16,66.6},{54.99,64.75},{54.49,64.14},{55.35,70.92},{54.36,73.59},{53.98,72.27},{56.01,63.03},{55.14,62.1},{58,62.98}}},nil,357,nil,nil,84,"A",nil,0},
[5305] = {'Frayfeather Skystormer',1848,1919,45,46,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5306] = {'Frayfeather Patriarch',2399,2488,46,47,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5307] = {'Vale Screecher',1093,1093,36,37,0,{[357]={{47.89,55.57},{48.96,49.51},{48.66,47.99},{43.4,36.49},{42.61,36.47},{37.5,32.51},{45.67,36.89},{45.89,49.3},{41.66,35.66},{45.1,35.77},{46.26,49.91},{35.06,32.33},{36.05,32.18},{40.77,35.77},{44.54,36.46},{46.11,38.43},{47.72,58.92},{47.98,55.61},{48.91,49.43},{48.69,47.98}}},nil,357,nil,nil,14,nil,nil,0},
[5308] = {'Rogue Vale Screecher',2228,2399,44,46,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5312] = {'Lethlas',80925,80925,62,62,1,nil,{[357]={{{50.42,12.28},{50.61,12.31},{50.81,12.29},{51.02,12.33},{51.25,12.33},{51.37,12.32},{51.54,12.29},{51.7,12.17},{51.84,11.97},{51.98,11.75},{52.13,11.43},{52.26,11.32},{52.43,11.2},{52.43,11.2},{52.74,10.98},{52.74,10.98},{53.06,10.75},{53.08,10.64},{52.94,10.8},{52.79,10.94},{52.79,10.94},{52.52,11.18},{52.52,11.18},{52.32,11.38},{52.32,11.38},{52.03,11.68},{51.92,11.8},{51.72,11.88},{51.56,11.98},{51.42,12.08},{51.21,12.17},{51.02,12.18},{50.85,12.06},{50.66,11.9},{50.54,11.72},{50.5,11.49},{50.54,11.26},{50.59,11.03},{50.61,10.72},{50.56,10.38},{50.5,10.19},{50.44,9.82},{50.41,9.54},{50.41,9.21},{50.43,8.93},{50.41,9.14},{50.41,9.23},{50.41,9.23},{50.39,9.76},{50.39,9.76},{50.37,10.29},{50.37,10.29},{50.33,10.99},{50.33,10.99},{50.35,11.52},{50.35,11.52},{50.35,11.52}}}},0,nil,nil,50,nil,nil,0},
[5314] = {'Phantim',1125,1125,26,26,0,{[331]={{93.72,40.95}}},{[331]={{{92.79,38.71},{92.89,38.79},{93.09,39.01},{93.48,39.43},{93.61,39.53},{93.85,39.54},{94.1,39.55},{94.34,39.53},{94.77,39.48},{94.88,39.35},{94.95,39.23},{95.2,38.61},{95.32,38.3},{95.44,37.88},{95.38,37.73},{95.18,37.47},{94.98,37.19},{94.84,36.82},{94.62,36.67},{94.35,36.51},{94.11,36.46},{93.71,36.38},{93.64,36.41},{93.19,36.9},{93.01,37.25},{92.98,37.44},{92.9,37.93},{92.97,38.25}}}},331,nil,nil,50,nil,nil,0},
[5315] = {'Jademir Dragonspawn',75,80,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[5317] = {'Jademir Oracle',62875,62875,61,61,1,nil,nil,0,nil,nil,50,nil,nil,0},
[5319] = {'Jademir Tree Warder',76300,76300,60,60,1,nil,nil,0,nil,nil,50,nil,nil,0},
[5320] = {'Jademir Boughguard',80925,80925,62,62,1,nil,nil,0,nil,nil,50,nil,nil,0},
[5326] = {'Jeremy\'s Test Monster',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[5327] = {'Coast Crawl Snapclaw',1277,1277,35,36,0,{[357]={{37.69,41.34},{25.21,44.37},{34.45,47.08},{23.71,43.92},{35.93,48.43},{38.86,40.65},{36.83,50.59},{24.27,49.54},{23.96,56.25},{37.08,43.95},{41.16,48.42},{38.7,47.76},{26.54,42.45}}},nil,357,nil,nil,129,nil,nil,0},
[5328] = {'Coast Crawl Deepseer',1050,1050,35,36,0,{[357]={{35.28,50.75},{32.24,41.28},{37.68,48.94},{33.5,42.29},{40.16,46.32},{24.85,42.1},{24.23,46.89},{23.9,52.21},{40.15,42.74},{29.69,41.57},{41.54,45.48},{34.88,43.6},{35.79,42.78},{36.38,40.75},{23.72,54.13},{41.25,43.02},{34.64,52.25}}},nil,357,nil,nil,129,nil,nil,0},
[5331] = {'Hatecrest Warrior',1981,2059,42,43,0,nil,nil,0,nil,nil,74,nil,nil,0},
[5332] = {'Hatecrest Wave Rider',1902,1981,41,42,0,nil,nil,0,nil,nil,74,nil,nil,0},
[5333] = {'Hatecrest Serpent Guard',1700,1774,44,45,0,nil,nil,0,nil,nil,74,nil,nil,0},
[5334] = {'Hatecrest Myrmidon',2317,2406,43,44,0,nil,nil,0,nil,nil,74,nil,nil,0},
[5335] = {'Hatecrest Screamer',1522,1585,41,42,0,nil,nil,0,nil,nil,74,nil,nil,0},
[5336] = {'Hatecrest Sorceress',1400,1496,43,44,0,nil,nil,0,nil,nil,74,nil,nil,0},
[5337] = {'Hatecrest Siren',1585,1648,42,43,0,nil,nil,0,nil,nil,74,nil,nil,0},
[5343] = {'Lady Szallah',1640,1640,37,37,4,{[357]={{27.73,69.2},{31.03,42.82}}},nil,357,nil,nil,74,nil,nil,0},
[5345] = {'Diamond Head',1916,1916,36,36,4,{[357]={{35.13,58.27},{21.94,57.82}}},nil,357,nil,nil,14,nil,nil,0},
[5346] = {'Bloodroar the Stalker',2004,2004,37,37,4,{[357]={{52.15,61.15}}},nil,357,nil,nil,14,nil,nil,0},
[5347] = {'Antilus the Soarer',1702,1702,38,38,4,{[357]={{54.02,73.03}}},{[357]={{{55.94,73.49},{56.2,72.82},{56.05,72.05},{55.55,71.37},{55.36,70.8},{55.63,70.07},{55.72,69.27},{55.35,69.04},{54.85,68.92},{54.55,68.83},{54.58,68.2},{55,67.45},{55.33,66.67},{55.01,65.74},{54.61,65},{54.23,65.33},{53.87,65.84},{53.98,66.58},{53.75,67.31},{53.91,68.13},{53.63,68.69},{53.64,69.6},{53.71,70.46},{53.92,71.38},{54.03,72.04},{54.4,72.63},{54.59,73.28},{55.02,73.95},{55.6,74.15}}}},357,nil,nil,16,nil,nil,0},
[5348] = {'Dreamwatcher Forktongue',3921,3921,55,55,4,{[8]={{18.08,70.42}}},nil,8,nil,nil,50,nil,nil,0},
[5349] = {'Arash-ethis',1916,1916,36,36,4,{[357]={{53.56,15.84},{40.63,22.02}}},nil,357,nil,nil,14,nil,nil,0},
[5350] = {'Qirot',2188,2188,39,39,4,{[357]={{74.32,62.14},{73.61,64.06}}},nil,357,nil,nil,310,nil,nil,0},
[5352] = {'Old Grizzlegut',2004,2004,37,37,4,{[357]={{58.11,55.66},{56.57,58.47},{61.25,61.61}}},nil,357,nil,nil,44,nil,nil,0},
[5353] = {'Itharius',2218,2218,45,45,0,nil,nil,0,nil,{3374},35,"AH",nil,1},
[5354] = {'Gnarl Leafbrother',2092,2092,38,38,4,{[357]={{69.24,57.31},{69.42,42.59}}},{[357]={{{69.24,57.31},{69.38,57.76},{69.47,58},{69.64,58.38},{69.79,58.77},{69.95,59.1},{70,59.35},{70.14,59.77},{70.34,60.08},{70.5,60.26},{70.78,60.44},{70.95,60.42},{71.21,60.25},{71.47,60.01},{71.72,59.75},{71.96,59.48},{72.19,59.19},{72.4,58.87},{72.63,58.57},{72.84,58.36},{73.13,58.2},{73.43,58.2},{73.8,58.11},{74.08,58.02},{74.36,58.01},{74.6,58.37},{74.5,58.73},{74.24,58.78},{74.03,58.6},{73.79,58.31},{73.51,58.21},{73.21,58.13},{72.93,58.06},{72.7,57.94},{72.39,57.99},{72.04,57.99},{71.82,57.86},{71.59,57.73},{71.21,57.51},{71.07,57.22},{70.79,57.19},{70.41,57.14},{70.14,56.98},{69.89,56.96},{69.59,56.97}}}},357,nil,nil,7,"AH",nil,0},
[5355] = {'Firewing Defender',5527,5527,63,64,0,{[3519]={{71.72,39.64},{71.37,39.52},{71.24,39.5},{72.68,39.55},{72.66,38.13},{72.85,38.96},{73.15,37.06},{72.93,36.84},{72.37,35.91},{71.97,35.73},{71.29,35.81},{70.7,35.8},{68.16,36.45},{68.15,36.6},{68.65,37.34},{68.88,37.06},{69.37,36.74},{69.83,36.73},{70.38,36.65},{70.6,36.4},{70.52,38.11},{69.63,37.77},{71.05,35.78},{71.8,34.87},{71.49,35.11}}},nil,3519,nil,nil,16,nil,nil,0},
[5356] = {'Snarler',2188,2188,39,39,4,{[357]={{80.5,39.5},{76.61,38.94}}},nil,357,nil,nil,38,nil,nil,0},
[5357] = {'Land Walker',6186,6414,41,43,1,nil,nil,0,nil,nil,778,nil,nil,0},
[5358] = {'Cliff Giant',6414,6645,41,43,1,nil,nil,0,nil,nil,778,nil,nil,0},
[5359] = {'Shore Strider',4008,4008,37,37,1,{[357]={{45.57,55.15},{45.55,53.17},{45.8,57.01},{45.81,58.81},{34.16,34.94},{44.45,69.7},{33.49,36.35},{44.38,71.51},{33.34,32.15},{39.6,37.81},{36.32,36.37},{44,68.03},{38.4,36.21},{43.04,68.01},{34.88,35.81},{37.35,36.76},{43.12,73.14},{32.91,34.23},{42.6,40.66},{44.38,66.4},{45.11,64.89},{43.79,41.39},{41.73,40.11},{40.62,38.59},{44.92,62.19},{44.55,60.96},{43.93,63.59},{43.92,44.39},{43.88,47.31},{43.63,48.95},{43.96,49.88},{45.6,53.3},{44.47,52.8},{45.78,58.77},{46.22,62.5},{45.42,63.54},{45.72,60.17},{45.54,55.2}}},nil,357,nil,nil,778,nil,nil,0},
[5360] = {'Deep Strider',4776,5130,47,49,1,nil,nil,0,nil,nil,778,nil,nil,0},
[5361] = {'Wave Strider',2500,2500,47,48,1,nil,nil,0,nil,nil,778,nil,nil,0},
[5362] = {'Northspring Harpy',967,967,34,35,0,{[357]={{38.6,17.05},{39.11,10.12},{38.21,10.33},{37.42,15.44},{37.58,16.1},{40.71,9.82},{38.33,15.9},{40.21,14.15},{40,12.8},{41.6,12.45},{41.43,11.28},{39.2,16.1},{38.39,14.7},{39.94,15.08},{39.39,14.92},{37.81,11.98},{41.69,10.04},{38.64,11.39}}},nil,357,nil,nil,514,nil,nil,0},
[5363] = {'Northspring Roguefeather',2000,2138,35,39,0,nil,nil,0,nil,nil,514,nil,nil,0},
[5364] = {'Northspring Slayer',2000,2215,35,39,0,nil,nil,0,nil,nil,514,nil,nil,0},
[5366] = {'Northspring Windcaller',967,967,34,34,0,{[357]={{42.22,11.1},{38.83,15.58},{38.87,10.83},{40.16,11.91},{40.14,10.37},{40.71,10.9},{40.95,12.12},{39.18,13.03},{38.59,12.69},{37.76,14.51},{39.36,14.07},{39.59,11.21},{38.67,13.6},{41.35,8.71},{40.01,9.3},{39.17,11.96}}},nil,357,nil,nil,514,nil,nil,0},
[5367] = {'Scillia Daggerquil',125,133,1,1,4,nil,nil,0,nil,nil,35,"AH",nil,0},
[5384] = {'Brohann Caskbelly',1753,1753,40,40,0,{[1519]={{66.74,44.19}}},nil,1519,nil,{1448,1469,1475},55,"A","Explorers' League",0},
[5385] = {'Watcher Mahar Ba',3882,3882,45,45,0,{[4]={{63.18,16.85}}},nil,4,{25716,26157},{1364,25714,25716},53,"A",nil,2},
[5386] = {'Acolyte Dellis',328,328,15,15,0,{[1519]={{51.4,73.81}}},nil,1519,nil,{1363},12,"A",nil,0},
[5387] = {'High Explorer Magellas',4120,4120,60,60,0,{[1537]={{69.93,18.55}}},nil,1537,{2963},{2279,2964},55,"A","Explorers' League",2},
[5388] = {'Ingo Woolybush',1678,1678,39,39,0,{[15]={{66.28,45.21}}},nil,15,nil,nil,55,"A","Jewelcrafting Trainer & Supplies",209},
[5389] = {'Prospector Gunstan',2218,2218,45,45,0,nil,nil,0,nil,nil,55,"A","Explorers' League",0},
[5390] = {'Sage Palerunner',2566,2566,49,49,0,{[357]={{75.09,42.71}}},nil,357,{25643},{25645},104,"H",nil,2},
[5391] = {'Galen Goodward',1536,1536,37,37,0,nil,nil,0,{1393},nil,1801,"H",nil,2},
[5392] = {'Yarr Hammerstone',198,198,10,10,0,{[1]={{57.13,48.62}}},nil,1,nil,nil,55,"A","Mining Trainer",81},
[5393] = {'Quartermaster Lungertz',3293,3293,54,54,0,{[4]={{60.1,13.49}}},nil,4,{25710,25711,25714},{1395,1423,1425,25710,25711,28673,28857,28867},123,"A",nil,2},
[5394] = {'Neeka Bloodscar',2218,2218,45,45,0,nil,nil,0,nil,{1418,1419},125,"H",nil,0},
[5395] = {'Felgur Twocuts',1782,1782,44,44,0,{[405]={{56.19,59.57}}},nil,405,{5581,14342},{1362,1365,1366,5581,14342,14344},125,"H",nil,3},
[5396] = {'Captain Pentigast',1651,1651,42,42,0,{[405]={{66.66,10.93}}},nil,405,{14361,14363,14364,14387},{14361,14362,14363,14364},123,"A",nil,2},
[5397] = {'Uthek the Wise',2138,2138,44,44,0,nil,nil,0,nil,{1368,1370,1373,1374,1380,1382,1384},35,"AH",nil,0},
[5398] = {'Warug',2138,2138,44,44,0,nil,nil,0,nil,{1367,1369,1371,1375,1381,1385,1386},35,"AH",nil,0},
[5399] = {'Veyzhak the Cannibal',3093,3093,48,48,4,{[8]={{77.62,45.76}}},nil,8,nil,nil,14,nil,nil,0},
[5400] = {'Zekkis',3093,3093,48,48,4,{[8]={{76.75,42.77},{76.41,41.51}},[44]={{98.64,99.22}}},nil,8,nil,nil,14,nil,nil,0},
[5401] = {'Kazkaz the Unholy',2475,2475,48,48,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5402] = {'Khan Hratha',1981,1981,42,42,0,nil,nil,0,nil,nil,134,nil,nil,0},
[5403] = {'Riding White Stallion',55,55,1,1,0,{[11]={{9.47,56.32}},[12]={{42.91,66.07},{49.05,42.96}},[85]={{81.07,31.87},{81.06,31.97},{81.24,31.81}},[440]={{50.8,27.5}}},nil,85,nil,nil,35,"AH",nil,0},
[5404] = {'Black Stallion',42,42,2,2,0,{[11]={{9.38,56.57}}},nil,11,nil,nil,35,"AH",nil,0},
[5405] = {'Pinto',42,42,1,1,0,{[11]={{9.44,56.38}},[12]={{83.99,64.85}},[15]={{65.19,51.99}}},nil,12,nil,nil,35,"AH",nil,0},
[5406] = {'Palomino',42,42,1,1,0,{[11]={{9.42,56.45}},[12]={{42.88,66.25}},[85]={{81.05,32.06}}},nil,85,nil,nil,35,"AH",nil,0},
[5407] = {'Nightmare',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[5409] = {'Harvester Swarm',1,1,34,34,0,nil,nil,0,nil,nil,310,nil,nil,0},
[5411] = {'Krinkle Goodsteel',1753,1753,40,40,0,{[440]={{51.15,30.39}}},nil,440,nil,{4450,5514,5538},474,"AH","Blacksmithing Supplies",4225},
[5412] = {'Gurda Wildmane',1220,1220,35,35,0,{[405]={{56.29,59.68}}},nil,405,nil,nil,83,"H",nil,0},
[5413] = {'Furen Longbeard',1753,1753,40,40,0,{[1519]={{64.54,37.58}}},nil,1519,nil,{1338,1701,1702,1782},122,"A",nil,2},
[5414] = {'Apothecary Faustin',1753,1753,40,40,0,nil,nil,0,nil,{1372,1383},68,"H","Royal Apothecary Society",0},
[5415] = {'Centaur Outrunner',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[5416] = {'Infiltrator Marksen',1753,1753,40,40,0,{[8]={{46.15,53.03}}},nil,8,nil,{1391},35,"AH",nil,0},
[5418] = {'Deathstalker Zraedus',1753,1753,40,40,0,nil,nil,0,nil,{1388},68,"H",nil,0},
[5419] = {'Glasshide Basilisk',1848,1848,44,45,0,{[440]={{48.8,27.41},{47.04,28.6},{48.34,25.43},{47.02,36.08},{46.83,31.87},{46.97,27.28},{48.4,29.28},{39.3,19.89},{39.39,19.83},{47.94,41.95},{46.98,34.17},{47.88,32.89},{48.36,31.51},{49.73,46.37},{52.91,42.51},{52.59,43.86},{50.78,43.94},{48.82,41.03},{51.15,42.51},{52.01,41.25},{51.13,40.8},{51.71,42.41},{51.6,39.02},{52.85,39.66},{49.28,38.98},{47.39,40.02},{46.96,41.05},{45.66,41.61},{48.7,34.28},{49.18,32.68},{50.84,34.67},{47.94,37.66},{51.33,35.54},{51.03,42.57},{51.14,40.98},{50.58,38.3},{50.43,39.76},{48.33,38.94}}},nil,440,nil,nil,49,nil,nil,0},
[5420] = {'Glasshide Gazer',1919,1919,46,47,0,{[440]={{51.03,63.28},{51.97,61.33},{51.1,54.47},{53.92,53.34},{53.01,53.08},{52.58,55.03},{56.72,51.44},{56.61,52.93},{58.06,55.65},{58.24,53.82},{60.26,57.39},{60.7,55.66},{54.8,52.21},{56.11,57.45},{56.15,54.89},{55.32,55.78},{53.42,57.19},{60.3,57.06},{58.46,57.13},{59.32,59.21},{56.21,58.52},{52.27,57.83},{51.63,59.1},{57.98,59.47},{53.93,57.76}}},nil,440,nil,nil,49,nil,nil,0},
[5421] = {'Glasshide Petrifier',2578,2672,48,49,0,nil,nil,0,nil,nil,49,nil,nil,0},
[5422] = {'Scorpid Hunter',1800,1902,40,41,0,nil,nil,0,nil,nil,413,nil,nil,0},
[5423] = {'Scorpid Tail Lasher',2059,2138,43,44,0,nil,nil,0,nil,nil,413,nil,nil,0},
[5424] = {'Scorpid Dunestalker',2399,2488,46,47,0,nil,nil,0,nil,nil,413,nil,nil,0},
[5425] = {'Starving Blisterpaw',1902,1981,41,42,0,nil,nil,0,nil,nil,38,nil,nil,0},
[5426] = {'Blisterpaw Hyena',1782,1782,44,45,0,{[440]={{46.4,35.79},{45.99,37.06},{45.24,36.38},{46.45,32.93},{45.09,28.6},{47.06,36.1},{46.73,25.31},{45.92,32.24},{46.8,31.91},{47.52,31.38},{46.61,27.89},{48.83,27.37},{49.05,26},{48.3,25.45},{45.88,30.02},{45.52,30.92},{46.09,30.85},{48.36,29.31},{47.94,30.09},{46.08,25.2},{48.38,29.38},{47.75,28.7},{47,28.62},{47.97,27.21},{48.41,28},{46.88,37.06},{46.54,26.58},{47.42,28},{46.95,27.23},{47.62,25.68},{47.48,26.75},{46.18,27.15},{46.51,27.97},{46.5,29.36},{46.03,28.68},{48.36,29.3}}},nil,440,nil,nil,38,nil,nil,0},
[5427] = {'Rabid Blisterpaw',1919,1919,46,47,0,{[440]={{51.39,62.68},{51.08,61.25},{50.73,55.75},{53.34,54.37},{56.03,52.2},{57.3,52.89},{57.64,54.39},{58.69,54.81},{61.14,56.45},{59.96,55.79},{54.06,51.52},{54.79,53.6},{55.21,54.66},{56.23,56.43},{54.06,56.49},{56.06,52.25},{55.25,54.78},{57.65,54.39},{54.82,52.88},{57.55,57.96},{54.45,57.7},{52.55,58.51},{58.56,60.06},{59.66,61.05},{56.96,59.38},{58.69,58.53},{52.49,59.92},{57.58,57.99}}},nil,440,nil,nil,38,nil,nil,0},
[5428] = {'Roc',1902,2059,41,43,0,nil,nil,0,nil,nil,73,nil,nil,0},
[5429] = {'Fire Roc',1478,1478,44,45,0,{[440]={{49.36,45.29},{47.89,48.88},{48.67,47.22},{43.58,50.58},{49.83,43.91},{42.75,50.31},{48.52,45.93},{42.34,51.65},{45.14,51.03},{46.84,46.64},{44.38,49.95},{44.56,48.73},{43.46,51.67},{44.23,50.93},{44.97,49.72},{43.75,49.41},{49.94,35.93},{50.26,37.07},{50.48,35.82},{49.17,36.93},{49.87,35.04},{49.07,35.52},{49.34,37.74},{49.52,36.12},{46.41,39.6},{43.33,39.25},{45.61,39.51},{45.07,40.53},{49.26,42.1},{49.44,37.81},{50.15,37.13},{48.74,36.97},{49.24,36.93}}},nil,440,nil,nil,73,nil,nil,0},
[5430] = {'Searing Roc',1990,1990,47,48,0,{[440]={{41.95,63.24},{37.41,67.1},{37.01,69.01},{36.88,69.89},{37.58,68.74},{36.94,68.04},{38.8,66.69},{38.31,66.69},{38.14,68.22},{38.16,67.38},{33.54,60.46},{33.15,60.97},{33.98,59.96},{33.53,59.76},{33.07,59.57},{32.12,61.57},{32.57,60.09},{34.45,59.27},{33.08,60.34},{32.18,60.73},{32.68,60.85},{41.16,62.87},{40.49,64.51},{40.87,63.29},{41.53,62.53},{42.07,62.27},{41,63.6},{40.51,63.67},{41.92,61.65},{41.47,63.12},{42.86,62.45},{42.4,61.67}}},nil,440,nil,nil,73,nil,nil,0},
[5431] = {'Surf Glider',1990,1990,47,48,0,{[440]={{62.3,74.94},{60.96,76.36},{59.9,77.77},{61.71,77.76},{64.45,66.75},{53.55,96.79},{52.85,96.31},{58.49,90.95},{58.91,89.49},{47.55,85.49},{53.44,95.62},{54.38,95.05},{55.07,94.73},{53.33,93.97},{55.29,88.96},{58.52,88.29},{56.98,91.94},{56.83,90.15},{56.77,89.15},{57.56,88.31},{58.98,85.87},{57.66,89.74},{58,85.78},{58.52,84.71},{59.07,88.52},{59.65,86.73},{58.58,86.88},{59.37,84.17},{59.89,82.78},{60.61,79.28},{60.54,81.97},{59.11,82.93},{59.58,81.91},{60.51,84.05},{59.57,80.42},{60.97,82.89},{60.25,80.48},{61,80.72},{60.51,87},{60.88,85.4},{60.04,85.65},{56.65,88.25},{55.3,90.37},{55.35,91.15},{56.27,90.72},{56.09,92.28},{54.36,93.66},{53.9,93.15},{55.32,93.23},{53.73,91.28},{63.36,68.27},{63.2,70.69},{54.5,92.22},{48.36,87.61}}},nil,440,nil,nil,15,"AH",nil,0},
[5432] = {'Giant Surf Glider',7088,7537,48,50,1,nil,nil,0,nil,nil,14,nil,nil,0},
[5433] = {'Tamed Bear',3517,3517,50,50,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5434] = {'Coral Shark',6716,6716,46,47,1,{[15]={{77.49,69.2}},[5287]={{73.04,41.83}}},nil,15,nil,nil,16,nil,nil,0},
[5435] = {'Sand Shark',594,594,10,10,1,{[85]={{21.67,33.69},{38.3,20.71},{55.85,19.64}}},nil,85,nil,nil,14,nil,nil,0},
[5436] = {'Tamed Bird',500,500,12,12,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[5437] = {'Tamed Boar',3517,3517,50,50,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[5438] = {'Tamed Cat',3517,3517,50,50,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[5439] = {'Tamed Crawler',3517,3517,50,50,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[5440] = {'Tamed Crocolisk',3517,3517,50,50,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[5441] = {'Hazzali Wasp',2488,2578,47,48,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5442] = {'Tamed Gorilla',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[5443] = {'Tamed Zhevra',2500,2700,23,24,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[5444] = {'Tamed Raptor',2471,2471,40,40,0,nil,nil,0,nil,nil,42,"AH",nil,0},
[5445] = {'Tamed Scorpid',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[5446] = {'Tamed Spider',3517,3517,50,50,0,nil,nil,0,nil,nil,22,nil,nil,0},
[5447] = {'Tamed Tallstrider',25,27,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[5448] = {'Tamed Turtle',128,128,50,50,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5449] = {'Tamed Wolf',3517,3517,50,50,0,nil,nil,0,nil,nil,29,"H",nil,0},
[5450] = {'Hazzali Stinger',1919,1919,46,47,0,{[440]={{51.05,70.7},{50.23,74.18},{51.8,72.2},{50.75,71.46},{50.32,66.02},{49.65,72.19},{49.58,71.41},{50.58,74.72},{50.7,65.35},{52.39,72.25},{50.57,74.01},{52.43,68.02},{52.44,67.28},{50.95,65.99},{56.72,62.28},{52.92,64.9},{54.19,60.76},{53.36,64.27},{53.52,65.11},{54.69,65.32},{55.35,62.87},{54.73,63.14},{54.56,66.02},{55.17,63.78},{55.09,65.8},{56.32,64.65},{56.93,64.83},{56.57,65.57},{56.81,61.46}}},nil,440,nil,nil,310,nil,nil,0},
[5451] = {'Hazzali Swarmer',1919,1919,46,47,0,{[440]={{49.7,73.9},{54.33,72.66},{53.69,71.02},{51.08,71.8},{52.39,73.06},{50.25,73.04},{53.85,69.86},{53.29,72.56},{54.85,72.5},{55.93,74.6},{54.7,72.85},{54.67,72.07},{54.4,70.29},{49.85,70.39},{55.78,72.83},{51.19,75.06},{57.51,70.14},{53.51,69.89},{55.71,71.55},{54.82,71.6},{54.68,71.77},{54.86,72.11},{54.48,71.7},{54.98,72.02},{54.79,71.88},{51.6,65.47},{51.72,70.17},{56.42,66.41},{56.86,70.93},{56.97,68.6},{56.36,70.96},{57.63,69.33},{56.86,69.57},{55.54,67.86},{56.37,68.17},{53.97,71.84},{53.79,71.35},{54.27,72.3},{54.53,71.77},{54.32,71.91},{51.81,67.61},{54.07,64.77},{53.11,63.08},{54.57,75.74},{55.49,76.41},{56.56,66.88},{54.57,67.7},{55.6,76.03},{55.58,66.76},{57.11,65.77},{53.25,61.89}}},nil,440,nil,nil,310,nil,nil,0},
[5452] = {'Hazzali Worker',1990,1990,46,47,0,{[440]={{56.39,72.65},{56.65,69.56},{56.35,71.79},{54.48,72.44},{48.89,71.01},{50.82,68.41},{54.6,74.99},{58.31,66.23},{53.2,74.21},{52.03,74.39},{56.13,73.21},{50.04,75.14},{54.52,72.76},{54.72,72.47},{57.11,72.97},{56.93,68.39},{50.58,66.81},{53.88,72.95},{51.35,73.55},{48.96,72.47},{56.69,66.49},{56.05,72.44},{50.76,69.56},{53.51,71.26},{53.9,68.77},{58.08,64.37},{55.15,70.73},{55.84,70.48},{55.08,71.97},{54.65,71.59},{55.18,71.55},{51.56,69},{55.97,67.13},{56.46,66.91},{56.79,69.05},{56.27,69.08},{56.88,67.97},{57.24,69.65},{56.03,70.5},{57.61,68.49},{55.47,68.76},{54.51,71.94},{56.18,68.03},{52.61,64.71},{53.02,66.24},{54.13,70.16},{54.62,69.59},{56.25,62.72},{54.95,65.23},{57.22,63.82},{55.25,75.93},{53.96,66.26},{54.56,75.08},{56.08,65.32},{55.16,62.13}}},nil,440,nil,nil,310,nil,nil,0},
[5453] = {'Hazzali Tunneler',2578,2672,48,49,0,nil,nil,0,nil,nil,310,nil,nil,0},
[5454] = {'Hazzali Sandreaver',1990,1990,46,47,0,{[440]={{57.47,71.13},{53.58,68.78},{50.27,71.58},{52.62,69.9},{56.82,74.22},{54.75,72.6},{53.5,75.58},{54.89,72.68},{53.32,69.28},{51.76,75.92},{54.98,72.66},{54.95,73.95},{55.03,72.14},{54.84,71.85},{55.46,71.53},{52.17,65.96},{52.53,71.46},{56.02,70.54},{57.97,68.61},{54.32,72.12},{55.9,63.95}}},nil,440,nil,nil,310,nil,nil,0},
[5455] = {'Centipaar Wasp',2062,2062,47,48,0,{[440]={{34.76,39.53},{33.73,45.15},{32.77,44.9},{34.27,51.44},{31.76,48.53},{31.8,45.99},{32.49,50.43},{34.51,39.91},{31.46,46.44},{31.63,49.03},{34.8,40.12},{33.85,51.29},{32.58,50.99},{32.13,48.54},{33.27,45.22},{32.16,50.69},{32.03,49.07},{31.57,46.87},{31.93,46.51},{34.11,50.77},{35.12,49.87},{35.36,50.12},{35.6,49.75},{35.85,48.21},{36.27,48.39},{36.06,40.4},{36.15,39.84},{36.46,40.18},{37,41.93},{37.42,41.94},{37.35,42.44},{36.31,44.75},{36.38,44},{36.77,44.52}}},nil,440,nil,nil,310,nil,nil,0},
[5456] = {'Centipaar Stinger',2578,2672,48,49,0,nil,nil,0,nil,nil,310,nil,nil,0},
[5457] = {'Centipaar Swarmer',2400,2769,49,50,0,nil,nil,0,nil,nil,310,nil,nil,0},
[5458] = {'Centipaar Worker',1990,1990,47,48,0,{[440]={{33.72,44.89},{34.49,51.55},{34.21,42.94},{32.66,48.39},{32.21,44.93},{32.59,45.62},{38.2,41.32},{33.69,41.93},{32.35,45.9},{35.43,43.37},{32.75,47.31},{35.48,43.98},{34.03,41.53},{33.09,51.05},{35.25,39.97},{33.11,46.29},{32.38,45.85},{34.76,46.69},{34.49,49.89},{35.79,49.19},{33.87,39.46},{34.62,40.52},{31.22,45.98},{35.45,46.96},{34.6,46.57},{36.27,41.88},{36.22,46.63},{36.61,39.03},{37.55,46.57},{36.61,45.37},{35.44,45.12}}},nil,440,nil,nil,310,nil,nil,0},
[5459] = {'Centipaar Tunneler',2062,2062,47,48,0,{[440]={{33.39,48.18},{35.7,42.49},{32.86,45.37},{35.5,42.26},{32.77,48.42},{34.22,46.79},{34.25,42.32},{32.94,45.94},{34.01,45.8},{35.38,42.66},{35.51,46.73},{34.14,47.63},{31.97,44.29},{35.59,45.44},{34.27,47.22},{33.54,48.18},{34.93,40.08},{33.76,43.43},{34.3,42.09},{31.65,45.98},{35.95,43.66},{32.91,44.84},{32.89,43.9},{34.81,41.62}}},nil,440,nil,nil,310,nil,nil,0},
[5460] = {'Centipaar Sandreaver',2062,2062,47,48,0,{[440]={{34.9,45.37},{33.11,44.46},{33.58,44.56},{32.7,46.55},{33.23,52.38},{35.36,39.12},{32.22,46.98},{34.56,38.49},{32.95,48.1},{35.58,40.52},{32.07,45.52},{33.58,44.46},{35.67,44},{31.7,50.32},{34.48,46.24},{32.46,44.67},{31.16,47.96},{34.34,45.25},{33.95,47.94},{32.64,49.54},{33.62,45.96},{33.31,49.57},{33.14,45.53},{35.13,40.65},{34.92,48.69},{34.91,51.21},{36.23,50.62},{36.75,49.4},{34.47,40.43},{32.8,43.46},{31.53,44.69},{34.97,42.41},{34.52,41.14},{36.87,41.02},{37.6,40.11},{37.89,42.51},{36.81,47.51},{37.45,44.84},{37.1,43.66},{34.58,44.72},{36.3,43.36},{34.02,43.62}}},nil,440,nil,nil,310,nil,nil,0},
[5461] = {'Sea Elemental',1336,1336,37,37,0,{[357]={{49.05,54.02},{49.82,50.99},{47.86,52.31},{46.37,55.8},{46.95,55.06},{46.38,57.29},{46.84,53.8},{36.72,36.01},{36.85,34.78},{34.91,34.07},{37.72,35.59},{39.01,34.8},{35.82,33.47},{39.34,33.31},{46.18,66.62},{45.08,68.8},{45.4,39.33},{41.09,36.95},{43.66,38.25},{44.35,39.65},{43.2,39.45},{46.32,60.32},{46.38,55.87},{47.07,55.18},{46.34,57.37},{46.98,53.59},{47.38,60.73},{46.56,62.73},{46.76,63.64},{47.25,62.02},{49.74,51.38},{47.91,50.77}}},nil,357,nil,nil,91,nil,nil,0},
[5462] = {'Sea Spray',1093,1093,37,37,0,{[357]={{50.05,53},{47.04,57.73},{47.8,50.96},{47.23,56.32},{48.92,50.93},{36.73,33.41},{34.05,31.96},{38.13,34},{34.21,33.44},{38.79,32.44},{35.8,34.91},{44.95,67.15},{46.24,65.05},{45.43,65.75},{45.81,67.95},{44.54,38.39},{42.54,38.02},{42.09,39.81},{40.18,37.11},{41.58,38.48},{39.29,36.38},{44.06,45.96},{44.03,51.46},{47.04,59.1},{47.07,57.79},{46.25,58.34},{46.61,61.53},{45.99,63.94},{47.06,56.54}}},nil,357,nil,nil,91,nil,nil,0},
[5464] = {'Watchmaster Sorigal',950,950,29,29,0,{[10]={{75.78,46.16}}},nil,10,nil,{1477},84,"A",nil,2},
[5465] = {'Land Rager',1919,1919,45,46,0,{[440]={{49.76,50.65},{39.21,41.94},{51.59,48.82},{39.16,40.56},{40.51,42.29},{40,43.99},{41.76,46.56},{36.17,55.13},{35.34,26.5},{53.82,48.1},{36.42,57.06},{40.64,47.89},{48.84,51.43},{39.09,32.22},{39.54,33.56}}},nil,440,nil,nil,91,nil,nil,0},
[5466] = {'Coast Strider',6186,6414,48,49,1,nil,nil,0,nil,nil,778,nil,nil,0},
[5467] = {'Deep Dweller',6414,6645,49,50,1,nil,nil,0,nil,nil,22,nil,nil,0},
[5468] = {'Wandering Dune Smasher',75,80,1,1,1,nil,nil,0,nil,nil,35,"AH",nil,0},
[5469] = {'Dune Smasher',6186,6414,48,49,1,nil,nil,0,nil,nil,778,nil,nil,0},
[5470] = {'Raging Dune Smasher',6414,6645,49,50,1,nil,nil,0,nil,nil,778,nil,nil,0},
[5471] = {'Dunemaul Ogre',1848,1848,45,46,0,{[440]={{39.3,57.68},{40.5,52.93},{41.06,52.73}}},nil,440,nil,nil,45,nil,nil,1},
[5472] = {'Dunemaul Enforcer',1990,1990,46,47,0,{[440]={{38.8,56.82},{38.87,54.3},{38.84,52.14},{38.75,56.27},{39.11,55.72},{40.52,54.09},{40.56,51.27},{40.68,51.51},{39.33,51.88},{39.38,51.27},{41.49,52.1},{41.73,56.35},{41.92,56.31},{41.14,56.55},{40.33,57.66},{40.62,57.7}}},nil,440,nil,nil,45,nil,nil,1},
[5473] = {'Dunemaul Ogre Mage',1535,1535,46,47,0,{[440]={{39.27,54.52},{40.62,55.72},{42.05,53.74},{42.78,54.15}}},nil,440,nil,nil,45,nil,nil,1},
[5474] = {'Dunemaul Brute',2062,2062,47,48,0,{[440]={{38.47,57.05},{38.17,56.78},{38.31,56.32},{38.44,58.78},{39.02,54.53},{40.93,50.57},{41.14,50.66},{40.92,54.13},{40.48,54.26},{40.3,50.88},{39.68,51.79},{38.85,52.73},{39.73,51.15},{40.08,51.17},{39.25,52.39},{42.55,53.19},{42.42,52.92},{41.04,53.85},{42.99,53.02},{41.61,51.86},{43.2,54.58},{41.47,56.45},{41.03,57.03},{40.5,55.69}}},nil,440,nil,nil,45,nil,nil,1},
[5475] = {'Dunemaul Warlock',1650,1650,47,48,0,{[440]={{40.16,56.38},{41.7,54.93}}},nil,440,nil,nil,45,nil,nil,1},
[5476] = {'Watcher Biggs',1221,1221,33,33,0,{[8]={{30.1,59.79}}},nil,8,nil,{1396,1398,1421,9609},12,"A",nil,0},
[5477] = {'Noboru the Cudgel',1678,1678,39,39,0,nil,{[8]={{{55.2,37.83},{54.38,38.46},{53.37,39.06},{52.28,39},{50.54,38.66},{48.66,38.58},{47.32,38.41},{46.48,38.67},{45.63,36.5},{44.35,34.7},{43.53,33.64},{42.25,32.07},{40.84,32.44},{40.25,34.77},{38.84,35.84},{38.41,38.05},{38.14,40.53},{37.92,43.28},{37.13,45.04},{36.72,46.51},{35.82,45.68},{34.18,44.43},{33.53,44.03},{33.41,42.62},{33.38,40.46},{32.78,39.18},{32.23,37.16},{32.27,36.49},{32.23,37.16},{32.78,39.18},{33.38,40.46},{33.41,42.62},{33.53,44.03},{34.18,44.43},{35.82,45.68},{36.72,46.51},{37.13,45.04},{37.92,43.28},{38.14,40.53},{38.41,38.05},{38.84,35.84},{40.25,34.77},{40.84,32.44},{42.25,32.07},{43.53,33.64},{44.35,34.7},{45.63,36.5},{46.48,38.67},{47.32,38.41},{48.66,38.58},{50.54,38.66},{52.28,39},{53.37,39.07},{54.38,38.46},{55.2,37.83},{55.93,36.23}}}},0,nil,nil,5