---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local debugMessagesLocales = {
    ["Questie Commands"] = {
        ["enUS"] = true,
        ["deDE"] = "Questie-Befehle",
        ["esES"] = "Comandos de Questie",
        ["esMX"] = "Comandos de Questie",
        ["frFR"] = "Commandes de Questie",
        ["koKR"] = "Questie 명령어",
        ["ptBR"] = "Comandos de Questie",
        ["ruRU"] = "Команды Questie:",
        ["zhCN"] = "Questie配置命令",
        ["zhTW"] = "Questie 指令",
    },
    ["Toggles the Config window"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeigen/Verstecken des Einstellungsfensters",
        ["esES"] = "Muestra/oculta la ventana de opciones",
        ["esMX"] = "Muestra/oculta la ventana de opciones",
        ["frFR"] = "Active ou désactive la fenêtre des options",
        ["koKR"] = "설정 창을 엽니다",
        ["ptBR"] = "Mostra/oculta a janela de opções",
        ["ruRU"] = "показать/скрыть окно настроек.",
        ["zhCN"] = "打开设置窗口",
        ["zhTW"] = "切換顯示設定選項",
    },
    ["Toggles showing questie on the map and minimap"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeigen/Verstecken von Questie auf der Weltkarte und Minimap",
        ["esES"] = "Muestra/oculta Questie en el mapa y minimapa",
        ["esMX"] = "Muestra/oculta Questie en el mapa y minimapa",
        ["frFR"] = "Active ou désactive l'affichage de Questie sur la carte et la minicarte",
        ["koKR"] = "맵과 미니맵에 퀘스티 아이콘을 표시합니다",
        ["ptBR"] = "Mostra/oculta Questie no mapa e minimapa",
        ["ruRU"] = "показать/скрыть значки Questie.",
        ["zhCN"] = "在地图上显示Questie提示",
        ["zhTW"] = "在大地圖和小地圖上顯示任務圖示",
    },
    ["Toggles the My Journey window"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeigen/Verstecken des 'Meine Reise'-Fensters",
        ["esES"] = "Muestra/oculta la ventana de 'Mi viaje'",
        ["esMX"] = "Muestra/oculta la ventana de 'Mi viaje'",
        ["frFR"] = "Active ou désactive l'affichage de la fenêtre 'Mon voyage'.",
        ["koKR"] = "나의 여정 창을 표시합니다",
        ["ptBR"] = "Mostra/oculta a janela 'Minha jornada'",
        ["ruRU"] = "открыть 'Путешествие'.",
        ["zhCN"] = "打开日志窗口",
        ["zhTW"] = "打開冒險日記",
    },
    ["Toggles the Tracker. Add 'show', 'hide', 'reset' to explicit show/hide or reset the Tracker"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeigen/Verstecken des Questie Trackers. Bei 'show', 'hide' oder 'reset' wird der Tracker explizit gezeigt, versteckt oder zurückgesetzt",
        ["esES"] = "Muestra/oculta el rastreador. Añade 'mostrar', 'ocultar', 'restablecer' para mostrar/ocultar o restablecer el rastreador",
        ["esMX"] = "Muestra/oculta el rastreador. Añade 'mostrar', 'ocultar', 'restablecer' para mostrar/ocultar o restablecer el rastreador",
        ["frFR"] = "Active ou désactive le suivi. Ajoute 'afficher', 'cacher', 'réinitialiser' pour afficher / cacher ou réinitialiser le suivi",
        ["koKR"] = "추적기를 표시합니다. 'show','hide','reset'을 설정하여 추적기를 설정합니다.",
        ["ptBR"] = "Mostra/oculta o rastreador. Adiciona 'mostrar', 'ocultar', 'redefinir' para mostrar/ocultar ou redefinir o rastreador",
        ["ruRU"] = "состояние трекера Questie. Добавьте 'show', 'hide', 'reset', чтобы показать, скрыть или сбросить трекер.",
        ["zhCN"] = "切换任务追踪窗口，输入  'show', 'hide', 'reset' 选项以显示、隐藏、重设追踪窗口",
        ["zhTW"] = "切換顯示追蹤清單。加上 'show', 'hide', 'reset' 選項來顯示、隱藏、重置追蹤清單",
    },
    ["Flex the amount of quests you have completed so far"] = {
        ["enUS"] = true,
        ["deDE"] = "Gib mit der Anzahl an Quests an die du bisher abgeschlossen hast",
        ["esES"] = "Muestra la cantidad de misiones que has completado hasta ahora",
        ["esMX"] = "Muestra la cantidad de misiones que has completado hasta ahora",
        ["frFR"] = "Frimer avec le nombre de quêtes réalisées jusqu’à présent",
        ["koKR"] = "지금까지 완료한 퀘스트의 수를 표시합니다",
        ["ptBR"] = "Mostra a quantidade de missões que você completou até agora",
        ["ruRU"] = "похвастаться количеством выполненных вами заданий.",
        ["zhCN"] = "调整目前为止你完成的任务数量",
        ["zhTW"] = "調整到目前為止你已完成的任務數量",
    },
    ["has completed a total of %d quests"] = {
        ["enUS"] = true,
        ["deDE"] = "hat insgesamt %d Quests abgeschlossen",
        ["esES"] = "ha completado un total de %d misiones",
        ["esMX"] = "ha completado un total de %d misiones",
        ["frFR"] = "a terminé un total de %d quêtes",
        ["koKR"] = "지금까지 %d 의 퀘스트를 완수하였습니다",
        ["ptBR"] = "completou um total de %d missões",
        ["ruRU"] = "всего выполнено заданий - %d",
        ["zhCN"] = "总共完成了 %d 个任务",
        ["zhTW"] = "總共完成了 %d 個任務",
    },
    ["Toggles the Minimap Button for Questie"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeigen/Verstecken des Minimap-Buttons für Questie",
        ["esES"] = "Muestra/oculta el botón del minimapa para Questie",
        ["esMX"] = "Muestra/oculta el botón del minimapa para Questie",
        ["frFR"] = "Active ou désactive l'affichage du bouton de la minicarte pour Questie.",
        ["koKR"] = "Questie 미니맵 아이콘을 표시합니다",
        ["ptBR"] = "Mostra/oculta o botão do minimapa para Questie",
        ["ruRU"] = "показать/скрыть кнопку у миникарты.",
        ["zhCN"] = "切换显示或隐藏Questie小地图图标",
        ["zhTW"] = "顯示小地圖按鈕",
    },
    ["Try to add markers for NPCs or objects to the map by search. If the \"tomap\" command is entered without subcommand it will attempt to mark the currently selected target. Searches by ID return exact matches, searches by name return partial matches. The \"reset\" subcommand does not accept additional parameters and just removes all markers."] = {
        ["enUS"] = true,
        ["deDE"] = "Versuche Markierungen für NPCs oder Objekte per Suche der Karte hinzuzufügen. Wenn der \"tomap\" Befehl ohne Unterbefehl eingegeben wird versucht er das aktuell ausgewählte Ziel zu markieren. Suchen per ID liefert exakte Treffer, suchen per Name liefert teilweise Treffer. Der \"reset\" Unterbefehl akzeptiert keine weiteren Parameter und entfernt einfach alle Markierungen.",
        ["esES"] = "Intenta agregar marcadores de PNJs u objetos al mapa mediante una búsqueda. Si el comando \"tomap\" se introduce sin subcomando, intentará marcar el objetivo actualmente seleccionado. Las búsquedas por ID devuelven coincidencias exactas, mientras que las búsquedas por nombre devuelven coincidencias parciales. El subcomando \"reset\" no acepta parámetros adicionales y simplemente elimina todos los marcadores.",
        ["esMX"] = "Intenta agregar marcadores de PNJs u objetos al mapa mediante una búsqueda. Si el comando \"tomap\" se introduce sin subcomando, intentará marcar el objetivo actualmente seleccionado. Las búsquedas por ID devuelven coincidencias exactas, mientras que las búsquedas por nombre devuelven coincidencias parciales. El subcomando \"reset\" no acepta parámetros adicionales y simplemente elimina todos los marcadores.",
        ["frFR"] = "Essayez d’ajouter des marqueurs pour les PNJs ou objets à la carte via une recherche. Si la commande \"tomap\" est utilisée sans sous-commande, elle essaiera de marquer la cible actuellement sélectionnée. Les recherches par ID donnent des correspondances exactes, celles par nom donnent des correspondances partielles. La sous-commande \"reset\" ne prend pas de paramètres supplémentaires et supprime simplement tous les marqueurs.",
        ["koKR"] = "검색에 따라 NPC 또는 오브젝트를 지도에 마킹합니다. 만약, \"tomap\" 명령이 하위 명령 없이 입력되었다면, 현재 선택된 대상을 마킹하려고 시도합니다. ID로 검색의 경우 완전히 일치하는 결과를 반환하며 이름으로 검색 시 부분적으로 일치한 결과만 반환합니다. \"reset\" 하위 명령은 추가 인수를 받지 않으며 항상 모든 마커를 제거합니다.",
        ["ptBR"] = "Tente adicionar marcadores de PNJs ou objetos ao mapa por meio de uma procura. Se o comando \"tomap\" for inserido sem subcomando, ele tentará marcar o alvo atualmente selecionado. Procuras por ID retornam correspondências exatas; procuras por nome retornam correspondências parciais. O subcomando \"reset\" não aceita parâmetros adicionais e apenas remove todos os marcadores.",
        ["ruRU"] = "Попробуйте добавить на карту метки для NPC или объектов с помощью поиска. Если команда \"tomap\" введена без подкоманды, она попытается отметить выбранную в данный момент цель. Поиск по ID возвращает точные совпадения, поиск по имени - частичные совпадения. Подкоманда \"reset\" не принимает дополнительных параметров и просто удаляет все маркеры.",
        ["zhCN"] = false,
        ["zhTW"] = "嘗試透過搜尋將 NPC 或物件圖示加到地圖上。若輸入 tomap 指令但未附加子指令，則會嘗試標記當前選取目標。依 ID 搜尋會得到完全符合的結果，依名稱搜尋則會得到部分符合的結果。reset 子指令不接受其他參數，只會移除所有標記。",
    },
    ["Invalid command. For a list of options please type:"] = {
        ["enUS"] = true,
        ["deDE"] = "Ungültiger Befehl. Für eine Liste aller verfügbaren Befehle nutze:",
        ["esES"] = "Comando inválido. Para una lista de comandos escribe:",
        ["esMX"] = "Comando inválido. Para una lista de opciones escribe:",
        ["frFR"] = "Commande invalide. Pour obtenir une liste d'options, veuillez taper :",
        ["koKR"] = "존재하지 않는 명령어입니다. 전체 명령어를 확인하시려면 다음과 같이 입력해주세요:",
        ["ptBR"] = "Comando inválido. Para uma lista de opções, digite:",
        ["ruRU"] = "Неверная команда. Для отображения списка команд наберите:",
        ["zhCN"] = "无效命令，要查看指令列表请输入：",
        ["zhTW"] = "無效的指令，要查看指令列表請輸入:",
    },
    ["An active target or search parameters are required."] = {
        ["enUS"] = true,
        ["deDE"] = "Ein aktives Ziel oder",
        ["esES"] = "Se requiere un objetivo activo o parámetros de búsqueda.",
        ["esMX"] = "Se requiere un objetivo activo o parámetros de búsqueda.",
        ["frFR"] = "Une cible active ou des paramètres de recherche sont requis.",
        ["koKR"] = "활성화된 대상 또는 검색 인수가 필요합니다.",
        ["ptBR"] = "É necessário um alvo ativo ou parâmetros de procura.",
        ["ruRU"] = "Требуется активная цель или параметры поиска.",
        ["zhCN"] = false,
        ["zhTW"] = "需要有選取的目標或是搜尋參數。",
    },
    ["All map markers cleared."] = {
        ["enUS"] = true,
        ["deDE"] = "Alle Kartenmarkierungen entfernt.",
        ["esES"] = "Todos los marcadores del mapa han sido eliminados.",
        ["esMX"] = "Todos los marcadores del mapa han sido eliminados.",
        ["frFR"] = "Tous les marqueurs de la carte ont été supprimés.",
        ["koKR"] = "모든 지도 마커가 제거 되었습니다.",
        ["ptBR"] = "Todos os marcadores do mapa foram removidos.",
        ["ruRU"] = "Все метки на карте удалены.",
        ["zhCN"] = false,
        ["zhTW"] = "所有地圖標記都已清除。",
    },
    ["Search term required."] = {
        ["enUS"] = true,
        ["deDE"] = "Suchbegriff benötigt",
        ["esES"] = "Se requiere un término de búsqueda.",
        ["esMX"] = "Se requiere un término de búsqueda.",
        ["frFR"] = "Un terme de recherche est requis.",
        ["koKR"] = "검색어가 필요합니다.",
        ["ptBR"] = "É necessário um termo de procura.",
        ["ruRU"] = "Требуется поисковый запрос.",
        ["zhCN"] = false,
        ["zhTW"] = "必須提供搜尋詞。",
    },
    ["Exact match found, added %s to map."] = {
        ["enUS"] = true,
        ["deDE"] = "Exakter Treffer gefunden, %s zur Karte hinzugefügt.",
        ["esES"] = "Coincidencia exacta encontrada, %s añadido al mapa.",
        ["esMX"] = "Coincidencia exacta encontrada, %s añadido al mapa.",
        ["frFR"] = "Correspondance exacte trouvée, %s ajouté à la carte.",
        ["koKR"] = "정확히 일치하는 결과가 발견되어, %s 를 지도에 추가했습니다.",
        ["ptBR"] = "Correspondência exata encontrada, %s adicionado ao mapa.",
        ["ruRU"] = "Точное соответствие найдено, добавлено на карту - %s.",
        ["zhCN"] = false,
        ["zhTW"] = "找到完全符合的項目，已將 %s 加到地圖上。",
    },
    ["No exact matches, %d partial matches found and added to map."] = {
        ["enUS"] = true,
        ["deDE"] = "Keine exakten Treffer, %d teilweise Treffer gefunden und zur Karte hinzugefügt.",
        ["esES"] = "No se encontraron coincidencias exactas, se encontraron %d coincidencias parciales y se añadieron al mapa.",
        ["esMX"] = "No se encontraron coincidencias exactas, se encontraron %d coincidencias parciales y se añadieron al mapa.",
        ["frFR"] = "Aucune correspondance exacte, %d correspondances partielles trouvées et ajoutées à la carte.",
        ["koKR"] = "정확히 일치하는 결과가 없었으나, 대신 %d 개의 부분일치 결과를 지도에 추가했습니다.",
        ["ptBR"] = "Nenhuma correspondência exata, %d correspondências parciais encontradas e adicionadas ao mapa.",
        ["ruRU"] = "Точных соответствий не найдено, найдено и добавлено на карту частичных соответствий - %d.",
        ["zhCN"] = false,
        ["zhTW"] = "沒有完全符合的項目，已找到 %d 個部分符合的項目並加入地圖。",
    },
    ["%d matches found and added to map."] = {
        ["enUS"] = true,
        ["deDE"] = "%d Treffer gefunden und zur Karte hinzugefügt.",
        ["esES"] = "%d coincidencias encontradas y añadidas al mapa.",
        ["esMX"] = "%d coincidencias encontradas y añadidas al mapa.",
        ["frFR"] = "%d correspondances trouvées et ajoutées à la carte.",
        ["koKR"] = "%d 개의 결과가 발견되어 지도에 추가했습니다.",
        ["ptBR"] = "%d correspondências encontradas e adicionadas ao mapa.",
        ["ruRU"] = "Соответствий найдено и добавлено на карту - %d.",
        ["zhCN"] = false,
        ["zhTW"] = "已找到 %d 個符合的項目並加入地圖。",
    },
    ["No match found, nothing added to map."] = {
        ["enUS"] = true,
        ["deDE"] = "Keine Treffer gefunden, nichts zur Karte hinzugefügt.",
        ["esES"] = "No se encontraron coincidencias, nada se añadió al mapa.",
        ["esMX"] = "No se encontraron coincidencias, nada se añadió al mapa.",
        ["frFR"] = "Aucune correspondance trouvée, rien n’a été ajouté à la carte.",
        ["koKR"] = "일치하는 결과가 없어 지도에 아무것도 추가되지 않았습니다.",
        ["ptBR"] = "Nenhuma correspondência encontrada, nada foi adicionado ao mapa.",
        ["ruRU"] = "Соответствие не найдено, ничего не добавлено на карту.",
        ["zhCN"] = false,
        ["zhTW"] = "沒有找到符合的項目，沒有東西加到地圖。",
    },
    ["Please wait a moment for Questie to finish loading"] = {
        ["enUS"] = true,
        ["deDE"] = "Bitte warte einen Moment bis Questie fertig geladen hat",
        ["esES"] = "Por favor, espera un momento a que Questie termine de cargar.",
        ["esMX"] = "Por favor, espera un momento a que Questie termine de cargar.",
        ["frFR"] = "Veuillez patienter un instant pendant que Questie termine son chargement.",
        ["koKR"] = "Questie 로드가 완료될 때까지 잠시 기다려 주세요.",
        ["ptBR"] = "Por favor, aguarde um momento enquanto o Questie termina de carregar.",
        ["ruRU"] = "Пожалуйста, подождите, пока Questie завершит загрузку.",
        ["zhCN"] = false,
        ["zhTW"] = "請稍候，讓 Questie 完成載入。",
    },
    ["There was a problem initializing Questie's database. This can usually be fixed by recompiling the database."] = {
        ["enUS"] = true,
        ["deDE"] = "Es gab ein Problem beim Initialisieren der Questie-Datenbank. Ein Neukompilieren der Datenbank behebt das Problem in der Regel.",
        ["esES"] = "Hubo un problema inicializando la base de datos de Questie. Esto generalmente se puede solucionar recompilando la base de datos.",
        ["esMX"] = "Hubo un problema inicializando la base de datos de Questie. Esto generalmente se puede solucionar recompilando la base de datos.",
        ["frFR"] = "Un problème est survenu lors de l'initialisation de la base de données de Questie. Cela peut généralement être résolu en recompilant la base de données.",
        ["koKR"] = "Questie 정보를 초기화하는동안 문제가 발생했습니다. 일반적으로 정보를 다시 편집하여 수정 할 수 있습니다.",
        ["ptBR"] = "Ocorreu um problema ao inicializar o banco de dados de Questie. Isso geralmente pode ser consertado recompilando o banco de dados.",
        ["ruRU"] = "Выявлена проблема при инициализации базы данных Questie. Обычно это может быть исправлено путем рекомпиляции БД.",
        ["zhCN"] = "初始化 Questie 的数据库时出现问题。 通常可以通过重新编辑数据库来解决问题。",
        ["zhTW"] = "初始化 Questie 的資料庫時發生問題，通常可以藉由重建資料庫來解決。",
    },
    ["There was an error populating objectives for %s %s %s %s"] = {
        ["enUS"] = true,
        ["deDE"] = "Es gab einen Fehler beim Weitergeben der Ziele für %s %s %s %s",
        ["esES"] = "Se produjo un error al obtener los objetivos para %s %s %s %s",
        ["esMX"] = "Se produjo un error al obtener los objetivos para %s %s %s %s",
        ["frFR"] = "Une erreur s'est produite lors de la création des objectifs pour %s %s %s %s",
        ["koKR"] = "%s %s %s %s 에 대한 목표를 진행하는 동안 오류가 발생했습니다.",
        ["ptBR"] = "Ocorreu um erro ao popular objetivos para %s %s %s %s",
        ["ruRU"] = "Ошибка получения целей: %s %s %s %s",
        ["zhCN"] = "在为 %s %s %s %s 加载任务目标时发生错误",
        ["zhTW"] = "在為 %s %s %s %s 載入任務目標時發生錯誤",
    },
    ["Error: Questie tracker in invalid location, resetting..."] = {
        ["enUS"] = true,
        ["deDE"] = "Fehler: Der Questie-Tracker ist in einer ungültigen Position und wird zurückgesetzt...",
        ["esES"] = "Error: Rastreador en ubicación inválida, restableciendo...",
        ["esMX"] = "Error: Rastreador en ubicación inválida, restableciendo...",
        ["frFR"] = "Erreur : suivi des quêtes de Questie dans un endroit non valide, réinitialisation...",
        ["koKR"] = "에러: Questie 추적기가 허용되지 않은 위치에 있습니다, 재설정 중...",
        ["ptBR"] = "Erro: Rastreador de Questie em um local inválido, redefinindo...",
        ["ruRU"] = "Ошибка: трекер Questie в неправильном положении, сброс...",
        ["zhCN"] = "错误：Questie任务追踪的框架跑到奇怪的地方去了，重置一下......",
        ["zhTW"] = "錯誤: Questie 的任務追蹤清單跑到奇怪的地方去了，正在重置...",
    },
    ["Setting icon limit value to %s : Redrawing!"] = {
        ["enUS"] = true,
        ["deDE"] = "Icon Limit geändert auf %s : Zeichne neu!",
        ["esES"] = "Estableciendo el límite del icono a %s : ¡Rediseñando!",
        ["esMX"] = "Estableciendo el límite del icono a %s : ¡Rediseñando!",
        ["frFR"] = "Définition de la valeur limite de l'icône sur %s : Redessiner !",
        ["koKR"] = "아이콘 제한 값을 %s 로 설정하는중 : Redrawing!",
        ["ptBR"] = "Definindo o valor limite do ícone como %s : Redesenhar!",
        ["ruRU"] = "Ограничение количества значков: %s. Перерисовка!",
        ["zhCN"] = "图标限制值设置为 %s : 重新绘制中!",
        ["zhTW"] = "圖示數量限制為 %s : 重新繪製中!",
    },
    ["Questie DB has updated!"] = {
        ["enUS"] = true,
        ["deDE"] = "Questie DB wurde aktualisiert!",
        ["esES"] = "¡La base de datos de Questie se ha actualizado!",
        ["esMX"] = "¡La base de datos de Questie se ha actualizado!",
        ["frFR"] = "La base de données Questie a été mise à jour !",
        ["koKR"] = "Questie DB가 업데이트되었습니다!",
        ["ptBR"] = "O banco de dados de Questie foi atualizado!",
        ["ruRU"] = "База данных Questie обновляется!",
        ["zhCN"] = "Questie 数据库已更新!",
        ["zhTW"] = "Questie 資料庫已更新!",
    },
    ["Data is being processed, this may take a few moments and cause some lag..."] = {
        ["enUS"] = true,
        ["deDE"] = "Die Daten werden verarbeitet, dies kann einige Momente dauern und etwas Lag verursachen...",
        ["esES"] = "Los datos se están procesando, esto puede demorar unos minutos y causar latencia...",
        ["esMX"] = "Los datos se están procesando, esto puede demorar unos minutos y causar latencia...",
        ["frFR"] = "Application de la mise à jour, cela peut prendre quelques instants et causer quelques lags...",
        ["koKR"] = "데이터가 처리중입니다. 이 작업은 몇 분 정도 걸릴 수 있으며, 약간의 지연이 발생할 수 있습니다.",
        ["ptBR"] = "Os dados estão sendo processados, isso pode levar alguns instantes e causar alguma latência...",
        ["ruRU"] = "Данные обрабатываются, это может занять некоторое время и стать причиной зависаний...",
        ["zhCN"] = "数据正在处理中，这可能需要一些时间，并会导致一些延迟...",
        ["zhTW"] = "正在處理資料，這會需要一點時間，並且會造成一些延遲...",
    },
    ["Updating NPCs"] = {
        ["enUS"] = true,
        ["deDE"] = "Aktualisiere NPCs",
        ["esES"] = "Actualizando PNJs",
        ["esMX"] = "Actualizando PNJs",
        ["frFR"] = "Mise à jour des PNJs",
        ["koKR"] = "NPC 업데이트중",
        ["ptBR"] = "Atualizando NPCs",
        ["ruRU"] = "Обновление NPC",
        ["zhCN"] = "正在更新 NPC 数据",
        ["zhTW"] = "正在更新 NPC 資料",
    },
    ["Updating objects"] = {
        ["enUS"] = true,
        ["deDE"] = "Aktualisiere Objekte",
        ["esES"] = "Actualizando objetos",
        ["esMX"] = "Actualizando objetos",
        ["frFR"] = "Mise à jour des objets",
        ["koKR"] = "정보 업데이트중",
        ["ptBR"] = "Atualizando objetos",
        ["ruRU"] = "Обновление объектов",
        ["zhCN"] = "正在更新物体数据",
        ["zhTW"] = "正在更新物體資料",
    },
    ["Updating quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Aktualisiere Quests",
        ["esES"] = "Actualizando misiones",
        ["esMX"] = "Actualizando misiones",
        ["frFR"] = "Mise à jour des quêtes",
        ["koKR"] = "퀘스트 업데이트중",
        ["ptBR"] = "Atualizando missões",
        ["ruRU"] = "Обновление заданий",
        ["zhCN"] = "正在更新 任务 数据",
        ["zhTW"] = "正在更新任務資料",
    },
    ["Loading database"] = {
        ["enUS"] = true,
        ["deDE"] = "Datenbank wird geladen",
        ["esES"] = "Cargando la base de datos",
        ["esMX"] = "Cargando la base de datos",
        ["frFR"] = "Chargement de la base de données",
        ["koKR"] = "데이터베이스 로드 중",
        ["ptBR"] = "Carregando o banco de dados",
        ["ruRU"] = "Загрузка базы данных",
        ["zhCN"] = "加载数据库中",
        ["zhTW"] = "正在載入資料庫",
    },
    ["Applying database corrections"] = {
        ["enUS"] = true,
        ["deDE"] = "Datenbankkorrekturen werden eingespielt",
        ["esES"] = "Aplicando correcciones a la base de datos",
        ["esMX"] = "Aplicando correcciones a la base de datos",
        ["frFR"] = "Application des correctifs de la base de données",
        ["koKR"] = "데이터베이스 수정 적용중",
        ["ptBR"] = "Aplicando correções ao banco de dados",
        ["ruRU"] = "Применение исправлений БД",
        ["zhCN"] = "更新数据库中",
        ["zhTW"] = "正在校正資料庫",
    },
    ["Initializing locale"] = {
        ["enUS"] = true,
        ["deDE"] = "Übersetzungen werden geladen",
        ["esES"] = "Inicializando idioma",
        ["esMX"] = "Inicializando idioma",
        ["frFR"] = "Initialisation de la langue",
        ["koKR"] = "Locale 데이터 설치중",
        ["ptBR"] = "Inicializando idioma",
        ["ruRU"] = "Определение языка игры",
        ["zhCN"] = "初始化语系",
        ["zhTW"] = "正在初始化語系",
    },
    ["Initializing townfolks"] = {
        ["enUS"] = true,
        ["deDE"] = "Initialisiere Stadtbewohner",
        ["esES"] = "Inicializando aldeanos",
        ["esMX"] = "Inicializando aldeanos",
        ["frFR"] = "Initialisation des villageois",
        ["koKR"] = "도시 NPC 초기화 중",
        ["ptBR"] = "Inicializando aldeões",
        ["ruRU"] = "Инициализация полезных объектов и NPC (ремонт, почтовый ящик и т.п.)",
        ["zhCN"] = "初始化镇民",
        ["zhTW"] = "正在初始化村民",
    },
    ["Optimizing waypoints"] = {
        ["enUS"] = true,
        ["deDE"] = "Optimiere Wegpunkte",
        ["esES"] = "Optimizando puntos de ruta",
        ["esMX"] = "Optimizando puntos de ruta",
        ["frFR"] = "Optimisation des points de cheminement",
        ["koKR"] = "웨이 포인트 조정 중",
        ["ptBR"] = "Otimizando pontos de rota",
        ["ruRU"] = "Оптимизация путевых точек",
        ["zhCN"] = "初始化地点",
        ["zhTW"] = "正在初始化地點",
    },
    ["Updating items"] = {
        ["enUS"] = true,
        ["deDE"] = "Aktualisiere Gegenstände",
        ["esES"] = "Actualizando objetos",
        ["esMX"] = "Actualizando objetos",
        ["frFR"] = "Mise à jour des objets",
        ["koKR"] = "아이템정보 업데이트중",
        ["ptBR"] = "Atualizando itens",
        ["ruRU"] = "Обновление предметов",
        ["zhCN"] = "正在更新物品信息",
        ["zhTW"] = "正在更新物品資訊",
    },
    ["Questie DB update complete!"] = {
        ["enUS"] = true,
        ["deDE"] = "Questie Datenbank-Update abgeschlossen!",
        ["esES"] = "¡Actualización de la base de datos de Questie completada!",
        ["esMX"] = "¡Actualización de la base de datos de Questie completada!",
        ["frFR"] = "La base de données Questie a été mise à jour !",
        ["koKR"] = "Questie DB 업데이트 완료!",
        ["ptBR"] = "Atualização do banco de dados de Questie concluída!",
        ["ruRU"] = "Обновление базы данных Questie завершено!",
        ["zhCN"] = "Questie 数据库更新完成!",
        ["zhTW"] = "Questie 資料庫更新完畢!",
    },
    ["%s for %s!"] = {
        ["enUS"] = true,
        ["deDE"] = "%s für %s!",
        ["esES"] = "¡%s para %s!",
        ["esMX"] = "¡%s para %s!",
        ["frFR"] = "%s pour %s !",
        ["koKR"] = "%s 위한 %s!",
        ["ptBR"] = "%s para %s!",
        ["ruRU"] = "%s для %s!",
        ["zhCN"] = "%s 任务： %s!",
        ["zhTW"] = "%s 任務 %s!",
    },
    ["Picked up %s which starts %s!"] = {
        ["enUS"] = true,
        ["deDE"] = "%s aufgehoben, das %s startet!",
        ["esES"] = "¡Recogió %s que inicia %s!",
        ["esMX"] = "¡Recogió %s que inicia %s!",
        ["frFR"] = "Ramassé %s qui démarre %s !",
        ["koKR"] = "%s 를 획득하여, 이제 %s 를 시작할 수 있습니다!",
        ["ptBR"] = "Pegou %s que inicia %s!",
        ["ruRU"] = "Получен предмет %s, который начинает задание %s",
        ["zhCN"] = "拾取 %s 自动接受任务： %s!",
        ["zhTW"] = "拾取 %s 自動接受任務 %s!",
    },
    ["You picked up %s which starts %s!"] = {
        ["enUS"] = true,
        ["deDE"] = "Du hast %s aufgehoben, das %s startet!",
        ["esES"] = "¡Recogiste %s que inicia %s!",
        ["esMX"] = "¡Recogiste %s que inicia %s!",
        ["frFR"] = "Vous avez ramassé %s qui démarre %s !",
        ["koKR"] = "%s 을(를) 시작하는 %s 을(를) 수락했습니다",
        ["ptBR"] = "Você pegou %s que inicia %s!",
        ["ruRU"] = "Вы получили предмет %s, который начинает задание %s",
        ["zhCN"] = "你拾取了 %s 自动接受任务 %s!",
        ["zhTW"] = "你拾取 %s 自動接受任務 %s!",
    },
    ["The '%s' world event is active!"] = {
        ["enUS"] = true,
        ["deDE"] = "Das '%s' Feiertag-Event ist aktiv!",
        ["esES"] = "¡El evento del mundo '%s' está activo!",
        ["esMX"] = "¡El evento del mundo '%s' está activo!",
        ["frFR"] = "L'évènement mondial '%s' est actif !",
        ["koKR"] = "월드 이벤트 '%s' 활성화",
        ["ptBR"] = "O evento mundial '%s' está ativo!",
        ["ruRU"] = "Игровое событие '%s' активно!",
        ["zhCN"] = "世界任务 '%s' 已开始!",
        ["zhTW"] = "世界事件 '%s' 已開始!",
    },
    ["Error during initialization!"] = {
        ["enUS"] = true,
        ["deDE"] = "Fehler während der Initialisierung!",
        ["esES"] = "¡Error durante la inicialización!",
        ["esMX"] = "¡Error durante la inicialización!",
        ["frFR"] = "Erreur durant l'initialisation !",
        ["koKR"] = "설치중에 에러 발생!",
        ["ptBR"] = "Erro durante inicialização!",
        ["ruRU"] = "Ошибка во время инициализации!",
        ["zhCN"] = "初始化时发生错误!",
        ["zhTW"] = "初始化時發生錯誤!",
    },
    ["The quest %s is missing from Questie's database. Please report this on GitHub or Discord!"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Quest %s fehlt in Questie's Datenbank. Bitte melde dies auf GitHub oder Discord!",
        ["esES"] = "Falta la misión %s en la base de datos de Questie. ¡Por favor, infórmalo en GitHub o Discord!",
        ["esMX"] = "Falta la misión %s en la base de datos de Questie. ¡Por favor, infórmalo en GitHub o Discord!",
        ["frFR"] = "La quête %s n'est pas présente dans la Base de données Questie. Veuillez le signaler sur GitHub ou Discord !",
        ["koKR"] = "해당 퀘스트 %s 는 퀘스티 데이터베이스에서 찾을 수 없습니다. Github/Discord에 리포트 부탁드립니다!",
        ["ptBR"] = "A missão %s está faltando no banco de dados de Questie. Por favor, informe isso no GitHub ou Discord!",
        ["ruRU"] = "Задание %s отсутствует в БД Questie. Пожалуйста, сообщите нам об этом на GitHub или в Discord!",
        ["zhCN"] = "Questie 数据库中缺少的任务 %s，请到 GitHub 或 Discord 上报告，谢谢!",
        ["zhTW"] = "Questie 的資料庫中沒有這個任務 %s，請到 GitHub 或 Discord 做回報!",
    },
    ["Coordinates addon is enabled and will cause buggy behavior. Disabling global map and mini map coordinates. These can be re-enabled in settings"] = {
        ["enUS"] = true,
        ["deDE"] = "Koordinaten-AddOn aktiviert und verursacht fehlerhaftes Verhalten. Deaktiviere globale Karten- und Minikarten-Koordinaten. Diese können in den Einstellungen wieder aktiviert werden.",
        ["esES"] = "El addon de coordenadas está activado y provocará un comportamiento con errores. Está desactivando las coordenadas del mapa del mundo y del minimapa. Estos se pueden volver a activar en la configuración.",
        ["esMX"] = "El addon de coordenadas está activado y provocará un comportamiento con errores. Está desactivando las coordenadas del mapa del mundo y del minimapa. Estos se pueden volver a activar en la configuración.",
        ["frFR"] = "L'add-on de coordonnées est activé et causera un comportement erratique. Désactivation des coordonnées de la carte globale et de la minicarte. Elles peuvent être réactivées dans les paramètres.",
        ["koKR"] = "좌표 애드온이 활성화 되어 버그가 발생할 수 있습니다. 세계 지도 및 미니맵 좌표를 해제하였습니다. 해당 옵션은 퀘스티 옵션에서 다시 켤 수 있습니다.",
        ["ptBR"] = "O addon de coordenadas está ativado e causará comportamento defeituoso. Desativando coordenadas do mapa-múndi e do minimapa. Estas podem ser reativadas nas configurações.",
        ["ruRU"] = "Включен другой аддон с координатами, это может вызвать ошибки. Во избежание этого Questie сейчас отключает координаты на карте мира и миникарте. Это может быть переопределено в настройках",
        ["zhCN"] = "已使用其他坐标插件，可能因发生冲突而影响游戏。请停用世界地图和小地图坐标，日后都可以在设定中重新启用。",
        ["zhTW"] = "已有使用其他座標插件，可能會發生衝突而影響遊戲。請停用世界地圖和小地圖座標，日後都可以在設定中重新啟用。",
    },
    ["Missing objective data for quest "] = {
        ["enUS"] = true,
        ["deDE"] = "Fehlende Ziel-Daten für Quest ",
        ["esES"] = "Faltan datos de objetivos para la misión ",
        ["esMX"] = "Faltan datos de objetivos para la misión ",
        ["frFR"] = "Données d'objectif manquantes pour la quête ",
        ["koKR"] = "퀘스트를 위한 오브젝트 데이터가 없습니다",
        ["ptBR"] = "Dados de objetivo ausentes para a missão ",
        ["ruRU"] = "Отсутствует информация о цели задания ",
        ["zhCN"] = "缺少目标数据，任务：",
        ["zhTW"] = "缺少目標資料，任務：",
    },
    ["Prints whether you are eligibile to do a quest"] = {
        ["enUS"] = true,
        ["deDE"] = "Gibt aus, ob eine Quests angenommen werden kann",
        ["esES"] = "Indica si eres elegible para hacer una misión",
        ["esMX"] = "Indica si eres elegible para hacer una misión",
        ["frFR"] = "Indique si vous êtes éligible pour faire une quête",
        ["koKR"] = "해당 퀘스트를 수행하기 적절한지 표시합니다",
        ["ptBR"] = "Indica se você é elegível para fazer uma missão",
        ["ruRU"] = "Выводит информацию о том, можете ли вы выполнить задание",
        ["zhCN"] = "显示你是否有资格接取任务",
        ["zhTW"] = "顯示你是否符合做任務的條件",
    },
    ["Prints Questie and client version info"] = {
        ["enUS"] = true,
        ["deDE"] = "Gibt die Questie- und Client-Version aus",
        ["esES"] = "Muestra la información de la versión del cliente y Questie",
        ["esMX"] = "Muestra la información de la versión del cliente y Questie",
        ["frFR"] = "Affiche des informations sur la version de Questie et du client",
        ["koKR"] = "퀘스티와 클라이언트 버전 정보를 표시합니다",
        ["ptBR"] = "Mostra informações sobre a versão de Questie e do cliente",
        ["ruRU"] = "Выводит информацию о версиях Questie и клиента",
        ["zhCN"] = "打印 Questie 和客户端的版本信息",
        ["zhTW"] = "顯示 Questie 和遊戲版本資訊",
    },
    -- Debug Offers
    ["Questie Debug Info"] = {
        ["enUS"] = true,
        ["deDE"] = "Questie Debug-Info",
        ["esES"] = "Información de depuración de Questie",
        ["esMX"] = "Información de depuración de Questie",
        ["frFR"] = "Informations de débogage de Questie",
        ["koKR"] = "퀘스티 디버그 정보",
        ["ptBR"] = "Informações de depuração de Questie",
        ["ruRU"] = "Отладочная информация",
        ["zhCN"] = "Questie 调试信息",
        ["zhTW"] = "Questie 除錯資訊",
    },
    ["Please share this info with us on"] = {
        ["enUS"] = true,
        ["deDE"] = "Bitte teile diese Informationen mit uns auf",
        ["esES"] = "Por favor comparte esta información con nosotros en",
        ["esMX"] = "Por favor comparte esta información con nosotros en",
        ["frFR"] = "S'il vous plaît, partagez ces informations avec nous",
        ["koKR"] = "해당 정보를 우리와 공유해 주세요: ",
        ["ptBR"] = "Por favor, compartilhe essas informações conosco",
        ["ruRU"] = "Пожалуйста, поделитесь с нами этой информацией",
        ["zhCN"] = "请在以下平台上与我们分享此信息：",
        ["zhTW"] = "請將此資訊分享給我們，在",
    },
    ["You can copy the data above"] = {
        ["enUS"] = true,
        ["deDE"] = "Du kannst die Daten oben kopieren",
        ["esES"] = "Puedes copiar los datos de arriba",
        ["esMX"] = "Puedes copiar los datos de arriba",
        ["frFR"] = "Vous pouvez copier les données ci-dessus",
        ["koKR"] = "상기의 데이터를 복사할 수 있습니다",
        ["ptBR"] = "Você pode copiar os dados acima",
        ["ruRU"] = "Вы можете скопировать эти данные выше",
        ["zhCN"] = "你可以复制上面的数据",
        ["zhTW"] = "你可以複製上方的資料",
    },
    ["Would you like to help us fix it?"] = {
        ["enUS"] = true,
        ["deDE"] = "Möchtest du uns dabei helfen, dies zu fixen?",
        ["esES"] = "¿Quieres ayudarnos a solucionarlo?",
        ["esMX"] = "¿Quieres ayudarnos a solucionarlo?",
        ["frFR"] = "Souhaitez-vous nous aider à le réparer ?",
        ["koKR"] = "해당 문제를 해결하기 위해 우리를 도와줄 수 있습니까?",
        ["ptBR"] = "Gostaria de nos ajudar a consertar isso?",
        ["ruRU"] = "Хотите ли вы помочь нам исправить это?",
        ["zhCN"] = "你愿意帮我们修复它吗？",
        ["zhTW"] = "是否願意協助我們修正?",
    },
    ["More Info"] = {
        ["enUS"] = true,
        ["deDE"] = "Mehr Infos",
        ["esES"] = "Más información",
        ["esMX"] = "Más información",
        ["frFR"] = "Plus d'informations",
        ["koKR"] = "더보기",
        ["ptBR"] = "Mais informações",
        ["ruRU"] = "Больше информации",
        ["zhCN"] = "更多信息",
        ["zhTW"] = "更多資訊",
    },
    ["An item you just encountered has data missing from the Questie database."] = {
        ["enUS"] = true,
        ["deDE"] = "Ein Gegenstand, den du gerade gefunden hast, fehlt in der Questie-Datenbank.",
        ["esES"] = "Un objeto que acabas de encontrar tiene datos faltantes en la base de datos de Questie.",
        ["esMX"] = "Un objeto que acabas de encontrar tiene datos faltantes en la base de datos de Questie.",
        ["frFR"] = "Un objet que vous venez de rencontrer présente des données manquantes dans la base de données de Questie.",
        ["koKR"] = "방금 획득한 아이템은 퀘스티 데이터베이스에 등록되지 않은 아이템입니다",
        ["ptBR"] = "Um item que você acabou de encontrar está com dados faltando no banco de dados de Questie.",
        ["ruRU"] = "Обнаруженный вами предмет отсутствует в БД Questie.",
        ["zhCN"] = "你刚刚遇到的一个物品在 Questie 数据库中缺失数据。",
        ["zhTW"] = "Questie 資料庫中缺少你剛才遇到的物品的資料。",
    },
    ["A quest you just encountered is missing from the Questie database."] = {
        ["enUS"] = true,
        ["deDE"] = "Eine Quest, die du gerade gefunden hast, fehlt in der Questie-Datenbank.",
        ["esES"] = "Una misión que acabas de encontrar no se encuentra en la base de datos de Questie.",
        ["esMX"] = "Una misión que acabas de encontrar no se encuentra en la base de datos de Questie.",
        ["frFR"] = "Une quête que vous venez de rencontrer est manquante dans la base de données de Questie.",
        ["koKR"] = "방금 수락한 퀘스트는 퀘스티 데이터베이스에 등록되지 않은 퀘스트입니다.",
        ["ptBR"] = "Uma missão que você acabou de encontrar está faltando no banco de dados de Questie.",
        ["ruRU"] = "Обнаруженное вами задание отсутствует в БД Questie.",
        ["zhCN"] = "你刚刚遇到的任务在 Questie 数据库中缺失数据。",
        ["zhTW"] = "你剛才遇到的任務是 Questie 資料庫中所缺少的。",
    },
    ["A quest in your quest log is missing from the Questie database and can't be tracked."] = {
        ["enUS"] = true,
        ["deDE"] = "Eine Quest in deinem Questlog fehlt in der Questie-Datenbank und kann nicht verfolgt werden.",
        ["esES"] = "Falta una misión en tu registro de misiones en la base de datos de Questie y no se puede rastrear.",
        ["esMX"] = "Falta una misión en tu registro de misiones en la base de datos de Questie y no se puede rastrear.",
        ["frFR"] = "Une quête dans votre journal de quêtes est manquante dans la base de données de Questie et ne peut pas être suivie.",
        ["koKR"] = "퀘스트 목록에 퀘스티 데이터베이스에 등록되지 않은 퀘스트가 있어 추적이 불가능합니다",
        ["ptBR"] = "Uma missão no seu registro de missões está faltando no banco de dados de Questie e não pode ser rastreada.",
        ["ruRU"] = "Задание в вашем журнале отсутствует в БД Questie и не может быть отслежено.",
        ["zhCN"] = "你的任务日志中的一个任务在 Questie 数据库中缺失，因此无法被追踪。",
        ["zhTW"] = "任務日誌中的任務是 Questie 資料庫中所缺少的，無法追蹤任務。",
    },
    ["The NPC you just targeted is missing from the Questie database."] = {
        ["enUS"] = true,
        ["deDE"] = "Der NPC, den du gerade anvisiert hast, fehlt in der Questie-Datenbank.",
        ["esES"] = "El PNJ al que acabas de apuntar no se encuentra en la base de datos de Questie.",
        ["esMX"] = "El PNJ al que acabas de apuntar no se encuentra en la base de datos de Questie.",
        ["frFR"] = "Le PNJ que vous venez de cibler est manquant dans la base de données de Questie.",
        ["koKR"] = "방금 선택한 NPC는 퀘스티 데이터베이스에 존재하지 않습니다",
        ["ptBR"] = "O NPC que você acabou de mirar está faltando no banco de dados de Questie.",
        ["ruRU"] = "NPC, которого вы только что взяли в цель, отсутствует в БД Questie",
        ["zhCN"] = "你刚刚选中的 NPC 在 Questie 数据库中缺失数据。",
        ["zhTW"] = "你剛才選為目標的 NPC 是 Questie 資料庫中所缺少的。",
    },
}

for k, v in pairs(debugMessagesLocales) do
    l10n.translations[k] = v
end
