---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local genericsLocales = {
    ["Objects"] = {
        ["enUS"] = true,
        ["deDE"] = "Objekte",
        ["esES"] = "Objetos",
        ["esMX"] = "Objetos",
        ["frFR"] = "Objets",
        ["koKR"] = "목표",
        ["ptBR"] = "Objetos",
        ["ruRU"] = "Объекты",
        ["zhCN"] = "物体",
        ["zhTW"] = "物體",
    },
    ["Objective"] = {
        ["enUS"] = true,
        ["deDE"] = "Questziel",
        ["esES"] = "Objetivo",
        ["esMX"] = "Objetivo",
        ["frFR"] = "Objectif",
        ["koKR"] = "목표",
        ["ptBR"] = "Objetivo",
        ["ruRU"] = "Цели",
        ["zhCN"] = "目标",
        ["zhTW"] = "目標",
    },
    ["Objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "Questziele",
        ["esES"] = "Objetivos",
        ["esMX"] = "Objetivos",
        ["frFR"] = "Objectifs",
        ["koKR"] = "목표",
        ["ptBR"] = "Objetivos",
        ["ruRU"] = "Цели заданий",
        ["zhCN"] = "目标",
        ["zhTW"] = "目標",
    },
    ["Quests"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "Misiones",
        ["esMX"] = "Misiones",
        ["frFR"] = "Quêtes",
        ["koKR"] = "퀘스트",
        ["ptBR"] = "Missões",
        ["ruRU"] = "Задания",
        ["zhCN"] = "任务",
        ["zhTW"] = "任務",
    },
    ["Show Questie"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeige Questie",
        ["esES"] = "Mostrar Questie",
        ["esMX"] = "Mostrar Questie",
        ["frFR"] = "Afficher Questie",
        ["koKR"] = "Questie 표시",
        ["ptBR"] = "Mostrar Questie",
        ["ruRU"] = "Показать Questie",
        ["zhCN"] = "显示Questie",
        ["zhTW"] = "顯示任務圖示",
    },
    ["Hide Questie"] = {
        ["enUS"] = true,
        ["deDE"] = "Verstecke Questie",
        ["esES"] = "Ocultar Questie",
        ["esMX"] = "Ocultar Questie",
        ["frFR"] = "Cacher Questie",
        ["koKR"] = "Questie 숨기기",
        ["ptBR"] = "Ocultar Questie",
        ["ruRU"] = "Скрыть Questie",
        ["zhCN"] = "隐藏Questie",
        ["zhTW"] = "隱藏任務圖示",
    },
    ["Reload UI"] = {
        ["enUS"] = true,
        ["deDE"] = "Interface neu laden",
        ["esES"] = "Recargar IU",
        ["esMX"] = "Recargar IU",
        ["frFR"] = "Recharger l'interface",
        ["koKR"] = "Reload UI",
        ["ptBR"] = "Recarregar interface",
        ["ruRU"] = "Перезагрузка",
        ["zhCN"] = "重载UI",
        ["zhTW"] = "重新載入介面",
    },
    ["Yes"] = {
        ["enUS"] = true,
        ["deDE"] = "Ja",
        ["esES"] = "Sí",
        ["esMX"] = "Sí",
        ["frFR"] = "Oui",
        ["koKR"] = "예",
        ["ptBR"] = "Sim",
        ["ruRU"] = "Да",
        ["zhCN"] = "是",
        ["zhTW"] = "是",
    },
    ["No"] = {
        ["enUS"] = true,
        ["deDE"] = "Nein",
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = "Non",
        ["koKR"] = "아니오",
        ["ptBR"] = "Não",
        ["ruRU"] = "Нет",
        ["zhCN"] = "否",
        ["zhTW"] = "否",
    },
    ["Cancel"] = {
        ["enUS"] = true,
        ["deDE"] = "Abbrechen",
        ["esES"] = "Cancelar",
        ["esMX"] = "Cancelar",
        ["frFR"] = "Annuler",
        ["koKR"] = "취소",
        ["ptBR"] = "Cancelar",
        ["ruRU"] = "Отмена",
        ["zhCN"] = "取消",
        ["zhTW"] = "取消",
    },
    ["Don't show again"] = {
        ["enUS"] = true,
        ["deDE"] = "Nicht erneut zeigen",
        ["esES"] = "No volver a mostrar",
        ["esMX"] = "No volver a mostrar",
        ["frFR"] = "Ne plus afficher",
        ["koKR"] = "다시 보이지 않기",
        ["ptBR"] = "Não mostrar novamente",
        ["ruRU"] = "Не отображать снова",
        ["zhCN"] = "不在显示",
        ["zhTW"] = "不再顯示",
    },
    ["Auto"] = {
        ["enUS"] = true,
        ["deDE"] = "Automatisch",
        ["esES"] = "Automático",
        ["esMX"] = "Automático",
        ["frFR"] = "Automatique",
        ["koKR"] = "자동",
        ["ptBR"] = "Automático",
        ["ruRU"] = "Авто",
        ["zhCN"] = "自动",
        ["zhTW"] = "自動",
    },
    ["Manual"] = {
        ["enUS"] = true,
        ["deDE"] = "Manuell",
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "수동",
        ["ptBR"] = true,
        ["ruRU"] = "Вручную",
        ["zhCN"] = "手动的",
        ["zhTW"] = "手動",
    },
    ["Enabled"] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert",
        ["esES"] = "Activado",
        ["esMX"] = "Activado",
        ["frFR"] = "Activé",
        ["koKR"] = "활성화",
        ["ptBR"] = "Ativado",
        ["ruRU"] = "Включено",
        ["zhCN"] = "已启用",
        ["zhTW"] = "已啟用",
    },
    ["Disabled"] = {
        ["enUS"] = true,
        ["deDE"] = "Deaktiviert",
        ["esES"] = "Desactivado",
        ["esMX"] = "Desactivado",
        ["frFR"] = "Désactivé",
        ["koKR"] = "비활성화",
        ["ptBR"] = "Desativado",
        ["ruRU"] = "Отключено",
        ["zhCN"] = "停用",
        ["zhTW"] = "已停用",
    },
    ["WARNING!"] = {
        ["enUS"] = true,
        ["deDE"] = "WARNUNG!",
        ["esES"] = "¡ADVERTENCIA!",
        ["esMX"] = "¡ADVERTENCIA!",
        ["frFR"] = "ATTENTION !",
        ["koKR"] = "경고!",
        ["ptBR"] = "ATENÇÃO!",
        ["ruRU"] = "ВНИМАНИЕ!",
        ["zhCN"] = "警告！",
        ["zhTW"] = "警告！",
    },
    ["xp"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "exp",
        ["esMX"] = "exp",
        ["frFR"] = "exp",
        ["koKR"] = "경험치",
        ["ptBR"] = "exp",
        ["ruRU"] = " опыта",
        ["zhCN"] = "经验",
        ["zhTW"] = "經驗值",
    },
    ["Alliance"] = {
        ["enUS"] = true,
        ["deDE"] = "Allianz",
        ["esES"] = "Alianza",
        ["esMX"] = "Alianza",
        ["frFR"] = true,
        ["koKR"] = "얼라이언스",
        ["ptBR"] = "Aliança",
        ["ruRU"] = "Альянс",
        ["zhCN"] = "联盟",
        ["zhTW"] = "聯盟",
    },
    ["Horde"] = {
        ["enUS"] = true,
        ["deDE"] = "Horde",
        ["esES"] = "Horda",
        ["esMX"] = "Horda",
        ["frFR"] = "Horde",
        ["koKR"] = "호드",
        ["ptBR"] = "Horda",
        ["ruRU"] = "Орда",
        ["zhCN"] = "部落",
        ["zhTW"] = "部落",
    },
    ["Quest ID"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest ID",
        ["esES"] = "ID de misión",
        ["esMX"] = "ID de misión",
        ["frFR"] = "ID de la quête",
        ["koKR"] = "퀘스트 ID",
        ["ptBR"] = "ID da missão",
        ["ruRU"] = "ID задания",
        ["zhCN"] = "任务 ID",
        ["zhTW"] = "任務 ID",
    },
    ["Quest Level"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest-Level",
        ["esES"] = "Nivel de misión",
        ["esMX"] = "Nivel de misión",
        ["frFR"] = "Niveau de la quête",
        ["koKR"] = "퀘스트 레벨",
        ["ptBR"] = "Nível da missão",
        ["ruRU"] = "Уровень задания",
        ["zhCN"] = "任务等级",
        ["zhTW"] = "任務等級",
    },
    ["Quest Details"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest-Details",
        ["esES"] = "Detalles de misión",
        ["esMX"] = "Detalles de misión",
        ["frFR"] = "Détails de la quête",
        ["koKR"] = "퀘스트 상세정보",
        ["ptBR"] = "Detalhes da missão",
        ["ruRU"] = "Подробности задания",
        ["zhCN"] = "任务详细信息",
        ["zhTW"] = "任務詳細資訊",
    },
    ["NPC Details"] = {
        ["enUS"] = true,
        ["deDE"] = "NPC-Details",
        ["esES"] = "Detalles del PNJ",
        ["esMX"] = "Detalles del PNJ",
        ["frFR"] = "Détails du PNJ",
        ["koKR"] = "NPC 상세정보",
        ["ptBR"] = "Detalhes do NPC",
        ["ruRU"] = "Подробности о NPC",
        ["zhCN"] = "NPC 详细信息",
        ["zhTW"] = "NPC 詳細資訊",
    },
    ["Object Details"] = {
        ["enUS"] = true,
        ["deDE"] = "Objektdetails",
        ["esES"] = "Detalles del objeto",
        ["esMX"] = "Detalles del objeto",
        ["frFR"] = "Détails de l’objet",
        ["koKR"] = "목표 상세정보",
        ["ptBR"] = "Detalhes do objeto",
        ["ruRU"] = "Подробности объекта",
        ["zhCN"] = "物体详细信息",
        ["zhTW"] = "物體詳細資訊",
    },
    ["Item Details"] = {
        ["enUS"] = true,
        ["deDE"] = "Item-Details",
        ["esES"] = "Detalles del objeto",
        ["esMX"] = "Detalles del objeto",
        ["frFR"] = "Détails de l’objet",
        ["koKR"] = "아이템 상세정보",
        ["ptBR"] = "Detalhes do item",
        ["ruRU"] = "Подробности о предмете",
        ["zhCN"] = "物品的详细信息",
        ["zhTW"] = "物品詳細資訊",
    },
    ["Required Level"] = {
        ["enUS"] = true,
        ["deDE"] = "Benötigtes Level",
        ["esES"] = "Nivel requerido",
        ["esMX"] = "Nivel requerido",
        ["frFR"] = "Niveau requis",
        ["koKR"] = "필요 레벨",
        ["ptBR"] = "Nível necessário",
        ["ruRU"] = "Требуемый уровень",
        ["zhCN"] = "需要等级",
        ["zhTW"] = "需要等級",
    },
    ["Required Race"] = {
        ["enUS"] = true,
        ["deDE"] = "Benötigtes Volk",
        ["esES"] = "Raza requerida",
        ["esMX"] = "Raza requerida",
        ["frFR"] = "Race requise",
        ["koKR"] = "필요 종족",
        ["ptBR"] = "Raça necessária",
        ["ruRU"] = "Требуемая раса",
        ["zhCN"] = "需要种族",
        ["zhTW"] = "需要種族",
    },
    ["Treasure Map"] = {
        ["enUS"] = true,
        ["deDE"] = "Schatzkarte",
        ["esES"] = "Mapa de tesoro",
        ["esMX"] = "Mapa de tesoro",
        ["frFR"] = "Carte au trésor",
        ["koKR"] = "보물 지도",
        ["ptBR"] = "Mapa do tesouro",
        ["ruRU"] = "Поиск кладов",
        ["zhCN"] = "藏宝图",
        ["zhTW"] = "藏寶圖",
    },
    ["Special"] = {
        ["enUS"] = true,
        ["deDE"] = "Spezial",
        ["esES"] = "Especial",
        ["esMX"] = "Especial",
        ["frFR"] = "Spécial",
        ["koKR"] = "특수",
        ["ptBR"] = "Especial",
        ["ruRU"] = "Особые",
        ["zhCN"] = "特殊",
        ["zhTW"] = "特殊",
    },
    ["Epic"] = {
        ["enUS"] = true,
        ["deDE"] = "Episch",
        ["esES"] = "Épico",
        ["esMX"] = "Épico",
        ["frFR"] = "Épique",
        ["koKR"] = "대규모",
        ["ptBR"] = "Épico",
        ["ruRU"] = "Эпические",
        ["zhCN"] = "史诗",
        ["zhTW"] = "史詩",
    },
    ["Legendary"] = {
        ["enUS"] = true,
        ["deDE"] = "Legendär",
        ["esES"] = "Legendario",
        ["esMX"] = "Legendario",
        ["frFR"] = "Légendaire",
        ["koKR"] = "전설",
        ["ptBR"] = "Lendário",
        ["ruRU"] = "Легендарные",
        ["zhCN"] = "传说",
        ["zhTW"] = "傳說",
    },
    ["Reputation"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruf",
        ["esES"] = "Reputación",
        ["esMX"] = "Reputación",
        ["frFR"] = "Réputation",
        ["koKR"] = "평판",
        ["ptBR"] = "Reputação",
        ["ruRU"] = "Репутация",
        ["zhCN"] = "声望",
        ["zhTW"] = "聲望",
    },
    ["Group"] = {
        ["enUS"] = true,
        ["deDE"] = "Gruppe",
        ["esES"] = "Grupo",
        ["esMX"] = "Grupo",
        ["frFR"] = "Groupe",
        ["koKR"] = "그룹",
        ["ptBR"] = "Grupo",
        ["ruRU"] = "Группа",
        ["zhCN"] = "队伍",
        ["zhTW"] = "隊伍",
    },
    ["Party"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "Grupo",
        ["esMX"] = "Grupo",
        ["frFR"] = "Groupe",
        ["koKR"] = "파티",
        ["ptBR"] = "Grupo",
        ["ruRU"] = "Группа",
        ["zhCN"] = "队伍",
        ["zhTW"] = "小隊",
    },
    ["Raid"] = {
        ["enUS"] = true,
        ["deDE"] = "Schlachtzug",
        ["esES"] = "Banda",
        ["esMX"] = "Banda",
        ["frFR"] = true,
        ["koKR"] = "레이드",
        ["ptBR"] = "Raide",
        ["ruRU"] = "Рейд",
        ["zhCN"] = "团队",
        ["zhTW"] = "團隊",
    },
    ["Account"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "Cuenta",
        ["esMX"] = "Cuenta",
        ["frFR"] = "Compte",
        ["koKR"] = "계정",
        ["ptBR"] = "Conta",
        ["ruRU"] = "Аккаунт",
        ["zhCN"] = "账号",
        ["zhTW"] = "帳號",
    },
    ["Vendors"] = {
        ["enUS"] = true,
        ["deDE"] = "Händler",
        ["esES"] = "Vendedores",
        ["esMX"] = "Vendedores",
        ["frFR"] = "Vendeurs",
        ["koKR"] = "상인",
        ["ptBR"] = "Comerciantes",
        ["ruRU"] = "Продавцы",
        ["zhCN"] = "供应商",
        ["zhTW"] = "商人",
    },
    ["Achievements"] = {
        ["enUS"] = true,
        ["deDE"] = "Erfolge",
        ["esES"] = "Logros",
        ["esMX"] = "Logros",
        ["frFR"] = "Hauts faits",
        ["koKR"] = "업적",
        ["ptBR"] = "Conquistas",
        ["ruRU"] = "Достижения",
        ["zhCN"] = "成就",
        ["zhTW"] = "成就",
    },
    ["Dismiss"] = {
        ["enUS"] = true,
        ["deDE"] = "Schließen",
        ["esES"] = "Cerrar",
        ["esMX"] = "Cerrar",
        ["frFR"] = "Fermer",
        ["koKR"] = "해산",
        ["ptBR"] = "Fechar",
        ["ruRU"] = "Закрыть",
        ["zhCN"] = "解散",
        ["zhTW"] = "解散",
    },
    ["Doable"] = {
        ["enUS"] = true,
        ["deDE"] = "Machbar",
        ["esES"] = "Realizable",
        ["esMX"] = "Realizable",
        ["frFR"] = "Faisable",
        ["koKR"] = "수행 가능",
        ["ptBR"] = "Fazível",
        ["ruRU"] = "Выполнимые",
        ["zhCN"] = "可行",
        ["zhTW"] = "可行",
    },
    ["Challenge Mode"] = {
        ["enUS"] = true,
        ["deDE"] = "Herausforderungsmodus",
        ["esES"] = "Modo desafío",
        ["esMX"] = "Modo desafío",
        ["frFR"] = "Mode Défi",
        ["koKR"] = "도전 모드",
        ["ptBR"] = "Modo Desafio",
        ["ruRU"] = "Режим испытаний",
        ["zhCN"] = "挑战模式",
        ["zhTW"] = "挑戰模式",
    },
}

for k, v in pairs(genericsLocales) do
    l10n.translations[k] = v
end
