---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local myJourneyLocales = {
    ["Questie Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Questie-Einstellungen",
        ["esES"] = "Opciones",
        ["esMX"] = "Opciones",
        ["frFR"] = "Options",
        ["koKR"] = "Questie 설정",
        ["ptBR"] = "Opções",
        ["ruRU"] = "Настройки Questie",
        ["zhCN"] = "打开 Questie",
        ["zhTW"] = "設定選項",
    },
    ["My Journey"] = {
        ["enUS"] = true,
        ["deDE"] = "Meine Reise",
        ["esES"] = "Mi viaje",
        ["esMX"] = "Mi viaje",
        ["frFR"] = "Mon voyage",
        ["koKR"] = "나의 여정",
        ["ptBR"] = "Minha jornada",
        ["ruRU"] = "Путешествие",
        ["zhCN"] = "我的任务历程",
        ["zhTW"] = "我的冒險日記",
    },
    ["%s's Journey"] = {
        ["enUS"] = true,
        ["deDE"] = "%s's Reise",
        ["esES"] = "Viaje de %s",
        ["esMX"] = "Viaje de %s",
        ["frFR"] = "Le voyage de %s",
        ["koKR"] = "%s의 여정",
        ["ptBR"] = "A jornada de %s",
        ["ruRU"] = "Путешествие персонажа %s",
        ["zhCN"] = "%s的任务历程",
        ["zhTW"] = "%s的冒險日記",
    },
    ["Your Recent History"] = {
        ["enUS"] = true,
        ["deDE"] = "Deine aktuelle Historie",
        ["esES"] = "Tu historial reciente",
        ["esMX"] = "Tu historial reciente",
        ["frFR"] = "Votre historique récent",
        ["koKR"] = "최근 기록",
        ["ptBR"] = "Seu histórico recente",
        ["ruRU"] = "Недавняя история",
        ["zhCN"] = "近期纪录",
        ["zhTW"] = "最近的歷史記錄",
    },
    ["It's about time you embark on your first Journey!"] = {
        ["enUS"] = true,
        ["deDE"] = "Es ist an der Zeit, dass du dich auf deine erste Reise begibst!",
        ["esES"] = "¡Es hora de que te embarques en tu primer viaje!",
        ["esMX"] = "¡Es hora de que te embarques en tu primer viaje!",
        ["frFR"] = "Il est temps d'embarquer pour votre premier voyage !",
        ["koKR"] = "당신은 이제 막 첫번째 여정을 시작했습니다!",
        ["ptBR"] = "É hora de embarcar em sua primeira jornada!",
        ["ruRU"] = "Пора начинать свое первое путешествие!",
        ["zhCN"] = "是时候踏上旅程了！",
        ["zhTW"] = "該是你踏上第一次旅程的時候了！",
    },
    ["Congratulations! You reached %s !"] = {
        ["enUS"] = true,
        ["deDE"] = "Herzlichen Glückwunsch! Du hast Level %s erreicht!",
        ["esES"] = "¡Enhorabuena! ¡Has alcanzado el %s!",
        ["esMX"] = "¡Felicitaciones, has alcanzado el %s!",
        ["frFR"] = "Félicitations, vous avez atteint le %s !",
        ["koKR"] = "축하합니다! %s 레벨을 달성했습니다!",
        ["ptBR"] = "Parabéns, você atingiu o %s!",
        ["ruRU"] = "Поздравляем! Ваш уровень - %s!",
        ["zhCN"] = "恭喜你达到了%s！",
        ["zhTW"] = "恭喜! 已達到 %s！",
    },
    ["You Accepted the quest %s"] = {
        ["enUS"] = true,
        ["deDE"] = "Du hast die Quest '%s' angenommen",
        ["esES"] = "Aceptaste la misión %s",
        ["esMX"] = "Aceptaste la misión %s",
        ["frFR"] = "Vous avez débuté la quête %s",
        ["koKR"] = "%s 퀘스트를 수락했습니다",
        ["ptBR"] = "Você aceitou a missão %s",
        ["ruRU"] = "Задание принято: %s",
        ["zhCN"] = "你接受了任务：%s",
        ["zhTW"] = "已接受任務 %s",
    },
    ["Quest %s: %s"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest %s: %s",
        ["esES"] = "Misión %s: %s",
        ["esMX"] = "Misión %s: %s",
        ["frFR"] = "Quête %s : %s",
        ["koKR"] = "퀘스트 %s: %s",
        ["ptBR"] = "Missão %s: %s",
        ["ruRU"] = "Задание %s: %s",
        ["zhCN"] = "任务%s：%s",
        ["zhTW"] = "任務 %s: %s",
    },
    ["Level %s"] = {
        ["enUS"] = true,
        ["deDE"] = "Level %s",
        ["esES"] = "nivel %s",
        ["esMX"] = "nivel %s",
        ["frFR"] = "niveau %s",
        ["koKR"] = "%s 레벨",
        ["ptBR"] = "nível %s",
        ["ruRU"] = "Уровень %s",
        ["zhCN"] = "等级%s",
        ["zhTW"] = "等級 %s",
    },
    ["You Reached Level %s"] = {
        ["enUS"] = true,
        ["deDE"] = "Du hast Level %s erreicht",
        ["esES"] = "Alcanzaste el nivel %s",
        ["esMX"] = "Alcanzaste el nivel %s",
        ["frFR"] = "Vous avez atteint le niveau %s",
        ["koKR"] = "%s 레벨을 달성했습니다",
        ["ptBR"] = "Você atingiu o nível %s",
        ["ruRU"] = "Достигнут уровень: %s",
        ["zhCN"] = "你达到了等级 %s",
        ["zhTW"] = "你已達到 %s 級",
    },
    ["Year %s"] = {
        ["enUS"] = true,
        ["deDE"] = "Jahr %s",
        ["esES"] = "Año %s",
        ["esMX"] = "Año %s",
        ["frFR"] = "Année %s",
        ["koKR"] = "%s년",
        ["ptBR"] = "Ano %s",
        ["ruRU"] = "Год %s",
        ["zhCN"] = "%s年",
        ["zhTW"] = "%s 年",
    },
    ["Accepted"] = {
        ["enUS"] = true,
        ["deDE"] = "Angenommen",
        ["esES"] = "Aceptada",
        ["esMX"] = "Aceptada",
        ["frFR"] = "Acceptée",
        ["koKR"] = "수락",
        ["ptBR"] = "Aceita",
        ["ruRU"] = "принято",
        ["zhCN"] = "接受",
        ["zhTW"] = "接受",
    },
    ["You Abandoned the quest %s"] = {
        ["enUS"] = true,
        ["deDE"] = "Du hast die Quest '%s' abgebrochen",
        ["esES"] = "Abandonaste la misión %s",
        ["esMX"] = "Abandonaste la misión %s",
        ["frFR"] = "Vous avez abandonné la quête %s",
        ["koKR"] = "%s 퀘스트를 포기했습니다",
        ["ptBR"] = "Você abandonou a missão %s",
        ["ruRU"] = "Задание отменено: %s",
        ["zhCN"] = "你放弃了任务：%s",
        ["zhTW"] = "已放棄任務 %s",
    },
    ["Abandoned"] = {
        ["enUS"] = true,
        ["deDE"] = "Abgebrochen",
        ["esES"] = "Abandonada",
        ["esMX"] = "Abandonada",
        ["frFR"] = "Abandonnée",
        ["koKR"] = "포기",
        ["ptBR"] = "Abandonada",
        ["ruRU"] = "отменено",
        ["zhCN"] = "放弃",
        ["zhTW"] = "放棄",
    },
    ["Entry Title"] = {
        ["enUS"] = true,
        ["deDE"] = "Titel des Eintrags",
        ["esES"] = "Título",
        ["esMX"] = "Título",
        ["frFR"] = "Titre :",
        ["koKR"] = "제목",
        ["ptBR"] = "Título",
        ["ruRU"] = "Название",
        ["zhCN"] = "输入标题",
        ["zhTW"] = "輸入標題",
    },
    ["Journal Entry"] = {
        ["enUS"] = true,
        ["deDE"] = "Tagebucheintrag",
        ["esES"] = "Entrada de viaje",
        ["esMX"] = "Entrada de viaje",
        ["frFR"] = "Message :",
        ["koKR"] = "내용",
        ["ptBR"] = "Entrada da jornada",
        ["ruRU"] = "Описание",
        ["zhCN"] = "输入游记",
        ["zhTW"] = "冒險筆記內容",
    },
    ["You Completed the quest %s"] = {
        ["enUS"] = true,
        ["deDE"] = "Du hast die Quest '%s' abgeschlossen",
        ["esES"] = "Completaste la misión %s",
        ["esMX"] = "Completaste la misión %s",
        ["frFR"] = "Vous avez terminé la quête %s",
        ["koKR"] = "%s 퀘스트를 완료했습니다",
        ["ptBR"] = "Você concluiu a missão %s",
        ["ruRU"] = "Задание выполнено: %s",
        ["zhCN"] = "你完成了任务：%s",
        ["zhTW"] = "已完成任務 %s",
    },
    ["Add Entry"] = {
        ["enUS"] = true,
        ["deDE"] = "Eintrag hinzufügen",
        ["esES"] = "Añadir entrada",
        ["esMX"] = "Añadir entrada",
        ["frFR"] = "Enregistrer la note",
        ["koKR"] = "메모 추가",
        ["ptBR"] = "Adicionar entrada",
        ["ruRU"] = "Добавить заметку",
        ["zhCN"] = "添加条目",
        ["zhTW"] = "新增內容",
    },
    ["Note Created: %s"] = {
        ["enUS"] = true,
        ["deDE"] = "Notiz erstellt: %s",
        ["esES"] = "Nota creada: %s",
        ["esMX"] = "Nota creada: %s",
        ["frFR"] = "Note créée : %s",
        ["koKR"] = "메모 추가: %s",
        ["ptBR"] = "Anotação criada: %s",
        ["ruRU"] = "Заметка добавлена: %s",
        ["zhCN"] = "创建：%s",
        ["zhTW"] = "筆記建立於: %s",
    },
    ["No Note was entered. You must enter a note before submitting."] = {
        ["enUS"] = true,
        ["deDE"] = "Keine Notiz angegeben. Du musst eine Notiz angeben, bevor ein Eintrag angelegt werden kann.",
        ["esES"] = "No has introducido una nota. Tienes que introducir uno antes de crear tu nota.",
        ["esMX"] = "No has introducido una nota. Tienes que introducir una antes de crear tu nota.",
        ["frFR"] = "Aucun message n'a été trouvé. Vous devez entrer un message avant d'enregistrer.",
        ["koKR"] = "내용이 입력되지 않았습니다. 메모를 추가하려면 내용을 입력해주세요.",
        ["ptBR"] = "Nenhuma anotação foi inserida. Você deve inserir uma anotação antes de submeter.",
        ["ruRU"] = "Вы не ввели описание заметки. Введите описание для добавления заметки.",
        ["zhCN"] = "内容不可为空",
        ["zhTW"] = "沒有輸入筆記，送出前必須先輸入筆記內容。",
    },
    ["No Title was entered. You must enter a title before submitting your note."] = {
        ["enUS"] = true,
        ["deDE"] = "Kein Titel angegeben. Du musst einen Titel angeben, bevor ein Eintrag angelegt werden kann.",
        ["esES"] = "No has introducido un título. Tienes que introducir uno antes de crear tu nota.",
        ["esMX"] = "No has introducido un título. Tienes que introducir uno antes de crear tu nota.",
        ["frFR"] = "Aucun titre n'a été trouvé. Vous devez entrer un titre avant d'enregistrer.",
        ["koKR"] = "제목이 입력되지 않았습니다. 메모를 추가하려면 제목을 입력해주세요.",
        ["ptBR"] = "Nenhum título foi inserido. Você deve inserir um título antes de submeter sua anotação.",
        ["ruRU"] = "Вы не ввели название заметки. Введите название для добавления заметки.",
        ["zhCN"] = "标题不可为空",
        ["zhTW"] = "沒有輸入標題，送出筆記前必須先輸入標題。",
    },
    ["New Note For: %s"] = {
        ["enUS"] = true,
        ["deDE"] = "Neue Notiz für: %s",
        ["esES"] = "Nueva nota para: %s",
        ["esMX"] = "Nueva nota para: %s",
        ["frFR"] = "Nouvelle note pour : %s",
        ["koKR"] = "새로운 메모: %s",
        ["ptBR"] = "Nova anotação para: %s",
        ["ruRU"] = "Новая заметка: %s",
        ["zhCN"] = "新笔记：%s",
        ["zhTW"] = "新筆記: %s",
    },
    ["Note: %s"] = {
        ["enUS"] = true,
        ["deDE"] = "Notiz: %s",
        ["esES"] = "Nota: %s",
        ["esMX"] = "Nota: %s",
        ["frFR"] = "Note : %s",
        ["koKR"] = "메모: %s",
        ["ptBR"] = "Anotação: %s",
        ["ruRU"] = "Заметка: %s",
        ["zhCN"] = "笔记：%s",
        ["zhTW"] = "筆記: %s",
    },
    ["Add New Adventure Note"] = {
        ["enUS"] = true,
        ["deDE"] = "Neue Abenteuer-Notiz hinzufügen",
        ["esES"] = "Añadir nota",
        ["esMX"] = "Añadir nota",
        ["frFR"] = "Ajouter une note",
        ["koKR"] = "새 여행 메모 추가",
        ["ptBR"] = "Adicionar nota",
        ["ruRU"] = "Новая заметка",
        ["zhCN"] = "添加冒险笔记",
        ["zhTW"] = "新增冒險筆記",
    },
    ["Create an entry in your journal to remember a specific moment. Simply supply a title and description and Questie will remember it for you!"] = {
        ["enUS"] = true,
        ["deDE"] = "Erstelle einen Eintrag in deinem Reisetagebuch, um dich an einen bestimmten Moment zu erinnern. Gebe einfach einen Titel und eine Beschreibung an und Questie wird sich für dich erinnern!",
        ["esES"] = "Crea una nueva entrada en el tu viaje para recordar un momento especifico. Simplemente proporciona un titulo y una descripción y Questie lo recordará por ti",
        ["esMX"] = "Crea una nueva nota en tu viaje para recordar un momento especifico. Simplemente proporciona un titulo y una descripción y Questie lo recordará por ti",
        ["frFR"] = "Créez une note dans votre journal pour vous rappeler un moment précis. Indiquez simplement un titre et une description et Questie s'en souviendra pour vous !",
        ["koKR"] = "여정 내역에 메모를 남겨 특별한 순간을 기억해보세요. 간단하게 제목과 내용을 입력하면 Questie가 당신을 위해 기억해드립니다!",
        ["ptBR"] = "Cria uma entrada no seu diário para lembrá-lo de um momento específico. Basta fornecer um título e uma descrição e o Questie lembrará disso para você!",
        ["ruRU"] = "Создает заметку в журнале путешествия, чтобы запомнить определенный момент. Просто введите название и описание, и Questie запомнит это для вас!",
        ["zhCN"] = "替你的魔兽升级之旅创建一个条目，纪录特别的时刻。只要输入标题和内容，Questie就会替你保存下来！",
        ["zhTW"] = "在你的冒險日記中建立新內容來記錄特別的時刻，只要簡單的輸入標題和內容描述，任務位置提示插件就會幫你保存起來！",
    },
    ["Delete Note"] = {
        ["enUS"] = true,
        ["deDE"] = "Notiz löschen",
        ["esES"] = "Eliminar nota",
        ["esMX"] = "Eliminar nota",
        ["frFR"] = "Supprimer la note",
        ["koKR"] = "메모 삭제",
        ["ptBR"] = "Excluir anotação",
        ["ruRU"] = "Удалить заметку",
        ["zhCN"] = "删除笔记",
        ["zhTW"] = "刪除筆記",
    },
    ["Are you sure you want to delete this note?"] = {
        ["enUS"] = true,
        ["deDE"] = "Bist du sicher, dass du diese Notiz löschen möchtest?",
        ["esES"] = "¿Estás seguro de que quieres eliminar esta nota?",
        ["esMX"] = "¿Estás seguro de que quieres eliminar esta nota?",
        ["frFR"] = "Êtes-vous sûr de vouloir supprimer cette note ?",
        ["koKR"] = "정말로 이 메모를 삭제하시겠습니까?",
        ["ptBR"] = "Tem certeza de que deseja excluir esta anotação?",
        ["ruRU"] = "Вы уверены, что хотите удалить эту заметку?",
        ["zhCN"] = "确定要删除这个笔记吗？",
        ["zhTW"] = "確定要刪除這個筆記嗎？",
    },
    ["Note deleted successfully"] = {
        ["enUS"] = true,
        ["deDE"] = "Notiz erfolgreich gelöscht",
        ["esES"] = "Nota eliminada con éxito",
        ["esMX"] = "Nota eliminada con éxito",
        ["frFR"] = "Note supprimée avec succès",
        ["koKR"] = "메모가 성공적으로 삭제되었습니다",
        ["ptBR"] = "Anotação excluída com sucesso",
        ["ruRU"] = "Заметка успешно удалена",
        ["zhCN"] = "笔记删除成功",
        ["zhTW"] = "筆記刪除成功",
    },
}

for k, v in pairs(myJourneyLocales) do
    l10n.translations[k] = v
end
