---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local mapOptionsLocales = {
    ["Map"] = {
        ["enUS"] = true,
        ["deDE"] = "Weltkarte",
        ["esES"] = "Mapa",
        ["esMX"] = "Mapa",
        ["frFR"] = "Carte",
        ["koKR"] = "지도",
        ["ptBR"] = "Mapa",
        ["ruRU"] = "Карта мира",
        ["zhCN"] = "大地图",
        ["zhTW"] = "大地圖",
    },
    ["Map Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Weltkarten-Einstellungen",
        ["esES"] = "Opciones del mapa",
        ["esMX"] = "Opciones del mapa",
        ["frFR"] = "Options de la carte",
        ["koKR"] = "지도 옵션",
        ["ptBR"] = "Opções do mapa",
        ["ruRU"] = "Настройки карты мира",
        ["zhCN"] = "大地图选项",
        ["zhTW"] = "大地圖選項",
    },
    ["Show Questie Map Button"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeige Questie-Button an der Weltkarte",
        ["esES"] = "Mostrar botón de Questie en el mapa",
        ["esMX"] = "Mostrar botón de Questie en el mapa",
        ["frFR"] = "Afficher le bouton Questie sur la carte",
        ["koKR"] = "Questie 지도 버튼 표시",
        ["ptBR"] = "Mostrar o botão de Questie no mapa",
        ["ruRU"] = "Кнопка Questie",
        ["zhCN"] = "大地图显示Questie按钮",
        ["zhTW"] = "顯示大地圖的任務圖示按鈕",
    },
    ["Enable or disable the Show/Hide Questie Button on Map (May fix some Map Addon interactions)."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert den Zeigen/Verstecken-Button an der Weltkarte (repariert möglicherweise Karten-Addon Interaktionen).",
        ["esES"] = "Activa o desactiva el botón de Questie en el mapa (puede solucionar algunas interacciones con los addons de mapas).",
        ["esMX"] = "Activa o desactiva el botón de Questie en el mapa (puede solucionar algunas interacciones con los addons de mapas).",
        ["frFR"] = "Active l'affichage du bouton de Questie sur la carte (peut corriger certaines interactions avec des add-ons modifiant la carte).",
        ["koKR"] = "지도에 Questie 버튼을 표시합니다 (따로 지도 애드온을 사용할 경우 충돌할 수 있습니다)",
        ["ptBR"] = "Ativa ou desativa o botão de Questie no mapa (pode corrigir algumas interações com os addons de mapas).",
        ["ruRU"] = "Показать/скрыть кнопку Questie на карте (может исправить некоторые проблемы с аддонами карт)",
        ["zhCN"] = "启用或停用大地图上的Questie切换按钮（可以解决某些地图插件的冲突）",
        ["zhTW"] = "啟用或停用大地圖上的顯示/隱藏任務圖示按鈕 (可以修正某些地圖插件的互動問題)。",
    },
    ["Map Icons Glow"] = {
        ["enUS"] = true,
        ["deDE"] = "Weltkarten-Icons immer leuchten lassen",
        ["esES"] = "Resplandecer iconos en el mapa",
        ["esMX"] = "Resplandecer iconos en el mapa",
        ["frFR"] = "Illuminer les icônes sur la carte",
        ["koKR"] = "지도 아이콘 반짝임 사용",
        ["ptBR"] = "Iluminar ícones no mapa",
        ["ruRU"] = "Подсветка значков",
        ["zhCN"] = "总是使大地图标记高亮",
        ["zhTW"] = "大地圖圖示發光",
    },
    ["Draw a glow texture behind map icons, colored unique to each quest."] = {
        ["enUS"] = true,
        ["deDE"] = "Zeichnet eine leuchtende Textur hinter die Weltkarten-Icons. Farblich einzigartig für jede Quest.",
        ["esES"] = "Resplandece los iconos en el mapa con colores únicos para cada misión.",
        ["esMX"] = "Resplandece los iconos en el mapa con colores únicos para cada misión.",
        ["frFR"] = "Illumine les icônes sur la carte, colorié différemment pour chaque quête.",
        ["koKR"] = "지도 아이콘에 반짝이는 효과를 표시합니다. 퀘스트마다 각각 다른 색상을 지닙니다.",
        ["ptBR"] = "Ilumina os ícones mínimos no mapa, com cores exclusivas para cada missão.",
        ["ruRU"] = "Показать/скрыть цветной ореол вокруг значков на карте",
        ["zhCN"] = "替大地图标记显示一圈光晕，且不同任务有不同的颜色",
        ["zhTW"] = "在任務目標圖示的後面繪製發光材質，每個任務都可以有不同的顏色。",
    },
    ["Unique Map Icon Colors"] = {
        ["enUS"] = true,
        ["deDE"] = "Karten-Icons für jede Quest unterschiedlich färben",
        ["esES"] = "Colores únicos de iconos del mapa",
        ["esMX"] = "Colores únicos de iconos del mapa",
        ["frFR"] = "Couleurs uniques des icônes de la carte",
        ["koKR"] = "각 퀘스트별 다른 아이콘 색상 사용",
        ["ptBR"] = "Cores únicas de ícones do mapa",
        ["ruRU"] = "Различные цветa значков",
        ["zhCN"] = "为每个任务的大地图标记使用不同颜色",
        ["zhTW"] = "每個任務顯示不同的圖示顏色",
    },
    ["Show map icons with colors that are randomly generated based on quest ID."] = {
        ["enUS"] = true,
        ["deDE"] = "Zeigt Karten-Icons mit zufälligen Farben für jede Quest.",
        ["esES"] = "Muestra iconos del mapa con colores que se generan aleatoriamente en función de la ID de la misión.",
        ["esMX"] = "Muestra iconos del mapa con colores que se generan aleatoriamente en función de la ID de la misión.",
        ["frFR"] = "Affiche les icônes de la carte avec couleurs aléatoires en fonction de l'ID des quêtes.",
        ["koKR"] = "지도에서 각 퀘스트별로 각각 다른 아이콘 색상을 사용할지 설정합니다.",
        ["ptBR"] = "Mostra ícones do mapa com cores geradas de maneira aleatoriamente com base na ID da missão.",
        ["ruRU"] = "Для каждого задания генерируется свой цвет значков на карте",
        ["zhCN"] = "基于任务ID，为每个任务的大地图标记随机生成不同颜色的图标",
        ["zhTW"] = "依據任務 ID 隨機產生不同的顏色來顯示地圖圖示。",
    },
    ["Map Note Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Weltkarten-Notiz-Einstellungen",
        ["esES"] = "Opciones de las notas de mapa",
        ["esMX"] = "Opciones de las notas de mapa",
        ["frFR"] = "Options des notes sur la carte",
        ["koKR"] = "지도 아이콘 설정",
        ["ptBR"] = "Opções de anotação de mapa",
        ["ruRU"] = "Настройки размеров значков",
        ["zhCN"] = "大地图标记",
        ["zhTW"] = "大地圖圖示選項",
    },
    ["How large the map icons are.\n(Default: %s)"] = {
        ["enUS"] = true,
        ["deDE"] = "Skaliert die Größe aller Weltkarten-Icons.\n(Standard: %s)",
        ["esES"] = "Define la escala de los iconos del mapa\n(Predeterminado: %s)",
        ["esMX"] = "Define la escala de los iconos del mapa\n(Predeterminado: %s)",
        ["frFR"] = "Définis la taille des icônes sur la carte.\n(Par défaut : %s)",
        ["koKR"] = "지도 아이콘의 크기를 설정합니다.\n(기본값: %s)",
        ["ptBR"] = "Qual é o tamanho dos ícones do mapa.\n(Padrão: %s)",
        ["ruRU"] = "Одновременная регулировка размера всех значков на карте\n(по умолчанию: %s)",
        ["zhCN"] = "调整大地图标记图标的缩放比例\n（默认：%s）",
        ["zhTW"] = "大地圖上圖示的大小。\n(預設值: %s)",
    },
    ["Scale for Available/Complete Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Skalierung der Icons für verfügbare/abgeschlossene Quests",
        ["esES"] = "Tamaño de iconos de misión disponible y completada",
        ["esMX"] = "Tamaño de iconos de misión disponible y completada",
        ["frFR"] = "Échelle des icônes de quête disponible/terminée",
        ["koKR"] = "수행가능/완료 퀘스트 아이콘 크기",
        ["ptBR"] = "Escala para ícones disponíveis/completos",
        ["ruRU"] = "Размер значков заданий",
        ["zhCN"] = "可取得与可完成的图标大小",
        ["zhTW"] = "可接/完成圖示縮放大小",
    },
    ["How large the available/complete icons are. Affects both map and minimap icons.\n(Default: %s)"] = {
        ["enUS"] = true,
        ["deDE"] = "Skaliert die Icons der verfügbaren/abgeschlossenen Quests.\n(Standard: %s)",
        ["esES"] = "Define la escala de los iconos de misión disponible y completada.\n(Predeterminado: %s)",
        ["esMX"] = "Define la escala de los iconos de misión disponible y completada.\n(Predeterminado: %s)",
        ["frFR"] = "Définis la taille des icônes de quête disponible/terminée.\n(Par défaut : %s)",
        ["koKR"] = "수행가능/완료 퀘스트 아이콘의 크기를 설정합니다.\n(기본값: %s)",
        ["ptBR"] = "Qual é o tamanho dos ícones disponíveis / completos\n(Padrão: %s)",
        ["ruRU"] = "Регулировка размера значков доступных/выполненных заданий на карте и миникарте\n(по умолчанию: %s)",
        ["zhCN"] = "调整可取得与可完成的缩放比例\n（默认：%s）",
        ["zhTW"] = "可接/完成圖示的大小。\n(預設值: %s)",
    },
    ["Scale for Event Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Skalierung der Event-Icons",
        ["esES"] = "Tamaño de iconos de evento",
        ["esMX"] = "Tamaño de iconos de evento",
        ["frFR"] = "Échelle des icônes d'évènement",
        ["koKR"] = "이벤트 아이콘 크기",
        ["ptBR"] = "Escala de ícones de eventos",
        ["ruRU"] = "Размер значков событий",
        ["zhCN"] = "事件图标大小",
        ["zhTW"] = "事件圖示縮放大小",
    },
    ["How large the event icons are.\n(Default: %s)"] = {
        ["enUS"] = true,
        ["deDE"] = "Skaliert wie groß die Event-Icons sind.\n(Standard: %s)",
        ["esES"] = "Define la escala de los iconos evento.\n(Predeterminado: %s)",
        ["esMX"] = "Define la escala de los iconos evento.\n(Predeterminado: %s)",
        ["frFR"] = "Définis la taille des icônes d'évènement.\n(Par défaut : %s)",
        ["koKR"] = "이벤트 아이콘의 크기를 설정합니다.\n(기본값: %s)",
        ["ptBR"] = "Qual é o tamanho dos ícones do evento.\n(Padrão: %s)",
        ["ruRU"] = "Регулировка размера значков событий на карте и миникарте\n(по умолчанию: %s)",
        ["zhCN"] = "调整事件图标的缩放比例\n（默认：%s）",
        ["zhTW"] = "事件圖示的大小。\n(預設值: %s)",
    },
    ["Scale for Loot Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Skalierung der Beute-Icons",
        ["esES"] = "Tamaño de iconos de botín",
        ["esMX"] = "Tamaño de iconos de botín",
        ["frFR"] = "Échelle des icônes de butin",
        ["koKR"] = "수집 아이콘 크기",
        ["ptBR"] = "Escala para ícones de saque",
        ["ruRU"] = "Размер значков добычи",
        ["zhCN"] = "拾取道具图标大小",
        ["zhTW"] = "撿東西圖示縮放大小",
    },
    ["How large the loot icons are.\n(Default: %s)"] = {
        ["enUS"] = true,
        ["deDE"] = "Skaliert wie groß die Beute-Icons sind.\n(Standard: %s)",
        ["esES"] = "Define la escala de los iconos de botín.\n(Predeterminado: %s)",
        ["esMX"] = "Define la escala de los iconos de botín.\n(Predeterminado: %s)",
        ["frFR"] = "Définis la taille des icônes de butin.\n(Par défaut : %s)",
        ["koKR"] = "수집 아이콘의 크기를 설정합니다.\n(기본값: %s)",
        ["ptBR"] = "Qual é o tamanho dos ícones de saque\n(Padrão: %s)",
        ["ruRU"] = "Регулировка размера значков добычи на карте и миникарте\n(по умолчанию: %s)",
        ["zhCN"] = "调整拾取道具图标的缩放比例\n（默认：%s）",
        ["zhTW"] = "撿東西圖示的大小。\n(預設值: %s)",
    },
    ["Scale for Slay Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Skalierung der Töten-Icons",
        ["esES"] = "Tamaño de iconos de matanza",
        ["esMX"] = "Tamaño de iconos de matanza",
        ["frFR"] = "Échelle des icônes de tuerie",
        ["koKR"] = "처치 아이콘 크기",
        ["ptBR"] = "Escala para ícones de matança",
        ["ruRU"] = "Размер значков убийств",
        ["zhCN"] = "击杀目标的图标大小",
        ["zhTW"] = "殺怪圖示縮放大小",
    },
    ["How large the slay icons are.\n(Default: %s)"] = {
        ["enUS"] = true,
        ["deDE"] = "Skaliert wie groß die Töten-Icons sind.\n(Standard: %s)",
        ["esES"] = "Define la escala de los iconos de matanza.\n(Predeterminado: %s)",
        ["esMX"] = "Define la escala de los iconos de matanza.\n(Predeterminado: %s)",
        ["frFR"] = "Définis la taille des icônes de tuerie.\n(Par défaut: %s)",
        ["koKR"] = "처치 아이콘의 크기를 설정합니다.\n( 기본값: %s)",
        ["ptBR"] = "Qual é o tamanho dos ícones de matança\n(Padrão: %s)",
        ["ruRU"] = "Регулировка размера значков убийств на карте и миникарте\n(по умолчанию: %s)",
        ["zhCN"] = "调整击杀目标图标的缩放比例\n（默认：%s）",
        ["zhTW"] = "殺怪圖示的大小。\n(預設值: %s)",
    },
    ["Scale for Object Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Skalierung der Objekt-Icons",
        ["esES"] = "Tamaño de iconos de objeto",
        ["esMX"] = "Tamaño de iconos de objeto",
        ["frFR"] = "Échelle des icônes d'objet",
        ["koKR"] = "오브젝트 아이콘 크기",
        ["ptBR"] = "Escala para ícones de objetos",
        ["ruRU"] = "Размер значков объектов",
        ["zhCN"] = "物体图标比例",
        ["zhTW"] = "物體圖示比例",
    },
    ["How large the object icons are.\n(Default: %s)"] = {
        ["enUS"] = true,
        ["deDE"] = "Skaliert wie groß die Objekt-Icons sind.\n(Standard: %s)",
        ["esES"] = "Define la escala de los iconos de objeto.\n(Predeterminado: %s)",
        ["esMX"] = "Define la escala de los iconos de objeto.\n(Predeterminado: %s)",
        ["frFR"] = "Définis la taille des icônes d'objet.\n(Par défaut : %s)",
        ["koKR"] = "오브젝트 아이콘의 크기를 설정합니다.\n(기본값: %s)",
        ["ptBR"] = "Qual é o tamanho dos ícones de objeto.\n(Padrão: %s)",
        ["ruRU"] = "Регулировка размера значков объектов на карте и миникарте\n(по умолчанию: %s)",
        ["zhCN"] = "物体图标的大小。\n（默认：%s）",
        ["zhTW"] = "物体圖示的大小。\n（預設：%s）",
    },
    ["Townsfolk Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Stadtbewohner Icons",
        ["esES"] = "Iconos de aldeanos",
        ["esMX"] = "Iconos de aldeanos",
        ["frFR"] = "Icônes des villageois",
        ["koKR"] = false,
        ["ptBR"] = "Ícones dos aldeões",
        ["ruRU"] = "Значки полезных NPC",
        ["zhCN"] = false,
        ["zhTW"] = false,
    },
    ["How large the townsfolk map icons are.\n(Default: %s)"] = {
        ["enUS"] = true,
        ["deDE"] = "Skaliert wie groß die Stadtbewohner-Icons sind.\n(Standard: %s)",
        ["esES"] = "Tamaño de los iconos de aldeanos en el mapa.\n(Predeterminado: %s)",
        ["esMX"] = "Tamaño de los iconos de aldeanos en el mapa.\n(Predeterminado: %s)",
        ["frFR"] = "Taille des icônes des villageois sur la carte.\n(Par défaut : %s)",
        ["koKR"] = false,
        ["ptBR"] = "Tamanho dos ícones dos aldeões no mapa.\n(Padrão: %s)",
        ["ruRU"] = "Размер значков полезных NPC на карте.\n(По умолчанию: %s)",
        ["zhCN"] = false,
        ["zhTW"] = false,
    },
    ["Minimap Townsfolk Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Minimap-Stadtbewohner-Icons",
        ["esES"] = "Iconos de aldeanos en el minimapa",
        ["esMX"] = "Iconos de aldeanos en el minimapa",
        ["frFR"] = "Icônes des villageois sur la minicarte",
        ["koKR"] = false,
        ["ptBR"] = "Ícones dos aldeões no minimapa",
        ["ruRU"] = "Значки полезных NPC (миникарта)",
        ["zhCN"] = false,
        ["zhTW"] = false,
    },
    ["How large the townsfolk minimap icons are.\n(Default: %s)"] = {
        ["enUS"] = true,
        ["deDE"] = "Skaliert wie groß die Minimap-Stadtbewohner-Icons sind.\n(Standard: %s)",
        ["esES"] = "Tamaño de los iconos de aldeanos en el minimapa.\n(Predeterminado: %s)",
        ["esMX"] = "Tamaño de los iconos de aldeanos en el minimapa.\n(Predeterminado: %s)",
        ["frFR"] = "Taille des icônes des villageois sur la minicarte.\n(Par défaut : %s)",
        ["koKR"] = false,
        ["ptBR"] = "Tamanho dos ícones dos aldeões no minimapa.\n(Padrão: %s)",
        ["ruRU"] = "Размер значков полезных NPC на миникарте.\n(По умолчанию: %s)",
        ["zhCN"] = false,
        ["zhTW"] = false,
    },
    ["Show Map Coordinates"] = {
        ["enUS"] = true,
        ["deDE"] = "Karten- und Zeiger-Koordinaten",
        ["esES"] = "Coordenadas de mapa y ratón",
        ["esMX"] = "Coordenadas de mapa y ratón",
        ["frFR"] = "Coordonnées",
        ["koKR"] = "지도 및 커서 좌표",
        ["ptBR"] = "Coordenadas de mapa e cursor",
        ["ruRU"] = "Координаты",
        ["zhCN"] = "大地图座标",
        ["zhTW"] = "大地圖和滑鼠坐標",
    },
    ["Place the Player's coordinates and Cursor's coordinates on the Map's title."] = {
        ["enUS"] = true,
        ["deDE"] = "Koordinaten von Spieler- und Mauszeiger-Koordinaten an der Weltkarte.",
        ["esES"] = "Muestra las coordenadas del jugador y del ratón en el título del mapa.",
        ["esMX"] = "Muestra las coordenadas del jugador y del ratón en el título del mapa.",
        ["frFR"] = "Affiche les coordonnées du joueur et celles du curseur dans le titre de la carte.",
        ["koKR"] = "지도 제목 영역에 플레이어 및 커서의 좌표를 표시합니다.",
        ["ptBR"] = "Mostra as coordenadas do jogador e do cursor no título do mapa.",
        ["ruRU"] = "Показать/скрыть координаты игрока и курсора в заголовке карты мира",
        ["zhCN"] = "在大地图标题上显示玩家与鼠标指向位置的座标",
        ["zhTW"] = "在大地圖的標題中顯示玩家和滑鼠游標的坐標。",
    },
    ["Map Coordinates Decimal Precision"] = {
        ["enUS"] = true,
        ["deDE"] = "Dezimalpunkt-Genauigkeit der Koordinaten",
        ["esES"] = "Precisión de coordenadas en el mapa",
        ["esMX"] = "Precisión de coordenadas en el mapa",
        ["frFR"] = "Précision des coordonnées sur la carte",
        ["koKR"] = "지도 좌표 소수점 표시 설정",
        ["ptBR"] = "Precisão de coordenadas no mapa",
        ["ruRU"] = "Количество знаков после запятой",
        ["zhCN"] = "座标数值精确度",
        ["zhTW"] = "地圖坐標小數點精確度",
    },
    ["How many decimals to include in the precision on the Map for Player and Cursor coordinates.\n(Default: %s)"] = {
        ["enUS"] = true,
        ["deDE"] = "Wie viele Nachkommastellen in die Genauigkeit für Spieler- und Mauszeiger-Koordinanten einfließen sollen.\n(Standard: %s)",
        ["esES"] = "Cuántos decimales de precisión tienen que tener las coordenadas en el mapa para el jugador y el ratón.\n(Predeterminado: %s)",
        ["esMX"] = "Cuántos decimales de precisión tienen que tener las coordenadas en el mapa para el jugador y el ratón.\n(Predeterminado: %s)",
        ["frFR"] = "Définis combien de décimales sont à inclure dans les coordonnées du joueur et du curseur.\n(Par défaut : %s)",
        ["koKR"] = "지도 좌표에 소수점 몇자리까지 표시할지 설정합니다.\n( 기본값: %s)",
        ["ptBR"] = "Número de casas decimais a serem incluídas na precisão do mapa para as coordenadas do jogador e do cursor.\n(Padrão: %s)",
        ["ruRU"] = "Допустимое количество знаков после запятой при отображении координат\n(по умолчанию: %s)",
        ["zhCN"] = "大地图的座标要显示到小数点后几位\n（默认：%s）",
        ["zhTW"] = "大地圖的玩家和滑鼠游標坐標要顯示幾位小數。\n(預設值: %s)",
    },
    ["Setting clustering value, clusterLevelHotzone set to %s : Redrawing!"] = {
        ["enUS"] = true,
        ["deDE"] = "Clusterlevel geändert auf %s : Zeichne neu!",
        ["esES"] = "Configuración NYI valor de agrupamiento, nivel de agrupamiento establecido a %s : Redibujando!",
        ["esMX"] = "Configuración NYI valor de agrupamiento, nivel de agrupamiento establecido a %s : Redibujando!",
        ["frFR"] = "Réglage de la valeur de fusionnement, clusterLevelHotzone réglée sur %s : réorganisation !",
        ["koKR"] = "클러스터링 값 설정 중, 클러스터 레벨 핫존이 %s로 설정됨: Redrawing!",
        ["ptBR"] = "Valor de cluster dos parâmetros da, clusterLevelHotzone definido como% s: Redrawing!",
        ["ruRU"] = "Группировка значков: %s. Перерисовка",
        ["zhCN"] = "设置群集值，clusterLevelHotzone设置为 %s : 重新绘制中!",
        ["zhTW"] = "設定密集度，clusterLevelHotzone 設為 %s : 重新繪製中!",
    },
}

for k, v in pairs(mapOptionsLocales) do
    l10n.translations[k] = v
end
