---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local socialOptionsLocales = {
    ["Social"] = {
        ["enUS"] = true,
        ["deDE"] = "Soziales",
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "소셜",
        ["ptBR"] = true,
        ["ruRU"] = "Социальное",
        ["zhCN"] = "通报",
        ["zhTW"] = "通報",
    },
    ["Social Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Soziale Einstellungen", -- TODO: Improve translation
        ["esES"] = "Opciones sociales",
        ["esMX"] = "Opciones sociales",
        ["frFR"] = "Options sociales",
        ["koKR"] = "소셜 옵션",
        ["ptBR"] = "Opções sociais",
        ["ruRU"] = "Социальные настройки",
        ["zhCN"] = "通报设置",
        ["zhTW"] = "通報選項",
    },
    ["Announce quest updates to other players in your group"] = {
        ["enUS"] = true,
        ["deDE"] = "Teilt Updates von Quests anderen Spielern in deiner Gruppe mit.",
        ["esES"] = "Anuncia actualizaciones de misiones a otros jugadores en tu grupo.",
        ["esMX"] = "Anuncia actualizaciones de misiones a otros jugadores en tu grupo.",
        ["frFR"] = "Annonce l'avancée des quêtes aux autres membres de votre groupe.",
        ["koKR"] = "그룹 내 다른 플레이어에게 퀘스트 업데이트 알림",
        ["ptBR"] = "Anuncia atualizações de missão para outros jogadores do seu grupo.",
        ["ruRU"] = "Включает оповещения об обновлениях заданий в чате группы",
        ["zhCN"] = "与您队伍中的其他玩家分享任务进度",
        ["zhTW"] = "將任務進度通報給隊伍中的其他玩家",
    },
    ["Channels to announce in"] = {
        ["enUS"] = true,
        ["deDE"] = "Kanäle in denen mitgeteilt wird",
        ["esES"] = "Canales en los que anunciar",
        ["esMX"] = "Canales en los que anunciar",
        ["frFR"] = "Canaux dans lesquels annoncer",
        ["koKR"] = "알림을 보낼 채널",
        ["ptBR"] = "Canais nos quais anunciar",
        ["ruRU"] = "Чаты для оповещений",
        ["zhCN"] = "通报的频道",
        ["zhTW"] = "通報的頻道",
    },
    ["Questie ShutUp!"] = {
    -- TN: This was a stand-alone addon name, so you may want to leave it untranslated (change to true)
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "Questie 차단",
        ["ptBR"] = true,
        ["ruRU"] = "Заткнись, Questie!",
        ["zhCN"] = "关闭Questie!通报",
        ["zhTW"] = "關閉任務通報!",
    },
    ["Remove all Questie chat messages coming from other players and disable sending your own."] = {
        ["enUS"] = true,
        ["deDE"] = "Alle Questie-Chatnachrichten anderer Spieler entfernen und das Senden der eigenen deaktivieren.",
        ["esES"] = "Elimina los mensajes de Questie.",
        ["esMX"] = "Elimina los mensajes de Questie.",
        ["frFR"] = "Supprimez les messages de Questie.",
        ["koKR"] = "다른 플레이어로부터 오는 모든 Questie 채팅 메시지를 제거하고 자신의 메시지 전송을 비활성화합니다.",
        ["ptBR"] = "Remove as mensagens de Questie.",
        ["ruRU"] = "Скрывает в чатах все сообщения Questie от других игроков и отключает отправку ваших",
        ["zhCN"] = "屏蔽来自其他玩家的所有 Questie 聊天消息，并禁止发送您自己的消息。",
        ["zhTW"] = "移除所有來自其他玩家的任務位置提示聊天訊息，你自己也停止發送訊息。",
    },
    ["Both"] = {
        ["enUS"] = true,
        ["deDE"] = "Beide",
        ["esES"] = "Ambos",
        ["esMX"] = "Ambos",
        ["frFR"] = "Les deux",
        ["koKR"] = "둘 다",
        ["ptBR"] = "Ambos",
        ["ruRU"] = "Группа и рейд",
        ["zhCN"] = "两者",
        ["zhTW"] = "兩者",
    },
    ["Types of updates to announce in chat"] = {
        ["enUS"] = true,
        ["deDE"] = "Updatearten die im Chat mitgeteilt werden",
        ["esES"] = "Tipos de actualizaciones para anunciar en el chat",
        ["esMX"] = "Tipos de actualizaciones para anunciar en el chat",
        ["frFR"] = "Types de mises à jour à annoncer dans la discussion",
        ["koKR"] = "채팅에서 알릴 업데이트 유형",
        ["ptBR"] = "Tipos de atualizações para anunciar no bate-papo",
        ["ruRU"] = "Типы обновлений для оповещения в чатах",
        ["zhCN"] = "在聊天中宣布的更新的类型",
        ["zhTW"] = "要通報的進度類型",
    },
    ["Items starting a quest"] = {
        ["enUS"] = true,
        ["deDE"] = "Quests startende Gegenstände",
        ["esES"] = "Objetos que inician una misión",
        ["esMX"] = "Objetos que inician una misión",
        ["frFR"] = "Objets commençant une quête",
        ["koKR"] = "퀘스트 시작 아이템",
        ["ptBR"] = "Itens que començam uma missão",
        ["ruRU"] = "Предметы, начинающие задание",
        ["zhCN"] = "开始任务的物品",
        ["zhTW"] = "開始任務的物品",
    },
    ["Announce looted items that start a quest to other players"] = {
        ["enUS"] = true,
        ["deDE"] = "Teilt das Aufheben von Gegenständen, die eine Quests beginnen, anderen Spielern mit.",
        ["esES"] = "Anuncia objetos despojados que inician una misión a otros jugadores.",
        ["esMX"] = "Anuncia objetos despojados que inician una misión a otros jugadores.",
        ["frFR"] = "Annonce le ramassage d’objets commençant une quête aux autres joueurs.",
        ["koKR"] = "다른 플레이어에게 퀘스트 시작 아이템 획득 알림",
        ["ptBR"] = "Anuncia itens saqueados que começam uma missão para outros jogadores.",
        ["ruRU"] = "Оповещение о предметах, начинающих задание",
        ["zhCN"] = "将拾取的启动任务物品通报给其他玩家",
        ["zhTW"] = "將拾取的啟動任務物品通報給其他玩家",
    },
    ["Quest accepted"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest angenommen",
        ["esES"] = "Misión aceptada",
        ["esMX"] = "Misión aceptada",
        ["frFR"] = "Quête acceptée",
        ["koKR"] = "퀘스트 수락",
        ["ptBR"] = "Missão aceita",
        ["ruRU"] = "Задание принято",
        ["zhCN"] = "已接受任务",
        ["zhTW"] = "接受任務",
    },
    ["Announce quest acceptance to other players"] = {
        ["enUS"] = true,
        ["deDE"] = "Teilt die Annahme von Quests anderen Spielern mit.",
        ["esES"] = "Anuncia la aceptación de misiones a otros jugadores.",
        ["esMX"] = "Anuncia la aceptación de misiones a otros jugadores.",
        ["frFR"] = "Annonce l'acceptation des quêtes aux autres joueurs.",
        ["koKR"] = "다른 플레이어에게 퀘스트 수락 알림",
        ["ptBR"] = "Anuncia a aceitação de missões para outros jogadores.",
        ["ruRU"] = "Оповещение о принятии задания",
        ["zhCN"] = "向其他玩家通报接受任务",
        ["zhTW"] = "接受任務時向其他玩家通報",
    },
    ["Quest abandoned"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest abgebrochen",
        ["esES"] = "Misión abandonada",
        ["esMX"] = "Misión abandonada",
        ["frFR"] = "Quête abandonnée",
        ["koKR"] = "퀘스트 포기",
        ["ptBR"] = "Missão abandonada",
        ["ruRU"] = "Задание отменено",
        ["zhCN"] = "放弃任务",
        ["zhTW"] = "放棄任務",
    },
    ["Announce quest abortion to other players"] = {
        ["enUS"] = true,
        ["deDE"] = "Teilt den Abbruch von Quests anderen Spielern mit.",
        ["esES"] = "Anuncia el abandono de misiones a otros jugadores.",
        ["esMX"] = "Anuncia el abandono de misiones a otros jugadores.",
        ["frFR"] = "Annonce l'abandon des quêtes aux autres joueurs.",
        ["koKR"] = "다른 플레이어에게 퀘스트 포기 알림",
        ["ptBR"] = "Anuncia o abandono de missões para outros jogadores.",
        ["ruRU"] = "Оповещение об отмене задания",
        ["zhCN"] = "向其他玩家通报放弃任务",
        ["zhTW"] = "放棄任務時向其他玩家通報",
    },
    ["Objective completed"] = {
        ["enUS"] = true,
        ["deDE"] = "Questziel erfüllt",
        ["esES"] = "Objetivo completado",
        ["esMX"] = "Objetivo completado",
        ["frFR"] = "Objectif terminé",
        ["koKR"] = "목표 완료",
        ["ptBR"] = "Objetivo concluído",
        ["ruRU"] = "Цель достигнута",
        ["zhCN"] = "目标已完成",
        ["zhTW"] = "目標已完成",
    },
    ["Announce completed objectives to other players"] = {
        ["enUS"] = true,
        ["deDE"] = "Teilt die Erfüllung von Questzielen anderen Spielern mit.",
        ["esES"] = "Anuncia la completación de objetivos a otros jugadores.",
        ["esMX"] = "Anuncia la completación de objetivos a otros jugadores.",
        ["frFR"] = "Annonce la terminaison des objectifs aux autres joueurs.",
        ["koKR"] = "다른 플레이어에게 목표 완료 알림",
        ["ptBR"] = "Anuncia a conclusão de objetivos para outros jogadores.",
        ["ruRU"] = "Оповещение о достижении целей задания",
        ["zhCN"] = "向其他玩家通报已完成的目标",
        ["zhTW"] = "向其他玩家通報已完成的目标",
    },
    ["Quest completed"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest abgeschlossen",
        ["esES"] = "Misión completada",
        ["esMX"] = "Misión completada",
        ["frFR"] = "Quête terminée",
        ["koKR"] = "퀘스트 완료",
        ["ptBR"] = "Missão concluída",
        ["ruRU"] = "Задание выполнено",
        ["zhCN"] = "任务完成",
        ["zhTW"] = "任務完成",
    },
    ["Announce quest completion to other players"] = {
        ["enUS"] = true,
        ["deDE"] = "Teilt den Abschluß von Quests anderen Spielern mit.",
        ["esES"] = "Anuncia la completación de misiones a otros jugadores.",
        ["esMX"] = "Anuncia la completación de misiones a otros jugadores.",
        ["frFR"] = "Annonce la terminaison des quêtes aux autres joueurs.",
        ["koKR"] = "다른 플레이어에게 퀘스트 완료 알림",
        ["ptBR"] = "Anuncia a conclusão de missões para outros jogadores.",
        ["ruRU"] = "Оповещение о выполнении задания",
        ["zhCN"] = "向其他玩家通报任务完成",
        ["zhTW"] = "任務完成時向其他玩家通報",
    },
    ["Incomplete breadcrumb"] = {
        ["enUS"] = true,
        ["deDE"] = "Unvollständige Brotkrumen",
        ["esES"] = "Misión previa incompleta",
        ["esMX"] = "Misión previa incompleta",
        ["frFR"] = "Quête préliminaire incomplète",
        ["koKR"] = "완료되지 않은 길잡이",
        ["ptBR"] = "Missão preliminar incompleta",
        ["ruRU"] = "Предзадание не завершено",
        ["zhCN"] = false,
        ["zhTW"] = false,
    },
    ["Announce that you just picked up a quest for which you have an incomplete breadcrumb quest"] = {
        ["enUS"] = true,
        ["deDE"] = "Teilt mit, dass du gerade eine Quest angenommen hast, für die du eine unvollständige Brotkrumen-Quest hast.",
        ["esES"] = "Anuncia que acabas de aceptar una misión para la cual tienes una misión previa incompleta",
        ["esMX"] = "Anuncia que acabas de aceptar una misión para la cual tienes una misión previa incompleta",
        ["frFR"] = "Annonce que tu viens d’accepter une quête pour laquelle tu as une quête préliminaire incomplète",
        ["koKR"] = "완료되지 않은 길잡이 퀘스트 아이템을 획득했습니다.",
        ["ptBR"] = "Anuncia que você acabou de aceitar uma missão para a qual tem uma missão preliminar incompleta",
        ["ruRU"] = "Объявляет, что вы только что приняли задание, для которого у вас имеется незавершенное предыдущее задание",
        ["zhCN"] = false,
        ["zhTW"] = false,
    },
    ["You have accepted %s without completing its breadcrumb quest %s"] = {
        ["enUS"] = true,
        ["deDE"] = "Du hast %s angenommen, ohne die dazugehörige Brotkrumen-Quest %s abzuschließen.",
        ["esES"] = "Has aceptado %s sin completar su misión previa %s",
        ["esMX"] = "Has aceptado %s sin completar su misión previa %s",
        ["frFR"] = "Tu as accepté %s sans avoir complété sa quête préliminaire %s",
        ["koKR"] = "%s 퀘스트를 길잡이 퀘스트 %s 이(가) 완료되기 전에 수락했습니다.",
        ["ptBR"] = "Você aceitou %s sem completar sua missão preliminar %s",
        ["ruRU"] = "Вы приняли %s, не выполнив его предзадание %s",
        ["zhCN"] = false,
        ["zhTW"] = false,
    },
    ["Share quest progress with nearby players"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest-Fortschritt mit Spielern in der Nähe teilen",
        ["esES"] = "Compartir el progreso con jugadores cercanos",
        ["esMX"] = "Compartir el progreso con jugadores cercanos",
        ["frFR"] = "Partager la progression avec les joueurs proches",
        ["koKR"] = "근처 플레이어에게 퀘스트 진행 공유",
        ["ptBR"] = "Compartilhar o progresso com jogadores próximos",
        ["ruRU"] = "Делиться прогрессом заданий",
        ["zhCN"] = "与身边玩家分享任务进度",
        ["zhTW"] = "和附近的玩家分享任務進度",
    },
    ["Your quest progress will be periodically sent to nearby players. Disabling this doesn't affect sharing progress with party members."] = {
        ["enUS"] = true,
        ["deDE"] = "Sendet deinen Quests-Fortschritt regelmäßig zu nahegelegenen Spielern",
        ["esES"] = "El progreso de tu misión se enviará periódicamente a los jugadores cercanos.",
        ["esMX"] = "El progreso de tu misión se enviará periódicamente a los jugadores cercanos.",
        ["frFR"] = "La progression de vos quêtes sera régulièrement partagée avec les joueurs proches.",
        ["koKR"] = "퀘스트 진행상황은 정기적으로 근처 플레이어로 전송됩니다. 이 기능을 사용하지 않도록 설정해도 파티원과의 진행률 공유에는 영향을 주지 않습니다.",
        ["ptBR"] = "O progresso de sua missão será enviado periodicamente a jogadores próximos.",
        ["ruRU"] = "Прогресс ваших заданий будет периодически отправляться игрокам, находящимся рядом",
        ["zhCN"] = "你的任务进度將定期的发送给身边玩家",
        ["zhTW"] = "你的任務進度將會定期發送給附近的玩家。停用此選項不會影響與隊友分享任務進度。",
    },
    ["Display announcements locally when outside of a group"] = {
        ["enUS"] = true,
        ["deDE"] = "Ankündigungen anzeigen, wenn du nicht in einer Gruppe bist",
        ["esES"] = "Mostrar anuncios localmente cuando estés fuera de un grupo",
        ["esMX"] = "Mostrar anuncios localmente cuando estés fuera de un grupo",
        ["frFR"] = "Afficher les annonces localement lorsque vous n'êtes pas dans un groupe",
        ["koKR"] = "그룹 외부에서 로컬 알림 표시",
        ["ptBR"] = "Mostrar anúncios localmente quando estiver fora de um grupo",
        ["ruRU"] = "Оповещения вне группы",
        ["zhCN"] = "没在队伍时通报给自己",
        ["zhTW"] = "沒有隊伍時通報給自己",
    },
    ["Questie will print your progress messages to chat when not in a group. Other players will NOT be able to see this."] = {
        ["enUS"] = true,
        ["deDE"] = "Questie wird deine Fortschrittsnachrichten im Chat anzeigen, wenn du nicht in einer Gruppe bist. Andere Spieler werden dies NICHT sehen können.",
        ["esES"] = "Questie imprimirá tus mensajes de progreso al chat cuando no estés en un grupo. Otros jugadores NO podrán ver esto.",
        ["esMX"] = "Questie imprimirá tus mensajes de progreso al chat cuando no estés en un grupo. Otros jugadores NO podrán ver esto.",
        ["frFR"] = "Questie affichera vos messages de progression dans la discussion lorsque vous n'êtes pas dans un groupe. Les autres joueurs NE pourront PAS voir cela.",
        ["koKR"] = "그룹에 속하지 않은 경우 Questie가 진행 메시지를 채팅에 출력합니다. 다른 플레이어는 이를 볼 수 없습니다.",
        ["ptBR"] = "Questie imprimirá suas mensagens de progresso no bate-papo quando você não estiver em um grupo. Outros jogadores NÃO serão capazes de ver isso.",
        ["ruRU"] = "Questie будет отображать в чате оповещения о прогрессе ваших заданий, когда вы вне группы. Другие игроки НЕ БУДУТ видеть эти оповещения",
        ["zhCN"] = "不在队伍时会用系统白色显示你的任务进度信息，其他玩家无法看到。",
        ["zhTW"] = "不在隊伍中時會用系統白字顯示你的任務進度訊息，其他玩家無法看到。",
    },
}

for k, v in pairs(socialOptionsLocales) do
    l10n.translations[k] = v
end
