--[[--
	by ALA
--]]--

local __addon, __private = ...;
local MT = __private.MT;
local CT = __private.CT;
local VT = __private.VT;
local DT = __private.DT;

if not CT.ISCATA then
	return;
end

local DataAgent = DT.DataAgent;

DataAgent.__DataVersion = 240515;

DataAgent.CURPHASE = 3;
DataAgent.MAXPHASE = 3;
DataAgent.MAXRANK = 525;
DataAgent.DBMINPID = 1;
DataAgent.DBMAXPID = 16;

--[==[--
	by ALA
	dbfilesclient
	##	2024-05-16
		Initialize CATA data
--]==]--

local bitclass = {
	["WARRIOR"] = 1,
	["PALADIN"] = 2,
	["HUNTER"] = 4,
	["ROGUE"] = 8,
	["PRIEST"] = 16,
	["DEATHKNIGHT"] = 32,
	["SHAMAN"] = 64,
	["MAGE"] = 128,
	["WARLOCK"] = 256,
	["DRUID"] = 1024,
};
DataAgent.USELFCLASSBIT = bitclass[CT.SELFCLASS];

--[==[
	--	P1	BWD BOT TOF
	--	P2	FL
	--	P3	DS
	防具锻造	9788	= { 34529, 34530, 34533, 34534, 36122, 36124, 36129, 36130, 36256, 36257, }	--	9954, 9974, 
					WLK = { 55183, 55184, 55185, }
	武器锻造	9787	= { 17039, 17040, 17041, 34535, 34537, 34538, 34540, 34541, 34542, 34543, 34544, 34545, 34546, 34547, 34548, 36125, 36126, 36128, 36131, 36133, 36134, 36135, 36136, 36137, 36258, 36259, 36260, 36261, 36262, 36263, }	--	10003, 10007, 10011, 10015, 
					WLK = { 55186, 55187, }
		宗师级铸剑	17039	= { 34535, 34537, 34538, 34540, 36131, 36133, 36258, 36259, }
		宗师级铸锤	17040	= { 34545, 34546, 34547, 34548, 36136, 36137, 36262, 36263, }
		宗师级铸斧	17041	= { 34541, 34542, 34543, 34544, 36134, 36135, 36260, 36261, }
	部落制皮	10660	= { 35585, 35587, 35588, 36075, 36078, }	--	10621, 10647, 
	龙鳞制皮	10656	= { 35575, 35576, 35577, 35580, 35582, 35584, 36076, 36079, }	--	10619, 10650, 24654, 24655, 
	元素制皮	10658	= { 35589, 35590, 35591, 36074, 36077, }	--	10630, 10632, 
	侏儒工程学	20219	= { 12759, 12895, 12897, 12899, 12902, 12903, 12905, 12906, 12907, 23096, 23129, 23489, 30568, 30569, 30570, 30574, 30575, 36955, }
					WLK = { 56473, }
	地精工程学	20222	= { 8895, 12715, 12716, 12717, 12718, 12754, 12755, 12758, 12760, 12908, 13240, 23078, 23486, 30558, 30560, 30563, 30565, 30566, 36954, }
					WLK	= { 56514, }
	魔焰裁缝	26797	= { 26752, 26753, 26754, }
	月布裁缝	26798	= { 26760, 26761, 26762, }
	暗纹裁缝	26801	= { 26756, 26757, 26758, }
	转化大师	28672
	药水大师	28675
					WLK	= { 53895, 53904, 54221, 54222, }
	药剂大师	28677
					WLK	= { 54220, 56519, 60354, 60355, 60356, 60357, 60365, 60366, 62410, }
--]==]

DataAgent.T_TradeSkill_ID = {
	[1] = 3273,		--	FirstAid
	[2] = 2018,		--	Blacksmithing
	[3] = 2108,		--	Leatherworking
	[4] = 2259,		--	Alchemy
	[5] = 2383,		--	Herbalism		--	UNUSED
	[6] = 2550,		--	Cooking
	[7] = 2575,		--	Mining
	[8] = 3908,		--	Tailoring
	[9] = 4036,		--	Engineering
	[10] = 7411,	--	Enchanting
	[11] = 7620,	--	Fishing			--	UNUSED
	[12] = 8613,	--	Skinning		--	UNUSED
	-- [13] = 2842,	--	Poisons			--	Rogue	--	Obsoleted
	[14] = 5149,	--	Beast Training	--	UNUSED	--	Hunter
	[15] = 25229,	--	Jewelcrafting	--	2.0
	[16] = 45357,	--	Inscription		--	3.0
};
DataAgent.T_TradeSkill_Texture = {
	[1] = "Interface\\Icons\\spell_holy_sealofsacrifice",
	[2] = "Interface\\Icons\\trade_blacksmithing",
	[3] = "Interface\\Icons\\trade_leatherworking",
	[4] = "Interface\\Icons\\trade_alchemy",
	[5] = "Interface\\Icons\\trade_herbalism",
	[6] = "Interface\\Icons\\inv_misc_food_15",
	[7] = "Interface\\Icons\\trade_mining",
	[8] = "Interface\\Icons\\trade_tailoring",
	[9] = "Interface\\Icons\\trade_engineering",
	[10] = "Interface\\Icons\\trade_engraving",
	[11] = "Interface\\Icons\\trade_fishing",
	[12] = "Interface\\Icons\\inv_misc_pelt_wolf_01",
	[13] = "Interface\\Icons\\trade_brewpoison",
	[14] = 132162,
	[15] = 134071,
	[16] = 237171,
};
DataAgent.T_TradeSkill_CheckID = {		--	[pid] = p_check_sid
	[1] = 3273,		--	FirstAid
	[2] = 2018,		--	Blacksmithing
	[3] = 2108,		--	Leatherworking
	[4] = 2259,		--	Alchemy
	[5] = 2383,		--	Herbalism		--	UNUSED
	[6] = 2550,		--	Cooking
	[7] = 2656,		--	Mining
	[8] = 3908,		--	Tailoring
	[9] = 4036,		--	Engineering
	[10] = 7411,	--	Enchanting
	[11] = 7620,	--	Fishing			--	UNUSED
	[12] = 8613,	--	Skinning		--	UNUSED
	[13] = 2842,	--	Poisons			--	Rogue
	[14] = 5149,	--	Beast Training	--	UNUSED	--	Hunter
	[15] = 25229,	--	Jewelcrafting	--	2.0
	[16] = 45357,	--	Inscription		--	3.0
};
DataAgent.T_TradeSkill_HasUI = {		--	[pid] = bool
	[1] = true,		--	FirstAid
	[2] = true,		--	Blacksmithing
	[3] = true,		--	Leatherworking
	[4] = true,		--	Alchemy
	[5] = false,	--	Herbalism		--	UNUSED
	[6] = true,		--	Cooking
	[7] = true,		--	Mining
	[8] = true,		--	Tailoring
	[9] = true,		--	Engineering
	[10] = true,	--	Enchanting
	[11] = false,	--	Fishing			--	UNUSED
	[12] = false,	--	Skinning		--	UNUSED
	[13] = true,	--	Poisons			--	Rogue
	[14] = true,	--	Beast Training	--	UNUSED	--	Hunter
	[15] = true,	--	Jewelcrafting	--	2.0
	[16] = true,	--	Inscription		--	3.0
};

-->		Index
	local index_validated = 1;
	local index_phase = 2;
	local index_pid = 3;
	local index_sid = 4;
	local index_cid = 5;
	local index_learn_rank = 6;
	local index_yellow_rank = 7;
	local index_green_rank = 8;
	local index_grey_rank = 9;
	local index_num_made_min = 10;
	local index_num_made_max = 11;
	local index_reagents_id = 12;
	local index_reagents_count = 13;
	local index_trainer = 14;
	local index_train_price = 15;
	local index_recipe = 16;
	local index_quest = 17;
	local index_object = 18;
	local index_class = 19;
	local index_spec = 20;
-->

local T_Recipe_Data = {
--	TradeSkill
	--[[
		SpellEffect.db2
			sid = [36AJ] SpellID
			cid = [14N] EffectItemType
			base = [9I] EffectBasePoints
			side = [13M] EffectDieSides
				side == 0
					min = max(base, 1)
					max = min
				side >0
					min = base + 1
					max = min + side - 1
		SpellReagents.db2
			sid = [2B] SpellID
			reagent = [3C] Reagent...10
			num = [11K] ReagentCount...19
		SkillLineAbility.db2
			通过3SkillLine查表SkillLine.db2得技能名筛选
			sid = [4D] SpellID
			pid = *([3C] SkillLine)
			Grey = [10J] TrivialSkillLineRankLow
			Yellow = [9I] TrivialSkillLineRankHigh
		SkillLine.db2
			[6F] SkillLine
			[1A] DisplayName_lang
		ItemEffect.db2
			[3C] TriggerType == 6 (OnLearn)
			sid = [8H] SpellID
			recipe = [10J] ParentItemID * SpellName
			--	Skip Spell:843
	--]]
	--------------.-PHA-PID-----SID-----CID-LEARN--Y--GREEN-GREY-MIN--MAX---------R-------N--TRAINER-PRICE-RECIPE-QUEST-OBJ-CLASS-SPEC
	--------------1--2---3-------4-------5----6----7----8----9---10---11---------12------13---14-------15-----16---17---18---19----20
--
	--
	[3275]   = { nil, 1,  1,   3275,   1251,   1,  30,  45,  60,  1,  1, { 2589, }, { 1, }, },
	[3276]   = { nil, 1,  1,   3276,   2581,  40,  50,  75, 100,  1,  1, { 2589, }, { 2, }, true, 100, },
	[3277]   = { nil, 1,  1,   3277,   3530,  80,  80, 115, 150,  1,  1, { 2592, }, { 1, }, true, 250, },
	[7934]   = { nil, 1,  1,   7934,   6452,  80,  80, 115, 150,  3,  3, { 1475, }, { 1, }, true, 250, },
	[3278]   = { nil, 1,  1,   3278,   3531, 115, 115, 150, 185,  1,  1, { 2592, }, { 2, }, true, 1000, },
	[7935]   = { nil, 1,  1,   7935,   6453, 130, 130, 165, 200,  3,  3, { 1288, }, { 1, }, nil, nil, { 6454, }, },
	[7928]   = { nil, 1,  1,   7928,   6450, 150, 150, 180, 210,  1,  1, { 4306, }, { 1, }, true, 5000, },
	[7929]   = { nil, 1,  1,   7929,   6451, 180, 180, 210, 240,  1,  1, { 4306, }, { 2, }, true, 5000, { 16112, }, },
	[10840]  = { nil, 1,  1,  10840,   8544, 210, 210, 240, 270,  1,  1, { 4338, }, { 1, }, true, 10000, { 16113, }, },
	[10841]  = { nil, 1,  1,  10841,   8545, 240, 240, 270, 300,  1,  1, { 4338, }, { 2, }, true, 10000, },
	[18629]  = { nil, 1,  1,  18629,  14529, 260, 260, 290, 320,  1,  1, { 14047, }, { 1, }, true, 20000, },
	[18630]  = { nil, 1,  1,  18630,  14530, 290, 290, 320, 350,  1,  1, { 14047, }, { 2, }, true, 20000, },
	[23787]  = { nil, 1,  1,  23787,  19440, 300, 300, 330, 360,  1,  1, { 19441, }, { 1, }, nil, nil, { 19442, }, },
	[27032]  = { nil, 1,  1,  27032,  21990, 300, 330, 347, 365,  1,  1, { 21877, }, { 1, }, true, 20000, },
	[27033]  = { nil, 1,  1,  27033,  21991, 330, 360, 367, 375,  1,  1, { 21877, }, { 2, }, true, 40000, { 21993, }, },
	[45545]  = { nil, 1,  1,  45545,  34721, 350, 375, 392, 410,  1,  1, { 33470, }, { 1, }, true, 40000, },
	[45546]  = { nil, 1,  1,  45546,  34722, 400, 400, 430, 470,  1,  1, { 33470, }, { 2, }, true, 60000, { 39152, }, },
	[74556]  = { nil, 1,  1,  74556,  53049, 425, 450, 467, 485,  1,  1, { 53010, }, { 1, }, true, 60000, },
	[74557]  = { nil, 1,  1,  74557,  53050, 475, 485, 505, 525,  1,  1, { 53010, }, { 2, }, true, 80000, },
	[74558]  = { nil, 1,  1,  74558,  53051, 525, 525, 530, 535,  1,  1, { 53050, }, { 2, }, true, 15000, },
	[88893]  = { nil, 1,  1,  88893,  53051, 525, 525, 530, 535,  1,  1, { 53010, }, { 3, }, true, 80000, },
	[2660]   = { nil, 1,  2,   2660,   2862,   1,  15,  35,  55,  1,  1, { 2835, }, { 1, }, },
	[3115]   = { nil, 1,  2,   3115,   3239,   1,  15,  35,  55,  1,  1, { 2835, 2589, }, { 1, 1, }, },
	[12260]  = { nil, 1,  2,  12260,  10421,   1,  15,  35,  55,  1,  1, { 2840, }, { 4, }, },
	[2663]   = { nil, 1,  2,   2663,   2853,   1,  20,  40,  60,  1,  1, { 2840, }, { 2, }, },
	[2662]   = { nil, 1,  2,   2662,   2852,   1,  50,  70,  90,  1,  1, { 2840, }, { 4, }, true, 50, },
	[2737]   = { nil, 1,  2,   2737,   2844,  15,  55,  75,  95,  1,  1, { 2840, 2880, 2589, }, { 6, 1, 2, }, true, 50, },
	[2738]   = { nil, 1,  2,   2738,   2845,  20,  60,  80, 100,  1,  1, { 2840, 2880, 2589, }, { 6, 1, 2, }, true, 50, },
	[3319]   = { nil, 1,  2,   3319,   3469,  20,  60,  80, 100,  1,  1, { 2840, }, { 8, }, true, 50, },
	[3320]   = { nil, 1,  2,   3320,   3470,  25,  45,  65,  85,  1,  1, { 2835, }, { 2, }, true, 100, },
	[2739]   = { nil, 1,  2,   2739,   2847,  25,  65,  85, 105,  1,  1, { 2840, 2880, 2589, }, { 6, 1, 2, }, true, 50, },
	[8880]   = { nil, 1,  2,   8880,   7166,  30,  70,  90, 110,  1,  1, { 2840, 2880, 3470, 2318, }, { 6, 1, 1, 1, }, true, 100, },
	[9983]   = { nil, 1,  2,   9983,   7955,  30,  70,  90, 110,  1,  1, { 2840, 2880, 3470, 2318, }, { 10, 2, 1, 1, }, true, 100, },
	[2661]   = { nil, 1,  2,   2661,   2851,  35,  75,  95, 115,  1,  1, { 2840, }, { 6, }, true, 100, },
	[3293]   = { nil, 1,  2,   3293,   3488,  35,  75,  95, 115,  1,  1, { 2840, 2880, 774, 3470, 2318, }, { 12, 2, 2, 2, 2, }, true, 250, },
	[3321]   = { nil, 1,  2,   3321,   3471,  35,  75,  95, 115,  1,  1, { 2840, 3470, }, { 8, 2, }, nil, nil, { 3609, }, },
	[43549]  = { nil, 1,  2,  43549,  33791,  35,  75,  95, 115,  1,  1, { 2840, 818, 3470, }, { 10, 1, 2, }, nil, nil, { 33792, }, },
	[3323]   = { nil, 1,  2,   3323,   3472,  40,  80, 100, 120,  1,  1, { 2840, 3470, }, { 8, 2, }, true, 100, },
	[3324]   = { nil, 1,  2,   3324,   3473,  45,  85, 105, 125,  1,  1, { 2840, 2321, 3470, }, { 8, 2, 3, }, true, 200, },
	[3325]   = { nil, 1,  2,   3325,   3474,  60, 100, 120, 140,  1,  1, { 2840, 818, 774, }, { 8, 1, 1, }, nil, nil, { 3610, }, },
	[2665]   = { nil, 1,  2,   2665,   2863,  65,  65,  72,  80,  1,  1, { 2836, }, { 1, }, true, 100, },
	[3116]   = { nil, 1,  2,   3116,   3240,  65,  65,  72,  80,  1,  1, { 2836, 2592, }, { 1, 1, }, true, 100, },
	[7408]   = { nil, 1,  2,   7408,   6214,  65, 105, 125, 145,  1,  1, { 2840, 2880, 2318, }, { 12, 2, 2, }, true, 300, },
	[2666]   = { nil, 1,  2,   2666,   2857,  70, 110, 130, 150,  1,  1, { 2840, }, { 10, }, true, 200, },
	[3294]   = { nil, 1,  2,   3294,   3489,  70, 110, 130, 150,  1,  1, { 2840, 2880, 2842, 3470, 2318, }, { 10, 2, 2, 2, 2, }, true, 500, },
	[8366]   = { nil, 1,  2,   8366,   6730,  70, 110, 130, 150,  1,  1, { 2840, 774, 3470, }, { 12, 2, 2, }, nil, nil, { 6734, }, },
	[3326]   = { nil, 1,  2,   3326,   3478,  75,  75,  87, 100,  1,  1, { 2836, }, { 2, }, true, 250, },
	[2667]   = { nil, 1,  2,   2667,   2864,  80, 120, 140, 160,  1,  1, { 2840, 1210, 3470, }, { 12, 1, 2, }, nil, nil, { 2881, }, },
	[2664]   = { nil, 1,  2,   2664,   2854,  90, 115, 127, 140,  1,  1, { 2840, 3470, }, { 10, 3, }, true, 500, },
	[7817]   = { nil, 1,  2,   7817,   6350,  95, 125, 140, 155,  1,  1, { 2841, 3470, }, { 6, 6, }, true, 200, },
	[3292]   = { nil, 1,  2,   3292,   3487,  95, 135, 155, 175,  1,  1, { 2840, 2880, 818, 2319, }, { 14, 2, 2, 2, }, true, 500, },
	[19666]  = { nil, 1,  2,  19666,  15869, 100, 100, 110, 120,  2,  2, { 2842, 3470, }, { 1, 1, }, true, 100, },
	[7818]   = { nil, 1,  2,   7818,   6338, 100, 105, 107, 110,  1,  1, { 2842, 3470, }, { 1, 2, }, true, 100, },
	[34979]  = { nil, 1,  2,  34979,  29201, 100, 130, 145, 160,  1,  1, { 2841, 3470, 2319, }, { 6, 2, 1, }, true, 600, },
	[8367]   = { nil, 1,  2,   8367,   6731, 100, 140, 160, 180,  1,  1, { 2840, 818, 3470, }, { 16, 2, 3, }, nil, nil, { 6735, }, },
	[2671]   = { nil, 1,  2,   2671,   2867, 100, 145, 160, 175,  1,  1, { 2841, }, { 4, }, nil, nil, { 5577, }, },
	[3491]   = { nil, 1,  2,   3491,   3848, 105, 135, 150, 165,  1,  1, { 2841, 2880, 3470, 818, 2319, }, { 6, 4, 2, 1, 1, }, true, 600, },
	[2668]   = { nil, 1,  2,   2668,   2865, 105, 145, 160, 175,  1,  1, { 2841, }, { 6, }, true, 300, },
	[2670]   = { nil, 1,  2,   2670,   2866, 105, 145, 160, 175,  1,  1, { 2841, }, { 7, }, true, 500, },
	[2740]   = { nil, 1,  2,   2740,   2848, 110, 140, 155, 170,  1,  1, { 2841, 2880, 2319, }, { 6, 4, 1, }, true, 200, },
	[3328]   = { nil, 1,  2,   3328,   3480, 110, 140, 155, 170,  1,  1, { 2841, 3478, }, { 5, 1, }, true, 500, },
	[6517]   = { nil, 1,  2,   6517,   5540, 110, 140, 155, 170,  1,  1, { 2841, 3466, 5498, 3478, }, { 6, 1, 2, 2, }, true, 800, },
	[2741]   = { nil, 1,  2,   2741,   2849, 115, 145, 160, 175,  1,  1, { 2841, 2880, 2319, }, { 7, 4, 1, }, true, 200, },
	[2672]   = { nil, 1,  2,   2672,   2868, 120, 150, 165, 180,  1,  1, { 2841, 3478, }, { 5, 2, }, true, 500, },
	[2742]   = { nil, 1,  2,   2742,   2850, 120, 150, 165, 180,  1,  1, { 2841, 2880, 2319, }, { 5, 4, 2, }, true, 200, },
	[2674]   = { nil, 1,  2,   2674,   2871, 125, 125, 132, 140,  1,  1, { 2838, }, { 1, }, true, 1000, },
	[3117]   = { nil, 1,  2,   3117,   3241, 125, 125, 132, 140,  1,  1, { 2838, 2592, }, { 1, 1, }, true, 1000, },
	[3337]   = { nil, 1,  2,   3337,   3486, 125, 125, 137, 150,  1,  1, { 2838, }, { 3, }, true, 1000, },
	[3295]   = { nil, 1,  2,   3295,   3490, 125, 155, 170, 185,  1,  1, { 2841, 3466, 2459, 1210, 3478, 2319, }, { 4, 1, 1, 2, 2, 2, }, nil, nil, { 2883, }, },
	[3330]   = { nil, 1,  2,   3330,   3481, 125, 155, 170, 185,  1,  1, { 2841, 2842, 3478, }, { 8, 2, 2, }, nil, nil, { 2882, }, },
	[9985]   = { nil, 1,  2,   9985,   7956, 125, 155, 170, 185,  1,  1, { 2841, 3466, 2319, }, { 8, 1, 1, }, true, 250, },
	[2673]   = { nil, 1,  2,   2673,   2869, 130, 160, 175, 190,  1,  1, { 2841, 2842, 3478, }, { 10, 2, 2, }, nil, nil, { 5578, }, },
	[3296]   = { nil, 1,  2,   3296,   3491, 130, 160, 175, 190,  1,  1, { 2841, 3466, 1206, 1210, 3478, 2319, }, { 8, 1, 1, 1, 2, 2, }, true, 1000, },
	[3331]   = { nil, 1,  2,   3331,   3482, 130, 160, 175, 190,  1,  1, { 2841, 2842, 3478, }, { 6, 1, 2, }, true, 500, },
	[9986]   = { nil, 1,  2,   9986,   7957, 130, 160, 175, 190,  1,  1, { 2841, 3466, 2319, }, { 12, 2, 2, }, true, 500, },
	[3333]   = { nil, 1,  2,   3333,   3483, 135, 165, 180, 195,  1,  1, { 2841, 2842, 3478, }, { 8, 1, 2, }, true, 1000, },
	[9987]   = { nil, 1,  2,   9987,   7958, 135, 165, 180, 195,  1,  1, { 2841, 3466, 2319, }, { 14, 1, 2, }, true, 500, },
	[6518]   = { nil, 1,  2,   6518,   5541, 140, 170, 185, 200,  1,  1, { 2841, 3466, 5500, 3478, 2319, }, { 10, 1, 1, 2, 2, }, nil, nil, { 5543, }, },
	[8368]   = { nil, 1,  2,   8368,   6733, 140, 170, 185, 200,  1,  1, { 2841, 1210, 3478, }, { 8, 3, 4, }, nil, nil, { 6736, }, },
	[2675]   = { nil, 1,  2,   2675,   2870, 145, 175, 190, 205,  1,  1, { 2841, 1206, 1705, 5500, 2842, }, { 20, 2, 2, 2, 4, }, true, 1000, },
	[3297]   = { nil, 1,  2,   3297,   3492, 145, 175, 190, 205,  1,  1, { 3575, 3466, 3391, 1705, 3478, 2319, }, { 6, 2, 1, 2, 2, 2, }, nil, nil, { 3608, }, },
	[3334]   = { nil, 1,  2,   3334,   3484, 145, 175, 190, 205,  1,  1, { 3575, 3478, 2605, }, { 6, 2, 1, }, nil, nil, { 3611, }, },
	[8768]   = { nil, 1,  2,   8768,   7071, 150, 150, 152, 155,  2,  2, { 3575, }, { 1, }, true, 250, },
	[19667]  = { nil, 1,  2,  19667,  15870, 150, 150, 160, 170,  2,  2, { 3577, 3486, }, { 1, 1, }, true, 250, },
	[14379]  = { nil, 1,  2,  14379,  11128, 150, 155, 157, 160,  1,  1, { 3577, 3478, }, { 1, 2, }, true, 250, },
	[3336]   = { nil, 1,  2,   3336,   3485, 150, 180, 195, 210,  1,  1, { 3575, 5498, 3478, 2605, }, { 4, 2, 2, 1, }, nil, nil, { 3612, }, },
	[7221]   = { nil, 1,  2,   7221,   6042, 150, 180, 195, 210,  1,  1, { 3575, 3478, }, { 6, 4, }, nil, nil, { 6044, }, },
	[3494]   = { nil, 1,  2,   3494,   3851, 155, 180, 192, 205,  1,  1, { 3575, 3466, 3486, 2842, 4234, }, { 8, 2, 1, 4, 2, }, nil, nil, { 10858, }, },
	[3506]   = { nil, 1,  2,   3506,   3842, 155, 180, 192, 205,  1,  1, { 3575, 3486, 2605, }, { 8, 1, 1, }, true, 5000, },
	[12259]  = { nil, 1,  2,  12259,  10423, 155, 180, 192, 205,  1,  1, { 2841, 2842, 3478, }, { 12, 4, 2, }, nil, nil, { 10424, }, },
	[3492]   = { nil, 1,  2,   3492,   3849, 160, 185, 197, 210,  1,  1, { 3575, 3466, 3486, 1705, 4234, }, { 6, 2, 1, 2, 3, }, nil, nil, { 12162, }, },
	[3504]   = { nil, 1,  2,   3504,   3840, 160, 185, 197, 210,  1,  1, { 3575, 3486, 2605, }, { 7, 1, 1, }, nil, nil, { 3870, }, },
	[9811]   = { nil, 1,  2,   9811,   7913, 160, 185, 197, 210,  1,  1, { 3575, 5635, 3486, }, { 8, 4, 2, }, nil, nil, { 7978, }, },
	[9813]   = { nil, 1,  2,   9813,   7914, 160, 185, 197, 210,  1,  1, { 3575, 3486, }, { 20, 4, }, nil, nil, { 7979, }, },
	[3501]   = { nil, 1,  2,   3501,   3835, 165, 190, 202, 215,  1,  1, { 3575, 2605, }, { 6, 1, }, true, 1000, },
	[7222]   = { nil, 1,  2,   7222,   6043, 165, 190, 202, 215,  1,  1, { 3575, 3478, 1705, }, { 4, 2, 1, }, nil, nil, { 6045, }, },
	[3495]   = { nil, 1,  2,   3495,   3852, 170, 195, 207, 220,  1,  1, { 3575, 3577, 1705, 3466, 4234, 3486, }, { 10, 4, 2, 2, 2, 2, }, nil, nil, { 3867, }, },
	[3502]   = { nil, 1,  2,   3502,   3836, 170, 195, 207, 220,  1,  1, { 3575, 3864, 2605, }, { 12, 1, 1, }, true, 1250, },
	[3507]   = { nil, 1,  2,   3507,   3843, 170, 195, 207, 220,  1,  1, { 3575, 3577, 3486, }, { 10, 2, 1, }, nil, nil, { 3872, }, },
	[3493]   = { nil, 1,  2,   3493,   3850, 175, 200, 212, 225,  1,  1, { 3575, 3466, 3486, 1529, 4234, }, { 8, 2, 2, 2, 3, }, nil, nil, { 3866, }, },
	[3505]   = { nil, 1,  2,   3505,   3841, 175, 200, 212, 225,  1,  1, { 3859, 3577, 3486, }, { 6, 2, 1, }, nil, nil, { 3871, }, },
	[9814]   = { nil, 1,  2,   9814,   7915, 175, 200, 212, 225,  1,  1, { 3575, 5637, 5635, }, { 10, 2, 2, }, nil, nil, { 7980, }, },
	[3496]   = { nil, 1,  2,   3496,   3853, 180, 205, 217, 230,  1,  1, { 3859, 3466, 3486, 1705, 4234, }, { 8, 2, 2, 3, 3, }, nil, nil, { 12163, }, },
	[3508]   = { nil, 1,  2,   3508,   3844, 180, 205, 217, 230,  1,  1, { 3575, 3486, 1529, 1206, 4255, }, { 20, 4, 2, 2, 1, }, true, 7500, },
	[9818]   = { nil, 1,  2,   9818,   7916, 180, 205, 217, 230,  1,  1, { 3575, 5637, 3486, }, { 12, 4, 2, }, nil, nil, { 7981, }, },
	[15972]  = { nil, 1,  2,  15972,  12259, 180, 205, 217, 230,  1,  1, { 3859, 3466, 1206, 7067, 4234, }, { 10, 2, 1, 1, 1, }, true, 7500, },
	[3498]   = { nil, 1,  2,   3498,   3855, 185, 210, 222, 235,  1,  1, { 3575, 3466, 3486, 3577, 4234, }, { 14, 2, 2, 4, 2, }, nil, nil, { 12164, }, },
	[3513]   = { nil, 1,  2,   3513,   3846, 185, 210, 222, 235,  1,  1, { 3859, 3864, 1705, 3486, }, { 8, 1, 1, 2, }, nil, nil, { 3874, }, },
	[7223]   = { nil, 1,  2,   7223,   6040, 185, 210, 222, 235,  1,  1, { 3859, 3486, }, { 5, 2, }, true, 1000, },
	[9820]   = { nil, 1,  2,   9820,   7917, 185, 210, 222, 235,  1,  1, { 3575, 3486, 5637, }, { 14, 3, 2, }, nil, nil, { 7982, }, },
	[3503]   = { nil, 1,  2,   3503,   3837, 190, 215, 227, 240,  1,  1, { 3859, 3577, 3486, }, { 8, 2, 2, }, nil, nil, { 6047, }, },
	[7224]   = { nil, 1,  2,   7224,   6041, 190, 215, 227, 240,  1,  1, { 3859, 3486, 4234, }, { 8, 2, 4, }, nil, nil, { 6046, }, },
	[15973]  = { nil, 1,  2,  15973,  12260, 190, 215, 227, 240,  1,  1, { 3859, 3577, 7068, 4234, }, { 10, 4, 2, 2, }, nil, nil, { 12261, }, },
	[21913]  = { nil, 1,  2,  21913,  17704, 190, 215, 227, 240,  1,  1, { 3859, 3829, 7070, 7069, 4234, }, { 10, 1, 2, 2, 2, }, nil, nil, { 17706, }, },
	[3511]   = { nil, 1,  2,   3511,   3845, 195, 220, 232, 245,  1,  1, { 3859, 3577, 3486, }, { 12, 2, 4, }, nil, nil, { 3873, }, },
	[9918]   = { nil, 1,  2,   9918,   7964, 200, 200, 205, 210,  1,  1, { 7912, }, { 1, }, true, 2500, },
	[9920]   = { nil, 1,  2,   9920,   7966, 200, 200, 205, 210,  1,  1, { 7912, }, { 4, }, true, 2500, },
	[9921]   = { nil, 1,  2,   9921,   7965, 200, 200, 205, 210,  1,  1, { 7912, 4306, }, { 1, 1, }, true, 2500, },
	[19668]  = { nil, 1,  2,  19668,  15871, 200, 200, 210, 220,  2,  2, { 6037, 7966, }, { 1, 1, }, true, 2500, },
	[14380]  = { nil, 1,  2,  14380,  11144, 200, 205, 207, 210,  1,  1, { 6037, 3486, }, { 1, 1, }, true, 2500, },
	[34981]  = { nil, 1,  2,  34981,  29202, 200, 220, 230, 240,  1,  1, { 3859, 7069, 3486, 4234, }, { 5, 2, 2, 1, }, true, 7500, },
	[3497]   = { nil, 1,  2,   3497,   3854, 200, 225, 237, 250,  1,  1, { 3859, 1529, 3829, }, { 12, 2, 2, }, nil, nil, { 3868, }, },
	[3500]   = { nil, 1,  2,   3500,   3856, 200, 225, 237, 250,  1,  1, { 3859, 3864, 3824, }, { 10, 2, 2, }, nil, nil, { 3869, }, },
	[3515]   = { nil, 1,  2,   3515,   3847, 200, 225, 237, 250,  1,  1, { 3859, 3577, 3486, }, { 10, 4, 4, }, nil, nil, { 3875, }, },
	[9916]   = { nil, 1,  2,   9916,   7963, 200, 225, 237, 250,  1,  1, { 3859, 3486, }, { 16, 3, }, true, 2500, },
	[11454]  = { nil, 1,  2,  11454,   9060, 200, 225, 237, 250,  1,  1, { 3860, 3577, 6037, }, { 5, 1, 1, }, nil, nil, { 10713, }, },
	[9926]   = { nil, 1,  2,   9926,   7918, 205, 225, 235, 245,  1,  1, { 3860, 4234, }, { 8, 6, }, true, 5000, },
	[9928]   = { nil, 1,  2,   9928,   7919, 205, 225, 235, 245,  1,  1, { 3860, 4338, }, { 6, 4, }, true, 5000, },
	[11643]  = { nil, 1,  2,  11643,   9366, 205, 225, 235, 245,  1,  1, { 3859, 3577, 3486, }, { 10, 4, 4, }, nil, nil, { 9367, }, },
	[9931]   = { nil, 1,  2,   9931,   7920, 210, 230, 240, 250,  1,  1, { 3860, }, { 12, }, true, 5000, },
	[9933]   = { nil, 1,  2,   9933,   7921, 210, 230, 240, 250,  1,  1, { 3860, }, { 10, }, nil, nil, { 7975, }, },
	[9993]   = { nil, 1,  2,   9993,   7941, 210, 235, 247, 260,  1,  1, { 3860, 3864, 7966, 4234, }, { 12, 2, 1, 4, }, true, 10000, },
	[9935]   = { nil, 1,  2,   9935,   7922, 215, 235, 245, 255,  1,  1, { 3859, 3864, 7966, }, { 14, 1, 1, }, true, 5000, },
	[9937]   = { nil, 1,  2,   9937,   7924, 215, 235, 245, 255,  1,  1, { 3860, }, { 8, }, nil, nil, { 7995, }, },
	[9939]   = { nil, 1,  2,   9939,   7967, 215, 235, 245, 255,  1,  1, { 3860, 6037, 7966, }, { 4, 2, 4, }, nil, nil, { 7976, }, },
	[9942]   = { nil, 1,  2,   9942,   7925, 220, 240, 250, 260,  1,  1, { 3860, 4234, 4338, }, { 8, 6, 4, }, nil, nil, { 7977, }, },
	[9945]   = { nil, 1,  2,   9945,   7926, 220, 240, 250, 260,  1,  1, { 3860, 6037, 7966, }, { 12, 1, 1, }, nil, nil, { 7983, }, },
	[9950]   = { nil, 1,  2,   9950,   7927, 220, 240, 250, 260,  1,  1, { 3860, 4338, 6037, 7966, }, { 10, 6, 1, 1, }, nil, nil, { 7984, }, },
	[9995]   = { nil, 1,  2,   9995,   7942, 220, 245, 257, 270,  1,  1, { 3860, 7909, 7966, 4304, }, { 16, 2, 1, 4, }, nil, nil, { 7992, }, },
	[9952]   = { nil, 1,  2,   9952,   7928, 225, 245, 255, 265,  1,  1, { 3860, 6037, 4304, }, { 12, 1, 6, }, nil, nil, { 7985, }, },
	[9954]   = { nil, 1,  2,   9954,   7938, 225, 245, 255, 265,  1,  1, { 3860, 6037, 7909, 3864, 5966, 7966, }, { 10, 8, 3, 3, 1, 2, }, },
	[9997]   = { nil, 1,  2,   9997,   7943, 225, 250, 262, 275,  1,  1, { 3860, 6037, 7966, 4304, }, { 14, 4, 1, 2, }, nil, nil, { 8029, }, },
	[9957]   = { nil, 1,  2,   9957,   7929, 230, 250, 260, 270,  1,  1, { 3860, 7067, }, { 12, 1, }, nil, nil, { 7994, }, },
	[9959]   = { nil, 1,  2,   9959,   7930, 230, 250, 260, 270,  1,  1, { 3860, }, { 16, }, true, 15000, },
	[9961]   = { nil, 1,  2,   9961,   7931, 230, 250, 260, 270,  1,  1, { 3860, 4338, }, { 10, 6, }, true, 15000, },
	[10001]  = { nil, 1,  2,  10001,   7945, 230, 255, 267, 280,  1,  1, { 3860, 7971, 1210, 7966, 4304, }, { 16, 1, 4, 1, 2, }, true, 15000, },
	[9964]   = { nil, 1,  2,   9964,   7969, 235, 255, 265, 275,  1,  1, { 3860, 7966, }, { 4, 3, }, nil, nil, { 7989, }, },
	[9966]   = { nil, 1,  2,   9966,   7932, 235, 255, 265, 275,  1,  1, { 3860, 4304, }, { 14, 4, }, nil, nil, { 7991, }, },
	[9968]   = { nil, 1,  2,   9968,   7933, 235, 255, 265, 275,  1,  1, { 3860, 4304, }, { 14, 4, }, true, 20000, },
	[10003]  = { nil, 1,  2,  10003,   7954, 235, 260, 272, 285,  1,  1, { 3860, 7075, 6037, 3864, 1529, 7966, 4304, }, { 24, 4, 6, 5, 5, 4, 4, }, },
	[9972]   = { nil, 1,  2,   9972,   7935, 240, 260, 270, 280,  1,  1, { 3860, 6037, 7077, 7966, }, { 16, 6, 1, 1, }, nil, nil, { 7986, }, },
	[10005]  = { nil, 1,  2,  10005,   7944, 240, 265, 277, 290,  1,  1, { 3860, 7909, 1705, 1206, 7966, 4338, }, { 14, 1, 2, 2, 1, 2, }, nil, nil, { 7993, }, },
	[9970]   = { nil, 1,  2,   9970,   7934, 245, 255, 265, 275,  1,  1, { 3860, 7909, }, { 14, 1, }, nil, nil, { 7990, }, },
	[9974]   = { nil, 1,  2,   9974,   7939, 245, 265, 275, 285,  1,  1, { 3860, 6037, 7910, 7971, 7966, }, { 12, 12, 2, 2, 2, }, },
	[9979]   = { nil, 1,  2,   9979,   7936, 245, 265, 275, 285,  1,  1, { 3860, 6037, 4304, 7966, 7909, }, { 14, 2, 4, 1, 1, }, nil, nil, { 7988, }, },
	[9980]   = { nil, 1,  2,   9980,   7937, 245, 265, 275, 285,  1,  1, { 3860, 6037, 7966, }, { 16, 2, 1, }, nil, nil, { 7987, }, },
	[10007]  = { nil, 1,  2,  10007,   7961, 245, 270, 282, 295,  1,  1, { 3860, 7081, 6037, 3823, 7909, 7966, 4304, }, { 28, 6, 8, 2, 6, 4, 2, }, },
	[10009]  = { nil, 1,  2,  10009,   7946, 245, 270, 282, 295,  1,  1, { 3860, 7075, 7966, 4304, }, { 18, 2, 1, 4, }, nil, nil, { 8028, }, },
	[16639]  = { nil, 1,  2,  16639,  12644, 250, 255, 257, 260,  1,  1, { 12365, }, { 4, }, true, 10000, },
	[16640]  = { nil, 1,  2,  16640,  12643, 250, 255, 257, 260,  1,  1, { 12365, 14047, }, { 1, 1, }, true, 10000, },
	[16641]  = { nil, 1,  2,  16641,  12404, 250, 255, 257, 260,  1,  1, { 12365, }, { 1, }, true, 10000, },
	[16642]  = { nil, 1,  2,  16642,  12405, 250, 270, 280, 290,  1,  1, { 12359, 12361, }, { 16, 1, }, true, 10000, { 12682, }, },
	[16643]  = { nil, 1,  2,  16643,  12406, 250, 270, 280, 290,  1,  1, { 12359, }, { 8, }, true, 10000, { 12683, }, },
	[10011]  = { nil, 1,  2,  10011,   7959, 250, 275, 287, 300,  1,  1, { 3860, 7972, 6037, 7966, 4304, }, { 28, 10, 10, 6, 6, }, },
	[16644]  = { nil, 1,  2,  16644,  12408, 255, 275, 285, 295,  1,  1, { 12359, }, { 8, }, true, 10000, { 12684, }, },
	[10013]  = { nil, 1,  2,  10013,   7947, 255, 280, 292, 305,  1,  1, { 3860, 6037, 7910, 7966, 4304, }, { 12, 6, 2, 1, 2, }, nil, nil, { 8030, }, },
	[16645]  = { nil, 1,  2,  16645,  12416, 260, 280, 290, 300,  1,  1, { 12359, 7077, }, { 10, 2, }, nil, nil, { 12685, }, },
	[36122]  = { nil, 1,  2,  36122,  30069, 260, 280, 290, 300,  1,  1, { 3860, 7075, }, { 16, 2, }, },
	[36124]  = { nil, 1,  2,  36124,  30070, 260, 280, 290, 300,  1,  1, { 3860, 7081, }, { 16, 2, }, },
	[36125]  = { nil, 1,  2,  36125,  30071, 260, 280, 290, 300,  1,  1, { 3860, 7075, }, { 12, 4, }, },
	[36126]  = { nil, 1,  2,  36126,  30072, 260, 280, 290, 300,  1,  1, { 3860, 7081, }, { 12, 4, }, },
	[36128]  = { nil, 1,  2,  36128,  30073, 260, 280, 290, 300,  1,  1, { 3860, 7077, }, { 12, 4, }, },
	[10015]  = { nil, 1,  2,  10015,   7960, 260, 285, 297, 310,  1,  1, { 3860, 6037, 7910, 7081, 7966, 4304, }, { 30, 16, 6, 4, 8, 6, }, },
	[16960]  = { nil, 1,  2,  16960,  12764, 260, 285, 297, 310,  1,  1, { 12359, 12644, 8170, }, { 10, 2, 4, }, nil, nil, { 12816, }, },
	[15292]  = { nil, 1,  2,  15292,  11608, 265, 285, 295, 305,  1,  1, { 11371, 7077, }, { 18, 4, }, nil, nil, { 11610, }, },
	[16646]  = { nil, 1,  2,  16646,  12428, 265, 285, 295, 305,  1,  1, { 12359, 8170, }, { 12, 6, }, true, 10000, { 12687, }, },
	[16647]  = { nil, 1,  2,  16647,  12424, 265, 285, 295, 305,  1,  1, { 12359, 8170, }, { 10, 6, }, true, 10000, { 12688, }, },
	[15293]  = { nil, 1,  2,  15293,  11606, 270, 290, 300, 310,  1,  1, { 11371, 7077, }, { 10, 2, }, nil, nil, { 11614, }, },
	[16648]  = { nil, 1,  2,  16648,  12415, 270, 290, 300, 310,  1,  1, { 12359, 7077, 7910, }, { 18, 2, 1, }, nil, nil, { 12689, }, },
	[16649]  = { nil, 1,  2,  16649,  12425, 270, 290, 300, 310,  1,  1, { 12359, }, { 12, }, true, 10000, { 12690, }, },
	[16650]  = { nil, 1,  2,  16650,  12624, 270, 290, 300, 310,  1,  1, { 12359, 12655, 12803, 8153, 12364, }, { 40, 2, 4, 4, 1, }, nil, nil, { 12691, }, },
	[16965]  = { nil, 1,  2,  16965,  12769, 270, 295, 307, 320,  1,  1, { 12359, 12803, 8153, 12799, 12644, 8170, }, { 30, 6, 6, 6, 2, 8, }, nil, nil, { 12817, }, },
	[16967]  = { nil, 1,  2,  16967,  12772, 270, 295, 307, 320,  1,  1, { 12359, 3577, 6037, 12361, 8170, }, { 30, 4, 2, 2, 4, }, nil, nil, { 12818, }, },
	[19669]  = { nil, 1,  2,  19669,  15872, 275, 275, 280, 285,  2,  2, { 12360, 12644, }, { 1, 1, }, true, 10000, },
	[20201]  = { nil, 1,  2,  20201,  16206, 275, 275, 280, 285,  1,  1, { 12360, 12644, }, { 3, 1, }, true, 10000, },
	[15294]  = { nil, 1,  2,  15294,  11607, 275, 295, 305, 315,  1,  1, { 11371, 7077, }, { 26, 4, }, nil, nil, { 11611, }, },
	[16651]  = { nil, 1,  2,  16651,  12645, 275, 295, 305, 315,  1,  1, { 12359, 12644, 7076, }, { 4, 4, 2, }, nil, nil, { 12692, }, },
	[16969]  = { nil, 1,  2,  16969,  12773, 275, 300, 312, 325,  1,  1, { 12359, 12799, 12644, 8170, }, { 10, 2, 2, 4, }, true, 15000, { 12819, }, },
	[16970]  = { nil, 1,  2,  16970,  12774, 275, 300, 312, 325,  1,  1, { 12359, 12655, 7910, 12361, 12644, 8170, }, { 30, 4, 4, 4, 2, 4, }, nil, nil, { 12821, }, },
	[15295]  = { nil, 1,  2,  15295,  11605, 280, 300, 310, 320,  1,  1, { 11371, 7077, }, { 6, 1, }, nil, nil, { 11615, }, },
	[16652]  = { nil, 1,  2,  16652,  12409, 280, 300, 310, 320,  1,  1, { 12359, 8170, }, { 12, 8, }, true, 10000, { 12693, }, },
	[16653]  = { nil, 1,  2,  16653,  12410, 280, 300, 310, 320,  1,  1, { 12359, 7910, }, { 12, 1, }, true, 10000, { 12694, }, },
	[16971]  = { nil, 1,  2,  16971,  12775, 280, 305, 317, 330,  1,  1, { 12359, 12644, 8170, }, { 12, 6, 6, }, true, 15000, { 12823, }, },
	[16973]  = { nil, 1,  2,  16973,  12776, 280, 305, 317, 330,  1,  1, { 12359, 12655, 12364, 12804, 8170, }, { 20, 6, 2, 4, 4, }, nil, nil, { 12824, }, },
	[16978]  = { nil, 1,  2,  16978,  12777, 280, 305, 317, 330,  1,  1, { 12655, 7078, 7077, 12800, 12644, }, { 10, 4, 4, 2, 2, }, nil, nil, { 12825, }, },
	[15296]  = { nil, 1,  2,  15296,  11604, 285, 305, 315, 325,  1,  1, { 11371, 7077, }, { 20, 8, }, nil, nil, { 11612, }, },
	[16654]  = { nil, 1,  2,  16654,  12418, 285, 305, 315, 325,  1,  1, { 12359, 7077, }, { 18, 4, }, nil, nil, { 12695, }, },
	[16667]  = { nil, 1,  2,  16667,  12628, 285, 305, 315, 325,  1,  1, { 12359, 12662, 12361, 7910, }, { 40, 10, 4, 4, }, nil, nil, { 12696, }, },
	[16980]  = { nil, 1,  2,  16980,  12779, 285, 310, 322, 335,  1,  1, { 12359, 12799, 12644, 8170, }, { 30, 2, 2, 4, }, nil, nil, { 12826, }, },
	[16983]  = { nil, 1,  2,  16983,  12781, 285, 310, 322, 335,  1,  1, { 12655, 12360, 12804, 12799, 12361, 12364, }, { 6, 2, 4, 2, 2, 1, }, nil, nil, { 12827, }, },
	[16655]  = { nil, 1,  2,  16655,  12631, 290, 310, 320, 330,  1,  1, { 12359, 12655, 7078, 7910, }, { 20, 6, 2, 4, }, nil, nil, { 12699, }, },
	[16656]  = { nil, 1,  2,  16656,  12419, 290, 310, 320, 330,  1,  1, { 12359, 7077, }, { 14, 4, }, nil, nil, { 12697, }, },
	[16660]  = { nil, 1,  2,  16660,  12625, 290, 310, 320, 330,  1,  1, { 12359, 12360, 12364, 7080, }, { 20, 4, 2, 2, }, nil, nil, { 12698, }, },
	[23628]  = { nil, 1,  2,  23628,  19043, 290, 310, 320, 330,  1,  1, { 12359, 7076, 12803, }, { 12, 3, 3, }, nil, nil, { 19202, }, },
	[23632]  = { nil, 1,  2,  23632,  19051, 290, 310, 320, 330,  1,  1, { 12359, 6037, 12811, }, { 8, 6, 1, }, nil, nil, { 19203, }, },
	[16984]  = { nil, 1,  2,  16984,  12792, 290, 315, 327, 340,  1,  1, { 12359, 7077, 7910, 8170, }, { 30, 4, 4, 4, }, nil, nil, { 12828, }, },
	[16985]  = { nil, 1,  2,  16985,  12782, 290, 315, 327, 340,  1,  1, { 12359, 12360, 12662, 12808, 12361, 12644, 8170, }, { 40, 2, 16, 8, 2, 2, 4, }, nil, nil, { 12830, }, },
	[16657]  = { nil, 1,  2,  16657,  12426, 295, 315, 325, 335,  1,  1, { 12359, }, { 18, }, true, 10000, { 12700, }, },
	[16658]  = { nil, 1,  2,  16658,  12427, 295, 315, 325, 335,  1,  1, { 12359, 7910, }, { 18, 1, }, true, 10000, { 12701, }, },
	[16659]  = { nil, 1,  2,  16659,  12417, 295, 315, 325, 335,  1,  1, { 12359, 7077, }, { 18, 4, }, nil, nil, { 12702, }, },
	[16661]  = { nil, 1,  2,  16661,  12632, 295, 315, 325, 335,  1,  1, { 12359, 12655, 7080, 12361, }, { 20, 4, 4, 4, }, nil, nil, { 12703, }, },
	[20872]  = { nil, 1,  2,  20872,  16989, 295, 315, 325, 335,  1,  1, { 11371, 17010, 17011, }, { 6, 3, 3, }, nil, nil, { 17049, }, },
	[20874]  = { nil, 1,  2,  20874,  17014, 295, 315, 325, 335,  1,  1, { 11371, 17010, 17011, }, { 4, 2, 2, }, nil, nil, { 17051, }, },
	[29654]  = { nil, 1,  2,  29654,  23528, 300, 300, 305, 310,  1,  1, { 23445, 22573, }, { 1, 1, }, true, 15000, },
	[32655]  = { nil, 1,  2,  32655,  25843, 300, 300, 305, 310,  1,  1, { 23445, }, { 6, }, true, 10000, },
	[34607]  = { nil, 1,  2,  34607,  28420, 300, 300, 305, 310,  1,  1, { 23445, 21877, }, { 1, 1, }, true, 15000, },
	[22757]  = { nil, 1,  2,  22757,  18262, 300, 300, 310, 320,  1,  1, { 7067, 12365, }, { 2, 3, }, nil, nil, { 18264, }, },
	[29545]  = { nil, 1,  2,  29545,  23482, 300, 310, 320, 330,  1,  1, { 23445, }, { 4, }, true, 15000, },
	[29551]  = { nil, 1,  2,  29551,  23493, 300, 310, 320, 330,  1,  1, { 23445, }, { 4, }, true, 15000, },
	[16662]  = { nil, 1,  2,  16662,  12414, 300, 320, 330, 340,  1,  1, { 12359, }, { 12, }, true, 12000, { 12704, }, },
	[16663]  = { nil, 1,  2,  16663,  12422, 300, 320, 330, 340,  1,  1, { 12359, }, { 20, }, true, 12000, { 12705, }, },
	[16664]  = { nil, 1,  2,  16664,  12610, 300, 320, 330, 340,  1,  1, { 12359, 12360, 3577, }, { 20, 2, 6, }, nil, nil, { 12706, }, },
	[16665]  = { nil, 1,  2,  16665,  12611, 300, 320, 330, 340,  1,  1, { 12359, 12360, 2842, }, { 20, 2, 10, }, nil, nil, { 12707, }, },
	[16724]  = { nil, 1,  2,  16724,  12633, 300, 320, 330, 340,  1,  1, { 12359, 12655, 6037, 3577, 12800, }, { 20, 4, 6, 6, 2, }, nil, nil, { 12711, }, },
	[16725]  = { nil, 1,  2,  16725,  12420, 300, 320, 330, 340,  1,  1, { 12359, 7077, }, { 20, 4, }, nil, nil, { 12713, }, },
	[16726]  = { nil, 1,  2,  16726,  12612, 300, 320, 330, 340,  1,  1, { 12359, 12360, 6037, 12364, }, { 30, 2, 2, 1, }, nil, nil, { 12714, }, },
	[16728]  = { nil, 1,  2,  16728,  12636, 300, 320, 330, 340,  1,  1, { 12359, 12655, 12799, 12364, }, { 40, 4, 6, 2, }, nil, nil, { 12716, }, },
	[16729]  = { nil, 1,  2,  16729,  12640, 300, 320, 330, 340,  1,  1, { 12359, 12360, 12361, 12800, }, { 80, 12, 10, 4, }, nil, nil, { 12717, }, },
	[16730]  = { nil, 1,  2,  16730,  12429, 300, 320, 330, 340,  1,  1, { 12359, }, { 24, }, true, 12000, { 12715, }, },
	[16731]  = { nil, 1,  2,  16731,  12613, 300, 320, 330, 340,  1,  1, { 12359, 12360, 7910, }, { 40, 2, 1, }, nil, nil, { 12718, }, },
	[16732]  = { nil, 1,  2,  16732,  12614, 300, 320, 330, 340,  1,  1, { 12359, 12360, 7910, }, { 40, 2, 1, }, nil, nil, { 12719, }, },
	[16741]  = { nil, 1,  2,  16741,  12639, 300, 320, 330, 340,  1,  1, { 12360, 12655, 7076, 12361, 12799, }, { 15, 20, 10, 4, 4, }, nil, nil, { 12720, }, },
	[16742]  = { nil, 1,  2,  16742,  12620, 300, 320, 330, 340,  1,  1, { 12360, 12655, 7076, 12799, 12800, }, { 6, 16, 6, 2, 1, }, nil, nil, { 12725, }, },
	[16744]  = { nil, 1,  2,  16744,  12619, 300, 320, 330, 340,  1,  1, { 12360, 12655, 7080, 12361, 12364, }, { 10, 20, 6, 2, 1, }, nil, nil, { 12726, }, },
	[16745]  = { nil, 1,  2,  16745,  12618, 300, 320, 330, 340,  1,  1, { 12360, 12655, 7076, 7080, 12364, 12800, }, { 8, 24, 4, 4, 2, 2, }, nil, nil, { 12727, }, },
	[16746]  = { nil, 1,  2,  16746,  12641, 300, 320, 330, 340,  1,  1, { 12360, 12655, 12364, 12800, }, { 30, 30, 6, 6, }, nil, nil, { 12728, }, },
	[16988]  = { nil, 1,  2,  16988,  12796, 300, 320, 330, 340,  1,  1, { 12359, 12360, 12809, 12810, 7076, }, { 50, 15, 4, 6, 10, }, nil, nil, { 12833, }, },
	[16990]  = { nil, 1,  2,  16990,  12790, 300, 320, 330, 340,  1,  1, { 12360, 12800, 12811, 12799, 12810, 12644, }, { 15, 8, 1, 4, 8, 2, }, nil, nil, { 12834, }, },
	[16991]  = { nil, 1,  2,  16991,  12798, 300, 320, 330, 340,  1,  1, { 12359, 12360, 12808, 12364, 12644, 12810, }, { 40, 12, 10, 8, 2, 4, }, nil, nil, { 12835, }, },
	[16992]  = { nil, 1,  2,  16992,  12797, 300, 320, 330, 340,  1,  1, { 12360, 12361, 12800, 7080, 12644, 12810, }, { 18, 8, 8, 4, 2, 4, }, nil, nil, { 12836, }, },
	[16993]  = { nil, 1,  2,  16993,  12794, 300, 320, 330, 340,  1,  1, { 12655, 12364, 12799, 7076, 12810, }, { 20, 8, 8, 6, 4, }, nil, nil, { 12837, }, },
	[16994]  = { nil, 1,  2,  16994,  12784, 300, 320, 330, 340,  1,  1, { 12360, 12810, 12644, }, { 20, 6, 2, }, nil, nil, { 12838, }, },
	[16995]  = { nil, 1,  2,  16995,  12783, 300, 320, 330, 340,  1,  1, { 12360, 12655, 12810, 7910, 12800, 12799, 12644, }, { 10, 10, 2, 6, 6, 6, 4, }, nil, nil, { 12839, }, },
	[20873]  = { nil, 1,  2,  20873,  16988, 300, 320, 330, 340,  1,  1, { 11371, 17010, 17011, }, { 16, 4, 5, }, nil, nil, { 17053, }, },
	[20876]  = { nil, 1,  2,  20876,  17013, 300, 320, 330, 340,  1,  1, { 11371, 17010, 17011, }, { 16, 4, 6, }, nil, nil, { 17052, }, },
	[20890]  = { nil, 1,  2,  20890,  17015, 300, 320, 330, 340,  1,  1, { 11371, 17010, 11382, 12810, }, { 16, 12, 2, 2, }, nil, nil, { 17059, }, },
	[20897]  = { nil, 1,  2,  20897,  17016, 300, 320, 330, 340,  1,  1, { 11371, 17011, 11382, 12810, }, { 18, 12, 2, 2, }, nil, nil, { 17060, }, },
	[23629]  = { nil, 1,  2,  23629,  19048, 300, 320, 330, 340,  1,  1, { 12360, 7076, 12803, }, { 4, 6, 6, }, nil, nil, { 19204, }, },
	[23633]  = { nil, 1,  2,  23633,  19057, 300, 320, 330, 340,  1,  1, { 12360, 6037, 12811, }, { 2, 10, 1, }, nil, nil, { 19205, }, },
	[23636]  = { nil, 1,  2,  23636,  19148, 300, 320, 330, 340,  1,  1, { 17011, 17010, 11371, }, { 4, 2, 4, }, nil, nil, { 19206, }, },
	[23637]  = { nil, 1,  2,  23637,  19164, 300, 320, 330, 340,  1,  1, { 17011, 17010, 17012, 11371, 11382, }, { 3, 5, 4, 4, 2, }, nil, nil, { 19207, }, },
	[23638]  = { nil, 1,  2,  23638,  19166, 300, 320, 330, 340,  1,  1, { 17011, 17010, 12360, 11382, 11371, }, { 3, 6, 12, 1, 4, }, nil, nil, { 19208, }, },
	[23639]  = { nil, 1,  2,  23639,  19167, 300, 320, 330, 340,  1,  1, { 17011, 17010, 12360, 11371, }, { 5, 2, 16, 6, }, nil, nil, { 19209, }, },
	[23650]  = { nil, 1,  2,  23650,  19170, 300, 320, 330, 340,  1,  1, { 17011, 17010, 12360, 11371, 12800, }, { 4, 7, 12, 8, 4, }, nil, nil, { 19210, }, },
	[23652]  = { nil, 1,  2,  23652,  19168, 300, 320, 330, 340,  1,  1, { 17011, 17010, 12360, 11371, 12809, }, { 6, 6, 10, 6, 12, }, nil, nil, { 19211, }, },
	[23653]  = { nil, 1,  2,  23653,  19169, 300, 320, 330, 340,  1,  1, { 17011, 17010, 12360, 11371, 12364, }, { 8, 5, 10, 12, 4, }, nil, nil, { 19212, }, },
	[24136]  = { nil, 1,  2,  24136,  19690, 300, 320, 330, 340,  1,  1, { 12359, 7910, }, { 20, 2, }, nil, nil, { 19776, }, },
	[24137]  = { nil, 1,  2,  24137,  19691, 300, 320, 330, 340,  1,  1, { 12359, 7910, }, { 16, 1, }, nil, nil, { 19777, }, },
	[24138]  = { nil, 1,  2,  24138,  19692, 300, 320, 330, 340,  1,  1, { 12359, 12810, }, { 12, 4, }, nil, nil, { 19778, }, },
	[24139]  = { nil, 1,  2,  24139,  19693, 300, 320, 330, 340,  1,  1, { 12359, 12799, }, { 20, 2, }, nil, nil, { 19779, }, },
	[24140]  = { nil, 1,  2,  24140,  19694, 300, 320, 330, 340,  1,  1, { 12359, 12799, }, { 18, 2, }, nil, nil, { 19780, }, },
	[24141]  = { nil, 1,  2,  24141,  19695, 300, 320, 330, 340,  1,  1, { 12359, 12799, }, { 16, 2, }, nil, nil, { 19781, }, },
	[24399]  = { nil, 1,  2,  24399,  20039, 300, 320, 330, 340,  1,  1, { 17011, 17010, 17012, 11371, }, { 3, 3, 4, 6, }, nil, nil, { 20040, }, },
	[24912]  = { nil, 1,  2,  24912,  20549, 300, 320, 330, 340,  1,  1, { 12359, 20520, 6037, 12810, }, { 12, 6, 6, 2, }, nil, nil, { 20553, }, },
	[24913]  = { nil, 1,  2,  24913,  20551, 300, 320, 330, 340,  1,  1, { 12359, 20520, 6037, 11754, }, { 16, 8, 8, 1, }, nil, nil, { 20555, }, },
	[24914]  = { nil, 1,  2,  24914,  20550, 300, 320, 330, 340,  1,  1, { 12359, 20520, 6037, }, { 20, 10, 10, }, nil, nil, { 20554, }, },
	[27585]  = { nil, 1,  2,  27585,  22197, 300, 320, 330, 340,  1,  1, { 22202, 12655, 7076, }, { 14, 4, 2, }, nil, nil, { 22209, }, },
	[27586]  = { nil, 1,  2,  27586,  22198, 300, 320, 330, 340,  1,  1, { 22203, 22202, 12655, 7076, }, { 8, 24, 8, 4, }, nil, nil, { 22219, }, },
	[27587]  = { nil, 1,  2,  27587,  22196, 300, 320, 330, 340,  1,  1, { 22203, 22202, 12655, 7076, 12364, }, { 18, 40, 12, 10, 4, }, nil, nil, { 22222, }, },
	[27588]  = { nil, 1,  2,  27588,  22195, 300, 320, 330, 340,  1,  1, { 22202, 12810, }, { 14, 4, }, nil, nil, { 22214, }, },
	[27589]  = { nil, 1,  2,  27589,  22194, 300, 320, 330, 340,  1,  1, { 22203, 22202, 12810, 13512, }, { 8, 24, 8, 1, }, nil, nil, { 22220, }, },
	[27590]  = { nil, 1,  2,  27590,  22191, 300, 320, 330, 340,  1,  1, { 22203, 22202, 12810, 12809, 12800, }, { 15, 36, 12, 10, 4, }, nil, nil, { 22221, }, },
	[27829]  = { nil, 1,  2,  27829,  22385, 300, 320, 330, 340,  1,  1, { 12360, 12655, 7076, 13510, }, { 12, 20, 10, 2, }, nil, nil, { 22388, }, },
	[27830]  = { nil, 1,  2,  27830,  22384, 300, 320, 330, 340,  1,  1, { 12360, 11371, 12808, 20520, 15417, }, { 15, 10, 20, 20, 10, }, nil, nil, { 22390, }, },
	[27832]  = { nil, 1,  2,  27832,  22383, 300, 320, 330, 340,  1,  1, { 12360, 20725, 13512, 12810, }, { 12, 2, 2, 4, }, nil, nil, { 22389, }, },
	[28242]  = { nil, 1,  2,  28242,  22669, 300, 320, 330, 340,  1,  1, { 22682, 12359, 12360, 7080, }, { 7, 16, 2, 4, }, nil, nil, { 22703, }, },
	[28243]  = { nil, 1,  2,  28243,  22670, 300, 320, 330, 340,  1,  1, { 22682, 12359, 12360, 7080, }, { 5, 12, 2, 2, }, nil, nil, { 22704, }, },
	[28244]  = { nil, 1,  2,  28244,  22671, 300, 320, 330, 340,  1,  1, { 22682, 12359, 12360, 7080, }, { 4, 12, 2, 2, }, nil, nil, { 22705, }, },
	[28461]  = { nil, 1,  2,  28461,  22762, 300, 320, 330, 340,  1,  1, { 12655, 12360, 12803, }, { 6, 2, 2, }, nil, nil, { 22766, }, },
	[28462]  = { nil, 1,  2,  28462,  22763, 300, 320, 330, 340,  1,  1, { 12655, 12803, }, { 8, 2, }, nil, nil, { 22767, }, },
	[28463]  = { nil, 1,  2,  28463,  22764, 300, 320, 330, 340,  1,  1, { 12655, 12803, }, { 6, 2, }, nil, nil, { 22768, }, },
	[34982]  = { nil, 1,  2,  34982,  29203, 300, 320, 330, 340,  1,  1, { 12655, 12359, 8170, }, { 2, 6, 1, }, true, 10000, },
	[16986]  = { nil, 1,  2,  16986,  12795, 300, 325, 337, 350,  1,  1, { 12655, 12360, 12662, 7910, 12644, }, { 10, 10, 8, 10, 2, }, nil, nil, { 12831, }, },
	[16987]  = { nil, 1,  2,  16987,  12802, 300, 325, 337, 350,  1,  1, { 12655, 12804, 12364, 12800, 12644, }, { 20, 20, 2, 2, 2, }, nil, nil, { 12832, }, },
	[21161]  = { nil, 1,  2,  21161,  17193, 300, 325, 337, 350,  1,  1, { 17203, 11371, 12360, 7078, 11382, 17011, 17010, }, { 8, 20, 50, 25, 10, 10, 10, }, nil, nil, { 18592, }, },
	[29547]  = { nil, 1,  2,  29547,  23484, 305, 315, 325, 335,  1,  1, { 23445, }, { 4, }, true, 15000, },
	[29552]  = { nil, 1,  2,  29552,  23491, 310, 320, 330, 340,  1,  1, { 23445, }, { 5, }, true, 18000, },
	[29557]  = { nil, 1,  2,  29557,  23497, 310, 320, 330, 340,  1,  1, { 23445, }, { 9, }, true, 18000, },
	[29548]  = { nil, 1,  2,  29548,  23487, 315, 325, 335, 345,  1,  1, { 23445, }, { 6, }, true, 20000, },
	[29549]  = { nil, 1,  2,  29549,  23488, 315, 325, 335, 345,  1,  1, { 23445, }, { 8, }, true, 20000, },
	[29553]  = { nil, 1,  2,  29553,  23494, 315, 325, 335, 345,  1,  1, { 23445, }, { 6, }, true, 20000, },
	[29558]  = { nil, 1,  2,  29558,  23498, 315, 325, 335, 345,  1,  1, { 23445, }, { 10, }, true, 20000, },
	[29556]  = { nil, 1,  2,  29556,  23490, 320, 330, 340, 350,  1,  1, { 23445, }, { 9, }, true, 22000, },
	[29565]  = { nil, 1,  2,  29565,  23499, 320, 330, 340, 350,  1,  1, { 23445, }, { 12, }, true, 22000, },
	[32284]  = { nil, 1,  2,  32284,  23559, 325, 325, 330, 335,  1,  1, { 23446, }, { 1, }, true, 25000, },
	[29550]  = { nil, 1,  2,  29550,  23489, 325, 335, 345, 355,  1,  1, { 23445, }, { 10, }, true, 25000, },
	[29566]  = { nil, 1,  2,  29566,  23502, 325, 335, 345, 355,  1,  1, { 23446, }, { 8, }, nil, nil, { 23590, }, },
	[29568]  = { nil, 1,  2,  29568,  23503, 330, 340, 350, 360,  1,  1, { 23446, }, { 8, }, nil, nil, { 23591, }, },
	[29569]  = { nil, 1,  2,  29569,  23504, 330, 340, 350, 360,  1,  1, { 23446, 21887, }, { 7, 2, }, nil, nil, { 23592, }, },
	[36129]  = { nil, 1,  2,  36129,  30074, 330, 340, 350, 360,  1,  1, { 23446, 22452, }, { 8, 4, }, },
	[36130]  = { nil, 1,  2,  36130,  30076, 330, 340, 350, 360,  1,  1, { 23446, 21885, 22451, }, { 8, 2, 2, }, },
	[36131]  = { nil, 1,  2,  36131,  30077, 330, 340, 350, 360,  1,  1, { 23446, 22451, }, { 6, 6, }, },
	[36133]  = { nil, 1,  2,  36133,  30086, 330, 340, 350, 360,  1,  1, { 23446, 22452, }, { 10, 6, }, },
	[36134]  = { nil, 1,  2,  36134,  30087, 330, 340, 350, 360,  1,  1, { 23446, 21885, 22451, }, { 8, 3, 3, }, },
	[36135]  = { nil, 1,  2,  36135,  30088, 330, 340, 350, 360,  1,  1, { 23446, 22451, }, { 10, 6, }, },
	[36136]  = { nil, 1,  2,  36136,  30089, 330, 340, 350, 360,  1,  1, { 23446, 21884, }, { 8, 6, }, },
	[36137]  = { nil, 1,  2,  36137,  30093, 330, 340, 350, 360,  1,  1, { 23446, 22452, }, { 12, 6, }, },
	[42688]  = { nil, 1,  2,  42688,  33185, 335, 345, 350, 355,  1,  1, { 23573, 23449, }, { 2, 1, }, nil, nil, { 33186, 35296, }, },
	[29571]  = { nil, 1,  2,  29571,  23505, 335, 345, 355, 365,  1,  1, { 23446, }, { 12, }, nil, nil, { 23593, }, },
	[29603]  = { nil, 1,  2,  29603,  23506, 335, 345, 355, 365,  1,  1, { 23446, 22452, 21884, }, { 6, 2, 2, }, nil, nil, { 23594, }, },
	[29605]  = { nil, 1,  2,  29605,  23508, 335, 345, 355, 365,  1,  1, { 23446, 21887, 22452, 21884, }, { 8, 2, 3, 2, }, nil, nil, { 23595, }, },
	[29728]  = { nil, 1,  2,  29728,  23575, 340, 340, 345, 350,  1,  1, { 23446, }, { 1, }, nil, nil, { 23638, }, },
	[29606]  = { nil, 1,  2,  29606,  23507, 340, 350, 360, 370,  1,  1, { 23446, 22452, 21884, }, { 12, 4, 2, }, nil, nil, { 23596, }, },
	[29656]  = { nil, 1,  2,  29656,  23529, 350, 350, 355, 360,  1,  1, { 23446, 22573, }, { 1, 2, }, nil, nil, { 23618, }, },
	[32285]  = { nil, 1,  2,  32285,  25521, 350, 350, 355, 360,  1,  1, { 23449, }, { 1, }, nil, nil, { 25526, }, },
	[32656]  = { nil, 1,  2,  32656,  25844, 350, 350, 355, 360,  1,  1, { 23446, }, { 10, }, nil, nil, { 25846, }, },
	[34608]  = { nil, 1,  2,  34608,  28421, 350, 350, 355, 360,  1,  1, { 23446, 21877, }, { 1, 2, }, nil, nil, { 28632, }, },
	[59405]  = { nil, 1,  2,  59405,  43854, 350, 360, 365, 370, 10, 10, { 36916, }, { 4, }, true, 30000, },
	[29614]  = { nil, 1,  2,  29614,  23515, 350, 360, 370, 380,  1,  1, { 23445, 21885, 21884, }, { 6, 3, 2, }, nil, nil, { 23601, }, },
	[34529]  = { nil, 1,  2,  34529,  23563, 350, 360, 370, 380,  1,  1, { 22456, 22451, 23573, 23448, 23449, }, { 20, 20, 6, 4, 8, }, },
	[34533]  = { nil, 1,  2,  34533,  28483, 350, 360, 370, 380,  1,  1, { 23571, 23573, 23447, 23449, }, { 8, 6, 6, 8, }, },
	[34535]  = { nil, 1,  2,  34535,  28425, 350, 360, 370, 380,  1,  1, { 22456, 22457, 23448, }, { 20, 20, 14, }, },
	[34538]  = { nil, 1,  2,  34538,  28428, 350, 360, 370, 380,  1,  1, { 23571, 23449, 23573, }, { 10, 14, 6, }, },
	[34541]  = { nil, 1,  2,  34541,  28431, 350, 360, 370, 380,  1,  1, { 23571, 22456, 23573, 23448, }, { 5, 20, 2, 12, }, },
	[34543]  = { nil, 1,  2,  34543,  28434, 350, 360, 370, 380,  1,  1, { 22451, 22452, 23571, 23447, }, { 12, 12, 4, 22, }, },
	[34545]  = { nil, 1,  2,  34545,  28437, 350, 360, 370, 380,  1,  1, { 21884, 22452, 23447, 23449, }, { 20, 20, 12, 8, }, },
	[34547]  = { nil, 1,  2,  34547,  28440, 350, 360, 370, 380,  1,  1, { 22451, 21885, 23573, 23449, }, { 20, 20, 6, 12, }, },
	[34983]  = { nil, 1,  2,  34983,  29204, 350, 360, 370, 380,  1,  1, { 23448, 22451, 21884, 23793, }, { 6, 2, 2, 1, }, true, 50000, },
	[52568]  = { nil, 1,  2,  52568,  39087, 350, 360, 370, 380,  1,  1, { 36916, }, { 4, }, true, 30000, },
	[52569]  = { nil, 1,  2,  52569,  39088, 350, 360, 370, 380,  1,  1, { 36916, }, { 4, }, true, 30000, },
	[29608]  = { nil, 1,  2,  29608,  23510, 355, 365, 375, 385,  1,  1, { 23573, 22445, 22449, }, { 2, 8, 2, }, nil, nil, { 23597, }, },
	[29611]  = { nil, 1,  2,  29611,  23511, 355, 365, 375, 385,  1,  1, { 23573, 22445, 22449, }, { 3, 12, 2, }, nil, nil, { 23598, }, },
	[29615]  = { nil, 1,  2,  29615,  23516, 355, 365, 375, 385,  1,  1, { 23445, 21885, 21884, }, { 12, 5, 3, }, nil, nil, { 23602, }, },
	[32657]  = { nil, 1,  2,  32657,  25845, 360, 365, 370, 375,  1,  1, { 23447, }, { 4, }, nil, nil, { 25847, }, },
	[52572]  = { nil, 1,  2,  52572,  39083, 360, 370, 375, 380,  1,  1, { 36916, }, { 4, }, true, 30000, },
	[54550]  = { nil, 1,  2,  54550,  40668, 360, 370, 375, 380,  1,  1, { 36916, }, { 4, }, true, 30000, },
	[55834]  = { nil, 1,  2,  55834,  41974, 360, 370, 375, 380,  1,  1, { 36916, }, { 4, }, true, 30000, },
	[29610]  = { nil, 1,  2,  29610,  23509, 360, 370, 380, 390,  1,  1, { 23573, 22445, 22449, }, { 4, 20, 4, }, nil, nil, { 23599, }, },
	[29616]  = { nil, 1,  2,  29616,  23514, 360, 370, 380, 390,  1,  1, { 23445, 21885, 21884, }, { 8, 4, 4, }, nil, nil, { 23603, }, },
	[29619]  = { nil, 1,  2,  29619,  23517, 360, 370, 380, 390,  1,  1, { 23448, }, { 6, }, nil, nil, { 23605, }, },
	[29620]  = { nil, 1,  2,  29620,  23518, 360, 370, 380, 390,  1,  1, { 23448, }, { 8, }, nil, nil, { 23606, }, },
	[29628]  = { nil, 1,  2,  29628,  23524, 360, 370, 380, 390,  1,  1, { 23449, 21885, 22457, }, { 3, 2, 2, }, nil, nil, { 23608, }, },
	[29629]  = { nil, 1,  2,  29629,  23523, 360, 370, 380, 390,  1,  1, { 23449, 21885, 22457, }, { 6, 4, 4, }, nil, nil, { 23609, }, },
	[29657]  = { nil, 1,  2,  29657,  23530, 360, 370, 380, 390,  1,  1, { 23448, 21884, 22452, }, { 4, 4, 4, }, nil, nil, { 23619, 24002, }, },
	[29613]  = { nil, 1,  2,  29613,  23512, 365, 375, 385, 395,  1,  1, { 23573, 22445, 22449, }, { 4, 24, 4, }, nil, nil, { 23600, }, },
	[29617]  = { nil, 1,  2,  29617,  23513, 365, 375, 385, 395,  1,  1, { 23445, 21885, 21884, }, { 16, 6, 4, }, nil, nil, { 23604, }, },
	[29621]  = { nil, 1,  2,  29621,  23519, 365, 375, 385, 395,  1,  1, { 23448, }, { 8, }, nil, nil, { 23607, }, },
	[29622]  = { nil, 1,  2,  29622,  23532, 365, 375, 385, 395,  1,  1, { 23573, 23571, 22452, 23572, }, { 10, 2, 15, 1, }, nil, nil, { 23621, }, },
	[29630]  = { nil, 1,  2,  29630,  23525, 365, 375, 385, 395,  1,  1, { 23449, 21885, 22457, }, { 4, 3, 3, }, nil, nil, { 23610, }, },
	[29642]  = { nil, 1,  2,  29642,  23520, 365, 375, 385, 395,  1,  1, { 23445, 21884, 23449, 22824, }, { 8, 6, 3, 2, }, nil, nil, { 23611, }, },
	[29643]  = { nil, 1,  2,  29643,  23521, 365, 375, 385, 395,  1,  1, { 23445, 21884, 23449, 22824, }, { 10, 10, 4, 4, }, nil, nil, { 23612, }, },
	[29658]  = { nil, 1,  2,  29658,  23531, 365, 375, 385, 395,  1,  1, { 23448, 23571, 23572, }, { 10, 3, 1, }, nil, nil, { 23620, }, },
	[29662]  = { nil, 1,  2,  29662,  23533, 365, 375, 385, 395,  1,  1, { 23448, 23571, 23572, }, { 10, 5, 1, }, nil, nil, { 23622, }, },
	[29663]  = { nil, 1,  2,  29663,  23534, 365, 375, 385, 395,  1,  1, { 23573, 22451, 21885, 23572, }, { 8, 16, 16, 1, }, nil, nil, { 23623, }, },
	[29664]  = { nil, 1,  2,  29664,  23535, 365, 375, 385, 395,  1,  1, { 23573, 22452, 22457, 23572, }, { 8, 22, 12, 1, }, nil, nil, { 23624, }, },
	[29668]  = { nil, 1,  2,  29668,  23536, 365, 375, 385, 395,  1,  1, { 23573, 23571, 21886, 23572, }, { 8, 3, 18, 1, }, nil, nil, { 23625, }, },
	[29669]  = { nil, 1,  2,  29669,  23537, 365, 375, 385, 395,  1,  1, { 23448, 22456, 23572, }, { 6, 15, 1, }, nil, nil, { 23626, }, },
	[29671]  = { nil, 1,  2,  29671,  23538, 365, 375, 385, 395,  1,  1, { 23573, 21886, 23572, }, { 6, 20, 1, }, nil, nil, { 23627, }, },
	[29672]  = { nil, 1,  2,  29672,  23539, 365, 375, 385, 395,  1,  1, { 23573, 23571, 21885, 23572, }, { 6, 2, 15, 1, }, nil, nil, { 23628, }, },
	[29692]  = { nil, 1,  2,  29692,  23540, 365, 375, 385, 395,  1,  1, { 23449, 23448, 23571, 23572, }, { 10, 10, 6, 2, }, nil, nil, { 23629, }, },
	[29693]  = { nil, 1,  2,  29693,  23541, 365, 375, 385, 395,  1,  1, { 23449, 23573, 23571, 23572, }, { 20, 2, 6, 2, }, nil, nil, { 23630, }, },
	[29694]  = { nil, 1,  2,  29694,  23542, 365, 375, 385, 395,  1,  1, { 23449, 23448, 23571, 23572, }, { 10, 10, 8, 2, }, nil, nil, { 23631, }, },
	[29695]  = { nil, 1,  2,  29695,  23543, 365, 375, 385, 395,  1,  1, { 23449, 23448, 23571, 23572, }, { 10, 10, 8, 2, }, nil, nil, { 23632, }, },
	[29696]  = { nil, 1,  2,  29696,  23544, 365, 375, 385, 395,  1,  1, { 23449, 23448, 23571, 23572, }, { 10, 10, 8, 2, }, nil, nil, { 23633, }, },
	[29697]  = { nil, 1,  2,  29697,  23546, 365, 375, 385, 395,  1,  1, { 23449, 23448, 23571, 23572, }, { 10, 10, 8, 2, }, nil, nil, { 23634, }, },
	[29698]  = { nil, 1,  2,  29698,  23554, 365, 375, 385, 395,  1,  1, { 23449, 23573, 23447, 23571, 23572, }, { 10, 4, 10, 8, 2, }, nil, nil, { 23635, }, },
	[29699]  = { nil, 1,  2,  29699,  23555, 365, 375, 385, 395,  1,  1, { 23449, 23448, 23571, 23572, }, { 10, 10, 8, 2, }, nil, nil, { 23636, }, },
	[29700]  = { nil, 1,  2,  29700,  23556, 365, 375, 385, 395,  1,  1, { 23449, 23573, 23447, 23571, 23572, }, { 10, 4, 10, 8, 4, }, nil, nil, { 23637, }, },
	[42662]  = { nil, 1,  2,  42662,  33173, 365, 375, 385, 395,  1,  1, { 23445, 21884, 23449, 27503, }, { 12, 2, 8, 2, }, nil, nil, { 33174, }, },
	[43846]  = { nil, 1,  2,  43846,  32854, 365, 375, 385, 395,  1,  1, { 23449, 23448, 23571, 23572, }, { 16, 12, 6, 2, }, nil, nil, { 33954, }, },
	[46140]  = { nil, 1,  2,  46140,  34380, 365, 375, 392, 410,  1,  1, { 35128, 21886, 23571, 34664, }, { 8, 20, 6, 6, }, nil, nil, { 35556, 35208, }, },
	[46141]  = { nil, 1,  2,  46141,  34378, 365, 375, 392, 410,  1,  1, { 35128, 21884, 22456, 22451, 34664, }, { 10, 12, 12, 12, 6, }, nil, nil, { 35553, 35209, }, },
	[46142]  = { nil, 1,  2,  46142,  34379, 365, 375, 392, 410,  1,  1, { 23449, 23573, 21886, 21885, 23572, }, { 20, 4, 15, 15, 6, }, nil, nil, { 35555, 35210, }, },
	[46144]  = { nil, 1,  2,  46144,  34377, 365, 375, 392, 410,  1,  1, { 23449, 23573, 21884, 22456, 23572, }, { 20, 4, 10, 10, 6, }, nil, nil, { 35554, 35211, }, },
	[52567]  = { nil, 1,  2,  52567,  39086, 370, 375, 380, 385,  1,  1, { 36916, }, { 5, }, true, 30000, },
	[52571]  = { nil, 1,  2,  52571,  39084, 370, 375, 380, 385,  1,  1, { 36916, }, { 5, }, true, 30000, },
	[55835]  = { nil, 1,  2,  55835,  41975, 370, 380, 385, 390,  1,  1, { 36916, }, { 5, }, true, 30000, },
	[29645]  = { nil, 1,  2,  29645,  23522, 370, 380, 390, 400,  1,  1, { 23445, 21884, 23449, 22824, }, { 12, 10, 6, 4, }, nil, nil, { 23613, }, },
	[29648]  = { nil, 1,  2,  29648,  23526, 370, 380, 390, 400,  1,  1, { 23448, 22449, 22831, 22451, }, { 6, 2, 4, 4, }, nil, nil, { 23615, }, },
	[29649]  = { nil, 1,  2,  29649,  23527, 370, 380, 390, 400,  1,  1, { 23573, 21886, 22452, }, { 4, 6, 4, }, nil, nil, { 23617, }, },
	[29729]  = { nil, 1,  2,  29729,  23576, 375, 375, 375, 375,  1,  1, { 23447, }, { 1, }, nil, nil, { 23639, }, },
	[52570]  = { nil, 1,  2,  52570,  39085, 375, 380, 385, 390,  1,  1, { 36916, }, { 6, }, true, 30000, },
	[54917]  = { nil, 1,  2,  54917,  40942, 375, 380, 385, 390,  1,  1, { 36916, }, { 7, }, true, 30000, },
	[34530]  = { nil, 1,  2,  34530,  23564, 375, 385, 395, 405,  1,  1, { 23563, 23572, 22457, }, { 1, 10, 10, }, },
	[34534]  = { nil, 1,  2,  34534,  28484, 375, 385, 395, 405,  1,  1, { 28483, 23572, 22457, }, { 1, 10, 10, }, },
	[34537]  = { nil, 1,  2,  34537,  28426, 375, 385, 395, 405,  1,  1, { 28425, 23572, 22451, }, { 1, 8, 10, }, },
	[34540]  = { nil, 1,  2,  34540,  28429, 375, 385, 395, 405,  1,  1, { 28428, 23572, 23571, }, { 1, 8, 2, }, },
	[34542]  = { nil, 1,  2,  34542,  28432, 375, 385, 395, 405,  1,  1, { 28431, 23572, 23448, }, { 1, 8, 6, }, },
	[34544]  = { nil, 1,  2,  34544,  28435, 375, 385, 395, 405,  1,  1, { 28434, 23572, 22457, }, { 1, 8, 10, }, },
	[34546]  = { nil, 1,  2,  34546,  28438, 375, 385, 395, 405,  1,  1, { 28437, 23572, 23571, }, { 1, 8, 2, }, },
	[34548]  = { nil, 1,  2,  34548,  28441, 375, 385, 395, 405,  1,  1, { 28440, 23572, 22457, }, { 1, 8, 10, }, },
	[36256]  = { nil, 1,  2,  36256,  23565, 375, 385, 395, 405,  1,  1, { 23564, 30183, }, { 1, 2, }, },
	[36257]  = { nil, 1,  2,  36257,  28485, 375, 385, 395, 405,  1,  1, { 28484, 30183, }, { 1, 2, }, },
	[36258]  = { nil, 1,  2,  36258,  28427, 375, 385, 395, 405,  1,  1, { 28426, 30183, }, { 1, 5, }, },
	[36259]  = { nil, 1,  2,  36259,  28430, 375, 385, 395, 405,  1,  1, { 28429, 30183, }, { 1, 5, }, },
	[36260]  = { nil, 1,  2,  36260,  28433, 375, 385, 395, 405,  1,  1, { 28432, 30183, }, { 1, 5, }, },
	[36261]  = { nil, 1,  2,  36261,  28436, 375, 385, 395, 405,  1,  1, { 28435, 30183, }, { 1, 5, }, },
	[36262]  = { nil, 1,  2,  36262,  28439, 375, 385, 395, 405,  1,  1, { 28438, 30183, }, { 1, 5, }, },
	[36263]  = { nil, 1,  2,  36263,  28442, 375, 385, 395, 405,  1,  1, { 28441, 30183, }, { 1, 5, }, },
	[36389]  = { nil, 1,  2,  36389,  30034, 375, 385, 395, 405,  1,  1, { 30183, 23573, 21885, 22452, }, { 2, 5, 10, 5, }, nil, nil, { 30321, }, },
	[36390]  = { nil, 1,  2,  36390,  30032, 375, 385, 395, 405,  1,  1, { 30183, 23573, 21884, }, { 2, 5, 10, }, nil, nil, { 30322, }, },
	[36391]  = { nil, 1,  2,  36391,  30033, 375, 385, 395, 405,  1,  1, { 23572, 23573, 21885, }, { 2, 4, 12, }, nil, nil, { 30323, }, },
	[36392]  = { nil, 1,  2,  36392,  30031, 375, 385, 395, 405,  1,  1, { 23572, 23573, 21884, }, { 2, 4, 12, }, nil, nil, { 30324, }, },
	[38473]  = { nil, 1,  2,  38473,  31364, 375, 385, 395, 405,  1,  1, { 23448, 21886, 22456, 23572, }, { 8, 12, 12, 1, }, nil, nil, { 31390, }, },
	[38475]  = { nil, 1,  2,  38475,  31367, 375, 385, 395, 405,  1,  1, { 23448, 21886, 22456, 23572, }, { 8, 12, 12, 1, }, nil, nil, { 31391, }, },
	[38476]  = { nil, 1,  2,  38476,  31368, 375, 385, 395, 405,  1,  1, { 23448, 21886, 22456, 23572, }, { 8, 12, 12, 1, }, nil, nil, { 31392, }, },
	[38477]  = { nil, 1,  2,  38477,  31369, 375, 385, 395, 405,  1,  1, { 23449, 21885, 21884, 23572, }, { 8, 12, 12, 1, }, nil, nil, { 31393, }, },
	[38478]  = { nil, 1,  2,  38478,  31370, 375, 385, 395, 405,  1,  1, { 23449, 21885, 21884, 23572, }, { 8, 12, 12, 1, }, nil, nil, { 31394, }, },
	[38479]  = { nil, 1,  2,  38479,  31371, 375, 385, 395, 405,  1,  1, { 23449, 21885, 21884, 23572, }, { 8, 12, 12, 1, }, nil, nil, { 31395, }, },
	[40033]  = { nil, 1,  2,  40033,  32402, 375, 385, 395, 405,  1,  1, { 32428, 22450, 21886, 22456, 23446, }, { 2, 1, 2, 4, 4, }, nil, nil, { 32441, }, },
	[40034]  = { nil, 1,  2,  40034,  32403, 375, 385, 395, 405,  1,  1, { 32428, 22450, 21886, 22456, 23446, }, { 1, 1, 2, 2, 4, }, nil, nil, { 32442, }, },
	[40035]  = { nil, 1,  2,  40035,  32404, 375, 385, 395, 405,  1,  1, { 32428, 22450, 21886, 22456, 23446, }, { 3, 1, 4, 6, 12, }, nil, nil, { 32443, }, },
	[40036]  = { nil, 1,  2,  40036,  32401, 375, 385, 395, 405,  1,  1, { 32428, 22450, 21886, 22456, 23446, }, { 2, 1, 3, 4, 8, }, nil, nil, { 32444, }, },
	[41132]  = { nil, 1,  2,  41132,  32568, 375, 385, 395, 405,  1,  1, { 23448, 23573, 22451, 32428, }, { 14, 2, 6, 4, }, nil, nil, { 32736, 35531, }, },
	[41133]  = { nil, 1,  2,  41133,  32570, 375, 385, 395, 405,  1,  1, { 23448, 23573, 22451, 32428, }, { 18, 2, 8, 2, }, nil, nil, { 32737, 35532, }, },
	[41134]  = { nil, 1,  2,  41134,  32571, 375, 385, 395, 405,  1,  1, { 23449, 23573, 21884, 32428, }, { 14, 2, 6, 4, }, nil, nil, { 32738, 35529, }, },
	[41135]  = { nil, 1,  2,  41135,  32573, 375, 385, 395, 405,  1,  1, { 23449, 23573, 21884, 32428, }, { 18, 2, 8, 2, }, nil, nil, { 32739, 35530, }, },
	[54978]  = { nil, 1,  2,  54978,  40956, 375, 395, 400, 405,  1,  1, { 36916, 37705, }, { 8, 2, }, nil, nil, { 41124, }, },
	[54979]  = { nil, 1,  2,  54979,  40957, 375, 405, 410, 415,  1,  1, { 36916, 37705, }, { 8, 2, }, nil, nil, { 41123, }, },
	[54980]  = { nil, 1,  2,  54980,  40958, 375, 410, 415, 420,  1,  1, { 36916, 37705, }, { 8, 2, }, nil, nil, { 41120, }, },
	[54981]  = { nil, 1,  2,  54981,  40959, 375, 415, 420, 425,  1,  1, { 36916, 37705, }, { 8, 2, }, nil, nil, { 41122, }, },
	[54918]  = { nil, 1,  2,  54918,  40949, 380, 385, 390, 395,  1,  1, { 36916, }, { 7, }, true, 30000, },
	[55200]  = { nil, 1,  2,  55200,  41239, 380, 385, 390, 395,  1,  1, { 36916, }, { 8, }, true, 35000, },
	[55201]  = { nil, 1,  2,  55201,  41240, 380, 385, 390, 395,  1,  1, { 36916, }, { 8, }, true, 35000, },
	[54941]  = { nil, 1,  2,  54941,  40950, 385, 390, 395, 400,  1,  1, { 36916, }, { 7, }, true, 30000, },
	[54944]  = { nil, 1,  2,  54944,  40951, 385, 390, 395, 400,  1,  1, { 36916, }, { 8, }, true, 30000, },
	[55202]  = { nil, 1,  2,  55202,  41241, 385, 390, 395, 400,  1,  1, { 36916, }, { 7, }, true, 35000, },
	[55203]  = { nil, 1,  2,  55203,  41242, 385, 390, 395, 400,  1,  1, { 36916, }, { 10, }, true, 35000, },
	[54557]  = { nil, 1,  2,  54557,  40670, 390, 395, 400, 405,  1,  1, { 36916, 36913, }, { 6, 4, }, true, 40000, },
	[54945]  = { nil, 1,  2,  54945,  40952, 390, 395, 400, 405,  1,  1, { 36916, }, { 12, }, true, 35000, },
	[55013]  = { nil, 1,  2,  55013,  41117, 390, 395, 400, 405,  1,  1, { 36916, 36913, }, { 6, 4, }, true, 40000, },
	[55174]  = { nil, 1,  2,  55174,  41181, 390, 395, 400, 405,  1,  1, { 36916, 36913, 37702, }, { 12, 4, 2, }, true, 50000, },
	[55204]  = { nil, 1,  2,  55204,  41243, 390, 395, 400, 405,  1,  1, { 36916, }, { 10, }, true, 35000, },
	[54551]  = { nil, 1,  2,  54551,  40669, 395, 400, 405, 410,  1,  1, { 36916, 36913, }, { 6, 5, }, true, 40000, },
	[54554]  = { nil, 1,  2,  54554,  40674, 395, 400, 405, 410,  1,  1, { 36916, 36913, 37701, }, { 5, 5, 1, }, true, 40000, },
	[54946]  = { nil, 1,  2,  54946,  40953, 395, 400, 405, 410,  1,  1, { 36916, }, { 12, }, true, 30000, },
	[54947]  = { nil, 1,  2,  54947,  40943, 395, 400, 405, 410,  1,  1, { 36916, }, { 12, }, true, 35000, },
	[55055]  = { nil, 1,  2,  55055,  41126, 395, 400, 405, 410,  1,  1, { 36916, 36913, 37705, }, { 5, 5, 1, }, true, 40000, },
	[55177]  = { nil, 1,  2,  55177,  41182, 395, 400, 405, 410,  1,  1, { 36916, 36913, 37702, }, { 8, 6, 2, }, true, 50000, },
	[59436]  = { nil, 1,  2,  59436,  43860, 395, 400, 405, 410,  1,  1, { 36916, 36913, }, { 6, 5, }, true, 40000, },
	[55628]  = { nil, 1,  2,  55628,    nil, 400, 400, 400, 400,  0,  0, { 3466, }, { 4, }, true, 45000, },
	[55641]  = { nil, 1,  2,  55641,    nil, 400, 400, 400, 400,  0,  0, { 3466, }, { 4, }, true, 45000, },
	[54552]  = { nil, 1,  2,  54552,  40671, 400, 405, 410, 415,  1,  1, { 36916, 36913, }, { 3, 8, }, true, 40000, },
	[54553]  = { nil, 1,  2,  54553,  40672, 400, 405, 410, 415,  1,  1, { 36916, 36913, 37701, }, { 6, 5, 1, }, true, 40000, },
	[54948]  = { nil, 1,  2,  54948,  40954, 400, 405, 410, 415,  1,  1, { 36916, }, { 12, }, true, 30000, },
	[54949]  = { nil, 1,  2,  54949,  40955, 400, 405, 410, 415,  1,  1, { 36916, }, { 8, }, true, 30000, },
	[55056]  = { nil, 1,  2,  55056,  41127, 400, 405, 410, 415,  1,  1, { 36916, 36913, }, { 3, 8, }, true, 40000, },
	[55179]  = { nil, 1,  2,  55179,  41183, 400, 405, 410, 415,  1,  1, { 36916, 36913, 37703, }, { 12, 4, 1, }, true, 50000, },
	[59438]  = { nil, 1,  2,  59438,  43864, 400, 405, 410, 415,  1,  1, { 36916, 36913, }, { 3, 8, }, true, 40000, },
	[54555]  = { nil, 1,  2,  54555,  40673, 405, 410, 415, 420,  1,  1, { 36913, 37701, }, { 12, 1, }, true, 40000, },
	[54556]  = { nil, 1,  2,  54556,  40675, 405, 410, 415, 420,  1,  1, { 36913, }, { 12, }, true, 40000, },
	[55057]  = { nil, 1,  2,  55057,  41128, 405, 410, 415, 420,  1,  1, { 36913, }, { 12, }, true, 40000, },
	[55181]  = { nil, 1,  2,  55181,  41184, 405, 410, 415, 420,  1,  1, { 36913, 37703, }, { 12, 2, }, true, 50000, },
	[59440]  = { nil, 1,  2,  59440,  43865, 405, 410, 415, 420,  1,  1, { 36913, }, { 12, }, true, 40000, },
	[55206]  = { nil, 1,  2,  55206,  41245, 405, 415, 420, 425,  1,  1, { 36913, 37700, }, { 7, 2, }, true, 40000, },
	[55014]  = { nil, 1,  2,  55014,  41113, 410, 415, 420, 425,  1,  1, { 36913, }, { 14, }, true, 35000, },
	[55017]  = { nil, 1,  2,  55017,  41116, 410, 415, 420, 425,  1,  1, { 36913, }, { 13, }, true, 40000, },
	[55182]  = { nil, 1,  2,  55182,  41185, 410, 415, 420, 425,  1,  1, { 36913, 37701, }, { 15, 2, }, true, 40000, },
	[56280]  = { nil, 1,  2,  56280,  42443, 410, 415, 420, 425,  1,  1, { 36913, 37705, }, { 15, 2, }, true, 40000, },
	[59442]  = { nil, 1,  2,  59442,  43871, 410, 415, 420, 425,  1,  1, { 36913, 37702, }, { 15, 2, }, true, 40000, },
	[55015]  = { nil, 1,  2,  55015,  41114, 415, 420, 425, 430,  1,  1, { 36913, }, { 14, }, true, 40000, },
	[55058]  = { nil, 1,  2,  55058,  41129, 415, 420, 425, 430,  1,  1, { 36913, 37705, }, { 14, 1, }, true, 45000, },
	[55183]  = { nil, 1,  2,  55183,  41186, 415, 420, 425, 430,  1,  1, { 36913, 37702, }, { 16, 1, }, },
	[55184]  = { nil, 1,  2,  55184,  41187, 415, 420, 425, 430,  1,  1, { 36913, 37702, }, { 14, 1, }, },
	[55185]  = { nil, 1,  2,  55185,  41188, 415, 420, 425, 430,  1,  1, { 36913, 37702, }, { 20, 2, }, true, 45000, },
	[55186]  = { nil, 1,  2,  55186,  41189, 415, 420, 425, 430,  1,  1, { 36913, 37701, }, { 14, 2, }, },
	[55187]  = { nil, 1,  2,  55187,  41190, 415, 420, 425, 430,  1,  1, { 36913, 37701, }, { 13, 2, }, },
	[55656]  = { nil, 1,  2,  55656,  41611, 415, 420, 425, 430,  1,  1, { 36913, 35624, 35622, 35627, }, { 4, 1, 1, 1, }, true, 50000, },
	[59441]  = { nil, 1,  2,  59441,  43870, 415, 420, 425, 430,  1,  1, { 36913, 37705, }, { 14, 1, }, true, 45000, },
	[55298]  = { nil, 1,  2,  55298,  41355, 420, 425, 430, 435,  1,  1, { 36913, 36860, }, { 12, 1, }, true, 45000, },
	[55305]  = { nil, 1,  2,  55305,  41354, 420, 425, 430, 435,  1,  1, { 36913, 35623, }, { 12, 1, }, true, 45000, },
	[55732]  = { nil, 1,  2,  55732,  41745, 420, 425, 430, 435,  1,  1, { 36913, 41163, }, { 2, 1, }, true, 42000, },
	[55839]  = { nil, 1,  2,  55839,  41976, 420, 425, 430, 435,  1,  1, { 36913, 41163, }, { 2, 1, }, true, 42000, },
	[56357]  = { nil, 1,  2,  56357,  42500, 420, 425, 430, 435,  1,  1, { 36913, 41163, }, { 2, 1, }, true, 42000, },
	[56549]  = { nil, 1,  2,  56549,  42723, 420, 425, 430, 435,  1,  1, { 36913, 35623, }, { 12, 1, }, true, 45000, },
	[55300]  = { nil, 1,  2,  55300,  41356, 420, 430, 440, 450,  1,  1, { 36913, 35622, }, { 12, 1, }, true, 45000, },
	[55301]  = { nil, 1,  2,  55301,  41357, 420, 430, 440, 450,  1,  1, { 36913, 35624, }, { 12, 1, }, true, 45000, },
	[55306]  = { nil, 1,  2,  55306,  41351, 420, 430, 440, 450,  1,  1, { 36913, 35622, }, { 12, 1, }, true, 45000, },
	[55307]  = { nil, 1,  2,  55307,  41352, 420, 430, 440, 450,  1,  1, { 36913, 35622, }, { 12, 1, }, true, 45000, },
	[55308]  = { nil, 1,  2,  55308,  41348, 420, 430, 440, 450,  1,  1, { 36913, 35627, }, { 12, 1, }, true, 45000, },
	[55309]  = { nil, 1,  2,  55309,  41349, 420, 430, 440, 450,  1,  1, { 36913, 36860, }, { 12, 1, }, true, 45000, },
	[56550]  = { nil, 1,  2,  56550,  42727, 420, 430, 440, 450,  1,  1, { 36913, 35622, }, { 12, 1, }, true, 45000, },
	[56551]  = { nil, 1,  2,  56551,  42729, 420, 430, 440, 450,  1,  1, { 36913, 35622, }, { 12, 1, }, true, 45000, },
	[56552]  = { nil, 1,  2,  56552,  42730, 420, 430, 440, 450,  1,  1, { 36913, 35627, }, { 12, 1, }, true, 45000, },
	[56553]  = { nil, 1,  2,  56553,  42724, 420, 430, 440, 450,  1,  1, { 36913, 36860, }, { 12, 1, }, true, 45000, },
	[61009]  = { nil, 1,  2,  61009,  43587, 420, 430, 440, 450,  1,  1, { 36913, 36860, 35622, 43102, }, { 12, 2, 2, 1, }, true, 120000, },
	[61010]  = { nil, 1,  2,  61010,  43588, 420, 430, 440, 450,  1,  1, { 36913, 36860, 35622, 43102, }, { 12, 2, 2, 1, }, true, 120000, },
	[55302]  = { nil, 1,  2,  55302,  41344, 425, 435, 445, 455,  1,  1, { 36913, 36860, }, { 14, 1, }, true, 45000, },
	[55303]  = { nil, 1,  2,  55303,  41345, 425, 435, 445, 455,  1,  1, { 36913, 35624, }, { 14, 1, }, true, 45000, },
	[55304]  = { nil, 1,  2,  55304,  41346, 425, 435, 445, 455,  1,  1, { 36913, 35622, }, { 14, 1, }, true, 45000, },
	[55310]  = { nil, 1,  2,  55310,  41347, 425, 435, 445, 455,  1,  1, { 36913, 35623, }, { 14, 1, }, true, 45000, },
	[55311]  = { nil, 1,  2,  55311,  41353, 425, 435, 445, 455,  1,  1, { 36913, 35624, }, { 14, 1, }, true, 45000, },
	[55312]  = { nil, 1,  2,  55312,  41350, 425, 435, 445, 455,  1,  1, { 36913, 35627, }, { 14, 1, }, true, 45000, },
	[56554]  = { nil, 1,  2,  56554,  42726, 425, 435, 445, 455,  1,  1, { 36913, 35623, }, { 14, 1, }, true, 45000, },
	[56555]  = { nil, 1,  2,  56555,  42725, 425, 435, 445, 455,  1,  1, { 36913, 35624, }, { 14, 1, }, true, 45000, },
	[56556]  = { nil, 1,  2,  56556,  42728, 425, 435, 445, 455,  1,  1, { 36913, 35627, }, { 14, 1, }, true, 45000, },
	[61008]  = { nil, 1,  2,  61008,  43586, 425, 435, 445, 455,  1,  1, { 36913, 36860, 35622, 43102, }, { 16, 3, 3, 1, }, true, 120000, },
	[76178]  = { nil, 1,  2,  76178,  65365, 425, 450, 452, 455,  1,  1, { 54849, }, { 2, }, true, 15000, },
	[59406]  = { nil, 1,  2,  59406,  43853, 430, 435, 440, 445, 20, 20, { 36913, 41163, }, { 4, 1, }, true, 45000, },
	[55369]  = { nil, 1,  2,  55369,  41257, 440, 450, 460, 470,  1,  1, { 36913, 37663, 43102, }, { 8, 8, 2, }, true, 180000, },
	[55370]  = { nil, 1,  2,  55370,  41383, 440, 450, 460, 470,  1,  1, { 36913, 37663, 43102, }, { 6, 6, 2, }, true, 150000, },
	[55371]  = { nil, 1,  2,  55371,  41384, 440, 450, 460, 470,  1,  1, { 36913, 37663, 43102, }, { 6, 6, 2, }, true, 150000, },
	[55372]  = { nil, 1,  2,  55372,  41386, 440, 450, 460, 470,  1,  1, { 36913, 37663, 43102, }, { 4, 4, 1, }, true, 120000, },
	[55373]  = { nil, 1,  2,  55373,  41387, 440, 450, 460, 470,  1,  1, { 36913, 37663, 43102, }, { 4, 4, 1, }, true, 120000, },
	[55374]  = { nil, 1,  2,  55374,  41388, 440, 450, 460, 470,  1,  1, { 36913, 37663, 43102, }, { 4, 4, 1, }, true, 120000, },
	[55375]  = { nil, 1,  2,  55375,  41391, 440, 450, 460, 470,  1,  1, { 36913, 37663, 43102, }, { 4, 3, 1, }, true, 120000, },
	[55376]  = { nil, 1,  2,  55376,  41392, 440, 450, 460, 470,  1,  1, { 36913, 37663, 43102, }, { 4, 3, 1, }, true, 120000, },
	[55377]  = { nil, 1,  2,  55377,  41394, 440, 450, 460, 470,  1,  1, { 36913, 37663, 43102, }, { 4, 3, 1, }, true, 120000, },
	[56234]  = { nil, 1,  2,  56234,  42435, 440, 450, 460, 470,  1,  1, { 36913, 37663, 43102, }, { 6, 6, 2, }, true, 150000, },
	[56400]  = { nil, 1,  2,  56400,  42508, 440, 450, 460, 470,  1,  1, { 36913, 37663, 43102, }, { 4, 3, 1, }, true, 150000, },
	[63182]  = { nil, 1,  2,  63182,  45085, 440, 450, 460, 470,  1,  1, { 37663, 34054, 43102, }, { 6, 6, 2, }, true, 150000, },
	[76179]  = { nil, 1,  2,  76179,  54850, 440, 460, 462, 465,  1,  1, { 65365, 18567, }, { 3, 1, }, true, 40000, },
	[76262]  = { nil, 1,  2,  76262,  55025, 440, 460, 462, 465,  1,  1, { 65365, }, { 3, }, true, 40000, { 66072, }, },
	[76280]  = { nil, 1,  2,  76280,  55033, 440, 460, 462, 465,  1,  1, { 65365, }, { 3, }, true, 40000, { 66084, }, },
	[62202]  = { nil, 1,  2,  62202,  44936, 450, 455, 460, 465,  1,  1, { 41163, 35627, }, { 4, 4, }, nil, nil, { 44937, 44938, }, },
	[63187]  = { nil, 1,  2,  63187,  45550, 450, 455, 465, 475,  1,  1, { 37663, 45087, }, { 5, 6, }, nil, nil, { 45088, }, },
	[63188]  = { nil, 1,  2,  63188,  45559, 450, 455, 465, 475,  1,  1, { 37663, 45087, }, { 5, 6, }, nil, nil, { 45089, }, },
	[63189]  = { nil, 1,  2,  63189,  45552, 450, 455, 465, 475,  1,  1, { 37663, 45087, }, { 5, 6, }, nil, nil, { 45090, }, },
	[63190]  = { nil, 1,  2,  63190,  45561, 450, 455, 465, 475,  1,  1, { 37663, 45087, }, { 5, 6, }, nil, nil, { 45091, }, },
	[63191]  = { nil, 1,  2,  63191,  45551, 450, 455, 465, 475,  1,  1, { 37663, 45087, }, { 5, 6, }, nil, nil, { 45092, }, },
	[63192]  = { nil, 1,  2,  63192,  45560, 450, 455, 465, 475,  1,  1, { 37663, 45087, }, { 5, 6, }, nil, nil, { 45093, }, },
	[76180]  = { nil, 1,  2,  76180,  54852, 450, 460, 462, 465,  1,  1, { 65365, }, { 3, }, true, 50000, { 66063, }, },
	[76263]  = { nil, 1,  2,  76263,  55026, 450, 460, 462, 465,  1,  1, { 65365, }, { 3, }, true, 50000, { 66074, }, },
	[76281]  = { nil, 1,  2,  76281,  55034, 450, 460, 462, 465,  1,  1, { 65365, 52327, }, { 6, 8, }, true, 50000, { 66085, }, },
	[76291]  = { nil, 1,  2,  76291,  55041, 450, 460, 462, 465,  1,  1, { 65365, }, { 3, }, true, 50000, { 66092, }, },
	[67091]  = { nil, 1,  2,  67091,  47591, 450, 460, 467, 475,  1,  1, { 37663, 35625, 36925, 47556, }, { 12, 8, 2, 8, }, nil, nil, { 47622, }, },
	[67092]  = { nil, 1,  2,  67092,  47570, 450, 460, 467, 475,  1,  1, { 37663, 36913, 47556, }, { 8, 20, 4, }, nil, nil, { 47623, }, },
	[67093]  = { nil, 1,  2,  67093,  47589, 450, 460, 467, 475,  1,  1, { 37663, 41245, 47556, }, { 10, 4, 8, }, nil, nil, { 47624, }, },
	[67094]  = { nil, 1,  2,  67094,  47572, 450, 460, 467, 475,  1,  1, { 37663, 41355, 47556, }, { 8, 1, 4, }, nil, nil, { 47625, }, },
	[67095]  = { nil, 1,  2,  67095,  47593, 450, 460, 467, 475,  1,  1, { 37663, 35625, 47556, }, { 10, 20, 8, }, nil, nil, { 47626, }, },
	[67096]  = { nil, 1,  2,  67096,  47574, 450, 460, 467, 475,  1,  1, { 37663, 35625, 47556, }, { 8, 12, 4, }, nil, nil, { 47627, }, },
	[67130]  = { nil, 1,  2,  67130,  47592, 450, 460, 467, 475,  1,  1, { 37663, 35625, 36925, 47556, }, { 12, 8, 2, 8, }, nil, nil, { 47640, }, },
	[67131]  = { nil, 1,  2,  67131,  47571, 450, 460, 467, 475,  1,  1, { 37663, 36913, 47556, }, { 8, 20, 4, }, nil, nil, { 47641, }, },
	[67132]  = { nil, 1,  2,  67132,  47590, 450, 460, 467, 475,  1,  1, { 37663, 41245, 47556, }, { 10, 4, 8, }, nil, nil, { 47644, }, },
	[67133]  = { nil, 1,  2,  67133,  47573, 450, 460, 467, 475,  1,  1, { 37663, 41355, 47556, }, { 8, 1, 4, }, nil, nil, { 47645, }, },
	[67134]  = { nil, 1,  2,  67134,  47594, 450, 460, 467, 475,  1,  1, { 37663, 35625, 47556, }, { 10, 20, 8, }, nil, nil, { 47643, }, },
	[67135]  = { nil, 1,  2,  67135,  47575, 450, 460, 467, 475,  1,  1, { 37663, 35625, 47556, }, { 8, 12, 4, }, nil, nil, { 47642, }, },
	[70562]  = { nil, 1,  2,  70562,  49902, 450, 475, 487, 500,  1,  1, { 37663, 35623, 49908, }, { 12, 20, 8, }, nil, nil, { 49969, }, },
	[70563]  = { nil, 1,  2,  70563,  49905, 450, 475, 487, 500,  1,  1, { 37663, 35624, 49908, }, { 8, 12, 5, }, nil, nil, { 49970, }, },
	[70565]  = { nil, 1,  2,  70565,  49903, 450, 475, 487, 500,  1,  1, { 37663, 35627, 49908, }, { 12, 20, 8, }, nil, nil, { 49971, }, },
	[70566]  = { nil, 1,  2,  70566,  49906, 450, 475, 487, 500,  1,  1, { 37663, 35622, 36860, 49908, }, { 8, 6, 6, 5, }, nil, nil, { 49972, }, },
	[70567]  = { nil, 1,  2,  70567,  49904, 450, 475, 487, 500,  1,  1, { 37663, 35624, 49908, }, { 12, 20, 8, }, nil, nil, { 49973, }, },
	[70568]  = { nil, 1,  2,  70568,  49907, 450, 475, 487, 500,  1,  1, { 37663, 35624, 49908, }, { 8, 12, 5, }, nil, nil, { 49974, }, },
	[76181]  = { nil, 1,  2,  76181,  54853, 460, 470, 472, 475,  1,  1, { 65365, 52327, }, { 4, 1, }, true, 55000, { 66062, 66064, }, },
	[76264]  = { nil, 1,  2,  76264,  55027, 460, 470, 472, 475,  1,  1, { 65365, 52327, }, { 4, 1, }, true, 55000, { 66077, }, },
	[76283]  = { nil, 1,  2,  76283,  55035, 460, 470, 472, 475,  1,  1, { 65365, 52327, }, { 4, 1, }, true, 55000, { 66086, }, },
	[76433]  = { nil, 1,  2,  76433,  55043, 460, 475, 477, 480,  1,  1, { 65365, 52327, }, { 20, 8, }, true, 50000, { 66094, }, },
	[76182]  = { nil, 1,  2,  76182,  54854, 470, 480, 482, 485,  1,  1, { 65365, }, { 5, }, true, 60000, { 66065, }, },
	[76265]  = { nil, 1,  2,  76265,  55028, 470, 480, 482, 485,  1,  1, { 65365, }, { 5, }, true, 60000, { 66078, }, },
	[76285]  = { nil, 1,  2,  76285,  55036, 470, 480, 482, 485,  1,  1, { 65365, }, { 5, }, true, 60000, { 66087, }, },
	[76293]  = { nil, 1,  2,  76293,  55042, 470, 480, 482, 485,  1,  1, { 65365, 52327, }, { 10, 4, }, true, 60000, { 66093, }, },
	[76434]  = { nil, 1,  2,  76434,  55044, 470, 480, 482, 485,  1,  1, { 65365, 52327, 52326, }, { 15, 6, 4, }, true, 60000, { 66095, }, },
	[76474]  = { nil, 1,  2,  76474,  55246, 470, 480, 482, 485,  1,  1, { 65365, 52327, 52325, }, { 12, 10, 4, }, true, 60000, { 66133, }, },
	[76438]  = { nil, 1,  2,  76438,  55053, 475, 480, 485, 490,  2,  2, { 65365, }, { 2, }, true, 60000, { 66099, }, },
	[92375]  = { nil, 1,  2,  92375,  65358, 475, 480, 485, 490,  1,  1, { 52186, }, { 15, }, true, 60000, { 66134, }, },
	[76258]  = { nil, 1,  2,  76258,  54876, 480, 490, 492, 495,  1,  1, { 65365, 52186, 52327, }, { 5, 15, 10, }, true, 65000, { 66066, }, },
	[76266]  = { nil, 1,  2,  76266,  55029, 480, 490, 492, 495,  1,  1, { 65365, 52186, }, { 3, 6, }, true, 65000, { 66079, }, },
	[76286]  = { nil, 1,  2,  76286,  55037, 480, 490, 492, 495,  1,  1, { 65365, 52186, }, { 2, 8, }, true, 65000, { 66088, }, },
	[76287]  = { nil, 1,  2,  76287,  55038, 480, 490, 492, 495,  1,  1, { 65365, 52186, }, { 2, 8, }, true, 65000, { 66089, }, },
	[76435]  = { nil, 1,  2,  76435,  55045, 480, 490, 492, 495,  1,  1, { 52186, 52327, 52325, }, { 20, 12, 4, }, true, 65000, { 66096, }, },
	[76436]  = { nil, 1,  2,  76436,  55046, 480, 490, 492, 495,  1,  1, { 65365, 52186, 52327, 52326, }, { 4, 12, 10, 6, }, true, 65000, { 66097, }, },
	[76437]  = { nil, 1,  2,  76437,  55052, 480, 490, 492, 495,  1,  1, { 65365, 52186, 52327, }, { 10, 10, 6, }, true, 65000, { 66098, }, },
	[76259]  = { nil, 1,  2,  76259,  55022, 490, 500, 502, 505,  1,  1, { 65365, 52186, }, { 2, 10, }, true, 65000, { 66068, }, },
	[76260]  = { nil, 1,  2,  76260,  55023, 490, 500, 502, 505,  1,  1, { 65365, 52186, 52327, }, { 4, 15, 6, }, true, 65000, { 66069, }, },
	[76267]  = { nil, 1,  2,  76267,  55030, 490, 500, 502, 505,  1,  1, { 65365, 52186, }, { 4, 7, }, true, 65000, { 66081, }, },
	[76288]  = { nil, 1,  2,  76288,  55039, 490, 500, 502, 505,  1,  1, { 52186, 52327, }, { 20, 8, }, true, 65000, { 66090, }, },
	[76441]  = { nil, 1,  2,  76441,  55055, 490, 500, 502, 505,  1,  1, { 52186, }, { 15, }, true, 65000, { 66102, }, },
	[76442]  = { nil, 1,  2,  76442,  55057, 500, 505, 510, 515,  1,  1, { 51950, }, { 1, }, nil, nil, { 66103, }, },
	[76261]  = { nil, 1,  2,  76261,  55024, 500, 510, 512, 515,  1,  1, { 65365, 52186, }, { 4, 6, }, true, 75000, { 66071, }, },
	[76269]  = { nil, 1,  2,  76269,  55031, 500, 510, 512, 515,  1,  1, { 52186, }, { 15, }, true, 75000, { 66082, }, },
	[76270]  = { nil, 1,  2,  76270,  55032, 500, 510, 512, 515,  1,  1, { 52186, 52327, }, { 15, 15, }, true, 75000, { 66083, }, },
	[76289]  = { nil, 1,  2,  76289,  55040, 500, 510, 512, 515,  1,  1, { 52186, }, { 15, }, true, 75000, { 66091, }, },
	[76456]  = { nil, 1,  2,  76456,  75124, 500, 510, 512, 515,  1,  1, { 52186, 52325, }, { 8, 10, }, nil, nil, { 66117, }, },
	[76465]  = { nil, 1,  2,  76465,  75125, 500, 510, 512, 515,  1,  1, { 52186, 52326, }, { 8, 10, }, nil, nil, { 66125, }, },
	[76457]  = { nil, 1,  2,  76457,  75122, 505, 515, 517, 520,  1,  1, { 52186, 52325, }, { 10, 10, }, nil, nil, { 66118, }, },
	[76466]  = { nil, 1,  2,  76466,  75121, 505, 515, 517, 520,  1,  1, { 52186, 52326, }, { 10, 10, }, nil, nil, { 66126, }, },
	[76444]  = { nil, 1,  2,  76444,  55059, 510, 520, 522, 525,  1,  1, { 53039, 58480, 52078, }, { 4, 3, 2, }, nil, nil, { 66105, }, },
	[76446]  = { nil, 1,  2,  76446,  55061, 510, 520, 522, 525,  1,  1, { 53039, 58480, 52078, }, { 4, 3, 2, }, nil, nil, { 66107, }, },
	[76448]  = { nil, 1,  2,  76448,  55063, 510, 520, 522, 525,  1,  1, { 53039, 58480, 52078, }, { 4, 3, 2, }, nil, nil, { 66109, }, },
	[76458]  = { nil, 1,  2,  76458,  75123, 510, 520, 522, 525,  1,  1, { 52186, 52325, }, { 10, 10, }, nil, nil, { 66119, }, },
	[76467]  = { nil, 1,  2,  76467,  75118, 510, 520, 522, 525,  1,  1, { 52186, 52326, }, { 10, 10, }, nil, nil, { 66127, }, },
	[76443]  = { nil, 1,  2,  76443,  55058, 515, 525, 525, 525,  1,  1, { 53039, 58480, 52078, }, { 5, 6, 3, }, nil, nil, { 66104, }, },
	[76445]  = { nil, 1,  2,  76445,  55060, 515, 525, 525, 525,  1,  1, { 53039, 58480, 52078, }, { 5, 6, 3, }, nil, nil, { 66106, }, },
	[76447]  = { nil, 1,  2,  76447,  55062, 515, 525, 525, 525,  1,  1, { 53039, 58480, 52078, }, { 5, 6, 3, }, nil, nil, { 66108, }, },
	[76450]  = { nil, 1,  2,  76450,  55065, 515, 525, 525, 525,  1,  1, { 53039, 58480, 52078, }, { 4, 6, 3, }, nil, nil, { 66111, }, },
	[76452]  = { nil, 1,  2,  76452,  55067, 515, 525, 525, 525,  1,  1, { 53039, 58480, 52078, }, { 4, 6, 3, }, nil, nil, { 66113, }, },
	[94718]  = { nil, 1,  2,  94718,  67602, 515, 525, 525, 525,  1,  1, { 53039, 58480, 52078, }, { 4, 5, 3, }, nil, nil, { 67603, }, },
	[76459]  = { nil, 1,  2,  76459,  75120, 515, 525, 527, 530,  1,  1, { 52186, 52325, }, { 12, 10, }, nil, nil, { 66120, }, },
	[76468]  = { nil, 1,  2,  76468,  75132, 515, 525, 527, 530,  1,  1, { 52186, 52326, }, { 12, 10, }, nil, nil, { 66128, }, },
	[76449]  = { nil, 1,  2,  76449,  55064, 520, 525, 525, 525,  1,  1, { 53039, 58480, 52078, }, { 4, 6, 3, }, nil, nil, { 66110, }, },
	[76451]  = { nil, 1,  2,  76451,  55066, 520, 525, 525, 525,  1,  1, { 53039, 58480, 52078, }, { 5, 6, 3, }, nil, nil, { 66112, }, },
	[76453]  = { nil, 1,  2,  76453,  55068, 520, 525, 525, 525,  1,  1, { 53039, 58480, 52078, }, { 4, 6, 3, }, nil, nil, { 66114, }, },
	[76454]  = { nil, 1,  2,  76454,  55069, 520, 525, 525, 525,  1,  1, { 53039, 58480, 52078, }, { 3, 3, 1, }, nil, nil, { 66115, }, },
	[76455]  = { nil, 1,  2,  76455,  55070, 520, 525, 525, 525,  1,  1, { 53039, 58480, 52078, }, { 3, 3, 1, }, nil, nil, { 66116, }, },
	[94732]  = { nil, 1,  2,  94732,  67605, 520, 525, 525, 525,  1,  1, { 53039, 58480, 52078, }, { 5, 6, 3, }, nil, nil, { 67606, }, },
	[76461]  = { nil, 1,  2,  76461,  75119, 520, 530, 532, 535,  1,  1, { 52186, 52325, }, { 12, 10, }, nil, nil, { 66121, }, },
	[76469]  = { nil, 1,  2,  76469,  75134, 520, 530, 532, 535,  1,  1, { 52186, 52326, }, { 12, 10, }, nil, nil, { 66129, }, },
	[76439]  = { nil, 1,  2,  76439,  55054, 525, 525, 525, 525,  1,  1, { 52327, 52186, 51950, }, { 4, 4, 4, }, nil, nil, { 66100, }, },
	[99439]  = { nil, 1,  2,  99439,  69936, 525, 525, 527, 530,  1,  1, { 53039, 52325, 69237, 52078, }, { 10, 40, 4, 3, }, nil, nil, { 69957, }, },
	[99440]  = { nil, 1,  2,  99440,  69937, 525, 525, 527, 530,  1,  1, { 53039, 52325, 69237, 52078, }, { 10, 40, 4, 3, }, nil, nil, { 69958, }, },
	[99441]  = { nil, 1,  2,  99441,  69938, 525, 525, 527, 530,  1,  1, { 53039, 52325, 69237, 52078, }, { 10, 40, 4, 3, }, nil, nil, { 69959, }, },
	[99452]  = { nil, 1,  2,  99452,  69946, 525, 525, 527, 530,  1,  1, { 53039, 52325, 69237, 52078, }, { 10, 40, 4, 3, }, nil, nil, { 69968, }, },
	[99453]  = { nil, 1,  2,  99453,  69947, 525, 525, 527, 530,  1,  1, { 53039, 52325, 69237, 52078, }, { 10, 40, 4, 3, }, nil, nil, { 69969, }, },
	[99454]  = { nil, 1,  2,  99454,  69948, 525, 525, 527, 530,  1,  1, { 53039, 52325, 69237, 52078, }, { 10, 40, 4, 3, }, nil, nil, { 69970, }, },
	[99652]  = { nil, 1,  2,  99652,  70155, 525, 525, 527, 530,  1,  1, { 58480, 52190, 53039, 52078, }, { 8, 2, 3, 5, }, nil, nil, { 70166, }, },
	[99653]  = { nil, 1,  2,  99653,  70156, 525, 525, 527, 530,  1,  1, { 58480, 52191, 52182, 53039, 52078, }, { 8, 1, 2, 1, 5, }, nil, nil, { 70167, }, },
	[99654]  = { nil, 1,  2,  99654,  70157, 525, 525, 527, 530,  1,  1, { 58480, 52326, 52078, }, { 8, 30, 5, }, nil, nil, { 70168, }, },
	[99655]  = { nil, 1,  2,  99655,  70158, 525, 525, 527, 530,  1,  1, { 58480, 52325, 53039, 52078, }, { 8, 8, 4, 5, }, nil, nil, { 70169, }, },
	[99656]  = { nil, 1,  2,  99656,  70162, 525, 525, 527, 530,  1,  1, { 58480, 52193, 53039, 52078, }, { 8, 1, 3, 5, }, nil, nil, { 70170, }, },
	[99657]  = { nil, 1,  2,  99657,  70163, 525, 525, 527, 530,  1,  1, { 58480, 52178, 56516, 52078, }, { 8, 8, 2, 5, }, nil, nil, { 70171, }, },
	[99658]  = { nil, 1,  2,  99658,  70164, 525, 525, 527, 530,  1,  1, { 58480, 52191, 53039, 52078, }, { 8, 2, 4, 5, }, nil, nil, { 70172, }, },
	[99660]  = { nil, 1,  2,  99660,  70165, 525, 525, 527, 530,  1,  1, { 58480, 56516, 53039, 52078, }, { 8, 6, 4, 5, }, nil, nil, { 70173, }, },
	[101924] = { nil, 1,  2, 101924,  71982, 525, 525, 530, 535,  1,  1, { 58480, 52329, 52078, 71998, }, { 8, 40, 4, 8, }, nil, nil, { 72001, }, },
	[101925] = { nil, 1,  2, 101925,  71983, 525, 525, 530, 535,  1,  1, { 58480, 52325, 52078, 71998, }, { 8, 40, 4, 8, }, nil, nil, { 72012, }, },
	[101928] = { nil, 1,  2, 101928,  71984, 525, 525, 530, 535,  1,  1, { 58480, 53039, 52078, 71998, }, { 8, 10, 4, 8, }, nil, nil, { 72013, }, },
	[101929] = { nil, 1,  2, 101929,  71991, 525, 525, 530, 535,  1,  1, { 58480, 52329, 52078, 71998, }, { 4, 30, 2, 4, }, nil, nil, { 72014, }, },
	[101931] = { nil, 1,  2, 101931,  71992, 525, 525, 530, 535,  1,  1, { 58480, 52325, 52078, 71998, }, { 4, 30, 2, 4, }, nil, nil, { 72015, }, },
	[101932] = { nil, 1,  2, 101932,  71993, 525, 525, 530, 535,  1,  1, { 58480, 53039, 52078, 71998, }, { 4, 10, 2, 4, }, nil, nil, { 72016, }, },
	[76440]  = { nil, 1,  2,  76440,  55056, 525, 530, 535, 540,  1,  1, { 51950, }, { 5, }, nil, nil, { 66101, }, },
	[76462]  = { nil, 1,  2,  76462,  75136, 525, 535, 537, 540,  1,  1, { 52186, 52325, }, { 15, 10, }, nil, nil, { 66122, }, },
	[76463]  = { nil, 1,  2,  76463,  75126, 525, 535, 537, 540,  1,  1, { 52186, 52325, }, { 15, 10, }, nil, nil, { 66123, }, },
	[76464]  = { nil, 1,  2,  76464,  75135, 525, 535, 537, 540,  1,  1, { 52186, 52325, }, { 15, 10, }, nil, nil, { 66124, }, },
	[76470]  = { nil, 1,  2,  76470,  75133, 525, 535, 537, 540,  1,  1, { 52186, 52326, }, { 15, 10, }, nil, nil, { 66130, }, },
	[76471]  = { nil, 1,  2,  76471,  75129, 525, 535, 537, 540,  1,  1, { 52186, 52326, }, { 15, 10, }, nil, nil, { 66131, }, },
	[76472]  = { nil, 1,  2,  76472,  75128, 525, 535, 537, 540,  1,  1, { 52186, 52326, }, { 15, 10, }, nil, nil, { 66132, }, },
	[2881]   = { nil, 1,  3,   2881,   2318,   1,  20,  30,  40,  1,  1, { 2934, }, { 3, }, },
	[2152]   = { nil, 1,  3,   2152,   2304,   1,  30,  45,  60,  1,  1, { 2318, }, { 1, }, },
	[2149]   = { nil, 1,  3,   2149,   2302,   1,  40,  55,  70,  1,  1, { 2318, 2320, }, { 2, 1, }, },
	[7126]   = { nil, 1,  3,   7126,   5957,   1,  40,  55,  70,  1,  1, { 2318, 2320, }, { 3, 1, }, },
	[9058]   = { nil, 1,  3,   9058,   7276,   1,  40,  55,  70,  1,  1, { 2318, 2320, }, { 2, 1, }, },
	[9059]   = { nil, 1,  3,   9059,   7277,   1,  40,  55,  70,  1,  1, { 2318, 2320, }, { 2, 3, }, },
	[2153]   = { nil, 1,  3,   2153,   2303,  15,  45,  60,  75,  1,  1, { 2318, 2320, }, { 4, 1, }, true, 50, },
	[3753]   = { nil, 1,  3,   3753,   4237,  25,  55,  70,  85,  1,  1, { 2318, 2320, }, { 6, 1, }, true, 75, },
	[3816]   = { nil, 1,  3,   3816,   4231,  35,  55,  65,  75,  1,  1, { 783, 4289, }, { 1, 1, }, true, 50, },
	[9064]   = { nil, 1,  3,   9064,   7280,  35,  65,  80,  95,  1,  1, { 2318, 2320, }, { 5, 5, }, nil, nil, { 7288, }, },
	[2160]   = { nil, 1,  3,   2160,   2300,  40,  70,  85, 100,  1,  1, { 2318, 2320, }, { 8, 4, }, true, 100, },
	[5244]   = { nil, 1,  3,   5244,   5081,  40,  70,  85, 100,  1,  1, { 5082, 2318, 2320, }, { 3, 4, 1, }, nil, nil, { 5083, }, },
	[2161]   = { nil, 1,  3,   2161,   2309,  55,  85, 100, 115,  1,  1, { 2318, 2320, }, { 8, 5, }, true, 100, },
	[3756]   = { nil, 1,  3,   3756,   4239,  55,  85, 100, 115,  1,  1, { 2318, 2320, }, { 3, 2, }, true, 150, },
	[2162]   = { nil, 1,  3,   2162,   2310,  60,  90, 105, 120,  1,  1, { 2318, 2320, }, { 5, 2, }, true, 100, },
	[2163]   = { nil, 1,  3,   2163,   2311,  60,  90, 105, 120,  1,  1, { 2318, 2320, 2324, }, { 8, 2, 1, }, nil, nil, { 2407, }, },
	[9065]   = { nil, 1,  3,   9065,   7281,  70, 100, 115, 130,  1,  1, { 2318, 2320, }, { 6, 4, }, true, 150, },
	[2164]   = { nil, 1,  3,   2164,   2312,  75, 105, 120, 135,  1,  1, { 4231, 2318, 2320, }, { 1, 4, 2, }, nil, nil, { 2408, }, },
	[3759]   = { nil, 1,  3,   3759,   4242,  75, 105, 120, 135,  1,  1, { 4231, 2318, 2320, }, { 1, 6, 2, }, true, 200, },
	[3763]   = { nil, 1,  3,   3763,   4246,  80, 110, 125, 140,  1,  1, { 2318, 2320, }, { 6, 2, }, true, 300, },
	[2159]   = { nil, 1,  3,   2159,   2308,  85, 105, 120, 135,  1,  1, { 2318, 2321, }, { 10, 2, }, true, 250, },
	[3761]   = { nil, 1,  3,   3761,   4243,  85, 115, 130, 145,  1,  1, { 4231, 2318, 2320, }, { 3, 6, 4, }, true, 350, },
	[8322]   = { nil, 1,  3,   8322,   6709,  90, 115, 130, 145,  1,  1, { 2318, 4231, 2320, 5498, }, { 6, 1, 4, 1, }, nil, nil, { 6710, }, },
	[2158]   = { nil, 1,  3,   2158,   2307,  90, 120, 135, 150,  1,  1, { 2318, 2320, }, { 7, 2, }, nil, nil, { 2406, }, },
	[6702]   = { nil, 1,  3,   6702,   5780,  90, 120, 135, 150,  1,  1, { 5784, 2318, 2321, }, { 8, 6, 1, }, nil, nil, { 5786, }, },
	[7953]   = { nil, 1,  3,   7953,   6466,  90, 120, 135, 150,  1,  1, { 6470, 4231, 2321, }, { 4, 1, 1, }, nil, nil, { 6474, }, },
	[6703]   = { nil, 1,  3,   6703,   5781,  95, 125, 140, 155,  1,  1, { 5784, 4231, 2318, 2321, }, { 12, 1, 8, 1, }, nil, nil, { 5787, }, },
	[9068]   = { nil, 1,  3,   9068,   7282,  95, 125, 140, 155,  1,  1, { 2318, 4231, 2321, }, { 10, 1, 1, }, true, 400, },
	[20648]  = { nil, 1,  3,  20648,   2319, 100, 100, 105, 110,  1,  1, { 2318, }, { 4, }, true, 500, },
	[2165]   = { nil, 1,  3,   2165,   2313, 100, 115, 122, 130,  1,  1, { 2319, 2320, }, { 4, 1, }, true, 250, },
	[3817]   = { nil, 1,  3,   3817,   4233, 100, 115, 122, 130,  1,  1, { 4232, 4289, }, { 1, 1, }, true, 200, },
	[2167]   = { nil, 1,  3,   2167,   2315, 100, 125, 137, 150,  1,  1, { 2319, 2321, 4340, }, { 4, 2, 1, }, true, 350, },
	[2169]   = { nil, 1,  3,   2169,   2317, 100, 125, 137, 150,  1,  1, { 2319, 2321, 4340, }, { 6, 1, 1, }, nil, nil, { 2409, }, },
	[3762]   = { nil, 1,  3,   3762,   4244, 100, 125, 137, 150,  1,  1, { 4243, 4231, 2320, }, { 1, 2, 2, }, nil, nil, { 4293, }, },
	[9070]   = { nil, 1,  3,   9070,   7283, 100, 125, 137, 150,  1,  1, { 7286, 2319, 2321, }, { 12, 4, 1, }, nil, nil, { 7289, }, },
	[24940]  = { nil, 1,  3,  24940,  20575, 100, 125, 137, 150,  1,  1, { 2319, 7286, 4231, 2321, }, { 8, 8, 1, 2, }, nil, nil, { 20576, }, },
	[7133]   = { nil, 1,  3,   7133,   5958, 105, 130, 142, 155,  1,  1, { 2319, 2997, 2321, }, { 8, 1, 1, }, nil, nil, { 5972, }, },
	[7954]   = { nil, 1,  3,   7954,   6467, 105, 130, 142, 155,  1,  1, { 6470, 2321, }, { 5, 2, }, nil, nil, { 6475, }, },
	[2168]   = { nil, 1,  3,   2168,   2316, 110, 135, 147, 160,  1,  1, { 2319, 2321, 4340, }, { 8, 1, 1, }, true, 350, },
	[7135]   = { nil, 1,  3,   7135,   5961, 115, 140, 152, 165,  1,  1, { 2319, 4340, 2321, }, { 12, 1, 1, }, true, 400, },
	[7955]   = { nil, 1,  3,   7955,   6468, 115, 140, 152, 165,  1,  1, { 6471, 6470, 2321, }, { 6, 4, 2, }, nil, nil, { 6476, }, },
	[2166]   = { nil, 1,  3,   2166,   2314, 120, 145, 157, 170,  1,  1, { 2319, 4231, 2321, }, { 10, 6, 2, }, true, 450, },
	[3767]   = { nil, 1,  3,   3767,   4250, 120, 145, 157, 170,  1,  1, { 2319, 3383, 2321, }, { 8, 1, 2, }, nil, nil, { 4294, }, },
	[9072]   = { nil, 1,  3,   9072,   7284, 120, 145, 157, 170,  1,  1, { 2604, 2319, 2321, }, { 6, 10, 1, }, nil, nil, { 7290, }, },
	[9074]   = { nil, 1,  3,   9074,   7285, 120, 145, 157, 170,  1,  1, { 2457, 2319, 2321, }, { 1, 6, 1, }, true, 500, },
	[3765]   = { nil, 1,  3,   3765,   4248, 120, 155, 167, 180,  1,  1, { 2319, 5373, 2321, 4340, }, { 8, 2, 1, 1, }, nil, nil, { 7360, }, },
	[3766]   = { nil, 1,  3,   3766,   4249, 125, 150, 162, 175,  1,  1, { 4246, 4233, 2321, 4340, }, { 1, 1, 2, 1, }, true, 400, },
	[9145]   = { nil, 1,  3,   9145,   7348, 125, 150, 162, 175,  1,  1, { 2319, 4233, 2321, }, { 8, 4, 2, }, true, 500, },
	[3768]   = { nil, 1,  3,   3768,   4251, 130, 155, 167, 180,  1,  1, { 4233, 2319, 2321, }, { 1, 4, 1, }, true, 500, },
	[3770]   = { nil, 1,  3,   3770,   4253, 135, 160, 172, 185,  1,  1, { 2319, 4233, 3389, 3182, 2321, }, { 4, 2, 2, 2, 2, }, true, 500, },
	[9146]   = { nil, 1,  3,   9146,   7349, 135, 160, 172, 185,  1,  1, { 2319, 3356, 2321, }, { 8, 4, 2, }, nil, nil, { 7361, }, },
	[9147]   = { nil, 1,  3,   9147,   7352, 135, 160, 172, 185,  1,  1, { 2319, 7067, 2321, }, { 6, 1, 2, }, nil, nil, { 7362, }, },
	[3769]   = { nil, 1,  3,   3769,   4252, 140, 165, 177, 190,  1,  1, { 2319, 3390, 4340, 2321, }, { 12, 1, 1, 2, }, nil, nil, { 4296, }, },
	[9148]   = { nil, 1,  3,   9148,   7358, 140, 165, 177, 190,  1,  1, { 2319, 5373, 2321, }, { 10, 2, 2, }, nil, nil, { 7363, }, },
	[3764]   = { nil, 1,  3,   3764,   4247, 145, 170, 182, 195,  1,  1, { 2319, 2321, }, { 14, 4, }, true, 500, },
	[9149]   = { nil, 1,  3,   9149,   7359, 145, 170, 182, 195,  1,  1, { 2319, 7067, 2997, 2321, }, { 12, 2, 2, 2, }, nil, nil, { 7364, }, },
	[20649]  = { nil, 1,  3,  20649,   4234, 150, 150, 155, 160,  1,  1, { 2319, }, { 5, }, true, 1000, },
	[23190]  = { nil, 1,  3,  23190,  18662, 150, 150, 155, 160,  1,  1, { 4234, 2321, }, { 2, 1, }, nil, nil, { 18731, }, },
	[3818]   = { nil, 1,  3,   3818,   4236, 150, 160, 165, 170,  1,  1, { 4235, 4289, }, { 1, 3, }, true, 500, },
	[3760]   = { nil, 1,  3,   3760,   3719, 150, 170, 180, 190,  1,  1, { 4234, 2321, }, { 5, 2, }, true, 600, },
	[3771]   = { nil, 1,  3,   3771,   4254, 150, 170, 180, 190,  1,  1, { 4234, 5637, 2321, }, { 6, 2, 1, }, nil, nil, { 4297, }, },
	[3780]   = { nil, 1,  3,   3780,   4265, 150, 170, 180, 190,  1,  1, { 4234, 2321, }, { 5, 1, }, true, 750, },
	[3772]   = { nil, 1,  3,   3772,   4255, 155, 175, 185, 195,  1,  1, { 4234, 2605, 2321, }, { 9, 2, 4, }, nil, nil, { 7613, }, },
	[23399]  = { nil, 1,  3,  23399,  18948, 155, 175, 185, 195,  1,  1, { 4234, 4236, 5498, 4461, 5637, }, { 8, 2, 4, 1, 4, }, nil, nil, { 18949, }, },
	[3774]   = { nil, 1,  3,   3774,   4257, 160, 180, 190, 200,  1,  1, { 4236, 4234, 2321, 2605, 7071, }, { 1, 5, 1, 1, 1, }, true, 1000, },
	[7147]   = { nil, 1,  3,   7147,   5962, 160, 180, 190, 200,  1,  1, { 4234, 4305, 2321, }, { 12, 2, 2, }, true, 1000, },
	[4096]   = { nil, 1,  3,   4096,   4455, 165, 185, 195, 205,  1,  1, { 4461, 4234, 2321, }, { 6, 4, 2, }, nil, nil, { 13287, }, },
	[4097]   = { nil, 1,  3,   4097,   4456, 165, 185, 195, 205,  1,  1, { 4461, 4234, 2321, }, { 4, 4, 2, }, nil, nil, { 13288, }, },
	[9195]   = { nil, 1,  3,   9195,   7373, 165, 185, 195, 205,  1,  1, { 4234, 2325, 2321, }, { 10, 1, 2, }, nil, nil, { 7449, }, },
	[3775]   = { nil, 1,  3,   3775,   4258, 170, 190, 200, 210,  1,  1, { 4236, 4234, 2321, 7071, }, { 2, 4, 1, 1, }, nil, nil, { 4298, }, },
	[6704]   = { nil, 1,  3,   6704,   5782, 170, 190, 200, 210,  1,  1, { 5785, 4236, 4234, 2321, }, { 12, 1, 10, 3, }, nil, nil, { 5788, }, },
	[7149]   = { nil, 1,  3,   7149,   5963, 170, 190, 200, 210,  1,  1, { 4234, 2321, 1206, }, { 10, 2, 1, }, nil, nil, { 5973, }, },
	[3773]   = { nil, 1,  3,   3773,   4256, 175, 195, 205, 215,  1,  1, { 4236, 4234, 3824, 2321, }, { 2, 12, 1, 2, }, nil, nil, { 4299, }, },
	[7151]   = { nil, 1,  3,   7151,   5964, 175, 195, 205, 215,  1,  1, { 4234, 4236, 2321, }, { 8, 1, 2, }, true, 1200, },
	[9196]   = { nil, 1,  3,   9196,   7374, 175, 195, 205, 215,  1,  1, { 4234, 3824, 2321, }, { 10, 1, 2, }, true, 1500, },
	[9197]   = { nil, 1,  3,   9197,   7375, 175, 195, 205, 215,  1,  1, { 7392, 4234, 2321, }, { 4, 10, 2, }, nil, nil, { 7450, }, },
	[3776]   = { nil, 1,  3,   3776,   4259, 180, 200, 210, 220,  1,  1, { 4236, 4234, 2605, 2321, }, { 2, 6, 1, 1, }, true, 1200, },
	[9198]   = { nil, 1,  3,   9198,   7377, 180, 200, 210, 220,  1,  1, { 4234, 7067, 7070, 2321, }, { 6, 2, 2, 2, }, true, 2000, },
	[3778]   = { nil, 1,  3,   3778,   4262, 185, 205, 215, 225,  1,  1, { 4236, 5500, 1529, 3864, 2321, }, { 4, 1, 1, 1, 1, }, nil, nil, { 14635, }, },
	[7153]   = { nil, 1,  3,   7153,   5965, 185, 205, 215, 225,  1,  1, { 4234, 4305, 4291, }, { 14, 2, 2, }, nil, nil, { 5974, }, },
	[9201]   = { nil, 1,  3,   9201,   7378, 185, 205, 215, 225,  1,  1, { 4234, 2325, 4291, }, { 16, 1, 2, }, true, 2000, },
	[6661]   = { nil, 1,  3,   6661,   5739, 190, 210, 220, 230,  1,  1, { 4234, 2321, 7071, }, { 14, 2, 1, }, true, 2000, },
	[6705]   = { nil, 1,  3,   6705,   5783, 190, 210, 220, 230,  1,  1, { 5785, 4236, 4234, 4291, }, { 16, 1, 14, 1, }, nil, nil, { 5789, }, },
	[7156]   = { nil, 1,  3,   7156,   5966, 190, 210, 220, 230,  1,  1, { 4234, 4236, 4291, }, { 4, 1, 1, }, true, 2400, },
	[9202]   = { nil, 1,  3,   9202,   7386, 190, 210, 220, 230,  1,  1, { 7392, 4234, 4291, }, { 6, 8, 2, }, nil, nil, { 7451, }, },
	[21943]  = { nil, 1,  3,  21943,  17721, 190, 210, 220, 230,  1,  1, { 4234, 7067, 4291, }, { 8, 4, 1, }, nil, nil, { 17722, }, },
	[3777]   = { nil, 1,  3,   3777,   4260, 195, 215, 225, 235,  1,  1, { 4234, 4236, 4291, }, { 6, 2, 1, }, nil, nil, { 4300, }, },
	[9206]   = { nil, 1,  3,   9206,   7387, 195, 215, 225, 235,  1,  1, { 4234, 4305, 2325, 7071, }, { 10, 2, 2, 1, }, true, 2500, },
	[10482]  = { nil, 1,  3,  10482,   8172, 200, 200, 200, 200,  1,  1, { 8169, 8150, }, { 1, 1, }, true, 2000, },
	[20650]  = { nil, 1,  3,  20650,   4304, 200, 200, 202, 205,  1,  1, { 4234, }, { 6, }, true, 4000, },
	[22711]  = { nil, 1,  3,  22711,  18238, 200, 210, 220, 230,  1,  1, { 4304, 10285, 4236, 8343, }, { 6, 8, 4, 1, }, nil, nil, { 18239, }, },
	[3779]   = { nil, 1,  3,   3779,   4264, 200, 220, 230, 240,  1,  1, { 4234, 4236, 5633, 4291, 7071, }, { 6, 2, 1, 1, 1, }, nil, nil, { 4301, }, },
	[9207]   = { nil, 1,  3,   9207,   7390, 200, 220, 230, 240,  1,  1, { 4234, 10285, 4291, }, { 8, 2, 2, }, nil, nil, { 7452, }, },
	[9208]   = { nil, 1,  3,   9208,   7391, 200, 220, 230, 240,  1,  1, { 4234, 2459, 4337, 4291, }, { 10, 2, 2, 1, }, nil, nil, { 7453, }, },
	[10487]  = { nil, 1,  3,  10487,   8173, 200, 220, 230, 240,  1,  1, { 4304, 4291, }, { 5, 1, }, true, 2000, },
	[10490]  = { nil, 1,  3,  10490,   8174, 200, 220, 230, 240,  1,  1, { 4234, 4236, 4291, }, { 12, 2, 2, }, nil, nil, { 8384, }, },
	[10499]  = { nil, 1,  3,  10499,   8175, 205, 225, 235, 245,  1,  1, { 4304, 4291, }, { 7, 2, }, true, 3000, },
	[10507]  = { nil, 1,  3,  10507,   8176, 205, 225, 235, 245,  1,  1, { 4304, 4291, }, { 5, 2, }, true, 3000, },
	[10509]  = { nil, 1,  3,  10509,   8187, 205, 225, 235, 245,  1,  1, { 4304, 8167, 8343, }, { 6, 8, 1, }, nil, nil, { 8385, }, },
	[10511]  = { nil, 1,  3,  10511,   8189, 210, 230, 240, 250,  1,  1, { 4304, 8167, 8343, }, { 6, 12, 1, }, true, 3000, },
	[10516]  = { nil, 1,  3,  10516,   8192, 210, 230, 240, 250,  1,  1, { 4304, 4338, 4291, }, { 8, 6, 3, }, nil, nil, { 8409, }, },
	[10518]  = { nil, 1,  3,  10518,   8198, 210, 230, 240, 250,  1,  1, { 4304, 8167, 8343, }, { 8, 12, 1, }, true, 3500, },
	[10520]  = { nil, 1,  3,  10520,   8200, 215, 235, 245, 255,  1,  1, { 4304, 8343, }, { 10, 1, }, nil, nil, { 8386, }, },
	[10525]  = { nil, 1,  3,  10525,   8203, 220, 240, 250, 260,  1,  1, { 4304, 8154, 4291, }, { 12, 12, 4, }, nil, nil, { 8395, 72029, }, },
	[10529]  = { nil, 1,  3,  10529,   8210, 220, 240, 250, 260,  1,  1, { 4304, 8153, 8172, }, { 10, 1, 1, }, nil, nil, { 8403, }, },
	[10531]  = { nil, 1,  3,  10531,   8201, 220, 240, 250, 260,  1,  1, { 4304, 8343, }, { 8, 1, }, nil, nil, { 8387, }, },
	[10533]  = { nil, 1,  3,  10533,   8205, 220, 240, 250, 260,  1,  1, { 4304, 8154, 4291, }, { 10, 4, 2, }, nil, nil, { 8397, 72026, }, },
	[10542]  = { nil, 1,  3,  10542,   8204, 225, 245, 255, 265,  1,  1, { 4304, 8154, 4291, }, { 6, 8, 2, }, nil, nil, { 8398, 72025, }, },
	[10544]  = { nil, 1,  3,  10544,   8211, 225, 245, 255, 265,  1,  1, { 4304, 8153, 8172, }, { 12, 2, 1, }, nil, nil, { 8404, }, },
	[10546]  = { nil, 1,  3,  10546,   8214, 225, 245, 255, 265,  1,  1, { 4304, 8153, 8172, }, { 10, 2, 1, }, nil, nil, { 8405, }, },
	[10619]  = { nil, 1,  3,  10619,   8347, 225, 245, 255, 265,  1,  1, { 4304, 8165, 8343, 8172, }, { 24, 12, 4, 2, }, },
	[10621]  = { nil, 1,  3,  10621,   8345, 225, 245, 255, 265,  1,  1, { 4304, 8153, 8172, 8343, }, { 18, 12, 4, 1, }, },
	[10548]  = { nil, 1,  3,  10548,   8193, 230, 250, 260, 270,  1,  1, { 4304, 4291, }, { 14, 4, }, true, 4000, },
	[10550]  = { nil, 1,  3,  10550,   8195, 230, 250, 260, 270,  1,  1, { 4304, 4291, }, { 12, 4, }, nil, nil, { 8388, }, },
	[10552]  = { nil, 1,  3,  10552,   8191, 230, 250, 260, 270,  1,  1, { 4304, 8167, 8343, }, { 14, 24, 1, }, true, 4000, },
	[10630]  = { nil, 1,  3,  10630,   8346, 230, 250, 260, 270,  1,  1, { 4304, 7079, 8172, 8343, }, { 20, 4, 1, 4, }, true, 10000, },
	[10554]  = { nil, 1,  3,  10554,   8209, 235, 255, 265, 275,  1,  1, { 4304, 8154, 4291, }, { 12, 12, 6, }, nil, nil, { 8399, 72028, }, },
	[10556]  = { nil, 1,  3,  10556,   8185, 235, 255, 265, 275,  1,  1, { 4304, 8167, 8343, }, { 14, 28, 1, }, true, 4500, },
	[10558]  = { nil, 1,  3,  10558,   8197, 235, 255, 265, 275,  1,  1, { 4304, 8343, }, { 16, 2, }, true, 4500, },
	[10560]  = { nil, 1,  3,  10560,   8202, 240, 260, 270, 280,  1,  1, { 4304, 8343, }, { 14, 2, }, nil, nil, { 8389, }, },
	[10562]  = { nil, 1,  3,  10562,   8216, 240, 260, 270, 280,  1,  1, { 4304, 8343, }, { 14, 2, }, nil, nil, { 8390, }, },
	[10564]  = { nil, 1,  3,  10564,   8207, 240, 260, 270, 280,  1,  1, { 4304, 8154, 8343, }, { 12, 16, 2, }, nil, nil, { 8400, 72027, }, },
	[10566]  = { nil, 1,  3,  10566,   8213, 245, 265, 275, 285,  1,  1, { 4304, 8153, 8172, }, { 14, 4, 2, }, nil, nil, { 8406, }, },
	[10568]  = { nil, 1,  3,  10568,   8206, 245, 265, 275, 285,  1,  1, { 4304, 8154, 8343, }, { 14, 8, 2, }, nil, nil, { 8401, 72030, }, },
	[22331]  = { nil, 1,  3,  22331,   8170, 250, 250, 250, 250,  1,  1, { 4304, }, { 6, }, true, 5000, },
	[19047]  = { nil, 1,  3,  19047,  15407, 250, 250, 255, 260,  1,  1, { 8171, 15409, }, { 1, 1, }, true, 5000, },
	[19058]  = { nil, 1,  3,  19058,  15564, 250, 255, 265, 275,  1,  1, { 8170, }, { 5, }, true, 5000, },
	[10570]  = { nil, 1,  3,  10570,   8208, 250, 270, 280, 290,  1,  1, { 4304, 8154, 8343, }, { 10, 20, 2, }, nil, nil, { 8402, 72033, }, },
	[10572]  = { nil, 1,  3,  10572,   8212, 250, 270, 280, 290,  1,  1, { 4304, 8153, 8172, }, { 16, 6, 2, }, nil, nil, { 8407, }, },
	[10574]  = { nil, 1,  3,  10574,   8215, 250, 270, 280, 290,  1,  1, { 4304, 8153, 8172, }, { 16, 6, 2, }, nil, nil, { 8408, }, },
	[10632]  = { nil, 1,  3,  10632,   8348, 250, 270, 280, 290,  1,  1, { 4304, 7077, 8172, 8343, }, { 30, 8, 2, 4, }, true, 10000, },
	[10647]  = { nil, 1,  3,  10647,   8349, 250, 270, 280, 290,  1,  1, { 4304, 17056, 7971, 8172, 8343, }, { 25, 20, 2, 4, 4, }, true, 10000, },
	[10650]  = { nil, 1,  3,  10650,   8367, 255, 275, 285, 295,  1,  1, { 4304, 8165, 8343, 8172, }, { 40, 30, 4, 4, }, true, 10000, },
	[19048]  = { nil, 1,  3,  19048,  15077, 255, 275, 285, 295,  1,  1, { 8170, 15408, 14341, }, { 4, 4, 1, }, nil, nil, { 15724, }, },
	[19049]  = { nil, 1,  3,  19049,  15083, 260, 280, 290, 300,  1,  1, { 8170, 2325, 14341, }, { 8, 1, 1, }, nil, nil, { 15725, }, },
	[19050]  = { nil, 1,  3,  19050,  15045, 260, 280, 290, 300,  1,  1, { 8170, 15412, 14341, }, { 20, 25, 2, }, nil, nil, { 15726, 78346, }, },
	[36074]  = { nil, 1,  3,  36074,  29964, 260, 280, 290, 300,  1,  1, { 8170, 7081, 8172, 14341, }, { 10, 8, 2, 1, }, true, 10000, },
	[36075]  = { nil, 1,  3,  36075,  29970, 260, 280, 290, 300,  1,  1, { 8170, 17056, 8153, 8172, 14341, }, { 10, 5, 4, 2, 1, }, true, 10000, },
	[36076]  = { nil, 1,  3,  36076,  29971, 260, 280, 290, 300,  1,  1, { 8170, 8165, 8172, 14341, }, { 10, 10, 2, 1, }, true, 10000, },
	[19051]  = { nil, 1,  3,  19051,  15076, 265, 285, 295, 305,  1,  1, { 8170, 15408, 14341, }, { 6, 6, 1, }, nil, nil, { 15727, }, },
	[19052]  = { nil, 1,  3,  19052,  15084, 265, 285, 295, 305,  1,  1, { 8170, 2325, 14341, }, { 8, 1, 1, }, true, 10000, { 15728, }, },
	[19053]  = { nil, 1,  3,  19053,  15074, 265, 285, 295, 305,  1,  1, { 8170, 12803, 14341, }, { 6, 1, 1, }, nil, nil, { 15729, }, },
	[19055]  = { nil, 1,  3,  19055,  15091, 270, 290, 300, 310,  1,  1, { 8170, 14047, 14341, }, { 10, 6, 1, }, true, 10000, { 15731, }, },
	[19059]  = { nil, 1,  3,  19059,  15054, 270, 290, 300, 310,  1,  1, { 8170, 7078, 7075, 14341, }, { 6, 1, 1, 1, }, nil, nil, { 15732, }, },
	[19060]  = { nil, 1,  3,  19060,  15046, 270, 290, 300, 310,  1,  1, { 8170, 15412, 14341, }, { 20, 25, 1, }, nil, nil, { 15733, 78345, }, },
	[19061]  = { nil, 1,  3,  19061,  15061, 270, 290, 300, 310,  1,  1, { 8170, 12803, 14341, }, { 12, 4, 1, }, nil, nil, { 15734, }, },
	[19062]  = { nil, 1,  3,  19062,  15067, 270, 290, 300, 310,  1,  1, { 8170, 17056, 1529, 14341, }, { 24, 40, 2, 1, }, nil, nil, { 15735, }, },
	[19063]  = { nil, 1,  3,  19063,  15073, 275, 295, 305, 315,  1,  1, { 8170, 12803, 14341, }, { 4, 1, 1, }, nil, nil, { 15737, }, },
	[19064]  = { nil, 1,  3,  19064,  15078, 275, 295, 305, 315,  1,  1, { 8170, 15408, 14341, }, { 6, 8, 1, }, nil, nil, { 15738, }, },
	[19065]  = { nil, 1,  3,  19065,  15092, 275, 295, 305, 315,  1,  1, { 8170, 7971, 14341, }, { 6, 1, 1, }, true, 10000, { 15739, }, },
	[19066]  = { nil, 1,  3,  19066,  15071, 275, 295, 305, 315,  1,  1, { 8170, 7080, 14341, }, { 4, 1, 1, }, nil, nil, { 15740, }, },
	[19067]  = { nil, 1,  3,  19067,  15057, 275, 295, 305, 315,  1,  1, { 8170, 7082, 14341, }, { 16, 2, 1, }, nil, nil, { 15741, }, },
	[19068]  = { nil, 1,  3,  19068,  15064, 275, 295, 305, 315,  1,  1, { 8170, 15419, 14341, }, { 28, 12, 1, }, nil, nil, { 20253, 15742, }, },
	[19070]  = { nil, 1,  3,  19070,  15082, 280, 300, 310, 320,  1,  1, { 8170, 15408, 14341, }, { 6, 8, 1, }, nil, nil, { 15743, }, },
	[19071]  = { nil, 1,  3,  19071,  15086, 280, 300, 310, 320,  1,  1, { 8170, 2325, 14341, }, { 12, 1, 1, }, true, 10000, { 15744, }, },
	[19072]  = { nil, 1,  3,  19072,  15093, 280, 300, 310, 320,  1,  1, { 8170, 14047, 14341, }, { 10, 10, 1, }, true, 10000, { 15745, }, },
	[19073]  = { nil, 1,  3,  19073,  15072, 280, 300, 310, 320,  1,  1, { 8170, 12803, 14341, }, { 8, 1, 1, }, nil, nil, { 15746, }, },
	[24655]  = { nil, 1,  3,  24655,  20296, 280, 300, 310, 320,  1,  1, { 8170, 15412, 15407, 14341, }, { 20, 30, 1, 2, }, true, 30000, },
	[44953]  = { nil, 1,  3,  44953,  34086, 285, 285, 285, 285,  1,  1, { 2840, 2997, 8170, 14341, }, { 1, 1, 4, 1, }, nil, nil, { 34262, }, },
	[22815]  = { nil, 1,  3,  22815,  18258, 285, 285, 290, 295,  1,  1, { 8170, 14048, 18240, 14341, }, { 4, 2, 1, 1, }, },
	[19074]  = { nil, 1,  3,  19074,  15069, 285, 305, 315, 325,  1,  1, { 8170, 7080, 14341, }, { 6, 1, 1, }, nil, nil, { 15747, }, },
	[19075]  = { nil, 1,  3,  19075,  15079, 285, 305, 315, 325,  1,  1, { 8170, 15408, 14341, }, { 8, 12, 1, }, nil, nil, { 15748, }, },
	[19076]  = { nil, 1,  3,  19076,  15053, 285, 305, 315, 325,  1,  1, { 8170, 7078, 7076, 14341, }, { 8, 1, 1, 1, }, nil, nil, { 15749, }, },
	[19077]  = { nil, 1,  3,  19077,  15048, 285, 305, 315, 325,  1,  1, { 8170, 15415, 15407, 14341, }, { 28, 30, 1, 1, }, nil, nil, { 15751, }, },
	[19078]  = { nil, 1,  3,  19078,  15060, 285, 305, 315, 325,  1,  1, { 8170, 12803, 15407, 14341, }, { 16, 6, 1, 1, }, nil, nil, { 15752, }, },
	[19079]  = { nil, 1,  3,  19079,  15056, 285, 305, 315, 325,  1,  1, { 8170, 7082, 15407, 14341, }, { 16, 3, 1, 1, }, nil, nil, { 15753, }, },
	[19080]  = { nil, 1,  3,  19080,  15065, 285, 305, 315, 325,  1,  1, { 8170, 15419, 14341, }, { 24, 14, 1, }, nil, nil, { 20254, 15754, }, },
	[19081]  = { nil, 1,  3,  19081,  15075, 290, 310, 320, 330,  1,  1, { 8170, 12803, 14341, }, { 10, 1, 1, }, nil, nil, { 15755, }, },
	[19082]  = { nil, 1,  3,  19082,  15094, 290, 310, 320, 330,  1,  1, { 8170, 14047, 14341, }, { 14, 10, 1, }, true, 15000, { 15756, }, },
	[19083]  = { nil, 1,  3,  19083,  15087, 290, 310, 320, 330,  1,  1, { 8170, 15407, 2325, 14341, }, { 12, 1, 3, 1, }, true, 15000, { 15757, }, },
	[19084]  = { nil, 1,  3,  19084,  15063, 290, 310, 320, 330,  1,  1, { 15417, 14341, }, { 8, 1, }, nil, nil, { 15758, }, },
	[19085]  = { nil, 1,  3,  19085,  15050, 290, 310, 320, 330,  1,  1, { 8170, 15416, 15407, 14341, }, { 25, 25, 1, 2, }, nil, nil, { 15759, }, },
	[19086]  = { nil, 1,  3,  19086,  15066, 290, 310, 320, 330,  1,  1, { 8170, 17056, 1529, 15407, 14341, }, { 35, 40, 1, 1, 1, }, nil, nil, { 15760, }, },
	[23703]  = { nil, 1,  3,  23703,  19044, 290, 310, 320, 330,  1,  1, { 8170, 12803, 15407, 14341, }, { 30, 4, 2, 2, }, nil, nil, { 19326, }, },
	[23705]  = { nil, 1,  3,  23705,  19052, 290, 310, 320, 330,  1,  1, { 8170, 12809, 7080, 15407, 14341, }, { 30, 2, 4, 2, 2, }, nil, nil, { 19328, }, },
	[19087]  = { nil, 1,  3,  19087,  15070, 295, 315, 325, 335,  1,  1, { 8170, 7080, 14341, }, { 6, 1, 1, }, nil, nil, { 15761, }, },
	[19088]  = { nil, 1,  3,  19088,  15080, 295, 315, 325, 335,  1,  1, { 8170, 15408, 15407, 14341, }, { 8, 12, 1, 1, }, nil, nil, { 15762, }, },
	[19089]  = { nil, 1,  3,  19089,  15049, 295, 315, 325, 335,  1,  1, { 8170, 15415, 12810, 15407, 14341, }, { 28, 30, 2, 1, 1, }, nil, nil, { 15763, }, },
	[19090]  = { nil, 1,  3,  19090,  15058, 295, 315, 325, 335,  1,  1, { 8170, 7082, 14227, }, { 12, 3, 2, }, nil, nil, { 15764, }, },
	[20853]  = { nil, 1,  3,  20853,  16982, 295, 315, 325, 335,  1,  1, { 17012, 17010, 17011, 14341, }, { 20, 6, 2, 2, }, nil, nil, { 17022, }, },
	[32454]  = { nil, 1,  3,  32454,  21887, 300, 300, 305, 310,  1,  1, { 25649, }, { 5, }, true, 10000, },
	[32482]  = { nil, 1,  3,  32482,  25679, 300, 300, 305, 310,  1,  1, { 21887, }, { 2, }, nil, nil, { 25726, }, },
	[32462]  = { nil, 1,  3,  32462,  25654, 300, 310, 320, 330,  1,  1, { 21887, 25700, 14341, }, { 5, 1, 2, }, true, 15000, },
	[32466]  = { nil, 1,  3,  32466,  25662, 300, 310, 320, 330,  1,  1, { 21887, 25700, 14341, }, { 6, 3, 2, }, true, 15000, },
	[32470]  = { nil, 1,  3,  32470,  25669, 300, 310, 320, 330,  1,  1, { 21887, 14341, }, { 6, 2, }, true, 15000, },
	[32478]  = { nil, 1,  3,  32478,  25673, 300, 310, 320, 330,  1,  1, { 21887, 14341, }, { 6, 3, }, true, 15000, },
	[45100]  = { nil, 1,  3,  45100,  34482, 300, 310, 320, 330,  1,  1, { 21887, 25700, 25707, 14341, }, { 20, 4, 4, 3, }, true, 15000, },
	[32456]  = { nil, 1,  3,  32456,  25650, 300, 310, 325, 340,  1,  1, { 21887, }, { 4, }, true, 15000, },
	[19054]  = { nil, 1,  3,  19054,  15047, 300, 320, 330, 340,  1,  1, { 8170, 15414, 14341, }, { 40, 30, 1, }, nil, nil, { 15730, }, },
	[19091]  = { nil, 1,  3,  19091,  15095, 300, 320, 330, 340,  1,  1, { 8170, 14047, 12810, 14341, }, { 18, 12, 2, 1, }, true, 15000, { 15765, }, },
	[19092]  = { nil, 1,  3,  19092,  15088, 300, 320, 330, 340,  1,  1, { 8170, 2325, 14341, }, { 14, 2, 2, }, true, 15000, { 15768, }, },
	[19093]  = { nil, 1,  3,  19093,  15138, 300, 320, 330, 340,  1,  1, { 15410, 14044, 14341, }, { 1, 1, 1, }, nil, nil, { 15769, }, },
	[19094]  = { nil, 1,  3,  19094,  15051, 300, 320, 330, 340,  1,  1, { 8170, 15416, 15407, 14341, }, { 20, 15, 1, 1, }, nil, nil, { 15770, }, },
	[19095]  = { nil, 1,  3,  19095,  15059, 300, 320, 330, 340,  1,  1, { 8170, 12803, 14342, 15407, 14341, }, { 16, 8, 2, 1, 2, }, nil, nil, { 15771, }, },
	[19097]  = { nil, 1,  3,  19097,  15062, 300, 320, 330, 340,  1,  1, { 15417, 15407, 14341, }, { 12, 1, 1, }, nil, nil, { 15772, }, },
	[19098]  = { nil, 1,  3,  19098,  15085, 300, 320, 330, 340,  1,  1, { 8170, 15407, 14256, 2325, 14341, }, { 20, 2, 2, 4, 2, }, true, 15000, { 15773, }, },
	[19100]  = { nil, 1,  3,  19100,  15081, 300, 320, 330, 340,  1,  1, { 8170, 15408, 15407, 14341, }, { 14, 14, 1, 2, }, nil, nil, { 15774, }, },
	[19101]  = { nil, 1,  3,  19101,  15055, 300, 320, 330, 340,  1,  1, { 8170, 7078, 7076, 14341, }, { 10, 1, 1, 2, }, nil, nil, { 15775, }, },
	[19102]  = { nil, 1,  3,  19102,  15090, 300, 320, 330, 340,  1,  1, { 8170, 12810, 14047, 15407, 14341, }, { 22, 4, 16, 1, 2, }, true, 15000, { 15776, }, },
	[19103]  = { nil, 1,  3,  19103,  15096, 300, 320, 330, 340,  1,  1, { 8170, 12810, 14047, 15407, 14341, }, { 16, 4, 18, 1, 2, }, true, 15000, { 15777, }, },
	[19104]  = { nil, 1,  3,  19104,  15068, 300, 320, 330, 340,  1,  1, { 8170, 7080, 15407, 14341, }, { 12, 1, 1, 2, }, nil, nil, { 15779, }, },
	[19106]  = { nil, 1,  3,  19106,  15141, 300, 320, 330, 340,  1,  1, { 8170, 15410, 15416, 14341, }, { 40, 12, 60, 2, }, nil, nil, { 15780, }, },
	[19107]  = { nil, 1,  3,  19107,  15052, 300, 320, 330, 340,  1,  1, { 8170, 15416, 15407, 14341, }, { 25, 25, 1, 2, }, nil, nil, { 15781, }, },
	[20854]  = { nil, 1,  3,  20854,  16983, 300, 320, 330, 340,  1,  1, { 17012, 17010, 17011, 14341, }, { 12, 3, 3, 2, }, nil, nil, { 17023, }, },
	[20855]  = { nil, 1,  3,  20855,  16984, 300, 320, 330, 340,  1,  1, { 15416, 17010, 17011, 14341, }, { 18, 3, 3, 2, }, nil, nil, { 17025, }, },
	[22727]  = { nil, 1,  3,  22727,  18251, 300, 320, 330, 340,  1,  1, { 17012, 14341, }, { 3, 2, }, nil, nil, { 18252, }, },
	[22921]  = { nil, 1,  3,  22921,  18504, 300, 320, 330, 340,  1,  1, { 8170, 12804, 15407, 14341, }, { 12, 12, 2, 4, }, nil, nil, { 18514, }, },
	[22922]  = { nil, 1,  3,  22922,  18506, 300, 320, 330, 340,  1,  1, { 8170, 7082, 11754, 15407, 14341, }, { 12, 6, 4, 2, 4, }, nil, nil, { 18515, }, },
	[22923]  = { nil, 1,  3,  22923,  18508, 300, 320, 330, 340,  1,  1, { 8170, 15407, 14341, }, { 24, 6, 4, }, nil, nil, { 18516, }, },
	[22926]  = { nil, 1,  3,  22926,  18509, 300, 320, 330, 340,  1,  1, { 8170, 12607, 15416, 15414, 14341, }, { 25, 4, 12, 12, 2, }, nil, nil, { 18517, }, },
	[22927]  = { nil, 1,  3,  22927,  18510, 300, 320, 330, 340,  1,  1, { 8170, 8153, 15407, 14341, }, { 30, 8, 2, 2, }, nil, nil, { 18518, }, },
	[22928]  = { nil, 1,  3,  22928,  18511, 300, 320, 330, 340,  1,  1, { 12810, 14341, }, { 10, 1, }, nil, nil, { 18519, }, },
	[23704]  = { nil, 1,  3,  23704,  19049, 300, 320, 330, 340,  1,  1, { 12810, 12804, 12803, 15407, 14227, }, { 8, 6, 6, 2, 2, }, nil, nil, { 19327, }, },
	[23706]  = { nil, 1,  3,  23706,  19058, 300, 320, 330, 340,  1,  1, { 12810, 12803, 12809, 15407, 14341, }, { 8, 4, 4, 2, 2, }, nil, nil, { 19329, }, },
	[23707]  = { nil, 1,  3,  23707,  19149, 300, 320, 330, 340,  1,  1, { 17011, 17012, 14227, }, { 2, 2, 4, }, nil, nil, { 19330, }, },
	[23708]  = { nil, 1,  3,  23708,  19157, 300, 320, 330, 340,  1,  1, { 17010, 17011, 17012, 14227, }, { 3, 2, 8, 4, }, nil, nil, { 19331, }, },
	[23709]  = { nil, 1,  3,  23709,  19162, 300, 320, 330, 340,  1,  1, { 17010, 17012, 8170, 14227, }, { 4, 12, 12, 4, }, nil, nil, { 19332, }, },
	[23710]  = { nil, 1,  3,  23710,  19163, 300, 320, 330, 340,  1,  1, { 17010, 17011, 17012, 14227, }, { 2, 2, 2, 4, }, nil, nil, { 19333, }, },
	[24121]  = { nil, 1,  3,  24121,  19685, 300, 320, 330, 340,  1,  1, { 19767, 15407, 12803, 14341, }, { 14, 5, 4, 4, }, nil, nil, { 19769, }, },
	[24122]  = { nil, 1,  3,  24122,  19686, 300, 320, 330, 340,  1,  1, { 19767, 15407, 12803, 14341, }, { 10, 4, 4, 3, }, nil, nil, { 19770, }, },
	[24123]  = { nil, 1,  3,  24123,  19687, 300, 320, 330, 340,  1,  1, { 19767, 15407, 12803, 14341, }, { 8, 3, 4, 3, }, nil, nil, { 19771, }, },
	[24124]  = { nil, 1,  3,  24124,  19688, 300, 320, 330, 340,  1,  1, { 19768, 15407, 14341, }, { 25, 3, 3, }, nil, nil, { 19772, }, },
	[24125]  = { nil, 1,  3,  24125,  19689, 300, 320, 330, 340,  1,  1, { 19768, 15407, 14341, }, { 25, 3, 3, }, nil, nil, { 19773, }, },
	[24654]  = { nil, 1,  3,  24654,  20295, 300, 320, 330, 340,  1,  1, { 8170, 15415, 15407, 14341, }, { 28, 36, 2, 2, }, true, 50000, },
	[24703]  = { nil, 1,  3,  24703,  20380, 300, 320, 330, 340,  1,  1, { 8170, 20381, 12803, 14341, }, { 20, 3, 3, 2, }, nil, nil, { 20382, }, },
	[24846]  = { nil, 1,  3,  24846,  20481, 300, 320, 330, 340,  1,  1, { 15407, 8170, 7078, }, { 1, 20, 2, }, nil, nil, { 20506, }, },
	[24847]  = { nil, 1,  3,  24847,  20480, 300, 320, 330, 340,  1,  1, { 8170, 7078, 15407, }, { 30, 2, 1, }, nil, nil, { 20507, }, },
	[24848]  = { nil, 1,  3,  24848,  20479, 300, 320, 330, 340,  1,  1, { 8170, 7078, 15407, }, { 40, 2, 3, }, nil, nil, { 20508, }, },
	[24849]  = { nil, 1,  3,  24849,  20476, 300, 320, 330, 340,  1,  1, { 8170, 15407, }, { 20, 4, }, nil, nil, { 20509, }, },
	[24850]  = { nil, 1,  3,  24850,  20477, 300, 320, 330, 340,  1,  1, { 8170, 15407, }, { 35, 4, }, nil, nil, { 20510, }, },
	[24851]  = { nil, 1,  3,  24851,  20478, 300, 320, 330, 340,  1,  1, { 8170, 15407, }, { 40, 4, }, nil, nil, { 20511, }, },
	[26279]  = { nil, 1,  3,  26279,  21278, 300, 320, 330, 340,  1,  1, { 12810, 7082, 14227, }, { 6, 4, 2, }, nil, nil, { 21548, }, },
	[28219]  = { nil, 1,  3,  28219,  22661, 300, 320, 330, 340,  1,  1, { 22682, 12810, 7080, 15407, 14227, }, { 7, 16, 2, 4, 4, }, nil, nil, { 22692, }, },
	[28220]  = { nil, 1,  3,  28220,  22662, 300, 320, 330, 340,  1,  1, { 22682, 12810, 7080, 15407, 14227, }, { 5, 12, 2, 3, 4, }, nil, nil, { 22694, }, },
	[28221]  = { nil, 1,  3,  28221,  22663, 300, 320, 330, 340,  1,  1, { 22682, 12810, 7080, 15407, 14227, }, { 4, 12, 2, 2, 4, }, nil, nil, { 22695, }, },
	[28222]  = { nil, 1,  3,  28222,  22664, 300, 320, 330, 340,  1,  1, { 22682, 15408, 7080, 15407, 14227, }, { 7, 24, 2, 4, 4, }, nil, nil, { 22696, }, },
	[28223]  = { nil, 1,  3,  28223,  22666, 300, 320, 330, 340,  1,  1, { 22682, 15408, 7080, 15407, 14227, }, { 5, 16, 2, 3, 4, }, nil, nil, { 22697, }, },
	[28224]  = { nil, 1,  3,  28224,  22665, 300, 320, 330, 340,  1,  1, { 22682, 15408, 7080, 15407, 14227, }, { 4, 16, 2, 2, 4, }, nil, nil, { 22698, }, },
	[28472]  = { nil, 1,  3,  28472,  22759, 300, 320, 330, 340,  1,  1, { 8170, 12803, 15407, }, { 12, 2, 2, }, nil, nil, { 22771, }, },
	[28473]  = { nil, 1,  3,  28473,  22760, 300, 320, 330, 340,  1,  1, { 12810, 12803, 15407, }, { 6, 3, 2, }, nil, nil, { 22770, }, },
	[28474]  = { nil, 1,  3,  28474,  22761, 300, 320, 330, 340,  1,  1, { 12810, 12803, 15407, }, { 4, 2, 1, }, nil, nil, { 22769, }, },
	[32463]  = { nil, 1,  3,  32463,  25655, 310, 320, 330, 340,  1,  1, { 21887, 25700, 14341, }, { 8, 1, 2, }, true, 18000, },
	[32467]  = { nil, 1,  3,  32467,  25661, 310, 320, 330, 340,  1,  1, { 21887, 25700, 14341, }, { 8, 1, 2, }, true, 18000, },
	[32479]  = { nil, 1,  3,  32479,  25674, 310, 320, 330, 340,  1,  1, { 21887, 14341, }, { 9, 3, }, true, 18000, },
	[32471]  = { nil, 1,  3,  32471,  25670, 315, 325, 335, 345,  1,  1, { 21887, 14341, }, { 10, 2, }, true, 18000, },
	[32464]  = { nil, 1,  3,  32464,  25656, 320, 330, 340, 350,  1,  1, { 21887, 25700, 14341, }, { 10, 3, 3, }, true, 20000, },
	[32472]  = { nil, 1,  3,  32472,  25668, 320, 330, 340, 350,  1,  1, { 21887, 14341, }, { 10, 3, }, true, 20000, },
	[32480]  = { nil, 1,  3,  32480,  25675, 320, 330, 340, 350,  1,  1, { 21887, 14341, }, { 13, 3, }, true, 20000, },
	[32455]  = { nil, 1,  3,  32455,  23793, 325, 325, 330, 335,  1,  1, { 21887, }, { 5, }, true, 20000, { 25720, }, },
	[32457]  = { nil, 1,  3,  32457,  25651, 325, 335, 340, 345,  1,  1, { 23793, 22452, }, { 3, 1, }, nil, nil, { 25721, }, },
	[32458]  = { nil, 1,  3,  32458,  25652, 325, 335, 340, 345,  1,  1, { 23793, 22457, }, { 3, 1, }, nil, nil, { 25722, }, },
	[35530]  = { nil, 1,  3,  35530,  29540, 325, 335, 340, 345,  1,  1, { 23793, 22452, }, { 6, 4, }, nil, nil, { 29664, 30444, }, },
	[32468]  = { nil, 1,  3,  32468,  25660, 325, 335, 345, 355,  1,  1, { 23793, 25700, 14341, }, { 2, 3, 3, }, true, 20000, },
	[32473]  = { nil, 1,  3,  32473,  25671, 330, 340, 350, 360,  1,  1, { 23793, 14341, }, { 3, 3, }, true, 25000, },
	[32481]  = { nil, 1,  3,  32481,  25676, 330, 340, 350, 360,  1,  1, { 23793, 14341, }, { 3, 3, }, true, 25000, },
	[36077]  = { nil, 1,  3,  36077,  29973, 330, 350, 360, 370,  1,  1, { 23793, 22451, 22452, 14341, }, { 4, 2, 2, 2, }, true, 40000, },
	[36078]  = { nil, 1,  3,  36078,  29974, 330, 350, 360, 370,  1,  1, { 23793, 25699, 21886, 14341, }, { 4, 12, 3, 2, }, true, 40000, },
	[36079]  = { nil, 1,  3,  36079,  29975, 330, 350, 360, 370,  1,  1, { 23793, 15416, 21884, 14341, }, { 4, 8, 3, 2, }, true, 40000, },
	[35549]  = { nil, 1,  3,  35549,  29533, 335, 335, 345, 355,  1,  1, { 23793, 29539, 22451, }, { 4, 2, 4, }, nil, nil, { 29719, 31361, }, },
	[35555]  = { nil, 1,  3,  35555,  29534, 335, 335, 345, 355,  1,  1, { 23793, 25708, 22452, }, { 4, 8, 4, }, nil, nil, { 29720, }, },
	[32465]  = { nil, 1,  3,  32465,  25657, 335, 345, 355, 365,  1,  1, { 23793, 25700, 14341, }, { 2, 3, 3, }, true, 25000, },
	[32469]  = { nil, 1,  3,  32469,  25659, 335, 345, 355, 365,  1,  1, { 23793, 25700, 14341, }, { 2, 2, 3, }, true, 25000, },
	[35540]  = { nil, 1,  3,  35540,  29528, 340, 340, 347, 355,  1,  1, { 23793, 25700, }, { 3, 3, }, true, 20000, },
	[35520]  = { nil, 1,  3,  35520,  29483, 340, 350, 355, 360,  1,  1, { 23793, 21886, }, { 4, 4, }, nil, nil, { 29669, }, },
	[35521]  = { nil, 1,  3,  35521,  29485, 340, 350, 355, 360,  1,  1, { 23793, 21885, }, { 4, 4, }, nil, nil, { 29672, }, },
	[35522]  = { nil, 1,  3,  35522,  29486, 340, 350, 355, 360,  1,  1, { 23793, 21884, }, { 4, 4, }, nil, nil, { 29673, }, },
	[35523]  = { nil, 1,  3,  35523,  29487, 340, 350, 355, 360,  1,  1, { 23793, 22456, }, { 4, 4, }, nil, nil, { 29674, }, },
	[35524]  = { nil, 1,  3,  35524,  29488, 340, 350, 355, 360,  1,  1, { 23793, 22457, }, { 4, 4, }, nil, nil, { 29675, }, },
	[32490]  = { nil, 1,  3,  32490,  25685, 340, 350, 360, 370,  1,  1, { 23793, 25707, 22456, 14341, }, { 6, 6, 6, 3, }, nil, nil, { 25732, }, },
	[32501]  = { nil, 1,  3,  32501,  25694, 340, 350, 360, 370,  1,  1, { 23793, 25699, 21885, 22457, 14341, }, { 4, 8, 3, 3, 2, }, nil, nil, { 25741, 29217, }, },
	[32502]  = { nil, 1,  3,  32502,  25692, 340, 350, 360, 370,  1,  1, { 23793, 25699, 21885, 22457, 14341, }, { 8, 12, 5, 5, 2, }, nil, nil, { 25742, 29219, }, },
	[35544]  = { nil, 1,  3,  35544,  29530, 345, 345, 352, 360,  1,  1, { 23793, 29547, }, { 6, 4, }, nil, nil, { 29718, 34172, 34173, }, },
	[351768] = { nil, 1,  3, 351768, 185851, 345, 345, 352, 360,  1,  1, { 23793, 29547, }, { 6, 4, }, nil, nil, { 185923, 187049, }, },
	[35539]  = { nil, 1,  3,  35539,  29531, 350, 350, 357, 365,  1,  1, { 23793, 29548, }, { 6, 4, }, nil, nil, { 29714, 34174, 34175, }, },
	[351769] = { nil, 1,  3, 351769, 185850, 350, 350, 357, 365,  1,  1, { 23793, 29548, }, { 6, 4, }, nil, nil, { 185924, 187048, }, },
	[64661]  = { nil, 1,  3,  64661,  33568, 350, 350, 362, 375,  1,  1, { 33567, }, { 5, }, true, 50000, },
	[44770]  = { nil, 1,  3,  44770,  34207, 350, 355, 360, 365,  1,  1, { 23793, 22452, }, { 4, 3, }, true, 50000, },
	[44970]  = { nil, 1,  3,  44970,  34330, 350, 355, 360, 365,  1,  1, { 23793, }, { 3, }, true, 50000, },
	[32461]  = { nil, 1,  3,  32461,  25653, 350, 360, 370, 380,  1,  1, { 23793, 23571, 22445, 22448, }, { 4, 1, 6, 1, }, nil, nil, { 25725, }, },
	[32485]  = { nil, 1,  3,  32485,  25680, 350, 360, 370, 380,  1,  1, { 23793, 29539, 22456, 4342, 14341, }, { 6, 2, 8, 4, 3, }, nil, nil, { 25728, }, },
	[32487]  = { nil, 1,  3,  32487,  25681, 350, 360, 370, 380,  1,  1, { 23793, 29539, 21886, 2325, 14341, }, { 6, 2, 8, 4, 3, }, nil, nil, { 25729, }, },
	[32488]  = { nil, 1,  3,  32488,  25683, 350, 360, 370, 380,  1,  1, { 23793, 29539, 21884, 2604, 14341, }, { 6, 2, 8, 4, 3, }, nil, nil, { 25731, }, },
	[32489]  = { nil, 1,  3,  32489,  25682, 350, 360, 370, 380,  1,  1, { 23793, 29539, 22452, 14341, }, { 6, 2, 8, 3, }, nil, nil, { 25730, }, },
	[32493]  = { nil, 1,  3,  32493,  25686, 350, 360, 370, 380,  1,  1, { 23793, 25707, 22456, 14341, }, { 10, 8, 8, 3, }, nil, nil, { 25733, }, },
	[32494]  = { nil, 1,  3,  32494,  25687, 350, 360, 370, 380,  1,  1, { 23793, 25707, 22456, 14341, }, { 10, 10, 10, 3, }, nil, nil, { 25734, }, },
	[32498]  = { nil, 1,  3,  32498,  25695, 350, 360, 370, 380,  1,  1, { 23793, 25707, 25699, 22451, 14341, }, { 6, 4, 8, 6, 2, }, nil, nil, { 25738, 29213, }, },
	[32503]  = { nil, 1,  3,  32503,  25693, 350, 360, 370, 380,  1,  1, { 23793, 25699, 21885, 22457, 14341, }, { 6, 10, 4, 4, 2, }, nil, nil, { 25743, 29218, }, },
	[35525]  = { nil, 1,  3,  35525,  29489, 350, 360, 370, 380,  1,  1, { 23793, 25700, 22457, }, { 6, 12, 8, }, nil, nil, { 29677, }, },
	[35526]  = { nil, 1,  3,  35526,  29490, 350, 360, 370, 380,  1,  1, { 23793, 25700, 22457, }, { 4, 10, 6, }, nil, nil, { 29682, }, },
	[35527]  = { nil, 1,  3,  35527,  29491, 350, 360, 370, 380,  1,  1, { 23793, 25700, 22457, }, { 4, 10, 6, }, nil, nil, { 29684, }, },
	[35528]  = { nil, 1,  3,  35528,  29493, 350, 360, 370, 380,  1,  1, { 23793, 25699, 21884, 21885, }, { 4, 8, 3, 3, }, nil, nil, { 29691, }, },
	[35529]  = { nil, 1,  3,  35529,  29492, 350, 360, 370, 380,  1,  1, { 23793, 25699, 21884, 21885, }, { 6, 12, 4, 4, }, nil, nil, { 29689, }, },
	[35531]  = { nil, 1,  3,  35531,  29494, 350, 360, 370, 380,  1,  1, { 23793, 25699, 21884, 21885, }, { 4, 8, 3, 3, }, nil, nil, { 29693, }, },
	[35532]  = { nil, 1,  3,  35532,  29495, 350, 360, 370, 380,  1,  1, { 23793, 25708, 22457, }, { 6, 24, 8, }, nil, nil, { 29698, }, },
	[35533]  = { nil, 1,  3,  35533,  29496, 350, 360, 370, 380,  1,  1, { 23793, 25708, 22457, }, { 4, 16, 6, }, nil, nil, { 29700, }, },
	[35534]  = { nil, 1,  3,  35534,  29497, 350, 360, 370, 380,  1,  1, { 23793, 25708, 22457, }, { 4, 16, 6, }, nil, nil, { 29701, }, },
	[35535]  = { nil, 1,  3,  35535,  29498, 350, 360, 370, 380,  1,  1, { 23793, 25707, 21884, 21885, }, { 6, 10, 4, 4, }, nil, nil, { 29702, }, },
	[35536]  = { nil, 1,  3,  35536,  29499, 350, 360, 370, 380,  1,  1, { 23793, 25707, 21884, 21885, }, { 4, 8, 3, 3, }, nil, nil, { 29703, }, },
	[35537]  = { nil, 1,  3,  35537,  29500, 350, 360, 370, 380,  1,  1, { 23793, 25707, 21884, 21885, }, { 4, 6, 3, 3, }, nil, nil, { 29704, }, },
	[50962]  = { nil, 1,  3,  50962,  38375, 350, 375, 380, 385,  1,  1, { 33568, }, { 4, }, true, 50000, },
	[32496]  = { nil, 1,  3,  32496,  25690, 355, 365, 375, 385,  1,  1, { 23793, 25708, 22452, 14341, }, { 6, 34, 4, 2, }, nil, nil, { 25736, }, },
	[32497]  = { nil, 1,  3,  32497,  25691, 355, 365, 375, 385,  1,  1, { 23793, 25708, 22452, 14341, }, { 4, 20, 4, 2, }, nil, nil, { 25737, }, },
	[44359]  = { nil, 1,  3,  44359,  34105, 360, 360, 370, 380,  1,  1, { 23793, 17056, 22451, 23572, }, { 8, 99, 2, 1, }, },
	[32495]  = { nil, 1,  3,  32495,  25689, 360, 370, 380, 390,  1,  1, { 23793, 25708, 22452, 14341, }, { 6, 40, 4, 2, }, nil, nil, { 25735, }, },
	[32499]  = { nil, 1,  3,  32499,  25697, 360, 370, 380, 390,  1,  1, { 23793, 25707, 25699, 22451, 14341, }, { 6, 6, 6, 4, 2, }, nil, nil, { 25739, 29214, }, },
	[32500]  = { nil, 1,  3,  32500,  25696, 360, 370, 380, 390,  1,  1, { 23793, 25707, 25699, 22451, 14341, }, { 10, 4, 8, 8, 2, }, nil, nil, { 25740, 29215, }, },
	[42546]  = { nil, 1,  3,  42546,  33122, 360, 370, 380, 390,  1,  1, { 23793, 21844, 22456, 23572, }, { 8, 12, 12, 4, }, nil, nil, { 33124, }, },
	[45117]  = { nil, 1,  3,  45117,  34490, 360, 370, 380, 390,  1,  1, { 23793, 29547, 25707, 29548, 25708, 14341, }, { 15, 5, 5, 5, 5, 3, }, nil, nil, { 34491, }, },
	[35543]  = { nil, 1,  3,  35543,  29529, 365, 365, 372, 380,  1,  1, { 23793, 25708, }, { 6, 4, }, nil, nil, { 29717, }, },
	[351771] = { nil, 1,  3, 351771, 185848, 365, 365, 372, 380,  1,  1, { 23793, 25708, }, { 6, 4, }, nil, nil, { 185926, }, },
	[35554]  = { nil, 1,  3,  35554,  29535, 365, 365, 375, 385,  1,  1, { 23793, 29539, 22451, 23572, }, { 4, 4, 8, 1, }, nil, nil, { 29722, 31362, }, },
	[35557]  = { nil, 1,  3,  35557,  29536, 365, 365, 375, 385,  1,  1, { 23793, 25708, 22452, 23572, }, { 4, 16, 8, 1, }, nil, nil, { 29721, }, },
	[35558]  = { nil, 1,  3,  35558,  29502, 365, 375, 385, 395,  1,  1, { 23793, 29539, 22451, 22456, 23572, }, { 6, 10, 15, 15, 1, }, nil, nil, { 29723, }, },
	[35559]  = { nil, 1,  3,  35559,  29503, 365, 375, 385, 395,  1,  1, { 23793, 29539, 22451, 22456, 23572, }, { 4, 8, 12, 12, 1, }, nil, nil, { 29724, 35302, }, },
	[35560]  = { nil, 1,  3,  35560,  29504, 365, 375, 385, 395,  1,  1, { 23793, 29547, 22451, 22457, 23572, }, { 6, 20, 18, 10, 1, }, nil, nil, { 29725, }, },
	[35561]  = { nil, 1,  3,  35561,  29505, 365, 375, 385, 395,  1,  1, { 23793, 21886, 21885, 23572, }, { 6, 20, 8, 1, }, nil, nil, { 29726, }, },
	[35562]  = { nil, 1,  3,  35562,  29506, 365, 375, 385, 395,  1,  1, { 23793, 21886, 22452, 23572, }, { 4, 16, 12, 1, }, nil, nil, { 29727, 35303, }, },
	[35563]  = { nil, 1,  3,  35563,  29507, 365, 375, 385, 395,  1,  1, { 23793, 29547, 22452, 22451, 23572, }, { 4, 12, 18, 8, 1, }, nil, nil, { 29728, }, },
	[35564]  = { nil, 1,  3,  35564,  29508, 365, 375, 385, 395,  1,  1, { 23793, 29548, 21886, 22457, 23572, }, { 6, 28, 12, 12, 1, }, nil, nil, { 29729, }, },
	[35567]  = { nil, 1,  3,  35567,  29512, 365, 375, 385, 395,  1,  1, { 23793, 29548, 22452, 22457, 23572, }, { 4, 24, 22, 4, 1, }, nil, nil, { 29730, }, },
	[35568]  = { nil, 1,  3,  35568,  29509, 365, 375, 385, 395,  1,  1, { 23793, 29547, 22451, 21884, 23572, }, { 4, 14, 14, 10, 1, }, nil, nil, { 29731, 35300, }, },
	[35572]  = { nil, 1,  3,  35572,  29510, 365, 375, 385, 395,  1,  1, { 23793, 29548, 21884, 22457, 23572, }, { 6, 28, 18, 12, 1, }, nil, nil, { 29732, }, },
	[35573]  = { nil, 1,  3,  35573,  29511, 365, 375, 385, 395,  1,  1, { 23793, 29548, 21884, 22457, 23572, }, { 4, 24, 14, 10, 1, }, nil, nil, { 29733, 35301, }, },
	[35574]  = { nil, 1,  3,  35574,  29514, 365, 375, 385, 395,  1,  1, { 23793, 29548, 22452, 22451, 23572, }, { 8, 32, 20, 8, 1, }, nil, nil, { 29734, }, },
	[42731]  = { nil, 1,  3,  42731,  33204, 365, 375, 385, 395,  1,  1, { 23793, 21844, 22452, 22456, 23572, }, { 10, 16, 12, 12, 2, }, nil, nil, { 33205, }, },
	[46132]  = { nil, 1,  3,  46132,  34372, 365, 375, 392, 410,  1,  1, { 23793, 25708, 21886, 23571, 34664, }, { 30, 16, 18, 8, 6, }, nil, nil, { 35212, 35546, }, },
	[46133]  = { nil, 1,  3,  46133,  34374, 365, 375, 392, 410,  1,  1, { 23793, 29547, 22451, 23571, 34664, }, { 30, 16, 18, 8, 6, }, nil, nil, { 35213, 35541, }, },
	[46134]  = { nil, 1,  3,  46134,  34370, 365, 375, 392, 410,  1,  1, { 23793, 25707, 22456, 23571, 34664, }, { 30, 16, 18, 8, 6, }, nil, nil, { 35214, 35542, }, },
	[46135]  = { nil, 1,  3,  46135,  34376, 365, 375, 392, 410,  1,  1, { 23793, 29548, 21886, 23571, 34664, }, { 30, 16, 18, 8, 6, }, nil, nil, { 35215, 35550, }, },
	[46136]  = { nil, 1,  3,  46136,  34371, 365, 375, 392, 410,  1,  1, { 23793, 25708, 23571, 23572, }, { 40, 24, 6, 6, }, nil, nil, { 35216, 35545, }, },
	[46137]  = { nil, 1,  3,  46137,  34373, 365, 375, 392, 410,  1,  1, { 23793, 29547, 23571, 23572, }, { 40, 24, 6, 6, }, nil, nil, { 35217, 35540, }, },
	[46138]  = { nil, 1,  3,  46138,  34369, 365, 375, 392, 410,  1,  1, { 23793, 25707, 23571, 23572, }, { 40, 24, 6, 6, }, nil, nil, { 35218, 35539, }, },
	[46139]  = { nil, 1,  3,  46139,  34375, 365, 375, 392, 410,  1,  1, { 23793, 29548, 23571, 23572, }, { 40, 24, 6, 6, }, nil, nil, { 35219, 35549, }, },
	[35538]  = { nil, 1,  3,  35538,  29532, 370, 370, 377, 385,  1,  1, { 23793, 25707, }, { 6, 4, }, nil, nil, { 29713, }, },
	[351770] = { nil, 1,  3, 351770, 185849, 370, 370, 377, 385,  1,  1, { 23793, 25707, }, { 6, 4, }, nil, nil, { 185925, }, },
	[50939]  = { nil, 1,  3,  50939,  38410, 370, 385, 395, 405,  1,  1, { 33568, }, { 12, }, true, 30000, },
	[50941]  = { nil, 1,  3,  50941,  38409, 370, 385, 395, 405,  1,  1, { 33568, }, { 8, }, true, 30000, },
	[50944]  = { nil, 1,  3,  50944,  38400, 370, 385, 395, 405,  1,  1, { 33568, }, { 12, }, true, 30000, },
	[50948]  = { nil, 1,  3,  50948,  38404, 370, 385, 395, 405,  1,  1, { 33568, }, { 8, }, true, 30000, },
	[50951]  = { nil, 1,  3,  50951,  38416, 370, 385, 395, 405,  1,  1, { 33568, }, { 12, }, true, 30000, },
	[50955]  = { nil, 1,  3,  50955,  38412, 370, 385, 395, 405,  1,  1, { 33568, }, { 8, }, true, 30000, },
	[50957]  = { nil, 1,  3,  50957,  38422, 370, 385, 395, 405,  1,  1, { 33568, }, { 8, }, true, 30000, },
	[50959]  = { nil, 1,  3,  50959,  38421, 370, 385, 395, 405,  1,  1, { 33568, }, { 12, }, true, 30000, },
	[351766] = { nil, 1,  3, 351766, 185852, 375, 375, 375, 375,  1,  1, { 23793, 25700, }, { 3, 3, }, nil, nil, { 185922, }, },
	[35575]  = { nil, 1,  3,  35575,  29515, 375, 385, 395, 405,  1,  1, { 23793, 29548, 21884, 22456, 23572, }, { 8, 30, 16, 16, 2, }, },
	[35576]  = { nil, 1,  3,  35576,  29516, 375, 385, 395, 405,  1,  1, { 23793, 29548, 21884, 22456, 23572, }, { 6, 24, 12, 12, 1, }, },
	[35577]  = { nil, 1,  3,  35577,  29517, 375, 385, 395, 405,  1,  1, { 23793, 29548, 21884, 22456, }, { 4, 18, 8, 8, }, },
	[35580]  = { nil, 1,  3,  35580,  29519, 375, 385, 395, 405,  1,  1, { 23793, 29548, 22457, 22451, 23572, }, { 8, 30, 16, 16, 2, }, },
	[35582]  = { nil, 1,  3,  35582,  29520, 375, 385, 395, 405,  1,  1, { 23793, 29548, 22457, 22451, 23572, }, { 6, 24, 12, 12, 1, }, },
	[35584]  = { nil, 1,  3,  35584,  29521, 375, 385, 395, 405,  1,  1, { 23793, 29548, 22457, 22451, }, { 4, 18, 8, 8, }, },
	[35585]  = { nil, 1,  3,  35585,  29522, 375, 385, 395, 405,  1,  1, { 23793, 29547, 22451, 23571, 23572, }, { 8, 20, 16, 3, 2, }, },
	[35587]  = { nil, 1,  3,  35587,  29524, 375, 385, 395, 405,  1,  1, { 23793, 29547, 22451, 23571, 23572, }, { 6, 16, 12, 2, 1, }, },
	[35588]  = { nil, 1,  3,  35588,  29523, 375, 385, 395, 405,  1,  1, { 23793, 29547, 22451, 23571, }, { 4, 12, 8, 1, }, },
	[35589]  = { nil, 1,  3,  35589,  29525, 375, 385, 395, 405,  1,  1, { 23793, 23571, 23572, }, { 8, 6, 2, }, },
	[35590]  = { nil, 1,  3,  35590,  29526, 375, 385, 395, 405,  1,  1, { 23793, 23571, 23572, }, { 6, 5, 1, }, },
	[35591]  = { nil, 1,  3,  35591,  29527, 375, 385, 395, 405,  1,  1, { 23793, 23571, }, { 4, 3, }, },
	[36349]  = { nil, 1,  3,  36349,  30042, 375, 385, 395, 405,  1,  1, { 30183, 23793, 21886, 14341, 22451, }, { 2, 4, 10, 2, 10, }, nil, nil, { 30301, }, },
	[36351]  = { nil, 1,  3,  36351,  30040, 375, 385, 395, 405,  1,  1, { 30183, 23793, 22456, 14341, 22451, }, { 2, 4, 10, 2, 10, }, nil, nil, { 30302, }, },
	[36352]  = { nil, 1,  3,  36352,  30046, 375, 385, 395, 405,  1,  1, { 30183, 23793, 22451, 29547, 14341, }, { 2, 4, 10, 10, 2, }, nil, nil, { 30303, }, },
	[36353]  = { nil, 1,  3,  36353,  30044, 375, 385, 395, 405,  1,  1, { 30183, 23793, 21885, 29547, 14341, }, { 2, 4, 10, 6, 2, }, nil, nil, { 30304, }, },
	[36355]  = { nil, 1,  3,  36355,  30041, 375, 385, 395, 405,  1,  1, { 23572, 23793, 21886, 14341, }, { 2, 4, 12, 2, }, nil, nil, { 30305, }, },
	[36357]  = { nil, 1,  3,  36357,  30039, 375, 385, 395, 405,  1,  1, { 23572, 23793, 22456, 14341, }, { 2, 4, 12, 2, }, nil, nil, { 30306, }, },
	[36358]  = { nil, 1,  3,  36358,  30045, 375, 385, 395, 405,  1,  1, { 23572, 23793, 22451, 29547, 14341, }, { 2, 4, 10, 6, 2, }, nil, nil, { 30307, }, },
	[36359]  = { nil, 1,  3,  36359,  30043, 375, 385, 395, 405,  1,  1, { 23572, 23793, 21885, 29547, 14341, }, { 2, 4, 10, 6, 2, }, nil, nil, { 30308, }, },
	[39997]  = { nil, 1,  3,  39997,  32398, 375, 385, 395, 405,  1,  1, { 32428, 22450, 21886, 22456, 25700, }, { 2, 1, 2, 4, 4, }, nil, nil, { 32429, }, },
	[40001]  = { nil, 1,  3,  40001,  32400, 375, 385, 395, 405,  1,  1, { 32428, 22450, 21886, 22456, 25700, }, { 3, 1, 4, 6, 3, }, nil, nil, { 32431, }, },
	[40002]  = { nil, 1,  3,  40002,  32397, 375, 385, 395, 405,  1,  1, { 32428, 22450, 21886, 22456, 25700, }, { 2, 1, 3, 4, 2, }, nil, nil, { 32432, }, },
	[40003]  = { nil, 1,  3,  40003,  32394, 375, 385, 395, 405,  1,  1, { 32428, 22450, 21886, 22456, 25707, }, { 2, 1, 2, 4, 4, }, nil, nil, { 32433, }, },
	[40004]  = { nil, 1,  3,  40004,  32395, 375, 385, 395, 405,  1,  1, { 32428, 22450, 21886, 22456, 25707, }, { 1, 1, 2, 2, 2, }, nil, nil, { 32434, }, },
	[40005]  = { nil, 1,  3,  40005,  32396, 375, 385, 395, 405,  1,  1, { 32428, 22450, 21886, 22456, 25707, }, { 3, 1, 4, 6, 3, }, nil, nil, { 32435, }, },
	[40006]  = { nil, 1,  3,  40006,  32393, 375, 385, 395, 405,  1,  1, { 32428, 22450, 21886, 22456, 25707, }, { 2, 1, 3, 4, 2, }, nil, nil, { 32436, }, },
	[41156]  = { nil, 1,  3,  41156,  32582, 375, 385, 395, 405,  1,  1, { 23793, 22451, 21886, 32428, }, { 4, 6, 6, 4, }, nil, nil, { 32744, 35519, }, },
	[41157]  = { nil, 1,  3,  41157,  32583, 375, 385, 395, 405,  1,  1, { 23793, 22451, 21886, 32428, }, { 6, 8, 8, 2, }, nil, nil, { 32745, 35523, }, },
	[41158]  = { nil, 1,  3,  41158,  32580, 375, 385, 395, 405,  1,  1, { 23793, 22451, 32428, }, { 4, 10, 4, }, nil, nil, { 32746, 35527, }, },
	[41160]  = { nil, 1,  3,  41160,  32581, 375, 385, 395, 405,  1,  1, { 23793, 22451, 32428, }, { 6, 12, 2, }, nil, nil, { 32747, 35528, }, },
	[41161]  = { nil, 1,  3,  41161,  32574, 375, 385, 395, 405,  1,  1, { 23793, 22451, 21885, 29547, 32428, }, { 4, 4, 4, 12, 4, }, nil, nil, { 32748, 35517, }, },
	[41162]  = { nil, 1,  3,  41162,  32575, 375, 385, 395, 405,  1,  1, { 23793, 22451, 21885, 29547, 32428, }, { 6, 6, 6, 16, 2, }, nil, nil, { 32749, 35524, }, },
	[41163]  = { nil, 1,  3,  41163,  32577, 375, 385, 395, 405,  1,  1, { 23793, 22451, 22452, 29547, 32428, }, { 4, 4, 4, 12, 4, }, nil, nil, { 32750, 35520, }, },
	[41164]  = { nil, 1,  3,  41164,  32579, 375, 385, 395, 405,  1,  1, { 23793, 22451, 22452, 29547, 32428, }, { 6, 6, 6, 16, 2, }, nil, nil, { 32751, 35521, }, },
	[52733]  = { nil, 1,  3,  52733,  32399, 375, 385, 395, 405,  1,  1, { 32428, 22450, 21886, 22456, 25700, }, { 1, 1, 2, 2, 2, }, nil, nil, { 32430, }, },
	[50938]  = { nil, 1,  3,  50938,  38408, 375, 390, 400, 410,  1,  1, { 33568, }, { 12, }, true, 30000, },
	[50942]  = { nil, 1,  3,  50942,  38407, 375, 390, 400, 410,  1,  1, { 33568, }, { 10, }, true, 30000, },
	[50945]  = { nil, 1,  3,  50945,  38401, 375, 390, 400, 410,  1,  1, { 33568, }, { 12, }, true, 30000, },
	[50947]  = { nil, 1,  3,  50947,  38403, 375, 390, 400, 410,  1,  1, { 33568, }, { 10, }, true, 30000, },
	[50950]  = { nil, 1,  3,  50950,  38414, 375, 390, 400, 410,  1,  1, { 33568, }, { 12, }, true, 30000, },
	[50952]  = { nil, 1,  3,  50952,  38424, 375, 390, 400, 410,  1,  1, { 33568, }, { 10, }, true, 30000, },
	[50956]  = { nil, 1,  3,  50956,  38420, 375, 390, 400, 410,  1,  1, { 33568, }, { 12, }, true, 30000, },
	[50961]  = { nil, 1,  3,  50961,  38418, 375, 390, 400, 410,  1,  1, { 33568, }, { 10, }, true, 30000, },
	[50943]  = { nil, 1,  3,  50943,  38406, 380, 380, 387, 395,  1,  1, { 33568, }, { 10, }, true, 30000, },
	[60631]  = { nil, 1,  3,  60631,  38441, 380, 390, 400, 410,  1,  1, { 33568, 37700, }, { 16, 4, }, true, 80000, },
	[50940]  = { nil, 1,  3,  50940,  38411, 380, 395, 405, 415,  1,  1, { 33568, }, { 10, }, true, 30000, },
	[50946]  = { nil, 1,  3,  50946,  38402, 380, 395, 405, 415,  1,  1, { 33568, }, { 10, }, true, 30000, },
	[50949]  = { nil, 1,  3,  50949,  38405, 380, 395, 405, 415,  1,  1, { 33568, }, { 10, }, true, 30000, },
	[50953]  = { nil, 1,  3,  50953,  38415, 380, 395, 405, 415,  1,  1, { 33568, }, { 10, }, true, 30000, },
	[50954]  = { nil, 1,  3,  50954,  38413, 380, 395, 405, 415,  1,  1, { 33568, }, { 10, }, true, 30000, },
	[50958]  = { nil, 1,  3,  50958,  38417, 380, 395, 405, 415,  1,  1, { 33568, }, { 10, }, true, 30000, },
	[50960]  = { nil, 1,  3,  50960,  38419, 380, 395, 405, 415,  1,  1, { 33568, }, { 10, }, true, 30000, },
	[51571]  = { nil, 1,  3,  51571,  38433, 385, 400, 410, 420,  1,  1, { 33568, }, { 12, }, true, 30000, },
	[51572]  = { nil, 1,  3,  51572,  38437, 385, 400, 410, 420,  1,  1, { 33568, }, { 14, }, true, 30000, },
	[60599]  = { nil, 1,  3,  60599,  38436, 385, 400, 410, 420,  1,  1, { 33568, }, { 12, }, true, 30000, },
	[60600]  = { nil, 1,  3,  60600,  38440, 385, 400, 410, 420,  1,  1, { 33568, }, { 14, }, true, 30000, },
	[60607]  = { nil, 1,  3,  60607,  38434, 385, 400, 410, 420,  1,  1, { 33568, }, { 12, }, true, 30000, },
	[60608]  = { nil, 1,  3,  60608,  38438, 385, 400, 410, 420,  1,  1, { 33568, }, { 14, }, true, 30000, },
	[60622]  = { nil, 1,  3,  60622,  38435, 385, 400, 410, 420,  1,  1, { 33568, }, { 12, }, true, 30000, },
	[60624]  = { nil, 1,  3,  60624,  38439, 385, 400, 410, 420,  1,  1, { 33568, }, { 14, }, true, 30000, },
	[50936]  = { nil, 1,  3,  50936,  38425, 390, 390, 395, 405,  1,  1, { 33568, }, { 6, }, true, 80000, },
	[50963]  = { nil, 1,  3,  50963,  38376, 395, 400, 402, 405,  1,  1, { 38425, }, { 4, }, true, 80000, },
	[55199]  = { nil, 1,  3,  55199,  41238, 395, 405, 415, 425,  1,  1, { 38425, 37700, 37705, }, { 6, 5, 5, }, true, 80000, },
	[51569]  = { nil, 1,  3,  51569,  38591, 395, 410, 420, 430,  1,  1, { 38425, 37703, }, { 6, 4, }, true, 80000, },
	[51570]  = { nil, 1,  3,  51570,  38592, 395, 410, 420, 430,  1,  1, { 38425, 37703, }, { 5, 5, }, true, 80000, },
	[60601]  = { nil, 1,  3,  60601,  44436, 395, 410, 420, 430,  1,  1, { 38425, 37705, }, { 4, 5, }, true, 80000, },
	[60604]  = { nil, 1,  3,  60604,  44437, 395, 410, 420, 430,  1,  1, { 38425, 37705, }, { 6, 4, }, true, 80000, },
	[60611]  = { nil, 1,  3,  60611,  44440, 395, 410, 420, 430,  1,  1, { 38425, 37703, }, { 4, 5, }, true, 80000, },
	[60613]  = { nil, 1,  3,  60613,  44441, 395, 410, 420, 430,  1,  1, { 38425, 37703, }, { 6, 4, }, true, 80000, },
	[60627]  = { nil, 1,  3,  60627,  44443, 395, 410, 420, 430,  1,  1, { 38425, 37705, }, { 4, 5, }, true, 80000, },
	[60629]  = { nil, 1,  3,  60629,  44444, 395, 410, 420, 430,  1,  1, { 38425, 37705, }, { 6, 4, }, true, 80000, },
	[60584]  = { nil, 1,  3,  60584,    nil, 400, 400, 400, 405,  0,  0, { 38558, }, { 2, }, true, 50000, },
	[50966]  = { nil, 1,  3,  50966,  38372, 400, 405, 410, 415,  1,  1, { 38425, 38558, }, { 4, 1, }, true, 50000, },
	[51568]  = { nil, 1,  3,  51568,  38590, 400, 415, 425, 435,  1,  1, { 38558, 37705, }, { 25, 6, }, true, 100000, },
	[60605]  = { nil, 1,  3,  60605,  44438, 400, 415, 425, 435,  1,  1, { 38557, }, { 35, }, true, 100000, },
	[60620]  = { nil, 1,  3,  60620,  44442, 400, 415, 425, 435,  1,  1, { 38558, }, { 35, }, true, 100000, },
	[60630]  = { nil, 1,  3,  60630,  44445, 400, 415, 425, 435,  1,  1, { 38557, 37703, }, { 30, 2, }, true, 80000, },
	[57683]  = { nil, 1,  3,  57683,    nil, 400, 425, 430, 435,  0,  0, { 44128, }, { 1, }, true, 70000, { 43097, }, },
	[57690]  = { nil, 1,  3,  57690,    nil, 400, 425, 430, 435,  0,  0, { 44128, }, { 1, }, true, 70000, },
	[57691]  = { nil, 1,  3,  57691,    nil, 400, 425, 430, 435,  0,  0, { 44128, }, { 1, }, true, 70000, },
	[57692]  = { nil, 1,  3,  57692,    nil, 400, 425, 430, 435,  0,  0, { 44128, }, { 1, }, nil, nil, { 44559, }, },
	[57694]  = { nil, 1,  3,  57694,    nil, 400, 425, 430, 435,  0,  0, { 44128, }, { 1, }, nil, nil, { 44560, }, },
	[57696]  = { nil, 1,  3,  57696,    nil, 400, 425, 430, 435,  0,  0, { 44128, }, { 1, }, nil, nil, { 44561, }, },
	[57699]  = { nil, 1,  3,  57699,    nil, 400, 425, 430, 435,  0,  0, { 44128, }, { 1, }, nil, nil, { 44562, }, },
	[57701]  = { nil, 1,  3,  57701,    nil, 400, 425, 430, 435,  0,  0, { 44128, }, { 1, }, nil, nil, { 44563, }, },
	[60583]  = { nil, 1,  3,  60583,    nil, 405, 405, 405, 410,  0,  0, { 38561, }, { 2, }, true, 50000, },
	[50964]  = { nil, 1,  3,  50964,  38371, 405, 410, 415, 420,  1,  1, { 38425, 38561, }, { 3, 12, }, true, 50000, },
	[50970]  = { nil, 1,  3,  50970,  38399, 415, 420, 422, 425,  1,  1, { 38425, }, { 8, }, nil, nil, { 44509, }, },
	[50971]  = { nil, 1,  3,  50971,  38347, 415, 420, 422, 425,  1,  1, { 38425, }, { 8, }, nil, nil, { 44510, }, },
	[60643]  = { nil, 1,  3,  60643,  44446, 415, 420, 422, 425,  1,  1, { 38425, }, { 8, }, true, 50000, },
	[60651]  = { nil, 1,  3,  60651,  43130, 420, 425, 430, 435,  1,  1, { 38425, 36860, }, { 12, 2, }, true, 100000, },
	[60652]  = { nil, 1,  3,  60652,  43131, 420, 425, 430, 435,  1,  1, { 38557, }, { 40, }, true, 100000, },
	[60658]  = { nil, 1,  3,  60658,  43133, 420, 425, 430, 435,  1,  1, { 38425, 35627, }, { 10, 2, }, true, 200000, },
	[60665]  = { nil, 1,  3,  60665,  43255, 420, 425, 430, 435,  1,  1, { 38425, 35622, }, { 10, 2, }, true, 100000, },
	[60666]  = { nil, 1,  3,  60666,  43256, 420, 425, 430, 435,  1,  1, { 38561, }, { 40, }, true, 80000, },
	[60671]  = { nil, 1,  3,  60671,  43258, 420, 425, 430, 435,  1,  1, { 38558, }, { 30, }, true, 100000, },
	[60697]  = { nil, 1,  3,  60697,  43260, 420, 425, 430, 435,  1,  1, { 38425, 35623, }, { 12, 1, }, nil, nil, { 44513, }, },
	[60702]  = { nil, 1,  3,  60702,  43433, 420, 425, 430, 435,  1,  1, { 38425, 35623, }, { 10, 1, }, nil, nil, { 44514, }, },
	[60703]  = { nil, 1,  3,  60703,  43434, 420, 425, 430, 435,  1,  1, { 38425, 35623, }, { 12, 1, }, nil, nil, { 44515, }, },
	[60704]  = { nil, 1,  3,  60704,  43435, 420, 425, 430, 435,  1,  1, { 38425, 35623, }, { 8, 1, }, nil, nil, { 44516, }, },
	[60715]  = { nil, 1,  3,  60715,  43261, 420, 425, 430, 435,  1,  1, { 38425, 35622, }, { 12, 1, }, nil, nil, { 44521, }, },
	[60716]  = { nil, 1,  3,  60716,  43262, 420, 425, 430, 435,  1,  1, { 38425, 35622, }, { 10, 1, }, nil, nil, { 44522, }, },
	[60718]  = { nil, 1,  3,  60718,  43263, 420, 425, 430, 435,  1,  1, { 38425, 35622, }, { 12, 1, }, nil, nil, { 44523, }, },
	[60720]  = { nil, 1,  3,  60720,  43264, 420, 425, 430, 435,  1,  1, { 38425, 35622, }, { 8, 1, }, nil, nil, { 44524, }, },
	[60728]  = { nil, 1,  3,  60728,  43447, 420, 425, 430, 435,  1,  1, { 38425, 35623, }, { 12, 1, }, nil, nil, { 44530, }, },
	[60729]  = { nil, 1,  3,  60729,  43449, 420, 425, 430, 435,  1,  1, { 38425, 35623, }, { 10, 1, }, nil, nil, { 44531, }, },
	[60730]  = { nil, 1,  3,  60730,  43445, 420, 425, 430, 435,  1,  1, { 38425, 35623, }, { 12, 1, }, nil, nil, { 44532, }, },
	[60731]  = { nil, 1,  3,  60731,  43444, 420, 425, 430, 435,  1,  1, { 38425, 35623, }, { 8, 1, }, nil, nil, { 44533, }, },
	[60743]  = { nil, 1,  3,  60743,  43455, 420, 425, 430, 435,  1,  1, { 38425, 35622, }, { 12, 1, }, nil, nil, { 44538, }, },
	[60746]  = { nil, 1,  3,  60746,  43457, 420, 425, 430, 435,  1,  1, { 38425, 35622, }, { 10, 1, }, nil, nil, { 44539, }, },
	[60747]  = { nil, 1,  3,  60747,  43453, 420, 425, 430, 435,  1,  1, { 38425, 35622, }, { 12, 1, }, nil, nil, { 44540, }, },
	[60748]  = { nil, 1,  3,  60748,  43452, 420, 425, 430, 435,  1,  1, { 38425, 35622, }, { 8, 1, }, nil, nil, { 44541, }, },
	[60997]  = { nil, 1,  3,  60997,  43591, 420, 430, 440, 450,  1,  1, { 38425, 36860, 35622, 38558, 43102, }, { 8, 2, 2, 4, 1, }, nil, nil, { 44585, }, },
	[60998]  = { nil, 1,  3,  60998,  43592, 420, 430, 440, 450,  1,  1, { 38425, 36860, 35622, 38558, 43102, }, { 8, 2, 2, 4, 1, }, nil, nil, { 44586, }, },
	[61000]  = { nil, 1,  3,  61000,  43594, 420, 430, 440, 450,  1,  1, { 38425, 36860, 35622, 38557, 43102, }, { 8, 2, 2, 4, 1, }, nil, nil, { 44588, }, },
	[61002]  = { nil, 1,  3,  61002,  43595, 420, 430, 440, 450,  1,  1, { 38425, 36860, 35622, 38557, 43102, }, { 8, 2, 2, 4, 1, }, nil, nil, { 44589, }, },
	[60649]  = { nil, 1,  3,  60649,  43129, 425, 430, 435, 440,  1,  1, { 38425, 35623, }, { 15, 1, }, true, 100000, },
	[60655]  = { nil, 1,  3,  60655,  43132, 425, 430, 435, 440,  1,  1, { 38425, 35627, }, { 14, 2, }, true, 200000, },
	[60660]  = { nil, 1,  3,  60660,  42731, 425, 430, 435, 440,  1,  1, { 38425, 35623, }, { 12, 2, }, true, 100000, },
	[60669]  = { nil, 1,  3,  60669,  43257, 425, 430, 435, 440,  1,  1, { 38425, }, { 25, }, true, 100000, },
	[60705]  = { nil, 1,  3,  60705,  43436, 425, 430, 435, 440,  1,  1, { 38425, 35623, }, { 10, 1, }, nil, nil, { 44517, }, },
	[60706]  = { nil, 1,  3,  60706,  43437, 425, 430, 435, 440,  1,  1, { 38425, 35623, }, { 10, 1, }, nil, nil, { 44518, }, },
	[60711]  = { nil, 1,  3,  60711,  43438, 425, 430, 435, 440,  1,  1, { 38425, 35623, }, { 12, 1, }, nil, nil, { 44519, }, },
	[60712]  = { nil, 1,  3,  60712,  43439, 425, 430, 435, 440,  1,  1, { 38425, 35623, }, { 10, 1, }, nil, nil, { 44520, }, },
	[60721]  = { nil, 1,  3,  60721,  43265, 425, 430, 435, 440,  1,  1, { 38425, 35622, }, { 10, 1, }, nil, nil, { 44525, }, },
	[60723]  = { nil, 1,  3,  60723,  43266, 425, 430, 435, 440,  1,  1, { 38425, 35622, }, { 10, 1, }, nil, nil, { 44526, }, },
	[60725]  = { nil, 1,  3,  60725,  43271, 425, 430, 435, 440,  1,  1, { 38425, 35622, }, { 12, 1, }, nil, nil, { 44527, }, },
	[60727]  = { nil, 1,  3,  60727,  43273, 425, 430, 435, 440,  1,  1, { 38425, 35622, }, { 10, 1, }, nil, nil, { 44528, }, },
	[60732]  = { nil, 1,  3,  60732,  43446, 425, 430, 435, 440,  1,  1, { 38425, 35623, }, { 10, 1, }, nil, nil, { 44534, }, },
	[60734]  = { nil, 1,  3,  60734,  43442, 425, 430, 435, 440,  1,  1, { 38425, 35623, }, { 10, 1, }, nil, nil, { 44535, }, },
	[60735]  = { nil, 1,  3,  60735,  43448, 425, 430, 435, 440,  1,  1, { 38425, 35623, }, { 12, 1, }, nil, nil, { 44536, }, },
	[60737]  = { nil, 1,  3,  60737,  43443, 425, 430, 435, 440,  1,  1, { 38425, 35623, }, { 10, 1, }, nil, nil, { 44537, }, },
	[60749]  = { nil, 1,  3,  60749,  43454, 425, 430, 435, 440,  1,  1, { 38425, 35622, }, { 10, 1, }, nil, nil, { 44542, }, },
	[60750]  = { nil, 1,  3,  60750,  43450, 425, 430, 435, 440,  1,  1, { 38425, 35622, }, { 10, 1, }, nil, nil, { 44543, }, },
	[60751]  = { nil, 1,  3,  60751,  43456, 425, 430, 435, 440,  1,  1, { 38425, 35622, }, { 12, 1, }, nil, nil, { 44544, }, },
	[60752]  = { nil, 1,  3,  60752,  43451, 425, 430, 435, 440,  1,  1, { 38425, 35622, }, { 10, 1, }, nil, nil, { 44545, }, },
	[50965]  = { nil, 1,  3,  50965,  38373, 425, 435, 440, 445,  1,  1, { 44128, 38558, 43102, }, { 2, 2, 1, }, true, 80000, },
	[50967]  = { nil, 1,  3,  50967,  38374, 425, 435, 440, 445,  1,  1, { 44128, 38557, 43102, }, { 2, 2, 1, }, true, 80000, },
	[62448]  = { nil, 1,  3,  62448,  44963, 425, 435, 440, 445,  1,  1, { 44128, 35624, 43102, }, { 2, 4, 1, }, true, 80000, },
	[84950]  = { nil, 1,  3,  84950,  52976, 425, 435, 442, 450,  1,  1, { 52977, }, { 5, }, true, 75000, },
	[60996]  = { nil, 1,  3,  60996,  43590, 425, 435, 445, 455,  1,  1, { 38425, 36860, 35622, 38558, 43102, }, { 10, 3, 3, 8, 1, }, nil, nil, { 44584, }, },
	[60999]  = { nil, 1,  3,  60999,  43593, 425, 435, 445, 455,  1,  1, { 38425, 36860, 35622, 38557, 43102, }, { 10, 3, 3, 8, 1, }, nil, nil, { 44587, }, },
	[78379]  = { nil, 1,  3,  78379,  56477, 425, 450, 452, 455,  1,  1, { 52976, }, { 5, }, true, 75000, },
	[74493]  = { nil, 1,  3,  74493,  52976, 435, 435, 442, 450,  1,  1, { 52977, }, { 4, }, },
	[60637]  = { nil, 1,  3,  60637,  43566, 440, 450, 455, 460,  1,  1, { 44128, 36860, 35627, 43102, }, { 2, 6, 4, 1, }, true, 200000, },
	[60640]  = { nil, 1,  3,  60640,  43565, 440, 450, 455, 460,  1,  1, { 44128, 38558, 43102, }, { 2, 40, 1, }, true, 200000, },
	[60754]  = { nil, 1,  3,  60754,  43458, 440, 450, 455, 460,  1,  1, { 38425, 35622, 35623, 43102, }, { 12, 6, 6, 1, }, nil, nil, { 44546, }, },
	[60755]  = { nil, 1,  3,  60755,  43459, 440, 450, 455, 460,  1,  1, { 38425, 35622, 35623, 43102, }, { 10, 5, 5, 1, }, nil, nil, { 44547, }, },
	[60756]  = { nil, 1,  3,  60756,  43461, 440, 450, 455, 460,  1,  1, { 38425, 35622, 43102, }, { 12, 12, 1, }, nil, nil, { 44548, }, },
	[60757]  = { nil, 1,  3,  60757,  43469, 440, 450, 455, 460,  1,  1, { 38425, 35622, 43102, }, { 10, 10, 1, }, nil, nil, { 44549, }, },
	[60758]  = { nil, 1,  3,  60758,  43481, 440, 450, 455, 460,  1,  1, { 38425, 36860, 35627, 43102, }, { 10, 6, 6, 1, }, nil, nil, { 44550, }, },
	[60759]  = { nil, 1,  3,  60759,  43484, 440, 450, 455, 460,  1,  1, { 38425, 36860, 35627, 43102, }, { 10, 5, 5, 1, }, nil, nil, { 44551, }, },
	[60760]  = { nil, 1,  3,  60760,  43495, 440, 450, 455, 460,  1,  1, { 38425, 35625, 35622, 43102, }, { 12, 6, 6, 1, }, nil, nil, { 44552, }, },
	[60761]  = { nil, 1,  3,  60761,  43502, 440, 450, 455, 460,  1,  1, { 38425, 35625, 35622, 43102, }, { 10, 5, 5, 1, }, nil, nil, { 44553, }, },
	[62176]  = { nil, 1,  3,  62176,  44930, 440, 450, 455, 460,  1,  1, { 38425, 35623, 35622, 43102, }, { 10, 5, 5, 1, }, nil, nil, { 44932, }, },
	[62177]  = { nil, 1,  3,  62177,  44931, 440, 450, 455, 460,  1,  1, { 38425, 35623, 35622, 43102, }, { 12, 6, 6, 1, }, nil, nil, { 44933, }, },
	[69386]  = { nil, 1,  3,  69386,  49633, 450, 450, 455, 470,  1,  1, { 38425, 38557, }, { 8, 8, }, true, 200000, },
	[69388]  = { nil, 1,  3,  69388,  49634, 450, 450, 455, 470,  1,  1, { 38425, 38561, }, { 8, 8, }, true, 200000, },
	[63194]  = { nil, 1,  3,  63194,  45553, 450, 455, 465, 475,  1,  1, { 44128, 38557, 45087, }, { 3, 20, 6, }, nil, nil, { 45094, }, },
	[63195]  = { nil, 1,  3,  63195,  45562, 450, 455, 465, 475,  1,  1, { 44128, 38561, 45087, }, { 3, 20, 6, }, nil, nil, { 45095, }, },
	[63196]  = { nil, 1,  3,  63196,  45554, 450, 455, 465, 475,  1,  1, { 44128, 38558, 45087, }, { 3, 20, 6, }, nil, nil, { 45096, }, },
	[63197]  = { nil, 1,  3,  63197,  45563, 450, 455, 465, 475,  1,  1, { 44128, 38557, 45087, }, { 3, 20, 6, }, nil, nil, { 45097, }, },
	[63198]  = { nil, 1,  3,  63198,  45555, 450, 455, 465, 475,  1,  1, { 44128, 35627, 45087, }, { 3, 4, 6, }, nil, nil, { 45098, }, },
	[63199]  = { nil, 1,  3,  63199,  45564, 450, 455, 465, 475,  1,  1, { 44128, 35627, 45087, }, { 3, 2, 6, }, nil, nil, { 45099, }, },
	[63200]  = { nil, 1,  3,  63200,  45556, 450, 455, 465, 475,  1,  1, { 38425, 44128, 45087, }, { 4, 3, 6, }, nil, nil, { 45100, }, },
	[63201]  = { nil, 1,  3,  63201,  45565, 450, 455, 465, 475,  1,  1, { 44128, 38557, 45087, }, { 3, 20, 6, }, nil, nil, { 45101, }, },
	[78398]  = { nil, 1,  3,  78398,  56483, 450, 460, 465, 470,  1,  1, { 52976, 38426, }, { 7, 1, }, true, 75000, { 66999, }, },
	[78410]  = { nil, 1,  3,  78410,  56494, 450, 460, 465, 470,  1,  1, { 52976, 38426, }, { 7, 1, }, true, 75000, { 67010, }, },
	[67080]  = { nil, 1,  3,  67080,  47597, 450, 460, 467, 475,  1,  1, { 38558, 35623, 34055, 44128, 47556, }, { 40, 8, 8, 8, 8, }, nil, nil, { 47628, }, },
	[67081]  = { nil, 1,  3,  67081,  47579, 450, 460, 467, 475,  1,  1, { 38558, 34057, 44128, 47556, }, { 40, 4, 6, 4, }, nil, nil, { 47629, }, },
	[67082]  = { nil, 1,  3,  67082,  47595, 450, 460, 467, 475,  1,  1, { 38557, 35622, 35625, 44128, 47556, }, { 40, 8, 8, 8, 8, }, nil, nil, { 47630, }, },
	[67083]  = { nil, 1,  3,  67083,  47576, 450, 460, 467, 475,  1,  1, { 38557, 35622, 44128, 47556, }, { 40, 8, 6, 4, }, nil, nil, { 47631, }, },
	[67084]  = { nil, 1,  3,  67084,  47602, 450, 460, 467, 475,  1,  1, { 38425, 35625, 44128, 47556, }, { 24, 20, 8, 8, }, nil, nil, { 47632, }, },
	[67085]  = { nil, 1,  3,  67085,  47583, 450, 460, 467, 475,  1,  1, { 38425, 35625, 44128, 47556, }, { 20, 12, 6, 4, }, nil, nil, { 47633, }, },
	[67086]  = { nil, 1,  3,  67086,  47599, 450, 460, 467, 475,  1,  1, { 38425, 35627, 44128, 47556, }, { 24, 20, 8, 8, }, nil, nil, { 47634, }, },
	[67087]  = { nil, 1,  3,  67087,  47581, 450, 460, 467, 475,  1,  1, { 38425, 35627, 44128, 47556, }, { 20, 12, 6, 4, }, nil, nil, { 47635, }, },
	[67136]  = { nil, 1,  3,  67136,  47598, 450, 460, 467, 475,  1,  1, { 38558, 35623, 34055, 44128, 47556, }, { 40, 8, 8, 8, 8, }, nil, nil, { 47650, }, },
	[67137]  = { nil, 1,  3,  67137,  47580, 450, 460, 467, 475,  1,  1, { 38558, 34057, 44128, 47556, }, { 40, 4, 6, 4, }, nil, nil, { 47646, }, },
	[67138]  = { nil, 1,  3,  67138,  47596, 450, 460, 467, 475,  1,  1, { 38557, 35622, 35625, 44128, 47556, }, { 40, 8, 8, 8, 8, }, nil, nil, { 47649, }, },
	[67139]  = { nil, 1,  3,  67139,  47582, 450, 460, 467, 475,  1,  1, { 38425, 35627, 44128, 47556, }, { 20, 12, 6, 4, }, nil, nil, { 47647, }, },
	[67140]  = { nil, 1,  3,  67140,  47601, 450, 460, 467, 475,  1,  1, { 38425, 35625, 44128, 47556, }, { 24, 20, 8, 8, }, nil, nil, { 47652, }, },
	[67141]  = { nil, 1,  3,  67141,  47584, 450, 460, 467, 475,  1,  1, { 38425, 35625, 44128, 47556, }, { 20, 12, 6, 4, }, nil, nil, { 47653, }, },
	[67142]  = { nil, 1,  3,  67142,  47600, 450, 460, 467, 475,  1,  1, { 38425, 35627, 44128, 47556, }, { 24, 20, 8, 8, }, nil, nil, { 47651, }, },
	[67143]  = { nil, 1,  3,  67143,  47577, 450, 460, 467, 475,  1,  1, { 38557, 35622, 44128, 47556, }, { 40, 8, 6, 4, }, nil, nil, { 47648, }, },
	[70554]  = { nil, 1,  3,  70554,  49898, 450, 475, 487, 500,  1,  1, { 38561, 44128, 35625, 49908, }, { 20, 8, 16, 8, }, nil, nil, { 49957, }, },
	[70555]  = { nil, 1,  3,  70555,  49894, 450, 475, 487, 500,  1,  1, { 38561, 44128, 35625, 49908, }, { 12, 5, 10, 5, }, nil, nil, { 49958, }, },
	[70556]  = { nil, 1,  3,  70556,  49899, 450, 475, 487, 500,  1,  1, { 38558, 44128, 35627, 49908, }, { 20, 8, 16, 8, }, nil, nil, { 49959, }, },
	[70557]  = { nil, 1,  3,  70557,  49895, 450, 475, 487, 500,  1,  1, { 38558, 44128, 35627, 49908, }, { 12, 8, 10, 5, }, nil, nil, { 49961, }, },
	[70558]  = { nil, 1,  3,  70558,  49900, 450, 475, 487, 500,  1,  1, { 38557, 44128, 35623, 49908, }, { 20, 8, 16, 8, }, nil, nil, { 49962, }, },
	[70559]  = { nil, 1,  3,  70559,  49896, 450, 475, 487, 500,  1,  1, { 38557, 44128, 35623, 49908, }, { 12, 5, 10, 5, }, nil, nil, { 49963, }, },
	[70560]  = { nil, 1,  3,  70560,  49901, 450, 475, 487, 500,  1,  1, { 38557, 44128, 35624, 49908, }, { 20, 8, 16, 8, }, nil, nil, { 49965, }, },
	[70561]  = { nil, 1,  3,  70561,  49897, 450, 475, 487, 500,  1,  1, { 38557, 44128, 35624, 49908, }, { 12, 8, 10, 5, }, nil, nil, { 49966, }, },
	[78415]  = { nil, 1,  3,  78415,  56498, 455, 465, 470, 475,  1,  1, { 52982, }, { 20, }, true, 75000, { 67014, }, },
	[78416]  = { nil, 1,  3,  78416,  56499, 455, 465, 470, 475,  1,  1, { 52976, 38426, }, { 7, 1, }, true, 75000, { 67015, }, },
	[78380]  = { nil, 1,  3,  78380,  56480, 460, 470, 475, 480,  1,  1, { 52976, 38426, }, { 7, 1, }, true, 75000, { 66995, }, },
	[78388]  = { nil, 1,  3,  78388,  56481, 460, 470, 475, 480,  1,  1, { 52976, 38426, }, { 10, 1, }, true, 75000, { 66996, }, },
	[85067]  = { nil, 1,  3,  85067,    nil, 465, 465, 465, 470,  0,  0, { 52979, }, { 2, }, true, 75000, },
	[85068]  = { nil, 1,  3,  85068,    nil, 465, 465, 465, 470,  0,  0, { 52979, }, { 2, }, true, 75000, },
	[101600] = { nil, 1,  3, 101600,    nil, 465, 465, 465, 470,  0,  0, { 52979, }, { 2, }, true, 75000, },
	[78399]  = { nil, 1,  3,  78399,  56484, 465, 475, 480, 485,  1,  1, { 52976, 52325, }, { 20, 8, }, true, 75000, { 67000, }, },
	[78407]  = { nil, 1,  3,  78407,  56491, 465, 475, 480, 485,  1,  1, { 52976, 38426, }, { 10, 1, }, true, 75000, { 67007, }, },
	[78405]  = { nil, 1,  3,  78405,  56489, 470, 475, 480, 485,  1,  1, { 52976, 52982, }, { 2, 8, }, true, 75000, { 67005, }, },
	[78396]  = { nil, 1,  3,  78396,  56482, 470, 480, 485, 490,  1,  1, { 52976, 38426, }, { 12, 1, }, true, 75000, { 66997, }, },
	[78406]  = { nil, 1,  3,  78406,  56490, 475, 485, 490, 495,  1,  1, { 52976, 38426, }, { 12, 1, }, true, 85000, { 67006, }, },
	[78411]  = { nil, 1,  3,  78411,  56495, 475, 485, 490, 495,  1,  1, { 52976, 38426, }, { 12, 1, }, true, 85000, { 67011, }, },
	[78419]  = { nil, 1,  3,  78419,  56502, 475, 485, 490, 495,  1,  1, { 52976, 52325, }, { 6, 4, }, true, 85000, { 67018, }, },
	[78420]  = { nil, 1,  3,  78420,  56503, 480, 490, 495, 500,  1,  1, { 52976, 52326, }, { 6, 4, }, true, 85000, { 67019, }, },
	[78427]  = { nil, 1,  3,  78427,  56508, 480, 490, 495, 500,  1,  1, { 52976, 38426, }, { 12, 1, }, true, 85000, { 67025, }, },
	[78428]  = { nil, 1,  3,  78428,  56509, 480, 490, 495, 500,  1,  1, { 52976, 38426, }, { 12, 1, }, true, 85000, { 67026, }, },
	[78436]  = { nil, 1,  3,  78436,  56516, 485, 485, 487, 490,  1,  1, { 52976, }, { 5, }, true, 85000, { 67036, }, },
	[78437]  = { nil, 1,  3,  78437,  56517, 485, 490, 495, 500,  1,  1, { 56516, }, { 4, }, true, 85000, { 67038, }, },
	[78432]  = { nil, 1,  3,  78432,  56512, 485, 495, 500, 505,  1,  1, { 56516, }, { 5, }, true, 85000, { 67031, }, },
	[78433]  = { nil, 1,  3,  78433,  56513, 485, 495, 500, 505,  1,  1, { 56516, 52327, }, { 4, 12, }, true, 85000, { 67033, }, },
	[78424]  = { nil, 1,  3,  78424,  56505, 490, 505, 507, 510,  1,  1, { 56516, }, { 5, }, true, 85000, { 67021, }, },
	[78423]  = { nil, 1,  3,  78423,  56504, 490, 510, 512, 515,  1,  1, { 52982, }, { 60, }, true, 85000, { 67020, }, },
	[78438]  = { nil, 1,  3,  78438,  56518, 495, 510, 512, 515,  1,  1, { 56516, 52328, 52327, 52325, 52326, }, { 8, 2, 2, 2, 2, }, true, 85000, { 67039, }, },
	[78439]  = { nil, 1,  3,  78439,  56519, 495, 510, 512, 515,  1,  1, { 52979, }, { 60, }, true, 85000, { 67041, }, },
	[85007]  = { nil, 1,  3,  85007,    nil, 500, 500, 500, 505,  0,  0, { 52327, }, { 2, }, true, 100000, },
	[85008]  = { nil, 1,  3,  85008,    nil, 500, 500, 500, 505,  0,  0, { 52328, }, { 2, }, true, 100000, },
	[85009]  = { nil, 1,  3,  85009,    nil, 500, 500, 500, 505,  0,  0, { 52325, }, { 2, }, true, 100000, },
	[85010]  = { nil, 1,  3,  85010,    nil, 500, 500, 500, 505,  0,  0, { 52326, }, { 2, }, true, 100000, },
	[99535]  = { nil, 1,  3,  99535,  75077, 500, 510, 512, 515,  1,  1, { 52980, 52325, }, { 1, 4, }, true, 100000, },
	[99536]  = { nil, 1,  3,  99536,  75076, 500, 510, 512, 515,  1,  1, { 52980, 52327, }, { 1, 4, }, true, 100000, },
	[100586] = { nil, 1,  3, 100586,  70137, 500, 520, 527, 535,  1,  1, { 52980, 52327, }, { 3, 15, }, nil, nil, { 70175, }, },
	[78444]  = { nil, 1,  3,  78444,  75106, 510, 515, 520, 525,  1,  1, { 56516, 52325, }, { 10, 10, }, nil, nil, { 67042, }, },
	[78445]  = { nil, 1,  3,  78445,  75117, 510, 515, 520, 525,  1,  1, { 56516, 52325, }, { 10, 10, }, nil, nil, { 67044, }, },
	[78446]  = { nil, 1,  3,  78446,  75131, 510, 515, 520, 525,  1,  1, { 56516, 52325, }, { 10, 10, }, nil, nil, { 67046, }, },
	[78447]  = { nil, 1,  3,  78447,  75104, 510, 515, 520, 525,  1,  1, { 56516, 52325, }, { 10, 10, }, nil, nil, { 67048, }, },
	[78448]  = { nil, 1,  3,  78448,  75094, 510, 515, 520, 525,  1,  1, { 56516, 52979, 52325, }, { 8, 10, 10, }, nil, nil, { 67049, }, },
	[78449]  = { nil, 1,  3,  78449,  75085, 510, 515, 520, 525,  1,  1, { 56516, 52979, 52325, }, { 8, 10, 10, }, nil, nil, { 67053, }, },
	[78450]  = { nil, 1,  3,  78450,  75114, 510, 515, 520, 525,  1,  1, { 56516, 52979, 52325, }, { 8, 10, 10, }, nil, nil, { 67054, }, },
	[78451]  = { nil, 1,  3,  78451,  75116, 510, 515, 520, 525,  1,  1, { 56516, 52979, 52325, }, { 8, 10, 10, }, nil, nil, { 67055, }, },
	[100583] = { nil, 1,  3, 100583,  70136, 510, 520, 527, 535,  1,  1, { 52980, 61981, }, { 3, 3, }, nil, nil, { 70174, }, },
	[78452]  = { nil, 1,  3,  78452,  75109, 515, 520, 525, 530,  1,  1, { 56516, 52325, }, { 10, 10, }, nil, nil, { 67056, }, },
	[78453]  = { nil, 1,  3,  78453,  75101, 515, 520, 525, 530,  1,  1, { 56516, 52325, }, { 10, 10, }, nil, nil, { 67058, }, },
	[78454]  = { nil, 1,  3,  78454,  75130, 515, 520, 525, 530,  1,  1, { 56516, 52325, }, { 10, 10, }, nil, nil, { 67060, }, },
	[78455]  = { nil, 1,  3,  78455,  75113, 515, 520, 525, 530,  1,  1, { 56516, 52325, }, { 10, 10, }, nil, nil, { 67062, }, },
	[78456]  = { nil, 1,  3,  78456,  75092, 515, 520, 525, 530,  1,  1, { 56516, 52979, 52325, }, { 8, 10, 10, }, nil, nil, { 67063, }, },
	[78457]  = { nil, 1,  3,  78457,  75083, 515, 520, 525, 530,  1,  1, { 56516, 52979, 52325, }, { 8, 10, 10, }, nil, nil, { 67064, }, },
	[78458]  = { nil, 1,  3,  78458,  75110, 515, 520, 525, 530,  1,  1, { 56516, 52979, 52325, }, { 8, 10, 10, }, nil, nil, { 67065, }, },
	[78459]  = { nil, 1,  3,  78459,  75081, 515, 520, 525, 530,  1,  1, { 56516, 52979, 52325, }, { 8, 10, 10, }, nil, nil, { 67066, }, },
	[78464]  = { nil, 1,  3,  78464,  75099, 520, 525, 530, 535,  1,  1, { 56516, 52326, }, { 10, 10, }, nil, nil, { 67074, }, },
	[78467]  = { nil, 1,  3,  78467,  75107, 520, 525, 530, 535,  1,  1, { 56516, 52326, }, { 10, 10, }, nil, nil, { 67075, }, },
	[78468]  = { nil, 1,  3,  78468,  75127, 520, 525, 530, 535,  1,  1, { 56516, 52326, }, { 10, 10, }, nil, nil, { 67076, }, },
	[78469]  = { nil, 1,  3,  78469,  75105, 520, 525, 530, 535,  1,  1, { 56516, 52326, }, { 10, 10, }, nil, nil, { 67077, }, },
	[78470]  = { nil, 1,  3,  78470,  75061, 520, 525, 530, 535,  1,  1, { 56516, 52979, 52326, }, { 8, 10, 10, }, nil, nil, { 67078, }, },
	[78471]  = { nil, 1,  3,  78471,  75097, 520, 525, 530, 535,  1,  1, { 56516, 52979, 52326, }, { 8, 10, 10, }, nil, nil, { 67079, }, },
	[78473]  = { nil, 1,  3,  78473,  75100, 520, 525, 530, 535,  1,  1, { 56516, 52979, 52326, }, { 8, 10, 10, }, nil, nil, { 67080, }, },
	[78474]  = { nil, 1,  3,  78474,  75102, 520, 525, 530, 535,  1,  1, { 56516, 52979, 52326, }, { 8, 10, 10, }, nil, nil, { 67081, }, },
	[78460]  = { nil, 1,  3,  78460,  56536, 525, 525, 525, 530,  1,  1, { 52980, 52326, 52328, 52078, }, { 3, 25, 25, 2, }, nil, nil, { 67068, }, },
	[78461]  = { nil, 1,  3,  78461,  56537, 525, 525, 525, 530,  1,  1, { 52980, 52328, 52078, }, { 3, 30, 2, }, nil, nil, { 67070, }, },
	[78462]  = { nil, 1,  3,  78462,  56538, 525, 525, 525, 530,  1,  1, { 52979, 52980, 52328, 52326, 52078, }, { 10, 3, 25, 25, 2, }, nil, nil, { 67072, }, },
	[78463]  = { nil, 1,  3,  78463,  56539, 525, 525, 525, 530,  1,  1, { 52979, 52327, 52329, 52980, 52078, }, { 10, 25, 25, 3, 2, }, nil, nil, { 67073, }, },
	[99443]  = { nil, 1,  3,  99443,  69939, 525, 525, 527, 530,  1,  1, { 52980, 52325, 52326, 69237, 52078, }, { 8, 40, 40, 4, 3, }, nil, nil, { 69960, }, },
	[99445]  = { nil, 1,  3,  99445,  69941, 525, 525, 527, 530,  1,  1, { 52980, 52325, 52326, 69237, 52078, }, { 8, 40, 40, 4, 3, }, nil, nil, { 69961, }, },
	[99446]  = { nil, 1,  3,  99446,  69942, 525, 525, 527, 530,  1,  1, { 52980, 52325, 52326, 69237, 52078, }, { 8, 40, 40, 4, 3, }, nil, nil, { 69962, }, },
	[99447]  = { nil, 1,  3,  99447,  69943, 525, 525, 527, 530,  1,  1, { 52980, 52325, 52326, 69237, 52078, }, { 8, 40, 40, 4, 3, }, nil, nil, { 69963, }, },
	[99455]  = { nil, 1,  3,  99455,  69949, 525, 525, 527, 530,  1,  1, { 52980, 52325, 52326, 69237, 52078, }, { 8, 40, 40, 4, 3, }, nil, nil, { 69971, }, },
	[99456]  = { nil, 1,  3,  99456,  69950, 525, 525, 527, 530,  1,  1, { 52980, 52325, 52326, 69237, 52078, }, { 8, 40, 40, 4, 3, }, nil, nil, { 69972, }, },
	[99457]  = { nil, 1,  3,  99457,  69951, 525, 525, 527, 530,  1,  1, { 52980, 52325, 52326, 69237, 52078, }, { 8, 40, 40, 4, 3, }, nil, nil, { 69973, }, },
	[99458]  = { nil, 1,  3,  99458,  69952, 525, 525, 527, 530,  1,  1, { 52980, 52325, 52326, 69237, 52078, }, { 8, 40, 40, 4, 3, }, nil, nil, { 69974, }, },
	[101933] = { nil, 1,  3, 101933,  71986, 525, 525, 530, 535,  1,  1, { 52980, 52329, 52078, 71998, }, { 8, 40, 4, 8, }, nil, nil, { 71999, }, },
	[101934] = { nil, 1,  3, 101934,  71988, 525, 525, 530, 535,  1,  1, { 52980, 52979, 52078, 71998, }, { 8, 40, 4, 8, }, nil, nil, { 72005, }, },
	[101935] = { nil, 1,  3, 101935,  71985, 525, 525, 530, 535,  1,  1, { 52980, 52325, 52328, 52078, 71998, }, { 8, 20, 20, 4, 8, }, nil, nil, { 72006, }, },
	[101936] = { nil, 1,  3, 101936,  71987, 525, 525, 530, 535,  1,  1, { 52980, 52979, 52325, 52327, 52078, 71998, }, { 8, 25, 10, 10, 4, 8, }, nil, nil, { 72007, }, },
	[101937] = { nil, 1,  3, 101937,  71995, 525, 525, 530, 535,  1,  1, { 52980, 52329, 52326, 52328, 52078, 71998, }, { 4, 10, 10, 10, 2, 4, }, nil, nil, { 72008, }, },
	[101939] = { nil, 1,  3, 101939,  71997, 525, 525, 530, 535,  1,  1, { 52980, 52979, 52328, 52078, 71998, }, { 4, 20, 30, 2, 4, }, nil, nil, { 72009, }, },
	[101940] = { nil, 1,  3, 101940,  71994, 525, 525, 530, 535,  1,  1, { 52980, 52325, 52328, 52078, 71998, }, { 4, 20, 20, 2, 4, }, nil, nil, { 72010, }, },
	[101941] = { nil, 1,  3, 101941,  71996, 525, 525, 530, 535,  1,  1, { 52980, 52979, 52329, 52078, 71998, }, { 4, 20, 20, 2, 4, }, nil, nil, { 72011, }, },
	[78475]  = { nil, 1,  3,  78475,  56548, 525, 530, 535, 540,  1,  1, { 52325, 52326, 52979, 52078, }, { 12, 12, 12, 1, }, nil, nil, { 67082, }, },
	[78476]  = { nil, 1,  3,  78476,  56549, 525, 530, 535, 540,  1,  1, { 52979, 52078, }, { 50, 1, }, nil, nil, { 67083, }, },
	[78477]  = { nil, 1,  3,  78477,  56550, 525, 530, 535, 540,  1,  1, { 52979, 52980, }, { 20, 1, }, nil, nil, { 68193, }, },
	[78478]  = { nil, 1,  3,  78478,  56551, 525, 530, 535, 540,  1,  1, { 52980, 52325, }, { 1, 20, }, nil, nil, { 67084, }, },
	[78479]  = { nil, 1,  3,  78479,  75080, 525, 530, 535, 540,  1,  1, { 56516, 52329, }, { 10, 10, }, nil, nil, { 67085, }, },
	[78480]  = { nil, 1,  3,  78480,  75111, 525, 530, 535, 540,  1,  1, { 56516, 52329, }, { 10, 10, }, nil, nil, { 67086, }, },
	[78481]  = { nil, 1,  3,  78481,  75103, 525, 530, 535, 540,  1,  1, { 56516, 52329, }, { 10, 10, }, nil, nil, { 67087, }, },
	[78482]  = { nil, 1,  3,  78482,  75112, 525, 530, 535, 540,  1,  1, { 56516, 52329, }, { 10, 10, }, nil, nil, { 67089, }, },
	[78483]  = { nil, 1,  3,  78483,  75084, 525, 530, 535, 540,  1,  1, { 56516, 52979, 52329, }, { 8, 10, 10, }, nil, nil, { 67090, }, },
	[78484]  = { nil, 1,  3,  78484,  75090, 525, 530, 535, 540,  1,  1, { 56516, 52979, 52329, }, { 8, 10, 10, }, nil, nil, { 67091, }, },
	[78485]  = { nil, 1,  3,  78485,  75108, 525, 530, 535, 540,  1,  1, { 56516, 52979, 52329, }, { 8, 10, 10, }, nil, nil, { 67092, }, },
	[78486]  = { nil, 1,  3,  78486,  75115, 525, 530, 535, 540,  1,  1, { 56516, 52979, 52329, }, { 8, 10, 10, }, nil, nil, { 67093, }, },
	[78487]  = { nil, 1,  3,  78487,  56561, 525, 530, 535, 540,  1,  1, { 52980, 52329, 52078, }, { 3, 50, 3, }, nil, nil, { 67094, }, },
	[78488]  = { nil, 1,  3,  78488,  56562, 525, 530, 535, 540,  1,  1, { 52980, 52328, 52325, 52078, }, { 3, 30, 20, 3, }, nil, nil, { 67095, }, },
	[78489]  = { nil, 1,  3,  78489,  56563, 525, 530, 535, 540,  1,  1, { 52979, 52980, 52325, 52328, 52078, }, { 15, 3, 25, 25, 3, }, nil, nil, { 67096, }, },
	[78490]  = { nil, 1,  3,  78490,  56564, 525, 530, 535, 540,  1,  1, { 52979, 52980, 52327, 52078, }, { 10, 3, 50, 3, }, nil, nil, { 67100, }, },
	[101599] = { nil, 1,  3, 101599,  71720, 525, 530, 535, 540,  1,  1, { 52980, 52327, }, { 1, 20, }, nil, nil, { 71721, }, },
	[2329]   = { nil, 1,  4,   2329,   2454,   1,  55,  75,  95,  1,  1, { 2449, 765, 3371, }, { 1, 1, 1, }, },
	[2330]   = { nil, 1,  4,   2330,    118,   1,  55,  75,  95,  1,  1, { 2447, 765, 3371, }, { 1, 1, 1, }, },
	[7183]   = { nil, 1,  4,   7183,   5997,   1,  55,  75,  95,  1,  1, { 765, 3371, }, { 2, 1, }, },
	[3170]   = { nil, 1,  4,   3170,   3382,  15,  60,  80, 100,  1,  1, { 2447, 2449, 3371, }, { 1, 2, 1, }, true, 50, },
	[2331]   = { nil, 1,  4,   2331,   2455,  25,  65,  85, 105,  1,  1, { 785, 765, 3371, }, { 1, 1, 1, }, true, 100, },
	[2332]   = { nil, 1,  4,   2332,   2456,  40,  70,  90, 110,  1,  1, { 785, 2447, 3371, }, { 2, 1, 1, }, true, 150, },
	[2334]   = { nil, 1,  4,   2334,   2458,  50,  80, 100, 120,  1,  1, { 2449, 2447, 3371, }, { 2, 1, 1, }, true, 250, },
	[3230]   = { nil, 1,  4,   3230,   2457,  50,  80, 100, 120,  1,  1, { 2452, 765, 3371, }, { 1, 1, 1, }, nil, nil, { 2553, }, },
	[4508]   = { nil, 1,  4,   4508,   4596,  50,  80, 100, 120,  1,  1, { 3164, 2447, 3371, }, { 1, 1, 1, }, nil, nil, { 4597, }, },
	[2337]   = { nil, 1,  4,   2337,    858,  55,  85, 105, 125,  1,  1, { 118, 2450, }, { 1, 1, }, true, 1000, },
	[2335]   = { nil, 1,  4,   2335,   2459,  60,  90, 110, 130,  1,  1, { 2452, 2450, 3371, }, { 1, 1, 1, }, nil, nil, { 2555, }, },
	[6617]   = { nil, 1,  4,   6617,   5631,  60,  90, 110, 130,  1,  1, { 5635, 3371, }, { 2, 1, }, nil, nil, { 5640, }, },
	[7836]   = { nil, 1,  4,   7836,   6370,  80,  80,  90, 100,  1,  1, { 6358, }, { 2, }, true, 250, },
	[3171]   = { nil, 1,  4,   3171,   3383,  90, 120, 140, 160,  1,  1, { 785, 2450, 3371, }, { 1, 2, 1, }, true, 500, },
	[7179]   = { nil, 1,  4,   7179,   5996,  90, 120, 140, 160,  1,  1, { 3820, 6370, 3371, }, { 1, 2, 1, }, true, 450, },
	[8240]   = { nil, 1,  4,   8240,   6662,  90, 120, 140, 160,  1,  1, { 6522, 2449, 3371, }, { 1, 1, 1, }, nil, nil, { 6663, }, },
	[7255]   = { nil, 1,  4,   7255,   6051, 100, 130, 150, 170,  1,  1, { 2453, 2452, 3371, }, { 1, 1, 1, }, nil, nil, { 6053, }, },
	[7841]   = { nil, 1,  4,   7841,   6372, 100, 130, 150, 170,  1,  1, { 2452, 6370, 3371, }, { 1, 1, 1, }, true, 1000, },
	[3172]   = { nil, 1,  4,   3172,   3384, 110, 135, 155, 175,  1,  1, { 785, 3355, 3371, }, { 3, 1, 1, }, nil, nil, { 3393, }, },
	[3447]   = { nil, 1,  4,   3447,    929, 110, 135, 155, 175,  1,  1, { 2453, 2450, 3371, }, { 1, 1, 1, }, true, 4000, },
	[3173]   = { nil, 1,  4,   3173,   3385, 120, 145, 165, 185,  1,  1, { 785, 3820, 3371, }, { 1, 1, 1, }, true, 1500, },
	[3174]   = { nil, 1,  4,   3174,   3386, 120, 145, 165, 185,  1,  1, { 1288, 2453, 3371, }, { 1, 1, 1, }, nil, nil, { 3394, }, },
	[3176]   = { nil, 1,  4,   3176,   3388, 125, 150, 170, 190,  1,  1, { 2453, 2450, 3371, }, { 2, 2, 1, }, true, 1500, },
	[7837]   = { nil, 1,  4,   7837,   6371, 130, 150, 160, 170,  1,  1, { 6359, }, { 2, }, true, 1000, },
	[3177]   = { nil, 1,  4,   3177,   3389, 130, 155, 175, 195,  1,  1, { 3355, 3820, 3371, }, { 1, 1, 1, }, true, 2000, },
	[7256]   = { nil, 1,  4,   7256,   6048, 135, 160, 180, 200,  1,  1, { 3369, 3356, 3371, }, { 1, 1, 1, }, nil, nil, { 6054, }, },
	[63732]  = { nil, 1,  4,  63732,  45621, 135, 160, 180, 200,  1,  1, { 6371, 2453, 3371, }, { 1, 1, 1, }, true, 2000, },
	[2333]   = { nil, 1,  4,   2333,   3390, 140, 165, 185, 205,  1,  1, { 3355, 2452, 3371, }, { 1, 1, 1, }, nil, nil, { 3396, }, },
	[7845]   = { nil, 1,  4,   7845,   6373, 140, 165, 185, 205,  1,  1, { 6371, 3356, 3371, }, { 2, 1, 1, }, true, 3000, },
	[3188]   = { nil, 1,  4,   3188,   3391, 150, 175, 195, 215,  1,  1, { 2449, 3356, 3371, }, { 1, 1, 1, }, nil, nil, { 6211, }, },
	[6624]   = { nil, 1,  4,   6624,   5634, 150, 175, 195, 215,  1,  1, { 6370, 3820, 3371, }, { 2, 1, 1, }, nil, nil, { 5642, }, },
	[7181]   = { nil, 1,  4,   7181,   1710, 155, 175, 195, 215,  1,  1, { 3357, 3356, 3371, }, { 1, 1, 1, }, true, 5000, },
	[3452]   = { nil, 1,  4,   3452,   3827, 160, 180, 200, 220,  1,  1, { 3820, 3356, 3371, }, { 1, 1, 1, }, true, 5000, },
	[3448]   = { nil, 1,  4,   3448,   3823, 165, 185, 205, 225,  1,  1, { 3818, 3355, 3371, }, { 1, 1, 1, }, true, 5000, },
	[3449]   = { nil, 1,  4,   3449,   3824, 165, 190, 210, 230,  1,  1, { 3369, 3371, }, { 2, 1, }, true, 5000, { 6068, }, },
	[7257]   = { nil, 1,  4,   7257,   6049, 165, 210, 230, 250,  1,  1, { 4402, 6371, 3371, }, { 1, 1, 1, }, nil, nil, { 6055, }, },
	[3450]   = { nil, 1,  4,   3450,   3825, 175, 195, 215, 235,  1,  1, { 3355, 3821, 3371, }, { 1, 1, 1, }, true, 6000, { 3830, }, },
	[6618]   = { nil, 1,  4,   6618,   5633, 175, 195, 215, 235,  1,  1, { 5637, 3356, 3371, }, { 1, 1, 1, }, nil, nil, { 5643, }, },
	[3451]   = { nil, 1,  4,   3451,   3826, 180, 200, 220, 240,  1,  1, { 3357, 2453, 3371, }, { 1, 1, 1, }, nil, nil, { 3831, }, },
	[11449]  = { nil, 1,  4,  11449,   8949, 185, 205, 225, 245,  1,  1, { 3820, 3821, 3371, }, { 1, 1, 1, }, true, 6500, },
	[7258]   = { nil, 1,  4,   7258,   6050, 190, 205, 225, 245,  1,  1, { 3819, 3821, 3371, }, { 1, 1, 1, }, nil, nil, { 6056, }, },
	[7259]   = { nil, 1,  4,   7259,   6052, 190, 210, 230, 250,  1,  1, { 3357, 3820, 3371, }, { 1, 1, 1, }, nil, nil, { 6057, }, },
	[21923]  = { nil, 1,  4,  21923,  17708, 190, 210, 230, 250,  1,  1, { 3819, 3358, 3371, }, { 2, 1, 1, }, nil, nil, { 17709, }, },
	[3453]   = { nil, 1,  4,   3453,   3828, 195, 215, 235, 255,  1,  1, { 3358, 3818, 3371, }, { 1, 1, 1, }, nil, nil, { 3832, }, },
	[11450]  = { nil, 1,  4,  11450,   8951, 195, 215, 235, 255,  1,  1, { 3355, 3821, 3371, }, { 1, 1, 1, }, true, 7500, },
	[3454]   = { nil, 1,  4,   3454,   3829, 200, 220, 240, 260,  1,  1, { 3358, 3819, 3371, }, { 4, 2, 1, }, nil, nil, { 14634, }, },
	[12609]  = { nil, 1,  4,  12609,  10592, 200, 220, 240, 260,  1,  1, { 3821, 3818, 3371, }, { 1, 1, 1, }, true, 8000, },
	[11448]  = { nil, 1,  4,  11448,   6149, 205, 220, 240, 260,  1,  1, { 3358, 3821, 3371, }, { 1, 1, 1, }, true, 9000, },
	[11451]  = { nil, 1,  4,  11451,   8956, 205, 220, 240, 260,  1,  1, { 4625, 3821, 3371, }, { 1, 1, 1, }, true, 8000, },
	[11453]  = { nil, 1,  4,  11453,   9036, 210, 225, 245, 265,  1,  1, { 3358, 8831, 3371, }, { 1, 1, 1, }, nil, nil, { 9293, }, },
	[11456]  = { nil, 1,  4,  11456,   9061, 210, 225, 245, 265,  1,  1, { 4625, 9260, 3371, }, { 1, 1, 1, }, nil, nil, { 10644, }, },
	[11452]  = { nil, 1,  4,  11452,   9030, 215, 225, 245, 265,  1,  1, { 7067, 3821, 3371, }, { 1, 1, 1, }, },
	[4942]   = { nil, 1,  4,   4942,   4623, 215, 230, 250, 270,  1,  1, { 3858, 3821, 3371, }, { 1, 1, 1, }, nil, nil, { 4624, }, },
	[11457]  = { nil, 1,  4,  11457,   3928, 215, 230, 250, 270,  1,  1, { 8838, 3358, 3371, }, { 1, 1, 1, }, true, 10000, },
	[22808]  = { nil, 1,  4,  22808,  18294, 215, 230, 250, 270,  1,  1, { 7972, 8831, 3371, }, { 1, 2, 1, }, true, 10000, },
	[11458]  = { nil, 1,  4,  11458,   9144, 225, 240, 260, 280,  1,  1, { 8153, 8831, 3371, }, { 1, 1, 1, }, nil, nil, { 9294, }, },
	[11459]  = { nil, 1,  4,  11459,   9149, 225, 240, 260, 280,  1,  1, { 3575, 9262, 8831, 4625, }, { 4, 1, 4, 4, }, nil, nil, { 9303, }, },
	[11479]  = { nil, 1,  4,  11479,   3577, 225, 240, 260, 280,  1,  1, { 3575, }, { 1, }, nil, nil, { 9304, }, },
	[11480]  = { nil, 1,  4,  11480,   6037, 225, 240, 260, 280,  1,  1, { 3860, }, { 1, }, nil, nil, { 9305, }, },
	[11460]  = { nil, 1,  4,  11460,   9154, 230, 245, 265, 285,  1,  1, { 8831, 3371, }, { 1, 1, }, true, 5000, },
	[15833]  = { nil, 1,  4,  15833,  12190, 230, 245, 265, 285,  1,  1, { 8831, 3371, }, { 3, 1, }, true, 10000, },
	[11461]  = { nil, 1,  4,  11461,   9155, 235, 250, 270, 290,  1,  1, { 8839, 3821, 3371, }, { 1, 1, 1, }, true, 10000, },
	[11464]  = { nil, 1,  4,  11464,   9172, 235, 250, 270, 290,  1,  1, { 8845, 8838, 3371, }, { 1, 1, 1, }, nil, nil, { 9295, }, },
	[11465]  = { nil, 1,  4,  11465,   9179, 235, 250, 270, 290,  1,  1, { 8839, 3358, 3371, }, { 1, 1, 1, }, true, 12000, },
	[11466]  = { nil, 1,  4,  11466,   9088, 240, 255, 275, 295,  1,  1, { 8839, 3371, }, { 3, 1, }, nil, nil, { 9296, }, },
	[11467]  = { nil, 1,  4,  11467,   9187, 240, 255, 275, 295,  1,  1, { 8838, 3821, 3371, }, { 1, 1, 1, }, true, 12000, },
	[11468]  = { nil, 1,  4,  11468,   9197, 240, 255, 275, 295,  1,  1, { 8831, 3371, }, { 3, 1, }, nil, nil, { 9297, }, },
	[11472]  = { nil, 1,  4,  11472,   9206, 245, 260, 280, 300,  1,  1, { 8838, 8846, 3371, }, { 1, 1, 1, }, nil, nil, { 9298, }, },
	[11473]  = { nil, 1,  4,  11473,   9210, 245, 260, 280, 300,  1,  1, { 8845, 4342, 3371, }, { 2, 1, 1, }, nil, nil, { 9302, }, },
	[17551]  = { nil, 1,  4,  17551,  13423, 250, 250, 255, 260,  1,  1, { 13422, }, { 1, }, true, 15000, },
	[11476]  = { nil, 1,  4,  11476,   9264, 250, 265, 285, 305,  1,  1, { 8845, 3371, }, { 3, 1, }, nil, nil, { 9301, }, },
	[11477]  = { nil, 1,  4,  11477,   9224, 250, 265, 285, 305,  1,  1, { 8846, 8845, 3371, }, { 1, 1, 1, }, nil, nil, { 9300, }, },
	[11478]  = { nil, 1,  4,  11478,   9233, 250, 265, 285, 305,  1,  1, { 8846, 3371, }, { 2, 1, }, true, 14000, },
	[26277]  = { nil, 1,  4,  26277,  21546, 250, 265, 285, 305,  1,  1, { 6371, 4625, 3371, }, { 3, 3, 1, }, nil, nil, { 21547, }, },
	[3175]   = { nil, 1,  4,   3175,   3387, 250, 275, 295, 315,  1,  1, { 8839, 8845, 3371, }, { 2, 1, 1, }, nil, nil, { 3395, }, },
	[17552]  = { nil, 1,  4,  17552,  13442, 255, 270, 290, 310,  1,  1, { 8846, 3371, }, { 3, 1, }, true, 15000, { 13476, }, },
	[17553]  = { nil, 1,  4,  17553,  13443, 260, 275, 295, 315,  1,  1, { 8838, 8839, 3371, }, { 2, 2, 1, }, true, 15000, { 13477, }, },
	[17554]  = { nil, 1,  4,  17554,  13445, 265, 280, 300, 320,  1,  1, { 13423, 8838, 3371, }, { 2, 1, 1, }, nil, nil, { 13478, }, },
	[17555]  = { nil, 1,  4,  17555,  13447, 270, 285, 305, 325,  1,  1, { 13463, 13466, 3371, }, { 1, 2, 1, }, true, 15000, { 13479, }, },
	[17187]  = { nil, 1,  4,  17187,  12360, 275, 275, 282, 290,  1,  1, { 12359, 12363, }, { 1, 1, }, nil, nil, { 12958, }, },
	[17559]  = { nil, 1,  4,  17559,   7078, 275, 275, 282, 290,  1,  1, { 7082, }, { 1, }, nil, nil, { 13482, }, },
	[17560]  = { nil, 1,  4,  17560,   7076, 275, 275, 282, 290,  1,  1, { 7078, }, { 1, }, nil, nil, { 13483, }, },
	[17561]  = { nil, 1,  4,  17561,   7080, 275, 275, 282, 290,  1,  1, { 7076, }, { 1, }, nil, nil, { 13484, }, },
	[17562]  = { nil, 1,  4,  17562,   7082, 275, 275, 282, 290,  1,  1, { 7080, }, { 1, }, nil, nil, { 13485, }, },
	[17563]  = { nil, 1,  4,  17563,   7080, 275, 275, 282, 290,  1,  1, { 12808, }, { 1, }, nil, nil, { 13486, }, },
	[17564]  = { nil, 1,  4,  17564,  12808, 275, 275, 282, 290,  1,  1, { 7080, }, { 1, }, nil, nil, { 13487, }, },
	[17565]  = { nil, 1,  4,  17565,   7076, 275, 275, 282, 290,  1,  1, { 12803, }, { 1, }, nil, nil, { 13488, }, },
	[17566]  = { nil, 1,  4,  17566,  12803, 275, 275, 282, 290,  1,  1, { 7076, }, { 1, }, nil, nil, { 13489, }, },
	[17556]  = { nil, 1,  4,  17556,  13446, 275, 290, 310, 330,  1,  1, { 13464, 13465, 3371, }, { 2, 1, 1, }, true, 20000, { 13480, }, },
	[17557]  = { nil, 1,  4,  17557,  13453, 275, 290, 310, 330,  1,  1, { 8846, 13466, 3371, }, { 2, 2, 1, }, true, 20000, { 13481, }, },
	[24365]  = { nil, 1,  4,  24365,  20007, 275, 290, 310, 330,  1,  1, { 13463, 13466, 3371, }, { 1, 2, 1, }, nil, nil, { 20011, }, },
	[24366]  = { nil, 1,  4,  24366,  20002, 275, 290, 310, 330,  1,  1, { 13463, 13464, 3371, }, { 2, 1, 1, }, nil, nil, { 20012, }, },
	[17570]  = { nil, 1,  4,  17570,  13455, 280, 295, 315, 335,  1,  1, { 13423, 10620, 3371, }, { 2, 1, 1, }, nil, nil, { 13490, }, },
	[17571]  = { nil, 1,  4,  17571,  13452, 280, 295, 315, 335,  1,  1, { 13465, 13466, 3371, }, { 2, 2, 1, }, nil, nil, { 13491, }, },
	[17572]  = { nil, 1,  4,  17572,  13462, 285, 300, 320, 340,  1,  1, { 13467, 13466, 3371, }, { 2, 2, 1, }, true, 20000, { 13492, }, },
	[17573]  = { nil, 1,  4,  17573,  13454, 285, 300, 320, 340,  1,  1, { 13463, 13465, 3371, }, { 3, 1, 1, }, true, 20000, { 13493, }, },
	[24367]  = { nil, 1,  4,  24367,  20008, 285, 300, 320, 340,  1,  1, { 13467, 13465, 3371, }, { 2, 1, 1, }, nil, nil, { 20013, }, },
	[17574]  = { nil, 1,  4,  17574,  13457, 290, 305, 325, 345,  1,  1, { 7068, 13463, 3371, }, { 1, 1, 1, }, nil, nil, { 13494, }, },
	[17575]  = { nil, 1,  4,  17575,  13456, 290, 305, 325, 345,  1,  1, { 7070, 13463, 3371, }, { 1, 1, 1, }, nil, nil, { 13495, }, },
	[17576]  = { nil, 1,  4,  17576,  13458, 290, 305, 325, 345,  1,  1, { 7067, 13463, 3371, }, { 1, 1, 1, }, nil, nil, { 13496, }, },
	[17577]  = { nil, 1,  4,  17577,  13461, 290, 305, 325, 345,  1,  1, { 11176, 13463, 3371, }, { 1, 1, 1, }, nil, nil, { 13497, }, },
	[17578]  = { nil, 1,  4,  17578,  13459, 290, 305, 325, 345,  1,  1, { 3824, 13463, 3371, }, { 1, 1, 1, }, nil, nil, { 13499, }, },
	[17579]  = { nil, 1,  4,  17579,  13460, 290, 305, 325, 345,  1,  1, { 7069, 13463, 3371, }, { 1, 1, 1, }, nil, nil, { 13500, }, },
	[24368]  = { nil, 1,  4,  24368,  20004, 290, 305, 325, 345,  1,  1, { 8846, 13466, 3371, }, { 1, 2, 1, }, nil, nil, { 20014, }, },
	[17580]  = { nil, 1,  4,  17580,  13444, 295, 310, 330, 350,  1,  1, { 13463, 13467, 3371, }, { 3, 2, 1, }, nil, nil, { 13501, }, },
	[25146]  = { nil, 1,  4,  25146,   7068, 300, 301, 305, 310,  3,  3, { 7077, }, { 1, }, nil, nil, { 20761, }, },
	[22732]  = { nil, 1,  4,  22732,  18253, 300, 310, 320, 330,  1,  1, { 10286, 13464, 13463, 3371, }, { 1, 4, 4, 1, }, nil, nil, { 18257, }, },
	[17634]  = { nil, 1,  4,  17634,  13506, 300, 315, 322, 330,  2,  2, { 13423, 3371, }, { 7, 1, }, nil, nil, { 13518, }, },
	[17635]  = { nil, 1,  4,  17635,  13510, 300, 315, 322, 330,  2,  2, { 8846, 13423, 13468, 3371, }, { 7, 3, 1, 1, }, nil, nil, { 31354, 13519, }, },
	[17636]  = { nil, 1,  4,  17636,  13511, 300, 315, 322, 330,  2,  2, { 13463, 13467, 13468, 3371, }, { 7, 3, 1, 1, }, nil, nil, { 31356, 13520, }, },
	[17637]  = { nil, 1,  4,  17637,  13512, 300, 315, 322, 330,  2,  2, { 13463, 13465, 13468, 3371, }, { 7, 3, 1, 1, }, nil, nil, { 31355, 13521, }, },
	[17638]  = { nil, 1,  4,  17638,  13513, 300, 315, 322, 330,  2,  2, { 13467, 13465, 13468, 3371, }, { 7, 3, 1, 1, }, nil, nil, { 31357, 13522, }, },
	[33732]  = { nil, 1,  4,  33732,  28100, 300, 315, 322, 330,  1,  1, { 13464, 22785, 3371, }, { 1, 1, 1, }, true, 20000, },
	[33738]  = { nil, 1,  4,  33738,  28102, 300, 315, 322, 330,  1,  1, { 13465, 22785, 3371, }, { 1, 1, 1, }, true, 20000, },
	[33740]  = { nil, 1,  4,  33740,  28103, 300, 315, 322, 330,  1,  1, { 13463, 22785, 3371, }, { 1, 1, 1, }, true, 20000, },
	[28543]  = { nil, 1,  4,  28543,  22823, 305, 320, 327, 335,  1,  1, { 22787, 22785, 3371, }, { 1, 1, 1, }, nil, nil, { 22900, }, },
	[28544]  = { nil, 1,  4,  28544,  22824, 305, 320, 327, 335,  1,  1, { 13465, 22785, 3371, }, { 1, 1, 1, }, true, 25000, },
	[28545]  = { nil, 1,  4,  28545,  22825, 310, 325, 332, 340,  1,  1, { 13464, 22786, 3371, }, { 1, 1, 1, }, true, 25000, },
	[33733]  = { nil, 1,  4,  33733,  28101, 310, 325, 332, 340,  1,  1, { 22787, 22785, 3371, }, { 2, 1, 1, }, true, 25000, },
	[39636]  = { nil, 1,  4,  39636,  32062, 310, 325, 332, 340,  1,  1, { 22787, 22785, 3371, }, { 2, 1, 1, }, true, 25000, },
	[24266]  = { nil, 1,  4,  24266,  19931, 315, 315, 322, 330,  3,  3, { 12938, 19943, 12804, 13468, }, { 1, 1, 6, 1, }, },
	[28546]  = { nil, 1,  4,  28546,  22826, 315, 330, 337, 345,  1,  1, { 22787, 22785, 3371, }, { 2, 1, 1, }, nil, nil, { 22901, }, },
	[33741]  = { nil, 1,  4,  33741,  28104, 315, 330, 337, 345,  1,  1, { 22789, 22785, 3371, }, { 1, 1, 1, }, true, 30000, },
	[28549]  = { nil, 1,  4,  28549,  22827, 320, 335, 342, 350,  1,  1, { 22578, 22790, 3371, }, { 2, 1, 1, }, nil, nil, { 22902, }, },
	[28550]  = { nil, 1,  4,  28550,  22828, 320, 335, 342, 350,  1,  1, { 22789, 3371, }, { 3, 1, }, nil, nil, { 22903, }, },
	[39637]  = { nil, 1,  4,  39637,  32063, 320, 335, 342, 350,  1,  1, { 22786, 22787, 3371, }, { 1, 2, 1, }, nil, nil, { 32070, }, },
	[39638]  = { nil, 1,  4,  39638,  32067, 320, 335, 342, 350,  1,  1, { 22785, 22789, 3371, }, { 1, 1, 1, }, true, 30000, },
	[45061]  = { nil, 1,  4,  45061,  34440, 325, 335, 342, 350,  1,  1, { 3371, 22787, }, { 1, 2, }, true, 35000, { 34481, }, },
	[28551]  = { nil, 1,  4,  28551,  22829, 325, 340, 347, 355,  1,  1, { 22791, 22785, 3371, }, { 2, 1, 1, }, true, 50000, },
	[28552]  = { nil, 1,  4,  28552,  22830, 325, 340, 347, 355,  1,  1, { 22787, 22789, 3371, }, { 2, 1, 1, }, nil, nil, { 22904, }, },
	[38070]  = { nil, 1,  4,  38070,  31080, 325, 340, 347, 355,  1,  1, { 22452, 21886, 22457, }, { 1, 1, 1, }, true, 20000, },
	[28553]  = { nil, 1,  4,  28553,  22831, 330, 345, 352, 360,  1,  1, { 22789, 22785, 3371, }, { 1, 2, 1, }, nil, nil, { 22905, 24001, }, },
	[39639]  = { nil, 1,  4,  39639,  32068, 330, 345, 352, 360,  1,  1, { 22790, 22787, 3371, }, { 1, 1, 1, }, nil, nil, { 32071, }, },
	[28554]  = { nil, 1,  4,  28554,  22871, 335, 350, 357, 365,  1,  1, { 22787, 22791, 3371, }, { 3, 1, 1, }, nil, nil, { 22906, }, },
	[38960]  = { nil, 1,  4,  38960,  31679, 335, 350, 357, 365,  1,  1, { 22789, 22792, 3371, }, { 1, 2, 1, }, nil, nil, { 31680, }, },
	[28555]  = { nil, 1,  4,  28555,  22832, 340, 355, 362, 370,  1,  1, { 22786, 22785, 3371, }, { 2, 1, 1, }, nil, nil, { 22907, }, },
	[28556]  = { nil, 1,  4,  28556,  22833, 345, 360, 367, 375,  1,  1, { 22574, 22790, 3371, }, { 2, 1, 1, }, nil, nil, { 22908, }, },
	[28557]  = { nil, 1,  4,  28557,  22834, 345, 360, 367, 375,  1,  1, { 22790, 22789, 3371, }, { 3, 1, 1, }, nil, nil, { 22909, }, },
	[38962]  = { nil, 1,  4,  38962,  31676, 345, 360, 367, 375,  1,  1, { 22785, 22792, 3371, }, { 2, 3, 1, }, nil, nil, { 31681, }, },
	[53838]  = { nil, 1,  4,  53838,  39671, 350, 360, 370, 380,  1,  1, { 36901, 3371, }, { 2, 1, }, true, 40000, },
	[17632]  = { nil, 1,  4,  17632,  13503, 350, 365, 372, 380,  1,  1, { 9149, 25867, 25868, 22794, 23571, }, { 1, 1, 1, 2, 5, }, nil, nil, { 13517, }, },
	[28558]  = { nil, 1,  4,  28558,  22835, 350, 365, 372, 380,  1,  1, { 22790, 22792, 3371, }, { 1, 1, 1, }, nil, nil, { 22910, }, },
	[28562]  = { nil, 1,  4,  28562,  22836, 350, 365, 372, 380,  1,  1, { 22786, 22792, 3371, }, { 1, 1, 1, }, nil, nil, { 22911, }, },
	[28563]  = { nil, 1,  4,  28563,  22837, 350, 365, 372, 380,  1,  1, { 22789, 22790, 3371, }, { 2, 1, 1, }, nil, nil, { 22912, }, },
	[28564]  = { nil, 1,  4,  28564,  22838, 350, 365, 372, 380,  1,  1, { 22789, 22791, 3371, }, { 2, 1, 1, }, nil, nil, { 22913, 35295, }, },
	[28565]  = { nil, 1,  4,  28565,  22839, 350, 365, 372, 380,  1,  1, { 22792, 22791, 3371, }, { 2, 1, 1, }, nil, nil, { 22914, }, },
	[28566]  = { nil, 1,  4,  28566,  21884, 350, 365, 372, 380,  1,  1, { 22451, }, { 1, }, nil, nil, { 22915, }, },
	[28567]  = { nil, 1,  4,  28567,  21885, 350, 365, 372, 380,  1,  1, { 22452, }, { 1, }, nil, nil, { 22916, }, },
	[28568]  = { nil, 1,  4,  28568,  22452, 350, 365, 372, 380,  1,  1, { 21884, }, { 1, }, nil, nil, { 22917, 30443, }, },
	[28569]  = { nil, 1,  4,  28569,  22451, 350, 365, 372, 380,  1,  1, { 21885, }, { 1, }, nil, nil, { 22918, }, },
	[29688]  = { nil, 1,  4,  29688,  23571, 350, 365, 372, 380,  1,  1, { 22452, 21885, 22451, 21884, 22457, }, { 1, 1, 1, 1, 1, }, nil, nil, { 23574, }, },
	[32765]  = { nil, 1,  4,  32765,  25867, 350, 365, 372, 380,  1,  1, { 23079, 23107, 23112, 22452, 21885, }, { 3, 3, 3, 2, 2, }, nil, nil, { 25869, }, },
	[32766]  = { nil, 1,  4,  32766,  25868, 350, 365, 372, 380,  1,  1, { 23077, 21929, 23117, 21884, 22451, }, { 3, 3, 3, 2, 2, }, nil, nil, { 25870, 29232, }, },
	[53841]  = { nil, 1,  4,  53841,  40068, 355, 365, 375, 385,  1,  1, { 36901, 37921, 3371, }, { 1, 2, 1, }, true, 40000, },
	[28570]  = { nil, 1,  4,  28570,  22840, 355, 370, 375, 380,  1,  1, { 22790, 22791, 3371, }, { 1, 1, 1, }, nil, nil, { 22919, }, },
	[41458]  = { nil, 1,  4,  41458,  32839, 360, 360, 370, 380,  1,  1, { 22457, 22793, 23782, }, { 2, 7, 1, }, },
	[41500]  = { nil, 1,  4,  41500,  32849, 360, 360, 370, 380,  1,  1, { 21884, 22793, 23782, }, { 2, 7, 1, }, },
	[41501]  = { nil, 1,  4,  41501,  32850, 360, 360, 370, 380,  1,  1, { 21885, 22793, 23782, }, { 2, 7, 1, }, },
	[41502]  = { nil, 1,  4,  41502,  32851, 360, 360, 370, 380,  1,  1, { 21886, 22793, 23782, }, { 2, 7, 1, }, },
	[41503]  = { nil, 1,  4,  41503,  32852, 360, 360, 370, 380,  1,  1, { 22456, 22793, 23782, }, { 2, 7, 1, }, },
	[53839]  = { nil, 1,  4,  53839,  40067, 360, 365, 375, 385,  1,  1, { 36907, 3371, }, { 2, 1, }, true, 40000, },
	[28571]  = { nil, 1,  4,  28571,  22841, 360, 375, 377, 380,  5,  5, { 21884, 22793, 3371, }, { 1, 3, 5, }, nil, nil, { 22920, }, },
	[28572]  = { nil, 1,  4,  28572,  22842, 360, 375, 377, 380,  5,  5, { 21885, 22793, 3371, }, { 1, 3, 5, }, nil, nil, { 22921, }, },
	[28573]  = { nil, 1,  4,  28573,  22844, 360, 375, 377, 380,  5,  5, { 21886, 22793, 3371, }, { 1, 3, 5, }, nil, nil, { 22922, }, },
	[28575]  = { nil, 1,  4,  28575,  22845, 360, 375, 377, 380,  5,  5, { 22457, 22793, 3371, }, { 1, 3, 5, }, nil, nil, { 22923, }, },
	[28576]  = { nil, 1,  4,  28576,  22846, 360, 375, 377, 380,  5,  5, { 22456, 22793, 3371, }, { 1, 3, 5, }, nil, nil, { 22924, }, },
	[28577]  = { nil, 1,  4,  28577,  22847, 360, 375, 377, 380,  5,  5, { 21886, 22793, 3371, }, { 1, 3, 5, }, nil, nil, { 22925, }, },
	[38961]  = { nil, 1,  4,  38961,  31677, 360, 375, 377, 380,  1,  1, { 22793, 22792, 3371, }, { 1, 2, 1, }, nil, nil, { 31682, }, },
	[28578]  = { nil, 1,  4,  28578,  22848, 365, 375, 377, 380,  1,  1, { 22791, 22793, 3371, }, { 1, 1, 1, }, nil, nil, { 22926, 35294, }, },
	[28579]  = { nil, 1,  4,  28579,  22849, 365, 375, 377, 380,  1,  1, { 22790, 22573, 3371, }, { 2, 3, 1, }, nil, nil, { 22927, }, },
	[53842]  = { nil, 1,  4,  53842,  40070, 365, 375, 382, 390,  1,  1, { 36901, 36904, 3371, }, { 1, 1, 1, }, true, 40000, },
	[28580]  = { nil, 1,  4,  28580,  21885, 375, 375, 377, 380,  1,  1, { 22456, }, { 1, }, },
	[28581]  = { nil, 1,  4,  28581,  22456, 375, 375, 377, 380,  1,  1, { 21885, }, { 1, }, },
	[28582]  = { nil, 1,  4,  28582,  21884, 375, 375, 377, 380,  1,  1, { 22457, }, { 1, }, },
	[28583]  = { nil, 1,  4,  28583,  22457, 375, 375, 377, 380,  1,  1, { 21884, }, { 1, }, },
	[28584]  = { nil, 1,  4,  28584,  22452, 375, 375, 377, 380,  1,  1, { 21886, }, { 1, }, },
	[28585]  = { nil, 1,  4,  28585,  21886, 375, 375, 377, 380,  1,  1, { 22452, }, { 1, }, },
	[28586]  = { nil, 1,  4,  28586,  22850, 375, 375, 377, 380,  1,  1, { 22793, 22786, 22791, 3371, }, { 2, 1, 1, 1, }, },
	[28587]  = { nil, 1,  4,  28587,  22851, 375, 375, 377, 380,  2,  2, { 22794, 22793, 22790, 3371, }, { 1, 3, 7, 1, }, },
	[28588]  = { nil, 1,  4,  28588,  22853, 375, 375, 377, 380,  2,  2, { 22794, 22793, 22786, 3371, }, { 1, 3, 7, 1, }, },
	[28589]  = { nil, 1,  4,  28589,  22854, 375, 375, 377, 380,  2,  2, { 22794, 22793, 22789, 3371, }, { 1, 3, 7, 1, }, },
	[28590]  = { nil, 1,  4,  28590,  22861, 375, 375, 377, 380,  2,  2, { 22794, 22793, 22791, 3371, }, { 1, 3, 7, 1, }, },
	[28591]  = { nil, 1,  4,  28591,  22866, 375, 375, 377, 380,  2,  2, { 22794, 22793, 22792, 3371, }, { 1, 3, 7, 1, }, },
	[47046]  = { nil, 1,  4,  47046,  35748, 375, 380, 385, 390,  1,  1, { 13503, 22451, 30183, }, { 1, 6, 2, }, nil, nil, { 35752, }, },
	[47048]  = { nil, 1,  4,  47048,  35749, 375, 380, 385, 390,  1,  1, { 13503, 21884, 30183, }, { 1, 6, 2, }, nil, nil, { 35753, }, },
	[47049]  = { nil, 1,  4,  47049,  35750, 375, 380, 385, 390,  1,  1, { 13503, 21886, 30183, }, { 1, 6, 2, }, nil, nil, { 35754, }, },
	[47050]  = { nil, 1,  4,  47050,  35751, 375, 380, 385, 390,  1,  1, { 13503, 22456, 30183, }, { 1, 6, 2, }, nil, nil, { 35755, }, },
	[53812]  = { nil, 1,  4,  53812,  40195, 375, 380, 385, 390,  1,  2, { 40199, }, { 1, }, true, 60000, },
	[53848]  = { nil, 1,  4,  53848,  40076, 375, 380, 385, 390,  1,  1, { 40195, 3371, }, { 3, 1, }, true, 60000, },
	[53899]  = { nil, 1,  4,  53899,  40079, 375, 380, 385, 390,  1,  1, { 37921, 36901, 3371, }, { 4, 1, 1, }, true, 60000, },
	[62409]  = { nil, 1,  4,  62409,  44958, 375, 380, 385, 390,  1,  1, { 41814, }, { 2, }, true, 60000, },
	[42736]  = { nil, 1,  4,  42736,  33208, 375, 390, 397, 405,  2,  2, { 22786, 22791, 22794, 3371, }, { 7, 3, 1, 1, }, nil, nil, { 33209, }, },
	[53900]  = { nil, 1,  4,  53900,  40081, 380, 385, 390, 395,  1,  1, { 36901, 36907, 3371, }, { 1, 2, 1, }, true, 120000, },
	[53847]  = { nil, 1,  4,  53847,  40072, 385, 390, 395, 400,  1,  1, { 36907, 3371, }, { 3, 1, }, true, 65000, },
	[54218]  = { nil, 1,  4,  54218,  40073, 385, 390, 395, 400,  1,  1, { 36904, 3371, }, { 2, 1, }, true, 120000, },
	[62213]  = { nil, 1,  4,  62213,  44939, 385, 390, 395, 400,  1,  1, { 39970, 3371, }, { 4, 1, }, true, 120000, },
	[53898]  = { nil, 1,  4,  53898,  40078, 390, 395, 400, 405,  1,  1, { 36901, 3371, }, { 4, 1, }, true, 120000, },
	[53840]  = { nil, 1,  4,  53840,  39666, 395, 400, 407, 415,  1,  1, { 36901, 36903, 3371, }, { 2, 2, 1, }, true, 120000, },
	[60367]  = { nil, 1,  4,  60367,  44332, 395, 400, 407, 415,  1,  1, { 37921, 36907, 3371, }, { 2, 1, 1, }, true, 120000, },
	[53905]  = { nil, 1,  4,  53905,  40093, 395, 415, 422, 430,  1,  1, { 36906, 3371, }, { 2, 1, }, true, 120000, },
	[60350]  = { nil, 1,  4,  60350,  41163, 395, 420, 430, 440,  1,  1, { 36913, }, { 8, }, true, 150000, },
	[53936]  = { nil, 1,  4,  53936,  40213, 400, 410, 415, 420,  1,  1, { 37701, 3371, }, { 2, 1, }, nil, nil, { 44564, }, },
	[53937]  = { nil, 1,  4,  53937,  40215, 400, 410, 415, 420,  1,  1, { 37702, 3371, }, { 2, 1, }, nil, nil, { 44566, }, },
	[53938]  = { nil, 1,  4,  53938,  40217, 400, 410, 415, 420,  1,  1, { 37704, 3371, }, { 2, 1, }, nil, nil, { 44568, }, },
	[53939]  = { nil, 1,  4,  53939,  40214, 400, 410, 415, 420,  1,  1, { 37705, 3371, }, { 2, 1, }, nil, nil, { 44565, }, },
	[53942]  = { nil, 1,  4,  53942,  40216, 400, 410, 415, 420,  1,  1, { 37703, 3371, }, { 2, 1, }, nil, nil, { 44567, }, },
	[53895]  = { nil, 1,  4,  53895,  40077, 400, 415, 422, 430,  1,  1, { 36901, 3371, }, { 2, 1, }, nil, nil, nil, nil, nil, nil, 28675, },
	[53904]  = { nil, 1,  4,  53904,  40087, 400, 415, 422, 430,  1,  1, { 36907, 36905, 3371, }, { 2, 2, 1, }, nil, nil, nil, nil, nil, nil, 28675, },
	[54220]  = { nil, 1,  4,  54220,  40097, 400, 415, 422, 430,  1,  1, { 36906, 37701, 3371, }, { 2, 1, 1, }, },
	[54221]  = { nil, 1,  4,  54221,  40211, 400, 415, 422, 430,  1,  1, { 36903, 40195, 3371, }, { 2, 1, 1, }, nil, nil, nil, nil, nil, nil, 28675, },
	[54222]  = { nil, 1,  4,  54222,  40212, 400, 415, 422, 430,  1,  1, { 36905, 40195, 3371, }, { 2, 1, 1, }, nil, nil, nil, nil, nil, nil, 28675, },
	[56519]  = { nil, 1,  4,  56519,  40109, 400, 415, 422, 430,  1,  1, { 36901, 36905, 3371, }, { 1, 2, 1, }, nil, nil, nil, nil, nil, nil, 28677, },
	[60354]  = { nil, 1,  4,  60354,  44325, 400, 415, 422, 430,  1,  1, { 36904, 36907, 3371, }, { 2, 1, 1, }, nil, nil, nil, nil, nil, nil, 28677, },
	[60355]  = { nil, 1,  4,  60355,  44327, 400, 415, 422, 430,  1,  1, { 36901, 36903, 3371, }, { 1, 2, 1, }, nil, nil, nil, nil, nil, nil, 28677, },
	[60356]  = { nil, 1,  4,  60356,  44328, 400, 415, 422, 430,  1,  1, { 36906, 37704, 3371, }, { 2, 1, 1, }, nil, nil, nil, nil, nil, nil, 28677, },
	[60357]  = { nil, 1,  4,  60357,  44329, 400, 415, 422, 430,  1,  1, { 36901, 36903, 3371, }, { 1, 2, 1, }, nil, nil, nil, nil, nil, nil, 28677, },
	[60365]  = { nil, 1,  4,  60365,  44330, 400, 415, 422, 430,  1,  1, { 36904, 3371, }, { 2, 1, }, nil, nil, nil, nil, nil, nil, 28677, },
	[60366]  = { nil, 1,  4,  60366,  44331, 400, 415, 422, 430,  1,  1, { 37921, 37704, 3371, }, { 1, 1, 1, }, nil, nil, nil, nil, nil, nil, 28677, },
	[60893]  = { nil, 1,  4,  60893,    nil, 400, 415, 422, 430,  0,  0, { 36901, 36903, 36907, 3371, }, { 10, 10, 4, 4, }, true, 200000, },
	[62410]  = { nil, 1,  4,  62410,   8827, 400, 415, 422, 430,  1,  1, { 44958, 3371, }, { 3, 1, }, nil, nil, nil, nil, nil, nil, 28677, },
	[60396]  = { nil, 1,  4,  60396,  44322, 400, 420, 425, 430,  1,  1, { 36901, 35625, 36908, }, { 20, 2, 1, }, true, 200000, },
	[60403]  = { nil, 1,  4,  60403,  44323, 400, 420, 425, 430,  1,  1, { 37921, 40195, 36908, }, { 20, 12, 1, }, true, 200000, },
	[60405]  = { nil, 1,  4,  60405,  44324, 400, 420, 425, 430,  1,  1, { 36903, 36904, 36908, }, { 15, 15, 1, }, true, 200000, },
	[53771]  = { nil, 1,  4,  53771,  35627, 405, 405, 415, 425,  1,  1, { 35625, }, { 1, }, },
	[53773]  = { nil, 1,  4,  53773,  36860, 405, 405, 415, 425,  1,  1, { 35625, }, { 1, }, },
	[53774]  = { nil, 1,  4,  53774,  35622, 405, 405, 415, 425,  1,  1, { 36860, }, { 1, }, },
	[53775]  = { nil, 1,  4,  53775,  35625, 405, 405, 415, 425,  1,  1, { 36860, }, { 1, }, },
	[53776]  = { nil, 1,  4,  53776,  35622, 405, 405, 415, 425,  1,  1, { 35623, }, { 1, }, },
	[53777]  = { nil, 1,  4,  53777,  35624, 405, 405, 415, 425,  1,  1, { 35623, }, { 1, }, },
	[53779]  = { nil, 1,  4,  53779,  35624, 405, 405, 415, 425,  1,  1, { 35627, }, { 1, }, },
	[53780]  = { nil, 1,  4,  53780,  35625, 405, 405, 415, 425,  1,  1, { 35627, }, { 1, }, },
	[53781]  = { nil, 1,  4,  53781,  35623, 405, 405, 415, 425,  1,  1, { 35624, }, { 1, }, },
	[53782]  = { nil, 1,  4,  53782,  35627, 405, 405, 415, 425,  1,  1, { 35624, }, { 1, }, },
	[53783]  = { nil, 1,  4,  53783,  35623, 405, 405, 415, 425,  1,  1, { 35622, }, { 1, }, },
	[53784]  = { nil, 1,  4,  53784,  36860, 405, 405, 415, 425,  1,  1, { 35622, }, { 1, }, },
	[53836]  = { nil, 1,  4,  53836,  33447, 405, 410, 417, 425,  1,  1, { 36901, 36906, 3371, }, { 1, 2, 1, }, true, 150000, },
	[58871]  = { nil, 1,  4,  58871,  43569, 410, 410, 412, 415,  1,  1, { 33447, 3371, }, { 10, 1, }, true, 150000, },
	[58868]  = { nil, 1,  4,  58868,  43570, 410, 415, 417, 420,  1,  1, { 33448, 3371, }, { 10, 1, }, true, 150000, },
	[53837]  = { nil, 1,  4,  53837,  33448, 410, 415, 422, 430,  1,  1, { 36905, 36901, 3371, }, { 2, 1, 1, }, true, 150000, },
	[57427]  = { nil, 1,  4,  57427,  41334, 425, 435, 440, 445,  1,  1, { 36932, 36929, 36860, }, { 1, 1, 1, }, true, 150000, },
	[67025]  = { nil, 1,  4,  67025,  47499, 425, 440, 445, 450,  1,  1, { 36908, 3371, }, { 4, 1, }, true, 100000, { 47507, }, },
	[93935]  = { nil, 1,  4,  93935,  67415, 425, 440, 450, 460,  1,  1, { 52983, 3371, }, { 1, 1, }, true, 150000, },
	[57425]  = { nil, 1,  4,  57425,  41266, 430, 440, 445, 450,  1,  1, { 36917, 36923, 35623, }, { 1, 1, 1, }, true, 150000, },
	[53901]  = { nil, 1,  4,  53901,  46376, 435, 450, 457, 465,  2,  2, { 36906, 36905, 36908, 3371, }, { 5, 5, 1, 1, }, true, 180000, },
	[53902]  = { nil, 1,  4,  53902,  46379, 435, 450, 457, 465,  2,  2, { 36905, 37704, 36908, 3371, }, { 7, 3, 1, 1, }, true, 150000, },
	[53903]  = { nil, 1,  4,  53903,  46377, 435, 450, 457, 465,  2,  2, { 36905, 36901, 36908, 3371, }, { 7, 3, 1, 1, }, true, 180000, },
	[54213]  = { nil, 1,  4,  54213,  46378, 435, 450, 457, 465,  2,  2, { 36906, 40195, 36908, 3371, }, { 7, 3, 1, 1, }, true, 150000, },
	[66659]  = { nil, 1,  4,  66659,  36919, 440, 440, 452, 465,  1,  1, { 36860, 36918, }, { 1, 1, }, },
	[54020]  = { nil, 1,  4,  54020,  40248, 445, 445, 452, 460,  1,  1, { 35623, 35624, 36860, 35622, }, { 1, 1, 1, 1, }, },
	[66658]  = { nil, 1,  4,  66658,  36931, 450, 450, 452, 465,  1,  1, { 36930, 35627, }, { 1, 1, }, true, 200000, },
	[66660]  = { nil, 1,  4,  66660,  36922, 450, 450, 452, 465,  1,  1, { 36921, 35625, }, { 1, 1, }, true, 200000, },
	[66662]  = { nil, 1,  4,  66662,  36928, 450, 450, 452, 465,  1,  1, { 35627, 36927, }, { 1, 1, }, true, 200000, },
	[66663]  = { nil, 1,  4,  66663,  36925, 450, 450, 452, 465,  1,  1, { 35623, 36924, }, { 1, 1, }, true, 200000, },
	[66664]  = { nil, 1,  4,  66664,  36934, 450, 450, 452, 465,  1,  1, { 36933, }, { 3, }, true, 200000, },
	[80477]  = { nil, 1,  4,  80477,  58084, 450, 455, 460, 465,  1,  1, { 52983, 3371, }, { 2, 1, }, true, 150000, },
	[80478]  = { nil, 1,  4,  80478,  58090, 450, 455, 460, 465,  1,  1, { 52984, 3371, }, { 2, 1, }, true, 150000, },
	[80479]  = { nil, 1,  4,  80479,  58142, 455, 460, 465, 470,  2,  2, { 52984, 3371, }, { 2, 1, }, true, 150000, },
	[80480]  = { nil, 1,  4,  80480,  58089, 455, 460, 465, 470,  1,  1, { 52984, 52985, 3371, }, { 1, 1, 1, }, true, 150000, },
	[80481]  = { nil, 1,  4,  80481,  58091, 460, 465, 470, 475,  1,  1, { 52983, 52985, 3371, }, { 1, 1, 1, }, true, 160000, },
	[80269]  = { nil, 1,  4,  80269,  58489, 460, 470, 475, 480,  1,  2, { 52329, 52985, 3371, }, { 3, 1, 1, }, true, 160000, },
	[80482]  = { nil, 1,  4,  80482,  57194, 465, 470, 475, 480,  1,  1, { 52985, 3371, }, { 2, 1, }, true, 160000, },
	[80484]  = { nil, 1,  4,  80484,  58092, 465, 470, 475, 480,  1,  1, { 52985, 52983, 3371, }, { 1, 1, 1, }, true, 160000, },
	[80486]  = { nil, 1,  4,  80486,  56850, 470, 475, 480, 485,  1,  2, { 53065, }, { 1, }, true, 160000, },
	[80487]  = { nil, 1,  4,  80487,  57099, 470, 475, 480, 485,  1,  1, { 56850, 3371, }, { 2, 1, }, true, 160000, },
	[80488]  = { nil, 1,  4,  80488,  58093, 475, 480, 485, 490,  1,  1, { 52986, 3371, }, { 2, 1, }, true, 160000, },
	[80490]  = { nil, 1,  4,  80490,  57193, 475, 480, 485, 490,  1,  1, { 52988, 52329, 3371, }, { 2, 1, 1, }, true, 160000, },
	[80491]  = { nil, 1,  4,  80491,  58094, 480, 485, 490, 495,  1,  1, { 52983, 52986, 3371, }, { 1, 1, 1, }, true, 175000, },
	[80492]  = { nil, 1,  4,  80492,  58143, 480, 485, 490, 495,  1,  1, { 52983, 52988, 3371, }, { 1, 1, 1, }, true, 175000, },
	[80494]  = { nil, 1,  4,  80494,  57192, 485, 490, 495, 500,  1,  1, { 52983, 52988, 3371, }, { 1, 1, 1, }, true, 175000, },
	[80495]  = { nil, 1,  4,  80495,  58145, 485, 490, 495, 500,  1,  1, { 52984, 52988, 3371, }, { 1, 1, 1, }, true, 175000, },
	[78866]  = { nil, 1,  4,  78866,  54464, 485, 510, 515, 520, 14, 16, { 52329, }, { 15, }, true, 175000, },
	[80493]  = { nil, 1,  4,  80493,  58144, 490, 495, 500, 505,  1,  1, { 52984, 52987, 3371, }, { 1, 1, 1, }, true, 175000, },
	[80496]  = { nil, 1,  4,  80496,  58146, 490, 495, 500, 505,  1,  1, { 52329, 52986, 3371, }, { 1, 1, 1, }, true, 175000, },
	[80497]  = { nil, 1,  4,  80497,  58148, 495, 500, 505, 510,  1,  1, { 52987, 52986, 3371, }, { 1, 1, 1, }, true, 175000, },
	[80498]  = { nil, 1,  4,  80498,  57191, 495, 500, 505, 510,  1,  1, { 52987, 3371, }, { 1, 1, }, true, 175000, },
	[80719]  = { nil, 1,  4,  80719,  58085, 500, 505, 510, 515,  1,  1, { 52329, 52983, 52987, 3371, }, { 8, 8, 8, 1, }, true, 200000, },
	[80724]  = { nil, 1,  4,  80724,  58149, 500, 505, 510, 515,  1,  1, { 52983, 52984, 52985, 52988, 52987, 3371, }, { 8, 8, 8, 8, 8, 1, }, true, 200000, },
	[94162]  = { nil, 1,  4,  94162,  67438, 500, 505, 510, 515,  1,  1, { 52329, 52984, 52986, 3371, }, { 8, 8, 8, 1, }, true, 200000, },
	[80508]  = { nil, 1,  4,  80508,  58483, 500, 510, 512, 515,  1,  1, { 52329, 52983, 52985, 52986, }, { 50, 12, 12, 12, }, true, 100000, },
	[96252]  = { nil, 1,  4,  96252,  68775, 500, 510, 512, 515,  1,  1, { 52329, 52983, 52986, }, { 50, 12, 24, }, true, 100000, },
	[96253]  = { nil, 1,  4,  96253,  68776, 500, 510, 512, 515,  1,  1, { 52329, 52983, 52986, }, { 50, 24, 12, }, true, 100000, },
	[96254]  = { nil, 1,  4,  96254,  68777, 500, 510, 512, 515,  1,  1, { 52329, 52983, 52985, 52986, }, { 50, 8, 20, 8, }, true, 100000, },
	[80251]  = { nil, 1,  4,  80251,  52192, 505, 510, 515, 520,  1,  1, { 52182, 52984, }, { 3, 3, }, true, 200000, },
	[80720]  = { nil, 1,  4,  80720,  58086, 505, 510, 515, 520,  1,  1, { 52329, 52985, 52987, 3371, }, { 8, 8, 8, 1, }, true, 200000, },
	[80250]  = { nil, 1,  4,  80250,  52193, 510, 515, 520, 525,  1,  1, { 52181, 52983, }, { 3, 3, }, true, 200000, },
	[80721]  = { nil, 1,  4,  80721,  58087, 510, 515, 520, 525,  1,  1, { 52329, 52985, 52988, 3371, }, { 8, 8, 8, 1, }, true, 200000, },
	[80723]  = { nil, 1,  4,  80723,  58088, 510, 515, 520, 525,  1,  1, { 52329, 52983, 52988, 3371, }, { 8, 8, 8, 1, }, true, 200000, },
	[80246]  = { nil, 1,  4,  80246,  52191, 515, 520, 525, 530,  1,  1, { 52178, 52985, }, { 3, 3, }, true, 200000, },
	[80248]  = { nil, 1,  4,  80248,  52194, 515, 520, 525, 530,  1,  1, { 52180, 52987, }, { 3, 3, }, true, 200000, },
	[80244]  = { nil, 1,  4,  80244,  51950, 520, 525, 530, 535,  3,  3, { 52186, 52327, }, { 1, 1, }, true, 200000, },
	[80247]  = { nil, 1,  4,  80247,  52195, 520, 525, 530, 535,  1,  1, { 52179, 52988, }, { 3, 3, }, true, 200000, },
	[92643]  = { nil, 1,  4,  92643,  62288, 525, 525, 525, 525,  1,  1, { 58085, 58086, 58087, 58088, 58142, }, { 1, 1, 1, 1, 8, }, nil, nil, { 65435, }, },
	[92688]  = { nil, 1,  4,  92688,  65460, 525, 525, 525, 525,  1,  1, { 58085, 58086, 58087, 58088, }, { 3, 3, 3, 3, }, nil, nil, { 65498, }, },
	[80237]  = { nil, 1,  4,  80237,  52303, 525, 525, 530, 535,  2,  2, { 52179, 52180, 52178, 52177, 52181, 52182, }, { 3, 3, 3, 3, 3, 3, }, true, 250000, },
	[80243]  = { nil, 1,  4,  80243,  58480, 525, 525, 530, 535,  1,  1, { 51950, 52325, 52328, 52326, }, { 3, 10, 10, 10, }, true, 250000, },
	[80245]  = { nil, 1,  4,  80245,  52190, 525, 525, 530, 535,  1,  1, { 52177, 52986, }, { 3, 3, }, true, 250000, },
	[80725]  = { nil, 1,  4,  80725,  58487, 525, 525, 530, 535,  1,  1, { 52986, 3371, }, { 5, 1, }, true, 250000, },
	[80726]  = { nil, 1,  4,  80726,  58488, 525, 525, 530, 535,  1,  1, { 52983, 52984, 52986, 52988, 3371, }, { 8, 4, 6, 4, 1, }, true, 250000, },
	[93328]  = { nil, 1,  4,  93328,  65891, 525, 525, 530, 535,  1,  1, { 65892, 65893, 58480, 58087, 58088, 56850, }, { 1, 8, 12, 8, 8, 8, }, nil, nil, { 67538, }, },
	[37836]  = { nil, 1,  6,  37836,  30816,   1,  30,  35,  40,  1,  1, { 30817, 2678, }, { 1, 1, }, true, 10, },
	[65454]  = { nil, 1,  6,  65454,  46691,   1,  30,  35,  40,  1,  1, { 30817, 1179, }, { 1, 1, }, nil, nil, { 46710, }, },
	[2538]   = { nil, 1,  6,   2538,   2679,   1,  45,  65,  85,  1,  1, { 2672, }, { 1, }, },
	[2540]   = { nil, 1,  6,   2540,   2681,   1,  45,  65,  85,  1,  1, { 769, }, { 1, }, },
	[7751]   = { nil, 1,  6,   7751,   6290,   1,  45,  65,  85,  1,  1, { 6291, }, { 1, }, nil, nil, { 6325, }, },
	[7752]   = { nil, 1,  6,   7752,    787,   1,  45,  65,  85,  1,  1, { 6303, }, { 1, }, nil, nil, { 6326, }, },
	[8604]   = { nil, 1,  6,   8604,   6888,   1,  45,  65,  85,  1,  1, { 6889, }, { 1, }, nil, nil, { 6891, }, },
	[15935]  = { nil, 1,  6,  15935,  12224,   1,  45,  65,  85,  1,  1, { 12223, }, { 1, }, nil, nil, { 12226, }, },
	[21143]  = { nil, 1,  6,  21143,  17197,   1,  45,  65,  85,  1,  1, { 6889, 17194, }, { 1, 1, }, nil, nil, { 17200, }, },
	[33276]  = { nil, 1,  6,  33276,  27635,   1,  45,  65,  85,  1,  1, { 27668, }, { 1, }, nil, nil, { 27685, }, },
	[33277]  = { nil, 1,  6,  33277,  24105,   1,  45,  65,  85,  1,  1, { 23676, }, { 1, }, nil, nil, { 27686, }, },
	[43779]  = { nil, 1,  6,  43779,  33924,   1,  50,  62,  75,  1,  1, { 30817, 1179, 2678, 6889, 2593, 785, }, { 8, 4, 4, 8, 1, 3, }, nil, nil, { 33925, }, },
	[62050]  = { nil, 1,  6,  62050,  44837,   1,  90, 102, 115,  1,  1, { 30816, 44835, }, { 1, 1, }, nil, nil, { 44860, }, },
	[66038]  = { nil, 1,  6,  66038,  44837,   1,  90, 102, 115,  1,  1, { 30816, 44835, }, { 1, 1, }, nil, nil, { 46803, }, },
	[6417]   = { nil, 1,  6,   6417,   5478,   1, 130, 150, 170,  2,  2, { 5051, }, { 1, }, nil, nil, { 44977, }, },
	[2539]   = { nil, 1,  6,   2539,   2680,  10,  50,  70,  90,  1,  1, { 2672, }, { 1, }, true, 50, },
	[6412]   = { nil, 1,  6,   6412,   5472,  10,  50,  70,  90,  1,  1, { 5465, }, { 1, }, true, 50, { 5482, }, },
	[2795]   = { nil, 1,  6,   2795,   2888,  10,  60,  80, 100,  1,  1, { 2886, }, { 1, }, nil, nil, { 2889, }, },
	[6413]   = { nil, 1,  6,   6413,   5473,  20,  60,  80, 100,  1,  1, { 5466, }, { 1, }, nil, nil, { 5483, }, },
	[6414]   = { nil, 1,  6,   6414,   5474,  35,  75,  95, 115,  2,  2, { 5467, }, { 1, }, nil, nil, { 5484, }, },
	[21144]  = { nil, 1,  6,  21144,  17198,  35,  75,  95, 115,  1,  1, { 6889, 1179, 17196, 17194, }, { 1, 1, 1, 1, }, nil, nil, { 17201, }, },
	[8607]   = { nil, 1,  6,   8607,   6890,  40,  80, 100, 120,  1,  1, { 3173, }, { 1, }, nil, nil, { 6892, }, },
	[93741]  = { nil, 1,  6,  93741,  67230,  40,  80, 100, 120,  1,  1, { 67229, }, { 1, }, true, 80, },
	[2541]   = { nil, 1,  6,   2541,   2684,  50,  90, 110, 130,  1,  1, { 2673, }, { 1, }, true, 100, },
	[2542]   = { nil, 1,  6,   2542,    724,  50,  90, 110, 130,  1,  1, { 723, }, { 1, }, nil, nil, { 2697, }, },
	[6415]   = { nil, 1,  6,   6415,   5476,  50,  90, 110, 130,  2,  2, { 5468, }, { 1, }, true, 100, { 5485, }, },
	[6416]   = { nil, 1,  6,   6416,   5477,  50,  90, 110, 130,  2,  2, { 5469, }, { 1, }, nil, nil, { 5486, }, },
	[6499]   = { nil, 1,  6,   6499,   5525,  50,  90, 110, 130,  1,  1, { 5503, 159, }, { 1, 1, }, true, 100, },
	[7753]   = { nil, 1,  6,   7753,   4592,  50,  90, 110, 130,  1,  1, { 6289, }, { 1, }, nil, nil, { 6328, }, },
	[7754]   = { nil, 1,  6,   7754,   6316,  50,  90, 110, 130,  1,  1, { 6317, }, { 1, }, nil, nil, { 6329, }, },
	[7827]   = { nil, 1,  6,   7827,   5095,  50,  90, 110, 130,  1,  1, { 6361, }, { 1, }, nil, nil, { 6368, }, },
	[33278]  = { nil, 1,  6,  33278,  27636,  50,  90, 110, 130,  1,  1, { 27669, }, { 1, }, nil, nil, { 27687, }, },
	[2543]   = { nil, 1,  6,   2543,    733,  50, 115, 135, 155,  2,  2, { 769, 159, }, { 1, 1, }, nil, nil, { 728, }, },
	[3371]   = { nil, 1,  6,   3371,   3220,  60, 100, 120, 140,  2,  2, { 3173, }, { 1, }, nil, nil, { 3679, }, },
	[9513]   = { nil, 1,  6,   9513,   7676,  60, 100, 120, 140,  1,  1, { 2452, 159, }, { 1, 1, }, nil, nil, { 7678, 18160, }, },
	[28267]  = { nil, 1,  6,  28267,  22645,  60, 100, 120, 140,  1,  1, { 22644, }, { 1, }, nil, nil, { 22647, }, },
	[2544]   = { nil, 1,  6,   2544,   2683,  75, 115, 135, 155,  1,  1, { 2674, }, { 1, }, true, 200, },
	[2546]   = { nil, 1,  6,   2546,   2687,  80, 120, 140, 160,  1,  1, { 2677, }, { 1, }, true, 150, },
	[3370]   = { nil, 1,  6,   3370,   3662,  80, 120, 140, 160,  1,  1, { 2924, }, { 1, }, nil, nil, { 3678, }, },
	[25704]  = { nil, 1,  6,  25704,  21072,  80, 120, 140, 160,  1,  1, { 21071, }, { 1, }, nil, nil, { 21099, }, },
	[2545]   = { nil, 1,  6,   2545,   2682,  85, 125, 145, 165,  1,  1, { 2675, }, { 1, }, nil, nil, { 2698, }, },
	[8238]   = { nil, 1,  6,   8238,   6657,  85, 125, 145, 165,  1,  1, { 6522, }, { 1, }, nil, nil, { 6661, }, },
	[3372]   = { nil, 1,  6,   3372,   3663,  90, 130, 150, 170,  1,  1, { 1468, }, { 2, }, nil, nil, { 3680, }, },
	[6501]   = { nil, 1,  6,   6501,   5526,  90, 130, 150, 170,  1,  1, { 5503, 1179, }, { 1, 1, }, nil, nil, { 5528, }, },
	[45695]  = { nil, 1,  6,  45695,  34832, 100, 100, 105, 110,  5,  5, { 2596, 2594, }, { 1, 1, }, nil, nil, { 34834, }, },
	[2547]   = { nil, 1,  6,   2547,   1082, 100, 135, 155, 175,  1,  1, { 1080, }, { 1, }, nil, nil, { 2699, }, },
	[2549]   = { nil, 1,  6,   2549,   1017, 100, 140, 160, 180,  3,  3, { 1015, }, { 2, }, nil, nil, { 2701, }, },
	[6418]   = { nil, 1,  6,   6418,   5479, 100, 140, 160, 180,  2,  2, { 5470, }, { 1, }, nil, nil, { 5488, }, },
	[7755]   = { nil, 1,  6,   7755,   4593, 100, 140, 160, 180,  1,  1, { 6308, }, { 1, }, nil, nil, { 6330, }, },
	[62044]  = { nil, 1,  6,  62044,  44836, 100, 150, 162, 175,  1,  1, { 46784, 44853, }, { 1, 1, }, nil, nil, { 44862, }, },
	[66036]  = { nil, 1,  6,  66036,  44836, 100, 150, 162, 175,  1,  1, { 46796, 44853, }, { 1, 1, }, nil, nil, { 46804, }, },
	[2548]   = { nil, 1,  6,   2548,   2685, 110, 130, 150, 170,  1,  1, { 2677, }, { 2, }, nil, nil, { 2700, 44851, }, },
	[3377]   = { nil, 1,  6,   3377,   3666, 110, 150, 170, 190,  1,  1, { 2251, }, { 2, }, nil, nil, { 3683, }, },
	[3397]   = { nil, 1,  6,   3397,   3726, 110, 150, 170, 190,  1,  1, { 3730, }, { 1, }, nil, nil, { 3734, }, },
	[6419]   = { nil, 1,  6,   6419,   5480, 110, 150, 170, 190,  2,  2, { 5471, }, { 1, }, nil, nil, { 5489, }, },
	[3373]   = { nil, 1,  6,   3373,   3664, 120, 160, 180, 200,  1,  1, { 3667, }, { 1, }, nil, nil, { 3681, }, },
	[6500]   = { nil, 1,  6,   6500,   5527, 125, 165, 185, 205,  1,  1, { 5504, }, { 1, }, true, 300, },
	[15853]  = { nil, 1,  6,  15853,  12209, 125, 165, 185, 205,  1,  1, { 1015, }, { 1, }, nil, nil, { 12227, }, },
	[3398]   = { nil, 1,  6,   3398,   3727, 125, 175, 195, 215,  1,  1, { 3731, }, { 1, }, nil, nil, { 3735, }, },
	[3376]   = { nil, 1,  6,   3376,   3665, 130, 170, 190, 210,  1,  1, { 3685, }, { 1, }, nil, nil, { 3682, }, },
	[24418]  = { nil, 1,  6,  24418,  20074, 150, 160, 180, 200,  1,  1, { 3667, }, { 2, }, nil, nil, { 20075, }, },
	[3399]   = { nil, 1,  6,   3399,   3728, 150, 190, 210, 230,  1,  1, { 3731, }, { 2, }, true, 450, { 3736, }, },
	[62049]  = { nil, 1,  6,  62049,  44840, 160, 210, 222, 235,  1,  1, { 44854, 44853, }, { 1, 1, }, nil, nil, { 44858, }, },
	[66035]  = { nil, 1,  6,  66035,  44840, 160, 210, 222, 235,  1,  1, { 46793, 44853, }, { 1, 1, }, nil, nil, { 46805, }, },
	[13028]  = { nil, 1,  6,  13028,  10841, 175, 175, 190, 205,  4,  4, { 3821, 159, }, { 1, 1, }, },
	[7828]   = { nil, 1,  6,   7828,   4594, 175, 190, 210, 230,  1,  1, { 6362, }, { 1, }, nil, nil, { 6369, }, },
	[3400]   = { nil, 1,  6,   3400,   3729, 175, 215, 235, 255,  1,  1, { 3712, }, { 1, }, true, 500, { 3737, }, },
	[4094]   = { nil, 1,  6,   4094,   4457, 175, 215, 235, 255,  1,  1, { 3404, }, { 1, }, true, 500, { 4609, }, },
	[7213]   = { nil, 1,  6,   7213,   6038, 175, 215, 235, 255,  1,  1, { 4655, }, { 1, }, nil, nil, { 6039, }, },
	[15855]  = { nil, 1,  6,  15855,  12210, 175, 215, 235, 255,  1,  1, { 12184, }, { 1, }, nil, nil, { 12228, }, },
	[15856]  = { nil, 1,  6,  15856,  13851, 175, 215, 235, 255,  1,  1, { 12203, }, { 1, }, nil, nil, { 12229, 44851, }, },
	[15861]  = { nil, 1,  6,  15861,  12212, 175, 215, 235, 255,  2,  2, { 12202, 159, }, { 1, 1, }, nil, nil, { 12231, }, },
	[15863]  = { nil, 1,  6,  15863,  12213, 175, 215, 235, 255,  1,  1, { 12037, }, { 1, }, nil, nil, { 12232, }, },
	[15865]  = { nil, 1,  6,  15865,  12214, 175, 215, 235, 255,  1,  1, { 12037, 2596, }, { 1, 1, }, nil, nil, { 12233, }, },
	[20916]  = { nil, 1,  6,  20916,   8364, 175, 215, 235, 255,  1,  1, { 8365, }, { 1, }, nil, nil, { 17062, }, },
	[25954]  = { nil, 1,  6,  25954,  21217, 175, 215, 235, 255,  1,  1, { 21153, }, { 1, }, nil, nil, { 21219, }, },
	[15906]  = { nil, 1,  6,  15906,  12217, 200, 225, 237, 250,  1,  1, { 12037, 4402, }, { 1, 1, }, nil, nil, { 12239, }, },
	[15910]  = { nil, 1,  6,  15910,  12215, 200, 225, 237, 250,  2,  2, { 12204, }, { 2, }, nil, nil, { 12240, }, },
	[21175]  = { nil, 1,  6,  21175,  17222, 200, 225, 237, 250,  1,  1, { 12205, }, { 2, }, true, 4000, },
	[62051]  = { nil, 1,  6,  62051,  44839, 220, 270, 282, 295,  1,  1, { 44855, 44853, 44835, }, { 1, 1, 1, }, nil, nil, { 44859, }, },
	[66034]  = { nil, 1,  6,  66034,  44839, 220, 270, 282, 295,  1,  1, { 46797, 44853, 44835, }, { 1, 1, 1, }, nil, nil, { 46806, }, },
	[15915]  = { nil, 1,  6,  15915,  12216, 225, 250, 262, 275,  1,  1, { 12206, }, { 1, }, nil, nil, { 16111, }, },
	[15933]  = { nil, 1,  6,  15933,  12218, 225, 250, 262, 275,  1,  1, { 12207, }, { 1, }, nil, nil, { 16110, }, },
	[18238]  = { nil, 1,  6,  18238,   6887, 225, 250, 262, 275,  1,  1, { 4603, }, { 1, }, true, 5000, { 13939, }, },
	[18239]  = { nil, 1,  6,  18239,  13927, 225, 250, 262, 275,  1,  1, { 13754, }, { 1, }, nil, nil, { 13940, }, },
	[18241]  = { nil, 1,  6,  18241,  13930, 225, 250, 262, 275,  1,  1, { 13758, }, { 1, }, nil, nil, { 13941, }, },
	[20626]  = { nil, 1,  6,  20626,  16766, 225, 250, 262, 275,  2,  2, { 7974, }, { 2, }, nil, nil, { 16767, }, },
	[22480]  = { nil, 1,  6,  22480,  18045, 225, 250, 262, 275,  1,  1, { 12208, }, { 1, }, nil, nil, { 18046, }, },
	[18240]  = { nil, 1,  6,  18240,  13928, 240, 265, 277, 290,  1,  1, { 13755, }, { 1, }, true, 6000, { 13942, }, },
	[18242]  = { nil, 1,  6,  18242,  13929, 240, 265, 277, 290,  1,  1, { 13756, }, { 1, }, nil, nil, { 13943, }, },
	[64054]  = { nil, 1,  6,  64054,  33004, 250, 250, 275, 300,  1,  1, { 7974, }, { 1, }, },
	[18243]  = { nil, 1,  6,  18243,  13931, 250, 275, 285, 295,  1,  1, { 13759, 159, }, { 1, 1, }, true, 6500, { 13945, }, },
	[18244]  = { nil, 1,  6,  18244,  13932, 250, 275, 285, 295,  1,  1, { 13760, }, { 1, }, true, 6500, { 13946, }, },
	[46684]  = { nil, 1,  6,  46684,  35563, 250, 275, 285, 295,  1,  1, { 35562, }, { 1, }, true, 6500, { 35564, }, },
	[46688]  = { nil, 1,  6,  46688,  35565, 250, 275, 285, 295,  1,  1, { 35562, }, { 1, }, true, 6500, { 35566, }, },
	[18245]  = { nil, 1,  6,  18245,  13933, 275, 300, 312, 325,  1,  1, { 13888, 159, }, { 1, 1, }, nil, nil, { 13947, }, },
	[18246]  = { nil, 1,  6,  18246,  13934, 275, 300, 312, 325,  1,  1, { 13893, }, { 1, }, nil, nil, { 13948, }, },
	[18247]  = { nil, 1,  6,  18247,  13935, 275, 300, 312, 325,  1,  1, { 13889, }, { 1, }, nil, nil, { 13949, }, },
	[22761]  = { nil, 1,  6,  22761,  18254, 275, 300, 312, 325,  1,  1, { 18255, }, { 1, }, nil, nil, { 18267, }, },
	[62045]  = { nil, 1,  6,  62045,  44838, 280, 405, 417, 430,  1,  1, { 44834, 44853, 44835, }, { 1, 2, 1, }, nil, nil, { 44861, }, },
	[66037]  = { nil, 1,  6,  66037,  44838, 280, 405, 417, 430,  1,  1, { 44834, 44853, 44835, }, { 1, 2, 1, }, nil, nil, { 46807, }, },
	[24801]  = { nil, 1,  6,  24801,  20452, 285, 310, 322, 335,  1,  1, { 20424, }, { 1, }, },
	[33279]  = { nil, 1,  6,  33279,  27651, 300, 320, 330, 340,  1,  1, { 27671, }, { 1, }, nil, nil, { 27684, }, },
	[33284]  = { nil, 1,  6,  33284,  27655, 300, 320, 330, 340,  1,  1, { 27674, }, { 1, }, nil, nil, { 27688, }, },
	[33290]  = { nil, 1,  6,  33290,  27661, 300, 320, 330, 340,  1,  1, { 27422, }, { 1, }, nil, nil, { 27694, }, },
	[33291]  = { nil, 1,  6,  33291,  27662, 300, 320, 330, 340,  1,  1, { 27425, }, { 1, }, nil, nil, { 27695, }, },
	[36210]  = { nil, 1,  6,  36210,  30155, 300, 320, 330, 340,  1,  1, { 24477, }, { 2, }, nil, nil, { 30156, }, },
	[43758]  = { nil, 1,  6,  43758,  33866, 300, 320, 330, 340,  1,  1, { 27678, 13757, }, { 1, 1, }, nil, nil, { 33871, }, },
	[43761]  = { nil, 1,  6,  43761,  33867, 300, 320, 330, 340,  1,  1, { 33823, }, { 1, }, nil, nil, { 33869, }, },
	[25659]  = { nil, 1,  6,  25659,  21023, 300, 325, 337, 350,  5,  5, { 9061, 8150, 21024, }, { 1, 1, 1, }, nil, nil, { 21025, }, },
	[43772]  = { nil, 1,  6,  43772,  33874, 300, 345, 355, 365,  1,  1, { 27671, }, { 1, }, nil, nil, { 33875, }, },
	[33292]  = { nil, 1,  6,  33292,  27663, 310, 330, 340, 350,  1,  1, { 27429, }, { 1, }, nil, nil, { 27696, }, },
	[33286]  = { nil, 1,  6,  33286,  27657, 315, 335, 345, 355,  1,  1, { 27677, }, { 1, }, nil, nil, { 27690, }, },
	[42296]  = { nil, 1,  6,  42296,  33048, 320, 335, 345, 355,  1,  1, { 27422, }, { 1, }, true, 15000, },
	[33293]  = { nil, 1,  6,  33293,  27664, 320, 340, 350, 360,  1,  1, { 27435, }, { 1, }, nil, nil, { 27697, }, },
	[33294]  = { nil, 1,  6,  33294,  27665, 320, 340, 350, 360,  1,  1, { 27437, }, { 1, }, nil, nil, { 27698, }, },
	[45022]  = { nil, 1,  6,  45022,  34411, 325, 325, 325, 325,  2,  2, { 34412, 17196, 17194, }, { 1, 1, 1, }, nil, nil, { 34413, }, },
	[43707]  = { nil, 1,  6,  43707,  33825, 325, 335, 345, 355,  1,  1, { 33824, }, { 1, }, nil, nil, { 33870, }, },
	[43765]  = { nil, 1,  6,  43765,  33872, 325, 335, 345, 355,  1,  1, { 27682, }, { 1, }, nil, nil, { 33873, }, },
	[33287]  = { nil, 1,  6,  33287,  27658, 325, 345, 355, 365,  1,  1, { 27678, }, { 1, }, nil, nil, { 27691, }, },
	[33288]  = { nil, 1,  6,  33288,  27659, 325, 345, 355, 365,  1,  1, { 27681, }, { 1, }, nil, nil, { 27692, }, },
	[33289]  = { nil, 1,  6,  33289,  27660, 325, 345, 355, 365,  1,  1, { 27682, }, { 1, }, nil, nil, { 27693, }, },
	[33295]  = { nil, 1,  6,  33295,  27666, 325, 345, 355, 365,  1,  1, { 27438, }, { 1, }, nil, nil, { 27699, }, },
	[38867]  = { nil, 1,  6,  38867,  31672, 335, 355, 365, 375,  1,  1, { 31670, }, { 1, }, nil, nil, { 31675, }, },
	[38868]  = { nil, 1,  6,  38868,  31673, 335, 355, 365, 375,  1,  1, { 31671, }, { 1, }, nil, nil, { 31674, }, },
	[58512]  = { nil, 1,  6,  58512,  43490, 350, 350, 357, 365,  5,  5, { 30817, 43501, }, { 2, 1, }, nil, nil, { 43507, }, },
	[58521]  = { nil, 1,  6,  58521,  43488, 350, 350, 357, 365,  5,  5, { 34736, }, { 1, }, nil, nil, { 43508, }, },
	[58523]  = { nil, 1,  6,  58523,  43491, 350, 350, 357, 365,  5,  5, { 36782, 22577, }, { 1, 1, }, nil, nil, { 43509, }, },
	[58525]  = { nil, 1,  6,  58525,  43492, 350, 350, 357, 365,  5,  5, { 41810, 12808, }, { 1, 1, }, nil, nil, { 43510, }, },
	[45560]  = { nil, 1,  6,  45560,  34759, 350, 350, 365, 380,  1,  1, { 41803, }, { 1, }, true, 10000, },
	[45561]  = { nil, 1,  6,  45561,  34760, 350, 350, 365, 380,  1,  1, { 41808, }, { 1, }, true, 10000, },
	[45562]  = { nil, 1,  6,  45562,  34761, 350, 350, 365, 380,  1,  1, { 41812, }, { 1, }, true, 10000, },
	[57421]  = { nil, 1,  6,  57421,  34747, 350, 350, 365, 380,  1,  1, { 43013, }, { 1, }, },
	[45549]  = { nil, 1,  6,  45549,  34748, 350, 350, 382, 415,  1,  1, { 34736, }, { 1, }, true, 20000, },
	[45550]  = { nil, 1,  6,  45550,  34749, 350, 350, 382, 415,  1,  1, { 43009, }, { 1, }, true, 20000, },
	[45551]  = { nil, 1,  6,  45551,  34750, 350, 350, 382, 415,  1,  1, { 43010, }, { 1, }, true, 20000, },
	[45552]  = { nil, 1,  6,  45552,  34751, 350, 350, 382, 415,  1,  1, { 43011, }, { 1, }, true, 20000, },
	[45553]  = { nil, 1,  6,  45553,  34752, 350, 350, 382, 415,  1,  1, { 43012, }, { 1, }, true, 20000, },
	[45563]  = { nil, 1,  6,  45563,  34762, 350, 350, 382, 415,  1,  1, { 41806, }, { 1, }, true, 20000, },
	[45564]  = { nil, 1,  6,  45564,  34763, 350, 350, 382, 415,  1,  1, { 41809, }, { 1, }, true, 20000, },
	[45565]  = { nil, 1,  6,  45565,  34764, 350, 350, 382, 415,  1,  1, { 41813, }, { 1, }, true, 20000, },
	[45566]  = { nil, 1,  6,  45566,  34765, 350, 350, 382, 415,  1,  1, { 41810, }, { 1, }, true, 20000, },
	[45569]  = { nil, 1,  6,  45569,  42942, 350, 350, 382, 415,  1,  1, { 41802, }, { 1, }, true, 20000, },
	[58065]  = { nil, 1,  6,  58065,  43268, 350, 350, 382, 415,  1,  1, { 36782, }, { 2, }, true, 20000, },
	[33296]  = { nil, 1,  6,  33296,  27667, 350, 370, 375, 380,  1,  1, { 27439, }, { 1, }, nil, nil, { 27700, }, },
	[42302]  = { nil, 1,  6,  42302,  33052, 350, 375, 380, 385,  6,  6, { 27515, }, { 1, }, true, 20000, },
	[42305]  = { nil, 1,  6,  42305,  33053, 350, 375, 380, 385,  2,  2, { 27516, }, { 1, }, true, 20000, },
	[53056]  = { nil, 1,  6,  53056,  39520, 350, 375, 387, 400,  5,  5, { 35949, 35948, }, { 2, 1, }, nil, nil, { 39644, }, },
	[45554]  = { nil, 1,  6,  45554,  34753, 375, 375, 400, 425,  1,  1, { 34736, 43009, 43010, 43013, }, { 1, 1, 1, 2, }, true, 50000, },
	[62350]  = { nil, 1,  6,  62350,  44953, 400, 400, 405, 460,  1,  1, { 43011, 43007, }, { 2, 1, }, nil, nil, { 44954, }, },
	[64358]  = { nil, 1,  6,  64358,  45932, 400, 400, 412, 425,  1,  1, { 41805, }, { 3, }, true, 50000, },
	[45555]  = { nil, 1,  6,  45555,  34754, 400, 425, 450, 475,  1,  1, { 34736, 43007, }, { 2, 1, }, nil, nil, { 43018, }, },
	[45556]  = { nil, 1,  6,  45556,  34755, 400, 425, 450, 475,  1,  1, { 43009, 43007, }, { 2, 1, }, nil, nil, { 43019, }, },
	[45557]  = { nil, 1,  6,  45557,  34756, 400, 425, 450, 475,  1,  1, { 43010, 43007, }, { 2, 1, }, nil, nil, { 43020, }, },
	[45558]  = { nil, 1,  6,  45558,  34757, 400, 425, 450, 475,  1,  1, { 43011, 43007, }, { 1, 1, }, nil, nil, { 43021, }, },
	[45559]  = { nil, 1,  6,  45559,  34758, 400, 425, 450, 475,  1,  1, { 43012, 43007, }, { 2, 1, }, nil, nil, { 43022, }, },
	[45567]  = { nil, 1,  6,  45567,  34766, 400, 425, 450, 475,  1,  1, { 41806, 43007, }, { 1, 1, }, nil, nil, { 43023, }, },
	[45568]  = { nil, 1,  6,  45568,  34767, 400, 425, 450, 475,  1,  1, { 41809, 43007, }, { 1, 1, }, nil, nil, { 43024, }, },
	[45570]  = { nil, 1,  6,  45570,  34769, 400, 425, 450, 475,  1,  1, { 41802, 43007, }, { 1, 1, }, nil, nil, { 43026, }, },
	[45571]  = { nil, 1,  6,  45571,  34768, 400, 425, 450, 475,  1,  1, { 41813, 43007, }, { 1, 1, }, nil, nil, { 43025, }, },
	[57433]  = { nil, 1,  6,  57433,  42993, 400, 425, 450, 475,  1,  1, { 41810, 43007, }, { 1, 1, }, nil, nil, { 43027, }, },
	[57434]  = { nil, 1,  6,  57434,  42994, 400, 425, 450, 475,  1,  1, { 43010, 43012, 43007, }, { 1, 1, 1, }, nil, nil, { 43028, }, },
	[57435]  = { nil, 1,  6,  57435,  43004, 400, 425, 450, 475,  4,  4, { 43013, 43007, }, { 2, 1, }, nil, nil, { 43029, }, },
	[57436]  = { nil, 1,  6,  57436,  42995, 400, 425, 450, 475,  1,  1, { 43012, 43007, }, { 1, 1, }, nil, nil, { 43030, }, },
	[57437]  = { nil, 1,  6,  57437,  42996, 400, 425, 450, 475,  1,  1, { 41808, 43007, }, { 3, 1, }, nil, nil, { 43031, }, },
	[57438]  = { nil, 1,  6,  57438,  42997, 400, 425, 450, 475,  1,  1, { 43011, 43007, }, { 1, 1, }, nil, nil, { 43032, }, },
	[57439]  = { nil, 1,  6,  57439,  42998, 400, 425, 450, 475,  1,  1, { 41801, 43007, }, { 1, 1, }, nil, nil, { 43033, }, },
	[57440]  = { nil, 1,  6,  57440,  43005, 400, 425, 450, 475,  1,  1, { 34736, 43007, }, { 1, 1, }, nil, nil, { 43034, }, },
	[57441]  = { nil, 1,  6,  57441,  42999, 400, 425, 450, 475,  1,  1, { 41807, 43007, }, { 1, 1, }, nil, nil, { 43035, }, },
	[57442]  = { nil, 1,  6,  57442,  43000, 400, 425, 450, 475,  1,  1, { 41807, 43007, }, { 1, 1, }, nil, nil, { 43036, }, },
	[57443]  = { nil, 1,  6,  57443,  43001, 400, 425, 450, 475,  1,  1, { 43009, 43007, }, { 1, 1, }, nil, nil, { 43037, }, },
	[88015]  = { nil, 1,  6,  88015,  62790, 415, 430, 435, 440,  4,  4, { 2596, 2595, }, { 2, 1, }, true, 30000, },
	[58527]  = { nil, 1,  6,  58527,  43478, 425, 435, 455, 475,  1,  1, { 41800, 34736, 41803, 43007, }, { 2, 2, 2, 1, }, nil, nil, { 43505, }, },
	[58528]  = { nil, 1,  6,  58528,  43480, 425, 435, 455, 475,  1,  1, { 41813, 43012, 41809, 43007, }, { 2, 2, 2, 1, }, nil, nil, { 43506, }, },
	[88006]  = { nil, 1,  6,  88006,  62676, 425, 450, 457, 465,  1,  1, { 62778, }, { 1, }, true, 35000, },
	[88017]  = { nil, 1,  6,  88017,  62673, 450, 450, 455, 470,  1,  1, { 62785, }, { 1, }, nil, nil, { 65408, }, },
	[57423]  = { nil, 1,  6,  57423,  43015, 450, 455, 460, 465,  1,  1, { 41806, 41809, 41813, 43007, }, { 2, 2, 2, 1, }, nil, nil, { 43017, }, },
	[88022]  = { nil, 1,  6,  88022,  62674, 450, 455, 460, 465,  1,  1, { 58265, 159, }, { 1, 1, }, nil, nil, { 65415, }, },
	[88045]  = { nil, 1,  6,  88045,  62675, 450, 455, 460, 465,  1,  1, { 62786, 159, }, { 1, 1, }, nil, nil, { 65414, }, },
	[88012]  = { nil, 1,  6,  88012,  62655, 450, 465, 477, 490,  1,  1, { 53063, }, { 1, }, nil, nil, { 65411, }, },
	[88024]  = { nil, 1,  6,  88024,  62654, 450, 465, 477, 490,  1,  1, { 53068, }, { 1, }, nil, nil, { 65407, }, },
	[88028]  = { nil, 1,  6,  88028,  62651, 450, 465, 477, 490,  1,  1, { 53067, }, { 1, }, nil, nil, { 65412, }, },
	[88030]  = { nil, 1,  6,  88030,  62657, 450, 465, 477, 490,  1,  1, { 53067, }, { 1, }, nil, nil, { 65416, }, },
	[88035]  = { nil, 1,  6,  88035,  62653, 450, 465, 477, 490,  1,  1, { 62780, }, { 1, }, nil, nil, { 65410, }, },
	[88037]  = { nil, 1,  6,  88037,  62652, 450, 465, 477, 490,  1,  1, { 62779, }, { 1, }, nil, nil, { 65413, }, },
	[88047]  = { nil, 1,  6,  88047,  62656, 450, 465, 477, 490,  1,  1, { 62791, }, { 1, }, nil, nil, { 65406, }, },
	[88021]  = { nil, 1,  6,  88021,  62659, 475, 490, 497, 505,  1,  1, { 62791, }, { 1, }, nil, nil, { 65418, }, },
	[88033]  = { nil, 1,  6,  88033,  62660, 475, 490, 497, 505,  1,  1, { 53064, }, { 1, }, nil, nil, { 65417, }, },
	[88046]  = { nil, 1,  6,  88046,  62658, 475, 490, 497, 505,  1,  1, { 62781, }, { 1, }, nil, nil, { 65419, }, },
	[88018]  = { nil, 1,  6,  88018,  62677, 475, 490, 500, 510,  1,  1, { 53062, }, { 3, }, nil, nil, { 65423, }, },
	[96133]  = { nil, 1,  6,  96133,  68687, 500, 500, 500, 510,  1,  1, { 53069, }, { 3, }, nil, nil, { 68688, }, },
	[88003]  = { nil, 1,  6,  88003,  62661, 500, 515, 520, 525,  1,  1, { 53071, }, { 1, }, nil, nil, { 65426, }, },
	[88004]  = { nil, 1,  6,  88004,  62665, 500, 515, 520, 525,  1,  1, { 62783, }, { 1, }, nil, nil, { 65427, }, },
	[88005]  = { nil, 1,  6,  88005,  62670, 500, 515, 520, 525,  1,  1, { 62784, }, { 1, }, nil, nil, { 65429, }, },
	[88014]  = { nil, 1,  6,  88014,  62664, 500, 515, 520, 525,  1,  1, { 62784, }, { 1, }, nil, nil, { 65430, }, },
	[88016]  = { nil, 1,  6,  88016,  62666, 500, 515, 520, 525,  1,  1, { 53072, }, { 1, }, nil, nil, { 65422, }, },
	[88020]  = { nil, 1,  6,  88020,  62662, 500, 515, 520, 525,  1,  1, { 62782, }, { 1, }, nil, nil, { 65428, }, },
	[88025]  = { nil, 1,  6,  88025,  62663, 500, 515, 520, 525,  1,  1, { 53068, }, { 1, }, nil, nil, { 65409, }, },
	[88031]  = { nil, 1,  6,  88031,  62667, 500, 515, 520, 525,  1,  1, { 53066, }, { 1, }, nil, nil, { 65420, }, },
	[88034]  = { nil, 1,  6,  88034,  62668, 500, 515, 520, 525,  1,  1, { 53066, }, { 1, }, nil, nil, { 65424, }, },
	[88039]  = { nil, 1,  6,  88039,  62671, 500, 515, 520, 525,  1,  1, { 53072, }, { 1, }, nil, nil, { 65421, }, },
	[88042]  = { nil, 1,  6,  88042,  62669, 500, 515, 520, 525,  1,  1, { 53070, }, { 1, }, nil, nil, { 65425, }, },
	[88011]  = { nil, 1,  6,  88011,  62289, 500, 525, 525, 525,  1,  1, { 62782, 62785, }, { 3, 2, }, nil, nil, { 62799, }, },
	[88013]  = { nil, 1,  6,  88013,  62680, 505, 510, 512, 515,  1,  1, { 30817, 62786, }, { 1, 1, }, nil, nil, { 65431, }, },
	[88019]  = { nil, 1,  6,  88019,  62649, 525, 525, 525, 525,  1,  1, { 30817, 60838, }, { 1, 1, }, nil, nil, { 65432, }, },
	[88036]  = { nil, 1,  6,  88036,  62290, 525, 525, 525, 525,  1,  1, { 53064, 53068, 53070, }, { 2, 2, 2, }, nil, nil, { 62800, }, },
	[88044]  = { nil, 1,  6,  88044,  62672, 525, 525, 525, 525,  5,  5, { 58278, 159, }, { 1, 1, }, nil, nil, { 65433, }, },
	[2657]   = { nil, 1,  7,   2657,   2840,   1,  20,  40,  60,  1,  1, { 2770, }, { 1, }, },
	[3304]   = { nil, 1,  7,   3304,   3576,  50,  50,  57,  75,  1,  1, { 2771, }, { 1, }, true, 50, },
	[2659]   = { nil, 1,  7,   2659,   2841,  50,  50,  75, 100,  2,  2, { 2840, 3576, }, { 1, 1, }, true, 200, },
	[2658]   = { nil, 1,  7,   2658,   2842,  65, 100, 105, 110,  1,  1, { 2775, }, { 1, }, true, 200, },
	[3307]   = { nil, 1,  7,   3307,   3575, 100, 100, 125, 150,  1,  1, { 2772, }, { 1, }, true, 500, },
	[3308]   = { nil, 1,  7,   3308,   3577, 115, 150, 155, 160,  1,  1, { 2776, }, { 1, }, true, 600, },
	[3569]   = { nil, 1,  7,   3569,   3859, 125, 125, 130, 135,  1,  1, { 3575, 3857, }, { 1, 1, }, true, 750, },
	[10097]  = { nil, 1,  7,  10097,   3860, 150, 150, 175, 200,  1,  1, { 3858, }, { 1, }, true, 5000, },
	[10098]  = { nil, 1,  7,  10098,   6037, 165, 200, 205, 210,  1,  1, { 7911, }, { 1, }, true, 10000, },
	[16153]  = { nil, 1,  7,  16153,  12359, 200, 200, 245, 290,  1,  1, { 10620, }, { 1, }, true, 20000, },
	[70524]  = { nil, 1,  7,  70524,  12655, 250, 250, 270, 290,  1,  1, { 12359, 11176, }, { 1, 3, }, true, 10000, },
	[29356]  = { nil, 1,  7,  29356,  23445, 275, 275, 300, 325,  1,  1, { 23424, }, { 2, }, true, 40000, },
	[35750]  = { nil, 1,  7,  35750,  22573, 300, 300, 300, 300, 10, 10, { 22452, }, { 1, }, true, 10000, },
	[35751]  = { nil, 1,  7,  35751,  22574, 300, 300, 300, 300, 10, 10, { 21884, }, { 1, }, true, 10000, },
	[14891]  = { nil, 1,  7,  14891,  11371, 300, 300, 305, 310,  1,  1, { 11370, }, { 8, }, },
	[22967]  = { nil, 1,  7,  22967,  17771, 300, 350, 362, 375,  1,  1, { 18562, 12360, 17010, 18567, }, { 1, 10, 1, 3, }, nil, nil, { 44956, }, },
	[29358]  = { nil, 1,  7,  29358,  23446, 325, 325, 332, 340,  1,  1, { 23425, }, { 2, }, true, 40000, },
	[29359]  = { nil, 1,  7,  29359,  23447, 350, 350, 357, 365,  1,  1, { 23427, }, { 2, }, true, 40000, },
	[29360]  = { nil, 1,  7,  29360,  23448, 350, 350, 357, 375,  1,  1, { 23445, 23447, }, { 3, 2, }, true, 40000, },
	[49252]  = { nil, 1,  7,  49252,  36916, 350, 350, 362, 375,  1,  1, { 36909, }, { 1, }, true, 100000, },
	[46353]  = { nil, 1,  7,  46353,  35128, 375, 375, 375, 375,  1,  1, { 23449, 23573, }, { 3, 1, }, nil, nil, { 35273, }, },
	[29361]  = { nil, 1,  7,  29361,  23449, 375, 385, 392, 400,  1,  1, { 23426, }, { 2, }, true, 100000, },
	[29686]  = { nil, 1,  7,  29686,  23573, 375, 385, 392, 400,  1,  1, { 23446, }, { 10, }, true, 100000, },
	[49258]  = { nil, 1,  7,  49258,  36913, 400, 400, 412, 425,  1,  1, { 36912, }, { 2, }, true, 150000, },
	[84038]  = { nil, 1,  7,  84038,  54849, 400, 400, 437, 475,  1,  1, { 53038, }, { 2, }, true, 50000, },
	[55208]  = { nil, 1,  7,  55208,  37663, 450, 450, 450, 450,  1,  1, { 41163, 36860, 35624, 35627, }, { 3, 1, 1, 1, }, true, 200000, },
	[55211]  = { nil, 1,  7,  55211,  41163, 450, 450, 450, 450,  1,  1, { 36910, }, { 2, }, true, 200000, },
	[74530]  = { nil, 1,  7,  74530,  52186, 450, 450, 475, 500,  1,  1, { 52185, }, { 2, }, true, 50000, },
	[74537]  = { nil, 1,  7,  74537,  53039, 475, 475, 500, 525,  1,  1, { 52186, 52327, }, { 10, 4, }, true, 50000, },
	[74529]  = { nil, 1,  7,  74529,  51950, 525, 525, 525, 525,  1,  1, { 52183, }, { 2, }, true, 50000, },
	[2963]   = { nil, 1,  8,   2963,   2996,   1,  25,  37,  50,  1,  1, { 2589, }, { 2, }, },
	[2387]   = { nil, 1,  8,   2387,   2570,   1,  35,  47,  60,  1,  1, { 2996, 2320, }, { 1, 1, }, },
	[2393]   = { nil, 1,  8,   2393,   2576,   1,  35,  47,  60,  1,  1, { 2996, 2320, 2324, }, { 1, 1, 1, }, true, 25, },
	[3915]   = { nil, 1,  8,   3915,   4344,   1,  35,  47,  60,  1,  1, { 2996, 2320, }, { 1, 1, }, },
	[12044]  = { nil, 1,  8,  12044,  10045,   1,  35,  47,  60,  1,  1, { 2996, 2320, }, { 1, 1, }, },
	[2385]   = { nil, 1,  8,   2385,   2568,  10,  45,  57,  70,  1,  1, { 2996, 2320, }, { 1, 1, }, true, 50, },
	[8776]   = { nil, 1,  8,   8776,   7026,  15,  50,  67,  85,  1,  1, { 2996, 2320, }, { 1, 1, }, true, 50, },
	[12045]  = { nil, 1,  8,  12045,  10046,  20,  50,  67,  85,  1,  1, { 2996, 2318, 2320, }, { 2, 1, 1, }, true, 50, },
	[3914]   = { nil, 1,  8,   3914,   4343,  30,  55,  72,  90,  1,  1, { 2996, 2320, }, { 2, 1, }, true, 50, },
	[7623]   = { nil, 1,  8,   7623,   6238,  30,  55,  72,  90,  1,  1, { 2996, 2320, }, { 3, 1, }, true, 50, },
	[7624]   = { nil, 1,  8,   7624,   6241,  30,  55,  72,  90,  1,  1, { 2996, 2320, 2324, }, { 3, 1, 1, }, true, 50, },
	[3840]   = { nil, 1,  8,   3840,   4307,  35,  60,  77,  95,  1,  1, { 2996, 2320, }, { 2, 1, }, true, 100, },
	[2389]   = { nil, 1,  8,   2389,   2572,  40,  65,  82, 100,  1,  1, { 2996, 2320, 2604, }, { 3, 2, 2, }, nil, nil, { 2598, }, },
	[2392]   = { nil, 1,  8,   2392,   2575,  40,  65,  82, 100,  1,  1, { 2996, 2320, 2604, }, { 2, 1, 1, }, true, 50, },
	[2394]   = { nil, 1,  8,   2394,   2577,  40,  65,  82, 100,  1,  1, { 2996, 2320, 6260, }, { 2, 1, 1, }, true, 50, },
	[8465]   = { nil, 1,  8,   8465,   6786,  40,  65,  82, 100,  1,  1, { 2996, 2320, 6260, 2324, }, { 2, 1, 1, 1, }, true, 50, },
	[3755]   = { nil, 1,  8,   3755,   4238,  45,  70,  87, 105,  1,  1, { 2996, 2320, }, { 3, 3, }, true, 100, },
	[7629]   = { nil, 1,  8,   7629,   6239,  55,  80,  97, 115,  1,  1, { 2996, 2320, 2604, }, { 3, 1, 1, }, nil, nil, { 6271, }, },
	[7630]   = { nil, 1,  8,   7630,   6240,  55,  80,  97, 115,  1,  1, { 2996, 2320, 6260, }, { 3, 1, 1, }, nil, nil, { 6270, }, },
	[2397]   = { nil, 1,  8,   2397,   2580,  60,  85, 102, 120,  1,  1, { 2996, 2320, }, { 2, 3, }, true, 200, },
	[3841]   = { nil, 1,  8,   3841,   4308,  60,  85, 102, 120,  1,  1, { 2996, 2320, 2605, }, { 3, 2, 1, }, true, 200, },
	[2386]   = { nil, 1,  8,   2386,   2569,  65,  90, 107, 125,  1,  1, { 2996, 2320, 2318, }, { 3, 1, 1, }, true, 200, },
	[2395]   = { nil, 1,  8,   2395,   2578,  70,  95, 112, 130,  1,  1, { 2996, 2318, 2321, }, { 4, 1, 1, }, true, 300, },
	[2396]   = { nil, 1,  8,   2396,   2579,  70,  95, 112, 130,  1,  1, { 2996, 2321, 2605, }, { 3, 1, 1, }, true, 200, },
	[3842]   = { nil, 1,  8,   3842,   4309,  70,  95, 112, 130,  1,  1, { 2996, 2321, }, { 4, 2, }, true, 300, },
	[6686]   = { nil, 1,  8,   6686,   5762,  70,  95, 112, 130,  1,  1, { 2996, 2321, 2604, }, { 4, 1, 1, }, nil, nil, { 5771, }, },
	[7633]   = { nil, 1,  8,   7633,   6242,  70,  95, 112, 130,  1,  1, { 2996, 2320, 6260, }, { 4, 2, 2, }, nil, nil, { 6272, }, },
	[2964]   = { nil, 1,  8,   2964,   2997,  75,  90,  97, 105,  1,  1, { 2592, }, { 3, }, true, 100, },
	[2402]   = { nil, 1,  8,   2402,   2584,  75, 100, 117, 135,  1,  1, { 2997, 2321, }, { 1, 1, }, true, 250, },
	[12046]  = { nil, 1,  8,  12046,  10047,  75, 100, 117, 135,  1,  1, { 2996, 2321, }, { 4, 1, }, true, 300, },
	[3757]   = { nil, 1,  8,   3757,   4240,  80, 105, 122, 140,  1,  1, { 2997, 2321, }, { 3, 1, }, true, 200, },
	[3845]   = { nil, 1,  8,   3845,   4312,  80, 105, 122, 140,  1,  1, { 2996, 2318, 2321, }, { 5, 2, 1, }, true, 300, },
	[2399]   = { nil, 1,  8,   2399,   2582,  85, 110, 127, 145,  1,  1, { 2997, 2321, 2605, }, { 2, 2, 1, }, true, 300, },
	[3843]   = { nil, 1,  8,   3843,   4310,  85, 110, 127, 145,  1,  1, { 2997, 2321, }, { 3, 1, }, true, 400, },
	[6521]   = { nil, 1,  8,   6521,   5542,  90, 115, 132, 150,  1,  1, { 2997, 2321, 5498, }, { 3, 2, 1, }, true, 400, },
	[7636]   = { nil, 1,  8,   7636,   6243,  90, 115, 132, 150,  1,  1, { 2997, 2321, 2605, }, { 3, 2, 1, }, nil, nil, { 6273, }, },
	[2401]   = { nil, 1,  8,   2401,   2583,  95, 120, 137, 155,  1,  1, { 2997, 2321, 2318, }, { 4, 2, 2, }, true, 300, },
	[3758]   = { nil, 1,  8,   3758,   4241,  95, 120, 137, 155,  1,  1, { 2997, 2605, 2321, }, { 4, 1, 1, }, nil, nil, { 4292, }, },
	[3847]   = { nil, 1,  8,   3847,   4313,  95, 120, 137, 155,  1,  1, { 2997, 2318, 2321, 2604, }, { 4, 2, 1, 2, }, nil, nil, { 4345, }, },
	[2406]   = { nil, 1,  8,   2406,   2587, 100, 110, 120, 130,  1,  1, { 2997, 2321, 4340, }, { 2, 1, 1, }, true, 200, },
	[3844]   = { nil, 1,  8,   3844,   4311, 100, 125, 142, 160,  1,  1, { 2997, 2321, 5498, }, { 3, 2, 2, }, nil, nil, { 4346, }, },
	[7639]   = { nil, 1,  8,   7639,   6263, 100, 125, 142, 160,  1,  1, { 2997, 2321, 6260, }, { 4, 2, 2, }, nil, nil, { 6274, }, },
	[2403]   = { nil, 1,  8,   2403,   2585, 105, 130, 147, 165,  1,  1, { 2997, 2321, 4340, }, { 4, 3, 1, }, nil, nil, { 2601, }, },
	[3848]   = { nil, 1,  8,   3848,   4314, 110, 135, 152, 170,  1,  1, { 2997, 2321, }, { 3, 2, }, true, 500, },
	[3850]   = { nil, 1,  8,   3850,   4316, 110, 135, 152, 170,  1,  1, { 2997, 2321, }, { 5, 4, }, true, 500, },
	[3866]   = { nil, 1,  8,   3866,   4330, 110, 135, 152, 170,  1,  1, { 2997, 2604, 2321, }, { 3, 2, 1, }, true, 250, },
	[8467]   = { nil, 1,  8,   8467,   6787, 110, 135, 152, 170,  1,  1, { 2997, 2324, 2321, }, { 3, 4, 1, }, true, 250, },
	[6688]   = { nil, 1,  8,   6688,   5763, 115, 140, 157, 175,  1,  1, { 2997, 2604, 2321, }, { 4, 1, 1, }, nil, nil, { 5772, }, },
	[7643]   = { nil, 1,  8,   7643,   6264, 115, 140, 157, 175,  1,  1, { 2997, 2321, 2604, }, { 5, 3, 3, }, nil, nil, { 6275, }, },
	[3849]   = { nil, 1,  8,   3849,   4315, 120, 145, 162, 180,  1,  1, { 2997, 2319, 2321, }, { 6, 2, 2, }, nil, nil, { 4347, }, },
	[7892]   = { nil, 1,  8,   7892,   6384, 120, 145, 162, 180,  1,  1, { 2997, 6260, 4340, 2321, }, { 4, 2, 1, 1, }, nil, nil, { 6390, }, },
	[7893]   = { nil, 1,  8,   7893,   6385, 120, 145, 162, 180,  1,  1, { 2997, 2605, 4340, 2321, }, { 4, 2, 1, 1, }, nil, nil, { 6391, }, },
	[12047]  = { nil, 1,  8,  12047,  10048, 120, 145, 162, 180,  1,  1, { 2997, 2604, 2321, }, { 5, 3, 1, }, nil, nil, { 10316, }, },
	[3839]   = { nil, 1,  8,   3839,   4305, 125, 135, 140, 145,  1,  1, { 4306, }, { 4, }, true, 500, },
	[3851]   = { nil, 1,  8,   3851,   4317, 125, 150, 167, 185,  1,  1, { 2997, 5500, 2321, }, { 6, 1, 3, }, nil, nil, { 4349, }, },
	[3855]   = { nil, 1,  8,   3855,   4320, 125, 150, 167, 185,  1,  1, { 4305, 2319, 3182, 5500, }, { 2, 4, 4, 2, }, true, 750, },
	[3868]   = { nil, 1,  8,   3868,   4331, 125, 150, 167, 185,  1,  1, { 2997, 5500, 2321, 2324, }, { 4, 1, 4, 2, }, nil, nil, { 4348, }, },
	[63742]  = { nil, 1,  8,  63742,  45626, 125, 150, 167, 185,  1,  1, { 4305, 3182, 2321, }, { 3, 6, 2, }, true, 750, },
	[3852]   = { nil, 1,  8,   3852,   4318, 130, 150, 165, 180,  1,  1, { 2997, 2321, 3383, }, { 4, 3, 1, }, true, 750, },
	[3869]   = { nil, 1,  8,   3869,   4332, 135, 145, 150, 155,  1,  1, { 4305, 4341, 2321, }, { 1, 1, 1, }, nil, nil, { 14627, }, },
	[6690]   = { nil, 1,  8,   6690,   5766, 135, 155, 170, 185,  1,  1, { 4305, 2321, 3182, }, { 2, 2, 2, }, true, 1000, },
	[3856]   = { nil, 1,  8,   3856,   4321, 140, 160, 175, 190,  1,  1, { 4305, 3182, 2321, }, { 3, 1, 2, }, nil, nil, { 4350, }, },
	[8758]   = { nil, 1,  8,   8758,   7046, 140, 160, 175, 190,  1,  1, { 4305, 6260, 2321, }, { 4, 2, 3, }, true, 600, },
	[8778]   = { nil, 1,  8,   8778,   7027, 140, 160, 175, 190,  1,  1, { 4305, 2319, 6048, 2321, }, { 3, 2, 1, 2, }, nil, nil, { 7093, }, },
	[8760]   = { nil, 1,  8,   8760,   7048, 145, 155, 160, 165,  1,  1, { 4305, 6260, 2321, }, { 2, 2, 1, }, true, 600, },
	[3854]   = { nil, 1,  8,   3854,   4319, 145, 165, 180, 195,  1,  1, { 4305, 4234, 6260, 2321, }, { 3, 2, 2, 2, }, nil, nil, { 7114, }, },
	[8780]   = { nil, 1,  8,   8780,   7047, 145, 165, 180, 195,  1,  1, { 4305, 4234, 6048, 2321, }, { 3, 2, 2, 2, }, nil, nil, { 7092, }, },
	[3813]   = { nil, 1,  8,   3813,   4245, 150, 170, 185, 200,  1,  1, { 4305, 4234, 2321, }, { 3, 2, 3, }, true, 800, },
	[3859]   = { nil, 1,  8,   3859,   4324, 150, 170, 185, 200,  1,  1, { 4305, 6260, }, { 5, 4, }, true, 750, },
	[6692]   = { nil, 1,  8,   6692,   5770, 150, 170, 185, 200,  1,  1, { 4305, 2321, 3182, }, { 4, 2, 2, }, nil, nil, { 5773, }, },
	[8782]   = { nil, 1,  8,   8782,   7049, 150, 170, 185, 200,  1,  1, { 4305, 4234, 929, 2321, }, { 3, 2, 4, 1, }, nil, nil, { 7091, }, },
	[102171] = { nil, 1,  8, 102171,  72101, 150, 170, 185, 200,  1,  1, { 4305, 2325, }, { 5, 4, }, nil, nil, { 72102, }, },
	[3870]   = { nil, 1,  8,   3870,   4333, 155, 165, 170, 175,  1,  1, { 4305, 4340, 2321, }, { 2, 2, 1, }, nil, nil, { 6401, }, },
	[8483]   = { nil, 1,  8,   8483,   6795, 160, 170, 175, 180,  1,  1, { 4305, 2324, 4291, }, { 3, 2, 1, }, true, 500, },
	[8762]   = { nil, 1,  8,   8762,   7050, 160, 170, 175, 180,  1,  1, { 4305, 2321, }, { 3, 2, }, true, 750, },
	[3857]   = { nil, 1,  8,   3857,   4322, 165, 185, 200, 215,  1,  1, { 4305, 2321, 4337, }, { 3, 2, 2, }, nil, nil, { 14630, }, },
	[8784]   = { nil, 1,  8,   8784,   7065, 165, 185, 200, 215,  1,  1, { 4305, 2605, 4291, }, { 5, 2, 1, }, nil, nil, { 7090, }, },
	[3871]   = { nil, 1,  8,   3871,   4334, 170, 180, 185, 190,  1,  1, { 4305, 2324, 2321, }, { 3, 2, 1, }, true, 500, },
	[3858]   = { nil, 1,  8,   3858,   4323, 170, 190, 205, 220,  1,  1, { 4305, 4291, 3824, }, { 4, 1, 1, }, nil, nil, { 4351, }, },
	[8764]   = { nil, 1,  8,   8764,   7051, 170, 190, 205, 220,  1,  1, { 4305, 7067, 2321, }, { 3, 1, 2, }, true, 900, },
	[3865]   = { nil, 1,  8,   3865,   4339, 175, 180, 182, 185,  1,  1, { 4338, }, { 4, }, true, 1000, },
	[8489]   = { nil, 1,  8,   8489,   6796, 175, 185, 190, 195,  1,  1, { 4305, 2604, 4291, }, { 3, 2, 1, }, true, 750, },
	[3860]   = { nil, 1,  8,   3860,   4325, 175, 195, 210, 225,  1,  1, { 4305, 4291, 4337, }, { 4, 1, 2, }, nil, nil, { 4352, }, },
	[6693]   = { nil, 1,  8,   6693,   5764, 175, 195, 210, 225,  1,  1, { 4305, 4234, 2321, 2605, }, { 4, 3, 3, 1, }, nil, nil, { 5774, }, },
	[8766]   = { nil, 1,  8,   8766,   7052, 175, 195, 210, 225,  1,  1, { 4305, 7070, 6260, 2321, 7071, }, { 4, 1, 2, 2, 1, }, true, 1000, },
	[8772]   = { nil, 1,  8,   8772,   7055, 175, 195, 210, 225,  1,  1, { 4305, 7071, 2604, 4291, }, { 4, 1, 2, 1, }, true, 1000, },
	[8786]   = { nil, 1,  8,   8786,   7053, 175, 195, 210, 225,  1,  1, { 4305, 6260, 2321, }, { 3, 2, 2, }, nil, nil, { 7089, }, },
	[3863]   = { nil, 1,  8,   3863,   4328, 180, 200, 215, 230,  1,  1, { 4305, 4337, 7071, }, { 4, 2, 1, }, nil, nil, { 4353, }, },
	[8774]   = { nil, 1,  8,   8774,   7057, 180, 200, 215, 230,  1,  1, { 4305, 4291, }, { 5, 2, }, true, 1000, },
	[8789]   = { nil, 1,  8,   8789,   7056, 180, 200, 215, 230,  1,  1, { 4305, 2604, 6371, 4291, }, { 5, 2, 2, 1, }, nil, nil, { 7087, }, },
	[3872]   = { nil, 1,  8,   3872,   4335, 185, 195, 200, 205,  1,  1, { 4305, 4342, 4291, }, { 4, 1, 1, }, nil, nil, { 4354, }, },
	[8791]   = { nil, 1,  8,   8791,   7058, 185, 205, 215, 225,  1,  1, { 4305, 2604, 2321, }, { 4, 2, 2, }, true, 2500, },
	[3861]   = { nil, 1,  8,   3861,   4326, 185, 205, 220, 235,  1,  1, { 4305, 3827, 4291, }, { 4, 1, 1, }, true, 1000, },
	[6695]   = { nil, 1,  8,   6695,   5765, 185, 205, 220, 235,  1,  1, { 4305, 2325, 2321, }, { 5, 1, 4, }, nil, nil, { 5775, }, },
	[21945]  = { nil, 1,  8,  21945,  17723, 190, 200, 205, 210,  1,  1, { 4305, 2605, 4291, }, { 5, 4, 1, }, nil, nil, { 17724, }, },
	[8770]   = { nil, 1,  8,   8770,   7054, 190, 210, 225, 240,  1,  1, { 4339, 7067, 7070, 7068, 7069, 4291, }, { 2, 2, 2, 2, 2, 2, }, true, 1000, },
	[8793]   = { nil, 1,  8,   8793,   7059, 190, 210, 225, 240,  1,  1, { 4305, 6371, 2604, 4291, }, { 5, 2, 2, 2, }, nil, nil, { 7084, }, },
	[8795]   = { nil, 1,  8,   8795,   7060, 190, 210, 225, 240,  1,  1, { 4305, 7072, 6260, 4291, }, { 6, 2, 2, 2, }, nil, nil, { 7085, }, },
	[8799]   = { nil, 1,  8,   8799,   7062, 195, 215, 225, 235,  1,  1, { 4305, 2604, 4291, }, { 4, 2, 2, }, true, 3000, },
	[8797]   = { nil, 1,  8,   8797,   7061, 195, 215, 230, 245,  1,  1, { 4305, 7067, 4234, 7071, 4291, }, { 5, 4, 4, 1, 2, }, nil, nil, { 7086, }, },
	[3873]   = { nil, 1,  8,   3873,   4336, 200, 210, 215, 220,  1,  1, { 4305, 2325, 4291, }, { 5, 1, 1, }, nil, nil, { 10728, }, },
	[3862]   = { nil, 1,  8,   3862,   4327, 200, 220, 235, 250,  1,  1, { 4339, 4291, 3829, 4337, }, { 3, 2, 1, 2, }, nil, nil, { 4355, }, },
	[3864]   = { nil, 1,  8,   3864,   4329, 200, 220, 235, 250,  1,  1, { 4339, 4234, 3864, 7071, 4291, }, { 4, 4, 1, 1, 1, }, nil, nil, { 4356, }, },
	[8802]   = { nil, 1,  8,   8802,   7063, 205, 220, 235, 250,  1,  1, { 4305, 7068, 3827, 2604, 4291, }, { 8, 4, 2, 4, 1, }, nil, nil, { 7088, }, },
	[12048]  = { nil, 1,  8,  12048,   9998, 205, 220, 235, 250,  1,  1, { 4339, 4291, }, { 2, 3, }, true, 4000, },
	[12049]  = { nil, 1,  8,  12049,   9999, 205, 220, 235, 250,  1,  1, { 4339, 4291, }, { 2, 3, }, true, 4000, },
	[8804]   = { nil, 1,  8,   8804,   7064, 210, 225, 240, 255,  1,  1, { 4305, 7068, 6371, 4304, 2604, 4291, }, { 6, 2, 2, 2, 4, 2, }, true, 5000, },
	[12050]  = { nil, 1,  8,  12050,  10001, 210, 225, 240, 255,  1,  1, { 4339, 8343, }, { 3, 1, }, true, 4000, },
	[12052]  = { nil, 1,  8,  12052,  10002, 210, 225, 240, 255,  1,  1, { 4339, 10285, 8343, }, { 3, 2, 1, }, true, 5000, },
	[12059]  = { nil, 1,  8,  12059,  10008, 215, 220, 225, 230,  1,  1, { 4339, 2324, 8343, }, { 1, 1, 1, }, nil, nil, { 10301, }, },
	[12061]  = { nil, 1,  8,  12061,  10056, 215, 220, 225, 230,  1,  1, { 4339, 6261, 8343, }, { 1, 1, 1, }, true, 2500, },
	[12053]  = { nil, 1,  8,  12053,  10003, 215, 230, 245, 260,  1,  1, { 4339, 8343, }, { 2, 2, }, true, 5000, },
	[12055]  = { nil, 1,  8,  12055,  10004, 215, 230, 245, 260,  1,  1, { 4339, 10285, 8343, }, { 3, 2, 1, }, true, 5500, },
	[12056]  = { nil, 1,  8,  12056,  10007, 215, 230, 245, 260,  1,  1, { 4339, 2604, 8343, }, { 3, 2, 1, }, nil, nil, { 10300, }, },
	[12060]  = { nil, 1,  8,  12060,  10009, 215, 230, 245, 260,  1,  1, { 4339, 2604, 8343, }, { 3, 2, 1, }, nil, nil, { 10302, }, },
	[12064]  = { nil, 1,  8,  12064,  10052, 220, 225, 230, 235,  1,  1, { 4339, 6261, 8343, }, { 2, 2, 1, }, nil, nil, { 10311, }, },
	[12062]  = { nil, 1,  8,  12062,  10010, 220, 235, 250, 265,  1,  1, { 4339, 7079, 8343, }, { 4, 2, 2, }, nil, nil, { 10303, }, },
	[12063]  = { nil, 1,  8,  12063,  10011, 220, 235, 250, 265,  1,  1, { 4339, 7079, 8343, }, { 3, 2, 2, }, nil, nil, { 10304, }, },
	[12065]  = { nil, 1,  8,  12065,  10050, 225, 240, 255, 270,  1,  1, { 4339, 4291, }, { 4, 2, }, true, 5000, },
	[12066]  = { nil, 1,  8,  12066,  10018, 225, 240, 255, 270,  1,  1, { 4339, 2604, 8343, }, { 3, 2, 2, }, nil, nil, { 10312, }, },
	[12067]  = { nil, 1,  8,  12067,  10019, 225, 240, 255, 270,  1,  1, { 4339, 8153, 10286, 8343, }, { 4, 4, 2, 2, }, true, 5000, },
	[12068]  = { nil, 1,  8,  12068,  10020, 225, 240, 255, 270,  1,  1, { 4339, 7079, 8343, }, { 5, 3, 2, }, nil, nil, { 10313, }, },
	[12069]  = { nil, 1,  8,  12069,  10042, 225, 240, 255, 270,  1,  1, { 4339, 7077, 8343, }, { 5, 2, 2, }, true, 5000, },
	[12070]  = { nil, 1,  8,  12070,  10021, 225, 240, 255, 270,  1,  1, { 4339, 8153, 10286, 8343, }, { 6, 6, 2, 2, }, true, 5000, },
	[12071]  = { nil, 1,  8,  12071,  10023, 225, 240, 255, 270,  1,  1, { 4339, 10285, 8343, }, { 5, 5, 2, }, true, 6000, },
	[27658]  = { nil, 1,  8,  27658,  22246, 225, 240, 255, 270,  1,  1, { 4339, 11137, 8343, }, { 4, 4, 2, }, nil, nil, { 22307, }, },
	[12075]  = { nil, 1,  8,  12075,  10054, 230, 235, 240, 245,  1,  1, { 4339, 4342, 8343, }, { 2, 2, 2, }, nil, nil, { 10314, }, },
	[12072]  = { nil, 1,  8,  12072,  10024, 230, 245, 260, 275,  1,  1, { 4339, 8343, }, { 3, 2, }, true, 6000, },
	[12073]  = { nil, 1,  8,  12073,  10026, 230, 245, 260, 275,  1,  1, { 4339, 8343, 4304, }, { 3, 2, 2, }, true, 6000, },
	[12074]  = { nil, 1,  8,  12074,  10027, 230, 245, 260, 275,  1,  1, { 4339, 8343, }, { 3, 2, }, true, 6000, },
	[12077]  = { nil, 1,  8,  12077,  10053, 235, 240, 245, 250,  1,  1, { 4339, 2325, 8343, 2324, }, { 3, 1, 1, 1, }, true, 5000, },
	[12080]  = { nil, 1,  8,  12080,  10055, 235, 240, 245, 250,  1,  1, { 4339, 10290, 8343, }, { 3, 1, 1, }, nil, nil, { 10317, }, },
	[12076]  = { nil, 1,  8,  12076,  10028, 235, 250, 265, 280,  1,  1, { 4339, 10285, 8343, }, { 5, 4, 2, }, true, 6500, },
	[12078]  = { nil, 1,  8,  12078,  10029, 235, 250, 265, 280,  1,  1, { 4339, 2604, 8343, }, { 4, 2, 3, }, nil, nil, { 10315, }, },
	[12079]  = { nil, 1,  8,  12079,  10051, 235, 250, 265, 280,  1,  1, { 4339, 2604, 8343, }, { 4, 2, 2, }, true, 6500, },
	[12085]  = { nil, 1,  8,  12085,  10034, 240, 245, 250, 255,  1,  1, { 4339, 8343, }, { 4, 2, }, nil, nil, { 10321, }, },
	[12081]  = { nil, 1,  8,  12081,  10030, 240, 255, 270, 285,  1,  1, { 4339, 8343, }, { 5, 2, }, nil, nil, { 10318, }, },
	[12082]  = { nil, 1,  8,  12082,  10031, 240, 255, 270, 285,  1,  1, { 4339, 10285, 8343, 4304, }, { 6, 6, 3, 2, }, true, 7000, },
	[12083]  = { nil, 1,  8,  12083,  10032, 240, 255, 270, 285,  1,  1, { 4339, 7079, 8343, }, { 4, 4, 2, }, nil, nil, { 10319, }, },
	[12084]  = { nil, 1,  8,  12084,  10033, 240, 255, 270, 285,  1,  1, { 4339, 2604, 8343, }, { 4, 2, 2, }, nil, nil, { 10320, }, },
	[12089]  = { nil, 1,  8,  12089,  10035, 245, 250, 255, 260,  1,  1, { 4339, 8343, }, { 4, 3, }, nil, nil, { 10323, }, },
	[50647]  = { nil, 1,  8,  50647,  38278, 245, 250, 255, 260,  1,  1, { 4339, 8343, 2325, }, { 4, 3, 3, }, nil, nil, { 38328, }, },
	[12086]  = { nil, 1,  8,  12086,  10025, 245, 260, 275, 290,  1,  1, { 4339, 10285, 8343, }, { 2, 8, 2, }, nil, nil, { 10463, }, },
	[12087]  = { nil, 1,  8,  12087,  10038, 245, 260, 275, 290,  1,  1, { 4339, 7079, 8343, }, { 5, 6, 3, }, nil, nil, { 10322, }, },
	[12088]  = { nil, 1,  8,  12088,  10044, 245, 260, 275, 290,  1,  1, { 4339, 8343, }, { 5, 3, }, true, 7500, },
	[44950]  = { nil, 1,  8,  44950,  34087, 250, 250, 250, 250,  1,  1, { 14048, 2997, 2605, 14341, }, { 4, 1, 2, 1, }, nil, nil, { 34261, }, },
	[44958]  = { nil, 1,  8,  44958,  34085, 250, 250, 250, 250,  1,  1, { 14048, 2997, 2604, 14341, }, { 4, 1, 2, 1, }, nil, nil, { 34319, }, },
	[18401]  = { nil, 1,  8,  18401,  14048, 250, 255, 257, 260,  1,  1, { 14047, }, { 4, }, true, 10000, },
	[12091]  = { nil, 1,  8,  12091,  10040, 250, 255, 260, 265,  1,  1, { 4339, 8343, 2324, }, { 5, 3, 1, }, nil, nil, { 10325, }, },
	[49677]  = { nil, 1,  8,  49677,   6836, 250, 255, 270, 285,  1,  1, { 4339, 4304, }, { 4, 2, }, nil, nil, { 37915, }, },
	[12090]  = { nil, 1,  8,  12090,  10039, 250, 265, 280, 295,  1,  1, { 4339, 7079, 8343, 4304, }, { 6, 6, 3, 2, }, nil, nil, { 10324, }, },
	[12092]  = { nil, 1,  8,  12092,  10041, 250, 265, 280, 295,  1,  1, { 4339, 8153, 10286, 8343, 6037, 1529, }, { 8, 4, 2, 3, 1, 1, }, true, 7500, },
	[12093]  = { nil, 1,  8,  12093,  10036, 250, 265, 280, 295,  1,  1, { 4339, 8343, }, { 5, 3, }, nil, nil, { 10326, }, },
	[26403]  = { nil, 1,  8,  26403,  21154, 250, 265, 280, 295,  1,  1, { 14048, 4625, 2604, 14341, }, { 4, 2, 2, 1, }, nil, nil, { 21722, 44916, }, },
	[26407]  = { nil, 1,  8,  26407,  21542, 250, 265, 280, 295,  1,  1, { 14048, 4625, 2604, 14341, }, { 4, 2, 2, 1, }, nil, nil, { 21723, 44917, }, },
	[50644]  = { nil, 1,  8,  50644,  38277, 250, 265, 280, 295,  1,  1, { 4339, 2325, 2604, 8343, }, { 5, 2, 1, 3, }, nil, nil, { 38327, }, },
	[18560]  = { nil, 1,  8,  18560,  14342, 250, 290, 305, 320,  1,  1, { 14256, }, { 2, }, nil, nil, { 14526, }, },
	[18402]  = { nil, 1,  8,  18402,  13856, 255, 270, 285, 300,  1,  1, { 14048, 14341, }, { 3, 1, }, true, 10000, },
	[18403]  = { nil, 1,  8,  18403,  13869, 255, 270, 285, 300,  1,  1, { 14048, 6260, 14341, }, { 5, 2, 1, }, true, 10000, { 14466, }, },
	[18404]  = { nil, 1,  8,  18404,  13868, 255, 270, 285, 300,  1,  1, { 14048, 7079, 14341, }, { 5, 2, 1, }, nil, nil, { 14467, }, },
	[18405]  = { nil, 1,  8,  18405,  14046, 260, 275, 290, 305,  1,  1, { 14048, 8170, 14341, }, { 5, 2, 1, }, nil, nil, { 14468, }, },
	[18406]  = { nil, 1,  8,  18406,  13858, 260, 275, 290, 305,  1,  1, { 14048, 14227, 14341, }, { 5, 1, 1, }, true, 10000, { 21924, 14469, }, },
	[18407]  = { nil, 1,  8,  18407,  13857, 260, 275, 290, 305,  1,  1, { 14048, 14227, 14341, }, { 5, 1, 1, }, true, 10000, { 14470, }, },
	[18408]  = { nil, 1,  8,  18408,  14042, 260, 275, 290, 305,  1,  1, { 14048, 7077, 14341, }, { 5, 2, 1, }, nil, nil, { 14471, }, },
	[26085]  = { nil, 1,  8,  26085,  21340, 260, 275, 290, 305,  1,  1, { 14048, 8170, 7972, 14341, }, { 6, 4, 2, 1, }, nil, nil, { 21358, }, },
	[18409]  = { nil, 1,  8,  18409,  13860, 265, 280, 295, 310,  1,  1, { 14048, 14227, }, { 4, 1, }, true, 10000, { 14472, }, },
	[18410]  = { nil, 1,  8,  18410,  14143, 265, 280, 295, 310,  1,  1, { 14048, 9210, }, { 2, 2, }, true, 10000, { 14473, }, },
	[18411]  = { nil, 1,  8,  18411,  13870, 265, 280, 295, 310,  1,  1, { 14048, 6260, 14341, }, { 5, 2, 1, }, true, 10000, { 14474, }, },
	[18412]  = { nil, 1,  8,  18412,  14043, 270, 285, 300, 315,  1,  1, { 14048, 7077, 14341, }, { 4, 2, 1, }, nil, nil, { 14476, }, },
	[18413]  = { nil, 1,  8,  18413,  14142, 270, 285, 300, 315,  1,  1, { 14048, 9210, }, { 2, 2, }, true, 10000, { 14477, }, },
	[18414]  = { nil, 1,  8,  18414,  14100, 270, 285, 300, 315,  1,  1, { 14048, 3577, }, { 4, 2, }, true, 10000, { 14478, }, },
	[18415]  = { nil, 1,  8,  18415,  14101, 270, 285, 300, 315,  1,  1, { 14048, 3577, }, { 4, 2, }, true, 10000, { 14479, }, },
	[18416]  = { nil, 1,  8,  18416,  14141, 275, 290, 305, 320,  1,  1, { 14048, 9210, }, { 2, 3, }, true, 12500, { 14480, }, },
	[18417]  = { nil, 1,  8,  18417,  13863, 275, 290, 305, 320,  1,  1, { 14048, 14341, }, { 5, 2, }, true, 12500, { 14481, }, },
	[18418]  = { nil, 1,  8,  18418,  14044, 275, 290, 305, 320,  1,  1, { 14048, 7078, 14341, }, { 5, 1, 1, }, nil, nil, { 14482, }, },
	[18419]  = { nil, 1,  8,  18419,  14107, 275, 290, 305, 320,  1,  1, { 14048, 14256, 14341, }, { 5, 2, 1, }, nil, nil, { 14483, }, },
	[18420]  = { nil, 1,  8,  18420,  14103, 275, 290, 305, 320,  1,  1, { 14048, 3577, }, { 4, 2, }, true, 12500, { 14484, }, },
	[18421]  = { nil, 1,  8,  18421,  14132, 275, 290, 305, 320,  1,  1, { 14048, 11176, 14341, }, { 4, 1, 1, }, true, 12500, { 14485, }, },
	[18422]  = { nil, 1,  8,  18422,  14134, 275, 290, 305, 320,  1,  1, { 14048, 7078, 7077, 7068, 14341, }, { 6, 4, 4, 4, 1, }, nil, nil, { 14486, }, },
	[27659]  = { nil, 1,  8,  27659,  22248, 275, 290, 305, 320,  1,  1, { 14048, 16203, 14341, }, { 5, 2, 2, }, nil, nil, { 22308, }, },
	[27724]  = { nil, 1,  8,  27724,  22251, 275, 290, 305, 320,  1,  1, { 14048, 8831, 14341, }, { 5, 10, 2, }, nil, nil, { 22310, }, },
	[18423]  = { nil, 1,  8,  18423,  13864, 280, 295, 310, 325,  1,  1, { 14048, 8170, 14341, }, { 4, 2, 1, }, true, 15000, { 14488, }, },
	[18424]  = { nil, 1,  8,  18424,  13871, 280, 295, 310, 325,  1,  1, { 14048, 6260, 14341, }, { 6, 2, 1, }, true, 15000, { 14489, }, },
	[18434]  = { nil, 1,  8,  18434,  14045, 280, 295, 310, 325,  1,  1, { 14048, 7078, 14341, }, { 6, 1, 1, }, nil, nil, { 14490, }, },
	[22813]  = { nil, 1,  8,  22813,  18258, 285, 285, 290, 295,  1,  1, { 14048, 8170, 18240, 14341, }, { 2, 4, 1, 1, }, },
	[18436]  = { nil, 1,  8,  18436,  14136, 285, 300, 315, 330,  1,  1, { 14048, 14256, 12808, 7080, 14341, }, { 10, 12, 4, 4, 1, }, nil, nil, { 14493, }, },
	[18437]  = { nil, 1,  8,  18437,  14108, 285, 300, 315, 330,  1,  1, { 14048, 14256, 8170, 14341, }, { 2, 2, 2, 1, }, true, 15000, { 14492, }, },
	[18438]  = { nil, 1,  8,  18438,  13865, 285, 300, 315, 330,  1,  1, { 14048, 14227, 14341, }, { 5, 2, 1, }, true, 15000, { 14491, }, },
	[26086]  = { nil, 1,  8,  26086,  21341, 285, 300, 315, 330,  1,  1, { 14256, 12810, 20520, 14227, }, { 12, 6, 2, 4, }, nil, nil, { 21369, }, },
	[19435]  = { nil, 1,  8,  19435,  15802, 290, 295, 310, 325,  1,  1, { 14048, 14342, 7971, 14341, }, { 6, 4, 2, 1, }, },
	[18439]  = { nil, 1,  8,  18439,  14104, 290, 305, 320, 335,  1,  1, { 14048, 3577, }, { 6, 4, }, nil, nil, { 14494, }, },
	[18440]  = { nil, 1,  8,  18440,  14137, 290, 305, 320, 335,  1,  1, { 14048, 14342, 14341, }, { 6, 4, 1, }, nil, nil, { 14497, }, },
	[18441]  = { nil, 1,  8,  18441,  14144, 290, 305, 320, 335,  1,  1, { 14048, 9210, }, { 3, 4, }, true, 15000, { 14495, }, },
	[18442]  = { nil, 1,  8,  18442,  14111, 290, 305, 320, 335,  1,  1, { 14048, 14256, 14341, }, { 2, 2, 1, }, true, 15000, { 14496, }, },
	[23662]  = { nil, 1,  8,  23662,  19047, 290, 305, 320, 335,  1,  1, { 14048, 7076, 12803, 14227, }, { 8, 3, 3, 2, }, nil, nil, { 19215, }, },
	[23664]  = { nil, 1,  8,  23664,  19056, 290, 305, 320, 335,  1,  1, { 14048, 12810, 13926, 12809, 14227, }, { 6, 4, 2, 2, 2, }, nil, nil, { 19216, }, },
	[18444]  = { nil, 1,  8,  18444,  13866, 295, 310, 325, 340,  1,  1, { 14048, 14341, }, { 6, 2, }, true, 15000, { 14498, }, },
	[31460]  = { nil, 1,  8,  31460,  24268, 300, 300, 310, 320,  2,  2, { 21877, }, { 3, }, true, 15000, },
	[26745]  = { nil, 1,  8,  26745,  21840, 300, 305, 315, 325,  1,  1, { 21877, }, { 5, }, true, 15000, },
	[18445]  = { nil, 1,  8,  18445,  14155, 300, 315, 330, 345,  1,  1, { 14048, 14342, 14341, }, { 4, 1, 1, }, nil, nil, { 14499, }, },
	[18446]  = { nil, 1,  8,  18446,  14128, 300, 315, 330, 345,  1,  1, { 14048, 11176, 14341, }, { 8, 2, 1, }, true, 15000, { 14500, }, },
	[18447]  = { nil, 1,  8,  18447,  14138, 300, 315, 330, 345,  1,  1, { 14048, 14342, 14341, }, { 6, 4, 1, }, nil, nil, { 14501, }, },
	[18448]  = { nil, 1,  8,  18448,  14139, 300, 315, 330, 345,  1,  1, { 14048, 14342, 14341, }, { 5, 5, 1, }, nil, nil, { 14507, }, },
	[18449]  = { nil, 1,  8,  18449,  13867, 300, 315, 330, 345,  1,  1, { 14048, 14227, 8170, 14341, }, { 7, 2, 4, 1, }, true, 15000, { 14504, }, },
	[18450]  = { nil, 1,  8,  18450,  14130, 300, 315, 330, 345,  1,  1, { 14048, 11176, 7910, 14341, }, { 6, 4, 1, 1, }, true, 15000, { 14505, }, },
	[18451]  = { nil, 1,  8,  18451,  14106, 300, 315, 330, 345,  1,  1, { 14048, 14256, 12662, 14341, }, { 8, 3, 2, 2, }, true, 15000, { 14506, }, },
	[18452]  = { nil, 1,  8,  18452,  14140, 300, 315, 330, 345,  1,  1, { 14048, 14342, 12800, 12810, 14341, }, { 4, 6, 1, 2, 2, }, nil, nil, { 14509, }, },
	[18453]  = { nil, 1,  8,  18453,  14112, 300, 315, 330, 345,  1,  1, { 14048, 14256, 12662, 8170, 14341, }, { 7, 3, 2, 4, 2, }, true, 15000, { 14508, }, },
	[18454]  = { nil, 1,  8,  18454,  14146, 300, 315, 330, 345,  1,  1, { 14048, 14342, 9210, 13926, 12364, 12810, 14341, }, { 10, 10, 10, 6, 6, 8, 2, }, nil, nil, { 14511, }, },
	[18455]  = { nil, 1,  8,  18455,  14156, 300, 315, 330, 345,  1,  1, { 14048, 14342, 14344, 17012, 14341, }, { 8, 12, 2, 2, 2, }, nil, nil, { 14510, }, },
	[18456]  = { nil, 1,  8,  18456,  14154, 300, 315, 330, 345,  1,  1, { 14048, 14342, 12811, 13926, 9210, 14341, }, { 12, 10, 4, 4, 10, 2, }, nil, nil, { 29120, 14512, }, },
	[18457]  = { nil, 1,  8,  18457,  14152, 300, 315, 330, 345,  1,  1, { 14048, 7078, 7082, 7076, 7080, 14341, }, { 12, 10, 10, 10, 10, 2, }, nil, nil, { 14513, }, },
	[18458]  = { nil, 1,  8,  18458,  14153, 300, 315, 330, 345,  1,  1, { 14048, 12662, 14256, 7078, 12808, 14341, }, { 12, 20, 40, 12, 12, 2, }, nil, nil, { 14514, }, },
	[20848]  = { nil, 1,  8,  20848,  16980, 300, 315, 330, 345,  1,  1, { 14048, 17010, 17011, 12810, 14341, }, { 12, 4, 4, 6, 2, }, nil, nil, { 17017, }, },
	[20849]  = { nil, 1,  8,  20849,  16979, 300, 315, 330, 345,  1,  1, { 14048, 17010, 7078, 12810, 14341, }, { 8, 6, 4, 2, 2, }, nil, nil, { 17018, }, },
	[22866]  = { nil, 1,  8,  22866,  18405, 300, 315, 330, 345,  1,  1, { 14048, 9210, 14342, 7080, 7078, 14344, 14341, }, { 16, 10, 10, 12, 12, 6, 6, }, nil, nil, { 18414, }, },
	[22867]  = { nil, 1,  8,  22867,  18407, 300, 315, 330, 345,  1,  1, { 14048, 14256, 12662, 12808, 14341, }, { 12, 20, 6, 8, 2, }, nil, nil, { 18415, }, },
	[22868]  = { nil, 1,  8,  22868,  18408, 300, 315, 330, 345,  1,  1, { 14048, 7078, 7910, 14341, }, { 12, 10, 2, 2, }, nil, nil, { 18416, }, },
	[22869]  = { nil, 1,  8,  22869,  18409, 300, 315, 330, 345,  1,  1, { 14048, 14342, 13926, 14341, }, { 12, 6, 2, 2, }, nil, nil, { 18417, }, },
	[22870]  = { nil, 1,  8,  22870,  18413, 300, 315, 330, 345,  1,  1, { 14048, 12809, 12360, 14341, }, { 12, 4, 1, 2, }, nil, nil, { 18418, }, },
	[22902]  = { nil, 1,  8,  22902,  18486, 300, 315, 330, 345,  1,  1, { 14048, 14342, 13926, 14341, }, { 6, 4, 2, 2, }, nil, nil, { 18487, }, },
	[23663]  = { nil, 1,  8,  23663,  19050, 300, 315, 330, 345,  1,  1, { 14342, 7076, 12803, 14227, }, { 5, 5, 5, 2, }, nil, nil, { 19218, }, },
	[23665]  = { nil, 1,  8,  23665,  19059, 300, 315, 330, 345,  1,  1, { 14342, 12809, 14227, }, { 5, 2, 2, }, nil, nil, { 19217, }, },
	[23666]  = { nil, 1,  8,  23666,  19156, 300, 315, 330, 345,  1,  1, { 14342, 17010, 17011, 7078, 14227, }, { 10, 2, 3, 6, 4, }, nil, nil, { 19219, }, },
	[23667]  = { nil, 1,  8,  23667,  19165, 300, 315, 330, 345,  1,  1, { 14342, 17010, 17011, 7078, 14227, }, { 8, 5, 3, 10, 4, }, nil, nil, { 19220, }, },
	[24091]  = { nil, 1,  8,  24091,  19682, 300, 315, 330, 345,  1,  1, { 14342, 12804, 14227, }, { 3, 3, 2, }, nil, nil, { 19764, }, },
	[24092]  = { nil, 1,  8,  24092,  19683, 300, 315, 330, 345,  1,  1, { 14342, 12804, 14227, }, { 4, 4, 2, }, nil, nil, { 19765, }, },
	[24093]  = { nil, 1,  8,  24093,  19684, 300, 315, 330, 345,  1,  1, { 14342, 14227, }, { 4, 2, }, nil, nil, { 19766, }, },
	[24901]  = { nil, 1,  8,  24901,  20538, 300, 315, 330, 345,  1,  1, { 14048, 20520, 14256, 14227, }, { 6, 8, 6, 2, }, nil, nil, { 20546, }, },
	[24902]  = { nil, 1,  8,  24902,  20539, 300, 315, 330, 345,  1,  1, { 14048, 20520, 14256, 12810, 14227, }, { 2, 6, 2, 2, 2, }, nil, nil, { 20548, }, },
	[24903]  = { nil, 1,  8,  24903,  20537, 300, 315, 330, 345,  1,  1, { 14048, 20520, 14256, 12810, 14227, }, { 4, 6, 4, 2, 2, }, nil, nil, { 20547, }, },
	[26087]  = { nil, 1,  8,  26087,  21342, 300, 315, 330, 345,  1,  1, { 14256, 17012, 7078, 14227, }, { 20, 16, 4, 4, }, nil, nil, { 21371, }, },
	[27660]  = { nil, 1,  8,  27660,  22249, 300, 315, 330, 345,  1,  1, { 14048, 14344, 12810, 14227, }, { 6, 4, 4, 4, }, nil, nil, { 22309, }, },
	[27725]  = { nil, 1,  8,  27725,  22252, 300, 315, 330, 345,  1,  1, { 14048, 14342, 13468, 14227, }, { 6, 2, 1, 4, }, nil, nil, { 22312, }, },
	[28205]  = { nil, 1,  8,  28205,  22654, 300, 315, 330, 345,  1,  1, { 22682, 14048, 7080, 14227, }, { 5, 4, 4, 4, }, nil, nil, { 22684, }, },
	[28207]  = { nil, 1,  8,  28207,  22652, 300, 315, 330, 345,  1,  1, { 22682, 14048, 7080, 14227, }, { 7, 8, 6, 8, }, nil, nil, { 22686, }, },
	[28208]  = { nil, 1,  8,  28208,  22658, 300, 315, 330, 345,  1,  1, { 22682, 14048, 7080, 14227, }, { 5, 4, 2, 4, }, nil, nil, { 22685, }, },
	[28209]  = { nil, 1,  8,  28209,  22655, 300, 315, 330, 345,  1,  1, { 22682, 14048, 7080, 14227, }, { 4, 2, 2, 4, }, nil, nil, { 22687, }, },
	[28210]  = { nil, 1,  8,  28210,  22660, 300, 315, 330, 345,  1,  1, { 14048, 12803, 14227, }, { 3, 5, 4, }, nil, nil, { 22683, }, },
	[28480]  = { nil, 1,  8,  28480,  22756, 300, 315, 330, 345,  1,  1, { 14048, 12803, 14227, }, { 4, 2, 2, }, nil, nil, { 22774, }, },
	[28481]  = { nil, 1,  8,  28481,  22757, 300, 315, 330, 345,  1,  1, { 14048, 14342, 12803, 14227, }, { 4, 2, 2, 2, }, nil, nil, { 22773, }, },
	[28482]  = { nil, 1,  8,  28482,  22758, 300, 315, 330, 345,  1,  1, { 14048, 12803, 14227, }, { 2, 4, 2, }, nil, nil, { 22772, }, },
	[22759]  = { nil, 1,  8,  22759,  18263, 300, 320, 335, 350,  1,  1, { 14342, 17010, 7078, 12810, 14341, }, { 6, 8, 2, 6, 4, }, nil, nil, { 18265, }, },
	[60969]  = { nil, 1,  8,  60969,  44554, 300, 340, 345, 350,  1,  1, { 21840, 23112, 22445, 8343, }, { 6, 4, 4, 5, }, true, 15000, },
	[26764]  = { nil, 1,  8,  26764,  21849, 310, 320, 325, 330,  1,  1, { 21840, 14341, }, { 3, 1, }, true, 15000, },
	[26765]  = { nil, 1,  8,  26765,  21850, 310, 320, 325, 330,  1,  1, { 21840, 14341, }, { 3, 1, }, true, 15000, },
	[26746]  = { nil, 1,  8,  26746,  21841, 315, 320, 330, 340,  1,  1, { 21840, 14341, }, { 4, 1, }, true, 15000, },
	[26770]  = { nil, 1,  8,  26770,  21851, 320, 330, 335, 340,  1,  1, { 21840, 21887, 14341, }, { 4, 2, 1, }, true, 20000, },
	[31461]  = { nil, 1,  8,  31461,  24269, 325, 325, 330, 335,  2,  2, { 21877, }, { 6, }, nil, nil, { 24315, }, },
	[26747]  = { nil, 1,  8,  26747,  21842, 325, 330, 335, 340,  1,  1, { 21840, 22445, }, { 3, 2, }, nil, nil, { 21892, }, },
	[26771]  = { nil, 1,  8,  26771,  21852, 325, 335, 340, 345,  1,  1, { 21840, 14341, }, { 6, 1, }, true, 20000, },
	[26772]  = { nil, 1,  8,  26772,  21853, 335, 345, 350, 355,  1,  1, { 21840, 21887, 14341, }, { 6, 2, 1, }, true, 20000, },
	[31430]  = { nil, 1,  8,  31430,  24273, 335, 345, 350, 355,  1,  1, { 14341, 22457, }, { 1, 5, }, nil, nil, { 24292, }, },
	[31431]  = { nil, 1,  8,  31431,  24275, 335, 345, 350, 355,  1,  1, { 14341, 21886, }, { 1, 5, }, nil, nil, { 24293, }, },
	[26749]  = { nil, 1,  8,  26749,  21843, 340, 340, 345, 350,  1,  1, { 21842, 21881, 22446, }, { 4, 2, 1, }, nil, nil, { 21893, }, },
	[26773]  = { nil, 1,  8,  26773,  21854, 340, 350, 355, 360,  1,  1, { 21840, 14341, }, { 8, 2, }, nil, nil, { 21896, }, },
	[26775]  = { nil, 1,  8,  26775,  21859, 340, 350, 355, 360,  1,  1, { 21842, 21881, 14341, }, { 5, 2, 1, }, nil, nil, { 21898, }, },
	[31459]  = { nil, 1,  8,  31459,  24270, 340, 350, 355, 360,  1,  1, { 21842, 21887, }, { 6, 4, }, nil, nil, { 24314, }, },
	[26750]  = { nil, 1,  8,  26750,  21844, 345, 345, 350, 355,  1,  1, { 21840, 21882, }, { 1, 8, }, nil, nil, { 21894, }, },
	[26774]  = { nil, 1,  8,  26774,  21855, 345, 355, 360, 365,  1,  1, { 21840, 14341, }, { 8, 2, }, nil, nil, { 21897, }, },
	[26751]  = { nil, 1,  8,  26751,  21845, 350, 350, 355, 360,  1,  1, { 21842, 21886, 21885, }, { 1, 1, 1, }, nil, nil, { 21895, }, },
	[31373]  = { nil, 1,  8,  31373,  24271, 350, 350, 355, 360,  1,  1, { 21842, 22457, 21884, }, { 1, 1, 1, }, nil, nil, { 24316, }, },
	[36686]  = { nil, 1,  8,  36686,  24272, 350, 350, 355, 360,  1,  1, { 21842, 22456, 21884, }, { 1, 1, 1, }, nil, nil, { 30483, }, },
	[26776]  = { nil, 1,  8,  26776,  21860, 350, 360, 365, 370,  1,  1, { 21842, 21887, 21881, 14341, }, { 4, 6, 2, 1, }, nil, nil, { 21899, }, },
	[26782]  = { nil, 1,  8,  26782,  21866, 350, 360, 365, 370,  1,  1, { 21840, 22445, 14341, }, { 6, 12, 2, }, nil, nil, { 21905, }, },
	[31434]  = { nil, 1,  8,  31434,  24249, 350, 360, 365, 370,  1,  1, { 21842, 22452, }, { 4, 8, }, nil, nil, { 24296, 35308, }, },
	[31435]  = { nil, 1,  8,  31435,  24250, 350, 360, 365, 370,  1,  1, { 21842, 22452, 22456, }, { 4, 4, 4, }, nil, nil, { 24297, }, },
	[31437]  = { nil, 1,  8,  31437,  24251, 350, 360, 365, 370,  1,  1, { 21842, 21884, }, { 4, 8, }, nil, nil, { 24298, }, },
	[31438]  = { nil, 1,  8,  31438,  24252, 350, 360, 365, 370,  1,  1, { 21842, 22457, 22456, }, { 6, 3, 3, }, nil, nil, { 24299, }, },
	[31440]  = { nil, 1,  8,  31440,  24253, 350, 360, 365, 370,  1,  1, { 21842, 22452, }, { 6, 6, }, nil, nil, { 24300, }, },
	[31441]  = { nil, 1,  8,  31441,  24254, 350, 360, 365, 370,  1,  1, { 21842, 21886, }, { 6, 6, }, nil, nil, { 24301, }, },
	[37873]  = { nil, 1,  8,  37873,  30831, 350, 360, 365, 370,  1,  1, { 21842, 22457, 21886, 21881, }, { 4, 3, 3, 2, }, nil, nil, { 30833, }, },
	[37882]  = { nil, 1,  8,  37882,  30837, 350, 360, 365, 370,  1,  1, { 21840, 21884, 14341, }, { 5, 5, 2, }, nil, nil, { 30842, }, },
	[55902]  = { nil, 1,  8,  55902,  41513, 350, 360, 370, 380,  1,  1, { 41510, 38426, }, { 3, 1, }, true, 50000, },
	[56031]  = { nil, 1,  8,  56031,  41512, 350, 360, 370, 380,  1,  1, { 41510, 38426, }, { 3, 1, }, true, 50000, },
	[55899]  = { nil, 1,  8,  55899,  41510, 350, 370, 372, 375,  1,  1, { 33470, }, { 5, }, true, 50000, },
	[26752]  = { nil, 1,  8,  26752,  21846, 355, 365, 370, 375,  1,  1, { 24271, 21884, 21881, }, { 4, 10, 2, }, nil, nil, { 21908, }, nil, nil, nil, 26797, },
	[26756]  = { nil, 1,  8,  26756,  21869, 355, 365, 370, 375,  1,  1, { 24272, 21885, 21881, }, { 4, 10, 2, }, nil, nil, { 21912, }, nil, nil, nil, 26801, },
	[26760]  = { nil, 1,  8,  26760,  21873, 355, 365, 370, 375,  1,  1, { 21845, 21881, 21886, }, { 4, 2, 8, }, nil, nil, { 21916, }, nil, nil, nil, 26798, },
	[26779]  = { nil, 1,  8,  26779,  21863, 355, 365, 370, 375,  1,  1, { 21844, 21887, 14341, }, { 5, 6, 4, }, nil, nil, { 21902, }, },
	[36665]  = { nil, 1,  8,  36665,  30459, 355, 365, 370, 375,  1,  1, { 21840, 21884, 22456, 21881, }, { 10, 5, 6, 2, }, nil, nil, { 30469, }, },
	[36667]  = { nil, 1,  8,  36667,  30460, 355, 365, 370, 375,  1,  1, { 21840, 21887, 21884, 22456, 21881, }, { 6, 4, 3, 4, 2, }, nil, nil, { 30470, }, },
	[36668]  = { nil, 1,  8,  36668,  30461, 355, 365, 370, 375,  1,  1, { 21840, 21887, 21884, 22456, 21881, }, { 6, 4, 2, 6, 2, }, nil, nil, { 30471, }, },
	[36669]  = { nil, 1,  8,  36669,  30465, 355, 365, 370, 375,  1,  1, { 21840, 21885, 21886, 21881, }, { 10, 5, 5, 2, }, nil, nil, { 30472, }, },
	[36670]  = { nil, 1,  8,  36670,  30463, 355, 365, 370, 375,  1,  1, { 21840, 21887, 21885, 21886, 21881, }, { 6, 4, 3, 3, 2, }, nil, nil, { 30473, }, },
	[36672]  = { nil, 1,  8,  36672,  30464, 355, 365, 370, 375,  1,  1, { 21840, 21887, 21885, 21886, 21881, }, { 4, 4, 2, 2, 2, }, nil, nil, { 30474, }, },
	[26777]  = { nil, 1,  8,  26777,  21861, 360, 370, 375, 380,  1,  1, { 21842, 21881, 14341, }, { 6, 2, 1, }, nil, nil, { 21900, }, },
	[26778]  = { nil, 1,  8,  26778,  21862, 360, 370, 375, 380,  1,  1, { 21842, 21881, 14341, }, { 6, 2, 1, }, nil, nil, { 21901, }, },
	[26783]  = { nil, 1,  8,  26783,  21867, 360, 370, 375, 380,  1,  1, { 21840, 22445, 14341, }, { 8, 16, 2, }, nil, nil, { 21906, }, },
	[37883]  = { nil, 1,  8,  37883,  30838, 360, 370, 375, 380,  1,  1, { 21840, 21884, 14341, }, { 7, 7, 2, }, nil, nil, { 30843, }, },
	[55898]  = { nil, 1,  8,  55898,  41509, 360, 370, 375, 380,  5,  5, { 33470, }, { 6, }, true, 50000, },
	[55903]  = { nil, 1,  8,  55903,  41515, 360, 370, 380, 390,  1,  1, { 41510, 38426, }, { 4, 1, }, true, 50000, },
	[55904]  = { nil, 1,  8,  55904,  44211, 360, 370, 380, 390,  1,  1, { 41510, 38426, }, { 3, 1, }, true, 50000, },
	[26753]  = { nil, 1,  8,  26753,  21847, 365, 375, 380, 385,  1,  1, { 24271, 21884, 21881, }, { 8, 12, 4, }, nil, nil, { 21909, }, nil, nil, nil, 26797, },
	[26757]  = { nil, 1,  8,  26757,  21870, 365, 375, 380, 385,  1,  1, { 24272, 21885, 21881, }, { 8, 12, 2, }, nil, nil, { 21914, }, nil, nil, nil, 26801, },
	[26761]  = { nil, 1,  8,  26761,  21874, 365, 375, 380, 385,  1,  1, { 21845, 21881, 21886, }, { 8, 2, 8, }, nil, nil, { 21918, }, nil, nil, nil, 26798, },
	[26780]  = { nil, 1,  8,  26780,  21864, 365, 375, 380, 385,  1,  1, { 21844, 14341, }, { 6, 4, }, nil, nil, { 21903, }, },
	[31442]  = { nil, 1,  8,  31442,  24255, 365, 375, 380, 385,  1,  1, { 21845, 22452, 23572, }, { 8, 16, 1, }, nil, nil, { 24302, 35309, }, },
	[31443]  = { nil, 1,  8,  31443,  24256, 365, 375, 380, 385,  1,  1, { 24272, 21884, 23572, }, { 10, 16, 1, }, nil, nil, { 24303, }, },
	[31444]  = { nil, 1,  8,  31444,  24257, 365, 375, 380, 385,  1,  1, { 21842, 22457, 23572, }, { 6, 14, 1, }, nil, nil, { 24304, }, },
	[31448]  = { nil, 1,  8,  31448,  24258, 365, 375, 380, 385,  1,  1, { 21845, 22452, 23572, }, { 10, 12, 1, }, nil, nil, { 24305, }, },
	[31449]  = { nil, 1,  8,  31449,  24259, 365, 375, 380, 385,  1,  1, { 24272, 22451, 23572, }, { 10, 14, 1, }, nil, nil, { 24306, }, },
	[31450]  = { nil, 1,  8,  31450,  24260, 365, 375, 380, 385,  1,  1, { 24271, 22457, 23572, }, { 10, 12, 1, }, nil, nil, { 24307, }, },
	[46128]  = { nil, 1,  8,  46128,  34366, 365, 375, 392, 410,  1,  1, { 24271, 24272, 34664, }, { 10, 10, 6, }, nil, nil, { 35551, 35204, }, },
	[46129]  = { nil, 1,  8,  46129,  34367, 365, 375, 392, 410,  1,  1, { 21845, 21886, 21885, 34664, }, { 18, 12, 12, 6, }, nil, nil, { 35205, 35544, }, },
	[46130]  = { nil, 1,  8,  46130,  34364, 365, 375, 392, 410,  1,  1, { 24271, 24272, 23572, }, { 12, 12, 2, }, nil, nil, { 35552, 35206, }, },
	[46131]  = { nil, 1,  8,  46131,  34365, 365, 375, 392, 410,  1,  1, { 21845, 23572, }, { 20, 2, }, nil, nil, { 35207, 35548, }, },
	[26784]  = { nil, 1,  8,  26784,  21868, 370, 380, 385, 390,  1,  1, { 21840, 22445, 14341, }, { 12, 20, 2, }, nil, nil, { 21907, }, },
	[37884]  = { nil, 1,  8,  37884,  30839, 370, 380, 385, 390,  1,  1, { 21840, 21884, 14341, }, { 9, 9, 2, }, nil, nil, { 30844, }, },
	[55908]  = { nil, 1,  8,  55908,  41522, 370, 380, 390, 400,  1,  1, { 41510, 38426, }, { 3, 1, }, true, 50000, },
	[26781]  = { nil, 1,  8,  26781,  21865, 375, 380, 382, 385,  1,  1, { 21844, 14341, }, { 8, 4, }, nil, nil, { 21904, }, },
	[26754]  = { nil, 1,  8,  26754,  21848, 375, 385, 390, 395,  1,  1, { 24271, 21884, 21881, }, { 14, 16, 4, }, nil, nil, { 21910, }, nil, nil, nil, 26797, },
	[26755]  = { nil, 1,  8,  26755,  21858, 375, 385, 390, 395,  1,  1, { 24271, 22446, 21881, }, { 6, 4, 4, }, nil, nil, { 21911, }, },
	[26758]  = { nil, 1,  8,  26758,  21871, 375, 385, 390, 395,  1,  1, { 24272, 21885, 21881, }, { 14, 16, 4, }, nil, nil, { 21913, }, nil, nil, nil, 26801, },
	[26759]  = { nil, 1,  8,  26759,  21872, 375, 385, 390, 395,  1,  1, { 24272, 21881, }, { 6, 4, }, nil, nil, { 21915, }, },
	[26762]  = { nil, 1,  8,  26762,  21875, 375, 385, 390, 395,  1,  1, { 21845, 22457, 21881, }, { 14, 12, 4, }, nil, nil, { 21917, }, nil, nil, nil, 26798, },
	[26763]  = { nil, 1,  8,  26763,  21876, 375, 385, 390, 395,  1,  1, { 21845, 21881, }, { 8, 4, }, nil, nil, { 21919, }, },
	[31432]  = { nil, 1,  8,  31432,  24274, 375, 385, 390, 395,  1,  1, { 14341, 22457, 23572, }, { 1, 10, 1, }, nil, nil, { 24294, }, },
	[31433]  = { nil, 1,  8,  31433,  24276, 375, 385, 390, 395,  1,  1, { 14341, 21886, 23572, }, { 1, 10, 1, }, nil, nil, { 24295, }, },
	[31451]  = { nil, 1,  8,  31451,  24261, 375, 385, 390, 395,  1,  1, { 21845, 23571, 23572, }, { 10, 5, 1, }, nil, nil, { 24308, }, },
	[31452]  = { nil, 1,  8,  31452,  24262, 375, 385, 390, 395,  1,  1, { 24271, 23571, 23572, }, { 10, 5, 1, }, nil, nil, { 24309, }, },
	[31453]  = { nil, 1,  8,  31453,  24263, 375, 385, 390, 395,  1,  1, { 21842, 23571, 23572, }, { 12, 8, 1, }, nil, nil, { 24310, }, },
	[31454]  = { nil, 1,  8,  31454,  24264, 375, 385, 390, 395,  1,  1, { 21845, 23571, 23572, }, { 10, 5, 1, }, nil, nil, { 24311, }, },
	[31455]  = { nil, 1,  8,  31455,  24266, 375, 385, 390, 395,  1,  1, { 24271, 23571, 23572, }, { 10, 5, 1, }, nil, nil, { 24312, }, },
	[31456]  = { nil, 1,  8,  31456,  24267, 375, 385, 390, 395,  1,  1, { 21842, 23571, 23572, }, { 12, 8, 1, }, nil, nil, { 24313, }, },
	[36315]  = { nil, 1,  8,  36315,  30038, 375, 385, 390, 395,  1,  1, { 30183, 21842, 21884, 14341, }, { 2, 4, 15, 2, }, nil, nil, { 30280, }, },
	[36316]  = { nil, 1,  8,  36316,  30036, 375, 385, 390, 395,  1,  1, { 30183, 21842, 21886, 14341, 21885, }, { 2, 4, 10, 2, 10, }, nil, nil, { 30281, }, },
	[36317]  = { nil, 1,  8,  36317,  30037, 375, 385, 390, 395,  1,  1, { 23572, 24272, 24271, 14341, }, { 2, 4, 4, 2, }, nil, nil, { 30282, }, },
	[36318]  = { nil, 1,  8,  36318,  30035, 375, 385, 390, 395,  1,  1, { 23572, 21845, 24271, 14341, }, { 2, 4, 4, 2, }, nil, nil, { 30283, }, },
	[40020]  = { nil, 1,  8,  40020,  32391, 375, 385, 390, 395,  1,  1, { 32428, 22450, 21886, 22456, 21842, }, { 2, 1, 2, 4, 1, }, nil, nil, { 32437, }, },
	[40021]  = { nil, 1,  8,  40021,  32392, 375, 385, 390, 395,  1,  1, { 32428, 22450, 21886, 22456, 21842, }, { 1, 1, 2, 2, 1, }, nil, nil, { 32438, }, },
	[40023]  = { nil, 1,  8,  40023,  32389, 375, 385, 390, 395,  1,  1, { 32428, 22450, 21886, 22456, 21842, }, { 3, 1, 4, 6, 2, }, nil, nil, { 32439, }, },
	[40024]  = { nil, 1,  8,  40024,  32390, 375, 385, 390, 395,  1,  1, { 32428, 22450, 21886, 22456, 21842, }, { 2, 1, 3, 4, 1, }, nil, nil, { 32440, }, },
	[40060]  = { nil, 1,  8,  40060,  32420, 375, 385, 390, 395,  1,  1, { 32428, 22450, 21886, 22456, 21842, }, { 1, 1, 2, 2, 1, }, nil, nil, { 32447, }, },
	[41205]  = { nil, 1,  8,  41205,  32586, 375, 385, 390, 395,  1,  1, { 21842, 24271, 22457, 32428, }, { 3, 4, 8, 4, }, nil, nil, { 32754, 35518, }, },
	[41206]  = { nil, 1,  8,  41206,  32587, 375, 385, 390, 395,  1,  1, { 21842, 24271, 22457, 32428, }, { 4, 2, 6, 2, }, nil, nil, { 32755, 35522, }, },
	[41207]  = { nil, 1,  8,  41207,  32584, 375, 385, 390, 395,  1,  1, { 21842, 21845, 21886, 32428, }, { 3, 4, 8, 4, }, nil, nil, { 32752, 35526, }, },
	[41208]  = { nil, 1,  8,  41208,  32585, 375, 385, 390, 395,  1,  1, { 21842, 21845, 21886, 32428, }, { 4, 2, 6, 2, }, nil, nil, { 32753, 35525, }, },
	[50194]  = { nil, 1,  8,  50194,  38225, 375, 385, 390, 395,  1,  1, { 21845, 22794, }, { 4, 2, }, nil, nil, { 38229, }, },
	[55906]  = { nil, 1,  8,  55906,  41520, 375, 385, 395, 405,  1,  1, { 41510, 38426, }, { 4, 1, }, true, 50000, },
	[55907]  = { nil, 1,  8,  55907,  41521, 380, 390, 400, 410,  1,  1, { 41510, 38426, }, { 5, 1, }, true, 50000, },
	[56030]  = { nil, 1,  8,  56030,  41519, 380, 390, 400, 410,  1,  1, { 41510, 38426, }, { 5, 1, }, true, 50000, },
	[55910]  = { nil, 1,  8,  55910,  41523, 385, 395, 405, 415,  1,  1, { 41510, 38426, 36783, }, { 7, 4, 1, }, true, 80000, },
	[55913]  = { nil, 1,  8,  55913,  41528, 385, 395, 405, 415,  1,  1, { 41510, 38426, 36783, }, { 5, 4, 2, }, true, 80000, },
	[56014]  = { nil, 1,  8,  56014,  41607, 390, 395, 400, 405,  1,  1, { 41510, 36783, }, { 7, 1, }, true, 100000, },
	[55911]  = { nil, 1,  8,  55911,  41525, 390, 400, 410, 420,  1,  1, { 41510, 38426, 36783, }, { 8, 4, 1, }, true, 80000, },
	[55914]  = { nil, 1,  8,  55914,  41543, 395, 400, 405, 410,  1,  1, { 41510, 38426, }, { 7, 1, }, true, 50000, },
	[56015]  = { nil, 1,  8,  56015,  41608, 395, 400, 405, 410,  1,  1, { 41510, 36783, }, { 8, 1, }, true, 100000, },
	[55901]  = { nil, 1,  8,  55901,  41548, 395, 405, 410, 415,  1,  1, { 41510, 38426, }, { 8, 1, }, true, 50000, },
	[55919]  = { nil, 1,  8,  55919,  41546, 395, 405, 410, 415,  1,  1, { 41510, 38426, }, { 8, 1, }, true, 100000, },
	[55900]  = { nil, 1,  8,  55900,  41511, 400, 400, 402, 405,  1,  1, { 41510, 34054, }, { 2, 2, }, true, 125000, },
	[55993]  = { nil, 1,  8,  55993,  41248, 400, 400, 405, 410,  1,  1, { 41510, 2604, }, { 4, 1, }, nil, nil, { 42172, }, },
	[55994]  = { nil, 1,  8,  55994,  41249, 400, 400, 405, 410,  1,  1, { 41510, 6260, }, { 4, 1, }, nil, nil, { 42173, }, },
	[55995]  = { nil, 1,  8,  55995,  41251, 400, 400, 405, 410,  1,  1, { 41510, 4341, }, { 4, 1, }, true, 50000, { 42174, }, },
	[55996]  = { nil, 1,  8,  55996,  41250, 400, 400, 405, 410,  1,  1, { 41510, 2605, }, { 4, 1, }, nil, nil, { 42175, }, },
	[55997]  = { nil, 1,  8,  55997,  41252, 400, 400, 405, 410,  1,  1, { 41510, 2604, }, { 4, 1, }, nil, nil, { 42177, }, },
	[55998]  = { nil, 1,  8,  55998,  41253, 400, 400, 405, 410,  1,  1, { 41510, 6260, }, { 4, 1, }, nil, nil, { 42176, }, },
	[55999]  = { nil, 1,  8,  55999,  41254, 400, 400, 405, 410,  1,  1, { 41510, 4341, }, { 4, 1, }, nil, nil, { 42178, }, },
	[56000]  = { nil, 1,  8,  56000,  41255, 400, 400, 405, 410,  1,  1, { 41510, 2605, }, { 4, 1, }, true, 50000, { 42179, }, },
	[56008]  = { nil, 1,  8,  56008,  41601, 400, 400, 405, 410,  1,  1, { 37704, 42253, }, { 2, 2, }, true, 100000, },
	[56010]  = { nil, 1,  8,  56010,  41603, 400, 400, 405, 410,  1,  1, { 37702, 42253, }, { 2, 2, }, true, 100000, },
	[56048]  = { nil, 1,  8,  56048,  41544, 400, 400, 410, 420,  1,  1, { 41520, 37703, }, { 1, 2, }, },
	[64729]  = { nil, 1,  8,  64729,  45811, 400, 405, 410, 415,  1,  1, { 41511, 42253, 35624, }, { 4, 4, 4, }, true, 100000, },
	[55920]  = { nil, 1,  8,  55920,  41551, 400, 410, 415, 420,  1,  1, { 41510, 38426, }, { 8, 1, }, true, 50000, },
	[56034]  = { nil, 1,  8,  56034,    nil, 405, 405, 405, 405,  0,  0, { 38426, }, { 1, }, true, 100000, },
	[56039]  = { nil, 1,  8,  56039,    nil, 405, 405, 405, 405,  0,  0, { 38426, }, { 1, }, true, 100000, },
	[64730]  = { nil, 1,  8,  64730,  45810, 405, 410, 415, 420,  1,  1, { 41511, 42253, 35627, }, { 4, 4, 4, }, true, 100000, },
	[55921]  = { nil, 1,  8,  55921,  41549, 405, 415, 420, 425,  1,  1, { 41510, 38426, }, { 10, 1, }, true, 100000, },
	[55922]  = { nil, 1,  8,  55922,  41545, 405, 415, 420, 425,  1,  1, { 41510, 38426, }, { 9, 1, }, true, 100000, },
	[55923]  = { nil, 1,  8,  55923,  41550, 410, 420, 425, 430,  1,  1, { 41510, 38426, }, { 10, 1, }, true, 100000, },
	[55924]  = { nil, 1,  8,  55924,  41544, 410, 420, 425, 430,  1,  1, { 41510, 38426, }, { 10, 1, }, true, 125000, },
	[56007]  = { nil, 1,  8,  56007,  41599, 410, 430, 440, 450,  1,  1, { 41511, 38426, }, { 6, 2, }, true, 80000, { 42186, }, },
	[55925]  = { nil, 1,  8,  55925,  41553, 415, 425, 430, 435,  1,  1, { 41511, 42253, 38426, }, { 5, 2, 2, }, true, 125000, },
	[55943]  = { nil, 1,  8,  55943,  41555, 415, 425, 430, 435,  1,  1, { 41511, 42253, 38426, }, { 4, 2, 2, }, true, 125000, },
	[56001]  = { nil, 1,  8,  56001,  41594, 415, 425, 430, 435,  1,  1, { 41511, 35625, }, { 1, 2, }, true, 100000, { 42181, }, },
	[56002]  = { nil, 1,  8,  56002,  41593, 415, 425, 430, 435,  1,  1, { 41511, 35627, }, { 1, 2, }, true, 100000, { 42180, }, },
	[56003]  = { nil, 1,  8,  56003,  41595, 415, 425, 430, 435,  1,  1, { 41511, 36860, }, { 1, 2, }, true, 100000, { 42182, }, },
	[59582]  = { nil, 1,  8,  59582,  43969, 415, 425, 435, 445,  1,  1, { 41511, 37702, 37701, 38426, }, { 3, 3, 3, 2, }, true, 100000, },
	[59583]  = { nil, 1,  8,  59583,  43974, 415, 425, 435, 445,  1,  1, { 41511, 37702, 37701, 38426, }, { 3, 3, 3, 2, }, true, 100000, },
	[56016]  = { nil, 1,  8,  56016,  41609, 415, 435, 445, 455,  1,  1, { 41511, 35625, 35622, 36784, 43102, }, { 5, 6, 4, 1, 1, }, nil, nil, { 42189, }, },
	[55642]  = { nil, 1,  8,  55642,    nil, 420, 420, 420, 420,  0,  0, { 38426, }, { 1, }, true, 125000, },
	[55769]  = { nil, 1,  8,  55769,    nil, 420, 420, 420, 420,  0,  0, { 38426, }, { 1, }, true, 125000, },
	[55777]  = { nil, 1,  8,  55777,    nil, 420, 420, 420, 420,  0,  0, { 38426, }, { 1, }, true, 125000, },
	[55941]  = { nil, 1,  8,  55941,  41554, 420, 430, 435, 440,  1,  1, { 41511, 42253, 38426, }, { 5, 2, 2, }, true, 125000, },
	[56019]  = { nil, 1,  8,  56019,  41985, 420, 430, 440, 450,  1,  1, { 41595, 41511, 38425, 42253, 38426, }, { 1, 5, 2, 4, 1, }, true, 100000, },
	[56020]  = { nil, 1,  8,  56020,  41986, 420, 430, 440, 450,  1,  1, { 41595, 41511, 42253, 38426, }, { 1, 4, 4, 1, }, true, 100000, },
	[56022]  = { nil, 1,  8,  56022,  42095, 420, 430, 440, 450,  1,  1, { 41594, 41511, 42253, 38426, }, { 1, 4, 4, 1, }, true, 100000, },
	[56023]  = { nil, 1,  8,  56023,  42096, 420, 430, 440, 450,  1,  1, { 41594, 41511, 38425, 42253, 38426, }, { 1, 4, 2, 4, 1, }, true, 100000, },
	[59584]  = { nil, 1,  8,  59584,  43973, 420, 430, 440, 450,  1,  1, { 41511, 37702, 37701, 38426, }, { 3, 4, 4, 2, }, true, 100000, },
	[59585]  = { nil, 1,  8,  59585,  43970, 420, 430, 440, 450,  1,  1, { 41511, 37702, 37701, 38426, }, { 3, 4, 4, 2, }, true, 100000, },
	[59586]  = { nil, 1,  8,  59586,  41516, 420, 430, 440, 450,  1,  1, { 41511, 37702, 37701, 38426, }, { 3, 4, 4, 2, }, true, 100000, },
	[59587]  = { nil, 1,  8,  59587,  43972, 420, 430, 440, 450,  1,  1, { 41511, 37702, 37701, 38426, }, { 4, 5, 5, 2, }, true, 100000, },
	[59588]  = { nil, 1,  8,  59588,  43975, 420, 430, 440, 450,  1,  1, { 41511, 37702, 37701, 38426, }, { 4, 5, 5, 2, }, true, 120000, },
	[59589]  = { nil, 1,  8,  59589,  43971, 420, 430, 440, 450,  1,  1, { 41511, 37702, 37701, 38426, }, { 4, 5, 5, 2, }, true, 120000, },
	[60990]  = { nil, 1,  8,  60990,  43584, 420, 430, 440, 450,  1,  1, { 41511, 36860, 35622, 38426, 43102, }, { 4, 2, 2, 2, 1, }, true, 180000, },
	[60994]  = { nil, 1,  8,  60994,  43585, 420, 430, 440, 450,  1,  1, { 41511, 36860, 35622, 38426, 43102, }, { 4, 2, 2, 2, 1, }, true, 180000, },
	[56017]  = { nil, 1,  8,  56017,  41610, 420, 435, 445, 455,  1,  1, { 41511, 36860, 35627, 36784, 43102, }, { 5, 6, 4, 1, 1, }, nil, nil, { 42190, }, },
	[56018]  = { nil, 1,  8,  56018,  41984, 425, 435, 440, 445,  1,  1, { 41593, 41511, 42253, 38426, }, { 1, 6, 4, 1, }, true, 100000, { 42191, }, },
	[56021]  = { nil, 1,  8,  56021,  42093, 425, 435, 440, 445,  1,  1, { 41594, 41511, 42253, 38426, }, { 1, 6, 4, 1, }, true, 100000, { 42194, }, },
	[60971]  = { nil, 1,  8,  60971,  44558, 425, 435, 445, 455,  1,  1, { 41511, 36930, 2604, 4341, 42253, }, { 12, 4, 4, 2, 4, }, true, 150000, },
	[60993]  = { nil, 1,  8,  60993,  43583, 425, 435, 445, 455,  1,  1, { 41511, 36860, 35622, 38426, 43102, }, { 6, 3, 3, 3, 1, }, true, 180000, },
	[75247]  = { nil, 1,  8,  75247,  54442, 425, 435, 445, 455,  3,  3, { 53010, }, { 6, }, true, 100000, },
	[75597]  = { nil, 1,  8,  75597,  54797, 425, 435, 445, 455,  1,  1, { 41594, 41595, 41593, 43102, }, { 1, 1, 1, 4, }, nil, nil, { 54798, }, },
	[74964]  = { nil, 1,  8,  74964,  53643, 425, 440, 445, 450,  1,  1, { 53010, }, { 5, }, true, 100000, },
	[56009]  = { nil, 1,  8,  56009,  41602, 430, 435, 440, 445,  1,  1, { 35625, 42253, 43102, }, { 4, 4, 1, }, nil, nil, { 42187, }, },
	[56011]  = { nil, 1,  8,  56011,  41604, 430, 435, 440, 445,  1,  1, { 36860, 42253, 43102, }, { 4, 4, 1, }, nil, nil, { 42188, }, },
	[56004]  = { nil, 1,  8,  56004,  41597, 435, 440, 445, 450,  1,  1, { 41593, 41595, 38426, }, { 4, 2, 1, }, nil, nil, { 42183, }, },
	[63924]  = { nil, 1,  8,  63924,  45773, 435, 440, 445, 450,  1,  1, { 41594, 36908, }, { 4, 6, }, nil, nil, { 45774, }, },
	[56025]  = { nil, 1,  8,  56025,  42103, 435, 445, 450, 455,  1,  1, { 41594, 41511, 38426, 43102, }, { 4, 4, 1, 1, }, true, 200000, },
	[56027]  = { nil, 1,  8,  56027,  42111, 435, 445, 450, 455,  1,  1, { 41593, 41511, 38426, 43102, }, { 4, 4, 1, 1, }, true, 200000, },
	[56029]  = { nil, 1,  8,  56029,  42113, 435, 445, 450, 455,  1,  1, { 41595, 41511, 38426, 43102, }, { 4, 4, 1, 1, }, true, 200000, },
	[56006]  = { nil, 1,  8,  56006,  41598, 440, 445, 450, 455,  1,  1, { 41595, 41594, 38426, }, { 4, 2, 1, }, nil, nil, { 42185, }, },
	[56024]  = { nil, 1,  8,  56024,  42100, 440, 450, 455, 460,  1,  1, { 41594, 41511, 38426, 43102, }, { 8, 6, 1, 1, }, true, 200000, },
	[56026]  = { nil, 1,  8,  56026,  42101, 440, 450, 455, 460,  1,  1, { 41593, 41511, 38426, 43102, }, { 8, 6, 1, 1, }, true, 200000, },
	[56028]  = { nil, 1,  8,  56028,  42102, 440, 450, 455, 460,  1,  1, { 41595, 41511, 38426, 43102, }, { 8, 6, 1, 1, }, true, 200000, },
	[56005]  = { nil, 1,  8,  56005,  41600, 445, 450, 455, 460,  1,  1, { 41594, 41593, 38426, }, { 4, 4, 1, }, nil, nil, { 42184, }, },
	[75248]  = { nil, 1,  8,  75248,  54471, 445, 455, 460, 465,  1,  1, { 53643, 38426, }, { 2, 2, }, true, 120000, },
	[75249]  = { nil, 1,  8,  75249,  54473, 445, 455, 460, 465,  1,  1, { 53643, 38426, }, { 2, 2, }, true, 120000, },
	[63203]  = { nil, 1,  8,  63203,  45557, 450, 455, 460, 465,  1,  1, { 41595, 41593, 45087, }, { 4, 4, 6, }, nil, nil, { 45102, }, },
	[63204]  = { nil, 1,  8,  63204,  45566, 450, 455, 460, 465,  1,  1, { 41595, 41593, 45087, }, { 4, 4, 6, }, nil, nil, { 45103, }, },
	[63205]  = { nil, 1,  8,  63205,  45558, 450, 455, 460, 465,  1,  1, { 41594, 45087, }, { 8, 6, }, nil, nil, { 45104, }, },
	[63206]  = { nil, 1,  8,  63206,  45567, 450, 455, 460, 465,  1,  1, { 41594, 45087, }, { 8, 6, }, nil, nil, { 45105, }, },
	[67064]  = { nil, 1,  8,  67064,  47605, 450, 460, 467, 475,  1,  1, { 41594, 36922, 47556, }, { 20, 2, 8, }, nil, nil, { 47657, }, },
	[67065]  = { nil, 1,  8,  67065,  47587, 450, 460, 467, 475,  1,  1, { 41594, 47556, }, { 12, 4, }, nil, nil, { 47656, }, },
	[67066]  = { nil, 1,  8,  67066,  47603, 450, 460, 467, 475,  1,  1, { 41593, 41595, 34052, 47556, }, { 8, 8, 8, 8, }, nil, nil, { 47655, }, },
	[67079]  = { nil, 1,  8,  67079,  47585, 450, 460, 467, 475,  1,  1, { 41595, 36934, 36919, 36925, 47556, }, { 8, 1, 1, 1, 4, }, nil, nil, { 47654, }, },
	[67144]  = { nil, 1,  8,  67144,  47606, 450, 460, 467, 475,  1,  1, { 41594, 36922, 47556, }, { 20, 2, 8, }, nil, nil, { 47636, }, },
	[67145]  = { nil, 1,  8,  67145,  47586, 450, 460, 467, 475,  1,  1, { 41595, 36934, 36919, 36925, 47556, }, { 8, 1, 1, 1, 4, }, nil, nil, { 47639, }, },
	[67146]  = { nil, 1,  8,  67146,  47604, 450, 460, 467, 475,  1,  1, { 41593, 41595, 34052, 47556, }, { 8, 8, 8, 8, }, nil, nil, { 47638, }, },
	[67147]  = { nil, 1,  8,  67147,  47588, 450, 460, 467, 475,  1,  1, { 41594, 47556, }, { 12, 4, }, nil, nil, { 47637, }, },
	[75250]  = { nil, 1,  8,  75250,  54447, 450, 465, 467, 470,  1,  1, { 53643, 52325, }, { 3, 6, }, true, 120000, },
	[70550]  = { nil, 1,  8,  70550,  49891, 450, 475, 487, 500,  1,  1, { 41595, 41593, 49908, }, { 10, 10, 8, }, nil, nil, { 49953, }, },
	[70551]  = { nil, 1,  8,  70551,  49890, 450, 475, 487, 500,  1,  1, { 41595, 41593, 49908, }, { 6, 6, 5, }, nil, nil, { 49954, }, },
	[70552]  = { nil, 1,  8,  70552,  49892, 450, 475, 487, 500,  1,  1, { 41594, 49908, }, { 20, 8, }, nil, nil, { 49955, }, },
	[70553]  = { nil, 1,  8,  70553,  49893, 450, 475, 487, 500,  1,  1, { 41594, 49908, }, { 10, 5, }, nil, nil, { 49956, }, },
	[75251]  = { nil, 1,  8,  75251,  54474, 455, 460, 465, 470,  1,  1, { 53643, 38426, }, { 3, 2, }, true, 120000, },
	[75252]  = { nil, 1,  8,  75252,  54477, 455, 460, 465, 470,  1,  1, { 53643, 38426, }, { 3, 2, }, true, 120000, },
	[75254]  = { nil, 1,  8,  75254,  54472, 460, 465, 470, 475,  1,  1, { 53643, 38426, }, { 3, 2, }, true, 120000, },
	[75253]  = { nil, 1,  8,  75253,  54478, 460, 470, 472, 475,  1,  1, { 53643, 52325, }, { 7, 4, }, true, 120000, },
	[75255]  = { nil, 1,  8,  75255,  54449, 460, 470, 472, 475,  1,  1, { 53643, 52326, }, { 3, 6, }, true, 120000, },
	[75256]  = { nil, 1,  8,  75256,  54476, 465, 470, 475, 480,  1,  1, { 53643, 38426, }, { 3, 2, }, true, 120000, },
	[75257]  = { nil, 1,  8,  75257,  54475, 465, 475, 477, 480,  1,  1, { 53643, 52325, }, { 8, 5, }, true, 120000, },
	[75258]  = { nil, 1,  8,  75258,  54481, 470, 475, 480, 485,  1,  1, { 53643, 38426, }, { 4, 2, }, true, 120000, },
	[75259]  = { nil, 1,  8,  75259,  54480, 470, 475, 480, 485,  1,  1, { 53643, 38426, }, { 4, 2, }, true, 120000, },
	[75261]  = { nil, 1,  8,  75261,  54482, 475, 480, 485, 490,  1,  1, { 53643, 38426, }, { 4, 2, }, true, 120000, },
	[75260]  = { nil, 1,  8,  75260,  54479, 475, 485, 487, 490,  1,  1, { 53643, 52326, }, { 9, 5, }, true, 120000, },
	[75262]  = { nil, 1,  8,  75262,  54484, 480, 485, 490, 495,  1,  1, { 53643, 38426, }, { 4, 2, }, true, 150000, },
	[75263]  = { nil, 1,  8,  75263,  54483, 480, 485, 490, 495,  1,  1, { 53643, 38426, }, { 4, 2, }, true, 150000, },
	[75264]  = { nil, 1,  8,  75264,  54443, 480, 490, 492, 495,  1,  1, { 53643, 52555, }, { 15, 15, }, true, 150000, },
	[75265]  = { nil, 1,  8,  75265,  54445, 480, 490, 492, 495,  1,  1, { 53643, 52555, 34055, 34052, }, { 9, 8, 4, 1, }, true, 150000, },
	[75266]  = { nil, 1,  8,  75266,  54485, 485, 500, 502, 505,  1,  1, { 53643, 52326, }, { 15, 6, }, true, 150000, },
	[75267]  = { nil, 1,  8,  75267,  54486, 485, 500, 502, 505,  1,  1, { 53643, 38426, }, { 6, 2, }, true, 150000, },
	[75268]  = { nil, 1,  8,  75268,  54446, 490, 500, 502, 505,  1,  1, { 53643, 52329, }, { 20, 40, }, true, 150000, },
	[99537]  = { nil, 1,  8,  99537,  75065, 490, 500, 502, 505,  1,  1, { 53643, 52326, 52325, }, { 10, 6, 6, }, true, 150000, },
	[75270]  = { nil, 1,  8,  75270,  75098, 500, 505, 510, 515,  1,  1, { 53643, 52325, 52326, }, { 6, 4, 4, }, true, 150000, },
	[75288]  = { nil, 1,  8,  75288,  54441, 500, 505, 510, 515,  1,  1, { 53643, 52325, 38426, 52078, }, { 8, 8, 8, 1, }, nil, nil, { 68199, }, },
	[75290]  = { nil, 1,  8,  75290,  75089, 500, 505, 510, 515,  1,  1, { 53643, 52325, 52328, }, { 6, 3, 3, }, true, 150000, },
	[75144]  = { nil, 1,  8,  75144,  54440, 500, 525, 530, 535,  1,  1, { 53643, 52329, }, { 8, 30, }, true, 150000, },
	[75146]  = { nil, 1,  8,  75146,  54440, 500, 525, 530, 535,  1,  1, { 53643, 52326, }, { 8, 30, }, true, 150000, },
	[75289]  = { nil, 1,  8,  75289,  54451, 500, 530, 535, 540,  1,  1, { 54440, 2325, 2605, 2321, }, { 4, 1, 1, 4, }, nil, nil, { 67541, }, },
	[75291]  = { nil, 1,  8,  75291,  75064, 505, 510, 515, 520,  1,  1, { 53643, 52326, 52325, }, { 6, 3, 3, }, true, 180000, },
	[75142]  = { nil, 1,  8,  75142,  54440, 505, 525, 530, 535,  1,  1, { 53643, 52327, }, { 8, 30, }, true, 150000, },
	[75269]  = { nil, 1,  8,  75269,  75086, 510, 515, 520, 525,  1,  1, { 53643, 52325, 52328, }, { 6, 3, 3, }, true, 180000, },
	[75292]  = { nil, 1,  8,  75292,  75091, 510, 515, 520, 525,  1,  1, { 53643, 52325, 52328, }, { 10, 4, 4, }, true, 180000, },
	[75293]  = { nil, 1,  8,  75293,  75096, 510, 515, 520, 525,  1,  1, { 53643, 52326, 52325, }, { 10, 4, 4, }, true, 180000, },
	[75145]  = { nil, 1,  8,  75145,  54440, 510, 525, 530, 535,  1,  1, { 53643, 52325, }, { 8, 30, }, true, 150000, },
	[100585] = { nil, 1,  8, 100585,  70138, 515, 515, 515, 515,  1,  1, { 54440, }, { 3, }, nil, nil, { 70176, }, },
	[75294]  = { nil, 1,  8,  75294,  75087, 515, 520, 525, 530,  1,  1, { 53643, 52325, 52326, }, { 10, 4, 4, }, true, 180000, },
	[75295]  = { nil, 1,  8,  75295,  75070, 515, 520, 525, 530,  1,  1, { 53643, 52326, 52325, }, { 10, 4, 4, }, true, 180000, },
	[75141]  = { nil, 1,  8,  75141,  54440, 515, 525, 530, 535,  1,  1, { 53643, 52328, }, { 8, 30, }, true, 150000, },
	[75296]  = { nil, 1,  8,  75296,  75063, 520, 525, 530, 535,  1,  1, { 53643, 52325, 52328, }, { 10, 4, 4, }, true, 180000, },
	[75297]  = { nil, 1,  8,  75297,  75095, 520, 525, 530, 535,  1,  1, { 53643, 52326, 52325, }, { 10, 4, 4, }, true, 180000, },
	[99448]  = { nil, 1,  8,  99448,  69944, 525, 525, 527, 530,  1,  1, { 54440, 69237, }, { 8, 4, }, nil, nil, { 69965, }, },
	[99449]  = { nil, 1,  8,  99449,  69945, 525, 525, 527, 530,  1,  1, { 54440, 69237, }, { 8, 4, }, nil, nil, { 69966, }, },
	[99459]  = { nil, 1,  8,  99459,  69953, 525, 525, 527, 530,  1,  1, { 54440, 69237, }, { 8, 4, }, nil, nil, { 69975, }, },
	[99460]  = { nil, 1,  8,  99460,  69954, 525, 525, 527, 530,  1,  1, { 54440, 69237, }, { 8, 4, }, nil, nil, { 69976, }, },
	[75298]  = { nil, 1,  8,  75298,  54504, 525, 525, 530, 535,  1,  1, { 54440, }, { 4, }, nil, nil, { 54601, }, },
	[75299]  = { nil, 1,  8,  75299,  54503, 525, 525, 530, 535,  1,  1, { 54440, }, { 4, }, nil, nil, { 54602, }, },
	[75300]  = { nil, 1,  8,  75300,  54505, 525, 525, 530, 535,  1,  1, { 54440, }, { 6, }, nil, nil, { 54603, }, },
	[75301]  = { nil, 1,  8,  75301,  54506, 525, 525, 530, 535,  1,  1, { 54440, }, { 6, }, nil, nil, { 54604, }, },
	[75302]  = { nil, 1,  8,  75302,  75082, 525, 525, 530, 535,  1,  1, { 53643, 52325, 52328, }, { 10, 4, 4, }, nil, nil, { 54597, }, },
	[75303]  = { nil, 1,  8,  75303,  75088, 525, 525, 530, 535,  1,  1, { 53643, 52325, 52328, }, { 8, 4, 4, }, nil, nil, { 54598, }, },
	[75304]  = { nil, 1,  8,  75304,  75062, 525, 525, 530, 535,  1,  1, { 53643, 52325, 52328, }, { 10, 4, 4, }, nil, nil, { 54596, }, },
	[75305]  = { nil, 1,  8,  75305,  75093, 525, 525, 530, 535,  1,  1, { 53643, 52326, 52325, }, { 10, 4, 4, }, nil, nil, { 54595, }, },
	[75306]  = { nil, 1,  8,  75306,  75073, 525, 525, 530, 535,  1,  1, { 53643, 52326, 52325, }, { 10, 4, 4, }, nil, nil, { 54593, }, },
	[75307]  = { nil, 1,  8,  75307,  75072, 525, 525, 530, 535,  1,  1, { 53643, 52326, 52325, }, { 10, 4, 4, }, nil, nil, { 54594, }, },
	[75308]  = { nil, 1,  8,  75308,  54444, 525, 525, 530, 535,  1,  1, { 54440, }, { 8, }, nil, nil, { 54605, }, },
	[75309]  = { nil, 1,  8,  75309,  54448, 525, 525, 530, 535,  1,  1, { 54440, }, { 1, }, nil, nil, { 54599, }, },
	[75310]  = { nil, 1,  8,  75310,  54450, 525, 525, 530, 535,  1,  1, { 54440, }, { 1, }, nil, nil, { 54600, }, },
	[94743]  = { nil, 1,  8,  94743,  54440, 525, 525, 530, 535,  1,  1, { 53643, 52078, }, { 8, 4, }, true, 240000, },
	[101920] = { nil, 1,  8, 101920,  71981, 525, 525, 530, 535,  1,  1, { 54440, 71998, }, { 8, 8, }, nil, nil, { 72000, }, },
	[101921] = { nil, 1,  8, 101921,  71980, 525, 525, 530, 535,  1,  1, { 54440, 71998, }, { 8, 8, }, nil, nil, { 72002, }, },
	[101922] = { nil, 1,  8, 101922,  71990, 525, 525, 530, 535,  1,  1, { 54440, 71998, }, { 8, 4, }, nil, nil, { 72003, }, },
	[101923] = { nil, 1,  8, 101923,  71989, 525, 525, 530, 535,  1,  1, { 54440, 71998, }, { 5, 4, }, nil, nil, { 72004, }, },
	[12900]  = { nil, 1,  9,  12900,  10719,   0, 205, 225, 245,  1,  1, { 10559, 10560, 3860, }, { 1, 1, 4, }, },
	[12722]  = { nil, 1,  9,  12722,  10585,   0, 240, 250, 260,  1,  1, { 10561, 3860, 4389, 10560, }, { 1, 2, 1, 1, }, },
	[12904]  = { nil, 1,  9,  12904,  10723,   0, 240, 250, 260,  1,  1, { 10561, 3860, 4389, 10560, }, { 1, 2, 1, 1, }, },
	[30561]  = { nil, 1,  9,  30561,  23831,   0, 325, 330, 335,  1,  1, { 23782, 23783, 10558, }, { 1, 4, 1, }, },
	[30573]  = { nil, 1,  9,  30573,  23832,   0, 325, 330, 335,  1,  1, { 23782, 23783, 10558, }, { 1, 4, 1, }, },
	[3918]   = { nil, 1,  9,   3918,   4357,   1,  20,  30,  40,  1,  1, { 2835, }, { 1, }, },
	[3919]   = { nil, 1,  9,   3919,   4358,   1,  30,  45,  60,  1,  1, { 4357, 2589, }, { 1, 1, }, },
	[3939]   = { nil, 1,  9,   3939,   4372,   1, 145, 157, 170,  1,  1, { 4371, 4359, 4400, 1206, }, { 2, 2, 1, 3, }, true, 500, { 13309, }, },
	[3922]   = { nil, 1,  9,   3922,   4359,  30,  45,  52,  60,  1,  1, { 2840, }, { 1, }, true, 115, },
	[3923]   = { nil, 1,  9,   3923,   4360,  30,  60,  75,  90,  1,  1, { 4357, 4359, }, { 2, 1, }, true, 130, },
	[7430]   = { nil, 1,  9,   7430,   6219,  50,  70,  80,  90,  1,  1, { 2840, }, { 6, }, true, 150, },
	[3925]   = { nil, 1,  9,   3925,   4362,  50,  80,  95, 110,  1,  1, { 2840, 4359, 4399, }, { 4, 3, 1, }, true, 150, },
	[3977]   = { nil, 1,  9,   3977,   4405,  60,  90, 105, 120,  1,  1, { 2840, 774, 4359, }, { 2, 2, 1, }, true, 200, },
	[3929]   = { nil, 1,  9,   3929,   4364,  65,  85,  90,  95,  1,  1, { 2836, }, { 1, }, true, 250, },
	[3931]   = { nil, 1,  9,   3931,   4365,  65,  95, 100, 105,  1,  1, { 4364, 2589, }, { 1, 1, }, true, 250, },
	[3928]   = { nil, 1,  9,   3928,   4401,  75, 105, 120, 135,  1,  1, { 4359, 2840, 774, }, { 1, 1, 2, }, nil, nil, { 4408, }, },
	[3932]   = { nil, 1,  9,   3932,   4366,  85, 115, 130, 145,  1,  1, { 2841, 2592, }, { 2, 2, }, true, 300, },
	[3973]   = { nil, 1,  9,   3973,   4404,  90, 110, 125, 140,  1,  1, { 2842, }, { 1, }, true, 300, },
	[8334]   = { nil, 1,  9,   8334,   6712, 100, 115, 122, 130,  1,  1, { 2841, }, { 3, }, true, 300, },
	[8339]   = { nil, 1,  9,   8339,   6714, 100, 115, 122, 130,  1,  3, { 4364, 2592, }, { 4, 1, }, nil, nil, { 6716, }, },
	[3933]   = { nil, 1,  9,   3933,   4367, 100, 130, 145, 160,  1,  1, { 4364, 2318, 159, }, { 2, 1, 1, }, nil, nil, { 4409, }, },
	[3934]   = { nil, 1,  9,   3934,   4368, 100, 130, 145, 160,  1,  1, { 2841, 818, }, { 8, 2, }, true, 400, },
	[3938]   = { nil, 1,  9,   3938,   4371, 105, 115, 135, 155,  1,  1, { 2841, }, { 2, }, true, 450, },
	[3937]   = { nil, 1,  9,   3937,   4370, 105, 125, 140, 155,  2,  4, { 2840, 4364, 4404, }, { 3, 4, 1, }, true, 450, },
	[3936]   = { nil, 1,  9,   3936,   4369, 105, 130, 142, 155,  1,  1, { 4371, 4406, 4399, }, { 4, 1, 1, }, true, 420, },
	[3978]   = { nil, 1,  9,   3978,   4406, 110, 135, 147, 160,  1,  1, { 4371, 1206, }, { 1, 1, }, true, 475, },
	[3941]   = { nil, 1,  9,   3941,   4374, 120, 120, 145, 170,  1,  3, { 4364, 2841, 4404, 2592, }, { 4, 2, 1, 1, }, true, 500, },
	[3940]   = { nil, 1,  9,   3940,   4373, 120, 145, 157, 170,  1,  1, { 2319, 1210, }, { 4, 2, }, nil, nil, { 4410, }, },
	[3945]   = { nil, 1,  9,   3945,   4377, 125, 125, 135, 145,  1,  1, { 2838, }, { 1, }, true, 500, },
	[3946]   = { nil, 1,  9,   3946,   4378, 125, 125, 135, 145,  1,  5, { 4377, 2592, }, { 2, 1, }, true, 500, },
	[26416]  = { nil, 1,  9,  26416,  21558, 125, 125, 137, 150,  3,  3, { 4364, 2319, }, { 1, 1, }, nil, nil, { 21724, }, },
	[26417]  = { nil, 1,  9,  26417,  21559, 125, 125, 137, 150,  3,  3, { 4364, 2319, }, { 1, 1, }, nil, nil, { 21725, }, },
	[26418]  = { nil, 1,  9,  26418,  21557, 125, 125, 137, 150,  3,  3, { 4364, 2319, }, { 1, 1, }, nil, nil, { 21726, }, },
	[3942]   = { nil, 1,  9,   3942,   4375, 125, 125, 150, 175,  1,  1, { 2841, 2592, }, { 2, 1, }, true, 500, },
	[3944]   = { nil, 1,  9,   3944,   4376, 125, 125, 150, 175,  1,  1, { 4375, 4402, }, { 1, 1, }, nil, nil, { 4411, }, },
	[9269]   = { nil, 1,  9,   9269,   7506, 125, 150, 162, 175,  1,  1, { 2841, 4375, 814, 818, 774, }, { 6, 1, 2, 1, 1, }, nil, nil, { 7560, }, },
	[3949]   = { nil, 1,  9,   3949,   4379, 130, 155, 167, 180,  1,  1, { 4371, 4375, 4400, 2842, }, { 2, 2, 1, 3, }, true, 550, },
	[6458]   = { nil, 1,  9,   6458,   5507, 135, 160, 172, 185,  1,  1, { 4371, 4375, 1206, }, { 2, 2, 1, }, true, 400, },
	[3950]   = { nil, 1,  9,   3950,   4380, 140, 140, 165, 190,  2,  4, { 4377, 2841, 4404, }, { 2, 3, 1, }, true, 600, },
	[3952]   = { nil, 1,  9,   3952,   4381, 140, 165, 177, 190,  1,  1, { 4371, 4375, 2319, 1206, }, { 1, 2, 2, 1, }, nil, nil, { 14639, }, },
	[3953]   = { nil, 1,  9,   3953,   4382, 145, 145, 170, 195,  1,  1, { 2841, 2319, 2592, }, { 2, 1, 1, }, true, 600, },
	[3954]   = { nil, 1,  9,   3954,   4383, 145, 170, 182, 195,  1,  1, { 4371, 4375, 4400, 1705, }, { 3, 3, 1, 2, }, nil, nil, { 4412, }, },
	[9271]   = { nil, 1,  9,   9271,   6533, 150, 150, 160, 170,  3,  3, { 2841, 6530, 4364, }, { 2, 1, 1, }, true, 500, },
	[23066]  = { nil, 1,  9,  23066,   9318, 150, 150, 162, 175,  3,  3, { 4377, 4234, }, { 1, 1, }, nil, nil, { 18647, }, },
	[23067]  = { nil, 1,  9,  23067,   9312, 150, 150, 162, 175,  3,  3, { 4377, 4234, }, { 1, 1, }, nil, nil, { 18649, }, },
	[23068]  = { nil, 1,  9,  23068,   9313, 150, 150, 162, 175,  3,  3, { 4377, 4234, }, { 1, 1, }, nil, nil, { 18648, }, },
	[12584]  = { nil, 1,  9,  12584,  10558, 150, 150, 170, 190,  3,  3, { 3577, }, { 1, }, true, 1000, },
	[3955]   = { nil, 1,  9,   3955,   4384, 150, 175, 187, 200,  1,  1, { 4382, 4375, 4377, 2592, }, { 1, 1, 2, 2, }, true, 750, },
	[3956]   = { nil, 1,  9,   3956,   4385, 150, 175, 187, 200,  1,  1, { 2319, 1206, 4368, }, { 4, 2, 1, }, true, 750, },
	[3957]   = { nil, 1,  9,   3957,   4386, 155, 175, 185, 195,  1,  1, { 4375, 3829, }, { 1, 1, }, nil, nil, { 13308, }, },
	[3958]   = { nil, 1,  9,   3958,   4387, 160, 160, 170, 180,  1,  1, { 3575, }, { 2, }, true, 800, },
	[3959]   = { nil, 1,  9,   3959,   4388, 160, 180, 190, 200,  1,  1, { 4375, 4306, 1529, 4371, }, { 3, 2, 1, 1, }, nil, nil, { 4413, }, },
	[9273]   = { nil, 1,  9,   9273,   7148, 165, 165, 180, 200,  1,  1, { 3575, 4375, 814, 4306, 1210, 7191, }, { 6, 2, 2, 2, 2, 1, }, nil, nil, { 7561, }, },
	[3960]   = { nil, 1,  9,   3960,   4403, 165, 185, 195, 205,  1,  1, { 4371, 4387, 4377, 2319, }, { 4, 1, 4, 4, }, nil, nil, { 4414, }, },
	[3961]   = { nil, 1,  9,   3961,   4389, 170, 170, 190, 210,  1,  1, { 3575, 10558, }, { 1, 1, }, true, 900, },
	[12585]  = { nil, 1,  9,  12585,  10505, 175, 175, 185, 195,  1,  1, { 7912, }, { 2, }, true, 1000, },
	[12586]  = { nil, 1,  9,  12586,  10507, 175, 175, 185, 195,  2,  2, { 10505, 4306, }, { 1, 1, }, true, 1000, },
	[26420]  = { nil, 1,  9,  26420,  21589, 175, 175, 187, 200,  3,  3, { 4377, 4234, }, { 1, 1, }, nil, nil, { 21727, }, },
	[26421]  = { nil, 1,  9,  26421,  21590, 175, 175, 187, 200,  3,  3, { 4377, 4234, }, { 1, 1, }, nil, nil, { 21728, }, },
	[26422]  = { nil, 1,  9,  26422,  21592, 175, 175, 187, 200,  3,  3, { 4377, 4234, }, { 1, 1, }, nil, nil, { 21729, }, },
	[3962]   = { nil, 1,  9,   3962,   4390, 175, 175, 195, 215,  2,  4, { 3575, 4377, 4306, }, { 1, 1, 1, }, true, 1000, },
	[3963]   = { nil, 1,  9,   3963,   4391, 175, 175, 195, 215,  1,  1, { 4387, 4382, 4389, 4234, }, { 2, 1, 2, 4, }, true, 1000, },
	[12590]  = { nil, 1,  9,  12590,  10498, 175, 175, 195, 215,  1,  1, { 3859, }, { 4, }, true, 1000, },
	[12587]  = { nil, 1,  9,  12587,  10499, 175, 195, 205, 215,  1,  1, { 4234, 3864, }, { 6, 2, }, nil, nil, { 10601, }, },
	[3979]   = { nil, 1,  9,   3979,   4407, 180, 200, 210, 220,  1,  1, { 4371, 1529, 3864, }, { 1, 1, 1, }, nil, nil, { 13310, }, },
	[3965]   = { nil, 1,  9,   3965,   4392, 185, 185, 205, 225,  1,  1, { 4387, 4382, 4389, 4234, }, { 1, 1, 1, 4, }, true, 1200, },
	[8243]   = { nil, 1,  9,   8243,   4852, 185, 185, 205, 225,  1,  1, { 4611, 4377, 4306, }, { 1, 1, 1, }, nil, nil, { 6672, }, },
	[3966]   = { nil, 1,  9,   3966,   4393, 185, 205, 215, 225,  1,  1, { 4234, 3864, }, { 6, 2, }, nil, nil, { 4415, }, },
	[3967]   = { nil, 1,  9,   3967,   4394, 190, 190, 210, 230,  2,  2, { 3575, 4377, 4404, }, { 3, 3, 1, }, true, 1400, },
	[21940]  = { nil, 1,  9,  21940,  17716, 190, 190, 210, 230,  1,  1, { 3860, 4389, 17202, 3829, }, { 8, 4, 4, 1, }, nil, nil, { 17720, }, },
	[12589]  = { nil, 1,  9,  12589,  10559, 195, 195, 215, 235,  1,  1, { 3860, }, { 3, }, true, 1300, },
	[3968]   = { nil, 1,  9,   3968,   4395, 195, 215, 225, 235,  1,  1, { 4377, 3575, 4389, }, { 3, 2, 1, }, nil, nil, { 4416, }, },
	[23069]  = { nil, 1,  9,  23069,  18588, 200, 200, 210, 220,  1,  1, { 10505, 4338, }, { 1, 2, }, nil, nil, { 18650, }, },
	[3972]   = { nil, 1,  9,   3972,   4398, 200, 200, 220, 240,  1,  1, { 10505, 4234, 159, }, { 2, 2, 1, }, nil, nil, { 4417, }, },
	[12591]  = { nil, 1,  9,  12591,  10560, 200, 200, 220, 240,  1,  1, { 3860, 4338, 10505, }, { 1, 1, 1, }, true, 1500, },
	[15255]  = { nil, 1,  9,  15255,  11590, 200, 200, 220, 240,  1,  1, { 3860, 4338, 10505, }, { 1, 1, 1, }, true, 1500, },
	[3969]   = { nil, 1,  9,   3969,   4396, 200, 220, 230, 240,  1,  1, { 4382, 4387, 4389, 3864, }, { 1, 2, 2, 1, }, nil, nil, { 13311, }, },
	[3971]   = { nil, 1,  9,   3971,   4397, 200, 220, 230, 240,  1,  1, { 4389, 1529, 1705, 3864, 7191, }, { 4, 2, 2, 2, 1, }, nil, nil, { 7742, }, },
	[12715]  = { nil, 1,  9,  12715,  10644, 205, 205, 205, 205,  1,  1, { 10648, 10647, }, { 1, 1, }, true, 1000, },
	[12895]  = { nil, 1,  9,  12895,  10713, 205, 205, 205, 205,  1,  1, { 10648, 10647, }, { 1, 1, }, true, 1500, },
	[13240]  = { nil, 1,  9,  13240,  10577, 205, 205, 205, 205,  1,  1, { 10577, 3860, 10505, }, { 1, 1, 3, }, },
	[15628]  = { nil, 1,  9,  15628,  11825, 205, 205, 205, 205,  1,  1, { 4394, 7077, 7191, 3860, }, { 1, 1, 1, 6, }, nil, nil, { 11828, }, },
	[15633]  = { nil, 1,  9,  15633,  11826, 205, 205, 205, 205,  1,  1, { 7075, 4389, 7191, 3860, 6037, }, { 1, 2, 1, 2, 1, }, nil, nil, { 11827, }, },
	[12760]  = { nil, 1,  9,  12760,  10646, 205, 205, 225, 245,  1,  1, { 4338, 10505, 10560, }, { 1, 3, 1, }, true, 1500, },
	[12594]  = { nil, 1,  9,  12594,  10500, 205, 225, 235, 245,  1,  1, { 4385, 3864, 7068, 4234, }, { 1, 2, 2, 4, }, true, 1600, },
	[12595]  = { nil, 1,  9,  12595,  10508, 205, 225, 235, 245,  1,  1, { 10559, 10560, 4400, 3860, 7068, }, { 1, 1, 1, 4, 2, }, true, 1600, },
	[12716]  = { nil, 1,  9,  12716,  10577, 205, 225, 235, 245,  1,  1, { 10559, 3860, 10505, 10558, 7068, }, { 2, 4, 5, 1, 1, }, true, 1500, },
	[12717]  = { nil, 1,  9,  12717,  10542, 205, 225, 235, 245,  1,  1, { 3860, 3864, 7067, }, { 8, 1, 4, }, true, 1500, },
	[12718]  = { nil, 1,  9,  12718,  10543, 205, 225, 235, 245,  1,  1, { 3860, 3864, 7068, }, { 8, 1, 4, }, true, 1500, },
	[12899]  = { nil, 1,  9,  12899,  10716, 205, 225, 235, 245,  1,  1, { 10559, 10560, 3860, 1529, }, { 1, 1, 4, 2, }, true, 1500, },
	[12597]  = { nil, 1,  9,  12597,  10546, 210, 230, 240, 250,  1,  1, { 10559, 7909, 4304, }, { 1, 2, 2, }, nil, nil, { 10602, }, },
	[12902]  = { nil, 1,  9,  12902,  10720, 210, 230, 240, 250,  1,  1, { 10559, 10285, 4337, 10505, 3860, }, { 1, 2, 4, 2, 4, }, true, 1800, },
	[12905]  = { nil, 1,  9,  12905,  10724, 210, 245, 255, 265,  1,  1, { 10026, 10559, 4234, 10505, 4389, }, { 1, 2, 4, 8, 4, }, true, 1500, },
	[12599]  = { nil, 1,  9,  12599,  10561, 215, 215, 235, 255,  1,  1, { 3860, }, { 3, }, true, 1800, },
	[12603]  = { nil, 1,  9,  12603,  10514, 215, 215, 235, 255,  3,  3, { 10561, 10560, 10505, }, { 1, 1, 1, }, true, 1800, },
	[12897]  = { nil, 1,  9,  12897,  10545, 215, 230, 240, 250,  1,  1, { 10500, 10559, 10558, 4234, }, { 1, 1, 2, 2, }, true, 2200, },
	[12903]  = { nil, 1,  9,  12903,  10721, 215, 235, 245, 255,  1,  1, { 7387, 3860, 6037, 10560, 7909, }, { 1, 4, 2, 1, 2, }, true, 2000, },
	[12607]  = { nil, 1,  9,  12607,  10501, 220, 240, 250, 260,  1,  1, { 4304, 7909, 10592, }, { 4, 2, 1, }, nil, nil, { 10603, }, },
	[12614]  = { nil, 1,  9,  12614,  10510, 220, 240, 250, 260,  1,  1, { 10559, 10560, 4400, 3860, 3864, }, { 2, 1, 1, 6, 2, }, nil, nil, { 10604, }, },
	[26423]  = { nil, 1,  9,  26423,  21571, 225, 225, 237, 250,  3,  3, { 10505, 4304, }, { 1, 1, }, nil, nil, { 21730, }, },
	[26424]  = { nil, 1,  9,  26424,  21574, 225, 225, 237, 250,  3,  3, { 10505, 4304, }, { 1, 1, }, nil, nil, { 21731, }, },
	[26425]  = { nil, 1,  9,  26425,  21576, 225, 225, 237, 250,  3,  3, { 10505, 4304, }, { 1, 1, }, nil, nil, { 21732, }, },
	[8895]   = { nil, 1,  9,   8895,   7189, 225, 245, 255, 265,  1,  1, { 10026, 10559, 4234, 9061, 10560, }, { 1, 2, 4, 2, 1, }, true, 2200, { 7192, }, nil, nil, nil, 20222, },
	[12615]  = { nil, 1,  9,  12615,  10502, 225, 245, 255, 265,  1,  1, { 4304, 7910, }, { 4, 2, }, true, 2500, { 10605, }, },
	[12616]  = { nil, 1,  9,  12616,  10518, 225, 245, 255, 265,  1,  1, { 4339, 10285, 10560, 10505, }, { 4, 2, 1, 4, }, nil, nil, { 10606, }, },
	[26442]  = { nil, 1,  9,  26442,  21569, 225, 245, 255, 265,  1,  1, { 9060, 9061, 10560, 10561, }, { 1, 1, 1, 1, }, nil, nil, { 21738, 44919, }, },
	[12755]  = { nil, 1,  9,  12755,  10587, 230, 230, 250, 270,  1,  1, { 10561, 10505, 6037, 10560, 4407, }, { 2, 4, 6, 1, 2, }, true, 2400, },
	[12617]  = { nil, 1,  9,  12617,  10506, 230, 250, 260, 270,  1,  1, { 3860, 10561, 6037, 818, 774, }, { 8, 1, 1, 4, 4, }, true, 2200, { 10607, }, },
	[12618]  = { nil, 1,  9,  12618,  10503, 230, 250, 260, 270,  1,  1, { 4304, 7910, }, { 6, 2, }, true, 2200, },
	[12906]  = { nil, 1,  9,  12906,  10725, 230, 250, 260, 270,  1,  1, { 10561, 6037, 3860, 9060, 10558, 1529, }, { 1, 6, 6, 2, 1, 2, }, true, 2400, },
	[12619]  = { nil, 1,  9,  12619,  10562, 235, 235, 255, 275,  4,  4, { 10561, 10560, 10505, }, { 2, 1, 2, }, true, 2400, },
	[12754]  = { nil, 1,  9,  12754,  10586, 235, 235, 255, 275,  2,  2, { 10561, 9061, 10507, 10560, }, { 1, 1, 6, 1, }, true, 2600, },
	[12907]  = { nil, 1,  9,  12907,  10726, 235, 255, 265, 275,  1,  1, { 3860, 6037, 10558, 7910, 4338, }, { 10, 4, 1, 2, 4, }, true, 2600, },
	[12620]  = { nil, 1,  9,  12620,  10548, 240, 260, 270, 280,  1,  1, { 10559, 7910, 6037, }, { 1, 1, 2, }, nil, nil, { 10608, }, },
	[12759]  = { nil, 1,  9,  12759,  10645, 240, 260, 270, 280,  1,  1, { 10559, 10560, 12808, 7972, 9060, }, { 2, 1, 1, 4, 1, }, true, 2800, },
	[12908]  = { nil, 1,  9,  12908,  10727, 240, 260, 270, 280,  1,  1, { 10559, 9061, 3860, 6037, 10560, }, { 2, 4, 6, 6, 1, }, true, 2800, },
	[12622]  = { nil, 1,  9,  12622,  10504, 245, 265, 275, 285,  1,  1, { 4304, 1529, 7909, 10286, 8153, }, { 8, 3, 3, 2, 2, }, true, 2800, },
	[12758]  = { nil, 1,  9,  12758,  10588, 245, 265, 275, 285,  1,  1, { 10543, 9061, 3860, 10560, }, { 1, 4, 4, 1, }, true, 3000, },
	[19788]  = { nil, 1,  9,  19788,  15992, 250, 250, 255, 260,  1,  1, { 12365, }, { 2, }, true, 4000, },
	[23070]  = { nil, 1,  9,  23070,  18641, 250, 250, 260, 270,  2,  2, { 15992, 14047, }, { 2, 3, }, true, 5000, },
	[23507]  = { nil, 1,  9,  23507,  19026, 250, 250, 260, 270,  4,  4, { 15992, 14047, 8150, }, { 2, 2, 1, }, nil, nil, { 19027, }, },
	[12624]  = { nil, 1,  9,  12624,  10576, 250, 270, 280, 290,  1,  1, { 3860, 7077, 6037, 7910, }, { 4, 2, 4, 1, }, nil, nil, { 10609, }, },
	[19567]  = { nil, 1,  9,  19567,  15846, 250, 270, 280, 290,  1,  1, { 10561, 12359, 10558, }, { 1, 6, 3, }, true, 4000, },
	[63750]  = { nil, 1,  9,  63750,  45631, 250, 270, 280, 290,  1,  1, { 15994, 6037, 7078, }, { 4, 6, 6, }, true, 5000, },
	[26011]  = { nil, 1,  9,  26011,  21277, 250, 320, 330, 340,  1,  1, { 15407, 15994, 7079, 18631, 10558, }, { 1, 4, 2, 2, 1, }, },
	[23129]  = { nil, 1,  9,  23129,  18660, 260, 260, 265, 270,  1,  1, { 10561, 15994, 10558, 10560, 3864, }, { 1, 2, 1, 1, 1, }, nil, nil, { 18661, }, nil, nil, nil, 20219, },
	[23071]  = { nil, 1,  9,  23071,  18631, 260, 270, 275, 280,  1,  1, { 6037, 7067, 7069, }, { 2, 2, 1, }, true, 5000, { 18651, }, },
	[19790]  = { nil, 1,  9,  19790,  15993, 260, 280, 290, 300,  3,  3, { 15994, 12359, 15992, 14047, }, { 1, 3, 3, 3, }, true, 10000, { 16041, }, },
	[19791]  = { nil, 1,  9,  19791,  15994, 260, 280, 290, 300,  1,  1, { 12359, 14047, }, { 3, 1, }, true, 5000, { 16042, }, },
	[19792]  = { nil, 1,  9,  19792,  15995, 260, 280, 290, 300,  1,  1, { 10559, 10561, 15994, 12359, 10546, }, { 2, 2, 2, 4, 1, }, true, 10000, { 16043, }, },
	[23077]  = { nil, 1,  9,  23077,  18634, 260, 280, 290, 300,  1,  1, { 15994, 18631, 12361, 7078, 3829, 13467, }, { 6, 2, 2, 4, 2, 4, }, nil, nil, { 18652, }, },
	[23096]  = { nil, 1,  9,  23096,  18645, 265, 275, 280, 285,  2,  2, { 12359, 7191, }, { 4, 1, }, nil, nil, { 18654, }, nil, nil, nil, 20219, },
	[19793]  = { nil, 1,  9,  19793,  15996, 265, 285, 295, 305,  1,  1, { 12803, 15994, 10558, 8170, }, { 1, 4, 1, 1, }, nil, nil, { 16044, }, },
	[23078]  = { nil, 1,  9,  23078,  18587, 265, 285, 295, 305,  1,  1, { 15994, 18631, 7191, 14227, 7910, }, { 2, 2, 2, 2, 2, }, nil, nil, { 18653, }, nil, nil, nil, 20222, },
	[19794]  = { nil, 1,  9,  19794,  15999, 270, 290, 300, 310,  1,  1, { 10502, 7910, 12810, 14047, }, { 1, 4, 2, 8, }, true, 20000, { 16045, }, },
	[26426]  = { nil, 1,  9,  26426,  21714, 275, 275, 280, 285,  3,  3, { 15992, 8170, }, { 1, 1, }, nil, nil, { 21733, }, },
	[26427]  = { nil, 1,  9,  26427,  21716, 275, 275, 280, 285,  3,  3, { 15992, 8170, }, { 1, 1, }, nil, nil, { 21734, }, },
	[26428]  = { nil, 1,  9,  26428,  21718, 275, 275, 280, 285,  3,  3, { 15992, 8170, }, { 1, 1, }, nil, nil, { 21735, }, },
	[28327]  = { nil, 1,  9,  28327,  22728, 275, 275, 280, 285,  1,  1, { 3860, 10558, }, { 3, 1, }, nil, nil, { 22729, }, },
	[39895]  = { nil, 1,  9,  39895,   7191, 275, 275, 280, 285,  5,  5, { 20816, 7078, }, { 3, 2, }, nil, nil, { 32381, }, },
	[23080]  = { nil, 1,  9,  23080,  18594, 275, 275, 285, 295,  1,  1, { 15994, 15992, 8170, 159, }, { 2, 3, 2, 1, }, nil, nil, { 18656, }, },
	[23079]  = { nil, 1,  9,  23079,  18637, 275, 285, 290, 295,  1,  1, { 16000, 18631, 14047, }, { 2, 1, 2, }, nil, nil, { 18655, }, },
	[19795]  = { nil, 1,  9,  19795,  16000, 275, 295, 305, 315,  1,  1, { 12359, }, { 6, }, true, 10000, { 16047, }, },
	[19796]  = { nil, 1,  9,  19796,  16004, 275, 295, 305, 315,  1,  1, { 16000, 11371, 10546, 12361, 12799, 8170, }, { 2, 6, 2, 2, 2, 4, }, nil, nil, { 16048, }, },
	[19814]  = { nil, 1,  9,  19814,  16023, 275, 295, 305, 315,  1,  1, { 10561, 16000, 15994, 6037, 8170, 14047, }, { 1, 1, 2, 1, 2, 4, }, nil, nil, { 16046, }, },
	[26443]  = { nil, 1,  9,  26443,  21570, 275, 295, 305, 315,  2,  2, { 10561, 9061, }, { 1, 1, }, nil, nil, { 21737, 44918, }, },
	[23486]  = { nil, 1,  9,  23486,  18984, 285, 285, 295, 305,  1,  1, { 3860, 18631, 7077, 7910, 10586, }, { 10, 1, 4, 2, 1, }, },
	[23489]  = { nil, 1,  9,  23489,  18986, 285, 285, 295, 305,  1,  1, { 3860, 18631, 7075, 7079, 7909, 9060, }, { 12, 2, 4, 2, 4, 1, }, },
	[19799]  = { nil, 1,  9,  19799,  16005, 285, 305, 315, 325,  3,  3, { 15994, 11371, 15992, 14047, }, { 2, 1, 3, 3, }, nil, nil, { 16049, }, },
	[19815]  = { nil, 1,  9,  19815,  16006, 285, 305, 315, 325,  1,  1, { 12360, 14227, }, { 1, 1, }, nil, nil, { 16050, }, },
	[19819]  = { nil, 1,  9,  19819,  16009, 290, 310, 320, 330,  1,  1, { 16006, 10558, 15994, 12799, }, { 2, 1, 1, 1, }, nil, nil, { 16052, }, },
	[19825]  = { nil, 1,  9,  19825,  16008, 290, 310, 320, 330,  1,  1, { 10500, 12364, 12810, }, { 1, 2, 4, }, true, 20000, { 16053, }, },
	[23081]  = { nil, 1,  9,  23081,  18638, 290, 310, 320, 330,  1,  1, { 11371, 18631, 7080, 7910, 12800, }, { 4, 3, 6, 4, 2, }, nil, nil, { 18657, }, },
	[30305]  = { nil, 1,  9,  30305,  23783, 300, 300, 305, 310,  1,  1, { 23445, }, { 1, }, true, 10000, },
	[30303]  = { nil, 1,  9,  30303,  23781, 300, 300, 310, 320,  4,  4, { 22574, 22573, }, { 1, 2, }, true, 10000, },
	[30304]  = { nil, 1,  9,  30304,  23782, 300, 300, 310, 320,  1,  1, { 23445, }, { 3, }, true, 10000, },
	[19830]  = { nil, 1,  9,  19830,  16022, 300, 320, 330, 340,  1,  1, { 10576, 16006, }, { 1, 4, }, nil, nil, { 16054, }, },
	[19831]  = { nil, 1,  9,  19831,  16040, 300, 320, 330, 340,  3,  3, { 16006, 12359, 14047, }, { 1, 3, 1, }, nil, nil, { 16055, }, },
	[19833]  = { nil, 1,  9,  19833,  16007, 300, 320, 330, 340,  1,  1, { 12360, 16000, 7078, 7076, 12800, 12810, }, { 10, 2, 2, 2, 2, 2, }, nil, nil, { 16056, }, },
	[22704]  = { nil, 1,  9,  22704,  18232, 300, 320, 330, 340,  1,  1, { 12359, 7191, }, { 16, 2, }, nil, nil, { 18235, }, },
	[22793]  = { nil, 1,  9,  22793,  18283, 300, 320, 330, 340,  1,  1, { 17011, 7076, 16006, 11371, 16000, }, { 2, 2, 4, 6, 1, }, nil, nil, { 18290, }, },
	[22795]  = { nil, 1,  9,  22795,  18282, 300, 320, 330, 340,  1,  1, { 17010, 17011, 12360, 16006, 16000, }, { 4, 2, 6, 2, 2, }, nil, nil, { 18292, }, },
	[22797]  = { nil, 1,  9,  22797,  18168, 300, 320, 330, 340,  1,  1, { 12360, 16006, 7082, 12803, 7076, }, { 6, 2, 8, 12, 8, }, nil, nil, { 18291, }, },
	[23082]  = { nil, 1,  9,  23082,  18639, 300, 320, 330, 340,  1,  1, { 11371, 18631, 12803, 12808, 12800, 12799, }, { 8, 4, 6, 4, 2, 2, }, nil, nil, { 18658, }, },
	[24356]  = { nil, 1,  9,  24356,  19999, 300, 320, 330, 340,  1,  1, { 7910, 12804, 12810, }, { 2, 6, 6, }, nil, nil, { 20000, }, },
	[24357]  = { nil, 1,  9,  24357,  19998, 300, 320, 330, 340,  1,  1, { 12655, 12800, 12804, }, { 4, 1, 6, }, nil, nil, { 20001, }, },
	[30310]  = { nil, 1,  9,  30310,  23736, 300, 320, 330, 340,  4,  4, { 23782, 23783, 23781, }, { 1, 2, 1, }, true, 15000, },
	[44155]  = { nil, 1,  9,  44155,  34060, 300, 330, 340, 350,  1,  1, { 23782, 23781, 23783, 11291, }, { 2, 20, 20, 8, }, true, 60000, },
	[30548]  = { nil, 1,  9,  30548,  23821, 305, 305, 315, 325,  1,  1, { 23782, 23783, 21886, 16006, }, { 2, 2, 4, 1, }, nil, nil, { 23888, }, },
	[30312]  = { nil, 1,  9,  30312,  23742, 320, 330, 340, 350,  1,  1, { 4400, 23782, 23783, }, { 1, 3, 6, }, true, 20000, },
	[30306]  = { nil, 1,  9,  30306,  23784, 325, 325, 330, 335,  1,  1, { 23446, 22452, }, { 4, 1, }, true, 20000, },
	[30348]  = { nil, 1,  9,  30348,  23774, 325, 325, 335, 345,  1,  1, { 23782, 23445, 23783, }, { 1, 5, 2, }, nil, nil, { 23816, }, },
	[30549]  = { nil, 1,  9,  30549,  23820, 325, 325, 335, 345,  1,  1, { 23784, 23783, 10558, }, { 1, 2, 1, }, nil, nil, { 23882, }, },
	[30558]  = { nil, 1,  9,  30558,  23826, 325, 325, 335, 345,  3,  3, { 23782, 23781, 17020, 23783, }, { 3, 6, 3, 2, }, true, 25000, },
	[30311]  = { nil, 1,  9,  30311,  23737, 325, 335, 345, 355,  3,  3, { 23446, 23783, 23781, }, { 4, 2, 1, }, true, 25000, },
	[30337]  = { nil, 1,  9,  30337,  23767, 325, 335, 345, 355,  1,  1, { 23784, 23782, 10558, 23783, }, { 1, 2, 1, 2, }, nil, nil, { 23810, }, },
	[30568]  = { nil, 1,  9,  30568,  23841, 325, 335, 345, 355,  3,  3, { 23784, 23783, 23781, 23782, }, { 1, 2, 3, 1, }, true, 25000, },
	[30551]  = { nil, 1,  9,  30551,  33092, 330, 330, 340, 350, 20, 20, { 23782, 23783, 21887, 22829, }, { 1, 1, 2, 20, }, nil, nil, { 23883, 35310, }, },
	[39971]  = { nil, 1,  9,  39971,  32423, 335, 335, 340, 345, 10, 10, { 21885, 23781, 21877, }, { 1, 2, 2, }, true, 20000, },
	[30341]  = { nil, 1,  9,  30341,  23768, 335, 335, 345, 355,  3,  3, { 23781, 21877, }, { 1, 1, }, nil, nil, { 23811, }, },
	[30342]  = { nil, 1,  9,  30342,  23769, 335, 335, 345, 355,  3,  3, { 23781, 21877, 2604, }, { 1, 1, 1, }, nil, nil, { 23812, }, },
	[30343]  = { nil, 1,  9,  30343,  23770, 335, 335, 345, 355,  3,  3, { 23781, 21877, 6260, }, { 1, 1, 1, }, nil, nil, { 23813, }, },
	[30344]  = { nil, 1,  9,  30344,  23771, 335, 335, 345, 355,  3,  3, { 23781, 21877, 2605, }, { 1, 1, 1, }, nil, nil, { 23814, }, },
	[32814]  = { nil, 1,  9,  32814,  25886, 335, 335, 345, 355,  3,  3, { 23781, 21877, 4342, }, { 1, 1, 1, }, nil, nil, { 25887, }, },
	[43676]  = { nil, 1,  9,  43676,  20475, 335, 335, 345, 355,  1,  1, { 23446, 4470, 23783, }, { 1, 4, 2, }, },
	[30329]  = { nil, 1,  9,  30329,  23764, 335, 345, 355, 365,  1,  1, { 23446, 23112, }, { 8, 2, }, nil, nil, { 23807, }, },
	[39973]  = { nil, 1,  9,  39973,  32413, 335, 345, 355, 365,  5,  5, { 32423, 23782, 23783, }, { 1, 1, 1, }, true, 50000, },
	[30560]  = { nil, 1,  9,  30560,  23827, 340, 340, 350, 360,  2,  2, { 21877, 23781, 22457, }, { 4, 4, 1, }, true, 35000, },
	[30307]  = { nil, 1,  9,  30307,  23785, 340, 350, 360, 370,  1,  1, { 23573, }, { 3, }, true, 50000, },
	[30308]  = { nil, 1,  9,  30308,  23786, 340, 350, 360, 370,  1,  1, { 23449, 21884, }, { 1, 1, }, true, 50000, },
	[30309]  = { nil, 1,  9,  30309,  23787, 340, 350, 360, 370,  1,  1, { 23448, }, { 2, }, true, 50000, },
	[30316]  = { nil, 1,  9,  30316,  23758, 340, 350, 360, 370,  1,  1, { 23793, 23077, 22445, }, { 4, 2, 8, }, nil, nil, { 23803, }, },
	[30317]  = { nil, 1,  9,  30317,  23761, 340, 350, 360, 370,  1,  1, { 23793, 21929, 22445, }, { 4, 2, 8, }, nil, nil, { 23804, }, },
	[30569]  = { nil, 1,  9,  30569,  23835, 340, 360, 370, 380,  1,  1, { 23785, 23786, 22445, 22449, }, { 2, 2, 10, 2, }, true, 35000, },
	[30552]  = { nil, 1,  9,  30552,  33093, 345, 345, 355, 365, 20, 20, { 23782, 23783, 21887, 22832, }, { 1, 1, 2, 20, }, nil, nil, { 23884, 35311, }, },
	[30547]  = { nil, 1,  9,  30547,  23819, 350, 350, 355, 360,  2,  2, { 23781, 23782, 23783, }, { 2, 1, 1, }, nil, nil, { 23874, }, },
	[36954]  = { nil, 1,  9,  36954,  30542, 350, 350, 360, 370,  1,  1, { 23784, 21884, 23826, 23783, 23786, }, { 1, 2, 2, 4, 1, }, },
	[36955]  = { nil, 1,  9,  36955,  30544, 350, 350, 360, 370,  1,  1, { 23784, 22451, 23787, 23783, 23786, }, { 1, 2, 2, 4, 1, }, },
	[30313]  = { nil, 1,  9,  30313,  23746, 350, 360, 370, 380,  1,  1, { 23782, 23784, 23783, }, { 3, 2, 4, }, nil, nil, { 23799, }, },
	[30318]  = { nil, 1,  9,  30318,  23762, 350, 360, 370, 380,  1,  1, { 23793, 23449, 23079, 22448, }, { 4, 2, 2, 2, }, nil, nil, { 23805, }, },
	[30563]  = { nil, 1,  9,  30563,  23836, 350, 360, 370, 380,  1,  1, { 23785, 23786, 23787, 21884, 22452, 16006, }, { 2, 1, 2, 6, 6, 2, }, true, 50000, },
	[30570]  = { nil, 1,  9,  30570,  23825, 350, 360, 370, 380,  1,  1, { 23793, 23786, 21886, 22456, 16006, }, { 8, 4, 10, 10, 2, }, true, 50000, },
	[56349]  = { nil, 1,  9,  56349,  39681, 350, 360, 370, 380,  1,  3, { 36916, }, { 2, }, true, 50000, },
	[53281]  = { nil, 1,  9,  53281,  39690, 350, 366, 375, 385,  2,  2, { 36916, 37705, }, { 3, 1, }, true, 50000, },
	[40274]  = { nil, 1,  9,  40274,  32461, 350, 370, 380, 390,  1,  1, { 23793, 23786, 23785, 23787, 23572, 23436, }, { 6, 1, 2, 4, 1, 2, }, nil, nil, nil, nil, nil, 35, },
	[41311]  = { nil, 1,  9,  41311,  32472, 350, 370, 380, 390,  1,  1, { 23793, 23786, 23785, 23787, 23572, 23440, }, { 6, 1, 2, 4, 1, 2, }, nil, nil, nil, nil, nil, 2, },
	[41312]  = { nil, 1,  9,  41312,  32473, 350, 370, 380, 390,  1,  1, { 23793, 23786, 23785, 23787, 23572, 23437, }, { 6, 1, 2, 4, 1, 2, }, nil, nil, nil, nil, nil, 35, },
	[41314]  = { nil, 1,  9,  41314,  32474, 350, 370, 380, 390,  1,  1, { 23793, 23786, 23785, 23787, 23572, 23441, }, { 6, 1, 2, 4, 1, 2, }, nil, nil, nil, nil, nil, 68, },
	[41315]  = { nil, 1,  9,  41315,  32476, 350, 370, 380, 390,  1,  1, { 23793, 23786, 23785, 23787, 23572, 23436, }, { 6, 1, 2, 4, 1, 2, }, nil, nil, nil, nil, nil, 64, },
	[41316]  = { nil, 1,  9,  41316,  32475, 350, 370, 380, 390,  1,  1, { 23793, 23786, 23785, 23787, 23572, 23439, }, { 6, 1, 2, 4, 1, 2, }, nil, nil, nil, nil, nil, 64, },
	[41317]  = { nil, 1,  9,  41317,  32478, 350, 370, 380, 390,  1,  1, { 23793, 23786, 23785, 23787, 23572, 23436, }, { 6, 1, 2, 4, 1, 2, }, nil, nil, nil, nil, nil, 1032, },
	[41318]  = { nil, 1,  9,  41318,  32479, 350, 370, 380, 390,  1,  1, { 23793, 23786, 23785, 23787, 23572, 23440, }, { 6, 1, 2, 4, 1, 2, }, nil, nil, nil, nil, nil, 1024, },
	[41319]  = { nil, 1,  9,  41319,  32480, 350, 370, 380, 390,  1,  1, { 23793, 23786, 23785, 23787, 23572, 23437, }, { 6, 1, 2, 4, 1, 2, }, nil, nil, nil, nil, nil, 1024, },
	[41320]  = { nil, 1,  9,  41320,  32494, 350, 370, 380, 390,  1,  1, { 23793, 23786, 23785, 23787, 23572, 23438, }, { 6, 1, 2, 4, 1, 2, }, true, 50000, nil, nil, nil, 400, },
	[41321]  = { nil, 1,  9,  41321,  32495, 350, 370, 380, 390,  1,  1, { 23793, 23786, 23785, 23787, 23572, 23439, }, { 6, 1, 2, 4, 1, 2, }, nil, nil, nil, nil, nil, 16, },
	[56460]  = { nil, 1,  9,  56460,  40771, 350, 375, 382, 390,  3,  3, { 39681, 39690, }, { 2, 1, }, true, 50000, },
	[30556]  = { nil, 1,  9,  30556,  23824, 355, 365, 375, 385,  1,  1, { 23793, 23786, 23785, 23787, }, { 8, 2, 2, 4, }, nil, nil, { 23887, }, },
	[46697]  = { nil, 1,  9,  46697,  35581, 355, 365, 375, 385,  1,  1, { 21840, 23786, 23785, 23787, }, { 8, 2, 2, 4, }, nil, nil, { 35582, }, },
	[30314]  = { nil, 1,  9,  30314,  23747, 360, 370, 380, 390,  1,  1, { 23785, 23787, 23783, }, { 1, 4, 4, }, nil, nil, { 23800, }, },
	[30325]  = { nil, 1,  9,  30325,  23763, 360, 370, 380, 390,  1,  1, { 23793, 23449, 23441, 22449, }, { 4, 2, 2, 2, }, nil, nil, { 23806, }, },
	[30332]  = { nil, 1,  9,  30332,  23765, 360, 370, 380, 390,  1,  1, { 23785, 23449, 23440, }, { 1, 4, 2, }, nil, nil, { 23808, }, },
	[44391]  = { nil, 1,  9,  44391,  34113, 360, 370, 380, 390,  5,  5, { 23446, 23783, 23786, }, { 8, 8, 1, }, nil, nil, { 34114, }, },
	[30565]  = { nil, 1,  9,  30565,  23838, 375, 375, 385, 395,  1,  1, { 24272, 22457, 22451, }, { 4, 12, 12, }, true, 100000, },
	[30566]  = { nil, 1,  9,  30566,  23839, 375, 375, 385, 395,  1,  1, { 23573, 22452, 21884, }, { 8, 12, 12, }, true, 100000, },
	[30574]  = { nil, 1,  9,  30574,  23828, 375, 375, 385, 395,  1,  1, { 24271, 21884, 22451, 22452, 21885, 23437, }, { 4, 8, 8, 8, 8, 2, }, true, 100000, },
	[30575]  = { nil, 1,  9,  30575,  23829, 375, 375, 385, 395,  1,  1, { 23793, 22456, 22452, 21884, 23436, }, { 8, 12, 12, 12, 2, }, true, 100000, },
	[41307]  = { nil, 1,  9,  41307,  32756, 375, 375, 392, 410,  1,  1, { 23785, 23449, 23787, 21884, 22451, 23572, }, { 1, 20, 4, 12, 12, 1, }, true, 50000, },
	[56459]  = { nil, 1,  9,  56459,  40892, 375, 380, 385, 390,  1,  1, { 36916, }, { 5, }, true, 100000, },
	[56461]  = { nil, 1,  9,  56461,  40893, 375, 380, 385, 390,  1,  1, { 36916, }, { 5, }, true, 100000, },
	[56464]  = { nil, 1,  9,  56464,  39682, 375, 380, 385, 390,  1,  1, { 36916, 37701, }, { 4, 1, }, true, 100000, },
	[44157]  = { nil, 1,  9,  44157,  34061, 375, 385, 390, 395,  1,  1, { 23784, 23786, 23787, 34249, }, { 4, 8, 8, 1, }, true, 180000, },
	[56463]  = { nil, 1,  9,  56463,  40536, 375, 385, 390, 395,  5,  5, { 33470, 39690, }, { 1, 3, }, true, 100000, },
	[30315]  = { nil, 1,  9,  30315,  23748, 375, 385, 395, 405,  1,  1, { 23785, 23449, 23783, 23439, }, { 2, 12, 4, 2, }, nil, nil, { 23802, }, },
	[30334]  = { nil, 1,  9,  30334,  23766, 375, 385, 395, 405,  1,  1, { 23785, 23787, 23438, }, { 2, 6, 2, }, nil, nil, { 23809, }, },
	[46106]  = { nil, 1,  9,  46106,  35183, 375, 390, 410, 430,  1,  1, { 32479, 21885, 22457, 23572, }, { 1, 4, 8, 4, }, nil, nil, { 35191, }, nil, nil, 1024, },
	[46107]  = { nil, 1,  9,  46107,  35185, 375, 390, 410, 430,  1,  1, { 32472, 21886, 22457, 22452, 23572, }, { 1, 8, 8, 8, 4, }, nil, nil, { 35187, }, nil, nil, 2, },
	[46108]  = { nil, 1,  9,  46108,  35181, 375, 390, 410, 430,  1,  1, { 32495, 21886, 22457, 23572, }, { 1, 8, 8, 4, }, nil, nil, { 35189, }, nil, nil, 16, },
	[46109]  = { nil, 1,  9,  46109,  35182, 375, 390, 410, 430,  1,  1, { 32480, 21885, 21886, 23572, }, { 1, 6, 12, 4, }, nil, nil, { 35190, }, nil, nil, 1024, },
	[46110]  = { nil, 1,  9,  46110,  35184, 375, 390, 410, 430,  1,  1, { 32475, 21886, 22457, 21885, 23572, }, { 1, 5, 5, 5, 4, }, nil, nil, { 35192, }, nil, nil, 64, },
	[46111]  = { nil, 1,  9,  46111,  34847, 375, 390, 410, 430,  1,  1, { 32494, 22456, 21884, 22457, 23572, }, { 1, 4, 4, 4, 4, }, nil, nil, { 35186, }, nil, nil, 400, },
	[46112]  = { nil, 1,  9,  46112,  34355, 375, 390, 410, 430,  1,  1, { 32476, 23571, 22451, 23572, }, { 1, 2, 2, 4, }, nil, nil, { 35193, }, nil, nil, 64, },
	[46113]  = { nil, 1,  9,  46113,  34356, 375, 390, 410, 430,  1,  1, { 32474, 22451, 23572, }, { 1, 12, 4, }, nil, nil, { 35194, }, nil, nil, 68, },
	[46114]  = { nil, 1,  9,  46114,  34354, 375, 390, 410, 430,  1,  1, { 32461, 21884, 23572, }, { 1, 10, 4, }, nil, nil, { 35195, }, nil, nil, 35, },
	[46115]  = { nil, 1,  9,  46115,  34357, 375, 390, 410, 430,  1,  1, { 32473, 35128, 23571, 23572, }, { 1, 2, 1, 4, }, nil, nil, { 35196, }, nil, nil, 35, },
	[46116]  = { nil, 1,  9,  46116,  34353, 375, 390, 410, 430,  1,  1, { 32478, 22456, 23572, }, { 1, 12, 4, }, nil, nil, { 35197, }, nil, nil, 1032, },
	[54793]  = { nil, 1,  9,  54793,    nil, 380, 380, 382, 385,  0,  0, { 36916, 39690, }, { 8, 8, }, true, 100000, },
	[55002]  = { nil, 1,  9,  55002,    nil, 380, 380, 382, 385,  0,  0, { 33470, 39682, }, { 12, 1, }, true, 100000, },
	[54736]  = { nil, 1,  9,  54736,    nil, 390, 390, 392, 395,  0,  0, { 39682, }, { 4, }, true, 100000, },
	[56471]  = { nil, 1,  9,  56471,  39683, 390, 395, 400, 405,  1,  1, { 36916, 37705, }, { 8, 1, }, true, 100000, },
	[61471]  = { nil, 1,  9,  61471,  44739, 390, 400, 407, 415,  1,  1, { 39683, 39681, }, { 1, 2, }, true, 100000, },
	[54998]  = { nil, 1,  9,  54998,    nil, 400, 400, 402, 405,  0,  0, { 36913, 37702, }, { 6, 4, }, true, 125000, },
	[54999]  = { nil, 1,  9,  54999,    nil, 400, 400, 402, 405,  0,  0, { 36913, 37700, }, { 6, 4, }, true, 125000, },
	[63770]  = { nil, 1,  9,  63770,    nil, 400, 400, 402, 405,  0,  0, { 36913, 35624, }, { 4, 2, }, true, 125000, },
	[54353]  = { nil, 1,  9,  54353,  39688, 400, 405, 410, 415,  1,  1, { 36913, 39683, 39684, 40533, }, { 10, 2, 1, 1, }, true, 125000, },
	[55016]  = { nil, 1,  9,  55016,    nil, 405, 405, 405, 410,  0,  0, { 39690, 39681, }, { 6, 6, }, true, 125000, },
	[56468]  = { nil, 1,  9,  56468,  44951, 405, 410, 415, 420,  1,  1, { 36913, 39690, }, { 5, 1, }, true, 125000, },
	[30349]  = { nil, 1,  9,  30349,  23775, 405, 425, 432, 440,  1,  1, { 36913, 41163, 39681, }, { 8, 8, 4, }, nil, nil, { 23817, }, },
	[67839]  = { nil, 1,  9,  67839,    nil, 410, 410, 415, 420,  0,  0, { 36913, 39683, }, { 8, 1, }, true, 100000, },
	[56476]  = { nil, 1,  9,  56476,  37567, 410, 415, 420, 425,  8,  8, { 36913, 39681, }, { 12, 2, }, true, 125000, },
	[67326]  = { nil, 1,  9,  67326,  47828, 410, 415, 420, 425,  1,  1, { 36913, 37702, 37705, }, { 6, 3, 3, }, true, 100000, },
	[55252]  = { nil, 1,  9,  55252,  40769, 415, 415, 417, 420,  5,  5, { 36913, }, { 10, }, },
	[56477]  = { nil, 1,  9,  56477,  42546, 415, 420, 425, 430,  8,  8, { 36913, 37705, }, { 12, 2, }, true, 125000, },
	[56465]  = { nil, 1,  9,  56465,  41112, 420, 425, 432, 440,  1,  1, { 36913, 33568, 35627, }, { 8, 2, 1, }, true, 125000, nil, nil, nil, 400, },
	[61481]  = { nil, 1,  9,  61481,  44740, 420, 425, 432, 440,  1,  1, { 36913, 33568, 35627, }, { 8, 2, 1, }, nil, nil, nil, nil, nil, 1032, },
	[61482]  = { nil, 1,  9,  61482,  44741, 420, 425, 432, 440,  1,  1, { 36913, 33568, 35627, }, { 8, 2, 1, }, nil, nil, nil, nil, nil, 68, },
	[61483]  = { nil, 1,  9,  61483,  44742, 420, 425, 432, 440,  1,  1, { 36913, 33568, 35627, }, { 8, 2, 1, }, nil, nil, nil, nil, nil, 35, },
	[56466]  = { nil, 1,  9,  56466,  40767, 420, 435, 440, 445,  1,  1, { 39683, 39682, 39681, }, { 2, 4, 2, }, true, 125000, },
	[56467]  = { nil, 1,  9,  56467,  40865, 420, 435, 440, 445,  1,  1, { 39683, 39682, 39681, }, { 2, 2, 8, }, true, 125000, },
	[56514]  = { nil, 1,  9,  56514,  42641, 425, 425, 430, 435,  5,  5, { 36913, 39690, }, { 1, 1, }, true, 150000, },
	[82175]  = { nil, 1,  9,  82175,    nil, 425, 425, 437, 450,  0,  0, { 52326, 67749, }, { 2, 1, }, },
	[82177]  = { nil, 1,  9,  82177,    nil, 425, 425, 437, 450,  0,  0, { 54849, 67749, }, { 2, 1, }, },
	[82180]  = { nil, 1,  9,  82180,    nil, 425, 425, 437, 450,  0,  0, { 52327, 67749, }, { 2, 2, }, },
	[82200]  = { nil, 1,  9,  82200,    nil, 425, 425, 437, 450,  0,  0, { 60224, 67749, }, { 1, 1, }, },
	[82201]  = { nil, 1,  9,  82201,    nil, 425, 425, 437, 450,  0,  0, { 60224, 67749, }, { 1, 1, }, },
	[84424]  = { nil, 1,  9,  84424,    nil, 425, 425, 437, 450,  0,  0, { 60224, 67749, }, { 1, 1, }, },
	[84425]  = { nil, 1,  9,  84425,    nil, 425, 425, 437, 450,  0,  0, { 4470, 60224, }, { 2, 1, }, },
	[84427]  = { nil, 1,  9,  84427,    nil, 425, 425, 437, 450,  0,  0, { 67749, }, { 3, }, },
	[82207]  = { nil, 1,  9,  82207,    nil, 425, 425, 452, 480,  0,  0, { 60224, }, { 1, }, },
	[56470]  = { nil, 1,  9,  56470,  41146, 425, 430, 432, 435,  1,  1, { 39683, 36920, 36921, }, { 1, 1, 1, }, true, 150000, },
	[56472]  = { nil, 1,  9,  56472,  40768, 425, 430, 432, 435,  1,  1, { 36913, 35623, }, { 8, 8, }, true, 150000, },
	[56469]  = { nil, 1,  9,  56469,  41121, 425, 430, 435, 440,  1,  1, { 41163, 36913, 35622, 35623, }, { 2, 8, 2, 2, }, true, 150000, },
	[56473]  = { nil, 1,  9,  56473,  40895, 425, 430, 435, 440,  1,  1, { 41163, 34052, 39681, }, { 6, 2, 2, }, true, 150000, },
	[84403]  = { nil, 1,  9,  84403,  60224, 425, 435, 442, 450,  2,  4, { 54849, }, { 2, }, true, 150000, },
	[56478]  = { nil, 1,  9,  56478,  41167, 430, 435, 445, 455,  1,  1, { 36913, 36927, }, { 10, 2, }, true, 200000, },
	[56462]  = { nil, 1,  9,  56462,  40772, 435, 440, 445, 450,  1,  1, { 36913, 7005, 2901, 5956, }, { 10, 1, 1, 1, }, true, 150000, },
	[67920]  = { nil, 1,  9,  67920,  48933, 435, 450, 455, 460,  1,  1, { 41163, 35627, 35622, 36860, 35623, }, { 8, 2, 2, 2, 2, }, true, 150000, },
	[95703]  = { nil, 1,  9,  95703,  67494, 440, 450, 452, 455,  1,  1, { 54849, 60224, 52327, }, { 4, 6, 4, }, true, 150000, },
	[56480]  = { nil, 1,  9,  56480,  42549, 440, 450, 455, 460,  1,  1, { 41163, 38425, 36924, 35624, 43102, }, { 8, 4, 2, 4, 1, }, nil, nil, nil, nil, nil, 35, },
	[56481]  = { nil, 1,  9,  56481,  42550, 440, 450, 455, 460,  1,  1, { 41163, 38425, 36918, 35623, 43102, }, { 8, 4, 2, 4, 1, }, nil, nil, nil, nil, nil, 1032, },
	[56483]  = { nil, 1,  9,  56483,  42552, 440, 450, 455, 460,  1,  1, { 41163, 38425, 36930, 36860, 43102, }, { 8, 4, 2, 4, 1, }, nil, nil, nil, nil, nil, 35, },
	[56484]  = { nil, 1,  9,  56484,  42553, 440, 450, 455, 460,  1,  1, { 41163, 38425, 36918, 35627, 43102, }, { 8, 4, 2, 4, 1, }, true, 150000, nil, nil, nil, 400, },
	[56486]  = { nil, 1,  9,  56486,  42554, 440, 450, 455, 460,  1,  1, { 41163, 38425, 36933, 35625, 43102, }, { 8, 4, 2, 4, 1, }, nil, nil, nil, nil, nil, 1024, },
	[56487]  = { nil, 1,  9,  56487,  42555, 440, 450, 455, 460,  1,  1, { 41163, 38425, 36921, 35623, 43102, }, { 8, 4, 2, 4, 1, }, nil, nil, nil, nil, nil, 64, },
	[56574]  = { nil, 1,  9,  56574,  42551, 440, 450, 455, 460,  1,  1, { 41163, 38425, 36927, 35622, 43102, }, { 8, 4, 2, 4, 1, }, nil, nil, nil, nil, nil, 68, },
	[62271]  = { nil, 1,  9,  62271,  44949, 440, 450, 455, 460,  1,  1, { 41163, 38425, 36933, 35624, 43102, }, { 8, 4, 2, 4, 1, }, nil, nil, nil, nil, nil, 2, },
	[84406]  = { nil, 1,  9,  84406,  60222, 440, 455, 457, 460,  1,  1, { 54849, 52181, 52976, }, { 8, 2, 2, }, true, 150000, },
	[94748]  = { nil, 1,  9,  94748,  67749, 445, 455, 460, 465,  2,  3, { 52328, }, { 2, }, true, 150000, },
	[56479]  = { nil, 1,  9,  56479,  41168, 450, 455, 460, 465,  1,  1, { 41163, 36913, 35623, 35622, 43102, 40533, }, { 10, 20, 15, 15, 1, 1, }, true, 200000, },
	[60874]  = { nil, 1,  9,  60874,  44504, 450, 455, 460, 465,  1,  1, { 41163, 43102, 36860, 35627, 41146, 40533, }, { 10, 1, 12, 12, 3, 1, }, true, 200000, },
	[84408]  = { nil, 1,  9,  84408,  59595, 450, 470, 472, 475,  1,  1, { 54849, 60224, 52179, }, { 6, 6, 2, }, true, 150000, },
	[84410]  = { nil, 1,  9,  84410,  59596, 450, 470, 472, 475,  1,  1, { 54849, 60224, }, { 10, 10, }, true, 150000, },
	[60866]  = { nil, 1,  9,  60866,  41508, 450, 480, 485, 490,  1,  1, { 37663, 39681, 44128, 44499, 44501, 44500, }, { 12, 40, 2, 1, 8, 1, }, nil, nil, { 44502, }, },
	[60867]  = { nil, 1,  9,  60867,  44413, 450, 480, 485, 490,  1,  1, { 37663, 39681, 44128, 44499, 44501, 44500, }, { 12, 40, 2, 1, 8, 1, }, nil, nil, { 44503, }, },
	[68067]  = { nil, 1,  9,  68067,  49040, 450, 480, 485, 490,  1,  1, { 18232, 34113, 40769, 37663, 36922, 39681, }, { 2, 10, 20, 8, 2, 30, }, nil, nil, { 49050, }, },
	[84409]  = { nil, 1,  9,  84409,  60853, 455, 460, 467, 475,  1,  1, { 60224, 67749, }, { 1, 2, }, true, 160000, },
	[84411]  = { nil, 1,  9,  84411,  60223, 465, 480, 480, 480,  1,  1, { 54849, 60224, 67749, }, { 10, 8, 4, }, true, 160000, },
	[84415]  = { nil, 1,  9,  84415,  60218, 475, 490, 492, 495,  1,  1, { 52186, 60224, }, { 20, 4, }, true, 170000, },
	[84412]  = { nil, 1,  9,  84412,  59597, 475, 495, 497, 500,  1,  1, { 54849, 60224, 67749, }, { 10, 8, 8, }, true, 160000, },
	[84413]  = { nil, 1,  9,  84413,  60216, 475, 495, 497, 500,  1,  1, { 54849, 60224, 67749, 52182, }, { 12, 4, 8, 2, }, true, 160000, },
	[84416]  = { nil, 1,  9,  84416,  60217, 475, 495, 497, 500,  1,  1, { 52186, 52327, }, { 15, 12, }, true, 170000, },
	[84418]  = { nil, 1,  9,  84418,  60403, 475, 505, 507, 510,  1,  1, { 60224, 67749, 52186, 53010, }, { 2, 8, 16, 20, }, true, 170000, },
	[84421]  = { nil, 1,  9,  84421,  60854, 490, 495, 497, 500,  1,  1, { 53039, 67749, }, { 5, 5, }, true, 170000, },
	[84420]  = { nil, 1,  9,  84420,  59598, 490, 510, 512, 515,  1,  1, { 54849, 67749, 53039, }, { 4, 2, 5, }, true, 170000, },
	[84417]  = { nil, 1,  9,  84417,  59599, 495, 515, 517, 520,  1,  1, { 67749, 53039, 52325, }, { 2, 5, 6, }, true, 170000, },
	[95705]  = { nil, 1,  9,  95705,  40727, 500, 505, 505, 505,  1,  1, { 67749, 53039, }, { 6, 3, }, true, 200000, },
	[95707]  = { nil, 1,  9,  95707,  63396, 500, 505, 507, 510,  3,  3, { 67749, 52186, }, { 1, 6, }, true, 200000, },
	[84429]  = { nil, 1,  9,  84429,  60858, 505, 505, 505, 515,  1,  1, { 52186, 62778, 62654, }, { 2, 2, 2, }, true, 200000, },
	[84430]  = { nil, 1,  9,  84430,  68049, 510, 510, 520, 540,  2,  2, { 60224, 52186, 52325, }, { 1, 4, 1, }, true, 200000, },
	[84428]  = { nil, 1,  9,  84428,  59594, 515, 525, 530, 535,  1,  1, { 53039, 52192, }, { 2, 2, }, true, 200000, },
	[100587] = { nil, 1,  9, 100587,  70139, 515, 525, 530, 535,  1,  1, { 53039, 67749, 60224, 52192, }, { 1, 4, 5, 2, }, nil, nil, { 70177, }, },
	[84432]  = { nil, 1,  9,  84432,  59367, 525, 525, 525, 525,  1,  1, { 53039, 58480, 39684, 40533, 52078, }, { 9, 3, 1, 1, 1, }, true, 240000, },
	[100687] = { nil, 1,  9, 100687,  71077, 525, 525, 525, 525,  1,  1, { 53039, 58480, 39684, 40533, 52078, }, { 5, 8, 1, 1, 5, }, nil, nil, { 71078, }, },
	[81714]  = { nil, 1,  9,  81714,  59359, 525, 525, 530, 535,  1,  1, { 60224, 67749, 53039, 52190, 58480, 52078, }, { 6, 6, 3, 2, 1, 1, }, nil, nil, nil, nil, nil, 35, },
	[81715]  = { nil, 1,  9,  81715,  59448, 525, 525, 530, 535,  1,  1, { 60224, 67749, 53039, 52191, 58480, 52078, }, { 6, 6, 3, 2, 1, 1, }, nil, nil, nil, nil, nil, 2, },
	[81716]  = { nil, 1,  9,  81716,  59456, 525, 525, 530, 535,  1,  1, { 60224, 67749, 53039, 52192, 58480, 52078, }, { 6, 6, 3, 2, 1, 1, }, nil, nil, nil, nil, nil, 68, },
	[81720]  = { nil, 1,  9,  81720,  59458, 525, 525, 530, 535,  1,  1, { 60224, 67749, 53039, 52191, 58480, 52078, }, { 6, 6, 3, 2, 1, 1, }, nil, nil, nil, nil, nil, 64, },
	[81722]  = { nil, 1,  9,  81722,  59455, 525, 525, 530, 535,  1,  1, { 60224, 67749, 53039, 52192, 58480, 52078, }, { 6, 6, 3, 2, 1, 1, }, nil, nil, nil, nil, nil, 1032, },
	[81724]  = { nil, 1,  9,  81724,  59453, 525, 525, 530, 535,  1,  1, { 60224, 67749, 53039, 52191, 58480, 52078, }, { 6, 6, 3, 2, 1, 1, }, nil, nil, nil, nil, nil, 1024, },
	[81725]  = { nil, 1,  9,  81725,  59449, 525, 525, 530, 535,  1,  1, { 60224, 67749, 53039, 52191, 58480, 52078, }, { 6, 6, 3, 2, 1, 1, }, true, 240000, nil, nil, nil, 400, },
	[84431]  = { nil, 1,  9,  84431,  59364, 525, 525, 530, 535,  1,  1, { 53039, 58480, 60224, 67749, 52078, }, { 12, 2, 6, 8, 1, }, true, 240000, },
	[44612]  = { nil, 1, 10,  44612,  38985,   0, 405, 412, 420,  1,  1, { 34054, 34052, }, { 30, 1, }, },
	[7421]   = { nil, 1, 10,   7421,   6218,   1,   5,   7,  10,  1,  1, { 6217, 10940, 10938, }, { 1, 1, 1, }, },
	[7418]   = { nil, 1, 10,   7418,  38679,   1,  70,  90, 110,  1,  1, { 10940, }, { 1, }, },
	[7428]   = { nil, 1, 10,   7428,  38768,   1,  80, 100, 120,  1,  1, { 10938, 10940, }, { 1, 1, }, },
	[14293]  = { nil, 1, 10,  14293,  11287,  10,  75,  95, 115,  1,  1, { 4470, 10938, }, { 1, 1, }, true, 50, },
	[7420]   = { nil, 1, 10,   7420,  38766,  15,  70,  90, 110,  1,  1, { 10940, }, { 1, }, true, 50, },
	[7443]   = { nil, 1, 10,   7443,  38769,  20,  80, 100, 120,  1,  1, { 10938, }, { 1, }, nil, nil, { 6342, }, },
	[7426]   = { nil, 1, 10,   7426,  38767,  40,  90, 110, 130,  1,  1, { 10940, 10938, }, { 2, 1, }, true, 100, },
	[25124]  = { nil, 1, 10,  25124,  20744,  45,  55,  65,  75,  1,  1, { 10940, 3371, }, { 2, 1, }, nil, nil, { 20758, }, },
	[7454]   = { nil, 1, 10,   7454,  38770,  45,  95, 115, 135,  1,  1, { 10940, 10938, }, { 1, 2, }, true, 100, },
	[7457]   = { nil, 1, 10,   7457,  38771,  50, 100, 120, 140,  1,  1, { 10940, }, { 3, }, true, 250, },
	[7748]   = { nil, 1, 10,   7748,  38773,  60, 105, 125, 145,  1,  1, { 10940, 10938, }, { 2, 2, }, true, 250, },
	[7766]   = { nil, 1, 10,   7766,  38774,  60, 105, 125, 145,  1,  1, { 10938, }, { 2, }, nil, nil, { 6344, }, },
	[7771]   = { nil, 1, 10,   7771,  38775,  70, 110, 130, 150,  1,  1, { 10940, 10939, }, { 3, 1, }, true, 200, },
	[14807]  = { nil, 1, 10,  14807,  11288,  70, 110, 130, 150,  1,  1, { 4470, 10939, }, { 1, 1, }, true, 200, },
	[7776]   = { nil, 1, 10,   7776,  38776,  80, 115, 135, 155,  1,  1, { 10939, 10938, }, { 1, 1, }, nil, nil, { 6346, }, },
	[7779]   = { nil, 1, 10,   7779,  38777,  80, 115, 135, 155,  1,  1, { 10940, 10939, }, { 2, 1, }, true, 400, },
	[7782]   = { nil, 1, 10,   7782,  38778,  80, 115, 135, 155,  1,  1, { 10940, }, { 5, }, nil, nil, { 6347, }, },
	[7786]   = { nil, 1, 10,   7786,  38779,  90, 120, 140, 160,  1,  1, { 10940, 10939, }, { 4, 2, }, nil, nil, { 6348, }, },
	[7788]   = { nil, 1, 10,   7788,  38780,  90, 120, 140, 160,  1,  1, { 10940, 10939, 10978, }, { 2, 1, 1, }, true, 500, },
	[7745]   = { nil, 1, 10,   7745,  38772, 100, 130, 150, 170,  1,  1, { 10940, 10978, }, { 4, 1, }, true, 500, },
	[7793]   = { nil, 1, 10,   7793,  38781, 100, 130, 150, 170,  1,  1, { 10939, }, { 3, }, nil, nil, { 6349, }, },
	[7795]   = { nil, 1, 10,   7795,   6339, 100, 130, 150, 170,  1,  1, { 6338, 10940, 10939, 6218, }, { 1, 6, 3, 1, }, true, 1000, },
	[13378]  = { nil, 1, 10,  13378,  38787, 105, 130, 150, 170,  1,  1, { 10998, 10940, }, { 1, 2, }, true, 600, },
	[13380]  = { nil, 1, 10,  13380,  38788, 110, 135, 155, 175,  1,  1, { 10998, 10940, }, { 1, 6, }, nil, nil, { 11038, }, },
	[13419]  = { nil, 1, 10,  13419,  38789, 110, 135, 155, 175,  1,  1, { 10998, }, { 1, }, nil, nil, { 11039, }, },
	[13421]  = { nil, 1, 10,  13421,  38790, 115, 140, 160, 180,  1,  1, { 10940, 10978, }, { 6, 1, }, true, 800, },
	[13464]  = { nil, 1, 10,  13464,  38791, 115, 140, 160, 180,  1,  1, { 10998, 10940, 10978, }, { 1, 1, 1, }, nil, nil, { 11081, }, },
	[7857]   = { nil, 1, 10,   7857,  38782, 120, 145, 165, 185,  1,  1, { 10940, 10998, }, { 4, 1, }, true, 1000, },
	[7859]   = { nil, 1, 10,   7859,  38783, 120, 145, 165, 185,  1,  1, { 10998, }, { 2, }, nil, nil, { 6375, }, },
	[7861]   = { nil, 1, 10,   7861,  38784, 125, 150, 170, 190,  1,  1, { 6371, 10998, }, { 1, 1, }, true, 1250, },
	[7863]   = { nil, 1, 10,   7863,  38785, 125, 150, 170, 190,  1,  1, { 10940, }, { 8, }, true, 1400, { 6376, }, },
	[7867]   = { nil, 1, 10,   7867,  38786, 125, 150, 170, 190,  1,  1, { 10940, 10998, }, { 6, 2, }, nil, nil, { 6377, }, },
	[13485]  = { nil, 1, 10,  13485,  38792, 130, 155, 175, 195,  1,  1, { 10998, 10940, }, { 2, 4, }, true, 1500, },
	[13501]  = { nil, 1, 10,  13501,  38793, 130, 155, 175, 195,  1,  1, { 11083, }, { 2, }, true, 1500, },
	[13522]  = { nil, 1, 10,  13522,  38795, 135, 160, 180, 200,  1,  1, { 11082, 6048, }, { 1, 1, }, nil, nil, { 11098, }, },
	[13503]  = { nil, 1, 10,  13503,  38794, 140, 165, 185, 205,  1,  1, { 11083, 11084, }, { 2, 1, }, true, 2000, },
	[13536]  = { nil, 1, 10,  13536,  38797, 140, 165, 185, 205,  1,  1, { 11083, }, { 2, }, nil, nil, { 11101, }, },
	[13538]  = { nil, 1, 10,  13538,  38798, 140, 165, 185, 205,  1,  1, { 10940, 11082, 11084, }, { 2, 1, 1, }, true, 2500, },
	[13529]  = { nil, 1, 10,  13529,  38796, 145, 170, 190, 210,  1,  1, { 11083, 11084, }, { 3, 1, }, true, 2400, },
	[13607]  = { nil, 1, 10,  13607,  38799, 145, 170, 190, 210,  1,  1, { 11082, 10998, }, { 1, 2, }, true, 2400, },
	[13612]  = { nil, 1, 10,  13612,  38800, 145, 170, 190, 210,  1,  1, { 11083, 2772, }, { 1, 3, }, nil, nil, { 11150, }, },
	[13617]  = { nil, 1, 10,  13617,  38801, 145, 170, 190, 210,  1,  1, { 11083, 3356, }, { 1, 3, }, nil, nil, { 11151, 78343, }, },
	[13620]  = { nil, 1, 10,  13620,  38802, 145, 170, 190, 210,  1,  1, { 11083, 6370, }, { 1, 3, }, nil, nil, { 11152, }, },
	[25125]  = { nil, 1, 10,  25125,  20745, 150, 160, 170, 180,  1,  1, { 11083, 3371, }, { 3, 1, }, nil, nil, { 20752, }, },
	[13622]  = { nil, 1, 10,  13622,  38803, 150, 175, 195, 215,  1,  1, { 11082, }, { 2, }, true, 2500, },
	[13626]  = { nil, 1, 10,  13626,  38804, 150, 175, 195, 215,  1,  1, { 11082, 11083, 11084, }, { 1, 1, 1, }, true, 2500, },
	[13628]  = { nil, 1, 10,  13628,  11130, 150, 175, 195, 215,  1,  1, { 11128, 5500, 11082, 11083, 6339, }, { 1, 1, 2, 2, 1, }, true, 2500, },
	[13631]  = { nil, 1, 10,  13631,  38805, 155, 175, 195, 215,  1,  1, { 11134, 11083, }, { 1, 1, }, true, 2600, },
	[13635]  = { nil, 1, 10,  13635,  38806, 155, 175, 195, 215,  1,  1, { 11138, 11083, }, { 1, 3, }, true, 2600, },
	[14809]  = { nil, 1, 10,  14809,  11289, 155, 175, 195, 215,  1,  1, { 11291, 11134, 11083, }, { 1, 1, 1, }, true, 2600, },
	[13637]  = { nil, 1, 10,  13637,  38807, 160, 180, 200, 220,  1,  1, { 11083, 11134, }, { 1, 1, }, true, 2800, },
	[13640]  = { nil, 1, 10,  13640,  38808, 160, 180, 200, 220,  1,  1, { 11083, }, { 3, }, true, 2700, },
	[13642]  = { nil, 1, 10,  13642,  38809, 165, 185, 205, 225,  1,  1, { 11134, }, { 1, }, true, 2800, },
	[13644]  = { nil, 1, 10,  13644,  38810, 170, 190, 210, 230,  1,  1, { 11083, }, { 4, }, true, 2800, },
	[13646]  = { nil, 1, 10,  13646,  38811, 170, 190, 210, 230,  1,  1, { 11134, 11083, }, { 1, 2, }, true, 2800, { 11163, }, },
	[13648]  = { nil, 1, 10,  13648,  38812, 170, 190, 210, 230,  1,  1, { 11083, }, { 6, }, true, 2800, },
	[13653]  = { nil, 1, 10,  13653,  38813, 175, 195, 215, 235,  1,  1, { 11134, 5637, 11138, }, { 1, 2, 1, }, nil, nil, { 11164, }, },
	[13655]  = { nil, 1, 10,  13655,  38814, 175, 195, 215, 235,  1,  1, { 11134, 7067, 11138, }, { 1, 1, 1, }, nil, nil, { 11165, }, },
	[13657]  = { nil, 1, 10,  13657,  38815, 175, 195, 215, 235,  1,  1, { 11134, 7068, }, { 1, 1, }, true, 3000, },
	[14810]  = { nil, 1, 10,  14810,  11290, 175, 195, 215, 235,  1,  1, { 11291, 11135, 11137, }, { 1, 1, 1, }, true, 3000, },
	[13659]  = { nil, 1, 10,  13659,  38816, 180, 200, 220, 240,  1,  1, { 11135, 11137, }, { 1, 1, }, true, 3200, },
	[13661]  = { nil, 1, 10,  13661,  38817, 180, 200, 220, 240,  1,  1, { 11137, }, { 1, }, true, 3600, },
	[13663]  = { nil, 1, 10,  13663,  38818, 185, 205, 225, 245,  1,  1, { 11135, }, { 1, }, true, 3800, },
	[13687]  = { nil, 1, 10,  13687,  38819, 190, 210, 230, 250,  1,  1, { 11135, 11134, }, { 1, 2, }, nil, nil, { 11167, }, },
	[21931]  = { nil, 1, 10,  21931,  38876, 190, 210, 230, 250,  1,  1, { 11135, 11137, 11139, 3819, }, { 3, 3, 1, 2, }, nil, nil, { 17725, }, },
	[13689]  = { nil, 1, 10,  13689,  38820, 195, 215, 235, 255,  1,  1, { 11135, 11137, 11139, }, { 2, 2, 1, }, nil, nil, { 11168, }, },
	[13693]  = { nil, 1, 10,  13693,  38821, 195, 215, 235, 255,  1,  1, { 11135, 11139, }, { 2, 1, }, true, 4000, },
	[25126]  = { nil, 1, 10,  25126,  20746, 200, 210, 220, 230,  1,  1, { 11137, 3371, }, { 3, 1, }, nil, nil, { 20753, }, },
	[13695]  = { nil, 1, 10,  13695,  38822, 200, 220, 240, 260,  1,  1, { 11137, 11139, }, { 4, 1, }, true, 4000, },
	[13698]  = { nil, 1, 10,  13698,  38823, 200, 220, 240, 260,  1,  1, { 11137, 7392, }, { 1, 3, }, nil, nil, { 11166, }, },
	[13700]  = { nil, 1, 10,  13700,  38824, 200, 220, 240, 260,  1,  1, { 11135, 11137, 11139, }, { 2, 2, 1, }, true, 4000, },
	[13702]  = { nil, 1, 10,  13702,  11145, 200, 220, 240, 260,  1,  1, { 11144, 7971, 11135, 11137, 11130, }, { 1, 1, 2, 2, 1, }, true, 4000, },
	[13746]  = { nil, 1, 10,  13746,  38825, 205, 225, 245, 265,  1,  1, { 11137, }, { 3, }, true, 4200, },
	[13794]  = { nil, 1, 10,  13794,  38826, 205, 225, 245, 265,  1,  1, { 11174, }, { 1, }, true, 4200, },
	[13815]  = { nil, 1, 10,  13815,  38827, 210, 230, 250, 270,  1,  1, { 11174, 11137, }, { 1, 1, }, true, 4400, },
	[13817]  = { nil, 1, 10,  13817,  38828, 210, 230, 250, 270,  1,  1, { 11137, }, { 5, }, nil, nil, { 11202, }, },
	[13822]  = { nil, 1, 10,  13822,  38829, 210, 230, 250, 270,  1,  1, { 11174, }, { 2, }, true, 4400, },
	[13836]  = { nil, 1, 10,  13836,  38830, 215, 235, 255, 275,  1,  1, { 11137, }, { 5, }, true, 4600, },
	[13841]  = { nil, 1, 10,  13841,  38831, 215, 235, 255, 275,  1,  1, { 11137, 6037, }, { 3, 3, }, nil, nil, { 11203, }, },
	[13846]  = { nil, 1, 10,  13846,  38832, 220, 240, 260, 280,  1,  1, { 11174, 11137, }, { 3, 1, }, nil, nil, { 11204, }, },
	[13858]  = { nil, 1, 10,  13858,  38833, 220, 240, 260, 280,  1,  1, { 11137, }, { 6, }, true, 4800, },
	[13868]  = { nil, 1, 10,  13868,  38834, 225, 245, 265, 285,  1,  1, { 11137, 8838, }, { 3, 3, }, nil, nil, { 11205, }, },
	[13882]  = { nil, 1, 10,  13882,  38835, 225, 245, 265, 285,  1,  1, { 11174, }, { 2, }, nil, nil, { 11206, 71714, }, },
	[13887]  = { nil, 1, 10,  13887,  38836, 225, 245, 265, 285,  1,  1, { 11174, 11137, }, { 2, 3, }, true, 5000, },
	[13890]  = { nil, 1, 10,  13890,  38837, 225, 245, 265, 285,  1,  1, { 11177, 7909, 11174, }, { 1, 1, 1, }, true, 5000, },
	[63746]  = { nil, 1, 10,  63746,  45628, 225, 245, 265, 285,  1,  1, { 11137, 11174, }, { 4, 1, }, true, 5000, },
	[13905]  = { nil, 1, 10,  13905,  38839, 230, 250, 270, 290,  1,  1, { 11175, 11176, }, { 1, 2, }, true, 5400, },
	[13915]  = { nil, 1, 10,  13915,  38840, 230, 250, 270, 290,  1,  1, { 11177, 11176, 9224, }, { 1, 2, 1, }, nil, nil, { 11208, }, },
	[13917]  = { nil, 1, 10,  13917,  38841, 230, 250, 270, 290,  1,  1, { 11175, 11174, }, { 1, 2, }, true, 5400, },
	[13931]  = { nil, 1, 10,  13931,  38842, 235, 255, 275, 295,  1,  1, { 11175, 11176, }, { 1, 2, }, nil, nil, { 11223, }, },
	[13933]  = { nil, 1, 10,  13933,  38843, 235, 255, 275, 295,  1,  1, { 11178, 3829, }, { 1, 1, }, nil, nil, { 11224, }, },
	[13935]  = { nil, 1, 10,  13935,  38844, 235, 255, 275, 295,  1,  1, { 11175, }, { 2, }, true, 5800, },
	[13937]  = { nil, 1, 10,  13937,  38845, 240, 260, 280, 300,  1,  1, { 11178, 11176, }, { 2, 2, }, true, 6200, },
	[13939]  = { nil, 1, 10,  13939,  38846, 240, 260, 280, 300,  1,  1, { 11176, 11175, }, { 2, 1, }, true, 6200, },
	[13941]  = { nil, 1, 10,  13941,  38847, 245, 265, 285, 305,  1,  1, { 11178, 11176, 11175, }, { 1, 3, 2, }, true, 6200, },
	[13943]  = { nil, 1, 10,  13943,  38848, 245, 265, 285, 305,  1,  1, { 11178, 11175, }, { 2, 2, }, true, 6200, },
	[13945]  = { nil, 1, 10,  13945,  38849, 245, 265, 285, 305,  1,  1, { 11176, }, { 5, }, nil, nil, { 11225, }, },
	[17180]  = { nil, 1, 10,  17180,  12655, 250, 250, 255, 260,  1,  1, { 12359, 11176, }, { 1, 3, }, true, 10000, },
	[17181]  = { nil, 1, 10,  17181,  12810, 250, 250, 255, 260,  1,  1, { 8170, 16202, }, { 1, 1, }, true, 10000, },
	[25127]  = { nil, 1, 10,  25127,  20747, 250, 260, 270, 280,  1,  1, { 11176, 8831, 3371, }, { 3, 2, 1, }, nil, nil, { 20754, }, },
	[13947]  = { nil, 1, 10,  13947,  38850, 250, 270, 290, 310,  1,  1, { 11178, 11176, }, { 2, 3, }, nil, nil, { 11226, }, },
	[13948]  = { nil, 1, 10,  13948,  38851, 250, 270, 290, 310,  1,  1, { 11178, 8153, }, { 2, 2, }, true, 6500, },
	[20008]  = { nil, 1, 10,  20008,  38852, 255, 275, 295, 315,  1,  1, { 16202, }, { 3, }, true, 10000, { 16214, }, },
	[20020]  = { nil, 1, 10,  20020,  38862, 260, 280, 300, 320,  1,  1, { 11176, }, { 5, }, nil, nil, { 16215, }, },
	[13898]  = { nil, 1, 10,  13898,  38838, 265, 285, 305, 325,  1,  1, { 11177, 7078, }, { 4, 1, }, nil, nil, { 11207, }, },
	[15596]  = { nil, 1, 10,  15596,  11811, 265, 285, 305, 325,  1,  1, { 7078, 14343, }, { 3, 3, }, nil, nil, { 11813, 45050, }, },
	[20014]  = { nil, 1, 10,  20014,  38858, 265, 285, 305, 325,  1,  1, { 7077, 7075, 7079, 7081, 7972, }, { 1, 1, 1, 1, 1, }, true, 10000, { 16216, }, },
	[20017]  = { nil, 1, 10,  20017,  38861, 265, 285, 305, 325,  1,  1, { 11176, }, { 5, }, nil, nil, { 16217, }, },
	[20009]  = { nil, 1, 10,  20009,  38853, 270, 290, 310, 330,  1,  1, { 16202, 11176, }, { 3, 4, }, nil, nil, { 16218, }, },
	[20012]  = { nil, 1, 10,  20012,  38856, 270, 290, 310, 330,  1,  1, { 16202, 16204, }, { 2, 3, }, true, 10000, { 16219, }, },
	[25128]  = { nil, 1, 10,  25128,  20750, 275, 285, 295, 305,  1,  1, { 16204, 4625, 3371, }, { 3, 2, 1, }, nil, nil, { 20755, }, },
	[20024]  = { nil, 1, 10,  20024,  38864, 275, 295, 315, 335,  1,  1, { 16203, }, { 2, }, nil, nil, { 16220, }, },
	[20026]  = { nil, 1, 10,  20026,  38866, 275, 295, 315, 335,  1,  1, { 14343, }, { 2, }, nil, nil, { 16221, }, },
	[20016]  = { nil, 1, 10,  20016,  38860, 280, 300, 320, 340,  1,  1, { 16203, 16204, }, { 1, 4, }, true, 15000, { 16222, }, },
	[20015]  = { nil, 1, 10,  20015,  38859, 285, 300, 317, 335,  1,  1, { 16204, }, { 8, }, nil, nil, { 16224, }, },
	[20029]  = { nil, 1, 10,  20029,  38868, 285, 300, 317, 335,  1,  1, { 14343, 7080, 7082, 13467, }, { 4, 1, 1, 1, }, nil, nil, { 16223, }, },
	[20028]  = { nil, 1, 10,  20028,  38867, 290, 305, 322, 340,  1,  1, { 16204, }, { 8, }, true, 15000, { 16242, }, },
	[20051]  = { nil, 1, 10,  20051,  16207, 290, 305, 322, 340,  1,  1, { 16206, 16204, 16203, 11145, 14344, }, { 1, 10, 4, 1, 2, }, true, 15000, { 16243, }, },
	[23799]  = { nil, 1, 10,  23799,  38879, 290, 305, 322, 340,  1,  1, { 14344, 7076, }, { 4, 4, }, nil, nil, { 19444, }, },
	[23800]  = { nil, 1, 10,  23800,  38880, 290, 305, 322, 340,  1,  1, { 14344, 7082, }, { 4, 4, }, nil, nil, { 19445, }, },
	[23801]  = { nil, 1, 10,  23801,  38881, 290, 305, 322, 340,  1,  1, { 16204, 16202, 7080, }, { 4, 4, 2, }, nil, nil, { 19446, }, },
	[27837]  = { nil, 1, 10,  27837,  38896, 290, 305, 322, 340,  1,  1, { 14344, 7082, }, { 8, 4, }, nil, nil, { 22392, }, },
	[20010]  = { nil, 1, 10,  20010,  38854, 295, 310, 325, 340,  1,  1, { 16204, 16203, }, { 6, 2, }, nil, nil, { 16246, }, },
	[20013]  = { nil, 1, 10,  20013,  38857, 295, 310, 325, 340,  1,  1, { 16202, 16204, }, { 4, 4, }, true, 20000, { 16244, }, },
	[20023]  = { nil, 1, 10,  20023,  38863, 295, 310, 325, 340,  1,  1, { 16202, 8153, }, { 2, 2, }, true, 20000, { 16245, }, },
	[20030]  = { nil, 1, 10,  20030,  38869, 295, 310, 325, 340,  1,  1, { 14344, 16204, }, { 4, 10, }, nil, nil, { 16247, }, },
	[20033]  = { nil, 1, 10,  20033,  38872, 295, 310, 325, 340,  1,  1, { 14344, 12808, }, { 4, 4, }, nil, nil, { 16248, }, },
	[42613]  = { nil, 1, 10,  42613,  22448, 300, 300, 300, 305,  1,  1, { 20725, }, { 1, }, true, 10000, },
	[25129]  = { nil, 1, 10,  25129,  20749, 300, 310, 320, 330,  1,  1, { 14344, 4625, 3371, }, { 2, 3, 1, }, nil, nil, { 20756, }, },
	[25130]  = { nil, 1, 10,  25130,  20748, 300, 310, 320, 330,  1,  1, { 14344, 8831, 3371, }, { 2, 3, 1, }, nil, nil, { 20757, }, },
	[20011]  = { nil, 1, 10,  20011,  38855, 300, 310, 325, 340,  1,  1, { 16204, }, { 10, }, nil, nil, { 16251, }, },
	[20025]  = { nil, 1, 10,  20025,  38865, 300, 310, 325, 340,  1,  1, { 14344, 16204, }, { 2, 6, }, nil, nil, { 16253, }, },
	[20031]  = { nil, 1, 10,  20031,  38870, 300, 310, 325, 340,  1,  1, { 14344, 16203, }, { 2, 4, }, nil, nil, { 16250, }, },
	[20032]  = { nil, 1, 10,  20032,  38871, 300, 310, 325, 340,  1,  1, { 14344, 12808, 12803, }, { 4, 4, 4, }, nil, nil, { 16254, }, },
	[20034]  = { nil, 1, 10,  20034,  38873, 300, 310, 325, 340,  1,  1, { 14344, 12811, }, { 4, 2, }, nil, nil, { 16252, }, },
	[20035]  = { nil, 1, 10,  20035,  38874, 300, 310, 325, 340,  1,  1, { 16203, 14344, }, { 4, 2, }, nil, nil, { 16255, }, },
	[20036]  = { nil, 1, 10,  20036,  38875, 300, 310, 325, 340,  1,  1, { 16203, 14344, }, { 4, 2, }, nil, nil, { 16249, }, },
	[22749]  = { nil, 1, 10,  22749,  38877, 300, 310, 325, 340,  1,  1, { 14344, 16203, 13926, }, { 4, 6, 2, }, nil, nil, { 18259, }, },
	[22750]  = { nil, 1, 10,  22750,  38878, 300, 310, 325, 340,  1,  1, { 14344, 16203, 7080, }, { 4, 4, 4, }, nil, nil, { 18260, }, },
	[23802]  = { nil, 1, 10,  23802,  38882, 300, 310, 325, 340,  1,  1, { 14344, 16204, 16202, }, { 2, 4, 4, }, nil, nil, { 19447, }, },
	[23803]  = { nil, 1, 10,  23803,  38883, 300, 310, 325, 340,  1,  1, { 14344, 16203, 16204, }, { 6, 4, 12, }, nil, nil, { 19448, }, },
	[23804]  = { nil, 1, 10,  23804,  38884, 300, 310, 325, 340,  1,  1, { 14344, 16203, 16204, }, { 6, 5, 20, }, nil, nil, { 19449, }, },
	[25072]  = { nil, 1, 10,  25072,  38885, 300, 310, 325, 340,  1,  1, { 22448, 22446, 21886, }, { 4, 2, 8, }, nil, nil, { 33153, 20726, }, },
	[25073]  = { nil, 1, 10,  25073,  38886, 300, 310, 325, 340,  1,  1, { 22448, 14344, 12808, }, { 3, 10, 6, }, nil, nil, { 20727, }, },
	[25074]  = { nil, 1, 10,  25074,  38887, 300, 310, 325, 340,  1,  1, { 22448, 14344, 7080, }, { 3, 10, 4, }, nil, nil, { 20728, }, },
	[25078]  = { nil, 1, 10,  25078,  38888, 300, 310, 325, 340,  1,  1, { 22448, 14344, 7078, }, { 2, 10, 4, }, nil, nil, { 20729, }, },
	[25079]  = { nil, 1, 10,  25079,  38889, 300, 310, 325, 340,  1,  1, { 22448, 14344, 12811, }, { 3, 8, 1, }, nil, nil, { 20730, }, },
	[25080]  = { nil, 1, 10,  25080,  38890, 300, 310, 325, 340,  1,  1, { 22448, 22446, 22451, }, { 3, 3, 2, }, nil, nil, { 33152, 20731, }, },
	[25081]  = { nil, 1, 10,  25081,  38891, 300, 310, 325, 340,  1,  1, { 22448, 22446, 7078, }, { 3, 3, 4, }, nil, nil, { 20732, }, },
	[25082]  = { nil, 1, 10,  25082,  38892, 300, 310, 325, 340,  1,  1, { 22448, 22446, 12803, }, { 2, 3, 4, }, nil, nil, { 20733, }, },
	[25083]  = { nil, 1, 10,  25083,  38893, 300, 310, 325, 340,  1,  1, { 22448, 22446, 22794, }, { 3, 3, 2, }, nil, nil, { 33149, 20734, }, },
	[25084]  = { nil, 1, 10,  25084,  38894, 300, 310, 325, 340,  1,  1, { 22448, 22446, 22456, }, { 4, 2, 8, }, nil, nil, { 33150, 33151, 20735, }, },
	[25086]  = { nil, 1, 10,  25086,  38895, 300, 310, 325, 340,  1,  1, { 22448, 22446, 22452, }, { 3, 3, 8, }, nil, nil, { 33148, 20736, }, },
	[32664]  = { nil, 1, 10,  32664,  22461, 300, 310, 325, 340,  1,  1, { 25843, 16203, 14344, 16207, }, { 1, 4, 6, 1, }, true, 10000, },
	[33991]  = { nil, 1, 10,  33991,  38929, 300, 310, 325, 340,  1,  1, { 22447, 22445, }, { 2, 2, }, true, 20000, },
	[34002]  = { nil, 1, 10,  34002,  38938, 300, 310, 325, 340,  1,  1, { 22445, }, { 6, }, true, 12500, },
	[27899]  = { nil, 1, 10,  27899,  38897, 305, 315, 330, 345,  1,  1, { 22445, }, { 6, }, true, 12500, },
	[27948]  = { nil, 1, 10,  27948,  38908, 305, 315, 330, 345,  1,  1, { 22445, 13446, 13444, }, { 6, 4, 4, }, nil, nil, { 22542, 35298, }, },
	[33993]  = { nil, 1, 10,  33993,  38931, 305, 315, 330, 345,  1,  1, { 22447, 22445, }, { 1, 4, }, true, 12500, },
	[34001]  = { nil, 1, 10,  34001,  38937, 305, 315, 330, 345,  1,  1, { 22447, }, { 3, }, true, 12500, },
	[28016]  = { nil, 1, 10,  28016,  22521, 310, 310, 320, 330,  1,  1, { 22445, 22791, 3371, }, { 3, 1, 1, }, nil, nil, { 22562, }, },
	[27944]  = { nil, 1, 10,  27944,  38904, 310, 320, 335, 350,  1,  1, { 22445, 22452, }, { 6, 10, }, true, 15000, },
	[27961]  = { nil, 1, 10,  27961,  38914, 310, 320, 335, 350,  1,  1, { 22445, }, { 8, }, true, 15000, },
	[33996]  = { nil, 1, 10,  33996,  38934, 310, 320, 335, 350,  1,  1, { 22445, }, { 8, }, true, 15000, },
	[34004]  = { nil, 1, 10,  34004,  38940, 310, 320, 335, 350,  1,  1, { 22446, 22445, 22451, }, { 1, 4, 1, }, true, 15000, },
	[27905]  = { nil, 1, 10,  27905,  38898, 315, 325, 340, 355,  1,  1, { 22445, 22447, }, { 6, 6, }, true, 12500, },
	[27957]  = { nil, 1, 10,  27957,  38911, 315, 325, 340, 355,  1,  1, { 22445, 13446, 14344, }, { 8, 4, 2, }, true, 17500, },
	[27906]  = { nil, 1, 10,  27906,  38899, 320, 330, 345, 360,  1,  1, { 22448, 22445, }, { 2, 10, }, nil, nil, { 22530, }, },
	[27950]  = { nil, 1, 10,  27950,  38909, 320, 330, 345, 360,  1,  1, { 22445, }, { 12, }, nil, nil, { 22543, }, },
	[33990]  = { nil, 1, 10,  33990,  38928, 320, 330, 345, 360,  1,  1, { 22446, }, { 2, }, true, 20000, },
	[28027]  = { nil, 1, 10,  28027,  22460, 325, 325, 330, 335,  1,  1, { 22449, }, { 4, }, true, 40000, },
	[28021]  = { nil, 1, 10,  28021,  22445, 325, 335, 345, 355,  3,  3, { 12363, }, { 1, }, nil, nil, { 22564, }, },
	[27911]  = { nil, 1, 10,  27911,  38900, 325, 335, 350, 365,  1,  1, { 22446, 21886, }, { 4, 4, }, nil, nil, { 22531, 24000, }, },
	[27945]  = { nil, 1, 10,  27945,  38905, 325, 335, 350, 365,  1,  1, { 22446, }, { 4, }, nil, nil, { 22539, }, },
	[34003]  = { nil, 1, 10,  34003,  38939, 325, 335, 350, 365,  1,  1, { 22446, 22445, 22457, }, { 2, 6, 2, }, nil, nil, { 28274, }, },
	[34009]  = { nil, 1, 10,  34009,  38945, 325, 335, 350, 365,  1,  1, { 22445, }, { 15, }, nil, nil, { 28282, }, },
	[27962]  = { nil, 1, 10,  27962,  38915, 330, 340, 355, 370,  1,  1, { 22446, 21884, 22451, 22452, 21885, }, { 4, 4, 4, 4, 4, }, nil, nil, { 22548, }, },
	[44383]  = { nil, 1, 10,  44383,  38949, 330, 340, 355, 370,  1,  1, { 22449, 22447, }, { 1, 4, }, true, 25000, },
	[28022]  = { nil, 1, 10,  28022,  22449, 335, 335, 335, 335,  1,  1, { 22448, }, { 3, }, nil, nil, { 22565, }, },
	[42615]  = { nil, 1, 10,  42615,  22448, 335, 335, 335, 335,  3,  3, { 22449, }, { 1, }, true, 40000, },
	[27913]  = { nil, 1, 10,  27913,  38901, 335, 345, 360, 375,  1,  1, { 22446, }, { 8, }, nil, nil, { 22532, }, },
	[28019]  = { nil, 1, 10,  28019,  22522, 340, 340, 350, 360,  1,  1, { 22445, 22792, 3371, }, { 3, 1, 1, }, nil, nil, { 22563, }, },
	[27946]  = { nil, 1, 10,  27946,  38906, 340, 350, 365, 380,  1,  1, { 22445, 22446, 22452, }, { 12, 4, 10, }, nil, nil, { 22540, }, },
	[27951]  = { nil, 1, 10,  27951,  37603, 340, 350, 365, 380,  1,  1, { 22446, 22445, }, { 8, 8, }, nil, nil, { 22544, }, },
	[27967]  = { nil, 1, 10,  27967,  38917, 340, 350, 365, 380,  1,  1, { 22449, 22446, 22445, }, { 2, 6, 6, }, nil, nil, { 22552, }, },
	[27968]  = { nil, 1, 10,  27968,  38918, 340, 350, 365, 380,  1,  1, { 22449, 22446, }, { 2, 10, }, nil, nil, { 22551, }, },
	[33995]  = { nil, 1, 10,  33995,  38933, 340, 350, 365, 380,  1,  1, { 22445, 22446, }, { 12, 1, }, true, 25000, },
	[27960]  = { nil, 1, 10,  27960,  38913, 345, 355, 367, 380,  1,  1, { 22449, 22445, 22446, }, { 4, 4, 4, }, nil, nil, { 24003, 22547, }, },
	[33992]  = { nil, 1, 10,  33992,  38930, 345, 355, 367, 380,  1,  1, { 22446, 22445, }, { 4, 10, }, nil, nil, { 28270, }, },
	[46578]  = { nil, 1, 10,  46578,  38998, 350, 350, 357, 365,  1,  1, { 22456, 21885, }, { 2, 2, }, nil, nil, { 35498, }, },
	[42620]  = { nil, 1, 10,  42620,  38947, 350, 360, 367, 375,  1,  1, { 22445, 22446, 22449, 22451, }, { 8, 4, 6, 2, }, nil, nil, { 33165, }, },
	[27958]  = { nil, 1, 10,  27958,  38912, 350, 360, 370, 380,  1,  1, { 34054, }, { 6, }, true, 50000, },
	[60609]  = { nil, 1, 10,  60609,  44456, 350, 360, 370, 380,  1,  1, { 34054, }, { 6, }, true, 50000, },
	[27914]  = { nil, 1, 10,  27914,  38902, 350, 370, 375, 380,  1,  1, { 22449, 22446, 22445, }, { 1, 10, 20, }, nil, nil, { 22533, }, },
	[27971]  = { nil, 1, 10,  27971,  38919, 350, 370, 375, 380,  1,  1, { 22449, 22445, }, { 4, 40, }, nil, nil, { 22554, }, },
	[27972]  = { nil, 1, 10,  27972,  38920, 350, 370, 375, 380,  1,  1, { 22449, 22446, 22445, }, { 4, 5, 20, }, nil, nil, { 22553, }, },
	[27975]  = { nil, 1, 10,  27975,  38921, 350, 370, 375, 380,  1,  1, { 22449, 22446, }, { 8, 8, }, nil, nil, { 22555, }, },
	[28028]  = { nil, 1, 10,  28028,  22459, 350, 370, 375, 380,  1,  1, { 22450, }, { 2, }, true, 80000, },
	[32665]  = { nil, 1, 10,  32665,  22462, 350, 370, 375, 380,  1,  1, { 25844, 22446, 22449, 23571, 22461, }, { 1, 8, 8, 1, 1, }, true, 80000, { 25848, }, },
	[33999]  = { nil, 1, 10,  33999,  38936, 350, 370, 375, 380,  1,  1, { 22446, 22449, 21886, }, { 6, 6, 6, }, nil, nil, { 28273, }, },
	[34005]  = { nil, 1, 10,  34005,  38941, 350, 370, 375, 380,  1,  1, { 22449, 22457, }, { 4, 8, }, nil, nil, { 28276, }, },
	[34006]  = { nil, 1, 10,  34006,  38942, 350, 370, 375, 380,  1,  1, { 22449, 22456, }, { 4, 8, }, nil, nil, { 28277, }, },
	[34010]  = { nil, 1, 10,  34010,  38946, 350, 370, 375, 380,  1,  1, { 22449, 21885, 21886, }, { 8, 8, 8, }, nil, nil, { 28281, }, },
	[27920]  = { nil, 1, 10,  27920,    nil, 360, 370, 377, 385,  0,  0, { 22449, 22445, }, { 2, 6, }, nil, nil, { 22535, }, },
	[27924]  = { nil, 1, 10,  27924,    nil, 360, 370, 377, 385,  0,  0, { 22449, 22446, }, { 2, 2, }, nil, nil, { 22536, }, },
	[27947]  = { nil, 1, 10,  27947,  38907, 360, 370, 377, 385,  1,  1, { 22449, 22573, 22574, 22572, 22578, }, { 2, 1, 1, 1, 1, }, nil, nil, { 22541, }, },
	[27977]  = { nil, 1, 10,  27977,  38922, 360, 370, 377, 385,  1,  1, { 22449, 22446, 22445, }, { 8, 6, 20, }, nil, nil, { 22556, }, },
	[28003]  = { nil, 1, 10,  28003,  38926, 360, 370, 377, 385,  1,  1, { 22449, 22446, 22445, }, { 12, 10, 20, }, nil, nil, { 22558, }, },
	[28004]  = { nil, 1, 10,  28004,  38927, 360, 370, 377, 385,  1,  1, { 22450, 22449, 21885, }, { 8, 8, 2, }, nil, nil, { 22557, }, },
	[33994]  = { nil, 1, 10,  33994,  38932, 360, 370, 377, 385,  1,  1, { 22446, 22445, 22449, }, { 8, 2, 2, }, nil, nil, { 28271, }, },
	[33997]  = { nil, 1, 10,  33997,  38935, 360, 370, 377, 385,  1,  1, { 22446, 22449, 22457, }, { 6, 6, 6, }, nil, nil, { 28272, }, },
	[34007]  = { nil, 1, 10,  34007,  38943, 360, 370, 377, 385,  1,  1, { 22449, 22451, }, { 8, 8, }, nil, nil, { 28279, 35299, }, },
	[34008]  = { nil, 1, 10,  34008,  38944, 360, 370, 377, 385,  1,  1, { 22449, 22452, }, { 8, 8, }, nil, nil, { 28280, 35297, }, },
	[44592]  = { nil, 1, 10,  44592,  38979, 360, 370, 380, 390,  1,  1, { 34054, 34056, }, { 4, 1, }, true, 50000, },
	[60616]  = { nil, 1, 10,  60616,  38971, 360, 370, 380, 390,  1,  1, { 34054, }, { 6, }, true, 50000, },
	[27917]  = { nil, 1, 10,  27917,  38903, 360, 370, 385, 400,  1,  1, { 22449, 21884, 21885, }, { 6, 6, 6, }, nil, nil, { 22534, }, },
	[46594]  = { nil, 1, 10,  46594,  38999, 360, 370, 385, 400,  1,  1, { 22446, 22445, 23427, }, { 4, 8, 4, }, nil, nil, { 35500, }, },
	[27926]  = { nil, 1, 10,  27926,    nil, 370, 380, 385, 390,  0,  0, { 22449, 22446, 22445, }, { 2, 3, 5, }, nil, nil, { 22537, }, },
	[27954]  = { nil, 1, 10,  27954,  38910, 370, 380, 385, 390,  1,  1, { 22450, 22449, }, { 2, 4, }, nil, nil, { 22545, }, },
	[44623]  = { nil, 1, 10,  44623,  38989, 370, 380, 390, 400,  1,  1, { 34054, 34056, }, { 4, 2, }, true, 50000, },
	[45765]  = { nil, 1, 10,  45765,  22449, 375, 375, 375, 375,  2,  2, { 22450, }, { 1, }, nil, nil, { 34872, }, },
	[32667]  = { nil, 1, 10,  32667,  22463, 375, 375, 377, 385,  1,  1, { 25845, 22446, 22445, 22462, }, { 1, 6, 6, 1, }, true, 50000, { 25849, }, },
	[44506]  = { nil, 1, 10,  44506,  38960, 375, 375, 380, 390,  1,  1, { 34055, }, { 1, }, true, 50000, },
	[27927]  = { nil, 1, 10,  27927,    nil, 375, 380, 385, 390,  0,  0, { 22450, 22449, }, { 2, 2, }, nil, nil, { 22538, 186683, }, },
	[27982]  = { nil, 1, 10,  27982,  38924, 375, 380, 385, 390,  1,  1, { 22450, 22449, 22446, 21885, 22456, }, { 12, 10, 8, 6, 6, }, nil, nil, { 22561, }, },
	[27984]  = { nil, 1, 10,  27984,  38925, 375, 380, 385, 390,  1,  1, { 22450, 22449, 22446, 22445, }, { 6, 10, 8, 40, }, nil, nil, { 22559, }, },
	[42974]  = { nil, 1, 10,  42974,  38948, 375, 380, 385, 390,  1,  1, { 22450, 22449, 22446, 22445, 22824, }, { 6, 10, 6, 30, 3, }, nil, nil, { 33307, 78348, }, },
	[47051]  = { nil, 1, 10,  47051,  39000, 375, 380, 385, 390,  1,  1, { 22446, 22452, }, { 8, 8, }, nil, nil, { 35756, }, },
	[44555]  = { nil, 1, 10,  44555,  38968, 375, 385, 392, 400,  1,  1, { 34054, }, { 10, }, true, 50000, },
	[71692]  = { nil, 1, 10,  71692,  50816, 375, 385, 392, 400,  1,  1, { 34054, 44958, }, { 1, 3, }, nil, nil, { 50406, }, },
	[60606]  = { nil, 1, 10,  60606,  44449, 375, 385, 395, 405,  1,  1, { 34054, 34056, }, { 4, 4, }, true, 50000, },
	[27981]  = { nil, 1, 10,  27981,  38923, 375, 390, 390, 390,  1,  1, { 22450, 22449, 22446, 21884, 23571, }, { 12, 10, 8, 6, 1, }, nil, nil, { 22560, }, },
	[60621]  = { nil, 1, 10,  60621,  44453, 380, 390, 400, 410,  1,  1, { 34054, 34056, }, { 2, 4, }, true, 80000, },
	[44528]  = { nil, 1, 10,  44528,  38966, 385, 385, 390, 400,  1,  1, { 34056, 34054, }, { 3, 3, }, true, 90000, },
	[60623]  = { nil, 1, 10,  60623,  38986, 385, 395, 405, 415,  1,  1, { 34054, 37705, }, { 8, 1, }, true, 90000, },
	[62959]  = { nil, 1, 10,  62959,  45060, 385, 395, 405, 415,  1,  1, { 34054, 34055, }, { 12, 2, }, true, 90000, },
	[44630]  = { nil, 1, 10,  44630,  38992, 390, 400, 410, 420,  1,  1, { 34054, 34055, }, { 6, 2, }, true, 80000, },
	[44582]  = { nil, 1, 10,  44582,  38973, 395, 395, 402, 410,  1,  1, { 34054, }, { 15, }, true, 100000, },
	[44492]  = { nil, 1, 10,  44492,  38955, 395, 405, 415, 425,  1,  1, { 34055, }, { 3, }, true, 100000, },
	[44500]  = { nil, 1, 10,  44500,  38959, 395, 405, 415, 425,  1,  1, { 34054, }, { 9, }, true, 100000, },
	[44513]  = { nil, 1, 10,  44513,  38964, 395, 405, 415, 425,  1,  1, { 34054, 34055, }, { 6, 1, }, true, 100000, },
	[44629]  = { nil, 1, 10,  44629,  38991, 395, 405, 415, 425,  1,  1, { 34054, 34055, }, { 10, 2, }, true, 100000, },
	[44635]  = { nil, 1, 10,  44635,  38997, 395, 405, 415, 425,  1,  1, { 34054, 34056, }, { 8, 4, }, true, 100000, },
	[60653]  = { nil, 1, 10,  60653,  44455, 395, 405, 415, 425,  1,  1, { 34054, }, { 12, }, true, 100000, },
	[44636]  = { nil, 1, 10,  44636,    nil, 400, 400, 407, 415,  0,  0, { 34054, 34055, }, { 8, 1, }, true, 100000, },
	[44645]  = { nil, 1, 10,  44645,    nil, 400, 400, 407, 415,  0,  0, { 34054, 34055, }, { 8, 1, }, true, 100000, },
	[59636]  = { nil, 1, 10,  59636,    nil, 400, 400, 407, 415,  0,  0, { 34054, 34055, }, { 8, 1, }, true, 100000, },
	[44616]  = { nil, 1, 10,  44616,  38987, 400, 410, 420, 430,  1,  1, { 34054, 34055, }, { 16, 3, }, true, 100000, { 37337, }, },
	[47766]  = { nil, 1, 10,  47766,  39002, 400, 410, 420, 430,  1,  1, { 34054, 35624, }, { 10, 1, }, true, 100000, { 37336, }, },
	[44483]  = { nil, 1, 10,  44483,  38950, 400, 415, 425, 435,  1,  1, { 34054, 34055, 36860, }, { 6, 3, 1, }, nil, nil, { 37332, }, },
	[44494]  = { nil, 1, 10,  44494,  38956, 400, 415, 425, 435,  1,  1, { 34054, 34055, 35627, }, { 15, 1, 1, }, nil, nil, { 37333, }, },
	[44556]  = { nil, 1, 10,  44556,  38969, 400, 415, 425, 435,  1,  1, { 34055, 35622, }, { 4, 1, }, nil, nil, { 37331, }, },
	[44590]  = { nil, 1, 10,  44590,  38977, 400, 415, 425, 435,  1,  1, { 34054, 34056, 35625, }, { 8, 2, 1, }, nil, nil, { 37334, }, },
	[44596]  = { nil, 1, 10,  44596,  38982, 400, 415, 425, 435,  1,  1, { 34054, 35624, }, { 20, 1, }, nil, nil, { 37330, }, },
	[44484]  = { nil, 1, 10,  44484,  38951, 405, 415, 425, 435,  1,  1, { 34054, }, { 12, }, true, 150000, },
	[44584]  = { nil, 1, 10,  44584,  38974, 405, 415, 425, 435,  1,  1, { 34054, 34055, }, { 8, 2, }, true, 150000, },
	[44488]  = { nil, 1, 10,  44488,  38953, 410, 420, 430, 440,  1,  1, { 34055, }, { 4, }, true, 150000, },
	[44508]  = { nil, 1, 10,  44508,  38961, 410, 420, 430, 440,  1,  1, { 34054, 34055, }, { 10, 1, }, true, 150000, },
	[44510]  = { nil, 1, 10,  44510,  38963, 410, 420, 430, 440,  1,  1, { 34054, 34052, }, { 16, 4, }, true, 150000, },
	[44633]  = { nil, 1, 10,  44633,  38995, 410, 420, 430, 440,  1,  1, { 34052, 35623, }, { 4, 4, }, true, 150000, },
	[44588]  = { nil, 1, 10,  44588,  38975, 410, 435, 445, 455,  1,  1, { 34055, 34052, }, { 2, 2, }, nil, nil, { 37340, }, },
	[44529]  = { nil, 1, 10,  44529,  38967, 415, 425, 435, 445,  1,  1, { 34055, 34052, }, { 4, 1, }, true, 150000, },
	[44589]  = { nil, 1, 10,  44589,  38976, 415, 425, 435, 445,  1,  1, { 34054, 34055, }, { 16, 4, }, true, 150000, },
	[44598]  = { nil, 1, 10,  44598,  38984, 415, 425, 435, 445,  1,  1, { 34054, 34055, }, { 14, 3, }, true, 150000, },
	[44489]  = { nil, 1, 10,  44489,  38954, 420, 430, 440, 450,  1,  1, { 34054, 35624, }, { 6, 6, }, true, 150000, },
	[44509]  = { nil, 1, 10,  44509,  38962, 420, 430, 440, 450,  1,  1, { 34054, 34055, }, { 4, 4, }, true, 150000, },
	[44593]  = { nil, 1, 10,  44593,  38980, 420, 430, 440, 450,  1,  1, { 34054, 34055, }, { 16, 4, }, true, 150000, },
	[60663]  = { nil, 1, 10,  60663,  44457, 420, 430, 440, 450,  1,  1, { 34054, 34055, 34052, }, { 8, 2, 2, }, true, 150000, },
	[44524]  = { nil, 1, 10,  44524,  38965, 425, 435, 445, 455,  1,  1, { 34052, 36860, }, { 4, 4, }, nil, nil, { 37344, }, },
	[44576]  = { nil, 1, 10,  44576,  38972, 425, 435, 445, 455,  1,  1, { 34052, 35625, }, { 1, 4, }, nil, nil, { 44494, }, },
	[47900]  = { nil, 1, 10,  47900,  39005, 425, 435, 445, 455,  1,  1, { 34054, 34055, }, { 20, 4, }, true, 150000, },
	[60619]  = { nil, 1, 10,  60619,  44452, 425, 435, 445, 455,  1,  1, { 41745, 34054, 34055, 34052, 22463, }, { 1, 12, 4, 2, 1, }, true, 150000, },
	[60668]  = { nil, 1, 10,  60668,  44458, 425, 435, 445, 455,  1,  1, { 34054, 34055, 34052, }, { 20, 4, 1, }, true, 150000, },
	[74132]  = { nil, 1, 10,  74132,  52687, 425, 440, 450, 460,  1,  1, { 52555, 52718, }, { 1, 1, }, true, 30000, },
	[74189]  = { nil, 1, 10,  74189,  52743, 425, 440, 450, 460,  1,  1, { 52555, }, { 2, }, true, 30000, },
	[74191]  = { nil, 1, 10,  74191,  52744, 425, 440, 450, 460,  1,  1, { 52718, }, { 2, }, true, 30000, },
	[44575]  = { nil, 1, 10,  44575,  44815, 430, 440, 450, 460,  1,  1, { 34054, 34055, }, { 24, 6, }, nil, nil, { 44484, }, },
	[44595]  = { nil, 1, 10,  44595,  38981, 430, 440, 450, 460,  1,  1, { 34054, 34052, }, { 6, 6, }, nil, nil, { 37327, 44473, }, },
	[44621]  = { nil, 1, 10,  44621,  38988, 430, 440, 450, 460,  1,  1, { 34055, 34052, }, { 2, 6, }, nil, nil, { 37339, }, },
	[47672]  = { nil, 1, 10,  47672,  39001, 430, 440, 450, 460,  1,  1, { 34054, 34055, }, { 15, 2, }, nil, nil, { 44471, }, },
	[47898]  = { nil, 1, 10,  47898,  39003, 430, 440, 450, 460,  1,  1, { 34054, 34055, }, { 16, 4, }, nil, nil, { 37348, 44472, }, },
	[60691]  = { nil, 1, 10,  60691,  44463, 430, 440, 450, 460,  1,  1, { 34054, 34055, 34057, }, { 40, 6, 6, }, nil, nil, { 44483, }, },
	[44591]  = { nil, 1, 10,  44591,  38978, 435, 445, 455, 465,  1,  1, { 34054, 41163, 34052, }, { 8, 2, 2, }, nil, nil, { 37347, }, },
	[44625]  = { nil, 1, 10,  44625,  38990, 435, 445, 455, 465,  1,  1, { 34052, 35624, }, { 2, 8, }, nil, nil, { 44485, }, },
	[60707]  = { nil, 1, 10,  60707,  44466, 435, 445, 455, 465,  1,  1, { 34054, 34055, 34052, 34057, }, { 10, 2, 2, 4, }, nil, nil, { 44486, }, },
	[60714]  = { nil, 1, 10,  60714,  44467, 435, 445, 455, 465,  1,  1, { 34054, 34052, 34057, }, { 30, 6, 6, }, nil, nil, { 44487, }, },
	[74192]  = { nil, 1, 10,  74192,  52745, 435, 450, 460, 470,  1,  1, { 52555, }, { 3, }, true, 30000, },
	[74193]  = { nil, 1, 10,  74193,  52746, 435, 450, 460, 470,  1,  1, { 52555, 52718, }, { 2, 1, }, true, 30000, },
	[44631]  = { nil, 1, 10,  44631,  38993, 440, 450, 460, 470,  1,  1, { 34054, 34057, }, { 12, 1, }, nil, nil, { 37349, }, },
	[47899]  = { nil, 1, 10,  47899,  39004, 440, 450, 460, 470,  1,  1, { 34055, 34057, }, { 6, 1, }, nil, nil, { 44488, }, },
	[47901]  = { nil, 1, 10,  47901,  39006, 440, 450, 460, 470,  1,  1, { 34054, 34055, 34052, }, { 10, 2, 2, }, nil, nil, { 44491, }, },
	[59619]  = { nil, 1, 10,  59619,  44497, 440, 450, 460, 470,  1,  1, { 34054, 34055, 34052, 34057, }, { 20, 4, 4, 6, }, nil, nil, { 44496, }, },
	[59621]  = { nil, 1, 10,  59621,  44493, 440, 450, 460, 470,  1,  1, { 34054, 34055, 34052, 34057, }, { 12, 4, 4, 10, }, nil, nil, { 44492, }, },
	[59625]  = { nil, 1, 10,  59625,  43987, 440, 450, 460, 470,  1,  1, { 34055, 34052, 34057, }, { 6, 6, 6, }, nil, nil, { 44495, }, },
	[60692]  = { nil, 1, 10,  60692,  44465, 440, 450, 460, 470,  1,  1, { 34052, 34057, }, { 4, 4, }, nil, nil, { 44489, }, },
	[60763]  = { nil, 1, 10,  60763,  44469, 440, 450, 460, 470,  1,  1, { 34055, 34052, }, { 4, 4, }, nil, nil, { 44490, }, },
	[60767]  = { nil, 1, 10,  60767,  44470, 440, 450, 460, 470,  1,  1, { 34054, 34055, 34052, }, { 6, 6, 1, }, nil, nil, { 44498, }, },
	[69412]  = { nil, 1, 10,  69412, 206759, 445, 445, 447, 450,  1,  1, { 34057, }, { 1, }, true, 150000, },
	[62948]  = { nil, 1, 10,  62948,  45056, 450, 455, 460, 465,  1,  1, { 34054, 34052, 34057, }, { 40, 6, 6, }, nil, nil, { 45059, }, },
	[64441]  = { nil, 1, 10,  64441,  46026, 450, 455, 460, 465,  1,  1, { 34057, 34055, 37663, }, { 4, 8, 1, }, nil, nil, { 46027, }, },
	[64579]  = { nil, 1, 10,  64579,  46098, 450, 455, 460, 465,  1,  1, { 34057, 34054, 36918, }, { 4, 40, 1, }, nil, nil, { 46348, }, },
	[74195]  = { nil, 1, 10,  74195,  52747, 450, 460, 462, 465,  1,  1, { 52555, 52719, }, { 11, 3, }, true, 30000, },
	[74197]  = { nil, 1, 10,  74197,  52748, 450, 460, 462, 465,  1,  1, { 52555, 52719, }, { 4, 6, }, true, 30000, },
	[62256]  = { nil, 1, 10,  62256,  44947, 450, 460, 470, 480,  1,  1, { 34055, 34057, }, { 4, 1, }, nil, nil, { 44944, }, },
	[62257]  = { nil, 1, 10,  62257,  44946, 450, 460, 470, 480,  1,  1, { 34052, 37663, }, { 4, 1, }, nil, nil, { 44945, }, },
	[74198]  = { nil, 1, 10,  74198,  52749, 455, 465, 475, 485,  1,  1, { 52555, 52718, }, { 4, 1, }, true, 30000, },
	[74199]  = { nil, 1, 10,  74199,  52750, 455, 465, 475, 485,  1,  1, { 52555, 52719, }, { 2, 1, }, true, 30000, },
	[74200]  = { nil, 1, 10,  74200,  52751, 460, 470, 480, 490,  1,  1, { 52555, 52718, }, { 5, 1, }, true, 30000, },
	[74201]  = { nil, 1, 10,  74201,  52752, 460, 470, 480, 490,  1,  1, { 52555, 52718, }, { 4, 2, }, true, 30000, },
	[74202]  = { nil, 1, 10,  74202,  52753, 465, 475, 485, 495,  1,  1, { 52555, }, { 6, }, true, 30000, },
	[74207]  = { nil, 1, 10,  74207,  52754, 465, 475, 485, 495,  1,  1, { 52719, 52327, }, { 1, 15, }, true, 30000, },
	[74211]  = { nil, 1, 10,  74211,  52755, 470, 480, 490, 500,  1,  1, { 52555, 52719, 52721, }, { 7, 2, 1, }, true, 30000, },
	[74212]  = { nil, 1, 10,  74212,  52756, 470, 480, 490, 500,  1,  1, { 52555, 52719, }, { 3, 2, }, true, 30000, },
	[95471]  = { nil, 1, 10,  95471,  68134, 470, 480, 490, 500,  1,  1, { 52555, 52719, 52721, }, { 3, 3, 3, }, true, 30000, },
	[74215]  = { nil, 1, 10,  74215,    nil, 475, 475, 475, 495,  0,  0, { 52721, }, { 1, }, true, 30000, },
	[74216]  = { nil, 1, 10,  74216,    nil, 475, 475, 475, 495,  0,  0, { 52721, }, { 1, }, true, 30000, },
	[74217]  = { nil, 1, 10,  74217,    nil, 475, 475, 475, 495,  0,  0, { 52721, }, { 1, }, true, 30000, },
	[74218]  = { nil, 1, 10,  74218,    nil, 475, 475, 475, 495,  0,  0, { 52721, }, { 1, }, true, 30000, },
	[74213]  = { nil, 1, 10,  74213,  52757, 475, 485, 495, 505,  1,  1, { 52555, 52719, }, { 4, 2, }, true, 30000, },
	[74214]  = { nil, 1, 10,  74214,  52758, 475, 485, 495, 505,  1,  1, { 52555, }, { 9, }, true, 30000, },
	[74220]  = { nil, 1, 10,  74220,  52759, 480, 490, 500, 510,  1,  1, { 52555, 52719, }, { 5, 2, }, true, 30000, },
	[74223]  = { nil, 1, 10,  74223,  52760, 480, 490, 500, 510,  1,  1, { 52721, 52328, }, { 6, 6, }, true, 30000, },
	[74225]  = { nil, 1, 10,  74225,  52761, 485, 495, 505, 515,  1,  1, { 52555, 52719, 52721, 52329, }, { 9, 3, 3, 3, }, true, 30000, },
	[74226]  = { nil, 1, 10,  74226,  52762, 485, 495, 505, 515,  1,  1, { 52555, }, { 12, }, true, 30000, },
	[74229]  = { nil, 1, 10,  74229,  52763, 490, 500, 510, 520,  1,  1, { 52719, 52328, }, { 5, 1, }, true, 30000, },
	[74230]  = { nil, 1, 10,  74230,  52764, 490, 500, 510, 520,  1,  1, { 52555, 52719, }, { 8, 2, }, true, 30000, },
	[74231]  = { nil, 1, 10,  74231,  52765, 495, 505, 515, 525,  1,  1, { 52555, 52719, }, { 10, 2, }, true, 30000, },
	[74232]  = { nil, 1, 10,  74232,  52766, 495, 505, 515, 525,  1,  1, { 52555, 52719, }, { 12, 1, }, true, 30000, },
	[74234]  = { nil, 1, 10,  74234,  52767, 500, 510, 520, 530,  1,  1, { 52555, 52719, }, { 8, 3, }, true, 30000, },
	[74235]  = { nil, 1, 10,  74235,  52768, 500, 510, 520, 530,  1,  1, { 52555, 52719, }, { 6, 4, }, true, 30000, },
	[74236]  = { nil, 1, 10,  74236,  52769, 505, 510, 512, 515,  1,  1, { 52555, 52719, 58094, }, { 2, 2, 1, }, true, 30000, },
	[74237]  = { nil, 1, 10,  74237,  52770, 505, 515, 525, 535,  1,  1, { 52555, 52719, }, { 9, 3, }, true, 30000, },
	[74238]  = { nil, 1, 10,  74238,  52771, 510, 520, 530, 540,  1,  1, { 52555, 52719, }, { 10, 3, }, true, 30000, },
	[74239]  = { nil, 1, 10,  74239,  52772, 510, 520, 530, 540,  1,  1, { 52555, 52719, }, { 4, 6, }, true, 30000, },
	[74240]  = { nil, 1, 10,  74240,  52773, 510, 520, 530, 540,  1,  1, { 52555, 52719, }, { 9, 4, }, true, 30000, },
	[92370]  = { nil, 1, 10,  92370,  52723, 515, 525, 525, 525,  1,  1, { 44452, 52555, 52719, 52721, 65358, }, { 1, 10, 6, 6, 1, }, nil, nil, { 65359, }, },
	[104698] = { nil, 1, 10, 104698,  52721, 515, 525, 530, 535,  2,  2, { 52722, }, { 1, }, true, 30000, },
	[96261]  = { nil, 1, 10,  96261,  68785, 515, 525, 532, 540,  1,  1, { 52555, 52722, 52327, }, { 6, 2, 25, }, nil, nil, { 68788, }, },
	[96262]  = { nil, 1, 10,  96262,  68786, 515, 525, 532, 540,  1,  1, { 52555, 52719, 52722, 52326, }, { 4, 4, 2, 15, }, nil, nil, { 68789, }, },
	[96264]  = { nil, 1, 10,  96264,  68784, 515, 525, 532, 540,  1,  1, { 52555, 52722, 52328, }, { 12, 2, 15, }, nil, nil, { 68787, }, },
	[93841]  = { nil, 1, 10,  93841,  67274, 525, 525, 525, 525,  1,  1, { 52721, 52722, 52555, }, { 8, 1, 8, }, nil, nil, { 67308, }, },
	[93843]  = { nil, 1, 10,  93843,  67275, 525, 525, 525, 525,  1,  1, { 52721, 52722, 52719, }, { 8, 1, 4, }, nil, nil, { 67312, }, },
	[74242]  = { nil, 1, 10,  74242,  52774, 525, 525, 532, 540,  1,  1, { 52555, 52721, 52722, }, { 14, 8, 4, }, nil, nil, { 52733, }, },
	[74244]  = { nil, 1, 10,  74244,  52775, 525, 525, 532, 540,  1,  1, { 52719, 52721, 52722, }, { 4, 6, 6, }, nil, nil, { 52735, }, },
	[74246]  = { nil, 1, 10,  74246,  52776, 525, 525, 532, 540,  1,  1, { 52555, 52719, 52721, 52722, }, { 6, 5, 5, 5, }, nil, nil, { 52736, }, },
	[74247]  = { nil, 1, 10,  74247,  52777, 525, 525, 532, 540,  1,  1, { 52722, }, { 5, }, nil, nil, { 52737, }, },
	[74248]  = { nil, 1, 10,  74248,  52778, 525, 525, 532, 540,  1,  1, { 52555, 52719, 52721, 52722, }, { 15, 3, 2, 1, }, nil, nil, { 52738, }, },
	[74250]  = { nil, 1, 10,  74250,  52779, 525, 525, 532, 540,  1,  1, { 52721, 52722, }, { 3, 3, }, nil, nil, { 52739, }, },
	[74251]  = { nil, 1, 10,  74251,  52780, 525, 525, 532, 540,  1,  1, { 52555, 52721, 52722, }, { 10, 4, 2, }, nil, nil, { 52740, }, },
	[74252]  = { nil, 1, 10,  74252,  52781, 525, 525, 532, 540,  1,  1, { 52555, 52719, 52721, 52722, }, { 5, 7, 2, 1, }, nil, nil, { 64411, }, },
	[74253]  = { nil, 1, 10,  74253,  52782, 525, 525, 532, 540,  1,  1, { 52719, 52721, 52722, }, { 10, 2, 1, }, nil, nil, { 64412, }, },
	[74254]  = { nil, 1, 10,  74254,  52783, 525, 525, 532, 540,  1,  1, { 52555, 52719, 52722, }, { 4, 8, 2, }, nil, nil, { 64415, }, },
	[74255]  = { nil, 1, 10,  74255,  52784, 525, 525, 532, 540,  1,  1, { 52555, 52719, 52722, }, { 10, 5, 2, }, nil, nil, { 64414, }, },
	[74256]  = { nil, 1, 10,  74256,  52785, 525, 525, 532, 540,  1,  1, { 52555, 52719, 52721, 52722, }, { 12, 4, 2, 1, }, nil, nil, { 64413, }, },
	[25255]  = { nil, 1, 15,  25255,  20816,   1,  20,  35,  50,  1,  1, { 2840, }, { 2, }, },
	[32259]  = { nil, 1, 15,  32259,  25498,   1,  30,  40,  50,  1,  1, { 2835, }, { 8, }, },
	[25493]  = { nil, 1, 15,  25493,  20906,   1,  30,  45,  60,  1,  1, { 20816, }, { 2, }, },
	[26925]  = { nil, 1, 15,  26925,  21931,   1,  30,  45,  60,  1,  1, { 20816, 2840, }, { 2, 1, }, },
	[26926]  = { nil, 1, 15,  26926,  21932,   5,  35,  50,  65,  1,  1, { 2840, 20816, }, { 4, 2, }, },
	[32178]  = { nil, 1, 15,  32178,  25438,  20,  50,  65,  80,  1,  1, { 774, 20816, }, { 1, 1, }, },
	[32179]  = { nil, 1, 15,  32179,  25439,  20,  50,  65,  80,  1,  1, { 818, 20816, }, { 1, 1, }, },
	[25283]  = { nil, 1, 15,  25283,  20821,  30,  60,  75,  90,  1,  1, { 774, 2840, }, { 2, 2, }, },
	[26928]  = { nil, 1, 15,  26928,  21934,  30,  60,  75,  90,  1,  1, { 818, 2840, 20816, }, { 2, 2, 1, }, },
	[25278]  = { nil, 1, 15,  25278,  20817,  50,  70,  80,  90,  1,  1, { 2841, }, { 2, }, },
	[32801]  = { nil, 1, 15,  32801,  25880,  50,  70,  80,  90,  1,  1, { 2836, }, { 8, }, },
	[25280]  = { nil, 1, 15,  25280,  20818,  50,  80,  95, 110,  1,  1, { 2842, }, { 1, }, },
	[25490]  = { nil, 1, 15,  25490,  20907,  50,  80,  95, 110,  1,  1, { 2841, }, { 4, }, },
	[26927]  = { nil, 1, 15,  26927,  21933,  50,  80,  95, 110,  1,  1, { 2841, 1210, 20816, }, { 2, 1, 1, }, },
	[25284]  = { nil, 1, 15,  25284,  20820,  60,  90, 105, 120,  1,  1, { 5498, 20817, 2840, }, { 1, 1, 2, }, },
	[37818]  = { nil, 1, 15,  37818,  30804,  65,  95, 110, 125,  1,  1, { 2841, 20817, 774, 818, 1210, }, { 2, 1, 3, 3, 2, }, },
	[25287]  = { nil, 1, 15,  25287,  20823,  70, 100, 115, 130,  1,  1, { 1210, 20817, 20816, }, { 2, 1, 2, }, },
	[36523]  = { nil, 1, 15,  36523,  30419,  75, 105, 120, 135,  1,  1, { 2841, 20817, 1206, }, { 4, 1, 1, }, },
	[25317]  = { nil, 1, 15,  25317,  20827,  80, 110, 125, 140,  1,  1, { 2842, }, { 2, }, },
	[38175]  = { nil, 1, 15,  38175,  31154,  80, 110, 125, 140,  1,  1, { 2841, 20817, 1705, }, { 6, 1, 1, }, },
	[25305]  = { nil, 1, 15,  25305,  20826,  90, 120, 135, 150,  1,  1, { 2842, 20817, 1206, 1705, }, { 2, 1, 1, 1, }, },
	[25318]  = { nil, 1, 15,  25318,  20828, 100, 130, 145, 160,  1,  1, { 1210, 2841, }, { 2, 2, }, },
	[36524]  = { nil, 1, 15,  36524,  30420, 105, 135, 150, 165,  1,  1, { 1529, 20817, 3575, }, { 1, 1, 2, }, },
	[32807]  = { nil, 1, 15,  32807,  25881, 110, 120, 130, 140,  1,  1, { 2838, }, { 8, }, },
	[25339]  = { nil, 1, 15,  25339,  20830, 110, 140, 155, 170,  1,  1, { 1705, 20817, }, { 2, 1, }, nil, nil, { 20854, }, },
	[25498]  = { nil, 1, 15,  25498,  20909, 110, 140, 155, 170,  1,  1, { 3575, 5637, 20817, }, { 8, 2, 2, }, },
	[25321]  = { nil, 1, 15,  25321,  20832, 120, 150, 165, 180,  1,  1, { 1705, 5498, 11083, 2842, 3827, }, { 3, 3, 4, 4, 2, }, },
	[25610]  = { nil, 1, 15,  25610,  20950, 120, 150, 165, 180,  1,  1, { 1206, 20817, }, { 1, 1, }, nil, nil, { 20970, }, },
	[25323]  = { nil, 1, 15,  25323,  20833, 125, 155, 170, 185,  1,  1, { 1705, 3824, 3575, }, { 1, 1, 4, }, nil, nil, { 20855, }, },
	[25612]  = { nil, 1, 15,  25612,  20954, 125, 155, 170, 185,  1,  1, { 3575, 3391, }, { 8, 2, }, nil, nil, { 20971, }, },
	[25613]  = { nil, 1, 15,  25613,  20955, 135, 165, 180, 195,  1,  1, { 1529, 3577, 20816, }, { 1, 2, 2, }, },
	[25614]  = { nil, 1, 15,  25614,  20956, 145, 175, 190, 205,  1,  1, { 1206, 1529, 2842, 20817, }, { 1, 1, 2, 2, }, nil, nil, { 20972, }, },
	[25615]  = { nil, 1, 15,  25615,  20963, 150, 170, 180, 190,  1,  1, { 3860, }, { 2, }, },
	[25320]  = { nil, 1, 15,  25320,  20831, 150, 180, 195, 210,  1,  1, { 3577, 1206, 3391, }, { 1, 2, 1, }, nil, nil, { 20856, }, },
	[25617]  = { nil, 1, 15,  25617,  20958, 150, 180, 195, 210,  1,  1, { 3864, 20963, }, { 1, 1, }, nil, nil, { 20973, }, },
	[25618]  = { nil, 1, 15,  25618,  20966, 160, 190, 205, 220,  1,  1, { 1529, 20963, }, { 1, 2, }, nil, nil, { 20974, }, },
	[25619]  = { nil, 1, 15,  25619,  20959, 170, 200, 215, 230,  1,  1, { 1529, 7067, }, { 1, 2, }, nil, nil, { 20975, }, },
	[25620]  = { nil, 1, 15,  25620,  20960, 170, 200, 215, 230,  1,  1, { 6037, 20963, }, { 1, 2, }, },
	[32808]  = { nil, 1, 15,  32808,  25882, 175, 175, 185, 195,  1,  1, { 7912, }, { 10, }, },
	[34955]  = { nil, 1, 15,  34955,  29157, 180, 190, 200, 210,  1,  1, { 3577, 1705, 1529, 3864, }, { 4, 1, 1, 1, }, },
	[25621]  = { nil, 1, 15,  25621,  20961, 180, 210, 225, 240,  1,  1, { 3864, 3860, }, { 1, 2, }, },
	[25622]  = { nil, 1, 15,  25622,  20967, 190, 220, 235, 250,  1,  1, { 3864, 7070, 3577, 20817, }, { 1, 2, 2, 1, }, nil, nil, { 20976, }, },
	[34959]  = { nil, 1, 15,  34959,  29158, 200, 210, 220, 230,  1,  1, { 6037, 7910, 3864, }, { 3, 2, 2, }, },
	[63743]  = { nil, 1, 15,  63743,  45627, 200, 210, 220, 230,  1,  1, { 6037, }, { 8, }, },
	[26872]  = { nil, 1, 15,  26872,  21748, 200, 225, 240, 255,  1,  1, { 1529, 6037, 11137, 20963, }, { 4, 2, 4, 4, }, },
	[26873]  = { nil, 1, 15,  26873,  21756, 200, 225, 240, 255,  1,  1, { 3577, 3864, }, { 6, 2, }, nil, nil, { 21940, }, },
	[26874]  = { nil, 1, 15,  26874,  20964, 210, 235, 250, 265,  1,  1, { 7909, 52188, }, { 3, 1, }, },
	[26875]  = { nil, 1, 15,  26875,  21758, 215, 240, 255, 270,  1,  1, { 7971, }, { 4, }, nil, nil, { 21941, }, },
	[26876]  = { nil, 1, 15,  26876,  21755, 220, 245, 260, 275,  1,  1, { 7909, 20963, }, { 1, 3, }, },
	[32809]  = { nil, 1, 15,  32809,  25883, 225, 225, 235, 245,  1,  1, { 12365, }, { 10, }, },
	[26880]  = { nil, 1, 15,  26880,  21752, 225, 235, 245, 255,  1,  1, { 12359, }, { 1, }, },
	[26878]  = { nil, 1, 15,  26878,  20969, 225, 250, 265, 280,  1,  1, { 7910, 7971, 6037, 21752, 6149, }, { 2, 2, 4, 4, 4, }, nil, nil, { 21942, }, },
	[26881]  = { nil, 1, 15,  26881,  21760, 225, 250, 265, 280,  1,  1, { 7909, 6037, 7075, 7079, }, { 2, 4, 2, 2, }, nil, nil, { 21943, }, },
	[36525]  = { nil, 1, 15,  36525,  30421, 230, 255, 270, 285,  1,  1, { 7910, 21752, }, { 1, 1, }, },
	[26882]  = { nil, 1, 15,  26882,  21763, 235, 260, 275, 290,  1,  1, { 7910, 6037, 7077, 7081, }, { 2, 4, 2, 2, }, nil, nil, { 21944, }, },
	[26883]  = { nil, 1, 15,  26883,  21764, 235, 260, 275, 290,  1,  1, { 7910, 21752, }, { 1, 1, }, },
	[26885]  = { nil, 1, 15,  26885,  21765, 240, 265, 280, 295,  1,  1, { 6037, 10286, }, { 2, 2, }, },
	[26887]  = { nil, 1, 15,  26887,  21754, 245, 270, 285, 300,  1,  1, { 7909, 21752, }, { 1, 1, }, nil, nil, { 21945, }, },
	[26896]  = { nil, 1, 15,  26896,  21753, 250, 275, 290, 305,  1,  1, { 7909, 3864, 21752, 6037, }, { 2, 2, 4, 2, }, nil, nil, { 21947, }, },
	[26897]  = { nil, 1, 15,  26897,  21766, 250, 275, 290, 305,  1,  1, { 12799, 21752, 6037, 11178, 20963, }, { 2, 2, 4, 2, 2, }, nil, nil, { 21948, }, },
	[26900]  = { nil, 1, 15,  26900,  21769, 260, 280, 290, 300,  1,  1, { 7910, 7078, 6037, }, { 2, 2, 2, }, nil, nil, { 21949, }, },
	[26902]  = { nil, 1, 15,  26902,  21767, 260, 280, 290, 300,  1,  1, { 12799, 21752, }, { 1, 1, }, },
	[36526]  = { nil, 1, 15,  36526,  30422, 265, 285, 295, 305,  1,  1, { 12800, 21752, }, { 1, 1, }, },
	[26903]  = { nil, 1, 15,  26903,  21768, 275, 285, 295, 305,  1,  1, { 12361, 6037, 21752, }, { 4, 2, 1, }, },
	[26906]  = { nil, 1, 15,  26906,  21774, 275, 285, 295, 305,  1,  1, { 12364, 12799, 12361, 12360, 12359, }, { 2, 2, 2, 2, 2, }, nil, nil, { 21952, }, },
	[26907]  = { nil, 1, 15,  26907,  21775, 280, 290, 300, 310,  1,  1, { 21752, 12804, 7076, }, { 1, 1, 1, }, },
	[26908]  = { nil, 1, 15,  26908,  21790, 280, 290, 300, 310,  1,  1, { 12361, 12808, 21752, }, { 1, 1, 1, }, },
	[34960]  = { nil, 1, 15,  34960,  29159, 280, 290, 300, 310,  1,  1, { 12800, 21752, }, { 2, 1, }, },
	[26909]  = { nil, 1, 15,  26909,  21777, 285, 295, 305, 315,  1,  1, { 12364, 12360, 12359, 12804, }, { 2, 2, 2, 4, }, nil, nil, { 21953, }, },
	[26910]  = { nil, 1, 15,  26910,  21778, 285, 295, 305, 315,  1,  1, { 12363, 12808, 12662, }, { 1, 2, 1, }, nil, nil, { 21954, }, },
	[26911]  = { nil, 1, 15,  26911,  21791, 290, 300, 310, 320,  1,  1, { 12364, 12803, 12804, }, { 2, 4, 4, }, },
	[34961]  = { nil, 1, 15,  34961,  29160, 290, 300, 310, 320,  1,  1, { 12364, 21752, }, { 2, 1, }, },
	[32810]  = { nil, 1, 15,  32810,  25884, 300, 300, 310, 320,  1,  1, { 22452, }, { 1, }, nil, nil, { 25888, }, },
	[28903]  = { nil, 1, 15,  28903,  23094, 300, 300, 320, 340,  1,  1, { 23077, }, { 1, }, nil, nil, { 23130, 23133, 23148, }, },
	[28910]  = { nil, 1, 15,  28910,  23098, 300, 300, 320, 340,  1,  1, { 21929, }, { 1, }, nil, nil, { 23135, }, },
	[28916]  = { nil, 1, 15,  28916,  23103, 300, 300, 320, 340,  1,  1, { 23079, }, { 1, }, nil, nil, { 23140, }, },
	[28925]  = { nil, 1, 15,  28925,  23108, 300, 300, 320, 340,  1,  1, { 23107, }, { 1, }, nil, nil, { 23144, }, },
	[28950]  = { nil, 1, 15,  28950,  23118, 300, 300, 320, 340,  1,  1, { 23117, }, { 1, }, nil, nil, { 23152, }, },
	[62941]  = { nil, 1, 15,  62941,  45054, 300, 310, 315, 320,  1,  1, { 11754, }, { 1, }, },
	[26912]  = { nil, 1, 15,  26912,  21784, 300, 310, 320, 330,  1,  1, { 18335, 11754, 12800, 12360, 12359, }, { 4, 4, 2, 2, 4, }, nil, nil, { 21955, }, },
	[26914]  = { nil, 1, 15,  26914,  21789, 300, 310, 320, 330,  1,  1, { 11371, 12360, 7910, }, { 4, 2, 2, }, nil, nil, { 21956, }, },
	[28905]  = { nil, 1, 15,  28905,  23095, 305, 305, 325, 345,  1,  1, { 23077, }, { 1, }, nil, nil, { 23131, }, },
	[28912]  = { nil, 1, 15,  28912,  23099, 305, 305, 325, 345,  1,  1, { 21929, }, { 1, }, nil, nil, { 23136, }, },
	[28917]  = { nil, 1, 15,  28917,  23104, 305, 305, 325, 345,  1,  1, { 23079, }, { 1, }, nil, nil, { 23141, }, },
	[28927]  = { nil, 1, 15,  28927,  23109, 305, 305, 325, 345,  1,  1, { 23107, }, { 1, }, nil, nil, { 23143, 23145, }, },
	[28944]  = { nil, 1, 15,  28944,  23114, 305, 305, 325, 345,  1,  1, { 23112, }, { 1, }, nil, nil, { 23149, 28291, }, },
	[34590]  = { nil, 1, 15,  34590,  28595, 305, 305, 325, 345,  1,  1, { 23077, }, { 1, }, nil, nil, { 23134, 28596, }, },
	[26915]  = { nil, 1, 15,  26915,  21792, 305, 315, 325, 335,  1,  1, { 12800, 21752, 12360, }, { 2, 2, 2, }, nil, nil, { 21957, }, },
	[26916]  = { nil, 1, 15,  26916,  21779, 310, 320, 330, 340,  1,  1, { 21929, 7078, 12803, }, { 1, 4, 4, }, },
	[31048]  = { nil, 1, 15,  31048,  24074, 310, 320, 330, 340,  1,  1, { 23445, 23077, }, { 1, 2, }, },
	[31049]  = { nil, 1, 15,  31049,  24075, 310, 320, 335, 350,  1,  1, { 23445, 23112, }, { 1, 2, }, },
	[28914]  = { nil, 1, 15,  28914,  23100, 315, 315, 335, 355,  1,  1, { 23107, }, { 1, }, nil, nil, { 23137, }, },
	[28918]  = { nil, 1, 15,  28918,  23105, 315, 315, 335, 355,  1,  1, { 23079, }, { 1, }, nil, nil, { 23142, 31359, }, },
	[28933]  = { nil, 1, 15,  28933,  23110, 315, 315, 335, 355,  1,  1, { 23107, }, { 1, }, nil, nil, { 23146, 31871, 31872, }, },
	[28947]  = { nil, 1, 15,  28947,  23115, 315, 315, 335, 355,  1,  1, { 23112, }, { 1, }, nil, nil, { 23150, }, },
	[28955]  = { nil, 1, 15,  28955,  23120, 315, 315, 335, 355,  1,  1, { 23117, }, { 1, }, nil, nil, { 23154, }, },
	[26918]  = { nil, 1, 15,  26918,  21793, 315, 325, 335, 345,  1,  1, { 12360, 7076, 7082, }, { 4, 4, 4, }, nil, nil, { 21958, }, },
	[31050]  = { nil, 1, 15,  31050,  24076, 320, 330, 340, 350,  1,  1, { 23445, 23117, 23079, }, { 1, 2, 1, }, },
	[28953]  = { nil, 1, 15,  28953,  23119, 325, 325, 325, 345,  1,  1, { 23117, }, { 1, }, nil, nil, { 23155, }, },
	[41420]  = { nil, 1, 15,  41420,  32833, 325, 325, 332, 340,  1,  1, { 24478, 27860, }, { 1, 1, }, },
	[38068]  = { nil, 1, 15,  38068,  31079, 325, 325, 335, 345,  1,  1, { 24243, 22452, }, { 4, 1, }, },
	[28915]  = { nil, 1, 15,  28915,  23101, 325, 325, 340, 355,  1,  1, { 21929, }, { 1, }, nil, nil, { 23138, }, },
	[28936]  = { nil, 1, 15,  28936,  23111, 325, 325, 340, 355,  1,  1, { 23107, }, { 1, }, nil, nil, { 23147, }, },
	[28948]  = { nil, 1, 15,  28948,  23116, 325, 325, 340, 355,  1,  1, { 23117, }, { 1, }, nil, nil, { 23151, 31870, }, },
	[39466]  = { nil, 1, 15,  39466,  31866, 325, 325, 340, 355,  1,  1, { 23107, }, { 1, }, nil, nil, { 31873, }, },
	[39467]  = { nil, 1, 15,  39467,  31869, 325, 325, 340, 355,  1,  1, { 21929, }, { 1, }, nil, nil, { 31874, }, },
	[26920]  = { nil, 1, 15,  26920,  21780, 325, 335, 345, 355,  1,  1, { 12359, 11382, 7910, 12938, }, { 8, 2, 4, 2, }, nil, nil, { 21959, }, },
	[41414]  = { nil, 1, 15,  41414,  32772, 325, 335, 345, 355,  1,  1, { 24478, 23447, }, { 8, 2, }, },
	[41415]  = { nil, 1, 15,  41415,  32774, 330, 340, 350, 360,  1,  1, { 24479, 31079, }, { 1, 4, }, },
	[31051]  = { nil, 1, 15,  31051,  24077, 335, 345, 355, 365,  1,  1, { 23446, 31079, }, { 2, 1, }, },
	[31052]  = { nil, 1, 15,  31052,  24078, 335, 345, 355, 365,  1,  1, { 23446, 31079, }, { 1, 1, }, },
	[40514]  = { nil, 1, 15,  40514,  32508, 340, 340, 355, 370,  1,  1, { 22578, 24478, 24479, }, { 3, 10, 1, }, },
	[31058]  = { nil, 1, 15,  31058,  24087, 345, 355, 365, 375,  1,  1, { 23448, 31079, }, { 2, 4, }, nil, nil, { 24163, }, },
	[31084]  = { nil, 1, 15,  31084,  24027, 350, 350, 365, 380,  1,  1, { 23436, }, { 1, }, nil, nil, { 24193, }, },
	[31085]  = { nil, 1, 15,  31085,  24028, 350, 350, 365, 380,  1,  1, { 23436, }, { 1, }, nil, nil, { 24192, 24194, 35306, }, },
	[31088]  = { nil, 1, 15,  31088,  24030, 350, 350, 365, 380,  1,  1, { 23436, }, { 1, }, nil, nil, { 24195, 24196, 24203, 35305, }, },
	[31090]  = { nil, 1, 15,  31090,  24032, 350, 350, 365, 380,  1,  1, { 23440, }, { 1, }, nil, nil, { 24197, 24207, }, },
	[31091]  = { nil, 1, 15,  31091,  24036, 350, 350, 365, 380,  1,  1, { 23436, }, { 1, }, nil, nil, { 24198, }, },
	[31092]  = { nil, 1, 15,  31092,  24033, 350, 350, 365, 380,  1,  1, { 23438, }, { 1, }, nil, nil, { 24199, 35304, }, },
	[31095]  = { nil, 1, 15,  31095,  24039, 350, 350, 365, 380,  1,  1, { 23438, }, { 1, }, nil, nil, { 24202, }, },
	[31097]  = { nil, 1, 15,  31097,  24048, 350, 350, 365, 380,  1,  1, { 23440, }, { 1, }, nil, nil, { 24204, 24206, }, },
	[31098]  = { nil, 1, 15,  31098,  24051, 350, 350, 365, 380,  1,  1, { 23438, }, { 1, }, nil, nil, { 24205, 31875, 35307, }, },
	[31101]  = { nil, 1, 15,  31101,  24053, 350, 350, 365, 380,  1,  1, { 23440, }, { 1, }, nil, nil, { 24208, }, },
	[31102]  = { nil, 1, 15,  31102,  24054, 350, 350, 365, 380,  1,  1, { 23441, }, { 1, }, nil, nil, { 24209, }, },
	[31103]  = { nil, 1, 15,  31103,  24055, 350, 350, 365, 380,  1,  1, { 23441, }, { 1, }, nil, nil, { 24210, 31876, }, },
	[31104]  = { nil, 1, 15,  31104,  24056, 350, 350, 365, 380,  1,  1, { 23441, }, { 1, }, nil, nil, { 24211, }, },
	[31106]  = { nil, 1, 15,  31106,  24058, 350, 350, 365, 380,  1,  1, { 23439, }, { 1, }, nil, nil, { 24213, }, },
	[31107]  = { nil, 1, 15,  31107,  24059, 350, 350, 365, 380,  1,  1, { 23439, }, { 1, }, nil, nil, { 24214, }, },
	[31108]  = { nil, 1, 15,  31108,  24060, 350, 350, 365, 380,  1,  1, { 23439, }, { 1, }, nil, nil, { 24215, 35323, }, },
	[31109]  = { nil, 1, 15,  31109,  24061, 350, 350, 365, 380,  1,  1, { 23441, }, { 1, }, nil, nil, { 24216, 31877, }, },
	[31111]  = { nil, 1, 15,  31111,  24066, 350, 350, 365, 380,  1,  1, { 23437, }, { 1, }, nil, nil, { 24218, }, },
	[31112]  = { nil, 1, 15,  31112,  24065, 350, 350, 365, 380,  1,  1, { 23441, }, { 1, }, nil, nil, { 24212, 24219, }, },
	[31113]  = { nil, 1, 15,  31113,  24067, 350, 350, 365, 380,  1,  1, { 23437, }, { 1, }, nil, nil, { 24220, }, },
	[31149]  = { nil, 1, 15,  31149,  24035, 350, 350, 365, 380,  1,  1, { 23438, }, { 1, }, nil, nil, { 24200, 24201, }, },
	[39470]  = { nil, 1, 15,  39470,  31867, 350, 350, 365, 380,  1,  1, { 23441, }, { 1, }, nil, nil, { 31878, }, },
	[39471]  = { nil, 1, 15,  39471,  31868, 350, 350, 365, 380,  1,  1, { 23439, }, { 1, }, nil, nil, { 31879, }, },
	[41429]  = { nil, 1, 15,  41429,  32836, 350, 350, 365, 380,  1,  1, { 24479, 27860, }, { 1, 1, }, },
	[43493]  = { nil, 1, 15,  43493,  33782, 350, 350, 365, 380,  1,  1, { 23437, }, { 1, }, nil, nil, { 33783, }, },
	[46403]  = { nil, 1, 15,  46403,  35315, 350, 350, 365, 380,  1,  1, { 23440, }, { 1, }, nil, nil, { 35322, }, },
	[46405]  = { nil, 1, 15,  46405,  35318, 350, 350, 365, 380,  1,  1, { 23437, }, { 1, }, nil, nil, { 35325, }, },
	[46803]  = { nil, 1, 15,  46803,  35707, 350, 350, 365, 380,  1,  1, { 23437, }, { 1, }, nil, nil, { 24217, 35708, }, },
	[47280]  = { nil, 1, 15,  47280, 191061, 350, 350, 365, 380,  1,  1, { 23117, 23077, 23079, 21929, 23112, 23107, }, { 3, 3, 3, 3, 3, 3, }, },
	[31053]  = { nil, 1, 15,  31053,  24079, 350, 360, 370, 380,  1,  1, { 23449, 31079, 22456, }, { 2, 3, 3, }, nil, nil, { 24158, }, },
	[56205]  = { nil, 1, 15,  56205,  41367, 350, 360, 370, 380,  1,  1, { 36932, }, { 1, }, },
	[53831]  = { nil, 1, 15,  53831,  39900, 350, 375, 395, 415,  1,  1, { 36917, }, { 1, }, },
	[53832]  = { nil, 1, 15,  53832,  39905, 350, 375, 395, 415,  1,  1, { 36917, }, { 1, }, },
	[53844]  = { nil, 1, 15,  53844,  39908, 350, 375, 395, 415,  1,  1, { 36917, }, { 1, }, },
	[53845]  = { nil, 1, 15,  53845,  39909, 350, 375, 395, 415,  1,  1, { 36920, }, { 1, }, },
	[53852]  = { nil, 1, 15,  53852,  39912, 350, 375, 395, 415,  1,  1, { 36917, }, { 1, }, },
	[53854]  = { nil, 1, 15,  53854,  39915, 350, 375, 395, 415,  1,  1, { 36923, }, { 1, }, },
	[53856]  = { nil, 1, 15,  53856,  39918, 350, 375, 395, 415,  1,  1, { 36920, }, { 1, }, },
	[53857]  = { nil, 1, 15,  53857,  39917, 350, 375, 395, 415,  1,  1, { 36920, }, { 1, }, nil, nil, { 41559, }, },
	[53859]  = { nil, 1, 15,  53859,  39934, 350, 375, 395, 415,  1,  1, { 36926, }, { 1, }, },
	[53860]  = { nil, 1, 15,  53860,  39935, 350, 375, 395, 415,  1,  1, { 36926, }, { 1, }, },
	[53861]  = { nil, 1, 15,  53861,  39942, 350, 375, 395, 415,  1,  1, { 36926, }, { 1, }, },
	[53865]  = { nil, 1, 15,  53865,  39945, 350, 375, 395, 415,  1,  1, { 36926, }, { 1, }, nil, nil, { 41575, }, },
	[53869]  = { nil, 1, 15,  53869,  39939, 350, 375, 395, 415,  1,  1, { 36926, }, { 1, }, nil, nil, { 41574, }, },
	[53870]  = { nil, 1, 15,  53870,  39933, 350, 375, 395, 415,  1,  1, { 36932, }, { 1, }, },
	[53871]  = { nil, 1, 15,  53871,  39940, 350, 375, 395, 415,  1,  1, { 36926, }, { 1, }, },
	[53872]  = { nil, 1, 15,  53872,  39947, 350, 375, 395, 415,  1,  1, { 36929, }, { 1, }, },
	[53873]  = { nil, 1, 15,  53873,  39948, 350, 375, 395, 415,  1,  1, { 36926, }, { 1, }, },
	[53874]  = { nil, 1, 15,  53874,  39949, 350, 375, 395, 415,  1,  1, { 36929, }, { 1, }, },
	[53875]  = { nil, 1, 15,  53875,  39950, 350, 375, 395, 415,  1,  1, { 36929, }, { 1, }, nil, nil, { 41566, }, },
	[53876]  = { nil, 1, 15,  53876,  39951, 350, 375, 395, 415,  1,  1, { 36929, }, { 1, }, },
	[53877]  = { nil, 1, 15,  53877,  39952, 350, 375, 395, 415,  1,  1, { 36929, }, { 1, }, nil, nil, { 41562, }, },
	[53879]  = { nil, 1, 15,  53879,  39954, 350, 375, 395, 415,  1,  1, { 36929, }, { 1, }, nil, nil, { 41564, 41565, }, },
	[53880]  = { nil, 1, 15,  53880,  39955, 350, 375, 395, 415,  1,  1, { 36929, }, { 1, }, },
	[53882]  = { nil, 1, 15,  53882,  39956, 350, 375, 395, 415,  1,  1, { 36929, }, { 1, }, },
	[53883]  = { nil, 1, 15,  53883,  39957, 350, 375, 395, 415,  1,  1, { 36926, }, { 1, }, },
	[53884]  = { nil, 1, 15,  53884,  39958, 350, 375, 395, 415,  1,  1, { 36929, }, { 1, }, nil, nil, { 41563, }, },
	[53885]  = { nil, 1, 15,  53885,  39959, 350, 375, 395, 415,  1,  1, { 36929, }, { 1, }, nil, nil, { 41561, }, },
	[53892]  = { nil, 1, 15,  53892,  39966, 350, 375, 395, 415,  1,  1, { 36926, }, { 1, }, },
	[53893]  = { nil, 1, 15,  53893,  39967, 350, 375, 395, 415,  1,  1, { 36929, }, { 1, }, },
	[53894]  = { nil, 1, 15,  53894,  39968, 350, 375, 395, 415,  1,  1, { 36926, }, { 1, }, },
	[53917]  = { nil, 1, 15,  53917,  39975, 350, 375, 395, 415,  1,  1, { 36932, }, { 1, }, nil, nil, { 41567, }, },
	[53918]  = { nil, 1, 15,  53918,  39976, 350, 375, 395, 415,  1,  1, { 36932, }, { 1, }, },
	[53919]  = { nil, 1, 15,  53919,  39977, 350, 375, 395, 415,  1,  1, { 36932, }, { 1, }, nil, nil, { 41572, }, },
	[53920]  = { nil, 1, 15,  53920,  39978, 350, 375, 395, 415,  1,  1, { 36932, }, { 1, }, },
	[53921]  = { nil, 1, 15,  53921,  39979, 350, 375, 395, 415,  1,  1, { 36926, }, { 1, }, nil, nil, { 41568, }, },
	[53922]  = { nil, 1, 15,  53922,  39980, 350, 375, 395, 415,  1,  1, { 36932, }, { 1, }, },
	[53923]  = { nil, 1, 15,  53923,  39981, 350, 375, 395, 415,  1,  1, { 36932, }, { 1, }, },
	[53924]  = { nil, 1, 15,  53924,  39982, 350, 375, 395, 415,  1,  1, { 36932, }, { 1, }, nil, nil, { 41571, 41573, }, },
	[53925]  = { nil, 1, 15,  53925,  39983, 350, 375, 395, 415,  1,  1, { 36932, }, { 1, }, },
	[53932]  = { nil, 1, 15,  53932,  39991, 350, 375, 395, 415,  1,  1, { 36932, }, { 1, }, nil, nil, { 41570, }, },
	[53933]  = { nil, 1, 15,  53933,  39992, 350, 375, 395, 415,  1,  1, { 36932, }, { 1, }, nil, nil, { 41569, }, },
	[53934]  = { nil, 1, 15,  53934,  39919, 350, 375, 395, 415,  1,  1, { 36923, }, { 1, }, },
	[53941]  = { nil, 1, 15,  53941,  39927, 350, 375, 395, 415,  1,  1, { 36923, }, { 1, }, },
	[53943]  = { nil, 1, 15,  53943,  39932, 350, 375, 395, 415,  1,  1, { 36923, }, { 1, }, nil, nil, { 41560, }, },
	[54017]  = { nil, 1, 15,  54017,  39910, 350, 375, 395, 415,  1,  1, { 36917, }, { 1, }, },
	[56193]  = { nil, 1, 15,  56193,  42336, 350, 380, 400, 420,  1,  1, { 37701, 36917, }, { 2, 1, }, },
	[56194]  = { nil, 1, 15,  56194,  42337, 350, 380, 400, 420,  1,  1, { 37701, 36920, }, { 2, 1, }, },
	[58141]  = { nil, 1, 15,  58141,  43244, 350, 380, 400, 420,  1,  1, { 37701, 36929, }, { 2, 1, }, },
	[58142]  = { nil, 1, 15,  58142,  43245, 350, 380, 400, 420,  1,  1, { 37701, 36923, }, { 2, 1, }, },
	[31054]  = { nil, 1, 15,  31054,  24080, 355, 365, 372, 380,  1,  1, { 23449, 31079, 21885, }, { 2, 4, 3, }, nil, nil, { 24159, }, },
	[31055]  = { nil, 1, 15,  31055,  24082, 355, 365, 372, 380,  1,  1, { 23449, 31079, 21884, }, { 2, 4, 3, }, nil, nil, { 24160, }, },
	[31060]  = { nil, 1, 15,  31060,  24088, 355, 365, 375, 385,  1,  1, { 23447, 31079, }, { 1, 5, }, nil, nil, { 24164, }, },
	[31067]  = { nil, 1, 15,  31067,  24106, 355, 365, 375, 385,  1,  1, { 23448, 31079, }, { 2, 3, }, nil, nil, { 24166, }, },
	[31068]  = { nil, 1, 15,  31068,  24110, 355, 365, 375, 385,  1,  1, { 23449, 31079, 23436, }, { 4, 1, 1, }, nil, nil, { 24167, }, },
	[42558]  = { nil, 1, 15,  42558,  33133, 360, 365, 370, 375,  1,  1, { 23436, }, { 1, }, nil, nil, { 33305, }, },
	[42588]  = { nil, 1, 15,  42588,  33134, 360, 365, 370, 375,  1,  1, { 23436, }, { 1, }, nil, nil, { 33155, }, },
	[42589]  = { nil, 1, 15,  42589,  33131, 360, 365, 370, 375,  1,  1, { 23436, }, { 1, }, nil, nil, { 33156, }, },
	[42590]  = { nil, 1, 15,  42590,  33135, 360, 365, 370, 375,  1,  1, { 23438, }, { 1, }, nil, nil, { 33157, }, },
	[42591]  = { nil, 1, 15,  42591,  33143, 360, 365, 370, 375,  1,  1, { 23440, }, { 1, }, nil, nil, { 33158, }, },
	[42592]  = { nil, 1, 15,  42592,  33140, 360, 365, 370, 375,  1,  1, { 23440, }, { 1, }, nil, nil, { 33159, }, },
	[42593]  = { nil, 1, 15,  42593,  33144, 360, 365, 370, 375,  1,  1, { 23440, }, { 1, }, nil, nil, { 33160, }, },
	[31056]  = { nil, 1, 15,  31056,  24085, 360, 370, 375, 380,  1,  1, { 23449, 31079, 21886, }, { 2, 4, 3, }, nil, nil, { 24161, }, },
	[31062]  = { nil, 1, 15,  31062,  24092, 360, 370, 375, 380,  1,  1, { 23448, 21885, 21884, 31079, }, { 2, 6, 4, 1, }, nil, nil, { 24174, }, },
	[31063]  = { nil, 1, 15,  31063,  24093, 360, 370, 375, 380,  1,  1, { 23448, 21884, 21885, 31079, }, { 2, 6, 4, 1, }, nil, nil, { 24175, }, },
	[31064]  = { nil, 1, 15,  31064,  24095, 360, 370, 375, 380,  1,  1, { 23448, 22456, 21886, 31079, }, { 2, 6, 4, 1, }, nil, nil, { 24176, }, },
	[31065]  = { nil, 1, 15,  31065,  24097, 360, 370, 375, 380,  1,  1, { 23448, 21886, 22456, 31079, }, { 2, 6, 4, 1, }, nil, nil, { 24177, }, },
	[31066]  = { nil, 1, 15,  31066,  24098, 360, 370, 375, 380,  1,  1, { 23448, 22457, 31079, }, { 2, 8, 1, }, nil, nil, { 24178, }, },
	[31071]  = { nil, 1, 15,  31071,  24116, 360, 370, 375, 380,  1,  1, { 23573, 31079, 23441, }, { 2, 2, 1, }, nil, nil, { 24169, }, },
	[37855]  = { nil, 1, 15,  37855,  30825, 360, 370, 375, 380,  1,  1, { 23447, 22457, }, { 2, 8, }, nil, nil, { 30826, }, },
	[31070]  = { nil, 1, 15,  31070,  24114, 360, 370, 377, 385,  1,  1, { 23447, 31079, }, { 2, 3, }, nil, nil, { 24168, }, },
	[56206]  = { nil, 1, 15,  56206,  42420, 360, 370, 380, 390,  1,  1, { 36926, }, { 1, }, },
	[53843]  = { nil, 1, 15,  53843,  39907, 360, 375, 395, 415,  1,  1, { 36920, }, { 1, }, },
	[53891]  = { nil, 1, 15,  53891,  39965, 360, 375, 395, 415,  1,  1, { 36929, }, { 1, }, },
	[56530]  = { nil, 1, 15,  56530,  42701, 360, 380, 400, 420,  1,  1, { 36783, 34054, }, { 1, 1, }, },
	[31057]  = { nil, 1, 15,  31057,  24086, 365, 370, 375, 380,  1,  1, { 23449, 31079, 22457, }, { 2, 4, 3, }, nil, nil, { 24162, }, },
	[31061]  = { nil, 1, 15,  31061,  24089, 365, 375, 377, 380,  1,  1, { 23447, 31079, 21884, }, { 2, 4, 4, }, nil, nil, { 24165, }, },
	[32866]  = { nil, 1, 15,  32866,  25896, 365, 375, 377, 380,  1,  1, { 25867, }, { 1, }, nil, nil, { 25902, }, },
	[32867]  = { nil, 1, 15,  32867,  25897, 365, 375, 377, 380,  1,  1, { 25867, }, { 1, }, nil, nil, { 25903, }, },
	[32868]  = { nil, 1, 15,  32868,  25898, 365, 375, 377, 380,  1,  1, { 25867, }, { 1, }, nil, nil, { 25905, }, },
	[32869]  = { nil, 1, 15,  32869,  25899, 365, 375, 377, 380,  1,  1, { 25867, }, { 1, }, nil, nil, { 25906, }, },
	[32870]  = { nil, 1, 15,  32870,  25901, 365, 375, 377, 380,  1,  1, { 25867, }, { 1, }, nil, nil, { 25904, }, },
	[32871]  = { nil, 1, 15,  32871,  25890, 365, 375, 377, 380,  1,  1, { 25868, }, { 1, }, nil, nil, { 25907, }, },
	[32872]  = { nil, 1, 15,  32872,  25893, 365, 375, 377, 380,  1,  1, { 25868, }, { 1, }, nil, nil, { 25909, }, },
	[32873]  = { nil, 1, 15,  32873,  25894, 365, 375, 377, 380,  1,  1, { 25868, }, { 1, }, nil, nil, { 25908, }, },
	[32874]  = { nil, 1, 15,  32874,  25895, 365, 375, 377, 380,  1,  1, { 25868, }, { 1, }, nil, nil, { 25910, }, },
	[39961]  = { nil, 1, 15,  39961,  32409, 365, 375, 377, 380,  1,  1, { 25867, }, { 1, }, nil, nil, { 32412, 33622, }, },
	[39963]  = { nil, 1, 15,  39963,  32410, 365, 375, 377, 380,  1,  1, { 25868, }, { 1, }, nil, nil, { 32411, }, },
	[44794]  = { nil, 1, 15,  44794,  34220, 365, 375, 377, 380,  1,  1, { 25868, }, { 1, }, nil, nil, { 34221, 34689, }, },
	[31072]  = { nil, 1, 15,  31072,  24117, 365, 375, 380, 385,  1,  1, { 23447, 31079, 23112, }, { 2, 4, 2, }, nil, nil, { 24170, }, },
	[31076]  = { nil, 1, 15,  31076,  24121, 365, 375, 380, 385,  1,  1, { 23449, 31079, 23117, }, { 2, 4, 2, }, nil, nil, { 24171, }, },
	[41418]  = { nil, 1, 15,  41418,  32776, 365, 375, 380, 385,  1,  1, { 23449, 31079, 24478, 24479, }, { 12, 4, 20, 3, }, },
	[46122]  = { nil, 1, 15,  46122,  34362, 365, 375, 380, 385,  1,  1, { 35128, 23571, 31079, 34664, }, { 4, 4, 12, 5, }, nil, nil, { 35198, 35536, }, },
	[46123]  = { nil, 1, 15,  46123,  34363, 365, 375, 380, 385,  1,  1, { 35128, 21886, 31079, 34664, }, { 4, 20, 12, 5, }, nil, nil, { 35199, 35538, }, },
	[46124]  = { nil, 1, 15,  46124,  34361, 365, 375, 380, 385,  1,  1, { 35128, 22451, 31079, 34664, }, { 4, 20, 12, 5, }, nil, nil, { 35200, 35534, }, },
	[46125]  = { nil, 1, 15,  46125,  34359, 365, 375, 380, 385,  1,  1, { 31079, 32227, 32228, }, { 12, 3, 3, }, nil, nil, { 35201, 35537, }, },
	[46126]  = { nil, 1, 15,  46126,  34360, 365, 375, 380, 385,  1,  1, { 31079, 32249, }, { 6, 6, }, nil, nil, { 35202, 35533, }, },
	[46127]  = { nil, 1, 15,  46127,  34358, 365, 375, 380, 385,  1,  1, { 35128, 23572, }, { 6, 9, }, nil, nil, { 35203, 35535, }, },
	[46597]  = { nil, 1, 15,  46597,  35501, 370, 375, 377, 380,  1,  1, { 25867, }, { 1, }, nil, nil, { 35502, }, },
	[46601]  = { nil, 1, 15,  46601,  35503, 370, 375, 377, 380,  1,  1, { 25868, }, { 1, }, nil, nil, { 35505, }, },
	[31077]  = { nil, 1, 15,  31077,  24122, 370, 375, 380, 385,  1,  1, { 23449, 21886, 23437, 31079, }, { 20, 20, 2, 5, }, nil, nil, { 24172, }, },
	[31078]  = { nil, 1, 15,  31078,  24123, 370, 375, 380, 385,  1,  1, { 23448, 22457, 23438, 31079, }, { 20, 20, 2, 5, }, nil, nil, { 24173, }, },
	[31079]  = { nil, 1, 15,  31079,  24124, 370, 375, 380, 385,  1,  1, { 23448, 23077, 22452, }, { 8, 2, 4, }, nil, nil, { 24179, }, },
	[31080]  = { nil, 1, 15,  31080,  24125, 370, 375, 380, 385,  1,  1, { 23449, 23440, 23112, }, { 4, 2, 4, }, nil, nil, { 24180, 31358, }, },
	[31081]  = { nil, 1, 15,  31081,  24126, 370, 375, 380, 385,  1,  1, { 23448, 23436, 21884, }, { 2, 2, 4, }, nil, nil, { 24181, }, },
	[31082]  = { nil, 1, 15,  31082,  24127, 370, 375, 380, 385,  1,  1, { 23447, 23437, 22457, }, { 2, 2, 4, }, nil, nil, { 24182, }, },
	[31083]  = { nil, 1, 15,  31083,  24128, 370, 375, 380, 385,  1,  1, { 23573, 23441, 22456, }, { 6, 2, 2, }, nil, nil, { 24183, }, },
	[56208]  = { nil, 1, 15,  56208,  42421, 370, 380, 390, 400,  1,  1, { 36926, 36932, }, { 1, 1, }, },
	[58143]  = { nil, 1, 15,  58143,  43246, 370, 390, 405, 420,  1,  1, { 35624, 36926, }, { 1, 2, }, },
	[58144]  = { nil, 1, 15,  58144,  43247, 370, 390, 405, 420,  1,  1, { 35624, 36932, }, { 1, 2, }, },
	[56049]  = { nil, 1, 15,  56049,  42142, 370, 390, 415, 440,  1,  1, { 42225, }, { 1, }, nil, nil, { 42298, }, },
	[56052]  = { nil, 1, 15,  56052,  42143, 370, 390, 415, 440,  1,  1, { 42225, }, { 1, }, nil, nil, { 42299, 42301, }, },
	[56053]  = { nil, 1, 15,  56053,  42144, 370, 390, 415, 440,  1,  1, { 42225, }, { 1, }, nil, nil, { 42300, 42309, }, },
	[56055]  = { nil, 1, 15,  56055,  42151, 370, 390, 415, 440,  1,  1, { 42225, }, { 1, }, nil, nil, { 42314, 42315, }, },
	[56056]  = { nil, 1, 15,  56056,  42152, 370, 390, 415, 440,  1,  1, { 42225, }, { 1, }, nil, nil, { 42302, }, },
	[56079]  = { nil, 1, 15,  56079,  42158, 370, 390, 415, 440,  1,  1, { 42225, }, { 1, }, nil, nil, { 42305, }, },
	[56081]  = { nil, 1, 15,  56081,  42154, 370, 390, 415, 440,  1,  1, { 42225, }, { 1, }, nil, nil, { 42306, }, },
	[56083]  = { nil, 1, 15,  56083,  42150, 370, 390, 415, 440,  1,  1, { 42225, }, { 1, }, nil, nil, { 42307, }, },
	[56084]  = { nil, 1, 15,  56084,  42156, 370, 390, 415, 440,  1,  1, { 42225, }, { 1, }, nil, nil, { 42308, }, },
	[56085]  = { nil, 1, 15,  56085,  42149, 370, 390, 415, 440,  1,  1, { 42225, }, { 1, }, nil, nil, { 42303, 42310, }, },
	[56086]  = { nil, 1, 15,  56086,  36767, 370, 390, 415, 440,  1,  1, { 42225, }, { 1, }, nil, nil, { 42311, }, },
	[56087]  = { nil, 1, 15,  56087,  42145, 370, 390, 415, 440,  1,  1, { 42225, }, { 1, }, nil, nil, { 42304, 42312, }, },
	[56088]  = { nil, 1, 15,  56088,  42155, 370, 390, 415, 440,  1,  1, { 42225, }, { 1, }, nil, nil, { 42313, }, },
	[38503]  = { nil, 1, 15,  38503,  31398, 375, 375, 380, 385,  1,  1, { 31079, 23449, 21885, 21884, }, { 4, 2, 6, 6, }, nil, nil, { 31401, }, },
	[38504]  = { nil, 1, 15,  38504,  31399, 375, 375, 380, 385,  1,  1, { 31079, 23448, 21886, 22456, }, { 4, 2, 6, 6, }, nil, nil, { 31402, }, },
	[39705]  = { nil, 1, 15,  39705,  32193, 375, 375, 380, 385,  1,  1, { 32227, }, { 1, }, nil, nil, { 32274, 35244, }, },
	[39706]  = { nil, 1, 15,  39706,  32194, 375, 375, 380, 385,  1,  1, { 32227, }, { 1, }, nil, nil, { 32277, 32283, 35245, 35246, }, },
	[39711]  = { nil, 1, 15,  39711,  32196, 375, 375, 380, 385,  1,  1, { 32227, }, { 1, }, nil, nil, { 32281, 32282, 32290, 35248, 35250, 35255, }, },
	[39713]  = { nil, 1, 15,  39713,  32198, 375, 375, 380, 385,  1,  1, { 32229, }, { 1, }, nil, nil, { 32284, 32294, 35249, 35261, }, },
	[39714]  = { nil, 1, 15,  39714,  32199, 375, 375, 380, 385,  1,  1, { 32227, }, { 1, }, nil, nil, { 32285, 35247, }, },
	[39715]  = { nil, 1, 15,  39715,  32200, 375, 375, 380, 385,  1,  1, { 32228, }, { 1, }, nil, nil, { 32286, 35263, }, },
	[39716]  = { nil, 1, 15,  39716,  32201, 375, 375, 380, 385,  1,  1, { 32228, }, { 1, }, nil, nil, { 32287, 32288, 35262, 35264, }, },
	[39718]  = { nil, 1, 15,  39718,  32203, 375, 375, 380, 385,  1,  1, { 32228, }, { 1, }, nil, nil, { 32289, 35265, }, },
	[39720]  = { nil, 1, 15,  39720,  32205, 375, 375, 380, 385,  1,  1, { 32229, }, { 1, }, nil, nil, { 32291, 32293, 35256, 35260, }, },
	[39721]  = { nil, 1, 15,  39721,  32206, 375, 375, 380, 385,  1,  1, { 32228, }, { 1, }, nil, nil, { 32292, 32296, 35257, 35259, }, },
	[39724]  = { nil, 1, 15,  39724,  32209, 375, 375, 380, 385,  1,  1, { 32229, }, { 1, }, nil, nil, { 32295, 35258, }, },
	[39727]  = { nil, 1, 15,  39727,  32211, 375, 375, 380, 385,  1,  1, { 32230, }, { 1, }, nil, nil, { 32297, 35243, }, },
	[39728]  = { nil, 1, 15,  39728,  32212, 375, 375, 380, 385,  1,  1, { 32230, }, { 1, }, nil, nil, { 32298, 32299, 35238, 35242, }, },
	[39731]  = { nil, 1, 15,  39731,  32215, 375, 375, 380, 385,  1,  1, { 32230, }, { 1, }, nil, nil, { 32301, 35239, }, },
	[39733]  = { nil, 1, 15,  39733,  32217, 375, 375, 380, 385,  1,  1, { 32231, }, { 1, }, nil, nil, { 32303, 35267, }, },
	[39734]  = { nil, 1, 15,  39734,  32218, 375, 375, 380, 385,  1,  1, { 32231, }, { 1, }, nil, nil, { 32304, 35269, }, },
	[39736]  = { nil, 1, 15,  39736,  32220, 375, 375, 380, 385,  1,  1, { 32230, }, { 1, }, nil, nil, { 32306, 32300, 35240, 35266, }, },
	[39737]  = { nil, 1, 15,  39737,  32221, 375, 375, 380, 385,  1,  1, { 32230, }, { 1, }, nil, nil, { 32307, 35270, }, },
	[39738]  = { nil, 1, 15,  39738,  32222, 375, 375, 380, 385,  1,  1, { 32231, }, { 1, }, nil, nil, { 32308, 35271, }, },
	[39739]  = { nil, 1, 15,  39739,  32223, 375, 375, 380, 385,  1,  1, { 32249, }, { 1, }, nil, nil, { 32309, 35252, }, },
	[39740]  = { nil, 1, 15,  39740,  32224, 375, 375, 380, 385,  1,  1, { 32249, }, { 1, }, nil, nil, { 32310, 35254, }, },
	[39741]  = { nil, 1, 15,  39741,  32225, 375, 375, 380, 385,  1,  1, { 32230, }, { 1, }, nil, nil, { 32311, 32302, 37504, 35241, 35251, }, },
	[39742]  = { nil, 1, 15,  39742,  32226, 375, 375, 380, 385,  1,  1, { 32249, }, { 1, }, nil, nil, { 32312, 35253, }, },
	[46775]  = { nil, 1, 15,  46775,  35693, 375, 375, 380, 385,  1,  1, { 23449, 32228, 23440, }, { 8, 2, 6, }, nil, nil, { 35695, }, },
	[46776]  = { nil, 1, 15,  46776,  35694, 375, 375, 380, 385,  1,  1, { 23449, 32231, 22452, }, { 8, 2, 8, }, nil, nil, { 35696, }, },
	[46777]  = { nil, 1, 15,  46777,  35700, 375, 375, 380, 385,  1,  1, { 23447, 32227, 21884, }, { 8, 2, 8, }, nil, nil, { 35697, }, },
	[46778]  = { nil, 1, 15,  46778,  35702, 375, 375, 380, 385,  1,  1, { 23573, 32230, 22456, }, { 4, 2, 8, }, nil, nil, { 35698, }, },
	[46779]  = { nil, 1, 15,  46779,  35703, 375, 375, 380, 385,  1,  1, { 23447, 32249, 22457, }, { 8, 2, 8, }, nil, nil, { 35699, }, },
	[47053]  = { nil, 1, 15,  47053,  35759, 375, 375, 380, 385,  1,  1, { 32249, }, { 1, }, nil, nil, { 35765, 35769, }, },
	[47054]  = { nil, 1, 15,  47054,  35758, 375, 375, 380, 385,  1,  1, { 32249, }, { 1, }, nil, nil, { 35764, 35766, }, },
	[47055]  = { nil, 1, 15,  47055,  35760, 375, 375, 380, 385,  1,  1, { 32231, }, { 1, }, nil, nil, { 32305, 35268, 35762, 35767, }, },
	[47056]  = { nil, 1, 15,  47056,  35761, 375, 375, 380, 385,  1,  1, { 32229, }, { 1, }, nil, nil, { 35763, 35768, }, },
	[56195]  = { nil, 1, 15,  56195,  42338, 380, 400, 410, 420,  1,  1, { 35624, 36929, 36932, }, { 1, 2, 2, }, },
	[56196]  = { nil, 1, 15,  56196,  42339, 380, 400, 410, 420,  1,  1, { 35624, 36917, 36920, 36923, }, { 1, 1, 2, 1, }, },
	[58145]  = { nil, 1, 15,  58145,  43248, 390, 410, 420, 430,  1,  1, { 35624, }, { 2, }, },
	[58146]  = { nil, 1, 15,  58146,  43249, 390, 410, 420, 430,  1,  1, { 35624, 35627, }, { 1, 1, }, },
	[53830]  = { nil, 1, 15,  53830,  39996, 390, 410, 425, 440,  1,  1, { 36918, }, { 1, }, nil, nil, { 41576, }, },
	[53945]  = { nil, 1, 15,  53945,  39997, 390, 410, 425, 440,  1,  1, { 36918, }, { 1, }, nil, nil, { 41577, }, },
	[53946]  = { nil, 1, 15,  53946,  39998, 390, 410, 425, 440,  1,  1, { 36918, }, { 1, }, nil, nil, { 41718, 47011, }, },
	[53948]  = { nil, 1, 15,  53948,  40000, 390, 410, 425, 440,  1,  1, { 36921, }, { 1, }, nil, nil, { 41719, 41791, }, },
	[53949]  = { nil, 1, 15,  53949,  40001, 390, 410, 425, 440,  1,  1, { 36918, }, { 1, }, nil, nil, { 41578, }, },
	[53951]  = { nil, 1, 15,  53951,  40003, 390, 410, 425, 440,  1,  1, { 36918, }, { 1, }, nil, nil, { 41790, }, },
	[53952]  = { nil, 1, 15,  53952,  40008, 390, 410, 425, 440,  1,  1, { 36924, }, { 1, }, nil, nil, { 42138, }, },
	[53954]  = { nil, 1, 15,  53954,  40010, 390, 410, 425, 440,  1,  1, { 36924, }, { 1, }, nil, nil, { 41581, }, },
	[53955]  = { nil, 1, 15,  53955,  40011, 390, 410, 425, 440,  1,  1, { 36924, }, { 1, }, nil, nil, { 41728, }, },
	[53957]  = { nil, 1, 15,  53957,  40013, 390, 410, 425, 440,  1,  1, { 36921, }, { 1, }, nil, nil, { 41720, 41817, }, },
	[53958]  = { nil, 1, 15,  53958,  40014, 390, 410, 425, 440,  1,  1, { 36924, }, { 1, }, nil, nil, { 41580, }, },
	[53960]  = { nil, 1, 15,  53960,  40016, 390, 410, 425, 440,  1,  1, { 36921, }, { 1, }, nil, nil, { 41727, }, },
	[53961]  = { nil, 1, 15,  53961,  40017, 390, 410, 425, 440,  1,  1, { 36921, }, { 1, }, nil, nil, { 41579, }, },
	[53962]  = { nil, 1, 15,  53962,  40022, 390, 410, 425, 440,  1,  1, { 36927, }, { 1, }, nil, nil, { 41784, }, },
	[53963]  = { nil, 1, 15,  53963,  40023, 390, 410, 425, 440,  1,  1, { 36927, }, { 1, }, nil, nil, { 41747, }, },
	[53965]  = { nil, 1, 15,  53965,  40025, 390, 410, 425, 440,  1,  1, { 36927, }, { 1, }, nil, nil, { 41795, 41725, }, },
	[53966]  = { nil, 1, 15,  53966,  40026, 390, 410, 425, 440,  1,  1, { 36927, }, { 1, }, nil, nil, { 41699, 41701, 41783, }, },
	[53968]  = { nil, 1, 15,  53968,  40028, 390, 410, 425, 440,  1,  1, { 36927, }, { 1, }, nil, nil, { 41740, }, },
	[53972]  = { nil, 1, 15,  53972,  40032, 390, 410, 425, 440,  1,  1, { 36927, }, { 1, }, nil, nil, { 41820, }, },
	[53974]  = { nil, 1, 15,  53974,  40034, 390, 410, 425, 440,  1,  1, { 36927, }, { 1, }, nil, nil, { 41726, }, },
	[53975]  = { nil, 1, 15,  53975,  40037, 390, 410, 425, 440,  1,  1, { 36930, }, { 1, }, nil, nil, { 41789, }, },
	[53976]  = { nil, 1, 15,  53976,  40038, 390, 410, 425, 440,  1,  1, { 36927, }, { 1, }, nil, nil, { 41777, }, },
	[53977]  = { nil, 1, 15,  53977,  40039, 390, 410, 425, 440,  1,  1, { 36930, }, { 1, }, nil, nil, { 41780, }, },
	[53978]  = { nil, 1, 15,  53978,  40040, 390, 410, 425, 440,  1,  1, { 36930, }, { 1, }, nil, nil, { 41734, }, },
	[53980]  = { nil, 1, 15,  53980,  40044, 390, 410, 425, 440,  1,  1, { 36927, }, { 1, }, nil, nil, { 41785, 41796, 41582, }, },
	[53981]  = { nil, 1, 15,  53981,  40045, 390, 410, 425, 440,  1,  1, { 36930, }, { 1, }, nil, nil, { 41732, 41733, 46906, }, },
	[53984]  = { nil, 1, 15,  53984,  40048, 390, 410, 425, 440,  1,  1, { 36930, }, { 1, }, nil, nil, { 41686, }, },
	[53985]  = { nil, 1, 15,  53985,  40049, 390, 410, 425, 440,  1,  1, { 36927, }, { 1, }, nil, nil, { 41688, }, },
	[53986]  = { nil, 1, 15,  53986,  40050, 390, 410, 425, 440,  1,  1, { 36930, }, { 1, }, nil, nil, { 41730, }, },
	[53987]  = { nil, 1, 15,  53987,  40051, 390, 410, 425, 440,  1,  1, { 36930, }, { 1, }, nil, nil, { 41690, 41689, }, },
	[53988]  = { nil, 1, 15,  53988,  40052, 390, 410, 425, 440,  1,  1, { 36930, }, { 1, }, nil, nil, { 41794, 41721, }, },
	[53991]  = { nil, 1, 15,  53991,  40055, 390, 410, 425, 440,  1,  1, { 36930, }, { 1, }, nil, nil, { 41792, 41687, }, },
	[53993]  = { nil, 1, 15,  53993,  40057, 390, 410, 425, 440,  1,  1, { 36930, }, { 1, }, nil, nil, { 41779, 41722, }, },
	[53994]  = { nil, 1, 15,  53994,  40058, 390, 410, 425, 440,  1,  1, { 36927, }, { 1, }, nil, nil, { 41818, }, },
	[53996]  = { nil, 1, 15,  53996,  40086, 390, 410, 425, 440,  1,  1, { 36933, }, { 1, }, nil, nil, { 41702, 41723, }, },
	[53997]  = { nil, 1, 15,  53997,  40088, 390, 410, 425, 440,  1,  1, { 36933, }, { 1, }, nil, nil, { 41698, }, },
	[53998]  = { nil, 1, 15,  53998,  40089, 390, 410, 425, 440,  1,  1, { 36933, }, { 1, }, nil, nil, { 41697, 41703, }, },
	[54000]  = { nil, 1, 15,  54000,  40090, 390, 410, 425, 440,  1,  1, { 36933, }, { 1, }, nil, nil, { 41738, }, },
	[54001]  = { nil, 1, 15,  54001,  40091, 390, 410, 425, 440,  1,  1, { 36933, }, { 1, }, nil, nil, { 41693, }, },
	[54003]  = { nil, 1, 15,  54003,  40095, 390, 410, 425, 440,  1,  1, { 36933, }, { 1, }, nil, nil, { 41781, 41724, }, },
	[54005]  = { nil, 1, 15,  54005,  40102, 390, 410, 425, 440,  1,  1, { 36933, }, { 1, }, nil, nil, { 41737, 41739, }, },
	[54009]  = { nil, 1, 15,  54009,  40100, 390, 410, 425, 440,  1,  1, { 36933, }, { 1, }, nil, nil, { 41696, 41782, }, },
	[54011]  = { nil, 1, 15,  54011,  40105, 390, 410, 425, 440,  1,  1, { 36933, }, { 1, }, nil, nil, { 41692, 41694, }, },
	[54012]  = { nil, 1, 15,  54012,  40098, 390, 410, 425, 440,  1,  1, { 36933, }, { 1, }, nil, nil, { 41736, 41819, }, },
	[54014]  = { nil, 1, 15,  54014,  40106, 390, 410, 425, 440,  1,  1, { 36933, }, { 1, }, nil, nil, { 41735, }, },
	[54019]  = { nil, 1, 15,  54019,  40041, 390, 410, 425, 440,  1,  1, { 36930, }, { 1, }, nil, nil, { 41793, }, },
	[54023]  = { nil, 1, 15,  54023,  40059, 390, 410, 425, 440,  1,  1, { 36930, }, { 1, }, nil, nil, { 41778, }, },
	[56531]  = { nil, 1, 15,  56531,  42702, 390, 410, 425, 440,  1,  1, { 36784, 34054, }, { 1, 4, }, },
	[56199]  = { nil, 1, 15,  56199,  42341, 400, 430, 440, 450,  1,  1, { 41163, 36918, 36921, }, { 2, 2, 1, }, },
	[56201]  = { nil, 1, 15,  56201,  42395, 400, 430, 440, 450,  1,  1, { 41163, 36927, 36930, }, { 2, 2, 1, }, },
	[56202]  = { nil, 1, 15,  56202,  42413, 400, 430, 440, 450,  1,  1, { 41163, 36924, 36933, }, { 2, 2, 1, }, },
	[56203]  = { nil, 1, 15,  56203,  42418, 400, 430, 440, 450,  1,  1, { 41163, 36933, 36918, }, { 2, 2, 1, }, },
	[59759]  = { nil, 1, 15,  59759,  44063, 400, 430, 440, 450,  1,  1, { 41163, 36930, 36933, }, { 2, 2, 1, }, },
	[55384]  = { nil, 1, 15,  55384,  41377, 420, 440, 450, 460,  1,  1, { 41266, }, { 1, }, nil, nil, { 41705, }, },
	[55386]  = { nil, 1, 15,  55386,  41375, 420, 440, 450, 460,  1,  1, { 41266, }, { 1, }, },
	[55387]  = { nil, 1, 15,  55387,  41378, 420, 440, 450, 460,  1,  1, { 41266, }, { 1, }, nil, nil, { 41743, }, },
	[55388]  = { nil, 1, 15,  55388,  41379, 420, 440, 450, 460,  1,  1, { 41266, }, { 1, }, nil, nil, { 41744, }, },
	[55389]  = { nil, 1, 15,  55389,  41285, 420, 440, 450, 460,  1,  1, { 41266, }, { 1, }, nil, nil, { 41704, }, },
	[55390]  = { nil, 1, 15,  55390,  41307, 420, 440, 450, 460,  1,  1, { 41266, }, { 1, }, nil, nil, { 41786, }, },
	[55392]  = { nil, 1, 15,  55392,  41333, 420, 440, 450, 460,  1,  1, { 41266, }, { 1, }, nil, nil, { 41706, }, },
	[55393]  = { nil, 1, 15,  55393,  41335, 420, 440, 450, 460,  1,  1, { 41266, }, { 1, }, nil, nil, { 41742, }, },
	[55394]  = { nil, 1, 15,  55394,  41339, 420, 440, 450, 460,  1,  1, { 41266, }, { 1, }, },
	[55395]  = { nil, 1, 15,  55395,  41400, 420, 440, 450, 460,  1,  1, { 41266, }, { 1, }, nil, nil, { 41787, }, },
	[55396]  = { nil, 1, 15,  55396,  41401, 420, 440, 450, 460,  1,  1, { 41334, }, { 1, }, nil, nil, { 41708, }, },
	[55397]  = { nil, 1, 15,  55397,  41395, 420, 440, 450, 460,  1,  1, { 41334, }, { 1, }, nil, nil, { 41798, }, },
	[55398]  = { nil, 1, 15,  55398,  41396, 420, 440, 450, 460,  1,  1, { 41334, }, { 1, }, nil, nil, { 41799, }, },
	[55399]  = { nil, 1, 15,  55399,  41397, 420, 440, 450, 460,  1,  1, { 41334, }, { 1, }, },
	[55400]  = { nil, 1, 15,  55400,  41398, 420, 440, 450, 460,  1,  1, { 41334, }, { 1, }, nil, nil, { 41710, }, },
	[55401]  = { nil, 1, 15,  55401,  41380, 420, 440, 450, 460,  1,  1, { 41334, }, { 1, }, nil, nil, { 41797, }, },
	[55402]  = { nil, 1, 15,  55402,  41381, 420, 440, 450, 460,  1,  1, { 41334, }, { 1, }, },
	[55403]  = { nil, 1, 15,  55403,  41382, 420, 440, 450, 460,  1,  1, { 41334, }, { 1, }, nil, nil, { 41711, }, },
	[55404]  = { nil, 1, 15,  55404,  41385, 420, 440, 450, 460,  1,  1, { 41334, }, { 1, }, nil, nil, { 41709, }, },
	[55405]  = { nil, 1, 15,  55405,  41389, 420, 440, 450, 460,  1,  1, { 41334, }, { 1, }, nil, nil, { 41788, }, },
	[55407]  = { nil, 1, 15,  55407,  41376, 420, 440, 450, 460,  1,  1, { 41266, }, { 1, }, nil, nil, { 41707, }, },
	[56197]  = { nil, 1, 15,  56197,  42340, 420, 440, 450, 460,  1,  1, { 41163, 36933, 34052, }, { 1, 1, 1, }, },
	[58147]  = { nil, 1, 15,  58147,  43250, 420, 440, 450, 460,  1,  1, { 41163, 35624, }, { 2, 2, }, nil, nil, { 43317, }, },
	[58148]  = { nil, 1, 15,  58148,  43251, 420, 440, 450, 460,  1,  1, { 41163, 35627, 36918, }, { 2, 3, 1, }, nil, nil, { 43318, }, },
	[58149]  = { nil, 1, 15,  58149,  43252, 420, 440, 450, 460,  1,  1, { 41163, 35623, 36860, }, { 2, 1, 2, }, nil, nil, { 43319, }, },
	[58150]  = { nil, 1, 15,  58150,  43253, 420, 440, 450, 460,  1,  1, { 41163, 35622, 36783, }, { 2, 1, 4, }, nil, nil, { 43320, }, },
	[58492]  = { nil, 1, 15,  58492,  43482, 420, 440, 450, 460,  1,  1, { 41163, 36860, }, { 4, 4, }, nil, nil, { 43485, }, },
	[58507]  = { nil, 1, 15,  58507,  43498, 420, 440, 450, 460,  1,  1, { 41163, 36860, }, { 4, 4, }, nil, nil, { 43497, }, },
	[58954]  = { nil, 1, 15,  58954,  43582, 420, 440, 450, 460,  1,  1, { 41163, 35622, 36860, 43102, }, { 2, 3, 3, 1, }, nil, nil, { 43597, }, },
	[64725]  = { nil, 1, 15,  64725,  45812, 420, 440, 450, 460,  1,  1, { 41163, 36933, }, { 1, 3, }, },
	[64726]  = { nil, 1, 15,  64726,  45813, 420, 440, 450, 460,  1,  1, { 41163, 36924, }, { 2, 2, }, },
	[64727]  = { nil, 1, 15,  64727,  45808, 420, 440, 450, 460,  1,  1, { 41163, 36927, }, { 2, 2, }, },
	[64728]  = { nil, 1, 15,  64728,  45809, 420, 440, 450, 460,  1,  1, { 41163, 36918, }, { 2, 1, }, },
	[62242]  = { nil, 1, 15,  62242,  44943, 425, 445, 457, 470,  1,  1, { 43102, 36923, 36926, 36932, }, { 1, 1, 1, 1, }, },
	[73224]  = { nil, 1, 15,  73224,  52083, 425, 450, 467, 485,  1,  1, { 52177, }, { 1, }, nil, nil, { 52363, }, },
	[73229]  = { nil, 1, 15,  73229,  52088, 425, 450, 467, 485,  1,  1, { 52178, }, { 1, }, nil, nil, { 52364, }, },
	[73231]  = { nil, 1, 15,  73231,  52090, 425, 450, 467, 485,  1,  1, { 52179, }, { 1, }, nil, nil, { 52365, }, },
	[73242]  = { nil, 1, 15,  73242,  52097, 425, 450, 467, 485,  1,  1, { 52180, }, { 1, }, nil, nil, { 52366, }, },
	[73244]  = { nil, 1, 15,  73244,  52099, 425, 450, 467, 485,  1,  1, { 52180, }, { 1, }, nil, nil, { 52367, }, },
	[73245]  = { nil, 1, 15,  73245,  52100, 425, 450, 467, 485,  1,  1, { 52180, }, { 1, }, nil, nil, { 52368, }, },
	[73248]  = { nil, 1, 15,  73248,  52103, 425, 450, 467, 485,  1,  1, { 52180, }, { 1, }, nil, nil, { 52369, }, },
	[73258]  = { nil, 1, 15,  73258,  52106, 425, 450, 467, 485,  1,  1, { 52181, }, { 1, }, nil, nil, { 52370, }, },
	[73260]  = { nil, 1, 15,  73260,  52108, 425, 450, 467, 485,  1,  1, { 52181, }, { 1, }, nil, nil, { 52371, }, },
	[73262]  = { nil, 1, 15,  73262,  52109, 425, 450, 467, 485,  1,  1, { 52181, }, { 1, }, nil, nil, { 52372, }, },
	[73263]  = { nil, 1, 15,  73263,  52110, 425, 450, 467, 485,  1,  1, { 52181, }, { 1, }, nil, nil, { 52373, }, },
	[73264]  = { nil, 1, 15,  73264,  52111, 425, 450, 467, 485,  1,  1, { 52181, }, { 1, }, nil, nil, { 52374, }, },
	[73265]  = { nil, 1, 15,  73265,  52112, 425, 450, 467, 485,  1,  1, { 52181, }, { 1, }, nil, nil, { 52375, }, },
	[73266]  = { nil, 1, 15,  73266,  52113, 425, 450, 467, 485,  1,  1, { 52181, }, { 1, }, nil, nil, { 69820, }, },
	[73269]  = { nil, 1, 15,  73269,  52116, 425, 450, 467, 485,  1,  1, { 52181, }, { 1, }, nil, nil, { 52376, }, },
	[73271]  = { nil, 1, 15,  73271,  52118, 425, 450, 467, 485,  1,  1, { 52181, }, { 1, }, nil, nil, { 52377, }, },
	[73272]  = { nil, 1, 15,  73272,  52119, 425, 450, 467, 485,  1,  1, { 52182, }, { 1, }, nil, nil, { 52378, }, },
	[73273]  = { nil, 1, 15,  73273,  52120, 425, 450, 467, 485,  1,  1, { 52182, }, { 1, }, nil, nil, { 52379, }, },
	[73275]  = { nil, 1, 15,  73275,  52122, 425, 450, 467, 485,  1,  1, { 52182, }, { 1, }, nil, nil, { 52382, }, },
	[73276]  = { nil, 1, 15,  73276,  52123, 425, 450, 467, 485,  1,  1, { 52182, }, { 1, }, nil, nil, { 52383, }, },
	[73277]  = { nil, 1, 15,  73277,  52124, 425, 450, 467, 485,  1,  1, { 52182, }, { 1, }, nil, nil, { 52385, }, },
	[73278]  = { nil, 1, 15,  73278,  52125, 425, 450, 467, 485,  1,  1, { 52182, }, { 1, }, nil, nil, { 52386, }, },
	[73280]  = { nil, 1, 15,  73280,  52127, 425, 450, 467, 485,  1,  1, { 52182, }, { 1, }, nil, nil, { 52388, }, },
	[56496]  = { nil, 1, 15,  56496,  42642, 430, 450, 455, 460,  1,  1, { 41163, 42225, 36860, 35627, 43102, }, { 2, 4, 4, 4, 1, }, nil, nil, { 42648, }, },
	[56497]  = { nil, 1, 15,  56497,  42643, 430, 450, 455, 460,  1,  1, { 41163, 42225, 35624, 35625, 43102, }, { 2, 4, 4, 4, 1, }, nil, nil, { 42649, }, },
	[56498]  = { nil, 1, 15,  56498,  42644, 430, 450, 455, 460,  1,  1, { 41163, 42225, 35622, 35623, 43102, }, { 2, 4, 4, 4, 1, }, nil, nil, { 42650, }, },
	[66587]  = { nil, 1, 15,  66587,  40159, 440, 440, 452, 465,  1,  1, { 36931, }, { 1, }, },
	[56499]  = { nil, 1, 15,  56499,  42645, 440, 450, 455, 460,  1,  1, { 41163, 42225, 35623, 36860, 43102, }, { 2, 4, 6, 6, 1, }, nil, nil, { 42651, }, },
	[56500]  = { nil, 1, 15,  56500,  42646, 440, 450, 455, 460,  1,  1, { 41163, 42225, 35625, 35624, 43102, }, { 2, 4, 6, 6, 1, }, nil, nil, { 42652, }, },
	[56501]  = { nil, 1, 15,  56501,  42647, 440, 450, 455, 460,  1,  1, { 41163, 42225, 35627, 35622, 43102, }, { 2, 4, 6, 6, 1, }, nil, nil, { 42653, }, },
	[66338]  = { nil, 1, 15,  66338,  40167, 450, 450, 452, 465,  1,  1, { 36934, }, { 1, }, nil, nil, { 46940, 46897, }, },
	[66428]  = { nil, 1, 15,  66428,  40168, 450, 450, 452, 465,  1,  1, { 36934, }, { 1, }, nil, nil, { 46898, }, },
	[66429]  = { nil, 1, 15,  66429,  40166, 450, 450, 452, 465,  1,  1, { 36934, }, { 1, }, nil, nil, { 46899, }, },
	[66431]  = { nil, 1, 15,  66431,  40165, 450, 450, 452, 465,  1,  1, { 36934, }, { 1, }, nil, nil, { 46944, 46901, }, },
	[66432]  = { nil, 1, 15,  66432,  40164, 450, 450, 452, 465,  1,  1, { 36928, }, { 1, }, nil, nil, { 46936, 46902, }, },
	[66434]  = { nil, 1, 15,  66434,  40169, 450, 450, 452, 465,  1,  1, { 36934, }, { 1, }, nil, nil, { 46904, }, },
	[66435]  = { nil, 1, 15,  66435,  40171, 450, 450, 452, 465,  1,  1, { 36934, }, { 1, }, nil, nil, { 46905, }, },
	[66439]  = { nil, 1, 15,  66439,  40177, 450, 450, 452, 465,  1,  1, { 36934, }, { 1, }, nil, nil, { 46907, 46909, }, },
	[66441]  = { nil, 1, 15,  66441,  40180, 450, 450, 452, 465,  1,  1, { 36934, }, { 1, }, nil, nil, { 46908, 46911, }, },
	[66442]  = { nil, 1, 15,  66442,  40179, 450, 450, 452, 465,  1,  1, { 36934, }, { 1, }, nil, nil, { 46910, 46912, }, },
	[66443]  = { nil, 1, 15,  66443,  40182, 450, 450, 452, 465,  1,  1, { 36934, }, { 1, }, nil, nil, { 46913, }, },
	[66445]  = { nil, 1, 15,  66445,  40173, 450, 450, 452, 465,  1,  1, { 36934, }, { 1, }, nil, nil, { 46914, 46915, }, },
	[66446]  = { nil, 1, 15,  66446,  40113, 450, 450, 452, 465,  1,  1, { 36919, }, { 1, }, nil, nil, { 46930, 46916, }, },
	[66447]  = { nil, 1, 15,  66447,  40111, 450, 450, 452, 465,  1,  1, { 36919, }, { 1, }, nil, nil, { 46917, }, },
	[66448]  = { nil, 1, 15,  66448,  40112, 450, 450, 452, 465,  1,  1, { 36919, }, { 1, }, nil, nil, { 46918, 46919, }, },
	[66450]  = { nil, 1, 15,  66450,  40118, 450, 450, 452, 465,  1,  1, { 36919, }, { 1, }, nil, nil, { 46920, }, },
	[66452]  = { nil, 1, 15,  66452,  40115, 450, 450, 452, 465,  1,  1, { 36922, }, { 1, }, nil, nil, { 46931, 46922, }, },
	[66453]  = { nil, 1, 15,  66453,  40116, 450, 450, 452, 465,  1,  1, { 36919, }, { 1, }, nil, nil, { 46923, }, },
	[66497]  = { nil, 1, 15,  66497,  40119, 450, 450, 452, 465,  1,  1, { 36925, }, { 1, }, nil, nil, { 46924, }, },
	[66498]  = { nil, 1, 15,  66498,  40120, 450, 450, 452, 465,  1,  1, { 36925, }, { 1, }, nil, nil, { 46925, 46927, }, },
	[66499]  = { nil, 1, 15,  66499,  40122, 450, 450, 452, 465,  1,  1, { 36925, }, { 1, }, nil, nil, { 46926, }, },
	[66501]  = { nil, 1, 15,  66501,  40125, 450, 450, 452, 465,  1,  1, { 36925, }, { 1, }, nil, nil, { 46928, }, },
	[66502]  = { nil, 1, 15,  66502,  40124, 450, 450, 452, 465,  1,  1, { 36922, }, { 1, }, nil, nil, { 46929, 46921, }, },
	[66505]  = { nil, 1, 15,  66505,  40127, 450, 450, 452, 465,  1,  1, { 36922, }, { 1, }, nil, nil, { 46932, }, },
	[66506]  = { nil, 1, 15,  66506,  40128, 450, 450, 452, 465,  1,  1, { 36922, }, { 1, }, nil, nil, { 46933, }, },
	[66554]  = { nil, 1, 15,  66554,  40129, 450, 450, 452, 465,  1,  1, { 36928, }, { 1, }, nil, nil, { 46935, }, },
	[66556]  = { nil, 1, 15,  66556,  40133, 450, 450, 452, 465,  1,  1, { 36928, }, { 1, }, nil, nil, { 46937, 46939, 46947, 46900, 46903, }, },
	[66557]  = { nil, 1, 15,  66557,  40130, 450, 450, 452, 465,  1,  1, { 36928, }, { 1, }, nil, nil, { 46934, 46938, }, },
	[66560]  = { nil, 1, 15,  66560,  40139, 450, 450, 452, 465,  1,  1, { 36928, }, { 1, }, nil, nil, { 46941, }, },
	[66561]  = { nil, 1, 15,  66561,  40141, 450, 450, 452, 465,  1,  1, { 36928, }, { 1, }, nil, nil, { 46942, }, },
	[66562]  = { nil, 1, 15,  66562,  40135, 450, 450, 452, 465,  1,  1, { 36928, }, { 1, }, nil, nil, { 46943, }, },
	[66567]  = { nil, 1, 15,  66567,  40142, 450, 450, 452, 465,  1,  1, { 36931, }, { 1, }, nil, nil, { 46948, }, },
	[66568]  = { nil, 1, 15,  66568,  40147, 450, 450, 452, 465,  1,  1, { 36931, }, { 1, }, nil, nil, { 46949, }, },
	[66569]  = { nil, 1, 15,  66569,  40152, 450, 450, 452, 465,  1,  1, { 36931, }, { 1, }, nil, nil, { 46950, }, },
	[66570]  = { nil, 1, 15,  66570,  40153, 450, 450, 452, 465,  1,  1, { 36928, }, { 1, }, nil, nil, { 46951, }, },
	[66571]  = { nil, 1, 15,  66571,  40154, 450, 450, 452, 465,  1,  1, { 36931, }, { 1, }, nil, nil, { 46952, }, },
	[66572]  = { nil, 1, 15,  66572,  40143, 450, 450, 452, 465,  1,  1, { 36928, }, { 1, }, nil, nil, { 46953, }, },
	[66573]  = { nil, 1, 15,  66573,  40157, 450, 450, 452, 465,  1,  1, { 36928, }, { 1, }, nil, nil, { 47008, 46945, 46946, 46956, }, },
	[66574]  = { nil, 1, 15,  66574,  40155, 450, 450, 452, 465,  1,  1, { 36931, }, { 1, }, nil, nil, { 47007, }, },
	[66576]  = { nil, 1, 15,  66576,  40162, 450, 450, 452, 465,  1,  1, { 36928, }, { 1, }, nil, nil, { 47010, }, },
	[66579]  = { nil, 1, 15,  66579,  40144, 450, 450, 452, 465,  1,  1, { 36931, }, { 1, }, nil, nil, { 47015, }, },
	[66581]  = { nil, 1, 15,  66581,  40160, 450, 450, 452, 465,  1,  1, { 36931, }, { 1, }, nil, nil, { 47012, 47017, }, },
	[66582]  = { nil, 1, 15,  66582,  40145, 450, 450, 452, 465,  1,  1, { 36931, }, { 1, }, nil, nil, { 47018, }, },
	[66583]  = { nil, 1, 15,  66583,  40146, 450, 450, 452, 465,  1,  1, { 36931, }, { 1, }, nil, nil, { 47019, }, },
	[66584]  = { nil, 1, 15,  66584,  40150, 450, 450, 452, 465,  1,  1, { 36931, }, { 1, }, nil, nil, { 47020, 47023, }, },
	[66585]  = { nil, 1, 15,  66585,  40149, 450, 450, 452, 465,  1,  1, { 36931, }, { 1, }, nil, nil, { 47016, 47021, }, },
	[66586]  = { nil, 1, 15,  66586,  40163, 450, 450, 452, 465,  1,  1, { 36931, }, { 1, }, nil, nil, { 47022, }, },
	[68253]  = { nil, 1, 15,  68253,  49110, 450, 450, 452, 465,  1,  1, { 42225, 34054, }, { 1, 5, }, nil, nil, { 49112, }, },
	[73622]  = { nil, 1, 15,  73622,  52490, 450, 450, 457, 465,  1,  1, { 52180, }, { 1, }, },
	[73222]  = { nil, 1, 15,  73222,  52081, 450, 450, 467, 485,  1,  1, { 52177, }, { 1, }, },
	[73223]  = { nil, 1, 15,  73223,  52082, 450, 450, 467, 485,  1,  1, { 52177, }, { 1, }, },
	[73225]  = { nil, 1, 15,  73225,  52084, 450, 450, 467, 485,  1,  1, { 52177, }, { 1, }, },
	[73226]  = { nil, 1, 15,  73226,  52085, 450, 450, 467, 485,  1,  1, { 52177, }, { 1, }, },
	[73227]  = { nil, 1, 15,  73227,  52086, 450, 450, 467, 485,  1,  1, { 52178, }, { 1, }, },
	[73228]  = { nil, 1, 15,  73228,  52087, 450, 450, 467, 485,  1,  1, { 52178, }, { 1, }, },
	[73230]  = { nil, 1, 15,  73230,  52089, 450, 450, 467, 485,  1,  1, { 52178, }, { 1, }, },
	[73232]  = { nil, 1, 15,  73232,  52091, 450, 450, 467, 485,  1,  1, { 52179, }, { 1, }, },
	[73233]  = { nil, 1, 15,  73233,  52092, 450, 450, 467, 485,  1,  1, { 52179, }, { 1, }, },
	[73234]  = { nil, 1, 15,  73234,  52093, 450, 450, 467, 485,  1,  1, { 52179, }, { 1, }, },
	[73239]  = { nil, 1, 15,  73239,  52094, 450, 450, 467, 485,  1,  1, { 52179, }, { 1, }, },
	[73240]  = { nil, 1, 15,  73240,  52095, 450, 450, 467, 485,  1,  1, { 52180, }, { 1, }, },
	[73241]  = { nil, 1, 15,  73241,  52096, 450, 450, 467, 485,  1,  1, { 52180, }, { 1, }, },
	[73243]  = { nil, 1, 15,  73243,  52098, 450, 450, 467, 485,  1,  1, { 52180, }, { 1, }, },
	[73246]  = { nil, 1, 15,  73246,  52101, 450, 450, 467, 485,  1,  1, { 52180, }, { 1, }, },
	[73247]  = { nil, 1, 15,  73247,  52102, 450, 450, 467, 485,  1,  1, { 52180, }, { 1, }, },
	[73249]  = { nil, 1, 15,  73249,  52104, 450, 450, 467, 485,  1,  1, { 52180, }, { 1, }, },
	[73250]  = { nil, 1, 15,  73250,  52105, 450, 450, 467, 485,  1,  1, { 52180, }, { 1, }, },
	[73259]  = { nil, 1, 15,  73259,  52107, 450, 450, 467, 485,  1,  1, { 52181, }, { 1, }, },
	[73267]  = { nil, 1, 15,  73267,  52114, 450, 450, 467, 485,  1,  1, { 52181, }, { 1, }, },
	[73268]  = { nil, 1, 15,  73268,  52115, 450, 450, 467, 485,  1,  1, { 52181, }, { 1, }, },
	[73270]  = { nil, 1, 15,  73270,  52117, 450, 450, 467, 485,  1,  1, { 52181, }, { 1, }, },
	[73274]  = { nil, 1, 15,  73274,  52121, 450, 450, 467, 485,  1,  1, { 52182, }, { 1, }, },
	[73279]  = { nil, 1, 15,  73279,  52126, 450, 450, 467, 485,  1,  1, { 52182, }, { 1, }, },
	[73281]  = { nil, 1, 15,  73281,  52128, 450, 450, 467, 485,  1,  1, { 52182, }, { 1, }, },
	[73494]  = { nil, 1, 15,  73494,  52306, 450, 450, 467, 485,  1,  1, { 52188, 52182, }, { 1, 1, }, },
	[73496]  = { nil, 1, 15,  73496,  52307, 450, 450, 467, 485,  1,  1, { 52188, 52179, }, { 1, 2, }, },
	[73625]  = { nil, 1, 15,  73625,  52485, 450, 480, 490, 500,  1,  1, { 52190, 52186, 52325, }, { 3, 2, 50, }, nil, nil, { 52494, }, },
	[73626]  = { nil, 1, 15,  73626,  52486, 455, 485, 495, 505,  1,  1, { 52191, 52186, 52326, }, { 3, 2, 50, }, nil, nil, { 52495, }, },
	[73627]  = { nil, 1, 15,  73627,  52487, 460, 490, 500, 510,  1,  1, { 52195, 52186, 52329, }, { 3, 2, 50, }, nil, nil, { 52496, }, },
	[73335]  = { nil, 1, 15,  73335,  52206, 465, 500, 507, 515,  1,  1, { 52190, }, { 1, }, nil, nil, { 52362, }, },
	[73336]  = { nil, 1, 15,  73336,  52212, 465, 500, 507, 515,  1,  1, { 52190, }, { 1, }, nil, nil, { 52380, }, },
	[73337]  = { nil, 1, 15,  73337,  52216, 465, 500, 507, 515,  1,  1, { 52190, }, { 1, }, nil, nil, { 52384, }, },
	[73338]  = { nil, 1, 15,  73338,  52207, 465, 500, 507, 515,  1,  1, { 52190, }, { 1, }, nil, nil, { 52387, }, },
	[73339]  = { nil, 1, 15,  73339,  52230, 465, 500, 507, 515,  1,  1, { 52190, }, { 1, }, nil, nil, { 52389, }, },
	[73340]  = { nil, 1, 15,  73340,  52242, 465, 500, 507, 515,  1,  1, { 52191, }, { 1, }, nil, nil, { 52390, }, },
	[73341]  = { nil, 1, 15,  73341,  52244, 465, 500, 507, 515,  1,  1, { 52191, }, { 1, }, nil, nil, { 52391, }, },
	[73343]  = { nil, 1, 15,  73343,  52246, 465, 500, 507, 515,  1,  1, { 52191, }, { 1, }, nil, nil, { 52392, }, },
	[73344]  = { nil, 1, 15,  73344,  52235, 465, 500, 507, 515,  1,  1, { 52191, }, { 1, }, nil, nil, { 52393, }, },
	[73345]  = { nil, 1, 15,  73345,  52247, 465, 500, 507, 515,  1,  1, { 52195, }, { 1, }, nil, nil, { 52394, }, },
	[73346]  = { nil, 1, 15,  73346,  52241, 465, 500, 507, 515,  1,  1, { 52195, }, { 1, }, nil, nil, { 52395, }, },
	[73347]  = { nil, 1, 15,  73347,  52226, 465, 500, 507, 515,  1,  1, { 52195, }, { 1, }, nil, nil, { 52396, }, },
	[73348]  = { nil, 1, 15,  73348,  52232, 465, 500, 507, 515,  1,  1, { 52195, }, { 1, }, nil, nil, { 52397, }, },
	[73349]  = { nil, 1, 15,  73349,  52219, 465, 500, 507, 515,  1,  1, { 52195, }, { 1, }, nil, nil, { 52398, }, },
	[73350]  = { nil, 1, 15,  73350,  52243, 465, 500, 507, 515,  1,  1, { 52194, }, { 1, }, nil, nil, { 52399, }, },
	[73351]  = { nil, 1, 15,  73351,  52238, 465, 500, 507, 515,  1,  1, { 52194, }, { 1, }, nil, nil, { 52400, }, },
	[73352]  = { nil, 1, 15,  73352,  52210, 465, 500, 507, 515,  1,  1, { 52194, }, { 1, }, nil, nil, { 52401, }, },
	[73353]  = { nil, 1, 15,  73353,  52248, 465, 500, 507, 515,  1,  1, { 52194, }, { 1, }, nil, nil, { 52402, }, },
	[73354]  = { nil, 1, 15,  73354,  52221, 465, 500, 507, 515,  1,  1, { 52194, }, { 1, }, nil, nil, { 52403, }, },
	[73355]  = { nil, 1, 15,  73355,  52236, 465, 500, 507, 515,  1,  1, { 52194, }, { 1, }, nil, nil, { 52404, }, },
	[73356]  = { nil, 1, 15,  73356,  52213, 465, 500, 507, 515,  1,  1, { 52194, }, { 1, }, nil, nil, { 52405, }, },
	[73357]  = { nil, 1, 15,  73357,  52220, 465, 500, 507, 515,  1,  1, { 52194, }, { 1, }, nil, nil, { 52406, }, },
	[73358]  = { nil, 1, 15,  73358,  52234, 465, 500, 507, 515,  1,  1, { 52194, }, { 1, }, nil, nil, { 52407, }, },
	[73359]  = { nil, 1, 15,  73359,  52217, 465, 500, 507, 515,  1,  1, { 52194, }, { 1, }, nil, nil, { 52408, }, },
	[73360]  = { nil, 1, 15,  73360,  52203, 465, 500, 507, 515,  1,  1, { 52194, }, { 1, }, nil, nil, { 52409, }, },
	[73361]  = { nil, 1, 15,  73361,  52229, 465, 500, 507, 515,  1,  1, { 52193, }, { 1, }, nil, nil, { 52410, }, },
	[73362]  = { nil, 1, 15,  73362,  52249, 465, 500, 507, 515,  1,  1, { 52193, }, { 1, }, nil, nil, { 52411, }, },
	[73364]  = { nil, 1, 15,  73364,  52222, 465, 500, 507, 515,  1,  1, { 52193, }, { 1, }, nil, nil, { 52412, }, },
	[73365]  = { nil, 1, 15,  73365,  52209, 465, 500, 507, 515,  1,  1, { 52193, }, { 1, }, nil, nil, { 52413, }, },
	[73366]  = { nil, 1, 15,  73366,  52239, 465, 500, 507, 515,  1,  1, { 52193, }, { 1, }, nil, nil, { 52414, }, },
	[73367]  = { nil, 1, 15,  73367,  52214, 465, 500, 507, 515,  1,  1, { 52193, }, { 1, }, nil, nil, { 52415, }, },
	[73368]  = { nil, 1, 15,  73368,  52211, 465, 500, 507, 515,  1,  1, { 52193, }, { 1, }, nil, nil, { 52416, }, },
	[73369]  = { nil, 1, 15,  73369,  52208, 465, 500, 507, 515,  1,  1, { 52193, }, { 1, }, nil, nil, { 52417, }, },
	[73370]  = { nil, 1, 15,  73370,  52240, 465, 500, 507, 515,  1,  1, { 52193, }, { 1, }, nil, nil, { 52418, }, },
	[73371]  = { nil, 1, 15,  73371,  52204, 465, 500, 507, 515,  1,  1, { 52193, }, { 1, }, nil, nil, { 52419, }, },
	[73372]  = { nil, 1, 15,  73372,  52215, 465, 500, 507, 515,  1,  1, { 52193, }, { 1, }, nil, nil, { 52420, }, },
	[73373]  = { nil, 1, 15,  73373,  52205, 465, 500, 507, 515,  1,  1, { 52193, }, { 1, }, nil, nil, { 52421, }, },
	[73374]  = { nil, 1, 15,  73374,  52224, 465, 500, 507, 515,  1,  1, { 52193, }, { 1, }, nil, nil, { 52422, }, },
	[73375]  = { nil, 1, 15,  73375,  52233, 465, 500, 507, 515,  1,  1, { 52192, }, { 1, }, nil, nil, { 52423, }, },
	[73376]  = { nil, 1, 15,  73376,  52227, 465, 500, 507, 515,  1,  1, { 52192, }, { 1, }, nil, nil, { 52424, }, },
	[73377]  = { nil, 1, 15,  73377,  52223, 465, 500, 507, 515,  1,  1, { 52192, }, { 1, }, nil, nil, { 52425, }, },
	[73378]  = { nil, 1, 15,  73378,  52228, 465, 500, 507, 515,  1,  1, { 52192, }, { 1, }, nil, nil, { 52426, }, },
	[73379]  = { nil, 1, 15,  73379,  52245, 465, 500, 507, 515,  1,  1, { 52192, }, { 1, }, nil, nil, { 52427, }, },
	[73380]  = { nil, 1, 15,  73380,  52218, 465, 500, 507, 515,  1,  1, { 52192, }, { 1, }, nil, nil, { 52428, }, },
	[73381]  = { nil, 1, 15,  73381,  52225, 465, 500, 507, 515,  1,  1, { 52192, }, { 1, }, nil, nil, { 52429, }, },
	[73382]  = { nil, 1, 15,  73382,  52231, 465, 500, 507, 515,  1,  1, { 52192, }, { 1, }, nil, nil, { 52430, }, },
	[73383]  = { nil, 1, 15,  73383,  52250, 465, 500, 507, 515,  1,  1, { 52192, }, { 1, }, nil, nil, { 52431, }, },
	[73384]  = { nil, 1, 15,  73384,  52237, 465, 500, 507, 515,  1,  1, { 52192, }, { 1, }, nil, nil, { 52432, }, },
	[95754]  = { nil, 1, 15,  95754,  68356, 465, 500, 507, 515,  1,  1, { 52193, }, { 1, }, nil, nil, { 68359, }, },
	[95755]  = { nil, 1, 15,  95755,  68357, 465, 500, 507, 515,  1,  1, { 52193, }, { 1, }, nil, nil, { 68360, }, },
	[95756]  = { nil, 1, 15,  95756,  68358, 465, 500, 507, 515,  1,  1, { 52193, }, { 1, }, nil, nil, { 68361, }, },
	[96226]  = { nil, 1, 15,  96226,  68741, 465, 500, 507, 515,  1,  1, { 52192, }, { 1, }, nil, nil, { 68742, }, },
	[73620]  = { nil, 1, 15,  73620,  52492, 470, 470, 475, 480,  1,  1, { 52177, 52188, }, { 3, 3, }, },
	[73495]  = { nil, 1, 15,  73495,  52308, 485, 485, 495, 505,  1,  1, { 52188, 52181, }, { 1, 2, }, },
	[73464]  = { nil, 1, 15,  73464,  52289, 490, 515, 520, 525,  1,  1, { 52303, }, { 1, }, nil, nil, { 52433, }, },
	[73465]  = { nil, 1, 15,  73465,  52291, 490, 515, 520, 525,  1,  1, { 52303, }, { 1, }, nil, nil, { 52434, }, },
	[73466]  = { nil, 1, 15,  73466,  52292, 490, 515, 520, 525,  1,  1, { 52303, }, { 1, }, nil, nil, { 52435, }, },
	[73467]  = { nil, 1, 15,  73467,  52293, 490, 515, 520, 525,  1,  1, { 52303, }, { 1, }, nil, nil, { 52436, }, },
	[73468]  = { nil, 1, 15,  73468,  52294, 490, 515, 520, 525,  1,  1, { 52303, }, { 1, }, nil, nil, { 52437, }, },
	[73469]  = { nil, 1, 15,  73469,  52295, 490, 515, 520, 525,  1,  1, { 52303, }, { 1, }, nil, nil, { 52438, }, },
	[73470]  = { nil, 1, 15,  73470,  52296, 490, 515, 520, 525,  1,  1, { 52303, }, { 1, }, nil, nil, { 52439, }, },
	[73471]  = { nil, 1, 15,  73471,  52297, 490, 515, 520, 525,  1,  1, { 52303, }, { 1, }, nil, nil, { 52440, }, },
	[73472]  = { nil, 1, 15,  73472,  52298, 490, 515, 520, 525,  1,  1, { 52303, }, { 1, }, nil, nil, { 52441, }, },
	[73473]  = { nil, 1, 15,  73473,  52299, 490, 515, 520, 525,  1,  1, { 52303, }, { 1, }, nil, nil, { 52442, }, },
	[73474]  = { nil, 1, 15,  73474,  52300, 490, 515, 520, 525,  1,  1, { 52303, }, { 1, }, nil, nil, { 52443, }, },
	[73475]  = { nil, 1, 15,  73475,  52301, 490, 515, 520, 525,  1,  1, { 52303, }, { 1, }, nil, nil, { 52444, }, },
	[73476]  = { nil, 1, 15,  73476,  52302, 490, 515, 520, 525,  1,  1, { 52303, }, { 1, }, nil, nil, { 52445, }, },
	[96255]  = { nil, 1, 15,  96255,  68778, 490, 515, 520, 525,  1,  1, { 52303, }, { 1, }, nil, nil, { 68781, }, },
	[96256]  = { nil, 1, 15,  96256,  68779, 490, 515, 520, 525,  1,  1, { 52303, }, { 1, }, nil, nil, { 68782, }, },
	[96257]  = { nil, 1, 15,  96257,  68780, 490, 515, 520, 525,  1,  1, { 52303, }, { 1, }, nil, nil, { 68783, }, },
	[73497]  = { nil, 1, 15,  73497,  52309, 495, 495, 505, 515,  1,  1, { 52188, 52180, }, { 1, 2, }, },
	[73621]  = { nil, 1, 15,  73621,  52493, 500, 500, 505, 510,  1,  1, { 52195, 52194, 52192, 52193, 52191, 52190, }, { 1, 1, 1, 1, 1, 1, }, },
	[73396]  = { nil, 1, 15,  73396,  52255, 500, 505, 507, 510,  1,  1, { 52196, }, { 1, }, nil, nil, { 52381, }, },
	[73397]  = { nil, 1, 15,  73397,  52258, 500, 505, 507, 510,  1,  1, { 52196, }, { 1, }, nil, nil, { 52447, }, },
	[73398]  = { nil, 1, 15,  73398,  52259, 500, 505, 507, 510,  1,  1, { 52196, }, { 1, }, nil, nil, { 52448, }, },
	[73399]  = { nil, 1, 15,  73399,  52257, 500, 505, 507, 510,  1,  1, { 52196, }, { 1, }, nil, nil, { 52449, }, },
	[73400]  = { nil, 1, 15,  73400,  52260, 500, 505, 507, 510,  1,  1, { 52196, }, { 1, }, nil, nil, { 52450, }, },
	[73401]  = { nil, 1, 15,  73401,  52261, 500, 505, 507, 510,  1,  1, { 52196, }, { 1, }, nil, nil, { 52451, }, },
	[73402]  = { nil, 1, 15,  73402,  52262, 500, 505, 507, 510,  1,  1, { 52196, }, { 1, }, nil, nil, { 52452, }, },
	[73403]  = { nil, 1, 15,  73403,  52263, 500, 505, 507, 510,  1,  1, { 52196, }, { 1, }, nil, nil, { 52453, }, },
	[73404]  = { nil, 1, 15,  73404,  52264, 500, 505, 507, 510,  1,  1, { 52196, }, { 1, }, nil, nil, { 52454, }, },
	[73405]  = { nil, 1, 15,  73405,  52265, 500, 505, 507, 510,  1,  1, { 52196, }, { 1, }, nil, nil, { 52455, }, },
	[73406]  = { nil, 1, 15,  73406,  52266, 500, 505, 507, 510,  1,  1, { 52196, }, { 1, }, nil, nil, { 52456, }, },
	[73407]  = { nil, 1, 15,  73407,  52267, 500, 505, 507, 510,  1,  1, { 52196, }, { 1, }, nil, nil, { 52457, }, },
	[73408]  = { nil, 1, 15,  73408,  52268, 500, 505, 507, 510,  1,  1, { 52196, }, { 1, }, nil, nil, { 52458, }, },
	[73409]  = { nil, 1, 15,  73409,  52269, 500, 505, 507, 510,  1,  1, { 52196, }, { 1, }, nil, nil, { 52459, }, },
	[99539]  = { nil, 1, 15,  99539,  75067, 515, 515, 520, 525,  1,  1, { 52188, 52191, 52328, }, { 1, 4, 8, }, },
	[99540]  = { nil, 1, 15,  99540,  75068, 515, 515, 520, 525,  1,  1, { 52188, 52195, 52326, }, { 1, 4, 8, }, },
	[99541]  = { nil, 1, 15,  99541,  75071, 515, 515, 520, 525,  1,  1, { 52188, 52190, 52327, }, { 1, 4, 8, }, },
	[73478]  = { nil, 1, 15,  73478,  52304, 525, 525, 525, 525,  1,  1, { 52177, 52179, 52181, 52182, 52180, 52178, }, { 3, 3, 3, 3, 3, 3, }, },
	[73498]  = { nil, 1, 15,  73498,  52318, 525, 525, 525, 525,  1,  1, { 52186, 52196, 52194, 52328, }, { 4, 4, 4, 75, }, nil, nil, { 52461, }, },
	[73502]  = { nil, 1, 15,  73502,  52319, 525, 525, 525, 525,  1,  1, { 52186, 52196, 52193, 52325, }, { 4, 4, 4, 75, }, nil, nil, { 52462, }, },
	[73503]  = { nil, 1, 15,  73503,  52320, 525, 525, 525, 525,  1,  1, { 52186, 52196, 52192, 52329, }, { 4, 4, 4, 75, }, nil, nil, { 52463, }, },
	[73504]  = { nil, 1, 15,  73504,  52321, 525, 525, 525, 525,  1,  1, { 52186, 52196, 52195, 52326, }, { 4, 4, 4, 75, }, nil, nil, { 52465, }, },
	[73505]  = { nil, 1, 15,  73505,  52322, 525, 525, 525, 525,  1,  1, { 52186, 52196, 52190, 52325, }, { 4, 4, 4, 75, }, nil, nil, { 52466, }, },
	[73506]  = { nil, 1, 15,  73506,  52323, 525, 525, 525, 525,  1,  1, { 52186, 52196, 52191, 52327, }, { 4, 4, 4, 75, }, nil, nil, { 52467, }, },
	[73520]  = { nil, 1, 15,  73520,  52348, 525, 525, 525, 525,  1,  1, { 52186, 52196, 52194, 52328, }, { 4, 4, 4, 75, }, nil, nil, { 52460, }, },
	[73521]  = { nil, 1, 15,  73521,  52350, 525, 525, 525, 525,  1,  1, { 52186, 52196, 52195, 52326, }, { 4, 4, 4, 75, }, nil, nil, { 52464, }, },
	[98921]  = { nil, 1, 15,  98921,  69852, 525, 525, 525, 525,  1,  1, { 52186, 52196, 52195, 52327, }, { 4, 4, 4, 75, }, nil, nil, { 69853, }, },
	[73623]  = { nil, 1, 15,  73623,  52489, 525, 525, 530, 535,  1,  1, { 58480, 52196, 52555, 52192, }, { 2, 2, 8, 2, }, nil, nil, { 71965, }, },
	[99542]  = { nil, 1, 15,  99542,  75074, 525, 525, 530, 535,  1,  1, { 52188, 52191, 52328, 52325, }, { 1, 5, 8, 4, }, },
	[99543]  = { nil, 1, 15,  99543,  75075, 525, 525, 530, 535,  1,  1, { 52188, 52195, 52326, 52329, }, { 1, 5, 8, 4, }, },
	[99544]  = { nil, 1, 15,  99544,  75078, 525, 525, 530, 535,  1,  1, { 52188, 52190, 52327, 52326, }, { 1, 5, 8, 6, }, },
	[101735] = { nil, 1, 15, 101735,  71817, 525, 525, 530, 535,  1,  1, { 71807, }, { 1, }, nil, nil, { 71821, }, },
	[101740] = { nil, 1, 15, 101740,  71818, 525, 525, 530, 535,  1,  1, { 71807, }, { 1, }, nil, nil, { 71884, }, },
	[101741] = { nil, 1, 15, 101741,  71819, 525, 525, 530, 535,  1,  1, { 71807, }, { 1, }, nil, nil, { 71885, }, },
	[101742] = { nil, 1, 15, 101742,  71820, 525, 525, 530, 535,  1,  1, { 71807, }, { 1, }, nil, nil, { 71886, }, },
	[101743] = { nil, 1, 15, 101743,  71822, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71887, }, },
	[101744] = { nil, 1, 15, 101744,  71823, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71888, }, },
	[101745] = { nil, 1, 15, 101745,  71824, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71889, }, },
	[101746] = { nil, 1, 15, 101746,  71825, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71890, }, },
	[101747] = { nil, 1, 15, 101747,  71826, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71891, }, },
	[101748] = { nil, 1, 15, 101748,  71827, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71892, }, },
	[101749] = { nil, 1, 15, 101749,  71828, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71893, }, },
	[101750] = { nil, 1, 15, 101750,  71829, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71894, }, },
	[101751] = { nil, 1, 15, 101751,  71830, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71895, }, },
	[101752] = { nil, 1, 15, 101752,  71831, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71896, }, },
	[101753] = { nil, 1, 15, 101753,  71832, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71897, }, },
	[101754] = { nil, 1, 15, 101754,  71833, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71898, }, },
	[101755] = { nil, 1, 15, 101755,  71834, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71899, }, },
	[101756] = { nil, 1, 15, 101756,  71835, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71900, }, },
	[101757] = { nil, 1, 15, 101757,  71836, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71901, }, },
	[101758] = { nil, 1, 15, 101758,  71837, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71902, }, },
	[101759] = { nil, 1, 15, 101759,  71838, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71903, }, },
	[101760] = { nil, 1, 15, 101760,  71839, 525, 525, 530, 535,  1,  1, { 71810, }, { 1, }, nil, nil, { 71904, }, },
	[101761] = { nil, 1, 15, 101761,  71840, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71905, }, },
	[101762] = { nil, 1, 15, 101762,  71841, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71906, }, },
	[101763] = { nil, 1, 15, 101763,  71842, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71907, }, },
	[101764] = { nil, 1, 15, 101764,  71843, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71908, }, },
	[101765] = { nil, 1, 15, 101765,  71844, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71909, }, },
	[101766] = { nil, 1, 15, 101766,  71845, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71910, }, },
	[101767] = { nil, 1, 15, 101767,  71846, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71911, }, },
	[101768] = { nil, 1, 15, 101768,  71847, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71912, }, },
	[101769] = { nil, 1, 15, 101769,  71848, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71913, }, },
	[101770] = { nil, 1, 15, 101770,  71849, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71914, }, },
	[101771] = { nil, 1, 15, 101771,  71850, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71915, }, },
	[101772] = { nil, 1, 15, 101772,  71851, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71916, }, },
	[101773] = { nil, 1, 15, 101773,  71852, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71917, }, },
	[101774] = { nil, 1, 15, 101774,  71853, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71918, }, },
	[101775] = { nil, 1, 15, 101775,  71854, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71919, }, },
	[101776] = { nil, 1, 15, 101776,  71855, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71920, }, },
	[101777] = { nil, 1, 15, 101777,  71856, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71921, }, },
	[101778] = { nil, 1, 15, 101778,  71857, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71922, }, },
	[101779] = { nil, 1, 15, 101779,  71858, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71923, }, },
	[101780] = { nil, 1, 15, 101780,  71859, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71924, }, },
	[101781] = { nil, 1, 15, 101781,  71860, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71925, }, },
	[101782] = { nil, 1, 15, 101782,  71861, 525, 525, 530, 535,  1,  1, { 71808, }, { 1, }, nil, nil, { 71926, }, },
	[101783] = { nil, 1, 15, 101783,  71862, 525, 525, 530, 535,  1,  1, { 71809, }, { 1, }, nil, nil, { 71927, }, },
	[101784] = { nil, 1, 15, 101784,  71863, 525, 525, 530, 535,  1,  1, { 71809, }, { 1, }, nil, nil, { 71928, }, },
	[101785] = { nil, 1, 15, 101785,  71864, 525, 525, 530, 535,  1,  1, { 71809, }, { 1, }, nil, nil, { 71929, }, },
	[101786] = { nil, 1, 15, 101786,  71865, 525, 525, 530, 535,  1,  1, { 71809, }, { 1, }, nil, nil, { 71930, }, },
	[101787] = { nil, 1, 15, 101787,  71866, 525, 525, 530, 535,  1,  1, { 71809, }, { 1, }, nil, nil, { 71931, }, },
	[101788] = { nil, 1, 15, 101788,  71867, 525, 525, 530, 535,  1,  1, { 71809, }, { 1, }, nil, nil, { 71932, }, },
	[101789] = { nil, 1, 15, 101789,  71868, 525, 525, 530, 535,  1,  1, { 71809, }, { 1, }, nil, nil, { 71933, }, },
	[101790] = { nil, 1, 15, 101790,  71869, 525, 525, 530, 535,  1,  1, { 71809, }, { 1, }, nil, nil, { 71934, }, },
	[101791] = { nil, 1, 15, 101791,  71870, 525, 525, 530, 535,  1,  1, { 71809, }, { 1, }, nil, nil, { 71935, }, },
	[101792] = { nil, 1, 15, 101792,  71871, 525, 525, 530, 535,  1,  1, { 71809, }, { 1, }, nil, nil, { 71936, }, },
	[101793] = { nil, 1, 15, 101793,  71872, 525, 525, 530, 535,  1,  1, { 71809, }, { 1, }, nil, nil, { 71937, }, },
	[101794] = { nil, 1, 15, 101794,  71873, 525, 525, 530, 535,  1,  1, { 71809, }, { 1, }, nil, nil, { 71938, }, },
	[101795] = { nil, 1, 15, 101795,  71879, 525, 525, 530, 535,  1,  1, { 71805, }, { 1, }, nil, nil, { 71939, }, },
	[101796] = { nil, 1, 15, 101796,  71880, 525, 525, 530, 535,  1,  1, { 71805, }, { 1, }, nil, nil, { 71940, }, },
	[101797] = { nil, 1, 15, 101797,  71881, 525, 525, 530, 535,  1,  1, { 71805, }, { 1, }, nil, nil, { 71941, }, },
	[101798] = { nil, 1, 15, 101798,  71882, 525, 525, 530, 535,  1,  1, { 71805, }, { 1, }, nil, nil, { 71942, }, },
	[101799] = { nil, 1, 15, 101799,  71883, 525, 525, 530, 535,  1,  1, { 71805, }, { 1, }, nil, nil, { 71943, }, },
	[101800] = { nil, 1, 15, 101800,  71874, 525, 525, 530, 535,  1,  1, { 71806, }, { 1, }, nil, nil, { 71944, }, },
	[101801] = { nil, 1, 15, 101801,  71875, 525, 525, 530, 535,  1,  1, { 71806, }, { 1, }, nil, nil, { 71945, }, },
	[101802] = { nil, 1, 15, 101802,  71876, 525, 525, 530, 535,  1,  1, { 71806, }, { 1, }, nil, nil, { 71946, }, },
	[101803] = { nil, 1, 15, 101803,  71877, 525, 525, 530, 535,  1,  1, { 71806, }, { 1, }, nil, nil, { 71947, }, },
	[101804] = { nil, 1, 15, 101804,  71878, 525, 525, 530, 535,  1,  1, { 71806, }, { 1, }, nil, nil, { 71948, }, },
	[52738]  = { nil, 1, 16,  52738,  37101,   1,  15,  22,  30,  1,  1, { 39151, }, { 1, }, },
	[45382]  = { nil, 1, 16,  45382,   1180,   1,  35,  40,  45,  1,  1, { 37101, 39354, }, { 1, 1, }, },
	[48114]  = { nil, 1, 16,  48114,    955,   1,  35,  40,  45,  1,  1, { 37101, 39354, }, { 1, 1, }, },
	[48116]  = { nil, 1, 16,  48116,   1181,   1,  35,  40,  45,  1,  1, { 37101, 39354, }, { 1, 1, }, },
	[58472]  = { nil, 1, 16,  58472,   3012,  15,  35,  40,  45,  1,  1, { 37101, 39354, }, { 2, 1, }, true, 50, },
	[58484]  = { nil, 1, 16,  58484,    954,  15,  35,  40,  45,  1,  1, { 37101, 39354, }, { 2, 1, }, true, 50, },
	[52843]  = { nil, 1, 16,  52843,  39469,  35,  45,  60,  75,  1,  1, { 39151, }, { 2, }, true, 50, },
	[48248]  = { nil, 1, 16,  48248,  37118,  35,  60,  67,  75,  1,  1, { 39354, 39469, }, { 1, 1, }, true, 50, },
	[52739]  = { nil, 1, 16,  52739,  38682,  35,  75,  87, 100,  2,  2, { 39469, 39354, }, { 1, 2, }, true, 150, },
	[53462]  = { nil, 1, 16,  53462,  39774,  75,  75,  77,  80,  1,  1, { 39334, }, { 2, }, true, 300, },
	[50598]  = { nil, 1, 16,  50598,   2290,  75,  75,  80,  85,  1,  1, { 39774, 39354, }, { 1, 1, }, true, 400, },
	[50605]  = { nil, 1, 16,  50605,   1712,  75,  75,  80,  85,  1,  1, { 39774, 39354, }, { 1, 1, }, true, 400, },
	[50612]  = { nil, 1, 16,  50612,   1711,  75,  75,  80,  85,  1,  1, { 39774, 39354, }, { 1, 1, }, true, 400, },
	[58289]  = { nil, 1, 16,  58289,  43332,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58296]  = { nil, 1, 16,  58296,  43335,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58298]  = { nil, 1, 16,  58298,  43356,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58299]  = { nil, 1, 16,  58299,  43338,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58301]  = { nil, 1, 16,  58301,  43350,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58303]  = { nil, 1, 16,  58303,  43339,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58306]  = { nil, 1, 16,  58306,  43359,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58308]  = { nil, 1, 16,  58308,  43364,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58310]  = { nil, 1, 16,  58310,  43361,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58312]  = { nil, 1, 16,  58312,  43366,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58313]  = { nil, 1, 16,  58313,  43367,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58314]  = { nil, 1, 16,  58314,  43340,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58317]  = { nil, 1, 16,  58317,  43342,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58318]  = { nil, 1, 16,  58318,  43371,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58323]  = { nil, 1, 16,  58323,  43379,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58326]  = { nil, 1, 16,  58326,  43343,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58337]  = { nil, 1, 16,  58337,  43390,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58342]  = { nil, 1, 16,  58342,  43395,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[58343]  = { nil, 1, 16,  58343,  43396,  75,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[92026]  = { nil, 1, 16,  92026,  64670,  75,  90, 100, 110,  1,  1, { 39774, }, { 1, }, true, 400, },
	[58286]  = { nil, 1, 16,  58286,  43316,  75, 105, 110, 115,  1,  1, { 43116, 39354, }, { 3, 1, }, },
	[58288]  = { nil, 1, 16,  58288,  43331,  75, 105, 110, 115,  1,  1, { 43116, 39354, }, { 3, 1, }, },
	[58311]  = { nil, 1, 16,  58311,  43365,  75, 105, 110, 115,  1,  1, { 43116, 39354, }, { 3, 1, }, },
	[58315]  = { nil, 1, 16,  58315,  43368,  75, 105, 110, 115,  1,  1, { 43116, 39354, }, { 3, 1, }, },
	[58320]  = { nil, 1, 16,  58320,  43373,  75, 105, 110, 115,  1,  1, { 43116, 39354, }, { 3, 1, }, },
	[58325]  = { nil, 1, 16,  58325,  43377,  75, 105, 110, 115,  1,  1, { 43116, 39354, }, { 3, 1, }, },
	[58332]  = { nil, 1, 16,  58332,  43386,  75, 105, 110, 115,  1,  1, { 43116, 39354, }, { 3, 1, }, },
	[58336]  = { nil, 1, 16,  58336,  43389,  75, 105, 110, 115,  1,  1, { 43116, 39354, }, { 3, 1, }, },
	[58345]  = { nil, 1, 16,  58345,  43398,  75, 105, 110, 115,  1,  1, { 43116, 39354, }, { 3, 1, }, },
	[107907] = { nil, 1, 16, 107907,  77101,  75, 105, 110, 115,  1,  1, { 43116, 39354, }, { 3, 1, }, },
	[61288]  = { nil, 1, 16,  61288,    nil,  75, 125, 137, 150,  0,  0, { 39469, 39354, }, { 1, 2, }, true, 1000, },
	[58307]  = { nil, 1, 16,  58307,  43360,  75, 130, 135, 140,  1,  1, { 43116, 10648, }, { 3, 1, }, },
	[58324]  = { nil, 1, 16,  58324,  43376,  75, 130, 135, 140,  1,  1, { 43116, 10648, }, { 3, 1, }, },
	[58328]  = { nil, 1, 16,  58328,  43380,  75, 130, 135, 140,  1,  1, { 43116, 10648, }, { 3, 1, }, },
	[58331]  = { nil, 1, 16,  58331,  43344,  75, 130, 135, 140,  1,  1, { 43116, 10648, }, { 3, 1, }, },
	[58340]  = { nil, 1, 16,  58340,  43391,  75, 130, 135, 140,  1,  1, { 43116, 10648, }, { 3, 1, }, },
	[58287]  = { nil, 1, 16,  58287,  43334,  75, 155, 160, 165,  1,  1, { 43118, 10648, }, { 3, 1, }, },
	[58302]  = { nil, 1, 16,  58302,  43351,  75, 155, 160, 165,  1,  1, { 43118, 10648, }, { 3, 1, }, },
	[58316]  = { nil, 1, 16,  58316,  43369,  75, 155, 160, 165,  1,  1, { 43118, 10648, }, { 3, 1, }, },
	[58319]  = { nil, 1, 16,  58319,  43370,  75, 155, 160, 165,  1,  1, { 43118, 10648, }, { 3, 1, }, },
	[58321]  = { nil, 1, 16,  58321,  43372,  75, 155, 160, 165,  1,  1, { 43118, 10648, }, { 3, 1, }, },
	[58329]  = { nil, 1, 16,  58329,  43381,  75, 155, 160, 165,  1,  1, { 43118, 10648, }, { 3, 1, }, },
	[58330]  = { nil, 1, 16,  58330,  43385,  75, 155, 160, 165,  1,  1, { 43118, 10648, }, { 3, 1, }, },
	[58333]  = { nil, 1, 16,  58333,  43388,  75, 155, 160, 165,  1,  1, { 43118, 10648, }, { 3, 1, }, },
	[58338]  = { nil, 1, 16,  58338,  43392,  75, 155, 160, 165,  1,  1, { 43118, 10648, }, { 3, 1, }, },
	[58339]  = { nil, 1, 16,  58339,  43393,  75, 155, 160, 165,  1,  1, { 43118, 10648, }, { 3, 1, }, },
	[59315]  = { nil, 1, 16,  59315,  43674,  75, 155, 160, 165,  1,  1, { 43118, 10648, }, { 3, 1, }, },
	[95215]  = { nil, 1, 16,  95215,  68039,  75, 155, 160, 165,  1,  1, { 43118, 10648, }, { 3, 1, }, },
	[95710]  = { nil, 1, 16,  95710,  63416,  75, 155, 160, 165,  1,  1, { 43118, 10648, }, { 3, 1, }, },
	[58297]  = { nil, 1, 16,  58297,  43355,  75, 205, 210, 215,  1,  1, { 43120, 10648, }, { 3, 1, }, },
	[58327]  = { nil, 1, 16,  58327,  43378,  75, 205, 210, 215,  1,  1, { 43120, 10648, }, { 3, 1, }, },
	[57209]  = { nil, 1, 16,  57209,  43535,  75, 295, 300, 305,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[57215]  = { nil, 1, 16,  57215,  43539,  75, 295, 300, 305,  1,  1, { 43124, 39501, }, { 3, 1, }, },
	[57217]  = { nil, 1, 16,  57217,  43544,  75, 295, 300, 305,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[57228]  = { nil, 1, 16,  57228,  43673,  75, 295, 300, 305,  1,  1, { 43124, 39501, }, { 3, 1, }, },
	[57229]  = { nil, 1, 16,  57229,  43671,  75, 295, 300, 305,  1,  1, { 43124, 39501, }, { 3, 1, }, },
	[57230]  = { nil, 1, 16,  57230,  43672,  75, 295, 300, 305,  1,  1, { 43124, 39501, }, { 3, 1, }, },
	[58347]  = { nil, 1, 16,  58347,  43400,  75, 295, 300, 305,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[56965]  = { nil, 1, 16,  56965,  44922,  75, 355, 360, 365,  1,  1, { 39502, 43126, }, { 1, 3, }, },
	[56990]  = { nil, 1, 16,  56990,  44920,  75, 355, 360, 365,  1,  1, { 39502, 43126, }, { 1, 3, }, },
	[57253]  = { nil, 1, 16,  57253,  44923,  75, 355, 360, 365,  1,  1, { 39502, 43126, }, { 1, 3, }, },
	[58322]  = { nil, 1, 16,  58322,  43374,  75, 355, 360, 365,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[58341]  = { nil, 1, 16,  58341,  43394,  75, 355, 360, 365,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[64312]  = { nil, 1, 16,  64312,  45794,  75, 355, 360, 365,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[68166]  = { nil, 1, 16,  68166,  49084,  75, 355, 360, 365,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[58344]  = { nil, 1, 16,  58344,  43397,  80,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 300, },
	[58346]  = { nil, 1, 16,  58346,  43399,  80,  80,  85,  90,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 300, },
	[58485]  = { nil, 1, 16,  58485,   2289,  80,  80,  85,  90,  1,  1, { 39774, 39354, }, { 1, 1, }, true, 400, },
	[56955]  = { nil, 1, 16,  56955,  40913,  80,  90, 100, 110,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 300, },
	[56976]  = { nil, 1, 16,  56976,  42741,  80,  90, 100, 110,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 300, },
	[57004]  = { nil, 1, 16,  57004,  42907,  80,  90, 100, 110,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 300, },
	[57022]  = { nil, 1, 16,  57022,  41096,  80,  90, 100, 110,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 300, },
	[57114]  = { nil, 1, 16,  57114,  42956,  80,  90, 100, 110,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 300, },
	[57194]  = { nil, 1, 16,  57194,  42408,  80,  90, 100, 110,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 300, },
	[57703]  = { nil, 1, 16,  57703,  43115,  85,  85,  90,  95,  1,  1, { 43103, }, { 1, }, true, 400, },
	[58473]  = { nil, 1, 16,  58473,   1477,  85,  85,  90,  95,  1,  1, { 39774, 39354, }, { 1, 1, }, true, 400, },
	[56963]  = { nil, 1, 16,  56963,  40922,  85,  95, 105, 115,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 300, },
	[57162]  = { nil, 1, 16,  57162,  43413,  85,  95, 105, 115,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 300, },
	[57239]  = { nil, 1, 16,  57239,  41531,  85,  95, 105, 115,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 300, },
	[57259]  = { nil, 1, 16,  57259,  42455,  85,  95, 105, 115,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 300, },
	[48247]  = { nil, 1, 16,  48247,  37168,  85, 125, 137, 150,  1,  1, { 39354, 43115, }, { 1, 1, }, true, 500, },
	[58565]  = { nil, 1, 16,  58565,  43515,  85, 125, 137, 150,  1,  1, { 39354, 43115, }, { 10, 5, }, true, 500, },
	[56961]  = { nil, 1, 16,  56961,  40897,  90, 100, 110, 120,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 400, },
	[56978]  = { nil, 1, 16,  56978,  42743,  90, 100, 110, 120,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 400, },
	[57009]  = { nil, 1, 16,  57009,  42912,  90, 100, 110, 120,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 400, },
	[57027]  = { nil, 1, 16,  57027,  41095,  90, 100, 110, 120,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 400, },
	[57119]  = { nil, 1, 16,  57119,  42960,  95, 105, 115, 125,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 400, },
	[57158]  = { nil, 1, 16,  57158,  43418,  95, 105, 115, 125,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 400, },
	[57196]  = { nil, 1, 16,  57196,  42410,  95, 105, 115, 125,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 400, },
	[57246]  = { nil, 1, 16,  57246,  41537,  95, 105, 115, 125,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 400, },
	[57266]  = { nil, 1, 16,  57266,  42462,  95, 105, 115, 125,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 400, },
	[57704]  = { nil, 1, 16,  57704,  43116, 100, 100, 100, 105,  1,  1, { 39338, }, { 2, }, true, 400, },
	[48121]  = { nil, 1, 16,  48121,  40924, 100, 105, 110, 115,  1,  1, { 43116, 39354, }, { 3, 1, }, true, 400, },
	[56995]  = { nil, 1, 16,  56995,  42898, 100, 105, 110, 115,  1,  1, { 43116, 39354, }, { 3, 1, }, true, 400, },
	[59326]  = { nil, 1, 16,  59326,  43725, 100, 105, 110, 115,  1,  1, { 43116, 39354, }, { 3, 1, }, true, 400, },
	[67600]  = { nil, 1, 16,  67600,  48720, 100, 105, 110, 115,  1,  1, { 39774, 39354, }, { 3, 1, }, true, 400, },
	[57029]  = { nil, 1, 16,  57029,  41106, 105, 110, 115, 120,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 500, },
	[57120]  = { nil, 1, 16,  57120,  42961, 105, 110, 115, 120,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 500, },
	[57184]  = { nil, 1, 16,  57184,  42398, 105, 110, 115, 120,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 500, },
	[57163]  = { nil, 1, 16,  57163,  43423, 110, 115, 120, 125,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 500, },
	[57238]  = { nil, 1, 16,  57238,  41530, 110, 115, 120, 125,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 500, },
	[57265]  = { nil, 1, 16,  57265,  42461, 110, 115, 120, 125,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 500, },
	[56945]  = { nil, 1, 16,  56945,  40914, 115, 120, 125, 130,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 500, },
	[56971]  = { nil, 1, 16,  56971,  42735, 115, 120, 125, 130,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 500, },
	[56997]  = { nil, 1, 16,  56997,  42900, 115, 120, 125, 130,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 500, },
	[57030]  = { nil, 1, 16,  57030,  41092, 120, 125, 130, 135,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 500, },
	[57121]  = { nil, 1, 16,  57121,  42962, 120, 125, 130, 135,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 500, },
	[57186]  = { nil, 1, 16,  57186,  42400, 120, 125, 130, 135,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 500, },
	[94401]  = { nil, 1, 16,  94401,  67487, 120, 125, 130, 135,  1,  1, { 43116, 39354, }, { 3, 1, }, true, 500, },
	[94403]  = { nil, 1, 16,  94403,  67485, 120, 125, 130, 135,  1,  1, { 43116, 39354, }, { 3, 1, }, true, 500, },
	[57706]  = { nil, 1, 16,  57706,  43117, 125, 125, 130, 135,  1,  1, { 43104, }, { 1, }, true, 750, },
	[57157]  = { nil, 1, 16,  57157,  43417, 125, 130, 135, 140,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 750, },
	[57240]  = { nil, 1, 16,  57240,  41532, 125, 130, 135, 140,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 750, },
	[57262]  = { nil, 1, 16,  57262,  42458, 125, 130, 135, 140,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 750, },
	[59475]  = { nil, 1, 16,  59475,  43654, 125, 150, 162, 175,  1,  1, { 43117, 10648, }, { 5, 10, }, true, 750, },
	[59478]  = { nil, 1, 16,  59478,  43655, 125, 150, 162, 175,  1,  1, { 43117, 10648, }, { 5, 10, }, true, 750, },
	[59480]  = { nil, 1, 16,  59480,  44142, 125, 150, 162, 175,  1,  1, { 43117, 10648, }, { 2, 1, }, true, 750, },
	[56951]  = { nil, 1, 16,  56951,  40923, 130, 135, 140, 145,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 750, },
	[56973]  = { nil, 1, 16,  56973,  42737, 130, 135, 140, 145,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 750, },
	[57005]  = { nil, 1, 16,  57005,  42908, 130, 135, 140, 145,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 750, },
	[57031]  = { nil, 1, 16,  57031,  41108, 135, 140, 145, 150,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 750, },
	[57123]  = { nil, 1, 16,  57123,  42964, 135, 140, 145, 150,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 750, },
	[57188]  = { nil, 1, 16,  57188,  42402, 135, 140, 145, 150,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 750, },
	[57167]  = { nil, 1, 16,  57167,  43427, 140, 145, 150, 155,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 750, },
	[57245]  = { nil, 1, 16,  57245,  41536, 140, 145, 150, 155,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 750, },
	[57269]  = { nil, 1, 16,  57269,  42465, 140, 145, 150, 155,  1,  1, { 43116, 10648, }, { 3, 1, }, true, 750, },
	[57707]  = { nil, 1, 16,  57707,  43118, 150, 150, 150, 155,  1,  1, { 39339, }, { 2, }, true, 750, },
	[56948]  = { nil, 1, 16,  56948,  40919, 150, 155, 160, 165,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 750, },
	[57007]  = { nil, 1, 16,  57007,  42910, 150, 155, 160, 165,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 750, },
	[94404]  = { nil, 1, 16,  94404,  67486, 150, 155, 160, 165,  1,  1, { 43118, 39354, }, { 3, 1, }, true, 750, },
	[94405]  = { nil, 1, 16,  94405,  67483, 150, 155, 160, 165,  1,  1, { 43118, 39354, }, { 3, 1, }, true, 750, },
	[57032]  = { nil, 1, 16,  57032,  41100, 155, 155, 160, 165,  1,  1, { 43118, 10648, }, { 3, 1, }, },
	[50614]  = { nil, 1, 16,  50614,   4422, 155, 160, 165, 170,  2,  2, { 43118, 10648, }, { 1, 2, }, true, 750, },
	[56974]  = { nil, 1, 16,  56974,  42738, 155, 160, 165, 170,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 750, },
	[50606]  = { nil, 1, 16,  50606,   4424, 160, 165, 170, 175,  2,  2, { 43118, 10648, }, { 1, 2, }, true, 750, },
	[57125]  = { nil, 1, 16,  57125,  42966, 160, 165, 170, 175,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 750, },
	[57197]  = { nil, 1, 16,  57197,  42411, 160, 165, 170, 175,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 750, },
	[50599]  = { nil, 1, 16,  50599,   4419, 165, 170, 175, 180,  5,  5, { 43118, 10648, }, { 1, 2, }, true, 750, },
	[57249]  = { nil, 1, 16,  57249,  41540, 165, 170, 175, 180,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 750, },
	[57271]  = { nil, 1, 16,  57271,  42467, 165, 170, 175, 180,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 750, },
	[56953]  = { nil, 1, 16,  56953,  40909, 170, 175, 180, 185,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 1000, },
	[57161]  = { nil, 1, 16,  57161,  43422, 170, 175, 180, 185,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 1000, },
	[58486]  = { nil, 1, 16,  58486,   4426, 170, 175, 180, 185,  5,  5, { 43118, 10648, }, { 1, 2, }, true, 750, },
	[57708]  = { nil, 1, 16,  57708,  43119, 175, 175, 175, 180,  1,  1, { 43105, }, { 1, }, true, 750, },
	[56981]  = { nil, 1, 16,  56981,  42746, 175, 180, 185, 190,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 1000, },
	[56994]  = { nil, 1, 16,  56994,  42897, 175, 180, 185, 190,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 1000, },
	[58476]  = { nil, 1, 16,  58476,   4425, 175, 180, 185, 190,  5,  5, { 43118, 10648, }, { 1, 2, }, true, 750, },
	[59484]  = { nil, 1, 16,  59484,  43656, 175, 200, 205, 210,  1,  1, { 43119, 10648, }, { 5, 10, }, true, 750, },
	[59486]  = { nil, 1, 16,  59486,  43657, 175, 200, 205, 210,  1,  1, { 43119, 10648, }, { 5, 10, }, true, 750, },
	[59487]  = { nil, 1, 16,  59487,  44161, 175, 200, 205, 210,  1,  1, { 43119, 10648, }, { 2, 1, }, true, 750, },
	[57020]  = { nil, 1, 16,  57020,  41104, 180, 185, 190, 195,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 1000, },
	[57200]  = { nil, 1, 16,  57200,  42415, 180, 185, 190, 195,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 1000, },
	[92579]  = { nil, 1, 16,  92579,  64493, 180, 185, 190, 195,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 1000, },
	[57129]  = { nil, 1, 16,  57129,  42970, 185, 190, 195, 200,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 3000, },
	[57241]  = { nil, 1, 16,  57241,  41547, 185, 190, 195, 200,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 3000, },
	[57165]  = { nil, 1, 16,  57165,  43424, 190, 195, 200, 205,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 3000, },
	[57277]  = { nil, 1, 16,  57277,  42473, 190, 195, 200, 205,  1,  1, { 43118, 10648, }, { 3, 1, }, true, 3000, },
	[57709]  = { nil, 1, 16,  57709,  43120, 200, 200, 200, 205,  1,  1, { 39340, }, { 2, }, true, 3000, },
	[56956]  = { nil, 1, 16,  56956,  40902, 200, 205, 210, 215,  1,  1, { 43120, 10648, }, { 3, 1, }, true, 3000, },
	[57000]  = { nil, 1, 16,  57000,  42903, 200, 205, 210, 215,  1,  1, { 43120, 10648, }, { 3, 1, }, true, 3000, },
	[59387]  = { nil, 1, 16,  59387,  43850, 200, 205, 210, 215,  1,  1, { 43120, 10648, }, { 2, 1, }, true, 3000, },
	[60336]  = { nil, 1, 16,  60336,  44314, 200, 215, 220, 225,  1,  1, { 10648, 43120, }, { 1, 1, }, true, 3000, },
	[50616]  = { nil, 1, 16,  50616,  10307, 205, 210, 215, 220,  2,  2, { 43120, 39501, }, { 1, 2, }, true, 4500, },
	[57023]  = { nil, 1, 16,  57023,  41099, 205, 210, 215, 220,  1,  1, { 43120, 39501, }, { 3, 1, }, true, 4500, },
	[50607]  = { nil, 1, 16,  50607,  10306, 210, 215, 220, 225,  2,  2, { 43120, 39501, }, { 1, 2, }, true, 4500, },
	[57131]  = { nil, 1, 16,  57131,  42972, 210, 215, 220, 225,  1,  1, { 43120, 39501, }, { 3, 1, }, true, 4500, },
	[57201]  = { nil, 1, 16,  57201,  42416, 210, 215, 220, 225,  1,  1, { 43120, 39501, }, { 3, 1, }, true, 4500, },
	[50600]  = { nil, 1, 16,  50600,  10308, 215, 220, 225, 230,  2,  2, { 43120, 39501, }, { 1, 2, }, true, 4500, },
	[57242]  = { nil, 1, 16,  57242,  41533, 215, 220, 225, 230,  1,  1, { 43120, 39501, }, { 3, 1, }, true, 4500, },
	[57270]  = { nil, 1, 16,  57270,  42466, 215, 220, 225, 230,  1,  1, { 43120, 39501, }, { 3, 1, }, true, 4500, },
	[56959]  = { nil, 1, 16,  56959,  40916, 220, 225, 230, 235,  1,  1, { 43120, 39501, }, { 3, 1, }, true, 4500, },
	[58487]  = { nil, 1, 16,  58487,  10310, 220, 225, 230, 235,  2,  2, { 43120, 39501, }, { 1, 2, }, true, 4500, },
	[57710]  = { nil, 1, 16,  57710,  43121, 225, 225, 225, 230,  1,  1, { 43106, }, { 1, }, true, 6000, },
	[56979]  = { nil, 1, 16,  56979,  42744, 225, 230, 235, 240,  1,  1, { 43120, 39501, }, { 3, 1, }, true, 6000, },
	[57001]  = { nil, 1, 16,  57001,  42904, 225, 230, 235, 240,  1,  1, { 43120, 39501, }, { 3, 1, }, true, 6000, },
	[58478]  = { nil, 1, 16,  58478,  10309, 225, 230, 235, 240,  2,  2, { 43120, 39501, }, { 1, 2, }, true, 4500, },
	[59489]  = { nil, 1, 16,  59489,  43660, 225, 250, 255, 260,  1,  1, { 43121, 39501, }, { 5, 10, }, true, 6000, },
	[59490]  = { nil, 1, 16,  59490,  43661, 225, 250, 255, 260,  1,  1, { 43121, 39501, }, { 5, 10, }, true, 6000, },
	[59491]  = { nil, 1, 16,  59491,  44163, 225, 250, 255, 260,  1,  1, { 43121, 39501, }, { 2, 1, }, true, 6000, },
	[57024]  = { nil, 1, 16,  57024,  41098, 230, 235, 240, 245,  1,  1, { 43120, 39501, }, { 3, 1, }, true, 6000, },
	[57183]  = { nil, 1, 16,  57183,  42397, 230, 235, 240, 245,  1,  1, { 43120, 39501, }, { 3, 1, }, true, 6000, },
	[57132]  = { nil, 1, 16,  57132,  42973, 235, 240, 245, 250,  1,  1, { 43120, 39501, }, { 3, 1, }, true, 6000, },
	[57244]  = { nil, 1, 16,  57244,  41535, 235, 240, 245, 250,  1,  1, { 43120, 39501, }, { 3, 1, }, true, 6000, },
	[57154]  = { nil, 1, 16,  57154,  43414, 240, 245, 250, 255,  1,  1, { 43120, 39501, }, { 3, 1, }, true, 7500, },
	[57274]  = { nil, 1, 16,  57274,  42470, 240, 245, 250, 255,  1,  1, { 43120, 39501, }, { 3, 1, }, true, 7500, },
	[57711]  = { nil, 1, 16,  57711,  43122, 250, 250, 250, 255,  1,  1, { 39341, }, { 2, }, true, 10000, },
	[50617]  = { nil, 1, 16,  50617,  27502, 250, 255, 260, 265,  2,  2, { 43122, 39501, }, { 1, 2, }, true, 10000, },
	[71101]  = { nil, 1, 16,  71101,  50045, 250, 255, 260, 265,  1,  1, { 43124, 39502, }, { 3, 1, }, nil, nil, { 50166, }, },
	[94406]  = { nil, 1, 16,  94406,  67482, 250, 255, 260, 265,  1,  1, { 43122, 39354, }, { 3, 1, }, true, 10000, },
	[64258]  = { nil, 1, 16,  64258,  45622, 250, 255, 262, 270,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 10000, },
	[64261]  = { nil, 1, 16,  64261,  45775, 250, 255, 262, 270,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 10000, },
	[64259]  = { nil, 1, 16,  64259,  45760, 255, 255, 262, 270,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 10000, },
	[64260]  = { nil, 1, 16,  64260,  45768, 255, 255, 262, 270,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 10000, },
	[64262]  = { nil, 1, 16,  64262,  45776, 255, 255, 262, 270,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 10000, },
	[50608]  = { nil, 1, 16,  50608,  27501, 255, 260, 265, 270,  2,  2, { 43122, 39501, }, { 1, 2, }, true, 10000, },
	[50601]  = { nil, 1, 16,  50601,  27499, 260, 265, 270, 275,  2,  2, { 43122, 39501, }, { 1, 2, }, true, 10000, },
	[56957]  = { nil, 1, 16,  56957,  40901, 260, 265, 270, 275,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 10000, },
	[57002]  = { nil, 1, 16,  57002,  42905, 260, 265, 270, 275,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 10000, },
	[57025]  = { nil, 1, 16,  57025,  41103, 265, 270, 275, 280,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 10000, },
	[57210]  = { nil, 1, 16,  57210,  43536, 265, 270, 275, 280,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 10000, },
	[58488]  = { nil, 1, 16,  58488,  27503, 265, 270, 275, 280,  2,  2, { 43122, 39501, }, { 1, 2, }, true, 10000, },
	[57185]  = { nil, 1, 16,  57185,  42399, 270, 275, 280, 285,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 10000, },
	[57216]  = { nil, 1, 16,  57216,  43543, 270, 275, 280, 285,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 10000, },
	[58480]  = { nil, 1, 16,  58480,  27498, 270, 275, 280, 285,  2,  2, { 43122, 39501, }, { 1, 2, }, true, 10000, },
	[57251]  = { nil, 1, 16,  57251,  41541, 275, 280, 285, 290,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 10000, },
	[57272]  = { nil, 1, 16,  57272,  42468, 275, 280, 285, 290,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 10000, },
	[64266]  = { nil, 1, 16,  64266,  45804, 275, 280, 287, 295,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 10000, },
	[96284]  = { nil, 1, 16,  96284,  68793, 275, 280, 287, 295,  1,  1, { 43124, 39501, }, { 3, 1, }, true, 10000, },
	[57712]  = { nil, 1, 16,  57712,  43123, 275, 290, 295, 300,  1,  1, { 43107, }, { 1, }, true, 10000, },
	[59493]  = { nil, 1, 16,  59493,  43663, 275, 290, 295, 300,  1,  1, { 43123, 39501, }, { 8, 10, }, true, 10000, },
	[59494]  = { nil, 1, 16,  59494,  43664, 275, 290, 295, 300,  1,  1, { 43123, 39501, }, { 8, 10, }, true, 10000, },
	[59502]  = { nil, 1, 16,  59502,  44316, 275, 290, 295, 300,  1,  1, { 43123, 39501, }, { 5, 1, }, true, 10000, },
	[57219]  = { nil, 1, 16,  57219,  43546, 280, 285, 290, 295,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 10000, },
	[57133]  = { nil, 1, 16,  57133,  42974, 285, 290, 295, 300,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 15000, },
	[57156]  = { nil, 1, 16,  57156,  43416, 285, 290, 295, 300,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 15000, },
	[57213]  = { nil, 1, 16,  57213,  43541, 285, 290, 295, 300,  1,  1, { 43122, 39501, }, { 3, 1, }, true, 15000, },
	[57713]  = { nil, 1, 16,  57713,  43124, 290, 295, 300, 305,  1,  1, { 39342, }, { 2, }, true, 20000, },
	[50618]  = { nil, 1, 16,  50618,  33461, 290, 300, 305, 310,  2,  2, { 43122, 39501, }, { 1, 2, }, true, 20000, },
	[50609]  = { nil, 1, 16,  50609,  33460, 295, 305, 310, 315,  2,  2, { 43122, 39501, }, { 1, 2, }, true, 20000, },
	[57026]  = { nil, 1, 16,  57026,  41105, 300, 305, 310, 315,  1,  1, { 43124, 39501, }, { 3, 1, }, true, 20000, },
	[57221]  = { nil, 1, 16,  57221,  43548, 300, 305, 310, 315,  1,  1, { 43124, 39501, }, { 3, 1, }, true, 20000, },
	[57236]  = { nil, 1, 16,  57236,  41527, 300, 305, 310, 315,  1,  1, { 43124, 39501, }, { 3, 1, }, true, 20000, },
	[50602]  = { nil, 1, 16,  50602,  33458, 300, 310, 315, 320,  2,  2, { 43124, 39501, }, { 1, 2, }, true, 20000, },
	[57122]  = { nil, 1, 16,  57122,  42963, 305, 310, 315, 320,  1,  1, { 43124, 39501, }, { 3, 1, }, true, 20000, },
	[57226]  = { nil, 1, 16,  57226,  43553, 305, 310, 315, 320,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 20000, },
	[58489]  = { nil, 1, 16,  58489,  33462, 305, 315, 320, 325,  2,  2, { 43124, 39501, }, { 1, 2, }, true, 20000, },
	[56952]  = { nil, 1, 16,  56952,  40903, 310, 315, 320, 325,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 20000, },
	[59338]  = { nil, 1, 16,  59338,  43825, 310, 315, 320, 325,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 20000, },
	[58481]  = { nil, 1, 16,  58481,  33457, 310, 320, 325, 330,  2,  2, { 43124, 39501, }, { 1, 2, }, true, 20000, },
	[56991]  = { nil, 1, 16,  56991,  44955, 315, 320, 325, 330,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 20000, },
	[57008]  = { nil, 1, 16,  57008,  42911, 315, 320, 325, 330,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 20000, },
	[57187]  = { nil, 1, 16,  57187,  42401, 315, 320, 325, 330,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 20000, },
	[57168]  = { nil, 1, 16,  57168,  43428, 320, 325, 330, 335,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 20000, },
	[59339]  = { nil, 1, 16,  59339,  43826, 320, 325, 330, 335,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 20000, },
	[57714]  = { nil, 1, 16,  57714,  43125, 325, 325, 325, 330,  1,  1, { 43108, }, { 1, }, true, 20000, },
	[56984]  = { nil, 1, 16,  56984,  42749, 325, 330, 335, 340,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 30000, },
	[57275]  = { nil, 1, 16,  57275,  42471, 325, 330, 335, 340,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 30000, },
	[59495]  = { nil, 1, 16,  59495,  43666, 325, 340, 345, 350,  1,  1, { 43125, 39502, }, { 6, 10, }, true, 20000, },
	[59496]  = { nil, 1, 16,  59496,  43667, 325, 340, 345, 350,  1,  1, { 43125, 39502, }, { 6, 10, }, true, 20000, },
	[59503]  = { nil, 1, 16,  59503,  44317, 325, 350, 365, 380,  1,  1, { 43125, 39502, 21886, }, { 3, 1, 3, }, true, 20000, },
	[57224]  = { nil, 1, 16,  57224,  43551, 330, 335, 340, 345,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 30000, },
	[57252]  = { nil, 1, 16,  57252,  41542, 330, 335, 340, 345,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 30000, },
	[94402]  = { nil, 1, 16,  94402,  67484, 330, 335, 340, 345,  1,  1, { 43124, 39354, }, { 3, 1, }, true, 30000, },
	[56972]  = { nil, 1, 16,  56972,  42736, 335, 340, 345, 350,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 30000, },
	[57033]  = { nil, 1, 16,  57033,  41094, 335, 340, 345, 350,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 30000, },
	[57113]  = { nil, 1, 16,  57113,  42955, 340, 345, 350, 355,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 30000, },
	[59340]  = { nil, 1, 16,  59340,  43827, 340, 345, 350, 355,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 30000, },
	[57172]  = { nil, 1, 16,  57172,  43432, 345, 350, 355, 360,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 30000, },
	[57227]  = { nil, 1, 16,  57227,  43554, 345, 350, 355, 360,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 30000, },
	[57715]  = { nil, 1, 16,  57715,  43126, 350, 350, 350, 355,  1,  1, { 39343, }, { 2, }, true, 50000, },
	[50619]  = { nil, 1, 16,  50619,  37093, 350, 355, 360, 365,  2,  2, { 43126, 39502, }, { 1, 2, }, true, 50000, },
	[56943]  = { nil, 1, 16,  56943,  40896, 350, 355, 360, 365,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 30000, },
	[57003]  = { nil, 1, 16,  57003,  42906, 350, 355, 360, 365,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 30000, },
	[57192]  = { nil, 1, 16,  57192,  42406, 350, 355, 360, 365,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 30000, },
	[57222]  = { nil, 1, 16,  57222,  43549, 350, 355, 360, 365,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 30000, },
	[57257]  = { nil, 1, 16,  57257,  42453, 350, 355, 360, 365,  1,  1, { 43124, 39502, }, { 3, 1, }, true, 30000, },
	[60337]  = { nil, 1, 16,  60337,  44315, 350, 355, 360, 365,  1,  1, { 43126, 39502, }, { 1, 1, }, true, 50000, },
	[64051]  = { nil, 1, 16,  64051,  45854, 350, 375, 387, 400,  1,  1, { 43126, 39502, 35627, }, { 5, 10, 3, }, nil, nil, { 46108, }, },
	[64053]  = { nil, 1, 16,  64053,  45849, 350, 375, 387, 400,  1,  1, { 43126, 39502, 35625, }, { 5, 10, 2, }, true, 50000, },
	[64255]  = { nil, 1, 16,  64255,  45793, 355, 355, 360, 365,  1,  1, { 43126, 10648, }, { 3, 1, }, },
	[50610]  = { nil, 1, 16,  50610,  37097, 355, 360, 365, 370,  2,  2, { 43126, 39502, }, { 1, 2, }, true, 50000, },
	[50603]  = { nil, 1, 16,  50603,  37091, 360, 365, 370, 375,  2,  2, { 43126, 39502, }, { 1, 2, }, true, 50000, },
	[58490]  = { nil, 1, 16,  58490,  43465, 365, 370, 375, 380,  2,  2, { 43126, 39502, }, { 1, 2, }, true, 50000, },
	[58482]  = { nil, 1, 16,  58482,  43463, 370, 375, 380, 385,  2,  2, { 43126, 39502, }, { 1, 2, }, true, 50000, },
	[57716]  = { nil, 1, 16,  57716,  43127, 375, 375, 375, 380,  1,  1, { 43109, }, { 2, }, true, 50000, },
	[71102]  = { nil, 1, 16,  71102,  50077, 375, 380, 382, 385,  1,  1, { 43126, 39502, }, { 3, 1, }, nil, nil, { 50168, }, },
	[56980]  = { nil, 1, 16,  56980,  42745, 375, 380, 385, 390,  1,  1, { 43126, 39502, }, { 3, 1, }, true, 50000, },
	[57006]  = { nil, 1, 16,  57006,  42909, 375, 380, 385, 390,  1,  1, { 43126, 39502, }, { 3, 1, }, true, 50000, },
	[57036]  = { nil, 1, 16,  57036,  41102, 375, 380, 385, 390,  1,  1, { 43126, 39502, }, { 3, 1, }, true, 50000, },
	[57198]  = { nil, 1, 16,  57198,  42412, 375, 380, 385, 390,  1,  1, { 43126, 39502, }, { 3, 1, }, true, 50000, },
	[57225]  = { nil, 1, 16,  57225,  43552, 375, 380, 385, 390,  1,  1, { 43126, 39502, }, { 3, 1, }, true, 50000, },
	[57248]  = { nil, 1, 16,  57248,  41539, 375, 380, 385, 390,  1,  1, { 43126, 39502, }, { 3, 1, }, true, 50000, },
	[62162]  = { nil, 1, 16,  62162,  44928, 375, 380, 385, 390,  1,  1, { 43126, 39502, }, { 3, 1, }, true, 50000, },
	[57153]  = { nil, 1, 16,  57153,  43412, 385, 385, 385, 385,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57234]  = { nil, 1, 16,  57234,  41524, 385, 390, 395, 400,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56944]  = { nil, 1, 16,  56944,  40899, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56946]  = { nil, 1, 16,  56946,  40920, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56947]  = { nil, 1, 16,  56947,  40908, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56949]  = { nil, 1, 16,  56949,  40915, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56950]  = { nil, 1, 16,  56950,  40900, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56954]  = { nil, 1, 16,  56954,  40912, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56958]  = { nil, 1, 16,  56958,  40921, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56960]  = { nil, 1, 16,  56960,  40906, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56975]  = { nil, 1, 16,  56975,  42739, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56977]  = { nil, 1, 16,  56977,  42742, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56983]  = { nil, 1, 16,  56983,  42748, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56986]  = { nil, 1, 16,  56986,  42751, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56988]  = { nil, 1, 16,  56988,  42753, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56989]  = { nil, 1, 16,  56989,  42754, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56996]  = { nil, 1, 16,  56996,  42899, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56998]  = { nil, 1, 16,  56998,  42901, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56999]  = { nil, 1, 16,  56999,  42902, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57010]  = { nil, 1, 16,  57010,  42913, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57011]  = { nil, 1, 16,  57011,  42914, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57012]  = { nil, 1, 16,  57012,  42915, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57014]  = { nil, 1, 16,  57014,  42917, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57019]  = { nil, 1, 16,  57019,  41101, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57021]  = { nil, 1, 16,  57021,  41107, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57028]  = { nil, 1, 16,  57028,  41097, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57034]  = { nil, 1, 16,  57034,  41110, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57035]  = { nil, 1, 16,  57035,  41109, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57112]  = { nil, 1, 16,  57112,  42954, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57115]  = { nil, 1, 16,  57115,  42957, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57116]  = { nil, 1, 16,  57116,  42958, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57117]  = { nil, 1, 16,  57117,  42959, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57124]  = { nil, 1, 16,  57124,  42965, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57126]  = { nil, 1, 16,  57126,  42967, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57127]  = { nil, 1, 16,  57127,  42968, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57128]  = { nil, 1, 16,  57128,  42969, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57130]  = { nil, 1, 16,  57130,  42971, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57152]  = { nil, 1, 16,  57152,  43425, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57155]  = { nil, 1, 16,  57155,  43415, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57159]  = { nil, 1, 16,  57159,  43419, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57160]  = { nil, 1, 16,  57160,  43421, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57164]  = { nil, 1, 16,  57164,  43430, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57170]  = { nil, 1, 16,  57170,  43431, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57181]  = { nil, 1, 16,  57181,  42396, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57189]  = { nil, 1, 16,  57189,  42403, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57190]  = { nil, 1, 16,  57190,  42404, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57191]  = { nil, 1, 16,  57191,  42405, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57193]  = { nil, 1, 16,  57193,  42407, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57195]  = { nil, 1, 16,  57195,  42409, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57199]  = { nil, 1, 16,  57199,  42414, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57202]  = { nil, 1, 16,  57202,  42417, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57207]  = { nil, 1, 16,  57207,  43533, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57208]  = { nil, 1, 16,  57208,  43534, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57211]  = { nil, 1, 16,  57211,  43537, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57214]  = { nil, 1, 16,  57214,  43542, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57220]  = { nil, 1, 16,  57220,  43547, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57223]  = { nil, 1, 16,  57223,  43550, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57232]  = { nil, 1, 16,  57232,  41517, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57233]  = { nil, 1, 16,  57233,  41518, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57235]  = { nil, 1, 16,  57235,  41526, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57237]  = { nil, 1, 16,  57237,  41529, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57243]  = { nil, 1, 16,  57243,  41534, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57247]  = { nil, 1, 16,  57247,  41538, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57250]  = { nil, 1, 16,  57250,  41552, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57258]  = { nil, 1, 16,  57258,  42454, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57260]  = { nil, 1, 16,  57260,  42456, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57261]  = { nil, 1, 16,  57261,  42457, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57263]  = { nil, 1, 16,  57263,  42459, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57264]  = { nil, 1, 16,  57264,  42460, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57267]  = { nil, 1, 16,  57267,  42463, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57268]  = { nil, 1, 16,  57268,  42464, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[57276]  = { nil, 1, 16,  57276,  42472, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[59559]  = { nil, 1, 16,  59559,  43867, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[59560]  = { nil, 1, 16,  59560,  43868, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[59561]  = { nil, 1, 16,  59561,  43869, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[61677]  = { nil, 1, 16,  61677,  44684, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[94000]  = { nil, 1, 16,  94000,  63539, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[95825]  = { nil, 1, 16,  95825,  66918, 385, 390, 397, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[61177]  = { nil, 1, 16,  61177,    nil, 385, 425, 437, 450,  0,  0, { 43126, 43127, 39502, }, { 3, 1, 5, }, true, 100000, },
	[94711]  = { nil, 1, 16,  94711,  63420, 385, 430, 435, 440,  1,  1, { 43124, 10648, }, { 3, 1, }, },
	[98398]  = { nil, 1, 16,  98398,  69773, 385, 430, 435, 440,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[101057] = { nil, 1, 16, 101057,  71155, 385, 430, 435, 440,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[56987]  = { nil, 1, 16,  56987,  42752, 400, 400, 400, 405,  1,  1, { 43126, 39502, }, { 3, 1, }, true, 60000, },
	[61117]  = { nil, 1, 16,  61117,    nil, 400, 400, 400, 405,  0,  0, { 43127, }, { 1, }, true, 75000, },
	[61118]  = { nil, 1, 16,  61118,    nil, 400, 400, 400, 405,  0,  0, { 43127, }, { 1, }, true, 75000, },
	[61119]  = { nil, 1, 16,  61119,    nil, 400, 400, 400, 405,  0,  0, { 43127, }, { 1, }, true, 75000, },
	[61120]  = { nil, 1, 16,  61120,    nil, 400, 400, 400, 405,  0,  0, { 43127, }, { 1, }, true, 75000, },
	[50620]  = { nil, 1, 16,  50620,  37094, 400, 405, 410, 415,  2,  2, { 43126, 39502, }, { 1, 2, }, true, 60000, },
	[59497]  = { nil, 1, 16,  59497,  38322, 400, 425, 437, 450,  1,  1, { 43127, 39502, 43102, }, { 5, 10, 1, }, true, 60000, },
	[59498]  = { nil, 1, 16,  59498,  44210, 400, 425, 437, 450,  1,  1, { 43127, 39502, 43102, }, { 5, 10, 1, }, true, 60000, },
	[59504]  = { nil, 1, 16,  59504,  44318, 400, 450, 462, 475,  1,  1, { 39502, 43127, 35625, }, { 1, 6, 1, }, true, 60000, },
	[50611]  = { nil, 1, 16,  50611,  37098, 405, 410, 415, 420,  2,  2, { 43126, 39502, }, { 1, 2, }, true, 60000, },
	[50604]  = { nil, 1, 16,  50604,  37092, 410, 415, 420, 425,  2,  2, { 43126, 39502, }, { 1, 2, }, true, 60000, },
	[58491]  = { nil, 1, 16,  58491,  43466, 415, 420, 425, 430,  2,  2, { 43126, 39502, }, { 1, 2, }, true, 60000, },
	[58483]  = { nil, 1, 16,  58483,  43464, 420, 425, 430, 435,  2,  2, { 43126, 39502, }, { 1, 2, }, true, 60000, },
	[86004]  = { nil, 1, 16,  86004,  61978, 425, 440, 445, 450,  1,  1, { 61979, }, { 2, }, true, 80000, },
	[64246]  = { nil, 1, 16,  64246,  45735, 430, 430, 435, 440,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[64247]  = { nil, 1, 16,  64247,  45778, 430, 430, 435, 440,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[64248]  = { nil, 1, 16,  64248,  45785, 430, 430, 435, 440,  1,  1, { 39774, 39354, }, { 3, 1, }, },
	[64249]  = { nil, 1, 16,  64249,  45734, 430, 430, 435, 440,  1,  1, { 43116, 39354, }, { 3, 1, }, },
	[64250]  = { nil, 1, 16,  64250,  45789, 430, 430, 435, 440,  1,  1, { 43116, 39354, }, { 3, 1, }, },
	[64251]  = { nil, 1, 16,  64251,  45747, 430, 430, 435, 440,  1,  1, { 43116, 10648, }, { 3, 1, }, },
	[64252]  = { nil, 1, 16,  64252,  45797, 430, 430, 435, 440,  1,  1, { 43116, 10648, }, { 3, 1, }, },
	[64253]  = { nil, 1, 16,  64253,  45733, 430, 430, 435, 440,  1,  1, { 43118, 10648, }, { 3, 1, }, },
	[64254]  = { nil, 1, 16,  64254,  45746, 430, 430, 435, 440,  1,  1, { 43120, 10648, }, { 3, 1, }, },
	[64256]  = { nil, 1, 16,  64256,  45623, 430, 430, 435, 440,  1,  1, { 43120, 39501, }, { 3, 1, }, },
	[64257]  = { nil, 1, 16,  64257,  45740, 430, 430, 435, 440,  1,  1, { 43120, 39501, }, { 3, 1, }, },
	[64268]  = { nil, 1, 16,  64268,  45601, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64270]  = { nil, 1, 16,  64270,  45602, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64271]  = { nil, 1, 16,  64271,  45625, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64273]  = { nil, 1, 16,  64273,  45731, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64274]  = { nil, 1, 16,  64274,  45736, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64275]  = { nil, 1, 16,  64275,  45737, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64276]  = { nil, 1, 16,  64276,  45738, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64277]  = { nil, 1, 16,  64277,  45741, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64278]  = { nil, 1, 16,  64278,  45742, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64279]  = { nil, 1, 16,  64279,  45743, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64280]  = { nil, 1, 16,  64280,  45753, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64281]  = { nil, 1, 16,  64281,  45755, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64282]  = { nil, 1, 16,  64282,  45756, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64283]  = { nil, 1, 16,  64283,  45758, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64284]  = { nil, 1, 16,  64284,  45761, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64285]  = { nil, 1, 16,  64285,  45762, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64286]  = { nil, 1, 16,  64286,  45764, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64287]  = { nil, 1, 16,  64287,  45770, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64288]  = { nil, 1, 16,  64288,  45771, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64289]  = { nil, 1, 16,  64289,  45772, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64291]  = { nil, 1, 16,  64291,  45779, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64294]  = { nil, 1, 16,  64294,  45781, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64295]  = { nil, 1, 16,  64295,  45790, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64296]  = { nil, 1, 16,  64296,  45792, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64297]  = { nil, 1, 16,  64297,  45799, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64298]  = { nil, 1, 16,  64298,  45800, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64300]  = { nil, 1, 16,  64300,  45806, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64302]  = { nil, 1, 16,  64302,  45795, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64303]  = { nil, 1, 16,  64303,  45769, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[64304]  = { nil, 1, 16,  64304,  45732, 430, 430, 435, 440,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[64305]  = { nil, 1, 16,  64305,  45745, 430, 430, 435, 440,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[64307]  = { nil, 1, 16,  64307,  45604, 430, 430, 435, 440,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[64308]  = { nil, 1, 16,  64308,  45744, 430, 430, 435, 440,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[64309]  = { nil, 1, 16,  64309,  45757, 430, 430, 435, 440,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[64310]  = { nil, 1, 16,  64310,  45767, 430, 430, 435, 440,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[64311]  = { nil, 1, 16,  64311,  45783, 430, 430, 435, 440,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[64313]  = { nil, 1, 16,  64313,  45603, 430, 430, 435, 440,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[64314]  = { nil, 1, 16,  64314,  45739, 430, 430, 435, 440,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[64315]  = { nil, 1, 16,  64315,  45766, 430, 430, 435, 440,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[64316]  = { nil, 1, 16,  64316,  45777, 430, 430, 435, 440,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[64317]  = { nil, 1, 16,  64317,  45782, 430, 430, 435, 440,  1,  1, { 43126, 39502, }, { 3, 1, }, },
	[64318]  = { nil, 1, 16,  64318,  45780, 430, 430, 435, 440,  1,  1, { 43124, 39502, }, { 3, 1, }, },
	[69385]  = { nil, 1, 16,  69385,  49632, 440, 440, 442, 460,  5,  5, { 43127, 39502, }, { 1, 5, }, true, 120000, },
	[89368]  = { nil, 1, 16,  89368,  63305, 445, 450, 455, 460,  5,  5, { 39502, 61978, }, { 2, 1, }, true, 80000, },
	[89373]  = { nil, 1, 16,  89373,  63308, 450, 455, 460, 465,  5,  5, { 39502, 61978, }, { 2, 1, }, true, 80000, },
	[86609]  = { nil, 1, 16,  86609,  60838, 450, 460, 467, 475,  1,  1, { 39502, 61978, }, { 1, 1, }, true, 80000, },
	[89371]  = { nil, 1, 16,  89371,  63307, 455, 460, 465, 470,  5,  5, { 39502, 61978, }, { 2, 1, }, true, 80000, },
	[89372]  = { nil, 1, 16,  89372,  63306, 460, 465, 470, 475,  5,  5, { 39502, 61978, }, { 2, 1, }, true, 80000, },
	[89367]  = { nil, 1, 16,  89367,  62237, 460, 475, 480, 485,  1,  1, { 39502, 61978, }, { 4, 1, }, true, 80000, },
	[89369]  = { nil, 1, 16,  89369,  63304, 465, 470, 475, 480,  5,  5, { 39502, 61978, }, { 2, 1, }, true, 80000, },
	[89815]  = { nil, 1, 16,  89815,  63481, 465, 470, 477, 485,  1,  1, { 61978, 10648, }, { 3, 1, }, nil, nil, { 68810, }, },
	[89370]  = { nil, 1, 16,  89370,  63303, 470, 475, 480, 485,  5,  5, { 39502, 61978, }, { 2, 1, }, true, 80000, },
	[92027]  = { nil, 1, 16,  92027,  63388, 475, 475, 487, 500,  3,  3, { 61978, }, { 1, }, true, 90000, },
	[86005]  = { nil, 1, 16,  86005,  61981, 475, 480, 482, 485,  1,  1, { 61980, }, { 2, }, true, 90000, },
	[86616]  = { nil, 1, 16,  86616,  62231, 475, 485, 487, 490,  1,  1, { 39502, 61981, 52329, }, { 10, 3, 6, }, true, 90000, },
	[86640]  = { nil, 1, 16,  86640,  62233, 475, 485, 487, 490,  1,  1, { 39502, 52329, }, { 10, 20, }, true, 90000, },
	[86644]  = { nil, 1, 16,  86644,  62239, 480, 480, 480, 490,  1,  1, { 39502, }, { 3, }, nil, nil, { 65649, }, },
	[86647]  = { nil, 1, 16,  86647,  62240, 480, 500, 502, 505,  1,  1, { 61981, 68047, }, { 4, 1, }, true, 90000, },
	[86648]  = { nil, 1, 16,  86648,  62241, 480, 500, 502, 505,  1,  1, { 39502, 61981, 52326, 52328, 52327, 52325, }, { 10, 2, 2, 2, 2, 2, }, true, 90000, },
	[86645]  = { nil, 1, 16,  86645,  62238, 490, 490, 490, 500,  1,  1, { 39502, }, { 3, }, nil, nil, { 65650, }, },
	[86375]  = { nil, 1, 16,  86375,    nil, 500, 500, 500, 505,  0,  0, { 61978, }, { 4, }, true, 75000, },
	[86401]  = { nil, 1, 16,  86401,    nil, 500, 500, 500, 505,  0,  0, { 61978, }, { 4, }, true, 75000, },
	[86402]  = { nil, 1, 16,  86402,    nil, 500, 500, 500, 505,  0,  0, { 61978, }, { 4, }, true, 75000, },
	[86403]  = { nil, 1, 16,  86403,    nil, 500, 500, 500, 505,  0,  0, { 61978, }, { 4, }, true, 75000, },
	[86646]  = { nil, 1, 16,  86646,  63246, 500, 500, 500, 510,  1,  1, { 39502, }, { 3, }, nil, nil, { 65651, }, },
	[85785]  = { nil, 1, 16,  85785,  62251, 500, 505, 510, 515,  5,  5, { 61981, 39502, }, { 5, 5, }, true, 120000, },
	[89244]  = { nil, 1, 16,  89244,  62056, 500, 525, 530, 535,  1,  1, { 39502, 61978, }, { 1, 1, }, true, 100000, },
	[86649]  = { nil, 1, 16,  86649,  62242, 505, 515, 520, 525,  1,  1, { 61981, 52329, 52325, 62323, }, { 8, 24, 6, 1, }, true, 120000, },
	[86641]  = { nil, 1, 16,  86641,  62234, 510, 520, 525, 530,  1,  1, { 39502, 61981, 52329, 52326, }, { 10, 8, 24, 6, }, true, 120000, },
	[86642]  = { nil, 1, 16,  86642,  62235, 510, 520, 525, 530,  1,  1, { 39502, 61981, 52329, 52328, }, { 10, 8, 24, 6, }, true, 120000, },
	[86643]  = { nil, 1, 16,  86643,  62236, 510, 520, 525, 530,  1,  1, { 39502, 61981, 52329, 52325, }, { 10, 8, 24, 6, }, true, 120000, },
	[99547]  = { nil, 1, 16,  99547,  75079, 510, 520, 525, 530,  1,  1, { 61981, 52329, 52326, 67335, }, { 5, 6, 6, 1, }, true, 120000, },
	[99548]  = { nil, 1, 16,  99548,  75066, 510, 520, 525, 530,  1,  1, { 61981, 52326, 67319, }, { 5, 12, 1, }, true, 120000, },
	[99549]  = { nil, 1, 16,  99549,  75069, 510, 520, 525, 530,  1,  1, { 61981, 52329, 67348, }, { 5, 12, 1, }, true, 120000, },
	[86650]  = { nil, 1, 16,  86650,  62243, 515, 525, 530, 535,  1,  1, { 61981, 52329, 52327, 67348, }, { 12, 36, 12, 1, }, true, 150000, },
	[86652]  = { nil, 1, 16,  86652,  62244, 515, 525, 530, 535,  1,  1, { 61981, 52329, 52326, 67319, }, { 12, 36, 12, 1, }, true, 150000, },
	[86653]  = { nil, 1, 16,  86653,  62245, 515, 525, 530, 535,  1,  1, { 61981, 52329, 52328, 67335, }, { 12, 36, 12, 1, }, true, 150000, },
	[86615]  = { nil, 1, 16,  86615,  61987, 525, 525, 530, 535,  1,  1, { 61981, 52329, 39502, }, { 10, 30, 1, }, true, 200000, },
	[86654]  = { nil, 1, 16,  86654,  63276, 525, 525, 530, 535,  1,  1, { 39502, 61978, }, { 1, 1, }, },

--	Extra
	[19566] = { nil, 1,  3,  19566,  15409, 275, 275, 275, 275,   1,   1, { 8150, }, { 1, }, },	--	筛盐器

--	Other
	--	套牌
	--	60
	[23677] = { nil, 1, -1,  23677,  19228,   0,   0,   0,   0,   1,   1, { 19227, 19230, 19231, 19232, 19233, 19234, 19235, 19236, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	野兽
	[23678] = { nil, 1, -1,  23678,  19257,   0,   0,   0,   0,   1,   1, { 19258, 19259, 19260, 19261, 19262, 19263, 19264, 19265, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	督军
	[23679] = { nil, 1, -1,  23679,  19267,   0,   0,   0,   0,   1,   1, { 19268, 19269, 19270, 19271, 19272, 19273, 19274, 19275, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	元素
	[23680] = { nil, 1, -1,  23680,  19277,   0,   0,   0,   0,   1,   1, { 19276, 19278, 19279, 19280, 19281, 19282, 19283, 19284, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	入口
	--	70
	[39480] = { nil, 1, -1,  39480,  31890,   0,   0,   0,   0,   1,   1, { 31882, 31889, 31888, 31885, 31884, 31887, 31886, 31883, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	祝福
	[39481] = { nil, 1, -1,  39481,  31891,   0,   0,   0,   0,   1,   1, { 31892, 31900, 31899, 31895, 31894, 31898, 31896, 31893, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	风暴
	[39483] = { nil, 1, -1,  39483,  31907,   0,   0,   0,   0,   1,   1, { 31901, 31909, 31908, 31904, 31903, 31906, 31905, 31902, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	报复
	[39484] = { nil, 1, -1,  39484,  31914,   0,   0,   0,   0,   1,   1, { 31910, 31918, 31917, 31913, 31912, 31916, 31915, 31911, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	愚人
	--	80
	[48221] = { nil, 1, -1, 48221, 37163, 0, 0, 0, 0, 1, 1, { 37140, 37143, 37156, }, { 1, 1, 1, }, },	--	盗贼套牌	48234, 48235
	[48239] = { nil, 1, -1, 48239, 37164, 0, 0, 0, 0, 1, 1, { 37145, 37147, 37159, 37160, }, { 1, 1, 1, 1, }, },	--	长剑套牌	48240, 48242, 48244
	[59953] = { nil, 1, -1, 59953, 44148, 0, 0, 0, 0, 1, 1, { 44165, 44144, 44145, 44146, 44147, }, { 1, 1, 1, 1, 1, }, },	--	法师套牌	59956, 59957, 59958, 59959
	[59962] = { nil, 1, -1, 59962, 44158, 0, 0, 0, 0, 1, 1, { 44143, 44154, 44155, 44156, 44157, }, { 1, 1, 1, 1, 1, }, },	--	恶魔套牌	59964, 59966, 59967, 59968
	[60245] = { nil, 1, -1, 60245, 44259, 0, 0, 0, 0, 1, 1, { 44260, 44261, 44262, 44263, 44264, 44265, 44266, 44267, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	棱镜套牌	60246, 60247, 60248, 60249, 60250, 60251, 60252
	[60255] = { nil, 1, -1, 60255, 44326, 0, 0, 0, 0, 1, 1, { 44268, 44269, 44270, 44271, 44272, 44273, 44274, 44275, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	高尚套牌	60257, 60259, 60260, 60261, 60262, 60263, 60264
	[60265] = { nil, 1, -1, 60265, 44276, 0, 0, 0, 0, 1, 1, { 44277, 44278, 44279, 44280, 44281, 44282, 44284, 44285, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	混乱套牌	60268, 60269, 60270, 60271, 60272, 60273, 60274
	[60276] = { nil, 1, -1, 60276, 44294, 0, 0, 0, 0, 1, 1, { 44286, 44287, 44288, 44289, 44290, 44291, 44292, 44293, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	死灵套牌	60277, 60278, 60279, 60280, 60281, 60282, 60283
	--85
	[86043] = { nil, 1, -1, 86043, 62021, 0, 0, 0, 0, 1, 1, { 61988, 61989, 61990, 61991, 61992, 61993, 61994, 61995, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	火山套牌	86043, 61988, 61989, 61990, 61991, 61992, 61993, 61994
	[86217] = { nil, 1, -1, 86217, 62045, 0, 0, 0, 0, 1, 1, { 62004, 62005, 62006, 62007, 62008, 62009, 62010, 62011, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	飓风套牌	86217, 62004, 62005, 62006, 62007, 62008, 62009, 62010
	[86229] = { nil, 1, -1, 86229, 62046, 0, 0, 0, 0, 1, 1, { 61996, 61997, 61998, 61999, 62000, 62001, 62002, 62003, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	地震套牌	86229, 61996, 61997, 61998, 61999, 62000, 62001, 62002
	[86241] = { nil, 1, -1, 86241, 62044, 0, 0, 0, 0, 1, 1, { 62012, 62013, 62014, 62015, 62016, 62017, 62018, 62019, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	海啸套牌	86241, 62012, 62013, 62014, 62015, 62016, 62017, 62018
	--	高级铸甲技术
	[23231] = { nil, 1, -1,  23231,  18769,   0,   0,   0,   0,   1,   1, { 18779, 18780, }, { 1, 1, }, },
	[23232] = { nil, 1, -1,  23232,  18770,   0,   0,   0,   0,   1,   1, { 18781, 18782, }, { 1, 1, }, },
	[23233] = { nil, 1, -1,  23233,  18771,   0,   0,   0,   0,   1,   1, { 18783, 18784, }, { 1, 1, }, },
	--	祈福
	[23151] = { nil, 1, -1,  23151,  18608,   0,   0,   0,   0,   1,   1, { 18646, 18659, 18665, }, { 1, 1, 1, }, },
	--	伦鲁迪洛尔，上古守护者的长弓
	-- [23192] = { nil, 1, -1,  23192,  18713,   0,   0,   0,   0,   1,   1, { 18707, 18724, }, { 1, 1, }, },
	--	科尔戈的藏宝图
	[11438] = { nil, 1, -1,  11438,   9254,   0,   0,   0,   0,   1,   1, { 9251, 9252, 9253, }, { 1, 1, 1, }, },
	--	刀锋山·耗尽的聚焦水晶
	[40548] = { nil, 1, -1,  40548,  32578,   0,   0,   0,   0,   1,   1, { 32576, 32569, }, { 1, 10, }, },
	--	刀锋山·能量枯竭的XX
	[40744] = { nil, 1, -1,  40744,  32658,   0,   0,   0,   0,   1,   1, { 32672, 32569, }, { 1, 50, }, },
	[40747] = { nil, 1, -1,  40747,  32665,   0,   0,   0,   0,   1,   1, { 32677, 32569, }, { 1, 50, }, },
	[40748] = { nil, 1, -1,  40748,  32655,   0,   0,   0,   0,   1,   1, { 32676, 32569, }, { 1, 50, }, },
	[40749] = { nil, 1, -1,  40749,  32659,   0,   0,   0,   0,   1,   1, { 32673, 32569, }, { 1, 50, }, },
	[40752] = { nil, 1, -1,  40752,  32661,   0,   0,   0,   0,   1,   1, { 32671, 32569, }, { 1, 50, }, },
	[40753] = { nil, 1, -1,  40753,  32656,   0,   0,   0,   0,   1,   1, { 32675, 32569, }, { 1, 50, }, },
	[40754] = { nil, 1, -1,  40754,  32664,   0,   0,   0,   0,   1,   1, { 32678, 32569, }, { 1, 50, }, },
	[40755] = { nil, 1, -1,  40755,  32662,   0,   0,   0,   0,   1,   1, { 32679, 32569, }, { 1, 50, }, },
	[40756] = { nil, 1, -1,  40756,  32660,   0,   0,   0,   0,   1,   1, { 32674, 32569, }, { 1, 50, }, },
	[40757] = { nil, 1, -1,  40757,  32663,   0,   0,   0,   0,   1,   1, { 32670, 32569, }, { 1, 50, }, },
	--	刀锋山·药剂
	[40964] = { nil, 1, -1,  40964,  32598,   0,   0,   0,   0,   1,   1, { 32569, }, { 10, }, },
	[40965] = { nil, 1, -1,  40965,  32598,   0,   0,   0,   0,   1,   1, { 32569, }, { 50, }, },
	[40968] = { nil, 1, -1,  40968,  32601,   0,   0,   0,   0,   1,   1, { 32569, }, { 10, }, },
	[40970] = { nil, 1, -1,  40970,  32601,   0,   0,   0,   0,   1,   1, { 32569, }, { 50, }, },
	[42020] = { nil, 1, -1,  42020,  32601,   0,   0,   0,   0,   1,   1, { 32569, }, { 10, }, },
	[42022] = { nil, 1, -1,  42022,  32601,   0,   0,   0,   0,   1,   1, { 32569, }, { 10, }, },

	--	源生元素
	--	空气22451 土22452 火21884 水21885 暗影22456 法力22457 生命21886
	--	空气22572 土22573 火22574 水22578 暗影22577 法力22576 生命22575
	--	    28100   28101   28102    28103    28104     28105     28106
	[28100] = { nil, 1, -1,  28100,  22451,   0,   0,   0,   0,   1,   1, { 22572, }, { 10, }, },	--	源生空气
	[28101] = { nil, 1, -1,  28101,  22452,   0,   0,   0,   0,   1,   1, { 22573, }, { 10, }, },	--	源生之土
	[28102] = { nil, 1, -1,  28102,  21884,   0,   0,   0,   0,   1,   1, { 22574, }, { 10, }, },	--	源生之火
	[28103] = { nil, 1, -1,  28103,  21885,   0,   0,   0,   0,   1,   1, { 22578, }, { 10, }, },	--	源生之水
	[28104] = { nil, 1, -1,  28104,  22456,   0,   0,   0,   0,   1,   1, { 22577, }, { 10, }, },	--	源生暗影
	[28105] = { nil, 1, -1,  28105,  22457,   0,   0,   0,   0,   1,   1, { 22576, }, { 10, }, },	--	源生法力
	[28106] = { nil, 1, -1,  28106,  21886,   0,   0,   0,   0,   1,   1, { 22575, }, { 10, }, },	--	源生生命
	--	永恒元素
	--	水35622 土35624 火36820 生命35625 暗影35627 空气35623
	--	  56040   56041   56042     56043    56044     56045
	--	空气37700 火37702 水37705 暗影37703 生命37704 土37701
	--	    49234   49244   49245    49246     49247   49248
	[56040] = { nil, 1, -1,  56040,  37705,   0,   0,   0,   0,  10,  10, { 35622, }, { 1, }, },	--	永恒之水
	[49245] = { nil, 1, -1,  49245,  35622,   0,   0,   0,   0,   1,   1, { 37705, }, { 10, }, },	--	永恒之水
	[56041] = { nil, 1, -1,  56041,  37701,   0,   0,   0,   0,  10,  10, { 35624, }, { 1, }, },	--	永恒之土
	[49248] = { nil, 1, -1,  49248,  35624,   0,   0,   0,   0,   1,   1, { 37701, }, { 10, }, },	--	永恒之土
	[56042] = { nil, 1, -1,  56042,  37702,   0,   0,   0,   0,  10,  10, { 36860, }, { 1, }, },	--	永恒火焰
	[49244] = { nil, 1, -1,  49244,  36860,   0,   0,   0,   0,   1,   1, { 37702, }, { 10, }, },	--	永恒火焰
	[56043] = { nil, 1, -1,  56043,  37704,   0,   0,   0,   0,  10,  10, { 35625, }, { 1, }, },	--	永恒生命
	[49247] = { nil, 1, -1,  49247,  35625,   0,   0,   0,   0,   1,   1, { 37704, }, { 10, }, },	--	永恒生命
	[56044] = { nil, 1, -1,  56044,  37703,   0,   0,   0,   0,  10,  10, { 35627, }, { 1, }, },	--	永恒暗影
	[49246] = { nil, 1, -1,  49246,  35627,   0,   0,   0,   0,   1,   1, { 37703, }, { 10, }, },	--	永恒暗影
	[56045] = { nil, 1, -1,  56045,  37700,   0,   0,   0,   0,  10,  10, { 35623, }, { 1, }, },	--	永恒空气
	[49234] = { nil, 1, -1,  49234,  35623,   0,   0,   0,   0,   1,   1, { 37700, }, { 10, }, },	--	永恒空气
	--
	--	附魔
	[13361] = { nil, 1, -1, 13361, 10939,  0, 0, 0, 0, 1, 1, { 10938, }, { 3, }, },   --  强效魔法精华
	[13497] = { nil, 1, -1, 13497, 11082,  0, 0, 0, 0, 1, 1, { 10998, }, { 3, }, },   --  强效星界精华
	[13632] = { nil, 1, -1, 13632, 11135,  0, 0, 0, 0, 1, 1, { 11134, }, { 3, }, },   --  强效秘法精华
	[13739] = { nil, 1, -1, 13739, 11175,  0, 0, 0, 0, 1, 1, { 11174, }, { 3, }, },   --  强效虚空精华
	[20039] = { nil, 1, -1, 20039, 16203,  0, 0, 0, 0, 1, 1, { 16202, }, { 3, }, },   --  强效不灭精华
	[32977] = { nil, 1, -1, 32977, 22446,  0, 0, 0, 0, 1, 1, { 22447, }, { 3, }, },   --  强效位面精华
	[44123] = { nil, 1, -1, 44123, 34055,  0, 0, 0, 0, 1, 1, { 34056, }, { 3, }, },   --  强效宇宙精华
	[74186] = { nil, 1, -1, 74186, 52719,  0, 0, 0, 0, 1, 1, { 52718, }, { 3, }, },   --  强效天界精华
	[13362] = { nil, 1, -1, 13362, 10938,  0, 0, 0, 0, 3, 3, { 10939, }, { 1, }, },   --  次级魔法精华
	[13498] = { nil, 1, -1, 13498, 10998,  0, 0, 0, 0, 3, 3, { 11082, }, { 1, }, },   --  次级星界精华
	[13633] = { nil, 1, -1, 13633, 11134,  0, 0, 0, 0, 3, 3, { 11135, }, { 1, }, },   --  次级秘法精华
	[13740] = { nil, 1, -1, 13740, 11174,  0, 0, 0, 0, 3, 3, { 11175, }, { 1, }, },   --  次级虚空精华
	[20040] = { nil, 1, -1, 20040, 16202,  0, 0, 0, 0, 3, 3, { 16203, }, { 1, }, },   --  次级不灭精华
	[32978] = { nil, 1, -1, 32978, 22447,  0, 0, 0, 0, 3, 3, { 22446, }, { 1, }, },   --  次级位面精华
	[44122] = { nil, 1, -1, 44122, 34056,  0, 0, 0, 0, 3, 3, { 34055, }, { 1, }, },   --  次级宇宙精华
	[74187] = { nil, 1, -1, 74187, 52718,  0, 0, 0, 0, 3, 3, { 52719, }, { 1, }, },   --  次级天界精华

	[61755] = { nil, 1, -1, 61755, 34052,  0, 0, 0, 0, 1, 1, { 34053, }, { 3, }, },   --  制造梦境碎片
	[74188] = { nil, 1, -1, 74188, 52721,  0, 0, 0, 0, 1, 1, { 52720, }, { 3, }, },   --  制造天界碎片

};
DataAgent.T_Recipe_Data = T_Recipe_Data;
-- local T_TradeSkill_RecipeList = {  };	--	[pid] = { sid }
-- for sid, info in next, T_Recipe_Data do
-- 	local pid = info[3];
-- 	T_TradeSkill_RecipeList[pid] = T_TradeSkill_RecipeList[pid] or {  };
-- 	tinsert(T_TradeSkill_RecipeList[pid], sid);
-- end
local T_TradeSkill_RecipeList = {	--	[pid] = { sid }
	[1] = {
		3275,
		3276,
		3277,
		7934,
		3278,
		7935,
		7928,
		7929,
		10840,
		10841,
		18629,
		18630,
		23787,
		27032,
		27033,
		45545,
		45546,
		74556,
		74557,
		74558,
		88893,
	},
	[2] = {
		2660,
		3115,
		12260,
		2663,
		2662,
		2737,
		2738,
		3319,
		3320,
		2739,
		8880,
		9983,
		2661,
		3293,
		3321,
		43549,
		3323,
		3324,
		3325,
		2665,
		3116,
		7408,
		2666,
		3294,
		-- 8366,
		3326,
		2667,
		2664,
		7817,
		3292,
		19666,
		7818,
		34979,
		8367,
		-- 2671,
		3491,
		2668,
		2670,
		2740,
		3328,
		6517,
		2741,
		2672,
		2742,
		2674,
		3117,
		3337,
		3295,
		3330,
		9985,
		2673,
		3296,
		3331,
		9986,
		3333,
		9987,
		6518,
		-- 8368,
		2675,
		3297,
		3334,
		8768,
		19667,
		14379,
		3336,
		7221,
		3494,
		3506,
		12259,
		3492,
		3504,
		9811,
		9813,
		3501,
		7222,
		3495,
		3502,
		3507,
		3493,
		3505,
		9814,
		3496,
		3508,
		9818,
		15972,
		3498,
		3513,
		7223,
		9820,
		3503,
		7224,
		15973,
		21913,
		3511,
		9918,
		9920,
		9921,
		19668,
		14380,
		34981,
		3497,
		3500,
		3515,
		9916,
		11454,
		9926,
		9928,
		11643,
		9931,
		9933,
		9993,
		9935,
		9937,
		9939,
		-- 9942,
		9945,
		9950,
		9995,
		9952,
		9954,
		9997,
		9957,
		9959,
		9961,
		10001,
		9964,
		9966,
		9968,
		10003,
		9972,
		10005,
		9970,
		9974,
		9979,
		9980,
		10007,
		10009,
		16639,
		16640,
		16641,
		16642,
		16643,
		10011,
		16644,
		10013,
		16645,
		36122,
		36124,
		36125,
		36126,
		36128,
		10015,
		-- 16960,
		15292,
		16646,
		16647,
		15293,
		16648,
		16649,
		16650,
		16965,
		16967,
		19669,
		20201,
		15294,
		16651,
		16969,
		16970,
		15295,
		16652,
		16653,
		16971,
		16973,
		16978,
		15296,
		16654,
		16667,
		-- 16980,
		16983,
		16655,
		16656,
		16660,
		23628,
		23632,
		16984,
		16985,
		16657,
		16658,
		16659,
		16661,
		20872,
		20874,
		29654,
		32655,
		34607,
		22757,
		29545,
		29551,
		16662,
		16663,
		16664,
		16665,
		16724,
		16725,
		16726,
		16728,
		16729,
		16730,
		16731,
		16732,
		16741,
		16742,
		16744,
		16745,
		16746,
		16988,
		16990,
		16991,
		16992,
		16993,
		16994,
		16995,
		20873,
		20876,
		20890,
		20897,
		23629,
		23633,
		23636,
		23637,
		23638,
		23639,
		23650,
		23652,
		23653,
		24136,
		24137,
		24138,
		24139,
		24140,
		24141,
		24399,
		24912,
		24913,
		24914,
		27585,
		27586,
		27587,
		27588,
		27589,
		27590,
		27829,
		27830,
		27832,
		28242,
		28243,
		28244,
		28461,
		28462,
		28463,
		34982,
		-- 16986,
		-- 16987,
		21161,
		29547,
		29552,
		29557,
		29548,
		29549,
		29553,
		29558,
		29556,
		29565,
		32284,
		29550,
		29566,
		29568,
		29569,
		36129,
		36130,
		36131,
		36133,
		36134,
		36135,
		36136,
		36137,
		42688,
		29571,
		29603,
		29605,
		29728,
		29606,
		29656,
		32285,
		32656,
		34608,
		59405,
		29614,
		34529,
		34533,
		34535,
		34538,
		34541,
		34543,
		34545,
		34547,
		34983,
		52568,
		52569,
		29608,
		29611,
		29615,
		32657,
		52572,
		54550,
		55834,
		29610,
		29616,
		29619,
		29620,
		29628,
		29629,
		29657,
		29613,
		29617,
		29621,
		29622,
		29630,
		29642,
		29643,
		29658,
		29662,
		29663,
		29664,
		29668,
		29669,
		29671,
		29672,
		29692,
		29693,
		29694,
		29695,
		29696,
		29697,
		29698,
		29699,
		29700,
		42662,
		43846,
		46140,
		46141,
		46142,
		46144,
		52567,
		52571,
		55835,
		29645,
		29648,
		29649,
		29729,
		52570,
		54917,
		34530,
		34534,
		34537,
		34540,
		34542,
		34544,
		34546,
		34548,
		36256,
		36257,
		36258,
		36259,
		36260,
		36261,
		36262,
		36263,
		36389,
		36390,
		36391,
		36392,
		38473,
		38475,
		38476,
		38477,
		38478,
		38479,
		40033,
		40034,
		40035,
		40036,
		41132,
		41133,
		41134,
		41135,
		54978,
		54979,
		54980,
		54981,
		54918,
		55200,
		55201,
		54941,
		54944,
		55202,
		55203,
		54557,
		54945,
		55013,
		55174,
		55204,
		54551,
		54554,
		54946,
		54947,
		55055,
		55177,
		59436,
		55628,
		55641,
		54552,
		54553,
		54948,
		54949,
		55056,
		55179,
		59438,
		54555,
		54556,
		55057,
		55181,
		59440,
		55206,
		55014,
		55017,
		55182,
		56280,
		59442,
		55015,
		55058,
		55183,
		55184,
		55185,
		55186,
		55187,
		55656,
		59441,
		55298,
		55305,
		55732,
		55839,
		56357,
		56549,
		55300,
		55301,
		55306,
		55307,
		55308,
		55309,
		56550,
		56551,
		56552,
		56553,
		61009,
		61010,
		55302,
		55303,
		55304,
		55310,
		55311,
		55312,
		56554,
		56555,
		56556,
		61008,
		76180,
		76262,
		76263,
		76280,
		76281,
		76291,
		76181,
		76264,
		76283,
		76433,
		76182,
		76265,
		76285,
		76293,
		76434,
		76474,
		76438,
		92375,
		76258,
		76266,
		76286,
		76287,
		76435,
		76436,
		76437,
		76259,
		76260,
		76267,
		76288,
		76441,
		76261,
		76269,
		76270,
		76289,
		59406,
		55369,
		55370,
		55371,
		55372,
		55373,
		55374,
		55375,
		55376,
		55377,
		56234,
		56400,
		63182,
		76178,
		62202,
		63187,
		63188,
		63189,
		63190,
		63191,
		63192,
		CT.SELFISHORDE and 67130 or 67091,
		CT.SELFISHORDE and 67131 or 67092,
		CT.SELFISHORDE and 67132 or 67093,
		CT.SELFISHORDE and 67133 or 67094,
		CT.SELFISHORDE and 67134 or 67095,
		CT.SELFISHORDE and 67135 or 67096,
		70562,
		70563,
		70565,
		70566,
		70567,
		70568,
		76179,
		76442,
		76456,
		76465,
		76457,
		76466,
		76444,
		76446,
		76448,
		76458,
		76467,
		76443,
		76445,
		76447,
		76450,
		76452,
		94718,
		76459,
		76468,
		76449,
		76451,
		76453,
		76454,
		76455,
		94732,
		76461,
		76469,
		76439,
		99439,
		99440,
		99441,
		99452,
		99453,
		99454,
		99652,
		99653,
		99654,
		99655,
		99656,
		99657,
		99658,
		99660,
		101924,
		101925,
		101928,
		101929,
		101931,
		101932,
		76440,
		76462,
		76463,
		76464,
		76470,
		76471,
		76472,
	},
	[3] = {
		2881,
		2152,
		2149,
		7126,
		9058,
		9059,
		2153,
		3753,
		3816,
		9064,
		2160,
		5244,
		2161,
		3756,
		2162,
		2163,
		9065,
		2164,
		3759,
		3763,
		2159,
		3761,
		8322,
		2158,
		6702,
		7953,
		6703,
		9068,
		20648,
		2165,
		3817,
		2167,
		2169,
		3762,
		9070,
		24940,
		7133,
		7954,
		2168,
		7135,
		7955,
		2166,
		3767,
		9072,
		9074,
		3765,
		3766,
		9145,
		3768,
		3770,
		9146,
		9147,
		3769,
		9148,
		3764,
		9149,
		20649,
		23190,
		3818,
		3760,
		3771,
		3780,
		3772,
		23399,
		3774,
		7147,
		4096,
		4097,
		9195,
		3775,
		6704,
		7149,
		3773,
		7151,
		9196,
		9197,
		3776,
		9198,
		3778,
		7153,
		9201,
		6661,
		6705,
		7156,
		9202,
		21943,
		3777,
		9206,
		10482,
		20650,
		22711,
		3779,
		9207,
		9208,
		10487,
		10490,
		10499,
		10507,
		10509,
		10511,
		10516,
		10518,
		10520,
		10525,
		10529,
		10531,
		10533,
		10542,
		10544,
		10546,
		10619,
		10621,
		10548,
		10550,
		10552,
		10630,
		10554,
		10556,
		10558,
		10560,
		10562,
		10564,
		10566,
		10568,
		22331,
		19047,
		19058,
		10570,
		10572,
		10574,
		10632,
		10647,
		10650,
		19048,
		19049,
		19050,
		36074,
		36075,
		36076,
		19051,
		19052,
		19053,
		19055,
		19059,
		19060,
		19061,
		19062,
		19063,
		19064,
		19065,
		19066,
		19067,
		19068,
		19070,
		19071,
		19072,
		19073,
		24655,
		44953,
		22815,
		19074,
		19075,
		19076,
		19077,
		19078,
		19079,
		19080,
		19081,
		19082,
		19083,
		19084,
		19085,
		19086,
		23703,
		23705,
		19087,
		19088,
		19089,
		19090,
		20853,
		32454,
		32482,
		32462,
		32466,
		32470,
		32478,
		45100,
		32456,
		19054,
		19091,
		19092,
		19093,
		19094,
		19095,
		19097,
		19098,
		19100,
		19101,
		19102,
		19103,
		19104,
		19106,
		19107,
		20854,
		20855,
		22727,
		22921,
		22922,
		22923,
		22926,
		22927,
		22928,
		23704,
		23706,
		23707,
		23708,
		23709,
		23710,
		24121,
		24122,
		24123,
		24124,
		24125,
		24654,
		24703,
		24846,
		24847,
		24848,
		24849,
		24850,
		24851,
		26279,
		28219,
		28220,
		28221,
		28222,
		28223,
		28224,
		28472,
		28473,
		28474,
		32463,
		32467,
		32479,
		32471,
		32464,
		32472,
		32480,
		32455,
		32457,
		32458,
		35530,
		32468,
		32473,
		32481,
		36077,
		36078,
		36079,
		35549,
		35555,
		32465,
		32469,
		35540,
		35520,
		35521,
		35522,
		35523,
		35524,
		32490,
		32501,
		32502,
		35544,
		351768,
		35539,
		351769,
		64661,
		44770,
		44970,
		32461,
		32485,
		32487,
		32488,
		32489,
		32493,
		32494,
		32498,
		32503,
		35525,
		35526,
		35527,
		35528,
		35529,
		35531,
		35532,
		35533,
		35534,
		35535,
		35536,
		35537,
		50962,
		32496,
		32497,
		44359,
		32495,
		32499,
		32500,
		42546,
		45117,
		35543,
		351771,
		35554,
		35557,
		35558,
		35559,
		35560,
		35561,
		35562,
		35563,
		35564,
		35567,
		35568,
		35572,
		35573,
		35574,
		42731,
		46132,
		46133,
		46134,
		46135,
		46136,
		46137,
		46138,
		46139,
		35538,
		351770,
		50939,
		50941,
		50944,
		50948,
		50951,
		50955,
		50957,
		50959,
		351766,
		35575,
		35576,
		35577,
		35580,
		35582,
		35584,
		35585,
		35587,
		35588,
		35589,
		35590,
		35591,
		36349,
		36351,
		36352,
		36353,
		36355,
		36357,
		36358,
		36359,
		39997,
		40001,
		40002,
		40003,
		40004,
		40005,
		40006,
		41156,
		41157,
		41158,
		41160,
		41161,
		41162,
		41163,
		41164,
		52733,
		50938,
		50942,
		50945,
		50947,
		50950,
		50952,
		50956,
		50961,
		50943,
		60631,
		50940,
		50946,
		50949,
		50953,
		50954,
		50958,
		50960,
		51571,
		51572,
		60599,
		60600,
		60607,
		60608,
		60622,
		60624,
		50936,
		50963,
		55199,
		51569,
		51570,
		60601,
		60604,
		60611,
		60613,
		60627,
		60629,
		60584,
		50966,
		51568,
		60605,
		60620,
		60630,
		57683,
		57690,
		57691,
		57692,
		57694,
		57696,
		57699,
		57701,
		60583,
		50964,
		50970,
		50971,
		60643,
		60651,
		60652,
		60658,
		60665,
		60666,
		60671,
		60697,
		60702,
		60703,
		60704,
		60715,
		60716,
		60718,
		60720,
		60728,
		60729,
		60730,
		60731,
		60743,
		60746,
		60747,
		60748,
		60997,
		60998,
		61000,
		61002,
		60649,
		60655,
		60660,
		60669,
		60705,
		60706,
		60711,
		60712,
		60721,
		60723,
		60725,
		60727,
		60732,
		60734,
		60735,
		60737,
		60749,
		60750,
		60751,
		60752,
		50965,
		50967,
		62448,
		60996,
		60999,
		78398,
		78410,
		78415,
		78416,
		78380,
		78388,
		78399,
		78405,
		78407,
		78396,
		78436,
		78406,
		78411,
		78419,
		78420,
		78427,
		78428,
		78437,
		78432,
		78433,
		78424,
		78423,
		78438,
		78439,
		74493,
		84950,
		60637,
		60640,
		60754,
		60755,
		60756,
		60757,
		60758,
		60759,
		60760,
		60761,
		62176,
		62177,
		69386,
		69388,
		78379,
		63194,
		63195,
		63196,
		63197,
		63198,
		63199,
		63200,
		63201,
		CT.SELFISHORDE and 67136 or 67080,
		CT.SELFISHORDE and 67137 or 67081,
		CT.SELFISHORDE and 67138 or 67082,
		CT.SELFISHORDE and 67143 or 67083,
		CT.SELFISHORDE and 67140 or 67084,
		CT.SELFISHORDE and 67141 or 67085,
		CT.SELFISHORDE and 67142 or 67086,
		CT.SELFISHORDE and 67139 or 67087,
		70554,
		70555,
		70556,
		70557,
		70558,
		70559,
		70560,
		70561,
		85067,
		85068,
		101600,
		85007,
		85008,
		85009,
		85010,
		100586,
		99535,
		99536,
		78444,
		78445,
		78446,
		78447,
		78448,
		78449,
		78450,
		78451,
		100583,
		78452,
		78453,
		78454,
		78455,
		78456,
		78457,
		78458,
		78459,
		78464,
		78467,
		78468,
		78469,
		78470,
		78471,
		78473,
		78474,
		78460,
		78461,
		78462,
		78463,
		99443,
		99445,
		99446,
		99447,
		99455,
		99456,
		99457,
		99458,
		101933,
		101934,
		101935,
		101936,
		101937,
		101939,
		101940,
		101941,
		78475,
		78476,
		78477,
		78478,
		78479,
		78480,
		78481,
		78482,
		78483,
		78484,
		78485,
		78486,
		78487,
		78488,
		78489,
		78490,
		101599,
	},
	[4] = {
		2329,
		2330,
		7183,
		3170,
		2331,
		2332,
		2334,
		3230,
		4508,
		2337,
		2335,
		6617,
		7836,
		3171,
		7179,
		8240,
		7255,
		7841,
		3172,
		3447,
		3173,
		3174,
		3176,
		7837,
		3177,
		7256,
		63732,
		2333,
		7845,
		3188,
		6624,
		7181,
		3452,
		3448,
		3449,
		7257,
		3450,
		6618,
		3451,
		11449,
		7258,
		7259,
		21923,
		3453,
		11450,
		3454,
		12609,
		11448,
		11451,
		11453,
		11456,
		11452,
		4942,
		11457,
		22808,
		11458,
		11459,
		11479,
		11480,
		11460,
		15833,
		11461,
		11464,
		11465,
		11466,
		11467,
		11468,
		11472,
		11473,
		17551,
		11476,
		11477,
		11478,
		26277,
		3175,
		17552,
		17553,
		17554,
		17555,
		17187,
		17559,
		17560,
		17561,
		17562,
		17563,
		17564,
		17565,
		17566,
		17556,
		17557,
		24365,
		24366,
		17570,
		17571,
		17572,
		17573,
		24367,
		17574,
		17575,
		17576,
		17577,
		17578,
		17579,
		24368,
		17580,
		25146,
		22732,
		17634,
		17635,
		17636,
		17637,
		17638,
		33732,
		33738,
		33740,
		28543,
		28544,
		28545,
		33733,
		39636,
		24266,
		28546,
		33741,
		28549,
		28550,
		39637,
		39638,
		45061,
		28551,
		28552,
		38070,
		28553,
		39639,
		28554,
		38960,
		28555,
		28556,
		28557,
		38962,
		53838,
		17632,
		28558,
		28562,
		28563,
		28564,
		28565,
		28566,
		28567,
		28568,
		28569,
		29688,
		32765,
		32766,
		53841,
		28570,
		41458,
		41500,
		41501,
		41502,
		41503,
		53839,
		28571,
		28572,
		28573,
		28575,
		28576,
		28577,
		38961,
		28578,
		28579,
		53842,
		28580,
		28581,
		28582,
		28583,
		28584,
		28585,
		28586,
		28587,
		28588,
		28589,
		28590,
		28591,
		47046,
		47048,
		47049,
		47050,
		53812,
		53848,
		53899,
		62409,
		42736,
		53900,
		53847,
		54218,
		62213,
		53898,
		53840,
		60367,
		53905,
		60350,
		53936,
		53937,
		53938,
		53939,
		53942,
		53895,
		53904,
		54220,
		54221,
		54222,
		56519,
		60354,
		60355,
		60356,
		60357,
		60365,
		60366,
		60893,
		62410,
		60396,
		60403,
		60405,
		53771,
		53773,
		53774,
		53775,
		53776,
		53777,
		53779,
		53780,
		53781,
		53782,
		53783,
		53784,
		53836,
		58871,
		58868,
		53837,
		57427,
		67025,
		57425,
		53901,
		53902,
		53903,
		54213,
		93935,
		66659,
		54020,
		66658,
		66660,
		66662,
		66663,
		66664,
		80477,
		80478,
		80479,
		80480,
		80481,
		80269,
		80482,
		80484,
		80486,
		80487,
		80488,
		80490,
		80491,
		80492,
		80494,
		80495,
		80493,
		80496,
		80497,
		80498,
		80719,
		80724,
		94162,
		80508,
		96252,
		96253,
		96254,
		78866,
		80251,
		80720,
		80250,
		80721,
		80723,
		80246,
		80248,
		92643,
		92688,
		80237,
		80243,
		80244,
		80245,
		80247,
		80725,
		80726,
		93328,
	},
	[6] = {
		37836,
		65454,
		2538,
		2540,
		7751,
		7752,
		8604,
		15935,
		21143,
		33276,
		33277,
		43779,
		CT.SELFISHORDE and 66038 or 62050,
		6417,
		2539,
		6412,
		2795,
		6413,
		6414,
		21144,
		8607,
		93741,
		2541,
		2542,
		6415,
		6416,
		6499,
		7753,
		7754,
		7827,
		33278,
		2543,
		3371,
		9513,
		28267,
		2544,
		2546,
		3370,
		25704,
		2545,
		8238,
		3372,
		6501,
		45695,
		2547,
		2549,
		6418,
		7755,
		CT.SELFISHORDE and 66036 or 62044,
		2548,
		3377,
		3397,
		6419,
		3373,
		6500,
		15853,
		3398,
		3376,
		24418,
		3399,
		CT.SELFISHORDE and 66035 or 62049,
		13028,
		7828,
		3400,
		4094,
		7213,
		15855,
		15856,
		15861,
		15863,
		15865,
		20916,
		25954,
		15906,
		15910,
		21175,
		CT.SELFISHORDE and 66034 or 62051,
		15915,
		15933,
		18238,
		18239,
		18241,
		20626,
		22480,
		18240,
		18242,
		64054,
		18243,
		18244,
		46684,
		46688,
		18245,
		18246,
		18247,
		22761,
		CT.SELFISHORDE and 66037 or 62045,
		24801,
		33279,
		33284,
		33290,
		33291,
		36210,
		43758,
		43761,
		25659,
		43772,
		33292,
		33286,
		42296,
		33293,
		33294,
		45022,
		43707,
		43765,
		33287,
		33288,
		33289,
		33295,
		38867,
		38868,
		58512,
		58521,
		58523,
		58525,
		45560,
		45561,
		45562,
		57421,
		45549,
		45550,
		45551,
		45552,
		45553,
		45563,
		45564,
		45565,
		45566,
		45569,
		58065,
		33296,
		42302,
		42305,
		53056,
		45554,
		62350,
		64358,
		45555,
		45556,
		45557,
		45558,
		45559,
		45567,
		45568,
		45570,
		45571,
		57433,
		57434,
		57435,
		57436,
		57437,
		57438,
		57439,
		57440,
		57441,
		57442,
		57443,
		58527,
		58528,
		88015,
		88017,
		88006,
		57423,
		88022,
		88045,
		88012,
		88024,
		88028,
		88030,
		88035,
		88037,
		88047,
		88021,
		88033,
		88046,
		88018,
		96133,
		88003,
		88004,
		88005,
		88014,
		88016,
		88020,
		88025,
		88031,
		88034,
		88039,
		88042,
		88011,
		88013,
		88019,
		88036,
		88044,
	},
	[7] = {
		2657,
		3304,
		2659,
		2658,
		3307,
		3308,
		3569,
		10097,
		10098,
		16153,
		70524,
		29356,
		14891,
		35750,
		35751,
		22967,
		29358,
		29360,
		29359,
		49252,
		46353,
		29361,
		29686,
		49258,
		84038,
		55208,
		55211,
		74530,
		74537,
		74529,
	},
	[8] = {
		2963,
		2387,
		2393,
		3915,
		12044,
		2385,
		8776,
		12045,
		3914,
		7623,
		7624,
		3840,
		2389,
		2392,
		2394,
		8465,
		3755,
		7629,
		7630,
		2397,
		3841,
		2386,
		2395,
		2396,
		3842,
		6686,
		7633,
		2964,
		2402,
		12046,
		3757,
		3845,
		2399,
		3843,
		6521,
		7636,
		2401,
		3758,
		3847,
		2406,
		3844,
		7639,
		2403,
		3848,
		3850,
		3866,
		8467,
		6688,
		7643,
		3849,
		7892,
		7893,
		12047,
		3839,
		3851,
		3855,
		3868,
		63742,
		3852,
		3869,
		6690,
		3856,
		8758,
		8778,
		8760,
		3854,
		8780,
		3813,
		3859,
		6692,
		8782,
		102171,
		3870,
		8483,
		8762,
		3857,
		8784,
		3871,
		3858,
		8764,
		3865,
		8489,
		3860,
		6693,
		8766,
		8772,
		8786,
		3863,
		8774,
		8789,
		3872,
		8791,
		3861,
		6695,
		21945,
		8770,
		8793,
		8795,
		8799,
		8797,
		3873,
		3862,
		3864,
		8802,
		12048,
		12049,
		8804,
		12050,
		12052,
		12059,
		12061,
		12053,
		12055,
		12056,
		12060,
		12064,
		12062,
		12063,
		12065,
		12066,
		12067,
		12068,
		12069,
		12070,
		12071,
		27658,
		12075,
		12072,
		12073,
		12074,
		12077,
		12080,
		12076,
		12078,
		12079,
		12085,
		12081,
		12082,
		12083,
		12084,
		12089,
		50647,
		12086,
		12087,
		12088,
		44950,
		44958,
		18401,
		12091,
		49677,
		12090,
		12092,
		12093,
		26403,
		26407,
		50644,
		18560,
		18402,
		18403,
		18404,
		18405,
		18406,
		18407,
		18408,
		26085,
		18409,
		18410,
		18411,
		18412,
		18413,
		18414,
		18415,
		18416,
		18417,
		18418,
		18419,
		18420,
		18421,
		18422,
		27659,
		27724,
		18423,
		18424,
		18434,
		22813,
		18436,
		18437,
		18438,
		26086,
		19435,
		18439,
		18440,
		18441,
		18442,
		23662,
		23664,
		18444,
		31460,
		26745,
		18445,
		18446,
		18447,
		18448,
		18449,
		18450,
		18451,
		18452,
		18453,
		18454,
		18455,
		18456,
		18457,
		18458,
		20848,
		20849,
		22866,
		22867,
		22868,
		22869,
		22870,
		22902,
		23663,
		23665,
		23666,
		23667,
		24091,
		24092,
		24093,
		24901,
		24902,
		24903,
		26087,
		27660,
		27725,
		28205,
		28207,
		28208,
		28209,
		28210,
		28480,
		28481,
		28482,
		22759,
		60969,
		26764,
		26765,
		26746,
		26770,
		31461,
		26747,
		26771,
		26772,
		31430,
		31431,
		26749,
		26773,
		26775,
		31459,
		26750,
		26774,
		26751,
		31373,
		36686,
		26776,
		26782,
		31434,
		31435,
		31437,
		31438,
		31440,
		31441,
		37873,
		37882,
		55902,
		56031,
		55899,
		26752,
		26756,
		26760,
		26779,
		36665,
		36667,
		36668,
		36669,
		36670,
		36672,
		26777,
		26778,
		26783,
		37883,
		55898,
		55903,
		55904,
		26753,
		26757,
		26761,
		26780,
		31442,
		31443,
		31444,
		31448,
		31449,
		31450,
		46128,
		46129,
		46130,
		46131,
		26784,
		37884,
		55908,
		26781,
		26754,
		26755,
		26758,
		26759,
		26762,
		26763,
		31432,
		31433,
		31451,
		31452,
		31453,
		31454,
		31455,
		31456,
		36315,
		36316,
		36317,
		36318,
		40020,
		40021,
		40023,
		40024,
		40060,
		41205,
		41206,
		41207,
		41208,
		50194,
		55906,
		55907,
		56030,
		55910,
		55913,
		56014,
		55911,
		55914,
		56015,
		55901,
		55919,
		55900,
		55993,
		55994,
		55995,
		55996,
		55997,
		55998,
		55999,
		56000,
		56008,
		56010,
		-- 56048,
		64729,
		55920,
		56034,
		56039,
		64730,
		55921,
		55922,
		55923,
		55924,
		56007,
		55925,
		55943,
		56001,
		56002,
		56003,
		59582,
		59583,
		56016,
		55642,
		55769,
		55777,
		55941,
		56019,
		56020,
		56022,
		56023,
		59584,
		59585,
		59586,
		59587,
		59588,
		59589,
		60990,
		60994,
		56017,
		56018,
		56021,
		60971,
		60993,
		75597,
		56009,
		56011,
		75247,
		56004,
		63924,
		56025,
		56027,
		56029,
		74964,
		56006,
		56024,
		56026,
		56028,
		56005,
		63203,
		63204,
		63205,
		63206,
		CT.SELFISHORDE and 67144 or 67064,
		CT.SELFISHORDE and 67145 or 67065,
		CT.SELFISHORDE and 67146 or 67066,
		CT.SELFISHORDE and 67147 or 67079,
		70550,
		70551,
		70552,
		70553,
		75248,
		75249,
		75251,
		75252,
		75250,
		75254,
		75253,
		75255,
		75256,
		75257,
		75258,
		75259,
		75261,
		75260,
		75262,
		75263,
		75264,
		75265,
		75266,
		75267,
		75268,
		99537,
		75288,
		75289,
		75270,
		75290,
		75291,
		100585,
		75269,
		75292,
		75293,
		75294,
		75295,
		99448,
		99449,
		99459,
		99460,
		75141,
		75142,
		75144,
		75145,
		75146,
		75296,
		75297,
		75298,
		75299,
		75300,
		75301,
		75302,
		75303,
		75304,
		75305,
		75306,
		75307,
		75308,
		75309,
		75310,
		94743,
		101920,
		101921,
		101922,
		101923,
	},
	[9] = {
		-- 12900,
		-- 12722,
		-- 12904,
		-- 30561,
		-- 30573,
		3918,
		3919,
		3922,
		3923,
		7430,
		3925,
		3977,
		3929,
		3931,
		3928,
		3932,
		3973,
		8334,
		8339,
		3933,
		3934,
		3938,
		3937,
		3936,
		3978,
		3941,
		3939,
		3940,
		3945,
		3946,
		26416,
		26417,
		26418,
		3942,
		3944,
		9269,
		3949,
		6458,
		3950,
		3952,
		3953,
		3954,
		9271,
		23066,
		23067,
		23068,
		12584,
		3955,
		3956,
		3957,
		3958,
		3959,
		9273,
		3960,
		3961,
		12585,
		12586,
		26420,
		26421,
		26422,
		3962,
		3963,
		12590,
		12587,
		3979,
		3965,
		8243,
		3966,
		3967,
		21940,
		12589,
		3968,
		23069,
		3972,
		12591,
		15255,
		3969,
		3971,
		13240,
		12895,
		12715,
		15628,
		15633,
		12760,
		12594,
		12595,
		12716,
		12717,
		12718,
		12899,
		12597,
		12902,
		12905,
		12599,
		12603,
		12897,
		12903,
		12607,
		12614,
		26423,
		26424,
		26425,
		8895,
		12615,
		12616,
		26442,
		12755,
		12617,
		12618,
		12906,
		12619,
		12754,
		12907,
		12620,
		12759,
		12908,
		12622,
		12758,
		19788,
		23070,
		23507,
		12624,
		19567,
		63750,
		26011,
		23129,
		23071,
		19790,
		19791,
		19792,
		23077,
		23096,
		19793,
		23078,
		19794,
		26426,
		26427,
		26428,
		28327,
		39895,
		23080,
		23079,
		19795,
		19796,
		19814,
		26443,
		23486,
		23489,
		19799,
		19815,
		19819,
		19825,
		23081,
		30305,
		30303,
		30304,
		19830,
		19831,
		19833,
		22704,
		22793,
		22795,
		22797,
		23082,
		24356,
		24357,
		30310,
		44155,
		30548,
		30312,
		30306,
		30348,
		-- 30549,
		30558,
		30311,
		30337,
		30568,
		30551,
		39971,
		30341,
		-- 30342,
		-- 30343,
		30344,
		32814,
		43676,
		30329,
		39973,
		30560,
		30307,
		30308,
		30309,
		30316,
		30317,
		30569,
		30552,
		30547,
		36954,
		36955,
		30313,
		30318,
		30563,
		30570,
		56349,
		53281,
		40274,
		41311,
		41312,
		41314,
		41315,
		41316,
		41317,
		41318,
		41319,
		41320,
		41321,
		56460,
		30556,
		46697,
		30314,
		30325,
		30332,
		44391,
		30565,
		30566,
		30574,
		30575,
		41307,
		56459,
		56461,
		56464,
		44157,
		56463,
		30315,
		30334,
		46106,
		46107,
		46108,
		46109,
		46110,
		46111,
		46112,
		46113,
		46114,
		46115,
		46116,
		54793,
		55002,
		54736,
		56471,
		61471,
		54998,
		54999,
		63770,
		54353,
		55016,
		56468,
		30349,
		67839,
		56476,
		67326,
		55252,
		56477,
		56465,
		61481,
		61482,
		61483,
		56466,
		56467,
		56514,
		82175,
		82177,
		82180,
		82200,
		82201,
		84424,
		84425,
		84427,
		82207,
		56470,
		56472,
		56469,
		56473,
		56478,
		84403,
		56462,
		67920,
		56480,
		56481,
		56483,
		56484,
		56486,
		56487,
		56574,
		62271,
		95703,
		56479,
		60874,
		CT.SELFISHORDE and 60866 or 60867,
		68067,
		84406,
		94748,
		84409,
		84408,
		84410,
		84411,
		84415,
		84429,
		84412,
		84413,
		84416,
		84421,
		84430,
		95705,
		84418,
		95707,
		84420,
		84417,
		100587,
		84432,
		100687,
		81714,
		81715,
		81716,
		81720,
		81722,
		81724,
		81725,
		84428,
		84431,
	},
	[10] = {
		7421,
		7418,
		7428,
		14293,
		7420,
		7443,
		7426,
		25124,
		7454,
		7457,
		7748,
		7766,
		7771,
		14807,
		7776,
		7779,
		7782,
		7786,
		7788,
		7745,
		7793,
		7795,
		13378,
		13380,
		13419,
		13421,
		13464,
		7857,
		7859,
		7861,
		7863,
		7867,
		13485,
		13501,
		13522,
		13503,
		13536,
		13538,
		13529,
		13607,
		13612,
		13617,
		13620,
		25125,
		13622,
		13626,
		13628,
		13631,
		13635,
		14809,
		13637,
		13640,
		13642,
		13644,
		13646,
		13648,
		13653,
		13655,
		13657,
		14810,
		13659,
		13661,
		13663,
		13687,
		21931,
		13689,
		13693,
		25126,
		13695,
		13698,
		13700,
		13702,
		13746,
		13794,
		13815,
		13817,
		13822,
		13836,
		13841,
		13846,
		13858,
		13868,
		13882,
		13887,
		13890,
		63746,
		13905,
		13915,
		13917,
		13931,
		13933,
		13935,
		13937,
		13939,
		13941,
		13943,
		13945,
		17180,
		17181,
		25127,
		13947,
		13948,
		20008,
		20020,
		13898,
		15596,
		20014,
		20017,
		20009,
		20012,
		25128,
		20024,
		20026,
		20016,
		20015,
		20029,
		20028,
		20051,
		23799,
		23800,
		23801,
		27837,
		20010,
		20013,
		20023,
		20030,
		20033,
		42613,
		25129,
		25130,
		20011,
		20025,
		20031,
		20032,
		20034,
		20035,
		20036,
		22749,
		22750,
		23802,
		23803,
		23804,
		25072,
		25073,
		25074,
		25078,
		25079,
		25080,
		25081,
		25082,
		25083,
		25084,
		25086,
		32664,
		33991,
		34002,
		27899,
		27948,
		33993,
		34001,
		28016,
		27944,
		27961,
		33996,
		34004,
		27905,
		27957,
		27906,
		27950,
		33990,
		28027,
		-- 28021,
		27911,
		27945,
		34003,
		34009,
		27962,
		44383,
		28022,
		42615,
		27913,
		28019,
		27946,
		27951,
		27967,
		27968,
		33995,
		27960,
		33992,
		46578,
		42620,
		27958,
		60609,
		27914,
		27971,
		27972,
		27975,
		28028,
		32665,
		33999,
		34005,
		34006,
		34010,
		27920,
		27924,
		27947,
		27977,
		28003,
		28004,
		33994,
		33997,
		34007,
		34008,
		44592,
		60616,
		27917,
		46594,
		27926,
		27954,
		44623,
		45765,
		32667,
		44506,
		27927,
		27982,
		27984,
		42974,
		47051,
		44555,
		71692,
		60606,
		27981,
		60621,
		44528,
		60623,
		62959,
		44630,
		44582,
		44492,
		44500,
		44513,
		44629,
		44635,
		60653,
		44636,
		44645,
		59636,
		44616,
		47766,
		44483,
		44494,
		44556,
		44590,
		44596,
		44484,
		44584,
		-- 44612,
		44488,
		44508,
		44510,
		44633,
		44588,
		44529,
		44589,
		44598,
		44489,
		44509,
		44593,
		60663,
		44524,
		44576,
		47900,
		60619,
		60668,
		44575,
		44595,
		44621,
		47672,
		47898,
		60691,
		44591,
		44625,
		60707,
		60714,
		74132,
		74189,
		74191,
		44631,
		47899,
		47901,
		59619,
		59621,
		59625,
		60692,
		60763,
		60767,
		69412,
		74192,
		74193,
		62948,
		64441,
		64579,
		62256,
		62257,
		74215,
		74216,
		74217,
		74218,
		74195,
		74197,
		74198,
		74199,
		74200,
		74201,
		74202,
		74207,
		74211,
		74212,
		95471,
		74213,
		74214,
		74220,
		74223,
		74225,
		74226,
		74229,
		74230,
		74231,
		74232,
		74236,
		74234,
		74235,
		74237,
		92370,
		96261,
		96262,
		96264,
		74238,
		74239,
		74240,
		93841,
		93843,
		104698,
		74242,
		74244,
		74246,
		74247,
		74248,
		74250,
		74251,
		74252,
		74253,
		74254,
		74255,
		74256,
	},
	[15] = {
		25255,
		25493,
		26925,
		32259,
		26926,
		32178,
		32179,
		25283,
		26928,
		25278,
		32801,
		25280,
		25490,
		26927,
		25284,
		37818,
		25287,
		36523,
		25317,
		38175,
		25305,
		25318,
		36524,
		32807,
		25339,
		25498,
		25321,
		25610,
		25323,
		25612,
		25613,
		25614,
		25615,
		25320,
		25617,
		25618,
		25619,
		25620,
		32808,
		34955,
		25621,
		25622,
		34959,
		63743,
		26872,
		26873,
		26874,
		26875,
		26876,
		32809,
		26880,
		26878,
		26881,
		36525,
		26882,
		26883,
		26885,
		26887,
		26896,
		26897,
		26900,
		26902,
		36526,
		26903,
		26906,
		26907,
		26908,
		34960,
		26909,
		26910,
		26911,
		34961,
		32810,
		28903,
		28910,
		28916,
		28925,
		28950,
		28905,
		28917,
		28953,
		34590,
		62941,
		26912,
		26914,
		28912,
		28927,
		28944,
		26915,
		31048,
		31049,
		26916,
		28914,
		28918,
		28933,
		28947,
		28955,
		26918,
		31050,
		41420,
		38068,
		28915,
		28936,
		28948,
		39466,
		39467,
		-- 26920,
		41414,
		41415,
		31051,
		31052,
		40514,
		31058,
		31084,
		31085,
		31088,
		31090,
		31091,
		31092,
		31095,
		31097,
		31098,
		31101,
		31102,
		31103,
		31104,
		31106,
		31107,
		31108,
		31109,
		31111,
		31112,
		31113,
		31149,
		39470,
		39471,
		41429,
		43493,
		46403,
		46405,
		46803,
		47280,
		31053,
		56205,
		56206,
		53831,
		53832,
		53843,
		53844,
		53845,
		53852,
		53854,
		53856,
		53857,
		53859,
		53860,
		53861,
		53865,
		53869,
		53870,
		53871,
		53872,
		53873,
		53874,
		53875,
		53876,
		53877,
		53879,
		53880,
		53882,
		53883,
		53884,
		53885,
		53891,
		53892,
		53893,
		53894,
		53917,
		53918,
		53919,
		53920,
		53921,
		53922,
		53923,
		53924,
		53925,
		53932,
		53933,
		53934,
		53941,
		53943,
		54017,
		56208,
		56193,
		56194,
		56530,
		58141,
		58142,
		58143,
		58144,
		31054,
		31055,
		31060,
		31067,
		31068,
		42558,
		42588,
		42589,
		42590,
		42591,
		42592,
		42593,
		31056,
		31062,
		31063,
		31064,
		31065,
		31066,
		31071,
		37855,
		31070,
		31057,
		31061,
		32866,
		32867,
		32868,
		32869,
		32870,
		32871,
		32872,
		32873,
		32874,
		39961,
		39963,
		44794,
		31072,
		31076,
		41418,
		46122,
		46123,
		46124,
		46125,
		46126,
		46127,
		46597,
		46601,
		31077,
		31078,
		31079,
		31080,
		31081,
		31082,
		31083,
		56049,
		56052,
		56053,
		56055,
		56056,
		56079,
		56081,
		56083,
		56084,
		56085,
		56086,
		56087,
		56088,
		38503,
		38504,
		39705,
		39706,
		39711,
		39713,
		39714,
		39715,
		39716,
		39718,
		39720,
		39721,
		39724,
		39727,
		39728,
		39731,
		39733,
		39734,
		39736,
		39737,
		39738,
		39739,
		39740,
		39741,
		39742,
		46775,
		46776,
		46777,
		46778,
		46779,
		47053,
		47054,
		47055,
		47056,
		56195,
		56196,
		58145,
		58146,
		53830,
		53945,
		53946,
		53948,
		53949,
		53951,
		53952,
		53954,
		53955,
		53957,
		53958,
		53960,
		53961,
		53962,
		53963,
		53965,
		53966,
		53968,
		53972,
		53974,
		53975,
		53976,
		53977,
		53978,
		53980,
		53981,
		53984,
		53985,
		53986,
		53987,
		53988,
		53991,
		53993,
		53994,
		53996,
		53997,
		53998,
		54000,
		54001,
		54003,
		54005,
		54009,
		54011,
		54012,
		54014,
		54019,
		54023,
		56531,
		56199,
		56201,
		56202,
		56203,
		59759,
		55384,
		55386,
		55387,
		55388,
		55389,
		55390,
		55392,
		55393,
		55394,
		55395,
		55396,
		55397,
		55398,
		55399,
		55400,
		55401,
		55402,
		55403,
		55404,
		55405,
		55407,
		56197,
		58147,
		58148,
		58149,
		58150,
		58492,
		58507,
		58954,
		64725,
		64726,
		64727,
		64728,
		62242,
		73224,
		73229,
		73231,
		73242,
		73244,
		73245,
		73248,
		73258,
		73260,
		73262,
		73263,
		73264,
		73265,
		73266,
		73269,
		73271,
		73272,
		73273,
		73275,
		73276,
		73277,
		73278,
		73280,
		56496,
		56497,
		56498,
		66587,
		56499,
		56500,
		56501,
		66338,
		66428,
		66429,
		66431,
		66432,
		66434,
		66435,
		66439,
		66441,
		66442,
		66443,
		66445,
		66446,
		66447,
		66448,
		66450,
		66452,
		66453,
		66497,
		66498,
		66499,
		66501,
		66502,
		66505,
		66506,
		66554,
		66556,
		66557,
		66560,
		66561,
		66562,
		66567,
		66568,
		66569,
		66570,
		66571,
		66572,
		66573,
		66574,
		66576,
		66579,
		66581,
		66582,
		66583,
		66584,
		66585,
		66586,
		68253,
		73622,
		73222,
		73223,
		73225,
		73226,
		73227,
		73228,
		73230,
		73232,
		73233,
		73234,
		73239,
		73240,
		73241,
		73243,
		73246,
		73247,
		73249,
		73250,
		73259,
		73267,
		73268,
		73270,
		73274,
		73279,
		73281,
		73494,
		73496,
		73625,
		73626,
		73627,
		73335,
		73336,
		73337,
		73338,
		73339,
		73340,
		73341,
		73343,
		73344,
		73345,
		73346,
		73347,
		73348,
		73349,
		73350,
		73351,
		73352,
		73353,
		73354,
		73355,
		73356,
		73357,
		73358,
		73359,
		73360,
		73361,
		73362,
		73364,
		73365,
		73366,
		73367,
		73368,
		73369,
		73370,
		73371,
		73372,
		73373,
		73374,
		73375,
		73376,
		73377,
		73378,
		73379,
		73380,
		73381,
		73382,
		73383,
		73384,
		95754,
		95755,
		95756,
		96226,
		73620,
		73495,
		73464,
		73465,
		73466,
		73467,
		73468,
		73469,
		73470,
		73471,
		73472,
		73473,
		73474,
		73475,
		73476,
		96255,
		96256,
		96257,
		73497,
		73621,
		73396,
		73397,
		73398,
		73399,
		73400,
		73401,
		73402,
		73403,
		73404,
		73405,
		73406,
		73407,
		73408,
		73409,
		99539,
		99540,
		99541,
		73478,
		73498,
		73502,
		73503,
		73504,
		73505,
		73506,
		73520,
		73521,
		98921,
		73623,
		99542,
		99543,
		99544,
		101735,
		101740,
		101741,
		101742,
		101743,
		101744,
		101745,
		101746,
		101747,
		101748,
		101749,
		101750,
		101751,
		101752,
		101753,
		101754,
		101755,
		101756,
		101757,
		101758,
		101759,
		101760,
		101761,
		101762,
		101763,
		101764,
		101765,
		101766,
		101767,
		101768,
		101769,
		101770,
		101771,
		101772,
		101773,
		101774,
		101775,
		101776,
		101777,
		101778,
		101779,
		101780,
		101781,
		101782,
		101783,
		101784,
		101785,
		101786,
		101787,
		101788,
		101789,
		101790,
		101791,
		101792,
		101793,
		101794,
		101795,
		101796,
		101797,
		101798,
		101799,
		101800,
		101801,
		101802,
		101803,
		101804,
	},
	[16] = {
		52738,
		48114,
		48116,
		45382,
		58472,
		58484,
		52843,
		48248,
		52739,
		53462,
		50598,
		50605,
		50612,
		58289,
		58296,
		58298,
		58299,
		58301,
		58303,
		58306,
		58308,
		58310,
		58312,
		58313,
		58314,
		58317,
		58318,
		58323,
		58326,
		58337,
		58342,
		58343,
		92026,
		58286,
		58288,
		58311,
		58315,
		58320,
		58325,
		58332,
		58336,
		58345,
		107907,
		61288,
		58307,
		58324,
		58328,
		58331,
		58340,
		58287,
		58302,
		58316,
		58319,
		58321,
		58329,
		58330,
		58333,
		58338,
		58339,
		59315,
		95215,
		95710,
		58297,
		58327,
		57209,
		57215,
		57217,
		57228,
		57229,
		57230,
		58347,
		56965,
		56990,
		57253,
		58322,
		58341,
		64312,
		68166,
		58344,
		58346,
		58485,
		56955,
		56976,
		57004,
		57022,
		57114,
		57194,
		57703,
		58473,
		56963,
		57162,
		57239,
		57259,
		48247,
		58565,
		56961,
		56978,
		57009,
		57027,
		57119,
		57158,
		57196,
		57246,
		57266,
		57704,
		48121,
		56995,
		59326,
		67600,
		57029,
		57120,
		57184,
		57163,
		57238,
		57265,
		56945,
		56971,
		56997,
		57030,
		57121,
		57186,
		94401,
		94403,
		57706,
		57157,
		57240,
		57262,
		59475,
		59478,
		59480,
		56951,
		56973,
		57005,
		57031,
		57123,
		57188,
		57167,
		57245,
		57269,
		57707,
		56948,
		57007,
		94404,
		94405,
		57032,
		50614,
		56974,
		50606,
		57125,
		57197,
		50599,
		57249,
		57271,
		56953,
		57161,
		58486,
		57708,
		56981,
		56994,
		58476,
		59484,
		59486,
		59487,
		57020,
		57200,
		92579,
		57129,
		57241,
		57165,
		57277,
		57709,
		56956,
		57000,
		59387,
		60336,
		50616,
		57023,
		50607,
		57131,
		57201,
		50600,
		57242,
		57270,
		56959,
		58487,
		57710,
		56979,
		57001,
		58478,
		59489,
		59490,
		59491,
		57024,
		57183,
		57132,
		57244,
		57154,
		57274,
		57711,
		50617,
		71101,
		94406,
		64258,
		64261,
		64259,
		64260,
		64262,
		50608,
		50601,
		56957,
		57002,
		57025,
		57210,
		58488,
		57185,
		57216,
		58480,
		57251,
		57272,
		64266,
		96284,
		57712,
		59493,
		59494,
		59502,
		57219,
		57133,
		57156,
		57213,
		57713,
		50618,
		50609,
		57026,
		57221,
		57236,
		50602,
		57122,
		57226,
		58489,
		56952,
		59338,
		58481,
		56991,
		57008,
		57187,
		57168,
		59339,
		57714,
		56984,
		57275,
		59495,
		59496,
		59503,
		57224,
		57252,
		94402,
		56972,
		57033,
		57113,
		59340,
		57172,
		57227,
		57715,
		50619,
		56943,
		57003,
		57192,
		57222,
		57257,
		60337,
		64051,
		64053,
		64255,
		50610,
		50603,
		58490,
		58482,
		57716,
		71102,
		56980,
		57006,
		57036,
		57198,
		57225,
		57248,
		62162,
		57153,
		57234,
		56944,
		56946,
		56947,
		56949,
		56950,
		56954,
		56958,
		56960,
		56975,
		56977,
		56983,
		56986,
		56988,
		56989,
		56996,
		56998,
		56999,
		57010,
		57011,
		57012,
		57014,
		57019,
		57021,
		57028,
		57034,
		57035,
		57112,
		57115,
		57116,
		57117,
		57124,
		57126,
		57127,
		57128,
		57130,
		57152,
		57155,
		57159,
		57160,
		57164,
		57170,
		57181,
		57189,
		57190,
		57191,
		57193,
		57195,
		57199,
		57202,
		57207,
		57208,
		57211,
		57214,
		57220,
		57223,
		57232,
		57233,
		57235,
		57237,
		57243,
		57247,
		57250,
		57258,
		57260,
		57261,
		57263,
		57264,
		57267,
		57268,
		57276,
		59559,
		59560,
		59561,
		61677,
		94000,
		95825,
		61177,
		94711,
		98398,
		101057,
		56987,
		61117,
		61118,
		61119,
		61120,
		50620,
		59497,
		59498,
		59504,
		50611,
		50604,
		58491,
		58483,
		64246,
		64247,
		64248,
		64249,
		64250,
		64251,
		64252,
		64253,
		64254,
		64256,
		64257,
		64268,
		64270,
		64271,
		64273,
		64274,
		64275,
		64276,
		64277,
		64278,
		64279,
		64280,
		64281,
		64282,
		64283,
		64284,
		64285,
		64286,
		64287,
		64288,
		64289,
		64291,
		64294,
		64295,
		64296,
		64297,
		64298,
		64300,
		64302,
		64303,
		64304,
		64305,
		64307,
		64308,
		64309,
		64310,
		64311,
		64313,
		64314,
		64315,
		64316,
		64317,
		64318,
		69385,
		86004,
		89368,
		89373,
		89371,
		86609,
		89372,
		89815,
		89369,
		89367,
		89370,
		92027,
		86644,
		86005,
		86616,
		86640,
		86645,
		86375,
		86401,
		86402,
		86403,
		86646,
		86647,
		86648,
		85785,
		86649,
		86641,
		86642,
		86643,
		99547,
		99548,
		99549,
		86615,
		86650,
		86652,
		86653,
		86654,
		89244,
	},
	[-1] = {
		--	套牌
		--	60,
		23677,
		23678,
		23679,
		23680,
		--	70,
		39480,
		39481,
		39483,
		39484,
		--	80,
		48221,
		48239,
		59953,
		59962,
		60245,
		60255,
		60265,
		60276,
		--85
		86043,
		86217,
		86229,
		86241,
		--	高级铸甲技术
		23231,
		23232,
		23233,
		--	祈福
		23151,
		--	伦鲁迪洛尔，上古守护者的长弓
		-- 23192,
		--	科尔戈的藏宝图
		11438,
		--	刀锋山·耗尽的聚焦水晶
		40548,
		--	刀锋山·能量枯竭的XX
		40744,
		40747,
		40748,
		40749,
		40752,
		40753,
		40754,
		40755,
		40756,
		40757,
		--	刀锋山·药剂
		40964,
		40965,
		40968,
		40970,
		42020,
		42022,
		--	源生元素
		28100,
		28101,
		28102,
		28103,
		28104,
		28105,
		28106,
		--	永恒元素
		56040,
		49245,
		56041,
		49248,
		56042,
		49244,
		56043,
		49247,
		56044,
		49246,
		56045,
		49234,
		--	附魔
		13361,
		13497,
		13632,
		13739,
		20039,
		32977,
		44123,
		74186,
		13362,
		13498,
		13633,
		13740,
		20040,
		32978,
		44122,
		74187,

		61755,
		74188,
	},
};
DataAgent.T_TradeSkill_RecipeList = T_TradeSkill_RecipeList;

local T_TradeSkill_Spec2Pid = {  };
for sid, info in next, T_Recipe_Data do
	local spec = info[index_spec];
	if spec then
		T_TradeSkill_Spec2Pid[spec] = info[index_pid];
	end
end
DataAgent.T_TradeSkill_Spec2Pid = T_TradeSkill_Spec2Pid;

--	[pid] = { { sid, [overrided rank], } }
DataAgent.T_TradeSkill_CooldownList = {
	[3] = {
		-- { 19566, 250, },	--	筛盐器
	},
	[4] = {
		-- { 17563, },	--	死灵化水	--	17562	点水成气	17561	转土成水	17565	生命归土	17560	点火成土
		-- { 17187, },	--	转化：奥金
		-- { 29688, },	--	转化：源生之能
		{ 54020, 275, 46714, },	--	转化：永恒之能
		-- { 46714, 275, },	--	转化元素
		{ 60893, },	--	诺森德炼金研究
	},
	[7] = {
		{ 55208, },	--	泰坦精钢锭
	},
	[8] = {
		-- { 18560, },	--	月布
		-- { 26751, },	--	原始月布
		-- { 31373, },	--	魔法布
		-- { 36686, },	--	暗影布
		{ 56001, },	--	月影布
		{ 56002, },	--	乌纹布
		{ 56003, },	--	法纹布
	},
	[15] = {
		-- { 47280, },	--	闪亮的玻璃
		{ 62242, },	--	冰冻棱柱
	},
	[16] = {
		{ 61288, },	--	小型铭文研究
		{ 61177, },	--	诺森德铭文研究
	},
};

DataAgent.T_PriceSpellBlackList = {
--	炼金
	[3577] = 1,		--	点铁成金	3577
	[11480] = 1,	--	转化秘银	6037
	--	元素精华
	[17559] = 1,	--	气转火		7078
	[17560] = 1,	--	火转土		7076
	[17561] = 1,	--	土转水		7080
	[17562] = 1,	--	水转气		7082
	[17563] = 1,	--	死灵转水	7080
	[17564] = 1,	--	水转死灵	12808
	[17565] = 1,	--	生命转土	7076
	[17566] = 1,	--	土转生命	12803
	-- [17187] = 1,	--	12360	--	奥金锭
	--	TBC源生元素
	[28566] = 1,	--	空气转火焰	21884
	[28567] = 1,	--	土转水		21885
	[28568] = 1,	--	火焰转土	22452
	[28569] = 1,	--	水转空气	22451
	[28580] = 1,	--	暗影转水	21885
	[28581] = 1,	--	水转暗影	22456
	[28582] = 1,	--	法力转火焰	21884
	[28583] = 1,	--	火焰转法力	22457
	[28584] = 1,	--	生命转土	22452
	[28585] = 1,	--	土转生命	21886
	[29688] = 1,	--	源生之能	23571
	--	WLK永恒元素
	[53780] = 1,	--	暗影转生命	35625
	[53779] = 1,	--	暗影转土	35624
	[53775] = 1,	--	火焰转生命	35625
	[53774] = 1,	--	火焰转水	35622
	[53776] = 1,	--	空气转水	35622
	[53777] = 1,	--	空气转土	35624
	[53771] = 1,	--	生命转暗影	35627
	[53773] = 1,	--	生命转火焰	36860
	[53784] = 1,	--	水转火焰	36860
	[53783] = 1,	--	水转空气	35623
	[53782] = 1,	--	土转暗影	35627
	[53781] = 1,	--	土转空气	35623
	[54020] = 1,	--	永恒之能	40248
	--	WLK宝石
	[66659] = 1,	--	赤玉石		36919
	[66663] = 1,	--	巨锆石		36925
	[66662] = 1,	--	恐惧石		36928
	[66660] = 1,	--	王者琥珀	36922
	[66658] = 1,	--	紫黄晶		36931
	[66664] = 1,	--	祖尔之眼	36934
--	裁缝
	-- [14342] = 1,	--	月布
	-- [26751] = 1,	--	原始月布
	-- [31373] = 1,	--	魔法布
	-- [36686] = 1,	--	暗影布
	[56001] = 1,	--	月影布
	[56002] = 1,	--	乌纹布
	[56003] = 1,	--	法纹布
--	制皮
	-- [19047] = 1,	--	15407	--	熟化毛皮
--	附魔
	[42613] = 1,	--	转化连结水晶
	[28021] = 1,	--	奥法之尘	--	奥术水晶>>奥法之尘
};
DataAgent.T_PriceItemBlackList = {
--	炼金
	--	元素精华
	[7078] = 1,
	[7076] = 1,
	[7082] = 1,
	[7080] = 1,
	[12808] = 1,
	[12803] = 1,
	-- [12360] = 1,	--	奥金锭
	--	TBC源生元素
	[21884] = 1,	--	源生火焰
	[21885] = 1,	--	源生之水
	[21886] = 1,	--	源生生命
	[22451] = 1,	--	源生空气
	[22452] = 1,	--	源生之土
	[22456] = 1,	--	源生暗影
	[22457] = 1,	--	源生法力
	[23571] = 1,	--	源生之能
	--	WLK永恒元素
	[35625] = 1,	--	永恒生命
	[35624] = 1,	--	永恒之土
	[35622] = 1,	--	永恒之水
	[35627] = 1,	--	永恒暗影
	[36860] = 1,	--	永恒火焰
	[35623] = 1,	--	永恒空气
	[40248] = 1,	--	永恒之能
	--	WLK宝石
	[36919] = 1,	--	赤玉石
	[36925] = 1,	--	巨锆石
	[36928] = 1,	--	恐惧石
	[36922] = 1,	--	王者琥珀
	[36931] = 1,	--	紫黄晶
	[36934] = 1,	--	祖尔之眼
--	裁缝
	-- [18560] = 1,	--	14342	--	月布
	-- [21845] = 1,	--	原始月布
	-- [24271] = 1,	--	魔法布
	-- [24272] = 1,	--	暗影布
	[41593] = 1,	--	乌纹布
	[41594] = 1,	--	月影布
	[41595] = 1,	--	法纹布
--	制皮
	-- [15407] = 1,	--	熟化毛皮
--	附魔
	[22448] = 1,	--	小块棱光碎片
};

DataAgent.T_MaterialVendorPrice = {
	--	BLACKSMITHING	ENGINEERING
	[5956] = 18,		-- 铁匠之锤
	[2901] = 81,		-- 矿工锄
	[2880] = 100,		-- 弱效助熔剂
	[3466] = 2000,		-- 强效助熔剂
	[3857] = 500,		-- 煤块
	[18567] = 150000,	-- 元素助熔剂
	[4399] = 200,		-- 木柴
	[4400] = 2000,		-- 沉重的树干
	[40533] = 50000,	-- 桃木树干
	[39684] = 9000,		-- 精密触发器
	[44499] = 30000000,	-- 铁魔像的零件
	[44500] = 15000000,	-- 源质排气管
	[44501] = 10000000,	-- 地精机械活塞
	-- [10648] = 500,		-- 空白的羊皮纸		--	move to glyph 普通的羊皮纸
	[10647] = 2000,		-- 墨水
	[6530] = 100,		-- 夜色虫
	[7005] = 82,		-- 剥皮小刀
	--	ALCHEMY
	[3371] = 4,			-- 空瓶
	[3372] = 40,		-- 铅瓶
	[8925] = 500,		-- 水晶瓶
	[18256] = 4000,		-- 灌魔之瓶
	[40411] = 10000,	-- 魔化瓶
	--	ENCHANGING
	[6217] = 124,		-- 铜棒
	[4470] = 38,		-- 普通木柴
	[11291] = 4500,		-- 星木
	--	TAILORING	LEATHERWORKING
	[2320] = 10,		-- 粗线
	[2321] = 100,		-- 细线
	[4291] = 500,		-- 丝线
	[8343] = 2000,		-- 粗丝线
	[14341] = 5000,		-- 符文线
	[38426] = 30000,	-- 恒金线
	[2324] = 25,		-- 漂白剂
	[2604] = 50,		-- 红色染料
	[6260] = 50,		-- 蓝色染料
	[2605] = 100,		-- 绿色染料
	[4341] = 500,		-- 黄色染料
	[4340] = 350,		-- 灰色染料
	[6261] = 1000,		-- 橙色染料
	[2325] = 1000,		-- 灰色染料
	[4342] = 2500,		-- 紫色染料
	[10290] = 2500,		-- 粉红燃料
	[4289] = 50,		-- 盐
	--	GLYPH
	[39354] = 15,		-- 轻羊皮纸
	[10648] = 125,		-- 普通的羊皮纸
	[39501] = 1250,		-- 重羊皮纸
	[39502] = 5000,		-- 坚韧羊皮纸
	--	COOKING
	[159] = 5,			-- 清凉的泉水
	[1179] = 125,		-- 冰镇牛奶
	[27860] = 1280,		-- 清洁的德拉诺之水
	[2678] = 2,			-- 甜香料
	[30817] = 5,		-- 面粉
	[2692] = 40,		-- 辣椒
	[3713] = 160,		-- 舒心草
	[2723] = 50,		-- 瓶装达拉然黑葡萄酒
	[2593] = 150,		-- 暴风城褐色酒
	[2596] = 120,		-- 矮人烈酒
	[2594] = 1500,		-- 壶装矮人蜜酒
	[2595] = 2000,		-- 罐装荒芜之地波本酒
	[2894] = 50,		-- 狂想麦酒
	[35949] = 1700,		-- 苔原浆果
	[35948] = 3200,		-- 美味雪梅
	--	MISC
	[34249] = 1000000,	--	草裙舞娃娃
	--	POISION
	[2928] = 20,		--	蚀骨灰
	[5140] = 25,		--	闪光粉
	[2930] = 50,		--	痛苦精华
	[2931] = 1000,		--	魔女之毒
	[8924] = 100,		--	堕落之尘
	[5173] = 100,		--	丧命草
	[8923] = 200,		--	苦楚精华
	--
	[5565] = 5000,		--	地狱火石
	[16583] = 10000,	--	恶魔雕像
	[17020] = 1000,		--	魔粉
	[17021] = 700,		--	野生浆果
	[17026] = 1000,		--	野生棘根草
	[22148] = 1500,		--	野生刺藤
	[44605] = 5000,		--	野生松叶
	[17028] = 700,		--	圣洁蜡烛
	[17029] = 1000,		--	神圣蜡烛
	[44615] = 2000,		--	虔诚蜡烛
	[17030] = 2000,		--	十字章
	[17031] = 1000,		--	传送符文
	[17032] = 2000,		--	传送门符文
	[17033] = 2000,		--	神圣符印
	[17034] = 200,		--	枫树种子
	[17035] = 400,		--	荆棘种子
	[17036] = 800,		--	灰木种子
	[17037] = 1400,		--	角树种子
	[17038] = 2000,		--	铁木种子
	[22147] = 5000,		--	灼草种子
	[44614] = 7000,		--	星叶种子
	[21177] = 300,		--	王者印记
	[37021] = 500,		--	尸尘
};

--[==[
--	ID	Race.raceName (enUS)	Race.clientFileString	Faction.name (enUS)		Faction.groupTag
	1	Human					Human					Alliance	Alliance,
	2	Orc						Orc						Horde		Horde,
	3	Dwarf					Dwarf					Alliance	Alliance,
	4	Night Elf				NightElf				Alliance	Alliance,
	5	Undead					Scourge					Horde		Horde,
	6	Tauren					Tauren					Horde		Horde,
	7	Gnome					Gnome					Alliance	Alliance,
	8	Troll					Troll					Horde		Horde,
	9	Goblin					Goblin					Horde		Horde,
	10	Blood Elf				BloodElf				Horde		Horde,
	11	Draenei					Draenei					Alliance	Alliance,
	12	Fel Orc					FelOrc					Alliance	Alliance,
	13	Naga					Naga_					Alliance	Alliance,
	14	Broken					Broken					Alliance	Alliance,
	15	Skeleton				Skeleton				Alliance	Alliance,
	16	Vrykul					Vrykul					Alliance	Alliance,
	17	Tuskarr					Tuskarr					Alliance	Alliance,
	18	Forest Troll			ForestTroll				Alliance	Alliance,
	19	Taunka					Taunka					Alliance	Alliance,
	20	Northrend Skeleton		NorthrendSkeleton		Alliance	Alliance,
	21	Ice Troll				IceTroll				Alliance	Alliance,
	22	Worgen					Worgen					Alliance	Alliance,
	23	Gilnean					Human					Alliance	Alliance,
	24	Pandaren				Pandaren							Neutral,
	25	Pandaren				Pandaren				Alliance	Alliance,
	26	Pandaren				Pandaren				Horde		Horde,
	27	Nightborne				Nightborne				Horde		Horde,
	28	Highmountain Tauren		HighmountainTauren		Horde		Horde,
	29	Void Elf				VoidElf					Alliance	Alliance,
	30	Lightforged Draenei		LightforgedDraenei		Alliance	Alliance,
	31	Zandalari Troll			ZandalariTroll			Horde		Horde,
	32	Kul Tiran				KulTiran				Alliance	Alliance,
	33	Human					ThinHuman				Alliance	Alliance,
	34	Dark Iron Dwarf			DarkIronDwarf			Alliance	Alliance,
	35	Vulpera					Vulpera					Horde		Horde,
	36	Mag'har Orc				MagharOrc				Horde		Horde,
	37	Mechagnome				Mechagnome				Alliance	Alliance,
]==]

DataAgent.T_RaceBonus = {
	--	Gnome
	[7] = {
		[9] = 15,
	},
	--	BloodElf
	[10] = {
		[10] = 10,
	},
	--	Draenei
	[11] = {
		[15] = 5,
	},
};

DataAgent.T_SkillTools = {  };

T_Recipe_Data[15628][index_spec] = 20222;	--	地精工程学续费礼包开出
T_Recipe_Data[15633][index_spec] = 20219;	--	侏儒工程学续费礼包开出

