local ALName, ALPrivate = ...

local AtlasLoot = _G.AtlasLootMY
local Profession = {}
AtlasLoot.Data.Profession = Profession
local Recipe, ContentPhase
local AL = AtlasLoot.Locales
local ALIL = AtlasLoot.IngameLocales

local format = string.format

local LOC_STRING_DESC = "|cff00ff00"..AL["L-Click"]..":|r %s"
local LOC_STRING_DESC2 = AL["|cff00ff00Left-Click:|r Show reagents."]
local FORMAT_STRING_SKILL = "|cffff8040%d|r |cffffff00%d|r |cff40bf40%d|r |cff808080%d|r"
local FORMAT_STRING_SKILL2 = "|cffffff00%d|r |cff40bf40%d|r |cff808080%d|r"

local PROFESSION_DEFAULT = 0
local PROFESSION_NAME = {
	[0]  = UNKNOWN,	   			   -- UNKNOWN
	[1]  = ALIL["First Aid"],      -- First Aid
	[2]  = ALIL["Blacksmithing"],  -- Blacksmithing
	[3]  = ALIL["Leatherworking"], -- Leatherworking
	[4]  = ALIL["Alchemy"],        -- Alchemy
	[5]  = ALIL["Herbalism"],      -- Herbalism
	[6]  = ALIL["Cooking"],        -- Cooking
	[7]  = ALIL["Mining"],         -- Mining
	[8]  = ALIL["Tailoring"],      -- Tailoring
	[9]  = ALIL["Engineering"],    -- Engineering
	[10] = ALIL["Enchanting"],     -- Enchanting
	[11] = ALIL["Fishing"],        -- Fishing
    [12] = ALIL["Skinning"],       -- Skinning
    [13] = ALIL["Poisons"],        -- Poisons
    [14] = ALIL["Jewelcrafting"],  -- Jewelcrafting
	[15] = ALIL["Inscription"],    -- Inscription
}

local PROFESSION_TEXT_MAX_LENGTH = 15
local PROFESSION_TEXT = {
	[0]  = LOC_STRING_DESC2,	                            -- UNKNOWN
}
local PROFESSION_TEXT_SHORT = {
	[0]  = LOC_STRING_DESC2,
}
for i = 1, #PROFESSION_NAME do
	PROFESSION_TEXT[i] = format(LOC_STRING_DESC, PROFESSION_NAME[i])
	if PROFESSION_NAME[i]:len() > PROFESSION_TEXT_MAX_LENGTH then
		PROFESSION_TEXT_SHORT[i] = format(LOC_STRING_DESC, PROFESSION_NAME[i]:sub(1,PROFESSION_TEXT_MAX_LENGTH-3).."...")
	else
		PROFESSION_TEXT_SHORT[i] = format(LOC_STRING_DESC, PROFESSION_NAME[i])
	end
end
Profession.PROFESSION_TEXT = PROFESSION_TEXT

local DUMMY_ICON = "Interface\\Icons\\INV_Misc_QuestionMark";
local PROFESSION_ICON = {
	[0]  = DUMMY_ICON,	          -- UNKNOWN
	[1]  = GetSpellTexture(3273), -- First Aid
	[2]  = GetSpellTexture(2018), -- Blacksmithing
	[3]  = GetSpellTexture(2108), -- Leatherworking
	[4]  = GetSpellTexture(2259), -- Alchemy
	[5]  = GetSpellTexture(2366), -- Herbalism
	[6]  = GetSpellTexture(2550), -- Cooking
	[7]  = GetSpellTexture(2575), -- Mining
	[8]  = GetSpellTexture(3908), -- Tailoring
	[9]  = GetSpellTexture(4036), -- Engineering
	[10] = GetSpellTexture(7411), -- Enchanting
	[11] = GetSpellTexture(7732), -- Fishing
    [12] = GetSpellTexture(8618), -- Skinning
    [13] = GetSpellTexture(2842), -- Rogue: Poisons
    [14] = 134071,                -- Jewelcrafting
	[15] = 237171,     			  -- Inscription
}

local PROFESSION, PROFESSION_DATA = AtlasLoot:GetGameVersionDataTable()
_G['ATLAS_PRP']=PROFESSION	
PROFESSION_DATA.CLASSIC = {
	-- [spellID] = { createdItemID, prof, minLvl, lowLvl, highLvl, reagents{}, reagentsCount{}, numCreatedItems }
	[818] = {nil,6,25,0,0,{4470},{1}},
	[2149] = {2302,3,1,40,70,{2318,2320},{2,1}},
	[2152] = {2304,3,1,30,60,{2318},{1}},
	[2153] = {2303,3,30,45,75,{2318,2320},{4,1}},
	[2156] = {2305,3,30,1,1,{2318,2320},{8,2}},
	[2157] = {2306,3,35,1,1,{2318,2320},{6,2}},
	[2158] = {2307,3,90,120,150,{2318,2320},{7,2}},
	[2159] = {2308,3,85,105,135,{2318,2321},{10,2}},
	[2160] = {2300,3,50,70,100,{2318,2320},{8,4}},
	[2161] = {2309,3,65,85,115,{2318,2320},{8,5}},
	[2162] = {2310,3,65,90,120,{2318,2320},{5,2}},
	[2163] = {2311,3,60,90,120,{2318,2320,2324},{8,2,1}},
	[2164] = {2312,3,75,105,135,{4231,2318,2320},{1,4,2}},
	[2165] = {2313,3,75,115,130,{2319,2320},{4,1}},
	[2166] = {2314,3,125,145,170,{2319,4231,2321},{10,2,2}},
	[2167] = {2315,3,100,125,150,{2319,2321,4340},{4,2,1}},
	[2168] = {2316,3,110,135,160,{2319,2321,4340},{8,1,1}},
	[2169] = {2317,3,100,125,150,{2319,2321,4340},{6,1,1}},
	[2329] = {2454,4,1,55,95,{2449,765,3371},{1,1,1}},
	[2330] = {118,4,1,55,95,{2447,765,3371},{1,1,1}},
	[2331] = {2455,4,30,65,105,{785,765,3371},{1,1,1}},
	[2332] = {2456,4,40,70,110,{785,2447,3371},{2,1,1}},
	[2333] = {3390,4,140,165,205,{3355,2452,3372},{1,1,1}},
	[2334] = {2458,4,50,80,120,{2449,2447,3371},{2,1,1}},
	[2335] = {2459,4,60,90,130,{2452,2450,3371},{1,1,1}},
	[2336] = {2460,4,70,100,140,{2449,785,3371},{2,2,1}},
	[2337] = {858,4,80,85,125,{118,2450},{1,1}},
	[2385] = {2568,8,10,45,70,{2996,2320},{1,1}},
	[2386] = {2569,8,65,90,125,{2996,2320,2318},{3,1,1}},
	[2387] = {2570,8,1,35,60,{2996,2320},{1,1}},
	[2389] = {2572,8,40,65,100,{2996,2320,2604},{3,2,2}},
	[2392] = {2575,8,40,65,100,{2996,2320,2604},{2,1,1}},
	[2393] = {2576,8,1,35,60,{2996,2320,2324},{1,1,1}},
	[2394] = {2577,8,40,65,100,{2996,2320,6260},{2,1,1}},
	[2395] = {2578,8,70,95,130,{2996,2318,2321},{4,1,1}},
	[2396] = {2579,8,70,95,130,{2996,2321,2605},{3,1,1}},
	[2397] = {2580,8,60,85,120,{2996,2320},{2,3}},
	[2399] = {2582,8,85,110,145,{2997,2321,2605},{2,2,1}},
	[2401] = {2583,8,95,120,155,{2997,2321,2318},{4,2,2}},
	[2402] = {2584,8,75,100,135,{2997,2321},{1,1}},
	[2403] = {2585,8,105,130,165,{2997,2321,4340},{4,3,1}},
	[2406] = {2587,8,100,110,130,{2997,2321,4340},{2,1,1}},
	[2538] = {2679,6,1,45,85,{2672},{1}},
	[2539] = {2680,6,30,50,90,{2672,2678},{1,1}},
	[2540] = {2681,6,1,45,85,{769},{1}},
	[2541] = {2684,6,65,90,130,{2673},{1}},
	[2542] = {724,6,50,90,130,{723,2678},{1,1}},
	[2543] = {733,6,75,115,155,{729,730,731},{1,1,1}},
	[2544] = {2683,6,75,115,155,{2674,2678},{1,1}},
	[2545] = {2682,6,85,125,165,{2675,2678},{1,1}},
	[2546] = {2687,6,110,120,160,{2677,2678},{1,1}},
	[2547] = {1082,6,100,135,175,{1081,1080},{1,1}},
	[2548] = {2685,6,110,130,170,{2677,2692},{2,1}},
	[2549] = {1017,6,100,140,180,{1015,2665},{2,1},3},
	[2657] = {2840,7,25,25,70,{2770},{1}},
	[2658] = {2842,7,75,100,125,{2775},{1}},
	[2659] = {2841,7,65,65,115,{2840,3576},{1,1},2},
	[2660] = {2862,2,1,15,55,{2835},{1}},
	[2661] = {2851,2,55,75,115,{2840},{6}},
	[2662] = {2852,2,40,50,90,{2840},{4}},
	[2663] = {2853,2,1,20,60,{2840},{2}},
	[2664] = {2854,2,65,115,140,{2840,3470},{10,3}},
	[2665] = {2863,2,75,65,80,{2836},{1}},
	[2666] = {2857,2,80,110,150,{2840},{10}},
	[2667] = {2864,2,80,120,160,{2840,1210,3470},{12,1,2}},
	[2668] = {2865,2,95,145,175,{2841},{6}},
	[2670] = {2866,2,105,145,175,{2841},{7}},
	[2671] = {2867,2,100,145,175,{2841},{4}},
	[2672] = {2868,2,120,150,180,{2841,3478},{5,2}},
	[2673] = {2869,2,130,160,190,{2841,2842,3478,1705},{10,2,2,1}},
	[2674] = {2871,2,125,125,140,{2838},{1}},
	[2675] = {2870,2,135,175,205,{2841,1206,1705,5500,2842},{20,2,2,2,4}},
	[2737] = {2844,2,30,55,95,{2840,2880,2589},{6,1,2}},
	[2738] = {2845,2,35,60,100,{2840,2880,2589},{6,1,2}},
	[2739] = {2847,2,40,65,105,{2840,2880,2589},{6,1,2}},
	[2740] = {2848,2,75,140,170,{2841,2880,2319},{6,4,1}},
	[2741] = {2849,2,85,145,175,{2841,2880,2319},{7,4,1}},
	[2742] = {2850,2,95,150,180,{2841,2880,2319},{5,4,2}},
	[2795] = {2888,6,25,60,100,{2886,2894},{1,1}},
	[2835] = {2892,13,1,175,225,{5173,3372},{1,1}},
	[2837] = {2893,13,1,215,265,{5173,3372},{2,1}},
	[2881] = {2318,3,1,20,40,{2934},{3}},
	[2963] = {2996,8,1,25,50,{2589},{2}},
	[2964] = {2997,8,75,90,105,{2592},{3}},
	[3115] = {3239,2,1,15,55,{2835,2589},{1,1}},
	[3116] = {3240,2,65,65,80,{2836,2592},{1,1}},
	[3117] = {3241,2,125,125,140,{2838,2592},{1,1}},
	[3170] = {3382,4,15,60,100,{2447,2449,3371},{1,2,1}},
	[3171] = {3383,4,90,120,160,{785,2450,3371},{1,2,1}},
	[3172] = {3384,4,110,135,175,{785,3355,3371},{3,1,1}},
	[3173] = {3385,4,120,145,185,{785,3820,3371},{1,1,1}},
	[3174] = {3386,4,120,145,185,{1288,2453,3372},{1,1,1}},
	[3175] = {3387,4,250,275,315,{8839,8845,8925},{2,1,1}},
	[3176] = {3388,4,125,150,190,{2453,2450,3372},{2,2,1}},
	[3177] = {3389,4,130,155,195,{3355,3820,3372},{1,1,1}},
	[3188] = {3391,4,150,175,215,{2449,3356,3372},{1,1,1}},
	[3230] = {2457,4,50,80,120,{2452,765,3371},{1,1,1}},
	[3275] = {1251,1,1,30,60,{2589},{1}},
	[3276] = {2581,1,40,50,100,{2589},{2}},
	[3277] = {3530,1,80,80,150,{2592},{1}},
	[3278] = {3531,1,115,115,185,{2592},{2}},
	[3292] = {3487,2,95,135,175,{2840,2880,818,2319},{14,2,2,2}},
	[3293] = {3488,2,35,75,115,{2840,2880,774,3470,2318},{12,2,2,2,2}},
	[3294] = {3489,2,70,110,150,{2840,2880,2842,3470,2318},{10,2,2,2,2}},
	[3295] = {3490,2,125,155,185,{2841,3466,2459,1210,3478,2319},{4,1,1,2,2,2}},
	[3296] = {3491,2,130,160,190,{2841,3466,1206,1210,3478,2319},{8,1,1,1,2,2}},
	[3297] = {3492,2,145,175,205,{3575,3466,3391,1705,3478,2319},{6,2,1,2,2,2}},
	[3304] = {3576,7,65,50,75,{2771},{1}},
	[3307] = {3575,7,125,130,140,{2772},{1}},
	[3308] = {3577,7,155,170,185,{2776},{1}},
	[3319] = {3469,2,20,60,100,{2840},{8}},
	[3320] = {3470,2,25,45,85,{2835},{2}},
	[3321] = {3471,2,35,75,115,{2840,774,3470},{8,1,2}},
	[3323] = {3472,2,40,80,120,{2840,3470},{8,2}},
	[3324] = {3473,2,45,85,125,{2840,2321,3470},{8,2,3}},
	[3325] = {3474,2,60,100,140,{2840,818,774},{8,1,1}},
	[3326] = {3478,2,75,75,100,{2836},{2}},
	[3328] = {3480,2,110,140,170,{2841,1210,3478},{5,1,1}},
	[3330] = {3481,2,125,155,185,{2841,2842,3478},{8,2,2}},
	[3331] = {3482,2,130,160,190,{2841,2842,3478},{6,1,2}},
	[3333] = {3483,2,135,165,195,{2841,2842,3478},{8,1,2}},
	[3334] = {3484,2,145,175,205,{3575,1705,3478,2605},{4,2,2,1}},
	[3336] = {3485,2,150,180,210,{3575,5498,3478,2605},{4,2,2,1}},
	[3337] = {3486,2,125,125,150,{2838},{3}},
	[3370] = {3662,6,80,120,160,{2924,2678},{1,1}},
	[3371] = {3220,6,60,100,140,{3173,3172,3174},{1,1,1},2},
	[3372] = {3663,6,90,130,170,{1468,2692},{2,1}},
	[3373] = {3664,6,120,160,200,{3667,2692},{1,1}},
	[3376] = {3665,6,130,170,210,{3685,2692},{1,1}},
	[3377] = {3666,6,110,150,190,{2251,2692},{2,1}},
	[3397] = {3726,6,110,150,190,{3730,2692},{1,1}},
	[3398] = {3727,6,125,175,215,{3731,2692},{1,1}},
	[3399] = {3728,6,150,190,230,{3731,3713},{2,1}},
	[3400] = {3729,6,175,215,255,{3712,3713},{1,1}},
	[3420] = {3775,13,1,125,175,{2930,3371},{1,1}},
	[3421] = {3776,13,1,275,325,{8923,8925},{3,1}},
	[3447] = {929,4,110,135,175,{2453,2450,3372},{1,1,1}},
	[3448] = {3823,4,165,185,225,{3818,3355,3372},{1,1,1}},
	[3449] = {3824,4,165,190,230,{3818,3369,3372},{4,4,1}},
	[3450] = {3825,4,175,195,235,{3355,3821,3372},{1,1,1}},
	[3451] = {3826,4,180,200,240,{3357,2453,3372},{1,1,1}},
	[3452] = {3827,4,160,180,220,{3820,3356,3372},{1,1,1}},
	[3453] = {3828,4,195,215,255,{3358,3818,3372},{1,1,1}},
	[3454] = {3829,4,200,220,260,{3358,3819,3372},{4,2,1}},
	[3491] = {3848,2,105,135,165,{2841,2880,3470,818,2319},{6,4,2,1,1}},
	[3492] = {3849,2,160,185,210,{3575,3466,3486,1705,4234},{6,2,1,2,3}},
	[3493] = {3850,2,175,200,225,{3575,3466,3486,1529,4234},{8,2,2,2,3}},
	[3494] = {3851,2,155,180,205,{3575,3466,3486,2842,4234},{8,2,1,4,2}},
	[3495] = {3852,2,170,195,220,{3575,3577,1705,3466,4234,3486},{10,4,2,2,2,2}},
	[3496] = {3853,2,180,205,230,{3859,3466,3486,1705,4234},{8,2,2,3,3}},
	[3497] = {3854,2,200,225,250,{3859,3466,3486,1529,3829,4234},{8,2,2,2,1,4}},
	[3498] = {3855,2,185,210,235,{3575,3466,3486,3577,4234},{14,2,2,4,2}},
	[3500] = {3856,2,200,225,250,{3859,3466,3486,3864,3824,4234},{10,2,3,2,1,3}},
	[3501] = {3835,2,165,190,215,{3575,2605},{6,1}},
	[3502] = {3836,2,170,195,220,{3575,3864,2605},{12,1,1}},
	[3503] = {3837,2,190,215,240,{3859,3577,3486},{8,2,2}},
	[3504] = {3840,2,160,185,210,{3575,3486,2605},{7,1,1}},
	[3505] = {3841,2,175,200,225,{3859,3577,3486},{6,2,1}},
	[3506] = {3842,2,155,180,205,{3575,3486,2605},{8,1,1}},
	[3507] = {3843,2,170,195,220,{3575,3577,3486},{10,2,1}},
	[3508] = {3844,2,180,205,230,{3575,3486,1529,1206,4255},{20,4,2,2,1}},
	[3511] = {3845,2,195,220,245,{3859,3577,3486,1529},{12,2,4,2}},
	[3513] = {3846,2,185,210,235,{3859,3864,1705,3486},{8,1,1,2}},
	[3515] = {3847,2,200,225,250,{3859,3577,3486,3864},{10,4,4,1}},
	[3569] = {3859,7,165,165,165,{3575,3857},{1,1}},
	[3753] = {4237,3,25,55,85,{2318,2320},{6,1}},
	[3755] = {4238,8,45,70,105,{2996,2320},{3,3}},
	[3756] = {4239,3,55,85,115,{2318,2320},{3,2}},
	[3757] = {4240,8,80,105,140,{2997,2321},{3,1}},
	[3758] = {4241,8,95,120,155,{2997,2605,2321},{4,1,1}},
	[3759] = {4242,3,75,105,135,{4231,2318,2320},{1,6,2}},
	[3760] = {3719,3,150,170,190,{4234,2321},{5,2}},
	[3761] = {4243,3,85,115,145,{4231,2318,2320},{3,6,4}},
	[3762] = {4244,3,100,125,150,{4243,4231,2320},{1,2,2}},
	[3763] = {4246,3,80,110,140,{2318,2320},{6,2}},
	[3764] = {4247,3,145,170,195,{2319,2321},{14,4}},
	[3765] = {4248,3,120,155,180,{2312,4233,2321,4340},{1,1,1,1}},
	[3766] = {4249,3,125,150,175,{4246,4233,2321,4340},{1,1,2,1}},
	[3767] = {4250,3,120,145,170,{2319,3383,2321},{8,1,2}},
	[3768] = {4251,3,130,155,180,{4233,2319,2321},{1,4,1}},
	[3769] = {4252,3,140,165,190,{2319,3390,4340,2321},{12,1,1,2}},
	[3770] = {4253,3,135,160,185,{2319,4233,3389,3182,2321},{4,2,2,2,2}},
	[3771] = {4254,3,150,170,190,{4234,5637,2321},{6,2,1}},
	[3772] = {4255,3,155,175,195,{4234,2605,2321},{9,2,4}},
	[3773] = {4256,3,175,195,215,{4236,4234,3824,2321},{2,12,1,2}},
	[3774] = {4257,3,160,180,200,{4236,4234,2321,2605,7071},{1,5,1,1,1}},
	[3775] = {4258,3,170,190,210,{4236,4234,2321,7071},{2,4,1,1}},
	[3776] = {4259,3,180,200,220,{4236,4234,2605,2321},{2,6,1,1}},
	[3777] = {4260,3,195,215,235,{4234,4236,4291},{6,2,1}},
	[3778] = {4262,3,185,205,225,{4236,5500,1529,3864,2321},{4,2,2,1,1}},
	[3779] = {4264,3,200,220,240,{4234,4236,4096,5633,4291,7071},{6,2,2,1,1,1}},
	[3780] = {4265,3,150,170,190,{4234,2321},{5,1}},
	[3813] = {4245,8,150,170,200,{4305,4234,2321},{3,2,3}},
	[3816] = {4231,3,35,55,75,{783,4289},{1,1}},
	[3817] = {4233,3,100,115,130,{4232,4289},{1,1}},
	[3818] = {4236,3,150,160,170,{4235,4289},{1,3}},
	[3839] = {4305,8,125,135,145,{4306},{4}},
	[3840] = {4307,8,35,60,95,{2996,2320},{2,1}},
	[3841] = {4308,8,60,85,120,{2996,2320,2605},{3,2,1}},
	[3842] = {4309,8,70,95,130,{2996,2321},{4,2}},
	[3843] = {4310,8,85,110,145,{2997,2321},{3,1}},
	[3844] = {4311,8,100,125,160,{2997,2321,5498},{3,2,2}},
	[3845] = {4312,8,80,105,140,{2996,2318,2321},{5,2,1}},
	[3847] = {4313,8,95,120,155,{2997,2318,2321,2604},{4,2,1,2}},
	[3848] = {4314,8,110,135,170,{2997,2321},{3,2}},
	[3849] = {4315,8,120,145,180,{2997,2319,2321},{6,2,2}},
	[3850] = {4316,8,110,135,170,{2997,2321},{5,4}},
	[3851] = {4317,8,125,150,185,{2997,5500,2321},{6,1,3}},
	[3852] = {4318,8,130,150,180,{2997,2321,3383},{4,3,1}},
	[3854] = {4319,8,145,165,195,{4305,4234,6260,2321},{3,2,2,2}},
	[3855] = {4320,8,125,150,185,{4305,2319,3182,5500},{2,4,4,2}},
	[3856] = {4321,8,140,160,190,{4305,3182,2321},{3,1,2}},
	[3857] = {4322,8,165,185,215,{4305,2321,4337},{3,2,2}},
	[3858] = {4323,8,170,190,220,{4305,4291,3824},{4,1,1}},
	[3859] = {4324,8,150,170,200,{4305,6260},{5,4}},
	[3860] = {4325,8,175,195,225,{4305,4291,4337},{4,1,2}},
	[3861] = {4326,8,185,205,235,{4305,3827,4291},{4,1,1}},
	[3862] = {4327,8,200,220,250,{4339,4291,3829,4337},{3,2,1,2}},
	[3863] = {4328,8,180,200,230,{4305,4337,7071},{4,2,1}},
	[3864] = {4329,8,200,220,250,{4339,4234,3864,7071,4291},{4,4,1,1,1}},
	[3865] = {4339,8,175,180,185,{4338},{5}},
	[3866] = {4330,8,110,135,170,{2997,2604,2321},{3,2,1}},
	[3868] = {4331,8,125,150,185,{2997,5500,2321,2324},{4,1,4,2}},
	[3869] = {4332,8,135,145,155,{4305,4341,2321},{1,1,1}},
	[3870] = {4333,8,155,165,175,{4305,4340,2321},{2,2,1}},
	[3871] = {4334,8,170,180,190,{4305,2324,2321},{3,2,1}},
	[3872] = {4335,8,185,195,205,{4305,4342,4291},{4,1,1}},
	[3873] = {4336,8,200,210,220,{4305,2325,4291},{5,1,1}},
	[3914] = {4343,8,30,55,90,{2996,2320},{2,1}},
	[3915] = {4344,8,1,35,60,{2996,2320},{1,1}},
	[3918] = {4357,9,1,20,40,{2835},{1}},
	[3919] = {4358,9,1,30,60,{4357,2589},{2,1},2},
	[3920] = {8067,9,30,30,60,{4357,2840},{1,1},200},
	[3922] = {4359,9,30,45,60,{2840},{1}},
	[3923] = {4360,9,30,60,90,{2840,4359,4357,2589},{1,1,2,1},2},
	[3924] = {4361,9,50,80,110,{2840,2880},{2,1}},
	[3925] = {4362,9,50,80,110,{4361,4359,4399},{1,1,1}},
	[3926] = {4363,9,65,95,125,{4359,2840,2589},{2,1,2}},
	[3928] = {4401,9,75,105,135,{4363,4359,2840,774},{1,1,1,2}},
	[3929] = {4364,9,75,85,95,{2836},{1}},
	[3930] = {8068,9,75,85,95,{4364,2840},{1,1},200},
	[3931] = {4365,9,75,90,105,{4364,2589},{3,1}},
	[3932] = {4366,9,85,115,145,{4363,4359,2841,2592},{1,2,1,1}},
	[3933] = {4367,9,100,130,160,{4364,4363,2318,159},{2,1,1,1}},
	[3934] = {4368,9,100,130,160,{2318,818},{6,2}},
	[3936] = {4369,9,105,130,155,{4361,4359,4399,2319},{2,4,1,2}},
	[3937] = {4370,9,105,105,155,{2840,4364,4404},{3,4,1},2},
	[3938] = {4371,9,105,105,155,{2841,2880},{2,1}},
	[3939] = {4372,9,120,145,170,{4371,4359,4400,1206},{2,2,1,3}},
	[3940] = {4373,9,120,145,170,{2319,1210},{4,2}},
	[3941] = {4374,9,120,120,170,{4364,2841,4404,2592},{4,2,1,1}},
	[3942] = {4375,9,125,125,175,{2841,2592},{2,1}},
	[3944] = {4376,9,125,125,175,{4375,4402},{1,1}},
	[3945] = {4377,9,125,125,145,{2838},{1}},
	[3946] = {4378,9,125,125,145,{4377,2592},{2,1}},
	[3947] = {8069,9,125,125,145,{4377,2841},{1,1},200},
	[3949] = {4379,9,130,155,180,{4371,4375,4400,2842},{2,2,1,3}},
	[3950] = {4380,9,140,140,190,{4377,2841,4404},{2,3,1},2},
	[3952] = {4381,9,140,165,190,{4371,4375,2319,1206},{1,2,2,1}},
	[3953] = {4382,9,145,145,195,{2841,2319,2592},{2,1,1}},
	[3954] = {4383,9,145,170,195,{4371,4375,4400,1705},{3,3,1,2}},
	[3955] = {4384,9,150,175,200,{4382,4375,4377,2592},{1,1,2,2}},
	[3956] = {4385,9,150,175,200,{2319,1206,4368},{4,2,1}},
	[3957] = {4386,9,155,175,195,{4375,3829},{1,1}},
	[3958] = {4387,9,160,160,180,{3575},{2}},
	[3959] = {4388,9,160,180,200,{4375,4306,1529,4371},{3,2,1,1}},
	[3960] = {4403,9,165,185,205,{4371,4387,4377,2319},{4,1,4,4}},
	[3961] = {4389,9,170,170,210,{3575,10558},{1,1}},
	[3962] = {4390,9,175,175,215,{3575,4377,4306},{1,1,1},2},
	[3963] = {4391,9,175,175,215,{4387,4382,4389,4234},{2,1,2,4}},
	[3965] = {4392,9,185,185,225,{4387,4382,4389,4234},{1,1,1,4}},
	[3966] = {4393,9,185,205,225,{4234,3864},{6,2}},
	[3967] = {4394,9,190,190,230,{3575,4377,4404},{3,3,1},2},
	[3968] = {4395,9,195,215,235,{4377,3575,4389},{3,2,1}},
	[3969] = {4396,9,200,220,240,{4382,4387,4389,3864,7191},{1,4,4,2,1}},
	[3971] = {4397,9,200,220,240,{4389,1529,1705,3864,7191},{4,2,2,2,1}},
	[3972] = {4398,9,200,200,240,{10505,4234,159},{2,2,1}},
	[3973] = {4404,9,90,110,140,{2842},{1},5},
	[3977] = {4405,9,60,90,120,{4361,774,4359},{1,1,1}},
	[3978] = {4406,9,110,135,160,{4371,1206},{1,1}},
	[3979] = {4407,9,180,200,220,{4371,1529,3864},{1,1,1}},
	[4094] = {4457,6,175,215,255,{3404,2692},{1,1}},
	[4096] = {4455,3,165,185,205,{4461,4234,2321},{6,4,2}},
	[4097] = {4456,3,165,185,205,{4461,4234,2321},{4,4,2}},
	[4508] = {4596,4,50,80,120,{3164,2447,3371},{1,1,1}},
	[4942] = {4623,4,215,230,270,{3858,3821,3372},{1,1,1}},
	[5244] = {5081,3,40,70,100,{5082,2318,2320},{3,4,1}},
	[5763] = {5237,13,1,150,200,{2928,2930,3371},{1,1,1}},
	[6412] = {5472,6,10,50,90,{5465},{1}},
	[6413] = {5473,6,20,60,100,{5466},{1}},
	[6414] = {5474,6,35,75,115,{5467,2678},{1,1},2},
	[6415] = {5476,6,50,90,130,{5468,2678},{1,1},2},
	[6416] = {5477,6,50,90,130,{5469,4536},{1,1},2},
	[6417] = {5478,6,90,130,170,{5051},{1},2},
	[6418] = {5479,6,100,140,180,{5470,2692},{1,1},2},
	[6419] = {5480,6,110,150,190,{5471,2678},{1,4},2},
	[6458] = {5507,9,135,160,185,{4371,4375,4363,1206},{2,2,1,1}},
	[6499] = {5525,6,50,90,130,{5503,159},{1,1}},
	[6500] = {5527,6,125,165,205,{5504,2692},{1,1}},
	[6501] = {5526,6,90,130,170,{5503,1179,2678},{1,1,1}},
	[6510] = {5530,13,1,170,220,{3818},{1},3},
	[6517] = {5540,2,110,140,170,{2841,3466,5498,3478},{6,1,2,2}},
	[6518] = {5541,2,140,170,200,{2841,3466,5500,3478,2319},{10,1,1,2,2}},
	[6521] = {5542,8,90,115,150,{2997,2321,5498},{3,2,1}},
	[6617] = {5631,4,60,90,130,{5635,2450,3371},{1,1,1}},
	[6618] = {5633,4,175,195,235,{5637,3356,3372},{1,1,1}},
	[6619] = {5632,4,125,150,190,{5636,3356,3372},{1,1,1}},
	[6624] = {5634,4,150,175,215,{6370,3820,3372},{2,1,1}},
	[6651] = {5654,13,120,1,1,{1288,3372},{1,1}},
	[6661] = {5739,3,190,210,230,{4234,2321,7071},{14,2,1}},
	[6686] = {5762,8,70,95,130,{2996,2321,2604},{4,1,1}},
	[6688] = {5763,8,115,140,175,{2997,2604,2321},{4,1,1}},
	[6690] = {5766,8,135,155,185,{4305,2321,3182},{2,2,2}},
	[6692] = {5770,8,150,170,200,{4305,2321,3182},{4,2,2}},
	[6693] = {5764,8,175,195,225,{4305,4234,2321,2605},{4,3,3,1}},
	[6695] = {5765,8,185,205,235,{4305,2325,2321},{5,1,4}},
	[6702] = {5780,3,90,120,150,{5784,2318,2321},{8,6,1}},
	[6703] = {5781,3,95,125,155,{5784,4231,2318,2321},{12,1,8,1}},
	[6704] = {5782,3,170,190,210,{5785,4236,4234,2321},{12,1,10,3}},
	[6705] = {5783,3,190,210,230,{5785,4236,4234,4291},{16,1,14,1}},
	[7126] = {5957,3,1,40,70,{2318,2320},{3,1}},
	[7133] = {5958,3,105,130,155,{2319,2997,2321},{8,1,1}},
	[7135] = {5961,3,115,140,165,{2319,4340,2321},{12,1,1}},
	[7147] = {5962,3,160,180,200,{4234,4305,2321},{12,2,2}},
	[7149] = {5963,3,170,190,210,{4234,2321,1206},{10,2,1}},
	[7151] = {5964,3,175,195,215,{4234,4236,2321},{8,1,2}},
	[7153] = {5965,3,185,205,225,{4234,4305,4291},{14,2,2}},
	[7156] = {5966,3,190,210,230,{4234,4236,4291},{4,1,1}},
	[7179] = {5996,4,90,120,160,{3820,6370,3371},{1,2,1}},
	[7181] = {1710,4,155,175,215,{3357,3356,3372},{1,1,1}},
	[7183] = {5997,4,1,55,95,{765,3371},{2,1}},
	[7213] = {6038,6,175,215,255,{4655,2692},{1,1}},
	[7221] = {6042,2,150,180,210,{3575,3478},{6,4}},
	[7222] = {6043,2,165,190,215,{3575,3478,1705},{4,2,1}},
	[7223] = {6040,2,185,210,235,{3859,3486},{5,2}},
	[7224] = {6041,2,190,215,240,{3859,3486,4234},{8,2,4}},
	[7255] = {6051,4,100,130,170,{2453,2452,3371},{1,1,1}},
	[7256] = {6048,4,135,160,200,{3369,3356,3372},{1,1,1}},
	[7257] = {6049,4,165,210,250,{4402,6371,3372},{1,1,1}},
	[7258] = {6050,4,190,205,245,{3819,3821,3372},{1,1,1}},
	[7259] = {6052,4,190,210,250,{3357,3820,3372},{1,1,1}},
	[7408] = {6214,2,65,105,145,{2840,2880,2318},{12,2,2}},
	[7418] = {nil,10,70,70,110,{10940},{1}},
	[7420] = {nil,10,15,70,110,{10940},{1}},
	[7421] = {6218,10,1,5,10,{6217,10940,10938},{1,1,1}},
	[7426] = {nil,10,40,90,130,{10940,10938},{2,1}},
	[7428] = {nil,10,80,80,120,{10938,10940},{1,1}},
	[7430] = {6219,9,50,70,90,{2840},{6}},
	[7443] = {nil,10,20,80,120,{10938},{1}},
	[7451] = {nil,10,60,1,1,{765},{2}},
	[7454] = {nil,10,45,95,135,{10940,10938},{1,2}},
	[7457] = {nil,10,50,100,140,{10940},{3}},
	[7623] = {6238,8,30,55,90,{2996,2320},{3,1}},
	[7624] = {6241,8,30,55,90,{2996,2320,2324},{3,1,1}},
	[7629] = {6239,8,55,80,115,{2996,2320,2604},{3,1,1}},
	[7630] = {6240,8,55,80,115,{2996,2320,6260},{3,1,1}},
	[7633] = {6242,8,70,95,130,{2996,2320,6260},{4,2,2}},
	[7636] = {6243,8,90,115,150,{2997,2321,2605},{3,2,1}},
	[7639] = {6263,8,100,125,160,{2997,2321,6260},{4,2,2}},
	[7643] = {6264,8,115,140,175,{2997,2321,2604},{5,3,3}},
	[7745] = {nil,10,100,130,170,{10940,10978},{4,1}},
	[7748] = {nil,10,60,105,145,{10940,10938},{2,2}},
	[7751] = {6290,6,1,45,85,{6291},{1}},
	[7752] = {787,6,1,45,85,{6303},{1}},
	[7753] = {4592,6,50,90,130,{6289},{1}},
	[7754] = {6316,6,50,90,130,{6317,2678},{1,1}},
	[7755] = {4593,6,100,140,180,{6308},{1}},
	[7766] = {nil,10,60,105,145,{10938},{2}},
	[7771] = {nil,10,90,110,150,{10940,10939},{3,1}},
	[7776] = {nil,10,80,115,155,{10939,10938},{1,1}},
	[7779] = {nil,10,80,115,155,{10940,10939},{2,1}},
	[7782] = {nil,10,80,115,155,{10940},{5}},
	[7786] = {nil,10,90,120,160,{10940,10939},{4,2}},
	[7788] = {nil,10,90,120,160,{10940,10939,10978},{2,1,1}},
	[7793] = {nil,10,100,130,170,{10939},{3}},
	[7795] = {6339,10,100,130,170,{6338,10940,10939,1210},{1,6,3,1}},
	[7817] = {6350,2,95,125,155,{2841,3470},{6,6}},
	[7818] = {6338,2,100,105,110,{2842,3470},{1,2}},
	[7827] = {5095,6,50,90,130,{6361},{1}},
	[7828] = {4594,6,175,190,230,{6362},{1}},
	[7836] = {6370,4,80,80,100,{6358,3371},{2,1}},
	[7837] = {6371,4,130,150,170,{6359,3371},{2,1}},
	[7841] = {6372,4,100,130,170,{2452,6370,3371},{1,1,1}},
	[7845] = {6373,4,140,165,205,{6371,3356,3372},{2,1,1}},
	[7857] = {nil,10,120,145,185,{10940,10998},{4,1}},
	[7859] = {nil,10,120,145,185,{10998},{2}},
	[7861] = {nil,10,125,150,190,{6371,10998},{1,1}},
	[7863] = {nil,10,125,150,190,{10940},{8}},
	[7867] = {nil,10,125,150,190,{10940,10998},{6,2}},
	[7892] = {6384,8,120,145,180,{2997,6260,4340,2321},{4,2,1,1}},
	[7893] = {6385,8,120,145,180,{2997,2605,4340,2321},{4,2,1,1}},
	[7928] = {6450,1,150,150,210,{4306},{1}},
	[7929] = {6451,1,180,180,240,{4306},{2}},
	[7934] = {6452,1,80,80,150,{1475},{1},3},
	[7935] = {6453,1,130,130,200,{1288},{1},3},
	[7953] = {6466,3,90,120,150,{6470,4231,2321},{8,1,1}},
	[7954] = {6467,3,105,130,155,{6471,6470,2321},{2,6,2}},
	[7955] = {6468,3,115,140,165,{6471,6470,2321},{10,10,2}},
	[8238] = {6657,6,85,125,165,{6522,2678},{1,1}},
	[8240] = {6662,4,90,120,160,{6522,2449,3371},{1,1,1}},
	[8243] = {4852,9,185,185,225,{4611,4377,4306},{1,1,1}},
	[8322] = {6709,3,90,115,145,{2318,4231,2320,5498},{6,1,4,1}},
	[8334] = {6712,9,100,115,130,{2841,4359,2880},{1,2,1}},
	[8339] = {6714,9,100,115,130,{4364,2592},{4,1}},
	[8366] = {6730,2,70,110,150,{2840,774,3470},{12,2,2}},
	[8367] = {6731,2,100,140,180,{2840,818,3470},{16,2,3}},
	[8368] = {6733,2,140,170,200,{2841,1210,3478},{8,3,4}},
	[8465] = {6786,8,40,65,100,{2996,2320,6260,2324},{2,1,1,1}},
	[8467] = {6787,8,110,135,170,{2997,2324,2321},{3,4,1}},
	[8483] = {6795,8,160,170,180,{4305,2324,4291},{3,2,1}},
	[8489] = {6796,8,175,185,195,{4305,2604,4291},{3,2,1}},
	[8604] = {6888,6,1,45,85,{6889,2678},{1,1}},
	[8607] = {6890,6,40,80,120,{3173},{1}},
	[8681] = {6947,13,1,125,175,{2928,3371},{1,1}},
	[8687] = {6949,13,1,165,215,{2928,3372},{3,1}},
	[8691] = {6950,13,1,205,255,{8924,3372},{1,1}},
	[8694] = {6951,13,1,215,265,{2928,2930,3372},{4,4,1}},
	[8758] = {7046,8,140,160,190,{4305,6260,2321},{4,2,3}},
	[8760] = {7048,8,145,155,165,{4305,6260,2321},{2,2,1}},
	[8762] = {7050,8,160,170,180,{4305,2321},{3,2}},
	[8764] = {7051,8,170,190,220,{4305,7067,2321},{3,1,2}},
	[8766] = {7052,8,175,195,225,{4305,7070,6260,2321,7071},{4,1,2,2,1}},
	[8768] = {7071,2,150,150,155,{3575},{1},2},
	[8770] = {7054,8,190,210,240,{4339,7067,7070,7068,7069,4291},{2,2,2,2,2,2}},
	[8772] = {7055,8,175,195,225,{4305,7071,2604,4291},{4,1,2,1}},
	[8774] = {7057,8,180,200,230,{4305,4291},{5,2}},
	[8776] = {7026,8,15,50,85,{2996,2320},{1,1}},
	[8778] = {7027,8,140,160,190,{4305,2319,6048,2321},{3,2,1,2}},
	[8780] = {7047,8,145,165,195,{4305,4234,6048,2321},{3,2,2,2}},
	[8782] = {7049,8,150,170,200,{4305,4234,929,2321},{3,2,4,1}},
	[8784] = {7065,8,165,185,215,{4305,2605,4291},{5,2,1}},
	[8786] = {7053,8,175,195,225,{4305,6260,2321},{3,2,2}},
	[8789] = {7056,8,180,200,230,{4305,2604,6371,4291},{5,2,2,1}},
	[8791] = {7058,8,185,205,225,{4305,2604,2321},{4,2,2}},
	[8793] = {7059,8,190,210,240,{4305,6371,2604,4291},{5,2,2,2}},
	[8795] = {7060,8,190,210,240,{4305,7072,6260,4291},{6,2,2,2}},
	[8797] = {7061,8,195,215,245,{4305,7067,4234,7071,4291},{5,4,4,1,2}},
	[8799] = {7062,8,195,215,235,{4305,2604,4291},{4,2,2}},
	[8802] = {7063,8,205,220,250,{4305,7068,3827,2604,4291},{8,4,2,4,1}},
	[8804] = {7064,8,210,225,255,{4305,7068,6371,4304,2604,4291},{6,2,2,2,4,2}},
	[8880] = {7166,2,30,70,110,{2840,2880,3470,2318},{6,1,1,1}},
	[8895] = {7189,9,130,245,265,{10026,10559,4234,9061,10560},{1,2,4,2,1}},
	[9058] = {7276,3,1,40,70,{2318,2320},{2,1}},
	[9059] = {7277,3,1,40,70,{2318,2320},{2,3}},
	[9060] = {7278,3,30,60,90,{2318,2320},{4,2}},
	[9062] = {7279,3,30,60,90,{2318,2320},{3,4}},
	[9064] = {7280,3,35,65,95,{2318,2320},{5,5}},
	[9065] = {7281,3,70,100,130,{2318,2320},{6,4}},
	[9068] = {7282,3,95,125,155,{2318,4231,2321},{10,1,1}},
	[9070] = {7283,3,100,125,150,{7286,2319,2321},{12,4,1}},
	[9072] = {7284,3,120,145,170,{7287,2319,2321},{6,4,1}},
	[9074] = {7285,3,120,145,170,{2457,2319,2321},{1,6,1}},
	[9145] = {7348,3,125,150,175,{2319,5116,2321},{8,4,2}},
	[9146] = {7349,3,135,160,185,{2319,3356,2321},{8,4,2}},
	[9147] = {7352,3,135,160,185,{2319,7067,2321},{6,1,2}},
	[9148] = {7358,3,140,165,190,{2319,5373,2321},{10,2,2}},
	[9149] = {7359,3,145,170,195,{2319,7067,2997,2321},{12,2,2,2}},
	[9193] = {7371,3,150,170,190,{4234,2321},{8,2}},
	[9194] = {7372,3,150,170,190,{4234,2321},{8,2}},
	[9195] = {7373,3,165,185,205,{4234,2325,2321},{10,1,2}},
	[9196] = {7374,3,175,195,215,{4234,3824,2321},{10,1,2}},
	[9197] = {7375,3,175,195,215,{7392,4234,2321},{4,10,2}},
	[9198] = {7377,3,180,200,220,{4234,7067,7070,2321},{6,2,2,2}},
	[9201] = {7378,3,185,205,225,{4234,2325,4291},{16,1,2}},
	[9202] = {7386,3,190,210,230,{7392,4234,4291},{6,8,2}},
	[9206] = {7387,3,195,215,235,{4234,4305,2325,7071},{10,2,2,1}},
	[9207] = {7390,3,200,220,240,{4234,7428,3824,4291},{8,2,1,2}},
	[9208] = {7391,3,200,220,240,{4234,2459,4337,4291},{10,2,2,1}},
	[9269] = {7506,9,125,150,175,{2841,4375,814,818,774},{6,1,2,1,1}},
	[9271] = {6533,9,150,150,170,{2841,6530,4364},{2,1,1},3},
	[9273] = {7148,9,165,160,200,{3575,4375,814,4306,1210,7191},{6,2,2,2,2,1}},
	[9513] = {7676,6,60,100,140,{2452,159},{1,1}},
	[9811] = {7913,2,160,185,210,{3575,5635,1210,3486},{8,4,2,2}},
	[9813] = {7914,2,160,185,210,{3575,3486},{20,4}},
	[9814] = {7915,2,175,200,225,{3575,5637,5635},{10,2,2}},
	[9818] = {7916,2,180,205,230,{3575,5637,818,3486},{12,4,4,2}},
	[9820] = {7917,2,185,210,235,{3575,3486,5637},{14,3,2}},
	[9916] = {7963,2,200,225,250,{3859,3486},{16,3}},
	[9918] = {7964,2,200,200,210,{7912},{1}},
	[9920] = {7966,2,200,200,210,{7912},{4}},
	[9921] = {7965,2,200,200,210,{7912,4306},{1,1}},
	[9926] = {7918,2,205,225,245,{3860,4234},{8,6}},
	[9928] = {7919,2,205,225,245,{3860,4338},{6,4}},
	[9931] = {7920,2,210,230,250,{3860},{12}},
	[9933] = {7921,2,210,230,250,{3860,1705},{10,2}},
	[9935] = {7922,2,215,235,255,{3859,7966},{14,1}},
	[9937] = {7924,2,215,235,255,{3860,3864},{8,2}},
	[9939] = {7967,2,215,235,255,{3860,6037,7966},{4,2,4}},
	[9942] = {7925,2,220,240,260,{3860,4234,4338},{8,6,4}},
	[9945] = {7926,2,220,240,260,{3860,6037,7966,7909},{12,1,1,1}},
	[9950] = {7927,2,220,240,260,{3860,4338,6037,7966},{10,6,1,1}},
	[9952] = {7928,2,225,245,265,{3860,6037,4304},{12,1,6}},
	[9954] = {7938,2,225,245,265,{3860,6037,7909,3864,5966,7966},{10,8,3,3,1,2}},
	[9957] = {7929,2,230,250,270,{3860,7067},{12,1}},
	[9959] = {7930,2,230,250,270,{3860},{16}},
	[9961] = {7931,2,230,250,270,{3860,4338},{10,6}},
	[9964] = {7969,2,235,255,275,{3860,7966},{4,3}},
	[9966] = {7932,2,235,255,275,{3860,4304,3864},{14,4,4}},
	[9968] = {7933,2,235,255,275,{3860,4304},{14,4}},
	[9970] = {7934,2,245,255,275,{3860,7909},{14,1}},
	[9972] = {7935,2,240,260,280,{3860,6037,7077,7966},{16,6,1,1}},
	[9974] = {7939,2,245,265,285,{3860,6037,7910,7971,7966},{12,24,4,4,2}},
	[9979] = {7936,2,245,265,285,{3860,6037,4304,7966,7909},{14,2,4,1,1}},
	[9980] = {7937,2,245,265,285,{3860,6037,7971,7966},{16,2,1,1}},
	[9983] = {7955,2,30,70,110,{2840,2880,3470,2318},{10,2,1,1}},
	[9985] = {7956,2,125,155,185,{2841,3466,2319},{8,1,1}},
	[9986] = {7957,2,130,160,190,{2841,3466,2319},{12,2,2}},
	[9987] = {7958,2,135,165,195,{2841,3466,2319},{14,1,2}},
	[9993] = {7941,2,210,235,260,{3860,3864,7966,4234},{12,2,1,4}},
	[9995] = {7942,2,220,245,270,{3860,7909,7966,4304},{16,2,1,4}},
	[9997] = {7943,2,225,250,275,{3860,6037,7966,4304},{14,4,1,2}},
	[10001] = {7945,2,230,255,280,{3860,7971,1210,7966,4304},{16,1,4,1,2}},
	[10003] = {7954,2,235,260,285,{3860,7075,6037,3864,1529,7966,4304},{24,4,6,5,5,4,4}},
	[10005] = {7944,2,240,265,290,{3860,7909,1705,1206,7966,4338},{14,1,2,2,1,2}},
	[10007] = {7961,2,245,270,295,{3860,7081,6037,3823,7909,7966,4304},{28,6,8,2,6,4,2}},
	[10009] = {7946,2,245,270,295,{3860,7075,7966,4304},{18,2,1,4}},
	[10011] = {7959,2,250,275,300,{3860,7972,6037,7966,4304},{28,10,10,6,6}},
	[10013] = {7947,2,255,280,305,{3860,6037,7910,7966,4304},{12,6,2,1,2}},
	[10015] = {7960,2,260,285,310,{3860,6037,7910,7081,7966,4304},{30,16,6,4,8,6}},
	[10097] = {3860,7,175,175,175,{3858},{1}},
	[10098] = {6037,7,230,230,230,{7911},{1}},
	[10482] = {8172,3,200,200,200,{8169,8150},{1,1}},
	[10487] = {8173,3,200,220,240,{4304,4291},{5,1}},
	[10490] = {8174,3,200,220,240,{4234,4236,4291},{12,2,2}},
	[10499] = {8175,3,205,225,245,{4304,4291},{7,2}},
	[10507] = {8176,3,205,225,245,{4304,4291},{5,2}},
	[10509] = {8187,3,205,225,245,{4304,8167,8343},{6,8,1}},
	[10511] = {8189,3,210,230,250,{4304,8167,8343},{6,12,1}},
	[10516] = {8192,3,210,230,250,{4304,4338,4291},{8,6,3}},
	[10518] = {8198,3,210,230,250,{4304,8167,8343},{8,12,1}},
	[10520] = {8200,3,215,235,255,{4304,8151,8343},{10,4,1}},
	[10525] = {8203,3,220,240,260,{4304,8154,4291},{12,12,4}},
	[10529] = {8210,3,220,240,260,{4304,8153,8172},{10,1,1}},
	[10531] = {8201,3,220,240,260,{4304,8151,8343},{8,6,1}},
	[10533] = {8205,3,220,240,260,{4304,8154,4291},{10,4,2}},
	[10542] = {8204,3,225,245,265,{4304,8154,4291},{6,8,2}},
	[10544] = {8211,3,225,245,265,{4304,8153,8172},{12,2,1}},
	[10546] = {8214,3,225,245,265,{4304,8153,8172},{10,2,1}},
	[10548] = {8193,3,230,250,270,{4304,4291},{14,4}},
	[10550] = {8195,3,230,250,270,{4304,4291},{12,4}},
	[10552] = {8191,3,230,250,270,{4304,8167,8343},{14,24,1}},
	[10554] = {8209,3,235,255,275,{4304,8154,4291},{12,12,6}},
	[10556] = {8185,3,235,255,275,{4304,8167,8343},{14,28,1}},
	[10558] = {8197,3,235,255,275,{4304,8343},{16,2}},
	[10560] = {8202,3,240,260,280,{4304,8152,8343},{10,6,2}},
	[10562] = {8216,3,240,260,280,{4304,8152,8343},{14,4,2}},
	[10564] = {8207,3,240,260,280,{4304,8154,8343},{12,16,2}},
	[10566] = {8213,3,245,265,285,{4304,8153,8172},{14,4,2}},
	[10568] = {8206,3,245,265,285,{4304,8154,8343},{14,8,2}},
	[10570] = {8208,3,250,270,290,{4304,8154,8343},{10,20,2}},
	[10572] = {8212,3,250,270,290,{4304,8153,8172},{16,6,2}},
	[10574] = {8215,3,250,270,290,{4304,8153,8172},{16,6,2}},
	[10619] = {8347,3,225,245,265,{4304,8165,8343,8172},{24,12,4,2}},
	[10621] = {8345,3,225,245,265,{4304,8368,8146,8343,8172},{18,2,8,4,2}},
	[10630] = {8346,3,230,250,270,{4304,7079,7075,8172,8343},{20,8,2,1,4}},
	[10632] = {8348,3,250,270,290,{4304,7077,7075,8172,8343},{40,8,4,2,4}},
	[10647] = {8349,3,250,270,290,{4304,8168,7971,8172,8343},{40,40,2,4,4}},
	[10650] = {8367,3,255,275,295,{4304,8165,8343,8172},{40,30,4,4}},
	[10840] = {8544,1,210,210,270,{4338},{1}},
	[10841] = {8545,1,240,240,300,{4338},{2}},
	[10844] = {8546,1,250,1,1,{8150},{4}},
	[11341] = {8926,13,1,245,295,{8924,8925},{2,1}},
	[11342] = {8927,13,1,285,335,{8924,8925},{3,1}},
	[11343] = {8928,13,1,325,375,{8924,8925},{4,1}},
	[11357] = {8984,13,1,255,305,{5173,8925},{3,1}},
	[11358] = {8985,13,1,295,345,{5173,8925},{5,1}},
	[11400] = {9186,13,1,285,335,{8924,8923,8925},{2,2,1}},
	[11447] = {8827,4,1,190,230,{6370,3357,3372},{1,1,1}},
	[11448] = {6149,4,205,220,260,{3358,3821,3372},{1,1,1}},
	[11449] = {8949,4,185,205,245,{3820,3821,3372},{1,1,1}},
	[11450] = {8951,4,195,215,255,{3355,3821,3372},{1,1,1}},
	[11451] = {8956,4,205,220,260,{4625,3821,8925},{1,1,1}},
	[11452] = {9030,4,215,225,265,{7067,3821,8925},{1,1,1}},
	[11453] = {9036,4,210,225,265,{3358,8831,8925},{1,1,1}},
	[11454] = {9060,2,200,225,250,{3860,3577,6037},{5,1,1}},
	[11456] = {9061,4,210,225,265,{4625,9260,3372},{1,1,1}},
	[11457] = {3928,4,215,230,270,{8838,3358,8925},{1,1,1}},
	[11458] = {9144,4,225,240,280,{8153,8831,8925},{1,1,1}},
	[11459] = {9149,4,225,240,280,{3575,9262,8831,4625},{4,1,4,4}},
	[11460] = {9154,4,230,245,285,{8836,8925},{1,1}},
	[11461] = {9155,4,235,250,290,{8839,3821,8925},{1,1,1}},
	[11464] = {9172,4,235,250,290,{8845,8838,8925},{1,1,1}},
	[11465] = {9179,4,235,250,290,{8839,3358,8925},{1,1,1}},
	[11466] = {9088,4,240,255,295,{8836,8839,8925},{1,1,1}},
	[11467] = {9187,4,240,255,295,{8838,3821,8925},{1,1,1}},
	[11468] = {9197,4,240,255,295,{8831,8925},{3,1}},
	[11472] = {9206,4,245,260,300,{8838,8846,8925},{1,1,1}},
	[11473] = {9210,4,245,260,300,{8845,4342,8925},{2,1,1}},
	[11476] = {9264,4,250,265,305,{8845,8925},{3,1}},
	[11477] = {9224,4,250,265,305,{8846,8845,8925},{1,1,1}},
	[11478] = {9233,4,250,265,305,{8846,8925},{2,1}},
	[11479] = {3577,4,225,240,280,{3575},{1}},
	[11480] = {6037,4,225,240,280,{3860},{1}},
	[11643] = {9366,2,205,225,245,{3859,3577,3486,3864},{10,4,4,1}},
	[11923] = {9718,2,190,1,1,{9719,3859,3466,7068,3486},{1,4,4,2,2}},
	[12044] = {10045,8,1,35,60,{2996,2320},{1,1}},
	[12045] = {10046,8,20,50,85,{2996,2318,2320},{2,1,1}},
	[12046] = {10047,8,75,100,135,{2996,2321},{4,1}},
	[12047] = {10048,8,120,145,180,{2997,2604,2321},{5,3,1}},
	[12048] = {9998,8,205,220,250,{4339,4291},{2,3}},
	[12049] = {9999,8,205,220,250,{4339,4291},{2,3}},
	[12050] = {10001,8,210,225,255,{4339,8343},{3,1}},
	[12052] = {10002,8,210,225,255,{4339,10285,8343},{3,2,1}},
	[12053] = {10003,8,215,230,260,{4339,8343},{2,2}},
	[12055] = {10004,8,215,230,260,{4339,10285,8343},{3,2,1}},
	[12056] = {10007,8,215,230,260,{4339,2604,8343},{3,2,1}},
	[12059] = {10008,8,215,220,230,{4339,2324,8343},{1,1,1}},
	[12060] = {10009,8,215,230,260,{4339,2604,8343},{3,2,1}},
	[12061] = {10056,8,215,220,230,{4339,6261,8343},{1,1,1}},
	[12062] = {10010,8,220,235,265,{4339,7079,8343},{4,2,2}},
	[12063] = {10011,8,220,235,265,{4339,7079,8343},{3,2,2}},
	[12064] = {10052,8,220,225,235,{4339,6261,8343},{2,2,1}},
	[12065] = {10050,8,225,240,270,{4339,4291},{4,2}},
	[12066] = {10018,8,225,240,270,{4339,2604,8343},{3,2,2}},
	[12067] = {10019,8,225,240,270,{4339,8153,10286,8343},{4,4,2,2}},
	[12068] = {10020,8,225,240,270,{4339,7079,8343},{5,3,2}},
	[12069] = {10042,8,225,240,270,{4339,7077,8343},{5,2,2}},
	[12070] = {10021,8,225,240,270,{4339,8153,10286,8343},{6,6,2,2}},
	[12071] = {10023,8,225,240,270,{4339,10285,8343},{5,5,2}},
	[12072] = {10024,8,230,245,275,{4339,8343},{3,2}},
	[12073] = {10026,8,230,245,275,{4339,8343,4304},{3,2,2}},
	[12074] = {10027,8,230,245,275,{4339,8343},{3,2}},
	[12075] = {10054,8,230,235,245,{4339,4342,8343},{2,2,2}},
	[12076] = {10028,8,235,250,280,{4339,10285,8343},{5,4,2}},
	[12077] = {10053,8,235,240,250,{4339,2325,8343,2324},{3,1,1,1}},
	[12078] = {10029,8,235,250,280,{4339,2604,8343},{4,2,3}},
	[12079] = {10051,8,235,250,280,{4339,2604,8343},{4,2,2}},
	[12080] = {10055,8,235,240,250,{4339,10290,8343},{3,1,1}},
	[12081] = {10030,8,240,255,285,{4339,4589,8343},{3,6,2}},
	[12082] = {10031,8,240,255,285,{4339,10285,8343,4304},{6,6,3,2}},
	[12083] = {10032,8,240,255,285,{4339,7079,8343},{4,4,2}},
	[12084] = {10033,8,240,255,285,{4339,2604,8343},{4,2,2}},
	[12085] = {10034,8,240,245,255,{4339,8343},{4,2}},
	[12086] = {10025,8,245,260,290,{4339,10285,8343},{2,8,2}},
	[12087] = {10038,8,245,260,290,{4339,7079,8343},{5,6,3}},
	[12088] = {10044,8,245,260,290,{4339,7077,8343,4304},{5,1,3,2}},
	[12089] = {10035,8,245,250,260,{4339,8343},{4,3}},
	[12090] = {10039,8,250,265,295,{4339,7079,8343,4304},{6,6,3,2}},
	[12091] = {10040,8,250,255,265,{4339,8343,2324},{5,3,1}},
	[12092] = {10041,8,250,265,295,{4339,8153,10286,8343,6037,1529},{8,4,2,3,1,1}},
	[12093] = {10036,8,250,265,295,{4339,8343},{5,3}},
	[12259] = {10423,2,155,180,205,{2841,2842,3478},{12,4,2}},
	[12260] = {10421,2,1,15,55,{2840},{4}},
	[12584] = {10558,9,150,150,190,{3577},{1},3},
	[12585] = {10505,9,175,175,195,{7912},{2}},
	[12586] = {10507,9,175,175,195,{10505,4306},{1,1},2},
	[12587] = {10499,9,175,195,215,{4234,3864},{6,2}},
	[12589] = {10559,9,195,195,235,{3860},{3}},
	[12590] = {10498,9,175,175,215,{3859},{4}},
	[12591] = {10560,9,200,200,240,{3860,4338,10505},{1,1,1}},
	[12594] = {10500,9,205,225,245,{4385,3864,7068,4234},{1,2,2,4}},
	[12595] = {10508,9,205,225,245,{10559,10560,4400,3860,7068},{1,1,1,4,2}},
	[12596] = {10512,9,210,210,250,{3860,10505},{1,1},200},
	[12597] = {10546,9,210,230,250,{10559,7909,4304},{1,2,2}},
	[12599] = {10561,9,215,215,255,{3860},{3}},
	[12603] = {10514,9,215,215,255,{10561,10560,10505},{1,1,1},3},
	[12607] = {10501,9,220,240,260,{4304,7909,10592},{4,2,1}},
	[12609] = {10592,4,200,220,260,{3821,3818,3372},{1,1,1}},
	[12614] = {10510,9,220,240,260,{10559,10560,4400,3860,3864},{2,1,1,6,2}},
	[12615] = {10502,9,225,245,265,{4304,7910},{4,2}},
	[12616] = {10518,9,225,245,265,{4339,10285,10560,10505},{4,2,1,4}},
	[12617] = {10506,9,230,250,270,{3860,10561,6037,818,774},{8,1,1,4,4}},
	[12618] = {10503,9,230,250,270,{4304,7910},{6,2}},
	[12619] = {10562,9,235,235,275,{10561,10560,10505},{2,1,2},4},
	[12620] = {10548,9,240,260,280,{10559,7910,6037},{1,1,2}},
	[12621] = {10513,9,245,245,285,{3860,10505},{2,2},200},
	[12622] = {10504,9,245,265,285,{4304,1529,7909,10286,8153},{8,3,3,2,2}},
	[12624] = {10576,9,250,270,290,{3860,7077,6037,9060,9061,7910},{14,4,4,2,2,2}},
	[12715] = {10644,9,205,205,205,{10648,10647},{1,1}},
	[12716] = {10577,9,225,225,245,{10559,3860,10505,10558,7068},{2,4,5,1,1}},
	[12717] = {10542,9,205,225,245,{3860,3864,7067},{8,1,4}},
	[12718] = {10543,9,205,225,245,{3860,3864,7068},{8,1,4}},
	[12719] = {10579,9,1,210,250,{3030,10505,3860},{100,2,2},100},
	[12720] = {10580,9,1,235,255,{10561,10505,10558,3860},{1,2,1,2}},
	[12722] = {10585,9,1,240,260,{10561,3860,4389,10560},{1,2,1,1}},
	[12754] = {10586,9,235,235,275,{10561,9061,10507,10560},{1,1,6,1},2},
	[12755] = {10587,9,230,230,270,{10561,10505,6037,10560,4407},{2,4,6,1,2}},
	[12758] = {10588,9,245,265,285,{10543,9061,3860,10560},{1,4,4,1}},
	[12759] = {10645,9,240,260,280,{10559,10560,12808,7972,9060},{2,1,1,4,1}},
	[12760] = {10646,9,205,205,245,{4338,10505,10560},{1,3,1}},
	[12895] = {10713,9,205,205,205,{10648,10647},{1,1}},
	[12897] = {10545,9,210,230,250,{10500,10559,10558,8151,4234},{1,1,2,2,2}},
	[12899] = {10716,9,205,225,245,{10559,10560,3860,8151,1529},{1,1,4,4,2}},
	[12900] = {10719,9,1,205,245,{10559,10560,3860},{1,1,4}},
	[12902] = {10720,9,210,230,250,{10559,10285,4337,10505,3860},{1,2,4,2,4}},
	[12903] = {10721,9,215,235,255,{7387,3860,6037,10560,7909},{1,4,2,1,2}},
	[12904] = {10723,9,1,240,260,{10561,3860,4389,10560},{1,2,1,1}},
	[12905] = {10724,9,225,245,265,{10026,10559,4234,10505,4389},{1,2,4,8,4}},
	[12906] = {10725,9,230,250,270,{10561,6037,3860,9060,10558,1529},{1,6,6,2,1,2}},
	[12907] = {10726,9,235,255,275,{3860,6037,10558,7910,4338},{10,4,1,2,4}},
	[12908] = {10727,9,240,260,280,{10559,9061,3860,6037,10560},{2,4,6,6,1}},
	[13028] = {10841,6,175,215,255,{3821,159},{1,1},4},
	[13220] = {10918,13,1,185,235,{2930,5173,3372},{1,1,1}},
	[13228] = {10920,13,1,225,275,{2930,5173,3372},{1,2,1}},
	[13229] = {10921,13,1,265,315,{8923,5173,8925},{1,2,1}},
	[13230] = {10922,13,1,305,355,{8923,5173,8925},{2,2,1}},
	[13240] = {10577,9,205,0,0,{10577,3860,10505},{1,1,3}},
	[13378] = {nil,10,105,130,170,{10998,10940},{1,2}},
	[13380] = {nil,10,110,135,175,{10998,10940},{1,6}},
	[13419] = {nil,10,110,135,175,{10998},{1}},
	[13421] = {nil,10,115,140,180,{10940,10978},{6,1}},
	[13464] = {nil,10,115,140,180,{10998,10940,10978},{1,1,1}},
	[13485] = {nil,10,130,155,195,{10998,10940},{2,4}},
	[13501] = {nil,10,130,155,195,{11083},{2}},
	[13503] = {nil,10,140,165,205,{11083,11084},{2,1}},
	[13522] = {nil,10,135,160,200,{11082,6048},{1,1}},
	[13529] = {nil,10,145,170,210,{11083,11084},{3,1}},
	[13536] = {nil,10,140,165,205,{11083},{2}},
	[13538] = {nil,10,140,165,205,{10940,11082,11084},{2,1,1}},
	[13607] = {nil,10,145,170,210,{11082,10998},{1,2}},
	[13612] = {nil,10,145,170,210,{11083,2772},{1,3}},
	[13617] = {nil,10,145,170,210,{11083,3356},{1,3}},
	[13620] = {nil,10,145,170,210,{11083,6370},{1,3}},
	[13622] = {nil,10,150,175,215,{11082},{2}},
	[13626] = {nil,10,150,175,215,{11082,11083,11084},{1,1,1}},
	[13628] = {11130,10,150,175,215,{11128,5500,11082,11083},{1,1,2,2}},
	[13631] = {nil,10,155,175,215,{11134,11083},{1,1}},
	[13635] = {nil,10,155,175,215,{11138,11083},{1,3}},
	[13637] = {nil,10,160,180,220,{11083,11134},{1,1}},
	[13640] = {nil,10,160,180,220,{11083},{3}},
	[13642] = {nil,10,165,185,225,{11134},{1}},
	[13644] = {nil,10,170,190,230,{11083},{4}},
	[13646] = {nil,10,170,190,230,{11134,11083},{1,2}},
	[13648] = {nil,10,170,190,230,{11083},{6}},
	[13653] = {nil,10,175,195,235,{11134,5637,11138},{1,2,1}},
	[13655] = {nil,10,175,195,235,{11134,7067,11138},{1,1,1}},
	[13657] = {nil,10,175,195,235,{11134,7068},{1,1}},
	[13659] = {nil,10,180,200,240,{11135,11137},{1,1}},
	[13661] = {nil,10,180,200,240,{11137},{1}},
	[13663] = {nil,10,185,205,245,{11135},{1}},
	[13687] = {nil,10,190,210,250,{11135,11134},{1,2}},
	[13689] = {nil,10,195,215,255,{11135,11137,11139},{2,2,1}},
	[13693] = {nil,10,195,215,255,{11135,11139},{2,1}},
	[13695] = {nil,10,200,220,260,{11137,11139},{4,1}},
	[13698] = {nil,10,200,220,260,{11137,7392},{1,3}},
	[13700] = {nil,10,200,220,260,{11135,11137,11139},{2,2,1}},
	[13702] = {11145,10,200,220,260,{11144,7971,11135,11137},{1,1,2,2}},
	[13746] = {nil,10,205,225,265,{11137},{3}},
	[13794] = {nil,10,205,225,265,{11174},{1}},
	[13815] = {nil,10,210,230,270,{11174,11137},{1,1}},
	[13817] = {nil,10,210,230,270,{11137},{5}},
	[13822] = {nil,10,210,230,270,{11174},{2}},
	[13836] = {nil,10,215,235,275,{11137},{5}},
	[13841] = {nil,10,215,235,275,{11137,6037},{3,3}},
	[13846] = {nil,10,220,240,280,{11174,11137},{3,1}},
	[13858] = {nil,10,220,240,280,{11137},{6}},
	[13868] = {nil,10,225,245,285,{11137,8838},{3,3}},
	[13882] = {nil,10,225,245,285,{11174},{2}},
	[13887] = {nil,10,225,245,285,{11174,11137},{2,3}},
	[13890] = {nil,10,225,245,285,{11177,7909,11174},{1,1,1}},
	[13898] = {nil,10,265,285,325,{11177,7078},{4,1}},
	[13905] = {nil,10,230,250,290,{11175,11176},{1,2}},
	[13915] = {nil,10,230,250,290,{11177,11176,9224},{1,2,1}},
	[13917] = {nil,10,230,250,290,{11175,11174},{1,2}},
	[13931] = {nil,10,235,255,295,{11175,11176},{1,2}},
	[13933] = {nil,10,235,255,295,{11178,3829},{1,1}},
	[13935] = {nil,10,235,255,295,{11175},{2}},
	[13937] = {nil,10,240,260,300,{11178,11176},{2,2}},
	[13939] = {nil,10,240,260,300,{11176,11175},{2,1}},
	[13941] = {nil,10,245,265,305,{11178,11176,11175},{1,3,2}},
	[13943] = {nil,10,245,265,305,{11178,11175},{2,2}},
	[13945] = {nil,10,245,265,305,{11176},{5}},
	[13947] = {nil,10,250,270,310,{11178,11176},{2,3}},
	[13948] = {nil,10,250,270,310,{11178,8153},{2,2}},
	[14293] = {11287,10,10,75,115,{4470,10938},{1,1}},
	[14379] = {11128,2,150,155,160,{3577,3478},{1,2}},
	[14380] = {11144,2,200,205,210,{6037,3486},{1,1}},
	[14807] = {11288,10,70,110,150,{4470,10939},{1,1}},
	[14809] = {11289,10,155,175,215,{11291,11134,11083},{1,1,1}},
	[14810] = {11290,10,175,195,235,{11291,11135,11137},{1,1,1}},
	[14891] = {11371,7,300,230,230,{11370},{8}},
	[14930] = {8217,3,225,245,265,{4304,8172,8949,4291},{12,1,1,4}},
	[14932] = {8218,3,225,245,265,{4304,8172,8951,4291},{10,1,1,6}},
	[15255] = {11590,9,200,200,240,{3860,4338,10505},{1,1,1}},
	[15292] = {11608,2,265,285,305,{11371,7077},{18,4}},
	[15293] = {11606,2,270,290,310,{11371,7077},{10,2}},
	[15294] = {11607,2,275,295,315,{11371,7077},{26,4}},
	[15295] = {11605,2,280,300,320,{11371,7077},{6,1}},
	[15296] = {11604,2,285,305,325,{11371,7077},{20,8}},
	[15596] = {11811,10,265,285,325,{11382,7078,14343},{1,1,3}},
	[15628] = {11825,9,205,205,205,{4394,7077,7191,3860},{1,1,1,6}},
	[15633] = {11826,9,205,205,205,{7075,4389,7191,3860,6037},{1,2,1,2,1}},
	[15833] = {12190,4,230,245,285,{8831,8925},{3,1}},
	[15853] = {12209,6,125,165,205,{1015,2678},{1,1}},
	[15855] = {12210,6,175,215,255,{12184,2692},{1,1}},
	[15856] = {13851,6,175,215,255,{12203,2692},{1,1}},
	[15861] = {12212,6,175,215,255,{12202,159,4536},{1,1,2},2},
	[15863] = {12213,6,175,215,255,{12037,2692},{1,1}},
	[15865] = {12214,6,175,215,255,{12037,2596},{1,1}},
	[15906] = {12217,6,200,240,280,{12037,4402,2692},{1,1,1}},
	[15910] = {12215,6,200,240,280,{12204,3713,159},{2,1,1},2},
	[15915] = {12216,6,225,265,305,{12206,2692},{1,2}},
	[15933] = {12218,6,225,265,305,{12207,3713},{1,2}},
	[15935] = {12224,6,1,45,85,{12223,2678},{1,1}},
	[15972] = {12259,2,180,205,230,{3859,3466,1206,7067,4234},{10,2,1,1,1}},
	[15973] = {12260,2,190,215,240,{3859,3577,7068,4234},{10,4,2,2}},
	[16153] = {12359,7,250,250,250,{10620},{1}},
	[16639] = {12644,2,250,255,260,{12365},{4}},
	[16640] = {12643,2,250,255,260,{12365,14047},{1,1}},
	[16641] = {12404,2,250,255,260,{12365},{1}},
	[16642] = {12405,2,250,270,290,{12359,12361,11188},{16,1,4}},
	[16643] = {12406,2,250,270,290,{12359,11186},{12,4}},
	[16644] = {12408,2,255,275,295,{12359,11184},{12,4}},
	[16645] = {12416,2,260,280,300,{12359,7077},{10,2}},
	[16646] = {12428,2,265,285,305,{12359,8170,3864},{24,6,2}},
	[16647] = {12424,2,265,285,305,{12359,8170,7909},{22,6,1}},
	[16648] = {12415,2,270,290,310,{12359,7077,7910},{18,2,1}},
	[16649] = {12425,2,270,290,310,{12359,7910},{20,1}},
	[16650] = {12624,2,270,290,310,{12359,12655,12803,8153,12364},{40,2,4,4,1}},
	[16651] = {12645,2,275,295,315,{12359,12644,7076},{4,4,2}},
	[16652] = {12409,2,280,300,320,{12359,8170,11185},{20,8,4}},
	[16653] = {12410,2,280,300,320,{12359,7910,11188},{24,1,4}},
	[16654] = {12418,2,285,305,325,{12359,7077},{18,4}},
	[16655] = {12631,2,290,310,330,{12359,12655,7078,7910},{20,6,2,4}},
	[16656] = {12419,2,290,310,330,{12359,7077},{14,4}},
	[16657] = {12426,2,295,315,335,{12359,7910,7909},{34,1,1}},
	[16658] = {12427,2,295,315,335,{12359,7910},{34,2}},
	[16659] = {12417,2,295,315,335,{12359,7077},{18,4}},
	[16660] = {12625,2,290,310,330,{12359,12360,12364,7080},{20,4,2,2}},
	[16661] = {12632,2,295,315,335,{12359,12655,7080,12361},{20,4,4,4}},
	[16662] = {12414,2,300,320,340,{12359,11186},{26,4}},
	[16663] = {12422,2,300,320,340,{12359,7910},{40,2}},
	[16664] = {12610,2,300,320,340,{12359,12360,3577},{20,2,6}},
	[16665] = {12611,2,300,320,340,{12359,12360,2842},{20,2,10}},
	[16667] = {12628,2,285,305,325,{12359,12662,12361,7910},{40,10,4,4}},
	[16724] = {12633,2,300,320,340,{12359,12655,6037,3577,12800},{20,4,6,6,2}},
	[16725] = {12420,2,300,320,340,{12359,7077},{20,4}},
	[16726] = {12612,2,300,320,340,{12359,12360,6037,12364},{30,2,2,1}},
	[16728] = {12636,2,300,320,340,{12359,12655,8168,12799,12364},{40,4,60,6,2}},
	[16729] = {12640,2,300,320,340,{12359,12360,8146,12361,12800},{80,12,40,10,4}},
	[16730] = {12429,2,300,320,340,{12359,7910},{44,2}},
	[16731] = {12613,2,300,320,340,{12359,12360,7910},{40,2,1}},
	[16732] = {12614,2,300,320,340,{12359,12360,7910},{40,2,1}},
	[16741] = {12639,2,300,320,340,{12360,12655,7076,12361,12799},{15,20,10,4,4}},
	[16742] = {12620,2,300,320,340,{12360,12655,7076,12799,12800},{6,16,6,2,1}},
	[16744] = {12619,2,300,320,340,{12360,12655,7080,12361,12364},{10,20,6,2,1}},
	[16745] = {12618,2,300,320,340,{12360,12655,7076,7080,12364,12800},{8,24,4,4,2,2}},
	[16746] = {12641,2,300,320,340,{12360,12655,12364,12800},{30,30,6,6}},
	[16960] = {12764,2,260,285,310,{12359,12644,8170},{16,2,4}},
	[16965] = {12769,2,270,295,320,{12359,12803,8153,12799,12644,8170},{30,6,6,6,2,8}},
	[16967] = {12772,2,270,295,320,{12359,3577,6037,12361,8170},{30,4,2,2,4}},
	[16969] = {12773,2,275,300,325,{12359,12799,12644,8170},{20,2,2,4}},
	[16970] = {12774,2,275,300,325,{12359,12655,7910,12361,12644,8170},{30,4,4,4,2,4}},
	[16971] = {12775,2,280,305,330,{12359,12644,8170},{40,6,6}},
	[16973] = {12776,2,280,305,330,{12359,12655,12364,12804,8170},{20,6,2,4,4}},
	[16978] = {12777,2,280,305,330,{12655,7078,7077,12800,12644},{10,4,4,2,2}},
	[16980] = {12779,2,285,310,335,{12359,12799,12644,8170},{30,2,2,4}},
	[16983] = {12781,2,285,310,335,{12655,12360,12804,12799,12361,12364},{6,2,4,2,2,1}},
	[16984] = {12792,2,290,315,340,{12359,7077,7910,8170},{30,4,4,4}},
	[16985] = {12782,2,290,315,340,{12359,12360,12662,12808,12361,12644,8170},{40,2,16,8,2,2,4}},
	[16986] = {12795,2,300,325,350,{12655,12360,12662,7910,12644},{10,10,8,10,2}},
	[16987] = {12802,2,300,325,350,{12655,12804,12364,12800,12644},{20,20,2,2,2}},
	[16988] = {12796,2,300,320,340,{12359,12360,12809,12810,7076},{50,15,4,6,10}},
	[16990] = {12790,2,300,320,340,{12360,12800,12811,12799,12810,12644},{15,8,1,4,8,2}},
	[16991] = {12798,2,300,320,340,{12359,12360,12808,12364,12644,12810},{40,12,10,8,2,4}},
	[16992] = {12797,2,300,320,340,{12360,12361,12800,7080,12644,12810},{18,8,8,4,2,4}},
	[16993] = {12794,2,300,320,340,{12655,12364,12799,7076,12810},{20,8,8,6,4}},
	[16994] = {12784,2,300,320,340,{12360,12810,12644},{20,6,2}},
	[16995] = {12783,2,300,320,340,{12360,12655,12810,7910,12800,12799,12644},{10,10,2,6,6,6,4}},
	[17180] = {12655,10,250,250,260,{12359,11176},{1,3}},
	[17181] = {12810,10,250,250,260,{8170,16202},{1,1}},
	[17187] = {12360,4,275,275,290,{12359,12363},{1,1}},
	[17551] = {13423,4,250,250,260,{13422,3372},{1,1}},
	[17552] = {13442,4,255,270,310,{8846,8925},{3,1}},
	[17553] = {13443,4,260,275,315,{8838,8839,8925},{2,2,1}},
	[17554] = {13445,4,265,280,320,{13423,8838,8925},{2,1,1}},
	[17555] = {13447,4,270,285,325,{13463,13466,8925},{1,2,1}},
	[17556] = {13446,4,275,290,330,{13464,13465,8925},{2,1,1}},
	[17557] = {13453,4,275,290,330,{8846,13466,8925},{2,2,1}},
	[17559] = {7078,4,275,275,290,{7082},{1}},
	[17560] = {7076,4,275,275,290,{7078},{1}},
	[17561] = {7080,4,275,275,290,{7076},{1}},
	[17562] = {7082,4,275,275,290,{7080},{1}},
	[17563] = {7080,4,275,275,290,{12808},{1}},
	[17564] = {12808,4,275,275,290,{7080},{1}},
	[17565] = {7076,4,275,275,290,{12803},{1}},
	[17566] = {12803,4,275,275,290,{7076},{1}},
	[17570] = {13455,4,280,295,335,{13423,10620,8925},{3,1,1}},
	[17571] = {13452,4,280,295,335,{13465,13466,8925},{2,2,1}},
	[17572] = {13462,4,285,300,340,{13467,13466,8925},{2,2,1}},
	[17573] = {13454,4,285,300,340,{13463,13465,8925},{3,1,1}},
	[17574] = {13457,4,290,305,345,{7068,13463,8925},{1,1,1}},
	[17575] = {13456,4,290,305,345,{7070,13463,8925},{1,1,1}},
	[17576] = {13458,4,290,305,345,{7067,13463,8925},{1,1,1}},
	[17577] = {13461,4,290,305,345,{11176,13463,8925},{1,1,1}},
	[17578] = {13459,4,290,305,345,{3824,13463,8925},{1,1,1}},
	[17579] = {13460,4,290,305,345,{7069,13463,8925},{1,1,1}},
	[17580] = {13444,4,295,310,350,{13463,13467,8925},{3,2,1}},
	[17632] = {13503,4,300,315,330,{7078,7076,7082,7080,12803,9262,13468},{8,8,8,8,8,2,4}},
	[17634] = {13506,4,300,315,330,{13423,13465,13468,8925},{30,10,1,1}},
	[17635] = {13510,4,300,315,330,{8846,13423,13468,8925},{30,10,1,1}},
	[17636] = {13511,4,300,315,330,{13463,13467,13468,8925},{30,10,1,1}},
	[17637] = {13512,4,300,315,330,{13463,13465,13468,8925},{30,10,1,1}},
	[17638] = {13513,4,300,315,330,{13467,13465,13468,8925},{30,10,1,1}},
	[18238] = {6887,6,225,265,305,{4603},{1}},
	[18239] = {13927,6,225,265,305,{13754,3713},{1,1}},
	[18240] = {13928,6,240,280,320,{13755,3713},{1,1}},
	[18241] = {13930,6,225,265,305,{13758},{1}},
	[18242] = {13929,6,240,280,320,{13756,2692},{1,2}},
	[18243] = {13931,6,250,290,330,{13759,159},{1,1}},
	[18244] = {13932,6,250,290,330,{13760},{1}},
	[18245] = {13933,6,275,315,355,{13888,159},{1,1}},
	[18246] = {13934,6,275,315,355,{13893,2692,3713},{1,1,1}},
	[18247] = {13935,6,275,315,355,{13889,3713},{1,1}},
	[18401] = {14048,8,250,255,260,{14047},{5}},
	[18402] = {13856,8,255,270,300,{14048,14341},{3,1}},
	[18403] = {13869,8,255,270,300,{14048,7079,14341},{5,2,1}},
	[18404] = {13868,8,255,270,300,{14048,7079,14341},{5,2,1}},
	[18405] = {14046,8,260,275,305,{14048,8170,14341},{5,2,1}},
	[18406] = {13858,8,260,275,305,{14048,14227,14341},{5,1,1}},
	[18407] = {13857,8,260,275,305,{14048,14227,14341},{5,1,1}},
	[18408] = {14042,8,260,275,305,{14048,7077,14341},{5,3,1}},
	[18409] = {13860,8,265,280,310,{14048,14227,14341},{4,1,1}},
	[18410] = {14143,8,265,280,310,{14048,9210,14227,14341},{3,2,1,1}},
	[18411] = {13870,8,265,280,310,{14048,7080,14341},{3,1,1}},
	[18412] = {14043,8,270,285,315,{14048,7077,14341},{4,3,1}},
	[18413] = {14142,8,270,285,315,{14048,9210,14227,14341},{4,2,1,1}},
	[18414] = {14100,8,270,285,315,{14048,3577,14341},{5,2,1}},
	[18415] = {14101,8,270,285,315,{14048,3577,14341},{4,2,1}},
	[18416] = {14141,8,275,290,320,{14048,9210,14227,14341},{6,4,1,1}},
	[18417] = {13863,8,275,290,320,{14048,8170,14341},{4,4,1}},
	[18418] = {14044,8,275,290,320,{14048,7078,14341},{5,1,1}},
	[18419] = {14107,8,275,290,320,{14048,14256,14341},{5,4,1}},
	[18420] = {14103,8,275,290,320,{14048,3577,14341},{4,2,1}},
	[18421] = {14132,8,275,290,320,{14048,11176,14341},{6,1,1}},
	[18422] = {14134,8,275,290,320,{14048,7078,7077,7068,14341},{6,4,4,4,1}},
	[18423] = {13864,8,280,295,325,{14048,14227,8170,14341},{4,2,4,1}},
	[18424] = {13871,8,280,295,325,{14048,7080,14341},{6,1,1}},
	[18434] = {14045,8,280,295,325,{14048,7078,14341},{6,1,1}},
	[18436] = {14136,8,285,300,330,{14048,14256,12808,7080,14341},{10,12,4,4,1}},
	[18437] = {14108,8,285,300,330,{14048,14256,8170,14341},{6,4,4,1}},
	[18438] = {13865,8,285,300,330,{14048,14227,14341},{6,2,1}},
	[18439] = {14104,8,290,305,335,{14048,3577,14227,14341},{6,4,1,1}},
	[18440] = {14137,8,290,305,335,{14048,14342,14341},{6,4,1}},
	[18441] = {14144,8,290,305,335,{14048,9210,14341},{6,4,1}},
	[18442] = {14111,8,290,305,335,{14048,14256,14341},{5,4,1}},
	[18444] = {13866,8,295,310,340,{14048,14227,14341},{4,2,1}},
	[18445] = {14155,8,300,315,345,{14048,14342,14341},{4,1,1}},
	[18446] = {14128,8,300,315,345,{14048,11176,14341},{8,2,1}},
	[18447] = {14138,8,300,315,345,{14048,14342,14341},{6,4,1}},
	[18448] = {14139,8,300,315,345,{14048,14342,14341},{5,5,1}},
	[18449] = {13867,8,300,315,345,{14048,14227,8170,14341},{7,2,4,1}},
	[18450] = {14130,8,300,315,345,{14048,11176,7910,14341},{6,4,1,1}},
	[18451] = {14106,8,300,315,345,{14048,14256,12662,14341},{8,8,4,2}},
	[18452] = {14140,8,300,315,345,{14048,14342,12800,12810,14341},{4,6,1,2,2}},
	[18453] = {14112,8,300,315,345,{14048,14256,12662,8170,14341},{7,6,4,4,2}},
	[18454] = {14146,8,300,315,345,{14048,14342,9210,13926,12364,12810,14341},{10,10,10,6,6,8,2}},
	[18455] = {14156,8,300,315,345,{14048,14342,14344,17012,14341},{8,12,2,2,2}},
	[18456] = {14154,8,300,315,345,{14048,14342,12811,13926,9210,14341},{12,10,4,4,10,2}},
	[18457] = {14152,8,300,315,345,{14048,7078,7082,7076,7080,14341},{12,10,10,10,10,2}},
	[18458] = {14153,8,300,315,345,{14048,12662,14256,7078,12808,14341},{12,20,40,12,12,2}},
	[18560] = {14342,8,250,290,320,{14256},{2}},
	[18629] = {14529,1,260,260,320,{14047},{1}},
	[18630] = {14530,1,290,290,350,{14047},{2}},
	[19047] = {15407,3,250,250,260,{8171,15409},{1,1}},
	[19048] = {15077,3,255,275,295,{8170,15408,14341},{4,4,1}},
	[19049] = {15083,3,260,280,300,{8170,2325,14341},{8,1,1}},
	[19050] = {15045,3,260,280,300,{8170,15412,14341},{20,25,2}},
	[19051] = {15076,3,265,285,305,{8170,15408,14341},{6,6,1}},
	[19052] = {15084,3,265,285,305,{8170,2325,14341},{8,1,1}},
	[19053] = {15074,3,265,285,305,{8170,15423,14341},{6,6,1}},
	[19054] = {15047,3,300,320,340,{8170,15414,14341},{40,30,1}},
	[19055] = {15091,3,270,290,310,{8170,14047,14341},{10,6,1}},
	[19058] = {15564,3,250,250,270,{8170},{5}},
	[19059] = {15054,3,270,290,310,{8170,7078,7075,14341},{6,1,1,1}},
	[19060] = {15046,3,270,290,310,{8170,15412,14341},{20,25,1}},
	[19061] = {15061,3,270,290,310,{8170,12803,14341},{12,4,1}},
	[19062] = {15067,3,270,290,310,{8170,15420,1529,14341},{24,80,2,1}},
	[19063] = {15073,3,275,295,315,{8170,15423,14341},{4,8,1}},
	[19064] = {15078,3,275,295,315,{8170,15408,14341},{6,8,1}},
	[19065] = {15092,3,275,295,315,{8170,7971,14047,14341},{6,1,6,1}},
	[19066] = {15071,3,275,295,315,{8170,15422,14341},{4,6,1}},
	[19067] = {15057,3,275,295,315,{8170,7080,7082,14341},{16,2,2,1}},
	[19068] = {15064,3,275,295,315,{8170,15419,14341},{28,12,1}},
	[19070] = {15082,3,280,300,320,{8170,15408,14341},{6,8,1}},
	[19071] = {15086,3,280,300,320,{8170,2325,14341},{12,1,1}},
	[19072] = {15093,3,280,300,320,{8170,14047,14341},{12,10,1}},
	[19073] = {15072,3,280,300,320,{8170,15423,14341},{8,8,1}},
	[19074] = {15069,3,285,305,325,{8170,15422,14341},{6,8,1}},
	[19075] = {15079,3,285,305,325,{8170,15408,14341},{8,12,1}},
	[19076] = {15053,3,285,305,325,{8170,7078,7076,14341},{8,1,1,1}},
	[19077] = {15048,3,285,305,325,{8170,15415,15407,14341},{28,30,1,1}},
	[19078] = {15060,3,285,305,325,{8170,12803,15407,14341},{16,6,1,1}},
	[19079] = {15056,3,285,305,325,{8170,7080,7082,15407,14341},{16,3,3,1,1}},
	[19080] = {15065,3,285,305,325,{8170,15419,14341},{24,14,1}},
	[19081] = {15075,3,290,310,330,{8170,15423,14341},{10,10,1}},
	[19082] = {15094,3,290,310,330,{8170,14047,14341},{14,10,1}},
	[19083] = {15087,3,290,310,330,{8170,15407,2325,14341},{16,1,3,1}},
	[19084] = {15063,3,290,310,330,{8170,15417,14341},{30,8,1}},
	[19085] = {15050,3,290,310,330,{8170,15416,15407,14341},{40,60,1,2}},
	[19086] = {15066,3,290,310,330,{8170,15420,1529,15407,14341},{40,120,1,1,1}},
	[19087] = {15070,3,295,315,335,{8170,15422,14341},{6,10,1}},
	[19088] = {15080,3,295,315,335,{8170,15408,15407,14341},{8,12,1,1}},
	[19089] = {15049,3,295,315,335,{8170,15415,12810,15407,14341},{28,30,2,1,1}},
	[19090] = {15058,3,295,315,335,{8170,7080,7082,12810,14341},{12,3,3,2,1}},
	[19091] = {15095,3,300,320,340,{8170,14047,12810,14341},{18,12,2,1}},
	[19092] = {15088,3,300,320,340,{8170,2325,14341},{14,2,2}},
	[19093] = {15138,3,300,320,340,{15410,14044,14341},{1,1,1}},
	[19094] = {15051,3,300,320,340,{8170,15416,12810,15407,14341},{44,45,2,1,1}},
	[19095] = {15059,3,300,320,340,{8170,12803,14342,15407,14341},{16,8,2,1,2}},
	[19097] = {15062,3,300,320,340,{8170,15417,15407,14341},{30,14,1,1}},
	[19098] = {15085,3,300,320,340,{8170,15407,14256,2325,14341},{20,2,6,4,2}},
	[19100] = {15081,3,300,320,340,{8170,15408,15407,14341},{14,14,1,2}},
	[19101] = {15055,3,300,320,340,{8170,7078,7076,14341},{10,1,1,2}},
	[19102] = {15090,3,300,320,340,{8170,12810,14047,15407,14341},{22,4,16,1,2}},
	[19103] = {15096,3,300,320,340,{8170,12810,14047,15407,14341},{16,4,18,1,2}},
	[19104] = {15068,3,300,320,340,{8170,15422,15407,14341},{12,12,1,2}},
	[19106] = {15141,3,300,320,340,{8170,15410,15416,14341},{40,12,60,2}},
	[19107] = {15052,3,300,320,340,{8170,15416,12810,15407,14341},{40,60,4,1,2}},
	[19435] = {15802,8,290,295,325,{14048,14342,7971,14341},{6,4,2,1}},
	[19566] = {15409,3,250,1,1,{8150},{1}},
	[19567] = {15846,9,250,270,290,{10561,12359,10558,10560},{1,6,1,4}},
	[19666] = {15869,2,100,100,120,{2842,3470},{1,1},2},
	[19667] = {15870,2,150,150,170,{3577,3486},{1,1},2},
	[19668] = {15871,2,200,200,220,{6037,7966},{1,1},2},
	[19669] = {15872,2,275,275,285,{12360,12644},{1,1},2},
	[19788] = {15992,9,250,250,260,{12365},{2}},
	[19790] = {15993,9,260,280,300,{15994,12359,15992,14047},{1,3,3,3},3},
	[19791] = {15994,9,260,280,300,{12359,14047},{3,1}},
	[19792] = {15995,9,260,280,300,{10559,10561,15994,12359,10546},{2,2,2,4,1}},
	[19793] = {15996,9,265,285,305,{12803,15994,10558,8170},{1,4,1,1}},
	[19794] = {15999,9,270,290,310,{10502,7910,12810,14047},{1,4,2,8}},
	[19795] = {16000,9,275,295,315,{12359},{6}},
	[19796] = {16004,9,275,295,315,{16000,11371,10546,12361,12799,8170},{2,6,2,2,2,4}},
	[19799] = {16005,9,285,305,325,{15994,11371,15992,14047},{2,1,3,3},3},
	[19800] = {15997,9,285,305,325,{12359,15992},{2,1},200},
	[19814] = {16023,9,275,295,315,{10561,16000,15994,6037,8170,14047},{1,1,2,1,2,4}},
	[19815] = {16006,9,285,305,325,{12360,14227},{1,1}},
	[19819] = {16009,9,290,310,330,{16006,10558,15994,12799},{2,1,1,1}},
	[19825] = {16008,9,290,310,330,{10500,12364,12810},{1,2,4}},
	[19830] = {16022,9,300,320,340,{10576,16006,12655,15994,10558,12810},{1,8,10,6,4,6}},
	[19831] = {16040,9,300,320,340,{16006,12359,14047},{1,3,1},3},
	[19833] = {16007,9,300,320,340,{12360,16000,7078,7076,12800,12810},{10,2,2,2,2,2}},
	[20008] = {nil,10,255,275,315,{16202},{3}},
	[20009] = {nil,10,270,290,330,{16202,11176},{3,10}},
	[20010] = {nil,10,295,315,355,{16204,16203},{6,6}},
	[20011] = {nil,10,300,320,360,{16204},{15}},
	[20012] = {nil,10,270,290,330,{16202,16204},{3,3}},
	[20013] = {nil,10,295,315,355,{16203,16204},{4,4}},
	[20014] = {nil,10,265,285,325,{16202,7077,7075,7079,7081,7972},{2,1,1,1,1,1}},
	[20015] = {nil,10,285,305,345,{16204},{8}},
	[20016] = {nil,10,280,300,340,{16203,16204},{2,4}},
	[20017] = {nil,10,265,285,325,{11176},{10}},
	[20020] = {nil,10,260,280,320,{11176},{10}},
	[20023] = {nil,10,295,315,355,{16203},{8}},
	[20024] = {nil,10,275,295,335,{16203,16202},{2,1}},
	[20025] = {nil,10,300,320,360,{14344,16204,16203},{4,15,10}},
	[20026] = {nil,10,275,295,335,{16204,14343},{6,1}},
	[20028] = {nil,10,290,310,350,{16203,14343},{3,1}},
	[20029] = {nil,10,285,305,345,{14343,7080,7082,13467},{4,1,1,1}},
	[20030] = {nil,10,295,315,355,{14344,16204},{4,10}},
	[20031] = {nil,10,300,320,360,{14344,16203},{2,10}},
	[20032] = {nil,10,300,320,360,{14344,12808,12803},{6,6,6}},
	[20033] = {nil,10,295,315,355,{14344,12808},{4,4}},
	[20034] = {nil,10,300,320,360,{14344,12811},{4,2}},
	[20035] = {nil,10,300,320,360,{16203,14344},{12,2}},
	[20036] = {nil,10,300,320,360,{16203,14344},{12,2}},
	[20051] = {16207,10,290,310,350,{16206,13926,16204,16203,14343,14344},{1,1,10,4,4,2}},
	[20201] = {16206,2,275,275,285,{12360,12644},{3,1}},
	[20626] = {16766,6,225,265,305,{7974,2692,1179},{2,1,1},2},
	[20648] = {2319,3,100,100,110,{2318},{4}},
	[20649] = {4234,3,150,150,160,{2319},{5}},
	[20650] = {4304,3,200,200,205,{4234},{6}},
	[20848] = {16980,8,300,315,345,{14048,17010,17011,12810,14341},{12,4,4,6,2}},
	[20849] = {16979,8,300,315,345,{14048,17010,7078,12810,14341},{8,6,4,2,2}},
	[20853] = {16982,3,295,315,335,{17012,17010,17011,14341},{20,6,2,2}},
	[20854] = {16983,3,300,320,340,{17012,17010,17011,14341},{15,3,6,2}},
	[20855] = {16984,3,300,320,340,{12810,15416,17010,17011,14341},{6,30,4,3,2}},
	[20872] = {16989,2,295,315,335,{11371,17010,17011},{6,3,3}},
	[20873] = {16988,2,300,320,340,{11371,17010,17011},{16,4,5}},
	[20874] = {17014,2,295,315,335,{11371,17010,17011},{4,2,2}},
	[20876] = {17013,2,300,320,340,{11371,17010,17011},{16,4,6}},
	[20890] = {17015,2,300,320,340,{11371,17010,11382,12810},{16,12,2,2}},
	[20897] = {17016,2,300,320,340,{11371,17011,11382,12810},{18,12,2,2}},
	[20916] = {8364,6,175,215,255,{8365},{1}},
	[21143] = {17197,6,1,45,85,{6889,17194},{1,1}},
	[21144] = {17198,6,35,75,115,{6889,1179,17196,17194},{1,1,1,1}},
	[21161] = {17193,2,300,325,350,{17203,11371,12360,7078,11382,17011,17010},{8,20,50,25,10,10,10}},
	[21175] = {17222,6,200,240,280,{12205},{2}},
	[21913] = {17704,2,190,215,240,{3859,3829,7070,7069,4234},{10,1,2,2,2}},
	[21923] = {17708,4,190,210,250,{3819,3358,3372},{2,1,1}},
	[21931] = {nil,10,190,210,250,{11135,11137,11139,3819},{3,3,1,2}},
	[21935] = {17202,9,190,1,1,{159},{1}},
	[21940] = {17716,9,190,190,230,{3860,4389,17202,3829},{8,4,4,1}},
	[21943] = {17721,3,190,210,230,{4234,7067,4291},{8,4,1}},
	[21945] = {17723,8,190,200,210,{4305,2605,4291},{5,4,1}},
	[22331] = {8170,3,250,250,250,{4304},{6}},
	[22430] = {17967,4,1,315,330,{15410},{1}},
	[22434] = {17968,10,1,320,310,{17967,16204,16203},{1,2,2}},
	[22480] = {18045,6,225,265,305,{12208,3713},{1,1}},
	[22704] = {18232,9,300,320,340,{12359,8170,7191,7067,7068},{12,4,1,2,1}},
	[22711] = {18238,3,200,210,230,{4304,7428,7971,4236,1210,8343},{6,8,2,2,4,1}},
	[22727] = {18251,3,300,320,340,{17012,14341},{3,2}},
	[22732] = {18253,4,300,310,330,{10286,13464,13463,18256},{1,4,4,1}},
	[22749] = {nil,10,300,320,360,{14344,16203,7078,7080,7082,13926},{4,12,4,4,4,2}},
	[22750] = {nil,10,300,320,360,{14344,16203,12803,7080,12811},{4,8,6,6,1}},
	[22757] = {18262,2,300,300,320,{7067,12365},{2,3}},
	[22759] = {18263,8,300,320,350,{14342,17010,7078,12810,14341},{6,8,2,6,4}},
	[22761] = {18254,6,275,315,355,{18255,3713},{1,1}},
	[22793] = {18283,9,300,320,340,{17011,7076,16006,11371,16000},{2,2,4,6,1}},
	[22795] = {18282,9,300,320,340,{17010,17011,12360,16006,16000},{4,2,6,2,2}},
	[22797] = {18168,9,300,320,340,{12360,16006,7082,12803,7076},{6,2,8,12,8}},
	[22808] = {18294,4,215,230,270,{7972,8831,8925},{1,2,1}},
	[22813] = {18258,8,285,285,295,{14048,8170,18240,14341},{2,4,1,1}},
	[22815] = {18258,3,285,285,295,{8170,14048,18240,14341},{4,2,1,1}},
	[22866] = {18405,8,300,315,345,{14048,9210,14342,7080,7078,14344,14341},{16,10,10,12,12,6,6}},
	[22867] = {18407,8,300,315,345,{14048,14256,12662,12808,14341},{12,20,6,8,2}},
	[22868] = {18408,8,300,315,345,{14048,7078,7910,14341},{12,10,2,2}},
	[22869] = {18409,8,300,315,345,{14048,14342,13926,14341},{12,6,2,2}},
	[22870] = {18413,8,300,315,345,{14048,12809,12360,14341},{12,4,1,2}},
	[22902] = {18486,8,300,315,345,{14048,14342,13926,14341},{6,4,2,2}},
	[22921] = {18504,3,300,320,340,{8170,12804,15407,14341},{12,12,2,4}},
	[22922] = {18506,3,300,320,340,{8170,7082,11754,15407,14341},{12,6,4,2,4}},
	[22923] = {18508,3,300,320,340,{8170,18512,15420,15407,14341},{12,8,60,4,4}},
	[22926] = {18509,3,300,320,340,{8170,12607,15416,15414,15407,14341},{30,12,30,30,5,8}},
	[22927] = {18510,3,300,320,340,{8170,12803,7080,18512,15407,14341},{30,12,10,8,3,8}},
	[22928] = {18511,3,300,320,340,{8170,7082,12753,12809,15407,14341},{30,12,4,8,4,8}},
	[22967] = {17771,7,300,310,320,{18562,12360,17010,18567},{1,10,1,3}},
	[23066] = {9318,9,150,150,175,{4377,4234},{1,1},3},
	[23067] = {9312,9,150,150,175,{4377,4234},{1,1},3},
	[23068] = {9313,9,150,150,175,{4377,4234},{1,1},3},
	[23069] = {18588,9,200,200,220,{10505,4338},{1,2}},
	[23070] = {18641,9,250,250,270,{15992,14047},{2,3},2},
	[23071] = {18631,9,260,270,280,{6037,7067,7069},{2,2,1}},
	[23077] = {18634,9,260,280,300,{15994,18631,12361,7078,3829,13467},{6,2,2,4,2,4}},
	[23078] = {18587,9,265,285,305,{15994,18631,7191,14227,7910},{2,2,2,2,2}},
	[23079] = {18637,9,275,285,295,{16000,18631,14047},{2,1,2}},
	[23080] = {18594,9,275,275,295,{15994,15992,8170,159},{2,3,2,1}},
	[23081] = {18638,9,290,310,330,{11371,18631,7080,7910,12800},{4,3,6,4,2}},
	[23082] = {18639,9,300,320,340,{11371,18631,12803,12808,12800,12799},{8,4,6,4,2,2}},
	[23096] = {18645,9,265,275,285,{12359,15994,8170,7910,7191},{4,2,4,1,1}},
	[23129] = {18660,9,260,260,270,{10561,15994,10558,10560,3864},{1,2,1,1,1}},
	[23190] = {18662,3,150,150,160,{4234,2321},{2,1}},
	[23399] = {18948,3,155,175,195,{4234,4236,5498,4461,5637},{8,2,4,1,4}},
	[23486] = {18984,9,285,285,305,{3860,18631,7077,7910,10586},{10,1,4,2,1}},
	[23489] = {18986,9,285,285,305,{3860,18631,7075,7079,7909,9060},{12,2,4,2,4,1}},
	[23507] = {19026,9,250,250,270,{15992,14047,8150},{2,2,1},4},
	[23628] = {19043,2,290,310,330,{12359,7076,12803},{12,3,3}},
	[23629] = {19048,2,300,320,340,{12360,7076,12803},{4,6,6}},
	[23632] = {19051,2,290,310,330,{12359,6037,12811},{8,6,1}},
	[23633] = {19057,2,300,320,340,{12360,6037,12811},{2,10,1}},
	[23636] = {19148,2,300,320,340,{17011,17010,11371},{4,2,4}},
	[23637] = {19164,2,300,320,340,{17011,17010,17012,11371,11382},{3,5,4,4,2}},
	[23638] = {19166,2,300,320,340,{17011,17010,12360,11382,11371},{3,6,12,1,4}},
	[23639] = {19167,2,300,320,340,{17011,17010,12360,11371},{5,2,16,6}},
	[23650] = {19170,2,300,320,340,{17011,17010,12360,11371,12800},{4,7,12,8,4}},
	[23652] = {19168,2,300,320,340,{17011,17010,12360,11371,12809},{6,6,10,6,12}},
	[23653] = {19169,2,300,320,340,{17011,17010,12360,11371,12364},{8,5,10,12,4}},
	[23662] = {19047,8,290,305,335,{14048,7076,12803,14227},{8,3,3,2}},
	[23663] = {19050,8,300,315,345,{14342,7076,12803,14227},{5,5,5,2}},
	[23664] = {19056,8,290,305,335,{14048,12810,13926,12809,14227},{6,4,2,2,2}},
	[23665] = {19059,8,300,315,345,{14342,12809,14227},{5,2,2}},
	[23666] = {19156,8,300,315,345,{14342,17010,17011,7078,14227},{10,2,3,6,4}},
	[23667] = {19165,8,300,315,345,{14342,17010,17011,7078,14227},{8,5,3,10,4}},
	[23703] = {19044,3,290,310,330,{8170,12804,12803,15407,14341},{30,2,4,2,2}},
	[23704] = {19049,3,300,320,340,{12810,12804,12803,15407,14227},{8,6,6,2,2}},
	[23705] = {19052,3,290,310,330,{8170,12809,7080,15407,14341},{30,2,4,2,2}},
	[23706] = {19058,3,300,320,340,{12810,12803,12809,15407,14341},{8,4,4,2,2}},
	[23707] = {19149,3,300,320,340,{17011,15407,14227},{5,4,4}},
	[23708] = {19157,3,300,320,340,{17010,17011,17012,12607,15407,14227},{5,2,4,4,4,4}},
	[23709] = {19162,3,300,320,340,{17010,17012,12810,15407,14227},{8,12,10,4,4}},
	[23710] = {19163,3,300,320,340,{17010,17011,7076,15407,14227},{2,7,6,4,4}},
	[23787] = {19440,1,300,300,360,{19441},{1}},
	[23799] = {nil,10,290,310,350,{14344,16203,16204,7076},{6,6,4,2}},
	[23800] = {nil,10,290,310,350,{14344,16203,16204,7082},{6,6,4,2}},
	[23801] = {nil,10,290,310,350,{16204,16203,7080},{16,4,2}},
	[23802] = {nil,10,300,320,360,{14344,16204,16203,12803},{2,20,4,6}},
	[23803] = {nil,10,300,320,360,{14344,16203,16204},{10,8,15}},
	[23804] = {nil,10,300,320,360,{14344,16203,16204},{15,12,20}},
	[24091] = {19682,8,300,315,345,{14342,19726,12804,14048,14227},{3,5,4,4,2}},
	[24092] = {19683,8,300,315,345,{14342,19726,12804,14048,14227},{4,4,4,4,2}},
	[24093] = {19684,8,300,315,345,{14342,19726,12810,14048,14227},{3,3,4,4,4}},
	[24121] = {19685,3,300,320,340,{19767,15407,12803,14341},{14,5,4,4}},
	[24122] = {19686,3,300,320,340,{19767,15407,12803,14341},{10,4,4,3}},
	[24123] = {19687,3,300,320,340,{19767,15407,12803,14341},{8,3,4,3}},
	[24124] = {19688,3,300,320,340,{19768,19726,15407,14341},{35,2,3,3}},
	[24125] = {19689,3,300,320,340,{19768,19726,15407,14341},{25,2,3,3}},
	[24136] = {19690,2,300,320,340,{12359,19774,19726,7910},{20,10,2,2}},
	[24137] = {19691,2,300,320,340,{12359,19774,19726,7910},{16,8,2,1}},
	[24138] = {19692,2,300,320,340,{12359,19774,19726,12810},{12,6,2,4}},
	[24139] = {19693,2,300,320,340,{12359,19774,12799},{20,14,2}},
	[24140] = {19694,2,300,320,340,{12359,19774,12799},{18,12,2}},
	[24141] = {19695,2,300,320,340,{12359,19774,12799},{16,10,1}},
	[24266] = {19931,4,300,315,330,{12938,19943,12804,13468},{1,1,6,1},3},
	[24356] = {19999,9,300,320,340,{19726,19774,16006,12804,12810},{4,5,2,8,4}},
	[24357] = {19998,9,300,320,340,{19726,19774,16006,12804,12810},{5,5,1,8,4}},
	[24365] = {20007,4,275,290,330,{13463,13466,8925},{1,2,1}},
	[24366] = {20002,4,275,290,330,{13463,13464,8925},{2,1,1}},
	[24367] = {20008,4,285,300,340,{13467,13465,10286,8925},{2,2,2,1}},
	[24368] = {20004,4,290,305,345,{8846,13466,8925},{1,2,1}},
	[24399] = {20039,2,300,320,340,{17011,17010,17012,11371},{3,3,4,6}},
	[24418] = {20074,6,150,160,200,{3667,3713},{2,1}},
	[24654] = {20295,3,300,320,340,{8170,15415,15407,14341},{28,36,2,2}},
	[24655] = {20296,3,280,300,320,{8170,15412,15407,14341},{20,30,1,2}},
	[24703] = {20380,3,300,320,340,{12810,20381,12803,15407,14227},{12,6,4,4,6}},
	[24801] = {20452,6,285,325,365,{20424,3713},{1,1}},
	[24846] = {20481,3,300,320,340,{20500,20498,7078},{1,20,2}},
	[24847] = {20480,3,300,320,340,{20500,20498,7078,15407},{2,30,2,1}},
	[24848] = {20479,3,300,320,340,{20500,20498,7078,15407},{3,40,2,2}},
	[24849] = {20476,3,300,320,340,{20501,20498,18512},{1,20,2}},
	[24850] = {20477,3,300,320,340,{20501,20498,18512,15407},{2,30,2,1}},
	[24851] = {20478,3,300,320,340,{20501,20498,18512,15407},{3,40,2,2}},
	[24901] = {20538,8,300,315,345,{14048,20520,14256,14227},{6,8,6,2}},
	[24902] = {20539,8,300,315,345,{14048,20520,14256,12810,14227},{2,6,2,2,2}},
	[24903] = {20537,8,300,315,345,{14048,20520,14256,12810,14227},{4,6,4,2,2}},
	[24912] = {20549,2,300,320,340,{12359,20520,6037,12810},{12,6,6,2}},
	[24913] = {20551,2,300,320,340,{12359,20520,6037,11754},{16,8,8,1}},
	[24914] = {20550,2,300,320,340,{12359,20520,6037},{20,10,10}},
	[24940] = {20575,3,100,125,150,{2319,7286,4231,2321},{8,8,1,2}},
	[25072] = {nil,10,300,320,360,{20725,14344,18512},{4,6,8}},
	[25073] = {nil,10,300,320,360,{20725,14344,12808},{3,10,6}},
	[25074] = {nil,10,300,320,360,{20725,14344,7080},{3,10,4}},
	[25078] = {nil,10,300,320,360,{20725,14344,7078},{2,10,4}},
	[25079] = {nil,10,300,320,360,{20725,14344,12811},{3,8,1}},
	[25080] = {nil,10,300,320,360,{20725,14344,7082},{3,8,4}},
	[25081] = {nil,10,300,320,360,{20725,14344,7078},{3,8,4}},
	[25082] = {nil,10,300,320,360,{20725,14344,12803},{2,8,4}},
	[25083] = {nil,10,300,320,360,{20725,14344,13468},{3,8,2}},
	[25084] = {nil,10,300,320,360,{20725,14344,11754},{4,6,2}},
	[25086] = {nil,10,300,320,360,{20725,14344,12809},{3,8,8}},
	[25124] = {20744,10,45,55,75,{10940,17034,3371},{2,1,1}},
	[25125] = {20745,10,150,160,180,{11083,17034,3372},{3,2,1}},
	[25126] = {20746,10,200,210,230,{11137,17035,3372},{3,2,1}},
	[25127] = {20747,10,250,260,280,{11176,8831,8925},{3,2,1}},
	[25128] = {20750,10,275,285,305,{16204,4625,8925},{3,2,1}},
	[25129] = {20749,10,300,310,330,{14344,4625,18256},{2,3,1}},
	[25130] = {20748,10,300,310,330,{14344,8831,18256},{2,3,1}},
	[25146] = {7068,4,300,301,310,{7077},{1},3},
	[25347] = {20844,13,1,300,350,{5173,8925},{7,1}},
	[25659] = {21023,6,300,325,365,{2692,9061,8150,21024},{1,1,1,1},5},
	[25704] = {21072,6,80,120,160,{21071,2678},{1,1}},
	[25954] = {21217,6,175,215,255,{21153,2692},{1,1}},
	[26011] = {21277,9,250,320,340,{15407,15994,7079,18631,10558},{1,4,2,2,1}},
	[26085] = {21340,8,260,275,305,{14048,8170,7972,14341},{6,4,2,1}},
	[26086] = {21341,8,285,300,330,{14256,12810,20520,14227},{12,6,2,4}},
	[26087] = {21342,8,300,315,345,{14256,17012,19726,7078,14227},{20,16,8,4,4}},
	[26277] = {21546,4,250,265,305,{6371,4625,8925},{3,3,1}},
	[26279] = {21278,3,300,320,340,{12810,7080,7082,15407,14227},{6,4,4,2,2}},
	[26403] = {21154,8,250,265,295,{14048,4625,2604,14341},{4,2,2,1}},
	[26407] = {21542,8,250,265,295,{14048,4625,2604,14341},{4,2,2,1}},
	[26416] = {21558,9,125,125,150,{4364,2319},{1,1},3},
	[26417] = {21559,9,125,125,150,{4364,2319},{1,1},3},
	[26418] = {21557,9,125,125,150,{4364,2319},{1,1},3},
	[26420] = {21589,9,175,175,200,{4377,4234},{1,1},3},
	[26421] = {21590,9,175,175,200,{4377,4234},{1,1},3},
	[26422] = {21592,9,175,175,200,{4377,4234},{1,1},3},
	[26423] = {21571,9,225,225,250,{10505,4304},{1,1},3},
	[26424] = {21574,9,225,225,250,{10505,4304},{1,1},3},
	[26425] = {21576,9,225,225,250,{10505,4304},{1,1},3},
	[26426] = {21714,9,275,275,285,{15992,8170},{1,1},3},
	[26427] = {21716,9,275,275,285,{15992,8170},{1,1},3},
	[26428] = {21718,9,275,275,285,{15992,8170},{1,1},3},
	[26442] = {21569,9,225,245,265,{9060,9061,10560,10561},{1,1,1,1}},
	[26443] = {21570,9,275,295,315,{9060,9061,18631,10561},{4,4,2,1}},
	[27585] = {22197,2,300,320,340,{22202,12655,7076},{14,4,2}},
	[27586] = {22198,2,300,320,340,{22203,22202,12655,7076},{8,24,8,4}},
	[27587] = {22196,2,300,320,340,{22203,22202,12655,7076,12364},{18,40,12,10,4}},
	[27588] = {22195,2,300,320,340,{22202,12810},{14,4}},
	[27589] = {22194,2,300,320,340,{22203,22202,12810,13512},{8,24,8,1}},
	[27590] = {22191,2,300,320,340,{22203,22202,12810,12809,12800},{15,36,12,10,4}},
	[27658] = {22246,8,225,240,270,{4339,11137,8343},{4,4,2}},
	[27659] = {22248,8,275,290,320,{14048,16203,14341},{5,2,2}},
	[27660] = {22249,8,300,315,345,{14048,14344,12810,14227},{6,4,4,4}},
	[27724] = {22251,8,275,290,320,{14048,8831,11040,14341},{5,10,8,2}},
	[27725] = {22252,8,300,315,345,{14048,14342,13468,14227},{6,2,1,4}},
	[27829] = {22385,2,300,320,340,{12360,12655,7076,13510},{12,20,10,2}},
	[27830] = {22384,2,300,320,340,{12360,11371,12808,20520,15417,12753},{15,10,20,20,10,2}},
	[27832] = {22383,2,300,320,340,{12360,20725,13512,12810},{12,2,2,4}},
	[27837] = {nil,10,290,310,350,{14344,16203,16204,7082},{10,6,14,4}},
	[28205] = {22654,8,300,315,345,{22682,14048,7080,14227},{5,4,4,4}},
	[28207] = {22652,8,300,315,345,{22682,14048,7080,14227},{7,8,6,8}},
	[28208] = {22658,8,300,315,345,{22682,14048,7080,14227},{5,4,2,4}},
	[28209] = {22655,8,300,315,345,{22682,14048,7080,14227},{4,2,2,4}},
	[28210] = {22660,8,300,315,345,{19726,14342,12803,14227},{1,2,4,4}},
	[28219] = {22661,3,300,320,340,{22682,12810,7080,15407,14227},{7,16,2,4,4}},
	[28220] = {22662,3,300,320,340,{22682,12810,7080,15407,14227},{5,12,2,3,4}},
	[28221] = {22663,3,300,320,340,{22682,12810,7080,15407,14227},{4,12,2,2,4}},
	[28222] = {22664,3,300,320,340,{22682,15408,7080,15407,14227},{7,24,2,4,4}},
	[28223] = {22666,3,300,320,340,{22682,15408,7080,15407,14227},{5,16,2,3,4}},
	[28224] = {22665,3,300,320,340,{22682,15408,7080,15407,14227},{4,16,2,2,4}},
	[28242] = {22669,2,300,320,340,{22682,12359,12360,7080},{7,16,2,4}},
	[28243] = {22670,2,300,320,340,{22682,12359,12360,7080},{5,12,2,2}},
	[28244] = {22671,2,300,320,340,{22682,12359,12360,7080},{4,12,2,2}},
	[28327] = {22728,9,275,295,315,{15994,10561,10558},{2,1,1}},
	[28461] = {22762,2,300,320,340,{12655,19726,12360,12803},{12,2,2,2}},
	[28462] = {22763,2,300,320,340,{12655,19726,12803},{8,1,2}},
	[28463] = {22764,2,300,320,340,{12655,12803},{6,2}},
	[28472] = {22759,3,300,320,340,{12810,19726,12803,15407},{12,2,2,2}},
	[28473] = {22760,3,300,320,340,{12810,18512,12803,15407},{6,2,2,2}},
	[28474] = {22761,3,300,320,340,{12810,12803,15407},{4,2,1}},
	[28480] = {22756,8,300,315,345,{14048,19726,12803,14227},{4,2,2,2}},
	[28481] = {22757,8,300,315,345,{14048,14342,12803,14227},{4,2,2,2}},
	[28482] = {22758,8,300,315,345,{14048,12803,14227},{2,4,2}},
	[30021] = {23684,1,300,300,360,{23567,14047},{1,10},4},
	[30047] = {23683,6,300,325,365,{23567,8150},{1,1},2},
}
if AtlasLoot:GameVersion_GE(AtlasLoot.BC_VERSION_NUM) then
    PROFESSION_DATA.BCC = {
		[2658] = {2842,7,75,115,130,{2775},{1}},
		[2795] = {2888,6,10,60,100,{2886,2894},{1,1}},
		[3304] = {3576,7,65,65,75,{2771},{1}},
		[3307] = {3575,7,125,130,160,{2772},{1}},
		[3321] = {3471,2,35,75,115,{2840,3470},{8,2}},
		[3328] = {3480,2,110,140,170,{2841,3478},{5,1}},
		[3334] = {3484,2,145,175,205,{3575,3478,2605},{6,2,1}},
		[3421] = {3776,13,1,275,325,{8923,8925},{1,1}},
		[5763] = {5237,13,1,150,200,{2928,3371},{1,1}},
		[6617] = {5631,4,60,90,130,{5635,3371},{2,1}},
		[7795] = {6339,10,100,130,170,{6338,10940,10939,6218},{1,6,3,1}},
		[7953] = {6466,3,90,120,150,{6470,4231,2321},{4,1,1}},
		[7954] = {6467,3,105,130,155,{6470,2321},{5,2}},
		[7955] = {6468,3,115,140,165,{6471,6470,2321},{6,4,2}},
		[8687] = {6949,13,1,165,215,{2928,3372},{1,1}},
		[8691] = {6950,13,1,205,255,{8924,3372},{2,1}},
		[8694] = {6951,13,1,215,265,{8923,3372},{1,1}},
		[9811] = {7913,2,160,185,210,{3575,5635,3486},{8,4,2}},
		[9818] = {7916,2,180,205,230,{3575,5637,3486},{12,4,2}},
		[9974] = {7939,2,245,265,285,{3860,6037,7910,7971,7966},{12,12,2,2,2}},
		[9980] = {7937,2,245,265,285,{3860,6037,7966},{16,2,1}},
		[10097] = {3860,7,175,175,230,{3858},{1}},
		[10098] = {6037,7,230,235,250,{7911},{1}},
		[11341] = {8926,13,1,245,295,{8924,8925},{1,1}},
		[11342] = {8927,13,1,285,335,{8924,8925},{2,1}},
		[11343] = {8928,13,1,325,375,{8924,8925},{2,1}},
		[11357] = {8984,13,1,255,305,{5173,8925},{1,1}},
		[11358] = {8985,13,1,295,345,{5173,8925},{2,1}},
		[11400] = {9186,13,1,285,335,{8923,8925},{1,1}},
		[13028] = {10841,6,175,175,205,{3821,159},{1,1},4},
		[13220] = {10918,13,1,185,235,{2930,3372},{1,1}},
		[13228] = {10920,13,1,225,275,{2930,5173,3372},{1,1,1}},
		[13229] = {10921,13,1,265,315,{8923,8925},{1,1}},
		[13230] = {10922,13,1,305,355,{8923,5173,8925},{1,1,1}},
		[13240] = {10577,9,205,1,1,{10577,3860,10505},{1,1,3}},
		[13628] = {11130,10,150,175,215,{11128,5500,11082,11083,6339},{1,1,2,2,1}},
		[13702] = {11145,10,200,220,260,{11144,7971,11135,11137,11130},{1,1,2,2,1}},
		[14891] = {11371,7,300,300,310,{11370},{8}},
		[15906] = {12217,6,200,225,250,{12037,4402,2692},{1,1,1}},
		[15910] = {12215,6,200,225,250,{12204,3713,159},{2,1,1},2},
		[15915] = {12216,6,225,250,275,{12206,2692},{1,2}},
		[15933] = {12218,6,225,250,275,{12207,3713},{1,2}},
		[16153] = {12359,7,250,250,290,{10620},{1}},
		[16646] = {12428,2,265,285,305,{12359,8170},{12,6}},
		[16647] = {12424,2,265,285,305,{12359,8170},{10,6}},
		[16649] = {12425,2,270,290,310,{12359},{12}},
		[16657] = {12426,2,295,315,335,{12359},{18}},
		[16658] = {12427,2,295,315,335,{12359,7910},{18,1}},
		[16663] = {12422,2,300,320,340,{12359},{20}},
		[16730] = {12429,2,300,320,340,{12359},{24}},
		[17570] = {13455,4,280,295,335,{13423,10620,8925},{2,1,1}},
		[17632] = {13503,4,350,365,380,{9149,25867,25868,22794,23571},{1,1,1,2,5}},
		[17634] = {13506,4,300,315,330,{13423,13465,13468,8925},{7,3,1,1}},
		[17635] = {13510,4,300,315,330,{8846,13423,13468,8925},{7,3,1,1}},
		[17636] = {13511,4,300,315,330,{13463,13467,13468,8925},{7,3,1,1}},
		[17637] = {13512,4,300,315,330,{13463,13465,13468,8925},{7,3,1,1}},
		[17638] = {13513,4,300,315,330,{13467,13465,13468,8925},{7,3,1,1}},
		[18238] = {6887,6,225,250,275,{4603},{1}},
		[18239] = {13927,6,225,250,275,{13754,3713},{1,1}},
		[18240] = {13928,6,240,265,290,{13755,3713},{1,1}},
		[18241] = {13930,6,225,250,275,{13758},{1}},
		[18242] = {13929,6,240,265,290,{13756,2692},{1,2}},
		[18243] = {13931,6,250,275,295,{13759,159},{1,1}},
		[18244] = {13932,6,250,275,295,{13760},{1}},
		[18245] = {13933,6,275,300,325,{13888,159},{1,1}},
		[18246] = {13934,6,275,300,325,{13893,2692,3713},{1,1,1}},
		[18247] = {13935,6,275,300,325,{13889,3713},{1,1}},
		[18408] = {14042,8,260,275,305,{14048,7077,14341},{5,2,1}},
		[18412] = {14043,8,270,285,315,{14048,7077,14341},{4,2,1}},
		[18419] = {14107,8,275,290,320,{14048,14256,14341},{5,2,1}},
		[18437] = {14108,8,285,300,330,{14048,14256,8170,14341},{6,2,4,1}},
		[18442] = {14111,8,290,305,335,{14048,14256,14341},{5,2,1}},
		[18451] = {14106,8,300,315,345,{14048,14256,12662,14341},{8,3,2,2}},
		[18453] = {14112,8,300,315,345,{14048,14256,12662,8170,14341},{7,3,2,4,2}},
		[19080] = {15065,3,285,305,325,{8170,15419,14341},{24,14,1}},
		[19098] = {15085,3,300,320,340,{8170,15407,14256,2325,14341},{20,2,2,4,2}},
		[19800] = {15997,9,285,295,305,{12359,15992},{2,1},200},
		[20010] = {nil,10,295,310,340,{16204,16203},{6,6}},
		[20011] = {nil,10,300,310,340,{16204},{15}},
		[20013] = {nil,10,295,310,340,{16203,16204},{4,4}},
		[20015] = {nil,10,285,300,335,{16204},{8}},
		[20023] = {nil,10,295,310,340,{16203},{8}},
		[20025] = {nil,10,300,310,340,{14344,16204,16203},{4,15,10}},
		[20028] = {nil,10,290,305,340,{16203,14343},{3,1}},
		[20029] = {nil,10,285,300,335,{14343,7080,7082,13467},{4,1,1,1}},
		[20030] = {nil,10,295,310,340,{14344,16204},{4,10}},
		[20031] = {nil,10,300,310,340,{14344,16203},{2,10}},
		[20032] = {nil,10,300,310,340,{14344,12808,12803},{6,6,6}},
		[20033] = {nil,10,295,310,340,{14344,12808},{4,4}},
		[20034] = {nil,10,300,310,340,{14344,12811},{4,2}},
		[20035] = {nil,10,300,310,340,{16203,14344},{12,2}},
		[20036] = {nil,10,300,310,340,{16203,14344},{12,2}},
		[20051] = {16207,10,290,305,340,{16206,13926,16204,16203,11145,14344},{1,1,10,4,1,2}},
		[20626] = {16766,6,225,250,275,{7974,2692,1179},{2,1,1},2},
		[21175] = {17222,6,200,225,250,{12205},{2}},
		[22480] = {18045,6,225,250,275,{12208,3713},{1,1}},
		[22704] = {18232,9,300,320,340,{12359,7191},{16,2}},
		[22749] = {nil,10,300,310,340,{14344,16203,7078,7080,7082,13926},{4,12,4,4,4,2}},
		[22750] = {nil,10,300,310,340,{14344,16203,12803,7080,12811},{4,8,6,6,1}},
		[22761] = {18254,6,275,300,325,{18255,3713},{1,1}},
		[22967] = {17771,7,350,350,375,{18562,12360,17010,18567},{1,10,1,3}},
		[23799] = {nil,10,290,305,340,{14344,16203,16204,7076},{6,6,4,2}},
		[23800] = {nil,10,290,305,340,{14344,16203,16204,7082},{6,6,4,2}},
		[23801] = {nil,10,290,305,340,{16204,16203,7080},{16,4,2}},
		[23802] = {nil,10,300,310,340,{14344,16204,16203,12803},{2,20,4,6}},
		[23803] = {nil,10,300,310,340,{14344,16203,16204},{10,8,15}},
		[23804] = {nil,10,300,310,340,{14344,16203,16204},{15,12,20}},
		[24266] = {19931,4,315,315,330,{12938,19943,12804,13468},{1,1,6,1},3},
		[24801] = {20452,6,285,310,335,{20424,3713},{1,1}},
		[25072] = {nil,10,300,310,340,{22448,22446,21886},{4,2,8}},
		[25073] = {nil,10,300,310,340,{20725,14344,12808},{3,10,6}},
		[25074] = {nil,10,300,310,340,{20725,14344,7080},{3,10,4}},
		[25078] = {nil,10,300,310,340,{20725,14344,7078},{2,10,4}},
		[25079] = {nil,10,300,310,340,{20725,14344,12811},{3,8,1}},
		[25080] = {nil,10,300,310,340,{22448,22446,22451},{3,3,2}},
		[25081] = {nil,10,300,310,340,{22448,22446,7078},{3,3,4}},
		[25082] = {nil,10,300,310,340,{22448,22446,12803},{2,3,4}},
		[25083] = {nil,10,300,310,340,{22448,22446,22794},{3,3,2}},
		[25084] = {nil,10,300,310,340,{22448,22446,22456},{4,2,8}},
		[25086] = {nil,10,300,310,340,{22448,22446,22452},{3,3,8}},
		[25255] = {20816,14,20,20,50,{2840},{2}},
		[25278] = {20817,14,50,70,90,{2841},{2}},
		[25280] = {20818,14,50,80,110,{2842},{1}},
		[25283] = {20821,14,30,60,90,{774,2840},{2,2}},
		[25284] = {20820,14,60,90,120,{5498,20817,2840},{1,1,2}},
		[25287] = {20823,14,70,100,130,{1210,20817,20816},{2,1,2}},
		[25305] = {20826,14,90,120,150,{2842,20817,1206,1705},{2,1,1,1}},
		[25317] = {20827,14,80,110,140,{2842},{2}},
		[25318] = {20828,14,100,130,160,{1210,2841},{2,2}},
		[25320] = {20831,14,150,180,210,{3577,1206,3391},{1,2,1}},
		[25321] = {20832,14,120,150,180,{1705,5498,11083,2842,3827},{3,3,4,4,2}},
		[25323] = {20833,14,125,155,185,{1705,3824,3575},{1,1,4}},
		[25339] = {20830,14,110,140,170,{1705,20817},{2,1}},
		[25347] = {20844,13,1,300,350,{5173,8925},{2,1}},
		[25490] = {20907,14,50,80,110,{2841},{4}},
		[25493] = {20906,14,30,30,60,{20816},{2}},
		[25498] = {20909,14,110,140,170,{3575,5637,20817},{8,2,2}},
		[25610] = {20950,14,120,150,180,{1206,20817},{1,1}},
		[25612] = {20954,14,125,155,185,{3575,3391},{8,2}},
		[25613] = {20955,14,135,165,195,{1529,3577,20816},{1,2,2}},
		[25614] = {20956,14,145,175,205,{1206,1529,2842,20817},{1,1,2,2}},
		[25615] = {20963,14,150,170,190,{3860},{2}},
		[25617] = {20958,14,150,180,210,{3864,20963},{1,1}},
		[25618] = {20966,14,160,190,220,{1529,20963},{1,2}},
		[25619] = {20959,14,170,200,230,{1529,7067},{1,2}},
		[25620] = {20960,14,170,200,230,{6037,20963},{1,2}},
		[25621] = {20961,14,180,210,240,{3864,7070,3860},{1,2,2}},
		[25622] = {20967,14,190,220,250,{3864,7070,3577,20817},{1,2,2,1}},
		[25659] = {21023,6,300,325,350,{2692,9061,8150,21024},{1,1,1,1},5},
		[26745] = {21840,8,300,305,325,{21877},{6}},
		[26746] = {21841,8,315,320,340,{21840,14341},{4,1}},
		[26747] = {21842,8,325,330,340,{21840,22445},{3,2}},
		[26749] = {21843,8,340,340,350,{21842,21881,22446},{4,2,1}},
		[26750] = {21844,8,345,345,355,{21840,21882},{1,8}},
		[26751] = {nil,8,350,350,360,{21842,21886,21885},{1,1,1}},
		[26752] = {21846,8,355,365,375,{24271,21884,21881},{4,10,2}},
		[26753] = {21847,8,365,375,385,{24271,21884,21881},{8,12,4}},
		[26754] = {21848,8,375,385,395,{24271,21884,21881},{14,16,4}},
		[26755] = {21858,8,375,385,395,{24271,22446,21881},{6,4,4}},
		[26756] = {21869,8,355,365,375,{24272,21885,21881},{4,10,2}},
		[26757] = {21870,8,365,375,385,{24272,21885,21881},{8,12,2}},
		[26758] = {21871,8,375,385,395,{24272,21885,21881},{14,16,4}},
		[26759] = {21872,8,375,385,395,{24272,21881},{6,4}},
		[26760] = {21873,8,355,365,375,{21845,21881,21886},{4,2,8}},
		[26761] = {21874,8,365,375,385,{21845,21881,21886},{8,2,8}},
		[26762] = {21875,8,375,385,395,{21845,22457,21881},{14,12,4}},
		[26763] = {21876,8,375,385,395,{21845,21881},{8,4}},
		[26764] = {21849,8,310,320,330,{21840,14341},{3,1}},
		[26765] = {21850,8,310,320,330,{21840,14341},{3,1}},
		[26770] = {21851,8,320,330,340,{21840,21887,14341},{4,2,1}},
		[26771] = {21852,8,325,335,345,{21840,14341},{6,1}},
		[26772] = {21853,8,335,345,355,{21840,21887,14341},{6,2,1}},
		[26773] = {21854,8,340,350,360,{21840,14341},{8,2}},
		[26774] = {21855,8,345,355,365,{21840,14341},{8,2}},
		[26775] = {21859,8,340,350,360,{21842,21881,14341},{5,2,1}},
		[26776] = {21860,8,350,360,370,{21842,21887,21881,14341},{4,6,2,1}},
		[26777] = {21861,8,360,370,380,{21842,21881,14341},{6,2,1}},
		[26778] = {21862,8,360,370,380,{21842,21881,14341},{6,2,1}},
		[26779] = {21863,8,355,365,375,{21844,21887,14341},{5,6,4}},
		[26780] = {21864,8,365,375,385,{21844,14341},{6,4}},
		[26781] = {21865,8,375,385,395,{21844,14341},{8,4}},
		[26782] = {21866,8,350,360,370,{21840,22445,14341},{6,12,2}},
		[26783] = {21867,8,360,370,380,{21840,22445,14341},{8,16,2}},
		[26784] = {21868,8,370,380,390,{21840,22445,14341},{12,20,2}},
		[26786] = {21835,13,1,340,370,{2931,5173,8925},{1,1,1}},
		[26872] = {21748,14,200,225,255,{1529,6037,11137,20963},{4,2,4,4}},
		[26873] = {21756,14,200,225,255,{3577,3864},{6,2}},
		[26874] = {20964,14,210,235,265,{7909,8151},{3,4}},
		[26875] = {21758,14,215,240,270,{7971,8151},{4,4}},
		[26876] = {21755,14,220,245,275,{7909,20963},{1,3}},
		[26878] = {20969,14,225,250,280,{7910,7971,6037,21752,6149},{2,2,4,4,4}},
		[26880] = {21752,14,225,235,255,{12359},{1}},
		[26881] = {21760,14,225,250,280,{7909,6037,7075,7079,8151},{2,4,2,2,4}},
		[26882] = {21763,14,235,260,290,{7910,6037,7077,7081,8151},{2,4,2,2,4}},
		[26883] = {21764,14,235,260,290,{7910,21752},{1,1}},
		[26885] = {21765,14,240,265,295,{6037,10286},{2,2}},
		[26887] = {21754,14,245,270,300,{7909,21752},{1,1}},
		[26892] = {21927,13,1,365,415,{2931,8925},{1,1}},
		[26896] = {21753,14,250,275,305,{7909,3864,21752,6037},{2,2,4,2}},
		[26897] = {21766,14,250,275,305,{12799,21752,6037,11178,20963},{2,2,4,2,2}},
		[26900] = {21769,14,260,280,300,{7910,7078,8152,6037},{2,2,4,2}},
		[26902] = {21767,14,260,280,300,{12799,21752},{1,1}},
		[26903] = {21768,14,275,285,305,{12361,6037,21752},{4,2,1}},
		[26904] = {21785,14,275,1,1,{12364},{1}},
		[26905] = {21786,14,275,1,1,{12800},{1}},
		[26906] = {21774,14,275,285,305,{12364,12799,12361,12360,12359},{2,2,2,2,2}},
		[26907] = {21775,14,280,290,310,{21752,12804,7076},{1,1,1}},
		[26908] = {21790,14,280,290,310,{12361,12808,21752},{1,1,1}},
		[26909] = {21777,14,285,295,315,{12364,12360,12359,12804},{2,2,2,4}},
		[26910] = {21778,14,285,295,315,{12363,12808,12662},{1,2,1}},
		[26911] = {21791,14,290,300,320,{12364,12803,12804},{2,4,4}},
		[26912] = {21784,14,300,310,330,{18335,11754,12800,12360,12359},{4,4,2,2,4}},
		[26914] = {21789,14,300,310,330,{11371,12360,7910},{4,2,2}},
		[26915] = {21792,14,305,315,335,{12800,21752,12360},{2,2,2}},
		[26916] = {21779,14,310,320,340,{21929,7078,12803},{1,4,4}},
		[26918] = {21793,14,315,325,345,{12360,7076,7082},{4,4,4}},
		[26920] = {21780,14,325,335,355,{12359,11382,7910,12938},{8,2,4,2}},
		[26925] = {21931,14,30,30,60,{20816,2840},{2,1}},
		[26926] = {21932,14,5,35,65,{2840,20816},{4,2}},
		[26927] = {21933,14,50,80,110,{2841,1210,20816},{2,1,1}},
		[26928] = {21934,14,30,60,90,{818,2840,20816},{2,2,1}},
		[26969] = {22053,13,1,345,385,{2931,8925},{1,1}},
		[27032] = {21990,1,330,330,390,{21877},{1}},
		[27033] = {21991,1,360,360,410,{21877},{2}},
		[27282] = {22054,13,1,385,425,{2931,8925},{1,1}},
		[27283] = {22055,13,1,345,395,{8923,8925},{2,1}},
		[27837] = {nil,10,290,305,340,{14344,16203,16204,7082},{10,6,14,4}},
		[27899] = {nil,10,305,315,345,{22445},{6}},
		[27905] = {nil,10,315,325,355,{22445,22447},{6,6}},
		[27906] = {nil,10,320,330,360,{22448,22445},{2,10}},
		[27911] = {nil,10,325,335,365,{22446,21886},{4,4}},
		[27913] = {nil,10,335,345,375,{22446},{8}},
		[27914] = {nil,10,350,360,390,{22449,22446,22445},{1,10,20}},
		[27917] = {nil,10,360,370,400,{22449,21884,21885},{6,6,6}},
		[27920] = {nil,10,360,370,400,{22449,22445},{2,6}},
		[27924] = {nil,10,360,370,400,{22449,22446},{2,2}},
		[27926] = {nil,10,370,380,410,{22449,22446,22445},{2,3,5}},
		[27927] = {nil,10,375,385,415,{22450,22449},{2,2}},
		[27944] = {nil,10,310,320,350,{22445,22452},{6,10}},
		[27945] = {nil,10,325,335,365,{22446},{4}},
		[27946] = {nil,10,340,350,380,{22445,22446,22452},{12,4,10}},
		[27947] = {nil,10,360,370,400,{22449,22573,22574,22572,22578},{2,1,1,1,1}},
		[27948] = {nil,10,305,315,345,{22445,13446,13444},{6,4,4}},
		[27950] = {nil,10,320,330,360,{22445},{12}},
		[27951] = {nil,10,340,350,380,{22446,22445},{8,8}},
		[27954] = {nil,10,370,380,410,{22450,22449,23572},{2,4,1}},
		[27957] = {nil,10,315,325,355,{22445,13446,14344},{8,4,2}},
		[27958] = {nil,10,325,335,365,{22449,13444,22446},{1,4,3}},
		[27960] = {nil,10,345,355,385,{22449,22445,22446},{4,4,4}},
		[27961] = {nil,10,310,320,350,{22445},{8}},
		[27962] = {nil,10,330,340,370,{22446,21884,22451,22452,21885},{4,4,4,4,4}},
		[27967] = {nil,10,340,350,380,{22449,22446,22445},{2,6,6}},
		[27968] = {nil,10,340,350,380,{22449,22446},{2,10}},
		[27971] = {nil,10,350,360,390,{22449,22445},{4,40}},
		[27972] = {nil,10,350,360,390,{22449,22446,22445},{4,5,20}},
		[27975] = {nil,10,350,360,390,{22449,22446},{8,8}},
		[27977] = {nil,10,360,370,400,{22449,22446,22445},{8,6,20}},
		[27981] = {nil,10,375,385,415,{22450,22449,22446,21884,23571},{12,10,8,6,1}},
		[27982] = {nil,10,375,385,415,{22450,22449,22446,21885,22456},{12,10,8,6,6}},
		[27984] = {nil,10,375,385,415,{22450,22449,22446,22445},{6,10,8,40}},
		[28003] = {nil,10,360,370,400,{22449,22446,22445},{12,10,20}},
		[28004] = {nil,10,360,370,400,{22450,22449,21885},{8,8,2}},
		[28016] = {22521,10,310,310,330,{22445,22791,18256},{3,1,1}},
		[28019] = {22522,10,340,340,360,{22445,22792,18256},{3,1,1}},
		[28021] = {22445,10,325,335,355,{12363},{1},3},
		[28022] = {22449,10,335,5,10,{22448},{3}},
		[28027] = {22460,10,325,325,335,{22449},{4}},
		[28028] = {22459,10,350,360,390,{22450},{2}},
		[28267] = {22645,6,60,100,140,{22644},{1}},
		[28327] = {22728,9,275,275,285,{3860,10558},{3,1}},
		[28543] = {22823,4,305,320,335,{22787,22785,18256},{1,1,1}},
		[28544] = {22824,4,305,320,335,{13465,22785,18256},{1,1,1}},
		[28545] = {22825,4,310,325,340,{13464,22786,18256},{1,1,1}},
		[28546] = {22826,4,315,330,345,{22787,22785,18256},{2,1,1}},
		[28549] = {22827,4,320,335,350,{22578,22790,18256},{2,1,1}},
		[28550] = {22828,4,320,335,350,{22789,18256},{3,1}},
		[28551] = {22829,4,325,340,355,{22791,22785,18256},{2,1,1}},
		[28552] = {22830,4,325,340,355,{22787,22789,18256},{2,1,1}},
		[28553] = {22831,4,330,345,360,{22789,22785,18256},{1,2,1}},
		[28554] = {22871,4,335,350,365,{22787,22791,18256},{3,1,1}},
		[28555] = {22832,4,340,355,370,{22786,22785,18256},{2,1,1}},
		[28556] = {22833,4,345,360,375,{22574,22790,18256},{2,1,1}},
		[28557] = {22834,4,345,360,375,{22790,22789,18256},{3,1,1}},
		[28558] = {22835,4,350,365,380,{22790,22792,18256},{1,1,1}},
		[28562] = {22836,4,350,365,380,{22786,22792,18256},{1,1,1}},
		[28563] = {22837,4,350,365,380,{22789,22790,18256},{2,1,1}},
		[28564] = {22838,4,350,365,380,{22789,22791,18256},{2,1,1}},
		[28565] = {22839,4,350,365,380,{22792,22791,18256},{2,1,1}},
		[28566] = {21884,4,350,365,380,{22451},{1}},
		[28567] = {21885,4,350,365,380,{22452},{1}},
		[28568] = {22452,4,350,365,380,{21884},{1}},
		[28569] = {22451,4,350,365,380,{21885},{1}},
		[28570] = {22840,4,355,370,385,{22790,22791,18256},{1,1,1}},
		[28571] = {22841,4,360,375,390,{21884,22793,18256},{1,3,5},5},
		[28572] = {22842,4,360,375,390,{21885,22793,18256},{1,3,5},5},
		[28573] = {22844,4,360,375,390,{21886,22793,18256},{1,3,5},5},
		[28575] = {22845,4,360,375,390,{22457,22793,18256},{1,3,5},5},
		[28576] = {22846,4,360,375,390,{22456,22793,18256},{1,3,5},5},
		[28577] = {22847,4,360,375,390,{21886,22793,18256},{1,3,5},5},
		[28578] = {22848,4,365,380,395,{22791,22793,18256},{1,1,1}},
		[28579] = {22849,4,365,380,395,{22790,22573,18256},{2,3,1}},
		[28580] = {21885,4,375,385,400,{22456},{1}},
		[28581] = {22456,4,375,385,400,{21885},{1}},
		[28582] = {21884,4,375,385,400,{22457},{1}},
		[28583] = {22457,4,375,385,400,{21884},{1}},
		[28584] = {22452,4,375,385,400,{21886},{1}},
		[28585] = {21886,4,375,385,400,{22452},{1}},
		[28586] = {22850,4,375,390,405,{22793,22786,22791,18256},{2,1,1,1}},
		[28587] = {22851,4,375,390,405,{22794,22793,22790,18256},{1,3,7,1}},
		[28588] = {22853,4,375,390,405,{22794,22793,22786,18256},{1,3,7,1}},
		[28589] = {22854,4,375,390,405,{22794,22793,22789,18256},{1,3,7,1}},
		[28590] = {22861,4,375,390,405,{22794,22793,22791,18256},{1,3,7,1}},
		[28591] = {22866,4,375,390,405,{22794,22793,22792,18256},{1,3,7,1}},
		[28903] = {23094,14,300,300,340,{23077},{1}},
		[28905] = {23095,14,305,305,345,{23077},{1}},
		[28906] = {23096,14,315,315,355,{23077},{1}},
		[28907] = {23097,14,325,325,355,{23077},{1}},
		[28910] = {23098,14,300,300,340,{21929},{1}},
		[28912] = {23099,14,305,305,345,{21929},{1}},
		[28914] = {23100,14,315,315,355,{21929},{1}},
		[28915] = {23101,14,325,325,355,{21929},{1}},
		[28916] = {23103,14,300,300,340,{23079},{1}},
		[28917] = {23104,14,305,305,345,{23079},{1}},
		[28918] = {23105,14,315,315,355,{23079},{1}},
		[28924] = {23106,14,325,325,355,{23079},{1}},
		[28925] = {23108,14,300,300,340,{23107},{1}},
		[28927] = {23109,14,305,305,345,{23107},{1}},
		[28933] = {23110,14,315,315,355,{23107},{1}},
		[28936] = {23111,14,325,325,355,{23107},{1}},
		[28938] = {23113,14,300,300,340,{23112},{1}},
		[28944] = {23114,14,305,305,345,{23112},{1}},
		[28947] = {23115,14,315,315,355,{23112},{1}},
		[28948] = {23116,14,325,325,355,{23112},{1}},
		[28950] = {23118,14,300,300,340,{23117},{1}},
		[28953] = {23119,14,305,305,345,{23117},{1}},
		[28955] = {23120,14,315,315,355,{23117},{1}},
		[28957] = {23121,14,325,325,355,{23117},{1}},
		[29356] = {23445,7,300,300,315,{23424},{2}},
		[29358] = {23446,7,325,325,340,{23425},{2}},
		[29359] = {23447,7,350,350,365,{23427},{2}},
		[29360] = {23448,7,350,355,380,{23445,23447},{3,2}},
		[29361] = {23449,7,375,375,375,{23426},{2}},
		[29545] = {23482,2,300,310,330,{23445},{4}},
		[29547] = {23484,2,305,315,335,{23445},{4}},
		[29548] = {23487,2,315,325,345,{23445},{6}},
		[29549] = {23488,2,315,325,345,{23445},{8}},
		[29550] = {23489,2,325,335,355,{23445},{10}},
		[29551] = {23493,2,300,310,330,{23445},{4}},
		[29552] = {23491,2,310,320,340,{23445},{5}},
		[29553] = {23494,2,315,325,345,{23445},{6}},
		[29556] = {23490,2,320,330,350,{23445},{9}},
		[29557] = {23497,2,310,320,340,{23445},{9}},
		[29558] = {23498,2,315,325,345,{23445},{10}},
		[29565] = {23499,2,320,330,350,{23445},{12}},
		[29566] = {23502,2,325,335,355,{23446},{8}},
		[29568] = {23503,2,330,340,360,{23446},{8}},
		[29569] = {23504,2,330,340,360,{23446,21887},{7,2}},
		[29571] = {23505,2,335,345,365,{23446},{12}},
		[29603] = {23506,2,335,345,365,{23446,22452,21884},{6,2,2}},
		[29605] = {23508,2,335,345,365,{23446,21887,22452,21884},{8,2,3,2}},
		[29606] = {23507,2,340,350,370,{23446,22452,21884},{12,4,2}},
		[29608] = {23510,2,355,365,385,{23573,22445,22449},{2,8,2}},
		[29610] = {23509,2,360,370,390,{23573,22445,22449},{4,20,4}},
		[29611] = {23511,2,355,365,385,{23573,22445,22449},{3,12,2}},
		[29613] = {23512,2,365,375,395,{23573,22445,22449},{4,24,4}},
		[29614] = {23515,2,350,360,380,{23445,21885,21884},{6,3,2}},
		[29615] = {23516,2,355,365,385,{23445,21885,21884},{12,5,3}},
		[29616] = {23514,2,360,370,390,{23445,21885,21884},{8,4,4}},
		[29617] = {23513,2,365,375,395,{23445,21885,21884},{16,6,4}},
		[29619] = {23517,2,360,370,390,{23448},{6}},
		[29620] = {23518,2,360,370,390,{23448},{8}},
		[29621] = {23519,2,365,375,395,{23448},{8}},
		[29622] = {23532,2,365,375,395,{23573,23571,22452,23572},{10,2,15,1}},
		[29628] = {23524,2,360,370,390,{23449,21885,22457},{3,2,2}},
		[29629] = {23523,2,360,370,390,{23449,21885,22457},{6,4,4}},
		[29630] = {23525,2,365,375,395,{23449,21885,22457},{4,3,3}},
		[29642] = {23520,2,365,375,395,{23445,21884,23449,22824},{8,6,3,2}},
		[29643] = {23521,2,365,375,395,{23445,21884,23449,22824},{10,10,4,4}},
		[29645] = {23522,2,370,380,400,{23445,21884,23449,22824},{12,10,6,4}},
		[29648] = {23526,2,370,380,400,{23448,22449,22831,22451},{6,2,4,4}},
		[29649] = {23527,2,370,380,400,{23573,21886,22452},{4,6,4}},
		[29654] = {23528,2,300,300,310,{23445,22573},{1,1}},
		[29656] = {23529,2,350,350,360,{23446,22573},{1,2}},
		[29657] = {23530,2,360,370,390,{23448,21884,22452},{4,4,4}},
		[29658] = {23531,2,365,375,395,{23448,23571,23572},{10,3,1}},
		[29662] = {23533,2,365,375,395,{23448,23571,23572},{10,5,1}},
		[29663] = {23534,2,365,375,395,{23573,22451,21885,23572},{8,16,16,1}},
		[29664] = {23535,2,365,375,395,{23573,22452,22457,23572},{8,22,12,1}},
		[29668] = {23536,2,365,375,395,{23573,23571,21886,23572},{8,3,18,1}},
		[29669] = {23537,2,365,375,395,{23448,22456,23572},{6,15,1}},
		[29671] = {23538,2,365,375,395,{23573,21886,23572},{6,20,1}},
		[29672] = {23539,2,365,375,395,{23573,23571,21885,23572},{6,2,15,1}},
		[29686] = {23573,7,375,375,375,{23446},{10}},
		[29688] = {23571,4,350,365,380,{22452,21885,22451,21884,22457},{1,1,1,1,1}},
		[29692] = {23540,2,365,375,395,{23449,23448,23571,23572},{10,10,6,2}},
		[29693] = {23541,2,365,375,395,{23449,23573,23571,23572},{20,2,6,2}},
		[29694] = {23542,2,365,375,395,{23449,23448,23571,23572},{10,10,8,2}},
		[29695] = {23543,2,365,375,395,{23449,23448,23571,23572},{10,10,8,2}},
		[29696] = {23544,2,365,375,395,{23449,23448,23571,23572},{10,10,8,2}},
		[29697] = {23546,2,365,375,395,{23449,23448,23571,23572},{10,10,8,2}},
		[29698] = {23554,2,365,375,395,{23449,23573,23447,23571,23572},{10,4,10,8,2}},
		[29699] = {23555,2,365,375,395,{23449,23448,23571,23572},{10,10,8,2}},
		[29700] = {23556,2,365,375,395,{23449,23573,23447,23571,23572},{10,4,10,8,4}},
		[29728] = {23575,2,340,340,350,{23446},{1}},
		[29729] = {23576,2,375,375,375,{23447},{1}},
		[30303] = {23781,9,300,300,320,{22574,22573},{1,2},4},
		[30304] = {23782,9,300,300,320,{23445},{3}},
		[30305] = {23783,9,300,300,310,{23445},{1}},
		[30306] = {23784,9,325,325,335,{23446,22452},{4,1}},
		[30307] = {23785,9,340,350,370,{23573},{3}},
		[30308] = {23786,9,340,350,370,{23449,21884},{3,1}},
		[30309] = {23787,9,340,350,370,{23448},{2}},
		[30310] = {23736,9,300,320,340,{23782,23783,23781},{1,2,1},4},
		[30311] = {23737,9,325,335,355,{23446,23783,23781},{4,2,1},3},
		[30312] = {23742,9,320,330,350,{4400,23782,23783},{1,3,6}},
		[30313] = {23746,9,350,360,380,{23782,23784,23783},{3,2,4}},
		[30314] = {23747,9,360,370,390,{23785,23787,23783},{1,4,4}},
		[30315] = {23748,9,375,385,405,{23785,23449,23783,23439},{2,12,4,2}},
		[30316] = {23758,9,340,350,370,{23793,23077,22445},{4,2,8}},
		[30317] = {23761,9,340,350,370,{23793,21929,22445},{4,2,8}},
		[30318] = {23762,9,350,360,380,{23793,23449,23079,22448},{4,2,2,2}},
		[30325] = {23763,9,360,370,390,{23793,23449,23441,22449},{4,2,2,2}},
		[30329] = {23764,9,335,345,365,{23446,23112},{8,2}},
		[30332] = {23765,9,360,370,390,{23785,23449,23440},{1,4,2}},
		[30334] = {23766,9,375,385,405,{23785,23787,23438},{2,6,2}},
		[30337] = {23767,9,325,335,355,{23784,23782,10558,23783},{1,2,1,2}},
		[30341] = {23768,9,335,335,355,{23781,21877},{1,1},3},
		[30342] = {23769,9,335,335,355,{23781,21877,2604},{1,1,1},3},
		[30343] = {23770,9,335,335,355,{23781,21877,6260},{1,1,1},3},
		[30344] = {23771,9,335,335,355,{23781,21877,2605},{1,1,1},3},
		[30346] = {23772,9,310,310,330,{23445,23781},{2,1},200},
		[30347] = {34504,9,335,335,355,{23446,23781,4470},{1,2,4}},
		[30348] = {23774,9,325,325,345,{23782,23445,23783},{1,5,2}},
		[30349] = {23775,9,350,360,380,{23782,23449,23783},{1,5,2}},
		[30547] = {23819,9,350,350,360,{23781,23782,23783},{2,1,1},2},
		[30548] = {23821,9,305,305,325,{23782,23783,21886,16006},{2,2,4,1}},
		[30549] = {23820,9,325,325,345,{23784,23783,10558},{1,2,1}},
		[30551] = {33092,9,330,330,350,{23782,23783,21887,22829},{1,1,2,20},20},
		[30552] = {33093,9,345,345,365,{23782,23783,21887,22832},{1,1,2,20},20},
		[30555] = {23840,9,335,1,1,{23784,23783,23786,7191},{1,2,1,1}},
		[30556] = {23824,9,355,365,385,{23793,23786,23785,23787},{8,2,2,4}},
		[30558] = {23826,9,325,325,345,{23782,23781,17020,23783},{3,6,3,2},3},
		[30560] = {23827,9,340,340,360,{21877,23781,22457},{4,4,1},2},
		[30561] = {23831,9,1,325,335,{23782,23783,10558},{1,4,1}},
		[30563] = {23836,9,350,360,380,{23785,23786,23787,21884,22452,16006},{2,1,2,6,6,2}},
		[30565] = {23838,9,375,375,395,{24272,22457,22451},{4,12,12}},
		[30566] = {23839,9,375,375,395,{23573,22452,21884},{8,12,12}},
		[30568] = {23841,9,325,335,355,{23784,23783,23781,23782},{1,2,3,1},3},
		[30569] = {23835,9,340,360,380,{23785,23786,22445,22449},{2,2,10,2}},
		[30570] = {23825,9,350,360,380,{23793,23786,21886,22456,16006},{8,4,10,10,2}},
		[30573] = {23832,9,1,325,335,{23782,23783,10558},{1,4,1}},
		[30574] = {23828,9,375,375,395,{24271,21884,22451,22452,21885,23437},{4,8,8,8,8,2}},
		[30575] = {23829,9,375,375,395,{23793,22456,22452,21884,23436},{8,12,12,12,2}},
		[31048] = {24074,14,310,320,340,{23445,23077},{1,2}},
		[31049] = {24075,14,310,320,350,{23445,23112},{1,2}},
		[31050] = {24076,14,320,330,350,{23445,23117,23079},{1,2,1}},
		[31051] = {24077,14,335,345,365,{23446,31079},{2,1}},
		[31052] = {24078,14,335,345,365,{23446,31079},{1,1}},
		[31053] = {24079,14,350,360,380,{23449,31079,22456},{2,3,3}},
		[31054] = {24080,14,355,365,385,{23449,31079,21885},{2,4,3}},
		[31055] = {24082,14,355,365,385,{23449,31079,21884},{2,4,3}},
		[31056] = {24085,14,360,370,390,{23449,31079,21886},{2,4,3}},
		[31057] = {24086,14,365,375,395,{23449,31079,22457},{2,4,3}},
		[31058] = {24087,14,345,355,375,{23448,31079},{2,4}},
		[31060] = {24088,14,355,365,385,{23447,31079},{1,5}},
		[31061] = {24089,14,365,375,395,{23447,31079,21884},{2,4,4}},
		[31062] = {24092,14,360,370,390,{23448,21885,21884,31079},{2,6,4,1}},
		[31063] = {24093,14,360,370,390,{23448,21884,21885,31079},{2,6,4,1}},
		[31064] = {24095,14,360,370,390,{23448,22456,21886,31079},{2,6,4,1}},
		[31065] = {24097,14,360,370,390,{23448,21886,22456,31079},{2,6,4,1}},
		[31066] = {24098,14,360,370,390,{23448,22457,31079},{2,8,1}},
		[31067] = {24106,14,355,365,385,{23448,31079},{2,3}},
		[31068] = {24110,14,355,365,385,{23449,31079,23436},{4,1,1}},
		[31070] = {24114,14,360,370,390,{23447,31079},{2,3}},
		[31071] = {24116,14,360,370,390,{23573,31079,23441},{2,2,1}},
		[31072] = {24117,14,365,375,395,{23447,31079,23112},{2,4,2}},
		[31076] = {24121,14,365,375,395,{23449,31079,23117},{2,4,2}},
		[31077] = {24122,14,370,380,400,{23449,21886,23437,31079},{20,20,2,5}},
		[31078] = {24123,14,370,380,400,{23448,22457,23438,31079},{20,20,2,5}},
		[31079] = {24124,14,370,380,400,{23448,23077,22452},{8,2,4}},
		[31080] = {24125,14,370,380,400,{23449,23440,23112},{4,2,4}},
		[31081] = {24126,14,370,380,400,{23448,23436,21884},{2,2,4}},
		[31082] = {24127,14,370,380,400,{23447,23437,22457},{2,2,4}},
		[31083] = {24128,14,370,380,400,{23573,23441,22456},{6,2,2}},
		[31084] = {24027,14,350,350,380,{23436},{1}},
		[31085] = {24028,14,350,350,380,{23436},{1}},
		[31087] = {24029,14,350,350,380,{23436},{1}},
		[31088] = {24030,14,350,350,380,{23436},{1}},
		[31089] = {24031,14,350,350,380,{23436},{1}},
		[31090] = {24032,14,350,350,380,{23436},{1}},
		[31091] = {24036,14,350,350,380,{23436},{1}},
		[31092] = {24033,14,350,350,380,{23438},{1}},
		[31094] = {24037,14,350,350,380,{23438},{1}},
		[31095] = {24039,14,350,350,380,{23438},{1}},
		[31096] = {24047,14,350,350,380,{23440},{1}},
		[31097] = {24048,14,350,350,380,{23440},{1}},
		[31098] = {24051,14,350,350,380,{23440},{1}},
		[31099] = {24050,14,350,350,380,{23440},{1}},
		[31100] = {24052,14,350,350,380,{23440},{1}},
		[31101] = {24053,14,350,350,380,{23440},{1}},
		[31102] = {24054,14,350,350,380,{23441},{1}},
		[31103] = {24055,14,350,350,380,{23441},{1}},
		[31104] = {24056,14,350,350,380,{23441},{1}},
		[31105] = {24057,14,350,350,380,{23441},{1}},
		[31106] = {24058,14,350,350,380,{23439},{1}},
		[31107] = {24059,14,350,350,380,{23439},{1}},
		[31108] = {24060,14,350,350,380,{23439},{1}},
		[31109] = {24061,14,350,350,380,{23439},{1}},
		[31110] = {24062,14,350,350,380,{23437},{1}},
		[31111] = {24066,14,350,350,380,{23437},{1}},
		[31112] = {24065,14,350,350,380,{23437},{1}},
		[31113] = {24067,14,350,350,380,{23437},{1}},
		[31149] = {24035,14,350,350,380,{23438},{1}},
		[31373] = {nil,8,350,350,360,{21842,22457,21884},{1,1,1}},
		[31430] = {24273,8,335,345,355,{14341,22457},{1,5}},
		[31431] = {24275,8,335,345,355,{14341,21886},{1,5}},
		[31432] = {24274,8,375,385,395,{14341,22457,23572},{1,10,1}},
		[31433] = {24276,8,375,385,395,{14341,21886,23572},{1,10,1}},
		[31434] = {24249,8,350,360,370,{21842,22452},{4,8}},
		[31435] = {24250,8,350,360,370,{21842,22452,22456},{4,4,4}},
		[31437] = {24251,8,350,360,370,{21842,21884},{4,8}},
		[31438] = {24252,8,350,360,370,{21842,22457,22456},{6,3,3}},
		[31440] = {24253,8,350,360,370,{21842,22452},{6,6}},
		[31441] = {24254,8,350,360,370,{21842,21886},{6,6}},
		[31442] = {24255,8,365,375,385,{21845,22452,23572},{8,16,1}},
		[31443] = {24256,8,365,375,385,{24272,21884,23572},{10,16,1}},
		[31444] = {24257,8,365,375,385,{21842,22457,23572},{6,14,1}},
		[31448] = {24258,8,365,375,385,{21845,22452,23572},{10,12,1}},
		[31449] = {24259,8,365,375,385,{24272,22451,23572},{10,14,1}},
		[31450] = {24260,8,365,375,385,{24271,22457,23572},{10,12,1}},
		[31451] = {24261,8,375,385,395,{21845,23571,23572},{10,5,1}},
		[31452] = {24262,8,375,385,395,{24271,23571,23572},{10,5,1}},
		[31453] = {24263,8,375,385,395,{21842,23571,23572},{12,8,1}},
		[31454] = {24264,8,375,385,395,{21845,23571,23572},{10,5,1}},
		[31455] = {24266,8,375,385,395,{24271,23571,23572},{10,5,1}},
		[31456] = {24267,8,375,385,395,{21842,23571,23572},{12,8,1}},
		[31459] = {24270,8,340,350,360,{21842,21887},{6,4}},
		[31460] = {24268,8,300,300,320,{21877},{3},2},
		[31461] = {24269,8,325,325,335,{21877},{6},2},
		[32178] = {25438,14,20,50,80,{774,20816},{1,1}},
		[32179] = {25439,14,20,50,80,{818,20816},{1,1}},
		[32259] = {25498,14,30,30,50,{2835},{8}},
		[32284] = {23559,2,325,325,335,{23446},{1}},
		[32285] = {25521,2,350,350,360,{23449},{1}},
		[32454] = {21887,3,300,300,310,{25649},{5}},
		[32455] = {23793,3,325,325,335,{21887},{5}},
		[32456] = {25650,3,300,310,340,{21887},{4}},
		[32457] = {25651,3,325,335,345,{23793,22452},{3,1}},
		[32458] = {25652,3,325,335,345,{23793,22457},{3,1}},
		[32461] = {25653,3,350,360,380,{23793,23571,22445,22448},{4,1,6,1}},
		[32462] = {25654,3,300,310,330,{21887,25700,14341},{5,1,2}},
		[32463] = {25655,3,310,320,340,{21887,25700,14341},{8,1,2}},
		[32464] = {25656,3,320,330,350,{21887,25700,14341},{10,3,3}},
		[32465] = {25657,3,335,345,365,{21887,25700,14341},{14,3,3}},
		[32466] = {25662,3,300,310,330,{21887,25700,14341},{6,3,2}},
		[32467] = {25661,3,310,320,340,{21887,25700,14341},{8,1,2}},
		[32468] = {25660,3,325,335,355,{21887,25700,14341},{12,3,3}},
		[32469] = {25659,3,335,345,365,{21887,25700,14341},{12,2,3}},
		[32470] = {25669,3,300,310,330,{21887,14341},{6,2}},
		[32471] = {25670,3,315,325,345,{21887,14341},{10,2}},
		[32472] = {25668,3,320,330,350,{21887,14341},{10,3}},
		[32473] = {25671,3,330,340,360,{21887,14341},{14,3}},
		[32478] = {25673,3,300,310,330,{21887,14341},{6,3}},
		[32479] = {25674,3,310,320,340,{21887,14341},{9,3}},
		[32480] = {25675,3,320,330,350,{21887,14341},{13,3}},
		[32481] = {25676,3,330,340,360,{21887,14341},{15,3}},
		[32482] = {25679,3,300,300,310,{21887},{2}},
		[32485] = {25680,3,350,360,380,{23793,29539,22456,4342,14341},{6,2,8,4,3}},
		[32487] = {25681,3,350,360,380,{23793,29539,21886,2325,14341},{6,2,8,4,3}},
		[32488] = {25683,3,350,360,380,{23793,29539,21884,2604,14341},{6,2,8,4,3}},
		[32489] = {25682,3,350,360,380,{23793,29539,22452,14341},{6,2,8,3}},
		[32490] = {25685,3,340,350,370,{23793,25707,22456,14341},{6,6,6,3}},
		[32493] = {25686,3,350,360,380,{23793,25707,22456,14341},{10,8,8,3}},
		[32494] = {25687,3,350,360,380,{23793,25707,22456,14341},{10,10,10,3}},
		[32495] = {25689,3,360,370,390,{23793,25708,22452,14341},{6,40,4,2}},
		[32496] = {25690,3,355,365,385,{23793,25708,22452,14341},{6,34,4,2}},
		[32497] = {25691,3,355,365,385,{23793,25708,22452,14341},{4,20,4,2}},
		[32498] = {25695,3,350,360,380,{23793,25707,25699,22451,14341},{6,4,8,6,2}},
		[32499] = {25697,3,360,370,390,{23793,25707,25699,22451,14341},{6,6,6,4,2}},
		[32500] = {25696,3,360,370,390,{23793,25707,25699,22451,14341},{10,4,8,8,2}},
		[32501] = {25694,3,340,350,370,{23793,25699,21885,22457,14341},{4,8,3,3,2}},
		[32502] = {25692,3,340,350,370,{23793,25699,21885,22457,14341},{8,12,5,5,2}},
		[32503] = {25693,3,350,360,380,{23793,25699,21885,22457,14341},{6,10,4,4,2}},
		[32655] = {25843,2,300,300,310,{23445},{6}},
		[32656] = {25844,2,350,350,360,{23446},{10}},
		[32657] = {25845,2,375,375,385,{23447},{4}},
		[32664] = {22461,10,300,310,340,{25843,16203,14344,16207},{1,4,6,1}},
		[32665] = {22462,10,350,360,390,{25844,22446,22449,23571,22461},{1,8,8,1,1}},
		[32667] = {22463,10,375,370,400,{25845,22446,22450,23571,22462},{1,12,2,4,1}},
		[32765] = {25867,4,350,365,380,{23079,23107,23112,22452,21885},{3,3,3,2,2}},
		[32766] = {25868,4,350,365,380,{23077,21929,23117,21884,22451},{3,3,3,2,2}},
		[32801] = {25880,14,50,70,90,{2836},{8}},
		[32807] = {25881,14,110,120,140,{2838},{8}},
		[32808] = {25882,14,175,175,195,{7912},{10}},
		[32809] = {25883,14,225,225,245,{12365},{10}},
		[32810] = {25884,14,300,300,320,{22452},{1}},
		[32814] = {25886,9,335,335,355,{23781,21877,4342},{1,1,1},3},
		[32866] = {25896,14,365,375,395,{25867},{1}},
		[32867] = {25897,14,365,375,395,{25867},{1}},
		[32868] = {25898,14,365,375,395,{25867},{1}},
		[32869] = {25899,14,365,375,395,{25867},{1}},
		[32870] = {25901,14,365,375,395,{25867},{1}},
		[32871] = {25890,14,365,375,395,{25868},{1}},
		[32872] = {25893,14,365,375,395,{25868},{1}},
		[32873] = {25894,14,365,375,395,{25868},{1}},
		[32874] = {25895,14,365,375,395,{25868},{1}},
		[33276] = {27635,6,1,45,85,{27668},{1}},
		[33277] = {24105,6,1,45,85,{23676},{1}},
		[33278] = {27636,6,50,90,130,{27669},{1}},
		[33279] = {27651,6,300,320,340,{27671},{1}},
		[33284] = {27655,6,300,320,340,{27674},{1}},
		[33285] = {27656,6,310,330,350,{27676},{1}},
		[33286] = {27657,6,315,335,355,{27677},{1}},
		[33287] = {27658,6,325,345,365,{27678},{1}},
		[33288] = {27659,6,325,345,365,{27681},{1}},
		[33289] = {27660,6,325,345,365,{27682},{1}},
		[33290] = {27661,6,300,320,340,{27422},{1}},
		[33291] = {27662,6,300,320,340,{27425},{1}},
		[33292] = {27663,6,310,330,350,{27429},{1}},
		[33293] = {27664,6,320,340,360,{27435},{1}},
		[33294] = {27665,6,320,340,360,{27437},{1}},
		[33295] = {27666,6,325,345,365,{27438},{1}},
		[33296] = {27667,6,350,370,390,{27439},{1}},
		[33732] = {28100,4,300,315,330,{13464,22785,18256},{1,1,1}},
		[33733] = {28101,4,310,325,340,{22787,22785,18256},{2,1,1}},
		[33738] = {28102,4,300,315,330,{13465,22785,18256},{1,1,1}},
		[33740] = {28103,4,300,315,330,{13463,22785,18256},{1,1,1}},
		[33741] = {28104,4,315,330,345,{22789,22785,18256},{3,1,1}},
		[33990] = {nil,10,320,330,360,{22446},{2}},
		[33991] = {nil,10,300,310,340,{22447,22445},{2,2}},
		[33992] = {nil,10,345,355,385,{22446,22445},{4,10}},
		[33993] = {nil,10,305,315,345,{22447,22445},{1,4}},
		[33994] = {nil,10,360,370,400,{22446,22445,22449},{8,2,2}},
		[33995] = {nil,10,340,350,380,{22445,22446},{12,1}},
		[33996] = {nil,10,310,320,350,{22445},{8}},
		[33997] = {nil,10,360,370,400,{22446,22449,22457},{6,6,6}},
		[33999] = {nil,10,350,360,390,{22446,22449,21886},{6,6,6}},
		[34001] = {nil,10,305,315,345,{22447},{3}},
		[34002] = {nil,10,300,310,340,{22445},{6}},
		[34003] = {nil,10,325,335,365,{22446,22445,22457},{2,6,2}},
		[34004] = {nil,10,310,320,350,{22446,22445,22451},{1,4,1}},
		[34005] = {nil,10,350,360,390,{22449,22457},{4,8}},
		[34006] = {nil,10,350,360,390,{22449,22456},{4,8}},
		[34007] = {nil,10,360,370,400,{22449,22451},{8,8}},
		[34008] = {nil,10,360,370,400,{22449,22452},{8,8}},
		[34009] = {nil,10,325,335,365,{22445},{15}},
		[34010] = {nil,10,350,360,390,{22449,21885,21886},{8,8,8}},
		[34069] = {28290,14,325,325,355,{23112},{1}},
		[34529] = {23563,2,350,360,380,{22456,22451,23573,23448,23449},{20,20,6,4,8}},
		[34530] = {23564,2,375,385,405,{23563,23572,22457},{1,10,10}},
		[34533] = {28483,2,350,360,380,{36860,35624,37663,41163,30183},{20,20,6,12,1}},
		[34534] = {28484,2,375,385,405,{28483,35623,34664},{1,10,1}},
		-- 空气 35623
		-- 火焰 36860
		-- 生命 35625
		[34543]={28434, 2, 450, 460, 475, {35623, 35624, 37663, 36913, 30183, }, {'20', '20', '6', '12', 1, }, },
[34544]={28435, 2, 450, 460, 475, {28434, 35622, 34664, }, {1, '10', 1, }, },
[36261]={28436, 2, 450, 460, 475, {28435, 20882, }, {1, 1, }, },
[34541]={28431, 2, 450, 460, 475, {35625, 35627, 37663, 36913, 30183, }, {'20', '20', '6', '12', 1, }, },
[34542]={28432, 2, 450, 460, 475, {28431, 35623, 34664, }, {1, '10', 1, }, },
[36260]={28433, 2, 450, 460, 475, {28432, 20882, }, {1, 1, }, },
[34547]={28440, 2, 450, 460, 475, {35623, 35622, 37663, 36913, 30183, }, {'20', '20', '6', '12', 1, }, },
[34548]={28441, 2, 450, 460, 475, {28440, 34664, 35623, }, {1, 1, '10', }, },
[36263]={28442, 2, 450, 460, 475, {28441, 20882, }, {1, 1, }, },
[34545]={28437, 2, 450, 460, 475, {35624, 36860, 37663, 36913, 30183, }, {'20', '20', 1, '12', 1, }, },
[34546]={28438, 2, 450, 460, 475, {28437, 36860, 34664, }, {1, '10', 1, }, },
[36262]={28439, 2, 450, 460, 475, {28438, 20882, }, {1, 1, }, },
[34538]={28428, 2, 450, 460, 475, {36860, 35625, 37663, 36913, 30183, }, {'20', '20', '6', '12', 1, }, },
[34540]={28429, 2, 450, 460, 475, {28428, 36860, 34664, }, {1, '10', 1, }, },
[36259]={28430, 2, 450, 460, 475, {28429, 20882, }, {1, 1, }, },
[34535]={28425, 2, 450, 460, 475, {35627, 36860, 37663, 36913, 30183, }, {'20', '20', '6', '12', 1, }, },
[34537]={28426, 2, 450, 460, 475, {28425, 35623, 34664, }, {1, '10', 1, }, },
[36258]={28427, 2, 450, 460, 475, {28426, 20882, }, {1, 1, }, },

		
		[34590] = {28595,14,305,305,345,{23077},{1}},
		[34607] = {28420,2,300,300,310,{23445,21877},{1,1}},
		[34608] = {28421,2,350,350,360,{23446,21877},{1,2}},
		[34955] = {29157,14,180,190,210,{3577,1705,1529,3864},{4,1,1,1}},
		[34959] = {29158,14,200,210,230,{6037,7910,3864},{3,2,2}},
		[34960] = {29159,14,280,290,310,{12800,21752},{2,1}},
		[34961] = {29160,14,290,300,320,{12364,21752},{2,1}},
		[34979] = {29201,2,100,130,160,{2841,3470,2319},{6,2,1}},
		[34981] = {29202,2,200,220,240,{3859,7069,3486,4234},{5,2,2,1}},
		[34982] = {29203,2,300,320,340,{12655,12359,8170},{2,6,1}},
		[34983] = {29204,2,350,360,380,{23448,22451,21884,23793},{6,2,2,1}},
		[35520] = {29483,3,340,350,360,{23793,21886},{4,4}},
		[35521] = {29485,3,340,350,360,{23793,21885},{4,4}},
		[35522] = {29486,3,340,350,360,{23793,21884},{4,4}},
		[35523] = {29487,3,340,350,360,{23793,22456},{4,4}},
		[35524] = {29488,3,340,350,360,{23793,22457},{4,4}},
		[35525] = {29489,3,350,360,380,{23793,25700,22457},{6,12,8}},
		[35526] = {29490,3,350,360,380,{23793,25700,22457},{4,10,6}},
		[35527] = {29491,3,350,360,380,{23793,25700,22457},{4,10,6}},
		[35528] = {29493,3,350,360,380,{23793,25699,21884,21885},{4,8,3,3}},
		[35529] = {29492,3,350,360,380,{23793,25699,21884,21885},{6,12,4,4}},
		[35530] = {29540,3,325,335,345,{23793,22452},{6,4}},
		[35531] = {29494,3,350,360,380,{23793,25699,21884,21885},{4,8,3,3}},
		[35532] = {29495,3,350,360,380,{23793,25708,22457},{6,24,8}},
		[35533] = {29496,3,350,360,380,{23793,25708,22457},{4,16,6}},
		[35534] = {29497,3,350,360,380,{23793,25708,22457},{4,16,6}},
		[35535] = {29498,3,350,360,380,{23793,25707,21884,21885},{6,10,4,4}},
		[35536] = {29499,3,350,360,380,{23793,25707,21884,21885},{4,8,3,3}},
		[35537] = {29500,3,350,360,380,{23793,25707,21884,21885},{4,6,3,3}},
		[35538] = {29532,3,370,370,385,{23793,25707},{6,4}},
		[35539] = {29531,3,350,350,365,{23793,29548},{6,4}},
		[35540] = {29528,3,340,340,355,{23793,25700},{3,3}},
		[35543] = {29529,3,365,365,380,{23793,25708},{6,4}},
		[35544] = {29530,3,345,345,360,{23793,29547},{6,4}},
		[35549] = {29533,3,335,335,355,{23793,29539,22451},{4,2,4}},
		[35554] = {29535,3,365,365,385,{23793,29539,22451,23572},{4,4,8,1}},
		[35555] = {29534,3,335,335,355,{23793,25708,22452},{4,8,4}},
		[35557] = {29536,3,365,365,385,{23793,25708,22452,23572},{4,16,8,1}},
		[35558] = {29502,3,365,375,395,{23793,29539,22451,22456,23572},{6,10,15,15,1}},
		[35559] = {29503,3,365,375,395,{23793,29539,22451,22456,23572},{4,8,12,12,1}},
		[35560] = {29504,3,365,375,395,{23793,29547,22451,22457,23572},{6,20,18,10,1}},
		[35561] = {29505,3,365,375,395,{23793,21886,21885,23572},{6,20,8,1}},
		[35562] = {29506,3,365,375,395,{23793,21886,22452,23572},{4,16,12,1}},
		[35563] = {29507,3,365,375,395,{23793,29547,22452,22451,23572},{4,12,18,8,1}},
		[35564] = {29508,3,365,375,395,{23793,29548,21886,22457,23572},{6,28,12,12,1}},
		[35567] = {29512,3,365,375,395,{23793,29548,22452,22457,23572},{4,24,22,4,1}},
		[35568] = {29509,3,365,375,395,{23793,29547,22451,21884,23572},{4,14,14,10,1}},
		[35572] = {29510,3,365,375,395,{23793,29548,21884,22457,23572},{6,28,18,12,1}},
		[35573] = {29511,3,365,375,395,{23793,29548,21884,22457,23572},{4,24,14,10,1}},
		[35574] = {29514,3,365,375,395,{23793,29548,22452,22451,23572},{8,32,20,8,1}},
		[35575] = {29515,3,375,385,405,{23793,29548,21884,22456,23572},{8,30,16,16,2}},
		[35576] = {29516,3,375,385,405,{23793,29548,21884,22456,23572},{6,24,12,12,1}},
		[35577] = {29517,3,375,385,405,{23793,29548,21884,22456},{4,18,8,8}},
		[35580] = {29519,3,375,385,405,{23793,29548,22457,22451,23572},{8,30,16,16,2}},
		[35582] = {29520,3,375,385,405,{23793,29548,22457,22451,23572},{6,24,12,12,1}},
		[35584] = {29521,3,375,385,405,{23793,29548,22457,22451},{4,18,8,8}},
		[35585] = {29522,3,375,385,405,{23793,29547,22451,23571,23572},{8,20,16,3,2}},
		[35587] = {29524,3,375,385,405,{23793,29547,22451,23571,23572},{6,16,12,2,1}},
		[35588] = {29523,3,375,385,405,{23793,29547,22451,23571},{4,12,8,1}},
		[35589] = {29525,3,375,385,405,{23793,23571,23572},{8,6,2}},
		[35590] = {29526,3,375,385,405,{23793,23571,23572},{6,5,1}},
		[35591] = {29527,3,375,385,405,{23793,23571},{4,3}},
		[35750] = {22573,7,300,300,300,{22452},{1},10},
		[35751] = {22574,7,300,300,300,{21884},{1},10},
		[36074] = {29964,3,260,280,300,{8170,7081,8172,14341},{10,8,2,1}},
		[36075] = {29970,3,260,280,300,{8170,8168,8153,8172,14341},{10,40,4,2,1}},
		[36076] = {29971,3,260,280,300,{8170,8165,7077,8172,14341},{10,10,2,2,1}},
		[36077] = {29973,3,330,350,370,{21887,22451,22452,14341},{20,2,2,2}},
		[36078] = {29974,3,330,350,370,{21887,25699,21886,14341},{20,12,3,2}},
		[36079] = {29975,3,330,350,370,{21887,15416,21884,14341},{20,8,3,2}},
		[36122] = {30069,2,260,280,300,{3860,7075},{16,2}},
		[36124] = {30070,2,260,280,300,{3860,7081},{16,2}},
		[36125] = {30071,2,260,280,300,{3860,7075},{12,4}},
		[36126] = {30072,2,260,280,300,{3860,7081},{12,4}},
		[36128] = {30073,2,260,280,300,{3860,7077},{12,4}},
		[36129] = {30074,2,330,340,360,{23446,22452},{8,4}},
		[36130] = {30076,2,330,340,360,{23446,21885,22451},{8,2,2}},
		[36131] = {30077,2,330,340,360,{23446,22451},{6,6}},
		[36133] = {30086,2,330,340,360,{23446,22452},{10,6}},
		[36134] = {30087,2,330,340,360,{23446,21885,22451},{8,3,3}},
		[36135] = {30088,2,330,340,360,{23446,22451},{10,6}},
		[36136] = {30089,2,330,340,360,{23446,21884},{8,6}},
		[36137] = {30093,2,330,340,360,{23446,22452},{12,6}},
		[36210] = {30155,6,300,320,340,{24477,3713},{2,1}},
		[36256] = {23565,2,375,385,405,{23564,30183},{1,2}},
		[36257] = {28485,2,375,385,405,{28484,20882},{1,1}},
		[36523] = {30419,14,75,105,135,{2841,20817,1206},{4,1,1}},
		[36524] = {30420,14,105,135,165,{1529,20817,3575},{1,1,2}},
		[36525] = {30421,14,230,255,285,{7910,21752},{1,1}},
		[36526] = {30422,14,265,285,305,{12800,21752},{1,1}},
		[36665] = {30459,8,355,365,375,{21840,21884,22456,21881},{10,5,6,2}},
		[36667] = {30460,8,355,365,375,{21840,21887,21884,22456,21881},{6,4,3,4,2}},
		[36668] = {30461,8,355,365,375,{21840,21887,21884,22456,21881},{6,4,2,6,2}},
		[36669] = {30465,8,355,365,375,{21840,21885,21886,21881},{10,5,5,2}},
		[36670] = {30463,8,355,365,375,{21840,21887,21885,21886,21881},{6,4,3,3,2}},
		[36672] = {30464,8,355,365,375,{21840,21887,21885,21886,21881},{4,4,2,2,2}},
		[36686] = {nil,8,350,350,360,{21842,22456,21884},{1,1,1}},
		[36954] = {30542,9,350,350,370,{23784,21884,23826,23783,23786},{1,2,2,4,1}},
		[36955] = {30544,9,350,350,370,{23784,22451,23787,23783,23786},{1,2,2,4,1}},
		[37818] = {30804,14,65,95,125,{2841,20817,774,818,1210},{2,1,3,3,2}},
		[37836] = {30816,6,1,30,40,{30817,2678},{1,1}},
		[37855] = {30825,14,360,370,390,{23447,22457},{2,8}},
		[37873] = {30831,8,350,360,370,{21842,22457,21886,21881},{4,3,3,2}},
		[37882] = {30837,8,350,360,370,{21840,21884,14341},{5,5,2}},
		[37883] = {30838,8,360,370,380,{21840,21884,14341},{7,7,2}},
		[37884] = {30839,8,370,380,390,{21840,21884,14341},{9,9,2}},
		[38068] = {31079,14,325,325,345,{24243,22452},{4,1}},
		[38070] = {31080,4,325,340,355,{22452,21886,22457},{1,1,1}},
		[38175] = {31154,14,80,110,140,{2841,20817,1705},{6,1,1}},
		
		[36392]={30031, 2, 450, 460, 475, {30183, 37663, 36860, 36913, }, {1, '6', '12', '15', }, },
[36390]={30032, 2, 450, 460, 475, {30183, 37663, 36860, 41163, }, {1, '5', '10', '6', }, },
[36391]={30033, 2, 450, 460, 475, {30183, 37663, 35622, 36913, }, {1, '6', '12', '15', }, },
[36389]={30034, 2, 450, 460, 475, {30183, 37663, 35622, 35624, }, {1, '6', '5', '5', }, },
[36315]={30038, 8, 450, 460, 475, {30183, 41511, 41595, 35622, 14341, }, {1, '4', '4', '12', '2', }, },
[36317]={30037, 8, 450, 460, 475, {30183, 24272, 41595, 36860, 14341, }, {1, '4', '4', '10', '2', }, },
[36318]={30035, 8, 450, 460, 475, {30183, 41594, 41595, 35623, 14341, }, {1, '4', '4', '12', '2', }, },
[36316]={30036, 8, 450, 460, 475, {30183, 41511, 35625, 14341, 35622, 41594, }, {1, '4', '10', '2', '10', 1, }, },
[36359]={30043, 3, 450, 460, 475, {30183, 38425, 35622, 44128, 14341, }, {1, '4', '10', '3', '2', }, },
[36353]={30044, 3, 450, 460, 475, {30183, 38425, 35622, 44128, 14341, }, {1, '4', '10', '3', '2', }, },
[36355]={30041, 3, 450, 460, 475, {30183, 38425, 35625, 44128, 14341, }, {1, '4', '12', '3', '2', }, },
[36358]={30045, 3, 450, 460, 475, {30183, 38425, 35623, 44128, 14341, }, {1, '4', '10', '3', '2', }, },
[36357]={30039, 3, 450, 460, 475, {30183, 38425, 35627, 44128, 14341, }, {1, '4', '12', '3', '2', }, },
[36349]={30042, 3, 450, 460, 475, {30183, 38425, 35625, 14341, 35623, }, {1, '4', '10', '2', '10', }, },
[36352]={30046, 3, 450, 460, 475, {30183, 38425, 35623, 44128, 14341, }, {1, '4', '10', '3', '2', }, },
[36351]={30040, 3, 450, 460, 475, {30183, 38425, 35627, 14341, 35623, }, {1, '4', '10', '2', '10', }, },

		
		
		[38473] = {31364,2,375,385,405,{23448,21886,22456,23572},{8,12,12,1}},
		[38475] = {31367,2,375,385,405,{23448,21886,22456,23572},{8,12,12,1}},
		[38476] = {31368,2,375,385,405,{23448,21886,22456,23572},{8,12,12,1}},
		[38477] = {31369,2,375,385,405,{23449,21885,21884,23572},{8,12,12,1}},
		[38478] = {31370,2,375,385,405,{23449,21885,21884,23572},{8,12,12,1}},
		[38479] = {31371,2,375,385,405,{23449,21885,21884,23572},{8,12,12,1}},
		[38503] = {31398,14,375,385,405,{31079,23449,21885,21884},{4,2,6,6}},
		[38504] = {31399,14,375,385,405,{31079,23448,21886,22456},{4,2,6,6}},
		[38867] = {31672,6,335,355,375,{31670},{1}},
		[38868] = {31673,6,335,355,375,{31671},{1}},
		[38960] = {31679,4,335,350,365,{22789,22792,18256},{1,2,1}},
		[38961] = {31677,4,360,375,390,{22793,22792,18256},{1,2,1}},
		[38962] = {31676,4,345,360,375,{22785,22792,18256},{2,3,1}},
		[39451] = {31860,14,325,325,355,{23112},{1}},
		[39452] = {31861,14,350,350,380,{23440},{1}},
		[39455] = {31862,14,325,325,355,{23107},{1}},
		[39458] = {31864,14,325,325,355,{23107},{1}},
		[39462] = {31865,14,350,350,380,{23441},{1}},
		[39463] = {31863,14,350,350,380,{23441},{1}},
		[39466] = {31866,14,325,325,355,{21929},{1}},
		[39467] = {31869,14,325,325,355,{21929},{1}},
		[39470] = {31867,14,350,350,380,{23439},{1}},
		[39471] = {31868,14,350,350,380,{23439},{1}},
		[39636] = {32062,4,310,325,340,{22787,22785,18256},{2,1,1}},
		[39637] = {32063,4,320,335,350,{22786,22787,18256},{1,2,1}},
		[39638] = {32067,4,320,335,350,{22785,22789,18256},{1,1,1}},
		[39639] = {32068,4,330,345,360,{22790,22787,18256},{1,1,1}},
		[39705] = {32193,14,375,375,400,{32227},{1}},
		[39706] = {32194,14,375,375,400,{32227},{1}},
		[39710] = {32195,14,375,375,400,{32227},{1}},
		[39711] = {32196,14,375,375,400,{32227},{1}},
		[39712] = {32197,14,375,375,400,{32227},{1}},
		[39713] = {32198,14,375,375,400,{32227},{1}},
		[39714] = {32199,14,375,375,400,{32227},{1}},
		[39715] = {32200,14,375,375,400,{32228},{1}},
		[39716] = {32201,14,375,375,400,{32228},{1}},
		[39717] = {32202,14,375,375,400,{32228},{1}},
		[39718] = {32203,14,375,375,400,{32228},{1}},
		[39719] = {32204,14,375,375,400,{32229},{1}},
		[39720] = {32205,14,375,375,400,{32229},{1}},
		[39721] = {32206,14,375,375,400,{32229},{1}},
		[39722] = {32207,14,375,375,400,{32229},{1}},
		[39723] = {32208,14,375,375,400,{32229},{1}},
		[39724] = {32209,14,375,375,400,{32229},{1}},
		[39725] = {32210,14,375,375,400,{32229},{1}},
		[39727] = {32211,14,375,375,400,{32230},{1}},
		[39728] = {32212,14,375,375,400,{32230},{1}},
		[39729] = {32213,14,375,375,400,{32230},{1}},
		[39730] = {32214,14,375,375,400,{32230},{1}},
		[39731] = {32215,14,375,375,400,{32230},{1}},
		[39732] = {32216,14,375,375,400,{32230},{1}},
		[39733] = {32217,14,375,375,400,{32231},{1}},
		[39734] = {32218,14,375,375,400,{32231},{1}},
		[39735] = {32219,14,375,375,400,{32231},{1}},
		[39736] = {32220,14,375,375,400,{32231},{1}},
		[39737] = {32221,14,375,375,400,{32231},{1}},
		[39738] = {32222,14,375,375,400,{32231},{1}},
		[39739] = {32223,14,375,375,400,{32249},{1}},
		[39740] = {32224,14,375,375,400,{32249},{1}},
		[39741] = {32225,14,375,375,400,{32249},{1}},
		[39742] = {32226,14,375,375,400,{32249},{1}},
		[39895] = {7191,9,275,275,285,{20816,7078},{3,2}},
		[39961] = {32409,14,365,375,395,{25867},{1}},
		[39963] = {32410,14,365,375,395,{25868},{1}},
		[39971] = {32423,9,335,335,345,{21885,23781,21877},{1,2,2},10},
		[39973] = {32413,9,335,345,365,{32423,23782,23783},{1,1,1},5},
		[39997] = {32398,3,375,385,405,{32428,22450,21886,22456,25700},{2,1,2,4,4}},
		[40000] = {32399,3,375,385,405,{32428,22450,21886,22456,25700},{1,1,2,2,2}},
		[40001] = {32400,3,375,385,405,{32428,22450,21886,22456,25700},{3,1,4,6,3}},
		[40002] = {32397,3,375,385,405,{32428,22450,21886,22456,25700},{2,1,3,4,2}},
		[40003] = {32394,3,375,385,405,{32428,22450,21886,22456,25707},{2,1,2,4,4}},
		[40004] = {32395,3,375,385,405,{32428,22450,21886,22456,25707},{1,1,2,2,2}},
		[40005] = {32396,3,375,385,405,{32428,22450,21886,22456,25707},{3,1,4,6,3}},
		[40006] = {32393,3,375,385,405,{32428,22450,21886,22456,25707},{2,1,3,4,2}},
		[40020] = {32391,8,375,385,395,{32428,22450,21886,22456,21842},{2,1,2,4,1}},
		[40021] = {32392,8,375,385,395,{32428,22450,21886,22456,21842},{1,1,2,2,1}},
		[40023] = {32389,8,375,385,395,{32428,22450,21886,22456,21842},{3,1,4,6,2}},
		[40024] = {32390,8,375,385,395,{32428,22450,21886,22456,21842},{2,1,3,4,1}},
		[40033] = {32402,2,375,385,405,{32428,22450,21886,22456,23446},{2,1,2,4,4}},
		[40034] = {32403,2,375,385,405,{32428,22450,21886,22456,23446},{1,1,2,2,4}},
		[40035] = {32404,2,375,385,405,{32428,22450,21886,22456,23446},{3,1,4,6,12}},
		[40036] = {32401,2,375,385,405,{32428,22450,21886,22456,23446},{2,1,3,4,8}},
		[40060] = {32420,8,375,385,395,{32428,22450,21886,22456,21842},{1,1,2,2,1}},
		[40274] = {32461,9,350,370,390,{23793,23786,23785,23787,23572,23436},{6,1,2,4,1,2}},
		[40514] = {32508,14,340,340,370,{22578,24478,24479},{3,10,1}},
		[41132] = {32568,2,375,385,405,{23448,23573,22451,32428},{14,2,6,4}},
		[41133] = {32570,2,375,385,405,{23448,23573,22451,32428},{18,2,8,2}},
		[41134] = {32571,2,375,385,405,{23449,23573,21884,32428},{14,2,6,4}},
		[41135] = {32573,2,375,385,405,{23449,23573,21884,32428},{18,2,8,2}},
		[41156] = {32582,3,375,385,405,{23793,22451,21886,32428},{4,6,6,4}},
		[41157] = {32583,3,375,385,405,{23793,22451,21886,32428},{6,8,8,2}},
		[41158] = {32580,3,375,385,405,{23793,22451,32428},{4,10,4}},
		[41160] = {32581,3,375,385,405,{23793,22451,32428},{6,12,2}},
		[41161] = {32574,3,375,385,405,{23793,22451,21885,29547,32428},{4,4,4,12,4}},
		[41162] = {32575,3,375,385,405,{23793,22451,21885,29547,32428},{6,6,6,16,2}},
		[41163] = {32577,3,375,385,405,{23793,22451,22452,29547,32428},{4,4,4,12,4}},
		[41164] = {32579,3,375,385,405,{23793,22451,22452,29547,32428},{6,6,6,16,2}},
		[41205] = {32586,8,375,385,395,{21842,24271,22457,32428},{3,4,8,4}},
		[41206] = {32587,8,375,385,395,{21842,24271,22457,32428},{4,2,6,2}},
		[41207] = {32584,8,375,385,395,{21842,21845,21886,32428},{3,4,8,4}},
		[41208] = {32585,8,375,385,395,{21842,21845,21886,32428},{4,2,6,2}},
		[41307] = {32756,9,375,375,410,{23785,23449,23787,21884,22451,23572},{1,20,4,12,12,1}},
		[41311] = {32472,9,350,370,390,{23793,23786,23785,23787,23572,23440},{6,1,2,4,1,2}},
		[41312] = {32473,9,350,370,390,{23793,23786,23785,23787,23572,23437},{6,1,2,4,1,2}},
		[41314] = {32474,9,350,370,390,{23793,23786,23785,23787,23572,23441},{6,1,2,4,1,2}},
		[41315] = {32476,9,350,370,390,{23793,23786,23785,23787,23572,23436},{6,1,2,4,1,2}},
		[41316] = {32475,9,350,370,390,{23793,23786,23785,23787,23572,23439},{6,1,2,4,1,2}},
		[41317] = {32478,9,350,370,390,{23793,23786,23785,23787,23572,23436},{6,1,2,4,1,2}},
		[41318] = {32479,9,350,370,390,{23793,23786,23785,23787,23572,23440},{6,1,2,4,1,2}},
		[41319] = {32480,9,350,370,390,{23793,23786,23785,23787,23572,23437},{6,1,2,4,1,2}},
		[41320] = {32494,9,350,370,390,{23793,23786,23785,23787,23572,23438},{6,1,2,4,1,2}},
		[41321] = {32495,9,350,370,390,{23793,23786,23785,23787,23572,23439},{6,1,2,4,1,2}},
		[41414] = {32772,14,325,335,355,{24478,23447},{8,2}},
		[41415] = {32774,14,330,340,360,{24479,31079},{1,4}},
		[41418] = {32776,14,365,375,395,{23449,31079,24478,24479},{12,4,20,3}},
		[41420] = {32833,14,325,325,340,{24478,27860},{1,1}},
		[41429] = {32836,14,350,350,380,{24479,27860},{1,1}},
		[41458] = {32839,4,360,360,380,{22457,22793,23782},{2,7,1}},
		[41500] = {32849,4,360,360,380,{21884,22793,23782},{2,7,1}},
		[41501] = {32850,4,360,360,380,{21885,22793,23782},{2,7,1}},
		[41502] = {32851,4,360,360,380,{21886,22793,23782},{2,7,1}},
		[41503] = {32852,4,360,360,380,{22456,22793,23782},{2,7,1}},
		[42296] = {33048,6,335,335,355,{27422,2593,3713},{1,1,1}},
		[42302] = {33052,6,375,375,385,{27515,4539,3713},{1,5,5},6},
		[42305] = {33053,6,375,375,385,{27516,3713},{1,2},2},
		[42546] = {33122,3,360,370,390,{23793,21844,22456,23572},{8,12,12,4}},
		[42558] = {33133,14,360,365,375,{23436},{1}},
		[42588] = {33134,14,360,365,375,{23436},{1}},
		[42589] = {33131,14,360,365,375,{23436},{1}},
		[42590] = {33135,14,360,365,375,{23438},{1}},
		[42591] = {33143,14,360,365,375,{23440},{1}},
		[42592] = {33140,14,360,365,375,{23440},{1}},
		[42593] = {33144,14,360,365,375,{23440},{1}},
		[42613] = {22448,10,300,295,305,{20725},{1}},
		[42615] = {22448,10,335,315,335,{22449},{1},3},
		[42620] = {nil,10,350,360,375,{22445,22446,22449,22451},{8,4,6,2}},
		[42662] = {33173,2,365,375,395,{23445,21884,23449,27503},{12,2,8,2}},
		[42688] = {33185,2,335,345,355,{23573,23449},{2,1}},
		[42731] = {33204,3,365,375,395,{23793,21844,22452,22456,23572},{10,16,12,12,2}},
		[42736] = {33208,4,375,390,405,{22786,22791,22794,18256},{7,3,1,1},2},
		[42974] = {nil,10,375,385,415,{22450,22449,22446,22445,22824},{6,10,6,30,3}},
		[43493] = {33782,14,350,350,380,{23437},{1}},
		[43549] = {33791,2,35,75,115,{2840,818,3470},{10,1,2}},
		[43676] = {20475,9,335,335,355,{23446,4470,23783},{1,4,2}},
		[43707] = {33825,6,325,335,355,{33824},{1}},
		[43758] = {33866,6,300,320,340,{27678,13757},{1,1}},
		[43761] = {33867,6,300,320,340,{33823},{1}},
		[43765] = {33872,6,325,335,355,{27682,2692},{1,1}},
		[43772] = {33874,6,300,345,365,{27671},{1}},
		[43779] = {33924,6,1,50,75,{30817,1179,2678,6889,2593,785},{8,4,4,8,1,3}},
		[43846] = {32854,2,365,375,395,{23449,23448,23571,23572},{16,12,6,2}},
		[44155] = {34060,9,350,375,385,{23784,23445,23783,11291,23446,23819},{2,30,8,8,5,4}},
		[44157] = {34061,9,375,385,395,{34060,23786,23787,34249},{1,8,8,1}},
		[44343] = {34099,3,315,325,345,{21887,14341,22451},{24,4,1}},
		[44344] = {34100,3,315,325,345,{21887,25719,14341},{20,30,2}},
		[44359] = {34105,3,350,360,380,{23793,17056,22451,23572},{8,99,2,1}},
		[44383] = {nil,10,330,340,370,{22449,22447},{1,4}},
		[44391] = {34113,9,360,370,390,{23446,23783,23786},{8,8,1},5},
		[44768] = {34106,3,350,360,380,{23793,29548,22452,23572},{12,12,4,1}},
		[44770] = {34207,3,350,355,365,{23793,22452},{4,3}},
		[44794] = {34220,14,365,375,395,{25868},{1}},
		[44950] = {34087,8,250,250,250,{14048,2997,2605,14341},{4,1,2,1}},
		[44953] = {34086,3,285,285,285,{2840,2997,8170,14341},{1,1,4,1}},
		[44958] = {34085,8,250,250,250,{14048,2997,2604,14341},{4,1,2,1}},
		[44970] = {34330,3,350,355,365,{23793},{3}},
		[45022] = {34411,6,325,325,325,{34412,17196,17194},{1,1,1},2},
		[45061] = {34440,4,325,335,350,{8925,22787},{1,2}},
		[45100] = {34482,3,300,310,330,{21887,25700,25707,14341},{20,4,4,3}},
		[45117] = {34490,3,360,370,390,{23793,29547,25707,29548,25708,14341},{15,5,5,5,5,3}},
		[45695] = {34832,6,100,100,110,{2596,2594},{1,1},5},
		[45765] = {22449,10,375,360,365,{22450},{1},2},
		[46106] = {35183,9,375,390,430,{32479,21885,22457,23572},{1,4,8,4}},
		[46107] = {35185,9,375,390,430,{32472,21886,22457,22452,23572},{1,8,8,8,4}},
		[46108] = {35181,9,375,390,430,{32495,21886,22457,23572},{1,8,8,4}},
		[46109] = {35182,9,375,390,430,{32480,21885,21886,23572},{1,6,12,4}},
		[46110] = {35184,9,375,390,430,{32475,21886,22457,21885,23572},{1,5,5,5,4}},
		[46111] = {34847,9,375,390,430,{32494,22456,21884,22457,23572},{1,4,4,4,4}},
		[46112] = {34355,9,375,390,430,{32476,23571,22451,23572},{1,2,2,4}},
		[46113] = {34356,9,375,390,430,{32474,22451,23572},{1,12,4}},
		[46114] = {34354,9,375,390,430,{32461,21884,23572},{1,10,4}},
		[46115] = {34357,9,375,390,430,{32473,35128,23571,23572},{1,2,1,4}},
		[46116] = {34353,9,375,390,430,{32478,22456,23572},{1,12,4}},
		[46122] = {34362,14,365,375,410,{35128,23571,31079,34664},{4,4,12,5}},
		[46123] = {34363,14,365,375,410,{35128,21886,31079,34664},{4,20,12,5}},
		[46124] = {34361,14,365,375,410,{35128,22451,31079,34664},{4,20,12,5}},
		[46125] = {34359,14,365,375,410,{31079,32227,32228},{12,3,3}},
		[46126] = {34360,14,365,375,410,{31079,32249},{6,6}},
		[46127] = {34358,14,365,375,410,{35128,23572},{6,9}},
		[46128] = {34366,8,365,375,410,{24271,24272,34664},{10,10,6}},
		[46129] = {34367,8,365,375,410,{21845,21886,21885,34664},{18,12,12,6}},
		[46130] = {34364,8,365,375,410,{24271,24272,23572},{12,12,2}},
		[46131] = {34365,8,365,375,410,{21845,23572},{20,2}},
		[46132] = {34372,3,365,375,410,{23793,25708,21886,23571,34664},{30,16,18,8,6}},
		[46133] = {34374,3,365,375,410,{23793,29547,22451,23571,34664},{30,16,18,8,6}},
		[46134] = {34370,3,365,375,410,{23793,25707,22456,23571,34664},{30,16,18,8,6}},
		[46135] = {34376,3,365,375,410,{23793,29548,21886,23571,34664},{30,16,18,8,6}},
		[46136] = {34371,3,365,375,410,{23793,25708,23571,23572},{40,24,6,6}},
		[46137] = {34373,3,365,375,410,{23793,29547,23571,23572},{40,24,6,6}},
		[46138] = {34369,3,365,375,410,{23793,25707,23571,23572},{40,24,6,6}},
		[46139] = {34375,3,365,375,410,{23793,29548,23571,23572},{40,24,6,6}},
		[46140] = {34380,2,365,375,410,{35128,21886,23571,34664},{8,20,6,6}},
		[46141] = {34378,2,365,375,410,{35128,21884,22456,22451,34664},{10,12,12,12,6}},
		[46142] = {34379,2,365,375,410,{23449,23573,21886,21885,23572},{20,4,15,15,6}},
		[46144] = {34377,2,365,375,410,{23449,23573,21884,22456,23572},{20,4,10,10,6}},
		[46353] = {35128,7,375,375,375,{23449,23573},{3,1}},
		[46403] = {35315,14,350,350,380,{23440},{1}},
		[46404] = {35316,14,350,350,380,{23439},{1}},
		[46405] = {35318,14,350,350,380,{23437},{1}},
		[46578] = {nil,10,350,350,365,{22456,21885},{2,2}},
		[46594] = {nil,10,360,370,400,{22446,22445,23427},{4,8,4}},
		[46597] = {35501,14,370,380,400,{25867},{1}},
		[46601] = {35503,14,370,380,400,{25868},{1}},
		[46684] = {35563,6,250,275,295,{35562},{1}},
		[46688] = {35565,6,250,275,295,{35562},{1}},
		[46697] = {35581,9,355,365,385,{21840,23786,23785,23787},{8,2,2,4}},
		[46775] = {35693,14,375,375,400,{23449,32228,23440},{8,2,6}},
		[46776] = {35694,14,375,375,400,{23449,32231,22452},{8,2,8}},
		[46777] = {35700,14,375,375,400,{23447,32227,21884},{8,2,8}},
		[46778] = {35702,14,375,375,400,{23573,32230,22456},{4,2,8}},
		[46779] = {35703,14,375,375,400,{23447,32249,22457},{8,2,8}},
		[46803] = {35707,14,350,350,380,{23441},{1}},
		[47046] = {35748,4,375,390,405,{13503,22451,30183},{1,6,2}},
		[47048] = {35749,4,375,390,405,{13503,21884,30183},{1,6,2}},
		[47049] = {35750,4,375,390,405,{13503,21886,30183},{1,6,2}},
		[47050] = {35751,4,375,390,405,{13503,22456,30183},{1,6,2}},
		[47051] = {nil,10,375,380,410,{22446,22452},{8,8}},
		[47053] = {35759,14,375,375,400,{32249},{1}},
		[47054] = {35758,14,375,375,400,{32249},{1}},
		[47055] = {35760,14,375,375,400,{32231},{1}},
		[47056] = {35761,14,375,375,400,{32229},{1}},
		[47280] = {191061,14,350,350,380,{23117,23077,23079,21929,23112,23107},{3,3,3,3,3,3}},
		[48789] = {37503,14,375,375,400,{32230},{1}},
		[49677] = {6836,8,250,255,285,{4339,4304},{4,2}},
		[50194] = {38225,8,375,385,395,{21845,22794},{4,2}},
		[50644] = {38277,8,250,265,295,{4339,2325,2604,8343},{5,2,1,3}},
		[50647] = {38278,8,245,250,260,{4339,8343,2325},{4,3,3}},
		[351766] = {185852,3,375,340,355,{23793,25700},{3,3}},
		[351768] = {185851,3,345,345,360,{23793,29547},{6,4}},
		[351769] = {185850,3,350,350,365,{23793,29548},{6,4}},
		[351770] = {185849,3,370,370,385,{23793,25707},{6,4}},
		[351771] = {185848,3,365,365,380,{23793,25708},{6,4}},
    }
	-- fix
	PROFESSION[36686][1] = 24272
	PROFESSION[31373][1] = 24271
	PROFESSION[26751][1] = 21845
end

if AtlasLoot:GameVersion_GE(AtlasLoot.WRATH_VERSION_NUM) then
    PROFESSION_DATA.WRATH = {
		[2166] = {2314,3,125,145,170,{2319,4231,2321},{10,6,2}},
		[2543] = {733,6,50,115,155,{729,730,731},{1,1,1},5},
		[2548] = {2685,6,110,130,170,{2677},{2}},
		[3397] = {3726,6,110,150,190,{3730},{1}},
		[3497] = {3854,2,200,225,250,{3859,1529,3829},{12,2,2}},
		[3500] = {3856,2,200,225,250,{3859,3864,3824},{10,2,2}},
		[3765] = {4248,3,120,155,180,{2319,5373,2321,4340},{8,2,1,1}},
		[3778] = {4262,3,185,205,225,{4236,5500,1529,3864,2321},{4,1,1,1,1}},
		[3865] = {4339,8,175,180,185,{4338},{4}},
		[3969] = {4396,9,200,220,240,{4382,4387,4389,3864},{1,2,2,1}},
		[6417] = {5478,6,90,130,170,{5051},{1},2},
		[7418] = {38679,10,70,70,110,{10940},{1}},
		[7420] = {38766,10,15,70,110,{10940},{1}},
		[7426] = {38767,10,40,90,130,{10940,10938},{2,1}},
		[7428] = {38768,10,80,80,120,{10938,10940},{1,1}},
		[7443] = {38769,10,20,80,120,{10938},{1}},
		[7454] = {38770,10,45,95,135,{10940,10938},{1,2}},
		[7457] = {38771,10,50,100,140,{10940},{3}},
		[7745] = {38772,10,100,130,170,{10940,10978},{4,1}},
		[7748] = {38773,10,60,105,145,{10940,10938},{2,2}},
		[7766] = {38774,10,60,105,145,{10938},{2}},
		[7771] = {38775,10,90,110,150,{10940,10939},{3,1}},
		[7776] = {38776,10,80,115,155,{10939,10938},{1,1}},
		[7779] = {38777,10,80,115,155,{10940,10939},{2,1}},
		[7782] = {38778,10,80,115,155,{10940},{5}},
		[7786] = {38779,10,90,120,160,{10940,10939},{4,2}},
		[7788] = {38780,10,90,120,160,{10940,10939,10978},{2,1,1}},
		[7793] = {38781,10,100,130,170,{10939},{3}},
		[7857] = {38782,10,120,145,185,{10940,10998},{4,1}},
		[7859] = {38783,10,120,145,185,{10998},{2}},
		[7861] = {38784,10,125,150,190,{6371,10998},{1,1}},
		[7863] = {38785,10,125,150,190,{10940},{8}},
		[7867] = {38786,10,425,150,190,{10940,10998},{6,2}},
		[9145] = {7348,3,125,150,175,{2319,4233,2321},{8,4,2}},
		[9207] = {7390,3,200,220,240,{4234,10285,4291},{8,2,2}},
		[9935] = {7922,2,215,235,255,{3859,3864,7966},{14,1,1}},
		[10098] = {6037,7,230,250,290,{7911},{1}},
		[10621] = {8345,3,225,245,265,{4304,8153,8172,8343},{18,12,4,1}},
		[10630] = {8346,3,230,250,270,{4304,7079,8172,8343},{20,4,1,4}},
		[10632] = {8348,3,250,270,290,{4304,7077,8172,8343},{30,8,2,4}},
		[10647] = {8349,3,250,270,290,{4304,17056,7971,8172,8343},{25,20,2,4,4}},
		[12088] = {10044,8,245,260,290,{4339,8343},{5,3}},
		[12624] = {10576,9,250,270,290,{3860,7077,6037,7910},{4,2,4,1}},
		[12716] = {10577,9,205,225,245,{10559,3860,10505,10558,7068},{2,4,5,1,1}},
		[13378] = {38787,10,105,130,170,{10998,10940},{1,2}},
		[13380] = {38788,10,110,135,175,{10998,10940},{1,6}},
		[13419] = {38789,10,110,135,175,{10998},{1}},
		[13421] = {38790,10,115,140,180,{10940,10978},{6,1}},
		[13464] = {38791,10,115,140,180,{10998,10940,10978},{1,1,1}},
		[13485] = {38792,10,130,155,195,{10998,10940},{2,4}},
		[13501] = {38793,10,130,155,195,{11083},{2}},
		[13503] = {38794,10,140,165,205,{11083,11084},{2,1}},
		[13522] = {38795,10,135,160,200,{11082,6048},{1,1}},
		[13529] = {38796,10,145,170,210,{11083,11084},{3,1}},
		[13536] = {38797,10,140,165,205,{11083},{2}},
		[13538] = {38798,10,140,165,205,{10940,11082,11084},{2,1,1}},
		[13607] = {38799,10,145,170,210,{11082,10998},{1,2}},
		[13612] = {38800,10,145,170,210,{11083,2772},{1,3}},
		[13617] = {38801,10,145,170,210,{11083,3356},{1,3}},
		[13620] = {38802,10,145,170,210,{11083,6370},{1,3}},
		[13622] = {38803,10,150,175,215,{11082},{2}},
		[13626] = {38804,10,150,175,215,{11082,11083,11084},{1,1,1}},
		[13631] = {38805,10,155,175,215,{11134,11083},{1,1}},
		[13635] = {38806,10,155,175,215,{11138,11083},{1,3}},
		[13637] = {38807,10,160,180,220,{11083,11134},{1,1}},
		[13640] = {38808,10,160,180,220,{11083},{3}},
		[13642] = {38809,10,165,185,225,{11134},{1}},
		[13644] = {38810,10,170,190,230,{11083},{4}},
		[13646] = {38811,10,170,190,230,{11134,11083},{1,2}},
		[13648] = {38812,10,170,190,230,{11083},{6}},
		[13653] = {38813,10,175,195,235,{11134,5637,11138},{1,2,1}},
		[13655] = {38814,10,175,195,235,{11134,7067,11138},{1,1,1}},
		[13657] = {38815,10,175,195,235,{11134,7068},{1,1}},
		[13659] = {38816,10,180,200,240,{11135,11137},{1,1}},
		[13661] = {38817,10,180,200,240,{11137},{1}},
		[13663] = {38818,10,185,205,245,{11135},{1}},
		[13687] = {38819,10,190,210,250,{11135,11134},{1,2}},
		[13689] = {38820,10,195,215,255,{11135,11137,11139},{2,2,1}},
		[13693] = {38821,10,195,215,255,{11135,11139},{2,1}},
		[13695] = {38822,10,200,220,260,{11137,11139},{4,1}},
		[13698] = {38823,10,200,220,260,{11137,7392},{1,3}},
		[13700] = {38824,10,200,220,260,{11135,11137,11139},{2,2,1}},
		[13746] = {38825,10,205,225,265,{11137},{3}},
		[13794] = {38826,10,205,225,265,{11174},{1}},
		[13815] = {38827,10,210,230,270,{11174,11137},{1,1}},
		[13817] = {38828,10,210,230,270,{11137},{5}},
		[13822] = {38829,10,210,230,270,{11174},{2}},
		[13836] = {38830,10,215,235,275,{11137},{5}},
		[13841] = {38831,10,215,235,275,{11137,6037},{3,3}},
		[13846] = {38832,10,220,240,280,{11174,11137},{3,1}},
		[13858] = {38833,10,220,240,280,{11137},{6}},
		[13868] = {38834,10,225,245,285,{11137,8838},{3,3}},
		[13882] = {38835,10,225,245,285,{11174},{2}},
		[13887] = {38836,10,225,245,285,{11174,11137},{2,3}},
		[13890] = {38837,10,225,245,285,{11177,7909,11174},{1,1,1}},
		[13898] = {38838,10,265,285,325,{11177,7078},{4,1}},
		[13905] = {38839,10,230,250,290,{11175,11176},{1,2}},
		[13915] = {38840,10,230,250,290,{11177,11176,9224},{1,2,1}},
		[13917] = {38841,10,230,250,290,{11175,11174},{1,2}},
		[13931] = {38842,10,235,255,295,{11175,11176},{1,2}},
		[13933] = {38843,10,235,255,295,{11178,3829},{1,1}},
		[13935] = {38844,10,235,255,295,{11175},{2}},
		[13937] = {38845,10,240,260,300,{11178,11176},{2,2}},
		[13939] = {38846,10,240,260,300,{11176,11175},{2,1}},
		[13941] = {38847,10,245,265,305,{11178,11176,11175},{1,3,2}},
		[13943] = {38848,10,245,265,305,{11178,11175},{2,2}},
		[13945] = {38849,10,245,265,305,{11176},{5}},
		[13947] = {38850,10,250,270,310,{11178,11176},{2,3}},
		[13948] = {38851,10,250,270,310,{11178,8153},{2,2}},
		[15596] = {11811,10,265,285,325,{7078,14343},{3,3}},
		[15856] = {13851,6,175,215,255,{12203},{1}},
		[16153] = {12359,7,230,250,290,{10620},{1}},
		[16643] = {12406,2,250,270,290,{12359},{8}},
		[16644] = {12408,2,255,275,295,{12359},{8}},
		[16652] = {12409,2,280,300,320,{12359,8170},{12,8}},
		[16653] = {12410,2,280,300,320,{12359,7910},{12,1}},
		[16662] = {12414,2,300,320,340,{12359},{12}},
		[16728] = {12636,2,300,320,340,{12359,12655,12799,12364},{40,4,6,2}},
		[16729] = {12640,2,300,320,340,{12359,12360,12361,12800},{80,12,10,4}},
		[16960] = {12764,2,260,285,310,{12359,12644,8170},{10,2,4}},
		[16969] = {12773,2,275,300,325,{12359,12799,12644,8170},{10,2,2,4}},
		[16971] = {12775,2,280,305,330,{12359,12644,8170},{12,6,6}},
		[17557] = {13453,4,275,290,330,{8846,13466,8925},{2,2,1}},
		[17634] = {13506,4,300,315,330,{13423,8925},{7,1},2},
		[17635] = {13510,4,300,315,330,{8846,13423,13468,8925},{7,3,1,1},2},
		[17636] = {13511,4,300,315,330,{13463,13467,13468,8925},{7,3,1,1},2},
		[17637] = {13512,4,300,315,330,{13463,13465,13468,8925},{7,3,1,1},2},
		[17638] = {13513,4,300,315,330,{13467,13465,13468,8925},{7,3,1,1},2},
		[18401] = {14048,8,250,255,260,{14047},{4}},
		[18403] = {13869,8,255,270,300,{14048,6260,14341},{5,2,1}},
		[18410] = {14143,8,265,280,310,{14048,9210},{2,2}},
		[18411] = {13870,8,265,280,310,{14048,6260,14341},{5,2,1}},
		[18413] = {14142,8,270,285,315,{14048,9210},{2,2}},
		[18414] = {14100,8,270,285,315,{14048,3577},{4,2}},
		[18416] = {14141,8,275,290,320,{14048,9210},{2,3}},
		[18417] = {13863,8,275,290,320,{14048,14341},{5,2}},
		[18421] = {14132,8,275,290,320,{14048,11176,14341},{4,1,1}},
		[18423] = {13864,8,280,295,325,{14048,8170,14341},{4,2,1}},
		[18424] = {13871,8,280,295,325,{14048,6260,14341},{6,2,1}},
		[18437] = {14108,8,285,300,330,{14048,14256,8170,14341},{2,2,2,1}},
		[18438] = {13865,8,285,300,330,{14048,14227,14341},{5,2,1}},
		[18441] = {14144,8,290,305,335,{14048,9210},{3,4}},
		[18442] = {14111,8,290,305,335,{14048,14256,14341},{2,2,1}},
		[18444] = {13866,8,295,310,340,{14048,14341},{6,2}},
		[19053] = {15074,3,265,285,305,{8170,12803,14341},{6,1,1}},
		[19058] = {15564,3,250,255,275,{8170},{5}},
		[19062] = {15067,3,270,290,310,{8170,17056,1529,14341},{24,40,2,1}},
		[19063] = {15073,3,275,295,315,{8170,12803,14341},{4,1,1}},
		[19065] = {15092,3,275,295,315,{8170,7971,14341},{6,1,1}},
		[19066] = {15071,3,275,295,315,{8170,7080,14341},{4,1,1}},
		[19067] = {15057,3,275,295,315,{8170,7082,14341},{16,2,1}},
		[19072] = {15093,3,280,300,320,{8170,14047,14341},{10,10,1}},
		[19073] = {15072,3,280,300,320,{8170,12803,14341},{8,1,1}},
		[19074] = {15069,3,285,305,325,{8170,7080,14341},{6,1,1}},
		[19079] = {15056,3,285,305,325,{8170,7082,15407,14341},{16,3,1,1}},
		[19081] = {15075,3,290,310,330,{8170,12803,14341},{10,1,1}},
		[19083] = {15087,3,290,310,330,{8170,15407,2325,14341},{12,1,3,1}},
		[19085] = {15050,3,290,310,330,{8170,15416,15407,14341},{25,25,1,2}},
		[19086] = {15066,3,290,310,330,{8170,17056,1529,15407,14341},{35,40,1,1,1}},
		[19087] = {15070,3,295,315,335,{8170,7080,14341},{6,1,1}},
		[19090] = {15058,3,295,315,335,{8170,7082,14227},{12,3,2}},
		[19094] = {15051,3,300,320,340,{8170,15416,15407,14341},{20,15,1,1}},
		[19104] = {15068,3,300,320,340,{8170,7080,15407,14341},{12,1,1,2}},
		[19107] = {15052,3,300,320,340,{8170,15416,15407,14341},{25,25,1,2}},
		[19567] = {15846,9,250,270,290,{10561,12359,10558},{1,6,3}},
		[19830] = {16022,9,300,320,340,{10576,16006},{1,4}},
		[20008] = {38852,10,255,275,315,{16202},{3}},
		[20009] = {38853,10,270,290,330,{16202,11176},{3,4}},
		[20010] = {38854,10,295,310,340,{16204,16203},{6,2}},
		[20011] = {38855,10,300,310,340,{16204},{10}},
		[20012] = {38856,10,270,290,330,{16202,16204},{2,3}},
		[20013] = {38857,10,295,310,340,{16202,16204},{4,4}},
		[20014] = {38858,10,265,285,325,{7077,7075,7079,7081,7972},{1,1,1,1,1}},
		[20015] = {38859,10,285,300,335,{16204},{8}},
		[20016] = {38860,10,280,300,340,{16203,16204},{1,4}},
		[20017] = {38861,10,265,285,325,{11176},{5}},
		[20020] = {38862,10,260,280,320,{11176},{5}},
		[20023] = {38863,10,295,310,340,{16202,8153},{2,2}},
		[20024] = {38864,10,275,295,335,{16203},{2}},
		[20025] = {38865,10,300,310,340,{14344,16204},{2,6}},
		[20026] = {38866,10,275,295,335,{14343},{2}},
		[20028] = {38867,10,290,305,340,{16204},{8}},
		[20029] = {38868,10,285,300,335,{14343,7080,7082,13467},{4,1,1,1}},
		[20030] = {38869,10,295,310,340,{14344,16204},{4,10}},
		[20031] = {38870,10,300,310,340,{14344,16203},{2,4}},
		[20032] = {38871,10,300,310,340,{14344,12808,12803},{4,4,4}},
		[20033] = {38872,10,295,310,340,{14344,12808},{4,4}},
		[20034] = {38873,10,300,310,340,{14344,12811},{4,2}},
		[20035] = {38874,10,300,310,340,{16203,14344},{4,2}},
		[20036] = {38875,10,300,310,340,{16203,14344},{4,2}},
		[20854] = {16983,3,300,320,340,{17012,17010,17011,14341},{12,3,3,2}},
		[20855] = {16984,3,300,320,340,{15416,17010,17011,14341},{18,3,3,2}},
		[21931] = {38876,10,190,210,250,{11135,11137,11139,3819},{3,3,1,2}},
		[22711] = {18238,3,200,210,230,{4304,10285,4236,8343},{6,8,4,1}},
		[22749] = {38877,10,300,310,340,{14344,16203,13926},{4,6,2}},
		[22750] = {38878,10,300,310,340,{14344,16203,7080},{4,4,4}},
		[22923] = {18508,3,300,320,340,{8170,18512,15407,14341},{12,8,4,4}},
		[22926] = {18509,3,300,320,340,{8170,12607,15416,15414,14341},{25,4,12,12,2}},
		[22927] = {18510,3,300,320,340,{8170,18512,15407,14341},{30,5,2,2}},
		[22928] = {18511,3,300,320,340,{12810,12753,14341},{10,2,1}},
		[22967] = {17771,7,300,350,375,{18562,12360,17010,18567},{1,10,1,3}},
		[23096] = {18645,9,265,275,285,{12359,7191},{4,1},2},
		[23703] = {19044,3,290,310,330,{8170,12803,15407,14341},{30,4,2,2}},
		[23707] = {19149,3,300,320,340,{17011,17012,14227},{2,2,4}},
		[23708] = {19157,3,300,320,340,{17010,17011,17012,14227},{3,2,8,4}},
		[23709] = {19162,3,300,320,340,{17010,17012,8170,14227},{4,12,12,4}},
		[23710] = {19163,3,300,320,340,{17010,17011,17012,14227},{2,2,2,4}},
		[23799] = {38879,10,290,305,340,{14344,7076},{4,4}},
		[23800] = {38880,10,290,305,340,{14344,7082},{4,4}},
		[23801] = {38881,10,290,305,340,{16204,16202,7080},{4,4,2}},
		[23802] = {38882,10,300,310,340,{14344,16204,16202},{2,4,4}},
		[23803] = {38883,10,300,310,340,{14344,16203,16204},{6,4,12}},
		[23804] = {38884,10,300,310,340,{14344,16203,16204},{6,5,20}},
		[24091] = {19682,8,300,315,345,{14342,19726,12804,14227},{3,3,3,2}},
		[24092] = {19683,8,300,315,345,{14342,19726,12804,14227},{4,4,4,2}},
		[24093] = {19684,8,300,315,345,{14342,19726,14227},{4,4,2}},
		[24124] = {19688,3,300,320,340,{19768,15407,14341},{25,3,3}},
		[24125] = {19689,3,300,320,340,{19768,15407,14341},{25,3,3}},
		[24136] = {19690,2,300,320,340,{12359,19774,7910},{20,10,2}},
		[24137] = {19691,2,300,320,340,{12359,19774,7910},{16,8,1}},
		[24138] = {19692,2,300,320,340,{12359,19774,12810},{12,6,4}},
		[24356] = {19999,9,300,320,340,{19726,7910,12804,12810},{4,2,6,4}},
		[24357] = {19998,9,300,320,340,{19726,12800,12804},{6,1,6}},
		[24703] = {20380,3,300,320,340,{8170,20381,12803,14341},{20,3,3,2}},
		[25072] = {38885,10,300,310,340,{22448,22446,21886},{4,2,8}},
		[25073] = {38886,10,300,310,340,{22448,14344,12808},{3,10,6}},
		[25074] = {38887,10,300,310,340,{22448,14344,7080},{3,10,4}},
		[25078] = {38888,10,300,310,340,{22448,14344,7078},{2,10,4}},
		[25079] = {38889,10,300,310,340,{22448,14344,12811},{3,8,1}},
		[25080] = {38890,10,300,310,340,{22448,22446,22451},{3,3,2}},
		[25081] = {38891,10,300,310,340,{22448,22446,7078},{3,3,4}},
		[25082] = {38892,10,300,310,340,{22448,22446,12803},{2,3,4}},
		[25083] = {38893,10,300,310,340,{22448,22446,22794},{3,3,2}},
		[25084] = {38894,10,300,310,340,{22448,22446,22456},{4,2,8}},
		[25086] = {38895,10,300,310,340,{22448,22446,22452},{3,3,8}},
		[25621] = {20961,14,180,210,240,{3864,3860},{1,2}},
		[25659] = {21023,6,300,325,350,{9061,8150,21024},{1,1,1},5},
		[26087] = {21342,8,300,315,345,{14256,17012,7078,14227},{20,16,4,4}},
		[26279] = {21278,3,300,320,340,{12810,7082,14227},{6,4,2}},
		[26403] = {21154,8,250,265,295,{14048,4625,2604,14341},{4,2,2,1}},
		[26407] = {21542,8,250,265,295,{14048,4625,2604,14341},{4,2,2,1}},
		[26442] = {21569,9,225,245,265,{9060,9061,10560,10561},{1,1,1,1}},
		[26443] = {21570,9,275,295,315,{10561,9061},{1,1},2},
		[26745] = {21840,8,300,305,325,{21877},{5}},
		[26781] = {21865,8,375,380,385,{21844,14341},{8,4}},
		[27032] = {21990,1,330,330,365,{21877},{1}},
		[27033] = {21991,1,360,360,375,{21877},{2}},
		[27837] = {38896,10,290,305,340,{14344,7082},{8,4}},
		[27899] = {38897,10,305,315,345,{22445},{6}},
		[27905] = {38898,10,315,325,355,{22445,22447},{6,6}},
		[27906] = {38899,10,320,330,360,{22448,22445},{2,10}},
		[27911] = {38900,10,325,335,365,{22446,21886},{4,4}},
		[27913] = {38901,10,335,345,375,{22446},{8}},
		[27914] = {38902,10,350,370,380,{22449,22446,22445},{1,10,20}},
		[27917] = {38903,10,360,370,400,{22449,21884,21885},{6,6,6}},
		[27920] = {nil,10,360,370,385,{22449,22445},{2,6}},
		[27924] = {nil,10,360,370,385,{22449,22446},{2,2}},
		[27926] = {nil,10,370,380,390,{22449,22446,22445},{2,3,5}},
		[27927] = {nil,10,375,380,390,{22450,22449},{2,2}},
		[27944] = {38904,10,310,320,350,{22445,22452},{6,10}},
		[27945] = {38905,10,325,335,365,{22446},{4}},
		[27946] = {38906,10,340,350,380,{22445,22446,22452},{12,4,10}},
		[27947] = {38907,10,360,370,385,{22449,22573,22574,22572,22578},{2,1,1,1,1}},
		[27948] = {38908,10,305,315,345,{22445,13446,13444},{6,4,4}},
		[27950] = {38909,10,320,330,360,{22445},{12}},
		[27951] = {37603,10,340,350,380,{22446,22445},{8,8}},
		[27954] = {38910,10,370,380,390,{22450,22449},{2,4}},
		[27957] = {38911,10,315,325,355,{22445,13446,14344},{8,4,2}},
		[27958] = {38912,10,325,360,380,{34054},{6}},
		[27960] = {38913,10,345,355,380,{22449,22445,22446},{4,4,4}},
		[27961] = {38914,10,310,320,350,{22445},{8}},
		[27962] = {38915,10,330,340,370,{22446,21884,22451,22452,21885},{4,4,4,4,4}},
		[27967] = {38917,10,340,350,380,{22449,22446,22445},{2,6,6}},
		[27968] = {38918,10,340,350,380,{22449,22446},{2,10}},
		[27971] = {38919,10,350,370,380,{22449,22445},{4,40}},
		[27972] = {38920,10,350,370,380,{22449,22446,22445},{4,5,20}},
		[27975] = {38921,10,350,370,380,{22449,22446},{8,8}},
		[27977] = {38922,10,360,370,385,{22449,22446,22445},{8,6,20}},
		[27981] = {38923,10,375,390,390,{22450,22449,22446,21884,23571},{12,10,8,6,1}},
		[27982] = {38924,10,375,380,390,{22450,22449,22446,21885,22456},{12,10,8,6,6}},
		[27984] = {38925,10,375,380,390,{22450,22449,22446,22445},{6,10,8,40}},
		[28003] = {38926,10,360,370,385,{22449,22446,22445},{12,10,20}},
		[28004] = {38927,10,360,370,385,{22450,22449,21885},{8,8,2}},
		[28028] = {22459,10,350,370,380,{22450},{2}},
		[28210] = {22660,8,300,315,345,{19726,14048,12803,14227},{1,2,4,4}},
		[28461] = {22762,2,300,320,340,{12655,19726,12360,12803},{6,2,2,2}},
		[28472] = {22759,3,300,320,340,{8170,19726,12803,15407},{12,2,2,2}},
		[28570] = {22840,4,355,370,380,{22790,22791,18256},{1,1,1}},
		[28571] = {22841,4,360,375,380,{21884,22793,18256},{1,3,5},5},
		[28572] = {22842,4,360,375,380,{21885,22793,18256},{1,3,5},5},
		[28573] = {22844,4,360,375,380,{21886,22793,18256},{1,3,5},5},
		[28575] = {22845,4,360,375,380,{22457,22793,18256},{1,3,5},5},
		[28576] = {22846,4,360,375,380,{22456,22793,18256},{1,3,5},5},
		[28577] = {22847,4,360,375,380,{21886,22793,18256},{1,3,5},5},
		[28578] = {22848,4,365,375,380,{22791,22793,18256},{1,1,1}},
		[28579] = {22849,4,365,375,380,{22790,22573,18256},{2,3,1}},
		[28580] = {21885,4,375,375,380,{22456},{1}},
		[28581] = {22456,4,375,375,380,{21885},{1}},
		[28582] = {21884,4,375,375,380,{22457},{1}},
		[28583] = {22457,4,375,375,380,{21884},{1}},
		[28584] = {22452,4,375,375,380,{21886},{1}},
		[28585] = {21886,4,375,375,380,{22452},{1}},
		[28586] = {22850,4,375,375,380,{22793,22786,22791,18256},{2,1,1,1}},
		[28587] = {22851,4,375,375,380,{22794,22793,22790,18256},{1,3,7,1},2},
		[28588] = {22853,4,375,375,380,{22794,22793,22786,18256},{1,3,7,1},2},
		[28589] = {22854,4,375,375,380,{22794,22793,22789,18256},{1,3,7,1},2},
		[28590] = {22861,4,375,375,380,{22794,22793,22791,18256},{1,3,7,1},2},
		[28591] = {22866,4,375,375,380,{22794,22793,22792,18256},{1,3,7,1},2},
		[29356] = {23445,7,275,275,325,{23424},{2}},
		[29360] = {23448,7,350,340,375,{23445,23447},{3,2}},
		[30349] = {23775,9,405,425,440,{36913,41163,39681},{8,8,4}},
		[31054] = {24080,14,355,365,380,{23449,31079,21885},{2,4,3}},
		[31055] = {24082,14,355,365,380,{23449,31079,21884},{2,4,3}},
		[31056] = {24085,14,360,370,380,{23449,31079,21886},{2,4,3}},
		[31057] = {24086,14,365,370,380,{23449,31079,22457},{2,4,3}},
		[31061] = {24089,14,365,375,380,{23447,31079,21884},{2,4,4}},
		[31062] = {24092,14,360,370,380,{23448,21885,21884,31079},{2,6,4,1}},
		[31063] = {24093,14,360,370,380,{23448,21884,21885,31079},{2,6,4,1}},
		[31064] = {24095,14,360,370,380,{23448,22456,21886,31079},{2,6,4,1}},
		[31065] = {24097,14,360,370,380,{23448,21886,22456,31079},{2,6,4,1}},
		[31066] = {24098,14,360,370,380,{23448,22457,31079},{2,8,1}},
		[31070] = {24114,14,360,370,385,{23447,31079},{2,3}},
		[31071] = {24116,14,360,370,380,{23573,31079,23441},{2,2,1}},
		[31072] = {24117,14,365,375,385,{23447,31079,23112},{2,4,2}},
		[31076] = {24121,14,365,375,385,{23449,31079,23117},{2,4,2}},
		[31077] = {24122,14,370,375,385,{23449,21886,23437,31079},{20,20,2,5}},
		[31078] = {24123,14,370,375,385,{23448,22457,23438,31079},{20,20,2,5}},
		[31079] = {24124,14,370,375,385,{23448,23077,22452},{8,2,4}},
		[31080] = {24125,14,370,375,385,{23449,23440,23112},{4,2,4}},
		[31081] = {24126,14,370,375,385,{23448,23436,21884},{2,2,4}},
		[31082] = {24127,14,370,375,385,{23447,23437,22457},{2,2,4}},
		[31083] = {24128,14,370,375,385,{23573,23441,22456},{6,2,2}},
		[32465] = {25657,3,335,345,365,{23793,25700,14341},{2,3,3}},
		[32468] = {25660,3,325,335,355,{23793,25700,14341},{2,3,3}},
		[32469] = {25659,3,335,345,365,{23793,25700,14341},{2,2,3}},
		[32473] = {25671,3,330,340,360,{23793,14341},{3,3}},
		[32481] = {25676,3,330,340,360,{23793,14341},{3,3}},
		[32657] = {25845,2,360,365,375,{23447},{4}},
		[32665] = {22462,10,350,370,380,{25844,22446,22449,23571,22461},{1,8,8,1,1}},
		[32667] = {22463,10,375,370,385,{25845,22446,22445,22462},{1,6,6,1}},
		[32866] = {25896,14,365,375,380,{25867},{1}},
		[32867] = {25897,14,365,375,380,{25867},{1}},
		[32868] = {25898,14,365,375,380,{25867},{1}},
		[32869] = {25899,14,365,375,380,{25867},{1}},
		[32870] = {25901,14,365,375,380,{25867},{1}},
		[32871] = {25890,14,365,375,380,{25868},{1}},
		[32872] = {25893,14,365,375,380,{25868},{1}},
		[32873] = {25894,14,365,375,380,{25868},{1}},
		[32874] = {25895,14,365,375,380,{25868},{1}},
		[33296] = {27667,6,350,370,380,{27439},{1}},
		[33741] = {28104,4,315,330,345,{22789,22785,18256},{1,1,1}},
		[33990] = {38928,10,320,330,360,{22446},{2}},
		[33991] = {38929,10,300,310,340,{22447,22445},{2,2}},
		[33992] = {38930,10,345,355,380,{22446,22445},{4,10}},
		[33993] = {38931,10,305,315,345,{22447,22445},{1,4}},
		[33994] = {38932,10,360,370,385,{22446,22445,22449},{8,2,2}},
		[33995] = {38933,10,340,350,380,{22445,22446},{12,1}},
		[33996] = {38934,10,310,320,350,{22445},{8}},
		[33997] = {38935,10,360,370,385,{22446,22449,22457},{6,6,6}},
		[33999] = {38936,10,350,370,380,{22446,22449,21886},{6,6,6}},
		[34001] = {38937,10,305,315,345,{22447},{3}},
		[34002] = {38938,10,300,310,340,{22445},{6}},
		[34003] = {38939,10,325,335,365,{22446,22445,22457},{2,6,2}},
		[34004] = {38940,10,310,320,350,{22446,22445,22451},{1,4,1}},
		[34005] = {38941,10,350,370,380,{22449,22457},{4,8}},
		[34006] = {38942,10,350,370,380,{22449,22456},{4,8}},
		[34007] = {38943,10,360,370,385,{22449,22451},{8,8}},
		[34008] = {38944,10,360,370,385,{22449,22452},{8,8}},
		[34009] = {38945,10,325,335,365,{22445},{15}},
		[34010] = {38946,10,350,370,380,{22449,21885,21886},{8,8,8}},
		[36075] = {29970,3,260,280,300,{8170,17056,8153,8172,14341},{10,5,4,2,1}},
		[36076] = {29971,3,260,280,300,{8170,8165,8172,14341},{10,10,2,1}},
		[36077] = {29973,3,330,350,370,{23793,22451,22452,14341},{4,2,2,2}},
		[36078] = {29974,3,330,350,370,{23793,25699,21886,14341},{4,12,3,2}},
		[36079] = {29975,3,330,350,370,{23793,15416,21884,14341},{4,8,3,2}},
		[37855] = {30825,14,360,370,380,{23447,22457},{2,8}},
		[38503] = {31398,14,375,375,385,{31079,23449,21885,21884},{4,2,6,6}},
		[38504] = {31399,14,375,375,385,{31079,23448,21886,22456},{4,2,6,6}},
		[38961] = {31677,4,360,375,380,{22793,22792,18256},{1,2,1}},
		[39705] = {32193,14,375,375,385,{32227},{1}},
		[39706] = {32194,14,375,375,385,{32227},{1}},
		[39710] = {32195,14,375,375,385,{32227},{1}},
		[39711] = {32196,14,375,375,385,{32227},{1}},
		[39712] = {32197,14,375,375,385,{32227},{1}},
		[39713] = {32198,14,375,375,385,{32227},{1}},
		[39714] = {32199,14,375,375,385,{32227},{1}},
		[39715] = {32200,14,375,375,385,{32228},{1}},
		[39716] = {32201,14,375,375,385,{32228},{1}},
		[39717] = {32202,14,375,375,385,{32228},{1}},
		[39718] = {32203,14,375,375,385,{32228},{1}},
		[39719] = {32204,14,375,375,385,{32229},{1}},
		[39720] = {32205,14,375,375,385,{32229},{1}},
		[39721] = {32206,14,375,375,385,{32229},{1}},
		[39722] = {32207,14,375,375,385,{32229},{1}},
		[39723] = {32208,14,375,375,385,{32229},{1}},
		[39724] = {32209,14,375,375,385,{32229},{1}},
		[39725] = {32210,14,375,375,385,{32229},{1}},
		[39727] = {32211,14,375,375,385,{32230},{1}},
		[39728] = {32212,14,375,375,385,{32230},{1}},
		[39729] = {32213,14,375,375,385,{32230},{1}},
		[39730] = {32214,14,375,375,385,{32230},{1}},
		[39731] = {32215,14,375,375,385,{32230},{1}},
		[39732] = {32216,14,375,375,385,{32230},{1}},
		[39733] = {32217,14,375,375,385,{32231},{1}},
		[39734] = {32218,14,375,375,385,{32231},{1}},
		[39735] = {32219,14,375,375,385,{32231},{1}},
		[39736] = {32220,14,375,375,385,{32231},{1}},
		[39737] = {32221,14,375,375,385,{32231},{1}},
		[39738] = {32222,14,375,375,385,{32231},{1}},
		[39739] = {32223,14,375,375,385,{32249},{1}},
		[39740] = {32224,14,375,375,385,{32249},{1}},
		[39741] = {32225,14,375,375,385,{32249},{1}},
		[39742] = {32226,14,375,375,385,{32249},{1}},
		[39895] = {7191,9,275,275,285,{20816,7078},{3,2},5},
		[39961] = {32409,14,365,375,380,{25867},{1}},
		[39963] = {32410,14,365,375,380,{25868},{1}},
		[41418] = {32776,14,365,375,385,{23449,31079,24478,24479},{12,4,20,3}},
		[42620] = {38947,10,350,360,375,{22445,22446,22449,22451},{8,4,6,2}},
		[42974] = {38948,10,375,380,390,{22450,22449,22446,22445,22824},{6,10,6,30,3}},
		[44155] = {34060,9,300,330,350,{23782,23781,23783,11291},{2,20,20,8}},
		[44157] = {34061,9,375,385,395,{23784,23786,23787,34249},{4,8,8,1}},
		[44383] = {38949,10,330,340,370,{22449,22447},{1,4}},
		[44438] = {34125,6,350,1,1,{33120},{1}},
		[44483] = {38950,10,400,415,435,{34054,34055,36860},{6,3,1}},
		[44484] = {38951,10,405,415,435,{34054},{12}},
		[44488] = {38953,10,410,420,440,{34055},{4}},
		[44489] = {38954,10,420,430,450,{34054,35624},{6,6}},
		[44492] = {38955,10,395,405,425,{34055},{3}},
		[44494] = {38956,10,400,415,435,{34054,34055,35627},{15,1,1}},
		[44500] = {38959,10,400,405,425,{34054},{9}},
		[44506] = {38960,10,375,370,390,{34055},{1}},
		[44508] = {38961,10,410,420,440,{34054,34055},{10,1}},
		[44509] = {38962,10,420,430,450,{34054,34055},{4,4}},
		[44510] = {38963,10,400,420,440,{34054,34052},{16,4}},
		[44513] = {38964,10,420,405,425,{34054,34055},{6,1}},
		[44524] = {38965,10,425,435,455,{34052,36860},{4,4}},
		[44528] = {38966,10,385,380,400,{34056,34054},{3,3}},
		[44529] = {38967,10,415,425,445,{34055,34052},{4,1}},
		[44555] = {38968,10,375,385,400,{34054},{10}},
		[44556] = {38969,10,400,415,435,{34055,35622},{4,1}},
		[44575] = {44815,10,430,440,460,{34054,34055},{24,6}},
		[44576] = {38972,10,425,435,455,{34052,35625},{1,4}},
		[44582] = {38973,10,395,395,410,{34054},{15}},
		[44584] = {38974,10,405,415,435,{34054,34055},{8,2}},
		[44588] = {38975,10,410,435,455,{34055,34052},{2,2}},
		[44589] = {38976,10,410,425,445,{34054,34055},{16,4}},
		[44590] = {38977,10,400,415,435,{34054,34056,35625},{8,2,1}},
		[44591] = {38978,10,435,445,465,{34054,41163,34052},{8,2,2}},
		[44592] = {38979,10,360,370,390,{34054,34056},{4,1}},
		[44593] = {38980,10,400,430,450,{34054,34055},{16,4}},
		[44595] = {38981,10,430,440,460,{34054,34052},{6,6}},
		[44596] = {38982,10,400,415,435,{34054,35624},{20,1}},
		[44598] = {38984,10,420,425,445,{34054,34055},{14,3}},
		[44612] = {38985,10,410,405,420,{34054,34052},{30,1}},
		[44616] = {38987,10,400,410,430,{34054,34055},{16,3}},
		[44621] = {38988,10,430,440,460,{34055,34052},{2,6}},
		[44623] = {38989,10,370,380,400,{34054,34056},{4,2}},
		[44625] = {38990,10,435,445,465,{34052,35624},{2,8}},
		[44629] = {38991,10,395,405,425,{34054,34055},{10,2}},
		[44630] = {38992,10,410,400,420,{34054,34055},{6,2}},
		[44631] = {38993,10,440,450,470,{34054,34057},{12,1}},
		[44633] = {38995,10,420,420,440,{34052,35623},{4,4}},
		[44635] = {38997,10,395,405,425,{34054,34056},{8,4}},
		[44636] = {nil,10,400,400,415,{34054,34055},{8,1}},
		[44645] = {nil,10,400,400,415,{34054,34055},{8,1}},
		[44794] = {34220,14,365,375,380,{25868},{1}},
		[45117] = {34490,3,350,370,390,{23793,29547,25707,29548,25708,14341},{15,5,5,5,5,3}},
		[45382] = {1180,15,35,35,45,{37101,39354},{1,1}},
		[45545] = {34721,1,350,375,410,{33470},{1}},
		[45546] = {34722,1,400,390,470,{33470},{2}},
		[45547] = {39691,6,350,1,1,{34618},{1}},
		[45549] = {34748,6,350,350,415,{34736},{1}},
		[45550] = {34749,6,350,350,415,{43009},{1}},
		[45551] = {34750,6,350,350,415,{43010},{1}},
		[45552] = {34751,6,350,350,415,{43011},{1}},
		[45553] = {34752,6,350,350,415,{43012},{1}},
		[45554] = {34753,6,375,375,425,{34736,43009,43010,43013},{1,1,1,2}},
		[45555] = {34754,6,400,425,475,{34736,43007},{2,1}},
		[45556] = {34755,6,400,425,475,{43009,43007},{2,1}},
		[45557] = {34756,6,400,425,475,{43010,43007},{2,1}},
		[45558] = {34757,6,400,425,475,{43011,43007},{1,1}},
		[45559] = {34758,6,400,425,475,{43012,43007},{2,1}},
		[45560] = {34759,6,350,350,380,{41803},{1}},
		[45561] = {34760,6,350,350,380,{41808},{1}},
		[45562] = {34761,6,350,350,380,{41812},{1}},
		[45563] = {34762,6,350,350,415,{41806},{1}},
		[45564] = {34763,6,350,350,415,{41809},{1}},
		[45565] = {34764,6,350,350,415,{41813},{1}},
		[45566] = {34765,6,350,350,415,{41810},{1}},
		[45567] = {34766,6,400,425,475,{41806,43007},{1,1}},
		[45568] = {34767,6,400,425,475,{41809,43007},{1,1}},
		[45569] = {42942,6,350,350,415,{41802},{1}},
		[45570] = {34769,6,400,425,475,{41802,43007},{1,1}},
		[45571] = {34768,6,400,425,475,{41813,43007},{1,1}},
		[46122] = {34362,14,365,375,385,{35128,23571,31079,34664},{4,4,12,5}},
		[46123] = {34363,14,365,375,385,{35128,21886,31079,34664},{4,20,12,5}},
		[46124] = {34361,14,365,375,385,{35128,22451,31079,34664},{4,20,12,5}},
		[46125] = {34359,14,365,375,385,{31079,32227,32228},{12,3,3}},
		[46126] = {34360,14,365,375,385,{31079,32249},{6,6}},
		[46127] = {34358,14,365,375,385,{35128,23572},{6,9}},
		[46578] = {38998,10,350,350,365,{22456,21885},{2,2}},
		[46594] = {38999,10,360,370,400,{22446,22445,23427},{4,8,4}},
		[46597] = {35501,14,370,375,380,{25867},{1}},
		[46601] = {35503,14,370,375,380,{25868},{1}},
		[46775] = {35693,14,375,375,385,{23449,32228,23440},{8,2,6}},
		[46776] = {35694,14,375,375,385,{23449,32231,22452},{8,2,8}},
		[46777] = {35700,14,375,375,385,{23447,32227,21884},{8,2,8}},
		[46778] = {35702,14,375,375,385,{23573,32230,22456},{4,2,8}},
		[46779] = {35703,14,375,375,385,{23447,32249,22457},{8,2,8}},
		[47046] = {35748,4,375,380,390,{13503,22451,30183},{1,6,2}},
		[47048] = {35749,4,375,380,390,{13503,21884,30183},{1,6,2}},
		[47049] = {35750,4,375,380,390,{13503,21886,30183},{1,6,2}},
		[47050] = {35751,4,375,380,390,{13503,22456,30183},{1,6,2}},
		[47051] = {39000,10,375,380,390,{22446,22452},{8,8}},
		[47053] = {35759,14,375,375,385,{32249},{1}},
		[47054] = {35758,14,375,375,385,{32249},{1}},
		[47055] = {35760,14,375,375,385,{32231},{1}},
		[47056] = {35761,14,375,375,385,{32229},{1}},
		[47672] = {39001,10,430,440,460,{34054,34055},{15,2}},
		[47766] = {39002,10,400,410,430,{34054,35624},{10,1}},
		[47898] = {39003,10,430,440,460,{34054,34055},{16,4}},
		[47899] = {39004,10,440,450,470,{34055,34057},{6,1}},
		[47900] = {39005,10,425,435,455,{34054,34055},{20,4}},
		[47901] = {39006,10,440,450,470,{34054,34055,34052},{10,2,2}},
		[48114] = {955,15,35,35,45,{37101,39354},{1,1}},
		[48116] = {1181,15,35,35,45,{37101,39354},{1,1}},
		[48121] = {40924,15,100,105,115,{43116,39354},{1,1}},
		[48247] = {37168,15,110,125,150,{39354,43115,39774},{1,1,1}},
		[48248] = {37118,15,35,60,75,{39354,39469},{1,1}},
		[48789] = {37503,14,375,375,385,{32230},{1}},
		[49252] = {36916,7,350,350,375,{36909},{1}},
		[49258] = {36913,7,400,400,400,{36912},{2}},
		[50598] = {2290,15,75,75,85,{39774,39354},{1,1}},
		[50599] = {4419,15,165,170,180,{43118,10648},{1,2},5},
		[50600] = {10308,15,215,220,230,{43120,39501},{1,2},2},
		[50601] = {27499,15,260,265,275,{43122,39501},{1,2},2},
		[50602] = {33458,15,310,310,320,{43124,39501},{1,2},2},
		[50603] = {37091,15,360,365,375,{43126,39502},{1,2},2},
		[50604] = {37092,15,410,415,425,{43126,39502},{1,2},2},
		[50605] = {1712,15,75,75,85,{39774,39354},{1,1}},
		[50606] = {4424,15,160,165,175,{43118,10648},{1,2},2},
		[50607] = {10306,15,210,215,225,{43120,39501},{1,2},2},
		[50608] = {27501,15,255,260,270,{43122,39501},{1,2},2},
		[50609] = {33460,15,295,305,315,{43122,39501},{1,2},2},
		[50610] = {37097,15,355,360,370,{43126,39502},{1,2},2},
		[50611] = {37098,15,405,410,420,{43126,39502},{1,2},2},
		[50612] = {1711,15,75,75,85,{39774,39354},{1,1}},
		[50614] = {4422,15,155,160,170,{43118,10648},{1,2},2},
		[50616] = {10307,15,205,210,220,{43120,39501},{1,2},2},
		[50617] = {27502,15,250,255,265,{43122,39501},{1,2},2},
		[50618] = {33461,15,290,300,310,{43122,39501},{1,2},2},
		[50619] = {37093,15,350,355,365,{43126,39502},{1,2},2},
		[50620] = {37094,15,400,405,415,{43126,39502},{1,2},2},
		[50936] = {38425,3,390,385,405,{33568},{6}},
		[50938] = {38408,3,375,390,410,{33568},{12}},
		[50939] = {38410,3,370,385,405,{33568},{12}},
		[50940] = {38411,3,380,395,415,{33568},{10}},
		[50941] = {38409,3,370,385,405,{33568},{8}},
		[50942] = {38407,3,375,390,410,{33568},{10}},
		[50943] = {38406,3,380,380,395,{33568},{10}},
		[50944] = {38400,3,370,385,405,{33568},{12}},
		[50945] = {38401,3,375,390,410,{33568},{12}},
		[50946] = {38402,3,380,395,415,{33568},{10}},
		[50947] = {38403,3,375,390,410,{33568},{10}},
		[50948] = {38404,3,370,385,405,{33568},{8}},
		[50949] = {38405,3,380,395,415,{33568},{10}},
		[50950] = {38414,3,375,390,410,{33568},{12}},
		[50951] = {38416,3,370,385,405,{33568},{12}},
		[50952] = {38424,3,375,390,410,{33568},{10}},
		[50953] = {38415,3,380,395,415,{33568},{10}},
		[50954] = {38413,3,380,395,415,{33568},{10}},
		[50955] = {38412,3,370,385,405,{33568},{8}},
		[50956] = {38420,3,375,390,410,{33568},{12}},
		[50957] = {38422,3,370,385,405,{33568},{8}},
		[50958] = {38417,3,380,395,415,{33568},{10}},
		[50959] = {38421,3,370,385,405,{33568},{12}},
		[50960] = {38419,3,380,395,415,{33568},{10}},
		[50961] = {38418,3,375,390,410,{33568},{10}},
		[50962] = {38375,3,350,375,385,{33568},{4}},
		[50963] = {38376,3,395,400,405,{38425},{4}},
		[50964] = {38371,3,405,410,420,{38425,38561},{3,12}},
		[50965] = {38373,3,425,435,445,{44128,38558,43102},{2,2,1}},
		[50966] = {38372,3,400,405,415,{38425,38558},{4,1}},
		[50967] = {38374,3,425,435,445,{44128,38557,43102},{2,2,1}},
		[50970] = {38399,3,415,420,425,{38425},{8}},
		[50971] = {38347,3,415,420,425,{38425},{8}},
		[51568] = {38590,3,390,415,435,{38558,37705},{25,6}},
		[51569] = {38591,3,400,410,430,{38425,37703},{6,4}},
		[51570] = {38592,3,410,410,430,{38425,37703},{5,5}},
		[51571] = {38433,3,385,400,420,{33568},{12}},
		[51572] = {38437,3,385,400,420,{33568},{14}},
		[52567] = {39086,2,370,375,385,{36916},{5}},
		[52568] = {39087,2,350,360,380,{36916},{4}},
		[52569] = {39088,2,350,360,380,{36916},{4}},
		[52570] = {39085,2,375,380,390,{36916},{6}},
		[52571] = {39084,2,370,375,385,{36916},{5}},
		[52572] = {39083,2,360,370,380,{36916},{4}},
		[52733] = {32399,3,375,385,405,{32428,22450,21886,22456,25700},{1,1,2,2,2}},
		[52738] = {37101,15,15,15,30,{39151},{1}},
		[52739] = {38682,15,35,75,100,{39469,39354},{1,2},2},
		[52840] = {39349,15,75,100,125,{39774,39354},{3,2},2},
		[52843] = {39469,15,35,45,75,{39151},{2}},
		[53056] = {39520,6,350,375,400,{35949,35948},{2,1},5},
		[53281] = {39690,9,350,366,385,{36916,37705},{3,1},2},
		[53462] = {39774,15,75,75,80,{39334},{2}},
		[53771] = {35627,4,405,405,425,{35625},{1}},
		[53773] = {36860,4,405,405,425,{35625},{1}},
		[53774] = {35622,4,405,405,425,{36860},{1}},
		[53775] = {35625,4,405,405,425,{36860},{1}},
		[53776] = {35622,4,405,405,425,{35623},{1}},
		[53777] = {35624,4,405,405,425,{35623},{1}},
		[53779] = {35624,4,405,405,425,{35627},{1}},
		[53780] = {35625,4,405,405,425,{35627},{1}},
		[53781] = {35623,4,405,405,425,{35624},{1}},
		[53782] = {35627,4,405,405,425,{35624},{1}},
		[53783] = {35623,4,405,405,425,{35622},{1}},
		[53784] = {36860,4,405,405,425,{35622},{1}},
		[53812] = {40195,4,375,380,390,{40199},{1}},
		[53830] = {39996,14,390,410,440,{36918},{1}},
		[53831] = {39900,14,350,375,415,{36917},{1}},
		[53832] = {39905,14,350,375,415,{36917},{1}},
		[53834] = {39911,14,350,375,415,{36917},{1}},
		[53835] = {39906,14,350,375,415,{36917},{1}},
		[53836] = {33447,4,405,410,425,{36901,36906,18256},{1,2,1}},
		[53837] = {33448,4,410,415,430,{36905,36901,18256},{2,1,1}},
		[53838] = {39671,4,350,360,380,{36901,18256},{2,1}},
		[53839] = {40067,4,360,365,385,{36907,18256},{2,1}},
		[53840] = {39666,4,395,400,415,{36901,36903,18256},{2,2,1}},
		[53841] = {40068,4,355,365,385,{36901,37921,18256},{1,2,1}},
		[53842] = {40070,4,365,375,390,{36901,36904,18256},{1,1,1}},
		[53843] = {39907,14,360,375,415,{36917},{1}},
		[53844] = {39908,14,350,375,415,{36917},{1}},
		[53845] = {39909,14,350,375,415,{36917},{1}},
		[53847] = {40072,4,385,390,400,{36907,18256},{3,1}},
		[53848] = {40076,4,375,380,390,{40195,18256},{3,1}},
		[53852] = {39912,14,350,375,415,{36920},{1}},
		[53853] = {39914,14,350,375,415,{36920},{1}},
		[53854] = {39915,14,350,375,415,{36920},{1}},
		[53855] = {39916,14,350,375,415,{36920},{1}},
		[53856] = {39918,14,350,375,415,{36920},{1}},
		[53857] = {39917,14,350,375,415,{36920},{1}},
		[53859] = {39934,14,350,375,415,{36926},{1}},
		[53860] = {39935,14,350,375,415,{36926},{1}},
		[53861] = {39942,14,350,375,415,{36926},{1}},
		[53862] = {39936,14,350,375,415,{36926},{1}},
		[53863] = {39941,14,350,375,415,{36926},{1}},
		[53864] = {39943,14,350,375,415,{36926},{1}},
		[53865] = {39945,14,350,375,415,{36926},{1}},
		[53866] = {39937,14,350,375,415,{36926},{1}},
		[53867] = {39944,14,350,375,415,{36926},{1}},
		[53868] = {39938,14,360,375,415,{36926},{1}},
		[53869] = {39939,14,350,375,415,{36926},{1}},
		[53870] = {39933,14,350,375,415,{36926},{1}},
		[53871] = {39940,14,350,375,415,{36926},{1}},
		[53872] = {39947,14,350,375,415,{36929},{1}},
		[53873] = {39948,14,350,375,415,{36929},{1}},
		[53874] = {39949,14,350,375,415,{36929},{1}},
		[53875] = {39950,14,350,375,415,{36929},{1}},
		[53876] = {39951,14,350,375,415,{36929},{1}},
		[53877] = {39952,14,350,375,415,{36929},{1}},
		[53878] = {39953,14,350,375,415,{36929},{1}},
		[53879] = {39954,14,350,375,415,{36929},{1}},
		[53880] = {39955,14,350,375,415,{36929},{1}},
		[53881] = {39946,14,350,375,415,{36929},{1}},
		[53882] = {39956,14,350,375,415,{36929},{1}},
		[53883] = {39957,14,350,375,415,{36929},{1}},
		[53884] = {39958,14,350,375,415,{36929},{1}},
		[53885] = {39959,14,350,375,415,{36929},{1}},
		[53886] = {39960,14,350,375,415,{36929},{1}},
		[53887] = {39961,14,350,375,415,{36929},{1}},
		[53888] = {39962,14,350,375,415,{36929},{1}},
		[53889] = {39963,14,350,375,415,{36929},{1}},
		[53890] = {39964,14,350,375,415,{36929},{1}},
		[53891] = {39965,14,360,375,415,{36929},{1}},
		[53892] = {39966,14,350,375,415,{36929},{1}},
		[53893] = {39967,14,350,375,415,{36929},{1}},
		[53894] = {39968,14,350,375,415,{36932},{1}},
		[53895] = {40077,4,400,415,430,{36901,18256},{2,1}},
		[53898] = {40078,4,390,395,405,{36901,18256},{4,1}},
		[53899] = {40079,4,375,380,390,{37921,36901,18256},{4,1,1}},
		[53900] = {40081,4,380,385,395,{36901,36907,18256},{1,2,1}},
		[53901] = {46376,4,435,450,465,{36906,36905,36908,40411},{5,5,1,1},2},
		[53902] = {46379,4,435,450,465,{36905,37704,36908,40411},{7,3,1,1},2},
		[53903] = {46377,4,435,450,465,{36905,36901,36908,40411},{7,3,1,1},2},
		[53904] = {40087,4,400,415,430,{36907,36905,18256},{2,2,1}},
		[53905] = {40093,4,395,415,430,{36906,18256},{2,1}},
		[53916] = {39974,14,350,375,415,{36932},{1}},
		[53917] = {39975,14,350,375,415,{36932},{1}},
		[53918] = {39976,14,350,375,415,{36932},{1}},
		[53919] = {39977,14,350,375,415,{36932},{1}},
		[53920] = {39978,14,350,375,415,{36932},{1}},
		[53921] = {39979,14,350,375,415,{36932},{1}},
		[53922] = {39980,14,350,375,415,{36932},{1}},
		[53923] = {39981,14,350,375,415,{36932},{1}},
		[53924] = {39982,14,350,375,415,{36932},{1}},
		[53925] = {39983,14,350,375,415,{36932},{1}},
		[53926] = {39984,14,350,375,415,{36932},{1}},
		[53927] = {39985,14,350,375,415,{36932},{1}},
		[53928] = {39986,14,350,375,415,{36932},{1}},
		[53929] = {39988,14,350,375,415,{36932},{1}},
		[53930] = {39989,14,350,375,415,{36932},{1}},
		[53931] = {39990,14,350,375,415,{36932},{1}},
		[53932] = {39991,14,350,375,415,{36932},{1}},
		[53933] = {39992,14,350,375,415,{36932},{1}},
		[53934] = {39919,14,350,375,415,{36923},{1}},
		[53936] = {40213,4,400,410,420,{37701,18256},{2,1}},
		[53937] = {40215,4,400,410,420,{37702,18256},{2,1}},
		[53938] = {40217,4,400,410,420,{37704,18256},{2,1}},
		[53939] = {40214,4,400,410,420,{37705,18256},{2,1}},
		[53940] = {39920,14,350,375,415,{36923},{1}},
		[53941] = {39927,14,350,375,415,{36923},{1}},
		[53942] = {40216,4,400,410,420,{37703,18256},{2,1}},
		[53943] = {39932,14,350,375,415,{36923},{1}},
		[53945] = {39997,14,390,410,440,{36918},{1}},
		[53946] = {39998,14,390,410,440,{36918},{1}},
		[53947] = {39999,14,390,410,440,{36918},{1}},
		[53948] = {40000,14,390,410,440,{36918},{1}},
		[53949] = {40001,14,390,410,440,{36918},{1}},
		[53950] = {40002,14,390,410,440,{36918},{1}},
		[53951] = {40003,14,390,410,440,{36918},{1}},
		[53952] = {40008,14,390,410,440,{36924},{1}},
		[53953] = {40009,14,390,410,440,{36924},{1}},
		[53954] = {40010,14,390,410,440,{36924},{1}},
		[53955] = {40011,14,390,410,440,{36924},{1}},
		[53956] = {40012,14,390,410,440,{36921},{1}},
		[53957] = {40013,14,390,410,440,{36921},{1}},
		[53958] = {40014,14,390,410,440,{36921},{1}},
		[53959] = {40015,14,390,410,440,{36921},{1}},
		[53960] = {40016,14,390,410,440,{36921},{1}},
		[53961] = {40017,14,390,410,440,{36921},{1}},
		[53962] = {40022,14,390,410,440,{36927},{1}},
		[53963] = {40023,14,390,410,440,{36927},{1}},
		[53964] = {40024,14,390,410,440,{36927},{1}},
		[53965] = {40025,14,390,410,440,{36927},{1}},
		[53966] = {40026,14,390,410,440,{36927},{1}},
		[53967] = {40027,14,390,410,440,{36927},{1}},
		[53968] = {40028,14,390,410,440,{36927},{1}},
		[53969] = {40029,14,390,410,440,{36927},{1}},
		[53970] = {40030,14,390,410,440,{36927},{1}},
		[53971] = {40031,14,390,410,440,{36927},{1}},
		[53972] = {40032,14,390,410,440,{36927},{1}},
		[53973] = {40033,14,390,410,440,{36927},{1}},
		[53974] = {40034,14,390,410,440,{36927},{1}},
		[53975] = {40037,14,390,410,440,{36930},{1}},
		[53976] = {40038,14,390,410,440,{36930},{1}},
		[53977] = {40039,14,390,410,440,{36930},{1}},
		[53978] = {40040,14,390,410,440,{36930},{1}},
		[53979] = {40043,14,390,410,440,{36930},{1}},
		[53980] = {40044,14,390,410,440,{36930},{1}},
		[53981] = {40045,14,390,410,440,{36930},{1}},
		[53982] = {40046,14,390,410,440,{36930},{1}},
		[53983] = {40047,14,390,410,440,{36930},{1}},
		[53984] = {40048,14,390,410,440,{36930},{1}},
		[53985] = {40049,14,390,410,440,{36930},{1}},
		[53986] = {40050,14,390,410,440,{36930},{1}},
		[53987] = {40051,14,390,410,440,{36930},{1}},
		[53988] = {40052,14,390,410,440,{36930},{1}},
		[53989] = {40053,14,390,410,440,{36930},{1}},
		[53990] = {40054,14,390,410,440,{36930},{1}},
		[53991] = {40055,14,390,410,440,{36930},{1}},
		[53992] = {40056,14,390,410,440,{36930},{1}},
		[53993] = {40057,14,390,410,440,{36930},{1}},
		[53994] = {40058,14,390,410,440,{36930},{1}},
		[53995] = {40085,14,390,410,440,{36933},{1}},
		[53996] = {40086,14,390,410,440,{36933},{1}},
		[53997] = {40088,14,390,410,440,{36933},{1}},
		[53998] = {40089,14,390,410,440,{36933},{1}},
		[54000] = {40090,14,390,410,440,{36933},{1}},
		[54001] = {40091,14,390,410,440,{36933},{1}},
		[54002] = {40092,14,390,410,440,{36933},{1}},
		[54003] = {40095,14,390,410,440,{36933},{1}},
		[54004] = {40099,14,390,410,440,{36933},{1}},
		[54005] = {40102,14,390,410,440,{36933},{1}},
		[54006] = {40104,14,390,410,440,{36933},{1}},
		[54007] = {40094,14,390,410,440,{36933},{1}},
		[54008] = {40096,14,390,410,440,{36933},{1}},
		[54009] = {40100,14,390,410,440,{36933},{1}},
		[54010] = {40103,14,390,410,440,{36933},{1}},
		[54011] = {40105,14,390,410,440,{36933},{1}},
		[54012] = {40098,14,390,410,440,{36933},{1}},
		[54013] = {40101,14,390,410,440,{36933},{1}},
		[54014] = {40106,14,390,410,440,{36933},{1}},
		[54017] = {39910,14,350,375,415,{36917},{1}},
		[54019] = {40041,14,390,410,440,{36930},{1}},
		[54020] = {40248,4,1,445,460,{35623,35624,36860,35622},{1,1,1,1}},
		[54023] = {40059,14,390,410,440,{36930},{1}},
		[54213] = {46378,4,435,450,465,{36906,40195,36908,40411},{7,3,1,1},2},
		[54218] = {40073,4,385,390,400,{36904,18256},{2,1}},
		[54220] = {40097,4,400,415,430,{36906,37701,18256},{2,1,1}},
		[54221] = {40211,4,400,415,430,{36903,40195,18256},{2,1,1}},
		[54222] = {40212,4,400,415,430,{36905,40195,18256},{2,1,1}},
		[54353] = {39688,9,400,405,415,{36913,39683,39684,40533},{10,2,1,1}},
		[54550] = {40668,2,360,370,380,{36916},{4}},
		[54551] = {40669,2,395,400,410,{36916,36913},{6,5}},
		[54552] = {40671,2,400,405,415,{36916,36913},{3,8}},
		[54553] = {40672,2,400,405,415,{36916,36913,37701},{6,5,1}},
		[54554] = {40674,2,395,400,410,{36916,36913,37701},{5,5,1}},
		[54555] = {40673,2,405,410,420,{36913,37701},{12,1}},
		[54556] = {40675,2,405,410,420,{36913},{12}},
		[54557] = {40670,2,390,395,405,{36916,36913},{6,4}},
		[54736] = {nil,9,390,390,395,{39682},{4}},
		[54793] = {nil,9,380,380,385,{36916,39690},{8,8}},
		[54917] = {40942,2,375,380,390,{36916},{7}},
		[54918] = {40949,2,380,385,395,{36916},{7}},
		[54941] = {40950,2,385,390,400,{36916},{7}},
		[54944] = {40951,2,385,390,400,{36916},{8}},
		[54945] = {40952,2,390,395,405,{36916},{12}},
		[54946] = {40953,2,395,400,410,{36916},{12}},
		[54947] = {40943,2,395,400,410,{36916},{12}},
		[54948] = {40954,2,400,405,415,{36916},{12}},
		[54949] = {40955,2,400,405,415,{36916},{8}},
		[54978] = {40956,2,375,395,405,{36916,37705},{8,2}},
		[54979] = {40957,2,375,405,415,{36916,37705},{8,2}},
		[54980] = {40958,2,375,410,420,{36916,37705},{8,2}},
		[54981] = {40959,2,375,415,425,{36916,37705},{8,2}},
		[54998] = {nil,9,400,400,405,{36913,37702},{6,4}},
		[54999] = {nil,9,400,400,405,{36913,37700},{6,4}},
		[55002] = {nil,9,380,380,385,{33470,39682},{12,1}},
		[55013] = {41117,2,390,395,405,{36916,36913},{6,4}},
		[55014] = {41113,2,410,415,425,{36913},{14}},
		[55015] = {41114,2,415,420,430,{36913},{14}},
		[55016] = {nil,9,405,400,410,{39690,39681},{6,6}},
		[55017] = {41116,2,410,415,425,{36913},{13}},
		[55055] = {41126,2,395,400,410,{36916,36913,37705},{5,5,1}},
		[55056] = {41127,2,400,405,415,{36916,36913},{3,8}},
		[55057] = {41128,2,405,410,420,{36913},{12}},
		[55058] = {41129,2,415,420,430,{36913,37705},{14,1}},
		[55174] = {41181,2,390,395,405,{36916,36913,37702},{12,4,2}},
		[55177] = {41182,2,395,400,410,{36916,36913,37702},{8,6,2}},
		[55179] = {41183,2,400,405,415,{36916,36913,37703},{12,4,1}},
		[55181] = {41184,2,405,410,420,{36913,37703},{12,2}},
		[55182] = {41185,2,410,415,425,{36913,37701},{15,2}},
		[55183] = {41186,2,415,420,430,{36913,37702},{16,1}},
		[55184] = {41187,2,415,420,430,{36913,37702},{14,1}},
		[55185] = {41188,2,415,420,430,{36913,37702},{20,2}},
		[55186] = {41189,2,415,420,430,{36913,37701},{14,2}},
		[55187] = {41190,2,415,420,430,{36913,37701},{13,2}},
		[55199] = {41238,3,395,405,425,{38425,37700,37705},{6,5,5}},
		[55200] = {41239,2,380,385,395,{36916},{8}},
		[55201] = {41240,2,380,385,395,{36916},{8}},
		[55202] = {41241,2,385,390,400,{36916},{7}},
		[55203] = {41242,2,385,390,400,{36916},{10}},
		[55204] = {41243,2,390,395,405,{36916},{10}},
		[55206] = {41245,2,405,415,425,{36913,37700},{7,2}},
		[55208] = {37663,7,450,450,450,{41163,36860,35624,35627},{3,1,1,1}},
		[55211] = {41163,7,450,450,450,{36910},{2}},
		[55243] = {41264,3,1,410,420,{38425,35623},{8,6}},
		[55252] = {40769,9,415,415,420,{36913},{10},5},
		[55298] = {41355,2,420,425,435,{36913,36860},{12,1}},
		[55300] = {41356,2,420,430,450,{36913,35622},{12,1}},
		[55301] = {41357,2,420,430,450,{36913,35624},{12,1}},
		[55302] = {41344,2,425,435,455,{36913,36860},{14,1}},
		[55303] = {41345,2,425,435,455,{36913,35624},{14,1}},
		[55304] = {41346,2,425,435,455,{36913,35622},{14,1}},
		[55305] = {41354,2,420,425,435,{36913,35623},{12,1}},
		[55306] = {41351,2,420,430,450,{36913,35622},{12,1}},
		[55307] = {41352,2,420,430,450,{36913,35622},{12,1}},
		[55308] = {41348,2,420,430,450,{36913,35627},{12,1}},
		[55309] = {41349,2,420,430,450,{36913,36860},{12,1}},
		[55310] = {41347,2,425,435,455,{36913,35623},{14,1}},
		[55311] = {41353,2,425,435,455,{36913,35624},{14,1}},
		[55312] = {41350,2,425,435,455,{36913,35627},{14,1}},
		[55369] = {41257,2,440,450,470,{36913,37663,43102},{8,8,2}},
		[55370] = {41383,2,440,450,470,{36913,37663,43102},{6,6,2}},
		[55371] = {41384,2,440,450,470,{36913,37663,43102},{6,6,2}},
		[55372] = {41386,2,440,450,470,{36913,37663,43102},{4,4,1}},
		[55373] = {41387,2,440,450,470,{36913,37663,43102},{4,4,1}},
		[55374] = {41388,2,440,450,470,{36913,37663,43102},{4,4,1}},
		[55375] = {41391,2,440,450,470,{36913,37663,43102},{4,3,1}},
		[55376] = {41392,2,440,450,470,{36913,37663,43102},{4,3,1}},
		[55377] = {41394,2,440,450,470,{36913,37663,43102},{4,3,1}},
		[55384] = {41377,14,440,440,460,{41266},{1}},
		[55386] = {41375,14,440,440,460,{41266},{1}},
		[55387] = {41378,14,420,440,460,{41266},{1}},
		[55388] = {41379,14,420,440,460,{41266},{1}},
		[55389] = {41285,14,440,440,460,{41266},{1}},
		[55390] = {41307,14,440,440,460,{41266},{1}},
		[55392] = {41333,14,440,440,460,{41266},{1}},
		[55393] = {41335,14,420,440,460,{41266},{1}},
		[55394] = {41339,14,440,440,460,{41266},{1}},
		[55395] = {41400,14,440,440,460,{41266},{1}},
		[55396] = {41401,14,440,440,460,{41334},{1}},
		[55397] = {41395,14,420,440,460,{41334},{1}},
		[55398] = {41396,14,420,440,460,{41334},{1}},
		[55399] = {41397,14,440,440,460,{41334},{1}},
		[55400] = {41398,14,440,440,460,{41334},{1}},
		[55401] = {41380,14,420,440,460,{41334},{1}},
		[55402] = {41381,14,440,440,460,{41334},{1}},
		[55403] = {41382,14,440,440,460,{41334},{1}},
		[55404] = {41385,14,440,440,460,{41334},{1}},
		[55405] = {41389,14,440,440,460,{41334},{1}},
		[55407] = {41376,14,440,440,460,{41266},{1}},
		[55628] = {nil,2,400,400,400,{36913,35624},{4,1}},
		[55641] = {nil,2,400,400,400,{36913,35627},{4,1}},
		[55642] = {nil,8,420,400,405,{41594,38426},{1,1}},
		[55656] = {41611,2,415,420,430,{36913,35624,35622,35627},{4,1,1,1}},
		[55732] = {41745,2,420,425,435,{36913,41163},{2,1}},
		[55769] = {nil,8,420,400,405,{41593,38426},{1,1}},
		[55777] = {nil,8,420,400,405,{41595,38426},{1,1}},
		[55834] = {41974,2,360,370,380,{36916},{4}},
		[55835] = {41975,2,370,380,390,{36916},{5}},
		[55839] = {41976,2,420,425,435,{36913,41163},{2,1}},
		[55898] = {41509,8,360,370,380,{33470},{6},5},
		[55899] = {41510,8,350,370,375,{33470},{5}},
		[55900] = {41511,8,400,400,405,{41510,34054},{2,2}},
		[55901] = {41548,8,395,405,415,{41510,38426},{8,1}},
		[55902] = {41513,8,350,360,380,{41510,38426},{3,1}},
		[55903] = {41515,8,360,370,390,{41510,38426},{4,1}},
		[55904] = {44211,8,360,370,390,{41510,38426},{3,1}},
		[55906] = {41520,8,375,385,405,{41510,38426},{4,1}},
		[55907] = {41521,8,380,390,410,{41510,38426},{5,1}},
		[55908] = {41522,8,370,380,400,{41510,38426},{3,1}},
		[55910] = {41523,8,385,395,415,{41510,38426,36783},{7,4,1}},
		[55911] = {41525,8,390,400,420,{41510,38426,36783},{8,4,1}},
		[55913] = {41528,8,385,395,415,{41510,38426,36783},{5,4,2}},
		[55914] = {41543,8,395,400,410,{41510,38426},{7,1}},
		[55919] = {41546,8,395,405,415,{41510,38426},{8,1}},
		[55920] = {41551,8,400,410,420,{41510,38426},{8,1}},
		[55921] = {41549,8,405,415,425,{41510,38426},{10,1}},
		[55922] = {41545,8,405,415,425,{41510,38426},{9,1}},
		[55923] = {41550,8,410,420,430,{41510,38426},{10,1}},
		[55924] = {41544,8,410,420,430,{41510,38426},{10,1}},
		[55925] = {41553,8,415,425,435,{41511,42253,38426},{5,2,2}},
		[55941] = {41554,8,420,430,440,{41511,42253,38426},{5,2,2}},
		[55943] = {41555,8,415,425,435,{41511,42253,38426},{4,2,2}},
		[55993] = {41248,8,400,400,410,{41510,2604},{4,1}},
		[55994] = {41249,8,400,400,410,{41510,6260},{4,1}},
		[55995] = {41251,8,400,400,410,{41510,4341},{4,1}},
		[55996] = {41250,8,400,400,410,{41510,2605},{4,1}},
		[55997] = {41252,8,400,400,410,{41510,2604},{4,1}},
		[55998] = {41253,8,400,400,410,{41510,6260},{4,1}},
		[55999] = {41254,8,400,400,410,{41510,4341},{4,1}},
		[56000] = {41255,8,400,400,410,{41510,2605},{4,1}},
		[56001] = {nil,8,415,425,435,{41511,35625},{1,2}},
		[56002] = {nil,8,415,425,435,{41511,35627},{1,2}},
		[56003] = {nil,8,415,425,435,{41511,36860},{1,2}},
		[56004] = {41597,8,435,440,450,{41593,41595,38426},{4,2,1}},
		[56005] = {41600,8,445,450,460,{41594,41593,38426},{4,4,1}},
		[56006] = {41598,8,440,445,455,{41595,41594,38426},{4,2,1}},
		[56007] = {41599,8,410,430,450,{41511,38426},{6,2}},
		[56008] = {41601,8,400,400,410,{37704,42253},{2,2}},
		[56009] = {41602,8,430,435,445,{35625,42253,43102},{4,4,1}},
		[56010] = {41603,8,400,400,410,{37702,42253},{2,2}},
		[56011] = {41604,8,430,435,445,{36860,42253,43102},{4,4,1}},
		[56014] = {41607,8,390,395,405,{41510,36783},{7,1}},
		[56015] = {41608,8,395,400,410,{41510,36783},{8,1}},
		[56016] = {41609,8,415,435,455,{41511,35625,35622,36784,43102},{5,6,4,1,1}},
		[56017] = {41610,8,420,435,455,{41511,36860,35627,36784,43102},{5,6,4,1,1}},
		[56018] = {41984,8,425,435,445,{41593,41511,42253,38426},{1,6,4,1}},
		[56019] = {41985,8,425,430,450,{41595,41511,38425,42253,38426},{1,5,2,4,1}},
		[56020] = {41986,8,425,430,450,{41595,41511,42253,38426},{1,4,4,1}},
		[56021] = {42093,8,425,435,445,{41594,41511,42253,38426},{1,6,4,1}},
		[56022] = {42095,8,425,430,450,{41594,41511,42253,38426},{1,4,4,1}},
		[56023] = {42096,8,425,430,450,{41594,41511,38425,42253,38426},{1,4,2,4,1}},
		[56024] = {42100,8,450,450,460,{41594,41511,38426,43102},{8,6,1,1}},
		[56025] = {42103,8,440,445,455,{41594,41511,38426,43102},{4,4,1,1}},
		[56026] = {42101,8,450,450,460,{41593,41511,38426,43102},{8,6,1,1}},
		[56027] = {42111,8,440,445,455,{41593,41511,38426,43102},{4,4,1,1}},
		[56028] = {42102,8,450,450,460,{41595,41511,38426,43102},{8,6,1,1}},
		[56029] = {42113,8,440,445,455,{41595,41511,38426,43102},{4,4,1,1}},
		[56030] = {41519,8,380,390,410,{41510,38426},{5,1}},
		[56031] = {41512,8,350,360,380,{41510,38426},{3,1}},
		[56034] = {nil,8,405,405,405,{38426},{1}},
		[56039] = {nil,8,405,405,405,{38426},{1}},
		[56048] = {41544,8,400,400,420,{41520,37703},{1,2}},
		[56049] = {42142,14,370,390,440,{42225},{1}},
		[56052] = {42143,14,370,390,440,{42225},{1}},
		[56053] = {42144,14,370,390,440,{42225},{1}},
		[56054] = {36766,14,370,390,440,{42225},{1}},
		[56055] = {42151,14,370,390,440,{42225},{1}},
		[56056] = {42152,14,370,390,440,{42225},{1}},
		[56074] = {42148,14,370,390,440,{42225},{1}},
		[56076] = {42153,14,370,390,440,{42225},{1}},
		[56077] = {42146,14,370,390,440,{42225},{1}},
		[56079] = {42158,14,370,390,440,{42225},{1}},
		[56081] = {42154,14,370,390,440,{42225},{1}},
		[56083] = {42150,14,370,390,440,{42225},{1}},
		[56084] = {42156,14,370,390,440,{42225},{1}},
		[56085] = {42149,14,370,390,440,{42225},{1}},
		[56086] = {36767,14,370,390,440,{42225},{1}},
		[56087] = {42145,14,370,390,440,{42225},{1}},
		[56088] = {42155,14,370,390,440,{42225},{1}},
		[56089] = {42157,14,370,390,440,{42225},{1}},
		[56193] = {42336,14,350,380,420,{37701,36917},{2,1}},
		[56194] = {42337,14,350,380,420,{37701,36920},{2,1}},
		[56195] = {42338,14,380,400,420,{35624,36929,36932},{1,2,2}},
		[56196] = {42339,14,380,400,420,{35624,36917,36920,36923},{1,1,2,1}},
		[56197] = {42340,14,420,440,460,{41163,36933,34052},{1,1,1}},
		[56199] = {42341,14,400,430,450,{41163,36918,36921},{2,2,1}},
		[56201] = {42395,14,400,430,450,{41163,36927,36930},{2,2,1}},
		[56202] = {42413,14,400,430,450,{41163,36924,36933},{2,2,1}},
		[56203] = {42418,14,400,430,450,{41163,36933,36918},{2,2,1}},
		[56205] = {41367,14,350,360,380,{36932},{1}},
		[56206] = {42420,14,360,370,390,{36926},{1}},
		[56208] = {42421,14,370,380,400,{36926,36932},{1,1}},
		[56234] = {42435,2,440,450,470,{36913,37663,43102},{6,6,2}},
		[56280] = {42443,2,410,415,425,{36913,37705},{15,2}},
		[56349] = {39681,9,350,360,380,{36916},{2}},
		[56357] = {42500,2,420,425,435,{36913,41163},{2,1}},
		[56400] = {42508,2,440,450,470,{36913,37663,43102},{4,3,1}},
		[56459] = {40892,9,375,380,390,{36916},{5}},
		[56460] = {40771,9,350,375,390,{39681,39690},{2,1},3},
		[56461] = {40893,9,375,380,390,{36916},{5}},
		[56462] = {40772,9,435,440,450,{36913,7005,2901,5956},{10,1,1,1}},
		[56463] = {40536,9,375,385,395,{33470,39690},{1,3},5},
		[56464] = {39682,9,375,380,390,{36916,37701},{4,1}},
		[56465] = {41112,9,420,425,440,{36913,33568,35627},{8,2,1}},
		[56466] = {40767,9,420,435,445,{39683,39682,39681},{2,4,2}},
		[56467] = {40865,9,420,435,445,{39683,39682,39681},{2,2,8}},
		[56468] = {44951,9,405,410,420,{36913,39690},{5,1}},
		[56469] = {41121,9,425,430,440,{41163,36913,35622,35623},{2,8,2,2}},
		[56470] = {41146,9,425,430,435,{39683,36920,36921},{1,1,1}},
		[56471] = {39683,9,390,395,405,{36916,37705},{8,1}},
		[56472] = {40768,9,425,430,435,{36913,35623},{8,8}},
		[56473] = {40895,9,425,430,440,{41163,34052,39681},{6,2,2}},
		[56474] = {41164,9,410,405,420,{36913,39690},{1,1},1000},
		[56475] = {41165,9,415,410,425,{36913},{2},1000},
		[56476] = {37567,9,410,415,425,{36913,39681},{12,2},8},
		[56477] = {42546,9,415,420,430,{36913,37705},{12,2},8},
		[56478] = {41167,9,430,435,455,{36913,36927},{10,2}},
		[56479] = {41168,9,450,455,465,{41163,36913,35623,35622,43102,40533},{10,20,15,15,1,1}},
		[56480] = {42549,9,440,450,460,{41163,38425,36924,35624,43102},{8,4,2,4,1}},
		[56481] = {42550,9,440,450,460,{41163,38425,36918,35623,43102},{8,4,2,4,1}},
		[56483] = {42552,9,440,450,460,{41163,38425,36930,36860,43102},{8,4,2,4,1}},
		[56484] = {42553,9,440,450,460,{41163,38425,36918,35627,43102},{8,4,2,4,1}},
		[56486] = {42554,9,440,450,460,{41163,38425,36933,35625,43102},{8,4,2,4,1}},
		[56487] = {42555,9,440,450,460,{41163,38425,36921,35623,43102},{8,4,2,4,1}},
		[56496] = {42642,14,430,450,460,{41163,42225,36860,35627,43102},{2,4,4,4,1}},
		[56497] = {42643,14,430,450,460,{41163,42225,35624,35625,43102},{2,4,4,4,1}},
		[56498] = {42644,14,430,450,460,{41163,42225,35622,35623,43102},{2,4,4,4,1}},
		[56499] = {42645,14,440,450,460,{41163,42225,35623,36860,43102},{2,4,6,6,1}},
		[56500] = {42646,14,440,450,460,{41163,42225,35625,35624,43102},{2,4,6,6,1}},
		[56501] = {42647,14,440,450,460,{41163,42225,35627,35622,43102},{2,4,6,6,1}},
		[56514] = {42641,9,425,425,435,{36913,39690},{1,1},5},
		[56519] = {40109,4,400,415,430,{36901,36905,18256},{1,2,1}},
		[56530] = {42701,14,360,380,420,{36783,34054},{1,1}},
		[56531] = {42702,14,390,410,440,{36784,34054},{1,4}},
		[56549] = {42723,2,420,425,435,{36913,35623},{12,1}},
		[56550] = {42727,2,420,430,450,{36913,35622},{12,1}},
		[56551] = {42729,2,420,430,450,{36913,35622},{12,1}},
		[56552] = {42730,2,420,430,450,{36913,35627},{12,1}},
		[56553] = {42724,2,420,430,450,{36913,36860},{12,1}},
		[56554] = {42726,2,425,435,455,{36913,35623},{14,1}},
		[56555] = {42725,2,425,435,455,{36913,35624},{14,1}},
		[56556] = {42728,2,425,435,455,{36913,35627},{14,1}},
		[56574] = {42551,9,440,450,460,{41163,38425,36927,35622,43102},{8,4,2,4,1}},
		[56943] = {40896,15,350,355,365,{43124,39502},{1,1}},
		[56944] = {40899,15,385,390,405,{43126,39502},{1,1}},
		[56945] = {40914,15,115,120,130,{43116,10648},{1,1}},
		[56946] = {40920,15,385,390,405,{43126,39502},{1,1}},
		[56947] = {40908,15,385,390,405,{43126,39502},{1,1}},
		[56948] = {40919,15,150,155,165,{43118,10648},{1,1}},
		[56949] = {40915,15,385,390,405,{43126,39502},{1,1}},
		[56950] = {40900,15,385,390,405,{43126,39502},{1,1}},
		[56951] = {40923,15,130,135,145,{43116,10648},{1,1}},
		[56952] = {40903,15,310,315,325,{43124,39502},{1,1}},
		[56953] = {40909,15,170,175,185,{43118,10648},{1,1}},
		[56954] = {40912,15,385,390,405,{43126,39502},{1,1}},
		[56955] = {40913,15,80,90,110,{39774,39354},{1,1}},
		[56956] = {40902,15,200,205,215,{43120,10648},{1,1}},
		[56957] = {40901,15,260,265,275,{43122,39501},{1,1}},
		[56958] = {40921,15,385,390,405,{43126,39502},{1,1}},
		[56959] = {40916,15,220,225,235,{43120,39501},{1,1}},
		[56960] = {40906,15,385,390,405,{43126,39502},{1,1}},
		[56961] = {40897,15,90,100,120,{39774,39354},{1,1}},
		[56963] = {40922,15,85,95,115,{39774,39354},{1,1}},
		[56965] = {44922,15,75,355,365,{39502,43126},{1,1}},
		[56968] = {42734,15,100,105,115,{43116,39354},{1,1}},
		[56971] = {42735,15,115,120,130,{43116,10648},{1,1}},
		[56972] = {42736,15,335,340,350,{43124,39502},{1,1}},
		[56973] = {42737,15,130,135,145,{43116,10648},{1,1}},
		[56974] = {42738,15,155,160,170,{43118,10648},{1,1}},
		[56975] = {42739,15,385,390,405,{43126,39502},{1,1}},
		[56976] = {42741,15,80,90,110,{39774,39354},{1,1}},
		[56977] = {42742,15,385,390,405,{43126,39502},{1,1}},
		[56978] = {42743,15,90,100,120,{39774,39354},{1,1}},
		[56979] = {42744,15,225,230,240,{43120,39501},{1,1}},
		[56980] = {42745,15,375,380,390,{43126,39502},{1,1}},
		[56981] = {42746,15,175,180,190,{43118,10648},{1,1}},
		[56982] = {42747,15,205,210,220,{43120,39501},{1,1}},
		[56983] = {42748,15,385,390,405,{43126,39502},{1,1}},
		[56984] = {42749,15,325,330,340,{43124,39502},{1,1}},
		[56985] = {42750,15,280,285,295,{43122,39501},{1,1}},
		[56986] = {42751,15,385,390,405,{43126,39502},{1,1}},
		[56987] = {42752,15,400,390,405,{43126,39502},{1,1}},
		[56988] = {42753,15,385,390,405,{43126,39502},{1,1}},
		[56989] = {42754,15,385,390,405,{43126,39502},{1,1}},
		[56990] = {44920,15,75,355,365,{39502,43126},{1,1}},
		[56991] = {44955,15,315,320,330,{43124,39502},{1,1}},
		[56994] = {42897,15,175,180,190,{43118,10648},{1,1}},
		[56995] = {42898,15,100,105,115,{43116,39354},{1,1}},
		[56996] = {42899,15,385,390,405,{43126,39502},{1,1}},
		[56997] = {42900,15,115,120,130,{43116,10648},{1,1}},
		[56998] = {42901,15,385,390,405,{43126,39502},{1,1}},
		[56999] = {42902,15,385,390,405,{43126,39502},{1,1}},
		[57000] = {42903,15,200,205,215,{43120,10648},{1,1}},
		[57001] = {42904,15,225,230,240,{43120,39501},{1,1}},
		[57002] = {42905,15,260,265,275,{43122,39501},{1,1}},
		[57003] = {42906,15,350,355,365,{43124,39502},{1,1}},
		[57004] = {42907,15,80,90,110,{39774,39354},{1,1}},
		[57005] = {42908,15,130,135,145,{43116,10648},{1,1}},
		[57006] = {42909,15,375,380,390,{43126,39502},{1,1}},
		[57007] = {42910,15,150,155,165,{43118,10648},{1,1}},
		[57008] = {42911,15,315,320,330,{43124,39502},{1,1}},
		[57009] = {42912,15,90,100,120,{39774,39354},{1,1}},
		[57010] = {42913,15,385,390,405,{43126,39502},{1,1}},
		[57011] = {42914,15,385,390,405,{43126,39502},{1,1}},
		[57012] = {42915,15,385,390,405,{43126,39502},{1,1}},
		[57013] = {42916,15,385,390,405,{43126,39502},{1,1}},
		[57014] = {42917,15,385,390,405,{43126,39502},{1,1}},
		[57019] = {41101,15,385,390,405,{43126,39502},{1,1}},
		[57020] = {41104,15,180,185,195,{43118,10648},{1,1}},
		[57021] = {41107,15,385,390,405,{43126,39502},{1,1}},
		[57022] = {41096,15,80,90,110,{39774,39354},{1,1}},
		[57023] = {41099,15,205,210,220,{43120,39501},{1,1}},
		[57024] = {41098,15,230,235,245,{43120,39501},{1,1}},
		[57025] = {41103,15,265,270,280,{43122,39501},{1,1}},
		[57026] = {41105,15,300,305,315,{43124,39501},{1,1}},
		[57027] = {41095,15,90,100,120,{39774,39354},{1,1}},
		[57028] = {41097,15,385,390,405,{43126,39502},{1,1}},
		[57029] = {41106,15,105,110,120,{43116,10648},{1,1}},
		[57030] = {41092,15,120,125,135,{43116,10648},{1,1}},
		[57031] = {41108,15,135,140,150,{43116,10648},{1,1}},
		[57032] = {41100,15,155,160,170,{43118,10648},{1,1}},
		[57033] = {41094,15,335,340,350,{43124,39502},{1,1}},
		[57034] = {41110,15,385,390,405,{43126,39502},{1,1}},
		[57035] = {41109,15,385,390,405,{43126,39502},{1,1}},
		[57036] = {41102,15,375,380,390,{43126,39502},{1,1}},
		[57112] = {42954,15,385,390,405,{43126,39502},{1,1}},

		[405005] = {204385,15,385,390,405,{43126,39502},{1,1}},
		[413897] = {206580,15,385,390,405,{43126,39502},{1,1}},
		[414813] = {206953,15,385,390,405,{43126,39502},{1,1}},
		[57113] = {42955,15,340,345,355,{43124,39502},{1,1}},
		[57114] = {42956,15,80,90,110,{39774,39354},{1,1}},
		[57115] = {42957,15,385,390,405,{43126,39502},{1,1}},
		[57116] = {42958,15,385,390,405,{43126,39502},{1,1}},
		[57117] = {42959,15,385,390,405,{43126,39502},{1,1}},
		[57119] = {42960,15,95,105,125,{39774,39354},{1,1}},
		[57120] = {42961,15,105,110,120,{43116,10648},{1,1}},
		[57121] = {42962,15,120,125,135,{43116,10648},{1,1}},
		[57122] = {42963,15,305,310,320,{43124,39501},{1,1}},
		[57123] = {42964,15,135,140,150,{43116,10648},{1,1}},
		[57124] = {42965,15,385,390,405,{43126,39502},{1,1}},
		[57125] = {42966,15,160,165,175,{43118,10648},{1,1}},
		[57126] = {42967,15,385,390,405,{43126,39502},{1,1}},
		[57127] = {42968,15,385,390,405,{43126,39502},{1,1}},
		[57128] = {42969,15,385,390,405,{43126,39502},{1,1}},
		[57129] = {42970,15,185,190,200,{43118,10648},{1,1}},
		[57130] = {42971,15,385,390,405,{43126,39502},{1,1}},
		[57131] = {42972,15,210,215,225,{43120,39501},{1,1}},
		[57132] = {42973,15,235,240,250,{43120,39501},{1,1}},
		[57133] = {42974,15,285,290,300,{43122,39501},{1,1}},
		[57151] = {43420,15,220,225,235,{43120,39501},{1,1}},
		[57152] = {43425,15,385,390,405,{43126,39502},{1,1}},
		[57153] = {43412,15,385,390,405,{43126,39502},{1,1}},
		[57154] = {43414,15,240,245,255,{43120,39501},{1,1}},
		[57155] = {43415,15,385,390,405,{43126,39502},{1,1}},
		[57156] = {43416,15,285,290,300,{43122,39501},{1,1}},
		[57157] = {43417,15,125,130,140,{43116,10648},{1,1}},
		[57158] = {43418,15,95,105,125,{39774,39354},{1,1}},
		[57159] = {43419,15,385,390,405,{43126,39502},{1,1}},
		[57160] = {43421,15,385,390,405,{43126,39502},{1,1}},
		[57161] = {43422,15,170,175,185,{43118,10648},{1,1}},
		[57162] = {43413,15,85,95,115,{39774,39354},{1,1}},
		[57163] = {43423,15,110,115,125,{43116,10648},{1,1}},
		[57164] = {43430,15,385,390,405,{43126,39502},{1,1}},
		[57165] = {43424,15,190,195,205,{43118,10648},{1,1}},
		[57166] = {43426,15,385,390,405,{43126,39502},{1,1}},
		[57167] = {43427,15,140,145,155,{43116,10648},{1,1}},
		[57168] = {43428,15,320,325,335,{43124,39502},{1,1}},
		[57169] = {43429,15,385,390,405,{43126,39502},{1,1}},
		[57170] = {43431,15,385,390,405,{43126,39502},{1,1}},
		[57172] = {43432,15,345,350,360,{43124,39502},{1,1}},
		[57181] = {42396,15,385,390,405,{43126,39502},{1,1}},
		[57183] = {42397,15,230,235,245,{43120,39501},{1,1}},
		[57184] = {42398,15,105,110,120,{43116,10648},{1,1}},
		[57185] = {42399,15,270,275,285,{43122,39501},{1,1}},
		[57186] = {42400,15,120,125,135,{43116,10648},{1,1}},
		[57187] = {42401,15,315,320,330,{43124,39502},{1,1}},
		[57188] = {42402,15,135,140,150,{43116,10648},{1,1}},
		[57189] = {42403,15,385,390,405,{43126,39502},{1,1}},
		[57190] = {42404,15,385,390,405,{43126,39502},{1,1}},
		[57191] = {42405,15,385,390,405,{43126,39502},{1,1}},
		[57192] = {42406,15,350,355,365,{43124,39502},{1,1}},
		[57193] = {42407,15,385,390,405,{43126,39502},{1,1}},
		[57194] = {42408,15,80,90,110,{39774,39354},{1,1}},
		[57195] = {42409,15,385,390,405,{43126,39502},{1,1}},
		[57196] = {42410,15,95,105,125,{39774,39354},{1,1}},
		[57197] = {42411,15,160,165,175,{43118,10648},{1,1}},
		[57198] = {42412,15,375,380,390,{43126,39502},{1,1}},
		[57199] = {42414,15,385,390,405,{43126,39502},{1,1}},
		[57200] = {42415,15,180,185,195,{43118,10648},{1,1}},
		[57201] = {42416,15,210,215,225,{43120,39501},{1,1}},
		[57202] = {42417,15,385,390,405,{43126,39502},{1,1}},
		[57207] = {43533,15,385,390,405,{43126,39502},{1,1}},
		[57208] = {43534,15,385,390,405,{43126,39502},{1,1}},
		[57209] = {43535,15,75,330,340,{43124,39502},{1,1}},
		[57210] = {43536,15,265,270,280,{43122,39501},{1,1}},
		[57211] = {43537,15,385,390,405,{43126,39502},{1,1}},
		[57212] = {43538,15,385,390,405,{43126,39502},{1,1}},
		[57213] = {43541,15,285,290,300,{43122,39501},{1,1}},
		[57214] = {43542,15,385,390,405,{43126,39502},{1,1}},
		[57215] = {43539,15,75,305,315,{43124,39501},{1,1}},
		[57216] = {43543,15,270,275,285,{43122,39501},{1,1}},
		[57217] = {43544,15,75,330,340,{43124,39502},{1,1}},
		[57218] = {43545,15,385,390,405,{43126,39502},{1,1}},
		[57219] = {43546,15,280,285,295,{43122,39501},{1,1}},
		[57220] = {43547,15,385,390,405,{43126,39502},{1,1}},
		[57221] = {43548,15,300,305,315,{43124,39501},{1,1}},
		[57222] = {43549,15,350,355,365,{43124,39502},{1,1}},
		[57223] = {43550,15,385,390,405,{43126,39502},{1,1}},
		[57224] = {43551,15,330,335,345,{43124,39502},{1,1}},
		[57225] = {43552,15,375,380,390,{43126,39502},{1,1}},
		[57226] = {43553,15,305,310,320,{43124,39502},{1,1}},
		[57227] = {43554,15,345,350,360,{43124,39502},{1,1}},
		[57228] = {43673,15,75,305,315,{43124,39501},{1,1}},
		[57229] = {43671,15,75,305,315,{43124,39501},{1,1}},
		[57230] = {43672,15,75,305,315,{43124,39501},{1,1}},
		[57231] = {42897,15,450,0,0,{39469,785,39354,10648,39501,39502},{1,1,1,1,1,1}},
		[57232] = {41517,15,385,390,405,{43126,39502},{1,1}},
		[57233] = {41518,15,385,390,405,{43126,39502},{1,1}},
		[57234] = {41524,15,385,390,400,{43126,39502},{1,1}},
		[57235] = {41526,15,385,390,405,{43126,39502},{1,1}},
		[57236] = {41527,15,300,305,315,{43124,39501},{1,1}},
		[57237] = {41529,15,385,390,405,{43126,39502},{1,1}},
		[57238] = {41530,15,110,115,125,{43116,10648},{1,1}},
		[57239] = {41531,15,85,95,115,{39774,39354},{1,1}},
		[57240] = {41532,15,125,130,140,{43116,10648},{1,1}},
		[57241] = {41547,15,185,190,200,{43118,10648},{1,1}},
		[57242] = {41533,15,215,220,230,{43120,39501},{1,1}},
		[57243] = {41534,15,385,390,405,{43126,39502},{1,1}},
		[57244] = {41535,15,235,240,250,{43120,39501},{1,1}},
		[57245] = {41536,15,140,145,155,{43116,10648},{1,1}},
		[57246] = {41537,15,95,105,125,{39774,39354},{1,1}},
		[57247] = {41538,15,385,390,405,{43126,39502},{1,1}},
		[57248] = {41539,15,375,380,390,{43126,39502},{1,1}},
		[57249] = {41540,15,165,170,180,{43118,10648},{1,1}},
		[57250] = {41552,15,385,390,405,{43126,39502},{1,1}},
		[57251] = {41541,15,275,280,290,{43122,39501},{1,1}},
		[57252] = {41542,15,330,335,345,{43124,39502},{1,1}},
		[57253] = {44923,15,75,355,365,{39502,43126},{1,1}},
		[57257] = {42453,15,350,355,365,{43124,39502},{1,1}},
		[57258] = {42454,15,385,390,405,{43126,39502},{1,1}},
		[57259] = {42455,15,85,95,115,{39774,39354},{1,1}},
		[57260] = {42456,15,385,390,405,{43126,39502},{1,1}},
		[57261] = {42457,15,385,390,405,{43126,39502},{1,1}},
		[57262] = {42458,15,125,130,140,{43116,10648},{1,1}},
		[57263] = {42459,15,385,390,405,{43126,39502},{1,1}},
		[57264] = {42460,15,385,390,405,{43126,39502},{1,1}},
		[57265] = {42461,15,110,115,125,{43116,10648},{1,1}},
		[57266] = {42462,15,95,105,125,{39774,39354},{1,1}},
		[57267] = {42463,15,385,390,405,{43126,39502},{1,1}},
		[57268] = {42464,15,385,390,405,{43126,39502},{1,1}},
		[57269] = {42465,15,140,145,155,{43116,10648},{1,1}},
		[57270] = {42466,15,215,220,230,{43120,39501},{1,1}},
		[57271] = {42467,15,165,170,180,{43118,10648},{1,1}},
		[57272] = {42468,15,275,280,290,{43122,39501},{1,1}},
		[57273] = {42469,15,385,390,405,{43126,39502},{1,1}},
		[57274] = {42470,15,240,245,255,{43120,39501},{1,1}},
		[57275] = {42471,15,325,330,340,{43124,39502},{1,1}},
		[57276] = {42472,15,385,390,405,{43126,39502},{1,1}},
		[57277] = {42473,15,190,195,205,{43118,10648},{1,1}},
		[57421] = {34747,6,350,350,380,{43013},{1}},
		[57423] = {43015,6,450,455,465,{41806,41809,41813,43007},{2,2,2,1}},
		[57425] = {41266,4,430,440,450,{36917,36923,35623},{1,1,1}},
		[57427] = {41334,4,425,435,445,{36932,36929,36860},{1,1,1}},
		[57433] = {42993,6,400,425,475,{41810,43007},{1,1}},
		[57434] = {42994,6,400,425,475,{43010,43012,43007},{1,1,1}},
		[57435] = {43004,6,400,425,475,{43013,43007},{2,1},4},
		[57436] = {42995,6,400,425,475,{43012,43007},{1,1}},
		[57437] = {42996,6,400,425,475,{41808,43007},{3,1}},
		[57438] = {42997,6,400,425,475,{43011,43007},{1,1}},
		[57439] = {42998,6,400,425,475,{41801,43007},{1,1}},
		[57440] = {43005,6,400,425,475,{34736,43007},{1,1}},
		[57441] = {42999,6,400,425,475,{41807,43007},{1,1}},
		[57442] = {43000,6,400,425,475,{41807,43007},{1,1}},
		[57443] = {43001,6,400,425,475,{43009,43007},{1,1}},
		[57683] = {nil,3,400,425,435,{44128},{1}},
		[57690] = {nil,3,400,425,435,{44128},{1}},
		[57691] = {nil,3,400,425,435,{44128},{1}},
		[57692] = {nil,3,400,425,435,{44128},{1}},
		[57694] = {nil,3,400,425,435,{44128},{1}},
		[57696] = {nil,3,400,425,435,{44128},{1}},
		[57699] = {nil,3,400,425,435,{44128},{1}},
		[57701] = {nil,3,400,425,435,{44128},{1}},
		[57703] = {43115,15,85,85,95,{43103},{1}},
		[57704] = {43116,15,100,95,105,{39338},{2}},
		[57706] = {43117,15,125,125,135,{43104},{1}},
		[57707] = {43118,15,150,145,155,{39339},{2}},
		[57708] = {43119,15,175,170,180,{43105},{1}},
		[57709] = {43120,15,200,195,205,{39340},{2}},
		[57710] = {43121,15,225,220,230,{43106},{1}},
		[57711] = {43122,15,250,245,255,{39341},{2}},
		[57712] = {43123,15,275,290,300,{43107},{1}},
		[57713] = {43124,15,290,295,305,{39342},{2}},
		[57714] = {43125,15,325,320,330,{43108},{1}},


		[57715] = {43126,15,350,345,355,{39343},{2}},
		[57716] = {43127,15,375,370,380,{43109},{2}},
		[57719] = {42740,15,385,390,405,{43126,39502},{1,1}},
		[58065] = {43268,6,350,350,415,{36782},{2}},
		[58141] = {43244,14,350,380,420,{37701,36929},{2,1}},
		[58142] = {43245,14,350,380,420,{37701,36923},{2,1}},
		[58143] = {43246,14,370,390,420,{35624,36926},{1,2}},
		[58144] = {43247,14,370,390,420,{35624,36932},{1,2}},
		[58145] = {43248,14,390,410,430,{35624},{2}},
		[58146] = {43249,14,390,410,430,{35624,35627},{1,1}},
		[58147] = {43250,14,420,440,460,{41163,35624},{2,2}},
		[58148] = {43251,14,420,440,460,{41163,35627,36918},{2,3,1}},
		[58149] = {43252,14,420,440,460,{41163,35623,36860},{2,1,2}},
		[58150] = {43253,14,420,440,460,{41163,35622,36783},{2,1,4}},
		[58286] = {43316,15,75,105,115,{43116,39354},{1,1}},
		[58287] = {43334,15,75,155,165,{43118,10648},{1,1}},
		[58288] = {43331,15,75,105,115,{43116,39354},{1,1}},
		[58289] = {43332,15,75,80,90,{39774,39354},{1,1}},
		[58296] = {43335,15,75,80,90,{39774,39354},{1,1}},
		[58297] = {43355,15,75,205,215,{43120,10648},{1,1}},
		[58298] = {43356,15,75,80,90,{39774,39354},{1,1}},
		[58299] = {43338,15,75,80,90,{39774,39354},{1,1}},
		[58300] = {43354,15,75,80,90,{39774,39354},{1,1}},
		[58301] = {43350,15,75,80,90,{39774,39354},{1,1}},
		[58302] = {43351,15,75,155,165,{43118,10648},{1,1}},
		[58303] = {43339,15,75,80,90,{39774,39354},{1,1}},
		[58305] = {43357,15,75,105,115,{43116,39354},{1,1}},
		[58306] = {43359,15,75,80,90,{39774,39354},{1,1}},
		[58307] = {43360,15,75,130,140,{43116,10648},{1,1}},
		[58308] = {43364,15,75,80,90,{39774,39354},{1,1}},
		[58310] = {43361,15,75,80,90,{39774,39354},{1,1}},
		[58311] = {43365,15,75,105,115,{43116,39354},{1,1}},
		[58312] = {43366,15,75,80,90,{39774,39354},{1,1}},
		[58313] = {43367,15,75,80,90,{39774,39354},{1,1}},
		[58314] = {43340,15,75,80,90,{39774,39354},{1,1}},
		[58315] = {43368,15,75,105,115,{43116,39354},{1,1}},
		[58316] = {43369,15,75,155,165,{43118,10648},{1,1}},
		[58317] = {43342,15,75,80,90,{39774,39354},{1,1}},
		[58318] = {43371,15,75,80,90,{39774,39354},{1,1}},
		[58319] = {43370,15,75,180,190,{43118,10648},{1,1}},
		[58320] = {43373,15,75,105,115,{43116,39354},{1,1}},
		[58321] = {43372,15,75,155,165,{43118,10648},{1,1}},
		[58322] = {43374,15,75,355,365,{43126,39502},{1,1}},
		[58323] = {43379,15,75,80,90,{39774,39354},{1,1}},
		[58324] = {43376,15,75,130,140,{43116,10648},{1,1}},
		[58325] = {43377,15,75,105,115,{43116,39354},{1,1}},
		[58326] = {43343,15,75,80,90,{39774,39354},{1,1}},
		[1282130] = {268295,15,390,395,4,{43126,39502},{1,1}},
		[58327] = {43378,15,75,205,215,{43120,10648},{1,1}},
		[58328] = {43380,15,75,130,140,{43116,10648},{1,1}},
		[58329] = {43381,15,75,155,165,{43118,10648},{1,1}},
		[58330] = {43385,15,75,155,165,{43118,10648},{1,1}},
		[58331] = {43344,15,75,130,140,{43116,10648},{1,1}},
		[58332] = {43386,15,75,105,115,{43116,39354},{1,1}},
		[58333] = {43388,15,75,155,165,{43118,10648},{1,1}},
		[58336] = {43389,15,75,105,115,{43116,39354},{1,1}},
		[58337] = {43390,15,75,80,90,{39774,39354},{1,1}},
		[58338] = {43392,15,75,155,165,{43118,10648},{1,1}},
		[58339] = {43393,15,75,155,165,{43118,10648},{1,1}},
		[58340] = {43391,15,75,130,140,{43116,10648},{1,1}},
		[58341] = {43394,15,75,355,365,{43126,39502},{1,1}},
		[58342] = {43395,15,75,80,90,{39774,39354},{1,1}},
		[58343] = {43396,15,75,80,90,{39774,39354},{1,1}},
		[58344] = {43397,15,75,80,90,{39774,39354},{1,1}},
		[58345] = {43398,15,75,105,115,{43116,39354},{1,1}},
		[58346] = {43399,15,75,80,90,{39774,39354},{1,1}},
		[58347] = {43400,15,75,330,340,{43124,39502},{1,1}},
		[58472] = {3012,15,15,35,45,{37101,39354},{2,1}},
		[58473] = {1477,15,85,85,95,{39774,39354},{1,1}},
		[58476] = {4425,15,175,180,190,{43118,10648},{1,2},5},
		[58478] = {10309,15,225,230,240,{43120,39501},{1,2},2},
		[58480] = {27498,15,270,275,285,{43122,39501},{1,2},2},
		[58481] = {33457,15,310,320,330,{43124,39501},{1,2},2},
		[58482] = {43463,15,370,375,385,{43126,39502},{1,2},2},
		[58483] = {43464,15,420,425,435,{43126,39502},{1,2},2},
		[58484] = {954,15,15,35,45,{37101,39354},{2,1}},
		[58485] = {2289,15,80,80,90,{39774,39354},{1,1}},
		[58486] = {4426,15,170,175,185,{43118,10648},{1,2},5},
		[58487] = {10310,15,220,225,235,{43120,39501},{1,2},2},
		[58488] = {27503,15,265,270,280,{43122,39501},{1,2},2},
		[58489] = {33462,15,305,315,325,{43124,39501},{1,2},2},
		[58490] = {43465,15,365,370,380,{43126,39502},{1,2},2},
		[58491] = {43466,15,415,420,430,{43126,39502},{1,2},2},
		[58492] = {43482,14,420,440,460,{41163,36860},{4,4}},
		[58507] = {43498,14,420,440,460,{41163,36860},{4,4}},
		[58512] = {43490,6,350,350,365,{30817,43501},{2,1},5},
		[58521] = {43488,6,350,350,365,{34736},{1},5},
		[58523] = {43491,6,350,350,365,{36782,22577},{1,1},5},
		[58525] = {43492,6,350,350,365,{41810,12808},{1,1},5},
		[58527] = {43478,6,425,435,475,{41800,34736,41803,43007},{2,2,2,1}},
		[58528] = {43480,6,425,435,475,{41813,43012,41809,43007},{2,2,2,1}},
		[58565] = {43515,15,110,125,150,{39354,43115,39774},{10,5,2}},
		[58868] = {43570,4,410,415,420,{33448,40411},{10,1}},
		[58871] = {43569,4,410,410,415,{33447,40411},{10,1}},
		[58954] = {43582,14,420,440,460,{41163,35622,36860,43102},{2,3,3,1}},
		[59315] = {43674,15,75,155,165,{43118,10648},{1,1}},
		[59326] = {43725,15,75,105,115,{43116,39354},{1,1}},
		[59338] = {43825,15,310,315,325,{43124,39502},{1,1}},
		[59339] = {43826,15,320,325,335,{43124,39502},{1,1}},
		[59340] = {43827,15,340,345,355,{43124,39502},{1,1}},
		[59387] = {43850,15,200,205,215,{43120,10648},{2,1}},
		[59405] = {43854,2,350,360,370,{36916},{4},10},
		[59406] = {43853,2,430,435,445,{36913,41163},{4,1},20},
		[59436] = {43860,2,395,400,410,{36916,36913},{6,5}},
		[59438] = {43864,2,400,405,415,{36916,36913},{3,8}},
		[59440] = {43865,2,405,410,420,{36913},{12}},
		[59441] = {43870,2,415,420,430,{36913,37705},{14,1}},
		[59442] = {43871,2,410,415,425,{36913,37702},{15,2}},
		[59475] = {43654,15,125,150,175,{43117,10648,43116},{5,10,2}},
		[59478] = {43655,15,125,150,175,{43117,10648,43116},{5,10,2}},
		[59480] = {44142,15,125,150,175,{43117,10648,43116},{2,1,1}},
		[59484] = {43656,15,175,200,210,{43119,10648,43118},{5,10,2}},
		[59486] = {43657,15,175,200,210,{43119,10648,43118},{5,10,2}},
		[59487] = {44161,15,175,200,210,{43119,10648,43118},{2,1,1}},
		[59488] = {39350,15,235,250,260,{43121,39501,43120},{1,2,1},2},
		[59489] = {43660,15,225,240,250,{43121,39501,43120},{5,10,2}},
		[59490] = {43661,15,225,240,250,{43121,43120,39501},{5,2,10}},
		[59491] = {44163,15,225,240,250,{43121,39501,43120},{2,1,1}},
		[59493] = {43663,15,275,290,300,{43123,39501,43122},{8,1,4}},
		[59494] = {43664,15,275,290,300,{43123,39501,43122},{8,10,4}},
		[59495] = {43666,15,325,340,350,{43125,39502,43124},{6,10,3}},
		[59496] = {43667,15,325,340,350,{43125,39502,43124},{6,10,3}},
		[59497] = {38322,15,400,425,450,{43127,39502,43102,43126},{5,10,1,2}},
		[59498] = {44210,15,400,425,450,{43127,39502,43102,43126},{5,10,1,2}},
		[59499] = {37602,15,200,210,220,{43120,10648},{1,2},2},
		[59500] = {43145,15,350,355,385,{43126,39502},{1,2},2},
		[59501] = {43146,15,400,405,415,{43126,39502},{3,2},2},
		[59502] = {44316,15,275,290,300,{43123,39501,43122},{5,1,2}},
		[59503] = {44317,15,325,350,380,{43125,39502,21886,43124},{3,1,3,1}},
		[59504] = {44318,15,400,450,475,{39502,43127,35625,43126},{1,6,3,3}},
		[59559] = {43867,15,385,390,405,{43126,39502},{1,1}},
		[59560] = {43868,15,385,390,405,{43126,39502},{1,1}},
		[59561] = {43869,15,385,390,405,{43126,39502},{1,1}},
		[59582] = {43969,8,415,425,445,{41511,37702,37701,38426},{3,3,3,2}},
		[59583] = {43974,8,415,425,445,{41511,37702,37701,38426},{3,3,3,2}},
		[59584] = {43973,8,420,430,450,{41511,37702,37701,38426},{3,4,4,2}},
		[59585] = {43970,8,420,430,450,{41511,37702,37701,38426},{3,4,4,2}},
		[59586] = {41516,8,420,430,450,{41511,37702,37701,38426},{3,4,4,2}},
		[59587] = {43972,8,420,430,450,{41511,37702,37701,38426},{4,5,5,2}},
		[59588] = {43975,8,420,430,450,{41511,37702,37701,38426},{4,5,5,2}},
		[59589] = {43971,8,420,430,450,{41511,37702,37701,38426},{4,5,5,2}},
		[59619] = {44497,10,440,450,470,{34054,34055,34052,34057},{20,4,4,6}},
		[59621] = {44493,10,440,450,470,{34054,34055,34052,34057},{12,4,4,10}},
		[59625] = {43987,10,440,450,470,{34055,34052,34057},{6,6,6}},
		[59636] = {nil,10,400,400,415,{34054,34055},{8,1}},
		[59759] = {44063,14,400,430,450,{41163,36930,36933},{2,2,1}},
		[60336] = {44314,15,200,215,225,{10648,43120},{1,1}},
		[60337] = {44315,15,350,345,355,{43126,39502},{1,1}},
		[60350] = {41163,4,395,420,440,{36913},{8}},
		[60354] = {44325,4,400,415,430,{36904,36907,18256},{2,1,1}},
		[60355] = {44327,4,400,415,430,{36901,36903,18256},{1,2,1}},
		[60356] = {44328,4,400,415,430,{36906,37704,18256},{2,1,1}},
		[60357] = {44329,4,400,415,430,{36901,36903,18256},{1,2,1}},
		[60365] = {44330,4,400,415,430,{36904,18256},{2,1}},
		[60366] = {44331,4,400,415,430,{37921,37704,18256},{1,1,1}},
		[60367] = {44332,4,395,400,415,{37921,36907,18256},{2,1,1}},
		[60396] = {44322,4,400,420,430,{36901,35625,36908},{20,2,1}},
		[60403] = {44323,4,400,420,430,{37921,40195,36908},{20,12,1}},
		[60405] = {44324,4,400,420,430,{36903,36904,36908},{15,15,1}},
		[60583] = {nil,3,405,400,410,{38561},{2}},
		[60584] = {nil,3,400,395,405,{38558},{2}},
		[60599] = {38436,3,385,400,420,{33568},{12}},
		[60600] = {38440,3,385,400,420,{33568},{14}},
		[60601] = {44436,3,395,410,430,{38425,37705},{4,5}},
		[60604] = {44437,3,395,410,430,{38425,37705},{6,4}},
		[60605] = {44438,3,400,415,435,{38557},{35}},
		[60606] = {44449,10,375,385,405,{34054,34056},{4,4}},
		[60607] = {38434,3,385,400,420,{33568},{12}},
		[60608] = {38438,3,385,400,420,{33568},{14}},
		[60609] = {44456,10,350,360,380,{34054},{6}},
		[60611] = {44440,3,395,410,430,{38425,37703},{4,5}},
		[60613] = {44441,3,395,410,430,{38425,37703},{6,4}},
		[60616] = {38971,10,360,370,390,{34054},{6}},
		[60619] = {44452,10,425,435,455,{41745,34054,34055,34052,22463},{1,40,12,8,1}},
		[60620] = {44442,3,400,415,435,{38558},{35}},
		[60621] = {44453,10,380,390,410,{34054,34056},{2,4}},
		[60622] = {38435,3,385,400,420,{33568},{12}},
		[60623] = {38986,10,385,395,415,{34054,37705},{8,1}},
		[60624] = {38439,3,385,400,420,{33568},{14}},
		[60627] = {44443,3,395,410,430,{38425,37705},{4,5}},
		[60629] = {44444,3,395,410,430,{38425,37705},{6,4}},
		[60630] = {44445,3,400,415,435,{38557,37703},{30,2}},
		[60631] = {38441,3,380,390,410,{33568,37700},{16,4}},
		[60637] = {43566,3,440,450,460,{44128,36860,35627,43102},{2,6,4,1}},
		[60640] = {43565,3,440,450,460,{44128,38558,43102},{2,40,1}},
		[60643] = {44446,3,415,420,425,{38425},{8}},
		[60645] = {44447,3,415,420,425,{38557,38425},{20,2}},
		[60647] = {44448,3,415,420,425,{38558,38425},{20,2}},
		[60649] = {43129,3,425,430,440,{38425,35623},{15,1}},
		[60651] = {43130,3,420,425,435,{38425,36860},{12,2}},
		[60652] = {43131,3,420,425,435,{38557},{40}},
		[60653] = {44455,10,395,405,425,{34054},{12}},
		[60655] = {43132,3,425,430,440,{38425,35627},{14,2}},
		[60658] = {43133,3,420,425,435,{38425,35627},{10,2}},
		[60660] = {42731,3,425,430,440,{38425,35623},{12,2}},
		[60663] = {44457,10,420,430,450,{34054,34055,34052},{8,2,2}},
		[60665] = {43255,3,420,425,435,{38425,35622},{10,2}},
		[60666] = {43256,3,420,425,435,{38561},{40}},
		[60668] = {44458,10,425,435,455,{34054,34055,34052},{20,4,1}},
		[60669] = {43257,3,425,430,440,{38425},{25}},
		[60671] = {43258,3,420,425,435,{38558},{30}},
		[60691] = {44463,10,430,440,460,{34054,34055,34057},{40,6,6}},
		[60692] = {44465,10,440,450,470,{34052,34057},{4,4}},
		[60697] = {43260,3,420,425,435,{38425,35623},{12,1}},
		[60702] = {43433,3,420,425,435,{38425,35623},{10,1}},
		[60703] = {43434,3,420,425,435,{38425,35623},{12,1}},
		[60704] = {43435,3,420,425,435,{38425,35623},{8,1}},
		[60705] = {43436,3,425,430,440,{38425,35623},{10,1}},
		[60706] = {43437,3,425,430,440,{38425,35623},{10,1}},
		[60707] = {44466,10,435,445,465,{34054,34055,34052,34057},{10,2,2,4}},
		[60711] = {43438,3,425,430,440,{38425,35623},{12,1}},
		[60712] = {43439,3,425,430,440,{38425,35623},{10,1}},
		[60714] = {44467,10,435,445,465,{34054,34052,34057},{30,6,6}},
		[60715] = {43261,3,420,425,435,{38425,35622},{12,1}},
		[60716] = {43262,3,420,425,435,{38425,35622},{10,1}},
		[60718] = {43263,3,420,425,435,{38425,35622},{12,1}},
		[60720] = {43264,3,420,425,435,{38425,35622},{8,1}},
		[60721] = {43265,3,425,430,440,{38425,35622},{10,1}},
		[60723] = {43266,3,425,430,440,{38425,35622},{10,1}},
		[60725] = {43271,3,425,430,440,{38425,35622},{12,1}},
		[60727] = {43273,3,425,430,440,{38425,35622},{10,1}},
		[60728] = {43447,3,420,425,435,{38425,35623},{12,1}},
		[60729] = {43449,3,420,425,435,{38425,35623},{10,1}},
		[60730] = {43445,3,420,425,435,{38425,35623},{12,1}},
		[60731] = {43444,3,420,425,435,{38425,35623},{8,1}},
		[60732] = {43446,3,425,430,440,{38425,35623},{10,1}},
		[60734] = {43442,3,425,430,440,{38425,35623},{10,1}},
		[60735] = {43448,3,425,430,440,{38425,35623},{12,1}},
		[60737] = {43443,3,425,430,440,{38425,35623},{10,1}},
		[60743] = {43455,3,420,425,435,{38425,35622},{12,1}},
		[60746] = {43457,3,420,425,435,{38425,35622},{10,1}},
		[60747] = {43453,3,420,425,435,{38425,35622},{12,1}},
		[60748] = {43452,3,420,425,435,{38425,35622},{8,1}},
		[60749] = {43454,3,425,430,440,{38425,35622},{10,1}},
		[60750] = {43450,3,425,430,440,{38425,35622},{10,1}},
		[60751] = {43456,3,425,430,440,{38425,35622},{12,1}},
		[60752] = {43451,3,425,430,440,{38425,35622},{10,1}},
		[60754] = {43458,3,440,450,460,{38425,35622,35623,43102},{12,6,6,1}},
		[60755] = {43459,3,440,450,460,{38425,35622,35623,43102},{10,5,5,1}},
		[60756] = {43461,3,440,450,460,{38425,35622,43102},{12,12,1}},
		[60757] = {43469,3,440,450,460,{38425,35622,43102},{10,10,1}},
		[60758] = {43481,3,440,450,460,{38425,36860,35627,43102},{10,6,6,1}},
		[60759] = {43484,3,440,450,460,{38425,36860,35627,43102},{10,5,5,1}},
		[60760] = {43495,3,440,450,460,{38425,35625,35622,43102},{12,6,6,1}},
		[60761] = {43502,3,440,450,460,{38425,35625,35622,43102},{10,5,5,1}},
		[60763] = {44469,10,440,450,470,{34055,34052},{4,4}},
		[60767] = {44470,10,440,450,470,{34054,34055,34052},{6,6,1}},
		[60866] = {41508,9,450,480,490,{37663,39681,44128,44499,44501,44500},{12,40,2,1,8,1}},
		[60867] = {44413,9,450,480,490,{37663,39681,44128,44499,44501,44500},{12,40,2,1,8,1}},
		[60874] = {44504,9,450,455,465,{41163,43102,36860,35627,41146,40533},{10,1,12,12,3,1}},
		[60893] = {nil,4,400,415,430,{36901,36903,36907,40411},{10,10,4,4}},
		[60969] = {44554,8,300,340,350,{21840,23112,22445,8343},{6,4,4,5}},
		[60971] = {44558,8,425,435,455,{41511,36930,2604,4341,42253},{12,4,4,2,4}},
		[60990] = {43584,8,420,430,450,{41511,36860,35622,38426,43102},{4,2,2,2,1}},
		[60993] = {43583,8,425,435,455,{41511,36860,35622,38426,43102},{6,3,3,3,1}},
		[60994] = {43585,8,420,430,450,{41511,36860,35622,38426,43102},{4,2,2,2,1}},
		[60996] = {43590,3,425,435,455,{38425,36860,35622,38558,43102},{10,3,3,8,1}},
		[60997] = {43591,3,420,430,450,{38425,36860,35622,38558,43102},{8,2,2,4,1}},
		[60998] = {43592,3,420,430,450,{38425,36860,35622,38558,43102},{8,2,2,4,1}},
		[60999] = {43593,3,425,435,455,{38425,36860,35622,38557,43102},{10,3,3,8,1}},
		[61000] = {43594,3,420,430,450,{38425,36860,35622,38557,43102},{8,2,2,4,1}},
		[61002] = {43595,3,420,430,450,{38425,36860,35622,38557,43102},{8,2,2,4,1}},
		[61008] = {43586,2,425,435,455,{36913,36860,35622,43102},{16,3,3,1}},
		[61009] = {43587,2,420,430,450,{36913,36860,35622,43102},{12,2,2,1}},
		[61010] = {43588,2,420,430,450,{36913,36860,35622,43102},{12,2,2,1}},
		[61117] = {nil,15,400,395,405,{43127},{1}},
		[61118] = {nil,15,400,395,405,{43127},{1}},
		[61119] = {nil,15,400,395,405,{43127},{1}},
		[61120] = {nil,15,400,395,405,{43127},{1}},
		[61177] = {nil,15,385,425,450,{43126,43127,39502},{3,1,5}},
		[61288] = {nil,15,75,125,150,{39469,39354},{1,2}},
		[61471] = {44739,9,390,400,415,{39683,39681},{1,2}},
		[61481] = {44740,9,420,425,440,{36913,33568,35627},{8,2,1}},
		[61482] = {44741,9,420,425,440,{36913,33568,35627},{8,2,1}},
		[61483] = {44742,9,420,425,440,{36913,33568,35627},{8,2,1}},
		[61677] = {44684,15,385,390,405,{43126,39502},{1,1}},
		[62044] = {nil,6,100,150,175,{46784,44853},{1,1}},
		[62045] = {nil,6,280,330,355,{44834,44853,44835},{1,2,1}},
		[62049] = {nil,6,160,210,235,{44854,44853},{1,1}},
		[62050] = {nil,6,1,90,115,{30816,44835},{1,1}},
		[62051] = {nil,6,220,270,295,{44855,44853,44835},{1,1,1}},
		[62162] = {44928,15,375,380,390,{43126,39502},{1,1}},
		[62176] = {44930,3,440,450,460,{38425,35623,35622,43102},{10,5,5,1}},
		[62177] = {44931,3,440,450,460,{38425,35623,35622,43102},{12,6,6,1}},
		[62202] = {44936,2,450,455,465,{41163,35627},{4,4}},
		[62213] = {44939,4,385,390,400,{39970,18256},{4,1}},
		[62242] = {44943,14,425,445,470,{43102,36923,36926,36932},{1,1,1,1}},
		[62256] = {44947,10,450,460,480,{34055,34057},{4,1}},
		[62257] = {44946,10,450,460,480,{34052,37663},{4,1}},
		[62271] = {44949,9,440,450,460,{41163,38425,36933,35624,43102},{8,4,2,4,1}},
		[62350] = {44953,6,400,350,460,{43011,43007},{2,1}},
		[62409] = {44958,4,375,380,390,{41814},{2}},
		[62410] = {8827,4,400,415,430,{44958,18256},{3,1}},
		[62448] = {44963,3,425,435,445,{44128,35624,43102},{2,4,1}},
		[62941] = {45054,14,300,310,320,{11754},{1}},
		[62948] = {45056,10,450,455,465,{34054,34052,34057},{40,6,6}},
		[62959] = {45060,10,385,395,415,{34054,34055},{12,2}},
		[63182] = {45085,2,440,450,470,{37663,34054,43102},{6,6,2}},
		[63187] = {45550,2,450,455,475,{37663,45087},{5,6}},
		[63188] = {45559,2,450,455,475,{37663,45087},{5,6}},
		[63189] = {45552,2,450,455,475,{37663,45087},{5,6}},
		[63190] = {45561,2,450,455,475,{37663,45087},{5,6}},
		[63191] = {45551,2,450,455,475,{37663,45087},{5,6}},
		[63192] = {45560,2,450,455,475,{37663,45087},{5,6}},
		[63194] = {45553,3,450,455,475,{44128,38557,45087},{3,20,6}},
		[63195] = {45562,3,450,455,475,{44128,38561,45087},{3,20,6}},
		[63196] = {45554,3,450,455,475,{44128,38558,45087},{3,20,6}},
		[63197] = {45563,3,450,455,475,{44128,38557,45087},{3,20,6}},
		[63198] = {45555,3,450,455,475,{44128,35627,45087},{3,4,6}},
		[63199] = {45564,3,450,455,475,{44128,35627,45087},{3,2,6}},
		[63200] = {45556,3,450,455,475,{38425,44128,45087},{4,3,6}},
		[63201] = {45565,3,450,455,475,{44128,38557,45087},{3,20,6}},
		[63203] = {45557,8,450,455,465,{41595,41593,45087},{4,4,6}},
		[63204] = {45566,8,450,455,465,{41595,41593,45087},{4,4,6}},
		[63205] = {45558,8,450,455,465,{41594,45087},{8,6}},
		[63206] = {45567,8,450,455,465,{41594,45087},{8,6}},
		[63732] = {45621,4,135,160,200,{6371,2453,3371},{1,1,1}},
		[63742] = {45626,8,125,150,185,{4305,3182,2321},{3,6,2}},
		[63743] = {45627,14,200,210,230,{6037},{8}},
		[63746] = {45628,10,225,245,285,{11137,11174},{4,1}},
		[63750] = {45631,9,250,270,290,{15994,6037,7078},{4,6,6}},
		[63765] = {nil,9,380,380,385,{33470,39682},{12,1}},
		[63770] = {nil,9,400,400,405,{36913,35624},{4,2}},
		[63924] = {45773,8,435,440,450,{41594,36908},{4,6}},
		[64051] = {45854,15,350,375,400,{43126,39502,35627},{5,10,3}},
		[64053] = {45849,15,350,375,400,{43126,39502,35625},{5,10,2}},
		[64054] = {33004,6,250,250,300,{7974},{1}},
		[64246] = {45735,15,430,430,440,{39774,39354},{1,1}},
		[64247] = {45778,15,430,430,440,{39774,39354},{1,1}},
		[64248] = {45785,15,430,430,440,{39774,39354},{1,1}},
		[64249] = {45734,15,430,430,440,{43116,39354},{1,1}},
		[64250] = {45789,15,430,430,440,{43116,39354},{1,1}},
		[64251] = {45747,15,430,430,440,{43116,10648},{1,1}},
		[64252] = {45797,15,430,430,440,{43116,10648},{1,1}},
		[64253] = {45733,15,430,430,440,{43118,10648},{1,1}},
		[64254] = {45746,15,430,430,440,{43120,10648},{1,1}},
		[64255] = {45793,15,430,430,440,{43120,10648},{1,1}},
		[64256] = {45623,15,430,430,440,{43120,39501},{1,1}},
		[64257] = {45740,15,430,430,440,{43120,39501},{1,1}},
		[64258] = {45622,15,250,255,270,{43122,39501},{1,1}},
		[64259] = {45760,15,255,255,270,{43122,39501},{1,1}},
		[64260] = {45768,15,255,255,270,{43122,39501},{1,1}},
		[64261] = {45775,15,250,255,270,{43122,39501},{1,1}},
		[64262] = {45776,15,255,255,270,{43122,39501},{1,1}},
		[64266] = {45804,15,275,280,295,{43122,39501},{1,1}},
		[64267] = {45805,15,280,285,295,{43122,39501},{1,1}},
		[64268] = {45601,15,430,430,440,{43124,39502},{1,1}},
		[64270] = {45602,15,430,430,440,{43124,39502},{1,1}},
		[64271] = {45625,15,430,430,440,{43124,39502},{1,1}},
		[64273] = {45731,15,430,430,440,{43124,39502},{1,1}},
		[64274] = {45736,15,430,430,440,{43124,39502},{1,1}},
		[64275] = {45737,15,430,430,440,{43124,39502},{1,1}},
		[64276] = {45738,15,430,430,440,{43124,39502},{1,1}},
		[64277] = {45741,15,430,430,440,{43124,39502},{1,1}},
		[64278] = {45742,15,430,430,440,{43124,39502},{1,1}},
		[64279] = {45743,15,430,430,440,{43124,39502},{1,1}},
		[64280] = {45753,15,430,430,440,{43124,39502},{1,1}},
		[64281] = {45755,15,430,430,440,{43124,39502},{1,1}},
		[64282] = {45756,15,430,430,440,{43124,39502},{1,1}},
		[64283] = {45758,15,430,430,440,{43124,39502},{1,1}},
		[64284] = {45761,15,430,430,440,{43124,39502},{1,1}},
		[64285] = {45762,15,430,430,440,{43124,39502},{1,1}},
		[64286] = {45764,15,430,430,440,{43124,39502},{1,1}},
		[64287] = {45770,15,430,430,440,{43124,39502},{1,1}},
		[64288] = {45771,15,430,430,440,{43124,39502},{1,1}},
		[64289] = {45772,15,430,430,440,{43124,39502},{1,1}},
		[64291] = {45779,15,430,430,440,{43124,39502},{1,1}},
		[64294] = {45781,15,430,430,440,{43124,39502},{1,1}},
		[64295] = {45790,15,430,430,440,{43124,39502},{1,1}},
		[64296] = {45792,15,430,430,440,{43124,39502},{1,1}},
		[64297] = {45799,15,430,430,440,{43124,39502},{1,1}},
		[64298] = {45800,15,430,430,440,{43124,39502},{1,1}},
		[64299] = {45803,15,430,430,440,{43124,39502},{1,1}},
		[64300] = {45806,15,430,430,440,{43124,39502},{1,1}},
		[64302] = {45795,15,430,430,440,{43124,39502},{1,1}},
		[64303] = {45769,15,430,430,440,{43124,39502},{1,1}},
		[64304] = {45732,15,430,430,440,{43126,39502},{1,1}},
		[64305] = {45745,15,430,430,440,{43126,39502},{1,1}},
		[64307] = {45604,15,430,430,440,{43126,39502},{1,1}},
		[64308] = {45744,15,430,430,440,{43126,39502},{1,1}},
		[64309] = {45757,15,430,430,440,{43126,39502},{1,1}},
		[64310] = {45767,15,430,430,440,{43126,39502},{1,1}},
		[64311] = {45783,15,430,430,440,{43126,39502},{1,1}},
		[64312] = {45794,15,75,430,440,{43126,39502},{1,1}},
		[64313] = {45603,15,430,430,440,{43126,39502},{1,1}},
		[64314] = {45739,15,430,430,440,{43126,39502},{1,1}},
		[64315] = {45766,15,430,430,440,{43126,39502},{1,1}},
		[64316] = {45777,15,430,430,440,{43126,39502},{1,1}},
		[64317] = {45782,15,430,430,440,{43126,39502},{1,1}},
		[64318] = {45780,15,430,430,440,{43124,39502},{1,1}},
		[64358] = {45932,6,400,400,425,{41805},{3}},
		[64441] = {46026,10,450,455,465,{34057,34055,37663},{4,8,1}},
		[64579] = {46098,10,450,455,465,{34057,34054,36918},{4,40,1}},
		[64661] = {33568,3,350,350,375,{33567},{5}},
		[64725] = {45812,14,420,440,460,{41163,36933},{1,3}},
		[64726] = {45813,14,420,440,460,{41163,36924},{2,2}},
		[64727] = {45808,14,420,440,460,{41163,36927},{2,2}},
		[64728] = {45809,14,420,440,460,{41163,36918},{2,1}},
		[64729] = {45811,8,400,405,415,{41511,42253,35624},{4,4,4}},
		[64730] = {45810,8,405,410,420,{41511,42253,35627},{4,4,4}},
		[65245] = {46372,15,430,430,440,{43126,39354},{1,1}},
		[65454] = {46691,6,1,30,40,{30817,1179},{1,1}},
		[66034] = {nil,6,220,270,295,{46797,44853,44835},{1,1,1}},
		[66035] = {nil,6,160,210,235,{46793,44853},{1,1}},
		[66036] = {nil,6,100,150,175,{46796,44853},{1,1}},
		[66037] = {nil,6,280,330,355,{44834,44853,44835},{1,2,1}},
		[66038] = {nil,6,1,90,115,{30816,44835},{1,1}},
		[66338] = {40167,14,450,440,465,{36934},{1}},
		[66428] = {40168,14,450,440,465,{36934},{1}},
		[66429] = {40166,14,450,440,465,{36934},{1}},
		[66430] = {40175,14,450,440,465,{36934},{1}},
		[66431] = {40165,14,450,440,465,{36934},{1}},
		[66432] = {40164,14,450,440,465,{36934},{1}},
		[66433] = {40170,14,450,440,465,{36934},{1}},
		[66434] = {40169,14,450,440,465,{36934},{1}},
		[66435] = {40171,14,450,440,465,{36934},{1}},
		[66436] = {40176,14,450,440,465,{36934},{1}},
		[66437] = {40172,14,450,440,465,{36934},{1}},
		[66438] = {40181,14,450,440,465,{36934},{1}},
		[66439] = {40177,14,450,440,465,{36934},{1}},
		[66440] = {40174,14,450,440,465,{36934},{1}},
		[66441] = {40180,14,450,440,465,{36934},{1}},
		[66442] = {40179,14,450,440,465,{36934},{1}},
		[66443] = {40182,14,450,440,465,{36934},{1}},
		[66444] = {40178,14,450,440,465,{36934},{1}},
		[66445] = {40173,14,450,440,465,{36934},{1}},
		[66446] = {40113,14,450,440,465,{36919},{1}},
		[66447] = {40111,14,450,440,465,{36919},{1}},
		[66448] = {40112,14,450,440,465,{36919},{1}},
		[66449] = {40114,14,450,440,465,{36919},{1}},
		[66450] = {40118,14,450,440,465,{36919},{1}},
		[66451] = {40117,14,450,440,465,{36919},{1}},
		[66452] = {40115,14,450,440,465,{36919},{1}},
		[66453] = {40116,14,450,440,465,{36919},{1}},
		[66497] = {40119,14,450,440,465,{36925},{1}},
		[66498] = {40120,14,450,440,465,{36925},{1}},
		[66499] = {40122,14,450,440,465,{36925},{1}},
		[66500] = {40121,14,450,440,465,{36925},{1}},
		[66501] = {40125,14,450,440,465,{36922},{1}},
		[66502] = {40124,14,450,440,465,{36922},{1}},
		[66503] = {40123,14,450,440,465,{36922},{1}},
		[66504] = {40126,14,450,440,465,{36922},{1}},
		[66505] = {40127,14,450,440,465,{36922},{1}},
		[66506] = {40128,14,450,440,465,{36922},{1}},
		[66553] = {40136,14,450,440,465,{36928},{1}},
		[66554] = {40129,14,450,440,465,{36928},{1}},
		[66555] = {40132,14,450,440,465,{36928},{1}},
		[66556] = {40133,14,450,440,465,{36928},{1}},
		[66557] = {40130,14,450,440,465,{36928},{1}},
		[66558] = {40134,14,450,440,465,{36928},{1}},
		[66559] = {40138,14,450,440,465,{36928},{1}},
		[66560] = {40139,14,450,440,465,{36928},{1}},
		[66561] = {40141,14,450,440,465,{36928},{1}},
		[66562] = {40135,14,450,440,465,{36928},{1}},
		[66563] = {40140,14,450,440,465,{36928},{1}},
		[66564] = {40137,14,450,440,465,{36928},{1}},
		[66565] = {40131,14,450,440,465,{36928},{1}},
		[66566] = {40151,14,450,440,465,{36931},{1}},
		[66567] = {40142,14,450,440,465,{36931},{1}},
		[66568] = {40147,14,450,440,465,{36931},{1}},
		[66569] = {40152,14,450,440,465,{36931},{1}},
		[66570] = {40153,14,450,440,465,{36931},{1}},
		[66571] = {40154,14,450,440,465,{36931},{1}},
		[66572] = {40143,14,450,440,465,{36931},{1}},
		[66573] = {40157,14,450,440,465,{36931},{1}},
		[66574] = {40155,14,450,440,465,{36931},{1}},
		[66575] = {40148,14,450,440,465,{36931},{1}},
		[66576] = {40162,14,450,440,465,{36931},{1}},
		[66577] = {40156,14,450,440,465,{36931},{1}},
		[66578] = {40161,14,450,440,465,{36931},{1}},
		[66579] = {40144,14,450,440,465,{36931},{1}},
		[66580] = {40158,14,450,440,465,{36931},{1}},
		[66581] = {40160,14,450,440,465,{36931},{1}},
		[66582] = {40145,14,450,440,465,{36931},{1}},
		[66583] = {40146,14,450,440,465,{36931},{1}},
		[66584] = {40150,14,450,440,465,{36931},{1}},
		[66585] = {40149,14,450,440,465,{36931},{1}},
		[66586] = {40163,14,450,440,465,{36931},{1}},
		[66587] = {40159,14,450,440,465,{36931},{1}},
		[66658] = {nil,4,450,440,465,{36930,35627},{1,1}},
		[66659] = {36919,4,440,440,465,{36860,36918},{1,1}},
		[66660] = {nil,4,450,440,465,{36921,35625},{1,1}},
		[66662] = {nil,4,450,440,465,{35627,36927},{1,1}},
		[66663] = {nil,4,450,440,465,{35623,36924},{1,1}},
		[66664] = {nil,4,450,440,465,{36933},{3}},
		[67025] = {47499,4,425,440,450,{36908,40411},{4,1}},
		[67064] = {47605,8,450,460,475,{41594,36922,47556},{20,2,8}},
		[67065] = {47587,8,450,460,475,{41594,47556},{12,4}},
		[67066] = {47603,8,450,460,475,{41593,41595,34052,47556},{8,8,8,8}},
		[67079] = {47585,8,450,460,475,{41595,36934,36919,36925,47556},{8,1,1,1,4}},
		[67080] = {47597,3,450,460,475,{38558,35623,34055,44128,47556},{40,8,8,8,8}},
		[67081] = {47579,3,450,460,475,{38558,34057,44128,47556},{40,4,6,4}},
		[67082] = {47595,3,450,460,475,{38557,35622,35625,44128,47556},{40,8,8,8,8}},
		[67083] = {47576,3,450,460,475,{38557,35622,44128,47556},{40,8,6,4}},
		[67084] = {47602,3,450,460,475,{38425,35625,44128,47556},{24,20,8,8}},
		[67085] = {47583,3,450,460,475,{38425,35625,44128,47556},{20,12,6,4}},
		[67086] = {47599,3,450,460,475,{38425,35627,44128,47556},{24,20,8,8}},
		[67087] = {47581,3,450,460,475,{38425,35627,44128,47556},{20,12,6,4}},
		[67091] = {47591,2,450,460,475,{37663,35625,36925,47556},{12,8,2,8}},
		[67092] = {47570,2,450,460,475,{37663,36913,47556},{8,20,4}},
		[67093] = {47589,2,450,460,475,{37663,41245,47556},{10,4,8}},
		[67094] = {47572,2,450,460,475,{37663,41355,47556},{8,1,4}},
		[67095] = {47593,2,450,460,475,{37663,35625,47556},{10,20,8}},
		[67096] = {47574,2,450,460,475,{37663,35625,47556},{8,12,4}},
		[67130] = {47592,2,450,460,475,{37663,35625,36925,47556},{12,8,2,8}},
		[67131] = {47571,2,450,460,475,{37663,36913,47556},{8,20,4}},
		[67132] = {47590,2,450,460,475,{37663,41245,47556},{10,4,8}},
		[67133] = {47573,2,450,460,475,{37663,41355,47556},{8,1,4}},
		[67134] = {47594,2,450,460,475,{37663,35625,47556},{10,20,8}},
		[67135] = {47575,2,450,460,475,{37663,35625,47556},{8,12,4}},
		[67136] = {47598,3,450,460,475,{38558,35623,34055,44128,47556},{40,8,8,8,8}},
		[67137] = {47580,3,450,460,475,{38558,34057,44128,47556},{40,4,6,4}},
		[67138] = {47596,3,450,460,475,{38557,35622,35625,44128,47556},{40,8,8,8,8}},
		[67139] = {47582,3,450,460,475,{38425,35627,44128,47556},{20,12,6,4}},
		[67140] = {47601,3,450,460,475,{38425,35625,44128,47556},{24,20,8,8}},
		[67141] = {47584,3,450,460,475,{38425,35625,44128,47556},{20,12,6,4}},
		[67142] = {47600,3,450,460,475,{38425,35627,44128,47556},{24,20,8,8}},
		[67143] = {47577,3,450,460,475,{38557,35622,44128,47556},{40,8,6,4}},
		[67144] = {47606,8,450,460,475,{41594,36922,47556},{20,2,8}},
		[67145] = {47586,8,450,460,475,{41595,36934,36919,36925,47556},{8,1,1,1,4}},
		[67146] = {47604,8,450,460,475,{41593,41595,34052,47556},{8,8,8,8}},
		[67147] = {47588,8,450,460,475,{41594,47556},{12,4}},
		[67326] = {47828,9,410,415,425,{36913,37702,37705},{6,3,3}},
		[67600] = {48720,15,100,105,115,{39774,39354},{1,1}},
		[67790] = {48933,9,1,435,445,{39683,35623,36860,35622,39681,42546},{2,2,2,2,10,5}},
		[67839] = {nil,9,410,410,420,{36913,39683},{8,1}},
		[67920] = {48933,9,435,450,460,{41163,35627,35622,36860,35623},{8,2,2,2,2}},
		[68067] = {49040,9,450,480,490,{18232,34113,40769,37663,36922,39681},{2,10,20,8,2,30}},
		[68166] = {49084,15,75,355,365,{43126,39502},{1,1}},
		[68253] = {49110,14,450,440,465,{42225,34054},{1,5}},
		[69385] = {49632,15,440,425,460,{43127,39502},{1,5},5},
		[69386] = {49633,3,450,440,470,{38425,38557},{8,8}},
		[69388] = {49634,3,450,440,470,{38425,38561},{8,8}},
		[69412] = {34057,10,445,445,450,{34057},{1}},
		[70524] = {12655,7,250,250,260,{12359,11176},{1,3}},
		[70550] = {49891,8,450,475,500,{41595,41593,49908},{10,10,8}},
		[70551] = {49890,8,450,475,500,{41595,41593,49908},{6,6,5}},
		[70552] = {49892,8,450,475,500,{41594,49908},{20,8}},
		[70553] = {49893,8,450,475,500,{41594,49908},{10,5}},
		[70554] = {49898,3,450,475,500,{38561,44128,35625,49908},{20,8,16,8}},
		[70555] = {49894,3,450,475,500,{38561,44128,35625,49908},{12,5,10,5}},
		[70556] = {49899,3,450,475,500,{38558,44128,35627,49908},{20,8,16,8}},
		[70557] = {49895,3,450,475,500,{38558,44128,35627,49908},{12,8,10,5}},
		[70558] = {49900,3,450,475,500,{38557,44128,35623,49908},{20,8,16,8}},
		[70559] = {49896,3,450,475,500,{38557,44128,35623,49908},{12,5,10,5}},
		[70560] = {49901,3,450,475,500,{38557,44128,35624,49908},{20,8,16,8}},
		[70561] = {49897,3,450,475,500,{38557,44128,35624,49908},{12,8,10,5}},
		[70562] = {49902,2,450,475,500,{37663,35623,49908},{12,20,8}},
		[70563] = {49905,2,450,475,500,{37663,35624,49908},{8,12,5}},
		[70565] = {49903,2,450,475,500,{37663,35627,49908},{12,20,8}},
		[70566] = {49906,2,450,475,500,{37663,35622,36860,49908},{8,6,6,5}},
		[70567] = {49904,2,450,475,500,{37663,35624,49908},{12,20,8}},
		[70568] = {49907,2,450,475,500,{37663,35624,49908},{8,12,5}},
		[71015] = {50125,15,375,380,385,{43126,39502},{1,1}},
		[71101] = {50045,15,250,255,265,{43124,39502},{1,1}},
		[71102] = {50077,15,375,380,385,{43126,39502},{1,1}},
		[71692] = {50816,10,375,385,400,{34054,44958},{1,3}},
		[72952] = {52020,9,450,440,460,{37701},{2},1000},
		[72953] = {52021,9,450,440,460,{37703},{2},1000},
		[75597] = {54797,8,425,435,455,{41594,41595,41593,43102},{1,1,1,4}},
    }
end

local PROFESSION_ITEM_SKILL, PROFESSION_ITEM_SKILL_DATA = AtlasLoot:GetGameVersionDataTable()
PROFESSION_ITEM_SKILL_DATA.CLASSIC = {
    -- Herb
    [8838] = { 230, 255, 330 }, -- Sungrass
    [8839] = { 235, 260, 335 }, -- Blindweed
    [8845] = { 245, 270, 345 }, -- Ghost Mushroom
    [8846] = { 250, 275, 350 }, -- Gromsblood
    [13464] = { 260, 285, 360 }, -- Golden Sansam
    [13463] = { 270, 295, 370 }, -- Dreamfoil
    [13465] = { 280, 305, 380 }, -- Mountain Silversage
    [13466] = { 285, 310, 385 }, -- Plaguebloom
    [13467] = { 290, 315, 390 }, -- Icecap
    [13468] = { 300, 325, 400 }, -- Black Lotus
    --[19726] = { 0, 0, 0 }, -- Bloodvine
    [3818] = { 160, 185, 260 }, -- Fadeleaf
    [3821] = { 170, 195, 270 }, -- Goldthorn
    [3358] = { 185, 210, 285 }, -- Khadgar's Whisker
    [3819] = { 195, 220, 295 }, -- Wintersbite
    [4625] = { 205, 230, 305 }, -- Firebloom
    [8831] = { 210, 235, 310 }, -- Purple Lotus
    --[8153] = { 0, 0, 0 }, -- Wildvine
    [8836] = { 220, 245, 320 }, -- Arthas' Tears
    [3820] = { 85, 110, 185 }, -- Stranglekelp
    [2453] = { 100, 125, 200 }, -- Bruiseweed
    [3355] = { 115, 140, 215 }, -- Wild Steelbloom
    [3369] = { 120, 145, 220 }, -- Grave Moss
    [3356] = { 125, 150, 225 }, -- Kingsblood
    [3357] = { 150, 175, 250 }, -- Liferoot
    [2447] = { 1, 25, 100 }, -- Peacebloom
    [765] = { 1, 25, 100 }, -- Silverleaf
    [2449] = { 15, 40,115 }, -- Earthroot
    [785] = { 50, 75, 150 }, -- Mageroyal
    [2450] = { 70, 95, 170 }, -- Briarthorn
    --[2452] = { 0, 0, 0 }, -- Swiftthistle
}

if AtlasLoot:GameVersion_GE(AtlasLoot.BC_VERSION_NUM) then
    PROFESSION_ITEM_SKILL_DATA.BCC = {
		[22793] = { 375, 375, 375 }, -- Mana Thistle
		[22792] = { 365, 365, 365 }, -- Nightmare Vine
		[22791] = { 350, 350, 350 }, -- Netherbloom
		[22790] = { 340, 340, 340 }, -- Ancient Lichen
		[22789] = { 325, 325, 325 }, -- Terocone
		[22787] = { 325, 325, 325 }, -- Ragveil
		[22786] = { 315, 315, 315 }, -- Dreaming Glory
		[22785] = { 300, 300, 300 }, -- Felweed
		--[22794] = { 0, 0, 0 }, -- Fel Lotus
    }
end

if AtlasLoot:GameVersion_GE(AtlasLoot.WRATH_VERSION_NUM) then
    PROFESSION_ITEM_SKILL_DATA.WRATH = {
		[36906] = { 435, 435, 435 }, -- Icethorn
		[36905] = { 425, 425, 425 }, -- Lichbloom
		[36903] = { 400, 400, 400 }, -- Adder's Tongue
		[36907] = { 385, 385, 385 }, -- Talandra's Rose
		[36904] = { 375, 375, 375 }, -- Tiger Lily
		[36901] = { 350, 350, 350 }, -- Goldclover
    }
end

-- maybe weak table?
local ProfessionCache = {}
local ContentPhaseCache = {}
local CraftedToSpellID

local function OnInit()
    Recipe = AtlasLoot.Data.Recipe
    ContentPhase = AtlasLoot.Data.ContentPhase
end
AtlasLoot:AddInitFunc(OnInit)

function Profession.IsProfessionSpell(spellID)
	return PROFESSION[spellID or 0] and true or false
end

function Profession.GetProfessionData(spellID)
	return PROFESSION[spellID or 0] and PROFESSION[spellID or 0] or nil
end

function Profession.GetDataForExtraFrame(spellID)
    local prof = Profession.GetProfessionData(spellID)
    if not prof then return end

    if not ProfessionCache[spellID] then
        local ret
        if prof[1] and prof[1] > 0 then
            if prof[1] and prof[8] then
                ret = { { prof[1], prof[8] } }
            else
                ret = { prof[1] }
            end
		else
			ret = {}
        end
        local recipe = Recipe.GetRecipeForSpell(spellID)
        if recipe then
            ret[#ret+1] = recipe
            ret[#ret+1] = 0
        elseif #ret > 0 then
            ret[#ret+1] = 0
        end
		ret[#ret+1] = "prof"..spellID
		for i = 1, #prof[6] do
			ret[#ret+1] = {prof[6][i], prof[7][i]}
		end
		ProfessionCache[spellID] = ret
    end

    return ProfessionCache[spellID]
end

function Profession.GetCreatedItemID(spellID)
	return PROFESSION[spellID or 0] and PROFESSION[spellID or 0][1] or nil
end

function Profession.GetNumCreatedItems(spellID)
	return PROFESSION[spellID or 0] and ( PROFESSION[spellID or 0][8] or 1 ) or nil
end

function Profession.GetSpellDescription(spellID)
	return ( spellID and PROFESSION[spellID] ) and PROFESSION_TEXT[PROFESSION[spellID][2] or PROFESSION_DEFAULT] or nil
end

function Profession.GetSpellDescriptionShort(spellID)
	return ( spellID and PROFESSION[spellID] ) and PROFESSION_TEXT_SHORT[PROFESSION[spellID][2] or PROFESSION_DEFAULT] or nil
end

function Profession.GetColorSkillRankNoSpell(min, low, high)
    return min <= 0 and format(FORMAT_STRING_SKILL2, low, ((high - low) * 0.5)+low, high) or format(FORMAT_STRING_SKILL, min, low, ((high - low) * 0.5)+low, high)
end

function Profession.GetColorSkillRank(spellID)
    local spell = Profession.GetProfessionData(spellID)
    if not spell then return end
    return  Profession.GetColorSkillRankNoSpell(spell[3], spell[4], spell[5]) --format(FORMAT_STRING_SKILL, spell[3], spell[4], ((spell[5] - spell[4]) * 0.5)+spell[4], spell[5])
end

function Profession.GetSpellDescriptionWithRank(spellID, shortName)
    if not spellID or not PROFESSION[spellID] then return end
	if shortName then
		return Profession.GetSpellDescriptionShort(spellID).."  "..(Profession.GetColorSkillRank(spellID) or "")
	else
		return Profession.GetSpellDescription(spellID).."  "..(Profession.GetColorSkillRank(spellID) or "")
	end
end

function Profession.GetColorSkillRankItem(itemID)
    local itemData = PROFESSION_ITEM_SKILL[itemID or 0]
    if not itemData then return end
    return  Profession.GetColorSkillRankNoSpell(itemData[1], itemData[2], itemData[3]) --format(FORMAT_STRING_SKILL, spell[3], spell[4], ((spell[5] - spell[4]) * 0.5)+spell[4], spell[5])
end

function Profession.GetIcon(spellID)
    local prof = Profession.GetProfessionData(spellID)
    if not prof then return PROFESSION_ICON[0] end
    return PROFESSION_ICON[prof[2] or 0] or PROFESSION_ICON[0]
end

function Profession.GetSpellIDPhase(spellID)
    if not PROFESSION[spellID] then return end
    if not ContentPhaseCache[spellID] then
        local content = PROFESSION[spellID][6]
        local recipe = Recipe.GetRecipeForSpell(spellID)
        local phase = recipe and ContentPhase:GetForItemID(recipe) or 0
        local createdItemPhase = ContentPhase:GetForItemID(PROFESSION[spellID][1])
        phase = ( createdItemPhase and createdItemPhase > phase ) and createdItemPhase or phase
        for i = 1, #content do
            local c = ContentPhase:GetForItemID(content[i])
            phase = ( c and c > phase ) and c or phase
        end

        ContentPhaseCache[spellID] = phase
    end
    return ContentPhaseCache[spellID]
end

function Profession.GetPhaseTextureForSpellID(spellID)
    local phase = ContentPhaseCache[spellID] or Profession.GetSpellIDPhase(spellID)
    if not phase then return end
    return ContentPhase:GetPhaseTexture(phase)
end

function Profession.GetProfessionID(spellID)
    return PROFESSION[spellID or 0] and PROFESSION[spellID][2] or nil
end

local PROF_STRING_C = "|cffffffff|Henchant:%d|h[%s]|h|r"
local PROF_STRING = "|cffffd000|Henchant:%d|h[%s: %s]|h|r"
function Profession.GetChatLink(spellID)
	if not PROFESSION[spellID] then return end
	if ALPrivate.IS_CLASSIC then
		return format(PROF_STRING_C, spellID, GetSpellInfo(spellID))
	else
		return format(PROF_STRING, spellID, PROFESSION_NAME[ PROFESSION[spellID][2] ], GetSpellInfo(spellID))
	end
end

-- Request #101
function Profession.GetCraftSpellForCreatedItem(itemID)
    if not CraftedToSpellID then
        CraftedToSpellID = {}
        for craftSpell, craftData in pairs(PROFESSION) do
            if craftData[1] then
                CraftedToSpellID[craftData[1]] = craftSpell
            end
        end
    end
    return CraftedToSpellID[itemID]
end

function Profession.GetRecipeForCreatedItem(itemID)
    return Recipe.GetRecipeForSpell(Profession.GetCraftSpellForCreatedItem(itemID))
end