-----------------------------------------------------------------------
-- Upvalued Lua API.
-----------------------------------------------------------------------
local _G = getfenv(0)
local select = _G.select
local string = _G.string
local format = string.format

-- WoW

-- ----------------------------------------------------------------------------
-- AddOn namespace.
-- ----------------------------------------------------------------------------
local addonname = ...
local AtlasLoot = _G.AtlasLootMY
if AtlasLoot:GameVersion_LT(AtlasLoot.WRATH_VERSION_NUM) then return end
local data = AtlasLoot.ItemDB:Add(addonname, 3, AtlasLoot.WRATH_VERSION_NUM)

local AL = AtlasLoot.Locales
local ALIL = AtlasLoot.IngameLocales

local NORMAL_DIFF = data:AddDifficulty("NORMAL", nil, nil, nil, true)
local P1_DIFF = data:AddDifficulty("P1", nil, nil, nil, true)
local HEROIC_DIFF = data:AddDifficulty("HEROIC", nil, nil, nil, true)
local ALPHA_DIFF = data:AddDifficulty(AL["Titan Rune Alpha"], "TRA", nil, nil, true)
local BETA_DIFF = data:AddDifficulty(AL["Titan Rune Beta"], "TRB", nil, nil, true)
local RAID10_DIFF = data:AddDifficulty("10RAID")
local RAID10H_DIFF = data:AddDifficulty("10RAIDH")
local RAID25_DIFF = data:AddDifficulty("25RAID")
local RAID25H_DIFF = data:AddDifficulty("25RAIDH")

local VENDOR_DIFF = data:AddDifficulty(AL["Vendor"], "vendor", 0)
local T10_1_DIFF = data:AddDifficulty(AL["10H / 25 / 25H"], "T10_1", 0)
local T10_2_DIFF = data:AddDifficulty(AL["25 Raid Heroic"], "T10_2", 0)


local NORMAL_ITTYPE = data:AddItemTableType("Item", "Item")
local SET_ITTYPE = data:AddItemTableType("Set", "Item")
local AC_ITTYPE = data:AddItemTableType("Achievement", "Item")

local QUEST_EXTRA_ITTYPE = data:AddExtraItemTableType("Quest")
local PRICE_EXTRA_ITTYPE = data:AddExtraItemTableType("Price")

local DUNGEON_CONTENT = data:AddContentType(AL["Dungeons"], ATLASLOOT_DUNGEON_COLOR)
-- local RAID_P1_CONTENT = data:AddContentType("P1", ATLASLOOT_RAID20_COLOR)
-- local RAID_P2_CONTENT = data:AddContentType("团本P2", ATLASLOOT_RAID20_COLOR)
-- local RAID_P1_CONTENT = data:AddContentType("团本P3", ATLASLOOT_RAID20_COLOR)
-- local RAID_P1_CONTENT = data:AddContentType("团本P4", ATLASLOOT_RAID20_COLOR)
-- local RAID_P1_CONTENT = data:AddContentType("团本P5", ATLASLOOT_RAID20_COLOR)
-- local RAID_P1_CONTENT = data:AddContentType("团本P6", ATLASLOOT_RAID20_COLOR)
-- local RAID_P1_CONTENT = data:AddContentType("团本P7", ATLASLOOT_RAID20_COLOR)
-- local RAID_P1_CONTENT = data:AddContentType("团本P8", ATLASLOOT_RAID20_COLOR)
-- local RAID_P1_CONTENT = data:AddContentType("团本P9", ATLASLOOT_RAID20_COLOR)
-- local RAID_P1_CONTENT = data:AddContentType("团本P10", ATLASLOOT_RAID20_COLOR)
-- local RAID_P1_CONTENT = data:AddContentType("团本P11", ATLASLOOT_RAID20_COLOR)
local RAID_CONTENT = data:AddContentType(AL["Raids"], ATLASLOOT_RAID20_COLOR)
local RAID10_CONTENT = data:AddContentType(AL["10 Raids"], ATLASLOOT_RAID20_COLOR)
local RAID25_CONTENT = data:AddContentType(AL["25 Raids"], ATLASLOOT_RAID40_COLOR)

local ATLAS_MODULE_NAME = "AtlasMY_WrathoftheLichKing"
local ATLAS_TBC_MODULE_NAME = "AtlasMY_BurningCrusade"
local ATLAS_ERA_MODULE_NAME = "AtlasMY_ClassicWoW"
-- extra
local CLASS_NAME = AtlasLoot:GetColoredClassNames()

-- name formats
local NAME_COLOR, NAME_COLOR_BOSS = "|cffC0C0C0", "|cffC0C0C0"
local NAME_CAVERNS_OF_TIME = NAME_COLOR..AL["CoT"]..":|r %s" -- Caverns of Time
local NAME_NEXUS = NAME_COLOR..AL["Nexus"]..":|r %s" -- The Nexus
local NAME_AZJOL = NAME_COLOR..AL["Azjol"]..":|r %s" -- Azjol
local NAME_ULDUAR = NAME_COLOR..AL["Ulduar"]..":|r %s" -- Ulduar
local NAME_UTGARDE = NAME_COLOR..AL["Utgarde"]..":|r %s" -- Utgarde
local NAME_ICC = NAME_COLOR..AL["ICC"]..":|r %s" -- ICC
local NAME_AT = NAME_COLOR..AL["AT"]..":|r %s" -- Argent Tournament

-- colors
local BLUE = "|cff6666ff%s|r"
--local GREY = "|cff999999%s|r"
local GREEN = "|cff66cc33%s|r"
local _RED = "|cffcc6666%s|r"
local PURPLE = "|cff9900ff%s|r"
--local WHIT = "|cffffffff%s|r"

-- format
local BONUS_LOOT_SPLIT = "%s - %s"


local KEYS = {	-- Keys
	name = AL["Keys"],
	TableType = NORMAL_ITTYPE,
	ExtraList = true,
	IgnoreAsSource = true,
	[NORMAL_DIFF] = {
        { 1, "INV_Box_01", nil, AL["Normal"], nil },
		{ 2, 44582 }, -- Key to the Focusing Iris
        { 3, 45796 }, -- Celestial Planetarium Key
        { 4, 42482 }, -- The Violet Hold Key
		{ 16, "INV_Box_01", nil, AL["Heroic"], nil },
		{ 17, 44581 }, -- Heroic Key to the Focusing Iris
        { 18, 45798 }, -- Heroic Celestial Planetarium Key
    }
}

local T7_SET = {
	name = format(AL["Tier %s Sets"], "7"),
	ExtraList = true,
	TableType = SET_ITTYPE,
	--ContentPhaseBC = 6,
	IgnoreAsSource = true,
	[RAID10_DIFF] = {
		{ 1,    3100802 }, -- Warlock
		{ 3,    3100804 }, -- Priest / Heal
        { 4,    3100805 }, -- Priest / Shadow
        { 6,    3100801 }, -- Rogue
		{ 8,    3100794 }, -- Hunter
		{ 10,   3100787 }, -- Warrior / Prot
        { 11,   3100788 }, -- Warrior / DD
        { 13,   3100793 }, -- Deathknight / Prot
        { 14,   3100792 }, -- Deathknight / DD
		{ 16,   3100803 }, -- Mage
        { 18,   3100799 }, -- Druid / Heal
        { 19,   3100800 }, -- Druid / Owl
        { 20,   3100798 }, -- Druid / Feral
        { 22,   3100797 }, -- Shaman / Heal
        { 23,   3100796 }, -- Shaman / Ele
        { 24,   3100795 }, -- Shaman / Enh
        { 26,   3100790 }, -- Paladin / Heal
        { 27,   3100791 }, -- Paladin / Prot
        { 28,   3100789 }, -- Paladin / DD
	},
    [RAID25_DIFF] = {
        { 1,    3250802 }, -- Warlock
        { 3,    3250804 }, -- Priest / Heal
        { 4,    3250805 }, -- Priest / Shadow
        { 6,    3250801 }, -- Rogue
        { 8,    3250794 }, -- Hunter
        { 10,   3250787 }, -- Warrior / Prot
        { 11,   3250788 }, -- Warrior / DD
        { 13,   3250793 }, -- Deathknight / Prot
        { 14,   3250792 }, -- Deathknight / DD
        { 16,   3250803 }, -- Mage
        { 18,   3250799 }, -- Druid / Heal
        { 19,   3250800 }, -- Druid / Owl
        { 20,   3250798 }, -- Druid / Feral
        { 22,   3250797 }, -- Shaman / Heal
        { 23,   3250796 }, -- Shaman / Ele
        { 24,   3250795 }, -- Shaman / Enh
        { 26,   3250790 }, -- Paladin / Heal
        { 27,   3250791 }, -- Paladin / Prot
        { 28,   3250789 }, -- Paladin / DD
	},
}

local T8_SET = {
	name = format(AL["Tier %s Sets"], "8"),
	ExtraList = true,
	TableType = SET_ITTYPE,
	--ContentPhaseBC = 6,
	IgnoreAsSource = true,
	[RAID10_DIFF] = {
		{ 1,    3100837 }, -- Warlock
		{ 3,    3100833 }, -- Priest / Heal
        { 4,    3100832 }, -- Priest / Shadow
        { 6,    3100826 }, -- Rogue
		{ 8,    3100838 }, -- Hunter
		{ 10,   3100831 }, -- Warrior / Prot
        { 11,   3100830 }, -- Warrior / DD
        { 13,   3100835 }, -- Deathknight / Prot
        { 14,   3100834 }, -- Deathknight / DD
		{ 16,   3100836 }, -- Mage
		{ 18,   3100829 }, -- Druid / Heal
        { 19,   3100828 }, -- Druid / Owl
        { 20,   3100827 }, -- Druid / Feral
        { 22,   3100825 }, -- Shaman / Heal
        { 23,   3100824 }, -- Shaman / Ele
        { 24,   3100823 }, -- Shaman / Enh
		{ 26,   3100822 }, -- Paladin / Heal
        { 27,   3100821 }, -- Paladin / Prot
        { 28,   3100820 }, -- Paladin / DD
	},
    [RAID25_DIFF] = {
		{ 1,    3250837 }, -- Warlock
		{ 3,    3250833 }, -- Priest / Heal
        { 4,    3250832 }, -- Priest / Shadow
        { 6,    3250826 }, -- Rogue
		{ 8,    3250838 }, -- Hunter
		{ 10,   3250831 }, -- Warrior / Prot
        { 11,   3250830 }, -- Warrior / DD
        { 13,   3250835 }, -- Deathknight / Prot
        { 14,   3250834 }, -- Deathknight / DD
		{ 16,   3250836 }, -- Mage
		{ 18,   3250829 }, -- Druid / Heal
        { 19,   3250828 }, -- Druid / Owl
        { 20,   3250827 }, -- Druid / Feral
        { 22,   3250825 }, -- Shaman / Heal
        { 23,   3250824 }, -- Shaman / Ele
        { 24,   3250823 }, -- Shaman / Enh
		{ 26,   3250822 }, -- Paladin / Heal
        { 27,   3250821 }, -- Paladin / Prot
        { 28,   3250820 }, -- Paladin / DD
	},
}

local T9_SET = {
	name = format(AL["Tier %s Sets"], "9"),
	ExtraList = true,
	TableType = SET_ITTYPE,
	--ContentPhaseBC = 6,
	IgnoreAsSource = true,
	[NORMAL_DIFF] = AtlasLoot:GetRetByFaction(
        { -- horde
            { 1,    3000845 }, -- Warlock
            { 3,    3000848 }, -- Priest / Heal
            { 4,    3000850 }, -- Priest / Shadow
            { 6,    3000858 }, -- Rogue
            { 8,    3000860 }, -- Hunter
            { 10,   3000870 }, -- Warrior / Prot
            { 11,   3000868 }, -- Warrior / DD
            { 13,   3000874 }, -- Deathknight / Prot
            { 14,   3000872 }, -- Deathknight / DD
            { 16,   3000844 }, -- Mage
            { 18,   3000852 }, -- Druid / Heal
            { 19,   3000854 }, -- Druid / Owl
            { 20,   3000856 }, -- Druid / Feral
            { 22,   3000862 }, -- Shaman / Heal
            { 23,   3000863 }, -- Shaman / Ele
            { 24,   3000866 }, -- Shaman / Enh
            { 26,   3000876 }, -- Paladin / Heal
            { 27,   3000880 }, -- Paladin / Prot
            { 28,   3000878 }, -- Paladin / DD
        },
        { -- alli
            { 1,    3000846 }, -- Warlock
            { 3,    3000847 }, -- Priest / Heal
            { 4,    3000849 }, -- Priest / Shadow
            { 6,    3000857 }, -- Rogue
            { 8,    3000859 }, -- Hunter
            { 10,   3000869 }, -- Warrior / Prot
            { 11,   3000867 }, -- Warrior / DD
            { 13,   3000873 }, -- Deathknight / Prot
            { 14,   3000871 }, -- Deathknight / DD
            { 16,   3000843 }, -- Mage
            { 18,   3000851 }, -- Druid / Heal
            { 19,   3000853 }, -- Druid / Owl
            { 20,   3000855 }, -- Druid / Feral
            { 22,   3000861 }, -- Shaman / Heal
            { 23,   3000864 }, -- Shaman / Ele
            { 24,   3000865 }, -- Shaman / Enh
            { 26,   3000875 }, -- Paladin / Heal
            { 27,   3000879 }, -- Paladin / Prot
            { 28,   3000877 }, -- Paladin / DD
        }
    ),
    [RAID25_DIFF] = AtlasLoot:GetRetByFaction(
        { -- horde
            { 1,    3250845 }, -- Warlock
            { 3,    3250848 }, -- Priest / Heal
            { 4,    3250850 }, -- Priest / Shadow
            { 6,    3250858 }, -- Rogue
            { 8,    3250860 }, -- Hunter
            { 10,   3250870 }, -- Warrior / Prot
            { 11,   3250868 }, -- Warrior / DD
            { 13,   3250874 }, -- Deathknight / Prot
            { 14,   3250872 }, -- Deathknight / DD
            { 16,   3250844 }, -- Mage
            { 18,   3250852 }, -- Druid / Heal
            { 19,   3250854 }, -- Druid / Owl
            { 20,   3250856 }, -- Druid / Feral
            { 22,   3250862 }, -- Shaman / Heal
            { 23,   3250863 }, -- Shaman / Ele
            { 24,   3250866 }, -- Shaman / Enh
            { 26,   3250876 }, -- Paladin / Heal
            { 27,   3250880 }, -- Paladin / Prot
            { 28,   3250878 }, -- Paladin / DD
        },
        { -- alli
            { 1,    3250846 }, -- Warlock
            { 3,    3250847 }, -- Priest / Heal
            { 4,    3250849 }, -- Priest / Shadow
            { 6,    3250857 }, -- Rogue
            { 8,    3250859 }, -- Hunter
            { 10,   3250869 }, -- Warrior / Prot
            { 11,   3250867 }, -- Warrior / DD
            { 13,   3250873 }, -- Deathknight / Prot
            { 14,   3250871 }, -- Deathknight / DD
            { 16,   3250843 }, -- Mage
            { 18,   3250851 }, -- Druid / Heal
            { 19,   3250853 }, -- Druid / Owl
            { 20,   3250855 }, -- Druid / Feral
            { 22,   3250861 }, -- Shaman / Heal
            { 23,   3250864 }, -- Shaman / Ele
            { 24,   3250865 }, -- Shaman / Enh
            { 26,   3250875 }, -- Paladin / Heal
            { 27,   3250879 }, -- Paladin / Prot
            { 28,   3250877 }, -- Paladin / DD
        }
    ),
    [RAID25H_DIFF] = AtlasLoot:GetRetByFaction(
        { -- horde
            { 1,    3251845 }, -- Warlock
            { 3,    3251848 }, -- Priest / Heal
            { 4,    3251850 }, -- Priest / Shadow
            { 6,    3251858 }, -- Rogue
            { 8,    3251860 }, -- Hunter
            { 10,   3251870 }, -- Warrior / Prot
            { 11,   3251868 }, -- Warrior / DD
            { 13,   3251874 }, -- Deathknight / Prot
            { 14,   3251872 }, -- Deathknight / DD
            { 16,   3251844 }, -- Mage
            { 18,   3251852 }, -- Druid / Heal
            { 19,   3251854 }, -- Druid / Owl
            { 20,   3251856 }, -- Druid / Feral
            { 22,   3251862 }, -- Shaman / Heal
            { 23,   3251863 }, -- Shaman / Ele
            { 24,   3251866 }, -- Shaman / Enh
            { 26,   3251876 }, -- Paladin / Heal
            { 27,   3251880 }, -- Paladin / Prot
            { 28,   3251878 }, -- Paladin / DD
        },
        { -- alli
            { 1,    3251846 }, -- Warlock
            { 3,    3251847 }, -- Priest / Heal
            { 4,    3251849 }, -- Priest / Shadow
            { 6,    3251857 }, -- Rogue
            { 8,    3251859 }, -- Hunter
            { 10,   3251869 }, -- Warrior / Prot
            { 11,   3251867 }, -- Warrior / DD
            { 13,   3251873 }, -- Deathknight / Prot
            { 14,   3251871 }, -- Deathknight / DD
            { 16,   3251843 }, -- Mage
            { 18,   3251851 }, -- Druid / Heal
            { 19,   3251853 }, -- Druid / Owl
            { 20,   3251855 }, -- Druid / Feral
            { 22,   3251861 }, -- Shaman / Heal
            { 23,   3251864 }, -- Shaman / Ele
            { 24,   3251865 }, -- Shaman / Enh
            { 26,   3251875 }, -- Paladin / Heal
            { 27,   3251879 }, -- Paladin / Prot
            { 28,   3251877 }, -- Paladin / DD
        }
    ),
}

local T10_SET = {
	name = format(AL["Tier %s Sets"], "10"),
	ExtraList = true,
	TableType = SET_ITTYPE,
	--ContentPhaseBC = 6,
	IgnoreAsSource = true,
	[VENDOR_DIFF] = {
		{ 1,    3000884 }, -- Warlock
		{ 3,    3000885 }, -- Priest / Heal
        { 4,    3000886 }, -- Priest / Shadow
        { 6,    3000890 }, -- Rogue
		{ 8,    3000891 }, -- Hunter
		{ 10,   3000896 }, -- Warrior / Prot
        { 11,   3000895 }, -- Warrior / DD
        { 13,   3000898 }, -- Deathknight / Prot
        { 14,   3000897 }, -- Deathknight / DD
		{ 16,   3000883 }, -- Mage
		{ 18,   3000887 }, -- Druid / Heal
        { 19,   3000888 }, -- Druid / Owl
        { 20,   3000889 }, -- Druid / Feral
        { 22,   3000892 }, -- Shaman / Heal
        { 23,   3000893 }, -- Shaman / Ele
        { 24,   3000894 }, -- Shaman / Enh
		{ 26,   3000899 }, -- Paladin / Heal
        { 27,   3000901 }, -- Paladin / Prot
        { 28,   3000900 }, -- Paladin / DD
	},
    [T10_1_DIFF] = {
		{ 1,    3250884 }, -- Warlock
		{ 3,    3250885 }, -- Priest / Heal
        { 4,    3250886 }, -- Priest / Shadow
        { 6,    3250890 }, -- Rogue
		{ 8,    3250891 }, -- Hunter
		{ 10,   3250896 }, -- Warrior / Prot
        { 11,   3250895 }, -- Warrior / DD
        { 13,   3250898 }, -- Deathknight / Prot
        { 14,   3250897 }, -- Deathknight / DD
		{ 16,   3250883 }, -- Mage
		{ 18,   3250887 }, -- Druid / Heal
        { 19,   3250888 }, -- Druid / Owl
        { 20,   3250889 }, -- Druid / Feral
        { 22,   3250892 }, -- Shaman / Heal
        { 23,   3250893 }, -- Shaman / Ele
        { 24,   3250894 }, -- Shaman / Enh
		{ 26,   3250899 }, -- Paladin / Heal
        { 27,   3250901 }, -- Paladin / Prot
        { 28,   3250900 }, -- Paladin / DD
	},
    [T10_2_DIFF] = {
		{ 1,    3251884 }, -- Warlock
		{ 3,    3251885 }, -- Priest / Heal
        { 4,    3251886 }, -- Priest / Shadow
        { 6,    3251890 }, -- Rogue
		{ 8,    3251891 }, -- Hunter
		{ 10,   3251896 }, -- Warrior / Prot
        { 11,   3251895 }, -- Warrior / DD
        { 13,   3251898 }, -- Deathknight / Prot
        { 14,   3251897 }, -- Deathknight / DD
		{ 16,   3251883 }, -- Mage
		{ 18,   3251887 }, -- Druid / Heal
        { 19,   3251888 }, -- Druid / Owl
        { 20,   3251889 }, -- Druid / Feral
        { 22,   3251892 }, -- Shaman / Heal
        { 23,   3251893 }, -- Shaman / Ele
        { 24,   3251894 }, -- Shaman / Enh
		{ 26,   3251899 }, -- Paladin / Heal
        { 27,   3251901 }, -- Paladin / Prot
        { 28,   3251900 }, -- Paladin / DD
	},
}
local T1_SET = {
	name = format(AL["Tier %s Sets"], "1"),
	ExtraList = true,
	TableType = SET_ITTYPE,
	--ContentPhaseBC = 6,
	IgnoreAsSource = true,
	[NORMAL_DIFF] = {
        {1,1994},
        {3,1995},
        {4,1996},
        {6,1991},
        {8,1993},
        {10,1999},
        {11,2000},
        {13,1998},
        {14,1997},
        {16,1992},
        {18,2004},
        {19,2005},
        {20,2006},
        {22,2007},
        {23,2008},
        {24,2009},
        {26,2001},
        {27,2003},
        {28,2002},
	},
}
local T5_SET = {
	name = format(AL["Tier %s Sets"], "5"),
	ExtraList = true,
	TableType = SET_ITTYPE,
	--ContentPhaseBC = 6,
	IgnoreAsSource = true,
	[NORMAL_DIFF] = {
		{ 1,    646 }, -- Warlock
		{ 3,    665 }, -- Priest / Heal
        { 4,    666 }, -- Priest / Shadow
        { 6,    622 }, -- Rogue
		{ 8,    652 }, -- Hunter
		{ 10,    656 }, -- Warrior / Prot
        { 11,    657 }, -- Warrior / DD
        { 13,  2011},
        { 14,  2012},
		{ 16,   649 }, -- Mage
		{ 18,   642 }, -- Druid / Heal
        { 19,   643 }, -- Druid / Owl
        { 20,   641 }, -- Druid / Feral
        { 22,   634 }, -- Shaman / Heal
        { 23,   635 }, -- Shaman / Ele
        { 24,   636 }, -- Shaman / Enh
		{ 26,   627 }, -- Paladin / Heal
        { 27,   628 }, -- Paladin / Prot
        { 28,   629 }, -- Paladin / DD
	},
}

local T6_SET = {
	name = format(AL["Tier %s Sets"], "6"),
	ExtraList = true,
	TableType = SET_ITTYPE,
	--ContentPhaseBC = 6,
	IgnoreAsSource = true,
	[NORMAL_DIFF] = {
		{ 1,    670 }, -- Warlock
		{ 3,    675 }, -- Priest / Heal
        { 4,    674 }, -- Priest / Shadow
        { 6,    668 }, -- Rogue
		{ 8,    669 }, -- Hunter
		{ 10,    673 }, -- Warrior / Prot
        { 11,    672 }, -- Warrior / DD
		{ 16,   671 }, -- Mage
		{ 18,   678 }, -- Druid / Heal
        { 19,   677 }, -- Druid / Owl
        { 20,   676 }, -- Druid / Feral
        { 22,   683 }, -- Shaman / Heal
        { 23,   684 }, -- Shaman / Ele
        { 24,   682 }, -- Shaman / Enh
		{ 26,   681 }, -- Paladin / Heal
        { 27,   679 }, -- Paladin / Prot
        { 28,   680 }, -- Paladin / DD
	},
}


local WOTLK_DUNGEONMASTER_AC_TABLE = {	--[Northrend Dungeonmaster]
    AchievementID = 1288,
	TableType = AC_ITTYPE,
	ExtraList = true,
    IgnoreAsSource = true,
	CoinTexture = "Achievement",
	[NORMAL_DIFF] = {
		{ 1, 1288 },
		{ 2, 477 },			{ 17, 478 },
		{ 3, 479 },			{ 18, 480 },
		{ 4, 481 },			{ 19, 482 },
		{ 5, 483 },			{ 20, 484 },
		{ 6, 485 },			{ 21, 486 },
		{ 7, 487 },			{ 22, 488 },
	},
}

local WOTLK_DUNGEON_HERO_AC_TABLE = {	--[Northrend Dungeon Hero]
    AchievementID = 1289,
	TableType = AC_ITTYPE,
	ExtraList = true,
    IgnoreAsSource = true,
	CoinTexture = "Achievement",
	[HEROIC_DIFF] = {
		{ 1, 1289 },
		{ 2, 489 },			{ 17, 490 },
		{ 3, 500 },			{ 18, 491 },
		{ 4, 492 },			{ 19, 493 },
		{ 5, 494 },			{ 20, 495 },
		{ 6, 496 },			{ 21, 497 },
		{ 7, 498 },			{ 22, 499 },
	},
}

local WOTLK_GLORY_OF_THE_HERO_AC_TABLE = {	--[Glory of the Hero]
    AchievementID = 2136,
	TableType = AC_ITTYPE,
	ExtraList = true,
    IgnoreAsSource = true,
	CoinTexture = "Achievement",
	[HEROIC_DIFF] = {
		{ 1, 2136, 44160 },
		{ 2, 1919 },			{ 17, 2150 },
		{ 3, 2036 },			{ 18, 2037 },
		{ 4, 1296 },			{ 19, 1297 },
		{ 5, 1860 },			{ 20, 1862 },
		{ 6, 2038 },			{ 21, 2056 },
		{ 7, 2151 },			{ 22, 2039 },
		{ 8, 2057 },			{ 23, 1816 },
		{ 9, 1865 },			{ 24, 2041 },
		{ 10, 2153 },			{ 25, 1864 },
		{ 11, 2152 },			{ 26, 2040 },
		{ 12, 2058 },			{ 27, 1866 },
		{ 13, 2154 },			{ 28, 2155 },
		{ 14, 1867 },			{ 29, 1834 },
		{ 15, 2042 },			{ 30, 1817 },
		{ 101, 1872 },			{ 116, 2043 },
		{ 102, 1873 },			{ 117, 2156 },
		{ 103, 2157 },			{ 118, 1871 },
		{ 104, 1868 },			{ 119, 2044 },
		{ 105, 2045 },			{ 120, 2046 },
	},
}

local WOTLK_NAXXRAMAS_AC_TABLE = {	--[Glory of the Raider]
	name = AL["Glory of the Raider"],
	TableType = AC_ITTYPE,
	ExtraList = true,
    IgnoreAsSource = true,
	CoinTexture = "Achievement",
	[RAID10_DIFF] = {
		{ 1, 2137, 44175 },
		{ 2, 578 },			    { 17, 1858 },
		{ 3, 1856 },			{ 18, 1996 },
		{ 4, 1997 },			{ 19, 2178 },
		{ 5, 2180 },			{ 20, 622 },
		{ 6, 1874 },			{ 21, 1869 },
		{ 7, 2047 },			{ 22, 2051 },
		{ 8, 2146 },			{ 23, 2176 },
		{ 9, 2148 },			{ 24, 2184 },
        { 10, 2187 },
	},
    [RAID25_DIFF] = {
		{ 1, 2138, 44164 },
		{ 2, 579 },			    { 17, 1859 },
		{ 3, 1857 },			{ 18, 2139 },
		{ 4, 2140 },			{ 19, 2179 },
		{ 5, 2181 },			{ 20, 623  },
		{ 6, 1875 },			{ 21, 1870 },
		{ 7, 2048 },			{ 22, 2054 },
		{ 8, 2147 },			{ 23, 2177 },
		{ 9, 2149 },			{ 24, 2185 },
        { 10, 2186 },
	},
}

local WOTLK_ULDUAR_AC_TABLE = {	--[Glory of the Ulduar Raider]
	name = AL["Glory of the Ulduar Raider"],
	TableType = AC_ITTYPE,
	ExtraList = true,
    IgnoreAsSource = true,
	CoinTexture = "Achievement",
	[RAID10_DIFF] = {
		{ 1, 2957, 45802 },
		{ 2, 3056 },			{ 17, 2930 },
		{ 3, 2923 },			{ 18, 3058 },
		{ 4, 2941 },			{ 19, 2953 },
		{ 5, 3006 },			{ 20, 3182 },
		{ 6, 3176 },			{ 21, 3179 },
		{ 7, 3180 },			{ 22, 3181 },
		{ 8, 3158 }
	},
    [RAID25_DIFF] = {
		{ 1, 2958, 45801 },
		{ 2, 3057 },			{ 17, 2929 },
		{ 3, 2924 },			{ 18, 3059 },
		{ 4, 2944 },			{ 19, 2954 },
		{ 5, 3007 },			{ 20, 3184 },
		{ 6, 3183 },			{ 21, 3187 },
		{ 7, 3189 },			{ 22, 3188 },
		{ 8, 3163 }
	},
}

local WOTLK_ICC_AC_TABLE = {	--[Glory of the Icecrown Raider]
	name = AL["Glory of the Icecrown Raider"],
	TableType = AC_ITTYPE,
	ExtraList = true,
	CoinTexture = "Achievement",
	[RAID10_DIFF] = {
		{ 1, 4602, 51954 },
		{ 2, 4534 },			{ 17, 4535 },
		{ 3, 4536 },			{ 18, 4537 },
		{ 4, 4538 },			{ 19, 4577 },
		{ 5, 4578 },			{ 20, 4582 },
		{ 6, 4539 },			{ 21, 4579 },
		{ 7, 4580 },			{ 22, 4601 },
	},
	[RAID10H_DIFF] = {
		{ 1, 4602, 51954 },
		{ 2, 4628 },			{ 17, 4629 },
		{ 3, 4630 },			{ 18, 4631 },
	},
    [RAID25_DIFF] = {
		{ 1, 4603, 51955 },
		{ 2, 4610 },			{ 17, 4611 },
		{ 3, 4612 },			{ 18, 4613 },
		{ 4, 4614 },			{ 19, 4615 },
		{ 5, 4616 },			{ 20, 4617 },
		{ 6, 4618 },			{ 21, 4619 },
		{ 7, 4620 },			{ 22, 4621 },
		{ 8, 4622 }
	},
	[RAID25H_DIFF] = {
		{ 1, 4603, 51955 },
		{ 2, 4632 },			{ 17, 4633 },
		{ 3, 4634 },			{ 18, 4635 },
	},
}

data["AhnKahet"] = {
    nameFormat = NAME_AZJOL,
	MapID = 4494,
    EncounterJournalID = 271,
	InstanceID = 619,
    ContentType = DUNGEON_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "AhnKahet",
	AtlasMapFile = {"AhnKahet"},
	LevelRange = {68, 73, 75},
	items = {
        { -- AhnkahetNadox / 15
            name = AL["Elder Nadox"],
            npcID = 29309,
            EncounterJournalID = 580,
            Level = 75,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 35607 }, -- Ahn'kahar Handwraps
                { 2, 35608 }, -- Crawler-Emblem Belt
                { 3, 35606 }, -- Blade of Nadox
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37594 }, -- Elder Headpiece
                { 4, 37593 }, -- Sprinting Shoulderpads
                { 5, 37592 }, -- Brood Plague Helmet
                { 6, 37591 }, -- Nerubian Shield Ring
                { 8, "ac2038" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39255 }, -- Staff of the Plague Beast
                { 4, 39249 }, -- Shoulderplates of Bloodshed
                { 5, 39263 }, -- Dissevered Leggings
                { 7, 37594 }, -- Elder Headpiece
                { 8, 37593 }, -- Sprinting Shoulderpads
                { 9, 37592 }, -- Brood Plague Helmet
                { 10, 37591 }, -- Nerubian Shield Ring
                { 12, "ac2038" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45314 }, -- Igniter Rod
                { 4, 45310 }, -- Gauntlets of the Iron Furnace
                { 6, 39255 }, -- Staff of the Plague Beast
                { 7, 39249 }, -- Shoulderplates of Bloodshed
                { 8, 39263 }, -- Dissevered Leggings
                { 10, "ac2038" },
            }
        },
        { -- AhnkahetTaldaram / 16
            name = AL["Prince Taldaram"],
            npcID = 29308,
            EncounterJournalID = 581,
            Level = 75,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 35611 }, -- Gloves of the Blood Prince
                { 2, 35610 }, -- Slasher's Amulet
                { 3, 35609 }, -- Talisman of Scourge Command
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37613 }, -- Flame Sphere Bindings
                { 4, 37614 }, -- Gauntlets of the Plundering Geist
                { 5, 37612 }, -- Bonegrinder Breastplate
                { 6, 37595 }, -- Necklace of Taldaram
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39251 }, -- Necrogenic Belt
                { 4, 39247 }, -- Cuffs of Dark Shadows
                { 5, 39260 }, -- Helm of the Corrupted Mind
                { 7, 37613 }, -- Flame Sphere Bindings
                { 8, 37614 }, -- Gauntlets of the Plundering Geist
                { 9, 37612 }, -- Bonegrinder Breastplate
                { 10, 37595 }, -- Necklace of Taldaram
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45321 }, -- Pauldrons of Tempered Will
                { 4, 46019 }, -- Leggings of the Insatiable
                { 6, 39251 }, -- Necrogenic Belt
                { 7, 39247 }, -- Cuffs of Dark Shadows
                { 8, 39260 }, -- Helm of the Corrupted Mind
            }
        },
        { -- AhnkahetAmanitarHEROIC / 17
            name = AL["Amanitar"],
            npcID = 30258,
            EncounterJournalID = 583,
            Level = 82,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 3,
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 43287 }, -- Silken Bridge Handwraps
                { 4, 43286 }, -- Legguards of Swarming Attacks
                { 5, 43285 }, -- Amulet of the Spell Flinger
                { 6, 43284 }, -- Amanitar Skullbow
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39251 }, -- Necrogenic Belt
                { 4, 39247 }, -- Cuffs of Dark Shadows
                { 5, 39260 }, -- Helm of the Corrupted Mind
                { 7, 43287 }, -- Silken Bridge Handwraps
                { 8, 43286 }, -- Legguards of Swarming Attacks
                { 9, 43285 }, -- Amulet of the Spell Flinger
                { 10, 43284 }, -- Amanitar Skullbow
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45317 }, -- Shawl of the Caretaker
                { 4, 45309 }, -- Rifle of the Platinum Guard
                { 6, 39251 }, -- Necrogenic Belt
                { 7, 39247 }, -- Cuffs of Dark Shadows
                { 8, 39260 }, -- Helm of the Corrupted Mind
            }
        },
        { -- AhnkahetJedoga / 18
            name = AL["Jedoga Shadowseeker"],
            npcID = 29310,
            EncounterJournalID = 582,
            Level = 75,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 4,
            [NORMAL_DIFF] = {
                { 1, 43278 }, -- Cloak of the Darkcaster
                { 2, 43279 }, -- Battlechest of the Twilight Cult
                { 3, 43277 }, -- Jedoga's Greatring
                { 16, 21524 }, -- Red Winter Hat
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 43283 }, -- Subterranean Waterfall Shroud
                { 4, 43280 }, -- Faceguard of the Hammer Clan
                { 5, 43282 }, -- Shadowseeker's Pendant
                { 6, 43281 }, -- Edge of Oblivion
                { 8, 21524 }, -- Red Winter Hat
                { 10, "ac2056" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39258 }, -- Legplates of Inescapable Death
                { 4, 39246 }, -- Amulet of Autopsy
                { 5, 39250 }, -- Ring of Holy Cleansing
                { 7, 43283 }, -- Subterranean Waterfall Shroud
                { 8, 43280 }, -- Faceguard of the Hammer Clan
                { 9, 43282 }, -- Shadowseeker's Pendant
                { 10, 43281 }, -- Edge of Oblivion
                { 12, 21524 }, -- Red Winter Hat
                { 14, "ac2056" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45702 }, -- Emerald Signet Ring
                { 4, 45701 }, -- Greaves of the Earthbinder
                { 6, 39258 }, -- Legplates of Inescapable Death
                { 7, 39246 }, -- Amulet of Autopsy
                { 8, 39250 }, -- Ring of Holy Cleansing
                { 10, 21524 }, -- Red Winter Hat
                { 12, "ac2056" },
            }
        },
        { -- AhnkahetVolazj / 19
            name = AL["Herald Volazj"],
            npcID = 29311,
            EncounterJournalID = 584,
            Level = 75,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 5,
            [NORMAL_DIFF] = {
                { 1, 35612 }, -- Mantle of Echoing Bats
                { 2, 35613 }, -- Pyramid Embossed Belt
                { 3, 35614 }, -- Volazj's Sabatons
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37622 }, -- Skirt of the Old Kingdom
                { 4, 37623 }, -- Fiery Obelisk Handguards
                { 5, 37620 }, -- Bracers of the Herald
                { 6, 37619 }, -- Wand of Ahnkahet
                { 8, 37616 }, -- Kilt of the Forgotten One
                { 9, 37618 }, -- Greaves of Ancient Evil
                { 10, 37617 }, -- Staff of Sinister Claws
                { 11, 37615 }, -- Titanium Compound Bow
                { 16, 43102 }, -- Frozen Orb
                { 18, 41790 }, -- Design: Precise Scarlet Ruby
                { 20, "ac1862" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37622 }, -- Skirt of the Old Kingdom
                { 4, 37623 }, -- Fiery Obelisk Handguards
                { 5, 37620 }, -- Bracers of the Herald
                { 6, 37619 }, -- Wand of Ahnkahet
                { 8, 37616 }, -- Kilt of the Forgotten One
                { 9, 37618 }, -- Greaves of Ancient Evil
                { 10, 37617 }, -- Staff of Sinister Claws
                { 11, 37615 }, -- Titanium Compound Bow
                { 13, 41790 }, -- Design: Precise Scarlet Ruby
                { 15, 43102 }, -- Frozen Orb
                { 16, 39417 }, -- Death's Bite
                { 17, 43998 }, -- Chestguard of Flagrant Prowess
                { 18, 40486 }, -- Necklace of the Glittering Chamber
                { 20, 40616 }, -- Helm of the Lost Conqueror
                { 21, 40617 }, -- Helm of the Lost Protector
                { 22, 40618 }, -- Helm of the Lost Vanquisher
                { 23, 40622 }, -- Spaulders of the Lost Conqueror
                { 24, 40623 }, -- Spaulders of the Lost Protector
                { 25, 40624 }, -- Spaulders of the Lost Vanquisher
                { 26, 40619 }, -- Leggings of the Lost Conqueror
                { 27, 40620 }, -- Leggings of the Lost Protector
                { 28, 40621 }, -- Leggings of the Lost Vanquisher
                { 30, "ac1862" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45696 }, -- Mark of the Unyielding
                { 4, 45704 }, -- Shawl of the Shattered Giant
                { 5, 45699 }, -- Pendant of the Piercing Glare
                { 7, 39417 }, -- Death's Bite
                { 8, 43998 }, -- Chestguard of Flagrant Prowess
                { 9, 40486 }, -- Necklace of the Glittering Chamber
				{ 16, "INV_Box_01", nil, AL["Tier Token iLvl200"], nil, "Tier7TitanRuneTokens" },
				{ 17, "INV_Box_01", nil, AL["Tier Token iLvl225"], nil, "Tier8TitanRuneTokens" },
                { 19, 43102 }, -- Frozen Orb
                { 21, 41790 }, -- Design: Precise Scarlet Ruby
                { 23, "ac1862" },
                { 101, 40616 }, -- Helm of the Lost Conqueror
                { 102, 40617 }, -- Helm of the Lost Protector
                { 103, 40618 }, -- Helm of the Lost Vanquisher
                { 104, 40622 }, -- Spaulders of the Lost Conqueror
                { 105, 40623 }, -- Spaulders of the Lost Protector
                { 106, 40624 }, -- Spaulders of the Lost Vanquisher
                { 107, 40619 }, -- Leggings of the Lost Conqueror
                { 108, 40620 }, -- Leggings of the Lost Protector
                { 109, 40621 }, -- Leggings of the Lost Vanquisher
                { 116, 45647 }, -- Helm of the Wayward Conqueror
                { 117, 45648 }, -- Helm of the Warward Protector
                { 118, 45649 }, -- Helm of the Wayward Vanquisher
                { 119, 45659 }, -- Spaulders of the Wayward Conqueror
                { 120, 45660 }, -- Spaulders of the Wayward Protector
                { 121, 45661 }, -- Spaulders of the Wayward Vanquisher
                { 122, 45635 }, -- Chestguard of the Wayward Conqueror
                { 123, 45636 }, -- Chestguard of the Wayward Protector
                { 124, 45637 }, -- Chestguard of the Wayward Vanquisher
                { 125, 45644 }, -- Gloves of the Wayward Conqueror
                { 126, 45645 }, -- Gloves of the Wayward Protector
                { 127, 45646 }, -- Gloves of the Wayward Vanquisher
                { 128, 45650 }, -- Leggings of the Wayward Conqueror
                { 129, 45651 }, -- Leggings of the Wayward Protector
                { 130, 45652 }, -- Leggings of the Wayward Vanquisher
            }
        },
        { -- Trash
            name = AL["Trash"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 35616 }, -- Spored Tendrils Spaulders
		        { 2, 35615 }, -- Glowworm Cavern Bindings
            },
            [HEROIC_DIFF] = {
                { 1, 37625 }, -- Web Winder Gloves
		        { 2, 37624 }, -- Stained-Glass Shard Ring
            }
        },
        KEYS,
        WOTLK_DUNGEONMASTER_AC_TABLE,
		WOTLK_DUNGEON_HERO_AC_TABLE,
		WOTLK_GLORY_OF_THE_HERO_AC_TABLE,
    }
}

data["AzjolNerub"] = {
    nameFormat = NAME_AZJOL,
	MapID = 4277,
    EncounterJournalID = 272,
	InstanceID = 601,
    ContentType = DUNGEON_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "AzjolNerub",
	AtlasMapFile = {"AzjolNerub"},
	LevelRange = {67, 72, 74},
	items = {
        { -- AzjolNerubKrikthir / 11
            name = AL["Krik'thir the Gatewatcher"],
            npcID = 28684,
            EncounterJournalID = 585,
            Level = 74,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 35657 }, -- Exquisite Spider-Silk Footwraps
                { 2, 35656 }, -- Aura Focused Gauntlets
                { 3, 35655 }, -- Cobweb Machete
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37218 }, -- Stone-Worn Footwraps
                { 4, 37219 }, -- Custodian's Chestpiece
                { 5, 37217 }, -- Golden Limb Bands
                { 6, 37216 }, -- Facade Shield of Glyphs
                { 8, "ac1296" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39257 }, -- Loatheb's Shadow
                { 4, 39259 }, -- Fungi-Stained Coverings
                { 5, 39267 }, -- Abomination Shoulderblades
                { 7, 37218 }, -- Stone-Worn Footwraps
                { 8, 37219 }, -- Custodian's Chestpiece
                { 9, 37217 }, -- Golden Limb Bands
                { 10, 37216 }, -- Facade Shield of Glyphs
                { 12, "ac1296" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45874 }, -- Signet of Winter
                { 4, 45464 }, -- Cowl of Icy Breaths
                { 6, 39257 }, -- Loatheb's Shadow
                { 7, 39259 }, -- Fungi-Stained Coverings
                { 8, 39267 }, -- Abomination Shoulderblades
                { 10, "ac1296" },
            }
        },
        { -- AzjolNerubHadronox / 12
            name = AL["Hadronox"],
            npcID = 28921,
            EncounterJournalID = 586,
            Level = 74,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 35660 }, -- Spinneret Epaulets
                { 2, 35659 }, -- Treads of Aspiring Heights
                { 3, 35658 }, -- Life-Staff of the Web Lair
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37222 }, -- Egg Sac Robes
                { 4, 37230 }, -- Grotto Mist Gloves
                { 5, 37221 }, -- Hollowed Mandible Legplates
                { 6, 37220 }, -- Essence of Gossamer
                { 8, "ac1297" },
                --{ 30, xxx }, -- xxx
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39252 }, -- Preceptor's Bindings
                { 4, 39261 }, -- Tainted Girdle of Mending
                { 5, 39256 }, -- Sulfur Stave
                { 7, 37222 }, -- Egg Sac Robes
                { 8, 37230 }, -- Grotto Mist Gloves
                { 9, 37221 }, -- Hollowed Mandible Legplates
                { 10, 37220 }, -- Essence of Gossamer
                { 12, "ac1297" },
                --{ 30, xxx }, -- xxx
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45316 }, -- Armbraces of the Vibrant Flame
                { 4, 45458 }, -- Stormedge
                { 6, 39252 }, -- Preceptor's Bindings
                { 7, 39261 }, -- Tainted Girdle of Mending
                { 8, 39256 }, -- Sulfur Stave
                { 10, "ac1297" },
                --{ 30, xxx }, -- xxx
            }
        },
        { -- AzjolNerubAnubarak / 13
            name = AL["Anub'arak"],
            npcID = 29120,
            EncounterJournalID = 587,
            Level = 74,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 35663 }, -- Charmed Silken Cord
                { 2, 35662 }, -- Wing Cover Girdle
                { 3, 35661 }, -- Signet of Arachnathid Command
                { 16, 43411 }, -- Anub'arak's Broken Husk
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37242 }, -- Sash of the Servant
                { 4, 37240 }, -- Flamebeard's Bracers
                { 5, 37241 }, -- Ancient Aligned Girdle
                { 6, 37238 }, -- Rod of the Fallen Monarch
                { 8, 37236 }, -- Insect Vestments
                { 9, 37237 }, -- Chitin Shell Greathelm
                { 10, 37232 }, -- Ring of the Traitor King
                { 11, 37235 }, -- Crypt Lord's Deft Blade
                { 16, 43102 }, -- Frozen Orb
                { 18, 41796 }, -- Design: Infused Twilight Opal
                { 20, "ac1860" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37242 }, -- Sash of the Servant
                { 4, 37240 }, -- Flamebeard's Bracers
                { 5, 37241 }, -- Ancient Aligned Girdle
                { 6, 37238 }, -- Rod of the Fallen Monarch
                { 8, 37236 }, -- Insect Vestments
                { 9, 37237 }, -- Chitin Shell Greathelm
                { 10, 37232 }, -- Ring of the Traitor King
                { 11, 37235 }, -- Crypt Lord's Deft Blade
                { 13, 41796 }, -- Design: Infused Twilight Opal
                { 15, 43102 }, -- Frozen Orb
                { 16, 39419 }, -- Nerubian Conquerer
                { 17, 43994 }, -- Belabored Legplates
                { 18, 39425 }, -- Cloak of the Dying
                { 20, 40616 }, -- Helm of the Lost Conqueror
                { 21, 40617 }, -- Helm of the Lost Protector
                { 22, 40618 }, -- Helm of the Lost Vanquisher
                { 23, 40622 }, -- Spaulders of the Lost Conqueror
                { 24, 40623 }, -- Spaulders of the Lost Protector
                { 25, 40624 }, -- Spaulders of the Lost Vanquisher
                { 26, 40619 }, -- Leggings of the Lost Conqueror
                { 27, 40620 }, -- Leggings of the Lost Protector
                { 28, 40621 }, -- Leggings of the Lost Vanquisher
                { 30, "ac1860" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45312 }, -- Gloves of Smoldering Touch
                { 4, 45318 }, -- Drape of Fuming Anger
                { 5, 45313 }, -- Furnace Stone
                { 7, 39419 }, -- Nerubian Conquerer
                { 8, 43994 }, -- Belabored Legplates
                { 9, 39425 }, -- Cloak of the Dying
				{ 16, "INV_Box_01", nil, AL["Tier Token iLvl200"], nil, "Tier7TitanRuneTokens" },
				{ 17, "INV_Box_01", nil, AL["Tier Token iLvl225"], nil, "Tier8TitanRuneTokens" },
                { 19, 43102 }, -- Frozen Orb
                { 21, 41796 }, -- Design: Infused Twilight Opal
                { 23, "ac1860" },
                { 101, 40616 }, -- Helm of the Lost Conqueror
                { 102, 40617 }, -- Helm of the Lost Protector
                { 103, 40618 }, -- Helm of the Lost Vanquisher
                { 104, 40622 }, -- Spaulders of the Lost Conqueror
                { 105, 40623 }, -- Spaulders of the Lost Protector
                { 106, 40624 }, -- Spaulders of the Lost Vanquisher
                { 107, 40619 }, -- Leggings of the Lost Conqueror
                { 108, 40620 }, -- Leggings of the Lost Protector
                { 109, 40621 }, -- Leggings of the Lost Vanquisher
                { 116, 45647 }, -- Helm of the Wayward Conqueror
                { 117, 45648 }, -- Helm of the Warward Protector
                { 118, 45649 }, -- Helm of the Wayward Vanquisher
                { 119, 45659 }, -- Spaulders of the Wayward Conqueror
                { 120, 45660 }, -- Spaulders of the Wayward Protector
                { 121, 45661 }, -- Spaulders of the Wayward Vanquisher
                { 122, 45635 }, -- Chestguard of the Wayward Conqueror
                { 123, 45636 }, -- Chestguard of the Wayward Protector
                { 124, 45637 }, -- Chestguard of the Wayward Vanquisher
                { 125, 45644 }, -- Gloves of the Wayward Conqueror
                { 126, 45645 }, -- Gloves of the Wayward Protector
                { 127, 45646 }, -- Gloves of the Wayward Vanquisher
                { 128, 45650 }, -- Leggings of the Wayward Conqueror
                { 129, 45651 }, -- Leggings of the Wayward Protector
                { 130, 45652 }, -- Leggings of the Wayward Vanquisher
            }
        },
        { -- Trash
            name = AL["Trash"],
            ExtraList = true,
            [HEROIC_DIFF] = {
                { 1, 37243 }, -- Treasure Seeker's Belt
                { 2, 37625 }, -- Web Winder Gloves
                { 3, 37624 }, -- Stained-Glass Shard Ring
            }
        },
        KEYS,
        WOTLK_DUNGEONMASTER_AC_TABLE,
		WOTLK_DUNGEON_HERO_AC_TABLE,
		WOTLK_GLORY_OF_THE_HERO_AC_TABLE,
    }
}

data["DrakTharonKeep"] = {
	MapID = 4196,
    EncounterJournalID = 273,
	InstanceID = 600,
    ContentType = DUNGEON_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "DrakTharonKeep",
	AtlasMapFile = {"DrakTharonKeep"},
	LevelRange = {69, 74, 76},
	items = {
        { -- DrakTharonKeepTrollgore / 21
            name = AL["Trollgore"],
            npcID = 26630,
            EncounterJournalID = 588,
            Level = 76,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 35620 }, -- Berserker's Horns
                { 2, 35619 }, -- Infection Resistant Legguards
                { 3, 35618 }, -- Troll Butcherer
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37715 }, -- Cowl of the Dire Troll
                { 4, 37714 }, -- Batrider's Cord
                { 5, 37717 }, -- Legs of Physical Regeneration
                { 6, 37712 }, -- Terrace Defence Boots
                { 8, "ac2151" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39241 }, -- Dark Shroud of the Scourge
                { 4, 39242 }, -- Robes of Hoarse Breaths
                { 5, 39245 }, -- Demise
                { 7, 37715 }, -- Cowl of the Dire Troll
                { 8, 37714 }, -- Batrider's Cord
                { 9, 37717 }, -- Legs of Physical Regeneration
                { 10, 37712 }, -- Terrace Defence Boots
                { 12, "ac2151" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45698 }, -- Sabatons of the Iron Watcher
                { 4, 45697 }, -- Shoulderguards of the Solemn Watch
                { 6, 39241 }, -- Dark Shroud of the Scourge
                { 7, 39242 }, -- Robes of Hoarse Breaths
                { 8, 39245 }, -- Demise
                { 10, "ac2151" },
            }
        },
        { -- DrakTharonKeepNovos / 22
            name = AL["Novos the Summoner"],
            npcID = 26631,
            Level = 76,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 35632 }, -- Robes of Novos
                { 2, 35631 }, -- Crystal Pendant of Warding
                { 3, 35630 }, -- Summoner's Stone Gavel
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37722 }, -- Breastplate of Undeath
                { 4, 37718 }, -- Temple Crystal Fragment
                { 5, 37721 }, -- Cursed Lich Blade
                { 7, "ac2057" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39237 }, -- Spaulders of Resumed Battle
                { 4, 39244 }, -- Ring of the Fated
                { 5, 39236 }, -- Trespasser's Boots
                { 7, 37722 }, -- Breastplate of Undeath
                { 8, 37718 }, -- Temple Crystal Fragment
                { 9, 37721 }, -- Cursed Lich Blade
                { 11, "ac2057" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45703 }, -- Spark of Hope
                { 4, 45687 }, -- Helm of Veiled Energies
                { 6, 39237 }, -- Spaulders of Resumed Battle
                { 7, 39244 }, -- Ring of the Fated
                { 8, 39236 }, -- Trespasser's Boots
                { 10, "ac2057" },
            }
        },
        { -- DrakTharonKeepKingDred / 23
            name = AL["King Dred"],
            npcID = 27483,
            EncounterJournalID = 590,
            Level = 76,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 35635 }, -- Stable Master's Breeches
                { 2, 35634 }, -- Scabrous-Hide Helm
                { 3, 35633 }, -- Staff of the Great Reptile
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37725 }, -- Savage Wound Wrap
                { 4, 37724 }, -- Handler's Arm Strap
                { 5, 37726 }, -- King Dred's Helm
                { 6, 37723 }, -- Incisor Fragment
                { 8, "ac2039" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39243 }, -- Handgrips of the Foredoomed
                { 4, 39239 }, -- Chestplate of the Risen Soldier
                { 5, 39240 }, -- Noth's Curse
                { 7, 37725 }, -- Savage Wound Wrap
                { 8, 37724 }, -- Handler's Arm Strap
                { 9, 37726 }, -- King Dred's Helm
                { 10, 37723 }, -- Incisor Fragment
                { 12, "ac2039" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45975 }, -- Cable of the Metrognome
                { 4, 45700 }, -- Stoneguard
                { 6, 39243 }, -- Handgrips of the Foredoomed
                { 7, 39239 }, -- Chestplate of the Risen Soldier
                { 8, 39240 }, -- Noth's Curse
                { 10, "ac2039" },
            }
        },
        { -- DrakTharonKeepTharonja / 24
            name = AL["The Prophet Tharon'ja"],
            npcID = 26632,
            EncounterJournalID = 591,
            Level = 76,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 4,
            [NORMAL_DIFF] = {
                { 1, 35638 }, -- Helmet of Living Flesh
                { 2, 35637 }, -- Muradin's Lost Greaves
                { 3, 35636 }, -- Tharon'ja's Aegis
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37798 }, -- Overlook Handguards
                { 4, 37791 }, -- Leggings of the Winged Serpent
                { 5, 37788 }, -- Limb Regeneration Bracers
                { 6, 37784 }, -- Keystone Great-Ring
                { 8, 37735 }, -- Ziggurat Imprinted Chestguard
                { 9, 37732 }, -- Spectral Seal of the Prophet
                { 10, 37734 }, -- Talisman of Troll Divinity
                { 11, 37733 }, -- Mojo Masked Crusher
                { 16, 43102 }, -- Frozen Orb
                { 18, 41795 }, -- Design: Timeless Forest Emerald
                { 20, "ac1658" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37798 }, -- Overlook Handguards
                { 4, 37791 }, -- Leggings of the Winged Serpent
                { 5, 37788 }, -- Limb Regeneration Bracers
                { 6, 37784 }, -- Keystone Great-Ring
                { 8, 37735 }, -- Ziggurat Imprinted Chestguard
                { 9, 37732 }, -- Spectral Seal of the Prophet
                { 10, 37734 }, -- Talisman of Troll Divinity
                { 11, 37733 }, -- Mojo Masked Crusher
                { 13, 41795 }, -- Design: Timeless Forest Emerald
                { 15, 43102 }, -- Frozen Orb
                { 16, 43995 }, -- Enamored Cowl
                { 17, 39416 }, -- Kel'Thuzad's Reach
                { 18, 43996 }, -- Sabatons of Firmament
                { 20, 40616 }, -- Helm of the Lost Conqueror
                { 21, 40617 }, -- Helm of the Lost Protector
                { 22, 40618 }, -- Helm of the Lost Vanquisher
                { 23, 40622 }, -- Spaulders of the Lost Conqueror
                { 24, 40623 }, -- Spaulders of the Lost Protector
                { 25, 40624 }, -- Spaulders of the Lost Vanquisher
                { 26, 40619 }, -- Leggings of the Lost Conqueror
                { 27, 40620 }, -- Leggings of the Lost Protector
                { 28, 40621 }, -- Leggings of the Lost Vanquisher
                { 30, "ac1658" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
				{ 3, 45303 }, -- Band of Draconic Guile
				{ 4, 45972 }, -- Pulse Baton
				{ 5, 45974 }, -- Shoulderguards of Assimilation
				{ 7, 43995 }, -- Enamored Cowl
				{ 8, 39416 }, -- Kel'Thuzad's Reach
				{ 9, 43996 }, -- Sabatons of Firmament
				{ 16, "INV_Box_01", nil, AL["Tier Token iLvl200"], nil, "Tier7TitanRuneTokens" },
				{ 17, "INV_Box_01", nil, AL["Tier Token iLvl225"], nil, "Tier8TitanRuneTokens" },
				{ 19, 43102 }, -- Frozen Orb { 21, 41796 }, -- Design: Infused Twilight Opal
				{ 23, "ac1860" }, { 101, 40616 }, -- Helm of the Lost Conqueror
				{ 102, 40617 }, -- Helm of the Lost Protector
				{ 103, 40618 }, -- Helm of the Lost Vanquisher
				{ 104, 40622 }, -- Spaulders of the Lost Conqueror
				{ 105, 40623 }, -- Spaulders of the Lost Protector
				{ 106, 40624 }, -- Spaulders of the Lost Vanquisher
				{ 107, 40619 }, -- Leggings of the Lost Conqueror
				{ 108, 40620 }, -- Leggings of the Lost Protector
				{ 109, 40621 }, -- Leggings of the Lost Vanquisher
				{ 116, 45647 }, -- Helm of the Wayward Conqueror
				{ 117, 45648 }, -- Helm of the Warward Protector
				{ 118, 45649 }, -- Helm of the Wayward Vanquisher
				{ 119, 45659 }, -- Spaulders of the Wayward Conqueror
				{ 120, 45660 }, -- Spaulders of the Wayward Protector
				{ 121, 45661 }, -- Spaulders of the Wayward Vanquisher
				{ 122, 45635 }, -- Chestguard of the Wayward Conqueror
				{ 123, 45636 }, -- Chestguard of the Wayward Protector
				{ 124, 45637 }, -- Chestguard of the Wayward Vanquisher
				{ 125, 45644 }, -- Gloves of the Wayward Conqueror
				{ 126, 45645 }, -- Gloves of the Wayward Protector
				{ 127, 45646 }, -- Gloves of the Wayward Vanquisher
				{ 128, 45650 }, -- Leggings of the Wayward Conqueror
				{ 129, 45651 }, -- Leggings of the Wayward Protector
				{ 130, 45652 }, -- Leggings of the Wayward Vanquisher
            }
        },
        { -- Trash
            name = AL["Trash"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 35641 }, -- Scytheclaw Boots
                { 2, 35640 }, -- Darkweb Bindings
                { 3, 35639 }, -- Brighthelm of Guarding
            },
            [HEROIC_DIFF] = {
                { 1, 37799 }, -- Reanimator's Cloak
                { 2, 37800 }, -- Aviary Guardsman's Hauberk
                { 3, 37801 }, -- Waistguard of the Risen Knight
            },
        },
        KEYS,
        WOTLK_DUNGEONMASTER_AC_TABLE,
		WOTLK_DUNGEON_HERO_AC_TABLE,
		WOTLK_GLORY_OF_THE_HERO_AC_TABLE,
    }
}

data["Gundrak"] = {
	MapID = 4416,
    EncounterJournalID = 274,
	InstanceID = 604,
    ContentType = DUNGEON_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "Gundrak",
	AtlasMapFile = {"Gundrak"},
	LevelRange = {71, 76, 78},
	items = {
        { -- GundrakSladran / 34
            name = AL["Slad'ran"],
            npcID = 29304,
            EncounterJournalID = 592,
            Level = 76,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 35584 }, -- Embroidered Gown of Zul'drak
                { 2, 35585 }, -- Cannibal's Legguards
                { 3, 35583 }, -- Witch Doctor's Wildstaff
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37629 }, -- Slithering Slippers
                { 4, 37628 }, -- Slad'ran's Coiled Cord
                { 5, 37627 }, -- Snake Den Spaulders
                { 6, 37626 }, -- Wand of Sseratus
                { 8, "ac2058" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39229 }, -- Embrace of the Spider
                { 4, 39230 }, -- Spaulders of the Monstrosity
                { 5, 39234 }, -- Plague-Impervious Boots
                { 7, 37629 }, -- Slithering Slippers
                { 8, 37628 }, -- Slad'ran's Coiled Cord
                { 9, 37627 }, -- Snake Den Spaulders
                { 10, 37626 }, -- Wand of Sseratus
                { 12, "ac2058" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45976 }, -- Static Charge Handwraps
                { 4, 45973 }, -- Stylish Power Cape
                { 6, 39229 }, -- Embrace of the Spider
                { 7, 39230 }, -- Spaulders of the Monstrosity
                { 8, 39234 }, -- Plague-Impervious Boots
                { 10, "ac2058" },
            }
        },
        { -- GundrakColossus / 35
            name = AL["Drakkari Colossus"],
            npcID = 29307,
            EncounterJournalID = 593,
            Level = 76,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 35591 }, -- Shoulderguards of the Ice Troll
                { 2, 35592 }, -- Hauberk of Totemic Mastery
                { 3, 35590 }, -- Drakkari Hunting Bow
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37637 }, -- Living Mojo Belt
                { 4, 37636 }, -- Helm of Cheated Fate
                { 5, 37634 }, -- Bracers of the Divine Elemental
                { 6, 37635 }, -- Pauldrons of the Colossus
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39225 }, -- Cloak of Armed Strife
                { 4, 39224 }, -- Leggings of Discord
                { 5, 39233 }, -- Aegis of Damnation
                { 7, 37637 }, -- Living Mojo Belt
                { 8, 37636 }, -- Helm of Cheated Fate
                { 9, 37634 }, -- Bracers of the Divine Elemental
                { 10, 37635 }, -- Pauldrons of the Colossus
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45306 }, -- Binding of the Dragon Matriarch
                { 4, 45301 }, -- Bracers of the Smothering Inferno
                { 6, 39225 }, -- Cloak of Armed Strife
                { 7, 39224 }, -- Leggings of Discord
                { 8, 39233 }, -- Aegis of Damnation
            }
        },
        { -- GundrakMoorabi / 36
            name = AL["Moorabi"],
            npcID = 29305,
            EncounterJournalID = 594,
            Level = 76,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 35588 }, -- Forlorn Breastplate of War
                { 2, 35589 }, -- Arcane Focal Signet
                { 3, 35587 }, -- Frozen Scepter of Necromancy
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37630 }, -- Shroud of Moorabi
                { 4, 37633 }, -- Ground Tremor Helm
                { 5, 37632 }, -- Mojo Frenzy Greaves
                { 6, 37631 }, -- Fist of the Deity
                { 8, "ac2040" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39221 }, -- Wraith Spear
                { 4, 39228 }, -- Web Cocoon Grips
                { 5, 39232 }, -- Pendant of Lost Vocations
                { 7, 37630 }, -- Shroud of Moorabi
                { 8, 37633 }, -- Ground Tremor Helm
                { 9, 37632 }, -- Mojo Frenzy Greaves
                { 10, 37631 }, -- Fist of the Deity
                { 12, "ac2040" },
            },
            [BETA_DIFF] = {
                { 1, 45299 }, -- Emblem of Conquest
                { 3, 45305 }, -- Dragonsteel Faceplate
                { 4, 45301 }, -- Breastplate of the Afterlife
                { 6, 39221 }, -- Wraith Spear
                { 7, 39228 }, -- Web Cocoon Grips
                { 8, 39232 }, -- Pendant of Lost Vocations
                { 10, "ac2040" },
            }
        },
        { -- GundrakEckHEROIC / 37
            name = AL["Eck the Ferocious"],
            npcID = 29932,
            EncounterJournalID = 595,
            Level = 76,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 4,
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 43313 }, -- Leggings of the Ruins Dweller
                { 4, 43312 }, -- Gorloc Muddy Footwraps
                { 5, 43311 }, -- Helmet of the Shrine
                { 6, 43310 }, -- Engraved Chestplate of Eck
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39226 }, -- Maexxna's Femur
                { 4, 39217 }, -- Avenging Combat Leggings
                { 5, 39231 }, -- Timeworn Silken Band
                { 7, 43313 }, -- Leggings of the Ruins Dweller
                { 8, 43312 }, -- Gorloc Muddy Footwraps
                { 9, 43311 }, -- Helmet of the Shrine
                { 10, 43310 }, -- Engraved Chestplate of Eck
            },
            [BETA_DIFF] = {
                { 1, 45299 }, -- Emblem of Conquest
                { 3, 45308 }, -- Eye of the Broodmother
                { 4, 45307 }, -- Ironscale Leggings
                { 6, 39226 }, -- Maexxna's Femur
                { 7, 39217 }, -- Avenging Combat Leggings
                { 8, 39231 }, -- Timeworn Silken Band
            }
        },
        { -- GundrakGaldarah / 38
            name = AL["Gal'darah"],
            npcID = 29306,
            EncounterJournalID = 596,
            Level = 76,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 5,
            [NORMAL_DIFF] = {
                { 1, 43305 }, -- Shroud of Akali
                { 2, 43309 }, -- Amulet of the Stampede
                { 3, 43306 }, -- Gal'darah's Signet
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37643 }, -- Sash of Blood Removal
                { 4, 37644 }, -- Gored Hide Legguards
                { 5, 37645 }, -- Horn-Tipped Gauntlets
                { 6, 37642 }, -- Hemorrhaging Circle
                { 8, 37641 }, -- Arcane Flame Altar-Garb
                { 9, 37640 }, -- Boots of Transformation
                { 10, 37639 }, -- Grips of the Beast God
                { 11, 37638 }, -- Offering of Sacrifice
                { 16, 43102 }, -- Frozen Orb
                { 18, "ac2152" },
                { 19, "ac1864" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37643 }, -- Sash of Blood Removal
                { 4, 37644 }, -- Gored Hide Legguards
                { 5, 37645 }, -- Horn-Tipped Gauntlets
                { 6, 37642 }, -- Hemorrhaging Circle
                { 8, 37641 }, -- Arcane Flame Altar-Garb
                { 9, 37640 }, -- Boots of Transformation
                { 10, 37639 }, -- Grips of the Beast God
                { 11, 37638 }, -- Offering of Sacrifice
                { 15, 43102 }, -- Frozen Orb
                { 16, 44660 }, -- Drakescale Collar
                { 17, 40491 }, -- Hailstorm
                { 18, 39283 }, -- Putrescent Bands
                { 20, 40616 }, -- Helm of the Lost Conqueror
                { 21, 40617 }, -- Helm of the Lost Protector
                { 22, 40618 }, -- Helm of the Lost Vanquisher
                { 23, 40622 }, -- Spaulders of the Lost Conqueror
                { 24, 40623 }, -- Spaulders of the Lost Protector
                { 25, 40624 }, -- Spaulders of the Lost Vanquisher
                { 26, 40619 }, -- Leggings of the Lost Conqueror
                { 27, 40620 }, -- Leggings of the Lost Protector
                { 28, 40621 }, -- Leggings of the Lost Vanquisher
                { 29, "ac2152" },
                { 30, "ac1864" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45298 }, -- Razorscale Talon
                { 4, 45304 }, -- Stormtempered Girdle
                { 5, 45893 }, -- Guise of the Midgard Serpent
                { 7, 44660 }, -- Drakescale Collar
                { 8, 40491 }, -- Hailstorm
                { 9, 39283 }, -- Putrescent Bands
                { 16, "INV_Box_01", nil, AL["Tier Token iLvl200"], nil, "Tier7TitanRuneTokens" },
				{ 17, "INV_Box_01", nil, AL["Tier Token iLvl225"], nil, "Tier8TitanRuneTokens" },
                { 19, 43102 }, -- Frozen Orb
                { 21, "ac2152" },
                { 23, "ac1864" },
                { 101, 40616 }, -- Helm of the Lost Conqueror
                { 102, 40617 }, -- Helm of the Lost Protector
                { 103, 40618 }, -- Helm of the Lost Vanquisher
                { 104, 40622 }, -- Spaulders of the Lost Conqueror
                { 105, 40623 }, -- Spaulders of the Lost Protector
                { 106, 40624 }, -- Spaulders of the Lost Vanquisher
                { 107, 40619 }, -- Leggings of the Lost Conqueror
                { 108, 40620 }, -- Leggings of the Lost Protector
                { 109, 40621 }, -- Leggings of the Lost Vanquisher
                { 116, 45647 }, -- Helm of the Wayward Conqueror
                { 117, 45648 }, -- Helm of the Warward Protector
                { 118, 45649 }, -- Helm of the Wayward Vanquisher
                { 119, 45659 }, -- Spaulders of the Wayward Conqueror
                { 120, 45660 }, -- Spaulders of the Wayward Protector
                { 121, 45661 }, -- Spaulders of the Wayward Vanquisher
                { 122, 45635 }, -- Chestguard of the Wayward Conqueror
                { 123, 45636 }, -- Chestguard of the Wayward Protector
                { 124, 45637 }, -- Chestguard of the Wayward Vanquisher
                { 125, 45644 }, -- Gloves of the Wayward Conqueror
                { 126, 45645 }, -- Gloves of the Wayward Protector
                { 127, 45646 }, -- Gloves of the Wayward Vanquisher
                { 128, 45650 }, -- Leggings of the Wayward Conqueror
                { 129, 45651 }, -- Leggings of the Wayward Protector
                { 130, 45652 }, -- Leggings of the Wayward Vanquisher
            }
        },
        { -- Trash
            name = AL["Trash"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 35594 }, -- Snowmelt Silken Cinch
		        { 2, 35593 }, -- Steel Bear Trap Bracers
                { 3, 37646 }, -- Burning Skull Pendant
            },
            [HEROIC_DIFF] = {
                { 1, 37647 }, -- Cloak of Bloodied Waters
                { 2, 37648 }, -- Belt of Tasseled Lanterns
                { 3, 37646 }, -- Burning Skull Pendant
            },
        },
        KEYS,
		WOTLK_DUNGEONMASTER_AC_TABLE,
		WOTLK_DUNGEON_HERO_AC_TABLE,
		WOTLK_GLORY_OF_THE_HERO_AC_TABLE,
    }
}

data["HallsofLightning"] = {
    nameFormat = NAME_ULDUAR,
	MapID = 4272,
    EncounterJournalID = 275,
	InstanceID = 602,
    ContentType = DUNGEON_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "UlduarHallsofLightning",
	AtlasMapFile = {"UlduarHallsofLightning", "UlduarEnt"},
	LevelRange = {75, 79, 80},
	items = {
        { -- HallsofLightningBjarngrim / 45
            name = AL["General Bjarngrim"],
            npcID = 28586,
            EncounterJournalID = 597,
            Level = 77,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 36982 }, -- Mantle of Electrical Charges
                { 2, 36979 }, -- Bjarngrim Family Signet
                { 3, 36980 }, -- Hewn Sparring Quarterstaff
                { 4, 36981 }, -- Hardened Vrykul Throwing Axe
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37825 }, -- Traditionally Dyed Handguards
                { 4, 37818 }, -- Patroller's War-Kilt
                { 5, 37814 }, -- Iron Dwarf Smith Pauldrons
                { 6, 37826 }, -- The General's Steel Girdle
                { 8, "ac1834" },
                --{ 30, xxx }, -- xxx
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39192 }, -- Gloves of Dark Gestures
                { 4, 39141 }, -- Deflection Band
                { 5, 39189 }, -- Boots of Persistence
                { 7, 37825 }, -- Traditionally Dyed Handguards
                { 8, 37818 }, -- Patroller's War-Kilt
                { 9, 37814 }, -- Iron Dwarf Smith Pauldrons
                { 10, 37826 }, -- The General's Steel Girdle
                { 12, "ac1834" },
                --{ 30, xxx }, -- xxx
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 46341 }, -- Drape of the Spellweaver
                { 4, 46347 }, -- Cloak of the Dormant Blaze
                { 6, 39192 }, -- Gloves of Dark Gestures
                { 7, 39141 }, -- Deflection Band
                { 8, 39189 }, -- Boots of Persistence
                { 10, "ac1834" },
                --{ 30, xxx }, -- xxx
            }
        },
        { -- HallsofLightningVolkhan / 46
            name = AL["Volkhan"],
            npcID = 28587,
            EncounterJournalID = 598,
            Level = 77,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 36983 }, -- Cape of Seething Steam
                { 2, 36985 }, -- Volkhan's Hood
                { 3, 36986 }, -- Kilt of Molten Golems
                { 4, 36984 }, -- Eternally Folded Blade
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37840 }, -- Shroud of Reverberation
                { 4, 37843 }, -- Giant-Hair Woven Gloves
                { 5, 37842 }, -- Belt of Vivacity
                { 6, 37841 }, -- Slag Footguards
                { 8, "ac2042" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39140 }, -- Knife of Incision
                { 4, 39191 }, -- Splint-Bound Leggings
                { 5, 39188 }, -- Chivalric Chestguard
                { 7, 37840 }, -- Shroud of Reverberation
                { 8, 37843 }, -- Giant-Hair Woven Gloves
                { 9, 37842 }, -- Belt of Vivacity
                { 10, 37841 }, -- Slag Footguards
                { 12, "ac2042" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 46342 }, -- Golemheart Longbow
                { 4, 46343 }, -- Fervor of the Protectorate
                { 6, 39140 }, -- Knife of Incision
                { 7, 39191 }, -- Splint-Bound Leggings
                { 8, 39188 }, -- Chivalric Chestguard
                { 10, "ac2042" },
            }
        },
        { -- HallsofLightningIonar / 47
            name = AL["Ionar"],
            npcID = 28546,
            EncounterJournalID = 599,
            Level = 77,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 39536 }, -- Thundercloud Grasps
                { 2, 39657 }, -- Tornado Cuffs
                { 3, 39534 }, -- Pauldrons of the Lightning Revenant
                { 4, 39535 }, -- Ionar's Girdle
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37846 }, -- Charged-Bolt Grips
                { 4, 37845 }, -- Cord of Swirling Winds
                { 5, 37826 }, -- The General's Steel Girdle
                { 6, 37844 }, -- Winged Talisman
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39146 }, -- Collar of Dissolution
                { 4, 39190 }, -- Agonal Sash
                { 5, 39139 }, -- Ravaging Sabatons
                { 7, 37846 }, -- Charged-Bolt Grips
                { 8, 37845 }, -- Cord of Swirling Winds
                { 9, 37826 }, -- The General's Steel Girdle
                { 10, 37844 }, -- Winged Talisman
                --{ 30, xxx }, -- xxx
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45677 }, -- Treacherous Shoulderpads
                { 4, 46344 }, -- Iceshear Mantle
                { 6, 39146 }, -- Collar of Dissolution
                { 7, 39190 }, -- Agonal Sash
                { 8, 39139 }, -- Ravaging Sabatons
            }
        },
        { -- HallsofLightningLoken / 48
            name = AL["Loken"],
            npcID = 28923,
            EncounterJournalID = 600,
            Level = 77,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 4,
            [NORMAL_DIFF] = {
                { 1, 36991 }, -- Raiments of the Titans
                { 2, 36996 }, -- Hood of the Furtive Assassin
                { 3, 36992 }, -- Leather-Braced Chain Leggings
                { 4, 36995 }, -- Fists of Loken
                { 5, 36988 }, -- Chaotic Spiral Amulet
                { 6, 36993 }, -- Seal of the Pantheon
                { 7, 36994 }, -- Projectile Activator
                { 8, 36989 }, -- Ancient Measuring Rod
                { 16, 41799 }, -- Design: Eternal Earthsiege Diamond
                { 18, 43151 }, -- Loken's Tongue
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37854 }, -- Woven Bracae Leggings
                { 4, 37853 }, -- Advanced Tooled-Leather Bands
                { 5, 37855 }, -- Mail Girdle of the Audient Earth
                { 6, 37852 }, -- Colossal Skull-Clad Cleaver
                { 8, 37851 }, -- Ornate Woolen Stola
                { 9, 37850 }, -- Flowing Sash of Order
                { 10, 37849 }, -- Planetary Helm
                { 11, 37848 }, -- Lightning Giant Staff
                { 16, 43102 }, -- Frozen Orb
                { 18, 41799 }, -- Design: Eternal Earthsiege Diamond
                { 20, "ac1867" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37854 }, -- Woven Bracae Leggings
                { 4, 37853 }, -- Advanced Tooled-Leather Bands
                { 5, 37855 }, -- Mail Girdle of the Audient Earth
                { 6, 37852 }, -- Colossal Skull-Clad Cleaver
                { 8, 37851 }, -- Ornate Woolen Stola
                { 9, 37850 }, -- Flowing Sash of Order
                { 10, 37849 }, -- Planetary Helm
                { 11, 37848 }, -- Lightning Giant Staff
                { 13, 41799 }, -- Design: Eternal Earthsiege Diamond
                { 15, 43102 }, -- Frozen Orb
                { 16, 40488 }, -- Ice Spire Scepter
                { 17, 40526 }, -- Gown of the Spell-Weaver
                { 18, 40426 }, -- Signet of the Accord
                { 20, 40616 }, -- Helm of the Lost Conqueror
                { 21, 40617 }, -- Helm of the Lost Protector
                { 22, 40618 }, -- Helm of the Lost Vanquisher
                { 23, 40622 }, -- Spaulders of the Lost Conqueror
                { 24, 40623 }, -- Spaulders of the Lost Protector
                { 25, 40624 }, -- Spaulders of the Lost Vanquisher
                { 26, 40619 }, -- Leggings of the Lost Conqueror
                { 27, 40620 }, -- Leggings of the Lost Protector
                { 28, 40621 }, -- Leggings of the Lost Vanquisher
                { 30, "ac1867" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45676 }, -- Chestplate ogf Vicious Potency
                { 4, 45680 }, -- Armbands of the Construct
                { 5, 46350 }, -- Pillar of Fortitude
                { 7, 40488 }, -- Ice Spire Scepter
                { 8, 40526 }, -- Gown of the Spell-Weaver
                { 9, 40426 }, -- Signet of the Accord
                { 16, "INV_Box_01", nil, AL["Tier Token iLvl200"], nil, "Tier7TitanRuneTokens" },
				{ 17, "INV_Box_01", nil, AL["Tier Token iLvl225"], nil, "Tier8TitanRuneTokens" },
                { 19, 43102 }, -- Frozen Orb
                { 21, 41799 }, -- Design: Eternal Earthsiege Diamond
                { 23, "ac1867" },
                { 101, 40616 }, -- Helm of the Lost Conqueror
                { 102, 40617 }, -- Helm of the Lost Protector
                { 103, 40618 }, -- Helm of the Lost Vanquisher
                { 104, 40622 }, -- Spaulders of the Lost Conqueror
                { 105, 40623 }, -- Spaulders of the Lost Protector
                { 106, 40624 }, -- Spaulders of the Lost Vanquisher
                { 107, 40619 }, -- Leggings of the Lost Conqueror
                { 108, 40620 }, -- Leggings of the Lost Protector
                { 109, 40621 }, -- Leggings of the Lost Vanquisher
                { 116, 45647 }, -- Helm of the Wayward Conqueror
                { 117, 45648 }, -- Helm of the Warward Protector
                { 118, 45649 }, -- Helm of the Wayward Vanquisher
                { 119, 45659 }, -- Spaulders of the Wayward Conqueror
                { 120, 45660 }, -- Spaulders of the Wayward Protector
                { 121, 45661 }, -- Spaulders of the Wayward Vanquisher
                { 122, 45635 }, -- Chestguard of the Wayward Conqueror
                { 123, 45636 }, -- Chestguard of the Wayward Protector
                { 124, 45637 }, -- Chestguard of the Wayward Vanquisher
                { 125, 45644 }, -- Gloves of the Wayward Conqueror
                { 126, 45645 }, -- Gloves of the Wayward Protector
                { 127, 45646 }, -- Gloves of the Wayward Vanquisher
                { 128, 45650 }, -- Leggings of the Wayward Conqueror
                { 129, 45651 }, -- Leggings of the Wayward Protector
                { 130, 45652 }, -- Leggings of the Wayward Vanquisher
            }
        },
        { -- Trash
            name = AL["Trash"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 36997 }, -- Sash of the Hardened Watcher
                { 2, 37000 }, -- Storming Vortex Bracers
                { 3, 36999 }, -- Boots of the Terrestrial Guardian
            },
            [HEROIC_DIFF] = {
                { 1, 37858 }, -- Awakened Handguards
                { 2, 37857 }, -- Helm of the Lightning Halls
                { 3, 37856 }, -- Librarian's Paper Cutter
            },
        },
        KEYS,
		WOTLK_DUNGEONMASTER_AC_TABLE,
		WOTLK_DUNGEON_HERO_AC_TABLE,
		WOTLK_GLORY_OF_THE_HERO_AC_TABLE,
    }
}

data["HallsofStone"] = {
    nameFormat = NAME_ULDUAR,
	MapID = 4264,
    EncounterJournalID = 277,
	InstanceID = 599,
    ContentType = DUNGEON_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "UlduarHallsofStone",
	AtlasMapFile = {"UlduarHallsofStone", "UlduarEnt"},
	LevelRange = {72, 77, 79},
	items = {
        { -- HallsofStoneKrystallus / 41
            name = AL["Krystallus"],
            npcID = 27977,
            EncounterJournalID = 604,
            Level = 77,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 35673 }, -- Leggings of Burning Gleam
                { 2, 35672 }, -- Hollow Geode Helm
                { 3, 35670 }, -- Brann's Lost Mining Helmet
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37652 }, -- Spaulders of Krystallus
                { 4, 37650 }, -- Shardling Legguards
                { 5, 37651 }, -- The Prospector's Prize
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39198 }, -- Frostblight Pauldrons
                { 4, 39195 }, -- Bracers of Lost Sentiments
                { 5, 39199 }, -- Watchful Eye
                { 7, 37652 }, -- Spaulders of Krystallus
                { 8, 37650 }, -- Shardling Legguards
                { 9, 37651 }, -- The Prospector's Prize
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45927 }, -- Handraps of Resonance
                { 4, 45892 }, -- Legacy of Thunder
                { 6, 39198 }, -- Frostblight Pauldrons
                { 7, 39195 }, -- Bracers of Lost Sentiments
                { 8, 39199 }, -- Watchful Eye
            }
        },
        { -- HallsofStoneMaiden / 40
            name = AL["Maiden of Grief"],
            npcID = 27975,
            EncounterJournalID = 605,
            Level = 77,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 38614 }, -- Embrace of Sorrow
                { 2, 38613 }, -- Chain of Fiery Orbs
                { 3, 38611 }, -- Ringlet of Repose
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 38616 }, -- Maiden's Girdle
                { 4, 38615 }, -- Lightning-Charged Gloves
                { 5, 38617 }, -- Woeful Band
                { 6, 38618 }, -- Hammer of Grief
                { 8, "ac1866" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39215 }, -- Boots of the Follower
                { 4, 39216 }, -- Sash of Mortal Desire
                { 5, 39196 }, -- Boots of the Worshiper
                { 7, 38616 }, -- Maiden's Girdle
                { 8, 38615 }, -- Lightning-Charged Gloves
                { 9, 38617 }, -- Woeful Band
                { 10, 38618 }, -- Hammer of Grief
                { 12, "ac1866" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45302 }, -- Treads of the Inader
                { 4, 45895 }, -- Belt of the Blood Pit
                { 6, 39215 }, -- Boots of the Follower
                { 7, 39216 }, -- Sash of Mortal Desire
                { 8, 39196 }, -- Boots of the Worshiper
                { 10, "ac1866" },
            }
        },
        { -- HallsofStoneTribunal / 42
            name = AL["The Tribunal of Ages"],
            npcID = 28234,
            EncounterJournalID = 606,
            Level = 77,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 35677 }, -- Cosmos Vestments
                { 2, 35676 }, -- Constellation Leggings
                { 3, 35675 }, -- Linked Armor of the Sphere
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37655 }, -- Mantle of the Tribunal
                { 4, 37656 }, -- Raging Construct Bands
                { 5, 37654 }, -- Sabatons of the Ages
                { 6, 37653 }, -- Sword of Justice
                { 8, "ac2154" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39200 }, -- Grieving Spellblade
                { 4, 39197 }, -- Gauntlets of the Master
                { 5, 39193 }, -- Band of Neglected Pleas
                { 7, 37655 }, -- Mantle of the Tribunal
                { 8, 37656 }, -- Raging Construct Bands
                { 9, 37654 }, -- Sabatons of the Ages
                { 10, 37653 }, -- Sword of Justice
                { 12, "ac2154" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 46340 }, -- Adamant Handguards
                { 4, 45894 }, -- Legging sof Unstable Discharge
                { 6, 39200 }, -- Grieving Spellblade
                { 7, 39197 }, -- Gauntlets of the Master
                { 8, 39193 }, -- Band of Neglected Pleas
                { 10, "ac2154" },
            }
        },
        { -- HallsofStoneSjonnir / 43
            name = AL["Sjonnir The Ironshaper"],
            npcID = 27978,
            EncounterJournalID = 607,
            Level = 77,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 4,
            [NORMAL_DIFF] = {
                { 1, 35679 }, -- Static Cowl
                { 2, 35678 }, -- Ironshaper's Legplates
                { 3, 35680 }, -- Amulet of Wills
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37669 }, -- Leggings of the Stone Halls
                { 4, 37668 }, -- Bands of the Stoneforge
                { 5, 37670 }, -- Sjonnir's Girdle
                { 6, 37667 }, -- The Fleshshaper
                { 8, 37666 }, -- Boots of the Whirling Mist
                { 9, 37658 }, -- Sun-Emblazoned Chestplate
                { 10, 37657 }, -- Spark of Life
                { 11, 37660 }, -- Forge Ember
                { 16, 43102 }, -- Frozen Orb
                { 18, 41792 }, -- Design: Deft Monarch Topaz
                { 20, "ac2155" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37669 }, -- Leggings of the Stone Halls
                { 4, 37668 }, -- Bands of the Stoneforge
                { 5, 37670 }, -- Sjonnir's Girdle
                { 6, 37667 }, -- The Fleshshaper
                { 8, 37666 }, -- Boots of the Whirling Mist
                { 9, 37658 }, -- Sun-Emblazoned Chestplate
                { 10, 37657 }, -- Spark of Life
                { 11, 37660 }, -- Forge Ember
                { 13, 41792 }, -- Design: Deft Monarch Topaz
                { 15, 43102 }, -- Frozen Orb
                { 16, 43993 }, -- Greatring of Collision
                { 17, 40489 }, -- Greatstaff of the Nexus
                { 18, 44659 }, -- Pendant of the Dragonsworn
                { 20, 40616 }, -- Helm of the Lost Conqueror
                { 21, 40617 }, -- Helm of the Lost Protector
                { 22, 40618 }, -- Helm of the Lost Vanquisher
                { 23, 40622 }, -- Spaulders of the Lost Conqueror
                { 24, 40623 }, -- Spaulders of the Lost Protector
                { 25, 40624 }, -- Spaulders of the Lost Vanquisher
                { 26, 40619 }, -- Leggings of the Lost Conqueror
                { 27, 40620 }, -- Leggings of the Lost Protector
                { 28, 40621 }, -- Leggings of the Lost Vanquisher
                { 30, "ac2155" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 46351 }, -- Bloodcrush Cudgel
                { 4, 46346 }, -- Boots of Unsettled Prey
                { 5, 46345 }, -- Bracers of Righteous Reformation
                { 7, 43993 }, -- Greatring of Collision
                { 8, 40489 }, -- Greatstaff of the Nexus
                { 9, 44659 }, -- Pendant of the Dragonsworn
                { 16, "INV_Box_01", nil, AL["Tier Token iLvl200"], nil, "Tier7TitanRuneTokens" },
				{ 17, "INV_Box_01", nil, AL["Tier Token iLvl225"], nil, "Tier8TitanRuneTokens" },
                { 19, 43102 }, -- Frozen Orb
                { 21, 41799 }, -- Design: Eternal Earthsiege Diamond
                { 23, "ac2155" },
                { 101, 40616 }, -- Helm of the Lost Conqueror
                { 102, 40617 }, -- Helm of the Lost Protector
                { 103, 40618 }, -- Helm of the Lost Vanquisher
                { 104, 40622 }, -- Spaulders of the Lost Conqueror
                { 105, 40623 }, -- Spaulders of the Lost Protector
                { 106, 40624 }, -- Spaulders of the Lost Vanquisher
                { 107, 40619 }, -- Leggings of the Lost Conqueror
                { 108, 40620 }, -- Leggings of the Lost Protector
                { 109, 40621 }, -- Leggings of the Lost Vanquisher
                { 116, 45647 }, -- Helm of the Wayward Conqueror
                { 117, 45648 }, -- Helm of the Warward Protector
                { 118, 45649 }, -- Helm of the Wayward Vanquisher
                { 119, 45659 }, -- Spaulders of the Wayward Conqueror
                { 120, 45660 }, -- Spaulders of the Wayward Protector
                { 121, 45661 }, -- Spaulders of the Wayward Vanquisher
                { 122, 45635 }, -- Chestguard of the Wayward Conqueror
                { 123, 45636 }, -- Chestguard of the Wayward Protector
                { 124, 45637 }, -- Chestguard of the Wayward Vanquisher
                { 125, 45644 }, -- Gloves of the Wayward Conqueror
                { 126, 45645 }, -- Gloves of the Wayward Protector
                { 127, 45646 }, -- Gloves of the Wayward Vanquisher
                { 128, 45650 }, -- Leggings of the Wayward Conqueror
                { 129, 45651 }, -- Leggings of the Wayward Protector
                { 130, 45652 }, -- Leggings of the Wayward Vanquisher
            }
        },
        { -- Trash
            name = AL["Trash"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 35682 }, -- Rune Giant Bindings
                { 2, 35683 }, -- Palladium Ring
                { 3, 35681 }, -- Unrelenting Blade
            },
            [HEROIC_DIFF] = {
                { 1, 37673 }, -- Dark Runic Mantle
                { 2, 37672 }, -- Patina-Coated Breastplate
                { 3, 37671 }, -- Refined Ore Gloves
            },
        },
        KEYS,
		WOTLK_DUNGEONMASTER_AC_TABLE,
		WOTLK_DUNGEON_HERO_AC_TABLE,
		WOTLK_GLORY_OF_THE_HERO_AC_TABLE,
    }
}

data["TheCullingOfStratholme"] = {
    nameFormat = NAME_CAVERNS_OF_TIME,
	MapID = 4100,
    EncounterJournalID = 279,
	InstanceID = 595,
    ContentType = DUNGEON_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "CoTOldStratholme",
	AtlasMapFile = {"CoTOldStratholme", "WL_CoTEnt"},
	LevelRange = {75, 79, 80},
	items = {
        { -- CoTStratholmeMeathook
            name = AL["Meathook"],
            npcID = 26529,
            EncounterJournalID = 611,
            -- Level = 0,
            -- DisplayIDs = {{0}},
            -- AtlasMapBossID = 0,
            [NORMAL_DIFF] = {
                { 1, 37083 }, -- Kilt of Sewn Flesh
                { 2, 37082 }, -- Slaughterhouse Sabatons
                { 3, 37079 }, -- Enchanted Wire Stitching
                { 4, 37081 }, -- Meathook's Slicer
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37680 }, -- Belt of Unified Souls
                { 4, 37678 }, -- Bile-Cured Gloves
                { 5, 37679 }, -- Spaulders of the Abomination
                { 6, 37675 }, -- Legplates of Steel Implants
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 40429 }, -- Crimson Steel
                { 4, 43988 }, -- Gale-Proof Cloak
                { 5, 43992 }, -- Volitant Amulet
                { 7, 37680 }, -- Belt of Unified Souls
                { 8, 37678 }, -- Bile-Cured Gloves
                { 9, 37679 }, -- Spaulders of the Abomination
                { 10, 37675 }, -- Legplates of Steel Implants
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45694 }, -- Conductive Cord
                { 4, 46339 }, -- Miniron's Repeater
                { 6, 40429 }, -- Crimson Steel
                { 7, 43988 }, -- Gale-Proof Cloak
                { 8, 43992 }, -- Volitant Amulet
            }
        },
        { -- CoTStratholmeSalramm
            name = AL["Salramm the Fleshcrafter"],
            npcID = 26530,
            EncounterJournalID = 612,
            -- Level = 0,
            -- DisplayIDs = {{0}},
            -- AtlasMapBossID = 0,
            [NORMAL_DIFF] = {
                { 1, 37084 }, -- Flowing Cloak of Command
                { 2, 37095 }, -- Waistband of the Thuzadin
                { 3, 37088 }, -- Spiked Metal Cilice
                { 4, 37086 }, -- Tome of Salramm
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37684 }, -- Forgotten Shadow Hood
                { 4, 37682 }, -- Bindings of Dark Will
                { 5, 37683 }, -- Necromancer's Amulet
                { 6, 37681 }, -- Gavel of the Fleshcrafter
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 43989 }, -- Remembrance Girdle
                { 4, 43991 }, -- Legguards of Composure
                { 5, 40428 }, -- Titan's Outlook
                { 7, 37684 }, -- Forgotten Shadow Hood
                { 8, 37682 }, -- Bindings of Dark Will
                { 9, 37683 }, -- Necromancer's Amulet
                { 10, 37681 }, -- Gavel of the Fleshcrafter
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45695 }, -- Spire of Withered Dreams
                { 4, 45679 }, -- Gloves of Taut Grip
                { 6, 43989 }, -- Remembrance Girdle
                { 7, 43991 }, -- Legguards of Composure
                { 8, 40428 }, -- Titan's Outlook
            }
        },
        { -- CoTStratholmeEpoch
            name = AL["Chrono-Lord Epoch"],
            npcID = 26532,
            EncounterJournalID = 613,
            -- Level = 0,
            -- DisplayIDs = {{0}},
            -- AtlasMapBossID = 0,
            [NORMAL_DIFF] = {
                { 1, 37106 }, -- Ouroboros Belt
                { 2, 37105 }, -- Treads of Altered History
                { 3, 37096 }, -- Necklace of the Chrono-Lord
                { 4, 37099 }, -- Sempiternal Staff
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37687 }, -- Gloves of Distorted Time
                { 4, 37686 }, -- Cracked Epoch Grasps
                { 5, 37688 }, -- Legplates of the Infinite Drakonid
                { 6, 37685 }, -- Mobius Band
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 40427 }, -- Circle of Arcane Streams
                { 4, 40430 }, -- Majestic Dragon Figurine
                { 5, 43990 }, -- Blade-Scarred Tunic
                { 7, 37687 }, -- Gloves of Distorted Time
                { 8, 37686 }, -- Cracked Epoch Grasps
                { 9, 37688 }, -- Legplates of the Infinite Drakonid
                { 10, 37685 }, -- Mobius Band
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45685 }, -- Plasma Foil
                { 4, 45675 }, -- Power Enhancing Loop
                { 6, 40427 }, -- Circle of Arcane Streams
                { 7, 40430 }, -- Majestic Dragon Figurine
                { 8, 43990 }, -- Blade-Scarred Tunic
            }
        },
        { -- CoTStratholmeMalGanis
            name = AL["Mal'Ganis"],
            npcID = 26533,
            EncounterJournalID = 614,
            -- Level = 0,
            -- DisplayIDs = {{0}},
            -- AtlasMapBossID = 0,
            [NORMAL_DIFF] = {
                { 1, 37113 }, -- Demonic Fabric Bands
                { 2, 37114 }, -- Gloves of Northern Lordaeron
                { 3, 37110 }, -- Gauntlets of Dark Conversion
                { 4, 37109 }, -- Discarded Silver Hand Spaulders
                { 5, 37111 }, -- Soul Preserver
                { 6, 37108 }, -- Dreadlord's Blade
                { 7, 37112 }, -- Beguiling Scepter
                { 8, 37107 }, -- Leeka's Shield
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37696 }, -- Plague-Infected Bracers
                { 4, 37695 }, -- Legguards of Nature's Power
                { 5, 37694 }, -- Band of Guile
                { 6, 37693 }, -- Greed
                { 7, 43085 }, -- Royal Crest of Lordaeron
                { 9, 37691 }, -- Mantle of Deceit
                { 10, 37690 }, -- Pauldrons of Destiny
                { 11, 37689 }, -- Pendant of the Nathrezim
                { 12, 37692 }, -- Pierce's Pistol
                { 16, 43102 }, -- Frozen Orb
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37696 }, -- Plague-Infected Bracers
                { 4, 37695 }, -- Legguards of Nature's Power
                { 5, 37694 }, -- Band of Guile
                { 6, 37693 }, -- Greed
                { 7, 43085 }, -- Royal Crest of Lordaeron
                { 9, 37691 }, -- Mantle of Deceit
                { 10, 37690 }, -- Pauldrons of Destiny
                { 11, 37689 }, -- Pendant of the Nathrezim
                { 12, 37692 }, -- Pierce's Pistol
                { 14, 43102 }, -- Frozen Orb
                { 16, 39235 }, -- Bone-Framed Bracers
                { 17, 44658 }, -- Chain of the Ancient Wyrm
                { 18, 40475 }, -- Barricade of Eternity
                { 20, 40616 }, -- Helm of the Lost Conqueror
                { 21, 40617 }, -- Helm of the Lost Protector
                { 22, 40618 }, -- Helm of the Lost Vanquisher
                { 23, 40622 }, -- Spaulders of the Lost Conqueror
                { 24, 40623 }, -- Spaulders of the Lost Protector
                { 25, 40624 }, -- Spaulders of the Lost Vanquisher
                { 26, 40619 }, -- Leggings of the Lost Conqueror
                { 27, 40620 }, -- Leggings of the Lost Protector
                { 28, 40621 }, -- Leggings of the Lost Vanquisher
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 46016 }, -- Abaddon
                { 4, 46018 }, -- Deliverance
                { 5, 46025 }, -- Devotion
                { 7, 39235 }, -- Bone-Framed Bracers
                { 8, 44658 }, -- Chain of the Ancient Wyrm
                { 9, 40475 }, -- Barricade of Eternity
                { 16, "INV_Box_01", nil, AL["Tier Token iLvl200"], nil, "Tier7TitanRuneTokens" },
				{ 17, "INV_Box_01", nil, AL["Tier Token iLvl225"], nil, "Tier8TitanRuneTokens" },
                { 19, 43102 }, -- Frozen Orb
                { 101, 40616 }, -- Helm of the Lost Conqueror
                { 102, 40617 }, -- Helm of the Lost Protector
                { 103, 40618 }, -- Helm of the Lost Vanquisher
                { 104, 40622 }, -- Spaulders of the Lost Conqueror
                { 105, 40623 }, -- Spaulders of the Lost Protector
                { 106, 40624 }, -- Spaulders of the Lost Vanquisher
                { 107, 40619 }, -- Leggings of the Lost Conqueror
                { 108, 40620 }, -- Leggings of the Lost Protector
                { 109, 40621 }, -- Leggings of the Lost Vanquisher
                { 116, 45647 }, -- Helm of the Wayward Conqueror
                { 117, 45648 }, -- Helm of the Warward Protector
                { 118, 45649 }, -- Helm of the Wayward Vanquisher
                { 119, 45659 }, -- Spaulders of the Wayward Conqueror
                { 120, 45660 }, -- Spaulders of the Wayward Protector
                { 121, 45661 }, -- Spaulders of the Wayward Vanquisher
                { 122, 45635 }, -- Chestguard of the Wayward Conqueror
                { 123, 45636 }, -- Chestguard of the Wayward Protector
                { 124, 45637 }, -- Chestguard of the Wayward Vanquisher
                { 125, 45644 }, -- Gloves of the Wayward Conqueror
                { 126, 45645 }, -- Gloves of the Wayward Protector
                { 127, 45646 }, -- Gloves of the Wayward Vanquisher
                { 128, 45650 }, -- Leggings of the Wayward Conqueror
                { 129, 45651 }, -- Leggings of the Wayward Protector
                { 130, 45652 }, -- Leggings of the Wayward Vanquisher
            }
        },
        { -- CoTStratholmeInfiniteCorruptorHEROIC
            name = AL["Infinite Corruptor"],
            npcID = 32273,
            Level = 82,
            -- DisplayIDs = {{0}},
            -- AtlasMapBossID = 0,
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
		            { 3, 43951 }, -- Reins of the Bronze Drake
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39468 }, -- The Stray
                { 4, 39427 }, -- Omen of Ruin
                { 5, 39473 }, -- Contortion
                { 6, 39467 }, -- Minion Bracers
                { 7, 39470 }, -- Medallion of the Disgraced
		            { 9, 43951 }, -- Reins of the Bronze Drake
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45686 }, -- Vest of the Glowing Crescent
                { 4, 45682 }, -- Pulsing Spellshield
                { 6, 39468 }, -- The Stray
                { 7, 39427 }, -- Omen of Ruin
                { 8, 39473 }, -- Contortion
                { 9, 39467 }, -- Minion Bracers
                { 10, 39470 }, -- Medallion of the Disgraced
		        { 12, 43951 }, -- Reins of the Bronze Drake
            }
        },
        { -- CoTHillsbradTrash
            name = AL["Trash"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 37117 }, -- King's Square Bracers
                { 2, 37116 }, -- Epaulets of Market Row
                { 3, 37115 }, -- Crusader's Square Pauldrons
                { 16, "ac1872" },
            }
        },
        KEYS,
		WOTLK_DUNGEONMASTER_AC_TABLE,
		WOTLK_DUNGEON_HERO_AC_TABLE,
		WOTLK_GLORY_OF_THE_HERO_AC_TABLE,
    }
}

data["TheNexus"] = {
    nameFormat = NAME_NEXUS,
	MapID = 4265,
    EncounterJournalID = 281,
	InstanceID = 576,
    ContentType = DUNGEON_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "TheNexus",
	AtlasMapFile = {"TheNexus"},
	LevelRange = {66, 71, 73},
	items = {
        { -- TheNexusKolurgStoutbeardHEROIC / 9
            name = AtlasLoot:GetRetByFaction(AL["Commander Kolurg"], AL["Commander Stoutbeard"]),
            npcID = AtlasLoot:GetRetByFaction(26798, 26796),
            EncounterJournalID = 833,
            Level = 72,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 4,
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37728 }, -- Cloak of the Enemy
                { 4, 37731 }, -- Opposed Stasis Leggings
                { 5, 37730 }, -- Cleric's Linen Shoes
                { 6, 37729 }, -- Grips of Sculptured Icicles
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39390 }, -- Resurgent Phantom Bindings
                { 4, 39394 }, -- Charmed Cierge
                { 5, 39398 }, -- Massive Skeletal Ribcage
                { 7, 37728 }, -- Cloak of the Enemy
                { 8, 37731 }, -- Opposed Stasis Leggings
                { 9, 37730 }, -- Cleric's Linen Shoes
                { 10, 37729 }, -- Grips of Sculptured Icicles
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45713 }, -- Nurturing Touch
                { 4, 45832 }, -- Mantle of the Preserver
                { 6, 39390 }, -- Resurgent Phantom Bindings
                { 7, 39394 }, -- Charmed Cierge
                { 8, 39398 }, -- Massive Skeletal Ribcage
            }
        },
        { -- TheNexusTelestra / 6
            name = AL["Grand Magus Telestra"],
            npcID = 26731,
            EncounterJournalID = 618,
            Level = 72,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 35605 }, -- Belt of Draconic Runes
                { 2, 35604 }, -- Insulating Bindings
                { 3, 35617 }, -- Wand of Shimmering Scales
                { 16, 21524 }, -- Red Winter Hat
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37139 }, -- Spaulders of the Careless Thief
                { 4, 37138 }, -- Bands of Channeled Energy
                { 5, 37135 }, -- Arcane-Shielded Helm
                { 6, 37134 }, -- Telestra's Journal
                { 8, "ac2150" },
                { 16, 21524 }, -- Red Winter Hat
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39397 }, -- Pauldrons of Havoc
                { 4, 39393 }, -- Claymore of Ancient Power
                { 5, 39388 }, -- Spirit-World Glass
                { 7, 37139 }, -- Spaulders of the Careless Thief
                { 8, 37138 }, -- Bands of Channeled Energy
                { 9, 37135 }, -- Arcane-Shielded Helm
                { 10, 37134 }, -- Telestra's Journal
                { 12, "ac2150" },
                { 16, 21524 }, -- Red Winter Hat
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45865 }, -- Raiments of the Corrupted
                { 4, 45707 }, -- Shieldwall of the Breaker
                { 6, 39397 }, -- Pauldrons of Havoc
                { 7, 39393 }, -- Claymore of Ancient Power
                { 8, 39388 }, -- Spirit-World Glass
                { 10, "ac2150" },
                { 16, 21524 }, -- Red Winter Hat
            }
        },
        { -- TheNexusAnomalus / 7
            name = AL["Anomalus"],
            npcID = 26763,
            EncounterJournalID = 619,
            Level = 72,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 35599 }, -- Gauntlets of Serpent Scales
                { 2, 35600 }, -- Cleated Ice Boots
                { 3, 35598 }, -- Tome of the Lore Keepers
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37149 }, -- Helm of Anomalus
                { 4, 37144 }, -- Hauberk of the Arcane Wraith
                { 5, 37150 }, -- Rift Striders
                { 6, 37141 }, -- Amulet of Dazzling Light
                { 8, "ac2037" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39386 }, -- Tunic of Dislocation
                { 4, 39396 }, -- Gown of Blaumeux
                { 5, 39407 }, -- Circle of Life
                { 7, 37149 }, -- Helm of Anomalus
                { 8, 37144 }, -- Hauberk of the Arcane Wraith
                { 9, 37150 }, -- Rift Striders
                { 10, 37141 }, -- Amulet of Dazzling Light
                { 12, "ac2037" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45292 }, -- Energy Siphon
                { 4, 45291 }, -- Combustion Bracers
                { 6, 39386 }, -- Tunic of Dislocation
                { 7, 39396 }, -- Gown of Blaumeux
                { 8, 39407 }, -- Circle of Life
                { 10, "ac2037" },
            }
        },
        { -- TheNexusOrmorok / 8
            name = AL["Ormorok the Tree-Shaper"],
            npcID = 26794,
            EncounterJournalID = 620,
            Level = 72,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 35602 }, -- Chiseled Stalagmite Pauldrons
                { 2, 35603 }, -- Greaves of the Blue Flight
                { 3, 35601 }, -- Drakonid Arm Blade
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37153 }, -- Gloves of the Crystal Gardener
                { 4, 37155 }, -- Frozen Forest Kilt
                { 5, 37152 }, -- Girdle of Ice
                { 6, 37151 }, -- Band of Frosted Thorns
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39389 }, -- Signet of the Malevolent
                { 4, 39395 }, -- Thane's Tainted Greathelm
                { 5, 39391 }, -- Heinous Chestguard
                { 7, 37153 }, -- Gloves of the Crystal Gardener
                { 8, 37155 }, -- Frozen Forest Kilt
                { 9, 37152 }, -- Girdle of Ice
                { 10, 37151 }, -- Band of Frosted Thorns
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45287 }, -- Firesoul
                { 4, 45288 }, -- Firestrider Chestguard
                { 6, 39389 }, -- Signet of the Malevolent
                { 7, 39395 }, -- Thane's Tainted Greathelm
                { 8, 39391 }, -- Heinous Chestguard
            }
        },
        { -- TheNexusKeristrasza / 10
            name = AL["Keristrasza"],
            npcID = 26723,
            EncounterJournalID = 621,
            Level = 73,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 5,
            [NORMAL_DIFF] = {
                { 1, 35596 }, -- Attuned Crystalline Boots
                { 2, 35595 }, -- Glacier Sharpened Vileblade
                { 3, 35597 }, -- Band of Glittering Permafrost
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37172 }, -- Gloves of Glistening Runes
                { 4, 37170 }, -- Interwoven Scale Bracers
                { 5, 37171 }, -- Flame-Bathed Steel Girdle
                { 6, 37169 }, -- War Mace of Unrequited Love
                { 8, 37165 }, -- Crystal-Infused Tunic
                { 9, 37167 }, -- Dragon Slayer's Sabatons
                { 10, 37166 }, -- Sphere of Red Dragon's Blood
                { 11, 37162 }, -- Bulwark of the Noble Protector
                { 16, 43102 }, -- Frozen Orb
                { 18, 41794 }, -- Design: Deadly Monarch Topaz
                { 20, "ac2036" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37172 }, -- Gloves of Glistening Runes
                { 4, 37170 }, -- Interwoven Scale Bracers
                { 5, 37171 }, -- Flame-Bathed Steel Girdle
                { 6, 37169 }, -- War Mace of Unrequited Love
                { 8, 37165 }, -- Crystal-Infused Tunic
                { 9, 37167 }, -- Dragon Slayer's Sabatons
                { 10, 37166 }, -- Sphere of Red Dragon's Blood
                { 11, 37162 }, -- Bulwark of the Noble Protector
                { 13, 41794 }, -- Design: Deadly Monarch Topaz
                { 15, 43102 }, -- Frozen Orb
                { 16, 39422 }, -- Staff of the Plaguehound
                { 17, 44657 }, -- Torque of the Red Dragonflight
                { 18, 39306 }, -- Plated Gloves of Relief
                { 20, 40616 }, -- Helm of the Lost Conqueror
                { 21, 40617 }, -- Helm of the Lost Protector
                { 22, 40618 }, -- Helm of the Lost Vanquisher
                { 23, 40622 }, -- Spaulders of the Lost Conqueror
                { 24, 40623 }, -- Spaulders of the Lost Protector
                { 25, 40624 }, -- Spaulders of the Lost Vanquisher
                { 26, 40619 }, -- Leggings of the Lost Conqueror
                { 27, 40620 }, -- Leggings of the Lost Protector
                { 28, 40621 }, -- Leggings of the Lost Vanquisher
                { 30, "ac2036" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45286 }, -- Pyrite Infuser
                { 4, 45283 }, -- Flamewatch Armguards
                { 5, 45282 }, -- Ironsoul
                { 7, 39422 }, -- Staff of the Plaguehound
                { 8, 44657 }, -- Torque of the Red Dragonflight
                { 9, 39306 }, -- Plated Gloves of Relief
                { 16, "INV_Box_01", nil, AL["Tier Token iLvl200"], nil, "Tier7TitanRuneTokens" },
				{ 17, "INV_Box_01", nil, AL["Tier Token iLvl225"], nil, "Tier8TitanRuneTokens" },
                { 19, 43102 }, -- Frozen Orb
                { 21, 41794 }, -- Design: Deadly Monarch Topaz
                { 23, "ac2036" },
                { 101, 40616 }, -- Helm of the Lost Conqueror
                { 102, 40617 }, -- Helm of the Lost Protector
                { 103, 40618 }, -- Helm of the Lost Vanquisher
                { 104, 40622 }, -- Spaulders of the Lost Conqueror
                { 105, 40623 }, -- Spaulders of the Lost Protector
                { 106, 40624 }, -- Spaulders of the Lost Vanquisher
                { 107, 40619 }, -- Leggings of the Lost Conqueror
                { 108, 40620 }, -- Leggings of the Lost Protector
                { 109, 40621 }, -- Leggings of the Lost Vanquisher
                { 116, 45647 }, -- Helm of the Wayward Conqueror
                { 117, 45648 }, -- Helm of the Warward Protector
                { 118, 45649 }, -- Helm of the Wayward Vanquisher
                { 119, 45659 }, -- Spaulders of the Wayward Conqueror
                { 120, 45660 }, -- Spaulders of the Wayward Protector
                { 121, 45661 }, -- Spaulders of the Wayward Vanquisher
                { 122, 45635 }, -- Chestguard of the Wayward Conqueror
                { 123, 45636 }, -- Chestguard of the Wayward Protector
                { 124, 45637 }, -- Chestguard of the Wayward Vanquisher
                { 125, 45644 }, -- Gloves of the Wayward Conqueror
                { 126, 45645 }, -- Gloves of the Wayward Protector
                { 127, 45646 }, -- Gloves of the Wayward Vanquisher
                { 128, 45650 }, -- Leggings of the Wayward Conqueror
                { 129, 45651 }, -- Leggings of the Wayward Protector
                { 130, 45652 }, -- Leggings of the Wayward Vanquisher
            }
        },
        KEYS,
		WOTLK_DUNGEONMASTER_AC_TABLE,
		WOTLK_DUNGEON_HERO_AC_TABLE,
		WOTLK_GLORY_OF_THE_HERO_AC_TABLE,
    }
}

data["TheOculus"] = {
    nameFormat = NAME_NEXUS,
	MapID = 4228,
    EncounterJournalID = 282,
	InstanceID = 578,
    ContentType = DUNGEON_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "TheOculus",
	AtlasMapFile = {"TheOculus"},
	LevelRange = {75, 79, 80},
	items = {
        { -- OcuDrakos / 61
            name = AL["Drakos the Interrogator"],
            npcID = 27654,
            EncounterJournalID = 622,
            Level = 82,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 36945 }, -- Verdisa's Cuffs of Dreaming
                { 2, 36946 }, -- Runic Cage Chestpiece
                { 3, 36943 }, -- Timeless Beads of Eternos
                { 4, 36944 }, -- Lifeblade of Belgaristrasz
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37258 }, -- Drakewing Raiments
                { 4, 37256 }, -- Scaled Armor of Drakos
                { 5, 37257 }, -- Band of Torture
                { 6, 37255 }, -- The Interrogator
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39399 }, -- Helm of the Vast Legions
                { 4, 39404 }, -- Cloak of Mastery
                { 5, 39408 }, -- Leggings of Sapphiron
                { 7, 37258 }, -- Drakewing Raiments
                { 8, 37256 }, -- Scaled Armor of Drakos
                { 9, 37257 }, -- Band of Torture
                { 10, 37255 }, -- The Interrogator
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45997 }, -- Gauntlets of the Wretched
                { 4, 45996 }, -- Hoperender
                { 6, 39399 }, -- Helm of the Vast Legions
                { 7, 39404 }, -- Cloak of Mastery
                { 8, 39408 }, -- Leggings of Sapphiron
            }
        },
        { -- OcuCloudstrider / 63
            name = AL["Varos Cloudstrider"],
            npcID = 27447,
            EncounterJournalID = 623,
            Level = 82,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 36947 }, -- Centrifuge Core Cloak
                { 2, 36949 }, -- Gloves of the Azure-Lord
                { 3, 36948 }, -- Horned Helm of Varos
                { 4, 36950 }, -- Wing Commander's Breastplate
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37261 }, -- Gloves of Radiant Light
                { 4, 37262 }, -- Azure Ringmail Leggings
                { 5, 37263 }, -- Legplates of the Oculus Guardian
                { 6, 37260 }, -- Cloudstrider's Waraxe
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39401 }, -- Circle of Death
                { 4, 39405 }, -- Helmet of the Inner Sanctum
                { 5, 39409 }, -- Cowl of Winged Fear
                { 7, 37261 }, -- Gloves of Radiant Light
                { 8, 37262 }, -- Azure Ringmail Leggings
                { 9, 37263 }, -- Legplates of the Oculus Guardian
                { 10, 37260 }, -- Cloudstrider's Waraxe
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 46015 }, -- Pendant of Endless Despair
                { 4, 46014 }, -- Saronite Animus Cloak
                { 6, 39401 }, -- Circle of Death
                { 7, 39405 }, -- Helmet of the Inner Sanctum
                { 8, 39409 }, -- Cowl of Winged Fear
            }
        },
        { -- OcuUrom / 62
            name = AL["Mage-Lord Urom"],
            npcID = 27655,
            EncounterJournalID = 624,
            Level = 82,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 36954 }, -- The Conjurer's Slippers
                { 2, 36951 }, -- Sidestepping Handguards
                { 3, 36953 }, -- Spaulders of Skillful Maneuvers
                { 4, 36952 }, -- Girdle of Obscuring
                { 16, 21525 }, -- Green Winter Hat
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37289 }, -- Sash of Phantasmal Images
                { 4, 37288 }, -- Catalytic Bands
                { 5, 37195 }, -- Band of Enchanted Growth
                { 6, 37264 }, -- Pendulum of Telluric Currents
                { 16, 21525 }, -- Green Winter Hat
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39415 }, -- Shroud of the Citadel
                { 4, 39311 }, -- Scepter of Murmuring Spirits
                { 5, 39403 }, -- Helm of the Unsubmissive
                { 7, 37289 }, -- Sash of Phantasmal Images
                { 8, 37288 }, -- Catalytic Bands
                { 9, 37195 }, -- Band of Enchanted Growth
                { 10, 37264 }, -- Pendulum of Telluric Currents
                { 16, 21525 }, -- Green Winter Hat
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 46011 }, -- Shadowbite
                { 4, 46013 }, -- Underworld Mantle
                { 6, 39415 }, -- Shroud of the Citadel
                { 7, 39311 }, -- Scepter of Murmuring Spirits
                { 8, 39403 }, -- Helm of the Unsubmissive
                { 16, 21525 }, -- Green Winter Hat
            }
        },
        { -- OcuEregos / 64
            name = AL["Ley-Guardian Eregos"],
            npcID = 27656,
            EncounterJournalID = 625,
            Level = 82,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 4,
            [NORMAL_DIFF] = {
                { 1, 36973 }, -- Vestments of the Scholar
                { 2, 36971 }, -- Headguard of Westrift
                { 3, 36969 }, -- Helm of the Ley-Guardian
                { 4, 36974 }, -- Eredormu's Ornamented Chestguard
                { 5, 36961 }, -- Dragonflight Great-Ring
                { 6, 36972 }, -- Tome of Arcane Phenomena
                { 7, 36962 }, -- Wyrmclaw Battleaxe
                { 8, 36975 }, -- Malygos's Favor
                { 16, 41798 }, -- Design: Bracing Earthsiege Diamond
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37361 }, -- Cuffs of Winged Levitation
                { 4, 37363 }, -- Gauntlets of Dragon Wrath
                { 5, 37362 }, -- Leggings of Protective Auras
                { 6, 37360 }, -- Staff of Draconic Combat
                { 8, 37291 }, -- Ancient Dragon Spirit Cape
                { 9, 37294 }, -- Crown of Unbridled Magic
                { 10, 37293 }, -- Mask of the Watcher
                { 11, 37292 }, -- Ley-Guardian's Legguards
                { 16, 43102 }, -- Frozen Orb
                { 18, 41798 }, -- Design: Bracing Earthsiege Diamond
                { 20, "ac1868" },
                { 21, "ac1871" },
                { 22, "ac2046" },
                { 23, "ac2045" },
                { 24, "ac2044" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37361 }, -- Cuffs of Winged Levitation
                { 4, 37363 }, -- Gauntlets of Dragon Wrath
                { 5, 37362 }, -- Leggings of Protective Auras
                { 6, 37360 }, -- Staff of Draconic Combat
                { 8, 37291 }, -- Ancient Dragon Spirit Cape
                { 9, 37294 }, -- Crown of Unbridled Magic
                { 10, 37293 }, -- Mask of the Watcher
                { 11, 37292 }, -- Ley-Guardian's Legguards
                { 13, 41798 }, -- Design: Bracing Earthsiege Diamond
                { 15, 43102 }, -- Frozen Orb
                { 16, 40497 }, -- Black Ice
                { 17, 39310 }, -- Mantle of the Extensive Mind
                { 18, 44659 }, -- Pendant of the Dragonsworn
                { 19, 44658 }, -- Chain of the Ancient Wyrm
                { 20, 44660 }, -- Drakescale Collar
                { 21, 44657 }, -- Torque of the Red Dragonflight
                { 23, "ac1868" },
                { 24, "ac1871" },
                { 25, "ac2046" },
                { 26, "ac2045" },
                { 27, "ac2044" },
                { 29, "INV_Box_01", nil, AL["Tier drops on next page"], nil },
                { 30, "INV_Box_01", nil, AL["Click the > button down below"], nil },
                { 101, 40616 }, -- Helm of the Lost Conqueror
                { 102, 40617 }, -- Helm of the Lost Protector
                { 103, 40618 }, -- Helm of the Lost Vanquisher
                { 104, 40622 }, -- Spaulders of the Lost Conqueror
                { 105, 40623 }, -- Spaulders of the Lost Protector
                { 106, 40624 }, -- Spaulders of the Lost Vanquisher
                { 107, 40619 }, -- Leggings of the Lost Conqueror
                { 108, 40620 }, -- Leggings of the Lost Protector
                { 109, 40621 }, -- Leggings of the Lost Vanquisher
                { 111, "INV_Box_01", nil, AL["Above Tier is iLVL 200"], nil },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 46012 }, -- Vestments of the Piercing Light
                { 4, 45873 }, -- Winter's Frigid Embrace
                { 5, 45872 }, -- Avalance
                { 7, 40497 }, -- Black Ice
                { 8, 39310 }, -- Mantle of the Extensive Mind
                { 9, 44659 }, -- Pendant of the Dragonsworn
                { 10, 44658 }, -- Chain of the Ancient Wyrm
                { 11, 44660 }, -- Drakescale Collar
                { 12, 44657 }, -- Torque of the Red Dragonflight
                { 16, "INV_Box_01", nil, AL["Tier Token iLvl200"], nil, "Tier7TitanRuneTokens" },
				{ 17, "INV_Box_01", nil, AL["Tier Token iLvl225"], nil, "Tier8TitanRuneTokens" },
                { 19, 43102 }, -- Frozen Orb
                { 21, 41798 }, -- Design: Bracing Earthsiege Diamond
                { 23, "ac1868" },
                { 24, "ac1871" },
                { 25, "ac2046" },
                { 26, "ac2045" },
                { 27, "ac2044" },
                { 101, 40616 }, -- Helm of the Lost Conqueror
                { 102, 40617 }, -- Helm of the Lost Protector
                { 103, 40618 }, -- Helm of the Lost Vanquisher
                { 104, 40622 }, -- Spaulders of the Lost Conqueror
                { 105, 40623 }, -- Spaulders of the Lost Protector
                { 106, 40624 }, -- Spaulders of the Lost Vanquisher
                { 107, 40619 }, -- Leggings of the Lost Conqueror
                { 108, 40620 }, -- Leggings of the Lost Protector
                { 109, 40621 }, -- Leggings of the Lost Vanquisher
                { 116, 45647 }, -- Helm of the Wayward Conqueror
                { 117, 45648 }, -- Helm of the Warward Protector
                { 118, 45649 }, -- Helm of the Wayward Vanquisher
                { 119, 45659 }, -- Spaulders of the Wayward Conqueror
                { 120, 45660 }, -- Spaulders of the Wayward Protector
                { 121, 45661 }, -- Spaulders of the Wayward Vanquisher
                { 122, 45635 }, -- Chestguard of the Wayward Conqueror
                { 123, 45636 }, -- Chestguard of the Wayward Protector
                { 124, 45637 }, -- Chestguard of the Wayward Vanquisher
                { 125, 45644 }, -- Gloves of the Wayward Conqueror
                { 126, 45645 }, -- Gloves of the Wayward Protector
                { 127, 45646 }, -- Gloves of the Wayward Vanquisher
                { 128, 45650 }, -- Leggings of the Wayward Conqueror
                { 129, 45651 }, -- Leggings of the Wayward Protector
                { 130, 45652 }, -- Leggings of the Wayward Vanquisher
            }
        },
        { -- Trash
            name = AL["Trash"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 36978 }, -- Ley-Whelphide Belt
                { 2, 36977 }, -- Bindings of the Construct
                { 3, 36976 }, -- Ring-Lord's Leggings
            },
            [HEROIC_DIFF] = {
                { 1, 37366 }, -- Drake-Champion's Bracers
                { 2, 37365 }, -- Bands of the Sky Ring
                { 3, 37290 }, -- Dragon Prow Amulet
                { 4, 37364 }, -- Frostbridge Orb
            }
        },
        KEYS,
		WOTLK_DUNGEONMASTER_AC_TABLE,
		WOTLK_DUNGEON_HERO_AC_TABLE,
		WOTLK_GLORY_OF_THE_HERO_AC_TABLE,
    }
}

data["VioletHold"] = {
	MapID = 4415,
	InstanceID = 608,
    ContentType = DUNGEON_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "VioletHold",
	AtlasMapFile = {"VioletHold"},
	LevelRange = {70, 75, 77},
	items = {
        { -- VioletHoldErekem / 26
            name = AL["Erekem"],
            npcID = 29315,
            Level = 75,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 43363 }, -- Screeching Cape
                { 2, 43375 }, -- Trousers of the Arakkoa
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 43406 }, -- Cloak of the Gushing Wound
                { 4, 43405 }, -- Sabatons of Erekem
                { 5, 43407 }, -- Stormstrike Mace
                { 7, "ac1865" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39275 }, -- Contagion Gloves
                { 4, 39281 }, -- Infection Repulser
                { 5, 39293 }, -- Blackened Legplates of Feugen
                { 7, 43406 }, -- Cloak of the Gushing Wound
                { 8, 43405 }, -- Sabatons of Erekem
                { 9, 43407 }, -- Stormstrike Mace
                { 11, "ac1865" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest

                { 3, 45935 }, -- Ironbark Faceguard
                { 4, 45940 }, -- Tunic of the Limber Stalker
                { 5, 45289 }, -- Lifespark Visage
                { 6, 45285 }, -- Might of the Leviathon
	            { 7, 45284 }, -- Kinetic Ripper

                { 9, 39275 }, -- Contagion Gloves
                { 10, 39281 }, -- Infection Repulser
                { 11, 39293 }, -- Blackened Legplates of Feugen
                { 13, "ac1865" },
            }
        },
        { -- VioletHoldZuramat / 27
            name = AL["Zuramat the Obliterator"],
            npcID = 29314,
            Level = 75,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 43353 }, -- Void Sentry Legplates
                { 2, 43358 }, -- Pendant of Shadow Beams
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 43403 }, -- Shroud of Darkness
                { 4, 43402 }, -- The Obliterator Greaves
                { 5, 43404 }, -- Zuramat's Necklace
                { 7, "ac1865" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39276 }, -- The Skull of Ruin
                { 4, 39270 }, -- Hatestrike
                { 5, 39282 }, -- Bone-Linked Amulet
                { 7, 43403 }, -- Shroud of Darkness
                { 8, 43402 }, -- The Obliterator Greaves
                { 9, 43404 }, -- Zuramat's Necklace
                { 11, "ac1865" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest

                { 3, 45935 }, -- Ironbark Faceguard
                { 4, 45940 }, -- Tunic of the Limber Stalker
                { 5, 45289 }, -- Lifespark Visage
                { 6, 45285 }, -- Might of the Leviathon
	            { 7, 45284 }, -- Kinetic Ripper

                { 9, 39276 }, -- The Skull of Ruin
                { 10, 39270 }, -- Hatestrike
                { 11, 39282 }, -- Bone-Linked Amulet
                { 13, "ac1865" },
            }
        },
        { -- VioletHoldXevozz / 28
            name = AL["Xevozz"],
            npcID = 29266,
            Level = 75,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 35644 }, -- Xevozz's Belt
                { 2, 35642 }, -- Riot Shield
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37867 }, -- Footwraps of Teleportation
                { 4, 37868 }, -- Girdle of the Ethereal
                { 5, 37861 }, -- Necklace of Arcane Spheres
                { 7, "ac1865" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39272 }, -- Drape of Surgery
                { 4, 39285 }, -- Handgrips of Turmoil
                { 5, 39278 }, -- Bands of Anxiety
                { 7, 37867 }, -- Footwraps of Teleportation
                { 8, 37868 }, -- Girdle of the Ethereal
                { 9, 37861 }, -- Necklace of Arcane Spheres
                { 11, "ac1865" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest

                { 3, 45935 }, -- Ironbark Faceguard
                { 4, 45940 }, -- Tunic of the Limber Stalker
                { 5, 45289 }, -- Lifespark Visage
                { 6, 45285 }, -- Might of the Leviathon
	            { 7, 45284 }, -- Kinetic Ripper

                { 9, 39272 }, -- Drape of Surgery
                { 10, 39285 }, -- Handgrips of Turmoil
                { 11, 39278 }, -- Bands of Anxiety
                { 13, "ac1865" },
            }
        },
        { -- VioletHoldIchoron / 29
            name = AL["Ichoron"],
            npcID = 29313,
            Level = 75,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 4,
            [NORMAL_DIFF] = {
                { 1, 35647 }, -- Handguards of Rapid Pursuit
                { 2, 35643 }, -- Spaulders of Ichoron
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 43401 }, -- Water-Drenched Robe
                { 4, 37862 }, -- Gauntlets of the Water Revenant
                { 5, 37869 }, -- Globule Signet
                { 7, "ac2041" },
                { 8, "ac1865" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39273 }, -- Sullen Cloth Boots
                { 4, 39279 }, -- Blistered Belt of Decay
                { 5, 39291 }, -- Torment of the Banished
                { 7, 43401 }, -- Water-Drenched Robe
                { 8, 37862 }, -- Gauntlets of the Water Revenant
                { 9, 37869 }, -- Globule Signet
                { 11, "ac2041" },
                { 12, "ac1865" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest

                { 3, 45935 }, -- Ironbark Faceguard
                { 4, 45940 }, -- Tunic of the Limber Stalker
                { 5, 45289 }, -- Lifespark Visage
                { 6, 45285 }, -- Might of the Leviathon
	            { 7, 45284 }, -- Kinetic Ripper

                { 9, 39273 }, -- Sullen Cloth Boots
                { 10, 39279 }, -- Blistered Belt of Decay
                { 11, 39291 }, -- Torment of the Banished
                { 13, "ac2041" },
                { 14, "ac1865" },
            }
        },
        { -- VioletHoldMoragg / 30
            name = AL["Moragg"],
            npcID = 29316,
            Level = 75,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 5,
            [NORMAL_DIFF] = {
                { 1, 43387 }, -- Shoulderplates of the Beholder
                { 2, 43382 }, -- Band of Eyes
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 43410 }, -- Moragg's Chestguard
                { 4, 43408 }, -- Solitare of Reflecting Beams
                { 5, 43409 }, -- Saliva Corroded Pike
                { 7, "ac1865" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39280 }, -- Leggings of Innumerable Barbs
                { 4, 39292 }, -- Repelling Charge
                { 5, 39274 }, -- Retcher's Shoulderpads
                { 7, 43410 }, -- Moragg's Chestguard
                { 8, 43408 }, -- Solitare of Reflecting Beams
                { 9, 43409 }, -- Saliva Corroded Pike
                { 11, "ac1865" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest

                { 3, 45935 }, -- Ironbark Faceguard
                { 4, 45940 }, -- Tunic of the Limber Stalker
                { 5, 45289 }, -- Lifespark Visage
                { 6, 45285 }, -- Might of the Leviathon
	            { 7, 45284 }, -- Kinetic Ripper

                { 9, 39280 }, -- Leggings of Innumerable Barbs
                { 10, 39292 }, -- Repelling Charge
                { 11, 39274 }, -- Retcher's Shoulderpads
                { 13, "ac1865" },
            }
        },
        { -- VioletHoldLavanthor / 31
            name = AL["Lavanthor"],
            npcID = 29312,
            Level = 75,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 6,
            [NORMAL_DIFF] = {
                { 1, 35646 }, -- Lava Burn Gloves
                { 2, 35645 }, -- Prison Warden's Shotgun
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37870 }, -- Twin-Headed Boots
                { 4, 37872 }, -- Lavanthor's Talisman
                { 5, 37871 }, -- The Key
                { 7, "ac1865" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39271 }, -- Blade of Dormant Memories
                { 4, 39307 }, -- Iron Rings of Endurance
                { 5, 39277 }, -- Sealing Ring of Grobbulus
                { 7, 37870 }, -- Twin-Headed Boots
                { 8, 37872 }, -- Lavanthor's Talisman
                { 9, 37871 }, -- The Key
                { 11, "ac1865" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest

                { 3, 45935 }, -- Ironbark Faceguard
                { 4, 45940 }, -- Tunic of the Limber Stalker
                { 5, 45289 }, -- Lifespark Visage
                { 6, 45285 }, -- Might of the Leviathon
	            { 7, 45284 }, -- Kinetic Ripper

                { 9, 39271 }, -- Blade of Dormant Memories
                { 10, 39307 }, -- Iron Rings of Endurance
                { 11, 39277 }, -- Sealing Ring of Grobbulus
                { 13, "ac1865" },
            }
        },
        { -- VioletHoldCyanigosa / 32
            name = AL["Cyanigosa"],
            npcID = 31134,
            Level = 75,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 7,
            [NORMAL_DIFF] = {
                { 1, 35650 }, -- Boots of the Portal Guardian
                { 2, 35651 }, -- Plate Claws of the Dragon
                { 3, 35649 }, -- Jailer's Baton
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37884 }, -- Azure Cloth Bindings
                { 4, 37886 }, -- Handgrips of the Savage Emissary
                { 5, 43500 }, -- Bolstered Legplates
                { 6, 37883 }, -- Staff of Trickery
                { 8, 37876 }, -- Cyanigosa's Leggings
                { 9, 37875 }, -- Spaulders of the Violet Hold
                { 10, 37874 }, -- Gauntlets of Capture
                { 11, 37873 }, -- Mark of the War Prisoner
                { 16, 43102 }, -- Frozen Orb
                { 18, 41791 }, -- Design: Thick Autumn's Glow
                { 20, "ac1816" }
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37884 }, -- Azure Cloth Bindings
                { 4, 37886 }, -- Handgrips of the Savage Emissary
                { 5, 43500 }, -- Bolstered Legplates
                { 6, 37883 }, -- Staff of Trickery
                { 8, 37876 }, -- Cyanigosa's Leggings
                { 9, 37875 }, -- Spaulders of the Violet Hold
                { 10, 37874 }, -- Gauntlets of Capture
                { 11, 37873 }, -- Mark of the War Prisoner
                { 13, 41791 }, -- Design: Thick Autumn's Glow
                { 15, 43102 }, -- Frozen Orb
                { 16, 39426 }, -- Wand of the Archlich
                { 17, 39420 }, -- Anarchy
                { 18, 40511 }, -- Focusing Energy Epaulets
                { 20, 40616 }, -- Helm of the Lost Conqueror
                { 21, 40617 }, -- Helm of the Lost Protector
                { 22, 40618 }, -- Helm of the Lost Vanquisher
                { 23, 40622 }, -- Spaulders of the Lost Conqueror
                { 24, 40623 }, -- Spaulders of the Lost Protector
                { 25, 40624 }, -- Spaulders of the Lost Vanquisher
                { 26, 40619 }, -- Leggings of the Lost Conqueror
                { 27, 40620 }, -- Leggings of the Lost Protector
                { 28, 40621 }, -- Leggings of the Lost Vanquisher
                { 30, "ac1816" }
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 46010 }, -- Darkstone Ring
                { 4, 46008 }, -- Choker of the Abyss
                { 5, 46009 }, -- Bindings of the Depths
                { 7, 39426 }, -- Wand of the Archlich
                { 8, 39420 }, -- Anarchy
                { 9, 40511 }, -- Focusing Energy Epaulets
                { 16, "INV_Box_01", nil, AL["Tier Token iLvl200"], nil, "Tier7TitanRuneTokens" },
				{ 17, "INV_Box_01", nil, AL["Tier Token iLvl225"], nil, "Tier8TitanRuneTokens" },
                { 19, 43102 }, -- Frozen Orb
                { 21, 41791 }, -- Design: Thick Autumn's Glow
                { 23, "ac1816" },
                { 101, 40616 }, -- Helm of the Lost Conqueror
                { 102, 40617 }, -- Helm of the Lost Protector
                { 103, 40618 }, -- Helm of the Lost Vanquisher
                { 104, 40622 }, -- Spaulders of the Lost Conqueror
                { 105, 40623 }, -- Spaulders of the Lost Protector
                { 106, 40624 }, -- Spaulders of the Lost Vanquisher
                { 107, 40619 }, -- Leggings of the Lost Conqueror
                { 108, 40620 }, -- Leggings of the Lost Protector
                { 109, 40621 }, -- Leggings of the Lost Vanquisher
                { 116, 45647 }, -- Helm of the Wayward Conqueror
                { 117, 45648 }, -- Helm of the Warward Protector
                { 118, 45649 }, -- Helm of the Wayward Vanquisher
                { 119, 45659 }, -- Spaulders of the Wayward Conqueror
                { 120, 45660 }, -- Spaulders of the Wayward Protector
                { 121, 45661 }, -- Spaulders of the Wayward Vanquisher
                { 122, 45635 }, -- Chestguard of the Wayward Conqueror
                { 123, 45636 }, -- Chestguard of the Wayward Protector
                { 124, 45637 }, -- Chestguard of the Wayward Vanquisher
                { 125, 45644 }, -- Gloves of the Wayward Conqueror
                { 126, 45645 }, -- Gloves of the Wayward Protector
                { 127, 45646 }, -- Gloves of the Wayward Vanquisher
                { 128, 45650 }, -- Leggings of the Wayward Conqueror
                { 129, 45651 }, -- Leggings of the Wayward Protector
                { 130, 45652 }, -- Leggings of the Wayward Vanquisher
            }
        },
        { -- Trash
            name = AL["Trash"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 35654 }, -- Bindings of the Bastille
                { 2, 35653 }, -- Dungeon Girdle
                { 3, 35652 }, -- Incessant Torch
            },
            [HEROIC_DIFF] = {
                { 1, 35654 }, -- Bindings of the Bastille
                { 2, 37890 }, -- Chain Gang Legguards
                { 3, 37891 }, -- Cast Iron Shackles
                { 4, 35653 }, -- Dungeon Girdle
                { 5, 37889 }, -- Prison Manifest
                { 6, 35652 }, -- Incessant Torch
            },
        },
        KEYS
    }
}

data["UtgardeKeep"] = {
    nameFormat = NAME_UTGARDE,
	MapID = 206,
    EncounterJournalID = 285,
	InstanceID = 574,
    ContentType = DUNGEON_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "UtgardeKeep",
	AtlasMapFile = {"UtgardeKeep"},
	LevelRange = {65, 69, 72},
	items = {
        { -- UtgardeKeepKeleseth / 2
            name = AL["Prince Keleseth"],
            npcID = 23953,
            EncounterJournalID = 638,
            Level = 72,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 35572 }, -- Reinforced Velvet Helm
                { 2, 35571 }, -- Dragon Stabler's Gauntlets
                { 3, 35570 }, -- Keleseth's Blade of Evocation
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37180 }, -- Battlemap Hide Helm
                { 4, 37178 }, -- Strategist's Belt
                { 5, 37179 }, -- Infantry Assault Blade
                { 6, 37177 }, -- Wand of the San'layn
                { 8, "ac1919" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39392 }, -- Veiled Amulet of Life
                { 4, 39379 }, -- Spectral Rider's Girdle
                { 5, 39345 }, -- Girdle of the Ascended Phantom
                { 7, 37180 }, -- Battlemap Hide Helm
                { 8, 37178 }, -- Strategist's Belt
                { 9, 37179 }, -- Infantry Assault Blade
                { 10, 37177 }, -- Wand of the San'layn
                { 12, "ac1919" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45333 }, -- Belt of the Iron Servant
                { 4, 45378 }, -- Boots of the Petrified Forest
                { 6, 39392 }, -- Veiled Amulet of Life
                { 7, 39379 }, -- Spectral Rider's Girdle
                { 8, 39345 }, -- Girdle of the Ascended Phantom
                { 10, "ac1919" },
            }
        },
        { -- UtgardeKeepSkarvald / 3
            name = AL["Skarvald the Constructor & Dalronn the Controller"],
            npcID = {24200, 24201},
            EncounterJournalID = 639,
            Level = 72,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 35575 }, -- Skarvald's Dragonskin Habergeon
                { 2, 35574 }, -- Chestplate of the Northern Lights
                { 3, 35573 }, -- Arm Blade of Augelmir
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37183 }, -- Bindings of the Tunneler
                { 4, 37184 }, -- Dalronn's Jerkin
                { 5, 37182 }, -- Helmet of the Constructor
                { 6, 37181 }, -- Dagger of Betrayal
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39309 }, -- Leggings of the Instructor
                { 4, 39344 }, -- Slayer of the Lifeless
                { 5, 39369 }, -- Sabatons of Deathlike Gloom
                { 7, 37183 }, -- Bindings of the Tunneler
                { 8, 37184 }, -- Dalronn's Jerkin
                { 9, 37182 }, -- Helmet of the Constructor
                { 10, 37181 }, -- Dagger of Betrayal
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45329 }, -- Circlet of True Sight
                { 4, 45322 }, -- Claok of the Iron Council
                { 6, 39309 }, -- Leggings of the Instructor
                { 7, 39344 }, -- Slayer of the Lifeless
                { 8, 39369 }, -- Sabatons of Deathlike Gloom
            }
        },
        { -- UtgardeKeepIngvar / 4
            name = AL["Ingvar the Plunderer"],
            npcID = 23954,
            EncounterJournalID = 640,
            Level = 72,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 35577 }, -- Holistic Patchwork Breeches
                { 2, 35578 }, -- Overlaid Chain Spaulders
                { 3, 35576 }, -- Ingvar's Monolithic Cleaver
                { 16, 33330 }, -- Ingvar's Head
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37194 }, -- Sharp-Barbed Leather Belt
                { 4, 37193 }, -- Staggering Legplates
                { 5, 37192 }, -- Annhylde's Ring
                { 6, 37191 }, -- Drake-Mounted Crossbow
                { 8, 37189 }, -- Breeches of the Caller
                { 9, 37188 }, -- Plunderer's Helmet
                { 10, 37186 }, -- Unsmashable Heavy Band
                { 11, 37190 }, -- Enraged Feral Staff
                { 16, 43102 }, -- Frozen Orb
                { 18, 41793 }, -- Design: Fierce Monarch Topaz
                { 20, "ac1658" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37194 }, -- Sharp-Barbed Leather Belt
                { 4, 37193 }, -- Staggering Legplates
                { 5, 37192 }, -- Annhylde's Ring
                { 6, 37191 }, -- Drake-Mounted Crossbow
                { 8, 37189 }, -- Breeches of the Caller
                { 9, 37188 }, -- Plunderer's Helmet
                { 10, 37186 }, -- Unsmashable Heavy Band
                { 11, 37190 }, -- Enraged Feral Staff
                { 13, 41793 }, -- Design: Fierce Monarch Topaz
                { 15, 43102 }, -- Frozen Orb
                { 16, 39424 }, -- The Soulblade
                { 17, 40519 }, -- Footsteps of Malygos
                { 18, 40474 }, -- Surge Needle Ring
                { 20, 40616 }, -- Helm of the Lost Conqueror
                { 21, 40617 }, -- Helm of the Lost Protector
                { 22, 40618 }, -- Helm of the Lost Vanquisher
                { 23, 40622 }, -- Spaulders of the Lost Conqueror
                { 24, 40623 }, -- Spaulders of the Lost Protector
                { 25, 40624 }, -- Spaulders of the Lost Vanquisher
                { 26, 40619 }, -- Leggings of the Lost Conqueror
                { 27, 40620 }, -- Leggings of the Lost Protector
                { 28, 40621 }, -- Leggings of the Lost Vanquisher
                { 30, "ac1658" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45324 }, -- Leggings of Swift Reflexes
                { 4, 45330 }, -- Greaves of Iron Intensity
                { 5, 45418 }, -- Lady Maye's Sapphire Ring
                { 7, 39424 }, -- The Soulblade
                { 8, 40519 }, -- Footsteps of Malygos
                { 9, 40474 }, -- Surge Needle Ring
                { 16, "INV_Box_01", nil, AL["Tier Token iLvl200"], nil, "Tier7TitanRuneTokens" },
				{ 17, "INV_Box_01", nil, AL["Tier Token iLvl225"], nil, "Tier8TitanRuneTokens" },
                { 19, 43102 }, -- Frozen Orb
                { 21, 41793 }, -- Design: Fierce Monarch Topaz
                { 23, "ac1658" },
                { 101, 40616 }, -- Helm of the Lost Conqueror
                { 102, 40617 }, -- Helm of the Lost Protector
                { 103, 40618 }, -- Helm of the Lost Vanquisher
                { 104, 40622 }, -- Spaulders of the Lost Conqueror
                { 105, 40623 }, -- Spaulders of the Lost Protector
                { 106, 40624 }, -- Spaulders of the Lost Vanquisher
                { 107, 40619 }, -- Leggings of the Lost Conqueror
                { 108, 40620 }, -- Leggings of the Lost Protector
                { 109, 40621 }, -- Leggings of the Lost Vanquisher
                { 116, 45647 }, -- Helm of the Wayward Conqueror
                { 117, 45648 }, -- Helm of the Warward Protector
                { 118, 45649 }, -- Helm of the Wayward Vanquisher
                { 119, 45659 }, -- Spaulders of the Wayward Conqueror
                { 120, 45660 }, -- Spaulders of the Wayward Protector
                { 121, 45661 }, -- Spaulders of the Wayward Vanquisher
                { 122, 45635 }, -- Chestguard of the Wayward Conqueror
                { 123, 45636 }, -- Chestguard of the Wayward Protector
                { 124, 45637 }, -- Chestguard of the Wayward Vanquisher
                { 125, 45644 }, -- Gloves of the Wayward Conqueror
                { 126, 45645 }, -- Gloves of the Wayward Protector
                { 127, 45646 }, -- Gloves of the Wayward Vanquisher
                { 128, 45650 }, -- Leggings of the Wayward Conqueror
                { 129, 45651 }, -- Leggings of the Wayward Protector
                { 130, 45652 }, -- Leggings of the Wayward Vanquisher
            }
        },
        { -- Trash
            name = AL["Trash"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 35580 }, -- Skein Woven Mantle
		        { 2, 35579 }, -- Vrykul Shackles
            },
            [HEROIC_DIFF] = {
                { 1, 37197 }, -- Tattered Castle Drape
		        { 2, 37196 }, -- Runecaster's Mantle
            },
        },
        KEYS,
		WOTLK_DUNGEONMASTER_AC_TABLE,
		WOTLK_DUNGEON_HERO_AC_TABLE,
		WOTLK_GLORY_OF_THE_HERO_AC_TABLE,
    }
}

data["UtgardePinnacle"] = {
    nameFormat = NAME_UTGARDE,
	MapID = 1196,
    EncounterJournalID = 286,
	InstanceID = 575,
    ContentType = DUNGEON_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "UtgardePinnacle",
	AtlasMapFile = {"UtgardePinnacle"},
	LevelRange = {75, 79, 80},
	items = {
        { -- UPSorrowgrave / 58
            name = AL["Svala Sorrowgrave"],
            npcID = 26668,
            EncounterJournalID = 641,
            Level = 77,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 37043 }, -- Tear-Linked Gauntlets
                { 2, 37040 }, -- Svala's Bloodied Shackles
                { 3, 37037 }, -- Ritualistic Athame
                { 4, 37038 }, -- Brazier Igniter
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37370 }, -- Cuffs of the Trussed Hall
                { 4, 37369 }, -- Sorrowgrave's Breeches
                { 5, 37368 }, -- Silent Spectator Shoulderpads
                { 6, 37367 }, -- Echoing Stompers
                { 8, "ac2043" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39299 }, -- Rapid Attack Gloves
                { 4, 39296 }, -- Accursed Bow of the Elite
                { 5, 39308 }, -- Girdle of Lenience
                { 7, 37370 }, -- Cuffs of the Trussed Hall
                { 8, 37369 }, -- Sorrowgrave's Breeches
                { 9, 37368 }, -- Silent Spectator Shoulderpads
                { 10, 37367 }, -- Echoing Stompers
                { 12, "ac2043" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45423 }, -- Runetouch Wristwraps
                { 4, 45331 }, -- Rune-Etched Nightblade
                { 6, 39299 }, -- Rapid Attack Gloves
                { 7, 39296 }, -- Accursed Bow of the Elite
                { 8, 39308 }, -- Girdle of Lenience
                { 10, "ac2043" },
            }
        },
        { -- UPPalehoof / 59
            name = AL["Gortok Palehoof"],
            npcID = 26687,
            EncounterJournalID = 642,
            Level = 77,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 4,
            [NORMAL_DIFF] = {
                { 1, 37048 }, -- Shroud of Resurrection
                { 2, 37052 }, -- Reanimated Armor
                { 3, 37051 }, -- Seal of Valgarde
                { 4, 37050 }, -- Trophy Gatherer
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37374 }, -- Ravenous Leggings of the Furbolg
                { 4, 37373 }, -- Massive Spaulders of the Jormungar
                { 5, 37376 }, -- Ferocious Pauldrons of the Rhino
                { 6, 37371 }, -- Ring of the Frenzied Wolvar
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39298 }, -- Waistguard of the Tutor
                { 4, 39284 }, -- Miasma Mantle
                { 5, 39295 }, -- Cowl of Sheet Lightning
                { 7, 37374 }, -- Ravenous Leggings of the Furbolg
                { 8, 37373 }, -- Massive Spaulders of the Jormungar
                { 9, 37376 }, -- Ferocious Pauldrons of the Rhino
                { 10, 37371 }, -- Ring of the Frenzied Wolvar
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45708 }, -- Archaedas' Lost Legplates
                { 4, 45332 }, -- Stormtip
                { 6, 39298 }, -- Waistguard of the Tutor
                { 7, 39284 }, -- Miasma Mantle
                { 8, 39295 }, -- Cowl of Sheet Lightning
            }
        },
        { -- UPSkadi / 56
            name = AL["Skadi the Ruthless"],
            npcID = 26693,
            Level = 77,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 37055 }, -- Silken Amice of the Ymirjar
                { 2, 37057 }, -- Drake Rider's Tunic
                { 3, 37056 }, -- Harpooner's Striders
                { 4, 37053 }, -- Amulet of Deflected Blows
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37389 }, -- Crenelation Leggings
                { 4, 37379 }, -- Skadi's Iron Belt
                { 5, 37377 }, -- Netherbreath Spellblade
                { 6, 37384 }, -- Staff of Wayward Principles
                { 8, "ac1873" },
                { 9, "ac2156" },
                { 16, 44151 }, -- Reins of the Blue Proto-Drake
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 39297 }, -- Cloak of Darkening
                { 4, 39294 }, -- Arc-Scorched Helmet
                { 5, 39472 }, -- Chain of Latent Energies
                { 7, 37389 }, -- Crenelation Leggings
                { 8, 37379 }, -- Skadi's Iron Belt
                { 9, 37377 }, -- Netherbreath Spellblade
                { 10, 37384 }, -- Staff of Wayward Principles
                { 12, "ac1873" },
                { 13, "ac2156" },
                { 16, 44151 }, -- Reins of the Blue Proto-Drake
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45712 }, -- Chestplate of Titanic Fury
                { 4, 45864 }, -- Cover of the Keepers
                { 6, 39297 }, -- Cloak of Darkening
                { 7, 39294 }, -- Arc-Scorched Helmet
                { 8, 39472 }, -- Chain of Latent Energies
                { 10, "ac1873" },
                { 11, "ac2156" },
                { 16, 44151 }, -- Reins of the Blue Proto-Drake
            }
        },
        { -- UPYmiron / 57
            name = AL["King Ymiron"],
            npcID = 26861,
            EncounterJournalID = 644,
            Level = 77,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 37067 }, -- Ceremonial Pyre Mantle
                { 2, 37062 }, -- Crown of Forgotten Kings
                { 3, 37066 }, -- Ancient Royal Legguards
                { 4, 37058 }, -- Signet of Ranulf
                { 5, 37064 }, -- Vestige of Haldor
                { 6, 37060 }, -- Jeweled Coronation Sword
                { 7, 37065 }, -- Ymiron's Blade
                { 8, 37061 }, -- Tor's Crest
                { 16, 41797 }, -- Design: Austere Earthsiege Diamond
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37408 }, -- Girdle of Bane
                { 4, 37409 }, -- Gilt-Edged Leather Gauntlets
                { 5, 37407 }, -- Sovereign's Belt
                { 6, 37401 }, -- Red Sword of Courage
                { 8, 37398 }, -- Mantle of Discarded Ways
                { 9, 37395 }, -- Ornamented Plate Regalia
                { 10, 37397 }, -- Gold Amulet of Kings
                { 11, 37390 }, -- Meteorite Whetstone
                { 16, 43102 }, -- Frozen Orb
                { 18, 41797 }, -- Design: Austere Earthsiege Diamond
                { 20, "ac1790" },
                { 21, "ac2157" },
            },
            [ALPHA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 37408 }, -- Girdle of Bane
                { 4, 37409 }, -- Gilt-Edged Leather Gauntlets
                { 5, 37407 }, -- Sovereign's Belt
                { 6, 37401 }, -- Red Sword of Courage
                { 8, 37398 }, -- Mantle of Discarded Ways
                { 9, 37395 }, -- Ornamented Plate Regalia
                { 10, 37397 }, -- Gold Amulet of Kings
                { 11, 37390 }, -- Meteorite Whetstone
                { 13, 41797 }, -- Design: Austere Earthsiege Diamond
                { 15, 43102 }, -- Frozen Orb
                { 16, 39194 }, -- Rusted-Link Spiked Gauntlets
                { 17, 39423 }, -- Hammer of the Astral Plane
                { 18, 39421 }, -- Gem of Imprisoned Vassals
                { 20, 40616 }, -- Helm of the Lost Conqueror
                { 21, 40617 }, -- Helm of the Lost Protector
                { 22, 40618 }, -- Helm of the Lost Vanquisher
                { 23, 40622 }, -- Spaulders of the Lost Conqueror
                { 24, 40623 }, -- Spaulders of the Lost Protector
                { 25, 40624 }, -- Spaulders of the Lost Vanquisher
                { 26, 40619 }, -- Leggings of the Lost Conqueror
                { 27, 40620 }, -- Leggings of the Lost Protector
                { 28, 40621 }, -- Leggings of the Lost Vanquisher
                { 29, "ac1790" },
                { 30, "ac2157" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 45866 }, -- Elemental Focus Stone
                { 4, 45711 }, -- Ironaya's Discarded Mantle
                { 5, 45709 }, -- Nimble Climber's Belt
                { 7, 39194 }, -- Rusted-Link Spiked Gauntlets
                { 8, 39423 }, -- Hammer of the Astral Plane
                { 9, 39421 }, -- Gem of Imprisoned Vassals
                { 16, "INV_Box_01", nil, AL["Tier Token iLvl200"], nil, "Tier7TitanRuneTokens" },
				{ 17, "INV_Box_01", nil, AL["Tier Token iLvl225"], nil, "Tier8TitanRuneTokens" },
                { 19, 43102 }, -- Frozen Orb
                { 21, 41797 }, -- Design: Austere Earthsiege Diamond
                { 23, "ac1790" },
                { 24, "ac2157" },
                { 101, 40616 }, -- Helm of the Lost Conqueror
                { 102, 40617 }, -- Helm of the Lost Protector
                { 103, 40618 }, -- Helm of the Lost Vanquisher
                { 104, 40622 }, -- Spaulders of the Lost Conqueror
                { 105, 40623 }, -- Spaulders of the Lost Protector
                { 106, 40624 }, -- Spaulders of the Lost Vanquisher
                { 107, 40619 }, -- Leggings of the Lost Conqueror
                { 108, 40620 }, -- Leggings of the Lost Protector
                { 109, 40621 }, -- Leggings of the Lost Vanquisher
                { 116, 45647 }, -- Helm of the Wayward Conqueror
                { 117, 45648 }, -- Helm of the Warward Protector
                { 118, 45649 }, -- Helm of the Wayward Vanquisher
                { 119, 45659 }, -- Spaulders of the Wayward Conqueror
                { 120, 45660 }, -- Spaulders of the Wayward Protector
                { 121, 45661 }, -- Spaulders of the Wayward Vanquisher
                { 122, 45635 }, -- Chestguard of the Wayward Conqueror
                { 123, 45636 }, -- Chestguard of the Wayward Protector
                { 124, 45637 }, -- Chestguard of the Wayward Vanquisher
                { 125, 45644 }, -- Gloves of the Wayward Conqueror
                { 126, 45645 }, -- Gloves of the Wayward Protector
                { 127, 45646 }, -- Gloves of the Wayward Vanquisher
                { 128, 45650 }, -- Leggings of the Wayward Conqueror
                { 129, 45651 }, -- Leggings of the Wayward Protector
                { 130, 45652 }, -- Leggings of the Wayward Vanquisher
            }
        },
        { -- Trash
            name = AL["Trash"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 37070 }, -- Tundra Wolf Boots
                { 2, 37069 }, -- Dragonflayer Seer's Bindings
                { 3, 37068 }, -- Berserker's Sabatons
            },
            [HEROIC_DIFF] = {
                { 1, 37587 }, -- Ymirjar Physician's Robe
                { 2, 37590 }, -- Bands of Fading Light
                { 3, 37410 }, -- Tracker's Balanced Knives
            },
        },
        KEYS,
		WOTLK_DUNGEONMASTER_AC_TABLE,
		WOTLK_DUNGEON_HERO_AC_TABLE,
		WOTLK_GLORY_OF_THE_HERO_AC_TABLE,
    }
}

data["TrialoftheChampion"] = {
    nameFormat = NAME_AT,
	MapID = 4723,
    EncounterJournalID = 284,
	InstanceID = 650,
    ContentType = DUNGEON_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "TrialOfTheChampion",
	AtlasMapFile = {"TrialOfTheChampion"},
	LevelRange = {75, 79, 80},
	items = {
        { -- TrialoftheChampionChampions / 213
            name = AL["Grand Champions"],
            npcID = {34705,34702,34701,34657,34703, 35572,35569,35571,35570,35617},
            EncounterJournalID = 834,
            ObjectID = 195709,
            Level = 80,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 47173 }, -- Bindings of the Wicked
                { 2, 47170 }, -- Belt of Fierce Competition
                { 3, 47174 }, -- Binding of the Tranquil Glade
                { 4, 47175 }, -- Scale Boots of the Outlander
                { 5, 47172 }, -- Helm of the Bested Gallant
                { 6, 47171 }, -- Legguards of Abandoned Fealty
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 47249 }, -- Leggings of the Snowy Bramble
                { 4, 47248 }, -- Treads of Dismal Fortune
                { 5, 47250 }, -- Pauldrons of the Deafening Gale
                { 6, 47244 }, -- Chestguard of the Ravenous Fiend
                { 7, 47243 }, -- Mark of the Relentless
                { 8, 47493 }, -- Edge of Ruin
                { 16, 44990 }, -- Champion's Seal
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 46024 }, -- Kingsbane
                { 4, 46028 }, -- Faceguard of the Eyeless Horror
                { 6, 47249 }, -- Leggings of the Snowy Bramble
                { 7, 47248 }, -- Treads of Dismal Fortune
                { 8, 47250 }, -- Pauldrons of the Deafening Gale
                { 9, 47244 }, -- Chestguard of the Ravenous Fiend
                { 10, 47243 }, -- Mark of the Relentless
                { 11, 47493 }, -- Edge of Ruin
                { 16, 44990 }, -- Champion's Seal
            }
        },
        { -- TrialoftheChampionEadricthePure / 215
            name = AL["Eadric the Pure"],
            npcID = 35119,
            EncounterJournalID = 635,
            Level = 80,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 47181 }, -- Belt of the Churning Blaze
                { 2, 47185 }, -- Leggings of the Haggard Apprentice
                { 3, 47210 }, -- Mantle of Gnarled Overgrowth
                { 4, 47177 }, -- Gloves of the Argent Fanatic
                { 5, 47202 }, -- Leggings of Brazen Trespass
                { 6, 47178 }, -- Carapace of Grim Visions
                { 7, 47176 }, -- Breastplate of the Imperial Joust
                { 8, 47197 }, -- Gauntlets of the Stouthearted Crusader
                { 9, 47201 }, -- Boots of Heartfelt Repentance
                { 10, 47199 }, -- Greaves of the Grand Paladin
                { 11, 47200 }, -- Signet of Purity
                { 12, 47213 }, -- Abyssal Rune
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 47501 }, -- Kurisu's Indecision
                { 4, 47496 }, -- Armbands of the Wary Lookout
                { 5, 47498 }, -- Gloves of Dismal Fortune
                { 6, 47504 }, -- Barkhide Treads
                { 7, 47497 }, -- Helm of the Crestfallen Challenger
                { 8, 47502 }, -- Majestic Silversmith Shoulderplates
                { 9, 47495 }, -- Legplates of Relentless Onslaught
                { 10, 47503 }, -- Legplates of the Argent Armistice
                { 11, 47494 }, -- Ancient Pendant of Arathor
                { 12, 47500 }, -- Peacekeeper Blade
                { 13, 47509 }, -- Mariel's Sorrow
                { 14, 47508 }, -- Aledar's Battlestar
                { 16, 44990 }, -- Champion's Seal
                { 18, "ac3803" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 46022 }, -- Pendant of a Thousand Maws
                { 4, 45311 }, -- Relentless Edge
                { 6, 44990 }, -- Champion's Seal
                { 8, "ac3803" },
                { 16, 47501 }, -- Kurisu's Indecision
                { 17, 47496 }, -- Armbands of the Wary Lookout
                { 18, 47498 }, -- Gloves of Dismal Fortune
                { 19, 47504 }, -- Barkhide Treads
                { 20, 47497 }, -- Helm of the Crestfallen Challenger
                { 21, 47502 }, -- Majestic Silversmith Shoulderplates
                { 22, 47495 }, -- Legplates of Relentless Onslaught
                { 23, 47503 }, -- Legplates of the Argent Armistice
                { 24, 47494 }, -- Ancient Pendant of Arathor
                { 25, 47500 }, -- Peacekeeper Blade
                { 26, 47509 }, -- Mariel's Sorrow
                { 27, 47508 }, -- Aledar's Battlestar
            }
        },
        { -- TrialoftheChampionConfessorPaletress / 214
            name = AL["Argent Confessor Paletress"],
            npcID = 34928,
            EncounterJournalID = 636,
            Level = 80,
            --DisplayIDs = {{17386}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 47181 }, -- Belt of the Churning Blaze
                { 2, 47218 }, -- The Confessor's Binding
                { 3, 47185 }, -- Leggings of the Haggard Apprentice
                { 4, 47217 }, -- Gaze of the Somber Keeper
                { 5, 47177 }, -- Gloves of the Argent Fanatic
                { 6, 47178 }, -- Carapace of Grim Visions
                { 7, 47211 }, -- Wristguards of Ceaseless Regret
                { 8, 47176 }, -- Breastplate of the Imperial Joust
                { 9, 47212 }, -- Mercy's Hold
                { 10, 47219 }, -- Brilliant Hailstone Amulet
                { 11, 47213 }, -- Abyssal Rune
                { 12, 47214 }, -- Banner of Victory
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 47498 }, -- Gloves of Dismal Fortune
                { 4, 47496 }, -- Armbands of the Wary Lookout
                { 5, 47245 }, -- Pauldrons of Concealed Loathing
                { 6, 47497 }, -- Helm of the Crestfallen Challenger
                { 7, 47514 }, -- Regal Aurous Shoulderplates
                { 8, 47510 }, -- Trueheart Girdle
                { 9, 47495 }, -- Legplates of Relentless Onslaught
                { 10, 47511 }, -- Plated Greaves of Providence
                { 11, 47494 }, -- Ancient Pendant of Arathor
                { 12, 47512 }, -- Sinner's Confession
                { 13, 47500 }, -- Peacekeeper Blade
                { 14, 47522 }, -- Marrowstrike
                { 16, 44990 }, -- Champion's Seal
                { 18, "ac3802" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 46022 }, -- Pendant of a Thousand Maws
                { 4, 45311 }, -- Relentless Edge
                { 6, 44990 }, -- Champion's Seal
                { 8, "ac3802" },
                { 16, 47498 }, -- Gloves of Dismal Fortune
                { 17, 47496 }, -- Armbands of the Wary Lookout
                { 18, 47245 }, -- Pauldrons of Concealed Loathing
                { 19, 47497 }, -- Helm of the Crestfallen Challenger
                { 20, 47514 }, -- Regal Aurous Shoulderplates
                { 21, 47510 }, -- Trueheart Girdle
                { 22, 47495 }, -- Legplates of Relentless Onslaught
                { 23, 47511 }, -- Plated Greaves of Providence
                { 24, 47494 }, -- Ancient Pendant of Arathor
                { 25, 47512 }, -- Sinner's Confession
                { 26, 47500 }, -- Peacekeeper Blade
                { 27, 47522 }, -- Marrowstrike
            }
        },

        { -- TrialoftheChampionBlackKnight / 216
            name = AL["The Black Knight"],
            npcID = 35451,
            EncounterJournalID = 637,
            Level = 80,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 4,
            [NORMAL_DIFF] = {
                { 1, 47232 }, -- Drape of the Undefeated
                { 2, 47226 }, -- Mantle of Inconsolable Fear
                { 3, 47230 }, -- Handwraps of Surrendered Hope
                { 4, 47221 }, -- Shoulderpads of the Infamous Knave
                { 5, 47231 }, -- Belt of Merciless Cruelty
                { 6, 47228 }, -- Leggings of the Bloodless Knight
                { 7, 47220 }, -- Helm of the Violent Fray
                { 8, 47229 }, -- Girdle of Arrogant Downfall
                { 9, 47227 }, -- Girdle of the Pallid Knight
                { 10, 47222 }, -- Uruka's Band of Zeal
                { 11, 47215 }, -- Tears of the Vanquished
                { 12, 47216 }, -- The Black Heart
            },
            [HEROIC_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 47564 }, -- Gaze of the Unknown
                { 4, 47527 }, -- Embrace of Madness
                { 5, 47560 }, -- Boots of the Crackling Flame
                { 6, 47529 }, -- Mask of Distant Memory
                { 7, 47561 }, -- Gloves of the Dark Exile
                { 8, 47563 }, -- Girdle of the Dauntless Conqueror
                { 9, 47565 }, -- Vambraces of Unholy Command
                { 10, 47567 }, -- Gauntlets of Revelation
                { 11, 47562 }, -- Symbol of Redemption
                { 12, 47566 }, -- The Warlord's Depravity
                { 13, 47569 }, -- Spectral Kris
                { 14, 49682 }, -- Black Knight's Rondel
                { 15, 47568 }, -- True-aim Long Rifle
                { 16, 43102 }, -- Frozen Orb
                { 18, 44990 }, -- Champion's Seal
                { 20, "ac3804" },
            },
            [BETA_DIFF] = {
                { 1, 45624 }, -- Emblem of Conquest
                { 3, 46030 }, -- Treads of the Dragon Council
                { 4, 46031 }, -- Touch of Madness
                { 5, 46021 }, -- Royal Seal of King Llane
                { 7, "INV_Box_01", nil, AL["Tier Token iLvl200"], nil, "Tier7TitanRuneTokens" },
				{ 8, "INV_Box_01", nil, AL["Tier Token iLvl225"], nil, "Tier8TitanRuneTokens" },
                { 10, 43102 }, -- Frozen Orb
                { 12, "ac3804" },
                { 16, 47564 }, -- Gaze of the Unknown
                { 17, 47527 }, -- Embrace of Madness
                { 18, 47560 }, -- Boots of the Crackling Flame
                { 19, 47529 }, -- Mask of Distant Memory
                { 20, 47561 }, -- Gloves of the Dark Exile
                { 21, 47563 }, -- Girdle of the Dauntless Conqueror
                { 22, 47565 }, -- Vambraces of Unholy Command
                { 23, 47567 }, -- Gauntlets of Revelation
                { 24, 47562 }, -- Symbol of Redemption
                { 25, 47566 }, -- The Warlord's Depravity
                { 26, 47569 }, -- Spectral Kris
                { 27, 49682 }, -- Black Knight's Rondel
                { 28, 47568 }, -- True-aim Long Rifle
                { 101, 40616 }, -- Helm of the Lost Conqueror
                { 102, 40617 }, -- Helm of the Lost Protector
                { 103, 40618 }, -- Helm of the Lost Vanquisher
                { 104, 40622 }, -- Spaulders of the Lost Conqueror
                { 105, 40623 }, -- Spaulders of the Lost Protector
                { 106, 40624 }, -- Spaulders of the Lost Vanquisher
                { 107, 40619 }, -- Leggings of the Lost Conqueror
                { 108, 40620 }, -- Leggings of the Lost Protector
                { 109, 40621 }, -- Leggings of the Lost Vanquisher
                { 116, 45647 }, -- Helm of the Wayward Conqueror
                { 117, 45648 }, -- Helm of the Warward Protector
                { 118, 45649 }, -- Helm of the Wayward Vanquisher
                { 119, 45659 }, -- Spaulders of the Wayward Conqueror
                { 120, 45660 }, -- Spaulders of the Wayward Protector
                { 121, 45661 }, -- Spaulders of the Wayward Vanquisher
                { 122, 45635 }, -- Chestguard of the Wayward Conqueror
                { 123, 45636 }, -- Chestguard of the Wayward Protector
                { 124, 45637 }, -- Chestguard of the Wayward Vanquisher
                { 125, 45644 }, -- Gloves of the Wayward Conqueror
                { 126, 45645 }, -- Gloves of the Wayward Protector
                { 127, 45646 }, -- Gloves of the Wayward Vanquisher
                { 128, 45650 }, -- Leggings of the Wayward Conqueror
                { 129, 45651 }, -- Leggings of the Wayward Protector
                { 130, 45652 }, -- Leggings of the Wayward Vanquisher
            }
        },
        KEYS
    }
}

local ICC_DUNGEONS_TRASH = { -- Trash
    name = AL["Trash"],
    ExtraList = true,
    [NORMAL_DIFF] = {
        { 1, 49854 }, -- Mantle of Tattered Feathers
		{ 2, 49855 }, -- Plated Grips of Korth'azz
		{ 3, 49853 }, -- Titanium Links of Lore
		{ 4, 49852 }, -- Coffin Nail
    },
    [HEROIC_DIFF] = {
        { 1, 50318 }, -- Ghostly Wristwraps
		{ 2, 50315 }, -- Seven-Fingered Claws
		{ 3, 50319 }, -- Unsharpened Ice Razor
        { 4, 50051 }, -- Hammer of Purified Flame
		{ 5, 50050 }, -- Cudgel of Furious Justice
		{ 6, 50052 }, -- Lightborn Spire
        { 16, AtlasLoot:GetRetByFaction(50380, 50379) }, -- Battered Hilt
    },
}

data["ForgeOfSouls"] = {
    nameFormat = NAME_ICC,
	MapID = 4809,
    EncounterJournalID = 280,
	InstanceID = 632,
    ContentType = DUNGEON_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "FHTheForgeOfSouls",
	AtlasMapFile = {"FHTheForgeOfSouls", "IcecrownEnt"},
	LevelRange = {75, 79, 80},
	items = {
        { -- FoSBronjahm / 268
            name = AL["Bronjahm"],
            npcID = 36497,
            EncounterJournalID = 615,
            Level = 80,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 49788 }, -- Cold Sweat Grips
                { 2, 49785 }, -- Bewildering Shoulderpads
                { 3, 49786 }, -- Robes of the Cheating Heart
                { 4, 49787 }, -- Seven Stormy Mornings
                { 5, 49784 }, -- Minister's Number One Legplates
                { 6, 49783 }, -- Lucky Old Sun
                { 16, 50317 }, -- Papa's New Bag
                { 17, 50316 }, -- Papa's Brand New Bag
            },
            [HEROIC_DIFF] = {
                { 1, 50193 }, -- Very Fashionable Shoulders
                { 2, 50197 }, -- Eyes of Bewilderment
                { 3, 50194 }, -- Weeping Gauntlets
                { 4, 50196 }, -- Love's Prisoner
                { 5, 50191 }, -- Nighttime
                { 6, 50169 }, -- Papa's Brand New Knife
                { 16, 50317 }, -- Papa's New Bag
                { 17, 50316 }, -- Papa's Brand New Bag
                { 19, "ac4522" },
            }
        },
        { -- FoSDevourer / 269
            name = AL["Devourer of Souls"],
            npcID = 36502,
            EncounterJournalID = 616,
            Level = 80,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 49792 }, -- Accursed Crawling Cape
                { 2, 49796 }, -- Essence of Anger
                { 3, 49798 }, -- Soul Screaming Boots
                { 4, 49791 }, -- Lost Reliquary Chestguard
                { 5, 49797 }, -- Brace Guards of the Starless Night
                { 6, 49794 }, -- Legplates of Frozen Granite
                { 7, 49795 }, -- Sollerets of Suffering
                { 8, 49799 }, -- Coil of Missing Gems
                { 9, 49800 }, -- Spiteful Signet
                { 10, 49789 }, -- Heartshiver
                { 11, 49790 }, -- Blood Boil Lancet
                { 12, 49793 }, -- Tower of the Mouldering Corpse
            },
            [HEROIC_DIFF] = {
                { 1, 50213 }, -- Mord'rethar Robes
                { 2, 50206 }, -- Frayed Scoundrel's Cap
                { 3, 50212 }, -- Essence of Desire
                { 4, 50214 }, -- Helm of the Spirit Shock
                { 5, 50209 }, -- Essence of Suffering
                { 6, 50208 }, -- Pauldrons of the Devourer
                { 7, 50207 }, -- Black Spire Sabatons
                { 8, 50215 }, -- Recovered Reliquary Boots
                { 9, 50211 }, -- Arcane Loops of Anger
                { 10, 50198 }, -- Needle-Encrusted Scorpion
                { 11, 50203 }, -- Blood Weeper
                { 12, 50210 }, -- Seethe
                { 16, 43102 }, -- Frozen Orb
                { 18, "ac4523" },
            }
        },
        ICC_DUNGEONS_TRASH,
        KEYS
    }
}

data["PitOfSaron"] = {
    nameFormat = NAME_ICC,
	MapID = 4813,
    EncounterJournalID = 278,
	InstanceID = 658,
    ContentType = DUNGEON_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "FHPitOfSaron",
	AtlasMapFile = {"FHPitOfSaron", "IcecrownEnt"},
	LevelRange = {75, 79, 80},
	items = {
        { -- PoSGarfrost / 271
            name = AL["Forgemaster Garfrost"],
            npcID = 36494,
            EncounterJournalID = 608,
            Level = 80,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 49805 }, -- Ice-Steeped Sandals
                { 2, 49806 }, -- Flayer's Black Belt
                { 3, 49804 }, -- Polished Mirror Helm
                { 4, 49803 }, -- Ring of Carnelian and Bone
                { 5, 49802 }, -- Garfrost's Two-Ton Hammer
                { 6, 49801 }, -- Unspeakable Secret
            },
            [HEROIC_DIFF] = {
                { 1, 50233 }, -- Spurned Val'kyr Shoulderguards
                { 2, 50234 }, -- Shoulderplates of Frozen Blood
                { 3, 50230 }, -- Malykriss Vambraces
                { 4, 50229 }, -- Legguards of the Frosty Depths
                { 5, 50228 }, -- Barbed Ymirheim Choker
                { 6, 50227 }, -- Surgeon's Needle
                { 16, "ac4524" },
            }
        },
        { -- PoSKrickIck / 272
            name = AL["Ick & Krick"],
            npcID = {36476,36477},
            EncounterJournalID = 609,
            Level = 80,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 49809 }, -- Wristguards of Subterranean Moss
                { 2, 49810 }, -- Scabrous Zombie Leather Belt
                { 3, 49811 }, -- Black Dragonskin Breeches
                { 4, 49808 }, -- Bent Gold Belt
                { 5, 49812 }, -- Purloined Wedding Ring
                { 6, 49807 }, -- Krick's Beetle Stabber
            },
            [HEROIC_DIFF] = {
                { 1, 50266 }, -- Ancient Polar Bear Hide
                { 2, 50263 }, -- Braid of Salt and Fire
                { 3, 50264 }, -- Chewed Leather Wristguards
                { 4, 50265 }, -- Blackened Ghoul Skin Leggings
                { 5, 50235 }, -- Ick's Rotting Thumb
                { 6, 50262 }, -- Felglacier Bolter
            }
        },
        { -- PoSTyrannus / 273
            name = AL["Scourgelord Tyrannus"],
            npcID = 36658,
            EncounterJournalID = 610,
            Level = 80,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 49823 }, -- Cloak of the Fallen Cardinal
                { 2, 49825 }, -- Palebone Robes
                { 3, 49822 }, -- Rimewoven Silks
                { 4, 49817 }, -- Shaggy Wyrmleather Leggings
                { 5, 49824 }, -- Horns of the Spurned Val'kyr
                { 6, 49826 }, -- Shroud of Rime
                { 7, 49820 }, -- Gondria's Spectral Bracer
                { 8, 49819 }, -- Skeleton Lord's Cranium
                { 9, 49816 }, -- Scourgelord's Frigid Chestplate
                { 10, 49818 }, -- Painfully Sharp Choker
                { 11, 49821 }, -- Protector of Frigid Souls
                { 12, 49813 }, -- Rimebane Rifle
            },
            [HEROIC_DIFF] = {
                { 1, 50286 }, -- Prelate's Snowshoes
                { 2, 50269 }, -- Fleshwerk Leggings
                { 3, 50270 }, -- Belt of Rotted Fingernails
                { 4, 50283 }, -- Mudslide Boots
                { 5, 50272 }, -- Frost Wyrm Ribcage
                { 6, 50285 }, -- Icebound Bronze Cuirass
                { 7, 50284 }, -- Rusty Frozen Fingerguards
                { 8, 50271 }, -- Band of Stained Souls
                { 9, 50259 }, -- Nevermelting Ice Crystal
                { 10, 50268 }, -- Rimefang's Claw
                { 11, 50267 }, -- Tyrannical Beheader
                { 12, 50273 }, -- Engraved Gargoyle Femur
                { 16, 43102 },	-- Frozen Orb
				{ 18, "ac4525" },
            }
        },
        ICC_DUNGEONS_TRASH,
        KEYS
    }
}

data["HallsOfReflection"] = {
    nameFormat = NAME_ICC,
	MapID = 4820,
    EncounterJournalID = 276,
	InstanceID = 668,
    ContentType = DUNGEON_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "FHHallsOfReflection",
	AtlasMapFile = {"FHHallsOfReflection", "IcecrownEnt"},
	LevelRange = {75, 79, 80},
	items = {
        { -- HoRFalric / 275
            name = AL["Falric"],
            npcID = 38112,
            EncounterJournalID = 601,
            Level = 80,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 49832 }, -- Eerie Runeblade Polisher
                { 2, 49828 }, -- Marwyn's Macabre Fingertips
                { 3, 49830 }, -- Fallen Sentry's Hood
                { 4, 49831 }, -- Muddied Boots of Brill
                { 5, 49829 }, -- Valonforth's Tarnished Pauldrons
                { 6, 49827 }, -- Ghoulslicer
            },
            [HEROIC_DIFF] = {
                { 1, 50292 }, -- Bracer of Worn Molars
                { 2, 50293 }, -- Spaulders of Black Betrayal
                { 3, 50295 }, -- Spiked Toestompers
                { 4, 50294 }, -- Chestpiece of High Treason
                { 5, 50290 }, -- Falric's Wrist-Chopper
                { 6, 50291 }, -- Soulsplinter
            }
        },
        { -- HoRMarwyn / 276
            name = AL["Marwyn"],
            npcID = 38113,
            EncounterJournalID = 602,
            Level = 80,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 49834 }, -- Frayed Abomination Stitching Shoulders
                { 2, 49838 }, -- Carpal Tunnelers
                { 3, 49837 }, -- Mitts of Burning Hail
                { 4, 49836 }, -- Frostsworn Bone Leggings
                { 5, 49833 }, -- Splintered Icecrown Parapet
                { 6, 49835 }, -- Splintered Door of the Citadel
            },
            [HEROIC_DIFF] = {
                { 1, 50298 }, -- Sightless Crown of Ulmaas
                { 2, 50299 }, -- Suspiciously Soft Gloves
                { 3, 50300 }, -- Choking Hauberk
                { 4, 50297 }, -- Frostsworn Bone Chestpiece
                { 5, 50260 }, -- Ephemeral Snowflake
                { 6, 50296 }, -- Orca-Hunter's Harpoon
            }
        },
        { -- HoRLichKing / 277
            name = AL["Wrath of the Lich King"],
            npcID = 36954,
            EncounterJournalID = 603,
            Level = 80,
            -- DisplayIDs = {{0}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 49842 }, -- Tapestry of the Frozen Throne
                { 2, 49849 }, -- Tattered Glacial-Woven Hood
                { 3, 49848 }, -- Grim Lasher Shoulderguards
                { 4, 49841 }, -- Blackened Geist Ribs
                { 5, 49847 }, -- Legguards of Untimely Demise
                { 6, 49851 }, -- Greathelm of the Silver Hand
                { 7, 49843 }, -- Crystalline Citadel Gauntlets
                { 8, 49846 }, -- Chilled Heart of the Glacier
                { 9, 49839 }, -- Mourning Malice
                { 10, 49840 }, -- Hate-Forged Cleaver
                { 11, 49845 }, -- Bone Golem Scapula
                { 12, 49844 }, -- Crypt Fiend Slayer
            },
            [HEROIC_DIFF] = {
                { 1, 50314 }, -- Strip of Remorse
                { 2, 50312 }, -- Chestguard of Broken Branches
                { 3, 50308 }, -- Blighted Leather Footpads
                { 4, 50304 }, -- Hoarfrost Gauntlets
                { 5, 50311 }, -- Second Helm of the Executioner
                { 6, 50305 }, -- Grinning Skull Boots
                { 7, 50310 }, -- Fossilized Ammonite Choker
                { 8, 50313 }, -- Oath of Empress Zoe
                { 9, 50306 }, -- The Lady's Promise
                { 10, 50309 }, -- Shriveled Heart
                { 11, 50302 }, -- Liar's Tongue
                { 12, 50303 }, -- Black Icicle
                { 16, 43102 },-- Frozen Orb
				{ 18, "ac4526" },
            }
        },
        ICC_DUNGEONS_TRASH,
        KEYS
    }
}

-- ## RAIDS
data["MoltenCore80"] = {
    MapID = 2717,
    name =AL["P1 Molten Core"],
    InstanceID = 409,
    AtlasModule = ATLAS_ERA_MODULE_NAME,
    AtlasMapID = "MoltenCore",
    AtlasMapFile = "CL_MoltenCore",
    AtlasMapFile_AL = "MoltenCore",
    ContentType = RAID_CONTENT,
    items = {{
        DisplayIDs = {{13031}, {12030}},
        name = AL["Lucifron"],
        AtlasMapBossID = 1,
        Level = 999,
        [NORMAL_DIFF] = {
            {1, 260495}, -- 熔火胜利者的护腕
            {2, 260504}, -- 熔火征服者的护腕
            {3, 260511}, -- 熔火保卫者的护腕
            
            {16, 255135}, 
            {17, 255100}, 
            {18, 255148}, 
            {19, 259901}, 
            {20, 255136}, 
            {21, 255137}, 
            {22, 255134}, 
            {23, 255139},
            {24, 255150}, 
            {25, 259900}, 
            {26, 255138}, 
            {30, 16665}},
        npcID = 12118
    }, {
        DisplayIDs = {{10193}},
        name = AL["Magmadar"],
        AtlasMapBossID = 2,
        Level = 999,
        [NORMAL_DIFF] = {
            {1, 260495}, -- 熔火胜利者的护腕
            {2, 260504}, -- 熔火征服者的护腕
            {3, 260511}, -- 熔火保卫者的护腕
            {5, 260494}, -- 熔火胜利者的腰带
            {6, 260503}, -- 熔火征服者的腰带
            {7, 260512}, -- 熔火保卫者的腰带

            {11, 255104}, 
            
            {16, 255084}, 
            {17, 255131}, 
            {18, 255129}, 
            {19, 255146}, 
            {20, 255140}, 
            {21, 255134}, 
            {22, 255147},
            {23, 255130}, 
            {24, 255127}, 
            {25, 255126}, 
            {26, 255145}, 
            {27, 255086}, 
            {28, 255089},
            {29, 259902}
        },
        npcID = 11982
    }, {
        DisplayIDs = {{13030}, {12002}},
        name = AL["Gehennas"],
        AtlasMapBossID = 3,
        Level = 999,
        [NORMAL_DIFF] = {
            {1, 260494}, -- 熔火胜利者的腰带
            {2, 260503}, -- 熔火征服者的腰带
            {3, 260512}, -- 熔火保卫者的腰带


           
            {16, 255135}, {17, 255148}, {18, 259901}, {19, 255136}, {20, 255137}, {21, 255134}, {22, 255139}, {23, 255150},
            {24, 259900}, {25, 255138}
        },
        npcID = 12259
    }, {
        DisplayIDs = {{12110}, {5781}},
        name = AL["Garr"],
        AtlasMapBossID = 4,
        Level = 999,
        [NORMAL_DIFF] = {

            {1, 260490}, -- 熔火胜利者的护胫
            {2, 260498}, -- 熔火征服者的护胫
            {3, 260506}, -- 熔火保卫者的护胫

            {16, 255131}, {17, 255129}, {18, 255146}, {19, 255140}, {20, 255134}, {21, 255147}, {22, 255130}, {23, 255127},
            {24, 255126}, {25, 255145}, {26, 255085}, {27, 255087}, {28, 255097}, {29, 255132},
            {30, 259902}
        },
        npcID = 12057
    }, {
        DisplayIDs = {{13032}},
        name = AL["Shazzrah"],
        AtlasMapBossID = 5,
        Level = 999,
        [NORMAL_DIFF] = {
            {1, 260493}, -- 熔火胜利者的护肩
            {2, 260502}, -- 熔火征服者的护肩
            {3, 260505}, -- 熔火保卫者的护肩
          
        {16, 255135}, {17, 255148}, {18, 259901}, {19, 255136}, {20, 255137}, {21, 255134}, {22, 255139}, {23, 255150},
                         {24, 259900}, {25, 255138}},
        npcID = 12264
    }, {
        DisplayIDs = {{12129}},
        name = AL["Baron Geddon"],
        AtlasMapBossID = 6,
        Level = 999,
        [NORMAL_DIFF] = {
            -- {1, 18563}, 
            {1, 255103}, 
          
            {3, 260496}, -- 熔火胜利者的手套
            {4, 260499}, -- 熔火征服者的手套
            {5, 260509}, -- 熔火保卫者的手套

       
        {16, 255131}, {17, 255129}, {18, 255146}, {19, 255140}, {20, 255134}, {21, 255147}, {22, 255130}, {23, 255127},
                         {24, 255101}, {25, 255126}, {26, 255145}, {27, 259902}},
        npcID = 12056
    }, {
        DisplayIDs = {{11986}},
        name = AL["Golemagg the Incinerator"],
        AtlasMapBossID = 7,
        Level = 999,
        [NORMAL_DIFF] = {
            {1, 260492}, -- 熔火胜利者的护腿
            {2, 260501}, -- 熔火征服者的护腿
            {3, 260508}, -- 熔火保卫者的护腿
            {5, 260491}, -- 熔火胜利者的战盔
            {6, 260500}, -- 熔火征服者的战盔
            {7, 260510}, -- 熔火保卫者的战盔

            
           
        {11, 17203}, {16, 255131}, {17, 255129}, {18, 255146}, {19, 255140}, {20, 255134}, {21, 255147}, {22, 255130},
                         {23, 255127}, {24, 255126}, {25, 255145}, {26, 255088}, {27, 255095}, {28, 259902},
                         {29, 255133}},
        npcID = 11988
    }, {
        DisplayIDs = {{13030}, {12030}},
        name = AL["Sulfuron Harbinger"],
        AtlasMapBossID = 8,
        Level = 999,
        [NORMAL_DIFF] = {
            {1, 260491}, -- 熔火胜利者的战盔
            {2, 260500}, -- 熔火征服者的战盔
            {3, 260510}, -- 熔火保卫者的战盔
        {16, 255135}, {17, 255148}, {18, 259901}, {19, 255136}, {20, 255137}, {21, 255134}, {22, 255139}, {23, 255150},
                         {24, 259900}, {25, 255138}, {26, 255090}},
        npcID = 12098
    }, {
        DisplayIDs = {{12029}, {13029}, {12002}},
        name = AL["Majordomo Executus"],
        AtlasMapBossID = 9,
        ["ObjectID"] = 179703,
        Level = 999,
        [NORMAL_DIFF] = {
            {1, 260492}, -- 熔火胜利者的护腿
            {2, 260501}, -- 熔火征服者的护腿
            {3, 260508}, -- 熔火保卫者的护腿
            {5, 260780}, 
            {6, 255109},
            
            {16, 259904}, 
            {17, 255119}, 
            {18, 259903}, 
            {19, 255117}, 
            {20, 255118}, 
            {21, 255121}, 
            {22, 255116},
                        
            {23, 255144}, 
            {24, 255115}, 
            {25, 255114}, 
        },
        npcID = 12018
    }, {
        DisplayIDs = {{11121}},
        name = AL["Ragnaros"],
        AtlasMapBossID = 10,
        Level = 999,
        [NORMAL_DIFF] = {
            {1, 257605},
             --{2, 19017}, 
            {4, 260489}, -- 熔火胜利者的胸甲
            {5, 260497}, -- 熔火征服者的胸甲
            {6, 260507}, -- 熔火保卫者的胸甲
            {14, 255093}, 
            {16, 255125}, {17, 255122}, {18, 259905}, {19, 259906}, {20, 255141},
                         {21, 255083}, {22, 259907}, {23, 255123}, {24, 255098}, {25, 255124}, {26, 255096},
                         {27, 255091}},
        npcID = 11502
    }, {
        [NORMAL_DIFF] = {
            {1, 260703}, {2, 260712}, {4, 260722}, {6, 260734}, {7, 260774}
        },
        name = AL["All bosses"],
        ExtraList = true
    }, T1_SET, 
    --          {
    --             name="T1",
    --             [NORMAL_DIFF]={
    --                {1, 260491},--熔火胜利者的战盔
    -- {2, 260500},--熔火征服者的战盔
    -- {3, 260510},--熔火保卫者的战盔
    -- {5, 260493},--熔火胜利者的护肩
    -- {6, 260502},--熔火征服者的护肩
    -- {7, 260505},--熔火保卫者的护肩
    -- {9, 260489},--熔火胜利者的胸甲
    -- {10, 260497},--熔火征服者的胸甲
    -- {11, 260507},--熔火保卫者的胸甲
    -- {13, 260495},--熔火胜利者的护腕
    -- {14, 260504},--熔火征服者的护腕
    -- {15, 260511},--熔火保卫者的护腕
    -- {16, 260496},--熔火胜利者的手套
    -- {17, 260499},--熔火征服者的手套
    -- {18, 260509},--熔火保卫者的手套
    -- {20, 260494},--熔火胜利者的腰带
    -- {21, 260503},--熔火征服者的腰带
    -- {22, 260512},--熔火保卫者的腰带
    -- {24, 260492},--熔火胜利者的护腿
    -- {25, 260501},--熔火征服者的护腿
    -- {26, 260508},--熔火保卫者的护腿
    -- {28, 260490},--熔火胜利者的护胫
    -- {29, 260498},--熔火征服者的护胫
    -- {30, 260506},--熔火保卫者的护胫
    --             },
    --             ExtraList = true
    --         },
    -- {
    --     [NORMAL_DIFF] = {{1, 255033}, {2, 255018}, {3, 255022}, {4, 255042}, {5, 255043}, {6, 255065},
    --                        {7, 255052}, {8, 255072}, {9, 16864}, {12, 17011}, {13, 17010}, {14, 11382}, {15, 17012},
    --                        {16, 255034}, {17, 255015}, {18, 255020}, {19, 257609}, {20, 255045}, {21, 255064},
    --                        {22, 255054}, {23, 255071}, {24, 257602}},
    --     name = "小怪",
    --     ExtraList = true
    -- },
    {
        name = AL["Fire Resistance Gears"],
        [NORMAL_DIFF] = {{1, 262915}, {2, 262916}, {3, 262919}, {4, 262920}, {5, 262921}, {6, 262922}, {7, 262924},
                         {8, 262925}, {9, 262926}, {10, 262927}, {11, 262931}, {12, 262932}, {13, 262933}, {14, 262934},
                         {15, 262935}, {16, 262937}, {17, 262939}, {18, 262940}, {19, 262941}, {20, 262942},
                         {21, 262943}, {22, 262944}, {23, 262945}, {24, 262946}, {25, 262947}, {26, 262948},
                         {27, 262949}, {28, 262950}, {29, 262952}, {30, 262953}, {101, 262954}, {102, 262955},
                         {103, 262956}, {104, 262958}, {105, 262959}, {106, 262960}, {107, 262961}, {108, 262968},
                         {109, 262969}, {110, 262971}, {111, 262972}, {112, 262974}, {113, 262975}, {114, 262976},
                         {115, 262977}, {116, 262978}, {117, 262979}, {118, 262980}, {119, 262981}, {120, 262985},
                         {121, 262986}, {122, 262987}, {123, 262988}, {124, 262993}, {125, 262995}, {126, 262996},
                         {127, 262997}, {128, 262998}, {129, 263000}, {130, 263001}, {201, 263002}, {202, 263003},
                         {203, 263004}, {204, 263008}},
        ExtraList = true
    }, {
        name = AL["Faction Rings"],
        [NORMAL_DIFF] = {{1, 255105}, {2, 255106}, {3, 263276}, {4, 263277}},
        ExtraList = true
    }, 
    -- {
    --     name ="PPP",
    --     [NORMAL_DIFF]={
    --         {1,255107},{2,255102},{3,255108},{4,255112},{5,255113},{6,256035},{7,256054},{8,256069},{9,256056},{10,256068},{11,256070},{12,256052},{13,256141},{14,256396},{15,257606},
    --     }
    -- },

    -- {
    --     name="aaa",
    --     [NORMAL_DIFF]={
    --         {1,258417},{2,258424},{3,258420},{4,258883},{5,259908},{6,260344},{7,260346},{8,260710},{9,260781},{10,260831},{11,263201},{12,263200},{13,263199},{14,263204},{15,263207},{16,263264},{17,263514},{18,264161},{19,264167},{20,264198},{21,264272},{22,264359},{23,264358},{24,264437},{25,264441},{26,264440},{27,264438},{28,264445},{29,264446},{30,264442},{101,264439},{102,264443},{103,264444},{104,264731},{105,264751},{106,264753},{107,264749},{108,264761},{109,264746},{110,264741},{111,264754},{112,264748},{113,264756},{114,264757},{115,264763},{116,264752},{117,264759},{118,264742},{119,264762},{120,264745},{121,264750},{122,264755},{123,264758},{124,264744},{125,264760},{126,264747},{127,264743},{128,264784},{129,264781},{130,264764},{201,264767},{202,264778},{203,264776},{204,264789},{205,264775},{206,264772},{207,264782},{208,264770},{209,264786},{210,264769},{211,264779},{212,264771},{213,264766},{214,264773},{215,264783},{216,264765},{217,264774},{218,264785},{219,264787},{220,264777},{221,264788},{222,264768},{223,264780},{224,264936},{225,264928},{226,264929},{227,264932},{228,264933},{229,264930},{230,264934},{301,264926},{302,264935},{303,264931},{304,264927},{305,264937},{306,264986},{307,265028},{308,265029},{309,265036},{310,265070},{311,265069},{312,265333},{313,265353},{314,265350},{315,265347},{316,265335},{317,265345},{318,265349},{319,265344},{320,265356},{321,265342},{322,265352},{323,265351},{324,265343},{325,265340},{326,265354},{327,265346},{328,265355},{329,265348},{330,265492},{401,265516},{402,265514},{403,265526},{404,265518},{405,265524},{406,265523},{407,265519},{408,265515},{409,265521},{410,265517},{411,265522},{412,265520},{413,265563},{414,265570},{415,265565},{416,265569},{417,265566},{418,265568},{419,265567},{420,265564},{421,265841},{422,265933},{423,265940},{424,265941},{425,265937},{426,265939},{427,265944},{428,265942},{429,267402},
    --     }
    -- },
    --  {
    --     name="bbb",
    --     [NORMAL_DIFF]={
    --         {1,268295},{2,268706},{3,268836},{4,268839},{5,268835},{6,268838},{7,268837},{8,268861},{9,268862},{10,268863},{11,268864},{12,268865},{13,268866},{14,268867},{15,268868},{16,268869},{17,268848},{18,268841},{19,268840},{20,268843},{21,268847},{22,268844},{23,268842},{24,268857},{25,268846},{26,268849},{27,268858},{28,268855},{29,268851},{30,268852},{101,268850},{102,268856},{103,268860},{104,268859},{105,268845},{106,268853},{107,268854},{108,268922},{109,268924},{110,268925},{111,268926},{112,268923},

    --     }
    -- },
    --  {
    --     name="ccc",
    --     [NORMAL_DIFF]={
    --         {1,200060},{2,200068},{3,200238},{4,200239},{5,200235},{6,200240},{7,201699},{8,201993},{9,202195},{10,202269},{11,204385},{12,204982},{13,206272},{14,206392},{15,206580},{16,206689},{17,206687},{18,206685},{19,206684},{20,206688},{21,206686},{22,206703},{23,206711},{24,206707},{25,206713},{26,206706},{27,206690},{28,206712},{29,206701},{30,206705},{101,206709},{102,206702},{103,206716},{104,206694},{105,206715},{106,206718},{107,206692},{108,206693},{109,206698},{110,206719},{111,206697},{112,206704},{113,206691},{114,206708},{115,206710},{116,206717},{117,206714},{118,206700},{119,206699},{120,206728},{121,206737},{122,206733},{123,206729},{124,206736},{125,206724},{126,206732},{127,206723},{128,206731},{129,206743},{130,206742},{201,206720},{202,206722},{203,206746},{204,206739},{205,206721},{206,206735},{207,206734},{208,206726},{209,206725},{210,206748},{211,206744},{212,206727},{213,206747},{214,206730},{215,206741},{216,206740},{217,206738},{218,206745},{219,206751},{220,206756},{221,206753},{222,206757},{223,206755},{224,206759},{225,206752},{226,206754},{227,206750},{228,206953},{229,207097},{230,208157},{301,209515},{302,209516},{303,209517},{304,209518},{305,209519},{306,209521},{307,209522},{308,209530},{309,209533},{310,209529},{311,209528},{312,209531},{313,209532},{314,209556},{315,209558},{316,209557},{317,209586},{318,209599},{319,209588},{320,209585},{321,209589},{322,209584},{323,209587},{324,209583},{325,209603},{326,209628},{327,209600},{328,209607},{329,209629},{330,209627},{401,209602},{402,209606},{403,209647},{404,209637},{405,209630},{406,209659},{407,209656},{408,209650},{409,209646},{410,209651},{411,209634},{412,209649},{413,209644},{414,209636},{415,209642},{416,209638},{417,209645},{418,209633},{419,209641},{420,209654},{421,209658},{422,209655},{423,209632},{424,209635},{425,209648},{426,209639},{427,209652},{428,209631},{429,209640},{430,209657},{501,209653},{502,209662},{503,209665},{504,209661},{505,209660},{506,209664},{507,209663},{508,209695},{509,209697},{510,209696},{511,209780},{512,209782},{513,209784},{514,209786},{515,209789},{516,209790},{517,209783},{518,209808},{519,209794},{520,209807},{521,209787},{522,209796},{523,209809},{524,209793},{525,209801},{526,209803},{527,209792},{528,209785},{529,209791},{530,209804},{601,209811},{602,209829},{603,209812},{604,209815},{605,209826},{606,209827},{607,209810},{608,209814},{609,209813},{610,209877},{611,209876},{612,209878},{613,209945},
    --     }
    -- },
    --  {
    --     name="ddd",
    --     [NORMAL_DIFF]={
    --         {1,210046},{2,210047},{3,210135},{4,211082},{5,211206},{6,211207},{7,211262},{8,211261},{9,211817},{10,211851},{11,211850},{12,211844},{13,211847},{14,216696},
    --     }
    -- },
    --  {
    --     name="eee",
    --     [NORMAL_DIFF]={
    --         {1,224002},{2,224378},{3,224375},{4,224379},{5,224377},{6,224376},{7,224383},{8,224380},{9,224381},{10,224382},{11,225921},{12,225926},{13,225924},{14,225923},{15,225922},{16,225925},{17,226805},{18,226812},{19,230769},{20,230757},{21,230759},{22,230756},{23,230761},{24,230758},{25,230767},{26,230766},{27,230755},{28,230768},{29,230763},{30,230765},{101,231312},{102,232614},{103,235404},{104,235464},{105,235562},{106,235561},{107,237044},{108,237052},{109,237066},{110,237061},{111,237059},{112,237050},{113,237054},{114,237063},{115,237069},{116,237056},{117,237065},{118,237064},{119,237045},{120,237042},{121,237067},{122,237046},{123,237047},{124,237051},{125,237060},{126,237048},{127,237062},{128,237068},{129,237049},{130,237055},{201,237043},{202,237053},{203,237077},{204,237086},{205,237091},{206,237071},{207,237088},{208,237083},{209,237079},{210,237073},{211,237080},{212,237089},{213,237092},{214,237070},{215,237085},{216,237082},{217,237075},{218,237078},{219,237087},{220,237093},{221,237090},{222,237084},{223,237076},{224,237072},{225,237074},{226,237081},{227,238343},{228,238340},{229,238341},{230,238339},{301,238342},{302,242551},{303,242550},{304,245584},{305,245613},{306,245612},{307,246901},{308,247893},{309,248263},{310,248398},{311,248754},{312,248753},{313,248946},{314,248949},{315,248947},{316,248945},{317,248948},{318,248950},{319,249819},{320,249821},{321,249820},
    -- }}
          --

    -- {
    --     name = AL["Data Mining"],
    --     [NORMAL_DIFF] = {{1, 200060}, {2, 200068}, {3, 200235}, {4, 200240}, {5, 201699}, {6, 201993}, {7, 202195},
    --                      {8, 204385}, {9, 204982}, {10, 206272}, {11, 206392}, {12, 206580}, {13, 206684}, {14, 206685},
    --                      {15, 206686}, {16, 206687}, {17, 206691}, {18, 206692}, {19, 206693}, {20, 206694},
    --                      {21, 206697}, {22, 206699}, {23, 206700}, {24, 206701}, {25, 206702}, {26, 206703},
    --                      {27, 206704}, {28, 206705}, {29, 206706}, {30, 206717}, {101, 206726}, {102, 206730},
    --                      {103, 206731}, {104, 206732}, {105, 206733}, {106, 206734}, {107, 206735}, {108, 206736},
    --                      {109, 206737}, {110, 206738}, {111, 206739}, {112, 206740}, {113, 206741}, {114, 206742},
    --                      {115, 206743}, {116, 206744}, {117, 206745}, {118, 206746}, {119, 206747}, {120, 206748},
    --                      {121, 206750}, {122, 206751}, {123, 206752}, {124, 206753}, {125, 206754}, {126, 206755},
    --                      {127, 206756}, {128, 206757}, {129, 206759}, {130, 206953}, {201, 207097}, {202, 208157},
    --                      {203, 209515}, {204, 209558}, {205, 209585}, {206, 209587}, {207, 209588}, {208, 209589},
    --                      {209, 209603}, {210, 209627}, {211, 209629}, {212, 209630}, {213, 209631}, {214, 209633},
    --                      {215, 209635}, {216, 209636}, {217, 209639}, {218, 209641}, {219, 209642}, {220, 209644},
    --                      {221, 209648}, {222, 209649}, {223, 209650}, {224, 209652}, {225, 209654}, {226, 209655},
    --                      {227, 209660}, {228, 209661}, {229, 209662}, {230, 209663}, {301, 209664}, {302, 209665},
    --                      {303, 209695}, {304, 209696}, {305, 209697}, {306, 209780}, {307, 209782}, {308, 209783},
    --                      {309, 209784}, {310, 209785}, {311, 209786}, {312, 209787}, {313, 209789}, {314, 209790},
    --                      {315, 209791}, {316, 209792}, {317, 209793}, {318, 209794}, {319, 209796}, {320, 209801},
    --                      {321, 209803}, {322, 209804}, {323, 209807}, {324, 209808}, {325, 209809}, {326, 209810},
    --                      {327, 209811}, {328, 209812}, {329, 209813}, {330, 209814}, {401, 209815}, {402, 209826},
    --                      {403, 209827}, {404, 209829}, {405, 209876}, {406, 209877}, {407, 209945}, {408, 210047},
    --                      {409, 210135}, {410, 211082}, {411, 211206}, {412, 211207}, {413, 211261}, {414, 211262},
    --                      {415, 216696}, {416, 224002}, {417, 224375}, {418, 224376}, {419, 224377}, {420, 224378},
    --                      {421, 224379}, {422, 224380}, {423, 224381}, {424, 224382}, {425, 224383}, {426, 226805},
    --                      {427, 226812}, {428, 231312}, {429, 232614}, {430, 235464}, {501, 235561}, {502, 235562},
    --                      {503, 238339}, {504, 238340}, {505, 238341}, {506, 238342}, {507, 238343}, {508, 242551},
    --                      {509, 245584}, {510, 245612}, {511, 245613}, {512, 246901}, {513, 247893}, {514, 248263},
    --                      {515, 248398}, {516, 248753}, {517, 248754}, {518, 248945}, {519, 248946}, {520, 248947},
    --                      {521, 248948}, {522, 248949}, {523, 248950}, {524, 256035}, {525, 256052}, {526, 256054},
    --                      {527, 256056}, {528, 256068}, {529, 256069}, {530, 256070}, {601, 256396}, {602, 258417},
    --                      {603, 258420}, {604, 258424}, {605, 258883}, {606, 260831}, {607, 263199}, {608, 263200},
    --                      {609, 263201}, {610, 263204}, {611, 263207}, {612, 263514}, {613, 264161}, {614, 264167},
    --                      {615, 264198}, {616, 264272}, {617, 264358}, {618, 264359}, {619, 264986}, {620, 265028},
    --                      {621, 265029}, {622, 265036}, {623, 265342}, {624, 265343}, {625, 265344}, {626, 265345},
    --                      {627, 265346}, {628, 265347}, {629, 265348}, {630, 265349}, {701, 265350}, {702, 265351},
    --                      {703, 265352}, {704, 265353}, {705, 265354}, {706, 265355}, {707, 265356}, {708, 265933},
    --                      {709, 265937}, {710, 265939}, {711, 265940}, {712, 265942}, {713, 265944}},
    --     ExtraList = true
    -- }
}
}

data["WorldBosses81"] = {
    name = AL["P1 World bosses of Vanilla"],
	AtlasMapFile = "Azuregos",
	ContentType = RAID_CONTENT,
	items = {
		{ -- AAzuregos
			name = AL["Azuregos"],
			AtlasMapFile = "Azuregos",
			npcID = 6109,
			Level = 999,
			ContentPhase = 2,
			DisplayIDs = {{11460}},
			AtlasMapBossID = 1,
			[NORMAL_DIFF] = {
				{ 1,  19132 }, -- Crystal Adorned Crown
				{ 2,  18208 }, -- Drape of Benediction
				{ 3,  18541 }, -- Puissant Cape
				{ 4,  18547 }, -- Unmelting Ice Girdle
				{ 5,  18545 }, -- Leggings of Arcane Supremacy
				{ 6,  19131 }, -- Snowblind Shoes
				{ 7,  19130 }, -- Cold Snap
				{ 8,  17070 }, -- Fang of the Mystics
				{ 9,  18202 }, -- Eskhandar's Left Claw
				{ 10, 18542 }, -- Typhoon
				{ 16, 260781 }, -- Mature Blue Dragon Sinew
				{ 18, 11938 }, -- Sack of Gems
                { 20, 260493},--熔火胜利者的护肩
                { 21, 260502},--熔火征服者的护肩
                { 22, 260505},--熔火保卫者的护肩
                { 24, 260494},--熔火胜利者的腰带
                { 25, 260503},--熔火征服者的腰带
                { 26, 260512},--熔火保卫者的腰带
				-- Hidden items
				{ 0, 17962 }, -- Blue Sack of Gems
				{ 0, 17963 }, -- Green Sack of Gems
				{ 0, 17964 }, -- Gray Sack of Gems
				{ 0, 17965 }, -- Yellow Sack of Gems
				{ 0, 17969 }, -- Red Sack of Gems
			},
		},
		{ -- KKazzak
			name = AL["Lord Kazzak"],
			AtlasMapFile = "LordKazzak",
			npcID = 12397,
			Level = 999,
			ContentPhase = 2,
			DisplayIDs = {{12449}},
			AtlasMapBossID = 1,
			[NORMAL_DIFF] = {
				{ 1,  18546 }, -- Infernal Headcage
				{ 2,  17111 }, -- Blazefury Medallion
				{ 3,  18204 }, -- Eskhandar's Pelt
				{ 4,  19135 }, -- Blacklight Bracer
				{ 5,  18544 }, -- Doomhide Gauntlets
				{ 6,  19134 }, -- Flayed Doomguard Belt
				{ 7,  19133 }, -- Fel Infused Leggings
				{ 8,  18543 }, -- Ring of Entropy
				{ 9,  17112 }, -- Empyrean Demolisher
				{ 10, 17113 }, -- Amberseal Keeper
				{ 16, 260831 }, -- The Eye of Shadow
				{ 18, 11938 }, -- Sack of Gems
                { 20, 260491},--熔火胜利者的战盔
                { 21, 260500},--熔火征服者的战盔
                { 22, 260510},--熔火保卫者的战盔
                { 24, 260495},--熔火胜利者的护腕
                { 25, 260504},--熔火征服者的护腕
                { 26, 260511},--熔火保卫者的护腕
				-- Hidden items
				{ 0, 17962 }, -- Blue Sack of Gems
				{ 0, 17963 }, -- Green Sack of Gems
				{ 0, 17964 }, -- Gray Sack of Gems
				{ 0, 17965 }, -- Yellow Sack of Gems
				{ 0, 17969 }, -- Red Sack of Gems
			},
		},
    }
}
local ROLE_DD = AL["Damage Dealer"]
data["VaultofArchavon"] = {
	MapID = 4603,
    name = AL["PhaseAll Vault of Archavon"],
	InstanceID = 624,
    ContentType = RAID_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "VaultOfArchavon",
	AtlasMapFile = {"VaultOfArchavon"},
	-- LevelRange = {80, 80, 80},
	items = {
        { -- VaultofArchavonArchavon
            name = AL["Archavon the Stone Watcher"],
            npcID = 31125,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapBossID = 1,
            [P1_DIFF] = {
                { 1, "CLASS_WARLOCK",       nil, CLASS_NAME["WARLOCK"],     nil,                "VoA_A_WARLOCK_10" },
                { 3, "CLASS_PRIEST",        nil, CLASS_NAME["PRIEST"],      AL["Holy"],         "VoA_A_PRIEST_10_H" },
                { 4, "CLASS_PRIEST",        nil, CLASS_NAME["PRIEST"],      AL["Shadow"],       "VoA_A_PRIEST_10_D" },
                { 6, "CLASS_ROGUE",         nil, CLASS_NAME["ROGUE"],       nil,                "VoA_A_ROGUE_10" },
                { 8, "CLASS_HUNTER",        nil, CLASS_NAME["HUNTER"],      nil,                "VoA_A_HUNTER_10" },
                { 10, "CLASS_WARRIOR",      nil, CLASS_NAME["WARRIOR"],     AL["Protection"],   "VoA_A_WARRIOR_10_T" },
                { 11, "CLASS_WARRIOR",      nil, CLASS_NAME["WARRIOR"],     ROLE_DD,            "VoA_A_WARRIOR_10_D" },
                { 13, "CLASS_DEATHKNIGHT",  nil, CLASS_NAME["DEATHKNIGHT"], AL["Blood"],        "VoA_A_DEATHKNIGHT_10_T" },
                { 14, "CLASS_DEATHKNIGHT",  nil, CLASS_NAME["DEATHKNIGHT"], ROLE_DD,            "VoA_A_DEATHKNIGHT_10_D" },
                { 16, "CLASS_MAGE",         nil, CLASS_NAME["MAGE"],        nil,                "VoA_A_MAGE_10" },
                { 18, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Restoration"],  "VoA_A_DRUID_10_H" },
                { 19, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Balance"],      "VoA_A_DRUID_10_DR" },
                { 20, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Feral"],        "VoA_A_DRUID_10_D" },
                { 22, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Restoration"],  "VoA_A_SHAMAN_10_H" },
                { 23, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Elemental"],    "VoA_A_SHAMAN_10_DR" },
                { 24, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Enhancement"],  "VoA_A_SHAMAN_10_D" },
                { 26, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Protection"],   "VoA_A_PALADIN_10_T" },
                { 27, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Holy"],         "VoA_A_PALADIN_10_H" },
                { 28, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Retribution"],  "VoA_A_PALADIN_10_D" },
            },
            -- [RAID25_DIFF] = {
            --     { 1, "CLASS_WARLOCK",       nil, CLASS_NAME["WARLOCK"],     nil,                "VoA_A_WARLOCK_25" },
            --     { 3, "CLASS_PRIEST",        nil, CLASS_NAME["PRIEST"],      AL["Holy"],         "VoA_A_PRIEST_25_H" },
            --     { 4, "CLASS_PRIEST",        nil, CLASS_NAME["PRIEST"],      AL["Shadow"],       "VoA_A_PRIEST_25_D" },
            --     { 6, "CLASS_ROGUE",         nil, CLASS_NAME["ROGUE"],       nil,                "VoA_A_ROGUE_25" },
            --     { 8, "CLASS_HUNTER",        nil, CLASS_NAME["HUNTER"],      nil,                "VoA_A_HUNTER_25" },
            --     { 10, "CLASS_WARRIOR",      nil, CLASS_NAME["WARRIOR"],     AL["Protection"],   "VoA_A_WARRIOR_25_T" },
            --     { 11, "CLASS_WARRIOR",      nil, CLASS_NAME["WARRIOR"],     ROLE_DD,            "VoA_A_WARRIOR_25_D" },
            --     { 13, "CLASS_DEATHKNIGHT",  nil, CLASS_NAME["DEATHKNIGHT"], AL["Blood"],        "VoA_A_DEATHKNIGHT_25_T" },
            --     { 14, "CLASS_DEATHKNIGHT",  nil, CLASS_NAME["DEATHKNIGHT"], ROLE_DD,            "VoA_A_DEATHKNIGHT_25_D" },
            --     { 16, "CLASS_MAGE",         nil, CLASS_NAME["MAGE"],        nil,                "VoA_A_MAGE_25" },
            --     { 18, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Restoration"],  "VoA_A_DRUID_25_H" },
            --     { 19, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Balance"],      "VoA_A_DRUID_25_DR" },
            --     { 20, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Feral"],        "VoA_A_DRUID_25_D" },
            --     { 22, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Restoration"],  "VoA_A_SHAMAN_25_H" },
            --     { 23, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Elemental"],    "VoA_A_SHAMAN_25_DR" },
            --     { 24, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Enhancement"],  "VoA_A_SHAMAN_25_D" },
            --     { 26, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Protection"],   "VoA_A_PALADIN_25_T" },
            --     { 27, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Holy"],         "VoA_A_PALADIN_25_H" },
            --     { 28, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Retribution"],  "VoA_A_PALADIN_25_D" },
            -- }
        },
        -- { -- VaultofArchavonEmalon
        --     name = AL["Emalon the Storm Watcher"],
        --     npcID = 33993,
        --     Level = 999,
        --     --DisplayIDs = {{17386}},
        --     AtlasMapBossID = 2,
        --     [RAID10_DIFF] = {
        --         { 1, "CLASS_WARLOCK",       nil, CLASS_NAME["WARLOCK"],     nil,                "VoA_E_WARLOCK_10" },
        --         { 3, "CLASS_PRIEST",        nil, CLASS_NAME["PRIEST"],      AL["Holy"],         "VoA_E_PRIEST_10_H" },
        --         { 4, "CLASS_PRIEST",        nil, CLASS_NAME["PRIEST"],      AL["Shadow"],       "VoA_E_PRIEST_10_D" },
        --         { 6, "CLASS_ROGUE",         nil, CLASS_NAME["ROGUE"],       nil,                "VoA_E_ROGUE_10" },
        --         { 8, "CLASS_HUNTER",        nil, CLASS_NAME["HUNTER"],      nil,                "VoA_E_HUNTER_10" },
        --         { 10, "CLASS_WARRIOR",      nil, CLASS_NAME["WARRIOR"],     AL["Protection"],   "VoA_E_WARRIOR_10_T" },
        --         { 11, "CLASS_WARRIOR",      nil, CLASS_NAME["WARRIOR"],     ROLE_DD,            "VoA_E_WARRIOR_10_D" },
        --         { 13, "CLASS_DEATHKNIGHT",  nil, CLASS_NAME["DEATHKNIGHT"], AL["Blood"],        "VoA_E_DEATHKNIGHT_10_T" },
        --         { 14, "CLASS_DEATHKNIGHT",  nil, CLASS_NAME["DEATHKNIGHT"], ROLE_DD,            "VoA_E_DEATHKNIGHT_10_D" },
        --         { 16, "CLASS_MAGE",         nil, CLASS_NAME["MAGE"],        nil,                "VoA_E_MAGE_10" },
        --         { 18, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Restoration"],  "VoA_E_DRUID_10_H" },
        --         { 19, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Balance"],      "VoA_E_DRUID_10_DR" },
        --         { 20, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Feral"],        "VoA_E_DRUID_10_D" },
        --         { 22, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Restoration"],  "VoA_E_SHAMAN_10_H" },
        --         { 23, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Elemental"],    "VoA_E_SHAMAN_10_DR" },
        --         { 24, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Enhancement"],  "VoA_E_SHAMAN_10_D" },
        --         { 26, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Protection"],   "VoA_E_PALADIN_10_T" },
        --         { 27, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Holy"],         "VoA_E_PALADIN_10_H" },
        --         { 28, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Retribution"],  "VoA_E_PALADIN_10_D" },
        --     },
        --     [RAID25_DIFF] = {
        --         { 1, "CLASS_WARLOCK",       nil, CLASS_NAME["WARLOCK"],     nil,                "VoA_E_WARLOCK_25" },
        --         { 3, "CLASS_PRIEST",        nil, CLASS_NAME["PRIEST"],      AL["Holy"],         "VoA_E_PRIEST_25_H" },
        --         { 4, "CLASS_PRIEST",        nil, CLASS_NAME["PRIEST"],      AL["Shadow"],       "VoA_E_PRIEST_25_D" },
        --         { 6, "CLASS_ROGUE",         nil, CLASS_NAME["ROGUE"],       nil,                "VoA_E_ROGUE_25" },
        --         { 8, "CLASS_HUNTER",        nil, CLASS_NAME["HUNTER"],      nil,                "VoA_E_HUNTER_25" },
        --         { 10, "CLASS_WARRIOR",      nil, CLASS_NAME["WARRIOR"],     AL["Protection"],   "VoA_E_WARRIOR_25_T" },
        --         { 11, "CLASS_WARRIOR",      nil, CLASS_NAME["WARRIOR"],     ROLE_DD,            "VoA_E_WARRIOR_25_D" },
        --         { 13, "CLASS_DEATHKNIGHT",  nil, CLASS_NAME["DEATHKNIGHT"], AL["Blood"],        "VoA_E_DEATHKNIGHT_25_T" },
        --         { 14, "CLASS_DEATHKNIGHT",  nil, CLASS_NAME["DEATHKNIGHT"], ROLE_DD,            "VoA_E_DEATHKNIGHT_25_D" },
        --         { 16, "CLASS_MAGE",         nil, CLASS_NAME["MAGE"],        nil,                "VoA_E_MAGE_25" },
        --         { 18, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Restoration"],  "VoA_E_DRUID_25_H" },
        --         { 19, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Balance"],      "VoA_E_DRUID_25_DR" },
        --         { 20, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Feral"],        "VoA_E_DRUID_25_D" },
        --         { 22, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Restoration"],  "VoA_E_SHAMAN_25_H" },
        --         { 23, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Elemental"],    "VoA_E_SHAMAN_25_DR" },
        --         { 24, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Enhancement"],  "VoA_E_SHAMAN_25_D" },
        --         { 26, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Protection"],   "VoA_E_PALADIN_25_T" },
        --         { 27, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Holy"],         "VoA_E_PALADIN_25_H" },
        --         { 28, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Retribution"],  "VoA_E_PALADIN_25_D" },
        --     }
        -- },
        -- { -- VaultofArchavonKoralon_Alliance
        --     name = AL["Koralon the Flame Watcher"],
        --     npcID = 35013,
        --     Level = 999,
        --     --DisplayIDs = {{17386}},
        --     AtlasMapBossID = 3,
        --     [RAID10_DIFF] = {
        --         { 1, "CLASS_WARLOCK",       nil, CLASS_NAME["WARLOCK"],     nil,                AtlasLoot:GetRetByFaction("VoA_KH_WARLOCK_10", "VoA_KA_WARLOCK_10") },
        --         { 3, "CLASS_PRIEST",        nil, CLASS_NAME["PRIEST"],      AL["Holy"],         AtlasLoot:GetRetByFaction("VoA_KH_PRIEST_10_H", "VoA_KA_PRIEST_10_H") },
        --         { 4, "CLASS_PRIEST",        nil, CLASS_NAME["PRIEST"],      AL["Shadow"],       AtlasLoot:GetRetByFaction("VoA_KH_PRIEST_10_D", "VoA_KA_PRIEST_10_D") },
        --         { 6, "CLASS_ROGUE",         nil, CLASS_NAME["ROGUE"],       nil,                AtlasLoot:GetRetByFaction("VoA_KH_ROGUE_10", "VoA_KA_ROGUE_10") },
        --         { 8, "CLASS_HUNTER",        nil, CLASS_NAME["HUNTER"],      nil,                AtlasLoot:GetRetByFaction("VoA_KH_HUNTER_10", "VoA_KA_HUNTER_10") },
        --         { 10, "CLASS_WARRIOR",      nil, CLASS_NAME["WARRIOR"],     AL["Protection"],   AtlasLoot:GetRetByFaction("VoA_KH_WARRIOR_10_T", "VoA_KA_WARRIOR_10_T") },
        --         { 11, "CLASS_WARRIOR",      nil, CLASS_NAME["WARRIOR"],     ROLE_DD,            AtlasLoot:GetRetByFaction("VoA_KH_WARRIOR_10_D", "VoA_KA_WARRIOR_10_D") },
        --         { 13, "CLASS_DEATHKNIGHT",  nil, CLASS_NAME["DEATHKNIGHT"], AL["Blood"],        AtlasLoot:GetRetByFaction("VoA_KH_DEATHKNIGHT_10_T", "VoA_KA_DEATHKNIGHT_10_T") },
        --         { 14, "CLASS_DEATHKNIGHT",  nil, CLASS_NAME["DEATHKNIGHT"], ROLE_DD,            AtlasLoot:GetRetByFaction("VoA_KH_DEATHKNIGHT_10_D", "VoA_KA_DEATHKNIGHT_10_D") },
        --         { 16, "CLASS_MAGE",         nil, CLASS_NAME["MAGE"],        nil,                AtlasLoot:GetRetByFaction("VoA_KH_MAGE_10", "VoA_KA_MAGE_10") },
        --         { 18, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Restoration"],  AtlasLoot:GetRetByFaction("VoA_KH_DRUID_10_H", "VoA_KA_DRUID_10_H") },
        --         { 19, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Balance"],      AtlasLoot:GetRetByFaction("VoA_KH_DRUID_10_DR", "VoA_KA_DRUID_10_DR") },
        --         { 20, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Feral"],        AtlasLoot:GetRetByFaction("VoA_KH_DRUID_10_D", "VoA_KA_DRUID_10_D") },
        --         { 22, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Restoration"],  AtlasLoot:GetRetByFaction("VoA_KH_SHAMAN_10_H", "VoA_KA_SHAMAN_10_H") },
        --         { 23, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Elemental"],    AtlasLoot:GetRetByFaction("VoA_KH_SHAMAN_10_DR", "VoA_KA_SHAMAN_10_DR") },
        --         { 24, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Enhancement"],  AtlasLoot:GetRetByFaction("VoA_KH_SHAMAN_10_D", "VoA_KA_SHAMAN_10_D") },
        --         { 26, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Protection"],   AtlasLoot:GetRetByFaction("VoA_KH_PALADIN_10_T", "VoA_KA_PALADIN_10_T") },
        --         { 27, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Holy"],         AtlasLoot:GetRetByFaction("VoA_KH_PALADIN_10_H", "VoA_KA_PALADIN_10_H") },
        --         { 28, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Retribution"],  AtlasLoot:GetRetByFaction("VoA_KH_PALADIN_10_D", "VoA_KA_PALADIN_10_D") },
        --         { 101, "SLOT_CLOTH",        nil, ALIL["Cloth"],         nil,  "VoA_K_CLOTH_10" },
        --         { 102, "SLOT_LEATHER",      nil, ALIL["Leather"],       nil,  "VoA_K_LEATHER_10" },
        --         { 103, "SLOT_MAIL",         nil, ALIL["Mail"],          nil,  "VoA_K_MAIL_10" },
        --         { 104, "SLOT_PLATE",        nil, ALIL["Plate"],         nil,  "VoA_K_PLATE_10" },
        --         { 106, "SLOT_BACK",         nil, ALIL["Back"],          nil,  "VoA_K_BACK_10" },
        --         { 107, "SLOT_NECK",         nil, ALIL["Neck"],          nil,  "VoA_K_NECK_10" },
        --         { 108, "SLOT_FINGER",       nil, ALIL["Finger"],        nil,  "VoA_K_FINGER_10" },
        --         { 116, AtlasLoot:GetRetByFaction(44083, 43959 ) }, -- Reins of the Grand Black War Mammoth
        --     },
        --     [RAID25_DIFF] = {
        --         { 1, "CLASS_WARLOCK",       nil, CLASS_NAME["WARLOCK"],     nil,                AtlasLoot:GetRetByFaction("VoA_KH_WARLOCK_25", "VoA_KA_WARLOCK_25") },
        --         { 3, "CLASS_PRIEST",        nil, CLASS_NAME["PRIEST"],      AL["Holy"],         AtlasLoot:GetRetByFaction("VoA_KH_PRIEST_25_H", "VoA_KA_PRIEST_25_H") },
        --         { 4, "CLASS_PRIEST",        nil, CLASS_NAME["PRIEST"],      AL["Shadow"],       AtlasLoot:GetRetByFaction("VoA_KH_PRIEST_25_D", "VoA_KA_PRIEST_25_D") },
        --         { 6, "CLASS_ROGUE",         nil, CLASS_NAME["ROGUE"],       nil,                AtlasLoot:GetRetByFaction("VoA_KH_ROGUE_25", "VoA_KA_ROGUE_25") },
        --         { 8, "CLASS_HUNTER",        nil, CLASS_NAME["HUNTER"],      nil,                AtlasLoot:GetRetByFaction("VoA_KH_HUNTER_25", "VoA_KA_HUNTER_25") },
        --         { 10, "CLASS_WARRIOR",      nil, CLASS_NAME["WARRIOR"],     AL["Protection"],   AtlasLoot:GetRetByFaction("VoA_KH_WARRIOR_25_T", "VoA_KA_WARRIOR_25_T") },
        --         { 11, "CLASS_WARRIOR",      nil, CLASS_NAME["WARRIOR"],     ROLE_DD,            AtlasLoot:GetRetByFaction("VoA_KH_WARRIOR_25_D", "VoA_KA_WARRIOR_25_D") },
        --         { 13, "CLASS_DEATHKNIGHT",  nil, CLASS_NAME["DEATHKNIGHT"], AL["Blood"],        AtlasLoot:GetRetByFaction("VoA_KH_DEATHKNIGHT_25_T", "VoA_KA_DEATHKNIGHT_25_T") },
        --         { 14, "CLASS_DEATHKNIGHT",  nil, CLASS_NAME["DEATHKNIGHT"], ROLE_DD,            AtlasLoot:GetRetByFaction("VoA_KH_DEATHKNIGHT_25_D", "VoA_KA_DEATHKNIGHT_25_D") },
        --         { 16, "CLASS_MAGE",         nil, CLASS_NAME["MAGE"],        nil,                AtlasLoot:GetRetByFaction("VoA_KH_MAGE_25", "VoA_KA_MAGE_25") },
        --         { 18, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Restoration"],  AtlasLoot:GetRetByFaction("VoA_KH_DRUID_25_H", "VoA_KA_DRUID_25_H") },
        --         { 19, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Balance"],      AtlasLoot:GetRetByFaction("VoA_KH_DRUID_25_DR", "VoA_KA_DRUID_25_DR") },
        --         { 20, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Feral"],        AtlasLoot:GetRetByFaction("VoA_KH_DRUID_25_D", "VoA_KA_DRUID_25_D") },
        --         { 22, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Restoration"],  AtlasLoot:GetRetByFaction("VoA_KH_SHAMAN_25_H", "VoA_KA_SHAMAN_25_H") },
        --         { 23, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Elemental"],    AtlasLoot:GetRetByFaction("VoA_KH_SHAMAN_25_DR", "VoA_KA_SHAMAN_25_DR") },
        --         { 24, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Enhancement"],  AtlasLoot:GetRetByFaction("VoA_KH_SHAMAN_25_D", "VoA_KA_SHAMAN_25_D") },
        --         { 26, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Protection"],   AtlasLoot:GetRetByFaction("VoA_KH_PALADIN_25_T", "VoA_KA_PALADIN_25_T") },
        --         { 27, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Holy"],         AtlasLoot:GetRetByFaction("VoA_KH_PALADIN_25_H", "VoA_KA_PALADIN_25_H") },
        --         { 28, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Retribution"],  AtlasLoot:GetRetByFaction("VoA_KH_PALADIN_25_D", "VoA_KA_PALADIN_25_D") },
        --         { 101, "SLOT_CLOTH",        nil, ALIL["Cloth"],         nil,  "VoA_K_CLOTH_25" },
        --         { 102, "SLOT_LEATHER",      nil, ALIL["Leather"],       nil,  "VoA_K_LEATHER_25" },
        --         { 103, "SLOT_MAIL",         nil, ALIL["Mail"],          nil,  "VoA_K_MAIL_25" },
        --         { 104, "SLOT_PLATE",        nil, ALIL["Plate"],         nil,  "VoA_K_PLATE_25" },
        --         { 106, "SLOT_BACK",         nil, ALIL["Back"],          nil,  "VoA_K_BACK_25" },
        --         { 107, "SLOT_NECK",         nil, ALIL["Neck"],          nil,  "VoA_K_NECK_25" },
        --         { 108, "SLOT_FINGER",       nil, ALIL["Finger"],        nil,  "VoA_K_FINGER_25" },
        --         { 116, AtlasLoot:GetRetByFaction(44083, 43959 ) }, -- Reins of the Grand Black War Mammoth
        --     }
        -- },
        -- { -- VaultofArchavonEmalon
        --     name = AL["Toravon the Ice Watcher"],
        --     npcID = 38433,
        --     Level = 999,
        --     --DisplayIDs = {{17386}},
        --     AtlasMapBossID = 4,
        --     [RAID10_DIFF] = {
        --         { 1, "CLASS_WARLOCK",       nil, CLASS_NAME["WARLOCK"],     nil,                "VoA_T_WARLOCK_10" },
        --         { 3, "CLASS_PRIEST",        nil, CLASS_NAME["PRIEST"],      AL["Holy"],         "VoA_T_PRIEST_10_H" },
        --         { 4, "CLASS_PRIEST",        nil, CLASS_NAME["PRIEST"],      AL["Shadow"],       "VoA_T_PRIEST_10_D" },
        --         { 6, "CLASS_ROGUE",         nil, CLASS_NAME["ROGUE"],       nil,                "VoA_T_ROGUE_10" },
        --         { 8, "CLASS_HUNTER",        nil, CLASS_NAME["HUNTER"],      nil,                "VoA_T_HUNTER_10" },
        --         { 10, "CLASS_WARRIOR",      nil, CLASS_NAME["WARRIOR"],     AL["Protection"],   "VoA_T_WARRIOR_10_T" },
        --         { 11, "CLASS_WARRIOR",      nil, CLASS_NAME["WARRIOR"],     ROLE_DD,            "VoA_T_WARRIOR_10_D" },
        --         { 13, "CLASS_DEATHKNIGHT",  nil, CLASS_NAME["DEATHKNIGHT"], AL["Blood"],        "VoA_T_DEATHKNIGHT_10_T" },
        --         { 14, "CLASS_DEATHKNIGHT",  nil, CLASS_NAME["DEATHKNIGHT"], ROLE_DD,            "VoA_T_DEATHKNIGHT_10_D" },
        --         { 16, "CLASS_MAGE",         nil, CLASS_NAME["MAGE"],        nil,                "VoA_T_MAGE_10" },
        --         { 18, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Restoration"],  "VoA_T_DRUID_10_H" },
        --         { 19, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Balance"],      "VoA_T_DRUID_10_DR" },
        --         { 20, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Feral"],        "VoA_T_DRUID_10_D" },
        --         { 22, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Restoration"],  "VoA_T_SHAMAN_10_H" },
        --         { 23, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Elemental"],    "VoA_T_SHAMAN_10_DR" },
        --         { 24, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Enhancement"],  "VoA_T_SHAMAN_10_D" },
        --         { 26, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Protection"],   "VoA_T_PALADIN_10_T" },
        --         { 27, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Holy"],         "VoA_T_PALADIN_10_H" },
        --         { 28, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Retribution"],  "VoA_T_PALADIN_10_D" },
        --         { 101, "SLOT_CLOTH",        nil, ALIL["Cloth"],         nil,  "VoA_T_CLOTH_10" },
        --         { 102, "SLOT_LEATHER",      nil, ALIL["Leather"],       nil,  "VoA_T_LEATHER_10" },
        --         { 103, "SLOT_MAIL",         nil, ALIL["Mail"],          nil,  "VoA_T_MAIL_10" },
        --         { 104, "SLOT_PLATE",        nil, ALIL["Plate"],         nil,  "VoA_T_PLATE_10" },
        --         { 106, "SLOT_BACK",         nil, ALIL["Back"],          nil,  "VoA_T_BACK_10" },
        --         { 107, "SLOT_NECK",         nil, ALIL["Neck"],          nil,  "VoA_T_NECK_10" },
        --         { 108, "SLOT_FINGER",       nil, ALIL["Finger"],        nil,  "VoA_T_FINGER_10" },
        --         { 116, AtlasLoot:GetRetByFaction(44083, 43959 ) }, -- Reins of the Grand Black War Mammoth
        --     },
        --     [RAID25_DIFF] = {
        --         { 1, "CLASS_WARLOCK",       nil, CLASS_NAME["WARLOCK"],     nil,                "VoA_T_WARLOCK_25" },
        --         { 3, "CLASS_PRIEST",        nil, CLASS_NAME["PRIEST"],      AL["Holy"],         "VoA_T_PRIEST_25_H" },
        --         { 4, "CLASS_PRIEST",        nil, CLASS_NAME["PRIEST"],      AL["Shadow"],       "VoA_T_PRIEST_25_D" },
        --         { 6, "CLASS_ROGUE",         nil, CLASS_NAME["ROGUE"],       nil,                "VoA_T_ROGUE_25" },
        --         { 8, "CLASS_HUNTER",        nil, CLASS_NAME["HUNTER"],      nil,                "VoA_T_HUNTER_25" },
        --         { 10, "CLASS_WARRIOR",      nil, CLASS_NAME["WARRIOR"],     AL["Protection"],   "VoA_T_WARRIOR_25_T" },
        --         { 11, "CLASS_WARRIOR",      nil, CLASS_NAME["WARRIOR"],     ROLE_DD,            "VoA_T_WARRIOR_25_D" },
        --         { 13, "CLASS_DEATHKNIGHT",  nil, CLASS_NAME["DEATHKNIGHT"], AL["Blood"],        "VoA_T_DEATHKNIGHT_25_T" },
        --         { 14, "CLASS_DEATHKNIGHT",  nil, CLASS_NAME["DEATHKNIGHT"], ROLE_DD,            "VoA_T_DEATHKNIGHT_25_D" },
        --         { 16, "CLASS_MAGE",         nil, CLASS_NAME["MAGE"],        nil,                "VoA_T_MAGE_25" },
        --         { 18, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Restoration"],  "VoA_T_DRUID_25_H" },
        --         { 19, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Balance"],      "VoA_T_DRUID_25_DR" },
        --         { 20, "CLASS_DRUID",        nil, CLASS_NAME["DRUID"],       AL["Feral"],        "VoA_T_DRUID_25_D" },
        --         { 22, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Restoration"],  "VoA_T_SHAMAN_25_H" },
        --         { 23, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Elemental"],    "VoA_T_SHAMAN_25_DR" },
        --         { 24, "CLASS_SHAMAN",       nil, CLASS_NAME["SHAMAN"],      AL["Enhancement"],  "VoA_T_SHAMAN_25_D" },
        --         { 26, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Protection"],   "VoA_T_PALADIN_25_T" },
        --         { 27, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Holy"],         "VoA_T_PALADIN_25_H" },
        --         { 28, "CLASS_PALADIN",      nil, CLASS_NAME["PALADIN"],     AL["Retribution"],  "VoA_T_PALADIN_25_D" },
        --         { 101, "SLOT_CLOTH",        nil, ALIL["Cloth"],         nil,  "VoA_T_CLOTH_25" },
        --         { 102, "SLOT_LEATHER",      nil, ALIL["Leather"],       nil,  "VoA_T_LEATHER_25" },
        --         { 103, "SLOT_MAIL4",        nil, ALIL["Mail"],          nil,  "VoA_T_MAIL_25" },
        --         { 104, "SLOT_PLATE",        nil, ALIL["Plate"],         nil,  "VoA_T_PLATE_25" },
        --         { 106, "SLOT_BACK",         nil, ALIL["Back"],          nil,  "VoA_T_BACK_25" },
        --         { 107, "SLOT_NECK",         nil, ALIL["Neck"],          nil,  "VoA_T_NECK_25" },
        --         { 108, "SLOT_FINGER",       nil, ALIL["Finger"],        nil,  "VoA_T_FINGER_25" },
        --         { 116, AtlasLoot:GetRetByFaction(44083, 43959 ) }, -- Reins of the Grand Black War Mammoth
        --     }
        -- },
        -- KEYS
    }
}
data["TempestKeep80"] = {

    name = AL["P2 Tempest Keep"],
	MapID = 3845,
	InstanceID = 550,
	AtlasModule = ATLAS_TBC_MODULE_NAME,
	AtlasMapID = "CL_TempestKeepTheEye",
	AtlasMapFile = {"CL_TempestKeepTheEye", "TempestKeepEnt"},
	ContentType = RAID_CONTENT,
    ContentPhaseBC = 2,
	items = {
        { -- TKEyeAlar
            name = AL["Al'ar"],
            npcID = 19514,
            Level = 999,
            DisplayIDs = {{18945}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 29925 }, -- Phoenix-Wing Cloak
                { 2, 29918 }, -- Mindstorm Wristbands
                { 3, 29947 }, -- Gloves of the Searing Grip
                { 4, 29921 }, -- Fire Crest Breastplate
                { 5, 29922 }, -- Band of Al'ar
                { 6, 29920 }, -- Phoenix-Ring of Rebirth
                { 7, 30448 }, -- Talon of Al'ar
                { 8, 30447 }, -- Tome of Fiery Redemption
                { 9, 29923 }, -- Talisman of the Sun King
                { 10, 264937 }, -- Talisman of the Sun King
                { 12, 265335 }, -- Talisman of the Sun King
                { 16, 32944 }, -- Talon of the Phoenix
                { 17, 29948 }, -- Claw of the Phoenix
                { 18, 29924 }, -- Netherbane
                { 19, 29949 }, -- Arcanite Steam-Pistol
            }
        },
        { -- TKEyeVoidReaver
            name = AL["Void Reaver"],
            npcID = 19516,
            Level = 999,
            DisplayIDs = {{18951}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 29986 }, -- Cowl of the Grand Engineer
                { 2, 29984 }, -- Girdle of Zaetar
                { 3, 29985 }, -- Void Reaver Greaves
                { 4, 29983 }, -- Fel-Steel Warhelm
                { 5, 32515 }, -- Wristguards of Determination
                { 6, 30619 }, -- Fel Reaver's Piston
                { 7, 30450 }, -- Warp-Spring Coil
                { 16, 30248 }, -- Pauldrons of the Vanquished Champion
                { 17, 30249 }, -- Pauldrons of the Vanquished Defender
                { 18, 30250 }, -- Pauldrons of the Vanquished Hero
            }
        },
        { -- TKEyeSolarian
            name = AL["High Astromancer Solarian"],
            npcID = 18805,
            Level = 999,
            DisplayIDs = {{18239}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 29977 }, -- Star-Soul Breeches
                { 2, 29972 }, -- Trousers of the Astromancer
                { 3, 29966 }, -- Vambraces of Ending
                { 4, 29976 }, -- Worldstorm Gauntlets
                { 5, 29951 }, -- Star-Strider Boots
                { 6, 29965 }, -- Girdle of the Righteous Path
                { 7, 29950 }, -- Greaves of the Bloodwarder
                { 8, 32267 }, -- Boots of the Resilient
                { 16, 30446 }, -- Solarian's Sapphire
                { 17, 30449 }, -- Void Star Talisman
                { 18, 29962 }, -- Heartrazor
                { 19, 29981 }, -- Ethereum Life-Staff
                { 20, 29982 }, -- Wand of the Forgotten Star
            }
        },
        { -- TKEyeKaelthas
            name = AL["Kael'thas Sunstrider"],
            npcID = 19622,
            Level = 999,
            DisplayIDs = {{20023}},
            AtlasMapBossID = 4,
            [NORMAL_DIFF] = {
                { 1, 29992 }, -- Royal Cloak of the Sunstriders
                { 2, 29989 }, -- Sunshower Light Cloak
                { 3, 29994 }, -- Thalassian Wildercloak
                { 4, 29990 }, -- Crown of the Sun
                { 5, 29987 }, -- Gauntlets of the Sun King
                { 6, 29995 }, -- Leggings of Murderous Intent
                { 7, 29991 }, -- Sunhawk Leggings
                { 8, 29998 }, -- Royal Gauntlets of Silvermoon
                { 9, 29997 }, -- Band of the Ranger-General
                { 10, 29993 }, -- Twinblade of the Phoenix
                { 11, 29996 }, -- Rod of the Sun King
                { 12, 29988 }, -- The Nexus Key
                { 16, "INV_Box_01", nil, AL["I Guess"] },
                {17,19018},
                { 19, 30236 }, -- Chestguard of the Vanquished Champion
                { 20, 30237 }, -- Chestguard of the Vanquished Defender
                { 21, 30238 }, -- Chestguard of the Vanquished Hero
                { 23, 32458 }, -- Ashes of Al'ar
                { 25, 32405 }, -- Verdant Sphere
                { 27, 29905 }, -- Kael's Vial Remnant
            }
        },
        { -- TKEyeLegendaries
            name = AL["Legendaries"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 30312 }, -- Infinity Blade
                { 2, 30311 }, -- Warp Slicer
                { 3, 30317 }, -- Cosmic Infuser
                { 4, 30316 }, -- Devastation
                { 5, 30313 }, -- Staff of Disintegration
                { 6, 30314 }, -- Phaseshift Bulwark
                { 7, 30318 }, -- Netherstrand Longbow
                { 8, 30319 }, -- Nether Spike
                {9,265069},
                {10,265070}
            }
        },
        { -- TKEyeTrash
            name = AL["All bosses"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 30024 }, -- Mantle of the Elven Kings
                { 2, 30020 }, -- Fire-Cord of the Magus
                { 3, 30029 }, -- Bark-Gloves of Ancient Wisdom
                { 4, 30026 }, -- Bands of the Celestial Archer
                { 5, 30030 }, -- Girdle of Fallen Stars
                { 6, 30028 }, -- Seventh Ring of the Tirisfalen
                { 8, 30324 }, -- Plans: Red Havoc Boots
                { 9, 30322 }, -- Plans: Red Belt of Battle
                { 10, 30323 }, -- Plans: Boots of the Protector
                { 11, 30321 }, -- Plans: Belt of the Guardian
                { 12, 30280 }, -- Pattern: Belt of Blasting
                { 13, 30282 }, -- Pattern: Boots of Blasting
                { 14, 30283 }, -- Pattern: Boots of the Long Road
                { 15, 30281 }, -- Pattern: Belt of the Long Road
                { 16, 30308 }, -- Pattern: Hurricane Boots
                { 17, 30304 }, -- Pattern: Monsoon Belt
                { 18, 30305 }, -- Pattern: Boots of Natural Grace
                { 19, 30307 }, -- Pattern: Boots of the Crimson Hawk
                { 20, 30306 }, -- Pattern: Boots of Utter Darkness
                { 21, 30301 }, -- Pattern: Belt of Natural Power
                { 22, 30303 }, -- Pattern: Belt of the Black Eagle
                { 23, 30302 }, -- Pattern: Belt of Deep Shadow
                { 25, 30183 }, -- Nether Vortex
                { 27, 32897 }, -- Mark of the Illidari
            }
        },
        T5_SET
    }
}

data["SerpentshrineCavern80"] = {
    name = AL["P2 Serpentshrine Cavern"],
	MapID = 3607,
	InstanceID = 548,
	AtlasModule = ATLAS_TBC_MODULE_NAME,
	AtlasMapID = "CL_CFRSerpentshrineCavern",
	AtlasMapFile = {"CL_CFRSerpentshrineCavern", "CL_CoilfangReservoirEnt"},
	ContentType = RAID_CONTENT,
    ContentPhaseBC = 2,
	items = {
        { -- CFRSerpentHydross
            name = AL["Hydross the Unstable"],
            npcID = 21216,
            Level = 999,
            DisplayIDs = {{20162}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 30056 }, -- Robe of Hateful Echoes
                { 2, 32516 }, -- Wraps of Purification
                { 3, 30050 }, -- Boots of the Shifting Nightmare
                { 4, 30055 }, -- Shoulderpads of the Stranger
                { 5, 30047 }, -- Blackfathom Warbands
                { 6, 30054 }, -- Ranger-General's Chestguard
                { 7, 30048 }, -- Brighthelm of Justice
                { 8, 30053 }, -- Pauldrons of the Wardancer
                { 16, 30052 }, -- Ring of Lethality
                { 17, 33055 }, -- Band of Vile Aggression
                { 18, 30664 }, -- Living Root of the Wildheart
                { 19, 30629 }, -- Scarab of Displacement
                { 20, 30049 }, -- Fathomstone
                { 21, 30051 }, -- Idol of the Crescent Goddess
            }
        },
        { -- CFRSerpentLurker
            name = AL["The Lurker Below"],
            npcID = 21217,
            Level = 999,
            DisplayIDs = {{20216}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 30064 }, -- Cord of Screaming Terrors
                { 2, 30067 }, -- Velvet Boots of the Guardian
                { 3, 30062 }, -- Grove-Bands of Remulos
                { 4, 30060 }, -- Boots of Effortless Striking
                { 5, 30066 }, -- Tempest-Strider Boots
                { 6, 30065 }, -- Glowing Breastplate of Truth
                { 7, 30057 }, -- Bracers of Eradication
                { 8, 265492},
                { 16, 30059 }, -- Choker of Animalistic Fury
                { 17, 30061 }, -- Ancestral Ring of Conquest
                { 18, 33054 }, -- The Seal of Danzalar
                { 19, 30665 }, -- Earring of Soulful Meditation
                { 20, 30063 }, -- Libram of Absolute Truth
                { 21, 30058 }, -- Mallet of the Tides
            }
        },
        { -- CFRSerpentLeotheras
            name = AL["Leotheras the Blind"],
            npcID = 21215,
            Level = 999,
            DisplayIDs = {{20514}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 30092 }, -- Orca-Hide Boots
                { 2, 30097 }, -- Coral-Barbed Shoulderpads
                { 3, 30091 }, -- True-Aim Stalker Bands
                { 4, 30096 }, -- Girdle of the Invulnerable
                { 5, 30627 }, -- Tsunami Talisman
                { 6, 30095 }, -- Fang of the Leviathan
                { 16, 30239 }, -- Gloves of the Vanquished Champion
                { 17, 30240 }, -- Gloves of the Vanquished Defender
                { 18, 30241 }, -- Gloves of the Vanquished Hero
            }
        },
        { -- CFRSerpentKarathress
            name = AL["Fathom-Lord Karathress"],
            npcID = 21214,
            Level = 999,
            DisplayIDs = {{20662},{20671},{20670},{20672}},
            AtlasMapBossID = 4,
            [NORMAL_DIFF] = {
                { 1, 30100 }, -- Soul-Strider Boots
                { 2, 30101 }, -- Bloodsea Brigand's Vest
                { 3, 30099 }, -- Frayed Tether of the Drowned
                { 4, 30663 }, -- Fathom-Brooch of the Tidewalker
                { 5, 30626 }, -- Sextant of Unstable Currents
                { 6, 30090 }, -- World Breaker
                { 16, 30245 }, -- Leggings of the Vanquished Champion
                { 17, 30246 }, -- Leggings of the Vanquished Defender
                { 18, 30247 }, -- Leggings of the Vanquished Hero
            }
        },
        { -- CFRSerpentMorogrim
            name = AL["Morogrim Tidewalker"],
            npcID = 21213,
            Level = 999,
            DisplayIDs = {{20739}},
            AtlasMapBossID = 5,
            [NORMAL_DIFF] = {
                { 1, 30098 }, -- Razor-Scale Battlecloak
                { 2, 30079 }, -- Illidari Shoulderpads
                { 3, 30075 }, -- Gnarled Chestpiece of the Ancients
                { 4, 30085 }, -- Mantle of the Tireless Tracker
                { 5, 30068 }, -- Girdle of the Tidal Call
                { 6, 30084 }, -- Pauldrons of the Argent Sentinel
                { 7, 30081 }, -- Warboots of Obliteration
                { 16, 30008 }, -- Pendant of the Lost Ages
                { 17, 30083 }, -- Ring of Sundered Souls
                { 18, 33058 }, -- Band of the Vigilant
                { 19, 30720 }, -- Serpent-Coil Braid
                { 20, 30082 }, -- Talon of Azshara
                { 21, 30080 }, -- Luminescent Rod of the Naaru
            }
        },
        { -- CFRSerpentVashj
            name = AL["Lady Vashj"],
            npcID = 21212,
            Level = 999,
            DisplayIDs = {{20748}},
            AtlasMapBossID = 6,
            [NORMAL_DIFF] = {
                { 1, 30107 }, -- Vestments of the Sea-Witch
                { 2, 30111 }, -- Runetotem's Mantle
                { 3, 30106 }, -- Belt of One-Hundred Deaths
                { 4, 30104 }, -- Cobra-Lash Boots
                { 5, 30102 }, -- Krakken-Heart Breastplate
                { 6, 30112 }, -- Glorious Gauntlets of Crestfall
                { 7, 30109 }, -- Ring of Endless Coils
                { 8, 30110 }, -- Coral Band of the Revived
                { 9, 30621 }, -- Prism of Inner Calm
                { 10, 30103 }, -- Fang of Vashj
                { 11, 30108 }, -- Lightfathom Scepter
                { 12, 30105 }, -- Serpent Spine Longbow
                { 16, 30242 }, -- Helm of the Vanquished Champion
                { 17, 30243 }, -- Helm of the Vanquished Defender
                { 18, 30244 }, -- Helm of the Vanquished Hero
                { 20, 29906 }, -- Vashj's Vial Remnant
            }
        },
        { -- CFRSerpentTrash
            name = AL["Trash"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 30027 }, -- Boots of Courage Unending
                { 2, 30022 }, -- Pendant of the Perilous
                { 3, 30620 }, -- Spyglass of the Hidden Fleet
                { 4, 30023 }, -- Totem of the Maelstrom
                { 5, 30021 }, -- Wildfury Greatstaff
                { 6, 30025 }, -- Serpentshrine Shuriken
                { 8, 30324 }, -- Plans: Red Havoc Boots
                { 9, 30322 }, -- Plans: Red Belt of Battle
                { 10, 30323 }, -- Plans: Boots of the Protector
                { 11, 30321 }, -- Plans: Belt of the Guardian
                { 12, 30280 }, -- Pattern: Belt of Blasting
                { 13, 30282 }, -- Pattern: Boots of Blasting
                { 14, 30283 }, -- Pattern: Boots of the Long Road
                { 15, 30281 }, -- Pattern: Belt of the Long Road
                { 16, 30308 }, -- Pattern: Hurricane Boots
                { 17, 30304 }, -- Pattern: Monsoon Belt
                { 18, 30305 }, -- Pattern: Boots of Natural Grace
                { 19, 30307 }, -- Pattern: Boots of the Crimson Hawk
                { 20, 30306 }, -- Pattern: Boots of Utter Darkness
                { 21, 30301 }, -- Pattern: Belt of Natural Power
                { 22, 30303 }, -- Pattern: Belt of the Black Eagle
                { 23, 30302 }, -- Pattern: Belt of Deep Shadow
                { 25, 30183 }, -- Nether Vortex
                { 27, 32897 }, -- Mark of the Illidari
            }
        },
        T5_SET
    }
}
data["WorldBossesBC80"] = {
    name = AL["P2 World bosses of TBC"],
	ContentType = RAID_CONTENT,
	items = {
        { -- DDoomwalker
            name = AL["Doomwalker"],
            npcID = 17711,
            Level = 999,
            DisplayIDs = {{21435}},
            [NORMAL_DIFF] = {
                { 1, 30729 }, -- Black-Iron Battlecloak
                { 2, 30725 }, -- Anger-Spark Gloves
                { 3, 30727 }, -- Gilded Trousers of Benediction
                { 4, 30730 }, -- Terrorweave Tunic
                { 5, 30728 }, -- Fathom-Helm of the Deeps
                { 6, 30731 }, -- Faceguard of the Endless Watch
                { 7, 30726 }, -- Archaic Charm of Presence
                { 8, 30723 }, -- Talon of the Tempest
                { 9, 30722 }, -- Ethereum Nexus-Reaver
                { 10, 30724 }, -- Barrel-Blade Longrifle
            }
        },
        { -- KKruul
            name = AL["Doom Lord Kazzak"],
            npcID = 18728,
            Level = 999,
            DisplayIDs = {{17887}},
            [NORMAL_DIFF] = {
                { 1, 30735 }, -- Ancient Spellcloak of the Highborne
                { 2, 30734 }, -- Leggings of the Seventh Circle
                { 3, 30737 }, -- Gold-Leaf Wildboots
                { 4, 30739 }, -- Scaled Greaves of the Marksman
                { 5, 30740 }, -- Ripfiend Shoulderplates
                { 6, 30741 }, -- Topaz-Studded Battlegrips
                { 7, 30736 }, -- Ring of Flowing Light
                { 8, 30738 }, -- Ring of Reciprocity
                { 9, 30733 }, -- Hope Ender
                { 10, 30732 }, -- Exodar Life-Staff
            }
        }
	}
}
data["NaxxramasWrath"] = {
	MapID = 3456,
    name = AL["P3 Naxxramas"],
	InstanceID = 533,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "Naxxramas",
	AtlasMapFile = "Naxxramas",
	ContentType = RAID_CONTENT,
    -- LevelRange = {80, 80, 80},
	items = {
		-- The Arachnid Quarter
		{ -- NAXAnubRekhan
			name = AL["Anub'Rekhan"],
			npcID = 15956,
            EncounterJournalID = 1601,
			Level = 999,
			DisplayIDs = {{15931}},
			AtlasMapBossID = "1",
            NameColor = BLUE,
            [NORMAL_DIFF] = {
                { 1, 39719 }, -- Mantle of the Locusts
                { 2, 39721 }, -- Sash of the Parlor
                { 3, 39720 }, -- Leggings of Atrophy
                { 4, 39722 }, -- Swarm Bindings
                { 5, 39701 }, -- Dawnwalkers
                { 6, 39702 }, -- Arachnoid Gold Band
                { 7, 39718 }, -- Corpse Scarab Handguards
                { 8, 39704 }, -- Pauldrons of Unnatural Death
                { 9, 39703 }, -- Rescinding Grips
                { 10, 39717 }, -- Inexorable Sabatons
                { 11, 39706 }, -- Sabatons of Sudden Reprisal
                { 12, 40071 }, -- Chains of Adoration
                { 13, 40065 }, -- Fool's Trial
                { 14, 40069 }, -- Heritage
                { 15, 40064 }, -- Thunderstorm Amulet
                { 16, 40080 }, -- Lost Jewel
                { 17, 40075 }, -- Ruthlessness
                { 18, 40107 }, -- Sand-Worn Band
                { 19, 40074 }, -- Strong-Handed Ring
                { 20, 39714 }, -- Webbed Death
                { 21, 40208 }, -- Cryptfiend's Bite
                { 22, 39716 }, -- Shield of Assimilation
                { 23, 39712 }, -- Gemmed Wand of the Nerubians
            },
		},
		{ -- NAXGrandWidowFaerlina
			name = AL["Grand Widow Faerlina"],
			npcID = 15953,
            EncounterJournalID = 1602,
			Level = 999,
			DisplayIDs = {{15940}},
			AtlasMapBossID = "2",
            NameColor = BLUE,
            [NORMAL_DIFF] = {
                { 1, 39732 }, -- Faerlina's Madness
                { 2, 39731 }, -- Punctilious Bindings
                { 3, 39733 }, -- Gloves of Token Respect
                { 4, 39735 }, -- Belt of False Dignity
                { 5, 39756 }, -- Tunic of Prejudice
                { 6, 39727 }, -- Dislocating Handguards
                { 7, 39724 }, -- Cult's Chestguard
                { 8, 39734 }, -- Atonement Greaves
                { 9, 39723 }, -- Fire-Scorched Greathelm
                { 10, 39725 }, -- Epaulets of the Grieving Servant
                { 11, 39729 }, -- Bracers of the Tyrant
                { 12, 39726 }, -- Callous-Hearted Gauntlets
                { 13, 40071 }, -- Chains of Adoration
                { 14, 40065 }, -- Fool's Trial
                { 15, 40069 }, -- Heritage
                { 16, 40064 }, -- Thunderstorm Amulet
                { 17, 40080 }, -- Lost Jewel
                { 18, 40075 }, -- Ruthlessness
                { 19, 40107 }, -- Sand-Worn Band
                { 20, 40108 }, -- Seized Beauty
                { 21, 40074 }, -- Strong-Handed Ring
                { 22, 39757 }, -- Idol of Worship
                { 23, 39728 }, -- Totem of Misery
                { 24, 39730 }, -- Widow's Fury
                { 26, "ac1997" },
                { 28, "ac2140" },
            },
		},
		{ -- NAXMaexxna
			name = AL["Maexxna"],
			npcID = 15952,
            EncounterJournalID = 1603,
			Level = 999,
			DisplayIDs = {{15928}},
			AtlasMapBossID = "3",
            NameColor = BLUE,
            [NORMAL_DIFF] = {
                { 1, 40250 }, -- Aged Winter Cloak
                { 2, 40254 }, -- Cloak of Averted Crisis
                { 3, 40252 }, -- Cloak of the Shadowed Sun
                { 4, 40253 }, -- Shawl of the Old Maid
                { 5, 40251 }, -- Shroud of Luminosity
                { 6, 40062 }, -- Digested Silken Robes
                { 7, 40060 }, -- Distorted Limbs
                { 8, 39768 }, -- Cowl of the Perished
                { 9, 40063 }, -- Mantle of Shattered Kinship
                { 10, 39765 }, -- Sinner's Bindings
                { 11, 39761 }, -- Infectious Skitterer Leggings
                { 12, 40061 }, -- Quivering Tunic
                { 13, 39762 }, -- Torn Web Wrapping
                { 14, 39760 }, -- Helm of Diminished Pride
                { 15, 39767 }, -- Undiminished Battleplate
                { 16, 39764 }, -- Bindings of the Hapless Prey
                { 17, 39759 }, -- Ablative Chitin Girdle
                { 18, 40257 }, -- Defender's Code
                { 19, 40255 }, -- Dying Curse
                { 20, 40258 }, -- Forethought Talisman
                { 21, 40256 }, -- Grim Toll
                { 22, 39766 }, -- Matriarch's Spawn
                { 23, 39763 }, -- Wraith Strike
                { 24, 39758 }, -- The Jawbone
                { 26, "ac1858" },
                { 28, "ac1859" },
            },
		},
		-- The Plague Quarter
		{ -- NAXNoththePlaguebringer
			name = AL["Noth the Plaguebringer"],
			npcID = 15954,
            EncounterJournalID = 1604,
			Level = 999,
			DisplayIDs = {{16590}},
			AtlasMapBossID = "1",
            NameColor = PURPLE,
            [NORMAL_DIFF] = {
                { 1, 40602 }, -- Robes of Mutation
                { 2, 40198 }, -- Bands of Impurity
                { 3, 40197 }, -- Gloves of the Fallen Wizard
                { 4, 40186 }, -- Thrusting Bands
                { 5, 40200 }, -- Belt of Potent Chanting
                { 6, 40193 }, -- Tunic of Masked Suffering
                { 7, 40196 }, -- Legguards of the Undisturbed
                { 8, 40184 }, -- Crippled Treads
                { 9, 40185 }, -- Shoulderguards of Opportunity
                { 10, 40188 }, -- Gauntlets of the Disobediant
                { 11, 40187 }, -- Poignant Sabatons
                { 12, 40071 }, -- Chains of Adoration
                { 13, 40065 }, -- Fool's Trial
                { 14, 40069 }, -- Heritage
                { 15, 40064 }, -- Thunderstorm Amulet
                { 16, 40080 }, -- Lost Jewel
                { 17, 40075 }, -- Ruthlessness
                { 18, 40107 }, -- Sand-Worn Band
                { 19, 40074 }, -- Strong-Handed Ring
                { 20, 40192 }, -- Accursed Spine
                { 21, 40191 }, -- Libram of Radiance
                { 22, 40189 }, -- Angry Dread
                { 23, 40190 }, -- Spinning Fate
            },
		},
		{ -- NAXHeigantheUnclean
			name = AL["Heigan the Unclean"],
			npcID = 15936,
            EncounterJournalID = 1605,
			Level = 999,
			DisplayIDs = {{16309}},
			AtlasMapBossID = "2",
            NameColor = PURPLE,
            [NORMAL_DIFF] = {
                { 1, 40250 }, -- Aged Winter Cloak
                { 2, 40254 }, -- Cloak of Averted Crisis
                { 3, 40252 }, -- Cloak of the Shadowed Sun
                { 4, 40253 }, -- Shawl of the Old Maid
                { 5, 40251 }, -- Shroud of Luminosity
                { 6, 40234 }, -- Heigan's Putrid Vestments
                { 7, 40236 }, -- Serene Echoes
                { 8, 40238 }, -- Gloves of the Dancing Bear
                { 9, 40205 }, -- Stalk-Skin Belt
                { 10, 40235 }, -- Helm of Pilgrimage
                { 11, 40209 }, -- Bindings of the Decrepit
                { 12, 40201 }, -- Leggings of Colossal Strides
                { 13, 40237 }, -- Eruption-Scared Boots
                { 14, 40203 }, -- Breastplate of Tormented Rage
                { 15, 40210 }, -- Chestguard of Bitter Charms
                { 16, 40204 }, -- Legguards of the Apostle
                { 17, 40206 }, -- Iron-Spring Jumpers
                { 18, 40257 }, -- Defender's Code
                { 19, 40255 }, -- Dying Curse
                { 20, 40258 }, -- Forethought Talisman
                { 21, 40256 }, -- Grim Toll
                { 22, 40207 }, -- Sigil of Awareness
                { 23, 40208 }, -- Cryptfiend's Bite
                { 24, 40233 }, -- The Undeath Carrier
                { 26, "ac1996" },
                { 28, "ac2139" },
            },
		},
		{ -- NAXLoatheb
			name = AL["Loatheb"],
			npcID = 16011,
            EncounterJournalID = 1606,
			Level = 999,
			DisplayIDs = {{16110}},
			AtlasMapBossID = "3",
            NameColor = PURPLE,
            [NORMAL_DIFF] = {
                { 1, 40247 }, -- Cowl of Innocent Delight
                { 2, 40246 }, -- Boots of Impetuous Ideals
                { 3, 40249 }, -- Vest of Vitality
                { 4, 40243 }, -- Footwraps of Vile Deceit
                { 5, 40242 }, -- Grotesque Handgrips
                { 6, 40241 }, -- Girdle of Unity
                { 7, 40240 }, -- Greaves of Turbulence
                { 8, 40244 }, -- The Impossible Dream
                { 9, 40239 }, -- The Hand of Nerub
                { 10, 40245 }, -- Fading Glow
                { 16, 40637 }, -- Mantle of the Lost Conqueror
                { 17, 40638 }, -- Mantle of the Lost Protector
                { 18, 40639 }, -- Mantle of the Lost Vanquisher
                { 20, "ac2182" },
                { 22, "ac2183" },
            },
		},
		-- The Military Quarter
		{ -- NAXInstructorRazuvious
			name = AL["Instructor Razuvious"],
			npcID = 16061,
            EncounterJournalID = 1607,
			Level = 999,
			DisplayIDs = {{16582}},
			AtlasMapBossID = "1",
            NameColor = _RED,
            [NORMAL_DIFF] = {
                { 1, 40325 }, -- Bindings of the Expansive Mind
                { 2, 40326 }, -- Boots of Forlorn Wishes
                { 3, 40305 }, -- Spaulders of Egotism
                { 4, 40319 }, -- Chestpiece of Suspicion
                { 5, 40323 }, -- Esteemed Bindings
                { 6, 40315 }, -- Shoulderpads of Secret Arts
                { 7, 40324 }, -- Bands of Mutual Respect
                { 8, 40327 }, -- Girdle of Recuperation
                { 9, 40306 }, -- Bracers of the Unholy Knight
                { 10, 40316 }, -- Gauntlets of Guiding Touch
                { 11, 40317 }, -- Girdle of Razuvious
                { 12, 40318 }, -- Legplates of Double Strikes
                { 13, 40320 }, -- Faithful Steel Sabatons
                { 14, 40071 }, -- Chains of Adoration
                { 15, 40065 }, -- Fool's Trial
                { 16, 40069 }, -- Heritage
                { 17, 40064 }, -- Thunderstorm Amulet
                { 18, 40080 }, -- Lost Jewel
                { 19, 40075 }, -- Ruthlessness
                { 20, 40107 }, -- Sand-Worn Band
                { 21, 40074 }, -- Strong-Handed Ring
                { 22, 40321 }, -- Idol of the Shooting Star
                { 23, 40322 }, -- Totem of Dueling
            },
		},
		{ -- NAXGothiktheHarvester
			name = AL["Gothik the Harvester"],
			npcID = 16060,
            EncounterJournalID = 1608,
			Level = 999,
			DisplayIDs = {{16279}},
			AtlasMapBossID = "2",
            NameColor = _RED,
            [NORMAL_DIFF] = {
                { 1, 40250 }, -- Aged Winter Cloak
                { 2, 40254 }, -- Cloak of Averted Crisis
                { 3, 40252 }, -- Cloak of the Shadowed Sun
                { 4, 40253 }, -- Shawl of the Old Maid
                { 5, 40251 }, -- Shroud of Luminosity
                { 6, 40339 }, -- Gothik's Cowl
                { 7, 40338 }, -- Bindings of Yearning
                { 8, 40329 }, -- Hood of the Exodus
                { 9, 40341 }, -- Shackled Cinch
                { 10, 40333 }, -- Leggings of Fleeting Moments
                { 11, 40340 }, -- Helm of Unleashed Energy
                { 12, 40331 }, -- Leggings of Failed Escape
                { 13, 40328 }, -- Helm of Vital Protection
                { 14, 40334 }, -- Burdened Shoulderplates
                { 15, 40332 }, -- Abetment Bracers
                { 16, 40330 }, -- Bracers of Unrelenting Attack
                { 17, 40257 }, -- Defender's Code
                { 18, 40255 }, -- Dying Curse
                { 19, 40258 }, -- Forethought Talisman
                { 20, 40256 }, -- Grim Toll
                { 21, 40342 }, -- Idol of Awakening
                { 22, 40337 }, -- Libram of Resurgence
                { 23, 40336 }, -- Life and Death
                { 24, 40335 }, -- Touch of Horror
            },
		},
		{ -- NAXTheFourHorsemen
			name = AL["The Four Horsemen"],
			npcID = {16064, 16065, 16062, 16063},
            EncounterJournalID = 1609,
			Level = 999,
			DisplayIDs = {{16155},{16153},{16139},{16154}},
			AtlasMapBossID = "3",
            NameColor = _RED,
            [NORMAL_DIFF] = {
                { 1, 40349 }, -- Gloves of Peaceful Death
                { 2, 40344 }, -- Helm of the Grave
                { 3, 40352 }, -- Leggings of Voracious Shadows
                { 4, 40347 }, -- Zeliek's Gauntlets
                { 5, 40350 }, -- Urn of Lost Memories
                { 6, 40345 }, -- Broken Promise
                { 7, 40343 }, -- Armageddon
                { 8, 40348 }, -- Damnation
                { 9, 22691 }, -- Final Voyage
                { 16, 40625 }, -- Breastplate of the Lost Conqueror
                { 17, 40626 }, -- Breastplate of the Lost Protector
                { 18, 40627 }, -- Breastplate of the Lost Vanquisher
                { 20, "ac2176" },
                { 22, "ac2177" },
            },
		},
		-- The Construct Quarter
		{ -- NAXPatchwerk
			name = AL["Patchwerk"],
			npcID = 16028,
            EncounterJournalID = 1610,
			Level = 999,
			DisplayIDs = {{16174}},
			AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 40271 }, -- Sash of Solitude
                { 2, 40269 }, -- Boots of Persuasion
                { 3, 40260 }, -- Belt of the Tortured
                { 4, 40270 }, -- Boots of Septic Wounds
                { 5, 40262 }, -- Gloves of Calculated Risk
                { 6, 40272 }, -- Girdle of the Gambit
                { 7, 40261 }, -- Crude Discolored Battlegrips
                { 8, 40263 }, -- Fleshless Girdle
                { 9, 40259 }, -- Waistguard of Divine Grace
                { 10, 40071 }, -- Chains of Adoration
                { 11, 40065 }, -- Fool's Trial
                { 12, 40069 }, -- Heritage
                { 13, 40064 }, -- Thunderstorm Amulet
                { 14, 40080 }, -- Lost Jewel
                { 15, 40075 }, -- Ruthlessness
                { 16, 40107 }, -- Sand-Worn Band
                { 17, 40074 }, -- Strong-Handed Ring
                { 18, 40273 }, -- Surplus Limb
                { 19, 40267 }, -- Totem of Hex
                { 20, 40268 }, -- Libram of Tolerance
                { 21, 40264 }, -- Split Greathammer
                { 22, 40266 }, -- Hero's Surrender
                { 23, 40265 }, -- Arrowsong
                { 25, "ac1856" },
                { 27, "ac1857" },
            },
		},
		{ -- NAXGrobbulus
			name = AL["Grobbulus"],
			npcID = 15931,
            EncounterJournalID = 1611,
			Level = 999,
			DisplayIDs = {{16035}},
			AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 40250 }, -- Aged Winter Cloak
                { 2, 40254 }, -- Cloak of Averted Crisis
                { 3, 40252 }, -- Cloak of the Shadowed Sun
                { 4, 40253 }, -- Shawl of the Old Maid
                { 5, 40251 }, -- Shroud of Luminosity
                { 6, 40287 }, -- Cowl of Vanity
                { 7, 40286 }, -- Mantle of the Corrupted
                { 8, 40351 }, -- Mantle of the Fatigued Sage
                { 9, 40289 }, -- Sympathetic Amice
                { 10, 40277 }, -- Tunic of Indulgence
                { 11, 40285 }, -- Desecrated Past
                { 12, 40288 }, -- Spaulders of Incoherence
                { 13, 40283 }, -- Fallout Impervious Tunic
                { 14, 40282 }, -- Slime Stream Bands
                { 15, 40275 }, -- Depraved Linked Belt
                { 16, 40279 }, -- Chestguard of the Exhausted
                { 17, 40274 }, -- Bracers of Liberation
                { 18, 40278 }, -- Girdle of Chivalry
                { 19, 40257 }, -- Defender's Code
                { 20, 40255 }, -- Dying Curse
                { 21, 40258 }, -- Forethought Talisman
                { 22, 40256 }, -- Grim Toll
                { 23, 40281 }, -- Twilight Mist
                { 24, 40280 }, -- Origin of Nightmares
                { 25, 40284 }, -- Plague Igniter
            },
		},
		{ -- NAXGluth
			name = AL["Gluth"],
			npcID = 15932,
            EncounterJournalID = 1612,
			Level = 999,
			DisplayIDs = {{16064}},
			AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 40247 }, -- Cowl of Innocent Delight
                { 2, 40289 }, -- Sympathetic Amice
                { 3, 40602 }, -- Robes of Mutation
                { 4, 39733 }, -- Gloves of Token Respect
                { 5, 40303 }, -- Wraps of the Persecuted
                { 6, 40326 }, -- Boots of Forlorn Wishes
                { 7, 40296 }, -- Cover of Silence
                { 8, 39768 }, -- Cowl of the Perished
                { 9, 40319 }, -- Chestpiece of Suspicion
                { 10, 40260 }, -- Belt of the Tortured
                { 11, 40205 }, -- Stalk-Skin Belt
                { 12, 40270 }, -- Boots of Septic Wounds
                { 13, 40193 }, -- Tunic of Masked Suffering
                { 14, 40209 }, -- Bindings of the Decrepit
                { 15, 40302 }, -- Benefactor's Gauntlets
                { 16, 39718 }, -- Corpse Scarab Handguards
                { 17, 40242 }, -- Grotesque Handgrips
                { 18, 39760 }, -- Helm of Diminished Pride
                { 19, 40185 }, -- Shoulderguards of Opportunity
                { 20, 40203 }, -- Breastplate of Tormented Rage
                { 21, 40332 }, -- Abetment Bracers
                { 22, 40188 }, -- Gauntlets of the Disobediant
                { 23, 40259 }, -- Waistguard of Divine Grace
                { 24, 40204 }, -- Legguards of the Apostle
                { 25, 39717 }, -- Inexorable Sabatons
                { 26, 40206 }, -- Iron-Spring Jumpers
                { 27, 40297 }, -- Sabatons of Endurance
                { 28, 40350 }, -- Urn of Lost Memories
                { 29, 40191 }, -- Libram of Radiance

                { 101, 40281 }, -- Twilight Mist
                { 102, 39714 }, -- Webbed Death
                { 103, 39730 }, -- Widow's Fury
                { 104, 40343 }, -- Armageddon
                { 105, 40239 }, -- The Hand of Nerub
                { 106, 40280 }, -- Origin of Nightmares
                { 107, 39716 }, -- Shield of Assimilation
                { 108, 40265 }, -- Arrowsong
                { 109, 40346 }, -- Final Voyage
                { 111, 40637 }, -- Mantle of the Lost Conqueror
                { 112, 40638 }, -- Mantle of the Lost Protector
                { 113, 40639 }, -- Mantle of the Lost Vanquisher
                { 116, 40625 }, -- Breastplate of the Lost Conqueror
                { 117, 40626 }, -- Breastplate of the Lost Protector
                { 118, 40627 }, -- Breastplate of the Lost Vanquisher
                { 120, 40634 }, -- Legplates of the Lost Conqueror
                { 121, 40635 }, -- Legplates of the Lost Protector
                { 122, 40636 }, -- Legplates of the Lost Vanquisher
            },
		},
		{ -- NAXThaddius
			name = AL["Thaddius"],
			npcID = 15928,
            EncounterJournalID = 1613,
			Level = 999,
			DisplayIDs = {{16137}},
			AtlasMapBossID = 4,
            [NORMAL_DIFF] = {
                { 1, 40303 }, -- Wraps of the Persecuted
                { 2, 40301 }, -- Cincture of Polarity
                { 3, 40296 }, -- Cover of Silence
                { 4, 40304 }, -- Headpiece of Fungal Bloom
                { 5, 40299 }, -- Pauldrons of the Abandoned
                { 6, 40302 }, -- Benefactor's Gauntlets
                { 7, 40298 }, -- Faceguard of the Succumbed
                { 8, 40294 }, -- Riveted Abomination Leggings
                { 9, 40297 }, -- Sabatons of Endurance
                { 10, 40300 }, -- Spire of Sunset
                { 16, 40634 }, -- Legplates of the Lost Conqueror
                { 17, 40635 }, -- Legplates of the Lost Protector
                { 18, 40636 }, -- Legplates of the Lost Vanquisher
                { 20, "ac2178" },
                { 21, "ac2180" },
                { 23, "ac2179" },
				{ 24, "ac2181" },
            },
		},
		-- Frostwyrm Lair
		{ -- NAXSapphiron
			name = AL["Sapphiron"],
			npcID = 15989,
            EncounterJournalID = 1614,
			Level = 999,
			DisplayIDs = {{16033}},
			AtlasMapBossID = "1",
            NameColor = GREEN,
            [NORMAL_DIFF] = {
                { 1, 40381 }, -- Sympathy
                { 2, 40380 }, -- Gloves of Grandeur
                { 3, 40376 }, -- Legwraps of the Defeated Dragon
                { 4, 40362 }, -- Gloves of Fast Reactions
                { 5, 40379 }, -- Legguards of the Boneyard
                { 6, 40367 }, -- Boots of the Great Construct
                { 7, 40366 }, -- Platehelm of the Great Wyrm
                { 8, 40377 }, -- Noble Birthright Pauldrons
                { 9, 40365 }, -- Breastplate of Frozen Pain
                { 10, 40363 }, --  Bone-Inlaid Legguards
                { 11, 40378 }, -- Ceaseless Pity
                { 12, 40374 }, -- Cosmic Lights
                { 13, 40369 }, -- Icy Blast Amulet
                { 14, 40370 }, -- Gatekeeper
                { 15, 40375 }, -- Ring of Decaying Beauty
                { 16, 40371 }, -- Bandit's Insignia
                { 17, 40373 }, -- Extract of Necromatic Power
                { 18, 40372 }, -- Rune of Repulsion
                { 19, 40382 }, -- Soul of the Dead
                { 20, 40368 }, -- Murder
                { 22, 44577 }, -- Heroic Key to the Focusing Iris
                { 24, "ac572" },
                { 25, "ac2146" },
                { 27, "ac573" },
				{ 28, "ac2147" },
            },
		},
		{ -- NAXKelThuzard
			name = AL["Kel'Thuzad"],
			npcID = 15990,
            EncounterJournalID = 1615,
			Level = 999,
			DisplayIDs = {{15945}},
			AtlasMapBossID = "2",
            NameColor = GREEN,
            [NORMAL_DIFF] = {
                { 1, 40405 }, -- Cape of the Unworthy Wizard
                { 2, 40403 }, -- Drape of the Deadly Foe
                { 3, 40398 }, -- Leggings of Mortal Arrogance
                { 4, 40387 }, -- Boundless Ambition
                { 5, 40399 }, -- Signet of Manifested Pain
                { 6, 40383 }, -- Calamity's Grasp
                { 7, 40386 }, -- Sinister Revenge
                { 8, 40396 }, -- The Turning Tide
                { 9, 40402 }, -- Last Laugh
                { 10, 40384 }, -- Betrayer of Humanity
                { 11, 40395 }, -- Torch of Holy Fire
                { 12, 40388 }, -- Journey's End
                { 13, 40401 }, -- Voice of Reason
                { 14, 40400 }, -- Wall of Terror
                { 15, 40385 }, -- Envoy of Mortality
                { 16, 265841 },
                { 17, 40631 }, -- Crown of the Lost Conqueror
                { 18, 40632 }, -- Crown of the Lost Protector
                { 19, 40633 }, -- Crown of the Lost Vanquisher
                { 20, "ac1658" },
                { 22, "ac574" },
                { 23, "ac2184" },
                { 25, "ac575" },
				{ 26, "ac2185" },
            },
		},
		{ -- NAXTrash
			name = AL["Trash"],
			ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 40410 }, -- Shadow of the Ghoul
                { 2, 40409 }, -- Boots of the Escaped Captive
                { 3, 40414 }, -- Shoulderguards of the Undaunted
                { 4, 40412 }, -- Ousted Bead Necklace
                { 5, 40408 }, -- Haunting Call
                { 6, 40407 }, -- Silent Crusader
                { 7, 40406 }, -- Inevitable Defeat
            },
		},
        T7_SET,
        WOTLK_NAXXRAMAS_AC_TABLE,
	},
}

data["TheEyeOfEternity"] = {
    name = AL["P3 The Eye of Eternity"],
	MapID = 4500,
	InstanceID = 616,
    ContentType = RAID_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "TheEyeOfEternity",
	AtlasMapFile = {"TheEyeOfEternity"},
	-- LevelRange = {80, 80, 80},
	items = {
        { -- Malygos / 180
	        name = AL["Malygos"],
            npcID = 28859,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 40562 }, -- Hood of Rationality
                { 2, 40555 }, -- Mantle of Dissemination
                { 3, 40194 }, -- Blanketing Robes of Snow
                { 4, 40561 }, -- Leash of Heedless Magic
                { 5, 40560 }, -- Leggings of the Wanton Spellcaster
                { 6, 40558 }, -- Arcanic Tramplers
                { 7, 40594 }, -- Spaulders of Catatonia
                { 8, 40539 }, -- Chestguard of the Recluse
                { 9, 40541 }, -- Frosted Adroit Handguards
                { 10, 40566 }, -- Unravelling Strands of Sanity
                { 11, 40543 }, -- Blue Aspect Helm
                { 12, 40588 }, -- Tunic of the Artifact Guardian
                { 13, 40564 }, -- Winter Spectacle Gloves
                { 14, 40549 }, -- Boots of the Renewed Flight
                { 15, 40590 }, -- Elevated Lair Pauldrons
                { 16, 40589 }, -- Legplates of Sovereignty
                { 17, 40592 }, -- Boots of Healing Energies
                { 18, 40591 }, -- Melancholy Sabatons
                { 19, 40532 }, -- Living Ice Crystals
                { 20, 40531 }, -- Mark of Norgannon
                { 22, 43952 }, -- Reins of the Azure Drake
                { 24, 44577 }, -- Heroic Key to the Focusing Iris
                { 25, 44651 }, -- Heart of Magic
            }
        },
        KEYS
    }
}

data["ObsidianSanctum"] = {
	MapID = 4493,
	InstanceID = 615,
    name =AL["P3 Obsidian Sanctum"],
    ContentType = RAID_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "ObsidianSanctum",
	AtlasMapFile = {"ObsidianSanctum"},
	-- LevelRange = {80, 80, 80},
	items = {
        { -- CoTHillsbradDrake
            name = AL["Sartharion"],
            npcID = 28860,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapBossID = 4,
            [NORMAL_DIFF] = {
                { 1, 40437 }, -- Concealment Shoulderpads
                { 2, 40439 }, -- Mantle of the Eternal Sentinel
                { 3, 40451 }, -- Hyaline Helm of the Sniper
                { 4, 40438 }, -- Council Chamber Epaulets
                { 5, 40453 }, -- Chestplate of the Great Aspects
                { 6, 40446 }, -- Dragon Brood Legguards
                { 7, 40433 }, -- Wyrmrest Band
                { 8, 40431 }, -- Fury of the Five Flights
                { 9, 40432 }, -- Illustration of the Dragon Soul
                { 10, 40455 }, -- Staff of Restraint
                { 16, 40628 }, -- Gauntlets of the Lost Conqueror
                { 17, 40629 }, -- Gauntlets of the Lost Protector
                { 18, 40630 }, -- Gauntlets of the Lost Vanquisher
                { 20, 43345 }, -- Dragon Hide Bag
                { 21, 43346 }, -- Large Satchel of Spoils
            }
        },
        { -- CoTHillsbradDrake
            name = format(BONUS_LOOT_SPLIT, AL["Sartharion"], AL["Bonus Loot"]),
            npcID = 28860,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, "INV_Box_01", nil, AL["One Drake Left"] },
                { 2, 44002 }, -- The Sanctum's Flowing Vestments
                { 3, 44003 }, -- Upstanding Spaulders
                { 4, 44004 }, -- Bountiful Gauntlets
                { 5, 44000 }, -- Dragonstorm Breastplate
                { 7, "INV_Box_01", nil, AL["Two Drakes Left"] },
                { 8, 44005 }, -- Pennant Cloak
                { 9, 44008 }, -- Unsullied Cuffs
                { 10, 44007 }, -- Headpiece of Reconciliation
                { 11, 44011 }, -- Leggings of the Honored
                { 12, 44006 }, -- Obsidian Greathelm
                { 16, "INV_Box_01", nil, AL["Three Drakes Left"] },
                { 17, 43954 }, -- Reins of the Twilight Drake
            }
        },
        T7_SET
    }
}
data["Zul'Gurub80"] = {
	MapID = 1977,
	InstanceID = 309,
    name =AL["P4 Zul'Gurub"],
	AtlasModule = ATLAS_ERA_MODULE_NAME,
	AtlasMapID = "Zul'Gurub", -- ??
	AtlasMapFile = "CL_ZulGurub",
	AtlasMapFile_AL = "ZulGurub",
	ContentType = RAID_CONTENT,
	items = {
		{ -- ZGJeklik
			name = AL["High Priestess Jeklik"],
			npcID = 14517,
			Level = 999,
			DisplayIDs = {{15219}},
			AtlasMapBossID = 1,
			[NORMAL_DIFF] = {
				{ 1,  19721 }, -- Primal Hakkari Shawl
				{ 2,  19724 }, -- Primal Hakkari Aegis
				{ 3,  19723 }, -- Primal Hakkari Kossack
				{ 4,  19722 }, -- Primal Hakkari Tabard
				{ 5,  19717 }, -- Primal Hakkari Armsplint
				{ 6,  19716 }, -- Primal Hakkari Bindings
				{ 7,  19718 }, -- Primal Hakkari Stanchion
				{ 8,  19719 }, -- Primal Hakkari Girdle
				{ 9,  19720 }, -- Primal Hakkari Sash
				{ 16, 19918 }, -- Jeklik's Crusher
				{ 18, 19923 }, -- Jeklik's Opaline Talisman
				{ 19, 19928 }, -- Animist's Spaulders
				{ 20, 20262 }, -- Seafury Boots
				{ 21, 20265 }, -- Peacekeeper Boots
				{ 22, 19920 }, -- Primalist's Band
				{ 23, 19915 }, -- Zulian Defender
			},
		},
		{ -- ZGVenoxis
			name = AL["High Priest Venoxis"],
			npcID = 14507,
			Level = 999,
			DisplayIDs = {{15217}},
			AtlasMapBossID = 2,
			[NORMAL_DIFF] = {
				{ 1,  19721 }, -- Primal Hakkari Shawl
				{ 2,  19724 }, -- Primal Hakkari Aegis
				{ 3,  19723 }, -- Primal Hakkari Kossack
				{ 4,  19722 }, -- Primal Hakkari Tabard
				{ 5,  19717 }, -- Primal Hakkari Armsplint
				{ 6,  19716 }, -- Primal Hakkari Bindings
				{ 7,  19718 }, -- Primal Hakkari Stanchion
				{ 8,  19719 }, -- Primal Hakkari Girdle
				{ 9,  19720 }, -- Primal Hakkari Sash
				{ 16, 19904 }, -- Runed Bloodstained Hauberk
				{ 17, 19903 }, -- Fang of Venoxis
				{ 19, 19907 }, -- Zulian Tigerhide Cloak
				{ 20, 19906 }, -- Blooddrenched Footpads
				{ 21, 19905 }, -- Zanzil's Band
				{ 22, 19900 }, -- Zulian Stone Axe
			},
		},
		{ -- ZGMarli
			name = AL["High Priestess Mar'li"],
			npcID = 14510,
			Level = 999,
			DisplayIDs = {{15220}},
			AtlasMapBossID = 4,
			[NORMAL_DIFF] = {
				{ 1,  19721 }, -- Primal Hakkari Shawl
				{ 2,  19724 }, -- Primal Hakkari Aegis
				{ 3,  19723 }, -- Primal Hakkari Kossack
				{ 4,  19722 }, -- Primal Hakkari Tabard
				{ 5,  19717 }, -- Primal Hakkari Armsplint
				{ 6,  19716 }, -- Primal Hakkari Bindings
				{ 7,  19718 }, -- Primal Hakkari Stanchion
				{ 8,  19719 }, -- Primal Hakkari Girdle
				{ 9,  19720 }, -- Primal Hakkari Sash
				{ 16, 20032 }, -- Flowing Ritual Robes
				{ 17, 19927 }, -- Mar'li's Touch
				{ 19, 19871 }, -- Talisman of Protection
				{ 20, 19919 }, -- Bloodstained Greaves
				{ 21, 19925 }, -- Band of Jin
				{ 22, 19930 }, -- Mar'li's Eye
			},
		},
		{ -- ZGMandokir
			name = AL["Bloodlord Mandokir"],
			npcID = 11382,
			Level = 999,
			DisplayIDs = {{11288}},
			AtlasMapBossID = 5,
			[NORMAL_DIFF] = {
				{ 1,  19721 }, -- Primal Hakkari Shawl
				{ 2,  19724 }, -- Primal Hakkari Aegis
				{ 3,  19723 }, -- Primal Hakkari Kossack
				{ 4,  19722 }, -- Primal Hakkari Tabard
				{ 5,  19717 }, -- Primal Hakkari Armsplint
				{ 6,  19716 }, -- Primal Hakkari Bindings
				{ 7,  19718 }, -- Primal Hakkari Stanchion
				{ 8,  19719 }, -- Primal Hakkari Girdle
				{ 9,  19720 }, -- Primal Hakkari Sash
				{ 11, 22637 }, -- Primal Hakkari Idol
				{ 16, 19872 }, -- Swift Razzashi Raptor
				{ 17, 20038 }, -- Mandokir's Sting
				{ 18, 19867 }, -- Bloodlord's Defender
				{ 19, 19866 }, -- Warblade of the Hakkari
				{ 20, 19874 }, -- Halberd of Smiting
				{ 22, 19878 }, -- Bloodsoaked Pauldrons
				{ 23, 19870 }, -- Hakkari Loa Cloak
				{ 24, 19869 }, -- Blooddrenched Grips
				{ 25, 19895 }, -- Bloodtinged Kilt
				{ 26, 19877 }, -- Animist's Leggings
				{ 27, 19873 }, -- Overlord's Crimson Band
				{ 28, 19863 }, -- Primalist's Seal
				{ 29, 19893 }, -- Zanzil's Seal
			},
		},
		{ -- ZGGrilek
			name = AL["Gri'lek"],
			npcID = 15082,
			Level = 999,
			DisplayIDs = {{8390}},
			AtlasMapBossID = 6,
			[NORMAL_DIFF] = {
				{ 1,  19961 }, -- Gri'lek's Grinder
				{ 2,  19962 }, -- Gri'lek's Carver
				{ 4,  19939 }, -- Gri'lek's Blood
			},
		},
		{ -- ZGHazzarah
			name = AL["Hazza'rah"],
			npcID = 15083,
			Level = 999,
			DisplayIDs = {{15267}},
			AtlasMapBossID = 6,
			[NORMAL_DIFF] = {
				{ 1,  19967 }, -- Thoughtblighter
				{ 2,  19968 }, -- Fiery Retributer
				{ 4,  19942 }, -- Hazza'rah's Dream Thread
			},
		},
		{ -- ZGRenataki
			name = AL["Renataki"],
			npcID = 15084,
			Level = 999,
			DisplayIDs = {{15268}},
			AtlasMapBossID = 6,
			[NORMAL_DIFF] = {
				{ 1,  19964 }, -- Renataki's Soul Conduit
				{ 2,  19963 }, -- Pitchfork of Madness
				{ 4,  19940 }, -- Renataki's Tooth
			},
		},
		{ -- ZGWushoolay
			name = AL["Wushoolay"],
			npcID = 15085,
			Level = 999,
			DisplayIDs = {{15269}},
			AtlasMapBossID = 6,
			[NORMAL_DIFF] = {
				{ 1,  19993 }, -- Hoodoo Hunting Bow
				{ 2,  19965 }, -- Wushoolay's Poker
				{ 4,  19941 }, -- Wushoolay's Mane
			},
		},
		{ -- ZGGahzranka
			name = AL["Gahz'ranka"],
			npcID = 15114,
			Level = 999,
			DisplayIDs = {{15288}},
			AtlasMapBossID = 7,
			[NORMAL_DIFF] = {
				{ 1,  19945 }, -- Foror's Eyepatch
				{ 2,  19944 }, -- Nat Pagle's Fish Terminator
				{ 4,  19947 }, -- Nat Pagle's Broken Reel
				{ 5,  19946 }, -- Tigule's Harpoon
				{ 7,  22739 }, -- Tome of Polymorph: Turtle
			},
		},
		{ -- ZGThekal
			name = AL["High Priest Thekal"],
			npcID = 14509,
			Level = 999,
			DisplayIDs = {{15216}},
			AtlasMapBossID = 8,
			[NORMAL_DIFF] = {
				{ 1,  19721 }, -- Primal Hakkari Shawl
				{ 2,  19724 }, -- Primal Hakkari Aegis
				{ 3,  19723 }, -- Primal Hakkari Kossack
				{ 4,  19722 }, -- Primal Hakkari Tabard
				{ 5,  19717 }, -- Primal Hakkari Armsplint
				{ 6,  19716 }, -- Primal Hakkari Bindings
				{ 7,  19718 }, -- Primal Hakkari Stanchion
				{ 8,  19719 }, -- Primal Hakkari Girdle
				{ 9,  19720 }, -- Primal Hakkari Sash
				{ 16, 19902 }, -- Swift Zulian Tiger
				{ 17, 19897 }, -- Betrayer's Boots
				{ 18, 19896 }, -- Thekal's Grasp
				{ 20, 19899 }, -- Ritualistic Legguards
				{ 21, 20260 }, -- Seafury Leggings
				{ 22, 20266 }, -- Peacekeeper Leggings
				{ 23, 19898 }, -- Seal of Jin
				{ 24, 19901 }, -- Zulian Slicer
			},
		},
		{ -- ZGArlokk
			name = AL["High Priestess Arlokk"],
			npcID = 14515,
			Level = 999,
			DisplayIDs = {{15218}},
			AtlasMapBossID = 9,
			[NORMAL_DIFF] = {
				{ 1,  19721 }, -- Primal Hakkari Shawl
				{ 2,  19724 }, -- Primal Hakkari Aegis
				{ 3,  19723 }, -- Primal Hakkari Kossack
				{ 4,  19722 }, -- Primal Hakkari Tabard
				{ 5,  19717 }, -- Primal Hakkari Armsplint
				{ 6,  19716 }, -- Primal Hakkari Bindings
				{ 7,  19718 }, -- Primal Hakkari Stanchion
				{ 8,  19719 }, -- Primal Hakkari Girdle
				{ 9,  19720 }, -- Primal Hakkari Sash
				{ 16, 19910 }, -- Arlokk's Grasp
				{ 17, 19909 }, -- Will of Arlokk
				{ 19, 19913 }, -- Bloodsoaked Greaves
				{ 20, 19912 }, -- Overlord's Onyx Band
				{ 21, 19922 }, -- Arlokk's Hoodoo Stick
				{ 23, 19914 }, -- Panther Hide Sack
			},
		},
		{ -- ZGJindo
			name = AL["Jin'do the Hexxer"],
			npcID = 11380,
			Level = 999,
			DisplayIDs = {{11311}},
			AtlasMapBossID = 10,
			[NORMAL_DIFF] = {
				{ 1,  19721 }, -- Primal Hakkari Shawl
				{ 2,  19724 }, -- Primal Hakkari Aegis
				{ 3,  19723 }, -- Primal Hakkari Kossack
				{ 4,  19722 }, -- Primal Hakkari Tabard
				{ 5,  19717 }, -- Primal Hakkari Armsplint
				{ 6,  19716 }, -- Primal Hakkari Bindings
				{ 7,  19718 }, -- Primal Hakkari Stanchion
				{ 8,  19719 }, -- Primal Hakkari Girdle
				{ 9,  19720 }, -- Primal Hakkari Sash
				{ 11, 22637 }, -- Primal Hakkari Idol
				{ 16, 19885 }, -- Jin'do's Evil Eye
				{ 17, 19891 }, -- Jin'do's Bag of Whammies
				{ 18, 19890 }, -- Jin'do's Hexxer
				{ 19, 19884 }, -- Jin'do's Judgement
				{ 21, 19886 }, -- The Hexxer's Cover
				{ 22, 19875 }, -- Bloodstained Coif
				{ 23, 19888 }, -- Overlord's Embrace
				{ 24, 19929 }, -- Bloodtinged Gloves
				{ 25, 19894 }, -- Bloodsoaked Gauntlets
				{ 26, 19889 }, -- Blooddrenched Leggings
				{ 27, 19887 }, -- Bloodstained Legplates
				{ 28, 19892 }, -- Animist's Boots
			},
		},
		{ -- ZGHakkar
			name = AL["Hakkar"],
			npcID = 14834,
			Level = 999,
			DisplayIDs = {{15295}},
			AtlasMapBossID = 11,
			[NORMAL_DIFF] = {
				{ 1,  19857 }, -- Cloak of Consumption
				{ 2,  20257, [ATLASLOOT_IT_ALLIANCE] = 20264 }, -- Seafury Gauntlets
				--{ 3,  20264, [ATLASLOOT_IT_HORDE] = 20257 }, -- Peacekeeper Gauntlets
				{ 3,  19855 }, -- Bloodsoaked Legplates
				{ 4,  19876 }, -- Soul Corrupter's Necklace
				{ 5,  19856 }, -- The Eye of Hakkar
				{ 7, 19802 }, -- Heart of Hakkar
				{ 16,  19861 }, -- Touch of Chaos
				{ 17,  19853 }, -- Gurubashi Dwarf Destroyer
				{ 18, 19862 }, -- Aegis of the Blood God
				{ 19, 19864 }, -- Bloodcaller
				{ 20, 19865 }, -- Warblade of the Hakkari
				{ 21, 19866 }, -- Warblade of the Hakkari
				{ 22, 19852 }, -- Ancient Hakkari Manslayer
				{ 23, 19859 }, -- Fang of the Faceless
				{ 24, 19854 }, -- Zin'rokh, Destroyer of Worlds
			},
		},
		{ -- ZGShared
			name = AL["High Priest Shared loot"],
			ExtraList = true,
			[NORMAL_DIFF] = {
				{ 1,  22721 }, -- Band of Servitude
				{ 2,  22722 }, -- Seal of the Gurubashi Berserker
				{ 4,  22720 }, -- Zulian Headdress
				{ 5,  22718 }, -- Blooddrenched Mask
				{ 6,  22711 }, -- Cloak of the Hakkari Worshipers
				{ 7,  22712 }, -- Might of the Tribe
				{ 8,  22715 }, -- Gloves of the Tormented
				{ 9,  22714 }, -- Sacrificial Gauntlets
				{ 10, 22716 }, -- Belt of Untapped Power
				{ 11, 22713 }, -- Zulian Scepter of Rites
			},
		},
		{ -- ZGTrash1
			name = AL["Trash"],
			ExtraList = true,
			[NORMAL_DIFF] = {
				{ 1,  20263 }, -- Gurubashi Helm
				{ 2,  20259 }, -- Shadow Panther Hide Gloves
				{ 3,  20261 }, -- Shadow Panther Hide Belt
				{ 4,  19921 }, -- Zulian Hacker
				{ 5,  19908 }, -- Sceptre of Smiting
				{ 16,  20258 }, -- Zulian Ceremonial Staff
				{ 17, 19726 }, -- Bloodvine
				{ 18, 19774 }, -- Souldarite
				{ 19, 19767 }, -- Primal Bat Leather
				{ 20, 19768 }, -- Primal Tiger Leather
				{ 7, 19706 }, -- Bloodscalp Coin
				{ 8, 19701 }, -- Gurubashi Coin
				{ 9, 19700 }, -- Hakkari Coin
				{ 10, 19699 }, -- Razzashi Coin
				{ 11, 19704 }, -- Sandfury Coin
				{ 12, 19705 }, -- Skullsplitter Coin
				{ 13, 19702 }, -- Vilebranch Coin
				{ 14, 19703 }, -- Witherbark Coin
				{ 15, 19698 }, -- Zulian Coin
				{ 22, 19708 }, -- Blue Hakkari Bijou
				{ 23, 19713 }, -- Bronze Hakkari Bijou
				{ 24, 19715 }, -- Gold Hakkari Bijou
				{ 25, 19711 }, -- Green Hakkari Bijou
				{ 26, 19710 }, -- Orange Hakkari Bijou
				{ 27, 19712 }, -- Purple Hakkari Bijou
				{ 28, 19707 }, -- Red Hakkari Bijou
				{ 29, 19714 }, -- Silver Hakkari Bijou
				{ 30, 19709 }, -- Yellow Hakkari Bijou
			},
		},
		{ -- ZGEnchants
			name = AL["Enchants"],
			ExtraList = true,
			[NORMAL_DIFF] = {
				{ 1,  19789 }, -- Prophetic Aura
				{ 2,  19787 }, -- Presence of Sight
				{ 3,  19788 }, -- Hoodoo Hex
				{ 4,  19784 }, -- Death's Embrace
				{ 5,  19790 }, -- Animist's Caress
				{ 6,  19785 }, -- Falcon's Call
				{ 7,  19786 }, -- Vodouisant's Vigilant Embrace
				{ 8,  19783 }, -- Syncretist's Sigil
				{ 9,  19782 }, -- Presence of Might
				{ 16, 20077 }, -- Zandalar Signet of Might
				{ 17, 20076 }, -- Zandalar Signet of Mojo
				{ 18, 20078 }, -- Zandalar Signet of Serenity
				{ 20, 22635 }, -- Savage Guard
			},
		},
		{ -- ZGMuddyChurningWaters
			name = AL["Muddy Churning Waters"],
			ExtraList = true,
			AtlasMapBossID = "1'",
			[NORMAL_DIFF] = {
				{ 1,  19975 }, -- Zulian Mudskunk
			},
		},
		{ -- ZGJinxedHoodooPile
			name = AL["Jinxed Hoodoo Pile"],
			ExtraList = true,
			AtlasMapBossID = "2'",
			[NORMAL_DIFF] = {
				{ 1,  19727 }, -- Blood Scythe
				{ 3,  19820 }, -- Punctured Voodoo Doll
				{ 4,  19818 }, -- Punctured Voodoo Doll
				{ 5,  19819 }, -- Punctured Voodoo Doll
				{ 6,  19814 }, -- Punctured Voodoo Doll
				{ 7,  19821 }, -- Punctured Voodoo Doll
				{ 8,  19816 }, -- Punctured Voodoo Doll
				{ 9,  19817 }, -- Punctured Voodoo Doll
				{ 10, 19815 }, -- Punctured Voodoo Doll
				{ 11, 19813 }, -- Punctured Voodoo Doll
			},
		},
	},
}

-- Trial of the Crusader / T9
data["TrialoftheCrusader"] = {
	EncounterJournalID = 757,
	InstanceID = 649,
	MapID = 4722,
    name = AL["P4 Trial of the Crusader"],
    AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "TrialOfTheCrusader",
    AtlasMapFile = "TrialOfTheCrusader",
	ContentType = RAID_CONTENT,
    -- LevelRange = {80, 80, 80},
	items = {
		{	--TrialoftheCrusader NorthrendBeasts
			name = AL["The Beasts of Northrend"],
			EncounterJournalID = 1618,
            [RAID10_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1, 47855 },	-- Icehowl Binding
                    { 2, 47857 },	-- Pauldrons of the Glacial Wilds
                    { 3, 47853 },	-- Acidmaw Treads
                    { 4, 47860 },	-- Pauldrons of the Spirit Walker
                    { 5, 47850 },	-- Bracers of the Northern Stalker
                    { 6, 47852 },	-- Dreadscale Bracers
                    { 7, 47851 },	-- Gauntlets of Mounting Anger
                    { 8, 47859 },	-- Belt of the Impaler
                    { 9, 47858 },	-- Girdle of the Frozen Reach
                    { 16, 47849 },	-- Collar of Unending Torment
                    { 17, 47854 },	-- Gormok's Band
                    { 19, 47856 },	-- Scepter of Imprisoned Souls
                    { 24, "ac3936" },
                    { 25, "ac3797" },
                },
                { -- alli
                    { 1,  47617 },	-- Icehowl Cinch
                    { 2,  47613 },	-- Shoulderpads of the Glacial Wilds
                    { 3,  47608 },	-- Acidmaw Boots
                    { 4,  47616 },	-- Shoulderguards of the Spirit Walker
                    { 5,  47610 },	-- Armbands of the Northern Stalker
                    { 6,  47611 },	-- Dreadscale Armguards
                    { 7,  47609 },	-- Gauntlets of Rising Anger
                    { 8,  47615 },	-- Belt of the Frozen Reach
                    { 9,  47614 },	-- Girdle of the Impaler
                    { 16, 47607 },	-- Collar of Ceaseless Torment
                    { 17, 47578 },	-- Carnivorous Band
                    { 19, 47612 },	-- Rod of Imprisoned Souls
                    { 24, "ac3936" },
                    { 25, "ac3797" },
                }
            ),
            [RAID10H_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  47994 },	-- Icehowl Binding
                    { 2,  47996 },	-- Pauldrons of the Glacial Wilds
                    { 3,  47992 },	-- Acidmaw Treads
                    { 4,  47999 },	-- Pauldrons of the Spirit Walker
                    { 5,  47989 },	-- Bracers of the Northern Stalker
                    { 6,  47991 },	-- Dreadscale Bracers
                    { 7,  47990 },	-- Gauntlets of Mounting Anger
                    { 8,  47998 },	-- Belt of the Impaler
                    { 9,  47997 },	-- Girdle of the Frozen Reach
                    { 16, 47988 },	-- Collar of Unending Torment
                    { 17, 47993 },	-- Gormok's Band
                    { 19, 47995 },	-- Scepter of Imprisoned Souls
                    { 21, 47242 },	-- Trophy of the Crusade
                    { 23, "ac3936" },
                    { 24, "ac3797" },
                },
                { -- alli
                    { 1,  47921 },	-- Icehowl Cinch
                    { 2,  47923 },	-- Shoulderpads of the Glacial Wilds
                    { 3,  47919 },	-- Acidmaw Boots
                    { 4,  47926 },	-- Shoulderguards of the Spirit Walker
                    { 5,  47916 },	-- Armbands of the Northern Stalker
                    { 6,  47918 },	-- Dreadscale Armguards
                    { 7,  47917 },	-- Gauntlets of Rising Anger
                    { 8,  47924 },	-- Belt of the Frozen Reach
                    { 9,  47925 },	-- Girdle of the Impaler
                    { 16, 47915 },	-- Collar of Ceaseless Torment
                    { 17, 47920 },	-- Carnivorous Band
                    { 19, 47922 },	-- Rod of Imprisoned Souls
                    { 21, 47242 },	-- Trophy of the Crusade
                    { 23, "ac3936" },
                    { 24, "ac3797" },
                }
            ),
            [RAID25_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  47257 },	-- Cloak of the Untamed Predator
                    { 2,  47256 },	-- Drape of the Refreshing Winds
                    { 3,  47264 },	-- Flowing Robes of Ascent
                    { 4,  47258 },	-- Belt of the Tenebrous Mist
                    { 5,  47259 },	-- Legwraps of the Broken Beast
                    { 6,  47262 },	-- Boots of the Harsh Winter
                    { 7,  47251 },	-- Cuirass of Cruel Intent
                    { 8,  237079 },	-- Binding of the Ice Burrower
                    { 9,  47254 },	-- Hauberk of the Towering Monstrosity
                    { 10, 47253 },	-- Boneshatter Vambraces
                    { 11, 47263 },	-- Sabatons of the Courageous
                    { 16, 47242 },	-- Trophy of the Crusade
                    { 18, 237071 },	-- Ring of the Violent Temperament
                    { 20, 237088 },	-- Barb of Tarasque
                    { 21, 237090 },	-- Stygian Bladebreaker
                    { 22, 237087 },	-- Forlorn Barrier
                    { 24, "ac3936" },
                    { 25, "ac3797" },
                },
                { -- alli
                    { 1,  46970 },	-- Drape of the Untamed Predator
                    { 2,  46976 },	-- Shawl of the Refreshing Winds
                    { 3,  46992 },	-- Flowing Vestments of Ascent
                    { 4,  46972 },	-- Cord of the Tenebrous Mist
                    { 5,  46974 },	-- Leggings of the Broken Beast
                    { 6,  46988 },	-- Boots of the Unrelenting Storm
                    { 7,  46960 },	-- Breastplate of Cruel Intent
                    { 8,  237052 },	-- Belt of the Ice Burrower
                    { 9,  46962 },	-- Chestplate of the Towering Monstrosity
                    { 10, 46961 },	-- Boneshatter Armplates
                    { 11, 46985 },	-- Boots of the Courageous
                    { 16, 47242 },	-- Trophy of the Crusade
                    { 18, 237044 },	-- Band of the Violent Temperment
                    { 20, 237062 },	-- Blade of Tarasque
                    { 21, 237064 },	-- Steel Bladebreaker
                    { 22, 237061 },	-- Crystal Plated Vanguard
                    { 24, "ac3936" },
                    { 25, "ac3797" },
                }
            ),
			[RAID25H_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  47418 },	-- Cloak of the Untamed Predator
                    { 2,  47417 },	-- Drape of the Refreshing Winds
                    { 3,  47425 },	-- Flowing Robes of Ascent
                    { 4,  47419 },	-- Belt of the Tenebrous Mist
                    { 5,  47420 },	-- Legwraps of the Broken Beast
                    { 6,  47423 },	-- Boots of the Harsh Winter
                    { 7,  47412 },	-- Cuirass of Cruel Intent
                    { 8,  47426 },	-- Binding of the Ice Burrower
                    { 9,  47415 },	-- Hauberk of the Towering Monstrosity
                    { 10, 47414 },	-- Boneshatter Vambraces
                    { 11, 47424 },	-- Sabatons of the Courageous
                    { 16, 47413 },	-- Ring of the Violent Temperament
                    { 18, 47422 },	-- Barb of Tarasque
                    { 19, 47416 },	-- Stygian Bladebreaker
                    { 20, 47421 },	-- Forlorn Barrier
                    { 22, 47242 },	-- Trophy of the Crusade
                    { 23, 47557 }, -- Regalia of the Grand Conqueror
                    { 24, 47558 }, -- Regalia of the Grand Protector
                    { 25, 47559 }, -- Regalia of the Grand Vanquisher
                    { 29, "ac3937" },
                    { 30, "ac3813" },
                },
                { -- alli
                    { 1,  46971 },	-- Drape of the Untamed Predator
                    { 2,  46977 },	-- Shawl of the Refreshing Winds
                    { 3,  46993 },	-- Flowing Vestments of Ascent
                    { 4,  46973 },	-- Cord of the Tenebrous Mist
                    { 5,  46975 },	-- Leggings of the Broken Beast
                    { 6,  46989 },	-- Boots of the Unrelenting Storm
                    { 7,  46965 },	-- Breastplate of Cruel Intent
                    { 8,  46991 },	-- Belt of the Ice Burrower
                    { 9,  46968 },	-- Chestplate of the Towering Monstrosity
                    { 10, 46967 },	-- Boneshatter Armplates
                    { 11, 46986 },	-- Boots of the Courageous
                    { 16, 46966  },	-- Band of the Violent Temperment
                    { 18, 46980  },	-- Blade of Tarasque
                    { 19, 46969  },	-- Steel Bladebreaker
                    { 20, 46964  },	-- Crystal Plated Vanguard
                    { 22, 47242 },	-- Trophy of the Crusade
                    { 23, 47557 }, -- Regalia of the Grand Conqueror
                    { 24, 47558 }, -- Regalia of the Grand Protector
                    { 25, 47559 }, -- Regalia of the Grand Vanquisher
                    { 29, "ac3937" },
                    { 30, "ac3813" },
                }
            ),
		},
        {	--TrialoftheCrusader LordJaraxxus
            name = AL["Lord Jaraxxus"],
            EncounterJournalID = 1619,
            [RAID10_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  47861 },	-- Felspark Bracers
                    { 2,  47865 },	-- Legwraps of the Demonic Messenger
                    { 3,  47863 },	-- Belt of the Bloodhoof Emissary
                    { 4,  47866 },	-- Darkspear Ritual Binding
                    { 5,  49236 },	-- Sabatons of Tortured Space
                    { 6,  47867 },	-- Warsong Poacher's Greaves
                    { 7,  47869 },	-- Armplates of the Nether Lord
                    { 8,  47870 },	-- Belt of the Nether Champion
                    { 16, 47872 },	-- Fortitude of the Infernal
                    { 17, 47864 },	-- Pendant of Binding Elements
                    { 18, 47862 },	-- Firestorm Band
                    { 19, 47868 },	-- Planestalker Band
                    { 21, 47871 },	-- Orcish Deathblade
                    { 23, "ac3996" },
                },
                { -- alli
                    { 1,  47663 },	-- Felspark Bindings
                    { 2,  47620 },	-- Leggings of the Demonic Messenger
                    { 3,  47669 },	-- Belt of the Winter Solstice
                    { 4,  47621 },	-- Girdle of the Farseer
                    { 5,  49235 },	-- Boots of Tortured Space
                    { 6,  47683 },	-- Sentinel Scouting Greaves
                    { 7,  47680 },	-- Armguards of the Nether Lord
                    { 8,  47711 },	-- Girdle of the Nether Champion
                    { 16, 47619 },	-- Amulet of Binding Elements
                    { 17, 47679 },	-- Endurance of the Infernal
                    { 18, 47618 },	-- Firestorm Ring
                    { 19, 47703 },	-- Planestalker Signet
                    { 21, 47676 },	-- Dirk of the Night Watch
                    { 23, "ac3996" },
                }
            ),
            [RAID10H_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  48000 },	-- Felspark Bracers
                    { 2,  48004 },	-- Legwraps of the Demonic Messenger
                    { 3,  48002 },	-- Belt of the Bloodhoof Emissary
                    { 4,  48005 },	-- Darkspear Ritual Binding
                    { 5,  49237 },	-- Sabatons of Tortured Space
                    { 6,  48006 },	-- Warsong Poacher's Greaves
                    { 7,  48008 },	-- Armplates of the Nether Lord
                    { 8,  48009 },	-- Belt of the Nether Champion
                    { 16, 48011 },	-- Fortitude of the Infernal
                    { 17, 48003 },	-- Pendant of Binding Elements
                    { 18, 48001 },	-- Firestorm Band
                    { 19, 48007 },	-- Planestalker Band
                    { 21, 48010 },	-- Orcish Deathblade
                    { 23, 47242 },	-- Trophy of the Crusade
                    { 25, "ac3996" },
                },
                { -- alli
                    { 1,  47927 },	-- Felspark Bindings
                    { 2,  47931 },	-- Leggings of the Demonic Messenger
                    { 3,  47929 },	-- Belt of the Winter Solstice
                    { 4,  47932 },	-- Girdle of the Farseer
                    { 5,  49238 },	-- Boots of Tortured Space
                    { 6,  47933 },	-- Sentinel Scouting Greaves
                    { 7,  47935 },	-- Armguards of the Nether Lord
                    { 8,  47937 },	-- Girdle of the Nether Champion
                    { 16, 47930 },	-- Amulet of Binding Elements
                    { 17, 47939 },	-- Endurance of the Infernal
                    { 18, 47928 },	-- Firestorm Ring
                    { 19, 47934 },	-- Planestalker Signet
                    { 21, 47938 },	-- Dirk of the Night Watch
                    { 23, 47242 },	-- Trophy of the Crusade
                    { 25, "ac3996" },
                }
            ),
            [RAID25_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  47275 },	-- Pride of the Demon Lord
                    { 2,  47274 },	-- Pants of the Soothing Touch
                    { 3,  47270 },	-- Vest of Calamitous Fate
                    { 4,  237083 },	-- Icewalker Treads
                    { 5,  237076 },	-- Armbands of Dark Determination
                    { 6,  47277 },	-- Bindings of the Autumn Willow
                    { 7,  47280 },	-- Wristwraps of Cloudy Omen
                    { 8,  237078 },	-- Bloodbath Girdle
                    { 9,  47279 },	-- Leggings of Failing Light
                    { 10, 47273 },	-- Legplates of Feverish Dedication
                    { 11, 237081 },	-- Dawnbreaker Sabatons
                    { 16, 47242 },	-- Trophy of the Crusade
                    { 18, 47272 },	-- Charge of the Eredar
                    { 19, 237070 },	-- Circle of the Darkmender
                    { 20, 47271 },	-- Solace of the Fallen
                    { 21, 47276 },	-- Talisman of Heedless Sins
                    { 22, 237073 },	-- Lurid Manifestation
                    { 24, 47266 },	-- Blood Fury
                    { 25, 47267 },	-- Death's Head Crossbow
                    { 27, "ac3997" },
                },
                { -- alli
                    { 1,  47042 },	-- Pride of the Eredar
                    { 2,  47051 },	-- Leggings of the Soothing Touch
                    { 3,  47000 },	-- Cuirass of Calamitous Fate
                    { 4,  237056 },	-- Treads of the Icewalker
                    { 5,  237049 },	-- Bracers of Dark Determination
                    { 6,  47055 },	-- Bracers of the Autumn Willow
                    { 7,  47056 },	-- Bracers of Cloudy Omen
                    { 8,  237051 },	-- Bloodbath Belt
                    { 9,  47057 },	-- Legplates of Failing Light
                    { 10, 47052 },	-- Legguards of Feverish Dedication
                    { 11, 237054 },	-- Dawnbreaker Greaves
                    { 16, 47242 },	-- Trophy of the Crusade
                    { 18, 47043 },	-- Charge of the Demon Lord
                    { 19, 237043 },	-- Ring of the Darkmender
                    { 20, 47041 },	-- Solace of the Defeated
                    { 21, 47053 },	-- Symbol of Transgression
                    { 22, 237046 },	-- Band of Deplorable Violence
                    { 24, 46996 },	-- Lionhead Slasher
                    { 25, 46994 },	-- Talonstrike
                    { 27, "ac3997" },
                }
            ),
            [RAID25H_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  47436 },	-- Pride of the Demon Lord
                    { 2,  47435 },	-- Pants of the Soothing Touch
                    { 3,  47431 },	-- Vest of Calamitous Fate
                    { 4,  47438 },	-- Bindings of the Autumn Willow
                    { 5,  47441 },	-- Wristwraps of Cloudy Omen
                    { 6,  47429 },	-- Bloodbath Girdle
                    { 7,  47440 },	-- Leggings of Failing Light
                    { 8,  47434 },	-- Legplates of Feverish Dedication
                    { 9,  47430 },	-- Dawnbreaker Sabatons
                    { 16, 47433 },	-- Charge of the Eredar
                    { 17, 47439 },	-- Circle of the Darkmender
                    { 18, 47432 },	-- Solace of the Fallen
                    { 19, 47437 },	-- Talisman of Heedless Sins
                    { 21, 47427 },	-- Blood Fury
                    { 22, 47428 },	-- Death's Head Crossbow
                    { 24, 47242 },	-- Trophy of the Crusade
                    { 25, 47557 }, -- Regalia of the Grand Conqueror
                    { 26, 47558 }, -- Regalia of the Grand Protector
                    { 27, 47559 }, -- Regalia of the Grand Vanquisher
                    { 30, "ac3997" },
                },
                { -- alli
                    { 1,  47063 },	-- Pride of the Eredar
                    { 2,  47062 },	-- Leggings of the Soothing Touch
                    { 3,  47004 },	-- Cuirass of Calamitous Fate
                    { 4,  47066 },	-- Bracers of the Autumn Willow
                    { 5,  47068 },	-- Bracers of Cloudy Omen
                    { 6,  47002 },	-- Bloodbath Belt
                    { 7,  47067 },	-- Legplates of Failing Light
                    { 8,  47061 },	-- Legguards of Feverish Dedication
                    { 9,  47003 },	-- Dawnbreaker Greaves
					{ 12, 47059 },	-- Solace of the Defeated
                    { 16, 47060 },	-- Charge of the Demon Lord
                    { 17, 47224 },	-- Ring of the Darkmender
                    { 19, 47064 },	-- Symbol of Transgression
                    { 20, 47001 },	-- Lionhead Slasher
                    { 21, 46995 },	-- Talonstrike
                    { 23, 47242 },	-- Trophy of the Crusade
                    { 24, 47557 }, -- Regalia of the Grand Conqueror
                    { 25, 47558 }, -- Regalia of the Grand Protector
                    { 26, 47559 }, -- Regalia of the Grand Vanquisher
                    { 28, "ac3997" },
                }
            ),
        },
        {	--TrialoftheCrusader FactionChampions
            name = AL["Faction Champions"],
            [RAID10_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  47873 },	-- Sunreaver Magus' Sandals
                    { 2,  47878 },	-- Sunreaver Assassin's Gloves
                    { 3,  47875 },	-- Sunreaver Ranger's Helm
                    { 4,  47876 },	-- Sunreaver Champion's Faceplate
                    { 5,  47877 },	-- Sunreaver Defender's Pauldrons
                    { 7,  47880 },	-- Binding Stone
                    { 8,  47882 },	-- Eitrigg's Oath
                    { 9,  47879 },	-- Fetish of Volatile Power
                    { 10, 47881 },	-- Vengeance of the Forsaken
                    { 16, 47874 },	-- Sunreaver Disciple's Blade
                    { 18, "ac3798" },
                },
                { -- alli
                    { 1,  47721 },	-- Sandals of the Silver Magus
                    { 2,  47719 },	-- Gloves of the Silver Assassin
                    { 3,  47718 },	-- Helm of the Silver Ranger
                    { 4,  47717 },	-- Faceplate of the Silver Champion
                    { 5,  47720 },	-- Pauldrons of the Silver Defender
                    { 7,  47728 },	-- Binding Light
                    { 8,  47727 },	-- Fervor of the Frostborn
                    { 9,  47726 },	-- Talisman of Volatile Power
                    { 10, 47725 },	-- Victor's Call
                    { 16, 47724 },	-- Blade of the Silver Disciple
                    { 18, "ac3798" },
                }
            ),
            [RAID10H_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  48012 },	-- Sunreaver Magus' Sandals
                    { 2,  48017 },	-- Sunreaver Assassin's Gloves
                    { 3,  48014 },	-- Sunreaver Ranger's Helm
                    { 4,  48015 },	-- Sunreaver Champion's Faceplate
                    { 5,  48016 },	-- Sunreaver Defender's Pauldrons
                    { 7,  48019 },	-- Binding Stone
                    { 8,  48021 },	-- Eitrigg's Oath
                    { 9,  48018 },	-- Fetish of Volatile Power
                    { 10, 48020 },	-- Vengeance of the Forsaken
                    { 16, 48013 },	-- Sunreaver Disciple's Blade
                    { 18, 47242 },	-- Trophy of the Crusade
                    { 20, "ac3798" },
                },
                { -- alli
                    { 1,  47940 },	-- Sandals of the Silver Magus
                    { 2,  47945 },	-- Gloves of the Silver Assassin
                    { 3,  47942 },	-- Helm of the Silver Ranger
                    { 4,  47943 },	-- Faceplate of the Silver Champion
                    { 5,  47944 },	-- Pauldrons of the Silver Defender
                    { 7,  47947 },	-- Binding Light
                    { 8,  47949 },	-- Fervor of the Frostborn
                    { 9,  47946 },	-- Talisman of Volatile Power
                    { 10, 47948 },	-- Victor's Call
                    { 16, 47941 },	-- Blade of the Silver Disciple
                    { 18, 47242 },	-- Trophy of the Crusade
                    { 20, "ac3798" },
                }
            ),
            [RAID25_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  47291 },	-- Shroud of Displacement
                    { 2,  47286 },	-- Belt of Biting Cold
                    { 3,  47293 },	-- Sandals of the Mourning Widow
                    { 4,  47292 },	-- Robes of the Shattered Fellowship
                    { 5,  237083 },	-- Icewalker Treads
                    { 6,  237075 },	-- Bracers of the Silent Massacre
                    { 7,  47289 },	-- Leggings of Concealed Hatred
                    { 8,  47295 },	-- Sabatons of Tremoring Earth
                    { 9,  47288 },	-- Chestplate of the Frostwolf Hero
                    { 10, 47294 },	-- Bracers of the Broken Bond
                    { 11, 237077 },	-- Belt of Bloodied Scars
                    { 16, 47242 },	-- Trophy of the Crusade
                    { 18, 237072 },	-- Band of Callous Aggression
                    { 19, 47290 },	-- Juggernaut's Vitality
                    { 21, 237091 },	-- Dual-blade Butcher
                    { 22, 237086 },	-- Bastion of Resolve
                },
                { -- alli
                    { 1,  47089 },	-- Cloak of Displacement
                    { 2,  47081 },	-- Cord of Biting Cold
                    { 3,  47092 },	-- Boots of the Mourning Widow
                    { 4,  47094 },	-- Vestments of the Shattered Fellowship
                    { 5,  237056 },	-- Treads of the Icewalker
                    { 6,  237048 },	-- Bracers of the Untold Massacre
                    { 7,  47083 },	-- Legguards of Concealed Hatred
                    { 8,  47090 },	-- Boots of Tremoring Earth
                    { 9,  47082 },	-- Chestplate of the Frostborn Hero
                    { 10, 47093 },	-- Vambraces of the Broken Bond
                    { 11, 237050 },	-- Girdle of Bloodied Scars
                    { 16, 47242 },	-- Trophy of the Crusade
                    { 18, 237045 },	-- Ring of Callous Aggression
                    { 19, 47080 },	-- Satrina's Impeding Scarab
                    { 21, 237065 },	-- Justicebringer
                    { 22, 237060 },	-- Bastion of Purity
                }
            ),
            [RAID25H_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  47452 },	-- Shroud of Displacement
                    { 2,  47447 },	-- Belt of Biting Cold
                    { 3,  47454 },	-- Sandals of the Mourning Widow
                    { 4,  47453 },	-- Robes of the Shattered Fellowship
                    { 5,  47445 },	-- Icewalker Treads
                    { 6,  47442 },	-- Bracers of the Silent Massacre
                    { 7,  47450 },	-- Leggings of Concealed Hatred
                    { 8,  47456 },	-- Sabatons of Tremoring Earth
                    { 9,  47449 },	-- Chestplate of the Frostwolf Hero
                    { 10, 47455 },	-- Bracers of the Broken Bond
                    { 11, 47444 },	-- Belt of Bloodied Scars
                    { 16, 47443 },	-- Band of Callous Aggression
                    { 17, 47451 },	-- Juggernaut's Vitality
                    { 19, 47446 },	-- Dual-blade Butcher
                    { 20, 47448 },	-- Bastion of Resolve
                    { 22, 47242 },	-- Trophy of the Crusade
                    { 23, 47557 }, -- Regalia of the Grand Conqueror
                    { 24, 47558 }, -- Regalia of the Grand Protector
                    { 25, 47559 }, -- Regalia of the Grand Vanquisher
                },
                { -- alli
                    { 1,  47095 },	-- Cloak of Displacement
                    { 2,  47084 },	-- Cord of Biting Cold
                    { 3,  47097 },	-- Boots of the Mourning Widow
                    { 4,  47096 },	-- Vestments of the Shattered Fellowship
                    { 5,  47077 },	-- Treads of the Icewalker
                    { 6,  47074 },	-- Bracers of the Untold Massacre
                    { 7,  47087 },	-- Legguards of Concealed Hatred
                    { 8,  47099 },	-- Boots of Tremoring Earth
                    { 9,  47086 },	-- Chestplate of the Frostborn Hero
                    { 10, 47098 },	-- Vambraces of the Broken Bond
                    { 11, 47076 },	-- Girdle of Bloodied Scars
                    { 13, 47088 },	-- Satrina's Impeding Scarab
                    { 16, 47075 },	-- Ring of Callous Aggression
                    { 18, 47078 },	-- Justicebringer
                    { 19, 47085 },	-- Bastion of Purity
                    { 21, 47242 },	-- Trophy of the Crusade
                    { 22, 47557 }, -- Regalia of the Grand Conqueror
                    { 23, 47558 }, -- Regalia of the Grand Protector
                    { 24, 47559 }, -- Regalia of the Grand Vanquisher
                }
            ),
        },
        {	--TrialoftheCrusader TwinValkyrs
            name = AL["The Twin Val'kyr"],
            EncounterJournalID = 1622,
            [RAID10_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  47889 },	-- Looming Shadow Wraps
                    { 2,  49232 },	-- Sandals of the Grieving Soul
                    { 3,  47891 },	-- Helm of the High Mesa
                    { 4,  47887 },	-- Vest of Shifting Shadows
                    { 5,  47893 },	-- Sen'jin Ritualist Gloves
                    { 6,  47885 },	-- Greaves of the Lingering Vortex
                    { 8,  47890 },	-- Darkbane Amulet
                    { 9,  47888 },	-- Band of the Twin Val'kyr
                    { 10, 47913 },	-- Lightbane Focus
                    { 16, 47886 },	-- Nemesis Blade
                    { 17, 47884 },	-- Edge of Agony
                    { 18, 47892 },	-- Illumination
                    { 19, 47883 },	-- Widebarrel Flintlock
                    { 21, "ac3799" },
                },
                { -- alli
                    { 1,  47745 },	-- Gloves of Looming Shadow
                    { 2,  49231 },	-- Boots of the Grieving Soul
                    { 3,  47746 },	-- Helm of the Snowy Grotto
                    { 4,  47739 },	-- Armor of Shifting Shadows
                    { 5,  47744 },	-- Gloves of the Azure Prophet
                    { 6,  47738 },	-- Sabatons of the Lingering Vortex
                    { 8,  47747 },	-- Darkbane Pendant
                    { 9,  47700 },	-- Loop of the Twin Val'kyr
                    { 10, 47742 },	-- Chalice of Benedictus
                    { 16, 47736 },	-- Icefall Blade
                    { 17, 47737 },	-- Reckoning
                    { 18, 47743 },	-- Enlightenment
                    { 19, 47740 },	-- The Diplomat
                    { 21, "ac3799" },
                }
            ),
            [RAID10H_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  48028 },	-- Looming Shadow Wraps
                    { 2,  49233 },	-- Sandals of the Grieving Soul
                    { 3,  48034 },	-- Helm of the High Mesa
                    { 4,  48026 },	-- Vest of Shifting Shadows
                    { 5,  48038 },	-- Sen'jin Ritualist Gloves
                    { 6,  48024 },	-- Greaves of the Lingering Vortex
                    { 8,  48030 },	-- Darkbane Amulet
                    { 9,  48027 },	-- Band of the Twin Val'kyr
                    { 10, 48032 },	-- Lightbane Focus
                    { 12, 48025 },	-- Nemesis Blade
                    { 13, 48023 },	-- Edge of Agony
                    { 14, 48036 },	-- Illumination
                    { 15, 48022 },	-- Widebarrel Flintlock

                    { 16, 47242 },	-- Trophy of the Crusade
                    { 18, 48703 }, --  The Facebreaker
                    { 19, 48699 }, --  Blood and Glory
                    { 20, 48693 }, --  Heartsmasher
                    { 21, 48701 }, --  Spellharvest
                    { 22, 48697 }, -- Frenzystrike Longbow
                    { 23, 48705 }, -- Attrition
                    { 24, 48695 }, -- Mor'kosh

                    { 26, "ac3799" },
                },
                { -- alli
                    { 1,  47956 },	-- Gloves of Looming Shadow
                    { 2,  49234 },	-- Boots of the Grieving Soul
                    { 3,  47959 },	-- Helm of the Snowy Grotto
                    { 4,  47954 },	-- Armor of Shifting Shadows
                    { 5,  47961 },	-- Gloves of the Azure Prophet
                    { 6,  47952 },	-- Sabatons of the Lingering Vortex
                    { 8,  47957 },	-- Darkbane Pendant
                    { 9,  47955 },	-- Loop of the Twin Val'kyr
                    { 10, 47958 },	-- Chalice of Benedictus
                    { 12, 47953 },	-- Icefall Blade
                    { 13, 47951 },	-- Reckoning
                    { 14, 47960 },	-- Enlightenment
                    { 15, 47950 },	-- The Diplomat

                    { 16, 47242 },	-- Trophy of the Crusade
                    { 18, 48712 }, --  The Spinebreaker
                    { 19, 48714 }, --  Honor of the Fallen
                    { 20, 48709 }, --  Heartcrusher
                    { 21, 48708 }, --  Spellstorm Blade
                    { 22, 48711 }, -- Rhok'shalla the Shadow's Bane
                    { 23, 48710 }, --  Paragon's Breadth
                    { 24, 48713 }, --  Lothar's Edge

                    { 26, "ac3799" },
                }
            ),
            [RAID25_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  47301 },	-- Skyweaver Vestments
                    { 2,  47306 },	-- Dark Essence Bindings
                    { 3,  47308 },	-- Belt of Pale Thorns
                    { 4,  237080 },	-- Belt of the Pitiless Killer
                    { 5,  237082 },	-- Greaves of Ruthless Judgment
                    { 6,  47310 },	-- Chestplate of the Frozen Lake
                    { 7,  237074 },	-- Armguards of the Shieldmaiden
                    { 8,  47304 },	-- Legplates of Ascension
                    { 10, 47307 },	-- Cry of the Val'kyr
                    { 11, 47305 },	-- Legionnaire's Gorget
                    { 12, 47297 },	-- The Executioner's Vice
                    { 13, 47303 },	-- Death's Choice
                    { 14, 47309 },	-- Mystifying Charm
                    { 16, 47242 },	-- Trophy of the Crusade
                    { 18, 47300 },	-- Gouge of the Frigid Heart
                    { 19, 237093 },	-- Twin's Pact
                    { 21, "ac3815" },
                },
                { -- alli
                    { 1,  47126 },	-- Skyweaver Robes
                    { 2,  47141 },	-- Bindings of Dark Essence
                    { 3,  237053 },	-- Belt of the Merciless Killer
                    { 4,  47140 },	-- Cord of Pale Thorns
                    { 5,  237055 },	-- Sabatons of Ruthless Judgment
                    { 6,  47142 },	-- Breastplate of the Frozen Lake
                    { 7,  237047 },	-- Bracers of the Shieldmaiden
                    { 8,  47121 },	-- Legguards of Ascension
                    { 10, 47116 },	-- The Arbiter's Muse
                    { 11, 47105 },	-- The Executioner's Malice
                    { 12, 47139 },	-- Wail of the Val'kyr
                    { 13, 47115 },	-- Death's Verdict
                    { 14, 47138 },	-- Chalice of Searing Light
                    { 16, 47242 },	-- Trophy of the Crusade
                    { 18, 47104 },	-- Twin Spike
                    { 19, 237067 },	-- Lupine Longstaff
                    { 21, "ac3815" },
                }
            ),
            [RAID25H_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  47462 },	-- Skyweaver Vestments
                    { 2,  47467 },	-- Dark Essence Bindings
                    { 3,  47469 },	-- Belt of Pale Thorns
                    { 4,  47460 },	-- Belt of the Pitiless Killer
                    { 5,  47457 },	-- Greaves of Ruthless Judgment
                    { 6,  47471 },	-- Chestplate of the Frozen Lake
                    { 7,  47459 },	-- Armguards of the Shieldmaiden
                    { 8,  47465 },	-- Legplates of Ascension
                    { 10, 47468 },	-- Cry of the Val'kyr
                    { 11, 47466 },	-- Legionnaire's Gorget
                    { 12, 47458 },	-- The Executioner's Vice
                    { 13, 47464 },	-- Death's Choice
                    { 14, 47470 },	-- Mystifying Charm
                    { 16, 47461 },	-- Gouge of the Frigid Heart
                    { 17, 47463 },	-- Twin's Pact
                    { 19, 47242 },	-- Trophy of the Crusade
                    { 20, 47557 }, -- Regalia of the Grand Conqueror
                    { 21, 47558 }, -- Regalia of the Grand Protector
                    { 22, 47559 }, -- Regalia of the Grand Vanquisher
                    { 23, 47513 }, -- Orgrim's Deflector
                    { 24, 47528 }, -- Cudgel of the Damned
                    { 25, 47518 }, -- Mortalis
                    { 26, 47520 }, -- Grievance
                    { 27, 47523 }, -- Fezzik's Autocannon
                    { 28, 47525 }, -- Sufferance
                    { 29, 47516 }, -- Fleshrender
                    { 30, "ac3815" },
                },
                { -- alli
                    { 1,  47129 },	-- Skyweaver Robes
                    { 2,  47143 },	-- Bindings of Dark Essence
                    { 3,  47112 },	-- Belt of the Merciless Killer
                    { 4,  47145 },	-- Cord of Pale Thorns
                    { 5,  47109 },	-- Sabatons of Ruthless Judgment
                    { 6,  47147 },	-- Breastplate of the Frozen Lake
                    { 7,  47111 },	-- Bracers of the Shieldmaiden
                    { 8,  47132 },	-- Legguards of Ascension
                    { 10, 47133 },	-- The Arbiter's Muse
                    { 11, 47110 },	-- The Executioner's Malice
                    { 12, 47144 },	-- Wail of the Val'kyr
                    { 14, 47131 },	-- Death's Verdict
                    { 15, "ac3815" },
                    { 16, 47146 },	-- Chalice of Searing Light
                    { 17, 47113 },	-- Twin Spike
                    { 18, 47130 },	-- Lupine Longstaff
                    { 19, 47506 }, -- Silverwing Defender
                    { 20, 47526 }, -- Remorseless
                    { 21, 47517 }, -- Blade of the Unbroken Covenant
                    { 22, 47519 }, -- Catastrophe
                    { 23, 47521 }, -- BRK-1000
                    { 24, 47524 }, -- Clemency
                    { 25, 47515 }, -- Decimation
                    { 27, 47242 },	-- Trophy of the Crusade
                    { 28, 47557 }, -- Regalia of the Grand Conqueror
                    { 29, 47558 }, -- Regalia of the Grand Protector
                    { 30, 47559 }, -- Regalia of the Grand Vanquisher
                }
            ),
        },
        {	--TrialoftheCrusader Anubarak
            name = AL["Anub'arak"],
            EncounterJournalID = 1623,
            [RAID10_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  47906 },	-- Robes of the Sleepless
                    { 2,  47909 },	-- Belt of the Eternal
                    { 3,  47904 },	-- Shoulderpads of the Snow Bandit
                    { 4,  47897 },	-- Helm of the Crypt Lord
                    { 5,  47901 },	-- Pauldrons of the Shadow Hunter
                    { 6,  47896 },	-- Stoneskin Chestplate
                    { 7,  47902 },	-- Legplates of Redeemed Blood
                    { 8,  47908 },	-- Sunwalker Legguards
                    { 10, 47899 },	-- Ardent Guard
                    { 11, 47903 },	-- Forsaken Bonecarver
                    { 12, 47898 },	-- Frostblade Hatchet
                    { 13, 47894 },	-- Mace of the Earthborn Chieftain
                    { 14, 47905 },	-- Blackhorn Bludgeon
                    { 16, 47911 },	-- Anguish
                    { 17, 47900 },	-- Perdition
                    { 18, 47910 },	-- Aegis of the Coliseum
                    { 19, 47895 },	-- Pride of the Kor'kron
                    { 20, 47907 },	-- Darkmaw Crossbow
                    { 24, "ac3917" },
                    { 25, "ac3800" },
                },
                { -- alli
                    { 1,  47838 },	-- Vestments of the Sleepless
                    { 2,  47837 },	-- Cinch of the Undying
                    { 3,  47832 },	-- Spaulders of the Snow Bandit
                    { 4,  47813 },	-- Helmet of the Crypt Lord
                    { 5,  47829 },	-- Pauldrons of the Timeless Hunter
                    { 6,  47811 },	-- Chestguard of the Warden
                    { 7,  47836 },	-- Legplates of the Immortal Spider
                    { 8,  47830 },	-- Legplates of the Silver Hand
                    { 10, 47810 },	-- Crusader's Glory
                    { 11, 47814 },	-- Westfall Saber
                    { 12, 47808 },	-- The Lion's Maw
                    { 13, 47809 },	-- Argent Resolve
                    { 14, 47816 },	-- The Grinder
                    { 16, 47834 },	-- Fordragon Blades
                    { 17, 47815 },	-- Cold Convergence
                    { 18, 47835 },	-- Bulwark of the Royal Guard
                    { 19, 47812 },	-- Vigilant Ward
                    { 20, 47741 },	-- Baelgun's Heavy Crossbow
                    { 24, "ac3917" },
                    { 25, "ac3800" },
                }
            ),
            [RAID10H_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  48669 }, -- Cloak of the Triumphant Combatant
                    { 2,  48668 }, -- Cloak of Serrated Blades
                    { 3,  48670 }, -- Cloak of the Unflinching Guardian
                    { 4,  48666 }, -- Drape of the Sunreavers
                    { 5,  48667 }, -- Shawl of the Devout Crusader
                    { 7,  48051 },	-- Robes of the Sleepless
                    { 8,  48054 },	-- Belt of the Eternal
                    { 9,  48049 },	-- Shoulderpads of the Snow Bandit
                    { 10, 48042 },	-- Helm of the Crypt Lord
                    { 11, 48046 },	-- Pauldrons of the Shadow Hunter
                    { 12, 48041 },	-- Stoneskin Chestplate
                    { 13, 48047 },	-- Legplates of Redeemed Blood
                    { 14, 48053 },	-- Sunwalker Legguards
                    { 16, 48044 },	-- Ardent Guard
                    { 17, 48048 },	-- Forsaken Bonecarver
                    { 18, 48043 },	-- Frostblade Hatchet
                    { 19, 48039 },	-- Mace of the Earthborn Chieftain
                    { 20, 48050 },	-- Blackhorn Bludgeon
                    { 22, 48056 },	-- Anguish
                    { 23, 48045 },	-- Perdition
                    { 24, 48055 },	-- Aegis of the Coliseum
                    { 25, 48040 },	-- Pride of the Kor'kron
                    { 26, 48052 },	-- Darkmaw Crossbow
                    { 28, "ac3917" },
                    { 29, "ac3918" },
                    { 30, "ac3800" },
                },
                { -- alli
                    { 1,  48674 }, -- Cloak of the Victorious Combatant
                    { 2,  48673 }, -- Cloak of the Silver Covenant
                    { 3,  48675 }, -- Cloak of the Unmoving Guardian
                    { 4,  48671 }, -- Drape of Bitter Incantation
                    { 5,  48672 }, -- Shawl of Fervent Crusader
                    { 7,  47974 },	-- Vestments of the Sleepless
                    { 8,  47977 },	-- Cinch of the Undying
                    { 9,  47972 },	-- Spaulders of the Snow Bandit
                    { 10, 47965 },	-- Headpiece of the Crypt Lord
                    { 11, 47969 },	-- Pauldrons of the Timeless Hunter
                    { 12, 47964 },	-- Chestguard of the Warden
                    { 13, 47976 },	-- Legplates of the Immortal Spider
                    { 14, 47970 },	-- Legplates of the Silver Hand
                    { 16, 47967 },	-- Crusader's Glory
                    { 17, 47971 },	-- Westfall Saber
                    { 18, 47966 },	-- The Lion's Maw
                    { 19, 47962 },	-- Argent Resolve
                    { 20, 47973 },	-- The Grinder
                    { 22, 47979 },	-- Fordragon Blades
                    { 23, 47968 },	-- Cold Convergence
                    { 24, 47978 },	-- Bulwark of the Royal Guard
                    { 25, 47963 },	-- Vigilant Ward
                    { 26, 47975 },	-- Baelgun's Heavy Crossbow
                    { 28, "ac3917" },
                    { 29, "ac3918" },
                    { 30, "ac3800" },
                }
            ),
            [RAID25_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  47328 },	-- Maiden's Adoration
                    { 2,  47320 },	-- Might of the Nerub
                    { 3,  48669 }, -- Cloak of the Triumphant Combatant
                    { 4,  48668 }, -- Cloak of Serrated Blades
                    { 5,  48670 }, -- Cloak of the Unflinching Guardian
                    { 6,  48666 }, -- Drape of the Sunreavers
                    { 7,  48667 }, -- Shawl of the Devout Crusader
                    { 8,  47324 },	-- Bindings of the Ashen Saint
                    { 9,  47326 },	-- Handwraps of the Lifeless Touch
                    { 10, 47317 },	-- Breeches of the Deepening Void
                    { 11, 47321 },	-- Boots of the Icy Floe
                    { 12, 47318 },	-- Leggings of the Awakening
                    { 13, 47325 },	-- Cuirass of Flowing Elements
                    { 14, 47311 },	-- Waistguard of Deathly Dominion
                    { 15, 47319 },	-- Leggings of the Lurking Threat
                    { 16, 47330 },	-- Gauntlets of Bitter Reprisal
                    { 17, 47323 },	-- Girdle of the Forgotten Martyr
                    { 18, 47312 },	-- Greaves of the Saronite Citadel
                    { 20, 47242 },	-- Trophy of the Crusade
                    { 22, 237069 },	-- Band of the Traitor King
                    { 23, 47316 },	-- Reign of the Dead
                    { 25, 237089 },	-- Hellscream Slicer
                    { 26, 237084 },	-- Suffering's End
                    { 27, 237092 },	-- Hellion Glaive
                    { 28, 237085 },	-- Ardent Guard
                    { 29, "ac3916" },
                    { 30, "ac3816" },
                },
                { -- alli
                    { 1,  47225 },	-- Maiden's Favor
                    { 2,  47183 },	-- Strength of the Nerub
                    { 3,  48674 }, -- Cloak of the Victorious Combatant
                    { 4,  48673 }, -- Cloak of the Silver Covenant
                    { 5,  48675 }, -- Cloak of the Unmoving Guardian
                    { 6,  48671 }, -- Drape of Bitter Incantation
                    { 7,  48672 }, -- Shawl of Fervent Crusader
                    { 8,  47203 },	-- Armbands of the Ashen Saint
                    { 9,  47235 },	-- Gloves of the Lifeless Touch
                    { 10, 47187 },	-- Leggings of the Deepening Void
                    { 11, 47194 },	-- Footpads of the Icy Floe
                    { 12, 47186 },	-- Legwraps of the Awakening
                    { 13, 47204 },	-- Chestguard of Flowing Elements
                    { 14, 47152 },	-- Belt of Deathly Dominion
                    { 15, 47184 },	-- Legguards of the Lurking Threat
                    { 16, 47234 },	-- Gloves of Bitter Reprisal
                    { 17, 47195 },	-- Belt of the Forgotten Martyr
                    { 18, 47150 },	-- Greaves of the 7th Legion
                    { 20, 47242 },	-- Trophy of the Crusade
                    { 22, 237042 },	-- Signet of the Traitor King
                    { 23, 47182 },	-- Reign of the Unliving
                    { 25, 237063 },	-- Stormpike Cleaver
                    { 26, 237059 },	-- Misery's End
                    { 27, 237066 },	-- Archon Glaive
                    { 28, 237068 },	-- Crusader's Glory
                    { 29, "ac3916" },
                    { 30, "ac3816" },
                }
            ),
            [RAID25H_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  47490 },	-- Maiden's Adoration
                    { 2,  47481 },	-- Might of the Nerub
                    { 3,  47546 }, -- Sylvanas' Cunning
                    { 4,  47550 }, -- Cairne's Endurance
                    { 5,  47548 }, -- Garrosh's Rage
                    { 6,  47551 }, -- Aethas' Intensity
                    { 7,  47554 }, -- Lady Liadrin's Conviction
                    { 8,  47485 },	-- Bindings of the Ashen Saint
                    { 9,  47487 },	-- Handwraps of the Lifeless Touch
                    { 10, 47478 },	-- Breeches of the Deepening Void
                    { 11, 47482 },	-- Boots of the Icy Floe
                    { 12, 47474 },	-- Armbands of Dark Determination
                    { 13, 47479 },	-- Leggings of the Awakening
                    { 14, 47486 },	-- Cuirass of Flowing Elements
                    { 15, 47472 },	-- Waistguard of Deathly Dominion
                    { 16, 47480 },	-- Leggings of the Lurking Threat
                    { 17, 47492 },	-- Gauntlets of Bitter Reprisal
                    { 18, 47484 },	-- Girdle of the Forgotten Martyr
                    { 19, 47473 },	-- Greaves of the Saronite Citadel
                    { 20, 47476 },	-- Band of the Traitor King
                    { 21, 47489 },	-- Lurid Manifestation
                    { 22, 47477 },	-- Reign of the Dead
                    { 23, 47475 },	-- Hellscream Slicer
                    { 24, 47483 },	-- Suffering's End
                    { 25, 47491 },	-- Hellion Glaive
                    { 26, 47242 },	-- Trophy of the Crusade
                    { 28, "ac3916" },
                    { 29, "ac3812" },
                    { 30, "ac3816" },
                },
                { -- alli
                    { 1,  47238 },	-- Maiden's Favor / Maiden's Adoration
                    { 2,  47192 },	-- Strength of the Nerub / Might of the Nerub
                    { 3,  47208 },	-- Armbands of the Ashen Saint / Bindings of the Ashen Saint
                    { 4,  47236 },	-- Gloves of the Lifeless Touch / Handwraps of the Lifeless Touch
                    { 5, 47189 },	-- Leggings of the Deepening Void / Breeches of the Deepening Void
                    { 6, 47205 },	-- Footpads of the Icy Floe / Boots of the Icy Floe
                    { 7, 47155 },	-- Bracers of Dark Determination / Armbands of Dark Determination
                    { 8, 47190 },	-- Legwraps of the Awakening / Leggings of the Awakening
                    { 9, 47209 },	-- Chestguard of Flowing Elements / Cuirass of Flowing Elements
                    { 10, 47153 },	-- Belt of Deathly Dominion / Waistguard of Deathly Dominion
                    { 11, 47191 },	-- Legguards of the Lurking Threat / Leggings of the Lurking Threat
                    { 12, 47240 },	-- Gloves of Bitter Reprisal / Gauntlets of Bitter Reprisal
                    { 13, 47207 },	-- Belt of the Forgotten Martyr / Girdle of the Forgotten Martyr
                    { 14, 47154 },	-- Greaves of the 7th Legion / Greaves of the Saronite Citadel
                    { 15, 47242 },	-- Trophy of the Crusade                    
                    { 16, 47237 },	-- Band of Deplorable Violence / Band of the Traitor King
                    { 17, 47157 },	-- Signet of the Traitor King / Lurid Manifestation
                    { 18, 47156 },	-- Stormpike Cleaver / Hellscream Slicer
                    { 19, 47206 },	-- Misery's End / Suffering's End
                    { 20, 47239 },	-- Archon Glaive / Hellion Glaive
                    { 22, 47188 },	-- Reign of the Unliving / Reign of the Dead
                    { 23, 47545 },  -- Vereesa's Dexterity
                    { 24, 47549 },  -- Magni's Resolution
                    { 25, 47547 },  -- Varian's Furor
                    { 26, 47552 },  -- Jaina's Radiance
                    { 27, 47553 },  -- Bolvar's Devotion
                    { 28, "ac3916" },
                    { 29, "ac3812" },
                    { 30, "ac3816" },
                }
            ),
        },
        {	-- Argent Crusade Tribute Chest
            name = format(AL["Argent Crusade Tribute Chest"]),
            --EncounterJournalID = 1623,
            [RAID10H_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    headerLines = {5},
                    { 5, "INV_Box_01", nil, format(AL["%s Attempts left"], "50"), format(AL["Includes the loot from %s"], "1-49") },
                    { 6, 49046 }, -- Swift Horde Wolf
                },
                { -- alli
                    headerLines = {5},
                    { 5, "INV_Box_01", nil, format(AL["%s Attempts left"], "50"), format(AL["Includes the loot from %s"], "1-49") },
                    { 6, 49044 }, -- Swift Alliance Steed
                }
            ),
            [RAID25H_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    headerLines = {5},
                    { 5, "INV_Box_01", nil, format(AL["%s Attempts left"], "50"), format(AL["Includes the loot from %s"], "1-49") },
                    { 6, 49098 }, -- Crusader's Black Warhorse
                },
                { -- alli
                    headerLines = {5},
                    { 5, "INV_Box_01", nil, format(AL["%s Attempts left"], "50"), format(AL["Includes the loot from %s"], "1-49") },
                    { 6, 49096 }, -- Crusader's White Warhorse
                }
            ),
        },
        {	--TrialoftheCrusader NorthrendBeasts
            name = AL["Patterns"],
            ExtraList = true,
            [NORMAL_DIFF] = AtlasLoot:GetRetByFaction(
                { -- horde
                    { 1,  47640 },	-- Plans: Breastplate of the White Knight (p2 450)
                    { 2,  47641 },	-- Plans: Saronite Swordbreakers (p2 450)
                    { 3,  47642 },	-- Plans: Sunforged Bracers (p2 450)
                    { 4,  47643 },	-- Plans: Sunforged Breastplate (p2 450)
                    { 5,  47644 },	-- Plans: Titanium Razorplate (p2 450)
                    { 6,  47645 },	-- Plans: Titanium Spikeguards (p2 450)
                    { 8,  47646 },	-- Pattern: Black Chitin Bracers (p7 450)
                    { 9,  47647 },	-- Pattern: Bracers of Swift Death (p7 450)
                    { 10, 47648 },	-- Pattern: Crusader's Dragonscale Bracers (p7 450)
                    { 11, 47649 },	-- Pattern: Crusader's Dragonscale Breastplate (p7 450)
                    { 12, 47650 },	-- Pattern: Ensorcelled Nerubian Breastplate (p7 450)
                    { 13, 47651 },	-- Pattern: Knightbane Carapace (p7 450)
                    { 14, 47652 },	-- Pattern: Lunar Eclipse Chestguard (p7 450)
                    { 15, 47653 },	-- Pattern: Moonshadow Armguards (p7 450)
                    { 16, 47639 },	-- Pattern: Bejeweled Wizard's Bracers (p8 450)
                    { 17, 47638 },	-- Pattern: Merlin's Robe (p8 450)
                    { 18, 47637 },	-- Pattern: Royal Moonshroud Bracers (p8 450)
                    { 19, 47636 },	-- Pattern: Royal Moonshroud Robe (p8 450)
                },
                { -- alli
                    { 1,  47622 },	-- Plans: Breastplate of the White Knight (p2 450)
                    { 2,  47623 },	-- Plans: Saronite Swordbreakers (p2 450)
                    { 3,  47627 },	-- Plans: Sunforged Bracers (p2 450)
                    { 4,  47626 },	-- Plans: Sunforged Breastplate (p2 450)
                    { 5,  47624 },	-- Plans: Titanium Razorplate (p2 450)
                    { 6,  47625 },	-- Plans: Titanium Spikeguards (p2 450)
                    { 8,  47629 },	-- Pattern: Black Chitin Bracers (p7 450)
                    { 9,  47635 },	-- Pattern: Bracers of Swift Death (p7 450)
                    { 10,  47631 },	-- Pattern: Crusader's Dragonscale Bracers (p7 450)
                    { 11, 47630 },	-- Pattern: Crusader's Dragonscale Breastplate (p7 450)
                    { 12, 47628 },	-- Pattern: Ensorcelled Nerubian Breastplate (p7 450)
                    { 13, 47634 },	-- Pattern: Knightbane Carapace (p7 450)
                    { 14, 47632 },	-- Pattern: Lunar Eclipse Chestguard (p7 450)
                    { 15, 47633 },	-- Pattern: Moonshadow Armguards (p7 450)
                    { 16, 47654 },	-- Pattern: Bejeweled Wizard's Bracers (p8 450)
                    { 17, 47655 },	-- Pattern: Merlin's Robe (p8 450)
                    { 18, 47656 },	-- Pattern: Royal Moonshroud Bracers (p8 450)
                    { 19, 47657 },	-- Pattern: Royal Moonshroud Robe (p8 450)
                }
            ),
        },
		T9_SET,
	}
}
data["SunwellPlateau80"] = {
	MapID = 4075,
	InstanceID = 580,
    name = AL["P5 Sunwell Plateau"],
	AtlasModule = ATLAS_TBC_MODULE_NAME,
	AtlasMapID = "CL_SunwellPlateau",
	AtlasMapFile = "CL_SunwellPlateau",
	ContentType = RAID_CONTENT,
	items = {
        { -- SPKalecgos
            name = AL["Kalecgos"],
            npcID = {24850,24892},
            Level = 999,
            DisplayIDs = {{23345},{6686}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 34170 }, -- Pantaloons of Calming Strife
                --{ 2, 34386 }, -- Pantaloons of Growing Strife
                { 2, 34169 }, -- Breeches of Natural Aggression
                --{ 4, 34384 }, -- Breeches of Natural Splendor
                { 3, 34168 }, -- Starstalker Legguards
                { 4, 34167 }, -- Legplates of the Holy Juggernaut
                --{ 7, 34382 }, -- Judicator's Legguards
                { 5, 34166 }, -- Band of Lucent Beams
                { 16, 34848 }, -- Bracers of the Forgotten Conqueror
                { 17, 34851 }, -- Bracers of the Forgotten Protector
                { 18, 34852 }, -- Bracers of the Forgotten Vanquisher
                { 20, 34165 }, -- Fang of Kalecgos
                { 21, 34164 }, -- Dragonscale-Encrusted Longblade
            }
        },
        { -- SPBrutallus
            name = AL["Brutallus"],
            npcID = 24882,
            Level = 999,
            DisplayIDs = {{22711}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 34181 }, -- Leggings of Calamity
                { 2, 34180 }, -- Felfury Legplates
                --{ 3, 34381 }, -- Felstrength Legplates
                { 3, 34178 }, -- Collar of the Pit Lord
                { 4, 34177 }, -- Clutch of Demise
                { 16, 34853 }, -- Belt of the Forgotten Conqueror
                { 17, 34854 }, -- Belt of the Forgotten Protector
                { 18, 34855 }, -- Belt of the Forgotten Vanquisher
                { 20, 34176 }, -- Reign of Misery
                { 21, 34179 }, -- Heart of the Pit
            }
        },
        { -- SPFelmyst
            name = AL["Felmyst"],
            npcID = 25038,
            Level = 999,
            DisplayIDs = {{22838}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 34352 }, -- Borderland Fortress Grips
                { 2, 34188 }, -- Leggings of the Immortal Night
                --{ 3, 34385 }, -- Leggings of the Immortal Beast
                { 3, 34186 }, -- Chain Links of the Tumultuous Storm
                --{ 5, 34383 }, -- Kilt of Spiritual Reconstruction
                { 4, 34184 }, -- Brooch of the Highborne
                { 16, 34856 }, -- Boots of the Forgotten Conqueror
                { 17, 34857 }, -- Boots of the Forgotten Protector
                { 18, 34858 }, -- Boots of the Forgotten Vanquisher
                { 20, 34182 }, -- Grand Magister's Staff of Torrents
                { 21, 34185 }, -- Sword Breaker's Bulwark
            }
        },
        { -- SPEredarTwins
            name = AL["Eredar Twins"],
            npcID = {25166,25165},
            Level = 999,
            DisplayIDs = {{23334},{23177}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 34205 }, -- Shroud of Redeemed Souls
                { 2, 34190 }, -- Crimson Paragon's Cover
                { 3, 34210 }, -- Amice of the Convoker
                { 4, 34202 }, -- Shawl of Wonderment
                --{ 5, 34393 }, -- Shoulderpads of Knowledge's Pursuit
                { 5, 34209 }, -- Spaulders of Reclamation
                --{ 7, 34391 }, -- Spaulders of Devastation
                { 6, 34195 }, -- Shoulderpads of Vehemence
                --{ 9, 34392 }, -- Demontooth Shoulderpads
                { 7, 34194 }, -- Mantle of the Golden Forest
                { 8, 34208 }, -- Equilibrium Epaulets
                --{ 12, 34390 }, -- Erupting Epaulets
                { 9, 34192 }, -- Pauldrons of Perseverance
                --{ 14, 34388 }, -- Pauldrons of Berserking
                { 10, 34193 }, -- Spaulders of the Thalassian Savior
                --{ 17, 34389 }, -- Spaulders of the Thalassian Defender
                { 16, 35290 }, -- Sin'dorei Pendant of Conquest
                { 17, 35291 }, -- Sin'dorei Pendant of Salvation
                { 18, 35292 }, -- Sin'dorei Pendant of Triumph
                { 19, 34204 }, -- Amulet of Unfettered Magics
                { 21, 34189 }, -- Band of Ruinous Delight
                { 23, 34206 }, -- Book of Highborne Hymns
                { 25, 34197 }, -- Shiv of Exsanguination
                { 26, 34199 }, -- Archon's Gavel
                { 27, 34203 }, -- Grip of Mannoroth
                { 28, 34198 }, -- Stanchion of Primal Instinct
                { 29, 34196 }, -- Golden Bow of Quel'Thalas
            }
        },
        { -- SPMuru
            name = AL["M'uru"],
            npcID = {25741,25840},
            Level = 999,
            DisplayIDs = {{23404},{23428}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 34232 }, -- Fel Conquerer Raiments
                { 2, 34233 }, -- Robes of Faltered Light
                --{ 3, 34399 }, -- Robes of Ghostly Hatred
                { 3, 34212 }, -- Sunglow Vest
                --{ 5, 34398 }, -- Utopian Tunic of Elune
                { 4, 34211 }, -- Harness of Carnal Instinct
                --{ 7, 34397 }, -- Bladed Chaos Tunic
                { 5, 34234 }, -- Shadowed Gauntlets of Paroxysm
                --{ 9, 34408 }, -- Gloves of the Forest Drifter
                { 6, 34229 }, -- Garments of Serene Shores
                --{ 11, 34396 }, -- Garments of Crashing Shores
                { 7, 34228 }, -- Vicious Hawkstrider Hauberk
                { 8, 34215 }, -- Warharness of Reckless Fury
                --{ 14, 34394 }, -- Breastplate of Agony's Aversion
                { 9, 34240 }, -- Gauntlets of the Soothed Soul
                { 10, 34216 }, -- Heroic Judicator's Chestguard
                --{ 17, 34395 }, -- Noble Judicator's Chestguard
                { 16, 34213 }, -- Ring of Hardened Resolve
                { 17, 34230 }, -- Ring of Omnipotence
                { 18, 35282 }, -- Sin'dorei Band of Dominance
                { 19, 35283 }, -- Sin'dorei Band of Salvation
                { 20, 35284 }, -- Sin'dorei Band of Triumph
                { 22, 34427 }, -- Blackened Naaru Sliver
                { 23, 34430 }, -- Glimmering Naaru Sliver
                { 24, 34429 }, -- Shifting Naaru Sliver
                { 25, 34428 }, -- Steely Naaru Sliver
                { 27, 34214 }, -- Muramasa
                { 28, 34231 }, -- Aegis of Angelic Fortune
            }
        },
        { -- SPKiljaeden
            name = AL["Kil'jaeden"],
            npcID = 25315,
            Level = 999,
            DisplayIDs = {{23200}},
            AtlasMapBossID = 4,
            [NORMAL_DIFF] = {
                { 1, 34241 }, -- Cloak of Unforgivable Sin
                { 2, 34242 }, -- Tattered Cape of Antonidas
                { 3, 34339 }, -- Cowl of Light's Purity
                --{ 4, 34405 }, -- Helm of Arcane Purity
                { 4, 34340 }, -- Dark Conjuror's Collar
                { 5, 34342 }, -- Handguards of the Dawn
                --{ 7, 34406 }, -- Gloves of Tyri's Power
                { 6, 34344 }, -- Handguards of Defiled Worlds
                { 7, 34244 }, -- Duplicitous Guise
                --{ 10, 34404 }, -- Mask of the Fury Hunter
                { 8, 34245 }, -- Cover of Ursol the Wise
                --{ 12, 34403 }, -- Cover of Ursoc the Mighty
                { 9, 34333 }, -- Coif of Alleria
                { 10, 34332 }, -- Cowl of Gul'dan
                --{ 15, 34402 }, -- Shroud of Chieftain Ner'zhul
                { 11, 34343 }, -- Thalassian Ranger Gauntlets
                { 12, 34243 }, -- Helm of Burning Righteousness
                --{ 18, 34401 }, -- Helm of Uther's Resolve
                { 13, 34345 }, -- Crown of Anasterian
                --{ 20, 34400 }, -- Crown of Dath'Remar
                { 14, 34341 }, -- Borderland Paingrips
                { 16, 34334 }, -- Thori'dal, the Stars' Fury
                { 18, 34329 }, -- Crux of the Apocalypse
                { 19, 34247 }, -- Apolyon, the Soul-Render
                { 20, 34335 }, -- Hammer of Sanctification
                { 21, 34331 }, -- Hand of the Deceiver
                { 22, 34336 }, -- Sunflare
                { 23, 34337 }, -- Golden Staff of the Sin'dorei
            }
        },
        { -- SPPatterns
            name = AL["Patterns"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 35212 }, -- Pattern: Leather Gauntlets of the Sun
                { 2, 35216 }, -- Pattern: Leather Chestguard of the Sun
                { 3, 35213 }, -- Pattern: Fletcher's Gloves of the Phoenix
                { 4, 35217 }, -- Pattern: Embrace of the Phoenix
                { 5, 35214 }, -- Pattern: Gloves of Immortal Dusk
                { 6, 35218 }, -- Pattern: Carapace of Sun and Shadow
                { 7, 35215 }, -- Pattern: Sun-Drenched Scale Gloves
                { 8, 35219 }, -- Pattern: Sun-Drenched Scale Chestguard
                { 9, 35204 }, -- Pattern: Sunfire Handwraps
                { 10, 35206 }, -- Pattern: Sunfire Robe
                { 11, 35205 }, -- Pattern: Hands of Eternal Light
                { 12, 35207 }, -- Pattern: Robe of Eternal Light
                { 13, 35198 }, -- Design: Loop of Forged Power
                { 14, 35201 }, -- Design: Pendant of Sunfire
                { 15, 35199 }, -- Design: Ring of Flowing Life
                { 16, 35202 }, -- Design: Amulet of Flowing Life
                { 17, 35200 }, -- Design: Hard Khorium Band
                { 18, 35203 }, -- Design: Hard Khorium Choker
                { 19, 35186 }, -- Schematic: Annihilator Holo-Gogs
                { 20, 35187 }, -- Schematic: Justicebringer 3000 Specs
                { 21, 35189 }, -- Schematic: Powerheal 9000 Lens
                { 22, 35190 }, -- Schematic: Hyper-Magnified Moon Specs
                { 23, 35191 }, -- Schematic: Wonderheal XT68 Shades
                { 24, 35192 }, -- Schematic: Primal-Attuned Goggles
                { 25, 35193 }, -- Schematic: Lightning Etched Specs
                { 26, 35194 }, -- Schematic: Surestrike Goggles v3.0
                { 27, 35195 }, -- Schematic: Mayhem Projection Goggles
                { 28, 35196 }, -- Schematic: Hard Khorium Goggles
                { 29, 35197 }, -- Schematic: Quad Deathblow X44 Goggles
            }
        },
        { -- SPTrash
            name = AL["Trash"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 34351 }, -- Tranquil Majesty Wraps
                --{ 2, 34407 }, -- Tranquil Moonlight Wraps
                { 2, 34350 }, -- Gauntlets of the Ancient Shadowmoon
                --{ 4, 34409 }, -- Gauntlets of the Ancient Frostwolf
                { 3, 35733 }, -- Ring of Harmonic Beauty
                { 4, 34183 }, -- Shivering Felspine
                { 5, 34346 }, -- Mounting Vengeance
                { 6, 34349 }, -- Blade of Life's Inevitability
                { 7, 34348 }, -- Wand of Cleansing Light
                { 8, 34347 }, -- Wand of the Demonsoul
                { 10, 35273 }, -- Study of Advanced Smelting
                { 12, 34664 }, -- Sunmote
                { 16, 32228 }, -- Empyrean Sapphire
                { 17, 32231 }, -- Pyrestone
                { 18, 32229 }, -- Lionseye
                { 19, 32249 }, -- Seaspray Emerald
                { 20, 32230 }, -- Shadowsong Amethyst
                { 21, 32227 }, -- Crimson Spinel
                { 23, 35208 }, -- Plans: Sunblessed Gauntlets
                { 24, 35210 }, -- Plans: Sunblessed Breastplate
                { 25, 35209 }, -- Plans: Hard Khorium Battlefists
                { 26, 35211 }, -- Plans: Hard Khorium Battleplate
            }
        },
        T6_SET
    }
}
data["ZulAman80"] = {
	MapID = 3805,
	InstanceID = 568,
    name = AL["P5 Zul'Aman"],
	AtlasModule = ATLAS_TBC_MODULE_NAME,
	AtlasMapID = "ZulAman",
	AtlasMapFile = "ZulAman",
	ContentType = RAID_CONTENT,
	items = {
        { -- ZAAkilZon
            name = AL["Akil'zon"],
            npcID = 23574,
            Level = 999,
            DisplayIDs = {{21630}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 29434 }, -- Badge of Justice
                { 2, 33286 }, -- Mojo-mender's Mask
                { 3, 33215 }, -- Bloodstained Elven Battlevest
                { 4, 33216 }, -- Chestguard of Hidden Purpose
                { 5, 33281 }, -- Brooch of Nature's Mercy
                { 6, 33293 }, -- Signet of Ancient Magics
                { 7, 33214 }, -- Akil'zon's Talonblade
                { 8, 33283 }, -- Amani Punisher
                { 16, 33307 }, -- Formula: Enchant Weapon - Executioner
            }
        },
        { -- ZANalorakk
            name = AL["Nalorakk"],
            npcID = 23576,
            Level = 999,
            DisplayIDs = {{21631}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 29434 }, -- Badge of Justice
                { 2, 33203 }, -- Robes of Heavenly Purpose
                { 3, 33285 }, -- Fury of the Ursine
                { 4, 33211 }, -- Bladeangel's Money Belt
                { 5, 33206 }, -- Pauldrons of Primal Fury
                { 6, 33327 }, -- Mask of Introspection
                { 7, 33191 }, -- Jungle Stompers
                { 8, 33640 }, -- Fury
                { 10, 33307 }, -- Formula: Enchant Weapon - Executioner
            }
        },
        { -- ZAJanAlai
            name = AL["Jan'alai"],
            npcID = 23578,
            Level = 999,
            DisplayIDs = {{21633}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 29434 }, -- Badge of Justice
                { 2, 33357 }, -- Footpads of Madness
                { 3, 33356 }, -- Helm of Natural Regeneration
                { 4, 33329 }, -- Shadowtooth Trollskin Cuirass
                { 5, 33328 }, -- Arrow-fall Chestguard
                { 6, 33354 }, -- Wub's Cursed Hexblade
                { 7, 33326 }, -- Bulwark of the Amani Empire
                { 8, 33332 }, -- Enamelled Disc of Mojo
                { 10, 33307 }, -- Formula: Enchant Weapon - Executioner
            }
        },
        { -- ZAHalazzi
            name = AL["Halazzi"],
            npcID = 23577,
            Level = 999,
            DisplayIDs = {{21632}},
            AtlasMapBossID = 4,
            [NORMAL_DIFF] = {
                { 1, 29434 }, -- Badge of Justice
                { 2, 33317 }, -- Robe of Departed Spirits
                { 3, 33300 }, -- Shoulderpads of Dancing Blades
                { 4, 33322 }, -- Shimmer-pelt Vest
                { 5, 33533 }, -- Avalanche Leggings
                { 6, 33299 }, -- Spaulders of the Advocate
                { 7, 33303 }, -- Skullshatter Warboots
                { 8, 33297 }, -- The Savage's Choker
                { 10, 33307 }, -- Formula: Enchant Weapon - Executioner
            }
        },
        { -- ZAMalacrass
            name = AL["Hex Lord Malacrass"],
            npcID = 24239,
            Level = 999,
            DisplayIDs = {{22332}},
            AtlasMapBossID = 5,
            [NORMAL_DIFF] = {
                { 1, 29434 }, -- Badge of Justice
                { 2, 33592 }, -- Cloak of Ancient Rituals
                { 3, 33453 }, -- Hood of Hexing
                { 4, 33463 }, -- Hood of the Third Eye
                { 5, 33432 }, -- Coif of the Jungle Stalker
                { 6, 33464 }, -- Hex Lord's Voodoo Pauldrons
                { 7, 33421 }, -- Battleworn Tuskguard
                { 8, 33446 }, -- Girdle of Stromgarde's Hope
                { 10, 33307 }, -- Formula: Enchant Weapon - Executioner
                { 16, 33829 }, -- Hex Shrunken Head
                { 17, 34029 }, -- Tiny Voodoo Mask
                { 18, 33828 }, -- Tome of Diabolic Remedy
                { 19, 33389 }, -- Dagger of Bad Mojo
                { 20, 33298 }, -- Prowler's Strikeblade
                { 21, 33388 }, -- Heartless
                { 22, 33465 }, -- Staff of Primal Fury
            }
        },
        { -- ZAZuljin
            name = AL["Zul'jin"],
            npcID = 23863,
            Level = 999,
            DisplayIDs = {{21899}},
            AtlasMapBossID = 6,
            [NORMAL_DIFF] = {
                { 1, 29434 }, -- Badge of Justice
                { 2, 33471 }, -- Two-toed Sandals
                { 3, 33479 }, -- Grimgrin Faceguard
                { 4, 33469 }, -- Hauberk of the Empire's Champion
                { 5, 33473 }, -- Chestguard of the Warlord
                { 6, 33466 }, -- Loop of Cursed Bones
                { 7, 33830 }, -- Ancient Aqir Artifact
                { 8, 33831 }, -- Berserker's Call
                { 10, 33307 }, -- Formula: Enchant Weapon - Executioner
                { 16, 33467 }, -- Blade of Twisted Visions
                { 17, 33478 }, -- Jin'rohk, The Great Apocalypse
                { 18, 33476 }, -- Cleaver of the Unforgiving
                { 19, 33468 }, -- Dark Blessing
                { 20, 33474 }, -- Ancient Amani Longbow
                { 22, 33102 }, -- Blood of Zul'jin
            }
        },
        { -- ZATimedChest
            name = AL["Timed Chest"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, "INV_Box_01", nil, format(AL["Timed Reward Chest %d"], 1), nil },
                { 2, 33590 }, -- Cloak of Fiends
                { 3, 33591 }, -- Shadowcaster's Drape
                { 4, 33489 }, -- Mantle of Ill Intent
                { 5, 33480 }, -- Cord of Braided Troll Hair
                { 6, 33483 }, -- Life-step Belt
                { 7, 33971 }, -- Elunite Imbued Leggings
                { 8, 33805 }, -- Shadowhunter's Treads
                { 9, 33481 }, -- Pauldrons of Stone Resolve
                { 10, "INV_Box_01", nil, format(AL["Timed Reward Chest %d"], 3), nil },
                { 11, 33497 }, -- Mana Attuned Band
                { 12, 33500 }, -- Signet of Eternal Life
                { 13, 33496 }, -- Signet of Primal Wrath
                { 14, 33499 }, -- Signet of the Last Defender
                { 15, 33498 }, -- Signet of the Quiet Forest
                { 16, "INV_Box_01", nil, format(AL["Timed Reward Chest %d"], 2), nil },
                { 17, 33495 }, -- Rage
                { 18, 33493 }, -- Umbral Shiv
                { 19, 33492 }, -- Trollbane
                { 20, 33490 }, -- Staff of Dark Mending
                { 21, 33494 }, -- Amani Divining Staff
                { 22, 33491 }, -- Tuskbreaker
                { 25, "INV_Box_01", nil, format(AL["Timed Reward Chest %d"], 4), nil },
                { 26, 33809 }, -- Amani War Bear
            }
        },
        { -- ZATrash
            name = AL["Trash"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 33993 }, -- Mojo
                { 3, 33865 }, -- Amani Hex Stick
                { 4, 33930 }, -- Amani Charm of the Bloodletter
                { 5, 33932 }, -- Amani Charm of the Witch Doctor
                { 6, 33931 }, -- Amani Charm of Mighty Mojo
                { 7, 33933 }, -- Amani Charm of the Raging Defender
            }
        },
    }
}
data["Ulduar"] = {
	MapID = 4273,
    name = AL["P6 Ulduar"],
    EncounterJournalID = 759,
	InstanceID = 603,
    ContentType = RAID_CONTENT,
	AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "UlduarA",
	AtlasMapFile = {"UlduarA", "UlduarEnt"},
	--LoadDifficulty = NORMAL_DIFF,
	-- LevelRange = {80, 80, 80},
	items = {
        { -- UlduarLeviathan
            name = AL["Flame Leviathan"],
            NameColor = GREEN,
            npcID = 33113,
            EncounterJournalID = 1637,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapBossID = 1,
            [RAID10_DIFF] = {
                { 1, 45117 }, -- Constructor's Handwraps
                { 2, 45119 }, -- Embrace of the Leviathan
                { 3, 45108 }, -- Mechanist's Bindings
                { 4, 45118 }, -- Steamworker's Goggles
                { 5, 45109 }, -- Gloves of the Fiery Behemoth
                { 6, 45107 }, -- Iron Riveted War Helm
                { 7, 45111 }, -- Mimiron's Inferno Couplings
                { 8, 45116 }, -- Freya's Choker of Warding
                { 9, 45113 }, -- Glowing Ring of Reclamation
                { 10, 45106 }, -- Strength of the Automaton
                { 11, 45112 }, -- The Leviathan's Coil
                { 12, 45115 }, -- Overcharged Fuel Rod
                { 13, 45114 }, -- Steamcaller's Totem
                { 14, 45110 }, -- Titanguard
                { 15, 45086 }, -- Rising Sun
                { 16, "SPECIAL_ACHIEVEMENT", nil, AL["Achievements"], nil, "AC_UlduarFlameLeviathan10" },
                { 25, "ac3056", nil, nil, AL["Hard Mode"] },
                { 26, 45293 }, -- Handguards of Potent Cures
                { 27, 45300 }, -- Mantle of Fiery Vengeance
                { 28, 45295 }, -- Gilded Steel Legplates
                { 29, 45297 }, -- Shimmering Seal
                { 30, 45296 }, -- Twirling Blades
            },
            [RAID25_DIFF] = {
                { 1, 45117 }, -- Constructor's Handwraps
                { 2, 45119 }, -- Embrace of the Leviathan
                { 3, 45108 }, -- Mechanist's Bindings
                { 4, 45118 }, -- Steamworker's Goggles
                { 5, 45109 }, -- Gloves of the Fiery Behemoth
                { 6, 45107 }, -- Iron Riveted War Helm
                { 7, 45111 }, -- Mimiron's Inferno Couplings
                { 8, 45116 }, -- Freya's Choker of Warding
                { 9, 45113 }, -- Glowing Ring of Reclamation
                { 10, 45106 }, -- Strength of the Automaton
                { 11, 45112 }, -- The Leviathan's Coil
                { 12, 45115 }, -- Overcharged Fuel Rod
                { 13, 45114 }, -- Steamcaller's Totem
                { 14, 45110 }, -- Titanguard
                { 15, 45086 }, -- Rising Sun
                { 16, 45038 }, -- Fragment of Val'anyr
                { 18, "SPECIAL_ACHIEVEMENT", nil, AL["Achievements"], nil, "AC_UlduarFlameLeviathan25" },
                { 25, "ac3057", nil, nil, AL["Hard Mode"] },
                { 26, 45135 }, -- Boots of Fiery Resolution
                { 27, 45136 }, -- Shoulderpads of Dormant Energies
                { 28, 45134 }, -- Plated Leggings of Ruination
                { 29, 45133 }, -- Pendant of Fiery Havoc
                { 30, 45132 }, -- Golden Saronite Dragon
            }
        },
        { -- UlduarIgnis
            name = AL["Ignis the Furnace Master"],
            NameColor = GREEN,
            npcID = 33118,
            EncounterJournalID = 1638,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapBossID = 2,
            [RAID10_DIFF] = {
                { 1, 45186 }, -- Soot-Covered Mantle
                { 2, 45185 }, -- Flamewrought Cinch
                { 3, 45162 }, -- Flamestalker Boots
                { 4, 45164 }, -- Helm of the Furnace Master
                { 5, 45187 }, -- Wristguards of the Firetender
                { 6, 45167 }, -- Lifeforge Breastplate
                { 7, 45161 }, -- Girdle of Embers
                { 8, 45166 }, -- Charred Saronite Greaves
                { 9, 45157 }, -- Cindershard Ring
                { 10, 45168 }, -- Pyrelight Circle
                { 11, 45158 }, -- Heart of Iron
                { 12, 45169 }, -- Totem of the Dancing Flame
                { 13, 45165 }, -- Worldcarver
                { 14, 45171 }, -- Intensity
                { 15, 45170 }, -- Scepter of Creation
                { 16, "ac2927" },
				{ 17, "ac2925" },
				{ 18, "ac2930" },
            },
            [RAID25_DIFF] = {
                { 1, 45186 }, -- Soot-Covered Mantle
                { 2, 45185 }, -- Flamewrought Cinch
                { 3, 45162 }, -- Flamestalker Boots
                { 4, 45164 }, -- Helm of the Furnace Master
                { 5, 45187 }, -- Wristguards of the Firetender
                { 6, 45167 }, -- Lifeforge Breastplate
                { 7, 45161 }, -- Girdle of Embers
                { 8, 45166 }, -- Charred Saronite Greaves
                { 9, 45157 }, -- Cindershard Ring
                { 10, 45168 }, -- Pyrelight Circle
                { 11, 45158 }, -- Heart of Iron
                { 12, 45169 }, -- Totem of the Dancing Flame
                { 13, 45165 }, -- Worldcarver
                { 14, 45171 }, -- Intensity
                { 15, 45170 }, -- Scepter of Creation
                { 16, 45038 }, -- Fragment of Val'anyr
                { 18, "ac2928" },
				{ 19, "ac2926" },
				{ 20, "ac2929" },
            }
        },
        { -- UlduarRazorscale
            name = AL["Razorscale"],
            NameColor = GREEN,
            npcID = 33186,
            EncounterJournalID = 1639,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapBossID = 3,
            [RAID10_DIFF] = {
                { 1, 45138 }, -- Drape of the Drakerider
                { 2, 45150 }, -- Collar of the Wyrmhunter
                { 3, 45146 }, -- Shackles of the Odalisque
                { 4, 45149 }, -- Bracers of the Broodmother
                { 5, 45141 }, -- Proto-hide Leggings
                { 6, 45151 }, -- Belt of the Fallen Wyrm
                { 7, 45143 }, -- Saronite Mesh Legguards
                { 8, 45140 }, -- Razorscale Shoulderguards
                { 9, 45139 }, -- Dragonslayer's Brace
                { 10, 45148 }, -- Living Flame
                { 11, 45510 }, -- Libram of Discord
                { 12, 45144 }, -- Sigil of Deflection
                { 13, 45142 }, -- Remorse
                { 14, 45147 }, -- Guiding Star
                { 15, 45137 }, -- Veranus' Bane
                { 16, "ac2919" },
				{ 17, "ac2923" },
            },
            [RAID25_DIFF] = {
                { 1, 45138 }, -- Drape of the Drakerider
                { 2, 45150 }, -- Collar of the Wyrmhunter
                { 3, 45146 }, -- Shackles of the Odalisque
                { 4, 45149 }, -- Bracers of the Broodmother
                { 5, 45141 }, -- Proto-hide Leggings
                { 6, 45151 }, -- Belt of the Fallen Wyrm
                { 7, 45143 }, -- Saronite Mesh Legguards
                { 8, 45140 }, -- Razorscale Shoulderguards
                { 9, 45139 }, -- Dragonslayer's Brace
                { 10, 45148 }, -- Living Flame
                { 11, 45510 }, -- Libram of Discord
                { 12, 45144 }, -- Sigil of Deflection
                { 13, 45142 }, -- Remorse
                { 14, 45147 }, -- Guiding Star
                { 15, 45137 }, -- Veranus' Bane
                { 16, 45038 }, -- Fragment of Val'anyr
                { 18, "ac2921" },
				{ 19, "ac2924" },
            }
        },
        { -- UlduarXT-002 Deconstructor
            name = AL["XT-002 Deconstructor"],
            NameColor = GREEN,
            npcID = 33293,
            EncounterJournalID = 1640,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapBossID = 4,
            [RAID10_DIFF] = {
                { 1, 45253 }, -- Mantle of Wavering Calm
                { 2, 45258 }, -- Sandals of Rash Temperament
                { 3, 45260 }, -- Boots of Hasty Revival
                { 4, 45259 }, -- Quartz-studded Harness
                { 5, 45249 }, -- Brass-lined Boots
                { 6, 45251 }, -- Shoulderplates of the Deconstructor
                { 7, 45252 }, -- Horologist's Wristguards
                { 8, 45248 }, -- Clockwork Legplates
                { 9, 45250 }, -- Crazed Construct Ring
                { 10, 45247 }, -- Signet of the Earthshaker
                { 11, 45254 }, -- Sigil of the Vengeful Heart
                { 12, 45255 }, -- Thunderfall Totem
                { 13, 45246 }, -- Golem-Shard Sticker
                { 14, 45256 }, -- Twisted Visage
                { 15, 45257 }, -- Quartz Crystal Wand
                { 16, "SPECIAL_ACHIEVEMENT", nil, AL["Achievements"], nil, "AC_UlduarXTDeconstructor10" },
                { 25, "ac3058", nil, nil, AL["Hard Mode"] },
                { 26, 45869 }, -- Fluxing Energy Coils
                { 27, 45867 }, -- Breastplate of the Stoneshaper
                { 28, 45871 }, -- Seal of Ulduar
                { 29, 45868 }, -- Aesir's Edge
                { 30, 45870 }, -- Magnetized Projectile Emitter
            },
            [RAID25_DIFF] = {
                { 1, 45253 }, -- Mantle of Wavering Calm
                { 2, 45258 }, -- Sandals of Rash Temperament
                { 3, 45260 }, -- Boots of Hasty Revival
                { 4, 45259 }, -- Quartz-studded Harness
                { 5, 45249 }, -- Brass-lined Boots
                { 6, 45251 }, -- Shoulderplates of the Deconstructor
                { 7, 45252 }, -- Horologist's Wristguards
                { 8, 45248 }, -- Clockwork Legplates
                { 9, 45250 }, -- Crazed Construct Ring
                { 10, 45247 }, -- Signet of the Earthshaker
                { 11, 45254 }, -- Sigil of the Vengeful Heart
                { 12, 45255 }, -- Thunderfall Totem
                { 13, 45246 }, -- Golem-Shard Sticker
                { 14, 45256 }, -- Twisted Visage
                { 15, 45257 }, -- Quartz Crystal Wand
                { 16, 45038 }, -- Fragment of Val'anyr
                { 18, "SPECIAL_ACHIEVEMENT", nil, AL["Achievements"], nil, "AC_UlduarXTDeconstructor25" },
                { 25, "ac3059", nil, nil, AL["Hard Mode"] },
                { 26, 45446 }, -- Grasps of Reason
                { 27, 45444 }, -- Gloves of the Steady Hand
                { 28, 45445 }, -- Breastplate of the Devoted
                { 29, 45443 }, -- Charm of Meticulous Timing
                { 30, 45442 }, -- Sorthalis, Hammer of the Watchers
            }
        },
        { -- UlduarIronCouncil
            name = AL["The Iron Council"],
            NameColor = BLUE,
            npcID = 32857,
            EncounterJournalID = 1641,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapFile = "UlduarB",
            AtlasMapBossID = 5,
            [RAID10_DIFF] = {
                { 1, 45224 }, -- Drape of the Lithe
                { 2, 45240 }, -- Raiments of the Iron Council
                { 3, 45238 }, -- Overload Legwraps
                { 4, 45237 }, -- Phaelia's Vestments of the Sprouting Seed
                { 5, 45232 }, -- Runed Ironhide Boots
                { 6, 45227 }, -- Iron-studded Mantle
                { 7, 45239 }, -- Runeshaper's Gloves
                { 8, 45226 }, -- Ancient Iron Heaume
                { 9, 45225 }, -- Steelbreaker's Embrace
                { 10, 45228 }, -- Handguards of the Enclave
                { 11, 45193 }, -- Insurmountable Fervor
                { 12, 45236 }, -- Unblinking Eye
                { 13, 45235 }, -- Radiant Seal
                { 14, 45233 }, -- Rune Edge
                { 15, 45234 }, -- Rapture
                { 16, "SPECIAL_ACHIEVEMENT", nil, AL["Achievements"], nil, "AC_UlduarCouncil10" },
                { 24, "ac2941", nil, nil, AL["Hard Mode"] },
                { 25, 45455 }, -- Belt of the Crystal Tree
                { 26, 45447 }, -- Watchful Eye
                { 27, 45456 }, -- Loop of the Agile
                { 28, 45449 }, -- The Masticator
                { 29, 45448 }, -- Perilous Bite
                { 30, 45506 }, -- Archivum Data Disc
            },
            [RAID25_DIFF] = {
                { 1, 45224 }, -- Drape of the Lithe
                { 2, 45240 }, -- Raiments of the Iron Council
                { 3, 45238 }, -- Overload Legwraps
                { 4, 45237 }, -- Phaelia's Vestments of the Sprouting Seed
                { 5, 45232 }, -- Runed Ironhide Boots
                { 6, 45227 }, -- Iron-studded Mantle
                { 7, 45239 }, -- Runeshaper's Gloves
                { 8, 45226 }, -- Ancient Iron Heaume
                { 9, 45225 }, -- Steelbreaker's Embrace
                { 10, 45228 }, -- Handguards of the Enclave
                { 11, 45193 }, -- Insurmountable Fervor
                { 12, 45236 }, -- Unblinking Eye
                { 13, 45235 }, -- Radiant Seal
                { 14, 45233 }, -- Rune Edge
                { 15, 45234 }, -- Rapture
                { 16, 45038 }, -- Fragment of Val'anyr
                { 18, "SPECIAL_ACHIEVEMENT", nil, AL["Achievements"], nil, "AC_UlduarCouncil25" },
                { 23, "ac2944", nil, nil, AL["Hard Mode"] },
                { 24, 45242 }, -- Drape of Mortal Downfall
                { 25, 45245 }, -- Shoulderpads of the Intruder
                { 26, 45244 }, -- Greaves of Swift Vengeance
                { 27, 45241 }, -- Belt of Colossal Rage
                { 28, 45243 }, -- Sapphire Amulet of Renewal
                { 29, 45607 }, -- Fang of Oblivion
                { 30, 45857 }, -- Archivum Data Disc
            }
        },
        { -- UlduarKologarn
            name = AL["Kologarn"],
            NameColor = BLUE,
            npcID = 32930,
            EncounterJournalID = 1642,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapFile = "UlduarB",
            AtlasMapBossID = 6,
            [RAID10_DIFF] = {
                { 1, 45272 }, -- Robes of the Umbral Brute
                { 2, 45275 }, -- Bracers of Unleashed Magic
                { 3, 45273 }, -- Handwraps of Plentiful Recovery
                { 4, 45265 }, -- Shoulderpads of the Monolith
                { 5, 45274 }, -- Leggings of the Stoneweaver
                { 6, 45264 }, -- Decimator's Armguards
                { 7, 45269 }, -- Unfaltering Armguards
                { 8, 45268 }, -- Gloves of the Pythonic Guardian
                { 9, 45267 }, -- Saronite Plated Legguards
                { 10, 45262 }, -- Necklace of Unerring Mettle
                { 11, 45263 }, -- Wrathstone
                { 12, 45271 }, -- Ironmender
                { 13, 45270 }, -- Idol of the Crying Wind
                { 14, 45266 }, -- Malice
                { 15, 45261 }, -- Giant's Bane
                { 16, "ac2953" },
				{ 17, "ac2955" },
				{ 18, "ac2959" },
				{ 19, "ac2951" },
            },
            [RAID25_DIFF] = {
                { 1, 45272 }, -- Robes of the Umbral Brute
                { 2, 45275 }, -- Bracers of Unleashed Magic
                { 3, 45273 }, -- Handwraps of Plentiful Recovery
                { 4, 45265 }, -- Shoulderpads of the Monolith
                { 5, 45274 }, -- Leggings of the Stoneweaver
                { 6, 45264 }, -- Decimator's Armguards
                { 7, 45269 }, -- Unfaltering Armguards
                { 8, 45268 }, -- Gloves of the Pythonic Guardian
                { 9, 45267 }, -- Saronite Plated Legguards
                { 10, 45262 }, -- Necklace of Unerring Mettle
                { 11, 45263 }, -- Wrathstone
                { 12, 45271 }, -- Ironmender
                { 13, 45270 }, -- Idol of the Crying Wind
                { 14, 45266 }, -- Malice
                { 15, 45261 }, -- Giant's Bane
                { 16, 45038 }, -- Fragment of Val'anyr
                { 18, "ac2954" },
				{ 19, "ac2956" },
				{ 20, "ac2960" },
				{ 21, "ac2952" },
            }
        },
        { -- UlduarAlgalon
            name = AL["Algalon the Observer"],
            NameColor = BLUE,
            npcID = 32871,
            EncounterJournalID = 1650,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapFile = "UlduarB",
            AtlasMapBossID = 7,
            [RAID10_DIFF] = {
                { 1, 46042 },	-- Drape of the Messenger
				{ 2, 46045 },	-- Pulsar Gloves
				{ 3, 46050 },	-- Starlight Treads
				{ 4, 46043 },	-- Gloves of the Endless Dark
				{ 5, 46049 },	-- Zodiac Leggings
				{ 6, 46044 },	-- Observer's Mantle
				{ 7, 46037 },	-- Shoulderplates of the Celestial Watch
				{ 8, 46039 },	-- Breastplate of the Timeless
				{ 9, 46041 },	-- Starfall Girdle
				{ 10, 46047 },	-- Pendant of the Somber Witness
				{ 11, 46040 },	-- Strength of the Heavens
				{ 12, 46048 },	-- Band of Lights
				{ 13, 46046 },	-- Nebula Band
				{ 14, 46038 },	-- Dark Matter
				{ 15, 46051 },	-- Meteorite Crystal
				{ 16, 46052 },	-- Reply-Code Alpha
            },
            [RAID25_DIFF] = {
				{ 1, 45665 },	-- Pharos Gloves
				{ 2, 45619 },	-- Starwatcher's Binding
				{ 3, 45611 },	-- Solar Bindings
				{ 4, 45616 },	-- Star-beaded Clutch
				{ 5, 45610 },	-- Boundless Gaze
				{ 6, 45615 },	-- Planewalker Treads
				{ 7, 45594 },	-- Legplates of the Endless Void
				{ 8, 45599 },	-- Sabatons of Lifeless Night
				{ 9, 45609 },	-- Comet's Trail
				{ 10, 45620 },	-- Starshard Edge
				{ 11, 45607 },	-- Fang of Oblivion
				{ 12, 45612 },	-- Constellus
				{ 13, 45613 },	-- Dreambinder
				{ 14, 45587 },	-- Bulwark of Algalon
				{ 15, 45570 },	-- Skyforge Crossbow
                { 16, 45617 },	-- Cosmos
                { 18, 45038 },	-- Fragment of Val'anyr
				{ 20, 46053 },	-- Reply-Code Alpha
            }
        },
        { -- UlduarAuriaya
            name = AL["Auriaya"],
            npcID = 33515,
            EncounterJournalID = 1643,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapFile = "UlduarC",
            AtlasMapBossID = 8,
            [RAID10_DIFF] = {
                { 1, 45319 }, -- Cloak of the Makers
                { 2, 45435 }, -- Cowl of the Absolute
                { 3, 45441 }, -- Sandals of the Ancient Keeper
                { 4, 45439 }, -- Unwavering Stare
                { 5, 45325 }, -- Gloves of the Stonereaper
                { 6, 45440 }, -- Amice of the Stoic Watch
                { 7, 45320 }, -- Shoulderplates of the Eternal
                { 8, 45334 }, -- Unbreakable Chestguard
                { 9, 45434 }, -- Greaves of the Rockmender
                { 10, 45326 }, -- Platinum Band of the Aesir
                { 11, 45438 }, -- Ring of the Faithful Servant
                { 12, 45436 }, -- Libram of the Resolute
                { 13, 45437 }, -- Runescribed Blade
                { 14, 45315 }, -- Stonerender
                { 15, 45327 }, -- Siren's Cry
                { 16, "ac3006" },
                { 17, "ac3076" },
            },
            [RAID25_DIFF] = {
                { 1, 45319 }, -- Cloak of the Makers
                { 2, 45435 }, -- Cowl of the Absolute
                { 3, 45441 }, -- Sandals of the Ancient Keeper
                { 4, 45439 }, -- Unwavering Stare
                { 5, 45325 }, -- Gloves of the Stonereaper
                { 6, 45440 }, -- Amice of the Stoic Watch
                { 7, 45320 }, -- Shoulderplates of the Eternal
                { 8, 45334 }, -- Unbreakable Chestguard
                { 9, 45434 }, -- Greaves of the Rockmender
                { 10, 45326 }, -- Platinum Band of the Aesir
                { 11, 45438 }, -- Ring of the Faithful Servant
                { 12, 45436 }, -- Libram of the Resolute
                { 13, 45437 }, -- Runescribed Blade
                { 14, 45315 }, -- Stonerender
                { 15, 45327 }, -- Siren's Cry
                { 16, 45038 }, -- Fragment of Val'anyr
                { 18, "ac3007" },
                { 19, "ac3077" },
            }
        },
        { -- UlduarHodir
            name = AL["Hodir"],
            npcID = 32845,
            EncounterJournalID = 1644,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapFile = "UlduarC",
            AtlasMapBossID = 9,
            [RAID10_DIFF] = {
                { 1, 45453 }, -- Winter's Icy Embrace
                { 2, 45454 }, -- Frost-bound Chain Bracers
                { 3, 45452 }, -- Frostplate Greaves
                { 4, 45451 }, -- Frozen Loop
                { 5, 45450 }, -- Northern Barrier
                { 9, "ac3182", nil, nil, AL["Hard Mode"] },
                { 10, 45888 }, -- Bitter Cold Armguards
                { 11, 45876 }, -- Shiver
                { 12, 45886 }, -- Icecore Staff
                { 13, 45887 }, -- Ice Layered Barrier
                { 14, 45877 }, -- The Boreal Guard
                { 15, 45786 }, -- Hodir's Sigil
                { 16, 45632 }, -- Breastplate of the Wayward Conqueror
                { 17, 45633 }, -- Breastplate of the Wayward Protector
                { 18, 45634 }, -- Breastplate of the Wayward Vanquisher
                { 20, "SPECIAL_ACHIEVEMENT", nil, AL["Achievements"], nil, "AC_UlduarHodir10" },
            },
            [RAID25_DIFF] = {
                { 1, 45453 }, -- Winter's Icy Embrace
                { 2, 45454 }, -- Frost-bound Chain Bracers
                { 3, 45452 }, -- Frostplate Greaves
                { 4, 45451 }, -- Frozen Loop
                { 5, 45450 }, -- Northern Barrier
                { 8, "ac3184", nil, nil, AL["Hard Mode"] },
                { 9, 45461 }, -- Drape of Icy Intent
                { 10, 45462 }, -- Gloves of the Frozen Glade
                { 11, 45460 }, -- Bindings of Winter Gale
                { 12, 45459 }, -- Frigid Strength of Hodir
                { 13, 45612 }, -- Constellus
                { 14, 45457 }, -- Staff of Endless Winter
                { 15, 45815 }, -- Hodir's Sigil
                { 16, 45038 }, -- Fragment of Val'anyr
                { 18, 45632 }, -- Breastplate of the Wayward Conqueror
                { 19, 45633 }, -- Breastplate of the Wayward Protector
                { 20, 45634 }, -- Breastplate of the Wayward Vanquisher
                { 22, "SPECIAL_ACHIEVEMENT", nil, AL["Achievements"], nil, "AC_UlduarHodir25" },
            }
        },
        { -- UlduarThorim
            name = AL["Thorim"],
            npcID = 32865,
            EncounterJournalID = 1645,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapFile = "UlduarC",
            AtlasMapBossID = 10,
            [RAID10_DIFF] = {
                { 1, 45468 }, -- Leggings of Lost Love
                { 2, 45467 }, -- Belt of the Betrayed
                { 3, 45469 }, -- Sif's Promise
                { 4, 45466 }, -- Scale of Fates
                { 5, 45463 }, -- Vulmir, the Northern Tempest
                { 9, "ac3176", nil, nil, AL["Hard Mode"] },
                { 10, 45928 }, -- Gauntlets of the Thunder God
                { 11, 45933 }, -- Pendant of the Shallow Grave
                { 12, 45931 }, -- Mjolnir Runestone
                { 13, 45929 }, -- Sif's Remembrance
                { 14, 45930 }, -- Combatant's Bootblade
                { 15, 45784 }, -- Thorim's Sigil
                { 16, 45638 }, -- Crown of the Wayward Conqueror
                { 17, 45639 }, -- Crown of the Wayward Protector
                { 18, 45640 }, -- Crown of the Wayward Vanquisher
                { 20, "ac2971" },
                { 21, "ac2973" },
                { 22, "ac3176" },
                { 23, "ac2977" },
                { 24, "ac2975" },
            },
            [RAID25_DIFF] = {
                { 1, 45468 }, -- Leggings of Lost Love
                { 2, 45467 }, -- Belt of the Betrayed
                { 3, 45469 }, -- Sif's Promise
                { 4, 45466 }, -- Scale of Fates
                { 5, 45463 }, -- Vulmir, the Northern Tempest
                { 8, "ac3183", nil, nil, AL["Hard Mode"] },
                { 9, 45473 }, -- Embrace of the Gladiator
                { 10, 45474 }, -- Pauldrons of the Combatant
                { 11, 45472 }, -- Warhelm of the Champion
                { 12, 45471 }, -- Fate's Clutch
                { 13, 45570 }, -- Skyforge Crossbow
                { 14, 45470 }, -- Wisdom's Hold
                { 15, 45817 }, -- Thorim's Sigil
                { 16, 45038 }, -- Fragment of Val'anyr
                { 18, 45638 }, -- Crown of the Wayward Conqueror
                { 19, 45639 }, -- Crown of the Wayward Protector
                { 20, 45640 }, -- Crown of the Wayward Vanquisher
                { 22, "ac2972" },
                { 23, "ac2974" },
                { 24, "ac3183" },
                { 25, "ac2978" },
                { 26, "ac2976" },
            }
        },
        { -- UlduarFreya
            name = AL["Freya"],
            npcID = 32906,
            EncounterJournalID = 1646,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapFile = "UlduarC",
            AtlasMapBossID = 11,
            [RAID10_DIFF] = {
                { 1, 45483 }, -- Boots of the Servant
                { 2, 45482 }, -- Leggings of the Lifetender
                { 3, 45481 }, -- Gauntlets of Ruthless Reprisal
                { 4, 45480 }, -- Nymph Heart Charm
                { 5, 45479 }, -- The Lifebinder
                { 9, "ac3179", nil, nil, AL["Hard Mode"] },
                { 10, 45943 }, -- Gloves of Whispering Winds
                { 11, 45945 }, -- Seed of Budding Carnage
                { 12, 45946 }, -- Fire Orchid Signet
                { 13, 45947 }, -- Serilas, Blood Blade of Invar One-Arm
                { 14, 45294 }, -- Petrified Ivy Sprig
                { 15, 45788 }, -- Freya's Sigil
                { 16, 45653 }, -- Legplates of the Wayward Conqueror
                { 17, 45654 }, -- Legplates of the Wayward Protector
                { 18, 45655 }, -- Legplates of the Wayward Vanquisher
                { 20, 46110 }, -- Alchemist's Cache
                { 22, "SPECIAL_ACHIEVEMENT", nil, AL["Achievements"], nil, "AC_UlduarFreya10" },
            },
            [RAID25_DIFF] = {
                { 1, 45483 }, -- Boots of the Servant
                { 2, 45482 }, -- Leggings of the Lifetender
                { 3, 45481 }, -- Gauntlets of Ruthless Reprisal
                { 4, 45480 }, -- Nymph Heart Charm
                { 5, 45479 }, -- The Lifebinder
                { 8, "ac3187", nil, nil, AL["Hard Mode"] },
                { 9, 45486 }, -- Drape of the Sullen Goddess
                { 10, 45488 }, -- Leggings of the Enslaved Idol
                { 11, 45487 }, -- Handguards of Revitalization
                { 12, 45485 }, -- Bronze Pendant of the Vanir
                { 13, 45484 }, -- Bladetwister
                { 14, 45613 }, -- Dreambinder
                { 15, 45814 }, -- Freya's Sigil
                { 16, 45038 }, -- Fragment of Val'anyr
                { 18, 45653 }, -- Legplates of the Wayward Conqueror
                { 19, 45654 }, -- Legplates of the Wayward Protector
                { 20, 45655 }, -- Legplates of the Wayward Vanquisher
                { 22, 46110 }, -- Alchemist's Cache
                { 24, "SPECIAL_ACHIEVEMENT", nil, AL["Achievements"], nil, "AC_UlduarFreya25" },
            }
        },
        { -- UlduarMimiron
            name = AL["Mimiron"],
            npcID = 33350,
            EncounterJournalID = 1647,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapFile = "UlduarD",
            AtlasMapBossID = 15,
            [RAID10_DIFF] = {
                { 1, 45493 }, -- Asimov's Drape
                { 2, 45492 }, -- Malleable Steelweave Mantle
                { 3, 45491 }, -- Waistguard of the Creator
                { 4, 45490 }, -- Pandora's Plea
                { 5, 45489 }, -- Insanity's Grip
                { 9, "ac3180", nil, nil, AL["Hard Mode"] },
                { 10, 45993 }, -- Mimiron's Flight Goggles
                { 11, 45989 }, -- Tempered Mercury Greaves
                { 12, 45982 }, -- Fused Alloy Legplates
                { 13, 45988 }, -- Greaves of the Iron Army
                { 14, 45990 }, -- Fusion Blade
                { 15, 45787 }, -- Mimiron's Sigil
                { 16, 45641 }, -- Gauntlets of the Wayward Conqueror
                { 17, 45642 }, -- Gauntlets of the Wayward Protector
                { 18, 45643 }, -- Gauntlets of the Wayward Vanquisher
                { 20, "ac3180" },
				{ 21, "ac3138" },
				{ 22, "ac2989" },
            },
            [RAID25_DIFF] = {
                { 1, 45493 }, -- Asimov's Drape
                { 2, 45492 }, -- Malleable Steelweave Mantle
                { 3, 45491 }, -- Waistguard of the Creator
                { 4, 45490 }, -- Pandora's Plea
                { 5, 45489 }, -- Insanity's Grip
                { 8, "ac3189", nil, nil, AL["Hard Mode"] },
                { 9, 45496 }, -- Titanskin Cloak
                { 10, 45497 }, -- Crown of Luminescence
                { 11, 45663 }, -- Armbands of Bedlam
                { 12, 45495 }, -- Conductive Seal
                { 13, 45494 }, -- Delirium's Touch
                { 14, 45620 }, -- Starshard Edge
                { 15, 45816 }, -- Mimiron's Sigil
                { 16, 45038 }, -- Fragment of Val'anyr
                { 18, 45641 }, -- Gauntlets of the Wayward Conqueror
                { 19, 45642 }, -- Gauntlets of the Wayward Protector
                { 20, 45643 }, -- Gauntlets of the Wayward Vanquisher
                { 22, "ac3189" },
				{ 23, "ac2995" },
				{ 24, "ac3237" },
            }
        },
        { -- UlduarGeneralVezax
            name = AL["General Vezax"],
            NameColor = PURPLE,
            npcID = 33271,
            EncounterJournalID = 1648,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapFile = "UlduarE",
            AtlasMapBossID = 16,
            [RAID10_DIFF] = {
                { 1, 45514 }, -- Mantle of the Unknowing
                { 2, 45508 }, -- Belt of the Darkspeaker
                { 3, 45512 }, -- Grips of the Unbroken
                { 4, 45504 }, -- Darkcore Leggings
                { 5, 45513 }, -- Boots of the Forgotten Depths
                { 6, 45502 }, -- Helm of the Faceless
                { 7, 45505 }, -- Belt of Clinging Hope
                { 8, 45501 }, -- Boots of the Underdweller
                { 9, 45503 }, -- Metallic Loop of the Sufferer
                { 10, 45515 }, -- Ring of the Vacant Eye
                { 11, 45507 }, -- The General's Heart
                { 12, 45509 }, -- Idol of the Corruptor
                { 13, 45145 }, -- Libram of the Sacred Shield
                { 14, 45498 }, -- Lotrafen, Spear of the Damned
                { 15, 45511 }, -- Scepter of Lost Souls
                { 16, "ac3181" },
				{ 17, "ac2996" },
                { 25, "ac3181", nil, nil, AL["Hard Mode"] },
                { 26, 46032 }, -- Drape of the Faceless General
                { 27, 46034 }, -- Leggings of Profound Darkness
                { 28, 46036 }, -- Void Sabre
                { 29, 46035 }, -- Aesuga, Hand of the Ardent Champion
                { 30, 46033 }, -- Tortured Earth
            },
            [RAID25_DIFF] = {
                { 1, 45514 }, -- Mantle of the Unknowing
                { 2, 45508 }, -- Belt of the Darkspeaker
                { 3, 45512 }, -- Grips of the Unbroken
                { 4, 45504 }, -- Darkcore Leggings
                { 5, 45513 }, -- Boots of the Forgotten Depths
                { 6, 45502 }, -- Helm of the Faceless
                { 7, 45505 }, -- Belt of Clinging Hope
                { 8, 45501 }, -- Boots of the Underdweller
                { 9, 45503 }, -- Metallic Loop of the Sufferer
                { 10, 45515 }, -- Ring of the Vacant Eye
                { 11, 45507 }, -- The General's Heart
                { 12, 45509 }, -- Idol of the Corruptor
                { 13, 45145 }, -- Libram of the Sacred Shield
                { 14, 45498 }, -- Lotrafen, Spear of the Damned
                { 15, 45511 }, -- Scepter of Lost Souls
                { 16, 45038 }, -- Fragment of Val'anyr
                { 18, "ac3188" },
				{ 19, "ac2997" },
                { 25, "ac3188", nil, nil, AL["Hard Mode"] },
                { 26, 45520 }, -- Handwraps of the Vigilant
                { 27, 45519 }, -- Vestments of the Blind Denizen
                { 28, 45517 }, -- Pendulum of Infinity
                { 29, 45518 }, -- Flare of the Heavens
                { 30, 45516 }, -- Voldrethar, Dark Blade of Oblivion
            }
        },
        { -- UlduarGeneralVezax
            name = AL["Yogg-Saron"],
            NameColor = PURPLE,
            npcID = 33271,
            EncounterJournalID = 1648,
            Level = 999,
            --DisplayIDs = {{17386}},
            AtlasMapFile = "UlduarE",
            AtlasMapBossID = 17,
            [RAID10_DIFF] = {
                { 1, 45529 }, -- Shawl of Haunted Memories
                { 2, 45532 }, -- Cowl of Dark Whispers
                { 3, 45523 }, -- Garona's Guise
                { 4, 45524 }, -- Chestguard of Insidious Intent
                { 5, 45531 }, -- Chestguard of the Fallen God
                { 6, 45525 }, -- Godbane Signet
                { 7, 45530 }, -- Sanity's Bond
                { 8, 45522 }, -- Blood of the Old God
                { 9, 45527 }, -- Soulscribe
                { 10, 45521 }, -- Earthshaper
                { 12, "SPECIAL_ACHIEVEMENT", nil, AL["Achievements"], nil, "AC_UlduarYoggSaron10" },
                { 16, 45656 }, -- Mantle of the Wayward Conqueror
                { 17, 45657 }, -- Mantle of the Wayward Protector
                { 18, 45658 }, -- Mantle of the Wayward Vanquisher
                { 22, "ac3158", nil, nil, AL["Hard Mode"] },
                { 23, 46068 }, -- Amice of Inconceivable Horror
                { 24, 46095 }, -- Soul-Devouring Cinch
                { 25, 46096 }, -- Signet of Soft Lament
                { 26, 46097 }, -- Caress of Insanity
                { 27, 46067 }, -- Hammer of Crushing Whispers
                { 29, "ac3159", nil, nil, AL["Hard Mode"] },
                { 30, 46312 }, -- Vanquished Clutches of Yogg-Saron
            },
            [RAID25_DIFF] = {
                { 1, 45529 }, -- Shawl of Haunted Memories
                { 2, 45532 }, -- Cowl of Dark Whispers
                { 3, 45523 }, -- Garona's Guise
                { 4, 45524 }, -- Chestguard of Insidious Intent
                { 5, 45531 }, -- Chestguard of the Fallen God
                { 6, 45525 }, -- Godbane Signet
                { 7, 45530 }, -- Sanity's Bond
                { 8, 45522 }, -- Blood of the Old God
                { 9, 45527 }, -- Soulscribe
                { 10, 45521 }, -- Earthshaper
                { 12, "SPECIAL_ACHIEVEMENT", nil, AL["Achievements"], nil, "AC_UlduarYoggSaron25" },
                { 16, 45038 }, -- Fragment of Val'anyr
                { 18, 45656 }, -- Mantle of the Wayward Conqueror
                { 19, 45657 }, -- Mantle of the Wayward Protector
                { 20, 45658 }, -- Mantle of the Wayward Vanquisher
                { 22, "ac3163", nil, nil, AL["Hard Mode"] },
                { 23, 45537 }, -- Treads of the False Oracle
                { 24, 45536 }, -- Legguards of Cunning Deception
                { 25, 45534 }, -- Seal of the Betrayed King
                { 26, 45535 }, -- Show of Faith
                { 27, 45533 }, -- Dark Edge of Depravity
                { 29, "ac3164", nil, nil, AL["Hard Mode"] },
                { 30, 45693 }, -- Mimiron's Head
            }
        },
        { -- Trash
            name = AL["Trash"],
            ExtraList = true,
            [RAID10_DIFF] = {
                { 1, 45541 },	-- Shroud of Alteration
				{ 2, 45549 },	-- Grips of Chaos
				{ 3, 45547 },	-- Relic Hunter's Cord
				{ 4, 45548 },	-- Belt of the Sleeper
				{ 5, 45543 },	-- Shoulders of Misfortune
				{ 6, 45544 },	-- Leggings of the Tortured Earth
				{ 7, 45542 },	-- Greaves of the Stonewarder
				{ 9, 45540 },	-- Bladebearer's Signet
				{ 10, 45539 },	-- Pendant of Focused Energies
				{ 11, 45538 },	-- Titanstone Pendant
				{ 16, 45605 },	-- Daschal's Bite
            },
            [RAID25_DIFF] = {
                { 1, 45541 },	-- Shroud of Alteration
				{ 2, 45549 },	-- Grips of Chaos
				{ 3, 45547 },	-- Relic Hunter's Cord
				{ 4, 45548 },	-- Belt of the Sleeper
				{ 5, 45543 },	-- Shoulders of Misfortune
				{ 6, 45544 },	-- Leggings of the Tortured Earth
				{ 7, 45542 },	-- Greaves of the Stonewarder
				{ 9, 45540 },	-- Bladebearer's Signet
				{ 10, 45539 },	-- Pendant of Focused Energies
				{ 11, 45538 },	-- Titanstone Pendant
				{ 16, 45605 },	-- Daschal's Bite
            },
        },
        { -- Patterns
            name = AL["Patterns"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 45089 },	-- Plans: Battlelord's Plate Boots
				{ 2, 45088 },	-- Plans: Belt of the Titans
				{ 3, 45092 },	-- Plans: Indestructible Plate Girdle
				{ 4, 45090 },	-- Plans: Plate Girdle of Righteousness
				{ 5, 45093 },	-- Plans: Spiked Deathdealers
				{ 6, 45091 },	-- Plans: Treads of Destiny
				{ 8, 45100 },	-- Pattern: Belt of Arctic Life
				{ 9, 45094 },	-- Pattern: Belt of Dragons
				{ 10, 45096 },	-- Pattern: Blue Belt of Chaos
				{ 11, 45095 },	-- Pattern: Boots of Living Scale
				{ 12, 45101 },	-- Pattern: Boots of Wintry Endurance
				{ 13, 45098 },	-- Pattern: Death-warmed Belt
				{ 14, 45099 },	-- Pattern: Footpads of Silence
				{ 15, 45097 },	-- Pattern: Lightning Grounded Boots
				{ 16, 45104 },	-- Pattern: Cord of the White Dawn
				{ 17, 45102 },	-- Pattern: Sash of Ancient Power
				{ 18, 45105 },	-- Pattern: Savior's Slippers
				{ 19, 45103 },	-- Pattern: Spellslinger's Slippers
				{ 21, 46027 },	-- Formula: Enchant Weapon - Blade Ward
				{ 22, 46348 },	-- Formula: Enchant Weapon - Blood Draining
            },
        },
        T8_SET,
        WOTLK_ULDUAR_AC_TABLE,
    }
}

data["MagtheridonsLair80"] = {
	MapID = 3836,
	InstanceID = 544,
    name = AL["P7 Magtheridon's Lair"],
	AtlasModule = ATLAS_TBC_MODULE_NAME,
	AtlasMapID = "CL_HCMagtheridonsLair",
	AtlasMapFile = {"CL_HCMagtheridonsLair", "HellfireCitadelEnt"},
	ContentType = RAID_CONTENT,
	items = {
        { -- HCMagtheridon
            name = AL["Magtheridon"],
            npcID = 17257,
            Level = 999,
            DisplayIDs = {{18527}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 28777 }, -- Cloak of the Pit Stalker
                { 2, 28780 }, -- Soul-Eater's Handwraps
                { 3, 28776 }, -- Liar's Tongue Gloves
                { 4, 28778 }, -- Terror Pit Girdle
                { 5, 28775 }, -- Thundering Greathelm
                { 6, 28779 }, -- Girdle of the Endless Pit
                { 7, 28789 }, -- Eye of Magtheridon
                { 8, 28781 }, -- Karaborian Talisman
                { 10, 28774 }, -- Glaive of the Pit
                { 11, 28782 }, -- Crystalheart Pulse-Staff
                { 12, 29458 }, -- Aegis of the Vindicator
                { 13, 28783 }, -- Eredar Wand of Obliteration
                { 16, 29754 }, -- Chestguard of the Fallen Champion
                { 17, 29753 }, -- Chestguard of the Fallen Defender
                { 18, 29755 }, -- Chestguard of the Fallen Hero
                { 20, 32385 }, -- Magtheridon's Head
                { 22, 34845 }, -- Pit Lord's Satchel
                { 24, 34846 }, -- Black Sack of Gems
            }
        },
        T4_SET
    }
}

data["GruulsLair80"] = {
	MapID = 3923,
	InstanceID = 565,
    name = AL["P7 Gruul's Lair"],
	AtlasModule = ATLAS_TBC_MODULE_NAME,
	AtlasMapID = "CL_GruulsLair",
	AtlasMapFile = "CL_GruulsLair",
	ContentType = RAID_CONTENT,
	items = {
        { -- GruulsLairHighKingMaulgar
            name = AL["High King Maulgar"],
            npcID = 18831,
            Level = 999,
            DisplayIDs = {{18649},{12472},{11585},{20195},{20194}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 28797 }, -- Brute Cloak of the Ogre-Magi
                { 2, 28799 }, -- Belt of Divine Inspiration
                { 3, 28796 }, -- Malefic Mask of the Shadows
                { 4, 28801 }, -- Maulgar's Warhelm
                { 5, 28795 }, -- Bladespire Warbands
                { 6, 28800 }, -- Hammer of the Naaru
                { 16, 29763 }, -- Pauldrons of the Fallen Champion
                { 17, 29764 }, -- Pauldrons of the Fallen Defender
                { 18, 29762 }, -- Pauldrons of the Fallen Hero
            }
        },
        { -- GruulGruul
            name = AL["Gruul the Dragonkiller"],
            npcID = 19044,
            Level = 999,
            DisplayIDs = {{18698}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 28804 }, -- Collar of Cho'gall
                { 2, 28803 }, -- Cowl of Nature's Breath
                { 3, 28828 }, -- Gronn-Stitched Girdle
                { 4, 28827 }, -- Gauntlets of the Dragonslayer
                { 5, 28810 }, -- Windshear Boots
                { 6, 28824 }, -- Gauntlets of Martial Perfection
                { 7, 28822 }, -- Teeth of Gruul
                { 8, 28823 }, -- Eye of Gruul
                { 9, 28830 }, -- Dragonspine Trophy
                { 11, 31750 }, -- Earthen Signet
                { 16, 29766 }, -- Leggings of the Fallen Champion
                { 17, 29767 }, -- Leggings of the Fallen Defender
                { 18, 29765 }, -- Leggings of the Fallen Hero
                { 20, 28802 }, -- Bloodmaw Magus-Blade
                { 21, 28794 }, -- Axe of the Gronn Lords
                { 22, 28825 }, -- Aldori Legacy Defender
                { 23, 28826 }, -- Shuriken of Negation
            }
        },
        T4_SET
    }
}
local KARA_MAPDATA_END = {"CL_KarazhanEnd", "CL_KarazhanEnt"}
data["Karazhan80"] = {
	MapID = 3457,
	InstanceID = 532,
    name = AL["P7 Karazhan"],
	AtlasModule = ATLAS_TBC_MODULE_NAME,
	AtlasMapID = "CL_KarazhanStart",
	AtlasMapFile = {"CL_KarazhanStart", "CL_KarazhanEnt"},
	ContentType = RAID_CONTENT,
	items = {
        { -- KaraAttumen
            name = AL["Attumen the Huntsman"],
            npcID = 16152,
            Level = 999,
            DisplayIDs = {{16040}},
            AtlasMapBossID = 5,
            [NORMAL_DIFF] = {
                { 1, 28477 }, -- Harbinger Bands
                { 2, 28507 }, -- Handwraps of Flowing Thought
                { 3, 28508 }, -- Gloves of Saintly Blessings
                { 4, 28453 }, -- Bracers of the White Stag
                { 5, 28506 }, -- Gloves of Dexterous Manipulation
                { 6, 28503 }, -- Whirlwind Bracers
                { 7, 28454 }, -- Stalker's War Bands
                { 8, 28502 }, -- Vambraces of Courage
                { 9, 28505 }, -- Gauntlets of Renewed Hope
                --{ 11, 29434 }, -- Badge of Justice
                { 16, 28509 }, -- Worgen Claw Necklace
                { 17, 28510 }, -- Spectral Band of Innervation
                { 18, 28504 }, -- Steelhawk Crossbow
                { 20, 30480 }, -- Fiery Warhorse's Reins
                { 22, 23809 }, -- Schematic: Stabilized Eternium Scope
            }
        },
        { -- KaraNamed
            name = AL["Rokad the Ravager"],
            nameFormat = NAME_KARA_QUARTERS,
            npcID = 16181,
            Level = 999,
            DisplayIDs = {{16054}},
            specialType = "rare",
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 30684 }, -- Ravager's Cuffs
                { 2, 30685 }, -- Ravager's Wrist-Wraps
                { 3, 30686 }, -- Ravager's Bands
                { 4, 30687 }, -- Ravager's Bracers
            }
        },
        { -- KaraNamed
            name = AL["Shadikith the Glider"],
            nameFormat = NAME_KARA_QUARTERS,
            npcID = 16180,
            Level = 999,
            DisplayIDs = {{16053}},
            specialType = "rare",
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 30680 }, -- Glider's Foot-Wraps
                { 2, 30681 }, -- Glider's Boots
                { 3, 30682 }, -- Glider's Sabatons
                { 4, 30683 }, -- Glider's Greaves
            }
        },
        { -- KaraNamed
            name = AL["Hyakiss the Lurker"],
            nameFormat = NAME_KARA_QUARTERS,
            npcID = 16179,
            Level = 999,
            DisplayIDs = {{15938}},
            specialType = "rare",
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 30675 }, -- Lurker's Cord
                { 2, 30676 }, -- Lurker's Grasp
                { 3, 30677 }, -- Lurker's Belt
                { 4, 30678 }, -- Lurker's Girdle
            }
        },
        { -- KaraMoroes
            name = AL["Moroes"],
            npcID = 15687,
            Level = 999,
            DisplayIDs = {{16540},{19327},{16637},{16640},{16639},{19328},{16638}},
            AtlasMapBossID = 7,
            [NORMAL_DIFF] = {
                { 1, 28529 }, -- Royal Cloak of Arathi Kings
                { 2, 28570 }, -- Shadow-Cloak of Dalaran
                { 3, 28565 }, -- Nethershard Girdle
                { 4, 28545 }, -- Edgewalker Longboots
                { 5, 28567 }, -- Belt of Gale Force
                { 6, 28566 }, -- Crimson Girdle of the Indomitable
                { 7, 28569 }, -- Boots of Valiance
                --{ 9, 29434 }, -- Badge of Justice
                { 16, 28530 }, -- Brooch of Unquenchable Fury
                { 17, 28528 }, -- Moroes' Lucky Pocket Watch
                { 18, 28525 }, -- Signet of Unshakable Faith
                { 19, 28568 }, -- Idol of the Avian Heart
                { 20, 28524 }, -- Emerald Ripper
                { 22, 22559 }, -- Formula: Enchant Weapon - Mongoose
            }
        },
        { -- KaraMaiden
            name = AL["Maiden of Virtue"],
            npcID = 16457,
            Level = 999,
            DisplayIDs = {{16198}},
            AtlasMapBossID = 11,
            [NORMAL_DIFF] = {
                { 1, 28511 }, -- Bands of Indwelling
                { 2, 28515 }, -- Bands of Nefarious Deeds
                { 3, 28517 }, -- Boots of Foretelling
                { 4, 28514 }, -- Bracers of Maliciousness
                { 5, 28521 }, -- Mitts of the Treemender
                { 6, 28520 }, -- Gloves of Centering
                { 7, 28519 }, -- Gloves of Quickening
                { 8, 28512 }, -- Bracers of Justice
                { 9, 28518 }, -- Iron Gauntlets of the Maiden
                --{ 11, 29434 }, -- Badge of Justice
                { 16, 28516 }, -- Barbed Choker of Discipline
                { 17, 28523 }, -- Totem of Healing Rains
                { 18, 28522 }, -- Shard of the Virtuous
            }
        },
        { -- KaraOperaEvent
            name = AL["The Wizard of Oz"],
            nameFormat = NAME_KARA_OPERA,
            npcID = {18168,17535,17548,17543,17547,17546},
            Level = 999,
            DisplayIDs = {{18168},{17069},{17079},{17076},{17187},{18261}},
            AtlasMapBossID = 14,
            [NORMAL_DIFF] = {
                { 1, 28586 }, -- Wicked Witch's Hat
                { 2, 28585 }, -- Ruby Slippers
                { 3, 28587 }, -- Legacy
                { 4, 28588 }, -- Blue Diamond Witchwand
                --{ 6, 29434 }, -- Badge of Justice
                { 16, 28594 }, -- Trial-Fire Trousers
                { 17, 28591 }, -- Earthsoul Leggings
                { 18, 28589 }, -- Beastmaw Pauldrons
                { 19, 28593 }, -- Eternium Greathelm
                { 20, 28590 }, -- Ribbon of Sacrifice
                { 21, 28592 }, -- Libram of Souls Redeemed
            }
        },
        { -- KaraOperaEvent
            name = AL["The Big Bad Wolf"],
            nameFormat = NAME_KARA_OPERA,
            npcID = 17521,
            Level = 999,
            DisplayIDs = {{17121},{17053}},
            AtlasMapBossID = 14,
            [NORMAL_DIFF] = {
                { 1, 28582 }, -- Red Riding Hood's Cloak
                { 2, 28583 }, -- Big Bad Wolf's Head
                { 3, 28584 }, -- Big Bad Wolf's Paw
                { 4, 28581 }, -- Wolfslayer Sniper Rifle
                --{ 6, 29434 }, -- Badge of Justice
                { 16, 28594 }, -- Trial-Fire Trousers
                { 17, 28591 }, -- Earthsoul Leggings
                { 18, 28589 }, -- Beastmaw Pauldrons
                { 19, 28593 }, -- Eternium Greathelm
                { 20, 28590 }, -- Ribbon of Sacrifice
                { 21, 28592 }, -- Libram of Souls Redeemed
            }
        },
        { -- KaraOperaEvent
            name = AL["Romulo and Julianne"],
            nameFormat = NAME_KARA_OPERA,
            npcID = {17533,17534},
            Level = 999,
            DisplayIDs = {{17067},{17068}},
            AtlasMapBossID = 14,
            [NORMAL_DIFF] = {
                { 1, 28578 }, -- Masquerade Gown
                { 2, 28579 }, -- Romulo's Poison Vial
                { 3, 28572 }, -- Blade of the Unrequited
                { 4, 28573 }, -- Despair
                --{ 6, 29434 }, -- Badge of Justice
                { 16, 28594 }, -- Trial-Fire Trousers
                { 17, 28591 }, -- Earthsoul Leggings
                { 18, 28589 }, -- Beastmaw Pauldrons
                { 19, 28593 }, -- Eternium Greathelm
                { 20, 28590 }, -- Ribbon of Sacrifice
                { 21, 28592 }, -- Libram of Souls Redeemed
            }
        },
        { -- KaraCurator
            name = AL["The Curator"],
            npcID = 15691,
            Level = 999,
            DisplayIDs = {{16958}},
            AtlasMapFile = KARA_MAPDATA_END,
            AtlasMapBossID = 16,
            [NORMAL_DIFF] = {
                { 1, 28612 }, -- Pauldrons of the Solace-Giver
                { 2, 28647 }, -- Forest Wind Shoulderpads
                { 3, 28631 }, -- Dragon-Quake Shoulderguards
                { 4, 28621 }, -- Wrynn Dynasty Greaves
                { 5, 28649 }, -- Garona's Signet Ring
                { 6, 28633 }, -- Staff of Infinite Mysteries
                --{ 8, 29434 }, -- Badge of Justice
                { 16, 29757 }, -- Gloves of the Fallen Champion
                { 17, 29758 }, -- Gloves of the Fallen Defender
                { 18, 29756 }, -- Gloves of the Fallen Hero
            }
        },
        { -- KaraIllhoof
            name = AL["Terestian Illhoof"],
            npcID = 15688,
            Level = 999,
            DisplayIDs = {{11343}},
            AtlasMapFile = KARA_MAPDATA_END,
            AtlasMapBossID = 20,
            [NORMAL_DIFF] = {
                { 1, 28660 }, -- Gilded Thorium Cloak
                { 2, 28653 }, -- Shadowvine Cloak of Infusion
                { 3, 28652 }, -- Cincture of Will
                { 4, 28654 }, -- Malefic Girdle
                { 5, 28655 }, -- Cord of Nature's Sustenance
                { 6, 28656 }, -- Girdle of the Prowler
                { 7, 28662 }, -- Breastplate of the Lightbinder
                --{ 9, 29434 }, -- Badge of Justice
                { 16, 28661 }, -- Mender's Heart-Ring
                { 17, 28785 }, -- The Lightning Capacitor
                { 18, 28657 }, -- Fool's Bane
                { 19, 28658 }, -- Terestian's Stranglestaff
                { 20, 28659 }, -- Xavian Stiletto
                { 22, 22561 }, -- Formula: Enchant Weapon - Soulfrost
            }
        },
        { -- KaraAran
            name = AL["Shade of Aran"],
            npcID = 16524,
            Level = 999,
            DisplayIDs = {{16621}},
            AtlasMapFile = KARA_MAPDATA_END,
            AtlasMapBossID = 21,
            [NORMAL_DIFF] = {
                { 1, 28672 }, -- Drape of the Dark Reavers
                { 2, 28726 }, -- Mantle of the Mind Flayer
                { 3, 28670 }, -- Boots of the Infernal Coven
                { 4, 28663 }, -- Boots of the Incorrupt
                { 5, 28669 }, -- Rapscallion Boots
                { 6, 28671 }, -- Steelspine Faceguard
                { 7, 28666 }, -- Pauldrons of the Justice-Seeker
                --{ 9, 29434 }, -- Badge of Justice
                { 9, 23933 }, -- Medivh's Journal
                { 16, 28674 }, -- Saberclaw Talisman
                { 17, 28675 }, -- Shermanar Great-Ring
                { 18, 28727 }, -- Pendant of the Violet Eye
                { 19, 28728 }, -- Aran's Soothing Sapphire
                { 20, 28673 }, -- Tirisfal Wand of Ascendancy
                { 22, 22560 }, -- Formula: Enchant Weapon - Sunfire
            }
        },
        { -- KaraNetherspite
            name = AL["Netherspite"],
            npcID = 15689,
            Level = 999,
            DisplayIDs = {{15363}},
            AtlasMapFile = KARA_MAPDATA_END,
            AtlasMapBossID = 22,
            [NORMAL_DIFF] = {
                { 1, 28744 }, -- Uni-Mind Headdress
                { 2, 28742 }, -- Pantaloons of Repentance
                { 3, 28732 }, -- Cowl of Defiance
                { 4, 28741 }, -- Skulker's Greaves
                { 5, 28735 }, -- Earthblood Chestguard
                { 6, 28740 }, -- Rip-Flayer Leggings
                { 7, 28743 }, -- Mantle of Abrahmis
                { 8, 28733 }, -- Girdle of Truth
                --{ 10, 29434 }, -- Badge of Justice
                { 16, 28731 }, -- Shining Chain of the Afterworld
                { 17, 28730 }, -- Mithril Band of the Unscarred
                { 18, 28734 }, -- Jewel of Infinite Possibilities
                { 19, 28729 }, -- Spiteblade
            }
        },
        { -- KaraChess
            name = AL["Chess Event"],
            ObjectID = 185119,
            Level = 999,
            DisplayIDs = {{51}},
            AtlasMapFile = KARA_MAPDATA_END,
            AtlasMapBossID = 25,
            [NORMAL_DIFF] = {
                { 1, 28756 }, -- Headdress of the High Potentate
                { 2, 28755 }, -- Bladed Shoulderpads of the Merciless
                { 3, 28750 }, -- Girdle of Treachery
                { 4, 28752 }, -- Forestlord Striders
                { 5, 28751 }, -- Heart-Flame Leggings
                { 6, 28746 }, -- Fiend Slayer Boots
                { 7, 28748 }, -- Legplates of the Innocent
                { 8, 28747 }, -- Battlescar Boots
                --{ 10, 29434 }, -- Badge of Justice
                { 16, 28745 }, -- Mithril Chain of Heroism
                { 17, 28753 }, -- Ring of Recurrence
                { 18, 28749 }, -- King's Defender
                { 19, 28754 }, -- Triptych Shield of the Ancients
            }
        },
        { -- KaraPrince
            name = AL["Prince Malchezaar"],
            npcID = 15690,
            Level = 999,
            DisplayIDs = {{19274}},
            AtlasMapFile = KARA_MAPDATA_END,
            AtlasMapBossID = 26,
            [NORMAL_DIFF] = {
                { 1, 28765 }, -- Stainless Cloak of the Pure Hearted
                { 2, 28766 }, -- Ruby Drape of the Mysticant
                { 3, 28764 }, -- Farstrider Wildercloak
                { 4, 28762 }, -- Adornment of Stolen Souls
                { 5, 28763 }, -- Jade Ring of the Everliving
                { 6, 28757 }, -- Ring of a Thousand Marks
                { 8, 28770 }, -- Nathrezim Mindblade
                { 9, 28768 }, -- Malchazeen
                { 10, 28767 }, -- The Decapitator
                { 11, 28773 }, -- Gorehowl
                { 12, 28771 }, -- Light's Justice
                { 13, 28772 }, -- Sunfury Bow of the Phoenix
                --{ 15, 29434 }, -- Badge of Justice
                { 16, 29760 }, -- Helm of the Fallen Champion
                { 17, 29761 }, -- Helm of the Fallen Defender
                { 18, 29759 }, -- Helm of the Fallen Hero
            }
        },
        { -- KaraNightbane
            name = AL["Nightbane"],
            npcID = 17225,
            Level = 999,
            DisplayIDs = {{18062}},
            specialType = "summon",
            AtlasMapBossID = 15,
            [NORMAL_DIFF] = {
                { 1, 28602 }, -- Robe of the Elder Scribes
                { 2, 28600 }, -- Stonebough Jerkin
                { 3, 28601 }, -- Chestguard of the Conniver
                { 4, 28599 }, -- Scaled Breastplate of Carnage
                { 5, 28610 }, -- Ferocious Swift-Kickers
                { 6, 28597 }, -- Panzar'Thar Breastplate
                { 7, 28608 }, -- Ironstriders of Urgency
                --{ 9, 29434 }, -- Badge of Justice
                { 9, 31751 }, -- Blazing Signet
                { 10, 24139 }, -- Faint Arcane Essence
                { 16, 28609 }, -- Emberspur Talisman
                { 17, 28603 }, -- Talisman of Nightbane
                { 18, 28604 }, -- Nightstaff of the Everliving
                { 19, 28611 }, -- Dragonheart Flameshield
                { 20, 28606 }, -- Shield of Impenetrable Darkness
            }
        },
        { -- KaraTrash
            name = AL["Trash"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 30642 }, -- Drape of the Righteous
                { 2, 30668 }, -- Grasp of the Dead
                { 3, 30673 }, -- Inferno Waist Cord
                { 4, 30644 }, -- Grips of Deftness
                { 5, 30674 }, -- Zierhut's Lost Treads
                { 6, 30643 }, -- Belt of the Tracker
                { 7, 30641 }, -- Boots of Elusion
                { 9, 23857 }, -- Legacy of the Mountain King
                { 10, 23864 }, -- Torment of the Worgen
                { 11, 23862 }, -- Redemption of the Fallen
                { 12, 23865 }, -- Wrath of the Titans
                { 14, 21882 }, -- Soul Essence
                { 16, 30666 }, -- Ritssyn's Lost Pendant
                { 17, 30667 }, -- Ring of Unrelenting Storms
                { 19, 21903 }, -- Pattern: Soulcloth Shoulders
                { 20, 21904 }, -- Pattern: Soulcloth Vest
                { 21, 22545 }, -- Formula: Enchant Boots - Surefooted
            }
        },
        AtlasLoot:GameVersion_GE(AtlasLoot.WRATH_VERSION_NUM, { -- KaraPrinceT
			name = AL["Prince Tenris Mirkblood"],
			npcID = 28194,
			Level = 999,
			DisplayIDs = {{25541}},
			AtlasMapBossID = 5,
			specialType = "scourgeInvasion",
			ExtraList = true,
			[NORMAL_DIFF] = {
				{ 1,  38658 }, -- Vampiric Batling
				{ 2,  39769 }, -- Arcanite Ripper
			},
		}),
        T4_SET
    }
}
data["BlackwingLair80"] = {
	MapID = 2677,
    name = AL["P8 Blackwing Lair"],
	InstanceID = 469,
	AtlasModule = ATLAS_ERA_MODULE_NAME,
	AtlasMapID = "BlackwingLair",
	AtlasMapFile = "CL_BlackwingLair",
	AtlasMapFile_AL = "BlackwingLair",
	ContentType = RAID_CONTENT,
	items = {
		{ -- BWLRazorgore
			name = AL["Razorgore the Untamed"],
			npcID = 12435,
			Level = 999,
			DisplayIDs = {{10115}},
			AtlasMapBossID = 1,
			[NORMAL_DIFF] = {
				{ 1,  16926 }, -- Bindings of Transcendence
				{ 2,  16918 }, -- Netherwind Bindings
				{ 3,  16934 }, -- Nemesis Bracers
				{ 4,  16911 }, -- Bloodfang Bracers
				{ 5,  16904 }, -- Stormrage Bracers
				{ 6,  16935 }, -- Dragonstalker's Bracers
				{ 7,  16943 }, -- Bracers of Ten Storms
				{ 8,  16951 }, -- Judgement Bindings
				{ 9,  16959 }, -- Bracelets of Wrath
				{ 16, 19336 }, -- Arcane Infused Gem
				{ 17, 19337 }, -- The Black Book
				{ 19, 19370 }, -- Mantle of the Blackwing Cabal
				{ 20, 19369 }, -- Gloves of Rapid Evolution
				{ 21, 19335 }, -- Spineshatter
				{ 22, 19334 }, -- The Untamed Blade
			},
		},
		{ -- BWLVaelastrasz
			name = AL["Vaelastrasz the Corrupt"],
			npcID = 13020,
			Level = 999,
			DisplayIDs = {{13992}},
			AtlasMapBossID = 2,
			[NORMAL_DIFF] = {
				{ 1,  16925 }, -- Belt of Transcendence
				{ 2,  16818 }, -- Netherwind Belt
				{ 3,  16933 }, -- Nemesis Belt
				{ 4,  16910 }, -- Bloodfang Belt
				{ 5,  16903 }, -- Stormrage Belt
				{ 6,  16936 }, -- Dragonstalker's Belt
				{ 7,  16944 }, -- Belt of Ten Storms
				{ 8,  16952 }, -- Judgement Belt
				{ 9,  16960 }, -- Waistband of Wrath
				{ 16, 19339 }, -- Mind Quickening Gem
				{ 17, 19340 }, -- Rune of Metamorphosis
				{ 19, 19372 }, -- Helm of Endless Rage
				{ 20, 19371 }, -- Pendant of the Fallen Dragon
				{ 21, 19348 }, -- Red Dragonscale Protector
				{ 22, 19346 }, -- Dragonfang Blade
			},
		},
		{ -- BWLLashlayer
			name = AL["Broodlord Lashlayer"],
			npcID = 12017,
			Level = 999,
			DisplayIDs = {{14308}},
			AtlasMapBossID = 3,
			[NORMAL_DIFF] = {
				{ 1,  16919 }, -- Boots of Transcendence
				{ 2,  16912 }, -- Netherwind Boots
				{ 3,  16927 }, -- Nemesis Boots
				{ 4,  16906 }, -- Bloodfang Boots
				{ 5,  16898 }, -- Stormrage Boots
				{ 6,  16941 }, -- Dragonstalker's Greaves
				{ 7,  16949 }, -- Greaves of Ten Storms
				{ 8,  16957 }, -- Judgement Sabatons
				{ 9,  16965 }, -- Sabatons of Wrath
				{ 16, 19341 }, -- Lifegiving Gem
				{ 17, 19342 }, -- Venomous Totem
				{ 19, 19373 }, -- Black Brood Pauldrons
				{ 20, 19374 }, -- Bracers of Arcane Accuracy
				{ 21, 19350 }, -- Heartstriker
				{ 22, 19351 }, -- Maladath, Runed Blade of the Black Flight
				{ 24, 20383 }, -- Head of the Broodlord Lashlayer
			},
		},
		{ -- BWLFiremaw
			name = AL["Firemaw"],
			npcID = 11983,
			Level = 999,
			DisplayIDs = {{6377}},
			AtlasMapBossID = 4,
			[NORMAL_DIFF] = {
				{ 1,  16920 }, -- Handguards of Transcendence
				{ 2,  16913 }, -- Netherwind Gloves
				{ 3,  16928 }, -- Nemesis Gloves
				{ 4,  16907 }, -- Bloodfang Gloves
				{ 5,  16899 }, -- Stormrage Handguards
				{ 6,  16940 }, -- Dragonstalker's Gauntlets
				{ 7,  16948 }, -- Gauntlets of Ten Storms
				{ 8,  16956 }, -- Judgement Gauntlets
				{ 9,  16964 }, -- Gauntlets of Wrath
				{ 13, 19344 }, -- Natural Alignment Crystal
				{ 14, 19343 }, -- Scrolls of Blinding Light
				{ 16, 19394 }, -- Drake Talon Pauldrons
				{ 17, 19398 }, -- Cloak of Firemaw
				{ 18, 19399 }, -- Black Ash Robe
				{ 19, 19400 }, -- Firemaw's Clutch
				{ 20, 19396 }, -- Taut Dragonhide Belt
				{ 21, 19401 }, -- Primalist's Linked Legguards
				{ 22, 19402 }, -- Legguards of the Fallen Crusader
				{ 24, 19365 }, -- Claw of the Black Drake
				{ 25, 19353 }, -- Drake Talon Cleaver
				{ 26, 19355 }, -- Shadow Wing Focus Staff
				{ 28, 19397 }, -- Ring of Blackrock
				{ 29, 19395 }, -- Rejuvenating Gem
			},
		},
		{ -- BWLEbonroc
			name = AL["Ebonroc"],
			npcID = 14601,
			Level = 999,
			DisplayIDs = {{6377}},
			AtlasMapBossID = 5,
			[NORMAL_DIFF] = {
				{ 1,  16920 }, -- Handguards of Transcendence
				{ 2,  16913 }, -- Netherwind Gloves
				{ 3,  16928 }, -- Nemesis Gloves
				{ 4,  16907 }, -- Bloodfang Gloves
				{ 5,  16899 }, -- Stormrage Handguards
				{ 6,  16940 }, -- Dragonstalker's Gauntlets
				{ 7,  16948 }, -- Gauntlets of Ten Storms
				{ 8,  16956 }, -- Judgement Gauntlets
				{ 9,  16964 }, -- Gauntlets of Wrath
				{ 11, 19345 }, -- Aegis of Preservation
				{ 12, 19406 }, -- Drake Fang Talisman
				{ 13, 19395 }, -- Rejuvenating Gem
				{ 16, 19394 }, -- Drake Talon Pauldrons
				{ 17, 19407 }, -- Ebony Flame Gloves
				{ 18, 19396 }, -- Taut Dragonhide Belt
				{ 19, 19405 }, -- Malfurion's Blessed Bulwark
				{ 21, 19368 }, -- Dragonbreath Hand Cannon
				{ 22, 19353 }, -- Drake Talon Cleaver
				{ 23, 19355 }, -- Shadow Wing Focus Staff
				{ 26, 19403 }, -- Band of Forced Concentration
				{ 27, 19397 }, -- Ring of Blackrock

			},
		},
		{ -- BWLFlamegor
			name = AL["Flamegor"],
			npcID = 11981,
			Level = 999,
			DisplayIDs = {{6377}},
			AtlasMapBossID = 6,
			[NORMAL_DIFF] = {
				{ 1,  16920 }, -- Handguards of Transcendence
				{ 2,  16913 }, -- Netherwind Gloves
				{ 3,  16928 }, -- Nemesis Gloves
				{ 4,  16907 }, -- Bloodfang Gloves
				{ 5,  16899 }, -- Stormrage Handguards
				{ 6,  16940 }, -- Dragonstalker's Gauntlets
				{ 7,  16948 }, -- Gauntlets of Ten Storms
				{ 8,  16956 }, -- Judgement Gauntlets
				{ 9,  16964 }, -- Gauntlets of Wrath
				{ 11, 19395 }, -- Rejuvenating Gem
				{ 12, 19431 }, -- Styleen's Impeding Scarab
				{ 16, 19394 }, -- Drake Talon Pauldrons
				{ 17, 19430 }, -- Shroud of Pure Thought
				{ 18, 19396 }, -- Taut Dragonhide Belt
				{ 19, 19433 }, -- Emberweave Leggings
				{ 21, 19367 }, -- Dragon's Touch
				{ 22, 19353 }, -- Drake Talon Cleaver
				{ 23, 19357 }, -- Herald of Woe
				{ 24, 19355 }, -- Shadow Wing Focus Staff
				{ 26, 19432 }, -- Circle of Applied Force
				{ 27, 19397 }, -- Ring of Blackrock
			},
		},
		{ -- BWLChromaggus
			name = AL["Chromaggus"],
			npcID = 14020,
			Level = 999,
			DisplayIDs = {{14367}},
			AtlasMapBossID = 7,
			[NORMAL_DIFF] = {
				{ 1,  16924 }, -- Pauldrons of Transcendence
				{ 2,  16917 }, -- Netherwind Mantle
				{ 3,  16932 }, -- Nemesis Spaulders
				{ 4,  16832 }, -- Bloodfang Spaulders
				{ 5,  16902 }, -- Stormrage Pauldrons
				{ 6,  16937 }, -- Dragonstalker's Spaulders
				{ 7,  16945 }, -- Epaulets of Ten Storms
				{ 8,  16953 }, -- Judgement Spaulders
				{ 9,  16961 }, -- Pauldrons of Wrath
				{ 16, 19389 }, -- Taut Dragonhide Shoulderpads
				{ 17, 19386 }, -- Elementium Threaded Cloak
				{ 18, 19390 }, -- Taut Dragonhide Gloves
				{ 19, 19388 }, -- Angelista's Grasp
				{ 20, 19393 }, -- Primalist's Linked Waistguard
				{ 21, 19392 }, -- Girdle of the Fallen Crusader
				{ 22, 19385 }, -- Empowered Leggings
				{ 23, 19391 }, -- Shimmering Geta
				{ 24, 19387 }, -- Chromatic Boots
				{ 26, 19361 }, -- Ashjre'thul, Crossbow of Smiting
				{ 27, 19349 }, -- Elementium Reinforced Bulwark
				{ 28, 19347 }, -- Claw of Chromaggus
				{ 29, 19352 }, -- Chromatically Tempered Sword
			},
		},
		{ -- BWLNefarian
			name = AL["Nefarian"],
			npcID = 11583,
			Level = 999,
			DisplayIDs = {{11380}},
			AtlasMapBossID = 8,
			[NORMAL_DIFF] = {
				{ 1,  16923 }, -- Robes of Transcendence
				{ 2,  16916 }, -- Netherwind Robes
				{ 3,  16931 }, -- Nemesis Robes
				{ 4,  16905 }, -- Bloodfang Chestpiece
				{ 5,  16897 }, -- Stormrage Chestguard
				{ 6,  16942 }, -- Dragonstalker's Breastplate
				{ 7,  16950 }, -- Breastplate of Ten Storms
				{ 8,  16958 }, -- Judgement Breastplate
				{ 9,  16966 }, -- Breastplate of Wrath
				{ 11, 19003 }, -- Head of Nefarian
				{ 16, 19360 }, -- Lok'amir il Romathis
				{ 17, 19363 }, -- Crul'shorukh, Edge of Chaos
				{ 18, 19364 }, -- Ashkandi, Greatsword of the Brotherhood
				{ 19, 19356 }, -- Staff of the Shadow Flame
				{ 21, 19375 }, -- Mish'undare, Circlet of the Mind Flayer
				{ 22, 19377 }, -- Prestor's Talisman of Connivery
				{ 23, 19378 }, -- Cloak of the Brood Lord
				{ 24, 19380 }, -- Therazane's Link
				{ 25, 19381 }, -- Boots of the Shadow Flame
				{ 26, 19376 }, -- Archimtiros' Ring of Reckoning
				{ 27, 19382 }, -- Pure Elementium Band
				{ 28, 19379 }, -- Neltharion's Tear
				{ 30, 11938 }, -- Sack of Gems
				-- Hidden items
				{ 0, 17962 }, -- Blue Sack of Gems
				{ 0, 17963 }, -- Green Sack of Gems
				{ 0, 17964 }, -- Gray Sack of Gems
				{ 0, 17965 }, -- Yellow Sack of Gems
				{ 0, 17969 }, -- Red Sack of Gems
			},
		},
		{ -- BWLTrashMobs
			name = AL["Trash"],
			ExtraList = true,
			[NORMAL_DIFF] = {
				{ 1,  19436 }, -- Cloak of Draconic Might
				{ 2,  19439 }, -- Interlaced Shadow Jerkin
				{ 3,  19437 }, -- Boots of Pure Thought
				{ 4,  19438 }, -- Ringo's Blizzard Boots
				{ 5,  19434 }, -- Band of Dark Dominion
				{ 6,  19435 }, -- Essence Gatherer
				{ 7,  19362 }, -- Doom's Edge
				{ 8,  19354 }, -- Draconic Avenger
				{ 9,  19358 }, -- Draconic Maul
				{ 11, 18562 }, -- Elementium Ore
			},
		},
		T2_SET,
	},
}

data["TheRuinsofAhnQiraj80"] = { -- AQ20
	MapID = 3429,
	InstanceID = 509,
    name = AL["P8 The Ruins of Ahn'Qiraj"],
	AtlasModule = ATLAS_ERA_MODULE_NAME,
	AtlasMapID = "TheRuinsofAhnQiraj",
	AtlasMapFile = "CL_TheRuinsofAhnQiraj",
	AtlasMapFile_AL = "TheRuinsofAhnQiraj",
	ContentType = RAID_CONTENT,

	items = {
		{ -- AQ20Kurinnaxx
			name = AL["Kurinnaxx"],
			npcID = 15348,
			Level = 999,
			DisplayIDs = {{15742}},
			AtlasMapBossID = 1,
			[NORMAL_DIFF] = {
				{ 1,  21499 }, -- Vestments of the Shifting Sands
				{ 2,  21498 }, -- Qiraji Sacrificial Dagger
				{ 4,  21502 }, -- Sand Reaver Wristguards
				{ 5,  21501 }, -- Toughened Silithid Hide Gloves
				{ 6,  21500 }, -- Belt of the Inquisition
				{ 7,  21503 }, -- Belt of the Sand Reaver
				{ 19, 20885 }, -- Qiraji Martial Drape
				{ 20, 20889 }, -- Qiraji Regal Drape
				{ 21, 20888 }, -- Qiraji Ceremonial Ring
				{ 22, 20884 }, -- Qiraji Magisterial Ring
			},
		},
		{ -- AQ20Rajaxx
			name = AL["General Rajaxx"],
			npcID = 15341,
			Level = 999,
			DisplayIDs = {{15376}},
			AtlasMapBossID = 2,
			[NORMAL_DIFF] = {
				{ 1,  21493 }, -- Boots of the Vanguard
				{ 2,  21492 }, -- Manslayer of the Qiraji
				{ 4,  21496 }, -- Bracers of Qiraji Command
				{ 5,  21494 }, -- Southwind's Grasp
				{ 6,  21495 }, -- Legplates of the Qiraji Command
				{ 7,  21497 }, -- Boots of the Qiraji General
				{ 9,  "INV_Box_01", nil, AL["Trash"] },
				{ 10,  21810 }, -- Treads of the Wandering Nomad
				{ 11,  21809 }, -- Fury of the Forgotten Swarm
				{ 12,  21806 }, -- Gavel of Qiraji Authority
				{ 19, 20885 }, -- Qiraji Martial Drape
				{ 20, 20889 }, -- Qiraji Regal Drape
				{ 21, 20888 }, -- Qiraji Ceremonial Ring
				{ 22, 20884 }, -- Qiraji Magisterial Ring
			},
		},
		{ -- AQ20Moam
			name = AL["Moam"],
			npcID = 15340,
			Level = 999,
			DisplayIDs = {{15392}},
			AtlasMapBossID = 3,
			[NORMAL_DIFF] = {
				{ 1,  21472 }, -- Dustwind Turban
				{ 2,  21467 }, -- Thick Silithid Chestguard
				{ 3,  21479 }, -- Gauntlets of the Immovable
				{ 4,  21471 }, -- Talon of Furious Concentration
				{ 6,  21455 }, -- Southwind Helm
				{ 7,  21468 }, -- Mantle of Maz'Nadir
				{ 8,  21474 }, -- Chitinous Shoulderguards
				{ 9,  21470 }, -- Cloak of the Savior
				{ 10, 21469 }, -- Gauntlets of Southwind
				{ 11, 21476 }, -- Obsidian Scaled Leggings
				{ 12, 21475 }, -- Legplates of the Destroyer
				{ 13, 21477 }, -- Ring of Fury
				{ 14, 21473 }, -- Eye of Moam
				{ 16, 20890 }, -- Qiraji Ornate Hilt
				{ 17, 20886 }, -- Qiraji Spiked Hilt
				{ 21, 20888 }, -- Qiraji Ceremonial Ring
				{ 22, 20884 }, -- Qiraji Magisterial Ring
				{ 24, 22220 }, -- Plans: Black Grasp of the Destroyer
				--{ 24, 22194 }, -- Black Grasp of the Destroyer
			},
		},
		{ -- AQ20Buru
			name = AL["Buru the Gorger"],
			npcID = 15370,
			Level = 999,
			DisplayIDs = {{15654}},
			AtlasMapBossID = 4,
			[NORMAL_DIFF] = {
				{ 1,  21487, [ATLASLOOT_IT_ALLIANCE] = 21486 }, -- Slimy Scaled Gauntlets
				--{ 2,  21486 }, -- Gloves of the Swarm
				{ 2,  21485 }, -- Buru's Skull Fragment
				{ 5,  21491 }, -- Scaled Bracers of the Gorger
				{ 6,  21489 }, -- Quicksand Waders
				{ 7,  21490 }, -- Slime Kickers
				{ 8,  21488 }, -- Fetish of Chitinous Spikes
				{ 16, 20890 }, -- Qiraji Ornate Hilt
				{ 17, 20886 }, -- Qiraji Spiked Hilt
				{ 20, 20885 }, -- Qiraji Martial Drape
				{ 21, 20889 }, -- Qiraji Regal Drape
				{ 22, 20888 }, -- Qiraji Ceremonial Ring
				{ 23, 20884 }, -- Qiraji Magisterial Ring
			},
		},
		{ -- AQ20Ayamiss
			name = AL["Ayamiss the Hunter"],
			npcID = 15369,
			Level = 999,
			DisplayIDs = {{15431}},
			AtlasMapBossID = 5,
			[NORMAL_DIFF] = {
				{ 1,  21479 }, -- Gauntlets of the Immovable
				{ 2,  21478 }, -- Bow of Taut Sinew
				{ 3,  21466 }, -- Stinger of Ayamiss
				{ 5,  21484 }, -- Helm of Regrowth
				{ 6,  21480 }, -- Scaled Silithid Gauntlets
				{ 7,  21482 }, -- Boots of the Fiery Sands
				{ 8,  21481 }, -- Boots of the Desert Protector
				{ 9,  21483 }, -- Ring of the Desert Winds
				{ 16, 20890 }, -- Qiraji Ornate Hilt
				{ 17, 20886 }, -- Qiraji Spiked Hilt
				{ 20, 20885 }, -- Qiraji Martial Drape
				{ 21, 20889 }, -- Qiraji Regal Drape
				{ 22, 20888 }, -- Qiraji Ceremonial Ring
				{ 23, 20884 }, -- Qiraji Magisterial Ring
			},
		},
		{ -- AQ20Ossirian
			name = AL["Ossirian the Unscarred"],
			npcID = 15339,
			Level = 999,
			DisplayIDs = {{15432}},
			AtlasMapBossID = 6,
			[NORMAL_DIFF] = {
				{ 1,  21460 }, -- Helm of Domination
				{ 2,  21454, [ATLASLOOT_IT_ALLIANCE] = 21453 }, -- Runic Stone Shoulders
				--{ 3,  21453 }, -- Mantle of the Horusath
				{ 3,  21456 }, -- Sandstorm Cloak
				{ 4,  21464 }, -- Shackles of the Unscarred
				{ 5,  21457 }, -- Bracers of Brutality
				{ 6,  21462 }, -- Gloves of Dark Wisdom
				{ 7,  21458 }, -- Gauntlets of New Life
				{ 8,  21463 }, -- Ossirian's Binding
				{ 9, 21461 }, -- Leggings of the Black Blizzard
				{ 10, 21459 }, -- Crossbow of Imminent Doom
				{ 11, 21715 }, -- Sand Polished Hammer
				{ 12, 21452 }, -- Staff of the Ruins
				{ 16, 20890 }, -- Qiraji Ornate Hilt
				{ 17, 20886 }, -- Qiraji Spiked Hilt
				{ 20, 20888 }, -- Qiraji Ceremonial Ring
				{ 21, 20884 }, -- Qiraji Magisterial Ring
				{ 23, 21220 }, -- Head of Ossirian the Unscarred
			},
		},
		{ -- AQ20Trash
			name = AL["Trash"],
			ExtraList = true,
			[NORMAL_DIFF] = {
				{ 1,  21804, [ATLASLOOT_IT_ALLIANCE] = 21803 }, -- Coif of Elemental Fury
				--{ 2,  21803 }, -- Helm of the Holy Avenger
				{ 2,  21805 }, -- Polished Obsidian Pauldrons
				{ 5,  20873 }, -- Alabaster Idol
				{ 6,  20869 }, -- Amber Idol
				{ 7,  20866 }, -- Azure Idol
				{ 8,  20870 }, -- Jasper Idol
				{ 9,  20868 }, -- Lambent Idol
				{ 10, 20871 }, -- Obsidian Idol
				{ 11, 20867 }, -- Onyx Idol
				{ 12, 20872 }, -- Vermillion Idol
				{ 14, 21761 }, -- Scarab Coffer Key
				{ 15, 21156 }, -- Scarab Bag
				{ 16, 21801 }, -- Antenna of Invigoration
				{ 17, 21800 }, -- Silithid Husked Launcher
				{ 18, 21802 }, -- The Lost Kris of Zedd
				{ 20, 20864 }, -- Bone Scarab
				{ 21, 20861 }, -- Bronze Scarab
				{ 22, 20863 }, -- Clay Scarab
				{ 23, 20862 }, -- Crystal Scarab
				{ 24, 20859 }, -- Gold Scarab
				{ 25, 20865 }, -- Ivory Scarab
				{ 26, 20860 }, -- Silver Scarab
				{ 27, 20858 }, -- Stone Scarab
				{ 29, 22203 }, -- Large Obsidian Shard
				{ 30, 22202 }, -- Small Obsidian Shard
			},
		},
		{ -- AQ20ClassBooks
			name = AL["Class books"],
			ExtraList = true,
			[NORMAL_DIFF] = {
				{ 1,  21284 }, -- Codex of Greater Heal V
				{ 2,  21287 }, -- Codex of Prayer of Healing V
				{ 3,  21285 }, -- Codex of Renew X
				{ 4,  21279 }, -- Tome of Fireball XII
				{ 5,  21214 }, -- Tome of Frostbolt XI
				{ 6,  21280 }, -- Tome of Arcane Missiles VIII
				{ 7,  21281 }, -- Grimoire of Shadow Bolt X
				{ 8,  21283 }, -- Grimoire of Corruption VII
				{ 9,  21282 }, -- Grimoire of Immolate VIII
				{ 10, 21300 }, -- Handbook of Backstab IX
				{ 11, 21303 }, -- Handbook of Feint V
				{ 12, 21302 }, -- Handbook of Deadly Poison V
				{ 13, 21294 }, -- Book of Healing Touch XI
				{ 14, 21296 }, -- Book of Rejuvenation XI
				{ 15, 21295 }, -- Book of Starfire VII
				{ 16, 21306 }, -- Guide: Serpent Sting IX
				{ 17, 21304 }, -- Guide: Multi-Shot V
				{ 18, 21307 }, -- Guide: Aspect of the Hawk VII
				{ 19, 21291 }, -- Tablet of Healing Wave X
				{ 20, 21292 }, -- Tablet of Strength of Earth Totem V
				{ 21, 21293 }, -- Tablet of Grace of Air Totem III
				{ 22, 21288 }, -- Libram: Blessing of Wisdom VI
				{ 23, 21289 }, -- Libram: Blessing of Might VII
				{ 24, 21290 }, -- Libram: Holy Light IX
				{ 25, 21298 }, -- Manual of Battle Shout VII
				{ 26, 21299 }, -- Manual of Revenge VI
				{ 27, 21297 }, -- Manual of Heroic Strike IX
			},
		},
		AQ_SCARABS,
		AQ_ENCHANTS,
		AQ_OPENING,
	},
}
data["WrathOnyxiasLair"] = {
	EncounterJournalID = 760,
	MapID = 2159,
    name = AL["P8 Onyxia's Lair"],
    InstanceID = 249,
    AtlasModule = ATLAS_ERA_MODULE_NAME,
	AtlasMapID = "OnyxiasLair",
    AtlasMapFile = "CL_OnyxiasLair",
	ContentType = RAID_CONTENT,
    -- LevelRange = {80, 80, 80},
	items = {
		{	--Onyxia
			name = AL["Onyxia"],
            npcID = 15956,
			EncounterJournalID = 1651,
            AtlasMapBossID = 3,
            DisplayIDs = {{8570}},
			Level = 999,
			[RAID10_DIFF] = {
                { 1, "SLOT_HEAD", nil, AL["Class Item drops"], nil, "WrathOnyxiaClassItems10" },
				{ 2, 49307 },	-- Fluttering Sapphiron Drape
                { 3, 49304 },	-- Sharpened Fang of the Mystics
				{ 4, 49437 },	-- Rusted Gutgore Ripper
				{ 5, 49298 },	-- Glinting Azuresong Mageblade
				{ 6, 49303 },	-- Gleaming Quel'Serrar
				{ 7, 49296 },	-- Singed Vis'kag the Bloodletter
				{ 8, 49299 },	-- Keen Obsidian Edged Blade
				{ 9, 49297 },	-- Empowered Deathbringer
				{ 10, 49302 },	-- Reclaimed Shadowstrike
				{ 11, 49301 },	-- Reclaimed Thunderstrike
				{ 12, 49305 },	-- Snub-Nose Blastershot Launcher
				{ 13, 49308 },	-- Antique Cornerstone Grimoire
                { 14, 49306 },	-- Eskhandar's Choker
				{ 15, 49309 },	-- Runed Ring of Binding
                { 16, 49636 },	-- Reins of the Onyxian Drake
				{ 18, 49463 },	-- Purified Shard of the Flame
				{ 19, 49310 },	-- Purified Shard of the Scale
                { 21, 49644 },	-- Head of Onyxia
				{ 22, 49295 },	-- Enlarged Onyxia Hide Backpack
				{ 23, 49294 },	-- Ashen Sack of Gems
				{ 27, "ac4396" },
				{ 28, "ac4403" },
				{ 29, "ac4402" },
				{ 30, "ac4404" },
			},
            [RAID25_DIFF] = {
                { 1, "SLOT_HEAD", nil, AL["Class Item drops"], nil, "WrathOnyxiaClassItems25" },
				{ 2, 49491 },	-- Fluttering Sapphiron Drape
				{ 3, 49494 },	-- Honed Fang of the Mystics
				{ 4, 49465 },	-- Tarnished Gutgore Ripper
				{ 5, 49499 },	-- Polished Azuresong Mageblade
				{ 6, 49495 },	-- Burnished Quel'Serrar
				{ 7, 49501 },	-- Tempered Vis'kag the Bloodletter
				{ 8, 49498 },	-- Sharpened Obsidian Edged Blade
				{ 9, 49500 },	-- Raging Deathbringer
				{ 10, 49496 },	-- Reinforced Shadowstrike
				{ 11, 49497 },	-- Reinforced Thunderstrike
				{ 12, 49493 },	-- Rifled Blastershot Launcher
				{ 13, 49490 },	-- Antediluvian Cornerstone Grimoire
                { 14, 49492 },	-- Eskhandar's Links
				{ 15, 49489 },	-- Signified Ring of Binding
                { 16, 49636 },	-- Reins of the Onyxian Drake
				{ 18, 49464 },	-- Purified Shard of the Flame
				{ 19, 49488 },	-- Purified Shard of the Scale
                { 21, 49644 },	-- Head of Onyxia
				{ 22, 49295 },	-- Enlarged Onyxia Hide Backpack
				{ 23, 49294 },	-- Ashen Sack of Gems
				{ 27, "ac4397" },
				{ 28, "ac4406" },
				{ 29, "ac4405" },
				{ 30, "ac4407" },
			},
		},
        T9_SET,
	}
}
data["TheTempleofAhnQiraj80"] = { -- AQ40
	MapID = 3428,
	InstanceID = 531,
    name = AL["P9 The Temple of Ahn'Qiraj"],
	AtlasModule = ATLAS_ERA_MODULE_NAME,
	AtlasMapID = "TheTempleofAhnQiraj",
	AtlasMapFile = "CL_TheTempleofAhnQiraj",
	AtlasMapFile_AL = "TheTempleofAhnQiraj",
	ContentType = RAID_CONTENT,
	items = {
		{ -- AQ40Skeram
			name = AL["The Prophet Skeram"],
			npcID = 15263,
			Level = 999,
			DisplayIDs = {{15345}},
			AtlasMapBossID = 1,
			[NORMAL_DIFF] = {
				{ 1,  21699 }, -- Barrage Shoulders
				{ 2,  21814 }, -- Breastplate of Annihilation
				{ 3,  21708 }, -- Beetle Scaled Wristguards
				{ 4,  21698 }, -- Leggings of Immersion
				{ 5,  21705 }, -- Boots of the Fallen Prophet
				{ 6,  21704 }, -- Boots of the Redeemed Prophecy
				{ 7,  21706 }, -- Boots of the Unwavering Will
				{ 9,  21702 }, -- Amulet of Foul Warding
				{ 10, 21700 }, -- Pendant of the Qiraji Guardian
				{ 11, 21701 }, -- Cloak of Concentrated Hatred
				{ 12, 21707 }, -- Ring of Swarming Thought
				{ 13, 21703 }, -- Hammer of Ji'zhi
				{ 14, 21128 }, -- Staff of the Qiraji Prophets
				{ 16, 21237 }, -- Imperial Qiraji Regalia
				{ 17, 21232 }, -- Imperial Qiraji Armaments
				{ 19, 22222 }, -- Plans: Thick Obsidian Breastplate
				--{ 20, 22196 }, -- Thick Obsidian Breastplate
			},
		},
		{ -- AQ40Trio
			name = AL["Bug Trio"],
			npcID = {15543, 15544, 15511},
			Level = 999,
			DisplayIDs = {{15657},{15658},{15656}},
			AtlasMapBossID = 2,
			[NORMAL_DIFF] = {
				{ 1,  21693 }, -- Guise of the Devourer
				{ 2,  21694 }, -- Ternary Mantle
				{ 3,  21697 }, -- Cape of the Trinity
				{ 4,  21696 }, -- Robes of the Triumvirate
				{ 5,  21692 }, -- Triad Girdle
				{ 6,  21695 }, -- Angelista's Touch
				{ 8,  21237 }, -- Imperial Qiraji Regalia
				{ 9,  21232 }, -- Imperial Qiraji Armaments
				{ 11, "INV_BOX_02", nil, format(AL["%s killed last"], AL["Lord Kri"]) },
				{ 12, 21680 }, -- Vest of Swift Execution
				{ 13, 21681 }, -- Ring of the Devoured
				{ 14, 21685 }, -- Petrified Scarab
				{ 15, 21603 }, -- Wand of Qiraji Nobility
				{ 16, "INV_BOX_02", nil, format(AL["%s killed last"], AL["Vem"]) },
				{ 17, 21690 }, -- Angelista's Charm
				{ 18, 21689 }, -- Gloves of Ebru
				{ 19, 21691 }, -- Ooze-ridden Gauntlets
				{ 20, 21688 }, -- Boots of the Fallen Hero
				{ 22, "INV_BOX_02", nil, format(AL["%s killed last"], AL["Princess Yauj"]) },
				{ 23, 21686 }, -- Mantle of Phrenic Power
				{ 24, 21684 }, -- Mantle of the Desert's Fury
				{ 25, 21683 }, -- Mantle of the Desert Crusade
				{ 26, 21682 }, -- Bile-Covered Gauntlets
				{ 27, 21687 }, -- Ukko's Ring of Darkness
			},
		},
		{ -- AQ40Sartura
			name = AL["Battleguard Sartura"],
			npcID = 15516,
			Level = 999,
			DisplayIDs = {{15583}},
			AtlasMapBossID = 3,
			[NORMAL_DIFF] = {
				{ 1,  21669 }, -- Creeping Vine Helm
				{ 2,  21678 }, -- Necklace of Purity
				{ 3,  21671 }, -- Robes of the Battleguard
				{ 4,  21672 }, -- Gloves of Enforcement
				{ 5,  21674 }, -- Gauntlets of Steadfast Determination
				{ 6,  21675 }, -- Thick Qirajihide Belt
				{ 7,  21676 }, -- Leggings of the Festering Swarm
				{ 8,  21668 }, -- Scaled Leggings of Qiraji Fury
				{ 9,  21667 }, -- Legplates of Blazing Light
				{ 10, 21648 }, -- Recomposed Boots
				{ 11, 21670 }, -- Badge of the Swarmguard
				{ 12, 21666 }, -- Sartura's Might
				{ 13, 21673 }, -- Silithid Claw
				{ 16, 21237 }, -- Imperial Qiraji Regalia
				{ 17, 21232 }, -- Imperial Qiraji Armaments
			},
		},
		{ -- AQ40Fankriss
			name = AL["Fankriss the Unyielding"],
			npcID = 15510,
			Level = 999,
			DisplayIDs = {{15743}},
			AtlasMapBossID = 4,
			[NORMAL_DIFF] = {
				{ 1,  21665 }, -- Mantle of Wicked Revenge
				{ 2,  21639 }, -- Pauldrons of the Unrelenting
				{ 3,  21627 }, -- Cloak of Untold Secrets
				{ 4,  21663 }, -- Robes of the Guardian Saint
				{ 5,  21652 }, -- Silithid Carapace Chestguard
				{ 6,  21651 }, -- Scaled Sand Reaver Leggings
				{ 7,  21645 }, -- Hive Tunneler's Boots
				{ 8,  21650 }, -- Ancient Qiraji Ripper
				{ 9,  21635 }, -- Barb of the Sand Reaver
				{ 11, 21664 }, -- Barbed Choker
				{ 12, 21647 }, -- Fetish of the Sand Reaver
				{ 13, 22402 }, -- Libram of Grace
				{ 14, 22396 }, -- Totem of Life
				{ 16, 21237 }, -- Imperial Qiraji Regalia
				{ 17, 21232 }, -- Imperial Qiraji Armaments
			},
		},
		{ -- AQ40Viscidus
			name = AL["Viscidus"],
			npcID = 15299,
			Level = 999,
			DisplayIDs = {{15686}},
			AtlasMapBossID = 5,
			[NORMAL_DIFF] = {
				{ 1,  21624 }, -- Gauntlets of Kalimdor
				{ 2,  21623 }, -- Gauntlets of the Righteous Champion
				{ 3,  21626 }, -- Slime-coated Leggings
				{ 4,  21622 }, -- Sharpened Silithid Femur
				{ 6,  21677 }, -- Ring of the Qiraji Fury
				{ 7,  21625 }, -- Scarab Brooch
				{ 8,  22399 }, -- Idol of Health
				{ 16, 21237 }, -- Imperial Qiraji Regalia
				{ 17, 21232 }, -- Imperial Qiraji Armaments
				{ 19, 20928 }, -- Qiraji Bindings of Command
				{ 20, 20932 }, -- Qiraji Bindings of Dominance
			},
		},
		{ -- AQ40Huhuran
			name = AL["Princess Huhuran"],
			npcID = 15509,
			Level = 999,
			DisplayIDs = {{15739}},
			AtlasMapBossID = 6,
			[NORMAL_DIFF] = {
				{ 1,  21621 }, -- Cloak of the Golden Hive
				{ 2,  21618 }, -- Hive Defiler Wristguards
				{ 3,  21619 }, -- Gloves of the Messiah
				{ 4,  21617 }, -- Wasphide Gauntlets
				{ 5,  21620 }, -- Ring of the Martyr
				{ 6,  21616 }, -- Huhuran's Stinger
				{ 16, 21237 }, -- Imperial Qiraji Regalia
				{ 17, 21232 }, -- Imperial Qiraji Armaments
				{ 19, 20928 }, -- Qiraji Bindings of Command
				{ 20, 20932 }, -- Qiraji Bindings of Dominance
			},
		},
		{ -- AQ40Emperors
			name = AL["Twin Emperors"],
			npcID = {15275, 15276},
			Level = 999,
			DisplayIDs = {{15761},{15778}},
			AtlasMapBossID = 7,
			[NORMAL_DIFF] = {
				{ 1, "INV_Box_01", nil, AL["Emperor Vek'lor"], nil },
				{ 2,  20930 }, -- Vek'lor's Diadem
				{ 3,  21602 }, -- Qiraji Execution Bracers
				{ 4,  21599 }, -- Vek'lor's Gloves of Devastation
				{ 5,  21598 }, -- Royal Qiraji Belt
				{ 6,  21600 }, -- Boots of Epiphany
				{ 7,  21601 }, -- Ring of Emperor Vek'lor
				{ 8,  21597 }, -- Royal Scepter of Vek'lor
				{ 9,  20735 }, -- Formula: Enchant Cloak - Subtlety
				{ 12, 21232 }, -- Imperial Qiraji Armaments
				{ 16, "INV_Box_01", nil, AL["Emperor Vek'nilash"], nil },
				{ 17, 20926 }, -- Vek'nilash's Circlet
				{ 18, 21608 }, -- Amulet of Vek'nilash
				{ 19, 21604 }, -- Bracelets of Royal Redemption
				{ 20, 21605 }, -- Gloves of the Hidden Temple
				{ 21, 21609 }, -- Regenerating Belt of Vek'nilash
				{ 22, 21607 }, -- Grasp of the Fallen Emperor
				{ 23, 21606 }, -- Belt of the Fallen Emperor
				{ 24, 21679 }, -- Kalimdor's Revenge
				{ 25, 20726 }, -- Formula: Enchant Gloves - Threat
				{ 27, 21237 }, -- Imperial Qiraji Regalia
			},
		},
		{ -- AQ40Ouro
			name = AL["Ouro"],
			npcID = 15517,
			Level = 999,
			DisplayIDs = {{15509}},
			AtlasMapBossID = 8,
			[NORMAL_DIFF] = {
				{ 1,  21615 }, -- Don Rigoberto's Lost Hat
				{ 2,  21611 }, -- Burrower Bracers
				{ 3,  23558 }, -- The Burrower's Shell
				{ 4,  23570 }, -- Jom Gabbar
				{ 5,  21610 }, -- Wormscale Blocker
				{ 6,  23557 }, -- Larvae of the Great Worm
				{ 16, 21237 }, -- Imperial Qiraji Regalia
				{ 17, 21232 }, -- Imperial Qiraji Armaments
				{ 19,  20927 }, -- Ouro's Intact Hide
				{ 20,  20931 }, -- Skin of the Great Sandworm
			},
		},
		{ -- AQ40CThun
			name = AL["C'Thun"],
			npcID = 15727,
			Level = 999,
			DisplayIDs = {{15787}},
			AtlasMapBossID = 9,
			[NORMAL_DIFF] = {
				{ 1,  22732 }, -- Mark of C'Thun
				{ 2,  21583 }, -- Cloak of Clarity
				{ 3,  22731 }, -- Cloak of the Devoured
				{ 4,  22730 }, -- Eyestalk Waist Cord
				{ 5,  21582 }, -- Grasp of the Old God
				{ 6,  21586 }, -- Belt of Never-ending Agony
				{ 7,  21585 }, -- Dark Storm Gauntlets
				{ 8,  21581 }, -- Gauntlets of Annihilation
				{ 9,  21596 }, -- Ring of the Godslayer
				{ 10, 21579 }, -- Vanquished Tentacle of C'Thun
				{ 11, 21839 }, -- Scepter of the False Prophet
				{ 12, 21126 }, -- Death's Sting
				{ 13, 21134 }, -- Dark Edge of Insanity
				{ 16, 20929 }, -- Carapace of the Old God
				{ 17, 20933 }, -- Husk of the Old God
				{ 19, 21221 }, -- Eye of C'Thun
				{ 21, 22734 }, -- Base of Atiesh
			},
		},
		{ -- AQ40Trash1
			name = AL["Trash"],
			ExtraList = true,
			[NORMAL_DIFF] = {
				{ 1,  21838 }, -- Garb of Royal Ascension
				{ 2,  21888 }, -- Gloves of the Immortal
				{ 3,  21889 }, -- Gloves of the Redeemed Prophecy
				{ 4,  21856 }, -- Neretzek, The Blood Drinker
				{ 5,  21837 }, -- Anubisath Warhammer
				{ 6,  21836 }, -- Ritssyn's Ring of Chaos
				{ 7,  21891 }, -- Shard of the Fallen Star
				{ 16, 21218 }, -- Blue Qiraji Resonating Crystal
				{ 17, 21324 }, -- Yellow Qiraji Resonating Crystal
				{ 18, 21323 }, -- Green Qiraji Resonating Crystal
				{ 19, 21321 }, -- Red Qiraji Resonating Crystal
			},
		},
		AQ_SCARABS,
		AQ_ENCHANTS,
		AQ_OPENING,
	},
}
data["WorldBosses4ll"] = {
	AtlasMapFile = "Azuregos",
    name = AL["P9 World bosses of Four Dragons"],
	ContentType = RAID_CONTENT,
	items = {
		
		{ -- DLethon
			name = AL["Lethon"],
			AtlasMapFile = "FourDragons",
			npcID = 14888,
			Level = 999,
			ContentPhase = 4,
			DisplayIDs = {{15365}},
			[NORMAL_DIFF] = {
				{ 1,  20628 }, -- Deviate Growth Cap
				{ 2,  20626 }, -- Black Bark Wristbands
				{ 3,  20630 }, -- Gauntlets of the Shining Light
				{ 4,  20625 }, -- Belt of the Dark Bog
				{ 5,  20627 }, -- Dark Heart Pants
				{ 6,  20629 }, -- Malignant Footguards
				{ 9,  20579 }, -- Green Dragonskin Cloak
				{ 10, 20615 }, -- Dragonspur Wraps
				{ 11, 20616 }, -- Dragonbone Wristguards
				{ 12, 20618 }, -- Gloves of Delusional Power
				{ 13, 20617 }, -- Ancient Corroded Leggings
				{ 14, 20619 }, -- Acid Inscribed Greaves
				{ 15, 20582 }, -- Trance Stone
				{ 16, 20644 }, -- Nightmare Engulfed Object
				{ 17, 20600 }, -- Malfurion's Signet Ring
				{ 24, 20580 }, -- Hammer of Bestial Fury
				{ 25, 20581 }, -- Staff of Rampant Growth
				{ 29, 20381 }, -- Dreamscale
				{ 30, 11938 }, -- Sack of Gems
				-- Hidden items
				{ 0, 17962 }, -- Blue Sack of Gems
				{ 0, 17963 }, -- Green Sack of Gems
				{ 0, 17964 }, -- Gray Sack of Gems
				{ 0, 17965 }, -- Yellow Sack of Gems
				{ 0, 17969 }, -- Red Sack of Gems
			},
		},
		{ -- DEmeriss
			name = AL["Emeriss"],
			AtlasMapFile = "FourDragons",
			npcID = 14889,
			Level = 999,
			ContentPhase = 4,
			DisplayIDs = {{15366}},
			[NORMAL_DIFF] = {
				{ 1,  20623 }, -- Circlet of Restless Dreams
				{ 2,  20622 }, -- Dragonheart Necklace
				{ 3,  20624 }, -- Ring of the Unliving
				{ 4,  20621 }, -- Boots of the Endless Moor
				{ 5,  20599 }, -- Polished Ironwood Crossbow
				{ 9,  20579 }, -- Green Dragonskin Cloak
				{ 10, 20615 }, -- Dragonspur Wraps
				{ 11, 20616 }, -- Dragonbone Wristguards
				{ 12, 20618 }, -- Gloves of Delusional Power
				{ 13, 20617 }, -- Ancient Corroded Leggings
				{ 14, 20619 }, -- Acid Inscribed Greaves
				{ 15, 20582 }, -- Trance Stone
				{ 16, 20644 }, -- Nightmare Engulfed Object
				{ 17, 20600 }, -- Malfurion's Signet Ring
				{ 24, 20580 }, -- Hammer of Bestial Fury
				{ 25, 20581 }, -- Staff of Rampant Growth
				{ 30, 11938 }, -- Sack of Gems
				-- Hidden items
				{ 0, 17962 }, -- Blue Sack of Gems
				{ 0, 17963 }, -- Green Sack of Gems
				{ 0, 17964 }, -- Gray Sack of Gems
				{ 0, 17965 }, -- Yellow Sack of Gems
				{ 0, 17969 }, -- Red Sack of Gems
			},
		},
		{ -- DTaerar
			name = AL["Taerar"],
			AtlasMapFile = "FourDragons",
			npcID = 14890,
			Level = 999,
			ContentPhase = 4,
			DisplayIDs = {{15363}, {15367}},
			[NORMAL_DIFF] = {
				{ 1,  20633 }, -- Unnatural Leather Spaulders
				{ 2,  20631 }, -- Mendicant's Slippers
				{ 3,  20634 }, -- Boots of Fright
				{ 4,  20632 }, -- Mindtear Band
				{ 5,  20577 }, -- Nightmare Blade
				{ 9,  20579 }, -- Green Dragonskin Cloak
				{ 10, 20615 }, -- Dragonspur Wraps
				{ 11, 20616 }, -- Dragonbone Wristguards
				{ 12, 20618 }, -- Gloves of Delusional Power
				{ 13, 20617 }, -- Ancient Corroded Leggings
				{ 14, 20619 }, -- Acid Inscribed Greaves
				{ 15, 20582 }, -- Trance Stone
				{ 16, 20644 }, -- Nightmare Engulfed Object
				{ 17, 20600 }, -- Malfurion's Signet Ring
				{ 24, 20580 }, -- Hammer of Bestial Fury
				{ 25, 20581 }, -- Staff of Rampant Growth
				{ 30, 11938 }, -- Sack of Gems
				-- Hidden items
				{ 0, 17962 }, -- Blue Sack of Gems
				{ 0, 17963 }, -- Green Sack of Gems
				{ 0, 17964 }, -- Gray Sack of Gems
				{ 0, 17965 }, -- Yellow Sack of Gems
				{ 0, 17969 }, -- Red Sack of Gems
			},
		},
		{ -- DYsondre
			name = AL["Ysondre"],
			AtlasMapFile = "FourDragons",
			npcID = 14887,
			Level = 999,
			ContentPhase = 4,
			DisplayIDs = {{15364}},
			[NORMAL_DIFF] = {
				{ 1,  20637 }, -- Acid Inscribed Pauldrons
				{ 2,  20635 }, -- Jade Inlaid Vestments
				{ 3,  20638 }, -- Leggings of the Demented Mind
				{ 4,  20639 }, -- Strangely Glyphed Legplates
				{ 5,  20636 }, -- Hibernation Crystal
				{ 6,  20578 }, -- Emerald Dragonfang
				{ 9,  20579 }, -- Green Dragonskin Cloak
				{ 10, 20615 }, -- Dragonspur Wraps
				{ 11, 20616 }, -- Dragonbone Wristguards
				{ 12, 20618 }, -- Gloves of Delusional Power
				{ 13, 20617 }, -- Ancient Corroded Leggings
				{ 14, 20619 }, -- Acid Inscribed Greaves
				{ 15, 20582 }, -- Trance Stone
				{ 16, 20644 }, -- Nightmare Engulfed Object
				{ 17, 20600 }, -- Malfurion's Signet Ring
				{ 24, 20580 }, -- Hammer of Bestial Fury
				{ 25, 20581 }, -- Staff of Rampant Growth
				{ 30, 11938 }, -- Sack of Gems
				-- Hidden items
				{ 0, 17962 }, -- Blue Sack of Gems
				{ 0, 17963 }, -- Green Sack of Gems
				{ 0, 17964 }, -- Gray Sack of Gems
				{ 0, 17965 }, -- Yellow Sack of Gems
				{ 0, 17969 }, -- Red Sack of Gems
			},
		},
	}
}
-- Icecrown Citadel / T10
data["IcecrownCitadel"] = {
	EncounterJournalID = 758,
	MapID = 4812,
    name = AL["P10 Icecrown Citadel"],
	InstanceID = 631,
    AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "IcecrownCitadelA",
    AtlasMapFile = {"IcecrownCitadelA", "IcecrownEnt"},
	ContentType = RAID_CONTENT,
    -- LevelRange = {80, 80, 80},
	items = {
		{	--ICC LordMarrowgar
			name = AL["Lord Marrowgar"],
			EncounterJournalID = 1624,
            AtlasMapBossID = 1,
			[RAID10_DIFF] = {
				{ 1, 50764 },	-- Shawl of Nerubian Silk
				{ 2, 50773 },	-- Cord of the Patronizing Practitioner
				{ 3, 50774 },	-- Coldwraith Bracers
				{ 4, 50762 },	-- Linked Scourge Vertebrae
				{ 5, 50775 },	-- Corrupted Silverplate Leggings
				{ 6, 50772 },	-- Ancient Skeletal Boots
				{ 8, 50763 },	-- Marrowgar's Scratching Choker
				{ 9, 50339 },	-- Sliver of Pure Ice
				{ 16, 50771 },	-- Frost Needle
				{ 17, 50761 },	-- Citadel Enforcer's Claymore
				{ 18, 50759 },	-- Bone Warden's Splitter
				{ 19, 50760 },	-- Bonebreaker Scepter
				{ 21, "ac4534" },
			},
			[RAID10H_DIFF] = {
				{ 1, 51933 },	-- Shawl of Nerubian Silk
				{ 2, 51930 },	-- Cord of the Patronizing Practitioner
				{ 3, 51929 },	-- Coldwraith Bracers
				{ 4, 51935 },	-- Linked Scourge Vertebrae
				{ 5, 51928 },	-- Corrupted Silverplate Leggings
				{ 6, 51931 },	-- Ancient Skeletal Boots
				{ 8, 51934 },	-- Marrowgar's Scratching Choker
				{ 9, 50346 },	-- Sliver of Pure Ice
				{ 16, 51932 },	-- Frost Needle
				{ 17, 51936 },	-- Citadel Enforcer's Claymore
				{ 18, 51938 },	-- Bone Warden's Splitter
				{ 19, 51937 },	-- Bonebreaker Scepter
				{ 21, 49908 },	-- Primordial Saronite
				{ 23, "ac4534" },
			},
			[RAID25_DIFF] = {
				{ 1, 49978 },	-- Crushing Coldwraith Belt
				{ 2, 49979 },	-- Handguards of Winter's Respite
				{ 3, 49950 },	-- Frostbitten Fur Boots
				{ 4, 49952 },	-- Snowserpent Mail Helm
				{ 5, 49980 },	-- Rusted Bonespike Pauldrons
				{ 6, 49951 },	-- Gendarme's Cuirass
				{ 7, 49960 },	-- Bracers of Dark Reckoning
				{ 8, 49964 },	-- Legguards of Lost Hope
				{ 10, 49975 },	-- Bone Sentinel's Amulet
				{ 11, 49949 },	-- Band of the Bone Colossus
				{ 12, 49977 },	-- Loop of the Endless Labyrinth
				{ 13, 49967 },	-- Marrowgar's Frigid Eye
				{ 16, 49968 },	-- Frozen Bonespike
				{ 17, 50415 },	-- Bryntroll, the Bone Arbiter
				{ 18, 49976 },	-- Bulwark of Smouldering Steel
				{ 20, 50274 },	-- Shadowfrost Shard
				{ 21, 49908 },	-- Primordial Saronite
				{ 23, "ac4610" },
			},
			[RAID25H_DIFF] = {
				{ 1, 50613 },	-- Crushing Coldwraith Belt
				{ 2, 50615 },	-- Handguards of Winter's Respite
				{ 3, 50607 },	-- Frostbitten Fur Boots
				{ 4, 50605 },	-- Snowserpent Mail Helm
				{ 5, 50617 },	-- Rusted Bonespike Pauldrons
				{ 6, 50606 },	-- Gendarme's Cuirass
				{ 7, 50611 },	-- Bracers of Dark Reckoning
				{ 8, 50612 },	-- Legguards of Lost Hope
				{ 10, 50609 },	-- Bone Sentinel's Amulet
				{ 11, 50604 },	-- Band of the Bone Colossus
				{ 12, 50614 },	-- Loop of the Endless Labyrinth
				{ 13, 50610 },	-- Marrowgar's Frigid Eye
				{ 16, 50608 },	-- Frozen Bonespike
				{ 17, 50709 },	-- Bryntroll, the Bone Arbiter
				{ 18, 50616 },	-- Bulwark of Smouldering Steel
				{ 20, 50274 },	-- Shadowfrost Shard
				{ 21, 49908 },	-- Primordial Saronite
				{ 23, "ac4610" },
			},
		},
		{	--ICC LadyDeathwhisper
			name = AL["Lady Deathwhisper"],
			EncounterJournalID = 1625,
            AtlasMapBossID = 2,
			[RAID10_DIFF] = {
				{ 1, 50785 },	-- Bracers of Dark Blessings
				{ 2, 50782 },	-- Sister's Handshrouds
				{ 3, 50780 },	-- Chestguard of the Frigid Noose
				{ 4, 50778 },	-- Soulthief's Braided Belt
				{ 5, 50783 },	-- Boots of the Frozen Seed
				{ 6, 50777 },	-- Handgrips of Frost and Sleet
				{ 7, 50784 },	-- Deathspeaker Disciple's Belt
				{ 8, 50779 },	-- Deathspeaker Zealot's Helm
				{ 9, 50786 },	-- Ghoul Commander's Cuirass
				{ 16, 50342 },	-- Whispering Fanged Skull
				{ 18, 50776 },	-- Njorndar Bone Bow
				{ 19, 50781 },	-- Scourgelord's Baton
				{ 21, "ac4535" },
			},
			[RAID10H_DIFF] = {
				{ 1, 51918 },	-- Bracers of Dark Blessings
				{ 2, 51921 },	-- Sister's Handshrouds
				{ 3, 51923 },	-- Chestguard of the Frigid Noose
				{ 4, 51925 },	-- Soulthief's Braided Belt
				{ 5, 51920 },	-- Boots of the Frozen Seed
				{ 6, 51926 },	-- Handgrips of Frost and Sleet
				{ 7, 51919 },	-- Deathspeaker Disciple's Belt
				{ 8, 51924 },	-- Deathspeaker Zealot's Helm
				{ 9, 51917 },	-- Ghoul Commander's Cuirass
				{ 16, 50343 },	-- Whispering Fanged Skull
				{ 18, 51927 },	-- Njorndar Bone Bow
				{ 19, 51922 },	-- Scourgelord's Baton
				{ 21, 49908 },	-- Primordial Saronite
				{ 23, "ac4535" },
			},
			[RAID25_DIFF] = {
				{ 1, 49991 },	-- Shoulders of Mercy Killing
				{ 2, 49994 },	-- The Lady's Brittle Bracers
				{ 3, 49987 },	-- Cultist's Bloodsoaked Spaulders
				{ 4, 49996 },	-- Deathwhisper Chestpiece
				{ 5, 49988 },	-- Leggings of Northern Lights
				{ 6, 49993 },	-- Necrophotic Greaves
				{ 7, 49986 },	-- Broken Ram Skull Helm
				{ 8, 49995 },	-- Fallen Lord's Handguards
				{ 9, 49983 },	-- Blood-Soaked Saronite Stompers
				{ 11, 49989 },	-- Ahn'kahar Onyx Neckguard
				{ 12, 49985 },	-- Juggernaut Band
				{ 13, 49990 },	-- Ring of Maddening Whispers
				{ 16, 49982 },	-- Heartpierce
				{ 17, 49992 },	-- Nibelung
				{ 18, 50034 },	-- Zod's Repeating Longbow
				{ 20, 50274 },	-- Shadowfrost Shard
				{ 21, 49908 },	-- Primordial Saronite
				{ 23, "ac4611" },
			},
			[RAID25H_DIFF] = {
				{ 1, 50643 },	-- Shoulders of Mercy Killing
				{ 2, 50651 },	-- The Lady's Brittle Bracers
				{ 3, 50646 },	-- Cultist's Bloodsoaked Spaulders
				{ 4, 50649 },	-- Deathwhisper Raiment
				{ 5, 50645 },	-- Leggings of Northern Lights
				{ 6, 50652 },	-- Necrophotic Greaves
				{ 7, 50640 },	-- Broken Ram Skull Helm
				{ 8, 50650 },	-- Fallen Lord's Handguards
				{ 9, 50639 },	-- Blood-Soaked Saronite Stompers
				{ 11, 50647 },	-- Ahn'kahar Onyx Neckguard
				{ 12, 50642 },	-- Juggernaut Band
				{ 13, 50644 },	-- Ring of Maddening Whispers
				{ 16, 50641 },	-- Heartpierce
				{ 17, 50648 },	-- Nibelung
				{ 18, 50638 },	-- Zod's Repeating Longbow
				{ 20, 50274 },	-- Shadowfrost Shard
				{ 21, 49908 },	-- Primordial Saronite
				{ 23, "ac4611" },
			},
		},
		{	--ICC GunshipBattle
			name = AL["Icecrown Gunship Battle"],
			EncounterJournalID = 1626,
            AtlasMapBossID = 3,
			[RAID10_DIFF] = {
				{ 1, 50791 },	-- Saronite Gargoyle Cloak
				{ 2, 50795 },	-- Cord of Dark Suffering
				{ 3, 50797 },	-- Ice-Reinforced Vrykul Helm
				{ 4, 50792 },	-- Pauldrons of Lost Hope
				{ 5, 50789 },	-- Icecrown Rampart Bracers
				{ 6, 50796 },	-- Bracers of Pale Illumination
				{ 7, 50788 },	-- Bone Drake's Enameled Boots
				{ 9, 50790 },	-- Abomination's Bloody Ring
				{ 10, 50340 },	-- Muradin's Spyglass
				{ 16, 50793 },	-- Midnight Sun
				{ 17, 50787 },	-- Frost Giant's Cleaver
				{ 18, 50794 },	-- Neverending Winter
				{ 20, "ac4536" },
			},
			[RAID10H_DIFF] = {
				{ 1, 51912 },	-- Saronite Gargoyle Cloak
				{ 2, 51908 },	-- Cord of Dark Suffering
				{ 3, 51906 },	-- Ice-Reinforced Vrykul Helm
				{ 4, 51911 },	-- Pauldrons of Lost Hope
				{ 5, 51914 },	-- Icecrown Rampart Bracers
				{ 6, 51907 },	-- Bracers of Pale Illumination
				{ 7, 51915 },	-- Bone Drake's Enameled Boots
				{ 9, 51913 },	-- Abomination's Bloody Ring
				{ 10, 50345 },	-- Muradin's Spyglass
				{ 16, 51910 },	-- Midnight Sun
				{ 17, 51916 },	-- Frost Giant's Cleaver
				{ 18, 51909 },	-- Neverending Winter
				{ 20, 49908 },	-- Primordial Saronite
				{ 22, "ac4536" },
			},
			[RAID25_DIFF] = {
				{ 1, 49998 },	-- Shadowvault Slayer's Cloak
				{ 2, 50006 },	-- Corp'rethar Ceremonial Crown
				{ 3, 50011 },	-- Gunship Captain's Mittens
				{ 4, 50001 },	-- Ikfirus' Sack of Wonder
				{ 5, 50009 },	-- Boots of Unnatural Growth
				{ 6, 50000 },	-- Scourge Hunter's Vambraces
				{ 7, 50003 },	-- Boneguard Commander's Pauldrons
				{ 8, 50002 },	-- Polar Bear Claw Bracers
				{ 9, 50010 },	-- Waistband of Righteous Fury
				{ 11, 50274 },	-- Shadowfrost Shard
				{ 12, 49908 },	-- Primordial Saronite
				{ 16, 50005 },	-- Amulet of the Silent Eulogy
				{ 17, 50008 },	-- Ring of Rapid Ascent
				{ 18, 49999 },	-- Skeleton Lord's Circle
				{ 19, 50359 },	-- Althor's Abacus
				{ 20, 50352 },	-- Corpse Tongue Coin
				{ 22, 50411 },	-- Scourgeborne Waraxe
				{ 24, "ac4612" },
			},
			[RAID25H_DIFF] = {
				{ 1, 50653 },	-- Shadowvault Slayer's Cloak
				{ 2, 50661 },	-- Corp'rethar Ceremonial Crown
				{ 3, 50663 },	-- Gunship Captain's Mittens
				{ 4, 50656 },	-- Ikfirus' Sack of Wonder
				{ 5, 50665 },	-- Boots of Unnatural Growth
				{ 6, 50655 },	-- Scourge Hunter's Vambraces
				{ 7, 50660 },	-- Boneguard Commander's Pauldrons
				{ 8, 50659 },	-- Polar Bear Claw Bracers
				{ 9, 50667 },	-- Waistband of Righteous Fury
				{ 11, 50274 },	-- Shadowfrost Shard
				{ 12, 49908 },	-- Primordial Saronite
				{ 16, 50658 },	-- Amulet of the Silent Eulogy
				{ 17, 50664 },	-- Ring of Rapid Ascent
				{ 18, 50657 },	-- Skeleton Lord's Circle
				{ 19, 50366 },	-- Althor's Abacus
				{ 20, 50349 },	-- Corpse Tongue Coin
				{ 22, 50654 },	-- Scourgeborne Waraxe
				{ 24, "ac4612" },
			},
		},
		{	--ICC Saurfang
			name = AL["Deathbringer Saurfang"],
			EncounterJournalID = 1628,
            AtlasMapBossID = 5,
			[RAID10_DIFF] = {
				{ 1, 50807 },	-- Thaumaturge's Crackling Cowl
				{ 2, 50804 },	-- Icecrown Spire Sandals
				{ 3, 50799 },	-- Scourge Stranglers
				{ 4, 50806 },	-- Leggings of Unrelenting Blood
				{ 5, 50800 },	-- Hauberk of a Thousand Cuts
				{ 6, 50801 },	-- Blade-Scored Carapace
				{ 7, 50802 },	-- Gargoyle Spit Bracers
				{ 8, 50808 },	-- Deathforged Legplates
                                                                { 16, 45038 },  -- Fragment of Val'anyr
				{ 18, 50809 },	-- Soulcleave Pendant
				{ 19, 50803 },	-- Saurfang's Cold-Forged Band
				{ 21, 50798 },	-- Ramaladni's Blade of Culling
				{ 22, 50805 },	-- Mag'hari Chieftain's Staff
				{ 24, "ac4537" },
			},
			[RAID10H_DIFF] = {
				{ 1, 51896 },	-- Thaumaturge's Crackling Cowl
				{ 2, 51899 },	-- Icecrown Spire Sandals
				{ 3, 51904 },	-- Scourge Stranglers
				{ 4, 51897 },	-- Leggings of Unrelenting Blood
				{ 5, 51903 },	-- Hauberk of a Thousand Cuts
				{ 6, 51902 },	-- Blade-Scored Carapace
				{ 7, 51901 },	-- Gargoyle Spit Bracers
				{ 8, 51895 },	-- Deathforged Legplates
				{ 10, 51894 },	-- Soulcleave Pendant
				{ 11, 51900 },	-- Saurfang's Cold-Forged Band
				{ 16, 52027 },	-- Conqueror's Mark of Sanctification
				{ 17, 52026 },	-- Protector's Mark of Sanctification
				{ 18, 52025 },	-- Vanquisher's Mark of Sanctification
				{ 20, 51905 },	-- Ramaladni's Blade of Culling
				{ 21, 51898 },	-- Mag'hari Chieftain's Staff
				{ 23, 49908 },	-- Primordial Saronite
				{ 25, "ac4537" },
			},
			[RAID25_DIFF] = {
				{ 1, 50014 },	-- Greatcloak of the Turned Champion
				{ 2, 50333 },	-- Toskk's Maximized Wristguards
				{ 3, 50015 },	-- Belt of the Blood Nova
				{ 4, 50362 },	-- Deathbringer's Will
				{ 5, 50412 },	-- Bloodvenom Blade
				{ 7, 50274 },	-- Shadowfrost Shard
				{ 8, 49908 },	-- Primordial Saronite
				{ 16, 52027 },	-- Conqueror's Mark of Sanctification
				{ 17, 52026 },	-- Protector's Mark of Sanctification
				{ 18, 52025 },	-- Vanquisher's Mark of Sanctification
				{ 20, "ac4613" },
			},
			[RAID25H_DIFF] = {
				{ 1, 50668 },	-- Greatcloak of the Turned Champion
				{ 2, 50670 },	-- Toskk's Maximized Wristguards
				{ 3, 50671 },	-- Belt of the Blood Nova
				{ 4, 50363 },	-- Deathbringer's Will
				{ 5, 50672 },	-- Bloodvenom Blade
				{ 7, 50274 },	-- Shadowfrost Shard
				{ 8, 49908 },	-- Primordial Saronite
				{ 16, 52030 },	-- Conqueror's Mark of Sanctification
				{ 17, 52029 },	-- Protector's Mark of Sanctification
				{ 18, 52028 },	-- Vanquisher's Mark of Sanctification
				{ 20, 52027 },	-- Conqueror's Mark of Sanctification
				{ 21, 52026 },	-- Protector's Mark of Sanctification
				{ 22, 52025 },	-- Vanquisher's Mark of Sanctification
				{ 24, "ac4613" },
			},
		},
		{	--ICC Festergut
			name = AL["Festergut"],
			EncounterJournalID = 1629,
            AtlasMapFile = "IcecrownCitadelB",
            AtlasMapBossID = 8,
			[RAID10_DIFF] = {
				{ 1, 50859 },	-- Cloak of Many Skins
				{ 2, 50988 },	-- Bloodstained Surgeon's Shoulderguards
				{ 3, 50990 },	-- Kilt of Untreated Wounds
				{ 4, 50985 },	-- Wrists of Septic Shock
				{ 5, 50858 },	-- Plague-Soaked Leather Leggings
				{ 6, 50812 },	-- Taldron's Long Neglected Boots
				{ 7, 50967 },	-- Festergut's Gaseous Gloves
				{ 8, 50811 },	-- Festering Fingerguards
				{ 16, 50852 },	-- Precious' Putrid Collar
				{ 17, 50986 },	-- Signet of Putrefaction
				{ 19, 50810 },	-- Gutbuster
				{ 20, 50966 },	-- Abracadaver
				{ 22, "ac4577" },
			},
			[RAID10H_DIFF] = {
				{ 1, 51888 },	-- Cloak of Many Skins
				{ 2, 51883 },	-- Bloodstained Surgeon's Shoulderguards
				{ 3, 51882 },	-- Kilt of Untreated Wounds
				{ 4, 51885 },	-- Wrists of Septic Shock
				{ 5, 51889 },	-- Plague-Soaked Leather Leggings
				{ 6, 51891 },	-- Taldron's Long Neglected Boots
				{ 7, 51886 },	-- Festergut's Gaseous Gloves
				{ 8, 51892 },	-- Festering Fingerguards
				{ 16, 51890 },	-- Precious' Putrid Collar
				{ 17, 51884 },	-- Signet of Putrefaction
				{ 19, 51893 },	-- Gutbuster
				{ 20, 51887 },	-- Abracadaver
				{ 22, 49908 },	-- Primordial Saronite
				{ 24, "ac4577" },
			},
			[RAID25_DIFF] = {
				{ 1, 50063 },	-- Lingering Illness
				{ 2, 50056 },	-- Plaguebringer's Stained Pants
				{ 3, 50062 },	-- Plague Scientist's Boots
				{ 4, 50042 },	-- Gangrenous Leggings
				{ 5, 50041 },	-- Leather of Stitched Scourge Parts
				{ 6, 50059 },	-- Horrific Flesh Epaulets
				{ 7, 50038 },	-- Carapace of Forgotten Kings
				{ 8, 50064 },	-- Unclean Surgical Gloves
				{ 9, 50413 },	-- Nerub'ar Stalker's Cord
				{ 10, 50060 },	-- Faceplate of the Forgotten
				{ 11, 50037 },	-- Fleshrending Gauntlets
				{ 12, 50036 },	-- Belt of Broken Bones
				{ 16, 50061 },	-- Holiday's Grace
				{ 17, 50414 },	-- Might of Blight
				{ 19, 50035 },	-- Black Bruise
				{ 20, 50040 },	-- Distant Land
				{ 22, 50226 },	-- Festergut's Acidic Blood
				{ 24, 50274 },	-- Shadowfrost Shard
				{ 25, 49908 },	-- Primordial Saronite
				{ 27, "ac4615" },
			},
			[RAID25H_DIFF] = {
				{ 1, 50702 },	-- Lingering Illness
				{ 2, 50694 },	-- Plaguebringer's Stained Pants
				{ 3, 50699 },	-- Plague Scientist's Boots
				{ 4, 50697 },	-- Gangrenous Leggings
				{ 5, 50696 },	-- Leather of Stitched Scourge Parts
				{ 6, 50698 },	-- Horrific Flesh Epaulets
				{ 7, 50689 },	-- Carapace of Forgotten Kings
				{ 8, 50703 },	-- Unclean Surgical Gloves
				{ 9, 50688 },	-- Nerub'ar Stalker's Cord
				{ 10, 50701 },	-- Faceplate of the Forgotten
				{ 11, 50690 },	-- Fleshrending Gauntlets
				{ 12, 50691 },	-- Belt of Broken Bones
				{ 16, 50700 },	-- Holiday's Grace
				{ 17, 50693 },	-- Might of Blight
				{ 19, 50692 },	-- Black Bruise
				{ 20, 50695 },	-- Distant Land
				{ 22, 50226 },	-- Festergut's Acidic Blood
				{ 24, 50274 },	-- Shadowfrost Shard
				{ 25, 49908 },	-- Primordial Saronite
				{ 27, "ac4615" },
			},
		},
		{	--ICC Rotface
			name = AL["Rotface"],
			EncounterJournalID = 1630,
            AtlasMapFile = "IcecrownCitadelB",
            AtlasMapBossID = 9,
			[RAID10_DIFF] = {
				{ 1, 51007 },	-- Ether-Soaked Bracers
				{ 2, 51005 },	-- Gloves of Broken Fingers
				{ 3, 51009 },	-- Chestguard of the Failed Experiment
				{ 4, 51002 },	-- Taldron's Short-Sighted Helm
				{ 5, 51006 },	-- Shuffling Shoes
				{ 6, 51000 },	-- Flesh-Shaper's Gurney Strap
				{ 8, 51008 },	-- Choker of Filthy Diamonds
				{ 9, 51001 },	-- Rotface's Rupturing Ring
				{ 16, 51003 },	-- Abomination Knuckles
				{ 17, 51004 },	-- Lockjaw
				{ 18, 50998 },	-- Gluth's Fetching Knife
				{ 19, 50999 },	-- Shaft of Glacial Ice				
				{ 21, "ac4538" },
			},
			[RAID10H_DIFF] = {
				{ 1, 51872 },	-- Ether-Soaked Bracers
				{ 2, 51874 },	-- Gloves of Broken Fingers
				{ 3, 51870 },	-- Chestguard of the Failed Experiment
				{ 4, 51877 },	-- Taldron's Short-Sighted Helm
				{ 5, 51873 },	-- Shuffling Shoes
				{ 6, 51879 },	-- Flesh-Shaper's Gurney Strap
				{ 8, 51871 },	-- Choker of Filthy Diamonds
				{ 9, 51878 },	-- Rotface's Rupturing Ring
				{ 16, 51876 },	-- Abomination Knuckles
				{ 17, 51875 },	-- Lockjaw
				{ 18, 51881 },	-- Shaft of Glacial Ice
				{ 19, 51880 },	-- Gluth's Fetching Knife
				{ 21, 49908 },	-- Primordial Saronite
				{ 23, "ac4538" },
			},
			[RAID25_DIFF] = {
				{ 1, 50019 },	-- Winding Sheet
				{ 2, 50032 },	-- Death Surgeon's Sleeves
				{ 3, 50026 },	-- Helm of the Elder Moon
				{ 4, 50021 },	-- Aldriana's Gloves of Secrecy
				{ 5, 50022 },	-- Dual-Bladed Pauldrons
				{ 6, 50030 },	-- Bloodsunder's Bracers
				{ 7, 50020 },	-- Raging Behemoth's Shoulderplates
				{ 8, 50024 },	-- Blightborne Warplate
				{ 9, 50027 },	-- Rot-Resistant Breastplate
				{ 11, 50023 },	-- Bile-Encrusted Medallion
				{ 12, 50025 },	-- Seal of Many Mouths
				{ 13, 50353 },	-- Dislodged Foreign Object
				{ 16, 50028 },	-- Trauma
				{ 17, 50016 },	-- Rib Spreader
				{ 18, 50033 },	-- Corpse-Impaling Spike
				{ 20, 50231 },	-- Rotface's Acidic Blood
				{ 22, 50274 },	-- Shadowfrost Shard
				{ 23, 49908 },	-- Primordial Saronite
				{ 25, "ac4614" },
			},
			[RAID25H_DIFF] = {
				{ 1, 50677 },	-- Winding Sheet
				{ 2, 50686 },	-- Death Surgeon's Sleeves
				{ 3, 50679 },	-- Helm of the Elder Moon
				{ 4, 50675 },	-- Aldriana's Gloves of Secrecy
				{ 5, 50673 },	-- Dual-Bladed Pauldrons
				{ 6, 50687 },	-- Bloodsunder's Bracers
				{ 7, 50674 },	-- Raging Behemoth's Shoulderplates
				{ 8, 50681 },	-- Blightborne Warplate
				{ 9, 50680 },	-- Rot-Resistant Breastplate
				{ 11, 50682 },	-- Bile-Encrusted Medallion
				{ 12, 50678 },	-- Seal of Many Mouths
				{ 13, 50348 },	-- Dislodged Foreign Object
				{ 16, 50685 },	-- Trauma
				{ 17, 50676 },	-- Rib Spreader
				{ 18, 50684 },	-- Corpse-Impaling Spike
				{ 20, 50231 },	-- Rotface's Acidic Blood
				{ 22, 50274 },	-- Shadowfrost Shard
				{ 23, 49908 },	-- Primordial Saronite
				{ 25, "ac4614" },
			},
		},
		{	--ICC Putricide
			name = AL["Professor Putricide"],
			EncounterJournalID = 1631,
            AtlasMapFile = "IcecrownCitadelB",
            AtlasMapBossID = 10,
			[RAID10_DIFF] = {
				{ 1, 51020 },	-- Shoulders of Ruinous Senility
				{ 2, 51017 },	-- Cauterized Cord
				{ 3, 51013 },	-- Discarded Bag of Entrails
				{ 4, 51015 },	-- Shoulderpads of the Morbid Ritual
				{ 5, 51019 },	-- Rippling Flesh Kilt
				{ 6, 51014 },	-- Scalpel-Sharpening Shoulderguards
				{ 7, 51018 },	-- Chestplate of Septic Stitches
                                                                { 16, 45038 },   -- Fragment of Val'anyr
				{ 18, 51012 },	-- Infected Choker
				{ 19, 51016 },	-- Pendant of Split Veins
				{ 20, 50341 },	-- Unidentifiable Organ
				{ 22, 51011 },	-- Flesh-Carving Scalpel
				{ 23, 51010 },	-- The Facelifter
				{ 25, "ac4578" },
			},
			[RAID10H_DIFF] = {
				{ 1, 51859 },	-- Shoulders of Ruinous Senility
				{ 2, 51862 },	-- Cauterized Cord
				{ 3, 51866 },	-- Discarded Bag of Entrails
				{ 4, 51864 },	-- Shoulderpads of the Morbid Ritual
				{ 5, 51860 },	-- Rippling Flesh Kilt
				{ 6, 51865 },	-- Scalpel-Sharpening Shoulderguards
				{ 7, 51861 },	-- Chestplate of Septic Stitches
				{ 9, 51867 },	-- Infected Choker
				{ 10, 51863 },	-- Pendant of Split Veins
				{ 11, 50344 },	-- Unidentifiable Organ
				{ 16, 52027 },	-- Conqueror's Mark of Sanctification
				{ 17, 52026 },	-- Protector's Mark of Sanctification
				{ 18, 52025 },	-- Vanquisher's Mark of Sanctification
				{ 20, 51868 },	-- Flesh-Carving Scalpel
				{ 21, 51869 },	-- The Facelifter
				{ 23, 49908 },	-- Primordial Saronite
				{ 25, "ac4578" },
			},
			[RAID25_DIFF] = {
				{ 1, 50067 },	-- Astrylian's Sutured Cinch
				{ 2, 50069 },	-- Professor's Bloodied Smock
				{ 3, 50351 },	-- Tiny Abomination in a Jar
				{ 4, 50179 },	-- Last Word
				{ 5, 50068 },	-- Rigormortis
				{ 7, 50274 },	-- Shadowfrost Shard
				{ 8, 49908 },	-- Primordial Saronite
				{ 16, 52027 },	-- Conqueror's Mark of Sanctification
				{ 17, 52026 },	-- Protector's Mark of Sanctification
				{ 18, 52025 },	-- Vanquisher's Mark of Sanctification
				{ 20, "ac4616" },
			},
			[RAID25H_DIFF] = {
				{ 1, 50707 },	-- Astrylian's Sutured Cinch
				{ 2, 50705 },	-- Professor's Bloodied Smock
				{ 3, 50706 },	-- Tiny Abomination in a Jar
				{ 4, 50708 },	-- Last Word
				{ 5, 50704 },	-- Rigormortis
				{ 7, 50274 },	-- Shadowfrost Shard
				{ 8, 49908 },	-- Primordial Saronite
				{ 16, 52030 },	-- Conqueror's Mark of Sanctification
				{ 17, 52029 },	-- Protector's Mark of Sanctification
				{ 18, 52028 },	-- Vanquisher's Mark of Sanctification
				{ 20, 52027 },	-- Conqueror's Mark of Sanctification
				{ 21, 52026 },	-- Protector's Mark of Sanctification
				{ 22, 52025 },	-- Vanquisher's Mark of Sanctification
				{ 24, "ac4616" },
			},
		},
		{	--ICC Council
			name = AL["Blood Prince Council"],
			EncounterJournalID = 1632,
            AtlasMapFile = "IcecrownCitadelB",
            AtlasMapBossID = 11,
			[RAID10_DIFF] = {
				{ 1, 51382 },	-- Heartsick Mender's Cape
				{ 2, 51379 },	-- Bloodsoul Raiment
				{ 3, 51380 },	-- Pale Corpse Boots
				{ 4, 51023 },	-- Taldaram's Soft Slippers
				{ 5, 51325 },	-- Blood-Drinker's Girdle
				{ 6, 51383 },	-- Spaulders of the Blood Princes
				{ 7, 51025 },	-- Battle-Maiden's Legguards
				{ 9, 51381 },	-- Cerise Coiled Ring
				{ 10, 51024 },	-- Thrice Fanged Signet
				{ 16, 51021 },	-- Soulbreaker
				{ 17, 51022 },	-- Hersir's Greatspear
				{ 18, 51326 },	-- Wand of Ruby Claret
				{ 20, "ac4582" },
			},
			[RAID10H_DIFF] = {
				{ 1, 51848 },	-- Heartsick Mender's Cape
				{ 2, 51851 },	-- Bloodsoul Raiment
				{ 3, 51850 },	-- Pale Corpse Boots
				{ 4, 51856 },	-- Taldaram's Soft Slippers
				{ 5, 51853 },	-- Blood-Drinker's Girdle
				{ 6, 51847 },	-- Spaulders of the Blood Princes
				{ 7, 51854 },	-- Battle-Maiden's Legguards
				{ 9, 51849 },	-- Cerise Coiled Ring
				{ 10, 51855 },	-- Thrice Fanged Signet
				{ 16, 51858 },	-- Soulbreaker
				{ 17, 51857 },	-- Hersir's Greatspear
				{ 18, 51852 },	-- Wand of Ruby Claret
				{ 20, 49908 },	-- Primordial Saronite
				{ 22, "ac4582" },
			},
			[RAID25_DIFF] = {
				{ 1, 50074 },	-- Royal Crimson Cloak
				{ 2, 50172 },	-- Sanguine Silk Robes
				{ 3, 50176 },	-- San'layn Ritualist Gloves
				{ 4, 50073 },	-- Geistlord's Punishment Sack
				{ 5, 50171 },	-- Shoulders of Frost-Tipped Thorns
				{ 6, 50177 },	-- Mail of Crimson Coins
				{ 7, 50071 },	-- Treads of the Wasteland
				{ 8, 50072 },	-- Landsoul's Horned Greathelm
				{ 9, 50175 },	-- Crypt Keeper's Bracers
				{ 10, 50075 },	-- Taldaram's Plated Fists
				{ 16, 50174 },	-- Incarnadine Band of Mending
				{ 17, 50170 },	-- Valanar's Other Signet Ring
				{ 19, 50184 },	-- Keleseth's Seducer
				{ 20, 49919 },	-- Cryptmaker
				{ 21, 50173 },	-- Shadow Silk Spindle
				{ 23, 50274 },	-- Shadowfrost Shard
				{ 24, 49908 },	-- Primordial Saronite
				{ 26, "ac4617" },
			},
			[RAID25H_DIFF] = {
				{ 1, 50718 },	-- Royal Crimson Cloak
				{ 2, 50717 },	-- Sanguine Silk Robes
				{ 3, 50722 },	-- San'layn Ritualist Gloves
				{ 4, 50713 },	-- Geistlord's Punishment Sack
				{ 5, 50715 },	-- Shoulders of Frost-Tipped Thorns
				{ 6, 50723 },	-- Mail of Crimson Coins
				{ 7, 50711 },	-- Treads of the Wasteland
				{ 8, 50712 },	-- Landsoul's Horned Greathelm
				{ 9, 50721 },	-- Crypt Keeper's Bracers
				{ 10, 50716 },	-- Taldaram's Plated Fists
				{ 16, 50720 },	-- Incarnadine Band of Mending
				{ 17, 50714 },	-- Valanar's Other Signet Ring
				{ 19, 50710 },	-- Keleseth's Seducer
				{ 20, 50603 },	-- Cryptmaker
				{ 21, 50719 },	-- Shadow Silk Spindle
				{ 23, 50274 },	-- Shadowfrost Shard
				{ 24, 49908 },	-- Primordial Saronite
				{ 26, "ac4617" },
			},
		},
		{	--ICC Lanathel
			name = AL["Blood-Queen Lana'thel"],
			EncounterJournalID = 1633,
            AtlasMapFile = "IcecrownCitadelB",
            AtlasMapBossID = 12,
			[RAID10_DIFF] = {
				{ 1, 51554 },	-- Cowl of Malefic Repose
				{ 2, 51552 },	-- Shoulderpads of the Searing Kiss
				{ 3, 51550 },	-- Ivory-Inlaid Leggings
				{ 4, 51551 },	-- Chestguard of Siphoned Elements
				{ 5, 51386 },	-- Throatrender Handguards
				{ 6, 51556 },	-- Veincrusher Gauntlets
				{ 7, 51555 },	-- Tightening Waistband
                                                                { 16, 45038 },   -- Fragment of Val'anyr
				{ 18, 51548 },	-- Collar of Haughty Disdain
				{ 19, 51387 },	-- Seal of the Twilight Queen
				{ 20, 51384 },	-- Bloodsipper
				{ 21, 51385 },	-- Stakethrower
				{ 22, 51553 },	-- Lana'thel's Bloody Nail
				{ 24, "ac4539" },
			},
			[RAID10H_DIFF] = {
				{ 1, 51837 },	-- Cowl of Malefic Repose
				{ 2, 51839 },	-- Shoulderpads of the Searing Kiss
				{ 3, 51841 },	-- Ivory-Inlaid Leggings
				{ 4, 51840 },	-- Chestguard of Siphoned Elements
				{ 5, 51844 },	-- Throatrender Handguards
				{ 6, 51835 },	-- Veincrusher Gauntlets
				{ 7, 51836 },	-- Tightening Waistband
				{ 9, 51842 },	-- Collar of Haughty Disdain
				{ 10, 51843 },	-- Seal of the Twilight Queen
				{ 16, 52027 },	-- Conqueror's Mark of Sanctification
				{ 17, 52026 },	-- Protector's Mark of Sanctification
				{ 18, 52025 },	-- Vanquisher's Mark of Sanctification
				{ 20, 51846 },	-- Bloodsipper
				{ 21, 51845 },	-- Stakethrower
				{ 22, 51838 },	-- Lana'thel's Bloody Nail
				{ 24, 49908 },	-- Primordial Saronite
				{ 26, "ac4539" },
			},
			[RAID25_DIFF] = {
				{ 1, 50182 },	-- Blood Queen's Crimson Choker
				{ 2, 50180 },	-- Lana'thel's Chain of Flagellation
				{ 3, 50354 },	-- Bauble of True Blood
				{ 4, 50178 },	-- Bloodfall
				{ 5, 50181 },	-- Dying Light
				{ 6, 50065 },	-- Icecrown Glacial Wall
				{ 8, 50274 },	-- Shadowfrost Shard
				{ 9, 49908 },	-- Primordial Saronite
				{ 16, 52027 },	-- Conqueror's Mark of Sanctification
				{ 17, 52026 },	-- Protector's Mark of Sanctification
				{ 18, 52025 },	-- Vanquisher's Mark of Sanctification
				{ 20, "ac4618" },
			},
			[RAID25H_DIFF] = {
				{ 1, 50724 },	-- Blood Queen's Crimson Choker
				{ 2, 50728 },	-- Lana'thel's Chain of Flagellation
				{ 3, 50726 },	-- Bauble of True Blood
				{ 4, 50727 },	-- Bloodfall
				{ 5, 50725 },	-- Dying Light
				{ 6, 50729 },	-- Icecrown Glacial Wall
				{ 8, 50274 },	-- Shadowfrost Shard
				{ 9, 49908 },	-- Primordial Saronite
				{ 16, 52030 },	-- Conqueror's Mark of Sanctification
				{ 17, 52029 },	-- Protector's Mark of Sanctification
				{ 18, 52028 },	-- Vanquisher's Mark of Sanctification
				{ 20, 52027 },	-- Conqueror's Mark of Sanctification
				{ 21, 52026 },	-- Protector's Mark of Sanctification
				{ 22, 52025 },	-- Vanquisher's Mark of Sanctification
				{ 24, "ac4618" },
			},
		},
		{	--ICC Valithria
			name = AL["Valithria Dreamwalker"],
			EncounterJournalID = 1634,
            AtlasMapFile = "IcecrownCitadelB",
            AtlasMapBossID = 14,
			[RAID10_DIFF] = {
				{ 1, 51584 },	-- Lich Wrappings
				{ 2, 51777 },	-- Leggings of the Refracted Mind
				{ 3, 51585 },	-- Sister Svalna's Spangenhelm
				{ 4, 51565 },	-- Skinned Whelp Shoulders
				{ 5, 51583 },	-- Stormbringer Gloves
				{ 6, 51566 },	-- Legguards of the Twisted Dream
				{ 7, 51586 },	-- Emerald Saint's Spaulders
				{ 8, 51563 },	-- Taiga Bindings
				{ 9, 51564 },	-- Ironrope Belt of Ymirjar
				{ 16, 51562 },	-- Oxheart
				{ 17, 51582 },	-- Sister Svalna's Aether Staff
				{ 18, 51561 },	-- Dreamhunter's Carbine
				{ 20, "ac4579" },
			},
			[RAID10H_DIFF] = {
				{ 1, 51826 },	-- Lich Wrappings
				{ 2, 51823 },	-- Leggings of the Refracted Mind
				{ 3, 51825 },	-- Sister Svalna's Spangenhelm
				{ 4, 51830 },	-- Skinned Whelp Shoulders
				{ 5, 51827 },	-- Stormbringer Gloves
				{ 6, 51829 },	-- Legguards of the Twisted Dream
				{ 7, 51824 },	-- Emerald Saint's Spaulders
				{ 8, 51832 },	-- Taiga Bindings
				{ 9, 51831 },	-- Ironrope Belt of Ymirjar
				{ 16, 51833 },	-- Oxheart
				{ 17, 51828 },	-- Sister Svalna's Aether Staff
				{ 18, 51834 },	-- Dreamhunter's Carbine
				{ 20, 49908 },	-- Primordial Saronite
				{ 22, "ac4579" },
			},
			[RAID25_DIFF] = {
				{ 1, 50205 },	-- Frostbinder's Shredded Cape
				{ 2, 50418 },	-- Robe of the Waking Nightmare
				{ 3, 50417 },	-- Bracers of Eternal Dreaming
				{ 4, 50202 },	-- Snowstorm Helm
				{ 5, 50188 },	-- Anub'ar Stalker's Gloves
				{ 6, 50187 },	-- Coldwraith Links
				{ 7, 50199 },	-- Leggings of Dying Candles
				{ 8, 50192 },	-- Scourge Reaver's Legplates
				{ 9, 50416 },	-- Boots of the Funeral March
				{ 10, 50190 },	-- Grinning Skull Greatboots
				{ 16, 50195 },	-- Noose of Malachite
				{ 17, 50185 },	-- Devium's Eternally Cold Ring
				{ 18, 50186 },	-- Frostbrood Sapphire Ring
				{ 20, 50183 },	-- Lungbreaker
				{ 21, 50472 },	-- Nightmare Ender
				{ 23, 50274 },	-- Shadowfrost Shard
				{ 24, 49908 },	-- Primordial Saronite
				{ 26, "ac4619" },
			},
			[RAID25H_DIFF] = {
				{ 1, 50628 },	-- Frostbinder's Shredded Cape
				{ 2, 50629 },	-- Robe of the Waking Nightmare
				{ 3, 50630 },	-- Bracers of Eternal Dreaming
				{ 4, 50626 },	-- Snowstorm Helm
				{ 5, 50619 },	-- Anub'ar Stalker's Gloves
				{ 6, 50620 },	-- Coldwraith Links
				{ 7, 50623 },	-- Leggings of Dying Candles
				{ 8, 50624 },	-- Scourge Reaver's Legplates
				{ 9, 50632 },	-- Boots of the Funeral March
				{ 10, 50625 },	-- Grinning Skull Greatboots
				{ 16, 50627 },	-- Noose of Malachite
				{ 17, 50622 },	-- Devium's Eternally Cold Ring
				{ 18, 50618 },	-- Frostbrood Sapphire Ring
				{ 20, 50621 },	-- Lungbreaker
				{ 21, 50631 },	-- Nightmare Ender
				{ 23, 50274 },	-- Shadowfrost Shard
				{ 24, 49908 },	-- Primordial Saronite
				{ 26, "ac4619" },
			},
		},
		{	--ICC Sindragosa
			name = AL["Sindragosa"],
			EncounterJournalID = 1635,
            AtlasMapFile = "IcecrownCitadelB",
            AtlasMapBossID = 15,
			[RAID10_DIFF] = {
				{ 1, 51790 },	-- Robes of Azure Downfall
				{ 2, 51783 },	-- Vambraces of the Frost Wyrm Queen
				{ 3, 51789 },	-- Icicle Shapers
				{ 4, 51792 },	-- Shoulderguards of Crystalline Bone
				{ 5, 51785 },	-- Wyrmwing Treads
				{ 6, 51782 },	-- Etched Dragonbone Girdle
				{ 7, 51786 },	-- Legplates of Aetheric Strife
				{ 8, 51787 },	-- Scourge Fanged Stompers
				{ 16, 45038 },  -- Fragment of Val'anyr
				{ 18, 51779 },	-- Rimetooth Pendant
				{ 19, 51784 },	-- Splintershard
				{ 20, 51788 },	-- Bleak Coldarra Carver
				{ 21, 51791 },	-- Lost Pavise of the Blue Flight
				{ 23, "ac4580" },
			},
			[RAID10H_DIFF] = {
				{ 1, 51813 },	-- Robes of Azure Downfall
				{ 2, 51820 },	-- Vambraces of the Frost Wyrm Queen
				{ 3, 51814 },	-- Icicle Shapers
				{ 4, 51811 },	-- Shoulderguards of Crystalline Bone
				{ 5, 51818 },	-- Wyrmwing Treads
				{ 6, 51821 },	-- Etched Dragonbone Girdle
				{ 7, 51817 },	-- Legplates of Aetheric Strife
				{ 8, 51816 },	-- Scourge Fanged Stompers
				{ 10, 51822 },	-- Rimetooth Pendant
				{ 16, 52027 },	-- Conqueror's Mark of Sanctification
				{ 17, 52026 },	-- Protector's Mark of Sanctification
				{ 18, 52025 },	-- Vanquisher's Mark of Sanctification
				{ 20, 51819 },	-- Splintershard
				{ 21, 51815 },	-- Bleak Coldarra Carver
				{ 22, 51812 },	-- Lost Pavise of the Blue Flight
				{ 24, 49908 },	-- Primordial Saronite
				{ 26, "ac4580" },
			},
			[RAID25_DIFF] = {
				{ 1, 50421 },	-- Sindragosa's Cruel Claw
				{ 2, 50424 },	-- Memory of Malygos
				{ 3, 50360 },	-- Phylactery of the Nameless Lich
				{ 4, 50361 },	-- Sindragosa's Flawless Fang
				{ 5, 50423 },	-- Sundial of Eternal Dusk
				{ 7, 50274 },	-- Shadowfrost Shard
				{ 8, 49908 },	-- Primordial Saronite
				{ 16, 52027 },	-- Conqueror's Mark of Sanctification
				{ 17, 52026 },	-- Protector's Mark of Sanctification
				{ 18, 52025 },	-- Vanquisher's Mark of Sanctification
				{ 20, "ac4620" },
			},
			[RAID25H_DIFF] = {
				{ 1, 50633 },	-- Sindragosa's Cruel Claw
				{ 2, 50636 },	-- Memory of Malygos
				{ 3, 50365 },	-- Phylactery of the Nameless Lich
				{ 4, 50364 },	-- Sindragosa's Flawless Fang
				{ 5, 50635 },	-- Sundial of Eternal Dusk
				{ 7, 50274 },	-- Shadowfrost Shard
				{ 8, 49908 },	-- Primordial Saronite
				{ 16, 52030 },	-- Conqueror's Mark of Sanctification
				{ 17, 52029 },	-- Protector's Mark of Sanctification
				{ 18, 52028 },	-- Vanquisher's Mark of Sanctification
				{ 20, 52027 },	-- Conqueror's Mark of Sanctification
				{ 21, 52026 },	-- Protector's Mark of Sanctification
				{ 22, 52025 },	-- Vanquisher's Mark of Sanctification
				{ 24, "ac4620" },
			},
		},
		{	--ICC LichKing
			name = AL["The Lich King"],
			EncounterJournalID = 1636,
            AtlasMapFile = "IcecrownCitadelC",
            AtlasMapBossID = 16,
			[RAID10_DIFF] = {
				{ 1, 51801 },	-- Pugius, Fist of Defiance
				{ 2, 51803 },	-- Tel'thas, Dagger of the Blood King
				{ 3, 51800 },	-- Stormfury, Black Blade of the Betrayer
				{ 4, 51795 },	-- Troggbane, Axe of the Frostborne King
				{ 5, 51798 },	-- Valius, Gavel of the Lightbringer
				{ 6, 51796 },	-- Warmace of Menethil
				{ 7, 51799 },	-- Halion, Staff of Forgotten Love
				{ 8, 51797 },	-- Tainted Twig of Nordrassil
				{ 9, 51802 },	-- Windrunner's Heartseeker
				{ 16, 45038 },  -- 瓦兰奈尔的碎片
				{ 18, 249820 }, -- 胜利旌旗
                { 19, 249821 }, -- 深渊符文
                { 20, 249819 }, -- 黑心
                { 21, 248753 },	-- 陨星水晶
				{ 22, 248754 }, -- 钢铁之心
				{ 24, "ac4530" },
				{ 25, "ac4601" },
				{ 26, "ac4581" },
			},
			[RAID10H_DIFF] = {
				{ 1, 51941 },	-- Pugius, Fist of Defiance
				{ 2, 51939 },	-- Tel'thas, Dagger of the Blood King
				{ 3, 51942 },	-- Stormfury, Black Blade of the Betrayer
				{ 4, 51947 },	-- Troggbane, Axe of the Frostborne King
				{ 5, 51944 },	-- Valius, Gavel of the Lightbringer
				{ 6, 51946 },	-- Warmace of Menethil
				{ 7, 51943 },	-- Halion, Staff of Forgotten Love
				{ 8, 51945 },	-- Tainted Twig of Nordrassil
				{ 9, 51940 },	-- Windrunner's Heartseeker
				{ 16, 52027 },	-- Conqueror's Mark of Sanctification
				{ 17, 52026 },	-- Protector's Mark of Sanctification
				{ 18, 52025 },	-- Vanquisher's Mark of Sanctification
				{ 20, 49908 },	-- Primordial Saronite
				{ 22, "ac4583" },
				{ 23, "ac4601" },
				{ 24, "ac4581" },
			},
			[RAID25_DIFF] = {
				{ 1, 50426 },	-- Heaven's Fall, Kryss of a Thousand Lies
				{ 2, 50427 },	-- Bloodsurge, Kel'Thuzad's Blade of Agony
				{ 3, 50070 },	-- Glorenzelg, High-Blade of the Silver Hand
				{ 4, 50012 },	-- Havoc's Call, Blade of Lordaeron Kings
				{ 5, 50428 },	-- Royal Scepter of Terenas II
				{ 6, 49997 },	-- Mithrios, Bronzebeard's Legacy
				{ 7, 50425 },	-- Oathbinder, Charge of the Ranger-General
				{ 8, 50429 },	-- Archus, Greatstaff of Antonidas
				{ 9, 49981 },	-- Fal'inrush, Defender of Quel'thalas
				{ 16, 52027 },	-- Conqueror's Mark of Sanctification
				{ 17, 52026 },	-- Protector's Mark of Sanctification
				{ 18, 52025 },	-- Vanquisher's Mark of Sanctification
				{ 20, 50274 },	-- Shadowfrost Shard
				{ 21, 49908 },	-- Primordial Saronite
				{ 23, "ac4597" },
				{ 24, "ac4621" },
				{ 25, "ac4622" },
			},
			[RAID25H_DIFF] = {
				{ 1, 50736 },	-- Heaven's Fall, Kryss of a Thousand Lies
				{ 2, 50732 },	-- Bloodsurge, Kel'Thuzad's Blade of Agony
				{ 3, 50730 },	-- Glorenzelg, High-Blade of the Silver Hand
				{ 4, 50737 },	-- Havoc's Call, Blade of Lordaeron Kings
				{ 5, 50734 },	-- Royal Scepter of Terenas II
				{ 6, 50738 },	-- Mithrios, Bronzebeard's Legacy
				{ 7, 50735 },	-- Oathbinder, Charge of the Ranger-General
				{ 8, 50731 },	-- Archus, Greatstaff of Antonidas
				{ 9, 50733 },	-- Fal'inrush, Defender of Quel'thalas
				{ 12, 50818 },	-- Invincible's Reins
				{ 14, 50274 },	-- Shadowfrost Shard
				{ 15, 49908 },	-- Primordial Saronite
				{ 16, 52030 },	-- Conqueror's Mark of Sanctification
				{ 17, 52029 },	-- Protector's Mark of Sanctification
				{ 18, 52028 },	-- Vanquisher's Mark of Sanctification
				{ 20, 52027 },	-- Conqueror's Mark of Sanctification
				{ 21, 52026 },	-- Protector's Mark of Sanctification
				{ 22, 52025 },	-- Vanquisher's Mark of Sanctification
				{ 25, "ac4584" },
				{ 26, "ac4621" },
				{ 27, "ac4622" },
			},
		},
		{	--ICC Trash
			name = AL["Trash Mobs"],
			ExtraList = true,
			[RAID25_DIFF] = {
				{ 1, 50449 },	-- Stiffened Corpse Shoulderpads
				{ 2, 50450 },	-- Leggings of Dubious Charms
				{ 3, 50451 },	-- Belt of the Lonely Noble
				{ 4, 50452 },	-- Wodin's Lucky Necklace
				{ 5, 50447 },	-- Harbinger's Bone Band
				{ 6, 50453 },	-- Ring of Rotting Sinew
				{ 7, 50444 },	-- Rowan's Rifle of Silver Bullets
			},
		},
		T10_SET,
		WOTLK_ICC_AC_TABLE,
	}
}

-- The Ruby Sanctum / T10
data["RubySanctum"] = {
	EncounterJournalID = 761,
	MapID = 4987,
    name = AL["P10 Ruby Sanctum"],
    InstanceID = 724,
    AtlasModule = ATLAS_MODULE_NAME,
	AtlasMapID = "RubySanctum",
    AtlasMapFile = {"RubySanctum"},
	ContentType = RAID_CONTENT,
    -- LevelRange = {80, 80, 80},
	items = {
		{	--Halion
            name = AL["Halion"],
			EncounterJournalID = 1652,
            AtlasMapBossID = 4,
			[RAID10_DIFF] = {
				{ 1, 53115 },	-- Abduction's Cover
				{ 2, 53118 },	-- Misbegotten Belt
				{ 3, 53114 },	-- Gloaming Sark
				{ 4, 53117 },	-- Changeling Gloves
				{ 5, 53113 },	-- Twilight Scale Shoulders
				{ 6, 53119 },	-- Boots of Divided Being
				{ 7, 53112 },	-- Bracers of the Heir
				{ 8, 53121 },	-- Surrogate Belt
				{ 9, 53111 },	-- Scion's Treads
				{ 16, 53103 },	-- Baltharus' Gift
				{ 17, 53116 },	-- Saviana's Tribute
				{ 18, 53110 },	-- Zarithrian's Offering
				{ 20, "ac4817" },
			},
			[RAID10H_DIFF] = {
				{ 1, 54556 },	-- Abduction's Cover
				{ 2, 54562 },	-- Misbegotten Belt
				{ 3, 54561 },	-- Gloaming Sark
				{ 4, 54560 },	-- Changeling Gloves
				{ 5, 54566 },	-- Twilight Scale Shoulders
				{ 6, 54558 },	-- Boots of Divided Being
				{ 7, 54559 },	-- Bracers of the Heir
				{ 8, 54565 },	-- Surrogate Belt
				{ 9, 54564 },	-- Scion's Treads
				{ 16, 54557 },	-- Baltharus' Gift
				{ 17, 54563 },	-- Saviana's Tribute
				{ 18, 54567 },	-- Zarithrian's Offering
				{ 20, "ac4818" },
			},
			[RAID25_DIFF] = {
				{ 1, 53489 },	-- Cloak of Burning Dusk
				{ 2, 53486 },	-- Bracers of Fiery Night
				{ 3, 53134 },	-- Phaseshifter's Bracers
				{ 4, 53126 },	-- Umbrage Armbands
				{ 5, 53488 },	-- Split Shape Belt
				{ 6, 53127 },	-- Returning Footfalls
				{ 7, 53125 },	-- Apocalypse's Advance
				{ 8, 53487 },	-- Foreshadow Steps
				{ 9, 53129 },	-- Treads of Impending Resurrection
				{ 16, 53132 },	-- Penumbra Pendant
				{ 17, 53490 },	-- Ring of Phased Regeneration
				{ 18, 53133 },	-- Signet of Twilight
				{ 19, 54572 },	-- Charred Twilight Scale
				{ 20, 54573 },	-- Glowing Twilight Scale
				{ 21, 54571 },	-- Petrified Twilight Scale
				{ 22, 54569 },	-- Sharpened Twilight Scale
				{ 24, "ac4815" },
			},
			[RAID25H_DIFF] = {
				{ 1, 54583 },	-- Cloak of Burning Dusk
				{ 2, 54582 },	-- Bracers of Fiery Night
				{ 3, 54584 },	-- Phaseshifter's Bracers
				{ 4, 54580 },	-- Umbrage Armbands
				{ 5, 54587 },	-- Split Shape Belt
				{ 6, 54577 },	-- Returning Footfalls
				{ 7, 54578 },	-- Apocalypse's Advance
				{ 8, 54586 },	-- Foreshadow Steps
				{ 9, 54579 },	-- Treads of Impending Resurrection
				{ 16, 54581 },	-- Penumbra Pendant
				{ 17, 54585 },	-- Ring of Phased Regeneration
				{ 18, 54576 },	-- Signet of Twilight
				{ 19, 54588 },	-- Charred Twilight Scale
				{ 20, 54589 },	-- Glowing Twilight Scale
				{ 21, 54591 },	-- Petrified Twilight Scale
				{ 22, 54590 },	-- Sharpened Twilight Scale
				{ 24, "ac4816" },
			},
		},
        T10_SET,
	}
}

data["HyjalSummit80"] = {
	MapID = 3606,
	InstanceID = 534,

    name = AL["Finale Hyjal Summit"],
	AtlasModule = ATLAS_TBC_MODULE_NAME,
	AtlasMapID = "CoTHyjal",
	AtlasMapFile = {"CoTHyjal", "CL_CoTHyjalEnt"},
	ContentType = RAID_CONTENT,
    ContentPhaseBC = 3,
	items = {
        { -- MountHyjalWinterchill
            name = AL["Rage Winterchill"],
            npcID = 17767,
            Level = 999,
            DisplayIDs = {{17444}},
            AtlasMapBossID = 1,
            [NORMAL_DIFF] = {
                { 1, 30871 }, -- Bracers of Martyrdom
                { 2, 30870 }, -- Cuffs of Devastation
                { 3, 30863 }, -- Deadly Cuffs
                { 4, 30868 }, -- Rejuvenating Bracers
                { 5, 30864 }, -- Bracers of the Pathfinder
                { 6, 30869 }, -- Howling Wind Bracers
                { 7, 30873 }, -- Stillwater Boots
                { 8, 30866 }, -- Blood-stained Pauldrons
                { 9, 30862 }, -- Blessed Adamantite Bracers
                { 10, 30861 }, -- Furious Shackles
                { 16, 30865 }, -- Tracker's Blade
                { 17, 30872 }, -- Chronicle of Dark Secrets
                { 19, 32459 }, -- Time-Phased Phylactery
            }
        },
        { -- MountHyjalAnetheron
            name = AL["Anetheron"],
            npcID = 17808,
            Level = 999,
            DisplayIDs = {{21069}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 30884 }, -- Hatefury Mantle
                { 2, 30888 }, -- Anetheron's Noose
                { 3, 30885 }, -- Archbishop's Slippers
                { 4, 30879 }, -- Don Alejandro's Money Belt
                { 5, 30886 }, -- Enchanted Leather Sandals
                { 6, 30887 }, -- Golden Links of Restoration
                { 7, 30880 }, -- Quickstrider Moccasins
                { 8, 30878 }, -- Glimmering Steel Mantle
                { 16, 30874 }, -- The Unbreakable Will
                { 17, 30881 }, -- Blade of Infamy
                { 18, 30883 }, -- Pillar of Ferocity
                { 19, 30882 }, -- Bastion of Light
            }
        },
        { -- MountHyjalKazrogal
            name = AL["Kaz'rogal"],
            npcID = 17888,
            Level = 999,
            DisplayIDs = {{17886}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 30895 }, -- Angelista's Sash
                { 2, 30916 }, -- Leggings of Channeled Elements
                { 3, 30894 }, -- Blue Suede Shoes
                { 4, 30917 }, -- Razorfury Mantle
                { 5, 30914 }, -- Belt of the Crescent Moon
                { 6, 30891 }, -- Black Featherlight Boots
                { 7, 30892 }, -- Beast-tamer's Shoulders
                { 8, 30919 }, -- Valestalker Girdle
                { 9, 30893 }, -- Sun-touched Chain Leggings
                { 10, 30915 }, -- Belt of Seething Fury
                { 16, 30918 }, -- Hammer of Atonement
                { 17, 30889 }, -- Kaz'rogal's Hardened Heart
            }
        },
        { -- MountHyjalAzgalor
            name = AL["Azgalor"],
            npcID = 17842,
            Level = 999,
            DisplayIDs = {{18526}},
            AtlasMapBossID = 4,
            [NORMAL_DIFF] = {
                { 1, 30899 }, -- Don Rodrigo's Poncho
                { 2, 30898 }, -- Shady Dealer's Pantaloons
                { 3, 30900 }, -- Bow-stitched Leggings
                { 4, 30896 }, -- Glory of the Defender
                { 5, 30897 }, -- Girdle of Hope
                { 6, 30901 }, -- Boundless Agony
                { 16, 31092 }, -- Gloves of the Forgotten Conqueror
                { 17, 31094 }, -- Gloves of the Forgotten Protector
                { 18, 31093 }, -- Gloves of the Forgotten Vanquisher
            }
        },
        { -- MountHyjalArchimonde
            name = AL["Archimonde"],
            npcID = 17968,
            Level = 999,
            DisplayIDs = {{20939}},
            AtlasMapBossID = 5,
            [NORMAL_DIFF] = {
                { 1, 30913 }, -- Robes of Rhonin
                { 2, 30912 }, -- Leggings of Eternity
                { 3, 30905 }, -- Midnight Chestguard
                { 4, 30907 }, -- Mail of Fevered Pursuit
                { 5, 30904 }, -- Savior's Grasp
                { 6, 30903 }, -- Legguards of Endless Rage
                { 7, 30911 }, -- Scepter of Purification
                { 9, 30910 }, -- Tempest of Chaos
                { 10, 30902 }, -- Cataclysm's Edge
                { 11, 30908 }, -- Apostle of Argus
                { 12, 30909 }, -- Antonidas's Aegis of Rapt Concentration
                { 13, 30906 }, -- Bristleblitz Striker
                { 16, 31097 }, -- Helm of the Forgotten Conqueror
                { 17, 31095 }, -- Helm of the Forgotten Protector
                { 18, 31096 }, -- Helm of the Forgotten Vanquisher
            }
        },
        { -- MountHyjalTrash
            name = AL["Trash"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 32590 }, -- Nethervoid Cloak
                { 2, 34010 }, -- Pepe's Shroud of Pacification
                { 3, 32609 }, -- Boots of the Divine Light
                { 4, 32592 }, -- Chestguard of Relentless Storms
                { 5, 32591 }, -- Choker of Serrated Blades
                { 6, 32589 }, -- Hellfire-Encased Pendant
                { 7, 34009 }, -- Hammer of Judgement
                { 8, 32946 }, -- Claw of Molten Fury
                { 9, 32945 }, -- Fist of Molten Fury
                { 11, 32428 }, -- Heart of Darkness
                { 12, 32897 }, -- Mark of the Illidari
                { 16, 32285 }, -- Design: Flashing Crimson Spinel
                { 17, 32296 }, -- Design: Great Lionseye
                { 18, 32303 }, -- Design: Inscribed Pyrestone
                { 19, 32295 }, -- Design: Mystic Lionseye
                { 20, 32298 }, -- Design: Shifting Shadowsong Amethyst
                { 21, 32297 }, -- Design: Sovereign Shadowsong Amethyst
                { 22, 32289 }, -- Design: Stormy Empyrean Sapphire
                { 23, 32307 }, -- Design: Veiled Pyrestone
            }
        },
        T6_SET
    }
}

data["BlackTemple80"] = {
	MapID = 3959,
	InstanceID = 564,
    name = AL["Finale BlackTemple"],
	AtlasModule = ATLAS_TBC_MODULE_NAME,
	AtlasMapID = "CL_BlackTempleStart",
	AtlasMapFile = "CL_BlackTempleStart",
	ContentType = RAID_CONTENT,
    ContentPhaseBC = 3,
	items = {
        { -- BTNajentus
            name = AL["High Warlord Naj'entus"],
            npcID = 22887,
            Level = 999,
            DisplayIDs = {{21174}},
            AtlasMapBossID = 2,
            [NORMAL_DIFF] = {
                { 1, 32239 }, -- Slippers of the Seacaller
                { 2, 32240 }, -- Guise of the Tidal Lurker
                { 3, 32377 }, -- Mantle of Darkness
                { 4, 32241 }, -- Helm of Soothing Currents
                { 5, 32234 }, -- Fists of Mukoa
                { 6, 32242 }, -- Boots of Oceanic Fury
                { 7, 32232 }, -- Eternium Shell Bracers
                { 8, 32243 }, -- Pearl Inlaid Boots
                { 9, 32245 }, -- Tide-stomper's Greaves
                { 16, 32238 }, -- Ring of Calming Waves
                { 17, 32247 }, -- Ring of Captured Storms
                { 18, 32237 }, -- The Maelstrom's Fury
                { 19, 32236 }, -- Rising Tide
                { 20, 32248 }, -- Halberd of Desolation
            }
        },
        { -- BTSupremus
            name = AL["Supremus"],
            npcID = 22898,
            Level = 999,
            DisplayIDs = {{21145}},
            AtlasMapBossID = 3,
            [NORMAL_DIFF] = {
                { 1, 32256 }, -- Waistwrap of Infinity
                { 2, 32252 }, -- Nether Shadow Tunic
                { 3, 32259 }, -- Bands of the Coming Storm
                { 4, 32251 }, -- Wraps of Precise Flight
                { 5, 32258 }, -- Naturalist's Preserving Cinch
                { 6, 32250 }, -- Pauldrons of Abyssal Fury
                { 16, 32260 }, -- Choker of Endless Nightmares
                { 17, 32261 }, -- Band of the Abyssal Lord
                { 18, 32257 }, -- Idol of the White Stag
                { 19, 32254 }, -- The Brutalizer
                { 20, 32262 }, -- Syphon of the Nathrezim
                { 21, 32255 }, -- Felstone Bulwark
                { 22, 32253 }, -- Legionkiller
            }
        },
        { -- BTAkama
            name = AL["Shade of Akama"],
            npcID = 22841,
            Level = 999,
            DisplayIDs = {{21357}},
            AtlasMapBossID = 4,
            [NORMAL_DIFF] = {
                { 1, 32273 }, -- Amice of Brilliant Light
                { 2, 32270 }, -- Focused Mana Bindings
                { 3, 32513 }, -- Wristbands of Divine Influence
                { 4, 32265 }, -- Shadow-walker's Cord
                { 5, 32271 }, -- Kilt of Immortal Nature
                { 6, 32264 }, -- Shoulders of the Hidden Predator
                { 7, 32275 }, -- Spiritwalker Gauntlets
                { 8, 32276 }, -- Flashfire Girdle
                { 9, 32279 }, -- The Seeker's Wristguards
                { 10, 32278 }, -- Grips of Silent Justice
                { 11, 32263 }, -- Praetorian's Legguards
                { 12, 32268 }, -- Myrmidon's Treads
                { 16, 32266 }, -- Ring of Deceitful Intent
                { 17, 32361 }, -- Blind-Seers Icon
            }
        },
        { -- BTBloodboil
            name = AL["Gurtogg Bloodboil"],
            npcID = 22948,
            Level = 999,
            DisplayIDs = {{21443}},
            AtlasMapFile = "CL_BlackTempleBasement",
            AtlasMapBossID = 6,
            [NORMAL_DIFF] = {
                { 1, 32337 }, -- Shroud of Forgiveness
                { 2, 32338 }, -- Blood-cursed Shoulderpads
                { 3, 32340 }, -- Garments of Temperance
                { 4, 32339 }, -- Belt of Primal Majesty
                { 5, 32334 }, -- Vest of Mounting Assault
                { 6, 32342 }, -- Girdle of Mighty Resolve
                { 7, 32333 }, -- Girdle of Stability
                { 8, 32341 }, -- Leggings of Divine Retribution
                { 16, 32335 }, -- Unstoppable Aggressor's Ring
                { 17, 32501 }, -- Shadowmoon Insignia
                { 18, 32269 }, -- Messenger of Fate
                { 19, 32344 }, -- Staff of Immaculate Recovery
                { 20, 32343 }, -- Wand of Prismatic Focus
            }
        },
        { -- BTEssencofSouls
            name = AL["Reliquary of the Lost"],
            npcID = 22856,
            Level = 999,
            DisplayIDs = {{21146}},
            AtlasMapFile = "CL_BlackTempleBasement",
            AtlasMapBossID = 7,
            [NORMAL_DIFF] = {
                { 1, 32353 }, -- Gloves of Unfailing Faith
                { 2, 32351 }, -- Elunite Empowered Bracers
                { 3, 32347 }, -- Grips of Damnation
                { 4, 32352 }, -- Naturewarden's Treads
                { 5, 32517 }, -- The Wavemender's Mantle
                { 6, 32346 }, -- Boneweave Girdle
                { 7, 32354 }, -- Crown of Empowered Fate
                { 8, 32345 }, -- Dreadboots of the Legion
                { 16, 32349 }, -- Translucent Spellthread Necklace
                { 17, 32362 }, -- Pendant of Titans
                { 18, 32350 }, -- Touch of Inspiration
                { 19, 32332 }, -- Torch of the Damned
                { 20, 32363 }, -- Naaru-Blessed Life Rod
            }
        },
        { -- BTGorefiend
            name = AL["Teron Gorefiend"],
            npcID = 22871,
            Level = 999,
            DisplayIDs = {{21254}},
            AtlasMapFile = "CL_BlackTempleBasement",
            AtlasMapBossID = 8,
            [NORMAL_DIFF] = {
                { 1, 32323 }, -- Shadowmoon Destroyer's Drape
                { 2, 32329 }, -- Cowl of Benevolence
                { 3, 32327 }, -- Robe of the Shadow Council
                { 4, 32324 }, -- Insidious Bands
                { 5, 32328 }, -- Botanist's Gloves of Growth
                { 6, 32510 }, -- Softstep Boots of Tracking
                { 7, 32280 }, -- Gauntlets of Enforcement
                { 8, 32512 }, -- Girdle of Lordaeron's Fallen
                { 16, 32330 }, -- Totem of Ancestral Guidance
                { 17, 32348 }, -- Soul Cleaver
                { 18, 32326 }, -- Twisted Blades of Zarak
                { 19, 32325 }, -- Rifle of the Stoic Guardian
            }
        },
        { -- BTShahraz
            name = AL["Mother Shahraz"],
            npcID = 22947,
            Level = 999,
            DisplayIDs = {{21252}},
            AtlasMapFile = "CL_BlackTempleTop",
            AtlasMapBossID = 9,
            [NORMAL_DIFF] = {
                { 1, 32367 }, -- Leggings of Devastation
                { 2, 32366 }, -- Shadowmaster's Boots
                { 3, 32365 }, -- Heartshatter Breastplate
                { 4, 32370 }, -- Nadina's Pendant of Purity
                { 5, 32368 }, -- Tome of the Lightbringer
                { 6, 32369 }, -- Blade of Savagery
                { 16, 31101 }, -- Pauldrons of the Forgotten Conqueror
                { 17, 31103 }, -- Pauldrons of the Forgotten Protector
                { 18, 31102 }, -- Pauldrons of the Forgotten Vanquisher
            }
        },
        { -- BTCouncil
            name = AL["The Illidari Council"],
            npcID = {23426, 22949, 22950, 22951, 22952},
            Level = 999,
            DisplayIDs = {{21416},{21417},{21419},{21418}},
            AtlasMapFile = "CL_BlackTempleTop",
            AtlasMapBossID = 10,
            [NORMAL_DIFF] = {
                { 1, 32331 }, -- Cloak of the Illidari Council
                { 2, 32519 }, -- Belt of Divine Guidance
                { 3, 32518 }, -- Veil of Turning Leaves
                { 4, 32376 }, -- Forest Prowler's Helm
                { 5, 32373 }, -- Helm of the Illidari Shatterer
                { 6, 32505 }, -- Madness of the Betrayer
                { 16, 31098 }, -- Leggings of the Forgotten Conqueror
                { 17, 31100 }, -- Leggings of the Forgotten Protector
                { 18, 31099 }, -- Leggings of the Forgotten Vanquisher
            }
        },
        { -- BTIllidanStormrage
            name = AL["Illidan Stormrage"],
            npcID = 22917,
            Level = 999,
            DisplayIDs = {{21135}},
            AtlasMapFile = "CL_BlackTempleTop",
            AtlasMapBossID = 11,
            [NORMAL_DIFF] = {
                { 1, 32524 }, -- Shroud of the Highborne
                { 2, 32525 }, -- Cowl of the Illidari High Lord
                { 3, 32235 }, -- Cursed Vision of Sargeras
                { 4, 32521 }, -- Faceplate of the Impenetrable
                { 5, 32497 }, -- Stormrage Signet Ring
                { 6, 32483 }, -- The Skull of Gul'dan
                { 7, 32496 }, -- Memento of Tyrande
                { 9, 32837 }, -- Warglaive of Azzinoth
                { 10, 32838 }, -- Warglaive of Azzinoth
                { 11, 242551},
                { 16, 31089 }, -- Chestguard of the Forgotten Conqueror
                { 17, 31091 }, -- Chestguard of the Forgotten Protector
                { 18, 31090 }, -- Chestguard of the Forgotten Vanquisher
                { 20, 32471 }, -- Shard of Azzinoth
                { 21, 32500 }, -- Crystal Spire of Karabor
                { 22, 32374 }, -- Zhar'doom, Greatstaff of the Devourer
                { 23, 32375 }, -- Bulwark of Azzinoth
                { 24, 32336 }, -- Black Bow of the Betrayer
            }
        },
        { -- BTTrash
            name = AL["Trash"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 32590 }, -- Nethervoid Cloak
                { 2, 34012 }, -- Shroud of the Final Stand
                { 3, 32609 }, -- Boots of the Divine Light
                { 4, 32593 }, -- Treads of the Den Mother
                { 5, 32592 }, -- Chestguard of Relentless Storms
                { 6, 32608 }, -- Pillager's Gauntlets
                { 7, 32606 }, -- Girdle of the Lightbearer
                { 8, 32591 }, -- Choker of Serrated Blades
                { 9, 32589 }, -- Hellfire-Encased Pendant
                { 10, 32526 }, -- Band of Devastation
                { 11, 32528 }, -- Blessed Band of Karabor
                { 12, 32527 }, -- Ring of Ancient Knowledge
                { 16, 34009 }, -- Hammer of Judgement
                { 17, 32943 }, -- Swiftsteel Bludgeon
                { 18, 34011 }, -- Illidari Runeshield
                { 20, 32228 }, -- Empyrean Sapphire
                { 21, 32231 }, -- Pyrestone
                { 22, 32229 }, -- Lionseye
                { 23, 32249 }, -- Seaspray Emerald
                { 24, 32230 }, -- Shadowsong Amethyst
                { 25, 32227 }, -- Crimson Spinel
                { 27, 32428 }, -- Heart of Darkness
                { 28, 32897 }, -- Mark of the Illidari
            }
        },
        { -- BTPatterns
            name = AL["Patterns"],
            ExtraList = true,
            [NORMAL_DIFF] = {
                { 1, 32738 }, -- Plans: Dawnsteel Bracers
                { 2, 32739 }, -- Plans: Dawnsteel Shoulders
                { 3, 32736 }, -- Plans: Swiftsteel Bracers
                { 4, 32737 }, -- Plans: Swiftsteel Shoulders
                { 5, 32748 }, -- Pattern: Bindings of Lightning Reflexes
                { 6, 32744 }, -- Pattern: Bracers of Renewed Life
                { 7, 32750 }, -- Pattern: Living Earth Bindings
                { 8, 32751 }, -- Pattern: Living Earth Shoulders
                { 9, 32749 }, -- Pattern: Shoulders of Lightning Reflexes
                { 10, 32745 }, -- Pattern: Shoulderpads of Renewed Life
                { 11, 32746 }, -- Pattern: Swiftstrike Bracers
                { 12, 32747 }, -- Pattern: Swiftstrike Shoulders
                { 16, 32754 }, -- Pattern: Bracers of Nimble Thought
                { 17, 32755 }, -- Pattern: Mantle of Nimble Thought
                { 18, 32753 }, -- Pattern: Swiftheal Mantle
                { 19, 32752 }, -- Pattern: Swiftheal Wraps
            }
        },
        T6_SET
    }
}