-- $Id: Atlas_BurningCrusade-enUS.lua 79 2023-03-20 14:56:15Z arithmandar $
--[[

	Atlas, a World of Warcraft instance map browser
	Copyright 2005 ~ 2010 - Dan Gilbert <dan.b.gilbert@gmail.com>
	Copyright 2010 - Lothaer <lothayer@gmail.com>, Atlas Team
	Copyright 2011 ~ 2023 - Arith Hsu, Atlas Team <atlas.addon at gmail dot com>

	This file is part of Atlas.

	Atlas is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Atlas is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Atlas; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

--]]

local AceLocale = LibStub:GetLibrary("AceLocale-3.0");
local L = AceLocale:NewLocale("Atlas_BurningCrusade", "enUS", true, true);

if L then
L["\"Captain\" Kaftiz"] = "\"Captain\" Kaftiz"
L["\"Slim\" <Shady Dealer>"] = "\"Slim\" <Shady Dealer>"
L["Abbendis"] = "Abbendis"
L["AC"] = "AC"
L["Advance Scout Chadwick"] = "Advance Scout Chadwick"
L["Aged Dalaran Wizard"] = "Aged Dalaran Wizard"
L["Al'ar"] = "Al'ar"
L["Alexston Chrome <Tavern of Time>"] = "Alexston Chrome <Tavern of Time>"
L["Alurmi <Keepers of Time Quartermaster>"] = "Alurmi <Keepers of Time Quartermaster>"
L["Aluyen <Reagents>"] = "Aluyen <Reagents>"
L["Alyson Antille"] = "Alyson Antille"
L["Ambassador Hellmaw"] = "Ambassador Hellmaw"
L["Ambassador Pax'ivi"] = "Ambassador Pax'ivi"
L["Anachronos <Keepers of Time>"] = "Anachronos <Keepers of Time>"
L["Andormu <Keepers of Time>"] = "Andormu <Keepers of Time>"
L["Anzu"] = "Anzu"
L["Apoko"] = "Apoko"
L["Apprentice Darius"] = "Apprentice Darius"
L["Arazmodu <The Scale of Sands>"] = "Arazmodu <The Scale of Sands>"
L["Arca"] = "Arca"
L["Archmage Alturus"] = "Archmage Alturus"
L["Archmage Leryda"] = "Archmage Leryda"
L["Arinoth"] = "Arinoth"
L["Artificer Morphalius"] = "Artificer Morphalius"
L["Attumen the Huntsman"] = "Attumen the Huntsman"
L["Auch"] = "Auch"
L["Avatar of the Martyred"] = "Avatar of the Martyred"
L["Bakkalzu"] = "Bakkalzu"
L["Barkeep Kelly <Bartender>"] = "Barkeep Kelly <Bartender>"
L["Barnes <The Stage Manager>"] = "Barnes <The Stage Manager>"
L["Baron Rafe Dreuger"] = "Baron Rafe Dreuger"
L["Baroness Dorothea Millstipe"] = "Baroness Dorothea Millstipe"
L["Bennett <The Sergeant at Arms>"] = "Bennett <The Sergeant at Arms>"
L["Berthold <The Doorman>"] = "Berthold <The Doorman>"
L["BF"] = "BF"
L["Bilger the Straight-laced"] = "Bilger the Straight-laced"
L["Blackheart the Inciter"] = "Blackheart the Inciter"
L["Blindeye the Seer"] = "Blindeye the Seer"
L["Blood Guard Hakkuz <Darkspear Elite>"] = "Blood Guard Hakkuz <Darkspear Elite>"
L["Blood Guard Porung"] = "Blood Guard Porung"
L["Bortega <Reagents & Poison Supplies>"] = "Bortega <Reagents & Poison Supplies>"
L["Bota"] = "Bota"
L["Brazen"] = "Brazen"
L["Broggok"] = "Broggok"
L["Broken Stairs"] = "Broken Stairs"
L["Brutallus"] = "Brutallus"
L["BT"] = "BT"
L["Cache of the Legion"] = "Cache of the Legion"
L["Calliard <The Nightman>"] = "Calliard <The Nightman>"
L["Captain Alina"] = "Captain Alina"
L["Captain Boneshatter"] = "Captain Boneshatter"
L["Captain Edward Hanes"] = "Captain Edward Hanes"
L["Captain Sanders"] = "Captain Sanders"
L["Caza'rez"] = "Caza'rez"
L["Charred Bone Fragment"] = "Charred Bone Fragment"
L["Chef Jessen <Speciality Meat & Slop>"] = "Chef Jessen <Speciality Meat & Slop>"
L["Chess Event"] = "Chess Event"
L["Clarissa"] = "Clarissa"
L["Commander Mograine"] = "Commander Mograine"
L["Commander Sarannis"] = "Commander Sarannis"
L["Connection to Master's Terrace (Nightbane)"] = "Connection to Master's Terrace (Nightbane)"
L["CoT"] = "CoT"
L["CoT1"] = "CoT1"
L["CoT2"] = "CoT2"
L["CoT3"] = "CoT3"
L["CR"] = "CR"
L["Cryo-Engineer Sha'heen"] = "Cryo-Engineer Sha'heen"
L["Dalliah the Doomsayer"] = "Dalliah the Doomsayer"
L["Darkheart"] = "Darkheart"
L["Darkweaver Syth"] = "Darkweaver Syth"
L["Dealer Tariq <Shady Dealer>"] = "Dealer Tariq <Shady Dealer>"
L["Dealer Vijaad"] = "Dealer Vijaad"
L["Don Carlos"] = "Don Carlos"
L["D'ore"] = "D'ore"
L["Dorothee"] = "Dorothee"
L["Draenei Spirit"] = "Draenei Spirit"
L["Drisella"] = "Drisella"
L["Dust Covered Chest"] = "Dust Covered Chest"
L["Earthbinder Rayge"] = "Earthbinder Rayge"
L["Ebonlocke <The Noble>"] = "Ebonlocke <The Noble>"
L["Echo of Medivh"] = "Echo of Medivh"
L["Ellrys Duskhallow"] = "Ellrys Duskhallow"
L["Entropius"] = "Entropius"
L["Eramas Brightblaze"] = "Eramas Brightblaze"
L["Erozion"] = "Erozion"
L["Essence of Anger"] = "Essence of Anger"
L["Essence of Desire"] = "Essence of Desire"
L["Essence of Suffering"] = "Essence of Suffering"
L["Ethereal Transporter Control Panel"] = "Ethereal Transporter Control Panel"
L["Eulinda <Reagents>"] = "Eulinda <Reagents>"
L["Exarch Larethor"] = "Exarch Larethor"
L["Exarch Maladaar"] = "Exarch Maladaar"
L["Fairbanks"] = "Fairbanks"
L["Farmer Kent"] = "Farmer Kent"
L["Fathom-Lord Karathress"] = "Fathom-Lord Karathress"
L["Fel Crystals"] = "Fel Crystals"
L["Felmyst"] = "Felmyst"
L["Fenstalker"] = "Fenstalker"
L["Field Commander Mahfuun"] = "Field Commander Mahfuun"
L["First Fragment Guardian"] = "First Fragment Guardian"
L["Fizzle"] = "Fizzle"
L["Forest Frogs"] = "Forest Frogs"
L["Frances Lin <Barmaid>"] = "Frances Lin <Barmaid>"
L["Galgrom <Provisioner>"] = "Galgrom <Provisioner>"
L["Garaxxas"] = "Garaxxas"
L["Gatewatcher Gyro-Kill"] = "Gatewatcher Gyro-Kill"
L["Gatewatcher Iron-Hand"] = "Gatewatcher Iron-Hand"
L["Gathios the Shatterer"] = "Gathios the Shatterer"
L["Gazakroth"] = "Gazakroth"
L["GL"] = "GL"
L["Gradav <The Warlock>"] = "Gradav <The Warlock>"
L["Grand Astromancer Capernian"] = "Grand Astromancer Capernian"
L["Grand Warlock Alythess"] = "Grand Warlock Alythess"
L["Grand Warlock Nethekurse"] = "Grand Warlock Nethekurse"
L["Grandmaster Vorpil"] = "Grandmaster Vorpil"
L["Greatfather Aldrimus"] = "Greatfather Aldrimus"
L["Gruul the Dragonkiller"] = "Gruul the Dragonkiller"
L["Guerrero"] = "Guerrero"
L["Gunny"] = "Gunny"
L["Gurtogg Bloodboil"] = "Gurtogg Bloodboil"
L["Hal McAllister"] = "Hal McAllister"
L["Ha'lei"] = "Ha'lei"
L["Harald <Food Vendor>"] = "Harald <Food Vendor>"
L["Harbinger Skyriss"] = "Harbinger Skyriss"
L["Hastings <The Caretaker>"] = "Hastings <The Caretaker>"
L["Hazlek"] = "Hazlek"
L["HC"] = "HC"
L["Helcular"] = "Helcular"
L["Herod the Bully"] = "Herod the Bully"
L["High Astromancer Solarian"] = "High Astromancer Solarian"
L["High Botanist Freywinn"] = "High Botanist Freywinn"
L["High King Maulgar"] = "High King Maulgar"
L["High Nethermancer Zerevor"] = "High Nethermancer Zerevor"
L["High Warlord Naj'entus"] = "High Warlord Naj'entus"
L["Horvon the Armorer <Armorsmith>"] = "Horvon the Armorer <Armorsmith>"
L["Hyakiss the Lurker"] = "Hyakiss the Lurker"
L["Hydromancer Thespia"] = "Hydromancer Thespia"
L["Hydross the Unstable"] = "Hydross the Unstable"
L["Illidan Stormrage"] = "Illidan Stormrage"
L["Indormi <Keeper of Ancient Gem Lore>"] = "Indormi <Keeper of Ancient Gem Lore>"
L["Innkeeper Monica"] = "Innkeeper Monica"
L["Isfar"] = "Isfar"
L["Isillien"] = "Isillien"
L["Jay Lemieux"] = "Jay Lemieux"
L["Jerry Carter"] = "Jerry Carter"
L["Jonathan Revah"] = "Jonathan Revah"
L["Julianne"] = "Julianne"
L["Julie Honeywell"] = "Julie Honeywell"
L["Kael'thas Sunstrider"] = "Kael'thas Sunstrider"
L["Kagani Nightstrike"] = "Kagani Nightstrike"
L["Kaldrick"] = "Kaldrick"
L["Kalecgos"] = "Kalecgos"
L["Kamsis <The Conjurer>"] = "Kamsis <The Conjurer>"
L["Kara"] = "Kara"
L["Kasha"] = "Kasha"
L["Keanna's Log"] = "Keanna's Log"
L["Keli'dan the Breaker"] = "Keli'dan the Breaker"
L["Kiggler the Crazed"] = "Kiggler the Crazed"
L["Kil'jaeden"] = "Kil'jaeden"
L["Kil'rek"] = "Kil'rek"
L["Korag Proudmane"] = "Korag Proudmane"
L["Koragg"] = "Koragg"
L["Koren <The Blacksmith>"] = "Koren <The Blacksmith>"
L["Krosh Firehand"] = "Krosh Firehand"
L["Lady Catriona Von'Indi"] = "Lady Catriona Von'Indi"
L["Lady Jaina Proudmoore"] = "Lady Jaina Proudmoore"
L["Lady Keira Berrybuck"] = "Lady Keira Berrybuck"
L["Lady Malande"] = "Lady Malande"
L["Lady Sacrolash"] = "Lady Sacrolash"
L["Lady Vashj"] = "Lady Vashj"
L["Laj"] = "Laj"
L["Lakka"] = "Lakka"
L["Landing Spot"] = "Landing Spot"
L["Lenzo"] = "Lenzo"
L["Leotheras the Blind"] = "Leotheras the Blind"
L["Little Jimmy Vishas"] = "Little Jimmy Vishas"
L["Lord Crispin Ference"] = "Lord Crispin Ference"
L["Lord Raadan"] = "Lord Raadan"
L["Lord Robin Daris"] = "Lord Robin Daris"
L["Lord Sanguinar"] = "Lord Sanguinar"
L["Lydia Accoste"] = "Lydia Accoste"
L["Madrigosa"] = "Madrigosa"
L["Mag"] = "Mag"
L["Magistrate Henry Maleb"] = "Magistrate Henry Maleb"
L["Magtheridon"] = "Magtheridon"
L["Maiden of Virtue"] = "Maiden of Virtue"
L["Main Chambers Access Panel"] = "Main Chambers Access Panel"
L["Mamdy the \"Ologist\""] = "Mamdy the \"Ologist\""
L["Master Engineer Telonicus"] = "Master Engineer Telonicus"
L["MaT"] = "MT"
L["Mawago"] = "Mawago"
L["Mech"] = "Mech"
L["Mechano-Lord Capacitus"] = "Mechano-Lord Capacitus"
L["Meeting Stone of Hellfire Citadel"] = "Meeting Stone of Hellfire Citadel"
L["Meeting Stone of Magtheridon's Lair"] = "Meeting Stone of Magtheridon's Lair"
L["Mekgineer Steamrigger"] = "Mekgineer Steamrigger"
L["Melasong"] = "Melasong"
L["Melissa"] = "Melissa"
L["Mennu the Betrayer"] = "Mennu the Betrayer"
L["Micah"] = "Micah"
L["Midnight"] = "Midnight"
L["Millhouse Manastorm"] = "Millhouse Manastorm"
L["Monk"] = "Monk"
L["Moroes"] = "Moroes"
L["Morogrim Tidewalker"] = "Morogrim Tidewalker"
L["Mortog Steamhead"] = "Mortog Steamhead"
L["Mother Shahraz"] = "Mother Shahraz"
L["MT"] = "MT"
L["Murmur"] = "Murmur"
L["M'uru"] = "M'uru"
L["Mysterious Bookshelf"] = "Mysterious Bookshelf"
L["Nahuud"] = "Nahuud"
L["Nat Pagle"] = "Nat Pagle"
L["Nathanos Marris"] = "Nathanos Marris"
L["Naturalist Bite"] = "Naturalist Bite"
L["Nazan"] = "Nazan"
L["Nethermancer Sepethrea"] = "Nethermancer Sepethrea"
L["Netherspite"] = "Netherspite"
L["Nexus-Prince Haramad"] = "Nexus-Prince Haramad"
L["Nexus-Prince Shaffar"] = "Nexus-Prince Shaffar"
L["Nightbane"] = "Nightbane"
L["Norkani"] = "Norkani"
L["Nozari <Keepers of Time>"] = "Nozari <Keepers of Time>"
L["Okuno <Ashtongue Deathsworn Quartermaster>"] = "Okuno <Ashtongue Deathsworn Quartermaster>"
L["Olm the Summoner"] = "Olm the Summoner"
L["Omor the Unscarred"] = "Omor the Unscarred"
L["Opera Hall"] = "Opera Hall"
L["Overcharged Manacell"] = "Overcharged Manacell"
L["Overwatch Mark 0 <Protector>"] = "Overwatch Mark 0 <Protector>"
L["Pandemonius"] = "Pandemonius"
L["Path to the Broken Stairs"] = "Path to the Broken Stairs"
L["Path to the Hellfire Ramparts and Shattered Halls"] = "Path to the Hellfire Ramparts and Shattered Halls"
L["Pathaleon the Calculator"] = "Pathaleon the Calculator"
L["Phin Odelic <The Kirin Tor>"] = "Phin Odelic <The Kirin Tor>"
L["Priestess Delrissa"] = "Priestess Delrissa"
L["Prince Malchezaar"] = "Prince Malchezaar"
L["Private Jacint"] = "Private Jacint"
L["Provisioner Tsaalt"] = "Provisioner Tsaalt"
L["Quagmirran"] = "Quagmirran"
L["Raleigh the True"] = "Raleigh the True"
L["Ramdor the Mad"] = "Ramdor the Mad"
L["Ramp"] = "Ramp"
L["Ramp down to the Gamesman's Hall"] = "Ramp down to the Gamesman's Hall"
L["Ramp from Mezzanine to Balcony"] = "Ramp from Mezzanine to Balcony"
L["Ramp to Guardian's Library"] = "Ramp to Guardian's Library"
L["Ramp to Medivh's Chamber"] = "Ramp to Medivh's Chamber"
L["Ramp to the Guest Chambers (Maiden)"] = "Ramp to the Guest Chambers (Maiden)"
L["Ramp up to the Celestial Watch"] = "Ramp up to the Celestial Watch"
L["Randy Whizzlesprocket"] = "Randy Whizzlesprocket"
L["Red Riding Hood"] = "Red Riding Hood"
L["Reinforced Fel Iron Chest"] = "Reinforced Fel Iron Chest"
L["Reliquary of Souls"] = "Reliquary of Souls"
L["Relissa"] = "Relissa"
L["Renault Mograine"] = "Renault Mograine"
L["Rifleman Brownbeard"] = "Rifleman Brownbeard"
L["Roar"] = "Roar"
L["Rokad the Ravager"] = "Rokad the Ravager"
L["Rokmar the Crackler"] = "Rokmar the Crackler"
L["Romulo"] = "Romulo"
L["Romulo & Julianne"] = "Romulo & Julianne"
L["Rosa"] = "Rosa"
L["Sa'at <Keepers of Time>"] = "Sa'at <Keepers of Time>"
L["Sally Whitemane"] = "Sally Whitemane"
L["Sathrovarr the Corruptor"] = "Sathrovarr the Corruptor"
L["Scout Orgarr"] = "Scout Orgarr"
L["Scrying Orb"] = "Scrying Orb"
L["Sebastian <The Organist>"] = "Sebastian <The Organist>"
L["Second Fragment Guardian"] = "Second Fragment Guardian"
L["Seer Kanai"] = "Seer Kanai"
L["Seer Olum"] = "Seer Olum"
L["Selin Fireheart"] = "Selin Fireheart"
L["Servant Quarters"] = "Servant Quarters"
L["Seth"] = "Seth"
L["SH"] = "SH"
L["Shade of Akama"] = "Shade of Akama"
L["Shade of Aran"] = "Shade of Aran"
L["Shadikith the Glider"] = "Shadikith the Glider"
L["Shadow Lord Xiraxis"] = "Shadow Lord Xiraxis"
L["Shattered Hand Executioner"] = "Shattered Hand Executioner"
L["Shirrak the Dead Watcher"] = "Shirrak the Dead Watcher"
L["Skar'this the Heretic"] = "Skar'this the Heretic"
L["SL"] = "SL"
L["Slither"] = "Slither"
L["Sliver <Garaxxas' Pet>"] = "Sliver <Garaxxas' Pet>"
L["Soridormi <The Scale of Sands>"] = "Soridormi <The Scale of Sands>"
L["Southshore Inn"] = "Southshore Inn"
L["SP"] = "SP"
L["Spiral Stairs to Netherspace"] = "Spiral Stairs to Netherspace"
L["Spirit of Olum"] = "Spirit of Olum"
L["Spirit of Udalo"] = "Spirit of Udalo"
L["Spy Grik'tha"] = "Spy Grik'tha"
L["Spy To'gun"] = "Spy To'gun"
L["SSC"] = "SSC"
L["Staircase to the Ballroom (Moroes)"] = "Staircase to the Ballroom (Moroes)"
L["Stairs to Opera House Orchestra Level"] = "Stairs to Opera House Orchestra Level"
L["Stairs to Underground Pond"] = "Stairs to Underground Pond"
L["Stairs to Underground Well"] = "Stairs to Underground Well"
L["Stairs to Upper Stable"] = "Stairs to Upper Stable"
L["Stalvan Mistmantle"] = "Stalvan Mistmantle"
L["Steps and path to the Blood Furnace"] = "Steps and path to the Blood Furnace"
L["Steward of Time <Keepers of Time>"] = "Steward of Time <Keepers of Time>"
L["Stone Guard Stok'ton"] = "Stone Guard Stok'ton"
L["Strawman"] = "Strawman"
L["SuP"] = "SP"
L["Supremus"] = "Supremus"
L["SV"] = "SV"
L["Taelan"] = "Taelan"
L["Talon King Ikiss"] = "Talon King Ikiss"
L["Taretha"] = "Taretha"
L["Tavarok"] = "Tavarok"
L["Terestian Illhoof"] = "Terestian Illhoof"
L["Teron Gorefiend"] = "Teron Gorefiend"
L["Thaladred the Darkener"] = "Thaladred the Darkener"
L["The Big Bad Wolf"] = "The Big Bad Wolf"
L["The Codex of Blood"] = "The Codex of Blood"
L["The Crone"] = "The Crone"
L["The Curator"] = "The Curator"
L["The Eredar Twins"] = "The Eredar Twins"
L["The Illidari Council"] = "The Illidari Council"
L["The Lurker Below"] = "The Lurker Below"
L["The Maker"] = "The Maker"
L["The Map of Zul'Aman"] = "The Map of Zul'Aman"
L["The Master's Terrace"] = "The Master's Terrace"
L["The Saga of Terokk"] = "The Saga of Terokk"
L["The Underspore"] = "The Underspore"
L["Third Fragment Guardian"] = "Third Fragment Guardian"
L["Thomas Yance <Travelling Salesman>"] = "Thomas Yance <Travelling Salesman>"
L["Thorngrin the Tender"] = "Thorngrin the Tender"
L["Thrall"] = "Thrall"
L["Thrall <Warchief>"] = "Thrall <Warchief>"
L["Thurg"] = "Thurg"
L["Tinhead"] = "Tinhead"
L["Tito"] = "Tito"
L["TK"] = "TK"
L["Tormented Soulpriest"] = "Tormented Soulpriest"
L["Towards Illidan Stormrage"] = "Towards Illidan Stormrage"
L["Towards Reliquary of Souls"] = "Towards Reliquary of Souls"
L["Towards Teron Gorefiend"] = "Towards Teron Gorefiend"
L["T'shu"] = "T'shu"
L["Tydormu <Keeper of Lost Artifacts>"] = "Tydormu <Keeper of Lost Artifacts>"
L["Tyllan"] = "Tyllan"
L["Tyrande Whisperwind <High Priestess of Elune>"] = "Tyrande Whisperwind <High Priestess of Elune>"
L["Tyrith"] = "Tyrith"
L["UB"] = "UB"
L["Udalo"] = "Udalo"
L["Vazruden the Herald"] = "Vazruden the Herald"
L["Veras Darkshadow"] = "Veras Darkshadow"
L["Vexallus"] = "Vexallus"
L["Void Reaver"] = "Void Reaver"
L["Vol'jin"] = "Vol'jin"
L["Voodoo Pile"] = "Voodoo Pile"
L["Warbringer O'mrogg"] = "Warbringer O'mrogg"
L["Warchief Kargath Bladefist"] = "Warchief Kargath Bladefist"
L["Warden Mellichar"] = "Warden Mellichar"
L["Warlord Kalithresh"] = "Warlord Kalithresh"
L["Warlord Salaris"] = "Warlord Salaris"
L["Warp Splinter"] = "Warp Splinter"
L["Watcher Jhang"] = "Watcher Jhang"
L["Watchkeeper Gargolmar"] = "Watchkeeper Gargolmar"
L["Weeder Greenthumb"] = "Weeder Greenthumb"
L["Windcaller Claw"] = "Windcaller Claw"
L["Witch Doctor T'wansi"] = "Witch Doctor T'wansi"
L["Wizard of Oz"] = "Wizard of Oz"
L["Wrath-Scryer Soccothrates"] = "Wrath-Scryer Soccothrates"
L["Wravien <The Mage>"] = "Wravien <The Mage>"
L["Yarley <Armorer>"] = "Yarley <Armorer>"
L["Yazzai"] = "Yazzai"
L["Yor"] = "Yor"
L["Young Blanchy"] = "Young Blanchy"
L["Ythyar"] = "Ythyar"
L["Zaladormu"] = "Zaladormu"
L["Zelfan"] = "Zelfan"
L["Zereketh the Unbound"] = "Zereketh the Unbound"
L["Zixil <Aspiring Merchant>"] = "Zixil <Aspiring Merchant>"
L["Zungam"] = "Zungam"

--************************************************
-- Zone Names, Acronyms, and Common Strings
--************************************************
	--BC Acronyms
	L["AC"] = "AC"; -- Auchenai Crypts
	L["Arca"] = "Arca"; -- The Arcatraz
	L["Auch"] = "Auch"; -- Auchindoun
	L["BF"] = "BF"; -- The Blood Furnace
	L["BT"] = "BT"; -- Black Temple
	L["Bota"] = "Bota"; -- The Botanica
	L["CoT"] = "CoT"; -- Caverns of Time
	L["CoT1"] = "CoT1"; -- Old Hillsbrad Foothills
	L["CoT2"] = "CoT2"; -- The Black Morass
	L["CoT3"] = "CoT3"; -- Hyjal Summit
	L["CR"] = "CR"; -- Coilfang Reservoir
	L["GL"] = "GL"; -- Gruul's Lair
	L["HC"] = "HC"; -- Hellfire Citadel
	L["Kara"] = "Kara"; -- Karazhan
	L["MaT"] = "MT"; -- Magisters' Terrace
	L["Mag"] = "Mag"; -- Magtheridon's Lair
	L["Mech"] = "Mech"; -- The Mechanar
	L["MT"] = "MT"; -- Mana-Tombs
	L["Ramp"] = "Ramp"; -- Hellfire Ramparts
	L["SSC"] = "SSC"; -- Serpentshrine Cavern
	L["Seth"] = "Seth"; -- Sethekk Halls
	L["SH"] = "SH"; -- The Shattered Halls
	L["SL"] = "SL"; -- Shadow Labyrinth
	L["SP"] = "SP"; -- The Slave Pens
	L["SuP"] = "SP"; -- Sunwell Plateau
	L["SV"] = "SV"; -- The Steamvault
	L["TK"] = "TK"; -- Tempest Keep
	L["UB"] = "UB"; -- The Underbog

--*******************
-- Burning Crusade Instances
--*******************

	L["Monk"] = "Monk";

	--Auchindoun (Entrance)
	L["Clarissa"] = "Clarissa";
	L["Greatfather Aldrimus"] = "Greatfather Aldrimus";
	L["Ha'lei"] = "Ha'lei";
	L["Horvon the Armorer <Armorsmith>"] = "Horvon the Armorer <Armorsmith>";
	L["Ramdor the Mad"] = "Ramdor the Mad";
	L["Nexus-Prince Haramad"] = "Nexus-Prince Haramad";
	L["\"Slim\" <Shady Dealer>"] = "\"Slim\" <Shady Dealer>";
	L["\"Captain\" Kaftiz"] = "\"Captain\" Kaftiz";
	L["Dealer Tariq <Shady Dealer>"] = "Dealer Tariq <Shady Dealer>";
	L["Provisioner Tsaalt"] = "Provisioner Tsaalt";

	--Auch: Auchenai Crypts
	L["Draenei Spirit"] = "Draenei Spirit";
	L["Avatar of the Martyred"] = "Avatar of the Martyred";
	L["D'ore"] = "D'ore";
	L["Tormented Soulpriest"] = "Tormented Soulpriest";
	L["Shirrak the Dead Watcher"] = "Shirrak the Dead Watcher"
	L["Exarch Maladaar"] = "Exarch Maladaar"

	--Auch: Mana-Tombs
	L["Artificer Morphalius"] = "Artificer Morphalius";
	L["Mamdy the \"Ologist\""] = "Mamdy the \"Ologist\"";
	L["Shadow Lord Xiraxis"] = "Shadow Lord Xiraxis";
	L["Ambassador Pax'ivi"] = "Ambassador Pax'ivi";
	L["Cryo-Engineer Sha'heen"] = "Cryo-Engineer Sha'heen";
	L["Ethereal Transporter Control Panel"] = "Ethereal Transporter Control Panel";
	L["Pandemonius"] = "Pandemonius"
	L["Tavarok"] = "Tavarok"
	L["Nexus-Prince Shaffar"] = "Nexus-Prince Shaffar"
	L["Yor"] = "Yor"

	--Auch: Sethekk Halls
	L["Isfar"] = "Isfar";
	L["Dealer Vijaad"] = "Dealer Vijaad";
	L["Lakka"] = "Lakka";
	L["The Saga of Terokk"] = "The Saga of Terokk";
	L["Darkweaver Syth"] = "Darkweaver Syth"
	L["Anzu"] = "Anzu"
	L["Talon King Ikiss"] = "Talon King Ikiss"

	--Auch: Shadow Labyrinth
	L["Field Commander Mahfuun"] = "Field Commander Mahfuun";
	L["Spy Grik'tha"] = "Spy Grik'tha";
	L["The Codex of Blood"] = "The Codex of Blood";
	L["First Fragment Guardian"] = "First Fragment Guardian";
	L["Spy To'gun"] = "Spy To'gun";
	L["Ambassador Hellmaw"] = "Ambassador Hellmaw"
	L["Blackheart the Inciter"] = "Blackheart the Inciter"
	L["Grandmaster Vorpil"] = "Grandmaster Vorpil"
	L["Murmur"] = "Murmur"

	--Black Temple (Start)
	L["Towards Reliquary of Souls"] = "Towards Reliquary of Souls";
	L["Towards Teron Gorefiend"] = "Towards Teron Gorefiend";
	L["Towards Illidan Stormrage"] = "Towards Illidan Stormrage";
	L["Spirit of Olum"] = "Spirit of Olum";
	L["Spirit of Udalo"] = "Spirit of Udalo";
	L["Aluyen <Reagents>"] = "Aluyen <Reagents>";
	L["Okuno <Ashtongue Deathsworn Quartermaster>"] = "Okuno <Ashtongue Deathsworn Quartermaster>";
	L["Seer Kanai"] = "Seer Kanai";
	L["High Warlord Naj'entus"] = "High Warlord Naj'entus"
	L["Supremus"] = "Supremus"
	L["Shade of Akama"] = "Shade of Akama"

	--Black Temple (Basement)
	L["Gurtogg Bloodboil"] = "Gurtogg Bloodboil"
	L["Reliquary of Souls"] = "Reliquary of Souls"
	L["Essence of Suffering"] = "Essence of Suffering"
	L["Essence of Desire"] = "Essence of Desire"
	L["Essence of Anger"] = "Essence of Anger"
	L["Teron Gorefiend"] = "Teron Gorefiend"

	--Black Temple (Top)
	L["Mother Shahraz"] = "Mother Shahraz"
	L["The Illidari Council"] = "The Illidari Council"
	L["Gathios the Shatterer"] = "Gathios the Shatterer"
	L["High Nethermancer Zerevor"] = "High Nethermancer Zerevor"
	L["Lady Malande"] = "Lady Malande"
	L["Veras Darkshadow"] = "Veras Darkshadow"
	L["Illidan Stormrage"] = "Illidan Stormrage"

	--Coilfang Reservoir (Entrance)
	L["Mortog Steamhead"] = "Mortog Steamhead";

	--CFR: Serpentshrine Cavern
	L["Seer Olum"] = "Seer Olum";
	L["Hydross the Unstable"] = "Hydross the Unstable"
	L["The Lurker Below"] = "The Lurker Below"
	L["Leotheras the Blind"] = "Leotheras the Blind"
	L["Fathom-Lord Karathress"] = "Fathom-Lord Karathress"
	L["Morogrim Tidewalker"] = "Morogrim Tidewalker"
	L["Lady Vashj"] = "Lady Vashj"

	--CFR: The Slave Pens
	L["Nahuud"] = "Nahuud";
	L["Watcher Jhang"] = "Watcher Jhang";
	L["Weeder Greenthumb"] = "Weeder Greenthumb";
	L["Skar'this the Heretic"] = "Skar'this the Heretic";
	L["Naturalist Bite"] = "Naturalist Bite";
	L["Mennu the Betrayer"] = "Mennu the Betrayer"
	L["Rokmar the Crackler"] = "Rokmar the Crackler"
	L["Quagmirran"] = "Quagmirran"

	--CFR: The Steamvault
	L["Windcaller Claw"] = "Windcaller Claw";
	L["Main Chambers Access Panel"] = "Main Chambers Access Panel";
	L["Second Fragment Guardian"] = "Second Fragment Guardian";
	L["Hydromancer Thespia"] = "Hydromancer Thespia"
	L["Mekgineer Steamrigger"] = "Mekgineer Steamrigger"
	L["Warlord Kalithresh"] = "Warlord Kalithresh"

	--CFR: The Underbog
	L["T'shu"] = "T'shu";
	L["The Underspore"] = "The Underspore";
	L["Earthbinder Rayge"] = "Earthbinder Rayge";
	L["Hungarfen"] = "Hungarfen"
	L["Ghaz'an"] = "Ghaz'an"
	L["Swamplord Musel'ek"] = "Swamplord Musel'ek"
	L["Claw"] = "Claw"
	L["The Black Stalker"] = "The Black Stalker"

	--Caverns of Time Entrance
	L["Steward of Time <Keepers of Time>"] = "Steward of Time <Keepers of Time>"
	L["Alexston Chrome <Tavern of Time>"] = "Alexston Chrome <Tavern of Time>"
	L["Yarley <Armorer>"] = "Yarley <Armorer>"
	L["Bortega <Reagents & Poison Supplies>"] = "Bortega <Reagents & Poison Supplies>"
	L["Alurmi <Keepers of Time Quartermaster>"] = "Alurmi <Keepers of Time Quartermaster>"
	L["Galgrom <Provisioner>"] = "Galgrom <Provisioner>"
	L["Zaladormu"] = "Zaladormu"
	L["Soridormi <The Scale of Sands>"] = "Soridormi <The Scale of Sands>"
	L["Arazmodu <The Scale of Sands>"] = "Arazmodu <The Scale of Sands>"
	L["Andormu <Keepers of Time>"] = "Andormu <Keepers of Time>"
	L["Nozari <Keepers of Time>"] = "Nozari <Keepers of Time>"
	L["Anachronos <Keepers of Time>"] = "Anachronos <Keepers of Time>"
	
	--Caverns of Time: Hyjal (Entrance)
	L["Indormi <Keeper of Ancient Gem Lore>"] = "Indormi <Keeper of Ancient Gem Lore>";
	L["Tydormu <Keeper of Lost Artifacts>"] = "Tydormu <Keeper of Lost Artifacts>";

	--CoT: The Black Morass
	L["Sa'at <Keepers of Time>"] = "Sa'at <Keepers of Time>";

	--CoT: Hyjal Summit
	L["Lady Jaina Proudmoore"] = "Lady Jaina Proudmoore";
	L["Thrall <Warchief>"] = "Thrall <Warchief>";
	L["Tyrande Whisperwind <High Priestess of Elune>"] = "Tyrande Whisperwind <High Priestess of Elune>";

	--CoT: Old Hillsbrad Foothills
	L["Erozion"] = "Erozion";
	L["Brazen"] = "Brazen";
	L["Landing Spot"] = "Landing Spot";
	L["Thrall"] = "Thrall";
	L["Taretha"] = "Taretha";
	L["Don Carlos"] = "Don Carlos";
	L["Guerrero"] = "Guerrero";
	L["Thomas Yance <Travelling Salesman>"] = "Thomas Yance <Travelling Salesman>";
	L["Aged Dalaran Wizard"] = "Aged Dalaran Wizard";
	L["Jonathan Revah"] = "Jonathan Revah";
	L["Jerry Carter"] = "Jerry Carter";
	L["Helcular"] = "Helcular";
	L["Farmer Kent"] = "Farmer Kent";
	L["Sally Whitemane"] = "Sally Whitemane";
	L["Renault Mograine"] = "Renault Mograine";
	L["Little Jimmy Vishas"] = "Little Jimmy Vishas";
	L["Herod the Bully"] = "Herod the Bully";
	L["Nat Pagle"] = "Nat Pagle";
	L["Hal McAllister"] = "Hal McAllister";
	L["Zixil <Aspiring Merchant>"] = "Zixil <Aspiring Merchant>";
	L["Overwatch Mark 0 <Protector>"] = "Overwatch Mark 0 <Protector>";
	L["Southshore Inn"] = "Southshore Inn";
	L["Captain Edward Hanes"] = "Captain Edward Hanes";
	L["Captain Sanders"] = "Captain Sanders";
	L["Commander Mograine"] = "Commander Mograine";
	L["Isillien"] = "Isillien";
	L["Abbendis"] = "Abbendis";
	L["Fairbanks"] = "Fairbanks";
	L["Taelan"] = "Taelan";
	L["Barkeep Kelly <Bartender>"] = "Barkeep Kelly <Bartender>";
	L["Frances Lin <Barmaid>"] = "Frances Lin <Barmaid>";
	L["Chef Jessen <Speciality Meat & Slop>"] = "Chef Jessen <Speciality Meat & Slop>";
	L["Stalvan Mistmantle"] = "Stalvan Mistmantle";
	L["Phin Odelic <The Kirin Tor>"] = "Phin Odelic <The Kirin Tor>";
	L["Magistrate Henry Maleb"] = "Magistrate Henry Maleb";
	L["Raleigh the True"] = "Raleigh the True";
	L["Nathanos Marris"] = "Nathanos Marris";
	L["Bilger the Straight-laced"] = "Bilger the Straight-laced";
	L["Innkeeper Monica"] = "Innkeeper Monica";
	L["Julie Honeywell"] = "Julie Honeywell";
	L["Jay Lemieux"] = "Jay Lemieux";
	L["Young Blanchy"] = "Young Blanchy";

	--Gruul's Lair
	L["High King Maulgar"] = "High King Maulgar"
	L["Kiggler the Crazed"] = "Kiggler the Crazed"
	L["Blindeye the Seer"] = "Blindeye the Seer"
	L["Olm the Summoner"] = "Olm the Summoner"
	L["Krosh Firehand"] = "Krosh Firehand"
	L["Gruul the Dragonkiller"] = "Gruul the Dragonkiller"

	--Hellfire Citadel (Entrance)
	L["Steps and path to the Blood Furnace"] = "Steps and path to the Blood Furnace";
	L["Path to the Hellfire Ramparts and Shattered Halls"] = "Path to the Hellfire Ramparts and Shattered Halls";
	L["Meeting Stone of Magtheridon's Lair"] = "Meeting Stone of Magtheridon's Lair";
	L["Meeting Stone of Hellfire Citadel"] = "Meeting Stone of Hellfire Citadel";

	--HFC: The Blood Furnace
	L["Gunny"] = "Gunny";
	L["Caza'rez"] = "Caza'rez";
	L["The Maker"] = "The Maker"
	L["Broggok"] = "Broggok"
	L["Keli'dan the Breaker"] = "Keli'dan the Breaker"

	--HFC: Hellfire Ramparts
	L["Advance Scout Chadwick"] = "Advance Scout Chadwick";
	L["Stone Guard Stok'ton"] = "Stone Guard Stok'ton";
	L["Reinforced Fel Iron Chest"] = "Reinforced Fel Iron Chest";
	L["Watchkeeper Gargolmar"] = "Watchkeeper Gargolmar"
	L["Omor the Unscarred"] = "Omor the Unscarred"
	L["Vazruden the Herald"] = "Vazruden the Herald"
	L["Nazan"] = "Nazan"

	--HFC: Magtheridon's Lair
	L["Magtheridon"] = "Magtheridon"

	--HFC: The Shattered Halls
	L["Shattered Hand Executioner"] = "Shattered Hand Executioner";
	L["Private Jacint"] = "Private Jacint";
	L["Rifleman Brownbeard"] = "Rifleman Brownbeard";
	L["Captain Alina"] = "Captain Alina";
	L["Scout Orgarr"] = "Scout Orgarr";
	L["Korag Proudmane"] = "Korag Proudmane";
	L["Captain Boneshatter"] = "Captain Boneshatter";
	L["Randy Whizzlesprocket"] = "Randy Whizzlesprocket";
	L["Drisella"] = "Drisella";
	L["Grand Warlock Nethekurse"] = "Grand Warlock Nethekurse"
	L["Blood Guard Porung"] = "Blood Guard Porung"
	L["Warbringer O'mrogg"] = "Warbringer O'mrogg"
	L["Warchief Kargath Bladefist"] = "Warchief Kargath Bladefist"

	--Karazhan (Entrance)
	L["Archmage Leryda"] = "Archmage Leryda";
	L["Archmage Alturus"] = "Archmage Alturus";
	L["Apprentice Darius"] = "Apprentice Darius";
	L["Stairs to Underground Pond"] = "Stairs to Underground Pond";
	L["Stairs to Underground Well"] = "Stairs to Underground Well";
	L["Charred Bone Fragment"] = "Charred Bone Fragment";
	L["Lydia Accoste"] = "Lydia Accoste";

	--Karazhan Start
	L["Staircase to the Ballroom (Moroes)"] = "Staircase to the Ballroom (Moroes)"
	L["Stairs to Upper Stable"] = "Stairs to Upper Stable"
	L["Ramp to the Guest Chambers (Maiden)"] = "Ramp to the Guest Chambers (Maiden)"
	L["Stairs to Opera House Orchestra Level"] = "Stairs to Opera House Orchestra Level"
	L["Ramp from Mezzanine to Balcony"] = "Ramp from Mezzanine to Balcony"
	L["Connection to Master's Terrace (Nightbane)"] = "Connection to Master's Terrace (Nightbane)"
	L["Path to the Broken Stairs"] = "Path to the Broken Stairs"
	L["Baroness Dorothea Millstipe"] = "Baroness Dorothea Millstipe";
	L["Lady Catriona Von'Indi"] = "Lady Catriona Von'Indi";
	L["Lady Keira Berrybuck"] = "Lady Keira Berrybuck";
	L["Baron Rafe Dreuger"] = "Baron Rafe Dreuger";
	L["Lord Robin Daris"] = "Lord Robin Daris";
	L["Lord Crispin Ference"] = "Lord Crispin Ference";
	L["Red Riding Hood"] = "Red Riding Hood";
	L["Wizard of Oz"] = "Wizard of Oz";
	L["The Master's Terrace"] = "The Master's Terrace";
	L["Servant Quarters"] = "Servant Quarters";
	L["Hastings <The Caretaker>"] = "Hastings <The Caretaker>";
	L["Berthold <The Doorman>"] = "Berthold <The Doorman>";
	L["Calliard <The Nightman>"] = "Calliard <The Nightman>";
	L["Koren <The Blacksmith>"] = "Koren <The Blacksmith>";
	L["Bennett <The Sergeant at Arms>"] = "Bennett <The Sergeant at Arms>";
	L["Keanna's Log"] = "Keanna's Log";
	L["Ebonlocke <The Noble>"] = "Ebonlocke <The Noble>";
	L["Sebastian <The Organist>"] = "Sebastian <The Organist>";
	L["Barnes <The Stage Manager>"] = "Barnes <The Stage Manager>";
	L["Rokad the Ravager"] = "Rokad the Ravager"
	L["Shadikith the Glider"] = "Shadikith the Glider"
	L["Hyakiss the Lurker"] = "Hyakiss the Lurker"
	L["Attumen the Huntsman"] = "Attumen the Huntsman"
	L["Midnight"] = "Midnight"
	L["Moroes"] = "Moroes"
	L["Maiden of Virtue"] = "Maiden of Virtue"
	L["Opera Hall"] = "Opera Hall"
	L["The Big Bad Wolf"] = "The Big Bad Wolf"
	L["Dorothee"] = "Dorothee"
	L["Tito"] = "Tito"
	L["Strawman"] = "Strawman"
	L["Tinhead"] = "Tinhead"
	L["Roar"] = "Roar"
	L["The Crone"] = "The Crone"
	L["Romulo & Julianne"] = "Romulo & Julianne"
	L["Romulo"] = "Romulo"
	L["Julianne"] = "Julianne"
	L["Nightbane"] = "Nightbane"

	--Karazhan End
	L["Path to the Broken Stairs"] = "Path to the Broken Stairs";
	L["Broken Stairs"] = "Broken Stairs";
	L["Ramp to Guardian's Library"] = "Ramp to Guardian's Library";
	L["Mysterious Bookshelf"] = "Mysterious Bookshelf";
	L["Ramp up to the Celestial Watch"] = "Ramp up to the Celestial Watch";
	L["Ramp down to the Gamesman's Hall"] = "Ramp down to the Gamesman's Hall";
	L["Ramp to Medivh's Chamber"] = "Ramp to Medivh's Chamber";
	L["Spiral Stairs to Netherspace"] = "Spiral Stairs to Netherspace";
	L["Wravien <The Mage>"] = "Wravien <The Mage>";
	L["Gradav <The Warlock>"] = "Gradav <The Warlock>";
	L["Kamsis <The Conjurer>"] = "Kamsis <The Conjurer>";
	L["Ythyar"] = "Ythyar";
	L["Echo of Medivh"] = "Echo of Medivh";
	L["Shade of Aran"] = "Shade of Aran"
	L["Terestian Illhoof"] = "Terestian Illhoof"
	L["Netherspite"] = "Netherspite"
	L["Chess Event"] = "Chess Event"
	L["Prince Malchezaar"] = "Prince Malchezaar"
	L["The Curator"] = "The Curator"
	L["Kil'rek"] = "Kil'rek"
	L["Dust Covered Chest"] = "Dust Covered Chest"

	--Magisters Terrace
	L["Exarch Larethor"] = "Exarch Larethor";
	L["Fel Crystals"] = "Fel Crystals";
	L["Apoko"] = "Apoko";
	L["Eramas Brightblaze"] = "Eramas Brightblaze";
	L["Ellrys Duskhallow"] = "Ellrys Duskhallow";
	L["Fizzle"] = "Fizzle";
	L["Garaxxas"] = "Garaxxas";
	L["Sliver <Garaxxas' Pet>"] = "Sliver <Garaxxas' Pet>";
	L["Kagani Nightstrike"] = "Kagani Nightstrike";
	L["Warlord Salaris"] = "Warlord Salaris";
	L["Yazzai"] = "Yazzai";
	L["Zelfan"] = "Zelfan";
	L["Tyrith"] = "Tyrith";
	L["Scrying Orb"] = "Scrying Orb";
	L["Selin Fireheart"] = "Selin Fireheart"
	L["Vexallus"] = "Vexallus"
	L["Kalecgos"] = "Kalecgos"
	L["Priestess Delrissa"] = "Priestess Delrissa"
	L["Kael'thas Sunstrider"] = "Kael'thas Sunstrider"

	--Sunwell Plateau
	L["Madrigosa"] = "Madrigosa";
	L["Sathrovarr the Corruptor"] = "Sathrovarr the Corruptor"
	L["Brutallus"] = "Brutallus"
	L["Felmyst"] = "Felmyst"
	L["The Eredar Twins"] = "The Eredar Twins"
	L["Grand Warlock Alythess"] = "Grand Warlock Alythess"
	L["Lady Sacrolash"] = "Lady Sacrolash"
	L["M'uru"] = "M'uru"
	L["Entropius"] = "Entropius"
	L["Kil'jaeden"] = "Kil'jaeden"

	--TK: The Arcatraz
	L["Millhouse Manastorm"] = "Millhouse Manastorm";
	L["Third Fragment Guardian"] = "Third Fragment Guardian";
	L["Udalo"] = "Udalo";
	L["Zereketh the Unbound"] = "Zereketh the Unbound"
	L["Dalliah the Doomsayer"] = "Dalliah the Doomsayer"
	L["Wrath-Scryer Soccothrates"] = "Wrath-Scryer Soccothrates"
	L["Harbinger Skyriss"] = "Harbinger Skyriss"
	L["Warden Mellichar"] = "Warden Mellichar"

	--TK: The Botanica
	L["Commander Sarannis"] = "Commander Sarannis"
	L["High Botanist Freywinn"] = "High Botanist Freywinn"
	L["Thorngrin the Tender"] = "Thorngrin the Tender"
	L["Laj"] = "Laj"
	L["Warp Splinter"] = "Warp Splinter"

	--TK: The Mechanar
	L["Overcharged Manacell"] = "Overcharged Manacell";
	L["Gatewatcher Gyro-Kill"] = "Gatewatcher Gyro-Kill"
	L["Gatewatcher Iron-Hand"] = "Gatewatcher Iron-Hand"
	L["Cache of the Legion"] = "Cache of the Legion"
	L["Mechano-Lord Capacitus"] = "Mechano-Lord Capacitus"
	L["Nethermancer Sepethrea"] = "Nethermancer Sepethrea"
	L["Pathaleon the Calculator"] = "Pathaleon the Calculator"

	--TK: The Eye
	L["Al'ar"] = "Al'ar"
	L["Void Reaver"] = "Void Reaver"
	L["High Astromancer Solarian"] = "High Astromancer Solarian"
	L["Kael'thas Sunstrider"] = "Kael'thas Sunstrider"
	L["Thaladred the Darkener"] = "Thaladred the Darkener"
	L["Master Engineer Telonicus"] = "Master Engineer Telonicus"
	L["Grand Astromancer Capernian"] = "Grand Astromancer Capernian"
	L["Lord Sanguinar"] = "Lord Sanguinar"
	
	--Zul'Aman
	L["Vol'jin"] = "Vol'jin";
	L["Witch Doctor T'wansi"] = "Witch Doctor T'wansi";
	L["Blood Guard Hakkuz <Darkspear Elite>"] = "Blood Guard Hakkuz <Darkspear Elite>";
	L["Voodoo Pile"] = "Voodoo Pile";
	L["Bakkalzu"] = "Bakkalzu";
	L["Hazlek"] = "Hazlek";
	L["The Map of Zul'Aman"] = "The Map of Zul'Aman";
	L["Norkani"] = "Norkani";
	L["Kasha"] = "Kasha";
	L["Thurg"] = "Thurg";
	L["Gazakroth"] = "Gazakroth";
	L["Lord Raadan"] = "Lord Raadan";
	L["Darkheart"] = "Darkheart";
	L["Alyson Antille"] = "Alyson Antille";
	L["Slither"] = "Slither";
	L["Fenstalker"] = "Fenstalker";
	L["Koragg"] = "Koragg";
	L["Zungam"] = "Zungam";
	L["Forest Frogs"] = "Forest Frogs";
	L["Eulinda <Reagents>"] = "Eulinda <Reagents>";
	L["Harald <Food Vendor>"] = "Harald <Food Vendor>";
	L["Arinoth"] = "Arinoth";
	L["Kaldrick"] = "Kaldrick";
	L["Lenzo"] = "Lenzo";
	L["Mawago"] = "Mawago";
	L["Melasong"] = "Melasong";
	L["Melissa"] = "Melissa";
	L["Micah"] = "Micah";
	L["Relissa"] = "Relissa";
	L["Rosa"] = "Rosa";
	L["Tyllan"] = "Tyllan";

end
