-- $Id: Atlas_WrathoftheLichKing-enUS.lua 71 2023-03-20 15:13:37Z arithmandar $
--[[

	Atlas, a World of Warcraft instance map browser
	Copyright 2005 ~ 2010 - Dan Gilbert <dan.b.gilbert@gmail.com>
	Copyright 2010 - Lothaer <lothayer@gmail.com>, Atlas Team
	Copyright 2011 ~ 2023 - Arith Hsu, Atlas Team <atlas.addon at gmail dot com>

	This file is part of Atlas.

	Atlas is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Atlas is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Atlas; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

--]]

local AceLocale = LibStub:GetLibrary("AceLocale-3.0");
local L = AceLocale:NewLocale("Atlas_WrathoftheLichKing", "enUS", true, true);

if L then
L["Ahn'kahet Brazier"] = "Ahn'kahet Brazier"
L["AK, Kahet"] = "AK, Kahet"
L["Ambrose Boltspark"] = "Ambrose Boltspark"
L["AN, Nerub"] = "AN, Nerub"
L["Archivum Console"] = "Archivum Console"
L["Archmage Elandra <Kirin Tor>"] = "Archmage Elandra <Kirin Tor>"
L["Archmage Koreln <Kirin Tor>"] = "Archmage Koreln <Kirin Tor>"
L["Belgaristrasz"] = "Belgaristrasz"
L["Berinand's Research"] = "Berinand's Research"
L["Black Dragonflight Chamber"] = "Black Dragonflight Chamber"
L["Brann Bronzebeard"] = "Brann Bronzebeard"
L["Brigg Smallshanks"] = "Brigg Smallshanks"
L["Cache of Eregos"] = "Cache of Eregos"
L["Cavern Entrance"] = "Cavern Entrance"
L["Centrifuge Construct"] = "Centrifuge Construct"
L["Champ"] = "Champ"
L["Chester Copperpot <General & Trade Supplies>"] = "Chester Copperpot <General & Trade Supplies>"
L["Chromie"] = "Chromie"
L["Chronicler Bah'Kini"] = "Chronicler Bah'Kini"
L["Colosos"] = "Colosos"
L["CoT-Strat"] = "CoT-Strat"
L["Crus"] = "Crus"
L["Crusaders' Coliseum"] = "Crusaders' Coliseum"
L["Dark Ranger Kalira"] = "Dark Ranger Kalira"
L["Dark Ranger Loralen"] = "Dark Ranger Loralen"
L["Dark Ranger Marrah"] = "Dark Ranger Marrah"
L["Defender Mordun"] = "Defender Mordun"
L["Drakuru's Brazier"] = "Drakuru's Brazier"
L["DTK"] = "DTK"
L["Elder Chogan'gada"] = "Elder Chogan'gada"
L["Elder Igasho"] = "Elder Igasho"
L["Elder Jarten"] = "Elder Jarten"
L["Elder Kilias"] = "Elder Kilias"
L["Elder Nurgen"] = "Elder Nurgen"
L["Elder Ohanzee"] = "Elder Ohanzee"
L["Elder Yurauk"] = "Elder Yurauk"
L["Eternos"] = "Eternos"
L["FH1"] = "FH1"
L["FH2"] = "FH2"
L["FH3"] = "FH3"
L["FoS"] = "FoS"
L["From previous map"] = "From previous map"
L["Frostwyrm Lair"] = "Frostwyrm Lair"
L["Gorkun Ironskull"] = "Gorkun Ironskull"
L["Guardian of Time"] = "Guardian of Time"
L["Gun"] = "Gun"
L["Heroic: Trial of the Grand Crusader"] = "Heroic: Trial of the Grand Crusader"
L["HoL"] = "HoL"
L["HoR"] = "HoR"
L["HoS"] = "HoS"
L["IC"] = "IC"
L["Image of Argent Confessor Paletress"] = "Image of Argent Confessor Paletress"
L["Image of Drakuru"] = "Image of Drakuru"
L["Jaelyne Evensong"] = "Jaelyne Evensong"
L["Kaldir Ironbane"] = "Kaldir Ironbane"
L["Kurzel"] = "Kurzel"
L["Lady Jaina Proudmoore"] = "Lady Jaina Proudmoore"
L["Lady Sylvanas Windrunner <Banshee Queen>"] = "Lady Sylvanas Windrunner <Banshee Queen>"
L["Lana Stouthammer"] = "Lana Stouthammer"
L["Lieutenant Sinclari"] = "Lieutenant Sinclari"
L["Marshal Jacob Alerius"] = "Marshal Jacob Alerius"
L["Martin Victus"] = "Martin Victus"
L["Mr. Bigglesworth"] = "Mr. Bigglesworth"
L["Nax"] = "Nax"
L["Nex, Nexus"] = "Nex, Nexus"
L["Ocu"] = "Ocu"
L["Ony"] = "Ony"
L["OS"] = "OS"
L["PoS"] = "PoS"
L["Precious"] = "Precious"
L["Prospector Doren"] = "Prospector Doren"
L["Reclaimer A'zak"] = "Reclaimer A'zak"
L["Red Dragonflight Chamber"] = "Red Dragonflight Chamber"
L["Rimefang"] = "Rimefang"
L["RS"] = "RS"
L["Scourge Invasion Points"] = "Scourge Invasion Points"
L["Seer Ixit"] = "Seer Ixit"
L["Shavalius the Fancy <Flight Master>"] = "Shavalius the Fancy <Flight Master>"
L["Sif"] = "Sif"
L["Sindragosa's Lair"] = "Sindragosa's Lair"
L["Sister Svalna"] = "Sister Svalna"
L["Slosh <Food & Drink>"] = "Slosh <Food & Drink>"
L["Spinestalker"] = "Spinestalker"
L["Stinky"] = "Stinky"
L["Stormherald Eljrrin"] = "Stormherald Eljrrin"
L["Teleporter to Middle"] = "Teleporter to Middle"
L["TEoE"] = "TEoE"
L["The Captain's Chest"] = "The Captain's Chest"
L["The Culling of Stratholme"] = "The Culling of Stratholme"
L["The Keepers"] = "The Keepers"
L["The Siege"] = "The Siege"
L["To next map"] = "To next map"
L["Tol'mar"] = "Tol'mar"
L["Tower of Flame"] = "Tower of Flame"
L["Tower of Frost"] = "Tower of Frost"
L["Tower of Life"] = "Tower of Life"
L["Tower of Storms"] = "Tower of Storms"
L["Tribunal Chest"] = "Tribunal Chest"
L["UK, Keep"] = "UK, Keep"
L["Uldu"] = "Uldu"
L["UP, Pinn"] = "UP, Pinn"
L["Upper Spire"] = "Upper Spire"
L["Verdisa"] = "Verdisa"
L["VH"] = "VH"
L["VoA"] = "VoA"
L["Warmage Kaitlyn"] = "Warmage Kaitlyn"
L["Watcher Gashra"] = "Watcher Gashra"
L["Watcher Narjil"] = "Watcher Narjil"
L["Watcher Silthik"] = "Watcher Silthik"

--************************************************
-- Zone Names, Acronyms, and Common Strings
--************************************************
	--WotLK Acronyms
	L["AK, Kahet"] = "AK, Kahet"; -- Ahn'kahet
	L["AN, Nerub"] = "AN, Nerub"; -- Azjol-Nerub
	L["Champ"] = "Champ"; -- Trial of the Champion
	L["CoT-Strat"] = "CoT-Strat"; -- Culling of Stratholme
	L["Crus"] = "Crus"; -- Trial of the Crusader
	L["DTK"] = "DTK"; -- Drak'Tharon Keep
	L["FoS"] = "FoS"; -- The Forge of Souls
	L["FH1"] = "FH1"; -- The Forge of Souls
	L["Gun"] = "Gun"; -- Gundrak
	L["HoL"] = "HoL"; -- Halls of Lightning
	L["HoR"] = "HoR"; -- Halls of Reflection
	L["FH3"] = "FH3"; -- Halls of Reflection
	L["HoS"] = "HoS"; -- Halls of Stone
	L["IC"] = "IC"; -- Icecrown Citadel
	L["Nax"] = "Nax"; -- Naxxramas
	L["Nex, Nexus"] = "Nex, Nexus"; -- The Nexus
	L["Ocu"] = "Ocu"; -- The Oculus
	L["Ony"] = "Ony"; -- Onyxia's Lair
	L["OS"] = "OS"; -- The Obsidian Sanctum
	L["PoS"] = "PoS"; -- Pit of Saron
	L["FH2"] = "FH2"; -- Pit of Saron
	L["RS"] = "RS"; -- The Ruby Sanctum
	L["TEoE"] = "TEoE"; -- The Eye of Eternity
	L["UK, Keep"] = "UK, Keep"; -- Utgarde Keep
	L["Uldu"] = "Uldu"; -- Ulduar
	L["UP, Pinn"] = "UP, Pinn"; -- Utgarde Pinnacle
	L["VH"] = "VH"; -- The Violet Hold
	L["VoA"] = "VoA"; -- Vault of Archavon

	--Zones not included in LibBabble-Zone
	L["Crusaders' Coliseum"] = "Crusaders' Coliseum"; 

--*****************
-- Wrath of the Lich King Instances
--*****************

	--Azjol-Nerub: Ahn'kahet: The Old Kingdom
	L["Seer Ixit"] = "Seer Ixit";
	L["Ahn'kahet Brazier"] = "Ahn'kahet Brazier";

	--Azjol-Nerub: Azjol-Nerub
	L["Reclaimer A'zak"] = "Reclaimer A'zak";
	L["Watcher Gashra"] = "Watcher Gashra";
	L["Watcher Narjil"] = "Watcher Narjil";
	L["Watcher Silthik"] = "Watcher Silthik";
	L["Elder Nurgen"] = "Elder Nurgen";	

	--Caverns of Time: The Culling of Stratholme
	L["The Culling of Stratholme"] = "The Culling of Stratholme";
	L["Scourge Invasion Points"] = "Scourge Invasion Points";
	L["Guardian of Time"] = "Guardian of Time";
	L["Chromie"] = "Chromie";

	--Drak'Tharon Keep
	L["Image of Drakuru"] = "Image of Drakuru";
	L["Kurzel"] = "Kurzel";
	L["Elder Kilias"] = "Elder Kilias";
	L["Drakuru's Brazier"] = "Drakuru's Brazier";

	--The Frozen Halls: Halls of Reflection
	--3 beginning NPCs omitted, see The Forge of Souls
	L["The Captain's Chest"] = "The Captain's Chest";

	--The Frozen Halls: Pit of Saron
	--6 beginning NPCs omitted, see The Forge of Souls
	L["Martin Victus"] = "Martin Victus";
	L["Gorkun Ironskull"] = "Gorkun Ironskull";
	L["Rimefang"] = "Rimefang";

	--The Frozen Halls: The Forge of Souls
	L["Lady Jaina Proudmoore"] = "Lady Jaina Proudmoore";
	L["Archmage Koreln <Kirin Tor>"] = "Archmage Koreln <Kirin Tor>";
	L["Archmage Elandra <Kirin Tor>"] = "Archmage Elandra <Kirin Tor>";
	L["Lady Sylvanas Windrunner <Banshee Queen>"] = "Lady Sylvanas Windrunner <Banshee Queen>";
	L["Dark Ranger Loralen"] = "Dark Ranger Loralen";
	L["Dark Ranger Kalira"] = "Dark Ranger Kalira";

	--Gundrak
	L["Chronicler Bah'Kini"] = "Chronicler Bah'Kini";
	L["Tol'mar"] = "Tol'mar";
	L["Elder Ohanzee"] = "Elder Ohanzee";

	--Icecrown Citadel
	L["To next map"] = "To next map";
	L["From previous map"] = "From previous map";
	L["Upper Spire"] = "Upper Spire";
	L["Sindragosa's Lair"] = "Sindragosa's Lair";
	L["Stinky"] = "Stinky";
	L["Precious"] = "Precious";
	L["Rimefang"] = "Rimefang";	-- NPC: 37533
	L["Spinestalker"] = "Spinestalker";	-- NPC: 37534
	L["Sister Svalna"] = "Sister Svalna";	-- NPC: 37126

	--Naxxramas
	L["Mr. Bigglesworth"] = "Mr. Bigglesworth";
	L["Frostwyrm Lair"] = "Frostwyrm Lair";
	L["Teleporter to Middle"] = "Teleporter to Middle";

	--The Obsidian Sanctum
	L["Black Dragonflight Chamber"] = "Black Dragonflight Chamber";

	--Onyxia's Lair

	--The Ruby Sanctum
	L["Red Dragonflight Chamber"] = "Red Dragonflight Chamber";

	--The Nexus: The Eye of Eternity

	--The Nexus: The Nexus
	L["Warmage Kaitlyn"] = "Warmage Kaitlyn";
	L["Berinand's Research"] = "Berinand's Research";
	L["Elder Igasho"] = "Elder Igasho";

	--The Nexus: The Oculus
	L["Belgaristrasz"] = "Belgaristrasz";
	L["Eternos"] = "Eternos";
	L["Verdisa"] = "Verdisa";
	L["Centrifuge Construct"] = "Centrifuge Construct";
	L["Cache of Eregos"] = "Cache of Eregos";

	--Trial of the Champion
	L["Marshal Jacob Alerius"] = "Marshal Jacob Alerius";
	L["Ambrose Boltspark"] = "Ambrose Boltspark";
	L["Colosos"] = "Colosos";
	L["Jaelyne Evensong"] = "Jaelyne Evensong";
	L["Lana Stouthammer"] = "Lana Stouthammer";

	--Trial of the Crusader
	L["Heroic: Trial of the Grand Crusader"] = "Heroic: Trial of the Grand Crusader";
	L["Cavern Entrance"] = "Cavern Entrance";

	--Ulduar (Entrance)
	L["Shavalius the Fancy <Flight Master>"] = "Shavalius the Fancy <Flight Master>";
	L["Chester Copperpot <General & Trade Supplies>"] = "Chester Copperpot <General & Trade Supplies>";
	L["Slosh <Food & Drink>"] = "Slosh <Food & Drink>";

	--Ulduar General
	L["The Siege"] = "The Siege";
	L["The Keepers"] = "The Keepers";

	--Ulduar A
	L["Tower of Life"] = "Tower of Life";
	L["Tower of Flame"] = "Tower of Flame";
	L["Tower of Frost"] = "Tower of Frost";
	L["Tower of Storms"] = "Tower of Storms";

	--Ulduar B
	L["Prospector Doren"] = "Prospector Doren";
	L["Archivum Console"] = "Archivum Console";

	--Ulduar C
	L["Sif"] = "Sif";

	--Ulduar D

	--Ulduar E

	--Ulduar: Halls of Lightning
	L["Stormherald Eljrrin"] = "Stormherald Eljrrin";

	--Ulduar: Halls of Stone
	L["Kaldir Ironbane"] = "Kaldir Ironbane";
	L["Tribunal Chest"] = "Tribunal Chest";
	L["Elder Yurauk"] = "Elder Yurauk";
	L["Brann Bronzebeard"] = "Brann Bronzebeard";

	--Utgarde Keep: Utgarde Keep
	L["Defender Mordun"] = "Defender Mordun";
	L["Dark Ranger Marrah"] = "Dark Ranger Marrah";
	L["Elder Jarten"] = "Elder Jarten";

	--Utgarde Keep: Utgarde Pinnacle
	L["Brigg Smallshanks"] = "Brigg Smallshanks";
	L["Image of Argent Confessor Paletress"] = "Image of Argent Confessor Paletress";
	L["Elder Chogan'gada"] = "Elder Chogan'gada";

	--Vault of Archavon

	--The Violet Hold
	L["Lieutenant Sinclari"] = "Lieutenant Sinclari";
end
