local AddonName, ns = ...

if (GetLocale() ~= "enUS") then return end

ns.enUS = true

local L = ns.L
local c1 = ns.c1

do --英语说明书
    ns.instructionsText = {
        "|cff00BFFF<Manual> (This plug-in supports MOP, CTM, WLK, Titan, and classic old world)",
        " ",
        "|cffFFFFFF-Open command: |r/BiaoGe or /GBG, or bind keys in game settings. Minimap icon: " .. "|TInterface\\AddOns\\BiaoGe\\Media\\icon\\icon:0|t",
        "|cffFFFFFF-Quick operation: |r|A:NPE_RightClick:0:0|a input box clears content",
        "|cffFFFFFF-jump cursor:|r Press Tab and arrow keys to jump to the cursor, ALT/CTRL/SHIFT+arrow keys to jump to the next BOSS",
        -- "|cffFFFFFF-Add equipment:|rSelect from the equipment drop-down list; or drag equipment from your backpack into the table",
        "|cffFFFFFF-Automatic auction: |rALT+click the table/backpack/chat box equipment to open the auction panel (when you are the group leader or item distributor)",
        "|cffFFFFFF-Follow the equipment:|rALT+click the equipment. The team leader will be reminded when the equipment is auctioned (when you are a team member)",
        "|cffFFFFFF-Auction countdown: |r|A:NPE_RightClick:0:0|a chat box equipment starts auction and counts down automatically (when you are the group leader or item distributor)",
        "|cffFFFFFF-Quick accounting: |r|A:NPE_RightClick:0:0|a chat box opens when equipped (when you are a member)",
        "|cffFFFFFF-View other optional equipment for the same part: |rCTRL+click on the equipment",
        "|cffFFFFFF-Swap grid: |rCTRL+ALT+click grid 1, then click grid 2 to exchange the entire contents of the two lines",
        "|cffFFFFFF-Character Overview:|rShortcut Command:/BGR",
        "|cffFFFFFF-More function introductions can be viewed in the settings",
        " ",
    }
    ns.updateText_now = {
    }
    ns.updateText_before = {
        "|cff00FF00" .. [[Updated on January 10th v1.24.4]],
        [[-Auction WA: Adjusted the bid increase per lot for bids above 10,000 to shorten the auction time]],
        [[-<Time Server/MOP>Support reporting WCL]],
        [[-<Time Server>World Boss: Now when you touch the Boss, the equipment will be automatically recorded in the table, no need to click the button]],
        " ",
        "|cff00FF00" .. [[Updated on January 7 v1.24.3]],
        [[-<Time Server>Member World BossCD: The member frame now supports right-clicking to open the menu (you can quickly kick people, etc.)]],
        [[-<MOP>Character Overview: Some brands will now display the total upper limit]],
        [[-<MOP>Character Overview: Added professional skill CD "Jewelry Research" (check it in the settings)]],
        " ",
        "|cff00FF00" .. [[Updated v1.23.9 on December 25]],
        [[-Added function: Move debtors to team 78 (the entrance is in the team interface where you press the O key, visible when you are the team leader)]],
        [[-Automatic auction: You can now hold down ALT+click on the equipment in the pickup box to initiate an auction]],
        [[-<MOP>Character Overview: Added currency "Supreme Stone Fragments" and "Iron Palm Emblem", added task "Collect Food" (the above 3 items are not checked by default)]],
        " ",
        "|cff00FF00" .. [[Updated on December 22 v1.23.7]],
        [[-<MOP>Character Overview: Add professional skill CD (check it in the settings)]],
        [[-Role Overview: Added display of professional skill points (only main majors are displayed by default, auxiliary majors need to be checked by yourself)]],
        [[-Character Overview: If a character who has learned a major has not completed the professional daily tasks that day, a red X will be displayed]],
        [[-Settings: You can now set the zoom individually for the character overview UI]],
        [[-Fixed the problem of invalid viewing of online users in foreign servers]],
        " ",
        "|cff00FF00" .. [[Updated on December 17th v1.23.6]],
        [[-<MOP>Supports Chinese version of Pandaren]],
        " ",
        "|cff00FF00" .. [[Updated on December 16th v1.23.5]],
        [[-<Time Server>Even if the chat is blocked, an equipment will record the results normally after the automatic auction ends, and no longer rely on the team leader’s notification]],
        " ",
        "|cff00FF00" .. [[Updated on December 15th v1.23.4]],
        [[-Notification bill: Add a self-selected notification channel (next to the notification button)]],
        [[-Settings: Add option "Block sending restricted system messages" (checked by default)]],
        [[-Added support for English localization]],
        [[-Fixed the issue of abnormal auction records when using automatic auction in the English version]],
    }
end

do
    L["|cff808080（带*的设置需要重载才能生效）|r"] = "|cff808080(Settings marked with * require a reload to take effect)|r"
    L["显示牌子总上限"] = "Show Total Currency Cap"
    L["像勇气点数、征服点数有总上限的牌子，在角色总览里会显示其总上限。"] = "For currencies with a total cap (e.g., Valor Points, Conquest Points), their total cap will be displayed in the Character Overview."
    L["（需重载）"] = "(Requires Reload)"
    L["末日领主"] = "Doom Lord"
    L["（总上限%s/%s）"] = "(Total Limit %s/%s)"
    L["|Hgarrmission:BiaoGeDuiZhang:%s|h[点击：对账]（|cff00ff00装备总收入%s|r%s）"] = "|Hgarrmission:BiaoGeDuiZhang:%s|h[Click: Reconcile Accounts] (|cff00ff00Total Equipment Income %s|r%s)"
    L["|Hgarrmission:BiaoGeDuiZhangCopy:%s:%s|h[ALT+点击：复制账单]（|cff00ff00仅对装备收入有效|r）"] = "|Hgarrmission:BiaoGeDuiZhangCopy:%s:%s|h[ALT+Click: Copy Bill] (|cff00ff00Only valid for equipment income|r)"
    L["%s：%s已就绪！"] = "%s: %s is ready!"
    L["珠宝研究"] = "Jewelcrafting Research"
    L["{rt1}Roll点开始{rt1} %s"] = "{rt1}Roll Started{rt1} %s"
    L["不能同时发起多件装备Roll点。"] = "Cannot initiate rolling for multiple pieces of equipment at the same time."
    L["开始Roll点"] = "Start Roll"
    L["以下玩家无法分配装备：\n(已有CD或没进战斗)"] = "The following players cannot receive equipment:\n(CD active or not in combat)"
    L["——通报CD异常玩家——"] = "——Notify Players with Abnormal CD——"
    L["无法分配装备(已有CD或没进战斗)："] = "Cannot assign equipment (CD active or not in combat):"
    L["已拍已交易"] = "Auctioned & Traded"
    L["欠款者移到78队"] = "Move debtors to Group 7 & 8"
    L["不在团队，该功能无法使用。"] = "Cannot use this feature when not in a raid group."
    L["你不是团长或助理，该功能无法使用。"] = "Cannot use this feature unless you are the raid leader or assistant."
    L["战斗中，该功能无法使用。"] = "Cannot use this feature during combat."
    L["团队人数超过30人，该功能无法使用。"] = "Cannot use this feature when the raid has more than 30 members."
    L["没有欠款。"] = "No outstanding debts."
    L["欠款者超过10人，该功能无法使用。"] = "Cannot use this feature when there are more than 10 debtors."
    L["队伍调整已完成。"] = "Raid group adjustment completed."
    L["收菜"] = "Collect Dues"
    L["选填（仅自己可见）"] = "Optional (Visible only to yourself)"
    L["邪煞水晶"] = "Fel Shard"
    L["仅显示高于该等级的角色："] = "Only show characters above this level: "
    L["仅显示高于该装等的角色："] = "Only show characters above this item level: "
    L["角色总览UI缩放"] = "Character Overview UI Scale"
    L["调整角色总览UI的大小。"] = "Adjust the size of the Character Overview UI."
    L["自动拍卖UI缩放"] = "Auto Auction UI Scale"
    L["表格UI缩放"] = "Table UI Scale"
    L["专业CD"] = "Profession CD"
    L["专业技能"] = "Professions"
    L["未学"] = "Unln"
    L["炼金转化"] = "Alchemy Transmutation"
    L["霹雳钢锭"] = "Thundersteel Ingot"
    L["智慧卷轴"] = "Scroll of Wisdom"
    L["神龙之心"] = "Dragon Soul"
    L["华丽制皮"] = "Elegant Leatherworking"
    L["帝王丝绸"] = "Imperial Silk"
    L["无CD"] = "No CD"
    L["团员世界BossCD"] = "Raid Member World Boss CD"
    L["该支出项含有百分比|cff00ff00（%s%%）|r，正在自动计算支出金额。"] = "This expense item contains a percentage |cff00ff00(%s%%)|r, and the expense amount is being calculated automatically."
    L["你可以通过删除支出项的百分比符号来取消自动计算，或者在表格设置里关闭该项功能。"] = "You can cancel automatic calculation by deleting the percentage symbol from the expense item, or disable this feature in the table settings."
    L["拍卖WA版本："] = "Auction WA Version: "
    L["屏蔽发送受限的系统消息"] = "Block system messages of sending restrictions"
    L["自动屏蔽该系统消息\"可发送的信息数量受限，请稍候再发送下一条信息。\"。"] = "Automatically block the system message: \"The number of sendable messages is limited, please wait to send the next message.\""
    L["|cffff0000由于服务器聊天限流，通报已被停止。"] = "|cffff0000Notification has been stopped due to server chat rate limiting.|r"
    L["该频道需在副本内才能通报。"] = "Notifications in this channel are only available inside instances."
    L["没有公会，无法通报。"] = "Cannot send notifications without a guild."
    L["不在团队，无法通报。"] = "Cannot send notifications without being in a raid group."
    L["该模块已被禁用"] = "This module has been disabled"
    L["禁用该模块"] = "Disable this module"
    L["开启该模块"] = "Enable this module"
    L["装备："] = "Equipment: "
    L["买家："] = "Buyer: "
    L["添加装备"] = "Add Equipment"
    L["删除记录"] = "Delete Record"
    L["修改记录"] = "Edit Record"
    L["取消选择"] = "Cancel Selection"
    L["一键清空全部装备、买家、金额，同时还清空关注和欠款。如果有自动拍卖记录，则也会被清空。"] = "One-click clear all equipment, buyers, amounts, as well as favorites and debts. Auto-auction records (if any) will also be cleared."
    L["表格：%s"] = "Table: %s"
    L["密码："] = "Password: "
    L["需全团安装拍卖WA，没安装的人将会看不到拍卖窗口。"] = "All raid members need to install the Auction WA; those who don't will not see the auction window."
    L["交易增强"] = "Trade Enhancement"
    L["|cff808080（带*的设置为即时生效，否则需要重载才能生效）|r"] = "|cff808080(Settings marked with * take effect immediately; others require a reload)|r"
    L["鼠标提示对方的欠款和罚款"] = "Show target's debts and fines on tooltip"
    L["鼠标悬浮在一个玩家时，显示他的欠款和罚款。"] = "Display a player's debts and fines when hovering the mouse over them."
    L["原生功能"] = "Native Features"
    L["备注："] = "Notes: "
    L["|cffFFFFFFCTRL+滚轮：|r快速滚动"] = "|cffFFFFFFCTRL+Scroll Wheel:|r Fast Scroll"
    L["|cffFFFFFFSHIFT+滚轮：|r滚动到最前/最后"] = "|cffFFFFFFSHIFT+Scroll Wheel:|r Scroll to Top/Bottom"
    L["< 表格 >"] = "< Table >"
    L["已成功接收%s的表格。"] = "Successfully received %s's table."
    L["毒蛇风暴"] = "SSC&TK"
    L["时光徽章历史价格"] = "Timeworn Badge Historical Prices"
    L["本次交易记为罚款"] = "Record this transaction as a fine"
    L["事由"] = "Subject matter"
    L["罚款人"] = "Fined Plr"
    L["（本周%s/%s）"] = "(%s/%s of the week)"
    L["末日领主卡扎克"] = "Doom Lord Kazzak"
    L["记录到表格"] = "Record to table"
    L["把全部掉落记录到BOSS对应的表格。"] = "Record all drops to the table corresponding to the boss."
    L["如果BOSS格子里已有旧记录，则会自动清空旧记录。"] = "If there is already an old record in the BOSS grid, the old record will be cleared automatically."
    L["通报频道"] = "Notification Channel"
    L["设为成功拍卖"] = "Set to Successful Auction"
    L["重新拍卖"] = "Re-auction"
    L["清空全部"] = "Clear all"
    L["清空部分内容（自选）"] = "Empty part (optional)"
    L["清空表格（%s）"] = "Empty Form (%s)"
    L["自动拍卖记录"] = "Auto Auction Log"
    L["全选"] = "Select All"
    L["取消全选"] = "Cancel Select All"
    L["确定清空表格"] = "Confirm Empty Form"
    L["|cffff0000（订阅已过期或未开更新器）"] = "|cffff0000 (subscription expired or no updater on)"
    L["|cffff0000（BiaoGeLib插件被禁用）"] = "|cffff0000 (BiaoGeLib plugin disabled)"
    L["海达希亚"] = "Haidahia"
    L["清空表格时自定义分钱人数"] = "Custom penny count when clearing the form"
    L["表格会按照你设定的人数修改分钱人数。"] = "The form will modify the number of cents according to the number of people you set."
    L["v3.2：支持英语本地化"] = "v3.2: Support English localization"
    L["T1套"] = "T1 set"
    L["快捷按钮"] = "Shortcut Button"
    L["毒蛇神殿"] = "Serpentshrine Cavern"
    L["商人"] = "Merchant"
    L["末日行者"] = "Doomwalker"
    L["末日行者卡扎克"] = "Doomwalker 'Lord Kazzak"
    L["炼金"] = "Alchemy"
    L["毒蛇神殿"] = "Serpentshrine Cavern."
    L["风暴要塞"] = "Tempest Keep"
    L["确定使用该表格？\n你的当前表格将被其|cffff0000替换|r"] = "Sure you want to use this form? \nYour current form will be replaced by its|cffff0000|r"
    L["使用该表格"] = "Use this form"
    L["已向%s发送请求。"] = "A request has been sent to %s."
    L["正在接收%s的表格数据。"] = "Receiving form data from %s is in progress."
    L["已成功接收%s的表格数据。"] = "Has successfully received form data from %s."
    L["双倍经验"] = "Double experience"
    L["满级"] = "Full"
    L["完成"] = "Complete"
    L["巨龙"] = "Mega Dragon"
    L["T13套"] = "T13 set"
    L["裂隙石"] = "Rift Stone"
    L["荣誉"] = "Honor"
    L["牌子拾取增强"] = "Token Pickup Enhancement"
    L["拾取牌子时，增加显示该牌子的现有数量。"] = "When picking up tiles, add display of the number of tiles available for that tile."
    L["拾取牌子时，如果已经达到该牌子的数量上限，播放语音提醒。"] = "When picking up tiles, play a voice reminder if the maximum number of tiles for that tile has been reached."
    L["在部分物品的提示文本中，增加显示该牌子的数量。比如在熊猫人之怒的正义奖章里，提示正义点数现有数量。"] = "Added display of the number of tiles available in the hint text for some items. For example, in the Justice Medallion for TESTT Man's Wrath, prompt for the existing number of Justice Points."
    L["英雄难度"] = "Seal of the Crusader Judgement Increase' Difficulty"
    L["普通难度"] = "Normal Difficulty."
    L["确定清空<%s>的所有历史表格？"] = "Make sure to clear all history tables for <%s>?"
    L["清空历史表格"] = "Empty history tables"
    L["魔古山"] = "Mount Mogu"
    L["恐惧"] = "Searing Pain"
    L["永春台"] = "Yongchun Terrace"
    L["T14套"] = "T14 set"
    L["勇气"] = "Courage"
    L["正义"] = "Justice"
    L["天神"] = "God of Heaven"
    L["罚款合计：%s"] = "Total fines: %s"
    L["（合计%s）"] = "(Total %s)"
    L["烹饪技能点"] = "Dry Pork Ribs' Skills Points"
    L["按下 Ctrl+X 复制金额"] = "Press Ctrl+X to copy the amount"
    L["工资与补贴"] = "Wages & Subs"
    L["工资与补贴："] = "Wages & Subs:"
    L["增加复制工资与补贴的按钮。"] = "Add button to copy Wages & Allowances."
    L["复制应付金额"] = "Copy Payable Amounts"
    L["在交易界面增加一个复制应付金额的按钮。"] = "Adds a button to copy payable amounts to the transaction screen."
    L["复制"] = "Copy"
    L["罚款格子满了。。"] = "The fines grid is full."
    L["< 交易记账成功 >|r\n项目：|cffff0000罚款|r\n玩家：%s\n金额：%s%d|rg"] = "< Record Success >|r\nItem:|cffff0000Fine|r\nPlayer:%s\nAmount:%s%d|rg"
    L["魔古山宝库"] = "Magic Ancient Mountain Treasure Trove"
    L["v3.1：修复了输入框变绿的问题"] = "v3.1: Fixed the problem of input box turning green"
    L["|cffff0000（未订阅）"] = "|cffff0000 (unsubscribed)"
    L["|cffff0000（插件被禁用）"] = "|cffff0000 (plugin disabled)"
    L["插件"] = "AddOn"
    L["已放金币：%s"] = "Gold released: %s"
    L["根据YY评价标记活动"] = "Evaluate 'Superior Mana' campaigns based on YA"
    L["如果活动说明里含有YY号且你曾评价过该YY，则对该活动添加对应的评价颜色。"] = "If the activity description contains a YY number and you have rated the YY, add the corresponding rating color to the activity."
    L["%s当前橙片数量：%s"] = "%sCurrent number of orange slices: %s"
    L["已自动记入表格：%s%s%s x%d => %s<%s>%s"] = "Automatically entered into table: %s%s%s x%d => %s<%s>%s"
    L["已自动记入表格：%s%s%s => %s<%s>%s"] = "Automatically entered into table: %s%s%s => %s<%s>%s"
    L["自动出价的延迟时间随机"] = "Randomized 'Summon Dart Frog' time for auto-bidding"
    L["启用自动出价时，当别人出价后，默认是自己会延迟0.5秒后才自动出价。"] = "When autobidding is enabled, when someone else bids, by default you will 'Summon Dart Frog' for 0.5 seconds before bidding."
    L["现在可以修改这个延迟时间，并在一定范围内随机（%s秒-X秒）。X最低为%s秒，最高为%s秒。"] = "Now you can change this 'Summon Dart Frog' time and randomize it within a certain range (%s seconds - X seconds). x is as low as %s seconds and as high as %s seconds."
    L["瓦兰奈尔碎片"] = "Varanelles 'Chess: Face Square"
    L["查看教程"] = "View Tutorial"
    L["我想成为语音包作者"] = "I want to become a voice pack author"
    L["通过搜索组队频道的活动也会显示[密语]按钮。"] = "Activity via 'Pick Pocket' group channel will also show the [Whisper] button."
    L["v3.0：修复了拍卖框架的一个重叠问题"] = "v3.0: Fixed an overlapping issue with auction frames."
    L["声望"] = "Reputation"
    L["提醒团长：如果你没有物品分配权，将会导致交易的相关功能失效。"] = "Reminder: If you do not have the right to distribute an item, it will result in a trade related feature called 'Spell Penetration 150 Frost Resist'."
    L["禁用语音开团快人一步"] = "Disable Voice-Opened Tours"
    L["活动列表顶部的语音开团快人一步将会被禁用，其活动将会合并到常规活动里。"] = "Spell Penetration will be disabled at the top of the event list and will be merged into regular events."
    L["影霜碎片"] = "Shadowfrost 'Chess: Face Square"
    L["埃提耶什的碎片"] = "Etiyesh's 'Chess: Face Square"
    L["这些物品分配给>%s<："] = "These items are assigned to >%s<:"
    L["|cff808080未知数量|r"] = "|cff808080Unknown Quantity|r"
    L["|cff808080(未知数量)|r"] = "|cff80808080(unknown quantity)|r"
    L["角色重复"] = "Character duplicates"
    L["你部分角色存在重复（同一个角色存在于多个子账号）。请你登录曾经复制过配置的账号，在表格设置-角色配置里面删掉重复角色。"] = "Some of your characters are duplicates (the same character exists in multiple sub-accounts). Please log in to the account that you have duplicated and delete the duplicate Character in Form Settings - Character Configuration."
    L["点击后会把这些物品分配给>%s<："] = "Clicking on this will assign these items to >%s<:"
    L["|cffff8000橙片：|r"] = "|cffff8000 orange slices:|r"
    L["橙片"] = "Orange Slices"
    L["选择指定人员"] = "Select Assigned Person"
    L["清除指定人员"] = "Clear Assigned Person"
    L["|cffff0000%s的橙片任务已完成，不能分配给它！|r"] = "|cffff0000%s Orange Slice Quests are complete and cannot be assigned to it! |r"
    L["|cffff0000%s的橙片可能已达上限，不能分配给它！|r"] = "|cffff0000%s of Orange Slice Quests may have been reached and cannot be assigned to it! |r"
    L["已完成橙片任务。"] = "Completed Orange Quests."
    L["未知橙片数量|cffFFD100（该玩家可能未安装BiaoGe插件，或者BiaoGe插件版本太低）|r"] = "Unknown number of orange slices |cffFFD100 (this player may not have the BiaoGe plugin installed, or the BiaoGe plugin version is too low) |r"
    L["|cff00ff00已完成任务|r"] = "|cff00ff00 has 'Quests completed' |r"
    L["|cffff0000未知数量|r"] = "|cffff0000 Unknown number |r"
    L["|cffff0000(未知数量)|r"] = "|cffff0000(unknown quantity)|r"
    L["|cffff0000未指定|r"] = "|cffff0000Unspecified|r"
    L["重置配置"] = "Reset Configuration"
    L["确认重置BiaoGe插件的所有配置文件？包括心愿清单、历史表格、角色总览、设置选项等等全部都会被重置。"] = "Confirmed to reset all configuration files of BiaoGe plugin? This includes Wish Lists, History Tables, Character Overview, Settings Options, etc. All will be reset."
    L["在某些情况下，会有语音提醒，比如：装备快过期、拍卖啦、心愿达成、炼金转化已就绪等等。"] = "In some cases, there will be voice alerts, such as: Gear is expiring, Auction is coming up, Wish is granted, Alchemy transformation is ready, etc."
    L["语音包"] = "Voice packs"
    L["自动出价结束后语音提醒"] = "Voice Alerts at the end of an automated bidding session"
    L["自动出价结束后，语音提醒你，防止你错过装备。"] = "A voice reminder at the end of an automatic bid to prevent you from missing a Gear."
    L["UI层级"] = "UI Layers"
    L["只能在非团队状态使用调试模式。"] = "Debug Mode can only be used in non-team state."
    L["调试模式"] = "Debug Mode"
    L["你可以在该模式，调整拍卖UI的位置，预览UI缩放和层级效果。只能在非团队状态下使用。"] = "In this mode, you can 'Improved Gouge' the position of the auction UI, preview the UI zoom and hierarchy effects. It can only be used in non-team state."
    L["退出调试模式"] = "Exiting Debug Mode"
    L["进入调试模式"] = "Enter Debug Mode"
    L["竞拍欢呼语"] = "Bidding Cheer"
    L["在竞价过程中，如果有人出价超过%s，有%s概率团长在团队频道发送一段随机的欢呼语，以活跃拍卖氛围。"] = "During the bidding process, if someone bids more than %s, there is a %s probability that the head of the team will send a random cheer in the team channel to liven up the auction atmosphere."
    L["需要使用非匿名模式，而且你是团长时才会生效。"] = "Requires non-anonymous mode and you are the team leader for this to work."
    L["实际交易：%s"] = "Actual transaction: %s"
    L["角色数据错误"] = "Character Data Error"
    L["你部分角色存在错误，请你/BGR，然后鼠标悬停在有错误的角色上，会显示解决办法。"] = "There are errors in some of your Characters, please /BGR, then hover over the Character with the error and the solution will be displayed."
    L["插件过期提醒"] = "Plugin expiration reminder"
    L["当插件有可用更新时，红字提醒。"] = "Red text reminder when there is an available update for the plugin."
    L["罚款："] = "Fine:"
    L["导出名单"] = "Export List"
    L["|cff808080（鼠标中键固定显示，长按SHIFT显示全服务器角色%s）|r"] = "|cff808080 (middle mouse button fixed display, long press SHIFT to display full server Character %s)|r"
    L["|cff808080（鼠标中键固定显示，长按SHIFT显示当前服务器角色%s）|r"] = "|cff808080 (middle mouse button fixed display, long press SHIFT to display current server Character %s)|r"
    L["|cff808080（%s固定显示，长按SHIFT显示全服务器角色%%s）|r"] = "|cff808080 (%s fixed display, long press SHIFT to display full server Character %%s)|r"
    L["|cff808080（%s固定显示，长按SHIFT显示当前服务器角色%%s）|r"] = "|cff808080 (%s fixed display, long press SHIFT to display current server Character %%s)|r"
    L["|cffff0000（该团长为毛团，请注意！如想举报更多毛团，请在抖音发视频后@苍穹之霜）|r"] = "|cffff0000 (This leader is a Maoist group! If you want to report more hairy corps, please post a video on ShakeShack and then @ CangDaoFrost)|r"
    L["你没有安装官方WCL插件。"] = "You do not have the official WCL plugin installed."
    L["拍卖过程中不会显示当前出价最高人是谁，拍卖结束后才会知晓。"] = "The auction process will not show who the current highest bidder is, it will only be known after the auction ends."
    L["如需强制清除欠款，需按下ALT后才能清除！"] = "If you need to force clear the outstanding amount, you need to press ALT before clearing it!"
    L["该支出项含有人数"] = "This expense item contains the number of people"
    L["支出：%s"] = "Expenses: %s"
    L["人数：%s人"] = "Number of people: %s people"
    L["每人：|cff00ff00%s|r"] = "People: |cff00ff00%s|r"
    L["使用方案"] = "Using the program"
    L["修改方案"] = "Modify the program"
    L["（ALT+%s改名，ALT+%s删除表格）"] = "(ALT+%s to change name, ALT+%s to delete form)"
    L["搜索该记录"] = "Pick Pocket This record"
    L["删除该记录"] = "Delete this record"
    L["（ALT+%s设为心愿装备。部位按钮支持使用滚轮切换）"] = "(ALT+%s Set to Wish Gear . The part buttons support switching using the scroll wheel)"
    L["打开历史表格"] = "Open history table"
    L["打开历史表格汇总"] = "Open history table summary"
    L["|cff808080（CTRL+%s固定显示，长按SHIFT显示全服务器角色%s）|r"] = "|cff808080 (CTRL+%s fixed display, long press SHIFT to display full server Character %s)|r"
    L["|cff808080（CTRL+%s固定显示，长按SHIFT显示当前服务器角色%s）|r"] = "|cff808080 (CTRL+%s fixed display, long press SHIFT to display current server Character %s)|r"
    L["（%s修改评价，SHIFT+%s查询大众评价，ALT+%s删除评价）"] = "(%sChange Rating, SHIFT+%sQuery Mass Rating, ALT+%sDelete Rating)"
    L["查询大众评价"] = "Query mass rating"
    L["复制该号码"] = "Copy this number"
    L["|cffFFFFFF%s玩家名字：|r设置为买家"] = "|cffFFFFFF%sPlayer name: |rSet as buyer"
    L["|cffFFFFFFSHIFT+%s玩家名字：|r密语"] = "|cffFFFFFFSHIFT+%sPlayer Name:|rSecret Message"
    L["你关注的装备开始拍卖了：%s（%s取消关注）"] = "The Gear you are following has started an auction: %s (%s unfollow)"
    L["取消关注"] = "Unfollow"
    L["清除欠款"] = "Clear arrears"
    L["取消提示"] = "Cancel alerts"
    L["点击一个装备可以打开菜单"] = "Click on a Gear to open the menu"
    L["取消心愿装备"] = "Cancel Wish Gear"
    L["（删除心愿装备）"] = "(Delete a Wish Gear)"
    L["通知框体可还原位置"] = "The notification box can be restored to its original position"
    L["左键：打开历史表格"] = "Left button: open history table"
    L["右键：打开历史表格汇总"] = "Right click: open history table summary"
    L["匿名模式对你无效"] = "Anonymity mode does not work for you"
    L["勾选后，在竞拍过程中，匿名对你无效，你将可以直接看到实际出价人，不管你是团长还是团员。"] = "When checked, anonymity will not work for you during the bidding process, and you will be able to see the actual bidder directly, regardless of whether you are a group leader or a group member."
    L["拍卖过程中不会显示当前出价最高人是谁。拍卖结束后才会知晓|cff00ff00（团长可以无视匿名）|r"] = "The auction will not show who the current highest bidder is. You will not know until after the auction is over|cff00ff00 (the leader can ignore the anonymity)|r"
    L["v2.9：匿名模式下团长现在可以无视匿名。重复出价时现在需要点击确认框后才能出价"] = "v2.9: Heads can now ignore anonymity in anonymous mode. Repeat bids now require clicking the confirmation box before bidding."
    L["半匿名模式"] = "Semi-anonymous mode"
    L["欠款需要单独收取，不要和装备混在一起交易！否则账单错误！"] = "Outstanding payments need to be collected separately, do not mix transactions with Gear! Otherwise the bill will be incorrect!"
    L["|cffFF0000(欠款%d)|r"] = "|cffFF0000(amount owed %d)|r"
    L["交易金额不能为负数！"] = "Transaction amount cannot be negative!"
    L["在交易界面右侧增加以下界面"] = "Add the following screen to the right side of the transaction screen"
    L["记账效果预览框："] = "Bookkeeping effect preview box:"
    L["可以预览这次的记账效果。"] = "You can preview the effect of this bookkeeping."
    L["最近拍卖/对方已拍："] = "Recent Auctions/Counterparty Auctioned:"
    L["如果你是物品分配者，会显示最近拍卖且可交易的装备，点击一下就能把装备放到交易里。"] = "If you are the dispenser of the item, it will show you the most recent auction of the Gear that can be traded, and you can put the Gear into the trade by clicking on it."
    L["一键发工资："] = "One-Click Payroll:"
    L["增加一键发工资和补贴的按钮。"] = "Add a button to pay wages and allowances with one click."
    L["数据来源：\n|cffffffff%s秒|r前%s通报的账单"] = "Data source: \n|cffffffff%s seconds|r before %s notification of bills"
    L["已清除%s的全部欠款|cffFF0000%s|r。"] = "All arrears of %s cleared|cffFF0000%s|r."
    L["已清除%s的%s欠款|cffFF0000%s|r。"] = "Cleared %s of %s owed|cffFF0000%s|r."
    L["交易金额需要减去对方的总欠款吗？\n%s"] = "Does the transaction amount need to be reduced by the total amount owed by the other party? \n%s"
    L["对方还有|cffff0000%s|r欠款，还继续交易对方|cffffff00%s|r？"] = "The counterparty still has |cffff0000%s|r arrears and continues to trade the counterparty |cffffff00%s|r?"
    L["减去并清除欠款"] = "Subtract and clear the arrears"
    L["不减"] = "Do not subtract"
    L["仅显示高于该装等的装备："] = "Show only Gear above this mount :"
    L["团长是否正在交易"] = "Whether or not the team leader is trading"
    L["在团长的团队框架显示其是否正在交易。"] = "Displays whether or not a team leader is trading in their team frame."
    L["支持NDui、ElvUI、Cell、原生框架。"] = "Supports NDui, ElvUI, Cell, native frames."
    L["拍卖竞价窗口自动往上吸附"] = "Auction Bidding Window Auto Attachment"
    L["当靠前的窗口消失时，后面的窗口会自动往上吸附。"] = "When the front window Growl, the back window will be automatically adsorbed upwards."
    L["v2.8：现在点击折叠按钮时，会重新排列位置。缩短拍卖结束后窗口消失的时间"] = "v2.8: Now rearrange the position when clicking the collapse button. Reduced the time it takes for the window to Growl after the auction ends."
    L["v2.7：手动输入的最低价格限制回调到之前的数值。优化窗口折叠效果"] = "v2.7: Manually-entered minimum price limit is rolled back to the previous value. Optimized window collapsing effect"
    L["你的钱不够！"] = "You don't have enough money!"
    L["交易时自动填写交易金额"] = "Automatically fill in the transaction amount when trading"
    L["交易时，自定填写应付的交易金额。"] = "Customize the amount to be paid during the transaction."
    L["交易时自动确认交易"] = "Automatically confirm the transaction when trading"
    L["当交易金额等于应收/应付金额时，自动点击交易按钮。但屏幕中间的二次确认框还是需要你手动确认。"] = "Automatically click the transaction button when the transaction amount is equal to the receivable/payable amount. However, the secondary confirmation box in the middle of the screen still requires you to confirm manually."
    L["BiaoGe正在申请确认交易"] = "BiaoGe is requesting a trade confirmation"
    L["这是为了防止你看不到对方的拍卖聊天信息和自动拍卖出价消息。"] = "This is to prevent you from not seeing each other's auction chat messages and auto auction bid messages."
    L["自动移除屏蔽对象"] = "Automatically Remove Blocked Objects"
    L["使用自动拍卖时，如果某个团员在你的屏蔽列表里，则自动把它移出该列表。"] = "When using auto auction, if a group member is in your block list, it is automatically removed from that list."
    L["|cffa335ee史诗|r"] = "|cffa335ee epic|r"
    L["< |cff00D82F随机|r >"] = "< |cff00D82F Random|r >"
    L["团本：史诗难度"] = "Group: Epic difficulty"
    L["唤魔师-湮灭"] = "Evoker - Annihilation"
    L["唤魔师-恩护"] = "Evoker - Enchantment"
    L["唤魔师-增辉"] = "Demon Hunter - Enrichment"
    L["恶魔猎手-浩劫"] = "Demon Hunter - Havoc"
    L["恶魔猎手-复仇"] = "Demon Hunter - 'Sharp Weapon +5"
    L["武僧-酒仙"] = "Warrior Monk - Wine Fairy"
    L["武僧-织雾"] = "Warrior Monk - Mistweaver"
    L["武僧-踏风"] = "Warrior Monk - Wind Treader"
    L["战刃"] = "Warblade"
    L["请你删除aaa插件，该插件会破坏系统的通讯功能，导致其他插件功能失效。"] = "Please remove the aaa plugin, this plugin breaks the system's communication function and causes other plugins to function as 'Spell Penetration 150 Frost Resist'."
    L["v2.6：拍卖窗口刷新时，不再重新排列全部窗口，而是保持原位不变"] = "v2.6: When the auction window is refreshed, it will no longer rearrange all the windows, but keep them in their original position."
    L["一键发工资"] = "One click payday"
    L["交易"] = "Transactions"
    L["确认交易%s%sg？"] = "Confirm transaction %s%sg?"
    L["单人工资"] = "Single person payroll"
    L["%s人工资"] = "%sPerson payroll"
    L["一键发工资"] = "One click payroll"
    L["在交易界面右上角，增加一键发工资和补贴的按钮，仅团长可见。"] = "In the top right corner of the trading screen, add buttons for one-click payroll and subsidies, visible only to the head."
    L["你没有启用WeakAurasOptions插件。"] = "You do not have the WeakAurasOptions plugin enabled."
    L["你没有安装WeakAuras插件。"] = "You do not have the WeakAuras plugin installed."
    L["需要按下SHIFT才能发送WA。"] = "You need to press SHIFT to send WA."
    L["在你的WA面板里未找到拍卖WA字符串，你需要先从表格左上角的\"拍卖WA\"按钮导入该字符串。"] = "The Auction WA string is not found in your WA panel, you need to import it first from the 'Auction WA\' button in the top left corner of the form."
    L["鼠标左键："] = "Left mouse button:"
    L["一键导入WA字符串"] = "Import WA string with one click"
    L["鼠标右键："] = "Right mouse button:"
    L["复制WA字符串"] = "Copy WA string"
    L["（WA面板尚未初始化）"] = "(WA panel has not been initialized)"
    L["（WA面板正在初始化：%s/%s）"] = "(WA panel is initializing: %s/%s)"
    L["（WA面板已初始化，可以发送了）"] = "(WA panel initialized and ready to send!)"
    L["SHIFT+点击：把WA字符串通过密语发送给没有的团员。"] = "SHIFT+click: send the WA string via cryptic message to a corp member who doesn't have it."
    L["太阳井"] = "Sunwell"
    L["错误"] = "Error"
    L["装等-名字"] = "Attire-Name"
    L["职业-名字"] = "Occupation-Name"
    L["名字"] = "Name"
    L["自定义排序"] = "Custom sorting"
    L["修改排序"] = "Modify Sort"
    L["已拍未交易"] = "Auctioned but not traded"
    L["已把%s从屏蔽名单中移除，防止你看不到对方的拍卖聊天信息。"] = "Removed %s from the block list to prevent you from seeing each other's auction chat messages."
    L["记录"] = "Records"
    L["拍卖成功的聊天消息后面增加[出价记录]"] = "Added [Bid Record] to the chat messages after successful auctions."
    L["鼠标悬停在[出价记录]时会显示该装备的出价记录。"] = "When hovering over [Bid Record], it will show the bid record of the Gear."
    L["自动清空表格时保存表格"] = "Save Forms when Auto Clearing Forms"
    L["进本自动清空表格时，把表格保存至历史表格1。"] = "When you enter this Auto Clear Form, the form will be saved to History Form 1."
    L["取消勾选则不会保存表格。"] = "Unchecking this box will not save the form."
    L["不显示低于该装等的角色："] = "Do not show Characters below this level:"
    L["|cffFFFFFF安装WA：|r此WA是团员端，用于接收团长发出的拍卖消息，没安装的团员显示不了拍卖UI。请团长安装该WA字符串后发给团员安装。如果团员已经安装了BiaoGe插件，可以不用安装该WA。"] = "|cffFFFFFFInstall WA:|rThis WA is the member's side, used to receive the auction message from the leader, without installing it, the member can not display the auction UI. please ask the leader to install this WA string and send it to the members to install. If you have already installed BiaoGe plugin, you don't need to install this WA."
    L["v2.5：拍卖金额超过1万时会进行缩写。ALT+点击折叠时，会对全部拍卖窗口折叠"] = "v2.5: Auctions are abbreviated when they exceed 10k. ALT+click to collapse will collapse the entire auction window."
    L["历史最大金币"] = "Historical Maximum Gold"
    L["工程技能点"] = "Engineering Skills Points"
    L["获得小宠物数量"] = "Legendary items acquired' quantity"
    L["<BiaoGe> 已自动清空表格< %s >，分钱人数已改为%s人。"] = "<BiaoGe> has automatically cleared the table < %s > and the number of people splitting money has been changed to %s of people."
    L["你的BiaoGe插件存在问题，请删除本地插件再重新安装一次（需要大退）。"] = "There is a problem with your BiaoGe plugin, please delete the local plugin and reinstall it again (requires a major regression)."
    L["团员名单"] = "Group Membership List"
    L["< 交易记账成功 >|r\n装备：%s\n买家：%s\n金额：%s%d|rg%s\nBoss：%s%s|r"] = "< Record Success >|r\nGear : %s\nBuyer : %s\nAmount : %s%d|rg%s\nBoss : %s%s|r"
    L["|cff00BFFF< 快速记账成功 >|r\n|cffFFFFFF装备：%s\n买家：%s\n金额：%s%s\nBoss：%s"] = "|cff00BFFF< Quick Bookkeeping Success >|r\n|cffFFFFFFGear : %s\nBuyer: %s\nAmount: %s%s\nBoss: %s"
    L["ALT+点击：复制账单|cff00FF00（仅对装备收入有效）|r"] = "ALT+Click: copy bill |cff00FF00 (valid only for Gear income)|r"
    L["游戏："] = "Game:"
    L["SHIFT+点击：查看该BOSS攻略"] = "SHIFT+Click: View this Boss strategy guide"
    L["角色配置"] = "Configuration"
    L["一键显示"] = "One-Click Display"
    L["在AtlasLoot主界面的右边，增加多个快捷按钮，点击后直接显示相应页面。"] = "On the right side of the main interface of AtlasLoot, add several shortcut buttons to display the corresponding page directly after clicking."
    L["比如珠宝按钮，点击后直接显示珠宝页面。"] = "For example, the Jewelry button, when clicked, directly displays the Jewelry page."
    L["十字军"] = "Crusader"
    L["T9套"] = "T9 set"
    L["精华"] = "Essence"
    L["已交易"] = "Traded"
    L["设为未交易"] = "Set as untraded"
    L["设为已交易"] = "Set as Traded"
    L["交易时不再显示该装备的应收/应付金额，团长也不会自动摆放该装备。"] = "The amount due to/from the Gear will no longer be displayed during the transaction, and the Gear will not be automatically placed by the leader."
    L["对方已拍"] = "Cpty Bid"
    L["\n背包里没有该件物品"] = "\nThere is no such item in the backpack."
    L["自动拍卖价格：%s"] = "Auto Auction Price: %s"
    L["|cffFFFFFF右键：|r复制该号码"] = "|cffFFFFFF right click: |r copy the number"
    L["提醒：你可能还没拾取刚击杀BOSS的掉落哦！"] = "Reminder: You may not have picked up the 'Killing Blows' boss drop!"
    L["装备未拾取提醒"] = "Gear Not Picked Up Reminder"
    L["击杀BOSS超过30秒装备还没拾取，且你是物品分配者时，屏幕中间红字提醒。"] = "If the 'Killing Blows' boss has not been picked up for more than 30 seconds and you are the item dispenser, you will be alerted in red in the center of the screen."
    L["按下ALT/SHIFT/CTRL时不会自动一键分配。"] = "You will not be automatically dispatched when ALT/SHIFT/CTRL is pressed."
    L["你%s秒前曾交给他相同的金币！"] = "You%s seconds ago had handed him the same amount of gold!"
    L["重复交易"] = "Repeat transaction"
    L["重复交易！"] = "Repeat transaction!"
    L["重复交易工资提醒"] = "Repeat transaction payroll reminder"
    L["如果2分钟内你曾与同一个人交易过相同的金币，会有红字提醒。"] = "If you have traded the same gold coin with the same person within 2 minutes, you will be reminded in red."
    L["交流群"] = "QQGroup"
    L["BiaoGe沟通交流群"] = "BiaoGe Communication Group"
    L["BiaoGe插件未来的更新计划共享在在线文档。"] = "BiaoGe plugin's future update plan is shared in an online document."
    L["你可以浏览该内容，留下你的建议。"] = "You can browse that content and leave your suggestions."
    L["你可以在这里订阅我的账号苍穹之霜，提前体验订阅模块和同步模块。"] = "You can subscribe to my account Cang Dome Frost here to experience the subscription module and synchronization module in advance."
    L["团长YY(根据聊天记录生成)"] = "Group Leader YY (generated from chat logs)"
    L["上下布局"] = "Top-down layout"
    L["左右布局"] = "Left/Right Layout"
    L["角色总览的布局方式："] = "Layout of Character Overview:"
    L["打开/关闭表格"] = "Open /rf Form"
    L["打开/关闭角色总览"] = "Open /rf Character Overview"
    L["密码：金团表格"] = "Password: Golden Corps Forms"
    L["插件加载错误，请查看右下角的红字报错，把报错内容截图发给作者，谢谢。（Q群：322785325，密码：金团表格）"] = "Plugin loading error, please check the bottom right corner of the red error report, send a screenshot of the reported content to the author, thank you. (Q group: 322785325, password: Golden Mission Form)"
    L["|cff808080（CTRL+左键固定显示，长按SHIFT显示全服务器角色%s）|r"] = "|cff808080 (CTRL+Left click fixed display, long press SHIFT to display full server Character %s)|r"
    L["|cff808080（CTRL+左键固定显示，长按SHIFT显示当前服务器角色%s）|r"] = "|cff808080 (CTRL+Left click to fix display, long press SHIFT to display current server Character %s)|r"
    L["当前服务器角色"] = "Current Server Character"
    L["全部服务器角色"] = "All Server Characters"
    L["角色总览的默认显示："] = "The default display for the Character overview:"
    L["未知服务器"] = "Unknown Server"
    L["|cff808080（CTRL+左键固定显示，长按SHIFT显示全服务器角色%s）|r"] = "|cff808080 (CTRL+Left click to fix display, long press SHIFT to display all server Character %s)|r"
    L["太阳井"] = "Sunwell"
    L["黑庙"] = "Black Temple"
    L["海山"] = "Sea Mountain"
    L["风暴"] = "Storm"
    L["毒蛇"] = "Venomstrike"
    L["格鲁尔"] = "Gruul"
    L["玛胖"] = "Mafia"
    L["祖阿曼"] = "Zul'Aman"
    L["卡拉赞"] = "Karazhan"
    L["平台"] = "Platform"
    L["塞泰克"] = "Setec"
    L["安其拉"] = "Angela"
    L["废墟"] = "Ruins"
    L["黑翼"] = "Blackwing"
    L["熔火"] = "Molten Fire"
    L["祖格"] = "Zug"
    L["纳克萨玛斯"] = "Naxxramas"
    L["熔火之心"] = "Molten Core"
    L["|cff808080（右键打开设置，CTRL+左键固定显示%s）|r"] = "|cff808080 (right click to open settings, CTRL+left click to fix display %s)|r"
    L["|cff808080（左键打开表格，右键打开设置，CTRL+左键固定显示%s）|r"] = "|cff808080 (left click to open table, right click to open settings, CTRL+left click to fix display %s)|r"
    L["25红玉"] = "25 Carnelian"
    L["10红玉"] = "10 Red Jade"
    L["25冰冠"] = "25 Ice Crown"
    L["10冰冠"] = "10 Ice Crown"
    L["25十字军"] = "25 Crusader"
    L["10十字军"] = "10 Crusader"
    L["25黑龙"] = "25 Black Dragon"
    L["10黑龙"] = "10Black Dragon"
    L["25奥杜尔"] = "25Ulduar"
    L["10奥杜尔"] = "10Ulduar"
    L["25纳克"] = "25Nak"
    L["10纳克"] = "10Nak"
    L["25蓝龙"] = "25Blue Dragon"
    L["10蓝龙"] = "10Blue Dragon"
    L["25黑曜石"] = "25 Obsidian"
    L["10黑曜石"] = "10 Obsidian"
    L["25宝库"] = "25 Treasure Trove"
    L["10宝库"] = "10 Treasure Chest"
    L["你可以在这里订阅我的账号苍穹之霜。"] = "You can subscribe to my account Frost of the Vault here."
    L["订阅模块"] = "Subscription Module"
    L["同步模块"] = "Synchronized Modules"
    L["炼金研究"] = "Alchemical Research"
    L["大雕文"] = "Large Sculptures"
    L["小雕文"] = "Minor Sculptures"
    L["冰冻棱柱"] = "Banshee Curse' Prisms"
    L["泰坦精钢"] = "Titan Steel"
    L["熔炉"] = "Furnace"
    L["法纹布"] = "Fabric"
    L["乌纹布"] = "Ebony Cloth"
    L["月影布"] = "Moonshadow Cloth"
    L["冰川背包"] = "Glacier Backpack"
    L["删除角色总览数据"] = "Delete Character Overview"
    L["，长按ALT仅显示本账号角色"] = "If you press and hold ALT, it will only show the Character of your account."
    L["以及多个没有留名的爱发电用户"] = "and many other users who have not left their names on the list."
    L["自动加入集结号频道"] = "Auto Join Rally Channel"
    L["进入游戏后，自动加入集结号频道，让你提前获取组队消息。"] = "When you enter the game, you will automatically join the Rally channel, so that you can get the group news in advance."
    L["而且，关闭集结号界面时不会自动退出该频道，这样可以一直同步组队消息，让你随时打开集结号都能查看全部活动。"] = "Moreover, the channel will not be automatically exited when rfing the Rally interface, so that you can always synchronize the group news, so that you can check all the activities whenever you open the Rally."
    L["标记已密语过的活动"] = "Superior Mana' activity that has already been whispered."
    L["如果你在最近15分钟内曾经密语过团长，那么该活动的说明变为灰色。"] = "If you have ever whispered to the leader in the last 15 minutes, the description of that activity turns gray."
    L["你不是物品分配者，不能使用。"] = "You are not an item dispenser and cannot use it."
    L["不在团队中，不能使用。"] = "You are not in a team and cannot use it."
    L["把全部可交易的物品分配给自己。"] = "Assign all tradable items to yourself."
    L["没有符合条件的物品。"] = "There are no eligible items."
    L["贝塔"] = "Beta."
    L["上传后你可以在|cff00ff00新手盒子-工具箱-云账单|r进行查看。"] = "After uploading you can view it at |cff00ff00 Novice Box - Toolbox - Cloud Bills|r."
    L["账单已上传到新手盒子！你可以在|cff00ff00新手盒子-工具箱-云账单|r进行查看！感谢你的支持！"] = "The bill has been uploaded to the Novice Box! You can view it at |cff00ff00NewbieBox-Toolbox-CloudBills|r! Thank you for your support!"
    L["把当前表格（账单）上传到新手盒子。你将可以随时查阅该账单，也可以把账单生成链接发给别人。"] = "Upload the current form (bill) to the Novice Box. You will be able to access that bill at any time and also send the bill generation link to others."
    L["插件加载错误，请查看右下角的红字报错，把报错内容截图发给作者，谢谢。（Q群322785325）"] = "Plugin loading error, please check the bottom right corner of the red letter to report the error, send a screenshot of the report to the author, thank you. (Q group 322785325)"
    L["插件加载错误，请把报错发给作者，谢谢。（Q群322785325）\n\n如果你不知道怎么看报错，请你安装BugSack和BugGrabber插件。"] = "Plugin loading error, please send the error report to the author, thank you. (Q Group 322785325)\n\nIf you don't know how to see the reported error, please install BugSack and BugGrabber plugin."
    L["（点击复制Q群）"] = "(Click to copy Q group)"
    L["装等-职业-名字"] = "Class-Name-Occupation-Name"
    L["装等-名字-职业"] = "Attire-Name-Occupation"
    L["职业-装等-名字"] = "Occupation-Professional-Name"
    L["职业-名字-装等"] = "Occupation-Name-Fit etc."
    L["名字-装等-职业"] = "Name-Plus-Professional"
    L["名字-职业-装等"] = "Name-Occupation-Professional"
    L["角色总览的排序方式："] = "How the Character overview is sorted:"
    L["不显示低于该等级的角色："] = "Do not show Character below this level :"
    L["v2.4：3千-5千的加价幅度改为100，3万-5万的加价幅度改为1000"] = "v2.4: Change the markup for 3k-5k to 100, and for 30k-50k to 1000"
    L["把当前表格（账单）上传到|cff00ff00新手盒子|r。你将可以在新手盒子随时查阅该账单，也可以把账单生成链接发给别人。（该云端账单即将上线）。"] = "Upload the current table (bill) to |cff00ff00 newbie box|r. You will be able to access the bill at any time in the newbie box, or send the bill generation link to others. (This cloud bill will be available soon)."
    L["上传前请你确保新手盒子正在运行。"] = "Please make sure your box is running before uploading."
    L["也可以在这里订阅我的账号苍穹之霜，提前体验BiaoGeVIP插件。"] = "You can also subscribe to my account Cthulhu Frost here to experience the BiaoGeVIP plugin in advance."
    L["未知买家"] = "UnknownBuyer"
    L["未知装备"] = "UnknownGear"
    L["新手盒子"] = "NewbeeBox"
    L["集插件管理、配置分享、云端备份、游戏攻略、游戏工具于一体。"] = "A collection of plugin management, configuration sharing, cloud backup, game tips, and game tools."
    L["也可以在这里获取BiaoGeVIP订阅模块插件。"] = "You can also get the BiaoGeVIP subscription module plugin here."
    L["在查询名单列表中增加查询记录。"] = "Add query records in the query list list."
    L["在查询名单列表中增加导出名单功能（可用于在官网进行批量举报）。"] = "Add export list function in query list list (can be used for batch reporting on official website)."
    L["导出名单"] = "Export List"
    L["导出本次查询的所有名单，可以在官网进行批量举报，比游戏里举报更有效。"] = "Export all the lists of this query, which can be used for batch reporting in the official website, which is more effective than in-game reporting."
    L["你可在插件设置-BiaoGe-其他功能-查询记录里关闭这个功能。"] = "You can rf this function in Plugin Settings - BiaoGe - Other Functions - Query Records."
    L["关闭名单"] = "rf list"
    L["官方举报地址（比游戏里举报更有效）："] = "Official reporting address (more effective than in-game reporting):"
    L["网易DD"] = "NetEase DD"
    L["官方插件平台"] = "Official Plugin Platform"
    L["集插件管理、配置分享、云端备份、团队语音于一体。"] = "Set plugin management, configuration sharing, cloud backup, team voice in one."
    L["你可以在这里更新BiaoGe插件。"] = "You can update BiaoGe plugins here."
    L["查询失败！CD"] = "Query Failed!"
    L["(重载后生效)"] = "(Effective after reloading)"
    L["v2.3：拍卖框体右上角的隐藏按钮改为折叠按钮"] = "v2.3: The 'Corrupted Stamina Passive' button in the top right corner of the auction box has been changed to a collapsed button."
    L["提交BUG"] = "Submit Bug"
    L["有报错！"] = "There are errors reported!"
    L["邮箱："] = "Mailbox:"
    L["Q群："] = "Q-group:"
    L["（点击复制）"] = "(Click to copy)"
    L["报错"] = "Report a bug"
    L["请你把该报错截图发给作者"] = "Could you please send a screenshot of the error to the author?"
    L["版本："] = "Version:"
    L["错误："] = "Error:"
    L["栈："] = "Stack:"
    L["爱发电"] = "AidouPower"
    L["感谢以下玩家的发电："] = "Thanks to the following players for generating power:"
    L["（点击复制网址）"] = "(Click to copy URL)"
    L["团长或物品分配者ALT+点击背包/表格/聊天框装备，来打开拍卖面板。"] = "Group Leader or Item Dispenser ALT+click on the backpack/form/chat box Gear to open the Auction Panel."
    L["使用组合键打开团长拍卖面板"] = "Use the 'Glowy (Purple)' key to open the leader's auction panel."
    L["一键开拍"] = "Open Auction with one click"
    L["在团长拍卖面板里，增加多个价格按钮，点击后直接按该价格开始拍卖。"] = "Add multiple price buttons in the Head Auction panel, click on them to start the auction at that price."
    L["v2.2：按加价时，可以直接把出价设置为合适的价格"] = "v2.2: When you press raise, you can directly set the bid to the appropriate price."
    L["物理命中"] = "Physical Strike"
    L["物理爆击"] = "Physical 'Critical Strike"
    L["法术强度"] = "Spell Strength"
    L["治疗强度"] = "Fire Blast' Strength"
    L["法强+奶强"] = "Spell Strength 'Fire Blast' Strength"
    L["仅加法强，不加奶强，治疗需要过滤此词缀"] = "Only adds spell strength, not milk strength. 'Fire Blast' needs to be filtered for this affix."
    L["这个词缀是赛季服新增的，指物理和法系的命中，治疗需要过滤此词缀"] = "Fire Blast' needs to be filtered for this suffix, which is new for the season and refers to physical and legal hits."
    L["法术和效果造成的治疗提高"] = "Fire Blast' is increased for spells and effects."
    L["未知"] = "Unknown"
    L["褪色的安德麦雷亚尔"] = "Faded Andromeda Real"
    L["世界Boss"] = "World Boss"
    L["说明书"] = "Manual"
    L["<历史表格>"] = "<History Table>"
    L["<BiaoGe> 金团表格"] = "<BiaoGe>"
    L["这个词缀是指“法术治疗提高最多x点，法术伤害提高最多x点”，法系DPS一般需要过滤此词缀"] = "This term means 'Fire Blast' increases spell damage by up to x points', which is usually filtered for spell DPS."
    L["风王子"] = "Wind Prince"
    L["黑龙"] = "Black Dragon"
    L["蓝龙"] = "Blue Dragon"
    L["卡扎克"] = "Lord Kazzak"
    L["使用组合键打开拍卖面板"] = "Use the 'Glowy (Purple)' key to open the auction panel."
    L["团长/物品分配者ALT+点击背包/表格/聊天框装备，来打开拍卖面板。"] = "Troupe Leader/Item Dispenser ALT+click on the backpack/form/chat box Gear to open the auction panel."
    L["出价记录"] = "Bid Record"
    L["、"] = "Bids are recorded,"
    L["复制活动说明"] = "Copy the event description"
    L["在聊天频道玩家的右键菜单里增加[密语模板]按钮。"] = "Add [Secret Message Template] button to the right-click menu of chat channel players."
    L["在聊天输入框的右键菜单里增加[密语模板]按钮。"] = "Add [Secret Message Template] button to the right-click menu of chat input box."
    L["在集结号活动的右键菜单里增加[邀请][复制活动说明]按钮。"] = "Add [Invite][Copy Event Description] button to the right-click menu of Rally events."
    L["在团长的右键菜单里增加[进入DD语音房间]按钮。"] = "Add [Enter DD Voice Room] button to the right-click menu of the leader."
    L["进入DD语音"] = "Enter DD Voice"
    L["进入团长的DD语音房间"] = "To enter the leader's DD voice room"
    L["需要你在后台已打开网易DD，否则进入失败。\n\n|cff808080你可在插件設置-BiaoGe-其他功能-密語模板裡關閉這個功能。|r"] = "Requires you to have opened Netflix DD in the background, otherwise entry fails. \n\n|cff808080You can turn off this function in Plugin Settings-BiaoGe-Other Functions-Secret Message Template. |r"
    L["罚款"] = "Fine"
    L["点击记入杂项"] = "Click to credit Miscellaneous"
    L["YY："] = "YY:"
    L["评价："] = "Rating:"
    L["理由："] = "Reason:"
    L["选填(备注仅自己可见)"] = "Optional (remarks are visible only to you)"
    L["清空表格时携带的金币"] = "Gold coins carried when clearing the form"
    L["清空表格时的金币： "] = "Gold coins when clearing the form:"
    L["角色："] = "Character :"
    L["时间："] = "Time:"
    L["金币："] = "Gold Coin:"
    L["表格："] = "Form:"
    L["清空表格时保留支出金额"] = "Keep spending amount when clearing form"
    L["如果你们团每次支出的金额都是固定的，可以勾选此项。"] = "If your group spends a fixed amount each time, you can check this item."
    L["v2.1：如果你的出价太低时，出价框显示为红色"] = "v2.1: If your bid is too low, the bid box is displayed in red color"
    L["备注:"] = "Remarks."
    L["备注"] = "Remarks"
    L["备注仅自己可见。"] = "Remarks are only visible to you."
    L["作者不再更新该版本及后续版本的装备库，实在抱歉。"] = "The author is no longer updating the Gear library for this and subsequent versions, sorry about that."
    L["v2.0：重做进入动画；按组合键时可以发送或观察装备"] = "v2.0: Reworked the entry animation; you can send or watch Gear when pressing 'Glowy (Purple)'."
    L["司卡奇"] = "Sikaki"
    L["匕首岭-<TIMEs>贝西"] = "Daggers Ridge-<TIMES>Bessie"
    L["|cffFFFFFF买家：|r"] = "|cffFFFFFF buyer:|r"
    L["万"] = "Wan"
    L["拥有传说物品"] = "Possession of Lore Items"
    L["团员成就："] = "Troupe Achievements:"
    L["查看团员的团本成就完成情况"] = "See group members' group achievements completed"
    L["团员成就"] = "Troupe Member Achievements"
    L["< 团员成就 >"] = "< Achievements"
    L["交易时自动摆放装备"] = "Automatically place Gear when trading"
    L["交易时，如果你是物品分配者，会自动把对方所拍装备摆放到交易框。"] = "When trading, if you are the dispenser of the item, you will automatically place the item in the trade box."
    L["交易时显示应收或应付金额"] = "Displaying the amount due when trading"
    L["交易时，根据对方或你所拍装备显示应收或应付金额。"] = "When you trade, the amount due is displayed according to the Gear you or your partner is bidding on."
    L["交易时自动记录欠款"] = "Automatically record the amount owed during the transaction"
    L["交易时，会自动记录欠款。"] = "When you trade, the amount due is automatically recorded."
    L["最大金币数量"] = "Most gold ever owned"
    L["获得坐骑数量"] = "Vanity pets owned"
    L["成\n就"] = "Achieve\n-ment"
    L["统\n计"] = "Unity\nCount"
    L["成就："] = "Achievement:"
    L["没有成就"] = "No Achievement"
    L["统计："] = "Statistics :"
    L["距离太远读取失败"] = "Failed to read from too far away"
    L["刷新数据"] = "Refresh Data"
    L["正在刷新"] = "Refreshing"
    L["离线"] = "Offline"
    L["数字小键盘"] = "Numeric keypad"
    L["在可以输入数字的地方，自动显示一个数字小键盘。用鼠标就能完成数字的输入。"] = "Automatically displays a numeric keypad where numbers can be entered. The input of numbers can be done with the mouse."
    L["指挥很好"] = "Very good command."
    L["非常效率"] = "Very 'Ice Totem'."
    L["没有团双"] = "No regimental double"
    L["团长很帅"] = "The commander is very handsome."
    L["团长很有耐心"] = "The commander is patient."
    L["指挥很烂"] = "The conductor sucks."
    L["拼多多团"] = "Poundland Troupe"
    L["强X装备"] = "Strong XGear"
    L["黑金"] = "Black Gold"
    L["毛装备"] = "Hairy Gear"
    L["只罚野人不罚亲友"] = "Punish only the wildlings and not their friends and family"
    L["稳如老狗"] = "Steady as an old dog"
    L["又快又黑=。="] = "Fast and black =. =."
    L["查看团员的团本成就完成情况（该功能引用于比较成就里的API）"] = "To view a corp member's corp achievement completion (this function references the API in Compare Achievements)"
    L["<未拍>"] = "<Untapped>"
    L["未拍"] = "Not"
    L["开始拍卖"] = "Start Auction"
    L["设为流拍"] = "Set as unsold"
    L["设为已拍"] = "Set as Auctioned"
    L["增加记录"] = "Add record"
    L["<正在拍卖>"] = "<Auctioning"
    L["离线"] = "Offline"
    L["操作提示："] = "Action Tip:"
    L["右键点击一个装备可以打开菜单"] = "Right click on a Gear to open the menu"
    L["在未拍列表可以按住CTRL、SHIFT来多选装备，便于团长批量发起拍卖"] = "You can hold down CTRL and SHIFT to select more Gears in the Unauctioned list, which is convenient for the leader to launch auctions in bulk."
    L["拍卖：%s"] = "Auction: %s"
    L["装备记录通知"] = "Gear Record Notification"
    L["自动记录装备后会在屏幕上方显示记录了什么装备、记录在哪个BOSS槽位。"] = "Automatically logging Gear will show what Gear is logged and in which Boss slot at the top of the screen."
    L["没有wc1记录"] = "No wc1 record"
    L["———通报wc1———"] = "----Notify wc1----"
    L["通报心愿"] = "Notify Wish"
    L["———我的心愿———"] = "---My Wish----"
    L["没有心愿"] = "No Wish"
    L["由于%s多次点击WA链接，不再提示他的相关文本了。"] = "Due to %s multiple clicks on the WA link, no longer prompting for his associated text."
    L["手动增加记录"] = "Adding records manually"
    L['添加装备'] = "添加裝備"
    L["按住Shift+点击表格/背包/聊天框装备；直接把装备拖到格子里"] = "Hold Shift+click on form/backpack/chat box Gear; drag Gear directly to the grid"
    L["自动拍卖"] = "AutoAuction"
    L["调整自动拍卖UI的大小。"] = "Improved Gouge' automatically auctions the size of the UI."
    L["v1.9：增加一个绿色钩子，用来表示你是否已经拥有该物品"] = "v1.9: add a green hook to indicate if you already have the item or not"
    L["没有WCL记录"] = "No record of WCL"
    L["———通报WCL———"] = "--- Inform WCL ---"
    L["更新日期"] = "Update Date."
    L["你没有安装WclPlayerScore-WotLK-CN插件。"] = "You do not have the WclPlayerScore-WotLK-CN plugin installed."
    L["拍卖自动倒数"] = "Auction auto countdown"
    L["倒数自动暂停"] = "Countdown is automatically 'Summon Tamed Boar'."
    L["正在自动倒数时，如果有人出价（在团队频道打出纯数字时），则自动暂停倒数。"] = "During the autocountdown, if a bid is placed (when a plain number is typed in the team channel), the countdown is automatically 'Summon Tamed Boar'."
    L["删除该账单"] = "Delete this bill"
    L["正在接收拍卖WA"] = "Receiving Auction WA"
    L["接收完毕，但未导入"] = "Received, but not imported"
    L["%s正在接收拍卖WA。"] = "Auction WA is being received."
    L["%s已成功导入拍卖WA。"] = "%s has successfully imported the auction WA."
    L["v1.8：增加出价记录；UI缩小了一点；提高了最小加价幅度"] = "v1.8: Add bid log; UI 'Iron Shield Spike' a bit; Increase the minimum bidding range."
    L["当前难度："] = "Curr Diff: "
    L["账单"] = "Bills"
    L["用时"] = "Time spent"
    L["消费"] = "Purch"
    L["欠款"] = "Debt"
    L["通报："] = "Notification:"
    L["撤销删除"] = "Undo Delete"
    L["撤销删除当前绿色高亮格子的内容。"] = "Undo the deletion of the current green highlighted grid."
    L["v1.7：增加自动出价功能"] = "v1.7: Add auto-bidding function"
    L["自动拍卖合计收入：|cff%s%s|r"] = "Auto auction total Income: |cff%s%s|r"
    L["上传账单"] = "Upload Bill"
    L["把当前表格的数据上传到|cff00ff00新手盒子|r。每件装备的拍卖价格也将有助于新手盒子建立市场平均价，使其他玩家更了解市场行情。"] = "Upload the data from the current table to |cff00ff00NewbieBox|r. The auction price of each Gear will also help NewbieBox to establish the average market price, so that other players will have a better understanding of the market situation."
    L["如果有自动拍卖记录，则也会被清空。"] = "If there is an auto auction record, it will be cleared as well."
    L["v1.6：增加显示正在拍卖的装备类型"] = "v1.6: Add display of the type of Gear being auctioned off"
    L["拍卖记录"] = "AucLog"
    L["自动拍卖装备（拍卖WA）的记录。"] = "Records for Auto Auction Gear (Auction WA)."
    L["自动拍卖装备（拍卖WA）的记录。该记录会跟随清空表格一起被清空，也会跟随保存表格一同保存到历史表格。"] = "A record of an Auto Auction Gear (Auction WA). The record will be cleared along with the Empty form, and will also be saved to the History form along with the Save form."
    L["按住ALT+右键：删除某条记录"] = "ALT+Right: Deletes a record."
    L["全部"] = "All"
    L["成功"] = "Suc"
    L["流拍"] = "Fail"
    L["生成表格账单"] = "Generate Form Billing"
    L["根据自动拍卖记录，直接覆盖表格里每件装备所对应的买家和金额。"] = "Overwrite the buyer and amount for each Gear in the table directly from the automated auction records."
    L["生成对账单"] = "Generate Statement"
    L["根据自动拍卖记录，生成一个对账单。"] = "Generates a statement based on the Auto Auction records."
    L["没有自动拍卖记录。"] = "There are no auto auction records."
    L["历史自动拍卖记录"] = "Historical Auto Auction History"
    L["<流拍>"] = "<Failed Auctions>"
    L["合计收入："] = "Total Inc:"
    L["应收："] = "Receivable:"
    L["合计应收："] = "Aggregate receivable:"
    L["应付："] = "Payable:"
    L["合计应付："] = "Total payables:"
    L["对方欠款记录"] = "Cpty Debt Recs"
    L["交易时，如果对方曾有欠款，则会在交易框下方显示其欠款记录，点击可以清除欠款。"] = "If the counterparty owes money to you, a record of the amount owed will be displayed at the bottom of the transaction box, and you can click on it to clear the amount owed."
    L["刷新"] = "Refresh"
    L["合计欠款："] = "Total Owed:"
    L["清除全部欠款"] = "Clears the entire amount owed"
    L["清除"] = "Clear"
    L["已清除%s的%s欠款|cff00FF00%s|r。"] = "Cleared %s of %s owed|cff00FF00%s|r."
    L["确认清除%s的全部欠款吗？\n欠款合计：|cffFF0000%s|r"] = "Confirm clearing all arrears for %s? \n Total arrears: |cffFF0000%s|r"
    L["已清除%s的全部欠款|cff00FF00%s|r。"] = "Cleared all arrears for %s |cff00FF00%s|r."
    L["（重载界面后生效）"] = "(Effective after reloading the interface)"
    L["该BOSS攻略提供：@祈福-太乙公会 大树\n点击复制NGA攻略地址"] = "This boss cheat is provided by @'Use Bauble' -Taiyi Guild Daishu\n Click to copy NGA cheat address"
    L["最近拍卖"] = "Recent Auctions"
    L["交易时，如果你是物品分配者，在交易框右边会显示最近拍卖且可交易的装备，点击一下就能把装备放到交易里。"] = "When trading, if you are the item dispenser, the recently auctioned and tradable Gear will be displayed on the right side of the trade box , click on it to put the Gear into the trade."
    L["把对方账单的金额覆盖我当前表格的金额。如果对方是BiaoGe插件的账单，则也会复制其买家。"] = "Overwrite the amount of the other party's bill with the amount of my current form. If the other party is billed by the BiaoGe plugin, it will also copy its buyer."
    L["（你当前版本是%s，无需下载）"] = "(Your current version is %s, no download required)"
    L["点击按钮后会把全部可交易的物品分配给自己（橙片、任务物品等不会自动分配）。"] = "Clicking the button will assign all tradable items to yourself (orange slices, Quests items, etc. are not automatically assigned)."
    L["把当前表格的数据上传到新手盒子。每件装备的拍卖价格也将有助于新手盒子建立市场平均价，使其他玩家更了解市场行情。"] = "Upload the data from the current table to the Newbie Box. The auction price of each Gear will also help the Novice Box establish the average market price, so that other players are more aware of the market conditions."
    L["已自动取消%s的关注和心愿。"] = "Has automatically unfollowed %s and wishes."
    L["已自动取消%s的关注。"] = "Has automatically unfollowed %s."
    L["已自动取消%s的心愿。"] = "Wish has been automatically canceled for %s."
    L["聊天频道显示星团长标记"] = "Superior Mana' is displayed in chat channels."
    L["在聊天频道（综合、组队等）/鼠标提示工具/目标右键菜单中，显示星团长标记。"] = "Show 'Superior Mana' in chat channels (General, Groups, etc.) / Mouse Tip Tools / Target context menu."
    L["需要集结号v2.0.0或以上版本才能生效。"] = "Requires Rally v2.0.0 or above to take effect."
    L["正在上传"] = "Uploading"
    L["已上传"] = "Uploaded"
    L["未上传"] = "Not uploaded"
    L["团本锁定ID"] = "Group 'Increase Spell Dam 16' ID"
    L["账单表格："] = "Billing form:"
    L["创建时间："] = "Creation time:"
    L["创建人："] = "Created by:"
    L["团长："] = "The leader of the group:"
    L["上传状态："] = "Upload Status:"
    L["创建账单"] = "Create Bill"
    L["使用当前表格的数据创建一个账单，用于上传新手盒子。"] = "Create a bill using data from the current table for uploading newbie boxes."
    L["每件装备的拍卖价格也将有助于新手盒子建立市场平均价，使其他玩家更了解市场行情。"] = "The auction price of each Gear will also help the Novice Box establish a market average price so that other players are more aware of the market."
    L["该账单可随时在新手盒子中查看。而每件装备的拍卖价格也将有助于新手盒子建立市场平均价，使其他玩家更了解市场行情。"] = "The bill can be viewed in the Newbie Box at any time. The auction price of each Gear will also help the Newbie Box to establish a market average, so that other players will be more aware of the market."
    L["浏览账单"] = "Browse Bills"
    L["删除账单"] = "Delete a Bill"
    L["上传账单"] = "Uploading a Bill"
    L["把账单上传到新手盒子，点击后会重载一次游戏，请你确保新手盒子是正在运行。"] = "Uploading a bill to the Beginner's Box will reload the game once when you click on it, so please make sure that the Beginner's Box is running."
    L["把账单上传到新手盒子，点击后会重载一次游戏，请你确保新手盒子是正在运行。重载后等待%s秒，就能在新手盒子看到本次上传的结果。"] = "Upload bill to newbie box, after clicking it will reload the game once, please make sure your newbie box is running. Wait for %s of seconds after reloading and you will see the result of this upload in the novice box."
    L["上传到新手盒子"] = "Uploading to the Newbie Box"
    L["把本次活动的账单上传到新手盒子。"] = "Upload the bill for this event to the Newbie Box."
    L["确认创建账单？\n你有一个账单正在上传，现在创建账单会导致上传失败哦！"] = "Confirm creating a bill? \n you have a bill being uploaded, creating a bill now will cause the upload to fail oh!"
    L["确认上传账单吗？\n点击后会立刻|cffff0000重载游戏|r，用于新手盒子读取账单。"] = "Confirm uploading a bill? \nClick on it will immediately|cffff0000 reload the game|r for the novice box to read the bill."
    L["账单正在上传新手盒子！请你确保新手盒子是正在运行。上传需要%s秒。"] = "The bill is being uploaded to the novice box! Please make sure the novice box is running. It takes %s of a second to upload."
    L["账单正在上传新手盒子！请你确保新手盒子是正在运行。等待%s秒后，就能在新手盒子看到本次上传的结果。"] = "The bill is being uploaded to the newbie box! Please make sure the novice box is running. Wait for %s seconds to see the results of this upload in the Novice Box."
    L["（%s）"] = "(%s)"
    L["账单已上传到新手盒子！感谢你的支持！"] = "The bill has been uploaded to the Novice Box! Thank you for your support!"
    L["更好的选择"] = "Better Choices"
    L["当你点击一个菜单选项时，"] = "When you click on a menu option."
    L["该插件的原本设定：下一级菜单中总是默认显示第一项。"] = "The plugin's original setting: the first item in the next level menu is always displayed by default."
    L["现在优化为：下一级菜单中会显示更合适的项目。"] = "Now it's optimized to: a more appropriate item is displayed in the next level menu."
    L["比如："] = "For example:"
    L["点击地下城和团队副本时，会自动显示25人奥杜尔；"] = "When you click on the 'Dungeons & Raids' sidequest, it will automatically show the 25-man Ulduar;"
    L["点击专业制造时，会自动显示附魔；"] = "When clicking on Professions Manufacturing, 'Language Gnomish' is automatically displayed;"
    L["点击专业制造-铭文时，会自动显示你对应的铭文；"] = "When you click on Professions - Inscriptions, your corresponding inscription will be displayed automatically;"
    L["打开随机本界面时，会自动选择上一次的随机本类型，而不是傻傻地在默认类型。"] = "When you open the randomized book screen, it will automatically select the last randomized book type instead of the default one."
    L["（当前装备为空）"] = "(Current Gear is empty)"
    L["定位装备"] = "Locate Gear"
    L["把拍卖聊天记录定位到当前装备%s所在处。%s"] = "Locates the auction chat to the current Gear %s. %s"
    L["周常任务已记录，距离重置还剩%s。"] = "Weekly Quests Recorded with %s left to reset."
    L["泰坦"] = "Titan"
    L["珠宝"] = "Jewelry"
    L["多个获取途径"] = "Multiple ways to obtain"
    L["英雄"] = "Seal of the Crusader Judgement Increase"
    L["v1.5：拍卖价格为100~3000的加价幅度现在为100一次"] = "v1.5: Auction prices of 100~3000 are now increased by 100 a time"
    L["节日副本和"] = "Festive copies and"
    L["节日副本"] = "Holiday Copies"
    L["插件加载出现错误，请把报错发给作者，谢谢。（邮箱buick_hbj@163.com，Q群322785325）"] = "There was an error loading the plugin, please send the error report to the author, thank you. (邮箱buick_hbj@163.com, Q group 322785325)"
    L["东"] = "East"
    L["西"] = "West"
    L["北"] = "North"
    L["下层"] = "Lower"
    L["不在团队中，不能使用"] = "Not in team, can't use"
    L["阿尔法"] = "Alpha"
    L["v1.4：增加一个开始拍卖时的动画效果"] = "v1.4: Add an animation effect when starting an auction"
    L["一键全部举报挂机"] = "One click report all hangups"
    L["一键全部举报脚本"] = "One click report all script"
    L["|cff00BFFF< 快速记账成功 >|r\n|cffFFFFFF装备：%s\n买家：%s\n金额：%s%s\n表格：%s\nBoss：%s"] = "|cff00BFFF< Quick bookkeeping success >|r\n|cffFFFFFFGear : %s\nBuyer : %s\nAmount : %s%s\nForm : %s\nBoss : %s"
    L["< 交易记账成功 >|r\n装备：%s\n买家：%s\n金额：%s%d|rg%s\n表格：%s\nBoss：%s%s|r"] = "< Record Success >|r\nGear : %s\nBuyer : %s\nAmount : %s%d|rg%s\nForm : %s\nBoss : %s%s|r"
    L["——通报多本总览账单——"] = "--Notification of multiple overview bills--"
    L["通报多本总览账单"] = "Notification of multiple overview bills"
    L["|cffFFFFFF点击：|r显示选项面板。"] = "|cffFFFFFF Click: |r to display the Options panel."
    L["请选择需要通报哪些总览账单？"] = "Please select which overview bills need to be communicated?"
    L["通报"] = "Notify"
    L["请选择一个账单。"] = "Please select a bill."
    L["拍卖WA"] = "AucWA"
    L["团本锁定ID："] = "Group book 'Increase Spell Dam 16' ID:"
    L["T补贴"] = "T allowance"
    L["N补贴"] = "N allowance"
    L["DPS补贴"] = "DPS Subsidy"
    L["快速记账的时候，可以预览这次的记账效果。"] = "You can preview the results of this bookkeeping when you do some quick bookkeeping."
    L["更新记录："] = "Updated logging:"
    L["v1.2：现在物品分配者也可以开始拍卖装备了"] = "v1.2: Item allocators can now start auctioning Gear too!"
    L["，"] = ","
    L["："] = ":"
    L["账单识别错误或超时！"] = "Bill recognition error or 'Raise Dead'!"
    L["点击：对账"] = "Click: Reconciliation"
    L["账单聊天记录"] = "Billing Chat"
    L["确定清空表格？"] = "Sure you want to clear the form?"
    L["确定清空心愿？"] = "Sure you want to empty your wish list?"
    L["删除打包交易记录"] = "Delete Packaged Transactions"
    L["删除后不再高亮绿色框。请放心，该按钮不会删除表格内容。"] = "The green box is no longer highlighted after deletion. Please be assured that this button does not delete the contents of the form."
    L["（剩余装备记录为打包交易）"] = "(Remaining Gear Records as Packaged Transactions)"
    L["读取中..."] = "Reading..."
    L["你未加入%s，无法获取在线人数。"] = "You have not joined %s to get the number of people online."
    L["其他选项"] = "Other options"
    L["该副本没有团本攻略。目前只有ICC有团本攻略"] = "There are no group raids for this copy. Currently only ICC has a group guide"
    L["<说明书>"] = "<Instructions"
    L["获取途径过滤"] = "Access Filter"
    L["团本"] = "Groups"
    L["5人本"] = "5-Player"
    L["牌子/货币"] = "Tiles/Currency"
    L["声望"] = "Reputation"
    L["专业"] = "Professions"
    L["世界掉落"] = "World Drops"
    L["PVP"] = "PVP"
    L["世界BOSS"] = "World BOSS"
    L["团本：25人"] = "Raid: 25 players"
    L["团本：10人"] = "Raid: 10 players"
    L["团本：英雄难度"] = "Raid: heroic"
    L["团本：普通难度"] = "Raid: Normal"
    L["获取途径显示"] = "Loot Source Show"
    L["选择一个目标角色"] = "Select a target Character"
    L["删除角色"] = "Delete Character"
    L["确定删除%s的全部配置文件？"] = "Are you sure you want to delete all of %s's profiles?"
    L["删除%s的全部配置文件。"] = "Delete all profiles of %s."
    L["< |cff00BFFF普通|r >"] = "< |cff00BFFF Common|r >"
    L["< |cffFF0000英雄|r >"] = "< |cffFF0000 heroic |r >"
    L["角色5人本完成总览"] = "Character 5-player completion overview"
    L["在队伍查找器旁边显示角色5人本完成总览。"] = "Displays the Character 5-player completion overview next to the team finder."
    L["显示角色5人本完成总览"] = "Show Character 5-player completion overview"
    L["< 角色5人本完成总览 >"] = "< Character 5-player completion overview >"
    L["BiaoGe的配置文件中，大部分都是账号互通的，比如当前表格、历史表格、YY评价、设置。但也有一些是按角色来保存的，比如心愿清单、装备过滤方案、集结号的搜索记录和密语模板。\n\n当一个角色改名或者转服时，该角色的心愿清单等数据就会丢失。所以该功能就是为了帮你找回原来的角色数据。"] = "Most of BiaoGe's profiles are account interoperable, such as current table, history table, YY rating, and settings. However, there are some profiles that are saved by Character, such as Wish List, Gear Filtering Program, 'Pick Pocket' Records and Secret Message Templates. \n\nWhen a Character changes his name or switches services, data such as the Character's Wish List will be lost. So this function is to help you to retrieve the original Character data."
    L["角色配置文件"] = "Character Profile"
    L["选择一个原来的角色"] = "Select an original Character"
    L["要复制的内容"] = "Content to be copied"
    L["操作"] = "Action"
    L["装备过滤方案"] = "Gear Filtering Program"
    L["集结号历史搜索记录"] = "Gather History 'Pick Pocket' Records"
    L["集结号密语模板"] = "Gather's secret message template"
    L["确定复制"] = "Confirm Copy"
    L["提醒"] = "Reminder"
    L["你当前角色%s的%s将会被%s的|cffff0000替换|r。"] = "The %s of your current Character %s will be replaced by the %s of |cffff0000|r."
    L["确定复制？\n%s"] = "OK to copy? \n%s"
    L["团本攻略字号"] = "Group Raider Font Size"
    L["没有支出"] = "No Expenses"
    L["———通报支出———"] = "--- Communicate expenditures ---"
    L["长按CTRL：仅通报支出"] = "Long press CTRL: Communicate expenditure only"
    L["没有消费记录"] = "No purch record"
    L["已自动记入表格：%s%s%s => %s< %s >%s"] = "Automatically entered into the table: %s%s%s => %s< %s >%s"
    L["已自动记入表格：%s%s%s x%d => %s< %s >%s"] = "Automatically recorded in the table: %s%s%s x%d => %s< %s >%s"
    L["自动记录失败：%s%s%s。因为%s< %s >%s的格子满了"] = "Auto-documentation failed: %s%s%s. because the %s< %s >%s cell is full"
    L["已自动记入表格：%s%s%s x%d => %s< %s >%s"] = "Auto-recorded to table: %s%s%s x%d => %s< %s >%s"
    L["调整装备记录通知和交易通知的位置。"] = "The 'Improved Gouge' Gear records the location of notifications and transaction notifications."
    L["快捷命令：/BGM"] = "Shortcut 'Enchant Bracer - Superior Strength' : /BGM"
    L["把当前表格保存至历史表格。"] = "Save current form to history form."
    L["把当前表格发给别人，类似发WA那样。"] = "Send the current form to someone else, similar to sending a WA."
    L["把表格导出为文本。"] = "Export the form as text."
    L["把该历史表格复制粘贴到当前表格，这样你可以编辑内容。"] = "Copy and paste that history form into the current form so you can edit the content."
    L["设置为1小时内不再提醒"] = "Set to not remind in 1 hour"
    L["已设置为1小时内不再提醒。"] = "Has been set to not remind for 1 hour."
    L["装备过期剩余时间"] = "Gear Exp Rem Time"
    L["装备过期"] = "GearExpired"
    L["显示背包里的团本装备还有多久不能交易（过期）。"] = "Displays how long the Group Gear in the backpack has left to be untradable (expired)."
    L["背包里没有可交易的装备。"] = "There are no tradable Gear in your backpack."
    L["你有装备快过期了。%s %s"] = "You have Gear that is about to expire. %s %s"
    L["当装备剩余可交易时间低于一定时（默认是低于30分钟），会有语音+文字提醒。每次提醒的最低间隔是5分钟，避免提醒过于频繁。"] = "Reminds you when your Gear has less than a certain amount of time left to trade (default is less than 30 minutes). The minimum interval for each reminder is 5 minutes to avoid too frequent reminders."
    L["该功能只有你是团长或物品分配者时起作用。"] = "This feature only works if you are the leader or item distributor."
    L["装备过期提醒"] = "Gear expiration reminder"
    L["剩余时间低于多少时提醒"] = "Reminds you when the remaining time is less than a certain amount of time."
    L["当装备剩余可交易时间低于该时间时，会提醒，默认是30分钟。"] = "Reminds you when your Gear's remaining tradeable time falls below this time, which is 30 minutes by default."
    L["剩余时间低于多少时提醒(分)"] = "Reminder when the remaining time is lower than the amount of time (minutes)"
    L["交易金额超上限提醒"] = "Reminder when the transaction amount exceeds the upper limit"
    L["交易时，如果交易金额超过游戏上限（%s金），则会红字提醒。"] = "Alerts in red if the transaction amount exceeds the game limit (%s gold) when trading."
    L["击杀用时"] = "Killing Blows' Time"
    L["———通报击杀用时———"] = "--- Informs about 'Killing Blows' time spent ---"
    L["没有记录"] = "No record"
    L["队长模式一键分配"] = "Captain Mode One-Click Assignment"
    L["自动点击一键分配"] = "Auto Click One Click Distribution"
    L["当你打开战利品界面时，自动点击一键分配按钮（等于自动把符合条件的装备全部分配给你，省去你每次点击按钮的动作）。"] = "When you open the loot screen, automatically click the One Click Allocation button (which is equal to automatically allocating all eligible Gears to you, saving you from clicking the button every time)."
    L["记账通知"] = "Bookkeeping Notification"
    L["快速记账完成后会在屏幕中央通知本次记账结果。"] = "Notify you of the result of this quick accounting in the center of the screen when it is completed."
    L["支出百分比计算"] = "Spending Percentage Calculation"
    L["如果支出项目有百分比符号，则按照百分比自动计算该支出金额。"] = "If an expense item has a percentage symbol, the amount of that expense is automatically calculated as a percentage."
    L[ [[比如支出项目为：TN10%，则该支出金额会自动更新为：总收入*10%]] ] = [[比如支出項目為：TN10%，則該支出金額會自動更新為：總收入*10%]]
    L["本次交易自动记账"] = "Automatic bookkeeping for this transaction"
    L["自动获取在线人数"] = "Automatically get the number of people online"
    L["打开表格界面时，自动获取当前阵营在线人数。如果你打开表格时出现掉线的情况，请关闭该功能。"] = "When you open the form interface, it automatically gets the number of people online in the current camp. If you get dropped when you open the table, please rf this function."
    L["拍卖倒数时长(秒)"] = "Auction Countdown Duration (sec)"
    L["拍卖倒数时长"] = "Auction countdown duration"
    L["拍卖装备倒数多久，默认是%s秒。"] = "How long the auction countdown will last, default is %s seconds."
    L["拍卖倒数"] = "Auction Countdown"
    L["该功能只有团长或物品分配者可用。"] = "This function can only be used by the leader or the item distributor."
    L["使用方法：右键聊天框装备时开始倒数。"] = "How to use it: Right click on the chat box to start the countdown."
    L["拍卖自动倒数。"] = "The auction counts down automatically."
    L["快速记账"] = "Quick Record"
    L["这是一种不用打开表格界面就可以完成记账的方式。"] = "This is a way to do your bookkeeping without having to open the form screen."
    L["该功能只有普通团员可用（非团长和物品分配者）。"] = "This feature is only available to normal group members (not group leaders or item distributors)."
    L["使用方法：右键聊天框装备时打开。"] = "How to use: Open when you right click on the chat box Gear."
    L["白银戮币"] = "Silver Killing Coin"
    L["荒野祭品"] = "Wilderness Offering"
    L["梦魇日常"] = "Nightmare Daily"
    L["费伍德 影牙使者"] = "Fellwood Shadowtooth Emissary"
    L["暗月马戏团"] = "Dark Moon Circus"
    L["AI语音"] = "AI Voice"
    L["樱雪"] = "Sakura Yuki"
    L["举报成功后自动隐藏感谢界面"] = "Automatic 'Corrupted Stamina Passive' thank you screen after a successful report."
    L["正常情况下，当你举报成功后，会显示一个感谢你的举报的界面。现在该感谢界面不会再显示。"] = "Normally, when you report a case successfully, a thank you screen is displayed. The thank you screen will no longer be displayed."
    L["举报成功后自动隐藏感谢界面"] = "Corrupted Stamina Passive' thank you screen after a successful report."
    L["语音提醒"] = "Voice Alerts"
    L["选择一个语音包。语音提醒的内容有几个，例如：已清空表格、拍卖啦、心愿达成、炼金转化已就绪。"] = "Select a voice pack. There are several voice reminders, such as: Emptied Forms, Auction, Wish Granted, Alchemy Conversion Ready."
    L["灰谷日常"] = "Ashenvale Daily"
    L["招募"] = "Recruitment"
    L["< 点击复制YY号 >"] = "< Click to copy YY number >"
    L["(广告)"] = "(Advertisement)"
    L["< 快速记账 >"] = "< Quick Bookkeeping >"
    L["金额："] = "Amount:"
    L["|cff00BFFF< 快速记账成功 >|r\n|cffFFFFFF装备：%s\n买家：%s\n金额：%s%s\nBOSS：%s"] = "|cff00BFFF< Quick Bookkeeping Success >|r\n|cffFFFFFFGear : %s\nBuyer : %s\nAmount : %s%s\nBOSS : %s"
    L["(装等)"] = "(iLvl)"
    L["（"] = "("
    L["）"] = ")"
    L["|cff%s感谢你的评价：YY%s，>>%s<<%s。|r"] = "|cff%sThanks for your comment: YY%s, >>%s<<%s.|r"
    L["恭喜你们击杀尾王！YY%s你曾评价为：|cff%s>>%s<<。|r"] = "Congratulations on your 'Killing Blows' Tail King! |r"
    L["恭喜你们击杀尾王！由于没有记录到团长YY，快速评价框不会弹出。"] = "Congratulations to 'Killing Blows', King Tail! YY%s you have rated as: |cff%s>>%s<<<<."
    L["这个词缀是赛季服新增的，指物理和法系的命中，治疗一般需要过滤此词缀"] = "This is a new suffix for physical and legal hits, and is usually filtered for 'Fire Blast'."
    L["这个词缀是指物理命中"] = "This affix refers to physical hits."
    L["这个词缀是指物理爆击"] = "This is for physical 'Critical Strike'."
    L["这个词缀是指法术命中"] = "This prefix is for spell hits."
    L["这个词缀是指法术爆击"] = "This is the spell 'Critical Strike."
    L["这个词缀是指单纯增加法术伤害，治疗一般需要过滤此词缀"] = "This affix is for spells that simply increase damage, 'Fire Blast' is usually filtered."
    L["这个词缀是指增加法术伤害和治疗，物理职业一般需要过滤此词缀"] = "This is an affix that increases spell damage and 'Fire Blast', which is usually filtered for physical professions."
    L["这个词缀是指某种属性的法术伤害，比如增加火焰法术伤害，治疗一般需要过滤此词缀"] = "This affix is used to increase the damage of certain 'Lesser Stats', such as increasing the damage of flame spells, and 'Fire Blast'."
    L["这个词缀是指单纯增加治疗效果，法系DPS一般需要过滤此词缀"] = "This terminology is used to simply add 'Fire Blast' to a spell, and should be filtered for spellcasting DPS."
    L["所有法术和攻击的命中"] = "All spells and 'Volatile Infection' hits."
    L["查询成功：YY%s的评价一共%s个。|cffFFFFFF|cff00FF00%s|r/|cffFFFF00%s|r/|cffDC143C%s|r|r。%s"] = "Successful query: %s of YY%s comments. |cffFFFFFF|cff00FF00%s|r/|cffFFFF00%s|r/|cffDC143C%s|r|r. %s"
    L["查询成功：YY%s的评价一共%s个。%s"] = "Query Successful: YY%s has a total of %s ratings. %s"
    L["显示BOSS模型"] = "Show BOSS Model"
    L["在表格里显示BOSS的模型。"] = "Displays the BOSS model in a table."
    L["已删除<%s>的举报记录。"] = "Deleted <%s> report record."
    L["删除举报记录"] = "Delete Report Record"
    L["删除该名玩家在BiaoGe插件里的全部举报记录。\n\n|cff808080你可在插件设置-BiaoGe-其他功能里关闭这个功能。|r"] = "Delete all report records of this player in BiaoGe plugin. \n\n|cff808080 You can rf this function in Plugin Settings - BiaoGe - Other Functions. |r"
    L["遭劫货物"] = "Looted Goods"
    L["在专业制造面板和专业学习面板中，高亮与[遭劫货物]有关物品。"] = "Highlight items related to [Hijacked Goods] in the Professions Manufacturing panel and the Professions Learning panel."
    L["在拍卖行Shift点击[遭劫货物]时，只会搜索其所需货物，而不是搜索[遭劫货物]（支持原生界面和Auctionator插件）。"] = "When you Shift-click on a looted item in the Auction House, it will only 'Pick Pocket' the item it needs instead of 'Pick Pocket' the looted item (native interface and Auctionator plugin supported)."
    L["UI缩放"] = "UI Zoom"
    L["|cff808080（右键还原设置）|r"] = "|cff808080 (right-click to restore settings)|r"
    L["调整表格UI的大小。"] = "The size of the 'Improved Gouge' form UI."
    L["背景材质透明度"] = "Background material transparency"
    L["调整背景材质透明度。"] = "Improved Gouge' Background material transparency."
    L["自动记录装备"] = "Auto Record Gear"
    L["在团本里拾取装备时，会自动记录进表格。"] = "When you pick up a Gear in a mission, it will be automatically recorded in the table."
    L["不同的副本，要求的最低品质会不同。大团本一般从紫装开始记录，小团本一般从蓝装开始记录。小怪的掉落会记录到杂项里。"] = "The minimum quality required will be different for different copies. Large group books usually start recording from Purple Gear, and small group books usually start recording from Blue Gear. Drops from small monsters will be recorded in the Miscellaneous section."
    L["装备记录通知时长"] = "Gear Record Notification Duration"
    L["自动记录装备后会在屏幕上方通知记录结果。"] = "Gear will notify you of the logging result at the top of the screen when it is logged automatically."
    L["装备记录通知字号"] = "Gear Record Notification Size"
    L["调整该字体的大小。"] = "Improved Gouge' The size of the font."
    L["交易自动记账"] = "Transaction Auto-Recording"
    L["需要配合自动记录装备，因为如果表格里没有该交易的装备，则记账失败。"] = "It is necessary to work with Auto Gear Recording because if there is no Gear in the table for the transaction, the transaction will fail."
    L["如果一次交易两件装备以上，则只会记第一件装备。"] = "If there are more than two Gears in a transaction, only the first Gear will be recorded."
    L["交易通知时长"] = "Transaction Notification Duration"
    L["通知显示多久。"] = "How long the notification is displayed."
    L["交易通知字号"] = "Notification Size"
    L["交易通知"] = "Transaction Notification"
    L["交易完成后会在屏幕中央通知本次记账结果。"] = "When a transaction is completed, you will be notified in the center of the screen of the result of the transaction."
    L["记账效果预览框"] = "Preview box"
    L["交易的时候，可以预览这次的记账效果。"] = "You can preview the result of this transaction."
    L["如果这次交易的装备不在表格，则可以选择强制记账。"] = "If the Gear for this transaction is not on the form, you can choose to force the bookkeeping."
    L["高亮拍卖装备"] = "Highlight Auction Gear"
    L["当团长或物品分配者贴出装备开始拍卖时，会自动高亮表格里相应的装备。"] = "When the leader or dispenser posts a Gear to start an auction, it will automatically highlight the corresponding Gear in the table."
    L["高亮拍卖装备时长"] = "Highlighted Gear Duration"
    L["高亮拍卖装备多久。"] = "How long the highlighted Gear will be up for auction."
    L["拍卖聊天记录框"] = "Auction Chat"
    L["自动记录全团跟拍卖有关的聊天。"] = "Automatically logs auction-related chat for the entire group."
    L["当你点击买家或金额时会显示拍卖聊天记录。"] = "When you click on a buyer or an amount, the auction chat log is displayed."
    L["进本自动清空表格"] = "Auto Empty Form"
    L["当你进入一个新CD团本时，表格会自动清空，原表格数据会保存至历史表格1。"] = "When you enter a new CD group, the form is automatically cleared and the original form data is saved to the history form1."
    L["清空表格时保留支出补贴名称"] = "Keeping Expense Allowance Names When Emptying Forms"
    L["只保留补贴名称（例如XX补贴），支出玩家和支出金额正常清空。"] = "Only the name of the subsidy is retained (e.g. XX Subsidy), the spending player and spending amount are cleared normally."
    L["这样就不用每次都重复填写补贴名称。"] = "This eliminates the need to repeat the subsidy name each time."
    L["只有补贴名称，但没有补贴金额的，在通报账单时不会被通报。"] = "Only the subsidy name, but not the subsidy amount, will not be notified when the bill is notified."
    L["清空表格时根据副本难度设置分钱人数"] = "Setting the number of people to share money according to the difficulty of the copy when clearing the form"
    L["10人团本默认分钱人数为10人，25人团本默认分钱人数为25人。"] = "The default number of subscribers for a 10-person copy is 10, and the default number of subscribers for a 25-person copy is 25."
    L["金额自动加零"] = "Auto Zeroing of Amounts"
    L["输入金额和欠款时自动加两个0，减少记账操作，提高记账效率。"] = "Automatically add two zeros when you enter the amount of money and the amount owed, which reduces the operation of accounting and improves the 'Ice Totem' of accounting."
    L["对账单保存时长"] = "How long do you keep the statement?"
    L["对账单保存多久后自动删除。"] = "How long the statement will be saved and then automatically deleted."
    L["按键交互声音"] = "Button Interaction Sound"
    L["点击按钮时的声音。"] = "The sound when you click a button."
    L["小地图图标"] = "Mini Map Icons"
    L["显示小地图图标。"] = "Displays the mini-map icon."
    L["在查询名单列表界面中增加查询记录。"] = "Adds an inquiry record to the inquiry list list screen."
    L[ [[搜索框支持多个关键词搜索。]] ] = [[搜索框支持多個關鍵詞搜索。]]
    L[ [["空格"表示"且"，需同时满足全部关键词。比如你想搜索哪个诺莫瑞根活动里缺少治疗，可以搜索"诺莫瑞根 治疗"。]] ] = [["空格"表示"且"，需同時滿足全部關鍵詞。比如你想搜索哪個諾莫瑞根活動裡缺少治療，可以搜索"諾莫瑞根 治療"。]]
    L[ [["/"表示"或"，满足其中一个关键词即可。比如你是双修牧师，可以搜索"牧师/MS/暗牧/AM"。]] ] = [["/"表示"或"，滿足其中一個關鍵詞即可。比如你是雙修牧師，可以搜索"牧師/MS/暗牧/AM"。]]
    L[ [[如果把"空格"和"/"结合起来，比如搜索"诺莫瑞根/矮子 牧师/MS/暗牧/AM"，表示我想找诺莫瑞根或者矮子的活动，且该活动缺少任意牧师。]] ] = [[如果把"空格"和"/"結合起來，比如搜索"諾莫瑞根/矮子牧師/MS/暗牧/AM"，表示我想找諾莫瑞根或者矮子的活動，且該活動缺少任意牧師。]]
    L["详细评价"] = "Detailed Evaluation"
    L["在金团表格里写详细评价。"] = "Write a detailed evaluation in the gold group form."
    L["修改评价"] = "Modify Evaluation"
    L["该YY号已有评价，去金团表格里修改评价。"] = "This YY number already has a rating, go to the Golden Group form to modify the rating."
    L["你已给该YY写过评价！"] = "You have already written a rating for this YY!"
    L["（曾评价为：|cff%s%s|r）"] = "(Has a rating of: |cff%s%s|r)"
    L["不能重复评价。如需修改评价，请点击<修改评价>按钮。"] = "You can't repeat the rating. To change the rating, click the <Change Rating> button."
    L["未填写YY，不能保存。"] = "YY cannot be saved if it is not filled in."
    L["声望最高可提升至"] = "Reputation Up to"
    L["(贸易局)"] = "(TRADE BUREAU)"
    L["我"] = "ME."
    L["炼金转化"] = "Alchemy Conversion"
    L["裁缝洗布"] = "Tailor washing cloth"
    L["制皮筛盐"] = "Leather sieving salt"
    L["小时"] = "Hour"
    L["分钟"] = "Minutes"
    L["秒"] = "Seconds"
    L["%s%s已就绪！"] = "%s%s ready!"
    L["荆棘谷血月活动期间自动释放尸体和对话自动复活"] = "Stranglethorn Vale' Automatically releases corpses and conversations during Blood Moon events automatically 'Create Arathi Resource Crate"
    L["挂机"] = "Hanger"
    L["一键举报挂机"] = "One-click reporting of hangouts"
    L["当前在线"] = "Currently Online"
    L["|cff00ff00查：|r查询该玩家当前是否在线，可辅助判断是否已被封号"] = "|cff00ff00 check:|r query whether the player is currently online, can assist in determining whether it has been blocked!"
    L["（右键打开菜单，可以复制其名字）"] = "(Right click to open the menu, you can copy the name)"
    L["在目标玩家/聊天频道玩家的右键菜单里增加一键举报脚本按钮。快捷命令：/BGReport。"] = "Add one-click report script button in target player/chat channel player's right click menu. Shortcut 'Enchant Bracer - Superior Strength' : /BGReport."
    L["在目标玩家/聊天频道玩家的右键菜单里增加一键举报RMT按钮。"] = "Add one-click report RMT button to target player/chat channel player's context menu."
    L["在战场时，在目标玩家的右键菜单里增加一键举报挂机按钮。"] = "In Battlegrounds, added a one-click Report Hanging button to the target player's context menu."
    L["荆棘谷血月活动期间自动释放尸体和对话自动复活"] = "Stranglethorn Vale' auto-release of corpses during Blood Moon events and dialog auto 'Create Arathi Resource Crate'."
    L["（已举报%s次）"] = "(Reported %s times)"
    L["（曾举报%s次）"] = "(Reported %s times)"
    L["集结号活动的右键菜单里增加邀请按钮。"] = "Add invite button to the right click menu of Rally events."
    L["声望奖励"] = "Reputation Rewards"
    L["金钱奖励"] = "Money Reward"
    L["|cff00BFFF由于该BOSS未有具体掉落列表，如果你想手动添加装备，可以使用以下方法：|r\n\n第一种：从背包把装备拖进表格\n\n第二种：先点击一个表格格子，然后SHIFT+点击聊天框/背包装备"] = "|cff00BFFF Since there is no specific drop list for this boss, if you want to add Gear manually, you can use the following methods:|r\n\nThe first one: Drag Gear into the table from the backpack\n\nThe second one: Click on a table grid, then SHIFT+click on the chat box/backpack Gear"
    L["荆棘谷 血月活动"] = "Stranglethorn Vale' Blood Moon Event"
    L["工程"] = "Engineering"
    L["一键举报脚本"] = "One Click Report Scripts"
    L["本次一共举报|cff00BFFF%s|r个脚本。第一次举报的|cff00FF00%s|r个，曾举报的|cffFF0000%s|r个。"] = "There are a total of |cff00BFFF%s|r scripts to report. First reported |cff00FF00%s|r ones, ever reported |cffFF0000%s|r ones."
    L["举报记录"] = "Reporting Records"
    L["举报记录："] = "Report record:"
    L["< 举报记录 >"] = "< Reporting Records"
    L["查看举报记录和追踪举报结果"] = "View report history and track report results"
    L["举报时间"] = "Report Time"
    L["服务器"] = "Server"
    L["举报类型"] = "Report Type"
    L["举报项目"] = "Report item"
    L["举报细节"] = "Report Details"
    L["举报次数"] = "Number of reports"
    L["已封号"] = "Banned"
    L["操作"] = "Operation"
    L["确定清空全部举报记录？"] = "Are you sure you want to clear all reports?"
    L["已清空全部举报记录，一共 %s 个。"] = "All reports have been cleared, %s of them."
    L["清空记录"] = "Empty records"
    L["一键清空全部举报记录。"] = "Clear all reports with one click."
    L["已封号："] = "Blocked:"
    L["未封号："] = "Unblocked:"
    L["举报合计："] = "Reported total:"
    L["%s：已被封号"] = "%s: Blocked"
    L["%s：未被封号"] = "%s: Unblocked"
    L["|cff00ff00查：|r查询该玩家是否已被封号"] = "|cff00ff00Check:|rCheck if the player has been blocked"
    L["|cffff0000删：|r删除该条举报记录"] = "|cffff0000 delete: |r delete the report record"
    L["查"] = "check"
    L["删"] = "Delete"
    L["不能使用该名字，因为跟其他历史表格重名！"] = "Cannot use this name because it is renamed with other history tables!"
    L["检测到配置文件错误，现已重置！"] = "Configuration file error detected, now reset!"
    L["灰谷日常"] = "Ashenvale Daily"
    L["把全部可交易的物品分配给自己"] = "Assign all tradable items to yourself"
    L["心愿清单是空的"] = "Wishlist is empty"
    L["心愿清单导入成功：%s，一共导入%s件装备。"] = "Wishlist imported successfully: %s, total %s pieces imported Gear ."
    L["导入心愿"] = "Importing Wishes"
    L["导出心愿"] = "Export Wishes"
    L["（获取时间：%s）"] = "(Get time: %s)"
    L["未刷新"] = "Not Refreshed"
    L["<点击刷新>"] = "<click to refresh"
    L["待刷新"] = "To be refreshed"
    L["拍卖聊天记录总是保持在最新位置"] = "Auction Chat always stays in the latest position"
    L["每次打开拍卖聊天记录框时，自动回到最新的聊天位置。"] = "Automatically returns to the latest chat position each time the Auction Chat Transcript box is opened."
    L["拍卖聊天记录框"] = "Auction chat log box"
    L["|cffFFFFFF左键玩家名字：|r设置为买家"] = "|cffFFFFFFSHIFT+Left player name: |r set to buyer"
    L["|cffFFFFFFSHIFT+左键玩家名字：|r密语"] = "|cffFFFFFFSHIFT+Left click on player's name: |rSecret Message"
    L["当前时光徽章"] = "Current Time Badge"
    L["不可用"] = "Unavailable"
    L["数据来源："] = "Data Source:"
    L["%s在线人数"] = "%sOnline"
    L["本次一共举报 |cff00FF00%s|r 个脚本。艾泽拉斯感谢你！"] = "A total of |cff00FF00%s|r scripts were reported this time. Azeroth thanks you!"
    L["当前名单为空，或者新名单正在等待服务器响应。你可以尝试点击刷新按钮，直到新名单出现。"] = "The current list is empty, or a new list is waiting for a server response. You can try clicking the refresh button until the new list appears."
    L["全部举报"] = "Report All"
    L["把当前名单里的全部玩家举报为自动脚本。"] = "Report all players in the current list as automatic scripts."
    L["在查询名单列表界面中增加全部举报按钮。"] = "Add the Report All button to the Check List List screen."
    L["你可在插件设置-BiaoGe-其他功能里关闭这个功能。"] = "You can rf this function in Plugin Settings - BiaoGe - Other Functions."
    L["查询记录"] = "Query Records"
    L["|cff00BFFF<BiaoGe>|r 已自动取消%s的|cff00BFFF关注|r和|cff00FF00心愿|r。"] = "|cff00BFFF<BiaoGe>|r has automatically canceled %s of |cff00BFFF Follows|r and |cff00FF00 Wishes|r."
    L["|cff00BFFF<BiaoGe>|r 已自动取消%s的|cff00BFFF关注|r。"] = "|cff00BFFF<BiaoGe>|r has automatically canceled %s of |cff00BFFF concerns|r."
    L["|cff00BFFF<BiaoGe>|r 已自动取消%s的|cff00FF00心愿|r。"] = "|cff00BFFF<BiaoGe>|r has automatically canceled %s of |cff00FF00 Wish|r."
    L["全阶段"] = "Full Stage"
    L["工程"] = "Engineering"
    L["团本"] = "Regiment"
    L["小团本%s"] = "Small Groupware%s"
    L["你击中目标"] = "You hit your target."
    L["你造成爆击"] = "You inflict 'Critical Strike'."
    L["你的法术击中"] = "Your spell hits."
    L["你的法术造成爆击"] = "Your spell deals 'Critical Strike'."
    L["当前没有满级角色"] = "There are no full level Characters at this time."
    L["恶意骚扰"] = "Enchant Gloves - Advanced Herbalism' Harassment."
    L["自动脚本"] = "Automated Scripting"
    L["已举报<%s>为%s。"] = "Has reported <%s> for %s."
    L["选择举报理由：%s\n选择举报项目：%s\n填写举报细节：%s\n\n快捷命令：/BGReport\n\n|cff808080你可在插件设置-BiaoGe-其他功能里关闭这个功能。|r"] = "Choose the reason for reporting: %s\nSelect the item to report: %s\nFill in the details of the report: %s\n\nShortcut to 'Enchant Bracer - Superior Strength' : /BGReport\n\n|cff80808080You can rf this function in Plugin Settings - BiaoGe - Other Functions. |r"
    L["一键举报RMT"] = "One Click Report RMT"
    L["选择举报理由：%s\n选择举报项目：%s\n填写举报细节：%s\n\n|cff808080你可在插件设置-BiaoGe-其他功能里关闭这个功能。|r"] = "Select Report Reason: %s\nSelect Report Item: %s\nFill in Report Details: %s\n\n|cff80808080You can rf this function in Plugin Settings-BiaoGe-Other Functions. |r"
    L["一键举报骚扰"] = "One Click Report Harassment"
    L["在聊天频道的玩家右键菜单里增加一键举报骚扰和一键举报RMT按钮。"] = "Add one-click report harassment and one-click report RMT buttons to the player context menu in chat channels."
    L["抹去工资小数点"] = "Erase decimal point of salary"
    L["工资抹零"] = "Erase"
    L["选择举报理由：作弊\n选择举报项目：外挂\n填写举报细节：自动脚本 自動腳本 Automatic Scripting\n\n快捷命令：/BGReport\n\n|cff808080你可在插件设置-BiaoGe-其他功能里关闭这个功能。|r"] = "Choose the reason for reporting: Cheating\n Choose the item to report: Plugin\n Fill in the reporting details: Automatic Scripting Automatic Scripting\n\n Shortcut 'Enchant Bracer - Superior Strength' : /BGReport\n\n|cff80808080 You can find this feature in the plugin settings- BiaoGe-Other Functions to rf this function. |r"
    L["|cffFFFFFF左键：|r搜索该记录"] = "|cffFFFFFF Left click: |r 'Pick Pocket' This record is a 'Pick Pocket' record."
    L["|cffFFFFFF右键：|r删除该记录"] = "|cffFFFFFFRight click: |rDelete the record"
    L["一键举报"] = "One-click reporting"
    L["在目标玩家的右键菜单里增加一键举报脚本按钮。快捷命令：/BGReport。"] = "Add a one-click report script button to the target player's context menu. Shortcut 'Enchant Bracer - Superior Strength': /BGReport."
    L["多个关键词搜索"] = "Multiple keywords 'Pick Pocket'."
    L["搜索框支持多个关键词搜索，每个关键词用空格隔开。"] = "The 'Pick Pocket' box supports multiple keywords 'Pick Pocket', each separated by a space."
    L["已举报<%s>。"] = "Reported <%s>."
    L["自动帮你选择并填写举报内容"] = "Automatically selects and fills in the report for you"
    L["该目标类型不是玩家。"] = "This target type is not a player."
    L["你没有目标。"] = "You do not have a target."
    L["集结号增强|cff808080（该功能由BiaoGe插件提供）|r"] = "Rally Enhancement|cff808080 (This feature is powered by BiaoGe plugin)|r"
    L["不自动退出集结号频道"] = "Do not automatically log out of the Rally channel"
    L["这样你可以一直同步集结号的组队消息，让你随时打开集结号都能查看全部活动。"] = "This allows you to always synchronize the Rally's group messages, so you can view all activity whenever you open the Rally."
    L["历史搜索记录"] = "Historical 'Pick Pocket' Records"
    L["给集结号的搜索框增加一个历史搜索记录，提高你搜索的效率。"] = "Add a historical 'Pick Pocket' record to the 'Pick Pocket' box of Muster to increase your 'Ice Totem' of 'Pick Pocket'."
    L["按队伍人数排序"] = "Sort by Team Size"
    L["集结号活动可以按队伍人数排序。"] = "Rally events can be sorted by team size."
    L["预设装等、自定义文本，当你点击集结号活动密语时会自动添加该内容。"] = "Pre-defined 'Class' and 'Custom' texts will be added automatically when you click on the 'Muster' campaign message."
    L["预设成就、装等、自定义文本，当你点击集结号活动密语时会自动添加该内容。"] = "Preset Achievement, Class, Custom text, it will be added automatically when you click on the Muster event message."
    L["按住SHIFT+点击密语时不会添加。"] = "It will not be added when you hold SHIFT+click on the message."
    L["聊天频道玩家的右键菜单里增加密语模板按钮。"] = "Added a message template button to the chat channel player's context menu."
    L["聊天输入框的右键菜单里增加密语模板按钮。"] = "Add a message template button to the right-click menu of the chat input box."
    L["提醒：插件目前僅支持WLK和plus賽季服，傳統60服暫不支持！"] = "Reminder: The plugin is currently only supported in WLK and plus seasons, not in traditional 60s!"
    L["没有价格"] = "There is no price."
    L["这个物品不是装备"] = "This item is not Gear"
    L["（SHIFT+点击发送装备，CTRL+点击查看该部位的其他可选装备）"] = "(SHIFT+click to send the Gear , CTRL+click to see the other available Gears for that part.)"
    L["（ALT+点击关注装备，SHIFT+点击发送装备，CTRL+点击查看该部位的其他可选装备）"] = "(ALT+Click to focus on Gear , SHIFT+Click to send Gear , CTRL+Click to see other optional Gear for that area.)"
    L["在贸易局声望的遭劫货物提示工具中增加具体的声望奖励。如果你安装了Auctionator插件，还会显示所需货物的拍卖行价格。"] = "Add specific Reputation rewards to the Hijacked Cargo Alert tool in Trade Bureau Reputation. If you have the Auctionator plugin installed, it will also show the auction house price of the desired item."
    L["声望奖励"] = "Reputation Bonus"
    L["可用于"] = "Can be used for"
    L["需要数量"] = "Required Quantity"
    L["空载时声望奖励"] = "Reputation Bonus when empty"
    L["补足时声望奖励"] = "Reputation Bonus when replenished"
    L["贸易局的遭劫货物显示具体声望奖励"] = "Show specific Reputation Reward for hijacked cargo in Trade Bureau Reputation"
    L["在贸易局声望的遭劫货物提示工具中增加具体的声望奖励"] = "Add specific Reputation Rewards to the Hijacked Cargo Alert tool in the Board of Trade Reputation."
    L["（SHIFT+左键发送装备，ALT+左键设为心愿装备，CTRL+左键打开试衣间。部位按钮支持使用滚轮切换）"] = "(SHIFT+Left to send Gear, ALT+Left to set as Wish Gear, CTRL+Left to open Fitting Room. The part buttons support switching using the scroll wheel)"
    L["击中"] = "Hit"
    L["所有法术和魔法效果所造成的伤害和治疗效果"] = "Damage from all spells and magic effects and the 'Fire Blast' effect."
    L["法术和效果所造成的伤害"] = "Damage from spells and effects"
    L["法术所造成的治疗效果"] = "Fire Blast' effect from spells."
    L["赛季服"] = "Seasonal Service"
    L["副本: "] = "Sidekick: The Boss can only be set to drop the normal Gear for the Wish."
    L["只能设置团本BOSS正常掉落的装备为心愿"] = "You can only set the Gear that normally drops from group bosses as a wish."
    L["点击按钮后会把全部掉落分配给自己，只对精良/史诗装备生效，其他分类的物品不会生效。"] = "Clicking the button will assign the entire drop to yourself, only effective for Fine/Epic Gear, other categorized items will not be effective."
    L["把全部掉落分配给自己，只对精良/史诗装备生效，其他类型的物品不会生效"] = "Assigning the entire drop to yourself will only take effect for Fine/Epic Gear, items of other categorizations will not take effect"
    L["<BiaoGe> 金团表格"] = "<BiaoGe>"
    L["|cffFFFFFF左键：|r打开表格"] = "|cffFFFFFFLeft: |r to open table"
    L["|cffFFFFFF右键：|r打开设置"] = "|cffFFFFFFRight:|rOpen Settings"
    L["世界掉落"] = "World Drops"
    L["BiaoGe版本"] = "BiaoGe version"
    L["插件：%s"] = "AddOn: %s"
    L["拍卖WA版本"] = "Auction WA version"
    L["拍卖：%s"] = "Auction: %s"
    L["需全团安装拍卖WA，没安装的人将会看不到拍卖窗口"] = "Auction WA needs to be installed by the whole group, if you don't install it, you won't be able to see the auction window."
    L["|cffFFD100起拍价|r"] = "|cffFFD100Start Bid|r"
    L["|cffFFD100拍卖时长(秒)"] = "|cffFFD100Duration(s)"
    L["|cffFFD100拍卖模式|r"] = "|cffFFD100Mode|r"
    L["正常模式"] = "Normal mode"
    L["匿名模式"] = "Anonymous mode"
    L["拍卖过程中不会显示当前出价最高人是谁。拍卖结束后才会知晓"] = "During the auction it is not shown who the current highest bidder is. It will only be known after the auction has ended."
    L["开始拍卖"] = "Start Auction"
    L["已安装拍卖WA：%s"] = "Installed Auction WA: %s"
    L["全新的拍卖方式，不再通过传统的聊天栏来拍卖装备，而是使用新的UI来拍卖。"] = "New auction method, instead of auctioning Gear through the traditional chat bar , the new UI is used to auction."
    L["|cffFFFFFF安装WA：|r此WA是团员端，用于接收团长发出的拍卖消息，没安装的团员显示不了拍卖UI。请团长安装该WA字符串后发给团员安装。如果团员已经安装了BiaoGe插件并且版本在1.7.0或以上，可以不用安装该WA。"] = "|cffFFFFFFInstalled WA:|rThis WA is the member's side, it is used to receive the auction message from the leader, the members who don't have it installed won't be able to show the auction UI. please ask the leader to install this WA string and send it to the members to install. If you have installed BiaoGe plugin and version is 1.7.0 or above, you don't need to install this WA."
    L["|cffFFFFFF拍卖教程：|r团长/物品分配者ALT+点击表格/背包/聊天框的装备来打开拍卖面板，填写起拍价、拍卖时长、拍卖模式即可开始拍卖。可同时拍卖多件装备。"] = "|cffFFFFFFAuction Tutorial:|rTeam Leader/Item Dispenser ALT+click on Gear in the form/pack/chat box to open the auction panel, fill in the Starting Bid, Auction Duration and Auction Mode to start the auction. Multiple Gears can be auctioned at the same time."
    L["拍卖WA字符串"] = "Auction WA string"
    L["YY评价模块初始化成功，已自动加入%s频道，用于共享和查询YY大众评价。"] = "YY evaluation module has been initialized successfully, you have automatically joined %s channel for sharing and checking YY public evaluation."
    L["你已退出%s频道，YY评价模块自动关闭。"] = "You have quit %s channel, YY evaluation module automatically rf ."
    L["点击后会把这些物品分配给你："] = "Clicking on it will assign these items to you:"
    L["没有符合条件的物品"] = "No eligible items"
    L["关注中"] = "Attention in"
    L["欠款：%s\n右键清除欠款"] = "Arrears: %s\nRight click to clear arrears"
    L["欠款：%s"] = "Arrears: %s"
    L["一键分配"] = "One click to assign"
    L["你不是物品分配者，不能使用"] = "You are not the item distributor, you cannot use"
    L["把全部掉落分配给自己，只对史诗装备或套装兑换物生效，其他类型的物品不会生效（例如橙片、任务物品不会自动分配）"] = "Assigning all drops to yourself will only work on Epic Gear or Set Exchange items, not other types of items (e.g. Orange Slice, Quests items will not be automatically assigned)"
    L["你可在插件设置-BiaoGe-其他功能里关闭这个功能"] = "You can rf this function in the plugin settings - BiaoGe - Other Functions."
    L["高亮对应装备"] = "Highlight Gear"
    L["当鼠标悬停在表格装备时，高亮背包里对应的装备。"] = "When hovering over a table Gear, highlight the corresponding Gear in the backpack."
    L["当鼠标悬停在背包装备时，高亮表格里对应的装备。"] = "When hovering over the backpack Gear, highlight the corresponding Gear in the table."
    L["当鼠标悬停在聊天框装备时，高亮表格和背包里对应的装备。"] = "When hovering over the chat box Gear, highlight the corresponding Gear in the table and the backpack."
    L["（背包系统支持原生背包、NDui背包、ElvUI背包、大脚背包、Bagnon）"] = "(The backpack system supports native backpacks, NDui backpacks, ElvUI backpacks, Bigfoot backpacks, and Bagnon backpacks.)"
    L["退队/入队玩家上色"] = "Retreat/Entry player coloring"
    L["在退队/入队的系统消息里，给该玩家名字加上职业色并设置为链接。"] = "Add a career color to the player's name and set it as a link in the exit/entry system message."
    L["一键指定%s"] = "Assign %s in one click"
    L["在地下城和团队副本界面增加一键指定%s按钮。"] = "Added a button to assign %s in the 'Dungeons & Raids' side screen."
    L["队长模式一键自动分配"] = "One-click auto-assign in Captain Mode"
    L["队长分配模式时，在战利品界面增加一键分配按钮。"] = "Added a one-click assign button to the loot screen when in captain assign mode."
    L["点击按钮后会把全部掉落分配给自己，只对史诗装备或套装兑换物生效，其他分类的物品不会生效（例如橙片、任务物品等不会自动分配）。"] = "Clicking the button will assign all drops to yourself, and will only work on Epic Gear or Set Exchange items, but not other categories (e.g. Orange Slices, Quests items, etc. will not be automatically assigned)."
    L["|cffffffff< 进本自动清空表格 >|r\n\n当你进入一个新CD团本时，表格会自动清空，原表格数据会保存至历史表格1"] = "|cffffffff< Auto Clear Form >|r\n\nWhen you enter a new CD group, the form will be automatically cleared and the original form data will be saved to the history form1"
    L["进本自动清空表格"] = "Auto-Empty Form"
    L["<BiaoGe> 已自动清空表格< %s >，分钱人数已改为%s人。原表格数据已保存至历史表格1。"] = "<BiaoGe> has automatically cleared the form < %s >, the number of split has been changed to %s people. The original form data has been saved to History Form 1."
    L["撤回清空"] = "Withdraw clearing"
    L["<BiaoGe> 已撤回清空，还原了表格数据，并删除了历史表格1。"] = "<BiaoGe> has withdrawn the clearing, restored the form data and deleted the history form 1."
    L["只能撤回一次。"] = "Can only be withdrawn once."
    L["没有欠款"] = "There is no outstanding amount"
    L["当前装备自动记录位置："] = "Current Gear Automatically record the position:"
    L["BOSS战开始"] = "Boss battle started"
    L["BOSS击杀成功"] = "BOSS 'Killing Blows' Successful"
    L["BOSS击杀失败"] = "BOSS 'Killing Blows' Failed"
    L["非BOSS战"] = "Non-Boss Battle"
    L["心愿汇总"] = "Wish summary."
    L["（右键删除心愿装备）"] = "(Right click to delete Wish Gear)"
    L["部位"] = "Parts"
    L["心愿"] = "Wish"
    L["复制对方账单"] = "Copy each other's bill"
    L["把对方账单的金额覆盖我当前表格的金额"] = "Overwrite the amount of the other party's bill with the amount of my current form"
    L["不会对漏记的装备和金额生效。"] = "Will not work on missed Gear and amounts."
    L[" {rt1}拍卖倒数{rt1}"] = " {rt1}Auction Countdown{rt1}"
    L["清空表格"] = "Empty Form"
    L["一键清空全部装备、买家、金额，同时还清空关注和欠款。"] = "Clear all Gear, Buyers, Amounts and also clear Concerns and Debts in one click."
    L["清空心愿"] = "Empty Wish List"
    L["一键清空全部心愿装备"] = "Empty all wishes with one click."
    L["指定%s"] = "Specify %s"
    L["一键指定副本伽马%s"] = "Specify the copy gamma %s with one click"
    L["副本已锁定"] = "The copy has been 'Increase Spell Dam 16'."
    L["装等+职业"] = "Class + Profession"
    L["输入你的职业、天赋等"] = "Enter your profession, talents, etc."
    L["输入你的经验、WCL分数等"] = "Enter your experience, WCL score, etc."
    L["自定义文本1"] = "Custom Text 1"
    L["自定义文本2"] = "Custom text 2"
    L["没有收入"] = "No income"
    L["< 收 %s 入 >"] = "< Income %s >"
    L["< 支 %s 出 >"] = "< Expenses %s Out >"
    L["< 总 %s 览 >"] = "< Total %s Pageview >"
    L["< 工 %s 资 >"] = "< Salary >"
    L["长按ALT：仅通报总览"] = "Press and hold ALT: overview only"
    L["长按SHITF：仅通报罚款"] = "Press and hold SHITF: only fines are notified."
    L["———通报总览———"] = "--- Notify Overview ---"
    L["< 总 %s 览 >"] = "< Total %s Page >"
    L["< 工 %s 资 >"] = "< Work %s Salary >"
    L["———通报罚款———"] = "--- Notification of fines ---"
    L["———通报总览———"] = "--- Notify Overview ---"
    L["———通报罚款———"] = "--- Notification of fines ---"
    L["没有罚款"] = "No fines"
    L["没有支出"] = "No expenditure"
    L["通报流拍"] = "notification of abortive auctions"
    L["流拍："] = "Streaming auction:"
    L["没有流拍装备"] = "No Out-of-sale Gear"
    L["%s 流拍装备一共%s件 %s"] = "%s Sold out Gear A total of %s pieces %s"
    L["心愿"] = "Wish"
    L["日期："] = "Date:"
    L["频道名称："] = "Channel Name:"
    L["评价："] = "Evaluation:"
    L["理由："] = "Reason:"
    L["打包交易"] = "PackingDeal"
    L["表格里没找到此次交易的装备，或者该装备已记过账"] = "The Gear for this transaction is not found in the table, or the Gear has already been accounted for."
    L["不能设置为心愿，因为该装备不是正常掉落"] = "Cannot be set as a Wish because the Gear is not a normal drop."
    L["不能设置为心愿，因为该BOSS的心愿格子已满"] = "Cannot be set as a Wish because the Boss's Wish Grid is full."
    L["掉落后会提醒"] = "Alerts when dropped"
    L["重置为默认方案"] = "Reset to default"
    L["不能设置该装备为心愿，可能因为该装备不是正常掉落"] = "Cannot set this Gear as a Wish, probably because the Gear is not a normal drop"
    L["不能设置该装备为心愿，因为该BOSS的心愿格子已满"] = "Cannot set this Gear as a Wish, because the Boss's Wish Grid is full."
    L["心愿装备"] = "Wish Gear"
    L["右键取消心愿装备"] = "Right click to cancel the Wish Gear"
    L["装绑"] = "BoE"
    L["当前表格"] = "Current Form"
    L["< 当前表格 >"] = "< Current Form >"
    L["表格的核心功能都在这里"] = "The core functions of the form are all here"
    L["心愿清单"] = "Wishlist"
    L["< 心愿清单 >"] = "< Wishlist >"
    L["你可以设置一些装备，这些装备只要掉落就会提醒，并且自动关注团长拍卖"] = "You can set up Gears that will alert you when they are dropped and automatically follow the head auction."
    L["装备库"] = "Gear Lib"
    L["< 装备库 >"] = "< Gear Library >"
    L["查看所有适合你的装备"] = "See all the Gears that fit your needs"
    L["对账"] = "Reconciliation"
    L["< 对账 >"] = "< Reconciliation >"
    L["当团队有人通报BiaoGe/RaidLedger/大脚的账单，你可以选择该账单，来对账"] = "When someone on your team reports a BiaoGe/RaidLedger/Bigfoot bill, you can select that bill to reconcile it."
    L["只对比装备收入，不对比罚款收入，也不对比支出"] = "Compare only Gear income, not fine income or expenses."
    L["别人账单会自动保存1天，过后自动删除"] = "Other people's bills will be automatically saved for 1 day and deleted automatically after that."
    L["YY评价"] = "YY Evaluation"
    L["< YY评价 >"] = "< YY Rating"
    L["|cff808080（右键：开启/关闭该模块）|r"] = "|cff808080 (Right click: 'Freezing Trap Effect' /rf the module)|r"
    L["你可以给YY频道做评价，帮助别人辨别该团好与坏"] = "You can rate a YY channel to help others recognize whether it is good or bad."
    L["你可以查询YY频道的大众评价"] = "You can check the public rating of a YY channel"
    L["聊天频道的YY号变为超链接，方便你复制该号码或查询大众评价"] = "The YY number of a chat channel becomes a hyperlink, so that you can copy the number or check the public rating."
    L["替换集结号的评价框，击杀当前版本团本尾王后弹出"] = "Replaced the evaluation box of 'Killing Blows', which pops up after the current version of the group book 'King of Tail'."
    L["< 团本攻略 >"] = "< Troupe Tips >"
    L["了解BOSS技能和應對策略、職業職責"] = "Understanding BOSSSkills and coping strategies, career responsibilities"
    L["序号"] = "Serial Number"
    L["等级"] = "Level"
    L["装备"] = "Gear"
    L["获取途径"] = "Acquisition"
    L["奥\n妮\n克\n希\n亚"] = "Al'ar \n Ninh \n K\n Hsi \n Ya"
    L["海\n里\n昂"] = "Hai \n Ri \n Ang"
    L["杂项"] = "Miscellaneous"
    L["小怪"] = "Gadgets"
    L["该部位没有合适当前过滤方案的装备"] = "There are no Gears in this section that fit the current filtering scheme"
    L["请在下方选择一个过滤方案"] = "Please select a filter below"
    L["没有过滤方案"] = "No filtering options"
    L["件"] = "Pieces"
    L["过滤方案："] = "Filtering scheme:"
    L["装备库："] = "Gear Library:"
    L["自动关注心愿装备：%s。团长拍卖此装备时会提醒"] = "Auto-follow Wish Gear : %s. Alerts when the head auctioneer auctions this Gear."
    L["|cffffffff< 背景材质透明度 >|r|cff808080（右键还原设置）|r\n\n1、调整背景材质透明度"] = "|cffffffff< Background material transparency >|r|cff808080 (right-click to restore settings)|r\n\n1, 'Improved Gouge' Background material transparency"
    L["背景材质透明度"] = "Background Material Transparency"
    L["岩石"] = "Rocks"
    L["大理石"] = "Marble"
    L["黑夜"] = "Black"
    L["皇帝的新衣"] = "Emperor's New Clothes"
    L["背景材质"] = "Background Texture "
    L["日常任务"] = "Everyday Quests "
    L["更改至第几位"] = "Change to the first digit"
    L["修改名称/图标"] = "Modify name/icon"
    L["正在修改方案："] = "The program is being modified:"
    L["更改顺序"] = "Changing order"
    L["删除方案"] = "Deleting programs"
    L["使用装备过滤方案："] = "Use Gear to filter schemes:"
    L["左键使用方案"] = "Left-click to use the scheme"
    L["右键修改方案"] = "Right-click to modify a scheme"
    L["< 装备过滤 >"] = "< Gear Filtering >"
    L["选择方案："] = "Select the scheme:"
    L["新建过滤方案"] = "New filtering scheme"
    L["名称："] = "Name:"
    L["图标："] = "Icon:"
    L["确定"] = "Determine"
    L["名称"] = "Name"
    L["图标"] = "Icon"
    L["不能新建"] = "Cannot create new"
    L["不能修改"] = "Cannot be modified"
    L["还需填写："] = "Still need to fill in:"
    L["返回"] = "Returns"
    L["new"] = "new"
    L["方案数量已达上限，不能再新建方案"] = "The number of programs has reached the upper limit, can not be new programs"
    L["新建过滤方案"] = "New filter program"
    L["重置"] = "Reset"
    L["把方案重置为默认值"] = "Reset the program to the default value."
    L["默认方案"] = "Default"
    L["其他"] = "Other"
    L["勾选全部多选框"] = "Check all boxes"
    L["取消勾选全部多选框"] = "Uncheck all boxes"
    L["自定义装备过滤方案"] = "Custom Gear filtering scheme"
    L["装备属性中包含特定词缀时，就会被过滤。例如勾选了力量，如果装备中有力量属性，则该装备会被过滤"] = "Gear 'Lesser Stats' will be filtered if it contains certain words. For example, if 'Daunting Growl' is checked, if there are 'Daunting Growl' and 'Lesser Stats' in Gear, then the Gear will be filtered."
    L["装备词缀过滤"] = "Gear word filter"
    L["例如勾选了单手剑，如果装备是单手剑，则会被过滤"] = "For example, if 'One-Handed Swords' is checked, the Gear will be filtered if it is 'One-Handed Swords'."
    L["武器类型过滤"] = "Weapon Type Filter"
    L["例如勾选了布甲，如果装备是布甲，则会被过滤"] = "For example, if 'Ward of Zanzil Passive' is checked, Gear will be filtered if it is 'Ward of Zanzil Passive'."
    L["护甲类型过滤"] = "Strong Troll's Blood Elixir' type filter."
    L["像套装兑换物这种有职业限定的装备，不适合你的会被过滤"] = "Gear that has an occupation limit, such as Set Exchange, will be filtered if it doesn't fit you."
    L["职业限定过滤"] = "Profession-specific filtering"
    L["没有%s任一属性的装备会被过滤（武器、饰品、圣物除外）"] = "Gear without any of the 'Lesser Stats' will be filtered (except for weapons, jewelry, and dmg11)."
    L["坦克专属过滤"] = "Tank-specific filters"
    L["死亡骑士-鲜血"] = "Deaths Knight - Blood"
    L["死亡骑士-冰霜/邪恶"] = "Deaths Knight - 'Felcloth Hood' / Evil"
    L["战士-防御"] = "Warrior - Defense"
    L["战士-武器/狂怒"] = "Warrior - Weapon / 'Netherfury Belt"
    L["圣骑士-神圣"] = "Paladin - Holy"
    L["圣骑士-防御"] = "Paladin - Defense"
    L["圣骑士-惩戒"] = "Paladin - Discipline"
    L["猎人"] = "Hunter"
    L["萨满-元素"] = "Shaman - Elemental"
    L["萨满-增强"] = "Shaman - Enhance"
    L["萨满-恢复"] = "Shaman - Renew"
    L["德鲁伊-平衡"] = "Druid - Balance"
    L["德鲁伊-巨熊"] = "Druid - Bear"
    L["德鲁伊-猎豹"] = "Druid - 'Water Walk"
    L["德鲁伊-恢复"] = "Druid - Renew"
    L["盗贼"] = "Thief"
    L["术士"] = "Warlock"
    L["法师"] = "Mage"
    L["牧师-戒律/神圣"] = "Cleric - Ragnarok/Holy"
    L["牧师-暗影"] = "Cleric - Shadow"
    L["这里是指法系的副手，不是物理dps的副手武器"] = "This is a reference to lawful sidearms, not physical dps sidearms"
    L["单手剑"] = "One-Handed Swords"
    L["单手斧"] = "One-Handed Axes"
    L["单手锤"] = "One-Handed Maces"
    L["匕首"] = "Daggers."
    L["拳套"] = "Scarshield Portal"
    L["双手剑"] = "Two-Handed Swords"
    L["双手斧"] = "Two-Handed Axes"
    L["双手锤"] = "Two-Handed Maces"
    L["长柄武器"] = "Polearms"
    L["法杖"] = "Staves."
    L["枪"] = "Polearms Staves"
    L["弓"] = "Bows."
    L["弩"] = "Hammertoe's Sacrifice."
    L["魔杖"] = "Pillar Delving"
    L["投掷武器"] = "Cooking Weapons"
    L["布甲"] = "Ward of Zanzil Passive'."
    L["全部布甲会被过滤（披风除外，否则本来合适你的披风也可能会被过滤）"] = "All 'Ward of Zanzil Passive' will be filtered (except cloaks, which may be filtered even if they fit you)."
    L["皮甲"] = "Leather Armor"
    L["锁甲"] = "Windfury Totem"
    L["板甲"] = "Plate Mail"
    L["盾牌"] = "Attract Rift Spawn"
    L["圣契"] = "Sacred Covenants"
    L["神像"] = "Energy Siphon"
    L["图腾"] = "Shadow Wrath"
    L["魔印"] = "Magic Seal"
    L["过滤职业限定的装备"] = "Filtering Professionally Limited Gear"
    L["过滤职业限定的装备"] = "Filtering profession-specific Gear"
    L["像套装兑换物这种有职业限定的装备，不适合你的会被过滤"] = "Gear that is limited to a specific profession, such as set exchanges, will be filtered if they don't fit you."
    L["过滤没有坦克属性的装备"] = "Filter Gear that doesn't have 'Lesser Stats'."
    L["周常"] = "Weekly"
    L["该周常是指达拉然的周常，不是ICC副本内的周常"] = "This is Dalaran's regular, not ICC's regular."
    L["没有%s属性的装备（武器和饰品部位除外）"] = "Gear without %s 'Lesser Stats' (except for weapon and jewelry items)."
    L["含有%s属性的装备"] = "Gear with %s 'Lesser Stats'."
    L["如果你想关闭该功能，可在插件设置-BiaoGe-角色总览里关闭"] = "If you want to rf this feature, you can rf it in the plugin settings - BiaoGe - Character Overview."
    L["SHIFT+点击："] = "SHIFT+Click:"
    L["< 我是教程 >"] = "< I'm a tutorial >"
    L["鉴于部分玩家找不到|cff00BFFF切换模块|r的按钮，特做此教程：\n按钮就在底下|cffFF0000红色框框|r里"] = "Since some players can't find the |cff00BFFF switch module |r button, here's a tutorial: \n button is at the bottom of the |cffFF0000 red box |r"
    L["@_@ 我知道了。。"] = "@_@ I got it."
    L["伽马"] = "Gamma."
    L["英雄"] = "Seal of the Crusader Judgement Increase"
    L["该BOSS攻略提供：@大树先生\n点击复制NGA攻略地址"] = "This BOSS Raiders provided by:@ Mr. Big Tree\nClick to copy NGA Raiders address"
    L["3、右键聊天频道玩家的菜单里增加密语模板按钮"] = "3、Right click chat channel player's menu to add secret message template button"
    L["4、右键聊天输入框增加密语模板按钮"] = "4、Right click chat input box to add secret message template button"
    L["< 查询大众评价 >"] = "< Query Public Evaluation"
    L["1、对BiaoGeYY频道的在线玩家发出该YY的请求"] = "1、Send a request for this YY to the online players of BiaoGeYY channel"
    L["2、如果这些玩家有该YY的评价，则会通过匿名方式把评价发送给你"] = "2、If these players have the rating of the YY, they will send the rating to you anonymously."
    L["3、不同时间查询到的大众评价可能会不同，因为在线的玩家会不同"] = "3、The public evaluation may be different at different time because the online players may be different."
    L["使用密语模板"] = "Using Secret Message Template"
    L["查询正在初始化，请稍后再试"] = "The query is initializing, please try again later."
    L["正在查询中"] = "Query in progress"
    L["查询CD中，剩余%s秒"] = "Query CD in progress, %s seconds remaining"
    L["正在查询YY%s的大众评价"] = "Querying YY%s of public evaluation"
    L["详细"] = "Detailed"
    L["|cffFFFFFF左键：|r查询大众评价"] = "|cffFFFFFFSHIFT+Left:|rQuery public rating"
    L["|cffFFFFFFSHIFT+左键：|r复制该号码"] = "|cffFFFFFFSHIFT+Left: |rCopy the number"
    L["以往查询结果(%s)："] = "Results of previous queries (%s):"
    L["以往查询结果(可能已过时)："] = "Previous query results (may be outdated):"
    L["|cff00FF00好评：%s个|r"] = "|cff00FF00Reviews: %s of |r"
    L["|cffFFFF00中评：%s个|r"] = "|cffFFFF00中评：%s个|r"
    L["|cffDC143C差评：%s个|r"] = "|cffDC143C Bad reviews: %s of |r"
    L["查询成功：YY%s的评价|cffFFFFFF一共%s个|r。|cff00FF00好评%s个|r，|cffFFFF00中评%s个|r，|cffDC143C差评%s个。|r%s"] = "Query Success: yy%s of reviews |cffFFFFFF a total of %s of |r. |cff00FF00 good reviews %s of |r, |cffFFFF00 medium reviews %s of |r, |cffDC143C bad reviews %s of. |r%s"
    L["查询成功！CD"] = "Query Successful!"
    L["你的评价可以帮助别人辨别该团好与坏\n当其他玩家查询大众评价而你有该YY的评价时，会以匿名的方式发送给对方"] = "Your rating can help others identify the group as good or bad \n When other players query the mass rating and you have a rating for that YY, it will be sent to the other player in an anonymous way"
    L["你的评价被其他玩家查询的次数"] = "The number of times your evaluation has been queried by other players"
    L["1、预设成就、装等、自定义文本，当你点击集结号活动密语时会自动添加该内容"] = "1、Preset Achievement, Pretend, Custom text, when you click on the rally activity secret message will automatically add the content"
    L["2、按住SHIFT+点击密语时不会添加"] = "2、When you hold down SHIFT+click on the secret word, it will not be added."
    L["|cff808080（右键打开设置）|r"] = "|cff808080 (right click to open settings)|r"
    L["|cff808080（左键打开表格，右键打开设置）|r"] = "|cff808080 (left click to open table, right click to open settings)|r"
    L["该攻略是按照25H去呈现，但由于暴雪数据库问题，部分技能链接里的描述文本并不符合25H的真实情况。请看技能的介绍文本"] = "The strategy is presented according to 25H, but due to Blizzard database problems, the description text in some Skills links does not match the real situation of 25H. Please see the Skills description text"
    L["|cffffffff< 角色5人本完成总览 >|r\n\n1、在队伍查找器旁边显示角色5人本完成总览"] = "|cffffffff< Character 5-player completion overview >|r\n\n1, show Character 5-player completion overview next to team finder"
    L["显示角色5人本完成总览"] = "Show Character 5-player overview*."
    L["|cffffffff< 团本攻略字体大小 >|r|cff808080（右键还原设置）|r\n\n1、调整该字体的大小"] = "|cffffffff< Group Tips Font Size >|r|cff808080 (Right click to restore settings)|r\n\n1, 'Improved Gouge' The size of the font."
    L["团本攻略字体大小"] = "Troupe Raider font size"
    L["|cffffffff< 密语模板 >|r\n\n1、预设成就、装等、自定义文本，当你点击集结号活动密语时会自动添加该内容\n2、按住SHIFT+点击密语时不会添加"] = "|cffffffff< Cipher Template >|r\n\n1, Preset Achievement, Attire, Custom Text, will be added automatically when you click on the Gathering Activity Cipher \n2, will not be added when you hold down SHIFT+click on the cipher"
    L["密语模板"] = "Secret message template"
    L["< 历史搜索记录 >"] = "< History of 'Pick Pocket' records >"
    L["|cffFFFFFF左键：|r搜索该记录\n|cffFFFFFF右键：|r删除该记录"] = "|cffFFFFFFLeft: |r 'Pick Pocket' the record \n|cffFFFFFFRight: |r delete the record"
    L["把搜索文本添加至历史记录"] = "Add the text 'Pick Pocket' to the history."
    L["密语模板"] = "Secret message templates"
    L["< 密语模板 >"] = "< Secret word template >"
    L["成就"] = "Achievement"
    L["成就ID："] = "Achievement ID:"
    L["成就ID参考"] = "Achievement ID Reference"
    L["当前没有成就"] = "There are currently no achievements"
    L["装等"] = "Level"
    L["自定义文本"] = "Custom Text"
    L["自定义文本参考"] = "Custom Text Reference"
    L["1、可以输入你的职业、天赋"] = "1、You can input your profession, talent"
    L["2、或你的经验、WCL分数等等"] = "2, or your experience, WCL score, etc."
    L["其他功能"] = "Other"
    L["|cffffffff< 按队伍人数排序 >|r\n\n1、集结号活动可以按队伍人数排序"] = "|cffffffff< Sort by team size >|r\n\n1, Rally activities can be sorted by team size"
    L["按队伍人数排序"] = "Sort by team size"
    L["|cffFFFFFF左键：|r搜索该记录\n|cffFFFFFF右键：|r删除该记录"] = "|cffFFFFFFLeft click:|r 'Pick Pocket' the record\n|cffFFFFFFRight click:|rDelete the record"
    L["集结号"] = "MeetingHorn"
    L["|cffffffff< 历史搜索记录 >|r\n\n1、给集结号的搜索框增加一个历史搜索记录，提高你搜索的效率"] = "|cffffffff< Historical 'Pick Pocket' Record >|r\n\n1, add a historical 'Pick Pocket' record to the 'Pick Pocket' box of the Rally, to increase your 'Pick Pocket' 'Ice Totem'."
    L["历史搜索记录"] = "Historical 'Pick Pocket' Records"
    L["|cffffffff< 不自动退出集结号频道 >|r\n\n1、这样你可以一直同步集结号的组队消息，让你随时打开集结号都能查看全部活动"] = "|cffffffff< Do not auto-logout from Rally channel >|r\n\n1, this way you can always synchronize Rally's team messages, so that you can check all the activities anytime you open the Rally."
    L["不自动退出集结号频道"] = "Do not automatically log out of the Muster channel"
    L["|cffffffff< YY评价 >|cff808080（右键：开启/关闭该模块）|r|r\n\n1、你可以给YY频道做评价，帮助别人辨别该团好与坏\n2、你可以查询YY频道的大众评价\n3、聊天频道的YY号变为超链接，方便你复制该号码或查询大众评价\n4、替换集结号的评价框，击杀当前版本团本尾王后弹出\n"] = "|cffffffff< YY Evaluation >|cff808080 (Right click: 'Freezing Trap Effect' /rf the module) |r|r\n\n1, you can rate the YY channel to help others recognize the group as good or bad \n2, you can query the public rating of the YY channel \n3, the YY number of the chat channel becomes hyperlinks to make it easier for you to Copy the number or query the public evaluation\n4, Replace the evaluation box of the rally, 'Killing Blows' Current version of the group book after the tail king pops up\n"
    L["模块开关"] = "Module switch"
    L["开启"] = "Freezing Trap Effect"
    L["该模块已关闭。右键底部标签页开启"] = "The module has rf . Right click on the bottom tab 'Freezing Trap Effect"
    L["< 历史搜索记录 >"] = "< History of 'Pick Pocket' record >"
    L["把搜索文本添加至历史记录"] = "Add 'Pick Pocket' text to history"
    L["团本攻略"] = "Group Tips"
    L["|cffffffff< 团本攻略 >|r\n\n1、了解BOSS技能和应对策略、职业职责\n"] = "|cffffffff< Group Tips >|r\n\n1, understand the BOSSSkills and coping strategies, occupational duties\n"
    L["查看该BOSS攻略"] = "View this BOSS strategy guide"
    L["当前时光徽章不可用"] = "Currently Time Badge is not available"
    L["< BOSS >"] = "< BOSS >"
    L["< 技能应对 >"] = "< Skills"
    L["< 职业职责 >"] = "< Career Responsibilities >"
    L["（SHIFT+点击技能可发送到聊天框）"] = "(SHIFT+click on Skills to send to the chat box.)"
    L["该BOSS攻略提供：@大树先生"] = "This Boss Skill is provided by @Mr. Big Tree"
    L["介绍："] = "Presentation:"
    L["应对："] = "Response:"
    L["坦克预警"] = "Tank warning"
    L["输出预警"] = "Output Early Warning"
    L["治疗预警"] = "Fire Blast' Early warning"
    L["英雄难度"] = "Seal of the Crusader Judgement Increase' Difficulty"
    L["灭团技能"] = "Extermination Skills"
    L["重要"] = "Important"
    L["可打断技能"] = "May 'Flame Protection' Skills"
    L["法术效果"] = "Spell Effects"
    L["诅咒"] = "Curse"
    L["中毒"] = "Poison"
    L["疾病"] = "Undead Slayer 108"
    L["坦克职责"] = "Tank Duty"
    L["治疗职责"] = "Fire Blast' Duty"
    L["输出职责"] = "Output Duty"
    L["近战职责"] = "Melee Duty"
    L["远程职责"] = "Ranged Duty"
    L["该副本没有团本攻略"] = "There is no group guide for this copy"
    L["< BiaoGe > 你的当前版本%s已过期，请更新插件。"] = "< BiaoGe > Your current version of %s has expired, please update the plugin."
    L["团长YY（根据聊天记录帮你生成）"] = "Troupe Leader YY (generated for you based on chat logs)"
    L["详细评价"] = "Detailed Evaluation"
    L["< 快速评价 >"] = "< Quick Evaluation >"
    L["恭喜你们击杀尾王！请给团长个评价吧！"] = "Congratulations on 'Killing Blows' Tail King! Please give the leader a rating!"
    L["YY号必填，填写数字"] = "YY number is required, fill in the numbers"
    L["评价:"] = "Rating."
    L["评价必填，默认中评"] = "Required, default rating"
    L["必填"] = "Required field"
    L["修改评价"] = "Modify Evaluation"
    L["详细评价"] = "Detailed evaluation"
    L["感谢你的评价：YY%s，|cff%s%s|r"] = "Thank you for your review: YY%s,|cff%s%s|r"
    L["保存"] = "Save"
    L["详细评价"] = "Detailed Evaluation"
    L["|cffffffff< 详细评价 >|r\n\n1、在金团表格里写详细评价"] = "|cffffffff< Detailed Evaluation >|r\n\n1, Write Detailed Evaluation in Golden Group Form"
    L["|cffffffff< 修改评价 >|r\n\n1、该YY号已有评价，去金团表格里修改评价"] = "|cffffffff< Modify Evaluation >|r\n\n1, the YY number has been evaluated, go to the gold group form to modify the evaluation"
    L["退出"] = "Exit"
    L["|cffffffff< 装备记录通知字体大小 >|r|cff808080（右键还原设置）|r\n\n1、调整该字体的大小"] = "|cffffffff< Gear record notification font size >|r|cff808080 (right-click to restore settings)|r\n\n1, 'Improved Gouge' the size of the font"
    L["装备记录通知字体大小"] = "Gear record notification font size"
    L["|cffffffff< 交易通知字体大小 >|r|cff808080（右键还原设置）|r\n\n1、调整该字体的大小"] = "|cffffffff< Transaction notification font size >|r|cff808080 (right-click to restore settings)|r\n\n1, 'Improved Gouge' Size of this font"
    L["交易通知字体大小"] = "Transaction notification font size"
    L["|cffffffff< 当前表格 >|r\n\n1、表格的核心功能都在这里"] = "|cffffffff< Current Form >|r\n\n1, the core functions of the form are here"
    L["当前表格"] = "Current Form"
    L["对账"] = "Reconciliation"
    L["心愿清单"] = "Wish List"
    L["YY评价"] = "YY Evaluation"
    L["团员插件版本"] = "Groupware Plugin Version"
    L["插件版本：%s"] = "Plugin Version: %s"
    L["当前时光徽章："] = "Current time badge:"
    L["|cffFFFFFF左键：|r查询|cff00BFFFYY%s|r的大众评价\n|cffFFFFFFSHIFT+左键：|r复制该YY号"] = "|cffFFFFFFLeft: |rQuery|cff00BFFFYY%s|rPopular Rating\n|cffFFFFFFSHIFT+Left: |rCopy this YY number"
    L["通报至团队通知频道"] = "Notify to team notification channel"
    L["通报至团队频道"] = "Notify to team notification channel"
    L["|cffffffff< 拍卖倒数时长 >|r|cff808080（右键还原设置）|r\n\n1、拍卖装备倒数多久，默认是8秒"] = "|cffffffff< Auction Countdown Duration >|r|cff808080 (right click to restore settings)|r\n\n1, Auction Gear countdown how long, the default is 8 seconds"
    L["拍卖倒数时长(秒)"] = "Auction Countdown Duration (sec)"
    L["|cffffffff< 拍卖倒数 >|r\n\n1、该功能只有团长或物品分配者可用\n2、ALT+点击当前表格、背包、聊天框的装备，自动开始拍卖倒数\n3、背包目前支持原生背包、NDUI背包、EUI背包、大脚背包\n"] = "|cffffffff< Auction Countdown >|r\n\n1, this function is only available to the leader or item distributor\n2, ALT+click on Gear in the current table, backpack, and chat box to automatically start the Auction Countdown\n3, Backpacks currently support native backpacks, NDUI backpacks, EUI backpacks, and Bigfoot backpacks\n"
    L["拍卖倒数"] = "Auction Countdown"
    L["你已共享|r |cff00FF00%s|r |cffffffff人次评价"] = "You've shared |r |cff00FF00%s|r |cffffffffff person reviews"
    L["{rt7}倒数暂停{rt7}"] = "{Countdown to 'Summon Tamed Boar' {rt7}"
    L[" {rt1}拍卖倒数"] = " {rt1}Countdown to the auction."
    L["秒{rt1}"] = "Seconds."
    L["（左键修改评价，SHIFT+左键查询大众评价，ALT+右键删除评价）"] = "(Left click to change rating, SHIFT+Left click to check public rating, ALT+Right click to delete rating)"
    L["|cffffffff< 共享我的评价 >   （你已共享|r |cff00FF00%s|r |cffffffff人次评价）|r\n\n1、当别人查询大众评价时，如果你有该YY的评价，则会以匿名的方式共享给对方\n2、如果你不开启该功能，则你的查询大众评价功能会被禁用，因为共享是相互的\n3、开启该功能后，会使聊天记录里的YY号变为超链接\n4、没满级的角色会被禁止共享和使用查询大众评价"] = "|cffffffff< Share My Evaluation > (You have shared |r |cff00FF00%s|r |cffffffffff sub-evaluations)|r\n\n1, when others query the public evaluation, if you have the evaluation of that YY, then it will be shared to the other party in an anonymous way \n2, if you don't 'Freezing Trap Effect' the function, then the function of your query public evaluation will be changed. If you don't 'Freezing Trap Effect' the function, then your public evaluation function will be disabled because sharing is mutual. 3. 'Freezing Trap Effect' will change the YY number in the chat log to a hyperlink. 4. Characters who have not reached their full level will be prohibited from sharing and using the public evaluation function."
    L["金币已超上限！"] = "Gold has exceeded the upper limit!"
    L["|cffffffff< YY评价 >|r\n\n1、你可以查询某个YY的评价如何\n2、降低你进入坑团的可能\n"] = "|cffffffff< YY Evaluation >|r\n\n1, you can check how a certain YY is evaluated\n2, reducing the possibility of you entering the pit group\n"
    L["< 新增评价 >"] = "< Add Evaluation >"
    L["YY号必填，填写数字"] = "YY number is required, fill in the numbers"
    L["频道名称:"] = "Channel Name."
    L["频道名称选填，方便自己辨认是哪个YY\n该名称不会共享给别人，仅自己可见"] = "The channel name is optional, so you can easily recognize which YY\n you are on. The name will not be shared with others, and will only be visible to you."
    L["评价:"] = "Rating."
    L["评价必填，默认中评"] = "Required, default rating is neutral"
    L["理由:"] = "Reason: Reason is optional."
    L["理由选填"] = "Reason is optional"
    L["必填"] = "Required"
    L["选填"] = "Optional"
    L["好评或差评需要填写不少于6字"] = "Good or bad comments need to fill in no less than 6 words"
    L["保存评价"] = "Save Evaluation"
    L["|cffffffff< 保存评价 >|r\n\n1、必填项填完才能保存\n2、同一个YY只能写一次评价，但你可以修改之前的评价"] = "|cffffffff< Save Evaluation >|r\n\n1, mandatory items to be filled out to save\n2, the same YY can only write an evaluation once, but you can modify the previous evaluation"
    L["退出修改"] = "Exit Modify"
    L["该YY已有评价，需要修改吗？"] = "This YY already has a rating, do you need to modify it?"
    L["< 我的评价 >"] = "< My Evaluation"
    L["序号"] = "Serial Number"
    L["日期"] = "Date"
    L["YY"] = "YY"
    L["频道名称"] = "Channel Name"
    L["评价"] = "Evaluation"
    L["理由"] = "Reason"
    L["正在初始化"] = "Initializing"
    L["|cffffffff< 共享我的评价 >   （你已共享|r |cff00FF00%s|r |cffffffff人次评价）|r\n\n1、当别人查询大众评价时，如果你有该YY的评价，则会以匿名的方式共享给对方\n2、如果你不开启该功能，则你的查询大众评价功能会被禁用，所以共享是相互的\n3、没满级的角色会被禁止共享和使用查询大众评价"] = " If you don't 'Freezing Trap Effect' the function will be disabled, so the sharing is mutual. 3. Characters without full level will be prohibited to share and use to check the public evaluation."
    L["理由"] = "Reason"
    L["好评"] = "Good"
    L["中评"] = "Medium"
    L["差评"] = "Bad"
    L["< 新增评价 >"] = "< Add Rating"
    L["保存评价"] = "Save Rating"
    L["< 修改评价 >"] = "< Modify Rating >"
    L["保存修改"] = "Save changes"
    L["（左键修改评价，SHIFT+左键把yy号发到查询里，ALT+右键删除评价）"] = "(Left click to modify evaluation, SHIFT+Left click to send yy number to query, ALT+Right click to delete evaluation)"
    L["< 查询大众评价 >"] = "< Query public evaluation >"
    L["查询成功：YY%s的评价|cffFFFFFF一共%s个|r。|cff00FF00好评%s个|r，|cffFFFF00中评%s个|r，|cffDC143C差评%s个|r"] = "Query Success: YY%s of evaluations |cffFFFFFF a total of %s of |r. |cff00FF00 favorable evaluations %s of |r, |cffFFFF00 moderate evaluations %s of |r, |cffDC143C unfavorable evaluations %s of |r"
    L["查询成功！CD"] = "Query Successful!"
    L["查询"] = "Query"
    L["无"] = "No"
    L["查询失败：没有找到YY%s的评价。"] = "Query Failed: No reviews found for YY%s."
    L["查询中 "] = "Query in"
    L["个)|r"] = "individual)|r"
    L["无"] = "None"
    L["无"] = "None"
    L["无"] = "None"
    L["历史查询："] = "Historical query:"
    L["筛选："] = "Filter:"
    L["全部"] = "All"
    L[" (0个)"] = " (0)"
    L["无"] = "None"
    L["序号"] = "Serial number"
    L["日期"] = "Date"
    L["YY"] = "YY"
    L["评价"] = "Evaluation"
    L["理由"] = "Rationale"
    L["理由"] = "Reason"
    L["个"] = "Individual"
    L["个"] = "YY"
    L["查询"] = "Inquiry"
    L["共享我的评价"] = "Share my evaluation"
    L["查询"] = "Inquiry"
    L["共享我的评价"] = "Share My Rating"
    L["共享我的评价"] = "Share My Rating"
    L["查询"] = "Inquiry"
    L["< BiaoGe > 金 团 表 格"] = "< BiaoGe > Gold Group Forms"
    L["|cff808080（带的设置为即时生效，否则需要重载才能生效）|r"] = "|cff808080 (with settings for immediate effect, otherwise you need to reload to take effect)|r"
    L["重载界面"] = "Reload Interface"
    L["不能即时生效的设置在重载后生效。"] = "Settings that cannot take effect instantly take effect after reloading."
    L["表格"] = "Tables"
    L["角色总览"] = "CharOverview"
    L["|cffffffff< UI缩放 >|r|cff808080（右键还原设置）|r\n\n1、调整表格UI的大小"] = "|cffffffff< UI Zoom >|r|cff808080 (right-click to restore settings)|r\n\n1, 'Improved Gouge' Form UI size"
    L["UI缩放"] = "UI scaling"
    L["|cffffffff< UI透明度 >|r|cff808080（右键还原设置）|r\n\n1、调整表格UI的透明度"] = "|cffffffff< UI Transparency >|r|cff808080 (right-click to restore settings)|r\n\n1, 'Improved Gouge' Form UI Transparency"
    L["UI透明度"] = "UI Transparency"
    L["|cffffffff< 自动记录装备 >|r\n\n1、在团本里拾取装备时，会自动记录进表格\n2、只会记录橙装、紫装、和蓝色的宝珠，不会记录图纸，小怪掉落会记录到杂项里\n"] = "|cffffffff< Auto Record Gear >|r\n\n1, when picking up Gear in the group book, it will be automatically recorded into the form\n2, only the orange, purple, and blue treasure beads will be recorded, not the drawings, and the monsters' drops will be recorded into the miscellaneous items\n"
    L["自动记录装备"] = "Automatically record Gear "
    L["|cffffffff< 装备记录通知时长 >|r|cff808080（右键还原设置）|r\n\n1、自动记录装备后会在屏幕上方通知记录结果"] = "|cffffffff< Gear Record Notification Duration >|r|cff808080 (right click to restore settings)|r\n\n1, automatically record Gear will be notified at the top of the screen to record the results."
    L["装备记录通知时长(秒)"] = "Gear Record Notification Duration (sec)"
    L["|cffffffff< 交易自动记账 >|r\n\n1、需要配合自动记录装备，因为如果表格里没有该交易的装备，则记账失败\n2、如果一次交易两件装备以上，则只会记第一件装备\n"] = "|cffffffff< Transaction Auto Record >|r\n\n1, need to work with Auto Record Gear because if there is no Gear in the form for that transaction, the record will fail\n2, if there are more than two Gears in a transaction, only the first Gear will be recorded \n"
    L["交易自动记账"] = "Transactions are automatically recorded*."
    L["|cffffffff< 交易通知时长 >|r|cff808080（右键还原设置）|r\n\n1、通知显示多久"] = "|cffffffff< Transaction Notification Duration >|r|cff808080 (right-click to restore the setting)|r\n\n1, how long the notification is displayed for"
    L["交易通知时长(秒)"] = "Transaction notification duration (seconds)"
    L["|cffffffff< 交易通知 >|r\n\n1、交易完成后会在屏幕中央通知本次记账结果\n"] = "|cffffffff< Transaction Notification >|r\n\n1, Notification of the result of this bookkeeping will be made in the center of the screen after the transaction is completed\n"
    L["交易通知"] = "Transaction Notification"
    L["|cffffffff< 记账效果预览框 >|r\n\n1、交易的时候，可以预览这次的记账效果\n2、如果这次交易的装备不在表格，则可以选择强制记账"] = "|cffffffff< Bookkeeping Effect Preview Box >|r\n\n1, when the transaction, you can preview the bookkeeping effect of this time \n2, if the Gear of this transaction is not in the table, you can choose to force bookkeeping"
    L["记账效果预览框"] = "Preview box for bookkeeping effect"
    L["|cffffffff< 高亮拍卖装备 >|r\n\n1、当团长或物品分配者贴出装备开始拍卖时，会自动高亮表格里相应的装备"] = "|cffffffff< Highlight Auction Gear >|r\n\n1, when the leader or item distributor posts a Gear to start the auction, the corresponding Gear in the table will be automatically highlighted."
    L["高亮拍卖装备"] = "Highlight Gear "
    L["|cffffffff< 高亮拍卖装备时长 >|r|cff808080（右键还原设置）|r\n\n1、高亮拍卖装备多久"] = "|cffffffff< Highlight Auction Gear Duration >|r|cff808080 (right-click to restore settings)|r\n\n1, Highlight Auction Gear How long?"
    L["高亮拍卖装备时长(秒)"] = "Highlight Auction Gear Duration (sec)"
    L["|cffffffff< 拍卖聊天记录框 >|r\n\n1、自动记录全团跟拍卖有关的聊天\n2、当你点击买家或金额时会显示拍卖聊天记录"] = "|cffffffff< Auction Chat Log Box >|r\n\n1, Automatically record the whole group's chat related to the auction \n2, Auction Chat Log will be displayed when you click on the buyer or amount of money"
    L["拍卖聊天记录框"] = "Auction Chat Record Box"
    L["|cffffffff< 金额自动加零 >|r\n\n1、输入金额和欠款时自动加两个0，减少记账操作，提高记账效率"] = "|cffffffff< Amount Auto Zero >|r\n\n1, automatically add two zeros when you enter the amount and the amount owed, to reduce the bookkeeping operation and improve the bookkeeping 'Ice Totem'."
    L["金额自动加零"] = "Amounts are automatically added with zero*."
    L["|cffffffff< 对账单保存时长(小时) >|r|cff808080（右键还原设置）|r\n\n1、对账单保存多久后自动删除"] = "|cffffffff< statement saving time (hours) >|r|cff808080 (right click to restore settings)|r\n\n1, how long the statement will be saved and then automatically deleted"
    L["对账单保存时长(小时)"] = "Statement saving time (hours)"
    L["|cffffffff< 进本提示清空表格 >|r\n\n1、每次进入副本都会提示清空表格"] = "|cffffffff< Enter this prompt to clear the form >|r\n\n1, every time you enter the copy will prompt to clear the form"
    L["进本提示清空表格"] = "Enter this prompt to empty the form"
    L["|cffffffff< 按键交互声音 >|r\n\n1、点击按钮时的声音"] = "|cffffffff< Button Interaction Sound >|r\n\n1, Sound when clicking a button"
    L["按键交互声音"] = "Button interaction sound"
    L["|cffffffff< 小地图图标 >|r\n\n1、显示小地图图标"] = "|cffffffff< Small map icon >|r\n\n1, show small map icon"
    L["小地图图标"] = "Mini-map icon"
    L["人"] = "People"
    L["总览数据"] = "Overview data"
    L["巫妖王之怒"] = "WLK "
    L["燃烧的远征"] = "BCC "
    L["经典旧世"] = "Classic "
    L["货币"] = "Currency"
    L["|cffffffff< 清空表格时根据副本难度设置分钱人数 >|r\n\n1、10人团本默认分钱人数为10人\n2、25人团本默认分钱人数为25人"] = "|cffffffff< Setting the number of people to split according to the difficulty of the copy when clearing the table >|r\n\n1, default number of people to split for a 10-player group is 10 people \n2, default number of people to split for a 25-player group is 25 people"
    L["清空表格时根据副本难度设置分钱人数"] = "When clearing the table, set the number of people according to the difficulty of the copy*."
    L["|cffFFFFFF10人团本分钱人数：|r"] = "|cffFFFFFF10M Raid Share Mem Cnt: |r"
    L["|cffFFFFFF25人团本分钱人数：|r"] = "|cffFFFFFF25M Raid Share Mem Cnt: |r"
    L["快捷命令：/BGO"] = "Shortcut 'Enchant Bracer - Superior Strength' : /BGO"
    L["|cffffffff< 清空表格时保留支出补贴名称 >|r\n\n1、只保留补贴名称（例如XX补贴），支出玩家和支出金额正常清空\n2、这样就不用每次都重复填写补贴名称\n3、只有补贴名称，但没有补贴金额的，在通报账单时不会被通报"] = "|cffffffff< Keep the name of the subsidy when clearing the form >|r\n\n1, only the name of the subsidy is kept (e.g. XX subsidy), the player and the amount of the subsidy are cleared as normal \n2, so that you don't have to fill in the name of the subsidy repeatedly every time \n3, if there is only the name of the subsidy but not the amount of the subsidy, it won't be notified when you report the bill."
    L["清空表格时保留支出补贴名称"] = "Keep the name of the subsidy when clearing the form"
    L["< BiaoGe > 金 团 表 格"] = "< BiaoGe > Gold Group Forms"
    L["<说明书与更新记录> "] = "<Instruction and Update Record"
    L["保存至历史表格"] = "Save to History Forms"
    L["该表格已在你历史表格里"] = "The form is already in your History Forms"
    L["历史表格（%d个）"] = "History(%d's)"
    L["已保存至历史表格1"] = "Saved to History Form 1"
    L["设置"] = "Settings"
    L["切换副本难度"] = "Toggle copy difficulty"
    L["10人|cff00BFFF普通|r"] = "10-Players|cff00BFFF Normal|r"
    L["25人|cff00BFFF普通|r"] = "25-Players|cff00BFFF Normal|r"
    L["10人|cffFF0000英雄|r"] = "10-Players|cffFF0000 Heroic |r"
    L["25人|cffFF0000英雄|r"] = "25-Players|cffFF0000 Heroic |r"
    L["确认切换难度为< %s >？"] = "Confirm switching difficulty to < %s >?"
    L["是"] = "No"
    L["否"] = "No"
    L["心愿清单"] = "Wishlist"
    L["清空当前表格"] = "Empty the current table"
    L["关闭心愿清单"] = "rf Wishlist"
    L["清空当前心愿"] = "Empty the current wish list"
    L["对账"] = "Reconciliation"
    L["关闭对账"] = "rf Reconciliation"
    L["要清空表格< %s >吗？"] = "Want to clear the form < %s >?"
    L["角色"] = "Character"
    L["黑龙"] = "Black Dragon"
    L["宝库"] = "Treasure Trove"
    L["赛德精华"] = "Said Essence"
    L["金币"] = "Gold"
    L["< 角色团本完成总览 >"] = "< Character Mission Completion Overview >"
    L["（团本重置时间：%s）"] = "(Reset time: %s)"
    L["当前没有符合的角色"] = "There are currently no matching Characters."
    L["（右键删除角色总览数据）"] = "(Right click to delete Character Overview data)"
    L["（插件右下角右键可删除数据）"] = "(Right click in the bottom right corner of the plugin to delete data)"
    L["< 角色货币总览 >"] = "< Character Currency Overview >"
    L["金"] = "Gold"
    L["合计"] = "Total"
    L["总览数据"] = "Overview data"
    L["你关注的装备开始拍卖了：%s（右键取消关注）"] = "The Gear you are following is up for auction : %s (Right click to unfollow)"
    L["已成功关注装备：%s。团长拍卖此装备时会提醒"] = "Successfully followed Gear : %s. The head of the delegation will be alerted when this Gear is auctioned."
    L["<自动记录装备>"] = "<Automatic Record Gear"
    L["已取消关注装备：%s"] = "Unfollowed Gear : %s"
    L["你的心愿达成啦！！！>>>>> %s(%s) <<<<<"] = "Your wish is granted! >>>>> %s(%s) <<<<<"
    L["已自动记入表格：%s%s(%s) x%d => %s< %s >%s"] = "Auto-recorded in form: %s%s(%s) x%d => %s< %s >%s"
    L["自动关注心愿装备：%s%s。团长拍卖此装备时会提醒"] = "Automatically follow Wish Gear: %s%s. Head of Mission will be alerted when this Gear is auctioned."
    L["自动记录失败：%s%s(%s)。因为%s< %s >%s的格子满了。。"] = "Auto record failure : %s%s(%s). Because the %s< %s >%s grid is full."
    L["自动关注心愿装备失败：%s%s"] = "Autofollow Wish Gear Failed: %s%s"
    L["已自动记入表格：%s%s(%s) => %s< %s >%s"] = "Auto-recorded form: %s%s(%s) => %s< %s >%s"
    L["< 交易记账失败 >"] = "< Failed to credit transaction >"
    L["双方都给了装备，但没金额"] = "Both parties gave Gear, but no amount."
    L["我不知道谁才是买家"] = "I don't know who is the buyer."
    L["如果有金额我就能识别了"] = "If there was a dollar amount, I'd be able to recognize it."
    L["（欠款%d）"] = "(Amount owed %d)"
    L["< 交易记账成功 >"] = "< Record Success >"
    L["< 交易记账成功 >|r\n装备：%s\n买家：%s\n金额：%s%d|rg%s\nBOSS：%s%s|r"] = "< Record Success >|r\nGear : %s\nBuyer : %s\nAmount : %s%d|rg%s\nBOSS : %s%s|r"
    L["表格里没找到此次交易的装备"] = "The Gear of this transaction is not found in the table"
    L["该BOSS格子已满"] = "This BOSS Grid is full"
    L["欠款："] = "Amount owed:"
    L["记账效果预览"] = "Accounting Preview"
    L["无"] = "None"
    L["次"] = "times"
    L["打断"] = "Flame Protection"
    L["级"] = "level"
    L["装等"] = "Installation"
    L["分钟"] = "Minutes"
    L["时间"] = "Time"
    L["已清空表格< %s >，分钱人数已改为%s人。"] = "The form < %s > has been cleared and the number of splitters has been changed to %s of people."
    L["已清空表格< %s >。"] = "Has cleared the form < %s >."
    L["已清空心愿< %s >"] = "Wishlist has been cleared < %s >."
    L["确认清空表格< %s >？"] = "Confirmed cleared form < %s >?"
    L["高亮该天赋的装备"] = "Highlight the Gear for the talent"
    L["<金额自动加零>"] = "<Amounts are automatically zeroed out"
    L["<UI缩放>"] = "<UI Zoom"
    L["<UI透明度>"] = "< UI Transparency"
    L["< BiaoGe > 版本过期提醒，最新版本是：%s，你的当前版本是：%s"] = "< BiaoGe > version expiration reminder, the latest version is: %s, your current version is: %s"
    L["你可以前往curseforge搜索biaoge更新"] = "You can go to curseforge 'Pick Pocket' biaoge for update"
    L["< BiaoGe > 金团表格载入成功。插件命令：%s或%s，小地图图标：%s"] = "< BiaoGe > Gold Group form loaded successfully. Plugin 'Enchant Bracer - Superior Strength' : %s or %s, minimap icon : %s"
    L["星星"] = "Stars"
    L["BiaoGe金团表格"] = "BiaoGe Gold Corps Forms"
    L["显示/关闭表格"] = "Show /rf table"
    L["对比的账单："] = "Compare the bills:"
    L["  项目"] = "  Item"
    L["装备"] = "Gear"
    L["我的金额"] = "My Amount"
    L["对方金额"] = "Cpty Amount"
    L["装备总收入"] = "Gear Total Revenue"
    L["差额"] = "Difference"
    L["买家"] = "Buyer"
    L["金额"] = "Amount"
    L["关注"] = "Attention"
    L["关注中，团长拍卖此装备会提醒"] = "Follow this Gear to be alerted by the auction manager."
    L["右键取消关注"] = "Right click to unfollow"
    L["欠款：%s|r\n右键清除欠款"] = "Arrears: %s|r\nRight click to clear arrears"
    L["坦克补贴"] = "Tank Subsidy"
    L["治疗补贴"] = "Fire Blast' Subsidy"
    L["输出补贴"] = "Output Subsidy"
    L["放鱼补贴"] = "Fish Release Allowance"
    L["人数可自行修改"] = "The number of people can be modified by yourself"
    L["（SHIFT+点击可发送装备，CTRL+点击可通报历史价格）"] = "(SHIFT+click to send Gear , CTRL+click to notify historical price.)"
    L["（ALT+点击可关注装备，SHIFT+点击可发送装备，CTRL+点击可通报历史价格）"] = "(ALT+click to follow Gear , SHIFT+click to send Gear , CTRL+click to inform historical prices)"
    L["欠款金额"] = "Amount owed"
    L["不在团队，无法通报"] = "Not in the team, can not notify"
    L["———通报历史价格———"] = "--- Inform historical price ---"
    L["装备：%s(%s)"] = "Gear : %s(%s)"
    L["月"] = "Month"
    L["日"] = "Day"
    L["，价格:"] = ", Price: , Buyer: , Gear: %s(%s), Price: %s(%s)"
    L["，买家:"] = ", Buyer: , Buyer: , Buyer: , Buyer: , Buyer: , Buyer: , Buyer"
    L["取消交换"] = "Cancel exchange"
    L["你正在交换该行全部内容"] = "You are exchanging the entire contents of the row"
    L["\n点击取消交换"] = "\nClick to cancel the exchange"
    L["交换成功"] = "The exchange was successful"
    L["（ALT+左键改名，ALT+右键删除表格）"] = "(ALT+left click to rename, ALT+right click to delete table)"
    L["保存表格"] = "Save"
    L["把当前表格保存至历史表格"] = "Save current form to history form"
    L["%m月%d日%H:%M:%S\n"] = "%m Month %d Day %H:%M:%S\n"
    L["%s%s %s人 工资:%s"] = "%s%s %s People Salary:%s"
    L["分享表格"] = "Share"
    L["把当前表格发给别人，类似发WA那样"] = "Send the current form to someone else, similar to sending a WA."
    L["当前表格-"] = "Current table-"
    L["历史表格-"] = "Historical table-"
    L["导出表格"] = "Export"
    L["把表格导出为文本"] = "Export form as text"
    L["应用表格"] = "Apply"
    L["把该历史表格复制粘贴到当前表格，这样你可以编辑内容"] = "Copy and paste the historical table into the current table so you can edit the content."
    L["确定应用表格？\n你当前的表格将被"] = "OK to apply the form? \n your current form will be"
    L[" 替换 "] = " replaced"
    L["当前名字："] = "current name:"
    L["名字改为："] = "The name is changed to:"
    L["确定"] = "OK"
    L["取消"] = "Cancel"
    L["（CTRL+点击可通报历史价格）"] = "(CTRL+Click to notify historical price)"
    L["< 历史表格 > "] = "< Historical Tables >"
    L["你正在改名第 %s 个表格"] = "You are renaming %s table"
    L["< |cffFFFFFF10人|r|cff00BFFF普通|r >"] = "< |cffFFFFFF10 people|r|cff00BFFF common|r >"
    L["< |cffFFFFFF25人|r|cff00BFFF普通|r >"] = "< |cffFFFFFF25 people|r|cff00BFFF common|r >"
    L["< |cffFFFFFF10人|r|cffFF0000英雄|r >"] = "< |cffFFFFFF10 man|r|cffFF0000 heroic |r >"
    L["< |cffFFFFFF25人|r|cffFF0000英雄|r >"] = "< |cffFFFFFF25 people|r|cffFF0000 heroic |r >"
    L["心愿1"] = "Wish 1"
    L["心愿2"] = "Wish 2"
    L["已掉落"] = "Dropped."
    L["恭喜你，该装备已掉落"] = "Congratulations, this Gear has been dropped"
    L["右键取消提示"] = "Right click to cancel the alert"
    L["当前团队还有 %s 人也许愿该装备！"] = "There are still %s of people in the current team who also 'Vanish Cooldown Reduction' this Gear!"
    L["查询心愿竞争"] = "Check Wish Competition"
    L["查询团队里，有多少人许愿跟你相同的装备"] = "Check how many people in your team have 'Vanish Cooldown Reduction' the same Gear as yours."
    L["不在团队，无法查询"] = "Can't check if you're not on the team."
    L["恭喜你，当前团队没人许愿跟你相同的装备"] = "Congratulations, no one in your team has the same Gear as Vanish Cooldown Reduction."
    L["分享心愿10PT"] = "Share your wish 10PT"
    L["分享心愿25PT"] = "Share your wish 25PT."
    L["分享心愿10H"] = "Share your wish 10H."
    L["分享心愿25H"] = "Share Wish 25H"
    L["< 我 的 心 愿 >"] = "< My Wish"
    L["副本难度："] = "Duplicate Difficulty:"
    L["频道：团队"] = "Channel: Raid"
    L["频道：队伍"] = "Channel: Team"
    L["不在队伍，无法通报"] = "Not in team, can't inform"
    L["频道：公会"] = "Channel: Guild"
    L["没有公会，无法通报"] = "No guild, unable to inform"
    L["频道：密语"] = "Channel: Secret Message"
    L["没有目标，无法通报"] = "No target, unable to inform"
    L["————我的心愿————"] = "---- my heart's desire ----"
    L["—感谢使用BiaoGe插件—"] = "-Thanks for using BiaoGe plugin-"
    L["队伍"] = "Team"
    L["公会"] = "Guild"
    L["团队"] = "Raid"
    L["密语目标"] = "Cryptic Goals"
    L["心愿清单："] = "Wishlist:"
    L["心愿装备只要掉落就会有提醒，并且掉落后自动关注团长拍卖"] = "WishGear Alerts whenever it drops and automatically follows the Head Auction after it drops"
    L["你今天的运气指数(1-100)："] = "Your luck index for the day (1-100):"
    L["当前表格"] = "Current Table"
    L["历史表格"] = "History"
    L["（当前为自动显示)"] = "(Currently displayed automatically)"
    L["<BiaoGe>金团表格"] = "<BiaoGe>"
    L["左键：|r打开表格"] = "Left button: |r to open the table"
    L["中键：|r切换自动显示角色总览"] = "Middle button: |r to toggle auto-display Character Overview"
    L["（当前为不自动显示)"] = "(Currently not displayed automatically)"
    L["通报流拍"] = "Notification of Auction"
    L["< 流 拍 装 备 >"] = "<Auctioned Equipment"
    L["通报欠款"] = "Notify arrears"
    L["< 通 报 欠 款 >"] = "< Notified Arrears >"
    L["< 合 计 欠 款 >"] = "< Total Arrears >"
    L["没记买家"] = "Unrecorded buyers"
    L["合计欠款："] = "Total arrears:"
    L["———通报欠款———"] = "--- Notification of arrears ---"
    L["{rt7} 合计欠款 {rt7}"] = "{rt7} Total arrears {rt7}"
    L[" 合计欠款："] = " Aggregate arrears:"
    L["没有WCL记录"] = "No WCL records"
    L["读取不到数据，你可能没安装或者没打开WCL插件"] = "No data can be read, you may not have installed or turned on the WCL plugin"
    L["更新时间："] = "Update time:"
    L["< WCL分数 >"] = "< WCL Score"
    L["———通报WCL分数———"] = "--- Communicate WCL score ---"
    L["通报WCL"] = "Communicate WCL"
    L["通报消费"] = "Communicate purch"
    L["< 消 费 排 名 >"] = "< Consumption Ranking"
    L["———通报消费排名———"] = "----Communicate purch rankings ----"
    L["< 通报击杀用时 >"] = "< Notification of 'Killing Blows' time spent"
    L["———通报击杀用时———"] = "---Notification of 'Killing Blows' time spent -----"
    L["分"] = "minutes"
    L["秒"] = "seconds"
    L["击杀用时："] = "Killing Blows' time:"
    L["通报账单"] = "Killing Blows"
    L["< 收  入 >"] = "< Revenue"
    L["Boss："] = "Boss:"
    L["项目："] = "Item:"
    L["< 支  出 >"] = "< Expenses"
    L["< 总  览 >"] = "< General Overview"
    L["< 工  资 >"] = "< Salary >"
    L["———通报账单———"] = "--- Bulletin Bills ---"
    L["< 收 {rt1} 入 >"] = "< Income >"
    L["< 支 {rt4} 出 >"] = "< Expenses"
    L["< 总 {rt3} 览 >"] = "< General {rt3} Overview"
    L["人"] = "People"
    L["< 工 {rt6} 资 >"] = "< Payroll > < Salary {rt6}"
    L["|cffffffff< 心愿清单 >|r\n\n1、你可以设置一些装备，\n    这些装备只要掉落就会有提醒，\n    并且掉落后自动关注团长拍卖\n"] = "|cffffff< Wish List >|r\n\n1, you can set up some Gear , \n these Gear as long as the drop will have a reminder, \n and after the drop automatically focus on the head auction \n"
    L["|cffffffff< 自动记录装备 >|r\n\n1、只会记录紫装和橙装\n2、橙片、飞机头、小怪掉落\n    会存到杂项里\n3、图纸不会自动保存\n"] = "|cffffffff< Auto Record Gear >|r\n\n1, will only record the purple and orange suit\n2, orange pieces, airplane heads, small monster drops\n will be saved to the miscellaneous items\n3, drawings will not be automatically saved\n"
    L["|cffffffff< 对账 >|r\n\n1、当团队有人通报BiaoGe/RaidLedger/大脚的账单，\n    你可以选择该账单，来对账\n2、只对比装备收入，不对比罚款收入，也不对比支出\n3、别人账单会自动保存1天，过后自动删除\n"] = "|cffffffff< Reconciliation >|r\n\n1, when someone in the team informs BiaoGe/RaidLedger/Bigfoot of a bill,\n you can select that bill to reconcile\n2, only Gear income will be compared, not fine income, nor expenses\n3, other people's bills will be automatically saved for 1 day, and deleted after that automatically\n"
    L["|cffffffff< 交易自动记账 >|r\n\n1、需要配合自动记录装备，因为\n    如果表格里没有该交易的装备，\n    则记账失败\n2、如果一次交易两件装备以上，\n    则只会记第一件装备，\n"] = "|cffffffff< Transaction Auto Bookkeeping >|r\n\n1, need to work with the automatic recording of Gear, because \n If there is no Gear in the form for the transaction, \n then the bookkeeping fails \n2, if there are more than two Gear in a transaction, \n then only the first Gear will be recorded, \n"
    L["|cffffffff< 清空当前表格/心愿 >|r\n\n1、表格界面时一键清空装备、买家、金额，同时还清空关注和欠款\n2、心愿界面时一键清空全部心愿装备\n"] = "|cffffffff< Empty Current Form/Wish >|r\n\n1, Empty Gear, Buyer, Amount, Concerns and Outstanding Payment in one click on Form screen\n2, Empty all Wish Gear in one click on Wish screen\n3, and clear all Wish Gear in one click on Wish screen\n4, and clear all Wish Gear in one click on Wish screen."
    L["|cffffffff< 金额自动加零 >|r\n\n1、输入金额和欠款时自动加两个0\n    减少记账操作，提高记账效率\n"] = "|cffffffff< Amount automatically add zero >|r\n\n1, enter the amount and arrears automatically add two 0\n Reduce the bookkeeping operation, improve the bookkeeping 'Ice Totem' \n"
    L["RaidLedger:.... 收入 ...."] = "RaidLedger:.... Revenue ...."
    L["事件：.-|c.-|Hitem.-|h|r"] = "Event:.-|c.-|Hitem.-|h|r"
    L["(%d+)金"] = "(%d+) gold"
    L["收入为："] = "Income for:"
    L["收入为：%d+。"] = "Income for: %d+."
    L["平均每人收入:"] = "Average Income per Person: |c.-|Hitem.-|h|r"
    L["，装备总收入"] = "Gear Total Income"
    L["-感谢使用大脚金团辅助工具-"] = "-Thanks for using the Bigfoot Golden Corps Aid-"
    L["总收入"] = "Total Income"
    L["总支出"] = "Total Expenses"
    L["净收入"] = "Net Income"
    L["分钱人数"] = "Profit Sharer Count"
    L["人均工资"] = "Wages per capita"
    L["历史价格：%s%s(%s)"] = "Historical price: %s%s(%s)"
    L["通报用时"] = "Briefing time"
    L["返回表格"] = "Return"
    L["当前"] = "Current"
    L["没有金额"] = "No amount"
    L["———通报流拍装备———"] = "--- Notification of aborted Gear ---"
    L["欠"] = "owed"
    L["人"] = "people"
    L["< 角色总览设置 >"] = "< Character Overview Settings >"
    L["删除某个角色"] = "Delete a Character"
    L["删除角色"] = "Delete a Character"
    L["巫妖王之怒"] = "Wrath of the Lich King"
    L["燃烧的远征"] = "BCC"
    L["经典旧世"] = "Classic"
    L["货币"] = "Currency"
    L["角色"] = "Character"
    L["（右键打开设置）"] = "(Right click to open settings)"
    L["< 角色货币总览 >"] = "< Character Currency Overview >"
    L["中键：|r切换自动显示角色总览"] = "Middle key: |r to toggle automatic display of the Character overview"
    L["右键：|r打开设置"] = "Right click: |r to open the setting"
    L[" （测试） "] = " (Test)"
    L["通知锁定"] = "Notify Lock"
    L["通知移动"] = "Move"
    L["调整装备记录通知和交易通知的位置\n快捷命令：/BGM"] = "Improved Gouge' Gear Record notification and trade notification location \n quick 'Enchant Bracer - Superior Strength' :/BGM"
    L["|cffFF0000（欠款2000）|r"] = "|cffFF0000 (2000 in arrears)|r"
    L["装备记录通知"] = "Gear Record Notification"
    L["交易通知"] = "Transaction Notification"
end

-- 专业技能
do
    L["锻造"] = "Blacksmithing"
    L["工程学"] = "Engineering"
    L["炼金术"] = "Alchemy"
    L["制皮"] = "Leatherworking"
    L["裁缝"] = "Tailoring"
    L["附魔"] = "Enchanting"
    L["采矿"] = "Mining"
    L["草药学"] = "Herbalism"
    L["剥皮"] = "Skinning"
    L["铭文"] = "Inscription"
    L["珠宝加工"] = "Jewelcrafting"
    L["考古学"] = "Archaeology"
    L["钓鱼"] = "Fishing"
    L["烹饪"] = "Cooking"
    L["急救"] = "First Aid"
end

-- BOSS名字
do
    L["你漏记的装备"] = "missed"
    L["总结"] = "Summaries"

    L["杂\n\n项"] = "Miscellaneous"
    L["罚\n\n款"] = "Fines"
    L["支\n\n出"] = "Expenses"
    L["总\n览"] = "General"
    L["工\n资"] = "Wages"

    -- MOP
    do
        L["石头守卫"] = "Stone Guard"
        L["受诅者魔封"] = "Cursed Mogu Warden"
        L["缚灵者戈拉亚"] = "Spiritbinder Gara'jal"
        L["先王之魂"] = "Ancestor Kings' Spirits"
        L["伊拉贡"] = "Elegon"
        L["皇帝的意志"] = "Emperor's Will"
        L["皇家宰相"] = "Imperial Vizier"
        L["刀锋领主"] = "Blade Lord"
        L["加拉隆"] = "Galleon"
        L["风领主"] = "Wind Lord"
        L["琥珀塑形者"] = "Amber-Shaper"
        L["大女皇夏柯希尔"] = "Shek'zeer"
        L["无尽守护者"] = "Endless Guardian"
        L["烛龙"] = "Tsulong"
        L["雷施"] = "Lei Shi"
        L["惧之煞"] = "Sha of Fear"
        L["怒之煞"] = "Sha of Anger"
        L["萨莱斯的兵团"] = "Salryssia's Brigade"
        L["炮舰"] = "Galleon"

        L["击碎者金罗克"] = "Battlesmasher Kinloch"
        L["赫利东"] = "Hridon"
        L["长者议会"] = "Council of Elders"
        L["托多斯"] = "Todos"
        L["墨格瑞拉"] = "Mogrilla"
        L["季鹍"] = "Kunchu the Quartermaster"
        L["遗忘者杜鲁姆"] = "Durum the Forsaken"
        L["普利莫修斯"] = "Primosius"
        L["黑暗意志"] = "Dark Will"
        L["铁穹"] = "Iron Dome"
        L["神女双天"] = "Twins"
        L["雷神"] = "Thor"
        L["莱登"] = "Lydon"
        L["暴风领主"] = "Storm Lord"
        L["乌达斯塔"] = "Udasta"
    end

    -- CTM
    do
        L["哈尔弗斯・碎龙者"] = "Halion"
        L["瓦里昂娜和瑟纳利昂"] = "Valiona & Theralion"
        L["升腾者议会"] = "Council of Ascension"
        L["古加尔"] = "Cho'gall"
        L["希奈丝特拉"] = "Sintharia"
        L["全能金刚防御系统"] = "Omnotron Defense System"
        L["熔喉"] = "Magmaw"
        L["艾卓曼德斯"] = "Atramedes"
        L["奇美隆"] = "Chimaeron"
        L["马洛拉克"] = "Maloriak"
        L["奈法利安的末日"] = "Nefarian's End"
        L["风之议会"] = "Conclave of Wind"
        L["奥拉基尔"] = "Al'Akir"

        L["贝丝缇拉克"] = "Beth'tilac"
        L["雷奥利斯领主"] = "Rhyolith"
        L["奥利瑟拉佐尔"] = "Alysrazor"
        L["沙恩诺克斯"] = "Shannox"
        L["贝尔洛克"] = "Baleroc"
        L["管理者鹿盔"] = "Fandral Staghelm"
        L["拉格纳罗斯"] = "Ragnaros"

        L["莫卓克"] = "Moroes"
        L["督军佐诺兹"] = "Zon'ozz"
        L["不眠的约萨希"] = "Yor'sahj"
        L["缚风者哈格拉"] = "Hagara"
        L["奥卓克希昂"] = "Ultraxion"
        L["战争大师黑角"] = "Blackhorn"
        L["死亡之翼的背脊"] = "Spine of Deathwing"
        L["疯狂的死亡之翼"] = "Madness of Deathwing"

        L["克伯鲁斯"] = "Cerberus"
        L["岩皮"] = "Rockfist"
        L["欧泽鲁克"] = "Ozruk"
        L["高阶女祭司艾苏尔"] = "High Priestess Azil"
        L["灰葬男爵"] = "Baron Ashbury"
        L["席瓦莱恩男爵"] = "Baron Silverlaine"
        L["指挥官斯普林瓦尔"] = "Commander Springvale"
        L["沃登勋爵"] = "Lord Warden"
        L["高弗雷勋爵"] = "Lord Godfrey"
        L["胡辛姆将军"] = "General Husam"
        L["锁喉"] = "Gorehowl"
        L["高阶预言者巴林姆"] = "High Prophet Barim"
        L["希亚玛特"] = "Shiamat"
        L["大宰相埃尔坦"] = "Grand Vizier Ertan"
        L["阿尔泰鲁斯"] = "Al'tabimus"
        L["西风君王阿萨德"] = "Asaad"
        L["乌比斯将军"] = "General Umberlis"
        L["铸炉之主索朗格斯"] = "Solangus"
        L["达加・燃影者"] = "Daga"
        L["地狱公爵埃鲁达克"] = "Duke Erudax"
        L["格拉布托克"] = "Grabbletooth"
        L["赫利克斯・破甲"] = "Helix Gearbreaker"
        L["死神5000"] = "Reaper's Gale"
        L["撕心狼将军"] = "General Heartrazor"
        L["“船长”曲奇"] = "Captain Cookie"
        L["梵妮莎・范克里夫"] = "Vanessa Vancleef"
        L["纳兹夏尔女士"] = "Lady Naz'jar"
        L["指挥官乌尔索克，腐烂王子"] = "Commander Ulthok"
        L["蛊心魔古厄夏"] = "Gu"
        L["厄祖玛特"] = "Ozumat"
        L["神殿守护者安努尔"] = "Temple Guardian Anhuur"
        L["地怒者塔赫"] = "Tahk"
        L["安拉斐特"] = "Amphithet"
        L["伊希斯特，魔法的造物"] = "Isiset"
        L["阿穆纳伊，生命的造物"] = "Ammunae"
        L["塞特斯，毁灭的造物"] = "Setesh"
        L["拉夏，太阳的造物"] = "Rajh"
        L["摧骨者罗姆欧格"] = "Rom'ogg"
        L["柯尔拉，暮光之兆"] = "Corla"
        L["卡尔什・断钢"] = "Karsh Steelbender"
        L["如花"] = "Ru Hua"
        L["升腾者领主奥西迪斯"] = "Ascendant Lord Obsidius"
    end

    -- WLK
    do
        L["玛洛加尔"] = "Marrowgar"
        L["亡语者女士"] = "Lady Deathwhisper"
        L["炮舰战"] = "Ship's Cannon"
        L["萨鲁法尔"] = "Saurfang"
        L["烂肠"] = "Rotface"
        L["腐面"] = "Festergut"
        L["普崔塞德教授"] = "Professor Putricide"
        L["鲜血议会"] = "Blood Council"
        L["鲜血女王"] = "Blood Queen"
        L["踏梦者"] = "Dreamwalker"
        L["辛达苟萨"] = "Sindragosa"
        L["巫妖王"] = "Lich King"
        L["海里昂"] = "Halion"

        L["诺森德猛兽"] = "Beasts of Northrend"
        L["加拉克苏斯"] = "Galakrond"
        L["阵营冠军"] = "Faction Champions"
        L["瓦格里双子"] = "Val'kyr Twins"
        L["阿努巴拉克"] = "Anub'arak"
        L["嘉奖宝箱"] = "Reward Chest"
        L["奥妮克希亚"] = "Onyxia"

        L["烈焰巨兽"] = "Flame Leviathan"
        L["锋鳞"] = "Sartharion"
        L["掌炉者"] = "Forgewright"
        L["拆解者"] = "Disconstructor"
        L["钢铁议会"] = "Iron Council"
        L["科隆加恩"] = "Kologarn"
        L["欧尔利亚"] = "Algalon"
        L["霍迪尔"] = "Hodir"
        L["托里姆"] = "Thorim"
        L["弗蕾亚"] = "Freya"
        L["米米尔隆"] = "Mimiron"
        L["维扎克斯将军"] = "General Vezax"
        L["尤格萨隆"] = "Yogg-Saron"
        L["奥尔加隆"] = "Algalon"

        L["阿努布雷坎"] = "Anub'Rekhan"
        L["黑女巫法琳娜"] = "Grand Widow Faerlina"
        L["迈克斯纳"] = "Maexxna"
        L["瘟疫使者诺斯"] = "Noth the Plaguebringer"
        L["肮脏的希尔盖"] = "Heigan the Unclean"
        L["洛欧塞布"] = "Loatheb"
        L["教官"] = "Instructor"
        L["收割者戈提克"] = "Gothik the Harvester"
        L["天启四骑士"] = "Four Horsemen"
        L["帕奇维克"] = "Patchwerk"
        L["格罗布鲁斯"] = "Grobbulus"
        L["格拉斯"] = "Gluth"
        L["塔迪乌斯"] = "Thaddius"
        L["萨菲隆"] = "Sapphiron"
        L["克尔苏加德"] = "Kel'Thuzad"
        L["萨塔里奥"] = "Sartharion"
        L["玛里苟斯"] = "Malygos"

        L["纳多克斯长老"] = "Elder Nadox"
        L["塔达拉姆王子"] = "Prince Taldaram"
        L["埃曼尼塔"] = "Amanitar"
        L["耶戈达・觅影者"] = "Jedoga Shadowseeker"
        L["传令官沃拉兹"] = "Herald Volazj"
        L["看门者克里克希尔"] = "Krik'thir the Gatewatcher"
        L["哈多诺克斯"] = "Hadronox"
        L["托尔戈"] = "Tol'vir"
        L["召唤者诺沃斯"] = "Novos the Summoner"
        L["暴龙之王爵德"] = "Drakos the Interrogator"
        L["先知萨隆亚"] = "Prophet Saron"
        L["斯拉德兰"] = "Slad'ran"
        L["达卡莱巨像"] = "Drakuru"
        L["莫拉比"] = "Moragg"
        L["凶残的伊克"] = "Ick"
        L["迦尔达拉"] = "Galdara"
        L["比亚格里将军"] = "General Bjarngrim"
        L["沃尔坎"] = "Volkhan"
        L["艾欧纳尔"] = "Ignis"
        L["洛肯"] = "Loken"
        L["克莱斯塔卢斯"] = "Krystallus"
        L["悲伤圣女"] = "Mourning Widow"
        L["远古法庭"] = "Ancient Tribunal"
        L["塑铁者斯约尼尔"] = "Sjonnir the Ironshaper"
        L["肉钩"] = "Meathook"
        L["塑血者沙尔拉姆"] = "Sharram the Bloodshaper"
        L["时光领主埃博克"] = "Epoch Hunter"
        L["玛尔加尼斯"] = "Mal'Ganis"
        L["永恒腐蚀者"] = "Eternal Corruptor"
        L["指挥官斯托比德"] = "Commander Stoutbeard"
        L["大魔导师泰蕾丝塔"] = "Grand Magus Telestra"
        L["阿诺玛鲁斯"] = "Anomalus"
        L["塑树者奥莫洛克"] = "Omorokk the Tree-Shaper"
        L["克莉斯塔萨"] = "Krystallus"
        L["审讯者达库斯"] = "Drakos the Interrogator"
        L["瓦尔洛斯・云击"] = "Varos Cloudstrider"
        L["法师领主伊洛姆"] = "Mage-Lord Urom"
        L["魔网守护者埃雷苟斯"] = "Eregos the Nether-Warden"
        L["埃雷克姆"] = "Erekem"
        L["湮灭者祖拉玛特"] = "Zuramat the Obliterator"
        L["谢沃兹"] = "Xevozz"
        L["艾库隆"] = "Akuriss"
        L["摩拉格"] = "Moragg"
        L["拉文索尔"] = "Lavanthor"
        L["塞安妮苟萨"] = "Sariani"
        L["凯雷塞斯王子"] = "Prince Keleseth"
        L["控制者达尔隆"] = "Dalronn the Controller"
        L["劫掠者因格瓦尔"] = "Ingvar the Plunderer"
        L["席瓦拉・索格蕾"] = "Svala Sorrowgrave"
        L["戈托克・苍蹄"] = "Gortok Palehoof"
        L["残忍的斯卡迪"] = "Skarvald the Constructor"
        L["伊米隆国王"] = "King Ymiron"
    end

    -- TBC
    do
        L["卡雷苟斯"] = "Kalecgos"
        L["布鲁塔卢斯"] = "Brutallus"
        L["菲米丝"] = "Felmyst"
        L["艾瑞达双子"] = "Eredar Twins"
        L["穆鲁"] = "M'uru"
        L["基尔加丹"] = "Kil'jaeden"
        L["纳因图斯"] = "Hydross"
        L["苏普雷姆斯"] = "Supremus"
        L["阿卡玛之影"] = "Shade of Akama"
        L["塔隆・血魔"] = "Teron Gorefiend"
        L["古尔图格・血沸"] = "Gurtogg Bloodboil"
        L["灵魂之匣"] = "Soul Box"
        L["莎赫拉丝主母"] = "Mother Shahraz"
        L["伊利达雷议会"] = "Illidari Council"
        L["伊利丹・怒风"] = "Illidan Stormrage"
        L["雷基・冬寒"] = "Rage Winterchill"
        L["安纳塞隆"] = "Anetheron"
        L["卡兹洛加"] = "Kaz'rogal"
        L["阿兹加洛"] = "Azgalor"
        L["阿克蒙德"] = "Archimonde"
        L["海度斯"] = "Hydross"
        L["鱼斯拉"] = "The Lurker Below"
        L["盲眼者"] = "Blindseer"
        L["深水领主"] = "Deepwater Lord"
        L["踏潮者"] = "Tidalvess"
        L["瓦丝琪"] = "Vashj"
        L["奥"] = "O"
        L["空灵机甲"] = "Void Reaver"
        L["大星术师"] = "High Astromancer"
        L["凯尔萨斯"] = "Kael'thas"
    end

    -- 60
    do
        L["鲁西弗隆"] = "Lucifron"
        L["玛格曼达"] = "Magmadar"
        L["基赫纳斯"] = "Gehennas"
        L["加尔"] = "Garr"
        L["沙斯拉尔"] = "Shazzrah"
        L["迦顿男爵"] = "Baron Geddon"
        L["古雷曼格"] = "Golemagg"
        L["萨弗隆先驱者"] = "Sulfuron Harbinger"
        L["埃克索图斯"] = "Majordomo Executus"
        L["拉格纳罗斯"] = "Ragnaros"
        L["奥妮克希亚"] = "Onyxia"

        L["狂野的拉佐格尔"] = "Razorgore the Untamed"
        L["堕落的瓦拉斯塔兹"] = "Vaelastrasz the Corrupt"
        L["勒什雷尔"] = "Lashlayer"
        L["费尔默"] = "Felmyst"
        L["埃博诺克"] = "Ebonroc"
        L["弗莱格尔"] = "Flamegor"
        L["克洛玛古斯"] = "Chromaggus"
        L["奈法利安"] = "Nefarian"

        L["耶克里克"] = "Jeklik"
        L["温诺希斯"] = "Venoxis"
        L["玛尔里"] = "Mar'li"
        L["血领主曼多基尔"] = "Bloodlord Mandokir"
        L["疯狂之缘"] = "Edge of Madness"
        L["加兹兰卡"] = "Gahz'ranka"
        L["塞卡尔"] = "Thekal"
        L["娅尔罗"] = "Arlokk"
        L["妖术师金度"] = "Jin'do the Hexxer"
        L["哈卡"] = "Hakkar"

        L["库林纳克斯"] = "Kurinnaxx"
        L["拉贾克斯将军"] = "General Rajaxx"
        L["莫阿姆"] = "Moam"
        L["吞咽者布鲁"] = "Buru the Gorger"
        L["狩猎者阿亚米斯"] = "Ayamiss the Hunter"
        L["无疤者奥斯里安"] = "Ossirian the Unscarred"

        L["预言者斯克拉姆"] = "Prophet Skeram"
        L["安其拉三宝"] = "Twin Emperors"
        L["沙尔图拉"] = "Sartura"
        L["顽强的范克瑞斯"] = "Fankriss the Unyielding"
        L["维希度斯"] = "Viscidus"
        L["哈霍兰公主"] = "Princess Huhuran"
        L["双子皇帝"] = "Twin Emperors"
        L["奥罗"] = "Ouro"
        L["克苏恩"] = "C'Thun"

        L["艾索雷葛斯"] = "Azuregos"
        L["卡扎克"] = "Kaz'zak"
        L["莱索恩"] = "Lethon"
        L["艾莫莉丝"] = "Emeriss"
        L["泰拉尔"] = "Taerar"
        L["伊森德雷"] = "Ysondre"
    end

    -- 60级赛季服
    do
        L["阿奎尼斯男爵"] = "Baron Aquanis"
        L["加摩拉"] = "Ghamoo-ra"
        L["萨利维丝"] = "Lady Sarevess"
        L["格里哈斯特"] = "Gri'lek"
        L["洛古斯・杰特"] = "Logos'jet"
        L["梦游者克尔里斯"] = "Keristrasza"
        L["阿库麦尔"] = "Aku'mai"

        L["矿工约翰森"] = "Miner Johnson"
        L["斯尼德"] = "Sneed"
        L["基尔尼格"] = "Gilnid"
        L["重锤先生"] = "Mr. Smite"
        L["绿皮队长"] = "Captain Greenskin"
        L["艾德温・范克里夫"] = "Edwin VanCleef"
        L["曲奇"] = "Cookie"
        L["考布莱恩"] = "Captain Cookie"
        L["克雷什"] = "Gluth"
        L["皮萨斯"] = "Pythas"
        L["斯卡姆"] = "Skum"
        L["瑟芬迪斯"] = "Sephuz"
        L["永生者沃尔丹"] = "Vol'jin"
        L["吞噬者穆坦努斯"] = "Mutanus the Devourer"
        L["变异精灵龙"] = "Mutated Sprite Darter"
        L["屠夫拉佐克劳"] = "Razzak kraul"
        L["席瓦莱恩男爵"] = "Baron Silverlaine"
        L["指挥官"] = "Commander"
        L["盲眼守卫奥杜"] = "Blind Guardian Odo"
        L["幻影之甲"] = "Phantom Armor"
        L["狼王南杜斯"] = "Lord Duskwhisper"
        L["大法师阿鲁高"] = "Archmage Arugal"
        L["布鲁高・铁拳"] = "Bru'gal Ironfist"

        L["格鲁比斯"] = "Grobis"
        L["粘性辐射尘"] = "Sticky Radiation"
        L["电刑器6000型"] = "Electrocutor 6000"
        L["群体打击者"] = "Group Strikers"
        L["黑铁大师"] = "Dark Iron Master"
        L["瑟玛普拉格"] = "Mekgineer Thermaplugg"
        L["机械动物园"] = "Mechanical Zoo"

        L["亡语者贾格巴"] = "Deathspeaker Jagub"
        L["主宰拉姆塔斯"] = "Overlord Ramtusk"
        L["刺鬃守卫"] = "Razormane Guard"
        L["暴怒的阿迦赛罗斯"] = "Aggem Thorncurse"
        L["盲眼猎手"] = "Blind Hunter"
        L["卡尔加・刺肋"] = "Kalga"
        L["唤地者哈穆加"] = "Hamugga the Earthcaller"
        L["审讯员韦沙斯"] = "Interrogator Vishas"
        L["永醒的艾希尔"] = "Ecil the Ever-Wakeful"
        L["死灵勇士"] = "Necro Warrior"
        L["铁脊死灵"] = "Ironspine Necropolis"
        L["血法师萨尔诺斯"] = "Bloodmage Thalnos"
        L["驯犬者洛克希"] = "Rokesh the Houndmaster"
        L["奥法师杜安"] = "Archmage Doran"
        L["赫洛德"] = "Herod"
        L["法尔班克斯"] = "Fairbanks"
        L["莫格莱尼"] = "Mograine"
        L["怀特迈恩"] = "Whitemane"
        L["图特卡什"] = "Tuten'kash"
        L["火眼莫德雷斯"] = "Mordreth the Eyes of Flame"
        L["暴食者"] = "Glutton"
        L["拉戈斯诺特"] = "Ragglesnout"
        L["寒冰之王亚门纳尔"] = "Arthas the Lich King"
        L["腐烂的普雷莫尔"] = "Premore the Rotten"
        L["埃瑞克"] = "Erik"
        L["巴尔洛戈"] = "Balrog"
        L["奥拉夫"] = "Olaf"
        L["鲁维罗什"] = "Ruvirosh"
        L["艾隆纳亚"] = "Elonnaya"
        L["石头看守者"] = "Stone Watcher"

        L["阿塔拉利恩"] = "Atal'alarion"
        L["腐溃烂泥"] = "Rotten Slime"
        L["阿塔莱防御者"] = "Atal'ai Defender"
        L["德姆塞卡尔"] = "Dumesekar"
        L["哈卡的化身"] = "Avatar of Hakkar"
        L["迦玛兰和奥戈姆"] = "Ghamoran and Ogom"
        L["摩弗拉斯"] = "Morphaz"
        L["哈扎斯"] = "Hazath"
        L["伊兰尼库斯"] = "Eranikus"

        L["烈焰卫士"] = "Flamewaker"
        L["索拉卡・火冠"] = "Solakar Flamewreath"
        L["杰德"] = "Jed"
        L["古拉鲁克"] = "Gurgluk"
        L["雷德・黑手"] = "Rend Blackhand"
        L["比斯巨兽"] = "The Beast"
        L["达基萨斯将军"] = "General Drakkisath"
        L["瓦塔拉克公爵"] = "Duke Barathen"

        L["熔火之心"] = "Molten Core"
        L["艾索雷葛斯"] = "Azuregos"
        L["卡扎克"] = "Kaz'zak"

        L["拉佐格尔"] = "Razorgore"
        L["瓦拉斯塔兹"] = "Vaelastrasz"
        L["双龙"] = "Twin Dragons"
        L["桑德兰王子"] = "Prince Thunderaan"
        L["莱索恩"] = "Lethon"
        L["艾莫莉丝"] = "Emeriss"
        L["泰拉尔"] = "Taerar"
        L["伊森德雷"] = "Ysondre"

        L["加加恩・火锤"] = "Gagg'nath Firehammer"
        L["格瑞姆洛克"] = "Grimlok"
        L["阿扎达斯"] = "Archaedas"
        L["安图苏尔"] = "Antu'sul"
        L["巫医祖穆拉恩"] = "Witch Doctor Zumrah"
        L["暗影祭司塞瑟斯"] = "Shadow Priest Sezz'ziz"
        L["灰尘怨灵"] = "Dust Wraith"
        L["加兹瑞拉"] = "Gahz'rilla"
        L["乌克兹・沙顶"] = "Ukkorok Sandscalp"
        L["泽雷利斯"] = "Zerillis"
        L["诺克赛恩"] = "Noxxion"
        L["锐刺鞭笞者"] = "Thorny Lasher"
        L["维利塔恩"] = "Velithria"
        L["收割者麦什洛克"] = "Mosh'Ogg Reaver"
        L["被诅咒的塞雷布拉斯"] = "Cursed Thaurissan"
        L["兰斯利德"] = "Landslide"
        L["工匠吉兹洛克"] = "Tinkerer Gizlock"
        L["洛特格里普"] = "Rotgrip"
        L["瑟莱德丝公主"] = "Princess Theradras"
        L["洛考尔"] = "Lokholar"
        L["审讯官格斯塔恩"] = "Interrogator Gerstahn"
        L["驯犬者格雷尔玛尔"] = "Grelmar the Houndmaster"
        L["竞技场-修行者高罗什"] = "Arena - Gorosh the Dervish"
        L["竞技场-格里兹尔"] = "Arena - Grizel"
        L["竞技场-剜眼者"] = "Arena - Eyegouger"
        L["竞技场-破坏者奥科索尔"] = "Arena - Ok'thor the Breaker"
        L["竞技场-阿努希尔"] = "Arena - Anetheron"
        L["竞技场-爬行者赫杜姆"] = "Arena - Hedrum the Creeper"
        L["控火师罗格雷恩"] = "Firemaster Rograine"
        L["黑色宝库"] = "Black Vault"
        L["典狱官斯迪尔基斯"] = "Warden Stilgiss"
        L["维雷克"] = "Verek"
        L["卫兵杜格瑞普"] = "Guard Dughan"
        L["弗诺斯・达克维尔"] = "Foroth Darkweave"
        L["伊森迪奥斯"] = "Eldershan"
        L["贝尔加"] = "Bael'Gar"
        L["安格弗将军"] = "General Angerforge"
        L["傀儡统帅阿格曼奇"] = "Puppetmaster Agamand"
        L["黑铁酒吧-霍尔雷・黑须"] = "Dark Iron Bar - Horrigan Blackbeard"
        L["黑铁酒吧-普拉格"] = "Dark Iron Bar - Plugger Spazzring"
        L["黑铁酒吧-方阵"] = "Dark Iron Bar - Phalanx"
        L["弗莱拉斯大使"] = "Ambassador Flamelash"
        L["无敌的潘佐尔"] = "Panzor the Invincible"
        L["七贤"] = "Seven Sages"
        L["玛格姆斯"] = "Magmus"
        L["铁炉堡公主茉艾拉・铜须"] = "Princess Moira Bronzebeard"
        L["达格兰・索瑞森大帝"] = "Emperor Dagran Thaurissan"
        L["晦根"] = "Hugen"
        L["搜寻者迪亚索鲁斯"] = "Seeker Diasorus"
        L["毁灭者的幻影"] = "Phantom of the Destroyer"
        L["吉尔巴格布"] = "Gilbagub"
        L["派拉尼斯"] = "Palanis"
        L["地狱咆哮的幻灵"] = "Spirit of Hellscream"
        L["阿兹加洛斯"] = "Azgalor"
    end
end

ns.L = L
