--[[
    GF_Auction MinimapButton Module
    Creates minimap button using LibDBIcon
]]

local addonName = "GF_Auction"
local L = GF_Auction_L

-- Create MinimapButton module
local MinimapButton = {}

-- Register to GF_Auction
if not GF_Auction then
    GF_Auction = {}
end
GF_Auction.MinimapButton = MinimapButton

-- Local references
local LDB = nil
local LibDBIcon = nil
local dataObject = nil

-- Initialize module
function MinimapButton:Initialize()
    -- Load libraries
    LDB = LibStub("LibDataBroker-1.1", true)
    LibDBIcon = LibStub("LibDBIcon-1.0", true)
    
    if not LDB or not LibDBIcon then
        return false
    end
    
    -- Get database
    local Database = GF_Auction:GetModule("Database")
    if not Database then
        return false
    end
    
    local db = Database:GetSettings()
    
    -- Initialize minimap icon settings
    if not db.minimap then
        db.minimap = {
            hide = false
        }
    end
    
    -- Create data object
    dataObject = LDB:NewDataObject(addonName, {
        type = "launcher",
        text = L("ADDON_NAME"),
        icon = "Interface\\AddOns\\GF_Auction\\Media\\minimap",
        OnClick = function(self, button)
            MinimapButton:OnClick(button)
        end,
        OnTooltipShow = function(tooltip)
            MinimapButton:OnTooltipShow(tooltip)
        end,
    })
    
    -- Register icon
    LibDBIcon:Register(addonName, dataObject, db.minimap)
    
    return true
end

-- Click handler
function MinimapButton:OnClick(button)
    local MainFrame = GF_Auction:GetModule("MainFrame")
    if MainFrame then
        if button == "LeftButton" then
            MainFrame:Toggle()
        elseif button == "RightButton" then
            -- Could open config or context menu
        end
    end
end

-- Tooltip handler
function MinimapButton:OnTooltipShow(tooltip)
    tooltip:SetText(L("ADDON_NAME"), 1, 1, 1)
    tooltip:AddLine(L("ADDON_DESC"), 1, 1, 1, true)
    tooltip:AddLine(" ")
    tooltip:AddLine(L("MINIMAP_LEFT_CLICK"), 0.7, 0.7, 0.7)
    tooltip:AddLine(L("MINIMAP_RIGHT_CLICK"), 0.7, 0.7, 0.7)
end

-- Show minimap icon
function MinimapButton:Show()
    if LibDBIcon then
        LibDBIcon:Show(addonName)
    end
end

-- Hide minimap icon
function MinimapButton:Hide()
    if LibDBIcon then
        LibDBIcon:Hide(addonName)
    end
end

-- Toggle minimap icon
function MinimapButton:Toggle()
    if LibDBIcon then
        if LibDBIcon:IsRegistered(addonName) then
            if LibDBIcon:IsShown(addonName) then
                self:Hide()
            else
                self:Show()
            end
        end
    end
end

-- Check if icon is shown
function MinimapButton:IsShown()
    if LibDBIcon then
        return LibDBIcon:IsShown(addonName)
    end
    return false
end

-- Get icon button
function MinimapButton:GetButton()
    if LibDBIcon then
        return LibDBIcon:GetMinimapButton(addonName)
    end
    return nil
end

