local ADDON_NAME = ...
---@class ns
local ns = select(2, ...)
local L = ns.L

---@class MeetingHornCategoryData
---@field path string
---@field name string
---@field channel string
---@field channels table<string, boolean>
---@field interval number
---@field timeout number
---@field members number
---@field inCity boolean

---@class MeetingHornActivityData
---@field name string
---@field shortName string
---@field nameLower string
---@field shortNameLower string
---@field path string
---@field members number
---@field minLevel number
---@field class string
---@field instanceName string
---@field category MeetingHornCategoryData

ns.MIN_INTERVAL = 10
ns.ADDON_PREFIX = format('|cff00ffff%s|r：', L.ADDON_NAME)
ns.ADDON_VERSION = GetAddOnMetadata(ADDON_NAME, 'Version'):gsub('%-%d+', '')
ns.ADDON_TAG = '<' .. L.ADDON_NAME .. '>'

ns.APPLICANT_STATUS = {Normal = 1, Invited = 2, Declined = 3, Joined = 4}

ns.PROJECT_DATA = { --
    [2] = {maxLevel = 60, name = EXPANSION_NAME0, projects = {2}},
    [5] = {maxLevel = 70, name = EXPANSION_NAME1, projects = {5, 2}},
    [11] = {maxLevel = 80, name = EXPANSION_NAME2, projects = {11, 5, 2}},
}

ns.SEARCH_ALIAS = { --
    ['5h'] = {'h', 'yx', '英雄', params = {comment = true}, ['英雄'] = {comment = true, name = true}},
    ['周常'] = {'周常', '周长', params = {comment = true}, ['周长'] = {comment = true, name = true}},
    ['日常'] = {'日常', '日长', params = {comment = true}, ['日长'] = {comment = true, name = true}},
    ['RS'] = {'RS', 'H RS','H红玉', '红玉', params = {comment = true}, ['红玉'] = {comment = true, name = true}},
    ['红玉'] = {'红玉', 'H RS', 'H红玉', params = {comment = true}, ['RS'] = {comment = true, name = true}},
    ['ICC'] = {'ICC', 'HICC', 'H ICC', params = {comment = true}, ['H ICC'] = {comment = true, name = true}},
    ['MC'] = {'MC', '熔火', params = {comment = true}, ['熔火'] = {comment = true, name = true}},
    ['宝库'] = {'宝库', '双色球', params = {comment = true}, ['双色球'] = {comment = true, name = true}},
    ['排随机'] = {'排随机', '排随', params = {comment = true}, ['排随'] = {comment = true, name = true}},
    ['PVP'] = {'战场', '竞技场', 'JJC', '野外', params = {comment = true}, ['野外'] = {comment = true, name = true}},
    ['黑石战场'] = {'黑石战场', '黑石', params = {comment = true}, ['黑石'] = {comment = true, name = true}},
}

local keyCombinations = {
    "CTRL-.", "CTRL-[", "CTRL-;",
    "CTRL-,", "CTRL-]", "CTRL-'",
    "ALT-,", "ALT-]", "ALT-'",
    "ALT-.", "ALT-[", "ALT-;",
    "SHIFT-.", "SHIFT-[", "SHIFT-;",
    "SHIFT-,", "SHIFT-]", "SHIFT-'",
}


local INSTANCE_DATA = {
    [2717] = {projectId = 2, logo = 'Ragnaros'}, -- 熔火之心
    -- [2159] = {projectId = 2, logo = 'Onyxia'}, -- 奥妮克希亚的巢穴
    [2677] = {projectId = 2, logo = 'Nefarian'}, -- 黑翼之巢
    [3428] = {projectId = 2, logo = 'CThun', instanceName = L['Ahn\'Qiraj Temple']}, -- 安其拉神殿
    -- [3456] = {projectId = 2, logo = 'KelThuzad'}, -- 纳克萨玛斯
    [1977] = {projectId = 2, logo = 'Avatar of Hakkar'}, -- 祖尔格拉布
    [3429] = {projectId = 2, logo = 'Ossirian the Unscarred'}, -- 安其拉废墟
    -- tbc
    [3457] = {projectId = 5, logo = 'Prince Malchezaar'}, -- 卡拉赞
    [3923] = {projectId = 5, logo = 'Gruul the Dragonkiller'}, -- 格鲁尔的巢穴
    [3836] = {projectId = 5, logo = 'Magtheridon'}, -- 玛瑟里顿的巢穴
    [3607] = {projectId = 5, logo = 'Lady Vashj'}, -- 毒蛇神殿
    [3845] = {projectId = 5, logo = 'KaelThas Sunstrider'}, -- 风暴要塞
    [3606] = {projectId = 5, logo = 'Archimonde'}, -- 海加尔山
    [3959] = {projectId = 5, logo = 'Illidan Stormrage'}, -- 黑暗神庙
    [3805] = {projectId = 5, logo = 'Daakara'}, -- 祖阿曼
    [4075] = {projectId = 5, logo = 'Kiljaeden', instanceName = '太阳之井'}, -- 太阳井
    -- wlk
    [3456] = {projectId = 11, logo = 'KelThuzad'}, -- 纳克萨玛斯
    [4493] = {projectId = 11, logo = 1385765}, -- 黑曜石圣殿
    [4500] = {projectId = 11, logo = 1385753}, -- 永恒之眼
    [2159] = {projectId = 11, logo = 'Onyxia'}, -- 奥妮克希亚的巢穴
    [4603] = {projectId = 11, logo = 1385767}, -- 阿尔卡冯的宝库
    [4273] = {projectId = 11, logo = 1385774}, -- 奥杜尔
    [4722] = {projectId = 11, logo = 607542}, -- 十字军的试炼
    [4812] = {projectId = 11, logo = 607688}, -- 冰冠堡垒
    [4987] = {projectId = 11, logo = 1385738}, -- 红玉圣殿
}

ns.INSTANCE_DATA = {}
ns.CURRENT_RELEASE_INSTANCES = {}

for mapId, v in pairs(INSTANCE_DATA) do
    local name = C_Map.GetAreaInfo(mapId)
    if name then
        if type(v.logo) == 'string' then
            v.logo = [[Interface\ENCOUNTERJOURNAL\UI-EJ-BOSS-]] .. v.logo
        end
        ns.INSTANCE_DATA[name] = v

        if v.projectId == WOW_PROJECT_ID then
            ns.CURRENT_RELEASE_INSTANCES[v.instanceName or name] = true
        end
    end
end

function ns.GetInstanceName(mapName)
    local data = ns.INSTANCE_DATA[mapName]
    if data then
        return data.instanceName or mapName
    end
end

function ns.GetInstanceLogo(mapName)
    local data = ns.INSTANCE_DATA[mapName]
    return data and data.logo
end

ns.GOODLEADER_INSTANCES = {
    --[=[@classic@
    {projectId = 2, mapId = 2717, bossId = 672, image = 'moltencore'}, --
    {projectId = 2, mapId = 2159, bossId = 1084, image = 'onyxia'}, --
    {projectId = 2, mapId = 2677, bossId = 617, image = 'blackwinglair'}, --
    {projectId = 2, mapId = 3428, bossId = 717, image = 'templeofahnqiraj'}, --
    {projectId = 2, mapId = 3456, bossId = 1114, name = L['克尔苏加德'], image = 'naxxramas'}, --
    {projectId = 2, mapId = 3456, bossId = 1121, name = L['军事区'], image = 'naxxramas'}, --
    {projectId = 2, mapId = 3456, bossId = 1115, name = L['瘟疫区'], image = 'naxxramas'}, --
    {projectId = 2, mapId = 3456, bossId = 1116, name = L['蜘蛛区'], image = 'naxxramas'}, --
    {projectId = 2, mapId = 3456, bossId = 1120, name = L['构造区'], image = 'naxxramas'}, --
    {projectId = 2, mapId = 1977, bossId = 793, image = 'zulgurub'}, --
    {projectId = 2, mapId = 3429, bossId = 723, image = 'ruinsofahnqiraj'}, --
    --@end-classic@]=]
    --[==[@bcc@
    {projectId = 5, mapId = 3457, bossId = 661, image = 'Karazhan'}, -- 卡拉赞
    {projectId = 5, mapId = 3923, bossId = 650, image = 'GruulsLair'}, -- 格鲁尔的巢穴
    {projectId = 5, mapId = 3836, bossId = 651, image = 'MagtheridonsLair'}, -- 玛瑟里顿的巢穴
    {projectId = 5, mapId = 3607, bossId = 628, image = 'CoilfangReservoir'}, -- 毒蛇神殿
    {projectId = 5, mapId = 3845, bossId = 733, image = 'TempestKeep'}, -- 风暴要塞
    {projectId = 5, mapId = 3606, bossId = 622, image = 'CavernsOfTime'}, -- 海加尔山
    {projectId = 5, mapId = 3959, bossId = 609, image = 'BlackTemple'}, -- 黑暗神庙
    {projectId = 5, mapId = 3805, bossId = 1189, image = 'ZulAman'}, -- 祖阿曼
    {projectId = 5, mapId = 4075, bossId = 729, image = 'SunwellPlateau'}, -- 太阳井
    --@end-bcc@]==]
    -- @lkc@
    {projectId = 11, mapId = 3456, bossId = 1114, difficulties = {3, 4}, image = 'naxxramas'}, -- 纳克萨玛斯
    {projectId = 11, mapId = 4493, bossId = 742, difficulties = {3, 4}, image = 1396588}, -- 黑曜石圣殿
    {projectId = 11, mapId = 4500, bossId = 734, difficulties = {3, 4}, image = 1396581}, -- 永恒之眼
    -- {projectId = 11, mapId = 4603, bossId = 0, image = 1396596}, -- 阿尔卡冯的宝库
    {projectId = 11, mapId = 4273, bossId = 756, difficulties = {3, 4}, image = 1396595}, -- -- 奥杜尔
    {projectId = 11, mapId = 4722, bossId = 645, difficulties = {3, 4, 5, 6}, image = 1396594}, -- -- 十字军的试炼
    {projectId = 11, mapId = 2159, bossId = 1084, difficulties = {3, 4}, image = 'onyxia'}, -- -- 奥妮克希亚的巢穴
    {projectId = 11, mapId = 4812, bossId = 856, difficulties = {3, 4, 5, 6}, image = 1396583}, -- -- 冰冠堡垒
    {projectId = 11, mapId = 4987, bossId = 887, difficulties = {3, 4, 5, 6}, image = 1396590}, -- -- 红玉圣殿
    -- @end-lkc@
}

local CLASS_INFO = FillLocalizedClassList {}

function ns.IsCompatChannel(channelName)
    return --[[channelName == '交易' or]] channelName:match('^大脚世界频道')
end

function ns.ShortChannelName(channelName)
    if #channelName > 12 then
        return channelName:gsub('频道', '')
    end
    return channelName
end

function ns.UnitInGroup(unit)
    return UnitInParty(unit) or UnitInRaid(unit)
end

function ns.IsGroupLeader()
    return not IsInGroup(LE_PARTY_CATEGORY_HOME) or UnitIsGroupLeader('player', LE_PARTY_CATEGORY_HOME)
end

function ns.GetNumGroupMembers()
    local num = GetNumGroupMembers(LE_PARTY_CATEGORY_HOME)
    return num > 0 and num or 1
end

function ns.GetClassLocale(classFileName)
    return CLASS_INFO[classFileName]
end

local function GetSlotItemLevel(unit, slot)
    local id = GetInventoryItemID(unit, slot)
    if not id then
        return 0
    end
    local itemLevel = select(4, GetItemInfo(id))
    return itemLevel
end

local ITEMS = { --
    [1] = GetSlotItemLevel,
    [2] = GetSlotItemLevel,
    [3] = GetSlotItemLevel,
    [5] = GetSlotItemLevel,
    [6] = GetSlotItemLevel,
    [7] = GetSlotItemLevel,
    [8] = GetSlotItemLevel,
    [9] = GetSlotItemLevel,
    [10] = GetSlotItemLevel,
    [11] = GetSlotItemLevel,
    [12] = GetSlotItemLevel,
    [13] = GetSlotItemLevel,
    [14] = GetSlotItemLevel,
    [15] = GetSlotItemLevel,
    [16] = function(unit, slot)
        local id = GetInventoryItemID(unit, slot)
        if not id then
            return 0
        end
        local itemLevel, _, _, _, _, itemEquipLoc = select(4, GetItemInfo(id))
        if itemEquipLoc == 'INVTYPE_2HWEAPON' then
            return itemLevel * 2
        end
        return itemLevel
    end,
    [17] = GetSlotItemLevel,
    [18] = GetSlotItemLevel,
}

function ns.GetPlayerItemLevel()
    return ns.GetUnitItemLevel('player')
end

function ns.GetUnitItemLevel(unit)
    local itemLevel = 0
    for slot, func in pairs(ITEMS) do
        itemLevel = itemLevel + (func(unit, slot) or 0)
    end
    local count = 17
    return floor(itemLevel / count * 10) / 10
end

function ns.GetRaidId(raidName)
    for i = 1, GetNumSavedInstances() do
        local name, id = GetSavedInstanceInfo(i)
        if name == raidName then
            return id
        end
    end
    return -1
end

local SOLO_GROUPS = {player = true}
local PARTY_GROUPS = (function()
    local r = {player = true}
    for i = 1, 4 do
        r['party' .. i] = true
    end
    return r
end)()
local RAID_GROUPS = (function()
    local r = {}
    for i = 1, 40 do
        r['raid' .. i] = true
    end
    return r
end)()

function ns.IterateGroup()
    if IsInRaid(LE_PARTY_CATEGORY_HOME) then
        return pairs(RAID_GROUPS)
    elseif IsInGroup(LE_PARTY_CATEGORY_HOME) then
        return pairs(PARTY_GROUPS)
    else
        return pairs(SOLO_GROUPS)
    end
end

function ns.UnitFullName(unit)
    local name, realm = UnitFullName(unit)
    if not name then
        return
    end
    return format('%s-%s', name, realm or GetRealmName():gsub('%s+', ''))
end

function ns.GetGroupLeader()
    for unit in ns.IterateGroup() do
        if UnitIsGroupLeader(unit) then
            return ns.UnitFullName(unit), UnitGUID(unit)
        end
    end
    return ns.UnitFullName('player'), UnitGUID('player')
end

function ns.GetGroupLooter()
    if IsInRaid() then
        for i = 1, 40 do
            local name, _, _, _, _, _, _, _, _, _, isML = GetRaidRosterInfo(i)
            if isML then
                return ns.UnitFullName(name), UnitGUID(name)
            end
        end
    end
    return ns.GetGroupLeader()
end

function ns.IsInGroup()
    return IsInGroup(LE_PARTY_CATEGORY_HOME)
end

function ns.tRemoveIf(t, condition)
    local any = false
    for i = #t, 1, -1 do
        local item = t[i]
        if condition(item) then
            tremove(t, i)
            any = true
        end
    end
    return any
end

function ns.SystemMessage(text)
    return DEFAULT_CHAT_FRAME:AddMessage(text, 1, 1, 0)
end

function ns.Message(msg, ...)
    if select('#', ...) > 0 then
        return ns.SystemMessage(string.format(ns.ADDON_PREFIX .. msg, ...))
    end
    return ns.SystemMessage(ns.ADDON_PREFIX .. msg)
end

function ns.FireHardWare()
    return ns.LFG:OnHardWare()
end

-- function ns.ParseRaidTag(message)
--     for tag in string.gmatch(message, '%b{}') do
--         local term = strlower(string.gsub(tag, '[{}]', ''))
--         if ICON_TAG_LIST[term] and ICON_LIST[ICON_TAG_LIST[term]] then
--             message = string.gsub(message, tag, ICON_LIST[ICON_TAG_LIST[term]] .. '0|t')
--         end
--     end
--     return message
-- end

local function replace(x)
    return ''
end

function ns.ParseRaidTag(text)
    return (text:gsub('{([^{]+)}', ''))
end

function ns.RemoveLink(text)
    return (text:gsub('|H[^|]+|h([^|]+)|h', '%1'):gsub('|cff%x%x%x%x%x%x', ''):gsub('|r', ''))
end

function ns.PrepareComment(text)
    return ns.ParseRaidTag(ns.RemoveLink(text))
end

function ns.FindAuraById(id, unit, filter)
    return AuraUtil.FindAura(function(idToFind, _, _, ...)
        local spellId = select(10, ...)
        return idToFind == spellId
    end, unit, filter, id)
end

function ns.RandomCall(sec, func, ...)
    local delay = random() * sec + 5
    local args = {...}
    C_Timer.After(delay, function()
        func(unpack(args))
    end)

    --[===[@debug@
    print('Random Call', delay, sec, func, ...)
    --@end-debug@]===]
end

local function SplitName(fullName)
    local name, realm = fullName:match('(.+)%-(.+)')
    if name then
        return name, realm
    end
    return fullName, GetRealmName():gsub('%s+', '')
end

function ns.MakeQRCode(leader)
    local name, _ = SplitName(leader)
    local realm = GetRealmID()
    local url = format('https://act.ds.163.com/1a8e6733be2b85c8/?meetinghorn_in=true&realmId=%s&charName=%s', realm, name)
    return url
end

function ns.memorize(func)
    local cache = {}
    return function(k, ...)
        if not k then
            return
        end
        if cache[k] == nil then
            cache[k] = func(k, ...)
        end
        return cache[k]
    end
end

local R = ns.memorize(function(d)
    local r = {}
    for i, v in ipairs {strsplit(',', d)} do
        r[v] = true
    end
    return r
end)

local CLASS_ROLES = { --
    DRUID = {R('DAMAGER,MAGIC,RANGE'), R('TANK'), R('HEALER')},
    HUNTER = {R('DAMAGER,PHYSICAL,RANGE')},
    MAGE = {R('DAMAGER,MAGIC,RANGE')},
    PALADIN = {R('HEALER'), R('TANK'), R('DAMAGER,PHYSICAL,MELEE')},
    PRIEST = {R('HEALER'), R('HEALER'), R('DAMAGER,MAGIC,RANGE')},
    ROGUE = {R('DAMAGER,PHYSICAL,MELEE')},
    SHAMAN = {R('DAMAGER,MAGIC,RANGE'), R('DAMAGER,PHYSICAL,MELEE'), R('HEALER')},
    WARLOCK = {R('DAMAGER,MAGIC,RANGE')},
    WARRIOR = {R('DAMAGER,PHYSICAL,MELEE'), R('DAMAGER,PHYSICAL,MELEE'), R('TANK')},
    DEATHKNIGHT = {R('TANK'), R('DAMAGER,PHYSICAL,MELEE'), R('DAMAGER,PHYSICAL,MELEE')},
}

local function GetCurrentRoles()
    local class = UnitClassBase("player")
    local roles = CLASS_ROLES[class]
    if not roles or #roles == 0 then
        return "DAMAGER" -- 默认返回输出
    end
    if #roles == 1 then
        return roles[1]  -- 如果职业只有一个职责（如猎人）
    end

    -- 查找点数最多的天赋页
    local maxTalentTabIndex
    local maxPoints = -1
    for i = 1, GetNumTalentTabs() do
        local _, _, pointsSpent = GetTalentTabInfo(i)
        pointsSpent = tonumber(pointsSpent) or 0
        if pointsSpent > maxPoints then
            maxTalentTabIndex = i
            maxPoints = pointsSpent
        end
    end

    -- 返回对应的职责
    return roles[maxTalentTabIndex] or "DAMAGER"
end

function ns.PlayerIsRole(role)
    return GetCurrentRoles()[role]
end

local QRTooltip = nil
function ns.OpenAnnouncementUrl(url)
    if not QRTooltip then
        QRTooltip = CreateFrame('Frame', nil, ns.Addon.MainPanel, 'MeetingHornActivityTooltipTemplate')
        QRTooltip:SetSize(240, 260)
        QRTooltip:SetPoint('TOPRIGHT', ns.Addon.MainPanel, 'TOPRIGHT', 0, 0)
        QRTooltip.Text:SetText('扫描下方二维码\n更多精彩在网易大神等你')
        QRTooltip.Text:ClearAllPoints()
        QRTooltip.Text:SetPoint('TOPLEFT', QRTooltip, "TOPLEFT", 8, -30)
        QRTooltip.Text:SetPoint('TOPRIGHT', QRTooltip, "BOTTOMRIGHT", -8, 8)
        QRTooltip.QRCode:ClearAllPoints()
        QRTooltip.QRCode:SetPoint('BOTTOM', QRTooltip, "BOTTOM", 0, 30)
        ns.UI.QRCodeWidget:Bind(QRTooltip.QRCode)
    end
    QRTooltip.QRCode:SetValue(url)
    QRTooltip:Show()
end

function ns.OpenUrlDialog(url, customText)
    local tempText = '请按<|cff00ff00Ctrl+C|r>复制网址到浏览器打开'
    if customText ~= nil then
        tempText = customText
    end

    if not StaticPopupDialogs['MEETINGHORN_COPY_URL'] then
        StaticPopupDialogs['MEETINGHORN_COPY_URL'] = {
            text = tempText,
            button1 = OKAY,
            timeout = 0,
            exclusive = 1,
            whileDead = 1,
            hideOnEscape = 1,
            hasEditBox = true,
            editBoxWidth = 260,
            EditBoxOnTextChanged = function(editBox, url)
                if editBox:GetText() ~= url then
                    editBox:SetMaxBytes(0)
                    editBox:SetMaxLetters(0)
                    editBox:SetText(url)
                    editBox:HighlightText()
                    editBox:SetCursorPosition(0)
                    editBox:SetFocus()
                end
            end,
        }
    end

    StaticPopupDialogs['MEETINGHORN_COPY_URL'].text = tempText
    StaticPopup_Show('MEETINGHORN_COPY_URL', nil, nil, url)
end

function ns.GetAddonSource()
    for line in gmatch(
                    '\066\105\103\070\111\111\116\058\049\010\033\033\033\049\054\051\085\073\033\033\033\058\050\010\068\117\111\119\097\110\058\052\010\069\108\118\085\073\058\056',
                    '[^\r\n]+') do
        local n, v = line:match('^(.+):(%d+)$')
        if IsAddOnLoaded(n) then
            return tonumber(v)
        end
    end
    return 0
end

function ns.ListToMap(list)
    local map = {}
    do
        for i, v in pairs(list) do
            map[v] = true
        end
    end
    return map
end

do
    local ImageFrame
    local function ImageButtonOnClick(button)
        if not ImageFrame then
            ImageFrame = CreateFrame('Frame', nil, UIParent, 'MeetingHornImageFrameTemplate')
        end

        if ImageFrame.which == button and ImageFrame:IsVisible() then
            ImageFrame.which = nil
            ImageFrame:Hide()
        else
            local params = button.params
            ImageFrame.which = button
            ImageFrame.Text:SetText(params.summary)
            ImageFrame.Image:SetTexture(params.texture)
            ImageFrame:SetHeight(ImageFrame.Text:GetHeight() - 13 + 215)
            ImageFrame:SetParent(button)
            ImageFrame:ClearAllPoints()
            ImageFrame:SetPoint(unpack(params.points))
            ImageFrame:Show()
        end
    end

    function ns.ApplyImageButton(button, params)
        if params.text then
            button:SetText(params.text)
        end
        button.params = params
        button:SetScript('OnClick', ImageButtonOnClick)
    end
end

function ns.DataMake(allowCrossRealm)
    local function decode(v)
        return v:gsub('..', function(x)
            return string.char(tonumber(x, 16))
        end)
    end

    local currentRealm
    local currentLevel
    local currentRoomID
    local currentBgID
    local function Realm(realm)
        realm = decode(realm)
        if allowCrossRealm or realm == GetRealmName() then
            currentRealm = realm
            return
        end
        currentRealm = nil
    end

    local function Name(name)
        if not currentRealm or currentRealm ~= GetRealmName() then
            return nop
        end

        name = decode(name)
        local regimentData = ns.Addon.db.realm.starRegiment.regimentData[name]
        if regimentData then
            regimentData.level = currentLevel
            regimentData.roomID = currentRoomID
            regimentData.bgID = currentBgID
            ns.Addon.db.realm.starRegiment.regimentData[name] = regimentData
        else
            ns.Addon.db.realm.starRegiment.regimentData[name] = { level = currentLevel, roomID = currentRoomID, bgID = currentBgID }
        end
    end

    local function Level(level)
        currentLevel = level
    end

    local function RoomID(roomid)
        currentRoomID = roomid
    end

    local function BgID(bgid)
        currentBgID = bgid
    end

    setfenv(2, {R = Realm, N = Name, L = Level, I = RoomID, B = BgID})
end

function ns.FormatSummary(text, tbl)
    return text:gsub('{{([%w_]+)}}', function(key)
        if type(tbl[key]) == 'function' then
            return tbl[key](tbl) or ''
        end
        return tbl[key] or ''
    end)
end

function ns.PrepareSearch(search)
    if not search or search:trim() == '' then
        return
    end

    local alias = ns.SEARCH_ALIAS[search]
    if alias then
        return alias
    end

    return search:lower()
end

-- 将表转换为 JSON 样式字符串的函数
-- Utility function to get the size of a table
function table_size(tbl)
    local count = 0
    for _ in pairs(tbl) do count = count + 1 end
    return count
end

function ns.TableToJson(tbl)
    local function isArray(t)
        local maxIndex = 0
        for k, _ in pairs(t) do
            if type(k) ~= "number" then return false end
            if k > maxIndex then maxIndex = k end
        end
        for i = 1, maxIndex do
            if t[i] == nil then return false end
        end
        return true
    end

    local function serialize(tbl, level)
        local result = {}
        local indent = string.rep("  ", level)

        if isArray(tbl) then
            table.insert(result, "[\n")
            for i, v in ipairs(tbl) do
                local value
                if type(v) == "table" then
                    value = serialize(v, level + 1)
                elseif type(v) == "string" then
                    value = string.format("%q", v)
                else
                    value = tostring(v)
                end
                local comma = (i == #tbl) and "\n" or ",\n"
                table.insert(result, string.format("%s  %s%s", indent, value, comma))
            end
            table.insert(result, indent .. "]")
        else
            table.insert(result, "{\n")
            local count = 0
            for k, v in pairs(tbl) do
                count = count + 1
                local key = (type(k) == "string" and string.format("%q", k)) or tostring(k)
                local value
                if type(v) == "table" then
                    value = serialize(v, level + 1)
                elseif type(v) == "string" then
                    value = string.format("%q", v)
                else
                    value = tostring(v)
                end
                local comma = (count == table_size(tbl)) and "\n" or ",\n"
                table.insert(result, string.format("%s  %s: %s%s", indent, key, value, comma))
            end
            table.insert(result, indent .. "}")
        end

        return table.concat(result)
    end

    return serialize(tbl, 0)
end

function ns.IsBlackListData(text)
    if not ns.Addon.db.global.BlackListData then
        return false
    end
    local isBlack = false
    for _, blackData in ipairs(ns.Addon.db.global.BlackListData) do
        if string.find(text, blackData) then
            isBlack = true
            break
        end
    end
    return isBlack
end

function ns.GetAchievementInfoIsTheSameDay(id)
    local _, _, _, completed, month, day, year = GetAchievementInfo(id)
    if completed then
        -- 获取当前日期
        local currentMonth = date("%m")
        local currentDay = date("%d")
        local currentYear = date("%Y")

        if tonumber(month) == tonumber(currentMonth) and
            tonumber(day) == tonumber(currentDay) and
            tonumber(year) == tonumber(currentYear) then
            return true
        end
    end
    return false
end

function ns.IsSingleKeyBound(key)
    return GetBindingAction(key) ~= ""
end

function ns.IsKeyCombinationAndSingleKeyUnbound(keyCombination)
    if ns.IsSingleKeyBound(keyCombination) then
        return false
    end

    local singleKey = keyCombination:match("[^%-]+$")
    if singleKey then
        if ns.IsSingleKeyBound(singleKey) then
            return false
        end
    end

    return true
end

function ns.FindFirstTwoUnboundKeys()
    local unboundKeys = {}
    for _, key in ipairs(keyCombinations) do
        if ns.IsKeyCombinationAndSingleKeyUnbound(key) then
            table.insert(unboundKeys, key)
            if #unboundKeys == 2 then
                break -- 找到两个未被绑定的按键后停止
            end
        end
    end
    return unboundKeys
end
