local _, ns = ...
local B, C, L, DB = unpack(ns)
local module = B:GetModule("Maps")

-- https://github.com/fang2hou/WindToolsScripts/blob/master/MapOverlay
module.RawMapData = {
	[119] = {
		["W186H276X272Y237"]     = "270870,270743",
		["W203H209X662Y11"]      = "270848",
		["W244H214X325Y140"]     = "270785",
		["W244H319X397Y66"]      = "270900,270819",
		["W259H302X457Y264"]     = "270903,270781,270794,270855",
		["W260H278X329Y237"]     = "270851,270871,270795,270769",
		["W267H378X153Y238"]     = "270822,270894,270835,270784",
		["W289H279X707Y181"]     = "270765,270824,270887,270801",
		["W290H292X712Y15"]      = "270826,270865,270759,270763",
		["W375H342X480Y0"]       = "270869,270890,270764,270762",
		["W382H258X293Y383"]     = "270761,270879,270880,270787",
		["W385H316X509Y214"]     = "270898,270840,270899,270812",
		["W396H203X314Y0"]       = "270806,270810",
		["W460H381X50Y0"]        = "270821,270758,270797,270775",
	},
	[120] = {
		["W188H211X374Y208"]     = "271192",
		["W196H218X543Y362"]     = "271358",
		["W213H219X403Y0"]       = "271232",
		["W214H261X614Y358"]     = "271313,271133",
		["W226H212X661Y264"]     = "271378",
		["W229H259X487Y0"]       = "271146,271257",
		["W229H299X42Y187"]      = "271267,271201",
		["W235H337X134Y165"]     = "271254,271233",
		["W235H354X569Y7"]       = "271149,271222",
		["W236H218X258Y203"]     = "271170",
		["W258H225X433Y118"]     = "271239,271157",
		["W299H278X703Y7"]       = "271351,271270,271175,271330",
		["W301H286X698Y332"]     = "271280,271346,271164,271387",
		["W304H203X256Y104"]     = "271352,271244",
		["W306H242X210Y0"]       = "271187,271231",
		["W311H272X691Y160"]     = "271333,271199,271364,271162",
		["W317H353X453Y219"]     = "271205,271248,271252,271236",
		["W356H300X217Y313"]     = "271322,271298,271290,271337",
	},
	[121] = {
		["W249H235X232Y129"]     = "271764",
		["W274H207X18Y461"]      = "271794,271778",
		["W278H290X217Y244"]     = "271801,271773,271779,271806",
		["W283H247X176Y421"]     = "271789,271812",
		["W294H227X358Y187"]     = "271785,271817",
		["W324H265X548Y137"]     = "271790,271765,271766,271767",
		["W328H260X331Y32"]      = "271809,271771,271772,271776",
		["W329H246X509Y0"]       = "271769,271770",
		["W332H294X17Y307"]      = "271768,271783,271795,271810",
		["W351H284X607Y41"]      = "271791,271807,271774,271796",
		["W356H224X7Y207"]       = "271781,271784",
		["W382H285X0Y46"]        = "271792,271775,271813,271797",
		["W455H400X547Y257"]     = "271798,271780,271814,271799",
		["W475H362X312Y294"]     = "271803,271788,271816,271805",
	},
	[122] = {
		["W174H173X576Y170"]     = "271946",
		["W177H191X342Y351"]     = "271992",
		["W178H208X595Y240"]     = "271945",
		["W181H178X490Y161"]     = "271993",
		["W187H263X397Y208"]     = "271980,271994",
		["W193H201X668Y223"]     = "271950",
		["W213H256X283Y203"]     = "271976",
		["W222H168X222Y100"]     = "271959",
		["W223H209X354Y0"]       = "271957",
		["W223H338X664Y25"]      = "271956,271974",
		["W232H216X585Y336"]     = "271941",
		["W238H232X343Y108"]     = "271984",
		["W242H189X225Y0"]       = "271954",
		["W244H305X621Y327"]     = "271969,271989",
		["W248H382X477Y216"]     = "271985,271968",
		["W251H192X490Y0"]       = "271970",
		["W263H265X99Y37"]       = "271940,271975,271953,271991",
		["W266H210X420Y57"]      = "271952,271967",
		["W284H308X415Y360"]     = "271997,271998,271963,271964",
		["W298H306X572Y0"]       = "271977,271978,271979,271958",
		["W333H265X99Y278"]      = "271962,271987,271983,271988",
		["W347H220X90Y180"]      = "271986,271960",
		["W350H258X168Y410"]     = "271965,271966,271972,271973",
	},
	[123] = {
		["W204H268X0Y167"]       = "254677,254678",
		["W219H283X218Y291"]     = "254688,254689",
		["W223H207X444Y276"]     = "254695",
		["W223H399X321Y15"]      = "254690,254691",
		["W227H210X327Y305"]     = "254687",
		["W238H240X217Y50"]      = "254692",
		["W245H239X690Y267"]     = "254679",
		["W248H243X538Y181"]     = "254684",
		["W269H217X715Y390"]     = "254693,254694",
		["W283H231X558Y329"]     = "254685,254686",
		["W300H343X626Y31"]      = "254680,254681,254682,254683",
		["W308H202X392Y466"]     = "254659,254660",
		["W308H212X342Y392"]     = "254657,254658",
		["W314H224X616Y30"]      = "294026,294027",
		["W373H375X355Y37"]      = "254653,254654,254655,254656",
		["W393H474X22Y122"]      = "254673,254674,254675,254676",
	},
	[124] = {
		["W207H235X427Y244"]     = "272524",
		["W233H286X705Y236"]     = "272529,272506",
		["W239H313X265Y355"]     = "272530,272516",
		["W249H248X172Y135"]     = "272507",
		["W268H288X138Y58"]      = "272517,272534,272496,272502",
		["W293H229X396Y51"]      = "272500,272501",
		["W294H327X308Y34"]      = "272523,272487,272539,272532",
		["W312H369X501Y134"]     = "272494,272495,272504,272533",
		["W322H265X596Y92"]      = "272521,272515,272522,272499",
		["W329H293X76Y375"]      = "272509,272491,272520,272484",
		["W455H316X82Y186"]      = "272535,272518,272490,272519",
		["W468H329X359Y339"]     = "272498,272531,272510,272541",
	},
	[125] = {
		["W169H164X239Y301"]     = "272922",
		["W180H239X214Y144"]     = "272933",
		["W182H270X570Y113"]     = "272927,272910",
		["W184H191X395Y470"]     = "272909",
		["W205H232X162Y143"]     = "272920",
		["W210H179X316Y296"]     = "272945",
		["W221H200X108Y206"]     = "272906",
		["W228H158X98Y318"]      = "272924",
		["W244H220X134Y429"]     = "272919",
		["W251H200X242Y468"]     = "272921",
		["W305H298X339Y370"]     = "272904,272925,272926,272952",
		["W306H484X627Y179"]     = "272934,272923,272908,272930",
		["W309H383X481Y285"]     = "272939,272953,272905,272935",
		["W322H195X109Y375"]     = "272948,272950",
		["W363H341X292Y122"]     = "272912,272913,272914,272946",
		["W369H265X218Y0"]       = "272943,272944,272931,272917",
	},
	[126] = {
		["W218H291X174Y191"]     = "273324,273292",
		["W237H248X288Y168"]     = "273329",
		["W247H304X431Y127"]     = "273322,273320",
		["W249H258X479Y241"]     = "273304,273305",
		["W261H288X607Y251"]     = "273309,273286,273310,273328",
		["W265H257X533Y345"]     = "273296,273300,273285,273287",
		["W266H254X289Y287"]     = "273330,273291",
		["W272H268X0Y247"]       = "273318,273298,273336,273303",
		["W286H265X326Y358"]     = "273311,273297,273331,273317",
		["W302H231X380Y437"]     = "273323,273289",
		["W307H256X7Y412"]       = "273326,273333",
		["W311H317X575Y88"]      = "273325,273307,273308,273319",
		["W321H305X181Y363"]     = "273312,273332,273282,273302",
		["W336H297X629Y0"]       = "273295,273301,273321,273288",
	},
	[127] = {
		["W512H416X252Y252"]     = "272721,272732,272715,272722",
		["W512H512X251Y4"]       = "272716,272728,272723,272733",
	},
	[132] = {
		["W252H260X0Y91"]        = "270966,271005",
		["W264H303X0Y176"]       = "270987,270962,270973,270997",
		["W288H222X0Y0"]         = "253268,271000",
		["W416H424X0Y244"]       = "270970,270961,270971,270996",
		["W446H369X536Y40"]      = "253267,270960,270995,270989",
		["W502H477X500Y105"]     = "253269,270985,253270,270986",
		["W544H668X129Y0"]       = "253264,271003,270968,270965,253265,253266,271002,271004,270984",
		["W558H285X444Y383"]     = "253271,253272,270974,270975,271001,270980",
	},
	[1194] = {
		["W445H160X244Y0"]   = "271435,271442",
		["W190H200X327Y60"]  = "271439",
		["W210H160X427Y78"]  = "271428",
		["W128H110X464Y33"]  = "271427",
		["W160H120X413Y476"] = "2212659",
		["W160H190X474Y384"] = "271426",
		["W190H180X462Y286"] = "271440",
		["W200H240X549Y427"] = "271437",
		["W215H215X355Y320"] = "271443",
		["W220H230X432Y170"] = "271421",
		["W230H230X301Y189"] = "271422",
	},
	[1200] = {
		["W185H128X291Y0"]   = "272172",
		["W205H128X395Y0"]   = "272179",
		["W205H230X502Y16"]  = "272169",
		["W215H240X428Y80"]  = "272177",
		["W280H240X249Y59"]  = "272187,272171",
		["W128H120X473Y260"] = "272185",
		["W128H155X379Y242"] = "272178",
		["W128H205X303Y307"] = "272176",
		["W170H128X458Y369"] = "272180",
		["W210H180X255Y214"] = "272181",
		["W225H235X532Y238"] = "272186",
		["W256H190X523Y356"] = "272170",
		["W256H200X367Y303"] = "272173",
		["W470H243X270Y425"] = "272168,272165",
	},
	[1202] = {
		["W128H100X412Y0"]   = "852705",
		["W120H110X555Y0"]   = "270553",
		["W170H120X456Y0"]   = "270564",
		["W128H105X419Y63"]  = "270554",
		["W100H165X564Y52"]  = "270569",
		["W125H115X492Y63"]  = "270584",
		["W200H145X317Y29"]  = "270572",
		["W115H110X507Y294"] = "852702",
		["W120H125X384Y115"] = "270560",
		["W125H125X556Y189"] = "270585",
		["W125H165X442Y298"] = "852696",
		["W128H128X306Y130"] = "852699",
		["W128H128X341Y537"] = "852704",
		["W128H128X431Y479"] = "852694",
		["W140H128X498Y119"] = "270574",
		["W145H125X365Y350"] = "852697",
		["W150H120X527Y307"] = "852701",
		["W155H115X407Y553"] = "852703",
		["W155H128X335Y462"] = "852695",
		["W155H128X481Y211"] = "270565",
		["W155H155X431Y118"] = "270559",
		["W175H185X365Y177"] = "852700",
		["W200H185X340Y234"] = "852693",
		["W210H150X355Y402"] = "852698",
		["W95H100X581Y247"]  = "270573",
	},
	[1205] = {
		["W285H230X276Y0"]   = "768728,768729",
		["W235H200X462Y77"]  = "768753",
		["W300H300X26Y262"]  = "769201,769202,769203,769204",
		["W330H265X44Y403"]  = "768734,768735,768736,768737",
		["W160H175X225Y478"] = "768731",
		["W165H197X314Y471"] = "768752",
		["W190H170X317Y372"] = "768732",
		["W200H200X406Y279"] = "768730",
		["W255H255X270Y197"] = "768739",
		["W255H320X462Y307"] = "768744,768745",
		["W280H240X334Y162"] = "768723,769200",
		["W195H288X399Y380"] = "768721,768722",
		["W220H280X196Y131"] = "768738,769205",
		["W350H370X626Y253"] = "768717,768718,768719,768720",
		["W370H300X549Y105"] = "768748,768749,768750,768751",
	},
	[1206] = {
		["W190H210X138Y54"]  = "270347",
		["W190H240X87Y138"]  = "2212539",
		["W230H240X192Y90"]  = "270351",
		["W160H230X558Y112"] = "270360",
		["W170H155X419Y293"] = "2212546",
		["W175H225X370Y186"] = "270352",
		["W180H210X472Y165"] = "270350",
		["W200H220X355Y412"] = "270348",
		["W205H250X655Y120"] = "270336",
		["W210H185X286Y310"] = "270346",
		["W215H210X559Y333"] = "270353",
		["W215H235X432Y362"] = "270342",
		["W230H195X531Y276"] = "270343",
		["W240H230X108Y287"] = "270358",
		["W245H245X232Y145"] = "270349",
		["W256H215X171Y424"] = "270361",
	},
	[1207] = {
		["W240H255X0Y148"]   = "2212593",
		["W245H205X389Y7"]   = "2212606",
		["W255H205X17Y310"]  = "270529",
		["W255H220X12Y428"]  = "270520",
		["W220H220X551Y48"]  = "270530",
		["W195H200X325Y148"] = "270543",
		["W200H195X445Y120"] = "270532",
		["W230H230X349Y256"] = "2212608",
		["W245H205X498Y209"] = "2212592",
		["W255H280X501Y341"] = "270540,270527",
		["W285H240X148Y384"] = "2212599,2212601",
		["W265H270X345Y389"] = "270522,270550,270528,270536",
		["W370H455X611Y110"] = "270534,270551,270546,270535",
		["W270H275X159Y199"] = "270525,270521,2212603,2212605",
	},
	[1209] = {
		["W170H200X472Y9"]   = "391433",
		["W185H190X559Y30"]  = "391432",
		["W195H180X361Y15"]  = "391435",
		["W170H145X405Y123"] = "391431",
		["W185H155X310Y133"] = "391425",
		["W225H170X501Y140"] = "391430",
		["W245H195X361Y195"] = "391434",
		["W265H220X453Y259"] = "391437,391436",
		["W384H450X212Y178"] = "391429,391428,391427,391426",
	},
	[1210] = {
		["W128H158X537Y299"] = "273015",
		["W150H128X474Y327"] = "273016",
		["W173H128X694Y289"] = "273000",
		["W174H220X497Y145"] = "273020",
		["W175H247X689Y104"] = "272996",
		["W216H179X630Y326"] = "273006",
		["W237H214X757Y205"] = "272999",
		["W243H199X363Y349"] = "273003",
		["W245H205X227Y328"] = "273001",
		["W256H156X239Y250"] = "273017",
		["W256H210X335Y139"] = "273019",
		["W230H205X698Y362"] = "2213418",
		["W186H128X395Y277"] = "2213434",
		["W211H189X746Y125"] = "2213425",
		["W201H288X587Y139"] = "273009,273002",
		["W315H235X463Y361"] = "2213428,2213430",
	},
	[1211] = {
		["W256H160X465Y0"]   = "2213063",
		["W185H165X286Y37"]  = "272610",
		["W250H215X593Y74"]  = "272600",
		["W256H220X459Y13"]  = "2213084",
		["W175H165X402Y65"]  = "2213080",
		["W160H170X470Y261"] = "272598",
		["W165H185X382Y252"] = "272616",
		["W210H160X352Y168"] = "272620",
		["W210H215X379Y447"] = "272609",
		["W220H160X364Y359"] = "272613",
		["W240H180X491Y417"] = "272599",
		["W240H240X494Y262"] = "272614",
		["W140H125X391Y446"] = "2213067",
		["W180H128X323Y128"] = "2213065",
		["W180H185X457Y144"] = "2213082",
	},
	[1212] = {
		["W205H340X590Y86"]  = "273122,273103",
		["W340H288X307Y16"]  = "273095,273111,273100,273090",
		["W160H125X300Y311"] = "273113",
		["W160H200X566Y198"] = "273121",
		["W170H165X600Y412"] = "273107",
		["W170H190X451Y323"] = "273102",
		["W180H205X520Y250"] = "273094",
		["W220H180X382Y164"] = "273114",
		["W225H185X137Y293"] = "273120",
		["W220H150X381Y265"] = "2212523",
		["W300H206X355Y462"] = "273108,273101",
		["W285H230X260Y355"] = "2212522,2212521",
		["W370H270X504Y343"] = "273119,273092,273112,273093",
	},
	[1213] = {
		["W256H384X0Y209"] = "2212705,2212706",
		["W284H450X718Y218"] = "4357864,4357866,4357868,4357870",
		["W256H256X126Y338"] = "271551",
		["W256H191X142Y455"] = "271512",
		["W256H256X261Y379"] = "271548",
		["W256H256X241Y239"] = "271536",
		["W256H179X279Y467"] = "271514",
		["W256H288X590Y269"] = "2212700,4357862",
		["W256H205X474Y412"] = "271532",
		["W256H197X687Y449"] = "271553",
		["W256H256X656Y277"] = "271533",
		["W256H256X379Y323"] = "271543",
		["W256H256X692Y144"] = "271537",
		["W256H256X562Y219"] = "271542",
		["W256H256X412Y177"] = "271523",
		["W256H256X590Y106"] = "271520",
		["W256H256X584Y8"] = "271554",
		["W256H256X427Y87"] = "271521",
		["W256H256X392Y14"] = "271535",
		["W256H256X49Y76"] = "271522",
		["W384H288X139Y61"] = "271518,271527,2212703,2212704",
		["W256H243X164Y0"] = "271529",
		["W256H256X471Y345"] = "271544",
	},
	[1214] = {
		["W288H225X2Y192"]   = "271876,271881",
		["W220H310X509Y0"]   = "271894,2212744",
		["W384H365X605Y75"]  = "271872,271898,271882,271891",
		["W125H100X109Y482"] = "271904",
		["W205H155X414Y154"] = "271897",
		["W165H200X175Y275"] = "2212736",
		["W215H240X541Y236"] = "2212742",
		["W240H275X637Y294"] = "271885,271877",
		["W235H270X418Y201"] = "271905,2212743",
		["W230H320X524Y339"] = "2212737,2212738",
		["W285H155X208Y368"] = "2212746,2212747",
		["W305H275X198Y155"] = "271883,271892,2212739,2212740",
	},
	[1215] = {
		["W255H205X13Y245"]  = "271917",
		["W275H275X509Y19"]  = "271908,271935,271936,271909",
		["W145H220X158Y149"] = "271927",
		["W160H145X512Y232"] = "271933",
		["W170H170X319Y302"] = "271934",
		["W180H170X408Y260"] = "271929",
		["W185H195X237Y185"] = "271928",
		["W195H185X240Y387"] = "271937",
		["W200H165X373Y365"] = "271922",
		["W205H195X374Y164"] = "271910",
		["W225H200X171Y306"] = "770218",
		["W170H310X693Y303"] = "271938,271916",
		["W235H285X505Y333"] = "271912,271920",
		["W280H205X571Y239"] = "271915,271921",
	},
	[1216] = {
		["W125H125X217Y287"] = "271398",
		["W128H128X573Y280"] = "271389",
		["W128H180X281Y167"] = "271392",
		["W128H190X347Y163"] = "271418",
		["W150H128X295Y385"] = "271406",
		["W155H128X522Y322"] = "271401",
		["W155H170X694Y273"] = "271409",
		["W165H165X608Y291"] = "271408",
		["W200H185X314Y311"] = "271400",
		["W200H200X386Y294"] = "271417",
		["W128H165X502Y221"] = "2212651",
		["W128H120X792Y279"] = "2212654",
		["W115H115X252Y249"] = "2212640",
		["W128H165X759Y173"] = "2212653",
		["W180H128X274Y296"] = "2212641",
		["W180H165X166Y184"] = "2212644",
		["W240H185X155Y403"] = "2212639",
		["W315H200X397Y163"] = "271410,271396",
	},
	[1220] = {
		["W405H430X85Y30"]   = "254509,254510,254511,254512",
		["W460H365X422Y8"]   = "254505,254506,254507,254508",
		["W275H235X77Y366"]  = "254503,254504",
		["W305H230X545Y407"] = "254527,254528",
		["W305H220X494Y300"] = "2201968,2201949",
		["W425H325X250Y170"] = "254529,254530,254531,254532",
		["W360H280X247Y388"] = "2201972,2201970,2201969,2201971",
	},
	[1224] = {
		["W415H315X56Y258"]  = "270941,270925,270926,270917",
		["W225H220X36Y109"]  = "270938",
		["W270H285X513Y99"]  = "270922,270934,270923,270937",
		["W280H355X722Y46"]  = "270944,270910,270935,270945",
		["W220H225X707Y168"] = "270927",
		["W245H265X334Y114"] = "270912,270909",
		["W256H280X173Y101"] = "270919,270911",
		["W270H310X589Y279"] = "270920,270914,270908,270929",
		["W294H270X708Y311"] = "270906,270918,270936,270942",
		["W320H270X377Y285"] = "270933,270943,270921,270928",
	},
	[1228] = {
		["W485H405X0Y0"]     = "2212713,2212714,2212715,2212716",
		["W225H220X422Y332"] = "271560",
		["W240H220X250Y270"] = "271567",
		["W255H250X551Y292"] = "271573",
		["W256H210X704Y330"] = "271578",
		["W256H237X425Y431"] = "271582",
		["W256H240X238Y428"] = "271576",
		["W256H249X577Y419"] = "271559",
		["W256H256X381Y147"] = "271572",
		["W306H233X696Y435"] = "271557,271583",
		["W310H256X587Y190"] = "271584,271565",
		["W256H341X124Y327"] = "2212708,2212709",
	},
	[1233] = {
		["W270H270X426Y299"] = "271092,271085,271086,271089",
		["W300H245X269Y337"] = "271095,271079",
		["W380H365X249Y76"]  = "271075,271076,271080,271081",
	},
	[1235] = {
		["W910H210X89Y31"]   = "271481,271460,271474,271468",
		["W160H330X19Y132"]  = "271453,271454",
		["W275H250X55Y342"]  = "271444,271483",
		["W350H300X85Y149"]  = "271473,271463,271467,271464",
		["W360H420X298Y79"]  = "2212678,2212679,2212680,2212681",
		["W200H175X653Y120"] = "271466",
		["W235H250X390Y382"] = "271449",
		["W250H230X539Y369"] = "271455",
		["W220H220X690Y353"] = "2212676",
		["W195H145X102Y302"] = "2212669",
		["W220H340X504Y117"] = "271470,271477",
		["W255H285X243Y348"] = "271448,271456",
		["W315H280X631Y162"] = "271471,271461,271450,271451",
	},
	[1236] = {
		["W230H300X125Y12"]  = "252882,252883",
		["W315H235X542Y48"]  = "252880,252881",
		["W235H270X229Y11"]  = "252884,2212852",
		["W290H175X339Y11"]  = "2212855,2212856",
		["W320H410X352Y87"]  = "252894,252895,252896,252897",
		["W195H250X109Y370"] = "252899",
		["W256H230X217Y203"] = "252898",
		["W255H285X215Y348"] = "252886,252887",
		["W345H256X482Y321"] = "252866,252867",
		["W370H295X546Y199"] = "252890,252891,252892,252893",
		["W295H358X309Y310"] = "252862,252863,2212828,2212829",
	},
	[1237] = {
		["W275H256X277Y0"]   = "272357,272342",
		["W365H350X0Y284"]   = "272364,272348,272358,272359",
		["W340H195X83Y197"]  = "272351,272340",
		["W365H245X121Y72"]  = "272362,272356",
		["W235H270X399Y129"] = "272334,2212936",
		["W250H250X654Y161"] = "272372",
		["W320H210X595Y320"] = "272347,272371",
		["W465H255X484Y361"] = "272369,272363",
		["W255H300X500Y215"] = "2212977,2212978",
		["W430H290X187Y333"] = "272344,272354,272350,272339",
		["W535H275X133Y240"] = "272335,272343,2212940,2212942,2212943,2212945",
	},
	[1238] = {
		["W170H90X284Y0"]    = "2213168",
		["W125H140X196Y3"]   = "2213173",
		["W155H150X388Y0"]   = "2213156",
		["W245H220X483Y8"]   = "2213196",
		["W90H80X241Y92"]    = "2213143",
		["W95H95X299Y88"]    = "2213154",
		["W105H125X387Y64"]  = "2213191",
		["W115H115X156Y42"]  = "2213197",
		["W128H175X432Y94"]  = "2213162",
		["W140H110X269Y26"]  = "2213165",
		["W190H175X152Y90"]  = "2213188",
		["W128H125X331Y59"]  = "2213158",
		["W95H95X350Y335"]   = "2213170",
		["W90H115X211Y359"]  = "2213164",
		["W105H110X311Y131"] = "2213161",
		["W110H105X260Y132"] = "2213150",
		["W110H110X306Y301"] = "2213171",
		["W110H140X371Y129"] = "2213145",
		["W120H120X345Y276"] = "2213148",
		["W125H120X314Y493"] = "2213152",
		["W125H125X280Y368"] = "2213159",
		["W128H125X364Y231"] = "2213194",
		["W145H128X203Y433"] = "2213147",
		["W165H175X194Y284"] = "2213146",
		["W165H190X229Y422"] = "2213192",
		["W170H125X394Y212"] = "2213174",
		["W200H185X235Y189"] = "2213187",
	},
	[1239] = {
		["W240H245X0Y262"]   = "2213206",
		["W245H305X0Y140"]   = "272759,272750",
		["W256H668X746Y0"]   = "272756,272737,272769",
		["W365H305X492Y0"]   = "2213200,2213202,2213203,2213204",
		["W235H205X171Y145"] = "272736",
		["W215H365X724Y120"] = "272739,272746",
		["W275H240X129Y236"] = "272747,272763",
		["W315H235X286Y110"] = "272768,272770",
		["W345H250X552Y378"] = "272740,272773",
		["W360H315X279Y237"] = "272742,272751,272752,272764",
		["W300H275X565Y218"] = "272772,272760,2213215,2213216",
	},
	[1240] = {
		["W165H200X488Y0"]   = "273143",
		["W210H215X387Y11"]  = "273145",
		["W215H215X307Y29"]  = "2212528",
		["W195H240X442Y241"] = "273137",
		["W200H185X208Y375"] = "273142",
		["W200H240X524Y252"] = "273125",
		["W220H200X317Y331"] = "273130",
		["W225H205X328Y148"] = "273126",
		["W225H210X459Y105"] = "273146",
		["W225H256X220Y102"] = "273149",
		["W256H175X339Y418"] = "273124",
		["W288H235X523Y377"] = "273131,273134",
		["W305H210X204Y260"] = "273129,273133",
		["W280H190X205Y467"] = "273141,2212527",
	},
	[1243] = {
		["W300H240X92Y82"]   = "273178,273167",
		["W175H128X13Y314"]  = "273156",
		["W205H180X401Y21"]  = "273164",
		["W225H190X89Y142"]  = "273171",
		["W240H175X77Y245"]  = "273163",
		["W200H240X237Y41"]  = "2212533",
		["W230H190X470Y371"] = "273174",
		["W205H245X527Y264"] = "273177",
		["W225H185X347Y218"] = "273159",
		["W190H160X628Y176"] = "273181",
		["W195H185X247Y205"] = "273155",
		["W200H185X349Y115"] = "273173",
		["W256H250X507Y115"] = "2212535",
		["W185H240X456Y125"] = "2212531",
		["W350H360X611Y230"] = "2213613,2213614,2212532,2212534",
	},
	[1244] = {
		["W180H256X377Y93"]  = "272822",
		["W128H190X335Y313"] = "272807",
		["W160H210X382Y281"] = "272826",
		["W170H240X272Y127"] = "272830",
		["W185H128X368Y443"] = "272814",
		["W200H200X561Y292"] = "272815",
		["W225H225X491Y153"] = "272811",
		["W256H185X436Y380"] = "272810",
		["W190H128X462Y323"] = "2213323",
		["W128H100X494Y548"] = "2213328",
		["W315H256X101Y247"] = "272806,272812",
	},
	[1247] = {
		["W195H215X510Y0"]   = "271043",
		["W230H190X375Y94"]  = "769208",
		["W170H195X468Y85"]  = "769211",
		["W150H215X318Y162"] = "769206",
		["W175H158X329Y510"] = "271044",
		["W175H183X229Y485"] = "769210",
		["W180H195X365Y181"] = "769207",
		["W190H205X324Y306"] = "271045",
		["W200H170X305Y412"] = "769209",
	},
	[1248] = {
		["W245H245X19Y28"]   = "270376",
		["W215H305X205Y38"]  = "2212542,2212543",
		["W128H195X131Y137"] = "270380",
		["W146H200X856Y151"] = "270387",
		["W155H150X260Y373"] = "270398",
		["W180H245X520Y238"] = "270402",
		["W200H160X796Y311"] = "270390",
		["W205H185X272Y251"] = "270386",
		["W210H185X463Y141"] = "270400",
		["W225H255X597Y258"] = "270401",
		["W235H205X547Y426"] = "270375",
		["W245H255X713Y344"] = "270405",
		["W255H195X203Y158"] = "270389",
		["W220H195X104Y259"] = "2212548",
		["W165H175X189Y324"] = "2212540",
		["W200H205X392Y218"] = "2212541",
		["W285H185X694Y225"] = "270388,2212547",
		["W275H240X356Y347"] = "2212544,2212545",
	},
	[1249] = {
		["W305H310X0Y0"]     = "2213348,2213349,2213351,2213352",
		["W190H190X31Y155"]  = "272968",
		["W210H180X205Y70"]  = "272963",
		["W205H195X259Y131"] = "272962",
		["W210H190X357Y264"] = "272954",
		["W210H195X391Y192"] = "2213363",
		["W240H220X492Y250"] = "2213395",
		["W250H240X179Y200"] = "2213369",
		["W320H365X610Y300"] = "2213371,2213372,2213374,2213375",
	},
	[1250] = {
		["W270H205X247Y0"]   = "272632,272641",
		["W125H86X663Y582"]  = "272650",
		["W145H107X572Y561"] = "272628",
		["W150H150X389Y320"] = "272646",
		["W190H97X718Y571"]  = "2213087",
		["W200H215X390Y145"] = "272624",
		["W225H120X668Y515"] = "2213088",
		["W125H125X475Y433"] = "2213093",
		["W230H355X210Y234"] = "272633,272647",
		["W288H355X457Y282"] = "272648,272634,272635,272623",
		["W320H275X553Y197"] = "272630,272649,272642,272636",
	},
	[1251] = {
		["W200H250X554Y0"]   = "271114",
		["W205H145X431Y0"]   = "271126",
		["W100H100X241Y6"]   = "2212638",
		["W205H250X311Y61"]  = "2212632",
		["W285H245X625Y33"]  = "271104,271124",
		["W190H220X447Y102"] = "271111",
		["W195H242X293Y426"] = "271122",
		["W205H195X690Y444"] = "271105",
		["W230H230X167Y389"] = "271125",
		["W220H220X607Y215"] = "2212634",
		["W170H160X555Y181"] = "2212635",
		["W245H285X212Y215"] = "271106,271129",
		["W275H250X387Y244"] = "271127,2212633",
		["W205H285X590Y365"] = "2212636,2212637",
		["W285H280X399Y380"] = "271108,271112,271113,271109",
	},
	[1252] = {
		["W150H125X454Y0"]   = "2212721",
		["W190H155X305Y0"]   = "2212733",
		["W110H110X493Y70"]  = "2212732",
		["W285H245X319Y75"]  = "271705,271686",
		["W140H165X690Y141"] = "271696",
		["W155H160X689Y233"] = "271675",
		["W190H250X540Y320"] = "271699",
		["W225H180X751Y198"] = "271680",
		["W230H195X454Y201"] = "271687",
		["W110H170X478Y386"] = "2212728",
		["W115H115X486Y329"] = "2212726",
		["W120H195X623Y167"] = "2212729",
		["W180H180X208Y234"] = "2212734",
		["W240H220X618Y298"] = "2212735",
		["W145H320X404Y256"] = "271700,271682",
		["W215H293X192Y375"] = "2212730,2212731",
	},
	[1253] = {
		["W250H315X422Y0"]   = "271507,271504",
		["W280H270X230Y0"]   = "2212685,2212686,2212687,2212688",
		["W200H195X660Y21"]  = "271494",
		["W230H205X534Y224"] = "271500",
		["W255H250X257Y313"] = "2212689",
		["W285H240X367Y381"] = "271503,271509",
		["W400H255X239Y189"] = "2212683,2212684",
	},
	[1254] = {
		["W210H175X254Y0"]   = "272788",
		["W175H165X421Y91"]  = "272774",
		["W155H150X592Y75"]  = "2213281",
		["W110H180X473Y234"] = "272800",
		["W155H150X561Y256"] = "272789",
		["W160H150X395Y346"] = "272798",
		["W180H200X252Y199"] = "272792",
		["W185H250X203Y286"] = "272781",
		["W195H175X299Y100"] = "272776",
		["W195H210X323Y359"] = "272784",
		["W205H145X325Y289"] = "272782",
		["W205H157X445Y511"] = "272801",
		["W215H175X499Y293"] = "272795",
		["W215H180X363Y194"] = "272799",
		["W220H210X449Y372"] = "272805",
		["W160H190X629Y220"] = "2213273",
		["W165H180X509Y168"] = "2213313",
		["W110H140X611Y147"] = "2213315",
		["W120H135X533Y104"] = "2213275",
		["W150H160X291Y434"] = "2213311",
	},
	[1259] = {
		["W570H170X366Y0"]   = "2212556,2212557,2212558",
		["W245H185X644Y40"]  = "270432",
		["W145H215X422Y95"]  = "2212573",
		["W200H150X77Y331"]  = "2212555",
		["W215H175X84Y229"]  = "2212574",
		["W225H180X35Y422"]  = "2212564",
		["W235H140X478Y44"]  = "2212560",
		["W120H155X818Y107"] = "270434",
		["W160H210X404Y194"] = "270412",
		["W240H125X552Y499"] = "270410",
		["W240H155X499Y119"] = "2212568",
		["W190H200X681Y153"] = "2212567",
		["W220H255X191Y369"] = "2212554",
		["W315H200X296Y429"] = "270409,2212559",
		["W370H220X389Y353"] = "2212565,2212566",
		["W395H128X396Y540"] = "2212569,2212570",
		["W235H270X250Y106"] = "2212571,2212572",
		["W265H280X238Y221"] = "270414,2212561,2212562,2212563",
		["W270H300X479Y201"] = "2212550,2212551,2212552,2212553",
	},
	[1260] = {
		["W240H145X483Y0"]   = "271660",
		["W195H170X330Y29"]  = "271652",
		["W215H215X420Y54"]  = "271673",
		["W160H145X548Y90"]  = "271653",
		["W145H159X496Y509"] = "271657",
		["W165H155X332Y465"] = "271663",
		["W175H135X408Y533"] = "271658",
		["W185H160X405Y429"] = "271659",
		["W235H145X292Y263"] = "271666",
		["W235H155X297Y381"] = "271664",
		["W235H200X307Y123"] = "271665",
		["W245H128X271Y331"] = "271669",
	},
	[1261] = {
		["W570H265X160Y6"]   = "273052,273062,273057,273058,2213490,2213491",
		["W285H285X582Y67"]  = "273051,2213483,2213484,2213486",
		["W295H270X367Y178"] = "273042,273065,273050,273036",
		["W310H355X560Y240"] = "273072,273039,273037,273063",
		["W315H345X121Y151"] = "273043,273075,273069,273061",
		["W345H285X158Y368"] = "273046,273053,273071,273047",
		["W345H285X367Y380"] = "273059,273066,273073,273054",
	},
	[1263] = {
		["W555H510X244Y89"]  = "252844,252845,252846,252847,2212870,2212872",
	},
	[1264] = {
		["W384H512X97Y144"]  = "272559,272543,272574,272575",
		["W512H320X265Y12"]  = "272565,272566,272577,272546",
		["W320H289X104Y24"]  = "272581,272562,2213052,2213053",
		["W384H384X500Y65"]  = "272580,272544,2213048,2213049",
		["W288H256X116Y413"] = "272564,272553",
		["W320H256X344Y197"] = "272573,272545",
		["W512H384X245Y285"] = "272567,272547,272555,272548",
	},
	[1266] = {
		["W250H180X368Y7"]   = "273184",
		["W175H185X555Y27"]  = "273203",
		["W125H165X611Y242"] = "273206",
		["W145H125X617Y158"] = "273200",
		["W165H140X593Y340"] = "273199",
		["W165H200X509Y107"] = "273191",
		["W185H160X392Y137"] = "273207",
		["W185H180X493Y258"] = "273185",
		["W200H160X523Y376"] = "273198",
		["W215H185X401Y198"] = "273192",
		["W230H120X229Y243"] = "273187",
		["W240H140X222Y172"] = "273202",
		["W255H205X447Y441"] = "2213650",
	},
	[1273] = {
		["W270H240X348Y13"]  = "270331,270325",
		["W235H290X399Y375"] = "270314,270315",
		["W300H300X335Y172"] = "270320,270321,270322,270323",
	},
	[1628] = {
		["W512H512X195Y5"]   = "271619,271602,271589,271638",
		["W512H512X440Y87"]  = "271632,271600,271617,271618",
		["W128H193X554Y475"] = "271603",
		["W128H197X584Y471"] = "271598",
		["W128H248X511Y420"] = "271592",
		["W128H253X183Y415"] = "271625",
		["W128H256X292Y319"] = "271633",
		["W128H256X580Y399"] = "271630",
		["W256H128X231Y404"] = "271627",
		["W256H128X243Y469"] = "271635",
		["W256H128X255Y507"] = "271596",
		["W256H128X524Y359"] = "271591",
		["W256H128X539Y305"] = "271628",
		["W256H172X378Y496"] = "271614",
		["W256H174X464Y494"] = "271615",
		["W256H256X215Y298"] = "271601",
		["W256H256X307Y136"] = "271608",
		["W256H256X324Y384"] = "271599",
		["W256H256X361Y298"] = "271637",
		["W256H256X386Y386"] = "271612",
		["W256H256X460Y373"] = "271588",
		["W256H256X474Y314"] = "271610",
		["W256H256X605Y253"] = "271604",
		["W256H256X669Y228"] = "271586",
		["W256H353X648Y315"] = "271587,271590",
	},
	[1629] = {
		["W512H512X44Y0"]    = "271726,271756,271727,271710",
		["W256H256X585Y0"]   = "271761",
		["W256H512X365Y2"]   = "271762,271751",
		["W427H256X575Y0"]   = "271735,271736",
		["W512H256X326Y0"]   = "271729,271707",
		["W512H256X460Y0"]   = "271731,271719",
		["W256H512X60Y117"]  = "271754,271733",
		["W256H256X40Y287"]  = "271752",
		["W512H293X95Y375"]  = "271721,271725,271714,271737",
		["W256H256X184Y238"] = "271744",
		["W256H256X210Y126"] = "271716",
		["W256H262X364Y406"] = "271711,271717",
		["W256H449X340Y219"] = "271740,271730",
		["W256H512X448Y150"] = "271741,271723",
		["W429H256X573Y136"] = "271715,271745",
		["W404H436X598Y232"] = "271742,271728,271758,271706",
		["W512H431X466Y237"] = "271712,271757,271713,271734",
	},
	[1631] = {
		["W256H128X356Y0"]   = "270493",
		["W256H256X291Y3"]   = "270510",
		["W512H512X74Y85"]   = "270475,270515,270495,270505",
		["W256H256X365Y49"]  = "270488",
		["W256H256X488Y24"]  = "270474",
		["W256H222X23Y446"]  = "270498",
		["W128H256X462Y349"] = "270497",
		["W256H247X220Y421"] = "270482",
		["W256H256X174Y363"] = "270492",
		["W256H256X176Y303"] = "270463",
		["W256H256X281Y305"] = "270509",
		["W256H256X352Y378"] = "270481",
		["W256H256X383Y249"] = "270513",
		["W256H256X449Y183"] = "270508",
		["W256H256X507Y350"] = "270512",
		["W256H256X515Y279"] = "270476",
		["W475H512X527Y104"] = "270511,270483,270489,270484",
	},
	[1633] = {
		["W512H256X477Y6"]   = "271867,271842",
		["W256H256X34Y142"]  = "271836",
		["W256H378X25Y290"]  = "271850,271864",
		["W256H512X326Y45"]  = "271840,271849",
		["W512H512X38Y152"]  = "271851,271841,271865,271853",
		["W512H512X478Y25"]  = "271863,271857,271845,271839",
		["W256H256X182Y412"] = "271830",
		["W256H256X206Y110"] = "271835",
		["W256H256X467Y154"] = "271852",
		["W256H256X469Y298"] = "271848",
		["W256H256X705Y368"] = "271843",
		["W256H260X308Y408"] = "271838,271861",
		["W256H458X338Y210"] = "271855,271833",
		["W256H512X579Y128"] = "271866,271821",
		["W256H512X737Y156"] = "271854,271825",
		["W422H238X580Y430"] = "271826,271822",
		["W512H255X261Y413"] = "271856,271820",
		["W512H342X183Y326"] = "271862,271844,271823,271831",
	},
	[1635] = {
		["W256H128X124Y0"]   = "273241",
		["W256H256X88Y50"]   = "273235",
		["W256H256X81Y152"]  = "273222",
		["W256H256X31Y339"]  = "273262",
		["W512H256X20Y202"]  = "273248,273279",
		["W256H512X219Y51"]  = "273268,273226",
		["W256H512X329Y25"]  = "273223,273272",
		["W256H512X462Y90"]  = "273253,273242",
		["W256H207X720Y461"] = "273266",
		["W256H256X175Y232"] = "273267",
		["W256H256X342Y249"] = "273233",
		["W256H256X512Y303"] = "273271",
		["W256H256X596Y412"] = "273280",
		["W256H343X141Y325"] = "273224,273225",
		["W256H512X569Y112"] = "273249,273238",
		["W308H256X694Y321"] = "273276,273246",
		["W286H512X716Y128"] = "273243,273273,273250,273251",
		["W512H336X314Y332"] = "273221,273269,273236,273277",
	},
	[1637] = {
		["W512H512X348Y8"]   = "272467,272465,272422,272453",
		["W512H512X116Y35"]  = "272428,272424,272433,272445",
		["W512H512X394Y90"]  = "272459,272438,272463,272447",
		["W256H256X520Y93"]  = "272421",
		["W256H256X143Y256"] = "272431",
		["W256H256X554Y308"] = "272461",
		["W256H512X290Y129"] = "272451,272471",
		["W492H223X510Y445"] = "272442,272443",
		["W396H512X606Y126"] = "272429,272470,272446,272450",
		["W512H358X343Y310"] = "272454,272426,272439,272455",
		["W512H410X469Y258"] = "272448,272449,272469,272452",
		["W512H439X168Y229"] = "272430,272460,272434,272435",
		["W512H512X104Y155"] = "272436,272440,272441,272427",
	},
	[1638] = {
		["W256H256X422Y0"]   = "270665",
		["W256H256X585Y0"]   = "270651",
		["W256H256X286Y28"]  = "270625",
		["W256H256X412Y95"]  = "270631",
		["W256H256X527Y81"]  = "270611",
		["W256H256X673Y71"]  = "270626",
		["W512H256X214Y55"]  = "270621,270633",
		["W256H512X479Y98"]  = "270616,270617",
		["W256H128X563Y151"] = "270643",
		["W256H240X271Y428"] = "270622",
		["W256H254X446Y414"] = "270642",
		["W256H256X254Y176"] = "270663",
		["W256H256X439Y210"] = "270649",
		["W256H256X623Y147"] = "270666",
		["W256H256X629Y406"] = "270667",
		["W256H256X658Y297"] = "270655",
		["W256H256X733Y109"] = "270609",
		["W256H297X342Y371"] = "270669,270657",
		["W256H318X289Y350"] = "270638,270630",
		["W256H336X533Y332"] = "270612,270658",
		["W256H396X405Y272"] = "270664,270659",
		["W256H410X554Y258"] = "270629,270606",
		["W256H419X512Y249"] = "270644,270610",
		["W256H462X166Y206"] = "270652,270653",
		["W256H507X314Y161"] = "270619,270620",
		["W416H256X586Y147"] = "270628,270605",
		["W512H252X144Y416"] = "270662,270632",
	},
	[1639] = {
		["W256H512X44Y62"]   = "270690,270729",
		["W256H256X637Y0"]   = "270714",
		["W256H256X657Y78"]  = "270712",
		["W256H256X729Y54"]  = "270682",
		["W256H256X555Y87"]  = "270741",
		["W256H256X205Y39"]  = "270701",
		["W256H256X451Y29"]  = "270734",
		["W256H256X613Y82"]  = "270709",
		["W256H256X302Y27"]  = "270727",
		["W512H430X43Y238"]  = "270692,270673,270702,270672",
		["W128H128X180Y216"] = "270671",
		["W239H256X763Y256"] = "270710",
		["W256H185X309Y483"] = "270718",
		["W256H198X503Y470"] = "270687",
		["W256H256X221Y136"] = "270676",
		["W256H256X232Y242"] = "270703",
		["W256H256X250Y404"] = "270739",
		["W256H256X293Y285"] = "270728",
		["W256H256X297Y136"] = "270733",
		["W256H256X367Y209"] = "270679",
		["W256H256X414Y406"] = "270700",
		["W256H256X437Y258"] = "270698",
		["W256H256X481Y117"] = "270720",
		["W256H256X546Y410"] = "270699",
		["W256H256X556Y216"] = "270740",
		["W256H256X598Y338"] = "270677",
		["W485H141X517Y527"] = "270711,270723",
		["W512H242X177Y426"] = "270674,270731",
	},
	[1640] = {
		["W256H256X157Y32"]  = "272235",
		["W256H256X277Y54"]  = "272242",
		["W256H256X351Y52"]  = "272237",
		["W256H256X598Y79"]  = "272232",
		["W256H256X504Y53"]  = "272208",
		["W256H512X10Y107"]  = "272199,272200",
		["W512H420X36Y248"]  = "272224,272233,272191,272212",
		["W256H241X558Y427"] = "272204",
		["W256H256X162Y154"] = "272198",
		["W256H256X219Y199"] = "272231",
		["W256H256X335Y193"] = "272213",
		["W256H256X387Y390"] = "272220",
		["W256H256X391Y258"] = "272230",
		["W256H256X431Y143"] = "272188",
		["W256H256X532Y363"] = "272236",
		["W256H256X533Y267"] = "272206",
		["W256H256X666Y233"] = "272244",
		["W256H334X660Y334"] = "272196,272197",
		["W512H334X168Y334"] = "272205,272229,272190,272238",
	},
	[1641] = {
		["W256H256X116Y4"]   = "272878",
		["W256H256X314Y0"]   = "272837",
		["W512H512X104Y4"]   = "272861,272831,272883,272838",
		["W256H256X478Y19"]  = "272880",
		["W256H512X455Y34"]  = "272879,272834",
		["W128H256X316Y268"] = "272840",
		["W256H208X321Y460"] = "272889",
		["W256H234X247Y434"] = "272843",
		["W256H256X222Y362"] = "272846",
		["W256H256X245Y289"] = "272881",
		["W256H256X310Y345"] = "272887",
		["W256H256X377Y272"] = "272836",
		["W256H256X397Y165"] = "272839",
		["W256H256X417Y327"] = "272873",
		["W256H256X480Y277"] = "272866",
		["W256H256X505Y154"] = "272886",
		["W256H256X521Y275"] = "272835",
		["W256H367X103Y301"] = "272844,272847",
		["W512H256X143Y171"] = "272851,272867",
		["W385H512X617Y149"] = "272860,272855,272850,272856",
		["W512H320X449Y348"] = "272876,272888,272857,272877",
	},
	[1642] = {
		["W256H256X229Y38"]  = "272263",
		["W256H256X237Y22"]  = "272273",
		["W256H256X396Y10"]  = "272269",
		["W256H256X411Y20"]  = "272248",
		["W512H256X354Y49"]  = "272296,272294",
		["W256H128X241Y388"] = "272255",
		["W256H145X490Y523"] = "272274",
		["W256H179X357Y489"] = "272288",
		["W256H213X239Y455"] = "272292",
		["W256H217X454Y451"] = "272253",
		["W256H256X132Y294"] = "272262",
		["W256H256X171Y155"] = "272247",
		["W256H256X253Y301"] = "272283",
		["W256H256X298Y134"] = "272285",
		["W256H256X328Y397"] = "272280",
		["W256H256X356Y261"] = "272249",
		["W256H256X465Y336"] = "272260",
		["W256H256X481Y208"] = "272264",
		["W256H256X513Y138"] = "272282",
		["W256H256X644Y173"] = "272287",
		["W256H387X147Y281"] = "272279,272265",
		["W409H384X593Y284"] = "272267,272254,272268,272284",
	},
	[1646] = {
		["W512H512X251Y4"]   = "272716,272728,272723,272733",
		["W512H416X252Y252"] = "272721,272732,272715,272722",
	},
}