---@type SeasonOfDiscovery
local SeasonOfDiscovery = QuestieLoader:ImportModule("SeasonOfDiscovery")
---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB")
---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")

--- Load the base NPCs for Season of Discovery
--- These are generated, do NOT EDIT the data entries here.
--- If you want to edit an NPC, do so in sodNPCFixes.lua
function SeasonOfDiscovery:LoadBaseNPCs()
    local npcKeys = QuestieDB.npcKeys
    local zoneIDs = ZoneDB.zoneIDs
    local sortKeys = QuestieDB.sortKeys

    return {
        [162539] = {
            [npcKeys.name] = "World Talent Master",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [169106] = {
            [npcKeys.name] = "Shea Dorrisist",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [173338] = {
            [npcKeys.name] = "Invisible Bunny",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [176552] = {
            [npcKeys.name] = "Orgrimmar",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [176553] = {
            [npcKeys.name] = "Stormwind",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [176663] = {
            [npcKeys.name] = "Call for Help Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [176721] = {
            [npcKeys.name] = "Dummy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [177063] = {
            [npcKeys.name] = "Spellcaster Dummy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [183709] = {
            [npcKeys.name] = "Season 01 Controller - Era",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [183713] = {
            [npcKeys.name] = "Season 02 Controller - Fresh Start",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [184314] = {
            [npcKeys.name] = "Beta Vendor and Raid Teleporter",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [184383] = {
            [npcKeys.name] = "Sulfuron Harbinger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185273] = {
            [npcKeys.name] = "Firemaw Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185320] = {
            [npcKeys.name] = "Unstable Chromatic Drake",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2677,
            [npcKeys.spawns] = {
                [2677] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185331] = {
            [npcKeys.name] = "Avelina Lilly Projection",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185332] = {
            [npcKeys.name] = "Isaac Pearson Projection",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185336] = {
            [npcKeys.name] = "Jezelle's Incubus",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{77.4,13.8},{77.8,14.6},{78.4,14.2},{78.6,14.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185342] = {
            [npcKeys.name] = "Ruby Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185371] = {
            [npcKeys.name] = "Emerald Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185378] = {
            [npcKeys.name] = "Azure Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185379] = {
            [npcKeys.name] = "Obsidian Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185380] = {
            [npcKeys.name] = "Bronze Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185536] = {
            [npcKeys.name] = "Suppression Device Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185585] = {
            [npcKeys.name] = "Flame Patch",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185590] = {
            [npcKeys.name] = "Dream Fog",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185605] = {
            [npcKeys.name] = "Chromatic Drakonid Spawner",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185631] = {
            [npcKeys.name] = "Corrupted Weapon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185650] = {
            [npcKeys.name] = "Dream Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185658] = {
            [npcKeys.name] = "Corrupted Weapon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185746] = {
            [npcKeys.name] = "Bouncing Bolt",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185760] = {
            [npcKeys.name] = "Nightmare Brambles",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185859] = {
            [npcKeys.name] = "Wing Buffet Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185868] = {
            [npcKeys.name] = "[DNT] Electricity Visual Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [186130] = {
            [npcKeys.name] = "[DNT] Ebonroc and Flamegor Controller",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [186348] = {
            [npcKeys.name] = "The Prophet Skeram",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [186506] = {
            [npcKeys.name] = "[DNT] Frost Tomb",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187162] = {
            [npcKeys.name] = "Eye of C'Thun",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187237] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187274] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187309] = {
            [npcKeys.name] = "Eye of C'Thun",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187327] = {
            [npcKeys.name] = "Claw Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187345] = {
            [npcKeys.name] = "Eye Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187346] = {
            [npcKeys.name] = "Giant Claw Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187383] = {
            [npcKeys.name] = "AQ40 Bonus Difficulty Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187564] = {
            [npcKeys.name] = "AQ40 Bonus Difficulty Indicator",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187664] = {
            [npcKeys.name] = "Fungal Spore Cluster",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187724] = {
            [npcKeys.name] = "Mad Scientist",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187725] = {
            [npcKeys.name] = "Deathknight Captain",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187728] = {
            [npcKeys.name] = "Necropolis Acolyte",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187729] = {
            [npcKeys.name] = "Patchwork Golem",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187798] = {
            [npcKeys.name] = "Corrupted Weapon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187801] = {
            [npcKeys.name] = "Corrupted Weapon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187832] = {
            [npcKeys.name] = "Skeletal Hitching Post",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187978] = {
            [npcKeys.name] = "Thaddius Mechanic Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187993] = {
            [npcKeys.name] = "Plagued Ghoul",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188018] = {
            [npcKeys.name] = "Dread Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188109] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188110] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188111] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188119] = {
            [npcKeys.name] = "Claw Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188131] = {
            [npcKeys.name] = "Giant Claw Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188134] = {
            [npcKeys.name] = "Eye Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188147] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188148] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188170] = {
            [npcKeys.name] = "Giant Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188178] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188182] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188183] = {
            [npcKeys.name] = "Giant Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [189047] = {
            [npcKeys.name] = "[DNT] Quick Sand",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [200571] = {
            [npcKeys.name] = "Artificer Terothordius",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [201722] = {
            [npcKeys.name] = "Ghamoo-ra",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [201854] = {
            [npcKeys.name] = "Cutty",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{49.8,52}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [201933] = {
            [npcKeys.name] = "Spellfrost Orb",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202060] = {
            [npcKeys.name] = "Frozen Murloc",
            [npcKeys.minLevel] = 9,
            [npcKeys.maxLevel] = 9,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{76.8,51.4},{77,51.8}},
                [85] = {{66.2,40.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202079] = {
            [npcKeys.name] = "Shadowfiend",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202093] = {
            [npcKeys.name] = "Polymorphed Apprentice",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{28.2,82.6},{28.4,82.4},{28.6,83.2},{28.8,82.4},{29.4,84},{29.6,83.4},{29.6,84},{29.6,84.6},{30.4,90.4},{30.4,90.6},{30.8,89.4},{30.8,90.2},{31,68.4},{31,90.6},{31.2,68.8},{31.2,87},{31.6,68.8},{31.6,90},{31.8,90.6},{34.4,83.2},{34.8,82.2},{34.8,83},{34.8,84},{36,85.4},{37.2,77.6},{37.4,77.2},{37.8,77.6},{38,77},{38.2,76.4},{38.6,76},{38.6,77.4},{40.4,82.8},{40.4,89.4},{40.4,89.8},{40.6,87.6},{40.6,89.4},{40.8,90},{44.4,56.4},{44.4,56.6},{44.4,57.6},{44.6,56.6},{44.6,57.6},{44.8,56.2},{46,86.4},{46,86.6},{46,87.6},{46.2,70.4},{46.4,69.4},{46.4,71},{46.6,70.4},{46.8,70.6},{48.4,52.4},{48.4,52.8},{48.4,54.2},{48.4,54.8},{48.4,81.4},{48.6,52.6},{48.6,53.6},{48.6,55},{48.8,55.6},{48.8,81.8},{49,51.2},{49,51.6},{49,81.4},{49.2,73.4},{49.4,73.6},{49.6,52.8},{49.8,73.4},{49.8,73.6},{51.4,84},{56.2,80.4},{56.2,81},{56.2,81.6},{56.6,80.4},{56.6,81},{58.4,60},{58.6,60.2},{59,59.4},{61.4,77.4},{61.6,77},{61.6,77.6},{62.4,63},{62.4,63.6},{62.6,78},{62.8,63},{62.8,63.6},{63.2,62.2},{63.6,62.8},{65,41.2},{65.2,41.6},{65.6,42.8},{65.8,41.2},{65.8,42.2},{66.8,81.4},{67,82.2},{67,82.6},{68.8,74.6},{69.4,76.2},{70,75.4},{70,76.2},{70.4,63.4},{70.4,63.8},{70.6,63.2},{70.6,63.6},{71,76},{73.4,41.2},{73.8,40.4},{74,41},{77.4,39.4},{77.4,40},{77.6,39.4},{77.6,39.8},{78.4,75.2},{79,79.6},{79.4,64.2},{79.4,64.6},{79.4,65.6},{79.4,78.4},{79.4,78.8},{79.6,64.2},{79.6,79},{79.6,80.2},{79.8,64.6},{80,65.8},{80.4,50.2},{80.4,50.6},{80.6,50.4},{80.6,50.6},{80.8,49.4},{82.4,70},{82.4,71},{82.4,86},{82.4,86.8},{82.6,71.6},{82.6,86.2},{82.8,70.6},{83,70.4},{83.2,83.6},{83.4,83.4},{83.4,86.8},{83.8,84.6},{84,83.4},{84,83.6},{85.4,65.4},{85.4,66},{85.8,65.2},{85.8,67.2},{86,66.2},{86.6,65.6},{87,81.8},{87.2,82.6},{87.6,82.2},{90.2,77.2},{90.4,77.6},{90.6,77},{90.6,77.8},{90.8,76.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202116] = {
            [npcKeys.name] = "Cut-throat Mugger",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{57.4,28.8},{61.4,29.2},{61.8,29.2},{62.8,29},{63.2,29.6}},
                [1537] = {{44,11},{47.4,12.6},{49.2,12.6},{50.4,11.6},{51.2,12.6},{51.4,10.6},{51.4,11.8},{51.8,12.4},{51.8,12.6},{51.8,13.6},{52,10.6},{52.6,9.6},{52.8,9}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202387] = {
            [npcKeys.name] = "Eye of the Void",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202390] = {
            [npcKeys.name] = "Homunculus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202391] = {
            [npcKeys.name] = "Homunculus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{34.2,57.8},{35,58},{49.8,33.8},{49.8,35.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202392] = {
            [npcKeys.name] = "Homunculus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202699] = {
            [npcKeys.name] = "Baron Aquanis",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202838] = {
            [npcKeys.name] = "Fathom Elemental",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202839] = {
            [npcKeys.name] = "Riptide Elemental",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202840] = {
            [npcKeys.name] = "Torrent Elemental",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203079] = {
            [npcKeys.name] = "Wandering Swordsman",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{53.4,47.4},{53.4,47.8},{53.6,47.4},{53.6,47.6}},
                [12] = {{22.2,73.4},{22.4,73.6},{22.6,73.2},{25.2,70},{25.6,70},{30,73},{36,80.4},{36,80.6},{38.4,75.4},{38.4,75.6},{38.6,75.4},{38.6,75.6},{40.8,74.6},{41,74.4}},
                [14] = {{36,48},{41,49.4},{41,49.6},{56,38.2},{56.4,27},{56.6,21.4},{56.6,21.6}},
                [85] = {{79.4,64.4},{79.4,64.8},{79.6,65.2}},
                [141] = {{39.6,37.6},{39.8,37.4},{39.8,69.4},{39.8,69.6},{43.8,76.8},{54.8,66},{62.6,71.8}},
                [215] = {{38,55},{40.6,53.2},{45.4,36.4},{45.6,36.4},{52,39.2},{60.2,67.4},{60.2,67.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203138] = {
            [npcKeys.name] = "Anvilrage Overseer",
            [npcKeys.minLevel] = 48,
            [npcKeys.maxLevel] = 49,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203139] = {
            [npcKeys.name] = "Son of Arugal",
            [npcKeys.minLevel] = 24,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{35,16.8},{35.2,16.2},{35.4,18.4},{35.4,19.2},{35.4,19.8},{35.6,15.8},{35.6,18.8},{36,18},{36.2,19.8},{36.2,22.2},{36.2,28.6},{36.4,15.2},{36.4,16.6},{36.4,20.6},{36.4,24.8},{36.6,20.2},{36.8,21.2},{36.8,27.8},{37,14.8},{37,16},{37,16.8},{37,26.6},{37.4,24},{37.4,25.2},{37.6,15.8},{37.6,24.6},{37.8,25.8},{38,14.2},{38,24},{38,28},{38.2,16.8},{38.2,21},{38.4,15.2},{38.6,17.8},{38.8,14.8},{38.8,27.2},{38.8,31.6},{39,17.2},{39,28},{39.2,14.2},{39.2,16.4},{39.2,26},{39.4,29.8},{39.6,25},{39.6,25.6},{39.8,15.4},{39.8,27},{39.8,30},{40,16.4},{40,18.4},{40,28.2},{40.2,30.8},{40.4,16.6},{40.4,29.2},{40.6,18.4},{40.6,30},{40.8,17.2},{41,19.4},{41,19.6},{41.2,29.4},{41.2,30.8},{41.6,17.2},{41.6,18.2},{41.6,21.6},{41.8,20},{41.8,29.8},{42,30.6},{42.2,20.8},{42.4,18.8},{42.6,21.4},{42.6,28.6},{43,20.4},{43,22},{43.2,28.2},{43.4,19},{43.4,30.4},{43.6,19},{43.6,21.4},{43.6,21.8},{43.6,28},{43.6,29.6},{43.6,79.6},{44.2,29.2},{44.2,77},{44.2,78.4},{44.4,16},{44.4,18.2},{44.4,19.8},{44.4,31.8},{44.6,29.2},{44.6,79.6},{44.8,17.8},{44.8,20.8},{45,29.8},{45,68},{45,81.6},{45.2,17},{45.2,81.2},{45.4,19},{45.4,27},{45.4,28.2},{45.4,33.2},{45.4,34.2},{45.4,76.2},{45.4,79.2},{45.4,83.2},{45.6,16.8},{45.6,29.2},{45.6,41.6},{45.6,82},{45.6,83.4},{45.6,84.6},{45.8,21.4},{45.8,29.8},{46,17.6},{46,27.4},{46,28.2},{46,79},{46,83.6},{46.2,18.8},{46.2,33.4},{46.4,26.2},{46.4,32.2},{46.4,33.6},{46.6,18},{46.6,19.4},{46.6,25.2},{46.6,81.2},{46.6,83.6},{46.8,17.4},{46.8,76},{47,26.8},{47,83.4},{47.2,19.8},{47.2,32.2},{47.2,82.4},{47.4,20.8},{47.4,26.2},{47.4,33},{47.4,33.8},{47.4,34.6},{47.6,17},{47.6,33.2},{47.8,19},{47.8,31.4},{47.8,34.2},{47.8,34.6},{47.8,81.6},{47.8,83.4},{48,19.6},{48,21.8},{48,32.2},{48,83.8},{48,84.6},{48.2,26},{48.2,38.4},{48.2,77.2},{48.4,20.8},{48.4,25.4},{48.4,75.2},{48.4,79.4},{48.6,20},{48.6,31.6},{48.6,33.8},{48.6,34.8},{48.8,26.6},{48.8,31},{48.8,32.8},{48.8,38.8},{48.8,72.4},{48.8,75.6},{48.8,82.2},{48.8,82.6},{49,18.8},{49,26.2},{49.2,20.8},{49.2,22.6},{49.2,24.2},{49.2,25.4},{49.2,37},{49.2,80},{49.4,36.4},{49.4,84},{49.6,23.4},{49.6,26.4},{49.6,29.6},{49.6,33.4},{49.6,82.4},{49.6,83.6},{49.8,17.2},{49.8,33.6},{49.8,76.4},{49.8,83.2},{50,25},{50.2,74.2},{50.2,74.8},{50.2,79},{50.2,81},{50.4,36.6},{50.6,34.8},{50.6,35.8},{50.6,74},{50.8,75},{50.8,79.2},{51,78.4},{51.4,36.8},{51.6,73},{51.6,77.6},{52,37.8},{52,72},{52,73.6},{52,75.4},{52.2,77.4},{52.4,76.2},{52.6,76.2},{52.8,74.2},{52.8,74.8},{53.4,72.4},{53.4,76.6},{53.6,75.8},{54,74.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203147] = {
            [npcKeys.name] = "Whirlpool",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203218] = {
            [npcKeys.name] = "Giant Whirlpool",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203226] = {
            [npcKeys.name] = "Viktoria Woods",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{69.4,50},{69.6,50.6},{69.8,50}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203279] = {
            [npcKeys.name] = "Riptide Essence",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203475] = {
            [npcKeys.name] = "Liv Bradford",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{22.4,64.4},{22.4,64.6},{22.6,64.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203478] = {
            [npcKeys.name] = "Stuart",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{21.4,61.8},{21.4,62.8},{21.6,62.8},{21.8,62.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203694] = {
            [npcKeys.name] = "Riding Lobster (Dead)",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204068] = {
            [npcKeys.name] = "Lady Sarevess",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204070] = {
            [npcKeys.name] = "Soboz",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{42.2,35.4},{42.2,35.6}},
                [14] = {{67.4,87.8},{67.6,87.8}},
                [1497] = {{24,41.4},{24,41.6}},
                [1519] = {{25,77.4},{25,77.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204091] = {
            [npcKeys.name] = "Blackfathom Elite",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204253] = {
            [npcKeys.name] = "Blackfathom Elite Spawner",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204256] = {
            [npcKeys.name] = "Damien Kane",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{44,66.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204346] = {
            [npcKeys.name] = "Treant",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204503] = {
            [npcKeys.name] = "Dead Acolyte",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{56.4,57.4},{56.4,57.8},{56.6,57.4},{56.6,57.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204545] = {
            [npcKeys.name] = "Tim's Stalker 01",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204645] = {
            [npcKeys.name] = "Blackfathom Elite",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204675] = {
            [npcKeys.name] = "Rune Scrying Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204758] = {
            [npcKeys.name] = "Exploded Corpse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204827] = {
            [npcKeys.name] = "Adventurer's Remains",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{43,49.4},{43,49.6}},
                [12] = {{52.2,84.4},{52.2,84.6}},
                [14] = {{48,79.4},{48,79.6}},
                [141] = {{33.6,35.6}},
                [215] = {{60.4,33.4},{60.4,33.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204921] = {
            [npcKeys.name] = "Gelihast",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204937] = {
            [npcKeys.name] = "Adventurer's Spirit",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{43,49.6}},
                [12] = {{52.2,84.4},{52.2,84.6}},
                [14] = {{48,79.4},{48,79.6}},
                [141] = {{33.4,35.6},{33.6,35.6}},
                [215] = {{60.4,33.4},{60.4,33.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204940] = {
            [npcKeys.name] = "Puddle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204960] = {
            [npcKeys.name] = "Chomp",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204961] = {
            [npcKeys.name] = "Snarly",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204962] = {
            [npcKeys.name] = "Tidelurker Mrrglrlr",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204989] = {
            [npcKeys.name] = "Wounded Adventurer",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{61.8,47},{61.8,47.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205153] = {
            [npcKeys.name] = "Ada Gelhardt",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{4.2,28.6},{4.4,28.2},{4.6,28.2},{4.6,28.6}},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205278] = {
            [npcKeys.name] = "Brother Romulus",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{38.2,28.2},{38.4,29},{38.6,27.4},{38.6,28.4},{38.6,28.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205382] = {
            [npcKeys.name] = "Mokwa",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{35.2,57.2},{35.2,57.6},{35.6,57.6},{35.8,57.2},{36,56.2},{36.6,56.6},{37.8,55.6},{37.8,56.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205383] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205422] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205423] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205635] = {
            [npcKeys.name] = "Takoda Sunmane",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{46.2,60.2},{46.2,60.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205692] = {
            [npcKeys.name] = "Rustling Bush",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{58.8,54.2},{59,54.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205700] = {
            [npcKeys.name] = "Venture Co. Poacher",
            [npcKeys.minLevel] = 6,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{58.2,54},{58.8,54.2},{59,54.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205724] = {
            [npcKeys.name] = "Blackfathom Tendril",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205729] = {
            [npcKeys.name] = "Boarton Shadetotem",
            [npcKeys.minLevel] = 4,
            [npcKeys.maxLevel] = 4,
            [npcKeys.zoneID] = 1638,
            [npcKeys.spawns] = {
                [1638] = {{39.4,64.4},{39.4,65.2},{39.4,65.6},{39.6,64.4},{39.6,65.4},{39.6,65.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {76156,76160,76240},
            [npcKeys.questEnds] = {76156,76160,76240},
        },
        [205733] = {
            [npcKeys.name] = "Blackfathom Pearl",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205765] = {
            [npcKeys.name] = "Murloc Egg",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205767] = {
            [npcKeys.name] = "Void Murloc",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205805] = {
            [npcKeys.name] = "Water Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [206152] = {
            [npcKeys.name] = "SoD Test Dummy 25",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [206153] = {
            [npcKeys.name] = "SoD Test Dummy 26",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [206154] = {
            [npcKeys.name] = "SoD Test Dummy 27",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [206155] = {
            [npcKeys.name] = "SoD Test Dummy 28",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [206217] = {
            [npcKeys.name] = "Bubble Beam Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [206245] = {
            [npcKeys.name] = "Unleashed Nature Spirit",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{67,58},{67,58.6}},
                [215] = {{37.6,49.6},{37.8,49.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [206248] = {
            [npcKeys.name] = "Wooden Effigy",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{67,58.2}},
                [215] = {{37.4,49.4},{37.4,49.6},{37.8,49.4},{37.8,49.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207010] = {
            [npcKeys.name] = "Telemachus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207356] = {
            [npcKeys.name] = "Lorgus Jett",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207358] = {
            [npcKeys.name] = "Blackfathom Tide Priestess",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207359] = {
            [npcKeys.name] = "Blackfathom Tide Priestess",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207367] = {
            [npcKeys.name] = "Blackfathom Tide Priestess",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207397] = {
            [npcKeys.name] = "Corrupted Windfury Totem",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207457] = {
            [npcKeys.name] = "Corrupted Lightning Shield Totem",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207515] = {
            [npcKeys.name] = "Lurkmane",
            [npcKeys.minLevel] = 6,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{30.4,61.4},{30.4,61.8},{30.6,63},{30.8,61.4},{30.8,61.6},{31,60.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207520] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207527] = {
            [npcKeys.name] = "Corrupted Molten Fury",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207576] = {
            [npcKeys.name] = "Corrupted Molten Fury Totem",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207577] = {
            [npcKeys.name] = "Lunar Stone",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{35,69.4},{35,69.6},{35.4,68.2},{35.4,70.6},{35.6,70.4},{35.6,70.6},{35.8,68}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207588] = {
            [npcKeys.name] = "Mulgore Lunar Stone Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207637] = {
            [npcKeys.name] = "Vateya Timberhoof",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{46.2,61.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207743] = {
            [npcKeys.name] = "Netali Proudwind",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1638,
            [npcKeys.spawns] = {
                [1638] = {{28.4,18.2},{28.4,19.2},{28.6,18.2},{28.6,18.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207754] = {
            [npcKeys.name] = "Mooart",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1638,
            [npcKeys.spawns] = {
                [1638] = {{25.4,18},{26.4,18.4},{26.4,18.8},{26.4,19.8},{26.6,19},{26.6,19.8},{27,18.4},{27.2,14.4},{27.6,19},{28,21.4},{28.2,19.8},{28.4,22.4},{28.6,23.2},{29.4,21.6},{31.6,27.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207957] = {
            [npcKeys.name] = "Vahi Bonesplitter",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{53,43.4},{53,43.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208023] = {
            [npcKeys.name] = "Gru'ark",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{49.6,65},{52.6,57.4},{53.6,57.4},{54.8,57},{56.4,57.2},{56.4,58},{57,44.6},{57,56},{57,57.8},{57.6,45.8},{57.6,57},{57.8,55.6},{58,48.4},{58,55.2},{58.2,49.4},{58.2,51.2},{58.2,54.4},{58.4,50.2},{58.4,52},{58.4,52.6},{58.6,51.4},{58.6,51.8},{58.8,53.4},{58.8,53.6},{59.2,56.6},{61.4,44.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208036] = {
            [npcKeys.name] = "Ba'so",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{51.8,58.6},{52,58.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208071] = {
            [npcKeys.name] = "Back-alley Mugger",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{55.8,44.6},{56,44},{56.2,42.8},{56.6,44.2},{57.4,45.2},{58.8,50.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208124] = {
            [npcKeys.name] = "Raluk",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{67.6,73},{67.8,68.8},{68.2,70.4},{68.4,71.4},{68.4,71.6},{68.4,74.2},{68.6,71.4},{68.6,71.6},{68.6,73},{71,72}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208127] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208128] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208158] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208179] = {
            [npcKeys.name] = "Rustling Bush",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{40.4,52},{40.6,52}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208180] = {
            [npcKeys.name] = "Razormane Poacher",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{28.8,49.8},{29,49.4}},
                [14] = {{40.4,52},{40.6,52}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208184] = {
            [npcKeys.name] = "Razzil",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{52.2,44}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208196] = {
            [npcKeys.name] = "Gillgar",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{25.2,49},{25.4,47.4},{25.4,48.2},{25.6,48.2},{25.6,48.6},{26.2,47},{26.4,46.4},{26.6,46.8},{27.2,46.4},{28,46.4},{28.4,46.8},{29,46.6},{29.6,46.6},{29.8,46},{30.4,49.4},{31,48}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208226] = {
            [npcKeys.name] = "Darmak Bloodhowl",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{54.6,41.4},{54.6,41.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208275] = {
            [npcKeys.name] = "Frozen Makrura",
            [npcKeys.minLevel] = 9,
            [npcKeys.maxLevel] = 9,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{58.6,45.4},{58.6,45.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208307] = {
            [npcKeys.name] = "Serpent Loa",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{55.4,72.4},{55.4,72.6}},
                [17] = {{51.4,29.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208309] = {
            [npcKeys.name] = "Loa Altar",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{55.2,72.6},{55.4,72.4}},
                [17] = {{51.4,29.4},{51.6,29.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208518] = {
            [npcKeys.name] = "Gaeriyan",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{54,23.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {3913},
            [npcKeys.questEnds] = {3912},
        },
        [208546] = {
            [npcKeys.name] = "Brazier of Embersight",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208565] = {
            [npcKeys.name] = "Altar of the Light",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{28.8,66.4},{28.8,66.6}},
                [38] = {{37.4,46.2}},
                [40] = {{52.8,52.8}},
                [1537] = {{31.2,21.4},{31.4,21.6},{31.8,22},{32,20.4},{32,20.6},{32.6,21.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208619] = {
            [npcKeys.name] = "Dorac Graves",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{47.2,70.4},{47.2,71.2},{48,70},{48,70.6},{48.2,71.6},{48.4,69.4},{48.6,69.2},{48.6,69.8},{48.6,70.8},{48.6,71.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208638] = {
            [npcKeys.name] = "Fyodi",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{27.8,38.2},{28.4,38.6},{28.4,42.8},{28.4,43.6},{28.4,44.8},{28.6,43.8},{28.8,39.6},{28.8,44.8},{29.2,38.4},{29.2,38.8},{29.2,43.4},{29.4,42.2},{29.6,38.4},{29.6,42.2},{29.6,42.8},{29.6,45.6},{29.8,39},{30.2,43.6},{30.4,36.6},{30.4,40.2},{30.4,41.2},{30.6,37.4},{30.6,42.4},{31,39.2},{31,39.6},{31.4,38.4},{31.6,39},{31.6,40},{32.2,36},{32.2,38},{32.4,37.2},{32.6,36.8},{33,36.4},{33.4,33.4},{33.4,34},{33.4,35.2},{33.4,37.6},{33.6,34.4},{33.6,35.4},{33.6,36},{33.6,37.8},{33.8,36.6},{35,33},{35.2,34.2},{35.2,36.4},{35.2,36.6},{35.4,34.6},{35.4,38},{35.6,33.2},{35.8,33.8},{35.8,37},{36,36.4},{36.6,36},{36.6,36.6},{37.6,35.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208652] = {
            [npcKeys.name] = "Junni Steelpass",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{46.4,53.2},{46.6,53.4},{46.6,53.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208682] = {
            [npcKeys.name] = "Denton Bleakway",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{83.2,26.6},{83.2,27.6},{83.4,25.4},{83.4,26},{83.6,24.8},{83.6,25.8},{83.6,27.4},{83.6,27.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208711] = {
            [npcKeys.name] = "Toby",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{63.4,50.2},{63.6,50.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208712] = {
            [npcKeys.name] = "Odd Melon",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{30.2,47.2},{33.4,49.4},{33.4,49.8},{33.6,49.4},{33.6,49.6},{34.8,51.2},{35.4,49},{35.6,49},{36.4,50.8},{36.8,51},{40.2,42},{44,38.6},{44.2,38.4},{44.8,28.4},{44.8,28.6},{45.2,33.4},{47.2,50.4},{47.2,50.8},{47.4,28.4},{47.4,28.6},{49.4,46.2},{49.4,46.8},{49.6,46.4},{49.6,46.6},{49.8,59.4},{50,59.6},{50.2,50.4},{50.2,50.8},{50.4,31},{50.4,61.8},{50.6,31},{51.4,57.2},{51.6,57.2},{51.6,57.6},{52.2,30.2},{52.6,30},{52.8,57.6},{53.8,56.8},{53.8,58.6},{53.8,59.8},{54,28},{54,56.4},{54,58.2},{57.4,40.4},{57.4,40.6},{57.6,40.2},{58.2,35.4},{58.4,35.6},{58.6,35.2},{58.8,58.4},{58.8,58.6},{59.8,33},{60,37},{65.4,62.8},{65.6,62.8},{71.4,34.2},{72,50.8},{72.2,50.4},{75,61.4},{75.2,61.6},{76,59.4},{76,59.6},{76.2,51.4},{76.2,51.8},{76.4,61.4},{76.4,61.6},{76.6,61.4},{76.6,61.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208752] = {
            [npcKeys.name] = "Frozen Trogg",
            [npcKeys.minLevel] = 9,
            [npcKeys.maxLevel] = 9,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{69.2,58.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208758] = {
            [npcKeys.name] = "Junior Apothecary",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208802] = {
            [npcKeys.name] = "Wounded Adventurer",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{25.4,43.4},{25.4,43.6},{25.6,43.4},{25.6,43.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208809] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208810] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208811] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208812] = {
            [npcKeys.name] = "Jorul",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{35.4,43.6},{35.8,42.6},{36,42.4},{36.4,38.8},{36.4,40.4},{36.6,40.4},{37,41},{37.2,42.4},{37.4,42.6},{37.6,41.4},{37.8,42.4},{38,38.6},{38.4,43.4},{38.4,43.6},{38.6,42},{38.6,43.4},{38.6,43.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208841] = {
            [npcKeys.name] = "Revered Champion",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{38,33.2},{39.2,27.4},{39.4,28},{39.4,28.6},{39.6,28.2},{39.6,28.6},{40.2,30.6},{40.6,29.8},{41,31.4},{42.4,32.4}},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208842] = {
            [npcKeys.name] = "The Gardener",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208843] = {
            [npcKeys.name] = "Abominable Snowman",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208844] = {
            [npcKeys.name] = "Scarlet Revenant",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208845] = {
            [npcKeys.name] = "Par'kourc",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 44,
            [npcKeys.spawns] = {
                [44] = {{65.8,58.8},{66,57.2},{66,58}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208846] = {
            [npcKeys.name] = "Sun Admirer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{30.4,74},{30.6,73.8},{40.2,28.4},{47.2,66.4},{52.6,45}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208847] = {
            [npcKeys.name] = "The Snatcher",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{40.4,70.8},{41,71.2},{41.2,68.8},{45.4,68},{45.4,68.8},{45.6,68.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208875] = {
            [npcKeys.name] = "Back-alley Mugger",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{55.8,44.6},{56,43.8},{56.2,42.8},{57,44.2},{57,45.6},{57.4,45.2},{58.4,49.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208876] = {
            [npcKeys.name] = "Cut-throat Mugger",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{59,27.8},{61.4,29.4},{61.4,29.6},{61.8,29.2},{62.4,29.6},{62.8,29.6},{63.2,29.2}},
                [1537] = {{50.2,11.6},{50.6,10.2},{51,12.2},{51.4,11},{51.8,11.4},{51.8,12.4},{52,12.6},{52.6,11.2},{52.8,9.2},{52.8,10.4},{57,12}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208886] = {
            [npcKeys.name] = "Blackrat",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{57.2,45.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208919] = {
            [npcKeys.name] = "Blueheart",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{61.6,51.4},{61.8,51.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208920] = {
            [npcKeys.name] = "Penny Hawkins",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{61.8,52}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208927] = {
            [npcKeys.name] = "Dead Acolyte",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{76.4,44.8},{76.6,44.8}},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208974] = {
            [npcKeys.name] = "Dark Iron Poacher",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208975] = {
            [npcKeys.name] = "Rustling Bush",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{28.8,49.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209002] = {
            [npcKeys.name] = "Gaklik Voidtwist",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{47.2,53.4},{47.2,53.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209004] = {
            [npcKeys.name] = "Bruart",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1537,
            [npcKeys.spawns] = {
                [1537] = {{71.2,73.2},{72,73.4},{72,75.2},{72.2,74}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209209] = {
            [npcKeys.name] = "Blackfathom Elite",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209213] = {
            [npcKeys.name] = "Murloc Spawner",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209214] = {
            [npcKeys.name] = "Blackfathom Murloc",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209511] = {
            [npcKeys.name] = "Oasis Snapjaw Hatchling",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{48.2,40.2},{55.8,42.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209524] = {
            [npcKeys.name] = "Patrolling Cheetah",
            [npcKeys.minLevel] = 18,
            [npcKeys.maxLevel] = 18,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{43.2,56.6},{43.4,56.4},{43.6,56.6},{44.2,55.8},{44.4,55.4},{44.6,55.2},{44.6,55.6},{44.6,56.8},{50.2,44.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209548] = {
            [npcKeys.name] = "Secret Agent",
            [npcKeys.minLevel] = 77,
            [npcKeys.maxLevel] = 77,
            [npcKeys.zoneID] = 8,
            [npcKeys.spawns] = {
                [8] = {{95,84.2}},
                [17] = {{50.4,79.6}},
                [40] = {{53.4,39.8},{53.4,40.6},{53.6,40.2}},
                [45] = {{25,20}},
                [46] = {{36,22.2}},
                [85] = {{53.4,57.4},{53.6,57},{53.6,58}},
                [139] = {{30,27}},
                [267] = {{88.2,47.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209607] = {
            [npcKeys.name] = "Lieutenant Stonebrew",
            [npcKeys.minLevel] = 17,
            [npcKeys.maxLevel] = 17,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{62.4,56.2},{62.6,56.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209608] = {
            [npcKeys.name] = "Delwynna",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{63.2,22.6},{63.4,21.4},{63.4,22},{63.6,22},{64,21.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209678] = {
            [npcKeys.name] = "Twilight Lord Kelris",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209742] = {
            [npcKeys.name] = "Desert Mirage",
            [npcKeys.minLevel] = 15,
            [npcKeys.maxLevel] = 15,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{54.4,36},{54.6,36.6},{54.8,35.8},{55,35.4},{55.4,33.4},{55.4,33.8},{55.8,34},{56,34.6},{57.4,35.8},{57.4,38.4},{57.4,38.6},{57.6,35.4},{57.6,35.8},{57.6,38.4},{57.6,38.6},{58.8,37.4},{58.8,37.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209758] = {
            [npcKeys.name] = "Invading Nightmare",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209773] = {
            [npcKeys.name] = "Dream Copy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209797] = {
            [npcKeys.name] = "Bruuz",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{63.2,38.6},{63.6,38.4},{64.4,39},{64.4,39.6},{64.8,39.8},{65,37.2},{65.2,39.4},{65.4,41.4},{66.4,39.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209806] = {
            [npcKeys.name] = "Waterfall Test",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209811] = {
            [npcKeys.name] = "Rustling Bush",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{46.4,46.2},{46.6,46.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209812] = {
            [npcKeys.name] = "Fallenroot Poacher",
            [npcKeys.minLevel] = 9,
            [npcKeys.maxLevel] = 9,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{43.2,42.6},{45.2,46.4},{45.2,47.2},{45.4,47.6},{45.4,49.4},{45.4,49.6},{46,47.8},{46,49.6},{46.2,45.4},{46.2,46.6},{46.4,44.2},{46.4,46.2},{46.4,48.8},{46.6,45.4},{46.6,46.2},{46.6,46.6},{46.8,43.6},{47,49.6},{47.4,49.4},{47.6,44.4},{47.6,50.2},{48,50.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209815] = {
            [npcKeys.name] = "Phantasmal Priestess",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209830] = {
            [npcKeys.name] = "Phantasmal Statue",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209872] = {
            [npcKeys.name] = "Syllart",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{56.2,59.4},{56.2,59.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209889] = {
            [npcKeys.name] = "Barebones",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{56,60.4},{56,61.6},{56.2,60.8},{56.6,61.2}},
                [1637] = {{51.6,76.8},{51.8,75.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209908] = {
            [npcKeys.name] = "Heretic Idol",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 38,
            [npcKeys.spawns] = {
                [38] = {{71.4,27.2},{71.8,27},{71.8,27.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209928] = {
            [npcKeys.name] = "Mowgh",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{46.4,32.6},{46.4,33.8},{47.2,32.6},{47.4,32.4},{47.4,33.6},{47.6,32.6},{48,31.6},{48.2,31.4},{48.6,31.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209939] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209940] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209941] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209948] = {
            [npcKeys.name] = "Relaeron",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{39.2,9},{39.4,9.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209949] = {
            [npcKeys.name] = "Sickly Deer",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{39.2,8.4},{39.2,9},{39.4,9.8},{39.6,9},{39.6,9.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209954] = {
            [npcKeys.name] = "Demonic Remains",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 38,
            [npcKeys.spawns] = {
                [38] = {{72.4,68.4},{72.4,68.6},{72.6,68.4},{72.6,68.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209958] = {
            [npcKeys.name] = "Graix",
            [npcKeys.minLevel] = 18,
            [npcKeys.maxLevel] = 18,
            [npcKeys.zoneID] = 38,
            [npcKeys.spawns] = {
                [38] = {{71.2,68.2},{72.4,68.4},{72.4,68.8},{72.6,67.8},{72.6,68.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210006] = {
            [npcKeys.name] = "Battle Totem",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210107] = {
            [npcKeys.name] = "Kackle",
            [npcKeys.minLevel] = 15,
            [npcKeys.maxLevel] = 16,
            [npcKeys.zoneID] = 38,
            [npcKeys.spawns] = {
                [38] = {{49.8,60.4},{50.2,53.8},{52.2,55.4},{52.4,54.4},{52.4,55.8},{53,56.4},{53.2,54.4},{53.2,56.6},{53.4,53.4},{53.4,55.4},{54,55.8},{54.2,53.2},{54.2,54},{54.2,55.2},{54.4,56.6},{54.6,52.2},{54.6,55.6},{54.8,54.2},{54.8,54.6},{54.8,56.6},{55,52.6},{55.6,52.2},{55.6,54.4},{55.6,57},{55.8,53.2},{55.8,54.6},{55.8,57.6},{56.4,55.6},{57.2,64.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210451] = {
            [npcKeys.name] = "Lady Sedorax",
            [npcKeys.minLevel] = 18,
            [npcKeys.maxLevel] = 18,
            [npcKeys.zoneID] = 148,
            [npcKeys.spawns] = {
                [148] = {{54.8,31.6},{55,32.6},{55.2,33.8},{55.2,35.2},{55.4,36.4},{55.4,36.8},{55.6,35.2},{55.6,36.4},{55.6,36.6},{55.8,34.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210482] = {
            [npcKeys.name] = "Paxnozz",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 148,
            [npcKeys.spawns] = {
                [148] = {{46.4,14.4},{46.4,14.6},{46.4,17},{46.6,17},{47,15.4},{47,15.6},{47.4,14},{48,13.4},{48,14},{48,15.2},{48,18},{48.2,17.2},{48.4,15.8},{48.6,13.8},{48.6,16.6},{48.8,14.8},{48.8,15.6},{49,11.8},{49,13.2},{49.6,14.2},{50,14.6},{50.2,12.6},{50.4,11.4},{50.4,12},{50.8,12.4},{51,13.6},{51.2,13.4},{51.8,13.2},{52.2,16.2},{52.4,17.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210483] = {
            [npcKeys.name] = "Aggressive Squashling",
            [npcKeys.minLevel] = 16,
            [npcKeys.maxLevel] = 16,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{36.6,48.8},{36.6,52.8},{38,48.2},{38.2,52.2},{39.2,55.2},{42.2,35.8},{43.2,34.2},{43.2,35.2},{43.6,33.8},{43.8,33.4},{43.8,38},{44.2,32.4},{44.8,31.8},{48.2,22},{48.8,22},{49,22.6},{50.2,24},{50.4,19.8},{50.4,22.4},{50.6,18.8},{50.6,22},{50.8,21.4},{51,18.4},{51,19.6},{51.4,24.8},{51.4,26},{52.4,30.4},{54.8,35.6},{57.8,16.6},{62.8,63}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210487] = {
            [npcKeys.name] = "Horror of the Deep",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{25,69.4},{25.2,65.6},{26,69.4},{26,69.6},{26.2,66.6},{26.2,68},{26.4,66},{26.8,66.2},{26.8,68},{26.8,69},{26.8,69.8},{27.6,70.4},{28.8,70.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210501] = {
            [npcKeys.name] = "Harvest Reaper Prototype",
            [npcKeys.minLevel] = 18,
            [npcKeys.maxLevel] = 18,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{34.4,52.6},{35.2,51.4},{35.4,51.6},{35.6,51.4},{35.6,52.2},{44.4,39.2},{45.2,39.6},{45.4,38.8},{45.4,40.8},{45.6,39},{48.2,29.8},{49.6,36.6},{50,18.8},{50.2,17.4},{50.2,18.4},{50.6,17.2},{50.6,18.4},{50.6,19},{50.8,20.4},{51.4,33.4},{51.4,33.6},{51.8,34},{52,33},{52.2,32.4},{52.8,33},{52.8,33.8},{58.8,54},{60.2,56.8},{61.2,57.4},{61.2,58.2},{61.4,58.8},{61.6,58.4},{61.6,58.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210528] = {
            [npcKeys.name] = "Terrified Soul",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210533] = {
            [npcKeys.name] = "Silverspur",
            [npcKeys.minLevel] = 14,
            [npcKeys.maxLevel] = 14,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{33.6,40.8},{34.4,37.2},{34.8,38.6},{35,38.4},{35,39.6},{35.6,38.4},{36,38.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210537] = {
            [npcKeys.name] = "Undying Laborer",
            [npcKeys.minLevel] = 14,
            [npcKeys.maxLevel] = 15,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{18,70.2},{20.4,77},{20.4,80},{20.6,79.8},{21.4,79},{21.8,78.8},{22.4,78.2},{22.6,77.4},{23,78.4},{23.4,78.6},{23.6,77.6},{24,75.6},{24.2,74.6},{24.2,76.6},{24.4,78.8},{25.2,75.6},{25.4,78.2},{25.8,76},{26.4,77.8},{26.6,75},{26.6,77.4},{27,75.8},{27.2,77.8},{27.6,77},{28,76},{28.2,77.8},{28.4,75.2},{28.6,77.8},{29.6,77.2},{29.6,77.8},{29.8,63.4},{30.6,76.6},{31,53.8},{31,76},{31.4,75.2},{31.4,78.4},{31.6,68.8},{31.6,78.4},{31.8,52.4},{31.8,74.6},{32,74},{32.2,50.8},{32.2,53.6},{32.2,73.4},{32.2,78.6},{32.4,50.2},{32.4,54.6},{32.8,51},{32.8,72.4},{32.8,72.8},{33,65.8},{33,78.2},{33.2,52.2},{33.2,54},{33.2,59},{33.4,52.6},{33.4,56},{33.4,57.2},{33.4,58},{33.4,64},{33.4,65},{33.4,71.4},{33.6,58},{33.6,60.8},{33.6,63.4},{33.8,53.4},{33.8,59},{33.8,66.8},{33.8,69},{33.8,77.6},{34,59.6},{34,65.6},{34,69.6},{34,70.6},{34.2,61.8},{34.2,64.8},{34.2,68.2},{34.2,71.6},{34.4,63.6},{34.4,72.6},{34.6,61.8},{34.6,76.8},{34.8,53.4},{34.8,70.2},{35,63.6},{35,68.8},{35,73.8},{35.2,68.2},{35.4,55.2},{35.4,76.2},{35.6,65.2},{35.8,53.4},{35.8,65.6},{36,67},{36.2,55.4},{36.2,57.6},{36.6,62.2},{36.8,53.4},{36.8,59.8},{37.2,58},{37.6,54.2},{40.2,64.4},{41,69.2},{42,69.2}},
                [40] = {{27.4,35.6},{28.2,37.8},{29,50.6},{29.2,41.4},{29.2,49.4},{29.2,50},{29.4,46.4},{29.4,46.6},{29.6,50.6},{29.8,46},{29.8,46.6},{29.8,49.8},{30.2,47.8},{30.4,42.6},{30.4,45.4},{30.4,49},{30.6,45.8},{30.6,48.2},{30.6,48.8},{31,43.2},{31.2,42.4},{31.2,44.8},{31.4,43.6},{31.6,44.6},{31.8,43.4},{31.8,43.6},{32.2,42.4},{33.4,43.2},{33.8,43},{34.4,43.8},{34.8,43.2},{35,43.8},{35.2,40.8},{35.4,42},{35.8,37.6},{36.2,44},{36.4,34.4},{36.4,40.6},{36.6,40.6},{36.8,39.2},{36.8,43.2},{37,31.4},{37,43.6},{37.4,28},{37.4,42.4},{37.6,37},{37.8,40},{37.8,45.4},{38.2,39.4},{38.6,24.8},{38.6,40.4},{38.8,35.6},{39.2,37.6},{39.4,35.2},{39.4,37.2},{39.6,22.6},{40,36.2},{40.8,33},{40.8,33.8},{40.8,37.4},{41,20.2},{41,34.8},{41.4,19},{41.4,31.2},{41.4,31.8},{41.8,30.6},{41.8,34.2},{42,17.8},{42,23.4},{42,30.4},{42.2,32.4},{42.6,29.8},{42.8,44.4},{43,16.6},{43.2,29.2},{43.2,31.4},{43.2,32.8},{43.2,34.6},{43.4,26.8},{43.8,25.2},{43.8,31.6},{44,23.4},{44,29.6},{44.4,21.2},{44.4,24},{44.4,25.6},{44.4,27},{44.4,29.4},{44.6,19.4},{44.6,19.6},{44.6,23.8},{44.6,24.8},{44.6,28},{44.8,26.2},{44.8,26.6},{44.8,29},{45,23},{45.2,15.8},{45.2,31.2},{45.4,18.2},{45.4,21.2},{45.4,21.6},{45.4,32.2},{45.6,20.4},{45.6,21.4},{45.6,21.6},{45.6,30.8},{45.8,27.4},{45.8,36.4},{46,18.4},{46.2,18.6},{46.2,26},{46.2,28.2},{46.6,19.2},{46.6,27.4},{46.8,28.8},{46.8,29.6},{47,30.6},{47.2,15},{47.2,51.8},{47.4,26.2},{47.4,27.6},{47.4,45},{47.6,28},{47.6,33.6},{47.6,40.2},{47.8,25},{47.8,26.4},{48,22},{48,30.4},{48.2,23.4},{48.2,28.6},{48.4,26.6},{48.6,24.6},{48.8,29},{49,17.8},{49,21.4},{49.2,26.8},{49.4,15},{49.4,28.4},{49.6,21.8},{49.6,29.2},{49.8,26.4},{50.2,19.6},{50.2,30.2},{50.4,27.4},{50.4,28.2},{50.6,28},{50.6,29.2},{51,27.4},{51.4,15.8},{51.4,21.2},{51.6,28.6},{52.2,24.2},{52.2,25.2},{52.2,27.2},{52.4,18.2},{52.4,26.4},{52.8,14},{53.4,17},{53.4,26},{53.4,27},{53.4,27.6},{53.8,26.6},{54,24},{54.4,28},{54.4,29.6},{54.4,47.4},{54.6,17},{54.6,25.6},{55,27.4},{55.2,31.4},{55.4,16.2},{55.4,25.4},{55.6,16.6},{55.8,18.8},{55.8,25.2},{55.8,25.8},{55.8,47.6},{56,31.2},{56,50},{56,50.6},{56,52},{56.2,47.4},{56.4,23.2},{56.4,44.2},{56.4,53.4},{56.6,54},{56.8,24.2},{56.8,47},{57.2,25},{57.4,21.8},{57.6,16},{57.6,23.2},{57.6,24},{58,21.4},{58,21.6},{58,26.6},{58,31.6},{58.4,37.6},{59.2,21.8},{59.4,13.4},{59.4,20},{59.6,16.4},{59.6,16.6},{59.6,20.8},{59.8,19.6},{60.4,8.6},{60.4,19.2},{60.6,8.8},{60.6,10.6},{60.6,11.6},{60.6,14.2},{60.6,18.8},{60.8,16},{60.8,20.6},{61.2,16.8},{61.2,18.4},{61.6,18},{61.8,19.4},{62.2,17.2}},
                [1519] = {{51.6,66.2},{52,58},{52,59.2},{52.2,57.2},{52.2,64.8},{53,60},{53.2,62.8},{53.2,63.6},{53.4,59.4},{54,64},{54.2,67},{54.4,58.8},{54.4,59.8},{54.4,62.6},{54.4,65.8},{54.6,59.4},{54.6,63.6},{54.8,60.8},{54.8,63.2},{54.8,65.4},{54.8,65.6},{55,62.2},{55,67.4},{55.2,59.6},{55.2,68},{55.6,59.8},{55.8,61.4},{55.8,62.6},{56,59.2},{56.2,58.4},{56.2,62.4},{56.2,64.8},{56.4,70.8},{56.6,60.6},{56.8,62},{56.8,62.6},{57,59.6},{57,63.6},{57.2,59.4},{57.4,57.8},{57.6,61.4},{57.6,63.4},{57.8,59},{58.2,64.4},{58.2,66.8},{58.4,58.2},{58.4,65},{58.4,66.4},{58.6,57.4},{58.6,58},{58.6,65.4},{58.8,52.4},{60,68.6},{60.2,60.4},{60.4,68},{61,61.4},{61.2,71},{61.2,75.8},{61.6,70.4},{61.6,71.4},{62,71.6},{62,77.2},{62.8,62.8},{63,63.8},{63.4,65.4},{63.8,75.8},{64,64.8},{64.4,77},{64.8,78.2},{65.2,63.8},{65.2,74.2},{65.4,73.2},{65.8,63.2},{65.8,79},{66.6,62.4},{66.6,80.2},{67.2,81.2},{67.2,82.6},{68,82.2},{68,82.8},{69,86.4},{69.4,85.2},{69.6,86.4},{69.6,87.4},{70.6,88},{70.6,89.2},{72.2,24.8},{77.2,18.2},{77.8,18.6},{78,18}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210549] = {
            [npcKeys.name] = "Defias Scout",
            [npcKeys.minLevel] = 14,
            [npcKeys.maxLevel] = 15,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{49.4,47.4},{50.2,48.2},{50.2,48.6},{50.4,47.4},{50.4,54.4},{50.4,54.8},{50.4,56.2},{50.6,47.6},{50.8,54.4},{51,47.2},{51,54.8},{51.4,55.6},{51.6,55.4},{51.6,55.6},{51.8,46.6},{52.2,54.2},{53.8,48.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210697] = {
            [npcKeys.name] = "Captain Namier",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{36.6,26.6},{37.4,27.6},{37.4,28.6},{37.8,28.4},{37.8,29},{38,29.6},{38.4,30.6},{38.8,29.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210750] = {
            [npcKeys.name] = "M'grrgl",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210802] = {
            [npcKeys.name] = "Webbed Victim",
            [npcKeys.minLevel] = 16,
            [npcKeys.maxLevel] = 16,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{35,7.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210845] = {
            [npcKeys.name] = "Jixo Madrocket",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 406,
            [npcKeys.spawns] = {
                [406] = {{59.2,62.4},{59.2,62.6},{60.6,62.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {78114,78121},
            [npcKeys.questEnds] = {78114,78121},
        },
        [210887] = {
            [npcKeys.name] = "Unsuspecting Pridewing",
            [npcKeys.minLevel] = 19,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 406,
            [npcKeys.spawns] = {
                [406] = {{60.4,62.2},{60.6,62.2},{60.6,62.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210901] = {
            [npcKeys.name] = "Stonetalon Wyvern stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210995] = {
            [npcKeys.name] = "Alonso",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{42,69.2},{42.4,70},{43.4,70.4},{43.4,70.6},{43.6,70.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {78132,78133,78134,78144},
            [npcKeys.questEnds] = {78132,78133,78134,78144},
        },
        [211022] = {
            [npcKeys.name] = "Owen Thadd",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{73.4,33},{73.6,33},{74,32.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {79094},
            [npcKeys.questEnds] = {78124,78127,78142,78143,78145,78146,78147,78148,78149,78150,79092,79093,79094,79095,79096,79097,79535,79536,79947,79948,79949,79950,79951,79952,79953,81947,81949,81951,81952,81953,81954,81955,81956,82084,82208},
        },
        [211033] = {
            [npcKeys.name] = "Garion Wendell",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{37.6,80.8},{37.8,80.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {78124,78127,78142,78143,78145,78146,78147,78148,78149,78150,79091,79092,79093,79095,79096,79097,79535,79536,79905,79947,79948,79949,79950,79951,79952,79953,81947,81949,81951,81952,81953,81954,81955,81956,82084,82208},
            [npcKeys.questEnds] = {78124,78127,78142,78143,78145,78146,78147,78148,78149,78150,79091,79092,79093,79095,79096,79097,79535,79536,79905,79947,79948,79949,79950,79951,79952,79953,81947,81949,81951,81952,81953,81954,81955,81956,82084,82208},
        },
        [211042] = {
            [npcKeys.name] = "Green Dragon Whelp",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{42,69.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211043] = {
            [npcKeys.name] = "Alonso",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211146] = {
            [npcKeys.name] = "Lost Adventurer",
            [npcKeys.minLevel] = 16,
            [npcKeys.maxLevel] = 16,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{34.2,9.4},{34.4,8.2},{35,7.6},{35.4,11.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211183] = {
            [npcKeys.name] = "Secret Agent",
            [npcKeys.minLevel] = 77,
            [npcKeys.maxLevel] = 77,
            [npcKeys.zoneID] = 8,
            [npcKeys.spawns] = {
                [8] = {{95,84.2}},
                [17] = {{50.4,79.6}},
                [40] = {{53.4,39.8},{53.6,40.2}},
                [45] = {{25,20}},
                [46] = {{35.8,19.8}},
                [85] = {{53.6,57},{53.8,57.8}},
                [267] = {{88.4,47.8}},
                [357] = {{26.8,94.8}},
                [361] = {{53.6,29.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211188] = {
            [npcKeys.name] = "Maethra Slagheart",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{37,88.8},{38,88},{38,89},{38,89.6},{38.6,89},{38.6,89.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {78192,78193},
            [npcKeys.questEnds] = {78192},
        },
        [211200] = {
            [npcKeys.name] = "Agon",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{60.2,31.8},{60.2,33},{60.4,29.8},{60.4,30.8},{60.6,25.8},{60.6,32.6},{60.8,29.2},{60.8,32.4},{61,30.6},{61.2,27.8},{61.4,30.4},{61.6,28.2},{61.6,29},{61.6,30.4},{61.6,31.8},{61.8,31.2},{62.2,25.4},{62.6,25.8},{62.6,31.8},{62.8,35.8},{63,31.2},{63,34.6},{63.2,30.4},{63.2,34.4},{63.4,25},{63.4,29},{63.6,31.4},{63.8,28.4},{64,32.4},{64,34},{64.2,33},{64.2,35},{64.2,35.6},{64.2,37.8},{64.4,23.8},{64.4,24.6},{64.4,26.4},{64.4,36.8},{64.6,36.4},{64.6,36.6},{64.8,24.8},{64.8,33},{64.8,34.4},{65,23.8},{65,32.4},{65.2,21.4},{65.2,21.6},{65.2,23.2},{65.2,27.8},{65.2,34.8},{65.4,26},{65.4,26.8},{65.4,30},{65.6,23.4},{65.6,24},{65.6,24.6},{65.6,26.4},{65.6,32.2},{65.6,34.8},{66,27},{66,32.6},{66,36.2},{66.2,33.6},{66.4,27.8},{66.4,29.2},{66.4,29.8},{66.6,33},{66.8,23.4},{66.8,28.4},{66.8,29.8},{67,30.6},{67.2,29.4},{67.4,27.2},{67.4,31.8},{67.6,30.2},{67.6,32},{67.6,33.6},{67.8,31},{68,33.4},{68.6,28},{68.8,32.4},{69.4,32.6},{69.6,29.4},{69.6,30.2},{70.2,33.4},{70.8,31.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211225] = {
            [npcKeys.name] = "Baj'ura",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{46.4,19.4},{46.4,20.2},{46.4,20.6},{47,19.6},{47.2,19.4},{48,19.2},{48,19.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {78198,78199},
            [npcKeys.questEnds] = {78198},
        },
        [211229] = {
            [npcKeys.name] = "Dietrich Praice",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{35.4,88},{35.6,88},{35.8,87.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {78196,78197,84328,84329,84405,84406,84408,84411,84412},
            [npcKeys.questEnds] = {78196,84327,84328,84405,84407,84408,84410,84411},
        },
        [211269] = {
            [npcKeys.name] = "Summoned Wisp",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{86.8,43.4},{86.8,43.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211274] = {
            [npcKeys.name] = "Ashenvale Wisp Target",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211279] = {
            [npcKeys.name] = "Corrupt Spirit Beast",
            [npcKeys.minLevel] = 23,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{86.6,43.6},{86.8,43.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211298] = {
            [npcKeys.name] = "Syrnoya",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 148,
            [npcKeys.spawns] = {
                [148] = {{37.6,43.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {78195},
        },
        [211330] = {
            [npcKeys.name] = "Suspicious Target",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{65.8,11.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211338] = {
            [npcKeys.name] = "Vile Fin Hunter",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{65.8,11.2},{65.8,11.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211653] = {
            [npcKeys.name] = "Grizzby",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{61.8,39.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {78265,78266,78267,78287,78288,82850,82851,82853},
            [npcKeys.questEnds] = {78265,78266,78267,78297,78304,82850,82851,82853},
        },
        [211736] = {
            [npcKeys.name] = "Grizzled Protector",
            [npcKeys.minLevel] = 16,
            [npcKeys.maxLevel] = 16,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{36.6,16},{36.6,17.2},{37.8,15.6},{39.4,15.2},{40.4,16.8},{40.6,18},{41.6,19.6},{42,24},{42.2,21.8},{42.4,18.4},{42.4,18.6},{42.8,18},{44,49.2},{44,51.6},{44.2,16.6},{44.6,17},{44.6,48.8},{45,24.6},{46,33},{47,18},{47.2,17},{47.2,19},{47.2,20.6},{47.4,32.8},{48,22.6},{48.2,20.8},{48.6,21.4},{48.6,33.4},{48.8,37.8},{49,14.2},{49,17.6},{49.2,15},{49.4,18.8},{49.4,21.6},{49.6,32.2},{49.8,19},{49.8,22.4},{50,16.6},{50.2,20},{50.4,16.2},{50.4,18.2},{50.4,23.4},{50.4,26},{50.4,38.2},{50.4,42.2},{50.4,44.8},{50.6,36.6},{50.6,67},{50.8,35.4},{51,15.8},{51,24.4},{51,38.2},{51,38.6},{51.2,19.2},{51.2,41.2},{51.2,45.2},{51.4,20},{51.6,17.2},{51.6,18.2},{51.6,20.8},{51.6,37.8},{51.6,38.8},{51.6,51.8},{51.8,19.6},{52,51.2},{52,57.8},{52.4,18.6},{52.4,59.4},{52.6,47.4},{52.6,48.4},{52.8,58.2},{53,20.8},{53.2,20.2},{53.4,44.4},{53.4,59},{53.8,45.8},{54,39.8},{54,44.2},{54.6,38.6},{54.6,40.4},{55,41.2},{55,44.6},{55.8,43}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211764] = {
            [npcKeys.name] = "Gefell",
            [npcKeys.minLevel] = 21,
            [npcKeys.maxLevel] = 22,
            [npcKeys.zoneID] = 209,
            [npcKeys.spawns] = {
                [209] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211765] = {
            [npcKeys.name] = "Gemela",
            [npcKeys.minLevel] = 21,
            [npcKeys.maxLevel] = 22,
            [npcKeys.zoneID] = 209,
            [npcKeys.spawns] = {
                [209] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211839] = {
            [npcKeys.name] = "Test Boss",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211875] = {
            [npcKeys.name] = "Decayed Elemental",
            [npcKeys.minLevel] = 15,
            [npcKeys.maxLevel] = 15,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{43.2,20.4},{43.2,20.6},{44.4,21.4},{44.4,21.8},{44.4,42},{45,21.6},{45,22.6},{45.2,21},{45.4,20},{45.8,20},{45.8,21.2},{45.8,22.6},{46,22.2},{46.2,19.4},{47,19.2},{47.2,20.4},{47.6,20},{55.4,15.6},{65.6,33.4},{67.2,24.6}},
                [1637] = {{37,76.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211941] = {
            [npcKeys.name] = "Dream Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211951] = {
            [npcKeys.name] = "Koartul",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 267,
            [npcKeys.spawns] = {
                [267] = {{61,33.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211952] = {
            [npcKeys.name] = "Omni Diffusion Armor",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{32.2,53.8}},
                [40] = {{53.2,39.2},{54,38.8},{56.4,53.2}},
                [85] = {{53.2,58.6},{53.4,57},{54.4,57},{58.4,62}},
                [1519] = {{56.2,60.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211953] = {
            [npcKeys.name] = "Bulky Protective Ironweave",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{53,40},{53.2,41.4},{53.4,39.4},{53.6,38.4},{57.4,42.8}},
                [85] = {{53.2,57.2},{53.6,56.6},{53.8,55.8},{54,58.6},{57,55.2},{57.4,56.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211954] = {
            [npcKeys.name] = "Electrostatic Discharge Shielding",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{53,38.8},{53,40.2},{57.4,43.2}},
                [85] = {{53.2,56.2},{54.4,56.8},{54.4,58}},
                [1519] = {{56,60},{56.2,61.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211955] = {
            [npcKeys.name] = "Auxiliary Anti-Tamper Mechanism",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{52,48.4},{52.4,39.4},{52.4,48.6},{52.6,48.4},{53,40.2},{53.2,40.8},{53.2,41.8},{53.4,38.8},{53.6,48.4},{57.8,42.6}},
                [85] = {{53,57},{54,56.8},{54.2,58}},
                [1519] = {{54.6,62.6},{55.8,62},{56,61.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211956] = {
            [npcKeys.name] = "Scarimous the Wandering",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{51.6,8.4},{51.6,8.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211965] = {
            [npcKeys.name] = "Carrodin",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 11,
            [npcKeys.spawns] = {
                [11] = {{47.2,64.4},{47.2,64.8},{47.2,65.6},{47.6,64},{47.6,64.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211967] = {
            [npcKeys.name] = "Leech Stalker Corpse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212159] = {
            [npcKeys.name] = "Old Serra'kis",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212186] = {
            [npcKeys.name] = "Grugimdern",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 11,
            [npcKeys.spawns] = {
                [11] = {{36.8,15.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212209] = {
            [npcKeys.name] = "Vodyanoi",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 11,
            [npcKeys.spawns] = {
                [11] = {{31.2,18.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212252] = {
            [npcKeys.name] = "Harvest Golem V000-A",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{33.2,22.4},{38.2,43.8},{43.2,48.8},{43.4,48},{45.4,43},{49.6,16.6},{49.6,48.6},{51.4,49.2},{51.4,49.8},{52,37},{52,48.8},{52,50.6},{52.2,36},{52.2,39.2},{52.2,40},{52.2,42.2},{52.4,41},{52.4,42.8},{52.4,45},{52.4,50},{52.6,43.8},{52.8,41.8},{52.8,47.8},{53,39.4},{53,39.8},{53.2,38.4},{53.2,40.8},{53.2,42.6},{53.2,46.6},{53.2,49.2},{53.4,37.4},{53.4,45.2},{53.6,40.4},{53.6,40.6},{53.6,42},{53.8,38.4},{53.8,39.4},{53.8,42.8},{54,47.2},{54.4,37},{54.4,45},{54.4,45.8},{54.4,47.6},{54.6,37.8},{54.6,40.6},{54.6,43.2},{54.8,39.6},{54.8,46.8},{54.8,52.6},{55,35.8},{55,42.2},{55,47.8},{55.2,37.4},{55.2,50},{55.2,52.2},{55.4,50.8},{55.6,34.6},{55.6,41.2},{55.6,48.4},{55.8,53.2},{56,50.8},{56,52},{56.2,42},{56.4,47.4},{56.6,41.2},{56.6,48.2},{56.6,48.6},{56.6,51.6},{56.6,53},{56.8,39.6},{56.8,53.6},{57.2,60.4},{57.4,43},{57.6,44},{57.6,50},{58,40.6},{58,46.8},{58.2,48},{58.4,41.8},{58.6,39.6},{60.2,42.6}},
                [85] = {{51.4,64.6},{51.6,63.8},{52.2,56.8},{52.4,56.4},{53.2,56.4},{53.2,56.6},{53.2,57.8},{53.2,58.8},{53.2,60.2},{53.2,63},{53.4,64},{53.6,56.8},{53.8,55.8},{53.8,57.8},{54,58.6},{54,67.2},{54.6,57.2},{54.6,57.6},{54.6,59.2},{55,56.2},{55.6,57.8},{55.8,59.2},{56.2,54.6},{56.2,57.4},{56.6,56.2},{56.6,60.2},{56.8,56.6},{57,53.2},{57.2,55.4},{57.6,55},{57.8,57},{57.8,57.8},{58,56.4},{58.2,62.6},{58.8,56.6},{59,51.2},{59.4,51.8},{59.6,59.4},{60.2,55},{60.4,52},{60.4,60},{60.8,58.6},{61.6,61},{61.8,54.6},{61.8,62.6},{61.8,64.8},{82.6,71}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212261] = {
            [npcKeys.name] = "Awakened Lich",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{17.2,37.6},{18,38},{18,38.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212330] = {
            [npcKeys.name] = "Explrgl",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212333] = {
            [npcKeys.name] = "Blackfathom Tendril",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212334] = {
            [npcKeys.name] = "Dead Twilight Cultist",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{17.2,26.4},{17.2,26.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212443] = {
            [npcKeys.name] = "Nightmare Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212458] = {
            [npcKeys.name] = "Phantasmal Crustacean",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212461] = {
            [npcKeys.name] = "Phantasmal Servant",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212462] = {
            [npcKeys.name] = "Phantasmal Softshell",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212463] = {
            [npcKeys.name] = "Phantasmal Snapjaw",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212468] = {
            [npcKeys.name] = "Invading Nightmare",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212598] = {
            [npcKeys.name] = "Recke Grinnes",
            [npcKeys.minLevel] = 16,
            [npcKeys.maxLevel] = 16,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{66.2,31.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212667] = {
            [npcKeys.name] = "Fettered Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212674] = {
            [npcKeys.name] = "Death's Head Shaman",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212678] = {
            [npcKeys.name] = "Earth Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212692] = {
            [npcKeys.name] = "Bound Elemental",
            [npcKeys.minLevel] = 21,
            [npcKeys.maxLevel] = 21,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{41.4,79.8},{42.2,80.8},{42.4,79.4},{43,78.6},{43,82.2},{43.2,78.4},{43.2,81.4},{43.6,78.8},{43.6,79.6},{43.8,78.4},{43.8,82.2},{44,80.6},{44,91.2},{44.4,88.8},{44.6,59},{44.8,76.8},{44.8,78.6},{44.8,85.8},{45,76.2},{45,79.6},{45.2,63.8},{45.2,74.2},{45.2,75.2},{45.2,77.8},{45.6,78.2},{45.8,80.4},{45.8,80.6},{45.8,82.8},{46,69},{46,69.8},{46,74},{46,75.2},{46,76.4},{46,76.6},{46.4,66},{47.6,81.6},{47.8,83.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212694] = {
            [npcKeys.name] = "Hirzek",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{41.8,79.4},{41.8,80.8},{42.2,81.6},{43.2,78.4},{43.2,78.6},{43.6,78.4},{43.6,78.8},{44.2,76.4},{44.2,80},{44.2,91},{44.4,59},{44.4,90},{44.6,75.8},{44.8,78.8},{45,86},{45.4,79.6},{45.4,83.8},{45.8,76.8},{46,61},{46,74.2},{46,75.4},{46,81.6},{46.2,60.4},{46.2,61.6},{46.2,67.8},{46.2,76.2},{47,60.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212699] = {
            [npcKeys.name] = "Silverwing Archer",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{27.4,27.6},{28.2,27.4},{28.2,28.8},{28.4,28.2},{28.6,28.2},{28.6,28.8},{29,26.6},{51.2,55.8},{51.2,56.6},{51.4,54.4},{51.4,54.8},{51.6,54.8},{51.6,55.6},{51.8,54.4},{59,72.6},{59.2,73.6},{59.4,71.2},{59.4,72.2},{59.8,71.8},{59.8,72.6},{60,70.4},{60,71.4},{60.6,71.4},{60.6,71.6},{72.4,73.2},{72.6,72.4},{72.8,73.2},{73,74.8},{73.4,73.6},{73.6,73.6},{74,73.2}},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212703] = {
            [npcKeys.name] = "Silverwing Dryad",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{28.4,27},{28.4,28.2},{28.4,28.6},{28.6,28},{28.8,28.8},{51.2,54.4},{51.2,55.6},{51.4,55.4},{51.6,54.8},{51.8,55.6},{59.4,73},{59.8,72.4},{60,71.4},{60,72.6},{60.6,71.4},{72.8,72.4},{73,73},{73.4,73.6},{73.6,73.8},{74,73.4}},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212706] = {
            [npcKeys.name] = "Silverwing Druid",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{27.4,27.8},{28.2,27},{28.4,28.4},{28.4,28.6},{28.6,28.2},{28.6,28.6},{51.2,55},{51.2,56},{51.4,54.4},{51.4,56.6},{51.6,54.4},{51.6,54.6},{59.4,72},{59.8,72.6},{60,70.4},{60,71.4},{60,71.6},{72.4,72.8},{72.8,72.4},{73,73.2},{73.2,73.6},{73.6,73.6}},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212707] = {
            [npcKeys.name] = "Larodar",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{51.2,54.4},{51.2,56.6},{51.4,55},{51.4,55.6},{51.4,57.6},{51.6,54.4},{51.6,54.8},{51.6,55.6},{51.6,57.4},{51.8,53.4},{51.8,58},{52.6,54.2},{52.6,58.2},{53.2,54.6},{53.6,54.4},{53.6,54.6},{56.2,55.6}},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212727] = {
            [npcKeys.name] = "Warsong Grunt",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{20.4,37},{21.2,36.4},{21.2,37.4},{21.2,37.8},{21.2,38.6},{21.6,36.4},{21.6,37.4},{21.6,38.6},{21.8,37.6},{38.2,68},{38.4,67.4},{38.4,68.6},{38.8,66.4},{39,67.8},{39,69},{39.4,66.8},{39.6,65.4},{39.6,66.4},{39.6,66.6},{39.6,69.4},{39.6,69.6},{52.4,54.2},{53.2,54.6},{53.4,54.4},{53.6,54.6},{54.2,54.4},{54.6,54.4},{54.8,55},{55.4,55.6},{55.6,55.4},{55.6,55.6},{68.4,63.8},{68.8,63.6},{69.4,63},{69.6,63},{69.8,62},{70.8,62.6}},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212728] = {
            [npcKeys.name] = "Warsong Raider",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{20.4,36.6},{21.2,37.4},{21.2,37.8},{21.4,36.4},{21.6,36.4},{21.6,37.4},{21.8,37.6},{38.2,67.8},{38.4,67.2},{38.8,69},{39,67.6},{39.4,66.2},{39.4,66.8},{39.6,65.4},{39.6,66.4},{39.6,66.6},{39.6,67.6},{53.2,54.4},{53.4,54.6},{54,54.6},{54.2,54.4},{54.6,54.4},{54.6,55},{55.6,55.2},{68.6,63.6},{69.4,63},{69.6,63},{70.8,62.6}},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212729] = {
            [npcKeys.name] = "Warsong Shaman",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{20.2,37},{21.2,36.6},{21.4,36.4},{21.4,37.6},{21.6,36.4},{21.6,37},{21.8,37.6},{38.2,68},{38.4,67.2},{38.4,68.6},{39,66.4},{39,67.8},{39.2,67},{39.6,65.4},{39.6,66.2},{39.6,67.4},{39.6,67.6},{48,56.2},{51.8,54.4},{53,54.4},{53,54.6},{54.2,53.2},{54.2,54.4},{54.2,54.6},{54.8,55},{69,63.6},{69.4,62.8},{69.8,63.2},{70.6,63.2}},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212730] = {
            [npcKeys.name] = "Tojara",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{50.2,55.4},{51.4,53.2},{51.4,54.4},{51.4,54.6},{51.6,54.4},{51.6,54.6},{51.8,53.4},{53,54.4},{53.4,54.6},{54.2,53.2},{54.2,54.4},{54.2,54.6},{54.6,54.4},{54.8,55},{54.8,55.6}},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212753] = {
            [npcKeys.name] = "Tortured Soul",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{45,58.6},{48.2,51.4},{63,37.6},{63,56.8}},
                [44] = {{76.4,84.2}},
                [130] = {{44.2,40.2},{44.4,42},{44.4,44},{44.8,42.4},{45,40.6},{46,39.6},{46.4,83.8},{47.4,83.8},{49,38.2},{52.6,55},{53.8,71.6},{54.8,70},{57.2,71},{57.6,71.4},{57.8,69.6},{58.4,72},{58.6,72},{59,70.8},{59.4,70.2},{59.6,70},{59.6,71.6},{59.8,71},{59.8,75.4},{60.2,74},{60.4,73.4},{60.6,72.4},{60.6,72.6},{61,74.8},{62,72.6},{62.6,73.8},{63.6,75.2},{65.8,80}},
                [1497] = {{54.6,72},{62.4,50},{63.8,51.2},{66.8,43.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212763] = {
            [npcKeys.name] = "Sadistic Fiend",
            [npcKeys.minLevel] = 19,
            [npcKeys.maxLevel] = 19,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{57,45.8},{57.4,44.8},{58.2,45.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212801] = {
            [npcKeys.name] = "Jubei",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{20,37.6},{20.4,37},{21.2,36.4},{21.2,37.4},{21.2,37.6},{21.2,38.6},{21.6,36.4},{21.6,37.4},{21.6,37.6},{21.8,38.6}},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212802] = {
            [npcKeys.name] = "Moogul the Sly",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{68.4,63.8},{69,63.6},{69.4,63},{69.6,63.2},{69.6,63.6}},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212803] = {
            [npcKeys.name] = "Ceredwyn",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{72.4,72.2},{72.8,72.4},{73.2,73.4},{73.2,73.6},{73.6,73.6}},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212804] = {
            [npcKeys.name] = "Centrius",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{27.4,27.8},{28,26.4},{28.2,27.4},{28.4,28.4},{28.4,28.6},{28.4,29.6},{28.6,28},{28.6,28.8}},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212809] = {
            [npcKeys.name] = "Wailing Spirit",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{57.2,70.4},{57.4,71},{57.6,71.2},{58.4,72},{58.6,71.6},{59.4,70.6},{59.8,71.2},{60.4,72.2},{60.4,72.8},{60.4,74},{60.4,74.8},{60.6,72.4},{60.6,73.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212837] = {
            [npcKeys.name] = "Primordial Anomaly",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 406,
            [npcKeys.spawns] = {
                [406] = {{27,64},{27.2,64.8},{27.4,65.6},{27.4,67.2},{27.6,63},{28,68.2},{28.2,71.8},{28.4,64.4},{28.4,65.4},{28.4,65.6},{28.4,70.8},{28.6,62},{28.6,63},{28.6,64.4},{28.6,65},{28.6,66},{29,71.4},{29,73.8},{29.2,71.8},{29.4,72.8},{29.6,63.6},{29.6,65.6},{29.6,70.4},{29.6,71.4},{29.6,72},{30.6,71.6},{31.2,66.8},{31.6,74.6},{31.8,67.4},{32.4,67.8},{32.8,68.4},{32.8,72.4},{33,69.4},{33.2,66.6},{33.2,69.6},{33.2,71.2},{33.6,68.8},{33.6,69.6},{33.8,68.4},{33.8,70.8},{35,72.2},{36.4,71.4},{36.4,71.6},{36.4,72.6},{36.8,71.4},{36.8,72},{36.8,72.6},{36.8,74.8},{37.6,71.4},{37.6,72},{37.6,72.6},{37.8,67.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212934] = {
            [npcKeys.name] = "Kazragore",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212953] = {
            [npcKeys.name] = "Felore Moonray",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212969] = {
            [npcKeys.name] = "Kazragore",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{38.4,66.8},{38.4,67.6},{38.8,66.4},{39,67.4},{39,68.6},{39.2,67.8},{39.6,66.4},{39.6,66.6},{39.6,67.6}},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {79098},
        },
        [212970] = {
            [npcKeys.name] = "Felore Moonray",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{60,71.4},{60,71.8},{60,72.6}},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {79090},
        },
        [213077] = {
            [npcKeys.name] = "Elaine Compton",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{54.4,60.8},{54.6,61.2},{54.8,62}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {78611,78612,78872,79100,79101,79102,79103,80307,80308,80309,82307,82308,82309,88654},
        },
        [213334] = {
            [npcKeys.name] = "Aku'mai",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213444] = {
            [npcKeys.name] = "Mysterious Traveler",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79,80.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {78684},
            [npcKeys.questEnds] = nil,
        },
        [213445] = {
            [npcKeys.name] = "Raszel Ander",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{49.2,57.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {78914,78994},
            [npcKeys.questEnds] = {78994},
        },
        [213450] = {
            [npcKeys.name] = "Felguard",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{33.4,55.8},{33.4,57.2},{33.8,55.6},{33.8,57},{34,54.8},{51,29.2},{51,29.6},{51,31},{51.4,26.8},{52,28}},
                [1377] = {{64.8,72.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213451] = {
            [npcKeys.name] = "Cleansing Elemental",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213452] = {
            [npcKeys.name] = "Corrosion Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213540] = {
            [npcKeys.name] = "Mysterious Traveler",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{49.2,57.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213595] = {
            [npcKeys.name] = "Void Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213659] = {
            [npcKeys.name] = "Dark Ritual Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213708] = {
            [npcKeys.name] = "Legion Hound",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79,80.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213709] = {
            [npcKeys.name] = "Mannoroc Lasher",
            [npcKeys.minLevel] = 24,
            [npcKeys.maxLevel] = 24,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79,80.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213710] = {
            [npcKeys.name] = "Felguard",
            [npcKeys.minLevel] = 24,
            [npcKeys.maxLevel] = 24,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79,80.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213711] = {
            [npcKeys.name] = "Searing Infernal",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79,80.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213795] = {
            [npcKeys.name] = "Gharrik",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 3,
            [npcKeys.spawns] = {
                [3] = {{22.4,67.4},{22.4,67.6},{22.6,67.4},{22.6,67.6},{23.4,66.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213994] = {
            [npcKeys.name] = "Corrosive Droplet",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214000] = {
            [npcKeys.name] = "Corrosive Pool Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214063] = {
            [npcKeys.name] = "Temporal Anomaly",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214070] = {
            [npcKeys.name] = "Jornah",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{51.4,63.8},{51.6,63.8},{51.6,64.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {78611,78612,78872,79100,79101,79102,79103,80307,80308,80309,82307,82308,82309,88654},
        },
        [214096] = {
            [npcKeys.name] = "Dokimi",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1638,
            [npcKeys.spawns] = {
                [1638] = {{39.4,53.4},{39.4,53.6},{39.6,53.4},{39.6,53.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {78611,78612,78872,79100,79101,79102,79103,80307,80308,80309,82307,82308,82309},
        },
        [214098] = {
            [npcKeys.name] = "Gishah",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{64.4,38.4},{64.4,38.6},{64.6,38.6},{64.8,38.2},{65.6,38.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {78611,78612,78872,79100,79101,79102,79103,80307,80308,80309,82307,82308},
        },
        [214099] = {
            [npcKeys.name] = "Tamelyn Aldridge",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1537,
            [npcKeys.spawns] = {
                [1537] = {{24.4,67.4},{24.4,67.6},{24.6,67.4},{24.6,67.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {88654},
            [npcKeys.questEnds] = {78611,78612,78872,79100,79101,79102,79103,80307,80308,80309,82307,82308,82309,88654},
        },
        [214101] = {
            [npcKeys.name] = "Marcy Baker",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{59.2,56.6},{59.8,56.4},{59.8,56.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {78611,78612,78872,79100,79101,79102,79103,80307,80308,80309,82307,82308,82309},
            [npcKeys.questEnds] = {78611,78612,78872,79100,79101,79102,79103,80307,80308,80309,82307,82308,82309},
        },
        [214129] = {
            [npcKeys.name] = "Venture Co. Light Shredder",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 21,
            [npcKeys.zoneID] = 406,
            [npcKeys.spawns] = {
                [406] = {{59.4,54.6},{59.8,51},{59.8,51.6},{60,54.4},{60,55},{60.2,50.4},{61.4,52.8},{62,53},{62,53.6},{62.2,52.4},{62.6,52.8},{66.4,47.4},{66.4,47.6},{66.6,47.4},{66.6,47.6},{67.4,57.4},{67.4,57.6},{67.6,57.4},{67.6,57.6},{68.2,47.4},{68.4,47.8},{68.6,47.4},{68.6,47.8},{68.8,48.6},{70,55.6},{70.2,55.2},{70.4,48.8},{70.6,41.4},{70.6,55.4},{70.6,55.8},{70.8,42},{70.8,49.2},{70.8,49.6},{72.4,52.4},{72.4,53.2},{72.4,53.6},{72.6,52.4},{72.6,53},{72.8,53.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214133] = {
            [npcKeys.name] = "Breath Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214190] = {
            [npcKeys.name] = "Blackfathom Pearl",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214208] = {
            [npcKeys.name] = "N'ora Anyheart",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{62,39.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {78909},
            [npcKeys.questEnds] = {78909},
        },
        [214212] = {
            [npcKeys.name] = "Shadowy Figure",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{88.4,73.4},{88.6,73.4},{88.6,73.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214254] = {
            [npcKeys.name] = "Pool of Shadow Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214440] = {
            [npcKeys.name] = "Demolition Explosives",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214456] = {
            [npcKeys.name] = "Dro'zem the Blasphemous",
            [npcKeys.minLevel] = 23,
            [npcKeys.maxLevel] = 23,
            [npcKeys.zoneID] = 44,
            [npcKeys.spawns] = {
                [44] = {{32.4,7},{33.2,7},{33.4,7.8},{33.6,7},{34.2,8.6},{34.4,7.6},{34.6,7.4},{34.8,7.8},{34.8,10},{35.2,8.6},{35.6,8},{35.8,6.8},{35.8,9.8},{36,12},{36.2,9.2},{36.4,11.4},{36.6,7.6},{36.6,10},{36.8,11.2},{36.8,13.6},{37,12},{38.6,13.8},{39.6,14.4},{57.4,41.4},{58.8,46.6},{59.8,40.4},{59.8,46.4},{60.4,42.4},{60.8,44},{61,42.4},{61.2,41},{61.2,43.4},{61.2,46},{61.4,45.2},{61.4,48},{62,45.6},{62.2,41.4},{62.2,42.2},{62.4,43.4},{62.4,43.6},{62.4,44.8},{62.6,42},{62.6,44.2},{62.6,44.8},{63,43},{63.4,41.4},{63.8,42.6},{64,42},{64,44.2},{64.2,45.8},{64.4,45},{64.6,46.6},{64.8,40.2},{65,48.4},{65.2,43.4},{65.6,41.8},{67,42.2},{69.8,82.6},{71.4,82},{71.4,82.8},{71.6,79.2},{71.8,80.8},{72,82},{72.6,81},{73,84.2},{73.4,82.2},{73.4,82.6},{73.6,79.6},{73.8,76},{74,81},{74,83.4},{74.4,78.6},{74.4,82.2},{74.4,83.6},{74.6,73.6},{74.6,76.8},{74.6,78.6},{75,71.6},{75,85},{75.2,73.2},{75.2,83.6},{75.4,77.8},{75.4,80.4},{75.4,81.2},{75.4,82.2},{75.4,82.6},{75.6,78.6},{75.6,81.4},{75.6,84.6},{75.8,78.2},{75.8,79.6},{75.8,83.6},{76,77.4},{76.2,69.6},{76.2,72},{76.2,82},{76.4,82.8},{76.6,82},{76.6,82.8},{77,70},{77,73.8},{77,77.2},{77,78.4},{77.2,68},{77.2,79.8},{77.2,81.4},{77.4,69.4},{77.4,71.4},{77.4,71.6},{77.4,75},{77.6,70.6},{77.6,74},{77.8,67},{78,72.4},{78.2,63.6},{78.2,66.4},{78.2,68},{78.2,69.2},{78.2,69.6},{78.4,72.8},{78.6,68},{78.6,69.2},{78.6,69.6},{78.6,70.6},{78.6,72.2},{78.8,67.4},{79.4,66.4},{79.4,72.6},{79.6,69.8},{79.6,70.6},{79.8,72.4},{80.2,67.6},{80.2,68.6},{80.8,69.6},{81,64.6},{82.2,67.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214458] = {
            [npcKeys.name] = "Baron Aquanis",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214468] = {
            [npcKeys.name] = "Ghamoo-ra",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214469] = {
            [npcKeys.name] = "Lady Sarevess",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214519] = {
            [npcKeys.name] = "Incinerator Gar'im",
            [npcKeys.minLevel] = 23,
            [npcKeys.maxLevel] = 23,
            [npcKeys.zoneID] = 44,
            [npcKeys.spawns] = {
                [44] = {{76.6,84.2},{77.2,85.2},{77.4,85.8},{77.8,86.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214523] = {
            [npcKeys.name] = "Blackfathom Elite",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214524] = {
            [npcKeys.name] = "Gelihast",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214525] = {
            [npcKeys.name] = "Lorgus Jett",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214526] = {
            [npcKeys.name] = "Twilight Lord Kelris",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214527] = {
            [npcKeys.name] = "Aku'mai",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214528] = {
            [npcKeys.name] = "Boss Dummy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214529] = {
            [npcKeys.name] = "Brave Stonetorch",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 267,
            [npcKeys.spawns] = {
                [267] = {{52.2,51.2},{65.8,19.6},{66,19.2},{67.4,14.2},{67.4,14.8},{67.6,14.4},{67.6,14.6},{68.6,13.8}},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {81944},
        },
        [214530] = {
            [npcKeys.name] = "Ardelle Dralta",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 267,
            [npcKeys.spawns] = {
                [267] = {{51,58.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214589] = {
            [npcKeys.name] = "Cozy Sleeping Bag",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214603] = {
            [npcKeys.name] = "Blackfathom Tide Priestess",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214612] = {
            [npcKeys.name] = "Aku'mai Fisher",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214658] = {
            [npcKeys.name] = "Ashenvale Arcane Shard Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214695] = {
            [npcKeys.name] = "Peon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214830] = {
            [npcKeys.name] = "Wisp",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214837] = {
            [npcKeys.name] = "Cheddar",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214876] = {
            [npcKeys.name] = "Davius Voidstar",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 148,
            [npcKeys.spawns] = {
                [148] = {{36.8,43.4},{36.8,43.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {79099},
            [npcKeys.questEnds] = {79099},
        },
        [214914] = {
            [npcKeys.name] = "Blackfathom Pearl",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214954] = {
            [npcKeys.name] = "Rix Xizzix",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{28.4,75.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215062] = {
            [npcKeys.name] = "Supplicant",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{39.4,28.2},{39.4,29},{39.4,30.4},{39.6,28.4},{39.6,29},{40,29.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215068] = {
            [npcKeys.name] = "[DNT] Kill Credit - Priest - Meditation Sharing Tutorial",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215072] = {
            [npcKeys.name] = "Loa Altar",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{79.8,67},{80,67.8}},
                [331] = {{11.8,35.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215081] = {
            [npcKeys.name] = "Bat Loa",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{79.8,67.2}},
                [331] = {{11.8,35.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215095] = {
            [npcKeys.name] = "Supplicant",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{39.4,87.4},{39.4,87.8},{39.8,86.2},{40,86.8},{40,88.6},{40.4,87.8},{40.6,88.2},{40.8,86.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215096] = {
            [npcKeys.name] = "Supplicant",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{35.6,87.6},{35.8,86.2},{35.8,87}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215097] = {
            [npcKeys.name] = "Supplicant",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215098] = {
            [npcKeys.name] = "Supplicant",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{48.2,14.6},{48.4,14},{49.4,14.4},{49.4,15},{49.4,16},{49.6,16},{50.2,14.4},{50.2,14.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215108] = {
            [npcKeys.name] = "Aku'mai Snapjaw",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215367] = {
            [npcKeys.name] = "Dawnwatcher Selgorm",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{55.6,24},{55.6,26},{56.6,24.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215369] = {
            [npcKeys.name] = "Bashana Runetotem",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 1638,
            [npcKeys.spawns] = {
                [1638] = {{70,33.4},{70,33.6},{70.8,32.4},{70.8,32.6},{70.8,33.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215643] = {
            [npcKeys.name] = "Tokal",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{27,77.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {79236,79242},
            [npcKeys.questEnds] = {79235,79236},
        },
        [215655] = {
            [npcKeys.name] = "Illari Duskfeather",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{93.8,71.4},{93.8,71.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215688] = {
            [npcKeys.name] = "Unkillable Test Dummy 25 Warrior",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215709] = {
            [npcKeys.name] = "Void Zone",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215728] = {
            [npcKeys.name] = "Crowd Pummeler 9-60",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215849] = {
            [npcKeys.name] = "Doan Karhan",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{51.2,82.4},{51.2,82.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {79298},
        },
        [215850] = {
            [npcKeys.name] = "Raszel Ander",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{51.2,82.4},{51.2,82.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {79298},
            [npcKeys.questEnds] = {78914},
        },
        [215854] = {
            [npcKeys.name] = "Shadowbinder Acolyte",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{51.2,82.4},{51.2,82.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215855] = {
            [npcKeys.name] = "Shadowbinder Acolyte",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{51.2,82.4},{51.2,82.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215890] = {
            [npcKeys.name] = "Gear Toss Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215974] = {
            [npcKeys.name] = "Des'Altek",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{51.2,82.4},{51.2,82.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216098] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216126] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216145] = {
            [npcKeys.name] = "Gnomeregan Smash Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216289] = {
            [npcKeys.name] = "Orokai",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 493,
            [npcKeys.spawns] = {
                [493] = {{41.2,43.6},{41.4,43.4},{41.6,43.4},{41.6,43.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {79377,85401},
            [npcKeys.questEnds] = {79348,79377,85401,85501},
        },
        [216310] = {
            [npcKeys.name] = "Rotting Ancient",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 15,
            [npcKeys.spawns] = {
                [15] = {{40,42.8},{40.4,44},{41.2,37.6},{41.2,44.6},{41.4,41},{41.4,42.4},{41.4,42.8},{41.4,43.6},{41.6,34.2},{41.6,37.8},{41.6,44.6},{41.8,42.6},{42,30.8},{42.4,40.8},{42.4,42},{42.4,43.8},{42.6,43.4},{42.6,43.8},{42.6,44.8},{43,42.2},{43.2,41.4},{43.6,41},{43.6,43},{44,42},{44.2,43.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216437] = {
            [npcKeys.name] = "Ancient Sapling",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{58,43.8},{58.2,43.4},{58.6,43.4},{58.6,43.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216445] = {
            [npcKeys.name] = "Ancient Sapling",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 8,
            [npcKeys.spawns] = {
                [8] = {{11.2,38.8},{11.4,38.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216448] = {
            [npcKeys.name] = "Ancient Sapling",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{32.6,65}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216451] = {
            [npcKeys.name] = "Ancient Sapling",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{46.8,71.4},{46.8,72}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216463] = {
            [npcKeys.name] = "Ailgrha Splittusk",
            [npcKeys.minLevel] = 38,
            [npcKeys.maxLevel] = 38,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{55,42}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216474] = {
            [npcKeys.name] = "Ravaging Tempest",
            [npcKeys.minLevel] = 38,
            [npcKeys.maxLevel] = 38,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{53.4,40.8},{53.8,40.4},{54,41.2},{54.4,41.8},{54.6,41.4},{54.6,41.8},{55.8,43.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216620] = {
            [npcKeys.name] = "Unkillable Test Dummy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216659] = {
            [npcKeys.name] = "Fallenroot Satyr",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{13.4,10},{13.4,12.2},{13.4,13.2},{13.6,11.8},{13.6,13.4},{13.8,10},{13.8,11.2},{14.4,9.4},{14.6,10},{15,10.6},{15.8,11.4},{16.2,11.6},{16.6,11}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216660] = {
            [npcKeys.name] = "Fallenroot Rogue",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{13.8,9.2},{14.4,9.6},{14.8,10.4},{15.2,10.8},{15.8,11.4},{16.4,11.6},{16.6,11},{16.6,11.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216661] = {
            [npcKeys.name] = "Blackfathom Tide Priestess",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{12.8,10},{13.4,9.4},{13.4,12.2},{13.4,13.2},{13.6,11.8},{13.6,13.4},{13.6,13.6},{13.8,9.2},{13.8,10},{13.8,11.2},{14.6,8.6},{14.6,10},{15,10.6},{15.8,11.4},{16.4,11.6},{16.6,11.6},{17,11.2},{17.6,11}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216662] = {
            [npcKeys.name] = "Blackfathom Oracle",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{13.6,9.6},{14.4,9.4},{14.6,10},{15.2,10.8},{15.6,11.2},{16.4,11.6},{16.6,11},{16.6,11.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216664] = {
            [npcKeys.name] = "Sprok",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216665] = {
            [npcKeys.name] = "Gnomeregan Evacuee",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{24.4,39.8},{24.4,41},{24.6,39.6},{24.8,39.2}},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216666] = {
            [npcKeys.name] = "Techbot",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216667] = {
            [npcKeys.name] = "Addled Leper",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{24.4,39},{24.4,39.8},{24.4,40.8},{24.6,39.4},{24.6,39.8},{25.8,39.8},{27.8,40.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216668] = {
            [npcKeys.name] = "Irradiated Invader",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216669] = {
            [npcKeys.name] = "Caverndeep Pillager",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216670] = {
            [npcKeys.name] = "Caverndeep Looter",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216671] = {
            [npcKeys.name] = "Caverndeep Invader",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216672] = {
            [npcKeys.name] = "Namdo Bizzfizzle",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216810] = {
            [npcKeys.name] = "Desiccated Fallout",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216854] = {
            [npcKeys.name] = "Freewind Post Wyvern",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{53.2,41}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216902] = {
            [npcKeys.name] = "Wulmort Jinglepocket",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1537,
            [npcKeys.spawns] = {
                [1537] = {{33.4,66.4},{33.4,67},{33.4,67.6},{33.6,66.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {7022,79482,79486,79492,79501},
            [npcKeys.questEnds] = {79484,79492},
        },
        [216915] = {
            [npcKeys.name] = "Strange Snowman",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{35.4,72.4},{35.4,72.6},{35.6,72},{35.6,72.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {79484,79485},
            [npcKeys.questEnds] = {79482,79483},
        },
        [216924] = {
            [npcKeys.name] = "Kaymard Copperpinch",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{53.2,66.4},{53.2,66.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {6961,79483,79487,79495,79502},
            [npcKeys.questEnds] = {79485,79495},
        },
        [216931] = {
            [npcKeys.name] = "The Abominable Greench",
            [npcKeys.minLevel] = 36,
            [npcKeys.maxLevel] = 36,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{28.4,62.6},{28.6,51.6},{28.8,56.2},{28.8,60.2},{28.8,61.4},{29,55.4},{29.2,57},{29.2,63.6},{29.4,62.6},{29.6,59.8},{29.8,58.8},{29.8,61},{29.8,63.4},{30,51.4},{30,55.6},{30,62},{30,65.6},{30.4,46.6},{30.4,54.6},{30.4,64.4},{30.4,65},{30.4,70.8},{30.6,47.4},{30.6,52.8},{30.6,54.2},{30.6,55},{30.6,60.8},{30.6,63.6},{30.8,63},{30.8,66.8},{31,65.4},{31,65.6},{31,70.6},{31.2,55.6},{31.4,48.8},{31.6,47.4},{31.6,51.4},{31.6,66.2},{31.6,71.8},{31.8,51.6},{31.8,54.8},{31.8,61.4},{31.8,70.6},{32,47.8},{32,66.8},{32,70},{32.2,48.6},{32.2,52.8},{32.4,50},{32.4,67.8},{32.6,47.8},{32.6,49},{32.6,50.6},{32.6,51.6},{32.6,52.8},{32.8,50},{32.8,71},{32.8,71.8},{33,70.4},{33.6,72.2},{34,70.2},{34.2,69.2},{34.2,70.8},{34.4,67.8},{34.6,46.6},{34.6,68.4},{34.6,71},{35.2,74.8},{35.4,70.4},{36.8,70.4},{37,72.4},{37.6,69.4},{37.6,70.4},{37.8,72.2},{38.2,66.4},{38.2,74},{38.4,72.8},{38.6,72.4},{38.8,72.6},{39,70.2},{39.2,66},{39.2,70.6},{39.4,68.6},{39.6,64.4},{39.6,65.4},{39.8,61.4},{39.8,62.4},{39.8,68.8},{39.8,73.4},{39.8,81.8},{40.2,73.8},{40.2,74.6},{40.4,68.2},{40.4,71.8},{40.6,62.6},{40.6,69.8},{40.6,74.8},{40.6,80},{40.8,64.8},{40.8,74.2},{41,72},{41,77.6},{41,79.2},{41.2,65.8},{41.4,69.4},{41.4,76.6},{41.6,76.4},{41.6,78},{41.6,79.6},{42,66.6},{42,77},{42.4,68.6},{43,61.8},{43,67.4},{43.8,62.8},{43.8,66},{44,65.2},{44.4,64},{44.6,62.4},{44.6,64}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216937] = {
            [npcKeys.name] = "Blood Moon Listener Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217049] = {
            [npcKeys.name] = "Mirror Image",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{21.2,36.4},{21.2,38.6},{21.4,36.8},{21.4,37.6},{21.6,36.4},{21.6,37.4},{21.6,37.6},{21.6,38.6},{22.6,38.2},{23,35},{23.6,38.2},{42.8,60.8},{49,56.8},{50,56.8},{50.2,54},{50.2,55},{50.2,56.2},{50.6,53.4},{51,51.8},{51.4,54.2},{51.4,54.8},{51.6,53.2},{51.6,54},{51.6,54.6},{53,54.6},{53.2,54.4},{53.8,54.6},{54.2,54},{54.4,53.4},{54.8,54.4},{54.8,54.8},{55.2,55.8},{60.8,70.2},{64,60},{67.2,62.2},{68.2,62.6},{68.2,64.2},{68.4,62.4},{69.2,63.6},{69.4,63},{69.6,63},{69.6,63.6},{70.2,62.4}},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217215] = {
            [npcKeys.name] = "Irradiated Cloud",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217216] = {
            [npcKeys.name] = "Grubbis Controller",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217221] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217280] = {
            [npcKeys.name] = "Grubbis",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217290] = {
            [npcKeys.name] = "Ogre Lightning Rod",
            [npcKeys.minLevel] = 37,
            [npcKeys.maxLevel] = 37,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{33.4,44.4},{33.4,44.6},{33.6,44.4},{33.6,44.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217300] = {
            [npcKeys.name] = "Skonk",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{57.4,74.4},{57.6,74.4},{57.6,74.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {79677,79678},
            [npcKeys.questEnds] = {79624,79677,79678},
        },
        [217302] = {
            [npcKeys.name] = "Tam'kar",
            [npcKeys.minLevel] = 37,
            [npcKeys.maxLevel] = 37,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{32.2,45.4},{32.4,43.4},{33,46.2},{33.4,44.4},{33.4,44.6},{33.6,44.4},{33.6,44.6},{33.8,45.8},{33.8,47.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217305] = {
            [npcKeys.name] = "Ancient Fire Elemental",
            [npcKeys.minLevel] = 34,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{60,45.4},{60,45.6},{60,46.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217308] = {
            [npcKeys.name] = "Irradiated Goo",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217387] = {
            [npcKeys.name] = "Brother Atticus",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{27,57}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217392] = {
            [npcKeys.name] = "Flameseer Dubelen",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{56,22.6},{56.2,23.6},{56.4,19.8},{56.4,21.4},{56.4,21.8},{56.6,20.4},{56.6,21.4},{56.6,21.8},{57.2,19},{57.8,22.2},{58,22.6},{58.2,19.6},{58.2,21.4},{58.6,20.8},{58.8,19},{59.2,16.4},{60.6,20.6},{62,18}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217412] = {
            [npcKeys.name] = "Amaryllis Webb",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 8,
            [npcKeys.spawns] = {
                [8] = {{25,54.2},{25.2,54.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217418] = {
            [npcKeys.name] = "Zai'enki",
            [npcKeys.minLevel] = 28,
            [npcKeys.maxLevel] = 28,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{68.6,55.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217580] = {
            [npcKeys.name] = "Seductress Ceeyna",
            [npcKeys.minLevel] = 38,
            [npcKeys.maxLevel] = 38,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{79.8,82.8},{80,82.4},{80.6,82.6},{81,79.4},{81.4,80.2},{81.4,80.6},{81.4,82},{81.6,79.4},{81.8,80.4},{81.8,80.6},{81.8,81.6},{82.6,80.2},{82.6,80.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217582] = {
            [npcKeys.name] = "Caverndeep Ambusher",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217588] = {
            [npcKeys.name] = "Arbor Tarantula",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{43.6,18.4},{43.8,18.6},{44.2,22},{45.2,19.4},{45.2,19.6},{45.4,22.2},{45.4,23.2},{45.6,22.2},{45.6,23}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217589] = {
            [npcKeys.name] = "Hay Weevil",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{30.4,28.6},{30.6,28.4},{30.8,28.6},{31,26.2},{32.2,31},{54,38.6},{54.2,38.4},{57,39.8},{57.2,39.4},{59.6,57},{61.2,55.4},{61.2,55.6},{62.4,56},{62.6,56}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217590] = {
            [npcKeys.name] = "Flesh Picker",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{49,58.4},{50,56},{50,59.2},{51.2,58},{51.4,59.8},{51.6,57.2},{51.6,59.8},{52.2,58.2},{52.4,56.4},{52.4,58.6},{52.6,56.8},{52.6,58},{52.8,56.4},{52.8,59.6},{53,59},{53.4,61.8},{54,62},{54,62.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217605] = {
            [npcKeys.name] = "Void Seeker",
            [npcKeys.minLevel] = 36,
            [npcKeys.maxLevel] = 36,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{29.2,62.4},{29.2,63}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217620] = {
            [npcKeys.name] = "Reckless Warlock",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{30.8,47}},
                [36] = {{54.4,49.4},{54.4,49.6},{54.6,49.4},{54.6,49.6}},
                [400] = {{10.8,40.4},{11,40.6}},
                [405] = {{74.8,13.4},{74.8,13.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217669] = {
            [npcKeys.name] = "Scorched Screeching Roguefeather",
            [npcKeys.minLevel] = 29,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{26.2,46.8},{26.4,46.4},{26.4,47.6},{26.6,47.6},{26.8,47.2},{27,42.2},{27,46.4},{27.6,46.2},{27.6,47}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217683] = {
            [npcKeys.name] = "Altar of the Wind Spirit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217689] = {
            [npcKeys.name] = "Ziri \"The Wrench\" Littlesprocket",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {79705,81975},
            [npcKeys.questEnds] = {79705,81974,81975},
        },
        [217703] = {
            [npcKeys.name] = "Singed Highperch Consort",
            [npcKeys.minLevel] = 28,
            [npcKeys.maxLevel] = 29,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{10.4,39.4},{10.4,40.2},{10.4,40.6},{10.6,40.6},{10.8,39.2},{11.2,39.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217706] = {
            [npcKeys.name] = "Kazragore",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{74,60.4},{74,60.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {79098},
        },
        [217707] = {
            [npcKeys.name] = "Felore Moonray",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{36.8,49.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {79090},
        },
        [217711] = {
            [npcKeys.name] = "Seared Needles Cougar",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 28,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{23.4,23.2},{23.4,23.6},{23.4,25},{23.6,23.4},{23.6,24.4},{23.6,24.8},{24.6,23.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217733] = {
            [npcKeys.name] = "Caverndeep Pillager",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217783] = {
            [npcKeys.name] = "Bloodscalp Guerrilla",
            [npcKeys.minLevel] = 34,
            [npcKeys.maxLevel] = 34,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{30.4,14},{30.4,15.4},{30.4,15.8},{30.6,14.2},{31,14.6},{31,16.6},{31.2,16.2},{31.6,14.2},{31.8,15.8},{32.4,15},{32.6,13},{32.6,14.8},{32.8,16.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217836] = {
            [npcKeys.name] = "Needletooth",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{66.4,66.8},{67,66.8},{67.4,64.2},{67.4,64.6},{67.4,65.6},{67.4,67.6},{67.4,68.6},{67.6,65.6},{67.6,66.8},{67.6,68.4},{67.6,68.6},{67.8,64.8},{67.8,69.6},{68,63.4},{68.4,64.2},{68.6,64.6},{68.6,66.6},{68.6,68.2},{69,64.2},{69.4,63.2},{69.6,63},{69.8,64.6},{70,64.4},{70.6,63.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217862] = {
            [npcKeys.name] = "Reconstructed Staff of Des'Altek",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217907] = {
            [npcKeys.name] = "Chicken TEST",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217908] = {
            [npcKeys.name] = "Willing Sacrifice",
            [npcKeys.minLevel] = 38,
            [npcKeys.maxLevel] = 39,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{82,80.4},{82,80.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217942] = {
            [npcKeys.name] = "Trogg Monster Random",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217943] = {
            [npcKeys.name] = "Scarlet Crusade Assassin",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217945] = {
            [npcKeys.name] = "Domesticated Attack Chicken",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217956] = {
            [npcKeys.name] = "Chomper",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217957] = {
            [npcKeys.name] = "Slain Scarlet Crusader",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217969] = {
            [npcKeys.name] = "Blastmaster Emi Shortfuse",
            [npcKeys.minLevel] = 42,
            [npcKeys.maxLevel] = 42,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217980] = {
            [npcKeys.name] = "Julien Faranister",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{66.2,58.4},{66.2,58.6},{66.2,59.8},{66.6,59},{67,58.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217987] = {
            [npcKeys.name] = "Giga Dummy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217996] = {
            [npcKeys.name] = "Aeonas",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 796,
            [npcKeys.spawns] = {
                [796] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {79963,79970},
            [npcKeys.questEnds] = {79946,79963},
        },
        [218007] = {
            [npcKeys.name] = "Josh's Kill Credit Creature 1",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218019] = {
            [npcKeys.name] = "Combat Dummy",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{68,89.4},{68,89.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218020] = {
            [npcKeys.name] = "Combat Dummy",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{67.8,89.4},{68,89.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218021] = {
            [npcKeys.name] = "Combat Dummy",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{67.8,89.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218029] = {
            [npcKeys.name] = "Witherbark Champion",
            [npcKeys.minLevel] = 34,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{66.6,79.2},{66.8,80},{67.2,81.8},{67.4,78.2},{67.6,77.8},{68,79.4},{68,82.2},{68.2,80},{68.4,80.6},{69,82.6},{69.4,80.4},{69.4,81.4},{69.4,81.6},{69.6,81.4},{69.6,81.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218032] = {
            [npcKeys.name] = "Witherbark Goliath",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{68.4,80.6},{69.2,81.4},{69.4,81.6},{69.6,81.4},{69.6,81.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218057] = {
            [npcKeys.name] = "Crowd Pummeler Bleacher Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218089] = {
            [npcKeys.name] = "Scarlet Squire Corpse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218090] = {
            [npcKeys.name] = "Scarlet Crusader Corpse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218093] = {
            [npcKeys.name] = "Burning Blade Acolyte Corpse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218095] = {
            [npcKeys.name] = "Burning Blade Acolyte Corpse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218115] = {
            [npcKeys.name] = "Mai'zin",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{31.2,48.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218160] = {
            [npcKeys.name] = "Aeonas the Vindicated",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{37.4,31.8},{37.6,31.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {81762},
            [npcKeys.questEnds] = {79970},
        },
        [218229] = {
            [npcKeys.name] = "Captain Aransas",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{27.4,76.6},{27.6,76.4},{27.6,76.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218230] = {
            [npcKeys.name] = "Wendel Mathers",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{44.2,8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218231] = {
            [npcKeys.name] = "Highlands Knight",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218232] = {
            [npcKeys.name] = "Kha'damu",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218233] = {
            [npcKeys.name] = "Forest Troll Shadow Priest",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218234] = {
            [npcKeys.name] = "Ogre Magi",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218235] = {
            [npcKeys.name] = "Gnoll Overseer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218236] = {
            [npcKeys.name] = "Red Bag",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{53,24.4},{53,24.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {84211},
            [npcKeys.questEnds] = {84146},
        },
        [218237] = {
            [npcKeys.name] = "Wirdal Wondergear",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{84.2,43.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {79982},
            [npcKeys.questEnds] = {79981,79982},
        },
        [218238] = {
            [npcKeys.name] = "Josh's Kill Credit Creature 2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218240] = {
            [npcKeys.name] = "Tower Defense Automaton",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{84.2,44}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218241] = {
            [npcKeys.name] = "Shadowy Figure",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 3,
            [npcKeys.spawns] = {
                [3] = {{7,90.6},{17,41.2},{19.2,42.6},{42.8,78.2},{48.4,37.8},{48.4,41.4},{50,14.2},{51.2,54.4},{54.4,24.6},{55.8,56.4},{72.2,65.8},{74.6,65.2},{83.2,30.6}},
                [15] = {{33.6,20.4},{33.8,46},{35.6,35.4},{37.2,22.8},{38,26.8},{38.4,34.4},{41.8,70.4},{43.2,66.4},{46.2,22.6},{46.2,83.8},{48,80.4},{49.4,37},{49.6,69.4},{51.4,71.2},{53.4,20.6},{54,15.8},{56.6,20.8},{57,11.4},{61.4,20.8},{61.8,17.6},{63,29.2},{63.2,36.6},{64.6,28.2}},
                [33] = {{21.2,10.4},{23.4,10},{24,10.6},{24.2,50.4},{24.2,61.4},{24.6,62.2},{25,63.6},{25.2,12.6},{26.2,13.4},{26.8,61.8},{26.8,67.4},{28,70},{28.8,71},{30,19.2},{30,23.4},{30.8,71.8},{31.2,68.4},{31.4,14.4},{32,67},{32.6,13},{32.8,37},{32.8,78.6},{33,74},{33.2,36},{33.2,60.4},{33.2,65},{33.8,20.2},{33.8,21.2},{34.2,60.6},{34.2,65},{35.6,42.6},{36,30},{36,41},{37.4,31.4},{38.4,42.6},{38.8,26},{39.6,38.2},{39.8,30.6},{40.2,27.2},{40.6,38.6},{41.4,43},{42.4,33.6},{42.6,18.4},{43.8,33.8},{44.2,10.2},{44.4,40.6},{44.8,40.2},{45.8,8},{46,41.4},{46.2,7},{46.4,13.2},{47.8,6.8}},
                [36] = {{17.4,84.8},{18,83.2},{18.6,81.6},{33.4,83.8},{38,15},{39.4,15},{39.6,68.6},{40.2,57.6},{40.4,74},{41.8,21},{42,62.2},{47.2,47.6},{47.6,84.4},{48.8,18.8},{56.8,46.8},{57.6,67.4},{59.4,67.8},{62.4,46.8}},
                [357] = {{23.2,64.2},{23.6,64.6},{24,52.6},{24.2,64.2},{24.4,63.2},{24.6,67},{25,55.8},{25,62.4},{25.2,52.2},{25.2,54},{25.2,55.2},{25.2,66},{25.4,49},{25.4,50.4},{25.4,51.2},{25.4,53.4},{25.4,63},{25.4,64.4},{25.4,65.2},{25.6,50.2},{25.6,51.4},{25.6,56},{25.6,64.6},{25.8,49},{25.8,62.2},{25.8,63.6},{25.8,66},{26,47.6},{26,52.8},{26,54},{26,71.4},{26.2,55},{26.2,63},{26.2,67.4},{26.4,45.4},{26.4,46.8},{26.4,52},{26.4,56.8},{26.4,68},{26.4,68.6},{26.6,46.4},{26.6,50.2},{26.6,52},{26.6,55.8},{26.8,46.6},{26.8,54.6},{26.8,56.8},{26.8,68.2},{26.8,69.4},{27,53.4},{27,64},{27,69.6},{27.2,45.4},{27.2,53.6},{27.2,62.2},{27.2,62.8},{27.4,47.8},{27.6,48.2},{27.6,48.8},{27.6,51.8},{27.6,54},{27.6,55.2},{27.6,62.2},{27.6,62.8},{27.6,68.2},{27.6,70.2},{27.6,70.8},{27.8,44.4},{27.8,47},{28,56.8},{28,69},{28.2,56.4},{28.2,58},{28.4,45.4},{28.4,45.6},{28.4,50.2},{28.4,51},{28.4,52.8},{28.6,52},{28.6,52.6},{28.8,44.8},{28.8,50.8},{28.8,53.8},{29,46.8},{29,50.2},{29.2,54.6},{29.2,56.6},{29.4,47.6},{29.4,49},{29.4,56},{29.6,49.8},{29.6,53},{29.6,55.2},{29.8,48.2},{29.8,52.2},{29.8,57.2},{30,49},{30.2,50.6},{30.2,54.2},{30.2,56},{30.6,48.2},{30.6,50.4},{30.6,53.8},{30.8,51.4},{30.8,52.6},{30.8,57.6},{31,52},{31.2,49.4},{31.2,55.8},{31.2,56.8},{31.4,55.4},{31.6,50.2},{31.8,51},{31.8,55.8},{31.8,57.6},{32.4,55.4},{32.6,56.8},{32.8,56.2},{33.2,49.8},{33.2,52.4},{33.2,53.2},{33.2,53.8},{33.2,55.2},{33.4,49},{33.4,51},{33.8,49.8},{34,49.4},{37.6,32.8},{38.6,13.8},{40.8,35.8},{42.6,8.8},{44.8,12.2},{45,45.8},{45.2,21},{48,44.8},{50.2,25},{51.8,32},{52.2,58},{53.4,56},{54.8,56.2},{55,73.2},{55.4,53},{55.4,57},{55.6,53},{55.8,56.6},{56.4,56},{56.6,54.8},{57.4,47.4},{57.6,45.2},{57.6,54},{58.8,48.6},{59.4,45.2},{59.6,66.2},{60.4,54.6},{60.4,56.2},{61.2,44.4},{61.2,64},{61.6,55.2},{67.4,55.6},{68.2,46.2},{68.8,47},{69,39.4},{69,50.8},{69.4,54.2},{69.6,39.6},{70.8,56.4},{71,53.2},{72,45.8},{72,55},{72.2,35.6},{72.6,56.4},{73,35.6},{73.4,64},{73.8,54.4},{74,37.8},{74.4,40.2},{74.8,27.2},{75.2,34.6},{75.4,53.8},{75.6,57.2},{75.8,33.6},{77.6,41},{78,38.2},{78.2,45},{78.4,33.8},{79.6,41.2},{85.6,44.2},{85.6,46},{86,41.8},{86,45.2},{86.6,41.2},{88.8,39.4}},
                [400] = {{67.4,86},{69.6,82.4},{69.8,88.8},{70.8,77.4},{71,86.2},{71.6,86.2},{77.2,89.6},{78.4,90.2},{79.8,87},{80.6,60.2}},
                [405] = {{27.4,8.6},{27.8,8.6},{29,77.8},{30.2,58.8},{31,79.4},{42.2,70},{43.2,73.2},{45,74.4},{48,75.6},{48.8,77.4},{49,78.4},{49.2,81.4},{49.4,78.6},{49.6,78},{49.8,73},{50,81.4},{50.2,74},{50.4,70},{50.4,71.6},{50.4,76.4},{50.4,76.8},{50.6,77.6},{50.6,82.6},{50.8,71},{51,75.2},{51,76.6},{51.2,68.8},{51.2,70.2},{51.2,72},{51.2,73.4},{51.2,75.8},{51.2,81.8},{51.2,83.6},{51.4,68},{51.8,74},{51.8,82.4},{51.8,84.6},{52,75.2},{52,83.6},{52.2,83.4},{52.4,67.2},{52.4,85.8},{52.6,70.8},{52.6,83.8},{52.8,71.8},{52.8,79.2},{53,72.6},{53.2,70},{53.2,77.6},{53.2,85.2},{53.4,76},{53.4,79.6},{53.4,81.2},{53.4,81.8},{53.6,70.2},{53.6,78},{53.6,82.2},{53.8,77.4},{53.8,79.8},{53.8,83.6},{54,76.2},{54.2,74},{54.4,71},{54.6,73.6},{55,77.2},{55.4,78.2},{55.8,40.8},{55.8,77.8},{56,75.8},{56.2,71.8},{56.2,77.2},{56.4,71.4},{56.4,73},{56.6,72.8},{56.6,77.8},{57,74.4},{57.2,76.2},{57.8,75.4},{58.2,77.4},{59.2,89.8},{60.4,90.4},{61,90.6},{63,52},{64,87.4},{64.4,90.6},{65,22.8},{65.8,25.4},{69.6,20.6},{69.8,31},{70,81},{72,19.4},{72.6,17},{72.8,73},{74,22.6},{74.6,13.2},{77,18.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218242] = {
            [npcKeys.name] = "STX-04/BD",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218243] = {
            [npcKeys.name] = "STX-13/LL",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218244] = {
            [npcKeys.name] = "STX-25/NB",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218245] = {
            [npcKeys.name] = "STX-37/CN",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218246] = {
            [npcKeys.name] = "Gurgthock",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{33.2,50.2},{33.2,50.6}},
                [14] = {{45.4,13.8}},
                [1519] = {{55.2,62.6},{55.4,63.6},{55.8,62.2},{55.8,63}},
                [1637] = {{51.8,69.8},{52,69.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218249] = {
            [npcKeys.name] = "Slitherblade Tide Priestess",
            [npcKeys.minLevel] = 33,
            [npcKeys.maxLevel] = 34,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{29.4,6},{29.6,6},{33,11.2},{33,11.6},{34.4,5.2},{34.4,20.2},{34.4,20.6},{34.4,26.4},{34.4,26.8},{34.4,30},{34.6,20},{34.6,26.4},{34.6,26.8},{34.6,30},{36.4,27},{36.6,26.4},{36.6,26.8},{38.4,23.8},{38.4,24.6},{38.6,24},{40.6,15.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218262] = {
            [npcKeys.name] = "Leprous Assistant",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218263] = {
            [npcKeys.name] = "Leprous Machinesmith",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218273] = {
            [npcKeys.name] = "Wandering Swordsman",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 3,
            [npcKeys.spawns] = {
                [3] = {{14.4,44.8},{15.6,45.8},{20,54.6},{20,57},{21,49.8},{22,58.6},{22.6,58.4},{22.8,56.4},{23,60},{23.4,59.2},{23.8,56.6},{24,58.6},{24,60.2},{24.4,58.4},{24.4,61.6},{24.8,56.4},{24.8,58.4},{24.8,58.6},{25.2,57.4},{25.2,60.2},{25.4,61.2},{25.8,59.4},{26.2,68.6},{26.4,57},{26.4,71},{26.8,71.8},{27,72.8},{27.2,66},{27.2,69.6},{27.4,47.6},{27.4,67.4},{27.4,68.4},{27.4,68.6},{27.6,66.6},{27.8,66},{27.8,68.2},{27.8,68.6},{27.8,72.4},{28,69.8},{28.8,64.8},{28.8,68},{31,51.4},{32.2,65.4},{32.4,69},{32.4,69.6},{32.6,70.6},{32.6,71.6},{33,66.2},{33.2,66.8},{33.4,68.4},{33.4,68.6},{33.4,69.6},{33.6,68.4},{33.6,69.2},{33.8,57.2},{33.8,69.8},{34.6,69.6},{34.8,57.2},{34.8,61},{35,56.4},{35.2,58.4},{35.4,59.4},{35.4,59.8},{35.6,56.8},{35.6,59.4},{35.6,59.6},{35.8,58.4},{36.6,56.8},{37.2,59.2},{38,59.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218343] = {
            [npcKeys.name] = "Leprous Defender",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218344] = {
            [npcKeys.name] = "Explosive Egg",
            [npcKeys.minLevel] = 42,
            [npcKeys.maxLevel] = 42,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218345] = {
            [npcKeys.name] = "Gnomeregan Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218349] = {
            [npcKeys.name] = "Walking Bomb",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218386] = {
            [npcKeys.name] = "Breath Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218434] = {
            [npcKeys.name] = "[DNT] Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218460] = {
            [npcKeys.name] = "[DNT] Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218461] = {
            [npcKeys.name] = "[DNT] Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218462] = {
            [npcKeys.name] = "[DNT] Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218537] = {
            [npcKeys.name] = "Mekgineer Thermaplugg",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218538] = {
            [npcKeys.name] = "STX-96/FR",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218571] = {
            [npcKeys.name] = "Shade of Eranikus",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218606] = {
            [npcKeys.name] = "Lumbering Dreamwalker",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218610] = {
            [npcKeys.name] = "Test Creature",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218624] = {
            [npcKeys.name] = "Atal'alarion",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218627] = {
            [npcKeys.name] = "Pillar Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218683] = {
            [npcKeys.name] = "Wendel Mathers",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218690] = {
            [npcKeys.name] = "Kha'damu",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{27.2,59},{27.4,62.4},{28.6,61.2},{29.6,54},{29.6,57.6},{29.8,56.6},{30,48.6},{30.2,49.6},{30.4,16.4},{30.4,48},{30.4,64.8},{30.6,64.2},{30.8,14},{30.8,46.2},{31,16},{31,70.2},{31.2,14.6},{31.2,46.8},{31.2,48.4},{31.4,17.6},{31.4,48.6},{31.4,52.8},{31.4,54.4},{31.4,58.8},{31.6,48.4},{32,51.2},{32,60.2},{32.2,39.2},{32.2,49.2},{32.2,52.2},{32.4,15.4},{32.4,16.4},{32.4,17.2},{32.4,49.6},{32.4,53.4},{32.4,54},{32.4,57.4},{32.4,58.4},{32.4,58.8},{32.4,61.2},{32.4,73},{32.6,13.2},{32.6,60.6},{33,9.6},{33,11.2},{33,49.2},{33,50.2},{33,59.2},{33,59.6},{33,62},{33.2,8.8},{33.2,14.2},{33.2,15.2},{33.2,15.6},{33.2,16.6},{33.2,18.2},{33.2,18.8},{33.2,57},{33.2,57.6},{33.4,50.6},{33.4,51.8},{33.4,52.8},{33.4,54.2},{33.4,55.4},{33.4,55.6},{33.6,12.2},{33.6,13.8},{33.6,49.8},{33.6,51.4},{33.6,51.6},{33.6,53.8},{33.6,55.2},{33.6,56.8},{33.6,74.4},{33.8,9.4},{33.8,16.4},{33.8,17.8},{33.8,52.6},{34,13.2},{34,14.8},{34,48.4},{34,48.6},{34,55.6},{34.2,7.6},{34.2,19.8},{34.4,16.8},{34.4,18.6},{34.4,58.8},{34.6,12.4},{34.6,51},{34.6,54.4},{34.8,13.2},{34.8,18.4},{34.8,50},{34.8,52.6},{34.8,58.2},{35,13.8},{35,19.6},{35,54.6},{35.2,14.8},{35.2,16.6},{35.4,16.4},{35.4,19},{35.4,21},{35.4,49},{35.4,55.8},{35.6,13.2},{35.6,19.8},{35.6,48.8},{35.6,56.8},{36,54.4},{36,54.6},{36,56.4},{36.2,18.6},{36.2,64.4},{36.4,15.6},{36.4,18.2},{36.4,48.4},{36.6,16.2},{36.6,54.8},{36.8,18.2},{36.8,64.8},{36.8,67.6},{36.8,79.6},{37.2,18.8},{37.2,48.6},{37.2,56},{37.2,62},{37.2,66.4},{37.4,43.8},{37.4,45.8},{37.4,47.2},{37.4,47.8},{37.6,17.4},{37.6,47},{37.6,47.6},{37.6,56.2},{37.6,61.4},{37.8,45.4},{38,19.2},{38,44.2},{38,46.2},{38.2,42.8},{38.2,56.8},{38.2,58.4},{38.2,60.2},{38.2,62.8},{38.4,42.4},{38.4,59},{38.4,62},{38.6,14.4},{38.6,42},{38.6,57.4},{38.6,58.4},{38.6,61.6},{38.8,16.2},{38.8,18.6},{38.8,43.2},{38.8,43.6},{38.8,45},{38.8,56.4},{38.8,59.2},{38.8,60.8},{39,40.8},{39,46.2},{39,60},{39.2,15},{39.2,39.6},{39.4,17.8},{39.6,17.8},{39.6,38.6},{39.6,59.8},{39.8,28.4},{39.8,36},{39.8,60.8},{40,59.4},{40.2,37.8},{40.4,58.4},{40.6,13.2},{40.6,37.2},{40.6,58.2},{40.8,38.6},{40.8,59},{41,37.6},{41.2,12},{41.2,59.8},{41.4,21.2},{41.4,35},{41.4,35.8},{41.6,39.6},{42,32.4},{42,38.2},{42,39.2},{42.2,33.6},{42.4,17.4},{42.4,35.4},{42.4,36.4},{42.4,36.6},{42.6,34},{42.6,36.4},{42.6,36.6},{42.8,21.2},{42.8,38.2},{43,38.8},{43.2,20.4},{43.2,35.2},{43.6,33.2},{43.6,36},{43.6,37.4},{43.6,38.4},{43.8,35.2},{44,20.6},{44.2,31.8},{44.4,13.8},{44.4,24},{44.4,25.6},{44.4,34.2},{44.6,19.6},{44.6,24.6},{44.6,38},{44.8,21.6},{44.8,34.2},{44.8,35.2},{45,23.4},{45,35.6},{45.2,20.6},{45.2,33},{45.4,13.8},{45.4,24},{45.4,32.4},{45.6,14.2},{45.6,31.6},{45.6,34.8},{45.8,24},{45.8,24.8},{45.8,26.6},{46,31},{46.2,19.6},{46.2,35.8},{46.4,14.8},{46.4,15.6},{46.4,17},{46.4,19.2},{46.4,23},{46.4,28.4},{46.6,14},{46.6,15.2},{46.6,27.2},{46.8,23.8},{46.8,30.6},{47,20.4},{47,22.6},{47.2,21.4},{47.2,28.4},{47.2,29.8},{47.2,32.2},{47.4,13.4},{47.4,16.4},{47.4,16.8},{47.4,18.4},{47.4,19.4},{47.4,21.6},{47.6,16.4},{47.6,16.8},{47.6,30.2},{47.6,32.8},{47.6,33.8},{47.8,13.8},{47.8,21.2},{47.8,22.8},{47.8,32},{48,18.8},{48,19.6},{48.2,12.8},{48.2,15},{48.2,17.8},{48.6,14.6},{48.6,15.6},{48.6,17.2},{48.6,29},{48.6,29.8},{48.8,19.6},{49.2,18.4},{49.2,18.6},{49.2,22},{49.2,33.4},{49.4,21},{49.6,14.8},{49.6,17},{49.6,18.6},{49.6,20},{49.6,21},{49.8,18},{50,21.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218706] = {
            [npcKeys.name] = "Test Visual",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218718] = {
            [npcKeys.name] = "Ogom the Wretched",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218721] = {
            [npcKeys.name] = "Jammal'an the Prophet",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218776] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218792] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218813] = {
            [npcKeys.name] = "Swamp of Sorrows Dart Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218819] = {
            [npcKeys.name] = "Festering Rotslime",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218868] = {
            [npcKeys.name] = "Mijan",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218869] = {
            [npcKeys.name] = "Death's Head Geomancer",
            [npcKeys.minLevel] = 37,
            [npcKeys.maxLevel] = 37,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{55.8,41.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218870] = {
            [npcKeys.name] = "Death's Head Necromancer",
            [npcKeys.minLevel] = 37,
            [npcKeys.maxLevel] = 37,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{53.4,41},{54,41.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218871] = {
            [npcKeys.name] = "Death's Head Cultist",
            [npcKeys.minLevel] = 37,
            [npcKeys.maxLevel] = 37,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{53.6,40.8},{54.8,40.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218873] = {
            [npcKeys.name] = "Death's Head Warrior",
            [npcKeys.minLevel] = 36,
            [npcKeys.maxLevel] = 36,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{53.4,40.8},{54.2,40.8},{54.8,40.8},{55,40.4},{55,41.6},{55.6,41.6},{55.8,41.4},{56.8,43}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218891] = {
            [npcKeys.name] = "Skeletal Servant",
            [npcKeys.minLevel] = 34,
            [npcKeys.maxLevel] = 34,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{53.2,41.2},{53.8,40.4},{54.2,41.2},{54.4,41.8},{55,40.8},{55.2,41.6},{55.6,42.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218908] = {
            [npcKeys.name] = "Scarlet Crusade Assassin",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218920] = {
            [npcKeys.name] = "Agent Keanna",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 41,
            [npcKeys.spawns] = {
                [41] = {{52,34.2},{52,34.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {80098,80120,80147,80148,80149,80150,80151,80152,86966,86969,86970},
            [npcKeys.questEnds] = {80098,80120,80147,80148,80149,80150,80151,80152,86965,86968,86969,86970},
        },
        [218922] = {
            [npcKeys.name] = "Hukku",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218930] = {
            [npcKeys.name] = "Deadwind Steed",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218931] = {
            [npcKeys.name] = "Dark Rider",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 3,
            [npcKeys.spawns] = {
                [3] = {{57.4,53.2},{57.6,53.4},{57.6,54.6},{57.8,54.2},{58.6,54}},
                [8] = {{68.6,27.4},{68.8,27.8},{68.8,29.6},{69,28.8},{69.6,28.6}},
                [10] = {{22.2,46.8},{22.8,46.8},{22.8,47.6},{23.2,46.2}},
                [17] = {{52,36.6},{52.2,36.4},{52.6,37}},
                [41] = {{42.4,27.4},{42.4,27.8},{42.6,27.4},{42.6,27.6},{42.8,28.6},{43.2,26.2},{44.4,29.2},{44.6,29.6},{44.8,29.4}},
                [45] = {{60.4,40.2},{60.4,40.6},{60.6,39.4},{60.6,39.8}},
                [405] = {{64.4,24.4},{65,23.4},{65.2,25},{65.2,25.6},{65.4,24.4},{65.6,24.4},{65.6,24.8},{66,22.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218935] = {
            [npcKeys.name] = "Walking Bomb",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218969] = {
            [npcKeys.name] = "STX-96/FR",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218970] = {
            [npcKeys.name] = "STX-97/IC",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218971] = {
            [npcKeys.name] = "STX-97/IC",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218972] = {
            [npcKeys.name] = "STX-98/PO",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218973] = {
            [npcKeys.name] = "STX-98/PO",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218974] = {
            [npcKeys.name] = "STX-99/XD",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218975] = {
            [npcKeys.name] = "STX-99/XD",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219110] = {
            [npcKeys.name] = "Incendiary Bomb",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219111] = {
            [npcKeys.name] = "Frost Bomb",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219112] = {
            [npcKeys.name] = "Radioactive Bomb",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219113] = {
            [npcKeys.name] = "Radiation Leak",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219177] = {
            [npcKeys.name] = "Omen",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 493,
            [npcKeys.spawns] = {
                [493] = {{44.4,34.2},{44.8,35},{44.8,36.4},{45,39.4},{47.4,39.4},{47.6,43},{47.8,69.4},{48.4,41.8},{50.8,34},{51.2,37.2},{51.6,36},{51.8,35.2},{55.8,65.6},{59.2,58.6},{59.8,67},{61.2,66},{61.8,65.8},{63.2,62.2},{63.6,62.6},{63.8,60.6},{64.4,60.4},{64.4,62.4},{64.6,60.6},{65,61.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219199] = {
            [npcKeys.name] = "Minion of Omen",
            [npcKeys.minLevel] = 42,
            [npcKeys.maxLevel] = 42,
            [npcKeys.zoneID] = 493,
            [npcKeys.spawns] = {
                [493] = {{57.4,66.2},{57.8,66.2},{59.2,66.2},{61,66},{61,67.4},{61.4,44.8},{61.8,66},{62.4,64.8},{62.6,65.2},{62.8,45.2},{63.2,63.4},{63.4,50.2},{63.4,63.8},{63.6,65.2},{63.8,62.8},{64.2,63.6},{64.4,60.6},{64.4,62.2},{64.4,65.8},{64.6,60.6},{64.6,62.2},{64.8,56.2},{65,46.6},{65,59.6},{65,63},{65.2,46.2},{65.4,51.6},{65.4,57.4},{65.4,59.2},{65.4,64.6},{66,51.2},{66,56.8},{66,58},{66,62.8},{66.2,52},{66.2,53},{66.4,55.6},{66.8,56.6},{67.2,56.4},{67.8,55}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219624] = {
            [npcKeys.name] = "Test Boss 2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219659] = {
            [npcKeys.name] = "High Tinker Mekkatorque",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 1537,
            [npcKeys.spawns] = {
                [1537] = {{68,48.4},{68.2,48.6},{68.8,49},{69.2,47.4},{69.6,49.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219663] = {
            [npcKeys.name] = "Nogg",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{75.4,24.8},{75.8,25.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219704] = {
            [npcKeys.name] = "Gurgthock",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219762] = {
            [npcKeys.name] = "SoD Test Dummy 40 DNT",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219791] = {
            [npcKeys.name] = "Tim's Stalker 01",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219822] = {
            [npcKeys.name] = "Chained Spirit",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{22.6,15.4},{30.2,73.2},{33.6,62.4},{33.8,52.6},{37,68},{37.4,64},{38.4,8.8},{39,45.8},{39.4,18},{44.4,25},{44.6,25},{45.4,13.4},{47.6,34.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219986] = {
            [npcKeys.name] = "Spirit Wolf",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{52,27.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219999] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220007] = {
            [npcKeys.name] = "Viscous Fallout",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220064] = {
            [npcKeys.name] = "Frozen Orb",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220072] = {
            [npcKeys.name] = "Electrocutioner 6000",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220075] = {
            [npcKeys.name] = "[DNT] Teleporter Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220076] = {
            [npcKeys.name] = "Witch Doctor Zum'rah",
            [npcKeys.minLevel] = 46,
            [npcKeys.maxLevel] = 46,
            [npcKeys.zoneID] = 1176,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220077] = {
            [npcKeys.name] = "[DNT] Teleporter Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220142] = {
            [npcKeys.name] = "Titanzilla",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220170] = {
            [npcKeys.name] = "King Knuckles",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220174] = {
            [npcKeys.name] = "Gamma-Ra",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220178] = {
            [npcKeys.name] = "Pterodan",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220179] = {
            [npcKeys.name] = "Mekatron",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220358] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220396] = {
            [npcKeys.name] = "Zul'Farrak Concoction Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220833] = {
            [npcKeys.name] = "Dreamscythe",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220864] = {
            [npcKeys.name] = "Weaver",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220908] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220929] = {
            [npcKeys.name] = "Josh's Kill Credit Creature 2 - Frix Xizzix",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220930] = {
            [npcKeys.name] = "Frix Xizzix",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{81.4,42.4},{81.4,42.6},{81.6,42.4},{81.6,42.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220931] = {
            [npcKeys.name] = "Nightmare Thorns 01",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220932] = {
            [npcKeys.name] = "Nightmare Thorns 02",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220933] = {
            [npcKeys.name] = "Nightmare Thorns 03",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220934] = {
            [npcKeys.name] = "Nightmare Thorns 04",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220935] = {
            [npcKeys.name] = "Nightmare Thorns 05",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220936] = {
            [npcKeys.name] = "Nightmare Thorns 06",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220937] = {
            [npcKeys.name] = "Nightmare Thorns 07",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220942] = {
            [npcKeys.name] = "Nightmare",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220984] = {
            [npcKeys.name] = "Fizbuz Mithril",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{51.6,27.4},{51.6,27.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81682,81877},
            [npcKeys.questEnds] = {81801,81877},
        },
        [221165] = {
            [npcKeys.name] = "Rope Climber",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221168] = {
            [npcKeys.name] = "Dire Wolf Alpha",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{45,58.4},{45,62.2},{45.2,62.6},{45.4,59.4},{45.4,59.6},{45.6,53.2},{45.6,59.4},{46,57.6},{46.2,44.8},{46.2,54.4},{46.2,54.6},{46.2,59.6},{46.4,37.4},{46.4,38.4},{46.4,39},{46.4,39.8},{46.4,40.8},{46.4,41.6},{46.4,46.4},{46.4,47.4},{46.4,47.8},{46.4,57.4},{46.6,38.4},{46.6,38.8},{46.6,39.8},{46.6,40.8},{46.6,41.6},{46.6,47.4},{46.6,47.6},{46.6,55.4},{46.6,57.6},{46.6,59.4},{46.8,43.8},{46.8,57.2},{47,45.2},{47,46.4},{47,56.4},{47.2,60},{47.4,62.4},{47.4,62.8},{47.4,63.6},{47.6,63.4},{48.8,64.4},{48.8,65},{50.8,60.8},{54.2,66.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221169] = {
            [npcKeys.name] = "Black Widow Broodmother",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{44.4,62.8},{44.6,62.8},{44.8,62.4},{45.2,52.8},{45.6,53.2},{46.2,54.4},{46.4,38.4},{46.4,38.6},{46.4,55.2},{46.4,55.6},{46.4,59.4},{46.4,59.6},{46.6,55.4},{46.6,55.6},{46.8,59.4},{47,43.4},{47,44.4},{47,44.6},{47,56.6},{47.2,45.8},{47.2,60.2},{47.2,60.6},{47.4,46.8},{47.4,47.6},{49,57.4},{52,71.4},{52,72}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221170] = {
            [npcKeys.name] = "Uprooted Gloomwood",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{44.2,36.4},{44.2,36.6},{44.8,58.4},{45,58.8},{45.6,57.8},{45.8,53.4},{46.2,54.4},{46.4,36.4},{46.4,37},{46.4,37.6},{46.4,38.6},{46.4,39.6},{46.4,42},{46.4,43.4},{46.4,43.6},{46.4,55},{46.4,55.6},{46.4,57.4},{46.4,59.4},{46.4,59.6},{46.6,36.4},{46.6,36.8},{46.6,37.6},{46.6,38.8},{46.6,40.4},{46.6,41.2},{46.6,41.8},{46.6,43},{46.6,55.4},{46.6,55.6},{46.6,59.4},{46.6,59.6},{46.8,43.8},{47,45.2},{47.2,46.4},{47.2,63.6},{47.4,47},{47.4,47.8},{47.4,48.6},{47.4,62.4},{47.4,63.2},{47.6,46.8},{47.6,47.8},{47.6,48.6},{47.8,63},{52.2,67.6},{52.8,68.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221171] = {
            [npcKeys.name] = "Nightmare Runner",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{55.4,71.4},{55.4,72.4},{55.4,72.6},{56,72},{56.2,71.2},{56.2,72.8},{56.6,71.8},{57.2,71.4},{58,71},{58.2,70.2},{58.6,71.2},{59.2,71.8},{59.2,74.8},{59.6,72.4},{59.8,72.8},{60.4,70},{60.4,71.2},{60.4,73.8},{60.6,70},{60.6,71},{60.6,73.6},{61,72.6},{61,75.4},{61,75.6},{61.2,69},{61.2,71.8},{61.4,68.4},{61.6,68.8},{61.6,71},{61.6,71.6},{61.6,72.8},{61.8,75},{62.2,74.4},{62.4,68.2},{63,71.4},{63,75.4},{63,76},{63.2,67},{63.2,69.2},{63.2,72.2},{63.2,73.8},{63.4,68.4},{63.4,69.8},{63.4,73},{63.6,69.8},{64,67.4},{64,67.6},{64,73},{64,75.2},{64.2,65.8},{64.2,71.4},{64.2,71.6},{64.4,68.8},{65,70.4},{65.2,68.4},{65.2,68.6},{65.2,70.6},{65.2,72.2},{65.2,72.8},{65.4,65.8},{65.4,67.4},{65.4,74.4},{65.4,75},{65.4,76.2},{65.4,76.8},{65.6,66},{65.6,69.4},{65.6,74.2},{65.6,75.2},{65.8,68.4},{65.8,70},{66,73.2},{66,76.4},{66,77.4},{66.2,71},{66.2,72.2},{66.4,66.8},{66.6,66.4},{66.6,66.6},{66.6,68.2},{66.6,71.6},{66.8,70.4},{66.8,75},{67,70.8},{67.2,69.2},{67.2,76.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221172] = {
            [npcKeys.name] = "Nightmare Weaver",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{61,75.4},{61,75.6},{62.6,65.4},{62.8,65.6},{62.8,71.4},{62.8,71.6},{63.8,67.4},{63.8,73},{64,67.6},{64,75.4},{64,75.6},{64.2,71.4},{64.2,71.6},{64.4,65.8},{64.4,73.8},{64.6,74},{65,70.6},{65,72.4},{65,73},{65.4,66},{65.4,67.4},{65.4,67.6},{65.4,69.4},{65.4,69.6},{65.4,75},{65.6,66},{65.6,67.4},{65.6,67.6},{65.6,69.4},{65.8,75.4},{66,70.2},{66,70.8},{66,75.8},{66.8,65.4},{66.8,65.8},{67.6,67.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221173] = {
            [npcKeys.name] = "Stitched Patroller",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{34.8,73.4},{34.8,75},{35.4,72.4},{36.2,72.4},{36.6,72.2},{38.2,70.4},{38.4,70.6},{39,70.6},{39.2,70},{39.6,70.2},{40.4,70.6},{41,69.8},{41.2,68.8},{41.4,64},{41.8,68.6},{41.8,69.8},{42.2,64},{42.2,66},{42.4,65.2},{42.8,64.2},{42.8,64.6},{42.8,67},{42.8,68.4},{43.2,66.2},{44,65.4},{44,67},{44.2,70.2},{44.2,72},{44.4,65.6},{44.6,65.8},{45,52.2},{45,65.4},{45.2,58.4},{45.4,59.6},{45.4,66.6},{45.6,57.8},{45.6,59.2},{45.6,64.4},{45.6,65.4},{46.2,57.2},{46.2,62.6},{46.2,66.2},{46.8,62.2},{46.8,66.8},{47,60},{47,64.4},{47.2,65.4},{47.4,66.2},{47.6,65.4},{47.8,63.8},{47.8,66},{47.8,67.6},{49,65},{49.2,64.2},{49.4,66},{49.4,66.8},{49.6,66.6},{50,66.2},{50,67.6},{50.6,66.4},{50.6,66.6},{50.8,69.8},{51.4,67.6},{51.8,67.2},{52.2,67.6},{52.4,68.6},{52.8,68.2},{53.2,68.8},{53.4,70.6},{53.6,69.6},{53.8,69},{54.4,64.2},{54.4,68.2},{54.8,69},{55,67},{55.4,68.4},{56,70.4},{56.2,67.2},{56.4,67.6},{56.6,66.8},{57.2,66.4},{57.8,65.2},{58,66.2},{58.2,67},{58.2,68.2},{58.6,69},{58.8,65.4},{59.2,63.4},{59.2,64},{59.6,63.6},{60.2,62.6},{60.6,62.4},{60.6,62.6},{62.8,61},{63.2,57},{63.2,66.8},{64,67.6},{65.2,60.2},{66.2,61},{66.4,60.2},{66.6,61},{67,60},{68.6,60.8},{69.4,60.4},{69.8,59.4},{70.2,60.2},{70.6,60.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221174] = {
            [npcKeys.name] = "Deranged Ogre",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{32,70.2},{32.4,69.4},{32.6,69.4},{33.2,67.8},{33.2,69.6},{33.4,72.4},{33.4,73.2},{33.4,76.2},{33.6,70},{33.6,73.4},{34,73.6},{34.2,77.4},{34.4,69.2},{34.4,71.4},{34.4,71.6},{34.4,75.4},{34.4,75.6},{34.4,77.8},{34.6,69.4},{34.6,71.4},{34.6,75.4},{34.6,75.6},{34.8,70.4},{34.8,71.6},{34.8,73.4},{34.8,78},{35,74.4},{35.2,78.8},{35.4,79.6},{35.6,71.4},{35.6,77.8},{35.6,80.4},{35.8,71.8},{36,69.6},{36.2,69},{36.4,77.4},{36.4,81.4},{36.4,81.6},{36.4,83.6},{36.6,77.4},{36.6,80.4},{36.6,81.4},{36.8,77.8},{36.8,78.8},{37,82.4},{37,82.8},{37.2,70.4},{37.2,70.8},{37.2,71.8},{37.2,84.2},{37.4,84.6},{37.6,70.6},{37.6,84.4},{37.8,70.4},{38.2,72},{38.6,71.6},{38.6,74.2},{39,75.6},{39.2,73},{39.4,70.2},{39.8,70.6},{39.8,73.4},{40,73.6},{40.4,69.4},{40.4,69.8},{40.6,69.6},{41,69.2},{41.8,68.8},{42.4,68.4},{42.6,68.2},{43.4,67.4},{43.6,67.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221175] = {
            [npcKeys.name] = "Demented Fire Weaver",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{31.4,67.8},{32,70},{32.6,67.6},{33.4,70},{33.4,75.6},{33.8,70.2},{33.8,74.8},{34,76.6},{34.4,71.4},{34.4,73.2},{34.4,73.6},{34.4,75.8},{34.4,77.8},{34.6,71.4},{34.6,71.6},{34.6,75.6},{34.6,77.8},{34.8,73.4},{34.8,73.6},{35.2,79.2},{35.4,79.6},{35.6,78},{35.6,80.2},{35.8,81},{36.2,72.4},{36.4,72.6},{36.4,77.4},{36.6,72.4},{36.6,72.6},{36.6,77.4},{36.6,79.8},{36.6,84.2},{36.8,77.8},{36.8,78.8},{36.8,82},{36.8,84.6},{37,83},{37.4,68.4},{37.6,79.4},{37.6,84.2},{38.4,74.2},{38.6,74},{39.4,70},{39.4,70.8},{39.6,70},{41,73.8},{41.2,73.4},{42.4,74},{43,74.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221176] = {
            [npcKeys.name] = "Nightterror Whelp",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{35.6,73.4},{36.4,71},{36.6,71.8},{37.8,70.6},{38.4,71.8},{40.8,73.8},{41.2,70.4},{43.4,69.6},{44,72.2},{44.2,66.8},{44.2,68},{44.2,69},{44.4,65.4},{44.4,71.2},{44.4,73.2},{44.6,76.6},{45.2,65.8},{45.2,71.4},{45.2,73.4},{45.2,74.6},{45.4,68},{45.4,70.4},{45.4,72.2},{45.4,73.8},{45.6,67.8},{45.8,77.6},{46,57.4},{46,69.2},{46,72.2},{46,72.8},{46.2,71},{46.2,73.6},{46.2,75.8},{46.4,59.4},{46.4,70.2},{46.4,74.8},{46.6,55.8},{46.6,71.4},{46.8,72.2},{47,74.6},{47,78.4},{47.2,65.2},{47.2,68.8},{47.2,76.6},{47.4,63},{47.4,64.2},{47.4,66.4},{47.4,67.4},{47.4,68.4},{47.4,70.4},{47.4,73.2},{47.4,73.8},{47.4,75.8},{47.6,67.4},{47.6,68.4},{47.6,68.8},{47.6,70.6},{48,66.2},{48,70.4},{48.2,76.6},{48.4,72.4},{48.4,73.2},{48.4,73.6},{48.4,75},{48.4,76.2},{48.6,66.4},{48.6,67.4},{48.6,70.4},{48.6,71.2},{48.6,72.4},{48.6,73},{48.8,74.4},{49,68.4},{49,68.6},{49.2,76.8},{49.2,78.6},{49.4,75},{49.4,75.6},{49.4,78.2},{49.6,70.8},{49.6,74.4},{49.6,75.2},{49.8,67.4},{49.8,70.4},{49.8,77.6},{50,68.4},{50,73.2},{50,79},{50.2,66.4},{50.2,69.4},{50.2,72.4},{50.2,76.4},{50.4,76.6},{50.6,67.2},{50.6,68.2},{50.6,72},{50.6,72.8},{50.6,74.4},{50.6,75.8},{50.6,77},{50.8,69.4},{50.8,70.4},{50.8,71.2},{50.8,75.4},{50.8,77.6},{50.8,78.6},{51,66.4},{51.6,69.2},{51.6,71.6},{51.6,73.4},{51.6,77.4},{51.6,77.6},{51.8,69.8},{51.8,74},{51.8,74.6},{52.2,78.6},{52.4,75.6},{52.6,74},{52.6,75.4},{52.6,75.6},{52.6,77.2},{52.6,78.8},{52.8,73},{53.2,68.8},{53.2,72.4},{53.6,77},{53.8,73.2},{54,75.8},{54,78.4},{54.2,72.4},{54.2,74.4},{54.2,75},{54.6,74},{54.6,75.6},{55,72.8},{55,75.4},{55.2,68.4},{55.2,72.4},{55.2,76.8},{55.4,71.4},{55.6,69.2},{55.6,70.2},{55.6,71.2},{55.8,72.8},{56.2,74.4},{56.4,72.2},{56.8,66.6},{56.8,72},{57,71.2},{57.8,71.6},{58.2,71},{58.2,72.6},{58.8,71.2},{58.8,73.8},{59,75},{60,73.2},{60.4,63},{60.6,72.4},{60.6,73.6},{60.8,75.4},{62.2,71.8},{63.6,69},{64.8,70},{66.2,76}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221200] = {
            [npcKeys.name] = "Wyrmkin Terrorwalker",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{47.4,69.4},{47.4,69.8},{47.4,72.4},{47.4,72.6},{47.6,72.6},{47.8,70.4},{47.8,72.4},{48,70.6},{48.2,73.6},{48.2,76.4},{48.6,72},{48.6,73},{48.8,74.4},{49.2,76.4},{49.2,76.6},{49.4,71.2},{49.4,75},{49.6,75.4},{50.2,70.2},{50.2,78.6},{50.4,70.6},{50.4,73.4},{50.4,73.8},{50.4,76.4},{50.4,76.6},{50.4,78.2},{50.6,70.4},{50.6,70.6},{50.6,72},{50.6,73.4},{50.6,73.8},{50.6,76.8},{50.6,78},{54.4,73},{54.8,72.8},{55.4,72.4},{55.6,72.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221201] = {
            [npcKeys.name] = "Rope Climber",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221204] = {
            [npcKeys.name] = "Ylanthrius",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{44.2,68.2},{44.2,71.2},{44.2,75.6},{44.4,71.6},{44.8,73.4},{45,69.2},{45,70.4},{45.2,64.6},{45.2,66},{46,70.2},{46,73.8},{46.2,73.2},{46.2,75},{46.4,71.2},{46.4,72.2},{46.6,72.2},{47,76.4},{47.2,69.4},{47.2,69.8},{47.2,70.6},{47.2,74},{47.2,74.6},{47.4,73.2},{47.4,76.6},{47.6,75.8},{47.6,77.6},{47.8,69.6},{47.8,70.6},{47.8,76.6},{48.2,64.2},{48.2,73.4},{48.2,78.6},{48.4,72.4},{48.4,74},{48.4,74.8},{48.8,71.2},{48.8,72},{48.8,73.4},{48.8,74.6},{48.8,75.6},{48.8,76.6},{49,74.4},{49.6,71.4},{49.6,72.8},{49.6,75.2},{49.6,75.6},{49.8,74.4},{50,69.4},{50,77.6},{50.4,70.4},{50.4,72},{50.4,76.6},{50.6,73.4},{50.6,73.6},{50.6,76.8},{50.8,76.4},{51,70.8},{51.2,75.4},{51.6,74.8},{51.8,74},{52.4,72.6},{52.8,76.2},{53,72.8},{53.4,74.2},{53.4,74.6},{53.6,72},{56.8,73.6},{57.2,71.6},{58,71},{61.4,73}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221206] = {
            [npcKeys.name] = "Vvarc' Zul",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{37,83.4},{37.4,84.2},{37.4,84.6},{37.6,84.4},{37.6,84.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221207] = {
            [npcKeys.name] = "Amokarok",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{65.6,75.2},{66,76.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221208] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221210] = {
            [npcKeys.name] = "Kroll Mountainshade",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{65.6,67.4},{66,69.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221215] = {
            [npcKeys.name] = "Alara Grovemender",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{49,77.4},{49,77.6},{65.6,67.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221216] = {
            [npcKeys.name] = "Elenora Marshwalker",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{32.4,69.4},{32.4,69.6},{32.6,69.4},{32.6,69.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221220] = {
            [npcKeys.name] = "Dreamwarden Amalia",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{50.6,77}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221221] = {
            [npcKeys.name] = "Dreamwarden Dorilar",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{66.2,76}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221222] = {
            [npcKeys.name] = "Dreamwarden Thalinar",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{36.6,83.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221223] = {
            [npcKeys.name] = "Duskblaze Shadowstalker",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{44.2,39},{44.2,41.2},{44.2,41.8},{44.4,38.4},{44.6,40.4},{44.6,40.8},{45,39.2},{45.2,38.4},{45.4,43.2},{45.4,51.2},{45.6,51.2},{45.8,43.6},{46,50.4},{46.4,36.4},{46.4,36.6},{46.4,38.2},{46.4,38.6},{46.4,40.4},{46.4,40.6},{46.4,41.8},{46.4,42.6},{46.6,36.4},{46.6,36.6},{46.6,38},{46.6,39},{46.6,39.8},{46.6,41.2},{46.6,42.2},{46.6,42.8},{46.8,43.8},{47,45},{47,49.6},{47.2,45.6},{47.4,46.8},{47.4,47.8},{47.4,49},{47.6,37.6},{47.6,41.6},{47.8,37.4},{47.8,41.2},{48.6,40.6},{48.8,40.4},{49.4,38.8},{49.6,38.4},{49.6,38.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221226] = {
            [npcKeys.name] = "Firestarter Imp",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{42.8,38.8},{43,37.6},{43.2,43.6},{43.4,35.2},{43.4,36.2},{43.4,36.6},{43.6,34.2},{43.6,35.4},{43.6,36.6},{43.6,41.6},{43.8,35.8},{43.8,43},{44,39.2},{44.2,38.2},{44.4,40.4},{44.4,40.6},{44.6,34.6},{44.8,40.4},{44.8,40.8},{44.8,45.6},{45,42},{45,42.6},{45.2,39.2},{45.2,52},{45.4,36.2},{45.4,37},{45.4,37.8},{45.4,43.6},{45.4,50.6},{45.6,35.4},{45.6,36.4},{45.6,36.8},{45.6,40.6},{45.6,50.6},{45.8,39.4},{45.8,40},{45.8,46.4},{45.8,50.4},{46.2,43.8},{46.2,44.6},{46.4,37.8},{46.4,41.6},{46.4,42.6},{46.4,47},{46.4,48.6},{46.6,39.4},{46.6,42.4},{46.6,50},{46.8,40},{46.8,42.8},{46.8,43.8},{46.8,44.6},{46.8,56.4},{47,40.6},{47.2,45.6},{47.2,47.6},{47.2,49.2},{47.4,36.4},{47.4,37.4},{47.4,37.6},{47.4,46.8},{47.6,37.6},{47.6,39.2},{47.6,40},{47.6,45},{47.6,45.6},{47.6,48.4},{47.8,44.2},{48,37.2},{48.2,35.4},{48.2,42.4},{48.4,36},{48.4,41.4},{48.6,35.2},{48.8,35.8},{48.8,36.6},{48.8,37.8},{48.8,44},{49,31.2},{49,32.8},{49,41.2},{49,41.6},{49.2,32},{49.2,40.2},{49.2,43.2},{49.4,33.8},{49.4,39.2},{49.6,32.2},{49.6,34},{49.6,36},{49.6,40.4},{49.6,41.4},{49.6,41.6},{49.6,44},{49.8,31},{49.8,32.6},{49.8,38.4},{49.8,42.6},{50,38.8},{50.6,42.2},{50.6,43.2},{50.8,40.4},{51.4,43.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221227] = {
            [npcKeys.name] = "Nightmare Hound",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{42.4,38.4},{42.6,34.8},{43,37.8},{43.4,38.6},{43.4,41},{43.4,42},{43.4,42.6},{43.8,38.4},{44,37.4},{44,41.6},{44.2,40},{44.2,43.6},{44.4,35.8},{44.4,39.4},{44.4,41.4},{44.4,42.6},{44.4,44.6},{44.6,38.4},{44.8,36.8},{44.8,40.8},{45,42.4},{45,42.6},{45.2,44.6},{45.2,51.6},{45.4,39.4},{45.4,40},{45.4,43.6},{45.4,51.2},{45.4,53},{45.6,51.2},{45.8,43.2},{46,48.6},{46,50.4},{46.2,45.6},{46.2,47.4},{46.2,54.2},{46.4,36},{46.4,37.2},{46.4,38.2},{46.4,38.8},{46.4,40.2},{46.4,40.6},{46.4,42},{46.4,43.6},{46.4,44.8},{46.4,48.2},{46.6,36.4},{46.6,37.4},{46.6,38.2},{46.6,38.6},{46.6,40.2},{46.6,41.2},{46.6,41.6},{46.6,43},{46.6,50},{46.6,55.6},{47,44.6},{47.2,44.2},{47.2,45.6},{47.2,46.8},{47.4,47.6},{47.4,49},{47.6,42.6},{47.6,44},{47.6,45.2},{47.6,46},{47.6,47.4},{47.6,48},{47.6,48.8},{47.8,35.8},{47.8,38},{47.8,39},{48,35.4},{48,40.4},{48.2,37.4},{48.2,40.8},{48.4,41.8},{48.6,36.2},{48.6,40.2},{48.6,41.2},{48.8,37},{48.8,38.2},{48.8,41.6},{49,42.8},{49,44},{49,44.6},{49.2,34.6},{49.2,39},{49.6,41.6},{49.6,42.6},{49.6,44.4},{49.8,38.8},{49.8,41.2},{50,38},{50.2,39.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221230] = {
            [npcKeys.name] = "Nightmare Grizzly",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79.4,46.4},{79.4,46.8},{79.6,46.4},{79.6,46.6},{80.6,48.8},{81.6,48.4},{81.6,48.6},{82.2,47},{82.8,48.4},{83,48.6},{83,55.4},{83.2,56.4},{83.2,56.6},{83.4,59.8},{83.6,47.6},{83.6,56},{83.6,57.8},{83.8,46.8},{83.8,59.6},{84,45.2},{84,46.4},{84,59.2},{84.6,46.2},{85.2,59.8},{85.4,59.4},{85.6,59.8},{86,46},{86,56.4},{86,56.8},{86.2,45.2},{86.4,48},{86.4,48.6},{86.6,48.4},{86.6,48.6},{86.8,45.6},{87,41.8},{87,44.4},{87,44.6},{87,51.4},{87.2,49.6},{87.2,52},{87.4,41.4},{87.4,58},{87.4,58.6},{87.6,49.4},{87.6,58},{87.6,58.6},{87.8,41.2},{87.8,43.2},{87.8,68.4},{88.4,42.2},{88.6,57.8},{89,42.2},{89,42.6},{89.2,44.4},{89.2,45.8},{89.2,47.2},{89.2,47.6},{89.4,40.4},{89.4,40.8},{89.4,44.8},{89.6,40},{89.6,40.6},{89.6,45},{89.6,47.2},{89.6,47.6},{89.8,38.4},{89.8,38.6},{91,39.4},{91.2,39.6},{91.6,39.6},{92.4,39.2},{92.8,39},{92.8,46.6},{93,40.4},{93.4,38},{93.6,39.6},{93.8,38.4},{93.8,38.6},{94,37.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221257] = {
            [npcKeys.name] = "Deathhorn Stag",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{84.2,45.6},{84.4,45.2},{86.4,46.4},{86.4,46.6},{86.4,54.2},{86.4,57.4},{86.4,57.6},{86.6,46.4},{86.6,46.6},{86.6,57.4},{86.6,57.6},{87,44},{88.2,49.4},{88.8,41},{89.6,44.6},{89.8,44.4},{89.8,50.6},{90,48.4},{90.2,39.8},{90.8,39.8},{91.4,39.2},{91.6,39.2},{92,38},{93.2,37.8},{93.4,39.8},{93.6,39.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221258] = {
            [npcKeys.name] = "Dreamthorn Stalker",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{80.4,45.8},{80.4,46.8},{80.6,45.8},{81.4,54},{82.4,53.4},{82.4,54},{82.4,54.6},{82.6,54.2},{82.6,54.6},{83.2,52},{83.4,46.4},{83.4,48},{83.8,46.4},{84,47.4},{84,47.6},{84.2,44.8},{85,51.4},{85.4,45.4},{85.4,45.6},{85.6,45.4},{85.8,43.4},{86,43.8},{86,46},{86,50.6},{86.2,50.4},{86.4,41.4},{86.4,41.6},{86.6,44.6},{87,40.4},{87,41.4},{87,41.6},{87.4,43.4},{87.4,43.6},{87.6,43.2},{87.6,43.6},{88,42.4},{88.4,64.2},{88.4,64.6},{88.4,67.2},{88.4,67.6},{88.6,68},{88.8,43.6},{89,43},{89,62.8},{89.2,42},{90.4,39.2},{90.4,39.6},{90.6,39},{90.6,39.6},{92.4,35.6},{92.6,35.2},{92.6,35.6},{93.4,36.6},{93.6,40.8},{93.8,36.4},{93.8,36.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221259] = {
            [npcKeys.name] = "Wyrmkin Nightstalker",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{83.4,48.2},{83.6,48},{83.8,45.4},{84,45.6},{84,47.4},{84.8,46},{85.4,44.4},{85.4,44.6},{85.8,46.6},{86,46},{86.2,43},{86.2,44.8},{86.4,42.4},{86.4,44.4},{86.6,44.6},{86.6,47.6},{86.8,43},{86.8,46.4},{86.8,46.6},{87.4,43.8},{87.6,43.4},{87.6,43.6},{88.2,41.4},{88.2,41.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221260] = {
            [npcKeys.name] = "Terror Whelp",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{83.8,47.2},{83.8,47.6},{84.8,46.2},{85.4,45.2},{85.6,45},{86,46},{86.2,44.4},{86.4,41.4},{86.4,41.6},{86.4,43},{86.4,48},{86.6,48},{86.6,49.2},{86.8,42},{86.8,43.4},{86.8,46.2},{86.8,46.6},{87,40.4},{87,40.6},{87,43.8},{87,44.6},{87,50.4},{87,50.6},{88.2,41.4},{88.2,41.6},{88.2,42.6},{88.2,43.6},{88.6,41.6},{88.8,43},{89.2,44.2},{89.2,44.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221261] = {
            [npcKeys.name] = "Dreamfire Betrayer",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{78.2,44.4},{78.2,44.6},{78.4,45.8},{78.6,45.8},{79,50.2},{79.2,46.6},{79.4,51},{79.8,47.2},{80,47.8},{80,49.2},{80.4,50.4},{80.4,50.6},{80.6,48.8},{80.8,46.6},{80.8,49.8},{81.2,51},{81.4,48.4},{81.4,51.6},{81.6,48.4},{81.6,48.6},{81.6,51.4},{81.6,51.8},{82,52.6},{82.4,50},{82.4,53.6},{82.6,50},{82.6,54.4},{82.8,52.2},{82.8,55}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221262] = {
            [npcKeys.name] = "Dreamfire Hellcaller",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{78.2,43.4},{78.2,45.4},{78.2,46.4},{78.2,46.6},{79,45.4},{79,46.2},{79,46.6},{80,50.6},{80.2,47.2},{80.2,48.8},{80.2,49.8},{80.4,46.4},{80.4,48.4},{80.6,46.4},{80.6,46.6},{81,49.2},{81,49.8},{81,50.6},{81.4,48.4},{81.6,48.4},{81.6,48.6},{81.6,52},{81.8,50}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221263] = {
            [npcKeys.name] = "Vengeful Ancient",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{80.2,55},{80.8,54.6},{81.2,54.2},{82,52.4},{82,52.6},{82.2,54.6},{82.4,54.2},{82.4,61.4},{82.4,62.2},{82.4,62.6},{82.6,52.4},{82.6,52.6},{82.6,54.4},{82.6,54.6},{82.6,61},{82.6,61.6},{82.6,62.6},{83,55.8},{83.4,56.6},{83.4,58.4},{83.4,58.6},{83.4,60.2},{83.6,55.8},{83.6,56.6},{83.6,60.4},{83.6,60.6},{83.8,58.4},{83.8,58.8},{84,65.4},{84,65.6},{84.2,62.6},{84.4,50.8},{84.4,62.2},{84.6,61.4},{84.6,62.2},{84.8,56.4},{84.8,62.6},{85,56.8},{85.2,50.4},{85.2,64.8},{85.4,50.6},{85.4,59.4},{85.4,59.6},{85.4,64.4},{85.4,66},{85.4,66.6},{85.6,50.4},{85.6,50.6},{85.6,56.2},{85.6,64},{85.6,65},{85.6,65.6},{85.8,53.8},{85.8,59.4},{85.8,59.6},{86.2,53.2},{86.2,54.6},{86.4,57.4},{86.4,57.6},{86.4,60.8},{86.4,62.2},{86.4,62.6},{86.6,56.4},{86.6,57.4},{86.6,57.8},{86.6,60},{86.6,60.6},{86.6,62.4},{86.6,62.6},{86.8,59.2},{87,52.6},{87,53.6},{87.2,50.6},{87.2,52.2},{87.4,50.4},{87.6,50.4},{87.6,50.6},{87.6,53.6},{87.8,53.4},{88,58.8},{88,61.6},{88.2,58.4},{88.2,61.4},{88.4,55.4},{88.4,56.4},{88.4,56.6},{88.6,55.4},{88.6,56.6},{88.6,58.8},{88.6,61},{88.6,61.6},{88.8,56.2},{89,58.4},{89.2,49.6},{89.4,48.4},{89.4,49.2},{89.4,51.4},{89.4,51.6},{89.4,53.2},{89.4,53.6},{89.6,48.2},{89.6,50.6},{89.6,52.4},{89.6,52.6},{89.8,58},{90.2,49.4},{90.2,49.6},{90.4,53.6},{90.6,50.2},{91,53.8},{91.6,53.8},{92,53.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221264] = {
            [npcKeys.name] = "Dreamharvester",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{83.4,58},{83.6,58},{84.2,56},{84.6,56.4},{85.6,56.8},{88.4,55.4},{88.4,55.6},{88.4,56.8},{88.4,57.8},{88.6,55.6},{89,57.2},{89.2,54.4},{89.2,54.6},{89.4,52.4},{89.4,53.4},{89.4,58},{89.8,57.4},{89.8,58},{90.6,57.4},{91,57.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221265] = {
            [npcKeys.name] = "Larsera",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{85.4,45.4},{85.4,45.6},{86,46},{86.2,44.4},{86.2,44.8},{86.6,44.2},{86.6,44.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221266] = {
            [npcKeys.name] = "Zalius",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{80.8,49.4},{80.8,49.6},{81,50.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221267] = {
            [npcKeys.name] = "Shredder 9000",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{86.4,60.4},{86.4,61.2},{86.4,61.6},{86.4,62.8},{86.6,61.2},{86.8,62.4},{86.8,62.6},{87.6,62.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221268] = {
            [npcKeys.name] = "Doran Dreambough",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{87.2,43.4},{87.2,43.6},{89.4,40.6},{89.6,40.4},{93.8,38.4},{93.8,38.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221269] = {
            [npcKeys.name] = "Maseara Autumnmoon",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{81,50.2},{81.2,50.6},{89.4,40.6},{89.6,40.4},{89.6,40.6},{93.4,38.8},{93.8,38.4},{93.8,38.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221270] = {
            [npcKeys.name] = "Alyssian Windcaller",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{89.6,40.4},{92,54.2},{93.8,38.4},{93.8,38.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221271] = {
            [npcKeys.name] = "Dreamwarden Ellodar",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{83.6,45.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221272] = {
            [npcKeys.name] = "Dreamwarden Mandoran",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{81.4,48.4},{81.4,48.6},{81.6,48.4},{81.6,48.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221273] = {
            [npcKeys.name] = "Dreamwarden Lanaria",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{91.2,58}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221282] = {
            [npcKeys.name] = "Emberspark Dreamsworn",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{92,39},{92.4,38.2},{92.4,40},{92.8,36.2},{92.8,38.6},{93.2,40.4},{93.2,40.6},{93.4,37.2},{93.4,38.2},{93.6,38.2},{94,36.4},{94,37.2},{94,39.2},{94,39.8},{94.4,40.6},{94.6,39},{94.8,37},{94.8,38}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221283] = {
            [npcKeys.name] = "Dreampyre Imp",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{89.6,40.6},{89.8,40.2},{90.4,39.4},{90.8,39.6},{91,38.4},{91,39},{92,39.4},{92,39.6},{92.4,36},{92.4,36.8},{92.6,36.2},{92.8,36.8},{92.8,38.6},{93,38.4},{93.4,39.6},{93.6,39.8},{93.8,38.4},{93.8,38.6},{94,36.4},{94.4,36.6},{94.6,36.4},{94.6,39.4},{94.8,37.4},{94.8,37.6},{94.8,39.8},{95.6,37.4},{95.6,37.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221292] = {
            [npcKeys.name] = "Dreamhunter Hound",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{89.4,40.4},{89.4,40.6},{89.6,40.6},{90.4,39.4},{90.4,39.8},{90.6,39.6},{91.4,38.4},{91.4,38.8},{91.6,38.8},{92.2,37.8},{92.4,37.4},{92.4,39.8},{92.6,38.4},{92.6,39.6},{93.4,37},{93.4,38.8},{93.4,40.6},{93.6,38.8},{93.6,40.6},{93.8,40.2},{94,36.4},{94,37.4},{94,37.6},{94.2,35.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221312] = {
            [npcKeys.name] = "Dreadfeather Hippogryph",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{43.6,52.8},{45,47.6},{47,48},{48.2,41},{50.4,49.8},{52,33.6},{53.6,34.2},{53.8,34.6},{54,32.8},{54.2,35.6},{54.6,52.2},{54.8,36.2},{55.4,34.4},{55.4,35},{55.6,36.4},{55.8,34.8},{55.8,43.8},{56,42.2},{56.2,42.6},{56.2,51.4},{56.4,47.8},{56.6,42.2},{56.6,43.2},{56.6,43.6},{57,31.4},{57.2,33.8},{57.2,35.6},{57.2,40.6},{57.4,35.2},{57.4,38.4},{57.4,38.6},{57.4,40.2},{57.6,33.4},{57.6,38.4},{57.6,40},{57.6,43.4},{58,35.6},{58,42.2},{58.2,33.6},{58.2,35.4},{58.2,41},{58.4,29.8},{58.4,38.6},{58.6,35},{58.6,39},{58.6,40.8},{58.8,29},{59,30.4},{59,32.8},{59,34},{59,35.8},{59,37.4},{59,39.6},{59,41.6},{59.2,32},{59.2,37.8},{59.4,28},{59.4,31.2},{59.6,35.6},{59.6,37.4},{59.6,38},{59.8,25.6},{59.8,31.4},{59.8,39.8},{60,30},{60.2,28.4},{60.2,32.6},{60.2,34.4},{60.2,34.6},{60.2,38.6},{60.4,25.2},{60.4,28.6},{60.4,32.4},{60.4,40.6},{60.6,28.4},{60.6,31.4},{60.6,41.6},{60.8,27},{61,36.8},{61,38.6},{61,43.2},{61.2,30},{61.2,35.6},{61.2,41.4},{61.4,25.2},{61.4,25.8},{61.4,29.2},{61.4,32.4},{61.4,33},{61.4,34.2},{61.4,34.6},{61.4,38.4},{61.4,39.6},{61.6,32.4},{61.6,34.6},{61.6,35.8},{61.6,38.4},{61.6,41},{61.8,25.2},{61.8,25.6},{61.8,26.8},{61.8,33.2},{61.8,33.6},{61.8,41.8},{62,28.4},{62,31},{62,38.8},{62.2,23.2},{62.2,36.8},{62.2,43.8},{62.4,23.6},{62.4,29.4},{62.4,29.6},{62.4,39.6},{62.4,43},{62.6,25.4},{62.6,30.2},{62.6,30.8},{62.6,32.4},{62.6,36.4},{62.6,39.4},{62.6,40.8},{62.8,39.6},{62.8,43.2},{63,23.2},{63,26},{63,28.8},{63,34},{63,42},{63.2,24.4},{63.2,27.4},{63.2,27.6},{63.2,36.8},{63.4,32.6},{63.4,44.2},{63.6,24.4},{63.6,27.6},{63.6,31.6},{63.6,32.8},{63.6,40.2},{63.8,27.2},{63.8,30.2},{64,28.6},{64.2,30.8},{64.2,34.6},{64.2,35.8},{64.2,41.4},{64.2,42.2},{64.2,44.8},{64.4,25.4},{64.4,26.4},{64.4,33.8},{64.4,43},{64.4,44.4},{64.6,25.6},{64.6,26.8},{64.6,42},{64.8,29},{64.8,31.4},{64.8,32.2},{64.8,34},{64.8,40.4},{65,24.8},{65,33},{65,38.6},{65,40.8},{65.2,35.2},{65.2,44.4},{65.2,46.8},{65.4,27.6},{65.4,35.6},{65.4,43.4},{65.4,44.6},{65.4,45.6},{65.6,25.6},{65.6,27.4},{65.6,33},{65.6,35.2},{65.6,37.8},{65.6,40.8},{65.6,42},{65.8,40.4},{65.8,46},{66,36.6},{66,46.8},{66.2,31.6},{66.2,34.4},{66.2,36.4},{66.2,43.4},{66.2,44.4},{66.2,44.6},{66.4,28},{66.6,32.2},{66.6,33},{66.6,40.8},{66.6,43.4},{66.6,43.6},{66.8,26.8},{66.8,28.2},{66.8,34.2},{67,25.6},{67,36.2},{67,41.8},{67,45.4},{67.2,25},{67.2,37.8},{67.2,39},{67.2,40.4},{67.2,45.6},{67.4,47.2},{67.4,48},{67.4,49.8},{67.6,26.4},{67.6,39.2},{67.6,43.8},{67.6,45.6},{67.8,40.6},{67.8,42.2},{67.8,43.4},{67.8,47.8},{68,47},{68.2,24.4},{68.2,37.6},{68.2,49},{68.4,24.6},{68.4,26.8},{68.4,45},{68.6,48.8},{68.8,28.6},{69,28.2},{69,39},{69,39.6},{69,43.4},{69,45.2},{69,45.6},{69,47.4},{69.2,37.2},{69.2,44.4},{69.4,47.8},{69.6,38.8},{69.6,39.6},{69.6,45.4},{69.6,52.6},{69.8,38.4},{69.8,43},{69.8,44},{70.2,40.6},{70.2,46.4},{70.4,42},{70.4,46.6},{70.4,47.6},{70.4,48.8},{70.4,49.8},{70.4,51},{70.6,43.6},{70.6,45.4},{70.6,46.4},{70.6,47.6},{70.6,48.6},{70.8,53.2},{71,47},{71,49.6},{71,51.6},{71.4,54.2},{71.6,46.4},{71.6,47.4},{71.6,47.6},{71.6,52.2},{71.6,57.2},{71.8,53},{72.2,50.8},{72.2,53.8},{72.4,49},{72.4,50.2},{72.6,48.8},{72.8,51},{72.8,52.8},{73,50},{73,51.6},{73.4,53.6},{73.6,50.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221315] = {
            [npcKeys.name] = "Unstable Wisp",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{49.6,47},{52.8,38.8},{53,38},{53.6,38.2},{53.6,39.2},{53.6,39.6},{61.2,35.4},{61.2,35.6},{61.4,34.4},{61.6,34.4},{61.8,34.6},{62,25.2},{62.2,32.4},{62.4,25.6},{62.4,29.8},{62.4,31},{62.4,33.4},{62.6,30.4},{62.6,30.8},{62.6,31.8},{62.6,32.8},{62.8,25.4},{62.8,25.6},{63.2,27},{63.2,27.6},{65.2,45.4},{65.4,46},{65.6,45.2},{65.6,46.2},{70.4,48.6},{70.8,47.2},{71,48.2},{71,49.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221324] = {
            [npcKeys.name] = "Grief-Crazed Gryphon",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{46,39.2},{46,39.8},{46.8,41.8},{47.8,40},{48.8,39.6},{49,41.4},{49.4,39.2},{49.6,46.6},{49.8,40.4},{49.8,40.6},{49.8,46.2},{50.2,39},{50.4,41.8},{50.4,44},{50.6,42},{51.2,46},{51.2,47.4},{51.4,37.4},{51.4,38},{51.4,38.6},{51.4,47.8},{51.8,41.2},{51.8,49.4},{52,38.2},{52,43.8},{52,47.2},{52,48.2},{52.2,33.8},{52.2,40.4},{52.2,50},{52.4,36.4},{52.4,36.8},{52.4,38.8},{52.6,34},{52.6,48.2},{52.8,40},{53,36.4},{53,39},{53,43.4},{53,44.2},{53,48.6},{53.2,34.8},{53.2,42.4},{53.2,46.8},{53.4,37.2},{53.4,37.6},{53.4,50.8},{53.6,35.2},{53.6,36.4},{53.8,37.4},{53.8,45},{53.8,49},{53.8,51.6},{54,37.6},{54,41.6},{54,43.6},{54,50.6},{54.2,34},{54.2,38.8},{54.2,52.6},{54.4,43.4},{54.4,45.6},{54.4,50.4},{54.6,37.4},{54.6,49.8},{54.6,54.6},{54.8,37.8},{54.8,41.4},{54.8,42.6},{54.8,44.6},{55,35.6},{55,39.8},{55.2,34.4},{55.2,34.6},{55.2,50.6},{55.4,33.2},{55.4,38.8},{55.4,44.2},{55.4,45.6},{55.4,47},{55.6,34.6},{55.6,35.8},{55.6,38.6},{55.6,49.4},{55.8,34.4},{56,44.6},{56,45.6},{56,50.4},{56.2,38},{56.2,44.4},{56.2,46.8},{56.4,48},{56.6,34.4},{56.6,43.4},{56.8,35.4},{56.8,38},{56.8,47.4},{56.8,49},{57,41},{57,50.2},{57.2,42.2},{57.2,45.4},{57.2,45.8},{57.4,33.4},{57.4,38.6},{57.4,44.4},{57.4,48.2},{57.6,37.4},{57.6,40.2},{57.6,41.4},{57.6,45.4},{57.6,46.4},{57.8,48.4},{58,42.2},{58,50.2},{58.2,33},{58.2,38.8},{58.2,44},{58.2,48.6},{58.2,51.4},{58.2,51.6},{58.4,18},{58.4,30.4},{58.4,30.8},{58.4,32.2},{58.4,33.6},{58.4,34.6},{58.4,35.6},{58.4,37.8},{58.6,35.6},{58.6,46.4},{58.6,46.6},{58.6,49.4},{58.8,23.8},{58.8,28.2},{59,19.6},{59,51.2},{59.2,17.8},{59.2,24.6},{59.2,37.8},{59.2,40.2},{59.2,41.2},{59.2,43.6},{59.2,45.4},{59.4,31},{59.4,33},{59.4,34.4},{59.4,35},{59.4,38.6},{59.6,33.6},{59.6,35.4},{59.8,29.4},{59.8,30},{59.8,33.2},{59.8,35.6},{59.8,45.2},{59.8,50.8},{60,31},{60,42.8},{60,47.8},{60.2,44.2},{60.4,32.4},{60.4,38.8},{60.4,41.2},{60.4,42.2},{60.6,32.2},{60.6,33},{60.6,38.4},{60.6,39.2},{60.6,47.6},{60.8,31.4},{60.8,46.4},{61,29.8},{61,36.6},{61,39.6},{61,40.8},{61.2,28.6},{61.2,35.8},{61.2,47},{61.2,49.2},{61.2,49.8},{61.4,28},{61.4,34.4},{61.4,35},{61.4,41.6},{61.4,42.6},{61.4,44},{61.4,45.2},{61.6,33.8},{61.6,40.6},{61.6,45.6},{61.8,44.2},{61.8,47},{62,32.6},{62,42},{62.2,23},{62.2,23.6},{62.2,26.4},{62.2,27.4},{62.2,30.6},{62.2,32},{62.2,35.4},{62.2,35.8},{62.2,36.6},{62.2,44.8},{62.2,47.8},{62.4,25},{62.4,28},{62.4,29.2},{62.4,30.2},{62.4,39.2},{62.4,39.6},{62.4,42.8},{62.4,50.4},{62.6,24.4},{62.6,24.6},{62.6,30.8},{62.6,34.2},{62.6,49.6},{62.8,23},{62.8,29.6},{62.8,41.8},{62.8,43.4},{63,26},{63,29},{63,32.4},{63,32.8},{63,35.4},{63,35.8},{63,40},{63,44.8},{63,47.4},{63.2,27.4},{63.2,27.6},{63.2,37.2},{63.2,44.4},{63.2,47.6},{63.4,40.6},{63.4,46},{63.4,48.6},{63.6,27.4},{63.6,31.8},{63.6,35.4},{63.6,40.4},{63.6,44.4},{63.8,28.2},{63.8,29.2},{63.8,29.8},{63.8,31},{63.8,43.4},{64,37.2},{64.2,33},{64.2,34.2},{64.2,35.6},{64.2,37.6},{64.2,42.2},{64.2,45},{64.2,45.6},{64.2,46.6},{64.2,49.2},{64.2,49.6},{64.4,26.4},{64.4,41.2},{64.4,47.6},{64.6,22.6},{64.6,30},{64.6,30.8},{64.6,33.2},{64.6,45.4},{64.6,46.6},{64.6,47.6},{64.8,16.4},{64.8,25.6},{64.8,35.6},{64.8,40.8},{64.8,42},{64.8,45.6},{65,18.2},{65,27.8},{65,31.8},{65,35},{65,43},{65,48.6},{65,50},{65.2,21.4},{65.2,25},{65.2,38},{65.2,40.2},{65.4,24},{65.4,27.2},{65.4,34},{65.4,37},{65.4,38.8},{65.4,44.4},{65.6,26.2},{65.6,27.4},{65.6,31.6},{65.6,33.4},{65.6,36.8},{65.6,47},{65.8,30},{65.8,46.4},{66,23.8},{66,24.6},{66,42.4},{66,50.2},{66.2,18.8},{66.2,28},{66.2,33.8},{66.2,35.2},{66.2,38.2},{66.2,38.6},{66.2,40.4},{66.2,44.6},{66.2,48.6},{66.4,17.8},{66.4,40.6},{66.4,43.4},{66.4,43.6},{66.4,47.6},{66.4,50.6},{66.6,17.8},{66.6,28.4},{66.6,32.6},{66.6,34},{66.6,38},{66.6,39},{66.6,49.8},{66.8,15.8},{66.8,43.4},{67,35.8},{67,41.2},{67,45.6},{67.2,16.6},{67.2,43.8},{67.2,44.6},{67.2,46.8},{67.2,48.2},{67.2,48.6},{67.2,53.2},{67.4,27.4},{67.4,40.4},{67.4,42.4},{67.6,42.4},{67.6,47},{67.6,48.8},{67.8,37},{67.8,43.4},{67.8,44},{67.8,44.8},{67.8,48.4},{68,15.8},{68,33},{68.2,34.8},{68.2,39.2},{68.2,40.4},{68.2,45.6},{68.2,49.8},{68.4,38.4},{68.4,40.8},{68.4,50.6},{68.6,28.8},{68.6,58},{68.8,51.6},{68.8,54},{69,43.8},{69,46.6},{69.2,37.2},{69.2,39.2},{69.2,43.4},{69.4,28.2},{69.4,37.8},{69.4,39.6},{69.4,45.4},{69.4,45.6},{69.4,48.2},{69.4,49.4},{69.4,50.4},{69.4,51},{69.4,55.2},{69.4,55.8},{69.6,27.6},{69.6,38.4},{69.6,40},{69.6,42.4},{69.6,48.4},{69.6,49.4},{69.6,55.8},{69.8,38.6},{70,42.8},{70,45.8},{70,50.4},{70.2,50.6},{70.2,51.6},{70.2,52.6},{70.2,54.6},{70.2,57.8},{70.4,44.4},{70.4,45.4},{70.4,47.4},{70.6,45.4},{70.6,46.4},{70.6,49.2},{70.6,50.2},{70.6,51.2},{70.6,56.4},{71,44.2},{71,47.6},{71.2,47},{71.2,54},{71.4,52.4},{71.4,53},{71.6,46.2},{71.6,47.4},{71.6,53.2},{71.6,58.4},{71.8,44.2},{71.8,45.2},{71.8,52.2},{71.8,54.6},{71.8,58.6},{72,47.6},{72.2,54},{72.4,48.6},{72.4,50.2},{72.4,51.2},{72.6,46.4},{72.6,47},{72.6,50.4},{72.8,48.4},{72.8,49.4},{72.8,50.8},{73,51.6},{73,53.8},{73,54.8},{73,56},{73.2,53.4},{73.6,49.4},{73.6,51.2},{73.6,53.6},{73.8,49.6},{73.8,52.2},{73.8,52.8},{74,57.2},{74.2,47.8},{74.8,49.4},{74.8,49.6},{74.8,52.6},{75,52},{75.6,49.6},{75.8,51},{76,49.2},{76.8,52.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221325] = {
            [npcKeys.name] = "Wyrmkin Starhunter",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{43.8,43.4},{44.2,44.2},{45,42.4},{45,42.6},{45.2,44.6},{45.4,38.8},{45.8,39.4},{46,39.6},{46,42.6},{46.2,42.4},{46.4,40.6},{46.6,40.4},{46.6,44.4},{46.6,44.6},{46.8,36.4},{47,37.2},{47,37.6},{47,41.4},{47,41.6},{47.8,43.4},{48,41},{48,43.6},{48.2,39.2},{48.6,39.6},{48.8,39.4},{49.2,41.4},{49.2,41.6},{49.8,39.4},{49.8,39.6},{50.8,38.2},{51.2,39.4},{51.2,40},{51.4,40.6},{51.6,39.6},{52.4,38.4},{52.4,39.4},{52.8,38},{52.8,38.8},{53,40},{53.6,38.2},{53.8,39.6},{54,39.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221326] = {
            [npcKeys.name] = "Wrath Whelp",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{44.4,43},{45,41},{45,41.6},{45,42.8},{45.4,38.8},{45.4,40.4},{45.4,44},{45.6,42.4},{45.8,39.4},{46,42.6},{46.4,36.4},{46.4,40.4},{46.4,40.6},{46.6,40.4},{46.8,34.4},{46.8,34.8},{46.8,35.6},{46.8,36.6},{46.8,43.4},{46.8,43.6},{47,39.4},{47,41.4},{47,41.6},{47.4,33.2},{47.6,41},{48.4,40.2},{48.4,41.6},{48.6,40.4},{48.6,40.6},{48.6,42.6},{48.8,41.6},{49.2,39.4},{49.4,38},{49.6,38.2},{49.8,39.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221328] = {
            [npcKeys.name] = "Dreamwater Vicejaw",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{48.4,44.4},{50.4,41.8},{51.4,44.4},{54.4,39.4},{55.4,39.8},{56.2,38.2},{56.4,42.2},{56.4,43.2},{56.6,42.2},{57,41.2},{57,43.2},{57.2,37},{57.2,43.6},{57.4,38.4},{57.4,38.8},{57.4,40.2},{57.6,35.8},{57.6,40.2},{57.6,42.8},{58.2,37.2},{58.2,40.6},{58.2,42.2},{58.4,38.2},{58.4,38.6},{58.4,43.6},{58.6,38.6},{59,37.8},{59,39.6},{59,40.8},{59.2,37.4},{59.4,35.2},{59.4,36.4},{59.4,41.6},{59.8,37.4},{60,35.2},{60,38.2},{60,43.2},{60,44},{60.4,36.4},{60.4,38.8},{60.4,40},{60.8,37.2},{60.8,38.8},{60.8,44},{61,31.8},{61,41.6},{61,42.8},{61.2,35.4},{61.2,35.6},{61.2,38.4},{61.2,40.6},{61.4,39.6},{61.6,34.2},{61.6,34.6},{61.6,38.4},{61.6,43.4},{61.6,46.2},{61.8,37},{62,36.2},{62.2,40.8},{62.2,43.6},{62.4,32.2},{62.4,32.6},{62.4,39.2},{62.4,39.6},{62.4,42.4},{62.6,37.4},{62.6,38.4},{62.6,39.4},{62.6,39.6},{62.6,46.4},{63,26.4},{63,28.2},{63,30.2},{63,41.4},{63,45},{63.2,27.2},{63.2,42.6},{63.2,44.2},{63.4,42.2},{63.4,46.6},{63.6,31},{63.6,38.4},{63.8,37.2},{63.8,39},{64,47.6},{64,52},{64.2,45.6},{64.4,40.4},{64.4,41.2},{64.4,42.2},{64.4,42.6},{64.4,43.8},{64.4,44.8},{64.4,47},{64.6,42},{64.6,43},{64.6,50.2},{64.8,47.6},{65,37.8},{65,40.4},{65,44.8},{65,47},{65.2,39.4},{65.2,48.8},{65.4,40.6},{65.4,44.4},{65.4,45.8},{65.6,33.2},{65.6,39.4},{65.6,44.4},{65.6,44.6},{65.6,46.2},{65.6,49.2},{65.8,42.4},{65.8,48.2},{65.8,50},{66,36.8},{66,46.6},{66.2,38.2},{66.2,43.2},{66.2,50.8},{66.4,40.4},{66.4,40.6},{66.6,40.4},{66.6,40.6},{66.6,43.4},{66.6,49.6},{66.8,45.4},{66.8,46.2},{67,46.6},{67,50.6},{67.2,36.6},{67.2,39.4},{67.2,42.4},{67.2,43.8},{67.4,47.8},{67.4,49.2},{67.6,40.4},{67.8,43.4},{67.8,50.8},{68,40.6},{68,42.4},{68,44.2},{68,44.8},{68,45.8},{68,49.8},{68.2,39.4},{68.2,47.4},{68.2,47.6},{68.4,48.6},{68.6,39.4},{68.6,47.4},{68.6,47.6},{68.8,41},{68.8,43},{68.8,45.4},{69,39.8},{69,44.4},{69,45.6},{69,51.2},{69.2,41.8},{69.2,49.6},{69.4,49.2},{69.4,52},{69.6,40.4},{69.6,40.6},{69.6,45.4},{69.6,45.6},{69.8,43.4},{69.8,44},{69.8,49},{70.2,47.2},{70.2,48.4},{70.4,50},{70.4,51},{70.4,51.6},{70.4,52.6},{70.6,44.6},{70.6,46.4},{70.6,48.4},{70.6,48.8},{70.6,51.2},{70.8,43.6},{71,53.8},{71.4,47.4},{71.4,50.2},{71.4,51.6},{71.4,53.4},{71.6,47.4},{71.6,47.6},{71.6,50.4},{71.6,50.6},{71.6,51.8},{71.6,54.6},{71.8,48.6},{71.8,52.8},{71.8,57.2},{72.2,54},{72.6,46.4},{72.6,48.4},{72.6,50.4},{72.6,51.4},{72.6,53.8},{73,49},{73,52},{73.2,53.4},{73.4,56.2},{73.8,53},{74,56.6},{74.2,57.8},{75.6,49.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221329] = {
            [npcKeys.name] = "Dreamhunter Hydra",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{63.4,40},{63.6,40.2},{64,40.6},{64.6,40.4},{64.6,40.6},{66.4,40.4},{66.4,40.6},{66.4,42.4},{66.6,41.8},{66.8,41},{67.8,40.6},{68.6,41.4},{69.2,42},{69.4,47.4},{69.4,47.8},{69.6,42.2},{70.4,44.4},{70.4,44.6},{70.4,47.4},{70.4,48.4},{70.4,48.6},{70.4,49.6},{70.4,51.8},{70.6,47.4},{70.6,48.6},{70.6,50.6},{70.6,51.8},{70.8,48.4},{71,49.8},{71.4,45.8},{71.6,47.4},{71.6,47.6},{71.6,49.8},{71.6,51.4},{71.6,52.4},{71.8,53},{72.2,53.8},{72.8,53.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221330] = {
            [npcKeys.name] = "Fallen Moonkin",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{49.6,47},{49.6,47.6},{50,46.2},{52.8,43.2},{53,38.8},{53,43.6},{53.4,40},{53.6,43},{53.8,40.8},{54,39},{54,39.6},{54.6,41.2},{54.8,39.4},{54.8,39.6},{55.4,41.6},{55.8,41.2},{55.8,43.8},{56.2,39.2},{56.2,40.2},{56.2,42.4},{56.2,42.6},{56.4,44.6},{56.6,42.2},{56.6,43.2},{56.6,44.6},{57,43.6},{57.2,46.2},{57.4,38.4},{57.4,38.8},{57.4,40.2},{57.4,41},{57.6,38.4},{57.6,39.4},{57.6,40},{57.6,44.8},{57.8,42.6},{57.8,43.6},{58,42.4},{58,46.4},{58,46.8},{58,50.2},{58.2,41.2},{58.6,38.2},{58.6,38.8},{58.6,40.2},{58.6,40.6},{58.6,46.6},{58.8,41.8},{59.2,45.4},{59.4,46.2},{59.8,45.6},{59.8,46.8},{60,45.4},{60.2,44.2},{60.4,43},{60.6,43},{60.6,44.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221331] = {
            [npcKeys.name] = "Florius",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{45.4,38.6},{45.8,39.4},{46,39.8},{46.4,37.4},{46.4,38},{46.4,40.6},{46.6,40.2},{46.6,40.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221333] = {
            [npcKeys.name] = "Doomkin",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{56.2,44.6},{56.4,42.4},{56.4,43.2},{56.4,43.6},{56.6,42.2},{56.6,43.4},{56.6,43.6},{56.6,44.6},{57.4,38.4},{57.4,39.2},{57.6,38.6},{57.6,39.6},{57.6,42.6},{58,40.8},{58,42.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221334] = {
            [npcKeys.name] = "Ghamoo-Raja",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{45.6,39.6},{47.2,41.2},{49.8,39.4},{54.4,37.2},{54.4,43.8},{55.6,38.8},{55.6,40.2},{56.2,42.4},{56.2,43},{56.6,38},{56.8,43},{57,46},{57.2,36.4},{57.4,38.8},{57.4,39.6},{57.6,39.8},{57.8,38},{57.8,38.6},{57.8,42.8},{58.2,41.4},{58.2,48.6},{58.8,38.8},{58.8,41.8},{59.6,38.4},{59.6,40},{59.8,35.4},{60,38.8},{60,42.8},{60.4,43.8},{60.6,37.8},{60.6,38.6},{60.6,39.8},{60.8,41.4},{61,32.2},{61,36.4},{61,36.6},{61,46.4},{61.4,32.6},{61.4,34.8},{61.6,34.8},{62,33.2},{62,38.8},{62,40.6},{62.2,23},{62.2,40.2},{62.4,23.6},{62.4,29.8},{62.4,30.6},{62.4,31.6},{62.4,42},{62.6,24.4},{62.6,25},{62.6,30.6},{62.6,40.6},{62.8,41.6},{62.8,42.8},{63,26},{63,29.6},{63,40.4},{63.2,27.6},{63.2,28.6},{63.4,27.4},{63.4,45.4},{63.4,45.6},{63.6,27.4},{63.6,27.6},{63.6,40.2},{63.8,40.6},{64.2,35.4},{64.2,42.2},{64.2,44.4},{64.4,43.4},{64.4,46.8},{64.6,39.4},{64.6,43},{64.6,43.8},{64.6,44.6},{64.6,50.4},{64.8,41.4},{65,42},{65,46.2},{65,47},{65.4,40.4},{65.4,49},{65.6,44},{65.8,40.8},{65.8,46.6},{66,42.8},{66,46.2},{66.2,40.4},{66.2,42.4},{66.6,40.4},{66.6,42.8},{66.6,49.6},{67,41.2},{67,46},{67,46.8},{67,55.4},{67.2,43.6},{67.2,44.8},{67.2,58.4},{67.4,42.2},{67.4,47.8},{67.8,43.4},{67.8,44.8},{67.8,45.6},{68,43.6},{68,49.2},{68.2,41.4},{68.2,42.2},{68.2,47.6},{68.2,49.6},{68.4,47.2},{68.6,42.8},{68.6,47.8},{68.6,50.8},{68.6,52.4},{68.8,47},{68.8,49.4},{69.2,49.8},{69.4,45.6},{69.4,58},{69.8,44.6},{69.8,49.2},{70,46.4},{70,53},{70.2,47.4},{70.2,48.4},{70.2,57.4},{70.2,59.4},{70.4,44.2},{70.4,49.8},{70.4,50.8},{70.4,51.8},{70.6,46.4},{70.6,46.8},{70.6,48.4},{70.6,48.8},{70.8,51.2},{70.8,52.4},{71,45.2},{71,54.8},{71,55.8},{71,59},{71.2,53.6},{71.2,57.2},{71.4,50.4},{71.4,53.4},{71.6,46.2},{71.6,47.6},{71.6,50},{71.6,57.8},{71.8,52.4},{71.8,54.6},{71.8,57.2},{72,48.6},{72,51},{72,53.4},{72,55.6},{72,58.6},{72.2,47},{72.4,53.6},{72.6,47.2},{72.6,49.8},{72.6,53.6},{72.6,55.6},{72.8,53.4},{73,51.4},{73,52},{73,60.4},{73.2,55.2},{73.6,53.4},{73.6,54},{73.6,57.2},{73.6,57.6},{73.8,48.6},{73.8,49.8},{73.8,51},{73.8,51.8},{73.8,56.4},{74.2,47.6},{74.2,55.4},{74.6,51},{74.8,55},{75,49},{75.2,49.6},{75.6,52.4},{75.8,49.4},{75.8,49.6},{76,51},{77,48.8},{77.6,53.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221335] = {
            [npcKeys.name] = "Elianar Shadowdrinker",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{49.4,38},{53.4,39},{53.6,39},{63.2,27.4},{63.2,27.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221336] = {
            [npcKeys.name] = "Serlina Starbright",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{63.2,27.4},{63.2,27.6},{71,48}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221337] = {
            [npcKeys.name] = "Veanna Cloudsleeper",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{57.4,42.8},{63.2,27.4},{63.2,27.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221351] = {
            [npcKeys.name] = "Dreamwarden Valori",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{56.4,43.2},{56.6,43.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221352] = {
            [npcKeys.name] = "Dreamwarden Sanathel",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{73.2,54}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221353] = {
            [npcKeys.name] = "Dreamwarden Laninar",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{46.8,41.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221356] = {
            [npcKeys.name] = "Doomspark Starsworn",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{59.2,26.2},{59.4,27},{59.4,27.8},{60.2,26.4},{60.4,26.8},{60.4,29.4},{60.4,29.6},{60.4,31.2},{60.6,29.4},{60.6,29.6},{60.8,31.4},{61,31.6},{61.4,34.4},{61.4,34.6},{61.6,34.6},{61.8,33.4},{61.8,33.6},{62.4,23.4},{62.4,23.8},{62.4,24.6},{62.4,25.6},{62.6,23.4},{62.6,24.2},{62.8,25.4},{62.8,25.8},{62.8,26.8},{63.4,27.6},{63.6,27},{63.6,27.6},{63.8,29.4},{64,25.4},{64,25.6},{64,29.6},{65,25.2},{65,31},{65.4,23.4},{66,27}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221357] = {
            [npcKeys.name] = "Stardust Imp",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{60.4,29.4},{60.4,29.6},{60.8,29.4},{60.8,29.8},{61.2,35.8},{61.4,31.4},{61.4,31.8},{61.4,33.2},{61.4,34.4},{61.4,34.8},{61.6,31.8},{61.6,33.4},{61.6,33.8},{62.2,23.2},{62.2,25.2},{62.4,23.6},{62.4,25.6},{62.4,27.6},{62.4,30.4},{62.4,30.6},{62.6,23.4},{62.6,23.8},{62.6,24.8},{62.6,30.4},{62.6,30.8},{62.8,26.2},{62.8,26.6},{63.4,29.2},{63.8,26.2},{63.8,26.6},{63.8,29.2},{63.8,29.6},{66,22.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221360] = {
            [npcKeys.name] = "Starkiller Hound",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{60.4,27},{60.6,38.6},{60.8,28.4},{60.8,29.8},{61,25.2},{61,26.4},{61,26.6},{61,36.8},{61.2,35.8},{61.4,28.6},{61.4,31.4},{61.4,31.6},{61.4,33.2},{61.4,34.4},{61.4,34.6},{61.6,31.4},{61.6,31.6},{61.6,33.2},{61.6,33.6},{61.6,34.6},{61.8,29},{62.2,23},{62.4,24.2},{62.4,24.6},{62.4,25.6},{62.4,27.4},{62.4,28.4},{62.4,29.6},{62.6,23.4},{62.6,24.4},{62.6,24.6},{62.6,31.6},{62.8,25.8},{62.8,29.4},{62.8,30.6},{63,27.2},{63,30.2},{63.2,27.8},{63.2,33.6},{63.4,33},{63.6,27.4},{63.6,27.8},{63.8,31.8},{63.8,33.2},{64,29.4},{64,29.8},{64,30.8},{64.6,27.2},{64.6,27.6},{64.6,29},{64.6,31},{64.8,26.2},{65.2,29.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221361] = {
            [npcKeys.name] = "Mad Sprite",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{37.2,12.4},{37.2,12.6},{37.6,16},{38.4,16.8},{41,8.2},{41,15},{41.2,9},{41.6,9},{43,13},{44.4,11.8},{44.6,11.8},{44.8,13.8},{45.2,19.4},{45.2,19.6},{45.4,21.4},{45.4,21.6},{45.6,21.4},{45.6,21.6},{46.2,14.2},{46.2,19.8},{46.4,14.6},{46.4,18.4},{46.4,18.6},{47.4,10.8},{47.4,13.6},{47.6,13.4},{47.6,13.6},{48.2,10.4},{48.4,10.6},{50.2,12.4},{50.4,12.6},{50.6,12.4},{50.8,10.6},{51.4,12.6},{51.6,12.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221364] = {
            [npcKeys.name] = "Rampaging Chimaera",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{36.4,14.8},{37.4,17.8},{37.8,14.8},{37.8,22.4},{38.2,24.2},{38.4,16},{38.4,21},{38.4,23},{38.6,15.8},{38.6,22.4},{38.6,23},{38.8,20.2},{38.8,24.4},{39,7.4},{39.2,13.4},{39.2,24.6},{39.4,8},{39.4,14},{39.4,15},{39.4,19},{39.4,20.8},{39.8,15.6},{40,19.2},{40.2,11.8},{40.2,14.4},{40.4,13.4},{40.4,14.6},{40.4,20.6},{40.6,13.4},{40.6,14.4},{40.6,14.8},{40.8,10.8},{40.8,19.2},{41.2,12},{41.2,20.4},{41.2,20.8},{41.4,8},{41.4,8.6},{41.4,15.8},{41.4,16.6},{41.6,8.2},{41.6,19.4},{41.6,20.4},{41.6,20.8},{41.8,22.4},{41.8,24},{42,8.8},{42,16.6},{42.2,14.8},{42.2,16},{42.2,23.4},{42.4,14.2},{42.6,7.4},{42.6,14.2},{42.6,15.2},{42.6,23.6},{42.8,9.2},{42.8,21.2},{42.8,23},{43,20.2},{43,22},{43,26.2},{43.2,13.2},{43.4,25},{43.8,25.6},{44,21.4},{44,23},{44,25.4},{44.4,21.8},{44.4,24},{44.6,21.4},{44.6,21.8},{44.6,22.6},{44.6,24.2},{45,19.8},{45,25},{45.2,9.2},{45.4,8},{45.4,17.6},{45.6,19.6},{45.6,20.8},{45.6,22.4},{45.8,12.2},{45.8,16.6},{45.8,17.6},{45.8,23.4},{46,7.4},{46,8},{46,16},{46,24.6},{46.6,7.6},{46.6,21.2},{47,17.6},{47.2,16.8},{47.4,16.4},{47.4,22},{47.6,16.4},{47.6,16.8},{47.8,5},{47.8,6},{48.6,15.4},{49.4,16.2},{49.4,16.6},{49.6,15},{49.6,16.2},{49.6,16.6},{50,4.8},{50,6.4},{50,7.6},{50.2,6.6},{50.6,6.2},{50.6,6.6},{50.6,7.8},{50.6,20},{50.8,5},{51.8,5.2},{51.8,7.8},{52.2,11.6},{52.4,10.6},{52.8,9.2},{52.8,10.8},{52.8,16.4},{53,9.6},{53.2,8.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221365] = {
            [npcKeys.name] = "Deathpetal Lasher",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{40.2,19},{41.4,16.8},{41.6,16.4},{41.6,16.6},{42.2,14.4},{42.2,14.6},{42.4,20.8},{42.6,21},{43,10.4},{43.2,10.8},{43.2,13.6},{43.4,12.4},{43.4,13.4},{43.8,12.4},{43.8,12.6},{44.4,10.8},{44.6,10.8},{44.8,22.6},{45,9.4},{45,19.8},{45,22.4},{45.4,12.2},{45.4,19.2},{45.6,12},{45.6,19.8},{45.6,22.2},{45.6,22.6},{46,13},{46.2,10.6},{46.2,13.6},{46.2,17.4},{46.2,17.8},{46.2,19},{46.2,20.8},{46.4,15.2},{46.4,15.6},{46.6,15.2},{46.6,15.6},{46.6,19},{46.6,21.2},{46.8,14.4},{47,21.6},{47.4,11.4},{47.4,11.8},{47.6,11.4},{47.6,11.6},{48,15.8},{49.2,16},{49.4,15},{50,15.6},{50.2,15},{50.4,10},{50.4,11},{50.4,11.8},{50.4,12.8},{50.6,12.6},{50.6,17.2},{50.8,11.8},{51,11.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221367] = {
            [npcKeys.name] = "Wyrmkin Berserker",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{47.2,16.8},{47.8,16},{48.4,11.4},{48.4,11.6},{48.6,11.4},{48.6,11.6},{49.2,14.4},{49.4,8},{49.4,15},{49.6,6.2},{49.6,15.6},{50,14.4},{50,14.6},{50.4,17},{50.6,5.6},{50.6,17.2},{51,15.4},{51.2,15.8},{51.6,14.8},{51.8,6},{52.4,16},{52.8,16.2},{53,16.6},{53.2,8},{53.4,12.2},{53.4,14.4},{53.4,14.8},{53.6,12.4},{53.6,13.4},{53.6,13.6},{53.6,15.2},{53.6,15.6},{54,10.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221369] = {
            [npcKeys.name] = "Frenzied Whelp",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{45.4,14.2},{45.8,14.2},{46,14.6},{46.4,12.8},{46.6,12.8},{47.2,14.6},{47.4,14.4},{48.2,13.4},{48.2,13.6},{48.8,10.8},{50,24.8},{50.2,16.2},{50.4,17},{50.4,17.8},{50.4,22.4},{50.4,22.6},{50.6,17.2},{50.6,21},{50.6,22.2},{50.6,24.8},{50.8,19.6},{50.8,22.6},{51,11.4},{51,11.6},{51,18.4},{51,18.8},{51,24},{51.4,16.4},{51.6,16},{51.6,16.6},{51.6,19.6},{51.8,15.4},{52.8,16.2},{53,16.6},{53.4,14.4},{53.4,14.6},{53.6,12.4},{53.6,12.8},{53.6,14.2},{53.6,16},{54.2,10.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221370] = {
            [npcKeys.name] = "Dreamspring Roguefeather",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{37.4,14.2},{38,14.4},{38,14.6},{38.2,10.4},{38.4,11.4},{38.4,11.6},{38.4,13},{38.4,15.8},{38.4,16.6},{38.6,11.4},{38.6,15.6},{38.6,16.6},{39,12},{39,13.4},{39.2,10},{39.4,9.4},{39.4,13.6},{39.4,14.6},{39.6,13.8},{39.6,15.8},{39.8,10.2},{39.8,12.2},{39.8,12.6},{39.8,15.2},{40,9.2},{40.4,8.2},{40.4,10.8},{40.6,8.2},{40.6,15},{40.8,9.8},{41,13.2},{41.4,8.6},{41.4,11.4},{41.4,12.4},{41.4,14.2},{41.6,8.4},{41.6,8.6},{41.6,11.4},{41.6,12.4},{41.6,12.6},{41.6,14},{41.6,14.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221371] = {
            [npcKeys.name] = "Dreamspring Stormcaller",
            [npcKeys.minLevel] = 49,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{36.8,13.8},{37.2,12.6},{37.4,12.4},{37.6,15.4},{37.6,15.6},{37.8,11.8},{37.8,12.6},{38,11.4},{38,14.4},{38.6,14},{38.8,14.6},{39,10},{39,13.4},{39.2,16.4},{39.4,9.2},{39.4,10.8},{39.4,12.2},{39.6,10.8},{39.6,12.8},{39.8,9.6},{40,9.2},{40.2,8},{40.2,12.4},{40.2,13.6},{40.6,9.6},{40.6,13.6},{40.8,8.2},{40.8,12.2},{41,10.8},{41.2,13},{41.4,9.4},{42,9},{42.2,11.2},{42.2,11.6},{42.8,9.4},{42.8,9.6},{43.2,11},{43.6,11},{43.8,10},{45,9.4},{45,10.8},{45.2,10.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221373] = {
            [npcKeys.name] = "Enraged Mountain Giant",
            [npcKeys.minLevel] = 49,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{38,14.2},{38.2,15.8},{38.4,13},{38.6,16},{39,10.2},{39,13.4},{39.2,13.8},{39.2,18.6},{39.4,11.8},{39.4,15},{39.8,18.6},{40,12.4},{40,12.6},{40,16.4},{40,17},{40.2,9.4},{40.2,13.6},{40.4,10.4},{40.4,10.6},{40.4,15},{40.6,10.6},{40.6,14.4},{40.8,11.6},{40.8,15.4},{40.8,17},{41,9.2},{41,13.2},{41,16.2},{41.2,8.4},{41.2,9.6},{41.2,17.8},{41.6,15.2},{41.6,15.8},{41.8,14},{42,18.6},{42.2,9.2},{42.2,12.6},{42.2,17},{42.2,17.8},{42.4,7},{42.4,12.2},{42.4,19.8},{42.4,20.6},{42.6,19.8},{42.8,9.8},{42.8,12.4},{42.8,13.6},{43,20.6},{43.2,11},{43.2,13.4},{43.2,21.6},{43.4,7.2},{43.4,8.8},{43.6,12.2},{43.6,13.2},{43.8,8.6},{44,21.4},{44.2,8.4},{44.2,11.4},{44.2,20.4},{44.4,22},{44.6,12.6},{44.8,11.8},{44.8,22.2},{45,8},{45,8.6},{45,14.2},{45,20},{45.2,22.6},{45.4,9.6},{45.4,17.4},{45.4,17.6},{45.4,19},{45.4,21},{45.6,8.4},{45.6,18.2},{45.6,18.6},{45.6,20.6},{45.6,21.8},{45.8,15.2},{45.8,16.4},{45.8,16.6},{45.8,19.8},{46,22.6},{46.2,14.4},{46.2,24.4},{46.4,9.2},{46.6,8.2},{46.6,9.4},{46.6,14},{46.6,15.8},{47,14.6},{47.2,16.8},{47.4,17.6},{48,16.8},{48.2,16.4},{48.2,24.6},{48.4,8.2},{48.4,23.6},{48.6,16.6},{49,15.4},{49,15.8},{49.2,8},{49.2,25},{49.6,15.4},{49.8,16.4},{50,7.2},{50,24.2},{50,25.2},{50,25.6},{50.2,7.8},{50.4,8.6},{50.4,17},{50.4,17.8},{50.4,21},{50.4,22.2},{50.4,22.8},{50.6,16.4},{50.6,17.2},{50.6,19.8},{50.6,22.8},{50.8,18},{50.8,20.8},{50.8,21.6},{50.8,23.6},{50.8,25.4},{51,7},{51,19},{51.2,7.8},{51.2,8.6},{51.6,7.8},{51.6,18.4},{51.8,18.6},{51.8,20.4},{52,7.4},{52.2,16},{52.4,15.2},{52.6,16},{52.6,16.6},{53.4,13.2},{53.4,14.4},{53.4,14.6},{53.6,12.4},{53.6,13.2},{53.6,14},{53.6,15.4},{54.2,9.8},{54.2,11},{54.4,8.4},{54.4,9.4},{54.6,8.6},{55.6,12}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221375] = {
            [npcKeys.name] = "Lost Daughter",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{41.4,15},{41.4,15.6},{41.4,18.4},{41.6,15.4},{41.6,15.6},{41.6,18.4},{42.2,20.8},{42.4,19.8},{43.2,13.4},{43.2,13.6},{44,21.4},{44.2,21.6},{44.2,23},{44.8,22.6},{45,12.4},{45,12.6},{45,22.4},{45,25},{45.2,8.4},{45.2,8.6},{45.2,21.4},{45.4,19.8},{45.6,19.8},{45.6,22.2},{45.6,22.6},{45.8,16.6},{46,16.4},{46,24.4},{46,24.6},{46.2,18.8},{46.4,14.4},{46.4,14.8},{46.4,17.6},{46.4,21},{46.6,14.4},{46.6,14.8},{46.6,16},{46.6,21.2},{47,21.6},{49.4,15},{49.6,15},{50.2,16.2},{50.4,17},{50.6,17},{50.8,11.4},{51.2,15.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221377] = {
            [npcKeys.name] = "Vengeful Son",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{41.2,17.4},{41.2,17.8},{41.4,15.4},{41.4,15.6},{41.6,15.4},{41.6,15.8},{41.8,17.2},{42.4,19.2},{42.4,19.8},{42.6,20},{42.8,12.4},{43,13.2},{43,13.6},{43.4,25},{43.6,25},{44,23},{44.4,12.4},{44.4,12.6},{44.4,22.2},{44.6,12.4},{44.6,12.8},{45,19.8},{45.2,25.2},{45.4,14.2},{45.4,18.4},{45.4,19.2},{45.4,20.6},{45.4,22.2},{45.4,22.6},{45.6,18.8},{45.6,19.8},{45.6,20.8},{45.6,22},{45.8,23.2},{45.8,23.6},{46,16.2},{46,16.6},{46,25.4},{46,25.6},{46.2,15.4},{46.2,17.6},{46.4,14.4},{46.6,14.4},{46.6,14.6},{46.6,16},{46.6,21.2},{46.6,21.6},{46.6,24.8},{47,17.4},{47,17.6},{47.2,24.4},{47.6,14},{48,11.8},{48,12.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221389] = {
            [npcKeys.name] = "Alondrius",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{42.6,13.2},{43.8,12.2},{43.8,13.2},{45,12},{45,12.6},{45.4,14.2},{45.4,14.8},{45.4,17.4},{45.4,17.6},{45.4,19.4},{45.4,19.8},{45.6,10.6},{45.8,11.6},{45.8,21.8},{46,13.2},{46.2,14.2},{46.2,15.4},{46.2,16.4},{46.2,16.6},{46.2,18.2},{46.2,20.2},{46.4,19.2},{46.4,20.6},{46.6,13.4},{46.6,15.4},{46.6,16.2},{46.6,16.6},{46.6,18},{46.6,18.8},{46.6,21.4},{46.8,11.8},{46.8,14.4},{46.8,19.6},{46.8,24.6},{47,21.8},{47.6,15.6},{47.6,16.6},{48,14.8},{48,22.8},{48.2,12.4},{48.2,12.8},{48.2,24},{48.4,14.4},{48.6,14},{49.2,11.2},{49.2,11.8},{49.2,12.6},{49.6,10.8},{50,13.4},{50.4,12.2},{50.4,14},{50.8,13.6},{51,11.4},{51,11.6},{51.2,12.6},{51.8,14},{52.6,13.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221391] = {
            [npcKeys.name] = "Slirena",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{38.4,13},{39,13.4},{39.2,13.6},{39.6,13.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221393] = {
            [npcKeys.name] = "Tyrannikus",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{51,11.4},{51,11.6},{52.4,14.4},{52.4,14.8},{52.4,16.2},{52.6,15},{53,16.4},{53.2,16.6},{53.6,17}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221394] = {
            [npcKeys.name] = "Avatar of Hakkar",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221395] = {
            [npcKeys.name] = "Mellias Earthtender",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{49.6,15.4},{50,13.4},{51,11.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221396] = {
            [npcKeys.name] = "Hakkari Bloodkeeper",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221398] = {
            [npcKeys.name] = "Nerene Brooksinger",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{45.8,16.4},{45.8,16.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221399] = {
            [npcKeys.name] = "Jamniss Treemender",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{40.4,8},{40.6,8},{51,11.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221400] = {
            [npcKeys.name] = "Kajind",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{25.4,66.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81697,81801},
            [npcKeys.questEnds] = {81682,81697},
        },
        [221401] = {
            [npcKeys.name] = "Dreamwarden Sheldryn",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{50.6,19.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221402] = {
            [npcKeys.name] = "Dreamwarden Gorlas",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{47,21.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221404] = {
            [npcKeys.name] = "Dreamwarden Anadelle",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{37.6,12}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221406] = {
            [npcKeys.name] = "Moonwalker Betrayer",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{48.2,13.2},{48.4,12.4},{48.6,12.4},{48.6,12.6},{48.8,11.4},{50,12},{50.4,11.2},{50.4,12.8},{50.6,11.8},{50.6,12.8},{50.8,10.4},{51.2,10.8},{51.6,11.2},{52.6,11.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221407] = {
            [npcKeys.name] = "Dreamshadow Imp",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{48.4,12.4},{48.4,12.6},{48.6,12.2},{48.6,12.6},{49.4,11.4},{50.2,10.4},{50.2,10.8},{50.2,12.4},{50.2,12.6},{50.4,7.4},{50.4,7.6},{50.4,9.2},{50.6,7.4},{50.6,7.6},{50.8,10.4},{50.8,10.6},{50.8,11.6},{51,12.6},{51.6,8},{51.6,11.2},{51.6,11.8},{52.6,8.6},{53.2,10.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221408] = {
            [npcKeys.name] = "Night Hunter",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{49.8,12.2},{50,11.2},{50.2,12.6},{50.4,9.8},{50.6,10},{50.8,11.6},{51,12.8},{51.2,10.8},{51.6,12.4},{51.6,12.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221426] = {
            [npcKeys.name] = "Atal'ai Ritualist",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221471] = {
            [npcKeys.name] = "Field Captain Palandar",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{45.6,51.2},{46.4,47.6},{46.6,47.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81716,81730,81731,81732,81733,81734,81735,81736,81737,81738,81739,81740,81741,81742,81743,81744,81745,81746,81747},
            [npcKeys.questEnds] = {81716,81730,81731,81732,81733,81734,81735,81736,81737,81738,81739,81740,81741,81742,81743,81744,81745,81746,81747},
        },
        [221472] = {
            [npcKeys.name] = "Scout Charla",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{47,36}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221477] = {
            [npcKeys.name] = "Field Captain Hannalah",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{89.4,40.6},{89.6,40.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81727,81768,81769,81770,81771,81772,81773,81774,81775,81776,81777,81778,81779,81780,81781,81782,81783,81784,81785,82017},
            [npcKeys.questEnds] = {81727,81768,81769,81770,81771,81772,81773,81774,81775,81776,81777,81778,81779,81780,81781,81782,81783,81784,81785},
        },
        [221479] = {
            [npcKeys.name] = "Field Captain Korlian",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{61.4,34.4},{61.4,34.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81728,81786,81787,81788,81789,81817,81820,81826,81830,81832,81833,81834,81835,81837,81838,81839,81850,81851,81852,82068,84011,84012,84013},
            [npcKeys.questEnds] = {81728,81786,81787,81788,81789,81817,81820,81826,81830,81832,81833,81834,81835,81837,81838,81839,81850,81851,81852,82068,84011,84012,84013},
        },
        [221480] = {
            [npcKeys.name] = "Field Captain Arunnel",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{48.4,12.4},{48.6,12.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81729,81855,81856,81857,81858,81859,81860,81861,81863,81864,81865,81866,81867,81868,81870,81871,81872,81873,81874,82068,84014,84015,84016},
            [npcKeys.questEnds] = {81729,81855,81856,81857,81858,81859,81860,81861,81863,81864,81865,81866,81867,81868,81870,81871,81872,81873,81874,82068,84014,84015,84016},
        },
        [221482] = {
            [npcKeys.name] = "Scout Gemeron",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{93.8,35.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221483] = {
            [npcKeys.name] = "Scout Fallia",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{61.8,24}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221484] = {
            [npcKeys.name] = "Scout Thandros",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{51,10.4},{51,10.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221493] = {
            [npcKeys.name] = "[DNT] Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221575] = {
            [npcKeys.name] = "Elrick",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 15,
            [npcKeys.spawns] = {
                [15] = {{66.4,45.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {81765},
            [npcKeys.questEnds] = {81764},
        },
        [221587] = {
            [npcKeys.name] = "Aeonas the Vindicated",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 361,
            [npcKeys.spawns] = {
                [361] = {{45,52}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {81885,82135},
            [npcKeys.questEnds] = {81885},
        },
        [221631] = {
            [npcKeys.name] = "[DNT] Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221636] = {
            [npcKeys.name] = "Gregory",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 361,
            [npcKeys.spawns] = {
                [361] = {{44.6,52}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {81790},
            [npcKeys.questEnds] = {81790},
        },
        [221637] = {
            [npcKeys.name] = "Gasher",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221638] = {
            [npcKeys.name] = "Loro",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221639] = {
            [npcKeys.name] = "Zolo",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221640] = {
            [npcKeys.name] = "Zul'Lor",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221651] = {
            [npcKeys.name] = "Ceruleos",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{36,68.8},{36.2,70},{36.4,71.8},{36.4,73},{37,71},{37,71.6},{37,72.6},{37.4,70},{37.6,71.2},{38.2,72.4},{38.4,73},{38.4,73.6},{38.8,73},{39.4,72.4},{39.6,71.2},{39.6,75.2},{40,71.8},{41.4,71.4},{41.4,72.4},{41.4,73.2},{41.8,71.2},{41.8,72},{41.8,72.6},{42.6,71.6},{44,67.2},{45.4,67.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221656] = {
            [npcKeys.name] = "Stern-faced Bar Patron",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 15,
            [npcKeys.spawns] = {
                [15] = {{66.4,45.4},{66.6,45.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221658] = {
            [npcKeys.name] = "[DNT] Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221732] = {
            [npcKeys.name] = "Atal'ai Defenders Controller",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221740] = {
            [npcKeys.name] = "Calefactus the Unleashed",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 4,
            [npcKeys.spawns] = {
                [4] = {{44,35.4},{44,38.2},{44,38.8},{44.2,31.4},{44.4,36.2},{44.4,37.2},{44.4,43.8},{44.6,39},{44.6,46.8},{44.8,44.8},{45,37.2},{45,39.6},{45,41},{45,41.6},{45,49.2},{45.2,29.8},{45.2,31.8},{45.2,33.2},{45.2,43.4},{45.2,50.6},{45.4,28.2},{45.4,34.4},{45.4,35.4},{45.4,35.8},{45.4,38.4},{45.4,44.2},{45.4,48.2},{45.4,52},{45.4,52.8},{45.4,54.2},{45.6,37.6},{45.6,40.2},{45.6,42.2},{45.6,51.4},{45.8,32.2},{45.8,34},{45.8,48.2},{46.2,33.4},{46.2,37.2},{46.2,53},{46.2,54},{46.4,34.6},{46.4,35.6},{46.4,38.6},{46.4,47.2},{46.4,49.4},{46.4,52.4},{46.6,35.6},{46.6,36.8},{46.6,39},{46.6,52},{46.6,55},{46.8,34.2},{46.8,34.6},{46.8,38.2},{47,47.4},{47,52.6},{47.2,48.2},{47.2,50},{47.4,48.6},{47.4,51},{47.4,54},{47.6,47.4},{47.6,49.8},{47.6,51},{47.8,33.8},{47.8,48.6},{47.8,53.6},{48,33.4},{48,51.6},{48.2,34.6},{48.2,39},{48.2,48},{48.2,53.2},{48.4,36.8},{48.4,38.4},{48.6,49.2},{48.6,51.2},{48.8,35.2},{48.8,48.2},{49,37.2},{49,50.2},{49.2,38.4},{49.2,52.4},{49.4,38.8},{49.8,38.2},{49.8,52.2},{49.8,52.8},{50,36.6},{50,39},{50.2,36.4},{50.4,40.2},{50.6,36.8},{50.6,38.4},{50.6,50.2},{51.2,39.2},{51.4,36.4},{51.8,33.2},{52.2,36.6},{53.2,30.4},{53.4,28.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221759] = {
            [npcKeys.name] = "Gasher",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221761] = {
            [npcKeys.name] = "Hakkar",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221762] = {
            [npcKeys.name] = "Hakkar",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221827] = {
            [npcKeys.name] = "Magister Falath",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 1537,
            [npcKeys.spawns] = {
                [1537] = {{26.4,9.4},{26.4,9.6},{26.4,10.6},{26.6,9.4},{27,8.4},{27.2,11.6},{27.4,9.8},{27.4,10.6},{27.6,10.4},{27.6,11.2},{27.6,11.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221828] = {
            [npcKeys.name] = "Vengeful Spirit",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{28.8,47.4},{29.2,47.8},{29.4,49.4},{29.4,49.6},{29.8,49.4},{29.8,50.2},{30.8,49.6},{30.8,50.8},{31.4,43.8},{31.8,44},{32,50.4},{32,50.8},{32.2,48.4},{32.4,45.4},{32.4,45.8},{32.4,47.4},{32.4,49.2},{32.6,45.2},{32.6,46},{32.6,47},{32.6,47.8},{32.8,44}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221829] = {
            [npcKeys.name] = "Kajind",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{51.6,27.4},{51.6,27.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221830] = {
            [npcKeys.name] = "Wandering Swordsman",
            [npcKeys.minLevel] = 48,
            [npcKeys.maxLevel] = 48,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{51.6,27.4},{51.6,27.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221831] = {
            [npcKeys.name] = "Gos Greasebasher",
            [npcKeys.minLevel] = 46,
            [npcKeys.maxLevel] = 46,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{51.6,27.4},{51.6,27.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221832] = {
            [npcKeys.name] = "Silver Hand Charger",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 361,
            [npcKeys.spawns] = {
                [361] = {{51,81.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221833] = {
            [npcKeys.name] = "Hukku",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221834] = {
            [npcKeys.name] = "Loro",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221835] = {
            [npcKeys.name] = "Mijan",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221836] = {
            [npcKeys.name] = "Zolo",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221837] = {
            [npcKeys.name] = "Zul'Lor",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221838] = {
            [npcKeys.name] = "Josh's Kill Credit Creature P3",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221916] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221924] = {
            [npcKeys.name] = "Kazkaz the Unholy",
            [npcKeys.minLevel] = 48,
            [npcKeys.maxLevel] = 48,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221928] = {
            [npcKeys.name] = "Hippogryph Avatar",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{34.4,48.8},{34.6,49}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221933] = {
            [npcKeys.name] = "Moonkin Avatar",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{66.2,53}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221935] = {
            [npcKeys.name] = "Treant Avatar",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{58.4,52},{58.6,52.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221942] = {
            [npcKeys.name] = "Morphaz",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221943] = {
            [npcKeys.name] = "Hazzas",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221981] = {
            [npcKeys.name] = "[DNT] Sleeping Copy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221985] = {
            [npcKeys.name] = "Tyrisius",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{57.2,69}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81924},
            [npcKeys.questEnds] = {81924},
        },
        [222004] = {
            [npcKeys.name] = "Corrupt Moderate Manifestation of Water",
            [npcKeys.minLevel] = 44,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{15,49.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222005] = {
            [npcKeys.name] = "Moderate Manifestation of Water",
            [npcKeys.minLevel] = 44,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{14.8,49.4},{14.8,49.6}},
                [357] = {{35.8,32.4},{36,32.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {82076},
            [npcKeys.questEnds] = {82073,82076},
        },
        [222008] = {
            [npcKeys.name] = "Rope Climber",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222044] = {
            [npcKeys.name] = "Twilight Dark Shaman",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{35.8,32.4},{35.8,32.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222052] = {
            [npcKeys.name] = "Explorer Imp",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {81967,82301,82302,82303,83188,83189,83190,83191,83192,84525},
            [npcKeys.questEnds] = {81967,82301,82302,82303,83188,83189,83190,83191,83192,84525},
        },
        [222058] = {
            [npcKeys.name] = "Bonfire",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222088] = {
            [npcKeys.name] = "Nightmare Whelpling",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222089] = {
            [npcKeys.name] = "Nightmare Scalebane",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222174] = {
            [npcKeys.name] = "Dual Spec Peon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222188] = {
            [npcKeys.name] = "Shadowy Figure",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 493,
            [npcKeys.spawns] = {
                [493] = {{52,40.4},{52,40.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81986,82021,82022},
            [npcKeys.questEnds] = {81986,82021,82022},
        },
        [222192] = {
            [npcKeys.name] = "Nightmare Vine",
            [npcKeys.minLevel] = 52,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222198] = {
            [npcKeys.name] = "Nightmare Amalgamation",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{87.8,68.4},{88.2,67.4},{88.2,68.6},{88.6,66.2},{88.6,67},{88.6,68.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222210] = {
            [npcKeys.name] = "Josh's Kill Credit Creature P3",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222225] = {
            [npcKeys.name] = "Josh's Kill Credit Creature P3",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222228] = {
            [npcKeys.name] = "Fel Sliver",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{37.4,16.6},{37.6,16.6},{38.6,15.4},{39.4,13.8},{39.6,13.8},{40,18.2},{40.8,14.4},{41.6,48.4},{42,14.2},{42.4,45},{42.6,44.8},{42.6,50.4},{43.4,44.2},{44.4,50},{44.4,54.8},{45,45.8},{45.8,51.4},{46.4,52.6},{47.6,49.4},{51.6,53.4},{53,50.8},{54.2,52.6},{54.4,48.4},{54.4,48.6},{55.6,25.6},{55.8,51},{56,24.8},{57.6,23.4},{57.6,23.6},{58.2,49.8},{58.8,25.6},{59,29.2},{59,32},{59.2,36.4},{59.2,36.6},{59.8,27.4},{59.8,27.6},{60.2,36},{60.8,29},{61.8,31.8}},
                [40] = {{28.4,43.8},{28.6,44},{28.8,47.2},{28.8,47.6},{29,58.2},{29,58.8},{29.4,68.8},{29.6,69.4},{29.8,34.4},{31.4,39.2},{31.4,39.6},{31.4,65},{31.4,65.6},{31.6,39.2},{31.6,65.4},{31.6,65.6},{32,80.2},{32.2,29.4},{32.2,29.6},{32.2,76},{34,82.2},{34.4,82.6},{34.8,61},{35.8,32.4},{36,32.8},{37.4,85},{37.4,85.6},{37.6,85},{37.6,85.6},{41.4,15.4},{41.4,15.8},{41.6,15.2},{44.4,46.4},{44.4,46.6},{44.8,46.2},{44.8,46.6},{46.4,12},{46.4,12.6},{46.8,12.2},{46.8,12.6},{46.8,39.6},{47,39.4},{47.2,67.6},{47.4,21.8},{47.4,67.4},{47.4,79.2},{47.4,79.6},{47.6,22},{47.6,67.2},{47.6,67.6},{47.6,79.2},{47.6,79.6},{47.8,13.8},{51,32.2},{51,32.6},{51.6,71.4},{51.6,71.6},{53,80.2},{57,10.4},{57,10.6},{62.4,26.6},{62.6,26.6},{62.8,26.4}},
                [130] = {{38.8,14.8},{38.8,23.4},{39,18},{44.2,25.2},{44.6,25.2},{44.6,25.8},{45.4,31.8},{45.6,31.8},{49.8,13.4},{50.2,56.8},{50.2,65.2},{54.2,35.4},{54.4,35.6},{54.6,35.8},{55.4,24.6},{55.4,57},{55.6,24.6},{55.6,57},{55.6,57.6},{56.6,16},{60.8,7},{66.6,57.4}},
                [148] = {{36,82.8},{36.2,71.6},{37.4,63.8},{37.6,63.8},{40.4,89.6},{40.6,89.8},{40.8,73.8},{43.2,27},{44.2,82},{45,26.2},{45.2,58.2},{46.2,46.8},{47.4,28.4},{47.4,28.6},{47.8,29.8},{49.8,36.8},{56.4,24.8},{59.8,21.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222232] = {
            [npcKeys.name] = "Corrupt Moderate Manifestation of Air",
            [npcKeys.minLevel] = 46,
            [npcKeys.maxLevel] = 47,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{50.8,47.6},{51,46.4},{51.2,47}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222233] = {
            [npcKeys.name] = "Ohk'zi",
            [npcKeys.minLevel] = 43,
            [npcKeys.maxLevel] = 43,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{75,25}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222243] = {
            [npcKeys.name] = "Zopilote",
            [npcKeys.minLevel] = 43,
            [npcKeys.maxLevel] = 43,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{38.4,31.8},{39.4,31.6},{40,31.8},{40.2,32.6},{41.2,31.2},{41.2,32.4},{41.2,33},{41.2,33.6},{41.2,34.6},{41.8,32.2},{42,34.4},{42.2,33.4},{42.4,35.2},{42.6,33.8},{42.8,28.2},{42.8,32.2},{42.8,35.6},{43,31},{43,32.6},{43,35.2},{43.8,32},{43.8,32.8},{43.8,33.6},{44.2,35.6},{44.2,36.8},{44.4,31.4},{44.6,35.6},{44.6,36.6},{44.8,30.4},{44.8,31.8},{45,30.8},{45,34.6},{45.6,32.2},{45.8,28.4},{45.8,30.6},{45.8,33.4},{46,29.2},{46,30.4},{46,36},{46.6,24.6},{46.6,35.2},{46.8,30.4},{46.8,31},{47,33.2},{47,35.6},{47.4,31.6},{47.6,32},{47.6,35.4},{48,29.8},{48,31.4},{48,35.8},{48.4,32.8},{48.4,33.8},{48.6,30},{48.6,35.6},{48.8,32.4},{48.8,33},{48.8,37.4},{49.4,25.6},{49.4,33.6},{49.6,32.2},{49.6,34},{49.6,34.6},{49.8,36},{50,32.8},{50.2,36.6},{50.6,36.6},{50.8,28.6},{51,33.4},{51,34.4},{51,35.2},{51.2,29.8},{51.4,21.4},{51.4,27.6},{51.4,36.2},{51.6,35.4},{52,36.4},{52.2,27.4},{52.2,37.2},{52.4,33.4},{52.4,37.6},{52.6,37},{52.8,36.4},{53.4,38},{53.8,36.2},{54,37.6},{54.4,37},{54.4,39},{54.6,33.8},{54.8,37.8},{55,36},{55,39.4},{55.4,39.8},{55.6,39.4},{55.6,40},{55.8,40.6},{57,33},{58.2,36.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222244] = {
            [npcKeys.name] = "[DNT] Spinning Flower",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222249] = {
            [npcKeys.name] = "[DNT] Bell Flower",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222250] = {
            [npcKeys.name] = "[DNT] Dripping Flower",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222251] = {
            [npcKeys.name] = "[DNT] Drooping Flower",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222252] = {
            [npcKeys.name] = "[DNT] Orange Flower",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222253] = {
            [npcKeys.name] = "[DNT] Purple Flower",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222254] = {
            [npcKeys.name] = "[DNT] Bell Flower 2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222256] = {
            [npcKeys.name] = "[DNT] Bell Flower 3",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222257] = {
            [npcKeys.name] = "[DNT] Purple Flower 2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222261] = {
            [npcKeys.name] = "Maximillian \"The Greaser\"",
            [npcKeys.minLevel] = 36,
            [npcKeys.maxLevel] = 36,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{79.8,77.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81987,82001,82002,82003,82013},
            [npcKeys.questEnds] = {81987,82001,82002,82011,82013},
        },
        [222269] = {
            [npcKeys.name] = "[DNT] Drooping Flower 2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222286] = {
            [npcKeys.name] = "Namida Grimtotem",
            [npcKeys.minLevel] = 43,
            [npcKeys.maxLevel] = 43,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{66.4,38.4},{66.6,38.2},{66.8,38.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222288] = {
            [npcKeys.name] = "Fel Rift",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{20.4,43.4},{20.4,43.6},{21,43.4},{21,43.6},{22.4,52.2},{22.4,52.6},{22.6,52.4},{22.8,52.6},{24,64.4},{24.4,65},{29.2,43.4},{29.4,44},{29.8,43.4},{36.2,60.8},{36.4,61.6},{37.4,42},{37.6,42.2},{57.4,45},{57.4,45.6},{57.6,45.4},{60,65},{69.2,26.2},{69.2,26.8},{69.6,26.4},{72.2,31.2},{72.2,31.8},{85.4,43.4},{85.4,44},{85.6,43.6},{93.2,59},{93.6,58.8}},
                [139] = {{22,34.2},{24.4,19.4},{24.4,19.6},{24.6,19.4},{24.8,19.8},{28.8,44},{28.8,44.6},{38,16.6},{38,40},{38.2,16.4},{38.2,25.8},{82.4,37.2},{82.6,37.2},{82.8,40.2},{82.8,40.6},{83.4,46.2},{83.6,46},{83.6,46.6},{83.8,43.6},{84,43.2},{86.8,42.6},{87,42.4}},
                [618] = {{52,89.4},{52,89.6},{57.2,89},{58.2,83.2},{58.2,86.2},{59.2,83.6},{59.4,83.4},{62.2,85.2},{63.2,80},{63.8,80.6},{64.2,78.4},{64.2,78.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222289] = {
            [npcKeys.name] = "Moderate Manifestation of Air",
            [npcKeys.minLevel] = 46,
            [npcKeys.maxLevel] = 47,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{51,46.4},{51,46.8}},
                [357] = {{35.8,32.4},{35.8,32.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {81968},
            [npcKeys.questEnds] = {81960,81968},
        },
        [222290] = {
            [npcKeys.name] = "Unfortunate Adventurer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222293] = {
            [npcKeys.name] = "Dream Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222316] = {
            [npcKeys.name] = "Fizzbizz Coppercoil",
            [npcKeys.minLevel] = 36,
            [npcKeys.maxLevel] = 36,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{77,77.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {82004,82008,82009,82010,82011},
            [npcKeys.questEnds] = {82003,82004,82008,82009,82010},
        },
        [222367] = {
            [npcKeys.name] = "Groddoc Infant",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{52.6,60.4},{52.6,60.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222376] = {
            [npcKeys.name] = "Groddoc Infant",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{59,58.4},{59,58.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222402] = {
            [npcKeys.name] = "ST Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222403] = {
            [npcKeys.name] = "ST Professions",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222404] = {
            [npcKeys.name] = "PvP items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222405] = {
            [npcKeys.name] = "Leyline Conflux",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{18.2,79.4},{18.2,79.6}},
                [47] = {{47.8,59}},
                [51] = {{54.8,66.2},{55,66.6}},
                [357] = {{57.2,61.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222406] = {
            [npcKeys.name] = "Groddoc Matriarch",
            [npcKeys.minLevel] = 43,
            [npcKeys.maxLevel] = 43,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{59,58.6},{59.2,58.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222407] = {
            [npcKeys.name] = "Enraged Leywalker",
            [npcKeys.minLevel] = 47,
            [npcKeys.maxLevel] = 47,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{18.2,79.4},{18.2,79.6}},
                [47] = {{47.4,59.2},{47.8,59}},
                [51] = {{54.4,66.2},{54.8,66}},
                [357] = {{57.2,61.4},{57.2,61.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222408] = {
            [npcKeys.name] = "Shadowtooth Emissary",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 361,
            [npcKeys.spawns] = {
                [361] = {{51.4,82},{51.6,82}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {82043,84384},
            [npcKeys.questEnds] = {82044,84384},
        },
        [222409] = {
            [npcKeys.name] = "Boss \"Gobb\" Goldnick",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{88.4,55.4},{90,58},{90.8,57.2},{91,58}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222410] = {
            [npcKeys.name] = "Shadowy Figure",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222411] = {
            [npcKeys.name] = "Josh's Kill Credit Creature P3",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222412] = {
            [npcKeys.name] = "Random Worm",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222413] = {
            [npcKeys.name] = "Zalgo the Explorer",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{15.2,15.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {82016,82093,82094},
            [npcKeys.questEnds] = {82016,82093,82094},
        },
        [222415] = {
            [npcKeys.name] = "Dire Troll Roulette",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222416] = {
            [npcKeys.name] = "Skeletal Wind Serpent",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222418] = {
            [npcKeys.name] = "Riding Bat",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222444] = {
            [npcKeys.name] = "Injured Gnome",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{26.8,77.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {82023},
            [npcKeys.questEnds] = nil,
        },
        [222451] = {
            [npcKeys.name] = "Itty Bitty Murloc",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{40.8,85.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {82023},
        },
        [222478] = {
            [npcKeys.name] = "Sentinel Keldara Sunblade",
            [npcKeys.minLevel] = 44,
            [npcKeys.maxLevel] = 44,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{20.4,62},{20.6,61.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222495] = {
            [npcKeys.name] = "Serpent's Ascension Visual",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222513] = {
            [npcKeys.name] = "Wild Growth",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222514] = {
            [npcKeys.name] = "Nightmare Mushroom",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222516] = {
            [npcKeys.name] = "Dream Fog",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222519] = {
            [npcKeys.name] = "Unbalanced Druid",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222521] = {
            [npcKeys.name] = "Dreamstone",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222522] = {
            [npcKeys.name] = "Spirit of Agamaggan",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 722,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {82044},
            [npcKeys.questEnds] = {82043},
        },
        [222523] = {
            [npcKeys.name] = "[DNT] Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222525] = {
            [npcKeys.name] = "Anvilrage Patrol",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1584,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222530] = {
            [npcKeys.name] = "Rugged Traveler",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1584,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {82062},
        },
        [222531] = {
            [npcKeys.name] = "Ragged Traveler",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{36,22},{36,22.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222542] = {
            [npcKeys.name] = "Atal'ai Drum",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222543] = {
            [npcKeys.name] = "Atal'ai Slab",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222544] = {
            [npcKeys.name] = "Atal'ai Mask",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222545] = {
            [npcKeys.name] = "Atal'ai Candle",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222546] = {
            [npcKeys.name] = "Iodax the Obliterator",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{65.2,46.6},{65.4,44.2},{65.4,45.4},{65.4,45.6},{65.6,48.2},{65.8,44.4},{65.8,45.4},{65.8,45.6},{66,46.6},{66.6,43.8},{66.6,45.4},{66.8,42.4},{66.8,46.2},{66.8,46.6},{67,43}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222551] = {
            [npcKeys.name] = "Grendag Brightbeard",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{68.2,23}},
                [1537] = {{44,10},{44.6,11},{45,10.2}},
                [1637] = {{49,57.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222553] = {
            [npcKeys.name] = "Atal'ai Mummy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222566] = {
            [npcKeys.name] = "Animated Flame",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222573] = {
            [npcKeys.name] = "Delirious Ancient",
            [npcKeys.minLevel] = 52,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 1176,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222580] = {
            [npcKeys.name] = "Child of Apa'ro",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{42,38},{42.2,36.2},{42.4,33.6},{42.4,34.6},{42.8,34.2},{42.8,34.6},{43,32.4},{43,33},{43.2,27.4},{43.2,31.4},{43.4,28.4},{43.4,29},{43.4,29.8},{43.6,28.8},{43.6,31},{43.6,32},{43.8,30},{44.4,28.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222617] = {
            [npcKeys.name] = "Moderate Manifestation of Fire",
            [npcKeys.minLevel] = 47,
            [npcKeys.maxLevel] = 48,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{23.8,73}},
                [357] = {{35.6,32.4},{35.6,32.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {82074},
            [npcKeys.questEnds] = {82071,82074},
        },
        [222620] = {
            [npcKeys.name] = "Corrupt Moderate Manifestation of Fire",
            [npcKeys.minLevel] = 47,
            [npcKeys.maxLevel] = 48,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{23.2,73.6},{23.2,76.8},{23.4,72.4},{23.4,72.8},{23.6,72.6},{24,72.4},{24.2,71.2},{26.4,74}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222623] = {
            [npcKeys.name] = "Moderate Manifestation of Earth",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 46,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{36,32.4},{36,32.6}},
                [440] = {{62,62.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {82075},
            [npcKeys.questEnds] = {82072,82075},
        },
        [222625] = {
            [npcKeys.name] = "Corrupt Moderate Manifestation of Earth",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 46,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{62,62.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222636] = {
            [npcKeys.name] = "Ancient Shrine",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222647] = {
            [npcKeys.name] = "Ancient Spirit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222648] = {
            [npcKeys.name] = "Wild Shrine",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222649] = {
            [npcKeys.name] = "Wild Spirit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222650] = {
            [npcKeys.name] = "Windswept Shrine",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222651] = {
            [npcKeys.name] = "Windswept Spirit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222656] = {
            [npcKeys.name] = "Defias Night Blade",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{45,66.8},{45,71.8},{46.2,73.8},{46.2,75.2},{46.4,76.2},{46.6,74.8},{46.8,71.8},{46.8,73.2},{47,74.4},{47.2,76.6},{47.4,69.6},{47.4,71.4},{47.4,76.4},{47.4,78},{47.6,70.4},{47.8,71.2},{47.8,75.6},{48.2,68.4},{48.2,76.6},{48.4,72.4},{48.4,73.2},{48.4,73.8},{48.4,75.2},{48.6,72.4},{48.6,74},{48.6,75.6},{48.8,73},{49,74.6},{49.2,70.6},{49.6,70.6},{49.6,72.6},{49.6,75.4},{50,74.4},{50,76},{50,76.8},{50.2,70.4},{50.2,72.4},{50.6,71.4},{50.6,73.2},{50.8,71.6},{50.8,75.8},{51,75},{51.4,74},{51.6,73.6},{51.6,75},{52,73.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222684] = {
            [npcKeys.name] = "Quartermaster Falinar",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{45.6,51.2},{46.8,47.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222685] = {
            [npcKeys.name] = "Quartermaster Kyleen",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{89.4,40.6},{89.6,40.4},{89.6,40.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222686] = {
            [npcKeys.name] = "Quartermaster Alandra",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{61.4,34.4},{61.4,34.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222687] = {
            [npcKeys.name] = "Quartermaster Valdane",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{48.4,12.4},{48.4,12.6},{48.6,12.4},{48.6,12.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222689] = {
            [npcKeys.name] = "Blood-crazed Spirit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222694] = {
            [npcKeys.name] = "Furniture",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222695] = {
            [npcKeys.name] = "Vilebranch Mask",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{72.4,52.8},{72.6,52.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222696] = {
            [npcKeys.name] = "Fel Crack",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{42.8,81.8},{43,78.2},{43.2,80.2},{43.8,73.4},{43.8,73.6},{43.8,83.8},{46,85.4},{46.2,85.6},{47.8,83.6},{48.4,81.2},{48.4,83},{48.6,83},{50.2,80.6}},
                [44] = {{29.4,29.6},{29.8,29.4},{29.8,29.8},{30.4,22.2},{30.8,21.8},{30.8,22.6},{42.4,16.4},{42.4,17.4},{42.6,16.6},{71.2,58.6},{71.4,57.8},{71.4,83.4},{71.4,84},{71.6,58.8},{71.6,83.4},{71.8,83.8},{72,57.8},{78.8,65.8},{79,33.4},{79,33.6},{79,65.4},{79,73},{79.6,32.8},{79.8,33.6},{81.4,60.8},{81.6,60.4},{81.8,60.8},{83,44.6},{83.2,44.4},{83.2,45.6},{83.8,45.4},{86.2,52.6},{86.4,52.4},{86.6,53}},
                [331] = {{23.2,56.2},{24.2,63.4},{27.6,62.4},{27.8,62.6},{30.2,30.2},{33.4,28.4},{33.4,28.6},{33.6,28.4},{44.4,64.2},{44.6,64.2},{51,47},{52.4,62.4},{52.4,62.8},{52.6,62.8},{55.4,40.2},{55.6,40.2},{67,46},{67.2,51},{77.2,73.2},{80.4,70.8},{80.6,70.8},{84.4,69.4},{84.4,69.6},{84.6,69.4},{84.8,70.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222697] = {
            [npcKeys.name] = "Fel Tear",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 8,
            [npcKeys.spawns] = {
                [8] = {{10.4,59.4},{10.4,60.2},{10.4,60.6},{10.6,60.2},{10.6,60.6},{12,29.4},{12.4,29.8},{12.6,29.4},{12.6,29.8},{16.4,63},{16.4,63.6},{16.6,63.6},{16.8,62.6},{22.4,64.2},{22.8,64},{22.8,64.6},{26.8,50},{27,48.8},{34,28.6},{34.4,28.2},{34.6,28},{36.2,50.6},{36.4,50},{36.6,50},{49.2,38.2},{49.4,38.6},{49.8,38.4},{49.8,38.6},{56.4,65},{56.4,65.8},{56.6,65},{56.8,65.6},{60.2,27.6},{60.6,27.8},{60.8,27.4},{61,43.4},{61.2,43.8},{69.2,78},{69.6,78.8},{69.8,78},{72.2,11},{72.4,10.4},{72.8,10.4},{72.8,11},{77,89.2},{77.2,89.6},{77.6,89.2},{77.6,89.8},{81.2,34},{81.2,35},{83.2,66.6},{83.4,66.2},{83.6,65.4},{83.6,66.6},{83.8,66.4},{86.8,26.6},{87.2,26.2},{87.6,26},{90.8,65.2},{91,65.6},{91.2,56.4},{91.4,57},{91.6,56.4}},
                [405] = {{47.4,22.2},{48.8,82.2},{49.4,74.4},{49.4,75},{49.6,74.4},{49.6,74.8},{52,85.4},{52,85.6},{52.2,72.4},{52.2,72.6},{52.8,81},{54.4,19.2},{54.6,28.8},{56,74.8},{56.2,74.4},{71.4,18.4},{71.4,18.8},{71.6,18.4},{71.6,18.8},{72.4,22},{72.6,21.8},{73.4,24.4},{73.4,24.6},{73.6,24.4},{73.6,24.8},{74.4,10.2},{74.4,10.6},{74.6,10.4},{74.6,10.6},{76.4,19.2},{76.6,19.2},{80.4,17},{80.6,17.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222698] = {
            [npcKeys.name] = "Fel Scar",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 4,
            [npcKeys.spawns] = {
                [4] = {{35,55.2},{41.2,33.4},{41.2,33.6},{43.6,25.2},{43.6,25.6},{46.4,39.2},{46.6,39.2},{48.4,48},{49,48.2},{56.2,36.8},{56.4,36.4},{60.2,46},{60.2,46.6},{62,39.2}},
                [16] = {{16.4,51},{16.6,51},{17.8,58.6},{21.2,54},{24.8,47.8},{25,81.4},{25,81.6},{30.2,79.8},{33,81.4},{33,81.6}},
                [357] = {{68.2,58.8},{70.6,62.4},{70.6,62.6},{72.4,63.8},{72.6,63.8},{73.2,54.4},{74.2,50.4},{74.2,50.8},{74.2,56.8},{74.2,60},{76.2,56.4},{76.2,56.6},{76.6,63.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222699] = {
            [npcKeys.name] = "Enraged Stormcrow",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{35.4,22.8},{37.8,29.6},{38,28},{47.4,55},{49,55.6},{51.2,55.4},{52,57},{52.2,59.4},{52.4,57.8},{52.8,56.2},{53.2,58.6},{53.4,57.4},{53.4,57.6},{53.6,57.6},{53.6,58.6},{53.6,62.6},{53.8,57.4},{54,59.6},{54.2,50.8},{54.6,56.4},{54.6,56.8},{54.8,59.6},{55,51.6},{55,52.8},{55,54},{55.2,51.4},{55.2,57.6},{55.2,61.2},{55.4,54.8},{55.4,58.8},{55.6,55.8},{55.6,57.2},{55.8,59.4},{56,50.8},{56,58.4},{56.2,59.8},{56.8,58},{57.2,60},{57.4,59.2},{57.8,59.2},{58.2,56.8},{58.2,57.8},{59,59.8},{59.4,59},{59.6,56},{60,58.4},{65.4,54.4},{70.8,55}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222701] = {
            [npcKeys.name] = "Pile of Bones",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222702] = {
            [npcKeys.name] = "Murderous Lost One",
            [npcKeys.minLevel] = 46,
            [npcKeys.maxLevel] = 46,
            [npcKeys.zoneID] = 4,
            [npcKeys.spawns] = {
                [4] = {{45.2,16.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222703] = {
            [npcKeys.name] = "Whisperwing",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{33,48.2},{34,48.2},{34.4,48.8},{34.6,48.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222704] = {
            [npcKeys.name] = "Sagefeather",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{66,53}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222705] = {
            [npcKeys.name] = "Blightbark",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{56.8,50.8},{58.2,53},{58.4,52},{58.6,52.2},{58.8,51},{58.8,53.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222706] = {
            [npcKeys.name] = "STV PvP P3",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222707] = {
            [npcKeys.name] = "Nightmare Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222708] = {
            [npcKeys.name] = "Darkmoon Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222709] = {
            [npcKeys.name] = "Rift",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222710] = {
            [npcKeys.name] = "Door",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222726] = {
            [npcKeys.name] = "Tyrant of the Hive",
            [npcKeys.minLevel] = 46,
            [npcKeys.maxLevel] = 46,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{76.4,59.6},{76.4,61.2},{77.4,62},{77.8,62.2},{78,62.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222734] = {
            [npcKeys.name] = "[DNT] Dream Fog Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222763] = {
            [npcKeys.name] = "Mixmaster Blix",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{67,22.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {82090},
            [npcKeys.questEnds] = {82090},
        },
        [222765] = {
            [npcKeys.name] = "Desirous",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222768] = {
            [npcKeys.name] = "Lisabeth La'monalissier",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222772] = {
            [npcKeys.name] = "Crimeon Lablade",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{67,22.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {82089},
            [npcKeys.questEnds] = {82089},
        },
        [222789] = {
            [npcKeys.name] = "The Giant",
            [npcKeys.minLevel] = 52,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{45.4,17},{45.6,22.2},{45.8,14.6},{46.2,14.4},{46.2,16.8},{46.4,18.2},{46.4,18.8},{46.4,19.6},{46.4,21},{46.6,12},{46.6,18.4},{46.6,19},{46.6,19.6},{46.8,12.6},{46.8,16},{46.8,21.4},{47,11.4},{47,21.6},{47.2,14.2},{47.8,22.8},{48.2,12.6},{48.2,24.4},{48.4,12.2},{48.8,12.4},{49,25}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222799] = {
            [npcKeys.name] = "Simmering Elemental",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 42,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{78.4,48.4},{78.6,47.6},{79,49.6},{79.2,49.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222856] = {
            [npcKeys.name] = "Odd Totem",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{43,41.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222857] = {
            [npcKeys.name] = "Odd Totem",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{45.6,37.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222897] = {
            [npcKeys.name] = "Enraged Voidwalker",
            [npcKeys.minLevel] = 43,
            [npcKeys.maxLevel] = 43,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{58.4,36.4},{58.4,36.6},{58.6,36.4},{58.8,36.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222919] = {
            [npcKeys.name] = "Whirling Tempest",
            [npcKeys.minLevel] = 44,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{60,67}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222968] = {
            [npcKeys.name] = "Lethlas",
            [npcKeys.minLevel] = 52,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{48.2,12.8},{48.4,11.8},{49,12.2},{50.4,11.6},{50.4,16.4},{50.6,21.8},{50.8,18.2},{50.8,19.2},{50.8,21.2},{51,11.2},{51,12},{51,13.2},{51,19.6},{51.2,15.2},{51.2,16},{51.4,16.6},{52,16.6},{52.2,15.2},{52.4,16.2},{52.8,14.4},{52.8,15.4},{53,16.4},{53.2,16.6},{53.6,15.2},{53.6,17}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222970] = {
            [npcKeys.name] = "Rift",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222971] = {
            [npcKeys.name] = "Rift",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222972] = {
            [npcKeys.name] = "Rift",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222977] = {
            [npcKeys.name] = "Phantim",
            [npcKeys.minLevel] = 42,
            [npcKeys.maxLevel] = 42,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{80.2,49},{80.8,50.2},{81.4,48.4},{81.4,48.6},{81.4,51.2},{81.6,48.4},{81.6,48.6},{81.6,49.8},{82.4,46.6},{82.8,48.6},{82.8,49.6},{83.4,47.2},{83.4,48},{83.6,47.6},{83.6,48.6},{83.8,47},{84,45.2},{84.2,46},{84.4,44.4},{84.6,46.6},{84.8,45.4},{84.8,46},{85.4,44.4},{85.6,44.4},{85.8,46.6},{86,43.4},{86,46},{86.2,45},{86.4,42.4},{86.4,50},{86.6,42},{86.6,43.2},{86.6,44.4},{86.6,44.6},{86.6,48},{86.8,45.6},{86.8,46.6},{86.8,49.2},{86.8,50},{86.8,51.2},{87.2,40.6},{87.6,41.4},{87.6,43.6},{87.8,43.2},{87.8,46.8},{88,40.4},{88,42.2},{88.6,43.6},{88.8,41.6},{88.8,42.8},{89,40.8},{89,44.6},{89.4,40.4},{89.8,40}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222978] = {
            [npcKeys.name] = "Green Sludge",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{43.4,33},{43.6,33.2},{44,33.6},{44,50},{44,51.2},{44.2,49},{44.4,32.4},{44.6,32.4},{44.6,33.8},{44.6,49.4},{45,41},{45,43},{45.4,34.8},{45.4,37.2},{45.4,38},{45.4,39.2},{45.4,40.4},{45.8,39.4},{45.8,42.8},{45.8,46.6},{46,39.6},{46.2,35.4},{46.2,45},{46.4,35.6},{46.4,37.2},{46.4,38.2},{46.4,40.6},{46.4,42},{46.4,44.4},{46.6,38.2},{46.6,39.2},{46.6,40.2},{46.6,40.6},{46.6,42.6},{46.8,34.2},{46.8,35.4},{46.8,43.6},{47,36.4},{47.2,37.2},{47.2,41.8},{47.2,45},{47.6,40.8},{47.8,38},{47.8,40.4},{47.8,47.4},{48,39},{48.4,41.6},{48.6,40},{49,42.8},{49.2,41.6},{49.4,38},{49.4,39.2},{49.8,39.4},{49.8,41.2},{51,38.6},{51,43.8},{52,41.8},{55.2,43.8},{56.6,44.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223061] = {
            [npcKeys.name] = "Charged Totem",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{60,66.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223068] = {
            [npcKeys.name] = "Thunderhead Hippogryph",
            [npcKeys.minLevel] = 46,
            [npcKeys.maxLevel] = 48,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{15,49.8},{15.2,54.6},{15.4,51.8},{15.4,53.8},{15.6,68.2},{16,52.8},{16.2,53.8},{16.4,51.4},{16.4,52.2},{16.4,54.6},{16.4,65.4},{16.6,51},{16.6,51.8},{16.6,65.4},{16.6,65.8},{16.8,55.2},{17,53.2},{17.2,59.8},{17.4,53.6},{17.4,56.2},{17.4,57.2},{17.4,57.8},{17.4,59.4},{17.4,62.4},{17.4,62.6},{17.4,63.6},{17.6,50.4},{17.6,53.2},{17.6,53.6},{17.6,55.4},{17.6,58.8},{17.6,60.2},{17.8,60.8},{17.8,62.4},{17.8,63.6},{18,56.4},{18,57},{18,62.8},{18,65.6},{18.2,51.2},{18.2,57.6},{18.2,65.2},{18.4,52},{18.4,67},{18.6,54.4},{18.6,56},{18.6,57},{18.6,57.8},{18.6,61.6},{18.6,62.8},{18.6,64},{18.6,65.8},{18.8,51.4},{18.8,60.4},{18.8,64.6},{19,52.6},{19.2,50.2},{19.2,52},{19.2,54.6},{19.2,58.8},{19.2,67.2},{19.4,68.2},{19.6,52},{19.6,53},{19.6,54.2},{19.6,62.8},{19.8,51.4},{19.8,58.8},{20.2,54.6},{20.2,57.6},{20.2,64},{20.2,65.4},{20.2,65.8},{20.2,67},{20.4,50},{20.4,56.4},{20.4,56.6},{20.4,67.6},{20.6,51.8},{20.6,56.4},{20.6,57.2},{20.6,57.6},{20.6,63.8},{20.6,65},{20.6,66.6},{20.8,65.6},{20.8,68.4},{21.2,54},{21.2,58.6},{21.6,51},{21.6,57},{21.6,61.6},{22.2,55}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223123] = {
            [npcKeys.name] = "Diseased Forest Walker",
            [npcKeys.minLevel] = 43,
            [npcKeys.maxLevel] = 44,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{72.4,50.4},{72.4,50.8},{72.6,50.4},{72.6,50.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223127] = {
            [npcKeys.name] = "Dead Diseased Grimtotem Shaman",
            [npcKeys.minLevel] = 43,
            [npcKeys.maxLevel] = 44,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{69.4,43.2},{69.6,43.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223128] = {
            [npcKeys.name] = "Dead Diseased Woodpaw Mystic",
            [npcKeys.minLevel] = 42,
            [npcKeys.maxLevel] = 43,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{66.4,50.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223130] = {
            [npcKeys.name] = "Uprooted Gloomwood",
            [npcKeys.minLevel] = 46,
            [npcKeys.maxLevel] = 46,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{41,9.4},{42.2,10.8},{43.4,13.2},{43.8,13},{44.8,12.6},{45,10.8},{45,21.6},{45.4,12},{45.4,14.2},{45.4,14.8},{45.4,17.4},{45.4,17.6},{45.4,19.4},{45.4,19.8},{45.4,20.8},{45.8,21.8},{46,11.4},{46,13.2},{46.2,12.4},{46.2,14.4},{46.2,15.4},{46.2,16.4},{46.2,16.6},{46.2,17.6},{46.2,20.8},{46.4,19.2},{46.4,19.8},{46.4,24.6},{46.6,14.8},{46.6,15.8},{46.6,19.4},{46.6,21.4},{46.8,14},{46.8,21.6},{46.8,23.8},{46.8,25.2},{47,9.4},{47,16.8},{47.2,13.2},{47.4,22.6},{47.6,15.4},{47.8,14},{48.2,12.4},{48.2,12.6},{48.2,24},{48.4,16.4},{48.8,12.6},{49.4,11},{49.6,12.8},{50.4,13.6},{50.8,11.6},{51,11}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223212] = {
            [npcKeys.name] = "[DNT] Tanaris - Arena Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223264] = {
            [npcKeys.name] = "Delirious Ancient",
            [npcKeys.minLevel] = 52,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 2100,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223265] = {
            [npcKeys.name] = "Delirious Ancient",
            [npcKeys.minLevel] = 52,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 1584,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223287] = {
            [npcKeys.name] = "Fire Elemental",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{35,78},{35.2,79.4},{35.2,80.6},{35.8,73.4},{36.2,81.2},{36.4,80.2},{36.4,81.6},{36.6,80.6},{37,82.4},{37,83.4},{37.4,84.4},{37.4,84.6},{37.6,84.4},{37.6,84.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223340] = {
            [npcKeys.name] = "Fel Interloper",
            [npcKeys.minLevel] = 15,
            [npcKeys.maxLevel] = 18,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{37.4,16.6},{40.2,18.4},{40.8,14.4},{41.6,48.2},{41.8,14.2},{43.4,44.2},{44.2,50},{44.4,54.8},{45.8,51.2},{46.4,52.6},{47.6,49.4},{51.6,53.4},{53,50.8},{54,52.6},{54.4,48.6},{55.6,25.6},{55.8,51.2},{56,24.8},{57.6,23.4},{57.6,23.6},{58.2,49.8},{58.8,25.6},{59,29},{59,32},{59.2,36.4},{59.2,36.6},{59.8,27.4},{59.8,27.6},{60.2,36},{60.8,29},{61.8,32}},
                [40] = {{28.6,43.8},{28.8,58.6},{29,43.2},{29,58.2},{29.6,34},{29.6,69.4},{30,69.6},{31.4,39.2},{31.4,65},{31.4,66},{31.6,39.2},{32.2,29},{32.2,76.2},{32.2,80.2},{34,82.4},{34.8,61},{35.8,32.4},{35.8,32.6},{37.6,85.4},{41.2,15.6},{41.4,15.4},{44.4,46.6},{44.6,46.8},{46.6,12.4},{46.8,39.4},{47.4,21.8},{47.4,67.4},{47.4,79.4},{47.6,21.8},{47.6,67.4},{47.6,67.6},{47.6,79.4},{47.8,14},{50.8,32.2},{51.6,71.4},{53,80.2},{62.6,26.4},{62.6,26.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223345] = {
            [npcKeys.name] = "Lledra's Vehicle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223359] = {
            [npcKeys.name] = "Lledra's Vehicle Visual",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223413] = {
            [npcKeys.name] = "[DNT] Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223482] = {
            [npcKeys.name] = "Wild Gods Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223483] = {
            [npcKeys.name] = "Merchant Faction Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223485] = {
            [npcKeys.name] = "Fel Portal Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223496] = {
            [npcKeys.name] = "Void Zone",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223542] = {
            [npcKeys.name] = "Fel Interloper",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 28,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{42.8,81.8},{43.8,84},{46,85.6},{47.6,83.4},{48.4,81.2},{50.2,80.6}},
                [44] = {{29.2,30.4},{29.8,30},{30.4,22},{30.8,21.8},{32.2,20.8},{42.4,17},{42.6,17},{71,84.8},{71.4,58.2},{71.4,84},{78.8,65.6},{78.8,72.8},{81.8,60.8},{83.2,44.6},{86.4,52.4}},
                [331] = {{24.2,63.4},{27.6,62.6},{30.2,30},{33.6,28.4},{44.6,64.2},{50.8,47},{52.4,62.8},{55.6,40.2},{67,46},{67.2,51.2},{77.2,73.2},{80.4,71},{84.4,69.4},{84.8,70.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223543] = {
            [npcKeys.name] = "Fel Interloper",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 38,
            [npcKeys.zoneID] = 8,
            [npcKeys.spawns] = {
                [8] = {{10.4,60},{10.4,60.6},{10.6,60},{12.4,29.8},{12.6,29.8},{16,63.2},{16.8,62.2},{17,63},{22.6,64.6},{22.8,64.4},{27,49.8},{34.2,28.4},{34.2,28.6},{36.2,50},{49.2,38.8},{49.4,38.4},{49.8,38.6},{56.6,65.4},{56.8,65.6},{60.4,27.8},{60.6,27},{60.6,27.8},{60.8,43.2},{61.2,43.6},{69.4,78.4},{69.4,79.2},{69.6,78.4},{69.6,78.8},{72.2,10.4},{72.2,10.8},{72.6,10.4},{72.8,10.8},{77.2,89.6},{77.4,89.4},{77.6,89.4},{77.6,90},{81.2,34},{81.2,34.8},{83.6,66.2},{87,26.2},{90.6,65.8},{91,65.4},{91.2,56.6},{91.4,56}},
                [405] = {{47.4,22},{48.8,81.4},{48.8,82},{49.4,74.8},{49.6,75},{52,85.4},{52.2,72.2},{52.2,72.6},{52.2,85.6},{52.8,81},{54.2,19.2},{56,74.8},{71.4,18.8},{71.6,18.8},{72.2,22.2},{72.6,21.8},{73.4,24.6},{73.6,24.4},{73.6,24.6},{74.6,10.4},{76.2,19.2},{80.4,17.2},{80.4,17.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223544] = {
            [npcKeys.name] = "Fel Interloper",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 48,
            [npcKeys.zoneID] = 4,
            [npcKeys.spawns] = {
                [4] = {{34.8,56.2},{35,55},{41.2,33.4},{41.2,33.6},{43.6,25.2},{46.2,39.4},{46.6,39.2},{48.8,48.2},{49.2,48.6},{56.2,36.4},{56.2,36.6},{56.6,36.6},{58.8,41.2},{59.2,40.2},{59.8,42.4},{60.2,46.6},{60.4,46.4},{60.6,39},{60.6,44.8},{61.8,38.4},{62.2,39}},
                [16] = {{16.4,51},{17.4,58.4},{17.6,58.8},{21.2,54},{24.8,47.4},{24.8,47.6},{25,81.4},{25,81.6},{30.2,79.8},{33,81.4},{33,81.6}},
                [357] = {{68,58.4},{68.2,58.8},{70.6,62.4},{70.6,62.6},{72.4,63.6},{72.6,63.8},{73.2,54.2},{74,50.4},{74.2,50.6},{74.2,56.8},{74.2,60},{74.6,56.8},{76.2,56.4},{76.2,56.6},{76.6,63.8},{76.8,63.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223568] = {
            [npcKeys.name] = "Josh's Kill Credit Creature P3",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223581] = {
            [npcKeys.name] = "Rune Scrying Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223586] = {
            [npcKeys.name] = "Hukku",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223587] = {
            [npcKeys.name] = "Mijan",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223588] = {
            [npcKeys.name] = "Gasher",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223590] = {
            [npcKeys.name] = "Shrine of the Watcher",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{89.8,33.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {82316},
            [npcKeys.questEnds] = {82316},
        },
        [223591] = {
            [npcKeys.name] = "Echo of a Lost Soul",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 8,
            [npcKeys.spawns] = {
                [8] = {{50.2,62}},
                [33] = {{40.8,58.4}},
                [47] = {{72.6,68.4},{72.6,68.6}},
                [440] = {{53.8,29}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223720] = {
            [npcKeys.name] = "[DNT] Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223737] = {
            [npcKeys.name] = "[DNT] Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224242] = {
            [npcKeys.name] = "Saturated Ooze",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224243] = {
            [npcKeys.name] = "Deep Lurker",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224244] = {
            [npcKeys.name] = "Slime Maggot",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224245] = {
            [npcKeys.name] = "Oozeling",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224250] = {
            [npcKeys.name] = "Atal'ai Warrior",
            [npcKeys.minLevel] = 52,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224253] = {
            [npcKeys.name] = "Nightmare Wanderer",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224254] = {
            [npcKeys.name] = "Nightmare Wyrmkin",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224255] = {
            [npcKeys.name] = "Nightmare Scalebane",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224256] = {
            [npcKeys.name] = "Nightmare Whelp",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224257] = {
            [npcKeys.name] = "Atal'ai Slave",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224258] = {
            [npcKeys.name] = "Atal'ai High Priest",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224259] = {
            [npcKeys.name] = "Atal'ai Deathwalker",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224260] = {
            [npcKeys.name] = "Atal'ai Corpse Eater",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224262] = {
            [npcKeys.name] = "Unliving Atal'ai",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224263] = {
            [npcKeys.name] = "Atal'ai Witch Doctor",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224328] = {
            [npcKeys.name] = "Zalgo the Explorer",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = {
                [1477] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224386] = {
            [npcKeys.name] = "Fireguard Destroyer",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1584,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224965] = {
            [npcKeys.name] = "Khonsu",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1377,
            [npcKeys.spawns] = {
                [1377] = {{11.8,95}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {84317},
        },
        [226797] = {
            [npcKeys.name] = "Prazik Pilfershard",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{83,72.4},{83,72.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [226799] = {
            [npcKeys.name] = "Pixi Pilfershard",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 28,
            [npcKeys.spawns] = {
                [28] = {{43.2,84}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [226921] = {
            [npcKeys.name] = "The Destructor's Wraith",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [226922] = {
            [npcKeys.name] = "Zilbagob",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [226923] = {
            [npcKeys.name] = "Grimroot",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [226982] = {
            [npcKeys.name] = "Frijidar",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{69.8,37.4},{69.8,38},{70.2,38.8},{71.6,39.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227019] = {
            [npcKeys.name] = "Diathorus the Seeker",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227028] = {
            [npcKeys.name] = "Hellscream's Phantom",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227140] = {
            [npcKeys.name] = "Pyranis",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227206] = {
            [npcKeys.name] = "Astral Projection",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227324] = {
            [npcKeys.name] = "Novice Frost Mage",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 28,
            [npcKeys.spawns] = {
                [28] = {{36.8,54.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227385] = {
            [npcKeys.name] = "Novice Frost Mage",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 28,
            [npcKeys.spawns] = {
                [28] = {{45,52}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227386] = {
            [npcKeys.name] = "Novice Frost Mage",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 28,
            [npcKeys.spawns] = {
                [28] = {{53.2,64.2},{53.4,64.6},{53.6,64.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227387] = {
            [npcKeys.name] = "Novice Frost Mage",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 28,
            [npcKeys.spawns] = {
                [28] = {{64.2,57.8},{64.4,57.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227464] = {
            [npcKeys.name] = "Squire Cuthbert",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {84008},
        },
        [227493] = {
            [npcKeys.name] = "Sandworm",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1377,
            [npcKeys.spawns] = {
                [1377] = {{32.6,66},{32.8,65.2},{33.6,66.4},{36.4,60.2},{36.4,71.4},{36.4,71.8},{36.4,72.6},{37,71.4},{37,71.8},{37.4,60.8},{37.8,60.8},{38,60.2},{41,66.4},{41.4,66.6},{41.6,66.4},{41.6,67.2},{41.6,68}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227511] = {
            [npcKeys.name] = "Pedestal",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 2017,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227519] = {
            [npcKeys.name] = "Fallen Knight",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 28,
            [npcKeys.spawns] = {
                [28] = {{44.4,46.4},{44.4,46.6},{44.6,46.4},{44.6,46.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227533] = {
            [npcKeys.name] = "Astral Wraith",
            [npcKeys.minLevel] = 56,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 1377,
            [npcKeys.spawns] = {
                [1377] = {{11.8,94.4},{11.8,95}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227672] = {
            [npcKeys.name] = "Squire Cuthbert",
            [npcKeys.minLevel] = 52,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 28,
            [npcKeys.spawns] = {
                [28] = {{44.4,46.6},{44.6,46.6},{47.8,50.4},{47.8,50.6}},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = {83808,83822,83935,83936},
            [npcKeys.questEnds] = {83808,83822,83935,83936},
        },
        [227673] = {
            [npcKeys.name] = "Squire Cuthbert",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {83823},
        },
        [227674] = {
            [npcKeys.name] = "Squire Cuthbert",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {84017,84125,84126},
            [npcKeys.questEnds] = {84017,84125,84126},
        },
        [227681] = {
            [npcKeys.name] = "Dirt Mound",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227705] = {
            [npcKeys.name] = "Kill Credit Creature",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227746] = {
            [npcKeys.name] = "Escaped Core Hound",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{24.2,57.8},{24.4,50.2},{24.8,55.6},{24.8,60},{25,49.8},{25,58.6},{25.2,49},{25.4,54},{25.6,54},{26,54.6},{26,56.2},{26.8,53.2},{27.6,52},{31.8,53},{33.4,51.8},{36.8,50.6},{38.4,62.6},{38.4,63.6},{39,60.2},{39.2,63.2},{39.4,61},{39.4,62.4},{39.6,61},{39.8,59.4},{40,59.6},{40,62.2},{40.2,63},{40.6,61.6},{40.8,54},{40.8,59.6},{40.8,61.4},{41,59.2},{41.8,61},{43.4,62},{46.4,60.6},{47.4,61.4},{49.6,61.4},{59.2,53.4},{59.8,53.4},{60.2,51.6},{60.2,54.8},{60.4,54.2},{60.8,53.4},{60.8,54},{61.4,51},{61.4,54.8},{61.6,54.4},{62,50.4},{63.4,51.4},{63.6,46},{63.8,49.8},{64.2,49},{65.4,49.6},{72,31.2},{72.2,34.6},{72.4,32},{72.4,32.6},{72.4,34},{72.4,37},{72.6,32.6},{72.8,31.4},{73.2,32.2},{74,30.8},{74.2,29.8},{74.6,32.8},{74.8,58.6},{83.6,54.4},{83.8,60},{84.8,68},{86.6,53.2},{87,58.2},{87.4,50.8},{87.6,51.8},{88.2,55},{88.4,53.6},{88.6,54.8},{88.8,51},{88.8,54},{89,53},{89.2,57},{91,52.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227755] = {
            [npcKeys.name] = "Estelenn",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{17,46.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {84136,85061},
            [npcKeys.questEnds] = {85521},
        },
        [227819] = {
            [npcKeys.name] = "Duke Hydraxis",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227853] = {
            [npcKeys.name] = "Pix Xizzix",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{28.4,75.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {83934},
            [npcKeys.questEnds] = {83934},
        },
        [227856] = {
            [npcKeys.name] = "Kill Credit Creature",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227857] = {
            [npcKeys.name] = "Kill Credit Creature",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227858] = {
            [npcKeys.name] = "Squire Cuthbert",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227866] = {
            [npcKeys.name] = "Testwerk",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227938] = {
            [npcKeys.name] = "Zotl",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 2,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227939] = {
            [npcKeys.name] = "The Molten Core",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227951] = {
            [npcKeys.name] = "Edwi Copperbolt",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1377,
            [npcKeys.spawns] = {
                [1377] = {{41.2,88.4},{41.2,88.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227985] = {
            [npcKeys.name] = "Arkonos the Cursed",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{82.4,42.6},{84.8,42.4},{85.4,39.8},{86.4,40},{86.6,39.8},{86.8,39.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227995] = {
            [npcKeys.name] = "Enterprising Imp",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [227996] = {
            [npcKeys.name] = "Sebastian Jurgens",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{53.4,57.2},{53.6,57.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228022] = {
            [npcKeys.name] = "The Destructor's Wraith",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228062] = {
            [npcKeys.name] = "Rumbling Sand",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228079] = {
            [npcKeys.name] = "Disembodied Voice of Kel'Thuzad",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228142] = {
            [npcKeys.name] = "D.E.L.T.A Techbot",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{51.2,27},{51.4,28},{51.4,29},{52,29.4},{52.2,27.4},{52.2,27.6},{52.4,29.6},{52.6,29.4},{53,29.6},{53.4,30.6},{53.6,30.6},{54,31.6},{54.4,34},{54.6,34.6},{54.6,35.8},{54.8,38.2},{54.8,39},{54.8,40.4},{54.8,42.8},{55,40.8},{55,41.6},{55.2,43.6},{55.2,44.8},{55.4,46},{55.4,47.2},{55.4,48.8},{55.6,49.4},{56.2,50},{57.8,52.4},{58.2,53},{58.4,54},{58.6,54.2},{58.6,89.8},{58.8,85.4},{58.8,88.4},{59.2,55.2},{59.2,91.4},{60,79.2},{60,80.2},{60,82.8},{61,77.2},{61,77.6},{61.4,76.4},{61.6,75.8},{62.2,75.2},{62.6,73.4},{62.6,75},{62.8,72.2},{62.8,74},{63,68},{63,69},{63,71},{63.2,61.4},{63.2,66.6},{63.4,62},{63.4,66.4},{63.8,62.4},{63.8,62.8},{63.8,64}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228143] = {
            [npcKeys.name] = "[DNT] Challenge",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228145] = {
            [npcKeys.name] = "Furniture",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228173] = {
            [npcKeys.name] = "Spike Lakeman",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228176] = {
            [npcKeys.name] = "Banteazo",
            [npcKeys.minLevel] = 12,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 493,
            [npcKeys.spawns] = {
                [493] = {{56.2,31.4},{56.2,32.4},{56.2,32.6},{56.8,32}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {84235,84636,84853},
            [npcKeys.questEnds] = {84136,84235,84636},
        },
        [228203] = {
            [npcKeys.name] = "T0",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228204] = {
            [npcKeys.name] = "T0.5",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228206] = {
            [npcKeys.name] = "T1",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228209] = {
            [npcKeys.name] = "PvP T1",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228216] = {
            [npcKeys.name] = "Numi",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{61.2,37}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {84146,84212},
            [npcKeys.questEnds] = {84138,84211},
        },
        [228230] = {
            [npcKeys.name] = "Harrigen",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{46.4,35.4},{46.6,35},{46.8,34},{47.4,35.6},{48.2,36.6},{48.4,34.8},{49.4,38.2},{49.8,33.4},{49.8,39},{50,35.2},{50.4,27.4},{50.6,28.2},{50.8,27.4},{50.8,30.2},{50.8,39.4},{51,26.4},{51,36.2},{51.2,25.2},{51.8,25.8},{52,26.6},{52.6,26.8},{52.8,25.2},{52.8,25.6},{53.4,24},{54,23.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228231] = {
            [npcKeys.name] = "Montrose",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{45,34.8},{46.2,38.6},{46.6,35.2},{46.6,37.4},{46.8,34.4},{47.4,36},{47.6,36},{48.2,36.6},{48.8,35.2},{49.4,38},{49.8,33.4},{49.8,36.6},{49.8,39.2},{50,35.2},{50.2,27.8},{50.4,27.4},{50.4,38.2},{50.4,41.6},{50.6,25},{50.6,28.2},{50.8,26.6},{50.8,30.2},{50.8,39.6},{51.2,26},{51.4,39.2},{51.8,25.8},{52,26.8},{52.8,25.6},{53,24.8},{53.2,24.2},{53.8,23.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228232] = {
            [npcKeys.name] = "Plio",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{45.2,35},{45.8,36.4},{46,38.2},{46.2,38.8},{46.6,36.8},{47.4,35.4},{47.4,36.2},{47.6,35.4},{48.2,34.4},{48.2,36.8},{48.4,36},{49,37},{49.2,35},{49.4,38.2},{49.8,33.4},{49.8,39},{50,27},{50,27.8},{50,35.2},{50.2,26.4},{50.4,38.2},{50.4,41.4},{50.6,25},{50.6,27.6},{50.8,27.4},{50.8,28.8},{50.8,30.2},{50.8,39.4},{51.2,26.2},{51.6,29.4},{52.2,26.6},{52.4,25.4},{52.4,25.8},{52.6,26.2},{52.6,26.6},{53,24.8},{53.2,23.4},{53.2,24.4},{54,23.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228233] = {
            [npcKeys.name] = "Abel",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{45,38},{45.4,35.2},{45.8,38.4},{46,37.4},{46.2,36.2},{46.2,38.8},{46.4,35},{46.8,34},{46.8,34.8},{47.4,36.2},{48.4,34.8},{48.4,36.4},{48.4,36.6},{48.8,35.6},{49,37},{49.2,34.6},{49.2,37.8},{49.8,33.4},{49.8,33.6},{49.8,39.2},{50,27},{50,35.2},{50.4,27.8},{50.4,38.2},{50.6,25},{50.6,27.2},{50.6,28.2},{50.6,35.8},{50.8,28.8},{50.8,30.2},{50.8,39.4},{50.8,41},{51.2,26},{51.8,25.4},{51.8,25.8},{52,26.6},{52,38},{52.6,25.6},{52.6,26.8},{53,24.8},{53.2,23.4},{53.2,24.4},{53.6,23.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228287] = {
            [npcKeys.name] = "Sebastian Jurgens",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{53.4,40},{53.6,40.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228353] = {
            [npcKeys.name] = "Lucifriend",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228414] = {
            [npcKeys.name] = "Heliath",
            [npcKeys.minLevel] = 56,
            [npcKeys.maxLevel] = 56,
            [npcKeys.zoneID] = 4,
            [npcKeys.spawns] = {
                [4] = {{67.4,29.6},{68,28.8},{68,30.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228429] = {
            [npcKeys.name] = "Lucifron",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228430] = {
            [npcKeys.name] = "Magmadar",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228431] = {
            [npcKeys.name] = "Gehennas",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228432] = {
            [npcKeys.name] = "Garr",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228433] = {
            [npcKeys.name] = "Baron Geddon",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228434] = {
            [npcKeys.name] = "Shazzrah",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228435] = {
            [npcKeys.name] = "Golemagg the Incinerator",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228436] = {
            [npcKeys.name] = "Sulfuron Harbinger",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228437] = {
            [npcKeys.name] = "Majordomo Executus",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228438] = {
            [npcKeys.name] = "Ragnaros",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228441] = {
            [npcKeys.name] = "Flamewaker Protector",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228442] = {
            [npcKeys.name] = "Core Hound",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228443] = {
            [npcKeys.name] = "[DNT] Challenge",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228461] = {
            [npcKeys.name] = "Oil Rig",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228532] = {
            [npcKeys.name] = "Shadowsworn Sacrifice",
            [npcKeys.minLevel] = 55,
            [npcKeys.maxLevel] = 56,
            [npcKeys.zoneID] = 4,
            [npcKeys.spawns] = {
                [4] = {{68,28.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228533] = {
            [npcKeys.name] = "Voidwalker Minion",
            [npcKeys.minLevel] = 56,
            [npcKeys.maxLevel] = 56,
            [npcKeys.zoneID] = 4,
            [npcKeys.spawns] = {
                [4] = {{68,28.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228535] = {
            [npcKeys.name] = "[DNT] Creature",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228551] = {
            [npcKeys.name] = "Spiritstorm",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228595] = {
            [npcKeys.name] = "Vengeful Wisp",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 361,
            [npcKeys.spawns] = {
                [361] = {{45.4,18.4},{45.4,18.6},{45.6,18.4},{45.6,18.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228596] = {
            [npcKeys.name] = "Vengeful Wisp",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228609] = {
            [npcKeys.name] = "Sulfuron Smuggler",
            [npcKeys.minLevel] = 56,
            [npcKeys.maxLevel] = 59,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{42.2,26.2},{42.8,25.6},{43.2,25.4},{43.8,22.4},{43.8,25.4},{44,23},{44.2,30.4},{44.4,25.8},{44.4,29.2},{44.6,30.2},{44.8,25.2},{45,26.4},{45,28.6},{45,31.8},{45.2,22.2},{45.2,28.4},{45.2,31.2},{45.2,35.2},{45.4,21.4},{45.4,22.6},{45.4,27.2},{45.6,22.6},{45.6,35.2},{45.8,37.2},{46,27.2},{46,36.2},{46.2,38.2},{46.2,38.6},{46.4,21.4},{46.4,21.6},{46.4,24.6},{46.4,27.6},{46.6,21.4},{46.6,27.4},{46.8,22},{46.8,24.4},{46.8,28.4},{47,22.6},{47,34.8},{47.2,25.2},{47.2,28.8},{47.2,35.8},{47.4,26.4},{47.6,25},{47.8,29.2},{47.8,36.2},{48,26.8},{48.2,26.4},{48.2,36.6},{48.4,28},{48.4,29.8},{48.4,35.4},{48.6,27.8},{48.6,29.4},{48.6,29.6},{48.6,37.2},{48.8,26.4},{49.2,27.2},{49.2,35},{49.4,38},{49.4,39},{49.8,26.4},{49.8,33.2},{49.8,39},{49.8,39.6},{50,27},{50,33.8},{50,35.2},{50.2,28.6},{50.2,35.8},{50.4,24.4},{50.4,25.4},{50.4,27.8},{50.4,30.8},{50.4,31.8},{50.4,38.2},{50.6,27.4},{50.6,27.6},{50.6,30.4},{50.8,28.8},{50.8,31.2},{50.8,39.8},{50.8,40.8},{51,33.8},{51.2,25.2},{51.2,25.8},{51.2,33},{51.4,32.4},{51.8,32.8},{51.8,36.8},{52,26.6},{52,33.8},{52.2,25.6},{52.4,25},{52.6,35},{52.8,26.6},{53,24.8},{53,26.2},{53,32.6},{53.2,24.2},{53.2,32.4},{53.4,23.4},{53.6,23.8},{53.6,33.6},{53.8,26},{54,23.4},{54,27.8},{54.2,32},{54.2,32.6},{54.8,23.4},{54.8,23.6},{54.8,31.4},{55.2,32},{55.4,32.8},{55.4,34.4},{55.4,34.6},{55.6,24.4},{55.6,29.8},{55.6,33.6},{56,33.2},{56.2,24.8},{56.4,32.4},{56.8,24},{56.8,25.4},{57.2,25.6},{57.2,27.4},{57.4,31.4},{57.6,24.4},{57.8,26},{58,25.2},{58,26.6},{58.4,27.6},{58.8,28.2},{59.2,29},{59.4,30.2},{59.6,29.8},{60.2,29.2},{60.8,29.8},{61.4,29},{61.6,28.8},{62,27.8},{62.6,27.2},{62.6,27.8},{62.8,29.6}},
                [51] = {{65,77.4},{65.2,76.4},{65.4,77.8},{65.4,79},{65.4,79.8},{65.6,77.4},{65.6,78.4},{65.6,78.8},{65.6,80},{66,81.2},{66.2,81.8},{67.2,79.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228610] = {
            [npcKeys.name] = "Blackrock Bootlegger",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 59,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{41.4,26.4},{42.4,26.2},{42.6,25.8},{43,25},{43.8,22.4},{44,25.6},{44.4,25.4},{44.4,29.4},{44.4,29.6},{44.4,31.2},{44.6,30.2},{44.8,25},{44.8,26},{44.8,29},{45,26.6},{45,28.2},{45.2,30.8},{45.2,32},{45.2,38.4},{45.4,22},{45.4,23.4},{45.4,35.2},{45.6,32.2},{45.8,37.4},{46,38.2},{46.2,21.6},{46.2,27.4},{46.2,27.6},{46.2,38.8},{46.4,21.4},{46.4,23.2},{46.4,35.8},{46.6,21.4},{46.6,36.6},{46.8,22.2},{46.8,27.6},{47,24},{47,35},{47.2,23},{47.2,25},{47.2,25.6},{47.2,28.8},{47.2,35.8},{47.4,26.6},{47.6,26.6},{47.6,31.2},{47.8,26.4},{47.8,29.2},{47.8,36},{48.2,30},{48.2,35.4},{48.4,27.6},{48.4,36.6},{48.6,27.4},{48.6,28.2},{48.6,29.2},{49,26.4},{49,36.6},{49.2,39},{49.4,35.4},{49.4,37.8},{49.8,25.4},{49.8,26.4},{50,26.6},{50.2,32.6},{50.2,34.8},{50.2,35.8},{50.2,38.2},{50.4,27.8},{50.4,28.6},{50.4,30.8},{50.4,34.2},{50.6,27.8},{50.6,31.4},{50.8,26.6},{50.8,29.4},{50.8,30.4},{50.8,41.2},{51.2,26},{51.2,33},{51.4,25.4},{51.4,33.8},{51.4,35.2},{51.6,29.8},{51.6,35.6},{52,26.6},{52.2,25.8},{52.2,35.4},{52.4,24.2},{52.4,25.2},{52.4,33.2},{52.4,34},{52.6,32.6},{52.8,26},{53,24.6},{53,26.6},{53,34},{53.2,24.2},{53.4,23.4},{53.6,33.4},{53.6,33.8},{53.8,23.6},{53.8,26},{54.2,23.4},{54.2,32.4},{54.8,23.4},{54.8,23.6},{54.8,31.8},{55.2,31},{55.2,33.4},{55.4,34.8},{55.6,24.2},{56,34},{56.2,24.8},{56.2,33.2},{56.2,34.6},{56.8,26.6},{56.8,32.8},{57,24.4},{57,26},{57.4,24.8},{57.6,25.4},{57.6,26},{57.8,23},{58,29.8},{58.2,23.8},{58.2,27.2},{58.4,27.6},{58.6,28},{58.8,28.6},{58.8,31.6},{59.4,29.8},{59.6,29.4},{60.4,29.8},{60.4,30.6},{61,29.8},{61.2,29.2},{61.6,30},{61.8,28.8},{62.2,28.2}},
                [51] = {{61,71.4},{62.8,74.4},{63.6,74.4},{64.2,82},{64.8,75.2},{65,82.2},{65.4,76.8},{65.4,77.8},{65.4,79},{65.4,80.4},{65.4,80.6},{65.6,79.2},{65.8,77.6},{65.8,80},{66.2,81.4},{66.2,81.8},{67.2,79.6},{67.6,79.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228611] = {
            [npcKeys.name] = "Wandering Swordsman",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1377,
            [npcKeys.spawns] = {
                [1377] = {{18.6,25},{18.8,23.2},{18.8,25.8},{19.2,19.4},{19.2,19.6},{19.2,27},{19.6,18.8},{19.6,19.6},{19.6,27.8},{20,28.8},{20,81.4},{20.2,18.2},{20.4,22.8},{20.6,23.6},{20.6,29.4},{20.6,31.6},{20.6,78},{20.8,30.2},{20.8,82.8},{20.8,89.6},{21,17.8},{21.2,17},{21.4,82},{21.6,16.6},{21.6,33.6},{21.6,36.8},{21.6,86.8},{21.8,16.2},{21.8,37.6},{22,39},{22,80.4},{22.4,13.8},{22.6,14.2},{22.6,85},{22.8,80.2},{23,86.8},{23.2,12.8},{23.8,12.8},{23.8,86.8},{24.2,41},{24.2,82.2},{24.4,11.8},{24.8,11.6},{25,42.2},{25.4,11.4},{25.6,11.2},{25.8,11.6},{26.2,86.8},{26.4,77.2},{26.6,11.4},{26.6,84.4},{27,44.2},{27,79.6},{27.4,11.6},{27.4,77.6},{27.6,76},{27.8,12},{28,45.4},{28.2,46},{28.2,72.6},{28.4,12.8},{28.4,84.4},{28.8,14.4},{28.8,47.2},{29,91.8},{29.2,47.8},{29.2,91.4},{29.4,15},{29.4,85},{29.6,14.6},{29.6,85.2},{29.8,47.8},{29.8,75.4},{30,49.2},{30.2,15.8},{30.2,90.2},{30.4,16.6},{30.4,88.8},{30.6,85},{30.8,47.8},{30.8,50.2},{31,17.4},{31,73.4},{31,87.8},{31.2,18.2},{31.2,18.6},{31.4,19.8},{31.6,19.4},{31.6,19.6},{31.8,72.2},{32,20.6},{32.2,52.8},{32.2,86.6},{32.4,17.8},{32.4,49},{32.8,48.6},{32.8,63.4},{32.8,64.2},{33,18},{33,68.8},{33.2,22.2},{33.2,23.6},{33.4,23.2},{33.6,56.8},{33.6,57.8},{33.6,84.8},{33.8,24.2},{33.8,61},{34,55},{34,69.8},{34.2,69},{34.4,25.2},{34.4,25.6},{34.4,30.8},{34.4,50.4},{34.4,62.6},{34.6,25.2},{34.6,25.8},{34.6,27},{34.6,65.2},{34.8,29},{34.8,30.2},{34.8,31},{34.8,32.6},{34.8,33.6},{34.8,34.6},{34.8,68.4},{35,28.2},{35,31.6},{35,37},{35,83.8},{35.4,68.8},{36,20.4},{36,68.4},{36,68.6},{36.2,41},{36.4,42.8},{36.4,85.4},{36.8,67.8},{37,67},{37,75.6},{37.2,60.8},{37.2,79},{37.4,66.4},{37.6,66.6},{37.6,72.4},{37.6,78.4},{37.6,79.2},{37.8,48.2},{37.8,66.4},{38,22.4},{38,59.6},{38,86.8},{38.2,59.2},{38.2,74.8},{38.4,23.8},{38.4,80.4},{38.4,81.6},{38.6,57.8},{38.6,81.4},{38.8,65.4},{38.8,65.8},{39,24.8},{39,57.4},{39,78.2},{39,83.4},{39.2,77.4},{39.4,72.2},{39.6,65.2},{39.6,81.8},{39.8,65.6},{39.8,76.8},{39.8,79.2},{40,81.2},{40.4,53.6},{40.4,75.2},{40.4,75.8},{40.6,65.2},{40.6,75.6},{40.6,76.6},{40.8,75.2},{41,28.6},{41.2,69.2},{41.4,29.6},{41.4,66},{41.4,74},{41.4,77.8},{41.4,79.6},{41.4,81},{41.6,30.4},{41.6,80.4},{41.6,81.4},{41.8,78.8},{41.8,81.6},{42,74.8},{42.2,68.2},{42.2,73.8},{42.2,77.6},{42.2,82.6},{42.4,66.4},{42.4,77.2},{42.4,87},{42.6,66.4},{42.6,77},{42.6,77.8},{42.6,79.6},{42.6,82.8},{42.6,87},{42.8,56},{43,32.2},{43,69},{43,83.6},{43.2,48.8},{43.2,73.4},{43.4,66.6},{43.6,66},{43.6,66.8},{43.6,68.6},{43.6,71.8},{43.6,77},{43.8,83.8},{44,65.2},{44,73.4},{44.2,73.8},{44.2,78.6},{44.2,83.4},{44.4,56.4},{44.4,64.2},{44.4,78},{44.6,57.2},{44.6,63.6},{44.6,70.8},{44.6,78.4},{44.6,87.6},{44.8,48},{44.8,87.2},{45,46.4},{45,74},{45.2,68.6},{45.2,70},{45.2,75.4},{45.2,83.8},{45.4,43.4},{45.4,83},{45.8,58},{45.8,83.8},{46,82.6},{46.2,31.6},{46.2,42},{46.2,82.4},{46.4,59.4},{46.4,62.4},{46.4,75.2},{46.6,41.2},{46.6,86.4},{46.8,76},{47,53},{47,53.6},{47,58.2},{47,81.2},{47.2,40.4},{47.2,52.4},{47.2,77.6},{47.2,81.8},{47.4,76.6},{47.4,79.6},{47.6,31.4},{47.6,77.2},{47.6,79.8},{47.6,80.8},{47.6,85},{47.8,36.6},{47.8,78},{47.8,78.8},{48,52.2},{48.2,52.6},{48.2,74},{48.4,33.6},{48.4,60.8},{48.4,61.8},{48.4,74.6},{48.6,52.6},{48.6,75},{48.6,82.6},{49,30.6},{49,60.8},{49,77.4},{49,78.2},{49,82.4},{49.4,80.2},{50.4,52.8},{50.6,59.4},{50.8,53.4},{51,53.6},{51.2,59.6},{51.6,54.2},{52,54.6},{52.2,58.8},{52.8,55},{53,58.4},{53.2,55.6},{53.4,29.2},{53.6,57},{53.8,24.4},{54,55.2},{54,55.6},{54.8,29.4},{54.8,54.6},{55,29.6},{55.2,53.6},{55.4,52.2},{55.4,53.2},{55.6,49.8},{55.6,52},{55.8,48.8},{56.2,52.6},{56.6,37},{56.8,30.8},{57,32.4},{57,37.8},{57,47.4},{57.2,22.6},{57.2,51.4},{57.6,22},{57.6,47.4},{57.8,50.8},{58,46.2},{58.2,21.4},{58.4,45.2},{58.4,49.6},{59,49},{59.2,39},{59.2,43.8},{59.2,44.6},{60,38},{60,46.6},{60.2,43.2},{60.6,43.2},{60.8,38},{61,41.6},{61.2,39.6},{61.2,41.2},{61.4,46.4},{62.6,45.2},{65,45.4},{65.4,28},{65.6,29.2},{65.8,30.6},{66.4,45.4},{67.6,42.6},{68.4,33.6},{68.6,40.6},{68.8,40.2},{69.6,38.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228612] = {
            [npcKeys.name] = "Festering Ghoul",
            [npcKeys.minLevel] = 54,
            [npcKeys.maxLevel] = 55,
            [npcKeys.zoneID] = 28,
            [npcKeys.spawns] = {
                [28] = {{42.2,53.4},{43.4,53.4},{45.2,54},{45.4,52.4},{45.4,53.4},{45.4,54.6},{45.6,51.8},{45.6,53.8},{45.8,48.6},{45.8,53.4},{45.8,54.6},{46.6,54},{47,57.2},{47.2,51.4},{47.2,52.8},{47.4,51.8},{47.8,51}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228614] = {
            [npcKeys.name] = "Archmage Bones",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228615] = {
            [npcKeys.name] = "Harrison Bones",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228616] = {
            [npcKeys.name] = "Doctor Bones",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228618] = {
            [npcKeys.name] = "Kill Credit Creature",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228619] = {
            [npcKeys.name] = "Orthas",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{7.4,43.6},{14.4,33.6},{22.8,27.8},{26,34.4},{27.2,87},{27.4,80.2},{27.4,85.4},{27.4,85.6},{28,80.2},{28,80.6},{28.2,75.2},{28.2,85.6},{28.4,31.4},{28.4,84.8},{28.8,79.8},{28.8,83.8},{28.8,85.2},{29,79.4},{29.2,77.6},{29.2,80.8},{29.4,81.8},{29.4,83},{29.6,78.6},{29.6,81.6},{29.6,82.8},{29.8,77},{29.8,78},{29.8,84.4},{30,80.6},{30.4,84.6},{30.6,80.6},{30.8,85.4},{31,76.6},{31.2,78.4},{31.4,79},{31.4,84.4},{31.8,83.2},{32.2,77.2},{32.4,84.2},{32.6,76.8},{32.6,77.6},{33,83.8},{33.2,75.8},{33.4,80.2},{33.6,76.2},{33.6,78},{34.2,23.2},{34.4,65.6},{34.4,84.2},{34.4,84.6},{34.8,59.8},{34.8,79.4},{34.8,80},{35,35.4},{35,36},{35,83.2},{35,84.2},{35.4,80.6},{35.6,85},{35.8,58.6},{35.8,79.2},{35.8,80.8},{36,33.8},{36,79.6},{36.2,64},{36.2,82},{36.6,79.4},{37,32.6},{37.2,84.6},{37.4,24.6},{37.4,77.6},{37.4,81.4},{37.6,78.2},{37.6,79.6},{37.6,81.4},{37.6,84.6},{38,36.8},{38,79.2},{38.2,84},{38.4,82.8},{38.6,36},{39,79.4},{39.2,81},{39.6,36.6},{40,78.8},{40.8,29.4},{40.8,83},{41,33.4},{41.2,78.4},{41.2,81.6},{42,25},{42,32.4},{42,79.4},{42.4,82.2},{42.6,76.2},{42.6,76.6},{43,27},{43,82},{43.2,83.2},{43.4,80.6},{43.6,74.6},{43.6,77.8},{43.6,79.2},{44,32.4},{44,36.2},{44,76.4},{44.2,81},{44.4,80.4},{44.6,76.6},{44.6,80.6},{44.8,76},{45.4,32.8},{45.4,80.2},{45.6,77.6},{45.6,81.2},{45.8,78.6},{45.8,79.6},{46,77.2},{47,77.2},{47.2,44.4},{47.8,22.6},{48,24.2},{49,75.8},{50.4,75.2},{53.4,73.6},{54.4,55.2},{54.4,72.6},{55.4,72.4},{57,67.8},{57.2,36.2},{57.2,70.2},{57.4,71.2},{57.8,72},{58,67.8},{58,70.6},{58,73.2},{58,79.4},{58.2,69.2},{58.4,51},{58.4,65.6},{58.4,74.2},{58.6,69.6},{59,72.2},{59.2,74.2},{59.6,65},{59.6,70.2},{60.4,69.4},{60.4,70.8},{60.4,73.2},{60.4,73.8},{61,64.8},{61,67},{61.2,69.2},{61.2,70.2},{61.2,71.8},{61.6,73.2},{62,65.6},{62,67.8},{62,71.4},{62,77.2},{62.2,65.2},{62.2,69.8},{62.4,64.4},{62.4,68.8},{62.4,72.2},{62.6,75.6},{62.8,66.4},{62.8,69.2},{63,71},{63,71.6},{63.2,73.2},{63.4,69.8},{65.8,66.2},{74,57},{78.2,57},{81,58.8},{81.2,59.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {84318,84319,84330},
            [npcKeys.questEnds] = {84318,84319},
        },
        [228620] = {
            [npcKeys.name] = "Slack-Jawed Ghoul",
            [npcKeys.minLevel] = 56,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{24.4,81.2},{26.2,79.6},{27,80.4},{27.4,84.8},{27.4,86.2},{28,75.6},{28,80.4},{28.4,80.8},{28.4,84.4},{28.4,85},{28.4,85.8},{28.4,86.8},{28.6,86.4},{28.8,84},{28.8,85.2},{29,79.2},{29,79.6},{29.2,77.6},{29.4,80.6},{29.4,83},{29.6,77.6},{29.6,80.2},{29.6,80.6},{29.6,81.8},{29.6,83},{30,78.6},{30.2,77.2},{30.4,84.4},{30.8,84.6},{31.2,76.8},{31.2,80.6},{31.4,78.4},{31.4,80.2},{31.4,84.4},{31.6,78.4},{31.6,81.6},{31.8,80.6},{31.8,83.4},{32,84.6},{32.2,77},{32.2,80.4},{32.2,83.6},{32.8,80.6},{32.8,83.8},{33.2,75.8},{33.2,76.6},{33.2,80.2},{33.6,78.2},{34.2,78.6},{34.2,80.4},{34.4,83.4},{34.4,84.2},{35,79.4},{35,83.6},{35,84.6},{35.2,80},{35.4,80.8},{35.6,84.8},{35.8,79.8},{35.8,81},{36.4,79.4},{36.4,82.4},{36.6,79.4},{36.6,79.8},{37.2,77.8},{37.2,84.6},{37.4,81.6},{37.8,78},{38,79.2},{38,83.6},{38.2,79.6},{38.6,78.2},{39.2,79.4},{39.2,79.6},{39.4,81.6},{39.8,78.8},{40,82},{40.8,78.4},{40.8,79.6},{40.8,83},{41,81.8},{41.6,78},{42,79.6},{42.2,77.2},{42.4,81.8},{42.4,82.6},{42.6,76.4},{42.8,79},{43,82},{43.2,76.6},{43.2,81},{43.6,77.4},{43.8,76.4},{43.8,79},{44,80.8},{44.4,78.4},{44.6,76},{45,77.4},{45.2,77.8},{45.4,81.4},{45.6,81.4},{45.8,77.6},{46,79.2},{46,79.6},{46.4,77.4},{47.2,77},{47.6,76.6},{48,76.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228621] = {
            [npcKeys.name] = "[DNT] Challenge",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228622] = {
            [npcKeys.name] = "Orthas",
            [npcKeys.minLevel] = 56,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{27.4,85.4},{27.4,85.8},{27.6,85.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228673] = {
            [npcKeys.name] = "Wandering Swordsman",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228676] = {
            [npcKeys.name] = "Kill Credit Creature",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228677] = {
            [npcKeys.name] = "Rift",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228703] = {
            [npcKeys.name] = "Dread Fungus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228714] = {
            [npcKeys.name] = "Chaos Chopper",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228718] = {
            [npcKeys.name] = "Firelands Invader",
            [npcKeys.minLevel] = 54,
            [npcKeys.maxLevel] = 55,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{26.4,50},{26.4,53.8},{26.6,50},{26.8,49.2},{27,53.4},{27,53.8},{27,54.8},{28.2,48.4},{28.2,49.2},{28.4,42.8},{28.6,42.8},{28.6,47.2},{28.6,48.4},{28.6,48.6},{29.2,41.8},{29.4,45.6},{30,41.8},{30.2,41.4},{30.4,33.4},{30.4,33.6},{30.4,51.4},{30.4,52.2},{30.6,51.4},{30.8,33.4},{30.8,33.6},{31,52.2},{31.4,52.8},{32,47.2},{32,47.6},{32.4,32.4},{32.4,33.2},{32.4,33.6},{32.6,33.2},{32.6,33.6},{32.8,31.8},{32.8,40.4},{33,31},{33.2,30.2},{33.4,28.4},{33.4,29},{33.4,44.2},{33.6,29.2},{33.6,29.8},{33.6,32.2},{33.8,27.4},{33.8,27.6},{33.8,44.2},{34,31.4},{34.2,26.4},{34.4,32.6},{34.4,47.2},{34.6,26.4},{34.6,26.6},{34.6,32.4},{34.6,32.6},{34.8,28.4},{34.8,29.2},{34.8,29.6},{34.8,30.6},{35,47.2},{35.2,58.6},{35.4,47.6},{35.4,58},{36.2,58},{36.6,58.2},{37.4,58.6},{37.8,37.6},{37.8,59},{38,37.4},{38,39.4},{38.2,59.6},{38.4,45.4},{38.4,45.6},{38.6,60.2},{39,38.8},{39,60.6},{39.2,44.8},{39.4,44.4},{39.6,44.6},{39.8,43},{39.8,44.4},{40,42.2},{40.2,39.8},{40.4,50.6},{40.6,39},{40.6,39.6},{40.6,43.8},{41,60},{41.4,59.4},{41.8,58.8},{42,55},{42,56},{42,58.4},{42.2,57.2},{42.4,41.4},{42.6,41.2},{42.6,46},{42.6,57.4},{42.6,57.6},{42.8,41.8},{44,42},{44,42.8},{44.8,40.6},{44.8,43.4},{45,40.2},{45.2,44.6},{45.4,43.8},{45.6,39.4},{46,44.6},{46.4,44.2},{46.6,44.2},{47.2,35.6},{47.4,35.4},{47.4,40},{47.4,48.8},{47.4,49.6},{47.6,48.8},{47.6,49.6},{47.8,35.2},{48,39.6},{48.4,38.8},{48.6,38.6},{48.8,38.2},{49,35.4},{49,39.8},{49.2,36.4},{49.2,37.4},{49.8,38.6},{49.8,48.6},{50.2,47.8},{50.4,37.4},{50.4,37.6},{50.4,47.2},{50.6,37.2},{50.6,37.8},{50.6,47.4},{50.6,47.6},{50.8,36.4},{52,44.6},{52.2,44.4},{52.6,44.4},{52.6,44.6},{54.4,44.8},{54.8,45},{56,45.2},{56,45.6},{56.2,47.2},{57.2,36},{57.6,35.8},{57.6,36.6},{58.2,42.4},{58.8,45.4},{59.2,41.4},{59.2,41.6},{62.4,35.4},{62.4,35.6},{62.6,35.6},{63.2,35.4},{64.4,37.8},{65,38}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228719] = {
            [npcKeys.name] = "Firelands Drudge",
            [npcKeys.minLevel] = 56,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{42,27.2},{42,30.8},{42.4,29},{42.6,30.6},{43,29.6},{43.2,26},{43.4,25.4},{43.4,27.2},{43.4,28.4},{43.4,29},{43.6,28.6},{43.8,27.4},{43.8,27.6},{44,23.4},{44.2,22.2},{44.2,24.2},{44.4,21},{44.4,25.4},{44.4,26.4},{44.6,20.4},{44.6,25},{44.8,24.4},{45,22.6},{45.2,21.4},{45.2,22.2},{45.2,26.4},{45.4,26.6},{45.6,22.6},{45.6,24},{45.6,26.8},{45.8,25.4},{45.8,26.4},{46,21.4},{46,22.4},{46.2,20},{46.4,19.4},{46.4,28},{46.6,25.4},{46.6,26.2},{46.6,27.2},{46.8,27.8},{47,20.6},{47.2,19.6},{47.4,21.8},{47.4,22.8},{47.4,45.4},{47.8,21.4},{47.8,22.2},{47.8,41.6},{48,20},{48,22.8},{48.2,24},{48.2,47.2},{48.4,24.6},{48.4,26.4},{48.4,26.6},{48.4,28.2},{48.4,28.8},{48.4,29.8},{48.4,41},{48.6,26},{48.6,26.6},{48.6,29.8},{48.6,38.4},{48.8,28.4},{48.8,28.8},{49,21.8},{49,24.8},{49.2,21.4},{49.2,24.2},{49.2,31},{49.2,31.6},{49.2,40.2},{49.4,23.4},{49.6,23.4},{49.6,23.6},{49.6,45.8},{49.8,31.8},{49.8,36.4},{49.8,37.4},{50,38.2},{50.2,27.6},{50.2,38.6},{50.4,25},{50.4,26},{50.4,26.8},{50.4,28.6},{50.6,26.4},{50.6,26.6},{50.8,23.4},{50.8,24.2},{50.8,34.2},{50.8,35.4},{50.8,38},{51,28.4},{51,35.8},{51.2,24.6},{51.2,29.2},{51.2,29.8},{51.2,33},{51.6,26.8},{51.6,27.6},{51.6,30.8},{51.8,34.2},{52,29.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228720] = {
            [npcKeys.name] = "Duke Searbrand",
            [npcKeys.minLevel] = 59,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{43,29.4},{43,29.6},{43.4,28.4},{43.6,28.2},{43.6,28.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228721] = {
            [npcKeys.name] = "Lieutenant Skarresh",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{39,32.6},{39.4,34.6},{39.6,31.2},{40,32.6},{40.8,29.8},{41,35.4},{41.2,35.6},{41.4,28.2},{41.6,35.4},{42,26.8},{42.2,26.4},{42.2,29.4},{42.2,35.6},{42.4,28.2},{42.4,30},{42.4,30.6},{42.4,31.6},{42.4,32.6},{42.6,25.4},{42.6,26.8},{42.6,29.6},{42.6,31.2},{42.6,36.2},{42.8,25.8},{42.8,28.6},{42.8,32.2},{43,33.2},{43,35},{43.2,34},{43.4,24.4},{43.4,27.8},{43.6,24.4},{43.6,27.2},{43.6,28.2},{43.6,32.2},{43.6,32.8},{43.6,34.4},{43.6,35.2},{43.8,31.4},{44,25.2},{44,26.4},{44,36.4},{44.4,37},{44.4,37.6},{44.6,36.2},{44.6,37.4},{45,38},{45.4,38.6},{45.6,38.4},{46,28},{46.2,39.4},{46.2,39.6},{46.6,40.4},{47.2,41.4},{47.4,41.6},{47.4,42.6},{47.6,42.4},{47.8,47.2},{48,42.8},{48.2,43.8},{48.6,43.8},{48.8,47.4},{49,43},{49,44.8},{49.6,46.4},{50,38.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228722] = {
            [npcKeys.name] = "Infernus Siege Giant",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{25.2,48.4},{25.2,53.4},{25.6,51},{25.8,52.2},{26.2,50.2},{26.2,55.2},{26.8,45.8},{26.8,52.2},{27,44.2},{27,46.8},{27,49.4},{27.2,52.6},{27.4,51},{27.4,53.6},{27.6,45.2},{27.6,47.8},{27.6,50.8},{27.6,81.4},{27.8,55},{28,42.4},{28,64.8},{28,78},{28.2,46},{28.2,46.6},{28.2,53.8},{28.4,66.6},{28.4,73.2},{28.4,76.6},{28.6,42.6},{28.6,44.6},{28.6,48.4},{28.6,75.8},{28.8,46.8},{28.8,48.8},{28.8,54},{28.8,55.6},{28.8,65.8},{29,57},{29,63.4},{29,67.8},{29,70.2},{29,77},{29,78.4},{29.2,45.6},{29.2,62},{29.2,74.4},{29.4,71.4},{29.4,71.6},{29.4,72.8},{29.6,43},{29.6,53.6},{29.6,56},{29.6,67.4},{29.6,68},{29.8,43.6},{29.8,55},{29.8,57.8},{29.8,61.8},{29.8,72.4},{29.8,75},{30,44.6},{30,70},{30,73},{30.2,51.4},{30.2,53},{30.2,58.6},{30.2,61},{30.2,68.8},{30.4,52.2},{30.4,57.4},{30.4,60},{30.4,71.4},{30.6,72.4},{30.8,41.6},{30.8,43},{30.8,61},{30.8,66.6},{30.8,69.4},{31,55.2},{31,59.2},{31,63.4},{31,67.6},{31,70},{31,70.6},{31,73.2},{31,73.8},{31.2,48.6},{31.2,50.2},{31.2,50.8},{31.2,56.6},{31.2,60},{31.2,62.2},{31.2,65.6},{31.4,45.4},{31.4,45.8},{31.4,54},{31.4,56},{31.4,58},{31.4,64},{31.6,34.2},{31.6,46.4},{31.6,47},{31.6,49.2},{31.6,51.2},{31.6,59.2},{31.6,64},{31.6,73.6},{31.8,55},{31.8,65.4},{31.8,71.6},{32,41.8},{32,48.4},{32,52.6},{32,56.4},{32,60.4},{32,67.4},{32,71.4},{32,72.6},{32.2,32.8},{32.2,43},{32.2,44.4},{32.2,45.2},{32.2,57},{32.2,62.2},{32.2,68.2},{32.2,69.6},{32.2,75},{32.4,40.6},{32.4,49.6},{32.4,52.2},{32.4,54.2},{32.4,58.2},{32.4,61},{32.4,62.6},{32.4,66.4},{32.4,68.8},{32.6,45.2},{32.6,47},{32.6,49.2},{32.6,57},{32.6,57.6},{32.6,59},{32.6,64.2},{32.6,65.8},{32.6,67},{32.6,76.8},{32.8,44.4},{32.8,50.4},{32.8,60.2},{32.8,65},{33,53.4},{33,53.8},{33,61.4},{33,75.4},{33,75.8},{33.2,46.2},{33.2,62.4},{33.2,68.2},{33.2,69.2},{33.2,72.2},{33.2,73},{33.4,62.8},{33.4,70.2},{33.4,70.8},{33.4,74.4},{33.4,78.2},{33.6,65.6},{33.6,68.6},{33.6,70.8},{33.6,72.8},{33.6,76.2},{33.8,44},{33.8,63.2},{33.8,63.8},{33.8,65},{33.8,67},{33.8,70.4},{33.8,72.4},{33.8,74},{33.8,78},{34,49.6},{34,62.2},{34,68.2},{34,76.8},{34.2,49.4},{34.4,45.2},{34.4,60.8},{34.6,42.4},{34.6,48.8},{34.6,63.2},{34.6,64.4},{34.6,69},{34.6,83.8},{34.8,50.6},{34.8,61.2},{34.8,62.2},{34.8,68.2},{34.8,69.8},{35,44.6},{35,47},{35,72.4},{35.2,66},{35.2,73},{35.4,41.4},{35.4,65},{35.4,71},{35.6,46},{35.6,65.2},{35.8,44.2},{35.8,47},{35.8,47.6},{35.8,71},{36,61},{36,73.2},{36.2,68.2},{36.4,64.4},{36.4,69.2},{36.6,42.8},{36.6,70.6},{36.8,72.4},{37.4,73},{38.4,50.4},{38.8,73.6},{39,73.2},{40.2,71.2},{42.6,72.8},{43.6,66.8},{44.6,66.6},{45,62.8},{45.2,61.2},{45.2,70.2},{45.8,62.6},{45.8,67.8},{46.4,63.8},{46.6,69.2},{47,62.2},{47,63},{47,66},{47,66.6},{47.2,63.6},{47.2,67.6},{47.4,61},{47.6,61.8},{48,63.6},{48.2,61.2},{48.2,63.4},{48.2,65.6},{48.4,67.2},{48.4,68.8},{48.6,64.6},{48.6,66.2},{48.6,69.4},{48.6,69.8},{48.6,70.8},{48.8,60.8},{48.8,63.8},{49,62.4},{49.2,59.6},{49.2,67.4},{49.4,68.4},{49.6,70.2},{49.8,59},{49.8,62.2},{50,62.8},{50.2,59.6},{50.2,65.4},{50.2,69.2},{50.4,67.2},{50.4,68},{50.6,59.2},{50.6,60.4},{50.6,64.8},{50.6,67.2},{50.8,70.6},{51,61.4},{51,69.2},{51.6,67.8},{51.6,70.8},{51.6,71.6},{51.8,59.8},{51.8,64.4},{51.8,69},{51.8,69.6},{52.6,69.8},{52.8,58.6},{53.2,64},{53.4,59.8},{53.6,65.8},{53.8,58.4},{53.8,70},{54,67},{54,68},{54.2,64.6},{54.4,68.6},{55,57.8},{55.2,53.2},{55.2,57.4},{55.4,67.6},{55.8,52.8},{55.8,57.6},{55.8,62.2},{55.8,66.2},{56,59.6},{56.8,57},{57.2,57.8},{57.4,59},{57.8,53.8},{58,55.4},{58,57.4},{59,70.6},{59.4,55.8},{59.4,72.8},{59.6,61},{60,53.6},{60.2,62.4},{60.2,67.4},{60.4,70.4},{60.6,58.2},{60.6,65.2},{61,59},{61.6,58.6},{62.6,64.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228723] = {
            [npcKeys.name] = "Obsidian Reaver",
            [npcKeys.minLevel] = 56,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{20.4,73.6},{20.8,73.8},{21.2,76.4},{21.2,76.6},{21.4,74.8},{21.8,75},{21.8,76.6},{22,74.2},{22,76.4},{22.2,73.4},{22.2,77.6},{22.6,74},{22.6,76.4},{22.6,77.6},{22.8,76.8},{23.4,72.8},{23.6,72.6},{23.8,72.2},{23.8,76.4},{23.8,76.8},{24.4,77.6},{25,76.2},{25.6,79},{25.8,75.2},{25.8,75.6},{26,77},{26,77.8},{26.2,74.4},{27,78.6},{27.2,71.4},{27.2,72.8},{27.4,68.6},{27.4,69.8},{27.4,72.2},{27.4,80.4},{27.4,81},{27.6,68},{27.6,69},{27.8,66.6},{27.8,70.6},{27.8,80.6},{28,70.4},{28,77.2},{28,78.2},{28,78.8},{28,79.6},{28.2,65.4},{28.2,65.8},{28.4,55.4},{28.4,55.6},{28.4,62.4},{28.4,62.6},{28.4,64.4},{28.4,75.4},{28.4,76.4},{28.4,81.8},{28.6,55.4},{28.6,55.6},{28.6,61.6},{28.6,66},{28.6,75.8},{28.6,81.4},{28.6,81.6},{28.8,56.6},{28.8,61},{28.8,65},{28.8,75.2},{29,63.6},{29,74.4},{29,77.2},{29,78.4},{29,79.8},{29.2,63.2},{29.2,73.4},{29.2,78.8},{29.6,62.4},{29.6,66.2},{29.6,72.8},{29.6,78.4},{29.6,79.2},{29.6,79.6},{29.6,80.6},{30.2,69.2},{30.2,72.4},{30.4,55.2},{30.4,55.6},{30.4,71},{30.6,55.2},{30.6,55.6},{30.8,72.2},{31,61.2},{31,62},{31,70.8},{31,77.8},{31.2,63.6},{31.2,72.6},{31.4,63.4},{31.4,64.8},{31.4,66.2},{31.4,67},{31.4,68.2},{31.4,69.4},{31.4,69.6},{31.4,74},{31.4,77},{31.6,63.4},{31.6,63.6},{31.6,69.2},{31.6,70},{31.6,76.4},{31.6,77},{31.8,67.2},{31.8,68},{31.8,71},{31.8,73.4},{31.8,77.6},{32.2,62.2},{32.2,66.2},{32.2,73.8},{32.4,58.4},{32.4,58.6},{32.4,60.4},{32.4,65},{32.4,71.8},{32.4,75},{32.6,58.4},{32.6,59.4},{32.8,66.6},{32.8,74.8},{32.8,76.8},{33,65},{33,72.2},{33,76.4},{33.2,60.2},{33.2,63.4},{33.2,63.8},{33.2,74},{33.4,61.2},{33.4,61.6},{33.4,66},{33.4,71.4},{33.4,73.2},{33.4,77.6},{33.4,79.2},{33.4,80},{33.4,80.6},{33.6,73.6},{33.6,76.4},{33.6,77.4},{33.6,77.8},{33.6,79.4},{33.6,79.6},{33.8,60.4},{34,59.4},{34,63.4},{34,64.4},{34,65.6},{34,66.6},{34,68.6},{34,73},{34,80.6},{34.2,61.8},{34.2,64.8},{34.2,71.4},{34.2,72},{34.4,60.6},{34.4,70.2},{34.6,60.6},{34.6,61.8},{34.6,65.4},{34.6,71.2},{34.6,71.6},{34.6,78.2},{34.8,60.2},{34.8,63.2},{34.8,63.8},{34.8,66.4},{35.2,73},{35.4,67.4},{35.4,67.8},{35.4,68.6},{35.6,67.4},{35.8,68.4},{35.8,68.6},{35.8,72},{36,70},{36.2,64.4},{36.2,70.6},{36.4,62.2},{36.4,63.2},{36.4,73.2},{36.4,74},{36.6,63},{36.6,69},{36.6,69.6},{36.6,70.6},{36.6,72},{36.6,73.4},{36.6,74.2},{36.6,74.6},{38,73.8},{40.2,73.4},{40.2,73.6},{40.6,73.4},{41.2,74.2},{43.2,66},{52,71.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228724] = {
            [npcKeys.name] = "Obsidian Surger",
            [npcKeys.minLevel] = 55,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{28.8,75.2},{28.8,75.6},{29.2,73},{29.2,73.6},{29.4,72.4},{29.6,72.8},{29.6,73.6},{30.4,71.4},{30.4,72.4},{30.6,73.6},{30.8,71.2},{30.8,72.4},{31,72.6},{31.6,72.4},{31.6,72.6},{31.6,73.6},{32.4,75.2},{32.4,76},{32.4,76.8},{32.8,76.8},{33,72.4},{33,74.4},{33,75.4},{33,76.4},{33.4,73.4},{33.4,77.6},{33.4,79.4},{33.4,79.6},{33.4,80.6},{33.6,76.4},{33.6,77.4},{33.6,78.4},{33.6,79.2},{33.6,79.6},{33.6,81.2},{33.8,73.8},{34,72.4},{34,73},{34,82.4},{34.2,82.8},{34.4,83.8},{34.6,71.8},{34.6,72.8},{34.6,83.4},{34.6,83.8},{35.4,71},{36.2,68.2},{36.2,72.6},{36.4,69.2},{36.4,69.6},{36.4,71.2},{36.4,71.6},{36.6,69},{36.6,69.6},{36.8,71.4},{36.8,71.6},{41.4,66.8},{41.6,66.8},{42.4,67.6},{42.4,74},{42.4,74.6},{42.6,67.6},{42.6,74.4},{42.6,74.8},{43.2,66.4},{43.4,66.8},{43.6,66.8},{43.6,67.6},{43.8,66.4},{45,68.8},{45.2,61.2},{45.2,61.8},{45.4,67.4},{45.4,67.6},{45.4,71.4},{45.4,71.6},{45.6,67.4},{45.6,67.6},{45.8,63.4},{45.8,72},{46.2,71.4},{46.4,60},{46.8,60},{46.8,60.6},{47.4,61.6},{48.4,66.2},{48.8,65.8},{48.8,66.6},{49.4,65.4},{49.6,65.6},{49.8,70.2},{49.8,70.6},{50,64.4},{50.4,64.8},{50.6,64.8},{50.8,64.4},{52.4,63},{52.4,64.2},{52.4,64.6},{52.6,63.2},{52.6,64},{53,65},{53.2,65.6},{55.8,64.6},{56,64.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228725] = {
            [npcKeys.name] = "Firesworn",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{14.4,33},{14.8,30.2},{15.2,31},{15.2,32},{15.2,32.6},{15.4,33.6},{15.4,38.6},{15.6,30.4},{15.6,30.6},{15.6,33},{15.6,50.4},{16.4,51.8},{16.4,52.6},{16.4,53.6},{16.6,52.4},{16.6,53.8},{17,51.4},{17,52.8},{17.4,54.6},{17.6,51.4},{17.6,52.8},{17.6,54.4},{17.8,52},{17.8,55.2},{18.8,51.2},{19.2,51.8},{26.8,42.4},{26.8,42.8},{31.4,66.8},{31.4,68.8},{32,66},{32.4,65.4},{32.4,67.2},{32.4,68},{32.4,68.8},{32.6,64.8},{32.6,66.4},{32.6,67.6},{32.8,66.6},{33.6,67.4},{33.8,67.8},{40.2,45.2},{41.2,34.8},{42.6,40.4},{43.4,39.4},{43.8,40},{44.4,39.4},{45,39},{45.4,36},{45.8,38.8},{46,41.2},{46.2,35},{46.2,36.2},{46.4,36.8},{46.4,38.4},{46.6,35.4},{46.6,36.8},{46.8,36},{47.4,33.6},{47.6,35.8},{48,34.8},{48.2,33.4},{48.6,36.2},{48.8,36.6},{49,34.8},{52,33.6},{52.2,36},{55.8,31.2},{56.6,57},{57.6,58.2},{58.2,58.6},{58.6,57.2},{58.8,58.8},{59,58.4},{59,62},{59.4,55},{59.8,31.4},{60.2,53.6},{60.2,54.6},{60.2,59},{60.2,59.8},{60.2,61},{60.4,56.6},{60.4,58},{60.6,29},{60.6,59.4},{60.6,60},{61,54.4},{61,56.2},{61,56.6},{61,58.2},{61,61},{61.2,30.8},{61.2,32.2},{61.2,55.2},{61.4,32.8},{61.4,34.4},{61.6,56.8},{61.8,34},{61.8,59.2},{61.8,59.6},{62,34.8},{62,61},{62.2,29.8},{62.2,58.2},{62.4,31.4},{62.4,32},{62.4,33},{62.6,32.6},{62.8,60.2},{63,30},{63,31.4},{63,59.4},{63.2,31.8},{63.2,34.6},{63.4,29.2},{63.6,31.8},{63.8,30.4},{63.8,30.6},{64.2,28.8},{64.2,32.6},{64.2,34.8},{64.4,28.4},{64.6,31.8},{64.6,32.6},{64.8,27.2},{65.2,23.4},{65.2,25},{65.2,25.6},{65.4,24.4},{65.6,28.6},{68,34.8},{83,56.2},{83.4,60},{84,59.4},{84.2,66},{84.6,53},{84.6,54.2},{84.6,56.2},{84.6,56.8},{85,55.4},{85.6,51.4},{85.8,54.8},{86.2,52},{86.2,52.6},{86.4,53.6},{86.6,52.6},{87.2,49},{87.2,50.8},{87.2,52.2},{87.4,53.6},{87.6,49.4},{87.8,53.2},{88,50},{88,52.2},{88,55},{88.4,54.4},{88.6,52.2},{89,50.8},{89.4,50.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228726] = {
            [npcKeys.name] = "Flamebringer Elementalist",
            [npcKeys.minLevel] = 55,
            [npcKeys.maxLevel] = 56,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{15,35.6},{15.4,34.4},{15.4,35},{15.6,35},{16.2,41.8},{16.6,41.6},{19.4,37.4},{19.4,37.8},{19.4,38.6},{19.6,36.2},{19.6,38.4},{19.6,38.6},{21.2,29},{21.6,29},{22.2,34.6},{22.4,34.2},{22.6,34.4},{22.6,34.6},{22.8,27.6},{23,26.4},{23,36},{23.2,26.8},{23.6,27.2},{24.4,28},{24.8,27.4},{24.8,28.4},{25,28.6},{26,36.4},{26,36.6},{26.2,29.4},{26.2,30},{26.6,30}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228727] = {
            [npcKeys.name] = "Flamebringer Defender",
            [npcKeys.minLevel] = 55,
            [npcKeys.maxLevel] = 56,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{13.2,40.6},{13.4,37.4},{13.4,38.4},{13.4,40.2},{13.4,42.2},{13.6,38.4},{13.6,38.6},{13.6,39.6},{13.8,37.4},{14,35.8},{14.2,43.2},{14.4,43.6},{14.6,43.6},{15,43.2},{15.2,35},{15.4,34},{15.4,35.6},{15.6,43.6},{15.8,33.4},{15.8,34.6},{15.8,43},{16.2,36},{16.2,37.6},{16.2,41.8},{16.4,34},{16.4,36.6},{16.6,36.4},{16.6,36.8},{17,37.6},{17.2,34.6},{17.2,41.6},{17.4,34.4},{17.4,41.2},{17.6,34.4},{18,35},{18,37.6},{18.2,41.4},{18.4,36.4},{18.4,37},{18.4,41.6},{18.6,35.4},{18.6,36.6},{18.8,41.6},{19,35.6},{19.4,38.2},{19.4,40.4},{19.4,40.8},{19.6,35.6},{19.6,38.4},{19.6,40.4},{19.6,40.6},{19.8,39.4},{21.2,36},{21.4,29.2},{21.4,29.6},{21.4,31.4},{21.4,31.6},{21.6,31},{21.6,31.6},{21.8,30.4},{22,36.4},{22.4,25.4},{22.4,25.6},{22.4,27.4},{22.4,28.4},{22.4,28.6},{22.4,37},{22.4,38},{22.4,39},{22.6,28.6},{22.6,31.4},{22.8,25.4},{22.8,27.4},{22.8,27.6},{22.8,37.6},{22.8,38.6},{23,25.8},{23,30.2},{23,36.2},{23,37.4},{23,39.8},{23.2,35},{23.4,41},{23.6,25.4},{23.6,25.8},{23.6,27.4},{23.6,37},{23.6,39.4},{24,27.8},{24,40.2},{24,41.2},{24,42},{24,44.2},{24.2,37.6},{24.2,42.8},{24.4,32.4},{24.4,32.8},{24.4,33.6},{24.4,34.6},{24.4,35.6},{24.6,33.8},{24.6,35.6},{24.6,40.8},{24.8,28},{24.8,28.6},{24.8,32.4},{24.8,32.8},{24.8,37},{24.8,37.6},{25,35.4},{25.2,30.8},{25.4,25.8},{25.4,27.2},{25.4,30.4},{25.6,27},{25.6,29.4},{25.6,33},{26,26.2},{26.2,30},{26.2,34.4},{26.2,35.6},{26.2,36.8},{26.4,23.8},{26.4,25.4},{26.4,34.8},{26.6,25.6},{26.6,33.2},{26.8,30},{26.8,34.6},{27,24.8},{27.2,24.4},{27.4,34.2},{27.6,34.4},{27.6,34.6},{28.6,34},{31.2,33.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228728] = {
            [npcKeys.name] = "Flamebringer Kelris",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{13.2,41},{13.4,40},{13.4,42.2},{13.4,42.6},{13.6,37.4},{13.6,39.4},{13.6,41.4},{13.6,42.4},{13.8,38},{14,35.6},{14.2,35},{14.2,43.2},{14.4,40.2},{14.4,43.6},{14.6,36.4},{14.6,37.2},{14.6,37.8},{14.6,39},{14.6,39.6},{15,34.8},{15,43.2},{15,43.8},{15.2,44.8},{15.4,42.2},{15.8,43.4},{15.8,43.6},{16,42.2},{16,44.6},{16.2,33.8},{16.6,44.6},{16.8,41.6},{17.2,41.4},{17.2,42.6},{17.6,41.4},{19,41.2},{19.6,35.8},{21.6,38.4},{28,34.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228729] = {
            [npcKeys.name] = "Duke Tectonis",
            [npcKeys.minLevel] = 59,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{27.4,80.4},{27.4,81},{27.4,81.6},{27.6,80.8},{27.6,81.6},{27.8,80.2},{28,78.4},{28,79.2},{28.2,76.8},{28.4,76.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228730] = {
            [npcKeys.name] = "Dread Seed",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228731] = {
            [npcKeys.name] = "Dread Lasher",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228738] = {
            [npcKeys.name] = "Calyx Greenglow",
            [npcKeys.minLevel] = 53,
            [npcKeys.maxLevel] = 53,
            [npcKeys.zoneID] = 361,
            [npcKeys.spawns] = {
                [361] = {{61.4,13},{61.6,13}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228743] = {
            [npcKeys.name] = "[DNT] Pyranis Fog Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228747] = {
            [npcKeys.name] = "Flamebringer Stalker",
            [npcKeys.minLevel] = 55,
            [npcKeys.maxLevel] = 56,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{33.4,28.4},{33.4,28.8},{33.4,29.6},{33.6,28.4},{33.6,28.6},{33.6,29.6},{33.8,27.4},{33.8,31.2},{33.8,32},{34.4,26.2},{34.8,29.6},{35.4,25.2},{35.4,26.4},{35.4,27},{35.4,28.2},{35.4,28.6},{35.6,27},{35.6,28.6},{36.2,25.4},{36.4,26},{36.4,28},{36.6,25.4},{36.6,26.4},{36.8,26.8},{37.2,28.6},{37.4,27.6},{37.6,27.4},{37.8,28.2},{37.8,28.6},{37.8,29.6},{37.8,30.8},{38.4,25.2},{38.4,25.6},{38.6,28},{39,25},{39,25.8},{39.4,27.4},{39.6,26.4},{39.6,26.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228748] = {
            [npcKeys.name] = "Poisoned Sapling",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228770] = {
            [npcKeys.name] = "Carrion Swarm",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228771] = {
            [npcKeys.name] = "Electromantic Resonance Transducer",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{53.4,40},{53.6,40}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228786] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228793] = {
            [npcKeys.name] = "Rift",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228814] = {
            [npcKeys.name] = "Arcterris",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{62,18},{63.2,17.4},{63.2,17.6},{63.4,16},{63.6,17.8},{63.8,16.4},{63.8,16.6},{64.6,18.2},{65,18.8},{65.2,20.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228816] = {
            [npcKeys.name] = "Primal Flame Elemental",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228818] = {
            [npcKeys.name] = "Shrine of Cooperation",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {84325,84410},
            [npcKeys.questEnds] = nil,
        },
        [228820] = {
            [npcKeys.name] = "Hydraxian Firefighter",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228822] = {
            [npcKeys.name] = "Calyx Greenglow",
            [npcKeys.minLevel] = 53,
            [npcKeys.maxLevel] = 53,
            [npcKeys.zoneID] = 361,
            [npcKeys.spawns] = {
                [361] = {{61.4,13},{61.6,13}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {84369},
            [npcKeys.questEnds] = nil,
        },
        [228833] = {
            [npcKeys.name] = "Flamewaker",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228834] = {
            [npcKeys.name] = "Firesworn",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228835] = {
            [npcKeys.name] = "Core Rager",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228836] = {
            [npcKeys.name] = "Flamewaker Elite",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228837] = {
            [npcKeys.name] = "Flamewaker Healer",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228838] = {
            [npcKeys.name] = "Flamewaker Priest",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228891] = {
            [npcKeys.name] = "Enraged Shade",
            [npcKeys.minLevel] = 53,
            [npcKeys.maxLevel] = 53,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{28.6,35.6},{29.6,35.4},{29.8,35.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228902] = {
            [npcKeys.name] = "Calyx Greenglow",
            [npcKeys.minLevel] = 53,
            [npcKeys.maxLevel] = 53,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{29.8,35.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {84369},
        },
        [228906] = {
            [npcKeys.name] = "Mannoroc Lasher",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228907] = {
            [npcKeys.name] = "Core Hound",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228908] = {
            [npcKeys.name] = "Mannoroc Felguard",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228909] = {
            [npcKeys.name] = "Legion Hound",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228910] = {
            [npcKeys.name] = "Hulking Infernal",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228911] = {
            [npcKeys.name] = "Searing Infernal",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228912] = {
            [npcKeys.name] = "Severed Dreamer",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228913] = {
            [npcKeys.name] = "Severed Druid",
            [npcKeys.minLevel] = 59,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228914] = {
            [npcKeys.name] = "Severed Keeper",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228915] = {
            [npcKeys.name] = "Severed Sleeper",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228916] = {
            [npcKeys.name] = "Mannoroc Satyr",
            [npcKeys.minLevel] = 59,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228917] = {
            [npcKeys.name] = "Water Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228918] = {
            [npcKeys.name] = "Mannoroc Shadowstalker",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228919] = {
            [npcKeys.name] = "Mannoroc Hellcaller",
            [npcKeys.minLevel] = 59,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228920] = {
            [npcKeys.name] = "Bleakheart Trickster",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228928] = {
            [npcKeys.name] = "Maethra Slagheart",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 41,
            [npcKeys.spawns] = {
                [41] = {{40.8,78.4},{40.8,78.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {84331},
            [npcKeys.questEnds] = {84329,84331},
        },
        [228929] = {
            [npcKeys.name] = "Baj'ura",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 41,
            [npcKeys.spawns] = {
                [41] = {{40.8,78.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228930] = {
            [npcKeys.name] = "Syrnoya",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 41,
            [npcKeys.spawns] = {
                [41] = {{40.8,78.4},{40.8,78.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228931] = {
            [npcKeys.name] = "Father Lazarus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 41,
            [npcKeys.spawns] = {
                [41] = {{40.8,78.4},{40.8,78.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228932] = {
            [npcKeys.name] = "Divine Apprehension",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228934] = {
            [npcKeys.name] = "Thane Korth'azz",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{27,84.4},{27.2,85.4},{27.4,85.8},{27.6,85.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228935] = {
            [npcKeys.name] = "Enraged Spirit",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{27.2,85.4},{27.4,85.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228936] = {
            [npcKeys.name] = "Lingering Blessing",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 41,
            [npcKeys.spawns] = {
                [41] = {{40.8,78.4},{40.8,78.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228944] = {
            [npcKeys.name] = "Electromantic Resonance Transducer",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{53.4,57.2},{53.6,57.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228945] = {
            [npcKeys.name] = "[DNT] Challenge",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228956] = {
            [npcKeys.name] = "Sebastian Jurgens",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {84138,84213},
            [npcKeys.questEnds] = {84137,84212},
        },
        [228969] = {
            [npcKeys.name] = "Lord Gazzran",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{30.8,58},{31.2,58.6},{32,68.4},{32.4,58.2},{32.4,63.4},{32.4,64},{33,67.8},{33.2,60.6},{33.4,65.2},{33.6,60},{33.6,66},{33.6,68.2},{34,62.2},{34.2,63.8},{34.6,61.4},{34.6,65},{34.8,62.6},{34.8,69.8},{35.2,67.6},{35.4,66},{35.4,66.6},{35.6,70.2},{35.8,66},{35.8,68.8},{36,63.4},{36,65.2},{36.4,66.8},{36.4,68},{36.6,70},{36.8,71.2},{37.2,60},{37.2,63.8},{37.2,65.4},{37.2,67.8},{37.4,65.8},{37.4,67.2},{37.4,72},{37.6,65.4},{37.6,67.2},{37.6,73},{37.8,72},{38.2,68.6},{38.4,68.4},{38.6,67.4},{38.6,68},{38.6,68.6},{39.8,68.4},{40,68.8},{40.6,68.6},{40.8,67.8},{41,70.8},{41.6,70.6},{42,66.8},{42,68.2},{42,72.6},{42.2,68.8},{42.4,65},{43,67.6},{43.4,66.8},{43.6,75},{44,66},{44.6,69.6},{44.6,70.6},{45.2,68.2},{45.4,68.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228970] = {
            [npcKeys.name] = "Galenges",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{19.4,74.6},{19.8,73.2},{19.8,76},{20.4,77},{20.4,78},{21,79.6},{21.2,77.4},{21.2,79},{21.4,78},{21.6,78.4},{21.6,78.6},{21.8,76.4},{22.4,77},{22.6,77.6},{23.2,72.6},{23.2,77},{23.4,76.2},{23.8,78.4},{24.2,76.4},{24.2,76.6},{24.8,76.2},{25.6,77.2},{26,70},{26.6,76.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228973] = {
            [npcKeys.name] = "[DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [228976] = {
            [npcKeys.name] = "Altruist Ward",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 3,
            [npcKeys.spawns] = {
                [3] = {{2.4,45}},
                [41] = {{41,79.2}},
                [45] = {{26.4,60}},
                [139] = {{47.6,58.4},{47.6,58.8},{48,21.8}},
                [1377] = {{39,69}},
                [1637] = {{35.4,87.6},{35.8,87.8},{50.6,71},{51.8,68.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229001] = {
            [npcKeys.name] = "Core Hound",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229009] = {
            [npcKeys.name] = "Spirit of Magmadar",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229016] = {
            [npcKeys.name] = "Orthas",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{27.4,85.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229018] = {
            [npcKeys.name] = "Rotting Dwarf Corpse",
            [npcKeys.minLevel] = 56,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{27.4,85.4},{27.4,85.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {84414},
            [npcKeys.questEnds] = {84330},
        },
        [229035] = {
            [npcKeys.name] = "Korth'azz's Chest",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229037] = {
            [npcKeys.name] = "[DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229047] = {
            [npcKeys.name] = "Goblin Friend",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229051] = {
            [npcKeys.name] = "Rift",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229052] = {
            [npcKeys.name] = "Rift",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229057] = {
            [npcKeys.name] = "Core Rager",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229061] = {
            [npcKeys.name] = "Thorium Brotherhood Lookout",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{14.6,43.2},{15.2,35.2},{15.4,33.8},{15.4,44.4},{15.8,36.6},{16.2,33.2},{16.4,34},{16.8,34.4},{16.8,34.8},{17.6,34.8},{17.6,42.6},{18.6,38.4},{18.8,41.4},{19.4,36.2},{20.4,35.8},{21,35.8},{21.2,29.4},{21.2,32.4},{21.8,29.6},{22.2,36.4},{22.2,40.4},{22.4,31.4},{22.4,37.2},{22.6,39.4},{22.8,28.2},{22.8,28.8},{22.8,37},{22.8,40.6},{23,27.4},{23,41.8},{23.2,25},{23.2,35.2},{23.2,35.6},{23.2,38.2},{23.6,37.2},{23.6,39.2},{23.8,43.6},{24,39.8},{24.2,32.8},{24.2,36},{24.4,28.2},{24.4,34.8},{24.4,38.4},{24.4,40.8},{24.4,46.2},{24.6,28.4},{24.6,32},{24.6,35},{24.8,27},{24.8,35.6},{24.8,41},{24.8,47},{25,32.8},{25,36.6},{25,48.2},{25.2,25.6},{25.2,29.6},{25.2,30.8},{25.2,33.8},{25.2,49.6},{25.6,36.6},{25.8,36.4},{25.8,50.8},{26,25.6},{26,34.4},{26,34.6},{26.2,42.4},{26.4,31.6},{26.4,33.2},{26.8,34.4},{26.8,40.8},{26.8,47},{26.8,49.8},{27,35.8},{27.2,34.6},{27.2,51.2},{27.4,52.2},{27.4,74},{27.6,80.4},{27.8,45.4},{27.8,48.2},{28,35.2},{28,80.6},{28.2,34.4},{28.2,36.2},{28.6,46.8},{28.6,56.2},{28.6,76},{28.8,33.4},{28.8,33.6},{28.8,38.2},{29,34.6},{29,80},{29,81.4},{29.2,53},{29.2,72.2},{29.4,40.8},{29.4,49},{29.4,58},{29.4,61.8},{29.4,73.6},{29.6,33.2},{29.6,46},{29.8,79},{30.2,33.6},{30.2,53.8},{30.4,34.8},{30.6,33.4},{30.6,55.4},{30.6,73.2},{30.8,33.8},{30.8,34.6},{30.8,36},{30.8,39.8},{30.8,46.6},{31,49.8},{31,58.2},{31,62},{31.2,54.4},{31.4,41.8},{31.4,57.4},{31.4,60.8},{31.6,33.8},{31.6,38.6},{31.6,48.8},{31.8,35},{31.8,41},{31.8,60.8},{32,33.2},{32.2,39.8},{32.2,42.4},{32.2,44.8},{32.2,59.4},{32.2,63},{32.2,70.6},{32.4,32.4},{32.4,38.2},{32.4,52},{32.4,54.6},{32.6,33.4},{32.6,33.8},{32.6,44.6},{32.6,63},{32.6,75.6},{32.8,26.6},{32.8,31},{32.8,32},{32.8,45.8},{32.8,57.8},{33,43},{33,52.2},{33,64},{33,65.2},{33.2,26},{33.2,37},{33.2,39.4},{33.2,72.2},{33.4,28.4},{33.4,29.2},{33.4,30},{33.4,35},{33.6,28.2},{33.6,28.6},{33.6,30.2},{33.6,30.6},{33.6,34.8},{33.6,61.8},{33.6,68.4},{33.6,73.8},{33.6,76.6},{33.6,78.2},{33.8,32.2},{33.8,43},{33.8,51},{33.8,63},{34,26.6},{34,38.4},{34,42.4},{34,44},{34,64},{34,71.4},{34,80.6},{34,83},{34.2,24.2},{34.2,37.4},{34.2,41},{34.2,60.8},{34.4,22.8},{34.4,25.4},{34.4,26.2},{34.4,32.6},{34.6,26.2},{34.6,32.8},{34.6,40},{34.6,59},{34.8,28},{34.8,28.8},{34.8,29.6},{34.8,30.8},{34.8,32.2},{34.8,35},{34.8,35.6},{34.8,38.8},{34.8,42.2},{34.8,46},{35,25.4},{35,27.4},{35,37.2},{35.2,24},{35.2,71.8},{35.4,23.4},{35.4,34.2},{35.4,37.8},{35.4,44},{35.4,49.6},{35.6,26},{35.6,27.4},{35.6,27.6},{35.6,28.6},{35.6,68},{35.8,21},{35.8,23.6},{35.8,25.4},{35.8,32.6},{35.8,36.6},{35.8,49.2},{35.8,65},{36,44.8},{36.2,22},{36.2,23.4},{36.2,34.6},{36.2,38.8},{36.4,36.2},{36.4,45.8},{36.4,51.6},{36.6,26.2},{36.8,22.8},{36.8,26.8},{36.8,31.8},{36.8,33.4},{37,36.4},{37.2,31},{37.4,27.6},{37.4,29},{37.4,33.6},{37.4,36.6},{37.4,43},{37.6,64.2},{37.8,26.8},{37.8,30.4},{37.8,31},{37.8,34.4},{37.8,36.2},{37.8,62.2},{38,25.6},{38,29},{38,43},{38,45},{38.4,27.8},{38.6,25.4},{38.6,28},{38.6,29.4},{38.6,30.2},{38.6,31.2},{38.6,38},{38.8,38.6},{39.2,25.8},{39.2,26.6},{39.2,36.4},{39.2,41.4},{39.6,26.4},{39.6,27.4},{39.6,50.6},{39.8,60.8},{40,31},{40.2,34.4},{40.4,32},{40.6,37},{40.6,42.2},{40.8,34.4},{40.8,34.6},{41,59.6},{41.2,38.4},{41.2,54.8},{41.6,39},{41.6,73},{41.8,35.6},{41.8,40.2},{42.2,53.8},{42.4,50.8},{42.6,46},{43.2,35},{43.2,42},{43.6,52.8},{43.6,56.8},{43.8,76.8},{44,42},{44.2,39.4},{44.2,40.6},{44.2,45.2},{44.2,46},{44.8,54.6},{45,36.6},{45.4,53.4},{45.8,42},{46,37.8},{46.2,39.8},{46.4,44.2},{46.8,44.4},{46.8,54.2},{47,40},{47.6,37.4},{47.8,42.4},{48.2,37.6},{48.2,51.8},{48.4,49.4},{48.8,35.8},{48.8,60.4},{49,37},{49.2,43.2},{49.4,49.8},{50.4,38},{52.2,36.4},{52.2,40.2},{52.4,64.6},{52.4,65.6},{52.6,46.2},{53.4,36},{54,36.4},{54.2,35.2},{55.4,38.4},{55.6,60.6},{56.2,37.2},{56.8,36},{58.8,72.6},{59.2,34.2},{62.4,45.6},{62.8,33.4},{66.6,53.6},{69.8,39.8},{70.4,35.2},{76.6,20}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229091] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229110] = {
            [npcKeys.name] = "Invisible Bunny",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229140] = {
            [npcKeys.name] = "Furniture",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229156] = {
            [npcKeys.name] = "Air Elemental Fragment",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 493,
            [npcKeys.spawns] = {
                [493] = {{39.8,68}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229200] = {
            [npcKeys.name] = "Astral Wraith",
            [npcKeys.minLevel] = 56,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 1377,
            [npcKeys.spawns] = {
                [1377] = {{11.4,94.8},{11.8,94.4},{11.8,94.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229202] = {
            [npcKeys.name] = "Altruist Ward",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{46.8,36.4}},
                [15] = {{51.2,75.4}},
                [28] = {{70.2,74}},
                [36] = {{34,53.8}},
                [41] = {{40.8,78.6}},
                [46] = {{63.2,36.8}},
                [51] = {{40,32.4}},
                [139] = {{47.6,58.4},{47.8,22.2},{47.8,23.4}},
                [357] = {{30.8,43.2}},
                [1519] = {{38.8,26.4},{39,27},{54.4,63.6},{54.6,63.2},{54.8,65.2},{55.8,62.8},{56.2,71},{57.4,55}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229311] = {
            [npcKeys.name] = "MC",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229312] = {
            [npcKeys.name] = "World Boss",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229346] = {
            [npcKeys.name] = "[DNT] Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229390] = {
            [npcKeys.name] = "Riding Druid",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229425] = {
            [npcKeys.name] = "Zotl",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 493,
            [npcKeys.spawns] = {
                [493] = {{55.4,32.2},{55.4,32.8},{55.6,32.6},{55.8,32.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229452] = {
            [npcKeys.name] = "Crimson Cannon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229454] = {
            [npcKeys.name] = "Divine Apprehension",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229485] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229515] = {
            [npcKeys.name] = "Rift",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229549] = {
            [npcKeys.name] = "[DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229564] = {
            [npcKeys.name] = "Meteor",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229631] = {
            [npcKeys.name] = "Southsea Cutthroat",
            [npcKeys.minLevel] = 59,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229632] = {
            [npcKeys.name] = "Southsea Buccaneer",
            [npcKeys.minLevel] = 59,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229731] = {
            [npcKeys.name] = "Dungeons",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229732] = {
            [npcKeys.name] = "Zilbagob",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229733] = {
            [npcKeys.name] = "Zilbagob",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229737] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229802] = {
            [npcKeys.name] = "Poisoned Sapling",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229803] = {
            [npcKeys.name] = "Furniture",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229805] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229840] = {
            [npcKeys.name] = "Hydraxian Firefighter",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229897] = {
            [npcKeys.name] = "Wild Windtwister",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 493,
            [npcKeys.spawns] = {
                [493] = {{36.8,65.2},{38.2,64.8},{38.4,65.8},{38.4,68.8},{38.6,66.4},{38.8,64.4},{39,67.2},{39.8,67.4},{40,65.4},{40.8,66.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [229984] = {
            [npcKeys.name] = "Siopi",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [230039] = {
            [npcKeys.name] = "Crafted",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [230069] = {
            [npcKeys.name] = "Eskhandar",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [230088] = {
            [npcKeys.name] = "Onyxia Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [230146] = {
            [npcKeys.name] = "Fel Interloper",
            [npcKeys.minLevel] = 55,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{20.6,43.2},{22.4,52.4},{22.4,52.6},{24.2,64.2},{24.2,64.6},{29.4,43.6},{36,61.6},{37.4,41.8},{37.6,42},{57.6,45.4},{57.6,45.6},{60,65},{69.2,26.2},{71.6,31.2},{72,30.2},{72,32},{85.4,43.6},{93.4,59},{93.6,59.2}},
                [139] = {{24.8,20},{28.8,44.2},{31.6,30.4},{31.8,30.6},{82,36.4},{82.6,37},{82.8,40.4},{83.4,45.8},{83.4,46.6},{83.6,46.2},{84.2,43.2},{87,42.4},{87.2,42.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [230302] = {
            [npcKeys.name] = "Lord Kazzak",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 15531,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [230317] = {
            [npcKeys.name] = "Mokvar",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{35,38}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {8923,8930,8960,84155,84156,84157,84158,84159,84160,84161,84162,84171,84172,84173,84174,84175,84176,84177,84178,84203,84204,84205,84206,84207,84208,84209,84210},
            [npcKeys.questEnds] = {8978,8998,84155,84156,84157,84158,84159,84160,84161,84162,84171,84172,84173,84174,84175,84176,84177,84178,84187,84188,84189,84190,84191,84192,84193,84194,84203,84204,84205,84206,84207,84208,84209,84210},
        },
        [230319] = {
            [npcKeys.name] = "Deliana",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1537,
            [npcKeys.spawns] = {
                [1537] = {{43.2,52.6},{43.4,52.2},{43.6,50.8},{43.6,52}},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = {8922,8929,8960,84147,84148,84149,84150,84151,84152,84153,84154,84163,84164,84165,84166,84167,84168,84169,84170,84195,84196,84197,84198,84199,84200,84201,84202},
            [npcKeys.questEnds] = {8977,8997,84147,84148,84149,84150,84151,84152,84153,84154,84163,84164,84165,84166,84167,84168,84169,84170,84179,84180,84181,84182,84183,84184,84185,84186,84195,84196,84197,84198,84199,84200,84201,84202},
        },
        [230481] = {
            [npcKeys.name] = "Earth Elemental Fragment",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 493,
            [npcKeys.spawns] = {
                [493] = {{76,64}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [230513] = {
            [npcKeys.name] = "Siopi",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 493,
            [npcKeys.spawns] = {
                [493] = {{55.4,30.8},{55.6,30.4},{55.6,30.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [230558] = {
            [npcKeys.name] = "Territorial Terran",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 493,
            [npcKeys.spawns] = {
                [493] = {{74,65},{74.2,66.2},{74.8,65.6},{75,65.2},{75.2,64.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [230565] = {
            [npcKeys.name] = "Ironforge Guard",
            [npcKeys.minLevel] = 55,
            [npcKeys.maxLevel] = 55,
            [npcKeys.zoneID] = 1537,
            [npcKeys.spawns] = {
                [1537] = {{43.2,52.4},{43.2,52.6},{43.6,52.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [230566] = {
            [npcKeys.name] = "Kor'kron Elite",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{34.8,38.4},{34.8,38.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [230775] = {
            [npcKeys.name] = "Rage Talon Quartermaster",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1583,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231050] = {
            [npcKeys.name] = "Syndicate Infiltrator",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1583,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {84880},
            [npcKeys.questEnds] = {84870},
        },
        [231178] = {
            [npcKeys.name] = "Duke Hydraxis",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231384] = {
            [npcKeys.name] = "Cenarion Emissary Blackhoof",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231430] = {
            [npcKeys.name] = "Caius Blackwood",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15809,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231485] = {
            [npcKeys.name] = "Procrastimond",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 15793,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {85480},
            [npcKeys.questEnds] = {85480},
        },
        [231494] = {
            [npcKeys.name] = "Prince Thunderaan",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 15825,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231498] = {
            [npcKeys.name] = "Aeonas",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 28,
            [npcKeys.spawns] = {
                [28] = {{51.6,81},{52,83.4},{52.2,83.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {85457,85508},
            [npcKeys.questEnds] = {85507},
        },
        [231499] = {
            [npcKeys.name] = "Ada Darkhardt",
            [npcKeys.minLevel] = 55,
            [npcKeys.maxLevel] = 55,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{28.2,75.4},{28.2,75.6},{28.6,75}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {85511},
            [npcKeys.questEnds] = {85510},
        },
        [231500] = {
            [npcKeys.name] = "Gregory",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 28,
            [npcKeys.spawns] = {
                [28] = {{69.4,79.6},{69.6,79.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {85458},
            [npcKeys.questEnds] = {85457,85511},
        },
        [231652] = {
            [npcKeys.name] = "(DNT) Dorian",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231661] = {
            [npcKeys.name] = "Rahuz",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231678] = {
            [npcKeys.name] = "(DNT) Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231691] = {
            [npcKeys.name] = "Beam Stalker I",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231711] = {
            [npcKeys.name] = "Victor Nefriendius",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 2677,
            [npcKeys.spawns] = {
                [2677] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231779] = {
            [npcKeys.name] = "Pedestal",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15793,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231800] = {
            [npcKeys.name] = "(DNT) Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231810] = {
            [npcKeys.name] = "Uther",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231852] = {
            [npcKeys.name] = "[DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231853] = {
            [npcKeys.name] = "(DNT) Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231858] = {
            [npcKeys.name] = "Storm Mender",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 15825,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231868] = {
            [npcKeys.name] = "Cyclone Imperator",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 15825,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231871] = {
            [npcKeys.name] = "Living Storm",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 15825,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231872] = {
            [npcKeys.name] = "Thundering Rager",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 15825,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231887] = {
            [npcKeys.name] = "Vale Tempest",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 15825,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231979] = {
            [npcKeys.name] = "[DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231980] = {
            [npcKeys.name] = "Shadra",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1977,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231982] = {
            [npcKeys.name] = "Hethiss",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1977,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231984] = {
            [npcKeys.name] = "Silithid Darter",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1377,
            [npcKeys.spawns] = {
                [1377] = {{38.4,27.4},{38.8,26.6},{39,28.4},{39.4,29.8},{39.4,32.6},{39.8,26.4},{39.8,27},{39.8,32},{40,24.4},{40,33.4},{40.4,27.8},{40.4,28.6},{40.4,30.2},{40.4,30.6},{40.6,27.2},{40.6,29.2},{40.6,30.2},{41,28.4},{41,30.6},{41.2,25.2},{41.2,32},{41.2,35.6},{41.4,33},{41.6,26.4},{41.6,27.4},{41.6,28.4},{41.6,29.6},{41.8,28.6},{41.8,35.4},{42,31.4},{42,32.4},{42.2,33.8},{42.4,33.2},{42.4,36.2},{42.6,32.4},{42.8,33},{42.8,33.8},{43,35},{43,38.2},{43.4,35.6},{43.4,37.4},{43.6,34.2},{43.6,34.6},{43.6,36},{43.8,32.8},{44.4,28.4},{44.4,37.4},{44.4,38.2},{44.6,37.8},{44.8,33.2},{45,36},{45.2,34},{45.2,37.2},{45.4,31.6},{45.6,33.8},{47.6,27},{47.6,32.6},{48.2,27.6},{48.2,28.8},{48.2,31.8},{48.2,34.4},{48.4,30.8},{48.6,33.6},{48.8,29.4},{48.8,31.6},{49,28},{49,32.8},{49.2,27.4},{49.2,29.8},{49.2,30.8},{49.4,26},{49.6,30.6},{49.6,32},{49.8,27.2},{50,25.6},{50,28.4},{50,29.2},{50,30},{50.4,24.6},{50.6,26.8},{50.6,29.2},{50.8,28.2},{50.8,30.2},{51.2,20},{51.2,23.4},{51.2,25.4},{51.2,31.4},{51.4,23.6},{51.4,25.8},{51.6,21.8},{51.6,23.4},{51.6,28.8},{51.8,30.6},{52,25.8},{52,28},{52,32.2},{52.2,21.4},{52.2,24.6},{52.2,27.2},{52.2,29.6},{52.4,23.8},{52.6,22.4},{52.6,23.4},{52.6,24},{52.8,24.6},{52.8,25.6},{53,21},{53,29.6},{53.2,29.4},{53.8,23.8},{53.8,25.4},{53.8,28.8},{53.8,32.2},{54,28.4},{54,29.8},{54,30.6},{54.2,26.8},{54.4,25.6},{54.6,30},{54.8,27.2},{54.8,27.6},{54.8,29.4},{56.2,26.2},{56.2,27},{56.6,30.2},{56.8,27.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231990] = {
            [npcKeys.name] = "Bethekk",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1977,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231991] = {
            [npcKeys.name] = "Shirvallah",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1977,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231992] = {
            [npcKeys.name] = "Hir'eek",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1977,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [231996] = {
            [npcKeys.name] = "Gonk",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232000] = {
            [npcKeys.name] = "[DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232074] = {
            [npcKeys.name] = "Renegade Felguard",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232075] = {
            [npcKeys.name] = "Incubus Enthraller",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{53.2,83.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232103] = {
            [npcKeys.name] = "Black Whelp",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 2677,
            [npcKeys.spawns] = {
                [2677] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232104] = {
            [npcKeys.name] = "Bronze Whelp",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 2677,
            [npcKeys.spawns] = {
                [2677] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232105] = {
            [npcKeys.name] = "Red Whelp",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 2677,
            [npcKeys.spawns] = {
                [2677] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232107] = {
            [npcKeys.name] = "Blue Whelp",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 2677,
            [npcKeys.spawns] = {
                [2677] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232109] = {
            [npcKeys.name] = "Green Whelp",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 2677,
            [npcKeys.spawns] = {
                [2677] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232190] = {
            [npcKeys.name] = "Spawn of Shadra",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 1977,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232215] = {
            [npcKeys.name] = "Rahuz",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232216] = {
            [npcKeys.name] = "Rahuz",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232223] = {
            [npcKeys.name] = "Frost Tomb",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232270] = {
            [npcKeys.name] = "Tempest",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232286] = {
            [npcKeys.name] = "BWL",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232309] = {
            [npcKeys.name] = "Highlord Demitrian",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 15825,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {85441},
            [npcKeys.questEnds] = {85441,85442,85443},
        },
        [232335] = {
            [npcKeys.name] = "Enslaved Spawn of Mar'li",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232380] = {
            [npcKeys.name] = "Weaver",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232381] = {
            [npcKeys.name] = "Valxx Cracklequil",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{60.6,38}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {85386},
            [npcKeys.questEnds] = {85385,85386},
        },
        [232386] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232398] = {
            [npcKeys.name] = "Primordial Flame",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{15,55.4},{15,56.8},{15.4,54.4},{15.4,56.4},{15.4,57.6},{15.6,56.6},{15.6,57.6},{15.6,58.8},{16.6,58.2},{17.4,55.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232399] = {
            [npcKeys.name] = "Outcast Cryomancer",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{63.2,68.4},{63.2,68.6},{63.6,68.4},{63.6,68.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232422] = {
            [npcKeys.name] = "Earth Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232424] = {
            [npcKeys.name] = "Earth Surger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232426] = {
            [npcKeys.name] = "Respawn Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232429] = {
            [npcKeys.name] = "Magical Stone",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{14.6,56.4},{15,56.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232462] = {
            [npcKeys.name] = "Rowan's Cooler Test Guy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232466] = {
            [npcKeys.name] = "Magical Stone",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{63.2,68.4},{63.2,68.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232467] = {
            [npcKeys.name] = "Spawn of Mar'li",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 1977,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232479] = {
            [npcKeys.name] = "Kha'damu",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232493] = {
            [npcKeys.name] = "T2",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232529] = {
            [npcKeys.name] = "Nandieb",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15938,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232532] = {
            [npcKeys.name] = "Fel Interloper",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{52.4,54.8},{52.8,54.2},{52.8,56.2},{53.2,56.8},{53.6,53.8},{53.6,56},{54.2,50},{54.4,55.2},{54.6,55.2},{55.4,49.2},{55.6,49.2},{55.6,50},{56.4,50.8},{56.6,50.2},{56.6,50.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232534] = {
            [npcKeys.name] = "Manathirst Imp",
            [npcKeys.minLevel] = 56,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{52.4,55.4},{52.4,55.6},{52.6,54.6},{53,53.4},{53.2,56.8},{53.4,53.8},{53.4,56.2},{53.6,54},{53.6,56},{54.2,55},{54.4,49.8},{54.6,49.8},{54.6,54.8},{54.8,52.4},{54.8,54.4},{55.4,49.2},{55.6,49.4},{56.4,50.4},{56.4,50.6},{56.6,50.4},{56.6,50.8},{57.4,49.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232538] = {
            [npcKeys.name] = "Growing Fel Rift",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{52.4,54.8},{52.8,54.2},{52.8,56.2},{53.2,56.8},{53.6,53.8},{53.6,56},{54.2,50},{54.4,55.2},{54.6,55.2},{55.4,49.2},{55.6,49.2},{56.4,50.6},{56.6,50.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232556] = {
            [npcKeys.name] = "Drake",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232557] = {
            [npcKeys.name] = "Drake",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232558] = {
            [npcKeys.name] = "Rampaging Dead",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232559] = {
            [npcKeys.name] = "Shambling Dead",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232560] = {
            [npcKeys.name] = "Scourge Footsoldier",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 59,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232561] = {
            [npcKeys.name] = "Dread Spellweaver",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 59,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232562] = {
            [npcKeys.name] = "Scourge Reaver",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232564] = {
            [npcKeys.name] = "Scourge Horror",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232565] = {
            [npcKeys.name] = "Cult Necromancer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232566] = {
            [npcKeys.name] = "Cult Acolyte",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232567] = {
            [npcKeys.name] = "Cult Warrior",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232568] = {
            [npcKeys.name] = "Daughter of Nandieb",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15938,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232587] = {
            [npcKeys.name] = "Nefarian",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2677,
            [npcKeys.spawns] = {
                [2677] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232596] = {
            [npcKeys.name] = "Riosus",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 11,
            [npcKeys.spawns] = {
                [11] = {{74.2,70}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {85446,85453},
            [npcKeys.questEnds] = {85446,85447},
        },
        [232597] = {
            [npcKeys.name] = "Mysterious Hooded Figure",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232619] = {
            [npcKeys.name] = "ZG",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232624] = {
            [npcKeys.name] = "Krasus",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 11,
            [npcKeys.spawns] = {
                [11] = {{74.4,70}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {85454},
            [npcKeys.questEnds] = {85453,85454},
        },
        [232625] = {
            [npcKeys.name] = "Riosustrasz",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 11,
            [npcKeys.spawns] = {
                [11] = {{70.8,68.4},{73.6,65.6},{73.6,71.2},{73.8,66.8},{73.8,68.2},{73.8,68.6},{74.2,70}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232626] = {
            [npcKeys.name] = "DNT",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232627] = {
            [npcKeys.name] = "Arthas Menethil",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232628] = {
            [npcKeys.name] = "Faerie Lamp",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 15938,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232629] = {
            [npcKeys.name] = "[DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232630] = {
            [npcKeys.name] = "Son of Nandieb",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15938,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232632] = {
            [npcKeys.name] = "Azgaloth",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232633] = {
            [npcKeys.name] = "[DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232634] = {
            [npcKeys.name] = "Parasitic Serpent",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 1977,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232638] = {
            [npcKeys.name] = "Zulian Panther",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232651] = {
            [npcKeys.name] = "Blood of the Lightbringer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232670] = {
            [npcKeys.name] = "Majordomo Executus",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2717,
            [npcKeys.spawns] = {
                [2717] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232693] = {
            [npcKeys.name] = "PvP T2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232694] = {
            [npcKeys.name] = "Storm Mender",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 15825,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232708] = {
            [npcKeys.name] = "Andorhal Farmer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232709] = {
            [npcKeys.name] = "Andorhal Farmer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232710] = {
            [npcKeys.name] = "Andorhal Resident",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232711] = {
            [npcKeys.name] = "Andorhal Resident",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232713] = {
            [npcKeys.name] = "Andorhal Rifleman",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232714] = {
            [npcKeys.name] = "Andorhal Rifleman",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232725] = {
            [npcKeys.name] = "Gavinrad the Dire",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232729] = {
            [npcKeys.name] = "Sage Truthbearer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232731] = {
            [npcKeys.name] = "Xirath",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{69.6,32}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232741] = {
            [npcKeys.name] = "Silithid Darter",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232744] = {
            [npcKeys.name] = "Ballador the Bright",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232746] = {
            [npcKeys.name] = "Paladin",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232747] = {
            [npcKeys.name] = "Paladin",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232752] = {
            [npcKeys.name] = "Deathly Steed",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232754] = {
            [npcKeys.name] = "Rotting Ghoul",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232755] = {
            [npcKeys.name] = "Van Amburgh",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 490,
            [npcKeys.spawns] = {
                [490] = {{22.4,33.2},{22.6,33.4},{23.6,33}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232756] = {
            [npcKeys.name] = "Hungry Dead",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232775] = {
            [npcKeys.name] = "Paladin",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232778] = {
            [npcKeys.name] = "Rotting Ghoul",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232781] = {
            [npcKeys.name] = "Towering Abomination",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232799] = {
            [npcKeys.name] = "Silithid Darter",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232802] = {
            [npcKeys.name] = "Doan Karhan",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{81.2,59}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {85485,85486,85505,85506},
            [npcKeys.questEnds] = {85468,85485,85486,85505},
        },
        [232816] = {
            [npcKeys.name] = "Bearthold",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 490,
            [npcKeys.spawns] = {
                [490] = {{22.4,33.2},{23.4,33.2},{23.8,33}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232817] = {
            [npcKeys.name] = "Roary",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 490,
            [npcKeys.spawns] = {
                [490] = {{23,33.2},{23,33.6},{24,32.4},{24,32.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232818] = {
            [npcKeys.name] = "Anne Tenna",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 490,
            [npcKeys.spawns] = {
                [490] = {{22.2,33},{22.4,33.6},{22.6,33.2},{23,31.6},{23.2,33.6},{23.6,30.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232826] = {
            [npcKeys.name] = "Causality Glitch",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 15793,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232848] = {
            [npcKeys.name] = "Manathirst Imp",
            [npcKeys.minLevel] = 56,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{69.2,29.4},{69.2,29.6},{69.6,29.6},{69.8,29.4},{70.4,28.4},{70.4,31},{70.6,30},{70.6,31},{71.2,29.2},{71.4,31.8},{72,30.4},{72,30.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232853] = {
            [npcKeys.name] = "Xirath",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{69.4,31.4},{69.4,32.4},{69.4,32.6},{69.4,33.6},{69.6,32},{69.6,32.8},{69.6,33.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232854] = {
            [npcKeys.name] = "Captured Silithid Darter",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1377,
            [npcKeys.spawns] = {
                [1377] = {{49.8,36.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232855] = {
            [npcKeys.name] = "Prismatic Elemental",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{37.4,30.8},{38,29.4},{38,31},{38.2,32.6},{38.4,30.4},{38.4,31.6},{38.6,31.6},{38.8,30.2},{38.8,30.6},{39.6,30},{39.8,30.8},{40,29.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232867] = {
            [npcKeys.name] = "Epic Class Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232869] = {
            [npcKeys.name] = "Thunderaan Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232875] = {
            [npcKeys.name] = "Abandoned Voidwalker",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{58.4,67.4},{58.4,67.6},{58.6,67.4},{58.6,67.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232880] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232884] = {
            [npcKeys.name] = "Cult of the Damned Sacrifice",
            [npcKeys.minLevel] = 59,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{58.4,67.4},{58.4,67.6},{58.6,67.4},{58.6,67.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232886] = {
            [npcKeys.name] = "Des'Altek",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232892] = {
            [npcKeys.name] = "[DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232896] = {
            [npcKeys.name] = "Ravenous Felhound",
            [npcKeys.minLevel] = 59,
            [npcKeys.maxLevel] = 59,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{51.4,54},{52.2,51},{52.4,52},{53,49.8},{53.2,51.2},{53.2,51.6},{53.2,53.2},{53.6,50},{53.8,51.4},{53.8,51.6},{54.2,53.4},{54.4,58.4},{54.8,51.6},{55,50.4},{55.4,44.4},{56.8,54.4},{59.8,51}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232899] = {
            [npcKeys.name] = "Large Fel Rift",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{31.6,30.4},{31.8,30.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232900] = {
            [npcKeys.name] = "Cursed Mage",
            [npcKeys.minLevel] = 55,
            [npcKeys.maxLevel] = 56,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{31.6,30.4},{31.8,30.6},{32.6,31}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232903] = {
            [npcKeys.name] = "Shadowmage",
            [npcKeys.minLevel] = 59,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{53,51},{53,51.8},{53.2,50.4},{53.4,52.6},{53.8,51.6},{54,51.4},{54,52.6},{54.4,50.4},{55,52.4},{55.4,53.6},{55.6,52}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232912] = {
            [npcKeys.name] = "Ada Darkhardt",
            [npcKeys.minLevel] = 55,
            [npcKeys.maxLevel] = 55,
            [npcKeys.zoneID] = 28,
            [npcKeys.spawns] = {
                [28] = {{69.4,79.4},{69.4,79.6},{69.6,79.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232920] = {
            [npcKeys.name] = "Uther",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 28,
            [npcKeys.spawns] = {
                [28] = {{46.8,69.8},{47,69.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232921] = {
            [npcKeys.name] = "Spawn of Shadra",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232922] = {
            [npcKeys.name] = "Aeonas",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 28,
            [npcKeys.spawns] = {
                [28] = {{46.8,69.8},{47,69.4},{48,71.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232923] = {
            [npcKeys.name] = "[DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232924] = {
            [npcKeys.name] = "Doan Karhan",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{84.8,70.4},{84.8,70.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {85506},
            [npcKeys.questEnds] = {85506},
        },
        [232926] = {
            [npcKeys.name] = "Frigid Wisp",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232928] = {
            [npcKeys.name] = "Fallen Leaf Shambler",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232929] = {
            [npcKeys.name] = "Gregory",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{53.4,83.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {85063,85064},
            [npcKeys.questEnds] = {85063,85458},
        },
        [232930] = {
            [npcKeys.name] = "Force of Nature",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 15938,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232931] = {
            [npcKeys.name] = "Poisoned Sprig",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15938,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232932] = {
            [npcKeys.name] = "Gregory",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 28,
            [npcKeys.spawns] = {
                [28] = {{39.4,67.2},{39.6,67.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {85065,85067,85091},
            [npcKeys.questEnds] = {85064,85066,85067,85090},
        },
        [232936] = {
            [npcKeys.name] = "Sprig of Growth",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15938,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232937] = {
            [npcKeys.name] = "Sprig of Restoration",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15938,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232938] = {
            [npcKeys.name] = "Sprig of Healing",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15938,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232939] = {
            [npcKeys.name] = "Felguard Elite",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{53.2,83.2},{53.2,83.8},{53.6,85}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232940] = {
            [npcKeys.name] = "Felhound Spellseeker",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{53.2,83.4},{53.2,83.8},{53.6,84.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232942] = {
            [npcKeys.name] = "Hulking Doomguard",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{53.2,83.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232943] = {
            [npcKeys.name] = "Diathorus the Seeker",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{53.2,83.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232944] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232945] = {
            [npcKeys.name] = "Azgaloth",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{53.2,83.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232946] = {
            [npcKeys.name] = "[DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232947] = {
            [npcKeys.name] = "Aeonas",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232959] = {
            [npcKeys.name] = "Servant of Caius",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232960] = {
            [npcKeys.name] = "Aeonas",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {85074},
            [npcKeys.questEnds] = {85068},
        },
        [232961] = {
            [npcKeys.name] = "[DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232993] = {
            [npcKeys.name] = "[DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232994] = {
            [npcKeys.name] = "Burning Blade Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232995] = {
            [npcKeys.name] = "Ada Darkhardt",
            [npcKeys.minLevel] = 55,
            [npcKeys.maxLevel] = 55,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{53.2,83.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232996] = {
            [npcKeys.name] = "Chromie",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232997] = {
            [npcKeys.name] = "Aeonas",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [232998] = {
            [npcKeys.name] = "Aeonas",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {85087},
            [npcKeys.questEnds] = {85074},
        },
        [233017] = {
            [npcKeys.name] = "Bearthold",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233027] = {
            [npcKeys.name] = "Bearthold",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 490,
            [npcKeys.spawns] = {
                [490] = {{22.4,33},{23.4,32.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233029] = {
            [npcKeys.name] = "Roary",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 490,
            [npcKeys.spawns] = {
                [490] = {{22.4,32.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233031] = {
            [npcKeys.name] = "Anne Tenna",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 490,
            [npcKeys.spawns] = {
                [490] = {{22.4,33.2},{22.8,33.6},{23.4,32.2},{23.4,33.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233033] = {
            [npcKeys.name] = "Rotgut",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233047] = {
            [npcKeys.name] = "Andorhal Resident",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233048] = {
            [npcKeys.name] = "Shambling Dead",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233049] = {
            [npcKeys.name] = "Searing Ghoul",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 59,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233084] = {
            [npcKeys.name] = "Estelenn",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 490,
            [npcKeys.spawns] = {
                [490] = {{23.4,33.2},{23.6,33.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {85251,85559},
            [npcKeys.questEnds] = {85250,85251},
        },
        [233087] = {
            [npcKeys.name] = "T2 Alt",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233093] = {
            [npcKeys.name] = "Magma Elemental",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{37.4,30.8},{38,29.4},{38,29.6},{38,32.4},{38.2,32.6},{38.4,31.4},{38.6,30.6},{38.6,32.2},{38.8,27.4},{39,28},{39,30},{39.6,28.8},{40,30.8},{40.2,30.4},{43.8,32.4},{45.6,34.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233138] = {
            [npcKeys.name] = "Aeonas",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {85090},
            [npcKeys.questEnds] = {85087},
        },
        [233158] = {
            [npcKeys.name] = "Azgaloth",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233159] = {
            [npcKeys.name] = "Gregory",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233165] = {
            [npcKeys.name] = "Gregory",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233175] = {
            [npcKeys.name] = "Invisible Bunny",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233178] = {
            [npcKeys.name] = "Duke Hydraxis",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233206] = {
            [npcKeys.name] = "Aeonas",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233234] = {
            [npcKeys.name] = "Chained Spirit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 11,
            [npcKeys.spawns] = {
                [11] = {{74.8,72.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233246] = {
            [npcKeys.name] = "Breath Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233249] = {
            [npcKeys.name] = "Estelenn",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 490,
            [npcKeys.spawns] = {
                [490] = {{21.4,36.8},{22.2,35.4},{22.2,35.6},{23.4,33.4},{23.4,33.6},{23.6,33.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233264] = {
            [npcKeys.name] = "Red Whelp",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 11,
            [npcKeys.spawns] = {
                [11] = {{73.6,68.2},{73.8,68.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233308] = {
            [npcKeys.name] = "Undermine Coin",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233315] = {
            [npcKeys.name] = "Beldruk Doombrow",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 796,
            [npcKeys.spawns] = {
                [796] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233335] = {
            [npcKeys.name] = "Rune Broker",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{29.4,72},{29.6,72}},
                [12] = {{48,41.4},{48.2,41.6}},
                [141] = {{58.8,43.8}},
                [1519] = {{57.4,26.8},{57.6,27}},
                [1537] = {{53.8,13.2},{53.8,13.6}},
                [1657] = {{28.4,39},{28.6,39}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233382] = {
            [npcKeys.name] = "Korialstrasz",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 11,
            [npcKeys.spawns] = {
                [11] = {{74.2,70.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233383] = {
            [npcKeys.name] = "DNT",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233414] = {
            [npcKeys.name] = "The Cleaner",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233428] = {
            [npcKeys.name] = "Rune Broker",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{42.8,68}},
                [85] = {{31.4,66.4}},
                [215] = {{44.4,76.6}},
                [1497] = {{79.4,19.8}},
                [1637] = {{49.2,46.8},{49.4,46.2},{49.6,46.2}},
                [1638] = {{22.6,12.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233574] = {
            [npcKeys.name] = "Bronze Whelp",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233575] = {
            [npcKeys.name] = "Aeonas",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15828,
            [npcKeys.spawns] = {
                [15828] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [233776] = {
            [npcKeys.name] = "Gregory",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 15475,
            [npcKeys.spawns] = {
                [15475] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {85092},
            [npcKeys.questEnds] = {85091,85092},
        },
        [233988] = {
            [npcKeys.name] = "Moonkin",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234193] = {
            [npcKeys.name] = "Gilded Scarab",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 3428,
            [npcKeys.spawns] = {
                [3428] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234218] = {
            [npcKeys.name] = "Invisible Bunny",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234472] = {
            [npcKeys.name] = "Argent Squire",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234539] = {
            [npcKeys.name] = "Selestrasza",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 3428,
            [npcKeys.spawns] = {
                [3428] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {86326},
            [npcKeys.questEnds] = {86326},
        },
        [234542] = {
            [npcKeys.name] = "Twilight Qiraji Battle Tank",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 2,
            [npcKeys.zoneID] = 3428,
            [npcKeys.spawns] = {
                [3428] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234543] = {
            [npcKeys.name] = "Orange Qiraji Battle Tank",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 2,
            [npcKeys.zoneID] = 3428,
            [npcKeys.spawns] = {
                [3428] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234544] = {
            [npcKeys.name] = "Light Green Qiraji Battle Tank",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 2,
            [npcKeys.zoneID] = 3428,
            [npcKeys.spawns] = {
                [3428] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234545] = {
            [npcKeys.name] = "Light Blue Qiraji Battle Tank",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 2,
            [npcKeys.zoneID] = 3428,
            [npcKeys.spawns] = {
                [3428] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234546] = {
            [npcKeys.name] = "Dark Blue Qiraji Battle Tank",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 2,
            [npcKeys.zoneID] = 3428,
            [npcKeys.spawns] = {
                [3428] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234577] = {
            [npcKeys.name] = "Ancient of War",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234651] = {
            [npcKeys.name] = "Tamed Silithid Tank",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234752] = {
            [npcKeys.name] = "Visions of the Qiraji Prophets",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234755] = {
            [npcKeys.name] = "Qiraji Mindslayer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234762] = {
            [npcKeys.name] = "Qiraji Mindslayer",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 3428,
            [npcKeys.spawns] = {
                [3428] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234794] = {
            [npcKeys.name] = "STV PvP P6",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234798] = {
            [npcKeys.name] = "Qiraji Champion",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 3428,
            [npcKeys.spawns] = {
                [3428] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234800] = {
            [npcKeys.name] = "Qiraji Slayer",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 3428,
            [npcKeys.spawns] = {
                [3428] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234814] = {
            [npcKeys.name] = "Qiraji Warlord",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 3428,
            [npcKeys.spawns] = {
                [3428] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234830] = {
            [npcKeys.name] = "Anubisath Defender",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 3428,
            [npcKeys.spawns] = {
                [3428] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234880] = {
            [npcKeys.name] = "Emeriss",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234917] = {
            [npcKeys.name] = "Guise of the False Prophet",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234954] = {
            [npcKeys.name] = "Alliance Druid",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234961] = {
            [npcKeys.name] = "Alliance Hunter",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234963] = {
            [npcKeys.name] = "Alliance Mage",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234969] = {
            [npcKeys.name] = "Alliance Paladin",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234973] = {
            [npcKeys.name] = "Alliance Priest",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234979] = {
            [npcKeys.name] = "Test MC",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234987] = {
            [npcKeys.name] = "Alliance Rogue",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234990] = {
            [npcKeys.name] = "Alliance Warlock",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [234996] = {
            [npcKeys.name] = "Alliance Warrior",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235008] = {
            [npcKeys.name] = "Horde Shaman",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235042] = {
            [npcKeys.name] = "Horde Warrior",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235043] = {
            [npcKeys.name] = "Horde Warlock",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235044] = {
            [npcKeys.name] = "Horde Rogue",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235047] = {
            [npcKeys.name] = "Horde Priest",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235048] = {
            [npcKeys.name] = "Horde Mage",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235049] = {
            [npcKeys.name] = "Horde Hunter",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235050] = {
            [npcKeys.name] = "Horde Druid",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16119,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235164] = {
            [npcKeys.name] = "G00 DV-1B3 Generator",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 3428,
            [npcKeys.spawns] = {
                [3428] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235180] = {
            [npcKeys.name] = "Lethon",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16018,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235197] = {
            [npcKeys.name] = "Taerar",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16169,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235207] = {
            [npcKeys.name] = "Unyielding Shade of Taerar",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16169,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235208] = {
            [npcKeys.name] = "Wandering Shade of Taerar",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16169,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235209] = {
            [npcKeys.name] = "Corrosive Shade of Taerar",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16169,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235232] = {
            [npcKeys.name] = "Ysondre",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16029,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235251] = {
            [npcKeys.name] = "Bubbles",
            [npcKeys.minLevel] = 38,
            [npcKeys.maxLevel] = 38,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{28.4,75.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235277] = {
            [npcKeys.name] = "T2.5",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235282] = {
            [npcKeys.name] = "AQ Small Set",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235284] = {
            [npcKeys.name] = "AQ Crafted",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235285] = {
            [npcKeys.name] = "AQ Big",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235286] = {
            [npcKeys.name] = "AQ Small",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235287] = {
            [npcKeys.name] = "DMF P6",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235288] = {
            [npcKeys.name] = "Brood Rings",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235289] = {
            [npcKeys.name] = "Dragons of Nightmare",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235291] = {
            [npcKeys.name] = "Vanquished Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235325] = {
            [npcKeys.name] = "Fathom Dweller",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235326] = {
            [npcKeys.name] = "Swift Spectral Tiger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235327] = {
            [npcKeys.name] = "Drakonid",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235328] = {
            [npcKeys.name] = "Furbolg Form",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235396] = {
            [npcKeys.name] = "Fleuric",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 41,
            [npcKeys.spawns] = {
                [41] = {{48.8,67.4},{48.8,67.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235406] = {
            [npcKeys.name] = "Xalus Nihilus",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16114,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235528] = {
            [npcKeys.name] = "Eye Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235668] = {
            [npcKeys.name] = "Eye Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235729] = {
            [npcKeys.name] = "Treasure Table Test [DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235761] = {
            [npcKeys.name] = "Rank 14",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235762] = {
            [npcKeys.name] = "P6 Undermine Coin",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235786] = {
            [npcKeys.name] = "P6 Quest Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235880] = {
            [npcKeys.name] = "Blood-Caked Raptor",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235881] = {
            [npcKeys.name] = "Blood-Caked Tiger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [235910] = {
            [npcKeys.name] = "AQ Recipes",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [236007] = {
            [npcKeys.name] = "Spirit Shade",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16018,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [236008] = {
            [npcKeys.name] = "Spirit Shade",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16018,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [236030] = {
            [npcKeys.name] = "Runes - Warrior [DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [236034] = {
            [npcKeys.name] = "Shadowy Figure",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [236075] = {
            [npcKeys.name] = "[DNT] Purveyor of Madness",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [236077] = {
            [npcKeys.name] = "Eye Tentacle",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 3428,
            [npcKeys.spawns] = {
                [3428] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [236173] = {
            [npcKeys.name] = "Curse of Madness",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [236619] = {
            [npcKeys.name] = "Void-Touched",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [236633] = {
            [npcKeys.name] = "Shadowy Figure",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [236811] = {
            [npcKeys.name] = "Demented Druid Spirit",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16029,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [236869] = {
            [npcKeys.name] = "Makrinni Razorclaw",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [236971] = {
            [npcKeys.name] = "Skeletal Torch",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [236979] = {
            [npcKeys.name] = "Floating Firebrand",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237196] = {
            [npcKeys.name] = "Runes - Druid [DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237246] = {
            [npcKeys.name] = "(DNT) Mimic Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237328] = {
            [npcKeys.name] = "Dialogues of the Dead",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237365] = {
            [npcKeys.name] = "(DNT) Book Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237374] = {
            [npcKeys.name] = "Kharon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237410] = {
            [npcKeys.name] = "(DNT) Light Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237434] = {
            [npcKeys.name] = "(DNT) Kharon Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237439] = {
            [npcKeys.name] = "Kharon",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237460] = {
            [npcKeys.name] = "Furious Firebrand",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237604] = {
            [npcKeys.name] = "(DNT) Torch Manager Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237657] = {
            [npcKeys.name] = "Glacial Fetters",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237752] = {
            [npcKeys.name] = "(DNT) Affix Manager Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237754] = {
            [npcKeys.name] = "Egg Sac",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237757] = {
            [npcKeys.name] = "Skittering Harvester",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237768] = {
            [npcKeys.name] = "(DNT) Buff Manager Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237773] = {
            [npcKeys.name] = "Scarlet Inquisitor Caldoran",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237818] = {
            [npcKeys.name] = "Harrison Jones",
            [npcKeys.minLevel] = 55,
            [npcKeys.maxLevel] = 55,
            [npcKeys.zoneID] = 41,
            [npcKeys.spawns] = {
                [41] = {{52.2,34.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {86968,86971},
            [npcKeys.questEnds] = {86967,86971,86972},
        },
        [237819] = {
            [npcKeys.name] = "Injured Adventurer",
            [npcKeys.minLevel] = 55,
            [npcKeys.maxLevel] = 55,
            [npcKeys.zoneID] = 41,
            [npcKeys.spawns] = {
                [41] = {{65.2,78.4},{65.2,78.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {86967},
            [npcKeys.questEnds] = {86966},
        },
        [237820] = {
            [npcKeys.name] = "Deceased Adventurer",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 41,
            [npcKeys.spawns] = {
                [41] = {{40,74.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {86965},
            [npcKeys.questEnds] = {86964},
        },
        [237821] = {
            [npcKeys.name] = "Cave KC Creature",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237823] = {
            [npcKeys.name] = "Camp KC Creature",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237824] = {
            [npcKeys.name] = "Crypt KC Creature",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237957] = {
            [npcKeys.name] = "Archmage Kir-Moldir",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237961] = {
            [npcKeys.name] = "Invisible Light",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237964] = {
            [npcKeys.name] = "Harbinger of Sin",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237969] = {
            [npcKeys.name] = "Subjugated Spinners",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [237994] = {
            [npcKeys.name] = "Pulverized Corpse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238018] = {
            [npcKeys.name] = "Bolstering Mushroom",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238024] = {
            [npcKeys.name] = "Creeping Malison",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238055] = {
            [npcKeys.name] = "Dark Rider",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238080] = {
            [npcKeys.name] = "(DNT) Ice Floor Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238100] = {
            [npcKeys.name] = "Blizzard",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238111] = {
            [npcKeys.name] = "Floating Firebrand",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238160] = {
            [npcKeys.name] = "T3",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238161] = {
            [npcKeys.name] = "T3 Tokens",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238191] = {
            [npcKeys.name] = "Risen Warrior",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238192] = {
            [npcKeys.name] = "Risen Warder",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238193] = {
            [npcKeys.name] = "Risen Protector",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238200] = {
            [npcKeys.name] = "Crypt Ghoul",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238206] = {
            [npcKeys.name] = "Diseased Ghoul",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238208] = {
            [npcKeys.name] = "Ragged Ghoul",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238211] = {
            [npcKeys.name] = "Risen Guard",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238213] = {
            [npcKeys.name] = "Sairuh Maryla",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238233] = {
            [npcKeys.name] = "Kaigy Maryla",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238234] = {
            [npcKeys.name] = "Barian Maryla",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238244] = {
            [npcKeys.name] = "Cellar Spider",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238245] = {
            [npcKeys.name] = "Crypt Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238251] = {
            [npcKeys.name] = "Risen Bones",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238252] = {
            [npcKeys.name] = "Trapped Soul",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238253] = {
            [npcKeys.name] = "Sinful Captive",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238261] = {
            [npcKeys.name] = "Argent Guard",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238262] = {
            [npcKeys.name] = "Cook",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238263] = {
            [npcKeys.name] = "Shoulder Enchant",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238264] = {
            [npcKeys.name] = "Seal of the Dawn",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238270] = {
            [npcKeys.name] = "Encrypted Text",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238286] = {
            [npcKeys.name] = "Scarlet Crusader",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238292] = {
            [npcKeys.name] = "Formula: Enchant Off-hand - Superior Intellect",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238303] = {
            [npcKeys.name] = "Formula: Enchant Off-hand - Excellent Spirit",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238304] = {
            [npcKeys.name] = "Formula: Enchant Off-hand - Wisdom",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238305] = {
            [npcKeys.name] = "Formula: Enchant 2H Weapon - Spellblasting",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238306] = {
            [npcKeys.name] = "Formula: Enchant Shield - Excellent Stamina",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238307] = {
            [npcKeys.name] = "Formula: Enchant Shield - Critical Strike",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238308] = {
            [npcKeys.name] = "Formula: Enchant Bracer - Greater Spellpower",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238309] = {
            [npcKeys.name] = "Formula: Enchant Gloves - Superior Strength",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238310] = {
            [npcKeys.name] = "Formula: Enchant Cloak - Agility",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238311] = {
            [npcKeys.name] = "The Lich King",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238324] = {
            [npcKeys.name] = "Ghoul",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238325] = {
            [npcKeys.name] = "Skeleton",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238326] = {
            [npcKeys.name] = "Human",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238327] = {
            [npcKeys.name] = "Troll",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238328] = {
            [npcKeys.name] = "Bone Golem",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238329] = {
            [npcKeys.name] = "War",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238330] = {
            [npcKeys.name] = "Conquest",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238331] = {
            [npcKeys.name] = "Death",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238332] = {
            [npcKeys.name] = "Famine",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238355] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238356] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238365] = {
            [npcKeys.name] = "Dark Rider",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238374] = {
            [npcKeys.name] = "reuseme",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238376] = {
            [npcKeys.name] = "Brother Luctus",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 46,
            [npcKeys.spawns] = {
                [46] = {{65.4,55.2}},
                [139] = {{80.4,65.4},{80.4,65.6},{80.6,65.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {87377,88713,88714,88715,88716,88717,88718},
            [npcKeys.questEnds] = {87361,87377,88713,88714,88715,88716,88717,88718},
        },
        [238382] = {
            [npcKeys.name] = "Kug Softjaw",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {87362,87364,87365,87366,87367,87368,87369},
            [npcKeys.questEnds] = {87362,87364,87365,87366,87367,87368,87369},
        },
        [238407] = {
            [npcKeys.name] = "Sairuh Maryla",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238415] = {
            [npcKeys.name] = "Grok'lo Mok'lo",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 8,
            [npcKeys.spawns] = {
                [8] = {{34.4,65.8}},
                [16] = {{32.2,54.6}},
                [46] = {{65.4,55.2}},
                [139] = {{80.4,65.4},{80.6,65.2}},
                [440] = {{54.4,28.4}},
                [618] = {{58.2,36}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238416] = {
            [npcKeys.name] = "Geenkle",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238417] = {
            [npcKeys.name] = "Beengis",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238418] = {
            [npcKeys.name] = "Jank",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238419] = {
            [npcKeys.name] = "Gold Rustboot",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238420] = {
            [npcKeys.name] = "Weeshald Rustboot",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238421] = {
            [npcKeys.name] = "Fimick Buzzkettle",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238422] = {
            [npcKeys.name] = "Hans",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238423] = {
            [npcKeys.name] = "Greta",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238424] = {
            [npcKeys.name] = "Grandma Finette",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238425] = {
            [npcKeys.name] = "Annie",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238426] = {
            [npcKeys.name] = "Steele",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238427] = {
            [npcKeys.name] = "Flora",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238428] = {
            [npcKeys.name] = "Trizivast",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238429] = {
            [npcKeys.name] = "Annabel",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238430] = {
            [npcKeys.name] = "Floating Firebrand",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 41,
            [npcKeys.spawns] = {
                [41] = {{40.2,74.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238431] = {
            [npcKeys.name] = "Enthusiastic Wisp",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{52.2,90.4},{52.2,90.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238432] = {
            [npcKeys.name] = "Scarlet Clothier",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238433] = {
            [npcKeys.name] = "Commander Beatrix",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238434] = {
            [npcKeys.name] = "Scarlet Strategist",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238435] = {
            [npcKeys.name] = "Scarlet Tactician",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238436] = {
            [npcKeys.name] = "Argent Guard",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238437] = {
            [npcKeys.name] = "Argent Medic",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238438] = {
            [npcKeys.name] = "Argent Medic",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238439] = {
            [npcKeys.name] = "(DNT) Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238440] = {
            [npcKeys.name] = "Injured Soldier",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238441] = {
            [npcKeys.name] = "Injured Soldier",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238442] = {
            [npcKeys.name] = "Scarlet Medic",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238443] = {
            [npcKeys.name] = "Torment's Illusion",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238444] = {
            [npcKeys.name] = "Invisible Wisp",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238445] = {
            [npcKeys.name] = "S03 - Naxxramas Raid - Difficulty - Kel'Thuzad - Area Trigger Spawner",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238447] = {
            [npcKeys.name] = "Rotting Ghoul",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238448] = {
            [npcKeys.name] = "Skeletal Warrior",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238449] = {
            [npcKeys.name] = "Abomination",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238450] = {
            [npcKeys.name] = "Crypt Fiend",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238451] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238452] = {
            [npcKeys.name] = "Argent Guard",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238453] = {
            [npcKeys.name] = "Scarlet Crusader",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238454] = {
            [npcKeys.name] = "Argent Guard",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238455] = {
            [npcKeys.name] = "Argent Guard",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 58,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238456] = {
            [npcKeys.name] = "Injured Soldier",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238457] = {
            [npcKeys.name] = "Scarlet Crusader",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238458] = {
            [npcKeys.name] = "Scarlet Crusader",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 3456,
            [npcKeys.spawns] = {
                [3456] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238459] = {
            [npcKeys.name] = "\"Tableknife\" Finkelbat",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238460] = {
            [npcKeys.name] = "Alfwhit Grigdert",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238461] = {
            [npcKeys.name] = "Wis",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238477] = {
            [npcKeys.name] = "Edgar",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238493] = {
            [npcKeys.name] = "(DNT) Spooky Eyes",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238499] = {
            [npcKeys.name] = "Dark Rider",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238503] = {
            [npcKeys.name] = "Chandelier",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238508] = {
            [npcKeys.name] = "Abandoned Acolyte",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238509] = {
            [npcKeys.name] = "Lost Neophyte",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238511] = {
            [npcKeys.name] = "The Gravekeeper",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238512] = {
            [npcKeys.name] = "Torch",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238526] = {
            [npcKeys.name] = "Ravaged Cadaver",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238527] = {
            [npcKeys.name] = "Mangled Cadaver",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238528] = {
            [npcKeys.name] = "Ragged Ghoul",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238543] = {
            [npcKeys.name] = "(DNT) Test",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238556] = {
            [npcKeys.name] = "Cursed Spiderling",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238558] = {
            [npcKeys.name] = "Spider Spawner",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238559] = {
            [npcKeys.name] = "Crypt Dweller",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238560] = {
            [npcKeys.name] = "The Warden",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238561] = {
            [npcKeys.name] = "Crypt Terror",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238562] = {
            [npcKeys.name] = "Bone Witch",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238563] = {
            [npcKeys.name] = "Crypt Soldier",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238589] = {
            [npcKeys.name] = "Spider Nest",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238593] = {
            [npcKeys.name] = "Atiesh Vendor",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238594] = {
            [npcKeys.name] = "Naxxramas Mounts",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238595] = {
            [npcKeys.name] = "[DNT] Death Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238597] = {
            [npcKeys.name] = "(DNT) Medivh",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238598] = {
            [npcKeys.name] = "Ghostly Spectator",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238599] = {
            [npcKeys.name] = "(DNT) Murder Hole Guy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238619] = {
            [npcKeys.name] = "Enchanted Flare [DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238620] = {
            [npcKeys.name] = "Roach",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238627] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238628] = {
            [npcKeys.name] = "Broodwidow",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238629] = {
            [npcKeys.name] = "Deep Stalker",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238630] = {
            [npcKeys.name] = "Skeleton",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238638] = {
            [npcKeys.name] = "Echo of the Baroness",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238639] = {
            [npcKeys.name] = "Wailing Banshee",
            [npcKeys.minLevel] = 59,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238640] = {
            [npcKeys.name] = "Shrieking Banshee",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238641] = {
            [npcKeys.name] = "Karazhan Shadowcaster",
            [npcKeys.minLevel] = 59,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238642] = {
            [npcKeys.name] = "Lost Necromancer",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238643] = {
            [npcKeys.name] = "Forgotten Denizen",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238644] = {
            [npcKeys.name] = "Unrepentant Criminal",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238645] = {
            [npcKeys.name] = "Unrepentant Sorcerer",
            [npcKeys.minLevel] = 59,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238646] = {
            [npcKeys.name] = "Unrepentant Conjuror",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238647] = {
            [npcKeys.name] = "Failed Novice",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238648] = {
            [npcKeys.name] = "Shrieking Banshee",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238649] = {
            [npcKeys.name] = "[DNT] Magical Broom",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238650] = {
            [npcKeys.name] = "Forgotten Student",
            [npcKeys.minLevel] = 58,
            [npcKeys.maxLevel] = 59,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238654] = {
            [npcKeys.name] = "Military Orb",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238656] = {
            [npcKeys.name] = "Crypt Dweller",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238657] = {
            [npcKeys.name] = "Crypt Dweller",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238658] = {
            [npcKeys.name] = "[DNT] No Name",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238659] = {
            [npcKeys.name] = "[DNT] No Name",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238660] = {
            [npcKeys.name] = "[DNT] No Name",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238666] = {
            [npcKeys.name] = "(DNT) Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238678] = {
            [npcKeys.name] = "Unk'omon",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238679] = {
            [npcKeys.name] = "Fallen Praetorian",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238680] = {
            [npcKeys.name] = "Mysterious Eidolon",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238681] = {
            [npcKeys.name] = "Mysterious Eidolon",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238682] = {
            [npcKeys.name] = "Mysterious Eidolon",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238715] = {
            [npcKeys.name] = "New Avalon Refugee",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{67.4,83.6},{67.6,82.4},{67.8,82.8},{68,84}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238716] = {
            [npcKeys.name] = "New Avalon Refugee",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238725] = {
            [npcKeys.name] = "Ghostly Spectator",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238734] = {
            [npcKeys.name] = "Treasure Chest",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238737] = {
            [npcKeys.name] = "Burning Web",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238745] = {
            [npcKeys.name] = "Scarlet Infiltrator",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{81.8,58}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238761] = {
            [npcKeys.name] = "Pile of Meat",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238766] = {
            [npcKeys.name] = "Withering Iris",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238767] = {
            [npcKeys.name] = "Immense Rock",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238892] = {
            [npcKeys.name] = "[DNT] Ethereal Charge Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238941] = {
            [npcKeys.name] = "Spider",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238942] = {
            [npcKeys.name] = "Black Rat",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238943] = {
            [npcKeys.name] = "Roach",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238954] = {
            [npcKeys.name] = "Solistrasza",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238985] = {
            [npcKeys.name] = "Hans",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238986] = {
            [npcKeys.name] = "Greta",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [238992] = {
            [npcKeys.name] = "Grandma Finette",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239031] = {
            [npcKeys.name] = "Scarlet Inquisitor Caldoran",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{68.2,82.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {87502,87506},
            [npcKeys.questEnds] = {87502},
        },
        [239032] = {
            [npcKeys.name] = "Commander Beatrix",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{67.8,83.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {87497,87516},
            [npcKeys.questEnds] = {87493,87498,87506,87509},
        },
        [239036] = {
            [npcKeys.name] = "Scarlet Crusader",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{66.2,82.6},{66.4,82},{66.8,81.6},{67,83.2},{67.4,80.8},{67.4,83.8},{67.6,80.4},{67.6,81.6},{67.6,83.8},{67.8,83.2},{68.2,81.4},{68.2,87.4},{68.2,87.6},{68.6,83},{68.8,86.6},{70.4,77.4},{70.4,78.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239042] = {
            [npcKeys.name] = "DNT",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239046] = {
            [npcKeys.name] = "Ghostly Spectator",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239047] = {
            [npcKeys.name] = "Scarlet Siege Commander",
            [npcKeys.minLevel] = 59,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{75,83.2},{76.8,81.6},{78,76.2},{78.2,80.6},{78.2,84.8},{78.4,78.8},{78.4,80.4},{78.4,81.6},{78.4,82.8},{78.6,84.8},{78.8,79},{79.2,79.8},{79.2,81},{79.4,82.2},{79.4,83.2},{79.4,83.6},{79.6,80.8},{79.6,83.4},{79.6,83.6},{79.6,85},{79.8,80.4},{80,85.6},{80.2,81.6},{81,80.4},{81.2,81},{81.2,81.6},{81.4,82.6},{81.6,81},{81.8,81.6},{82.2,85},{82.4,84.4},{82.8,82.6},{82.8,85.4},{83,85.6},{83.2,87},{83.4,81.8},{83.4,84.2},{83.6,85.4},{84,82.6},{84.2,81.4},{84.2,82},{84.4,84.2},{84.4,86},{84.4,86.8},{84.6,79},{84.6,81.2},{84.6,85.4},{84.6,86.2},{84.8,81.8},{84.8,84.2},{85.2,87.4},{85.4,82.8},{85.4,87.6},{85.6,83.6},{85.6,86.8},{85.8,87.6},{86.2,82.8},{86.4,80.4},{86.4,81.4},{86.4,81.6},{86.6,81.4},{86.8,87.2},{87,82.2},{87.2,83},{87.4,83.6},{87.6,83},{87.8,82},{88.2,81.4},{88.2,84.4},{90.4,82.8},{90.4,84.8},{90.6,82.8},{90.6,84.8},{92.8,78.2},{92.8,78.6},{94.4,78.2},{95.4,77.8},{95.6,77.4},{95.6,77.6},{97.4,76.4},{97.4,76.6},{97.6,76.4},{97.6,76.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239048] = {
            [npcKeys.name] = "DNT",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239050] = {
            [npcKeys.name] = "(DNT) Plague Goo Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239054] = {
            [npcKeys.name] = "Argent Emissary",
            [npcKeys.minLevel] = 55,
            [npcKeys.maxLevel] = 55,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{67.8,83.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {87508},
            [npcKeys.questEnds] = nil,
        },
        [239127] = {
            [npcKeys.name] = "(DNT) Scarlet Caravan",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239130] = {
            [npcKeys.name] = "(DNT) Scarlet Caravan",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239139] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239146] = {
            [npcKeys.name] = "Incendiary Orb",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239151] = {
            [npcKeys.name] = "Monument",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1377,
            [npcKeys.spawns] = {
                [1377] = {{17.6,89.4},{17.6,89.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239152] = {
            [npcKeys.name] = "DNT",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239153] = {
            [npcKeys.name] = "DNT",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239154] = {
            [npcKeys.name] = "DNT",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239187] = {
            [npcKeys.name] = "Gregory",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239189] = {
            [npcKeys.name] = "Teo Hammerstorm",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239328] = {
            [npcKeys.name] = "Burning Ghoul",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239329] = {
            [npcKeys.name] = "Tortured Student",
            [npcKeys.minLevel] = 59,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239334] = {
            [npcKeys.name] = "Deadwind Steed",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239335] = {
            [npcKeys.name] = "[DNT] Fire Summon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239336] = {
            [npcKeys.name] = "Molten Boulder",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239337] = {
            [npcKeys.name] = "Lord Maxwell Tyrosus",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {87517},
            [npcKeys.questEnds] = {87516,87517},
        },
        [239363] = {
            [npcKeys.name] = "Shadowy Firebrand",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239365] = {
            [npcKeys.name] = "Blighted Apparition",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239382] = {
            [npcKeys.name] = "Diseased Corpse",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16074,
            [npcKeys.spawns] = {
                [16074] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239386] = {
            [npcKeys.name] = "Loot Vendor",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239573] = {
            [npcKeys.name] = "Greta",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239640] = {
            [npcKeys.name] = "Naxxramas Gear",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239642] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239713] = {
            [npcKeys.name] = "Naxxramas Quest Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239714] = {
            [npcKeys.name] = "Naxxramas Crafted Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239715] = {
            [npcKeys.name] = "Scourge Invasion Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239719] = {
            [npcKeys.name] = "[DNT] Torch Toss Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239725] = {
            [npcKeys.name] = "[DNT] Disease Summon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [239982] = {
            [npcKeys.name] = "[DNT] Grasping Spirits",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240122] = {
            [npcKeys.name] = "S03 - Karazhan Crypts - Creeping Malison - Spider Nest (Glow)",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240246] = {
            [npcKeys.name] = "New Avalon Defender",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{91.4,86.4},{92.4,79.8},{92.4,81.2},{92.4,82.8},{92.6,79.4},{92.8,79.6},{93.2,81.6},{93.4,83},{93.4,89.4},{93.4,89.6},{93.6,79.4},{93.6,79.6},{93.6,89},{93.6,93.6},{93.8,89.6},{93.8,92.4},{94,80.8},{94,92.8},{94.4,81.6},{94.4,83.2},{94.4,83.6},{94.6,83.6},{94.8,91.2},{95.2,82.2},{95.2,82.6},{95.8,82.6},{95.8,83.8},{96.2,82.2},{97.4,79.4},{97.4,79.6},{97.6,79.4},{97.6,79.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240247] = {
            [npcKeys.name] = "Scarlet Bloodhound",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{86.2,82.6},{87.4,82.2},{87.6,81.8},{88.6,81.6},{89,81.2},{89.8,83.8},{90,85},{90.2,79.4},{90.2,85.8},{90.4,79.8},{90.4,81.4},{90.4,82},{90.4,82.8},{90.4,86.6},{90.6,78.6},{90.6,81.4},{90.6,82.2},{90.6,86.6},{90.8,80.4},{91,84.4},{91,84.8},{91.2,93.2},{91.2,93.6},{91.4,83.2},{91.4,88.4},{91.4,89.8},{91.6,79.8},{91.6,82.2},{91.6,83.4},{91.6,87},{91.8,81.4},{91.8,89.6},{92,85.2},{92,93},{92.2,89.2},{92.4,84.4},{92.4,91.2},{92.6,84.4},{92.6,85.6},{92.6,90.6},{92.6,92.8},{92.8,85.4},{92.8,88},{92.8,89.8},{93.2,81},{93.2,81.8},{93.2,87.4},{93.2,88.8},{93.4,78.4},{93.4,78.6},{93.4,83},{93.6,78.8},{93.8,81},{93.8,89.6},{94,78},{94.2,86},{94.2,89.2},{94.2,90.6},{94.4,79.6},{94.4,81.8},{94.4,83.4},{94.4,88.4},{94.4,92},{94.6,85},{94.6,86.6},{94.6,88.6},{94.6,92},{94.8,78.4},{94.8,78.8},{94.8,79.6},{94.8,90.6},{94.8,92.8},{95,80.8},{95,83},{95.2,86.2},{95.2,87.8},{95.4,81.6},{95.4,83.8},{95.4,89.8},{95.6,86.2},{95.8,85.4},{96,80.6},{96,83.6},{96,86.8},{96,88.2},{96,93.4},{96.2,76.8},{96.2,78.4},{96.2,78.8},{96.2,89.2},{96.4,80.4},{96.4,82.4},{96.4,83.2},{96.6,76.4},{96.6,77.4},{96.6,78},{96.6,80.4},{97,79.4},{97,82},{97,83},{97,84.8},{97,86.2},{97,88.6},{97.2,88.2},{97.4,80.8},{97.4,84},{97.4,87.2},{97.6,87.4},{97.6,91.4},{97.6,92.2},{97.8,90.4},{98,77.4},{98,77.6},{98,81.4},{98.2,81.8},{98.2,83.2},{98.2,85.2},{98.2,88.4},{98.4,84.2},{98.6,82.4},{98.8,80},{98.8,88.6},{99,81.2},{99,84},{99.2,77.4},{99.2,83.4},{99.4,91.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240248] = {
            [npcKeys.name] = "Bryon Steelblade",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{98.4,84},{98.6,84}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {89260},
            [npcKeys.questEnds] = {89260},
        },
        [240298] = {
            [npcKeys.name] = "[DNT] Wiggling Spider Egg",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240310] = {
            [npcKeys.name] = "Dark Rider",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240352] = {
            [npcKeys.name] = "Mana Elemental",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 41,
            [npcKeys.spawns] = {
                [41] = {{51.4,38.4},{51.6,37.8},{52,36.4},{52,36.6},{52.4,34.4},{52.4,34.6},{52.6,34.4},{52.6,34.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240568] = {
            [npcKeys.name] = "Haunted Anvil",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 41,
            [npcKeys.spawns] = {
                [41] = {{48.4,78},{48.6,78}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240604] = {
            [npcKeys.name] = "Carrie Hearthfire",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{95.2,78.4},{95.2,78.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {89224,89236,89245,89253,89341,90518,90520},
            [npcKeys.questEnds] = {89224,89236,89245,89253,89340,89341,90518,90519,90520},
        },
        [240607] = {
            [npcKeys.name] = "Devon Woods",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{95.2,80.2},{95.2,80.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {89342},
            [npcKeys.questEnds] = {89342},
        },
        [240609] = {
            [npcKeys.name] = "New Avalon Citizen",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{95.2,79},{95.2,79.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240631] = {
            [npcKeys.name] = "Taylor Stitchings",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{94.6,83.4},{94.6,83.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {90116,90120},
            [npcKeys.questEnds] = {90116,90120},
        },
        [240632] = {
            [npcKeys.name] = "Tanya Hyde",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{94.2,93.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240633] = {
            [npcKeys.name] = "Smith",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{98.4,77},{98.6,77}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240636] = {
            [npcKeys.name] = "Suspicious Soldier",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240639] = {
            [npcKeys.name] = "Peculiar Peddler",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240654] = {
            [npcKeys.name] = "Fizzlefuse",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {89463,89471,89485,89486,89487,89489,89491},
            [npcKeys.questEnds] = {89463,89471,89485,89486,89487,89489,89491},
        },
        [240779] = {
            [npcKeys.name] = "Scarlet Warder",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240780] = {
            [npcKeys.name] = "Scarlet Bloodhound",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240781] = {
            [npcKeys.name] = "Scarlet Praetorian",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240782] = {
            [npcKeys.name] = "Scarlet Cleric",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240783] = {
            [npcKeys.name] = "Scarlet Curate",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240784] = {
            [npcKeys.name] = "Scarlet Archmage",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240785] = {
            [npcKeys.name] = "Scarlet Alchemist",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240786] = {
            [npcKeys.name] = "Scarlet Medic",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240787] = {
            [npcKeys.name] = "Scarlet Priest",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240788] = {
            [npcKeys.name] = "Scarlet Spellbinder",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240789] = {
            [npcKeys.name] = "Scarlet Spellbreaker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240790] = {
            [npcKeys.name] = "Scarlet Lumberjack",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240791] = {
            [npcKeys.name] = "Scarlet Worker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240792] = {
            [npcKeys.name] = "Scarlet Smith",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240793] = {
            [npcKeys.name] = "Scarlet Soldier",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240794] = {
            [npcKeys.name] = "Alexei the Beastlord",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240795] = {
            [npcKeys.name] = "Herod",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240796] = {
            [npcKeys.name] = "Scarlet Cavalier",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240797] = {
            [npcKeys.name] = "Scarlet Executioner",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240798] = {
            [npcKeys.name] = "Scarlet Knight",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240799] = {
            [npcKeys.name] = "Scarlet Ranger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240800] = {
            [npcKeys.name] = "Scarlet Invoker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240801] = {
            [npcKeys.name] = "Scarlet Mage",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240802] = {
            [npcKeys.name] = "Scarlet Paladin",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240803] = {
            [npcKeys.name] = "Commander Granis Darkhammer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240804] = {
            [npcKeys.name] = "Inquisitor Tenn Flamecaster",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240805] = {
            [npcKeys.name] = "Captain Manadar",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240806] = {
            [npcKeys.name] = "Captain Buzan",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240807] = {
            [npcKeys.name] = "Captain Jorn",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240808] = {
            [npcKeys.name] = "Captain Karnwield",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240809] = {
            [npcKeys.name] = "Vishas",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240810] = {
            [npcKeys.name] = "Doan",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240811] = {
            [npcKeys.name] = "Balnazzar",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240812] = {
            [npcKeys.name] = "High Commander Beatrix",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240825] = {
            [npcKeys.name] = "Elysabeth Monalissier",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240978] = {
            [npcKeys.name] = "Apple",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{95.4,90.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [240998] = {
            [npcKeys.name] = "New Avalon Orchardist",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{90.2,92.6},{90.6,93.8},{91.4,93},{91.6,93.6},{91.6,94.8},{92,92.6},{92.2,90.2},{92.2,91.6},{92.6,92.2},{93,90.2},{93.2,93},{93.2,94.4},{93.8,92.8},{93.8,94.6},{94,88.6},{94,92.4},{94,94.2},{94.4,88.4},{94.6,93.8},{94.8,92},{95,86},{95.2,89.4},{95.2,91},{95.2,93.2},{95.4,89.8},{95.6,88},{95.6,89.6},{95.6,91},{95.8,89},{96,92.8},{96.2,91.6},{96.6,91},{96.6,91.6},{96.8,89.6},{97,86},{97,88.2},{97,89.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241006] = {
            [npcKeys.name] = "Grand Crusader Caldoran",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241019] = {
            [npcKeys.name] = "Johnny",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{94.8,91.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241021] = {
            [npcKeys.name] = "Mason the Echo",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241032] = {
            [npcKeys.name] = "Fish Barrel",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241048] = {
            [npcKeys.name] = "Scarlet Hunter",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241119] = {
            [npcKeys.name] = "New Avalon Watchman",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{85.6,82.6},{86.6,81.2},{87,82.2},{87.6,81.6},{88.4,81},{88.8,80.4},{89,81.4},{89,81.8},{89.6,81.6},{90,85.2},{90.2,81},{90.2,85.6},{90.6,81.6},{91,93.6},{91.2,80},{91.2,83},{91.2,84.2},{91.2,92},{91.2,93},{91.4,81.4},{91.4,84.8},{91.4,94.6},{91.6,80},{91.6,91.4},{91.6,92.8},{91.8,83},{91.8,85},{91.8,92.2},{92.2,85.8},{92.4,82.4},{92.4,84.4},{92.4,95},{92.6,84.6},{92.8,81.4},{92.8,83.8},{92.8,92.8},{93,78.2},{93,79},{93,79.8},{93,81.8},{93,83},{93,95.4},{93.6,83.8},{93.8,77.8},{93.8,79},{93.8,79.8},{93.8,92.6},{94.2,81.2},{94.2,81.6},{94.2,89.4},{94.2,92},{94.4,85.8},{94.6,79.4},{94.6,83.6},{94.6,86.6},{94.6,92.8},{94.8,80.2},{94.8,90.2},{94.8,90.6},{94.8,91.8},{95,77.4},{95,81.6},{95,82.8},{95,86.4},{95,88.2},{95.2,81.4},{95.4,89},{95.6,81},{95.6,85.4},{95.6,86.2},{95.8,89},{96,78.8},{96,79.8},{96,82.2},{96,86.6},{96.4,77},{96.4,78.2},{96.4,83.6},{96.6,78.6},{96.6,85.6},{96.8,76.6},{96.8,77.6},{97,80.2},{97,87.6},{97.4,82.4},{97.4,83.4},{97.4,84.2},{97.4,84.8},{97.4,93.2},{97.6,84.6},{97.8,85.8},{98,84.2},{98.2,83.2},{98.4,81.6},{98.6,82.4},{98.8,84.8},{98.8,86},{99,88.8},{99.2,83.4},{99.4,84.2},{99.4,97}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241120] = {
            [npcKeys.name] = "Scarlet Footman",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{84,83.2},{84.2,81.2},{84.8,85.2},{85,81.6},{85.2,80.6},{87,82.2},{87.8,82.2},{88.2,81.4},{88.4,85},{89,81.8},{89,82.6},{89,83.6},{89.4,79.4},{89.4,80},{89.4,81.4},{89.6,83.8},{89.6,85.6},{89.8,85.4},{90,79.4},{90.2,83.2},{90.2,93.4},{90.4,79.6},{90.4,81.4},{90.4,82},{90.4,92},{90.4,94.2},{90.4,94.6},{90.4,95.8},{90.6,81.4},{90.6,82},{90.8,79.4},{90.8,84.6},{91,83},{91,84.4},{91,86.4},{91,88.4},{91,93.4},{91.2,79.8},{91.2,87.4},{91.2,89.8},{91.2,92},{91.2,96.4},{91.4,78.4},{91.4,88.8},{91.4,91.2},{91.4,94.4},{91.4,94.6},{91.6,87.2},{91.6,92.8},{91.6,94.8},{91.8,79},{91.8,80.4},{91.8,80.6},{91.8,90.4},{91.8,92},{91.8,94},{92,86.2},{92,90.8},{92.2,78.4},{92.2,85.2},{92.2,88.4},{92.2,88.8},{92.2,95.6},{92.4,82.2},{92.4,82.6},{92.4,83.8},{92.6,84.6},{92.6,91},{92.6,91.8},{92.6,93.4},{92.8,78.2},{92.8,83.2},{93,86.2},{93,88.6},{93,89.6},{93.2,80},{93.2,81.4},{93.2,81.8},{93.2,83.8},{93.2,87},{93.2,88},{93.2,95.4},{93.2,96},{93.4,78.8},{93.6,78.4},{93.6,78.6},{93.6,85.6},{93.6,87},{93.8,82.6},{93.8,95},{94,79.6},{94,84.4},{94.2,85.4},{94.2,88.4},{94.4,81},{94.4,81.8},{94.4,88.6},{94.4,93.6},{94.6,79.4},{94.6,81.8},{94.6,82.8},{94.6,86.6},{94.8,78.2},{94.8,88.6},{94.8,93.6},{95,81},{95,88.2},{95,89.6},{95,91.4},{95,92.8},{95.2,80.2},{95.2,86.4},{95.2,92.4},{95.4,84},{95.4,84.6},{95.6,80.8},{95.6,81.8},{95.6,84.2},{95.6,84.8},{95.8,83.4},{95.8,86},{95.8,93},{96.2,77.2},{96.2,79.2},{96.2,86.8},{96.2,88},{96.2,89.4},{96.2,92.2},{96.4,78.4},{96.4,80.2},{96.6,77.6},{96.6,79.6},{96.6,91},{96.8,76.6},{97,76.4},{97,85},{97.2,79},{97.2,82},{97.2,85.8},{97.2,88.6},{97.4,81},{97.4,83.2},{97.4,84.2},{97.4,87.2},{97.4,87.8},{97.4,89.6},{97.6,80.4},{97.6,84.2},{97.6,84.6},{97.6,87.4},{97.8,85.8},{97.8,94},{98,81.4},{98,82.2},{98.2,83.2},{98.2,88},{98.6,80.4},{98.6,81.4},{98.6,85.4},{98.6,86.8},{98.8,89.2},{99,76.6},{99,83.4},{99.2,79.2},{99.2,84.2},{99.2,97.4},{99.2,97.6},{99.4,82.4},{99.4,86.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241121] = {
            [npcKeys.name] = "Scarlet Archer",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{89.8,94.6},{90.2,83.4},{90.2,83.6},{90.2,84.6},{90.2,85.6},{90.4,81},{90.4,82.4},{90.6,84.6},{90.6,87.6},{90.8,80.6},{90.8,83.2},{90.8,84.4},{90.8,93},{90.8,93.6},{91,79.2},{91,95.2},{91,95.8},{91.2,78.2},{91.4,79.8},{91.4,82.2},{91.4,86.2},{91.4,87.2},{91.4,88.8},{91.4,91.2},{91.4,91.8},{91.6,91.2},{91.6,91.6},{91.6,94},{91.8,80.4},{91.8,80.6},{91.8,82.4},{91.8,82.8},{91.8,85.2},{91.8,85.6},{91.8,87.2},{91.8,88.4},{91.8,90.4},{92,88.6},{92,93},{92,95.6},{92.2,79.2},{92.2,94.6},{92.4,78.2},{92.4,84.4},{92.6,78.6},{92.6,84.4},{92.6,85.2},{92.6,89},{92.8,78.2},{92.8,83.2},{92.8,86.2},{93,82.2},{93,86.8},{93.2,80.2},{93.2,88},{93.2,89.6},{93.4,80.6},{93.6,78},{93.6,87},{93.6,89.6},{93.8,80},{93.8,82.4},{93.8,82.6},{93.8,94.4},{93.8,94.6},{94,84.4},{94,92.8},{94.2,88.4},{94.4,79.2},{94.4,80.8},{94.4,84.8},{94.4,86.4},{94.4,88.6},{94.6,80.4},{94.6,82.6},{94.6,88.8},{94.6,93.8},{95,77.8},{95,84},{95,84.8},{95.2,81.4},{95.2,86.4},{95.2,88},{95.2,92.2},{95.2,92.8},{95.4,77.2},{95.4,78.6},{95.4,81.8},{95.4,87},{95.6,84.4},{95.6,87},{95.8,79.6},{95.8,82.2},{95.8,86.2},{96,80.6},{96,88.8},{96,89.8},{96,92},{96.2,77.4},{96.2,77.6},{96.2,79},{96.2,82.8},{96.2,87.6},{96.4,85},{96.6,79.6},{96.6,84.8},{96.8,77.8},{96.8,82.4},{96.8,88.6},{97,81.2},{97,83.4},{97,86.2},{97.2,84.4},{97.2,90.2},{97.4,79},{97.4,87.4},{97.4,87.8},{97.4,93.6},{97.6,87.8},{97.6,89.6},{97.8,83.2},{97.8,84.4},{98,81.4},{98,81.6},{98,88.6},{98,90.8},{98.2,85.4},{98.2,85.6},{98.4,87.2},{98.6,80.4},{98.6,88.2},{98.8,81.4},{98.8,87},{99,97},{99.2,84.2},{99.2,85.4},{99.2,85.8},{99.4,82.4},{99.4,83.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241122] = {
            [npcKeys.name] = "Scarlet Confessor",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{90,95},{90.2,81.6},{90.2,83.4},{90.2,84.4},{90.2,84.6},{90.4,81},{90.4,94.4},{90.6,84.4},{90.8,79.2},{90.8,84.6},{90.8,87.2},{91,79.6},{91,80.8},{91,83.4},{91,93.4},{91,93.6},{91,95.4},{91,95.6},{91.4,82.2},{91.4,85.8},{91.4,88.6},{91.4,91},{91.4,91.8},{91.6,82.4},{91.6,85.6},{91.6,91.8},{91.8,80.6},{91.8,83},{91.8,85.4},{91.8,87},{91.8,88.6},{91.8,90.8},{91.8,94.4},{91.8,94.6},{92,90.2},{92,92.8},{92.2,79.6},{92.2,83.8},{92.2,95.6},{92.4,78.2},{92.4,78.6},{92.6,78.2},{92.6,84.2},{92.8,83.4},{92.8,86.6},{93,79.2},{93,88},{93,89},{93.2,80.2},{93.2,80.8},{93.2,82},{93.2,85.2},{93.4,85.6},{93.6,78.2},{93.6,87},{93.8,80.2},{93.8,82.6},{93.8,86.4},{93.8,94.4},{93.8,94.6},{94,78.8},{94,84.2},{94.4,80.6},{94.4,81.6},{94.4,84.6},{94.4,88.4},{94.4,88.6},{94.4,92.2},{94.4,93.4},{94.6,78.2},{94.6,80.4},{94.6,82},{94.6,88.6},{94.8,83},{94.8,84},{95,91.4},{95,92.4},{95,92.6},{95.2,88.2},{95.4,78.6},{95.4,81},{95.4,84.6},{95.4,86.4},{95.4,90.2},{95.6,78.6},{95.6,88},{95.8,81.8},{95.8,85},{95.8,88.6},{95.8,93},{96,79.6},{96,84.2},{96.2,77.4},{96.2,77.6},{96.2,86.4},{96.2,86.6},{96.4,81.2},{96.4,83.2},{96.6,78},{96.6,78.6},{96.6,80.4},{96.6,81.4},{96.6,82.6},{96.6,84.6},{96.8,82.2},{96.8,88.4},{97,84.4},{97,88.6},{97,89.6},{97.2,85.6},{97.2,86.6},{97.6,85.6},{97.6,87.8},{97.6,89.4},{98,81},{98,83.2},{98,83.6},{98.4,81.8},{98.4,87},{98.8,83.6},{99.2,81.2},{99.2,85.2},{99.2,86},{99.4,82.4},{99.4,82.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241123] = {
            [npcKeys.name] = "Scarlet Priest",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{83.6,83.2},{89.8,81.6},{90,95.6},{90.2,83.2},{90.2,83.6},{90.2,84.6},{90.2,95},{90.4,81},{90.4,94.4},{90.8,79.2},{90.8,83.2},{90.8,93.6},{91,84.6},{91,88.6},{91,93.4},{91.2,79.6},{91.2,84.4},{91.2,96.4},{91.4,78.2},{91.4,80.6},{91.4,82.4},{91.4,85.6},{91.4,90.2},{91.4,91.2},{91.4,91.6},{91.4,95},{91.6,91.6},{91.8,80.4},{91.8,80.6},{91.8,82.4},{91.8,82.8},{91.8,85.4},{91.8,86.4},{91.8,87.2},{91.8,90.4},{91.8,91},{91.8,94.4},{91.8,94.6},{92,88.6},{92,92.8},{92,95.6},{92.2,79.4},{92.2,83.6},{92.4,78.2},{92.6,88.8},{92.6,93.6},{92.8,78.2},{92.8,83.4},{93,79.2},{93,86.4},{93.2,79.8},{93.2,82},{93.2,85.4},{93.2,88.2},{93.4,80.6},{93.4,84.2},{93.4,87},{93.4,94.8},{93.6,78.2},{93.6,79.2},{93.6,85.2},{93.8,82.6},{93.8,84.2},{93.8,86.2},{93.8,87.2},{93.8,89},{93.8,94},{93.8,95},{94,80},{94,89.8},{94.4,80.6},{94.4,81.8},{94.4,88.4},{94.6,79.4},{94.6,79.6},{94.6,81.8},{94.6,88.8},{94.6,89.6},{94.6,93.8},{94.8,84},{94.8,92.2},{95,83.2},{95,84.8},{95.2,81},{95.2,92.6},{95.4,78},{95.4,88.2},{95.6,78.6},{95.6,83.2},{95.6,84.4},{95.6,84.6},{95.6,88.2},{95.8,82},{96,79.8},{96.2,77.4},{96.2,77.6},{96.4,81.2},{96.4,86.4},{96.4,86.6},{96.6,78},{96.6,80.2},{96.6,81},{96.6,86.4},{96.8,82},{96.8,82.8},{96.8,86.6},{96.8,88.2},{97,78.8},{97,88.6},{97.2,84.8},{97.4,84.2},{97.4,89.8},{97.6,83},{97.6,86.2},{97.6,87.8},{97.6,89.4},{98,83.6},{98.2,80.4},{98.2,82},{98.4,81.4},{98.4,85.4},{98.4,87},{98.6,86},{98.6,87.2},{98.8,81.4},{99,88.8},{99.2,79.6},{99.2,88},{99.4,82.4},{99.4,82.6},{99.4,83.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241136] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241149] = {
            [npcKeys.name] = "Sword in the Stone",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241154] = {
            [npcKeys.name] = "Kill Credit [DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241164] = {
            [npcKeys.name] = "[DNT] Internal Only - Kill Credit Example - DO NOT EDIT",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241329] = {
            [npcKeys.name] = "Lighthouse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241334] = {
            [npcKeys.name] = "The Will of the Ashbringer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241335] = {
            [npcKeys.name] = "[DNT] Kill Credit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241406] = {
            [npcKeys.name] = "Scarlet Battle Mage",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241407] = {
            [npcKeys.name] = "Scarlet Defender",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241408] = {
            [npcKeys.name] = "Scarlet Courier",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241409] = {
            [npcKeys.name] = "Scarlet Armorer",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241411] = {
            [npcKeys.name] = "Scarlet Rifleman",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241434] = {
            [npcKeys.name] = "Scarlet Sentry",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241437] = {
            [npcKeys.name] = "Scarlet Courier",
            [npcKeys.minLevel] = 56,
            [npcKeys.maxLevel] = 56,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{97.4,92.2},{97.6,91.6},{97.8,90.6},{98.2,89},{98.4,89.8},{98.6,89.8},{99,90.8},{99.2,88.4},{99.4,89},{99.4,91.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241461] = {
            [npcKeys.name] = "Kill Credit [DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241462] = {
            [npcKeys.name] = "Kill Credit [DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241492] = {
            [npcKeys.name] = "Balnazzar",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241493] = {
            [npcKeys.name] = "Grand Crusader Dathrohan",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241501] = {
            [npcKeys.name] = "Grand Crusader Dathrohan",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241518] = {
            [npcKeys.name] = "Grand Crusader Caldoran",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241519] = {
            [npcKeys.name] = "High Commander Beatrix",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241613] = {
            [npcKeys.name] = "Kyndra Swiftarrow",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{93.8,90.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {89381,89421},
            [npcKeys.questEnds] = {89381,89421},
        },
        [241616] = {
            [npcKeys.name] = "Scarlet Trainee",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{93.4,90},{93.8,90.2},{94.2,91.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241659] = {
            [npcKeys.name] = "Markus Hearthfire",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{95.4,79}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241663] = {
            [npcKeys.name] = "Gerald",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{95.2,78.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241664] = {
            [npcKeys.name] = "Malorie",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{95.2,78.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241665] = {
            [npcKeys.name] = "Archmagus Nilas Arcanister",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241701] = {
            [npcKeys.name] = "(DNT) Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241707] = {
            [npcKeys.name] = "(DNT) Invisible Teleport Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241768] = {
            [npcKeys.name] = "Herod",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241769] = {
            [npcKeys.name] = "Arcanist Doan",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241770] = {
            [npcKeys.name] = "Interrogator Vishas",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241772] = {
            [npcKeys.name] = "Grand Crusader Caldoran",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241778] = {
            [npcKeys.name] = "Scarlet Thaumaturgist",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241785] = {
            [npcKeys.name] = "Ritual",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241786] = {
            [npcKeys.name] = "Ritual",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241787] = {
            [npcKeys.name] = "Ritual",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241825] = {
            [npcKeys.name] = "Ritual",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241826] = {
            [npcKeys.name] = "Ritual 2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241827] = {
            [npcKeys.name] = "Ritual Orb",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241828] = {
            [npcKeys.name] = "Scarlet Trainee",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241829] = {
            [npcKeys.name] = "[DNT] Kill Credit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241830] = {
            [npcKeys.name] = "Forsaken Captive",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241834] = {
            [npcKeys.name] = "Istaria",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241838] = {
            [npcKeys.name] = "Curious Troll",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{79,41}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241840] = {
            [npcKeys.name] = "(DNT) Invisible Cremation Targeting Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241859] = {
            [npcKeys.name] = "(DNT) Invisible Cremation Area Trigger Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241862] = {
            [npcKeys.name] = "Scarlet Stash",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{98.4,82.4},{98.6,82.4},{98.6,82.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241877] = {
            [npcKeys.name] = "Mayor Quimby",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{90.8,85.6},{91,85.4},{91.2,86.8},{91.6,85.6},{91.8,85.2},{92.8,84.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241895] = {
            [npcKeys.name] = "Manath Magesinger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241904] = {
            [npcKeys.name] = "Scarlet Artillery",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241906] = {
            [npcKeys.name] = "Sir Dornel",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241921] = {
            [npcKeys.name] = "Morlune the Mighty",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241940] = {
            [npcKeys.name] = "Spirit of Mograine",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241962] = {
            [npcKeys.name] = "[DNT] Kill Credit:",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241963] = {
            [npcKeys.name] = "[DNT] Kill Credit:",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241964] = {
            [npcKeys.name] = "[DNT] Kill Credit:",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241965] = {
            [npcKeys.name] = "[DNT] Kill Credit:",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [241985] = {
            [npcKeys.name] = "Mortar Combat Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242007] = {
            [npcKeys.name] = "Blade Dance",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242008] = {
            [npcKeys.name] = "Oil Spill",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242009] = {
            [npcKeys.name] = "Scarlet Cannon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242010] = {
            [npcKeys.name] = "Pupper",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{94.8,79.4},{94.8,79.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242019] = {
            [npcKeys.name] = "Leonid Barthalomew the Revered",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{33.4,27.4},{33.4,27.6},{33.6,27.4},{33.6,27.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {89234,89568,89574},
            [npcKeys.questEnds] = {89567,89568,89574},
        },
        [242062] = {
            [npcKeys.name] = "Scarlet Martyr",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242092] = {
            [npcKeys.name] = "Scarlet Ravager",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242093] = {
            [npcKeys.name] = "Parrot",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242098] = {
            [npcKeys.name] = "Scarlet Magus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242106] = {
            [npcKeys.name] = "Eastsea Cannoneer",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242107] = {
            [npcKeys.name] = "Eastsea Dockworker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242108] = {
            [npcKeys.name] = "Swift Scarlet Warhorse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242109] = {
            [npcKeys.name] = "Eastsea Swashbuckler",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242110] = {
            [npcKeys.name] = "Eastsea Cannon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242111] = {
            [npcKeys.name] = "Eastsea Buccaneer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242112] = {
            [npcKeys.name] = "Eastsea Privateer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242113] = {
            [npcKeys.name] = "First Mate Kip",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242114] = {
            [npcKeys.name] = "Scarlet Infantry",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242125] = {
            [npcKeys.name] = "Master Craftsman Omarion",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242135] = {
            [npcKeys.name] = "Eastsea Handler",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242137] = {
            [npcKeys.name] = "Un'Goro Gorilla",
            [npcKeys.minLevel] = 32,
            [npcKeys.maxLevel] = 33,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242141] = {
            [npcKeys.name] = "Glubb",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242142] = {
            [npcKeys.name] = "Young Stranglethorn Tiger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242148] = {
            [npcKeys.name] = "Scarlet Cavalry",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242156] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242158] = {
            [npcKeys.name] = "Climhazzard",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242159] = {
            [npcKeys.name] = "Scarlet Steed",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242160] = {
            [npcKeys.name] = "Great Shark",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242161] = {
            [npcKeys.name] = "Scarlet Miner",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242169] = {
            [npcKeys.name] = "S03 - Scarlet Enclave - Boss - Caldoran - Divine Conflagration - Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242170] = {
            [npcKeys.name] = "[DNT] Kill Credit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242174] = {
            [npcKeys.name] = "Thisalee Crow",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 618,
            [npcKeys.spawns] = {
                [618] = {{60.8,37.8}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242182] = {
            [npcKeys.name] = "T4 Tokens",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242183] = {
            [npcKeys.name] = "Abatha Rainwater",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{93.4,79.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242188] = {
            [npcKeys.name] = "Robin D. Banks",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{90.8,85.6},{91,85.4}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242204] = {
            [npcKeys.name] = "T4",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242214] = {
            [npcKeys.name] = "Scarlet Priest",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242216] = {
            [npcKeys.name] = "Scarlet Archer",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242218] = {
            [npcKeys.name] = "Scarlet Mage",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242224] = {
            [npcKeys.name] = "Cardinal Stiltz",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242229] = {
            [npcKeys.name] = "Test Boss",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242240] = {
            [npcKeys.name] = "S03 - Scarlet Enclave - Boss - Caldoran - Reinforcement - Stalker - Type A",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242243] = {
            [npcKeys.name] = "S03 - Scarlet Enclave - Boss - Caldoran - Reinforcement - Stalker - Type B",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242245] = {
            [npcKeys.name] = "S03 - Scarlet Enclave - Boss - Caldoran - Reinforcement - Stalker - Type C",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242246] = {
            [npcKeys.name] = "S03 - Scarlet Enclave - Boss - Caldoran - Reinforcement - Stalker - Type D",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242250] = {
            [npcKeys.name] = "Pile of Ash",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242271] = {
            [npcKeys.name] = "Scarlet Priest",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242272] = {
            [npcKeys.name] = "Scarlet Archer",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242275] = {
            [npcKeys.name] = "Scarlet Artillery",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242279] = {
            [npcKeys.name] = "Scarlet Cavalry",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242282] = {
            [npcKeys.name] = "Scarlet Infantry",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242283] = {
            [npcKeys.name] = "Scarlet Mage",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242296] = {
            [npcKeys.name] = "Bowmaster Puck",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242298] = {
            [npcKeys.name] = "The Ashbringer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242300] = {
            [npcKeys.name] = "Watchman Briggs",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242301] = {
            [npcKeys.name] = "Cannon Mistress Lind",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242304] = {
            [npcKeys.name] = "Knight-Captain Fratley",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242308] = {
            [npcKeys.name] = "Shield Warden Stein",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242310] = {
            [npcKeys.name] = "Arcanist Hilda",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242329] = {
            [npcKeys.name] = "S03 - Scarlet Enclave - Boss - Caldoran - Wrath of the Crusade - Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242344] = {
            [npcKeys.name] = "Skeleton",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242345] = {
            [npcKeys.name] = "Dahlos",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242354] = {
            [npcKeys.name] = "Scarlet Commander",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242367] = {
            [npcKeys.name] = "New Avalon Citizen",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{89.8,79.2},{90,83.4},{90.4,84.4},{90.4,84.6},{90.4,94.2},{90.4,95.8},{90.6,82.8},{90.6,94.2},{90.8,79.2},{90.8,79.6},{90.8,80.6},{90.8,85.6},{90.8,93.4},{90.8,95.6},{91.2,78},{91.2,82.2},{91.2,86.6},{91.2,92},{91.4,84.4},{91.4,84.6},{91.4,87.8},{91.4,91},{91.4,94.6},{91.6,84.4},{91.6,91},{91.6,94.8},{91.8,80.8},{91.8,82.8},{91.8,87},{91.8,92},{91.8,93.8},{92,78.2},{92,79.8},{92,82.4},{92,85.2},{92,85.8},{92,87.8},{92,88.6},{92,90.4},{92,93},{92.2,78.8},{92.2,95.8},{92.6,79.8},{92.6,92.8},{92.8,78.4},{92.8,84.4},{93,86},{93,86.8},{93.2,81},{93.2,85.2},{93.2,88.2},{93.2,90},{93.2,90.6},{93.4,79.4},{93.4,82.4},{93.4,83.4},{93.4,89.4},{93.4,92.2},{93.4,93.8},{93.4,95.2},{93.6,79.4},{93.6,85.4},{93.6,86.4},{93.6,87.2},{93.6,89.8},{93.6,94.4},{93.8,89.2},{93.8,92.8},{93.8,95.2},{94,78.4},{94,79.6},{94.2,81.2},{94.2,81.8},{94.4,83.4},{94.4,83.6},{94.4,88.4},{94.4,91.2},{94.4,91.8},{94.6,79.2},{94.6,83.4},{94.6,83.6},{94.6,85},{94.6,88.4},{94.6,89},{94.6,91.6},{94.8,79.6},{94.8,91.2},{95,92.8},{95.2,81.4},{95.2,86.2},{95.2,90.4},{95.4,77.6},{95.4,82.2},{95.4,93.6},{95.6,80.8},{95.6,82},{95.6,91},{95.6,92.4},{95.8,84.2},{95.8,88.4},{95.8,93.2},{96,77.8},{96,78.6},{96,88.8},{96.2,77.4},{96.2,83},{96.2,86.4},{96.2,86.8},{96.4,80.4},{96.4,84.6},{96.6,82.2},{96.6,87},{96.8,84.6},{96.8,87.6},{96.8,88.8},{97,83.8},{97,86.4},{97.4,79.4},{97.4,79.6},{97.4,83},{97.6,79.8},{97.6,81.4},{97.8,79.2},{97.8,84},{97.8,88},{98,83.2},{98.2,81.8},{98.2,87},{98.4,85.6},{98.6,87.6},{98.8,84},{98.8,85.4},{98.8,87.2},{99,85.8},{99.2,80.6},{99.2,83.4},{99.4,82.4}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242371] = {
            [npcKeys.name] = "Entangling Shot",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242373] = {
            [npcKeys.name] = "S03 - Scarlet Enclave - Boss - Caldoran - Fire Stalker - Damage",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242378] = {
            [npcKeys.name] = "S03 - Scarlet Enclave - Boss - Caldoran - Fire Stalker - Cosmetic 1",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242380] = {
            [npcKeys.name] = "S03 - Scarlet Enclave - Boss - Caldoran - Fire Stalker - Cosmetic 2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242386] = {
            [npcKeys.name] = "Scarlet Firefighter",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242389] = {
            [npcKeys.name] = "Angela Dosantos",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242424] = {
            [npcKeys.name] = "S03 - Scarlet Enclave - Boss - Caldoran - Collapse Stalker Manager",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242427] = {
            [npcKeys.name] = "Scarlet Foreman",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242439] = {
            [npcKeys.name] = "Thisalee Crow",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242450] = {
            [npcKeys.name] = "Kill Credit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242466] = {
            [npcKeys.name] = "Scarlet Deaconess",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242470] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242477] = {
            [npcKeys.name] = "Animated Detritus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242479] = {
            [npcKeys.name] = "Immolation Trap",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242496] = {
            [npcKeys.name] = "[DNT] Kill Credit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242497] = {
            [npcKeys.name] = "[DNT] Kill Credit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242499] = {
            [npcKeys.name] = "Highlord Mograine",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242501] = {
            [npcKeys.name] = "The Will of the Ashbringer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242510] = {
            [npcKeys.name] = "Scarlet Hollow",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242516] = {
            [npcKeys.name] = "S03 - Scarlet Enclave - Boss - Caldoran - Bloodflame - Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242547] = {
            [npcKeys.name] = "Scarlet Praetorian",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242554] = {
            [npcKeys.name] = "Jorn",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242555] = {
            [npcKeys.name] = "Buzan",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242556] = {
            [npcKeys.name] = "Karnwield",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242557] = {
            [npcKeys.name] = "Manadar",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242558] = {
            [npcKeys.name] = "Nilas Arcanister",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242559] = {
            [npcKeys.name] = "Granis Darkhammer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242560] = {
            [npcKeys.name] = "Tenn Flamecaster",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242561] = {
            [npcKeys.name] = "Alexei",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242562] = {
            [npcKeys.name] = "Vishas",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242563] = {
            [npcKeys.name] = "Beatrix",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242564] = {
            [npcKeys.name] = "Herod",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242565] = {
            [npcKeys.name] = "Doan",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242572] = {
            [npcKeys.name] = "Scarlet Mage Tier 2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242573] = {
            [npcKeys.name] = "Scarlet Infantry Tier 2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242574] = {
            [npcKeys.name] = "Scarlet Cavalry Tier 2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242575] = {
            [npcKeys.name] = "Scarlet Artillery Tier 2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242576] = {
            [npcKeys.name] = "Scarlet Archer Tier 2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242577] = {
            [npcKeys.name] = "Devouring Hunger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242580] = {
            [npcKeys.name] = "Wisp",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242599] = {
            [npcKeys.name] = "[DNT] Kill Credit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242600] = {
            [npcKeys.name] = "[DNT] Kill Credit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242601] = {
            [npcKeys.name] = "[DNT] Kill Credit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242605] = {
            [npcKeys.name] = "The Creature",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{96,81.4},{96.2,81.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242624] = {
            [npcKeys.name] = "Fire Door",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242629] = {
            [npcKeys.name] = "Scarlet Courier",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242641] = {
            [npcKeys.name] = "Reborn Shuffler",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242660] = {
            [npcKeys.name] = "Molten Basin",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242690] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242741] = {
            [npcKeys.name] = "Charge Stalker 01",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242751] = {
            [npcKeys.name] = "Viznit the Scoundrel",
            [npcKeys.minLevel] = 55,
            [npcKeys.maxLevel] = 55,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242757] = {
            [npcKeys.name] = "New Avalon Councilman",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{90.8,85.6},{91.2,86.6},{91.6,85.8},{91.8,85.4},{92.6,85.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242782] = {
            [npcKeys.name] = "The Ashbringer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242788] = {
            [npcKeys.name] = "Bowmaster Puck",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242789] = {
            [npcKeys.name] = "Cannon Mistress Lind",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242790] = {
            [npcKeys.name] = "Knight-Captain Fratley",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242791] = {
            [npcKeys.name] = "Shield Warden Stein",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242792] = {
            [npcKeys.name] = "Arcanist Hilda",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242793] = {
            [npcKeys.name] = "Cardinal Stiltz",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242796] = {
            [npcKeys.name] = "Beatrix Controller",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242816] = {
            [npcKeys.name] = "Nether Barrier",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242827] = {
            [npcKeys.name] = "Captain Bloodcoin",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242828] = {
            [npcKeys.name] = "Herod",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242853] = {
            [npcKeys.name] = "Eastsea Scallywag",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242862] = {
            [npcKeys.name] = "Ancient Flame",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242863] = {
            [npcKeys.name] = "Hyjal Bonfire",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242867] = {
            [npcKeys.name] = "The Will of the Ashbringer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242870] = {
            [npcKeys.name] = "S03 - Item - Experiment-800M - Transform - Cannon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242872] = {
            [npcKeys.name] = "Lady Blaumeux",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242874] = {
            [npcKeys.name] = "Thane Korth'azz",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242877] = {
            [npcKeys.name] = "Sir Zeliek",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242878] = {
            [npcKeys.name] = "Highlord Mograine",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242886] = {
            [npcKeys.name] = "Eastsea Long Barrel",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242892] = {
            [npcKeys.name] = "Mirage",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242908] = {
            [npcKeys.name] = "Scarlet Archer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242922] = {
            [npcKeys.name] = "Scarlet Artillery",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242923] = {
            [npcKeys.name] = "Breath Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242924] = {
            [npcKeys.name] = "Scarlet Enclave Weapons",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242925] = {
            [npcKeys.name] = "Scarlet Enclave Armor",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242926] = {
            [npcKeys.name] = "Scarlet Cavalry",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242927] = {
            [npcKeys.name] = "Scarlet Cavalry",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242954] = {
            [npcKeys.name] = "Anvil",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{99.4,77.8}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242957] = {
            [npcKeys.name] = "Scarlet Infantry",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [242958] = {
            [npcKeys.name] = "Scarlet Infantry",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243001] = {
            [npcKeys.name] = "Scarlet Priest",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243005] = {
            [npcKeys.name] = "Putress",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243007] = {
            [npcKeys.name] = "Screeching Terror",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243011] = {
            [npcKeys.name] = "Infernal",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243012] = {
            [npcKeys.name] = "Strong Bear",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243013] = {
            [npcKeys.name] = "Observant Owl",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243014] = {
            [npcKeys.name] = "Quick Cat",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243015] = {
            [npcKeys.name] = "Agile Raptor",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243016] = {
            [npcKeys.name] = "Powerful Gorilla",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243017] = {
            [npcKeys.name] = "Ferocious Crocolisk",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243018] = {
            [npcKeys.name] = "Brilliant Mr. Bigglesworth",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243019] = {
            [npcKeys.name] = "Last Standard",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243021] = {
            [npcKeys.name] = "Lillian Voss",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243022] = {
            [npcKeys.name] = "New Avalon Citizen",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243023] = {
            [npcKeys.name] = "Inquisitor Jociphine",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{68.2,82.4},{68.2,82.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {90510},
            [npcKeys.questEnds] = {90510},
        },
        [243024] = {
            [npcKeys.name] = "DNT",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243025] = {
            [npcKeys.name] = "Meteor",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243026] = {
            [npcKeys.name] = "Meteor",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243027] = {
            [npcKeys.name] = "Scarlet Mage",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243046] = {
            [npcKeys.name] = "Scarlet Captain",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{67.4,83.2},{67.8,83.2}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243047] = {
            [npcKeys.name] = "Scarlet Infantry",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243050] = {
            [npcKeys.name] = "Scarlet Sergeant",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243051] = {
            [npcKeys.name] = "Mote of Possibility",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243056] = {
            [npcKeys.name] = "Knight Farris",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2017,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243057] = {
            [npcKeys.name] = "Knight Stearn",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2017,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243060] = {
            [npcKeys.name] = "Distracted Scarlet Wizard",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243061] = {
            [npcKeys.name] = "(DNT) Invisible Target Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243062] = {
            [npcKeys.name] = "(DNT) Invisible Beam Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243076] = {
            [npcKeys.name] = "Scarlet Lightbearer",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243086] = {
            [npcKeys.name] = "Eastsea Dockworker",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243087] = {
            [npcKeys.name] = "Eastsea Mercenary",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243094] = {
            [npcKeys.name] = "Scarlet Wizard",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243096] = {
            [npcKeys.name] = "Magic Ward",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243099] = {
            [npcKeys.name] = "Scarlet Enclave Weapon Enchants",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243100] = {
            [npcKeys.name] = "Shade of Balnazzar",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243107] = {
            [npcKeys.name] = "[DNT] TEST NPC",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243139] = {
            [npcKeys.name] = "Lightgorged Whelp",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243158] = {
            [npcKeys.name] = "Cardinal Martell",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243159] = {
            [npcKeys.name] = "Scarlet Priest",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243184] = {
            [npcKeys.name] = "Transformation",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243186] = {
            [npcKeys.name] = "Fydriel",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243187] = {
            [npcKeys.name] = "Gustave",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243189] = {
            [npcKeys.name] = "Slipstrip Silverspanner",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243190] = {
            [npcKeys.name] = "Argent Guard",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243191] = {
            [npcKeys.name] = "Argent Rider",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243192] = {
            [npcKeys.name] = "Griffin Rowan",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243193] = {
            [npcKeys.name] = "Angela Dosantos",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243194] = {
            [npcKeys.name] = "Spymaster Ricky Bismuth",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243195] = {
            [npcKeys.name] = "Argent Scout",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243200] = {
            [npcKeys.name] = "[DNT] Kill Credit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243201] = {
            [npcKeys.name] = "[DNT] Kill Credit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243202] = {
            [npcKeys.name] = "[DNT] Kill Credit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243203] = {
            [npcKeys.name] = "[DNT] Kill Credit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243204] = {
            [npcKeys.name] = "[DNT] Kill Credit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243250] = {
            [npcKeys.name] = "Knight-Captain Caldoran",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2017,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243251] = {
            [npcKeys.name] = "Crusader Caldoran",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{16.4,31.4},{16.4,31.6},{16.6,31.4},{16.6,31.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243252] = {
            [npcKeys.name] = "Leonid Barthalomew",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 2017,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243254] = {
            [npcKeys.name] = "Leonid Barthalomew",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{16.4,31.4},{16.6,31.2},{16.6,31.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243255] = {
            [npcKeys.name] = "Scarlet Crusader",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{16.4,31.4},{16.4,31.6},{16.6,31.4},{16.6,31.6}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243269] = {
            [npcKeys.name] = "Solistrasza",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243271] = {
            [npcKeys.name] = "Molten Boulder",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243299] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243331] = {
            [npcKeys.name] = "Liliana Barthalomew",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 2017,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243332] = {
            [npcKeys.name] = "Percival Barthalomew",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 2017,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243337] = {
            [npcKeys.name] = "Frozen Core",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243385] = {
            [npcKeys.name] = "DNT",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243386] = {
            [npcKeys.name] = "Leonid Barthalomew the Revered",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{16.4,31.2},{16.6,31.2}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {89229,89328,89329},
            [npcKeys.questEnds] = {89310,89328,89329},
        },
        [243387] = {
            [npcKeys.name] = "DNT",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243392] = {
            [npcKeys.name] = "DNT",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243393] = {
            [npcKeys.name] = "Leonid Barthalomew the Revered",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{47.8,22}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {89235,89310},
            [npcKeys.questEnds] = {89234,89235},
        },
        [243394] = {
            [npcKeys.name] = "Percival Barthalomew",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 139,
            [npcKeys.spawns] = {
                [139] = {{16.4,31.2},{16.6,31.4},{16.6,31.6}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243627] = {
            [npcKeys.name] = "Argent Scout",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243628] = {
            [npcKeys.name] = "Argent Scout",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243629] = {
            [npcKeys.name] = "DNT",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243630] = {
            [npcKeys.name] = "DNT",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243632] = {
            [npcKeys.name] = "Argent Scout",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243637] = {
            [npcKeys.name] = "Monument",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243645] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243647] = {
            [npcKeys.name] = "Ancient of War",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243648] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243657] = {
            [npcKeys.name] = "Scarlet Crusader Corpse",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243702] = {
            [npcKeys.name] = "Scarlet Paladin",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243737] = {
            [npcKeys.name] = "Scarlet Myrmidon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243755] = {
            [npcKeys.name] = "Argent Dawn Infantry",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243756] = {
            [npcKeys.name] = "Scarlet Crusader",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243757] = {
            [npcKeys.name] = "Angela Dosantos",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243783] = {
            [npcKeys.name] = "Scarlet Infantry",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243787] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243788] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243790] = {
            [npcKeys.name] = "Scarlet Cavalry",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243834] = {
            [npcKeys.name] = "Johnny Heart Man",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243838] = {
            [npcKeys.name] = "Dwiba",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243893] = {
            [npcKeys.name] = "High General Abbendis",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243904] = {
            [npcKeys.name] = "Scarlet Paladin",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243911] = {
            [npcKeys.name] = "Dread Cannon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243914] = {
            [npcKeys.name] = "Scarlet Cannonball",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243917] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243943] = {
            [npcKeys.name] = "Toxic Pool",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243946] = {
            [npcKeys.name] = "Argent Dawn Infantry",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243947] = {
            [npcKeys.name] = "Cannon Fire Stalker [DNT]",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [243954] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244005] = {
            [npcKeys.name] = "Scarlet Priest",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244006] = {
            [npcKeys.name] = "Scarlet Mage",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244007] = {
            [npcKeys.name] = "Scarlet Infantry",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244008] = {
            [npcKeys.name] = "Scarlet Cavalry",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244009] = {
            [npcKeys.name] = "Scarlet Artillery",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244010] = {
            [npcKeys.name] = "Scarlet Archer",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244011] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244013] = {
            [npcKeys.name] = "Scarlet Mage",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244014] = {
            [npcKeys.name] = "Scarlet Priest",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244015] = {
            [npcKeys.name] = "Scarlet Infantry",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244016] = {
            [npcKeys.name] = "Scarlet Cavalry",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244017] = {
            [npcKeys.name] = "Scarlet Artillery",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244018] = {
            [npcKeys.name] = "Scarlet Archer",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244019] = {
            [npcKeys.name] = "Scarlet Priest",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244020] = {
            [npcKeys.name] = "Scarlet Mage",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244021] = {
            [npcKeys.name] = "Scarlet Infantry",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244022] = {
            [npcKeys.name] = "Scarlet Cavalry",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244023] = {
            [npcKeys.name] = "Scarlet Artillery",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244024] = {
            [npcKeys.name] = "Scarlet Archer",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244064] = {
            [npcKeys.name] = "Scarlet Archer",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244065] = {
            [npcKeys.name] = "Scarlet Artillery",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244066] = {
            [npcKeys.name] = "Scarlet Cavalry",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244067] = {
            [npcKeys.name] = "Scarlet Infantry",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244068] = {
            [npcKeys.name] = "Scarlet Mage",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244069] = {
            [npcKeys.name] = "Scarlet Priest",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244102] = {
            [npcKeys.name] = "Scarlet Priest",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244103] = {
            [npcKeys.name] = "Scarlet Mage",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244104] = {
            [npcKeys.name] = "Scarlet Infantry",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244105] = {
            [npcKeys.name] = "Scarlet Cavalry",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244106] = {
            [npcKeys.name] = "Scarlet Artillery",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244107] = {
            [npcKeys.name] = "Scarlet Archer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244122] = {
            [npcKeys.name] = "Eastsea Cannoneer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244131] = {
            [npcKeys.name] = "Scarlet Priest",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244132] = {
            [npcKeys.name] = "Scarlet Mage",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244133] = {
            [npcKeys.name] = "Scarlet Infantry",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 16236,
            [npcKeys.spawns] = {
                [16236] = {{-1,-1}},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244134] = {
            [npcKeys.name] = "Scarlet Cavalry",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244135] = {
            [npcKeys.name] = "Scarlet Artillery",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244136] = {
            [npcKeys.name] = "Scarlet Archer",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244147] = {
            [npcKeys.name] = "Scarlet Rifleman",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244151] = {
            [npcKeys.name] = "Argent Dawn Cleric",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244155] = {
            [npcKeys.name] = "New Avalon Refugee",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244172] = {
            [npcKeys.name] = "Argent Dawn Infantry",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244265] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244306] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244307] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244310] = {
            [npcKeys.name] = "Furniture",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244311] = {
            [npcKeys.name] = "Invisible Bunny",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244321] = {
            [npcKeys.name] = "Leonid Barthalomew the Revered",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244322] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244324] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244329] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244330] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244342] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244343] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244345] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244346] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244347] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244348] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244350] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244351] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244352] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244353] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244357] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244358] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244361] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244362] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244364] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244365] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244366] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244367] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244368] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244369] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244373] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244374] = {
            [npcKeys.name] = "(DNT) Hallway Corpses",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244460] = {
            [npcKeys.name] = "Male Dark Assassin",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244462] = {
            [npcKeys.name] = "Female Dark Assassin",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244477] = {
            [npcKeys.name] = "Riding Gryphon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244480] = {
            [npcKeys.name] = "Riding Gryphon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244481] = {
            [npcKeys.name] = "Riding Gryphon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [244482] = {
            [npcKeys.name] = "Riding Gryphon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
    }
end
