---@type ContentPhases
local ContentPhases = QuestieLoader:ImportModule("ContentPhases")

-- This function blacklists any quests in phases LATER than the currentPhase value
-- so in Phase 1, quests in phases 2+ are blacklisted, in phase 2, phases 3+ are blacklisted, etc
-- Phase 1 is omitted, because everything not in this list is supposed to be available in Phase 1
local questsToBlacklistByPhase = {
    [1] = {}, -- Phase 1 (this is required for counting, but should stay empty)
    [2] = { -- Phase 2 (Patch 5.1 Landfall (Brawlers Guild, New Scenarios)
        [32106] = true, -- A Winter Veil Gift
        [32108] = true, -- Domination Point
        [32109] = true, -- Lion's Landing
        [32112] = true, -- FLAG - Been to Fight Club
        [32113] = true, -- FLAG - Been to Fight Club Today
        [32115] = true, -- Shackles of the Past
        [32116] = true, -- Priorities, People!
        [32118] = true, -- Taking Advantage
        [32119] = true, -- It Is A Mystery
        [32120] = true, -- Legacy of Ogudei
        [32121] = true, -- The Spirit Trap
        [32122] = true, -- Ogudei's Lieutenants
        [32123] = true, -- Death on Two Legs
        [32126] = true, -- Tear It Up
        [32127] = true, -- All Dead, All Dead
        [32128] = true, -- Another One Bites the Dust
        [32130] = true, -- Good Luck, Have Fun
        [32131] = true, -- We Require More Minerals!
        [32132] = true, -- Worker Harassment
        [32133] = true, -- Sentry Wards
        [32134] = true, -- Hard Counter
        [32135] = true, -- Hero Killer
        [32136] = true, -- Work Order: Fuel
        [32137] = true, -- Runnin' On Empty
        [32138] = true, -- Work Order: Lumber
        [32139] = true, -- Stacked!
        [32140] = true, -- Work Order: Iron
        [32141] = true, -- Power Metal
        [32142] = true, -- We Will Rock You
        [32143] = true, -- A Kind of Magic
        [32144] = true, -- Under Pressure
        [32145] = true, -- Don't Lose Your Head
        [32146] = true, -- Hammer to Fall
        [32147] = true, -- Attack Daily 06
        [32148] = true, -- Attack! Move!
        [32149] = true, -- Resource Gathering
        [32150] = true, -- Supply Block
        [32151] = true, -- Tower Defense
        [32152] = true, -- Siege Damage
        [32153] = true, -- Hero Killer
        [32154] = true, -- Burn Out!
        [32155] = true, -- Necessary Breaks
        [32156] = true, -- It's Only Right
        [32157] = true, -- The Only Good Goblin...
        [32158] = true, -- Two Step Program
        [32159] = true, -- Circle of Life
        [32161] = true, -- Beastmaster's Hunt: The Crane
        [32162] = true, -- Beastmaster's Hunt: The Tiger
        [32163] = true, -- Beastmaster's Hunt: The Crab
        [32164] = true, -- Beastmaster's Hunt: The Crane
        [32165] = true, -- Beastmaster's Hunt: The Tiger
        [32166] = true, -- Beastmaster's Hunt: The Crab
        [32167] = true, -- Ancient's Fall
        [32168] = true, -- End of an Elder
        [32169] = true, -- A Colossal Victory
        [32170] = true, -- Ancient's Fall
        [32171] = true, -- End of an Elder
        [32172] = true, -- A Colossal Victory
        [32181] = true, -- Beastmaster's Quarry: The Crane
        [32182] = true, -- Beastmaster's Quarry: The Tiger
        [32183] = true, -- Beastmaster's Quarry: The Crab
        [32184] = true, -- Beastmaster's Quarry: The Crane
        [32185] = true, -- Beastmaster's Quarry: The Tiger
        [32186] = true, -- Beastmaster's Quarry: The Crab
        [32189] = true, -- A Shabby New Face
        [32190] = true, -- To Mogujia
        [32191] = true, -- Ancient Guardians
        [32192] = true, -- Bloodlines
        [32193] = true, -- To Mogujia
        [32194] = true, -- Bad Blood
        [32197] = true, -- Mystery Meatloaf
        [32198] = true, -- One Magical, Flying Kingdom's Trash...
        [32199] = true, -- Krasarang Steampot
        [32214] = true, -- Bilgewater Infiltrators
        [32221] = true, -- Storming the Beach
        [32222] = true, -- WANTED: Chief Engineer Cogwrench
        [32223] = true, -- WANTED: Lieutenant Ethan Jacobson
        [32235] = true, -- Flash! Aaaaaahhhh!
        [32236] = true, -- Bug Off!
        [32237] = true, -- Precious Resource
        [32238] = true, -- Universal Remote-Explode
        [32242] = true, -- Buried Secrets
        [32243] = true, -- The Source of Korune Power
        [32244] = true, -- The Korune
        [32246] = true, -- Meet the Scout
        [32247] = true, -- A King Among Men
        [32248] = true, -- A Little Patience
        [32249] = true, -- Meet the Scout
        [32250] = true, -- The Might of the Warchief
        [32251] = true, -- Dagger in the Dark
        [32256] = true, -- Rise Of An Empire
        [32257] = true, -- Voice of the Gods
        [32284] = true, -- Someone You Should See
        [32295] = true, -- An Unusual Tome
        [32306] = true, -- Lumber Collection Tracking
        [32307] = true, -- Reader for the Dead Tongue
        [32309] = true, -- A Tale of Six Masters
        [32310] = true, -- A Tale of Six Masters
        [32315] = true, -- Anduin's Plea
        [32316] = true, -- Heart Of The Alliance
        [32317] = true, -- Seeking the Soulstones
        [32319] = true, -- Find Thrall!
        [32320] = true, -- The Horde Is Family
        [32321] = true, -- The Monkey King
        [32324] = true, -- Seek the Signal
        [32325] = true, -- Infiltrating the Black Temple
        [32326] = true, -- Insertion
        [32327] = true, -- The Darnassus Mission
        [32328] = true, -- Victorious Return
        [32329] = true, -- Get My Results!
        [32330] = true, -- What's in the Box?
        [32331] = true, -- The Kirin Tor
        [32333] = true, -- The Second Riddle: Fellowship
        [32334] = true, -- The Third Riddle: Strength
        [32335] = true, -- The Greatest Prank
        [32336] = true, -- The Handle
        [32337] = true, -- The Head
        [32338] = true, -- The Harmonic Ointment
        [32339] = true, -- Rebuilding the Mallet (Tracker)
        [32340] = true, -- Plunder the Black Temple
        [32342] = true, -- The Spirit Trap
        [32343] = true, -- Ogudei's Lieutenants
        [32344] = true, -- It Is A Mystery
        [32345] = true, -- We're Not Monsters!
        [32346] = true, -- Oi Ain't Afraid o' No Ghosts!
        [32347] = true, -- Eviction Notice
        [32348] = true, -- Kick 'em While They're Down
        [32351] = true, -- Echoes of Thunder
        [32352] = true, -- A Gathering Storm
        [32355] = true, -- The Harmonic Mallet
        [32356] = true, -- Tracking Event: Ambassadors Summoned
        [32357] = true, -- Tracking Event: Event Complete
        [32358] = true, -- The Soulcore
        [32361] = true, -- Tracking Event: Event Complete
        [32362] = true, -- The Fate of Dalaran
        [32363] = true, -- The Kun-Lai Expedition
        [32365] = true, -- Tracking Event: Epilogue Complete
        [32368] = true, -- Memory Wine
        [32370] = true, -- The Kun-Lai Expedition
        [32371] = true, -- Memory Wine
        [32372] = true, -- De-Subjugation
        [32375] = true, -- A Dash of That
        [32376] = true, -- To the Valley!
        [32377] = true, -- A Kor'kron In Our Midst
        [32378] = true, -- Clearing a Path
        [32379] = true, -- Legacy of the Korune
        [32380] = true, -- The Best Around
        [32381] = true, -- To Catch A Spy
        [32382] = true, -- He's In Deep
        [32383] = true, -- Bugging Out
        [32384] = true, -- Trapping the Leader
        [32391] = true, -- The Ruins of Korune
        [32392] = true, -- The Divine Bell
        [32393] = true, -- The Ruins of Korune
        [32394] = true, -- The Divine Bell
        [32395] = true, -- Tracking Event: Saw Avartu
        [32397] = true, -- He Won't Even Miss It
        [32398] = true, -- The Bell Speaks
        [32399] = true, -- Breath of Darkest Shadow
        [32400] = true, -- The Bell Speaks
        [32401] = true, -- Breath of Darkest Shadow
        [32402] = true, -- The Situation In Dalaran
        [32403] = true, -- It Starts in the Sewers
        [32404] = true, -- Violence in the Arena
        [32405] = true, -- Hand of the Silver Covenant
        [32406] = true, -- A Tactical Assault
        [32408] = true, -- The Silver Covenant's Stronghold
        [32409] = true, -- The Kirin Tor's True Colors
        [32410] = true, -- Krasus' Landing
        [32411] = true, -- The Remaining Sunreavers
        [32412] = true, -- One Last Grasp
        [32413] = true, -- A Return to Krasarang
        [32414] = true, -- Darnassus Attacked?
        [32416] = true, -- Jaina's Resolution
        [32417] = true, -- Sewer Cleaning
        [32418] = true, -- Unfair Trade
        [32419] = true, -- Nowhere to Hide
        [32420] = true, -- Cashing Out
        [32421] = true, -- Nowhere to Run
        [32423] = true, -- What Had To Be Done
        [32426] = true, -- Stirred, Not Shaken
        [32433] = true, -- Undermining the Under Miner
        [32435] = true, -- Second Place
        [32436] = true, -- Third Place
        [32437] = true, -- Tracking Event: Saw Sarannha 1
        [32438] = true, -- Tracking Event: Saw Sarannha 2
        [32442] = true, -- Impending Danger
        [32444] = true, -- FLAG - Earned Brawler Title (Weekly)
        [32446] = true, -- Dis-Assembly Required
        [32448] = true, -- Ties with the Past
        [32449] = true, -- The Ruins of Ogudei
        [32450] = true, -- The Time Is Now!
        [32451] = true, -- Send A Message
        [32452] = true, -- And Then There Were Goblins
        [32455] = true, -- The Silence
        [32460] = true, -- Tracking the Thieves
        [32461] = true, -- The Order of the Cloud Serpent
        [32477] = true, -- Tracking Event: Player is Back in Time
        [33252] = true, -- A Winter Veil Gift
        [33354] = true, -- Den Mother's Demise
    },
    [3] = { -- Phase 3 (Patch 5.2 The Thunder King (Isle of Thunder, Throne of Thunder))
        [32200] = true, -- Dangers of Za'Tual
        [32201] = true, -- Grave Circumstances
        [32204] = true, -- The Skumblade Threat
        [32205] = true, -- Gather Scout Reports
        [32206] = true, -- This Just Won't Do
        [32207] = true, -- Saur Loser
        [32208] = true, -- Maximum Capacitor
        [32209] = true, -- Save Our Scouts!
        [32212] = true, -- The Assault on Zeb'tula
        [32213] = true, -- Old Enemies
        [32215] = true, -- Heinous Sacrifice
        [32216] = true, -- Pterrible Ptorment
        [32217] = true, -- Dark Offerings
        [32218] = true, -- Ashes of the Enemy
        [32219] = true, -- Stone Cold
        [32220] = true, -- Soul Surrender
        [32224] = true, -- Rise No More!
        [32225] = true, -- The Call of Thunder
        [32226] = true, -- Into the Crypts
        [32227] = true, -- Preventing a Future Threat
        [32228] = true, -- The Shuddering Moor
        [32230] = true, -- The Zandalari Colossus
        [32232] = true, -- What's Inside Counts
        [32233] = true, -- Very Disarming
        [32234] = true, -- Knowledge Is Power
        [32252] = true, -- Harbingers of the Loa
        [32254] = true, -- Manipulating the Saurok
        [32255] = true, -- De-Constructed
        [32258] = true, -- Horde Quest Choice: PvP
        [32259] = true, -- Horde Quest Choice: PvE
        [32260] = true, -- Alliance Quest Choice: PvE
        [32261] = true, -- Alliance Quest Choice: PvP
        [32262] = true, -- Captive Audience
        [32264] = true, -- Spellbound
        [32265] = true, -- Charged Moganite
        [32266] = true, -- Mana Manifestations
        [32268] = true, -- Tactical Mana Bombs
        [32269] = true, -- Breaking Down the Defenses
        [32274] = true, -- The Residents of Ihgaluk
        [32275] = true, -- Surgical Death
        [32276] = true, -- Tear Down This Wall!
        [32277] = true, -- To the Skies!
        [32278] = true, -- Decisive Action
        [32279] = true, -- The Fall of Shan Bu
        [32282] = true, -- Compy Stomp
        [32283] = true, -- Loa-saur
        [32285] = true, -- The Sleepless Legion
        [32287] = true, -- Enemies Beneath the Tower
        [32288] = true, -- Bolstering the Defenses
        [32292] = true, -- Forge Ahead!
        [32293] = true, -- Among the Bones
        [32294] = true, -- Raining Bones
        [32296] = true, -- Treasures of the Thunder King
        [32297] = true, -- Direhorn or Devilsaur
        [32298] = true, -- Dino Might
        [32299] = true, -- Just Some Light Clean-Up Work
        [32300] = true, -- Disarming Irony
        [32301] = true, -- Old Enemies
        [32302] = true, -- Desconstruction
        [32303] = true, -- Made for War
        [32304] = true, -- High Recognition
        [32305] = true, -- Overpowered
        [32467] = true, -- Sacrificial Prevention [PH]
        [32468] = true, -- Crystal Clarity
        [32469] = true, -- Crystal Clarity
        [32470] = true, -- Light Camera Action
        [32471] = true, -- Light Camera Action
        [32472] = true, -- Frighten Pterodactyls [PH]
        [32485] = true, -- Bolstering the Defenses
        [32489] = true, -- The Creeping Carpet of Ihgaluk
        [32491] = true, -- Left To Rot
        [32492] = true, -- Destroy Cauldrons
        [32493] = true, -- They All Fall Down
        [32494] = true, -- Power Play
        [32495] = true, -- The Bloodletter
        [32496] = true, -- Desecrate this Fire!
        [32497] = true, -- Honor the Flame
        [32498] = true, -- Honor the Flame
        [32499] = true, -- Honor the Flame
        [32500] = true, -- Honor the Flame
        [32501] = true, -- Honor the Flame
        [32502] = true, -- Honor the Flame
        [32503] = true, -- Desecrate this Fire!
        [32506] = true, -- A Wing to Fly On
        [32507] = true, -- Skin of the Saurok
        [32509] = true, -- Honor the Flame
        [32510] = true, -- Honor the Flame
        [32517] = true, -- The Conquest of Stone
        [32518] = true, -- Short-Supply Reward
        [32519] = true, -- Short-Supply Reward
        [32520] = true, -- Competing Magic
        [32521] = true, -- Encroaching Force
        [32522] = true, -- Imposing Threat
        [32523] = true, -- The Beast Pens
        [32524] = true, -- The Beating of Troll Drums
        [32525] = true, -- Ashes of the Enemy
        [32526] = true, -- Soul Surrender
        [32527] = true, -- Grave Circumstances
        [32528] = true, -- Into the Crypts
        [32529] = true, -- The Call of Thunder
        [32530] = true, -- The Bloodletter
        [32531] = true, -- The Conquest of Stone
        [32532] = true, -- Rise No More!
        [32533] = true, -- Stone Cold
        [32535] = true, -- The Skumblade Threat
        [32536] = true, -- Manipulating the Saurok
        [32537] = true, -- De-Constructed
        [32538] = true, -- Heinous Sacrifice
        [32539] = true, -- Dark Offerings
        [32540] = true, -- Harbingers of the Loa
        [32541] = true, -- Preventing a Future Threat
        [32542] = true, -- Surgical Strike
        [32543] = true, -- Dangers of Za'Tual
        [32544] = true, -- Pterrible Ptorment
        [32545] = true, -- The Residents of Ihgaluk
        [32546] = true, -- Just Some Light Clean-Up Work
        [32547] = true, -- The Creeping Carpet of Ihgaluk
        [32548] = true, -- Left To Rot
        [32549] = true, -- Skin of the Saurok
        [32550] = true, -- Saur Loser
        [32551] = true, -- Compy Stomp
        [32552] = true, -- Loa-saur
        [32553] = true, -- Direhorn vs Devilsaur
        [32554] = true, -- Dino Might
        [32555] = true, -- Centuries in Sentries
        [32556] = true, -- The More You Know
        [32557] = true, -- Out of Enemy Hands
        [32558] = true, -- All In the Family
        [32559] = true, -- Even Giants Fall
        [32560] = true, -- Keep It Secret
        [32561] = true, -- Competing Magic
        [32562] = true, -- Imposing Threat
        [32563] = true, -- Encroaching Force
        [32564] = true, -- Zandalari on the Rise
        [32565] = true, -- Encroaching Force
        [32567] = true, -- The Beast Pens
        [32568] = true, -- No Time To Rest
        [32570] = true, -- Gather Scout Reports
        [32571] = true, -- A Wing to Fly On
        [32572] = true, -- The Sleepless Legion
        [32573] = true, -- Enemies Beneath the Tower
        [32574] = true, -- The Shuddering Moor
        [32575] = true, -- The Zandalari Colossus
        [32576] = true, -- Competing Magic
        [32577] = true, -- Imposing Threat
        [32578] = true, -- Among the Bones
        [32579] = true, -- Competing Magic
        [32580] = true, -- Encroaching Force
        [32581] = true, -- Imposing Threat
        [32582] = true, -- Raining Bones
        [32583] = true, -- Zandalari on the Rise
        [32584] = true, -- Encroaching Force
        [32585] = true, -- Encroaching Force
        [32586] = true, -- Maximum Capacitor
        [32587] = true, -- Forge Ahead!
        [32588] = true, -- On Her Magic-ey Secret Service
        [32589] = true, -- Life Blood
        [32591] = true, -- Secrets of the First Empire
        [32592] = true, -- I Need a Champion
        [32593] = true, -- The Thunder Forge
        [32594] = true, -- Spirit of the Storm Lord
        [32595] = true, -- The Crown of Heaven
        [32596] = true, -- Echoes of the Titans
        [32597] = true, -- Heart of the Thunder King
        [32598] = true, -- A Reckoning
        [32599] = true, -- Securing A Future
        [32600] = true, -- The Zandalari Prophecy
        [32601] = true, -- Rumbles of Thunder
        [32602] = true, -- Gods and Monsters
        [32605] = true, -- Subtle Encouragement
        [32606] = true, -- Subtle Encouragement
        [32607] = true, -- Extended Shore Leave
        [32608] = true, -- Raiding the Vault
        [32609] = true, -- Rare Chest Tracking Quest
        [32610] = true, -- Rare Boss Tracking Quest
        [32611] = true, -- Rare Drop Tracking Quest
        [32613] = true, -- Giant Dinosaur Bone
        [32614] = true, -- More Giant Dinosaur Bones
        [32615] = true, -- Many More Giant Dinosaur Bones
        [32616] = true, -- A Large Pile of Giant Dinosaur Bones
        [32617] = true, -- A Mountain of Giant Dinosaur Bones
        [32621] = true, -- Lightning Steel
        [32622] = true, -- Intro Flight
        [32626] = true, -- Loot Room Key Tracking Quest
        [32627] = true, -- Charged Moganite
        [32628] = true, -- Tactical Mana Bombs
        [32629] = true, -- Thunderwing Captured Tracking Quest
        [32630] = true, -- Chief Engineer Jard's Journal
        [32631] = true, -- High Recognition
        [32632] = true, -- Made for War
        [32633] = true, -- Spellbound
        [32634] = true, -- Breaking Down the Defenses
        [32635] = true, -- Enough with the Bombs!
        [32636] = true, -- Captive Audience
        [32637] = true, -- Overpowered
        [32638] = true, -- Mana Scavengers
        [32639] = true, -- Deconstruction
        [32640] = true, -- Champions of the Thunder King
        [32641] = true, -- Champions of the Thunder King
        [32642] = true, -- Work Order: Dominance Offensive I
        [32643] = true, -- Work Order: Dominance Offensive II
        [32644] = true, -- The Assault on Shaol'mara
        [32645] = true, -- Work Order: Operation: Shieldwall I
        [32646] = true, -- Work Order: Operation: Shieldwall II
        [32647] = true, -- Work Order: Golden Lotus I
        [32648] = true, -- Work Order: Golden Lotus II
        [32649] = true, -- Work Order: Shado-Pan I
        [32650] = true, -- Work Order: Shado-Pan II
        [32652] = true, -- To the Skies!
        [32653] = true, -- Work Order: The August Celestials I
        [32654] = true, -- Tear Down This Wall!
        [32655] = true, -- A Bold Idea
        [32656] = true, -- The Fall of Shan Bu
        [32657] = true, -- Work Order: The August Celestials II
        [32658] = true, -- Work Order: The Klaxxi I
        [32659] = true, -- Work Order: The Klaxxi II
        [32666] = true, -- FLAG - Warlock - Green Fire
        [32676] = true, -- Extended Shore Leave
        [32677] = true, -- Raiding the Vault
        [32678] = true, -- Thunder Calls
        [32679] = true, -- Thunder Calls
        [32680] = true, -- The Storm Gathers
        [32681] = true, -- The Storm Gathers
        [32683] = true, -- So You Want to Be a Blacksmith...
        [32684] = true, -- You Want Fish?
        [32685] = true, -- No Fishing Pole Necessary!
        [32686] = true, -- Pristine Banner of the Mantid Empire
        [32687] = true, -- Pristine Ancient Sap Feeder
        [32688] = true, -- Pristine Praying Mantid
        [32689] = true, -- Pristine Sound Beacon
        [32690] = true, -- Pristine Remains of a Paragon
        [32691] = true, -- Pristine Mantid Lamp
        [32692] = true, -- Pristine Pollen Collector
        [32693] = true, -- Pristine Kypari Sap Container
        [32694] = true, -- Quest Reward Summary: PvP Stage 1-5
        [32695] = true, -- Quest Reward Summary: PvE Stage 0-2
        [32697] = true, -- Quest Reward Summary: PvE Stage 3
        [32698] = true, -- Quest Reward Summary: PvE Stage 4-5
        [32700] = true, -- Quest Reward Summary: PvP Stage 1-5
        [32701] = true, -- Quest Reward Summary: PvE Stage 0-2
        [32703] = true, -- Quest Reward Summary: PvE Stage 3
        [32704] = true, -- Quest Reward Summary: PvE Stage 4-5
        [32706] = true, -- Allies in the Shadows
        [32707] = true, -- Secrets in the Isle of Thunder
        [32708] = true, -- Setting the Trap
        [32709] = true, -- Allies in the Shadows
        [32710] = true, -- Something Foul is Afoot
        [32711] = true, -- Agony and Anima
        [32712] = true, -- Zao'cho the Wicked
        [32713] = true, -- Rocks Fall, People Die
        [32714] = true, -- Taming the Tempest
        [32715] = true, -- Requiem for a Queen
        [32716] = true, -- Eyes of the Thunder King
        [32720] = true, -- Choose Your Assignment
        [32721] = true, -- Choose Your Assignment
        [32722] = true, -- Forge Ahead!
        [32724] = true, -- Forge Ahead!
        [32725] = true, -- FLAG - Warlock - Reached Kanrethad
        [32726] = true, -- So You Want to Be a Blacksmith...
        [32727] = true, -- Contributed to Server Percentage Daily Tracking Quest
        [32728] = true, -- The Court of Bones
        [32729] = true, -- Za'Tual
        [32730] = true, -- Ihgaluk Crag
        [32731] = true, -- The Court of Bones
        [32732] = true, -- Ihgaluk Crag
        [32733] = true, -- Za'Tual
        [32744] = true, -- Jin'rokh Dead
        [32745] = true, -- Horridon Dead
        [32746] = true, -- Zandalari Council Dead
        [32747] = true, -- Tortos Dead
        [32748] = true, -- Maegaera Dead
        [32749] = true, -- Ji'kun Dead
        [32750] = true, -- Durumu Dead
        [32751] = true, -- Primordious Dead
        [32752] = true, -- Dark Animus Dead
        [32753] = true, -- Ra-Den Dead
        [32754] = true, -- Iron Qon Dead
        [32755] = true, -- Empyreal Queens Dead
        [32756] = true, -- Lei Shen Dead
        [32758] = true, -- Reader for the Dead Tongue
    },
    [4] = { -- Phase 4 (Patch 5.3 Escalation (Deepwind Gorge, New Scenarios, Heroic Scenarios))
        [32805] = true, -- Celestial Blessings
        [32806] = true, -- The King and the Council
        [32807] = true, -- The Warchief and the Darkness
        [32808] = true, -- A Little Field Work
        [32809] = true, -- Gathering Intelligence
        [32810] = true, -- The Darkspear Rebellion
        [32811] = true, -- Battlefield: Barrens
        [32812] = true, -- The Darkspear Rebellion
        [32813] = true, -- Battle of Sen'jin Village
        [32814] = true, -- Battle of Razor Hill
        [32815] = true, -- The Old Seer
        [32816] = true, -- Path of the Last Emperor
        [32819] = true, -- Battlefield: Barrens
        [32871] = true, -- Vol'jin of the Darkspear
        [32900] = true, -- Heroic Deeds
        [32901] = true, -- Heroic Deeds
    },
    [5] = { -- Phase 5 (Patch 5.4 Siege of Orgrimmar (Raid, Timeless Isle, Proving Grounds)
        [32919] = true, -- Short-Supply Reward
        [32922] = true, -- Short-Supply Reward
        [32923] = true, -- Short-Supply Reward
        [32924] = true, -- Short-Supply Reward
        [32942] = true, -- Work Order: Sunreaver Onslaught I
        [32943] = true, -- Work Order: Sunreaver Onslaught II
        [32944] = true, -- Work Order: Kirin Tor Offensive I
        [32945] = true, -- Work Order: Kirin Tor Offensive II
        [32949] = true, -- Tracking Quest: Guru Kukuru
        [32956] = true, -- Tracking Quest - Spectral Pirate Treasure
        [32957] = true, -- Sunken Hozen Treasure - Tracking Quest
        [32959] = true, -- Tracking Quest - Daily - Zhu-Gon the Sour/Skunky Beer
        [32960] = true, -- Cave-In - Tracking Quest
        [32961] = true, -- Scary Ghosts and Nice Sprites - Tracking Quest
        [32962] = true, -- \"Tom\" Bone Apart - Tracking Quest
        [32964] = true, -- Tracking Quest: Ghost Pirate Battle - Completed
        [32965] = true, -- Tracking Quest: Ghost Pirate Battle - Looted Treasure
        [32966] = true, -- Tracking Quest - Daily - Chelon
        [32967] = true, -- Tracking Quest - Daily - Cranegnasher
        [32968] = true, -- Rope Drop Tracking Quest
        [32969] = true, -- Pillar Hopping Tracking Quest
        [32970] = true, -- Pirate Ship Mast Tracking Quest
        [32971] = true, -- Feather Fall Tracking Quest
        [32972] = true, -- Avatar of Flame Transform Tracking Quest
        [32973] = true, -- Avatar of Flame Kill Tracking Quest
        [32974] = true, -- Rolo's Riddle
        [32975] = true, -- Rolo's Riddle
        [32976] = true, -- Rolo's Riddle
        [32997] = true, -- Tracking Quest - First - Zesqua
        [33018] = true, -- Noodle Secrets Long Forgotten
        [33020] = true, -- The Lost Secret of the Secret Ingredient
        [33021] = true, -- Secrets Lost, Forever?
        [33022] = true, -- Catch and Carry
        [33025] = true, -- NC S2 Q2
        [33027] = true, -- The Secret Ingredient Is...
        [33047] = true, -- Short-Supply Reward
        [33089] = true, -- FLAG - Proving Grounds - Damage Bronze
        [33090] = true, -- FLAG - Proving Grounds - Damage Silver
        [33091] = true, -- FLAG - Proving Grounds - Damage Gold
        [33092] = true, -- FLAG - Proving Grounds - Tank Bronze
        [33093] = true, -- FLAG - Proving Grounds - Tank Silver
        [33094] = true, -- FLAG - Proving Grounds - Tank Gold
        [33095] = true, -- FLAG - Proving Grounds - Healer Bronze
        [33096] = true, -- FLAG - Proving Grounds - Healer Silver
        [33097] = true, -- FLAG - Proving Grounds - Healer Gold
        [33100] = true, -- The Emperor's Way
        [33104] = true, -- A Pandaren Legend
        [33105] = true, -- Judgment of the Black Prince
        [33107] = true, -- Bad Feeling, Worse Result
        [33109] = true, -- Short-Supply Reward
        [33117] = true, -- Short-Supply Reward
        [33118] = true, -- Short-Supply Reward
        [33124] = true, -- Fishing with Fin - Tracking Quest
        [33133] = true, -- Warforged Seals
        [33134] = true, -- Warforged Seals
        [33136] = true, -- The Rainy Day is Here
        [33137] = true, -- The Celestial Tournament
        [33138] = true, -- Why Do We Fight?
        [33139] = true, -- Secrets Lost, Forever?
        [33146] = true, -- Noodle Time
        [33147] = true, -- The Last Gasp of Y'Shaarj
        [33156] = true, -- Time Keeper Kairoz
        [33160] = true, -- Time Keeper Kairoz
        [33161] = true, -- A Timeless Tour
        [33162] = true, -- Weekly Vignette Boss Kill - Tracking Quest
        [33163] = true, -- Weekly Vignette Loot Chest - Tracking Quest
        [33164] = true, -- Weekly Vignette Event Compeltion - Tracking Quest
        [33170] = true, -- One-Time Chest 000
        [33171] = true, -- One-Time Chest 001
        [33172] = true, -- One-Time Chest 002
        [33173] = true, -- One-Time Chest 003
        [33174] = true, -- One-Time Chest 004
        [33175] = true, -- One-Time Chest 005
        [33176] = true, -- One-Time Chest 006
        [33177] = true, -- One-Time Chest 007
        [33178] = true, -- One-Time Chest 008
        [33179] = true, -- One-Time Chest 009
        [33180] = true, -- One-Time Chest 010
        [33181] = true, -- One-Time Chest 011
        [33182] = true, -- One-Time Chest 012
        [33183] = true, -- One-Time Chest 013
        [33184] = true, -- One-Time Chest 014
        [33185] = true, -- One-Time Chest 015
        [33186] = true, -- One-Time Chest 016
        [33187] = true, -- One-Time Chest 017
        [33188] = true, -- One-Time Chest 018
        [33189] = true, -- One-Time Chest 019
        [33190] = true, -- One-Time Chest 020
        [33191] = true, -- One-Time Chest 021
        [33192] = true, -- One-Time Chest 022
        [33193] = true, -- One-Time Chest 023
        [33194] = true, -- One-Time Chest 024
        [33195] = true, -- One-Time Chest 025
        [33196] = true, -- One-Time Chest 026
        [33197] = true, -- One-Time Chest 027
        [33198] = true, -- One-Time Chest - Stump Center
        [33199] = true, -- One-Time Chest - Stump SW Shore
        [33200] = true, -- One-Time Chest - Stump West
        [33201] = true, -- One-Time Chest - Ordo Lake Lower
        [33202] = true, -- One-Time Chest - Steam Shore
        [33203] = true, -- One-Time Chest - Cavern of Lost Spirits
        [33204] = true, -- One-Time Chest - Carry Bird 2
        [33205] = true, -- One-Time Chest - Carry Bird 1
        [33206] = true, -- One-Time Chest - Gulp Frogs
        [33207] = true, -- One-Time Chest - Hammer Cavern
        [33208] = true, -- One-Time Chest - Ordo Chest 000
        [33209] = true, -- One-Time Chest - Ordo Chest 001
        [33210] = true, -- One-Time Chest - Blazing Chest
        [33211] = true, -- A Timeless Question
        [33216] = true, -- One-Time Chest - T1G1
        [33217] = true, -- One-Time Chest - T1G2
        [33218] = true, -- One-Time Chest - T1G3
        [33219] = true, -- One-Time Chest - T1G4
        [33220] = true, -- One-Time Chest - T2
        [33221] = true, -- One-Time Chest - T3
        [33222] = true, -- Little Tommy Newcomer
        [33225] = true, -- Short-Supply Reward
        [33226] = true, -- Short-Supply Reward
        [33227] = true, -- One-Time Chest 028
        [33228] = true, -- Time In Your Hands
        [33229] = true, -- A Flash of Bronze...
        [33230] = true, -- A Flash of Bronze...
        [33231] = true, -- Journey to the Timeless Isle
        [33232] = true, -- Journey to the Timeless Isle
        [33233] = true, -- Short-Supply Reward
        [33234] = true, -- Meaty Crane Leg
        [33235] = true, -- Great Turtle Meat
        [33236] = true, -- Heavy Yak Flank
        [33238] = true, -- Thick Tiger Haunch
        [33239] = true, -- Pristine Firestorm Egg
        [33248] = true, -- Proving Grounds - Available on release?
        [33249] = true, -- Proving Grounds - Available on release?
        [33250] = true, -- A Time-Lost Treasure
        [33257] = true, -- Sprite Fright - Tracking Quest
        [33258] = true, -- Tracking Quest - First - Karkanos
        [33259] = true, -- Tracking Quest - First - Spirit of Jadefire
        [33260] = true, -- Tracking Quest - First - Gu'chi the Swarmbringer
        [33261] = true, -- Tracking Quest - First - Emerald Gander
        [33270] = true, -- Tracking Quest - First - Ironfur Steelhorn
        [33272] = true, -- Tracking Quest - First - Great Turtle Furyshell
        [33273] = true, -- Tracking Quest - First - Leafmender
        [33274] = true, -- Tracking Quest - First - Champion of the Black Flame
        [33275] = true, -- Tracking Quest - First - Garnia
        [33276] = true, -- Tracking Quest - First - Bufo
        [33277] = true, -- Tracking Quest - First - Monstrous Spineclaw
        [33278] = true, -- Tracking Quest - First - Imperial Python
        [33279] = true, -- Tracking Quest - First - Tsavo'ka
        [33280] = true, -- Tracking Quest - First - Stinkbraid
        [33281] = true, -- Tracking Quest - First - Jakur of Ordon
        [33283] = true, -- Tracking Quest - First - Rock Moss
        [33284] = true, -- Tracking Quest - First - Urdur the Cauterizer
        [33285] = true, -- Tracking Quest - First - Flintlord Gairan
        [33286] = true, -- Tracking Quest - First - Cinderfall
        [33287] = true, -- Tracking Quest - First - Huolon
        [33288] = true, -- Tracking Quest - First - Archiereus of Flame
        [33289] = true, -- Tracking Quest - First - Evermaw
        [33290] = true, -- Tracking Quest - First - Dread Ship Vazuvius
        [33291] = true, -- Tracking Quest - First - Golganarr
        [33292] = true, -- Tracking Quest - Daily - Karkanos
        [33293] = true, -- Tracking Quest - Daily - Spirit of Jadefire
        [33294] = true, -- Tracking Quest - Daily - Gu'chi the Swarmbringer
        [33295] = true, -- Tracking Quest - Daily - Emerald Gander
        [33296] = true, -- Tracking Quest - Daily - Ironfur Steelhorn
        [33297] = true, -- Tracking Quest - Daily - Great Turtle Furyshell
        [33298] = true, -- Tracking Quest - Daily - Leafmender
        [33299] = true, -- Tracking Quest - Daily - Champion of the Black Flame
        [33300] = true, -- Tracking Quest - Daily - Garnia
        [33301] = true, -- Tracking Quest - Daily - Bufo
        [33302] = true, -- Tracking Quest - Daily - Monstrous Spineclaw
        [33303] = true, -- Tracking Quest - Daily - Imperial Python
        [33304] = true, -- Tracking Quest - Daily - Tsavo'ka
        [33305] = true, -- Tracking Quest - Daily - Stinkbraid
        [33306] = true, -- Tracking Quest - Daily - Jakur of Ordon
        [33307] = true, -- Tracking Quest - Daily - Rock Moss
        [33308] = true, -- Tracking Quest - Daily - Urdur the Cauterizer
        [33309] = true, -- Tracking Quest - Daily - Flintlord Gairan
        [33310] = true, -- Tracking Quest - Daily - Cinderfall
        [33311] = true, -- Tracking Quest - Daily - Huolon
        [33312] = true, -- Tracking Quest - Daily - Archiereus of Flame
        [33313] = true, -- Tracking Quest - Daily - Evermaw
        [33314] = true, -- Tracking Quest - Daily - Dread Ship Vazuvius
        [33315] = true, -- Tracking Quest - Daily - Golganarr
        [33316] = true, -- Tracking Quest - Daily - Zesqua
        [33317] = true, -- Tracking Quest - First - Zhu-Gon the Bitter/Skunky Beer
        [33318] = true, -- Tracking Quest - First - Chelon
        [33319] = true, -- Tracking Quest - First - Cranegnasher
        [33321] = true, -- Tracking Quest - First - Watcher Osu
        [33322] = true, -- Tracking Quest - Daily - Watcher Osu
        [33332] = true, -- Hints From The Past
        [33333] = true, -- Timeless Treasures
        [33334] = true, -- Strong Enough To Survive
        [33335] = true, -- The Last Emperor
        [33336] = true, -- The Essence of Time
        [33337] = true, -- A Vision in Time
        [33338] = true, -- Empowering the Hourglass
        [33340] = true, -- Timeless Nutriment
        [33341] = true, -- Wayshrines Of The Celestials
        [33342] = true, -- Drive Back The Flame
        [33343] = true, -- The Archiereus Of Flame
        [33345] = true, -- Dark Shaman Weekly Attempt
        [33348] = true, -- \"Tom\" Bone Apart - Intro Tracking Quest
        [33358] = true, -- Noodle Time: Bonus
        [33360] = true, -- 5.4 Raid - RRP - Boss 1 Legendary Quest
        [33361] = true, -- 5.4 Raid - RRP - Boss 2 Legendary Quest
        [33362] = true, -- 5.4 Raid - RRP - Boss 3 Legendary Quest
        [33363] = true, -- 5.4 Raid - RRP - Boss 4 Legendary Quest
        [33364] = true, -- 5.4 Raid - RRP - Boss 5 Legendary Quest
        [33365] = true, -- 5.4 Raid - RRP - Boss 6 Legendary Quest
        [33366] = true, -- 5.4 Raid - RRP - Boss 7 Legendary Quest
        [33367] = true, -- 5.4 Raid - RRP - Boss 8 Legendary Quest
        [33368] = true, -- 5.4 Raid - RRP - Boss 9 Legendary Quest
        [33369] = true, -- 5.4 Raid - RRP - Boss 10 Legendary Quest
        [33370] = true, -- 5.4 Raid - RRP - Boss 11 Legendary Quest
        [33371] = true, -- 5.4 Raid - RRP - Boss 12 Legendary Quest
        [33372] = true, -- 5.4 Raid - RRP - Boss 13 Legendary Quest
        [33373] = true, -- 5.4 Raid - RRP - Boss 14 Legendary Quest
        [33374] = true, -- Path of the Mistwalker
        [33375] = true, -- Refining The Vision
        [33376] = true, -- Seeking Fate
        [33377] = true, -- Hidden Threads
        [33378] = true, -- Courting Destiny
        [33379] = true, -- One Final Turn
        [33385] = true, -- Kairoz Weekly Tracking Quest
        [33602] = true, -- Short-Supply Reward
        [33603] = true, -- Short-Supply Reward
        [34060] = true, -- Krasarang RRP - Daily Vignette - Rogue Boss
        [34061] = true, -- Krasarang RRP - Daily Vignette - Priest Boss
        [34062] = true, -- Krasarang RRP - Daily Vignette - Warrior Boss
    },
}

---@param questsToBlacklist table<QuestId, boolean>
---@param contentPhase number
---@return table<QuestId, boolean>
function ContentPhases.BlacklistMoPQuestsByPhase(questsToBlacklist, contentPhase)
    for phase = contentPhase + 1, #questsToBlacklistByPhase do
        for questId in pairs(questsToBlacklistByPhase[phase]) do
            questsToBlacklist[questId] = true
        end
    end

    return questsToBlacklist
end
