---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")

-- Different source of zoneIds
-- These are not in use anymore but are quite helpful when fixing the database
-- https://www.ownedcore.com/forums/world-of-warcraft/world-of-warcraft-emulator-servers/60411-zone-ids.html
---@enum ZoneIDs
ZoneDB.zoneIDs = {
    DUN_MOROGH = 1,
    BADLANDS = 3,
    BLASTED_LANDS = 4,
    SWAMP_OF_SORROWS = 8,
    DUSKWOOD = 10,
    WETLANDS = 11,
    ELWYNN_FOREST = 12,
    DUROTAR = 14,
    DUSTWALLOW_MARSH = 15,
    AZSHARA = 16,
    THE_BARRENS = 17, -- This is also Northern Barrens in Cata
    WESTERN_PLAGUELANDS = 28,
    STRANGLETHORN_VALE = 33, -- This is also Northern Stranglethorn in Cata
    ALTERAC_MOUNTAINS = 36,
    LOCH_MODAN = 38,
    WESTFALL = 40,
    DEADWIND_PASS = 41,
    REDRIDGE_MOUNTAINS = 44,
    ARATHI_HIGHLANDS = 45,
    BURNING_STEPPES = 46,
    THE_HINTERLANDS = 47,
    SEARING_GORGE = 51,
    DRAGONBLIGHT = 65,
    ZUL_DRAK = 66,
    STORM_PEAKS = 67,
    TIRISFAL_GLADES = 85,
    SILVERPINE_FOREST = 130,
    NEW_TINKERTOWN_OLD = 133,
    FROSTMANE_HOLD = 135,
    EASTERN_PLAGUELANDS = 139,
    TELDRASSIL = 141,
    STONEWROUGHT_DAM = 146,
    DARKSHORE = 148,
    NIGHTS_WEB_HOLLOW = 155,
    UTGARDE_KEEP = 206, -- this is also Njordir Preparation map for Utgarde Keep
    SHADOWFANG_KEEP = 209, -- this is also The Courtyard map for Shadowfang Keep
    ICECROWN = 210,
    MULGORE = 215,
    SHADOWTHREAD_CAVE = 257,
    HILLSBRAD_FOOTHILLS = 267,
    ASHENVALE = 331,
    FERALAS = 357,
    FELWOOD = 361,
    BURNING_BLADE_COVEN = 365,
    RATCHET = 392,
    GRIZZLY_HILLS = 394,
    THOUSAND_NEEDLES = 400,
    DESOLACE = 405,
    STONETALON_MOUNTAINS = 406,
    TANARIS = 440,
    AUBERDINE = 442,
    UN_GORO_CRATER = 490,
    RAZORFEN_KRAUL = 491,
    MOONGLADE = 493,
    HOWLING_FJORD = 495,
    MOUNT_HYJAL = 616,
    WINTERSPRING = 618,
    THE_STOCKADE = 717,
    WAILING_CAVERNS = 718,
    BLACKFATHOM_DEEPS = 719, -- this is also The Pool of Ask'Ar map for Blackfathom Deeps
    GNOMEREGAN = 721, -- this is also The Hall of Gears map for Gnomeregan
    RAZORFEN_DOWNS = 722,
    SCARLET_MONASTERY = 796, -- this is also Graveyard map for Scarlet Monastery
    CHILL_BREEZE_VALLEY = 801,
    ZUL_FARRAK = 1176,
    UTGARDE_PINNACLE = 1196, -- this is also Upper Pinnacle map for Utgarde Pinnacle
    ULDAMAN = 1337, -- this is also Hall of the Keepers map for Uldaman
    SILITHUS = 1377,
    SUNKEN_TEMPLE = 1417,
    THE_TEMPLE_OF_ATAL_HAKKAR = 1477,
    UNDERCITY = 1497,
    STORMWIND_CITY = 1519,
    IRONFORGE = 1537,
    THE_DEADMINES = 1581, -- this is also The Deadmines map for The Deadmines
    LOWER_BLACKROCK_SPIRE = 1583, -- this is also Hall of Blackhand map for Blackrock Spire
    BLACKROCK_DEPTHS = 1584, -- this is also Detention Block map for Blackrock Depths
    ORGRIMMAR = 1637,
    THUNDER_BLUFF = 1638,
    DARNASSUS = 1657,
    CAVERNS_OF_TIME = 1941,
    ZUL_GURUB = 1977,
    STRATHOLME = 2017, -- this is also Crusader's Square map for Stratholme
    SCHOLOMANCE = 2057, -- this is also The Reliquary map for Scholomance
    ALCAZ_ISLAND = 2079,
    MARAUDON = 2100, -- this is also Caverns of Maraudon map for Maraudon
    ONYXIAS_LAIR = 2159,
    DEEPRUN_TRAM = 2257,
    THE_BLACK_MORASS = 2366,
    OLD_HILLSBRAD_FOOTHILLS = 2367,
    RAGEFIRE_CHASM = 2437,
    DIRE_MAUL = 2557,
    ALTERAC_VALLEY = 2597,
    BLACKWING_LAIR = 2677,
    MOLTEN_CORE = 2717,
    CRYSTALSONG_FOREST = 2817,
    HALL_OF_LEGENDS = 2917,
    CHAMPIONS_HALL = 2918,
    WARSONG_GULCH = 3277,
    ARATHI_BASIN = 3358,
    AHN_QIRAJ = 3428, -- this is also The Temple Gates map for AQ40
    RUINS_OF_AHN_QIRAJ = 3429,
    EVERSONG_WOODS = 3430,
    GHOSTLANDS = 3433,
    NAXXRAMAS = 3456, -- this is also The Lower Necropolis map for Naxxramas
    KARAZHAN = 3457,
    HELLFIRE_PENINSULA = 3483,
    SILVERMOON_CITY = 3487,
    NAGRAND = 3518,
    TEROKKAR_FOREST = 3519,
    SHADOWMOON_VALLEY = 3520,
    ZANGARMARSH = 3521,
    BLADES_EDGE_MOUNTAINS = 3522,
    NETHERSTORM = 3523,
    AZUREMYST_ISLE = 3524,
    BLOODMYST_ISLE = 3525,
    BOREAN_TUNDRA = 3537,
    THE_EXODAR = 3557,
    HELLFIRE_RAMPARTS = 3562,
    HELLFIRE_CITADEL = 3563, -- we need to use this id
    HYJAL_SUMMIT = 3606,
    SERPENTSHRINE_CAVERN = 3607,
    SKETTIS = 3679,
    AUCHINDOUN = 3688,
    SHATTRATH_CITY = 3703,
    SHOLAZAR_BASIN = 3711,
    THE_BLOOD_FURNACE = 3713,
    THE_SHATTERED_HALLS = 3714,
    THE_STEAMVAULT = 3715,
    THE_UNDERBOG = 3716,
    THE_SLAVE_PENS = 3717,
    SHADOW_LABYRINTH = 3789,
    AUCHENAI_CRYPTS = 3790, -- this is also Halls of the Hereafter map for Auchenai Crypts
    SETHEKK_HALLS = 3791, -- this is also Veil Sethekk map for Sethekk Halls
    MANA_TOMBS = 3792,
    ZUL_AMAN = 3805,
    MAGTHERIDONS_LAIR = 3836,
    TEMPEST_KEEP = 3845,
    THE_BOTANICA = 3847,
    THE_ARCATRAZ = 3848, -- this is also Stasis Block: Trion map in The Arcatraz
    THE_MECHANAR = 3849, -- this is also The Mechanar map for The Mechanar
    COILFANG_RESERVOIR = 3905,
    AUCHINDOUN_DUNGEONS = 3917,
    BLACK_TEMPLE = 3959,
    THE_FROZEN_SEA = 3979,
    SUNWELL_PLATEAU = 4075,
    ISLE_OF_QUEL_DANAS = 4080,
    THE_CULLING_OF_STRATHOLME = 4100,
    MAGISTERS_TERRACE = 4131, -- this is also Observation Grounds map for Magisters' Terrace
    DRAKTHARON_KEEP = 4196, -- this is also The Vestibules of Drak'Tharon map for Drak'Tharon Keep
    WINTERGRASP = 4197,
    THE_OCULUS = 4228, -- this is also Band of Variance map for The Oculus
    HALLS_OF_STONE = 4264,
    THE_NEXUS = 4265,
    HALLS_OF_LIGHTNING = 4272, -- this is also Unyielding Garrison map for Halls of Lightning
    ULDUAR = 4273,
    AZJOL_NERUB = 4277, -- this is also The Gilded Gate map for Azjol-Nerub
    ACHERUS_THE_EBON_HOLD = 4281,
    PLAGUELANDS_THE_SCARLET_ENCLAVE = 4298,
    NEW_AVALON = 4343, -- SoD (might be the wrong ID)
    DALARAN = 4395,
    VIOLET_HOLD = 4415,
    GUNDRAK = 4416, -- this is also Upper Level map for Gundrak, and in Cata+ it is the only map of the dungeon
    AHNKAHET_THE_OLD_KINGDOM = 4494,
    THE_UNDERBELLY = 4560,
    THE_ARCHIVUM = 4657,
    RUINS_OF_GILNEAS = 4706,
    SOUTHERN_BARRENS = 4709,
    GILNEAS = 4714,
    THE_LOST_ISLES = 4720,
    TRIAL_OF_THE_CRUSADER = 4722,
    TRIAL_OF_THE_CHAMPION = 4723,
    EMBERSTONE_MINE = 4732, -- Cave in Gilneas (Worgen starting zone)
    KEZAN = 4737,
    THE_SILVER_ENCLAVE = 4740,
    HROTHGARS_LANDING = 4742,
    GILNEAS_CITY = 4755,
    KAJA_MINE = 4766, -- Cave in Kezan (North)
    KAJA_MINE_CAVERN = 4778, -- Cave in The Lost Isles
    FORGE_OF_SOULS = 4809,
    ICECROWN_CITADEL = 4812, -- this is also The Lower Citadel map for Icecrown Citadel
    PIT_OF_SARON = 4813,
    KELP_THAR_FOREST = 4815,
    GREYMANE_MANOR_MAIN_FLOOR = 4817,
    HALLS_OF_REFLECTION = 4820,
    SPITESCALE_CAVERN = 4913,
    TWILIGHT_HIGHLANDS = 4922,
    BLACKROCK_CAVERNS = 4926,
    THE_RUBY_SANCTUM = 4987,
    ULDUM = 5034,
    THE_VORTEX_PINNACLE = 5035,
    DEEPHOLM = 5042,
    TOL_BARAD = 5095, -- the southern isle
    SHIMMERING_EXPANSE = 5144, -- Vashj'ir sub zone
    ABYSSAL_DEPTHS = 5145, -- Vashj'ir sub zone
    VASHJ_IR = 5146,
    THE_CAPE_OF_STRANGLETHORN = 5287,
    STRANGLETHORN_COMPOSITE_MAP = 5339, -- this is the composite map of Northern Stranglethorn and The Cape of Stranglethorn (1 level higher)
    TOL_BARAD_PENINSULA = 5389, -- the northern isle
    THE_MAELSTROM = 5416,
    MOLTEN_FRONT = 5733,
    THE_WANDERING_ISLE = 5736,
    THE_JADE_FOREST = 5785,
    THE_NEXUS_LEGENDARY = 5786,
    WELL_OF_ETERNITY = 5788,
    END_TIME = 5789, -- this is also End Time map for End Time
    END_TIME_RUBY_DRAGONSHRINE = 5790,
    END_TIME_OBSIDIAN_DRAGONSHRINE = 5792,
    END_TIME_AZURE_DRAGONSHRINE = 5793,
    END_TIME_EMERALD_DRAGONSHRINE = 5794,
    END_TIME_BRONZE_DRAGONSHRINE = 5795,
    VALLEY_OF_THE_FOUR_WINDS = 5805,
    VALE_OF_ETERNAL_BLOSSOMS = 5840,
    KUN_LAI_SUMMIT = 5841,
    TOWNLONG_STEPPES = 5842,
    HOUR_OF_TWILIGHT = 5844, -- this is also Hour of Twilight map for Hour of Twilight
    DARKMOON_FAIRE_ISLAND = 5861,
    SHADO_PAN_MONASTERY = 5918,
    GREENSTONE_QUARRY = 5955, -- Cave in The Jade Forest -- Upper Quarry
    TEMPLE_OF_THE_JADE_SERPENT = 5956, -- Dungeon
    STORMSTOUT_BREWERY = 5963, -- Dungeon
    GATE_OF_THE_SETTING_SUN = 5976,
    THE_HALFHILL_MARKET = 5981,
    THE_VEILED_STAIR = 6006,
    SCARLET_HALLS = 6052, -- this is also Training Grounds map for Scarlet Halls (MoP)
    SCHOLOMANCE_MOP = 6066, -- this is also The Reliquary map for Scholomance (MoP)
    TERRACE_OF_ENDLESS_SPRING = 6067,
    GUO_LAI_HALLS = 6074, -- Cave in Vale of Eternal Blossoms
    PEAK_OF_SERENITY = 6081,
    THE_DEEPER = 6084, -- Cave in Kun-Lai Summit
    KNUCKLETHUMP_HOLE = 6088, -- Cave in Kun-Lai Summit
    PRANKSTERS_HOLLOW = 6099, -- Cave in Kun-Lai Summit
    A_BREWING_STORM = 6101, -- Scenario
    SCARLET_MONASTERY_MOP = 6109, -- Scarlet Monastery MoP
    MOGUSHAN_VAULTS = 6125, -- Dais of Conquerors
    KRASARANG_WILDS = 6134,
    FROSTMANE_HOVEL = 6137,
    DREAD_WASTES = 6138,
    SHRINE_OF_TWO_MOONS = 6141,
    SHRINE_OF_SEVEN_STARS = 6142,
    NORTHSHIRE = 6170,
    COLDSHIRE_VALLEY = 6176,
    MOGUSHAN_PALACE = 6182,
    TOMB_OF_CONQUERORS = 6201, -- Cave in Kun-Lai Summit
    GREENSTONE_VILLAGE = 6209, -- Scenario
    NIUZAO_CATACOMBS = 6213, -- Cave in Townlong Steppes
    SIEGE_OF_NIUZAO_TEMPLE = 6214,
    ARENA_OF_ANNIHILATION = 6219,
    HEART_OF_FEAR = 6297,
    BRAWLGAR_ARENA = 6298,
    UNGA_INGOO = 6309, -- Scenario
    SCARLET_MONASTERY_MOP_FORLORN_CLOISTER = 6384,
    SCARLET_MONASTERY_MOP_CRUSADERS_CHAPEL = 6386,
    HOWLINGWIND_CAVERN = 6389, -- Cave in Kun-Lai Summit
    BREWMOON_FESTIVAL = 6426, -- Scenario
    SHADOWGLEN = 6450,
    VALLEY_OF_TRIALS = 6451,
    CAMP_NARACHE = 6452,
    ECHO_ISLES = 6453,
    DEATHKNELL = 6454,
    SUNSTRIDER_ISLE = 6455,
    AMMEN_VALE = 6456,
    NEW_TINKERTOWN = 6457,
    CAVERN_OF_ENDLESS_ECHOES = 6466,
    MOGUSHAN_PALACE_THE_CRIMSON_ASSEMBLY_HALL = 6471, -- 453
    MOGUSHAN_PALACE_VAULTS_OF_KINGS_PAST = 6473, -- 454
    MOGUSHAN_PALACE_THRONE_OF_ANCIENT_CONQUERORS = 6474, -- 455
    ISLE_OF_THUNDER = 6507,
    THE_WIDOWS_WAIL = 6512, -- cave in The Jade Forest
    OONA_KAGU = 6513, -- cave in The Jade Forest
    GREYMANE_MANOR_UPPER_FLOOR = 6545,
    RUINS_OF_OGUDEI_ALLIANCE_EXCAVATION = 6609, -- Ruins of Ogudei - cave in Krasarang Wilds
    DALARAN_LANDFALL = 6611,
    A_LITTLE_PATIENCE = 6616, -- Scenario
    BIZMOS_BRAWLPUB = 6618,
    ISLE_OF_GIANTS = 6661,
    TIMELESS_ISLE = 6757,
    UPPER_BLACKROCK_SPIRE = 7307,

    -- Fake IDs for dungeons
    MARAUDON_ZAETARS_GRAVE = 10000, -- 281
    STRATHOLME_THE_GAUNTLET = 10001, -- 318
    BLACKROCK_DEPTHS_SHADOWFORGE_CITY = 10002, -- 243
    BLACKROCK_SPIRE_TAZZ_ALOR = 10003, -- 250
    BLACKROCK_SPIRE_SKITTERWEB_TUNNELS = 10004, -- 251
    BLACKROCK_SPIRE_HORDEMAR_CITY = 10005, -- 252
    BLACKROCK_SPIRE_HALYCONS_LAIR = 10006, -- 254
    BLACKROCK_SPIRE_CHAMBER_OF_BATTLE = 10007, -- 255
    SCARLET_MONASTERY_LIBRARY = 10008, -- 303
    SCARLET_MONASTERY_ARMORY = 10009, -- 304
    SCARLET_MONASTERY_CATHEDRAL = 10010, -- 305
    SCHOLOMANCE_CHAMBER_OF_SUMMONING = 10011, -- 307
    SCHOLOMANCE_THE_UPPER_STUDY = 10012, -- 308
    SCHOLOMANCE_HEADMASTERS_STUDY = 10013, -- 309
    SHADOWFANG_KEEP_DINING_HALL	= 10014, -- 311
    SHADOWFANG_KEEP_THE_VACANT_DEN	= 10015, -- 312
    SHADOWFANG_KEEP_LOWER_OBSERVATORY = 10016, -- 313
    SHADOWFANG_KEEP_UPPER_OBSERVATORY = 10017, -- 314
    SHADOWFANG_KEEP_LORD_GOFREYS_CHAMBER = 10018, -- 315
    SHADOWFANG_KEEP_THE_WALL_WALK = 10019, -- 316
    BLACKFATHOM_DEEPS_MOONSHRINE_SANCTUM = 10020, -- 222
    BLACKFATHOM_DEEPS_THE_FORGOTTEN_POOL = 10021, -- 223
    DIRE_MAUL_GORDOK_COMMONS = 10022, -- 235
    DIRE_MAUL_CAPITAL_GARDENS = 10023, -- 236
    DIRE_MAUL_COURT_OF_THE_HIGHBORNE = 10024, -- 237
    DIRE_MAUL_PRISON_OF_IMMOLTHAR = 10025, -- 238
    DIRE_MAUL_WARPWOOD_QUARTER = 10026, -- 239
    DIRE_MAUL_THE_SHRINE_OF_ELDRETHARR = 10027, -- 240
    MAGISTERS_TERRACE_GRAND_MAGISTERS_ASYLUM = 10028, -- 348
    THE_DEADMINES_IRONCLAD_COVE = 10029, -- 292
    GNOMEREGAN_THE_DORMITORY = 10030, -- 227
    GNOMEREGAN_LAUNCH_BAY = 10031, -- 228
    GNOMEREGAN_TINKERS_COURT = 10032, -- 229
    ULDAMAN_KHAZ_GOROTHS_SEAT = 10033, -- 231
    HOUR_OF_TWILIGHT_WYRMREST_TEMPLE = 10039, -- 400
    AQ40_THE_HIVE_UNDERGROUNDS = 10040, -- 319
    AQ40_VAULT_OF_CTHUN = 10041, -- 321
    SETHEKK_HALLS_HALLS_OF_MOURNING = 10042, -- 259
    AUCHENAI_CRYPTS_BRIDGE_OF_SOULS = 10043, -- 257
    THE_MECHANAR_CALCULATION_CHAMBER = 10044, -- 268
    THE_ARCATRAZ_STASIS_BLOCK_MAXIMUS = 10045, -- 270
    THE_ARCATRAZ_CONTAINMENT_CORE = 10046, -- 271
    BAND_OF_ACCELERATION = 10047, -- 144
    BAND_OF_TRANSMUTATION = 10048, -- 145
    BAND_OF_ALIGNMENT = 10049, -- 146
    THE_DESCENT_OF_MADNESS = 10050, -- 150
    THE_SPARK_OF_IMAGINATION = 10051, -- 151
    THE_INNER_SANCTUM_OF_ULDUAR = 10052, -- 149
    UTGARDE_PINNACLE_LOWER_LEVEL = 10053, -- 136
    THE_TERRESTRIAL_WATCHTOWER = 10054, -- 139
    THE_BROOD_PIT = 10055, -- 157
    HADRONOXS_LAIR = 10056, -- 158
    UTGARDE_KEEP_MIDDLE_LEVEL = 10057, -- 134
    UTGARDE_KEEP_UPPER_LEVEL = 10058, -- 135
    THE_CULLING_OF_STRATHOLME_CITY = 10059, -- 131
    DRAKTHARON_KEEP_UPPER_LEVEL = 10060, -- 161
    GUNDRAK_LOWER_LEVEL = 10061, -- 153
    NAXXRAMAS_CONSTRUCT_QUARTER = 10062, -- 162
    NAXXRAMAS_ARACHNID_QUARTER = 10063, -- 163
    NAXXRAMAS_MILITARY_QUARTER = 10064, -- 164
    NAXXRAMAS_PLAGUE_QUARTER = 10065, -- 165
    NAXXRAMAS_FROSTWYRM_LAIR = 10066, -- 167
    ICECROWN_CITADEL_UPPER_SPIRE = 10067, -- 190
    ICECROWN_CITADEL_QUEEN_LANA_THEL = 10068, -- 191
    ICECROWN_CITADEL_SINDRAGOSA = 10069, -- 189
    ICECROWN_CITADEL_RAMPART_OF_SKULLS = 10070, -- 187
    ICECROWN_CITADEL_DEATHBRINGERS_RISE = 10071, -- 188
    ICECROWN_CITADEL_THE_FROZEN_THRONE = 10072, -- 192
    SCARLET_HALLS_ATHENAEUM = 10076, -- 432
    SCHOLOMANCE_MOP_CHAMBER_OF_SUMMONING = 10077, -- 477
    SCHOLOMANCE_MOP_THE_UPPER_STUDY = 10078, -- 478
    SCHOLOMANCE_MOP_HEADMASTERS_STUDY = 10079, -- 479
    GUO_LAI_HALLS_THE_HALL_OF_THE_SERPENT = 10080, -- 396
    GREENSTONE_QUARRY_LOWER = 10081, -- 373
    SHRINE_OF_TWO_MOONS_TOP_FLOOR = 10082, -- 392
    SHRINE_OF_SEVEN_STARS_TOP_FLOOR = 10083, -- 394
    THE_DEEPER_LOWER_LEVEL = 10084, -- cave in Kun_Lai Summit -- 384
    RUINS_OF_OGUDEI = 10085, -- Ruins of Ogudei - cave in Krasarang Wilds -- 420
    RUINS_OF_OGUDEI_RELIQUARY_INCURSION = 10086, -- Ruins of Ogudei - cave in Krasarang Wilds -- 421
    CRYPT_OF_KORUNE = 10087, -- Ruins of Ogudei - cave in Krasarang Wilds -- 387
    DALARAN_LANDFALL_UNDERBELLY = 10088, -- Dalaran - Underbelly (Landfall version) -- 502
    KAJA_MINE_SE = 10090, -- Kaja'mine SE - cave in Kezan -- 196
    KAJA_MINE_SW = 10091, -- Kaja'mine SW - cave in Kezan -- 197

    -- Fake IDs for continents
    KALIMDOR = 10073, -- continent map
    EASTERN_KINGDOMS = 10074, -- continent map
    PANDARIA = 10075, -- continent map
    AZEROTH = 10089, -- continent map

    -- Fake IDs for SoD
    DEMON_FALL_CANYON = 15475, -- SoD Dungeon
    THE_TAINTED_SCAR = 15531, -- SoD Lord Kazzak Raid
    THE_BURNING_OF_ANDORHAL = 15828, -- SoD Paladin specific solo dungeon
    KARAZHAN_CRYPTS = 16074, -- SoD Dungeon
    SCARLET_ENCLAVE = 16236, -- SoD Raid
}
