---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local searchLocales = {
    ["Advanced Search"] = {
        ["enUS"] = true,
        ["deDE"] = "Erweiterte Suche",
        ["esES"] = "Búsqueda avanzada",
        ["esMX"] = "Búsqueda avanzada",
        ["frFR"] = "Recherche avancée",
        ["koKR"] = "고급 검색",
        ["ptBR"] = "Procura avançada",
        ["ruRU"] = "Расширенный поиск",
        ["zhCN"] = "进阶搜询",
        ["zhTW"] = "進階搜尋",
    },
    ["Search"] = {
        ["enUS"] = true,
        ["deDE"] = "Suche",
        ["esES"] = "Buscar",
        ["esMX"] = "Buscar",
        ["frFR"] = "Rechercher",
        ["koKR"] = "검색",
        ["ptBR"] = "Procurar",
        ["ruRU"] = "Поиск",
        ["zhCN"] = "搜索",
        ["zhTW"] = "搜尋",
    },
    ["Search By Name"] = {
        ["enUS"] = true,
        ["deDE"] = "Suche mit Namen",
        ["esES"] = "Buscar por nombre",
        ["esMX"] = "Buscar por nombre",
        ["frFR"] = "Recherche par nom",
        ["koKR"] = "이름으로 검색",
        ["ptBR"] = "Procurar por nome",
        ["ruRU"] = "Поиск по имени",
        ["zhCN"] = "根据任务名称搜索",
        ["zhTW"] = "搜尋名稱",
    },
    ["Search By ID"] = {
        ["enUS"] = true,
        ["deDE"] = "Suche mit ID",
        ["esES"] = "Buscar por ID",
        ["esMX"] = "Buscar por ID",
        ["frFR"] = "Recherche par ID",
        ["koKR"] = "ID로 검색",
        ["ptBR"] = "Procurar por ID",
        ["ruRU"] = "Поиск по ID",
        ["zhCN"] = "根据任务ID搜索",
        ["zhTW"] = "搜尋 ID",
    },
    ["Enter in your Search"] = {
        ["enUS"] = true,
        ["deDE"] = "Suche",
        ["esES"] = "Escribe tu búsqueda",
        ["esMX"] = "Escribe tu búsqueda",
        ["frFR"] = "Recherche",
        ["koKR"] = "검색을 입력해주세요",
        ["ptBR"] = "Digite sua procura",
        ["ruRU"] = "Введите данные для поиска",
        ["zhCN"] = "输入搜索",
        ["zhTW"] = "輸入關鍵字搜尋",
    },
    ["Quest Information"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest-Informationen",
        ["esES"] = "Información de la misión",
        ["esMX"] = "Información de la misión",
        ["frFR"] = "Informations sur la quête",
        ["koKR"] = "퀘스트 정보",
        ["ptBR"] = "Informação da missão",
        ["ruRU"] = "Информация о задании",
        ["zhCN"] = "任务信息",
        ["zhTW"] = "任務資訊",
    },
    ["No Quests to List"] = {
        ["enUS"] = true,
        ["deDE"] = "Keine Quests zum Auflisten vorhanden",
        ["esES"] = "No hay misiones que listar",
        ["esMX"] = "No hay misiones que listar",
        ["frFR"] = "Aucunes quêtes à lister",
        ["koKR"] = "표시할 퀘스트가 없습니다",
        ["ptBR"] = "Nenhuma missão para listar",
        ["ruRU"] = "Нет заданий в списке",
        ["zhCN"] = "无任务可列出",
        ["zhTW"] = "沒有任務可供列出",
    },
    ["No spawn data available."] = {
        ["enUS"] = true,
        ["deDE"] = "Keine Spawn-Daten verfügbar.",
        ["esES"] = "No hay datos de aparición disponibles.",
        ["esMX"] = "No hay datos de aparición disponibles.",
        ["frFR"] = "Aucune donnée de spawn disponible.",
        ["koKR"] = "출현 정보가 없습니다.",
        ["ptBR"] = "Não há dados de spawn disponíveis.",
        ["ruRU"] = "Нет данных о появлении",
        ["zhCN"] = "没有可用的生成数据。",
        ["zhTW"] = "沒有可用的重生資料。",
    },
    ["Recommended Quest Level: "] = {
        ["enUS"] = true,
        ["deDE"] = "Empfohlenes Questlevel: ",
        ["esES"] = "Nivel recomendado para la misión: ",
        ["esMX"] = "Nivel recomendado para la misión: ",
        ["frFR"] = "Niveau recommandé : ",
        ["koKR"] = "추천 퀘스트 레벨: ",
        ["ptBR"] = "Nível recomendado para a missão:",
        ["ruRU"] = "Рекомендуемый уровень для выполнения задания: ",
        ["zhCN"] = "建议等级：",
        ["zhTW"] = "任務推薦等級: ",
    },
    ["Ends the following quests:"] = {
        ["enUS"] = true,
        ["deDE"] = "Beendet die folgenden Quests",
        ["esES"] = "Finaliza las siguientes misiones:",
        ["esMX"] = "Finaliza las siguientes misiones:",
        ["frFR"] = "Termine les quêtes suivantes :",
        ["koKR"] = "다음의 퀘스트를 완료할 수 있습니다:",
        ["ptBR"] = "Termina as seguintes missões:",
        ["ruRU"] = "Завершает следующие задания:",
        ["zhCN"] = "结束以下任务:",
        ["zhTW"] = "結束下列任務:",
    },
    ["Remove from Map"] = {
        ["enUS"] = true,
        ["deDE"] = "Von der Karte entfernen",
        ["esES"] = "Quitar del mapa",
        ["esMX"] = "Quitar del mapa",
        ["frFR"] = "Retirer de la carte",
        ["koKR"] = "지도에서 제거",
        ["ptBR"] = "Remover do mapa",
        ["ruRU"] = "Удалить с карты",
        ["zhCN"] = "地图上移除",
        ["zhTW"] = "從地圖上移除",
    },
    ["Quest ID: "] = {
        ["enUS"] = true,
        ["deDE"] = "Quest ID: ",
        ["esES"] = "ID de misión: ",
        ["esMX"] = "ID de misión: ",
        ["frFR"] = "ID de quête : ",
        ["koKR"] = "퀘스트 ID: ",
        ["ptBR"] = "ID da missão: ",
        ["ruRU"] = "ID задания: ",
        ["zhCN"] = "任务ID： ",
        ["zhTW"] = "任務 ID: ",
    },
    ["Found in"] = {
        ["enUS"] = true,
        ["deDE"] = "Gefunden in",
        ["esES"] = "Encontrado en",
        ["esMX"] = "Encontrado en",
        ["frFR"] = "Trouvé dans ",
        ["koKR"] = "발견할 수 있음",
        ["ptBR"] = "Encontrado em",
        ["ruRU"] = "Местонахождение",
        ["zhCN"] = "任务可被发现",
        ["zhTW"] = "任務地點",
    },
    ["No Match for Search Results: %s"] = {
        ["enUS"] = true,
        ["deDE"] = "Keine Treffer für die Suche: %s",
        ["esES"] = "No hay resultados para tu búsqueda: %s",
        ["esMX"] = "No hay resultados para tu búsqueda: %s",
        ["frFR"] = "Aucune correspondance trouvée pour : %s",
        ["koKR"] = "검색 결과가 없습니다: %s",
        ["ptBR"] = "Nenhum resultado encontrado para sua procura: %s",
        ["ruRU"] = "Нет совпадений для результатов поиска: %s",
        ["zhCN"] = "没有符合的结果：%s",
        ["zhTW"] = "沒有符合的搜尋結果: %s",
    },
    ["No Quests found"] = {
        ["enUS"] = true,
        ["deDE"] = "Keine Quests gefunden",
        ["esES"] = "No se encontraron misiones",
        ["esMX"] = "No se encontraron misiones",
        ["frFR"] = "Aucune quête trouvée",
        ["koKR"] = "퀘스트를 찾을 수 없습니다",
        ["ptBR"] = "Nenhuma missão encontrada",
        ["ruRU"] = "Задания не найдены",
        ["zhCN"] = "找不到任务",
        ["zhTW"] = "找不到任務",
    },
    ["NPC"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "PNJ",
        ["esMX"] = "PNJ",
        ["frFR"] = "PNJ",
        ["koKR"] = true,
        ["ptBR"] = true,
        ["ruRU"] = true,
        ["zhCN"] = true,
        ["zhTW"] = true,
    },
    ["NPCs"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "PNJ",
        ["esMX"] = "PNJ",
        ["frFR"] = "PNJ",
        ["koKR"] = true,
        ["ptBR"] = true,
        ["ruRU"] = true,
        ["zhCN"] = true,
        ["zhTW"] = true,
    },
    ["Items"] = {
        ["enUS"] = true,
        ["deDE"] = "Items",
        ["esES"] = "Objetos",
        ["esMX"] = "Objetos",
        ["frFR"] = "Objets",
        ["koKR"] = "아이템",
        ["ptBR"] = "Itens",
        ["ruRU"] = "Предметы",
        ["zhCN"] = "物品",
        ["zhTW"] = "物品",
    },
    ["This NPC Also Starts the following quests:"] = {
        ["enUS"] = true,
        ["deDE"] = "Dieser NPC startet außerdem die folgenden Quests:",
        ["esES"] = "Este PNJ también inicia las siguientes misiones:",
        ["esMX"] = "Este PNJ también inicia las siguientes misiones:",
        ["frFR"] = "Ce PNJ débute également les quêtes suivantes :",
        ["koKR"] = "해당 NPC에게 다음 퀘스트도 시작할 수 있습니다:",
        ["ptBR"] = "Este NPC também começa as seguintes missões:",
        ["ruRU"] = "Этот NPC также начинает следующие задания:",
        ["zhCN"] = "这个NPC同时是下列任务的起始者：",
        ["zhTW"] = "這個 NPC 也會開始下列任務:",
    },
    ["This NPC Also Completes the following quests:"] = {
        ["enUS"] = true,
        ["deDE"] = "Dieser NPC beendet außerdem die folgenden Quests:",
        ["esES"] = "Este PNJ también finaliza las siguientes misiones:",
        ["esMX"] = "Este PNJ también finaliza las siguientes misiones:",
        ["frFR"] = "Ce PNJ termine également les quêtes suivantes :",
        ["koKR"] = "해당 NPC에게 다음 퀘스트도 완료할 수 있습니다:",
        ["ptBR"] = "Este NPC também termina as seguintes missões:",
        ["ruRU"] = "Этот NPC также завершает следующие задания:",
        ["zhCN"] = "这个NPC同时是下列任务的提交者：",
        ["zhTW"] = "這個 NPC 也會完成下列任務:",
    },
    ["Quest Start Object Information"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest-Start-Objekt-Informationen",
        ["esES"] = "Objeto que inicia la misión",
        ["esMX"] = "Información del objeto que inicia la misión",
        ["frFR"] = "Informations sur l'objet débutant la quête",
        ["koKR"] = "퀘스트 시작 오브젝트 정보",
        ["ptBR"] = "Informação sobre o objeto que começa a missão",
        ["ruRU"] = "Информация о начинающем задание объекте:",
        ["zhCN"] = "任务起始物体信息",
        ["zhTW"] = "任務開始物體資訊",
    },
    ["This Object Also Starts the following quests:"] = {
        ["enUS"] = true,
        ["deDE"] = "Dieses Objekt startet außerdem die folgenden Quests:",
        ["esES"] = "Este objeto también inicia las siguientes misiones:",
        ["esMX"] = "Este objeto también inicia las siguientes misiones:",
        ["frFR"] = "Cet objet débute également les quêtes suivantes :",
        ["koKR"] = "해당 오브젝트에게 다음 퀘스트도 시작할 수 있습니다:",
        ["ptBR"] = "Esse objeto também começa as seguintes missões:",
        ["ruRU"] = "Этот объект также начинает следующие задания:",
        ["zhCN"] = "此物体亦会启动下列任务：",
        ["zhTW"] = "此物體亦會啟動下列任務：",
    },
    ["Quest Start NPC Information"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest-Start-NPC-Informationen",
        ["esES"] = "Información del PNJ que inicia la misión",
        ["esMX"] = "Información del PNJ que inicia la misión",
        ["frFR"] = "Informations sur le PNJ débutant la quête",
        ["koKR"] = "퀘스트 시작 NPC 정보",
        ["ptBR"] = "Informação sobre o NPC que começa a missão",
        ["ruRU"] = "Информация о начинающем задание NPC:",
        ["zhCN"] = "任务起始NPC信息",
        ["zhTW"] = "開始任務 NPC 資訊",
    },
    ["Quest Turn-in NPC Information"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest-Abgabe-NPC-Informationen",
        ["esES"] = "Información del PNJ al que se entrega la misión",
        ["esMX"] = "Información del PNJ al que se entrega la misión",
        ["frFR"] = "Informations sur le PNJ terminant la quête",
        ["koKR"] = "퀘스트 완료 NPC 정보",
        ["ptBR"] = "Informação sobre o NPC de entrega da missão",
        ["ruRU"] = "Информация о завершающем задание NPC:",
        ["zhCN"] = "任务提交NPC信息",
        ["zhTW"] = "交回任務 NPC 資訊",
    },
    ["Starts the following quests:"] = {
        ["enUS"] = true,
        ["deDE"] = "Startet die folgenden Quests:",
        ["esES"] = "Inicia las siguientes misiones:",
        ["esMX"] = "Inicia las siguientes misiones:",
        ["frFR"] = "Commence les quêtes suivantes :",
        ["koKR"] = "다음의 퀘스트를 시작할 수 있습니다:",
        ["ptBR"] = "Começa as seguintes missões:",
        ["ruRU"] = "Начинает следующие задания:",
        ["zhCN"] = "开始以下任务:",
        ["zhTW"] = "開始下列任務:",
    },
    ["Minimum Required Level for Quest: "] = {
        ["enUS"] = true,
        ["deDE"] = "Benötigtes Mindestlevel für diese: ",
        ["esES"] = "Nivel mínimo requerido para la misión: ",
        ["esMX"] = "Nivel mínimo requerido para la misión: ",
        ["frFR"] = "Niveau minimum requis pour la quête : ",
        ["koKR"] = "수행가능한 최소 레벨: ",
        ["ptBR"] = "Nível mínimo necessário para a missão:",
        ["ruRU"] = "Минимальный уровень для принятия задания: ",
        ["zhCN"] = "最低等级：",
        ["zhTW"] = "最低需求等級: ",
    },
    ["Difficulty Range: %s"] = {
        ["enUS"] = true,
        ["deDE"] = "Schwierigkeitsgrad: %s",
        ["esES"] = "Rango de dificultad: %s",
        ["esMX"] = "Rango de dificultad: %s",
        ["frFR"] = "Fourchette de difficulté : %s",
        ["koKR"] = "난이도 범위: %s",
        ["ptBR"] = "Dificuldade: %s",
        ["ruRU"] = "Диапазон сложности: %s",
        ["zhCN"] = "难度级距：%s",
        ["zhTW"] = "難度範圍: %s",
    },
    ["Hidden"] = {
        ["enUS"] = true,
        ["deDE"] = "Versteckt",
        ["esES"] = "Oculto",
        ["esMX"] = "Oculto",
        ["frFR"] = "Cachée",
        ["koKR"] = "숨김",
        ["ptBR"] = "Oculto",
        ["ruRU"] = "Скрыто",
        ["zhCN"] = "隐藏",
        ["zhTW"] = "隱藏",
    },
    ["Quest is hidden"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest ist versteckt",
        ["esES"] = "La misión está oculta",
        ["esMX"] = "La misión está oculta",
        ["frFR"] = "La quête est cachée",
        ["koKR"] = "퀘스트가 숨겨졌습니다.",
        ["ptBR"] = "Missão oculta",
        ["ruRU"] = "Задание скрыто",
        ["zhCN"] = "任务被隐藏",
        ["zhTW"] = "任務被隱藏",
    },
    ["\nWhen selected, hides the quest from the map, even if it is active.\n\nHiding a quest is also possible by Shift-clicking it on the map."] = {
        ["enUS"] = true,
        ["deDE"] = "\nWenn der Haken gesetzt ist, dann wird die Quest nicht auf der Karte angezeigt, auch wenn sie aktiv ist.\n\nQuests können auch per Shift+Linksklick auf der Karte versteckt werden.",
        ["esES"] = "\nSi está activado, oculta la misión del mapa, incluso si se encuentra activa.\n\nTambién se puede ocultar una misión desde el mapa presionando Mayús + Clic izquierdo sobre ella",
        ["esMX"] = "\nSi está activado, oculta la misión del mapa, incluso si se encuentra activa.\n\nTambién se puede ocultar una misión desde el mapa presionando Mayús + Clic izquierdo sobre ella",
        ["frFR"] = "\nSi cette option est activée, cache la quête de la carte, même si elle est active.\n\nCacher une quête est également possible en cliquant dessus tout en maintenant la touche Maj enfoncée sur la carte.",
        ["koKR"] = "\n이 옵션을 선택하면 퀘스트를 지도에서 숨깁니다. \n\n 지도에서 Shift 클릭으로 퀘스트를 숨길 수도 있습니다.",
        ["ptBR"] = "\nSe ativado, oculta a missão do mapa, mesmo que esteja ativa.\n\nTambém é possível ocultar a missão utilizando Shift + Botão esquerdo nela no mapa.",
        ["ruRU"] = "\nКогда выбрано, скрывает задание с карты, даже если оно активно.\n\nСкрыть задание можно также через Shift-клик по нему на карте",
        ["zhCN"] = "\n选中该选项后，即使该任务处于活动状态也将其在地图中隐藏。\n\n也可以通过在地图上按住Shift+单击来隐藏该任务。 ",
        ["zhTW"] = "\n啟用時，即使是正在進行中的任務，也會在地圖上隱藏。\n\n也可以按住 Shift 點擊地圖上的任務來隱藏。",
    },
    ["Hidden by Questie"] = {
        ["enUS"] = true,
        ["deDE"] = "Von Questie versteckt",
        ["esES"] = "Ocultado por Questie",
        ["esMX"] = "Ocultado por Questie",
        ["frFR"] = "Cachée par Questie",
        ["koKR"] = "퀘스티로 숨겨짐",
        ["ptBR"] = "Oculto por Questie",
        ["ruRU"] = "Скрыто аддоном",
        ["zhCN"] = "被Questie隐藏",
        ["zhTW"] = "被任務位置提示插件隱藏",
    },
    ["NPCs starting this quest:"] = {
        ["enUS"] = true,
        ["deDE"] = "NPCs welche diese Quest starten:",
        ["esES"] = "PNJ que inician esta misión:",
        ["esMX"] = "PNJ que inician esta misión:",
        ["frFR"] = "PNJ qui débutent cette quête",
        ["koKR"] = "해당 NPC가 퀘스트를 시작합니다",
        ["ptBR"] = "NPCs que começam esta missão:",
        ["ruRU"] = "NPC, начинающие это задание:",
        ["zhCN"] = "开始这个任务的NPC:",
        ["zhTW"] = "開始這個任務的 NPC:",
    },
    ["NPCs finishing this quest:"] = {
        ["enUS"] = true,
        ["deDE"] = "NPCs welche diese Quest beenden:",
        ["esES"] = "PNJ que finalizan esta misión:",
        ["esMX"] = "PNJ que finalizan esta misión:",
        ["frFR"] = "PNJ qui terminent cette quête",
        ["koKR"] = "해당 NPC가 퀘스트를 끝냅니다.",
        ["ptBR"] = "NPCs que terminam esta missão:",
        ["ruRU"] = "NPC, завершающие это задание:",
        ["zhCN"] = "完成此任务的NPC:",
        ["zhTW"] = "完成這個任務的 NPC:",
    },
    ["Objects starting this quest:"] = {
        ["enUS"] = true,
        ["deDE"] = "Objekte welche diese Quest starten:",
        ["esES"] = "Objetos que inician esta misión",
        ["esMX"] = "Objetos que inician esta misión",
        ["frFR"] = "Objets qui démarrent cette quête",
        ["koKR"] = "해당 오브젝트가 퀘스트를 시작합니다.",
        ["ptBR"] = "Objetos que começam esta missão:",
        ["ruRU"] = "Объекты, начинающие это задание:",
        ["zhCN"] = "开始此任务的物体：",
        ["zhTW"] = "開始此任務的物體：",
    },
    ["Objects finishing this quest:"] = {
        ["enUS"] = true,
        ["deDE"] = "Objekte welche diese Quest beenden:",
        ["esES"] = "Objetos que finalizan esta misión:",
        ["esMX"] = "Objetos que finalizan esta misión:",
        ["frFR"] = "Objets qui terminent cette quête",
        ["koKR"] = "해당 오브젝트가 퀘스트를 끝냅니다.",
        ["ptBR"] = "Objetos que terminam esta missão:",
        ["ruRU"] = "Объекты, завершающие это задание:",
        ["zhCN"] = "完成此任务的物体：",
        ["zhTW"] = "完成此任務的物體：",
    },
    ["Items starting this quest:"] = {
        ["enUS"] = true,
        ["deDE"] = "Gegenstände welche diese Quest starten:",
        ["esES"] = "Objetos que inician esta misión:",
        ["esMX"] = "Objetos que inician esta misión:",
        ["frFR"] = "Objets qui démarrent cette quête",
        ["koKR"] = "해당 아이템이 퀘스트를 시작힙니다.",
        ["ptBR"] = "Itens que começam esta missão:",
        ["ruRU"] = "Предметы, начинающие это задание:",
        ["zhCN"] = "启动此任务的物品：",
        ["zhTW"] = "啟動此任務的物品：",
    },
    ["This item is blacklisted because it has too many sources"] = {
        ["enUS"] = true,
        ["deDE"] = "Dieser Gegenstand ist blockiert, da es zu viele Quellen für ihn gibt",
        ["esES"] = "Este objeto está en la lista negra porque tiene demasiadas fuentes",
        ["esMX"] = "Este objeto está en la lista negra porque tiene demasiadas fuentes",
        ["frFR"] = "Cet objet est en liste noire parce qu'il a trop de sources",
        ["koKR"] = "해당 아이템은 너무 많은 소스로 인하여 블랙리스트에 추가되었습니다",
        ["ptBR"] = "Este item está na lista negra porque tem muitas fontes",
        ["ruRU"] = "Этот предмет находится в черном списке, т.к. у него слишком много источников получения",
        ["zhCN"] = "此物品已被列入黑名单，因为它的来源太多",
        ["zhTW"] = "此物品已被列入黑名單，因為它的來源太多",
    },
    ["No NPC drops this item"] = {
        ["enUS"] = true,
        ["deDE"] = "Kein NPC lässt diesen Gegenstand fallen",
        ["esES"] = "Ningún PNJ contiene este objeto",
        ["esMX"] = "Ningún PNJ contiene este objeto",
        ["frFR"] = "Aucun PNJ ne fait tomber cet item",
        ["koKR"] = "어떠한 NPC도 해당 아이템을 드롭하지 않습니다",
        ["ptBR"] = "Nenhum NPC contém este item",
        ["ruRU"] = "Ни с одного NPC не добывается этот предмет",
        ["zhCN"] = "没有 NPC 掉落这个物品",
        ["zhTW"] = "沒有 NPC 掉落這個物品",
    },
    ["No Object drops this item"] = {
        ["enUS"] = true,
        ["deDE"] = "Kein Objekt lässt diesen Gegenstand fallen",
        ["esES"] = "Ningún objeto contiene este objeto",
        ["esMX"] = "Ningún objeto contiene este objeto",
        ["frFR"] = "Aucun Objet ne fait tomber cet item",
        ["koKR"] = "어떠한 오브젝트도 해당 아이템을 드롭하지 않습니다",
        ["ptBR"] = "Nenhum objeto contém este item",
        ["ruRU"] = "Ни с одного объекта не добывается этот предмет",
        ["zhCN"] = "没有物体掉落这个物品",
        ["zhTW"] = "沒有物體掉落這個物品",
    },
    ["No Vendor sells this item"] = {
        ["enUS"] = true,
        ["deDE"] = "Kein Händler verkauft diesen Gegenstand",
        ["esES"] = "Ningún vendedor vende este objeto",
        ["esMX"] = "Ningún vendedor vende este objeto",
        ["frFR"] = "Aucun vendeur ne vend cet item",
        ["koKR"] = "해당 아이템을 파는 상인이 없습니다",
        ["ptBR"] = "Nenhum comerciante vende este item",
        ["ruRU"] = "Ни один продавец не продает этот предмет",
        ["zhCN"] = "没有商人贩售此物品",
        ["zhTW"] = "沒有商人販售此物品",
    },
    ["%d NPCs drop this item"] = {
        ["enUS"] = true,
        ["deDE"] = "%d NPCs lassen diesen Gegenstand fallen",
        ["esES"] = "%d PNJ sueltan este objeto",
        ["esMX"] = "%d PNJ sueltan este objeto",
        ["frFR"] = "%d PNJ font tomber cet item ",
        ["koKR"] = "%d NPC가 해당 아이템을 드롭합니다",
        ["ptBR"] = "%d NPCs derrubam este item",
        ["ruRU"] = "NPC, с которых добывается этот предмет - %d",
        ["zhCN"] = "有 %d 个 NPC 掉落这个物品",
        ["zhTW"] = "有 %d 個 NPC 掉落這個物品",
    },
    ["%d Objects drop this item"] = {
        ["enUS"] = true,
        ["deDE"] = "%d Objekte lassen diesen Gegenstand fallen",
        ["esES"] = "%d objetos contienen este objeto",
        ["esMX"] = "%d objetos contienen este objeto",
        ["frFR"] = "%d Objects font tomber cet item ",
        ["koKR"] = "%d 오브젝트가 해당 아이템을 드롭합니다",
        ["ptBR"] = "%d objetos contém este item",
        ["ruRU"] = "Объектов, с которых добывается этот предмет - %d",
        ["zhCN"] = "有 %d 个物体掉落此物品",
        ["zhTW"] = "有 %d 個物體掉落此物品",
    },
    ["%d Vendors sell this item"] = {
        ["enUS"] = true,
        ["deDE"] = "%d Händler verkaufen diesen Gegenstand",
        ["esES"] = "%d vendedores venden este objeto",
        ["esMX"] = "%d vendedores venden este objeto",
        ["frFR"] = "%d Vendeurs vendent cet item ",
        ["koKR"] = "%d 상인이 해당 아이템을 판매합니다",
        ["ptBR"] = "%d comerciantes vendem este item",
        ["ruRU"] = "Продавцов, у которых продается этот предмет - %d",
        ["zhCN"] = "有 %d 位商人贩售此物品",
        ["zhTW"] = "有 %d 位商人販售此物品",
    },
    ["Requires all of these quests to be finished:"] = {
        ["enUS"] = true,
        ["deDE"] = "Benötigt, dass alle folgenden Quests abgeschlossen sind:",
        ["esES"] = "Requiere completar todas estas misiones:",
        ["esMX"] = "Requiere completar todas estas misiones:",
        ["frFR"] = "Requiert que toutes ces quêtes soient terminées",
        ["koKR"] = "해당되는 모든 퀘스트를 완료해야 합니다",
        ["ptBR"] = "Requer que todas estas missões sejam concluídas:",
        ["ruRU"] = "Требуется выполнение всех этих заданий:",
        ["zhCN"] = "必須完成以下所有任务：",
        ["zhTW"] = "需要完成所有這些任務:",
    },
    ["Requires one of these quests to be finished:"] = {
        ["enUS"] = true,
        ["deDE"] = "Benötigt, dass eine der folgenden Quests abgeschlossen ist:",
        ["esES"] = "Requiere completar una de estas misiones:",
        ["esMX"] = "Requiere completar una de estas misiones:",
        ["frFR"] = "Requiert qu'une de ces quêtes soient terminées",
        ["koKR"] = "해당 퀘스트 중 한가지를 완료해야 합니다",
        ["ptBR"] = "Requer que uma destas missões seja concluída:",
        ["ruRU"] = "Требуется выполнение одного из этих заданий:",
        ["zhCN"] = "必須完成以下任务之一：",
        ["zhTW"] = "需要完成其中之一任務:",
    },
    ["Object"] = {
        ["enUS"] = true,
        ["deDE"] = "Objekt",
        ["esES"] = "Objeto",
        ["esMX"] = "Objeto",
        ["frFR"] = "Objet",
        ["koKR"] = "오브젝트",
        ["ptBR"] = "Objeto",
        ["ruRU"] = "Объект",
        ["zhCN"] = false,
        ["zhTW"] = "物件",
    },
    ["Friendly to"] = {
        ["enUS"] = true,
        ["deDE"] = "Freundlich zu",
        ["esES"] = "Amistoso con",
        ["esMX"] = "Amistoso con",
        ["frFR"] = "Amical envers",
        ["koKR"] = "우호적",
        ["ptBR"] = "Amigável com",
        ["ruRU"] = "Дружественный к",
        ["zhCN"] = false,
        ["zhTW"] = "友好於",
    },
    ["both factions"] = {
        ["enUS"] = true,
        ["deDE"] = "beiden Fraktionen",
        ["esES"] = "ambas facciones",
        ["esMX"] = "ambas facciones",
        ["frFR"] = "les deux factions",
        ["koKR"] = "모든 진영",
        ["ptBR"] = "ambas as facções",
        ["ruRU"] = "обеим фракциям",
        ["zhCN"] = false,
        ["zhTW"] = "雙方陣營",
    },
    ["no faction"] = {
        ["enUS"] = true,
        ["deDE"] = "keiner Fraktion",
        ["esES"] = "ninguna facción",
        ["esMX"] = "ninguna facción",
        ["frFR"] = "aucune faction",
        ["koKR"] = "중립",
        ["ptBR"] = "nenhuma facção",
        ["ruRU"] = "ни к одной фракции",
        ["zhCN"] = false,
        ["zhTW"] = "沒有陣營",
    },
    ["Level"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "Nivel",
        ["esMX"] = "Nivel",
        ["frFR"] = "Niveau",
        ["koKR"] = "레벨",
        ["ptBR"] = "Nível",
        ["ruRU"] = "Уровень",
        ["zhCN"] = false,
        ["zhTW"] = "等級",
    },
    ["Health"] = {
        ["enUS"] = true,
        ["deDE"] = "Leben",
        ["esES"] = "Salud",
        ["esMX"] = "Salud",
        ["frFR"] = "Vie",
        ["koKR"] = "생명력",
        ["ptBR"] = "Vida",
        ["ruRU"] = "Здоровье",
        ["zhCN"] = false,
        ["zhTW"] = "血量",
    },
    ["Click to show"] = {
        ["enUS"] = true,
        ["deDE"] = "Zum anzeigen klicken",
        ["esES"] = "Haz clic para mostrar",
        ["esMX"] = "Haz clic para mostrar",
        ["frFR"] = "Cliquez pour afficher",
        ["koKR"] = "클릭해서 보기",
        ["ptBR"] = "Clique para exibir",
        ["ruRU"] = "Клик для отображения",
        ["zhCN"] = false,
        ["zhTW"] = "點一下顯示",
    },
    ["NPCs dropping this item:"] = {
        ["enUS"] = true,
        ["deDE"] = "NPCs die diesen Gegenstand fallen lassen:",
        ["esES"] = "PNJ que sueltan este objeto:",
        ["esMX"] = "PNJ que sueltan este objeto:",
        ["frFR"] = "PNJ qui laissent tomber cet objet :",
        ["koKR"] = "NPC가 다음의 아이템을 드랍합니다:",
        ["ptBR"] = "NPCs que derrubam este item:",
        ["ruRU"] = "Предмет добывается с:",
        ["zhCN"] = false,
        ["zhTW"] = "掉落此物品的 NPC:",
    },
}

for k, v in pairs(searchLocales) do
    l10n.translations[k] = v
end
