---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local townsfolkLocales = {
    ["Ammo"] = {
        ["enUS"] = true,
        ["deDE"] = "Munition",
        ["esES"] = "Municiones",
        ["esMX"] = "Municiones",
        ["frFR"] = "Munitions",
        ["koKR"] = "무기상인",
        ["ptBR"] = "Munição",
        ["ruRU"] = "Боеприпасы",
        ["zhCN"] = "枪械和弹药商",
        ["zhTW"] = "武器商人",
    },
    ["Auctioneer"] = {
        ["enUS"] = true,
        ["deDE"] = "Auktionator",
        ["esES"] = "Subastador",
        ["esMX"] = "Subastador",
        ["frFR"] = "Commissaire-priseur",
        ["koKR"] = "경매인",
        ["ptBR"] = "Leiloeiro",
        ["ruRU"] = "Аукционер",
        ["zhCN"] = "拍卖师",
        ["zhTW"] = "拍賣師",
    },
    ["Bags"] = {
        ["enUS"] = true,
        ["deDE"] = "Taschen",
        ["esES"] = "Bolsas",
        ["esMX"] = "Bolsas",
        ["frFR"] = "Sacs",
        ["koKR"] = "가방 상인",
        ["ptBR"] = "Bolsas",
        ["ruRU"] = "Сумки",
        ["zhCN"] = "背包",
        ["zhTW"] = "背包商人",
    },
    ["Banker"] = {
        ["enUS"] = true,
        ["deDE"] = "Bankier",
        ["esES"] = "Banquero",
        ["esMX"] = "Banquero",
        ["frFR"] = "Banquier",
        ["koKR"] = "은행원",
        ["ptBR"] = "Banqueiro",
        ["ruRU"] = "Банкир",
        ["zhCN"] = "银行职员",
        ["zhTW"] = "銀行職員",
    },
    ["Battlemaster"] = {
        ["enUS"] = true,
        ["deDE"] = "Kampfmeister",
        ["esES"] = "Maestro de batalla",
        ["esMX"] = "Maestro de batalla",
        ["frFR"] = "Maître de guerre",
        ["koKR"] = "전투모병관",
        ["ptBR"] = "Mestre de Batalha",
        ["ruRU"] = "Военачальник",
        ["zhCN"] = "战场军官",
        ["zhTW"] = "戰場軍官",
    },
    ["Class Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Lehrer für eine Klasse",
        ["esES"] = "Instructor de clase",
        ["esMX"] = "Instructor de clase",
        ["frFR"] = "Maître de classe",
        ["koKR"] = "직업 상급자",
        ["ptBR"] = "Instrutor de classe",
        ["ruRU"] = "Учитель классовых навыков",
        ["zhCN"] = "职业训练师",
        ["zhTW"] = "職業訓練師",
    },
    ["Drink"] = {
        ["enUS"] = true,
        ["deDE"] = "Getränke",
        ["esES"] = "Bebidas",
        ["esMX"] = "Bebidas",
        ["frFR"] = "Boissons",
        ["koKR"] = "음료 상인",
        ["ptBR"] = "Bebidas",
        ["ruRU"] = "Напитки",
        ["zhCN"] = "水商",
        ["zhTW"] = "飲料商人",
    },
    ["Flight Master"] = {
        ["enUS"] = true,
        ["deDE"] = "Flugmeister",
        ["esES"] = "Maestro de vuelo",
        ["esMX"] = "Maestro de vuelo",
        ["frFR"] = "Maître de vol",
        ["koKR"] = "비행 조련사",
        ["ptBR"] = "Mestre de Voo",
        ["ruRU"] = "Распорядитель полетов",
        ["zhCN"] = "飞行管理员",
        ["zhTW"] = "飛行管理員",
    },
    ["Food"] = {
        ["enUS"] = true,
        ["deDE"] = "Essen",
        ["esES"] = "Comida",
        ["esMX"] = "Comida",
        ["frFR"] = "Nourriture",
        ["koKR"] = "음식 상인",
        ["ptBR"] = "Comida",
        ["ruRU"] = "Еда",
        ["zhCN"] = "面包商人",
        ["zhTW"] = "麵包商人",
    },
    ["Innkeeper"] = {
        ["enUS"] = true,
        ["deDE"] = "Gastwirt",
        ["esES"] = "Tabernero",
        ["esMX"] = "Tabernero",
        ["frFR"] = "Aubergiste",
        ["koKR"] = "여관주인",
        ["ptBR"] = "Estalajadeiro",
        ["ruRU"] = "Хозяин таверны",
        ["zhCN"] = "旅馆老板",
        ["zhTW"] = "旅店老闆",
    },
    ["Mailbox"] = {
        ["enUS"] = true,
        ["deDE"] = "Briefkasten",
        ["esES"] = "Buzón",
        ["esMX"] = "Buzón",
        ["frFR"] = "Boîte aux lettres",
        ["koKR"] = "우체통",
        ["ptBR"] = "Caixa de Correio",
        ["ruRU"] = "Почтовый ящик",
        ["zhCN"] = "邮箱",
        ["zhTW"] = "郵箱",
    },
    ["Profession Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Berufsausbilder",
        ["esES"] = "Instructor de profesión",
        ["esMX"] = "Instructor de profesión",
        ["frFR"] = "Maître de profession",
        ["koKR"] = "기술 전문가",
        ["ptBR"] = "Instrutor de profissão",
        ["ruRU"] = "Учитель профессий",
        ["zhCN"] = "专业训练师",
        ["zhTW"] = "專業技能訓練師",
    },
    ["Reagents"] = {
        ["enUS"] = true,
        ["deDE"] = "Reagenzien",
        ["esES"] = "Componentes",
        ["esMX"] = "Componentes",
        ["frFR"] = "Composants",
        ["koKR"] = "마법 재료 상인",
        ["ptBR"] = "Reagentes",
        ["ruRU"] = "Реагенты",
        ["zhCN"] = "施法材料",
        ["zhTW"] = "施法材料",
    },
    ["Repair"] = {
        ["enUS"] = true,
        ["deDE"] = "Reparieren",
        ["esES"] = "Reparación",
        ["esMX"] = "Reparación",
        ["frFR"] = "Réparations",
        ["koKR"] = "장비 수리",
        ["ptBR"] = "Reparos",
        ["ruRU"] = "Ремонт",
        ["zhCN"] = "修理",
        ["zhTW"] = "修理",
    },
    ["Spirit Healer"] = {
        ["enUS"] = true,
        ["deDE"] = "Geistheiler",
        ["esES"] = "Ángel de la Resurrección",
        ["esMX"] = "Ángel de la Resurrección",
        ["frFR"] = "Gardien des âmes",
        ["koKR"] = "영혼의 치유사",
        ["ptBR"] = "Anjo da Cura",
        ["ruRU"] = "Целитель душ",
        ["zhCN"] = "灵魂医者",
        ["zhTW"] = "靈魂醫者",
    },
    ["Stable Master"] = {
        ["enUS"] = true,
        ["deDE"] = "Stallmeister",
        ["esES"] = "Maestro de establos",
        ["esMX"] = "Maestro de establos",
        ["frFR"] = "Maître des écuries",
        ["koKR"] = "야수 관리인",
        ["ptBR"] = "Mestre de Estábulo",
        ["ruRU"] = "Смотритель стойл",
        ["zhCN"] = "兽栏管理员",
        ["zhTW"] = "獸欄管理員",
    },
    ["Meeting Stone"] = {
        ["enUS"] = true,
        ["deDE"] = "Versammlungsstein",
        ["esES"] = "Roca de encuentro",
        ["esMX"] = "Roca de encuentro",
        ["frFR"] = "Pierre de rencontre",
        ["koKR"] = "만남의 돌",
        ["ptBR"] = "Pedra de Encontro",
        ["ruRU"] = "Камень встреч",
        ["zhCN"] = "集合石",
        ["zhTW"] = "集合石",
    },
    ["Meeting Stones"] = {
        ["enUS"] = true,
        ["deDE"] = "Versammlungssteine",
        ["esES"] = "Rocas de encuentro",
        ["esMX"] = "Rocas de encuentro",
        ["frFR"] = "Pierre de rencontre",
        ["koKR"] = "만남의 돌",
        ["ptBR"] = "Pedra de Encontro",
        ["ruRU"] = "Камни встреч",
        ["zhCN"] = "集合石",
        ["zhTW"] = "集合石",
    },
    ["Pet Food"] = {
        ["enUS"] = true,
        ["deDE"] = "Futter",
        ["esES"] = "Comida de mascota",
        ["esMX"] = "Comida de mascota",
        ["frFR"] = "Nourriture de familier",
        ["koKR"] = "펫 먹이",
        ["ptBR"] = "Comida de ajudante",
        ["ruRU"] = "Еда для питомцев",
        ["zhCN"] = "宠物食物",
        ["zhTW"] = "寵物食物",
    },
    ["Portal Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Portallehrer",
        ["esES"] = "Instructor de portal",
        ["esMX"] = "Instructor de portal",
        ["frFR"] = "Maître des portails",
        ["koKR"] = "순간이동 전문 마법사",
        ["ptBR"] = "Treinamento de Portais",
        ["ruRU"] = "Мастер порталов",
        ["zhCN"] = "传送门训练师",
        ["zhTW"] = "傳送門訓練師",
    },
    ["Potions"] = {
        ["enUS"] = true,
        ["deDE"] = "Tränke",
        ["esES"] = "Pociones",
        ["esMX"] = "Pociones",
        ["frFR"] = true,
        ["koKR"] = "물약",
        ["ptBR"] = "Poções",
        ["ruRU"] = "Зелья",
        ["zhCN"] = "药剂商人",
        ["zhTW"] = "藥水商人",
    },
    ["Trade Goods"] = {
        ["enUS"] = true,
        ["deDE"] = "Handwerkswaren",
        ["esES"] = "Objetos comerciables",
        ["esMX"] = "Objetos comerciables",
        ["frFR"] = "Fournitures d'artisanat",
        ["koKR"] = "각종용품 상인",
        ["ptBR"] = "Mercadorias",
        ["ruRU"] = "Хозяйственные товары",
        ["zhCN"] = "杂货商人",
        ["zhTW"] = "雜貨商人",
    },
    ["Vendor"] = {
        ["enUS"] = true,
        ["deDE"] = "Verkäufer",
        ["esES"] = "Vendedor",
        ["esMX"] = "Vendedor",
        ["frFR"] = "Vendeur",
        ["koKR"] = "상인",
        ["ptBR"] = "Comerciante",
        ["ruRU"] = "Торговец",
        ["zhCN"] = "商人",
        ["zhTW"] = "商人",
    },
    ["Weapon Master"] = {
        ["enUS"] = true,
        ["deDE"] = "Waffenmeister",
        ["esES"] = "Maestro armero",
        ["esMX"] = "Maestro de armas",
        ["frFR"] = "Maître d'armes",
        ["koKR"] = "무기 전문가",
        ["ptBR"] = "Mestre de Armas",
        ["ruRU"] = "Эксперт по оружию",
        ["zhCN"] = "武器大师",
        ["zhTW"] = "武器大師",
    },
    ["Townsfolk"] = {
        ["enUS"] = true,
        ["deDE"] = "Stadtbewohner",
        ["esES"] = "Aldeanos",
        ["esMX"] = "Aldeanos",
        ["frFR"] = "Villageois",
        ["koKR"] = "마을 NPC",
        ["ptBR"] = "Aldeões",
        ["ruRU"] = "Полезные NPC",
        ["zhCN"] = "城镇NPC",
        ["zhTW"] = "城鎮NPC",
    },
    ["Transmogrifier"] = {
        ["enUS"] = true,
        ["deDE"] = "Transmogrifizierer",
        ["esES"] = "Transfigurador",
        ["esMX"] = "Transfigurador",
        ["frFR"] = "Transmogrifieur",
        ["koKR"] = "형상변환사",
        ["ptBR"] = "Transmogrificador",
        ["ruRU"] = "Трансмогрификатор",
        ["zhCN"] = "幻化师",
        ["zhTW"] = "塑形師",
    },
    ["Arcane Reforger"] = {
        ["enUS"] = true,
        ["deDE"] = "Arkaner Umschmieder",
        ["esES"] = "Reforjador Arcano",
        ["esMX"] = "Reforjador Arcano",
        ["frFR"] = "Retoucheur arcanique",
        ["koKR"] = "마법 재연마사",
        ["ptBR"] = "Reforjador Arcano",
        ["ruRU"] = "Чародей-кузнец",
        ["zhCN"] = "奥术重铸师",
        ["zhTW"] = "秘法重鑄師",
    },
    ["Barber"] = { -- male barber
        ["enUS"] = true,
        ["deDE"] = "Barbier",
        ["esES"] = "Peluquero",
        ["esMX"] = "Peluquero",
        ["frFR"] = "Barbier",
        ["koKR"] = "미용사",
        ["ptBR"] = "Barbeiro",
        ["ruRU"] = "Парикмахер",
        ["zhCN"] = "理发师",
        ["zhTW"] = "美容師",
    },
    ["Battle Pet Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Kampfhaustiertrainer",
        ["esES"] = "Instructor de mascotas de duelo",
        ["esMX"] = "Instructor de mascotas de duelo",
        ["frFR"] = "Dresseur de mascottes de combat",
        ["koKR"] = "전투 애완동물 전문가",
        ["ptBR"] = "Adestramento de Batalha",
        ["ruRU"] = "Наставник боевых питомцев",
        ["zhCN"] = "战斗宠物训练师",
        ["zhTW"] = "戰寵訓練師",
    },
}

for k, v in pairs(townsfolkLocales) do
    l10n.translations[k] = v
end
