---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local advancedOptionsLocales = {
    ["Advanced"] = {
        ["enUS"] = true,
        ["deDE"] = "Erweitert",
        ["esES"] = "Avanzado",
        ["esMX"] = "Avanzado",
        ["frFR"] = "Avancé",
        ["koKR"] = "고급",
        ["ptBR"] = "Avançado",
        ["ruRU"] = "Дополнительно",
        ["zhCN"] = "高级",
        ["zhTW"] = "進階",
    },
    ["Advanced Settings"] = {
        ["enUS"] = true,
        ["deDE"] = "Erweiterte Einstellungen",
        ["esES"] = "Configuración avanzada",
        ["esMX"] = "Configuración avanzada",
        ["frFR"] = "Configuration avancée",
        ["koKR"] = "고급 설정",
        ["ptBR"] = "Configurações avançadas",
        ["ruRU"] = "Расширенные настройки",
        ["zhCN"] = "高级选项",
        ["zhTW"] = "進階設定",
    },
    ["Enable Icon Limit"] = {
        ["enUS"] = true,
        ["deDE"] = "Icons limitieren",
        ["esES"] = "Activar límite de icono",
        ["esMX"] = "Activar límite de icono",
        ["frFR"] = "Limiter le nombre d'icônes",
        ["koKR"] = "아이콘 개수 제한 활성화",
        ["ptBR"] = "Ativar limite de ícone",
        ["ruRU"] = "Лимит значков",
        ["zhCN"] = "启用图标限制",
        ["zhTW"] = "啟用圖示限制",
    },
    ["Icon Limit"] = {
        ["enUS"] = true,
        ["deDE"] = "Icon Limit",
        ["esES"] = "Límite de icono",
        ["esMX"] = "Límite de icono",
        ["frFR"] = "Limite d'icônes",
        ["koKR"] = "아이콘 개수 제한",
        ["ptBR"] = "Limite de ícone",
        ["ruRU"] = "Лимит количества значков",
        ["zhCN"] = "图标限制",
        ["zhTW"] = "圖示數量限制",
    },
    ["Enable the limit of icons drawn per type."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert, ob die Menge an Icons pro Typ limitiert wird.",
        ["esES"] = "Activa el límite de iconos por tipo.",
        ["esMX"] = "Activa el límite de iconos por tipo.",
        ["frFR"] = "Active la limite au nombre d'icônes affichées d'un même type.",
        ["koKR"] = "아이콘의 종류 별로 표시할 개수를 제한합니다.",
        ["ptBR"] = "Ativa o limite de ícones desenhados por tipo.",
        ["ruRU"] = "Включает ограничение количества значков, отображаемых для каждого типа",
        ["zhCN"] = "启用对每种类型图标的限制",
        ["zhTW"] = "啟用每種類型繪製圖示的限制。",
    },
    ["Limits the amount of icons drawn per type. ( Default: %s )"] = {
        ["enUS"] = true,
        ["deDE"] = "Wie viele Icons pro Type gezeigt werden sollen. (Standard: %s)",
        ["esES"] = "Limita la cantidad de iconos por tipo. (Predeterminado: %s)",
        ["esMX"] = "Limita la cantidad de iconos por tipo. (Predeterminado: %s)",
        ["frFR"] = "Limite le nombre d'icônes affichées d'un même type. (Par défaut : %s)",
        ["koKR"] = "아이콘의 종류 별로 표시를 제한할 개수를 설정합니다. (기본값: %s)",
        ["ptBR"] = "Limita a quantidade de ícones desenhados por tipo. (Padrão: %s)",
        ["ruRU"] = "Регулировка ограничения количества значков, отображаемых для каждого типа (по умолчанию: %s)",
        ["zhCN"] = "限制每种类型图标数量 (默认: %s)",
        ["zhTW"] = "限制每種類型繪製的圖示數量。(預設值: %s)",
    },
    ["Available quest filter distance"] = {
        ["enUS"] = true,
        ["deDE"] = "Filterdistanz für verfügbare Quests",
        ["esES"] = "Distancia de filtro de misiones disponibles",
        ["esMX"] = "Distancia de filtro de misiones disponibles",
        ["frFR"] = "Distance de filtrage des quêtes disponibles",
        ["koKR"] = "사용가능한 퀘스트를 거리에 따라 필터",
        ["ptBR"] = "Distância do filtro de missões disponíveis",
        ["ruRU"] = "Дистанция фильтра доступных заданий",
        ["zhCN"] = "可用任务过滤距离",
        ["zhTW"] = "可用任務過濾距離",
    },
    ["How far away a spawn starting a quest needs to be inside a zone before another spawn of the same creature or object is added.\n\nWARNING! Setting this to lower values may result in a lot of icons being drawn and can impact map performance!"] = {
        ["enUS"] = true,
        ["deDE"] = "Wie weit entfernt innerhalb einer Zone ein Spawn der einen Quest startet seien muss bevor ein anderer Spawn derselben Kreatur oder desselben Objektes hinzugefügt wird.\n\nWARNUNG! Diese Einstellung auf niedrigere Werte zu setzen kann in einer großen Menge an hinzugefügten Icons resultieren und die Leistung der Karte beeinträchtigen!",
        ["esES"] = "La distancia que debe estar un enemigo u objeto que inicia una misión dentro de una zona antes de que se agregue otro enemigo u objeto del mismo tipo.\n\n¡ADVERTENCIA! Establecer un valor bajo puede resultar en muchos iconos dibujados y afectar el rendimiento del mapa.",
        ["esMX"] = "La distancia que debe estar un enemigo u objeto que inicia una misión dentro de una zona antes de que se agregue otro enemigo u objeto del mismo tipo.\n\n¡ADVERTENCIA! Establecer un valor bajo puede resultar en muchos iconos dibujados y afectar el rendimiento del mapa.",
        ["frFR"] = "À quelle distance un ennemi ou objet déclenchant une quête doit-il se trouver à l'intérieur d'une zone avant qu'un autre ennemi ou objet du même type soit ajouté.\n\nATTENTION ! Régler cette valeur trop bas peut entraîner l'affichage de nombreuses icônes et affecter les performances de la carte.",
        ["koKR"] = "퀘스트를 시작하는 스폰이 같은 생물이나 오브젝트의 다른 스폰에 추가되기 전, 영역 내에서 얼마나 떨어져 있어야 하는지를 설정합니다.\n\n경고! 이 값을 너무 낮게 설정할 경우, 매우 많은 아이콘으로 인해 지도에 성능 저하가 발생할 수 있습니다.",
        ["ptBR"] = "Quão distante um inimigo ou objeto que inicia uma missão precisa estar dentro de uma zona antes que outro inimigo ou objeto do mesmo tipo seja adicionado.\n\nATENÇÃO! Definir um valor muito baixo pode resultar em muitos ícones sendo exibidos e pode afetar o desempenho do mapa.",
        ["ruRU"] = "Насколько далеко начинающий задание объект должен быть в зоне перед тем, как появится следующий такой же объект.\n\nВНИМАНИЕ! Установка пониженных значений может вызвать отображение большого числа значков, а также сильно повлиять на производительность карты!",
        ["zhCN"] = "在区域内，启动任务的生物或对象的生成点需要相距多远才会添加同一生物或对象的另一个生成点。\n\n警告！将此值设置过低可能导致绘制大量图标并影响地图性能！",
        ["zhTW"] = "在區域內，啟動任務的生物或物件的生成點需要相距多遠才會新增同一生物或物件的另一個生成點。\n\n警告！將此值設定過低可能會導致繪製大量圖示並影響地圖效能！",
    },
    ["Available quest icon limit"] = {
        ["enUS"] = true,
        ["deDE"] = "Anzeigelimit für verfügbare Quests",
        ["esES"] = "Límite de iconos de misiones disponibles",
        ["esMX"] = "Límite de iconos de misiones disponibles",
        ["frFR"] = "Limite d'icônes des quêtes disponibles",
        ["koKR"] = "사용가능한 궤스트 아이콘 제한",
        ["ptBR"] = "Limite de ícones de missões disponíveis",
        ["ruRU"] = "Лимит значков доступных заданий",
        ["zhCN"] = "可用任务图标限制",
        ["zhTW"] = "可用任務圖示限制",
    },
    ["This setting limits the number of icons starting a single quest.\n\nSetting to zero means there is no limit (except through other settings).\n\nWARNING! Setting this to 0 may result in a lot of icons being drawn and can impact map performance!"] = {
        ["enUS"] = true,
        ["deDE"] = "Diese Einstellung limitiert die Anzahl an Icons die einen einzelnen Quest starten.\n\nDie Einstellung auf Null setzen bedeutet es gibt kein Limit (außer durch andere Einstellungen).\n\nWARNUNG! Diese Einstellung auf Null zu setzen kann in einer großen Menge an hinzugefügten Icons resultieren und die Leistung der Karte beeinträchtigen!",
        ["esES"] = "Esta opción limita la cantidad de iconos que inician una sola misión.\n\nEstablecerlo en cero significa que no hay límite (excepto por otras configuraciones).\n\n¡ADVERTENCIA! Establecerlo en 0 puede resultar en muchos iconos dibujados y afectar el rendimiento del mapa.",
        ["esMX"] = "Esta opción limita la cantidad de iconos que inician una sola misión.\n\nEstablecerlo en cero significa que no hay límite (excepto por otras configuraciones).\n\n¡ADVERTENCIA! Establecerlo en 0 puede resultar en muchos iconos dibujados y afectar el rendimiento del mapa.",
        ["frFR"] = "Ce paramètre limite le nombre d'icônes déclenchant une seule quête.\n\nLe régler sur zéro signifie qu'il n'y a aucune limite (sauf par d'autres paramètres).\n\nATTENTION ! Régler cette valeur à 0 peut entraîner l'affichage de nombreuses icônes et affecter les performances de la carte.",
        ["koKR"] = "이 설정은 단일 퀘스트를 시작하는 아이콘 수를 제한합니다.\n\n비활성화 하려면 0으로 설정 (다른 설정 제외) 하세요.\n\n경고! 이 값을 0으로 설정할 경우, 매우 많은 아이콘으로 인해 지도에 성능 저하가 발생할 수 있습니다.",
        ["ptBR"] = "Esta configuração limita o número de ícones que iniciam uma única missão.\n\nDefinir como zero significa que não há limite (exceto por outras configurações).\n\nATENÇÃO! Definir como 0 pode resultar em muitos ícones sendo exibidos e pode afetar o desempenho do mapa.",
        ["ruRU"] = "Эта опция ограничивает количество значков, начинающих задание.\n\nНоль означает отсутствие лимита (за исключением других настроек).\n\nВНИМАНИЕ! Установка на ноль может вызвать отображение большого числа значков, а также сильно повлиять на производительность карты!",
        ["zhCN"] = "此设置限制单个任务启动时显示的图标数量。\n\n设置为零表示没有限制（除非通过其他设置）。\n\n警告！将此值设置为0可能导致绘制大量图标并影响地图性能！",
        ["zhTW"] = "此設定限制單個任務啟動時顯示的圖示數量。\n\n設定為零表示沒有限制（除非透過其他設定）。\n\n警告！將此值設定為0可能會導致繪製大量圖示並影響地圖效能！",
    },
    ["Enable bug workarounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Bug-Workarounds aktivieren",
        ["esES"] = "Activar soluciones de errores",
        ["esMX"] = "Activar soluciones de errores",
        ["frFR"] = "Activer les contournements de bugs",
        ["koKR"] = "버그 해결 방법 활성화",
        ["ptBR"] = "Ativar soluções alternativas para bugs",
        ["ruRU"] = "Обходные решения",
        ["zhCN"] = "启用错误修正功能",
        ["zhTW"] = "啟用錯誤修正功能",
    },
    ["When enabled, Questie will hotfix vanilla UI bugs."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert, dass Questie Fehler im Vanilla UI behebt.",
        ["esES"] = "Si está activado, Questie corregirá los errores de la interfaz de usuario.",
        ["esMX"] = "Si está activado, Questie corregirá los errores de la interfaz de usuario.",
        ["frFR"] = "Si cette option est activée, Questie corrigera les bugs de l'interface utilisateur.",
        ["koKR"] = "활성화되면 Questie가 기본 UI 버그를 수정합니다.",
        ["ptBR"] = "Se ativado, Questie corrigirá bugs da interface do usuário.",
        ["ruRU"] = "Когда включено, Questie будет исправлять ошибки классического интерфейса",
        ["zhCN"] = "启用时，任务提示插件会热修经典的界面错误。",
        ["zhTW"] = "啟用時，任務位置提示插件會熱修經典的介面錯誤。",
    },
    ["Developer Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Entwickler-Einstellungen",
        ["esES"] = "Opciones de desarrollo",
        ["esMX"] = "Opciones de desarrollo",
        ["frFR"] = "Options de développement",
        ["koKR"] = "개발자 설정",
        ["ptBR"] = "Opções do desenvolvimento",
        ["ruRU"] = "Настройки разработчика",
        ["zhCN"] = "开发者选项",
        ["zhTW"] = "開發者選項",
    },
    ["Show Quest IDs"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeige Quest-IDs",
        ["esES"] = "Mostrar ID de misión",
        ["esMX"] = "Mostrar ID de misión",
        ["frFR"] = "Afficher l'ID des quêtes",
        ["koKR"] = "퀘스트 ID 표시",
        ["ptBR"] = "Mostrar ID de missão",
        ["ruRU"] = "Показать ID заданий",
        ["zhCN"] = "显示任务ID",
        ["zhTW"] = "顯示任務 ID",
    },
    ["When this is checked, the ID of quests will show in tooltips and the tracker."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert, dass die Quest-ID in den Tooltips und dem Tracker angezeigt werden.",
        ["esES"] = "Si está activado, la ID de misiones se mostrará en los tooltips y el rastreador.",
        ["esMX"] = "Si está activado, la ID de misiones se mostrará en los tooltips y el rastreador.",
        ["frFR"] = "Si cette option est activée, l'ID des quêtes sera affichée dans les infobulles et le suivi des quêtes.",
        ["koKR"] = "퀘스트의 ID를 툴팁과 추적기에 표시합니다.",
        ["ptBR"] = "Se ativado, a ID de missões será mostrada nas dicas de ferramentas e no rastreador.",
        ["ruRU"] = "Когда включено, ID заданий будут отображаться во всплывающих подсказках и в трекере",
        ["zhCN"] = "勾选此选项后，任务ID将显示在鼠标提示和跟踪器中",
        ["zhTW"] = "啟用時，會在浮動提示資訊和任務追蹤清單內顯示任務 ID。",
    },
    ["Enable Debug"] = {
        ["enUS"] = true,
        ["deDE"] = "Debugging aktivieren",
        ["esES"] = "Activar depuración",
        ["esMX"] = "Activar depuración",
        ["frFR"] = "Activer le débogage",
        ["koKR"] = "디버그 활성화",
        ["ptBR"] = "Ativar depuração",
        ["ruRU"] = "Режим отладки",
        ["zhCN"] = "启用Debug",
        ["zhTW"] = "啟用除錯",
    },
    ["Enable or disable debug functionality."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert die Debugging Funktion.",
        ["esES"] = "Si está activado, se volverá el modo de depuración.",
        ["esMX"] = "Si está activado, se volverá el modo de depuración.",
        ["frFR"] = "Si cette option est activée, le mode de débogage sera activé.",
        ["koKR"] = "디버그 기능을 사용합니다.",
        ["ptBR"] = "Se ativado, o modo de depuração será ativado.",
        ["ruRU"] = "Включить/отключить режим отладки",
        ["zhCN"] = "启用或停用Debug功能",
        ["zhTW"] = "啟用或停用除錯的功能。",
    },
    ["Debug level to print"] = {
        ["enUS"] = true,
        ["deDE"] = "Debug-Level",
        ["esES"] = "Nivel de depuración a mostrar",
        ["esMX"] = "Nivel de depuración a mostrar",
        ["frFR"] = "Niveau de débogage à afficher",
        ["koKR"] = "디버그 레벨 출력",
        ["ptBR"] = "Nível de depuração a ser mostrado",
        ["ruRU"] = "Уровень отладки для вывода в чат",
        ["zhCN"] = "Debug等级",
        ["zhTW"] = "除錯訊息等級",
    },
    ["Hitting this button will reset all of the Questie configuration settings back to their default values. (Excluding Localization)"] = {
        ["enUS"] = true,
        ["deDE"] = "Setzt alle Einstellungen von Questie auf den Standardwert zurück (Lokalisierung ausgeschlossen).",
        ["esES"] = "Al hacer clic este botón restablecerá toda la configuración de Questie a los valores predeterminados. (Menos el idioma)",
        ["esMX"] = "Al hacer clic este botón restablecerá toda la configuración de Questie a los valores predeterminados. (Menos el idioma)",
        ["frFR"] = "Activer ce bouton réinitialisera tous les paramètres de Questie à leurs valeurs par défaut. (sauf choix de la langue)",
        ["koKR"] = "이 버튼을 누르면 모든 Questie 설정이 기본값으로 초기화됩니다. (언어 설정 제외)",
        ["ptBR"] = "Se clicar nesse botão redefinirá todas as configurações de Questie para seus valores padrão. (Não o idioma)",
        ["ruRU"] = "Нажатие этой кнопки приведет к сбросу всех настроек аддона (за исключением языка)",
        ["zhCN"] = "点击这个按钮将会使Questie除了本地化以外的所有设置重置为默认值。",
        ["zhTW"] = "按下這個按鈕會將任務位置提示插件的所有設定重置成預設值。(語言設定除外)",
    },
    ["Reset Questie"] = {
        ["enUS"] = true,
        ["deDE"] = "Questie zurücksetzen",
        ["esES"] = "Restablecer Questie",
        ["esMX"] = "Restablecer Questie",
        ["frFR"] = "Réinitialiser Questie",
        ["koKR"] = "Quetie 초기화",
        ["ptBR"] = "Redefinir Questie",
        ["ruRU"] = "Сбросить настройки",
        ["zhCN"] = "重置Questie",
        ["zhTW"] = "重置任務位置提示",
    },
    ["Reset Questie to the default values for all settings."] = {
        ["enUS"] = true,
        ["deDE"] = "Setzt alle Einstellungen von Questie auf den Standardwert zurück.",
        ["esES"] = "Restablece Questie a todos los valores predeterminados.",
        ["esMX"] = "Restablece Questie a todos los valores predeterminados.",
        ["frFR"] = "Réinitialise Questie aux valeurs par défaut pour tous les paramètres.",
        ["koKR"] = "모든 Questie 설정을 기본값으로 초기화합니다.",
        ["ptBR"] = "Redefine a Questie para valores para todas as configurações.",
        ["ruRU"] = "Сбросить настройки аддона к значениям по умолчанию",
        ["zhCN"] = "将所有设置重置为默认值。",
        ["zhTW"] = "重置任務位置提示插件，所有設定都恢復成預設值。",
    },
    ["Reset Questie Journey"] = {
        ["enUS"] = true,
        ["deDE"] = "Questie Reise zurücksetzen",
        ["esES"] = "Restablecer viaje",
        ["esMX"] = "Restablecer viaje",
        ["frFR"] = "Réinitialiser le voyage",
        ["koKR"] = "Questie 여정 초기화",
        ["ptBR"] = "Redefinir jornada",
        ["ruRU"] = "Сброс Путешествия",
        ["zhCN"] = "重置 Questie 任务历程",
        ["zhTW"] = "重置 Questie 冒險日記",
    },
    ["Clear the Journey of the current character"] = {
        ["enUS"] = true,
        ["deDE"] = "Löscht die Reisedaten des aktuellen Charakters",
        ["esES"] = "Restablece el viaje del personaje actual",
        ["esMX"] = "Restablece el viaje del personaje actual",
        ["frFR"] = "Réinitialise le voyage du personnage actuel",
        ["koKR"] = "현재 캐릭터의 여정을 초기화합니다",
        ["ptBR"] = "Redefine a jornada do personagem atual",
        ["ruRU"] = "Сбросить данные раздела 'Путешествие' для текущего персонажа",
        ["zhCN"] = "清除当前角色的任务历程",
        ["zhTW"] = "清空當前角色的冒險日記",
    },
    ["Recompile Database"] = {
        ["enUS"] = true,
        ["deDE"] = "Datenbank neukompilieren",
        ["esES"] = "Recompilar base de datos",
        ["esMX"] = "Recompilar base de datos",
        ["frFR"] = "Recompiler la base de données",
        ["koKR"] = "데이터베이스 재설정",
        ["ptBR"] = "Recompilar banco de dados",
        ["ruRU"] = "Перекомпиляция БД",
        ["zhCN"] = "重建数据库",
        ["zhTW"] = "重建資料庫",
    },
    ["Forces a recompile of the Questie database. This will also reload the UI."] = {
        ["enUS"] = true,
        ["deDE"] = "Lässt die Questie Datenbank neu kompilieren und läd das UI neu.",
        ["esES"] = "Fuerza una recompilación de la base de datos Questie. Esto también volverá a cargar la interfaz de usuario.",
        ["esMX"] = "Fuerza una recompilación de la base de datos Questie. Esto también volverá a cargar la interfaz de usuario.",
        ["frFR"] = "Force une recompilation de la base de données Questie. Cela recharge aussi votre interface graphique.",
        ["koKR"] = "퀘스트 데이터베이스를 강제로 재설정합니다. UI는 Reload됩니다.",
        ["ptBR"] = "Força uma recompilação do banco de dados de Questie. Isso também recarregará a interface do usuário.",
        ["ruRU"] = "Принудительная перекомпиляция базы данных Questie. При этом перезагрузится пользовательский интерфейс",
        ["zhCN"] = "强制重建任务数据库。这会重新加载插件",
        ["zhTW"] = "強制重建任務位置提示插件的資料庫，同時也會重新載入介面。",
    },
    ["Open Profiler"] = {
        ["enUS"] = true,
        ["deDE"] = "Profiler öffnen",
        ["esES"] = "Abrir perfilador",
        ["esMX"] = "Abrir perfilador",
        ["frFR"] = "Ouvrir le profileur",
        ["koKR"] = "프로파일러를 엽니다.",
        ["ptBR"] = "Abrir perfilador",
        ["ruRU"] = "Открыть профайлер",
        ["zhCN"] = "打开分析器",
        ["zhTW"] = "打開效能分析",
    },
    ["Open the Questie profiler, this is useful for tracking down the source of lag / frame spikes."] = {
        ["enUS"] = true,
        ["deDE"] = "Der Profiler ermöglich das Ermitteln von Ursachen für Lags und FPS Verlusten.",
        ["esES"] = "Abre el perfilador de Questie, esto es útil para rastrear la fuente de picos de latencia.",
        ["esMX"] = "Abre el perfilador de Questie, esto es útil para rastrear la fuente de picos de latencia.",
        ["frFR"] = "Ouvrez le profileur Questie, cela est utile pour rechercher la source des pics de latence / image.",
        ["koKR"] = "Questie 프로파일러를 엽니다. 이 프로파일러는 지연/프레임 스파이크의 소스를 추적하는 데 유용합니다.",
        ["ptBR"] = "Abre o perfilador Questie, isso é útil para rastrear a fonte de picos da latência.",
        ["ruRU"] = "Открывает профайлер Questie. Полезен для отслеживания источников лагов или падения FPS",
        ["zhCN"] = "打开 Questie 分析器, 这对于追踪延迟/帧数峰值的来源很有用",
        ["zhTW"] = "打開任務位置提示插件的效能分析，對於追蹤延遲/掉幀的原因很有幫助。",
    },
    ["Localization Settings"] = {
        ["enUS"] = true,
        ["deDE"] = "Spracheinstellungen",
        ["esES"] = "Opciones de idioma",
        ["esMX"] = "Opciones de idioma",
        ["frFR"] = "Options de la langue",
        ["koKR"] = "언어 설정",
        ["ptBR"] = "Opções de idioma",
        ["ruRU"] = "Язык аддона",
        ["zhCN"] = "语言设置",
        ["zhTW"] = "語言設定",
    },
    ["Select UI Locale"] = {
        ["enUS"] = true,
        ["deDE"] = "Interface-Sprache wählen",
        ["esES"] = "Seleccionar idioma",
        ["esMX"] = "Seleccionar idioma",
        ["frFR"] = "Sélection de la langue",
        ["koKR"] = "UI 언어 설정",
        ["ptBR"] = "Selecionar idioma",
        ["ruRU"] = "Выберите язык",
        ["zhCN"] = "选择界面语言",
        ["zhTW"] = "選擇介面語言",
    },
    ["Automatic"] = {
        ["enUS"] = true,
        ["deDE"] = "Automatisch",
        ["esES"] = "Automático",
        ["esMX"] = "Automático",
        ["frFR"] = "Automatique",
        ["koKR"] = "자동",
        ["ptBR"] = "Automático",
        ["ruRU"] = "Автовыбор",
        ["zhCN"] = "自动选择",
        ["zhTW"] = "自動",
    },
    ["Questie is under active development for World of Warcraft: Classic. Please check GitHub for the latest alpha builds or to report issues. Or join us on our discord! (( https://github.com/Questie/Questie/ ))"] = {
        ["enUS"] = true,
        ["deDE"] = "Questie befindet sich noch aktiv in der Entwicklungsphase für World of Warcraft: Classic. Für Neuigkeiten und aktuelle Versionen schau auf Github vorbei oder trete unserem Discord Server bei! (( https://github.com/Questie/Questie/ ))",
        ["esES"] = "Questie está bajo desarrollo activo para World of Warcraft: Classic. Por favor ve a Github para las versiones alfa o para reportar problemas. O únete a nuestro Discord! (https://github.com/Questie/Questie/)",
        ["esMX"] = "Questie está bajo desarrollo activo para World of Warcraft: Classic. Por favor ve a Github para las versiones alfa o para reportar problemas. O únete a nuestro Discord! (https://github.com/Questie/Questie/)",
        ["frFR"] = "Questie est en cours de développement pour World of Warcraft: Classic. Veuillez consulter GitHub pour connaître les dernières versions alpha ou signaler des problèmes. Ou rejoignez nous sur notre discord ! ( https://github.com/Questie/Questie/ ) ",
        ["koKR"] = "Questie는 월드 오브 워크래프트:클래식을 위해 활발히 개발 중입니다. 최신 알파 빌드 또는 보고된 문제들을 확인하시려면 GitHub을 확인해주세요. 또는 저희 디스코드에 참여하세요! (( https://github.com/Questie/Questie/ ))",
        ["ptBR"] = "Questie está em desenvolvimento para World of Warcraft: Classic. Verifique o GitHub para obter as versões mais recentes ou relatar problemas. Ou junte-se a nós em nossa Discord!(https://github.com/Questie/Questie/)",
        ["ruRU"] = "Questie находится в стадии активной разработки для World of Warcraft: Classic. Проверяйте наличие обновлений на сайте GitHub (https://github.com/Questie/Questie/) или присоединяйтесь к нашему серверу в Discord (https://discord.gg/phKnHVu)",
        ["zhCN"] = "Questie是一款为魔兽世界经典旧世制作的任务插件，目前仍在开发中，请到Github查看最新版本、提交问题或提供建议，或是加入我们的 discord 频道。(( https://github.com/Questie/Questie/ ))",
        ["zhTW"] = "任務位置提示插件 Questie 正在為了魔獸世界：經典版積極開發中。請到 GitHub 取得最新的 alpha 版本和回報問題，或是在 Discord 上加入我們! (( https://github.com/Questie/Questie/ ))",
    },
    ["Skip Validation"] = {
        ["enUS"] = true,
        ["deDE"] = "Validierung überspringen",
        ["esES"] = "Omitir validación",
        ["esMX"] = "Omitir validación",
        ["frFR"] = "Ignorer la validation",
        ["koKR"] = "검증 건너뛰기",
        ["ptBR"] = "Omitir validação",
        ["ruRU"] = "Пропуск валидации",
        ["zhCN"] = "跳过验证",
        ["zhTW"] = "跳過檢查",
    },
    ["Skip database validation upon recompile. Validation is only present with debug enabled in the first place."] = {
        ["enUS"] = true,
        ["deDE"] = "Die Datenbank-Validierung beim Neukompilieren überspringen. Die Validierung findet nur bei aktivem Debugging statt.",
        ["esES"] = "Si está activado, se omitirá la validación de la base de datos al volver a compilar. La validación solo está presente con la depuración activada.",
        ["esMX"] = "Si está activado, se omitirá la validación de la base de datos al volver a compilar. La validación solo está presente con la depuración activada.",
        ["frFR"] = "Si cette option est activée, la validation de la base de données sera ignorée lors de la recompilation. La validation est uniquement présente lorsque le débogage est activé.",
        ["koKR"] = "다시 컴파일할 때 데이터베이스 검증을 건너뜁니다. 검증은 디버그가 활성화된 경우에만 수행됩니다.",
        ["ptBR"] = "Se ativado, a validação do banco de dados será omitida ao recompilar. A validação está presente apenas com a depuração ativada.",
        ["ruRU"] = "Пропустить валидацию БД после перекомпиляции. Валидация имеется только при включенном режиме отладки",
        ["zhCN"] = "重建数据库时跳过验证。只有将Debug模式开启的情况下才能进行验证",
        ["zhTW"] = "重新編譯時跳過資料庫驗證。只有先啟用除錯的情況下才會進行驗證。",
    },
    ["Quel'Danas Settings"] = {
        ["enUS"] = true,
        ["deDE"] = "Quel'Danas Einstellungen",
        ["esES"] = "Opciones de Quel'Danas",
        ["esMX"] = "Opciones de Quel'Danas",
        ["frFR"] = "Options de Quel'Danas",
        ["koKR"] = "쿠엘다나스 설정",
        ["ptBR"] = "Opçoes de Quel'Danas",
        ["ruRU"] = "Настройки Кель'Данаса",
        ["zhCN"] = "奎尔丹纳斯选项",
        ["zhTW"] = "奎爾達納斯設定",
    },
    ["Show Item IDs"] = {
        ["enUS"] = true,
        ["deDE"] = "Gegenstand-IDs anzeigen",
        ["esES"] = "Mostrar ID de artículo",
        ["esMX"] = "Mostrar ID de artículo",
        ["frFR"] = "Afficher l'ID d'objets",
        ["koKR"] = "아이템 ID 표시",
        ["ptBR"] = "Mostrar IDs de itens",
        ["ruRU"] = "Показать ID предметов",
        ["zhCN"] = "显示物品 ID",
        ["zhTW"] = "顯示物品 ID",
    },
    ["When this is checked, the ID of items will shown in tooltips."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, werden die Gegenstand-IDs in den Tooltips angezeigt.",
        ["esES"] = "Si está activado, la ID de los artículos se mostrará en los tooltips.",
        ["esMX"] = "Si está activado, la ID de los artículos se mostrará en los tooltips.",
        ["frFR"] = "Si cette option est activée, l'ID des objets sera affiché dans les infobulles.",
        ["koKR"] = "이 옵션을 선택하면 아이템 ID가 툴팁에 표시됩니다.",
        ["ptBR"] = "Se ativado, a ID dos itens será mostrada nas dicas de ferramentas.",
        ["ruRU"] = "Когда это включено, в подсказках будут отображаться ID предметов",
        ["zhCN"] = "启用后，物品ID会在悬浮窗中显示",
        ["zhTW"] = "啟用時，會在浮動提示資訊中顯示物品 ID。",
    },
    ["Show Object IDs"] = {
        ["enUS"] = true,
        ["deDE"] = "Objekt-IDs anzeigen",
        ["esES"] = "Mostrar ID de objeto",
        ["esMX"] = "Mostrar ID de objeto",
        ["frFR"] = "Afficher l'ID d'objets",
        ["koKR"] = "오브젝트 ID 표시",
        ["ptBR"] = "Mostrar IDs de objetos",
        ["ruRU"] = "Показать ID объектов",
        ["zhCN"] = "显示物体 ID",
        ["zhTW"] = "顯示物體 ID",
    },
    ["When this is checked, the ID of objects will be shown in tooltips. These are guesses and only show the first matching ID in the QuestieDB."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, werden die Objekt-IDs in den Tooltips angezeigt. Diese sind Schätzungen und zeigen nur die erste passende ID aus der QuestieDB.",
        ["esES"] = "Si está activado, la ID de los objetos se mostrará en los tooltips. Estas son conjeturas y solo muestran la primera identificación coincidente en QuestieDB.",
        ["esMX"] = "Si está activado, la ID de los objetos se mostrará en los tooltips. Estas son conjeturas y solo muestran la primera identificación coincidente en QuestieDB.",
        ["frFR"] = "Si cette option est activée, l'ID des objets sera affichée dans les infobulles. Ce ne sont que des suppositions et ne montrent que le premier ID correspondant dans la base de données de Questie.",
        ["koKR"] = "이 옵션을 선택하면 오브젝트 ID가 툴팁에 표시됩니다. 이는 예측값이며 QuestieDB에서 첫 번째로 일치하는 ID만 표시됩니다.",
        ["ptBR"] = "Se ativado, a ID dos objetos será mostrada nas dicas de ferramentas. Esses são palpites e mostram apenas a primeira ID correspondente no QuestieDB.",
        ["ruRU"] = "Когда это включено, в подсказках будут отображаться ID объектов. Эти данные являются предполагаемыми, отображается только первый совпадающий ID в БД Questie",
        ["zhCN"] = "当勾选此项时，物体的 ID 会显示在提示中。这些仅为猜测，并且只显示 QuestieDB 中第一个匹配的 ID。",
        ["zhTW"] = "當勾選此項時，物體的 ID 將顯示在提示中。這些僅為猜測，且只會顯示 QuestieDB 中第一個符合的 ID。",
    },
    ["Show NPC IDs"] = {
        ["enUS"] = true,
        ["deDE"] = "NPC-IDs anzeigen",
        ["esES"] = "Mostrar ID de PNJ",
        ["esMX"] = "Mostrar ID de PNJ",
        ["frFR"] = "Afficher l'ID des PNJ",
        ["koKR"] = "NPC ID 표시",
        ["ptBR"] = "Mostrar IDs de NPCs",
        ["ruRU"] = "Показать ID NPC",
        ["zhCN"] = "显示 NPC ID",
        ["zhTW"] = "顯示 NPC ID",
    },
    ["When this is checked, the ID of NPCs will be shown in tooltips."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, werden die NPC-IDs in den Tooltips angezeigt.",
        ["esES"] = "Si está activado, la ID de los PNJ se mostrará en los tooltips.",
        ["esMX"] = "Si está activado, la ID de los PNJ se mostrará en los tooltips.",
        ["frFR"] = "Si cette option est activée, l'ID des PNJ sera affichée dans les infobulles.",
        ["koKR"] = "이 옵션을 선택하면 NPC ID가 툴팁에 표시됩니다.",
        ["ptBR"] = "Se ativado, a ID dos NPCs será mostrada nas dicas de ferramentas.",
        ["ruRU"] = "Когда это включено, в подсказках будут отображаться ID NPC",
        ["zhCN"] = "启用后，NPC ID会在悬浮窗中显示",
        ["zhTW"] = "啟用時，會在浮動提示資訊中顯示 NPC ID。",
    },
    ["Hide Startup Warnings"] = {
        ["enUS"] = true,
        ["deDE"] = "Start-Warnungen ausblenden",
        ["esES"] = "Ocultar avisos de inicio",
        ["esMX"] = "Ocultar avisos de inicio",
        ["frFR"] = "Cacher les avertissements de démarrage",
        ["koKR"] = "시작 경고 숨기기",
        ["ptBR"] = "Ocultar avisos de inicialização",
        ["ruRU"] = "Скрыть предупреждение при входе",
        ["zhCN"] = "隐藏启动警告",
        ["zhTW"] = "隱藏啟動時的警告",
    },
    ["Disables the \"Welcome to Cataclysm Classic\" message on startup."] = {
        ["enUS"] = true,
        ["deDE"] = "Deaktiviert die \"Willkommen zu Cataclysm Classic\" Nachricht beim Start.",
        ["esES"] = "Desactiva el mensaje de \"Bienvenido a Cataclysm Classic\" al inicio.",
        ["esMX"] = "Desactiva el mensaje de \"Bienvenido a Cataclysm Classic\" al inicio.",
        ["frFR"] = "Désactive le message \"Bienvenue sur Cataclysm Classic\" au démarrage.",
        ["koKR"] = "시작 메세지 \"Cataclysm Classic에 오신 것을 환영합니다\"를 비활성화합니다.",
        ["ptBR"] = "Desativa a mensagem \"Bem-vindo ao Cataclysm Classic\" na inicialização.",
        ["ruRU"] = "Отключает сообщение \"Добро пожаловать в Cataclysm Classic!\" при входе в игру",
        ["zhCN"] = "屏蔽进入游戏时的欢迎信息",
        ["zhTW"] = "停用啟動時的 \"歡迎來到浩劫與重生\" 訊息。",
    },
    ["Enable bug hints for all game versions"] = {
        ["enUS"] = true,
        ["deDE"] = "Bug-Hinweise für alle Spielversionen aktivieren",
        ["esES"] = "Activar sugerencias de errores para todas las versiones del juego",
        ["esMX"] = "Activar sugerencias de errores para todas las versiones del juego",
        ["frFR"] = "Activer les indices de bugs pour toutes les versions du jeu",
        ["koKR"] = "모든 게임 버전에 대한 버그 힌트 활성화",
        ["ptBR"] = "Ativar dicas de bugs para todas as versões do jogo",
        ["ruRU"] = "Подсказки об ошибках для всех версий",
        ["zhCN"] = "为所有游戏版本致能错误提示",
        ["zhTW"] = "啟用錯誤提示 (所有遊戲版本)",
    },
    ["Enables the bug hint windows for all game versions, usually used for bug reports in SoD."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert die Bug-Hinweisfenster für alle Spielversionen, das normalerweise für Fehlerberichte in SoD verwendet wird.",
        ["esES"] = "Si está activado, se mostrarán las ventanas de sugerencias de errores para todas las versiones del juego, generalmente utilizadas para informes de errores en SoD.",
        ["esMX"] = "Si está activado, se mostrarán las ventanas de sugerencias de errores para todas las versiones del juego, generalmente utilizadas para informes de errores en SoD.",
        ["frFR"] = "Si cette option est activée, les fenêtres d'indices de bugs seront affichées pour toutes les versions du jeu, généralement utilisées pour les rapports de bugs dans SoD.",
        ["koKR"] = "모든 게임 버전에 대한 버그 힌트 창을 활성화합니다. 주로 SoD에서 버그 보고에 사용됩니다.",
        ["ptBR"] = "Se ativado, as janelas de dicas de bugs serão mostradas para todas as versões do jogo, geralmente usadas para relatórios de bugs no SoD.",
        ["ruRU"] = "Включает окна подсказок об ошибках, обычно используемые в SoD, для всех версий игры",
        ["zhCN"] = "致能所有游戏版本的错误提示窗口，通常用于 SoD 中的错误报告。",
        ["zhTW"] = "為所有遊戲版本啟用，通常用於探索賽季中回報錯誤的錯誤提示視窗。",
    },
}

for k, v in pairs(advancedOptionsLocales) do
    l10n.translations[k] = v
end
