---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local dungeonLocales = {
    ["A Brewing Storm"] = {
        ["enUS"] = true,
        ["deDE"] = "Ein Sturm braut sich zusammen",
        ["esES"] = "Cervezas y Truenos",
        ["esMX"] = "Cervezas y Truenos",
        ["frFR"] = "Une bière foudroyante",
        ["koKR"] = "양조 폭풍",
        ["ptBR"] = "Tempestade Cervejeira",
        ["ruRU"] = "Хмельная буря",
        ["zhCN"] = "酝酿风暴",
        ["zhTW"] = "雷電佳釀",
    },
    ["A Little Patience"] = {
        ["enUS"] = true,
        ["deDE"] = "Ein wenig Geduld",
        ["esES"] = "Templanza",
        ["esMX"] = "Templanza",
        ["frFR"] = "Un peu de patience",
        ["koKR"] = "약간의 참을성",
        ["ptBR"] = "Um Pouco de Paciência",
        ["ruRU"] = "Немного терпения",
        ["zhCN"] = "王者的耐心",
        ["zhTW"] = "耐心試煉",
    },
    ["Arena of Annihilation"] = {
        ["enUS"] = true,
        ["deDE"] = "Arena der Auslöschung",
        ["esES"] = "Arena de la Aniquilación",
        ["esMX"] = "Arena de la Aniquilación",
        ["frFR"] = "Arène de l’Annihilation",
        ["koKR"] = "파멸의 투기장",
        ["ptBR"] = "Arena da Aniquilação",
        ["ruRU"] = "Арена Истребления",
        ["zhCN"] = "破军比武场",
        ["zhTW"] = "殲滅競技場",
    },
    ["Assault on Zan'vess"] = {
        ["enUS"] = true,
        ["deDE"] = "Angriff auf Zan'vess",
        ["esES"] = "Asalto a Zan'vess",
        ["esMX"] = "Asalto a Zan'vess",
        ["frFR"] = "L’assaut de Zan’vess",
        ["koKR"] = "잔베스 강습",
        ["ptBR"] = "Ataque a Zan'vess",
        ["ruRU"] = "Атака на Зан'весс",
        ["zhCN"] = "突袭扎尼维斯",
        ["zhTW"] = "襲擊贊斐斯",
    },
    ["Battle on the High Seas"] = {
        ["enUS"] = true,
        ["deDE"] = "Schlacht auf hoher See",
        ["esES"] = "Batalla en Alta Mar",
        ["esMX"] = "Batalla en Alta Mar",
        ["frFR"] = "Bataille en haute mer",
        ["koKR"] = "공해 상에서의 전투",
        ["ptBR"] = "Batalha em Alto Mar",
        ["ruRU"] = "Битва в открытом море",
        ["zhCN"] = "公海激战",
        ["zhTW"] = "怒海之戰",
    },
    ["Blood in the Snow"] = {
        ["enUS"] = true,
        ["deDE"] = "Blutroter Schnee",
        ["esES"] = "Sangre en la Nieve",
        ["esMX"] = "Sangre en la Nieve",
        ["frFR"] = "Du sang dans la neige",
        ["koKR"] = "피로 얼룩진 설원",
        ["ptBR"] = "Sangue na Neve",
        ["ruRU"] = "Кровь на снегу",
        ["zhCN"] = "雪山血战",
        ["zhTW"] = "血染滄雪",
    },
    ["Brewmoon Festival"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Braumondfest",
        ["esES"] = "Festival de la Cerveza Lunar",
        ["esMX"] = "Festival de la Cerveza Lunar",
        ["frFR"] = "Festival de Brasse-Lune",
        ["koKR"] = "맥주달 축제",
        ["ptBR"] = "Festival da Cerveja da Lua",
        ["ruRU"] = "Фестиваль Хмельнолуния",
        ["zhCN"] = "酿月祭",
        ["zhTW"] = "酒月節",
    },
    ["Crypt of Forgotten Kings"] = {
        ["enUS"] = true,
        ["deDE"] = "Gruft der Vergessenen Könige",
        ["esES"] = "Cripta de los Reyes Olvidados",
        ["esMX"] = "Cripta de los Reyes Olvidados",
        ["frFR"] = "Crypte des Rois oubliés",
        ["koKR"] = "잊혀진 왕의 납골당",
        ["ptBR"] = "Cripta dos Reis Esquecidos",
        ["ruRU"] = "Гробница Забытых Королей",
        ["zhCN"] = "遗忘之王古墓",
        ["zhTW"] = "遺忘諸王墓穴",
    },
    ["Dagger in the Dark"] = {
        ["enUS"] = true,
        ["deDE"] = "Ein Dolch im Dunkel",
        ["esES"] = "Una Daga en la Oscuridad",
        ["esMX"] = "Una Daga en la Oscuridad",
        ["frFR"] = "Une dague dans la nuit",
        ["koKR"] = "어둠 속의 비수",
        ["ptBR"] = "Adaga no Escuro",
        ["ruRU"] = "Кинжал во тьме",
        ["zhCN"] = "黑暗中的匕首",
        ["zhTW"] = "暗箭難防",
    },
    ["Dark Heart of Pandaria"] = {
        ["enUS"] = true,
        ["deDE"] = "Das dunkle Herz Pandarias",
        ["esES"] = "Corazón Oscuro de Pandaria",
        ["esMX"] = "Corazón Oscuro de Pandaria",
        ["frFR"] = "Le sombre cœur de la Pandarie",
        ["koKR"] = "판다리아의 검은 심장",
        ["ptBR"] = "Coração Sombrio de Pandária",
        ["ruRU"] = "Темное сердце Пандарии",
        ["zhCN"] = "潘达利亚的黑暗之心",
        ["zhTW"] = "潘達利亞的黑暗之心",
    },
    ["Domination Point"] = {
        ["enUS"] = true,
        ["deDE"] = "Krasarangwildnis",
        ["esES"] = "Espesura Krasarang",
        ["esMX"] = "Espesura Krasarang",
        ["frFR"] = "Étendues sauvages de Krasarang",
        ["koKR"] = "크라사랑 밀림",
        ["ptBR"] = "Selva de Krasarang",
        ["ruRU"] = "Красарангские джунгли",
        ["zhCN"] = "卡桑琅丛林",
        ["zhTW"] = "喀撒朗蠻荒",
    },
    ["Greenstone Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Grünstein",
        ["esES"] = "Aldea Verdemar",
        ["esMX"] = "Aldea Verdemar",
        ["frFR"] = "Pierre-Verte",
        ["koKR"] = "녹옥 마을",
        ["ptBR"] = "Aldeia Rocha Verde",
        ["ruRU"] = "Деревня Зеленой Скалы",
        ["zhCN"] = "绿石村",
        ["zhTW"] = "綠石村",
    },
    ["Lion's Landing"] = {
        ["enUS"] = true,
        ["deDE"] = "Löwenlandung",
        ["esES"] = "Desembarco del León",
        ["esMX"] = "Desembarco del León",
        ["frFR"] = "Territoire du Lion",
        ["koKR"] = "사자의 상륙지",
        ["ptBR"] = "Ancoradouro do Leão",
        ["ruRU"] = "Львиный лагерь",
        ["zhCN"] = "雄狮港",
        ["zhTW"] = "雄獅灘",
    },
    ["The Secrets of Ragefire"] = {
        ["enUS"] = true,
        ["deDE"] = "Geheimnisse des Flammenschlunds",
        ["esES"] = "Los Secretos de Sima Ígnea",
        ["esMX"] = "Los Secretos de Sima Ígnea",
        ["frFR"] = "Les secrets de Ragefeu",
        ["koKR"] = "성난불길의 비밀",
        ["ptBR"] = "Os Segredos das Cavernas Ígneas",
        ["ruRU"] = "Секреты Огненной Пропасти",
        ["zhCN"] = "怒焰之谜",
        ["zhTW"] = "怒焰之秘",
    },
    ["Theramore's Fall"] = {
        ["enUS"] = true,
        ["deDE"] = "Theramores Sturz",
        ["esES"] = "Caída de Theramore",
        ["esMX"] = "Caída de Theramore",
        ["frFR"] = "La chute de Theramore",
        ["koKR"] = "테라모어의 몰락",
        ["ptBR"] = "Queda de Theramore",
        ["ruRU"] = "Падение Терамора",
        ["zhCN"] = "塞拉摩的沦陷",
        ["zhTW"] = "塞拉摩攻防戰",
    },
    ["Unga Ingoo"] = {
        ["enUS"] = true,
        ["deDE"] = "Unga Ingu",
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = "Unga Ingou",
        ["koKR"] = "웅가 잉구",
        ["ptBR"] = "Ungá Ingô",
        ["ruRU"] = "Унга-Ингу",
        ["zhCN"] = "盎迦猴岛",
        ["zhTW"] = "仰加印古",
    },
}

for k, v in pairs(dungeonLocales) do
    l10n.translations[k] = v
end
