
local _,addon = ...


addon.professionID = {
    alchemy = {2259, 3101, 3464, 11611, 28596, 51304},
    blacksmithing = {2018, 3100, 3538, 9785, 29844, 51300},
    enchanting = {13920, 7411, 7412, 7413, 28029, 51313},
    engineering = {4036, 4037, 4038, 12656, 30350, 51306},
    herbalism = {2383},
    inscription = {45357, 45358, 45359, 45360, 45361, 45363},
    jewelcrafting = {25229, 25230, 28894, 28895, 28897, 51311},
    leatherworking = {2108, 3104, 3811, 10662, 32549, 51302},
    mining = {2656},
    skinning = {8613, 8617, 8618, 10768, 32678, 50305},
    tailoring = {3908, 3909, 3910, 12180, 26790, 51309},
    cooking = {2550, 3102, 3413, 18260, 33359, 51296},
    firstaid = {3273, 3274, 7924, 10846, 27028, 45542},
    fishing = {7620, 7731, 7732, 18248, 33095, 51294}
}

C_Spell.RequestLoadSpellData(2575) -- mining
C_Spell.RequestLoadSpellData(9134) -- herbalism
C_Spell.RequestLoadSpellData(33388) -- riding

local defaultGuideList = {
    [3455] = "RestedXP Speed Leveling\\a) Exile's Reach",
    [460]  = "RestedXP Speed Leveling\\ab) Shadowglen",
    [425]  = "RestedXP Speed Leveling\\ab) Northshire Valley",
    [30]   = "RestedXP Speed Leveling\\ab) New Tinkertown",
    [468]  = "RestedXP Speed Leveling\\ab) Ammen Vale",
    [202]  = "RestedXP Speed Leveling\\a) Worgen Intro",
    [378]  = "RestedXP Speed Leveling\\b) Pandaren Intro",
    [2373] = "RestedXP Speed Leveling\\a) Dracthyr Intro",
    [971]  = "RestedXP Speed Leveling\\a) VoidElf Intro",
    [940]  = "RestedXP Speed Leveling\\a) LightforgedDraenei Intro",
    [2322] = "RestedXP Speed Leveling\\a) EarthenDwarf Intro",
    [1161] = "RestedXP Speed Leveling\\a) KulTiran Intro",
    [1573] = "RestedXP Speed Leveling\\a) Mechagnome Intro",
    [1186] = "RestedXP Speed Leveling\\a) DarkIronDwarf Intro",
    [124]  = "RestedXP Speed Leveling\\a) DK Intro",
    [1602] = "RestedXP Speed Leveling\\a) New DK Intro",
    [465]  = "RestedXP Speed Leveling\\ab) Deathknell",
    [462]  = "RestedXP Speed Leveling\\ab) Camp Narache",
    [467]  = "RestedXP Speed Leveling\\ab) Sunstrider Isle",
    [194]  = "RestedXP Speed Leveling\\ab) Goblin Intro",
    [680]  = "RestedXP Speed Leveling\\a) Nightborne Intro",
    [4652] = "RestedXP Speed Leveling\\a) HighmountainTauren",
    ["MagharOrc"] = "RestedXP Speed Leveling\\a) MagharOrc Intro",
    [1165] = "RestedXP Speed Leveling\\a) ZandalariTroll Intro",
    ["Vulpera"] = "RestedXP Speed Leveling\\a) Vulpera Intro", -- changed from duplicate 85 (org)
    [672]  = "RestedXP Speed Leveling\\a) DH Intro",
    [627] = "RestedXP Legion Remix\\a) Intro",
}

function addon.GetDefaultGuide()
    local login = addon.tracker.state.login
    local played = difftime(time(),login.time) + login.totalTimePlayed
    if played < 120 then
        local HBD = LibStub("HereBeDragons-2.0")
        local zone = HBD:GetPlayerZone()
        local exilesreach = C_Map.GetAreaInfo(3455)
        local default
        if zone then
            default = defaultGuideList[zone]
        elseif GetSubZoneText() == exilesreach or GetZoneText() == exilesreach then
            default = defaultGuideList[3455]
        end
        return default or defaultGuideList[addon.player.race]
    end
end

function addon.LoadDefaultGuide()
    local defaultGuide = addon.GetDefaultGuide()
    if defaultGuide then
        --print(defaultGuide)
        addon.functions:next(defaultGuide)
    end
end


addon.mapId = {}
for i = 1, 2200 do
	local map = C_Map.GetMapInfo(i)
	if map and not addon.mapId[map.name] then
		addon.mapId[map.name] = i
	end
end

addon.mapId["ScarletEnclave"] = 124
addon.mapId["IcecrownGlacier"] = addon.mapId["Icecrown"]
addon.mapId["CrystalsongForest"] = addon.mapId["Crystalsong Forest"]
addon.mapId["StormPeaks"] = addon.mapId["The Storm Peaks"]
addon.mapId["TheStormPeaks"] = addon.mapId["The Storm Peaks"]
addon.mapId["SholazarBasin"] = addon.mapId["Sholazar Basin"]
addon.mapId["ZulDrak"] = addon.mapId["Zul'Drak"]
addon.mapId["GrizzlyHills"] = addon.mapId["Grizzly Hills"]
addon.mapId["HowlingFjord"] = addon.mapId["Howling Fjord"]
addon.mapId["BoreanTundra"] = addon.mapId["Borean Tundra"]

addon.hearthstoneSpellIds = {
	375357,
	363799,
	136508,
	298068,
	278559,
	94719,
	172179,
	342122,
	326064,
	340200,
	345393,
	285424,
	75136,
	278244,
	231504,
	142543,
	286331,
	367013,
	286353,
	285362,
	391042,
	286031,
	279066,
	366945,
}


addon.mapId["ScarletEnclave"] = 124
addon.mapId["IcecrownGlacier"] = addon.mapId["Icecrown"]
addon.mapId["CrystalsongForest"] = addon.mapId["Crystalsong Forest"]
addon.mapId["StormPeaks"] = addon.mapId["The Storm Peaks"]
addon.mapId["TheStormPeaks"] = addon.mapId["The Storm Peaks"]
addon.mapId["SholazarBasin"] = addon.mapId["Sholazar Basin"]
addon.mapId["ZulDrak"] = addon.mapId["Zul'Drak"]
addon.mapId["GrizzlyHills"] = addon.mapId["Grizzly Hills"]
addon.mapId["HowlingFjord"] = addon.mapId["Howling Fjord"]
addon.mapId["BoreanTundra"] = addon.mapId["Borean Tundra"]


addon.professionID = {
    alchemy = {105206,80731,11611,28596,3464,2259,51304,3101},
    blacksmithing = {3538,51300,2018,110396,3100,76666,29844,9785},
    enchanting = {110400,74258,28029,7411,51313,13920,7412,7413},
    engineering = {4037,49383,30350,4036,82774,51306,12656},
    herbalism = {2383},
    inscription = {45357, 45358, 45359, 45360, 45361, 45363},
    jewelcrafting = {25229, 25230, 28894, 28895, 28897, 51311},
    leatherworking = {2108, 3104, 3811, 10662, 32549, 51302},
    mining = {2656},
    skinning = {8613, 8617, 8618, 10768, 32678, 50305},
    tailoring = {3908, 3909, 3910, 12180, 26790, 51309},
    cooking = {2550, 3102, 3413, 18260, 33359, 51296},
    firstaid = {3273, 3274, 7924, 10846, 27028, 45542},
    fishing = {7620, 7731, 7732, 18248, 33095, 51294}
}

C_Spell.RequestLoadSpellData(2575) -- mining
C_Spell.RequestLoadSpellData(9134) -- herbalism
C_Spell.RequestLoadSpellData(33388) -- riding

-------------------------------
addon.taxiPos = {
  [0] = {
    [2] = {wx = -8841.05957, wy = 489.65601, flag = 1, name = "Stormwind, Elwynn"},
    [4] = {wx = -10551.90039, wy = 1034.39001, flag = 1, name = "Sentinel Hill, Westfall"},
    [5] = {wx = -9429.09961, wy = -2231.39990, flag = 1, name = "Lakeshire, Redridge"},
    [6] = {wx = -4821.77979, wy = -1155.43994, flag = 1, name = "Ironforge, Dun Morogh"},
    [7] = {wx = -3787.81006, wy = -777.69598, flag = 1, name = "Menethil Harbor, Wetlands"},
    [8] = {wx = -5421.91016, wy = -2930.01001, flag = 1, name = "Thelsamar, Loch Modan"},
    [10] = {wx = 478.85999, wy = 1536.58997, flag = 2, name = "The Sepulcher, Silverpine Forest"},
    [11] = {wx = 1568.62000, wy = 267.97000, flag = 10, name = "Undercity, Tirisfal"},
    [12] = {wx = -10515.50000, wy = -1261.65002, flag = 1, name = "Darkshire, Duskwood"},
    [13] = {wx = -17.70660, wy = -874.20300, flag = 2, name = "Tarren Mill, Hillsbrad"},
    [16] = {wx = -1240.53003, wy = -2515.11011, flag = 1, name = "Refuge Pointe, Arathi"},
    [17] = {wx = -916.28998, wy = -3496.88989, flag = 2, name = "Hammerfall, Arathi"},
    [18] = {wx = -14444.29980, wy = 509.62000, flag = 2, name = "Booty Bay, Stranglethorn"},
    [19] = {wx = -14473.00000, wy = 464.14999, flag = 1, name = "Booty Bay, Stranglethorn"},
    [20] = {wx = -12414.20020, wy = 146.28999, flag = 2, name = "Grom'gol, Stranglethorn"},
    [21] = {wx = -6676.87012, wy = -2433.37012, flag = 2, name = "New Kargath, Badlands"},
    [43] = {wx = 283.73999, wy = -2002.76001, flag = 1, name = "Aerie Peak, The Hinterlands"},
    [45] = {wx = -11112.29980, wy = -3435.73999, flag = 9, name = "Nethergarde Keep, Blasted Lands"},
    [56] = {wx = -10457.00000, wy = -3279.25000, flag = 2, name = "Stonard, Swamp of Sorrows"},
    [383] = {wx = 1935.96997, wy = -2694.47998, flag = 3, name = "Thondroril River, Eastern Plaguelands"},
    [521] = {wx = -4588.04980, wy = 3481.12012, flag = 3, name = "Smuggler's Scar, Vashj'ir"},
    [523] = {wx = -6616.39990, wy = 4308.27979, flag = 1, name = "Tranquil Wash, Vashj'ir"},
    [524] = {wx = -6902.25000, wy = 5943.81982, flag = 1, name = "Darkbreak Cove, Vashj'ir"},
    [526] = {wx = -6507.99023, wy = 6075.25000, flag = 2, name = "Tenebrous Cavern, Vashj'ir"},
    [70] = {wx = -7504.02979, wy = -2187.54004, flag = 2, name = "Flame Crest, Burning Steppes"},
    [460] = {wx = 2272.67993, wy = 372.06400, flag = 10, name = "Brill, Tirisfal Glades"},
    [610] = {wx = -6878.52002, wy = 4244.70996, flag = 2, name = "Stygian Bounty, Vashj'ir"},
    [195] = {wx = -11344.00000, wy = -216.83000, flag = 5, name = "Rebel Camp, Stranglethorn Vale"},
    [71] = {wx = -8364.61035, wy = -2738.35010, flag = 1, name = "Morgan's Vigil, Burning Steppes"},
    [673] = {wx = -7123.06006, wy = -1236.63000, flag = 3, name = "Iron Summit, Searing Gorge"},
    [554] = {wx = -4113.60010, wy = -2741.20996, flag = 1, name = "Slabchisel's Survey, Wetlands"},
    [551] = {wx = -3222.92993, wy = -1989.48999, flag = 1, name = "Whelgar's Retreat, Wetlands"},
    [552] = {wx = -3306.64990, wy = -2718.68994, flag = 1, name = "Greenwarden's Grove, Wetlands"},
    [555] = {wx = -5668.31006, wy = -4253.43994, flag = 1, name = "Farstrider Lodge, Loch Modan"},
    [598] = {wx = -10176.59961, wy = -3836.54004, flag = 1, name = "Marshtide Watch, Swamp of Sorrows"},
    [669] = {wx = -566.88898, wy = -1051.19995, flag = 2, name = "Eastpoint Tower, Hillsbrad"},
    [600] = {wx = -10118.59961, wy = -2852.47998, flag = 5, name = "The Harborage, Swamp of Sorrows"},
    [667] = {wx = -661.83698, wy = -536.49298, flag = 2, name = "Ruins of Southshore, Hillsbrad"},
    [589] = {wx = -9475.70996, wy = -1306.73999, flag = 1, name = "Eastvale Logging Camp, Elwynn"},
    [665] = {wx = -3146.91992, wy = -4994.27979, flag = 1, name = "Thundermar, Twilight Highlands"},
    [66] = {wx = 931.32001, wy = -1430.10999, flag = 1, name = "Chillwind Camp, Western Plaguelands"},
    [68] = {wx = 2270.19995, wy = -5343.10986, flag = 2, name = "Light's Hope Chapel, Eastern Plaguelands"},
    [663] = {wx = -4170.54980, wy = -4748.93018, flag = 1, name = "Victor's Point, Twilight Highlands"},
    [590] = {wx = -12828.79980, wy = -413.70999, flag = 1, name = "Fort Livingston, Stranglethorn"},
    [67] = {wx = 2271.09009, wy = -5340.79980, flag = 1, name = "Light's Hope Chapel, Eastern Plaguelands"},
    [661] = {wx = -4012.44995, wy = -6329.25000, flag = 2, name = "Dragonmaw Port, Twilight Highlands"},
    [660] = {wx = -2780.17993, wy = -6409.27979, flag = 2, name = "The Krazzworks, Twilight Highlands"},
    [659] = {wx = -3637.56006, wy = -5288.18994, flag = 2, name = "Bloodgulch, Twilight Highlands"},
    [525] = {wx = -6805.62988, wy = 4199.85010, flag = 2, name = "Legion's Rest, Vashj'ir"},
    [657] = {wx = -3494.62988, wy = -4379.47998, flag = 2, name = "The Gullet, Twilight Highlands"},
    [592] = {wx = -13288.29980, wy = 722.02802, flag = 2, name = "Hardwrench Hideaway, Stranglethorn"},
    [602] = {wx = -12761.90039, wy = -2919.04004, flag = 9, name = "Surwich, Blasted Lands"},
    [651] = {wx = 1864.31995, wy = -1755.81995, flag = 3, name = "The Menders' Stead, Western Plaguelands"},
    [681] = {wx = 1056.06006, wy = 1518.90002, flag = 2, name = "Forsaken Rear Guard, Silverpine Forest"},
    [84] = {wx = 2965.55005, wy = -3033.61011, flag = 3, name = "Plaguewood Tower, Eastern Plaguelands"},
    [676] = {wx = -7865.93018, wy = -1919.53003, flag = 3, name = "Chiselgrip, Burning Steppes"},
    [582] = {wx = -9433.99023, wy = 85.14930, flag = 1, name = "Goldshire, Elwynn"},
    [672] = {wx = 2839.78003, wy = -1500.51001, flag = 3, name = "Hearthglen, Western Plaguelands"},
    [675] = {wx = -8092.25977, wy = -1025.79004, flag = 3, name = "Flamestar Post, Burning Steppes"},
    [668] = {wx = -605.18402, wy = 435.46500, flag = 2, name = "Southpoint Gate, Hillsbrad"},
    [670] = {wx = 622.85101, wy = -979.57800, flag = 2, name = "Strahnbrad, Alterac Mountains"},
    [664] = {wx = -4183.89990, wy = -5620.14990, flag = 1, name = "Firebeard's Patrol, Twilight Highlands"},
    [666] = {wx = -2689.42993, wy = -5427.52979, flag = 1, name = "Kirthaven, Twilight Highlands"},
    [76] = {wx = -635.26001, wy = -4720.50000, flag = 2, name = "Revantusk Village, The Hinterlands"},
    [662] = {wx = -4863.10010, wy = -6740.60986, flag = 1, name = "Highbank, Twilight Highlands"},
    [656] = {wx = -4831.75977, wy = -4848.93018, flag = 2, name = "Crushblow, Twilight Highlands"},
    [658] = {wx = -3032.76001, wy = -3940.96997, flag = 3, name = "Vermillion Redoubt, Twilight Highlands"},
    [553] = {wx = -2656.54004, wy = -2464.28003, flag = 1, name = "Dun Modr, Wetlands"},
    [654] = {wx = -114.14200, wy = 1312.31995, flag = 2, name = "The Forsaken Front, Silverpine Forest"},
    [649] = {wx = 1511.80005, wy = -1586.94995, flag = 2, name = "Andorhal, Western Plaguelands"},
    [650] = {wx = 1374.22998, wy = -1281.93994, flag = 1, name = "Andorhal, Western Plaguelands"},
    [645] = {wx = 1421.02002, wy = 1018.22998, flag = 2, name = "Forsaken High Command, Silverpine Forest"},
    [85] = {wx = 3134.26001, wy = -4354.77979, flag = 3, name = "Northpass Tower, Eastern Plaguelands"},
    [74] = {wx = -6552.58984, wy = -1168.27002, flag = 1, name = "Thorium Point, Searing Gorge"},
    [618] = {wx = 312.32599, wy = -4105.35986, flag = 1, name = "Stormfeather Outpost, The Hinterlands"},
    [315] = {wx = 2352.37012, wy = -5666.91016, flag = 3, name = "Acherus: The Ebon Hold"},
    [632] = {wx = -6898.25000, wy = -3513.98999, flag = 2, name = "Bloodwatcher Point, Badlands"},
    [635] = {wx = -6574.93994, wy = -3875.12988, flag = 3, name = "Fuselight, Badlands"},
    [633] = {wx = -6594.08984, wy = -3401.17993, flag = 1, name = "Dustwind Dig, Badlands"},
    [630] = {wx = 2262.10010, wy = -4411.52002, flag = 3, name = "Light's Shield Tower, Eastern Plaguelands"},
    [522] = {wx = -6105.60986, wy = 4285.08008, flag = 3, name = "Silver Tide Hollow, Vashj'ir"},
    [384] = {wx = 1726.62000, wy = -740.98102, flag = 2, name = "The Bulwark, Tirisfal"},
    [75] = {wx = -6554.93018, wy = -1100.05005, flag = 2, name = "Thorium Point, Searing Gorge"},
    [622] = {wx = -10737.59961, wy = 267.04300, flag = 1, name = "Raven Hill, Duskwood"},
    [620] = {wx = -5714.14014, wy = -1578.64001, flag = 1, name = "Gol'Bolar Quarry, Dun Morogh"},
    [619] = {wx = -5660.79980, wy = -494.85101, flag = 1, name = "Kharanos, Dun Morogh"},
    [617] = {wx = -25.77600, wy = -2821.78003, flag = 2, name = "Hiri'watha Research Station, The Hinterlands"},
    [615] = {wx = -9446.63965, wy = -2836.98999, flag = 1, name = "Camp Everstill, Redridge"},
    [612] = {wx = -6880.16992, wy = 4278.06006, flag = 2, name = "Stygian Bounty, Vashj'ir"},
    [611] = {wx = -7198.97021, wy = 3912.36011, flag = 1, name = "Voldrin's Hold, Vashj'ir"},
    [609] = {wx = -5669.18994, wy = 3711.81006, flag = 2, name = "Sandy Beach, Vashj'ir"},
    [607] = {wx = -5267.35010, wy = 3900.27002, flag = 1, name = "Sandy Beach, Vashj'ir"},
    [605] = {wx = -7209.70996, wy = 3925.85010, flag = 1, name = "Voldrin's Hold, Vashj'ir"},
    [603] = {wx = -12357.59961, wy = -3058.22998, flag = 10, name = "Sunveil Excursion, Blasted Lands"},
    [601] = {wx = -952.37701, wy = -1585.73999, flag = 14, name = "Galen's Fall, Arathi"},
    [599] = {wx = -9737.08008, wy = -3890.71997, flag = 3, name = "Bogpaddle, Swamp of Sorrows"},
    [87] = {wx = 1876.40002, wy = -3693.32007, flag = 3, name = "Crown Guard Tower, Eastern Plaguelands"},
    [634] = {wx = -7034.52979, wy = -2570.79004, flag = 1, name = "Dragon's Mouth, Badlands"},
    [593] = {wx = -12092.20020, wy = -814.09900, flag = 2, name = "Bambala, Stranglethorn"},
    [591] = {wx = -13600.90039, wy = -85.54860, flag = 1, name = "Explorers' League Digsite, Stranglethorn"},
    [86] = {wx = 2524.43994, wy = -4769.56006, flag = 3, name = "Eastwall Tower, Eastern Plaguelands"},
    [596] = {wx = -9641.66992, wy = -3479.37012, flag = 1, name = "Shalewind Canyon, Redridge"},
    [584] = {wx = -9838.50977, wy = 1273.93005, flag = 1, name = "Furlbrow's Pumpkin Farm, Westfall"},
    [583] = {wx = -10876.90039, wy = 1542.88000, flag = 1, name = "Moonbrook, Westfall"},
    [604] = {wx = -10933.29980, wy = -2790.97998, flag = 14, name = "Dreadmaul Hold, Blasted Lands"},
    [606] = {wx = -5310.85010, wy = 3914.41992, flag = 1, name = "Sandy Beach, Vashj'ir"},
    [608] = {wx = -5671.02002, wy = 3720.07007, flag = 2, name = "Sandy Beach, Vashj'ir"},
  },
  [1] = {
    [22] = {wx = -1197.20996, wy = 29.71000, flag = 2, name = "Thunder Bluff, Mulgore"},
    [23] = {wx = 1798.27002, wy = -4363.27002, flag = 2, name = "Orgrimmar, Durotar"},
    [25] = {wx = -441.79999, wy = -2596.08008, flag = 2, name = "The Crossroads, Northern Barrens"},
    [26] = {wx = 7459.89990, wy = -326.56000, flag = 9, name = "Lor'danel, Darkshore"},
    [27] = {wx = 8383.75000, wy = 980.96399, flag = 9, name = "Rut'theran Village, Teldrassil"},
    [28] = {wx = 2827.34009, wy = -289.23999, flag = 1, name = "Astranaar, Ashenvale"},
    [29] = {wx = 966.57001, wy = 1040.31995, flag = 2, name = "Sun Rock Retreat, Stonetalon Mountains"},
    [30] = {wx = -4310.60986, wy = -927.06403, flag = 2, name = "Westreach Summit, Thousand Needles"},
    [31] = {wx = -4996.87988, wy = 73.94270, flag = 1, name = "Shadebough, Feralas"},
    [32] = {wx = -3825.37012, wy = -4516.58008, flag = 9, name = "Theramore, Dustwallow Marsh"},
    [33] = {wx = 2147.25000, wy = 1537.87000, flag = 1, name = "Thal'darah Overlook, Stonetalon Mountains"},
    [37] = {wx = 139.24001, wy = 1325.81995, flag = 1, name = "Nijel's Point, Desolace"},
    [38] = {wx = -1767.64001, wy = 3263.88989, flag = 2, name = "Shadowprey Village, Desolace"},
    [39] = {wx = -7185.97021, wy = -3768.23999, flag = 1, name = "Gadgetzan, Tanaris"},
    [40] = {wx = -7094.02979, wy = -3813.68994, flag = 2, name = "Gadgetzan, Tanaris"},
    [41] = {wx = -4467.04004, wy = 2188.63989, flag = 1, name = "Feathermoon, Feralas"},
    [42] = {wx = -4419.85986, wy = 199.31000, flag = 2, name = "Camp Mojache, Feralas"},
    [44] = {wx = 3547.19995, wy = -6294.66016, flag = 2, name = "Bilgewater Harbor, Azshara"},
    [49] = {wx = 7458.45020, wy = -2487.20996, flag = 1, name = "Moonglade"},
    [52] = {wx = 6796.79980, wy = -4742.39014, flag = 1, name = "Everlook, Winterspring"},
    [53] = {wx = 6813.06006, wy = -4611.12012, flag = 2, name = "Everlook, Winterspring"},
    [55] = {wx = -3147.38989, wy = -2842.17993, flag = 2, name = "Brackenwall Village, Dustwallow Marsh"},
    [58] = {wx = 3351.82007, wy = 1052.30005, flag = 2, name = "Zoram'gar Outpost, Ashenvale"},
    [61] = {wx = 2302.38989, wy = -2524.55005, flag = 2, name = "Splintertree Post, Ashenvale"},
    [781] = {wx = 4397.79004, wy = -2107.53003, flag = 3, name = "Sanctuary of Malorne, Hyjal"},
    [80] = {wx = -894.59003, wy = -3773.01001, flag = 3, name = "Ratchet, Northern Barrens"},
    [683] = {wx = 2988.12988, wy = -4161.35986, flag = 6, name = "Valormok, Azshara"},
    [356] = {wx = 2159.62012, wy = -1144.05005, flag = 2, name = "Silverwind Refuge, Ashenvale"},
    [674] = {wx = -10711.90039, wy = 1059.62000, flag = 3, name = "Schnottz's Landing, Uldum"},
    [653] = {wx = -8375.46973, wy = 791.25897, flag = 3, name = "Oasis of Vir'sar, Uldum"},
    [652] = {wx = -9415.01953, wy = -1042.96997, flag = 3, name = "Ramkahen, Uldum"},
    [65] = {wx = 6214.31982, wy = -1874.28003, flag = 1, name = "Talonbranch Glade, Felwood"},
    [616] = {wx = 4059.39990, wy = -3966.75000, flag = 3, name = "Gates of Sothann, Hyjal"},
    [354] = {wx = 1206.05005, wy = -2209.14990, flag = 2, name = "The Mor'Shan Ramparts, Ashenvale"},
    [365] = {wx = 973.94000, wy = 2013.13000, flag = 1, name = "Farwatcher's Glen, Stonetalon Mountains"},
    [364] = {wx = 237.88000, wy = -281.35001, flag = 1, name = "Northwatch Expedition Base Camp, Stonetalon Mountains"},
    [367] = {wx = -1694.53003, wy = 2577.57007, flag = 1, name = "Thargad's Camp, Desolace"},
    [366] = {wx = -439.14999, wy = 2242.62012, flag = 2, name = "Furien's Post, Desolace"},
    [77] = {wx = -2152.35010, wy = -1724.33997, flag = 2, name = "Vendetta Point, Southern Barrens"},
    [360] = {wx = 2188.00000, wy = 1241.89001, flag = 2, name = "Cliffwalker Post, Stonetalon Mountains"},
    [363] = {wx = -111.94000, wy = -260.41000, flag = 2, name = "Malaka'jin, Stonetalon Mountains"},
    [179] = {wx = -4566.22998, wy = -3226.05005, flag = 3, name = "Mudsprocket, Dustwallow Marsh"},
    [614] = {wx = 4611.37988, wy = -7041.79980, flag = 2, name = "Northern Rocketway, Azshara"},
    [613] = {wx = 2647.79004, wy = -6214.39990, flag = 2, name = "Southern Rocketway, Azshara"},
    [402] = {wx = -2299.54004, wy = -379.06900, flag = 2, name = "Bloodhoof Village, Mulgore"},
    [595] = {wx = 4734.16016, wy = -883.80603, flag = 3, name = "Wildheart Point, Felwood"},
    [369] = {wx = -534.03998, wy = 1056.68005, flag = 3, name = "Thunk's Abode, Desolace"},
    [368] = {wx = -1038.43005, wy = 1637.98999, flag = 3, name = "Karnum's Glade, Desolace"},
    [594] = {wx = 6078.50977, wy = -844.99799, flag = 3, name = "Whisperwind Grove, Felwood"},
    [370] = {wx = -356.47000, wy = 2478.89990, flag = 3, name = "Ethel Rethor, Desolace"},
    [569] = {wx = -4606.52002, wy = 1898.18994, flag = 2, name = "Stonemaul Hold, Feralas"},
    [568] = {wx = -3081.69995, wy = 2560.10010, flag = 2, name = "Camp Ataya, Feralas"},
    [567] = {wx = -4863.64014, wy = 1478.16003, flag = 1, name = "Tower of Estulan, Feralas"},
    [362] = {wx = 932.12000, wy = -21.25000, flag = 2, name = "Krom'gar Fortress, Stonetalon Mountains"},
    [73] = {wx = -6761.83008, wy = 772.03003, flag = 9, name = "Cenarion Hold, Silithus"},
    [559] = {wx = 5584.06006, wy = -3569.84009, flag = 3, name = "Nordrassil, Hyjal"},
    [513] = {wx = -6075.37012, wy = -3913.43994, flag = 3, name = "Fizzle & Pozzik's Speedbarge, Thousand Needles"},
    [388] = {wx = -2124.20996, wy = -3561.79004, flag = 1, name = "Northwatch Hold, Southern Barrens"},
    [389] = {wx = -3150.25000, wy = -2286.27002, flag = 1, name = "Fort Triumph, Southern Barrens"},
    [390] = {wx = -798.71997, wy = -1590.87000, flag = 2, name = "Hunter's Hill, Southern Barrens"},
    [391] = {wx = -3288.85010, wy = -1697.98999, flag = 2, name = "Desolation Hold, Southern Barrens"},
    [558] = {wx = 5163.50977, wy = -1760.57996, flag = 3, name = "Grove of Aessina, Hyjal"},
    [167] = {wx = 3000.25000, wy = -3202.40991, flag = 1, name = "Forest Song, Ashenvale"},
    [386] = {wx = -6958.43994, wy = -1095.23999, flag = 3, name = "Mossy Pile, Un'Goro Crater"},
    [387] = {wx = -335.20001, wy = -1532.43994, flag = 1, name = "Honor's Stand, Southern Barrens"},
    [532] = {wx = -9493.70996, wy = -2953.98999, flag = 1, name = "Gunstan's Dig, Tanaris"},
    [456] = {wx = 9873.09961, wy = 977.69800, flag = 9, name = "Dolanaar, Teldrassil"},
    [457] = {wx = 9968.79980, wy = 2622.09009, flag = 9, name = "Darnassus, Teldrassil"},
    [539] = {wx = -8683.08984, wy = -4088.10010, flag = 3, name = "Bootlegger Outpost, Tanaris"},
    [540] = {wx = 1825.93994, wy = 727.20801, flag = 2, name = "The Sludgewerks, Stonetalon Mountains"},
    [79] = {wx = -7548.04980, wy = -1541.13000, flag = 3, name = "Marshal's Stand, Un'Goro Crater"},
    [541] = {wx = 1379.42004, wy = 1034.85999, flag = 1, name = "Mirkfallon Post, Stonetalon Mountains"},
    [537] = {wx = 269.91699, wy = -4766.75977, flag = 2, name = "Razor Hill, Durotar"},
    [536] = {wx = -780.26703, wy = -4890.27979, flag = 2, name = "Sen'jin Village, Durotar"},
    [531] = {wx = -9487.88965, wy = -2467.12988, flag = 2, name = "Dawnrise Expedition, Tanaris"},
    [458] = {wx = 1152.59998, wy = -3381.73999, flag = 2, name = "Nozzlepot's Outpost, Northern Barrens"},
    [597] = {wx = 6892.68994, wy = -1620.41003, flag = 2, name = "Irontree Clearing, Felwood"},
    [557] = {wx = 4987.87012, wy = -2676.18994, flag = 3, name = "Shrine of Aviana, Hyjal"},
    [338] = {wx = 3880.51001, wy = 654.15997, flag = 1, name = "Blackfathom Camp, Ashenvale"},
    [339] = {wx = 4970.50000, wy = 147.64999, flag = 9, name = "Grove of the Ancients, Darkshore"},
    [69] = {wx = 7470.39014, wy = -2123.37988, flag = 2, name = "Moonglade"},
    [565] = {wx = -3136.62012, wy = 1951.67004, flag = 1, name = "Dreamer's Rest, Feralas"},
    [350] = {wx = 3049.08008, wy = -498.95001, flag = 2, name = "Hellscream's Watch, Ashenvale"},
    [351] = {wx = 1905.10999, wy = -321.98999, flag = 1, name = "Stardust Spire, Ashenvale"},
    [361] = {wx = 1268.51001, wy = 432.87000, flag = 1, name = "Windshear Hold, Stonetalon Mountains"},
    [166] = {wx = 3972.84009, wy = -1324.51001, flag = 3, name = "Emerald Sanctuary, Felwood"},
    [72] = {wx = -6811.39014, wy = 836.73999, flag = 10, name = "Cenarion Hold, Silithus"},
  },
  [1220] = {
    [1879] = {wx = 1893.30005, wy = 3092.55005, flag = 3, name = "Crimson Thicket, Suramar"},
    [1613] = {wx = 576.40503, wy = 6644.02979, flag = 3, name = "Azurewing Repose, Azsuna"},
    [1633] = {wx = -784.17401, wy = 6130.04004, flag = 3, name = "Shackle's Den, Azsuna"},
    [1942] = {wx = -1225.51001, wy = 2195.22998, flag = 3, name = "Aalgen Point, Broken Shore"},
    [1841] = {wx = 379.92899, wy = 4364.24023, flag = 75, name = "Western Suramar"},
    [1778] = {wx = 3891.94995, wy = 3500.17993, flag = 3, name = "Stonehoof Watch, Highmountain"},
    [1815] = {wx = 4074.32007, wy = 7225.45020, flag = 11, name = "The Dreamgrove, Val'sharah (Druids Only)"},
    [1767] = {wx = 4483.45996, wy = 4843.29004, flag = 3, name = "Nesingwary, Highmountain"},
    [1839] = {wx = 3793.25000, wy = 2368.84009, flag = 75, name = "Nastrondir"},
    [1759] = {wx = 3005.71997, wy = 3668.46997, flag = 3, name = "Ironhorn Enclave, Highmountain"},
    [1863] = {wx = 1797.34998, wy = 1816.69995, flag = 3, name = "Hafr Fjall, Stormheim"},
    [1848] = {wx = 4632.02979, wy = 5320.95996, flag = 75, name = "Trueshot Lodge"},
    [1855] = {wx = 4764.52002, wy = -186.99699, flag = 3, name = "Shield's Rest, Stormheim"},
    [1840] = {wx = 815.49103, wy = 2760.97998, flag = 75, name = "Eastern Suramar"},
    [1845] = {wx = -1704.43994, wy = 6472.99023, flag = 75, name = "Isle of the Watchers"},
    [1862] = {wx = -1437.43005, wy = 1162.23999, flag = 3, name = "Acherus: The Ebon Hold"},
    [1741] = {wx = 3987.54004, wy = 2914.29004, flag = 2, name = "Forsaken Foothold, Stormheim"},
    [1739] = {wx = 2355.71997, wy = 1870.08997, flag = 2, name = "Dreadwake's Landing, Stormheim"},
    [1861] = {wx = -228.43800, wy = 7733.70020, flag = 3, name = "Illidari Perch, Azsuna"},
    [1766] = {wx = 2841.79004, wy = 6482.29004, flag = 3, name = "Garden of the Moon, Val'sharah"},
    [1758] = {wx = 2971.68994, wy = 4343.45996, flag = 3, name = "Obsidian Overlook, Highmountain"},
    [1755] = {wx = 5108.33008, wy = 5570.60986, flag = 3, name = "Felbane Camp, Highmountain"},
    [1859] = {wx = 554.04199, wy = 5628.87988, flag = 3, name = "Felblaze Ingress, Azsuna"},
    [1747] = {wx = 3217.60010, wy = 3079.91992, flag = 1, name = "Skyfire Triage Camp, Stormheim"},
    [1774] = {wx = -860.82800, wy = 4295.95020, flag = 19, name = "Dalaran"},
    [1858] = {wx = 1615.52002, wy = 4757.85986, flag = 3, name = "Meredil, Suramar"},
    [1764] = {wx = 3094.06006, wy = 5807.20996, flag = 3, name = "Starsong Refuge, Val'sharah"},
    [1760] = {wx = 4634.29004, wy = 5339.41992, flag = 11, name = "Trueshot Lodge, Highmountain"},
    [1857] = {wx = 3835.61011, wy = 2016.12000, flag = 3, name = "Stormtorn Foothills, Stormheim"},
    [1856] = {wx = -545.19098, wy = 3001.78003, flag = 3, name = "Vengeance Point, Broken Shore"},
    [1850] = {wx = 3769.17993, wy = 3682.89990, flag = 75, name = "Eastern Highmountain"},
    [1777] = {wx = 3853.55005, wy = 5150.58984, flag = 3, name = "Sylvan Falls, Highmountain"},
    [1847] = {wx = 4411.14990, wy = 7164.20996, flag = 75, name = "The Dreamgrove"},
    [1673] = {wx = 2299.87988, wy = 6577.66016, flag = 3, name = "Lorlathil, Val'sharah"},
    [1846] = {wx = -88.43230, wy = 8214.32031, flag = 75, name = "Faronaar"},
    [1941] = {wx = -1647.68005, wy = 3178.63989, flag = 3, name = "Deliverance Point, Broken Shore"},
    [1754] = {wx = 5116.10986, wy = 4982.16016, flag = 3, name = "The Witchwood, Highmountain"},
    [1756] = {wx = 6466.83984, wy = 4727.99023, flag = 7, name = "Shipwreck Cove, Highmountain"},
    [1745] = {wx = 2704.48999, wy = 2860.22998, flag = 1, name = "Lorna's Watch, Stormheim"},
    [1744] = {wx = 2863.92993, wy = 849.17499, flag = 1, name = "Greywatch, Stormheim"},
    [1761] = {wx = 5613.39990, wy = 3585.03003, flag = 3, name = "Prepfoot, Highmountain"},
    [1742] = {wx = 3205.59009, wy = 1515.57996, flag = 3, name = "Valdisdall, Stormheim"},
    [1837] = {wx = -1403.63000, wy = 6656.85986, flag = 3, name = "Wardens' Redoubt, Azsuna"},
    [1753] = {wx = 4833.93018, wy = 3967.37012, flag = 3, name = "Skyhorn, Highmountain"},
    [1738] = {wx = 2885.64990, wy = 2422.61011, flag = 2, name = "Cullen's Post, Stormheim"},
    [1615] = {wx = 1406.07996, wy = 7140.70020, flag = 3, name = "Challiane's Terrace, Azsuna"},
    [1719] = {wx = 4156.50977, wy = 4374.45020, flag = 3, name = "Thunder Totem, Highmountain"},
    [1713] = {wx = 2814.29004, wy = 7275.81982, flag = 3, name = "Bradensbrook, Val'sharah"},
    [1870] = {wx = -3362.32007, wy = 4823.00977, flag = 3, name = "Eye of Azshara, Azsuna"},
    [1622] = {wx = -117.83500, wy = 6891.18994, flag = 3, name = "Illidari Stand, Azsuna"},
    [1860] = {wx = -1804.71997, wy = 6417.62988, flag = 3, name = "Watchers' Aerie, Azsuna"},
    [1880] = {wx = 2268.80005, wy = 5241.58984, flag = 3, name = "Irongrove Retreat, Suramar"},
    [1885] = {wx = 2523.93994, wy = 8174.85986, flag = 3, name = "Gloaming Reef, Val'sharah"},
    [1838] = {wx = 2113.39990, wy = 2823.45996, flag = 75, name = "Thorim's Peak"},
  },
  [870] = {
    [1090] = {wx = -570.40503, wy = 3859.79004, flag = 3, name = "The Briny Muck, Dread Wastes"},
    [1115] = {wx = 234.40601, wy = 2198.03003, flag = 1, name = "The Lion's Redoubt, Dread Wastes"},
    [1117] = {wx = 2123.14990, wy = 2584.92993, flag = 2, name = "Serpent's Spine, Kun-Lai Summit"},
    [1056] = {wx = 1803.31995, wy = 4204.22998, flag = 3, name = "Shado-Pan Garrison, Townlong Steppes"},
    [1070] = {wx = 172.66299, wy = 3152.25000, flag = 3, name = "Klaxxi'vess, Dread Wastes"},
    [1072] = {wx = 982.67700, wy = 3451.86011, flag = 3, name = "The Sunset Brewgarden, Dread Wastes"},
    [1080] = {wx = 465.85599, wy = -1558.56006, flag = 3, name = "Serpent's Overlook, Jade Forest"},
    [1294] = {wx = -404.95001, wy = -4608.56006, flag = 2, name = "Huojin Landing, Timeless Isle"},
    [1029] = {wx = 784.89899, wy = -203.67000, flag = 3, name = "Tavern in the Mists, The Veiled Stair"},
    [1293] = {wx = -901.37000, wy = -4639.12012, flag = 1, name = "Tushui Landing, Timeless Isle"},
    [1222] = {wx = 5799.64014, wy = 1080.56995, flag = 2, name = "Bozzle's Wreck, Isle Of Giants"},
    [1221] = {wx = 5753.75977, wy = 1255.55005, flag = 1, name = "Beeble's Wreck, Isle Of Giants"},
    [1195] = {wx = -1752.18994, wy = 2492.02002, flag = 2, name = "Domination Point, Krasarang Wilds"},
    [1190] = {wx = -1193.56006, wy = -1193.69995, flag = 1, name = "Lion's Landing, Krasarang Wilds"},
    [1053] = {wx = 2363.22998, wy = 2994.38989, flag = 3, name = "Longying Outpost, Townlong Steppes"},
    [1073] = {wx = 611.36499, wy = 2125.03003, flag = 3, name = "Serpent's Spine, Vale of Eternal Blossoms"},
    [1071] = {wx = -1086.20996, wy = 3136.18994, flag = 3, name = "Soggy's Gamble, Dread Wastes"},
    [1058] = {wx = 1580.16003, wy = 894.16699, flag = 2, name = "Shrine of Two Moons, Vale of Eternal Blossoms"},
    [1057] = {wx = 896.45300, wy = 334.35101, flag = 1, name = "Shrine of Seven Stars, Vale of Eternal Blossoms"},
    [1055] = {wx = 1531.72998, wy = 3963.69995, flag = 3, name = "Rensai's Watchpost, Townlong Steppes"},
    [1018] = {wx = 3504.04004, wy = 690.67700, flag = 3, name = "Temple of the White Tiger, Kun-Lai Summit"},
    [895] = {wx = 1503.70996, wy = -1832.13000, flag = 3, name = "Dawn's Blossom, Jade Forest"},
    [1022] = {wx = 3124.52002, wy = 1224.28003, flag = 3, name = "One Keg, Kun-Lai Summit"},
    [1020] = {wx = 2103.35010, wy = 1463.82996, flag = 1, name = "Westwind Rest, Kun-Lai Summit"},
    [1054] = {wx = 1440.71997, wy = 2804.48999, flag = 3, name = "Gao-Ran Battlefront, Townlong Steppes"},
    [992] = {wx = -2082.30005, wy = 1483.63000, flag = 3, name = "Cradle of Chi-Ji, Krasarang Wilds"},
    [987] = {wx = -878.27600, wy = 171.40300, flag = 6, name = "Thunder Cleft, Krasarang Wilds"},
    [988] = {wx = -1125.31006, wy = -227.74699, flag = 1, name = "The Incursion, Krasarang Wilds"},
    [984] = {wx = 543.91498, wy = -637.81403, flag = 7, name = "Pang's Stead, Valley of the Four Winds"},
    [973] = {wx = 2927.15991, wy = -509.18399, flag = 2, name = "Honeydew Village, Jade Forest"},
    [1052] = {wx = 460.54001, wy = -100.46700, flag = 3, name = "Grassy Cline, Valley of the Four Winds"},
    [969] = {wx = 2550.76001, wy = -2418.32007, flag = 3, name = "Sri-La Village, Jade Forest"},
    [971] = {wx = 2505.89990, wy = -1590.89001, flag = 3, name = "Tian Monastery, Jade Forest"},
    [1019] = {wx = 2250.59009, wy = 931.56897, flag = 2, name = "Eastwind Rest, Kun-Lai Summit"},
    [966] = {wx = -307.20001, wy = -1762.77002, flag = 1, name = "Paw'Don Village, Jade Forest"},
    [894] = {wx = 1418.56995, wy = -487.70300, flag = 6, name = "Grookin Hill, Jade Forest"},
    [986] = {wx = -375.68399, wy = -647.96503, flag = 3, name = "Zhu's Watch, Krasarang Wilds"},
    [985] = {wx = -221.32600, wy = 464.55899, flag = 3, name = "Halfhill, Valley of the Four Winds"},
    [991] = {wx = -1156.60999, wy = 1770.38000, flag = 5, name = "Sentinel Basecamp, Krasarang Wilds"},
    [989] = {wx = -436.54001, wy = 1886.69995, flag = 3, name = "Stoneplow, Valley of the Four Winds"},
    [1024] = {wx = 1880.58997, wy = 2088.58008, flag = 3, name = "Shado-Pan Fallback, Kun-Lai Summit"},
    [990] = {wx = -1685.68005, wy = 1590.33997, flag = 2, name = "Dawnchaser Retreat, Krasarang Wilds"},
    [967] = {wx = 1600.66003, wy = -2530.27002, flag = 3, name = "The Arboretum, Jade Forest"},
    [993] = {wx = -2504.09009, wy = 491.58301, flag = 3, name = "Marista, Krasarang Wilds"},
    [970] = {wx = 2400.75000, wy = -2099.42993, flag = 3, name = "Emperor's Omen, Jade Forest"},
    [968] = {wx = 773.24701, wy = -2358.95996, flag = 3, name = "Jade Temple Grounds, Jade Forest"},
    [1017] = {wx = 1690.10999, wy = 303.95801, flag = 3, name = "Binan Village, Kun-Lai Summit"},
    [972] = {wx = -186.09700, wy = -2594.61011, flag = 1, name = "Pearlfin Village, Jade Forest"},
    [1021] = {wx = 4362.95996, wy = 932.11798, flag = 3, name = "Zouchin Village, Kun-Lai Summit"},
    [1023] = {wx = 2716.42993, wy = 2163.31006, flag = 3, name = "Kota Basecamp, Kun-Lai Summit"},
    [1025] = {wx = 3151.85010, wy = 2677.76001, flag = 3, name = "Winter's Blossom, Kun-Lai Summit"},
  },
  [1643] = {
    [2274] = {wx = -1001.07001, wy = 1493.88000, flag = 10, name = "Swiftwind Post, Drustvar"},
    [2077] = {wx = -1688.04004, wy = -1420.53003, flag = 3, name = "Castaway Point, Tiragarde Sound"},
    [2052] = {wx = 790.83698, wy = 1861.54004, flag = 201, name = "Anglepoint Wharf, Tiragarde Sound"},
    [2056] = {wx = -135.63699, wy = 1764.27002, flag = 201, name = "Fallhaven, Drustvar"},
    [2074] = {wx = -93.73780, wy = -633.32300, flag = 1, name = "Bridgeport, Tiragarde Sound"},
    [2086] = {wx = 2495.52002, wy = -44.36810, flag = 1, name = "Brennadam, Stormsong Valley"},
    [2094] = {wx = 3889.08008, wy = 423.14899, flag = 10, name = "Warfang Hold, Stormsong Valley"},
    [2096] = {wx = -80.04510, wy = -2648.35010, flag = 5, name = "Tol Dagor, Tiragarde Sound"},
    [2104] = {wx = 124.18900, wy = -498.45300, flag = 201, name = "Eastpoint Station, Tiragarde Sound"},
    [2275] = {wx = 618.91101, wy = 1740.37000, flag = 10, name = "Mudfisher Cove, Drustvar"},
    [2279] = {wx = -809.11298, wy = 1041.01001, flag = 14, name = "Stonefist Watch, Tiragarde Sound"},
    [2278] = {wx = 465.68799, wy = -642.65100, flag = 1, name = "Mariner's Row, Tiragarde Sound"},
    [2138] = {wx = 3372.15991, wy = 1397.35999, flag = 1, name = "Fort Daelin, Stormsong Valley"},
    [2277] = {wx = 552.16803, wy = -126.11800, flag = 1, name = "Proudmoore Keep, Tiragarde Sound"},
    [2276] = {wx = 139.65800, wy = -2541.44995, flag = 6, name = "Tol Dagor, Tiragarde Sound"},
    [2441] = {wx = 3282.02002, wy = 4900.45996, flag = 2, name = "Prospectus Bay, Mechagon"},
    [2102] = {wx = 1174.62000, wy = 1838.38000, flag = 1, name = "Roughneck Camp, Tiragarde Sound"},
    [2140] = {wx = -191.64101, wy = -1487.96997, flag = 10, name = "Plunder Harbor, Tiragarde Sound"},
    [2139] = {wx = 4133.56982, wy = -110.04200, flag = 10, name = "Windfall Cavern, Stormsong Valley"},
    [2054] = {wx = 801.13501, wy = 252.16701, flag = 201, name = "Firebreaker Expedition, Tiragarde Sound"},
    [2135] = {wx = 340.83200, wy = 3160.43994, flag = 10, name = "Krazzlefrazz Outpost, Drustvar"},
    [2053] = {wx = -318.50500, wy = 980.13702, flag = 201, name = "Old Drust Road, Tiragarde Sound"},
    [2057] = {wx = -928.12299, wy = 1325.54004, flag = 201, name = "Fletcher's Hollow, Drustvar"},
    [2109] = {wx = 631.97900, wy = 3829.43994, flag = 3, name = "Whitegrove Chapel, Drustvar"},
    [2108] = {wx = -1501.96997, wy = 3755.72998, flag = 1, name = "Falconhurst, Drustvar"},
    [2107] = {wx = 100.12800, wy = 3478.34009, flag = 1, name = "Watchman's Rise, Drustvar"},
    [2023] = {wx = -1786.51001, wy = -729.38202, flag = 3, name = "Freehold, Tiragarde Sound"},
    [2106] = {wx = -742.60901, wy = 3115.29004, flag = 1, name = "Arom's Stand, Drustvar"},
    [2062] = {wx = 1641.33997, wy = 385.85199, flag = 10, name = "Wolf's Den, Tiragarde Sound"},
    [2273] = {wx = 1397.26001, wy = 2043.43005, flag = 2, name = "Waning Glacier, Tiragarde Sound"},
    [2037] = {wx = 350.88501, wy = 1710.32996, flag = 1, name = "Barbthorn Ridge, Drustvar"},
    [2034] = {wx = -296.98300, wy = 1227.53003, flag = 1, name = "Hangman's Point, Drustvar"},
    [2101] = {wx = 2508.09009, wy = 458.84000, flag = 1, name = "The Amber Waves, Stormsong Valley"},
    [2042] = {wx = -730.97601, wy = 706.56598, flag = 1, name = "Vigil Hill, Tiragarde Sound"},
    [2055] = {wx = -145.05701, wy = 41.04170, flag = 201, name = "Southwind Station, Tiragarde Sound"},
    [2067] = {wx = -254.58200, wy = -362.44400, flag = 10, name = "Timberfell Outpost, Tiragarde Sound"},
    [2079] = {wx = -921.96198, wy = -696.55200, flag = 1, name = "Kennings Lodge, Tiragarde Sound"},
    [2083] = {wx = 1153.03003, wy = -470.30099, flag = 5, name = "Tradewinds Market, Tiragarde Sound"},
    [2091] = {wx = 2636.48999, wy = 1138.15002, flag = 10, name = "Stonetusk Watch, Stormsong Valley"},
    [2097] = {wx = 2991.09009, wy = 914.74500, flag = 1, name = "Deadwash, Stormsong Valley"},
    [2105] = {wx = 1038.64001, wy = -586.50201, flag = 201, name = "Tradewinds Market, Tiragarde Sound"},
    [2060] = {wx = 1167.56995, wy = 24.06940, flag = 1, name = "Hatherford, Tiragarde Sound"},
    [2127] = {wx = -392.09500, wy = 4203.89014, flag = 3, name = "Anyport, Drustvar"},
    [2133] = {wx = 4073.12988, wy = -1087.64001, flag = 1, name = "Shrine of the Storm, Stormsong Valley"},
    [2137] = {wx = 2644.84009, wy = 1594.28003, flag = 1, name = "Millstone Hamlet, Stormsong Valley"},
    [2033] = {wx = -66.31600, wy = 2141.23999, flag = 1, name = "Fallhaven, Drustvar"},
    [2035] = {wx = -1045.72998, wy = 1277.66003, flag = 1, name = "Fletcher's Hollow, Drustvar"},
    [2442] = {wx = 3044.40991, wy = 4800.75977, flag = 5, name = "Overspark Expedition Camp, Mechagon"},
    [2084] = {wx = 889.00201, wy = 1064.58997, flag = 1, name = "Norwington Estate, Tiragarde Sound"},
    [2085] = {wx = 3346.84009, wy = -376.00201, flag = 1, name = "Tidecross, Stormsong Valley"},
    [2087] = {wx = 1080.94995, wy = 2347.85010, flag = 1, name = "Outrigger Post, Tiragarde Sound"},
    [2089] = {wx = 3752.62012, wy = 1068.59998, flag = 3, name = "Seekers Vista, Stormsong Valley"},
    [2090] = {wx = 2126.50000, wy = 349.99100, flag = 10, name = "Hillcrest Pasture, Stormsong Valley"},
    [2088] = {wx = 2700.28003, wy = -547.56598, flag = 1, name = "Mildenhall Meadery, Stormsong Valley"},
    [2092] = {wx = 3298.97998, wy = 262.87500, flag = 2, name = "Diretusk Hollow, Stormsong Valley"},
    [2093] = {wx = 2737.38989, wy = -966.67902, flag = 10, name = "Ironmaul Overlook, Stormsong Valley"},
    [2095] = {wx = 4252.02002, wy = -1080.81995, flag = 2, name = "Shrine of the Storm, Stormsong Valley"},
  },
  [530] = {
    [99] = {wx = 228.50000, wy = 2633.57007, flag = 2, name = "Thrallmar, Hellfire Peninsula"},
    [83] = {wx = 7594.47021, wy = -6784.29004, flag = 2, name = "Tranquillien, Ghostlands"},
    [213] = {wx = 13012.70020, wy = -6908.37012, flag = 3, name = "Shattered Sun Staging Area"},
    [151] = {wx = 91.67000, wy = 5214.91992, flag = 2, name = "Swamprat Post, Zangarmarsh"},
    [124] = {wx = -3982.07007, wy = 2156.46997, flag = 1, name = "Wildhammer Stronghold, Shadowmoon Valley"},
    [150] = {wx = 2974.94995, wy = 1848.23999, flag = 3, name = "Cosmowrench, Netherstorm"},
    [93] = {wx = -1933.27002, wy = -11954.59961, flag = 1, name = "Blood Watch, Bloodmyst Isle"},
    [149] = {wx = 276.20001, wy = 1486.91003, flag = 1, name = "Shatter Point, Hellfire Peninsula"},
    [125] = {wx = 2183.64990, wy = 6794.45996, flag = 1, name = "Sylvanaar, Blade's Edge Mountains"},
    [126] = {wx = 2446.37012, wy = 6020.93018, flag = 2, name = "Thunderlord Stronghold, Blade's Edge Mountains"},
    [127] = {wx = -2567.33008, wy = 4423.83008, flag = 2, name = "Stonebreaker Hold, Terokkar Forest"},
    [94] = {wx = -3867.56006, wy = -11641.09961, flag = 1, name = "The Exodar"},
    [159] = {wx = -4073.16992, wy = 1123.60999, flag = 3, name = "Sanctum of the Stars, Shadowmoon Valley"},
    [120] = {wx = -1261.08997, wy = 7133.39014, flag = 2, name = "Garadar, Nagrand"},
    [121] = {wx = -2987.23999, wy = 3872.78003, flag = 1, name = "Allerian Stronghold, Terokkar Forest"},
    [156] = {wx = 1857.34998, wy = 5531.87012, flag = 1, name = "Toshley's Station, Blade's Edge Mountains"},
    [122] = {wx = 3082.31006, wy = 3596.11011, flag = 3, name = "Area 52, Netherstorm"},
    [631] = {wx = 9501.92969, wy = -6767.08984, flag = 2, name = "Falconwing Square, Eversong Woods"},
    [123] = {wx = -3018.62012, wy = 2557.09009, flag = 2, name = "Shadowmoon Village, Shadowmoon Valley"},
    [624] = {wx = -4130.08008, wy = -12520.50000, flag = 1, name = "Azure Watch, Azuremyst Isle"},
    [101] = {wx = 199.16000, wy = 4241.56006, flag = 1, name = "Temple of Telhamat, Hellfire Peninsula"},
    [164] = {wx = 966.66998, wy = 7399.16016, flag = 1, name = "Orebor Harborage, Zangarmarsh"},
    [100] = {wx = -673.41998, wy = 2717.27002, flag = 1, name = "Honor Hold, Hellfire Peninsula"},
    [163] = {wx = 2028.79004, wy = 4705.27002, flag = 2, name = "Mok'Nathal Village, Blade's Edge Mountains"},
    [140] = {wx = -3065.60010, wy = 749.41998, flag = 3, name = "Altar of Sha'tar, Shadowmoon Valley"},
    [141] = {wx = -1316.83997, wy = 2358.62012, flag = 2, name = "Spinebreaker Ridge, Hellfire Peninsula"},
    [118] = {wx = 219.45000, wy = 7816.00000, flag = 2, name = "Zabra'jin, Zangarmarsh"},
    [625] = {wx = 8745.78027, wy = -6654.12012, flag = 2, name = "Fairbreeze Village, Eversong Woods"},
    [160] = {wx = 2976.01001, wy = 5501.12988, flag = 3, name = "Evergrove, Blade's Edge Mountains"},
    [119] = {wx = -2729.00000, wy = 7305.29980, flag = 1, name = "Telaar, Nagrand"},
    [205] = {wx = 6789.79004, wy = -7747.58008, flag = 3, name = "Zul'Aman, Ghostlands"},
    [128] = {wx = -1837.22998, wy = 5301.89990, flag = 3, name = "Shattrath, Terokkar Forest"},
    [129] = {wx = -327.35001, wy = 1020.48999, flag = 1, name = "Hellfire Peninsula, The Dark Portal"},
    [102] = {wx = -587.40997, wy = 4101.00977, flag = 2, name = "Falcon Watch, Hellfire Peninsula"},
    [130] = {wx = -178.09000, wy = 1026.71997, flag = 2, name = "Hellfire Peninsula, The Dark Portal"},
    [139] = {wx = 4157.58008, wy = 2959.68994, flag = 3, name = "The Stormspire, Netherstorm"},
    [117] = {wx = 213.75000, wy = 6063.75000, flag = 1, name = "Telredor, Zangarmarsh"},
    [82] = {wx = 9375.24023, wy = -7165.89014, flag = 6, name = "Silvermoon City"},
  },
  [1116] = {
    [1648] = {wx = 3728.37988, wy = 157.93100, flag = 3, name = "Sha'naari Refuge, Tanaan Jungle"},
    [1395] = {wx = 5789.56982, wy = 2394.88989, flag = 10, name = "Thunder Pass, Frostfire Ridge"},
    [1387] = {wx = 6754.56006, wy = 6012.54004, flag = 2, name = "Bladespire Citadel, Frostfire Ridge"},
    [1389] = {wx = 7399.45020, wy = 4358.41016, flag = 3, name = "Bloodmaul Slag Mines, Frostfire Ridge"},
    [1644] = {wx = 3979.30005, wy = 1216.62000, flag = 2, name = "The Iron Front, Tanaan Jungle"},
    [1383] = {wx = 602.69800, wy = -1710.44995, flag = 1, name = "Path of the Light, Shadowmoon Valley"},
    [1556] = {wx = 407.04199, wy = -2449.72998, flag = 1, name = "Tranquil Court, Shadowmoon Valley"},
    [1568] = {wx = 7093.60010, wy = 404.73999, flag = 3, name = "Everbloom Wilds, Gorgrond"},
    [1574] = {wx = 3676.04004, wy = 5776.18994, flag = 3, name = "Joz's Rylaks, Nagrand"},
    [1580] = {wx = 8018.08984, wy = -560.48999, flag = 3, name = "Everbloom Overlook, Gorgrond"},
    [1502] = {wx = 3040.78003, wy = 4783.08008, flag = 3, name = "The Ring of Trials, Nagrand"},
    [1476] = {wx = 1866.56006, wy = 219.46700, flag = 1, name = "Lunarfall (Alliance), Shadowmoon Valley"},
    [1524] = {wx = 8486.15039, wy = 1544.23999, flag = 3, name = "Iron Docks, Gorgrond"},
    [1520] = {wx = 6593.43018, wy = 1316.04004, flag = 3, name = "Breaker's Crown, Gorgrond"},
    [1528] = {wx = 5724.25977, wy = 2163.63989, flag = 1, name = "Iron Siegeworks, Frostfire Ridge"},
    [1510] = {wx = -1579.14001, wy = 993.09003, flag = 3, name = "Pinchwhistle Gearworks, Spires of Arak"},
    [1506] = {wx = 2594.25000, wy = 5700.62988, flag = 1, name = "Telaari Station, Nagrand"},
    [1518] = {wx = 6456.10010, wy = -174.75500, flag = 1, name = "Wildwood Wash, Gorgrond"},
    [1514] = {wx = 4837.62988, wy = 1687.55005, flag = 2, name = "Evermorn Springs, Gorgrond"},
    [1432] = {wx = 5578.93994, wy = 4564.83984, flag = 2, name = "Frostwall Garrison, Frostfire Ridge"},
    [1408] = {wx = 5356.22998, wy = -3942.23999, flag = 2, name = "Warspear, Ashran"},
    [1420] = {wx = 3685.14990, wy = -3840.46997, flag = 5, name = "Stormshield (Alliance), Ashran"},
    [1462] = {wx = 2158.64990, wy = 1634.46997, flag = 3, name = "Terokkar Refuge, Talador"},
    [1468] = {wx = 1240.19995, wy = -1666.43005, flag = 1, name = "Elodor (Alliance), Shadowmoon Valley"},
    [1440] = {wx = 3418.78003, wy = 1040.15002, flag = 3, name = "Zangarra, Talador"},
    [1452] = {wx = 1378.40002, wy = 3318.52002, flag = 3, name = "Retribution Point, Talador"},
    [1448] = {wx = 3407.72998, wy = 2062.00000, flag = 1, name = "Redemption Rise, Talador"},
    [1621] = {wx = 4307.91016, wy = -1465.31006, flag = 2, name = "Vol'mar, Tanaan Jungle"},
    [1396] = {wx = 6600.00000, wy = 4342.54980, flag = 2, name = "Darkspear's Edge, Frostfire Ridge"},
    [1384] = {wx = 1526.38000, wy = -788.89099, flag = 3, name = "Exile's Rise, Shadowmoon Valley"},
    [1388] = {wx = 7879.56982, wy = 5560.16992, flag = 2, name = "Throm'Var, Frostfire Ridge"},
    [1645] = {wx = 4074.96997, wy = 1183.75000, flag = 5, name = "The Iron Front, Tanaan Jungle"},
    [1382] = {wx = 195.23599, wy = -459.20001, flag = 1, name = "Twilight Glade, Shadowmoon Valley"},
    [1559] = {wx = 5830.85986, wy = 3004.09009, flag = 2, name = "Wolf's Stand, Frostfire Ridge"},
    [1539] = {wx = 7596.20020, wy = 1829.05005, flag = 3, name = "Skysea Ridge, Gorgrond"},
    [1569] = {wx = 676.42401, wy = 701.43903, flag = 3, name = "Akeeta's Hovel, Shadowmoon Valley"},
    [1573] = {wx = 2053.65991, wy = 6507.39014, flag = 3, name = "Nivek's Overlook, Nagrand"},
    [1493] = {wx = -1117.44995, wy = 2316.96997, flag = 1, name = "Southport, Spires of Arak"},
    [1503] = {wx = 3918.79004, wy = 5131.45020, flag = 3, name = "Throne of the Elements, Nagrand"},
    [1475] = {wx = -799.67401, wy = -671.42401, flag = 3, name = "Socrethar's Rise, Shadowmoon Valley"},
    [1487] = {wx = -368.20099, wy = 2285.55005, flag = 2, name = "Axefall, Spires of Arak"},
    [1647] = {wx = 4457.54004, wy = -574.69299, flag = 3, name = "Malo's Lookout, Tanaan Jungle"},
    [1646] = {wx = 3475.28003, wy = -762.55200, flag = 3, name = "Vault of the Earth, Tanaan Jungle"},
    [1523] = {wx = 5412.85010, wy = 1271.05005, flag = 1, name = "Deeproot, Gorgrond"},
    [1643] = {wx = 4569.43994, wy = 335.05399, flag = 3, name = "Aktar's Post, Tanaan Jungle"},
    [1529] = {wx = -974.12500, wy = -1739.30005, flag = 3, name = "Darktide Roost, Shadowmoon Valley"},
    [1511] = {wx = 4552.27002, wy = 1274.56006, flag = 1, name = "Bastion Rise, Gorgrond"},
    [1507] = {wx = 3384.16992, wy = 5755.58008, flag = 1, name = "Yrel's Watch, Nagrand"},
    [1519] = {wx = 6352.58008, wy = 746.23401, flag = 1, name = "Highpass, Gorgrond"},
    [1515] = {wx = 128.61501, wy = 1544.63000, flag = 3, name = "Crow's Crook, Spires of Arak"},
    [1442] = {wx = 5815.50977, wy = 1304.33997, flag = 2, name = "Beastwatch, Gorgrond"},
    [1443] = {wx = 3258.83008, wy = 1609.27002, flag = 2, name = "Vol'jin's Pride, Talador"},
    [1508] = {wx = -398.98801, wy = 1880.12000, flag = 3, name = "Veil Terokk, Spires of Arak"},
    [1509] = {wx = -335.45099, wy = 926.62201, flag = 3, name = "Talon Watch, Spires of Arak"},
    [1505] = {wx = 3102.81006, wy = 6500.37988, flag = 2, name = "Riverside Post, Nagrand"},
    [1454] = {wx = 1731.08997, wy = 2581.53003, flag = 2, name = "Exarch's Refuge, Talador"},
    [1447] = {wx = 3576.81006, wy = 1669.40002, flag = 1, name = "Fort Wrynn (Alliance), Talador"},
    [1381] = {wx = 918.26398, wy = -792.36102, flag = 1, name = "Embaari Village, Shadowmoon Valley"},
    [1450] = {wx = 2727.15991, wy = 2777.00000, flag = 3, name = "Shattrath City, Talador"},
    [1512] = {wx = 4641.62012, wy = 1188.06995, flag = 2, name = "Bastion Rise, Gorgrond"},
    [1504] = {wx = 3235.72998, wy = 4584.54980, flag = 2, name = "Wor'var, Nagrand"},
    [1467] = {wx = 128.56900, wy = -1555.75000, flag = 1, name = "The Draakorium, Shadowmoon Valley"},
    [1445] = {wx = 2808.79004, wy = 2525.73999, flag = 2, name = "Durotan's Grasp, Talador"},
    [1441] = {wx = 4008.86011, wy = 2166.87012, flag = 2, name = "Frostwolf Overlook, Talador"},
    [1453] = {wx = 1696.50000, wy = 2561.35010, flag = 1, name = "Exarch's Refuge, Talador"},
    [1451] = {wx = 2171.82007, wy = 1059.21997, flag = 1, name = "Anchorite's Sojourn, Talador"},
    [1620] = {wx = 3875.21997, wy = -1311.71997, flag = 1, name = "Lion's Watch, Tanaan Jungle"},
    [1513] = {wx = 387.54199, wy = 2442.72998, flag = 3, name = "Apexis Excavation, Spires of Arak"},
    [1572] = {wx = 3761.26001, wy = 6430.14990, flag = 3, name = "Rilzit's Holdfast, Nagrand"},
    [1390] = {wx = 6157.56006, wy = 5052.43994, flag = 2, name = "Stonefang Outpost, Frostfire Ridge"},
    [1386] = {wx = 5988.68018, wy = 6180.85986, flag = 2, name = "Wor'gol, Frostfire Ridge"},
  },
  [1795] = {
    [2544] = {wx = 685.71002, wy = 1492.81006, flag = 3, name = "Mistfall Village, Vale of Eternal Blossoms"},
  },
  [2738] = {
    [3164] = {wx = -289.40500, wy = 787.75500, flag = 491, name = "Hosaas' Rest"},
    [3034] = {wx = 1160.18005, wy = 1281.22998, flag = 3, name = "Overlook Zo'Shuul, K'aresh"},
    [3029] = {wx = -636.51398, wy = 5.41840, flag = 3, name = "Tazavesh, K'aresh"},
    [3163] = {wx = -482.05600, wy = 985.00897, flag = 491, name = "Ruins of Yaathron"},
    [3162] = {wx = 1733.56006, wy = 771.22101, flag = 491, name = "Untethered Space"},
    [3161] = {wx = 2027.46997, wy = 596.68402, flag = 491, name = "Fracture of Laacuna"},
    [3035] = {wx = -244.50200, wy = 753.81598, flag = 3, name = "Hosaas Rest, K'aresh"},
    [3030] = {wx = -144.86800, wy = -570.47900, flag = 3, name = "Eco-Dome: Rhovan, K'aresh"},
    [3033] = {wx = 1961.79004, wy = 1742.22998, flag = 3, name = "Shadow Point, K'aresh"},
    [3155] = {wx = 1891.19995, wy = 1497.51001, flag = 491, name = "Shadow Point"},
    [3145] = {wx = -1206.65002, wy = -217.33900, flag = 483, name = "Tazavesh, the Veiled Market"},
    [3032] = {wx = 1610.06995, wy = 227.20100, flag = 3, name = "Shan'dorah, K'aresh"},
    [3031] = {wx = 1290.25000, wy = -1099.30005, flag = 3, name = "The Oasis, K'aresh"},
    [3146] = {wx = 1391.81995, wy = -1040.18005, flag = 491, name = "The Oasis"},
    [3156] = {wx = 529.13202, wy = 999.41101, flag = 491, name = "Serrated Peaks"},
    [3147] = {wx = 1611.43005, wy = 249.98599, flag = 491, name = "Shan'dorah"},
    [3159] = {wx = 509.88199, wy = -1143.69995, flag = 491, name = "North Sufaad"},
    [3160] = {wx = 25.08850, wy = 365.99500, flag = 491, name = "Naakroa"},
    [3157] = {wx = 1201.55005, wy = 1062.01001, flag = 491, name = "Overlook Zo'Shuul"},
    [3158] = {wx = 562.82098, wy = -170.86501, flag = 491, name = "Lunnall River"},
  },
  [2552] = {
    [2932] = {wx = 3517.62012, wy = -3394.80005, flag = 3, name = "Rambleshire, Isle of Dorn"},
    [2929] = {wx = 985.46002, wy = -1847.63000, flag = 3, name = "Freywold Village, Isle of Dorn"},
    [2972] = {wx = 985.46002, wy = -1847.63000, flag = 128, name = "Jeff the Flightmaster"},
    [2928] = {wx = 2585.43994, wy = -2473.32007, flag = 3, name = "Dornogal, Isle of Dorn"},
    [2931] = {wx = 2673.65991, wy = -4099.72998, flag = 3, name = "Durgaz Cabin, Isle of Dorn"},
  },
  [2706] = {
    [2997] = {wx = -18.04170, wy = 914.70697, flag = 3, name = "Slam Central Station"},
    [2999] = {wx = 38.32990, wy = 153.47600, flag = 3, name = "The Gallagio"},
    [2996] = {wx = -385.97900, wy = 519.48602, flag = 3, name = "The Heaps"},
    [2998] = {wx = 576.26703, wy = 225.82600, flag = 3, name = "Demolition Dome"},
    [2988] = {wx = 65.56770, wy = 535.78497, flag = 3, name = "The Incontinental Hotel"},
  },
  [2548] = {
    [2905] = {wx = -282.98300, wy = 8216.58008, flag = 3, name = "Wellspring Overlook, The Emerald Dream"},
    [2904] = {wx = -81.62150, wy = 6754.06982, flag = 3, name = "Eye of Ysera, The Emerald Dream"},
    [2902] = {wx = -1716.34998, wy = 7074.14014, flag = 3, name = "Central Encampment, The Emerald Dream"},
    [2903] = {wx = -1328.38000, wy = 5746.04980, flag = 3, name = "Verdant Landing, The Emerald Dream"},
  },
  [2454] = {
    [2865] = {wx = -959.29901, wy = 3140.22998, flag = 3, name = "Dragonscale Camp, Zaralek Cavern"},
    [2864] = {wx = 1061.21997, wy = 2355.43994, flag = 3, name = "Obsidian Rest, Zaralek Cavern"},
    [2863] = {wx = -324.57300, wy = 2032.03003, flag = 3, name = "Loamm, Zaralek Cavern"},
  },
  [2444] = {
    [2855] = {wx = 6407.70996, wy = -2560.27002, flag = 3, name = "Morqut Village, The Forbidden Reach"},
    [2825] = {wx = -2444.62012, wy = 2524.69995, flag = 3, name = "Ohn'iri Springs, Ohn'ahran Plains"},
    [2817] = {wx = 2610.12012, wy = -1153.97998, flag = 3, name = "Skytop Observatory, The Waking Shores"},
    [2841] = {wx = 2339.43994, wy = -1351.97998, flag = 99, name = "Skytop Observatory, The Waking Shores"},
    [2837] = {wx = -3162.35010, wy = -2953.37988, flag = 99, name = "Vakthros, Azure Span"},
    [2804] = {wx = 3407.94995, wy = 322.64200, flag = 3, name = "Uktulut Backwater, The Waking Shores"},
    [2810] = {wx = -10.02950, wy = -844.18597, flag = 3, name = "Valdrakken, Thaldraszus"},
    [2784] = {wx = -5185.14014, wy = -1414.03003, flag = 3, name = "Camp Nowhere, Azure Span"},
    [2798] = {wx = -1504.53003, wy = 727.17700, flag = 3, name = "Pinewood Post, Ohn'ahran Plains"},
    [2774] = {wx = -3800.95996, wy = 404.45099, flag = 3, name = "Camp Antonidas, Azure Span"},
    [2752] = {wx = 1530.00000, wy = -393.00000, flag = 227, name = "Ruby Lifeshrine, The Waking Shores"},
    [2801] = {wx = 949.51703, wy = 2758.06006, flag = 3, name = "Apex Observatory, The Waking Shores"},
    [2794] = {wx = -1671.17004, wy = 3788.55005, flag = 3, name = "Teerakai, Ohn'ahran Plains"},
    [2842] = {wx = 568.22302, wy = 882.83801, flag = 99, name = "Rubyscale Outpost, The Waking Shores"},
    [2812] = {wx = -1287.82996, wy = -2946.32007, flag = 3, name = "Temporal Conflux, Thaldraszus"},
    [2839] = {wx = -546.64001, wy = 662.31000, flag = 99, name = "Rusza'thar Reach, Ohn'ahran Plains"},
    [2838] = {wx = -3116.15991, wy = 230.26300, flag = 99, name = "Cobalt Assembly, Azure Span"},
    [2836] = {wx = 1474.69995, wy = -3201.79004, flag = 99, name = "Algeth'era, Thaldraszus"},
    [2862] = {wx = 6308.24023, wy = -2255.78003, flag = 99, name = "Morqut Islet, Forbidden Reach"},
    [2818] = {wx = 394.64899, wy = -4186.89014, flag = 3, name = "Vault of the Incarnates, Thaldraszus"},
    [2813] = {wx = 1378.71997, wy = -1893.48999, flag = 3, name = "Algeth'era, Thaldraszus"},
    [2815] = {wx = -1118.85999, wy = -485.13400, flag = 3, name = "Garden Shrine, Thaldraszus"},
    [2814] = {wx = 2929.66992, wy = -3170.86011, flag = 3, name = "Veiled Ossuary, Thaldraszus"},
    [2816] = {wx = -1125.42004, wy = -2708.84009, flag = 3, name = "Shifting Sands, Thaldraszus"},
    [2840] = {wx = -1379.76001, wy = 4499.68994, flag = 99, name = "Shady Sanctuary, Ohn'ahran Plains"},
    [2834] = {wx = -1094.85999, wy = -2180.93994, flag = 99, name = "Eon's Fringe, Thaldraszus"},
    [2807] = {wx = 1753.25000, wy = 42.12500, flag = 3, name = "Ruby Life Pools, The Waking Shores"},
    [2811] = {wx = -317.99799, wy = -2055.98999, flag = 3, name = "Gelikyr Post, Thaldraszus"},
    [2787] = {wx = -2575.58008, wy = 145.81599, flag = 3, name = "Cobalt Assembly, Azure Span"},
    [2795] = {wx = -666.65802, wy = 3296.98999, flag = 3, name = "Broadhoof Outpost, Ohn'ahran Plains"},
    [2775] = {wx = -4471.60010, wy = 4051.16992, flag = 3, name = "Iskaara, Azure Span"},
    [2793] = {wx = -2578.26001, wy = 1392.60999, flag = 3, name = "Forkriver Crossing, Ohn'ahran Plains"},
    [2790] = {wx = 204.83900, wy = 365.97699, flag = 3, name = "Timberstep Outpost, Ohn'ahran Plains"},
    [2789] = {wx = -2646.12988, wy = 3410.31006, flag = 3, name = "Three-Falls Lookout, Azure Span"},
    [2739] = {wx = 2348.88989, wy = -1394.94995, flag = 227, name = "Rebuff Lookout, The Waking Shores"},
    [2788] = {wx = -2114.68994, wy = -1620.64001, flag = 3, name = "Theron's Watch, Azure Span"},
    [2786] = {wx = -2771.06006, wy = -1691.82996, flag = 3, name = "Rhonin's Shield, Azure Span"},
    [2792] = {wx = -706.47601, wy = 2048.89990, flag = 3, name = "Maruukai, Ohn'ahran Plains"},
    [2773] = {wx = -5341.56982, wy = 1454.62000, flag = 3, name = "Azure Archives, Azure Span"},
    [2741] = {wx = 3094.98999, wy = 86.55730, flag = 227, name = "Skytop Lookout (QD), The Waking Shores"},
    [2796] = {wx = -1493.50000, wy = 4564.60986, flag = 3, name = "Shady Sanctuary, Ohn'ahran Plains"},
    [2797] = {wx = 147.85600, wy = 1759.92004, flag = 3, name = "Emberwatch, Ohn'ahran Plains"},
    [2799] = {wx = -444.33701, wy = 407.77600, flag = 3, name = "Rusza'thar Reach, Ohn'ahran Plains"},
    [2915] = {wx = -1715.96997, wy = 7073.85010, flag = 3, name = "Bel'ameth, Amirdrassil"},
    [2802] = {wx = 2337.28003, wy = 2635.61011, flag = 3, name = "Obsidian Throne, The Waking Shores"},
    [2803] = {wx = 3908.17993, wy = 997.29199, flag = 3, name = "Uktulut Pier, The Waking Shores"},
    [2808] = {wx = 1847.21997, wy = 1283.48999, flag = 3, name = "Obsidian Bulwark, The Waking Shores"},
    [2800] = {wx = 652.89600, wy = 3258.60010, flag = 3, name = "Uktulut Outpost, The Waking Shores"},
    [2805] = {wx = 3508.34009, wy = -1411.17004, flag = 3, name = "Wingrest Embassy, The Waking Shores"},
    [2806] = {wx = 2321.31006, wy = -533.65302, flag = 3, name = "Life Vault Ruins, The Waking Shores"},
    [2809] = {wx = 939.79199, wy = 832.41498, flag = 3, name = "Dragonscale Basecamp, The Waking Shores"},
  },
  [2175] = {
    [2402] = {wx = 1023.71997, wy = -1307.58997, flag = 1, name = "Ogre Citadel, Exile's Reach Island"},
    [2401] = {wx = 209.14200, wy = -2295.62988, flag = 1, name = "Alliance Outpost, Exile's Reach Outpost"},
  },
  [1718] = {
    [2482] = {wx = 2113.03003, wy = -584.93402, flag = 10, name = "The Tidal Conflux, Nazjatar"},
    [2483] = {wx = 2112.79004, wy = -525.21198, flag = 9, name = "The Tidal Conflux, Nazjatar"},
    [2411] = {wx = 1721.81006, wy = 128.68100, flag = 2, name = "Ashen Strand, Nazjatar"},
    [2412] = {wx = 449.53799, wy = 54.11630, flag = 2, name = "Wreck of the Hungry Riverbeast, Nazjatar"},
    [2437] = {wx = 1316.75000, wy = -1130.31995, flag = 2, name = "Ekka's Hideaway, Nazjatar"},
    [2405] = {wx = 1707.18005, wy = -1794.62000, flag = 2, name = "Zin'Azshari, Nazjatar"},
    [2403] = {wx = 2077.94995, wy = -1566.26001, flag = 3, name = "Kelya's Grave, Nazjatar"},
    [2410] = {wx = 1708.19995, wy = 237.06799, flag = 9, name = "Ashen Strand, Nazjatar"},
    [2406] = {wx = 1652.43005, wy = -1560.80005, flag = 1, name = "Orise's Vigil, Nazjatar"},
    [2404] = {wx = 988.80603, wy = -425.99701, flag = 2, name = "Newhome, Nazjatar"},
    [2407] = {wx = 1747.16003, wy = -1035.33997, flag = 1, name = "Utama's Stand, Nazjatar"},
    [2408] = {wx = 1251.15002, wy = -101.86100, flag = 1, name = "Mezzamere, Nazjatar"},
    [2409] = {wx = 359.45001, wy = -299.94800, flag = 1, name = "Wreck of the Old Blanchy, Nazjatar"},
  },
  [2601] = {
    [2921] = {wx = -1406.26001, wy = -2817.04004, flag = 3, name = "Mmarl, Azj-Kahet"},
    [2963] = {wx = 1529.30005, wy = -3782.61011, flag = 3, name = "Shadowvein Point, The Ringing Deeps"},
    [2920] = {wx = 689.84698, wy = -1651.45996, flag = 3, name = "Faerin's Advance, Azj-Kahet"},
    [2922] = {wx = 2471.55005, wy = -1204.88000, flag = 3, name = "Dunelle's Kindness, Hallowfall"},
    [3000] = {wx = -180.31300, wy = -4803.27002, flag = 3, name = "Gutterville, The Ringing Deeps"},
    [2889] = {wx = -796.04303, wy = 876.14398, flag = 3, name = "Wildcamp Or'lay, Azj-Kahet"},
    [2925] = {wx = 72.31600, wy = -4018.75000, flag = 3, name = "Opportunity Point, The Ringing Deeps"},
    [2950] = {wx = 1815.48999, wy = -1522.89001, flag = 7, name = "The Aegis Wall, Hallowfall"},
    [2923] = {wx = 1552.83997, wy = 10.93400, flag = 3, name = "Lightspark, Hallowfall"},
    [2962] = {wx = 2224.32007, wy = -2735.79004, flag = 3, name = "Gundargaz, The Ringing Deeps"},
    [2924] = {wx = 998.53802, wy = 1040.23999, flag = 3, name = "Light's Redoubt, Hallowfall"},
    [2919] = {wx = -1544.42004, wy = -590.80402, flag = 3, name = "Wildcamp Ul'ar, Azj-Kahet"},
    [2943] = {wx = 2689.72998, wy = 385.19101, flag = 3, name = "Lorel's Crossing, Hallowfall"},
    [2941] = {wx = 2035.14001, wy = 953.68103, flag = 3, name = "Mereldar, Hallowfall"},
    [2893] = {wx = -2149.56006, wy = -975.33002, flag = 3, name = "The Burrows, Azj-Kahet"},
    [2882] = {wx = -593.34998, wy = -1446.64001, flag = 3, name = "Weaver's Lair, Azj-Kahet"},
    [2926] = {wx = 748.12799, wy = -3548.26001, flag = 3, name = "Camp Murroch, The Ringing Deeps"},
    [2944] = {wx = 3235.26001, wy = -692.19397, flag = 3, name = "Hillhelm Family Farm, Hallowfall"},
    [2942] = {wx = 3074.37988, wy = 988.04498, flag = 7, name = "Priory of the Sacred Flame, Hallowfall"},
  },
  [1190] = {
    [1538] = {wx = -11254.00000, wy = -3666.57007, flag = 9, name = "Shattered Beachhead, Blasted Lands"},
    [1537] = {wx = -11771.20020, wy = -3867.32007, flag = 10, name = "Shattered Landing, Blasted Lands"},
  },
  [1642] = {
    [2078] = {wx = 2079.33008, wy = 176.21500, flag = 1, name = "Fort Victory, Nazmir"},
    [2080] = {wx = 1310.31006, wy = 1647.50000, flag = 9, name = "Grimwatt's Crash, Nazmir"},
    [2110] = {wx = 2778.29004, wy = 4186.95996, flag = 9, name = "Shatterstone Harbor, Vol'dun"},
    [2118] = {wx = 284.26401, wy = 3029.70996, flag = 2, name = "Temple of Akunda, Vol'dun"},
    [2126] = {wx = -290.76599, wy = -281.03799, flag = 3, name = "Scaletrader Post, Zuldazar"},
    [2144] = {wx = 1559.93994, wy = 3777.53003, flag = 2, name = "Goldtusk Inn, Vol'dun"},
    [2164] = {wx = -3529.85010, wy = 1103.29004, flag = 2, name = "Isle of Fangs, Zuldazar"},
    [2012] = {wx = -2652.84009, wy = 2272.02002, flag = 1, name = "Xibala, Zuldazar"},
    [2009] = {wx = -2022.55005, wy = 1629.16003, flag = 2, name = "Warport Rastari, Zuldazar"},
    [2117] = {wx = 2095.05005, wy = 2808.83008, flag = 2, name = "Vulpera Hideaway, Vol'dun"},
    [2165] = {wx = -3018.71997, wy = 686.41998, flag = 2, name = "Tusk Isle, Zuldazar"},
    [1954] = {wx = 2025.87000, wy = 1336.53003, flag = 2, name = "Zo'bal Ruins, Nazmir"},
    [2027] = {wx = -1132.62000, wy = 1499.69995, flag = 2, name = "Temple of the Prophet, Zuldazar"},
    [2157] = {wx = -696.90601, wy = 1942.73999, flag = 9, name = "Veiled Grotto, Zuldazar"},
    [2153] = {wx = -1293.62000, wy = 259.44800, flag = 9, name = "Mistvine Ledge, Zuldazar"},
    [2045] = {wx = -104.02300, wy = 1502.47998, flag = 2, name = "Garden of the Loa, Zuldazar"},
    [2148] = {wx = -150.21201, wy = 1911.94995, flag = 9, name = "Mugamba Overlook, Zuldazar"},
    [2061] = {wx = -624.58801, wy = 715.30499, flag = 2, name = "The Sliver, Zuldazar"},
    [2147] = {wx = -1697.42004, wy = -862.75201, flag = 1, name = "Castaway Encampment, Zuldazar"},
    [2075] = {wx = -2303.22998, wy = -252.86800, flag = 3, name = "Seeker's Outpost, Zuldazar"},
    [2046] = {wx = -639.64899, wy = 1806.08997, flag = 2, name = "Atal'Dazar, Zuldazar"},
    [1975] = {wx = 512.45001, wy = -835.21899, flag = 2, name = "Zeb'ahari, Zuldazar"},
    [1953] = {wx = 793.23602, wy = 1400.73999, flag = 2, name = "Zul'jan, Nazmir"},
    [2111] = {wx = 2740.17993, wy = 3469.89990, flag = 2, name = "Vorrik's Sanctum, Vol'dun"},
    [2119] = {wx = 2048.03003, wy = 4806.85986, flag = 7, name = "Sanctuary of the Devoted, Vol'dun"},
    [1959] = {wx = -1035.97998, wy = 756.59998, flag = 2, name = "The Great Seal"},
    [1955] = {wx = 2007.54004, wy = -79.64240, flag = 2, name = "Gloom Hollow, Nazmir"},
    [2143] = {wx = 884.99799, wy = 3698.92993, flag = 2, name = "Scorched Sands Outpost, Vol'dun"},
    [2145] = {wx = -19.93750, wy = 999.85901, flag = 9, name = "Verdant Hollow, Zuldazar"},
    [1974] = {wx = -2692.84009, wy = 1915.12000, flag = 2, name = "Xibala, Zuldazar"},
    [2161] = {wx = 2799.25000, wy = 774.20099, flag = 1, name = "Redfield's Watch, Nazmir"},
    [1956] = {wx = 2596.87988, wy = -848.68799, flag = 10, name = "Forlorn Ruins, Nazmir"},
    [1957] = {wx = -1950.78003, wy = 744.28003, flag = 6, name = "Port of Zandalar, Zuldazar"},
    [1965] = {wx = 382.02399, wy = 104.04300, flag = 3, name = "Nesingwary's Gameland, Zuldazar"},
    [2076] = {wx = -959.60797, wy = -1058.67004, flag = 3, name = "Atal'Gral, Zuldazar"},
    [1966] = {wx = -1046.31995, wy = 19.17360, flag = 2, name = "Warbeast Kraal, Zuldazar"},
    [2112] = {wx = 2623.35010, wy = 3038.16992, flag = 9, name = "Vulture's Nest, Vol'dun"},
    [2114] = {wx = 528.71198, wy = 3983.06006, flag = 9, name = "Deadwood Cove, Vol'dun"},
    [2381] = {wx = -1849.67004, wy = 1195.69995, flag = 6, name = "The Mugambala, Zuldazar"},
    [2120] = {wx = 3353.12988, wy = 2476.12988, flag = 3, name = "Tortaka Refuge, Vol'dun"},
  },
  [2222] = {
    [2594] = {wx = -1815.68994, wy = 1302.41003, flag = 163, name = "9.0 Maw - Oribos - Teleport In"},
    [2590] = {wx = -6828.47998, wy = 798.73297, flag = 3, name = "Refugee Camp, Ardenweald"},
    [2560] = {wx = 3531.67993, wy = -2766.63989, flag = 3, name = "Keres' Rest, Maldraxxus"},
    [2559] = {wx = 3587.01001, wy = -1746.56006, flag = 3, name = "Spider's Watch, Maldraxxus"},
    [2537] = {wx = -2191.10010, wy = 7223.68018, flag = 3, name = "Charred Ramparts, Revendreth"},
    [2529] = {wx = -2944.08008, wy = -4853.70996, flag = 3, name = "Hero's Rest, Bastion"},
    [2513] = {wx = -1798.88000, wy = 5975.68994, flag = 3, name = "Old Gate, Revendreth"},
    [2511] = {wx = -2172.12012, wy = 7696.52002, flag = 3, name = "Sanctuary of the Mad, Revendreth"},
    [2698] = {wx = 3270.72998, wy = 5739.16016, flag = 43, name = "Keeper's Respite"},
    [2398] = {wx = 1974.73999, wy = -2691.75000, flag = 3, name = "Bleak Redoubt, Maldraxxus"},
    [2625] = {wx = -1714.81995, wy = -5786.20996, flag = 99, name = "Elysian Hold, Bastion"},
    [2633] = {wx = -4290.81006, wy = -5383.72021, flag = 99, name = "Temple of Purity, Bastion"},
    [2515] = {wx = -1424.75000, wy = 7952.00977, flag = 3, name = "Dominance Keep, Revendreth"},
    [2700] = {wx = 4535.12988, wy = 6706.66016, flag = 43, name = "Ve'nari's Refuge"},
    [2682] = {wx = -1919.25000, wy = -5533.35986, flag = 227, name = "Elysian Beacon, Bastion"},
    [2558] = {wx = 2489.25000, wy = -1839.09998, flag = 3, name = "The Spearhead, Maldraxxus"},
    [2636] = {wx = -1837.66003, wy = -3781.41992, flag = 99, name = "Terrace of the Collectors, Bastion"},
    [2589] = {wx = -7747.39990, wy = 657.87500, flag = 3, name = "Claw's Edge, Ardenweald"},
    [2635] = {wx = -2986.03003, wy = -5855.18994, flag = 99, name = "Temple of Humility, Bastion"},
    [2569] = {wx = 1778.31995, wy = -3039.29004, flag = 3, name = "Plague Watch, Maldraxxus"},
    [2634] = {wx = -2239.55005, wy = -5313.10010, flag = 99, name = "Seat of Eternal Hymns, Bastion"},
    [2556] = {wx = 4464.52979, wy = 6831.62988, flag = 43, name = "Progenitor Console"},
    [2548] = {wx = -1852.38000, wy = 7585.41992, flag = 3, name = "Sinfall, Revendreth"},
    [2588] = {wx = -6821.22998, wy = 1804.90002, flag = 3, name = "Root-Home, Ardenweald"},
    [2528] = {wx = -1636.67004, wy = -5815.99023, flag = 11, name = "Elysian Hold, Bastion"},
    [2520] = {wx = -2305.08008, wy = -4361.41016, flag = 3, name = "Sagehaven, Bastion"},
    [2518] = {wx = -2952.60010, wy = 6721.12988, flag = 3, name = "Wanecrypt Hill, Revendreth"},
    [2631] = {wx = -3316.85010, wy = -4135.93994, flag = 99, name = "Xandria's Vigil, Bastion"},
    [2630] = {wx = -4101.20020, wy = -4643.75977, flag = 99, name = "Aspirant's Rest, Bastion"},
    [2488] = {wx = -2623.97998, wy = 6010.49023, flag = 3, name = "Darkhaven, Revendreth"},
    [2587] = {wx = -6788.56006, wy = 1006.79999, flag = 3, name = "Heart of the Forest, Ardenweald"},
    [2512] = {wx = -1848.27002, wy = 5393.16016, flag = 3, name = "Halls of Atonement, Revendreth"},
    [2519] = {wx = -4160.75000, wy = -4629.77002, flag = 3, name = "Aspirant's Rest, Bastion"},
    [2517] = {wx = -1304.68994, wy = 6367.64990, flag = 3, name = "Menagerie of the Master, Revendreth"},
    [2586] = {wx = -6903.62988, wy = 15.22220, flag = 3, name = "Hibernal Hollow, Ardenweald"},
    [2703] = {wx = -5895.64014, wy = 4810.74023, flag = 11, name = "Tazavesh, the Veiled Market"},
    [2514] = {wx = -3387.69995, wy = 5461.45996, flag = 3, name = "Pridefall Hamlet, Revendreth"},
    [2680] = {wx = -1803.76001, wy = -3804.84009, flag = 3, name = "Terrace of the Collectors, Bastion"},
    [2561] = {wx = 2891.32007, wy = -3648.03003, flag = 3, name = "Renounced Bastille, Maldraxxus"},
    [2564] = {wx = 2580.46997, wy = -2520.76001, flag = 3, name = "Theater of Pain, Maldraxxus"},
    [2585] = {wx = -6143.77979, wy = -207.12801, flag = 3, name = "Tirna Vaal, Ardenweald"},
    [2395] = {wx = -1902.43994, wy = 1214.76001, flag = 3, name = "Oribos"},
    [2626] = {wx = -2943.62988, wy = -4871.95020, flag = 99, name = "Hero's Rest, Bastion"},
    [2632] = {wx = -2330.70996, wy = -4365.93018, flag = 99, name = "Sagehaven, Bastion"},
    [2584] = {wx = -5993.72021, wy = 650.75500, flag = 3, name = "Glitterfall Basin, Ardenweald"},
  },
  [571] = {
    [295] = {wx = 785.27002, wy = -2887.70996, flag = 3, name = "Kamagua, Howling Fjord"},
    [294] = {wx = 2792.44995, wy = 908.96002, flag = 3, name = "Moa'ki, Dragonblight"},
    [244] = {wx = 3712.42993, wy = -694.85999, flag = 1, name = "Wintergarde Keep, Dragonblight"},
    [245] = {wx = 2269.54004, wy = 5173.68994, flag = 1, name = "Valiance Keep, Borean Tundra"},
    [183] = {wx = 567.40997, wy = -5010.97021, flag = 1, name = "Valgarde Port, Howling Fjord"},
    [303] = {wx = 5100.81006, wy = 2185.64990, flag = 1, name = "Valiance Landing Camp, Wintergrasp"},
    [309] = {wx = 5596.10010, wy = 5824.37012, flag = 3, name = "Nesingwary Base Camp, Sholazar Basin"},
    [296] = {wx = 2919.18994, wy = 4046.09009, flag = 3, name = "Unu'pe, Borean Tundra"},
    [190] = {wx = 401.12000, wy = -4544.29980, flag = 2, name = "New Agamand, Howling Fjord"},
    [310] = {wx = 5813.89014, wy = 449.13000, flag = 3, name = "Dalaran"},
    [252] = {wx = 3653.20996, wy = 247.58000, flag = 3, name = "Wyrmrest Temple, Dragonblight"},
    [308] = {wx = 5506.22998, wy = 4748.10010, flag = 3, name = "River's Heart, Sholazar Basin"},
    [253] = {wx = 3446.35010, wy = -2754.10010, flag = 1, name = "Amberpine Lodge, Grizzly Hills"},
    [306] = {wx = 5190.10986, wy = -2206.45996, flag = 3, name = "Light's Breach, Zul'Drak"},
    [305] = {wx = 5218.89990, wy = -1302.21997, flag = 7, name = "Ebon Watch, Zul'Drak"},
    [304] = {wx = 5521.62988, wy = -2672.25000, flag = 3, name = "The Argent Stand, Zul'Drak"},
    [255] = {wx = 4584.97998, wy = -4254.68994, flag = 1, name = "Westfall Brigade, Grizzly Hills"},
    [191] = {wx = 1918.59998, wy = -6175.89014, flag = 2, name = "Vengeance Landing, Howling Fjord"},
    [248] = {wx = 2108.11011, wy = -2970.62012, flag = 2, name = "Apothecary Camp, Howling Fjord"},
    [332] = {wx = 5024.99023, wy = 3685.55005, flag = 2, name = "Warsong Camp, Wintergrasp"},
    [249] = {wx = 3876.34009, wy = -4520.08008, flag = 2, name = "Camp Oneqwah, Grizzly Hills"},
    [334] = {wx = 6164.49023, wy = -61.31000, flag = 3, name = "The Argent Vanguard, Icecrown"},
    [250] = {wx = 3258.89990, wy = -2263.09009, flag = 2, name = "Conquest Hold, Grizzly Hills"},
    [326] = {wx = 8864.74023, wy = -1324.32996, flag = 3, name = "Ulduar, The Storm Peaks"},
    [184] = {wx = 2468.77002, wy = -5029.81982, flag = 1, name = "Fort Wildervar, Howling Fjord"},
    [324] = {wx = 7793.85010, wy = -2810.09009, flag = 2, name = "Camp Tunka'lo, The Storm Peaks"},
    [185] = {wx = 1342.83997, wy = -3287.89990, flag = 1, name = "Westguard Keep, Howling Fjord"},
    [322] = {wx = 7308.04004, wy = -2607.60010, flag = 3, name = "Dun Niffelem, The Storm Peaks"},
    [323] = {wx = 7857.29980, wy = -735.02002, flag = 2, name = "Grom'arsh Crash-Site, The Storm Peaks"},
    [333] = {wx = 8408.08984, wy = 2702.65991, flag = 3, name = "The Shadow Vault, Icecrown"},
    [320] = {wx = 6186.75000, wy = -1052.91003, flag = 3, name = "K3, The Storm Peaks"},
    [321] = {wx = 6667.04004, wy = -258.70001, flag = 1, name = "Frosthold, The Storm Peaks"},
    [335] = {wx = 6402.06006, wy = 467.85999, flag = 3, name = "Crusaders' Pinnacle, Icecrown"},
    [256] = {wx = 3865.87012, wy = 1525.63000, flag = 2, name = "Agmar's Hammer, Dragonblight"},
    [257] = {wx = 2920.29004, wy = 6242.85010, flag = 2, name = "Warsong Hold, Borean Tundra"},
    [259] = {wx = 4474.79004, wy = 5712.12988, flag = 2, name = "Bor'gorok Outpost, Borean Tundra"},
    [260] = {wx = 4946.66992, wy = 1165.93994, flag = 2, name = "Kor'kron Vanguard, Dragonblight"},
    [331] = {wx = 6897.64990, wy = -4118.22998, flag = 7, name = "Gundrak, Zul'Drak"},
    [327] = {wx = 8472.45996, wy = -335.95001, flag = 3, name = "Bouldercrag's Refuge, The Storm Peaks"},
    [226] = {wx = 3575.43994, wy = 6661.64014, flag = 3, name = "Transitus Shield, Coldarra"},
    [325] = {wx = 7427.31982, wy = 4224.16016, flag = 3, name = "Death's Rise, Icecrown"},
    [340] = {wx = 8475.79004, wy = 891.20001, flag = 3, name = "Argent Tournament Grounds, Icecrown"},
    [307] = {wx = 5777.39990, wy = -3594.93994, flag = 3, name = "Zim'Torga, Zul'Drak"},
    [251] = {wx = 4612.20996, wy = 1406.59998, flag = 1, name = "Fordragon Hold, Dragonblight"},
    [246] = {wx = 4127.22998, wy = 5313.06982, flag = 1, name = "Fizzcrank Airstrip, Borean Tundra"},
    [336] = {wx = 5035.64990, wy = -519.96002, flag = 1, name = "Windrunner's Overlook, Crystalsong Forest"},
    [337] = {wx = 5590.49023, wy = -693.22998, flag = 2, name = "Sunreaver's Command, Crystalsong Forest"},
    [254] = {wx = 3242.95996, wy = -666.15997, flag = 2, name = "Venomspite, Dragonblight"},
    [258] = {wx = 3449.51001, wy = 4089.52002, flag = 2, name = "Taunka'le Village, Borean Tundra"},
    [192] = {wx = 2652.88989, wy = -4392.70996, flag = 2, name = "Camp Winterhoof, Howling Fjord"},
    [289] = {wx = 3587.84009, wy = 5973.29980, flag = 3, name = "Amber Ledge, Borean Tundra"},
    [247] = {wx = 3504.12988, wy = 1992.03003, flag = 1, name = "Stars' Rest, Dragonblight"},
  },
  [1669] = {
    [1944] = {wx = 501.29999, wy = 1470.30005, flag = 43, name = "Vindicaar, Krokuun"},
    [1967] = {wx = 1081.13000, wy = 2275.75000, flag = 43, name = "Shattered Fields, Krokuun"},
    [1977] = {wx = 4728.60010, wy = 9862.45996, flag = 43, name = "Vindicaar, Eredath"},
    [1994] = {wx = -2636.08008, wy = 8699.91016, flag = 43, name = "Vindicaar, Antoran Wastes"},
    [1993] = {wx = -2367.06006, wy = 8878.92969, flag = 43, name = "The Veiled Den, Antoran Wastes"},
    [1982] = {wx = 4983.29980, wy = 9823.46973, flag = 43, name = "Triumvirate's End, Eredath"},
    [1976] = {wx = 1437.47998, wy = 1444.27002, flag = 43, name = "Destiny Point, Krokuun"},
    [1988] = {wx = -2934.80005, wy = 8798.42969, flag = 43, name = "Hope's Landing, Antoran Wastes"},
    [1992] = {wx = -3516.09009, wy = 8809.33984, flag = 43, name = "Light's Purchase, Antoran Wastes"},
    [1991] = {wx = 6307.33008, wy = 10116.50000, flag = 43, name = "Prophet's Reflection, Eredath"},
    [1928] = {wx = 985.81897, wy = 1711.89001, flag = 43, name = "Krokul Hovel, Krokuun"},
    [1981] = {wx = 5546.06006, wy = 10563.00000, flag = 43, name = "Shadowguard Incursion, Eredath"},
    [2003] = {wx = 5417.00977, wy = 10013.29980, flag = 43, name = "City Center, Eredath"},
    [1978] = {wx = 5764.89014, wy = 9493.78027, flag = 43, name = "Conservatory of the Arcane, Eredath"},
  },
  [2374] = {
    [2750] = {wx = -3299.95996, wy = 250.34399, flag = 483, name = "Dormant Alcove"},
    [2751] = {wx = -3374.47998, wy = 112.95300, flag = 483, name = "Fulgor Alcove"},
    [2754] = {wx = -3195.03003, wy = 71.72050, flag = 227, name = "Arcae Locus"},
    [2749] = {wx = -3380.93994, wy = 318.84500, flag = 483, name = "Rondure Alcove"},
    [2743] = {wx = -3048.10010, wy = 45.55210, flag = 483, name = "Quartus Locus"},
    [2744] = {wx = -2965.27002, wy = -123.46500, flag = 483, name = "Tertius Locus"},
    [2725] = {wx = -3540.51001, wy = 679.70502, flag = 3, name = "Faith's Repose, Zereth Mortis"},
    [2728] = {wx = -3730.97998, wy = -595.01001, flag = 3, name = "Pilgrim's Grace, Zereth Mortis"},
    [2748] = {wx = -3286.36011, wy = 80.84550, flag = 483, name = "Repertory Alcove"},
    [2736] = {wx = -3834.80005, wy = -751.03302, flag = 35, name = "Sepulcher Overlook, Zereth Mortis"},
    [2734] = {wx = -2489.42993, wy = 99.73260, flag = 35, name = "Antecedent Isle, Zereth Mortis"},
    [2733] = {wx = -2813.66992, wy = 174.40601, flag = 35, name = "Zovaal's Grasp, Zereth Mortis"},
    [2730] = {wx = -3204.39990, wy = 52.59030, flag = 483, name = "Interior Locus"},
    [2724] = {wx = -4212.99023, wy = 684.64801, flag = 3, name = "Haven, Zereth Mortis"},
    [2729] = {wx = -3214.41992, wy = -13.07470, flag = 483, name = "Gravid Repose Locus"},
    [2737] = {wx = -3829.58008, wy = -1170.96997, flag = 35, name = "Sepulcher Of The First Ones, Zereth Mortis"},
    [2738] = {wx = -3101.14990, wy = 26.17190, flag = 483, name = "Ultimus Locus"},
    [2742] = {wx = -3145.44995, wy = -63.94440, flag = 483, name = "Quintus Locus"},
    [2745] = {wx = -2992.46997, wy = 82.24650, flag = 483, name = "Secundus Locus"},
    [2746] = {wx = -2939.62988, wy = 44.51740, flag = 483, name = "Primus Locus"},
    [2747] = {wx = -3311.01001, wy = 36.11810, flag = 483, name = "Camber Alcove"},
  },
}
