RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#subweight 10
#name 0) How to Use & Essential Tips
#displayname |cRXP_WARN_How to Use & Essential Tips|r
#next 1) Prepatch Quests
step
*Welcome to the RestedXP War Within Preparation Guide!
*|cFFFF0000Attention!|r |cRXP_WARN_Please take a moment to read this chapter, as it will greatly assist you in navigating and using the guide effectively.|r
+|cFFFF0000This chapter is click-through. To proceed, simply click on the circle next to the text.|r
step
+|cRXP_WARN_Before starting the guide, it is highly advised to disable any add-ons or WeakAuras, except for RestedXP, that automate quests. This will help prevent accidental turn-ins.|r
step
+|cRXP_WARN_It is highly advised to check if any quest automation add-ons, besides RestedXP, are enabled when logging into any character. This will help prevent accidental turn-ins.|r
step
+|cRXP_WARN_Every quest in this guide scales up to level 80, providing adequate experience regardless of when you turn it in.|r
step
*In this guide, we will accomplish two main tasks: preparing quests in advance of the War Within expansion for fast experience upon its release, and obtaining items to improve leveling speed and quality of life.
+There are a total of 8 chapters in this guide, each serving a different purpose.
step
#completewith Partially Teleported Kobold
*|cRXP_WARN_Chapter 0:|r Prepatch Quests
*Guides you through new pre-patch questlines and stops when you have the ideal quests prepared ready to turn in for optimal experience at launch.
step
*|cRXP_WARN_Chapter 1:|r Miscellaneous Quests
*Guides you through various quests that provide adequate experience at level 70 and above.
+|cRXP_WARN_If you haven't completed any of the quests, you can gain 36% of the experience needed from 70-71 here.|r
step
*|cRXP_WARN_Chapter 2:|r Alterac Valley Quests
*Directs you for a quest to Hillsbrad Foothils and Checks your reputation standing for quest eligibilty
+|cRXP_WARN_If you are exalted and haven't completed any of the quests, you can gain 30% of the experience needed from 70-71 here.|r
step
*|cRXP_WARN_Chapter 3:|r Pet Battle Quests
*Guides you through the entire Pet Battle Campaign for PoP UP-Quests, which can be turned in via the Questlog. Completes Daily Quests for additional experience.
+|cRXP_WARN_If you haven't completed any of the quests, you can gain 110% of the experience needed from 70-71 here.|r
step
*|cRXP_WARN_Chapter 4:|r Heritage Armor Quests
+Highlights useful items for leveling, allowing you to choose which ones to pursue. |cRXP_WARN_Mandatory items will be highlighted.|r
step
*|cRXP_WARN_Chapter 5:|r Item Showcase
+Highlights useful items for leveling, allowing you to choose which ones to pursue. |cRXP_WARN_Mandatory items will be highlighted.|r
step
*|cRXP_WARN_Chapter 6:|r Item Preparation
+Guides you through the acquisition of the items. |cRXP_WARN_Items not supported will be highlighted.|r
step
*|cRXP_WARN_Chapter 7:|r Hearthstone Locations & Mage Teleports
+Guides you through setting up the ideal hearthstone location for the turn-in process during launch based on your current quests. |cRXP_WARN_Additionally includes steps for mages to train their portals if they haven't yet.|r
step
*|cRXP_WARN_Chapter 8:|r Turnin Route
+Follow this guide for the turn-in process during launch, |cRXP_WARN_but only complete it when XP has been unlocked for level 70 on launch day.|r
step
*|cRXP_WARN_Final Chapter:|r Turnin for PoP-UP Quests
*This chapter provides important instructions on the best way to turn in PoP-UP Quests. |cRXP_WARN_This is a hidden guide and it is naturally included in the 70-80 guide.|r, ensuring you turn them in at the perfect time.
+PoP-up quests are quests that can be turned in directly from the quest log.
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 1) Pre Patch Quests
#displayname |cRXP_WARN_Chapter 0 -|r Pre Patch Quests
#next 2) Miscellaneous Quests
step
#sticky
*|cRXP_WARN_Chapter 0:|r Pre Patch Quests
*Guides you through new pre-patch questlines and stops when you have the optimal quests setup ready to turn in for experience at launch.
step
#completewith next
.zone 71 >> Go to Tanaris
step
.isQuestAvailable 83492
.goto 71,52.6,27.19,10,0
.goto 71,52.51,26.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Blue|r |cRXP_WARN_inside the hut|r
.turnin 83492 >>Turn in Warbands: Warbanding Together
.target Blue
step
.isNotOnQuest 83493,83494
.goto 71,52.51,26.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Blue|r |cRXP_WARN_inside the hut|r
.target Blue
.accept 83493 >>Accept Warbands: Rift Reader
.accept 83494 >>Accept Warbands: Space Ghosts by the Coast
step
.isOnQuest 83493,83494
#hidewindow
#completewith Partially Teleported Kobold
#loop
.goto 71,52.05,33.81,20,0
.goto 71,51.33,35.2,20,0
.goto 71,50.76,34.66,20,0
.goto 71,51.34,32.82,20,0
+1
step
.isOnQuest 83493,83494
#completewith next
>>Kill |cRXP_ENEMY_Partially Teleported Kobold, Murloc|r and |cRXP_ENEMY_Trogg.|r Loot them for |cRXP_LOOT_|T463877:0|tSpatial Residue|r
.complete 83494,1 
.mob Partially Teleported Kobold
.mob Partially Teleported Murloc
.mob Partially Teleported Trogg
step
.isOnQuest 83493,83494
>>Click on |cRXP_PICK_Portals|r
.complete 83493,1 
step
.isOnQuest 83493,83494
#label Partially Teleported Kobold
>>Kill |cRXP_ENEMY_Partially Teleported Kobold, Murloc|r and |cRXP_ENEMY_Trogg.|r Loot them for |cRXP_LOOT_|T463877:0|tSpatial Residue|r
.complete 83494,1 
.mob Partially Teleported Kobold
.mob Partially Teleported Murloc
.mob Partially Teleported Trogg
step
.isOnQuest 83493,83494
+|cRXP_WARN_DON'T turn in the quest until the war within launch.|r |cFFFF0000manually skip this step.|r
step
.isNotOnQuest 78713,81930
.goto 13,43.04,73.66
.accept 79009 >>Accept The Harbinger
step << Alliance
.isNotOnQuest 78713,81930
.isOnQuest 79009
.goto 84,62.2,68.58
.zone 627 >>Use |T1444943:0|t[Legion Dalaran Hearthstone] or take the Portal from Stormwind to Dalaran
.use 223988
step << Horde
.isNotOnQuest 78713,81930
.isOnQuest 79009
.goto 85,53.73,76.6
.zone 627 >>Use |T1444943:0|t[Legion Dalaran Hearthstone] or take the Portal from Orgrimmar to Dalaran
.use 223988
step
.isNotOnQuest 78713,81930
.goto 627,49.52,47.68,10,0
.goto 629,39.52,46.11
>>|cRXP_WARN_Follow the Arrow|r
.complete 79009,1 
step
.isNotOnQuest 78713,81930
.goto 629,36.24,48.67
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alleria|r
.complete 79009,2 
.skipgossip
.target Alleria
step
.isNotOnQuest 78713,81930
.goto 629,28.47,37.01
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
.turnin 79009 >>Turn in The Harbinger
.target Archmage Khadgar
step
.isNotOnQuest 78713,81930
.goto 629,31.44,41.69
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alleria Windrunner|r
.accept 79010 >>Accept Door to the Ren'dorei
.target Alleria Windrunner
step
.isNotOnQuest 78713,81930
.goto 629,39.81,53.26,10,0
.goto 629,41.16,64.94,10,0
.goto 629,33.8,78.8
>>|cRXP_WARN_Follow the Arrow|r
.complete 79010,1 
step
.isNotOnQuest 78713,81930
.goto 629,33.79,78.68
>>Click on |cRXP_PICK_Void Rift.|r
.complete 79010,2 
step
.isNotOnQuest 78713,81930
.goto 971,27.25,27.88
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alleria Windrunner|r
.turnin 79010 >>Turn in Door to the Ren'dorei
.target Alleria Windrunner
step
.isNotOnQuest 78713,81930
.goto 971,27.22,27.69
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Magister Umbric|r
.accept 79011 >>Accept Riftwalker Reports
.target Magister Umbric
.accept 79012 >>Accept Cracks in the Void
step
.isNotOnQuest 78713,81930
.isOnQuest 79012
.goto 971,27.89,28.61
.vehicle >>Click on the |cRXP_PICK_Void Rift|r
.timer 7, RP
step
.isNotOnQuest 78713,81930
.isOnQuest 79012
.goto 971,29.53,41.22
.cast 430692 >>Click on the |cRXP_PICK_Unstable Void Rift.|r
step
.isNotOnQuest 78713,81930
.goto 971,30.09,43.38
>>Run away from the |cRXP_FRIENDLY_Unstable Void Rift.|r
.complete 79012,1,1
step
.isNotOnQuest 78713,81930
.goto 971,30.09,43.37
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Riftwalker Dellyn|r
.complete 79011,1 
.skipgossip
.target Riftwalker Dellyn
step
.isNotOnQuest 78713,81930
.isOnQuest 79012
.goto 971,30.09,44.23
.vehicle >>Click on the |cRXP_PICK_Void Rift|r
.timer 10, RP
step
.isNotOnQuest 78713,81930
.isOnQuest 79012
.goto 971,37.83,50
.cast 430692 >>Click on the |cRXP_PICK_Unstable Void Rift.|r
step
.isNotOnQuest 78713,81930
.goto 971,37.72,51.72
>>Run away from the |cRXP_FRIENDLY_Unstable Void Rift.|r
.complete 79012,1,2
step
.isNotOnQuest 78713,81930
.goto 971,37.72,51.71
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Riftwalker Soran|r
.complete 79011,2 
.skipgossip
.target Riftwalker Soran
step
.isNotOnQuest 78713,81930
.isOnQuest 79012
.goto 971,38.41,52.95
.cast 430692 >>Click on the |cRXP_PICK_Unstable Void Rift.|r
step
.isNotOnQuest 78713,81930
.goto 971,39.93,53.73
>>Run away from the |cRXP_FRIENDLY_Unstable Void Rift.|r
.complete 79012,1,3
step
.isNotOnQuest 78713,81930
.goto 971,39.92,53.72
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Riftwalker Orlis|r
.complete 79011,3 
.skipgossip
.target Riftwalker Orlis
step
.isNotOnQuest 78713,81930
.isOnQuest 79012
.goto 971,40.75,57.25
.cast 430692 >>Click on the |cRXP_PICK_Unstable Void Rift.|r
step
.isNotOnQuest 78713,81930
.isOnQuest 79012
.goto 971,42.01,59.92
>>Run away from the |cRXP_FRIENDLY_Unstable Void Rift.|r
.complete 79012,1,4
step
.isNotOnQuest 78713,81930
.isOnQuest 79012
.goto 971,42.01,59.92
.cast 430692 >>Click on the |cRXP_PICK_Unstable Void Rift.|r
step
.isNotOnQuest 78713,81930
.goto 971,40.86,60.87
>>Run away from the |cRXP_FRIENDLY_Unstable Void Rift.|r
.complete 79012,1,5
step
.isNotOnQuest 78713,81930
.goto 971,40.87,60.85
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Magister Umbric|r
.turnin 79011 >>Turn in Riftwalker Reports
.target Magister Umbric
.turnin 79012 >>Turn in Cracks in the Void
step
.isNotOnQuest 78713,81930
.goto 971,40.67,60.85
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alleria Windrunner|r
.accept 79013 >>Accept Galakrond's Unrest
.target Alleria Windrunner
step
.isNotOnQuest 78713,81930
.goto 971,39.67,60.61
>>Click on the |cRXP_PICK_Telogrus Rift.|r
.complete 79013,1 
step
.isNotOnQuest 78713,81930
.goto 115,56.68,39.00
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alleria Windrunner|r
.turnin 79013 >>Turn in Galakrond's Unrest
.target Alleria Windrunner
.accept 79014 >>Accept Walk a Mile in Her Shadows
step
.isNotOnQuest 78713,81930
.isOnQuest 79014
.goto 115,55.97,37.56,10 >>Follow the Arrow
.timer 8,RP
step
.isNotOnQuest 78713,81930
.goto 115,55.97,37.56
>>|cRXP_WARN_Wait for the RP.|r Use your [ExtraActionButton] |cRXP_WARN_afterwards.|r
.complete 79014,1 
step
.isNotOnQuest 78713,81930
.goto 115,55.69,35.17
>>Use your [ExtraActionButton] near the Rift.
*Kill the spawning enemies.
.complete 79014,2,1 
.mob Cosmic Ooze
step
.isNotOnQuest 78713,81930
.goto 115,56.22,35.35
>>Use your [ExtraActionButton] near the Rift.
*Kill the spawning enemies.
.complete 79014,2,2 
.mob Cosmic Ooze
step
.isNotOnQuest 78713,81930
.goto 115,56.73,34.81
>>Use your [ExtraActionButton] near the Rift.
*Kill the spawning enemies.
.complete 79014,2,3 
.mob Cosmic Ooze
step
.isNotOnQuest 78713,81930
.goto 115,57.5,35.21
>>Use your [ExtraActionButton] near the Rift.
*Kill the spawning enemies.
.complete 79014,2,4 
.mob Cosmic Ooze
step
.isNotOnQuest 78713,81930
.isOnQuest 79014
.cast 48933 >>|T135778:0|t[Wormhole Generator: Northend] to Storm Peaks
.itemcount 48933,1
step
.isNotOnQuest 78713,81930
.goto 120,41.50,22.71
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alleria Windrunner|r
.turnin 79014 >>Turn in Walk a Mile in Her Shadows
.target Alleria Windrunner
.accept 79015 >>Accept Dark Descension
step
.isNotOnQuest 78713,81930
.goto 120,41.53,21.32
>>Kill |cRXP_ENEMY_Riftwalker Nilara|r
.complete 79015,1 
.mob Shadowguard Ethereal
.mob Riftwalker Nilara
step
.isNotOnQuest 78713,81930
.goto 120,41.49,21.33
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alleria Windrunner|r
.turnin 79015 >>Turn in Dark Descension
.target Alleria Windrunner
.accept 79016 >>Accept Legacy of the Void
step
.isNotOnQuest 78713,81930
.goto 120,41.54,20.25
>>Click on the |cRXP_PICK_Portal.|r
.complete 79016,1 
step
.isNotOnQuest 78713,81930
.goto 882,22.52,53.45
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alleria Windrunner|r
.turnin 79016 >>Turn in Legacy of the Void
.target Alleria Windrunner
.accept 79017 >>Accept The Path Taken
step
.isNotOnQuest 78713,81930
.goto 882,21.03,52.5
>>Kill |cRXP_ENEMY_Eradication|r and his minions.
.complete 79017,2,1 
.mob Eradication
.mob Legion Hound
.mob Legion Felguard
step
.isNotOnQuest 78713,81930
.goto 882,21.02,50.58
>>Use your [ExtraActionButton] near |cRXP_FRIENDLY_Arator|r
.complete 79017,1,1 
.target Arator
step
.isNotOnQuest 78713,81930
.goto 882,21.88,48.27
>>Kill |cRXP_ENEMY_Amani Shadowspeaker,|r |cRXP_ENEMY_Amani Berserker|r and |cRXP_ENEMY_Amani Cavalry.|r
.complete 79017,2,2 
.mob Amani Shadowspeaker
.mob Amani Berserker
.mob Amani Cavalry
step
.isNotOnQuest 78713,81930
.goto 882,23.17,50.09
>>Use your [ExtraActionButton] near |cRXP_FRIENDLY_Alleria|r
.complete 79017,1,2 
.target Alleria
step
.isNotOnQuest 78713,81930
.goto 882,24.9,51.84
>>Use your [ExtraActionButton] near |cRXP_FRIENDLY_L'ura|r
.complete 79017,1,3 
.target L'ura
step
.isNotOnQuest 78713,81930
.goto 882,24.68,48.98
>>Kill |cRXP_ENEMY_Fist of Doomhammer|r
.complete 79017,2,3 
.mob Fist of Doomhammer
step
.isNotOnQuest 78713,81930
.goto 882,24.61,49.14
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alleria Windrunner|r
.turnin 79017 >>Turn in The Path Taken
.target Alleria Windrunner
.accept 79018 >>Accept And Be One Traveler, Long I Stood
step
.isNotOnQuest 78713,81930
.isOnQuest 79018
.goto 882,23.52,46.83,10,0
.goto 882,24.23,43,10 >> Follow the Arrow
.timer 43,RP
step
.isNotOnQuest 78713,81930
.goto 882,24.22,43.00
>>Wait for the RP.
.complete 79018,1 
step
.isNotOnQuest 78713,81930
.goto 882,24.23,42.73
>>Click on the |cRXP_PICK_Portal.|r
.complete 79018,2 
step
.isNotOnQuest 78713,81930
.goto 971,28.64,23.98
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alleria Windrunner|r
.turnin 79018 >>Turn in And Be One Traveler, Long I Stood
.target Alleria Windrunner
.accept 79019 >>Accept Defend Telogrus Rift
step
.isNotOnQuest 78713,81930
#loop
.goto 971,28.49,20.59,20,0
.goto 971,25.96,24.6,20,0
.goto 971,25,27.95,20,0
.goto 971,27.93,28.66,20,0
.goto 971,29.98,25.54,20,0
>>Interact with |cRXP_FRIENDLY_Trapped Void Elves|r
*Click on |cRXP_PICK_Unstable Rifts|r and pull them away from you.
*Kill |cRXP_ENEMY_Zan'do|r and |cRXP_ENEMY_Shadowguards.|r
.complete 79019,1
.mob Shadowguard Phaseblade
.mob Shadowguard Adept
.mob Zan'do
.mob Cosmic Ooze
.target Trapped Void Elf
step
.isNotOnQuest 78713,81930
.isOnQuest 79019
.goto 971,27.9,28.61
.vehicle >> Click on the |cRXP_PICK_Portal|r
step
.isNotOnQuest 78713,81930
.isOnQuest 79019
.goto 971,30.05,44.14
.vehicle >> Click on the |cRXP_PICK_Portal|r
step
.isNotOnQuest 78713,81930
.goto 971,43.55,63.79
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alleria Windrunner|r
.turnin 79019 >>Turn in Defend Telogrus Rift
.target Alleria Windrunner
.accept 79020 >>Accept Null and Void
step
.isNotOnQuest 78713,81930
.goto 971,43.95,63.75
>>Click on the |cRXP_PICK_Portal|r
.complete 79020,1 
step
.isNotOnQuest 78713,81930
.goto 971,49.52,76.07
>>Kill |cRXP_ENEMY_Corrupted Memory of Turalyon|r
.complete 79020,2 
.mob Corrupted Memory of Turalyon
step
.isNotOnQuest 78713,81930
.goto 971,50.19,75.23
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alleria Windrunner|r
.turnin 79020 >>Turn in Null and Void
.target Alleria Windrunner
step
.isNotOnQuest 78713,81930
.goto 971,50.39,75.30
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Locus-Walker|r
.accept 79021 >>Accept Radiant Warnings
.target Locus-Walker
.complete 79021,1 
step
.isNotOnQuest 78713,81930
.isOnQuest 79021
.goto 971,52.21,67.59
.deathskip >>Jump off the cliff ingame.
step
.isNotOnQuest 78713,81930
.isOnQuest 79021
.goto 971,25.01,27.86
.zone 629 >> Take the Portal to Dalaran
step
.isNotOnQuest 78713,81930
.goto 629,52.68,37.92,10,0
.goto 629,36.86,47.2,10,0
.goto 629,32.34,41.69
>>|cRXP_WARN_Follow the Arrow|r
.complete 79021,2 
step
.isNotOnQuest 78713,81930
.goto 629,28.38,36.96
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
.turnin 79021 >>Turn in Radiant Warnings
.target Archmage Khadgar
step
.isNotOnQuest 78713,81930
.isQuestAvailable 78713 << Horde
.isQuestAvailable 81930 << Alliance
.logout >>Log out and log back in to receive the quest "The War Within."
step
#label IsleOfDornA
>>This quests should automatically appear in your quest log
.accept 78713 >>Accept in The War Within << Horde
.accept 81930 >>Accept in The War Within << Alliance
step
.isOnQuest 78713,81930
>>Use the |T4549141:0|t[Teleportation Scroll] to get to Silithus
.use 227669
.complete 78713,1 << Horde 
.complete 81930,1 << Alliance 
step << Horde
.goto 81,41.96,45.06
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thrall|r
.turnin 78713 >>Turn in The War Within
.accept 78714 >>Accept Oh, THAT Sword
.target Thrall
step << Alliance
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Jaina Proudmoore|r and |cRXP_FRIENDLY_Thrall|r
.turnin 81930 >>Turn in The War Within
.goto 81,41.93,45.11
.target +Lady Jaina Proudmoore
.accept 78714 >>Accept Oh, THAT Sword
.goto 81,41.96,45.06
.target +Thrall
step
>>Click on the |cRXP_PICK_Titan Translocator|r
.goto 81,43.19,44.50
.complete 78714,1 
step
.goto 2321,50.08,64.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Magni Bronzebeard|r
.turnin 78714 >>Turn in Oh, THAT Sword
.accept 78715 >>Accept Azeroth's Voice
.target Magni Bronzebeard
step
#completewith ActivateChamberofHeart
#hidewindow
#loop
.goto 2321,56.48,64.70,7,0
.goto 2321,50.20,74.08,7,0
.goto 2321,43.82,64.62,7,0
+1
step
#sticky
#label ActivateChamberofHeart
>>Activate the 3 |cRXP_PICK_Chamber Consoles|r
.goto 2321,50.08,64.81,0,0
.complete 78715,1 
step
#completewith ActivateChamberofHeart
#label ChamberConsoleA
.goto 2321,56.52,64.74,0
.goto 2321,56.48,64.70,0
.goto 2321,43.92,64.59,0
.cast 444901 >> Click on the |cRXP_PICK_Chamber Consoles|r
step
#requires ChamberConsoleA
#completewith ActivateChamberofHeart
#label ChamberConsoleB
.goto 2321,56.52,64.74,0
.goto 2321,56.48,64.70,0
.goto 2321,43.92,64.59,0
.cast 444901 >> Click on the |cRXP_PICK_Chamber Consoles|r
step
#requires ChamberConsoleB
#completewith ActivateChamberofHeart
.goto 2321,56.52,64.74,0
.goto 2321,56.48,64.70,0
.goto 2321,43.92,64.59,0
.cast 444901 >> Click on the |cRXP_PICK_Chamber Consoles|r
step
#requires ActivateChamberofHeart
.goto 2321,50.15,65.25
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Magni to begin the ritual|r
.skipgossip 213624,1
.complete 78715,2 
.target Magni to begin the ritual
step
.goto 2321,49.54,58.73
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Jaina Proudmoore|r
.turnin 78715 >>Turn in Azeroth's Voice
.accept 78716 >>Accept Painful Lessons
.target Lady Jaina Proudmoore
step
>>Click on the |cRXP_PICK_Portal to Dalaran|r
.goto 2321,53.32,58.15
.complete 78716,1 
step
.goto 619,45.85,64.51
.complete 78716,2 
step
.goto 629,42.96,60.01
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
.turnin 78716 >>Turn in Painful Lessons
.target Archmage Khadgar
step
.goto 629,40.43,54.16
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Moira Thaurissan|r
.accept 80500 >>Accept The Bronzebeard Family
.target Moira Thaurissan
step
#completewith TalkToBrann
#label TeleporterUsedA
.goto 629,64.84,20.84,1 >>Use the teleporter
step
#requires TeleporterUsedA
#completewith TalkToBrann
.goto 627,52.09,56.93,3 >>Enter the Dalaran Visitor Center
step
#label TalkToBrann
.goto 627,50.77,55.57
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brann|r
.skipgossip 214669,1
.complete 80500,1 
.target Brann
step
#completewith next
.goto 627,54.39,53.78,15,0
.goto 627,49.20,47.77,1 >>Use the teleporter
step
.isQuestComplete 80500
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [The Bronzebeard Family] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
.achievement 19030,1 >> If you want to min-max to its fullest extent, there is one additional quest that unlocks when purchasing the War Within Epic Edition.
*|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
.achievementComplete 19030,1
#completewith Flash
.zone 2112 >> Go to Valdrakken
step
#completewith next
.cast 420759 >> Summon Squally
step
.achievementComplete 19030,1
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Squally|r |cRXP_WARN_next to you|r
.accept 82809 >>Accept Gryphons of a Feather
.target Squally
.use 4266
step
.achievementComplete 19030,1
.goto 2112,38.34,94.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kurdran Wildhammer|r
.complete 82809,1 
.skipgossip 222277,1
.target Kurdran Wildhammer
step
.achievementComplete 19030,1
.goto 2025,49.30,80.25
>>Interact with |cRXP_FRIENDLY_Thundo|r
.complete 82809,4 
.target Thundo
.mob Stormshroud Defender
step
.achievementComplete 19030,1
.goto 2023,58.37,31.41
>>Interact with |cRXP_FRIENDLY_Gale|r |cRXP_WARN_approach him from behind|r
.complete 82809,3 
.target Gale
step
.achievementComplete 19030,1
#label Flash
.goto 2022,71.17,25.68
>>Interact with |cRXP_FRIENDLY_Flash|r
.complete 82809,2 
.target Flash
step
.isQuestComplete 82809
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Gryphons of a Feather] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 2) Miscellaneous Quests
#displayname |cRXP_WARN_Chapter 1 -|r Miscellaneous Quests
#next 3) Alterac Valley Quests
step
#sticky
*|cRXP_WARN_Chapter 1:|r Miscellaneous Quests
*Guides you through various quests that provide adequate experience at level 70 and above.
+|cRXP_WARN_If you haven't completed any of the quests, you can gain 36% of the experience needed from 70-71 here.|r
step << Monk
.isQuestAvailable 31834
.zoneskip 379
.cast 126892 >>Use Zen Pilgrimage
step << Monk
.isOnQuest 31834
.goto 379,48.60,42.74
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Hight|r
.accept 31834 >>Accept Begin Your Training: Master Cheng
.target Master Hight
step << Monk
.isOnQuest 31834
#completewith next
.goto 379,48.12,43.3,10 >>Leave the Temple
step << Monk
.isOnQuest 31834
.goto 379,47.06,40.15
.gossipoption 41015 >>Talk to |cRXP_FRIENDLY_Master Cheng|r
.timer 29,RP
.target Master Cheng
step << Monk
.isOnQuest 31834
>>|cRXP_WARN_Follow the Arrow.|r When |cRXP_FRIENDLY_Master Cheng|r stops moving, retarget him to bow, then defeat him in a duel.
.emote BOW,66138
.goto 379,48.12,40.35
.complete 31834,1 
.target Master Cheng
.mob Master Cheng
step << Monk
.isQuestComplete 31834
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Begin Your Training: Master Cheng] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step << Horde
#sticky
.zone 85 >> Go to Orgrimmar
step << Alliance
#sticky
.zone 84 >> Go to Stormwind
step
.isQuestAvailable 38934
#completewith Silas
#label ZoneA
#dmf
.goto 84,61.12,70.62,-1 << Alliance
.goto 84,60.21,32.17,-1 << Alliance
.goto 85,53.92,73.12,-1 << Horde
.goto 85,66.53,36.32,-1 << Horde
#dmf
>>Buy |T237302:0|t[Darkmoon Daggermaw] from the Auction House
.collect 124669,100 
step
.isQuestAvailable 38934
#completewith Silas
#dmf
.goto 84,62.26,72.95,-1 << Alliance
.goto 84,62.11,32.18,-1 << Alliance
.goto 85,48.24,62.16 << Horde
.zone 37 >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Darkmoon Faire Mystic Mage|r << Alliance
.zone 7 >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Darkmoon Faire Mystic Mage|r << Horde
*|cRXP_WARN_Select "Take me to the faire staging area"|r and |cRXP_WARN_accept the prompt.|r
.skipgossip
.target Darkmoon Faire Mystic Mage
step
.isQuestAvailable 38934
#completewith Silas
#dmf
.goto 7,36.85,35.86 << Horde
.goto 37,41.8,69.5 << Alliance
.zone 407 >>Click on the |cRXP_PICK_Darkmoon Faire Portal|r
step
.isQuestAvailable 38934
#label Silas
#dmf
.goto 407,55.45,52.66,20,0
.goto 407,52.51,88.76
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Galissa Sundew|
.accept 38934 >>Accept Silas' Secret Stash
.buy 126930
.target Galissa Sundew
step
.isQuestAvailable 38934
#dmf
#completewith Stash
>>|cRXP_WARN_Any addon or weakaura excluding restedxp that automates quests should be turned off before continuing|r
step
.isQuestAvailable 38934
#dmf
.goto 407,41.96,91.11
>>Click on the |cRXP_PICK_Bag|r |cRXP_WARN_in the tent.|r
.complete 38934,1 
step
.isQuestAvailable 38934
#dmf
.goto 407,53.25,60.65
>>Click on the |cRXP_PICK_Suspicious Mound|r |cRXP_WARN_in the sand.|r
.complete 38934,2 
step
.isQuestAvailable 38934
#dmf
.goto 407,52.56,84.84
>>Click on the |cRXP_PICK_Note|r |cRXP_WARN_near Careless Carnie|r
.complete 38934,3 
.target Careless Carnie
step
.isQuestAvailable 38934
#completewith Fourth clue
#dmf
.goto 407,50.56,90.69
.zone 37 >>Click on the |cRXP_PICK_Darkmoon Faire Portal|r << Alliance
.zone 7 >>Click on the |cRXP_PICK_Darkmoon Faire Portal|r << Horde
step
.isQuestAvailable 38934
#completewith Fourth clue
#dmf
.goto 7,36.85,35.86 << Horde
.goto 37,41.8,69.5 << Alliance
.zone 407 >>Click on the |cRXP_PICK_Darkmoon Faire Portal|r
step
.isQuestAvailable 38934
#label Fourth clue
#dmf
.goto 407,52.03,30.36
>>|cRXP_WARN_Go back through the |cRXP_PICK_Darkmoon Faire Portal|r|r. Click on the |cRXP_PICK_Dirt|r |cRXP_WARN_near a banner|r
.complete 38934,4 
step
.isOnQuest 38934
*|cRXP_WARN_|cRXP_WARN_DISABLE ANY QUEST AUTOMATION ADDON EXCEPT RXP BEFORE PROCEEDING:|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
.isQuestAvailable 38934
#dmf
.goto 407,21.52,29.06
>>Click on the |cRXP_PICK_Treasure Chest|r |cRXP_WARN_on the ocean floor|r
.complete 38934,5 
step
#label Stash
.isQuestComplete 38934
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [SILAS SECRET STASH] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
*|cRXP_WARN_VERIFY that you have disabled any quest automation addons except RXP.|r
*Click on the quest pop-up and click the "x" at the top right of the window to close it. Then, proceed to untrack the quest in your quest log.
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
#dmf
.zoneskip 407
.goto 84,62.26,72.95,-1 << Alliance
.goto 84,62.11,32.18,-1 << Alliance
.goto 85,48.24,62.16 << Horde
.zone 37 >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Darkmoon Faire Mystic Mage|r << Alliance
.zone 7 >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Darkmoon Faire Mystic Mage|r << Horde
*|cRXP_WARN_Select "Take me to the faire staging area"|r and |cRXP_WARN_accept the prompt.|r
.skipgossip
.target Darkmoon Faire Mystic Mage
step
#dmf
.isQuestAvailable 37819
.zoneskip 407
.goto 7,36.85,35.86 << Horde
.goto 37,41.8,69.5 << Alliance
.zone 407 >>Click on the |cRXP_PICK_Darkmoon Faire Portal|r
step
#dmf
.isQuestAvailable 37819
.goto 407,54.35,53.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zina Sharpworth|r
.collect 78910,2
.buy 78910,2
.target Zina Sharpworth
step
#dmf
.isQuestAvailable 37819
.goto 407,48.97,88.32
>>Open |T133645:0|t[Sack o' Tokens] in your Bag
.collect 71083,40
.use 78910
step
#dmf
.isQuestAvailable 37819
.goto 407,48.97,88.32
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Malle Earnhard|r
.accept 37819 >>Accept Welcome to the Darkmoon Races
.target Malle Earnhard
step
#dmf
.isOnQuest 37819
.goto 407,47.83,88.20
*|cRXP_WARN_|cRXP_WARN_DISABLE ANY QUEST AUTOMATION ADDON EXCEPT RXP BEFORE PROCEEDING:|r
>>|cRXP_WARN_Follow the Arrow|r
.complete 37819,1 
step
#dmf
.isOnQuest 37819
.goto 407,27.13,67.05
>>|cRXP_WARN_Follow the Arrow|r and use|T413579:0|t[Jump to Banner]|cRXP_WARN_(1)|r to jump to banners in front of you and run into items on the ground for the following effects:
*|cRXP_WARN_Boots:|r Grants Water Walking and a significant movement speed buff
*|cRXP_WARN_Spring:|r Provides a forward lift in the air
*|cRXP_WARN_Wormhole:|r Teleports you forward
*|cRXP_WARN_Additionally:|r Whenever you run through a banner or are near a banner, you will gain a minor speed buff incl. waterwalking.
.complete 37819,2 
step
#dmf
.isOnQuest 37819
.goto 407,46.69,88.29
>>|cRXP_WARN_Follow the Arrow|r and use |T413579:0|t[Jump to Banner]|cRXP_WARN_(1)|r to jump to banners in front of you and run into items on the ground for the following effects:
*|cRXP_WARN_Boots:|r Grants Water Walking and a significant movement speed buff
*|cRXP_WARN_Spring:|r Provides a forward lift in the air
*|cRXP_WARN_Wormhole:|r Teleports you forward
*|cRXP_WARN_Additionally:|r Whenever you run through a banner or are near a banner, you will gain a minor speed buff incl. waterwalking.
.complete 37819,3 
step
#dmf
.isQuestComplete 37819
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Welcome to the Darkmoon Races] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
*|cRXP_WARN_VERIFY that you have disabled any quest automation addons except RXP.|r
*Click on the quest pop-up and click the "x" at the top right of the window to close it. Then, proceed to untrack the quest in your quest log.
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step << Horde
.goto 85,66.44,41.9
.train 7620 >>Talk to |cRXP_FRIENDLY_Lumak|r in Orgrimmar and learn Fishing
.target Lumak
step << Alliance
.goto 84,54.8,69.59
.train 7620 >>Talk to |cRXP_FRIENDLY_Arnold Leland|r in Stormwind and learn Fishing
.target Arnold Leland
step << Alliance
.goto 84,55.04,69.71
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Catherine Leland|r in Stormwind
.daily 26414,26420,26442,26488,26536 >> Accept Fishing Daily
.target Catherine Leland
step << Horde
.goto 85,65.67,41.09
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Razgar|r in Orgrimmar
.daily 26543,26556,26557,26588,26572 >> Accept Fishing Daily
.target Razgar
step << Alliance
.isOnQuest 26442
#loop
.goto 84,22.18,51.9,30,0
.goto 84,19.65,37.27,30,0
.goto 84,20.28,19.37,30,0
>>Click on |cRXP_PICK_Stormwind Lobster Traps|r
.complete 26442,1 
step << Alliance
.isOnQuest 26420
#loop
.goto 84,59.08,20.7,10,0
.goto 84,58.08,10.54,30,0
.goto 84,60.52,6.94,30,0
.goto 84,63.47,5.75,30,0
.goto 84,64.97,8.75,30,0
.goto 84,63.88,16.66,30,0
>>Click on |cRXP_PICK_Dirt Mound|r for |cRXP_LOOT_|T236553:0|tOvergrown Earthworm|r
.collect 58788,1
step << Alliance
.isOnQuest 26420
#completewith next
.cast 80534 >> Use |T236553:0|t[Overgrown Earthworm]
.use 58788
step << Alliance
.isOnQuest 26420
>>Use |T4620674:0|t[Fishing] near the water and click on the |cRXP_PICK_Fishing Bobber|r when it bobs to catch a |T3495040|t[Crystal Bass] |cRXP_WARN_might have to do it multiple times.|r
.aura -80534
.complete 26420,1 
.usespell 131474
step << Alliance
.isOnQuest 26536
.goto 37,24.98,59.13
>>Fish Up |T133907:0|t[Violet Perches] |cRXP_WARN_you'll start catching them at skill 15|r
.complete 26536,1 
.usespell 131474
step << Alliance
.isOnQuest 26414
.goto 84,53.44,39.14
>>Fish Up |T349503:0|t[Hardened Walleye's]
.complete 26414,1 
.usespell 131474
step << Alliance
.isOnQuest 26488
.goto 84,75.61,83.43
>>Fish Up |T348532:0|t[Royal Monkfishes] and use them to get |T349503:0|t[Precious Locket]
.complete 26488,1 
.usespell 131474
step << Alliance
.isOnQuest 26414,26420,26442,26488,26536
*|cRXP_WARN_DO NOT TURN IN THE|r [FISHING DAILY] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step << Horde
.isOnQuest 26572
#hidewindow
#completewith Golden Stonefish
#loop
.goto 1,43.68,24.05,20,0
.goto 1,43.54,24.87,20,0
.goto 1,42.42,24.2,20,0
.goto 1,41.93,23.96,20,0
.goto 1,41.64,25.14,20,0
.goto 1,41.21,24.55,20,0
.goto 1,40.58,24.2,20,0
.goto 1,39.58,23.65,20,0
.goto 1,39.49,24.95,20,0
.goto 1,38.97,25.12,20,0
+1
step << Horde
.isOnQuest 26572
#completewith next
>>Interact with a dead |cRXP_FRIENDLY_Drowned Thunder Lizard|r to obtain |T133721:0|t[Drowned Thunder Lizard Tail] |cRXP_WARN_they periodically cast lighting discharge, be careful.|r
.collect 58958,1
.target Drowned Thunder Lizard
.use 58955
step << Horde
.isOnQuest 26572
#label Golden Stonefish
>>Use |T133721:0|t[Drowned Thunder Lizard Tail] near |cRXP_ENEMY_Golden Stonefish|r to kill them. Loot them for |cRXP_LOOT_Golden Stonefish|r
.complete 26572,1 
.use 58958
.mob Golden Stonefish
step << Horde
.isOnQuest 26556
#loop
.goto 85,33.41,70.72,10,0
.goto 85,35.59,74.79,10,0
>>Fish up [Toxic Puddlefish]
.complete 26556,1 
.usespell 131474
step << Horde
.isOnQuest 26557
.goto 76,25.29,74.79,30,0
.goto 76,27.98,73.94,30,0
.goto 76,29.15,75.48,30,0
>>Kill |cRXP_ENEMY_Weakened Mosshoof Stag|r
.collect 58949,1
.mob Weakened Mosshoof Stag
step << Horde
.isOnQuest 26557
.aura -80868
.goto 85,45.51,47.61
>>Fish Up [Sandy Carp]
.complete 26557,1 
.use 58949
.usespell 131474
step << Horde
.isOnQuest 26543
.goto 1,56.91,6.73,25,0
.goto 1,59.5,7.2,25,0
.goto 1,59.75,8.91,25,0
.goto 1,59.22,10.75,25,0
.goto 1,59.3,12.77,25,0
.goto 1,59.01,14.06,25,0
.goto 1,58.06,13.46,25,0
.goto 1,57.36,12.17,25,0
>>Click on the|cRXP_PICK_Clams|r |cRXP_WARN_ocean floor|r
.complete 26543,1 
step << Horde
.isOnQuest 26588
.goto 1,36.88,10.51
>>Fish until you get the |T396545:0|t[|cRXP_LOOT_Giant Furious Pike|r]
.complete 26588,1 
step << Horde
.isOnQuest 26543,26556,26557,26588,26572
*|cRXP_WARN_DO NOT TURN IN THE|r [FISHING DAILY] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step << Horde
.goto 85,56.54,62.49
.train 2550 >>Talk to |cRXP_FRIENDLY_Marogg|r in Orgrimmar
.target Marogg
step << Alliance
.goto 84,50.67,73.81
.train 2550 >>Talk to |cRXP_FRIENDLY_Robby Flay|r in Stormwind
.target Robby Flay
step << Alliance
.goto 84,50.66,73.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Robby Flay|r
.daily 26153,26183,26190,26177,26192 >> Accept the Fishing Daily
.target Robby Flay
step << Horde
.goto 85,56.54,62.49
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marogg|r
.daily 26227,26226,26235,26220,26233,26234 >> Accept the Cooking Daily
.target Marogg
step << Alliance
.isOnQuest 26153
#loop
.goto 84,55.71,10.8,15,0
.goto 84,55.05,7.96,15,0
.goto 84,53.37,6.56,15,0
.goto 84,54.99,5.09,15,0
.goto 84,57.15,8.49,15,0
>>Click on |cRXP_PICK_Stormwind Pumpkins|r
.complete 26153,1 
step << Alliance
.isOnQuest 26192
#completewith 4/4 Confectioners' Sugar
>>Obtain |T134059:0|t[Confectioners' Sugar] by collecting sacks from the ground and purchasing them from vendors.
.complete 26192,1 
step << Alliance
.isOnQuest 26192
.goto 84,48.37,69.26
.vendor >>Talk to |cRXP_FRIENDLY_Lisa McKeever|r and purchase all available |T134059:0|t[Confectioners' Sugar] |cRXP_WARN_(limited quantity).|r
.buy 57246,2
.target Lisa McKeever
step << Alliance
.isOnQuest 26192
.goto 84,64.83,72.17
.vendor >> Talk to |cRXP_FRIENDLY_Thurman Mullby|r inside the house and purchase all available |T134059:0|t[Confectioners' Sugar] |cRXP_WARN_(limited quantity).|r
.buy 57246,2
.target Thurman Mullby
step << Alliance
.isOnQuest 26192
.goto 84,75.11,55.32,10,0
.goto 84,76.22,53.55,8,0
.goto 84,76.9,53.55,5,0
.goto 84,77.64,53.05
.vendor >> Talk to |cRXP_FRIENDLY_Erika Tate|r inside the house and purchase all available |T134059:0|t[Confectioners' Sugar] |cRXP_WARN_(limited quantity).|r
.buy 57246,2
.target Erika Tate
step << Alliance
.isOnQuest 26192
.goto 84,75.06,55.37,10,0
.goto 84,64.17,32.72,10,0
.goto 84,65.86,31.3
.vendor >>Talk to |cRXP_FRIENDLY_Colin Field|r inside the house and purchase all available |T134059:0|t[Confectioners' Sugar] |cRXP_WARN_(limited quantity).|r
.buy 57246,2
.target Colin Field
step << Alliance
.isOnQuest 26192
#label 4/4 Confectioners' Sugar
.goto 84,50.53,90.42,50
.goto 84,50.34,91.32,5,0
.goto 84,51.12,93.93,8,0
.goto 84,51.12,95.55
.vendor >>Talk to |cRXP_FRIENDLY_Connor Rivers|r inside the house and purchase all available |T134059:0|t[Confectioners' Sugar] |cRXP_WARN_(limited quantity).|r
.buy 57246,2
.target Connor Rivers
step << Alliance
.isOnQuest 26192
#loop
.goto 84,48.37,69.26,10,0
.goto 84,64.83,72.17,10,0
.goto 84,77.64,53.05,10,0
.goto 84,65.86,31.3,10,0
.goto 84,51.12,95.55,10,0
>>Repeat the loop until completion
.complete 26192,1 
step << Alliance
.isOnQuest 26183
.goto 84,49.98,78.84,25,0
.goto 84,51.75,81.52,25,0
.goto 84,48.83,83.31,25,0
.goto 84,44.01,74.92,25,0
.goto 84,55.08,74.17,25,0
.goto 84,54.15,63.66,25,0
.goto 84,60.07,58.81,25,0
.goto 84,57.26,56.26,25,0
.goto 84,49.3,50.98,25,0
.goto 84,58.41,43.36,25,0
.goto 84,62.11,34.93,25,0
.goto 84,66.84,51.58,25,0
.goto 84,72.61,55.74,25,0
.goto 84,76.2,62.06,25,0
.goto 84,72.49,67.89,25,0
.goto 84,65.45,62.26,25,0
>>Click on |cRXP_PICK_Apples|r laying around |cRXP_WARN_apple trees|r
.complete 26183,1 
step << Alliance
.isOnQuest 26190
#loop
.goto 84,54.96,68.24,10,0
.goto 84,46.28,56.76,10,0
.goto 84,62.87,50.53,10,0
.goto 84,69.48,41.12,10,0
.goto 84,70.84,43.8,10,0
.goto 84,74.25,50.39,10,0
.goto 84,68.86,64.84,10,0
>>Click on the |cRXP_PICK_Barrel|r
.complete 26190,1 
step << Alliance
.isOnQuest 26177
#loop
.goto 84,57.69,77.33,30,0
.goto 84,54.68,70.24,30,0
.goto 84,54.94,65.57,30,0
.goto 84,59.86,60.91,30,0
.goto 84,61.84,59.73,30,0
.goto 84,70.32,66.6,30,0
.goto 84,66.4,58.06,30,0
.goto 84,67.49,53.61,30,0
.goto 84,70.94,49.42,30,0
.goto 84,63.87,51.85,30,0
.goto 84,58.62,42.26,30,0
.goto 84,62.21,56.81,30,0
>>Click on the |cRXP_PICK_Crabs|r
.complete 26177,1 
step << Alliance
step << Alliance
.isOnQuest 26153,26183,26190,26177,26192
*|cRXP_WARN_DO NOT TURN IN THE|r [COOKING DAILY] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step << Horde
.isOnQuest 26227
#loop
.goto 85,59.99,61.29,30,0
.goto 85,59.31,54.41,30,0
.goto 85,60.68,52.15,30,0
.goto 85,58.95,49.24,30,0
.goto 85,52.37,49.1,30,0
.goto 85,42.83,47.9,30,0
.goto 85,46.38,53.38,30,0
.goto 85,42.71,55.53,30,0
.goto 85,41.24,59.81,30,0
.goto 85,40.85,66.62,30,0
.goto 85,42.58,70.57,30,0
.goto 85,43.9,69.06,30,0
.goto 85,44.96,73.94,30,0
.goto 85,49.94,86.56,30,0
.goto 85,50.62,75.08,30,0
.goto 85,52.13,65.93,30,0
>>Click on |cRXP_PICK_Prickly Pear Fruit.|r
.complete 26227,1 
step << Horde
.isOnQuest 26235
#loop
.goto 85,58.59,64.59,20,0
.goto 85,53.9,46.49,20,0
.goto 85,49.48,68.77,20,0
>>Kill |cRXP_ENEMY_Orgrimmar Thieves|r and loot them for [Horde Infantry Rations] |cRXP_WARN_they are stealthed orcs.|r
.complete 26235,1 
.mob Orgrimmar Thief
step << Horde
.isOnQuest 26233
.goto 85,36.51,73.04,20,0
.goto 85,35.14,69.78,20,0
.goto 85,32.48,68.64,20,0
.goto 85,27.67,65.45,20,0
.goto 85,32.4,64.62,20,0
.goto 85,35.6,66.12,20,0
.goto 85,34.86,67.96,20,0
>>Click on |cRXP_PICK_Barrels|r
.complete 26233,1 
step << Horde
.isOnQuest 26234
.goto 85,36.51,73.04,20,0
.goto 85,35.14,69.78,20,0
.goto 85,32.48,68.64,20,0
.goto 85,27.67,65.45,20,0
.goto 85,32.4,64.62,20,0
.goto 85,35.6,66.12,20,0
.goto 85,34.86,67.96,20,0
>>Click on |cRXP_PICK_Barrels|r
.complete 26233,1 
step << Horde
#loop
.isOnQuest 26220
.goto 1,49.07,15.98,30,0
.goto 1,48.22,15.92,30,0
.goto 1,46.82,14.84,30,0
.goto 1,42.81,15.25,30,0
>>Kill |cRXP_ENEMY_Mature Swine|r and |cRXP_ENEMY_Wild Mature Swine.|r Loot them for |cRXP_LOOT_|T350571:0|t[Swine Belly]|r
.complete 26220,1 
.mob Mature Swine
.mob Wild Mature Swine
step << Horde
#loop
.isOnQuest 26226
.goto 85,62.84,39.16,20,0
.goto 85,62.82,43.56,20,0
.goto 85,65.67,43.99,20,0
.goto 85,67.4,42.43,20,0
.goto 85,69.07,43.67,20,0
.goto 85,70.69,41.69,20,0
.goto 85,72.02,39.19,20,0
.goto 85,74.99,38.74,20,0
.goto 85,56.4,54.26,30,0
.goto 85,47.64,49.8,30,0
.goto 85,46.85,46.11,30,0
.goto 85,43.65,45.9,30,0
.goto 85,30.88,62.47,30,0
.goto 85,26.74,63.34,30,0
.goto 85,28.47,66.25,30,0
.goto 85,31.31,66.08,30,0
.goto 85,34.58,72.5,30,0
.goto 85,36.77,75.33,30,0
.goto 85,36.51,85.27,30,0
.goto 85,38.7,85.49,30,0
>>Click on |cRXP_PICK_Muddy Crawfish|r
.complete 26226,1 
.mob Muddy Crawfish
step << Alliance
.isOnQuest 26227,26226,26235,26220,26233,26234
*|cRXP_WARN_DO NOT TURN IN THE|r [COOKING DAILY] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step << Alliance
.isQuestAvailable 29412
.goto 84,58.91,52.72
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vin|r
.accept 29412 >>Accept Blown Away
.target Vin
step << Horde
.isQuestAvailable 29401
.goto 85,48.13,46.85
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jaga|r
.accept 29401 >>Accept Blown Away
.target Jaga
step << Alliance
.isOnQuest 29412
#loop
.goto 84,61.9,51.5,20,0
.goto 84,64.8,51.0,20,0
.goto 84,61.0,42.9,20,0
.goto 84,59.7,35.9,20,0
.goto 84,61.5,33.3,20,0
.goto 84,63.1,28.4,20,0
.goto 84,66.0,33.5,20,0
.goto 84,66.8,38.8,20,0
.goto 84,64.5,38.9,20,0
.goto 84,63.1,41.9,20,0
.goto 84,64.6,44.7,20,0
.goto 84,68.0,44.5,20,0
.goto 84,71.6,47.7,20,0
.goto 84,74.0,45.2,20,0
.goto 84,74.2,49.4,20,0
.goto 84,73.6,54.6,20,0
.goto 84,75.5,56.5,20,0
.goto 84,76.2,61.5,20,0
.goto 84,75.5,64.5,20,0
.goto 84,72.8,68.5,20,0
.goto 84,72.9,61.6,20,0
.goto 84,70.5,57.5,20,0
.goto 84,64.6,68.3,20,0
.goto 84,63.5,65.6,20,0
.goto 84,59.8,68.3,20,0
.goto 84,60.6,73.6,20,0
.goto 84,61.7,77.0,20,0
.goto 84,52.7,77.1,20,0
.goto 84,52.6,82.7,20,0
.goto 84,51.0,84.5,20,0
.goto 84,48.8,89.7,20,0
.goto 84,47.5,84.1,20,0
.goto 84,48.5,76.5,20,0
.goto 84,46.2,64.8,20,0
.goto 84,52.5,62.8,20,0
.goto 84,55.2,58.6,20,0
>>Click on the |cRXP_PICK_Balloons|r
.complete 29412,1 
step << Horde
.isOnQuest 29401
#loop
.goto 85,50.2,49.8,20,0
.goto 85,52.5,49.5,20,0
.goto 85,55.1,53.0,20,0
.goto 85,56.9,57.8,20,0
.goto 85,56.7,62.7,20,0
.goto 85,56.9,57.8,20,0
.goto 85,57.0,65.3,20,0
.goto 85,53.6,62.9,20,0
.goto 85,53.8,65.5,20,0
.goto 85,52.5,66.0,20,0
.goto 85,52.5,68.9,20,0
.goto 85,50.1,68.7,20,0
.goto 85,52.5,73.8,20,0
.goto 85,53.5,76.5,20,0
.goto 85,52.7,79.7,20,0
.goto 85,53.7,82.5,20,0
.goto 85,53.6,83.7,20,0
.goto 85,50.0,84.8,20,0
.goto 85,49.5,77.5,20,0
.goto 85,47.7,81.6,20,0
.goto 85,40.5,80.7,20,0
.goto 85,38.5,86.7,20,0
.goto 85,37.5,77.6,20,0
.goto 85,34.8,73.5,20,0
.goto 85,35.0,67.4,20,0
.goto 85,31.5,68.6,20,0
.goto 85,35.8,49.6,20,0
.goto 85,40.0,39.6,20,0
.goto 85,52.2,39.5,20,0
.goto 85,63.7,23.5,20,0
.goto 85,64.8,17.5,20,0
.goto 85,66.8,13.3,20,0
.goto 85,68.5,30.1,20,0
.goto 85,68.1,36.6,20,0
.goto 85,71.5,35.8,20,0
.goto 85,68.1,36.6,20,0
>>Click on the |cRXP_PICK_Balloons|r
.complete 29401,1 
step << Horde
.isQuestComplete 29401
*|cRXP_WARN_DO NOT TURN IN THE QUEST|r [Blown Away] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step << Alliance
.isQuestComplete 29412
*|cRXP_WARN_DO NOT TURN IN THE QUEST|r [Blown Away] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step << Alliance
.goto 84,61.34,22.66
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Arielle Snapflash|r
.accept 32470 >>Accept Light Camera Action
.itemcount 48933,<1
.target Arielle Snapflash
step << Horde
.itemcount 48933,<1
.goto 85,34.49,70.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vivica Starshot|r
.accept 32470 >>Accept Light Camera Action
.target Vivica Starshot
step << Alliance
.isOnQuest 32470
.goto 84,68.07,67.12
>>Click on the |cRXP_PICK_Box.|r Kill the |cRXP_ENEMY_Giant Rat|r if you get into combat.
.complete 32470,1 
.mob Giant Rat
step << Alliance
.isOnQuest 32470
.goto 84,53.23,82.03
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Duncan Cullan|r
.collect 3593,1 
.buy 3593
.target Duncan Cullan
step << Horde
.isOnQuest 32470
.goto 85,60.92,59.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tor'phan|r
.complete 32470,3 
.buy 3593
.target Tor'phan
step << Horde
.isOnQuest 32470
.goto 85,63.76,19.59
>>Click on the |cRXP_PICK_Box.|r Kill the |cRXP_ENEMY_Giant Rat|r if you get into combat.
.complete 32470,1 
step << Alliance
.isOnQuest 32470
.goto 84,61.13,70.63
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Auctioneer Fitch|r and buy a |T134441:0|t[Standard Scope]
.collect 4406,1 
.target Auctioneer Fitch
step << Horde
.isOnQuest 32470
.goto 85,66.76,36.19
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Auctioneer Kuvi|r and buy a |T134441:0|t[Standard Scope]
.complete 32470,2 
.target Auctioneer Kuvi
step
.isQuestComplete 32470
*|cRXP_WARN_DO NOT TURN IN THE|r [Light Camera Action] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
#completewith Seabraid's Inventory << Alliance
#completewith Zen'kala's Inventory << Horde
>>If you frequently play Horde and Alliance, |cRXP_WARN_set up this quest a day or two before the launch|r. Otherwise, the quest progress resets anytime you log into the opposing faction.
step
.isQuestAvailable 66858 << Alliance
.isQuestAvailable 66959 << Horde
>>Enter Stormwind to receive the quest automatically. << Alliance
>>Enter Orgrimmar to receive the quest automatically. << Horde
.accept 66858 >>Accept Tour the Trading Post << Alliance
.accept 66959 >>Accept Tour the Trading Post << Horde
.zone 84 >> Go to Stormwind << Alliance
.zone 85 >> Go to Orgrimmar << Horde
step << Horde
.isOnQuest 66959
.goto 85,48.44,75.63
>>Click on the |cRXP_PICK_Chest|r
.complete 66959,1 
step << Alliance
.isOnQuest 66858
.goto 84,51.32,72.33
>>Click on the |cRXP_PICK_Chest|r
.complete 66858,1 
step << Alliance
.isOnQuest 66858
.goto 84,51.33,70.85
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dilya|r
.complete 66858,3 
.target Dilya
step << Horde
.isOnQuest 66959
.goto 85,48.27,74.99
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zaa'je|r
.complete 66959,3 
.target Zaa'je
step << Alliance
.isOnQuest 66858
#loop
.goto 84,49.17,71.77,10,0
.goto 84,48.09,72.07,10,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Valarian|r
.complete 66858,2 
.target Valarian
step << Horde
.isOnQuest 66959
.goto 85,47.39,76.51
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gothal|r
.complete 66959,2 
.target Gothal
step << Alliance
.isOnQuest 66858
.goto 84,51.04,71.61
>>Click on the |cRXP_PICK_Poster|r
.complete 66858,4 
step << Horde
.isOnQuest 66959
.goto 85,48.92,76.29
>>Click on the |cRXP_PICK_Poster|r
.complete 66959,4 
step << Alliance
#label Seabraid's Inventory
.isOnQuest 66858
.goto 84,51.07,72.12
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wilder Seabraid|r
.complete 66858,5 
.skipgossip
.target Wilder Seabraid
step << Horde
#label Zen'kala's Inventory
.isOnQuest 66959
.goto 85,48.77,75.98
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zen'kala|r
.complete 66959,5 
.skipgossip
.target Zen'kala
step << Horde
.isQuestComplete 66959
*|cRXP_WARN_DO NOT TURN IN THE|r [Light Camera Action] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step << Alliance
.isQuestComplete 66858
*|cRXP_WARN_DO NOT TURN IN THE|r [Light Camera Action] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 3) Alterac Valley Quests
#displayname |cRXP_WARN_Chapter 2 -|r Alterac Valley Quests
#next 4) Pet Battle Setup
step
#sticky
*|cRXP_WARN_Chapter 2:|r Alterac Valley Quests
*Directs you for a quest to Hillsbrad Foothils and Checks your reputation standing for quest eligibilty
+|cRXP_WARN_If you are exalted and haven't completed any of the quests, you can gain 30% of the experience needed from 70-71 here.|r
step
.zone 25 >> Go to Hillsbrad Foothils
step << Alliance
.goto 25,44.67,46.2
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Haggerdin|r
.accept 7162 >>Accept Proving Grounds
.target Lieutenant Haggerdin
step << Alliance
.isOnQuest 7162
>>Que for an Alterac Valley and complete the quest |cRXP_WARN_but DO NOT TURN IT IN.|r
.accept 7162,1 
step << Alliance
.reputation 730,exalted,3000 >>Que for Alterac Valley until you reach exalted with the Stormpike Guard.
*Each Reputation Level rewards 1 additional quest for a total 6 quests on launch.
*|cRXP_WARN_DO NOT TURN IN ANY OF THE|r [ALTERAC VALLEY QUESTS] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
step << Horde
.goto 25,57.79,33.34
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Warmaster Laggrond|r
.accept 7161 >>Accept Proving Grounds
.target Warmaster Laggrond
step << Horde
.isOnQuest 7162
>>Que for an Alterac Valley and complete the quest |cRXP_WARN_but DO NOT TURN IT IN.|r
.complete 7162,1 
step << Horde
.reputation 729,exalted,999 >>Que for Alterac Valley until you reach exalted with the Frostwolf Clan
>>For each Reputation Level, you earn an additional quest, allowing you to complete up to a total of 6 quests on launch.
*|cRXP_WARN_DO NOT TURN IN ANY OF THE|r [ALTERAC VALLEY QUESTS] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 4) Pet Battle Setup
#displayname |cRXP_WARN_Chapter 3 -|r Pet Battle Quests
#next 5) Goblin Heritage Quests << Goblin
#next 5) Troll Heritage Quests << Troll
#next 5) Orc Heritage Quests << Orc
#next 5) Tauren Heritage Quests << Tauren
#next 5) Undead Heritage Quests << Undead
#next 6) Item Information <<DarkIronDwarf/MagharOrc/ZandalariTroll/Pandaren/Dracthyr/HighmountainTauren/Vulpera/Nightborne
step
#sticky
*|cRXP_WARN_Chapter 3:|r Pet Battle Quests
*Guides you through the entire Pet Battle Campaign for PoP UP-Quests, which can be turned in via the Questlog. Completes Daily Quests for additional experience.
*|cRXP_WARN_|cRXP_WARN_DISABLE ANY QUEST AUTOMATION ADDON EXCEPT RXP BEFORE PROCEEDING:|r
+|cRXP_WARN_If you haven't completed any of the quests, you can gain 110% of the experience needed from 70-71 here.|r
step << Alliance
#completewith Level 25
.zone 84 >>Go to Stormwind
step << Horde
#completewith Level 25
.zone 85 >>Go to Orgrimmar
step << Alliance
.goto 84,69.49,25.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Audrey Burnhep|r train |T643856:0|t[Battle Pet Training] and any available pet
.train 125610 >>Train |T643856:0|t[Battle Pet Training]
.target Audrey Burnhep
step << Horde
.goto 85,52.56,59.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Varzok|r train |T643856:0|t[Battle Pet Training] and any available pet
.train 125610 >>Train |T643856:0|t[Battle Pet Training]
.target Varzok
step << Alliance
.goto 84,61.17,70.8,-1
.goto 84,60.21,32.16,-1
>>Buy a |T797326:0|t[Zandalari Anklerender] from the Auction House on Level 1 |cRXP_WARN_if you can afford it.|r
.collectpet 70451,1
step << Horde
.goto 85,54.06,73.11,-1
.goto 85,66.53,36.32,-1
>>Buy a |T797326:0|t[Zandalari Anklerender] from the Auction House on Level 1 |cRXP_WARN_if you can afford it.|r
.collectpet 70451,1
step << Alliance
#loop
.goto 37,33.42,48.56,30,0
.goto 37,32.05,53.02,30,0
.goto 37,34.99,68.36,30,0
.goto 37,31.44,73.43,30,0
.goto 37,29.15,76.49,30,0
.goto 37,26.64,78.78,30,0
.goto 37,24.14,82.38,30,0
.goto 52,61.63,27.87,30,0
.goto 52,64.25,43.61,30,0
.goto 52,63.1,59.95,30,0
.goto 52,55.96,32.49,30,0
.achievement 6566,1 >>Defeat wild battle pets until you reach level 5 with any pet.
*If you are using the |T797326:0|t[Zandalari Anklerender] pet, spam |T132122:0|t[Rip]. Before defeating the opponent's pet, use |T132131:0|t[Devour] to heal.
.mob Rabbit
.mob Fawn
.mob Small Frog
.mob Prairie Dog
.mob Snake
.mob Chicken
step << Alliance
#loop
.goto 47,6.4,34.94,30,0
.goto 47,10.55,28.59,30,0
.goto 47,28.22,32.58,30,0
.goto 47,25.1,46.22,30,0
.goto 47,22.96,49.67,30,0
.goto 47,21.71,52.35,30,0
.goto 47,24,70.9,30,0
.goto 47,30.76,64.58,30,0
.goto 50,44.63,20.62,30,0
.goto 50,40.8,19.89,30,0
.goto 50,41.86,22.86,30,0
.goto 50,41.54,33.7,30,0
.goto 50,40.65,37.01,30,0
.achievement 6567,1 >>Defeat wild battle pets until you reach level 10 with any pet.
*If you are using the |T797326:0|t[Zandalari Anklerender] pet, spam |T132122:0|t[Rip]. Before defeating the opponent's pet, use |T132131:0|t[Devour] to heal.
.mob Mouse
.mob Small Frog
.mob Rabbit
.mob Black Rat
.mob Roach
.mob Skunk
.mob Dusk Spiderling
.mob Beetle
step << Alliance
.goto 210,49.83,15.5,30,0
.goto 210,48.33,20.24,30,0
.goto 210,46.71,57.79,30,0
.goto 210,49.83,15.5,30,0
.goto 210,48.33,20.24,30,0
.goto 210,46.71,57.79,30,0
.goto 32,28.56,81.73,30,0
.goto 32,29.07,70.27,30,0
.goto 32,30.23,58.99,30,0
.goto 32,29.59,51.13,30,0
.goto 32,32.13,42.96,30,0
.goto 32,52.26,69.15,30,0
.goto 36,35.75,30.15,30,0
.goto 36,34.03,39.54,30,0
.goto 36,40.01,59.23,30,0
.goto 36,26.79,59.01,30,0
.goto 36,18.83,59.55,30,0
.achievement 6568,1 >>Defeat wild battle pets until you reach level 15 with any pet.
*If you are using the |T797326:0|t[Zandalari Anklerender] pet, spam |T132122:0|t[Rip]. Before defeating the opponent's pet, use |T132131:0|t[Devour] to heal.
.mob Beetle
.mob Lizard Hatchling
.mob Strand Crab
.mob Crimson Moth
.mob Forest Spiderling
.mob Tree Frog
.mob Ash Spiderling
step << Alliance
#loop
.goto 32,28.56,81.73,30,0
.goto 32,29.07,70.27,30,0
.goto 32,30.23,58.99,30,0
.goto 32,29.59,51.13,30,0
.goto 32,32.13,42.96,30,0
.goto 32,52.26,69.15,30,0
.goto 36,35.75,30.15,30,0
.goto 36,34.03,39.54,30,0
.goto 36,40.01,59.23,30,0
.goto 36,26.79,59.01,30,0
.goto 36,18.83,59.55,30,0
.achievement 6569,1 >>Defeat wild battle pets until you reach level 20 with any pet.
*If you are using the |T797326:0|t[Zandalari Anklerender] pet, spam |T132122:0|t[Rip]. Before defeating the opponent's pet, use |T132131:0|t[Devour] to heal.
.use 125439
.use 86143
.mob Cockroach
.mob Mouse
.mob Scorpid
.mob Fire Beetle
.mob Ash Viper
.mob Lava Crab
step << Alliance
#completewith next
.goto 84,44.39,88.71,10,0
.zone 125 >> Take the Portal from Stormwind to Dalaran
step << Alliance
#label Level 25
#loop
.goto 127,40.36,45.78,30,0
.goto 127,53.72,46.48,30,0
.goto 127,39.23,57.66,30,0
.goto 127,33.92,53.54,30,0
.goto 127,27.03,48.45,30,0
.goto 127,15.08,49.89,30,0
.goto 127,35.29,34.23,30,0
.achievement 6570,1 >>Defeat wild battle pets until you reach level 25 with any pet.
*If you are using the |T797326:0|t[Zandalari Anklerender] pet, spam |T132122:0|t[Rip]. Before defeating the opponent's pet, use |T132131:0|t[Devour] to heal.
.use 125439
.use 8614
.mob Squirrel
.mob Cockroach
.mob Fire Beetle
.mob Ash Viper
.mob Lava Crab
step << Horde
#loop
.goto 1,43.02,20.84,30,0
.goto 1,45.8,23.56,30,0
.goto 1,45.65,30.05,30,0
.goto 1,45.77,35.77,30,0
.goto 1,41.21,39.37,30,0
.goto 1,35.98,41.75,30,0
.goto 10,66.28,42.49
.achievement 6566,1 >>Defeat wild battle pets until you reach level 5 with any pet.
*If you are using the |T797326:0|t[Zandalari Anklerender] pet, spam |T132122:0|t[Rip]. Before defeating the opponent's pet, use |T132131:0|t[Devour] to heal.
.mob Creepy Crawly
.mob Dung Beetle
.mob Water Snake
.mob Adder
step << Horde
.goto 63,64.45,84.17,30,0
.goto 63,61.12,83.3,30,0
.goto 63,60.79,80.09,30,0
.goto 63,57.06,73.54,30,0
.goto 63,53.58,71.77,30,0
.goto 65,73.2,55.37,30,0
.goto 65,71.34,56.73,30,0
.goto 65,74.85,64.97,30,0
.goto 199,32.58,9.93
.achievement 6567,1 >>Defeat wild battle pets until you reach level 10 with any pet.
*If you are using the |T797326:0|t[Zandalari Anklerender] pet, spam |T132122:0|t[Rip]. Before defeating the opponent's pet, use |T132131:0|t[Devour] to heal.
.mob Adder
.mob Prairie Dog
.mob Cheetah Cub
.mob Squirrel
.mob Forest Moth
.mob Toad
.mob Coral Snake
.mob Mountain Skunk
step << Horde
#loop
.goto 199,41.83,20.55,30,0
.goto 199,42.04,23.5,30,0
.goto 199,43.1,28.09,30,0
.goto 199,45.41,32.83,30,0
.goto 199,46.45,35.47,30,0
.goto 199,48.46,42.58,30,0
.goto 199,49.37,45.67,30,0
.goto 199,50.64,48.81,30,0
.goto 199,51.84,54.59,30,0
.goto 70,33.82,22.69,30,0
.goto 70,34.92,26.85,30,0
.goto 70,34.08,45.11,30,0
.goto 70,34.57,57.79,30,0
.goto 70,36.03,69.21,30,0
.goto 64,55.63,62.29
.achievement 6568,1 >>Defeat wild battle pets until you reach level 15 with any pet.
*If you are using the |T797326:0|t[Zandalari Anklerender] pet, spam |T132122:0|t[Rip]. Before defeating the opponent's pet, use |T132131:0|t[Devour] to heal.
.mob Spider
.mob Small Frog
.mob twillight iguana
step << Horde
#loop
.goto 78,65,36.42,30,0
.goto 78,65.74,41.43,30,0
.goto 78,65.82,51.98,30,0
.goto 78,47.15,64.35,30,0
.goto 78,42.91,64.71,30,0
.goto 78,38.56,66.23,30,0
.goto 78,34.61,67.51,30,0
.achievement 6569,1 >>Defeat wild battle pets until you reach level 20 with any pet.
*If you are using the |T797326:0|t[Zandalari Anklerender] pet, spam |T132122:0|t[Rip]. Before defeating the opponent's pet, use |T132131:0|t[Devour] to heal.
.use 125439
.use 86143
.mob Cockroach
.mob Beetle
.mob Ash Viper
.mob Lava Crab
.mob parrot
step << Horde
#completewith next
.goto 85,56.26,91.71,10,0
.zone 125>> Take the Portal from Orgrimmar to Dalaran
step << Horde
#label Level 25
#loop
.goto 127,40.36,45.78,30,0
.goto 127,53.72,46.48,30,0
.goto 127,39.23,57.66,30,0
.goto 127,33.92,53.54,30,0
.goto 127,27.03,48.45,30,0
.goto 127,15.08,49.89,30,0
.goto 127,35.29,34.23,30,0
.achievement 6570,1 >>Defeat wild battle pets until you reach level 25 with any pet.
*If you are using the |T797326:0|t[Zandalari Anklerender] pet, spam |T132122:0|t[Rip]. Before defeating the opponent's pet, use |T132131:0|t[Devour] to heal.
.use 125439
.use 86143
.mob Cockroach
.mob Fire Beetle
.mob Ash Viper
.mob Lava Crab
step
>>Buy the following Level 25 pets from the Auction House. |cRXP_WARN_If you can afford it, this will make things significantly faster and easier.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
.collectpet 86447,3
.disablecheckbox
.collectpet 77221,3
.disablecheckbox
.collectpet 73011,3
.disablecheckbox
.collectpet 106181,3
.disablecheckbox
.collectpet 70451,3
.disablecheckbox
.collectpet 68662,3
.disablecheckbox
.collectpet 23909,3
.disablecheckbox
.collectpet 94867,3
.disablecheckbox
.collectpet 68659,1
.disablecheckbox
.collectpet 64899,3
.disablecheckbox
.collectpet 55356,3
.disablecheckbox
.collectpet 55367,3
.disablecheckbox
.collectpet 63098,3
.disablecheckbox
step
*Create a Level 1 Orc in Durotar|cFFFF0000(even if you only play alliance.|r
*|cRXP_WARN_This character is used to pick up horde specific quests and they cannot be picked up on a high level horde character.|r
*|cRXP_WARN_Do not delete the level 1 Orc until the guide tells you to|r
+|cFFFF0000 To proceed with the guide, simply click on the circle next to the text.|r |cRXP_WARN_You will likely have to skip this manually many times.|r
step << Horde
.goto 461,66.92,69.93,20,0
.goto 461,69.84,66.94,20,0
.goto 1,55.38,73.31
.fly Orgrimmar >>Fly to Orgrimmar
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Handler Marnlek|r
.target Handler Marnlek
step << Horde
.isQuestTurnedIn 31966,31967
.goto 85,52.56,59.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Varzok|r
.accept 31952 >>Accept Battle Pet Tamers: Pandaria
.target Varzok
step << Horde
.isQuestTurnedIn 31929,31927
.goto 85,52.59,59.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Varzok|r
.accept 31967 >>Accept Battle Pet Tamers: Cataclysm
.target Varzok
step << Horde
.isQuestTurnedIn 31921,31919
.goto 85,52.54,59.25
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Varzok|r
.accept 31929 >>Accept Battle Pet Tamers: Northrend
.target Varzok
step << Horde
.isQuestTurnedIn 31903,31902,31891,31889
.goto 85,52.54,59.25
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Varzok|r
.accept 31921 >>Accept Battle Pet Tamers: Outland
step << Horde
.isQuestAvailable 31812
.goto 85,52.56,59.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Varzok|r in Orgrimmar.
.accept 31812 >>Accept Zunta, The Pet Tamer
step << Horde
#completewith Cassandra Kaboom
.isQuestAvailable 31870
+Switch to a max-level Horde Character.
*|cRXP_WARN_If you don't have one, create a class trial Horde character.|r
step << Horde
.isOnQuest 31812
.goto 1,44.01,29.01
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zunta|r and defeat him in a pet battle.
.complete 31812,1 
.skipgossip
.target Zunta
step << Horde
.isOnQuest 31812
.goto 1,43.86,28.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zunta|r
.turnin 31812 >>Turn in Zunta, The Pet Tamer
.target Zunta
step << Horde
.isQuestAvailable 31813
.goto 1,43.86,28.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zunta|r
.accept 31813 >>Accept Dagra the Fierce
.target Zunta
step << Horde
.isOnQuest 31813
.goto 10,58.61,52.78
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dagra the Fierce|r and defeat him in a pet battle.
.complete 31813,1 
.skipgossip
.target Dagra the Fierce
step << Horde
.isOnQuest 31813
.goto 10,58.61,53.05
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dagra the Fierce|r
.turnin 31813 >>Turn in Dagra the Fierce
.target Dagra the Fierce
step << Horde
.isQuestAvailable 31814
.goto 10,58.61,53.05
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dagra the Fierce|r
.target Dagra the Fierce
.accept 31814 >>Accept Analynn
step << Horde
.isOnQuest 31814
.goto 63,20.05,29.42
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Analynn|r and defeat them in a pet battle.
.complete 31814,1 
.skipgossip
.target Analynn
step << Horde
.isOnQuest 31814
.goto 63,20.20,29.55
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Analynn|r
.turnin 31814 >>Turn in Analynn
.target Analynn
step << Horde
.isQuestAvailable 31815
.goto 63,20.20,29.55
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Analynn|r
.target Analynn
.accept 31815 >>Accept Zonya the Sadist
step << Horde
.isOnQuest 31815
.goto 65,59.80,71.45
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zonya the Sadist|r and defeat them in a pet battle.
.complete 31815,1 
.skipgossip
.target Zonya the Sadist
step << Horde
.isOnQuest 31815
.goto 65,59.66,71.58
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zonya the Sadist|r
.turnin 31815 >>Turn in Zonya the Sadist
.target Zonya the Sadist
step << Horde
.isQuestAvailable 31817
.goto 65,59.66,71.58
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zonya the Sadist|r
.target Zonya the Sadist
.accept 31817 >>Accept Merda Stronghoof
step << Horde
.isOnQuest 31817
.goto 66,57.25,45.95
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Merda Stronghoof|r and defeat them in a pet battle.
.complete 31817,1 
.skipgossip
.target Merda Stronghoof
step << Horde
.isOnQuest 31817
.goto 66,57.11,45.68
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Merda Stronghoof|r
.turnin 31817 >>Turn in Merda Stronghoof
.target Merda Stronghoof
step << Horde
.isQuestAvailable 31870
.goto 66,57.11,45.68
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Merda Stronghoof|r
.target Merda Stronghoof
.accept 31870 >>Accept Cassandra Kaboom
step << Horde
.isOnQuest 31870
.goto 199,39.70,79.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cassandra Kaboom|r and defeat them in a pet battle.
.complete 31870,1 
.skipgossip
.target Cassandra Kaboom
step << Horde
#label Cassandra Kaboom
.isOnQuest 31870
.goto 199,39.59,79.14
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cassandra Kaboom|r
.turnin 31870 >>Turn in Cassandra Kaboom
.target Cassandra Kaboom
step << Horde
>>Log into your Level 1 Orc |cRXP_WARN_if you are not already.|r
+|cFFFF0000 To proceed with the guide, simply click on the circle next to the text.|r |cRXP_WARN_You will likely have to skip this manually many times.|r
step << Horde
.isQuestAvailable 31891
.goto 85,52.56,59.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Varzok|r
.accept 31891 >>Accept Battle Pet Tamers: Kalimdor
.target Varzok
step << Horde
.isQuestAvailable 31903
.goto 85,52.56,59.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Varzok|r
.target Varzok
.accept 31903 >>Accept Battle Pet Tamers: Eastern Kingdoms
step
*Create a Level 1 Human in Northshire Valley |cFFFF0000(even if you only play Horde.|r
*|cRXP_WARN_This character is used to pick up Alliance specific quests and they cannot be picked up on a high level Alliance characters.|r
*|cRXP_WARN_Do not delete the level 1 Human until the guide tells you to|r
+|cFFFF0000 To proceed with the guide, simply click on the circle next to the text.|r |cRXP_WARN_You will likely have to skip this manually many times.|r
step << Alliance
.isQuestTurnedIn 31966,31967
.goto 84,69.48,25.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Audrey Burnhep|r
.accept 31930 >>Accept Battle Pet Tamers: Pandaria
.target Audrey Burnhep
step << Alliance
.isQuestTurnedIn 31929,31927
.goto 84,69.48,25.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Audrey Burnhep|r
.accept 31966 >>Accept Battle Pet Tamers: Cataclysm
.target Audrey Burnhep
step << Alliance
.isQuestTurnedIn 31921,31919
.goto 84,69.48,25.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Audrey Burnhep|r
.accept 31927 >>Accept Battle Pet Tamers: Northrend
.target Audrey Burnhep
step << Alliance
.isQuestTurnedIn 31903,31902,31891,31889
.goto 84,69.49,25.16
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Audrey Burnhep|r
.accept 31919 >>Accept Battle Pet Tamers: Outland
.target Audrey Burnhep
step << Alliance
.isQuestAvailable 31316
.goto 84,69.49,25.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Audrey Burnhep|r in Stormwind
.accept 31316 >>Accept Julia, The Pet Tamer
.target Audrey Burnhep
step
#completewith Turn in Bill Buckler
.isQuestAvailable 31728
+Switch to a max-level Alliance Character.
*|cRXP_WARN_If you don't have one, create a class trial Alliance character.|r
step << Alliance
.isOnQuest 31316
.goto 37,41.38,83.76
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Julia Stevens|r and defeat them in a pet battle.
.complete 31316,1 
.skipgossip
.target Julia Stevens
step << Alliance
.isOnQuest 31316
.goto 37,41.65,83.67
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Julia Stevens|r
.turnin 31316 >>Turn in Julia, The Pet Tamer
.target Julia Stevens
step << Alliance
.isQuestAvailable 31724
.goto 37,41.65,83.67
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Old MacDonald|r
.target Old MacDonald
.accept 31724 >>Accept Old MacDonald
step << Alliance
.isOnQuest 31724
.goto 52,61.04,18.82
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Old MacDonald|r and defeat them in a pet battle.
.complete 31724,1 
.skipgossip
.target Old MacDonald
step << Alliance
.isOnQuest 31724
.goto 52,60.86,18.49
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Old MacDonald|r
.turnin 31724 >>Turn in Old MacDonald
.target Old MacDonald
step << Alliance
.isQuestAvailable 31725
.goto 52,60.86,18.49
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lindsay|r
.target Lindsay
.accept 31725 >>Accept Lindsay
step << Alliance
.isOnQuest 31725
.goto 49,33.04,53.02
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lindsay|r and defeat them in a pet battle.
.complete 31725,1 
.skipgossip
step << Alliance
.isOnQuest 31725
.goto 49,33.29,52.57
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lindsay|r
.turnin 31725 >>Turn in Lindsay
.target Lindsay
step << Alliance
.isQuestAvailable 31726
.goto 49,33.29,52.57
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lindsay|r
.target Lindsay
.accept 31726 >>Accept Eric Davidson
step << Alliance
.isOnQuest 31726
.goto 47,19.91,45.17
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eric Davidson|r and defeat them in a pet battle.
.complete 31726,1 
.skipgossip
step << Alliance
.isOnQuest 31726
.goto 47,19.88,44.64
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eric Davidson|r
.turnin 31726 >>Turn in Eric Davidson
.target Eric Davidson
step << Alliance
.isQuestAvailable 31729
.goto 47,19.88,44.64
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eric Davidson|r
.target Eric Davidson
.accept 31729 >>Accept Steven Lisbane
step << Alliance
.isOnQuest 31729
.goto 50,46.17,40.18
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Steven Lisbane|r and defeat them in a pet battle.
.complete 31729,1 
.skipgossip
step << Alliance
.isOnQuest 31729
.goto 50,46.01,40.44
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Steven Lisbane|r
.turnin 31729 >>Turn in Steven Lisbane
.target Steven Lisbane
step << Alliance
.isQuestAvailable 31728
.goto 50,46.01,40.44
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Steven Lisbane|r
.target Steven Lisbane
.accept 31728 >>Accept Bill Buckler
step << Alliance
.isOnQuest 31728
.goto 210,51.22,73.30
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bill Buckler|r and defeat them in a pet battle.
.complete 31728,1 
.skipgossip
step << Alliance
#label Turn in Bill Buckler
.isOnQuest 31728
.goto 210,51.47,73.38
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bill Buckler|r
.turnin 31728 >>Turn in Bill Buckler
.target Bill Buckler
step << Alliance
>>Log into your Level 1 Human |cRXP_WARN_if you are not already.|r
+|cFFFF0000 To proceed with the guide, simply click on the circle next to the text.|r |cRXP_WARN_You will likely have to skip this manually many times.|r
step << Alliance
.isQuestAvailable 31902
.goto 84,69.48,25.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Audrey Burnhep|r
.accept 31902 >>Accept Battle Pet Tamers: Eastern Kingdoms
.target Audrey Burnhep
step << Alliance
.isQuestAvailable 31889
.goto 84,69.48,25.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Audrey Burnhep|r
.target Audrey Burnhep
.accept 31889 >>Accept Battle Pet Tamers: Kalimdor
step
.isOnQuest 31902,31903
>>|cRXP_WARN_Switch to a max-level character, either Horde or Alliance.|r
+|cFFFF0000 To proceed with the guide, simply click on the circle next to the text.|r |cRXP_WARN_You will likely have to skip this manually many times.|r
step
.isOnQuest 31902,31903
#completewith next
.zone 51 >>Go to Swamp of Sorrows
step
.isOnQuest 31902
.goto 51,76.54,41.07
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Everessa|r and defeat them in a pet battle.
.complete 31902,4 
.skipgossip
step
.isOnQuest 31902,31903
#completewith next
.zone 51 >>Go to Swamp of Sorrows
step
.isOnQuest 31903
.goto 51,76.54,41.07
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Everessa|r and defeat them in a pet battle.
.complete 31903,4 
.skipgossip
.target Everessa
step
.isOnQuest 31902,31903
#completewith next
.zone 36 >>Go to Burning Steppes
step
.isOnQuest 31902
.goto 36,25.58,47.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Durin Darkhammer|r and defeat them in a pet battle.
.complete 31902,5 
.skipgossip
step
.isOnQuest 31902,31903
#completewith next
.zone 36 >>Go to Burning Steppes
step
.isOnQuest 31903
.goto 36,25.58,47.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Durin Darkhammer|r and defeat them in a pet battle.
.complete 31903,5 
.skipgossip
.target Durin Darkhammer
step
.isOnQuest 31902,31903
#completewith next
.zone 32 >>Go to Searing Gorge
step
.isOnQuest 31902
.goto 32,35.75,27.77
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kortas Darkhammer|r and defeat them in a pet battle.
.complete 31902,3 
.skipgossip
step
.isOnQuest 31902,31903
#completewith next
.zone 32 >>Go to Searing Gorge
step
.isOnQuest 31903
.goto 32,35.75,27.77
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kortas Darkhammer|r and defeat them in a pet battle.
.complete 31903,3 
.skipgossip
.target Kortas Darkhammer
step
.isOnQuest 31902,31903
#completewith next
.zone 26 >>Go to Hinterlands
step
.isOnQuest 31902
.goto 26,62.78,54.83
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_David Kosse|r and defeat them in a pet battle.
.complete 31902,1 
.skipgossip
step
.isOnQuest 31902,31903
#completewith next
.zone 26 >>Go to Hinterlands
step
.isOnQuest 31903
.goto 26,62.78,54.83
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_David Kosse|r and defeat them in a pet battle.
.complete 31903,1 
.skipgossip
.target David Kosse
step
.isOnQuest 31902,31903
#completewith next
.zone 23 >>Go to Eastern Plaguelands
step
.isOnQuest 31902
.goto 23,67.16,52.19
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Deiza Plaguehorn|r and defeat them in a pet battle.
.complete 31902,2 
.skipgossip
step
.isOnQuest 31902,31903
#completewith next
.zone 23 >>Go to Eastern Plaguelands
step
.isOnQuest 31903
.goto 23,67.16,52.19
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Deiza Plaguehorn|r and defeat them in a pet battle.
.complete 31903,2 
.skipgossip
.target Deiza Plaguehorn
step
.isQuestAvailable 31903,31889,31891
.isOnQuest 31902
>>Click on the Quest Pop-UP to |cFFFF0000ONLY|r turn in |cFFFF00001|r of the Battle Pet Tamers: Eastern Kingdoms Quests.
*|cFFFF0000Keep the other one until launch night to turn it in for XP|r
*|cRXP_WARN_You can minimize the other pop-up and untrack the quest|r |cFFFF0000make sure all quest automation addons are off excluding RXP.|r
.turnin 31902 >>Turn in Battle Pet Tamers: Eastern Kingdoms
step
.isQuestAvailable 31902,31889,31891
.isOnQuest 31903
>>Click on the Quest Pop-UP to |cFFFF0000ONLY|r turn in |cFFFF00001|r of the Battle Pet Tamers: Eastern Kingdoms Quests.
*|cFFFF0000Keep the other one until launch night to turn it in for XP|r
*|cRXP_WARN_You can minimize the other pop-up and untrack the quest|r |cFFFF0000make sure all quest automation addons are off excluding RXP.|r
.turnin 31903 >>Turn in Battle Pet Tamers: Eastern Kingdoms
step
.isQuestAvailable 31915
.goto 42,40.45,76.47
>>Click on the Quest PoP-UP to accept [Defeat Grand Master Lydia Accoste]
*|cRXP_WARN_You can minimize the other pop-up and untrack the quest|r |cFFFF0000make sure all quest automation addons are off excluding RXP.|r
.accept 31915 >>Accept Grand Master Lydia Accoste
step
.isOnQuest 31915
#completewith next
.zone 42 >>Go to Deadwind Pass
step
.isOnQuest 31915
.goto 42,40.45,76.47
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lydia Accoste|r and defeat them in a pet battle.
.complete 31915,1 
.skipgossip
.target Lydia Accoste
step
.isQuestComplete 31915
.goto 42,40.38,76.44
>>Click on the Quest Pop-UP to turn in the quest [Grand Master Lydia Accoste]
*|cRXP_WARN_You can minimize the other pop-ups and untrack the quest|r |cFFFF0000make sure all quest automation addons are off excluding RXP.|r
.turnin 31915 >>Turn in Grand Master Lydia Accoste
.target Shiekrunner
step
.isOnQuest 31889,31891
>>|cRXP_WARN_Switch to a max-level character, either Horde or Alliance.|r
step
.isOnQuest 31889,31891
#completewith next
.zone 69 >>Go to Feralas
step
.isOnQuest 31889
.goto 69,59.61,49.61
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Traitor Gluk|r and defeat them in a pet battle.
.complete 31889,1 
.skipgossip
.target Traitor Gluk
step
.isOnQuest 31889,31891
#completewith next
.zone 69 >>Go to Feralas
step
.isOnQuest 31891
.goto 69,59.61,49.61
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Traitor Gluk|r and defeat them in a pet battle.
.complete 31891,1 
.skipgossip
.target Traitor Gluk
step
.isOnQuest 31889,31891
#completewith next
.zone 70 >>Go to Dustwallow Marsh
step
.isOnQuest 31889
.goto 70,53.81,74.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grazzle the Great|r and defeat them in a pet battle.
.complete 31889,2 
.skipgossip
.target Grazzle the Great
step
.isOnQuest 31889,31891
#completewith next
.zone 70 >>Go to Dustwallow Marsh
step
.isOnQuest 31891
.goto 70,53.81,74.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grazzle the Great|r and defeat them in a pet battle.
.complete 31891,2 
.skipgossip
.target Grazzle the Great
step
.isOnQuest 31889,31891
#completewith next
.zone 64 >>Go to Thousand Needles
step
.isOnQuest 31889
.goto 64,11.81,32.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kela Grimtotem|r and defeat them in a pet battle.
.complete 31889,3 
.skipgossip
.target Kela Grimtotem
step
.isOnQuest 31889,31891
#completewith next
.zone 64 >>Go to Thousand Needles
step
.isOnQuest 31891
.goto 64,11.81,32.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kela Grimtotem|r and defeat them in a pet battle.
.complete 31891,3 
.skipgossip
.target Kela Grimtotem
step
.isOnQuest 31889,31891
#completewith next
.zone 77 >>Go to Felwood
step
.isOnQuest 31889
.goto 77,40.01,56.41
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zoltan|r and defeat them in a pet battle.
.complete 31889,4 
.skipgossip
.target Zoltan
step
.isOnQuest 31889,31891
#completewith next
.zone 77 >>Go to Felwood
step
.isOnQuest 31891
.goto 77,40.01,56.41
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zoltan|r and defeat them in a pet battle.
.complete 31891,4 
.skipgossip
.target Zoltan
step
.isOnQuest 31889,31891
#completewith next
.zone 80 >>Go to Moonglade
step
.isOnQuest 31889
.goto 80,46.01,60.61
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elena Flutterfly|r and defeat them in a pet battle.
.complete 31889,5 
.skipgossip
.target Elena Flutterfly
step
.isOnQuest 31889,31891
#completewith next
.zone 80 >>Go to Moonglade
step
.isOnQuest 31891
.goto 80,46.01,60.61
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elena Flutterfly|r and defeat them in a pet battle.
.complete 31891,5 
.skipgossip
.target Elena Flutterfly
step
.isOnQuest 31889,31891
#completewith next
.zone 42 >>Go to Winterspring
step
.isQuestAvailable 31897
.goto 42,40.45,76.47
>>Click on the Quest PoP-UP to accept [Defeat Grand Master Trixxy]
*|cRXP_WARN_You can minimize the other pop-ups and untrack the quest|r |cFFFF0000make sure all quest automation addons are off excluding RXP.|r
.accept 31897 >>Accept Grand Master Trixxy
.target Grand Master Trixxy
step
.isOnQuest 31897
#completewith next
.zone 42 >>Go to Winterspring
step
.isOnQuest 31897
.goto 42,40.45,76.47
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grand Master Trixxy|r and defeat them in a pet battle.
.complete 31897,1 
.skipgossip
.target Grand Master Trixxy
step
.isQuestComplete 31897
.goto 42,40.38,76.44
>>Click on the Quest Pop-UP to turn in the quest [Grand Master Trixxy]
*|cRXP_WARN_You can minimize the other pop-ups and untrack the quest|r |cFFFF0000make sure all quest automation addons are off excluding RXP.|r
.turnin 31915 >>Turn in Grand Master Trixxy
.target Grand Master Trixxy
step
.isQuestAvailable 31891,31902,31903
.isOnQuest 31889
>>Click on the Quest Pop-UP to |cFFFF0000ONLY|r turn in |cFFFF00001|r of the Battle Pet Tamers: Kalimdor Quests.
*|cFFFF0000Keep the other one until launch night to turn it in for XP|r
*|cRXP_WARN_You can minimize the other pop-up and untrack the quest|r |cFFFF0000make sure all quest automation addons are off excluding RXP.|r
.turnin 31889 >>Turn in Battle Pet Tamers: Kalimdor
step
.isQuestAvailable 31889,31902,31903
.isOnQuest 31891
>>Click on the Quest Pop-UP to |cFFFF0000ONLY|r turn in |cFFFF00001|r of the Battle Pet Tamers: Kalimdor Quests.
*|cFFFF0000Keep the other one until launch night to turn it in for XP|r
*|cRXP_WARN_You can minimize the other pop-up and untrack the quest|r |cFFFF0000make sure all quest automation addons are off excluding RXP.|r
.turnin 31891 >>Turn in Battle Pet Tamers: Kalimdor
step
.isQuestAvailable 31919
#completewith next
+Log into your Level 1 Human
step
.isQuestAvailable 31919
.goto 84,69.49,25.16
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Audrey Burnhep|r
.accept 31919 >>Accept Battle Pet Tamers: Outland
.target Audrey Burnhep
step
.isQuestAvailable 31921
#completewith next
+Log into your Level 1 Orc
step
.isQuestAvailable 31921
.goto 85,52.54,59.25
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Varzok|r
.accept 31921 >>Accept Battle Pet Tamers: Outland
.target Varzok
step
.isOnQuest 31919,31921
#completewith next
.zone 111 >>Go to Shattrath
step
.isOnQuest 31919
.goto 111,59.51,69.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Morulu the Elder|r and defeat them in a pet battle.
.complete 31919,4 
.skipgossip
step
.isOnQuest 31919,31921
#completewith next
.zone 111 >>Go to Shattrath
step
.isOnQuest 31921
.goto 111,59.51,69.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Morulu the Elder|r and defeat them in a pet battle.
.complete 31921,4 
.skipgossip
step
.isOnQuest 31919,31921
#completewith next
.zone 107 >>Go to Narrok
step
.isOnQuest 31919
.goto 107,61.06,49.19
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Narrok|r and defeat them in a pet battle.
.complete 31919,3 
.skipgossip
step
.isOnQuest 31919,31921
#completewith next
.zone 107 >>Go to Narrok
step
.isOnQuest 31921
.goto 107,61.06,49.19
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Narrok|r and defeat them in a pet battle.
.complete 31921,3 
.skipgossip
step
.isOnQuest 31919,31921
#completewith next
.zone 102 >>Go to Zangarmarsh
step
.isOnQuest 31919
.goto 102,17.05,50.52
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ras'an|r and defeat them in a pet battle.
.complete 31919,2 
.skipgossip
step
.isOnQuest 31919,31921
#completewith next
.zone 102 >>Go to Zangarmarsh
step
.isOnQuest 31921
.goto 102,17.05,50.52
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ras'an|r and defeat them in a pet battle.
.complete 31921,2 
.skipgossip
step
.isOnQuest 31919,31921
#completewith next
.zone 100 >>Go to Hellfire Peninsula
step
.isOnQuest 31919
.goto 100,64.51,49.31
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nicki Tinytech|r and defeat them in a pet battle.
.complete 31919,1 
.skipgossip
step
.isOnQuest 31919,31921
#completewith next
.zone 100 >>Go to Hellfire Peninsula
step
.isOnQuest 31921
.goto 100,64.51,49.31
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nicki Tinytech|r and defeat them in a pet battle.
.complete 31921,1 
.skipgossip
step
.isQuestAvailable 31921
.isOnQuest 31919
>>Click on the Quest Pop-UP to |cFFFF0000ONLY|r turn in |cFFFF00001|r of the Battle Pet Tamers: Outland
*|cFFFF0000Keep the other one until launch night to turn it in for XP|r
*|cRXP_WARN_You can minimize the other pop-up and untrack the quest|r |cFFFF0000make sure all quest automation addons are off excluding RXP.|r
.goto 100,64.44,49.31
.turnin 31919 >>Turn in Battle Pet Tamers: Outland
step
.isQuestAvailable 31919
.isOnQuest 31921
>>Click on the Quest Pop-UP to |cFFFF0000ONLY|r turn in |cFFFF00001|r of the Battle Pet Tamers: Outland
*|cFFFF0000Keep the other one until launch night to turn it in for XP|r
*|cRXP_WARN_You can minimize the other pop-up and untrack the quest|r |cFFFF0000make sure all quest automation addons are off excluding RXP.|r
.goto 100,64.44,49.31
.turnin 31921 >>Turn in Battle Pet Tamers: Outland
step
.isQuestAvailable 31920
>>Click on the Quest Pop-UP to accept [Defeat Grand Master Antari]
*|cRXP_WARN_You can minimize the other pop-ups and untrack the quest|r |cFFFF0000make sure all quest automation addons are off excluding RXP.|r
.goto 100,64.44,49.31
.accept 31920 >>Accept Grand Master Antari
step
.isOnQuest 31920
#completewith next
.zone 104 >>Go to Shadowmoon Valley
step
.isOnQuest 31920
.goto 104,30.43,42.00
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bloodknight Antari|r and defeat them in a pet battle.
.complete 31920,1 
.skipgossip
step
.isOnQuest 31920
.goto 104,30.51,41.77
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bloodknight Antari|r
.turnin 31920 >>Turn in Grand Master Antari
.target Bloodknight Antari
step
.isQuestAvailable 31929
#completewith next
+Log into your Level 1 Orc
step
.isQuestAvailable 31929
.goto 85,52.54,59.25
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Varzok|r
.accept 31929 >>Accept Battle Pet Tamers: Northrend
.target Varzok
step
.isQuestAvailable 31927
#completewith next
+Log into your Level 1 Human
step
.isQuestAvailable 31927
.goto 84,69.48,25.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Audrey Burnhep|r
.accept 31927 >>Accept Battle Pet Tamers: Northrend
.target Audrey Burnhep
step
.isOnQuest 31929,31927
#completewith next
>>|cRXP_WARN_Switch to a max-level character, either Horde or Alliance.|r
step
.isOnQuest 31929,31927
#completewith next
.zone 127 >>Go to Crystalsong Forest
step
.isOnQuest 31929
.goto 127,50.38,59.34
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nearly Headless Jacob|r and defeat them in a pet battle.
.complete 31929,2 
.skipgossip
step
.isOnQuest 31929,31927
#completewith next
.zone 127 >>Go to Crystalsong Forest
step
.isOnQuest 31927
.goto 127,50.38,59.34
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nearly Headless Jacob|r and defeat them in a pet battle.
.complete 31927,2 
.skipgossip
step
.isOnQuest 31929,31927
#completewith next
.zone 121 >>Go to Zul'Drak
step
.isOnQuest 31929
.goto 121,13.03,66.79
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gutretch|r and defeat them in a pet battle.
.complete 31929,4 
.skipgossip
step
.isOnQuest 31929,31927
#completewith next
.zone 121 >>Go to Zul'Drak
step
.isOnQuest 31927
.goto 121,13.03,66.79
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gutretch|r and defeat them in a pet battle.
.complete 31927,4 
.skipgossip
step
.isOnQuest 31929,31927
#completewith next
.zone 117 >>Go to Howling Fjord
step
.isOnQuest 31929
.goto 117,28.55,33.65
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Beegle Blastfuse|r and defeat them in a pet battle.
.complete 31929,1 
.skipgossip
step
.isOnQuest 31929,31927
#completewith next
.zone 117 >>Go to Howling Fjord
step
.isOnQuest 31927
.goto 117,28.55,33.65
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Beegle Blastfuse|r and defeat them in a pet battle.
.complete 31927,1 
.skipgossip
step
.isOnQuest 31929,31927
#completewith next
.zone 115 >>Go to Dragonblight
step
.isOnQuest 31929
.goto 115,59.02,76.79
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Okrut Dragonwaste|r and defeat them in a pet battle.
.complete 31929,3 
.skipgossip
step
.isOnQuest 31929,31927
#completewith next
.zone 115 >>Go to Dragonblight
step
.isOnQuest 31927
.goto 115,59.02,76.79
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Okrut Dragonwaste|r and defeat them in a pet battle.
.complete 31927,3 
.skipgossip
step
.isQuestAvailable 31929
.isOnQuest 31927
.goto 115,59.02,76.82
>>Click on the Quest Pop-UP to |cFFFF0000ONLY|r turn in |cFFFF00001|r of Battle Pet Tamers: Northrend
*|cFFFF0000Keep the other one until launch night to turn it in for XP|r
*|cRXP_WARN_You can minimize the other pop-up and untrack the quest|r |cFFFF0000make sure all quest automation addons are off excluding RXP.|r
.turnin 31927 >>Turn in Battle Pet Tamers: Northrend
step
.isQuestAvailable 31927
.isOnQuest 31929
.goto 115,59.02,76.82
>>Click on the Quest Pop-UP to |cFFFF0000ONLY|r turn in |cFFFF00001|r of Battle Pet Tamers: Northrend
*|cFFFF0000Keep the other one until launch night to turn it in for XP|r
*|cRXP_WARN_You can minimize the other pop-up and untrack the quest|r |cFFFF0000make sure all quest automation addons are off excluding RXP.|r
.turnin 31929 >>Turn in Battle Pet Tamers: Northrend
step
.isOnQuest 31928
.goto 115,59.02,76.82
>>Click on the Quest Pop-UP to accept [Defeat Grand Master Payne]
*|cRXP_WARN_You can minimize the other pop-ups and untrack the quest|r |cFFFF0000make sure all quest automation addons are off excluding RXP.|r
.accept 31928 >>Accept Grand Master Payne
step
.isOnQuest 31928
#completewith next
.zone 118 >>Go to Icecrown
step
.isOnQuest 31928
.goto 118,77.28,19.73
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Major Payne|r and defeat them in a pet battle.
.complete 31928,1 
.skipgossip
step
.isOnQuest 31928
.goto 118,77.39,19.56
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Major Payne|r
.turnin 31928 >>Turn in Grand Master Payne
.target Major Payne
step
.isQuestAvailable 31966
#completewith next
+Log into your Level 1 Human
step
.isQuestAvailable 31966
.goto 84,69.48,25.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Audrey Burnhep|r
.accept 31966 >>Accept Battle Pet Tamers: Cataclysm
.target Audrey Burnhep
step
.isQuestAvailable 31967
#completewith next
+Log into your Level 1 Orc
step
.isQuestAvailable 31967
.goto 85,52.59,59.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Varzok|r
.accept 31967 >>Accept Battle Pet Tamers: Cataclysm
.target Varzok
step
.isOnQuest 31966,31967
#completewith next
>>|cRXP_WARN_Switch to a max-level character, either Horde or Alliance.|r
step
.isOnQuest 31966,31967
#completewith next
.zone 198 >>Go to Hyjal
step
.isOnQuest 31966
.goto 198,61.38,33.06
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brok|r and defeat them in a pet battle.
.complete 31966,1 
.skipgossip
step
.isOnQuest 31966,31967
#completewith next
.zone 198 >>Go to Hyjal
step
.isOnQuest 31967
.goto 198,61.38,33.06
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brok|r and defeat them in a pet battle.
.complete 31967,1 
.skipgossip
step
.isOnQuest 31966,31967
#completewith next
.zone 207 >>Go to Deepholm
step
.isOnQuest 31966
.goto 207,50.06,57.04
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bordin Steadyfist|r and defeat them in a pet battle.
.complete 31966,2 
.skipgossip
step
.isOnQuest 31966,31967
#completewith next
.zone 207 >>Go to Deepholm
step
.isOnQuest 31967
.goto 207,50.06,57.04
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bordin Steadyfist|r and defeat them in a pet battle.
.complete 31967,2 
.skipgossip
step
.isOnQuest 31966,31967
#completewith next
.zone 241 >>Go to Twillight Highlands
step
.isOnQuest 31966
.goto 241,56.45,56.99
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Goz Banefury|r and defeat them in a pet battle.
.complete 31966,3 
.skipgossip
step
.isOnQuest 31966,31967
#completewith next
.zone 241 >>Go to Twillight Highlands
step
.isOnQuest 31967
.goto 241,56.45,56.99
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Goz Banefury|r and defeat them in a pet battle.
.complete 31967,3 
.skipgossip
step
.isQuestAvailable 31967
.isOnQuest 31966
.goto 241,56.46,56.98
>>Click on the Quest Pop-UP to |cFFFF0000ONLY|r turn in |cFFFF00001|r of Battle Pet Tamers: Northrend
*|cFFFF0000Keep the other one until launch night to turn it in for XP|r
.turnin 31966 >>Turn in Battle Pet Tamers: Cataclysm
step
.isQuestAvailable 31966
.isOnQuest 31967
.goto 241,56.46,56.98
>>Click on the Quest Pop-UP to |cFFFF0000ONLY|r turn in |cFFFF00001|r of Battle Pet Tamers: Northrend
*|cFFFF0000Keep the other one until launch night to turn it in for XP|r
.turnin 31967 >>Turn in Battle Pet Tamers: Cataclysm
step
.isQuestAvailable 31970
.goto 241,56.46,56.98
>>Click on the Quest Pop-UP to accept Grand Master Obalis
*|cRXP_WARN_You can minimize the other pop-ups and untrack the quest|r |cFFFF0000make sure all quest automation addons are off excluding RXP.|r
.accept 31970 >>Accept Grand Master Obalis
step
.isOnQuest 31970
#completewith next
.zone 1527 >>Go to Uldum
step
.isOnQuest 31970
.goto 1527,54.32,37.48
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Obalis|r and defeat them in a pet battle.
.complete 31970,1 
.skipgossip
step
.isOnQuest 31970
.goto 1527,54.44,37.62
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Obalis|r
.turnin 31970 >>Turn in Grand Master Obalis
.target Obalis
step
.isQuestAvailable 31952
#completewith next
+Log into your Level 1 Orc
step
.isQuestAvailable 31952
.goto 85,52.56,59.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Varzok|r
.accept 31952 >>Accept Battle Pet Tamers: Pandaria
.target Varzok
step
.isQuestAvailable 31930
#completewith next
+Log into your Level 1 Human
step
.isQuestAvailable 31930
.goto 84,69.48,25.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Audrey Burnhep|r
.accept 31930 >>Accept Battle Pet Tamers: Pandaria
.target Audrey Burnhep
step
.isOnQuest 31952,31930
#completewith next
>>|cRXP_WARN_Switch to a max-level character, either Horde or Alliance.|r
step
.isOnQuest 31952,31930
#completewith next
.zone 371 >>Go to Jade Forest
step
.isOnQuest 31952
.goto 371,47.99,53.96
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hyuna of the Shrines|r and defeat them in a pet battle.
.complete 31952,1 
.target Hyuna of the Shrines
.skipgossip
step
.isOnQuest 31952,31930
#completewith next
.zone 371 >>Go to Jade Forest
step
.isOnQuest 31930
.goto 371,47.99,53.96
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hyuna of the Shrines|r and defeat them in a pet battle.
.complete 31930,1 
.target Hyuna of the Shrines
.skipgossip
step
.isOnQuest 31952,31930
#completewith next
.zone 376 >>Go to Valley of the Four Winds
step
.isOnQuest 31952
.goto 376,45.81,43.70
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farmer Nishi|r and defeat them in a pet battle.
.complete 31952,2 
.target Farmer Nishi
.skipgossip
step
.isOnQuest 31952,31930
#completewith next
.zone 376 >>Go to Valley of the Four Winds
step
.isOnQuest 31930
.goto 376,45.81,43.70
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farmer Nishi|r and defeat them in a pet battle.
.complete 31930,2 
.target Farmer Nishi
.skipgossip
step
.isOnQuest 31952,31930
#completewith next
.zone 418 >>Go to Krasarang Wilds
step
.isOnQuest 31952
.goto 418,62.04,45.78
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mo'ruk|r and defeat them in a pet battle.
.complete 31952,3 
.skipgossip
.target Mo'ruk
step
.isOnQuest 31952,31930
#completewith next
.zone 418 >>Go to Krasarang Wilds
step
.isOnQuest 31930
.goto 418,62.04,45.78
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mo'ruk|r and defeat them in a pet battle.
.complete 31930,3 
.skipgossip
step
.isOnQuest 31952,31930
#completewith next
.zone 422 >>Go to Dread Wastes
step
.isOnQuest 31952
.goto 422,54.94,37.44
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wastewalker Shu|r and defeat them in a pet battle.
.complete 31952,6 
.target Wastewalker Shu
.skipgossip
step
.isOnQuest 31952,31930
#completewith next
.zone 422 >>Go to Dread Wastes
step
.isOnQuest 31930
.goto 422,54.94,37.44
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wastewalker Shu|r and defeat them in a pet battle.
.complete 31930,6 
.target Wastewalker Shu
.skipgossip
step
.isOnQuest 31952,31930
#completewith next
.zone 379 >>Go to Kun-Lai Summit
step
.isOnQuest 31952
.goto 379,35.83,73.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Courageous Yon|r and defeat them in a pet battle.
.complete 31952,4 
.target Courageous Yon
.skipgossip
step
.isOnQuest 31952,31930
#completewith next
.zone 379 >>Go to Kun-Lai Summit
step
.isOnQuest 31930
.goto 379,35.83,73.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Courageous Yon|r and defeat them in a pet battle.
.complete 31930,4 
.target Courageous Yon
.skipgossip
step
.isOnQuest 31952,31930
#completewith next
.zone 388 >>Go to Townlong Steppes
step
.isOnQuest 31952
.goto 388,36.22,52.42
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Seeker Zusshi|r and defeat them in a pet battle.
.complete 31952,5 
.target Seeker Zusshi
.skipgossip
step
.isOnQuest 31952,31930
#completewith next
.zone 388 >>Go to Townlong Steppes
step
.isOnQuest 31930
.goto 388,36.22,52.42
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Seeker Zusshi|r and defeat them in a pet battle.
.complete 31930,5 
.target Seeker Zusshi
.skipgossip
*We no longer need the level 1 characters.
step
.isOnQuest 31952
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Battle Pet Tamers: Pandaria Horde] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
.isOnQuest 31930
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Battle Pet Tamers: Pandaria Alliance] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
.isOnQuest 31967
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Battle Pet Tamers: Cataclysm Horde] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
.isOnQuest 31966
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Battle Pet Tamers: Cataclysm Alliance] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
.isOnQuest 31929
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Battle Pet Tamers: Northend Horde] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
.isOnQuest 31927
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Battle Pet Tamers: Northend Alliance] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
.isOnQuest 31921
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Battle Pet Tamers: Outland Horde] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
.isOnQuest 31919
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Battle Pet Tamers: Outland Alliance] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
.isOnQuest 31903
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Battle Pet Tamers: Eastern Kingdoms Horde] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
.isOnQuest 31902
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Battle Pet Tamers: Eastern Kingdoms Alliance] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
.isOnQuest 31891
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Battle Pet Tamers: Kalimdor Horde] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
.isOnQuest 31889
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Battle Pet Tamers: Kalimdor Alliance] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
>>|cRXP_WARN_Switch to a max-level or class trial alliance character|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
#completewith Lindsay1
.zone 84 >> Go Stormwind
step
.isQuestAvailable 31850
.goto 47,19.87,44.59
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eric Davidson|r
.daily 31850 >>Accept Eric Davidson
.target Eric Davidson
step
.isOnQuest 31850
.goto 47,19.87,44.59
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eric Davidson|r and defeat them in a pet battle.
.complete 31850,1 
.skipgossip
.target Eric Davidson
step
.isQuestComplete 31850
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Eric Davidson] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|
step
.isQuestAvailable 31851
.goto 210,51.49,73.44
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bill Buckler|r
.daily 31851 >>Accept Bill Buckler
.target Bill Buckler
step
.isOnQuest 31851
.goto 210,51.49,73.44
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bill Buckler|r and defeat them in a pet battle.
.complete 31851,1 
.skipgossip
.target Bill Buckler
step
.isQuestComplete 31851
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Bill Buckler] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
.isQuestAvailable 31781
.goto 49,33.29,52.58
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lindsay|r
.daily 31781 >>Accept Lindsay
.target Lindsay
step
#label Lindsay1
.isOnQuest 31781
.goto 49,33.29,52.58
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lindsay|r and defeat them in a pet battle.
.complete 31781,1 
.skipgossip
.target Lindsay
step
.isQuestComplete 31781
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Lindsay] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
>>|cRXP_WARN_Switch to a max-level or class trial horde character|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|
step
#completewith DagraFierce
.isQuestAvailable 31819
.zone 85 >> Go Orgrimmar
step
.isQuestAvailable 31819
.goto 10,58.61,53.05
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dagra the Fierce|r
.daily 31819 >>Accept Dagra the Fierce
.target Dagra the Fierce
step
#label DagraFierce
.isOnQuest 31819
.goto 10,58.61,53.05
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dagra the Fierce|r and defeat them in a pet battle.
.complete 31819,1 
.skipgossip
.target Dagra the Fierce
step
.isQuestComplete 31819
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Dagra the Fierce] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
>>|cRXP_WARN_Switch to a max-level or class trial horde or alliance character|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|
step
#completewith Defeat Major Payne
.isQuestAvailable 31935
.zone 118 >> Go to Icecrown
step
.isQuestAvailable 31935
.goto 118,77.28,19.73
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grand Master Payne|r and defeat them in a pet battle.
.daily 31935 >>Accept Grand Master Payne
.target Grand Master Payne
step
#label Defeat Major Payne
.isOnQuest 31935
.goto 118,77.28,19.73
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grand Master Payne|r and defeat them in a pet battle.
.complete 31935,1 
.skipgossip
step
.isQuestComplete 31935
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Grand Master Payne] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
#completewith Shattrath
.isQuestAvailable 31925
.zone 111 >> Go to Shattrath
step
.isQuestAvailable 31925
.goto 111,59.51,69.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Morulu the Elder|r and defeat them in a pet battle.
.daily 31925 >>Accept Morulu the Elder
.target Morulu the Elder
step
#label Shattrath
.isOnQuest 31925
.goto 111,59.51,69.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Morulu the Elder|r and defeat them in a pet battle.
.complete 31925,1 
.skipgossip
.target Morulu the Elder
step
.isQuestComplete 31925
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Obalis] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
#completewith Defeat Obalis
.isQuestAvailable 31971
.zone 1527 >> Go to Uldum
step
.isQuestAvailable 31971
.goto 1527,54.45,37.65
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Obalis|r
.daily 31971 >>Accept Grand Master Obalis
.target Obalis
step
#label Defeat Obalis
.isOnQuest 31971
.goto 1527,54.45,37.65
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Obalis|r and defeat them in a pet battle.
.complete 31971,1 
.skipgossip
.target Obalis
step
.isQuestComplete 31971
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Obalis] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
#completewith Defeat Nearly Headless Jacob
.isQuestAvailable 31932
.zone 127 >> Go to Crstalsong Forest
step
.isQuestAvailable 31932
.goto 127,50.09,58.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nearly Headless Jacob|r
.daily 31932 >>Accept Nearly Headless Jacob
.target Nearly Headless Jacob
step
#label Defeat Nearly Headless Jacob
.isOnQuest 31932
.goto 127,50.09,58.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nearly Headless Jacob|r and defeat them in a pet battle.
.complete 31932,1 
.skipgossip
.target Nearly Headless Jacob
step
.isQuestComplete 31932
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Nearly Headless Jacob] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
#completewith Defeat Bordin Steadyfist
.isQuestAvailable 31973
.zone 207 >> Go to Deepholm
step
.isQuestAvailable 31973
.goto 207,49.87,57.06
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bordin Steadyfist|r
.daily 31973 >>Accept Bordin Steadyfist
.target Bordin Steadyfist
step
#label Defeat Bordin Steadyfist
.isOnQuest 31973
.goto 207,49.87,57.06
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bordin Steadyfist|r and defeat them in a pet battle.
.complete 31973,1 
.target Bordin Steadyfist
step
.isQuestComplete 31973
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Bordin Steadyfist] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
#completewith Defeat Gutretch
.isQuestAvailable 31934
.zone 121 >> Go to Zul'drak
step
.isQuestAvailable 31934
.goto 121,13.25,66.79
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gutretch|r
.daily 31934 >>Accept Gutretch
.target Gutretch
step
#label Defeat Gutretch
.isOnQuest 31934
.goto 121,13.25,66.79
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gutretch|r and defeat them in a pet battle.
.complete 31934,1 
.skipgossip
.target Gutretch
step
.isQuestComplete 31934
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Gutretch] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
#completewith Defeat Brok
.isQuestAvailable 31972
.zone 198 >> Go to Hyal
step
.isQuestAvailable 31972
.goto 198,61.39,32.71
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brok|r
.daily 31972 >>Accept Brok
.target Brok
step
#label Brok
.isOnQuest 31972
.goto 198,61.39,32.71
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brok|r and defeat them in a pet battle.
.complete 31972,1 
.skipgossip
.target Brok
step
.isQuestComplete 31972
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Brok] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
#completewith Defeat Goz Banefury
.isQuestAvailable 31974
.zone 241 >> Go to Twillight Highlands
step
.isQuestAvailable 31974
.goto 241,56.59,56.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Goz Banefury|r
.daily 31974 >>Accept Goz Banefury
.target Goz Banefury
step
#label Defeat Goz Banefury
.isOnQuest 31974
.goto 241,56.59,56.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Goz Banefury|r and defeat them in a pet battle.
.complete 31974,1 
.skipgossip
.target Goz Banefury
step
.isQuestComplete 31974
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Goz Banefury] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step <<DarkIronDwarf
#completewith Defeat Bloodknight Antari
.isQuestAvailable 31926
.zone 104 >>Go to Shadowmoon Valley(Outland)
step <<DarkIronDwarf
.goto 104,30.51,41.76
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bloodknight Antari|r
.target Bloodknight Antari
.daily 31926 >>Accept Grand Master Antari
step <<DarkIronDwarf
#label Defeat Bloodknight Antari
.goto 104,30.43,42.00
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bloodknight Antari|r and defeat them in a pet battle.
.complete 31926,1 
.target Bloodknight Antari
step <<DarkIronDwarf
.isQuestComplete 31926
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Grand Master Antari] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
step
#completewith Rescue Gurgl
.isQuestAvailable 64167
.zone 627 >> Go to Legion Dalaran
step
.isQuestAvailable 64167
.goto 627,58.47,39.14
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Breanni|r
.accept 64167 >>Accept Pets Detective
.target Breanni
step
.isOnQuest 64167
.goto 627,47.97,31.89
>>|cRXP_WARN_Follow the Arrow|r
.complete 64167,1 
step
.isOnQuest 64167
.goto 627,47.97,31.89
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Suspicious Onlooker|r
.complete 64167,2 
.skipgossip
.target Suspicious Onlooker
step
.isOnQuest 64167
.goto 627,57.09,55.78
>>|cRXP_WARN_Follow the Arrow|r
.complete 64167,3 
step
.isOnQuest 64167
.goto 627,57.09,55.78
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Precocious Onlooker|r
.complete 64167,4 
.skipgossip
.target Precocious Onlooker
step
.isOnQuest 64167
.goto 627,55.48,82.13
>>|cRXP_WARN_Follow the Arrow|r
.complete 64167,5 
.skipgossip
step
.isOnQuest 64167
.goto 627,55.48,82.13
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farsighted Onlooker|r
.complete 64167,6 
.skipgossip
.target Farsighted Onlooker
step
.isOnQuest 64167
.goto 627,58.45,39.18
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Breanni|r
.turnin 64167 >>Turn in Pets Detective
step
.isOnQuest 64196
.goto 627,58.45,39.18
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Breanni|r
.accept 64196 >>Accept Pet Up
.target Breanni
step
.isOnQuest 64196
.goto 790,74.24,67.69
>>|cRXP_WARN_Follow the Arrow|r
.complete 64196,1 
step
.isOnQuest 64196
.goto 790,74.24,67.69
>>Interact with |cRXP_FRIENDLY_Stringfellowe|r |cRXP_WARN_If you have any instant heal abilities use those instead.|r
.complete 64196,3 
.use 186695
.target Stringfellowe
step
.isOnQuest 64196
.goto 790,73.24,74.98
>>Interact with |cRXP_FRIENDLY_Zantini|r |cRXP_WARN_If you have any instant heal abilities use those instead.|r
.complete 64196,2 
.use 186695
.target Zantini
step
.isOnQuest 64196
.goto 790,73.56,77.97
>>Interact with |cRXP_FRIENDLY_Speedy IV|r |cRXP_WARN_If you have any instant heal abilities use those instead.|r
.complete 64196,4 
.use 186695
.target Speedy IV
step
.isOnQuest 64196
.goto 790,73.24,74.96
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zantini|r
.turnin 64196 >>Turn in Pet Up
.target Zantini
step
.isOnQuest 64203
.goto 790,73.24,74.96
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zantini|r
.target Zantini
.accept 64203 >>Accept The Coast is Clear
step
.isOnQuest 64203
.goto 790,73.41,74.64
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Speedy IV|r
.complete 64203,1 
.skipgossip
.target Speedy IV
step
.isOnQuest 64203
#loop
.goto 790,74.27,67.48,25,0
.goto 790,70.44,63.92,25,0
.goto 790,70.87,61.27,25,0
.goto 790,74.04,58.45,25,0
.goto 790,75.6,52.12,25,0
.goto 790,75.79,50.99,25,0
.goto 790,77.76,53.94,25,0
.goto 790,77.77,55.64,25,0
.goto 790,76.63,57.5,25,0
.goto 790,78.37,62.19,25,0
.goto 790,78.13,64.57,25,0
.goto 790,78.12,66.13,25,0
.goto 790,75.89,63.45,25,0
>>Use |T839982:0|t[Spin'N Stun] near enemies to stun them make sure after clicking on the |cRXP_PICK_pet supplies|r to use |T965900:0|t[Dart] to sprint away
.complete 64203,2 
step
.isOnQuest 64203
.goto 790,73.23,74.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zantini|r
.turnin 64203 >>Turn in The Coast is Clear
.target Zantini
step
.isOnQuest 64215
.goto 790,73.23,74.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zantini|r
.target Zantini
.accept 64215 >>Accept Paw Patrol
step
.isOnQuest 64215
#loop
.goto 790,43.39,42.56,30,0
.goto 790,40.08,42.77,30,0
.goto 790,43.4,38.99,30,0
.goto 790,45.53,37.37,30,0
.goto 790,42.92,35.28,30,0
.goto 790,46.96,36.41,30,0
.goto 790,48.55,34.25,30,0
.goto 790,49.73,33.14,30,0
>>Kill |cRXP_ENEMY_Violetsail Cutthroat|r, |cRXP_ENEMY_Violetsail Swiftshot|r and |cRXP_ENEMY_Violetsail Bruisebringer.|r Loot them for |T134242:0|t[Violetsail Pet Cage Key.]
*Use the keys to open |cRXP_PICK_Cages.|r
.complete 64215,1 
.collect 186772,6,64215,0x1,-1
.mob Violetsail Cutthroat
.mob Violetsail Swiftshot
.mob Violetsail Bruisebringer
step
.isOnQuest 64215
.goto 790,73.23,74.96
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zantini|r
.turnin 64215 >>Turn in Paw Patrol
.target Zantini
step
.isOnQuest 64237
.goto 790,73.23,74.96
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zantini|r
.target Zantini
.accept 64237 >>Accept Gurgl and the Bandit
step
.isOnQuest 64237
.goto 790,31.96,58.16
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Trainer Iris Greedsway|r and defeat her in a pet battle.
.complete 64237,1 
.skipgossip
.target Trainer Iris Greedsway
step
#label Rescue Gurgl
.isOnQuest 64237
.goto 790,32.08,58.20
>>Interact with |cRXP_FRIENDLY_Gurgl|r
.complete 64237,2 
.target Gurgl
step
.isOnQuest 64237
*|cRXP_WARN_DO NOT TURN IN THE QUEST:|r [Gurgl and the Bandit] |cRXP_WARN_BEFORE THE WAR WITHIN EXPANSION HAS LAUNCHED.|r
+|cFFFF0000To proceed in the guide, simply click on the circle next to this text to manually skip this step.|r
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Human Heritage Armor
#displayname |cRXP_WARN_Chapter 4 -|r Human Heritage Quests
#next 6) Item Information
<<Alliance Human
step
#sticky
*|cRXP_WARN_Chapter 0:|r Warband Quests
*Guides you through the heritage armor questline and stops when you have the optimal quests set up, ready to turn in for the best experience at launch.
+|cRXP_WARN_This questline can only be completed once per account.|r
step
#completewith next
.zone 84 >> Go to Stormwind
step
.goto 84,54.47,20.09
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Agent Render|r
.accept 75265 >>Accept An Urgent Matter
.target Agent Render
step
.goto 84,87.45,30.79
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Mathias Shaw|r |cRXP_WARN_behind the house.|r
.turnin 75265 >>Turn in An Urgent Matter
.target Master Mathias Shaw
.accept 72405 >>Accept An Unlikely Informant
step
.isOnQuest 72405
.goto 37,43.06,65.68,10 >>Enter Lion's Pride Inn
step
.goto 37,43.22,66.09,5,0
.goto 37,43.77,65.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Innkeeper Farlay|r
.home >>Set your Hearthstone to Lion's Pride Inn
.target Innkeeper Farlay
step
.isOnQuest 72405
.goto 37,44.05,66.07,5,0
.goto 37,44.46,65.74,10 >>Enter Lion's Pride Inn basement
step
.isOnQuest 72405
.goto 37,44.34,66.21
.gossipoption 107712 >>Talk to |cRXP_FRIENDLY_Master Mathias Shaw|r
.timer 26,RP
.target Master Mathias Shaw
step
.goto 37,44.34,66.19
>>|cRXP_WARN_Wait until the objective is complete.
.complete 72405,1 
step
.goto 37,44.34,66.19
>>|r|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Mathias Shaw|r
.turnin 72405 >>Turn in An Unlikely Informant
.target Master Mathias Shaw
.accept 72408 >>Accept A Window to the Past
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shaw|r
*|cFFFF0000After completing the objective, you can skip the cutscene by pressing 'Escape' and accepting the prompt.|r
.complete 72408,1 
.skipgossip
.target Shaw
step
.goto 37,44.34,66.05
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vanessa VanCleef|r
.turnin 72408 >>Turn in A Window to the Past
.target Vanessa VanCleef
.accept 72409 >>Accept Rotten Old Memories
step
.isOnQuest 72409
.goto 37,44.46,65.74,10,0
.goto 37,44.09,66.04,10,0
.goto 37,43.16,65.95,10,0
.goto 37,43.19,65.63,8,0
.goto 37,42.86,65.63,8 >>Leave Lion's Pride Inn basement
step
.goto 36,72.86,64.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ragged John|r
.complete 72409,1 
.skipgossip 9563,1,1,1,1,2
.target Ragged John
step
.isOnQuest 72409
.goto 36,61.99,65.07,10 >>Go inside the Cave
step
.goto 36,61.76,66.76
>>Click on |cRXP_PICK_Hoarded Debris.|r
.complete 72409,2,1 
.mob Vicious Ember Worg
step
.goto 36,61.21,67.24
>>Click on |cRXP_PICK_Hoarded Debris.|r
.complete 72409,2,2 
.mob Vicious Ember Worg
step
.goto 36,60.24,66.23
>>Click on |cRXP_PICK_Hoarded Debris.|r
.complete 72409,2,3 
.mob Vicious Ember Worg
step
.goto 36,61.28,65.28
>>Click on |cRXP_PICK_Hoarded Debris.|r
.complete 72409,2,4 
.mob Vicious Ember Worg
step
.isOnQuest 72409
.goto 36,61.99,65.07,10 >>Leave the Cave
step
.goto 36,72.84,64.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ragged John|r
.turnin 72409 >>Turn in Rotten Old Memories
.target Ragged John
.accept 72424 >>Accept Looking for Something Specific
step
.isOnQuest 72424
.goto 37,43.13,65.68,10,0
.goto 37,43.2,66.1,10,0
.goto 37,44.11,66.06,10,0
.goto 37,44.46,65.74,10 >>Enter Lion's Pride Inn basement
step
.goto 37,44.33,66.22
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Mathias Shaw|r
.turnin 72424 >>Turn in Looking for Something Specific
.target Master Mathias Shaw
.accept 72426 >>Accept The New Clessington Estate
step
.isOnQuest 72426
.goto 37,44.46,65.74,10,0
.goto 37,44.09,66.04,10,0
.goto 37,43.16,65.95,10,0
.goto 37,43.19,65.63,8,0
.goto 37,42.86,65.63,8 >>Leave Lion's Pride Inn basement
step
#completewith next
.goto 47,18.04,55.13,10 >>Enter the House
step
.goto 47,17.45,55.22,10,0
.goto 47,18.04,54.65,5,0
.goto 47,18.06,54.01
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cecilia Clessington|r
.complete 72426,1 
.skipgossip 198912,1
.target Cecilia Clessington
step
#completewith escorted
.goto 47,17.88,54.81,10,0
.goto 47,17.54,54.72,10,0
.goto 47,18.04,55.39,10 >>Leave the Building
*Kill |cRXP_ENEMY_Clessington Attendants|r
.mob Clessington Attendant
step
#completewith escorted
.goto 47,18.34,54.63,5 >>Follow the Arrow
*Kill |cRXP_ENEMY_Clessington Attendants|r
.mob Clessington Attendant
step
#label escorted
.goto 47,18.35,55.07
>>Wait for the Objective to complete.
.complete 72426,2 
.mob Clessington Attendant
.target Cecilia Clessington
step
.goto 47,18.35,55.07
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cecilia Clessington|r
.complete 72426,3 
.skipgossip 198912,1
.target Cecilia Clessington
step
.goto 47,18.35,55.07
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cecilia Clessington|r
.turnin 72426 >>Turn in The New Clessington Estate
.target Cecilia Clessington
step
.goto 47,18.32,54.98
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vanessa VanCleef|r
.accept 72430 >>Accept Misdeeds in Moonbrook
.target Vanessa VanCleef
step
.goto 52,46.72,66.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vanessa VanCleef|r
.turnin 72430 >>Turn in Misdeeds in Moonbrook
.target Vanessa VanCleef
step
.goto 52,46.72,66.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vanessa VanCleef|r
.accept 72431 >>Accept A Hungry Heritage
.target Vanessa VanCleef
step
.goto 52,46.74,66.74
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cecilia Clessington|r
.accept 72432 >>Accept Supply Only the Finest Goons
.target Cecilia Clessington
step
#completewith Count Clessington
>>Kill |cRXP_ENEMY_Clessington Attendants|r
.complete 72432,1 
.mob Clessington Attendant
step
.goto 52,42.60,71.96
>>|cRXP_WARN_Follow the Arrow|r
.complete 72431,1 
step
#label Count Clessington
.isOnQuest 72431
.goto 52,43.36,71.91,10,0
.goto 52,42.78,72.6,10,0
.goto 52,43.37,72.66,5,0
.goto 52,43.65,72.81,10,0
.goto 52,43.3,72.98,10,0
.goto 55,69.27,22.87,10,0
.goto 55,65.89,25.58,10 >>|cRXP_WARN_Follow the Arrow|r
step
.isOnQuest 72431
.goto 55,62.34,30.28,10 >> Jump Down
step
.isOnQuest 72431
.goto 55,49.56,42.05,10,0
.goto 55,51.58,53.49,10,0
.goto 55,58.03,58.81,10 >>|cRXP_WARN_Follow the Arrow|r
.timer 60,RP
step
#sticky
>>|cRXP_WARN_Follow the Arrow|r
.complete 72431,2 
step
.goto 55,49.41,49.63,10,0
.goto 55,50.94,41.01,10,0
.goto 55,63.63,15.28,10,0
.goto 55,59.69,18.33,10,0
.goto 55,66.17,26.3,10,0
.goto 55,70.24,21.8,10,0
.goto 52,43.3,72.95,10,0
.goto 52,43.36,72.72,5,0
.goto 52,42.89,72.73,5,0
.goto 52,42.98,71.73,10,0
.goto 52,42.57,72.02,5 >> Leave the Cave
step
#sticky
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vanessa VanCleef|r |cRXP_WARN_next to you|r
.target Vanessa VanCleef
.turnin 72431 >>Turn in A Hungry Heritage
step
.goto 52,45.22,68.06
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vanessa VanCleef|r
.target Vanessa VanCleef
.accept 72453 >>Accept Betrayal of the Brotherhood
step
#loop
.goto 52,42.77,68.77,40,0
.goto 52,45.62,68.77,40,0
.goto 52,42.56,71.82,40,0
>>Kill |cRXP_ENEMY_Clessington Attendants|r
*|cRXP_WARN_You can use the|r [ExtraActionButton] to increase your movement speed.
.complete 72432,1 
.mob Clessington Attendant
step
#completewith next
.goto 52,46.88,66.62,10 >>Follow the Arrow
.timer 5, RP
step
>>|cRXP_WARN_Follow the Arrow|r
*|cRXP_WARN_You can use the|r [ExtraActionButton] to increase your movement speed.
.complete 72453,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vanessa VanCleef|r, |cRXP_FRIENDLY_Cecilia Clessington|r and |cRXP_FRIENDLY_Master Mathias Shaw.|r
.turnin 72453 >>Turn in Betrayal of the Brotherhood
.goto 52,46.65,66.78
.target +Vanessa VanCleef
.turnin 72432 >>Turn in Supply Only the Finest Goons
.goto 52,46.74,66.75
.target +Cecilia Clessington
.accept 72445 >>Accept To Northshire
.goto 52,46.72,66.71
.target +Master Mathias Shaw
step
#completewith next
.hs >>Hearth to Lion's Pride Inn
step
.goto 425,27.90,66.76
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Mathias Shaw|r
.turnin 72445 >>Turn in To Northshire
.target Master Mathias Shaw
.accept 72449 >>Accept Knock It Off!
step
.goto 425,27.70,66.70
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal McBride|r
.accept 72446 >>Accept What's Their Problem?
.target Marshal McBride
step
#completewith Enforcer Horb's Signet
>>Kill |cRXP_ENEMY_Defias,|r |cRXP_ENEMY_Confused Citizens|r and |cRXP_ENEMY_Clessington Attendant|r
.complete 72446,1 
.mob Clessington Attendant
.mob Confused Acolyte
.mob Confused Commoner
.mob Confused Recruit
.mob Defias Bandit
.mob Defias Mage
step
.goto 425,35.61,61.23
>>Kill |cRXP_ENEMY_Enforcer Grant.|r Loot them for |cRXP_LOOT_Enforcer Grant's Signet|r
.complete 72449,1 
.mob Enforcer Grant
step
.goto 425,49.52,62.61
>>Kill |cRXP_ENEMY_Enforcer Jennive.|r Loot them for |cRXP_LOOT_Enforcer Jennive's Signet|r
.complete 72449,2 
.mob Enforcer Jennive
step
.goto 425,35.32,39.05
>>Kill |cRXP_ENEMY_Enforcer Tera.|r Loot them for |cRXP_LOOT_Enforcer Tera's Signet|r
.complete 72449,3 
.mob Enforcer Tera
step
#label Enforcer Horb's Signet
.goto 425,31.25,19.24
>>Kill |cRXP_ENEMY_Enforcer Horb.|r Loot them for |cRXP_LOOT_Enforcer Horb's Signet|r
.complete 72449,4 
.mob Enforcer Horb
step
#loop
.goto 425,26.88,48.3,40,0
.goto 425,32.24,54.67,40,0
.goto 425,37.41,59.37,40,0
.goto 425,47.25,59.06,40,0
.goto 425,43.14,46.45,40,0
.goto 425,31.35,21.82,40,0
>>Kill |cRXP_ENEMY_Defias,|r |cRXP_ENEMY_Confused Citizens|r and |cRXP_ENEMY_Clessington Attendant|r
.complete 72446,1 
.mob Clessington Attendant
.mob Confused Acolyte
.mob Confused Commoner
.mob Confused Recruit
.mob Defias Bandit
.mob Defias Mage
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Nightelf Heritage Armor
#displayname |cRXP_WARN_Chapter 4 -|r Nightelf Heritage Quests
#next 6) Item Information
<<Alliance NightElf
step
#sticky
*|cRXP_WARN_Chapter 0:|r Warband Quests
*Guides you through the heritage armor questline and stops when you have the optimal quests set up, ready to turn in for the best experience at launch.
+|cRXP_WARN_This questline can only be completed once per account.|r
step
#completewith next
.zone 84 >> Go to Stormwind
step
.goto 84,52.3,14.2
>>Click on the |cRXP_PICK_Scroll|r
.accept 75890 >>Accept Clarion Call
step
.goto 84,52.34,4.52
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Arko'narin Starshade|r
.turnin 75890 >>Turn in The Clarion Call
.target Arko'narin Starshade
.accept 75891 >>Accept Ancient Curses
step
#completewith next
.goto 84,76.16,18.7
.zone 198 >> Take the Portal to Twillight Highlands
step
.goto 12,47.67,30.61,10 >>|cRXP_WARN_Follow the Arrow|r
.timer 30,RP
step
.goto 12,47.67,30.61
>>Wait for the objective to complete.
.complete 75891,1 
.target Maiev Shadowsong
step
.goto 12,47.67,30.61
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Maiev Shadowsong|r
.turnin 75891 >>Turn in Ancient Curses
.target Maiev Shadowsong
.accept 76194 >>Accept A Grim Portent
step
.isOnQuest 76194
.goto 12,47.67,30.62
.gossipoption 110344 >>Talk to |cRXP_FRIENDLY_Arko'narin|r
.timer 30,RP
.target Arko'narin
step
.goto 12,47.67,30.61
>>Wait for the objective to complete.
.complete 76194,1 
step
.goto 12,47.68,30.61
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Maiev Shadowsong|r
.turnin 76194 >>Turn in A Grim Portent
.target Maiev Shadowsong
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lysander Starshade|r and |cRXP_FRIENDLY_Arko'narin Starshade|r
.accept 76195 >>Accept Countering Corruption
.goto 12,47.68,30.62
.target +Lysander Starshade
.accept 76196 >>Accept Mercy or Misery
.goto 12,47.66,30.61
.target +Arko'narin Starshade
step
#hidewindow
#completewith Kill enemies in Jaedenar
#loop
.goto 12,47.55,30.78,30,0
.goto 12,47.42,30.62,30,0
.goto 12,47.33,30.47,30,0
.goto 12,47.34,30.36,30,0
.goto 12,47.47,30.44,30,0
.goto 12,47.48,30.3,30,0
+1
step
#completewith next
>>Kill |cRXP_ENEMY_Feltouched Trickster,|r |cRXP_ENEMY_Feltouched Conjurer,|r |cRXP_ENEMY_Jaedenar Warrior|r and |cRXP_ENEMY_Jaedenar Scoundrel|r
.complete 76196,1 
.mob Feltouched Trickster
.mob Jaedenar Warrior
.mob Jaedenar Scoundrel
.mob Feltouched Conjurer
step
>>Use |T134544:0|t[Incanter's Tome] on dead |cRXP_ENEMY_Feltouched Trickster|r and |cRXP_ENEMY_Feltouched Conjurer.|r
.complete 76195,1 
.use 207004
step
#label Kill enemies in Jaedenar
>>Kill |cRXP_ENEMY_Feltouched Trickster,|r |cRXP_ENEMY_Feltouched Conjurer,|r |cRXP_ENEMY_Jaedenar Warrior|r and |cRXP_ENEMY_Jaedenar Scoundrel|r
.complete 76196,1 
.mob Feltouched Trickster
.mob Jaedenar Warrior
.mob Jaedenar Scoundrel
.mob Feltouched Conjurer
step
.goto 77,36.14,57.90
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Maiev Shadowsong|r
.turnin 76195 >>Turn in Countering Corruption
.turnin 76196 >>Turn in Mercy or Misery
.target Maiev Shadowsong
.accept 76203 >>Accept Stepping into the Shadows
step
.goto 77,36.14,57.90
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Maiev Shadowsong|r
.complete 76203,1 
.skipgossip 202702,1
.target Maiev Shadowsong
step
#completewith Maiev Shadowsong1
+Stay close to |cRXP_FRIENDLY_Maiev Shadowsong|r
step
.goto 77,36.18,56.85
>>Click on |cRXP_PICK_Felflame Brazier|r
.complete 76203,2,1 
step
.goto 77,36.83,56.17
>>Click on |cRXP_PICK_Felflame Brazier|r
.complete 76203,2,2 
step
.goto 77,37.07,55.38
>>Click on |cRXP_PICK_Felflame Brazier|r
.complete 76203,2,3 
step
.goto 77,37.17,54.67
>>Click on |cRXP_PICK_Felflame Brazier|r
.complete 76203,2,4 
step
.goto 77,37.92,54.77
>>Click on |cRXP_PICK_Felflame Brazier|r
.complete 76203,2,5 
step
.goto 77,38.46,54.4
>>Click on |cRXP_PICK_Felflame Brazier|r
.complete 76203,2,6 
step
#label Maiev Shadowsong1
.goto 77,38.40,53.96
>>|cRXP_WARN_Follow the Arrow|r
.complete 76203,3 
.timer 5, RP
step
.goto 77,38.06,53.67
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Maiev Shadowsong|r
.turnin 76203 >>Turn in Stepping into the Shadows
.target Maiev Shadowsong
.accept 76197 >>Accept A Glimpse of Terro
step
.goto 77,37.85,52.77
>>Kill |cRXP_ENEMY_Cultist Nethus|r
.complete 76197,1 
.mob Cultist Nethus
step
.goto 77,36.71,51.63
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Maiev Shadowsong|r
.turnin 76197 >>Turn in A Glimpse of Terror
.target Maiev Shadowsong
.accept 76205 >>Accept Balancing the Scales
step
.goto 77,36.68,51.65
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lysander Starshade|r
.accept 76206 >>Accept Heart of the Issue
.target Lysander Starshade
step
#completewith Portals
>>Kill |cRXP_ENEMY_Hel'nurathian Hel'nurathian Cultist,|r |cRXP_ENEMY_Hel'nurathian Defender|r and |cRXP_ENEMY_Hel'nurathian Felmaw.|r
.complete 76205,1 
.mob Hel'nurathian Cultist
.mob Hel'nurathian Defender
.mob Hel'nurathian Felmaw
step
#sticky
.complete 76206,1,1 
step
.isOnQuest 76206
.goto 77,39.02,50.33
.cast 416036 >>Click on the |cRXP_PICK_Portals|r
step
#sticky
.complete 76206,1,2 
step
.isOnQuest 76206
.goto 77,39.58,49.62,5,0
.goto 77,39.83,50.04,5,0
.goto 77,39.9,49.59,5,0
.goto 77,39.68,49.9,5,0
.goto 77,39.95,49.91,5,0
.goto 77,39.33,46.66,5,0
.goto 77,41.13,48.39
.complete 76206,1,2 
step
#sticky
.isOnQuest 76206
.complete 76206,1,3 
step
.isOnQuest 76206
.goto 77,40.88,48.5,10,0
.goto 77,41.04,49.6
.cast 416036 >>Click on the |cRXP_PICK_Portals|r
step
#sticky
.isOnQuest 76206
.complete 76206,1,4 
step
.isOnQuest 76206
#label Portals
.goto 77,40.48,47.51,10,0
.goto 77,39.29,46.93
.cast 416036 >>Click on the |cRXP_PICK_Portals|r
step
>>Kill |cRXP_ENEMY_Hel'nurathian Hel'nurathian Cultist,|r |cRXP_ENEMY_Hel'nurathian Defender|r and |cRXP_ENEMY_Hel'nurathian Felmaw.|r
.complete 76205,1 
.mob Hel'nurathian Cultist
.mob Hel'nurathian Defender
.mob Hel'nurathian Felmaw
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Maiev Shadowsong|r and |cRXP_FRIENDLY_Arko'narin Starshade|r
.turnin 76205 >>Turn in Balancing the Scales
.goto 77,37.98,46.21
.target +Maiev Shadowsong
.turnin 76206 >>Turn in Heart of the Issue
.goto 77,37.93,46.26
.target +Arko'narin Starshade
step
.goto 77,38.49,45.66,10,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Arko'narin Starshade|r
.accept 76207 >>Accept Wardens' Wrath
.target Arko'narin Starshade
step
.goto 77,38.58,46.62
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Maiev Shadowsong|r
.target Maiev Shadowsong
.complete 76207,1 
.skipgossip
step
.goto 77,38.11,47.37
>>Defend |cRXP_FRIENDLY_Lysander|r
*|cFFFF0000After completing the objective, you can skip the cutscene by pressing 'Escape' and accepting the prompt.|r
.complete 76207,2 
.mob Hel'nurathian Eye
.mob Hel'nurathian Felmaw
step
.goto 12,47.41,30.37
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lysander Starshade|r
.turnin 76207 >>Turn in Wardens' Wrath
.target Lysander Starshade
step
.goto 12,47.42,30.39
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Maiev Shadowsong|r
.accept 76212 >>Accept A Mark For A Protector
.target Maiev Shadowsong
step
.goto 12,47.4,30.36
>>|cRXP_WARN_Follow the Arrow|r
.complete 76212,1 
step
#completewith next
.goto 12,47.4,30.36
.cast 421556 >>|cRXP_WARN_Use the|r [ExtraActionButton]
.timer 82,RP
step
>>Wait for the Objective to complete.
.complete 76212,2 
step
#completewith next
.goto 12,47.42,30.38
.zone 84 >> Take the Portal to Stormwind
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Dwarf Heritage Armor
#displayname |cRXP_WARN_Chapter 4 -|rDwarf Heritage Quests
#next 6) Item Information
<<Alliance Dwarf
step
#sticky
*|cRXP_WARN_Chapter 0:|r Warband Quests
*Guides you through the heritage armor questline and stops when you have the optimal quests set up, ready to turn in for the best experience at launch.
+|cRXP_WARN_This questline can only be completed once per account.|r
step
.goto 84,54.61,18.11
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Digger Golad|r
.accept 53838 >>Accept Keep Yer Feet On The Ground
.target Digger Golad
step
#completewith missing excavators
.zone 27 >>Go to Dun Morogh
step
#completewith missing excavators
.goto 27,68.08,48.91 >> Enter the Cave
step
#label missing excavators
.goto 31,38.47,54.23,10,0
.goto 31,50.87,20.89,10,0
.goto 31,39.69,22.64
>>|cRXP_WARN_Follow the Arrow|r
.complete 53838,1 
step
.goto 31,39.80,22.55
>>Kill |cRXP_ENEMY_Maw'roc the Thief|r
.complete 53838,2 
.mob Maw'roc the Thief
step
.goto 31,39.80,22.55
>>Click on the |cRXP_PICK_Ancient Tablet|r
.turnin 53838 >>Turn in Keep Yer Feet On The Ground
.accept 53835 >>Accept Something Valuable, Perhaps?
.target Ancient Tablet
step
#completewith Turn in Something Valuable, Perhaps?
.goto 31,50.87,20.89
.goto 31,38.47,54.23
.goto 27,77.83,54.89 >>Leave the Cave
step
#completewith Turn in Something Valuable, Perhaps?
.goto 27,60.55,33.3
.zone 87 >>Go to Ironforge
step
#label Turn in Something Valuable, Perhaps?
.goto 87,77.42,9.56,40,0
.goto 87,22.21,78.59,20,0
.goto 87,27.48,84.68,20,0
.goto 87,37.43,66.74,10,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brann Bronzebeard|r
.turnin 53835 >>Turn in Something Valuable, Perhaps?
.accept 53836 >>Accept Ancient Armor, Ancient Mystery
.target Brann Bronzebeard
step
.goto 87,44.26,49.85,10,0
.goto 87,46.37,52.83,5,0
.goto 1361,75.76,88.5,5,0
.goto 1361,80.96,89.21,5,0
.goto 1361,82,53.24,5,0
.goto 1361,57.03,47.87
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Advisor Belgrum|r
.turnin 53836 >>Turn in Ancient Armor, Ancient Mystery
.target Advisor Belgrum
.accept 53837 >>Accept Watch Yer Back
step
.goto 1361,45.14,62.19,5,0
.goto 1361,38.25,66.03,5,0
.goto 1361,43.4,54.15,5,0
.goto 1361,37.63,40.67,5,0
.goto 1361,28.2,50.73,5,0
.goto 1361,38.87,71.33,5,0
.goto 1361,47.72,65.33,5,0
.goto 1361,38.15,44.51,5,0
.goto 1361,19.69,51.98
>>Kill |cRXP_ENEMY_Trogg Invader|r and the |cRXP_ENEMY_Roc'maw the Burrower|r
.complete 53837,1 
.complete 53837,2 
.mob Trogg Invader
.mob Roc'maw the Burrower
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Advisor Belgrum|r |cRXP_WARN_next to you.|r
.turnin 53837 >>Turn in Watch Yer Back
.target Advisor Belgrum
.accept 53839 >>Accept Aegrim's Study
step
.isOnQuest 53839
.goto 1361,18.65,52.4
.zone 87 >>Click on the |cRXP_PICK_Door|r
step
.goto 87,19.55,52.05
>>Click on |the cRXP_PICK_Armor Stand|r
.turnin 53839 >>Turn in Aegrim's Study
.target Armor Stand
.accept 53841 >>Accept Shards of the Past
step
#completewith Ancient Golem Guards
+Kill |cRXP_ENEMY_Ancient Golem Guards.|r
.mob Ancient Golem Guard
step
.goto 87,19.48,51.8
>>Click on the |cRXP_PICK_Metal.|r
.complete 53841,1,1 
step
.goto 87,20.25,52.57
>>Click on the |cRXP_PICK_Metal.|r
.complete 53841,1,2 
step
.goto 87,20.89,53.24
>>Click on the |cRXP_PICK_Metal.|r
.complete 53841,1,3 
step
.goto 87,21.96,51.53
>>Click on the |cRXP_PICK_Metal.|r
.complete 53841,1,4 
step
.goto 87,20.93,50.94
>>Click on the |cRXP_PICK_Metal.|r
.complete 53841,1,5 
step
#label Ancient Golem Guards
.goto 87,20.7,49.65
>>Click on the |cRXP_PICK_Metal.|r
.complete 53841,1,6 
step
.goto 87,24.82,49.31
.isOnQuest 53841
.zone 1361 >>Click on the |cRXP_PICK_Door|r
step
.goto 1361,38.15,44.51,5,0
.goto 1361,47.72,65.33,5,0
.goto 1361,38.87,71.33,5,0
.goto 1361,28.2,50.73,5,0
.goto 1361,37.63,40.67,5,0
.goto 1361,43.4,54.15,5,0
.goto 1361,38.25,66.03,5,0
.goto 1361,45.14,62.19,5,0
.goto 1361,63.29,48.61,5,0
.goto 1361,81.67,53.71,5,0
.goto 1361,79.76,88.88,5,0
.goto 1361,75.6,88.32,5,0
.goto 87,46.51,52.75,5,0
.goto 87,43.95,51.91,5,0
.goto 87,44.86,49.14,5,0
.goto 87,77.44,9.55
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brann Bronzebeard|r
.turnin 53841 >>Turn in Shards of the Past
.target Brann Bronzebeard
.accept 53840 >>Accept Interest Yah In A Pint?
step
#completewith next
.goto 87,55.65,47.84
.fly Thelsamar >>Fly to Thelsamar
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gryth Thurden|r
.target Gryth Thurden
step
.isOnQuest 53840
.goto 48,35.23,47.77,5,0 >> Enter Thelsamar
step
.goto 48,35.53,48.40
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Innkeeper Hearthstove|r
.home >>Set your Hearthstone to Stoutlager Inn
.target Innkeeper Hearthstove
step
.goto 48,35.00,48.78
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grumnus Steelshaper|r
.turnin 53840 >>Turn in Interest Yah In A Pint?
.target Grumnus Steelshaper
step
.goto 48,35.02,48.67
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brann Bronzebeard|r
.accept 53844 >>Accept Recruiting the Furnace Master
.target Brann Bronzebeard
step
.cast 48933 >>|T135778:0|t[Wormhole Generator: Northend] to Storm Peaks
.itemcount 48933,1
step
#completewith next
.zone 120 >>Go to Northend(Storm Peaks)
step
.goto 120,41.55,17.99
>>Enter the Ulduar Instance Portal
.complete 53844,1 
step
#completewith next
>>Kill |cRXP_ENEMY_Titan Flames|r
.complete 53844,2 
.mob Titan Flame
step
>>Kill |cRXP_ENEMY_Magmarion of the Furnace|r
*|cRXP_WARN_Take the first left turn.|r
.complete 53844,3 
.mob Magmarion of the Furnace
step
>>Kill |cRXP_ENEMY_Titan Flames|r
.complete 53844,2 
.mob Titan Flame
step
.goto 48,35.01,48.66
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brann Bronzebeard|r
.turnin 53844 >>Turn in Recruiting the Furnace Master
.target Brann Bronzebeard
.accept 53842 >>Accept Earthen Blessing
step
#completewith next
.goto 48,35.48,48.16,5,0
.goto 48,35.37,47.67,5,0
.goto 48,33.84,50.82
.fly Ironforge >>Fly to Ironforge
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thorgrum Borrelson|r
.target Thorgrum Borrelson
step
.goto 87,44.26,49.85,10,0
.goto 87,46.37,52.83,5,0
.goto 1361,75.76,88.5,5,0
.goto 1361,80.96,89.21,5,0
.goto 1361,82,53.24,5,0
.goto 1361,36.11,54.22
>>Click on the |cRXP_PICK_Remnant of the Earthen Ritual|r
.complete 53842,1 
step
.goto 1361,82,53.24,5,0
.goto 1361,80.96,89.21,5,0
.goto 1361,75.76,88.5,5,0
.goto 87,46.37,52.83,5,0
.goto 87,44.26,49.85,10,0
.goto 87,49.23,45.78
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bouldercrag the Rockshaper|r
.turnin 53842 >>Turn in Earthen Blessing
.target Bouldercrag the Rockshaper
step
.goto 87,48.79,45.87
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grumnus Steelshaper|r
.accept 53845 >>Accept Forging the Armor
.target Grumnus Steelshaper
step
.goto 87,49.13,44.88
>>|cRXP_WARN_Use the|r [ExtraActionButton] inside the fiery circle.
.complete 53845,1 
step
#completewith next
.goto 87,49.03,44.67
.cast 6478 >>Click on the|cRXP_PICK_Pile of Ancient Metal.|r
step
.goto 87,51.69,43.70
>>Mount up and fly inside the fiery circle.
.complete 53845,2 
step
#completewith next
.goto 87,52.34,44.08
.cast 6478 >>Click on the |cRXP_PICK_Molten Metal.|r
step
.goto 87,50.10,43.96
>>Mount up and fly inside the fiery circle.
.complete 53845,3 
step
>>|cRXP_WARN_Use the|r [ExtraActionButton]
.complete 53845,4 
step
.goto 87,49.74,43.71
>>Click on the|cRXP_PICK_Bulwark of the Mountain King|r
.complete 53845,5 
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Gnome Heritage Armor
#displayname |cRXP_WARN_Chapter 4 -|rGnome Heritage Quests
#next 6) Item Information
<<Alliance Gnome
step
#sticky
*|cRXP_WARN_Chapter 0:|r Warband Quests
*Guides you through the heritage armor questline and stops when you have the optimal quests set up, ready to turn in for the best experience at launch.
+|cRXP_WARN_This questline can only be completed once per account.|r
step
#completewith next
.zone 87 >>Go to Ironforge
step
.goto 84,54.81,18.61
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ace Pilot Stormcrog|r
.accept 54402 >>Accept Shifting Gears
.target Ace Pilot Stormcrog
step
.goto 469,41.77,31.63
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Tread Sparknozzle|r
.turnin 54402 >>Turn in Shifting Gears
.target Captain Tread Sparknozzle
.accept 54576 >>Accept Gnomeregan's Finest
step
.goto 469,40.28,38.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cog Captain Winklespring|r
.complete 54576,3 
.skipgossip
.target Cog Captain Winklespring
step
.goto 469,37.46,38.16,10,0
.goto 469,38.25,39.24,5,0
.goto 469,38.19,38.90
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Emaedi Autoblast|r |cRXP_WARN_inside the house.|r
.complete 54576,1 
.skipgossip
.target Emaedi Autoblast
step
.goto 469,38.23,39.32,5,0
.goto 469,37.43,38.11,5,0
.goto 469,37.95,33.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Fizzi Tinkerbow|r
.complete 54576,2 
.skipgossip
.target Fizzi Tinkerbow
step
.goto 469,41.78,31.61
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Tread Sparknozzle|r
.turnin 54576 >>Turn in Gnomeregan's Finest
.target Captain Tread Sparknozzle
.accept 54577 >>Accept Shadowed Halls and Dusty Cogs
step
.goto 27,31.18,38.02,10,0
.goto 30,69.88,83.03,10,0
.goto 30,56.49,81.13,10,0
.goto 30,54.09,75.64,10,0
.goto 30,53.88,14.98,10,0
.goto 30,45.43,13.95
>>|cRXP_WARN_Follow the Arrow.|r
.complete 54577,1 
step
.goto 1380,83.17,63.81,20,0
.goto 1380,78.3,63.53,20,0
.goto 1380,75.05,67.25,20,0
.goto 1380,72.05,73.19,20,0
.goto 1380,65.41,72.47,20,0
.goto 1380,56.56,62.8,20,0
.goto 1380,52.9,67.83,20,0
.goto 1380,50.66,89.67,20,0
.goto 1380,46.39,89.92,20,0
.goto 1380,36.7,86.26,20,0
.goto 1380,35.95,73.04
>>Click on |cRXP_PICK_Prototype Arcane Engine.|r
.complete 54577,2 
step
#completewith next
.goto 1380,37.81,72.24
.cast 6478 >>Click on the|cRXP_PICK_Broken Teleporter|r
step
.goto 469,41.77,31.62
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Tread Sparknozzle|r
.turnin 54577 >>Turn in Shadowed Halls and Dusty Cogs
.target Captain Tread Sparknozzle
.accept 54580 >>Accept A Tundra Conundrum
step
#completewith next
.zone 114 >>Go to Borean Tundra(Northend)
step
#loop
.goto 114,55.28,18.92,2,0
.goto 114,55.36,18.82,2,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cog Captain Winklespring|r
.turnin 54580 >>Turn in A Tundra Conundrum
.target Cog Captain Winklespring
step
.goto 114,55.32,18.99
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Fizzi Tinkerbow|r
.accept 54581 >>Accept Now With More Mechanical Fowl
.target Fizzi Tinkerbow
step
#loop
.goto 114,60.31,21.08,30,0
.goto 114,62.12,20.23,30,0
.goto 114,63.06,19.3,30,0
.goto 114,64.2,19.82,30,0
.goto 114,64.41,22.12,30,0
>>Kill |cRXP_ENEMY_Ironbound Brute|r and |cRXP_ENEMY_Ironbound Scrapthrower|r
*|cRXP_WARN_Use the|r [ExtraActionButton] to deal additional damage.
.complete 54581,1 
.mob Ironbound Brute
.mob Ironbound Scrapthrower
step
.goto 114,64.08,24.73
>>|cRXP_WARN_Click the pop-up in your questlog|r
.turnin 54581 >>Turn in Now With More Mechanical Fowl
.accept 54582 >>Accept Smarter Than Your Average Trogg
step
.goto 114,64.62,23.02
>>Kill |cRXP_ENEMY_Krugg the Smart.|r Loot them for the |cRXP_LOOT_Broken Communication Device.|r
.complete 54582,1 
.complete 54582,2 
.mob Krugg the Smart
step
.goto 114,55.31,18.98
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Fizzi Tinkerbow|r
.turnin 54582 >>Turn in Smarter Than Your Average Trogg
.target Fizzi Tinkerbow
.accept 54579 >>Accept The Gnome Behind the Trogg
step
.goto 114,55.28,18.98
>>Click on the |cRXP_PICK_RCV Control Switch.|r
.complete 54579,1 
.timer 15,RP
step
.goto 114,55.31,18.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Fizzi Tinkerbow|r
.turnin 54579 >>Turn in The Gnome Behind the Trogg
.target Fizzi Tinkerbow
.accept 54639 >>Accept A Signal in Storm Peaks
step
.goto 114,55.18,18.83
>>Click on the |cRXP_PICK_First Squadron Prototype.|r
.complete 54639,1 
.timer 140,RP
.target First Squadron Prototype
step
>>Wait until it's arrival.
.complete 54639,2 
step
.goto 120,37.60,60.23
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cog Captain Winklespring|r
.turnin 54639 >>Turn in A Signal in Storm Peaks
.target Cog Captain Winklespring
.accept 54640 >>Accept Gnomercy!
step
.goto 120,37.45,60.51
>>Click on |cRXP_PICK_Shrinkified Assault Tank|r
.complete 54640,1 
.target Shrinkified Assault Tank
step
.goto 120,37.45,60.51
>>Click on |cRXP_PICK_Gnomeregan Assault Tank|r
.complete 54640,2 
.target Gnomeregan Assault Tank
step
.isOnQuest 54640
.exitvehicle >> |cRXP_WARN_Dismount the Gnomeregan Assault Tank by pressing the |r[Exit] |cRXP_WARN_button on your action bars.|r
*|cRXP_WARN_Alternatively, you can use this macro;|r
.link /leavevehicle>> CLICK HERE FOR MACRO.
step
#loop
.goto 120,38.23,59.93,40,0
.goto 120,40.17,60.55,40,0
.goto 120,42.49,59.35,40,0
.goto 120,43.22,57.1,40,0
.goto 120,42.66,54.85,40,0
.goto 120,41.48,53.15,40,0
.goto 120,39.53,53.8,40,0
.goto 120,38.01,57.05,40,0
>>Kill |cRXP_ENEMY_Ironbound Invader|r
.complete 54640,3 
.mob Ironbound Invader
step
.goto 120,56.12,51.42
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cog Captain Winklespring|r
.turnin 54640 >>Turn in Gnomercy!
.target Cog Captain Winklespring
.accept 54850 >>Accept Operation: Troggageddon
step
.goto 120,56.17,51.50
>>Click on the |cRXP_PICK_First Squadron Prototype|r
.complete 54850,1 
.target First Squadron Prototype
step
.goto 120,37.43,43.02
>>Use |T1141394:0|t1[Standard Issue Bomber Gun](1) to hit enemies in a cone infront of you and |T136111:0|t[Buster Cannon Mk. II](2) to target enemies within a circle on the ground.
.complete 54850,2 
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Worgen Heritage Armor
#displayname |cRXP_WARN_Chapter 4 -|r Worgen Heritage Quests
#next 6) Item Information
<< Alliance Worgen
step
#sticky
*|cRXP_WARN_Chapter 0:|r Warband Quests
*Guides you through the heritage armor questline and stops when you have the optimal quests set up, ready to turn in for the best experience at launch.
+|cRXP_WARN_This questline can only be completed once per account.|r
step
.goto 84,54.81,18.61
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Courier Claridge|r
.accept 54976 >>Accept The Shadow of Gilneas
.target Courier Claridge
step
.goto 84,82.50,28.08
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Princess Tess Greymane|r
.turnin 54976 >>Turn in The Shadow of Gilneas
.target Princess Tess Greymane
step
.goto 84,82.35,27.75
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mia Greymane|r
.accept 54977 >>Accept Into Duskwood
.target Mia Greymane
step
#loop
.goto 47,18.29,57.21,2,0
.goto 47,18.09,57.23,2,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vassandra Stormclaw|r
.turnin 54977 >>Turn in Into Duskwood
.target Vassandra Stormclaw
.accept 54980 >>Accept Bane of the Nightbane
step
.goto 47,52.01,61.63
>>Click on the |cRXP_PICK_Pungent Meat|r
.complete 54980,1 
step
.goto 47,52.01,61.63
>>Kill |cRXP_ENEMY_Bloodeyes|r
*|cRXP_WARN_Use the|r [ExtraActionButton] when it's available.
.complete 54980,2 
.mob Bloodeyes
step
.goto 47,18.10,57.23
>>|cRXP_WARN_Follow the Arrow|r
.complete 54980,3 
step
#loop
.goto 47,18.29,57.21,2,0
.goto 47,18.09,57.23,2,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vassandra Stormclaw|r
.turnin 54980 >>Turn in Bane of the Nightbane
.target Vassandra Stormclaw
.accept 54981 >>Accept Cry to the Moon
.accept 54982 >>Accept The Spirit of the Hunter
step
#completewith next
>>Kill |cRXP_ENEMY_Mistfang Alpha.|r Loot them for |cRXP_LOOT_Bloodstained Fangs.|r
.complete 54982,1 
.mob Mistfang Alpha
step
.goto 47,82.36,33.95
>>Click on |cRXP_PICK_Elune's Grace|r
.complete 54981,1 
step
#loop
.goto 47,77.27,35.49,15,0
.goto 47,77.3,30.53,15,0
.goto 47,81.7,33.46,15,0
>>Kill |cRXP_ENEMY_Mistfang Alpha.|r Loot them for |cRXP_LOOT_Bloodstained Fangs.|r
.complete 54982,1 
.mob Mistfang Alpha
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Draenei Heritage Armor
#displayname |cRXP_WARN_Chapter 4 -|r Draenei Heritage Quests
#next 6) Item Information
<<Alliance Draenei
step
.goto 13,43.79,71.79
.accept 78068 >>Accept An Artificer's Appeal
step
#completewith next
.cast 426620 >>Use |T1686574:0|t[Spare Hologem]
.use 210454
step
.goto 103,54.78,79.84
>>|cRXP_WARN_Follow the Arrow.|r
.complete 78068,2 
step
.goto 103,54.78,79.83
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grand Artificer Romuul|r
.turnin 78068 >>Turn in An Artificer's Appeal
.target Grand Artificer Romuul
.accept 78069 >>Accept Reviving Tradition
step
.goto 103,58.05,79.79
>>Click on the |cRXP_PICK_Chest|r
.complete 78069,1 
step
.goto 103,51.26,74.67
>>Click on the |cRXP_PICK_Chest|r
.complete 78069,2 
step
.goto 103,54.78,79.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grand Artificer Romuul|r
.complete 78069,3 
.skipgossip 210340,1
.target Grand Artificer Romuul
step
.isOnQuest 78069
.cast 3365>>Click on the |cRXP_PICK_Arcanite Pillar|r
.target Arkonite Generator
.goto 103,55.55,78.78
step
.isOnQuest 78069
.cast 3365>>Click on the |cRXP_PICK_Arcanite Pillar|r
.target Arkonite Generator
.goto 103,54.72,78.81
step
.isOnQuest 78069
.cast 3365>>Click on the |cRXP_PICK_Arcanite Pillar|r
.target Arkonite Generator
.goto 103,54.32,81.45
step
.isOnQuest 78069
.cast 3365>>Click on the |cRXP_PICK_Arcanite Pillar|r
.target Arkonite Generator
.goto 103,53.97,80.18
step
.goto 103,53.82,78.96
>>Click on the |cRXP_PICK_Arkonite Generator|r in the middle.
.complete 78069,4 
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Goblin Heritage Armor
#displayname |cRXP_WARN_Chapter 4 -|r Goblin Heritage Quests
#next 6) Item Information
<< Horde Goblin
step
#sticky
*|cRXP_WARN_Chapter 4:|r Heritage Armor Quests
*Guides you through the heritage armor questline and stops when you have the optimal quests set up, ready to turn in for the best experience at launch.
+|cRXP_WARN_This questline can only be completed once per account.|r
step
.goto 85,39.51,80.25
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Izzy|r
.accept 57043 >>Accept Old Friends, New Opportunities
.target Izzy
step
.goto 210,34.61,28.59
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sassy Hardwrench|r
.turnin 57043 >>Turn in Old Friends, New Opportunities
.target Sassy Hardwrench
.accept 57045 >>Accept A Special Delivery
step
.goto 210,32.82,26.13
>>Click on |cRXP_PICK_Goblin Flying Machine|r and accept the prompt.
.complete 57045,1 
.target Goblin Flying Machine
step
.isOnQuest 57045
.goto 1532,53.86,65.37,10 >> Follow the Arrow
.timer 18,RP
step
.isOnQuest 57045
.goto 1532,53.86,65.37
.countdown 18 >> |cRXP_WARN_Wait for Gallywix departure.|r
step
.goto 1532,53.57,61.98
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hobart Grapplehammer|r
.turnin 57045 >>Turn in A Special Delivery
.target Hobart Grapplehammer
.accept 57047 >>Accept A Simple Experiment
.timer 22,RP
step
.goto 1532,53.00,58.56
>>Wait until the objective completes.
.complete 57047,1 
step
.goto 1532,53.00,58.56
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hobart Grapplehammer|r
.complete 57047,2 
.skipgossip 156520,1
.target Hobart Grapplehammer
step
.isOnQuest 57047
.goto 1532,52.51,60.29
.cast 305728 >>Click on |cRXP_PICK_Freezing Console|r
.timer 24,RP
step
.goto 1532,53.23,60.13
>>Wait until the objective completes.
.complete 57047,3 
step
.isOnQuest 57047
.goto 1532,53.21,60.08
.cast 305733 >>Click on |cRXP_PICK_Flame Console|r
.timer 22,RP
step
.goto 1532,54.00,59.74
>>Wait until the objective completes.
.complete 57047,4 
step
.goto 1532,54.00,59.74
>>Click on |cRXP_PICK_Flame Console|r
.complete 57047,5 
step
.goto 1532,52.99,58.59
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hobart Grapplehammer|r
.turnin 57047 >>Turn in A Simple Experiment
.target Hobart Grapplehammer
.accept 57048 >>Accept Shopping For Parts
step
.goto 1532,56.11,78.21
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Crank Greasefuse|r
.turnin 57048 >>Turn in Shopping For Parts
.target Crank Greasefuse
.accept 57051 >>Accept Debt Collection!
step
#loop
.goto 1532,54.92,76.22,20,0
.goto 1532,52.86,76.19,20,0
.goto 1532,53.42,72.68,20,0
.goto 1532,53.87,70.96,20,0
.goto 1532,53.17,69.77,20,0
.goto 1532,55.88,69.89,20,0
.goto 1532,55.7,74.02,20,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shady Thug.|r
*|cRXP_WARN_If you have to kill them|r Loot them for |cRXP_LOOT_Unpaid Debt|r
.skipgossip
.complete 57051,1 
.target Shady Thug
.mob Shady Thug
step
.goto 1532,56.12,78.24
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Crank Greasefuse|r
.turnin 57051 >>Turn in Debt Collection!
.target Crank Greasefuse
.accept 57052 >>Accept I've Got What You Need
step
.goto 1532,58.75,60.85
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hobart Grapplehammer|r
.turnin 57052 >>Turn in I've Got What You Need
.target Hobart Grapplehammer
.accept 57053 >>Accept Blunt Force Testing
step
.goto 1532,53.23,59.97
>>Use |T431762:0|t[X-52 Body Armor]
.complete 57053,1 
.use 171114
step
.goto 1532,53.23,59.97
>>Click on the |cRXP_PICK_Test Console|r
.complete 57053,2 
.timer 6,RP
step
.goto 1532,53.13,59.34
>>Kill |cRXP_ENEMY_Mechanized Lab Assistant|r
.complete 57053,3 
.mob Mechanized Lab Assistant
step
.goto 1532,58.74,60.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hobart Grapplehammer|r
.turnin 57053 >>Turn in Blunt Force Testing
.target Hobart Grapplehammer
.accept 57058 >>Accept Fun With Landmines
step
.goto 1532,46.24,47.98
>>Use |T431762:0|t[X-52 Body Armor]
.complete 57058,1 
.use 174059
step
#completewith next
.goto 1532,47.84,50.61,10,0
.cast 69070 >>Run into the bombs for an uplift; when close enough to the middle, use |T370769:0|t[Rocket Jump] while midair to get near the Refreshing coconut beverage
step
.goto 1532,46.02,48.25
>>Click on the |cRXP_PICK_Refreshing coconut beverage.|r
.complete 57058,2 
step
.goto 1532,51.77,62.22,10,0
.goto 1532,52.09,59.32
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hobart Grapplehammer|r
.turnin 57058 >>Turn in Fun With Landmines
.target Hobart Grapplehammer
.accept 57059 >>Accept Let's Rumble!
step
#loop
.goto 1532,54.02,58.66,15,0
.goto 1532,53.55,61.22,15,0
.goto 1532,52.21,60.38,15,0
>>Kill |cRXP_ENEMY_Hired Scoundrel|r
.complete 57059,1 
.mob Hired Scoundrel
step
.goto 1532,53.29,60.37
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gallywix|r
.complete 57059,2 
.skipgossip
.target Gallywix
step
.goto 1532,52.10,59.31
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hobart Grapplehammer|r
.turnin 57059 >>Turn in Let's Rumble!
.target Hobart Grapplehammer
.accept 57077 >>Accept Buyers Wanted!
step
.goto 1532,50.69,94.75
>>Click on |cRXP_PICK_Goblin Flying Machine|r and accept the prompt.
.complete 57077,1 
.target Goblin Flying Machine
step
.goto 210,34.61,28.60
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sassy Hardwrench|r
.turnin 57077 >>Turn in Buyers Wanted!
.target Sassy Hardwrench
.accept 57078 >>Accept The VIP List
step
.goto 71,51.20,29.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marin Noggenfogger|r
.complete 57078,1 
.skipgossip
.target Marin Noggenfogger
step
.goto 64,75.93,74.69
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Pozzik|r
.complete 57078,2 
.skipgossip 40028,1
.target Pozzik
step
.goto 10,68.41,69.06
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gazlowe|r
.complete 57078,3 
.skipgossip 3391,1
.target Gazlowe
step
.goto 210,34.61,28.59
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sassy Hardwrench|r
.turnin 57078 >>Turn in The VIP List
.target Sassy Hardwrench
.accept 57079 >>Accept Beat The Crapopolis Outta Him!
step
.isOnQuest 57079
.goto 210,32.86,26.18
.cast 306977 >>Click on the |cRXP_PICK_Goblin Flying Machine|r
.target Goblin Flying Machine
step
.goto 1531,52.31,84.7
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sassy Hardwrench|r
.scenario 4367,1 
.skipgossip
step
#loop
.goto 1531,53.13,59.45,5,0
.goto 1531,52.58,58.9,5,0
>>Kill |cRXP_ENEMY_Dax Blitzblaster|r and |cRXP_ENEMY_Street Thug|r to rescue |cRXP_FRIENDLY_Hobart Grapplehammer.|r
.scenario 4368,1
.mob Street Thug
.mob Dax Blitzblaster
.target Hobart Grapplehammer
step
.isOnQuest 57079
.goto 1531,52.58,58.9
>>Click on the |cRXP_PICK_Chest|r
.scenario 4369,1
step
.goto 1531,51.36,62.77,15,0
.goto 1531,46.29,48.2
>>Kill |cRXP_ENEMY_Gallywix|r, but be aware that he will repair himself three times before you can finally destroy him using your |cRXP_WARN_[ExtraActionButton]|r.
*If you are struggling with survivability, you can use your |cRXP_WARN_[ExtraActionButton]|r to defend yourself from incoming fire damage as well.
.complete 57079,1 
.mob Trade Prince Gallywix
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Troll Heritage Armor
#displayname |cRXP_WARN_Chapter 4 -|r Troll Heritage Quests
#next 6) Item Information
<<Horde Troll
step
#sticky
*|cRXP_WARN_Chapter 0:|r Warband Quests
*Guides you through the heritage armor questline and stops when you have the optimal quests set up, ready to turn in for the best experience at launch.
+|cRXP_WARN_This questline can only be completed once per account.|r
step
.goto 85,32.70,64.62
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zi'guma|r
.accept 77869 >>Accept Return to the Echo Isles
.target Zi'guma
step
.goto 463,61.13,65.66
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.turnin 77869 >>Turn in Return to the Echo Isles
.target Rokhan
step
.goto 463,61.39,65.37
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Gadrin|r
.accept 77871 >>Accept De Old Loa
.target Master Gadrin
step
.goto 463,61.9,65.42
>>Click on |cRXP_PICK_Mueh'zala Offering|r |cRXP_WARN_[1]|r
.complete 77871,1,1 
step
.goto 463,61.65,64.44
>>Click on |cRXP_PICK_Mueh'zala Offering|r |cRXP_WARN_[1]|r
.complete 77871,1,2 
step
.goto 463,60.65,65.34
>>Click on |cRXP_PICK_Mueh'zala Offering|r |cRXP_WARN_[1]|r
.complete 77871,1,3 
step
.goto 463,60.6,66.2
>>Click on |cRXP_PICK_Mueh'zala Offering|r |cRXP_WARN_[1]|r
.complete 77871,1,4 
step
.goto 463,60.62,66.58
>>Click on |cRXP_PICK_Mueh'zala Offering|r |cRXP_WARN_[1]|r
.complete 77871,1,5 
step
.goto 463,61.37,65.36
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Gadrin|r
.accept 77871 >>Accept De Old Loa
.target Master Gadrin
step
#completewith next
+Jump out of the house
step
.goto 463,58.75,66.27
>>Click on |cRXP_PICK_Altar of the Loa.|r
.complete 77871,2 
step
.goto 463,59.16,65.61
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.turnin 77871 >>Turn in De Old Loa
.target Rokhan
step
.goto 463,59.16,65.61
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.target Rokhan
.accept 77874 >>Accept De Loa of de Past
step
.goto 463,59.22,62.1
>>Click on the |cRXP_PICK_Tribute objects|r
.complete 77874,1,1 
step
.goto 463,59.93,60.92
>>Click on the |cRXP_PICK_Tribute objects|r
.complete 77874,1,2 
step
.goto 463,60.03,61.07
>>Click on the |cRXP_PICK_Tribute objects|r
.complete 77874,1,3 
step
.goto 463,59.74,62.5,5,0
.goto 463,60.26,61.61
>>Click on the |cRXP_PICK_Tribute objects|r
.complete 77874,1,4 
step
.goto 463,60.18,62.12
>>Click on the |cRXP_PICK_Tribute objects|r
.complete 77874,1,5 
step
.goto 463,60.87,63.34
>>Click on the |cRXP_PICK_Tribute objects|r
.complete 77874,1,6 
step
.goto 463,60.51,63.45
>>Click on the |cRXP_PICK_Tribute objects|r
.complete 77874,1,7 
step
.goto 463,60.36,63.21
>>Click on the |cRXP_PICK_Tribute objects|r
.complete 77874,1,8 
step
.goto 463,58.72,65.99
>>Click on |cRXP_PICK_Jani's Junkpile.|r
.complete 77874,2 
.timer 32,RP
step
.goto 463,58.37,65.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jani|r
.complete 77874,3 
.skipgossip
.target Jani
step
.goto 463,58.71,66.04
>>Click on |cRXP_PICK_Jani's Junkpile.|r
.complete 77874,4 
step
.goto 50,84.60,40.17
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.turnin 77874 >>Turn in De Loa of de Past
.target Rokhan
.accept 77879 >>Accept Stalking the Stalker
step
#loop
.goto 50,88.01,45.74,20,0
.goto 50,89.17,49.06,20,0
.goto 50,87.18,49.64,20,0
>>Kill |cRXP_ENEMY_Animated Offering|r, |cRXP_ENEMY_Hakkari Ritualist|r and |cRXP_ENEMY_Foul Offering.|r Loot them for |cRXP_LOOT_Offering to Hakkar|r
.complete 77879,1 
.mob Animated Offering
.mob Hakkari Ritualist
.mob Foul Offering
step
.goto 50,81.77,47.86
>>|cRXP_WARN_Follow the Arrow|r
.complete 77879,2 
.timer 20,RP
step
.goto 50,81.81,48.09
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kevo ya Siti|r
.turnin 77879 >>Turn in Stalking the Stalker
.target Kevo ya Siti
.accept 77881 >>Accept There is Another
step
>>Click on |cRXP_PICK_Jani's Junkpile|r
.goto 50,81.84,47.61
.complete 77881,1 
.complete 77881,2 
step
.goto 50,63.59,41.46
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kevo ya Siti|r
.turnin 77881 >>Turn in There is Another
.target Kevo ya Siti
step
.goto 50,63.48,41.33
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.accept 77880 >>Accept Looking for Lukou
.target Rokhan
step
.goto 50,65.03,42.5
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shadow Hunter Ty'jin|r
.complete 77880,1,1 
.skipgossip
.target Shadow Hunter Ty'jin
step
.goto 50,66.05,40.51
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shadow Hunter Ty'jin|r
.complete 77880,1,2 
.skipgossip
.target Shadow Hunter Ty'jin
step
.goto 50,63.18,39.87
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shadow Hunter Ty'jin|r
.complete 77880,1,3 
.skipgossip
.target Shadow Hunter Ty'jin
step
.goto 50,63.48,41.32
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.complete 77880,2 
.skipgossip 210091,1
.target Rokhan
step
.goto 50,65.14,47.69
>>Follow the Arrow
.complete 77880,3 
step
.goto 50,65.09,47.48
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.turnin 77880 >>Turn in Looking for Lukou
.target Rokhan
step
.goto 50,65.06,47.71
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kevo ya Siti|r
.accept 77877 >>Accept One with the Loa
.target Kevo ya Siti
step
.goto 50,65.06,47.71
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kevo ya Siti|r
.complete 77877,1 
.timer 20,RP
.skipgossip
step
.goto 50,70.38,48.96
>>Wait until the objective completes.
.complete 77877,2 
step
.goto 50,70.63,49.02
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.turnin 77877 >>Turn in One with the Loa
.target Rokhan
.accept 77882 >>Accept Stolen but Not Forgotten
.accept 78875 >>Accept The Unkillable
step
>>Kill |cRXP_ENEMY_Mosh'Ogg Witch Doctor|r and |cRXP_ENEMY_Mosh'Ogg Spellcrafter.|r Loot them for |cRXP_LOOT_Altar Fragment.|r
*Click on |cRXP_PICK_Dusty Bags|r
.complete 77882,1 
.mob Mosh'Ogg Witch Doctor
.mob Mosh'Ogg Spellcrafter
step
.goto 50,69.24,48.6,10,0
.goto 50,68.6,49.63,10,0
.goto 50,68.44,49.04,10,0
.goto 50,67.92,47,10,0
.goto 50,69.18,46.97
>>Kill |cRXP_ENEMY_Mai'Zoth.|r Loot them for |cRXP_LOOT_Lukou's Altar Centerpiece|r
.complete 78875,1 
.mob Mai'Zoth
step
#loop
.goto 50,69.64,47.11,10,0
.goto 50,67.93,47.09,10,0
.goto 50,67.52,47.92,10,0
.goto 50,67.28,49.01,10,0
.goto 50,67.64,48.91,10,0
.goto 50,68.34,48.88,10,0
.goto 50,68.76,49.38,10,0
.goto 50,68.97,48.84,10,0
>>Kill |cRXP_ENEMY_Mosh'Ogg Witch Doctor|r and |cRXP_ENEMY_Mosh'Ogg Spellcrafter.|r Loot them for |cRXP_LOOT_Altar Fragment.|r
*Click on |cRXP_PICK_Dusty Bags|r
.complete 77882,1 
step
.goto 50,70.62,49.02
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.turnin 77882 >>Turn in Stolen but Not Forgotten
.target Rokhan
.turnin 78875 >>Turn in The Unkillable
.accept 77894 >>Accept Heart of Lukou
step
.goto 50,70.71,48.99
>>Click on the |cRXP_PICK_Altar of Regeneration|r
.complete 77894,1 
.timer 10,RP
step
.goto 50,70.78,48.63
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lukou|r
.complete 77894,2 
.timer 9,RP
.skipgossip
.target Lukou
step
.goto 50,70.63,49.03
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.turnin 77894 >>Turn in Heart of Lukou
.target Rokhan
.accept 77898 >>Accept Honor and Tribute
step
.goto 50,70.4,49.58
>>Click on |cRXP_PICK_Jani's Junkpile|r
.complete 77898,1 
step
.goto 463,59.07,65.90
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tzadah|r
.complete 77898,2 
.skipgossip 210086,1
.target Tzadah
step
.goto 463,58.64,66.3
>>Click on |cRXP_PICK_Lukou Offering|r
.complete 77898,4 
step
.goto 463,58.85,66.28
>>Click on |cRXP_PICK_Kevo ya Siti Offering|r
.complete 77898,3 
step
.goto 463,58.75,66.28
>>Click on |cRXP_PICK_Kevo ya Siti Offering|r
.complete 77898,5 
step
.goto 463,59.07,65.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Witch Doctor Tzadah|r
.turnin 77898 >>Turn in Honor and Tribute
.target Witch Doctor Tzadah
.accept 77899 >>Accept The Rush'kah
step
.goto 463,59.29,61.88
>>Click on |cRXP_PICK_Rush'kah Paint|r
.complete 77899,1 
step
.goto 463,59.2,61.96
>>Click on |cRXP_PICK_Prepared Wood|r
.complete 77899,2 
step
.goto 463,60.13,62.17
>>Click on |cRXP_PICK_Finished Rush'kah|r
.complete 77899,3 
step
.goto 463,60.09,62.39
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.turnin 77899 >>Turn in The Rush'kah
.target Rokhan
step
.goto 463,60.09,62.39
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.target Rokhan
.accept 77900 >>Accept The Loa Trials
step
#completewith next
.goto 463,58.77,65.92
.cast 427573 >>Use |T136194:0|t[Loa Trial Ritual]
.use 427573
.timer 46,RP
step
.goto 463,58.5,65.57
>>Wait until the objective completes
.complete 77900,1 
step
.goto 463,58.52,65.53
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.turnin 77900 >>Turn in The Loa Trials
.target Rokhan
.accept 77903 >>Accept De Power of Death
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lukou|r and |cRXP_FRIENDLY_Kevo ya Siti|r
.accept 77902 >>Accept Ritual Recovery
.goto 463,58.48,66.15
.target +Lukou
.accept 77901 >>Accept Retraining the Trainees
.goto 463,59.02,66.17
.target +Kevo ya Siti
step
#completewith Ritual Circle
>>Kill |cRXP_ENEMY_Devotee of Mueh'zala,|r |cRXP_ENEMY_Raised Boneripper,|r |cRXP_ENEMY_Unfinished Rush'kah|r and |cRXP_ENEMY_Empowered Boneguard.|r
.complete 77903,1 
.mob Devotee of Mueh'zala
.mob Raised Boneripper
.mob Empowered Boneguard
.mob Unfinished Rush'kah
step
#completewith Ritual Circle
>>When the |cRXP_ENEMY_Lost Trainee's|r health drops to 50%, click on them for credit.
.complete 77901,1 
.use 211000
.mob Lost Trainee Warrior
.mob Lost Trainee Rogue
.mob Lost Trainee Druid
.mob Lost Trainee Hunter
.mob Lost Trainee Priest
.mob Lost Trainee Shaman
.mob Lost Trainee Warlock
step
.goto 463,59.72,51.61
>>Click on the |cRXP_PICK_Ritual Circle|r
.complete 77902,1,1 
step
.goto 463,48.59,47.55
>>Click on the |cRXP_PICK_Ritual Circle|r
.complete 77902,1,2 
step
#label Ritual Circle
.goto 463,49.55,60.84
>>Click on the |cRXP_PICK_Ritual Circle|r
.complete 77902,1,3 
step
#hidewindow
#completewith Devotee of Mueh'zala
#loop
.goto 463,53.86,64.39,25,0
.goto 463,56.74,51.61,25,0
.goto 463,56,42.86,25,0
.goto 463,49.53,44.43,25,0
.goto 463,47.62,53.04,25,0
+1
step
#completewith next
>>Kill |cRXP_ENEMY_Devotee of Mueh'zala,|r |cRXP_ENEMY_Raised Boneripper,|r |cRXP_ENEMY_Unfinished Rush'kah|r and |cRXP_ENEMY_Empowered Boneguard.|r
.complete 77903,1 
.mob Devotee of Mueh'zala
.mob Raised Boneripper
.mob Empowered Boneguard
.mob Unfinished Rush'kah
step
>>When the |cRXP_ENEMY_Lost Trainee's|r health drops to 50%, click on them for credit.
.complete 77901,1 
.use 211000
.mob Lost Trainee Warrior
.mob Lost Trainee Rogue
.mob Lost Trainee Druid
.mob Lost Trainee Hunter
.mob Lost Trainee Priest
.mob Lost Trainee Shaman
.mob Lost Trainee Warlock
step
#label Devotee of Mueh'zala
>>Kill |cRXP_ENEMY_Devotee of Mueh'zala,|r |cRXP_ENEMY_Raised Boneripper,|r |cRXP_ENEMY_Unfinished Rush'kah|r and |cRXP_ENEMY_Empowered Boneguard.|r
.complete 77903,1 
.mob Devotee of Mueh'zala
.mob Raised Boneripper
.mob Empowered Boneguard
.mob Unfinished Rush'kah
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Orc Heritage Armor
#displayname |cRXP_WARN_Chapter 4 -|r Orc Heritage Quests
#next 6) Item Information
<< Horde Orc
step
#sticky
*|cRXP_WARN_Chapter 4:|r Heritage Armor Quests
*Guides you through the heritage armor questline and stops when you have the optimal quests set up, ready to turn in for the best experience at launch.
+|cRXP_WARN_This questline can only be completed once per account.|r
step
#completewith next
.goto 85,50.01,75.88,10,0 >> Enter Gromash Hold
step
.goto 85,50.1,74.48,5,0
.goto 85,49.26,73.73,6,0
.goto 85,49.21,72.28
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eitrigg|r
.turnin 73703 >>Turn in A Summon to Orgrimmar
.accept 72462 >>Accept A People in Need of Healing
.target Eitrigg
step
.goto 85,49.26,73.78,5,0
.goto 85,49.99,74.61,5,0
.goto 85,49.94,75.75,5,0
.goto 85,51.15,78.94
>>Click on the |cRXP_PICK_Portal.|r
.complete 72462,1 
.timer 100,RP
step
#completewith next
.isOnQuest 72462
>>Wait for |cRXP_FRIENDLY_Eitrigg|r to arrive.
.scenario 5388,1
.target Eitrigg
step
.isOnQuest 72462
.goto 2162,48.83,83.96,15,0
.goto 2162,48.73,86.09,15,0
.goto 2162,47.8,86.44,15,0
.goto 2162,47.51,86.19,15,0
.goto 2162,47.11,86.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eitrigg|r
.scenario 5388,2
.skipgossip
.target Eitrigg
step
.isOnQuest 72462
.goto 2162,47.1,86.58
>>Wait for |cRXP_FRIENDLY_Farseer Drek'Thar|r to arrive.
.scenario 5388,1
.target Farseer Drek'Thar
step
.isOnQuest 72462
.goto 2162,47.1,86.58
>>Click on the |cRXP_PICK_Totem of Air|r
.scenario 5389,2,1
.target Totem of Air
step
.isOnQuest 72462
.goto 2162,47.31,86.35
>>Click on the |cRXP_PICK_Totem of Water|r
.scenario 5389,2,2
.target Totem of Water
step
.isOnQuest 72462
.goto 2162,47.52,87.32
>>Click on the |cRXP_PICK_Totem of Fire|r
.scenario 5389,2,3
.target Totem of Fire
step
.isOnQuest 72462
.goto 2162,47.26,87.3
>>Click on the |cRXP_PICK_Totem of Earth|r
.scenario 5389,2,4
.target Totem of Earth
step
.isOnQuest 72462
.goto 2162,47.11,86.98
>>Wait until the objective completes.
.scenario 5389,1
step
.isOnQuest 72462
.goto 2162,47.11,86.98
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farseer Drek'Thar|r
.scenario 5390,1,1
.timer 20,RP
.skipgossip
.target Farseer Drek'Thar
step
.isOnQuest 72462
.goto 2162,47.41,86.84
>>Kill |cRXP_ENEMY_Duros|r and |cRXP_ENEMY_Drakan|r
.timer 20,RP
.scenario 5390,2
.scenario 5390,3
.mob Duros
.mob Drakan
step
.isOnQuest 72462
.goto 2162,47.1,86.58,10,0
.goto 2162,47.31,86.35,10,0
.goto 2162,47.52,87.32,10,0
.goto 2162,47.26,87.3,10,0
.goto 2162,47.41,86.84
>>Kill the |cRXP_ENEMY_Totems|r and then the |cRXP_ENEMY_Elemental Projection.|r
.scenario 5396,1
.mob Elemental Projection
step
.goto 2162,47.42,86.75
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thrall|r and use |T413582:0|t[Thrall's Hearthstone]
.scenario 5422,1
.skipgossip
.target Thrall
step
.goto 85,54.37,78.6
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thrall|r
.complete 72462,2 
.target Aggra
step
.goto 85,54.31,78.63
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Aggra|r
.turnin 72462 >>Turn in A People in Need of Healing
.target Aggra
.accept 72464 >>Accept The Kosh'harg
step
.goto 85,53.2,78.96,10,0
.goto 1,52.21,43.01
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farseer Aggralan to begin the Om'gora|r
.complete 72464,2 
.skipgossip 199148,2
.target Farseer Aggralan
step
.goto 1,52.20,43.00
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farseer Aggralan|r
.turnin 72464 >>Turn in The Kosh'harg
.target Farseer Aggralan
step
.goto 1,52.20,43.00
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farseer Aggralan|r
.turnin 72464 >>Turn in The Kosh'harg
.target Farseer Aggralan
.accept 72465 >>Accept The Blessing of the Land
.accept 72476 >>Accept The Blessing of the Ancestors
.accept 72467 >>Accept The Blessing of the Clan
step
.goto 1,53.54,42.61,10,0
.goto 1,53.91,42.89,10,0
.goto 1,54.01,42.67
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thega Graveblade|r and accept the prompt.
*|cRXP_WARN_The clan can be changed at a later time if you want.|r
.complete 72467,1 
.skipgossip 199151,1
.target Thega Graveblade
step
.goto 1,52.11,42.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eitrigg|r
.accept 74581 >>Accept The Long Knives
.target Eitrigg
step
.goto 1,50.73,42.69
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cook Torka|r
.turnin 72476 >>Turn in The Blessing of the Ancestors
.target Cook Torka
.accept 74374 >>Accept An Important Heirloom
step
.goto 1,50.76,42.63
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Arugi|r and learn cooking.
.complete 74374,2 
.target Arugi
step
.goto 1,51.67,42.36,10,0
.goto 1,51.83,41.97,10,0
.goto 1,51.66,41.23
>>Click on the |cRXP_PICK_Old Cookbook|r
.complete 74374,1 
step
.goto 1,51.83,41.97,10,0
.goto 1,51.67,42.36,10,0
.goto 1,50.75,42.69
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cook Torka|r
.turnin 74374 >>Turn in An Important Heirloom
.target Cook Torka
.accept 72477 >>Accept Orcish Groceries
step
.goto 1,50.78,42.72
>>Click on the |cRXP_PICK_Spoons and Forks.|r
.complete 72477,1 
step
.goto 1,50.72,43.24
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nula the Butcher|r
.complete 72477,10 
.skipgossip
.buy 202027,3
.target Nula the Butcher
step
.goto 1,51.10,44.13
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Suja|r
.skipgossip
.buy 202029,3
.buy 202707,2
.buy 204793,3
.complete 72477,6 
.complete 72477,7 
.complete 72477,4 
.target Suja
step
#completewith next
.goto 1,51.39,44.19
.cast 6478 >>Click on the |cRXP_PICK_Crate|r
step
#loop
.goto 1,51.38,44.18,15,0
.goto 1,51.08,43.86,15,0
.goto 1,51.34,43.44,15,0
>>Click on the |cRXP_PICK_Escaped Crabs|r
.complete 72477,2 
.target Escaped Crab
step
.goto 1,51.58,43.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Razgar|r
.complete 72477,5 
.skipgossip
.buy 202028,5
.target Razgar
step
.goto 1,51.30,42.42
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kyl'kahn|r
.complete 72477,11 
.skipgossip
.target Kyl'kahn
step
.goto 1,50.84,41.42
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Far'kul Flametongue|r
.buy 202706,3
.buy 202030,3
.buy 202031,2
.complete 72477,9 
.complete 72477,8 
.complete 72477,3 
.skipgossip
.target Far'kul Flametongue
step
.goto 1,50.79,42.69
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Durak|r |cRXP_WARN_next to you.|r
.turnin 72477 >>Turn in Orcish Groceries
.target Durak
.accept 74415 >>Accept A Worthy Offering
step
.goto 1,40.80,26.88
>>Click on the |cRXP_PICK_Ancient Skeleton|r
.complete 72465,1 
step
.goto 1,40.59,26.78
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_The Spirit of Thunder Ridge|r
.turnin 72465 >>Turn in The Blessing of the Land
.target The Spirit of Thunder Ridge
.accept 72466 >>Accept The Spirit of Thunder Ridge
step
.goto 1,40.31,27.69
>>Click on the |cRXP_PICK_Ancient Seed|r
*|cRXP_WARN_Kill spawning |cRXP_ENEMY_Mud Elemental|r|r
.complete 72466,1 
.mob Mud Elemental
step
#loop
.goto 1,40.43,28.72,20,0
.goto 1,40.34,29.63,20,0
.goto 1,40.93,30.03,20,0
.goto 1,40.83,30.73,20,0
.goto 1,39.11,28.19,20,0
.goto 1,38.92,27.84,20,0
.goto 1,38.87,26.99,20,0
>>Click on the |cRXP_PICK_Ancient Seed|r
*|cRXP_WARN_Kill spawning |cRXP_ENEMY_Mud Elemental|r|r
.complete 72466,1 
.mob Mud Elemental
.mob Eroded Stone Elemental
.mob Flood Elemental
step
.goto 1,40.48,26.90
>>|cRXP_WARN_Follow the Arrow|r
.complete 72466,2 
step
.goto 1,40.60,26.77
>>Click on |cRXP_PICK_The Spirit of Thunder Ridge.|r
.complete 72466,3 
.target The Spirit of Thunder Ridge
step
.goto 1,52.21,42.99
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farseer Aggralan|r
.turnin 72466 >>Turn in The Spirit of Thunder Ridge
.target Farseer Aggralan
step
.goto 1,50.79,42.69
>>Open the Professions Book and select Cooking; cook the following
.complete 74415,3 
.complete 74415,1 
.complete 74415,2 
step
.goto 1,50.79,42.69
>>Cook |T2066013:0|t[Feast for the Ancestors]
.complete 74415,4 
step
.goto 1,53.13,45.76
>>Click on |cRXP_PICK_Feast for the Ancestors.|r
.complete 74415,5 
step
.goto 461,45.20,68.39
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kaltunk|r
.turnin 74581 >>Turn in The Long Knives
.target Kaltunk
.accept 72474 >>Accept Tracking a Killer
step
.goto 461,43.4,70.63
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Karranisha|r
.complete 72474,1,1 
.skipgossip
.target Karranisha
step
>>Vollow the arrow and wait near the |cRXP_FRIENDLY_Dead Peon|r
.complete 72474,1,2 
.skipgossip
.goto 461,46.01,63.39
.target Dead Peon
step
.goto 461,49.98,59.98
>>Click on |cRXP_PICK_Bag of Cactus Apples|r
.accept 72463 >>Accept Galgar's Cactus Apple Surprise...
.target Bag of Cactus Apples
step
.goto 461,49.98,59.98
>>Click on |cRXP_PICK_Bag of Cactus Apples|r
.complete 72463,1 
.complete 72474,1,3 
step
.goto 461,54.25,62.52
>>Click on |cRXP_PICK_Beast Tracks|r
.complete 72474,1,4 
.skipgossip
step
.goto 461,52.42,68.61
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Terrified Peon|r
.complete 72474,1,5 
.skipgossip
.target Terrified Peon
step
.goto 461,45.13,68.43
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kaltunk|r
.turnin 72474 >>Turn in Tracking a Killer
.target Kaltunk
.accept 72475 >>Accept Cornering Gor'krosh
step
.goto 1,59.28,63.38
>>|cRXP_WARN_Follow the Arrow|r
.complete 72475,1 
step
#completewith next
.goto 1,59.28,63.38
.cast 384743 >>Click on |cRXP_PICK_Raptor Nest|r
.timer 5,RP
step
.goto 1,59.15,63.43
>>Kill |cRXP_ENEMY_Gor'krosh.|r Loot them for |cRXP_LOOT_Long Knife|r
.complete 72475,2 
.complete 72475,4 
.mob Gor'krosh
step
.goto 1,59.14,63.51
>>Click on |cRXP_PICK_Raptor Blood|r
.complete 72475,3 
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Tauren Heritage Armor
#displayname |cRXP_WARN_Chapter 4 -|r Tauren Goblin Heritage Quests
#next 6) Item Information
<< Horde Tauren
step
#sticky
*|cRXP_WARN_Chapter 4:|r Heritage Armor Quests
*Guides you through the heritage armor questline and stops when you have the optimal quests set up, ready to turn in for the best experience at launch.
+|cRXP_WARN_This questline can only be completed once per account.|r
step
.goto 88,60.29,51.73
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Spiritwalker Ussoh|r
.turnin 54759 >>Turn in When Spirits Whisper
.accept 54760 >>Accept The Spiritwalkers
.target Spiritwalker Ussoh
step
.goto 462,12.18,31.27
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Baine Bloodhoof|r
.turnin 54760 >>Turn in The Spiritwalkers
.accept 54761 >>Accept Spirit Guide
.target Baine Bloodhoof
step
#completewith next
.goto 462,12.55,31.36
.cast 6478,1 >>Click on the |cRXP_PICK_Spiritwalker's Incense|r
.timer 23,RP
step
.isOnQuest 54761
>>Wait until the objective completes.
.complete 54761,1 
step
.goto 462,12.15,31.28
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Spiritwalker Ussoh|r
.turnin 54761 >>Turn in Spirit Guide
.target Spiritwalker Ussoh
.accept 54762 >>Accept A Small Retreat
step
.goto 65,49.18,60.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Spiritwalker Ussoh|r
.turnin 54762 >>Turn in A Small Retreat
.accept 54763 >>Accept Crossing Over
.target Spiritwalker Ussoh
step
.goto 65,49.18,60.93
>>Use the |T921387:0|t[Spiritwalker's Hallowed Vessel]
.complete 54763,1 
.use 166899
step
#completewith next
.goto 65,49.54,61.46,20,0
.goto 65,49.2,62.98,20,0
.goto 65,48.15,63.06,20,0
.goto 65,48.05,64.45,20,0
.goto 65,48.86,65.36,20 >> Follow the Arrow |cRXP_WARN_stay close to the|r |cRXP_FRIENDLY_Ancient Kodo|r
.target Ancient Kodo
step
.goto 65,50.05,65.68
>>Kill |cRXP_ENEMY_Necrofiends|r
.complete 54763,2 
.mob Necrofiend
step
.goto 65,49.17,60.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Spiritwalker Ussoh|r
.turnin 54763 >>Turn in Crossing Over
.target Spiritwalker Ussoh
step
.goto 65,49.17,60.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Spiritwalker Ussoh|r
.target Spiritwalker Ussoh
.accept 54764 >>Accept Storm in Bloodhoof
step
.goto 7,47.49,55.94
>>Follow the Arrow
.complete 54764,1 
step
#loop
.goto 7,46.84,56.95,30,0
.goto 7,47.68,59.2,30,0
.goto 7,48.43,57.22,30,0
>>Interact with |cRXP_FRIENDLY_Bloodhoof Villager|r and |cRXP_FRIENDLY_Trapped Kodo.|r
*Click on |cRXP_PICK_Spirit Portals|r
*Kill |cRXP_ENEMY_Necrofiends|r and |cRXP_ENEMY_Malicious Spirits.|r
.complete 54764,2 
.mob Necrofiend
.mob Malicious Spirit
.target Bloodhoof Villager
.target Trapped Kodo
step
.goto 88,58.21,51.78
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Baine Bloodhoof|r
.turnin 54764 >>Turn in Storm in Bloodhoof
.target Baine Bloodhoof
step
.goto 88,58.21,51.78
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Baine Bloodhoof|r
.target Baine Bloodhoof
.accept 54766 >>Accept Answer the Call
step
#completewith next
.goto 88,58.21,51.78
.gossipoption 49999 >>Talk to |cRXP_FRIENDLY_Baine Bloodhoof|r
step
.goto 88,55.63,50.91
>>Kill |cRXP_ENEMY_Malevolent Spirit|r
.complete 54766,1 
.mob Malevolent Spirit
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Undead Heritage Armor
#displayname |cRXP_WARN_Chapter 4 -|r Undead Heritage Quests
#next 6) Item Information
<< Horde Undead
step
.goto 85,50.70,75.57
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calia Menethil|r
.accept 65656 >>Accept Call to Lordaeron
.target Calia Menethil
step
.goto 85,50.85,75.39
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Forsaken Dreadmage|r
.complete 65656,1 
.skipgossip
.target Forsaken Dreadmage
step
.goto 2070,60.83,51.98,10,0
.goto 2070,60.80,51.37
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calia Menethil|r
.turnin 65656 >>Turn in Call to Lordaeron
.target Calia Menethil
.accept 65657 >>Accept Assemble the Forsaken
step
.goto 2070,61.97,50.51
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dark Ranger Velonara|r
.accept 65658 >>Accept This Land is Ours
.complete 65657,1 
.skipgossip
.target Dark Ranger Velonara
step
.goto 2070,63.47,49.21
>>Kill |cRXP_ENEMY_Blighted Soldiers and Shadowmages|r
.complete 65658,1 
.mob Blighted Soldiers
.mob Blighted Shadowmages
step
.goto 2070,63.23,55.52
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Apothecary Faranell|r
.complete 65657,3 
.skipgossip 185794,1
.target Master Apothecary Faranell
step
.goto 2070,57.57,49.20
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lilian Voss|r
.complete 65657,2 
.target Lilian Voss
.skipgossip 185793,1
step
.goto 2070,60.84,51.96,10,0
.goto 2070,60.80,51.56
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dark Ranger Velonara|r
.turnin 65658 >>Turn in This Land is Ours
.target Dark Ranger Velonara
step
.goto 2070,60.90,51.34
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lilian Voss|r
.turnin 65657 >>Turn in Assemble the Forsaken
.target Lilian Voss
.accept 65659 >>Accept The Blight Congress
step
#completewith next
.gossipoption 54673 >>Talk to |cRXP_FRIENDLY_Lilian Voss|r
.timer 50,RP
.target Lilian Voss
step
.goto 2070,60.79,51.36
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calia|r
.complete 65659,3 
.skipgossip 185512,1
.target Calia
step
.goto 2070,61.97,55.67
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calia Menethil|r
.turnin 65659 >>Turn in The Blight Congress
.target Calia Menethil
.accept 65660 >>Accept Walk of Faith
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calia|r
.complete 65660,1 
.skipgossip
.target Calia
step
>>Defend |cRXP_FRIENDLY_Calia Menethil.|r Use your |cRXP_WARN_[ExtraActionButton]|r once it activates
.complete 65660,2 
.target Calia Menethil
.mob Blighted Soldier
.mob Blighted Lieutenant
step
>>Defend |cRXP_FRIENDLY_Calia Menethil.|r
.complete 65660,3 
.target Calia Menethil
.mob Blighted Soldier
.mob Blighted Lieutenant
step
.goto 2070,61.92,55.57
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lilian Voss|r
.turnin 65660 >>Turn in Walk of Faith
.target Lilian Voss
.accept 65661 >>Accept Consulting Our Allies
step
#completewith next
.zone 1536 >> Take the portal to Maldraxxus
step
.goto 1536,74.76,33.65
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Margrave Sin'dane|r
.turnin 65661 >>Turn in Consulting Our Allies
.target Margrave Sin'dane
.accept 65662 >>Accept House of Plagues
step
#completewith next
.goto 1536,73.56,33.4,10,0
.goto 1536,74.29,33.88,5 >>Take the Portal to the Surface
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Plague Deviser Marileth|r and |cRXP_FRIENDLY_Calia Menethil|r
.turnin 65662 >>Turn in House of Plagues
.target Plague Deviser Marileth
.accept 65664 >>Accept Essence of Plague
.goto 1536,71.15,71.47
.accept 65663 >>Accept Feed the Eater
.goto 1536,71.15,71.38
.target Calia Menethil
step
#completewith Tumultuous Concoction
>>Kill |cRXP_ENEMY_Plaguerocs|r, |cRXP_ENEMY_Concentrated Plague|r and |cRXP_ENEMY_Undiluted Plague|r
.complete 65663,1 
.mob Plagueroc
.mob Concentrated Plague
.mob Undiluted Plague
step
.goto 1536,70.96,74.06
>>Click on the |cRXP_PICK_Simmering Concoction|r
.complete 65664,1 
step
.goto 1536,69.66,75.59
>>Click on the |cRXP_PICK_Unstable Concoction|r
.complete 65664,2 
step
#label Tumultuous Concoction
.goto 1536,68.53,79.82
>>Click on the |cRXP_PICK_Tumultuous Concoction|r
.complete 65664,3 
step
#loop
.goto 1536,69.66,75.59,40,0
.goto 1536,70.96,74.06,40,0
.goto 1536,68.53,79.82,40,0
>>Kill |cRXP_ENEMY_Plaguerocs|r, |cRXP_ENEMY_Concentrated Plague|r and |cRXP_ENEMY_Undiluted Plague|r
.complete 65663,1 
.mob Plagueroc
.mob Concentrated Plague
.mob Undiluted Plague
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calia Menethil|r and |cRXP_FRIENDLY_Plague Deviser Marileth|r
.turnin 65663 >>Turn in Feed the Eater
.goto 1536,68.66,81.69
.target +Calia Menethil
.turnin 65664 >>Turn in Essence of Plague
.goto 1536,68.67,81.76
.target +Plague Deviser Marileth
.accept 65665 >>Accept Embodiment
step
.goto 1536,68.27,84.58
>>Kill |cRXP_ENEMY_Lordaeron Blight|r
.complete 65665,1 
.mob Lordaeron Blight
step
.goto 1536,68.61,81.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lilian Voss|r
.turnin 65665 >>Turn in Embodiment
.target Lilian Voss
.accept 65666 >>Accept Return to Brill
step
#completewith next
.cast 368788 >>Use |T413582:0|t[Lilian's Hearthstone]
.use 191029
step
.goto 2070,60.83,52.01,10,0
.goto 2070,65.78,60.13
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Apothecary Faranell|r
.complete 65666,1 
.skipgossip 185731,1
.target Master Apothecary Faranell
step
.goto 2070,65.78,60.13
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Apothecary Faranell|r
.turnin 65666 >>Turn in Return to Brill
.target Master Apothecary Faranell
step
.goto 2070,65.84,60.38
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calia Menethil|r
.accept 65667 >>Accept The Remedy of Lordaeron
.target Calia Menethil
step
.goto 2070,65.70,59.81
>>Interact with a |cRXP_FRIENDLY_Shadowbat|r
.complete 65667,1 
.target Shadowbat
step
>>Use (1) and (2) on cooldown and if you are close to the purple arrow then priotize using it on it.
.complete 65667,2 
step
.goto 2070,63.28,69.71
>>Kill |cRXP_ENEMY_Amalgam|r using 3 and 4. 5 to heal
.complete 65667,3 
.mob Amalgam
step
.goto 2070,61.85,67.73
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lilian Voss|r
.turnin 65667 >>Turn in The Remedy of Lordaeron
.target Lilian Voss
.accept 65668 >>Accept The Desolate Council
.timer 60,RP
step
.goto 2070,61.78,67.99
.complete 65668,1 
Council
step
.goto 2070,61.79,67.78
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calia Menethil|r, |cRXP_FRIENDLY_Dark Ranger Velonara|r and |cRXP_FRIENDLY_Lilian Voss|r
.turnin 65668 >>Turn in The Desolate Council
.target +Calia Menethil
.turnin 66091 >>Turn in Path of the Dark Ranger
.goto 2070,61.73,67.74
.target +Dark Ranger Velonara
.accept 65788 >>Accept A Walk with Ghosts
.goto 2070,61.86,67.76
.target Lilian Voss
step
.goto 2070,61.84,71.51
>>|cRXP_WARN_Follow the Arrow|r
.complete 65788,1 
step
.goto 2070,61.84,72.83
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calia Menethil|r
.turnin 65788 >>Turn in A Walk with Ghosts
.target Calia Menethil
.accept 76530 >>Accept Unliving Summons
step
.goto 2070,63.76,68.16
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lilian Voss|r
.turnin 76530 >>Turn in Unliving Summons
.target Lilian Voss
.accept 72854 >>Accept Our Enemies Abound
step
.goto 2070,61.21,82.75
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Belmont|r
.complete 72854,1 
.skipgossip 199761,1
.target Belmont
step
.goto 2070,61.21,82.75
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Deathstalker Commander Belmont|r
.turnin 72854 >>Turn in Our Enemies Abound
.target Deathstalker Commander Belmont
.accept 72855 >>Accept To the Sepulcher
step
.goto 2070,61.17,82.39
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Forsaken Dreadmage|r
.complete 72855,1 
.skipgossip
.target Forsaken Dreadmage
step
.goto 21,42.66,40.84,10,0
.goto 21,42.68,41.44,10,0
.goto 21,45.57,42.05
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dark Ranger Velonara|r
.turnin 72855 >>Turn in To the Sepulcher
.target Dark Ranger Velonara
.accept 72858 >>Accept Acid Beats Paper
step
.goto 21,45.57,42.05
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Apothecary Faranell|r
.accept 72856 >>Accept Nothing Like the Classic
.target Master Apothecary Faranell
.accept 72857 >>Accept Boom Weed
step
#completewith Notice to All Undead
>>Kill |cRXP_ENEMY_Plagued Wolf,|r |cRXP_ENEMY_Sickly Deer|r and |cRXP_ENEMY_Plagued Bear.|r Loot them for |cRXP_LOOT_Plagued Flesh|r
.complete 72856,1 
.mob Plagued Wolf
.mob Sickly Deer
.mob Plagued Bear
step
#completewith Notice to All Undead
>>Click on the |cRXP_PICK_Boom Weed.|r
.complete 72857,1 
step
.goto 21,46.67,47.08
>>Use |T132104:0|t[Acid Rifle] infront of the paper.
.complete 72858,1,1 
step
.goto 21,45.61,47.37
>>Use |T132104:0|t[Acid Rifle] infront of the paper.
.complete 72858,1,2 
step
.goto 21,46.95,50.23
>>Use |T132104:0|t[Acid Rifle] infront of the paper.
.complete 72858,1,3 
step
#label Notice to All Undead
.goto 21,48.35,48.83
>>Use |T132104:0|t[Acid Rifle] infront of the paper.
.complete 72858,1,4 
step
#hidewindow
#completewith Plagued Flesh
#loop
.goto 21,48.05,52.44,40,0
.goto 21,46.47,54.45,40,0
.goto 21,43.59,50.86,40,0
.goto 21,46.69,44.83,40,0
+1
step
#completewith next
>>Kill |cRXP_ENEMY_Plagued Wolf,|r |cRXP_ENEMY_Sickly Deer|r and |cRXP_ENEMY_Plagued Bear.|r Loot them for |cRXP_LOOT_Plagued Flesh|r
.complete 72856,1 
.mob Plagued Wolf
.mob Sickly Deer
.mob Plagued Bear
step
>>Click on the |cRXP_PICK_Boom Weed.|r
.complete 72857,1 
step
#label Plagued Flesh
>>Kill |cRXP_ENEMY_Plagued Wolf,|r |cRXP_ENEMY_Sickly Deer|r and |cRXP_ENEMY_Plagued Bear.|r Loot them for |cRXP_LOOT_Plagued Flesh|r
.complete 72856,1 
.mob Plagued Wolf
.mob Sickly Deer
.mob Plagued Bear
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 6) Item Information
#displayname |cRXP_WARN_Chapter 5 -|r Item Showcase
#next 7) Item Setup
step
#sticky
*|cRXP_WARN_Chapter 5:|r Item Showcase
*Highlights useful items for leveling, allowing you to choose which ones to pursue. |cRXP_WARN_Mandatory items will be highlighted.|r
*|cRXP_WARN_This list includes some items too niche for |cRXP_WARN_Chapter 5 -|r Item Preparation|r
+|cFFFF0000This chapter is click-through. To proceed, simply click on the circle next to the text.|r
step
+|T4644002:0|t[Draconic Augment Runes] increases your Main stat.
step !Shaman/!Mage/!Hunter/!Evoker
+|T4559221:0|t[Feral Hide Drums] increases Haste by 15% for you and your party(shares cd with other bloodlust effects)
step
+|T5088843:0|t[Potion of Withering Dreams] is a strong healing potion but you will get minor damage for 30seconds after it's use.
step
+|T134014:0|t[Shadowberries] can regenerate up to 10% max health every 5 seconds.
.mob Mother Om'ra
step
+|T4497566:0|t[Potion of Gust] will propel you forward a short distance.
step
+|T1405809:0|t[Gunshoes] significantly boost your Movement speed and allow you to travel on water for a short period of time.
step
+|T133632:0|t[Goblin Glider Kit] propel you forward and allow you to slowfall for 2minutes or when you hit the ground.
step
+|T1405811:0|t[Leystone Buoy] will propel you to the ocean surface.
step
+|T1373906:0|t[Felslate Anchors] will pull you straight down in the ocean.
step
+|T134042:0|t[Unagi Skewer] deals damage to attackers(very minimal gain).
step
+|T134263:0|t[Tuft of Yak Fur] is an |cFFFF0000extremely useful items for traveling short to medium distances.|r
step
+|T986491:0|t[Loot-A-Rang]|cFFFF0000is an extremely useful during questing as it allows you to loot mobs from a far away range.|r
step
+The |T461816:0|t[Banner of Cooperation], |T461817:0|t[Standard of Unity], and |T461818:0|t[Battle Standard of Coordination] provide a significant XP boost, increasing the XP gained from monsters by up to 15% as long as you stay within 100 yards of the banner.
step
+|T1444943:0|t[Legion Dalaran Hearthstone] teleports you to Legion Dalaran and |cFFFF0000is mandatory; without it, the launch turn-in guide will not work as effectively.|r
step
+|T461813:0|t[Shroud of Cooperation], |T461814:0|t[Wrap of Unity] and |T461812:0|t[Cloak of Coordination] |cFFFF0000are mandatory; without them, the launch turn-in guide will not work as effectively.|r
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 7) Item Setup
#displayname |cRXP_WARN_Chapter 6 -|r Item Preparation
#next 8) Turnin Route Hearthstone Locations
step
#sticky
*|cRXP_WARN_Chapter 6:|r Item Preparation
+Guides you through the acquisition of the items. |cRXP_WARN_Items not supported will be highlighted.|r
step
#completewith Dalaran Hearthstone
.isQuestAvailable 40519
+Unlock/Obtain |T1444943:0|t[Dalaran Hearthstone] |cRXP_WARN_Mandatory for Launch Turnin Guide|r
*|cFFFF0000You can manually skip this step.|r
step << Alliance
.isQuestAvailable 40519
.zone 84 >> Go to Stormwind
step << Alliance
.isQuestAvailable 40519
.goto 84,62.90,71.54,-1
.goto 84,62.22,30,-1
>>Click on the |cRXP_PICK_Hero's Call Board|r
.accept 40519 >>Accept Legion: The Legion Returns
step << Alliance
.goto 84,37.07,43.11
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Recruiter Lee|r
.turnin 40519 >>Turn in Legion: The Legion Returns
.target Recruiter Lee
step << Alliance
.goto 84,37.07,43.11
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Recruiter Lee|r to skip the Broken Shore Scenario
*|cRXP_WARN_If you are unable to skip the scenario or don't want to|r |cFFFF0000manually skip this step.|r
.accept 44184 >>Accept In the Blink of an Eye
.skipgossip
.target Recruiter Lee
step << Alliance
.isQuestAvailable 44184
.goto 84,37.07,43.11
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Recruiter Lee|r
.target Recruiter Lee
.accept 42782 >>Accept To Be Prepared
step << Alliance
.isQuestAvailable 44184
.goto 84,29.83,42.96
>>Click on the |cRXP_PICK_Barrel|r
.complete 42782,1 
step << Alliance
.isQuestAvailable 44184
.goto 84,32.6,35.17
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zelena Moonbreak|r then defeat him.
.complete 42782,4 
.skipgossip
.mob Zelena Moonbreak
.target Zelena Moonbreak
step << Alliance
.isQuestAvailable 44184
.goto 84,30.09,34.27
>>Click on the |cRXP_PICK_Light-Infused Crystals|r
.complete 42782,2 
step << Alliance
.isQuestAvailable 44184
.goto 84,29.70,30.15
>>Click on the |cRXP_PICK_Food|r
.complete 42782,3 
step << Alliance
.isQuestAvailable 44184
.goto 84,19.00,26.45
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Knight Dameron|r
.turnin 42782 >>Turn in To Be Prepared
.target Knight Dameron
step << Alliance
.isQuestAvailable 44184
.goto 84,19.00,26.45
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Knight Dameron|r
.target Knight Dameron
.accept 42740 >>Accept The Battle for Broken Shore
step << Alliance
.isOnQuest 42740
.goto 84,19.90,29.44
|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Angelica|r and wait for a moment until the transfer to the Broken Shore.
*|cFFFF0000After completing the objective, you can skip the cutscene by pressing 'Escape' and accepting the prompt.|r
.complete 42740,1 
.skipgossip
.target Captain Angelica
step << Alliance
.isOnQuest 42740
.goto 619,53.66,72.9,10 >>Wait for our ship to dock.
*|cFFFF0000After completing the objective, you can skip the cutscene by pressing 'Escape' and accepting the prompt.|r
step << Alliance
.isOnQuest 42740
.goto 619,53.51,72.44,10 >>|cRXP_WARN_Follow the Arrow|r
.timer 1140, Time until scenario auto-completes.
step << Alliance
.isOnQuest 42740
#completewith guldanscenarioend
+You can let the NPCs complete |cRXP_WARN_the entire scenario for you.|r While it's around 5minutes slower, you can choose to either partake or wait until they finish.
*|cRXP_WARN_Feel free to manually skip this step|r
step << Alliance
.isOnQuest 42740
#completewith next
>>Kill |cRXP_ENEMY_Demons|r and |cRXP_ENEMY_Felguards|r |cRXP_WARN_infront of each pillar|r
.scenario 1522,1
.scenario 1522,2
.mob Fel Lord Rakkan
.mob Fel Lord Kurduz
.mob Fel Lord Zardak
.mob Felguard Legionnaire
.mob Felstalker Dreadhound
step << Alliance
.isOnQuest 42740
#loop
.goto 619,53.17,72.03,8,0
.goto 619,53.13,71.96,8,0
.goto 619,53.18,71.9,8,0
.goto 619,53.22,71.92,8,0
>>Destroy |cRXP_WARN_Spires of Woe|r by killing |cRXP_ENEMY_Anchoring Crystal|r
.scenario 1522,3,1
.mob Anchoring Crystal
step << Alliance
.isOnQuest 42740
#loop
.goto 619,53.01,72.4,8,0
.goto 619,52.93,72.44,8,0
.goto 619,52.92,72.34,8,0
>>Destroy |cRXP_WARN_Spires of Woe|r by killing |cRXP_ENEMY_Anchoring Crystal|r
.scenario 1522,3,2
.mob Anchoring Crystal
step << Alliance
.isOnQuest 42740
#loop
.goto 619,53.46,71.81,8,0
.goto 619,53.54,71.72,8,0
.goto 619,53.55,71.85,8,0
>>Destroy |cRXP_WARN_Spires of Woe|r by killing |cRXP_ENEMY_Anchoring Crystal|r
.scenario 1522,3,3
.mob Anchoring Crystal
step << Alliance
.isOnQuest 42740
>>Kill |cRXP_ENEMY_Demons|r and |cRXP_ENEMY_Felguards|r |cRXP_WARN_infront of each pillar|r
.scenario 1522,1
.scenario 1522,2
.mob Fel Lord Rakkan
.mob Fel Lord Kurduz
.mob Fel Lord Zardak
.mob Felguard Legionnaire
.mob Felstalker Dreadhound
step << Alliance
.isOnQuest 42740
.goto 619,53.39,72.39
>>Kill |cRXP_ENEMY_Dread Commander Arganoth|r
.scenario 2685,1
.mob Dread Commander Arganoth
step << Alliance
.isOnQuest 42740
.target Lady Jaina Proudmoore
.goto 619,52.89,69.9,10 >>|cRXP_WARN_Follow|cRXP_FRIENDLY_Jaina|r and the crew.|r
.scenario 1589,1
step << Alliance
.isOnQuest 42740
.target Lady Jaina Proudmoore
.goto 619,51.29,66.75
.scenario 1589,1 >>Follow the arrow and wait for the new objective to appear.
step << Alliance
.isOnQuest 42740
.goto 619,51.34,66.58
.scenario 1532,1,1 >>Kill |cRXP_ENEMY_Eredar Chaos Guard|r to remove the shield from the |cRXP_ENEMY_Shielded Anchors.|r Once the shield is down,|cRXP_ENEMY_Shielded Anchor|r
.mob Shielded Anchor
.mob Eredar Chaos Guard
step << Alliance
.isOnQuest 42740
.goto 619,51.38,66.57
.scenario 1532,1,2 >>Kill |cRXP_ENEMY_Eredar Chaos Guard|r to remove the shield from the |cRXP_ENEMY_Shielded Anchors.|r Once the shield is down,|cRXP_ENEMY_Shielded Anchor|r
.mob Shielded Anchor
.mob Eredar Chaos Guard
step << Alliance
.isOnQuest 42740
.goto 619,51.55,66.64
.scenario 1532,1,3 >>Kill |cRXP_ENEMY_Eredar Chaos Guard|r to remove the shield from the |cRXP_ENEMY_Shielded Anchors.|r Once the shield is down,|cRXP_ENEMY_Shielded Anchor|r
.mob Shielded Anchor
.mob Eredar Chaos Guard
step << Alliance
.isOnQuest 42740
.goto 619,51.56,66.82
.scenario 1532,1,4 >>Kill |cRXP_ENEMY_Eredar Chaos Guard|r to remove the shield from the |cRXP_ENEMY_Shielded Anchors.|r Once the shield is down,|cRXP_ENEMY_Shielded Anchor|r
.mob Shielded Anchor
.mob Eredar Chaos Guard
step << Alliance
.isOnQuest 42740
#loop
.goto 619,52.41,68.37,30,0
.goto 619,52.59,68.53,30,0
.goto 619,52.83,67.77,30,0
.goto 619,52.69,66.34,30,0
.goto 619,52.82,65.56,30,0
.goto 619,52.5,65.38,30,0
.goto 619,52.2,65.57,30,0
.goto 619,52.06,66.48,30,0
.scenario 1505,1 >>Kill |cRXP_ENEMY_Demon Elites,|r |cRXP_ENEMY_Demons|r and open |cRXP_PICK_Legion Cages|r
.mob Infernal Siegebreaker
.mob Wrathguard Dreadblade
.mob Felguard Invader
.mob Dark Worshipper
.mob Soulbound Destructor
.mob Mother Virila
.mob Shadowflame Imp
.mob Fiery Trickster
.mob Eredar Chaos Guard
.mob Fel Lord Dukaz
.mob Shielded Anchor
.mob Mo'arg Painbringer
.mob Burning Sentry
.mob Fel Lord Rakaz
.mob Shadowsworn Harbinger
.target Argent Dawnbringer
step << Alliance
.isOnQuest 42740
.scenario 1506,1 >>|cRXP_WARN_Follow |cRXP_FRIENDLY_Lady Jaina Proudmoore|r and it's crew.|r
.target Lady Jaina Proudmoore
step << Alliance
.isOnQuest 42740
.goto 619,54.88,64.48
.scenario 1761,1 >>Kill |cRXP_ENEMY_Krosus|r
.mob Krosus
step << Alliance
.isOnQuest 42740
.goto 619,55.37,63.52,10 >>|cRXP_WARN_Follow |cRXP_FRIENDLY_Lady Jaina Proudmoore|r and it's crew.|r
step << Alliance
.isOnQuest 42740
#loop
.goto 619,55.47,63.38,10,0
.goto 619,55.37,63.52,10,0
>>Kill the onslaught of |cRXP_ENEMY_Demons|r
*|cFFFF0000After completing the objective, you can skip the cutscene by pressing 'Escape' and accepting the prompt.|r
.complete 42740,2 
.mob Mo'arg Spinebreaker
.mob Wrathguard Dreadblade
step << Alliance
#label guldanscenarioend
.isQuestComplete 42740
.goto 84,20.09,34.91
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Genn Greymane|r
.turnin 42740 >>Turn in The Battle for Broken Shore
.target Genn Greymane
step << Alliance
.isQuestAvailable 44184
.goto 84,20.09,34.91
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Genn Greymane|r
.target Genn Greymane
.accept 40517 >>Accept The Fallen Lion
step << Alliance
.isOnQuest 40517
.goto 84,83.98,30.73,15,0
.goto 84,85.87,31.61
>>|cRXP_WARN_Manually fly to Stormwind Keep, ignoring the gryphon.|r
.complete 40517,1 
step << Alliance
.isOnQuest 40517
.goto 84,85.89,31.6
.gossipoption 45042 >>Talk to |cRXP_FRIENDLY_Anduin Wrynn|r
.target Anduin Wrynn
.timer 83, Time until Completion
step << Alliance
.isOnQuest 40517
.goto 84,85.89,31.60
>>Wait until the objective is complete.
.complete 40517,2 
step << Alliance
.isOnQuest 40517
.goto 84,85.89,31.60
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Anduin Wrynn|r
.turnin 40517 >>Turn in The Fallen Lion
.target Anduin Wrynn
step << Alliance
.isQuestTurnedIn 40517
.goto 84,85.32,32.27
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jace Darkweaver|r
.accept 40593 >>Accept Demons Among Us
.target Jace Darkweaver
step << Alliance
.isOnQuest 40593
.goto 84,85.32,32.27
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jace Darkweaver|r
*|cFFFF0000After completing the objective, you can skip the cutscene by pressing 'Escape' and accepting the prompt.|r
.target Jace Darkweaver
.complete 40593,1 
.skipgossip
step << Alliance
#completewith next
.isOnQuest 40593
>>Kill |cRXP_ENEMY_Felblade Assassin|r
.complete 40593,2 
.mob Felblade Assassin
step << Alliance
.isOnQuest 40593
.goto 84,82.39,27.87
>>Click on the |cRXP_PICK_Portal|r
.complete 40593,3 
step << Alliance
#loop
.goto 84,81.44,25.94,30,0
.goto 84,80.02,27.61,30,0
.goto 84,82.3,31.75,30,0
.goto 84,85.01,28.43,30,0
.goto 84,82.82,24.29,30,0
.isOnQuest 40593
>>Kill |cRXP_ENEMY_Felblade Assassin|r
.complete 40593,2 
.mob Felblade Assassin
step << Alliance
.isOnQuest 40593
.goto 84,83.95,30.65,10,0
.goto 84,85.75,31.73
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Anduin Wrynn|r
.turnin 40593 >>Turn in Demons Among Us
.target Anduin Wrynn
step << Alliance
.isQuestTurnedIn 40593
.goto 84,85.75,31.73
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Anduin Wrynn|r
.target Anduin Wrynn
.accept 44120 >>Accept Illidari Allies
step << Alliance
.isOnQuest 44120
.goto 84,83.14,29.15,10,0
.goto 84,40.28,77.70
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elerion Bladedancer|r
.turnin 44120 >>Turn in Illidari Allies
.target Elerion Bladedancer
step << Alliance
.isNotOnQuest 44184
.goto 84,40.28,77.70
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elerion Bladedancer|r
.target Elerion Bladedancer
.accept 44663 >>Accept In the Blink of an Eye
step << Alliance
.isOnQuest 44663
.goto 84,49.37,86.94,10 >> Follow the Arrow
step << Alliance
#label Dalaran Hearthstone
.isOnQuest 44663
.goto 84,49,87.58
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kirin Tor Emissary|r
.complete 44663,2 
.skipgossip
.target Kirin Tor Emissary
step << Alliance
.zoneskip 627,1
.goto 627,57.63,45.76
+|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Emissary Auldbridge|r |cRXP_WARN_and manually turn in the quest.|r
.target Emissary Auldbridge
step << Horde
.isQuestAvailable 43926
.zone 85 >> Go to Orgrimmar
step << Horde
.isQuestAvailable 43926
.goto 85,49.68,76.44
>>Click on the |cRXP_PICK_Warchief's Command Board|r and select [Fight the Legion]
.accept 43926 >>Accept Legion: The Legion Returns
step << Horde
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Holgar Stormaxe|r outside of Orgrimmar
.goto 1,46.00,13.80
.turnin 43926 >>Turn in Legion: The Legion Returns
.target Holgar Stormaxe
step << Horde
.isNotOnQuest 44184
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Holgar Stormaxe|r outside of Orgrimmar
.goto 1,46.00,13.80
.accept 44281 >>Accept To Be Prepared
.target Holgar Stormaxe
step << Horde
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Holgar Stormaxe|r to skip the Broken Shore Scenario
*|cRXP_WARN_If you are unable to skip the scenario or don't want to|r |cFFFF0000manually skip this step by, simply click on the circle next to Accept.|r.|r
.goto 1,46.01,13.81
.skipgossip
.accept 44184 >>Accept In the Blink of an Eye
step << Horde
.isQuestAvailable 44184
.goto 1,47.66,13.57
>>Click on the |cRXP_PICK_Food|r
.complete 44281,3 
step << Horde
.isQuestAvailable 44184
.goto 1,49.63,14.17
>>Click on the |cRXP_PICK_Barrel|r
.complete 44281,1 
step << Horde
.isQuestAvailable 44184
.goto 1,51.38,12.29
>>Click on the |cRXP_PICK_Sphere|r
.complete 44281,2 
step << Horde
.isQuestAvailable 44184
.goto 1,52.82,11.34
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Arienne Black|r and defeat her
.complete 44281,4 
.skipgossip
.mob Arienne Black
.target Arienne Black
step << Horde
.isQuestAvailable 44184
.goto 1,55.63,11.02
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Stone Guard Mukar|r
.turnin 44281 >>Turn in To Be Prepared
.target Stone Guard Mukar
step << Horde
.isQuestAvailable 44184
.goto 1,55.63,11.02
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Stone Guard Mukar|r
.target Stone Guard Mukar
.accept 40518 >>Accept The Battle for Broken Shore
step << Horde
.isOnQuest 40518
.goto 1,57.78,10.49
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Russo|r
*|cFFFF0000After completing the objective, you can skip the cutscene by pressing 'Escape' and accepting the prompt.|r
.complete 40518,1 
.skipgossip
.target Captain Russo
step << Horde
.isOnQuest 40518
.goto 619,54.43,72.28,10 >>Wait for our ship to dock.
*|cFFFF0000After completing the objective, you can skip the cutscene by pressing 'Escape' and accepting the prompt.|r
step << Horde
.isOnQuest 40518
.goto 619,54.43,71.8,10 >>|cRXP_WARN_Follow the Arrow|r
.timer 1140, Time until scenario auto-completes.
step << Horde
.isOnQuest 40518
#completewith guldanscenarioend
+You can let the NPCs complete |cRXP_WARN_the entire scenario for you.|r While it's around 5minutes slower, you can choose to either partake or wait until they finish.
*|cRXP_WARN_Feel free to manually skip this step|r
step << Horde
.isOnQuest 40518
#completewith next
>>Kill |cRXP_ENEMY_Demons|r and |cRXP_ENEMY_Felguards|r |cRXP_WARN_infront of each pillar|r
.scenario 2896,1
.scenario 2896,2
.mob Fel Lord Razzar
.mob Fel Lord Darakk
.mob Fel Lord Kurrz
.mob Felguard Legionnaire
.mob Felstalker Dreadhound
step << Horde
.isOnQuest 40518
#loop
.goto 619,54.35,71.25,8,0
.goto 619,54.29,71.11,8,0
.goto 619,54.41,71.13,8,0
>>Destroy |cRXP_WARN_Spires of Woe|r by killing |cRXP_ENEMY_Anchoring Crystal|r
.scenario 2896,3,1
.mob Anchoring Crystal
step << Horde
.isOnQuest 40518
#loop
.goto 619,54.61,71.28,8,0
.goto 619,54.68,71.26,8,0
.goto 619,54.67,71.36,8,0
>>Destroy |cRXP_WARN_Spires of Woe|r by killing |cRXP_ENEMY_Anchoring Crystal|r
.scenario 2896,3,2
.mob Anchoring Crystal
step << Horde
.isOnQuest 40518
#loop
.goto 619,54.05,71.1,8,0
.goto 619,53.99,71.2,8,0
.goto 619,54.04,71.27,8,0
>>Destroy |cRXP_WARN_Spires of Woe|r by killing |cRXP_ENEMY_Anchoring Crystal|r
.scenario 2896,3,3
.mob Anchoring Crystal
step << Horde
.isOnQuest 40518
>>Kill |cRXP_ENEMY_Demons|r and |cRXP_ENEMY_Felguards|r |cRXP_WARN_infront of each pillar|r
.scenario 2896,1
.scenario 2896,2
.mob Fel Lord Rakkan
.mob Fel Lord Kurduz
.mob Fel Lord Zardak
.mob Felguard Legionnaire
.mob Felstalker Dreadhound
step << Horde
.isOnQuest 40518
.goto 619,54.25,71.39
>>Kill |cRXP_ENEMY_Fel Commander Azgalor|r
.scenario 2897,1
.mob Fel Commander Azgalor
step << Horde
.isOnQuest 40518
.target Vol'jin
.goto 619,54.59,69.46,10 >>|cRXP_WARN_Follow |cRXP_FRIENDLY_Vol'jin|r and the crew.|r
step << Horde
.isOnQuest 40518
.target Vol'jin
>>Follow the arrow and wait for the new objective to appear.
.goto 619,54.51,68.08
.scenario 2898,1
step << Horde
.isOnQuest 40518
.goto 619,54.51,68.08
.scenario 2899,1,1 >>Kill |cRXP_ENEMY_Eredar Chaos Guard|r to remove the shield from the |cRXP_ENEMY_Shielded Anchors.|r Once the shield is down,|cRXP_ENEMY_Shielded Anchor|r
.mob Shielded Anchor
.mob Eredar Chaos Guard
step << Horde
.isOnQuest 40518
.goto 619,54.52,67.87
.scenario 2899,1,2 >>Kill |cRXP_ENEMY_Eredar Chaos Guard|r to remove the shield from the |cRXP_ENEMY_Shielded Anchors.|r Once the shield is down,|cRXP_ENEMY_Shielded Anchor|r
.mob Shielded Anchor
.mob Eredar Chaos Guard
step << Horde
.isOnQuest 40518
.goto 619,54.69,67.86
.scenario 2899,1,3 >>Kill |cRXP_ENEMY_Eredar Chaos Guard|r to remove the shield from the |cRXP_ENEMY_Shielded Anchors.|r Once the shield is down,|cRXP_ENEMY_Shielded Anchor|r
.mob Shielded Anchor
.mob Eredar Chaos Guard
step << Horde
.isOnQuest 40518
.goto 619,54.67,68.09
.scenario 2899,1,4 >>Kill |cRXP_ENEMY_Eredar Chaos Guard|r to remove the shield from the |cRXP_ENEMY_Shielded Anchors.|r Once the shield is down,|cRXP_ENEMY_Shielded Anchor|r
.mob Shielded Anchor
.mob Eredar Chaos Guard
step << Horde
#loop
.goto 619,55.12,68.47,30,0
.goto 619,55.38,68.51,30,0
.goto 619,55.56,68.49,30,0
.goto 619,55.76,68.1,30,0
.goto 619,55.82,67.6,30,0
.goto 619,55.71,67.08,30,0
.goto 619,55.39,66.61,30,0
.goto 619,55.14,66.93,30,0
.isOnQuest 40518
.scenario 2900,1 >>Kill |cRXP_ENEMY_Demon Elites,|r |cRXP_ENEMY_Demons|r and open |cRXP_PICK_Legion Cages|r
*|cFFFF0000Press escape to skip the Cutscene if you can|r
.mob Infernal Siegebreaker
.mob Wrathguard Dreadblade
.mob Felguard Invader
.mob Dark Worshipper
.mob Soulbound Destructor
.mob Mother Virila
.mob Shadowflame Imp
.mob Fiery Trickster
.mob Eredar Chaos Guard
.mob Fel Lord Dukaz
.mob Shielded Anchor
.mob Mo'arg Painbringer
.mob Burning Sentry
.mob Fel Lord Rakaz
.mob Shadowsworn Harbinger
.target Argent Dawnbringer
step << Horde
.isOnQuest 40518
.scenario 2901,1 >>|cRXP_WARN_Follow |cRXP_FRIENDLY_Lady Sylvanas Windrunner|r and it's crew.|r
.target Lady Sylvanas Windrunner
step << Horde
.isOnQuest 40518
.goto 619,55.13,65.01
.scenario 2902,1 >>Kill |cRXP_ENEMY_Krosus|r
.mob Krosus
step << Horde
.isOnQuest 40518
.goto 619,56.53,64.68,25,0
.goto 619,56.5,64.34,25,0
.goto 619,56.08,64.01,25,0
.goto 619,56.52,64.2,25,0
.goto 619,55.37,63.52,10 >>|cRXP_WARN_Follow |cRXP_FRIENDLY_Lady Sylvanas Windrunner|r and it's crew.|r
.target Lady Sylvanas Windrunner
step << Horde
.isOnQuest 40518
#loop
.goto 619,56.52,64.2
>>Kill the onslaught of |cRXP_ENEMY_Demons|r
*|cFFFF0000Press escape to skip the Cutscene if you can|r
.complete 40518,2 
.mob Mo'arg Spinebreaker
.mob Wrathguard Dreadblade
.mob Felguard Invader
.mob Grinning Shadowstalker
step << Horde
#label guldanscenarioend
.isQuestComplete 40518
.goto 1,57.16,10.51
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eitrigg|r
.turnin 40518 >>Turn in The Battle for Broken Shore
.target Eitrigg
step << Horde
.isQuestTurnedIn 40518
.goto 1,57.16,10.51
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eitrigg|r
.target Eitrigg
.accept 40522 >>Accept Fate of the Horde
step << Horde
.isOnQuest 40522
.goto 85,49.98,75.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Saurfang|r
.complete 40522,1 
.skipgossip
step << Horde
.isOnQuest 40522
.goto 85,48.38,71.22
>>Follow the arrow and wait for the new objective to appear.
*|cFFFF0000After completing the objective, you can skip the cutscene by pressing 'Escape' and accepting the prompt.|r
.complete 40522,3 
step << Horde
.isOnQuest 40522
.goto 1,45.71,15.88
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Sylvanas Windrunner|r
.complete 40522,4 
.skipgossip 100866,1
.target Lady Sylvanas Windrunner
step << Horde
.isQuestComplete 40522
.goto 1,45.71,15.88
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Sylvanas Windrunner|r
.turnin 40522 >>Turn in Fate of the Horde
.target Lady Sylvanas Windrunner
step << Horde
.isQuestTurnedIn 40522
.goto 1,45.71,15.88
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Sylvanas Windrunner|r
.target Lady Sylvanas Windrunner
.accept 40760 >>Accept Emissary
step << Horde
.isOnQuest 40760
.goto 1,45.81,15.13
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Allari the Souleater|r
.turnin 40760 >>Turn in Emissary
.target Allari the Souleater
step << Horde
.isOnQuest 40607
.goto 1,45.81,15.13
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Allari the Souleater|r
*|cFFFF0000After completing the objective, you can skip the cutscene by pressing 'Escape' and accepting the prompt.|r
.target Allari the Souleater
.complete 40607,1 
.skipgossip
step << Horde
.isOnQuest 40607
.goto 1,45.81,15.13
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Allari the Souleater|r
.target Allari the Souleater
.accept 40607 >>Accept Demons Among Us
step << Horde
.isOnQuest 40607
#loop
.goto 1,45.62,14.05,30,0
.goto 1,46.71,14.08,30,0
.goto 1,46.97,17.41,30,0
.goto 1,45.49,16.88,30,0
>>Kill |cRXP_ENEMY_Felblade Assassins|r and |cRXP_ENEMY_Shards of Hate|r
.complete 40607,2 
.mob Shard of Hate
.mob Felblade Assassin
step << Horde
.isQuestComplete 40607
.goto 1,45.68,15.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Sylvanas Windrunner|r
.turnin 40607 >>Turn in Demons Among Us
.target Lady Sylvanas Windrunner
step << Horde
.isQuestTurnedIn 40607
.goto 1,45.68,15.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Sylvanas Windrunner|r
.target Lady Sylvanas Windrunner
.accept 40605 >>Accept Keep Your Friends Close
step << Horde
.isQuestComplete 40605
.goto 85,52.34,57.18
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elthyn Da'rai|r
.turnin 40605 >>Turn in Keep Your Friends Close
.target Elthyn Da'rai
step << Horde
.isOnQuest 44663
.goto 85,52.85,90.57,10 >> Follow the Arrow
step << Horde
#label Dalaran Hearthstone
.isOnQuest 44663
.goto 619,46.33,64.42
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kirin Tor Emissary|r
.complete 44663,2 
.skipgossip
.target Kirin Tor Emissary
step << Horde
.zoneskip 627,1
.goto 627,57.62,45.70
+|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Emissary Auldbridge|r |cRXP_WARN_and manually turn in the quest.|r
.target Emissary Auldbridge
step
#completewith next
+Go to Pandaria
step
#loop
.goto 422,52.09,72.37
.goto 422,51.43,68.73
>>Kill |cRXP_ENEMY_Pengsong.|r Loot them for |cRXP_LOOT_Tuft of Yak Fur|r
.collect 89770,30 
.mob Pengsong
step
#completewith next
+Go to Draenor
step
.goto 539,43.95,57.65
>>Kill |cRXP_ENEMY_Mother Om'ra.|r Loot them for |cRXP_LOOT_Shadowberries|r
.collect 119449,40 
.mob Mother Om'ra
step
#completewith next
+Go to an Auction House
step
>>|cRXP_WARN_Buy the following items of the auction house;|r
*|cRXP_WARN_The quantity is a recommendation; only|r |T463898:0|t[Potion of Deepholm] |cRXP_WARN_is Mandatory.|r
.collect 132516,100 
.disablecheckbox
.collect 109076,100 
.disablecheckbox
.collect 136606,100 
.disablecheckbox
.collect 151239,1 
.disablecheckbox
.collect 201325,10 
.disablecheckbox
.collect 193470,20 
.disablecheckbox
.collect 207041,40 
.disablecheckbox
.collect 191398,20 
.disablecheckbox
.collect 58487,20 
.disablecheckbox
.collect 169280,5 
step << Horde
#completewith DMF1
.zone 85 >> Go to Orgrimmar
step << Horde
.goto 85,47.14,80.04
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Goram|r and buy the following items:
*|cRXP_WARN_If you cannot purchase the items, it may be due to one of the following reasons: you are not in a guild, your guild does not have the necessary achievements to unlock the items, or you lack the required reputation.|r
*|cRXP_WARN_If your current guild does not have the necessary achievements to unlock the items, consider temporarily joining another guild or working with a few guild members to unlock the necessary achievements.|r
*|cFFFF0000These items are mandatory.|r
.collect 63353,1 
.collect 63207,1 
.collect 65274,1 
.reputation 1168,revered >> Get Revered with a Guild
*|cRXP_WARN_While in a guild,|r complete max-level quests, including world quests, to increase your reputation. Raids, Mythic+ dungeons, and regular dungeons also reward reputation |cRXP_WARN_if the majority of your group is composed of guild members.|r
.target Goram
step << Horde
.goto 85,47.14,80.04
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Goram|r and buy the following items:
*|cRXP_WARN_If you cannot purchase the items, it may be due to one of the following reasons: you are not in a guild, your guild does not possess the items, or you lack the required reputation.|r
.collect 64400,1 
.collect 64401,1 
.collect 64402,1 
.reputation 1168,revered >>Get Revered with a Guild
*|cRXP_WARN_While in a guild,|r complete max-level quests, including world quests, to increase your reputation. Raids, Mythic+ dungeons, and regular dungeons also reward reputation |cRXP_WARN_if the majority of your group is composed of guild members.|r
.target Goram
step << Alliance
#completewith DMF1
.zone 84 >> Go to Stormwind
step << Alliance
.goto 84,64.16,77.03
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shay Pressler|r and buy the following items:
*|cRXP_WARN_If you cannot purchase the items, it may be due to one of the following reasons: you are not in a guild, your guild does not have the necessary achievements to unlock the items, or you lack the required reputation.|r
*|cRXP_WARN_If your current guild does not have the necessary achievements to unlock the items, consider temporarily joining another guild or working with a few guild members to unlock the necessary achievements.|r
*|cFFFF0000These items are mandatory.|r
.collect 63352,1 
.collect 63206,1 
.collect 65360,1 
.reputation 1168,revered >>Get Revered with a Guild
*|cRXP_WARN_While in a guild,|r complete max-level quests, including world quests, to increase your reputation. Raids, Mythic+ dungeons, and regular dungeons also reward reputation if the majority of your group is composed of guild members.
.target Shay Pressler
step << Alliance
.goto 84,64.16,77.03
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shay Pressler|r and buy the following items:
*|cRXP_WARN_If you cannot purchase the items, it may be due to one of the following reasons: you are not in a guild, your guild does not possess the items, or you lack the required reputation.|r
.collect 63359,1 
.collect 64398,1 
.collect 64399,1 
.reputation 1168,revered >>|cRXP_WARN_While in a guild,|r complete max-level quests, including world quests, to increase your reputation. Raids, Mythic+ dungeons, and regular dungeons also reward reputation if the majority of your group is composed of guild members.
.target Shay Pressler
step
>>Train Cataclysm Engineering to 70 and learn |T986491:0|t[Loot-A-Rang]
.collecttoy 60854 
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 8) Turnin Route Hearthstone Locations
#displayname |cRXP_WARN_Chapter 7 -|r Hearthstone Location for Turnins
#next 9) Turnin Route Alliance << Alliance
#next 9) Turnin Route Horde << Horde
step
#sticky
*|cRXP_WARN_Chapter 7:|r Hearthstone Locations
+Guides you through setting up the ideal hearthstone location for the turn-in process during launch based on your current quests.
step << Alliance Mage
#completewith next
.zone 84 >>Go to Stormwind
step << Alliance Mage
.goto 84,45.6,90.29
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Larimaine Purdue|r
.train 33690
.train 53140
.train 281403
.train 3561
.train 3562
.train 49360
.train 11419
.train 3465
.train 224869
.train 176248
.train 88342
.train 132621
.target Larimaine Purdue
step << Alliance Mage
.goto 84,48.89,93.44
.zone 2112 >>Take the Portal to Valdrakken
step << Alliance Mage
.goto 2112,59.21,42.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alregosa|r
.train 395277
.target Alregosa
step << Horde Mage
#completewith next
.zone 85 >>Go to Orgrimmar
step << Horde Mage
.goto 86,45.56,67.37
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rundok|r
.train 3567
.train 32272
.train 49358
.train 3566
.train 3562
.train 224869
.train 53140
.train 281404
.train 35715
.train 88344
.train 132627
.train 176242
.target Rundok
step << Horde Mage
.goto 85,57.11,87.37
.zone 2112 >>Take the Portal to Valdrakken
step << Horde Mage
.goto 2112,59.21,42.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alregosa|r
.train 395277
.target Alregosa
step
#completewith next
.zone 71 >>Go to Tanaris
step
.isOnQuest 83493,83494
.isNotOnQuest 54981,53845,72858,72856,72857,72467,77901,54766,57079
.goto 71,52.6,27.19,10,0
.goto 71,52.54,27.01
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Innkeeper Fizzgrimble|r
.home >>Set your Hearthstone to The Road Warrior
.target Innkeeper Fizzgrimble
step
#completewith next
.zone 47 >>Go to Duskwood
step
.isOnQuest 54981
.goto 47,73.87,44.41
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Innkeeper Trelayne|r
.home >>Set your Hearthstone to Scarlet Raven Tavern
.target Innkeeper Trelayne
step <<!Mage
#completewith next
.zone 87 >>Go to Ironforge
step <<!Mage
.isOnQuest 53845
.goto 87,18.13,51.47
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Innkeeper Firebrew|r
.home >>Set your Hearthstone to The Stonefire Tavern
.target Innkeeper Firebrew
step
#completewith next
.zone 87 >>Go to Silverpine Forest
step
.isOnQuest 72858,72856,72857
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Innkeeper Bates|r
.goto 21,46.42,42.70
.home >>Set your Hearthstone to The Sepulcher
.target Innkeeper Bates
step
#completewith next
.zone 1 >>Go to Durotar
step
.isOnQuest 72467,77901
.goto 1,51.51,41.64
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grosk|r
.home >>Set your Hearthstone to Razor Hill
.target Innkeeper Grosk
step
#completewith next
.zone 88 >>Go to Thunder Bluff
step
.isOnQuest 54766
.goto 88,45.84,64.71
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Pala|r
.home >>Set your Hearthstone to The Cat and the Shaman
.target Innkeeper Pala
step
#completewith next
.zone 210 >>Go to Stranglethorn Vale
step
.isOnQuest 57079
.goto 210,35.08,27.19
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Innkeeper Draxle|r
.home >>Set your Hearthstone to Hardwrench Hideaway
.target Innkeeper Draxle
step
.isOnQuest 58435
#completewith next
.zone 210 >>Go to Vol'dun
step
.isOnQuest 58435
.goto 864,56.78,49.80
.cast 312370 >> Use |T3193418:0|t[Make Camp]
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 9) Turnin Route Alliance
#displayname |cRXP_WARN_Chapter 8 -|r Turnin Route
#next a) Isle of Dorn Campaign + Side Quests
<< Alliance
step
*|cRXP_WARN_Chapter 8:|r Turnin Route
+Follow this guide for the turn-in process during launch, |cRXP_WARN_but only complete it when XP has been unlocked for level 70 on launch day.|r
step
.reputation 730,neutral,<0,1
.isQuestComplete 7162
.goto 25,44.67,46.2
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Haggerdin|r
.turnin 7162 >>Turn in Proving Grounds
.target Lieutenant Haggerdin
step
.reputation 730,friendly,<0,1
.isQuestComplete 7162,7168
.goto 25,44.67,46.2
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Haggerdin|r
.turnin 7162 >>Turn in Proving Grounds
.turnin 7168 >>Turn in Rise and Be Recognized
.target Lieutenant Haggerdin
step
.reputation 730,honored,<0,1
.goto 25,44.67,46.2
.isQuestComplete 7162,7168,7169
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Haggerdin|r
.turnin 7162 >>Turn in Proving Grounds
.turnin 7168 >>Turn in Rise and Be Recognized
.turnin 7169 >>Turn in Honored Amongst the Guard
.target Lieutenant Haggerdin
step
.reputation 730,revered,<0,1
.isQuestComplete 7162,7168,7169,7170
.goto 25,44.67,46.2
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Haggerdin|r
.turnin 7162 >>Turn in Proving Grounds
.turnin 7168 >>Turn in Rise and Be Recognized
.turnin 7169 >>Turn in Honored Amongst the Guard
.turnin 7170 >>Turn in Earned Reverence
.target Lieutenant Haggerdin
step
.reputation 730,exalted,<0,1
.isQuestComplete 7162,7168,7169,7170,7171,7172
.goto 25,44.67,46.2
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Haggerdin|r
.turnin 7162 >>Turn in Proving Grounds
.turnin 7168 >>Turn in Rise and Be Recognized
.turnin 7169 >>Turn in Honored Amongst the Guard
.turnin 7170 >>Turn in Earned Reverence
.turnin 7171 >>Turn in Legendary Heroes
.turnin 7172 >>Turn in The Eye of Command
.target Lieutenant Haggerdin
step
.cast 80256 >>Use |T463898:0|t[Potion of Deepholm]
.use 58487
step
.isQuestComplete 31973
.goto 207,49.87,57.06
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bordin Steadyfist|r
.dailyturnin 31973 >>Turn in Bordin Steadyfist
.target Bordin Steadyfist
step
.zoneskip 207,1
.goto 207,49.67,53.25,25,0
.goto 207,48.54,53.84
.zone 84 >> Take the Portal to Stormwind
step
#completewith next
.isQuestComplete 31972
.zoneskip 198,1
.goto 84,76.22,18.69
.zone 198 >>Take the Portal to Hyjal
step
.isQuestComplete 31972
.goto 198,61.39,32.71
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brok|r
.dailyturnin 31972 >>Turn in Brok
.target Brok
step
.zoneskip 198,1
.goto 198,62.61,23.14
.zone 84 >>Take the Portal to Stormwind
step
#completewith Obalis
.isQuestComplete 31971
.goto 84,75.24,20.51
.zone 1527 >>Take the Portal to Uldum
.zoneskip 249
step
.zoneskip 1527,1
.isQuestComplete 31971
.goto 1527,54.45,37.65
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Obalis|r
.dailyturnin 31971 >>Turn in Grand Master Obalis
.target Obalis
step
.zoneskip 249,1
.isQuestComplete 31971
.goto 249,56.56,42
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Obalis|r
.dailyturnin 31971 >>Turn in Grand Master Obalis
.target Obalis
step << Mage
.isQuestComplete 80384
.cast 395277 >> Use |T4661645:0|t[Teleport: Valdrakken]
step <<!Monk !Mage
.cast 89157 >>Use |T461812:0|t[Cloak of Coordination] to Stormwind.
.use 65360
step <<Monk
.cast 126892 >>Use Zen Pilgrimage
.use 126892
step <<Monk
.isQuestComplete 31834
.goto 379,48.60,42.74
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Hight|r
.turnin 31834 >>Turn in Begin Your Training: Master Cheng
.accept 31835 >>Accept Continue Your Training: Master Kistane
.accept 31840 >>Accept Practice Makes Perfect: Master Cheng
.target Master Hight
step <<Monk
.zoneskip 379,1
.goto 379,48.98,43.37
.zone 84 >>Take the Portal to Stormwind
step
#completewith next
.zoneskip 84,1
.goto 84,48.89,93.44
.zone 2112 >>Take the Portal to Valdrakken
step
.isQuestComplete 80384
.goto 2112,48.33,49.6,10,0
.goto 2112,46.59,45.12
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Da'kash Grimledger|r
.turnin 80384 >>Turn in A Keg-Stamped Package
.target Da'kash Grimledger
step <<!Mage
.zoneskip 2112,1
.goto 2112,48.3,49.62,10,0
.goto 2112,59.77,41.74
.zone 84 >>Take the Portal to Stormwind
step <<!Mage
.isQuestComplete 31925
.goto 84,44.89,85.76
.zone 74 >>Take the Portal to Shattrath
step <<Mage
.isQuestComplete 31925
.cast 33690 >> Use |T135760:0|t[Teleport: Shattrath]
step
.isQuestComplete 31925
.goto 111,59.51,69.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Morulu the Elder|r
.dailyturnin 31925 >>Turn in Morulu the Elder
.skipgossip
.target Morulu the Elder
step <<Monk
.zoneskip 111,1
.cast 126892 >>Use Zen Pilgrimage
step <<Monk
.zoneskip 379,1
.goto 379,48.97,43.37
.zone 84 >>Take the Portal to Stormwind
step <<!Monk !Mage
.zoneskip 111,1
.goto 111,57.2,48.24
.zone 84 >>Take the Portal to Stormwind
step <<Mage !KulTiran
.cast 3561 >>Use |T135763:0|t[Teleport: Stormwind]
step <<Mage KulTiran
.isQuestComplete 53722
.cast 281403 >>Use |T2176535:0|t[Teleport: Boralus]
step <<KulTiran !Mage
#completewith next
.goto 84,48.77,95.25
.zone 1161 >>Take the Portal from Stormwind to Boralus
step <<KulTiran
.isQuestComplete 53722
.goto 1161,43.94,62.62
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Katherine Proudmoore|r
.turnin 53722 >>Turn in Heritage of the Kul Tiran
.target Katherine Proudmoore
step <<KulTiran !Mage
#completewith next
.goto 1161,70.12,16.8
.zone 84 >>Take the Portal from Boralus to Stormwind.
step <<Kultiran Mage
.zoneskip 1161,1
.cast 3561 >> Use |T135763:0|t[Teleport: Stormwind]
step <<Mage !Draenei
.zoneskip 1161,1
.cast 3561 >> Use |T135763:0|t[Teleport: Stormwind]
step <<Draenei !Mage
.isOnQuest 78069
.goto 84,43.67,87.16
.zone 103 >>Take the portal from Stormwind to Exodar
step <<Mage Draenei
.isQuestComplete 78069
.cast 32271 >>Use |T135756:0|t[Teleport: Exodar]
step <<Draenei
.isOnQuest 78069
.goto 103,54.78,79.76
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grand Artificer Romuul|r
.turnin 78069 >>Turn in Reviving Tradition
.target Grand Artificer Romuul
step <<Draenei !Mage
.zoneskip 103,1
.goto 103,48.34,62.94
.zone 84 >>Take the portal from Exodar to Stormwind.
step <<Mage Draenei
.zoneskip 103,1
.cast 3561 >> Use |T135763:0|t[Teleport: Stormwind]
step
.goto 84,49.35,86.76,10,0
.goto 84,49.34,87.16,10,0
.goto 84,48.59,87.12,10,0
.goto 84,48.98,87.91,10,0
.goto 84,49.42,86.81,5 >>Leave the Magetower
step
.isQuestComplete 26153,26183,26190,26177,26192
.goto 84,50.66,73.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Robby Flay|r
.dailyturnin 26153,26183,26190,26177,26192 >>Turn in the Cooking Daily
.target Robby Flay
step
.isQuestComplete 66858
.goto 84,50.98,71.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tawny Seabraid|r
.turnin 66858 >>Turn in Tour the Trading Post
.target Tawny Seabraid
step
.isQuestComplete 26414,26420,26442,26488,26536
.goto 84,55.04,69.70
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Catherine Leland|r
.dailyturnin 26414,26420,26442,26488,26536 >>Turn in the Fishing Daily
.target Catherine Leland
step << Human
.isOnQuest 72446,72449,
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal McBride,|r |cRXP_FRIENDLY_Master Mathias Shaw|r and |cRXP_FRIENDLY_Cecilia Clessington|r
.turnin 72446 >>Turn in What's Their Problem?
.goto 425,27.68,66.66
.target +Marshal McBride
.turnin 72449 >>Turn in Knock It Off!
.goto 425,27.89,66.73
.target +Master Mathias Shaw
.turnin 72450 >>Turn in The Clessington Will
.goto 425,28.02,67.31
.target +Cecilia Clessington
step
.isQuestComplete 29412
.goto 84,58.91,52.73
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vin|r
.turnin 29412 >>Turn in Blown Away
.target Vin
step
.isQuestComplete 32470
.goto 84,61.33,22.69
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Arielle Snapflash|r
.turnin 32470 >>Turn in Light Camera Action
.target Arielle Snapflash
step <<LightforgedDraenei
#completewith next
.goto 84,48.08,11.13
.zone 940 >>Click on the |cRXP_PICK_Lightforged Beacon|r
step <<LightforgedDraenei
.isOnQuest 49782
.goto 940,49.21,43.79
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Fareeya|r
.target Captain Fareeya
.turnin 49782 >>Turn in Heritage of the Lightforged
step <<LightforgedDraenei
.zoneskip 941,1
.goto 941,47.37,62.94,10,0
.goto 941,54.09,58.5,5,0
.goto 941,43.12,24.77
.zone 84 >>Take the portal from the Vindicaar to Stormwind
step <<VoidElf
#completewith next
.goto 84,50.7,8.44
.zone 971 >>Click on the |cRXP_PICK_Rift to Telogrus|r
step <<VoidElf
.isOnQuest 49928
.goto 971,28.53,22.27
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alleria Windrunner|r
.turnin 49928 >>Turn in Heritage of the Void
.target Alleria Windrunner
step <<VoidElf
.zoneskip 971,1
.goto 971,27.98,21.46
.zone 84 >>Take the portal from Telogrus to Stormwind
step <<DarkIronDwarf
#completewith next
.goto 84,49.73,10.66
.zone 1573 >>Click on the |cRXP_PICK_Mole Machine to Shadowforge City.|r
.target Mole Machine to Shadowforge City
step <<DarkIronDwarf
.isOnQuest 51483
.goto 971,28.53,22.27
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alleria Windrunner|r
.turnin 51483 >>Turn in Heritage of the Dark Iron
.target Alleria Windrunner
step <<DarkIronDwarf
.zoneskip 1186,1
.goto 1186,59.34,26.46
.zone 84 >>Take the Mole Machine inside Shadowforge City to Stormwind City
.target Mole Machine to Shadowforge City
step <<Mechagnome
#completewith next
.goto 84,48.47,8.65
.zone 1573 >>Step on the teleporter to Mechagnome.
step <<Mechagnome
.isOnQuest 58436
.goto 1573,18.67,67.48
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Prince Erazmin|r
.turnin 58436 >>Turn in Heritage of the Mechagnome
.target Prince Erazmin
step <<Mechagnome
.zoneskip 1573,1
.goto 1573,20.19,59.03
.zone 84 >>Step on the teleporter from Mechagon to Stormwind.
step <<NightElf
.isOnQuest 76212
.goto 84,49.4,86.71,5,0
.goto 84,49.36,87.41,5,0
.goto 84,48.92,86.78,5,0
.goto 84,48.66,87.69,5,0
.goto 84,49.42,86.83,5,0
.goto 84,52.42,4.42
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lysander Starshade|r
.turnin 76212 >>Turn in A Mark For A Protector
.target Lysander Starshade
step <<NightElf
.isQuestTurnedIn 76212
.goto 84,52.59,3.82
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Maiev Shadowsong|r
.accept 76213 >>Accept Honor of the Goddess
.timer 30,RP
.target Maiev Shadowsong
step <<NightElf
.isOnQuest 76213
.goto 84,52.59,3.82
>>|cRXP_WARN_Wait for the roleplay|r
*|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Maiev Shadowsong|r
.target Maiev Shadowsong
.turnin 76213 >>Turn in Honor of the Goddess
step
.isQuestComplete 32863
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brok|r
.turnin 32863 >>Turn in What We've Been Training For
.target Brok
step
.isQuestComplete 31974
.goto 84,75.35,16.49
.zone 241 >>Take the Portal to Twillight Highlands
step
.isQuestComplete 31974
.goto 241,56.59,56.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Goz Banefury|r
.dailyturnin 31974 >>Turn in Goz Banefury
.target Goz Banefury
step
.isQuestComplete 83493
>>Use |T133870:0|t[Ultrasafe Transporter: Gadgetzan] |cRXP_WARN_if you can.|r
.itemcount 18986,1
.use 18986
step
.isOnQuest 83493,83494
.isNotOnQuest 54981,53845,72858,72856,72857,72467,77901,54766,57079
.zoneskip 71
.hs >>Use your Hearthstone to Gadgetzan
step <<Worgen !Mage/Dwarf !Mage
.zoneskip 71
.cast 89157 >>Use |T461811:0|t[Wrap of Unity] to Stormwind
.use 63206
step <<Worgen Mage/Dwarf Mage
.zoneskip 71
.cast 3561 >>Use |T135763:0|t[Teleport: Stormwind]
step <<Worgen/Dwarf
.zoneskip 71
.isQuestComplete 83493
.goto 84,43.74,85.37
.zone 71 >>Take the portal from Stormwind to the Caverns of Time.
step
.isQuestComplete 83493
.goto 71,52.6,27.19,10,0
.goto 71,52.51,26.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Blue|r |cRXP_WARN_inside the hut|r
.turnin 83493 >>Turn in Warbands: Rift Reader
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Blue|r |cRXP_WARN_inside the hut|r
.isQuestComplete 83494
.turnin 83494 >>Turn in Warbands: Space Ghosts by the Coast
.target Blue
step <<Worgen
.isQuestComplete 54981
#completewith next
.hs >>Hearth to to Scarlet Raven Tavern
step <<Worgen
.isOnQuest 54981,54982
.goto 47,74.09,45.55,5,0
.goto 47,73.75,45.56,5,0
.goto 47,73.8,46.13,5,0
.goto 47,46.39,36.89
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vassandra Stormclaw|r
.turnin 54981 >>Turn in Cry to the Moon
.target Vassandra Stormclaw
.turnin 54982 >>Turn in The Spirit of the Hunter
step
.isQuestTurnedIn 54982
.goto 47,46.39,36.89
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vassandra Stormclaw|r
.target Vassandra Stormclaw
.accept 54983 >>Accept Waking a Dreamer
step <<Worgen
.isOnQuest 54983
.goto 47,46.39,36.89
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vassandra Stormclaw|r
.complete 54983,1 
.timer 56,RP
.skipgossip
.target Vassandra Stormclaw
step <<Worgen
.isOnQuest 54983
.goto 47,46.60,36.98
>>Kill |cRXP_ENEMY_Spirit of Fury|r
.complete 54983,2 
.mob Spirit of Fury
step <<Worgen
.isOnQuest 54983
.goto 47,46.58,36.52
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Goldrinn|r
.turnin 54983 >>Turn in Waking a Dreamer
.target Goldrinn
step <<Dwarf !Mage
.isQuestComplete 53845
.hs >>Hearth to The Stonefire Tavern
step <<Dwarf Mage
.isQuestComplete 53845
.cast 3562 >>Use |T135757:0|t[Teleport: Ironforge]
step <<Dwarf
.isOnQuest 53845
.goto 87,46.10,50.21
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grumnus Steelshaper|r
.turnin 53845 >>Turn in Forging the Armor
.target Grumnus Steelshaper
step <<Dwarf
.isQuestTurnedIn 53845
.goto 87,45.88,49.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brann Bronzebeard|r
.accept 53846 >>Accept Legacy of the Bronzebeard
.target Brann Bronzebeard
step
.isOnQuest 53846
.goto 87,40.0,55.0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Muradin Bronzebeard|r
.turnin 53846 >>Turn in Legacy of the Bronzebeard
.target Muradin Bronzebeard
step
.isQuestComplete 31935
.cast 48933 >>|T135778:0|t[Wormhole Generator: Northend]
.itemcount 48933,1
step
.isQuestComplete 31935
.goto 121,13.25,66.79
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gutretch|r
.dailyturnin 31935 >>Turn in Grand Master Payne
.target Gutretch
step <<DarkIronDwarf
.isQuestComplete 31935
.isQuestTurnedIn 53599
.zone 104 >>Use your |T1786409:0|t[Mole Machine] to Shadowmoon Valley.
.use 265225
step <<DarkIronDwarf
.isQuestComplete 31935
.isQuestTurnedIn 53599
.goto 104,30.51,41.77
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bloodknight Antari|r
.dailyturnin 31926 >>Turn in Grand Master Antari
.target Bloodknight Antari
step <<!Mage
#completewith
.cast 89157 >>Use |T461810:0|t[Shroud of Cooperation]
.use 63352
step <<Mage
#completewith Gutretch2
.isQuestComplete 31932
.cast 53140 >>Use |T237509:0|t[Teleport: Dalaran]
step <<!Mage
#completewith Gutretch2
.isQuestComplete 31932
.goto 85,56.23,91.74
.zone 125 >>Take the Portal to Old Dalaran
step
.isQuestComplete 31932
.goto 127,50.09,58.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nearly Headless Jacob|r and defeat them in a pet battle.
.dailyturnin 31932 >>Turn in Nearly Headless Jacob
.skipgossip
.target Nearly Headless Jacob
step
#label Gutretch2
.isQuestComplete 31934
.goto 121,13.25,66.79
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gutretch|r
.dailyturnin 31934 >>Turn in Gutretch
.target Gutretch
step
.isQuestTurnedIn 44663,44184
.isQuestComplete 64237
.cast 222695 >>Use |T1444943:0|t[Legion Dalaran Hearthstone]
.use 140192
step
.isOnQuest 64237
.goto 627,58.47,39.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Breanni|r
.turnin 64237 >>Turn in Gurgl and the Bandit
.target Breanni
step
.goto 629,40.43,54.13
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Moira Thaurissan|r
.turnin 80500 >>Turn in The Bronzebeard Family
.target Moira Thaurissan
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 9) Turnin Route Horde
#displayname |cRXP_WARN_Chapter 8 -|r Turnin Route
#next a) Isle of Dorn Campaign + Side Quests
<< Horde
step
*|cRXP_WARN_Chapter 8:|r Turnin Route
+Follow this guide for the turn-in process during launch, |cRXP_WARN_but only complete it when XP has been unlocked for level 70 on launch day.|r
step
.isQuestComplete 7161
.reputation 729,friendly,<0,1
.goto 25,57.79,33.34
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Warmaster Laggrond|r
.turnin 7161 >>Turn in Proving Grounds
.target Warmaster Laggrond
step
.isQuestComplete 7161,7163
.reputation 729,friendly,<0,1
.goto 25,57.79,33.34
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Warmaster Laggrond|r
.turnin 7161 >>Turn in Proving Grounds
.turnin 7163 >>Turn in Rise and Be Recognized
.target Warmaster Laggrond
step
.isQuestComplete 7161,7163,7164
.reputation 729,honored,<0,1
.goto 25,57.79,33.34
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Warmaster Laggrond|r
.turnin 7161 >>Turn in Proving Grounds
.turnin 7163 >>Turn in Rise and Be Recognized
.turnin 7164 >>Turn in Honored Amongst the Guard
.target Warmaster Laggrond
step
.isQuestComplete 7161,7163,7164,7165
.reputation 729,revered,<0,1
.goto 25,57.79,33.34
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Warmaster Laggrond|r
.turnin 7161 >>Turn in Proving Grounds
.turnin 7163 >>Turn in Rise and Be Recognized
.turnin 7164 >>Turn in Honored Amongst the Guard
.turnin 7165 >>Turn in Earned Reverence
.target Warmaster Laggrond
step
.isQuestComplete 7161,7163,7164,7165,7166,7167
.reputation 729,Exalted,<0,1
.goto 25,57.79,33.34
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Warmaster Laggrond|r
.turnin 7161 >>Turn in Proving Grounds
.turnin 7163 >>Turn in Rise and Be Recognized
.turnin 7164 >>Turn in Honored Amongst the Guard
.turnin 7165 >>Turn in Earned Reverence
.turnin 7166 >>Turn in Legendary Heroes
.turnin 7167 >>Turn in The Eye of Command
.target Warmaster Laggrond
step
.cast 80256 >>Use |T463898:0|t[Potion of Deepholm]
.use 58487
step
.isQuestComplete 31973
.goto 207,49.87,57.06
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bordin Steadyfist|r
.dailyturnin 31973 >>Turn in Bordin Steadyfist
.target Bordin Steadyfist
step <<!Mage
.zoneskip 207,1
.goto 207,49.67,53.25,25,0
.goto 207,50.93,53.1
.zone 85 >>Take the Portal to Orgrimmar
step << Mage
#completewith A Keg-Stamped Package
.isQuestComplete 80384
.cast 395277 >> Use |T4661645:0|t[Teleport: Valdrakken]
step <<!Mage
#completewith A Keg-Stamped Package
.isQuestComplete 80384
.goto 85,53.28,90.43,20,0
.goto 85,55.73,90.06,15,0
.goto 85,57.11,87.35
.zone 2112 >>Take the Portal to Valdrakken
step
#label A Keg-Stamped Package
.isQuestComplete 80384
.goto 2112,48.4,49.63,10,0
.goto 2112,46.59,45.12
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Da'kash Grimledger|r
.turnin 80384 >>Turn in A Keg-Stamped Package
.target Da'kash Grimledger
step <<!Mage
.zoneskip 2112,1
.goto 2112,54.59,45.42
.goto 2112,56.61,38.33
.zone 84 >>Take the Portal to Orgrimmar
step <<ZandalariTroll !Mage
.isQuestComplete 53721
#completewith Heritage of the Zandalari
.goto 85,52.98,90.58,15,0
.goto 85,58.54,91.29
.zone 862 >>Take the |cRXP_PICK_Portal|r from Orgrimmar to Zuldazar
step <<ZandalariTroll Mage
#completewith Heritage of the Zandalari
.isOnQuest 53721
.cast 281402 >>Use |T2176536:0|t[Teleport: Dazar'alor]
step <<ZandalariTroll !Mage
#completewith Heritage of the Zandalari
.goto 1165,50.02,40.3,15,0
.goto 1163,53.36,70.1,10,0
.goto 1163,73.99,69.84
.zone 85 >>Take the |cRXP_PICK_Portal|r from Orgrimmar to Zuldazar
step <<ZandalariTroll
#label Heritage of the Zandalari
.isOnQuest 53721
.goto 1165,49.93,46.65
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Queen Talanji|r
.turnin 53721 >>Turn in Heritage of the Zandalari
.target Queen Talanji
step <<ZandalariTroll Mage
.zoneskip 1163
.cast 3567 >>Use |T135759:0|t[Teleport: Orgrimmar]
step <<ZandalariTroll !Mage
.goto 1165,49.94,42.05,10,0
.goto 1163,54.02,70.36,10,0
.goto 1163,73.63,69.95
.zone 85 >>Click on the |cRXP_PICK_Portal|r to Orgrimmar
step
.isQuestComplete 66959
.goto 85,48.9,76.14
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shiri|r
.turnin 66959 >>Turn in Tour the Trading Post
.target Shiri
step <<HighmountainTauren
.isOnQuest 49783
#completewith next
.goto 85,38.17,75.3
.zone 652 >>Take the Portal from Orgrimmar to Highmountain
step <<HighmountainTauren
.isOnQuest 49783
.goto 652,54.95,63.18
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mayla Highmountain|r
.turnin 49783 >>Turn in Heritage of Highmountain
.target Mayla Highmountain
step <<HighmountainTauren
.zoneskip 652,1
.goto 652,46.09,63.77
.zone 85 >>Take the Portal from Highmountain to Orgrimmar
step <<Nightborne
#completewith next
.isOnQuest 49784
.goto 85,38.59,75.92
.zone 680 >>Click on the |cRXP_PICK_Portal|r to Nighthold
step <<Nightborne
.isOnQuest 49784
.goto 680,59.33,85.53
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_First Arcanist Thalyssra|r
.turnin 49784 >>Turn in Heritage of the Nightborne
.target First Arcanist Thalyssra
step <<Nightborne
.zoneskip 680,1
.goto 680,58.19,87.34
.zone 85 >>Take the Portal from Suramar to Orgrimmar
step
.isQuestComplete 32470
.goto 85,48.14,46.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jaga|r
.turnin 32470 >>Turn in Light Camera Action
.target Jaga
step
.isQuestComplete 29401
.goto 85,48.13,46.85
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jaga|r
.turnin 29401 >>Turn in Blown Away
.target Jaga
step
#completewith next
.isQuestComplete 31972
.goto 85,51.14,38.26
.zone 198 >>Take the Portal to Hyjal
step
.isQuestComplete 31972
.goto 198,61.39,32.71
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brok|r
.dailyturnin 31972 >>Turn in Brok
.target Brok
step <<!Mage
#completewith Turn in Morulu the Elder
.zoneskip 198,1
.goto 198,63.49,24.44
.zone 85 >>Take the Portal to Orgrimmar
step <<!Mage
#completewith Turn in Morulu the Elder
.isQuestComplete 31925
.goto 85,54.81,90.02,10,0
.goto 85,54.63,87.15,10,0
.goto 85,55.93,86.91,10,0
.goto 85,57.48,91.61
.zone 74 >>Take the Portal to Shattrath
step <<Mage
#completewith Turn in Morulu the Elder
.isQuestComplete 31925
.cast 35715 >>Use |T135760:0|t[Teleport: Shattrath]
step
#label Turn in Morulu the Elder
.isQuestComplete 31925
.goto 111,59.51,69.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Morulu the Elder|r and defeat them in a pet battle.
.dailyturnin 31925 >>Turn in Morulu the Elder
.skipgossip
.target Morulu the Elder
step << Monk
#completewith next
.zoneskip 111,1
.cast 126892 >>Use Zen Pilgrimage
step << Monk
.isQuestComplete 31834
.goto 379,48.60,42.74
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Hight|r
.turnin 31834 >>Turn in Begin Your Training: Master Cheng
.target Master Hight
step << Monk
.zoneskip 379,1
.goto 379,48.54,43.57
.zone 85 >>Take the Portal to Orgrimmar
step <<!Monk !Mage
.zoneskip 111,1
.goto 111,56.83,48.85
.zone 85 >>Take the Portal to Orgrimmar
step <<Mage
.zoneskip 1163
.cast 3567 >>Use |T135759:0|t[Teleport: Orgrimmar]
step
.isQuestComplete 32863
.goto 85,52.57,59.3
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Varzok|r
.turnin 32863 >>Turn in What We've Been Training For
.target Varzok
step
.isOnQuest 26227,26226,26235,26220,26234,26233
.goto 85,56.54,62.49
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marogg|r
.dailyturnin 26227,26226,26235,26220,26234,26233 >>Turn in the Cooking Daily
.target Marogg
step <<MagharOrc
.isOnQuest 51484
.goto 85,70.61,44.61
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Overlord Geya'rah|r
.turnin 51484 >>Turn in Heritage of the Mag'har
.target Overlord Geya'rah
step
.isOnQuest 26543,26556,26557,26588,26572
.goto 85,65.67,41.09
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Razgar|r
.dailyturnin 26543,26556,26557,26588,26572 >>Turn in the Fishing Daily
.target Razgar
step
.isQuestComplete 31971
.goto 85,48.87,38.55
.zone 249 >>Take the Portal to Uldum
.zoneskip 1527
step
.zoneskip 1527,1
.isQuestComplete 31971
.goto 1527,54.45,37.65
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Obalis|r
.dailyturnin 31971 >>Turn in Grand Master Obalis
.target Obalis
step
.zoneskip 249,1
.isQuestComplete 31971
.goto 249,56.56,42
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Obalis|r
.dailyturnin 31971 >>Turn in Grand Master Obalis
.target Obalis
step << Goblin
.isQuestComplete 57079
#completewith Goblin
.hs >>Hearth to Hardwrench Hideaway
step << Tauren
.isQuestComplete 54766
#completewith Tauren
.hs >>Hearth to The Cat and the Shaman
step << Orc
.isQuestComplete 72467
#completewith Orc
.hs >>Hearth to to Razor Hill
step << Troll
.isQuestComplete 77901
#completewith Troll
.hs >>Hearth to to Razor Hill
step << Undead
.isQuestComplete 72858
#completewith Undead
.hs >>Hearth to Silverpine Forest
step << Undead
#label Undead
.isOnQuest 72858,72856,72857
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dark Ranger Velonara|r and |cRXP_FRIENDLY_Master Apothecary Faranell|r
.turnin 72858 >>Turn in Acid Beats Paper
.goto 21,45.56,42.04
.target +Dark Ranger Velonara
.turnin 72856 >>Turn in Nothing Like the Classic
.target +Master Apothecary Faranell
.turnin 72857 >>Turn in Boom Weed
.goto 21,45.63,41.99
step << Goblin
#label Goblin
.isQuestComplete 57079
.goto 1531,47.86,50.59
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hobart Grapplehammer|r
.turnin 57079 >>Turn in Beat The Crapopolis Outta Him!
.target Hobart Grapplehammer
step <<Goblin
.isQuestTurnedIn 57079
.goto 1531,47.86,50.59
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hobart Grapplehammer|r
.accept 57080 >>Accept A Fitting Reward
.target Hobart Grapplehammer
step << Goblin
.isQuestComplete 57080
.goto 1531,47.86,50.59
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hobart Grapplehammer|r
.turnin 57080 >>Turn in A Fitting Reward
step << Troll
#label Troll
.isOnQuest 77901,77902,77903
.goto 463,56.96,56.41
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.turnin 77901 >>Turn in Retraining the Trainees
.target Rokhan
.turnin 77902 >>Turn in Ritual Recovery
.turnin 77903 >>Turn in De Power of Death
step << Troll
.isQuestTurnedIn 77903
.goto 463,56.96,56.41
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.accept 77905 >>Accept Avatar of Mueh'zala
step << Troll
.isOnQuest 77905
.goto 463,56.27,56.49
>>Click on the |cRXP_PICK_Feather|r
.complete 77905,1 
step << Troll
.isOnQuest 77905
.goto 463,58.55,56.29
>>Kill |cRXP_ENEMY_Summoned Visage|r on the pillar and click the |cRXP_PICK_Totems|r.
.complete 77905,3,1 
.mob Summoned Visage
step << Troll
.isOnQuest 77905
.goto 463,54.39,56.53
>>Kill |cRXP_ENEMY_Summoned Visage|r on the pillar and click the |cRXP_PICK_Totems|r.
.complete 77905,3,2 
.mob Summoned Visage
step << Troll
.isOnQuest 77905
.goto 463,54.49,47.04
>>Kill |cRXP_ENEMY_Summoned Visage|r on the pillar and click the |cRXP_PICK_Totems|r.
.complete 77905,3,3 
.mob Summoned Visage
step << Troll
.isOnQuest 77905
.goto 463,58.48,46.89
>>Kill |cRXP_ENEMY_Summoned Visage|r on the pillar and click the |cRXP_PICK_Totems|r.
*|cFFFF0000After completing the objective, you can skip the cutscene by pressing 'Escape' and accepting the prompt.|r
.complete 77905,3,4 
.mob Summoned Visage
step << Troll
.isQuestComplete 77905
.goto 463,58.50,65.55
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.turnin 77905 >>Turn in Avatar of Mueh'zala
.target Rokhan
step << Troll
.isQuestTurnedIn 77905
.goto 463,58.50,65.55
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r
.accept 77906 >>Accept De Darkspear Loa
.target Rokhan
step << Troll
.isOnQuest 77906
.goto 463,58.73,66.12
>>Click on |cRXP_PICK_Totem|r
.complete 77906,1 
step << Troll
.isOnQuest 77906
.goto 463,58.73,66.12
>>Click on |cRXP_PICK_Loa Offering|r
.complete 77906,2 
step << Troll
.isQuestComplete 77906
.goto 463,59.05,65.78
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Gadrin|r
.turnin 77906 >>Turn in De Darkspear Loa
.target Master Gadrin
step << Orc
#label Orc
.goto 1,52.20,42.99
.isOnQuest 72467,74415,72475
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farseer Aggralan|r
.turnin 72467 >>Turn in The Blessing of the Clan
.turnin 74415 >>Turn in A Worthy Offering
.turnin 72475 >>Turn in Cornering Gor'krosh
.target Farseer Aggralan
step << Orc
.isQuestTurnedIn 72475
.goto 1,52.20,42.99
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farseer Aggralan|r
.accept 72478 >>Accept Honor and Glory
step << Orc
.isOnQuest 72478
#completewith Boss Magor
>>Click on all the |cRXP_PICK_Food.|r Kill |cRXP_ENEMY_Rowdy Warlock|r and |cRXP_ENEMY_Rowdy Grunt.|r
.complete 72478,1 
.mob Rowdy Warlock
.mob Rowdy Grunt
step << Orc
.isOnQuest 72478
#completewith Boss Magor
.goto 1,52.48,40.95
.gossipoption 108372 >>Talk to |cRXP_FRIENDLY_Boss Magor|r
.timer 10,RP
.target Boss Magor
step << Orc
#label Boss Magor
.isOnQuest 72478
.goto 1,52.06,42.15
>>Kill |cRXP_ENEMY_Boss Magor.|r Pickup a |cRXP_PICK_Booterang|r and use your |cRXP_WARN_ExtraActionButton|r when he casts |cRXP_WARN_Bootstorm.|r
.complete 72478,2 
.mob Boss Magor
.target Boss Magor
step << Orc
#loop
.isOnQuest 72478
.goto 1,52.2,42.31,30,0
.goto 1,52.5,41.5,30,0
.goto 1,52.95,42.85,30,0
.goto 1,52.33,43.32,30,0
>>Click on all the |cRXP_PICK_Food.|r Kill |cRXP_ENEMY_Rowdy Warlock|r and |cRXP_ENEMY_Rowdy Grunt.|r
.complete 72478,1 
.mob Rowdy Warlock
.mob Rowdy Grunt
step << Orc
.isOnQuest 72478
.goto 1,52.25,43.44
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thrall|r
.turnin 72478 >>Turn in Honor and Glory
.target Thrall
step << Orc
.isQuestTurnedIn 72478
.goto 1,52.25,43.44
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thrall|r
.target Thrall
.accept 72479 >>Accept Aka'magosh
step << Orc
.isOnQuest 72479
.goto 1,52.26,43.02
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eitrigg|r
.turnin 72479 >>Turn in Aka'magosh
.target Eitrigg
step << Tauren
#label Tauren
.isQuestComplete 54766
.goto 88,60.32,51.69
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Baine Bloodhoof|r
.turnin 54766 >>Turn in Answer the Call
.target Baine Bloodhoof
step << Tauren
.isQuestTurnedIn 54766
.goto 88,60.32,51.69
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Baine Bloodhoof|r
.target Baine Bloodhoof
.accept 54765 >>Accept Thank Your Guide
step << Tauren
.isOnQuest 54765
.goto 7,33.97,38.64
>>Click on |cRXP_PICK_Spirit Offering|r
.complete 54765,1 
step << Tauren
.isQuestComplete 54765
.goto 7,34.00,38.67
>>Click on |cRXP_PICK_Ceremonial Tauren Garb.|r
.turnin 54765 >>Turn in Thank Your Guide
.target Ceremonial Tauren Garb
step <<Vulpera
#completewith next
.isOnQuest 58435
.cast 312372 >> Use |T3193420:0|t[Return to Camp]
step <<Vulpera
.isOnQuest 58435
.goto 864,56.78,49.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hagashi|r
.turnin 58435 >>Turn in Heritage of the Vulpera
.target Hagashi
step
#completewith next
.isQuestComplete 31935
.cast 48933 >>|T135778:0|t[Wormhole Generator: Northend] to Storm Peaks
.itemcount 48933,1
step
.isQuestComplete 31935
.goto 121,13.25,66.79
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gutretch|r
.dailyturnin 31935 >>Turn in Grand Master Payne
.target Gutretch
step
.isQuestComplete 83493
>>Use |T133870:0|t[Ultrasafe Transporter: Gadgetzan] |cRXP_WARN_if you can.|r
.itemcount 18986,1
.use 18986
step
.isOnQuest 83493,83494
.isQuestTurnedIn 54981,53845,72858,72856,72857,72467,77901,54766,57079
.zoneskip 71
.hs >> Use your Hearthstone to Gadgetzan
step <<!Mage
.isOnQuest 83493,83494
.zoneskip 71
.cast 89158 >>Use |T461814:0|t[Wrap of Unity]
.use 63207
step <<Mage
.isOnQuest 83493,83494
.zoneskip 71
.cast 3567 >>Use |T135759:0|t[Teleport: Orgrimmar]
step
.zoneskip 71
.isQuestComplete 83493
.goto 85,54.74,90.2,10,0
.goto 85,53.22,90.52,10,0
.goto 85,54.77,89.52,10,0
.goto 85,54.7,87.15,10,0
.goto 85,56,86.92,10,0
.goto 85,56.41,92.55
.zone 71 >>Take the portal from Orgrimmar to the Caverns of Time.
step
.isQuestComplete 83493
.goto 71,52.6,27.19,10,0
.goto 71,52.51,26.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Blue|r |cRXP_WARN_inside the hut|r
.turnin 83493 >>Turn in Warbands: Rift Reader
.target Blue
step
.isQuestComplete 83494
.goto 71,52.51,26.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Blue|r |cRXP_WARN_inside the hut|r
.turnin 83494 >>Turn in Warbands: Space Ghosts by the Coast
.target Blue
step <<!Mage
#completewith Gutretchs
.isQuestComplete 31932
.goto 85,56.23,91.74
.zone 125 >>Take the Portal to Old Dalaran
step <<Mage
#completewith Gutretchs
.isQuestComplete 31932
.cast 53140 >>Use |T237509:0|t[Teleport: Dalaran]
step
.isQuestComplete 31932
.goto 127,50.09,58.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nearly Headless Jacob|r and defeat them in a pet battle.
.dailyturnin 31932 >>Turn in Nearly Headless Jacob
.skipgossip
.target Nearly Headless Jacob
step
#label Gutretchs
.isQuestComplete 31932
.goto 121,13.25,66.79
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gutretch|r
.dailyturnin 31934 >>Turn in Gutretch
.target Gutretch
step <<!Mage
.isQuestTurnedIn 44663,44184
.isQuestComplete 64237
.cast 222695 >>Use |T1444943:0|t[Legion Dalaran Hearthstone]
.use 140192
step <<Mage
.cast 224869 >>Use |T135975:0|t[Teleport: Dalaran - Broken Isles]
step
.isQuestComplete 64237
.goto 627,58.47,39.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Breanni|r
.turnin 64237 >>Turn in Gurgl and the Bandit
.target Breanni
step
.goto 629,40.43,54.13
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Moira Thaurissan|r
.turnin 80500 >>Turn in The Bronzebeard Family
.target Moira Thaurissan
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 9b) PoP-UP Quests Turnins
#displayname |cRXP_WARN_Final Chapter -|r Turnin for PoP-UP Quests
step
#completewith Silas' Secret Stash
+Turning in these quests during the leveling route is slightly faster. However, you can choose to turn them in at any time, as long as XP is already enabled.
step
#hidewindow
#completewith PoPUPQuestsTurnins
#label PoPUPQuestsTurnins
+1
step
.isOnQuest 38934,31889,31919,31927,31966,31930,31952,31780,31850,31819,31851,54850,31781
.achievementComplete 16645,1
.cast 396125 >>Use [Dungeon Teleport: The Azure Vault] to Azure Span
.use 396125
step
.zoneskip 2024
.isOnQuest 38934,31889,31919,31927,31966,31930,31952,31780,31850,31819,31851,54850,31781
.achievementComplete 16642,1
.cast 396129 >>Use [Dungeon Teleport: Brackenhide Hollow] to Azure Span
.use 396129
step << Alliance !Mage
.zoneskip 2024
.isOnQuest 38934,31889,31919,31927,31966,31930,31952,31780,31850,31819,31851,54850,31781
.achievement 16642,0 >> Use |T461815:0|t[Cloak of Coordination], |T461814:0|t[Wrap of Unity] or |T461813:0|t[Shroud of Cooperation] to teleport to Stormwind.
.use 65360
.use 63352
.use 63206
step << Alliance !Mage
.zoneskip 2024
.isOnQuest 38934,31889,31919,31927,31966,31930,31952,31780,31850,31819,31851,54850,31781
.achievementComplete 16645,1 >> Use |T461815:0|t[Cloak of Coordination], |T461814:0|t[Wrap of Unity] or |T461813:0|t[Shroud of Cooperation] to teleport to Stormwind.
.disablecheckbox
.use 65360
.use 63352
.use 63206
step << Horde !Mage
.zoneskip 2024
.isOnQuest 38934,31889,31919,31927,31966,31930,31952,31780,31850,31819,31851,54850,31781
.achievementComplete 16642,1 >> Use |T461815:0|t[Cloak of Coordination], |T461814:0|t[Wrap of Unity] or |T461813:0|t[Shroud of Cooperation] to teleport to Orgrimmar.
.use 63353
.use 63207
.use 65274
step << Horde !Mage
.zoneskip 2024
.isOnQuest 38934,31889,31919,31927,31966,31930,31952,31780,31850,31819,31851,54850,31781
.achievementComplete 16645,1 >> Use |T461815:0|t[Cloak of Coordination], |T461814:0|t[Wrap of Unity] or |T461813:0|t[Shroud of Cooperation] to teleport to Orgrimmar.
.use 63353
.use 63207
.use 65274
step << Horde !Mage
.zoneskip 2024
.isOnQuest 38934,31889,31919,31927,31966,31930,31952,31780,31850,31819,31851,54850,31781
.goto 85,53.28,90.43,20,0
.goto 85,55.73,90.06,15,0
.goto 85,57.11,87.35
.zone 2112 >>Take the Portal to Valdrakken
step << Alliance !Mage
.zoneskip 2024
.isOnQuest 38934,31889,31919,31927,31966,31930,31952,31780,31850,31819,31851,54850,31781
.goto 84,48.89,93.44
.zone 2112 >>Take the Portal to Valdrakken
step << Mage
.zoneskip 2024
.isOnQuest 38934,31889,31919,31927,31966,31930,31952,31780,31850,31819,31851,54850,31781
.cast 395277 >> Use |T4661645:0|t[Teleport: Valdrakken]
step << Horde
.goto 2024,13.89,49.29
.isOnQuest 38934,31889,31919,31927,31966,31930,31952,31780,31850,31819,31851,54850,31781
.zone 2024>>Head to Azure Span to obtain the 25% Dreamsurge Buff before turning in the pop-up quests.
*|cRXP_WARN_To further optimize, every 30 minutes there's a chance for an additional 30% XP buff in Azure Span.|r
step << Alliance
.goto 2024,13.89,49.29
.isOnQuest 38934,31889,31919,31927,31966,31930,31952,31780,31850,31819,31851,54850,31781
.zone 2024>>Head to Azure Span to obtain the 25% Dreamsurge Buff before turning in the pop-up quests.
*|cRXP_WARN_To further optimize, every 30 minutes there's a chance for an additional 30% XP buff in Azure Span.|r
step
#label Silas' Secret Stash
.goto 2024,13.89,49.29
.isOnQuest 38934,31889,31919,31927,31966,31930,31952,31780,31850,31819,31851,54850,31781
.link /run local q,x=C_QuestLog; for i=1,q.GetNumQuestLogEntries() do x=q.GetInfo(i) if x and x.isAutoComplete and not x.isHidden and q.IsComplete(x.questID) then ShowQuestComplete(x.questID) C_Timer.After(0.25,function()GetQuestReward(1)end) break end end >> Pepeatedly use this Macro to turnin all Quests.
.turnin 38934 >>Turn in Silas' Secret Stash
.turnin 31889 >>Turn in Battle Pet Tamers: Kalimdor Alliance
.turnin 31919 >>Turn in Battle Pet Tamers: Outland Alliance
.turnin 31927 >>Turn in Battle Pet Tamers: Northend Alliance
.turnin 31966 >>Turn in Battle Pet Tamers: Cataclysm Alliance
.turnin 31930 >>Turn in Battle Pet Tamers: Pandaria Alliance
.turnin 31952 >>Turn in Battle Pet Tamers: Pandaria Horde
.turnin 31780 >>Turn in Old Macdonald
.turnin 31850 >>Turn in Eric Davidson
.turnin 31819 >>Turn in Dagra the Fierce
.turnin 31851 >>Turn in Bill Buckler
.turnin 54850 >>Turn in Operation: Troggageddon << Gnome
.turnin 31781 >>Turn in Lindsay
step
.achievementComplete 19030,1
#completewith next
.isQuestComplete 82809
.cast 420759 >>Summon the Pet:Squally
step
#label PoPUPQuestsTurnins2
.achievementComplete 19030,1
.isQuestComplete 82809
.goto 2022,71.09,25.89
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Squally|r
.turnin 82809 >>Turn in Gryphons of a Feather
.target Squally
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#subgroup Chromie Time (Veteran Player)
#name a) BfA Intro
#displayname |cFFFCDC00Chapter 1|r - BfA Intro
#next b) Horde Draenor Scenario
#veteran
<< Horde
step << DK !Orc !Undead !Tauren !Troll !BloodElf !Goblin
.goto 1602,49.55,90.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_The Lich King|r
.accept 58877 >>Accept Death's Power Grows
.target The Lich King
step << DK !Orc !Undead !Tauren !Troll !BloodElf !Goblin
.goto 1602,49.55,90.80
>>Use the Extra Action Button
.complete 58877,1 
step << DK !Orc !Undead !Tauren !Troll !BloodElf !Goblin
.goto 1602,49.55,90.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_The Lich King|r
.turnin 58877 >>Turn in Death's Power Grows
.accept 58903 >>Accept Defender of Azeroth
.target The Lich King
step << DK !Orc !Undead !Tauren !Troll !BloodElf !Goblin
.goto 1602,50.74,71.05
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Darion|r
.complete 58903,1 
.target Highlord Darion Mograine
.skipgossip
step << DK !Orc !Undead !Tauren !Troll !BloodElf !Goblin
.goto 1602,49.96,38.98
>>Take the Death Gate to Orgrimmar
.complete 58903,2 
step << !ZandalariTroll
.goto 85,40.83,80.16
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Chromie|r
>>|cRXP_WARN_Select "Battle for Azeroth" Campaign|r
*|cRXP_WARN_It's possible that it bugs out and doesn't give you the quest. If this is the case select a different campaign and swap back to the "Battle for Azeroth" one until you get the quest|r
.accept 51443 >>Accept Battle for Azeroth: Mission Statement
.target Chromie
.skipgossip
.isQuestAvailable 60360
step << ZandalariTroll
.goto 85,40.83,80.16
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Chromie|r
>>|cRXP_WARN_Select "Battle for Azeroth" Campaign|r
*|cRXP_WARN_It's possible that it bugs out and doesn't give you the quest. If this is the case select a different campaign and swap back to the "Battle for Azeroth" one until you get the quest|r
.accept 47514 >>Accept Zuldazar
.target Chromie
.skipgossip
.isQuestAvailable 60360
step << !ZandalariTroll
.goto 85,49.34,74.02
>>Enter Grommash Hold
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic|r
.complete 51443,1 
.isQuestAvailable 60360
step << !ZandalariTroll
#completewith MeetTeam
.goto 85,54.43,78.47,23 >> Enter the Inn
.timer 16,Meet your team RP
.nodmf
step
.goto 85,53.56,78.79
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gryshka|r
.home >>Set your Hearthstone to The Broken Tusk
>>|cRXP_BUY_Buy food/water if needed|r
.target Innkeeper Gryshka
.zoneskip 85,1
step
#veteran
#label DMFBuyAHItems
>>|cRXP_BUY_Buy the following items from the auction house or send them to yourself via mail|r
>>|cRXP_WARN_This step is optional and you don't need to buy the items if you don't want to/can't afford it|r
+|cRXP_WARN_Manually skip this step when you're done|r
.goto 85,53.98,73.26
.collect 71951,1,29456,1,1
.collect 71635,1,29443,1,1
.collect 71715,1,29451,1,1
.collect 71716,1,29464,1,1
.collect 71952,1,29457,1,1
.collect 71636,1,29444,1,1
.collect 71637,1,29445,1,1
.collect 71638,1,29446,1,1
.target Auctioneer Drezmit
.dmf
step
#completewith DMFDarkmoonPortalTaken
.goto 85,53.38,90.48,10,0
.goto 85,56.26,91.70
.zone 125 >>Take the Portal to Dalaran
.dmf
step
.goto 125,50.29,50.38
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Darkmoon Faire Mystic Mage|r
.accept 7926 >>Accept The Darkmoon Faire
.zone 7 >> Teleport to the Darkmoon Faire
.target Darkmoon Faire Mystic Mage
.skipgossip
.dmf
step
#completewith next
.goto 7,36.85,35.86
.zone 407 >>Take the Darkmoon Faire Portal to the Darkmoon Island
.dmf
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick the Strider if you don't have an Heirloom Mount
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kae Ti|r. |cRXP_BUY_Buy a|r |T133734:0|t[Ride Ticket Book] |cRXP_BUY_from her|r
.goto 407,50.44,59.33
.collect 92788,1,7926,1 
.target Kae Ti
.dmf
step
#veteran
>>|cRXP_WARN_Open the|r |T133734:0|t[Ride Ticket Book]
>>|cRXP_WARN_Stand on the Carousel and wait for the Experience Buff to reach 60minutes|r
>>|cRXP_WARN_Click the Quest Items in your bag (skip the ones you don't have)|r
.goto 407,49.45,57.5
.collect 81055,5,7926,1 
.accept 29464 >>Accept Tools of Divination
.accept 29451 >>Accept The Master Strategist
.accept 29456 >>Accept A Captured Banner
.accept 29457 >>Accept The Enemy's Insignia
.accept 29458 >>Accept The Captured Journal
.accept 29443 >>Accept A Curious Crystal
.accept 29444 >>Accept An Exotic Egg
.accept 29445 >>Accept An Intriguing Grimoire
.accept 29446 >>Accept A Wondrous Weapon
.use 92788
.zoneskip 407,1
.dmf
step
#veteran
.goto 407,51.91,60.94
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Professor Paleo|r
.turnin 29464 >>Turn in Tools of Divination
.target Professor Thaddeus Paleo
.itemcount 71716,1
.zoneskip 407,1
.dmf
step
#veteran
.goto 407,51.91,60.94
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Professor Paleo|r
.turnin 29451 >>Turn in The Master Strategist
.target Professor Thaddeus Paleo
.itemcount 71715,1
.zoneskip 407,1
.dmf
step
#veteran
.goto 407,51.91,60.94
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Professor Paleo|r
.turnin 29456 >>Turn in A Captured Banner
.target Professor Thaddeus Paleo
.itemcount 71951,1
.zoneskip 407,1
.dmf
step
#veteran
.goto 407,51.91,60.94
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Professor Paleo|r
.turnin 29457 >>Turn in The Enemy's Insignia
.target Professor Thaddeus Paleo
.itemcount 71952,1
.zoneskip 407,1
.dmf
step
#veteran
.goto 407,51.91,60.94
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Professor Paleo|r
.turnin 29458 >>Turn in The Captured Journal
.target Professor Thaddeus Paleo
.itemcount 71953,1
.zoneskip 407,1
.dmf
step
#veteran
.goto 407,51.91,60.94
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Professor Paleo|r
.turnin 29443 >>Turn in A Curious Crystal
.target Professor Thaddeus Paleo
.itemcount 71635,1
.zoneskip 407,1
.dmf
step
#veteran
.goto 407,51.91,60.94
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Professor Paleo|r
.turnin 29446 >>Turn in A Wondrous Weapon
.target Professor Thaddeus Paleo
.itemcount 71638,1
.zoneskip 407,1
.dmf
step
.goto 407,47.76,64.76
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gelvas|r. |cRXP_BUY_Buy as many|r |T669449:0|t[Darkmoon Top Hats] |cRXP_BUY_from him as you can|r
.turnin 7926 >>Turn in The Darkmoon Faire
.collect 171364,1,29506,1 
.target Gelvas Grimegate
.zoneskip 407,1
.dmf
step
.goto 407,53.23,75.82
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sayge|r for Buffs
.collect 19422,1
.target Sayge
.skipgossip 1
.zoneskip 407,1
.dmf
step
#veteran
.goto 407,51.11,82.04
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Yebb|r
.turnin 29444 >>Turn in An Exotic Egg
.target Yebb Neblegear
.zoneskip 407,1
.dmf
.isOnQuest 29444
step
#label DMFHeartBackToOrgrimmar
#completewith BFAStatement
.hs >>Hearth to The Broken Tusk
.dmf
.zoneskip 85
step << !ZandalariTroll
#label MeetTeam
.goto 85,54.43,78.47
>>Wait out the RP
.complete 51443,2 
.isOnQuest 51443
step << !ZandalariTroll
#veteran
.goto 85,54.43,78.43
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nathanos|r to get teleported to Zandalar
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic|r
.turnin 51443 >>Turn in Battle for Azeroth: Mission Statement
.accept 50769 >>Accept The Stormwind Extraction
.zone 862 >> Teleport to Zandalar
.target Nathanos Blightcaller
.skipgossip
.isQuestAvailable 60360
.isQuestTurnedIn 52969
step << !ZandalariTroll
#label BFAStatement
.goto 85,54.43,78.43
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nathanos|r
.turnin 51443 >>Turn in Battle for Azeroth: Mission Statement
.accept 50769 >>Accept The Stormwind Extraction
.target Nathanos Blightcaller
.isQuestAvailable 60360
step << !ZandalariTroll
.goto 85,54.58,78.36
>>Loot the |cRXP_PICK_Potion|r on the table
.complete 50769,1 
.zoneskip 862
.isOnQuest 50769
step << !ZandalariTroll
.goto 85,51.19,83.57
.vehicle >>Get onto a |cRXP_FRIENDLY_Skyhorn Eagle|r
.timer 95,The Stormwind Extraction RP
.target Skyhorn Eagle
.zoneskip 862
.isOnQuest 50769
step << !ZandalariTroll
>>|cRXP_WARN_Wait out the RP|r
.scenario 3718,1
.zoneskip 862
.isOnQuest 50769
step << !ZandalariTroll
.goto 1012,46.31,58.20,-1
.goto 1012,46.16,58.04,-1
>>Click the |cRXP_PICK_Padlocks|r on the ground
.scenario 3719,2
.zoneskip 862
.isOnQuest 50769
step << !ZandalariTroll
.goto 1012,46.31,57.96
>>|cRXP_WARN_Go down the Stockades Portal in the water|r
.scenario 3719,1
.zoneskip 862
.isOnQuest 50769
step << !ZandalariTroll
.goto 1013,31.52,62.04,8,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tOpen the |cRXP_PICK_Cell Door|r to |cRXP_FRIENDLY_Saurfang|r's prison
>>|cRXP_WARN_Ignore all the|r |cRXP_ENEMY_7th Legion Enforcers|r |cRXP_WARN_and|r |cRXP_ENEMY_7th Legion Sharpshooters|r. |cRXP_WARN_They disappear when you open the|r |cRXP_PICK_Cell Door|r
.scenario 3721,2
.goto 1013,50.67,38.88
.gossipoption 48752 >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Saurfang|r
.timer 48,The Stormwind Extraction RP
.goto 1013,48.05,33.52
.target High Overlord Saurfang
.skipgossip
.zoneskip 862
.isOnQuest 50769
step << !ZandalariTroll
#completewith next
.goto 1013,59.60,59.72,8,0
.goto 1013,55.65,64.12,5 >>Run to the next Prison Cell
step << !ZandalariTroll
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tOpen the |cRXP_PICK_Cell Door|r to |cRXP_FRIENDLY_Talanji|r's and |cRXP_FRIENDLY_Zul|r's prison
>>You may have to wait out |cRXP_FRIENDLY_Saurfang|r's RP
.goto 1013,55.65,64.48
.scenario 3722,1
.timer 61,The Stormwind Extraction RP
.mob 7th Legion Sharpshooter
.mob 7th Legion Enforcer
.zoneskip 862
.isOnQuest 50769
step << !ZandalariTroll
#completewith next
.goto 1013,59.44,37.24,8 >>|cRXP_WARN_Wait out the RP. Follow the group|r
step << !ZandalariTroll
.goto 1013,75.57,26.40,8,0
.goto 1013,87.15,23.20
>>Kill |cRXP_ENEMY_7th Legion Enforcers|r, |cRXP_ENEMY_7th Legion Sharpshooters|r, and |cRXP_ENEMY_7th Legion Battlemages|r in the big circular room
>>Kill |cRXP_ENEMY_Lyra|r and her |cRXP_ENEMY_7th Legion Battlemages|r when they spawn
>>After killing |cRXP_ENEMY_Lyra|r, click the |cRXP_PICK_Sewer Access Door on the ground|r
.scenario 3722,2
.mob 7th Legion Enforcer
.mob 7th Legion Sharpshooter
.mob 7th Legion Battlemage
.mob Mage-Commander Lyra
.zoneskip 862
.isOnQuest 50769
step << !ZandalariTroll
#completewith next
.goto 1012,71.09,46.72
>>|cRXP_WARN_Dismiss your pet|r << Hunter/Warlock
.gossipoption 48518 >> Talk to |cRXP_FRIENDLY_Rokhan|r
.target Rokhan
step << !ZandalariTroll
.goto 1012,70.22,47.53,15,0
.goto 1012,68.51,49.84,15,0
.goto 1012,66.05,51.25,15,0
.goto 1012,64.00,49.59,15,0
.goto 1012,64.30,48.72,8,0
.goto 1012,62.34,47.46,15,0
.goto 1012,61.50,44.77,15,0
.goto 1012,60.00,44.85,8,0
.goto 1012,59.59,43.55
>>|cRXP_WARN_Follow|r |cRXP_FRIENDLY_Rokhan|r
>>|cRXP_WARN_Stay inside|r |cRXP_FRIENDLY_Rokhan|r|cRXP_WARN_'s circle to stay stealthed|r
>>|cRXP_WARN_Avoid red circles to avoid detection|r
.gossipoption 48339 >> Talk to |cRXP_FRIENDLY_Rokhan|r when he stops after jumping off the Bridge
.target Rokhan
.zoneskip 862
.isOnQuest 50769
step << !ZandalariTroll
.goto 1012,61.21,44.93,12,0
.goto 1012,60.48,45.70,15,0
.goto 1012,59.66,46.81,15,0
.goto 1012,60.29,49.05,15,0
.goto 1012,58.13,52.45,15,0
.goto 1012,57.57,54.49,15,0
.goto 1012,55.96,57.10
>>|cRXP_WARN_Follow|r |cRXP_FRIENDLY_Rokhan|r
>>|cRXP_WARN_Stay inside|r |cRXP_FRIENDLY_Rokhan|r|cRXP_WARN_'s circle to stay stealthed|r
>>|cRXP_WARN_Avoid red circles to avoid detection|r
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic|r
.scenario 3727,1
.target Rokhan
.zoneskip 862
.isOnQuest 50769
step << !ZandalariTroll
.goto 1012,55.97,57.09
>>Kill the |cRXP_ENEMY_Gilnean Maulers|r attacking the shield
>>|cRXP_WARN_Wait out the RP|r
.scenario 3729,1
.mob Gilnean Mauler
.zoneskip 862
.isOnQuest 50769
step << !ZandalariTroll
.goto 1012,53.79,55.25,20,0
.goto 1012,51.69,54.93,20,0
.goto 1012,49.60,52.21,20,0
.goto 1012,47.33,51.66,20,0
.goto 1012,47.43,47.28,20,0
.goto 1012,49.32,42.49,20,0
.goto 1012,45.43,43.18
>>Follow the group whilst killing |cRXP_ENEMY_Gilnean Maulers|r |cRXP_ENEMY_Stormwind Guards|r, and |cRXP_ENEMY_Stormwind Battlemages|r
.gossipoption 48198 >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nathanos|r
.scenario 3729,2
.mob Gilnean Mauler
.mob Stormwind Guard
.mob Stormwind Battlemage
.target Nathanos Blightcaller
.zoneskip 862
.isOnQuest 50769
step << !ZandalariTroll
.goto 1012,43.53,42.81,20,0
.goto 1012,42.41,42.79,20,0
.goto 1012,39.79,40.59
>>|cRXP_WARN_Dodge the White Swirls on the ground|r
>>|cRXP_WARN_Stay in|r |cRXP_FRIENDLY_Talanji|r|cRXP_WARN_'s Bubble when she casts it|r
>>Kill the |cRXP_ENEMY_Ice Barrier|r
.scenario 3730,1
.mob Ice Barrier
.zoneskip 862
.isOnQuest 50769
step << !ZandalariTroll
>>|cRXP_WARN_Follow the group|r
>>Kill the |cRXP_ENEMY_Alliance|r to reach |cRXP_FRIENDLY_Talanji|r's Ship |cRXP_WARN_with the group|r
.scenario 3788,1
.goto 1012,33.54,34.75,30,0
.goto 1012,31.47,31.73,30,0
.goto 1012,29.14,31.42,30,0
.goto 1012,29.69,26.64,30,0
.goto 1012,19.64,25.70
.mob Gilnean Mauler
.mob Stormwind Guard
.mob Stormwind Knight
.mob Stormwind Battlemage
.mob Teldrassil Sentinel
.mob Dwarven Rifleman
.mob Gnomish Gyro-Engineer
.mob Exodar Peacekeeper
.zoneskip 862
.isOnQuest 50769
step << !ZandalariTroll
.goto 1012,20.07,28.76,10,0
.goto 1012,20.54,28.94
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematics|r
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Talanji|r when she gets onto the ship
.complete 50769,3 
.target Princess Talanji
.skipgossip
.zoneskip 862
.isOnQuest 50769
steps << !ZandalariTroll
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nathanos|r
.goto 862,57.95,62.76
.turnin 60361 >>Turn in Battle for Azeroth: Mission Statement
.target Nathanos Blightcaller
.isOnQuest 60361
step << !ZandalariTroll
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nathanos|r
.turnin 50769 >>Turn in The Stormwind Extraction
.goto 1164,40.11,71.56,-1
.goto 862,57.96,62.76,-1
.target Nathanos Blightcaller
.isQuestComplete 50769
step << !ZandalariTroll
#label ZuldazarWelcometoZuldazar
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Talanji|r
.accept 46957 >>Accept Welcome to Zuldazar
.goto 862,57.95,62.46
.target Princess Talanji
.zoneskip 1164
step << !ZandalariTroll
.goto 1165,50.78,92.73,40,0
.goto 1165,50.35,90.93,40,0
.goto 1165,49.94,85.84,40,0
.goto 1165,48.89,83.91,40,0
.goto 1165,49.98,82.33
>>|cRXP_WARN_Stay close to |cRXP_FRIENDLY_Princess Talanji|r else she will stop moving|r
.complete 46957,1 
.target Princess Talanji
.zoneskip 1164
step << !ZandalariTroll
.goto 1165,49.98,82.33
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_General Jakra'zet|r
.turnin 46957 >>Turn in Welcome to Zuldazar
.accept 46930 >>Accept Rastakhan
.target General Jakra'zet
.zoneskip 1164
step << !ZandalariTroll
.goto 1165,49.98,82.58
>>|cRXP_WARN_DO NOT ride the Pterrordax|r
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tInstead, talk to |cRXP_FRIENDLY_Talanji|r
>>Press "Escape" on your keyboard to skip the cinematic
.complete 46930,1 
.target Princess Talanji
.skipgossip
.zoneskip 1164
step << !ZandalariTroll
.goto 1165,49.91,42.72
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_King Rastakhan|r
.turnin 46930 >>Turn in Rastakhan
.accept 46931 >>Accept Speaker of the Horde
.target King Rastakhan
.zoneskip 1164
step << !ZandalariTroll
#completewith next
>>|cRXP_WARN_Follow the arrow.|r You don't need to follow Zolani
.goto 1165,49.43,44.67,10,0
.goto 1165,48.66,44.61,20,0
.goto 1165,49.93,39.86
.complete 46931,1 
.isOnQuest 46931
step << !ZandalariTroll
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick the shade of the |cRXP_PICK_Horde Banner|r
.goto 1165,49.93,39.86
.complete 46931,2 
.isOnQuest 46931
step << !ZandalariTroll
#completewith next
.cooldown item,132516,>0,1
.cast 202844 >>Use your |T1405809:0|t[Gunshoes] to move faster
.use 132516
.itemcount 132516,1
.isOnQuest 46931
step << !ZandalariTroll
>>Go into the three rooms
.complete 46931,3 
.goto 1163,49.78,73.50
.complete 46931,4 
.goto 1163,67.67,70.75
.complete 46931,5 
.goto 862,57.57,44.37
.isOnQuest 46931
step << !ZandalariTroll
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tGo up and talk to |cRXP_FRIENDLY_Talanji|r
*If you're very fast then you can skip Talanji's roleplay by relogging
.goto 1164,44.67,70.33,20,0
.goto 1164,41.22,66.75
.turnin 46931 >>Turn in Speaker of the Horde
.target Princess Talanji
.isOnQuest 46931
step << ZandalariTroll
#completewith EnterDazaralorZandalariTroll
#label ZuldazarZandalariTroll
#hidewindow
.goto 1164,41.17,66.77,0,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Princess Talanji|r
.turnin 47514 >>Turn in Zuldazar
.accept 49615 >>Accept Trust of a King
.target Princess Talanji
step << ZandalariTroll
#completewith ZuldazarZandalariTroll
#label PortalToZuldazarZandalariTroll
.zoneskip 85,1
.goto 85,53.54,90.37,6,0
.goto 85,58.54,91.27
.zone 862 >>Use the |cRXP_PICK_Portal to Zuldazar|r
step << ZandalariTroll
#requires PortalToZuldazarZandalariTroll
#label EnterDazaralorZandalariTroll
.goto 1165,49.94,42.14,6 >>|cRXP_WARN_Fly up with skyriding|r. Enter Dazar'alor
step << ZandalariTroll
#requires EnterDazaralorZandalariTroll
.goto 1164,41.17,66.77
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Princess Talanji|r
.turnin 47514 >>Turn in Zuldazar
.accept 49615 >>Accept Trust of a King
.target Princess Talanji
step
.goto 1163,48.87,71.63
.home >>Set your Hearthstone to The Great Seal
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#subgroup Chromie Time (Veteran Player)
#name b) Horde Draenor Scenario
#displayname |cFFFCDC00Chapter 2|r - Draenor Scenario
#next c) Horde Draenor Garrison
#veteran
<< Horde
step
.isQuestAvailable 36881
.goto 1163,74.00,69.92
.zone 85 >> Take the portal to Orgrimmar
step
.abandon 34398 >>Abandon Warlods of Draenor: The Dark Portal
step
#completewith next
#label AcceptTheDarkPortal
.goto 17,54.93,50.26,0,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
.accept 36881 >>Accept Warlords of Draenor: The Dark Portal
.target Archmage Khadgar
step
#completewith AcceptTheDarkPortal
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|t|cRXP_WARN_Follow the arrow.|r Talk to the |cRXP_FRIENDLY_Thrallmar Battlemage|r downstairs
.goto 85,54.81,89.85,8,0
.goto 85,54.64,87.10,8,0
.goto 85,56.03,86.99,8,0
.goto 85,57.14,90.69
.skipgossip 1
.zone 17 >>Travel to the Blasted Lands
.target Thrallmar Mage
step
#requires AcceptTheDarkPortal
.goto 17,54.93,50.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
.accept 36881 >>Accept Warlords of Draenor: The Dark Portal
.target Archmage Khadgar
step
.goto 17,54.93,50.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r |cRXP_WARN_and accept the popup|r
.complete 36881,1 
.target Archmage Khadgar
step
.goto 577,54.79,48.28
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
.target Archmage Khadgar
.turnin 34398 >>Turn in Warlords of Draenor: The Dark Portal
.accept 35933 >>Accept Azeroth's Last Stand
step
.goto 577,52.76,43.25
>>Kill an |cRXP_ENEMY_Iron Grunt|r. Loot him for the |T133469:0|t[Iron Horde Missive]
.complete 35933,1 
step
>>Click on the quest in your quest log under the minimap.
.turnin 35933 >>Turn in Azeroth's Last Stand
.accept 34392 >>Accept Onslaught's End
step
.goto 577,51.03,42.00
>>Click on the |cRXP_PICK_Fel Spire|r
.complete 34392,1 
step
.goto 577,51.26,54.58
>>Click on the |cRXP_PICK_Fel Spire|r
.complete 34392,2 
step
.goto 577,52.98,48.30,30,0
.goto 577,54.70,48.25
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
.turnin 34392 >>Turn in Onslaught's End
.accept 34393 >>Accept The Portal's Power
.target Archmage Khadgar
step
.goto 577,54.92,45.03,8,0
.goto 577,54.93,46.13
>>|cRXP_WARN_Follow the arrow|r
.complete 34393,1 
step
.goto 577,56.02,46.32
>>Click on the |cRXP_PICK_Mark of the Burning Blade|r
.complete 34393,2 
step
.goto 577,57.26,48.18
>>Click on the |cRXP_PICK_Mark of the Shattered Hand|r
.complete 34393,3 
step
.goto 577,56.07,50.20
>>Click on the |cRXP_PICK_Mark of the Blackrock|r
.complete 34393,4 
step
.goto 577,55.99,48.23
>>Click on the |cRXP_PICK_Stasis Rune|r on the ground
.complete 34393,5 
step
#completewith next
#label PortalsPower
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
.goto 577,56.82,45.84,0,0
.turnin 34393 >>Turn in The Portal's Power
.accept 34420 >>Accept The Cost of War
.target Archmage Khadgar
step
#completewith PortalsPower
#title Leave Prison
.goto 577,54.94,45.20,8 >>Leave the Prison
step
#requires PortalsPower
.goto 577,56.82,45.84,8,0
.goto 577,54.76,48.28
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
.turnin 34393 >>Turn in The Portal's Power
.accept 34420 >>Accept The Cost of War
.target Archmage Khadgar
step
.itemcount 132516,1
#completewith BlastedLandsTheDarkPortal
.cooldown item,132516,>0,1
.cast 202844 >>Use |T1405809:0|t[Gunshoes]
step
.goto 577,60.26,56.32
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
.turnin 34420 >>Turn in The Cost of War
.accept 34422 >>Accept Blaze of Glory
.target Archmage Khadgar
step
.goto 577,62.26,52.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ashka|r and |cRXP_FRIENDLY_Korag|r
.accept 35241 >>Accept Vengeance for the Fallen
.target +Ashka
.accept 34421 >>Accept Bled Dry
.target +Korag
step
#completewith BledDry
>>Kill |cRXP_ENEMY_Bleeding Hollow Orcs|r on the side
.goto 577,63.57,64.18,0,0
.complete 35241,1 
.mob Bleeding Hollow Savage
.mob Bleeding Hollow Berserker
.mob Bleeding Hollow Hatchet
step
.goto 577,63.61,50.07
>>Use the |T132839:0|t[Lucifrium Bead] to burn 3 |cRXP_PICK_Bleeding Hollow huts|r
.complete 34422,1,3 
.use 113191
step
.goto 577,65.74,54.21
>>Click on the |cRXP_PICK_Bleeding Hollow Cage|r
.complete 34421,1 
step
.goto 577,66.49,56.09
>>Use the |T132839:0|t[Lucifrium Bead] to burn 2 |cRXP_PICK_Bleeding Hollow huts|r
.complete 34422,1,5 
.use 113191
step
#completewith next
.goto 577,61.02,62.77,0
>>Click on the |cRXP_PICK_Bleeding Hollow Cage|r
.complete 34421,2 
step
.goto 577,61.43,61.97,0,0
>>Use the |T132839:0|t[Lucifrium Bead] to burn the missing |cRXP_PICK_Bleeding Hollow huts|r
.complete 34422,1 
.use 113191
step
#label BledDry
.goto 577,61.02,62.77
>>Click on the |cRXP_PICK_Bleeding Hollow Cage|r
.complete 34421,2 
step
#loop
.goto 577,65.80,69.32,35,0
.goto 577,61.02,62.77,35,0
.goto 577,66.49,56.09,35,0
.goto 577,63.61,50.07,35,0
.goto 577,61.02,62.77,35,0
>>Kill |cRXP_ENEMY_Bleeding Hollow Orcs|r on the side
.complete 35241,1 
.mob Bleeding Hollow Savage
.mob Bleeding Hollow Berserker
.mob Bleeding Hollow Hatchet
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thrall|r and |cRXP_FRIENDLY_Archmage Khadgar|r after a short roleplay
.turnin 35241 >>Turn in Vengeance for the Fallen
.goto 577,71.94,62.08
.target +Thrall
.turnin 34422 >>Turn in Blaze of Glory
.turnin 34421 >>Turn in Bled Dry
.accept 34423 >>Accept Altar Altercation
.goto 577,71.54,62.38
.target +Archmage Khadgar
step
.goto 577,71.99,62.19
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ariok|r
.complete 34423,1 
.target Ariok
.skipgossipid 43152
step
.goto 577,76.98,58.04
>>|cRXP_WARN_Follow the arrow|r
.complete 34423,2 
step
#completewith next
#label BloodRitualOrbDestroyedA
.goto 577,79.22,57.04,0,0
>>Click on the |cRXP_PICK_Blood Ritual Orb|r
.complete 34423,3,1 
step
#completewith BloodRitualOrbDestroyedA
#title Go up the stairs
.goto 577,79.22,57.04,8 >>Go up the stairs
step
#requires BloodRitualOrbDestroyedA
.goto 577,79.22,57.04,8,0
.goto 577,78.64,53.38
>>Click on the |cRXP_PICK_Blood Ritual Orb|r
.complete 34423,3,1 
step
.goto 577,78.19,53.52
>>Click on the |cRXP_PICK_Blood Ritual Orb|r
.complete 34423,3,2 
step
.goto 577,76.68,53.87
>>Click on the |cRXP_PICK_Blood Ritual Orb|r
.complete 34423,3 
step
.goto 577,72.02,41.90
>>|cRXP_WARN_Cross the bridge|r
.complete 34423,4 
step
.goto 577,71.95,40.47
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
.turnin 34423 >>Turn in Altar Altercation
.accept 34425 >>Accept The Kargathar Proving Grounds
.timer 30,Roleplay Duration
.target Archmage Khadgar
step
.goto 577,73.03,38.11
>>|cRXP_WARN_Wait for the roleplay|r
.complete 34425,1 
step
.goto 577,73.03,38.11
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
.turnin 34425 >>Turn in The Kargathar Proving Grounds
.accept 34427 >>Accept A Potential Ally
.target Archmage Khadgar
step
.goto 577,68.91,33.73
>>Use the |T252270:0|t[Frostfire Focus] near the fire
*|cRXP_WARN_Spam use the item if you have a bleed on you.|r
.complete 34427,1 
.timer 22,Wait for Farseer Drek'Thar
.use 110799
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farseer Drek'Thar|r and |cRXP_FRIENDLY_Archmage Khadgar|r
.turnin 34427 >>Turn in A Potential Ally
.goto 577,73.18,38.95
.target +Farseer Drek'Thar
.accept 34429 >>Accept Kill Your Hundred
.goto 577,73.03,38.10
.target +Archmage Khadgar
step
.goto 577,73.38,27.13
>>|cRXP_WARN_Wait at the waypoint location for roughly 20 seconds|r
.complete 34429,1 
step
.goto 577,73.37,27.40
>>Kill the |cRXP_ENEMY_Shattered Hand Brawlers|r
.complete 34429,2,99 
.mob Shattered Hand Brawler
step
.goto 578,81.88,49.92
>>|cRXP_WARN_Follow the arrow|r
.complete 34429,3 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r, |cRXP_FRIENDLY_Thrall|r and |cRXP_FRIENDLY_Luuka|r
.turnin 34429 >>Turn in Kill Your Hundred
.goto 578,81.31,50.26
.accept 34739 >>Accept The Shadowmoon Clan
.goto 578,81.56,44.78
.accept 34737 >>Accept Masters of Shadow
.goto 578,82.90,44.35
.target Archmage Khadgar
.target Thrall
.target Luuka
step
#sticky
#label TanaanJungleIntroEnemyUmbralHalls
>>Kill |cRXP_ENEMY_Void Wolfs|r, |cRXP_ENEMY_Shadowmoon Ritualists|r or |cRXP_ENEMY_Shadowmoon Voidaxes|r
.goto 578,56.93,51.91,0,0
.complete 34739,1 
.mob Void Wolf
.mob Shadowmoon Ritualist
.mob Shadowmoon Voidaxe
step
>>Kill |cRXP_ENEMY_Taskmaster Gurran|r
.goto 578,46.37,38.95,10,0
.goto 578,52.69,24.16
.complete 34737,2 
.mob Taskmaster Gurran
step
.goto 578,53.52,19.81,4,0
.goto 578,45.59,15.27
>>|cRXP_WARN_Jump down and follow the arrow|r
.complete 34737,3 
step
.goto 578,45.20,15.69
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Yrel|r
.accept 34740 >>Accept Yrel
.target Yrel
step
.goto 578,57.43,37.36,8,0
.goto 578,46.79,41.78
>>|cRXP_WARN_Follow the arrow to the escort location|r
.complete 34740,1 
step
>>Kill |cRXP_ENEMY_Ungra|r
.goto 578,46.41,41.62,20,0
.goto 578,43.78,77.37
.complete 34737,1 
.mob Ungra
step
#requires TanaanJungleIntroEnemyUmbralHalls
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Olin Umberhide|r, |cRXP_FRIENDLY_Yrel|r, and |cRXP_FRIENDLY_Lady Liadrin|r
.turnin 34739 >>Turn in The Shadowmoon Clan
.goto 578,51.19,46.86
.target +Olin Umberhide
.turnin 34740 >>Turn in Yrel
.goto 578,50.55,48.28
.target +Yrel
.turnin 34737 >>Turn in Masters of Shadow
.accept 34741 >>Accept Keli'dan the Breaker
.goto 578,50.13,48.25
.target +Lady Liadrin
step
>>Kill |cRXP_ENEMY_Keli'dan the Breaker|r
*|cRXP_WARN_Talent info some self healing or a pet before pulling him (without Heirlooms)|r. Hold your interrupt/stun for his ability 'Void Vacuum'.
*|cRXP_WARN_Drag him away from the totems otherwise he will deal a lot more damage|r
.goto 578,36.30,48.95
.complete 34741,1 
.mob Keli'dan the Breaker
step
.goto 577,49.53,14.46
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
.turnin 34741 >>Turn in Keli'dan the Breaker
.target Archmage Khadgar
step
.goto 577,50.08,13.34
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thrall|r
.accept 35005 >>Accept Prepare for Battle
.target Thrall
step
#completewith next
+Best sources for Blackrock Weapons:
>>1) |cRXP_PICK_Iron Horde Weapon Racks|r
>>2) |cRXP_ENEMY_Blackrock Forgeworkers|r who are 'carrying Weapons'
step
#loop
.goto 577,43.21,15.75,20,0
.goto 577,41.46,17.75,25,0
.goto 577,44.81,19.62,15,0
.goto 577,46.94,21.23,15,0
.goto 577,45.91,19.15,15,0
>>Pick up |cRXP_PICK_Blackrock Weapons|r
.complete 35005,1 
.mob Blackrock Forgeworker
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thrall|r and |cRXP_FRIENDLY_Cordana Felsong|r
.turnin 35005 >>Turn in Prepare for Battle
.goto 577,50.06,13.31
.target +Thrall
.accept 34439 >>Accept The Battle of the Forge
.goto 577,49.50,14.22
.target +Cordana Felsong
step
#loop
.goto 577,44.13,15.06,35,0
.goto 577,43.21,19.33,35,0
>>Kill the |cRXP_ENEMY_Grunts|r and |cRXP_ENEMY_Ogrons|r in the area
>>|cRXP_WARN_Focus on low HP mobs|r
.complete 34439,1 
.complete 34439,2 
.mob Blackrock Grunt
.mob Ogron Warcrusher
step
.goto 577,43.04,26.37
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farseer Drek'Thar|r
.turnin 34439 >>Turn in The Battle of the Forge
.accept 34442 >>Accept Ga'nar of the Frostwolf
.target Farseer Drek'Thar
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hansel Heavyhands|r and |cRXP_FRIENDLY_Thaelin Darkanvil|r
.accept 34987 >>Accept The Gunpowder Plot
.goto 577,44.10,29.54
.target +Hansel Heavyhands
.accept 34958 >>Accept The Shadow of the Worldbreaker
.goto 577,44.07,29.69
.target +Thaelin Darkanvil
step
#completewith BackrockPowderKegB
>>Kill |cRXP_ENEMY_orcs|r in the area. Loot them for the |cRXP_LOOT_schematics|r
.goto 577,42.56,39.85,0,0
.complete 34958,1 
.mob Blackrock Laborer
.mob Blackrock Machinist
step
.goto 577,41.92,42.05
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ga'nar|r
.turnin 34442 >>Turn in Ga'nar of the Frostwolf
.accept 34925 >>Accept Polishing the Iron Throne
.target Ga'nar
step
#completewith next
#label GanarsShackleKey
.goto 577,45.64,39.71,0,0
>>Kill |cRXP_ENEMY_Overseer Gotrigg|r downstairs. Loot him for |T134245:0|t[|cRXP_LOOT_Ga'nar's Shackle Key|r]
*|cRXP_WARN_If necessary run away from him when his blade is burning.|r
.complete 34925,1 
.mob Overseer Gotrigg
step
#completewith GanarsShackleKey
#title Enter House
.goto 577,44.29,38.07,8 >>Enter the building
step
#requires GanarsShackleKey
.goto 577,45.64,39.71
>>Kill |cRXP_ENEMY_Overseer Gotrigg|r downstairs. Loot him for |T134245:0|t[|cRXP_LOOT_Ga'nar's Shackle Key|r]
*|cRXP_WARN_If necessary run away from him when his blade is burning.|r
.complete 34925,1 
.mob Overseer Gotrigg
step
#completewith next
#label PolishingTheIronThrone
.goto 577,41.86,42.10,0,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ga'nar|r
.turnin 34925 >>Turn in Polishing the Iron Throne
.accept 34437 >>Accept The Prodigal Frostwolf
.target Ga'nar
step
#completewith PolishingTheIronThrone
#title Leave House
.goto 577,44.29,38.07,8 >>Leave the building
step
#requires PolishingTheIronThrone
.goto 577,41.86,42.10
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ga'nar|r
.turnin 34925 >>Turn in Polishing the Iron Throne
.accept 34437 >>Accept The Prodigal Frostwolf
.target Ga'nar
step
#completewith next
#label BackrockPowderKeg
.goto 577,46.98,32.15
>>Click on the |cRXP_PICK_Blackrock Powder Keg|r
.complete 34987,1 
step
#completewith BackrockPowderKeg
#title Enter House
.goto 577,45.54,31.69,8 >>Enter the building
step
#requires BackrockPowderKeg
#label BackrockPowderKegB
.goto 577,46.98,32.15
>>Click on the |cRXP_PICK_Blackrock Powder Keg|r
.complete 34987,1 
step
#loop
.goto 577,41.10,49.90,35,0
.goto 577,45.24,30.38,35,0
>>Kill |cRXP_ENEMY_orcs|r in the area. Loot them for the |cRXP_LOOT_schematics|r
.complete 34958,1 
.mob Blackrock Laborer
.mob Blackrock Machinist
step
#completewith next
#label ShadowOfTheWorldbreaker
.goto 577,44.09,29.69
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thaelin Darkanvil|r
.turnin 34958 >>Turn in The Shadow of the Worldbreaker
.target Thaelin Darkanvil
step
#completewith ShadowOfTheWorldbreaker
.goto 577,44.08,29.62
>>Click on the |cRXP_PICK_Makeshift Plunger|r
.complete 34987,2 
step
#requires ShadowOfTheWorldbreaker
.goto 577,44.08,29.62
>>Click on the |cRXP_PICK_Makeshift Plunger|r
.complete 34987,2 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thaelin Darkanvil|r and |cRXP_FRIENDLY_Hansel Heavyhands|r
.turnin 34958 >>Turn in The Shadow of the Worldbreaker
.goto 577,44.09,29.69
.target +Thaelin Darkanvil
.turnin 34987 >>Turn in The Gunpowder Plot
.goto 577,44.09,29.56
.target +Hansel Heavyhands
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farseer Drek'Thar|r and |cRXP_FRIENDLY_Archmage Khadgar|r
>>|cRXP_WARN_It's possible that you have to wait a few seconds before the quest pops up|r
.turnin 34437 >>Turn in The Prodigal Frostwolf
.goto 577,43.03,26.38
.target +Farseer Drek'Thar
.accept 35747 >>Accept Taking a Trip to the Top of the Tank
.goto 577,43.13,28.74
.target +Archmage Khadgar
step
.goto 577,44.08,29.69
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thaelin Darkanvil|r
.complete 35747,1 
.target Thaelin Darkanvil
.skipgossipid 42452
step
.itemcount 132516,1
#completewith next
.use 132516
.cooldown item,132516,>0,1
.cast 202844 >>Use |T1405809:0|t[Gunshoes]
step
.goto 577,37.45,48.33
>>Kill |cRXP_ENEMY_Gogluk|r
.complete 35747,2 
.mob Gogluk
step
.goto 577,40.14,48.32
>>|cRXP_WARN_Follow the arrow upwards|r
.complete 35747,3 
step
.goto 577,40.11,48.43
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thaelin Darkanvil|r
.turnin 35747 >>Turn in Taking a Trip to the Top of the Tank
.accept 34445 >>Accept A Taste of Iron
.target Thaelin Darkanvil
step
.goto 577,40.17,48.99
>>Click on the |cRXP_PICK_Worldbreaker Side Turret|r
.complete 34445,1 
step
.goto 577,40.18,48.74
>>Spam |T252185:0|t[Turret Blast] (1) on the spot shown in the picture. |cRXP_WARN_You can ignore the cannons|r
.link https://i.imgur.com/C5x3cTM.jpeg >>Spot to shoot at
.complete 34445,2 
step
.goto 577,40.30,48.30
>>Click on the |cRXP_PICK_Main Cannon Trigger|r
.complete 34445,3 
step
.goto 577,40.12,48.43
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thaelin Darkanvil|r
.turnin 34445 >>Turn in A Taste of Iron
.accept 34446 >>Accept The Home Stretch
.target Thaelin Darkanvil
step
.itemcount 132516,1
#completewith next
.use 132516
.cooldown item,132516,>0,1
.cast 202844 >>Use |T1405809:0|t[Gunshoes]
step
.goto 577,44.30,79.91
>>|cRXP_WARN_Follow the arrow|r
.complete 34446,1 
step
.goto 577,44.38,80.73
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
.turnin 34446 >>Turn in The Home Stretch
.accept 33868 >>Accept The Home of the Frostwolves
.target Archmage Khadgar
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#subgroup Chromie Time (Veteran Player)
#name c) Horde Draenor Garrison
#displayname |cFFFCDC00Chapter 3|r - Draenor Garrison Intro
#next d) Horde Zuldazar
#veteran
<< Horde
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farseer Drek'Thar|r
.target Farseer Drek'Thar
.goto 525,40.79,67.09
.turnin 33868 >>Turn in The Home of the Frostwolves
.accept 33815 >>Accept A Song of Frost and Fire
.timer 32,Introduction Roleplay
step
.goto 525,41.54,67.61,20,0
.goto 525,41.81,69.65
>>Wait next to |cRXP_FRIENDLY_Durotan|r
.complete 33815,1 
.target Durotan
step
.goto 525,41.81,69.65
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Durotan|r
.turnin 33815 >>Turn in A Song of Frost and Fire
.accept 34402 >>Accept Of Wolves and Warriors
.target Durotan
step
.goto 590,43.54,68.35,20,0
.goto 590,16.70,73.02,20,0
.goto 590,51.17,43.27
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|t|cRXP_WARN_Follow the way up the mountain.|r Talk to |cRXP_FRIENDLY_Thrall|r after he has arrived.
.turnin 34402 >>Turn in Of Wolves and Warriors
.accept 34364 >>Accept For the Horde!
.target Thrall
step
.goto 590,50.67,39.48
>>Click on the |cRXP_PICK_Horde Banner|r
.complete 34364,1 
.timer 16,Roleplay Duration
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tWait for |cRXP_FRIENDLY_Gazlowe|r and talk to him
.goto 590,51.25,39.61
.turnin 34364 >>Turn in For the Horde!
.accept 34375 >>Accept Back to Work
.accept 34592 >>Accept A Gronnling Problem
.target Gazlowe
step
#compeltewith BackToWork
.goto 590,40.18,28.26,0,0
>>Kill |cRXP_ENEMY_Frostfire Gronnlings|r
.complete 34592,1 
.mob Frostfire Gronnling
step
#title Tree marked (1/6)
.goto 590,47.29,57.32
>>Click on the |cRXP_PICK_Tree Marking|r
.complete 34375,1,1 
step
#title Tree marked (2/6)
.goto 590,48.59,62.82
>>Click on the |cRXP_PICK_Tree Marking|r
.complete 34375,1,2 
step
#title Tree marked (3/6)
>>Click on the |cRXP_PICK_Tree Marking|r
.goto 590,56.86,69.14
.complete 34375,1,3 
step
#title Tree marked (4/6)
.goto 590,59.53,72.74
>>Click on the |cRXP_PICK_Tree Marking|r
.complete 34375,1,4 
step
#title Tree marked (5/6)
.goto 590,62.64,55.31
>>Click on the |cRXP_PICK_Tree Marking|r
.complete 34375,1,5 
step
#label BackToWork
#title Tree marked (6/6)
.goto 590,63.30,51.90
>>Click on the |cRXP_PICK_Tree Marking|r
.complete 34375,1 
step
#loop
.goto 590,73.41,41.49,35,0
.goto 590,41.01,20.24,35,0
.goto 590,38.56,48.53,35,0
>>Kill |cRXP_ENEMY_Frostfire Gronnlings|r
.complete 34592,1 
.mob Frostfire Gronnling
step
.goto 590,51.26,39.63
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gazlowe|r
.turnin 34375 >>Turn in Back to Work
.turnin 34592 >>Turn in A Gronnling Problem
.accept 34765 >>Accept The Den of Skog
.target Gazlowe
step
.goto 590,48.88,84.72
>>Kill |cRXP_ENEMY_Skog|r. |cRXP_WARN_Watch out for his Ground Slap ability|r
.complete 34765,1 
.mob Skog
step
.goto 590,51.26,39.63
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gazlowe|r
.turnin 34765 >>Turn in The Den of Skog
.accept 34378 >>Accept Establish Your Garrison
.target Gazlowe
step
.goto 590,35.60,52.46
>>Click on the |cRXP_PICK_Master Surveyor|r
.complete 34378,1 
step
.goto 590,52.49,53.41
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gazlowe|r in front of the Architect Table
.turnin 34378 >>Turn in Establish Your Garrison
.target Gazlowe
step
.goto 590,52.49,53.41
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gazlowe|r
.accept 34824 >>Accept What We Got
.accept 34822 >>Accept What We Need
.target Gazlowe
step
.isOnQuest 34824
.goto 590,54.70,52.31
>>Click on the |cRXP_PICK_Garrison Cache|r to the left
.complete 34824,2 
step
.goto 590,51.29,51.43
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk with |cRXP_FRIENDLY_Rokhan|r
.accept 34823 >>Accept The Ogron Live?
.target Rokhan
step
.isOnQuest 34824
.goto 590,41.02,50.88
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Skaggit|r
.complete 34824,1 
.target Skaggit
.skipgossipid 42535
step
.isOnQuest 34824
.goto 590,49.36,16.51
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tGo north and talk to |cRXP_FRIENDLY_Senior Peon II|r
.complete 34824,3 
.target Senior Peon II
.skipgossipid 43217
step
.isOnQuest 34822
.itemcount 132516,1
#completewith next
.cooldown item,132516,>0,1
.cast 202844 >>Use |T1405809:0|t[Gunshoes]
step
.isOnQuest 34822
#completewith GroogSlainB
>>Kill |cRXP_ENEMY_Pack Boars|r. Loot them for the |cRXP_LOOT_salvage|r. Or pick up |cRXP_PICK_Drudgeboat Salvages|r directly
.complete 34822,1 
.mob Pack Boar
step
.isOnQuest 34823
#completewith next
#label GroogSlain
>>Kill |cRXP_ENEMY_Groog|r
>>Be sure to avoid his Rampaging Strike and Earthrending Slam.
.goto 525,40.29,58.95,0,0
.complete 34823,1 
.mob Groog
step
#completewith GroogSlain
#title Enter Cave
.goto 525,40.22,60.10,10 >>Enter the cave
step
.isOnQuest 34823
#requires GroogSlain
#label GroogSlainB
>>Kill |cRXP_ENEMY_Groog|r
>>Be sure to avoid his Rampaging Strike and Earthrending Slam.
.goto 525,40.29,58.95,10,0
.goto 525,41.92,59.19
.complete 34823,1 
.mob Groog
step
.isOnQuest 34822
#loop
.goto 525,42.04,59.51,5,0
.goto 525,42.17,58.09,5,0
.goto 525,41.79,58.30,10,0
.goto 525,40.18,59.91,10,0
>>Kill |cRXP_ENEMY_Pack Boars|r. Loot them for the |T132761:0|t[|cRXP_LOOT_Drudgeboat Salvage|r]. Or pick up |cRXP_PICK_Drudgeboat Salvages|r directly
.complete 34822,1 
.mob Pack Boar
step
#completewith next
#label WhatGotNeedLive
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk with |cRXP_FRIENDLY_Gazlowe|r and |cRXP_FRIENDLY_Rokhan|r just outside the building
.turnin 34824 >>Turn in What We Got
.turnin 34822 >>Turn in What We Need
.turnin 34823 >>Turn in The Ogron Live?
.target Gazlowe
.target Rokhan
step
.isOnQuest 34823
.zoneskip 590
#completewith WhatGotNeedLive
#title Use the |T1041860:0|t[Garrison Hearthstone]
.use 110560
.cast 171253 >>Use the Garrison Hearthstone
step
#requires WhatGotNeedLive
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk with |cRXP_FRIENDLY_Gazlowe|r and |cRXP_FRIENDLY_Rokhan|r just outside the building
.turnin 34824 >>Turn in What We Got
.turnin 34822 >>Turn in What We Need
.goto 590,52.47,53.33
.target +Gazlowe
.turnin 34823 >>Turn in The Ogron Live?
.goto 590,51.29,51.39
.target +Rokhan
step
.goto 590,52.47,53.33
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gazlowe|r
.accept 34461 >>Accept Build Your Barracks
.target Gazlowe
step
.goto 590,59.87,50.15
>>Click on the |cRXP_PICK_Garrison Blueprint: Barracks|r
.complete 34461,1 
step
.goto 590,59.87,50.15
>>Use the blueprint |T1001489:0|t[Barracks, Level 1] in your bags
.complete 34461,2 
.use 111956
step
.goto 590,52.27,53.59
>>Click on the |cRXP_PICK_Architect Table|r
*- |cRXP_WARN_Drag and drop 'Barrack' from the list on the left onto the glowing circle on the right|r
.complete 34461,3 
.target Gazlowe
step
.goto 590,57.42,48.34
>>Now you have to wait for ~10s and follow |cRXP_FRIENDLY_Gazlowe|r. If he doesn't move then talk to him, open the Architect Table again or just wait for 1-2 minutes longer.
.complete 34461,4 
step
.goto 590,58.14,48.42
>>Click on the |cRXP_PICK_Finalize Garrison Plot|r scroll
.complete 34461,5 
step
.goto 590,57.42,48.40
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gazlowe|r
.turnin 34461 >>Turn in Build Your Barracks
.target Gazlowe
step
.goto 590,57.42,48.40
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gazlowe|r
.accept 34861 >>Accept We Need An Army
.target Gazlowe
step
.goto 590,53.90,54.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Warmaster Zog|r
.turnin 34861 >>Turn in We Need An Army
.accept 34462 >>Accept Winds of Change
.target Warmaster Zog
step
#completewith next
#label RescueOlinUmberhide
.goto 525,57.31,62.92,0,0
>>Click on |cRXP_FRIENDLY_Olin Umberhide|r
.complete 34462,1 
.target Olin Umberhide
step
#completewith RescueOlinUmberhide
#title Enter Cave
.goto 525,56.76,62.59,6 >>Enter the cave
step
#requires RescueOlinUmberhide
.goto 525,57.31,62.92
>>Click on |cRXP_FRIENDLY_Olin Umberhide|r
.complete 34462,1 
.target Olin Umberhide
step
.goto 590,53.90,54.95
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Warmaster Zog|r
.turnin 34462 >>Turn in Winds of Change
.accept 34775 >>Accept Mission Probable
.target Warmaster Zog
step
.goto 590,53.79,54.62
>>Click on the |cRXP_PICK_Command Table|r. |cRXP_WARN_Follow these steps:|r
*- Click on the mission |cRXP_PICK_Gronnling Abound|r.
*- Drag |cRXP_FRIENDLY_Olin Umberhide|r to the follower frame unter the |cRXP_ENEMY_Frostfire Gronnling|r
*- Click on the |cRXP_WARN_"Start Mission"|r button
.complete 34775,1 
step
.goto 590,53.89,54.94
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Warmaster Zog|r
.turnin 34775 >>Turn in Mission Probable
.target Warmaster Zog
step
.zoneskip 1163
.hs >>Hearth to The Great Seal
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#subgroup Chromie Time (Veteran Player)
#name d) Horde Zuldazar
#displayname |cFFFCDC00Chapter 4|r - Zuldazar
#next e) Horde Silverpine Forest
#veteran
<< Horde
step
.isQuestAvailable 51443
.goto 85,40.83,80.16
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Chromie|r
>>|cRXP_WARN_Select "Battle for Azeroth" Campaign|r
*|cRXP_WARN_It's possible that it bugs out and doesn't give you the quest. If this is the case select the "Cataclysm" campaign and swap back to the "Battle for Azeroth" one until you get the quest|r
.accept 51443 >>Accept Battle for Azeroth: Mission Statement
.skipgossip
.target Chromie
step
.isOnQuest 51443
>>Enter the building
.goto 85,49.43,75.11
*You can skip most cinematics/cutscene by presseing ESC and then clicking yes
.complete 51443,1 
step
.isOnQuest 51443
.goto 85,54.43,78.47
>>Go into the Inn
.complete 51443,2 
step
.isQuestAvailable 50769
.goto 85,54.43,78.43
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nathanos BLightcaller|r
.turnin -51443 >>Turn in Battle for Azeroth: Mission Statement
.accept 50769 >>Accept The Stormwind Extraction
.target Nathanos Blightcaller
step
.isOnQuest 50769
.isQuestTurnedIn 52969
.zoneskip 862
+|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nathanos Blightcaller|r again
*|cRXP_WARN_Don't take the potion. If you did then abandon the quest and accept it again.|r
.goto 85,54.43,78.47
.skipgossip 1
.target Nathanos Blightcaller
step
.isOnQuest 50769
.zoneskip 862
>>Loot the |cRXP_PICK_potion|r on the table
.goto 85,54.58,78.36
.complete 50769,1 
step
.isOnQuest 50769
.zoneskip 85,1
.isQuestTurnedIn 52969
>>You took the potion. Abandon the quest, reaccept it and use the skip. If you really want to do the scenario again then skip this step
.abandon 50769
step
.isOnQuest 50769
#completewith next
.isQuestTurnedIn 52969
.zoneskip 85,1
+|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nathanos Blightcaller|r again
*|cRXP_WARN_Don't take the potion. If you did then abandon the quest and accept it again.|r
.goto 85,54.43,78.47
.skipgossip 1
.target Nathanos Blightcaller
step
.isOnQuest 50769
.zoneskip 85,1
>>Loot the |cRXP_PICK_potion|r on the table
.goto 85,54.58,78.36
.complete 50769,1 
step
.isQuestComplete 50769
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nathanos Blightcaller|r
.turnin 50769 >>Turn in The Stormwind Extraction
.goto 1164,40.11,71.56,-1
.goto 862,57.96,62.76,-1
.target Nathanos Blightcaller
step
.isOnQuest 50769
.zoneskip 862
>>Leave the building. Get onto a |cRXP_FRIENDLY_Skyhorn Eagle|r outside. |cRXP_WARN_It's worth doing the scenario at least once so you can skip it on subsequent characters|r
.goto 85,51.19,83.57
.complete 50769,2 
.target Skyhorn Eagle
step
.isOnQuest 50769
.zoneskip 862
.scenario 3718,1
step
.isOnQuest 50769
.zoneskip 862
>>|TInterface/GossipFrame/HealerGossipIcon:0|tDestroy the two |cRXP_PICK_Padlocks|r next to the waypoint by clicking on them. Afterwards follow the arrow into the trapdoor
.scenario 3719,2
.goto 1012,46.31,58.22
.scenario 3719,1
.goto 1012,46.31,57.96
step
.isOnQuest 50769
.zoneskip 862
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tIf possible ignore all mobs, open the door at the end as fast as possible and talk to |cRXP_FRIENDLY_Saurfang|r
.scenario 3720,1
.goto 1013,31.52,62.04,3,0
.goto 1013,50.99,39.32
step
.isOnQuest 50769
.zoneskip 862
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tIf possible ignore all mobs, open the door at the end as fast as possible and talk to |cRXP_FRIENDLY_Saurfang|r
.scenario 3721,2
.scenario 3721,1
.goto 1013,48.03,33.56,10,0
.goto 1013,55.92,64.00
>> You can already wait at the next prison cell
.skipgossip
step
.isOnQuest 50769
.zoneskip 862
>>Wait at the waypoint until you can see the barrier and then wait until the barrier disappears
.scenario 3722,1
.goto 1013,55.92,64.00
step
.isOnQuest 50769
.zoneskip 862
>>You only need to kill the mobs in front and inside the big circular room. If you're experienced you can ignore the other ones
*|TInterface/GossipFrame/HealerGossipIcon:0|tClick on the |cRXP_PICK_Stormwind Sewer Access|r at the end
.scenario 3722,2
.goto 1013,53.68,44.44,5,0
.goto 1013,87.17,23.20
step
.isOnQuest 50769
.zoneskip 862
>>|cRXP_WARN_Dismiss your pet as a Hunter or Warlock|r << Hunter/Warlock
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rokhan|r and follow him. Stay inside the shroud
.scenario 3727,1
.goto 1012,71.07,46.71,3,0
.skipgossip
.target Rokhan
step
.isOnQuest 50769
.zoneskip 862
>>Follow the arrow and kill mobs when you see them.
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tAt the end talk to |cRXP_FRIENDLY_Nathanos|r
.scenario 3729,1
.goto 1012,55.81,56.85
.scenario 3729,2
.goto 1012,53.20,55.42,15,0
.goto 1012,47.38,51.81,10,0
.goto 1012,49.42,42.23,15,0
.goto 1012,45.43,43.18
.skipgossip
.target Nathanos Blightcaller
step
.isOnQuest 50769
.zoneskip 862
>>Follow the arrow, dodge the swirlies on the ground and destroy the |cRXP_ENEMY_Ice Barrier|r
.scenario 3730,1
.goto 1012,39.79,40.59
.mob Ice Barrier
step
.isOnQuest 50769
.zoneskip 862
>>Follow the arrow, kill all mobs on the way. Wait for the NPCs to attack them if you're not confident that you can kill them alone
.scenario 3788,1
.goto 1012,36.61,34.81,20,0
.goto 1012,34.40,34.65,10,0
.goto 1012,31.79,31.66,10,0
.goto 1012,28.72,31.54,20,0
.goto 1012,29.81,26.57,25,0
.goto 1012,19.64,25.70
step
.isOnQuest 50769
.zoneskip 862
#completewith next
+You can skip the cutscene at the end by pressing ESC and clicking on Yes
step
.isOnQuest 50769
.zoneskip 862
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tFollow |cRXP_FRIENDLY_Princess Talanji|r and talk to her
.goto 1012,19.34,28.66,10,0
.goto 1012,20.54,28.93
.skipgossip
.complete 50769,3 
.mob Princess Talanji
steps
.isOnQuest 60361
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nathanos Blightcaller|r
.goto 862,57.95,62.76
.turnin 60361 >>Turn in Battle for Azeroth: Mission Statement
.target Nathanos Blightcaller
step
.isQuestComplete 50769
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nathanos Blightcaller|r
.turnin 50769 >>Turn in The Stormwind Extraction
.goto 1164,40.11,71.56,-1
.goto 862,57.96,62.76,-1
.target Nathanos Blightcaller
step
.zoneskip 1164
#label ZuldazarWelcometoZuldazar
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Princess Talanji|r
.accept 46957 >>Accept Welcome to Zuldazar
.goto 862,57.95,62.46
.mob Princess Talanji
step
.isOnQuest 46957
.zoneskip 1164
>>|cRXP_WARN_Stay close to |cRXP_FRIENDLY_Talanji|r else she will stop moving|r
.goto 1165,50.02,60.63,40,0
.goto 1165,50.78,92.73,40,0
.goto 1165,50.35,90.93,40,0
.goto 1165,49.94,85.84,40,0
.goto 1165,48.89,83.91,40,0
.goto 1165,49.98,82.33
.complete 46957,1 
step
.isQuestAvailable 46930
.zoneskip 1164
.goto 1165,49.98,82.33
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_General Jakra'zet|r
.turnin -46957 >>Turn in Welcome to Zuldazar
.accept 46930 >>Accept Rastakhan
.target General Jakra'zet
step
.isOnQuest 46930
.zoneskip 1164
.goto 1165,49.98,82.58
>>|cRXP_WARN_DO NOT ride the Pterrordax|r
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tInstead, talk to |cRXP_FRIENDLY_Princess Talanji|r
*Skip the next cinematic with ESC
.complete 46930,1 
.skipgossip
.mob Princess Talanji
step
.isQuestAvailable 46931
.zoneskip 1164
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_King Rastakhan|r
.goto 1165,49.91,42.72
.turnin -46930 >>Turn in Rastakhan
.accept 46931 >>Accept Speaker of the Horde
.target King Rastakhan
step
.isOnQuest 46931
#completewith next
>>|cRXP_WARN_Follow the arrow.|r You don't need to follow |cRXP_FRIENDLY_Zolani|r
.goto 1165,49.43,44.67,10,0
.goto 1165,48.66,44.61,20,0
.goto 1165,49.93,39.86
.complete 46931,1 
step
.isOnQuest 46931
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick on the shade of the |cRXP_PICK_Horde Banner|r
.goto 1165,49.93,39.86
.complete 46931,2 
step
.isOnQuest 46931
#completewith next
.cooldown item,132516,>0,1
.cast 202844 >>Use your |T1405809:0|t[Gunshoes] to move faster
.use 132516
.itemcount 132516,1
step
.isOnQuest 46931
>>Go into the three rooms
.complete 46931,3 
.goto 1163,49.78,73.50
.complete 46931,4 
.goto 1163,67.67,70.75
.complete 46931,5 
.goto 862,57.57,44.37
step
.isOnQuest 46931
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tGo up and talk to |cRXP_FRIENDLY_Talanji|r
*If you're very fast then you can skip Talanji's roleplay by relogging
.goto 1164,44.67,70.33,20,0
.goto 1164,41.22,66.75
.turnin 46931 >>Turn in Speaker of the Horde
.target Princess Talanji
step << DemonHunter
.xp <20,1
.pve
.zoneskip 85,1
#title Active War Mode. Skip if you don't want to.
+Skip if you don't want to activate War Mode (Bottom Right on your Talent Window (N)) even though it increases your experience gain by at least 10%
step
#label PortalToZuldazarCatchupA
.isQuestAvailable 27484
.goto 85,53.38,90.49,10,0
.goto 85,58.52,91.31
.zone 862 >>Enter the |cRXP_PICK_Portal to Zuldazar|r
.zoneskip 85,1
step
#label ZuldazarAcceptZuldazar
.goto 1164,41.72,69.33
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick on the |cRXP_PICK_Scouting Map|r, click on Zuldazar. Accept the quest
.accept 47514 >>Accept Zuldazar
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Talanji|r
.goto 1164,41.22,66.75
.turnin 47514 >>Turn in Zuldazar
.accept 49615 >>Accept Trust of a King
.target Princess Talanji
step
#completewith next
.goto 1164,22.67,72.08,5,0
.goto 1165,48.72,44.92,10,0
.goto 1165,49.56,44.60,18 >>Take the elevator up to |cRXP_FRIENDLY_King Rastakhan|r
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_King Rastakhan|r, |cRXP_FRIENDLY_Zolani|r, and |cRXP_FRIENDLY_Yazma|r |cRXP_WARN_upstairs|r
.goto 1165,49.93,46.62
.turnin 49615 >>Turn in Trust of a King
.accept 49488 >>Accept Tal'gurub
.target King Rastakhan
step
#label Hatchling2
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Direhorn Hatchling|r
.goto 862,65.66,41.35
.accept 47226 >>Accept The Orphaned Hatchling
.target Direhorn Hatchling
step
.goto 862,66.81,42.51
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Beastlord L'kala|r
.turnin 47226 >>Turn in The Orphaned Hatchling
.accept 47259 >>Accept Direhorn Daycare
.accept 48527 >>Accept Ravenous Landsharks
.target Beastlord L'kala
step
.goto 862,66.56,42.35
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jes'tri|r
.home >>Set your Hearthstone to Beastcaller Inn
.target Jes'tri
step
#completewith next
>>Kill |cRXP_ENEMY_Irritable Diemetradon|r
.goto 862,68.35,45.75,0,0
.complete 48527,1 
.mob Irritable Diemetradon
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick the |cRXP_PICK_Soothing Lilybuds|r
*When the plant keeps glowing you have to click it again
.goto 862,68.09,43.42,6,0
.goto 862,68.70,43.99,6,0
.goto 862,68.96,44.07,6,0
.goto 862,69.90,44.22,6,0
.goto 862,69.53,44.95,6,0
.goto 862,69.20,45.51,6,0
.goto 862,68.88,45.34,6,0
.goto 862,68.65,44.48,6,0
.goto 862,68.11,44.31,6,0
.goto 862,68.38,45.78
.complete 47259,1 
step
.goto 862,69.04,47.68,30,0
.goto 862,69.61,44.45,30,0
.goto 862,68.96,43.89
>>Kill |cRXP_ENEMY_Irritable Diemetradons|r
.complete 48527,1 
.mob Irritable Diemetradon
step
#label DirehornD
#requires ZuldazarIrritableDiemetraden
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Beastlord L'kala|r and |cRXP_FRIENDLY_Trader Alexxi|r
.turnin 47259 >>Turn in Direhorn Daycare
.turnin 48527 >>Turn in Ravenous Landsharks
.accept 47311 >>Accept Headbutting 101
.goto 862,66.81,42.51
.accept 47272 >>Accept Direhorn Growth Hormone
.goto 862,66.81,42.58
.target Beastlord L'kala
.target Trader Alexxi
step
#completewith next
.cooldown item,132516,>0,1
.cast 202844 >>Use your |T1405809:0|t[Gunshoes] to move faster
.use 132516
.itemcount 132516,1
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_PICK_Poster|r and |cRXP_FRIENDLY_Wingrider Nivek|r
.accept 51980 >>Accept WANTED: Jabra'kan
.goto 862,69.07,40.85
.accept 47312 >>Accept Queenfeather
.goto 862,69.02,40.69
.target Wingrider Nivek
step
#completewith ZuldazarDirehornGrowthHormone
>>|cRXP_WARN_Use your [ExtraActionButton] ON COOLDOWN on |cRXP_ENEMY_Savagemane Ravasaurs|r and |cRXP_ENEMY_Invasive Eggsnatchers|r|r
.complete 47311,1 
.mob Savagemane Ravasaurs
.mob Invasive Eggsnatchers
step
#completewith ZuldazarDirehornGrowthHormone6
>>Kill |cRXP_ENEMY_Queenfeather|r. Loot her for her |cRXP_LOOT_plume|r
.goto 862,71.14,40.26,0,0
.complete 47312,1 
.mob Queenfeather
step
#title Fresh Carrion (1/10)
>>Click on the |cRXP_PICK_Steaming Fresh Carrions|r on the ground
.goto 862,70.01,40.40
.complete 47272,1,1 
step
#title Fresh Carrion (2/10)
>>Click on the |cRXP_PICK_Steaming Fresh Carrions|r on the ground
.goto 862,70.18,40.26
.complete 47272,1,2 
step
#title Fresh Carrion (3/10)
>>Click on the |cRXP_PICK_Steaming Fresh Carrions|r on the ground
.goto 862,70.54,40.60
.complete 47272,1,3 
step
#title Fresh Carrion (4/10)
>>Loot the |cRXP_PICK_Steaming Fresh Carrions|r on the ground
.goto 862,70.82,40.95
.complete 47272,1,4 
step
#title Fresh Carrion (5/10)
>>Loot the |cRXP_PICK_Steaming Fresh Carrions|r on the ground
.goto 862,71.37,41.36
.complete 47272,1,5 
step
#label ZuldazarDirehornGrowthHormone6
#title Fresh Carrion (6/10)
>>Loot the |cRXP_PICK_Steaming Fresh Carrions|r on the ground
.goto 862,71.38,40.68
.complete 47272,1,6 
step
#label ZuldazarQueenfeather
>>Kill |cRXP_ENEMY_Queenfeather|r. Loot her for her |cRXP_LOOT_plume|r
.goto 862,71.14,40.26,0,0
.complete 47312,1 
.mob Queenfeather
step
#title Fresh Carrion (7/10)
>>Loot the |cRXP_PICK_Steaming Fresh Carrions|r on the ground
.goto 862,70.73,39.81
.complete 47272,1,7 
step
#title Fresh Carrion (8/10)
>>Loot the |cRXP_PICK_Steaming Fresh Carrions|r on the ground
.goto 862,70.76,39.51
.complete 47272,1,8 
step
#title Fresh Carrion (9/10)
>>Loot the |cRXP_PICK_Steaming Fresh Carrions|r on the ground
.goto 862,70.35,39.59
.complete 47272,1,9 
step
#label ZuldazarDirehornGrowthHormone
#title Fresh Carrion (10/10)
>>Loot the |cRXP_PICK_Steaming Fresh Carrions|r on the ground
.goto 862,70.00,39.25
.complete 47272,1 
step
>>|cRXP_WARN_Use your [ExtraActionButton] ON COOLDOWN on |cRXP_ENEMY_Savagemane Ravasaurs|r and |cRXP_ENEMY_Invasive Eggsnatchers|r|r
.goto 862,70.37,39.76
.complete 47311,1 
.mob Savagemane Ravasaurs
.mob Invasive Eggsnatchers
step
.goto 862,67.07,37.11
>>Kill |cRXP_ENEMY_Jabra'kan|r. |cRXP_WARN_Move away from Traps he throws at you and the cone damage from his Volley|r
*|cRXP_WARN_Skip this step if he's not up during an assault|r
.complete 51980,1 
.mob Jabra'kan the Poacher
step
.isQuestComplete 51980
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wingrider Nivek|r
.target Wingrider Nivek
.goto 862,69.02,40.69
.turnin 51980 >>Turn in WANTED: Jabra'kan
.turnin 47312 >>Turn in Queenfeather
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wingrider Nivek|r
.goto 862,69.02,40.69
.abandon 51980 >>Abandon WANTED: Jabra'kan
.turnin 47312 >>Turn in Queenfeather
.target Wingrider Nivek
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Beastlord L'kala|r, |cRXP_FRIENDLY_Trader Alexxi|r, then |cRXP_FRIENDLY_L'kala|r again
.turnin 47311 >>Turn in Headbutting 101
.goto 862,66.81,42.51
.turnin 47272 >>Turn in Direhorn Growth Hormone
.accept 51998 >>Accept DGH: Now With Real Direhorn
.goto 862,66.81,42.58
.accept 51990 >>Accept Wings for the Kraal
.goto 862,66.81,42.51
.target Beastlord L'kala
.target Trader Alexxi
step
#completewith ZuldazarNearlyHatchungEgg
>>Kill |cRXP_ENEMY_Pterrordax Skyrenders|r and |cRXP_ENEMY_Wild Pterrorchicks|r. Loot them for their |cRXP_LOOT_flesh|r
.complete 51998,1 
.mob Pterrordax Skyrender
.mob Wild Pterrorchick
step
#title Egg (1/8)
.goto 862,66.95,34.99
>>Loot the |cRXP_PICK_Egg|r on the ground
.complete 51990,1,1 
step
#title Egg (2/8)
.goto 862,67.05,34.48
>>Loot the |cRXP_PICK_Egg|r on the ground
.complete 51990,1,2 
step
#title Egg (3/8)
.goto 862,67.01,33.89
>>Loot the |cRXP_PICK_Egg|r on the ground
.complete 51990,1,3 
step
#title Egg (5/8)
.goto 862,66.83,34.04
>>Loot the |cRXP_PICK_Egg|r on the ground
.complete 51990,1,5 
step
#title Egg (7/8)
.goto 862,66.71,34.50
>>Loot the |cRXP_PICK_Egg|r on the ground
.complete 51990,1,7 
step
#label ZuldazarNearlyHatchungEgg
#title Egg (8/8)
.goto 862,66.50,34.89
>>Loot the |cRXP_PICK_Egg|r on the ground
.complete 51990,1 
step
.goto 862,66.02,32.86,40,0
.goto 862,67.71,31.93,40,0
.goto 862,66.77,35.52
>>Kill |cRXP_ENEMY_Pterrordax Skyrenders|r and |cRXP_ENEMY_Wild Pterrorchicks|r. Loot them for their |cRXP_LOOT_flesh|r
.complete 51998,1 
.mob Pterrordax Skyrender
.mob Wild Pterrorchick
step
#completwith next
>>Click on |cRXP_FRIENDLY_Ata the Winglord|r
.goto 1165,49.94,43.13
.complete 49488,1 
.target Ata the Winglord
step
.goto 862,62.82,32.56
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zul|r
.turnin 49488 >>Turn in Tal'gurub
.accept 49489 >>Accept Needs a Little Body
.accept 49490 >>Accept The Urn of Voices
.target Zul
step
#completewith ZuldazarVoodooTotemEight
>>Kill the |cRXP_ENEMY_Jambani|r and |cRXP_ENEMY_Masks|r for their souls
.complete 49490,1 
.mob Howling Voodoo Mask
.mob Jambani Spirit Twister
.mob Jambani Crusher
step
.goto 862,63.62,31.76
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Izita's Spirit|r
.accept 49491 >>Accept Fuel for the Voodoo
.target Izita's Spirit
step
#title Totem (1/8)
.goto 862,64.19,32.82
>>Loot the |cRXP_PICK_Totem|r on the ground
.complete 49491,1,1 
step
#title Totem (2/8)
.goto 862,64.72,32.98
>>Loot the |cRXP_PICK_Totem|r on the ground
.complete 49491,1,2 
step
#sticky
#label Totem3
#title Totem (3/8)
.goto 862,64.98,32.91,-1
>>Loot the |cRXP_PICK_Totem|r on the ground
.complete 49491,1,3 
step
#title Concotion 1/2
>>Go inside the building. Click on |cRXP_FRIENDLY_Atal'jamba Ungo|r
.goto 862,65.03,32.98,-1
.complete 49489,1,1 
.target Atal'jamba Ungo
step
#requires Totem3
#completewith next
.goto 862,64.36,33.14,15,0
.goto 862,63.94,32.49,20 >>Go back across the bridge, then turn right as you get onto the stairs
step
#requires Totem3
#title Totem (4/8)
.goto 862,63.91,31.92
>>Loot the |cRXP_PICK_Totem|r on the ground
.complete 49491,1,4 
step
#title Totem (5/8)
.goto 862,63.74,30.83
>>Loot the |cRXP_PICK_Totem|r on the ground
.complete 49491,1,5 
step
#title Totem (6/8)
.goto 862,63.11,30.22
>>Loot the |cRXP_PICK_Totem|r on the ground
.complete 49491,1,6 
step
#title Concotion 2/2
>>Go inside the building. Click on |cRXP_FRIENDLY_Atal'jamba Iri|r
.goto 862,63.07,29.06,12,0
.goto 862,63.20,29.06
.complete 49489,1 
.target Atal'jamba Iri
step
#title Totem (7/8)
.goto 862,62.70,29.09
>>Loot the |cRXP_PICK_Totem|r on the ground
.complete 49491,1,7 
step
#label ZuldazarVoodooTotemEight
#title Totem (8/8)
.goto 862,62.88,28.61
>>Loot the |cRXP_PICK_Totem|r on the ground
.complete 49491,1,8 
step
.goto 862,62.70,29.09,40,0
.goto 862,63.11,30.22,40,0
.goto 862,63.74,30.83,40,0
.goto 862,63.91,31.92,40,0
.goto 862,64.19,32.82,40,0
.goto 862,64.72,32.98
>>Kill the |cRXP_ENEMY_Jambani|r and |cRXP_ENEMY_Masks|r for their souls
.complete 49490,1 
.mob Howling Voodoo Mask
.mob Jambani Spirit Twister
.mob Jambani Crusher
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_PICK_Brazier|r and |cRXP_FRIENDLY_Zul|r
.turnin 49491 >>Turn in Fuel for the Voodoo
.goto 862,62.74,28.43
.turnin 49489 >>Turn in Needs a Little Body
.turnin 49490 >>Turn in The Urn of Voices
.accept 49492 >>Accept Arrogance of Vol'jamba
.goto 862,62.86,28.24
.target Zul
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick the |cRXP_PICK_Masks|r on the wall. Don't worry about their traps
.complete 49492,1 
.goto 862,62.90,28.00
.complete 49492,2 
.goto 862,63.55,28.08
.complete 49492,3 
.goto 862,64.12,28.37
.timer 20,Zul RP
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tWait for |cRXP_FRIENDLY_Zul|r to walk up the stairs and talk to him
.goto 862,64.38,28.55
.turnin 49492 >>Turn in Arrogance of Vol'jamba
.accept 49493 >>Accept Zul's Ethical Dilemma
.accept 49494 >>Accept Zuvembi Brew
.target Zul
step
#completewith ZuldazarJambaniStockpiles
>>Use the |T237388:0|t[Mindbreaker Chant] while standing in melee range of |cRXP_ENEMY_Mindslaved Berserkers|r and |cRXP_ENEMY_Mindslaved Gurubashi|r. Try to free multiple in one cast
.use 155458
.complete 49493,1 
.mob Mindslaved Berserker
.mob Mindslaved Gurubashi
step
.goto 862,64.88,27.00
>>Kill |cRXP_ENEMY_Zuvembi Brewer Zekal|r
.complete 49494,1 
.mob Zuvembi Brewer Zekal
step
#title Stockpile destroyed (1/8)
.goto 862,65.29,28.19
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Jambani Stockpile|r, then click it again to burn it
.accept 51663 >>Accept Preparing for the Fall
.complete 51663,1,1 
step
#title Stockpile destroyed (2/8)
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick the |cRXP_PICK_Jambani Stockpile|r to burn it
.goto 862,65.39,27.86
.complete 51663,1,2 
step
#title Stockpile destroyed (3/8)
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick the |cRXP_PICK_Jambani Stockpile|r to burn it
.goto 862,65.00,28.34
.complete 51663,1,3 
step
#title Stockpile destroyed (4/8)
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick the |cRXP_PICK_Jambani Stockpile|r to burn it
.goto 862,64.92,28.36
.complete 51663,1,4 
step
#title Stockpile destroyed (5/8)
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick the |cRXP_PICK_Jambani Stockpile|r to burn it
.goto 862,64.66,28.64
.complete 51663,1,5 
step
#title Stockpile destroyed (6/8)
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick the |cRXP_PICK_Jambani Stockpile|r to burn it
.goto 862,64.61,29.82
.complete 51663,1,6 
step
#title Stockpile destroyed (7/8)
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick the |cRXP_PICK_Jambani Stockpile|r to burn it
.goto 862,65.02,29.62
.complete 51663,1,7 
step
#label ZuldazarJambaniStockpiles
#title Stockpile destroyed (8/8)
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick the |cRXP_PICK_Jambani Stockpile|r to burn it
.goto 862,65.59,29.14
.complete 51663,1 
step
>>Use the |T237388:0|t[Mindbreaker Chant] while standing in melee range of |cRXP_ENEMY_Mindslaved Berserkers|r and |cRXP_ENEMY_Mindslaved Gurubashi|r. Try to free multiple in one cast
.use 155458
.goto 862,66.35,29.55,30,0
.goto 862,66.47,28.56,30,0
.goto 862,66.07,28.57,30,0
.goto 862,64.66,28.64,30,0
.goto 862,64.61,29.82
.complete 49493,1 
.mob Mindslaved Berserker
.mob Mindslaved Gurubashi
step
#completewith next
.goto 862,65.71,30.21,40 >>Climb the stairs
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zul|r
.goto 862,65.71,30.21
.turnin 49493 >>Turn in Zul's Ethical Dilemma
.turnin 49494 >>Turn in Zuvembi Brew
.turnin 51663 >>Turn in Preparing for the Fall
.accept 49495 >>Accept Enforcing Fate
.target Zul
step
.isOnQuest 49495
>>|cRXP_WARN_Make sure to accept the quest with two free bag slots. If you see this message then free up some bag space, abandon the quest and reaccept it|r
.collect 160523,1,49495,1
.collect 160524,1,49495,1
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick on the |cRXP_PICK_Gong of Command|r
.goto 862,65.89,31.09
.complete 49495,1 
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick on the |cRXP_PICK_shade of the urn|r
.goto 862,65.89,30.67
.complete 49495,2 
.timer 6,Urn of Voices RP
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick on the |cRXP_PICK_shade of the urn|r again when it appears
.goto 862,65.86,30.65
.complete 49495,3 
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick on the |cRXP_PICK_potion|r on the table
.goto 862,65.56,31.30
.complete 49495,4 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zul|r
.goto 862,65.71,30.21
.turnin 49495 >>Turn in Enforcing Fate
.accept 49905 >>Accept Plot Twist
.timer 30,Plot Twist RP
.target Zul
step
>>Wait for the RP. Attack |cRXP_ENEMY_Vol'jamba|r
.goto 862,65.68,31.03
.complete 49905,1 
.mob Vol'jamba
step
.goto 862,65.68,31.03
>>Kill |cRXP_ENEMY_Vol'Jamba|r
.complete 49905,2 
.mob Vol'jamba
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zul|r
.goto 862,65.58,30.51
.turnin 49905 >>Turn in Plot Twist
.accept 49663 >>Accept False Prophecies
.target Zul
step
#completewith HuntKing
.cooldown item,132516,>0,1
.cast 202844 >>Use your |T1405809:0|t[Gunshoes] to move faster
.use 132516
.itemcount 132516,1
step
#completewith next
.goto 862,66.99,29.79,30 >> Run down this part of the cliff
step
#label HuntKing
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_PICK_Hunter's Board|r, |cRXP_FRIENDLY_Hemet Nesingwary|r, |cRXP_FRIENDLY_Erak|r, and |cRXP_FRIENDLY_Tracker Burke|r
.accept 47706 >>Accept Hunt for King K'tal
.goto 862,67.44,17.90
.accept 50466 >>Accept He's Gone Mad!
.goto 862,67.50,17.70
.accept 47584 >>Accept A Thorn in the Side
.goto 862,67.45,17.72
.accept 47583 >>Accept Die, Die, Diemetradon
.goto 862,67.56,17.73
.target Hemet Nesingwary
.target Erak
.target Tracker Burke
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the dead |cRXP_FRIENDLY_Trapper|r on the ground
.goto 862,68.85,19.44,0,0
.accept 47585 >>Accept Predatory
.target Trapper Custer
step
#completewith ZuldazarWildtusk
>>Kill |cRXP_ENEMY_Vemomous Diemetradons|r and |cRXP_ENEMY_Ankylodons|r
.goto 862,70.84,20.31,40,0
.complete 47583,1 
.complete 47584,1 
.mob Venomous Diemetradons
.mob Ankylodons
step
#completewith next
.line 862,71.69,20.36,71.40,20.93,71.33,21.89,71.50,22.41,70.84,22.62,70.14,22.88,68.99,22.64,68.26,21.95,67.98,22.04,67.93,22.32,68.10,22.90,68.25,22.74,68.42,23.03,69.76,22.59,70.84,22.62
>>Kill |cRXP_ENEMY_King K'tal|r. Loot him for his |cRXP_LOOT_skull|r. Find a group for him if needed. Skip this step if you're unable to find a group or solo him.
.complete 47706,1 
.isOnQuest 47706
.mob King K'tal
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ranger Paalu|r on the ground
.goto 862,70.63,22.09
.complete 47585,1 
.target Ranger Paalu
step << Hunter
#completewith next
+Recommendation: Tame a Ankylodon (Dismiss Pet -> Tame Beast)
*Ferocity pets are far more durable.
*Ignore this step if you aready have a Ferocity pet or want to keep using your current one.
step
#label ZuldazarWildtusk
.goto 862,70.94,26.26
>>Kill the |cRXP_ENEMY_Wildtusk|r
.complete 50466,1 
.mob Wildtusk
step
#completewith next
>>Kill |cRXP_ENEMY_Venomous Diemetradons|r
.complete 47583,1 
.mob Venomous Diemetradons
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marksman Julyen|r on the ground
.goto 862,67.81,25.03
.complete 47585,2 
.target Marksman Julyen
step
#loop
.goto 862,68.00,26.14,40,0
.goto 862,68.86,25.70,40,0
.goto 862,68.80,25.22,40,0
.goto 862,68.41,25.03,40,0
.goto 862,68.56,24.19,40,0
.goto 862,67.78,24.33,40,0
.goto 862,67.41,24.86,40,0
.goto 862,68.00,26.14,40,0
>>Kill |cRXP_ENEMY_Venomous Diemetradons|r
.complete 47583,1 
.mob Venomous Diemetradons
step
#completewith next
.line 862,71.69,20.36,71.40,20.93,71.33,21.89,71.50,22.41,70.84,22.62,70.14,22.88,68.99,22.64,68.26,21.95,67.98,22.04,67.93,22.32,68.10,22.90,68.25,22.74,68.42,23.03,69.76,22.59,70.84,22.62
>>Kill |cRXP_ENEMY_King K'tal|r. Loot him for his |cRXP_LOOT_skull|r. Find a group for him if needed. Skip this step if you're unable to find a group or solo him.
.complete 47706,1 
.isOnQuest 47706
.mob King K'tal
step
#loop
.goto 862,67.81,22.89,45,0
.goto 862,68.74,21.43,45,0
.goto 862,68.63,20.44,45,0
.goto 862,67.66,20.12,45,0
.goto 862,68.26,18.54,45,0
.goto 862,69.11,18.71,45,0
>>Kill |cRXP_ENEMY_Ankylodons|r
.complete 47584,1 
.mob Ankylodon
step
#completewith ZuldazarNesingwarysTrekTurnins
#loop
.goto 862,67.81,23.37,40,0
.goto 862,71.39,21.48,40,0
.goto 862,67.81,23.37,40,0
>>Kill |cRXP_ENEMY_King K'tal|r. Loot him for his |cRXP_LOOT_skull|r. Find a group for him if needed. Skip this step if you're unable to find a group or solo him.
.complete 47706,1 
.isOnQuest 47706
.mob King K'tal
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_PICK_Tracker Burke's Hat|r, |cRXP_FRIENDLY_Erak|r, and |cRXP_FRIENDLY_Huntmaster Vol'ka|r
.turnin 47583 >>Turn in Die, Die, Diemetradon
.goto 862,67.50,18.89
.turnin 47584 >>Turn in A Thorn in the Side
.goto 862,68.01,18.03
.turnin 47585 >>Turn in Predatory
.turnin 47706 >>Turn in Hunt for King K'tal
.turnin 50466 >>Turn in He's Gone Mad!
.accept 47586 >>Accept Hunting the Hunter
.goto 862,67.50,17.62
.isQuestComplete 47706
.target Erak
.target Huntmaster Vol'ka
step
#label ZuldazarNesingwarysTrekTurnins
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tReturn to Nesingwary's Trek. Talk to |cRXP_PICK_Tracker Burke's Hat|r, |cRXP_FRIENDLY_Erak|r, and |cRXP_FRIENDLY_Huntmaster Vol'ka|r
.turnin 47583 >>Turn in Die, Die, Diemetradon
.goto 862,67.50,18.89
.turnin 47584 >>Turn in A Thorn in the Side
.goto 862,68.01,18.03
.turnin 50466 >>Turn in He's Gone Mad!
.turnin 47585 >>Turn in Predatory
.accept 47586 >>Accept Hunting the Hunter
.goto 862,67.50,17.62
.target Erak
.target Huntmaster Vol'ka
step
.abandon 47706 >> Abandon Hunt for King K'tal
step
#completewith ZuldazarFollowNesingwary
>>Kill |cRXP_ENEMY_Feathered Vipers|r, their |cRXP_ENEMY_Eggs|r, and |cRXP_ENEMY_Wild Sabertusks|r
.complete 50178,1 
.mob Feathered Viper
.mob Feathered Viper Egg
.mob Wild Sabertusk
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick on |cRXP_PICK_Nesingwary's Campfire|r on the ground
.goto 862,62.45,19.26
.complete 47586,1 
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick on the |cRXP_PICK_Dwarf Trap|r on the ground
.goto 862,61.48,17.95
.complete 47586,2 
step
#label ZuldazarFollowNesingwary
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick on the |cRXP_PICK_Nesingwary's Rifle|r on the ground
.goto 862,62.32,16.87
.complete 47586,3 
step
>>Kill |cRXP_ENEMY_Feathered Vipers|r, their |cRXP_ENEMY_Eggs|r, and |cRXP_ENEMY_Wild Sabertusks|r
.goto 862,62.76,17.45,40,0
.goto 862,62.88,17.04,40,0
.goto 862,64.01,19.36,40,0
.goto 862,64.14,17.29,40,0
.goto 862,65.83,17.90,40,0
.goto 862,65.17,20.05,40,0
.goto 862,62.76,17.45
.complete 50178,1 
.mob Feathered Viper
.mob Feathered Viper Egg
.mob Wild Sabertusk
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hemet Nesingwary|r inside the building
.goto 862,63.49,16.15
.turnin 47586 >>Turn in Hunting the Hunter
.accept 47587 >>Accept Headhunter Jo
.target Hemet Nesingwary
step
.goto 862,62.96,15.81
>>Kill |cRXP_ENEMY_Headhunter Jo|r outside
.complete 47587,1 
.mob Headhunter Jo
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hemet Nesingwary|r
.goto 862,63.49,16.15
.turnin 47587 >>Turn in Headhunter Jo
.target Hemet Nesingwary
step
#completewith next
.hs >>Hearth to Warbeast Kraal
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tReturn to the Warbeast Kraal. Talk to |cRXP_FRIENDLY_Beastlord L'kala|r and |cRXP_FRIENDLY_Trader Alexxi|r
.turnin 51990 >>Turn in Wings for the Kraal
.goto 862,66.81,42.51
.turnin 51998 >>Turn in DGH: Now With Real Direhorn
.goto 862,66.81,42.58
.target Beastlord L'kala
.target Trader Alexxi
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_King Rastakhan|r, |cRXP_FRIENDLY_Zolani|r, and |cRXP_FRIENDLY_Yazma|r
.turnin 49663 >>Turn in False Prophecies
.goto 1165,49.93,46.62
.accept 50835 >>Accept The Port of Zandalar
.goto 1165,49.82,46.55
.accept 47445 >>Accept The Zanchuli Council
.goto 1165,49.73,46.51
.target King Rastakhan
.target Zolani
.target Yazma
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wardruid Loti|r
.goto 1165,45.26,24.02
.turnin 47445 >>Turn in The Zanchuli Council
.accept 47423 >>Accept Forbidden Practices
.target Wardruid Loti
step
.use 152627
.goto 1165,47.30,21.67,30,0
.goto 1165,48.09,20.82,30,0
.goto 1165,48.92,18.10,30,0
.goto 1165,49.84,17.92,30,0
.goto 1165,50.31,15.00,30,0
.goto 1165,50.40,13.00,30,0
.goto 1165,50.65,10.74,30,0
.goto 1165,51.65,10.35,30,0
.goto 1165,47.30,21.67
>>Use |T136008:0|t[Loti's Totem] near |cRXP_ENEMY_Zanchuli Acolytes|r to reveal them
.complete 47423,1 
.use 152627
.target Zanchuli Acolyte
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hexlord Raal|r
.goto 1165,51.90,11.89
.turnin 47423 >>Turn in Forbidden Practices
.accept 47433 >>Accept Offensively Defensive
.target Hexlord Raal
step
>>Mount |cRXP_FRIENDLY_Ata the Windlord|r
.goto 1165,53.20,11.63
.complete 47433,2 
.target Ata the Windlord
step
>>Use the |T136232:0|t[Farseer Totems] (1) on the glowing circles. Make sure to zoom out and look around
*The first one is directly below the starting position
.complete 47433,3 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wardruid Loti|r
.goto 1165,46.21,19.25
.turnin 47433 >>Turn in Offensively Defensive
.accept 47435 >>Accept Pterrortorial Dispute
.accept 47434 >>Accept Restraining Order
.target Wardruid Loti
step
.goto 1165,42.88,19.90,30,0
.goto 1165,41.91,16.04,30,0
.goto 1165,40.91,15.02,30,0
.goto 1165,38.59,15.73,30,0
.goto 1165,38.35,10.85,30,0
.goto 1165,39.42,14.08,30,0
.goto 1165,42.88,19.90
>>Run through |cRXP_FRIENDLY_Hatchlings|r to shoo them. Kill |cRXP_ENEMY_Bloodraged Pterrordax|r
.complete 47434,1 
.complete 47435,1 
.mob Bloodraged Pterrordax
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hexlord Raal|r
.goto 1165,40.92,11.33
.turnin 47435 >>Turn in Pterrortorial Dispute
.turnin 47434 >>Turn in Restraining Order
.accept 47437 >>Accept Competitive Devotion
.target Hexlord Raal
step
>>Kill the |cRXP_ENEMY_Guardian of the Tombs|r
.goto 1167,65.69,69.07
.complete 47437,1 
.mob Guardian of the Tombs
step
>>Kill the |cRXP_ENEMY_Guardian of the Rites|r
.goto 1167,36.67,25.67,15,0
.goto 1167,44.14,15.47,15,0
.goto 1166,65.91,30.73
.complete 47437,2 
.mob Guardian of the Rites
step
>>Kill the |cRXP_ENEMY_Guardian of the Dead|r
.goto 1166,66.62,69.40,15,0
.goto 1166,78.58,86.53,15,0
.goto 1165,44.29,16.71
.complete 47437,3 
.mob Guardian of the Dead
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wardruid Loti|r
.goto 1165,46.11,13.07
.turnin 47437 >>Turn in Competitive Devotion
.accept 47422 >>Accept Dire Situation
.target Wardruid Loti
step
>>Kill |cRXP_ENEMY_Dregada|r. Dodge the leap. Run through the totems at the edges to pick up buffs.
.goto 1165,43.64,7.39
.complete 47422,1 
.mob Dregada
step
.isQuestAvailable 47438
#completewith next
+|cRXP_WARN_Please follow the waypoint and the instructions perfectly and choose the Pterrodax not the Raptor on the next quest. Disable other Addons that automatically turn in quests.|r
step
.isQuestAvailable 47438
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wardruid Loti|r
.turnin 47422 >>Turn in Dire Situation
.accept 47438 >>Accept Picking a Side
.goto 1165,42.30,9.10
.target Wardruid Loti
step
.isQuestAvailable 47438
#completewith next
+|cRXP_WARN_Please follow the waypoint and the instructions perfectly and choose the Pterrodax not the Raptor on the next quest. Disable other Addons that automatically turn in quests.|r
step
.isQuestAvailable 47438
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick on |cRXP_FRIENDLY_Pa'ku|r to choose her
.complete 47438,1 
.goto 1165,42.61,9.21
.target Pa'ku
step
.isQuestTurnedIn 47443
>>You've chosen the wrong loa, reaccept the quest and pick the pterrodax. If you've already accidently turned in the quest the skip this step.
.abandon 47438
step
.isQuestAvailable 47438
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wardruid Loti|r
.accept 47438 >>Accept Picking a Side
.goto 1165,42.30,9.10
.target Wardruid Loti
step
.isQuestAvailable 47438
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick on |cRXP_FRIENDLY_Pa'ku|r to choose her
.complete 47438,1 
.goto 1165,42.61,9.21
.target Pa'ku
step
.isQuestTurnedIn 47436
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wardruid Loti|r
.turnin 47438 >>Turn in Picking a Side
.goto 1165,42.30,9.10
.target Wardruid Loti
step
.isQuestTurnedIn 47436
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hexlord Raal|r
.accept 47440 >>Accept Pa'ku, Master of Winds
.goto 1165,42.54,9.49
.target Hexlord Raal
step
.isQuestTurnedIn 47443
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wardruid Loti|r
.goto 1165,42.30,9.10
.accept 47439 >>Accept Gonk, Lord of the Pack
.target Wardruid Loti
step
.isQuestTurnedIn 47443
#completewith next
.goto 1165,42.27,9.47,1 >>Run through the |cRXP_PICK_Totem of Gonk|r to gain his buff. The buff reduces your falling damage and increases your movement speed
.goto 1165,40.51,9.40,15,0
.goto 1165,37.95,11.25,20,0
.goto 1165,36.28,7.99,25 >>Jump down
step
.isQuestTurnedIn 47443
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gonk|r
.goto 862,48.18,32.27
.skipgossip
.complete 47439,1 
.target Gonk
step
.isQuestTurnedIn 47443
#completewith next
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Paku'ai Rip'nata|r
.goto 862,48.05,28.70,20,0
.goto 862,48.56,26.87,20,0
.goto 862,49.72,26.27
.fly The Great Seal >>Fly to The Great Seal
.target Paku'ai Rip'nata
step
.isQuestTurnedIn 47443
#completewith next
.goto 1165,50.49,40.70,10 >>Run through the |cRXP_PICK_Totem of Gonk|r to get his buff
step
.isQuestTurnedIn 47443
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tJump down and talk to |cRXP_FRIENDLY_Wardruid Loti|r
.goto 1165,49.92,33.42
.turnin 47439 >>Turn in Gonk, Lord of the Pack
.accept 48897 >>Accept The Bargain is Struck
.target Wardruid Loti
step
.isQuestTurnedIn 47443
#completewith Hatchling
.cast 6478 >>Click the |cRXP_PICK_Altar of Gonk|r to gain a passive damage buff
.goto 1165,49.92,33.10
step
.isOnQuest 47440
>>Mount |cRXP_FRIENDLY_Ata the Winglord|r
.goto 1165,42.51,10.05
.complete 47440,1 
.target Ata the Winglord
step
.isQuestTurnedIn 47436
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Pa'ku|r
.goto 862,71.52,49.40
.complete 47440,2 
.target Pa'ku
step
.isQuestTurnedIn 47436
#completewith next
+If you wish to save time, open up the Battle Net client on your computer
step
.isQuestTurnedIn 47436
.goto 862,71.78,49.24,12,0
.goto 862,72.1,49.5
.complete 47440,3 
.timer 52,Flight Duration
step
.isQuestTurnedIn 47436
#completewith next
+Press "Play" on the Battle Net client to open a second WoW client. Do NOT close your first client. Log in on your second client, wait until you can move, then close your first client
step
.isQuestTurnedIn 47436
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hexlord Raal|r
.goto 1165,49.92,33.41
.turnin 47440 >>Turn in Pa'ku, Master of Winds
.accept 47432 >>Accept The Bargain is Struck
.target Hexlord Raal
step
.isQuestTurnedIn 47436
#completewith next
.cast 6478 >>Click on the |cRXP_PICK_Altar of Pa'ku|r to gain a movement speed buff
.goto 1165,49.92,33.10
step
.isQuestTurnedIn 47436
#label TotemPaku1
#completewith Hatchling2
.goto 1165,58.30,32.63
.vehicle 131154 >>Click on the |cRXP_PICK_Totem of Pa'ku|r
.timer 11,Pa'ku Flight
.itemcount 109076,<1
.target Totem of Pa'ku
step
#label ZuldazarPortofZuldazar
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zolani|r and |cRXP_FRIENDLY_Yazma|r
.turnin 50835 >>Turn in The Port of Zandalar
.accept 46926 >>Accept Shakedown
.goto 1165,50.06,85.07
.accept 46846 >>Accept The Word of Zul
.goto 1165,50.05,84.76
.target Zolani
.target Yazma
step
#completewith ZuldazarDocksideThugs
.goto 1165,47.83,87.31,0
>>Kill |cRXP_ENEMY_Gurubashi|r, |cRXP_ENEMY_Amani|r, and |cRXP_ENEMY_Sandfury Thugs|r
.complete 46926,1 
.mob Gurubashi Thug
.mob Amani Thug
.mob Sandfury Thug
step
.goto 1165,51.52,91.03
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nokali|r. |cRXP_WARN_Do NOT go downstairs.|r
.skipgossip
.complete 46846,1 
.target Nokali
step
#completewith next
.goto 1165,53.48,90.62,20 >> Jump down through the gap in the wall
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Volkini|r
.goto 1165,53.89,91.20
.skipgossip
.complete 46846,2 
.target Volkini
step
#completewith next
.goto 1165,56.03,89.72,20 >> Go under the overhang
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Scrollsage Rooka|r
.goto 1165,55.95,88.83
.accept 48404 >>Accept The Scamps
.target Scrollsage Rooka
step
#completewith next
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_FRIENDLY_Street Scamps|r. |cRXP_WARN_Be careful as they vanish after a few seconds|r
*You can find some at the waypoint marks on your minimap but they run around everywhere. If you don't finish this now, we will finish it later.
.goto 1165,51.65,93.32,0
.goto 1165,49.19,89.77,0
.goto 1165,52.30,82.86,0
.goto 1165,48.74,89.43,0
.goto 1165,49.19,89.77,10,0
.complete 48404,1 
.target Street Scamp
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dockmaster Cobo|r
.goto 1165,45.31,79.78
.skipgossip
.complete 46846,3 
.target Dockmaster Cobo
step
#label ZuldazarDocksideThugs
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Witch Doctor Jala|r
.goto 1165,44.25,82.15
.accept 48452 >>Accept The Red Market
.target Witch Doctor Jala
step
#completewith next
>>Kill |cRXP_ENEMY_Crimson Cultists|r. Loot them for their |cRXP_LOOT_Dark Fetishes|r
.complete 48452,1 
.mob Crimson Cultist
step
>>|cRXP_WARN_Make sure to jump down while mounted otherwise your pet will pull everything|r << Hunter/Warlock
>>|TInterface/GossipFrame/HealerGossipIcon:0|tJump down below, then go inside the building. Click the |cRXP_PICK_Chalice of Calling|r
.goto 1165,42.76,83.64,12,0
.goto 1165,43.13,83.07
.complete 48452,2 
step
#loop
.goto 1165,41.82,82.83,30,0
.goto 1165,41.67,77.10,30,0
.goto 1165,43.13,83.07,30,0
>>Kill |cRXP_ENEMY_Crimson Cultists|r. Loot them for their |cRXP_LOOT_Dark Fetishes|r
.complete 48452,1 
.mob Crimson Cultist
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Witch Doctor Jala|r
.goto 1165,44.25,82.15
.turnin 48452 >>Turn in The Red Market
.accept 48454 >>Accept Evidence of Evil
.target Witch Doctor Jala
step
#completewith next
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_FRIENDLY_Street Scamps|r. |cRXP_WARN_Be careful as they vanish after a few seconds|r
*You can find some at the waypoint marks on your minimap but they run around everywhere
.goto 1165,51.65,93.32,0
.goto 1165,49.19,89.77,0
.goto 1165,52.30,82.86,0
.goto 1165,48.74,89.43,0
.complete 48404,1 
.target Street Scamp
step
.goto 1165,45.31,80.04,30,0
.goto 1165,47.52,87.26,30,0
.goto 1165,46.97,89.89,30,0
.goto 1165,48.45,83.77,30,0
.goto 1165,45.31,80.04
>>Kill |cRXP_ENEMY_Gurubashi|r, |cRXP_ENEMY_Amani|r, and |cRXP_ENEMY_Sandfury Thugs|r
.complete 46926,1 
.mob Gurubashi Thug
.mob Amani Thug
.mob Sandfury Thug
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zolani|r and |cRXP_FRIENDLY_Yazma|r
.turnin 46926 >>Turn in Shakedown
.turnin 48454 >>Turn in Evidence of Evil
.accept 46929 >>Accept Deterrent
.goto 1165,50.06,85.07
.turnin 46846 >>Turn in The Word of Zul
.accept 46927 >>Accept Punishment of Tal'aman
.accept 46928 >>Accept Punishment of Tal'farrak
.goto 1165,50.05,84.76
.target Zolani
.target Yazma
step
#completewith Gong
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_FRIENDLY_Street Scamps|r. |cRXP_WARN_Be careful as they vanish after a few seconds|r
*You can find some at the waypoint marks on your minimap but they run around everywhere
.goto 1165,51.65,93.32,0
.goto 1165,49.19,89.77,0
.goto 1165,52.30,82.86,0
.goto 1165,48.74,89.43,0
.goto 1165,52.08,83.02,15,0
.goto 1165,50.02,89.97,0,0
.complete 48404,1 
.target Street Scamp
step
#completewith GahzRagon
.goto 1165,48.39,77.83,40,0
>>Kill |cRXP_ENEMY_Sandfury Trolls|r. Loot them for their |cRXP_LOOT_heads|r
.complete 46929,2 
.mob Sandfury Axe Thrower
.mob Sandfury Axe Dunerider
.mob Sandfury Axe Speaker
step
#label Gong
#completewith next
.goto 1165,46.61,73.87
.cast 3365 >>Click the Ancient Gong to summon Gahz'ragon
step
#label GahzRagon
.goto 1165,46.63,72.61
>>Kill |cRXP_ENEMY_Gahz'ragon|r. Loot him for his |cRXP_LOOT_tongues|r
.complete 46928,1 
.mob Gahz'ragon
step
.goto 1165,46.61,70.64,40,0
.goto 1165,47.71,72.37,40,0
.goto 1165,45.82,77.73,40,0
.goto 1165,48.39,77.83
>>Kill |cRXP_ENEMY_Sandfury Trolls|r. Loot them for their |cRXP_LOOT_heads|r
.complete 46929,2 
.mob Sandfury Axe Thrower
.mob Sandfury Axe Dunerider
.mob Sandfury Axe Speaker
step
#completewith next
.cooldown item,132516,>0,1
.cast 202844 >>Use your |T1405809:0|t[Gunshoes] to move faster
.use 132516
.itemcount 132516,1
step
.goto 1165,51.74,77.65,40,0
.goto 1165,54.22,79.81,40,0
.goto 1165,57.31,80.80
>>Kill |cRXP_ENEMY_Amani Trolls|r. Loot them for their |cRXP_LOOT_heads|r
.complete 46929,1 
.mob Amani Warrior
step
#completewith next
.goto 1165,56.19,87.53
.cast 3365 >>Click the |cRXP_PICK_Ancient Gong|r to summon an |cRXP_ENEMY_Amani Disciple|r
step
>>Kill the |cRXP_ENEMY_Amani Disciples|r
*|cRXP_WARN_Don't use the gong too fast. Sometimes it can bug and you have to wait for around 2 minutes until you can interact with the gong again|r
.goto 1165,56.04,86.88
.complete 46927,1,1 
.mob Disciple of Akil'zon
.mob Disciple of Nalorakk
.mob Disciple of Jan'alai
.mob Disciple of Halazzi
step
#completewith next
.goto 1165,56.19,87.53
.cast 3365 >>Click the |cRXP_PICK_Ancient Gong|r to summon an |cRXP_ENEMY_Amani Disciple|r
step
>>Kill the |cRXP_ENEMY_Amani Disciples|r
*|cRXP_WARN_Don't use the gong too fast. Sometimes it can bug and you have to wait for around 2 minutes until you can interact with the gong again|r
.goto 1165,56.04,86.88
.complete 46927,1,2 
.mob Disciple of Akil'zon
.mob Disciple of Nalorakk
.mob Disciple of Jan'alai
.mob Disciple of Halazzi
step
#completewith next
.goto 1165,56.19,87.53
.cast 3365 >>Click the |cRXP_PICK_Ancient Gong|r to summon an |cRXP_ENEMY_Amani Disciple|r
step
>>Kill the |cRXP_ENEMY_Amani Disciples|r
*|cRXP_WARN_Don't use the gong too fast. Sometimes it can bug and you have to wait for around 2 minutes until you can interact with the gong again|r
.goto 1165,56.04,86.88
.complete 46927,1,3 
.mob Disciple of Akil'zon
.mob Disciple of Nalorakk
.mob Disciple of Jan'alai
.mob Disciple of Halazzi
step
#completewith next
.goto 1165,56.19,87.53
.cast 3365 >>Click the |cRXP_PICK_Ancient Gong|r to summon an |cRXP_ENEMY_Amani Disciple|r
step
>>Kill the |cRXP_ENEMY_Amani Disciples|r
*|cRXP_WARN_Don't use the gong too fast. Sometimes it can bug and you have to wait for around 2 minutes until you can interact with the gong again|r
.goto 1165,56.04,86.88
.complete 46927,1 
.mob Disciple of Akil'zon
.mob Disciple of Nalorakk
.mob Disciple of Jan'alai
.mob Disciple of Halazzi
step
#completewith Rooka
.goto 1165,54.41,87.92,25 >> Jump down by taking the shortcut here
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_FRIENDLY_Street Scamps|r. |cRXP_WARN_Be careful as they vanish after a few seconds|r
.goto 1165,51.65,93.32,30,0
.goto 1165,49.19,89.77,30,0
.goto 1165,52.30,82.86,30,0
.goto 1165,48.74,89.43,30,0
.goto 1165,51.65,93.32,30,0
.goto 1165,49.19,89.77,30,0
.goto 1165,52.30,82.86,30,0
.goto 1165,48.74,89.43
.complete 48404,1 
.target Street Scamp
step
#label Rooka
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Scrollsage Rooka|r
.goto 1165,56.25,89.70,15,0
.goto 1165,55.95,88.83
.turnin 48404 >>Turn in The Scamps
.accept 48405 >>Accept Mista Nice
.target Scrollsage Rooka
step
>>|cRXP_WARN_Mount up and follow the arrow. Don't talk to anyone|r
.goto 1165,59.06,90.73,12,0
.goto 1165,59.11,88.71,12,0
.goto 1165,57.21,87.77
.complete 48405,1 
step
.goto 1165,57.20,87.39
>>Kill |cRXP_ENEMY_Mista Nice|r. |cRXP_WARN_Move out of the Voodoo Totem he places|r
.complete 48405,2 
.mob Mista Nice
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tJump down again. Talk to |cRXP_FRIENDLY_Scrollsage Rooka|r
.goto 1165,55.95,88.83
.turnin 48405 >>Turn in Mista Nice
.target Scrollsage Rooka
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Koba|r and |cRXP_FRIENDLY_Batu|r
.accept 49285 >>Accept Tiny Treasures
.goto 862,70.27,65.02,0,0
.accept 49284 >>Accept Perfect Tidings
.goto 862,70.28,64.95,0,0
.target Koba
.target Batu
step
#completewith ClueThree
>>Kill |cRXP_ENEMY_Murlocs|r and run on top of |cRXP_FRIENDLY_Tadpoles|r to scare them
.complete 49315,1 
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tSearch the |cRXP_PICK_Bag|r under the tree
.goto 862,71.19,64.58
.complete 49284,1 
step
>>Loot the |cRXP_PICK_cage|r
.goto 862,71.66,64.15
.complete 49285,1 
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tSearch the |cRXP_PICK_Scroll|r against the tree
.goto 862,72.65,63.05
.complete 49284,2 
step
>>Loot |cRXP_PICK_Spitzy|r on the ground
.goto 862,73.10,64.81
.complete 49285,3 
step
>>Loot the |cRXP_PICK_Alchemist Stone|r floating above the water
.goto 862,73.19,67.22
.complete 49285,2 
step
#completewith next
.cooldown item,132516,>0,1
.cast 202844 >>Use your |T1405809:0|t[Gunshoes] to move faster
.use 132516
.itemcount 132516,1
step
#label ClueThree
>>|TInterface/GossipFrame/HealerGossipIcon:0|tSearch the |cRXP_PICK_Scroll Case|r
.goto 862,74.02,62.08
.complete 49284,3 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Choa|r and |cRXP_FRIENDLY_Deyon|r
.goto 862,73.68,60.99
.turnin 49285 >>Turn in Tiny Treasures
.turnin 49284 >>Turn in Perfect Tidings
.accept 49286 >>Accept Caged Wisdom
.target Choa
.target Deyon
step
>>Go inside the cave. Kill |cRXP_ENEMY_Sil'thrus|r. Loot him for his |cRXP_LOOT_key|r
.goto 862,73.66,60.49,20,0
.goto 862,74.60,59.34
.complete 49286,1 
.mob Sil'thrus
step
.goto 862,73.68,60.99
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick the |cRXP_PICK_cage|r, then talk to |cRXP_FRIENDLY_Deyon|r
.complete 49286,2 
.turnin 49286 >>Turn in Caged Wisdom
.accept 49287 >>Accept Lost Chelonians
.accept 49288 >>Accept Scrollhunters
.target Deyon
step
#completewith ZuldazarLostChelonians
>>Kill |cRXP_ENEMY_Murlocs|r and |cRXP_ENEMY_Nagas|r. Run on top of |cRXP_FRIENDLY_Tadpoles|r to scare them
.complete 49315,1 
step
#sticky
#completewith ZuldazarLostChelonians
>>Kill |cRXP_ENEMY_Nazeshi Tempest-Wielders|r. Loot them for their |cRXP_LOOT_scrolls|r
.complete 49288,1 
.mob Nazeshi Tempest-Wielder
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick the |cRXP_PICK_cages|r to free |cRXP_FRIENDLY_Kono|r
.goto 862,73.90,65.85
.complete 49287,1 
.target Kono
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick the |cRXP_PICK_cages|r to free |cRXP_FRIENDLY_Rauloo|r
.goto 862,75.13,66.55
.complete 49287,2 
.target Rauloo
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick the |cRXP_PICK_cages|r to free |cRXP_FRIENDLY_Akru|r
.goto 862,77.05,66.48
.complete 49287,3 
.target Akru
step
#label ZuldazarLostChelonians
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick the |cRXP_PICK_cages|r to free |cRXP_FRIENDLY_Crosh|r
*|cRXP_WARN_DO NOT PULL Tidecaller Nezara, she is level 60|r
.goto 862,77.29,64.36
.complete 49287,4 
.target Crosh
step
#label ShallowsTI
>>Kill |cRXP_ENEMY_Murlocs|r and |cRXP_ENEMY_Nagas|r. Run on top of |cRXP_FRIENDLY_Tadpoles|r to scare them
.goto 862,74.67,65.85
.complete 49315,1 
step
>>Kill |cRXP_ENEMY_Nazeshi Tempest-Wielders|r. Loot them for their |cRXP_LOOT_scrolls|r
.goto 862,76.66,65.67,25,0
.goto 862,76.66,64.88,25,0
.goto 862,77.29,64.36
.complete 49288,1 
.mob Nazeshi Tempest-Wielder
step
#requires ShallowsTI
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Deyon|r
.goto 862,75.22,61.49
.turnin 49287 >>Turn in Lost Chelonians
.turnin 49288 >>Turn in Scrollhunters
.accept 49289 >>Accept A Special Stone
.target Deyon
step
>>Loot the |cRXP_PICK_Stone Fragment|r in the middle of the lake
>>Kill |cRXP_ENEMY_Tidemistress Nazesh|r. Loot her for her |cRXP_LOOT_orders|r
*You can use the Scroll of Storm Control for an extra ability
.goto 862,76.67,61.42
.use 157539
.complete 49289,2 
.complete 49289,1 
.mob Tidemistress Nazesh
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Deyon|r. Wait out the RP event
.goto 862,75.22,61.49
.turnin 49289 >>Turn in A Special Stone
.timer 10,Roleplay Duration
.target Deyon
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tWait for the RP. Talk to |cRXP_FRIENDLY_Deyon|r again
.goto 862,75.22,61.49
.accept 51407 >>Accept Find Their Words
.target Deyon
step
>>Take the portal |cRXP_FRIENDLY_Deyon|r summons.
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Akru|r
.goto 862,70.56,64.89
.turnin 51407 >>Turn in Find Their Words
.target Akru
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Yazma|r and |cRXP_FRIENDLY_Zolani|r
.turnin 46927 >>Turn in Punishment of Tal'aman
.turnin 46928 >>Turn in Punishment of Tal'farrak
.goto 1165,50.05,84.76
.turnin 46929 >>Turn in Deterrent
.accept 50881 >>Accept Royal Report
.goto 1165,50.05,85.08
.target Yazma
.target Zolani
step
#label ZuldazarRoyalReport
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Habutu|r. You may have to wait when you turned in the other quests first
.goto 1165,49.43,44.77,20,0
.goto 1165,50.03,46.54
.turnin 50881 >>Turn in Royal Report
.target Habutu
step
#label ZuldazarFalseProphecies
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_King Rastakhan|r
.goto 1165,49.92,46.63
.turnin 47432 >>Turn in The Bargain is Struck
.turnin 49663 >>Turn in False Prophecies
.target King Rastakhan
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_King Rastakhan|r
.target King Rastakhan
.accept 49122 >>Accept A Port in Peril
.goto 1165,49.92,46.63
step
.goto 862,51.62,45.45
>>Click on the |cRXP_PICK_WANTED board|r
.accept 51071 >>Accept WANTED: Sabertusk Empress
.accept 51072 >>Accept WANTED: Prime Thumpknuckle
step
.goto 862,52.69,45.05
>>Kill a |cRXP_ENEMY_Prime Thumpknuckle|r
>>|cRXP_WARN_SEMI HARD elite, skip if too hard|r
.complete 51072,1 
.mob Prime Thumpknuckle
step
.goto 862,52.36,47.76
>>Kill a |cRXP_ENEMY_Sabertusk Empress|r
>>|cRXP_WARN_VERY HARD elite, only try it if you know what to do and/or are using heirlooms|r
*Even with heirlooms this elite can be very difficult depending on your class
.complete 51071,1 
.mob Sabertusk Empress
step
.goto 862,51.65,50.53
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shaz'ki|r
.turnin 51071 >>Turn in WANTED: Sabertusk Empress
.target Shaz'ki
step
.goto 862,51.65,50.53
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Saz'ki|r
.turnin 51072 >>Turn in WANTED: Prime Thumpknuckle
.target Saz'ki
step
.goto 862,51.61,50.57
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bently Greaseflare|r
.accept 49919 >>Accept Kaja'mite Ore Bust
.target Bently Greaseflare
.accept 49922 >>Accept King Da'ka
step
#label ZuldazarGorillaGorge
#completewith ZuldazarPeaceLovingGorillas
>>Kill |cRXP_ENEMY_Gorillas|r in the area
.accept 49918 >>Accept Gorilla Gorge (Bonus Objective)
.complete 49918,1 
.mob Da'kani Pugilist
.mob Da'kani Highbrow
.mob Zayoos
.mob King Da'ka
step
#title Vent scanned (1/5)
.goto 862,50.37,55.02
>>CLick on the |cRXP_PICK_Kaja'mite Steam Vent|r
.complete 49919,1,1 
step
.goto 862,50.17,54.57
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tsunga|r
.accept 49920 >>Accept Gorilla Warfare
.target Tsunga
step
#completewith ZuldazarDakaniGorillas
+Pick up a |cRXP_PICK_Kaja'mite Chunk|r for a damage buff
step
#title Gorilla released (1/6)
>>Click on the |cRXP_PICK_Cage|r
.goto 862,49.95,54.94
.complete 49920,1,1 
step
#title Vent scanned (2/5)
.goto 862,49.51,54.72
>>CLick on the |cRXP_PICK_Kaja'mite Steam Vent|r
.complete 49919,1,2 
step
#title Gorilla released (2/6)
>>Click on the |cRXP_PICK_Cage|r
.goto 862,49.56,55.26
.complete 49920,1,2 
step
#title Vent scanned (3/5)
.goto 862,49.07,55.31
>>CLick on the |cRXP_PICK_Kaja'mite Steam Vent|r
.complete 49919,1,3 
step
#title Gorilla released (3/6)
>>Click on the |cRXP_PICK_Cage|r
.goto 862,49.03,54.79
.complete 49920,1,3 
step
#title Gorilla released (4/6)
>>Click on the |cRXP_PICK_Cage|r
.goto 862,48.63,53.91
.complete 49920,1,4 
step
#title Vent scanned (4/5)
.goto 862,48.16,54.00
>>CLick on the |cRXP_PICK_Kaja'mite Steam Vent|r
.complete 49919,1,4 
step
#completewith next
.goto 862,48.00,54.24,30,0
+You can kill the rare |cRXP_ENEMY_Zayoos|r if you want. He drops a pretty good trinket and counts for the bonus objective
step
#title Gorilla released (5/6)
>>Click on the |cRXP_PICK_Cage|r
.goto 862,48.14,53.16
.complete 49920,1,5 
step
#title Vent scanned (5/5)
.goto 862,48.02,52.70
>>CLick on the |cRXP_PICK_Kaja'mite Steam Vent|r
.complete 49919,1 
step
#title Gorilla released (6/6)
#label ZuldazarPeaceLovingGorillas
>>Click on the |cRXP_PICK_Cage|r
.goto 862,48.09,51.24
.complete 49920,1 
step
#completewith next
#label KingDakaSlain
.goto 862,46.74,50.54,0,0
>>Kill |cRXP_ENEMY_King Da'ka|r
.complete 49922,1 
.mob King Da'ka
step
#completewith KingDakaSlain
#title Enter Cave
.goto 862,47.10,51.52,10 >>Enter the cave
step
#requires KingDakaSlain
.goto 862,46.74,50.54
>>Kill |cRXP_ENEMY_King Da'ka|r
.complete 49922,1 
.mob King Da'ka
step
.isQuestComplete 49920
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tsunga|r
.goto 862,47.42,52.43
.turnin 49920 >>Turn in Gorilla Warfare
.target Tsunga
step
#label ZuldazarDakaniGorillas
>>Kill |cRXP_ENEMY_Gorillas|r in the area
.waypoint 862,48.93,54.52,-25,0
.complete 49918,1 
.mob Da'kani Pugilist
.mob Da'kani Highbrow
.mob Zayoos
.mob King Da'ka
step
.goto 862,51.60,50.56
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bently Greaseflare|r
.turnin 49919 >>Turn in Kaja'mite Ore Bust
.turnin 49922 >>Turn in King Da'ka
.target Bently Greaseflare
step
.goto 862,47.92,60.45
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zolani|r
.turnin 49122 >>Turn in A Port in Peril
.accept 49144 >>Accept Wrath of the Zandalari
.target Zolani
step
.goto 862,47.86,60.45
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Habutu|r
.accept 49145 >>Accept No Troll Left Behind
.target Habutu
step
.goto 862,47.13,60.47
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kaza'Jin|r
.accept 49146 >>Accept Spirit's Belongings
.target Kaza'Jin
step
#completewith ZuldazarGrimoireoftheOtherSide
>>Kill |cRXP_ENEMY_Mogu Invaders|r in the area
.complete 49144,1 
.mob Kao-Tien Marauder
.mob Charged Sentinel
.mob Kao-Tien Subjugator
step
#title Rally Rastair Defenders (2/12)
>>Use the |T133729:0|t[Rastari Skull Whistle] near |cRXP_FRIENDLY_Rastari Defenders|r to rally them
.goto 862,46.80,60.66
.use 153524
.complete 49145,1,2 
step
#title Rally Rastair Defenders (5/12)
>>Use the |T133729:0|t[Rastari Skull Whistle] near |cRXP_FRIENDLY_Rastari Defenders|r to rally them
.goto 862,46.34,60.17
.use 153524
.complete 49145,1,5 
step
#title Reclaimed Bijous
>>Pick up the |cRXP_PICK_Reclaimed Bijous|r
.goto 862,45.61,60.38
.complete 49146,1 
step
#title Rally Rastair Defenders (7/12)
>>Use the |T133729:0|t[Rastari Skull Whistle] near |cRXP_FRIENDLY_Rastari Defenders|r to rally them
.goto 862,45.61,60.38
.use 153524
.complete 49145,1,7 
step
#title Rally Rastair Defenders (12/12)
>>Use the |T133729:0|t[Rastari Skull Whistle] near |cRXP_FRIENDLY_Rastari Defenders|r to rally them
.goto 862,45.30,60.91
.use 153524
.complete 49145,1,12 
step
>>Pick up the |cRXP_PICK_Venerated Remains|r
.goto 862,45.30,60.91,10,0
.goto 862,45.81,62.45
.complete 49146,3 
step
#label ZuldazarGrimoireoftheOtherSide
>>Jump down and pick up the |cRXP_PICK_Grimoire of the Other Side|r
.goto 862,46.80,61.90
.complete 49146,2 
step
#loop
.goto 862,46.45,60.75,35,0
.goto 862,46.45,60.80,35,0
>>Kill |cRXP_ENEMY_Mogu Invaders|r
.complete 49144,1 
.mob Kao-Tien Marauder
.mob Charged Sentinel
.mob Kao-Tien Subjugator
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Habutu|r
.goto 862,47.87,60.44
.turnin 49145 >>Turn in No Troll Left Behind
.target Habutu
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zalani|r
.goto 862,47.92,60.45
.turnin 49144 >>Turn in Wrath of the Zandalari
.target Zalani
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kaza'jin|r
.goto 862,48.08,60.37
.turnin 49146 >>Turn in Spirits' Belongings
.target Kaza'jin
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kaza'jin|r
.goto 862,48.08,60.37
.accept 49149 >>Accept Embrace the Voodoo
.target Kaza'jin
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zalani|r
.goto 862,47.92,60.45
.accept 49148 >>Accept Crumbling Apart
.target Zalani
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Habutu|r
.goto 862,47.87,60.44
.accept 49147 >>Accept Show of Strength
.target Habutu
step
#completewith ZuldazarBlueRunesTurnin
+|cRXP_WARN_Standing in the blue runes on the ground gives you 100% crit chance|r
step
#completewith ZuldazarSpiritObelisksactivated
>>Kill |cRXP_ENEMY_Stormbound Conquerer|r
.complete 49148,1 
.mob Stormbound Conquerer
step
#title Obelisk activated (1/5)
>>Click on the |cRXP_PICK_Spirit Obelisk|r
.goto 862,47.22,61.86
.complete 49149,1,1 
step
#title Obelisk activated (2/5)
>>Click on the |cRXP_PICK_Spirit Obelisk|r
.goto 862,47.97,63.06
.complete 49149,1,2 
step
.goto 862,48.15,64.48
>>Kill |cRXP_ENEMY_Jao-Ti|r
.complete 49147,1 
.mob Jao-Ti the Thunderous
step
#title Obelisk activated (3/5)
>>Click on the |cRXP_PICK_Spirit Obelisk|r
.goto 862,47.45,65.14
.complete 49149,1,3 
step
#title Obelisk activated (4/5)
>>Click on the |cRXP_PICK_Spirit Obelisk|r
.goto 862,47.48,66.76
.complete 49149,1,4 
step
>>Kill |cRXP_ENEMY_Zheng|r
.goto 862,45.83,66.51
.complete 49147,2 
.mob Subjugator Zheng
step
#title Obelisk activated (5/5)
#label ZuldazarSpiritObelisksactivated
>>Click on the |cRXP_PICK_Spirit Obelisk|r
.goto 862,48.55,64.51
.complete 49149,1 
step
#loop
.goto 862,47.57,60.80,40,0
.goto 862,46.91,67.62,40,0
.goto 862,48.78,64.48,40,0
>>Kill |cRXP_ENEMY_Stormbound Conquerer|r
.complete 49148,1 
.mob Stormbound Conquerer
step
#label ZuldazarBlueRunesTurnin
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kaza'jin|r
.goto 862,49.59,64.48
.turnin 49149 >>Turn in Embrace the Voodoo
.turnin 49147 >>Turn in Show of Strength
.turnin 49148 >>Turn in Crumbling Apart
.target Kaza'jin
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kaza'jin|r
.goto 862,49.59,64.48
.accept 49309 >>Accept Thunder's Fall
.target Kaza'jin
step
>>Kill |cRXP_ENEMY_Warlord Kao|r on the ship
.goto 862,50.19,65.38
.complete 49309,1 
.mob Warlord Kao
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kaza'jin|r
.goto 862,49.59,64.48
.turnin 49309 >>Turn in Thunder's Fall
.accept 49310 >>Accept The Prophet's Ploy
.target Kaza'jin
step
>>Mount |cRXP_FRIENDLY_Scarbeak|r
.goto 862,49.51,64.34
.complete 49310,1 
.target Scarbeak
step
.goto 1164,41.33,72.25
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Baine|r
.turnin 49310 >>Turn in The Prophet's Play
.accept 47509 >>Accept Terrace of the Chosen
.target Baine Bloodhoof
step
.isOnQuest 47509
.isQuestTurnedIn 47436
#completewith ZuldazarTerraceoftheChosen
.goto 1165,49.92,33.18
.cast 6478 >>Click on the |cRXP_PICK_Altar of Pa'ku|r to gain a movement speed buff
step
.isOnQuest 47509
.isQuestTurnedIn 47443
#completewith ZuldazarTerraceoftheChosen
.goto 1165,49.92,33.18
.cast 6478 >>Click the |cRXP_PICK_Altar of Gonk|r to gain a passive damage buff
step
#label ZuldazarTerraceoftheChosen
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kaza'jin|r
.goto 1165,42.6,21.4
.turnin 47509 >>Turn in Terrace of the Chosen
.accept 47897 >>Accept Zanchuli Traitors
.accept 47915 >>Accept Rescuing the Taken
.target Kaza'jin
step
#completewith next
>>Kill the |cRXP_ENEMY_Zanchuli|r in the area
.complete 47897,1 
.mob Zanchuli Betrayer
.mob Zanchuli Berserker
.mob Zanchuli Backstabber
step
>>Kill |cRXP_ENEMY_Hexmother Kala|r. Loot her for her |cRXP_LOOT_fetish|r
.goto 1165,41.42,18.84,8,0
.goto 1165,43.51,17.71
.complete 47915,1 
.mob Hexmother Kala
step
>>Kill the |cRXP_ENEMY_Zanchuli|r in the area
.goto 1165,39.62,13.19
.complete 47897,1 
.mob Zanchuli Betrayer
.mob Zanchuli Berserker
.mob Zanchuli Backstabber
.mob Zulian Inquisitor
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wardruid Loti|r
.goto 1165,39.3,13.7
.turnin 47897 >>Turn in Zanchuli Traitors
.turnin 47915 >>Turn in Rescuing the Taken
.target Wardruid Loti
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wardruid Loti|r
.goto 1165,39.3,13.7
.accept 47518 >>Accept Raal
.accept 47520 >>Accept Walls Have Ears
.target Wardruid Loti
step
#sticky
#label ZuldazarEyesEarsYazma
>>Try to kill 5-6 |cRXP_ENEMY_spiders|r before you reach the top
.goto 1165,43.63,7.41,0,0
.complete 47520,1 
.mob Eye of Yazma
.mob Ear of Yazma
step
>>Climb the pyramide. Kill |cRXP_ENEMY_Crazzak|r
.goto 1167,46.31,39.87,10,0
.goto 1167,36.76,25.53,10,0
.goto 1167,44.09,15.00,10,0
.goto 1166,78.67,86.33,10,0
.goto 1165,46.08,15.98,10,0
.goto 1165,43.63,7.39
.complete 47518,1 
.mob Crazzak
step
#requires ZuldazarEyesEarsYazma
.goto 1165,43.63,7.39
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hexlord Raal|r and |cRXP_FRIENDLY_Wardruid Loti|r
.turnin -47518 >>Turn in Raal
.turnin -47520 >>Turn in Walls Have Ears
.target Hexlord Raal
.target Wardruid Loti
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hexlord Raal|r
.goto 1165,42.55,9.48
.accept 47521 >>Accept Midnight in the Garden of the Loa
.target Hexlord Raal
step
>>Mount |cRXP_FRIENDLY_Ata the Winglord|r
.goto 1165,42.51,10.04
.complete 47521,1 
.target Ata the Winglord
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wardruid Loti|r
.goto 862,50.69,29.66
.turnin 47521 >>Turn in Midnight in the Garden of the Loa
.accept 47522 >>Accept The Hunter
.target Wardruid Loti
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hexlord Raal|r
.goto 862,50.69,29.57
.accept 47963 >>Accept The Ancient One
.target Hexlord Raal
step
#completewith ZuldazarMistressofLies
>>Click on the small |cRXP_PICK_Voodoo Piles|r on the ground
>>Or kill the |cRXP_ENEMY_Atal'Shadra forces|r in the area
.accept 47527 >>Accept Rituals of Heresy (Bonus Objective)
.complete 47527,1 
.mob Atal'Shadra Bloodletter
.mob Atal'Shadra Tormentor
.mob Spawn of Shadra
step
>>Kill the |cRXP_ENEMY_Shadra Betrayers|r around |cRXP_FRIENDLY_Pa'ku|r to rescue him
.goto 862,50.24,30.58,15,0
.goto 862,50.99,32.17,20,0
.goto 862,51.28,31.99,10,0
.goto 862,52.07,33.14
.complete 47963,1 
.mob Shadra Betrayer
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Pa'ku|r
.goto 862,52.1,33.1
.turnin 47963 >>Turn in The Ancient One
.target Pa'ku
step
>>Run up the small hill to rescue |cRXP_FRIENDLY_Gonk|r
.goto 862,50.13,33.46,15,0
.goto 862,49.18,32.45,15,0
.goto 862,48.79,31.79
.complete 47522,1 
step
#completewith ZuldazarTheHunter
.goto 862,48.79,32.08
.cast 6478 >>Click on the |cRXP_PICK_Altar of Pa'ku|r to gain a movement speed buff
step
.isQuestTurnedIn 47443
#completewith ZuldazarTheHunter
.goto 862,48.59,31.59
.cast 6478 >>Click on the |cRXP_PICK_Altar of Gonk|r to gain a passive damage buff
step
#label ZuldazarTheHunter
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gonk|r
.goto 862,48.4,32.1
.turnin 47522 >>Turn in The Hunter
.target Gonk
step
#label ZuldazarMistressofLies
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Acolyte Mali|r
.goto 862,48.54,31.95
.accept 47528 >>Accept Mistress of Lies
.target Acolyte Mali
step
>>Click on the small |cRXP_PICK_Voodoo Piles|r on the ground
>>Or kill the |cRXP_ENEMY_Atal'Shadra forces|r in the area
#loop
.goto 862,48.69,31.21,10,0
.goto 862,48.91,29.76,8,0
.goto 862,49.35,29.46,8,0
.goto 862,49.34,29.08,8,0
.goto 862,47.70,28.85,5,0
.goto 862,49.15,28.39,20,0
.goto 862,48.00,30.44,30,0
.goto 862,49.95,29.84,30,0
.goto 862,49.41,28.39,30,0
.complete 47527,1 
.mob Atal'Shadra Bloodletter
.mob Atal'Shadra Tormentor
.mob Spawn of Shadra
step
#label ZuldazarVolkaalYazma
>>Enter the shrine and defeat |cRXP_ENEMY_Vol'kaal|r
.goto 862,47.72,28.85,10,0
.goto 862,47.10,27.79
.complete 47528,1 
.complete 47528,2 
.mob Vol'kaal
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wardruid Loti|r
*You have to relog if you don't see her
.goto 862,47.92,29.07,15,0
.goto 862,48.57,26.79
.turnin 47528 >>Turn in Mistress of Lies
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Beastmother Jabati|r
.goto 862,47.32,25.13
.accept 49679 >>Accept The Sethrak Incursion
.target Beastmother Jabati
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bladeguard Sonji|r
.goto 862,47.25,24.95
.accept 49678 >>Accept I Spy a Spire
.accept 49680 >>Accept Skycaller Soltok
.target Bladeguard Sonji
step
#sticky
#label ZuldazarSethrakInvader
>>Kill the |cRXP_ENEMY_Sethrak|r and the |cRXP_ENEMY_Krolusk|r in the area
.goto 862,45.80,23.70,0,0
.complete 49679,1 
.mob Sethrak Invader
.mob Sethrak Skycaller
.mob Krolusk Warcrawler
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lil'Tika|r
.goto 862,46.20,23.35
.accept 49681 >>Accept Lil' Tika
.target Lil'Tika
step
>>Click on the |cRXP_PICK_Sethrak Cage|r
.goto 862,46.20,23.35
.complete 49681,1 
step
#title Spire destroyed (1/4)
>>Click on the |cRXP_PICK_Sethrak Spire|r
.goto 862,46.00,22.78
.complete 49678,1,1 
step
#title Spire destroyed (2/4)
>>Click on the |cRXP_PICK_Sethrak Spire|r
.goto 862,45.62,23.03
.complete 49678,1,2 
step
#title Spire destroyed (3/4)
>>Click on the |cRXP_PICK_Sethrak Spire|r
.goto 862,45.11,24.06
.complete 49678,1,3 
step
#title Spire destroyed (4/4)
>>Click on the |cRXP_PICK_Sethrak Spire|r
.goto 862,44.34,24.49
.complete 49678,1 
step
>>Click on the |cRXP_FRIENDLY_Chief Chan'tika|r on the ground
.goto 862,45.37,26.40
.complete 49681,2 
step
>>Kill |cRXP_ENEMY_Skycaller Soltok|r on the second floor
.goto 862,45.19,25.95,10,0
.goto 862,45.05,26.14,5,0
.goto 862,45.31,26.25
.complete 49680,1 
.mob Skycaller Soltok
step
#requires ZuldazarSethrakInvader
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bladeguard Sonji|r
.goto 862,47.25,24.95
.turnin 49678 >>Turn in I Spy a Spire
.turnin 49680 >>Turn in Skycaller Soltok
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Beastmother Jabati|r
.goto 862,47.33,25.14
.turnin 49679 >>Turn in The Sethrak Incursion
.turnin 49681 >>Turn in Lil' Tika
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#subgroup Chromie Time (Veteran Player)
#name e) Horde Silverpine Forest
#displayname |cFFFCDC00Chapter 5|r - Silverpine Forest
#next f) Horde Hillsbrad Foothills
#veteran
<< Horde
step
#title Fly to Dazar'alor
.zoneskip 862,1
.goto 1165,49.91,40.98
.zone 1165 >>Fly to Dazar'alor
step
#title Enter The Great Seal
.zoneskip 1165,1
.goto 1163,48.56,50.92
.zone 1163 >>Enter The Great Seal
step
#title Click on Portal to Orgrimmar
.zoneskip 1163,1
.goto 1163,73.94,69.92
.zone 85 >>Click on the Portal to Orgrimmar
step
.pve
.zoneskip 85,1
#title Active War Mode. Skip if you don't want to.
+|cRXP_WARN_Skip if you don't want to activate War Mode|r (Bottom Right on your Talent Window (N)) even though it increases your experience gain by at least 10%
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Chromie|r and select the campaign |cRXP_PICK_"Draenor"|r
.goto 85,40.81,80.08
.accept 60968 >>Accept Warlords of Draenor: Onward to Adventure in Draenor
.target Chromie
step
>>Open the Adventure Guide (Shift + J), click on the right arrow until you see 'Spires of Arak', click 'Start Quest'
>>|cRXP_WARN_MAKE SURE YOU'RE IN THE WARLORDS OF DRAENOR TIMEWALKING PHASE|r
*You have to be at least level 30 to do this. The guide is written in a way that you should be level 30 at this point.
.goto 85,40.81,80.08
.accept 36951 >>Accept Arakkoa Exodus
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Chromie|r and select the campaign "The Legion Invasion"
.goto 85,40.81,80.08
.accept 43926 >>Accept Legion: The Legion Returns
.target Chromie
step
.isOnQuest 43926
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Holgar Stormaxe|r outside of Orgrimmar
.goto 1,46.00,13.80
.turnin 43926 >>Turn in Legion: The Legion Returns
.target Holgar Stormaxe
step
.isQuestTurnedIn 43926
.isQuestAvailable 44184
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Holgar Stormaxe|r outside of Orgrimmar
.goto 1,46.00,13.80
.accept 44281 >>Accept To Be Prepared
.target Holgar Stormaxe
step
.isOnQuest 44281
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with any of the |cRXP_PICK_meals|r
.goto 1,47.85,13.59
.complete 44281,3 
step
.isOnQuest 44281
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with a |cRXP_PICK_Keg of Armor Polish|r
.goto 1,49.67,14.13
.complete 44281,1 
step
.isOnQuest 44281
#completewith next
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Cauldron of Mojo|r
.goto 1,50.12,13.81,10,0
.collect 141295,1
step
.isQuestTurnedIn 43926
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Holgar Stormaxe|r to skip the Scenario
*If you can't skip it then skip this step
.goto 1,46.01,13.81
.skipgossip
.accept 44184 >>Accept In the Blink of an Eye
step
.isOnQuest 44184
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Emissary Auldbridge|r
.target Emissary Auldbridge
.goto 627,57.60,45.78
.turnin 44184 >>Turn in In the Blink of an Eye
step
#completewith SilvermoonToUndercityA
#label SilverpineTheWarchiefCometh
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grand Executor Mortuus|r
.target Grand Executor Mortuus
.goto 21,57.43,10.14,0,0
.accept 26965 >>Accept The Warchief Cometh
.timer 300,Garrosh Roleplay
step
#completewith SilverpineTheWarchiefCometh
#label DaralanToOrgrimmarA
.zoneskip 627,1
.goto 627,55.24,24.01
.zone 85 >>Take the portal to Orgrimmar
step
#requires DaralanToOrgrimmarA
#completewith SilverpineTheWarchiefCometh
#label OrgrimmarToSilvermoonA
.goto 85,56.02,88.25
.zone 110 >> Take the portal to Silvermoon
step
.zoneskip 18
#requires OrgrimmarToSilvermoonA
#completewith SilverpineTheWarchiefCometh
#label SilvermoonToUndercityA
.goto 110,51.84,17.95,8,0
.goto 110,49.52,17.19,8,0
.goto 110,48.87,14.04,8,0
.goto 110,49.52,14.81
.zone 18 >>Click on the |cRXP_PICK_Orb of Translocation|r
step
#requires SilverpineTheWarchiefCometh
.goto 21,57.43,10.14
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grand Executor Mortuus|r
.accept 26965 >>Accept The Warchief Cometh
.timer 300,Garrosh Roleplay
.target Grand Executor Mortuus
step
#completewith SilverpineStandbyWarchiefGarroshArrival
.goto 21,57.23,10.37
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_High Warlord Cromush|r when he arrives
.accept 28089 >>Accept Warchief's Command: Hillsbrad Foothills!
.target High Warlord Cromush
step
#label SilverpineStandbyWarchiefGarroshArrival
.goto 21,57.42,10.13
.complete 26965,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grand Executor Mortuus|r
.target Grand Executor Mortuus
.goto 21,57.42,10.13
.turnin 26965 >>Turn in The Warchief Cometh
.accept 26989 >>Accept The Gilneas Liberation Front
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Apothecary Witherbloom|r and |cRXP_FRIENDLY_High Apothecary Shana T'veen|r
.accept 26992 >>Accept Agony Abounds
.goto 21,56.77,9.19
.accept 26995 >>Accept Guts and Gore
.goto 21,56.26,8.40
.target Apothecary Witherbloom
.target High Apothecary Shana T'veen
step
#completewith SilverpineWorgenRenegade
>>Kill |cRXP_ENEMY_beasts|r in the area. Loot them for their |cRXP_LOOT_guts|r
>>Keep an eye out for the rares |cRXP_ENEMY_Kree|r and |cRXP_ENEMY_Gorefang|r
.goto 21,60.83,6.82,30,0
.goto 21,62.24,12.54,25,0
.goto 21,61.76,13.12,20,0
.goto 21,59.36,12.96,20,0
.goto 21,55.66,20.18,20,0
.goto 21,56.01,22.62,20,0
.complete 26995,1 
.mob Ferocious Grizzled Bear
.mob Worg
step
#completewith SilverpineWorgenRenegade
*>>Pick up |cRXP_PICK_Ferocious Doomweed|r from the ground
.complete 26992,1 
step
#label SilverpineWorgenRenegade
>>Kill the |cRXP_ENEMY_Worgen Renegade|r in the area
.goto 21,56.01,22.62,30,0
.goto 21,53.93,17.13,15,0
.goto 21,56.07,12.92
.complete 26989,1 
.mob Worgen Renegade
step
#sticky
#label SilverpineCleanBeastGuts
>>Kill |cRXP_ENEMY_beasts|r in the area. Loot them for their |cRXP_LOOT_guts|r
>>Keep an eye out for the rares |cRXP_ENEMY_Kree|r and |cRXP_ENEMY_Gorefang|r
.goto 21,59.26,16.38,20,0
.goto 21,60.52,9.07,20,0
.complete 26995,1 
.mob Ferocious Grizzled Bear
.mob Worg
step
*>>Pick up |cRXP_PICK_Ferocious Doomweed|r from the ground
.goto 21,55.54,13.17,20,0
.goto 21,58.30,15.89,20,0
.goto 21,61.04,13.36,30,0
.goto 21,60.46,8.74
.complete 26992,1 
step
#requires SilverpineCleanBeastGuts
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grand Executor Mortuus|r
.target Grand Executor Mortuus
.goto 21,57.41,10.12
.turnin 26989 >>Turn in The Gilneas Liberation Front
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Apothecary Witherbloom|r and |cRXP_FRIENDLY_High Apothecary Shana T'veen|r
.turnin 26992 >>Turn in Agony Abounds
.goto 21,56.76,9.19
.turnin 26995 >>Turn in Guts and Gore
.accept 26998 >>Accept Iterating Upon Success
.goto 21,56.26,8.40
.target Apothecary Witherbloom
.target High Apothecary Shana T'veen
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bat Handler Maggotbreath|r
.target Bat Handler Maggotbreath
.goto 21,57.91,8.71
.skipgossip 1
.complete 26998,1 
step
>>Spam |T236885:0|t[Blight Concotion] (1) on the |cRXP_ENEMY_Murlocs|r
*|cRXP_WARN_DON'T USE (2)|r
.complete 26998,2 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_High Apothecary Shana T'veen|r
.target High Apothecary Shana T'veen
.goto 21,56.26,8.40
.turnin 26998 >>Turn in Iterating Upon Success
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Deathstalker Commander Belmont|r
.target Deathstalker Commander Belmont
.goto 21,58.09,8.98
.accept 27039 >>Accept Dangerous Intentions
step
>>Click on the |cRXP_PICK_Abandoned Outhouse|r
.goto 21,53.90,13.01
.turnin 27039 >>Turn in Dangerous Intentions
.accept 27045 >>Accept Waiting to Exsanguinate
step
>>Click on the |cRXP_PICK_Armoire|r. |cRXP_WARN_DON'T SKIP THE CINEMATIC|r
.goto 21,53.41,13.19,8,0
.goto 21,53.04,13.11,8,0
.goto 21,53.44,13.08,8,0
.goto 21,53.30,12.56
.complete 27045,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Deathstalker Commander Belmont|r
.target Deathstalker Commander Belmont
.goto 21,58.09,8.98
.turnin 27045 >>Turn in Waiting to Exsanguinate
.accept 27056 >>Accept Belmont's Report
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Sylvanas Windrunner|r
.target Lady Sylvanas Windrunner
.goto 21,57.37,10.20
.turnin 27056 >>Turn in Belmont's Report
.accept 27065 >>Accept The Warchief's Fleet
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Admiral Hatchet|r and |cRXP_FRIENDLY_Warlord Torok|r
>>Follow the arrow to check the locations for the rares |cRXP_ENEMY_Nightlash|r, |cRXP_ENEMY_Gnath|r, and |cRXP_ENEMY_Bolgaff|r
.goto 21,52.57,25.71,25,0
.goto 21,50.06,29.25,25,0
.goto 21,48.38,24.48,25,0
.goto 21,44.06,21.36
.turnin 27065 >>Turn in The Warchief's Fleet
.accept 27069 >>Accept Steel Thunder
.accept 27073 >>Accept Give 'em Hell!
.target Admiral Hatchet
.target Warlord Torok
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Apothecary Wormcrud|r
.target Apothecary Wormcrud
.goto 21,44.80,20.91
.accept 27082 >>Accept Playing Dirty
step
#completewith next
>>Kill |cRXP_ENEMY_Worgs|r and |cRXP_ENEMY_Bears|r. Loot them for their |cRXP_LOOT_organs|r
.goto 21,42.44,20.06,20,0
.goto 21,38.58,23.93,10,0
.goto 21,37.45,23.73
.complete 27082,1 
.mob Giant Rabid Bear
.mob Rabid Worg
step
#completewith next
>>Kill |cRXP_ENEMY_Bloodfang Scavengers|r
.goto 21,39.41,25.88,20,0
.goto 21,37.89,27.44,20,0
.goto 21,38.79,30.30,20,0
.goto 21,40.19,29.25
.goto 21,39.20,28.09,0,0
.complete 27073,1 
.mob Bloodfang Scavenger
step
>>Pick up the |cRXP_PICK_crates|r on the ground
.goto 21,39.20,28.09
.complete 27069,1 
step
#sticky
#label SilverpineBloodfangScavenger
>>Kill |cRXP_ENEMY_Bloodfang Scavengers|r
.goto 21,39.20,28.09
.complete 27073,1 
.mob Bloodfang Scavenger
step
>>Kill |cRXP_ENEMY_Worgs|r and |cRXP_ENEMY_Bears|r. Loot them for their |cRXP_LOOT_organs|r
.goto 21,45.69,27.85
.complete 27082,1 
.mob Giant Rabid Bear
.mob Rabid Worg
step
#requires SilverpineBloodfangScavenger
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Admiral Hatchet|r and |cRXP_FRIENDLY_Warlord Torok|r
.goto 21,44.00,21.34
.turnin 27069 >>Turn in Steel Thunder
.turnin 27073 >>Turn in Give 'em Hell!
.accept 27095 >>Accept Skitterweb Menace
.accept 27093 >>Accept Lost in the Darkness
.target Admiral Hatchet
.target Warlord Torok
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Apothecary Wormcrud|r
.target Apothecary Wormcrud
.goto 21,44.79,20.91
.turnin 27082 >>Turn in Playing Dirty
.accept 27088 >>Accept It's Only Poisonous if You Ingest It
step
#completewith SilverpineSkitterwebMatriarch
>>Destroy the |cRXP_ENEMY_Webbed Victims|r to free the |cRXP_FRIENDLY_Orc Sea Dogs|r
>>Keep an eye out for the rare |cRXP_ENEMY_Krethis the Shadowspinner|r
.goto 21,35.90,14.58,0,0
.complete 27093,1 
.mob Webbed Victim
step
#completewith SilverpineSkitterwebMatriarch
>>Kill |cRXP_ENEMY_Skitterweb Spiders|r
.goto 21,35.90,14.58,0,0
.complete 27095,1 
.mob Skitterweb Spider
step
>>Follow the arrow into the mine. Jump up the rocks
>>|cRXP_WARN_There may be a chest next to the jumping location|r
.goto 21,35.14,11.29,10,0
.goto 21,35.47,10.51,10,0
.goto 21,34.95,10.29,10,0
.goto 21,35.56,9.29
.accept 27094 >>Accept Deeper into Darkness
step
#label SilverpineSkitterwebMatriarch
>>Kill the |cRXP_ENEMY_Skitterweb Matriarch|r
.goto 21,35.94,8.65
.complete 27094,1 
.mob Skitterweb Matriarch
step
#completewith next
.goto 21,35.85,7.98,10 >>Check for a possible |cRXP_PICK_chest|r
.goto 21,34.67,7.82,10,0
.goto 21,35.60,13.38,10 >>Leave the cave
step
#sticky
#label SilverpineOrcSeaDog
>>Destroy the |cRXP_ENEMY_Webbed Victims|r to free the |cRXP_FRIENDLY_Orc Sea Dogs|r
>>Keep an eye out for the rare |cRXP_ENEMY_Krethis the Shadowspinner|r
.goto 21,34.80,15.02,30,0
.goto 21,35.60,17.69,30,0
.goto 21,35.90,14.58,0,0
.complete 27093,1 
.mob Webbed Victim
step
>>Kill |cRXP_ENEMY_Skitterweb Spiders|r
.goto 21,37.11,16.23,30,0
.goto 21,34.80,15.02,30,0
.goto 21,35.60,17.69,30,0
.goto 21,35.90,14.58
.complete 27095,1 
.mob Skitterweb Spider
step
>>Click on the quest in your quest log under your minimap
.turnin 27095 >>Turn in Skitterweb Menace
step
#requires SilverpineOrcSeaDog
>>Use the |T132598:0|t[Mutant Bush Chicken Cage] on the |cRXP_ENEMY_Ettin|r.
*|cRXP_WARN_The |cRXP_ENEMY_Ettin|r runs around the village. Click on the quest on the map/quest tracker to track the |cRXP_ENEMY_Ettin|r. You should see a small yellow waypoint at his position.|r
.goto 21,46.68,18.04,30,0
.goto 21,46.20,28.45,30,0
.goto 21,39.64,29.99,30,0
.goto 21,39.90,16.58
.use 60808
.complete 27088,1 
.mob Forest Ettin
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Apothecary Wormcrud|r, |cRXP_FRIENDLY_Admiral Hatchet|r, and |cRXP_FRIENDLY_Warlord Torok|r
.turnin 27088 >>Turn in It's Only Poisonous if You Ingest It
.goto 21,44.79,20.91
.turnin 27093 >>Turn in Lost in the Darkness
.turnin 27094 >>Turn in Deeper into Darkness
.accept 27096 >>Accept Orcs are in Order
.goto 21,44.01,21.32
.target Apothecary Wormcrud
.target Admiral Hatchet
.target Warlord Torok
step
#completewith next
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bat Handler Maggotbreath|r
.goto 21,45.94,21.88
.fly Forsaken High Command >>Fly to Forsaken High Command
.target Bat Handler Maggotbreath
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Sylvanas Windrunner|r
*Dismount before talking to Sylvanas
.target Lady Sylvanas Windrunner
.goto 21,57.37,10.20
.turnin 27096 >>Turn in Orcs are in Order
.accept 27097 >>Accept Rise, Forsaken
step
>>Kill |cRXP_ENEMY_Hillsbrad Refugees|r while |cRXP_FRIENDLY_Agatha|r is next to you
*|cRXP_WARN_Wait until Agatha spawns before mounting up. If she despawns just dismount and wait for her to reappear|r
.goto 21,64.87,19.37,30,0
.goto 21,65.70,26.35
.complete 27097,1 
step
>>Click on the quest in your quest log under your minimap
.goto 21,65.70,26.35
.turnin 27097 >>Turn in Rise, Forsaken
.accept 27099 >>Accept No Escape
step
.goto 21,65.73,24.39,10,0
.goto 21,66.27,24.34,10,0
.goto 21,66.07,23.92,10,0
.goto 21,65.54,23.44,10,0
.goto 21,65.92,23.35,8,0
.goto 21,65.94,23.91,8,0
.goto 21,65.29,23.94,10,0
.goto 21,65.27,24.97
>>Find the leaders upstaris. You don't need to kill any mobs |cRXP_WARN_if you can survive it.|r
*|cRXP_WARN_DON'T SKIP THE CINEMATIC|r
.complete 27099,1 
step
.goto 21,57.35,10.21
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Sylvanas Windrunner|r
.turnin 27099 >>Turn in No Escape
.accept 27098 >>Accept Lordaeron
.target Lady Sylvanas Windrunner
step
.complete 27098,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Sylvanas Windrunner|r
.target Lady Sylvanas Windrunner
.goto 21,44.89,41.65
.turnin 27098 >>Turn in Lordaeron
.accept 27180 >>Accept Honor the Dead
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Admiral Hatchet|r and |cRXP_FRIENDLY_Warlord Torok|r
.goto 21,45.78,41.94
.accept 27226 >>Accept Hair of the Dog
.accept 27231 >>Accept Reinforcements from Fenris
.target Admiral Hatchet
.target Warlord Torok
step
#completewith SilverpineAcceptExcisingtheTaint
.goto 21,46.42,42.70
.skipgossip 6739,1
.home >>Set your Hearthstone to The Sepulcher
step
#label SilverpineAcceptExcisingtheTaint
>>Kill a |cRXP_ENEMY_Bloodfang Stalker|r to trigger the quest
.goto 21,47.28,46.68
.accept 27181 >>Accept Excising the Taint
.mob Bloodfang Stalker
step
#completewith next
>>Loot the corpses of |cRXP_FRIENDLY_Veteran Forsaken Troopers|r on the ground
.complete 27180,1 
.target Veteran Forsaken Trooper
step
>>Kill |cRXP_ENEMY_Bloodfang Stalkers|r
>>Keep an eye out for the rare |cRXP_ENEMY_Berard the Moon-Crazed|r
.goto 21,43.34,50.79,15,0
.goto 21,46.27,51.27,25,0
.goto 21,47.48,49.47,30,0
.goto 21,47.03,53.10
.complete 27181,1 
.mob Bloodfang Stalker
step
>>Click on the quest in your quest log under your minimap
.turnin 27181 >>Turn in Excising the Taint
.accept 27193 >>Accept Seek and Destroy
step
>>Kill |cRXP_ENEMY_Caretaker Smithers|r. Loot him for his |cRXP_LOOT_logbook|r
.goto 21,45.90,54.23
.complete 27193,1 
.mob Caretaker Smithers
step
>>Click on the quest in your quest log under your minimap
.turnin 27193 >>Turn in Seek and Destroy
.accept 27194 >>Accept Cornered and Crushed!
step
>>Loot the corpses of |cRXP_FRIENDLY_Veteran Forsaken Troopers|r on the ground
.goto 21,47.03,53.10,30,0
.goto 21,46.27,51.27,25,0
.goto 21,47.48,49.47,30,0
.goto 21,45.55,49.45,30,0
.goto 21,47.03,53.10
.complete 27180,1 
.target Veteran Forsaken Trooper
step
#requires SilverpineForsakenInsignia
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Forteski|r and follow him
.goto 21,55.88,46.35
.turnin 27194 >>Turn in Cornered and Crushed!
.accept 27195 >>Accept Nowhere to Run
.target Master Forteski
step
*|cRXP_WARN_Don't run too far away from |cRXP_FRIENDLY_Master Forteski|r|r
.goto 21,58.05,44.89
.complete 27195,1 
.target Master Forteski
step
#completewith next
.goto 21,56.46,46.06,10 >>Leave the cave
step
#completewith SilverpineHairoftheDog
>>Kill |cRXP_ENEMY_Hillsbrad Worgen|r
.goto 21,56.64,34.11,0,0
.complete 27231,1 
.mob Hillsbrad Worgen
step
#title Orc roused 1/8
>>Use the |T252176:0|t[Barrel of Explosive Ale] on Orc Sea Dogs
*Keep an eye out for chests
.goto 21,54.25,38.83
.use 60870
.complete 27226,1,1 
.target Orc Sea Dog
step
#completewith next
.goto 21,53.51,38.64,10 >>Check for a possible |cRXP_PICK_chest|r
step
#title Orc roused 2/8
>>Use the |T252176:0|t[Barrel of Explosive Ale] on Orc Sea Dogs
*Keep an eye out for chests
.goto 21,53.86,37.49
.use 60870
.complete 27226,1,2 
.target Orc Sea Dog
step
#title Orc roused 3/8
>>Use the |T252176:0|t[Barrel of Explosive Ale] on Orc Sea Dogs
*Keep an eye out for chests
.goto 21,54.37,36.25
.use 60870
.complete 27226,1,3 
.target Orc Sea Dog
step
#title Orc roused 4/8
>>Use the |T252176:0|t[Barrel of Explosive Ale] on Orc Sea Dogs
*Keep an eye out for chests
.goto 21,53.91,35.74
.use 60870
.complete 27226,1,4 
.target Orc Sea Dog
step
#completewith next
.goto 21,54.43,34.34,10 >>Check for a possible chest
step
#title Orc roused 5/8
>>Use the |T252176:0|t[Barrel of Explosive Ale] on Orc Sea Dogs
*Keep an eye out for chests
.goto 21,54.47,33.00
.use 60870
.complete 27226,1,5 
.target Orc Sea Dog
step
#title Orc roused 6/8
>>Use the |T252176:0|t[Barrel of Explosive Ale] on Orc Sea Dogs
*Keep an eye out for chests
.goto 21,56.08,32.18
.use 60870
.complete 27226,1,6 
.target Orc Sea Dog
step
#title Orc roused 7/8
>>Use the |T252176:0|t[Barrel of Explosive Ale] on Orc Sea Dogs
*Keep an eye out for chests
.goto 21,57.05,32.67
.use 60870
.complete 27226,1,7 
.target Orc Sea Dog
step
#label SilverpineHairoftheDog
#title Orc roused 8/8
>>Use the |T252176:0|t[Barrel of Explosive Ale] on Orc Sea Dogs
*Keep an eye out for chests
.goto 21,57.76,34.06
.use 60870
.complete 27226,1 
.target Orc Sea Dog
step
>>Kill |cRXP_ENEMY_Hillsbrad Worgen|r
.goto 21,57.01,34.96,30,0
.goto 21,54.34,34.19,30,0
.goto 21,52.93,31.90,30,0
.goto 21,56.64,34.11,0,0
.complete 27231,1 
.mob Hillsbrad Worgen
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Horde Communication Panel|r
.goto 21,59.24,34.22
.turnin 27231 >>Turn in Reinforcements from Fenris
.accept 27232 >>Accept The Waters Run Red...
step
#completewith next
.goto 21,59.62,33.53
.vehicle 45263 >>Enter the |cRXP_PICK_Horde Cannon|r
step
>>Use |T133032:0|t[Rocket Blast] (1) to kill the arriving |cRXP_ENEMY_Worgen|r
>>Keep an eye out for the rare |cRXP_ENEMY_Fenwick Thatros|r
.goto 21,59.38,33.46,8,0
.goto 21,59.62,33.53
.complete 27232,1 
step
#completewith next
.goto 21,46.43,42.70
.vendor
step
#label SilverpineTheWatersRunRed
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Admiral Hatchet|r and |cRXP_FRIENDLY_Warlord Torok|r
.goto 21,45.79,41.90
.turnin 27232 >>Turn in The Waters Run Red...
.turnin 27226 >>Turn in Hair of the Dog
.target Admiral Hatchet
.target Warlord Torok
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Sylvanas Windrunner|r
.target Lady Sylvanas Windrunner
.goto 21,44.94,41.66
.turnin 27180 >>Turn in Honor the Dead
.turnin 27195 >>Turn in Nowhere to Run
.accept 27290 >>Accept To Forsaken Forward Command
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tFly with |cRXP_FRIENDLY_Arthura|r and talk to |cRXP_FRIENDLY_Deathstalker Commander Belmont|r
.goto 217,57.46,18.77
.turnin 27290 >>Turn in To Forsaken Forward Command
.accept 27342 >>Accept In Time, All Will Be Revealed
.target Arthura
.target Deathstalker Commander Belmont
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Forward Commander Onslaught|r
.target Forward Commander Onslaught
.goto 217,57.54,18.24
.accept 27333 >>Accept Losing Ground
.accept 27345 >>Accept The F.C.D.
step
#completewith next
>>Kill |cRXP_ENEMY_Worgen Rebels|r
.goto 217,55.39,13.66,20,0
.complete 27333,1 
.mob Worgen Rebel
step
#sticky
#label SilverpineKorokSecondHead
>>Kill |cRXP_ENEMY_Korok|r (patrolling). Loot him for his |cRXP_LOOT_head|r. Click it in your bags
.goto 217,50.26,19.52,15,0
.goto 217,50.26,19.52,0,0
.collect 60956,1,27322,1
.accept 27322 >>Accept Korok the Colossus
.mob Korok the Colossus
step
>>Pick up the |cRXP_PICK_device|r on the ground
.goto 217,45.76,21.96
.complete 27345,1 
step
#requires SilverpineKorokSecondHead
#sticky
#label SilverpineWorgenRebel
>>Kill the |cRXP_ENEMY_Worgen Rebels|r
.goto 217,54.21,22.11,20,0
.goto 217,55.10,26.28,15,0
.goto 217,54.84,19.34,0,0
.complete 27333,1 
.mob Worgen Rebel
step
#requires SilverpineKorokSecondHead
>>Loot |cRXP_PICK_Wolfsbane|r around the waypoint
*Spawn is too random to place exact waypoints
.goto 217,58.82,32.55,20,0
.goto 217,62.30,33.88,30,0
.goto 217,63.78,31.96,30,0
.goto 217,59.83,28.20
.complete 27342,1 
step
#requires SilverpineWorgenRebel
.goto 217,57.49,18.48
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Onslaught|r and |cRXP_FRIENDLY_Belmont|r
.turnin 27333 >>Turn in Losing Ground
.turnin 27345 >>Turn in The F.C.D.
.turnin 27322 >>Turn in Korok the Colossus
.turnin 27342 >>Turn in In Time, All Will Be Revealed
.accept 27349 >>Accept Break in Communications: Dreadwatch Outpost
.target Forward Commander Onslaught
.target Deathstalker Commander Belmont
step
*It may not complete if you fly too high.
>>|cRXP_WARN_Follow the arrow|r
.goto 217,52.70,32.23
.complete 27349,1 
step
>>Click on the quest in your quest log under your minimap
.goto 217,52.76,32.36
.turnin 27349 >>Turn in Break in Communications: Dreadwatch Outpost
.accept 27350 >>Accept Break in Communications: Rutsak's Guard
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Rutsak|r
.target Captain Rutsak
.goto 217,65.64,34.21
.turnin 27350 >>Turn in Break in Communications: Rutsak's Guard
.accept 27360 >>Accept Vengeance for Our Soldiers
.accept 27364 >>Accept On Whose Orders?
step
#completewith next
>>Kill the |cRXP_ENEMY_Submariners|r in the area
.complete 27360,1 
.mob 7th Legion Submariner
step
>>Kill |cRXP_ENEMY_Master Seargent Pietro Zaren|r. Loot him for the |cRXP_LOOT_orders|r
.goto 217,58.76,47.38
.complete 27364,1 
.mob Master Seargent Pietro Zaren
step
>>Click on the quest in your quest log under your minimap
.goto 217,58.17,47.43
.turnin 27364 >>Turn in On Whose Orders?
.accept 27401 >>Accept What Tomorrow Brings
step
>>Kill |cRXP_ENEMY_7th Legion Sumbariners|r in the area
*|cRXP_WARN_Be careful not to pull too many because they can do a lot of damage.|r
.goto 217,60.12,45.39,20,0
.goto 217,59.17,42.96,20,0
.goto 217,57.91,45.44,20,0
.goto 217,56.73,48.52
.complete 27360,1 
.mob 7th Legion Submariner
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_spyglass|r
*|cRXP_WARN_DON'T SKIP THE CINEMATIC|r
.goto 217,54.72,44.45
.complete 27401,1 
step
>>Click on the quest in your quest log under your minimap
.goto 217,54.72,44.45
.turnin 27401 >>Turn in What Tomorrow Brings
.accept 27405 >>Accept Fall Back!
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Rutsak|r
.target Captain Rutsak
.goto 217,65.70,34.29
.turnin 27360 >>Turn in Vengeance for Our Soldiers
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Deathstalker Commander Belmont|r
.target Deathstalker Commander Belmont
.goto 217,72.88,30.21
.turnin 27405 >>Turn in Fall Back!
.accept 27406 >>Accept A Man Named Godfrey
step
>>You automatically accept it when you reach the waypoint
.goto 217,73.76,32.85
.accept 27423 >>Accept Resistance is Futile
step
#completewith next
+|cRXP_WARN_Dismount if no NPC is following you to make them spawn|r
step
*Focus on killing the the |cRXP_ENEMY_Bloodfang Scout|r + 5 |cRXP_ENEMY_Gilnean Warhound|r packs
.goto 217,71.84,42.71,35,0
.goto 217,71.78,51.53,35,0
.goto 217,76.38,56.02,35,0
.goto 217,77.65,61.04
.complete 27423,1 
.mob Bloodfang Scout
.mob Gilnean Warhound
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_corpse|r of |cRXP_FRIENDLY_Lord Godfrey|r
.goto 217,79.70,75.78
.complete 27406,1 
.target Lord Godfrey
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Deathstalker Commander Belmont|r
.target Deathstalker Commander Belmont
*Dismount if no NPC is following you to make them spawn.
.goto 217,79.70,75.78
.turnin 27406 >>Turn in A Man Named Godfrey
.turnin 27423 >>Turn in Resistance is Futile
.accept 27438 >>Accept The Great Escape
step
.goto 21,51.77,66.06
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Sylvanas Windrunner|r
.target Lady Sylvanas Windrunner
.turnin 27438 >>Turn in The Great Escape
.accept 27472 >>Accept Rise, Godfrey
step
#completewith SilverpineLordGodfreyReborn
+|cRXP_WARN_You only have roughly 40 seconds to search for the next two Rares|r. Run back early if you're too slow. If you miss the timer, abandon the quest and start it again.
step
#completewith next
*You have to pull him with a ranged ability as you can't see him near the Forsaken Front
.goto 21,48.53,69.00,15 >>Search for Corpsefeeder behind you
step
#completewith next
.goto 21,47.43,69.93,15 >>Search for Effritus
step
#label SilverpineLordGodfreyReborn
.goto 21,51.73,65.50
.complete 27472,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Sylvanas Windrunner|r and |cRXP_FRIENDLY_Daschla|r
.turnin 27472 >>Turn in Rise, Godfrey
.accept 27474 >>Accept Breaking the Barrier
.goto 21,51.88,65.08
.accept 27475 >>Accept Unyielding Servitors
.goto 21,51.91,64.69
.target Lady Sylvanas Windrunner
.target Daschla
step
#completewith next
#title Check for Chest
.goto 21,58.48,61.62,8 >>Check possible |cRXP_PICK_Chest|r location
step
#completewith SilverpineBreakingtheBarrier
>>Kill the |cRXP_ENEMY_elementals|r in the area. Loot them for their |cRXP_LOOT_cores|r
.goto 21,59.51,64.29,0,0
.complete 27475,1 
.mob Elemental Servitor
step
#completewith next
.goto 21,62.84,64.02,8 >>Enter the building
step
#label SilverpineBreakingtheBarrier
>>Pick up the |cRXP_PICK_book|r.
.goto 21,63.48,64.25
.complete 27474,1 
step
#completewith next
.goto 21,62.84,64.02,8 >>Leave the building
step
>>Kill the |cRXP_ENEMY_elementals|r in the area. Loot them for their |cRXP_LOOT_cores|r
.goto 21,59.51,64.29,0,0
.complete 27475,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Daschla|r and |cRXP_FRIENDLY_Lady Sylvanas Windrunner|r
.turnin 27475 >>Turn in Unyielding Servitors
.goto 21,51.89,64.67
.turnin 27474 >>Turn in Breaking the Barrier
.accept 27476 >>Accept Dalar Dawnweaver
.goto 21,51.94,64.99
.target Daschla
.target Lady Sylvanas Windrunner
step
#completewith next
.goto 21,50.85,63.72
.fly The Sepulcher >>Fly to The Sepulcher
step
.goto 21,47.06,43.22
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dalar Dawnweaver|r
.target Dalar Dawnweaver
.turnin 27476 >>Turn in Dalar Dawnweaver
.accept 27478 >>Accept Relios the Relic Keeper
.accept 27483 >>Accept Practical Vengeance
step
#completewith next
#label LeyEnergies
>>Kill an |cRXP_ENEMY_Arcane Remnant|r. Loot it for the |cRXP_LOOT_Arcane Remnant|r. Click it in your bags
.goto 25,30.10,37.07,0,0
.collect 61310,1,27480
.accept 27480 >>Accept Ley Energies
.mob Arcane Remnant
step
#completewith LeyEnergies
#title Portal to Dalaran Crater
.goto 21,47.25,43.37
.zone 25 >> Click the Portal to Dalaran Crater
step
#requires LeyEnergies
>>Kill an |cRXP_ENEMY_Arcane Remnant|r. Loot it for the |cRXP_LOOT_Arcane Remnant|r. Click it in your bags
.goto 25,30.10,37.07
.collect 61310,1,27480
.accept 27480 >>Accept Ley Energies
.mob Arcane Remnant
step
#completewith next
>>Kill |cRXP_ENEMY_Arcane Remnants|r. Loot them for their |T135731:0|t[|cRXP_LOOT_Arcane Remnants|r]
.goto 25,31.86,37.55,15,0
.complete 27480,1 
.mob Arcane Remnant
step
#completewith next
*Focus on killing |cRXP_ENEMY_Dalaran Workers|r. The summoners are not worth it
.goto 25,29.72,44.21,0,0
.unitscan Indigos
.complete 27483,1 
.mob Dalaran Worker
step
>>Kill |cRXP_ENEMY_Relios the Relic|r. Loot him for the |cRXP_LOOT_ring|r
>>Keep an eye out for the rare |cRXP_ENEMY_Indigos|r
.goto 25,31.73,39.82,15,0
.goto 25,32.76,43.09
.complete 27478,1 
.mob Relios the Relic
step
#sticky
#label SilverpineDalaranHuman
*Focus on killing |cRXP_ENEMY_Dalaran Workers|r. The summoners are not worth it
.goto 25,30.78,43.81,15,0
.goto 25,29.01,43.88
.complete 27483,1 
.mob Dalaran Worker
step
>>Kill |cRXP_ENEMY_Arcane Remnants|r. Loot them for their |T135731:0|t[|cRXP_LOOT_Arcane Remnants|r]
.goto 25,30.31,40.28,15,0
.goto 25,30.40,38.09
.complete 27480,1 
.mob Arcane Remnant
step
#requires SilverpineDalaranHuman
#completewith next
.goto 25,30.29,36.62
.zone 21 >>Take the Portal to the Sepulcher
step
#requires SilverpineDalaranHuman
.goto 21,47.07,43.22
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dalar Dawnweaver|r
.target Dalar Dawnweaver
.turnin 27478 >>Turn in Relios the Relic Keeper
.accept 27484 >>Accept Only One May Enter
.turnin 27483 >>Turn in Practical Vengeance
.turnin 27480 >>Turn in Ley Energies
step
#label SilverpineOnlyOneMayEnter
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Sylvanas Windrunner|r
.target Lady Sylvanas Windrunner
.goto 21,51.85,64.94
.turnin 27484 >>Turn in Only One May Enter
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#subgroup Chromie Time (Veteran Player)
#name f) Horde Hillsbrad Foothills
#displayname |cFFFCDC00Chapter 6|r - Hillsbrad Foothills
#next g) Horde Kun-Lai Summit <<!Monk
#next z) Monk Quest Horde <<Monk
#veteran
<< Horde
step
.zoneskip 85,1
#completewith HillsbradHillsbradFoothills
.goto 85,56.02,88.25
.zone 110 >> Take the portal to Silvermoon
step
.zoneskip 18,1
#completewith HillsbradHillsbradFoothills
.goto 110,51.84,17.95,8,0
.goto 110,49.52,17.19,8,0
.goto 110,48.87,14.04,8,0
.goto 110,49.52,14.81
.zone 18 >>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Orb of Translocation|r
step
.zoneskip 18,1
.itemcount 132516,<1
#completewith HillsbradHillsbradFoothills
+Fly to Hillsbrad
step
.zoneskip 18,1
.itemcount 132516,1
#completewith next
.cooldown item,132516,>0,1
.cast 202844 >>Use |T1405809:0|t[Gunshoes]
step
#label HillsbradHillsbradFoothills
.isOnQuest 28089
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_to High Executor Darthalia|r
.target to High Executor Darthalia
.goto 25,29.24,63.34
.turnin 28089 >>Turn in Warchief's Command: Hillsbrad Foothills!
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_to High Executor Darthalia|r
.target to High Executor Darthalia
.goto 25,29.24,63.34
.accept 28096 >>Accept Welcome to the Machine
step
#completewith next
.goto 25,29.34,63.44
.vehicle 47488 >>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Skeletal Steed|r
.target Skeletal Steed
step
>>Stay on the |cRXP_FRIENDLY_Steed|r and talk to the approaching |cRXP_FRIENDLY_NPCs|r
.skipgossip 1
.complete 28096,1 
.complete 28096,2 
.complete 28096,3 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_High Executor Darthalia|r
.target High Executor Darthalia
.goto 25,29.24,63.34
.turnin 28096 >>Turn in Welcome to the Machine
.accept 28111 >>Accept Trouble at Azurelode
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Apothecary Underhill|r
.target Apothecary Underhill
.goto 25,29.21,64.04
.accept 28115 >>Accept Past Their Prime
.accept 28114 >>Accept Glorious Harvest
step
#completewith next
.goto 25,29.46,64.12
.vendor
step
>>Kill |cRXP_ENEMY_Infested Bears|r. Loot the Eggs from their back
*|cRXP_WARN_Don't use AOE abilities otherwise you'll kill the Eggs|r. Each Bear has 8 Eggs.
.goto 25,36.04,70.81
.complete 28115,1 
.complete 28114,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Keyton|r and |cRXP_FRIENDLY_Spider-Handler Sarus|r
.goto 25,33.29,73.58
.turnin 28111 >>Turn in Trouble at Azurelode
.turnin 28115 >>Turn in Past Their Prime
.turnin 28114 >>Turn in Glorious Harvest
.accept 28144 >>Accept Thieving Little Monsters!
.accept 28138 >>Accept Human Infestation
.target Captain Keyton
.target Spider-Handler Sarus
step
#completewith next
.goto 25,33.50,71.99,5 >>Enter the Mine
step
#sticky
#label SilverpineHillbradHuman
>>|cRXP_WARN_Don't kill the humans|r. Use the |T134881:0|t[Titanium Shackles] at or below 35% HP.
.complete 28138,1 
.mob Hillsbrad Miner
.mob Hillsbrad Sentry
.use 63079
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dumass|r
.target Dumass
.goto 25,35.71,71.51,10,0
.goto 25,36.63,70.19
.accept 28156 >>Accept Deep Mine Rescue
step
#completewith next
+Leave the cave after scanning for the rare
step
*|cRXP_WARN_Dumass follows you but he will randomly attack Miners so be careful not to loose him!|r
>>Keep an eye out for the rare |cRXP_ENEMY_Miasmiss|r
.goto 25,36.77,68.39,15,0
.complete 28156,1 
.goto 25,33.29,73.58
step
#requires SilverpineHillbradHuman
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_ENEMY_Spider-Handler Sarus|r
.goto 25,33.27,73.62
.accept 28146 >>Accept Coastal Delicacies!
.target Spider-Handler Sarus
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Keytron|r
.isQuestComplete 28138
.goto 25,33.30,73.55
.turnin 28138 >>Turn in Human Infestation
.target Captain Keytron
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Keytron|r
.goto 25,33.27,73.67
.turnin 28156 >>Turn in Deep Mine Rescue
.target Captain Keytron
step
#completewith next
>>Kill |cRXP_ENEMY_Muckgill|r. Loot him for |cRXP_LOOT_Muckgill's Flipper|r. Click it in your bags
.use 63090
.collect 63090,1,28154
.accept 28154 >>Accept Muckgill's Flipper or Something...
.mob Muckgill
step
#sticky
#label HillsbradMurlocsFedSpider
>>Kill |cRXP_ENEMY_murlocs|r in the area
>>Keep an eye out for the rare |cRXP_ENEMY_Scargil|r
.goto 25,33.14,79.60,0,0
.complete 28146,1 
.mob Torn Fin Muckdweller
.mob Torn Fin Coastrunner
step
>>Click on the |cRXP_PICK_Forsaken Camp "Supplies"
.goto 25,31.37,75.71,10,0
.goto 25,32.52,79.91,10,0
.goto 25,34.47,81.14,10,0
.goto 25,35.81,81.72,10,0
.goto 25,37.60,80.94,10,0
.goto 25,32.60,79.96
.complete 28144,1 
step
>>Kill |cRXP_ENEMY_Muckgill|r. Loot him for |cRXP_LOOT_Muckgill's Flipper|r. Click it in your bags
.use 63090
.collect 63090,1,28154
.accept 28154 >>Accept Muckgill's Flipper or Something...
.mob Muckgill
step
#requires HillsbradMurlocsFedSpider
#completewith next
.unitscan Little Bjorn
.goto 25,35.08,78.48,25 >>Try to target |cRXP_ENEMY_Little Bjorn|r before running back to the camp.
.mob Little Bjorn
step
#requires HillsbradMurlocsFedSpider
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Spider-Handler Sarus|r and |cRXP_FRIENDLY_Captain Keyton|r
.goto 25,33.27,73.67
.turnin 28146 >>Turn in Coastal Delicacies!
.turnin 28138 >>Turn in Human Infestation
.turnin 28144 >>Turn in Muckgill's Flipper or Something...
.turnin 28156 >>Turn in Muckgill's Flipper or Something...
.turnin 28154 >>Turn in Muckgill's Flipper or Something...
.accept 28168 >>Accept Trouble at the Sludge Fields
.target Spider-Handler Sarus
.target Captain Keyton
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Warden Stillwater|r
.target Warden Stillwater
.goto 25,36.22,61.16
.turnin 28168 >>Turn in Trouble at the Sludge Fields
.accept 28192 >>Accept No One Here Gets Out Alive
.turnin 28192 >>Turn in No One Here Gets Out Alive
.accept 28197 >>Accept Discretion is Key
step
#completewith SilverpineForScience
.goto 25,35.85,61.26
.home >>Set your Hearthstone to The Sludge Fields
step
#completewith next
.goto 25,36.12,60.68
.vendor >> Vendor any trash you have.
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flesh-Shaper Arnauld|r
.goto 25,36.34,60.24
.accept 28199 >>Accept For Science!
.target Flesh-Shaper Arnauld
step
#sticky
#label HillsbradFleshSample
>>Kill the |cRXP_ENEMY_zombies|r in the area. Loot them for some |cRXP_LOOT_samples|r
.goto 25,38.89,63.91,0,0
.complete 28199,1 
.mob Risen Hillsbrad Peasant
.mob Risen Hillsbrad Farmer
step
>>Kill |cRXP_ENEMY_Clerk Horrace|r. Loot him for the |cRXP_LOOT_The Battle for Hillsbrad|r. Click it in your bags
.goto 25,37.82,63.37,10,0
.goto 25,38.26,63.19
.use 63249
.complete 28197,2 
.collect 63249,1,28196
.accept 28196 >>Accept The Battle for Hillsbrad
.mob Clerk Horrace Whitesteed
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Shovel|r
.goto 25,39.73,63.04
.accept 28189 >>Accept Do the Right Thing
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_FRIENDLY_Human Seedlings|r
.complete 28197,1 
.goto 25,38.98,64.14
.complete 28189,1 
.goto 25,39.14,63.57
.target Human Seedling
step
>>Click on the quest popup under your minimap or search for the quest in your quest log
.goto 25,38.45,63.16
.turnin 28189 >>Turn in Do the Right Thing
step
#label SilverpineForScience
#requires HillsbradFleshSample
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flesh-Shaper Arnauld|r
.goto 25,36.34,60.23
.turnin 28199 >>Turn in For Science!
.target Flesh-Shaper Arnauld
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Warden Stillwater|r
.target Warden Stillwater
.goto 25,36.18,61.14
.turnin 28196 >>Turn in The Battle for Hillsbrad
.turnin 28197 >>Turn in Discretion is Key
.accept 28206 >>Accept A Lost Lad
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Johnny Awesome|r and |cRXP_FRIENDLY_Master Apothecary Lydon|r
*|cRXP_WARN_DON'T KILL ANYTHING ON YOUR WAY|r
.goto 25,40.33,59.40
.turnin 28206 >>Turn in A Lost Lad
.accept 28209 >>Accept Freedom for Lydon
.target Johnny Awesome
.target Master Apothecary Lydon
step
#completewith next
.goto 25,39.55,60.36,15 >>Check |cRXP_PICK_Chest|r location
step
>>Kill |cRXP_ENEMY_Infected Sludge Guards|r. Loot them for |T237379:0|t[|cRXP_LOOT_Lydon's Cage Key|r]
.goto 25,38.97,59.66
.complete 28209,1 
.mob Infected Sludge Guard
step
#completewith HillsbradHeadOfWardenStillwater
+|cRXP_WARN_If you can't see |cRXP_FRIENDLY_Lydon|r or |cRXP_FRIENDLY_Johnny|r dismount and wait until they respawn|r
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Apothecary Lydon|r
.target Master Apothecary Lydon
.goto 25,40.25,59.32
.turnin 28209 >>Turn in Freedom for Lydon
.accept 28230 >>Accept Protocol
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Johnny Awesome|r
.target Johnny Awesome
.goto 25,40.25,59.32
.accept 28231 >>Accept Do it for Twinkles
step
>>Kill the |cRXP_ENEMY_Monstrosity|r and |cRXP_ENEMY_Verringtan|r
.goto 25,38.37,56.61
.complete 28230,1 
.complete 28231,1 
.mob The Ray-Getz-Kalaba Monstrosity
.mob Blacksmith Verringtan
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Johnny Awesome|r and |cRXP_FRIENDLY_Master Apothecary Lydon|r
.goto 25,38.22,56.71
.turnin 28230 >>Turn in Protocol
.turnin 28231 >>Turn in Do it for Twinkles
.accept 28235 >>Accept Burnside Must Fall
.target Johnny Awesome
.target Master Apothecary Lydon
step
>>Walk up to |cRXP_ENEMY_Magistrate Burnside|r to kill him.
.goto 25,36.64,58.00
.complete 28235,1 
.mob Magistrate Burnside
step
.goto 25,36.65,58.07
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Apothecary Lydon|r
.target Master Apothecary Lydon
.turnin 28235 >>Turn in Burnside Must Fall
.accept 28237 >>Accept A Blight Upon the Land
step
>>Kill |cRXP_ENEMY_Warden Stillwater|r. Loot him for his |cRXP_LOOT_head|r
*Make sure to face Warden Stillwater to the house because he will knock you back
.goto 25,36.37,61.16
.complete 28237,1 
.mob Warden Stillwater
step
#label HillsbradHeadOfWardenStillwater
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Apothecary Lydon|r
.target Master Apothecary Lydon
.goto 25,36.65,61.20
.turnin 28237 >>Turn in A Blight Upon the Land
.accept 28251 >>Accept Trouble at Southshore
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Serge Hinott|r
.target Serge Hinott
>>Keep an eye out for the rare |cRXP_ENEMY_Alitus|r
.unitscan Alitus
.goto 25,49.10,66.36
.turnin 28251 >>Turn in Green Living
.accept 28325 >>Accept Green Living
.accept 28324 >>Accept Studies in Lethality
step
#sticky
#label HillsbradBlightSample
>>Use the |T307036:0|t[Lethality Analyzer] on the |cRXP_ENEMY_slimes|r in the area
*|cRXP_WARN_Remember that you can also just click on the slimes to use the item|r
.use 63426
.goto 25,48.90,72.12,0,0
.complete 28324,1 
.mob Blight Slime
step
#completewith HillsbradAngryBlightSlime
>>Pick up |cRXP_PICK_Used Blight Canisters|r from the ground
.goto 25,48.56,72.02,0,0
.complete 28325,1 
step
>>Kill an |cRXP_ENEMY_Angry Blight Slime|r
.goto 25,48.73,72.07
.accept 28329 >>Accept Angry Scrubbing Bubbles
.mob Angry Blight Slime
step
*|cRXP_WARN_Make sure to drain them before killing them|r
>>Kill |cRXP_ENEMY_Angry Blight Slimes|r
.goto 25,49.20,72.21,15,0
.goto 25,46.27,73.67,20,0
.goto 25,47.20,70.96,20,0
.goto 25,48.71,72.55
.complete 28329,1 
.mob Angry Blight Slime
step
#label HillsbradAngryBlightSlime
>>Click on the quest popup under your minimap or search for the quest in your quest log
.goto 25,48.71,72.55
.turnin 28329 >>Turn in Angry Scrubbing Bubbles
.accept 28330 >>Accept Trail of Filth
step
>>Kill |cRXP_ENEMY_Chet|r inside the house. |cRXP_WARN_You can drain him to make the fight easier.|r
.goto 25,47.87,72.44
.complete 28330,1 
.mob Chet the Slime-Breeder
step
>>Pick up |cRXP_PICK_Used Blight Canisters|r from the ground
.goto 25,49.33,71.34,20,0
.goto 25,50.12,70.69,20,0
.goto 25,49.63,69.59,20,0
.goto 25,48.56,72.02,0,0
.complete 28325,1 
step
#requires HillsbradBlightSample
#completewith next
.goto 25,46.89,75.48,10 >>Try to target the rare |cRXP_ENEMY_Carcinak|r
.mob Carcinak
step
#requires HillsbradBlightSample
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kingslayer Orkus|r
.target Kingslayer Orkus
.goto 25,49.57,74.40
.accept 28345 >>Accept *Gurgle* HELP! *Gurgle*
.complete 28345,1 
.skipgossip 1
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kingslayer Orkus|r
.target Kingslayer Orkus
*Skip the next cinematic with ESC
.goto 25,50.02,74.34
.turnin 28345 >>Turn in *Gurgle* HELP! *Gurgle*
.accept 28348 >>Accept Stormpike Rendezvous
.turnin 28348 >>Turn in Stormpike Rendezvous
.accept 28354 >>Accept Kasha Will Fly Again
step
>>Kill |cRXP_ENEMY_Daggerspine|r. Loot him for the |cRXP_LOOT_Daggerspine Attack Plans|r. Click it in your bags
.goto 25,51.62,74.95
.use 63686
.collect 63686,1,28356
.accept 28356 >>Accept Preemptive Strike
.mob Daggerspine
step
#completewith next
.mob Lady Zephris
.goto 25,54.92,76.36,15 >>Try to target the rare |cRXP_ENEMY_Lady Zephris|r
step
>>Kill |cRXP_ENEMY_Daggerspine Nagas|r
.goto 25,54.34,77.17,25,0
.goto 25,55.11,81.10
.complete 28356,1 
.mob Daggerspine Shorestalker
.mob Daggerspine Shorehunter
.mob Daggerspine Screamer
.mob Daggerspine Siren
step
#completewith MudsnoutGnollOrShamanSlain
#hidewindow
#loop
.goto 25,57.16,75.18,25,0
.goto 25,58.12,72.31,25,0
.goto 25,57.72,74.66,25,0
+1
step
#completewith next
>>Pick up the |cRXP_PICK_Mushrooms|r
.goto 25,57.72,74.66,0,0
.complete 28354,1 
step
>>Kill a |cRXP_ENEMY_Mudsnout Gnoll|r or |cRXP_ENEMY_Shaman|r |cRXP_WARN_on the field|r
*If this doesn't trigger after the first kill, turn on "Low Level Quests" in your tracking menu next to the minimap.
.accept 28355 >>Accept Terrible Little Creatures
.mob Mudsnout Gnoll
.mob Mudsnout Shaman
step
#completewith next
>>Kill |cRXP_ENEMY_Mudsount Gnolls|r or |cRXP_ENEMY_Shamans|r
>>Keep an eye out for the rare |cRXP_ENEMY_Ro'Bark|r and a |cRXP_PICK_chest|r
.complete 28355,1 
.mob Mudsnout Gnoll
.mob Mudsnout Shaman
step
>>Click on the |cRXP_PICK_Mudsnout Blossoms|r
.complete 28354,1 
step
#label MudsnoutGnollOrShamanSlain
>>Kill |cRXP_ENEMY_Mudsount Gnolls|r or |cRXP_ENEMY_Shamans|r
>>Keep an eye out for the rare |cRXP_ENEMY_Ro'Bark|r and a |cRXP_PICK_chest|r
.complete 28355,1 
.mob Mudsnout Gnoll
.mob Mudsnout Shaman
step
>>Click on the quest popup under your minimap or search for the quest in your quest log
.goto 25,57.16,75.18
.turnin 28355 >>Turn in Terrible Little Creatures
step
#requires HillsbradMudsnoutBlossom
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Jekyll|r and |cRXP_FRIENDLY_Nils Beerot|r
.accept 28635 >>Accept A Haunting in Hillsbrad
.accept 28643 >>Accept The Durnholde Challenge: Zephyrus
.goto 25,60.01,63.34
.accept 28634 >>Accept Extinction
.goto 25,60.14,63.76
.target Captain Jekyll
.target Nils Beerot
step
>>Kill |cRXP_ENEMY_Rampaging Owlbeasts|r
>>Keep an eye out for the rares |cRXP_ENEMY_Big Samras|r and |cRXP_ENEMY_Lopex|r
.goto 25,63.61,52.69,0
.goto 25,68.8,56.0,0
.goto 25,63.52,60.82,25,0
.goto 25,63.05,57.45,25,0
.goto 25,64.42,57.03,25,0
.goto 25,65.50,54.18,25,0
.goto 25,63.61,52.69,25,0
.goto 25,67.46,54.00,25,0
.goto 25,68.89,55.88,25,0
.goto 25,71.22,57.08,25,0
.goto 25,73.03,59.96,25,0
.complete 28634,1 
.mob Rampaging Owlbeast
step
#completewith next
+|cRXP_WARN_The following elementals are VERY DIFFICULT. You can skip them.|r
step
>>Kill |cRXP_ENEMY_Zephyrus|r
*Run away when it summons a Tornado
.goto 25,68.64,59.43
.use 141295
.complete 28643,1 
.mob Zephyrus
step
.isQuestComplete 28643
>>Click on the quest popup under your minimap or search for the quest in your quest log
.turnin 28643 >>Turn in The Durnholde Challenge: Zephyrus
.accept 28644 >>Accept The Durnholde Challenge: Teracula
step
.isOnQuest 28644
>>Kill |cRXP_ENEMY_Teracula|r
*Dodge or interrupt the Rupture Line
.goto 25,67.28,59.86
.use 141295
.complete 28644,1 
.mob Teracula
step
.isQuestComplete 28644
>>Click on the quest popup under your minimap or search for the quest in your quest log
.turnin -28644 >>Turn in The Durnholde Challenge: Teracula
.accept 28645 >>Accept The Durnholde Challenge: Bloodvenom
step
.isOnQuest 28645
>>Kill |cRXP_ENEMY_Bloodvenom|r
*Move out of the blue void zones
.goto 25,66.26,60.10
.use 141295
.complete 28645,1 
.mob Bloodvenom
step
.isQuestComplete 28645
.goto 25,66.26,60.22
>>Click on the quest popup under your minimap or search for the quest in your quest log
.turnin 28645 >>Turn in The Durnholde Challenge: Bloodvenom
.accept 28646 >>Accept The Durnholde Challenge: Infernus
step
.isOnQuest 28646
>>Kill |cRXP_ENEMY_Infernus|r
*|cRXP_WARN_This one is very hard without a pet because he will disorient you periodically|r
.goto 25,68.01,63.17
.complete 28646,1 
.mob Infernus
step
.isQuestComplete 28646
>>You may have to click on the quest in your quest log under the minimap
.turnin 28646 >>Turn in The Durnholde Challenge: Infernus
.accept 28647 >>Accept The Durnholde Challenge: D-1000
step
.isOnQuest 28647
>>Kill |cRXP_ENEMY_D-1000|r
*|cRXP_WARN_This one is also very hard because of his hard hitting melee hits|r
.goto 25,70.27,61.05
.complete 28647,1 
.mob D-1000
step
#completewith next
.goto 25,77.05,59.90,30 >>Search for Zorn
.unitscan Zorn
.goto 14,26.26,28.21,30 >>Search for Snuffles and Singer
.unitscan Singer
.unitscan Snuffles
.goto 14,18.87,31.20,30 >>Search for Ruul Onestone
.unitscan Ruul Onestone
step
>>Follow the arrow
.goto 25,61.75,83.93
.complete 28635,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Ironhill's Ghost|r
.target Captain Ironhill's Ghost
.goto 25,61.78,84.39
.turnin 28635 >>Turn in A Haunting in Hillsbrad
.accept 28636 >>Accept Silence of the Dwarves
step
>>Kill |cRXP_ENEMY_Dun Garok Spirits|r
>>Keep an eye out for the rare |cRXP_ENEMY_Tamra Stormpike|r
.goto 25,63.16,87.01,10,0
.goto 25,63.31,86.61,10,0
.goto 25,63.20,85.71,20,0
.goto 25,62.43,83.75
.complete 28636,1 
.mob Dun Garok Spirit
step
.isQuestComplete 28647
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Jekyll|r and |cRXP_FRIENDLY_Nils Beerot|r
.turnin 28636 >>Turn in Silence of the Dwarves
.goto 25,59.98,63.36
.turnin 28634 >>Turn in Extinction
.turnin 28647 >>Turn in The Durnholde Challenge: D-1000
.goto 25,60.06,63.66
.target Captain Jekyll
.target Nils Beerot
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Jekyll|r and |cRXP_FRIENDLY_Nils Beerot|r
.turnin 28636 >>Turn in Silence of the Dwarves
.goto 25,59.98,63.36
.turnin 28634 >>Turn in Extinction
.goto 25,60.06,63.66
.target Captain Jekyll
.target Nils Beerot
step
.abandon 28643 >>Abandon The Durnholde Challenge: Zephyrus
.abandon 28644 >>Abandon The Durnholde Challenge: Teracula
.abandon 28645 >>Abandon The Durnholde Challenge: Bloodvenom
.abandon 28646 >>Abandon The Durnholde Challenge: Infernus
.abandon 28647 >>Abandon The Durnholde Challenge: D-1000
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Serge Hinott|r and |cRXP_FRIENDLY_Helcular|r
.goto 25,49.13,66.30
.turnin 28324 >>Turn in Studies in Lethality
.turnin 28330 >>Turn in Trail of Filth
.turnin 28325 >>Turn in Green Living
.turnin 28356 >>Turn in Preemptive Strike
.target Serge Hinott
.target Helcular
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kingslayer Orkus|r
.target Kingslayer Orkus
*Skip the cinmatic with ESC
.goto 25,50.00,74.28
.turnin 28354 >>Turn in Kasha Will Fly Again
.accept 28375 >>Accept The Road to Purgation
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kingslayer Orkus|r
.target Kingslayer Orkus
.goto 25,29.25,83.99
.turnin 28375 >>Turn in The Road to Purgation
.accept 28397 >>Accept They Will Never Expect This...
step
>>Kill |cRXP_ENEMY_Bloodfang Sentries|r and |cRXP_ENEMY_Stormpike Dwarves|r in the area
*Be careful these NPCs deal a lot of damage.
>>Keep an eye out for the rare |cRXP_ENEMY_Dustwing|r
.goto 25,27.55,84.22
.complete 28397,2 
.complete 28397,1 
.mob Bloodfang Sentry
.mob Stormpike Dwarf
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_ENEMY_Kingslayer Orkus|r next to you
*Type '/reload' into the chat if you can't turn in the quest
.goto 25,27.28,88.20
.turnin 28397 >>Turn in They Will Never Expect This...
.accept 28400 >>Accept Heroes of the Horde!
.target Kingslayer Orkus
step
>>Follow the path up the mountain
*Wait next to |cRXP_FRIENDLY_Orkus|r until you can talk to him
>>Loot the |cRXP_ENEMY_Stormpike Battle Master|r after he has killed him
.goto 25,27.35,87.35
.skipgossip 1
.complete 28400,1 
.timer 150,Flying RP
step
>>Flying takes about 2 minutes. Wait for the RP
.goto 25,57.48,46.87
.complete 28400,2 
step
#label HillsbradAcceptAFightingChance
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Advisor Duskingdawn|r
.target Advisor Duskingdawn
.goto 25,56.75,47.36
.accept 28495 >>Accept A Fighting Chance
step
#label HillsbradHeroesoftheHorde
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_High Warlord Cromush|r
.target High Warlord Cromush
.goto 25,57.08,46.24
.turnin 28400 >>Turn in Heroes of the Horde!
.accept 28587 >>Accept Aid of the Frostwolf
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Keeper Bel'varil|r
.target Keeper Bel'varil
.goto 25,56.99,45.72
.accept 28484 >>Accept The Heart of the Matter
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Deathguard Humbert|r and |cRXP_FRIENDLY_Samsa|r
*If you jump backwards while standing on the stairs you can accept the quest from downstairs. Otherwise go up the stairs in the building.
.goto 25,57.16,45.55
.accept 28487 >>Accept Humbert's Personal Problems
.accept 28485 >>Accept Yetimus the Yeti Lord
.target Deathguard Humbert
.target Samsa
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Voggah Deathgrip|r
.target Voggah Deathgrip
*Skip the cinematic with ESC
.goto 25,58.70,34.24
.turnin 28587 >>Turn in Aid of the Frostwolf
.accept 28600 >>Accept Matters of Loyalty
step
#completewith next
.goto 25,60.37,28.92,20 >>Check for the rare |cRXP_FRIENDLY_Maggarrak|r above the AV tunnel
.unitscan Maggarrak
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_High Warlord Cromush|r
.target High Warlord Cromush
*Skip the cinematic with ESC
.goto 25,57.08,46.24
.turnin 28600 >>Turn in Matters of Loyalty
.accept 28506 >>Accept March of the Stormpike
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_High Warlord Cromush|r
.target High Warlord Cromush
.goto 25,57.08,46.24
.turnin 28506 >>Turn in March of the Stormpike
.accept 28556 >>Accept Breaking the Hand
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Melisara|r
.target Melisara
.goto 25,57.27,46.35
.accept 28538 >>Accept Cry of the Banshee
step
#sticky
#label HillsbradNukeSoferasNaze
>>Use the |T237030:0|t[Goblin Pocket-Nuke] at the waypoint location
.use 64471
.goto 25,55.48,38.34,0,0
.complete 28556,1 
step
>>Damage the |cRXP_FRIENDLY_Assasins|r until 35% HP and use the |T458243:0|t[Banshee Mirror]
>>Keep an eye out for a |cRXP_PICK_chest|r
.use 64445
.goto 25,55.50,38.46,20,0
.goto 25,55.64,40.70
.complete 28538,1 
.mob SI:7 Assassin
step
>>Click on the quest in your quest log under your minimap
.turnin 28538 >>Turn in Cry of the Banshee
.accept 28566 >>Accept Decimation
step
#requires HillsbradNukeSoferasNaze
#sticky
#label HillsbradNukeCorrahnsDagger
>>Use the |T237030:0|t[Goblin Pocket-Nuke] at the waypoint location
.use 64471
.goto 25,49.40,46.69,0,0
.complete 28556,2 
step
#requires HillsbradNukeSoferasNaze
#completewith next
>>Kill |cRXP_ENEMY_Stormpike Soldiers|r
.goto 25,50.20,46.59,15,0
.goto 25,49.46,46.82,15,0
.complete 28566,2 
.mob Stormpike Soldier
step
#requires HillsbradNukeSoferasNaze
>>Kill |cRXP_ENEMY_Captain Iceheart|r (patrolling)
.goto 25,49.46,46.76
.complete 28566,1 
.mob Captain Iceheart
step
>>Kill |cRXP_ENEMY_Stormpike Soldiers|r
.goto 25,49.43,48.22,20,0
.goto 25,50.20,46.59,15,0
.goto 25,48.88,47.05
.complete 28566,2 
.mob Stormpike Soldier
step
>>Click on the quest in your quest log under your minimap
.turnin 28566 >>Turn in Decimation
.accept 28603 >>Accept Infiltration
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lilith|r next to you
.accept 28604 >>Accept Deception and Trickery
.target Lilith
step
#completewith next
.unitscan Jimmy the Bleeder
.goto 25,49.88,50.38,25 >>Search for Jimmy the Bleeder and check for Chest
step
#completewith next
>>Use the |T132814:0|t[Water Barrel] next to |cRXP_FRIENDLY_Stormpike Trainees|r
*|cRXP_WARN_Don't use the item again until you get credit for the last trainees|r
.use 64583
.complete 28604,1 
.target Stormpike Trainee
step
#requires HillsbradNukeCorrahnsDagger
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Instructor Rufus|r and kill him
>>Kill |cRXP_ENEMY_Captain Crudbeard|r
.complete 28603,1 
.goto 25,44.51,49.07
.complete 28603,3 
.goto 25,44.31,50.39
.skipgossip
.mob Instructor Rufus
.mob Captain Crudbeard
step
#completewith next
.goto 25,44.20,52.32,10 >>Check possible |cRXP_PICK_Chest|r location
.goto 25,44.32,53.83,25 >>Check for the rare |cRXP_ENEMY_Araga|r
.unitscan Araga
step
#sticky
#label HillsbradNukeHeadland
>>Use the |T237030:0|t[Goblin Pocket-Nuke] at the waypoint location
.use 64471
.goto 25,43.97,48.99,0,0
.complete 28556,3 
step
#completewith HillsbradTurninInfiltration
>>Use the |T132814:0|t[Water Barrel] next to |cRXP_FRIENDLY_Stormpike Trainees|r
*Don't use the item again until you get credit for the last trainees
.use 64583
.complete 28604,1 
.target Stormpike Trainee
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Drill Seargent Magnus|r
.target Drill Seargent Magnus
*You have to stay in meele range otherwise he may evade
.goto 25,43.41,49.97
.skipgossip
.complete 28603,2 
step
#label HillsbradTurninInfiltration
>>Click on the quest in your quest log under your minimap
.turnin 28603 >>Turn in Infiltration
step
#requires HillsbradNukeHeadland
>>Use the |T132814:0|t[Water Barrel] next to |cRXP_FRIENDLY_Stormpike Trainees|r
*Don't use the item again until you get credit for the last trainees
.use 64583
.goto 25,44.65,48.99,20,0
.goto 25,44.14,50.89,20,0
.goto 25,44.16,52.43,20,0
.goto 25,44.14,50.89
.complete 28604,1 
.target Stormpike Trainee
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lilith|r next to you
.turnin 28604 >>Turn in Deception and Trickery
.accept 28605 >>Accept Domination
.target Lilith
step
#sticky
#label HillsbradStormpikeEngineer
>>Kill |cRXP_ENEMY_Stormpike Engineers|r
.goto 25,39.93,48.52,0,0
.complete 28605,1 
.mob Stormpike Engineer
step
>>Use the |T237030:0|t[Goblin Pocket-Nuke] at the waypoint location
.use 64471
.goto 25,39.48,49.06
.complete 28556,4 
step
#requires HillsbradStormpikeEngineer
#completewith next
>>Use |T135468:0|t[Duskingdawn's Wand]. |cRXP_WARN_Make sure to stay far away from the fawns otherwise they may attack you which will result in your death|r
.use 64416
.complete 28495,1 
step
#requires HillsbradStormpikeEngineer
#completewith next
.goto 25,46.62,54.41,10 >>Enter the cave
step
#requires HillsbradStormpikeEngineer
#sticky
#label HillsbrandBeatingYetiHeart
>>Kill |cRXP_ENEMY_Cave Yetis|r. Loot them for their |cRXP_LOOT_hearts|r
.complete 28484,1 
.mob Cave Yeti
step
#requires HillsbradStormpikeEngineer
>>Pick up the |cRXP_PICK_glowing sword|r
.goto 25,45.09,51.34
.complete 28487,1 
step
>>Pick up the |cRXP_PICK_small helm|r
.goto 25,45.53,52.26,8,0
.goto 25,45.86,51.54,10,0
.goto 25,44.58,50.93
.complete 28487,2 
step
#completewith next
.goto 25,45.86,51.54,20,0
.goto 25,45.77,53.39,20 >>Search for the rare |cRXP_FRIENDLY_Weevil|r
.unitscan Weevil
step
>>Pick up the |cRXP_PICK_pants|r
.goto 25,43.79,55.16,15,0
.goto 25,44.09,53.21
.complete 28487,3 
step
#completewith next
.goto 25,45.51,52.11,10,0
.goto 25,44.78,53.30,15,0
.goto 25,46.51,54.28,10 >>Leave the cave
step
#completewith next
.isOnQuest 28485
>>|cRXP_WARN_VERY HARD Elite. Might not even kill him with Heirlooms.|r
*Within a party you should be able to kill him. You can skip this.
.goto 25,48.37,56.74,0,0
.complete 28485,1 
step
>>Use |T135468:0|t[Duskingdawn's Wand]. |cRXP_WARN_Make sure to stay far away from the fawns otherwise they may attack you which will result in your death|r
#loop
.goto 25,44.61,57.82,30,0
.goto 25,45.22,60.38,30,0
.goto 25,48.77,55.69,20,0
.goto 25,50.03,55.52,30,0
.goto 25,48.56,53.08,30,0
.goto 25,48.77,55.69,30,0
.goto 25,40.93,56.11,40,0
.use 64416
.complete 28495,1 
step
.isOnQuest 28485
>>|cRXP_WARN_VERY HARD Elite. Might not even kill him with Heirlooms.|r
*Within a party you should be able to kill him. You can skip this.
.goto 25,48.37,56.74
.complete 28485,1 
step
#requires HillsbradHillFawnSaved
#completewith next
.goto 25,55.86,54.57,35 >>Search for the rare |cRXP_ENEMY_Chordix|r
.unitscan Chordix
step
#requires HillsbradHillFawnSaved
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Advisor Duskingdawn|r
.target Advisor Duskingdawn
.goto 25,56.74,47.47
.turnin 28495 >>Turn in A Fighting Chance
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Melisara|r
.target Melisara
.goto 25,57.25,46.35
.turnin 28605 >>Turn in Domination
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_High Warlord Cromush|r
.target High Warlord Cromush
*Skip the cinematic with ESC
.goto 25,57.08,46.23
.turnin 28556 >>Turn in Breaking the Hand
.accept 28616 >>Accept Stormpike Apocalypse
.turnin 28616 >>Turn in Stormpike Apocalypse
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Keeper Bel'varil|r
.target Keeper Bel'varil
.goto 25,57.00,45.73
.turnin 28484 >>Turn in The Heart of the Matter
step
.isQuestComplete 28485
.goto 25,57.19,45.56
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Deathguard Samsa|r
.target Deathguard Samsa
.turnin 28485 >>Turn in Yetimus the Yeti Lord
step
.abandon 28485
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Deathguard Humbert|r
.target Deathguard Humbert
.goto 25,57.16,45.53
.turnin 28487 >>Turn in Humbert's Personal Problems
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#subgroup Chromie Time (Veteran Player)
#name g) Horde Kun-Lai Summit
#displayname |cFFFCDC00Chapter 7|r - Kun-Lai Summit
#title Kun-Lai Summit
#next h) Horde Spires of Arak
#veteran
<< Horde
step
.isQuestAvailable 30460
.use 140192
.zone 627 >>Use Dalaran Hearthstone
step
.isQuestAvailable 30460
.goto 627,55.28,23.95
.zone 85 >>Take the portal to Orgrimmar
step
.isQuestAvailable 30460
.goto 85,57.45,92.22
.zone 371 >>Take the Portal to Jade Forest in Orgrimmar
step
.goto 379,71.57,92.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Apothecary Cheng|r
.accept 30460 >>Accept Hit Medicine
.target Apothecary Cheng
step
.goto 379,72.27,91.83
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mayor Bramblestaff|r
.accept 30457 >>Accept Call Out Their Leader
.target Mayor Bramblestaff
step
.goto 379,70.75,90.36
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Commander Hsieh|r
.accept 30459 >>Accept All of the Arrows
.target Commander Hsieh
step
#completewith Injured Binan Warrior
#hidewindow
#loop
.goto 379,69.85,90.86,25,0
.goto 379,68.56,90.96,25,0
.goto 379,67.88,89.11,25,0
.goto 379,67.97,87.75,25,0
.goto 379,68.88,87.10,25,0
.goto 379,70.76,89.27,25,0
.goto 379,69.85,90.86,0
.goto 379,68.56,90.96,0
.goto 379,67.88,89.11,0
.goto 379,67.97,87.75,0
.goto 379,68.88,87.10,0
.goto 379,70.76,89.27,0
+1
step
#completewith Dit Da Jow
>>Kill |cRXP_ENEMY_Bataari Tribe Members|r and |cRXP_ENEMY_Bataari Fire-Warrior|r |cRXP_WARN_he spawns after killing 10x |cRXP_ENEMY_Bataari Tribe Members|r.|r
.complete 30457,1 
.complete 30457,2 
.mob Bataari Flamecaller
.mob bataari fire-warrior
.mob Bataari Yaungol
step
#completewith Dit Da Jow
>>Click on |cRXP_PICK_Arrows|r
.complete 30459,1 
step
#label Dit Da Jow
>>Use |T132798:0|t[Dit Da Jow] on |cRXP_FRIENDLY_Injured Binan Warrior|r
*|cRXP_WARN_Prioritize your own healing spells, if you have any.|r
.complete 30460,1 
.use 79819
.target Injured Binan Warrior
step
#completewith next
>>Use |T132798:0|t[Dit Da Jow] on |cRXP_FRIENDLY_Injured Binan Warrior|r
*|cRXP_WARN_Prioritize your own healing spells, if you have any.|r
.complete 30460,1 
.use 79819
.target Injured Binan Warrior
step
>>Click on |cRXP_PICK_Arrows|r
.complete 30459,1 
step
#label Injured Binan Warrior
>>Use |T132798:0|t[Dit Da Jow] on |cRXP_FRIENDLY_Injured Binan Warrior|r
*|cRXP_WARN_Prioritize your own healing spells, if you have any.|r
.complete 30460,1 
.use 79819
.target Injured Binan Warrior
step
.goto 379,70.76,90.35
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Commander Hsieh|r
.turnin 30459 >>Turn in All of the Arrows
.target Commander Hsieh
step
.goto 379,72.27,91.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mayor Bramblestaff|r
.turnin 30457 >>Turn in Call Out Their Leader
.target Mayor Bramblestaff
step
.goto 379,71.57,92.83
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Apothecary Cheng|r
.turnin 30460 >>Turn in Hit Medicine
.target Apothecary Cheng
.accept 30511 >>Accept General Nazgrim has Awakened
step
.goto 379,71.48,93.18,5,0
.goto 379,71.65,93.10
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_General Nazgrim|r
.turnin 30511 >>Turn in General Nazgrim has Awakened
.accept 30513 >>Accept Eastwind Rest
.target General Nazgrim
step
.goto 379,74.97,88.87
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Merchant Shi,|r
.accept 30467 >>Accept My Son...
.accept 30469 >>Accept Repossession
.target Merchant Shi
step
.goto 379,74.80,88.69
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Swordmistress Mei|r
.accept 30468 >>Accept Enraged Vengeance
.target Swordmistress Mei
step
.goto 379,75.14,87.94
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Waterspeaker Gorai|r
.accept 30496 >>Accept The Waterspeaker's Staff
.accept 30967 >>Accept Free the Dissenters
.target Waterspeaker Gorai
step
#completewith Orachi
>>Kill |cRXP_ENEMY_Enraged Jinyu|r
.complete 30468,1 
.mob Orachi
.mob Enraged Cavalier
.mob Enraged Priest
.mob Enraged Blacksmith
.mob Enraged Enforcer
.mob Enraged Spearman
.mob Enraged Tideweaver
step
#completewith Orachi
>>Click on |cRXP_PICK_Stolen Supplies.|r
.complete 30469,1 
step
#completewith Orachi
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Inkgill Dissenter.|r
.complete 30967,1 
.skipgossip
.target Inkgill Dissenter
step
#label Orachi
.goto 379,74.27,78.13
>>Kill |cRXP_ENEMY_Orachi.|r Loot him for |cRXP_LOOT_Stolen Inkgill Ritual Staff.|r
.complete 30496,1 
.mob Orachi
step
.goto 379,74.68,76.91
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wu-Peng|r
.turnin 30467 >>Turn in My Son...
.accept 30834 >>Accept Father and Child Reunion
.target Wu-Peng
step
#completewith Turn in The Waterspeaker's Staff
#hidewindow
#loop
.goto 379,73.08,76.26,40,0
.goto 379,73.17,77.19,40,0
.goto 379,74.33,78.61,40,0
.goto 379,74.79,79.76,40,0
.goto 379,74.77,82.39,40,0
.goto 379,73.86,82.87,40,0
.goto 379,73.72,84.08,40,0
.goto 379,74.63,84.98,40,0
.goto 379,73.08,76.26,0
.goto 379,73.17,77.19,0
.goto 379,74.33,78.61,0
.goto 379,74.79,79.76,0
.goto 379,74.77,82.39,0
.goto 379,73.86,82.87,0
.goto 379,73.72,84.08,0
.goto 379,74.63,84.98,0
+1
step
#completewith Inkgill Dissenters
>>Kill |cRXP_ENEMY_Enraged Jinyu|r
.complete 30468,1 
.mob Enraged Cavalier
.mob Enraged Priest
.mob Enraged Blacksmith
.mob Enraged Enforcer
.mob Enraged Spearman
.mob Enraged Tideweaver
.mob Orachi
step
#completewith Inkgill Dissenters
>>Click on |cRXP_PICK_Stolen Supplies.|r
.complete 30469,1 
step
#label Inkgill Dissenters
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Inkgill Dissenter.|r
.complete 30967,1 
.skipgossip
.target Inkgill Dissenter
step
#completewith next
>>Kill |cRXP_ENEMY_Enraged Jinyu|r
.complete 30468,1 
.mob Enraged Cavalier
.mob Enraged Priest
.mob Enraged Blacksmith
.mob Enraged Enforcer
.mob Enraged Spearman
.mob Enraged Tideweaver
.mob Orachi
step
>>Click on |cRXP_PICK_Stolen Supplies.|r
.complete 30469,1 
step
#label Turn in The Waterspeaker's Staff
>>Kill |cRXP_ENEMY_Enraged Jinyu|r
.complete 30468,1 
.mob Enraged Cavalier
.mob Enraged Priest
.mob Enraged Blacksmith
.mob Enraged Enforcer
.mob Enraged Spearman
.mob Enraged Tideweaver
.mob Orachi
step
.goto 379,75.21,88.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Waterspeaker Gorai|r
.turnin 30496 >>Turn in The Waterspeaker's Staff
.turnin 30967 >>Turn in Free the Dissenters
.target Waterspeaker Gorai
step
.goto 379,74.78,88.68
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Swordmistress Mei|r
.turnin 30468 >>Turn in Enraged Vengeance
.target Swordmistress Mei
step
.goto 379,74.97,88.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Merchant Shi|r
.turnin 30469 >>Turn in Repossession
.turnin 30834 >>Turn in Father and Child Reunion
.target Merchant Shi
step
#xprate <2
.goto 379,75.21,88.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Waterspeaker Gorai|r
.accept 30480 >>Accept The Ritual
.target Waterspeaker Gorai
step
.goto 379,75.21,88.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Waterspeaker Gorai|r
.target Waterspeaker Gorai
.complete 30480,1 
.timer 34,RP
.skipgossip 60973,1
step
.goto 379,74.90,88.58
>>Wait for the roleplay
.complete 30480,2 
step
>>Kill |cRXP_ENEMY_Explosive Hatred|r
.complete 30480,3 
.timer 14,RP
.mob Explosive Hatred
step
.goto 379,74.90,88.59
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Waterspeaker Gorai|r
.turnin 30480 >>Turn in The Ritual
.target Waterspeaker Gorai
step
#loop
.goto 379,71.57,74.97,40,0
.goto 379,70.74,72.41,40,0
.goto 379,71.55,71.05,40,0
.goto 379,71.57,74.97,0
.goto 379,70.74,72.41,0
.goto 379,71.55,71.05,0
>>Kill |cRXP_ENEMY_Burilgi Despoiler|r. Loot him for |T133364:0|t[Muskpaw's Keepsake]. This will start a quest.
.accept 30582 >>Accept The Late Mrs. Muskpaw
.mob Burilgi Despoiler
step
#loop
.goto 379,71.61,70.08,20,0
.goto 379,71.21,69.36,20,0
.goto 379,71.61,70.08,0
.goto 379,71.21,69.36,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lao Muskpaw|r
.turnin 30582 >>Turn in The Late Mrs. Muskpaw
.accept 30488 >>Accept The Missing Muskpaw
.accept 30489 >>Accept Fresh Needle Scent
.accept 30804 >>Accept The Fearmaster
.target Lao Muskpaw
step
#completewith next
.goto 379,73.05,73.49,20,0
.goto 381,16.39,39.7,10,0
.goto 381,26.25,61.08,10,0
.goto 381,41.97,40.32,10,0
.goto 381,53.77,32.01,10,0
.goto 381,65.53,43.08,10,0
>>Kill |cRXP_ENEMY_Needle Sprite.|r Loot them for |T134439:0|t[|cRXP_LOOT_Pungent Sprite Needles|r].
.complete 30489,1 
.mob Needle Sprite
step
.goto 381,63.96,59.96
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Muskpaw Jr.|r
.turnin 30488 >>Turn in The Missing Muskpaw
.target Muskpaw Jr.
step
#completewith next
.goto 381,65.53,43.08,10,0
.goto 381,53.77,32.01,10,0
.goto 381,41.97,40.32,10,0
.goto 381,26.25,61.08,10,0
.goto 381,16.39,39.7,10,0
.goto 379,73.05,73.49,10,0
.goto 379,71.92,72.18,30,0
.goto 379,71.5,72.05,30,0
.goto 379,69.31,72.72,30,0
.goto 379,67.99,72.47,30,0
.goto 379,65.68,73.11,30,0
.goto 379,66.96,74.17,30,0
>>Kill |cRXP_ENEMY_Needle Sprite.|r Loot them for |cRXP_LOOT_Pungent Sprite Needles.|r
.complete 30489,1 
.mob Needle Sprite
step
#completewith next
.goto 381,60.48,36.14
.goto 381,43.75,31.78
.goto 381,35.36,53.24
.goto 381,21.41,58.02
.goto 381,17.85,45.64
.goto 379,73.03,73.48,15 >> Leave the cave
step
#loop
.goto 379,71.57,74.97,40,0
.goto 379,70.74,72.41,40,0
.goto 379,71.55,71.05,40,0
.goto 379,71.57,74.97,0
.goto 379,70.74,72.41,0
.goto 379,71.55,71.05,0
>>Kill |cRXP_ENEMY_Burilgi Despoiler|r to accept quest:[Yakity Yak]
*|cRXP_WARN_This can take multiple kills|r
.accept 30587 >>Accept Yakity Yak
.mob Burilgi Despoiler
step
#completewith The Fearmaster
>>Kill |cRXP_ENEMY_Needle Sprite.|r Loot them for |cRXP_LOOT_Pungent Sprite Needles|r
.complete 30489,1 
.mob Needle Sprite
step
#completewith The Fearmaster
>>Kill |cRXP_ENEMY_Burilgi Despoiler|r
.complete 30587,1 
.mob burilgi despoiler
step
#label The Fearmaster
.goto 379,67.84,73.97
>>Kill |cRXP_ENEMY_The Fearmaster|r
.complete 30804,1 
.mob the fearmaster
step
#completewith Needle Sprite
#hidewindow
#loop
.goto 379,68.10,71.70,40,0
.goto 379,70.00,70.27,40,0
.goto 379,72.67,71.49,40,0
.goto 379,71.79,74.10,40,0
.goto 379,66.54,74.19,40,0
.goto 379,68.10,71.70,0
.goto 379,70.00,70.27,0
.goto 379,72.67,71.49,0
.goto 379,71.79,74.10,0
.goto 379,66.54,74.19,0
+1
step
#completewith next
>>Kill |cRXP_ENEMY_Needle Sprite.|r Loot them for |cRXP_LOOT_Pungent Sprite Needles|r
.complete 30489,1 
.mob Needle Sprite
step
>>Kill |cRXP_ENEMY_Burilgi Despoiler|r
.complete 30587,1 
.mob burilgi despoiler
step
#label Needle Sprite
>>Kill |cRXP_ENEMY_Needle Sprite.|r Loot them for |cRXP_LOOT_Pungent Sprite Needles|r
.complete 30489,1 
.mob Needle Sprite
step
#loop
.goto 379,71.21,69.39,25,0
.goto 379,71.94,70.30,25,0
.goto 379,71.21,69.39,0
.goto 379,71.94,70.30,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lao Muskpaw|r
.turnin 30489 >>Turn in Fresh Needle Scent
.turnin 30587 >>Turn in Yakity Yak
.turnin 30804 >>Turn in The Fearmaster
.target Lao Muskpaw
step
.group
.goto 379,71.40,69.28
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Muskpaw Jr.|r
.turnin 30491 >>Turn in At the Yak Wash
.accept 30492 >>Accept Back in Yak
.target Muskpaw Jr.
step
.goto 379,65.49,60.83
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Slimy Inkstain|r
.accept 30614 >>Accept Oil Stop
.target Slimy Inkstain
step
.goto 379,64.88,60.49
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Smokey Sootassle|r
.accept 30616 >>Accept Traffic Issues
.target Smokey Sootassle
step
.goto 379,64.71,61.73
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lucky Eightcoins|r
.accept 30808 >>Accept A Grummle's Luck
.target Lucky Eightcoins
step
#completewith Filled Oil Vial
>>Kill |cRXP_ENEMY_Ruqin Infantry|r and |cRXP_ENEMY_Ruqin Elder|r
.complete 30616,1 
.mob Ruqin Infantry
.mob Ruqin Elder
step
#completewith Filled Oil Vial
>>Click on |cRXP_PICK_Bags of Stolen Luckydos.|r
.complete 30808,1 
step
#label Filled Oil Vial
.goto 379,63.34,68.46
>>Click on |cRXP_PICK_Yaungol Oil Derrik.|r
.complete 30614,1 
step
#completewith Ruqin Yaungols
#hidewindow
#loop
.goto 379,62.19,69.29,20,0
.goto 379,62.04,67.93,20,0
.goto 379,63.38,66.86,20,0
.goto 379,62.19,69.29,0
.goto 379,62.04,67.93,0
.goto 379,63.38,66.86,0
+1
step
#completewith next
>>Kill |cRXP_ENEMY_Ruqin Infantry|r and |cRXP_ENEMY_Ruqin Elder|r
.complete 30616,1 
.mob Ruqin Infantry
.mob Ruqin Elder
.mob Ruqin Outrider
step
>>Click on |cRXP_PICK_Bags of Stolen Luckydos.|r
.complete 30808,1 
step
#label Ruqin Yaungols
>>Kill |cRXP_ENEMY_Ruqin Infantry|r and |cRXP_ENEMY_Ruqin Elder|r
.complete 30616,1 
.mob Ruqin Infantry
.mob Ruqin Elder
.mob Ruqin Outrider
step
.goto 379,63.68,86.64
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farmhand Ko|r
.complete 30513,1 
.target Farmhand Ko
.skipgossip 63751,1
step
.goto 379,61.20,82.22
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elder Shiao|r
.complete 30513,2 
.skipgossip 63535,1
.target Elder Shiao
step
.goto 379,61.19,82.22
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elder Shiao|r
.turnin 30513 >>Turn in Eastwind Rest
.accept 30515 >>Accept Challenge Accepted
.target Elder Shiao
step
#completewith next
.goto 379,58.19,84.11
.cast 8386 >>Click on the |cRXP_PICK_Banner|r to summon |cRXP_ENEMY_Ur-Bataar|r |cRXP_WARN_to summon|r |cRXP_ENEMY_Ur-Bataar|r
step
.convertquest 30514,30515 <<Horde
.goto 379,58.20,84.35
>>Kill |cRXP_ENEMY_Ur-Bataar|r
.complete 30514,1 
.mob ur-bataar
step << Alliance
.goto 379,54.69,84.21
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elder Tsulan|r
.turnin 30514 >>Turn in Challenge Accepted
.target Elder Tsulan
step << Alliance
.goto 379,53.77,82.66
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Admiral Taylor|r
.accept 30575 >>Accept Round 'Em Up
.target Admiral Taylor
step << Alliance
.goto 379,54.08,82.87
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kai the Restless|r
.home >>Set your Hearthstone to Westwind Rest
.target Kai the Restless
step << Alliance
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sully "The Pickle" McLeary|r |cRXP_FRIENDLY_Elder Tsulan|r
.accept 30583 >>Accept Blue Dwarf Needs Food Badly
.goto 379,54.15,83.30
.accept 30619 >>Accept Mogu?! Oh No-gu!
.goto 379,54.18,83.43
.target Elder Tsulan
.target Sully "The Pickle" McLeary
step << Alliance
.goto 379,53.78,84.11
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farmhand Bo|r
.accept 30569 >>Accept Trouble on the Farmstead
.target Farmhand Bo
step <<Alliance
#loop
.goto 379,53.45,83.36,10,0
.goto 379,53.46,83.08,10,0
.goto 379,53.68,83.28,10,0
.goto 379,53.45,83.36,0
.goto 379,53.46,83.08,0
.goto 379,53.68,83.28,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mishka|r
.accept 30593 >>Accept Deanimate the Reanimated
.target Mishka
step << Horde
.goto 379,61.58,80.18
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elder Shiao|r
.turnin 30515 >>Turn in Challenge Accepted
.target Elder Shiao
step << Horde
.goto 379,63.00,80.19
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_General Nazgrim|r
.accept 31256 >>Accept Round 'Em Up
.target General Nazgrim
step << Horde
.goto 379,62.70,80.71
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shademaster Kiryn|r
.accept 30594 >>Accept Deanimate the Reanimated
.target Shademaster Kiryn
step << Horde
.goto 379,62.78,79.89
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rivett Clutchpop|r
.accept 31251 >>Accept Best Meals Anywhere!
.target Rivett Clutchpop
step << Horde
.goto 379,62.53,79.42
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farmhand Ko|r
.accept 30570 >>Accept Trouble on the Farmstead
.target Farmhand Ko
step << Horde
.goto 379,62.33,79.61
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elder Shiao|r
.accept 30620 >>Accept Mogu?! Oh No-gu!
.target Elder Shiao
step
#completewith Profiting off of the Past
.convertquest 30583,31251 << Horde
>>Kill |cRXP_ENEMY_Kun-lai Wildlife.|r Loot them for |cRXP_LOOT_Kun-Lai Meaty Bits|r
.complete 30583,1 
.mob Highlands Calf
.mob Highlands Mushan
.mob Razorquill Porcupine
.mob Summit Bonestripper
step
#label Profiting off of the Past
.goto 379,59.61,78.20
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bao Jian|r
.accept 30595 >>Accept Profiting off of the Past
.target Bao Jian
step
.convertquest 30593,30594 << Horde
#loop
.goto 379,58.84,76.29,40,0
.goto 379,57.77,76.89,40,0
.goto 379,56.62,76.53,40,0
.goto 379,56.88,75.53,40,0
.goto 379,57.96,74.50,40,0
.goto 379,59.28,73.51,40,0
.goto 379,59.98,75.57,20,0
.goto 379,58.84,76.29,0
.goto 379,57.77,76.89,0
.goto 379,56.62,76.53,0
.goto 379,56.88,75.53,0
.goto 379,57.96,74.50,0
.goto 379,59.28,73.51,0
.goto 379,59.98,75.57,0
>>Kill |cRXP_ENEMY_Terracotta Warriors|r and |cRXP_ENEMY_Terracotta Guardians|r. Loot them for |cRXP_LOOT_Mogu Relic.|r |cRXP_WARN_Additionally Click on |cRXP_PICK_Mogu Relics|r |cRXP_WARN_on the ground.|r |r
.complete 30593,1 
.complete 30595,1 
.mob Terracotta Guardian
.mob Terracotta Warrior
step
.convertquest 30619,30620 << Horde
.goto 379,58.13,70.92
>>Kill |cRXP_ENEMY_Mogujia Soul-caller|r
.complete 30619,1 
.mob mogujia soul-caller
step
#label Mogujia Soul-caller
.goto 379,59.60,78.23
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bao Jian|r
.turnin 30595 >>Turn in Profiting off of the Past
.target Bao Jian
step
#completewith next
>>Kill |cRXP_ENEMY_Kun-lai Wildlife.|r Loot them for |cRXP_LOOT_Kun-Lai Meaty Bits|r
.complete 30583,1 
.mob Highlands Calf
.mob Highlands Mushan
.mob Razorquill Porcupine
.mob Summit Bonestripper
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farmer Chow|r and |cRXP_FRIENDLY_Uyen Chow|r
.turnin 30569 >>Turn in Trouble on the Farmstead << Alliance
.turnin 30570 >>Turn in Trouble on the Farmstead << Horde
.accept 30571 >>Accept Farmhand Freedom
.goto 379,60.25,85.81
.accept 30581 >>Accept ... and the Pot, Too!
.goto 379,60.17,85.93
.target Uyen Chow
.target Farmer Chow
step
#completewith Farmstead Slaves
#hidewindow
#loop
.goto 379,60.88,86.97,40,0
.goto 379,61.29,86.14,40,0
.goto 379,61.92,87.15,40,0
.goto 379,61.87,87.85,40,0
.goto 379,61.31,87.85,40,0
.goto 379,61.41,88.37,40,0
.goto 379,60.79,88.00,40,0
.goto 379,60.50,87.52,40,0
.goto 379,58.87,88.61,40,0
.goto 379,58.38,88.40,40,0
.goto 379,58.31,89.41,40,0
.goto 379,58.33,90.11,40,0
.goto 379,58.85,90.11,40,0
.goto 379,58.95,89.78,40,0
.goto 379,60.88,86.97,0
.goto 379,61.29,86.14,0
.goto 379,61.92,87.15,0
.goto 379,61.87,87.85,0
.goto 379,61.31,87.85,0
.goto 379,61.41,88.37,0
.goto 379,60.79,88.00,0
.goto 379,60.50,87.52,0
.goto 379,58.87,88.61,0
.goto 379,58.38,88.40,0
.goto 379,58.31,89.41,0
.goto 379,58.33,90.11,0
.goto 379,58.85,90.11,0
.goto 379,58.95,89.78,0
+1
step
#completewith next
>>Kill |cRXP_ENEMY_Ordo Overseer|r to rescue |cRXP_FRIENDLY_Farmstead Slaves.|r
.complete 30571,1 
.mob Ordo Raider
.mob Ordo Overseer
step
>>Kill |cRXP_ENEMY_Wascally Wirmen.|r Loot him for a lot of |cRXP_LOOT_Root Vegetables.|r |cRXP_WARN_Additionally click on |cRXP_PICK_Root Vegetables.|r |r
.complete 30581,1 
.mob Wascally Wirmen
step
#label Farmstead Slaves
>>Kill |cRXP_ENEMY_Ordo Overseer|r to rescue |cRXP_FRIENDLY_Farmstead Slaves.|r
.complete 30571,1 
.mob Ordo Raider
.mob Ordo Overseer
step
.goto 379,60.02,88.45
>>Click on |cRXP_PICK_Root Vegetable|r |cRXP_WARN_inside the small house|r
.complete 30581,2 
.mob Cookie McYaungol
step
#label Back to Westwind Rest
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Uyen Chow|r and |cRXP_FRIENDLY_Farmer Chow|r
.turnin 30581 >>Turn in ... and the Pot, Too!
.goto 379,60.17,85.92
.turnin 30571 >>Turn in Farmhand Freedom
.accept 31252 >>Accept Back to Westwind Rest << Alliance
.accept 31253 >>Accept Back to Eastwind Rest << Horde
.goto 379,60.24,85.8
.target Uyen Chow
.target Farmer Chow
step << Alliance
#completewith Kun-Lai Meaty Bits
#hidewindow
#loop
.goto 379,55.21,86.24,40,0
.goto 379,53.95,88.55,40,0
.goto 379,53.73,90.23,40,0
.goto 379,51.77,88.90,40,0
.goto 379,50.04,88.73,40,0
.goto 379,50.07,85.97,40,0
.goto 379,50.01,84.46,40,0
.goto 379,51.98,81.15,40,0
.goto 379,54.55,79.55,40,0
.goto 379,55.21,86.24,0
.goto 379,53.95,88.55,0
.goto 379,53.73,90.23,0
.goto 379,51.77,88.90,0
.goto 379,50.04,88.73,0
.goto 379,50.07,85.97,0
.goto 379,50.01,84.46,0
.goto 379,51.98,81.15,0
.goto 379,54.55,79.55,0
+1
step << Horde
#completewith Kun-Lai Meaty Bits
#hidewindow
#loop
.goto 379,63.51,84.80,40,0
.goto 379,65.95,85.31,40,0
.goto 379,67.45,80.68,40,0
.goto 379,66.52,77.04,40,0
.goto 379,64.40,78.05,40,0
.goto 379,63.51,84.80,0
.goto 379,65.95,85.31,0
.goto 379,67.45,80.68,0
.goto 379,66.52,77.04,0
.goto 379,64.40,78.05,0
+1
step
#completewith WildPlaneYakC
#label Kun-Lai Meaty Bits
>>Kill |cRXP_ENEMY_Kun-lai Wildlife.|r Loot them for |cRXP_LOOT_Kun-Lai Meaty Bits.|r
.complete 30583,1 
.mob Highlands Calf
.mob Highlands Mushan
.mob Razorquill Porcupine
.mob Summit Bonestripper
step
#completewith WildPlaneYakC
#label Yaksroundedup
>>|cRXP_WARN_When you have 3 |cRXP_FRIENDLY_Captured Yaks|r follow the arrow.|r
.complete 30575,1 << Alliance 
.complete 31256,1 << Horde 
step
#completewith Yaksroundedup
#label WildPlaneYakA
*|cRXP_WARN_If you already have 3 yaks following you ignore this step.|r
.aura 114661,1+ >>Click on |cRXP_FRIENDLY_Wild Plane Yaks|r.
.target Captured Yak
.mob Wild Plains Yak
step
#requires WildPlaneYakA
#completewith Yaksroundedup
#label WildPlaneYakB
*|cRXP_WARN_If you already have 3 yaks following you ignore this step.|r
.cast 114653 >>Click on |cRXP_FRIENDLY_Wild Plane Yaks|r.
.target Captured Yak
.mob Wild Plains Yak
step
#requires WildPlaneYakB
#completewith Yaksroundedup
#label WildPlaneYakC
*|cRXP_WARN_If you already have 3 yaks following you ignore this step.|r
.cast 114653 >>Click on |cRXP_FRIENDLY_Wild Plane Yaks|r.
.target Captured Yak
.mob Wild Plains Yak
step
#label Kun-Lai Meaty Bits
#requires WildPlaneYakC
>>Kill |cRXP_ENEMY_Kun-lai Wildlife.|r Loot them for |cRXP_LOOT_Kun-Lai Meaty Bits.|r
.complete 30583,1 
.mob Highlands Calf
.mob Highlands Mushan
.mob Razorquill Porcupine
.mob Summit Bonestripper
step
#requires WildPlaneYakC
.goto 379,54.08,83.57 << Alliance
.goto 379,62.48,80.14 << Horde
>>|cRXP_WARN_When you have 3 |cRXP_FRIENDLY_Captured Yaks|r follow the arrow.|r
.complete 30575,1 << Alliance 
.complete 31256,1 << Horde 
step << Alliance
.goto 379,53.79,84.11
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farmhand Bo|r
.turnin 31252 >>Turn in Back to Westwind Rest
.accept 31392 >>Accept Temple of the White Tiger
.target Farmhand Bo
step << Alliance
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elder Tsulan|r and |cRXP_FRIENDLY_Sully "The Pickle" McLeary|r
.turnin 30619 >>Turn in Mogu?! Oh No-gu!
.accept 30650 >>Accept Pandaren Prisoners
.goto 379,54.17,83.43
.turnin 30583 >>Turn in Blue Dwarf Needs Food Badly
.accept 30651 >>Accept Barrels of Fun
.goto 379,54.17,83.28
.target Sully "The Pickle" McLeary
.target Elder Tsulan
step << Alliance
.goto 379,53.76,82.67
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Admiral Taylor|r |cRXP_WARN_inside the tent.|r
.turnin 30575 >>Turn in Round 'Em Up
.accept 30652 >>Accept In Tents Channeling
.target Admiral Taylor
step << Alliance
#label Mishka
#loop
.goto 379,53.45,83.36,10,0
.goto 379,53.46,83.08,10,0
.goto 379,53.68,83.28,10,0
.goto 379,53.45,83.36,0
.goto 379,53.46,83.08,0
.goto 379,53.68,83.28,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mishka|r
.turnin 30593 >>Turn in Deanimate the Reanimated
.target Mishka
step << Horde
.goto 379,62.78,79.90
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rivett Clutchpop|r
.turnin 31251 >>Turn in Best Meals Anywhere!
.target Rivett Clutchpop
step << Horde
.goto 379,62.54,79.44
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farmhand Ko|r
.turnin 31253 >>Turn in Back to Eastwind Rest
.target Farmhand Ko
step << Horde
.goto 379,62.34,79.60
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elder Shiao|r
.turnin 30620 >>Turn in Mogu?! Oh No-gu!
.accept 30655 >>Accept Pandaren Prisoners
.target Elder Shiao
step << Horde
.goto 379,62.73,79.94
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rivett Clutchpop|r
.accept 30656 >>Accept Barrels of Fun
.target Rivett Clutchpop
step << Horde
.goto 379,63.00,80.20
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_General Nazgrim|r
.turnin 31256 >>Turn in Round 'Em Up
.target General Nazgrim
.accept 30657 >>Accept In Tents Channeling
step << Horde
.goto 379,62.69,80.72
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shademaster Kiryn|r
.turnin 30594 >>Turn in Deanimate the Reanimated
.target Shademaster Kiryn
step
.convertquest 30652,30657 << Horde
.convertquest 30650,30655 << Horde
.convertquest 30651,30656 << Horde
.convertquest 30660,30661
#completewith Akonu the Embercaller
>>Click on |cRXP_FRIENDLY_Pandaren Prisoners|r
.complete 30650,1 
.target Pandaren Prisoner
step
#sticky
#label EasternOilRigDestroyed
.goto 379,50.97,79.53
.use 80528
.cast 115550 >>Use |T252176:0|t[Explosives Barrel] |cRXP_WARN_next to the Rig|r
.timer 5,Explosion
.disablecheckbox
.complete 30651,1 
step
#title Pick up |T252176:0|t[Explosives Barrel]
#completewith EasternOilRigDestroyed
.goto 379,51.24,79.29,10,0
.goto 379,51,79.37
.collect 80528,1 >>Pick up a |T252176:0|t[|cRXP_PICK_Explosives Barrel|r]
step
#requires EasternOilRigDestroyed
.goto 379,50.4,78.66
>>Kill |cRXP_ENEMY_Musaan the Blazecaster|r
.complete 30652,1 
.mob musaan the blazecaster
step
.goto 379,49.44,78.49
>>Kill |cRXP_ENEMY_Harala the Firespeaker|r
.complete 30652,3 
.mob harala the firespeaker
step
#completewith next
#label SouthernOilRigDestroyed
.goto 379,49.57,81.04
.use 80528
.cast 115550 >>Use |T252176:0|t[Explosives Barrel] |cRXP_WARN_next to the Rig|r
.timer 5,Explosion
.disablecheckbox
.complete 30651,2 
step
#title Pick up |T252176:0|t[Explosives Barrel]
#completewith SouthernOilRigDestroyed
.goto 379,49.59,78.92,20,0
.goto 379,49.57,81.04
.collect 80528,1 >>Pick up a |T252176:0|t[|cRXP_PICK_Explosives Barrel|r]
step
#requires SouthernOilRigDestroyed
.goto 379,49.57,81.04
.use 80528
.cast 115550 >>Use |T252176:0|t[Explosives Barrel] |cRXP_WARN_next to the Rig|r
.timer 5,Explosion
.disablecheckbox
.complete 30651,2 
step
#requires SouthernOilRigDestroyed
.goto 379,49.35,81.06,20,0
.goto 379,49.17,80.38
>>Kill |cRXP_ENEMY_Pao-kun the Pyromancerr|r
.complete 30652,4 
.mob pao-kun the pyromancer
step
#completewith next
#label WesternOilRigDestroyed
.goto 379,47.86,81.42
.use 80528
.cast 115550 >>Use |T252176:0|t[Explosives Barrel] |cRXP_WARN_next to the Rig|r
.disablecheckbox
.timer 5,Explosion
.complete 30651,3 
step
#title Pick up |T252176:0|t[Explosives Barrel]
#completewith WesternOilRigDestroyed
.goto 379,47.53,80.18,15,0
.goto 379,47.86,81.42
.collect 80528,1 >>Pick up a |T252176:0|t[|cRXP_PICK_Explosives Barrel|r]
step
#requires WesternOilRigDestroyed
.goto 379,47.86,81.42
.use 80528
.cast 115550 >>Use |T252176:0|t[Explosives Barrel] |cRXP_WARN_next to the Rig|r
.disablecheckbox
.timer 5,Explosion
.complete 30651,3 
step
#label Akonu the Embercaller
.goto 379,47.70,80.05
>>Kill |cRXP_ENEMY_Akonu the Embercaller|r
.complete 30652,2 
.mob akonu the embercaller
step
.goto 379,48.9,76.89
>>Click on the questlog to turn in the quest.
.turnin 30652 >>Turn in In Tents Channeling
step
#requires WesternOilRigDestroyed
#completewith Ordo Warbringer
>>Interact with |cRXP_FRIENDLY_Pandaren Prisoners|r
.complete 30650,1 
.target Pandaren Prisoner
step
#requires WesternOilRigDestroyed
#completewith next
#label Ordo Warbringer
>>Kill |cRXP_ENEMY_Ordo Warbringer|r |cRXP_WARN_in the cave.|r
.complete 30660,1 
.mob ordo warbringer
step
#title Enter Cave
#requires WesternOilRigDestroyed
#completewith Ordo Warbringer
.goto 379,48.9,76.89,10 >> Enter the cave.
step
#requires Ordo Warbringer
.goto 379,48.37,76.70
>>Kill |cRXP_ENEMY_Ordo Warbringer|r |cRXP_WARN_in the cave.|r
.complete 30660,1 
.mob ordo warbringer
step
#loop
.goto 379,49.60,78.64,40,0
.goto 379,51.11,79.30,40,0
.goto 379,51.59,79.85,40,0
.goto 379,49.41,80.91,40,0
.goto 379,47.71,80.24,40,0
.goto 379,49.60,78.64,0
.goto 379,51.11,79.30,0
.goto 379,51.59,79.85,0
.goto 379,49.41,80.91,0
.goto 379,47.71,80.24,0
>>Interact with |cRXP_FRIENDLY_Pandaren Prisoners|r
.complete 30650,1 
.target Pandaren Prisoner
step
#title Enter Castle
#completewith DefenseShadopan
.goto 379,44.5,89.09,20 >> Enter the Castle
step
.isOnQuest 31455,31453
#optional
.goto 379,44.48,89.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shado-Master Chong|r
.turnin 31453 >>Turn in The Shado-Pan
.accept 30665 >>Accept The Defense of Shado-Pan Fallback
.accept 30670 >>Accept Turnabout
.target Shado-Master Chong
step
#label DefenseShadopan
.goto 379,44.48,89.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shado-Master Chong|r
.accept 30665 >>Accept The Defense of Shado-Pan Fallback
.accept 30670 >>Accept Turnabout
.target Shado-Master Chong
step
#completewith Holed Up
>>Kill |cRXP_ENEMY_sha-infested yaungol|r
.complete 30665,1 
.mob Sha-Infested Yaungol
step
#completewith Holed Up
>>Kill |cRXP_ENEMY_Blind Rage.|r Loot them for |cRXP_LOOT_Blind Rage Essence.|r
.complete 30670,1 
.mob Blind Rage
step
#completewith Holed Up
.goto 379,44.51,89.06,10 >> Leave the Castle
step
#label Holed Up
.goto 379,42.94,88.32
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sya Zhong|r |cRXP_WARN_inside the small house|r
.accept 30682 >>Accept Holed Up
.target Sya Zhong
step
#completewith Jin Warmkeg
>>Kill |cRXP_ENEMY_Sha-Infested Yaungol.|r
.complete 30665,1 
.mob Sha-Infested Yaungol
step
#completewith Jin Warmkeg
>>Kill |cRXP_ENEMY_Blind Rage.|r Loot them for |cRXP_LOOT_Blind Rage Essence.|r
.complete 30670,1 
.mob Blind Rage
step
.goto 379,43.12,88.41
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sya Zhong|r
.complete 30682,4 
.skipgossip
.target Sya Zhong
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ya Firebough|r
.complete 30682,2 
.goto 379,41.07,87.00
.skipgossip
.target Ya Firebough
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Old Lady Fung|r
.complete 30682,3 
.goto 379,42.84,85.71
.skipgossip
.target Old Lady Fung
step
#label Jin Warmkeg
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jin Warmkeg|r
.complete 30682,1 
.goto 379,43.88,86.17
.skipgossip
.target Jin Warmkeg
step
#completewith Sha-Infested Yaungol
#hidewindow
#loop
.goto 379,45.15,88.27,40,0
.goto 379,42.89,87.97,40,0
.goto 379,41.06,86.39,40,0
.goto 379,42.80,86.06,40,0
.goto 379,45.15,88.27,0
.goto 379,42.89,87.97,0
.goto 379,41.06,86.39,0
.goto 379,42.80,86.06,0
+1
step
#completewith next
>>Kill |cRXP_ENEMY_Sha-Infested Yaungol.|r
.complete 30665,1 
.mob Sha-Infested Yaungol
step
>>Kill |cRXP_ENEMY_Blind Rage.|r Loot them for |cRXP_LOOT_Blind Rage Essence.|r
.complete 30670,1 
.mob Blind Rage
step
#label Sha-Infested Yaungol
>>Kill |cRXP_ENEMY_Sha-Infested Yaungol|r
.complete 30665,1 
.mob Sha-Infested Yaungol
step
#completewith next
.goto 379,44.51,89.06,12 >> Enter the Castle
step
.goto 379,44.47,89.94
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shado-Master Chong|r
.turnin 30665 >>Turn in The Defense of Shado-Pan Fallback
.turnin 30670 >>Turn in Turnabout
.turnin 30682 >>Turn in Holed Up
.accept 30690 >>Accept Unmasking the Yaungol
.target Shado-Master Chong
step
#completewith KobaiTrapMask
.goto 379,44.51,89.06,12 >> Leave the Castle
step
#sticky
#label KobaiTrapMask
.complete 30690,1 
step
#label KobaiTrap
#completewith KobaiTrapMask
#loop
.goto 379,44.94,86.47,20,0
.goto 379,45.14,85.98,20,0
.goto 379,45.51,85.53,20,0
.goto 379,45.82,86.57,20,0
.goto 379,45.49,86.96,20,0
.goto 379,44.94,86.47,0
.goto 379,45.14,85.98,0
.goto 379,45.51,85.53,0
.goto 379,45.82,86.57,0
.goto 379,45.49,86.96,0
.cast 118938 >>Use |T537467:0|t[Blinding Rage Trap] near |cRXP_ENEMY_Kobai.|r
.mob Kobai
.use 81741
step
.isOnQuest 30690
#requires KobaiTrap
#completewith KobaiTrapMask
.goto 379,45.44,85.47
.cast 118984 >>Pull |cRXP_ENEMY_Kobai|r inside the Trap and use |T133564:0|t[Blinding Rage Trap] on |cRXP_ENEMY_Kobai|r to steal his mask.
.use 118984
.mob Kobai
step
#requires KobaiTrapMask
>>Kill |cRXP_ENEMY_Malevolent Fury|r
.complete 30690,2 
.mob malevolent fury
step
#completewith next
.goto 379,44.51,89.06,12 >> Enter the Castle
step
.goto 379,44.48,89.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shado-Master Chong|r
.turnin 30690 >>Turn in Unmasking the Yaungol
.target Shado-Master Chong
.accept 30699 >>Accept To Winter's Blossom
step
#completewith next
.goto 379,45.13,89.98,10 >> Leave the Castle
step << Horde
#completewith next
.goto 379,62.70,80.45
.cooldown item,6948,>0,1
.hs >>Use your Heartstone to Eastwind Rest
step << Horde
.goto 379,62.32,80.21
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_General Nazgrim|r
.turnin 30655 >>Turn in Pandaren Prisoners
.turnin 30661 >>Turn in The Ordo Warbringer
.target General Nazgrim
step << Horde
.goto 379,62.77,79.91
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rivett Clutchpop|r
.turnin 30656 >>Turn in Barrels of Fun
.target Rivett Clutchpop
step << Horde
.goto 379,62.69,80.66
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shademaster Kiryn|r
.accept 31459 >>Accept Cho's Missive
.target Shademaster Kiryn
step << Horde
.goto 379,62.32,80.21
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_General Nazgrim|r
.turnin 30655 >>Turn in Pandaren Prisoners
.turnin 30661 >>Turn in The Ordo Warbringer
.target General Nazgrim
step
.goto 379,65.48,60.84
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Slimy Inkstain|r
.turnin 30614 >>Turn in Oil Stop
.target Slimy Inkstain
step
.goto 379,64.71,61.76,0,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lucky Eightcoins|r
.turnin 30808 >>Turn in A Grummle's Luck
.target Lucky Eightcoins
step
.goto 379,64.89,60.5
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Smokey Sootassle|r
.turnin 30616 >>Turn in Traffic Issues
.accept 30617 >>Accept Roadside Assistance
.target Smokey Sootassle
step
#loop
.goto 379,64.11,59.07,20,0
.goto 379,62.91,62.03,20,0
.goto 379,62.85,63.05,20,0
.goto 379,62.79,63.80,20,0
.goto 379,62.95,64.57,20,0
.goto 379,62.44,64.45,20,0
.goto 379,62.04,64.90,20,0
.goto 379,61.73,65.37,20,0
.goto 379,61.18,65.59,20,0
.goto 379,60.37,66.00,20,0
.goto 379,59.96,65.27,20,0
.goto 379,59.33,65.10,20,0
.goto 379,58.91,64.33,20,0
.goto 379,59.00,63.81,20,0
.goto 379,58.73,63.09,20,0
.goto 379,58.81,62.48,20,0
.goto 379,58.34,62.13,20,0
.goto 379,58.35,61.63,20,0
.goto 379,62.91,62.03,0
.goto 379,62.85,63.05,0
.goto 379,62.79,63.80,0
.goto 379,62.95,64.57,0
.goto 379,62.44,64.45,0
.goto 379,62.04,64.90,0
.goto 379,61.73,65.37,0
.goto 379,61.18,65.59,0
.goto 379,60.37,66.00,0
.goto 379,59.96,65.27,0
.goto 379,59.33,65.10,0
.goto 379,58.91,64.33,0
.goto 379,59.00,63.81,0
.goto 379,58.73,63.09,0
.goto 379,58.81,62.48,0
.goto 379,58.34,62.13,0
.goto 379,58.35,61.63,0
>>Click on |cRXP_PICK_Lucky Burlap Incense|r |cRXP_WARN_(possible while mounted)|r
.complete 30617,1 
step
.goto 379,58.1,61.48
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brother Trailscenter|r
.turnin 30617 >>Turn in Roadside Assistance
.accept 30592 >>Accept The Burlap Trail: To Burlap Waystation
.target Brother Trailscenter
step
.goto 379,57.34,61.69
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lorewalker Cho|r
.turnin 31459 >>Turn in Cho's Missive
.target Lorewalker Cho
.accept 30999 >>Accept Path Less Traveled
step
.goto 379,57.21,61.19
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Uncle Cloverleaf|r
.turnin 30999 >>Turn in Path Less Traveled
.target Uncle Cloverleaf
.accept 30601 >>Accept Instant Courage
step
#completewith next
.goto 379,57.5,60.17 >> Enter the House
step
.goto 379,57.72,61.77
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Big Sal|r |cRXP_WARN_inside the small house.|r
.accept 30618 >>Accept Resupplying One Keg
.target Big Sal
step
.goto 379,57.37,60.00
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Chiyo Mistpaw|r |cRXP_WARN_inside the house.|r
.home >>Set your Hearthstone to The Lucky Traveller
.target Chiyo Mistpaw
step
.goto 379,57.33,60.19
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ji-Lu the Lucky|r |cRXP_WARN_inside the house.|r
.accept 30621 >>Accept They Stole My Luck!
.target Ji-Lu the Lucky
step
#completewith next
.goto 379,57.5,60.17,5 >> Leave the House
step
#completewith Stolen Sprite Treasure
>>Kill |cRXP_ENEMY_Mischievous Snow Sprite|r and |cRXP_ENEMY_Suspicious Snow Pile|r
.complete 30621,4 
.complete 30621,1 
.complete 30621,2 
.complete 30621,3 
.mob Mischievous Snow Sprite
.mob Suspicious Snow Pile
step
#completewith Stolen Sprite Treasure
>>Click on |cRXP_PICK_Stolen Supplies|r
.complete 30618,1 
step
#completewith Stolen Sprite Treasure
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hiding Guides|r
.complete 30601,1 
.skipgossip
.target Hiding Guide
step
>>|cRXP_WARN_Follow the way into the cave|r
.isOnQuest 30601
#label Stolen Sprite Treasure
.goto 379,59.1,52.86,30,0
.goto 380,67.33,77.53,30,0
.goto 380,53.37,69.48,30,0
.goto 380,50.97,63.32,30,0
.goto 380,46.7,57.95,30,0
.goto 380,51.65,44.26,30,0
.goto 380,53.14,25.91,30,0
.goto 380,42.65,20.78,30,0
.goto 380,32.2,31.27,30,0
.goto 380,33.46,42.71,30,0
.goto 380,41.56,43.94
.turnin 31415 >> Click on the |cRXP_PICK_Stolen Sprite Treasure.|r
step
#completewith Lucky
#hidewindow
#loop
.goto 380,33.53,41.3,30,0
.goto 380,36.82,29.36,30,0
.goto 380,42.6,24.98,30,0
.goto 380,53.88,45.19,30,0
.goto 380,66,49.91,30,0
.goto 380,48.42,58.72,30,0
.goto 380,58.72,75.11,30,0
.goto 380,67.86,78.37,30,0
.goto 379,59.1,53.18,30,0
.goto 380,33.53,41.3,0
.goto 380,36.82,29.36,0
.goto 380,42.6,24.98,0
.goto 380,53.88,45.19,0
.goto 380,66,49.91,0
.goto 380,48.42,58.72,0
.goto 380,58.72,75.11,0
.goto 380,67.86,78.37,0
.goto 379,59.1,53.18,0
+1
step
#completewith Hiding Guide
>>Kill |cRXP_ENEMY_Mischievous Snow Sprite|r and |cRXP_ENEMY_Suspicious Snow Pile|r Loot them for |cRXP_LOOT_Lucky's Items|r
.complete 30621,4 
.complete 30621,1 
.complete 30621,2 
.complete 30621,3 
.mob Mischievous Snow Sprite
.mob Suspicious Snow Pile
step
#completewith Hiding Guide
>>Click on |cRXP_PICK_Stolen Supplies|r
.complete 30618,1 
step
#label Hiding Guide
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hiding Guides|r
.complete 30601,1 
.skipgossip
.target Hiding Guide
step
#completewith next
>>Kill |cRXP_ENEMY_Mischievous Snow Sprite|r and |cRXP_ENEMY_Suspicious Snow Pile|r Loot them for |cRXP_LOOT_Lucky's Items|r
.complete 30621,4 
.complete 30621,1 
.complete 30621,2 
.complete 30621,3 
.mob Mischievous Snow Sprite
.mob Suspicious Snow Pile
step
>>Click on |cRXP_PICK_Stolen Supplies|r
.complete 30618,1 
step
#label Lucky
>>Kill |cRXP_ENEMY_Mischievous Snow Sprite|r and |cRXP_ENEMY_Suspicious Snow Pile.|r Loot them for |cRXP_LOOT_Lucky's Items|r
.complete 30621,4 
.complete 30621,1 
.complete 30621,2 
.complete 30621,3 
.mob Mischievous Snow Sprite
.mob Suspicious Snow Pile
step
.isOnQuest 30621
.goto 380,34.24,35.09
.deathskip >> Die and ress at the spirit healer
step
#completewith TheyStoleMyLuck
.goto 379,57.5,60.17,5 >> Enter the House
step
#label TheyStoleMyLuck
.goto 379,57.32,60.19
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ji-Lu the Lucky|r |cRXP_WARN_inside small house.|r
.turnin 30621 >>Turn in They Stole My Luck!
.target Ji-Lu the Lucky
step
.goto 379,57.72,61.76
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Big Sal|r
.turnin 30618 >>Turn in Resupplying One Keg
.target Big Sal
step
.goto 379,57.22,61.21
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Uncle Cloverleaf|r
.turnin 30601 >>Turn in Instant Courage
.accept 30487 >>Accept Comin' Round the Mountain
.target Uncle Cloverleaf
step
.isOnQuest 30487
#completewith ZuldazarTheTempleofRezan
>>Repair your gear
.goto 379,57.43,61.75
.vendor
step
.goto 379,57.30,61.55
>>Click on |cRXP_FRIENDLY_Ji-Lu's Cart|r
.complete 30487,1 
.timer 125,RP
.target Ji-Lu's Cart
step
.goto 379,48.13,48.92
>>Wait for the roleplay
.complete 30487,2 
step
.goto 379,48.13,49.04
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lucky Bluestring|r
.turnin 30487 >>Turn in Comin' Round the Mountain
.target Lucky Bluestring
.accept 30683 >>Accept One Traveler's Misfortune
step
.goto 379,50.07,49.25
>>Click on |cRXP_PICK_Abandoned Wreakage.|r
.complete 30683,1 
.timer 9,RP
step
.goto 379,50.07,49.37
>>Kill |cRXP_ENEMY_Stone Guardians|r then |cRXP_ENEMY_General Sho Lien.|r
.complete 30683,2 
.mob general sho lien
.mob Stone Guardian
step
.goto 379,48.14,49.05
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lucky Bluestring|r
.turnin 30683 >>Turn in One Traveler's Misfortune
.target Lucky Bluestring
.accept 30684 >>Accept Seeker's Folly
step
.goto 379,44.78,49.17
>>Click on the |cRXP_PICK_Shrine.|r
.complete 30684,1 
step
.goto 379,42.68,50.11
>>Click on the |cRXP_PICK_Shrine.|r
.complete 30684,2 
step
.goto 379,43.17,51.98
>>Click on the |cRXP_PICK_Shrine.|r
.complete 30684,3 
step
.goto 379,43.80,51.04
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lorewalker Cho|r
.turnin 30684 >>Turn in Seeker's Folly
.accept 30829 >>Accept The Tongue of Ba-Shon
.target Lorewalker Cho
step
#completewith Reclaimer Zuan B
+|cRXP_WARN_During quest downtime, maximize efficiency by focusing on the following activities based on your current needs:|r
*- Open |cRXP_FRIENDLY_|T1542852:0|t[Caches of Infinite Treasures]|r
*- Replace Old Gear
*- Extract Old Gems
*- Scrap Obsolete Gear
*- Combine Prismatic Gems
.use 211279
.usespell 436523
.usespell 433397
step
#completewith next
#label Reclaimer Zuan A
>>Kill |cRXP_ENEMY_Reclaimer Zuan|r
.complete 30829,1 
.mob Reclaimer Zuan
.mob Yachi
step
#completewith Reclaimer Zuan A
.goto 379,43.79,51.07
.gossipoption 40517 >>Talk to |cRXP_FRIENDLY_Lorewalker Cho|r
.timer 20,RP
.target Lorewalker Cho
step
#requires Reclaimer Zuan A
#label Reclaimer Zuan B
.goto 379,43.46,51.42
>>Kill |cRXP_ENEMY_Reclaimer Zuan|r
.complete 30829,1 
.skipgossipid 40517
.mob Reclaimer Zuan
.mob Yachi
step
.goto 379,43.77,51.11
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lorewalker Cho|r
.turnin 30829 >>Turn in The Tongue of Ba-Shon
.accept 30795 >>Accept Staying Connected
.target Lorewalker Cho
step
.goto 379,57.11,47.89
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Curious Text|r
.accept 30797 >>Accept It Was Almost Alive
.target Curious Text
step
.goto 379,57.11,47.89
>>Click on |cRXP_PICK_Torn Page|r
.complete 30797,1 
step
.goto 379,57.11,47.89
>>Use |T512479:0|t[The Tongue of Ba-Shon] near the book.
.complete 30795,1 
.use 81712
step
.goto 379,57.11,47.89
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Image of Lorewalker Cho|r
>>|cRXP_WARN_Use|r |T512479:0|t[The Tongue of Ba-Shon] |cRXP_WARN_if you can't see |cRXP_FRIENDLY_Image of Lorewalker Cho|r|r.
.turnin 30795 >>Turn in Staying Connected
.accept 30796 >>Accept An End to Everything
.turnin 30797 >>Turn in It Was Almost Alive
.accept 30799 >>Accept The Tomb of Shadows
.use 81712
.target Image of Lorewalker Cho
step
#loop
.goto 379,57.18,49.04,20,0
.goto 379,56.73,47.23,20,0
.goto 379,57.46,47.40,20,0
.goto 379,57.18,49.04,0
.goto 379,56.73,47.23,0
.goto 379,57.46,47.40,0
>>Kill |cRXP_ENEMY_Tormented Spirits|r
.complete 30796,1 
.mob tormented spirits
step
#title Enter Temple
#completewith next
.goto 379,55.88,46.21,10 >> Enter the Temple
step
.goto 379,57.07,45.03
>>Click on the |cRXP_PICK_Tablet|r
.complete 30799,3 
step
.goto 379,57.13,43.49
>>Click on the |cRXP_PICK_Tablet|r |cRXP_WARN_next to the statue.|r
.complete 30799,1 
step
.goto 379,56.36,43.45
>>Click on the |cRXP_PICK_Tablet|r |cRXP_WARN_under the pole.|r
.complete 30799,2 
step
#completewith next
.cast 118927 >>Use |T512479:0|t[The Tongue of Ba-Shon] to summon an |cRXP_FRIENDLY_Image of Lorewalker Cho.|r
step
.goto 379,55.88,46.21
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Image of Lorewalker Cho.|r
>>|cRXP_WARN_Use|r |T512479:0|t[The Tongue of Ba-Shon] |cRXP_WARN_if you can't see |cRXP_FRIENDLY_Image of Lorewalker Cho|r|r.
.turnin 30796 >>Turn in An End to Everything
.turnin 30799 >>Turn in The Tomb of Shadows
.accept 30798 >>Accept Breaking the Emperor's Shield
.target Image of Lorewalker Cho
.use 81712
step
#title Leave Temple
#completewith InterruptedSpiritbinding
#label LeaveTempleSpiritbinding
.goto 379,55.88,46.21,10 >> Leave the Temple
step
#title Enter Temple
#requires LeaveTempleSpiritbinding
#completewith InterruptedSpiritbinding
#label EnterTempleSpiritbinding
.goto 379,53.33,49.35,10 >> Enter the Temple
step
#completewith InterruptedSpiritbinding
#requires EnterTempleSpiritbinding
.goto 379,52.98,51.25,15 >> |cRXP_WARN_Follow the Arrow|r
step
#label InterruptedSpiritbinding
.goto 379,52.93,51.34
>>Kill |cRXP_ENEMY_Imperial Guards|r and |cRXP_ENEMY_Nakk'rakas.|r
.complete 30798,1 
.mob Imperial Guard
.mob Nakk'rakas
step
#completewith next
.cast 118927 >>Use |T512479:0|t[The Tongue of Ba-Shon] to summon an |cRXP_FRIENDLY_Image of Lorewalker Cho.|r
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Image of Lorewalker Cho.|r
>>|cRXP_WARN_Use|r |T512479:0|t[The Tongue of Ba-Shon] |cRXP_WARN_if you can't see |cRXP_FRIENDLY_Image of Lorewalker Cho|r|r.
.turnin 30798 >>Turn in Breaking the Emperor's Shield
.accept 30800 >>Accept Stealing Their Thunder King
.target Image of Lorewalker Cho
.use 81712
step
#completewith BottomFragment
#label LeaveTempleBottomFragment
.goto 379,53.33,49.35,10 >> Leave the Temple
step
#completewith BottomFragment
#requires LeaveTempleBottomFragment
.goto 379,53.07,46.44,10 >> Enter the Temple
step
#label BottomFragment
.goto 385,84.12,61.59,10,0
.goto 385,81.57,74.06,10,0
.goto 385,58.66,72.54
>>Click on |cRXP_PICK_King's Coffer|r
.complete 30800,1 
step
.goto 385,39.71,69.08,10,0
.goto 385,34.33,61.67
>>Click on |cRXP_PICK_Tablet|r on the wall.
.complete 30800,2 
.mob Terracotta Gladiator
step
#completewith next
.cast 118927 >>Use |T512479:0|t[The Tongue of Ba-Shon] to summon an |cRXP_FRIENDLY_Image of Lorewalker Cho.|r
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Image of Lorewalker Cho.|r
>>|cRXP_WARN_Use|r |T512479:0|t[The Tongue of Ba-Shon] |cRXP_WARN_if you can't see |cRXP_FRIENDLY_Image of Lorewalker Cho|r|r.
.turnin 30800 >>Turn in Stealing Their Thunder King
.accept 30801 >>Accept Lessons from History
.target Image of Lorewalker Cho
.use 81712
step
.goto 385,34.33,61.67
>>Click on |cRXP_PICK_Tablet|r on the wall.
.complete 30801,1 
step
#completewith next
.cast 118927 >>Use |T512479:0|t[The Tongue of Ba-Shon] to summon an |cRXP_FRIENDLY_Image of Lorewalker Cho.|r
step
.goto 385,33.44,62.75
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Image of Lorewalker Cho|r
>>|cRXP_WARN_Use|r |T512479:0|t[The Tongue of Ba-Shon] |cRXP_WARN_if you can't see |cRXP_FRIENDLY_Image of Lorewalker Cho|r|r.
.turnin 30801 >>Turn in Lessons from History
.accept 30802 >>Accept Chasing the Storm
.target Image of Lorewalker Cho
.use 81712
step
#loop
.goto 385,53.79,72.07,20,0
.goto 385,58.69,85.70,20,0
.goto 385,66.66,74.20,20,0
.goto 385,61.77,59.20,20,0
.goto 385,81.60,75.95,20,0
.goto 385,53.79,72.07,0
.goto 385,58.69,85.70,0
.goto 385,66.66,74.20,0
.goto 385,61.77,59.20,0
.goto 385,81.60,75.95,0
>>Kill |cRXP_ENEMY_Zandalari Warrior.|r Loot them for |cRXP_LOOT_Blood-Revealed Map.|r
.complete 30802,1 
.mob Zandalari Warrior
step
#completewith next
.cast 118927 >>Use |T512479:0|t[The Tongue of Ba-Shon] to summon an |cRXP_FRIENDLY_Image of Lorewalker Cho.|r
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Image of Lorewalker Cho|r
>>|cRXP_WARN_Use|r |T512479:0|t[The Tongue of Ba-Shon] |cRXP_WARN_if you can't see |cRXP_FRIENDLY_Image of Lorewalker Cho|r|r.
.turnin 30802 >>Turn in Chasing the Storm
.target Image of Lorewalker Cho
.use 81712
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#subgroup Chromie Time (Veteran Player)
#name h) Horde Spires of Arak
#displayname |cFFFCDC00Chapter 8|r - Spires of Arak
#next i) Horde Gorgrond
#veteran
<< Horde
step
.zoneskip 590
#completewith next
.cast 171253 >>Use your Garrison Hearthstone
step
.goto 590,50.85,50.68
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Murla Longeye|r
.accept 36862 >>Accept Pinchwhistle Gearworks
.target Murla Longeye
step
>>Open the Adventure Guide (Shift + J), click on the right arrow until you see 'Spires of Arak', click 'Start Quest'
.accept 36951 >>Accept Arakkoa Exodus
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bron Skyhorn|r the Flight Master to be flown out to Spires of Arak.
.skipgossip 3
.turnin 36951 >> Turn in Arakkoa Exodus
.accept 34655 >> Accept Password spoken to Reshad
.goto 542,37.89,18.02
.target Bron Skyhorn
step
.goto 542,36.81,17.14
.turnin 36243 >>Loot the Outcast's Belongings within the mountains
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Reshad|r
.target Reshad
.goto 542,43.65,12.93
.skipgossip 79519
.complete 36243,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Reshad|r
.target Reshad
.goto 542,43.65,12.93
.turnin 34655 >>Turn in The Shadows of Skettis
.accept 34656 >>Accept Hidden in Plain Sight
.accept 34657 >>Accept Adherents of the Sun God
step
#completewith SpiresofArakHiddenInPlainSight
>>Kill |cRXP_ENEMY_Adherent Bladewings|r
.complete 34657,1 
step
>>Pick up the Wingblades
.goto 542,41.23,16.27
.complete 34656,1 
step
>>|cRXP_WARN_Keep the item for later|r
.goto 542,43.91,15.03
.turnin 36395 >>Pick up the Elixir of Shadow Sight
step
#label SpiresofArakHiddenInPlainSight
>>Pick up the Ragged Mask
.goto 542,44.93,15.14
.complete 34656,2 
step
>>Kill |cRXP_ENEMY_Adherent Bladewings|r
.goto 542,45.62,13.06,25,0
.goto 542,43.63,14.16,30,0
.goto 542,41.56,16.22,30,0
.goto 542,45.62,13.06
.complete 34657,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Reshad|r
.target Reshad
.goto 542,43.65,12.93
.turnin 34656 >>Turn in Hidden in Plain Sight
.turnin 34657 >>Turn in Adherents of the Sun God
.accept 34658 >>Accept Orders From On High
step
>>Kill |cRXP_ENEMY_Sun-Sage Rathyx. Loot him for the proclamation
*When he or his bird cast Blinding Flash/Flash Bang |cRXP_WARN_look away|r
*|cRXP_WARN_Interrupt Solar Radiance (50% heal)|r
.goto 542,45.97,15.43
.complete 34658,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Reshad|r
.target Reshad
.goto 542,45.39,18.26
.turnin 34658 >>Turn in Orders From On High
.accept 34659 >>Accept The Crone
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Reshad again
.goto 542,45.39,18.26
.skipgossip 1
.train 78670 >>Train Apprentice Archaeology
step
.goto 542,42.96,16.37
.turnin 36245 >>Pick up the Relics of the Outcasts
step
.goto 542,42.70,18.32
.turnin 36244 >>Pick up the Misplaced Scrolls
step
.goto 542,50.51,22.10
.turnin 36246>>Pick up the Fractured Sunstone in the water
step
>>Try to not loot it just close the loot window. This skips the knockup
.goto 542,50.32,25.80
.turnin 36444 >>Pick up the Iron Horde Explosives
step
.goto 542,50.75,28.74
.turnin 36247 >>Pick up the Lost Herb Satchel
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ornekka|r
.target Ornekka
.goto 542,51.62,31.37
.skipgossip 79890,1
.complete 34659,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Ornekka and Reshad
.goto 542,51.62,31.37
.turnin 34659 >>Turn in The Crone
.accept 34756 >>Accept A Charming Deception
.accept 35636 >>Accept All Due Respect
.accept 34805 >>Accept Echo Hunters
step
#completewith SpiresofArakAllDueRespect
>>Kill |cRXP_ENEMY_Echo Hunters|r
.complete 34805,1 
step
#title Illusion Charm 1
>>Pick up the Illusion Charm
.goto 542,50.97,31.31
.complete 34756,1,1 
step
#title Illusion Charm 2
>>Pick up the Illusion Charm
.goto 542,51.31,33.58
.complete 34756,1,2 
step
#title Illusion Charm 3
>>Pick up the Illusion Charm
.goto 542,51.83,36.40
.complete 34756,1,3 
step
#title Illusion Charm 4
>>Pick up the Illusion Charm
.goto 542,51.13,36.50
.complete 34756,1,4 
step
>>Interact with the corpse of Syth
.goto 542,50.26,36.38
.complete 35636,1 
step
>>Interact with Syth's Bookcase. Defeat the three incoming waves afterwards
*If you see Echo Hunter nearby, kill them
.goto 542,50.02,36.73
.complete 35636,2 
step
#label SpiresofArakAllDueRespect
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Reshad|r
.target Reshad
.goto 542,50.28,36.70
.turnin 35636 >>Turn in All Due Respect
.accept 35668 >>Accept Syth's Secret
step
#completewith SpiresofArakSythsSecret
>>Kill |cRXP_ENEMY_Echo Hunters|r
.goto 542,50.46,34.97,20,0
.goto 542,51.27,38.71,30,0
.complete 34805,1 
step
#title Illusion Charm 5
>>Pick up the Illusion Charm
.goto 542,50.40,40.05
.complete 34756,1,5 
step
.goto 542,49.20,37.30
.turnin 36445 >>Pick up Assassin's Spear
step
#completewith next
.goto 542,49.06,41.26,10 >>Enter the cave
step
#label SpiresofArakSythsSecret
>>Kill |cRXP_ENEMY_Sun-Talon Oberyx|r. Loot him for his eye
*Dodge the chakrams (void zones)
.goto 542,48.34,42.87
.complete 35668,1 
step
>>Kill |cRXP_ENEMY_Echo Hunters|r
.goto 542,47.79,42.68,25,0
.goto 542,48.90,43.08,25,0
.goto 542,50.04,39.01
.complete 34805,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Reshad|r
.target Reshad
.goto 542,48.56,44.48
.turnin 34756 >>Turn in A Charming Deception
.turnin 34805 >>Turn in Echo Hunters
.turnin 35668 >>Turn in Syth's Secret
.accept 35671 >>Accept A Gathering of Shadows
step
#completewith next
.use 115463
.cast 170183 >>Use the Elixier of Shadow Sight
step
.goto 542,48.58,44.49
.turnin 36386 >>Pick up the Gift of Anzu
step
>>Wait at the waypoint
.goto 542,46.51,45.61
.complete 35671,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Shadow-Sage Iskar
.goto 542,46.51,45.61
.turnin 35671 >>Turn in A Gathering of Shadows
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shadow Hunter Ukambe|r
.target Shadow Hunter Ukambe
.goto 542,45.89,46.37
.accept 35272 >>Accept One of Our Own
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Shadow-Sage Iskar
.goto 542,46.51,45.61
.skipgossip
.complete 35272,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shadow Hunter Ukambe|r
.target Shadow Hunter Ukambe
.goto 542,45.89,46.36
.turnin 35272 >>Turn in One of Our Own
.accept 35275 >>Accept Inspecting the Troops
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shadow Hunter Ukambe|r
.target Shadow Hunter Ukambe
.goto 542,40.07,44.05
.turnin 35275 >>Turn in Inspecting the Troops
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taskmaster Gornek|r
.target Taskmaster Gornek
.goto 542,40.19,43.50
.accept 35277 >>Accept Orders, Commander?
step
>>Interact with the Drafting Table and select 'Home Away From Home' (Hearthfire Tavern on the left)
.goto 542,40.19,43.50
.complete 35277,1 
.complete 35277,2 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taskmaster Gornek|r
.target Taskmaster Gornek
.goto 542,40.18,43.50
.turnin 35277 >>Turn in Orders, Commander?
.accept 37326 >>Accept Befriending the Locals
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Percy|r
.target Percy
.goto 542,40.10,43.97
.accept 35611 >>Accept Return to Veil Terokk
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Dusk-Seer Irizzar
.goto 542,43.90,48.91
.turnin 37326 >>Turn in Befriending the Locals
.accept 37296 >>Accept A Lack of Wasps
step
>>Kill |cRXP_ENEMY_Widow Wasps|r
.goto 542,44.63,49.50,20,0
.goto 542,43.23,50.56,20,0
.goto 542,43.53,47.20
.complete 37296,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Dusk-Seer Irizzar
.goto 542,43.90,48.92
.turnin 37296 >>Turn in A Lack of Wasps
.accept 37328 >>Accept Not Here, Not Now
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Reshad and Shadow-Sage Iskar
.turnin 35611 >>Turn in Return to Veil Terokk
.accept 34998 >>Accept Talon Watch
.accept 34884 >>Accept The Kaliri Whisperer
.goto 542,45.87,45.73
.accept 34827 >>Accept Last of the Talonpriests
.goto 542,45.94,45.78
step
.goto 542,45.94,44.17
.turnin 36354 >>Pick up Relics of the Outcasts on the rope
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tInteract with Skizziks corpse
.goto 542,45.43,36.32
.skipgossip
.complete 34884,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Skizzik and the Kaliri Egg
.accept 34885 >>Accept Mother of Thorns
.goto 542,45.43,36.32
.accept 34838 >>Accept Ikky's Egg
.goto 542,45.39,36.74
step
>>Click on the egg
.goto 542,45.39,36.74
.complete 34838,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalkTalk to Ikky
.goto 542,45.39,36.74
.turnin 34838 >>Turn in Ikky's Egg
.accept 34886 >>Accept Baby Bird
step
#completewith next
>>Kill |cRXP_ENEMY_Shadeback Ravagers|r and pick up Ravager Grubs
.complete 34886,1 
.complete 34885,1 
step
>>Kill the |cRXP_ENEMY_Shadeback Thornmother|r
.goto 542,44.19,37.96
.complete 34885,2 
step
>>Kill |cffShadeback Ravager|r and pick up Ravager Grubs (small maggots)
.goto 542,45.10,37.92
.complete 34886,1 
.complete 34885,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ikky|r
.target Ikky
.goto 542,45.40,36.75
.turnin 34886 >>Turn in Baby Bird
step
.goto 542,47.77,36.11
.turnin 36411 >>Pick up the Lost Ring in the water
step
>>Use the |T134711:0|t[Elixier of Shadows]
.use 112100
.goto 542,47.98,34.69
.complete 34827,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Talonpriest Ishaal|r
.target Talonpriest Ishaal
.goto 542,48.01,34.76
.turnin 34827 >>Turn in Last of the Talonpriests
.accept 34828 >>Accept Ishaal's Orb
.accept 34829 >>Accept New Neighbors
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ravager Egg|r
.target Ravager Egg
.goto 542,47.13,31.66
.accept 36425 >>Accept Egg Punt
step
#completewith SpiresofArakIshaalsOrb
>>Kill |cRXP_ENEMY_Shattered Hand Orcs|r
.complete 34829,1 
step
#completewith SpiresofArakIshaalsOrb
>>Click on the Ravager Eggs on the ground
.complete 36425,1 
step
.goto 542,47.93,30.66
.turnin 36361 >>Pick up the Shattered Hand Lockbox
step
#label SpiresofArakIshaalsOrb
>>Pick up Ishaal's Orb
.goto 542,48.09,28.47
.complete 34828,1 
step
#completewith next
>>Kill |cRXP_ENEMY_Shattered Hand Orcs|r
*|cRXP_WARN_Dodge the Blade Flurries to the side|r
.complete 34829,1 
step
>>Click on the Ravager Eggs on the ground
.goto 542,46.62,29.37,25,0
.goto 542,47.14,31.56,25,0
.goto 542,47.33,30.56
.complete 36425,1 
step
>>Finish killing |cRXP_ENEMY_Shattered Hand Orcs|r
.goto 542,47.33,30.56
.complete 34829,1 
step
#sticky
#label SpiresofArakEggPunt
>>Click on the quest in the quest log under your minimap
.turnin 36425 >>Turn in Egg Punt
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Talonpriest Ishaal|r
.target Talonpriest Ishaal
.goto 542,48.01,34.75
.turnin 34828 >>Turn in Ishaal's Orb
.turnin 34829 >>Turn in New Neighbors
.accept 34830 >>Accept Behind the Veil
step
.goto 542,46.92,34.04
.turnin 36446 >>Pick up the Outcast's Poach from the dead Arrakoa Outcast on the tree
step
>>Use the |T134711:0|t[Major Elixir of Shadows]
.use 112099
.goto 542,44.48,24.01
.complete 34830,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Talonpriest Zellek|r
.target Talonpriest Zellek
.goto 542,44.48,24.01
.turnin 34830 >>Turn in Behind the Veil
step
.goto 542,43.82,24.63
.turnin 36397 >>Pick up the Elixir of Shadow Sight
step
.goto 542,43.21,27.26
.turnin 36355 >>Pick up the Relics of the Outcasts located in the trees.
step
#completewith next
.cast 168499 >>Use Home Away From Home (|cRXP_WARN_Zone Ability not your Hearthstone|r)
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taskmaster Gornek|r
.target Taskmaster Gornek
.goto 542,40.19,43.50
.turnin 37328 >>Turn in Not Here, Not Now
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ikky|r
.target Ikky
.goto 542,46.20,45.69
.turnin 34898 >>Turn in Ikky
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Reshad|r
.target Reshad
.goto 542,45.87,45.74
.turnin 34884 >>Turn in The Kaliri Whisperer
.turnin 34885 >>Turn in Mother of Thorns
step
.goto 542,48.35,52.61
.turnin 36405 >>Pick up the Offering of the Raven Mother
step
#completewith next
.use 118267
.cast 174031 >>Use the Ravenmother Offering
step
.goto 542,48.91,54.71
.turnin 36406 >>Pick up the Offering of the Raven Mother
step
#completewith next
.use 118267
.cast 174031 >>Use the Ravenmother Offering
step
.goto 542,53.32,55.51
.turnin 36403 >>Pick up the Offering of the Raven Mother
step
#completewith next
.use 118267
.cast 174031 >>Use the Ravenmother Offering
step
.goto 542,60.97,63.88
.turnin 36410 >>Pick up the Offering of the Raven Mother
step
#completewith next
.use 118267
.cast 174031 >>Use the Ravenmother Offering
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Kimzee Pinchwhistle and Engineer Gazwitz
.goto 542,61.47,72.94
.turnin 36862 >>Turn in Pinchwhistle Gearworks
.accept 35077 >>Accept Defungination
.accept 35079 >>Accept Spore-be-Gone
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Exterminator Lemmy|r
.target Exterminator Lemmy
.goto 542,62.57,73.91
.accept 36179 >>Accept Unwanted Pests
step
#completewith SpiresofArakSporebeGone
>>Kill |cRXP_ENEMY_Sport Drifter|r. Avoid Fungal Hulks
.complete 36179,1 
step
#completewith SpiresofArakSporebeGone
>>Use the |T134538:0|t [QR58 Flame Blaster] to burn the yellow/green spores on the ground
.use 112683
.complete 35077,1 
step
#title Turret 1
>>Activate the turret
.goto 542,63.16,73.92,20,0
.goto 542,63.59,74.08
.complete 35079,1,1 
step
#title Turret 2
>>Activate the turret
.goto 542,64.49,74.26
.complete 35079,1,2 
step
#title Turret 3
>>Activate the turret
.goto 542,64.76,74.23
.complete 35079,1,3 
step
#title Turret 4
>>Activate the turret
.goto 542,64.36,75.01,15,0
.goto 542,63.72,74.94
.complete 35079,1,4 
step
#title Turret 5
>>Activate the turret
.goto 542,63.36,75.78
.complete 35079,1,5 
step
#label SpiresofArakSporebeGone
#title Turret 6
>>Activate the turret
.goto 542,63.63,76.41
.complete 35079,1 
step
#completewith next
>>Kill |cRXP_ENEMY_Sport Drifter|r. Avoid Fungal Hulks. The QR58 Flame Baster also damages these mobs
.complete 36179,1 
step
#completewith SpiresofArakSporebeGone
>>Use the |T134538:0|t[QR58 Flame Blaster] to burn the yellow/green spores on the ground
.use 112683
.goto 542,62.68,76.40,20,0
.goto 542,63.60,75.34,20,0
.goto 542,64.57,75.18,20,0
.goto 542,63.31,74.30
.complete 35077,1 
step
#completewith next
>>Kill |cRXP_ENEMY_Sport Drifter|r. Avoid Fungal Hulks
.goto 542,62.68,76.40,20,0
.goto 542,63.60,75.34,20,0
.goto 542,64.57,75.18,20,0
.goto 542,63.31,74.30
.complete 36179,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Kimzee Pinchwhistle and Engineer Gazwitz
.goto 542,61.46,72.95
.turnin 35077 >>Turn in Defungination
.turnin 35079 >>Turn in Spore-be-Gone
.turnin 36179 >>Turn in Unwanted Pests
.accept 35080 >>Accept The Mother Lode
step
.itemcount 132516,1
#completewith next
.cooldown item,132516,>0,1
.cast 202844 >>Use |T1405809:0|t[Gunshoes]
step
>>Follow the arrow
.goto 542,59.12,79.18
.complete 35080,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Kimzee Pinchwhistle and Engineer Gazwitz
.turnin 35080 >>Turn in The Mother Lode
.accept 35082 >>Accept Getting the Crew Back Together
.goto 542,59.12,79.18
.accept 35081 >>Accept Clearing Out Before Cleaning Up
.goto 542,59.10,79.23
step
#completewith SpiresofArakGettingtheCrewBackTogether
>>Kill |cRXP_ENEMY_Crimsonwing Wasps|r
.complete 35081,1 
step
#title Crew Revived 1
>>Click on the Injured Crewmans
.goto 542,60.25,79.77
.complete 35082,1,1 
step
#title Crew Revived 2
>>Click on the Injured Crewmans
.goto 542,60.43,80.66
.complete 35082,1,2 
step
#title Crew Revived 3
>>Click on the Injured Crewmans
.goto 542,60.19,81.49
.complete 35082,1,3 
step
#title Crew Revived 4
>>Click on the Injured Crewmans
.goto 542,60.54,81.65
.complete 35082,1,4 
step
#title Crew Revived 5
>>Click on the Injured Crewmans
.goto 542,60.43,82.33
.complete 35082,1,5 
step
#label SpiresofArakGettingtheCrewBackTogether
#title Crew Revived 6
>>Click on the Injured Crewmans
.goto 542,60.00,82.09
.complete 35082,1 
step
>>Kill |cRXP_ENEMY_Crimsonwing Wasps|r
.goto 542,59.20,81.89,25,0
.goto 542,60.91,82.22,20,0
.goto 542,59.91,80.80
.complete 35081,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Kimzee Pinchwhistle and Engineer Gazwitz
.goto 542,59.11,79.20
.turnin 35082 >>Turn in Getting the Crew Back Together
.turnin 35081 >>Turn in Clearing Out Before Cleaning Up
.accept 35285 >>Accept Follow that Hotrod!
step
>>Talk to Kimzee Pinchwhistle and Kimzee Pinchwhistle and Krixel Pinchwhistle
.turnin 35285 >>Turn in Follow that Hotrod!
.accept 35090 >>Accept The Right Parts for the Job
.accept 35089 >>Accept Skimming Off the Top
.goto 542,58.48,92.33
.accept 36384 >>Accept Field Trial
.goto 542,58.49,92.20
step
#completewith next
.goto 542,58.81,91.99
.vendor
step
.goto 542,59.15,90.63
.turnin 36366 >>Pick up the bottle in the small building
step
#completewith next
>>Kill |cRXP_ENEMY_Volatile Sludge|r. Loot them for the oil
.complete 35089,1 
step
>>Use the |T133032:0|t[G-14 Buster Rocket] to destroy Broken Shredder and pick up the spawning gears
.goto 542,59.32,89.90,20,0
.goto 542,59.81,87.54,20,0
.goto 542,58.95,88.51,20,0
.goto 542,58.29,89.51,20,0
.goto 542,57.94,90.36
.use 112698
.complete 35090,1 
step
>>Kill |cRXP_ENEMY_Volatile Sludge|r. Loot them for the oil
.goto 542,59.31,88.91
.complete 35089,1 
step
>>Use |T609895:0|t[Vial of Untested Serum] on an Infected Lumberjack
.goto 542,58.64,87.10
.use 115457
.complete 36384,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Krixel Pinchwhistle|r
.goto 542,58.49,92.21
.turnin 36384 >>Turn in Field Trial
.target Krixel Pinchwhistle
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kimzee Pinchwhistle|r
.target Kimzee Pinchwhistle
.goto 542,58.83,92.84
.turnin 35089 >>Turn in Skimming Off the Top
.turnin 35090 >>Turn in The Right Parts for the Job
.accept 35091 >>Accept Sporicide
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Krixel Pinchwhistle|r
.target Krixel Pinchwhistle
.goto 542,58.48,92.20
.accept 35211 >>Accept Preventing the Worst
.accept 36428 >>Accept Curing With Force
step
#completewith next
>>Kill |cRXP_ENEMY_Spore Shamblers|r
.complete 35091,1 
.mob Spore Shambler
step
#completewith next
>>Use |T609892:0|t[Vial of Refined Serum] on |cRXP_ENEMY_Infected Bruisers|r or |cRXP_ENEMY_Infected Bar Patrons|r below 30% HP
.use 115533
.complete 36428,1 
.mob Infected Bruiser
.mob Infected Bar Patron
step
#title Bomb Placed 1/5
>>Place the |cRXP_PICK_bomb|r inside the small building
.goto 542,56.62,89.99
.complete 35211,1,1 
step
#title Bomb Placed 2/5
>>Place the |cRXP_PICK_bomb|r
.goto 542,56.46,89.45
.complete 35211,1,2 
step
>>Kill |cRXP_ENEMY_Spore Shamblers|r
.goto 542,54.91,87.97
.complete 35091,1 
.mob Spore Shambler
step
#completewith SpiresofArakPreventingtheWorst
>>Use |T609892:0|t[Vial of Refined Serum] on |cRXP_ENEMY_Infected Bruisers|r or |cRXP_ENEMY_Infected Bar Patrons|r below 30 HP
.use 115533
.complete 36428,1 
step
#title Bomb Placed 3/5
>>Place the |cRXP_PICK_bomb|r
.goto 542,55.69,90.99
.complete 35211,1,3 
step
#title Bomb Placed 4/5
>>Place the |cRXP_PICK_bomb|r
.goto 542,56.29,91.61
.complete 35211,1,4 
step
#label SpiresofArakPreventingtheWorst
#title Bomb Placed 5/5
>>Place the |cRXP_PICK_bomb|r
.goto 542,56.74,91.56
.complete 35211,1 
step
>>Use |T609892:0|t[Vial of Refined Serum] on |cRXP_ENEMY_Infected Bruisers|r or |cRXP_ENEMY_Infected Bar Patrons|r below 30 HP
.use 115533
.goto 542,56.20,90.70,20,0
.goto 542,58.28,87.30,40,0
.goto 542,56.20,90.70
.complete 36428,1 
.mob Infected Bruiser
.mob Infected Bar Patron
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Kimzee Pinchwhistle and Krixel Pinchwhistle
.turnin 35091 >>Turn in Sporicide
.goto 542,58.82,92.83
.turnin 35211 >>Turn in Preventing the Worst
.turnin 36428 >>Turn in Curing With Force
.accept 35298 >>Accept Flame On
.goto 542,58.49,92.20
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Plunger|r
.goto 542,58.51,92.22
.complete 35298,1 
step
>>Mount the |cRXP_FRIENDLY_Repaired Flying Machine|r
.goto 542,58.87,92.86
.complete 35298,2 
.target Repaired Flying Machine
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kimzee Pinchwhistle|r
.goto 542,61.60,72.85
.turnin 35298 >>Turn in Flame On
.turnin 36062 >>Turn in Kimzee Pinchwhistle
.target Kimzee Pinchwhistle
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#subgroup Chromie Time (Veteran Player)
#name i) Horde Gorgrond
#displayname |cFFFCDC00Chapter 9|r - Gorgrond
#veteran
<< Horde
step
.zoneskip 590
#completewith FrostfireRidgeAcceptGutGuttra
.cast 171253 >>Use your Garrison Hearthstone
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Warmaster Zog|r next to the Innkeeper.
.accept 34462 >>Accept Winds of Change
.target Warmaster Zog
step
>>Mount up and fly east. Waypoints aren't able to be shown inside of a Garrison.
>>|TInterface/GossipFrame/HealerGossipIcon:0|tClick on |cRXP_FRIENDLY_Olin Umberhide|r inside the cave.
.goto 525,57.29,62.90
.complete 34462,1 
.target Olin Umberhide
step
#label FrostfireRidgeAcceptGutGuttra
.goto 525,66.02,49.07
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tFly east and talk to |cRXP_FRIENDLY_Outrider Urukag|r
.accept 33132 >>Accept Gut Guttra
.target Outrider Urukag
step
>>Kill |cRXP_ENEMY_Grimfrost Ogres|r and free |cRXP_FRIENDLY_Captured Frostwolves|r
.goto 525,66.33,47.49,20,0
.goto 525,67.19,49.06,20,0
.goto 525,67.96,48.51,30,0
.goto 525,67.14,46.70
.complete 33145,1 
.complete 33145,2 
.mob Grimfrost Wolfslayer
.mob Grimfrost Lavaslinger
.mob Grimfrost Drudge
.target Captured Frostwolf
step
>>Kill |cRXP_ENEMY_Guttra Wolfchew|r
.goto 525,68.27,45.53
.complete 33132,1 
.mob Guttra Wolfchew
step
.goto 525,66.06,49.07
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Outrider Urukag|r
.target Outrider Urukag
.turnin 33132 >>Turn in Gut Guttra
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tFly to Gorgrond and talk to |cRXP_FRIENDLY_Durotan|r
.goto 543,37.28,77.01
.accept 33543 >>Accept The Laughing Skull
.target Durotan
step
>>Follow the arrow
.goto 543,38.42,74.29
.complete 33543,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ripfist|r
.target Ripfist
.goto 543,38.77,73.62
.turnin 33543 >>Turn in The Laughing Skull
.accept 33544 >>Accept Goren, Goren, Gone!
step
#sticky
#label GorgrondAcidtoothDevourers
>>Kill |cRXP_ENEMY_Acidtooth Devourers|r and turn in the quest under your minimap
.goto 543,40.81,73.87,0,0
.complete 33544,1 
.turnin 33544 >>Turn in Goren, Goren, Gone!
.mob Acidtooth Devourer
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kaz the Shrieker|r
.target Kaz the Shrieker
.goto 543,39.33,71.98
.accept 33548 >>Accept We Die Laughing!
step
#title Mask 1/5
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Dead Laughing Skull|r
.goto 543,39.66,72.46
.complete 33548,1,1 
step
.goto 543,40.01,72.26
.turnin 36170 >>Pick up the |cRXP_PICK_bone|r
step
#title Mask 2/5
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Dead Laughing Skull|r
.goto 543,40.21,72.52
.complete 33548,1,2 
step
.goto 543,40.48,71.95
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Limbflayer|r
.target Limbflayer
.accept 33563 >>Accept Eye Candy
step
#title Mask 3/5
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Dead Laughing Skull|r
.goto 543,41.12,72.26
.complete 33548,1,3 
step
>>Kill |cRXP_ENEMY_Skothwa|r. Loot him for his eye
.goto 543,41.46,72.68
.complete 33563,1 
step
#title Mask 4/5
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Dead Laughing Skull|r
.goto 543,41.14,72.87
.complete 33548,1,4 
step
#title Mask 5/5
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Dead Laughing Skull|r
.goto 543,41.06,73.74
.complete 33548,1 
step
#requires GorgrondAcidtoothDevourers
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Limbflayer|r, |cRXP_FRIENDLY_Kaz|r and |cRXP_FRIENDLY_Durotan|r
.goto 543,41.48,74.13
.turnin 33563 >>Turn in Eye Candy
.turnin 33548 >>Turn in We Die Laughing!
.accept 33593 >>Accept A Flare for the Dramatic
.target Limbflayer
.target Kaz the Shrieker
.target Durotan
step
>>Use |T391128:0|t[Penny's Flare Gun]
.use 115534
.goto 543,41.38,74.10
.complete 33593,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Durotan|r
.target Durotan
*Skip the next cinematic with ESC
.goto 543,41.49,74.08
.turnin 33593 >>Turn in A Flare for the Dramatic
.accept 36434 >>Accept Penny From Heaven
step
.turnin 36621 >>Pick up the |cRXP_PICK_Explorer Canister|r in the water
.goto 543,40.37,76.60
step
.turnin 36658 >>Pick up the |cRXP_PICK_Evermorn Supply Cache|r
.goto 543,41.82,78.04
step
.turnin 35709 >>Pick up the |cRXP_PICK_Laughing Skull Cache|r on the tree.
.goto 543,44.19,74.23
step
.turnin 36118 >>Pick up the |cRXP_PICK_Pile of Rubble|r
.goto 543,43.94,70.49
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Penny Clobberbottom|r
.target Penny Clobberbottom
.goto 543,45.69,70.59
.turnin 36434 >>Turn in Penny From Heaven
.accept 36460 >>Accept Just Another Stick in the Wall
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with |cRXP_PICK_Penny's Plunger|r
.goto 543,45.69,70.59
.complete 36460,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Durotan|r
.target Durotan
.goto 543,45.86,70.30
.turnin 36460 >>Turn in Just Another Stick in the Wall
.accept 35151 >>Accept Your Base, Your Choice
step
*|cRXP_WARN_Select the right building 'Savage Fight Club'|r
.goto 543,45.85,70.26
.complete 35151,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Durotan|r
.target Durotan
.goto 543,46.10,70.19
.turnin 35151 >>Turn in Your Base, Your Choice
.accept 35880 >>Accept Rage and Wisdom
step
#completewith next
.goto 543,45.98,69.71
.home >>Set your Hearthstone to Beastwatch
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Limbflayer|r
.target Limbflayer
.goto 543,46.33,69.71
.accept 34697 >>Accept A Rediscovered Legend
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marrow|r
.target Marrow
.goto 543,46.29,69.98
.accept 35667 >>Accept Skulltakers in Crimson Fen
.accept 33694 >>Accept Reagents from Rakthoth
step
.itemcount 132516,1
#completewith next
.cooldown item,132516,>0,1
.cast 202844 >>Use |T1405809:0|t[Gunshoes]
step
#completewith next
>>You have 60 seconds to get the following 3 items after using the ability. |cRXP_WARN_Before using the ability pull some mobs and damage them until they have only ~20% HP left.
*Skip the ones you didn't get
.goto 543,45.26,79.82,30,0
.cast 164012 >>Use Champion's Honor (Zone Ability)
step
*1) Loot 'Ravager Claw' from |cRXP_ENEMY_Thicket Ravagers|r
*2) Loot 'Wasp Sting' from the |cRXP_ENEMY_Golden Pollinator|r
*3) Loot 'Orc Thorn' from the |cRXP_ENEMY_Vined Guardians|r
*Skip if you don't loot it after 60 seconds.
.goto 543,45.16,78.14,20,0
.goto 543,43.52,82.00,15,0
.goto 543,42.52,82.67,15,0
.goto 543,40.59,83.83,15,0
.goto 543,40.13,83.24,15,0
.collect 114032,1,36097,1
.collect 114034,1,36101,1
.collect 114027,1,36091,1
.accept 36097 >>Accept Proof of Strength: Ravager Claw
.accept 36101 >>Accept Proof of Strength: Wasp Stinger
.accept 36091 >>Accept Proof of Strength: Orc Thorn
.mob Thicket Ravager
.mob Golden Pllinator
.mob Vined Guardian
step
.goto 543,43.57,90.18
.accept 36520 >>Accept Tailthrasher Basin (Bonus Objective)
step
#completewith next
#title Destroy Rope Spikes
>>|TInterface/GossipFrame/HealerGossipIcon:0|tDestroy the |cRXP_PICK_Spikes|r to free the |cRXP_FRIENDLY_Acebeak|r
.goto 543,43.57,90.78,10,0
.complete 36520,2 
step
#completewith next
.goto 543,44.73,90.17,8 >>Enter the cave
step
>>Kill |cRXP_ENEMY_Skull Trash|r
.goto 543,44.43,88.89
.complete 36520,3 
.mob Skull Thrash
step
#sticky
#label GorgrondJungleAxebeakFreed
#title Destroy Rope Spikes
>>|TInterface/GossipFrame/HealerGossipIcon:0|tDestroy the |cRXP_PICK_Spikes|r to free the |cRXP_FRIENDLY_Acebeak|r
.goto 543,45.13,90.61,10,0
.goto 543,44.57,91.58,10,0
.goto 543,45.93,89.72,10,0
.complete 36520,2 
step
>>Kill |cRXP_ENEMY_Tailthrasher Saberons|r
.goto 543,44.18,91.01,0,0
.complete 36520,1 
.mob Tailthrasher Saberon
step
#requires GorgrondJungleAxebeakFreed
.goto 543,49.29,81.57
.accept 35881 >>Accept Ruins of the First Bastion (Bonus Objective)
step
#sticky
#label GorgrondFrenziedPodlingsSlain
>>Kill |cRXP_ENEMY_Frenzied Podlings|r
.goto 543,50.69,79.66,0,0
.complete 35881,1 
.mob Frenzied Podling
step
#title Ancient Jar 1/8
>>Pick up the |cRXP_PICK_Ancient Jar|r on the ground
.goto 543,49.72,80.42
.complete 35881,2,1 
step
#title Ancient Jar 2/8
>>Pick up the |cRXP_PICK_Ancient Jar|r on the ground
.goto 543,49.85,80.34
.complete 35881,2,2 
step
#title Ancient Jar 3/8
>>Pick up the |cRXP_PICK_Ancient Jar|r on the ground
.goto 543,50.57,80.09
.complete 35881,2,3 
step
#title Ancient Jar 4/8
>>Pick up the |cRXP_PICK_Ancient Jar|r on the ground
.goto 543,50.47,80.55
.complete 35881,2,4 
step
#title Ancient Jar 5/8
>>Pick up the |cRXP_PICK_Ancient Jar|r on the ground
.goto 543,51.09,80.96
.complete 35881,2,5 
step
#title Ancient Jar 6/8
>>Pick up the |cRXP_PICK_Ancient Jar|r on the ground
.goto 543,51.26,80.71
.complete 35881,2,6 
step
>>Kill |cRXP_ENEMY_Malkor|r
.goto 543,52.08,81.25
.complete 35881,3 
.mob Malkor
step
#title Ancient Jar 7/8
>>Pick up the |cRXP_PICK_Ancient Jar|r on the ground
.goto 543,51.74,80.49
.complete 35881,2,7 
step
#title Ancient Jar 8/8
>>Pick up the |cRXP_PICK_Ancient Jar|r on the ground
.goto 543,51.65,79.85
.complete 35881,2 
step
#requires GorgrondFrenziedPodlingsSlain
.goto 543,48.49,75.19
.accept 36500 >>Accept The Razorbloom (Bonus Objective)
step
#completewith next
>>Walk over the |cRXP_ENEMY_slimes|r
.complete 36500,3 
step
>>Kill the Infested in the area
.goto 543,48.38,73.97,20,0
.goto 543,47.12,74.81,20,0
.goto 543,47.04,73.27,20,0
.goto 543,47.85,72.54
.complete 36500,1 
.mob Infested Orc
.mob Infested Behemoth
step
#sticky
#label GorgrondToxicSlimemold
>>Walk over the |cRXP_FRIENDLY_slimes|r on your flying mount.
.goto 543,48.25,73.02,0,0
.complete 36500,3 
step
>>Kill the |cRXP_ENEMY_Voice of Iyu|r
.goto 543,49.43,71.65
.complete 36500,2 
.mob Voice of Iyu
step
#requires GorgrondToxicSlimemold
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bony Xuk|r
.target Bony Xuk
.goto 543,43.56,65.01
.turnin 35880 >>Turn in Rage and Wisdom
.accept 35248 >>Accept A Harsh Reminder
.accept 35035 >>Accept Seedbearers of Bad News
step
#completewith next
>>You have 60 seconds to get the following 3 items after using the ability. |cRXP_WARN_Before using the ability pull some mobs and damage them until they have only ~20% HP left.
*Skip the ones you didn't get
.cast 164012 >>Use Champion's Honor (Zone Ability)
step
*1) Loot 'Gronnling Scale' from |cRXP_ENEMY_'Gronnling Bonebreaker'|r
*2) Loot 'Acid-Stained Goren Tooth' from the |cRXP_ENEMY_'Goren Gouger'|r
*3) Loot 'Botani Bloom' from |cRXP_ENEMY_'Botani Greensworn'|r
*Skip the items you haven't looted after 60 seconds.
.goto 543,44.02,64.88,15,0
.goto 543,44.52,64.66,15,0
.goto 543,45.41,63.76,15,0
.collect 114021,1,36080,1
.collect 113590,1,35948,1
.collect 114025,1,36086,1
.accept 36080 >>Accept Proof of Strength: Gronnling Scale
.accept 35948 >>Accept Proof of Strength: Acid-Stained Goren Tooth
.accept 36086 >>Accept Proof of Strength: Botani Bloom
.mob Gronnling Bonebreaker
.mob Goren Gouger
.mob Botani Greensworn
step
#sticky
#label GorgrondDenizensOfWasteland
>>Kill |cRXP_ENEMY_Gronnlings|r, |cRXP_ENEMY_Ogrons|r, and |cRXP_ENEMY_Gorens|r
.goto 543,44.76,64.22,0,0
.complete 35248,1 
.mob Gronnling Bonebreker
.mob Goren Gouger
.mob Gorgrond Ogron
.mob Gronn Rockthrower
step
>>Burn the |cRXP_FRIENDLY_Ancients|r on your flying mount.
.goto 543,44.76,64.22
.complete 35035,1 
.target Ancient Seedbearer
step
#requires GorgrondDenizensOfWasteland
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bony Xuk|r
.target Bony Xuk
.goto 543,43.56,65.01
.turnin 35248 >>Turnin A Harsh Reminder
.turnin 35035 >>Turnin Seedbearers of Bad News
.accept 35025 >>Accept We Have Company
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kash'drakor|r, |cRXP_FRIENDLY_Beatface|r and |cRXP_FRIENDLY_Akaani|r
.goto 543,42.77,63.12
.accept 36603 >>Accept Brimstone Springs
.turnin 34697 >>Turn in A Rediscovered Legend
.accept 34698 >>Accept Slave Hunters
.accept 34700 >>Accept Nazgrel
.accept 34702 >>Accept Krav'ogra
.accept 34699 >>Accept Getting Gladiators
.target Kash'drakor
.target Beatface
.target Akaani
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Prowler Sasha|r
.target Prowler Sasha
.goto 543,41.42,66.11
.accept 34012 >>Accept Need More Teeth
step
#sticky
#label GorgrondOgreTeeth
>>Kill |cRXP_ENEMY_Ogres|r. Loot them for their |cRXP_LOOT_teeth|r
.goto 543,38.94,68.04,0,0
.complete 34012,1 
step
>>Kill |cRXP_ENEMY_Slave Hunter Krag|r at the top of the building. Loot him for his |cRXP_LOOT_pendant|r
.goto 543,41.12,66.23
.complete 34698,2 
.mob Slave Hunter Krag
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tBreak the |cRXP_PICK_Shackles|r to free |cRXP_FRIENDLY_Bruto|r
.goto 543,40.30,64.83
.complete 34699,3 
step
>>Kill |cRXP_FRIENDLY_Slave Hunter Brol|r. Loot him for his |cRPX_LOOT_pendant|r
.goto 543,40.47,66.70
.complete 34698,1 
.mob Slave Hunter Brol
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Gong|r until |cRXP_ENEMY_Slavemaster Ok'mok|r jumps down
*You have to use the Gong three times and after each use you've to kill an NPC
.goto 543,40.40,67.56
.complete 34702,1 
.mob Slavemaster Ok'mok
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tBreak the |cRXP_PICK_Shackles|r to free |cRXP_FRIENDLY_Y'kish|r
.goto 543,39.75,67.83
.complete 34699,2 
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tBreak the |cRXP_PICK_Shackles|r to free |cRXP_FRIENDLY_Vaandaam|r inside the hut
.goto 543,39.17,67.23
.complete 34699,1 
step
>>Kill |cRXP_ENEMY_Slave Hunter Mol|r inside the tower. Loot him for his |cRXP_LOOT_pendant|r
.goto 543,38.99,68.73
.complete 34698,3 
.mob Slave Hunter Mol
step
#completewith next
.goto 543,38.58,67.38,10 >>Enter the cave
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bruto|r
.goto 543,36.85,67.90
.turnin 34699 >>Turn in Getting Gladiators
.accept 34703 >>Accept The Axe of Kor'gall
.target Bruto
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tBreak down the |cRXP_PICK_Barricade|r and cross the bridge to the throne.
*|cRXP_WARN_If you're not confident then wait for your cooldown before you attack |cRXP_ENEMY_Kor'gall|r|r: Loot him for his |cRXP_LOOT_axe|r
.goto 543,36.25,68.78,10,0
.goto 543,36.41,69.66
.complete 34703,1 
.mob Kor'gall
step
*Jump down and hug the right wall
>>|TInterface/GossipFrame/HealerGossipIcon:0|tOpen the |cRXP_PICK_cage|r
.goto 543,37.38,69.17,10,0
.goto 543,36.85,70.56
.complete 34700,1 
step
#requires GorgrondOgreTeeth
#completewith next
.goto 543,38.58,67.38,10 >>Leave the cave
step
#requires GorgrondOgreTeeth
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Prowler Sasha|r
.target Prowler Sasha
.goto 543,41.43,66.09
.turnin 34012 >>Turn in Need More Teeth
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Beatface|r, |cRXP_FRIENDLY_Y'kish|r, |cRXP_FRIENDLY_Bruto|r, |cRXP_FRIENDLY_Akaani|r and |cRXP_FRIENDLY_Kash'drakor|r
.goto 543,42.73,63.03
.turnin 34702 >>Turn in Krav'ogra
.turnin 34703 >>Turn in The Axe of Kor'gall
.turnin 34700 >>Turn in Slave Hunters
.turnin 34698 >>Turn in Slave Hunters
.accept 35152 >>Accept The Sparring Arena
.turnin 35882 >>Turn in The Interest of Bruto
.target Beatface
.target Yikish
.target Bruto
.target Akaani
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Dying Beast|r
.target Dying Beast
.goto 543,44.24,61.61
.skipgossip
.complete 35025,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rexxar|r
.target Rexxar
.goto 543,44.27,61.64
.turnin 35025 >>Turn in We Have Company
.accept 35730 >>Accept Cauterizing Wounds
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Bonfire|r
.goto 543,44.37,61.33
.complete 35730,1 
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with |cRXP_FRIENDLY_Nisha|r
.goto 543,44.26,61.60
.complete 35730,2 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rexxar|r
.target Rexxar
.goto 543,44.28,61.64
.turnin 35730 >>Turn in Cauterizing Wounds
.accept 35026 >>Accept On the Mend
.accept 35870 >>Accept Basilisk Butcher
step
#completewith next
>>You have 60 seconds to get the following four items after using the ability. |cRXP_WARN_Before using the ability pull some mobs and damage them until they have only ~20% HP left.
*Skip the ones you didn't get
.cast 164012 >>Use Champion's Honor (Zone Ability)
step
#sticky
#label GorgrondGonnEyeRockthrower
*1) Loot 'Gronn Eye' from |cRXP_ENEMY_'Gronn Rockthrowers'|r
*Skip the items you haven't looted after 60 seconds.
.goto 543,43.86,62.71,15,0
.goto 543,43.85,63.35,15,0
.goto 543,44.74,62.84,15,0
.goto 543,45.76,64.53,15,0
.collect 114023,1,36083,1
.accept 36083 >>Accept Proof of Strength: Gronn Eye
.mob Gronn Rockthrower
step
*2) Loot 'Elemental Crystal' from the |cRXP_ENEMY_'Steamfuries'|r
*Skip the items you haven't looted after 60 seconds.
.goto 543,45.28,62.63,15,0
.goto 543,45.38,61.77,15,0
.collect 114038,1,36106,1
.accept 36106 >>Accept Proof of Strength: Elemental Crystal
.mob Rippling Steamfury
.mob Turbulent Steamfury
step
#requires GorgrondGonnEyeRockthrower
#completewith next
>>Kill |cRXP_ENEMY_Steamfuries|r around the pools. Loot them for the |cRXP_LOOT_water|r
.goto 543,45.53,59.40,15,0
.complete 35026,1 
.mob Rippling Steamfury
.mob Turbulent Steamfury
step
#requires GorgrondGonnEyeRockthrower
>>Kill |cRXP_ENEMY_Basilisks|r. Loot them for their |cRXP_LOOT_meat|r. Or pick it up from |cRXP_ENEMY_Decaying Basilisks|r
.goto 543,44.50,60.03
.complete 35870,1 
.mob Stoneshamble Basilisk
step
>>Kill |cRXP_ENEMY_Steamfuries|r around the pools. Loot them for the |cRXP_LOOT_water|r
.goto 543,44.15,57.57
.complete 35026,1 
.mob Rippling Steamfury
.mob Turbulent Steamfury
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nisha|r
.target Nisha
.goto 543,45.87,54.95
.turnin 35870 >>Turn in Basilisk Butcher
.turnin 35026 >>Turn in On the Mend
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rexxar|r twice
.target Rexxar
.goto 543,46.02,54.75
.skipgossip
.accept 35036 >>Accept Is This One of Yours?
.complete 35036,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bony Xuk|r
.target Bony Xuk
.goto 543,46.18,55.09
.turnin 35036 >>Turn in Is This One of Yours?
.accept 35038 >>Accept What the Bony Xuk?
.accept 35202 >>Accept Xuk Me, Right?
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rexxar|r
.target Rexxar
.goto 543,46.05,54.75
.accept 35037 >>Accept Bad at Breaking
.accept 35934 >>Accept Nisha's Vengeance
step
>>Kill |cRXP_ENEMY_Gorger|r. Loot them for their |cRXP_LOOT_shells|r.
>>Pick up the |cRXP_PICK_Crystals|r from the corpses of |cRXP_ENEMY_Longtooth Gorgers|r
#loop
.line 543,45.57,52.41,44.59,53.72,43.77,53.54,44.58,51.32
.goto 543,45.57,52.41,20,0
.goto 543,44.59,53.72,20,0
.goto 543,43.77,53.54,20,0
.goto 543,44.58,51.32,20,0
.complete 35038,1 
.complete 35202,1 
.mob Boneyard Tunneler
.mob Boneyard Gorger
.target Longtooth Gorger
step
#sticky
#label GorgrondGromkarGrunt
>>Kill |cRXP_ENEMY_Grom'kar Grunts|r
.goto 543,47.91,52.91,0,0
.complete 35934,1 
.mob Grom'kar Grunt
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Orders|r
.goto 543,47.75,52.07
.accept 35925 >>Accept The Gronn Strategy
step
>>Kill |cRXP_ENEMY_Gronnslaver Raz|r
.goto 543,47.78,51.81
.complete 35037,2 
.mob Gronnslaver Raz
step
>>Kill the |cRXP_ENEMY_Mangled Boulderbreaker|r
.goto 543,47.94,54.31
.complete 35037,1 
.mob Mangled Boulderbreaker
step
#requires GorgrondGromkarGrunt
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rexxar|r
.target Rexxar
.goto 543,46.04,54.75
.turnin 35037 >>Turn in Bad at Breaking
.turnin 35934 >>Turn in Nisha's Vengeance
.turnin 35925 >>Turn in The Gronn Strategy
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bony Xuk|r
.target Bony Xuk
.goto 543,46.20,55.09
.turnin 35202 >>Turn in Xuk Me, Right?
.turnin 35038 >>Turn in What the Bony Xuk?
.accept 35041 >>Accept Xuk It!
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Tunnel|r
.goto 543,46.92,55.38
.complete 35041,1 
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Rylak corpse|r
.goto 543,45.75,50.39
.complete 35041,2 
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Tunnel|r
.goto 543,45.75,50.39
.complete 35041,3 
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Tunnel|r
.goto 543,44.30,41.77
.complete 35041,4 
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_corpse|r
.goto 543,43.16,42.30
.complete 35041,5 
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Tunnel|r
.goto 543,43.01,42.49
.complete 35041,6 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rexxar|r
.target Rexxar
.goto 543,46.04,54.74
.turnin 35041 >>Turn in Xuk It!
.accept 35129 >>Accept Leave Every Soldier Behind
.accept 35128 >>Accept Fair Warning
step
#completewith next
>>You have 60 seconds to get the following four items after using the ability. |cRXP_WARN_Before using the ability pull some mobs and damage them until they have only ~20% HP left.
*Skip the ones you didn't get
.cast 164012 >>Use Champion's Honor (Zone Ability)
step
*Loot 'Worn Ogron Horn' from the |cRXP_ENEMY_'Ogron Spinecrushers'|r
*Skip the items you haven't looted after 60 seconds.
.goto 543,43.49,48.05,15,0
.goto 546,58.71,79.16,15,0
.goto 543,35.77,65.86,15,0
.collect 114019,1,36076,1
.accept 36076 >>Accept Proof of Strength: Worn Ogron Horn
.mob Ogron Spinecrusher
step
#sticky
#label GorgrondOgronSpinecrusher
>>Kill |cRXP_ENEMY_Ogron Spinecrushers|r
.goto 546,51.76,64.72,0,0
.complete 35128,1 
.mob Ogron Spinecrusher
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Corporal Thukmar|r and pick up the |cRXP_PICK_intel|r afterwards.
.goto 546,46.50,57.62,20,0
.goto 546,41.17,58.75,12,0
.goto 546,44.84,85.81
.skipgossip
.complete 35129,1 
.complete 35129,2 
.target Corporal Thukmar
step
>>Kill |cRXP_ENEMY_Borogahn|r
.goto 547,31.07,75.36
.complete 35128,2 
.mob Borogahn
step
#requires GorgrondOgronSpinecrusher
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Tunnel|r
.goto 547,34.77,66.63
.accept 35210 >>Accept A Great Escape
.complete 35210,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bony Xuk|r
.target Bony Xuk
.goto 543,43.89,48.85
.accept 35247 >>Accept Zero Xuks Given
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bony Xuk|r again
.target Bony Xuk
.goto 543,43.89,48.85
.skipgossip
.complete 35247,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rexxar|r
.target Rexxar
.goto 543,43.94,48.86
.turnin 35128 >>Turn in Fair Warning
.turnin 35129 >>Turn in Leave Every Soldier Behind
.turnin 35210 >>Turn in A Great Escape
.accept 35139 >>Accept Eye in the Sky
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nisha|r
.target Nisha
*Skip the next cinematic with ESC
.goto 543,43.87,48.91
.skipgossip
.complete 35139,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rexxar|r
.target Rexxar
.goto 543,43.94,48.86
.turnin 35139 >>Turn in Eye in the Sky
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the Spirit
.goto 543,44.12,48.81
.turnin 35247 >>Turn in Zero Xuks Given
.turnin 36832 >>Turn in Get The Xuk Outta Here!
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rexxar|r
.target Rexxar
.goto 543,43.94,48.86
.accept 35136 >>Accept Chains of Iron
step
.goto 543,44.71,48.69
.accept 36480 >>Accept Valley of Destruction (Bonus Objective)
step
#sticky
#label GorgrondCanyonBoulderbreak
>>Kill the closest |cRXP_ENEMY_Boulderbreakers|r around the waypoint
.goto 543,45.73,46.44
.complete 36480,1 
.mob Canyon Boulderbreaker
step
>>Break |cRXP_ENEMY_Goren Eggs|r and kill |cRXP_ENEMY_Nibblers|r around the waypoint
.goto 543,47.62,48.11
.complete 36480,2 
.complete 36480,3 
.mob Goren Nibbler
step
#requires GorgrondCanyonBoulderbreak
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rakthoth|r
.target Rakthoth
.goto 543,49.37,49.70
.turnin 33694 >>Turn in Reagents from Rakthoth
.accept 33689 >>Accept Plant Pruning
.accept 33685 >>Accept Ambassador to the Ancient
step
#sticky
#label defendersdionor
#loop
.line 543,49.80,47.63,49.46,47.19,49.82,46.36,50.28,46.09,50.89,46.31
.goto 543,49.80,47.63,15,0
.goto 543,49.46,47.19,15,0
.goto 543,49.82,46.36,15,0
.goto 543,50.28,46.09,15,0
.goto 543,50.89,46.31,15,0
>>Kill the |cRXP_ENEMY_Seedpriests|r or |cRXP_ENEMY_Growths|r
.complete 33689,1 
.mob Dionor Seedpriest
.mob Primal Growth
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Birchus|r
.goto 543,50.29,47.52
.skipgossip 1
.complete 33685,1 
.target Birchus
step
#requires defendersdionor
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rakthoth|r
.target Rakthoth
.goto 543,51.28,47.98
.turnin 33689 >>Turn in Plant Pruning
.turnin 33685 >>Turn in Ambassador to the Ancient
.accept 33662 >>Accept Beatface vs. Boulder
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Boulder|r
.goto 543,50.63,51.45
.complete 33662,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rakthoth|r
.target Rakthoth
.goto 543,50.91,51.43
.turnin 33662 >>Turn in Beatface vs. Boulder
.accept 33661 >>Accept Steamscar "Reagents"
step
>>|TInterface/GossipFrame/HealerGossipIcon:0|tInteract with the |cRXP_PICK_Saberon Stash|r
.goto 543,51.05,51.62
.accept 33660 >>Accept The Sacking of the Saberon
step
#sticky
#label GorgrondSaberonHeart
>>Kill |cRXP_ENEMY_Streamscars|r. Loot them for their |cRXP_LOOT_hearts|r
.goto 543,51.86,51.27,0,0
.complete 33661,1 
.mob Streamscar Warrior
.mob Streamscar Primalist
step
#title Herb Bundle 1/8
>>Pick up the |cRXP_PICK_bundle|r
.goto 543,51.41,51.87
.complete 33660,1,1 
step
#title Herb Bundle 2/8
>>Pick up the |cRXP_PICK_bundle|r
.goto 543,51.66,52.47
.complete 33660,1,2 
step
#title Herb Bundle 3/8
>>Pick up the |cRXP_PICK_bundle|r
.goto 543,51.95,51.04
.complete 33660,1,3 
step
#title Herb Bundle 4/8
>>Pick up the |cRXP_PICK_bundle|r
.goto 543,53.23,50.98
.complete 33660,1,4 
step
#title Herb Bundle 5/8
>>Pick up the |cRXP_PICK_bundle|r
.goto 543,53.64,50.82
.complete 33660,1,5 
step
#title Herb Bundle 6/8
>>Pick up the |cRXP_PICK_bundle|r
.goto 543,53.70,51.20
.complete 33660,1,6 
step
#title Herb Bundle 7/8
>>Pick up the |cRXP_PICK_bundle|r
.goto 543,53.59,51.75
.complete 33660,1,7 
step
#title Herb Bundle 8/8
>>Pick up the |cRXP_PICK_bundle|r
.goto 543,53.47,51.82
.complete 33660,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rakthoth|r
.target Rakthoth
.goto 543,52.86,51.76
.turnin 33660 >>Turn in The Sacking of the Saberon
.turnin 33661 >>Turn in Steamscar "Reagents"
.accept 33695 >>Accept Taking the Death Bloom
step
>>Kill |cRXP_ENEMY_Smokemaster Snarl|r. Loot him for the |cRXP_LOOT_Death Bloom|r
.goto 543,54.27,52.61
.complete 33695,1 
.mob Smokemaster Snarl
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Birchus|r
.target Birchus
.goto 543,50.30,47.53
.turnin 33695 >>Turn in Taking the Death Bloom
.accept 33706 >>Accept Laying Dionor to Rest
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tWait for ~5 seconds. Talk to |cRXP_FRIENDLY_Birchus|r again
.goto 543,50.30,47.53
.turnin 33706 >>Turn in Laying Dionor to Rest
.target Birchus
step
.goto 543,48.93,47.31
.turnin 36203 >>Pick up the |cRXP_PICK_egg|r inside the cave
step
>>Defeat the incoming waves. Kill |cRXP_ENEMY_Captain Brak|r at the end
*|cRXP_WARN_If you're squishy only attack NPCs Rexxar is attacking and wait for him to generate some threat.|r
.goto 543,49.21,44.90
.complete 35136,1 
.mob Captain Brak
step
>>Pick up the |cRXP_PICK_Heart.|r
.goto 543,49.73,43.85
.complete 35136,2 
step
#completewith next
.hs >>Hearth to Beastwatch
step
.goto 543,48.88,69.68
.accept 36563 >>Accept Mistcreep Mire (Bonus Objective)
step
#completewith next
>>You have 60 seconds to get the following item after using the ability. |cRXP_WARN_Before using the ability pull some mobs and damage them until they have only ~20% HP left.
*Skip the ones you didn't get
.cast 164012 >>Use Champion's Honor (Zone Ability)
step
*Loot 'Basilik Scale' from the |cRXP_ENEMY_'Mire Basilisks'|r
*Skip the items you haven't looted after 60 seconds.
.goto 543,50.09,69.19,15,0
.goto 543,51.58,68.46
.collect 114036,1,36104,1
.accept 36104 >>Accept Proof of Strength: Basilisk Scale
.mob Mire Basilisk
step
#sticky
#label hydravilescale
>>Break |cRXP_ENEMY_Eggs|r and kill |cRXP_ENEMY_Vilescales|r around the waypoint
.goto 543,51.84,66.54,0,0
.complete 36563,1 
.complete 36563,2 
.mob Lernaea Vilescale
.mob Hydra Egg
step
.goto 543,52.50,66.95
.turnin 36509 >>Pick up the |cRXP_PICK_skull|r
step
#requires hydravilescale
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grulkor|r
.target Grulkor
.goto 543,54.45,66.65
.turnin 35667 >>Turn in Skulltakers in Crimson Fen
.accept 35016 >>Accept Basic Skulltaking
step
#sticky
#label GorgrondFungalLurcher
>>Kill |cRXP_ENEMY_Fungal Lurchers|r in the area
.goto 543,56.79,63.49,0,0
.complete 35017,1 
.mob Fungal Lurcher
step
#sticky
#label laughingskull1
#title Laughing Skull 1/5
>>Take the |cRXP_PICK_Laughing Skull|r from the |cRXP_ENEMY_Dead Skulltaker|r
.goto 543,54.56,65.58
.complete 35016,1,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dying Skulltaker|r
.target Dying Skulltaker
.goto 543,54.84,65.31
.accept 35017 >>Accept Skulltaker's Revenge
step
>>Kill |cRXP_ENEMY_Fungal Lurcher|r. Loot them for the |cRXP_LOOT_Glowing Red Pod|r. Click it in your bags
.goto 543,54.84,65.31
.collect 112378,1,35021
.accept 35021 >>Accept Mysterious Pod
.mob Fungal Lurcher
step
#requires laughingskull1
#title Laughing Skull 2/5
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dying Skulltaker|r
.goto 543,55.25,65.19
.complete 35016,1,2 
step
#title Laughing Skull 3/5
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dying Skulltaker|r
.goto 543,55.54,64.68
.complete 35016,1,3 
step
#title Laughing Skull 4/5
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dying Skulltaker|r
.goto 543,55.83,64.66
.complete 35016,1,4 
step
#title Laughing Skull 5/5
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dying Skulltaker|r
.goto 543,56.11,64.59
.complete 35016,1 
step
#requires GorgrondFungalLurcher
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grulkor|r
.target Grulkor
.goto 543,57.20,61.95
.turnin 35016 >>Turn in Basic Skulltaking
.turnin 35017 >>Turn in Skulltaker's Revenge
.turnin 35021 >>Turn in Mysterious Pod
.accept 35027 >>Accept Clearing the Way
.accept 35029 >>Accept The Secret of the Fungus
step
#sticky
#label GorgrondFungusCoveredShamblers
>>Kill |cRXP_ENEMY_Fungus Covered Shambler|r
.goto 543,57.31,60.74,0,0
.complete 35027,1 
.mob Fungus Covered Shambler
step
>>Pickup the five |cRXP_PICK_mushrooms|r that are closest to the waypoint.
.goto 543,57.31,60.74
.complete 35029,1 
step
#requires GorgrondFungusCoveredShamblers
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grulkor|r
.target Grulkor
.goto 543,57.20,61.95
.turnin 35027 >>Turn in Clearing the Way
.turnin 35029 >>Turn in The Secret of the Fungus
.accept 35030 >>Accept A Grim Harvest
.accept 35031 >>Accept A Heartfelt Search
step
>>Follow the arrow
.goto 543,58.93,62.53
.complete 35031,1 
step
>>Kill |cRXP_ENEMY_Fungal Stompers|r. Loot them for the |cRXP_LOOT_pods|r
.goto 543,58.48,62.79,20,0
.goto 543,58.92,61.34,20,0
.goto 543,59.91,62.75
.complete 35030,1 
.mob Fungal Stomper
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grulkor|r
.target Grulkor
.goto 543,58.91,62.52
.turnin 35030 >>Turn in A Grim Harvest
.turnin 35031 >>Turn in A Heartfelt Search
.accept 35040 >>Accept Heart of the Fen
step
>>Kill |cRXP_ENEMY_Grulkor|r
*If you damage is low wait for your cooldowns.
.goto 543,61.22,61.83
.complete 35040,1 
.mob Grulkor
step
.goto 543,61.20,57.58
.accept 36571 >>Accept Iyun Weald (Bonus Objective)
step
#sticky
#label GorgrondWealdStinger
>>Kill |cRXP_ENEMY_Weal Stingers|r
>>They fly above you. Use a ranged ability to pull them.
.complete 36571,3 
.mob Weald Stinger
step
>>Kill |cRXP_ENEMY_Thorny Stabbers|r
>>Click on the |cRXP_ENEMY_Leaflings|r to insta-kill them
.goto 543,61.35,56.61,15,0
.goto 543,60.88,55.54,15,0
.goto 543,61.01,54.37,15,0
.goto 543,60.61,53.62,15,0
.goto 543,61.12,53.22
.complete 36571,1 
.complete 36571,2 
.mob Thorny Stabber
.mob Thorny Leafling
step
#requires GorgrondWealdStinger
.goto 543,61.52,63.20
.accept 36564 >>Accept Tangleheart (Bonus Objective)
step
#sticky
#label GorgrondTangleheartCultivator
>>Kill |cRXP_ENEMY_Tangleheart Cultivator|r
.goto 543,58.60,71.52,0,0
.complete 36564,1 
step
#title Pod 1/10
>>|TInterface/GossipFrame/HealerGossipIcon:0|tDestroy the |cRXP_PICK_Pod.|r
.goto 543,61.89,63.64
.complete 36564,2,1 
step
#title Pod 2/10
>>|TInterface/GossipFrame/HealerGossipIcon:0|tDestroy the |cRXP_PICK_Pod.|r
.goto 543,62.03,65.41
.complete 36564,2,2 
step
#title Pod 3/10
>>|TInterface/GossipFrame/HealerGossipIcon:0|tDestroy the |cRXP_PICK_Pod.|r
.goto 543,61.56,66.39
.complete 36564,2,3 
step
#title Pod 4/10
>>|TInterface/GossipFrame/HealerGossipIcon:0|tDestroy the |cRXP_PICK_Pod.|r
.goto 543,60.74,65.95
.complete 36564,2,4 
step
#title Pod 5/10
>>|TInterface/GossipFrame/HealerGossipIcon:0|tDestroy the |cRXP_PICK_Pod.|r
.goto 543,59.43,65.68
.complete 36564,2,5 
step
#title Pod 6/10
>>|TInterface/GossipFrame/HealerGossipIcon:0|tDestroy the |cRXP_PICK_Pod.|r
.goto 543,59.31,66.99
.complete 36564,2,6 
step
#title Pod 7/10
>>|TInterface/GossipFrame/HealerGossipIcon:0|tDestroy the |cRXP_PICK_Pod.|r
.goto 543,59.38,67.88
.complete 36564,2,7 
step
#title Pod 8/10
>>|TInterface/GossipFrame/HealerGossipIcon:0|tDestroy the |cRXP_PICK_Pod.|r
.goto 543,59.86,68.72
.complete 36564,2,8 
step
#title Pod 9/10
>>|TInterface/GossipFrame/HealerGossipIcon:0|tDestroy the |cRXP_PICK_Pod.|r
.goto 543,60.16,69.79
.complete 36564,2,9 
step
>>Kill |cRXP_ENEMY_Ontogen the Harvester|r
.goto 543,59.87,71.06
.complete 36564,3 
.mob Ontogen the Harvester
step
#title Pod 10/10
>>|TInterface/GossipFrame/HealerGossipIcon:0|tDestroy the |cRXP_PICK_Pod.|r
.goto 543,59.39,71.03
.complete 36564,2 
step
#completewith next
>>You have 60 seconds to get the following 2 items after using the ability. |cRXP_WARN_Before using the ability pull some mobs and damage them until they have only ~20% HP left.
*Skip the ones you didn't get
.cast 164012 >>Use Champion's Honor (Zone Ability)
step
*1) Loot 'Orc Thorn' from |cRXP_ENEMY_'Infested Behemoths'|r
*2) Loot 'Ancient Branch' from the |cRXP_ENEMY_'Bloom Defender'|r
*Skip if you don't loot it after 60 seconds.
.goto 543,48.44,74.05,20,0
.goto 543,47.06,73.15,20,0
.goto 543,46.11,73.29,20,0
.collect 114027,1,36091,1
.collect 114030,1,36094,1
.accept 36091 >>Accept Proof of Strength: Orc Thorn
.accept 36094 >>Accept Proof of Strength: Ancient Branch
.mob Infested Behemoth
.mob Bloom Defender
step
#requires GorgrondTangleheartCultivator
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Limbflayer|r
.target Limbflayer
.goto 543,46.33,69.71
.turnin -35152 >>Turn in The Sparring Arena
.turnin -35948 >>Turn in Proof of Strength: Goren Tooth
.turnin -36076 >>Turn in Proof of Strength: Ogron Horn
.turnin -36080 >>Turn in Proof of Strength: Gronnling Scale
.turnin -36083 >>Turn in Proof of Strength: Gronn Eye
.turnin -36086 >>Turn in Proof of Strength: Botani Bloom
.turnin -36091 >>Turn in Proof of Strength: Orc Thorn
.turnin -36097 >>Turn in Proof of Strength: Ravager Claw
.turnin -36101 >>Turn in Proof of Strength: Wasp Stinger
.turnin -36104 >>Turn in Proof of Strength: Basilisk Scale
.turnin -36106 >>Turn in Proof of Strength: Elemental Crystal
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marrow|r
.target Marrow
.goto 543,46.28,69.98
.turnin 35040 >>Turn in Heart of the Fen
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Durotan|r
.target Durotan
.goto 543,46.10,70.19
.turnin 35136 >>Turn in Chains of Iron
step
.zoneskip 590
#completewith next
.cast 171253 >>Use your Garrison Hearthstone
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Warmaster Zog|r in front of you
.turnin 34462 >>Turn in Winds of Change
.accept 34775 >>Accept Mission Probable
.target Warmaster Zog
step
>>Interact with the Mission Table and skip through the tutorial
*If you can't press on the mission then type '/reload' into the chat.
*Click on the first Mission then drag |cRXP_FRIENDLY_Olin Umberhide|r into the follower slot and start it.
.complete 34775,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Warmaster Zog|r
.target Warmaster Zog
.turnin 34775 >>Turn in Mission Probable
step
.isQuestTurnedIn 44184
#completewith next
.use 140192
.cast 222695 >>Use Dalaran Hearthstone
step
.isQuestTurnedIn 44184
.goto 627,55.28,23.95
.zone 85 >>Take the portal to Orgrimmar
step
.isQuestAvailable 44184
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gazlowe|r
.target Gazlowe
.accept 36706 >>Accept Ashran Appearance
step
.isQuestAvailable 44184
>>Go to the Flight Master and talk to him
.skipgossip 2
.complete 36706,1 
step
.isQuestAvailable 44184
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Stomphoof|r
.target Stomphoof
.goto 624,45.55,34.64
.turnin 36706 >>Turn in Ashran Appearance
step
.isQuestAvailable 44184
.zoneskip 85
.goto 624,60.76,51.59,1 >>Use the Portal to Orgrimmar
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Goblin Heritage Quests (H)
#displayname |cRXP_WARN_Chapter 4 -|r Goblin Heritage Quests
#next 6) Item Information (H)
<< Horde Goblin
step
#include 5) Goblin Heritage Armor
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Troll Heritage Quests (H)
#displayname |cRXP_WARN_Chapter 4 -|r Troll Heritage Quests
#next 6) Item Information (H)
<<Horde Troll
step
#include 5) Troll Heritage Armor
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Orc Heritage Quests (H)
#displayname |cRXP_WARN_Chapter 4 -|r Orc Heritage Quests
#next 6) Item Information (H)
<< Horde Orc
step
#include 5) Orc Heritage Armor
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Tauren Heritage Quests (H)
#displayname |cRXP_WARN_Chapter 4 -|r Tauren Heritage Quests
#next 6) Item Information (H)
<< Horde Tauren
step
#include 5) Tauren Heritage Armor
]])
RXPGuides.RegisterGuide([[
-- ]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Undead Heritage Armor (H)
#displayname |cRXP_WARN_Chapter 4 -|r Undead Heritage Quests
#next 6) Item Information (H)
<< Horde Undead
step
#include 5) Undead Heritage Armor
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 8) Turnin Route Hearthstone Locations (H)
#displayname |cRXP_WARN_Chapter 7 -|r Hearthstone Location for Turnins
#next 9) Turnin Route Horde (H)
<< Horde
step
#include 8) Turnin Route Hearthstone Locations
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 9) Turnin Route Horde (H)
#displayname |cRXP_WARN_Chapter 8 -|r Turnin Route
#next 9b) PoP-UP Quests Turnins (H)
<< Horde
step
#include 9) Turnin Route Horde
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 9b) PoP-UP Quests Turnins (H)
#displayname |cRXP_WARN_Final Chapter -|r PoP-UP Quests Turnins
<< Horde
step
#include 9b) PoP-UP Quests Turnins
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#subgroup Dragonflight (New Player)
#displayname Chapter 1 - The Waking Shores
#name a) The Waking Shores Fresh (H)
#next b) Ohn'ahran Plain Fresh (H)
<< Horde
step
#include a) The Waking Shores Fresh
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP Speedrun Guide
#subgroup Dragonflight (New Player)
#name b) Ohn'ahran Plain Fresh (H)
#displayname Chapter 2 - Ohn'ahran Plains
#next c) The Azure Span Fresh (H)
<< Horde
step
#include b) Ohn'ahran Plain Fresh
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP Speedrun Guide
#subgroup Dragonflight (New Player)
#displayname Chapter 3 - The Azure Span
#name c) The Azure Span Fresh (H)
#next d) Thaldraszus Fresh (H)
<< Horde
step
#include c) The Azure Span Fresh
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP Speedrun Guide
#subgroup Dragonflight (New Player)
#name d) Thaldraszus Fresh (H)
#displayname Chapter 4 - Thaldraszus
<< Horde
step
#include d) Thaldraszus Fresh
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Only (70 -76)
#name a) Isle of Dorn Campaign (H)
#displayname |cRXP_WARN_Chapter 1|r - Isle of Dorn
#title Isle of Dorn Campaign
#next b) The Ringing Deeps Campaign (H)
#subweight 9
<< Horde
step
#include a) Isle of Dorn Campaign
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Only (70 -76)
#name b) The Ringing Deeps Campaign (H)
#displayname |cRXP_WARN_Chapter 2|r - The Ringing Deeps
#title The Ringing Deeps Campaign
#next c) Hallowfall Campaign (H)
#subweight 9
<< Horde
step
#include b) The Ringing Deeps Campaign
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Only (70 -76)
#name c) Hallowfall Campaign (H)
#displayname |cRXP_WARN_Chapter 3|r - Hallowfall
#title Hallowfall Campaign
#next d) Azj-kahet Campaign (H)
#subweight 9
<< Horde
step
#include c) Hallowfall Campaign
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Only (70 -76)
#name d) Azj-kahet Campaign (H)
#displayname |cRXP_WARN_Chapter 4|r - Azj-kahet
#title Azj-kahet Campaign
#subweight 9
<< Horde
step
#include d) Azj-kahet Campaign
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling (70-80)
#name a) Isle of Dorn Campaign + Side Quests (H)
#displayname |cRXP_WARN_Chapter 1|r - Isle of Dorn (1/2)
#title Isle of Dorn Leveling 1
#next b) The Ringing Deeps Campaign + Side Quests (H)
#subweight 8
<< Horde
step
#include a) Isle of Dorn Campaign + Side Quests
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling (70-80)
#name b) The Ringing Deeps Campaign + Side Quests (H)
#displayname |cRXP_WARN_Chapter 2|r - The Ringing Deeps
#title The Ringing Deeps Leveling
#next c) Hallowfall Campaign + Side Quests (H)
#subweight 8
<< Horde
step
#include b) The Ringing Deeps Campaign + Side Quests
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling (70-80)
#name c) Hallowfall Campaign + Side Quests (H)
#displayname |cRXP_WARN_Chapter 3|r - Hallowfall
#title Hallowfall Leveling
#next d) Azj-kahet Campaign + Side Quests (H)
#subweight 8
<< Horde
step
#include c) Hallowfall Campaign + Side Quests
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling (70-80)
#name d) Azj-kahet Campaign + Side Quests (H)
#displayname |cRXP_WARN_Chapter 4|r - Azj-kahet
#next e) Isle of Dorn Campaign + Side Quests (H)
#title Azj-kahet Leveling
#subweight 8
<< Horde
step
#include d) Azj-kahet Campaign + Side Quests
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling (70-80)
#name e) Isle of Dorn Campaign + Side Quests (H)
#displayname |cRXP_WARN_Chapter 5|r - Isle of Dorn (2/2)
#title Isle of Dorn Leveling 2
#subweight 8
<< Horde
step
#include e) Isle of Dorn Campaign + Side Quests
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Only Multibox (70 -76)
#name a) Isle of Dorn Campaign Multibox (H)
#displayname |cRXP_WARN_Chapter 1|r - Isle of Dorn MB
#title Isle of Dorn Campaign MB
#next b) The Ringing Deeps Campaign Multibox (H)
#subweight 9
<< Horde
step
#include a) Isle of Dorn Campaign Multibox
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Only Multibox (70 -76)
#name b) The Ringing Deeps Campaign Multibox (H)
#displayname |cRXP_WARN_Chapter 2|r - The Ringing Deeps MB
#title The Ringing Deeps Campaign MB
#next c) Hallowfall Campaign Multibox (H)
#subweight 9
<< Horde
step
#include b) The Ringing Deeps Campaign Multibox
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Only Multibox (70 -76)
#name c) Hallowfall Campaign Multibox (H)
#displayname |cRXP_WARN_Chapter 3|r - Hallowfall MB
#title Hallowfall Campaign MB
#next d) Azj-kahet Campaign Multibox (H)
#subweight 9
<< Horde
step
#include c) Hallowfall Campaign Multibox
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Only Multibox (70 -76)
#name d) Azj-kahet Campaign Multibox (H)
#displayname |cRXP_WARN_Chapter 4|r - Azj-kahet MB
#title Azj-kahet Campaign MB
#subweight 9
<< Horde
step
#include d) Azj-kahet Campaign Multibox
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling Multibox (70-80)
#name a) Isle of Dorn Campaign + Side Quests MB (H)
#displayname |cRXP_WARN_Chapter 1|r - Isle of Dorn MB (1/2)
#title Isle of Dorn Leveling MB 1
#next b) The Ringing Deeps Campaign + Side Quests MB (H)
#subweight 8
<< Horde
step
#include a) Isle of Dorn Campaign + Side Quests MB
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling Multibox (70-80)
#name b) The Ringing Deeps Campaign + Side Quests MB (H)
#displayname |cRXP_WARN_Chapter 2|r - The Ringing Deeps MB
#title Ringing Deeps Leveling MB
#next c) Hallowfall Campaign + Side Quests MB (H)
#subweight 8
<< Horde
step
#include b) The Ringing Deeps Campaign + Side Quests MB
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling Multibox (70-80)
#name c) Hallowfall Campaign + Side Quests MB (H)
#displayname |cRXP_WARN_Chapter 3|r - Hallowfall MB
#title Hallowfall Leveling MB
#next d) Azj-kahet Campaign + Side Quests MB (H)
#subweight 8
<< Horde
step
#include c) Hallowfall Campaign + Side Quests MB
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling Multibox (70-80)
#name d) Azj-kahet Campaign + Side Quests MB (H)
#displayname |cRXP_WARN_Chapter 4|r - Azj-kahet MB
#title Azj-kahet Leveling MB
#next e) Isle of Dorn Campaign + Side Quests MB (H)
#subweight 8
<< Horde
step
#include d) Azj-kahet Campaign + Side Quests MB
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling Multibox (70-80)
#name e) Isle of Dorn Campaign + Side Quests MB (H)
#displayname |cRXP_WARN_Chapter 5|r - Isle of Dorn MB (2/2)
#title Isle of Dorn Leveling MB 2
#subweight 8
<< Horde
step
#include e) Isle of Dorn Campaign + Side Quests MB
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Adventure Mode (70-80)
#name a) Intro Scenario War Within (H)
#displayname |cRXP_WARN_Chapter 0|r - Intro Scenario (Optional)
#title Intro Scenario
#next a) Isle of Dorn Adventure Mode 1 (H)
<< Horde
step
#include a) Intro Scenario War Within
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Adventure Mode (70-80)
#name a) Isle of Dorn Adventure Mode 1 (H)
#displayname |cRXP_WARN_Chapter 1|r - Isle of Dorn (1/2)
#title Isle of Dorn Adventure Mode 1
#next b) Azjkahet Adventure Mode 1 (H)
#subweight 7
<< Horde
step
#include a) Isle of Dorn Adventure Mode 1
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Adventure Mode (70-80)
#name b) Azjkahet Adventure Mode 1 (H)
#displayname |cRXP_WARN_Chapter 2|r - Azj-kahet (1/2)
#title Azj-kahet Adventure Mode 1
#next c) Hallowfall Adventure Mode (H)
#subweight 7
<< Horde
step
#include b) Azjkahet Adventure Mode 1
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Adventure Mode (70-80)
#name c) Hallowfall Adventure Mode (H)
#displayname |cRXP_WARN_Chapter 3|r - Hallowfall
#title Hallowfall Adventure Mode
#next d) Azjkahet Adventure Mode 2 (H)
#subweight 7
<< Horde
step
#include c) Hallowfall Adventure Mode
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Adventure Mode (70-80)
#name d) Azjkahet Adventure Mode 2 (H)
#displayname |cRXP_WARN_Chapter 4|r - Azj-kahet (2/2)
#title Azj-kahet Adventure Mode 2
#next e) Isle of Dorn Adventure Mode 2 (H)
#subweight 7
<< Horde
step
#include d) Azjkahet Adventure Mode 2
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Adventure Mode (70-80)
#name e) Isle of Dorn Adventure Mode 2 (H)
#displayname |cRXP_WARN_Chapter 5|r - Isle of Dorn (2/2)
#title Isle of Dorn Adventure Mode 2
#next f) The Ringing Deeps Adventure Mode (H)
#subweight 7
<< Horde
step
#include e) Isle of Dorn Adventure Mode 2
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Adventure Mode (70-80)
#name f) The Ringing Deeps Adventure Mode (H)
#displayname |cRXP_WARN_Chapter 6|r - The Ringing Deeps
#title Ringing Deeps Adventure Mode
#subweight 7
<< Horde
step
#include f) The Ringing Deeps Adventure Mode
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name a) Spores of Dread (H)
#displayname Spores of Dread
#subweight 4
<< Horde
step
#include a) Spores of Dread
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name b) Behind Closed Doors (H)
#displayname Behind Closed Door
#subweight 4
<< Horde
step
#include b) Behind Closed Doors
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name c) Seven Soldiers (H)
#displayname Seven Soldiers
#subweight 4
<< Horde
step
#include c) Seven Soldiers
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name d) Lost Lord of the Storm (H)
#displayname Lost Lord of the Storm
#subweight 4
<< Horde
step
#include d) Lost Lord of the Storm
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name e) Hope, An Anomaly (H)
#displayname Hope, An Anomaly
#subweight 4
<< Horde
step
#include e) Hope, An Anomaly
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name f) The Hermit (H)
#displayname The Hermit
#subweight 4
<< Horde
step
#include f) The Hermit
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name g) A Titanic Expedition (H)
#displayname A Titanic Expedition
#subweight 4
<< Horde
step
#include g) A Titanic Expedition
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name h) Remember Me, Earthen (H)
#displayname Remember Me, Earthen
#subweight 4
<< Horde
step
#include h) Remember Me, Earthen
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name i) All Ore Nothing (H)
#displayname All Ore Nothing
#subweight 4
<< Horde
step
#include i) All Ore Nothing
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name i) Heart of Stone (H)
#displayname Heart of Stone
#subweight 4
<< Horde
step
#include i) Heart of Stone
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name i) Cloud Fishing (H)
#displayname Cloud Fishing
#subweight 4
<< Horde
step
#include i) Cloud Fishing
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name i) The Opalcreg (H)
#displayname The Opalcreg
#subweight 4
<< Horde
step
#include i) The Opalcreg
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name e) Envenomed Invasion (H)
#displayname Envenomed Invasion
#title Envenomed Invasion
#subweight 3
<< Horde
step
#include e) Envenomed Invasion
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name p) Frolicking in the Fetid Grotto (H)
#displayname Frolicking in the Fetid Grotto
#title Frolicking in the Fetid Grotto
#subweight 3
<< Horde
step
#include p) Frolicking in the Fetid Grotto
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name d) Dread in the Den (H)
#displayname Dread in the Den
#subweight 3
<< Horde
step
#include d) Dread in the Den
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name f) Fearbreaker (H)
#displayname Fearbreaker
#subweight 3
<< Horde
step
#include f) Fearbreaker
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name n) Revenge in the Rumbling Wastes (H)
#displayname Revenge in the Rumbling Wastes
#subweight 3
<< Horde
step
#include n) Revenge in the Rumbling Wastes
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name o) Tired of Rest (H)
#displayname Tired of Rest
#subweight 3
<< Horde
step
#include o) Tired of Rest
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name c) Routine Maintenance (H)
#displayname Routine Maintenance
#subweight 3
<< Horde
step
#include c) Routine Maintenance
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name g) Into the Fog (H)
#displayname Into the Fog
#subweight 3
<< Horde
step
#include g) Into the Fog
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name m) Abysmal Extraction (H)
#displayname Abysmal Extraction
#subweight 3
<< Horde
step
#include m) Abysmal Extraction
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name a) The Caretaker of Brunwin's Terrace (H)
#displayname The Caretaker of Brunwin's Terrace
#subweight 3
<< Horde
step
#include a) The Caretaker of Brunwin's Terrace
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name h) Magma-nificence (H)
#displayname Magma-nificence
#subweight 3
<< Horde
step
#include h) Magma-nificence
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name l) Rampage at Nibelgaz Mine (H)
#displayname Rampage at Nibelgaz Mine
#subweight 3
<< Horde
step
#include l) Rampage at Nibelgaz Mine
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name k) Kobold Candles/Crew/Story (H)
#displayname Kobold Candles/Crew/Story
#subweight 3
<< Horde
step
#include k) Kobold Candles/Crew/Story
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name a) Light of Velhan's Claim (H)
#displayname Light of Velhan's Claim
#subweight 2
<< Horde
step
#include a) Light of Velhan's Claim
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name b) The Priory (H)
#displayname The Priory
#subweight 2
<< Horde
step
#include b) The Priory
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name m) What Grows in the Dark (H)
#displayname What Grows in the Dark
#subweight 2
<< Horde
step
#include m) What Grows in the Dark
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name l) The Mysterious Chef (H)
#displayname The Mysterious Chef
#subweight 2
<< Horde
step
#include l) The Mysterious Chef
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name f) Crushing Depths (H)
#displayname Crushing Depths
#subweight 2
<< Horde
step
#include f) Crushing Depths
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name n) Suspicious Minds (H)
#displayname Suspicious Minds
#subweight 2
<< Horde
step
#include n) Suspicious Minds
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name e) The Sky's the Limit (H)
#displayname The Sky's the Limit
#subweight 2
<< Horde
step
#include e) The Sky's the Limit
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name i) Apart for Purpose (H)
#displayname Apart for Purpose
#subweight 2
<< Horde
step
#include i) Apart for Purpose
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name g) The Last Mage of Hallowfall (H)
#displayname The Last Mage of Hallowfall
#subweight 2
<< Horde
step
#include g) The Last Mage of Hallowfall
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name c) Striking Steel (H)
#displayname Striking Steel
#subweight 2
<< Horde
step
#include c) Striking Steel
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name h) The Second Front (H)
#displayname The Second Front
#subweight 1
<< Horde
step
#include h) The Second Front
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name b) Pillar-nest Vosh (H)
#displayname Pillar-nest Vosh
#subweight 1
<< Horde
step
#include b) Pillar-nest Vosh
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name m) Silken Ward (H)
#displayname Silken Ward
#subweight 1
<< Horde
step
#include m) Silken Ward
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name n) Grieve & Weave (H)
#displayname Grieve & Weave
#subweight 1
<< Horde
step
#include n) Grieve & Weave
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name i) Mr. Sunflower's Therapy (H)
#displayname Mr. Sunflower's Therapy
#subweight 1
<< Horde
step
#include i) Mr. Sunflower's Therapy
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name c) Gutter Work (H)
#displayname Gutter Work
#subweight 1
<< Horde
step
#include c) Gutter Work
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name j) The Wild Camp (H)
#displayname The Wild Camp
#subweight 1
<< Horde
step
#include j) The Wild Camp
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name f) The Wormlands (H)
#displayname The Wormlands
#subweight 1
<< Horde
step
#include f) The Wormlands
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name d) Melody of Madness (H)
#displayname Melody of Madness
#subweight 1
<< Horde
step
#include d) Melody of Madness
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name l) Subterfuge in Silk (H)
#displayname Subterfuge in Silk
#subweight 1
<< Horde
step
#include l) Subterfuge in Silk
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name a) Rak-Ush Swarmery (H)
#displayname Rak-Ush Swarmery
#subweight 1
<< Horde
step
#include a) Rak-Ush Swarmery
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#groupweight 9
#displayname Chapter 1 - Elwynn Forest
#name 1A_Elwynn Forest
#next 2A_Redridge Mountains
#fresh 30
#veteran
<< Alliance
step
#veteran
.goto 84,61.11,70.6
+The Darkmoon Faire event is now active, |cRXP_WARN_which guarantees you to gain an additional level for free and a temporary 10% experience boost.|r You'll need to purchase |cRXP_WARN_certain items from the auction house to take full advantage of this.|r If necessary,|cRXP_WARN_you can transfer gold from your other characters to make these purchases.|r However, if you find that you can't afford everything, |cRXP_WARN_It's still worthwhile to visit the Darkmoon Faire for the temporary experience buff and to buy only some of the items.|r
>>|cRXP_WARN_It is recommended to log in with a different character possessing at least 10,000 gold. Use this character to purchase the items and then send them over.|r
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Auctioneer Fitch|r
.collect 71715,1
.collect 71638,1
.collect 71637,1
.collect 71636,1
.collect 71635,1
.collect 71952,1
.collect 71951,1
.collect 71953,1
.collect 71716,1
.target Auctioneer Fitch
.target Auctioneer Jaxon
.target Auctioneer Chilton
.dmf
step
#fresh
+The Darkmoon Faire event is now active, |cRXP_WARN_which guarantees you to gain an additional level for free and a temporary 10% experience boost.|r
.dmf
step
#optional
.goto 37,41.71,52.74,-1
.goto 37,39.48,60.53,-1
.deathskip >> Die and respawn at the |cRXP_FRIENDLY_Spirit Healer|r
.isOnQuest 37112 
.skill riding,75,1
step << !Human !KulTiran
.goto 37,41.715,64.636
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bartlett the Brave|r
.fp Goldshire >> Get the Goldshire Flight Path
.target Bartlett the Brave
step
#optional
.goto 37,42.11,65.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal Dughan|r
.turnin 54 >>Turn in Report to Goldshire
.accept 62 >>Accept The Fargodeep Mine
.accept 26378 >>Accept Hero's Call: Westfall!
.target Marshal Dughan
.isOnQuest 54
step
.goto 37,42.11,65.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal Dughan|r
.accept 62 >>Accept The Fargodeep Mine
.accept 26378 >>Accept Hero's Call: Westfall!
.target Marshal Dughan
step << Human/KulTiran
.goto 37,41.708,65.541
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Smith Argus|r
.accept 26393 >>Accept A Swift Message
.target Smith Argus
step << Human/KulTiran
.goto 37,41.715,64.636
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bartlett the Brave|r
.turnin 26393 >>Turn in A Swift Message
.accept 26394 >>Accept Continue to Stormwind
.target Bartlett the Brave
step
#optional
#completewith next
.goto 37,43.19,65.74,5,0
.goto 37,43.23,65.95,5,0
.goto 37,43.318,65.705,4 >> Travel toward |cRXP_FRIENDLY_William Pestle|r
step
.goto 37,43.318,65.705
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_William Pestle|r
.accept 60 >>Accept Kobold Candles
.target William Pestle
step
#veteran
#completewith Cooking
.goto 37,43.77,65.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Innkeeper Farley|r.
>>|cRXP_BUY_Buy 5|r |T132789:0|t[Moonberry Juice] |cRXP_BUY_from him|r
>>|cRXP_WARN_The|r |T132789:0|t[Moonberry Juice] |cRXP_WARN_is for an|r |T4620669:0|t[Alchemy] |cRXP_WARN_Darkmoon Faire quest. If you don't want to train|r |T4620669:0|t[Alchemy]|cRXP_WARN_, skip the objective|r
.turnin 37112 >>Turn in Rest and Relaxation
.collect 1645,5,29506,1 
.home >>Set your Hearthstone to Lion's Pride Inn
.target Innkeeper Farley
.isQuestAvailable 47
.dmf
step
#veteran
.goto 37,43.77,65.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Innkeeper Farley|r
.turnin 37112 >>Turn in Rest and Relaxation
.home >>Set your Hearthstone to Lion's Pride Inn
.target Innkeeper Farley
.isQuestAvailable 47
.nodmf
step
#veteran
#label Cooking
.goto 37,44.37,65.99
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tomas|r
.train 2550 >> Train Cooking
.target Tomas
.dmf
step
#fresh
.goto 37,43.77,65.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Innkeeper Farley|r
.turnin 37112 >>Turn in Rest and Relaxation
.home >>Set your Hearthstone to Lion's Pride Inn
.target Innkeeper Farley
.isQuestAvailable 47
step
#optional
#completewith next
.goto 37,43.23,65.95,5,0
.goto 37,43.13,65.74,5,0
.goto 37,42.93,65.71,6,0
.goto 37,42.14,67.26,12 >> Travel toward |cRXP_FRIENDLY_Remy "Two Times"|r
step
.goto 37,42.14,67.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Remy "Two Times"|r
.accept 40 >>Accept A Fishy Peril
.accept 47 >>Accept Gold Dust Exchange
.target Remy "Two Times"
step
#veteran
.goto 37,41.95,67.16
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lien Farmer|r
>>|cRXP_WARN_These professions are used for Darkmoon Faire quests later. If you don't want to do this, skip this step|r
.train 2259 >> Train |T4620669:0|t[Alchemy] and |T4620676:0|t[Inscription]
.skipgossip 47384,2,1,1
.target Lien Farmer
.dmf
step
#veteran
.goto 37,41.95,67.16
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lien Farmer|r
.train 45357 >> Train |T4620676:0|t[Inscription]
.skipgossip 47384,3,6,2
.target Lien Farmer
.dmf
.train 2259,3 
step
#veteran
.goto 37,41.89,67.10
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tharynn Bouden|r. Buy the following items from him:
.collect 30817,5,29509,1 
.collect 39354,5,29515,1 
.target Tharynn Bouden
.dmf
.train 45357,3 
step
#veteran
.goto 37,41.89,67.10
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tharynn Bouden|r. Buy the following items from him:
.collect 30817,5,29509,1 
.target Tharynn Bouden
.dmf
step
.goto 37,43.2,65.99,5,0
.goto 37,43.2,65.63,5,0
.goto 37,42.9,65.7,5,0
.goto 37,41.78,69.55
.zone 407 >>Take the |cRXP_PICK_Darkmoon Faire Portal|r |cFFfa9602to the Darkmoon Island.|r
.dmf
step
#completewith next
+|TInterface/cursor/crosshair/interact.blp:20|tInteract with the |cRXP_FRIENDLY_Strider.|r |cRXP_WARN_only if you don't have a level 1 mount.|r
.dmf
step
#veteran
.goto 407,51.57,24.84,10,0
.goto 407,55.83,53.02,15,0
.goto 407,50.44,59.33
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kae Ti|r and buy a |T133734:0|t[Ride Ticket Book] from her.
*|cRXP_WARN_buy the cheaper version |cFFfa9602on the left in the window|r|r
.collect 92788,1,92794,1 
.target Kae Ti
.dmf
step
#completewith next
.goto 407,49.45,57.5
.cast 107829 >> |cRXP_WARN_Open Ride Ticket Book|r
.dmf
.use 92788
.use 92794
step
#veteran
.goto 407,49.45,57.5
>>|cRXP_WARN_Stand on the Carousel and |cRXP_WARN_wait for the Experience Buff to reach 60minutes|r|r
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the quest items in your bag |cRXP_WARN_and skip the ones you don't have)|
.accept 29464 >>Accept Tools of Divination
.accept 29451 >>Accept The Master Strategist
.accept 29456 >>Accept A Captured Banner
.accept 29457 >>Accept The Enemy's Insignia
.accept 29458 >>Accept The Captured Journal
.accept 29443 >>Accept A Curious Crystal
.accept 29444 >>Accept An Exotic Egg
.accept 29445 >>Accept An Intriguing Grimoire
.accept 29446 >>Accept A Wondrous Weapon
.zoneskip 407,1
.dmf
step
#fresh
.goto 407,49.45,57.5
>>|cRXP_WARN_Stand on the Carousel and |cRXP_WARN_wait for the Experience Buff to reach 60minutes|r|r
.zoneskip 407,1
.dmf
step
#veteran
.goto 407,51.91,60.94
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Professor Paleo|r
.turnin -29464 >>Turn in Tools of Divination
.turnin -29451 >>Turn in The Master Strategist
.turnin -29456 >>Turn in A Captured Banner
.turnin -29457 >>Turn in The Enemy's Insignia
.turnin -29458 >>Turn in The Captured Journal
.turnin -29443 >>Turn in A Curious Crystal
.turnin -29446 >>Turn in A Wondrous Weapon
.zoneskip 407,1
.dmf
step
#veteran
.goto 407,47.76,64.76
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gelvas Grimegate|r and buy as many |T669449:0|t[Darkmoon Top Hats] from him as you can.
.turnin 7905 >>Turn in The Darkmoon Faire
.collect 171364,1,29506,1 
.target Gelvas Grimegate
.zoneskip 407,1
.dmf
step
#fresh
.goto 407,47.76,64.76
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gelvas Grimegate|r
.turnin 7905 >>Turn in The Darkmoon Faire
.target Gelvas Grimegate
.zoneskip 407,1
.dmf
step
.goto 407,52.89,67.96
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Stamp Thunderhorn|r
.accept 29509 >>Accept Putting the Crunch in the Frog
.target Stamp Thunderhorn
.zoneskip 407,1
.dmf
step
.goto 407,52.88,67.96
>>Use the |T133642:0|t[Plump Frogs] to turn them into |T237579:0|t[Breaded Frogs].
.collect 72056,5,29509,1,-1 
.collect 30817,5,29509,1,-1 
.collect 72057,5,29509,1 
.use 72056 
.zoneskip 407,1
.dmf
.isOnQuest 29509
step
.goto 407,52.88,67.96
>>Use the |T237579:0|t[Breaded Frogs] near |cRXP_FRIENDLY_Stamp Thunderhorn|r
.collect 72057,5,29509,1,-1 
.complete 29509,1 
.use 72057 
.zoneskip 407,1
.dmf
.isOnQuest 29509
step
.goto 407,52.88,67.96
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Stamp Thunderhorn|r
.turnin 29509 >>Turn in Putting the Crunch in the Frog
.target Stamp Thunderhorn
.zoneskip 407,1
.dmf
step
.goto 407,50.54,69.56
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sylannia|r and buy |T132792:0|t[Fizzy Faire Drinks] from her.
.accept 29506 >>Accept A Fizzy Fusion
.collect 19299,5,29506,1 
.target Sylannia
.zoneskip 407,1
.dmf
.train 2259,3 
step
.goto 407,50.54,69.56
>>Use the |T132793:0|t[Cocktail Shaker] to make |T463532:0|t[Moonberry Fizz]
.collect 1645,5,29506,1,-1 
.collect 19299,5,29506,1,-1 
.complete 29506,1 
.use 72043 
.zoneskip 407,1
.dmf
.isOnQuest 29506
step
.goto 407,50.53,69.56
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sylannia|r
.turnin 29506 >>Turn in A Fizzy Fusion
.target Sylannia
.zoneskip 407,1
.dmf
.isOnQuest 29506
step
.goto 407,53.23,75.82
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sayge|r
.turnin 29445 >>Turn in An Intriguing Grimoire
.accept 29515 >>Accept Writing the Future
.target Sayge
.zoneskip 407,1
.dmf
.isOnQuest 29445
.train 45357,3 
step
#optional
.goto 407,53.23,75.82
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sayge|r
.turnin 29445 >>Turn in An Intriguing Grimoire
.target Sayge
.zoneskip 407,1
.dmf
.isOnQuest 29445
step
#optional
.goto 407,53.23,75.82
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sayge|r
.accept 29515 >>Accept Writing the Future
.target Sayge
.zoneskip 407,1
.dmf
.train 45357,3 
step
.goto 407,53.23,75.82
>>Use the |T413571:0|t[Bundle of Exotic Herbs] to make |T237061:0|t[Prophetic Ink]
.collect 71972,1,29515,1
.use 71971
.zoneskip 407,1
.dmf
.isOnQuest 29515
step
.goto 407,53.23,75.82
>>Use the |T237061:0|t[Prophetic Ink] to make |T134943:0|t[Fortunes]
.collect 39354,5,29515,1,-1 
.complete 29515,1 
.use 71972
.zoneskip 407,1
.dmf
.isOnQuest 29515
step
.goto 407,53.23,75.82
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sayge|r
.turnin 29515 >>Turn in Writing the Future
.target Sayge
.skipgossip
.zoneskip 407,1
.dmf
step
#veteran
.goto 407,51.11,82.04
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Yebb Neblegear|r
.turnin 29444 >>Turn in An Exotic Egg
.target Yebb Neblegear
.zoneskip 407,1
.dmf
.isOnQuest 29444
step
.goto 407,50.56,90.80
.zone 37 >>Take the |cRXP_PICK_Darkmoon Faire Portal|r |cFFfa9602to Elwynn Forest.|r
.zoneskip 407,1
.dmf
step
#completewith next
+|cRXP_WARN_Abandon your Professions|r
.link /run AbandonSkill(773); AbandonSkill(171); >> |cRXP_WARN_Click this text to receive a macro that will unlearn your professions.|r
.isOnQuest 60
.dmf
step
#sticky
#label Professions1
#completewith Professions3
.goto 37,41.95,67.16
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lien Farmer|r
>>|cRXP_WARN_Herbing Herbs and Mining Veins provides XP. Only gather resources in your direct path|r
>>|cRXP_WARN_If you don't want to do this, skip this step|r
.train 2366 >> Train |T4620675:0|t[Herbalism]
.train 2575 >> Train |T4620679:0|t[Mining]
.target Lien Farmer
.skipgossip 47396,1,1,1
.train 2366,1 
.train 2575,1 
step
#optional
#requires Professions1
#label Professions2
#completewith Professions3
.goto 37,41.95,67.16
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lien Farmer|r
>>|cRXP_WARN_Herbing Herbs provides XP. Only gather resources in your direct path|r
>>|cRXP_WARN_If you don't want to do this, skip this step|r
.train 2366 >> Train |T4620675:0|t[Herbalism]
.target Lien Farmer
.skipgossip 47396,2,2,2
.train 2575,3 
step
#optional
#requires Professions2
#label Professions3
.goto 37,41.95,67.16
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lien Farmer|r
>>|cRXP_WARN_Mining Veins provides XP. Only gather resources in your direct path|r
>>|cRXP_WARN_If you don't want to do this, skip this step|r
.train 2575 >> Train |T4620679:0|t[Mining]
.target Lien Farmer
.skipgossip 47396,2,3,2
.train 2366,3 
step
#veteran
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Julia Stevens|r.
>>|cRXP_WARN_Skip this step if you don't have level 25 Pet Battle Pets.|r
.goto 37,41.65,83.67
.accept 31693 >>Accept Julia Stevens
.target Julia Stevens
.isQuestTurnedIn 31903 
step
#veteran
>>Defeat |cRXP_ENEMY_Julia Stevens|r in a Pet Battle.
.complete 31693,1 
.target Julia Stevens
.isOnQuest 31693
step
#veteran
.goto 37,41.66,83.66
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Julia Stevens|r
.turnin 31693 >>Turn in Julia Stevens
.target Julia Stevens
.isQuestComplete 31693
step
#completewith FargodeepM
.goto 37,38.22,83.41,0
>>Kill |cRXP_ENEMY_Kobold Tunnelers|r and |cRXP_ENEMY_Kobold Miners|r. Loot them for their |cRXP_LOOT_Large Candles|r and |cRXP_LOOT_Gold Dust|r
.complete 60,1 
.complete 47,1 
.mob Kobold Tunneler
.mob Kobold Miner
step
#optional
.goto 37,38.22,83.41,40 >>|cRXP_WARN_[RARE] Check for |cRXP_ENEMY_Narg the Taskmaster|r. Kill him if he's up|r
.unitscan Narg the Taskmaster
.isOnQuest 60
.noflyable
step
#optional
#completewith next
.goto 37,38.94,82.23,12,0
.goto 38,42.52,71.63
.subzone 54 >> Enter the upper level of the Fargodeep Mine
step
#label FargodeepM
.goto 38,54.31,59.56,-1
.goto 39,66.53,66.18,-1
>>Enter one of the central rooms inside Fargodeep Mine
.complete 62,1 
step
.goto 37,37.82,86.14,40,0
.goto 37,37.89,81.45,40,0
.goto 39,47.59,68.00,20,0
.goto 39,60.14,82.29,20,0
.goto 39,78.65,28.65,20,0
.goto 39,57.67,25.29,20,0
.goto 38,53.73,72.25,20,0
.goto 37,37.82,86.14,40,0
.goto 37,37.89,81.45,40,0
.goto 39,47.59,68.00,20,0
.goto 39,60.14,82.29,20,0
.goto 39,78.65,28.65,20,0
.goto 39,57.67,25.29,20,0
.goto 38,53.73,72.25
>>Kill |cRXP_ENEMY_Kobold Tunnelers|r and |cRXP_ENEMY_Kobold Miners|r. Loot them for their |cRXP_LOOT_Large Candles|r and |cRXP_LOOT_Gold Dust|r
.complete 60,1 
.complete 47,1 
.mob Kobold Tunneler
.mob Kobold Miner
step
.goto 37,34.66,84.48
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ma Stonefield|r
.accept 88 >>Accept Princess Must Die!
.target Ma Stonefield
step
#optional
.goto 37,33.64,87.76,15 >>|cRXP_WARN_[CHEST] Check for the |cRXP_PICK_Chest|r inside the stables. Loot it if it's up|r
.isOnQuest 60
.noflyable
step
#loop
.line 37,32.48,86.81,33.41,86.16,33.32,84.95,32.58,84.26,32.04,85.20,32.48,86.81
.goto 37,33.32,84.95,0
.goto 37,32.04,85.20,20,0
.goto 37,32.58,84.26,20,0
.goto 37,33.32,84.95,20,0
.goto 37,33.41,86.16,20,0
.goto 37,32.48,86.81,20,0
>>Kill |cRXP_ENEMY_Princess|r. Loot her for her |cRXP_LOOT_Brass Collar|r
.complete 88,1 
.mob Princess
step
.goto 37,34.66,84.48
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ma Stonefield|r
.turnin 88 >>Turn in Princess Must Die!
.target Ma Stonefield
step
#optional
.goto 37,30.81,64.65,40 >>|cRXP_WARN_[RARE] Check for |cRXP_ENEMY_Morgaine the Sly|r inside. Kill her if she's up|r
.unitscan Morgaine the Sly
.isOnQuest 60
.noflyable
step
#optional
.goto 37,27.22,67.51,40 >>|cRXP_WARN_[RARE] Check for |cRXP_ENEMY_Grizzled Ben|r. Kill him if he's up|r
.unitscan Grizzled Ben
.isOnQuest 60
.noflyable
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Wanted Poster|r and |cRXP_FRIENDLY_Deputy Rainer|r
.accept 176 >>Accept WANTED: "Hogger"
.goto 37,24.55,74.67
.accept 11 >>Accept Riverpaw Gnoll Bounty
.goto 37,24.23,74.45
.target Deputy Rainer
step
#completewith Bounty
.goto 37,24.36,93.65,0
.goto 37,26.10,91.95,0
.goto 37,25.30,88.95,0
.goto 37,27.80,88.36,0
.goto 37,27.67,86.21,0
.goto 37,26.32,86.82,0
+|cRXP_WARN_[RARE & CHEST] Keep an eye out for the |cRXP_PICK_Chest|r and |cRXP_ENEMY_Gruff Swiftbite|r in the camps. Loot the |cRXP_PICK_Chest|r if you find one, and kill |cRXP_ENEMY_Gruff Swiftbite|r if he's up|r
.unitscan Gruff Swiftbite
.noflyable
step
#sticky
#label Armbands
#loop
.goto 37,24.36,93.65,0
.goto 37,26.10,91.95,0
.goto 37,25.30,88.95,0
.goto 37,27.80,88.36,0
.goto 37,27.67,86.21,0
.goto 37,26.32,86.82,0
.waypoint 37,24.36,93.65,40,0
.waypoint 37,26.10,91.95,40,0
.waypoint 37,25.30,88.95,40,0
.waypoint 37,27.80,88.36,40,0
.waypoint 37,27.67,86.21,40,0
.waypoint 37,26.32,86.82,40,0
>>Kill |cRXP_ENEMY_Riverpaw Outrunners|r and |cRXP_ENEMY_Riverpaw Runts|r. Loot them for their |cRXP_LOOT_Painted Gnoll Armbands|r
.complete 11,1 
.mob *Riverpaw Outrunner
.mob *Riverpaw Runt
step
#sticky
#label Deed
.goto 37,24.78,95.26
>>Click the |cRXP_PICK_Westfall Deed|r on the ground
.accept 184 >>Accept Furlbrow's Deed
step
#label Hogger
.goto 37,24.85,95.14
>>Defeat |cRXP_ENEMY_Hogger|r
>>|cRXP_WARN_DON'T wait out the RP after you defeat him|r
.complete 176,1 
.mob Hogger
.mob Minion of Hogger
step
#optional
#requires Deed
step
#label Bounty
#requires Armbands
.goto 37,24.23,74.45
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Deputy Rainer|r
.turnin 11 >>Turn in Riverpaw Gnoll Bounty
.target Deputy Rainer
step
#veteran
.goto 52,60.85,18.49
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Old MacDonald|r
>>|cRXP_WARN_Skip this step if you don't have level 25 Pet Battle Pets.|r
.accept 31780 >>Accept Old MacDonald
.target Old MacDonald
.isQuestTurnedIn 31903
step
#veteran
.goto 52,61.04,18.82
>>Defeat |cRXP_ENEMY_Old MacDonald|r in a Pet Battle
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Old MacDonald
.complete 31780,1 
.target Old MacDonald
.skipgossip 65648,1
.isOnQuest 31780
step
#veteran
.goto 52,61.04,18.82
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Old MacDonald|r
.turnin 31780 >>Turn in Old MacDonald
.target Old MacDonald
.isQuestComplete 31780
step
.goto 52,60.05,19.28,5,0
.goto 52,60.18,19.37
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Horatio Laine|r
.turnin 184 >>Turn in Furlbrow's Deed
.turnin 26378 >>Turn in Hero's Call: Westfall!
.accept 26209 >>Accept Murder Was The Case That They Gave Me
.target Lieutenant Horatio Laine
step
#loop
.goto 52,58.23,18.12,0
.goto 52,58.56,16.21,20,0
.goto 52,59.18,18.16,20,0
.goto 52,58.12,19.58,20,0
.goto 52,57.31,18.33,20,0
.goto 52,58.56,16.21,20,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Homeless Stormwind Citizens|r, |cRXP_FRIENDLY_West Plains Drifters|r, and |cRXP_FRIENDLY_Transients|r. Pay them for their |cRXP_LOOT_Clues|r.
.complete 26209,1 
.complete 26209,2 
.complete 26209,3 
.complete 26209,4 
.target Homeless Stormwind Citizen
.target West Plains Drifter
.target Transients
.skipgossip 42383,1 
.skipgossip 42384,1 
.skipgossip 42386,1 
.skipgossip 42391,1 
.skill riding,75,1
step
#loop
#optional
.goto 52,58.23,18.12,0
.goto 52,58.56,16.21,20,0
.goto 52,59.18,18.16,20,0
.goto 52,58.12,19.58,20,0
.goto 52,57.31,18.33,20,0
.goto 52,58.56,16.21,20,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Homeless Stormwind Citizens|r, |cRXP_FRIENDLY_West Plains Drifters|r, and |cRXP_FRIENDLY_Transients|r for their |cRXP_LOOT_Clues|r.
>>|cRXP_WARN_Stay mounted and spam talk to them, ignore them if they turn hostile|r
.complete 26209,1 
.complete 26209,2 
.complete 26209,3 
.complete 26209,4 
.target Homeless Stormwind Citizen
.target West Plains Drifter
.target Transients
.skipgossip 2
.skill riding,<75,1
step
.goto 52,60.05,19.28,5,0
.goto 52,60.18,19.37
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Horatio Laine|r
.turnin 26209 >>Turn in Murder Was The Case That They Gave Me
.accept 26213 >>Accept Hot On the Trail: The Riverpaw Clan
.target Lieutenant Horatio Laine
step
#optional
#completewith Horatio
.goto 52,56.46,13.26,30 >>|cRXP_WARN_[CHEST] Check for a |cRXP_PICK_Chest|r in the camp|r
.noflyable
step
#loop
.goto 52,56.46,13.26,0
.goto 52,58.16,10.71,40,0
.goto 52,57.17,15.12,40,0
.goto 52,51.38,15.89,40,0
.goto 52,50.68,14.77,40,0
.goto 52,56.46,13.26,40,0
>>Kill |cRXP_ENEMY_Riverpaw Scouts|r and |cRXP_ENEMY_Riverpaw Gnolls|r. Loot them for the |cRXP_LOOT_Riverpaw Gnoll Clue|r
.complete 26213,1 
.mob Riverpaw Scout
.mob Riverpaw Gnoll
step
#label Horatio
.goto 52,60.05,19.28,5,0
.goto 52,60.18,19.37
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Horatio Laine|r
.turnin 26213 >>Turn in Hot On the Trail: The Riverpaw Clan
.target Lieutenant Horatio Laine
step
#completewith next
.hs >>Hearth to Lion's Pride Inn
step
.goto 37,43.32,65.70
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_William Pestle|r
.turnin 60 >>Turn in Kobold Candles
.target William Pestle
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Remy "Two Times"|r and |cRXP_FRIENDLY_Marshal Dughan|r
.turnin 47 >>Turn in Gold Dust Exchange
.goto 37,42.14,67.25
.target +Remy "Two Times"
.turnin 62 >>Turn in The Fargodeep Mine
.turnin 40 >>Turn in A Fishy Peril
.accept 35 >>Accept Further Concerns
.accept 76 >>Accept The Jasperlode Mine
.turnin 176 >>Turn in WANTED: "Hogger"
.goto 37,42.11,65.93
.target +Marshal Dughan
.isOnQuest 40
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Remy "Two Times"|r and |cRXP_FRIENDLY_Marshal Dughan|r
.turnin 47 >>Turn in Gold Dust Exchange
.goto 37,42.14,67.25
.target +Remy "Two Times"
.turnin 62 >>Turn in The Fargodeep Mine
.accept 35 >>Accept Further Concerns
.accept 76 >>Accept The Jasperlode Mine
.turnin 176 >>Turn in WANTED: "Hogger"
.goto 37,42.11,65.93
.target +Marshal Dughan
step
.goto 37,41.69,65.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Andrew Krighton|r
.vendor >>Vendor and Repair
.isOnQuest 35
.target Andrew Krighton
.noflyable 
step
#optional
.goto 37,52.25,62.90,40 >>|cRXP_WARN_[RARE] Check for |cRXP_ENEMY_Lamepaw the Whimperer|r. Kill him if he's up|r
.unitscan Lamepaw the Whimperer
.isOnQuest 35
.noflyable
step
#optional
.goto 37,57.49,64.61,45 >> |cRXP_WARN_[CHEST] Scan the murloc islands with your mouse for a|r |cRXP_PICK_Chest|r. Your mouse will become a |TInterface/cursor/crosshair/interact.blp:20|tgear icon if there's a |cRXP_PICK_Chest|r. If you find one. Loot it if it's up|r
.isOnQuest 35
.noflyable
step
#optional
.goto 37,66.51,63.83,40 >>|cRXP_WARN_[RARE] Check for |cRXP_ENEMY_Tarantis|r. Kill him if he's up|r
.unitscan Tarantis
.isOnQuest 35
.noflyable
step
#optional
.goto 37,64.7,56.73,30 >>|cRXP_WARN_[CHEST] Check for the |cRXP_PICK_Chest|r inside the Kobold Camp. Loot it if it's up|r
.isOnQuest 35
.noflyable
step
#completewith next
.goto 37,61.65,53.93,12,0
.goto 40,48.05,87.33
.subzone 54 >>Enter the Jasperlode Mine
step
.goto 40,44.22,67.89,12,0
.goto 40,38.71,60.84,12,0
.goto 40,35.92,52.81
>>Follow the middle path inside Jasperlode Mine
.complete 76,1 
step
#optional
.goto 40,31.02,37.51,20,0
.goto 40,37.01,50.26,20,0
.goto 40,47.25,36.66,20,0
.goto 40,53.93,30.58,20,0
.goto 40,45.14,21.76,20 >>|cRXP_WARN_[RARE] Check for |cRXP_ENEMY_Mother Fang|r at the back of Jasperlode Mine. Kill her if she's up|r
.unitscan Mother Fang
.isOnQuest 35
.noflyable
step
#completewith next
.goto 37,61.58,70.04,0
.deathskip >> Die and Respawn at the |cRXP_FRIENDLY_Spirit Healer|r
.isOnQuest 35
.skill riding,75,1
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Guard Thomas|r and the |cRXP_FRIENDLY_Bounty Board|r
.turnin 35 >>Turn in Further Concerns
.accept 37 >>Accept Find the Lost Guards
.accept 52 >>Accept Protect the Frontier
.goto 37,73.973,72.177
.target +Guard Thomas
.accept 46 >>Accept Bounty on Murlocs
.accept 26152 >>Accept WANTED: James Clark
.goto 37,74.025,72.310
step
#completewith next
>>Kill |cRXP_ENEMY_Prowlers|r and |cRXP_ENEMY_Gray Forest Wolves|r
>>Kill any |cRXP_ENEMY_Young Forest Bears|r you see
.complete 52,1 
.mob +*Prowler
.mob +*Gray Forest Wolf
.complete 52,2 
.mob +Young Forest Bear
step
#optional
.goto 37,82.95,84.82,40 >>|cRXP_WARN_[RARE] Check for |cRXP_ENEMY_Bushtail|r. Kill him if he's up|r
.isOnQuest 52
.unitscan Bushtail
.noflyable
step
#completewith next
.goto 37,75.71,86.29,0
>>Kill |cRXP_ENEMY_Murloc Foragers|r and |cRXP_ENEMY_Murloc Lurkers|r. Loot them for their |cRXP_LOOT_Torn Murloc Fins|r
.complete 46,1,4 
.mob Murloc Forager
.mob Murloc Lurker
step
.goto 37,75.71,86.29,30,0
.goto 37,77.55,85.75
.deathskip >> Whilst killing |cRXP_ENEMY_Murloc Foragers|r and |cRXP_ENEMY_Murloc Lurkers|r, die and respawn at the |cRXP_FRIENDLY_Spirit Healer|r
.isOnQuest 46
.skill riding,75,1
step
.goto 37,83.283,66.089
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rallic Finn|r
.vendor 1198 >> Vendor and Repair
.target Rallic Finn
.isOnQuest 52
.noflyable 
step
.goto 37,79.462,68.715
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sara Timberlain|r
.accept 83 >>Accept Fine Linen Goods
.target Sara Timberlain
step
.goto 37,78.87,67.20,10,0
.goto 37,78.637,67.157
>>Kill |cRXP_FRIENDLY_James Clark|r inside. Loot him for |cRXP_LOOT_James Clark's Head|r and the |T134939:0|t|cRXP_LOOT_[Gold Pickup Schedule]|r
>>|cRXP_WARN_Use the |T134939:0|t|cRXP_LOOT_[Gold Pickup Schedule]|r to start the quest|r
.complete 26152,1 
.collect 1307,1,123,1 
.accept 123 >>Accept The Collector
.mob James Clark
.use 1307
step
.goto 37,81.382,66.112
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Supervisor Raelen|r
.accept 5545 >> Accept A Bundle of Trouble
.target Supervisor Raelen
step
.goto 37,81.860,66.040
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal Patterson|r
.turnin 26152 >>Turn in WANTED: James Clark
.turnin 123 >>Turn in The Collector
.accept 147 >>Accept Manhunt
.target Marshal Patterson
step
#completewith StoneCairn
.goto 37,81.72,58.57,0
.goto 37,77.99,60.59,0
.goto 37,71.58,60.84,0
.goto 37,74.75,67.13,0
.goto 37,87.15,64.63,0
>>Kill |cRXP_ENEMY_Prowlers|r and |cRXP_ENEMY_Gray Forest Wolves|r
>>Kill any |cRXP_ENEMY_Young Forest Bears|r you see
.complete 52,1 
.mob +*Prowler
.mob +*Gray Forest Wolf
.complete 52,2 
.mob +Young Forest Bear
step
#completewith MurlocFins
.goto 37,80.88,53.78,0
.goto 37,80.63,62.25,0
.goto 37,82.79,60.12,0
>>Loot |cRXP_LOOT_Bundles of Wood|r on the ground next to the trees
.complete 5545,1 
step
#label LostGuards
.goto 37,72.653,60.323
>>Click |cRXP_PICK_A half-eaten body|r on the ground
.turnin 37 >>Turn in Find the Lost Guards
.accept 45 >>Accept Discover Rolf's Fate
step
#label StoneCairn
.goto 37,79.795,55.510
.subzone 86 >> Travel toward Stone Cairn Lake
.isOnQuest 45
step
#sticky
#label MurlocFins
#loop
.goto 37,78.837,55.770,0
.waypoint 37,80.004,53.783,40,0
.waypoint 37,79.222,54.041,40,0
.waypoint 37,78.554,55.834,40,0
.waypoint 37,77.474,57.257,40,0
.waypoint 37,77.991,58.108,40,0
.waypoint 37,79.370,57.016,40,0
>>Kill |cRXP_ENEMY_Murloc Foragers|r and |cRXP_ENEMY_Murloc Lurkers|r. Loot them for their |cRXP_LOOT_Torn Murloc Fins|r
>>|cRXP_WARN_Be careful as |cRXP_ENEMY_Murloc Foragers|r will cast|r |T135915:0|t[Drink Minor Potion] |cRXP_WARN_which heals themselves for 61-68 health|r
.complete 46,1 
.mob Murloc Forager
.mob Murloc Lurker
step
.goto 37,79.795,55.510
>>Click |cRXP_PICK_Rolf's corpse|r on the ground
.turnin 45 >>Turn in Discover Rolf's Fate
.accept 71 >>Accept Report to Thomas
step
#sticky
#label PTFrontier
#requires MurlocFins
#loop
.goto 37,81.72,58.57,0
.goto 37,77.99,60.59,0
.goto 37,71.58,60.84,0
.goto 37,74.75,67.13,0
.goto 37,87.15,64.63,0
.waypoint 37,81.72,58.57,60,0
.waypoint 37,77.99,60.59,60,0
.waypoint 37,71.58,60.84,60,0
.waypoint 37,74.75,67.13,60,0
.waypoint 37,87.15,64.63,60,0
>>Kill |cRXP_ENEMY_Prowlers|r and |cRXP_ENEMY_Gray Forest Wolves|r
>>Kill any |cRXP_ENEMY_Young Forest Bears|r you see
.complete 52,1 
.mob +*Prowler
.mob +*Gray Forest Wolf
.complete 52,2 
.mob +Young Forest Bear
step
#loop
#requires MurlocFins
.goto 37,80.88,53.78,0
.goto 37,80.63,62.25,0
.goto 37,82.79,60.12,0
.goto 37,80.88,53.78,20,0
.goto 37,80.48,55.18,20,0
.goto 37,79.79,56.71,20,0 
.goto 37,79.04,59.56,20,0
.goto 37,77.30,59.56,20,0 
.goto 37,77.18,60.65,20,0 
.goto 37,76.75,61.76,20,0
.goto 37,77.13,63.00,20,0
.goto 37,78.38,62.35,20,0
.goto 37,79.30,63.34,20,0
.goto 37,80.24,61.47,20,0
.goto 37,80.63,62.25,20,0
.goto 37,81.57,62.64,20,0
.goto 37,81.27,61.59,20,0
.goto 37,82.00,61.01,20,0
.goto 37,83.27,61.12,20,0
.goto 37,84.20,61.55,20,0
.goto 37,83.85,60.48,20,0
.goto 37,82.79,60.12,20,0
>>Loot |cRXP_LOOT_Bundles of Wood|r on the ground next to the trees
.complete 5545,1 
step << skip
#requires MurlocFins
#completewith next
.goto 37,77.65,57.70
>>|cRXP_WARN_Skip this if you're not low at health|r
.deathskip >>Die and respawn at the |cRXP_FRIENDLY_Spirit Healer|r
step
.goto 37,73.973,72.177
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Guard Thomas|r
.turnin 46 >> Turn in Bounty on Murlocs
.turnin 52 >> Turn in Protect the Frontier
.turnin 71 >> Turn in Report to Thomas
.accept 59 >> Accept Cloth and Leather Armor
.target Guard Thomas
step
#completewith Morgan
.goto 37,68.56,82.68,0
.goto 37,67.63,78.01,0
.goto 37,68.23,76.33,0
.goto 37,71.31,76.93,0
.goto 37,71.81,78.51,0
>>Kill |cRXP_ENEMY_Bandits|r, |cRXP_ENEMY_Erlan Drudgemoor|r inside, and |cRXP_ENEMY_Surena Caledon|r inside. Loot them for their |cRXP_LOOT_Linen Scraps|r
.complete 83,1 
.mob Bandit
.mob Erlan Drudgemoor
.mob Surena Caledon
step
#optional
#label Morgan
.goto 37,71.02,80.67
>>Kill |cRXP_ENEMY_Morgan the Collector|r inside. Loot him for |cRXP_LOOT_The Collector's Ring|r and |cRXP_LOOT_Linen Scraps|r
>>|cRXP_WARN_[CHEST] Check for the |cRXP_PICK_Chest|r in and around the house. Loot it if it's up|r
.complete 147,1 
.complete 83,1 
.disablecheckbox
.mob Morgan the Collector
.itemcount 1019,<6
.isOnQuest 83
step
.goto 37,71.02,80.67
>>Kill |cRXP_ENEMY_Morgan the Collector|r inside. Loot him for |cRXP_LOOT_The Collector's Ring|r
>>|cRXP_WARN_[CHEST] Check for the |cRXP_PICK_Chest|r in and around the house. Loot it if it's up|r
.complete 147,1 
.mob Morgan the Collector
step
#optional
#sticky
#label Snoot
.goto 37,69.32,79.31,30 >>|cRXP_WARN_[RARE] Check for |cRXP_ENEMY_Snoot the Rooter|r. Kill him if he's up|r
.unitscan Snoot the Rooter
.isOnQuest 83
.noflyable
step
#loop
.goto 37,68.56,82.68,0
.goto 37,67.63,78.01,0
.goto 37,68.23,76.33,0
.goto 37,71.31,76.93,0
.goto 37,71.81,78.51,0
.goto 37,70.62,80.73,50,0
.goto 37,68.56,82.68,50,0
.goto 37,67.83,80.86,50,0
.goto 37,67.63,78.01,50,0
.goto 37,68.55,77.39,50,0
.goto 37,68.23,76.33,50,0
.goto 37,70.97,77.21,10,0
.goto 37,71.31,76.93,10,0
.goto 37,70.84,78.22,50,0
.goto 37,71.81,78.51,50,0
>>Kill |cRXP_ENEMY_Bandits|r. Loot them for their |cRXP_LOOT_Linen Scraps|r
>>|cRXP_WARN_[CHEST] Check for the |cRXP_PICK_Chest|r in and around the barn. Loot it if it's up|r
.complete 83,1 
.mob Bandit
step
#completewith next
#requires Snoot
.goto 37,75.71,86.29,30,0
.goto 37,77.55,85.75,-1
.goto 37,83.68,69.74,-1
.deathskip >> Die and respawn at the |cRXP_FRIENDLY_Spirit Healer|r
.isOnQuest 83
.skill riding,75
step
#requires Snoot
.goto 37,83.283,66.089
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rallic Finn|r
.vendor 1198 >>Vendor and Repair
.target Rallic Finn
.isOnQuest 83
.noflyable 
step << !DarkIronDwarf !KulTiran !LightforgedDraenei !Mechagnome !VoidElf
.goto 37,81.829,66.556
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Goss the Swift|r
.fp Eastvale Logging Camp >> Get the Eastvale Logging Camp flight path
.target Goss the Swift
step
.goto 37,81.860,66.040
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal Patterson|r
.turnin 147 >>Turn in Manhunt
.target Marshal Patterson
step
.goto 37,81.382,66.112
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Supervisor Raelen|r
.turnin 5545 >> Turn in A Bundle of Trouble
.target Supervisor Raelen
step
.goto 37,79.462,68.715
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sara Timberlain|r
.turnin 83 >> Turn in Fine Linen Goods
.turnin 59 >> Turn in Cloth and Leather Armor
.target Sara Timberlain
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#name 2A_Redridge Mountains
#displayname Chapter 2 - Redridge Mountains
#next 3A_Duskwood
#fresh 30
#veteran
<< Alliance
step
#completewith next
.zone 49 >> Travel to Redridge Mountains
.isQuestAvailable 26504
step
.goto 49,16.03,64.63
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_FRIENDLY_Wanted Poster.|r
.accept 26504 >>Accept WANTED: Redridge Gnolls
step
.goto 49,15.622,65.327
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Darcy Parker|r
.accept 26506 >>Accept Franks and Beans
.target Darcy Parker
step
.goto 49,15.309,64.691
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Watch Captain Parker|r atop Tower Watch
.accept 26503 >>Accept Still Assessing the Threat
.target Watch Captain Parker
step
#loop
.goto 49,13.543,66.732,50,0
.goto 49,12.566,69.384,50,0
.goto 49,14.471,75.116,50,0
.goto 49,15.220,73.203,50,0
>>Kill |cRXP_ENEMY_Tarantulas|r. Loot them for their |cRXP_LOOT_Tarantula Eyes|r
.complete 26506,1 
.mob Tarantula
step
#completewith Martie
.goto 49,16.461,54.587,0
.goto 49,20.199,58.665,0
.goto 49,20.881,65.321,0
.goto 49,20.123,66.613,0
.goto 49,16.993,63.436,0
.goto 49,13.697,68.732,0
.goto 49,13.265,62.483,0
.goto 49,27.403,59.815,0
.goto 49,29.142,56.606,0
.goto 49,32.433,54.249,0
.goto 49,33.624,57.701,0
.goto 49,35.378,64.225,0
.goto 49,32.309,63.674,0
.goto 49,29.952,64.571,0
>>Kill |cRXP_ENEMY_Dire Condors|r flying above or sitting on perches. Loot them for their |cRXP_LOOT_Condor Giblets|r
>>Kill |cRXP_ENEMY_Great Goretusks|r. Loot them for their |cRXP_LOOT_Goretusk Kidneys|r
.complete 26506,2 
.unitscan +Dire Condor
.complete 26506,3 
.mob +Great Goretusk
step
#completewith next
.goto 49,28.028,74.887,0
.goto 49,30.563,62.710,0
.goto 49,25.600,57.889,0
.goto 49,16.203,55.263,0
>>Kill |cRXP_ENEMY_Redridge Thrashers|r, |cRXP_ENEMY_Redridge Mongrels|r, and |cRXP_ENEMY_Redridge Brutes|r
.complete 26504,1 
.mob *Redridge Thrasher
.mob *Redridge Mongrel
.mob *Redridge Brute
step
.goto 49,16.203,55.263
>>Loot the |cRXP_PICK_Gnoll Battle Plans|r on the ground
.complete 26503,1 
step
#label Martie
.goto 49,22.043,42.696
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Martie Jainrose|r
.accept 26509 >>Accept An Unwelcome Guest
.target Martie Jainrose
step
.goto 49,16.919,45.720,0
.goto 49,17.203,44.935,15,0
.goto 49,16.919,45.720,15,0
.goto 49,17.375,45.858,15,0
.goto 49,16.919,45.720
>>Kill |cRXP_ENEMY_Bellygrub|r. Loot her for |cRXP_LOOT_Bellygrub's Tusk|r
.complete 26509,1 
.mob Bellygrub
step
.goto 49,22.043,42.696
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Martie Jainrose|r
.turnin 26509 >>Turn in An Unwelcome Guest
.target Martie Jainrose
step
#optional
#completewith next
.goto 49,26.093,42.716,10,0
.goto 49,26.138,42.315,8,0
.goto 49,26.306,42.096,8 >> Enter the Lakeshire Inn
.pve
.isOnQuest 76
step
.goto 49,26.393,41.425
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Innkeeper Brianna|r
.home >> Set your Hearthstone to Lakeshire
.target Innkeeper Brianna
.pve
.isOnQuest 76
step
#optional
#completewith next
.goto 49,28.282,41.910,8,0
.goto 49,27.972,41.567,8 >> Enter the Lakeshire Town Hall
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bailiff Conacher|r and |cRXP_FRIENDLY_Magistrate Solomon.|r
.accept 26511 >>Accept Lake Everstill Clean Up
.accept 26728 >>Accept Hero's Call: Duskwood!
.goto 49,28.681,40.955
.target +Bailiff Conacher
.accept 26510 >>Accept We Must Prepare!
.goto 49,28.971,41.123
.target +Magistrate Solomon
step
#optional
#completewith next
.goto 49,27.960,41.519,8,0
.goto 49,28.310,41.910,8,0
.goto 49,28.588,42.644,15 >> Exit the Lakeshire Town Hall
step
.goto 49,28.344,48.874
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shawn|r
.accept 26508 >>Accept Nida's Necklace
.target Shawn
step
#loop
.goto 49,19.760,47.282,0
.goto 49,21.922,48.497,0
.goto 49,23.938,49.802,0
.goto 49,25.321,49.235,0
.goto 49,25.985,46.815,0
.goto 49,27.096,50.935,0
.goto 49,29.752,49.376,0
.goto 49,32.075,50.279,0
.goto 49,34.767,49.432,0
.goto 49,35.716,49.607,0
.goto 49,19.760,47.282,40,0
.goto 49,21.922,48.497,40,0
.goto 49,23.938,49.802,40,0
.goto 49,25.321,49.235,40,0
.goto 49,25.985,46.815,40,0
.goto 49,27.096,50.935,40,0
.goto 49,29.752,49.376,40,0
.goto 49,32.075,50.279,40,0
.goto 49,34.767,49.432,40,0
.goto 49,35.716,49.607,40,0
>>|cRXP_WARN_Swim underwater and check the spawn locations. There are 10 locations with 2 spawns up at once|r
>>Open the |cRXP_PICK_Glinting Mud|r. Loot it for |cRXP_LOOT_Nida's Necklace|r
.complete 26508,1 
.isOnQuest 26508
step
.goto 49,29.419,53.759
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ariena Stormfeather|r
.fp Lakeshire >>Get the Lakeshire Flight Path
.target Ariena Stormfeather
step
#sticky
#label EverstillMurlocs
#loop
.goto 49,37.818,42.158,0
.goto 49,39.626,46.404,0
.goto 49,36.095,45.006,40,0
.goto 49,36.580,43.202,40,0
.goto 49,37.798,41.157,40,0
.goto 49,38.840,41.673,40,0
.goto 49,40.457,44.698,40,0
.goto 49,42.557,47.125,40,0
.goto 49,40.397,48.986,40,0
.goto 49,36.943,50.290,40,0
.goto 49,36.640,46.754,40,0
>>Kill |cRXP_ENEMY_Murloc Flesheaters|r and |cRXP_ENEMY_Murloc Scouts|r
.complete 26511,1 
.mob Murloc Flesheater
.mob Murloc Scout
step
#optional
#completewith next
.goto 49,37.742,42.179,20 >>|cRXP_WARN_[RARE] Check for |cRXP_ENEMY_Squiddic|r in front of the |cRXP_PICK_Gnomecorder|r. Kill him if he's up|r
.unitscan Squiddic
.noflyable
step
.goto 49,37.818,42.158
>>Loot the |cRXP_PICK_Gnomecorder|r on the ground
.complete 26510,1 
step
#requires EverstillMurlocs
.goto 49,28.277,48.871
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nida|r
.turnin 26508 >>Turn in Nida's Necklace
.isQuestComplete 26508
.target Nida
step
#optional
.abandon 26508 >>Abandon Nida's Necklace
step
#optional
#completewith next
.goto 49,28.282,41.910,8,0
.goto 49,27.972,41.567,8 >> Enter the Lakeshire Town Hall
step
#requires EverstillMurlocs
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bailiff Conacher|r and |cRXP_FRIENDLY_Magistrate Solomon|r inside the Lakeshire Town Hall
.turnin 26511 >>Turn in Lake Everstill Clean Up
.goto 49,28.681,40.955
.target +Bailiff Conacher
.turnin 26510 >>Turn in We Must Prepare!
.accept 26512 >>Accept Tuning the Gnomecorder
.goto 49,28.971,41.123
.target +Magistrate Solomon
step
#optional
#completewith Marris
.goto 49,27.960,41.519,8,0
.goto 49,28.310,41.910,8,0
.goto 49,28.588,42.644,15 >> Exit the Lakeshire Town Hall
step
.goto 49,28.836,43.577
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Karen Taylor|r
.vendor >>Vendor and Repair
.target Karen Taylor
.isOnQuest 76
step << DarkIronDwarf
#optional
#completewith RRWarmode1
.cast 265225 >>Cast |T1786409:0|t[Mole Machine]
.xp <20,1
.pve
.isOnQuest 76
step << DarkIronDwarf
#optional
#completewith RRWarmode1
.zone 84 >>Talk to the |cRXP_FRIENDLY_Mole Machine|r to travel to Stormwind
.skipgossip 143925,1,2
.xp <20,1
.pve
.isOnQuest 76
step << !DarkIronDwarf Monk
#optional
#completewith RRWarmode1
.zone 379 >>Cast |T775462:0|t[Zen Pilgrimage]
.xp <20,1
.pve
.isOnQuest 76
step << !DarkIronDwarf Monk
#optional
#completewith RRWarmode1
.goto 379,48.967,43.368
>>Click the |cRXP_PICK_Portal to Stormwind|r
.xp <20,1
.pve
.isOnQuest 76
step << Monk
#optional
#completewith RRWarmode1
.goto 84,49.45,86.60,8,0
.goto 84,49.51,86.67,10 >>Exit the Mage Tower
.pve
.isOnQuest 76
step << !Monk !DarkIronDwarf
#optional
#completewith RRWarmode1
.goto 49,29.419,53.759
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ariena Stormfeather|r
.fly Stormwind >>Fly to Stormwind
.target Ariena Stormfeather
.xp <20,1
.pve
.isOnQuest 76
step
#optional
#label RRWarmode1
+|cRXP_WARN_Open Up your Talents (Default N) and turn on Warmode to an XP buff and extra talents.
>>|cRXP_WARN_Skip this step if you don't want to turn on Warmode.|r
.pve
.xp <20,1
step
#optional
#completewith JasperlodeEnd1
.goto 84,70.938,72.472
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dungar Longdrink|r
.fly Goldshire >>Fly to Goldshire
.target Dungar Longdrink
.zoneskip 84,1
.xp <20,1
step
#optional
#completewith JasperlodeEnd1
.goto 49,29.419,53.759
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ariena Stormfeather|r
.fly Goldshire >>Fly to Goldshire
.target Ariena Stormfeather
.zoneskip 49,1
.xp <20,1
step
#optional
#label JasperlodeEnd1
.goto 37,42.105,65.927
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal Dughan|r
.turnin 76 >>Turn in The Jasperlode Mine
.target Marshal Dughan
.xp <20,1
step
#optional
#completewith Marris
.goto 37,41.715,64.636
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bartlett the Brave|r
.fly Lakeshire >>Fly to Lakeshire
.target Bartlett the Brave
.zoneskip 49
.xp <20,1
.cooldown item,6948,<0
step
#optional
#completewith Marris
.hs >> Hearth to Lakeshire
.zoneskip 49
.xp <20,1
.cooldown item,6948,>0,1
step
#label Marris
.goto 49,31.856,44.894
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal Marris|r
.accept 26513 >>Accept Like a Fart in the Wind
.target Marshal Marris
step
.goto 49,32.330,39.544
>>Go into the Lakeshire graveyard
.complete 26512,1 
.turnin 26512 >>Turn in Tuning the Gnomecorder
.accept 26514 >>Accept Canyon Romp
step
#sticky
#label DirtScroll
.goto 49,36.305,30.502,0
.goto 49,32.496,24.909,0
.goto 49,30.051,28.018,0
.goto 49,27.453,27.292,0
.goto 49,27.470,34.077,0
.goto 49,21.637,34.274,0
.goto 49,23.390,26.005,0
.waypoint 49,36.305,30.502,50,0
.waypoint 49,32.496,24.909,50,0
.waypoint 49,30.051,28.018,50,0
.waypoint 49,27.453,27.292,50,0
.waypoint 49,27.470,34.077,50,0
.waypoint 49,21.637,34.274,50,0
.waypoint 49,23.390,26.005,50,0
>>Kill |cRXP_ENEMY_Redridge Gnolls|r. Loot them for the |T134944:0|t|cRXP_LOOT_[Dirt-Stained Scroll]|r
>>|cRXP_WARN_Use the |T134944:0|t|cRXP_LOOT_[Dirt-Stained Scroll]|r to start the quest|r
.collect 58898,1,26519,1 
.accept 26519 >>Accept He Who Controls the Ettins
.mob Redridge Drudger
.mob Redridge Mystic
.mob Redridge Basher
.mob Redridge Alpha
.mob Redridge Brute
.use 58898
step
#loop
.goto 49,36.305,30.502,0
.goto 49,32.496,24.909,0
.goto 49,30.051,28.018,0
.goto 49,27.453,27.292,0
.goto 49,27.470,34.077,0
.goto 49,21.637,34.274,0
.goto 49,23.390,26.005,0
.goto 49,36.305,30.502,50,0
.goto 49,32.496,24.909,50,0
.goto 49,30.051,28.018,50,0
.goto 49,27.453,27.292,50,0
.goto 49,27.470,34.077,50,0
.goto 49,21.637,34.274,50,0
.goto 49,23.390,26.005,50,0
>>Loot the |cRXP_LOOT_Redridge Supply Crates|r on the ground
>>Kill |cRXP_ENEMY_Redridge Drudgers|r, |cRXP_ENEMY_Redridge Mystics|r, |cRXP_ENEMY_Redridge Bashers|r, |cRXP_ENEMY_Redridge Alphas|r, and |cRXP_ENEMY_Redridge Brutes|r. Loot them for their |cRXP_LOOT_Redridge Gnoll Collars|r
>>|cRXP_WARN_Avoid pulling the |cRXP_ENEMY_Canyon Ettins|r that patrol the area|r
.complete 26513,1 
.disablecheckbox
.complete 26514,1 
.mob Redridge Drudger
.mob Redridge Mystic
.mob Redridge Basher
.mob Redridge Alpha
.mob Redridge Brute
.unitscan Canyon Ettin
step
.goto 49,20.431,26.655
>>|cRXP_WARN_Click the pop-up in your questlog|r
.turnin 26514 >>Turn in Canyon Romp
.accept 26544 >>Accept They've Wised Up...
step
#optional
#completewith next
.goto 49,36.305,30.502,0
.goto 49,32.496,24.909,0
.goto 49,30.051,28.018,0
.goto 49,27.453,27.292,0
.goto 49,27.470,34.077,0
.goto 49,21.637,34.274,0
.goto 49,23.390,26.005,0
>>Loot the |cRXP_LOOT_Redridge Supply Crates|r on the ground
>>|cRXP_WARN_Avoid pulling the |cRXP_ENEMY_Canyon Ettins|r that patrol the area|r
.complete 26513,1 
.unitscan Canyon Ettin
step
#completewith Ardo
#requires DirtScroll
.goto 49,20.431,26.655
.subzone 98 >> Enter the Rethban Caverns
.isOnQuest 26544
step
#sticky
#requires DirtScroll
#label Missive1
#loop
.goto 49,20.337,15.044,0
.goto 49,22.424,17.323,0
.goto 49,22.425,21.890,0
.goto 49,21.588,23.647,0
.goto 49,19.525,24.078,0
.goto 49,20.141,21.509,0
.goto 49,16.783,19.487,0
.waypoint 49,20.337,15.044,20,0
.waypoint 49,22.424,17.323,20,0
.waypoint 49,22.425,21.890,20,0
.waypoint 49,21.588,23.647,20,0
.waypoint 49,19.525,24.078,20,0
.waypoint 49,20.141,21.509,20,0
.waypoint 49,16.783,19.487,20,0
>>Kill |cRXP_ENEMY_Blackrock Overseers|r inside Rethban Caverns. Loot them for the |cRXP_LOOT_Blackrock Orc Missive|r
.complete 26544,1 
.mob *Blackrock Overseer
step
#sticky
#label Missive2
#requires Missive1
>>|cRXP_WARN_Click the pop-up in your questlog|r
.turnin 26544 >>Turn in They've Wised Up...
.accept 26545 >>Accept Yowler Must Die!
step
#optional
#completewith next
#requires DirtScroll
.goto 49,19.502,24.380,20,0
.goto 49,18.121,22.037,20,0
.goto 49,17.650,17.871,20,0
.goto 49,19.884,17.025,15 >>Travel toward |cRXP_ENEMY_Ardo Dirtpaw|r inside Rethban Caverns
step
#requires DirtScroll
#label Ardo
.goto 49,18.432,18.172
>>Kill |cRXP_ENEMY_Ardo Dirtpaw|r. Click the |cRXP_PICK_Ettin Control Orb|r next to him
>>|cRXP_WARN_[CHEST] Check for the |cRXP_PICK_Chest|r next to him. Loot it if it's up|r
.complete 26519,1 
.goto 49,18.432,18.172
.mob +Ardo Dirtpaw
.turnin 26519 >>Turn in He Who Controls the Ettins
.accept 26520 >>Accept Saving Foreman Oslow
.goto 49,17.841,18.618
step
#requires Missive1
.goto 49,20.431,26.655,25,0
.goto 49,21.318,27.426,40 >>Exit the Rethban Caverns
.isOnQuest 26520
.zoneskip 49,1 
step
#sticky
#label SupplyCrates
#loop
.goto 49,36.305,30.502,0
.goto 49,32.496,24.909,0
.goto 49,30.051,28.018,0
.goto 49,27.453,27.292,0
.goto 49,27.470,34.077,0
.goto 49,21.637,34.274,0
.goto 49,23.390,26.005,0
.waypoint 49,36.305,30.502,50,0
.waypoint 49,32.496,24.909,50,0
.waypoint 49,30.051,28.018,50,0
.waypoint 49,27.453,27.292,50,0
.waypoint 49,27.470,34.077,50,0
.waypoint 49,21.637,34.274,50,0
.waypoint 49,23.390,26.005,50,0
>>Loot the |cRXP_LOOT_Redridge Supply Crates|r on the ground
>>|cRXP_WARN_Avoid pulling the |cRXP_ENEMY_Canyon Ettins|r that patrol the area|r
.complete 26513,1 
.unitscan Canyon Ettin
step
#requires Missive2
.goto 49,26.870,21.977
>>Kill |cRXP_ENEMY_Yowler|r. Loot him for the |cRXP_LOOT_Blackrock Invasion Plans|r
.complete 26545,1 
.complete 26545,2 
.mob Yowler
step
#completewith next
#requires SupplyCrates
#loop
.goto 49,23.859,29.302,0
.goto 49,22.766,34.745,0
.goto 49,24.022,35.828,0
.goto 49,28.492,36.235,0
.goto 49,27.799,30.853,0
.line 49,23.859,29.302,23.973,30.595,23.762,32.089,22.766,34.745,23.014,35.134,23.619,34.381,24.022,35.828,25.529,35.789,26.902,36.339,28.492,36.235,28.357,34.410,27.054,32.432,27.799,30.853,27.502,28.865,26.595,28.355,25.013,28.408
.goto 49,23.859,29.302,50,0
.goto 49,23.973,30.595,50,0
.goto 49,23.762,32.089,50,0
.goto 49,22.766,34.745,50,0
.goto 49,23.014,35.134,50,0
.goto 49,23.619,34.381,50,0
.goto 49,24.022,35.828,50,0
.goto 49,25.529,35.789,50,0
.goto 49,26.902,36.339,50,0
.goto 49,28.492,36.235,50,0
.goto 49,28.357,34.410,50,0
.goto 49,27.054,32.432,50,0
.goto 49,27.799,30.853,50,0
.goto 49,27.502,28.865,50,0
.goto 49,26.595,28.355,50,0
.goto 49,25.013,28.408,50,0
.cast 80704 >> Whilst standing still, use the |T332402:0|t[Ettin Control Orb] on a |cRXP_ENEMY_Canyon Ettin|r
.use 58895
.unitscan Canyon Ettin
.isOnQuest 26520
step
#requires SupplyCrates
.goto 49,31.480,44.344
>>Travel toward |cRXP_FRIENDLY_Foreman Oslow|r. Use the |T332402:0|t[Ettin Control Orb] next to him whilst you control a |cRXP_FRIENDLY_Subdued Canyon Ettin|r
.complete 26520,1 
.use 58895
step
.goto 49,31.856,44.894
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal Marris|r
.turnin 26513 >>Turn in Like a Fart in the Wind
.target Marshal Marris
step
#completewith next
.goto 49,28.836,43.577
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Karen Taylor|r
.vendor >>Vendor and Repair
.target Karen Taylor
step
#optional
#completewith next
.goto 49,28.282,41.910,8,0
.goto 49,27.972,41.567,8 >> Enter the Lakeshire Town Hall
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Magistrate Solomon|r and |cRXP_FRIENDLY_Colonel Troteman|r
.turnin 26520 >>Turn in Saving Foreman Oslow
.turnin 26545 >>Turn in Yowler Must Die!
.goto 49,28.971,41.123
.target +Magistrate Solomon
.accept 26567 >>Accept John J. Keeshan
.goto 49,28.659,40.744,5,0
.goto 49,28.892,40.894,5,0
.goto 49,28.659,40.744
.target +Colonel Troteman
step
#optional
#completewith next
.goto 49,27.960,41.519,8,0
.goto 49,28.310,41.910,8,0
.goto 49,28.588,42.644,15 >> Exit the Lakeshire Town Hall
step
#optional
#completewith KeeshanStart
.goto 49,26.093,42.716,10,0
.goto 49,26.138,42.315,8,0
.goto 49,26.306,42.096,8 >> Enter the Lakeshire Inn
step
.goto 49,26.393,41.425
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Innkeeper Brianna|r
.home >> Set your Hearthstone to Lakeshire
.target Innkeeper Brianna
.isQuestAvailable 76
step
#optional
#completewith next
.goto 49,26.253,40.514,8,0
.goto 49,25.945,39.756,6 >>Go into the backroom, then go downstairs toward |cRXP_FRIENDLY_John J. Keeshan|r
step
#label KeeshanStart
.goto 49,26.297,40.131
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_John J. Keeshan|r in the Lakeshire Inn basement
.turnin 26567 >>Turn in John J. Keeshan
.accept 26568 >>Accept This Ain't My War
.target John J. Keeshan
step
#optional
#completewith next
.goto 49,25.945,39.756,8,0
.goto 49,26.253,40.514,8,0
.goto 49,26.306,42.096,8,0
.goto 49,26.138,42.315,8,0
.goto 49,26.093,42.716,10 >> Exit the Lakeshire Inn
step
#optional
#completewith next
.goto 49,28.282,41.910,8,0
.goto 49,27.972,41.567,8 >> Enter the Lakeshire Town Hall
step
.goto 49,28.659,40.744
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Colonel Troteman|r inside
.turnin 26568 >>Turn in This Ain't My War
.accept 26571 >>Accept Weapons of War
.accept 26586 >>Accept In Search of Bravo Company
.target Colonel Troteman
step
#optional
#completewith next
.goto 49,27.960,41.519,8,0
.goto 49,28.310,41.910,8,0
.goto 49,28.588,42.644,15 >> Exit the Lakeshire Town Hall
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Foreman Oslow|r and |cRXP_FRIENDLY_Marshal Marris|r
.accept 26569 >>Accept Surveying Equipment
.goto 49,29.652,44.548
.target +Foreman Oslow
.accept 26570 >>Accept Render's Army
.goto 49,29.731,44.519
.target +Marshal Marris
step
#optional
.goto 49,37.932,34.200,50 >>|cRXP_WARN_[RARE] Check for |cRXP_ENEMY_Chatter|r. Kill him if he's up|r
.unitscan Chatter
.isOnQuest 26570
.noflyable
step
#completewith Render
.goto 49,44.299,30.816,0
.goto 49,41.458,35.639,0
.goto 49,44.548,35.896,0
.goto 49,47.950,33.981,0
.goto 49,47.671,40.994,0
.goto 49,51.823,42.459,0
.goto 49,53.901,37.198,0
>>Kill |cRXP_ENEMY_Blackrock Renegades|r and |cRXP_ENEMY_Blackrock Scouts|r
.complete 26570,1 
.mob Blackrock Scout
.mob Blackrock Renegade
step
#completewith next
.goto 49,41.173,36.033,0
.goto 49,43.955,34.962,0
.goto 49,45.024,31.802,0
.goto 49,41.037,32.557,0
>>Kill |cRXP_ENEMY_Dire Condors|r flying above. Loot them for their |cRXP_LOOT_Condor Giblets|r
.complete 26506,2 
.mob Dire Condor
step
.goto 49,47.529,41.955
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Messner|r
.turnin 26586 >>Turn in In Search of Bravo Company
.accept 26587 >>Accept Breaking Out is Hard to Do
.target Messner
step
>>Kill |cRXP_ENEMY_Murdunk|r and |cRXP_ENEMY_Homurk|r. Loot them for |cRXP_LOOT_Keeshan's Bow|r and |cRXP_LOOT_Keeshan's Survival Knife|r
.complete 26571,2 
.goto 49,51.525,41.398
.mob +Homurk
.complete 26571,1 
.goto 49,51.681,41.330
.mob +Murdunk
step
#sticky
#label Heart
>>|cRXP_WARN_Click the pop-up in your questlog|r
.turnin 26571 >>Turn in Weapons of War
.accept 26573 >>Accept His Heart Must Be In It
step
.goto 49,49.234,38.005
>>Open |cRXP_PICK_Blackrock Key Pouch|r in the stump. Loot it for |cRXP_LOOT_Messner's Cage Key|r
>>|cRXP_WARN_Avoid the |cRXP_ENEMY_Blackrock Worg Captain|r and |cRXP_ENEMY_Blackrock Battle Worgs|r|r
.complete 26587,1 
.unitscan Blackrock Worg Captain
.mob Blackrock Battle Worg
step
#requires Heart
.goto 49,47.529,41.955
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Messner|r in the cage, then when he reappears next to you
.turnin 26587 >>Turn in Breaking Out is Hard to Do
.timer 3,Messner RP
.accept 26560 >>Accept Jorgensen
.target Messner
step
#loop
.goto 49,41.173,36.033,0
.goto 49,43.955,34.962,0
.goto 49,45.024,31.802,0
.goto 49,41.037,32.557,0
.goto 49,41.173,36.033,50,0
.goto 49,43.955,34.962,50,0
.goto 49,45.024,31.802,50,0
.goto 49,41.037,32.557,50,0
>>Kill |cRXP_ENEMY_Dire Condors|r flying above. Loot them for their |cRXP_LOOT_Condor Giblets|r
.complete 26506,2 
.target Dire Condor
step
#completewith Utroka
.goto 49,43.021,11.211,0
.goto 49,43.264,15.478,0
.goto 49,39.373,18.359,0
.goto 49,42.471,22.338,0
.goto 49,45.114,27.577,0
>>Kill |cRXP_ENEMY_Great Goretusks|r. Loot them for their |cRXP_LOOT_Goretusk Kidneys|r
.complete 26506,3 
.mob Great Goretusk
step
#optional
#label Render
.goto 49,43.143,23.741,60 >>Travel toward the outskirts of Render's Camp
.isOnQuest 26560
.noflyable 
step
#completewith Danforth
#label Spyglass1
.goto 49,42.789,21.487,0
.goto 49,43.357,17.991,0
.goto 49,42.034,14.041,0
.goto 49,36.291,15.982,0
.goto 49,32.625,10.192,0
>>Kill |cRXP_ENEMY_Blackrock Summoners|r and |cRXP_ENEMY_Blackrock Trackers|r. Loot the |cRXP_ENEMY_Blackrock Trackers|r for their |cRXP_LOOT_Blackrock Spyglasses|r
.complete 26570,1 
.complete 26569,1 
.mob Blackrock Tracker
.mob Blackrock Summoner
.itemcount 58952,<5 
step
#optional
#completewith Danforth
#requires Spyglass1
.goto 49,42.789,21.487,0
.goto 49,43.357,17.991,0
.goto 49,42.034,14.041,0
.goto 49,36.291,15.982,0
.goto 49,32.625,10.192,0
>>Kill |cRXP_ENEMY_Blackrock Summoners|r and |cRXP_ENEMY_Blackrock Trackers|r
.complete 26570,1 
.mob Blackrock Tracker
.mob Blackrock Summoner
.itemcount 58952,5 
step
#label Utroka
.goto 49,43.546,10.819
>>Kill |cRXP_ENEMY_Utroka the Keymistress|r. Loot her for |cRXP_LOOT_Jorgensen's Cage Key|r
.complete 26560,1 
.mob Utroka the Keymistress
step
#optional
#loop
.goto 49,43.021,11.211,0
.goto 49,43.264,15.478,0
.goto 49,39.373,18.359,0
.goto 49,42.471,22.338,0
.goto 49,45.114,27.577,0
.waypoint 49,43.021,11.211,55,0
.waypoint 49,43.264,15.478,55,0
.waypoint 49,39.373,18.359,55,0
.waypoint 49,42.471,22.338,55,0
.waypoint 49,45.114,27.577,55,0
>>Kill |cRXP_ENEMY_Great Goretusks|r. Loot them for their |cRXP_LOOT_Goretusk Kidneys|r
.complete 26506,3 
.mob Great Goretusk
step
#optional
#completewith next
.goto 49,36.022,15.133,40,0
.goto 49,35.846,14.524,40,0
.goto 49,33.538,11.867,15 >> Travel toward |cRXP_FRIENDLY_Jorgensen|r
.noflyable 
step
#optional
.goto 49,33.538,11.867
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jorgensen|r in the cage and when he reappears next to you
>>|cRXP_WARN_[RARE & CHEST] Keep an eye out for the |cRXP_PICK_Chest|r and |cRXP_ENEMY_Kazon|r in front of the tent. Kill him if he's up|r
.turnin 26560 >>Turn in Jorgensen
.timer 3,Jorgensen RP
.accept 26561 >>Accept Krakauer
.target Jorgensen
.unitscan Kazon
step
#completewith BlackrockC
#label RendersRock
.goto 49,30.861,9.190,20 >> Enter Render's Rock
.isOnQuest 265261
step
#sticky
#label Tarak
#requires RendersRock
.goto 49,26.057,10.450,0,0
>>Kill |cRXP_ENEMY_Ritualist Tarak|r inside
>>|cRXP_WARN_[CHEST] Keep an eye out for a |cRXP_PICK_Chest|r near him|r
.complete 26561,1 
.mob +Ritualist Tarak
step
#optional
#completewith BlackrockC
#requires RendersRock
.goto 49,30.050,9.353
.goto 49,29.150,10.594
.goto 49,26.586,10.530,15 >>Travel toward the |cRXP_PICK_Blackrock Coffer|r inside
step
#label BlackrockC
.goto 49,26.586,10.530
>>Open the |cRXP_PICK_Blackrock Coffer|r on the ground inside. Loot it for |cRXP_LOOT_Keeshan's Red Headband|r and |cRXP_LOOT_Keeshan's Jade Amulet|r
.complete 26573,1 
.complete 26573,2 
step
#requires Tarak
.goto 49,25.906,10.487
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Krakauer|r on the altar inside and when he reappears next to you
.turnin 26561 >>Turn in Krakauer
.timer 3,Krakauer RP
.accept 26562 >>Accept And Last But Not Least... Danforth
.target Krakauer
step
#optional
#completewith next
.goto 49,26.615,13.314,15,0
.goto 49,25.552,14.772,15,0
.goto 49,25.856,16.403,15,0
.goto 49,27.634,18.155,15 >Travel toward |cRXP_ENEMY_Overlord Barbarius|r inside
step
.goto 49,27.634,18.155
>>Kill |cRXP_ENEMY_Overlord Barbarius|r inside. Loot him for the |cRXP_LOOT_Blackrock Lever Key|r
>>|cRXP_WARN_Make sure your Guardians teleport down when you jump down|r
.complete 26562,1 
.complete 26562,2 
.mob Overlord Barbarius
step
#completewith next
.goto 49,27.765,17.943
.cast 80887 >>|cRXP_WARN_Click the |cRXP_PICK_Chain Lever|r on the ground inside|r
.isOnQuest 26562
step
#label Danforth
.goto 49,28.326,17.012
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Danforth|r inside in the water and when he reappears next to you
.turnin 26562 >>Turn in And Last But Not Least... Danforth
.timer 3,Danforth RP
.accept 26563 >>Accept Return of the Bravo Company
.target Danforth
step
#optional
#completewith next
.goto 49,30.100,15.657,15,0
.goto 49,30.004,12.928,15,0
.goto 49,29.820,10.349,15,0
.goto 49,30.372,9.117,15,0
.goto 49,31.635,9.630,30 >> Exit Render's Rock
step
#optional
#loop
.goto 49,42.789,21.487,0
.goto 49,43.357,17.991,0
.goto 49,42.034,14.041,0
.goto 49,36.291,15.982,0
.goto 49,32.625,10.192,0
.goto 49,45.155,23.968,55,0
.goto 49,42.789,21.487,55,0
.goto 49,41.185,20.004,55,0
.goto 49,41.167,17.881,55,0
.goto 49,43.357,17.991,55,0
.goto 49,44.269,13.930,55,0
.goto 49,41.899,12.146,55,0
.goto 49,42.034,14.041,55,0
.goto 49,40.282,16.319,55,0
.goto 49,38.889,17.678,55,0
.goto 49,36.291,15.982,55,0
.goto 49,34.239,13.808,55,0
.goto 49,34.298,11.938,55,0
.goto 49,32.625,10.192,55,0
>>Kill |cRXP_ENEMY_Blackrock Summoners|r and |cRXP_ENEMY_Blackrock Trackers|r. Loot the |cRXP_ENEMY_Blackrock Trackers|r for their |cRXP_LOOT_Blackrock Spyglasses|r
.complete 26570,1 
.complete 26569,1 
.mob Blackrock Tracker
.mob Blackrock Summoner
step
#completewith next
.hs >> Hearth to Lakeshire
step
.goto 49,26.456,42.038
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kimberly Hiett|r in the Lakeshire Inn
.vendor >>Vendor and Repair
.target Kimberly Hiett
.isOnQuest 26573
step
#optional
#completewith next
.goto 49,28.282,41.910,8,0
.goto 49,27.972,41.567,8 >> Enter the Lakeshire Town Hall
step
.goto 49,28.659,40.744
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Colonel Troteman|r
.turnin 26563 >>Turn in Return of the Bravo Company
.turnin 26573 >>Turn in His Heart Must Be In It
.accept 26607 >>Accept They Drew First Blood
.target Colonel Troteman
step
#optional
#completewith next
.goto 49,27.960,41.519,8,0
.goto 49,28.310,41.910,8,0
.goto 49,28.588,42.644,15 >> Exit the Lakeshire Town Hall
step
#optional
#completewith Keeshan2
.goto 49,26.093,42.716,10,0
.goto 49,26.138,42.315,8,0
.goto 49,26.306,42.096,8 >> Enter the Lakeshire Inn
step
#optional
#completewith next
.goto 49,26.253,40.514,8,0
.goto 49,25.945,39.756,6 >>Go into the backroom, then go downstairs toward |cRXP_FRIENDLY_John J. Keeshan|r
step
#label Keeshan2
.goto 49,26.334,40.112
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_John J. Keeshan|r in the Lakeshire Inn basement
.turnin 26607 >>Turn in They Drew First Blood
.accept 26616 >>Accept It's Never Over
.target John J. Keeshan
step << DarkIronDwarf
#optional
#completewith RRWarmode2
.cast 265225 >>Cast |T1786409:0|t[Mole Machine]
.xp <20,1
.pve
.isOnQuest 76
step << DarkIronDwarf
#optional
#completewith RRWarmode2
.zone 84 >>Talk to the |cRXP_FRIENDLY_Mole Machine|r to travel to Stormwind
.skipgossip 143925,1,2
.xp <20,1
.pve
.isOnQuest 76
step << !DarkIronDwarf Monk
#optional
#completewith RRWarmode2
.zone 379 >>Cast |T775462:0|t[Zen Pilgrimage]
.xp <20,1
.pve
.isOnQuest 76
step << !DarkIronDwarf Monk
#optional
#completewith RRWarmode2
.goto 379,48.967,43.368
>>Click the |cRXP_PICK_Portal to Stormwind|r
.xp <20,1
.pve
.isOnQuest 76
step << Monk
#optional
#completewith RRWarmode2
.goto 84,49.45,86.60,8,0
.goto 84,49.51,86.67,10 >>Exit the Mage Tower
.pve
.isOnQuest 76
step << !Monk !DarkIronDwarf
#optional
#completewith RRWarmode2
.goto 49,29.419,53.759
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ariena Stormfeather|r
.fly Stormwind >>Fly to Stormwind
.target Ariena Stormfeather
.xp <20,1
.pve
.isOnQuest 76
step
#optional
#label RRWarmode2
+|cRXP_WARN_Open Up your Talents (Default N) and turn on Warmode to an XP buff and extra talents.
>>|cRXP_WARN_Skip this step if you don't want to turn on Warmode.|r
.pve
.xp <20,1
step
#optional
#completewith JasperlodeEnd2
.goto 84,70.938,72.472
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dungar Longdrink|r
.fly Goldshire >>Fly to Goldshire
.target Dungar Longdrink
.zoneskip 84,1
.xp <20,1
step
#optional
#completewith JasperlodeEnd2
.goto 49,29.419,53.759
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ariena Stormfeather|r
.fly Goldshire >>Fly to Goldshire
.target Ariena Stormfeather
.zoneskip 49,1
.xp <20,1
step
#optional
#label JasperlodeEnd2
.goto 37,42.105,65.927
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal Dughan|r
.turnin 76 >>Turn in The Jasperlode Mine
.target Marshal Dughan
.xp <20,1
step
#optional
#completewith Boat
.goto 37,41.715,64.636
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bartlett the Brave|r
.fly Lakeshire >>Fly to Lakeshire
.target Bartlett the Brave
.zoneskip 49
.xp <20,1
.cooldown item,6948,<0
step
#optional
#label HearthLS1
#completewith Boat
.hs >> Hearth to Lakeshire
.zoneskip 49
.xp <20,1
.cooldown item,6948,>0,1
step
#optional
#requires HearthLS1
#completewith next
.goto 49,26.306,42.096,8,0
.goto 49,26.138,42.315,8,0
.goto 49,26.108,42.747,10 >> Exit the Lakeshire Inn 
.zoneskip 49,1
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Foreman Oslow|r and |cRXP_FRIENDLY_Marshal Marris|r
.turnin 26569 >>Turn in Surveying Equipment
.goto 49,29.652,44.548
.target +Foreman Oslow
.turnin 26570 >>Turn in Render's Army
.goto 49,29.731,44.519
.target +Marshal Marris
step
#label Boat
.goto 49,34.426,45.914
.vehicle >> Get into |cRXP_PICK_Keeshan's Riverboat|r
.timer 43,It's Never Over RP
.isOnQuest 26616
step
.goto 49,52.901,52.999
>>Wait out the RP
>>|cRXP_WARN_Manually leave the boat when the timer completes|r
.complete 26616,1 
step
#completewith Muckdwellers
.goto 49,52.920,54.640
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Arlen Marsters|r
.fp >>Get the Camp Everstill Flight Path
.target Arlen Marsters
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_John J. Keeshan|r, |cRXP_FRIENDLY_Krakauer|r, |cRXP_FRIENDLY_Messner|r, and |cRXP_FRIENDLY_Danforth|r
.turnin 26616 >>Turn in It's Never Over
.accept 26639 >>Accept Point of Contact: Brubaker
.goto 49,52.551,55.408
.target +John J. Keeshan
.accept 26636 >>Accept Bravo Company Field Kit: Camouflage
.goto 49,52.402,55.407
.target +Krakauer
.accept 26637 >>Accept Bravo Company Field Kit: Chloroform
.goto 49,52.432,55.541
.target +Messner
.accept 26638 >>Accept Hunting the Hunters
.goto 49,52.533,55.557
.target +Danforth
step
#label Muckdwellers
#loop
.goto 49,48.669,54.976,0
.goto 49,46.956,56.688,0
.goto 49,43.168,55.127,0
.goto 49,39.453,57.087,0
.goto 49,39.358,50.183,0
.goto 49,45.014,49.280,0
.goto 49,48.669,54.976,55,0
.goto 49,48.798,57.741,55,0
.goto 49,46.786,58.420,55,0
.goto 49,46.956,56.688,55,0
.goto 49,44.610,54.864,55,0
.goto 49,44.320,52.796,55,0
.goto 49,43.168,55.127,55,0
.goto 49,41.915,53.874,55,0
.goto 49,40.214,54.370,55,0
.goto 49,39.453,57.087,55,0
.goto 49,38.895,60.012,55,0
.goto 49,38.064,52.309,55,0
.goto 49,39.358,50.183,55,0
.goto 49,40.550,47.338,55,0
.goto 49,42.860,49.655,55,0
.goto 49,45.014,49.280,55,0
>>Kill |cRXP_ENEMY_Muckdwellers|r underwater. Loot them for their |cRXP_LOOT_Muckdweller Glands|r
>>|cRXP_WARN_Avoid|r |cRXP_ENEMY_Ol' Gummers|r
.complete 26637,1 
.mob Muckdweller
.unitscan Ol' Gummers
step
#sticky
#label Hunters
#loop
.goto 49,55.822,66.568,0
.goto 49,53.086,69.251,0
.goto 49,50.922,65.688,0
.goto 49,49.219,67.953,0
.goto 49,47.151,66.384,0
.goto 49,45.798,69.412,0
.goto 49,43.679,70.878,0
.goto 49,39.093,68.551,0
.waypoint 49,55.822,66.568,20,0
.waypoint 49,54.430,68.474,20,0
.waypoint 49,53.627,69.824,20,0
.waypoint 49,53.086,69.251,20,0
.waypoint 49,52.089,69.305,20,0
.waypoint 49,49.800,69.120,20,0
.waypoint 49,50.922,65.688,20,0
.waypoint 49,50.313,66.097,20,0
.waypoint 49,49.024,66.516,20,0
.waypoint 49,49.219,67.953,20,0
.waypoint 49,48.006,68.721,20,0
.waypoint 49,48.030,67.211,20,0
.waypoint 49,47.151,66.384,20,0
.waypoint 49,46.832,67.484,20,0
.waypoint 49,45.871,66.825,20,0
.waypoint 49,46.634,70.734,20,0
.waypoint 49,45.798,69.412,20,0
.waypoint 49,43.680,66.576,20,0
.waypoint 49,43.679,70.878,20,0
.waypoint 49,41.375,69.805,20,0
.waypoint 49,39.093,68.551,20,0
>>Kill |cRXP_ENEMY_Blackrock Hunters|r
>>|cRXP_WARN_Be careful as they are|r |T136041:0|t[Camouflaged]
.complete 26638,1 
.mob Blackrock Hunter
step
.goto 49,43.723,64.583,0 
.goto 49,39.080,69.773,0
.goto 49,41.122,69.990,0
.goto 49,42.532,70.274,0
.goto 49,45.198,68.405,0
.goto 49,47.075,66.697,0
.goto 49,39.080,69.773,40,0
.goto 49,39.687,69.959,40,0
.goto 49,40.424,68.797,40,0
.goto 49,41.122,69.990,40,0
.goto 49,41.557,68.559,40,0
.goto 49,42.280,69.740,40,0
.goto 49,42.532,70.274,40,0
.goto 49,44.090,70.194,40,0
.goto 49,43.958,67.755,40,0
.goto 49,45.198,68.405,40,0
.goto 49,46.057,69.072,40,0
.goto 49,47.075,66.697,40,0
>>Loot the |cRXP_LOOT_Piles of Leaves|r and |cRXP_LOOT_Fox Poop|r on the ground
>>|cRXP_WARN_[CHEST] Keep an eye out for the |cRXP_PICK_Chest|r in the Murloc Camp. Loot it if it's up|r
.complete 26636,1 
.complete 26636,2 
step
.goto 49,53.216,67.815,0 
.goto 49,53.052,67.825
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brubaker|r
>>|cRXP_WARN_[CHEST] Check for the |cRXP_PICK_Chest|r next to him. Loot it if it's up|r
.turnin 26639 >>Turn in Point of Contact: Brubaker
.accept 26640 >>Accept Unspeakable Atrocities
.target Brubaker
step
#optional
#questguide
#requires Hunters
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Messner|r, |cRXP_FRIENDLY_Krakauer|r, |cRXP_FRIENDLY_Danforth|r, and |cRXP_FRIENDLY_John J. Keeshan|r
.turnin 26637 >>Turn in Bravo Company Field Kit: Chloroform
.goto 49,52.432,55.541
.target +Messner
.turnin 26636 >>Turn in Bravo Company Field Kit: Camouflage
.goto 49,52.402,55.407
.target +Krakauer
.turnin 26638 >>Turn in Hunting the Hunters
.goto 49,52.533,55.557
.target +Danforth
.turnin 26640 >>Turn in Unspeakable Atrocities
.accept 26646 >>Accept Prisoners of War
.goto 49,52.551,55.408
.target +John J. Keeshan
step
#requires Hunters
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Messner|r, |cRXP_FRIENDLY_Krakauer|r, |cRXP_FRIENDLY_Danforth|r, and |cRXP_FRIENDLY_John J. Keeshan|r
.turnin 26637 >>Turn in Bravo Company Field Kit: Chloroform
.goto 49,52.432,55.541
.target +Messner
.turnin 26636 >>Turn in Bravo Company Field Kit: Camouflage
.goto 49,52.402,55.407
.target +Krakauer
.turnin 26638 >>Turn in Hunting the Hunters
.goto 49,52.533,55.557
.target +Danforth
.turnin 26640 >>Turn in Unspeakable Atrocities
.goto 49,52.551,55.408
.target +John J. Keeshan
step << DarkIronDwarf
#optional
#completewith RRWarmode3
.cast 265225 >>Cast |T1786409:0|t[Mole Machine]
.xp <20,1
.pve
.isOnQuest 76
step << DarkIronDwarf
#optional
#completewith RRWarmode3
.zone 84 >>Talk to the |cRXP_FRIENDLY_Mole Machine|r to travel to Stormwind
.skipgossip 143925,1,2
.xp <20,1
.pve
.isOnQuest 76
step << !DarkIronDwarf Monk
#optional
#completewith RRWarmode3
.zone 379 >>Cast |T775462:0|t[Zen Pilgrimage]
.xp <20,1
.pve
.isOnQuest 76
step << !DarkIronDwarf Monk
#optional
#completewith RRWarmode3
.goto 379,48.967,43.368
>>Click the |cRXP_PICK_Portal to Stormwind|r
.xp <20,1
.pve
.isOnQuest 76
step << Monk
#optional
#completewith RRWarmode3
.goto 84,49.45,86.60,8,0
.goto 84,49.51,86.67,10 >>Exit the Mage Tower
.pve
.isOnQuest 76
step << !Monk !DarkIronDwarf
#optional
#completewith RRWarmode3
.goto 49,29.419,53.759
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ariena Stormfeather|r
.fly Stormwind >>Fly to Stormwind
.target Ariena Stormfeather
.xp <20,1
.pve
.isOnQuest 76
step
#optional
#label RRWarmode3
+|cRXP_WARN_Open Up your Talents (Default N) and turn on Warmode to an XP buff and extra talents.
>>|cRXP_WARN_Skip this step if you don't want to turn on Warmode.|r
.pve
.xp <20,1
step
#optional
#completewith JasperlodeEnd3
.goto 84,70.938,72.472
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dungar Longdrink|r
.fly Goldshire >>Fly to Goldshire
.target Dungar Longdrink
.zoneskip 84,1
.xp <20,1
step
#optional
#completewith JasperlodeEnd3
.goto 49,29.419,53.759
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ariena Stormfeather|r
.fly Goldshire >>Fly to Goldshire
.target Ariena Stormfeather
.zoneskip 49,1
.xp <20,1
step
#optional
#label JasperlodeEnd3
.goto 37,42.105,65.927
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal Dughan|r
.turnin 76 >>Turn in The Jasperlode Mine
.target Marshal Dughan
.xp <20,1
step
#optional
#completewith RedridgeWarmode1
.goto 37,41.715,64.636
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bartlett the Brave|r
.fly Lakeshire >>Fly to Lakeshire
.target Bartlett the Brave
.zoneskip 49
.xp <20,1
.cooldown item,6948,<0
step
#optional
#completewith RedridgeWarmode1
.hs >> Hearth to Lakeshire
.zoneskip 49
.xp <20,1
.cooldown item,6948,>0,1
step
#optional
#label RedridgeWarmode1
.goto 49,35.45,60.53
.zone 49 >> Travel to Redridge Mountains
.isOnQuest 26504
step
#veteran
.goto 49,33.30,52.57
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lindsay.|r.
>>|cRXP_WARN_Skip this step if you don't have level 25 Pet Battle Pets.|r
.accept 31781 >>Accept Lindsay
.isQuestTurnedIn 31903
.target Lindsay
step
#veteran
.goto 49,33.30,52.57
>>Defeat |cRXP_ENEMY_Lindsay|r in a Pet Battle.
.complete 31781,1 
.skipgossip 65651,1
.isOnQuest 31781
.target Lindsay
step
#veteran
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 31781 >>Turn in Lindsay
.isQuestComplete 31781
step
#label RedridgeGnollKill
#completewith GnollOrders2
>>Kill |cRXP_ENEMY_Redridge Thrashers|r, |cRXP_ENEMY_Brutes|r, and |cRXP_ENEMY_Mongrels.|r
.complete 26504,1 
.target Redridge Thrasher
.target Redridge Brute
.target Redridge Mongrel
step
.goto 49,35.45,60.53,30 >>Check for |cRXP_ENEMY_Snarlflare|r (Rare) |cFFfa9602on the Mountain.|r
.unitscan Snarlflare
.isOnQuest 26504
step
.goto 49,30.14,61.20,30 >>Check for |cRXP_ENEMY_Ribchaser|r (Rare) |cFFfa9602in the camp.|r
.unitscan Ribchaser
.isOnQuest 26504
step
.goto 49,30.56,62.71
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Map|r |cFFfa9602on the ground.|r
.complete 26503,3 
step
#label GnollOrders2
.goto 49,28.03,74.88
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Gnoll Orders|r on the ground. Check for a |cRXP_PICK_Chest|r nearby
.complete 26503,2 
step
.goto 49,32.82,73.67,40,0
.goto 49,33.08,59.41
>>Kill |cRXP_ENEMY_Redridge Thrashers|r, |cRXP_ENEMY_Brutes|r, and |cRXP_ENEMY_Mongrels.|r
.complete 26504,1 
.mob Redridge Thrasher
.mob Redridge Brute
.mob Redridge Mongrel
step
.goto 49,24.37,71.20,40 >>Check for |cRXP_ENEMY_Gnollfraster|r(Rare).
.unitscan Gnollfeaster
.isOnQuest 26504
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Darcy|r and |cRXP_FRIENDLY_Parker.|r
.turnin 26506 >>Turn in Franks and Beans
.goto 49,15.62,65.33
.turnin 26503 >>Turn in Still Assessing the Threat
.turnin 26504 >>Turn in WANTED: Redridge Gnolls
.accept 26505 >>Accept in Parker's Report
.goto 49,15.42,65.91,8,0
.goto 49,15.32,64.59
.target Darcy Parker
.target Watch Captain Parker
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#name 3A_Duskwood
#displayname Chapter 3 - Duskwood
#next 4A_Northern Stranglethorn
#fresh 30
#veteran
<<Alliance
step
.goto 47,93.30,12.00
.zone 47 >> Travel |cFFfa9602to Duskwood|r
step
#completewith next
.goto 47,74.23,26.09,40,0
.goto 47,77.32,36.47,15 >>Travel to |cFFfa9602Manor Mistmantle.|r Check for a |cRXP_PICK_Chest|r |cFFfa9602in and around the House.|r
step
.goto 47,78.74,44.53,8,0
.goto 47,79.09,44.17
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tobias|r |cFFfa9602inside the house.|r
.accept 26666 >>Accept The Legend of Stalvan
.target Tobias Mistmantle
step
.goto 47,87.43,35.21
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Abercrombie.|r
.accept 26653 >>Accept Supplies from Darkshire
.target Abercrombie
step
#completewith next
.goto 47,87.98,33.16,20,0
.goto 47,88.1,31.33,20,0
.goto 47,90.98,30.53,30 >>Check for the |cRXP_ENEMY_Unknown Soldier|r(Rare).
.unitscan Unknown Soldier
step << !DarkIronDwarf !KulTiran !LightforgedDraenei !Mechagnome !VoidElf
#completewith Kabobs
.goto 47,77.48,44.28
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Felicia Maline|r
.fp Darkshire >>Get the Darkshire Flight Path
.target Felicia Maline
.isQuestTurnedIn 12801 << DK
step
.goto 47,75.56,45.37,8,0
.goto 47,75.83,45.26
>>Talk to |cRXP_FRIENDLY_Madame Eva|r |cFFfa9602inside the house.|r
.turnin 26653 >>Turn in Supplies from Darkshire
.accept 26652 >>Accept Ghost Hair Thread
.target Madame Eva
step
#completewith next
.goto 47,73.82,45.95,8,0
.goto 47,74.07,45.32,8 >>Go |cFFfa9602inside the Inn.|r
step
#completewith Daltry1
.goto 47,73.87,44.41
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Innkeeper Trelayne.|r
.home >>Set your Hearthstone to Scarlet Raven Tavern
.target Innkeeper Trelayne
step
#label Kabobs
.goto 47,73.74,43.48
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Chef Grual.|r
.accept 26620 >>Accept Seasoned Wolf Kabobs
.accept 26623 >>Accept Dusky Crab Cakes
.target Chef Grual
step
#completewith Daltry1
.goto 47,74.07,45.32,8,0
.goto 47,73.82,45.95,8>>Exit |cFFfa9602the Inn.|r
step
#label Daltry1
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Clerk Daltry|r and |cRXP_FRIENDLY_Commander Althea Ebonlocke.|r
.turnin 26666 >>Turn in The Legend of Stalvan
.accept 26667 >>Accept The Stolen Letters
.goto 47,72.44,46.91
.turnin 26728 >>Turn in Hero's Call: Duskwood!
.accept 26618 >>Accept Wolves at Our Heels
.goto 47,73.53,46.92
.target Clerk Daltry
.target Commander Althea Ebonlocke
.isOnQuest 26728
step
#label Daltry1
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Clerk Daltry|r and |cRXP_FRIENDLY_Commander Althea Ebonlocke.|r
.turnin 26666 >>Turn in The Legend of Stalvan
.accept 26667 >>Accept The Stolen Letters
.goto 47,72.44,46.91
.accept 26618 >>Accept Wolves at Our Heels
.goto 47,73.53,46.92
.target Clerk Daltry
.target Commander Althea Ebonlocke
step
.goto 47,75.33,48.02
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calor.|r
.accept 26688 >>Accept Worgen in the Woods
.target Calor
step << DarkIronDwarf
#optional
#completewith DWWarmode1
.cast 265225 >>Cast |T1786409:0|t[Mole Machine]
.xp <20,1
.pve
.isOnQuest 76
step << DarkIronDwarf
#optional
#completewith DWWarmode1
.zone 84 >>Talk to the |cRXP_FRIENDLY_Mole Machine|r to travel to Stormwind
.skipgossip 143925,1,2
.xp <20,1
.pve
.isOnQuest 76
step << !DarkIronDwarf Monk
#optional
#completewith DWWarmode1
.zone 379 >>Cast |T775462:0|t[Zen Pilgrimage]
.xp <20,1
.pve
.isOnQuest 76
step << !DarkIronDwarf Monk
#optional
#completewith DWWarmode1
.goto 379,48.967,43.368
>>Click the |cRXP_PICK_Portal to Stormwind|r
.xp <20,1
.pve
.isOnQuest 76
step << Monk
#optional
#completewith DWWarmode1
.goto 84,49.45,86.60,8,0
.goto 84,49.51,86.67,10 >>Exit the Mage Tower
.pve
.isOnQuest 76
step << !Monk !DarkIronDwarf
#optional
#completewith DWWarmode1
.goto 47,77.487,44.287
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Felicia Maline|r
.fly Stormwind >>Fly to Stormwind
.target Felicia Maline
.xp <20,1
.pve
.isOnQuest 76
step
#optional
#label DWWarmode1
+|cRXP_WARN_Open Up your Talents (Default N) and turn on Warmode to an XP buff and extra talents.
>>|cRXP_WARN_Skip this step if you don't want to turn on Warmode.|r
.pve
.xp <20,1
step
#optional
#completewith JasperlodeEnd4
.goto 84,70.938,72.472
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dungar Longdrink|r
.fly Goldshire >>Fly to Goldshire
.target Dungar Longdrink
.zoneskip 84,1
.xp <20,1
step
#optional
#completewith JasperlodeEnd4
.goto 47,77.487,44.287
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Felicia Maline|r
.fly Goldshire >>Fly to Goldshire
.target Felicia Maline
.zoneskip 47,1
.xp <20,1
step
#optional
#label JasperlodeEnd4
.goto 37,42.105,65.927
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal Dughan|r
.turnin 76 >>Turn in The Jasperlode Mine
.target Marshal Dughan
.xp <20,1
step
#optional
#completewith DuskwoodWarmode1
.goto 37,41.715,64.636
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bartlett the Brave|r
.fly Darkshire >>Fly to Darkshire
.target Bartlett the Brave
.zoneskip 47
.xp <20,1
step
#optional
#label DuskwoodWarmode1
.goto 47,72.60,45.91
.zone 47 >> Travel to Duskwood
.isOnQuest 26667
step
#completewith next
>>Kill |cRXP_ENEMY_Venom Web Spiders|r and loot them for their |cRXP_LOOT_Dusky Lumps.|r
.complete 26623,1 
.mob Venom Web Spider
step
#completewith Letters
>>Kill |cRXP_ENEMY_Nightbane Worgen.|r
.complete 26688,1 
.mob Nightbane Worgen
step
#completewith next
.goto 47,72.60,45.91,30,0
.goto 47,69.23,44.74,30,0
.goto 47,58.12,30.05,30,0
+Check for |cRXP_ENEMY_Fenros|r (Rare) |cFFfa9602in and around the Worgen Camps.|r
.isOnQuest 26623
.unitscan Fenros
step
#label Letters
.goto 47,61.24,40.50
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Bundle of Letters|r |cFFfa9602on the ground.|r
*|cRXP_WARN_Make sure to quickly check for a |cRXP_PICK_Chest|r |cFFfa9602in and around the camp.|r|r
.complete 26667,1 
step
.goto 47,64.12,51.62
>>Kill |cRXP_ENEMY_Nightbane Worgen|r
.complete 26688,1 
.mob Nightbane Worgen
step
#completewith next
.goto 47,65.54,30.32,40,0
.goto 47,73.29,20.23,40,0
.goto 47,63.90,19.41,40,0
>>Kill |cRXP_ENEMY_Dire Wolves|r and loot them for their |cRXP_LOOT_Wolf Skirt Steaks.|r
>>|cRXP_WARN_Check for |cRXP_ENEMY_Lupos|r (Rare), who is patrolling around the |cRXP_ENEMY_Wolves|r and |cRXP_ENEMY_Spiders.|r|r
.complete 26618,1 
.complete 26620,1 
.mob Dire Wolf
.unitscan Lupos
step
.goto 47,68.35,19.48,40,0
.goto 47,60.93,27.34,40,0
.goto 47,65.54,30.32,40,0
.goto 47,73.29,20.23,40,0
.goto 47,63.90,19.41,40,0
.goto 47,68.35,19.48,40,0
.goto 47,60.93,27.34,40,0
.goto 47,65.54,30.32,40,0
.goto 47,73.29,20.23,40,0
.goto 47,63.90,19.41
>>Kill |cRXP_ENEMY_Venom Web Spiders|r and loot them for their |cRXP_LOOT_Dusky Lump.|r
.complete 26623,1 
.mob Venom Web Spider
step
.goto 47,59.00,20.72,40,0
.goto 47,68.35,19.48,40,0
.goto 47,60.93,27.34,40,0
.goto 47,65.54,30.32,40,0
.goto 47,59.00,20.72,40,0
.goto 47,63.90,19.41,40,0
.goto 47,68.35,19.48,40,0
.goto 47,60.93,27.34,40,0
.goto 47,65.54,30.32,40,0
.goto 47,59.00,20.72
>>Kill |cRXP_ENEMY_Dire Wolves|r and loot them for their |cRXP_LOOT_Wolf Skirt Steaks.|r
>>|cRXP_WARN_Check for |cRXP_ENEMY_Lupos|r (Rare), who is patrolling around the |cRXP_ENEMY_Wolves|r and |cRXP_ENEMY_Spiders.|r|r
.complete 26618,1 
.complete 26620,1 
.target Dire Wolf
.unitscan Lupos
step
.goto 37,82.95,84.82,40 >>Check for |cRXP_ENEMY_Bushtail|r(Rare).
.unitscan Bushtail
.isOnQuest 26620
step
.goto 37,74.42,85.99,40,0
.goto 37,66.52,84.48,40	>>Check for |cRXP_ENEMY_Terrapis|r(Rare).
.unitscan Terrapis
.isOnQuest 26620
step
.goto 37,69.32,79.31,30 >>Check for |cRXP_ENEMY_Snoot the Rooter|r(Rare).
.unitscan Snoot the Rooter
.isOnQuest 26620
step
#completewith Grual
.hs >> Hearthstone |cFFfa9602to Darkshire.|r
.cooldown item,6948,>0
step
#label Grual
.goto 47,73.75,43.47
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Chef Grual.|r
.turnin 26620 >>Turn in Seasoned Wolf Kabobs
.turnin 26623 >>Turn in Dusky Crab Cakes
.target Chef Grual
step
#completewith next
.goto 47,74.07,45.32,8,0
.goto 47,73.82,45.95,8>>Exit |cFFfa9602the Inn.|r
step
.goto 47,73.13,44.65
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Avette Fellwood.|r
.vendor 228 >>Vendor and Repair
.target Avette Fellwood
.isOnQuest 26667
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Clerk Daltry|r and |cRXP_FRIENDLY_Commander Althea Ebonlocke.|r
.turnin 26667 >>Turn in The Stolen Letters
.accept 26669 >>Accept In A Dark Corner
.goto 47,72.44,46.91
.turnin 26618 >>Turn in Wolves at Our Heels
.accept 26645 >>Accept The Night Watch
.goto 47,73.53,46.92
.target Clerk Daltry
.target Commander Althea Ebonlocke
step
.goto 47,75.33,48.02
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calor.|r
.turnin 26688 >>Turn in Worgen in the Woods
.accept 26689 >>Accept The Rotting Orchard
.target Calor
step << DarkIronDwarf
#optional
#completewith DWWarmode2
.cast 265225 >>Cast |T1786409:0|t[Mole Machine]
.xp <20,1
.pve
.isOnQuest 76
step << DarkIronDwarf
#optional
#completewith DWWarmode2
.zone 84 >>Talk to the |cRXP_FRIENDLY_Mole Machine|r to travel to Stormwind
.skipgossip 143925,1,2
.xp <20,1
.pve
.isOnQuest 76
step << !DarkIronDwarf Monk
#optional
#completewith DWWarmode2
.zone 379 >>Cast |T775462:0|t[Zen Pilgrimage]
.xp <20,1
.pve
.isOnQuest 76
step << !DarkIronDwarf Monk
#optional
#completewith DWWarmode2
.goto 379,48.967,43.368
>>Click the |cRXP_PICK_Portal to Stormwind|r
.xp <20,1
.pve
.isOnQuest 76
step << Monk
#optional
#completewith DWWarmode2
.goto 84,49.45,86.60,8,0
.goto 84,49.51,86.67,10 >>Exit the Mage Tower
.pve
.isOnQuest 76
step << !Monk !DarkIronDwarf
#optional
#completewith DWWarmode2
.goto 47,77.487,44.287
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Felicia Maline|r
.fly Stormwind >>Fly to Stormwind
.target Felicia Maline
.xp <20,1
.pve
.isOnQuest 76
step
#optional
#label DWWarmode2
+|cRXP_WARN_Open Up your Talents (Default N) and turn on Warmode to an XP buff and extra talents.
>>|cRXP_WARN_Skip this step if you don't want to turn on Warmode.|r
.pve
.xp <20,1
step
#optional
#completewith JasperlodeEnd5
.goto 84,70.938,72.472
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dungar Longdrink|r
.fly Goldshire >>Fly to Goldshire
.target Dungar Longdrink
.zoneskip 84,1
.xp <20,1
step
#optional
#completewith JasperlodeEnd5
.goto 47,77.487,44.287
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Felicia Maline|r
.fly Goldshire >>Fly to Goldshire
.target Felicia Maline
.zoneskip 47,1
.xp <20,1
step
#optional
#label JasperlodeEnd5
.goto 37,42.105,65.927
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal Dughan|r
.turnin 76 >>Turn in The Jasperlode Mine
.target Marshal Dughan
.xp <20,1
step
#optional
#completewith LookStars
.goto 37,41.715,64.636
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bartlett the Brave|r
.fly Darkshire >>Fly to Darkshire
.target Bartlett the Brave
.zoneskip 47
.xp <20,1
.cooldown item,6948,<0
step
#optional
#completewith LookStars
.hs >> Hearth to Darkshire
.zoneskip 47
.xp <20,1
.cooldown item,6948,>0,1
step
#label LookStars
.goto 47,79.53,47.48
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Viktori Prism'Antras.|r
.accept 26683 >>Accept Look To The Stars
.target Viktori Prism'Antras
step
#completewith next
>>Kill |cRXP_ENEMY_Rotting Horrors|r
>>|cRXP_WARN_Check for |cRXP_ENEMY_Watcher Eva|r(Rare) |cFFfa9602in and around the house.|r|r
.complete 26645,1 
.mob Rotting Horror
.unitscan Watcher Eva
step
.goto 47,81.66,59.16,8,0
.goto 47,81.92,58.98,5,0
.goto 47,82.05,59.32
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mary|r |cFFfa9602inside the house.|r
.turnin 26652 >>Turn in Ghost Hair Thread
.accept 26654 >>Accept Return the Comb
.turnin 26683 >>Turn in Turn in Look To The Stars
.accept 26684 >>Accept The Insane Ghoul
.target Blind Mary
step
#loop
.line 47,82.30,61.22,82.45,56.25,80.91,56.65,79.48,60.41,82.30,61.22
.goto 47,82.30,61.22,30,0
.goto 47,82.45,56.25,30,0
.goto 47,80.91,56.65,30,0
.goto 47,79.48,60.41,30,0
.goto 47,82.30,61.22,30,0
>>Kill |cRXP_ENEMY_Rotting Horrors|r
>>|cRXP_WARN_Check for |cRXP_ENEMY_Watcher Eva|r(Rare) |cFFfa9602in and around the house.|r|r
.complete 26645,1 
.mob Rotting Horror
.unitscan Watcher Eva
step
.goto 47,75.56,45.37,8,0
.goto 47,75.83,45.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Madame Eva|r |cFFfa9602inside the house.|r
.turnin 26654 >>Turn in Return the Comb
.accept 26655 >>Accept Deliver the Thread
.target Madame Eva
step
.goto 47,87.43,35.21
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Abercrombie.|r
.turnin 26655 >>Turn in Deliver the Thread
.accept 26660 >>Accept Zombie Juice
.target Abercrombie
step
#completewith next
.goto 47,87.98,33.16,20,0
.goto 47,88.1,31.33,20,0
.goto 47,90.98,30.53,30 >>|cRXP_WARN_Check for the |cRXP_ENEMY_Unknown Soldier|r(Rare).|r
.unitscan Unknown Soldier
step
#completewith next
.goto 47,73.82,45.95,8,0
.goto 47,74.07,45.32,8 >>Go |cFFfa9602inside the Inn.|r
step
.goto 47,74.09,44.71
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tavernkeep Smitts.|r
.turnin 26660 >>Turn in Zombie Juice
.accept 26661 >>Accept Gather Rot Blossoms
.mob Tavernkeep Smitts
step
#completewith next
.goto 47,74.07,45.32,8,0
.goto 47,73.82,45.95,8 >>Exit |cFFfa9602the Inn.|r
step
.goto 47,73.53,46.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Commander Althea Ebonlocke.|r
.turnin 26645 >>Turn in The Night Watch
.accept 26686 >>Accept Bones That Walk
.target Commander Althea Ebonlocke
step << DarkIronDwarf
#optional
#completewith DWWarmode3
.cast 265225 >>Cast |T1786409:0|t[Mole Machine]
.xp <20,1
.pve
.isOnQuest 76
step << DarkIronDwarf
#optional
#completewith DWWarmode3
.zone 84 >>Talk to the |cRXP_FRIENDLY_Mole Machine|r to travel to Stormwind
.skipgossip 143925,1,2
.xp <20,1
.pve
.isOnQuest 76
step << !DarkIronDwarf Monk
#optional
#completewith DWWarmode3
.zone 379 >>Cast |T775462:0|t[Zen Pilgrimage]
.xp <20,1
.pve
.isOnQuest 76
step << !DarkIronDwarf Monk
#optional
#completewith DWWarmode3
.goto 379,48.967,43.368
>>Click the |cRXP_PICK_Portal to Stormwind|r
.xp <20,1
.pve
.isOnQuest 76
step << Monk
#optional
#completewith DWWarmode3
.goto 84,49.45,86.60,8,0
.goto 84,49.51,86.67,10 >>Exit the Mage Tower
.pve
.isOnQuest 76
step << !Monk !DarkIronDwarf
#optional
#completewith DWWarmode3
.goto 47,77.487,44.287
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Felicia Maline|r
.fly Stormwind >>Fly to Stormwind
.target Felicia Maline
.xp <20,1
.pve
.isOnQuest 76
step
#optional
#label DWWarmode3
+|cRXP_WARN_Open Up your Talents (Default N) and turn on Warmode to an XP buff and extra talents.
>>|cRXP_WARN_Skip this step if you don't want to turn on Warmode.|r
.pve
.xp <20,1
step
#optional
#completewith JasperlodeEnd6
.goto 84,70.938,72.472
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dungar Longdrink|r
.fly Goldshire >>Fly to Goldshire
.target Dungar Longdrink
.zoneskip 84,1
.xp <20,1
step
#optional
#completewith JasperlodeEnd6
.goto 47,77.487,44.287
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Felicia Maline|r
.fly Goldshire >>Fly to Goldshire
.target Felicia Maline
.zoneskip 47,1
.xp <20,1
step
#optional
#label JasperlodeEnd6
.goto 37,42.105,65.927
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal Dughan|r
.turnin 76 >>Turn in The Jasperlode Mine
.target Marshal Dughan
.xp <20,1
step
#optional
#completewith DuskwoodWarmode2
.goto 37,41.715,64.636
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bartlett the Brave|r
.fly Darkshire >>Fly to Darkshire
.target Bartlett the Brave
.zoneskip 47
.xp <20,1
.cooldown item,6948,<0
step
#optional
#completewith DuskwoodWarmode2
.hs >> Hearth to Darkshire
.zoneskip 47
.xp <20,1
.cooldown item,6948,>0,1
step
#optional
#label DuskwoodWarmode2
.goto 47,72.60,45.91
.zone 47 >> Travel to Duskwood
.isOnQuest 26684
step
#completewith next
>>Kill |cRXP_ENEMY_Skeletal Warriors|r and |cRXP_ENEMY_Skeletal Mages.|r
>>Check for |cRXP_ENEMY_Watcher Eva|r (Rare) near the Central/North side of the Cemetary (if you haven't killed him recently)
>>Loot the |cRXP_PICK_Rot Blossoms|r on the ground
.complete 26686,1 
.complete 26686,2 
.complete 26661,1 
.target Skeletal Warrior
.target Skeletal Mage
.unitscan Watcher Eva
step
.goto 47,80.31,71.10,15,0
.goto 47,80.88,71.58
>>Kill the |cRXP_ENEMY_Insane Ghoul|r |cFFfa9602inside the Cemetery.|r and loot it for the |cRXP_LOOT_Mary's Looking Glass.|r
.complete 26684,1 
.target Insane Ghoul
step
#loop
.line 47,81.85,68.34,78.33,66.13,77.02,69.85,80.89,74.21,81.85,68.34
.goto 47,81.85,68.34,40,0
.goto 47,78.33,66.13,40,0
.goto 47,77.02,69.85,40,0
.goto 47,80.89,74.21,40,0
.goto 47,81.85,68.34,40,0
>>Kill |cRXP_ENEMY_Skeletal Warriors|r and |cRXP_ENEMY_Skeletal Mages.|r
>>Check for |cRXP_ENEMY_Watcher Eva|r (Rare) near the Central/North side of the Cemetary (if you haven't killed him recently)
>>Loot the |cRXP_PICK_Rot Blossoms|r on the ground
.complete 26686,1 
.complete 26686,2 
.complete 26661,1 
.target Skeletal Warrior
.target Skeletal Mage
.unitscan Watcher Eva
step
.goto 47,73.53,74.24,20 >>Check for a |cRXP_PICK_Chest|r |cFFfa9602in front of the mine.|r
.isOnQuest 26669
step
#completewith Marus
>>Kill |cRXP_ENEMY_Nightbane Shadow Weavers|r
.complete 26689,1 
.target Nightbane Shadow Weavers
step
#completewith next
.goto 47,66.03,75.79,8,0
.goto 47,65.98,76.42,8 >> Go inside the barn
step
.goto 47,66.59,76.44
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Torn Journal|r |cFFfa9602on the ground.|r Keep an eye out for a |cRXP_PICK_Chest|r |cFFfa9602inside the barn.|r
.complete 26669,1 
step
#label Marus
.goto 47,65.32,68.08,8,0
.goto 47,64.98,67.48,8,0
.goto 47,65.72,67.12,8 >>Check for |cRXP_ENEMY_Marus|r and a |cRXP_PICK_Chest|r |cFFfa9602inside the building.|r
.unitscan Marus
.isOnQuest 26689
step
.goto 47,63.50,76.61,40,0
.goto 47,60.88,73.19,40,0
.goto 47,64.19,65.03,40,0
.goto 47,63.50,76.61,40,0
.goto 47,60.88,73.19,40,0
.goto 47,64.19,65.03,40,0
.goto 47,63.50,76.61
>>Kill |cRXP_ENEMY_Nightbane Shadow Weavers|r. Kill |cRXP_ENEMY_Marus|r if you see him (and you haven't killed him already)
.complete 26689,1 
.target Nightbane Shadow Weavers
.unitscan Marus
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to|cRXP_FRIENDLY_Althea|r and |cRXP_FRIENDLY_Daltry.|r
.turnin 26686 >>Turn in Bones That Walk
.goto 47,73.53,46.92
.turnin 26669 >>Turn in In A Dark Corner
.accept 26670 >>Accept Roland's Doom
.goto 47,72.44,46.91
.target Commander Althea Ebonlocke
.target Clerk Daltry
step
#completewith next
.goto 47,73.82,45.95,8,0
.goto 47,74.07,45.32,8 >>Go |cFFfa9602inside the Inn|r
step
.goto 47,74.09,44.71
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tavernkeep Smitts|r
.turnin 26661 >>Turn in Gather Rot Blossoms
.accept 26676 >>Accept Juice Delivery
.target Tavernkeep Smitts
step
#completewith next
.goto 47,74.07,45.32,8,0
.goto 47,73.82,45.95,8 >>Exit |cFFfa9602the Inn.|r
step
.goto 47,75.33,48.02
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calor|r
.turnin 26689,1 >>Turn in The Rotting Orchard
.accept 26690 >>Accept Vile and Tainted
.target Calor
step << DarkIronDwarf
#optional
#completewith DWWarmode4
.cast 265225 >>Cast |T1786409:0|t[Mole Machine]
.xp <20,1
.pve
.isOnQuest 76
step << DarkIronDwarf
#optional
#completewith DWWarmode4
.zone 84 >>Talk to the |cRXP_FRIENDLY_Mole Machine|r to travel to Stormwind
.skipgossip 143925,1,2
.xp <20,1
.pve
.isOnQuest 76
step << !DarkIronDwarf Monk
#optional
#completewith DWWarmode4
.zone 379 >>Cast |T775462:0|t[Zen Pilgrimage]
.xp <20,1
.pve
.isOnQuest 76
step << !DarkIronDwarf Monk
#optional
#completewith DWWarmode4
.goto 379,48.967,43.368
>>Click the |cRXP_PICK_Portal to Stormwind|r
.xp <20,1
.pve
.isOnQuest 76
step << Monk
#optional
#completewith DWWarmode4
.goto 84,49.45,86.60,8,0
.goto 84,49.51,86.67,10 >>Exit the Mage Tower
.pve
.isOnQuest 76
step << !Monk !DarkIronDwarf
#optional
#completewith DWWarmode4
.goto 47,77.487,44.287
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Felicia Maline|r
.fly Stormwind >>Fly to Stormwind
.target Felicia Maline
.xp <20,1
.pve
.isOnQuest 76
step
#optional
#label DWWarmode4
+|cRXP_WARN_Open Up your Talents (Default N) and turn on Warmode to an XP buff and extra talents.
>>|cRXP_WARN_Skip this step if you don't want to turn on Warmode.|r
.pve
.xp <20,1
step
#optional
#completewith JasperlodeEnd7
.goto 84,70.938,72.472
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dungar Longdrink|r
.fly Goldshire >>Fly to Goldshire
.target Dungar Longdrink
.zoneskip 84,1
.xp <20,1
step
#optional
#completewith JasperlodeEnd7
.goto 47,77.487,44.287
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Felicia Maline|r
.fly Goldshire >>Fly to Goldshire
.target Felicia Maline
.zoneskip 47,1
.xp <20,1
step
#optional
#label JasperlodeEnd7
.goto 37,42.105,65.927
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal Dughan|r
.turnin 76 >>Turn in The Jasperlode Mine
.target Marshal Dughan
.xp <20,1
step
#optional
#completewith Insane
.goto 37,41.715,64.636
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bartlett the Brave|r
.fly Darkshire >>Fly to Darkshire
.target Bartlett the Brave
.zoneskip 47
.xp <20,1
.cooldown item,6948,<0
step
#optional
#completewith Insane
.hs >> Hearth to Darkshire
.zoneskip 47
.xp <20,1
.cooldown item,6948,>0,1
step
#label Insane
.goto 47,79.53,47.48
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Viktori Prism'Antras.|r
.turnin 26684 >>Turn in The Insane Ghoul
.accept 26685 >>Accept Classy Glass
.target Viktori Prism'Antras
step
.goto 47,87.43,35.21
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Abercrombie.|r
.turnin 26676 >>Turn in Juice Delivery
.accept 26680 >>Accept Ogre Thieves
.target Abercrombie
step
.goto 47,87.98,33.16,20,0
.goto 47,88.1,31.33,20,0
.goto 47,90.98,30.53,30 >>Check for the |cRXP_ENEMY_Unknown Soldier|r(Rare).
.unitscan Unknown Soldier
.isOnQuest 26670
step
#completewith JPages
>>Kill |cRXP_ENEMY_Nightbane Tainted Ones|r and |cRXP_ENEMY_Vile Fangs|r
.complete 26690,2 
.complete 26690,1 
step
#completewith next
.goto 47,73.05,75.17,20 >>Check for a |cRXP_PICK_Chest|r in front of the mine. Enter the mine
.isOnQuest 26690
step
#label JPages
.goto 47,73.44,76.86,20,0
.goto 47,74.26,77.92,20,0
.goto 47,73.62,79.21
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Pages|r |cFFfa9602on the ground.|r
>>Check for |cRXP_ENEMY_Nefaru|r (Rare) and a |cRXP_PICK_Chest|r |cFFfa9602inside the Mine.|r
.complete 26670,1 
step
.goto 47,74.84,67.51,40,0
.goto 47,72.13,67.77,40,0
.goto 47,72.03,74.77,40,0
.goto 47,74.25,73.86,40,0
.goto 47,73.46,73.17,40,0
.goto 47,74.84,67.51,40,0
.goto 47,72.13,67.77,40,0
.goto 47,72.03,74.77,40,0
.goto 47,74.25,73.86,40,0
.goto 47,73.46,73.17
>>Kill |cRXP_ENEMY_Nightbane Tainted Ones|r and |cRXP_ENEMY_Nightbane Vile Fangs|r
.complete 26690,2 
.complete 26690,1 
.mob Nightbane Tainted One
.mob Nightbane Vile Fang
step
#completewith next
.deathskip >> Die and respawn at the |cRXP_FRIENDLY_Spirit Healer|r
step
.goto 47,72.44,46.91
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Clerk Daltry.|r
.turnin 26670 >>Turn in Roland's Doom
.accept 26671 >>Accept The Fate of Stalvan Mistmantle
.target Clerk Daltry
step
.goto 47,73.13,44.65
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Avette Fellwood.|r
.vendor 228 >>Vendor and Repair
.target Avette Fellwood
.isOnQuest 26671
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calor|r and |cRXP_FRIENDLY_Jonathan Carevin.|r
.turnin 26690 >>Turn in Vile and Tainted
.accept 26691 >>Accept Worgen in the Woods
.goto 47,75.33,48.02
.turnin 26691 >>Turn in Worgen in the Woods
.goto 47,75.24,48.23,5,0
.goto 47,75.39,49.00
.target Calor
.target Jonathan Carevin
step
.goto 47,78.74,44.53,8,0
.goto 47,79.09,44.17
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tobias Mistmantle|r |cFFfa9602inside the house.|r
.turnin 26671 >>Turn in The Fate of Stalvan Mistmantle
.accept 26672 >>Accept Clawing at the Truth
.target Tobias Mistmantle
step << DarkIronDwarf
#optional
#completewith DWWarmode4
.cast 265225 >>Cast |T1786409:0|t[Mole Machine]
.xp <20,1
.pve
.isOnQuest 76
step << DarkIronDwarf
#optional
#completewith DWWarmode4
.zone 84 >>Talk to the |cRXP_FRIENDLY_Mole Machine|r to travel to Stormwind
.skipgossip 143925,1,2
.xp <20,1
.pve
.isOnQuest 76
step << !DarkIronDwarf Monk
#optional
#completewith DWWarmode5
.zone 379 >>Cast |T775462:0|t[Zen Pilgrimage]
.xp <20,1
.pve
.isOnQuest 76
step << !DarkIronDwarf Monk
#optional
#completewith DWWarmode5
.goto 379,48.967,43.368
>>Click the |cRXP_PICK_Portal to Stormwind|r
.xp <20,1
.pve
.isOnQuest 76
step << Monk
#optional
#completewith DWWarmode5
.goto 84,49.45,86.60,8,0
.goto 84,49.51,86.67,10 >>Exit the Mage Tower
.pve
.isOnQuest 76
step << !Monk !DarkIronDwarf
#optional
#completewith DWWarmode5
.goto 47,77.487,44.287
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Felicia Maline|r
.fly Stormwind >>Fly to Stormwind
.target Felicia Maline
.xp <20,1
.pve
.isOnQuest 76
step
#optional
#label DWWarmode5
+|cRXP_WARN_Open Up your Talents (Default N) and turn on Warmode to an XP buff and extra talents.
>>|cRXP_WARN_Skip this step if you don't want to turn on Warmode.|r
.pve
.xp <20,1
step
#optional
#completewith JasperlodeEnd8
.goto 84,70.938,72.472
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dungar Longdrink|r
.fly Goldshire >>Fly to Goldshire
.target Dungar Longdrink
.zoneskip 84,1
.xp <20,1
step
#optional
#completewith JasperlodeEnd8
.goto 47,77.487,44.287
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Felicia Maline|r
.fly Goldshire >>Fly to Goldshire
.target Felicia Maline
.zoneskip 47,1
.xp <20,1
step
#optional
#label JasperlodeEnd8
.goto 37,42.105,65.927
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal Dughan|r
.turnin 76 >>Turn in The Jasperlode Mine
.target Marshal Dughan
.xp <20,1
step
#optional
#completewith Clawing
.goto 37,41.715,64.636
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bartlett the Brave|r
.fly Darkshire >>Fly to Darkshire
.target Bartlett the Brave
.zoneskip 47
.xp <20,1
.cooldown item,6948,<0
step
#optional
#completewith Clawing
.hs >> Hearth to Darkshire
.zoneskip 47
.xp <20,1
.cooldown item,6948,>0,1
step
#label Clawing
.goto 47,75.56,45.37,8,0
.goto 47,75.83,45.26
>>Talk to |cRXP_FRIENDLY_Madame Eva|r |cFFfa9602inside the house.|r
.turnin 26672 >>Turn in Clawing at the Truth
.accept 26674 >>Accept Mistmantle's Revenge
.target Madame Eva
step
.goto 47,77.42,35.85,10,0
.goto 47,77.33,36.18
>>|cRXP_WARN_Use the|r |T332402:0|t[Mistmantle Family Ring] |cRXP_WARN_inside Stalvan's house. Wait out the RP|r
>>Kill |cRXP_ENEMY_Fetid Corpses|r and check for a |cRXP_PICK_Chest|r in and around the House while you wait for |cRXP_ENEMY_Stalvan|r to become hostile.
>>Kill |cRXP_ENEMY_Stalvan|r
.complete 26674,1 
.mob Fetid Corpse
.mob Stalvan Mistmantle
.cast 82029
.timer 33,Mistmantle's Revenge RP
.use 59363
step
.goto 47,78.74,44.53,8,0
.goto 47,79.09,44.17
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tobias Mistmantle|r |cFFfa9602inside the house.|r
.turnin 26674 >>Turn in Mistmantle's Revenge
.accept 26785 >>Accept Part of the Pack
.target Tobias Mistmantle
step
#completewith next
.goto 47,69.51,48.83,30 >> Take the path |cFFfa9602behind the Town Hall to Brightwood Grove.|r
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Watcher Dodds|r and |cRXP_FRIENDLY_Apprentice Fess.|r
.accept 25235 >>Accept Vulgar Vul'Gol
.goto 47,45.12,67.02
.turnin 26785 >>Turn in Part of the Pack
.accept 26707 >>Accept A Deadly Vine
.accept 26717 >>Accept The Yorgen Worgen
.goto 47,44.92,67.43
.target Watcher Dodds
.target Apprentice Fess
step
#completewith next
>>Kill |cRXP_ENEMY_Corpseweed|r and loot them for their |cRXP_LOOT_Corpseweed.|r
>>Check for the |cRXP_ENEMY_Carved One|r (Rare).
.complete 26707,1 
.mob Corpseweed
.unitscan Carved One
step
.goto 47,49.86,77.69
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Dirt Pile|r |cFFfa9602on the ground.|r
.complete 26717,1 
step
.goto 47,51.99,73.61,40,0
.goto 47,49.04,70.73,40,0
.goto 47,47.12,73.79,40,0
.goto 47,49.28,76.56,40,0
.goto 47,51.99,73.61,40,0
.goto 47,49.04,70.73,40,0
.goto 47,47.12,73.79,40,0
.goto 47,49.28,76.56
>>Kill |cRXP_ENEMY_Corpseweed|r and loot them for their |cRXP_LOOT_Corpseweed|r
>>Check for the |cRXP_ENEMY_Carved One|r(Rare)
.complete 26707,1 
.mob Corpseweed
.unitscan Carved One
step
#completewith Zzarc
>>Kill |cRXP_ENEMY_Splinter Fist Ogres|r, |cRXP_ENEMY_Firemongers|r, and |cRXP_ENEMY_Warriors|r
.complete 25235,1 
.mob Splinter Fist Ogre
.mob Splinter Fist Firemonger
.mob Splinter Fist Warrior
step
.goto 47,33.52,75.33
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Crate|r |cFFfa9602on the ground.|r
.complete 26680,1 
step
#completewith next
.goto 47,34.20,77.47,15 >>Check for a |cRXP_PICK_Chest|r |cFFfa9602at the mine's entrance|r, then go |cFFfa9602inside the mine.|r
step
#completewith next
.goto 47,35.56,80.07,15,0
.goto 47,34.86,81.36,15 >>Check for a |cRXP_PICK_Chest|r |cFFfa9602inside the mine.|r
step
#label Zzarc
.goto 47,37.87,84.33
>>Kill |cRXP_ENEMY_Zzarc' Vul|r and loot him for his |cRXP_LOOT_Ogre's Monocle|r
.complete 26685,1 
.target Zzarc' Vul
step
#completewith DeadlyV
.goto 47,34.20,77.47,15 >>Exit |cFFfa9602the mine.|r
.isOnQuest 25235
step
.goto 47,33.32,74.63,40,0
.goto 47,32.82,68.37,40,0
.goto 47,39.06,70.59,40,0
.goto 47,40.66,74.97,40,0
.goto 47,33.32,74.63,40,0
.goto 47,32.82,68.37,40,0
.goto 47,39.06,70.59,40,0
.goto 47,40.66,74.97
>>Kill |cRXP_ENEMY_Splinter Fist Ogres|r, |cRXP_ENEMY_Splinter Fist Firemonger|r, and |cRXP_ENEMY_Splinter Fist Warrior.|r
.complete 25235,1 
.mob Splinter Fist Ogre
.mob Splinter Fist Firemonger
.mob Splinter Fist Warrior
step
#label DeadlyV
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Apprentice Fess|r and |cRXP_FRIENDLY_Watcher Dodds.|r
.turnin 26707 >>Turn in A Deadly Vine
.turnin 26717 >>Turn in The Yorgen Worgen
.accept 26719 >>Accept Delivery to Master Harris
.goto 47,44.92,67.43
.turnin 25235 >>Turn in Vulgar Vul'Gol
.goto 47,45.12,67.02
.target Apprentice Fess
.target Watcher Dodds
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#name 4A_Northern Stranglethorn
#displayname Chapter 4 - Northern Stranglethorn
#next 5A_Duskwood 2
#fresh 30
#veteran
<< Alliance
step
.goto 50,51.86,12.01
.zone 50 >> Travel |cFFfa9602to Northern Stranglethorn.|r
step
#completewith next
.goto 50,47.74,12.69,30,0
.goto 50,47.87,11.86,40 >> Travel |cFFfa9602to the Rebel Camp.|r
step
#completewith next
.goto 50,47.87,11.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_James Stillair.|r
.fp Rebel Camp >>Get the Rebel Camp Flight Path
.target James Stillair
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Doren|r, |cRXP_FRIENDLY_Corporal Kaleb|r, and |cRXP_FRIENDLY_Brother Nimetz.|r
.accept 26735 >>Accept The Fate of Kurzen
.goto 50,47.57,10.25
.accept 26740 >>Accept Krazek's Cookery
.goto 50,47.10,10.70
.accept 26732 >>Accept Bad Medicine
.goto 50,47.25,11.10
.target Lieutenant Doren
.target Corporal Kaleb
.target Brother Nimetz
step
#label Nesingwary
#completewith Camp1
.goto 50,49.36,14.78,40,0
.goto 50,44.26,22.26,40 >> Travel |cFFfa9602to Nesingwary's Expedition.|r
step
#sticky
#label Jaq
#requires Nesingwary
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jaquilina Dramet.|r
.goto 50,43.69,23.19,0,0
.vendor 2483 >>|cRXP_WARN_Vendor and Repair.|r
.target Jaquilina Dramet
.isOnQuest 26685
step
#label Camp1
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Barnil Stonepot|r, |cRXP_FRIENDLY_Hemet Nesingwary Jr.|r, |cRXP_FRIENDLY_Drizzlik|r, and |cRXP_FRIENDLY_Krazek.|r
.accept 583 >>Accept Welcome to the Jungle
.goto 50,44.25,22.12
.turnin 583 >>Turn in Welcome to the Jungle
.accept 194 >>Accept Raptor Hunting
.goto 50,44.18,22.97,10,0
.goto 50,44.02,23.29
.accept 26343 >>Accept Supply and Demand
.goto 50,43.62,23.40
.turnin 26740 >>Turn in Krazek's Cookery
.accept 26763 >>Accept Venture Company Mining
.goto 50,43.60,23.13
.target Barnil Stonepot
.target Hemet Nesingwary Jr.
.target Drizzlik
.target Krazek
step
#requires Jaq
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sir S. J. Erlgadin|r, |cRXP_FRIENDLY_Barnil Stonepot|r, and |cRXP_FRIENDLY_Ajeck Rouack.|r
.accept 190 >>Accept Panther Hunting
.goto 50,43.72,22.27,10,0
.goto 50,43.96,22.49,10,0
.goto 50,44.18,22.26
.accept 26269 >>Accept The Green Hills of Stranglethorn
.goto 50,44.25,22.12
.accept 185 >>Accept Tiger Hunting
.goto 50,44.50,22.66
.target Sir S. J. Erlgadin
.target Barnil Stonepot
.target Ajeck Rouack
step
>>Kill |cRXP_ENEMY_River Crocolisks|r and loot them for their |cRXP_LOOT_Large River Crocolisk Skin.|r
.complete 26343,1 
.mob River Crocolisk
step
#completewith next
>>Kill |cRXP_ENEMY_Young Stranglethorn Tigers.|r
.complete 185,1 
.mob Young Stranglethorn Tiger
step
.goto 50,45.97,20.58,40,0
.goto 50,43.88,18.04,40,0
.goto 50,41.96,17.77,40,0
.goto 50,41.02,19.93,40,0
.goto 50,42.49,21.96,40,0
.goto 50,38.92,18.96,40,0
.goto 50,45.97,20.58,40,0
.goto 50,43.88,18.04,40,0
.goto 50,41.96,17.77,40,0
.goto 50,41.02,19.93,40,0
.goto 50,42.49,21.96,40,0
.goto 50,38.92,18.96
>>Kill |cRXP_ENEMY_River Crocolisks|r and loot them for their |cRXP_LOOT_Large River Crocolisk Skin.|r
.complete 26343,1 
.mob River Crocolisk
step
.goto 50,37.50,19.98,40,0
.goto 50,39.10,22.12,40,0
.goto 50,40.72,24.52,40,0
.goto 50,42.95,28.10,40,0
.goto 50,44.46,26.17,40,0
.goto 50,46.28,23.20,40,0
.goto 50,37.50,19.98,40,0
.goto 50,39.10,22.12,40,0
.goto 50,40.72,24.52,40,0
.goto 50,42.95,28.10,40,0
.goto 50,44.46,26.17,40,0
.goto 50,46.28,23.20
>>Kill |cRXP_ENEMY_Young Stranglethorn Tigers.|r
.complete 185,1 
.mob Young Stranglethorn Tiger
step
.goto 50,43.65,23.46
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 185 >>Turn in Tiger Hunting
.accept 186 >>Accept Tiger Stalking
step
.goto 50,43.62,23.40
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Drizzlik.|r
.turnin 26343 >>Turn in Supply and Demand
.accept 26344 >>Accept Some Assembly Required
.mob Drizzlik
step
#completewith next
.goto 50,46.52,27.94,8,0
.goto 50,46.93,27.81,8,0
>>Kill |cRXP_ENEMY_Young Panthers|r. |cRXP_WARN_They are stealthed around the trees and bushes|r.
.complete 190,1,5 
.mob Young Panther
step
.goto 50,47.19,31.84,30 >>Check for |cRXP_ENEMY_Tsul'Kalu|r(Rare).
.unitscan Tsul'Kalu
.isOnQuest 190
step
.goto 50,48.71,29.33,8,0
.goto 50,49.24,27.9,8,0
.goto 50,48.66,26.77,8,0
.goto 50,48.62,26.9,10,0
>>Kill |cRXP_ENEMY_Young Panthers|r. |cRXP_WARN_They are stealthed around the trees and bushes.|r
.complete 190,1,5 
.mob Young Panther
step
#completewith next
.goto 50,50.67,29.62,35,0
.goto 50,52.15,28.82,35,0
.goto 50,49.99,33.55,35,0
.goto 50,51.20,36.00,35,0
>>Kill |cRXP_ENEMY_Snapjaw Crocolisks|r |cRXP_WARN_(even if they're underwater)|r and loot them for their |cRXP_LOOT_ Snapjaw Crocolisk Skin.|r
.complete 26344,1 
.mob Snapjaw Crocolisk
step
#veteran
.goto 50,46.00,40.45
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Steven Lisbane.|r
>>|cRXP_WARN_Skip this step if you don't have level 25 Pet Battle Pets|r
.accept 31852 >>Accept Steven Lisbane
.target Steven Lisbane
.isQuestTurnedIn 31903,31889,31891,31902
step
#veteran
.goto 50,46.00,40.45
>>Defeat |cRXP_ENEMY_Steven|r in a Pet Battle.
.complete 31852,1 
.target Steven Lisbane
.skipgossip 63194,1
.isOnQuest 31852
step
#veteran
.goto 50,46.00,40.45
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Steven Lisbane.|r
.turnin 31852 >>Turn in Steven Lisbane
.target Steven Lisbane
.isQuestTurnedIn 31852
step
#veteran
.goto 50,40.88,39.16,40,0
.goto 50,41.64,40.66,40,0
.goto 50,43.33,40.88,40,0
.goto 50,43.16,43.43,40,0
.goto 50,43.78,43.27,30 >>Check for |cRXP_ENEMY_Gluggl|r(Rare).
.unitscan Gluggl
.isQuestTurnedIn 31903,31889,31891,31902
step
#label CrocoSkin
#completewith Mahamba
.goto 50,50.13,39.89,35,0
.goto 50,51.70,39.86,35,0
.goto 50,54.32,38.65,35,0
>>Kill |cRXP_ENEMY_Snapjaw Crocolisks|r |cRXP_WARN_(even if they're underwater)|r and loot them for their |cRXP_LOOT_Snapjaw Crocolisk Skin.|r
.complete 26344,1 
.mob Snapjaw Crocolisk
.isQuestTurnedIn 31903,31889,31891,31902
step
#label CrocoSkin
#completewith next
.goto 50,50.67,29.62,35,0
.goto 50,52.15,28.82,35,0
.goto 50,49.99,33.55,35,0
.goto 50,51.20,36.00,35,0
.goto 50,50.13,39.89,35,0
.goto 50,51.70,39.86,35,0
.goto 50,54.32,38.65,35,0
>>Kill |cRXP_ENEMY_Snapjaw Crocolisks|r |cRXP_WARN_(even if they're underwater)|r and loot them for their |cRXP_LOOT_Snapjaw Crocolisk Skin.|r
.complete 26344,1 
.mob Snapjaw Crocolisk
.isQuestAvailable 31903
step
#label Mahamba
#completewith CrocoSkin
.goto 50,54.29,30.43,30 >>Check for |cRXP_ENEMY_Mahamba|r(Rare).
.unitscan Mahamba
.isOnQuest 26344
step
#requires Mahamba
.goto 50,50.67,29.62,35,0
.goto 50,52.15,28.82,35,0
.goto 50,49.99,33.55,35,0
.goto 50,51.20,36.00,35,0
.goto 50,50.13,39.89,35,0
.goto 50,51.70,39.86,35,0
.goto 50,54.32,38.65
>>Kill |cRXP_ENEMY_Snapjaw Crocolisks|r |cRXP_WARN_(even if they're underwater)|r and loot them for their |cRXP_LOOT_Snapjaw Crocolisk Skin.|r
.complete 26344,1 
.mob Snapjaw Crocolisk
step
#completewith next
>>Kill |cRXP_ENEMY_Venture Co. Geologists|r and |cRXP_ENEMY_Venture Co. Shredders|r and loot them for their |cRXP_LOOT_Tumbled Crystals.|r
>>|cRXP_WARN_Check for the |cRXP_PICK_Chests|r that can spawn in the lumberyard and on the oil rig|r
.complete 26763,1 
.mob Venture Co. Geologist
.mob Venture Co. Shredder
step
.goto 50,54.29,30.43,30 >>Check for |cRXP_ENEMY_Mahamba|r(Rare).
>>|cRXP_WARN_Skip this step if you killed him already|r
.unitscan Mahamba
.isOnQuest 26344
step
#label VentureCo
>>Kill |cRXP_ENEMY_Venture Co. Geologists|r and |cRXP_ENEMY_Venture Co. Shredders|r and loot them for their |cRXP_LOOT_Tumbled Crystals|r
>>|cRXP_WARN_Check for the |cRXP_PICK_Chests|r that can spawn in the lumberyard and on the oil rig|r
.goto 50,54.08,33.65,15,0
.goto 50,54.48,34.08,15,0
.goto 50,54.43,35.29,10,0
.goto 50,55.35,35.7,15,0
.goto 50,55.87,42.43,40,0
.goto 50,59.59,36.22,40,0
.goto 50,55.29,30.48,40,0
.goto 50,55.87,42.43,40,0
.goto 50,59.59,36.22,40,0
.goto 50,55.29,30.48
.complete 26763,1 
.mob Venture Co. Geologist
.mob Venture Co. Shredder
step
.goto 50,56.39,28.08,40,0
.goto 50,58.47,26.80,40,0
.goto 50,60.65,30.98,40,0
.goto 50,61.80,31.60,40,0
.goto 50,60.96,25.20,40,0
.goto 50,56.39,28.08,40,0
.goto 50,58.47,26.80,40,0
.goto 50,60.65,30.98,40,0
.goto 50,61.80,31.60,40,0
.goto 50,60.96,25.20
>>Kill |cRXP_ENEMY_Stranglethorn Tigers.|r
.complete 186,1 
.mob Stranglethorn Tiger
step
.goto 50,57.92,23.65
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 186 >>Turn in Tiger Stalking
.accept 187 >>Accept Tiger Prowess
step
#completewith next
>>Kill |cRXP_ENEMY_Kurzen Medicine Men|r and |cRXP_ENEMY_Kurzen Jungle Fighters|r and loot them for their |cRXP_LOOT_Jungle Remedies.|r
.complete 26732,1 
.accept 26738 >>Accept Just Hatched
.mob Kurzen Medicine Man
.mob Kurzen Jungle Fighter
step
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Scrolls|r |cFFfa9602on the ground.|r
.complete 26735,2 
.goto 50,57.92,23.66
.complete 26735,1 
.goto 50,57.89,22.86
step
.goto 50,58.82,23.14,15,0
.goto 50,57.66,21.06,40,0
.goto 50,56.87,20.28,15,0
.goto 50,56.47,20.31,8,0
.goto 50,56.84,20.73,8,0
.goto 50,56.51,20.25,8,0
.goto 50,58.38,18.57,15,0
.goto 50,56.74,22.87,40,0
.goto 50,58.82,23.14,15,0
.goto 50,57.66,21.06,40,0
.goto 50,56.87,20.28,15,0
.goto 50,56.47,20.31,8,0
.goto 50,56.84,20.73,8,0
.goto 50,56.51,20.25,8,0
.goto 50,58.38,18.57,15,0
.goto 50,56.74,22.87
>>Kill |cRXP_ENEMY_Kurzen Medicine Men|r and |cRXP_ENEMY_Kurzen Jungle Fighters|r. Loot them for their |cRXP_LOOT_Jungle Remedies.|r
>>|cRXP_WARN_Check for a |cRXP_PICK_Chest|r that can be upstairs or downstairs in the house|r
.complete 26732,1 
.mob Kurzen Medicine Man
.mob Kurzen Jungle Fighter
step
.goto 50,52.56,23,00
>>|cRXP_WARN_Select the option to accept the quest from the pop-up in your quest log.|r
.accept 26738 >>Accept Just Hatched
step
.goto 50,55.65,21.57,10,0
.goto 50,54.58,23.24,10,0
.goto 50,55.10,24.59,10,0
.goto 50,54.69,26.78,10,0
.goto 50,53.30,25.50,10,0
.goto 50,52.56,23,00,10,0
.goto 50,55.65,21.57,10,0
.goto 50,54.58,23.24,10,0
.goto 50,55.10,24.59,10,0
.goto 50,54.69,26.78,10,0
.goto 50,53.30,25.50,10,0
.goto 50,52.56,23,00
>>Kill |cRXP_ENEMY_Young Panthers|r. |cRXP_WARN_They are stealthed around the trees and bushes.|r
.complete 190,1 
.mob Young Panther
step
.goto 50,47.58,10.25
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 190 >>Turn in Panther Hunting
.accept 191 >>Accept Panther Stalking
step
#completewith next
.goto 50,49.44,14.20,30,0
.goto 50,47.74,12.69,30,0
.goto 50,47.57,10.25,40 >> Return |cFFfa9602to the Rebel Camp.|r
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Doren|r, |cRXP_FRIENDLY_Corporal Sethman|r, and |cRXP_FRIENDLY_Brother Nimetz.|r
.turnin 26735 >>Turn in The Fate of Kurzen
.accept 26736 >>Accept Spared from Madness
.goto 50,47.57,10.25
.turnin 26738 >>Turn in Just Hatched
.accept 26739 >>Accept I Think She's Hungry
.goto 50,46.98,10.84
.turnin 26732 >>Turn in Bad Medicine
.accept 26733 >>Accept Control Sample
.goto 50,47.25,11.10
.target Lieutenant Doren
.target Corporal Sethman
.target Brother Nimetz
step
#completewith next
.goto 50,47.74,12.69,30,0
.goto 50,49.44,14.20,30 >> Exit |cFFfa9602the Rebel Camp.|r
step
.goto 50,56.87,20.28,15,0
.goto 50,56.47,20.31,8,0
.goto 50,56.84,20.73,8,0
.goto 50,56.41,20.29
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Cage|r |cFFfa9602upstairs in the house.|r
>>|cRXP_WARN_Check for a |cRXP_PICK_Chest|r that can be upstairs or downstairs in the house|r
.complete 26736,1 
.complete 26736,2 
.complete 26736,3 
step
.goto 50,60.48,21.98,40,0
.goto 50,61.73,19.96,40,0
.goto 50,63.63,18.48,40,0
.goto 50,64.67,21.11,40,0
.goto 50,63.17,22.43,40,0
.goto 50,61.43,22.78,40,0
.goto 50,63.44,24.93,40,0
.goto 50,63.65,31.49,40,0
.goto 50,60.48,21.98,40,0
.goto 50,61.73,19.96,40,0
.goto 50,63.63,18.48,40,0
.goto 50,64.67,21.11,40,0
.goto 50,63.17,22.43,40,0
.goto 50,61.43,22.78,40,0
.goto 50,63.44,24.93,40,0
.goto 50,63.65,31.49
>>|cRXP_WARN_Use the|r |T132835:0|t[Lashtail Raptor Egg Fragment] |cRXP_WARN_to summon a|r |cRXP_FRIENDLY_Hatchling.|r
>>Kill |cRXP_ENEMY_Crystal Spine Basilisks|r. Loot them for their |cRXP_LOOT_Blood|r. Let the |cRXP_FRIENDLY_Hatchling|r eat their corpses for their |cRXP_LOOT_Basilisk Meat.|r
.complete 26739,1 
.complete 26733,1 
.mob Crystal Spine Basilisk
.use 58165
step
#completewith next
.deathskip >> Die and respawn at the |cRXP_FRIENDLY_Spirit Healer|r
step
#completewith next
.goto 50,49.44,14.20,30,0
.goto 50,47.74,12.69,30,0
.goto 50,47.57,10.25,40 >> Return |cFFfa9602to the Rebel Camp|r
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brother Nimetz|r, |cRXP_FRIENDLY_Corporal Sethman|r, and |cRXP_FRIENDLY_Lieutenant Doren.|r
.turnin 26733 >>Turn in Control Sample
.accept 26734 >>Accept The Source of the Madness
.goto 50,47.25,11.10
.turnin 26739 >>Turn in I Think She's Hungry
.accept 26744 >>Accept Deep Roots
.goto 50,46.98,10.84
.turnin 26736 >>Turn in Spared from Madness
.accept 26737 >>Accept Stopping Kurzen's Legacy
.goto 50,47.57,10.25
.target Brother Nimetz
.target Corporal Sethman
.target Lieutenant Doren
step
.goto 50,47.98,12.01
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Berrin Burnquill.|r
>>|cRXP_WARN_If he isn't here, either relog, or zone into Duskwood and come back|r
.accept 26742 >>Accept Bloodscalp Insight
.target Berrin Burnquill
step
#completewith next
.goto 50,47.74,12.69,30,0
.goto 50,49.44,14.20,30 >> Exit |cFFfa9602the Rebel Camp.|r
step
#completewith next
.goto 50,59.53,18.52,40 >> Enter |cFFfa9602the Cave.|r
step
#completewith Esquivel
>>Kill all |cRXP_ENEMY_Kurzen|r |cFFfa9602inside the cave|r |cRXP_WARN_EXCEPT Commandos|r and loot them for the |cRXP_LOOT_Blue Stone.|r
.complete 26734,1 
.mob Kurzen Headshrinker
.mob Kurzen Witch Doctor
.mob Kurzen Elite
.mob Kurzen Shadow Hunter
.mob Kurzen Subchief
step
.goto 50,60.48,17.05,20,0
.goto 50,62.42,17.61,20,0
.goto 50,63.22,16.90,20,0
.goto 50,63.75,16.74
>>Kill |cRXP_ENEMY_Chief Anders.|r
>>|cRXP_WARN_Be careful of the Stealthed Commandos inside the cave as they stun.|r
.complete 26737,1 
.mob Chief Anders
step
.goto 50,63.11,17.66,8,0
.goto 50,62.86,16.66,15,0
.goto 50,62.45,14.07
>>Kill |cRXP_ENEMY_Chief Gaulus.|r
.complete 26737,2 
.mob Chief Gaulus
step
.goto 50,64.09,19.02,20,0
.goto 50,65.78,17.13
>>Kill |cRXP_ENEMY_Chief Miranda|r
>>|cRXP_WARN_Check for a |cRXP_PICK_Chest|r near the barrels and crates.|r
.complete 26737,3 
.mob Chief Miranda
step
#label Esquivel
.goto 50,64.20,13.36,20,0
.goto 50,66.09,11.73
>>Kill |cRXP_ENEMY_Chief Esquivel.|r
>>|cRXP_WARN_Check for a |cRXP_PICK_Chest|r near the him|r
.complete 26737,4 
.mob Chief Esquivel
step
.goto 50,59.53,18.52,40,0
.goto 50,63.75,16.74,20,0
.goto 50,62.45,14.07,20,0
.goto 50,65.78,17.13,20,0
.goto 50,66.09,11.73,20,0
.goto 50,59.53,18.52,40,0
.goto 50,63.75,16.74,20,0
.goto 50,62.45,14.07,20,0
.goto 50,65.78,17.13,20,0
.goto 50,66.09,11.73
>>Kill all |cRXP_ENEMY_Kurzen|r |cFFfa9602inside the cave|r |cRXP_WARN_EXCEPT Commandos|r and loot them for the |cRXP_LOOT_Blue Stone.|r
.complete 26734,1 
.mob Kurzen Headshrinker
.mob Kurzen Witch Doctor
.mob Kurzen Elite
.mob Kurzen Shadow Hunter
.mob Kurzen Subchief
step
.goto 50,60.48,21.98,40,0
.goto 50,61.73,19.96,40,0
.goto 50,63.63,18.48,40,0
.goto 50,64.67,21.11,40,0
.goto 50,63.17,22.43,40,0
.goto 50,61.43,22.78,40,0
.goto 50,63.44,24.93,40,0
.goto 50,63.65,31.49,40,0
.goto 50,60.48,21.98,40,0
.goto 50,61.73,19.96,40,0
.goto 50,63.63,18.48,40,0
.goto 50,64.67,21.11,40,0
.goto 50,63.17,22.43,40,0
.goto 50,61.43,22.78,40,0
.goto 50,63.44,24.93,40,0
.goto 50,63.65,31.49
>>Kill |cRXP_ENEMY_Crystal Spine Basilisks|r and loot them for |cRXP_LOOT_Page 14|r
.complete 26269,1 
.mob Crystal Spine Basilisk
step
#completewith next
.deathskip >> Die and respawn at the |cRXP_FRIENDLY_Spirit Healer.|r
step
#sticky
#label Jaq2
.goto 50,43.69,23.19,0,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jaquilina Dramet.|r
.vendor 2483 >>Vendor and Repair. |cRXP_WARN_It is VERY important you repair here|r
.target Jaquilina Dramet
.isOnQuest 26737
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Barnil Stonepot|r, |cRXP_FRIENDLY_Krazek|r, and |cRXP_FRIENDLY_Drizzlik.|r
.turnin 26269 >>Turn in The Green Hills of Stranglethorn
.goto 50,44.25,22.12
.turnin 26763 >>Turn in Venture Company Mining
.accept 26765 >>Accept Return to Corporal Kaleb
.goto 50,43.60,23.13
.turnin 26344 >>Turn in Some Assembly Required
.goto 50,43.62,23.40
.target Barnil Stonepot
.target Krazek
.target Drizzlik
step
#requires Jaq2
#completewith next
>>Kill |cRXP_ENEMY_Elder Stranglethorn Tigers.|r
>>|cRXP_WARN_DON'T kill Sin'Dall If you see her|r
.complete 187,1 
.mob Elder Stranglethorn Tiger
step
#requires Jaq2
.goto 50,36.24,28.89,30 >>Check for |cRXP_ENEMY_Pogeyan|r(Rare).
.unitscan Pogeyan
.isOnQuest 191
step
.goto 50,36.39,32.58,40,0
.goto 50,37.61,33.55,40,0
.goto 50,37.17,36.85,40,0
.goto 50,38.56,36.44,40,0
.goto 50,39.82,32.34,40,0
.goto 50,38.58,28.25,40,0
.goto 50,36.39,32.58,40,0
.goto 50,37.61,33.55,40,0
.goto 50,37.17,36.85,40,0
.goto 50,38.56,36.44,40,0
.goto 50,39.82,32.34,40,0
.goto 50,38.58,28.25
>>Kill |cRXP_ENEMY_Elder Stranglethorn Tigers.|r
>>|cRXP_WARN_DON'T kill Sin'Dall If you see her|r
.complete 187,1 
.mob Elder Stranglethorn Tiger
step
.goto 50,38.48,32.59
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 187 >>Turn in Tiger Prowess
.accept 188 >>Accept Tiger Mastery
step
.goto 50,40.47,31.78,30,0
.goto 50,38.50,32.47,30,0
.goto 50,37.26,32.81,30,0
.goto 50,37.48,29.60,30,0
.goto 50,40.47,31.78,30,0
.goto 50,38.50,32.47,30,0
.goto 50,37.26,32.81,30,0
.goto 50,37.48,29.60
>>Kill |cRXP_ENEMY_Sin'Dall|r and loot her for her |cRXP_LOOT_Paw of Sin'Dall.|r
>>|cRXP_WARN_She respawns instantly east of the hill, then patrols ontop of the hill then either west, north, or east of it|r
.complete 188,1 
.unitscan Sin'Dall
step
.goto 50,36.63,27.97,40,0
.goto 50,36.13,30.34,40,0
.goto 50,32.22,26.43,40,0
.goto 50,33.77,25.57,40,0
.goto 50,36.44,22.90,40,0
.goto 50,33.86,18.86,40,0
.goto 50,31.35,20.62,40,0
.goto 50,36.63,27.97,40,0
.goto 50,36.13,30.34,40,0
.goto 50,32.22,26.43,40,0
.goto 50,33.77,25.57,40,0
.goto 50,36.44,22.90,40,0
.goto 50,33.86,18.86,40,0
.goto 50,31.35,20.62
>>Kill |cRXP_ENEMY_Panthers.|r
.complete 191,1 
.mob Panther
step
.goto 50,31.13,30.25
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 191 >>Turn in Panther Stalking
step
.goto 50,31.23,28.02,40,0
.goto 50,30.31,30.27,40,0
.goto 50,31.66,33.19,40,0
.goto 50,32.11,29.87,40,0
.goto 50,28.93,30.25,40,0
.goto 50,25.03,29.71,40,0
.goto 50,31.23,28.02,40,0
.goto 50,30.31,30.27,40,0
.goto 50,31.66,33.19,40,0
.goto 50,32.11,29.87,40,0
.goto 50,28.93,30.25,40,0
.goto 50,25.03,29.71
>>Kill |cRXP_ENEMY_Stranglethorn Raptors.|r
.complete 194,1 
.mob Stranglethorn Raptor
step
.goto 50,30.86,29.66
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 194 >>Turn in Raptor Hunting
.accept 195 >>Accept Raptor Stalking
step
#requires Prowess
#label BloodscalpT
#completewith BloodTablet
>>Kill |cRXP_ENEMY_Bloodscalp Shamans|r and loot them for their |cRXP_LOOT_Bloodscalp Totem.|r
.complete 26742,1 
.mob Bloodscalp Shaman
step
#requires BloodscalpT
#completewith next
.goto 50,33.64,36.91
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Hatchling|r |cFFfa9602next to you.|r
.accept 26745 >>Accept Favored Skull
.target Lashtail Hatchling
step
#requires Prowess
#label BloodTablet
.goto 50,33.64,36.91
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Tablet|r |cFFfa9602on the ground.|r
>>|cRXP_WARN_Check for a |cRXP_PICK_Chest|r nearby in the ruins|r
.complete 26744,1 
step
.goto 50,34.49,35.89,40,0
.goto 50,33.68,33.98,40,0
.goto 50,35.49,31.58,40,0
.goto 50,35.89,37.88,40,0
.goto 50,33.73,38.03,40,0
.goto 50,34.49,35.89,40,0
.goto 50,33.68,33.98,40,0
.goto 50,35.49,31.58,40,0
.goto 50,35.89,37.88,40,0
.goto 50,33.73,38.03
>>Kill |cRXP_ENEMY_Bloodscalp Shamans|r and loot them for their |cRXP_LOOT_Bloodscalp Totem.|r
>>|cRXP_WARN_Check for a |cRXP_PICK_Chest|r nearby in the ruins.|r
.complete 26742,1 
.mob Bloodscalp Shaman
step
.goto 50,33.64,36.91
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Hatchling|r |cFFfa9602next to you.|r
.accept 26745 >>Accept Favored Skull
.target Lashtail Hatchling
step
#completewith next
>>Kill |cRXP_ENEMY_Lashtail Raptors.|r
.complete 195,1 
.mob Lashtail Raptor
step
.goto 50,40.88,39.16,40,0
.goto 50,41.64,40.66,40,0
.goto 50,43.33,40.88,40,0
.goto 50,43.16,43.43,40,0
.goto 50,43.78,43.27,30 >>Check for |cRXP_ENEMY_Gluggl|r(Rare).
.unitscan Gluggl
.isOnQuest 26734
step
#completewith next
.goto 50,41.11,45.48,40,0
.goto 50,43.15,47.39,40,0
>>Kill |cRXP_ENEMY_Lashtail Raptors.|r
.complete 195,1 
.mob Lashtail Raptor
step
.goto 50,47.33,44.85,40,0
.goto 50,45.79,47.50,40,0
.goto 50,46.05,51.59,40,0
.goto 50,45.23,53.03,40,0
.goto 50,45.55,54.89,30 >>Check for |cRXP_ENEMY_Roloch|r(Rare).
.unitscan Roloch
.isOnQuest 26734
step
.goto 50,48.87,46.00,40,0
.goto 50,49.48,39.87,40,0
.goto 50,47.92,36.54,40,0
.goto 50,41.11,45.48,40,0
.goto 50,43.15,47.39,40,0
.goto 50,48.87,46.00,40,0
.goto 50,49.48,39.87,40,0
.goto 50,47.92,36.54,40,0
.goto 50,41.11,45.48,40,0
.goto 50,43.15,47.39
>>Kill |cRXP_ENEMY_Lashtail Raptors.|r
.complete 195,1 
.mob Lashtail Raptor
step
.goto 50,47.19,31.84
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 195 >>Turn in Raptor Stalking
.accept 196 >>Accept Raptor Prowess
step
.goto 50,47.19,31.84,40 >>Check for |cRXP_ENEMY_Tsul'Kalu|r(Rare).
.unitscan Tsul'Kalu
.isOnQuest 26734
step
#sticky
#label Jaq3
.goto 50,43.69,23.19,0,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jaquilina Dramet.|r
.vendor 2483 >>Vendor and Repair
.target Jaquilina Dramet
.isOnQuest 26685
step
.goto 50,44.50,22.66
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ajeck Rouack.|r
.turnin 188 >>Turn in Tiger Mastery
.target Ajeck Rouack
step
#requires Jaq3
#completewith next
.goto 50,49.44,14.20,30,0
.goto 50,47.74,12.69,30,0
.goto 50,47.25,11.10,40 >> Return |cFFfa9602to the Rebel Camp.|r
step
#requires Jaq3
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brother Nimetzz|r, |cRXP_FRIENDLY_Corporal Sethman|r, |cRXP_FRIENDLY_Corporal Kaleb|r, |cRXP_FRIENDLY_Osborn Obnoticus|r, |cRXP_FRIENDLY_Lieutenant Doren|r, and |cRXP_FRIENDLY_Berrin Burnquill.|r
.turnin 26734 >>Turn in The Source of the Madness
.goto 50,47.25,11.10
.turnin 26744 >>Turn in Deep Roots
.goto 50,46.98,10.84
.turnin 26765 >>Turn in Return to Corporal Kaleb
.goto 50,47.10,10.70
.turnin 26745 >>Turn in Favored Skull
.goto 50,47.14,10.56
.turnin 26737 >>Turn in Stopping Kurzen's Legacy
.goto 50,47.57,10.25
.turnin 26742 >>Turn in Bloodscalp Insight
.goto 50,47.98,12.01
.target Brother Nimetz
.target Corporal Sethman
.target Corporal Kaleb
.target Osborn Obnoticus
.target Lieutenant Doren
.target Berrin Burnquill
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#name 5A_Duskwood 2
#displayname Chapter 5 - Duskwood [2]
#next 6A_Redridge Mountains 2
#fresh 30
#veteran
<<Alliance
step
#completewith next
.zone 47 >> Take the |cFFfa9602Shortcut to Duskwood (optional)|r
.link https://www.youtube.com/watch?v=PLrBG2G5dKs >> CLICK HERE
.zoneskip 50,1
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sister Elsington|r, |cRXP_FRIENDLY_Jitters|r, and |cRXP_FRIENDLY_Oliver Harris|r
.accept 26777 >>Accept Soothing Spirits
.goto 47,20.03,57.82
.accept 26721 >>Accept The Jitters-Bugs
.goto 47,18.62,58.36
.turnin 26719 >>Turn in Delivery to Master Harris
.accept 26720 >>Accept A Curse We Cannot Lift
.goto 47,18.32,57.67
.target Sister Elsington
.target Jitters
.target Oliver Harris
step
#completewith LurkingW
>>Use the |T134547:0|t[Holy Censer] on |cRXP_FRIENDLY_Forlorn Spirits.|r
.complete 26777,1 
.mob Forlon Spirit
.use 60225
step
#completewith next
.goto 47,21.65,72.34,8,0
.goto 47,21.29,72.73,8 >>Go |cFFfa9602inside the Stable|r
step
#label LurkingW
.goto 47,21.61,73.15
>>|cRXP_WARN_Damage the Worgen that spawns to 20% or less health, then use the|r |T134825:0|t[Harris's Ampule] |cRXP_WARN_on it.|r
.complete 26720,1 
.mob Lurking Worgen
.use 60206
step
.goto 47,19.20,68.25,40,0
.goto 47,19.95,64.85,40,0
.goto 47,23.23,66.58,40,0
.goto 47,25.13,70.24,40,0
.goto 47,22.85,72.11,40,0
.goto 47,19.20,68.25,40,0
.goto 47,19.95,64.85,40,0
.goto 47,23.23,66.58,40,0
.goto 47,25.13,70.24,40,0
.goto 47,22.85,72.11
>>Use the |T134547:0|t[Holy Censer] on |cRXP_FRIENDLY_Forlorn Spirits.|r
.complete 26777,1 
.mob Forlon Spirit
.use 60225
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Oliver Harris|r and |cRXP_FRIENDLY_Sister Elsington.|r
.turnin 26720 >>Turn in A Curse We Cannot Lift
.accept 26760 >>Accept Cry For The Moon
.timer 58,Cry For The Moon RP
.goto 47,18.32,57.67
.turnin 26777 >>Turn in Soothing Spirits
.goto 47,20.03,57.82
.target Oliver Harris
.target Sister Elsington
step
.goto 47,20.26,58.37
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wilkinson.|r
.vendor 44114 >> Vendor Trash
.target Wilkinson
.isOnQuest 26760
step
.goto 47,21.08,56.45
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_John Shelby.|r
.fp Raven Hill >> Get the Raven Hill flight path
.target John Shelby
step
>>|cRXP_WARN_Wait out the RP|r
>>|cRXP_WARN_If you didn't get credit after the timer expires, abandon "Cry For The Moon" and accept the quest again|r
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Oliver Harris|r, |cRXP_FRIENDLY_Sven Yorgen|r, and |cRXP_FRIENDLY_Sister Elsington|r
.complete 26760,1 
.turnin 26760 >>Turn in Cry For The Moon
.goto 47,18.32,57.67
.accept 26723 >>Accept The Fate of Morbent Fel
.goto 47,18.34,58.06
.accept 26778 >>Accept The Cries of the Dead
.goto 47,20.03,57.82
.target Oliver Harris
.target Sven Yorgen
.target Sister Elsington
step
.goto 47,31.66,50.31,50,0
.goto 47,37.52,25.18,50,0
.goto 47,30.98,31.14,50,0
.goto 47,31.66,50.31,50,0
.goto 47,37.52,25.18,50,0
.goto 47,30.98,31.14
>>Kill |cRXP_ENEMY_Black Widows|r and loot them for their |cRXP_LOOT_Widow Venom Sac.|r
>>|cRXP_WARN_They sometimes vanish for 1-2s in combat|r
.complete 26721,1 
.mob Black Widow
step
#completewith EChest
+|cRXP_WARN_Avoid Mor'Ladim patrolling nearby|r
.unitscan Mor'Ladim
step
.goto 47,17.72,29.05
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_FRIENDLY_A Weathered Grave.|r
.accept 26793 >>Accept The Weathered Grave
step
#completewith EChest
>>Kill |cRXP_ENEMY_Plague Spreaders|r, |cRXP_ENEMY_Flesh Eaters|r, |cRXP_ENEMY_Rotted Ones|r, and |cRXP_ENEMY_Bone Chewers|r. |cRXP_WARN_Don't focus on this|r
.complete 26778,1 
.mob Plague Spreader
.mob Flesh Eater
.mob Rotted One
.mob Bone Chewer
step
.goto 47,17.49,33.40,8,0
.goto 47,17.44,34.17,5,0
.goto 47,16.97,33.42
>>|cRXP_WARN_Check for a |cRXP_PICK_Chest|r|r and loot the |cRXP_PICK_Hat|r on the ground |cFFfa9602inside the house |rfor |cRXP_PICK_Morbent's Remains.|r
.complete 26723,1 
step
#label EChest
.goto 47,19.88,44.53,20 >>Check for a |cRXP_PICK_Chest|r behind |cRXP_FRIENDLY_Eric.|r
.isOnQuest 26723
step
#veteran
.goto 47,19.88,44.61
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eric Davidson.|r
>>|cRXP_WARN_Skip this step if you don't have level 25 Pet Battle Pets|r
.accept 31850 >>Accept Eric Davidson
.target Eric Davidson
.isQuestTurnedIn 31903,31889,31891,31902
step
#veteran
.goto 47,19.88,44.61
>>Defeat |cRXP_ENEMY_Eric|r in a Pet Battle.
.complete 31850,1 
.target Eric Davidson
.skipgossip 65655,1
.isOnQuest 31850
step
#veteran
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 31850 >>Turn in Questlog
.isQuestComplete 31850
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sven Yorgen|r, |cRXP_FRIENDLY_Jitters|r, and |cRXP_FRIENDLY_Sister Elsington.|r
.turnin 26723 >>Turn in The Fate of Morbent Fel
.accept 26724 >>Accept The Lurking Lich
.goto 47,18.34,58.06
.turnin 26721 >>Turn in The Jitters-Bugs
.accept 26787 >>Accept Bear In Mind
.goto 47,18.62,58.36
.turnin 26724 >>Turn in The Lurking Lich
.accept 26725 >>Accept Guided by the Light
.turnin 26778 >>Turn in The Cries of the Dead
.goto 47,20.03,57.82
.target Sven Yorgen
.target Jitters
.target Sister Elsington
.isQuestComplete 26778
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sven Yorgen|r, |cRXP_FRIENDLY_Jitters|r, and |cRXP_FRIENDLY_Sister Elsington.|r
.turnin 26723 >>Turn in The Fate of Morbent Fel
.accept 26724 >>Accept The Lurking Lich
.goto 47,18.34,58.06
.turnin 26721 >>Turn in The Jitters-Bugs
.accept 26787 >>Accept Bear In Mind
.goto 47,18.62,58.36
.turnin 26724 >>Turn in The Lurking Lich
.accept 26725 >>Accept Guided by the Light
.goto 47,20.03,57.82
.target Sven Yorgen
.target Jitters
.target Sister Elsington
step
#completewith CatacombsX
>>Kill |cRXP_ENEMY_Plague Spreaders|r, |cRXP_ENEMY_Flesh Eaters|r, |cRXP_ENEMY_Rotted Ones|r, and |cRXP_ENEMY_Bone Chewers.|r
.complete 26778,1 
.mob Plague Spreader
.mob Flesh Eater
.mob Rotted One
.mob Bone Chewer
step
.goto 47,23.45,35.41
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_FRIENDLY_Lightforged Rod|r |cFFfa9602on the ground.|r
.turnin 26725 >>Turn in Guided by the Light
.accept 26753 >>Accept The Halls of the Dead
step
#label CatacombsX
#completewith next
.goto 47,23.94,34.80,10,0
.goto 47,25.68,33.76,15,0
.goto 47,25.46,31.50,15,0
.goto 47,23.47,27.99,15,0
.goto 47,20.37,27.46,20 >>Go deep |cFFfa9602inside the Catacombs.|r
step
.goto 47,20.37,27.46
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_FRIENDLY_Lightforged Arch|r |cFFfa9602on the ground.|r
.turnin 26753 >>Turn in The Halls of the Dead
.accept 26722 >>Accept Buried Below
step
#completewith next
.goto 47,20.33,26.81,10,0
.goto 47,19.47,26.81,10,0
.goto 47,18.53,24.94,10,0
.goto 47,18.01,25.37,10 >>Go through the hole in the wall and descend deeper |cFFfa9602into the Catacombs.|r
step
.goto 47,18.01,25.37
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_FRIENDLY_Lightforged Crest|r |cFFfa9602on the ground.|r
.turnin 26722 >>Turn in Buried Below
.accept 26754 >>Accept Morbent's Bane
step
#completewith next
.goto 47,17.33,26.27,10,0
.goto 47,18.16,27.63,10,0
.goto 47,17.63,28.45,10 >>Run deeper |cFFfa9602into the secret part of the Catacombs.|r
step
#completewith next
.goto 47,16.53,31.06
.cast 82130 >>|cRXP_WARN_Use|r |T135142:0|t[Morbent's Bane] |cRXP_WARN_on|r |cRXP_ENEMY_Morbent Fel|r |cRXP_WARN_to weaken him.|r
.mob Morbent Fel
.use 60212
step
.goto 47,16.53,31.06
>>Kill |cRXP_ENEMY_Morbent Fel.|r
.complete 26754,1 
.mob Morbent Fel
.use 60212
step
#completewith CoalB
.goto 47,16.18,33.19,15,0
.goto 47,15.31,38.48,15,0
.goto 47,16.09,38.78,15 >>Exit the Catacombs |cFFfa9602through the other side.|r
step
.goto 47,20.72,35.33,40,0
.goto 47,22.70,32.95,40,0
.goto 47,16.20,33.17,40,0
.goto 47,14.27,41.46,40,0
.goto 47,20.72,35.33,40,0
.goto 47,22.70,32.95,40,0
.goto 47,16.20,33.17,40,0
.goto 47,14.27,41.46
>>Kill |cRXP_ENEMY_Plague Spreaders|r, |cRXP_ENEMY_Flesh Eaters|r, |cRXP_ENEMY_Rotted Ones|r, and |cRXP_ENEMY_Bone Chewers.|r
>>|cRXP_WARN_Avoid Mor'Ladim patrolling nearby|r
.complete 26778,1 
.mob Plague Spreader
.mob Flesh Eater
.mob Rotted One
.mob Bone Chewer
.unitscan Mor'Ladim
step
#label CoalB
.goto 47,13.92,34.34,40,0
.goto 47,7.91,33.71,40,0
.goto 47,11.17,60.22,40,0
.goto 47,16.99,76.07,40,0
.goto 47,13.92,34.34,40,0
.goto 47,11.17,60.22,40,0
.goto 47,16.99,76.07
>>Kill |cRXP_ENEMY_Coalpelt Bears|r and loot them for their |cRXP_LOOT_Black Bear Brains.|r
>>|cRXP_WARN_Check for |cRXP_ENEMY_Marina|r (Rare).|r
.complete 26787,1 
.mob Coalpelt Bear
.unitscan Marina DeSirrus
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sven Yorgen|r, |cRXP_FRIENDLY_Jitters|r, and |cRXP_FRIENDLY_Sister Elsington.|r
.turnin 26754,1 >>Turn in Morbent's Bane
.goto 47,18.34,58.06
.turnin 26787 >>Turn in Bear In Mind
.goto 47,18.62,58.36
.turnin 26778 >>Turn in The Cries of the Dead
.goto 47,20.03,57.82
.target Sven Yorgen
.target Jitters
.target Sister Elsington
.isOnQuest 26778
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sven Yorgen|r and |cRXP_FRIENDLY_Jitters.|r
.turnin 26754 >>Turn in Morbent's Bane
.goto 47,18.34,58.06
.turnin 26787 >>Turn in Bear In Mind
.goto 47,18.62,58.36
.target Sven Yorgen
.target Jitters
step
#completewith next
.hs >> Hearthstone |cFFfa9602to Darkshire.|r
step
#completewith next
.goto 47,74.07,45.32,8,0
.goto 47,73.82,45.95,8,0
.goto 47,72.86,46.82,10,0
.goto 47,72.53,47.21,8 >>Exit |cFFfa9602the Inn, then go into the Town Hall.|r
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sirra Von'Indi|r and |cRXP_FRIENDLY_Commander Althea Ebonlocke.|r
.turnin 26793 >>Turn in The Weathered Grave
.accept 26794 >>Accept Morgan Ladimore
.goto 47,72.60,47.76
.turnin 26794 >>Turn in Morgan Ladimore
.goto 47,73.53,46.92
.target Sirra Von'Indi
.target Commander Althea Ebonlocke
step
#sticky
#label Morladim
.destroy 2154 >> |cRXP_WARN_You can delete "The Story of Morgan Ladimore" from your bags, as it's no longer needed.|r
step
.goto 47,79.53,47.48
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Viktori Prism'Antras.|r
.turnin 26685 >>Turn in Classy Glass
.target Viktori Prism'Antras
step
.goto 47,87.43,35.21
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Abercrombie.|r
.turnin 26680 >>Turn in Ogre Thieves
.accept 26677 >>Accept Ghoulish Effigy
.target Abercrombie
step
#completewith next
.goto 47,87.98,33.16,20,0
.goto 47,88.1,31.33,20,0
.goto 47,90.98,30.53,30 >>Check for the |cRXP_ENEMY_Unknown Soldier|r(Rare).
.unitscan Unknown Soldier
step
.goto 47,77.34,36.27,15,0
.goto 47,75.08,37.23,40,0
.goto 47,76.73,30.50,40,0
.goto 47,81.23,32.15,40,0
.goto 47,79.79,35.41,40,0
.goto 47,75.08,37.23,40,0
.goto 47,76.73,30.50,40,0
.goto 47,81.23,32.15,40,0
.goto 47,79.79,35.41
>>Kill |cRXP_ENEMY_Fetid Corpses|r and loot them for their |cRXP_LOOT_Ghoul Ribs.|r
>>|cRXP_WARN_Check for a |cRXP_PICK_Chest|r in and around the House|r
.complete 26677,1 
.mob Fetid Corpse
step
.goto 47,87.43,35.21
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Abercrombie.|r
.turnin 26677 >>Turn in Ghoulish Effigy
.accept 26681 >>Accept Note to the Mayor
.target Abercrombie
step
#completewith next
.goto 47,72.86,46.82,10,0
.goto 47,72.53,47.21,8,0
.goto 47,72.35,47.75,8 >>Enter |cFFfa9602the Town Hall.|r
step
.goto 47,71.93,46.43
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Ello Ebonlocke.|r
.turnin 26681 >>Turn in Note to the Mayor
.accept 26727 >>Accept The Embalmer's Revenge
.target Lord Ello Ebonlocke
step
#completewith next
.goto 47,72.35,47.75,8,0
.goto 47,72.53,47.21,8,0
.goto 47,72.86,46.82,10 >>Exit |cFFfa9602the Town Hall.|r
step
.goto 47,74.17,46.47
>>Kill |cRXP_ENEMY_Stiches.|r
.complete 26727,1 
.mob Stitches
step
#completewith next
.goto 47,72.86,46.82,10,0
.goto 47,72.53,47.21,8,0
.goto 47,72.35,47.75,8 >>Enter |cFFfa9602the Town Hall.|r
step
.goto 47,71.93,46.43
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Ello Ebonlocke.|r
.turnin 26727 >>Turn in The Embalmer's Revenge
.target Lord Ello Ebonlocke
step << DarkIronDwarf !Monk
#completewith Believe
.zone 84 >>Use |T1786409:0|t|cRXP_FRIENDLY_Mole Machine|r and |TInterface/cursor/crosshair/interact.blp:20|tinteract with it.
.skipgossip 143925,1,2
.xp <30,1
step << !DarkIronDwarf Monk
.goto 379,48.96,43.36
.zone 84 >>Cast |T775462:0|tZen Pilgrimage and |TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_portal to Stormwind.|r
.xp <30,1
step << !DarkIronDwarf Monk
#completewith next
.goto 84,49.45,86.60,8,0
.goto 84,49.51,86.67,10 >>Go through the portal and exit the Mage Tower
.xp <30,1
step << !Monk !DarkIronDwarf
#completewith next
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Felicia Maline.|r
.fly Stormwind >>Fly to Stormwind
.goto 47,77.48,44.28
.target Felicia Maline
.zoneskip 84
.xp <30,1
step << !Monk !DarkIronDwarf
.zone 84 >>Travel to Stormwind
.xp <30,1
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#displayname Chapter 6 - Redridge Mountains [2]
#name 6A_Redridge Mountains 2
#next 7A_Tirangarde Sound
#fresh 30
#veteran
<< Alliance
step
#completewith RedridgeStart
.next << 30
.goto 47,77.487,44.287
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Felicia Maline|r
.fly Camp Everstill >>Fly to Camp Everstill
.target Felicia Maline
.zoneskip 49
step
#optional
.goto 49,52.551,55.408
.accept 26646 >>Accept Prisoners of War
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_John J. Keeshan|r
.target John J. Keeshan
step
#label RedridgeStart
#optional
.goto 49,68.486,75.120
.zone 49 >> Travel to Redridge Mountains
step << Druid
#completewith SeaforiumD
+|cRXP_WARN_Use the|r |T133878:0|t[Bravo Company Field Kit] |cRXP_WARN_in|r |cRXP_WARN_Render's Valley|r
>>|cRXP_WARN_You can mount normally with the item, but cannot be|r |T136041:0|t[Camouflaged]
>>Cast |T136074:0|t[Camouflage] (1) to become invisible|r
>>Cast |T132289:0|t[Distraction] (2) to make the |cRXP_ENEMY_Blackrock Orcs|r move
>>Cast |T136090:0|t[Chloroform] (3) to sleep the |cRXP_ENEMY_Blackrock Wardens|r and |cRXP_ENEMY_Blackrock Guards|r. This does not work on |cRXP_ENEMY_Blackrock Drake Riders|r
.use 60384
.mob Blackrock Drake Rider
.mob Blackrock Warden
.mob Blackrock Guard
.isOnQuest 26646
.noflyable 
step
#optional << Druid
#completewith SeaforiumD
+|cRXP_WARN_Use the|r |T133878:0|t[Bravo Company Field Kit] |cRXP_WARN_in|r |cRXP_WARN_Render's Valley|r
>>|cRXP_WARN_You can mount normally with the item, but cannot be|r |T136041:0|t[Camouflaged] << !Druid
>>|cRXP_WARN_You can mount normally with the item and fly in|r |T132144:0|t[Travel Form] |cRXP_WARN_whilst|r |T136041:0|t[Camouflaged] << Druid
>>Cast |T136074:0|t[Camouflage] (1) to become invisible|r
>>Cast |T132289:0|t[Distraction] (2) to make the |cRXP_ENEMY_Blackrock Orcs|r move
>>Cast |T136090:0|t[Chloroform] (3) to sleep the |cRXP_ENEMY_Blackrock Wardens|r and |cRXP_ENEMY_Blackrock Guards|r. This does not work on |cRXP_ENEMY_Blackrock Drake Riders|r
.use 60384
.mob Blackrock Drake Rider
.mob Blackrock Warden
.mob Blackrock Guard
.isOnQuest 26646
.flyable << Druid 
step
#optional
#completewith next
.goto 49,68.486,75.120,20 >> Enter the cave in Render's Valley
step
.goto 49,69.525,76.315
>>Open the |cRXP_PICK_Blackrock Key Pouch|r inside. Loot it for the |cRXP_LOOT_Blackrock Holding Pen Key|r
>>|cRXP_WARN_[CHEST] Check for the |cRXP_PICK_Chest|r inside. Loot it if it's up|r
.collect 59261,1,26646,1 
step
.goto 49,68.665,61.444,0
.goto 49,69.805,59.125,-1
.goto 49,68.970,60.132,-1
>>Open any of the |cRXP_PICK_Blackrock Holding Pens|r
>>|cRXP_WARN_[CHEST] Check for the |cRXP_PICK_Chest|r west of the banner. Loot it if it's up|r
.complete 26646,1 
step
#sticky
#label Prisoners
>>|cRXP_WARN_Click the pop-up in your questlog|r
.turnin 26646 >>Turn in Prisoners of War
.accept 26651 >>Accept To Win a War, You Gotta Become War
step
#optional
#completewith next
.goto 49,66.318,70.789,15 >>Go inside the tower
.noflyable 
step
.goto 49,66.411,71.479
>>With the |T133878:0|t[Bravo Company Field Kit] equipped, cast |T136173:0|t[Plant Seaforium] (4) on the middle floor in the middle of the tower
>>|cRXP_WARN_[CHEST] Check for the |cRXP_PICK_Chest|r in the tower. Loot it if it's up|r
.complete 26651,2 
step
#label SeaforiumD
.goto 49,65.031,70.244,0
.goto 49,64.112,70.826
>>With the |T133878:0|t[Bravo Company Field Kit] equipped, cast |T136173:0|t[Plant Seaforium] (4) on the outside wall of the hut
>>|cRXP_WARN_[CHEST] Check for the |cRXP_PICK_Chest|r in front of the logs. Loot it if it's up|r
.complete 26651,1 
step
#optional
#completewith War
.goto 49,63.501,65.692,40 >>|cRXP_WARN_[RARE] Check for |cRXP_ENEMY_Chitter|r. Kill him if he's up|r
.unitscan Chitter
.noflyable
step
#optional
#label FieldKit
#completewith War
.aura -82587 >> |cRXP_WARN_Click off the|r |T133878:0|t[Bravo Company Field Kit] |cRXP_WARN_buff|r
.isOnQuest 26651
step
#optional
#requires FieldKit
#completewith War
>>|cRXP_WARN_Avoid|r |cRXP_ENEMY_Blackrock Wardens|r, |cRXP_ENEMY_Blackrock Guards|r, and |cRXP_ENEMY_Blackrock Drake Riders|r
.goto 49,77.683,65.506,15 >> Travel toward |cRXP_FRIENDLY_John J. Keeshan|r
.noflyable 
step
#label War
.goto 49,77.683,65.506
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_John J. Keeshan|r
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic|r
.turnin 26651 >>Turn in To Win a War, You Gotta Become War
.accept 26668 >>Accept Detonation
.target John J. Keeshan
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_John J. Keeshan|r and |cRXP_FRIENDLY_Danforth|r
.turnin 26668 >>Turn in Detonation
.accept 26693 >>Accept The Dark Tower
.goto 49,77.683,65.506
.target +John J. Keeshan
.accept 26692 >>Accept Shadowhide Extinction
.goto 49,77.628,65.341
.target +Danforth
step
#sticky
#label Shadowhide
.goto 49,73.167,48.650,0
.goto 49,74.650,52.479,0
.goto 49,72.277,51.252,0
.goto 49,69.079,50.430,0
.goto 49,67.317,43.754,0
.goto 49,66.197,37.545,0
.goto 49,71.332,33.267,0
.goto 49,70.571,38.254,0
.goto 49,73.004,43.909,0
.waypoint 49,73.167,48.650,50,0
.waypoint 49,73.795,49.819,50,0
.waypoint 49,76.102,53.026,50,0
.waypoint 49,74.650,52.479,50,0
.waypoint 49,73.531,53.657,50,0
.waypoint 49,73.185,50.399,50,0
.waypoint 49,72.277,51.252,50,0
.waypoint 49,71.567,50.196,50,0
.waypoint 49,71.349,48.124,50,0
.waypoint 49,69.079,50.430,50,0
.waypoint 49,66.885,47.661,50,0
.waypoint 49,67.015,45.857,50,0
.waypoint 49,67.317,43.754,50,0
.waypoint 49,65.054,40.527,50,0
.waypoint 49,64.633,37.658,50,0
.waypoint 49,66.197,37.545,50,0
.waypoint 49,66.330,33.341,50,0
.waypoint 49,68.025,35.534,50,0
.waypoint 49,71.332,33.267,50,0
.waypoint 49,72.209,34.231,50,0
.waypoint 49,71.606,35.978,50,0
.waypoint 49,70.571,38.254,50,0
.waypoint 49,70.569,41.638,50,0
.waypoint 49,73.004,43.909,50,0
>>Kill |cRXP_ENEMY_Rabid Shadowhide Gnolls|r, |cRXP_ENEMY_Shadowhide Darkweavers|r, |cRXP_ENEMY_Shadowhide Assassins|r, |cRXP_ENEMY_Shadowhide Warriors|r, |cRXP_ENEMY_Shadowhide Slayers|r, |cRXP_ENEMY_Shadowhide Brutes|r and |cRXP_ENEMY_Shadowhide Gnolls|r
>>|cRXP_WARN_Be careful as |cRXP_ENEMY_Shadowhide Assassins|r are|r |T132320:0|t[Stealthed]
.complete 26692,1 
.mob Rabid Shadowhide Gnoll
.mob *Shadowhide Darkweaver
.mob *Shadowhide Assassins
.mob *Shadowhide Warrior
.mob *Shadowhide Slayer
.mob *Shadowhide Brute
.mob *Shadowhide Gnoll
step
#sticky
#requires Shadowhide
#label Extinction
>>|cRXP_WARN_Click the pop-up in your questlog|r
.turnin 26692 >>Turn in Shadowhide Extinction
step
#optional
#completewith next
.goto 49,71.920,50.206,0
.goto 49,70.711,41.350,0
.goto 49,69.921,34.906,0
.goto 49,71.920,50.206,30,0
.goto 49,70.711,41.350,30,0
.goto 49,69.921,34.906,30,0
.goto 49,68.302,35.596,20 >>|cRXP_WARN_[RARE] Check for |cRXP_ENEMY_Rohh the Silent|r. Kill him if he's up|r
>>|cRXP_WARN_Be careful as he is|r |T132320:0|t[Stealthed]
>>|cRXP_WARN_[CHEST] Keep an eye out for |cRXP_PICK_Chests|r in Galardell Valley. Loot the |cRXP_PICK_Chest|r if you find one|r
.unitscan Rohh the Silent
.noflyable
step
#optional
#completewith next
.goto 49,67.611,30.650 >>Enter |cRXP_ENEMY_General Fangore|r's cave
step
.goto 49,67.542,28.902
>>Kill |cRXP_ENEMY_General Fangore|r inside. Loot him for the |cRXP_LOOT_Key of Ilgalar|r
>>|cRXP_WARN_[CHEST] Check for the |cRXP_PICK_Chest|r inside. Loot it if it's up|r
.complete 26693,1 
.mob General Fangore
step
>>|cRXP_WARN_Click the pop-up in your questlog|r
.turnin 26693 >>Turn in The Dark Tower
.accept 26694 >>Accept The Grand Magus Doane
step
#optional
#label Ilgalar1
#completewith next
.goto 49,72.538,44.629,20,0
.goto 49,71.952,44.819,15 >>Travel toward the entrance of the Tower of Ilgalar
.noflyable 
step
#optional
#label Ilgalar2
#requires Ilgalar1
#completewith next
.goto 49,71.952,44.819
.cast 81776 >> Click the |cRXP_PICK_Ward of Ilgalar|r at the base of the Tower of Ilgalar
.isOnQuest 26694
step
.goto 49,71.491,44.896,0
.goto 49,71.256,45.402
>>Defeat |cRXP_ENEMY_Grand Magus Doane|r inside atop the Tower of Ilgalar
>>|cRXP_WARN_[CHEST] Keep an eye out for |cRXP_PICK_Chests|r inside on the bottom floor and 2nd highest floor. Loot the |cRXP_PICK_Chest|r if you find one|r
.complete 26694,1 
.mob Grand Magus Doane
step
#requires Extinction
#completewith next
.goto 49,76.973,52.844,40,0
.goto 49,77.906,58.960,40,0
.goto 49,77.683,65.506,15 >> Return to |cRXP_FRIENDLY_John J. Keeshan|r
.noflyable 
step
#requires Extinction
.goto 49,77.683,65.506
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_John J. Keeshan|r
.turnin 26694 >>Turn in The Grand Magus Doane
.timer 29,The Grand Magus Doane RP
.target John J. Keeshan
step
.goto 49,77.204,65.923
>>|cRXP_WARN_Wait out the RP|r
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Colonel Troteman|r
.accept 26708 >>Accept AHHHHHHHHHHHH! AHHHHHHHHH!!!
.target Colonel Troteman
step
#completewith BlackrockInvaders
#label BravoCompany
.goto 49,76.916,66.133
.vehicle >> Enter the |cRXP_FRIENDLY_Bravo Company Siege Tank|r
.target Bravo Company Siege Tank
.isOnQuest 26708
step
#optional
#completewith BlackrockInvaders
#requires BravoCompany
.goto 49,77.906,58.960,40,0
.goto 49,76.869,54.470,40 >>|cRXP_WARN_Whilst in the |cRXP_FRIENDLY_Bravo Company Siege Tank|r, travel back toward Galardell Valley
.isOnQuest 26708
step
#label BlackrockInvaders
.goto 49,75.045,50.854,0
.goto 49,71.179,48.591,0
.goto 49,67.150,44.692,0
.goto 49,63.587,39.740,0
.goto 49,63.587,39.740,50,0
.goto 49,75.045,50.854,50,0
.goto 49,60.660,36.666
>>|cRXP_WARN_Whilst in the |cRXP_FRIENDLY_Bravo Company Siege Tank|r, drive through the |cRXP_ENEMY_Blackrock Invaders|r toward Keeshan's Post, casting|r |T252187:0|t[Ram] (1) |cRXP_WARN_on cooldown|r
.complete 26708,1 
.mob Blackrock Invader
step
#optional
#completewith next
>>|cRXP_WARN_Exit the|r |cRXP_FRIENDLY_Bravo Company Siege Tank|r
>>|cRXP_WARN_This will immediately phase you out of the phase with |cRXP_ENEMY_Blackrock Invaders|r and back into the phase with the|r |cRXP_ENEMY_Shadowhide Gnolls|r
.goto 49,60.660,36.666,15 >> Return to |cRXP_FRIENDLY_Colonel Troteman|r
step
.goto 49,60.660,36.666
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Colonel Troteman|r
.turnin 26708 >>Turn in AHHHHHHHHHHHH! AHHHHHHHHH!!!
.accept 26713 >>Accept Showdown at Stonewatch
.target Colonel Troteman
step
#optional
#completewith Darkblaze
+|cRXP_WARN_Ensure your team is with you before proceeding. They should spawn as you approach |cRXP_ENEMY_Tharil'zun|r. If they don't, log out and log back in|r
step
.goto 49,60.307,47.402
>>Kill |cRXP_ENEMY_Tharil'zun|r
.complete 26713,1 
.mob Tharil'zun
step
#optional
#completewith next
.goto 49,60.307,47.402,40,0
.goto 49,57.775,56.285,45 >>Travel toward |cRXP_ENEMY_Gath'Ilzogg|r
.noflyable 
step
.goto 49,57.775,56.285
>>Kill |cRXP_ENEMY_Gath'Ilzogg|r
.complete 26713,2 
.mob Gath'Ilzogg
step
>>|cRXP_WARN_Click the pop-up in your questlog|r
.turnin 26713 >>Turn in Showdown at Stonewatch
.goto 49,58.651,55.469
.accept 26714 >>Accept Darkblaze, Brood of the Worldbreaker
.timer 25,Darkblaze RP
.goto 49,60.660,36.666
step
#label Darkblaze
.goto 49,58.651,55.469
>>|cRXP_WARN_Wait out |cRXP_ENEMY_Grand Magus Doane|r's transformation RP|r
>>|cRXP_WARN_Defeat |cRXP_ENEMY_Darkblaze|r once the RP finishes|r
>>|cRXP_WARN_If you fail, use the|r |cRXP_PICK_Horn of Summoning|r on the ground to resummon|r |cRXP_ENEMY_Grand Magus Doane|r
.complete 26714,1 
.mob Darkblaze
.mob *Grand Magus Doane
step
.goto 49,60.660,36.666
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Colonel Troteman|r
.turnin 26714 >>Turn in Darkblaze, Brood of the Worldbreaker
.accept 26726 >>Accept Triumphant Return
.target Colonel Troteman
step
#optional
.goto 49,37.932,34.200,50 >>|cRXP_WARN_[RARE] Check for |cRXP_ENEMY_Chatter|r. Kill him if he's up|r
.unitscan Chatter
.isOnQuest 26726
.noflyable
step
#optional
#completewith Triumph
.goto 49,28.282,41.910,8,0
.goto 49,27.972,41.567,8 >> Enter the Lakeshire Town Hall
.isOnQuest 26726
step
.goto 49,28.971,41.123
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Magistrate Solomon|r inside
.turnin 26726 >>Turn in Triumphant Return
.turnin 26505 >>Turn in Parker's Report
.target Magistrate Solomon
.isQuestComplete 26505
.isOnQuest 26726
step
#optional
#label Triumph
.goto 49,28.971,41.123
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Magistrate Solomon|r inside
.turnin 26726 >>Turn in Triumphant Return
.target Magistrate Solomon
.isOnQuest 26726
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#name 7A_Tiragarde Sound
#displayname Chapter 7 - Tiragarde Sound
#next 8A_Tiragarde Sound Part 2
<<Alliance
step << DarkIronDwarf
#completewith Herald
.zone 84 >>Use |T1786409:0|t|cRXP_FRIENDLY_Mole Machine|r and |TInterface/cursor/crosshair/interact.blp:20|tinteract with it.
.skipgossip 143925,1,2
.isQuestAvailable 46727
step << Monk
#completewith Herald
.goto 379,48.96,43.36
.zone 84 >>Cast |T775462:0|tZen Pilgrimage and |TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_portal to Stormwind.|r
.isQuestAvailable 46727
step << !Monk !DarkIronDwarf
#completewith Herald
.goto 47,77.48,44.28
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Felicia Maline.|r
.fly Stormwind >>Fly |cFFfa9602to Stormwind.|r
.target Felicia Maline
.zoneskip 47,1
.isQuestAvailable 46727
step << !Monk !DarkIronDwarf
#completewith Herald
.goto 49,29.42,53.76
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ariena Stormfeather.|r
.fly Stormwind >>Fly |cFFfa9602to Stormwind.|r
.target Ariena Stormfeather
.zoneskip 49,1
.isQuestAvailable 46727
step << !Monk !DarkIronDwarf
.zone 84 >>Travel |cFFfa9602to Stormwind.|r
.isQuestAvailable 46727
step << Monk
.goto 84,60.39,75.27
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Innkeeper Allison.|r
.home >>Set your Hearthstone |cFFfa9602to Stormwind Trade District|r
.target Innkeeper Allison
step << Monk
#completewith next
>>Consider purchasing |T348525:0|t[Wildercloth Bags] from the Auction House |cRXP_WARN_if you need larger bags.|r However, if you already own larger bags, you can disregard this step. |cRXP_WARN_After purchase, head to the mailbox to collect them and then equip them.|r
.collect 194017,4 
.target Auctioneer Fitch
.target Auctioneer Chilton
.target Auctioneer Jaxon
step
#label Herald
.goto 84,62.82,71.74,-1
.goto 84,62.17,30.14,-1
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Hero's Herald.|r
.accept 46727 >>Accept Battle for Azeroth: Tides of War
.target Hero's Herald
step << !Monk
#completewith next
>>Consider purchasing |T348525:0|t[Wildercloth Bags] from the Auction House |cRXP_WARN_if you need larger bags.|r However, if you already own larger bags, you can disregard this step. |cRXP_WARN_After purchase, head to the mailbox to collect them and then equip them.|r
.collect 194017,4 
.target Auctioneer Fitch
.target Auctioneer Chilton
.target Auctioneer Jaxon
step << !Monk
.goto 84,60.39,75.27
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Innkeeper Allison|r
.home >>Set your Hearthstone to Stormwind Trade District
.target Innkeeper Allison
step
#completewith next
.goto 84,80.65,37.82,25,0
.goto 84,80.26,33.12,36 >>Travel |cFFfa9602to Stormwind's Keep|r
.timer 49,Battle for Azeroth: Tides of War RP
step
.goto 84,80.49,33.52
>>|cRXP_WARN_Wait for the brief roleplay, which will be completed when the timer runs out.|r
.complete 46727,1 
step
.goto 84,80.49,33.52
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal.|r
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic.|r
.complete 46727,2 
step
.goto 84,80.26,33.12
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Anduin Wrynn|r
.turnin 46727 >>Turn in Battle for Azeroth: Tides of War
.accept 46728 >>Accept The Nation of Kul Tiras
.target Anduin Wrynn
step
.goto 84,81.56,35.59,5,0
.goto 84,80.72,37.73,5,0
.goto 84,56.26,17.32
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Chromie|r
>>|cRXP_WARN_Select "The Cataclysm" Campaign|r
.turnin 62567 >>Turn in Adventurers Wanted: Chromie's Call
.accept 60891 >>Accept Cataclysm: Onward to Adventure in the Eastern Kingdoms
.target Chromie
.skipgossip
.isOnQuest 62567
step
.goto 84,81.56,35.59,5,0
.goto 84,80.72,37.73,5,0
.goto 84,56.26,17.32
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Chromie|r and select |cRXP_WARN_ "The Cataclysm" Campaign.|r
.accept 60891 >>Accept Cataclysm: Onward to Adventure in the Eastern Kingdoms
.target Chromie
.skipgossip
step
.goto 84,63.76,73.60
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk |cRXP_FRIENDLY_Renato Gallina|r
.accept 332 >>Accept Wine Shop Advert
.target Renato Gallina
.isOnQuest 62567
step
.goto 84,62.32,67.96
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk |cRXP_FRIENDLY_Harlan Bagley|r
.accept 333 >>Accept Harlan Needs a Resupply
.target Harlan Bagley
.isOnQuest 62567
step
.goto 84,58.09,67.49
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk |cRXP_FRIENDLY_Rema Schneider|r
.turnin 333 >>Turn in Harlan Needs a Resupply
.accept 334 >>Accept Package for Thurman
.target Rema Schneider
.isOnQuest 62567
step
.goto 84,60.28,76.75
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk |cRXP_FRIENDLY_Suzetta Gallina|r
.turnin 332 >>Turn in Wine Shop Advert
.target Suzetta Gallina
.isOnQuest 62567
step
.goto 84,52.59,83.40
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk |cRXP_FRIENDLY_Thurman Schneider|r
.turnin 334 >>Turn in Package for Thurman
.target Thurman Schneider
.isOnQuest 62567
step
.goto 84,22.79,24.68
.achievementIncomplete 12582,1
.isOnQuest 46728
.gossipoption 47615 >> Talk to |cRXP_FRIENDLY_Lady Jaina Proudmoore|r
>>|cRXP_WARN_Wait for the brief roleplay, which will be completed when the timer runs out.|r
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic.|r
.turnin 46728 >>Turn in The Nation of Kul Tiras
.accept 51341 >>Accept Daughter of the Sea
.timer 7,Daughter of the Sea RP
.target Lady Jaina Proudmoore
step
.goto 84,22.79,24.68
.achievementComplete 12582,1
.isOnQuest 46728
.gossipoption 47616 >> Talk to |cRXP_FRIENDLY_Lady Jaina Proudmoore|r and press accept to skip |cRXP_WARN_ "the Kultiras Introduction Quests"|r
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic|r
.target Lady Jaina Proudmoore
step
.goto 84,22.79,24.68
.achievementComplete 12582,1
.isOnQuest 46728
.gossipoption 47616 >> Talk to |cRXP_FRIENDLY_Lady Jaina Proudmoore|r
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic.|r
.target Lady Jaina Proudmoore
step
.goto 1169,47.42,46.30
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flynn Fairwind|r
.turnin 51341 >>Turn in Daughter of the Sea
.accept 47098 >>Accept Out Like Flynn
.timer 5,Out Like Flynn RP
.target Flynn Fairwind
step
.goto 1169,46.62,45.47
>>|cRXP_WARN_Wait for the brief roleplay, which will be completed when the timer runs out.|r
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Flynn Fairwind|r to punch him.
.complete 47098,1 
.timer 10,Out Like Flynn RP
.target Flynn Fairwind
.skipgossip
step
.goto 1169,46.66,40.94
>>|cRXP_WARN_Wait for the brief roleplay, which will be completed when the timer runs out.|r
>>Run out the cell and pull the |cRXP_PICK_Lever.|r
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic.|r
.complete 47098,2 
step
.goto 1169,46.84,44.71
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Chest|r |cFFfa9602on the ground.|r
.complete 47098,3 
step
.goto 1169,40.25,54.78
>>Kill |cRXP_ENEMY_Carmine|r
.complete 47098,4 
.mob Block Warden Carmine
step
.goto 1169,43.58,54.08
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Gunpowder|r |cFFfa9602on the table.|r
.complete 47098,5 
step
.isOnQuest 47098
.goto 1169,42.71,46.78,10,0
.goto 1169,41.17,43.49,10,0
.goto 1169,43.24,36.66,15 >>Run |cFFfa9602to the Cell Block Gate|r
step
.isOnQuest 47098
.goto 1169,43.24,36.66
.cast 271399 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Cell Block Gate|r
.timer 12,Out Like Flynn RP
step
.goto 1169,44.48,35.69,12,0
.goto 1169,45.51,36.76,12,0
.goto 1169,49.31,42.18,12,0
.goto 1169,48.59,42.70,12,0
.goto 1169,46.69,42.80,12,0
.goto 1169,44.19,42.22,12,0
.goto 1169,37.94,53.79
>>Run |cFFfa9602down the hall into the Sewers.|r
.complete 47098,7 
step
.goto 1169,44.48,35.69,12,0
.goto 1169,45.51,36.76,12,0
.goto 1169,49.31,42.18,12,0
.goto 1169,48.59,42.70,12,0
.goto 1169,46.69,42.80,12,0
.goto 1169,44.19,42.22,12,0
.goto 1169,37.94,53.79
>>Run down the hall into the Sewers
.complete 47098,7 
step
.isOnQuest 47098
.goto 1169,42.23,58.92,10,0
.goto 1169,48.87,45.24,10,0
.goto 1169,50.96,47.27,10 >>Run |cRXP_WARN_down the Drain Pipe out to the Shore.|r
step
.isOnQuest 47098
.goto 1169,61.53,47.69,30,0
.goto 1169,64.04,33.31,30,0
.goto 1169,60.59,25.53,20 >>Run to the |cRXP_PICK_Getaway Boat.|r
step
.goto 1169,60.59,25.53
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Getaway Boat.|r
.complete 47098,8 
.timer 36,Out Like Flynn RP
step
#completewith next
+|cRXP_WARN_Wait for the brief roleplay, which will be completed when the timer runs out.|r
*|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic.|r
.isOnQuest 47098
step << KulTiran
.goto 1161,68.16,21.99
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taelia|r
.accept 47189 >>Accept A Nation Divided
.target Taelia
step << KulTiran
.goto 1161,68.38,22.11
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Scouting Map|r
.complete 47189,1 
step << KulTiran
.goto 1161,75.72,23.58
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taelia|r
.accept 47960 >>Accept Tiragarde Sound
.turnin 47189 >>Turn in A Nation Divided
.target Taelia
step << KulTiran
.goto 1161,67.60,22.19
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flynn Fairwind|r
.accept 47181 >>Accept The Smoking Gun
.complete 47181,1 
.target Flynn Fairwind
step << KulTiran
.goto 1161,67.58,22.19
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flynn Fairwind|r
.turnin 47181 >>Turn in The Smoking Gun
.target Flynn Fairwind
step << KulTiran
.goto 1161,67.97,21.91
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cyrus Crestfall|r
.accept 47485 >>Accept The Ashvane Trading Company
.target Cyrus Crestfall
step << !KulTiran
.goto 1161,75.73,23.58
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taelia|r
.turnin 47098 >>Turn in Out Like Flynn
.accept 47099 >>Accept Get Your Bearings
.target Taelia
step << !KulTiran
.goto 1161,74.17,24.80,10 >>Go near |cRXP_FRIENDLY_Will Melborne|r
.timer 6.5, Wait at Tradewinds Counting House
.isOnQuest 47099
step << !KulTiran
.goto 1161,75.59,19.51
>>|cRXP_WARN_Wait for the brief roleplay infront of the |cFFfa9602Tradewinds Counting House|r, which will be completed when the timer runs out.|r
>>|cFFd0342cDON'T go inside the |cFFfa9602Tradewinds Counting House|r yet.|r
.complete 47099,1 
.target Will Melborne
step << !KulTiran
.goto 1161,75.47,17.94,5 >>Go inside the |cFFfa9602Tradewinds Counting House.|r
.timer 3.6, bank rp.
.isOnQuest 47099
step << !KulTiran
.goto 1161,75.6,19.15,5,0
.goto 1161,73.53,13.81,5 >> Go inside the |cFFfa9602Snug Harbor Inn.|r
.timer 7.5, Inn RP
.isOnQuest 47099
step << !KulTiran
.goto 1161,74.13,12.66
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wesley Rockhold|r
.home >>Set your Hearthstone to Boralus
.target Wesley Rockhold
.isOnQuest 47099
step << !KulTiran
.isOnQuest 47099
.goto 1161,73.52,13.8,5,0
.goto 1161,67.02,14.96
>>Follow the Arrow. |cRXP_WARN_then wait for the brief roleplay, which will be completed when the timer runs out.|r
.complete 47099,3 
step << !KulTiran
.isOnQuest 47099
.goto 1161,67.2,15.05,10,0
.goto 1161,68.93,21.13,5,0
.goto 1161,67.45,21.39,5,0
.goto 1161,68.73,18.86,10,0
.goto 1161,68.96,21.15,5,0
.goto 1161,67.55,21,5,0
.goto 1161,67.16,22.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Joan Weber|r to unlock the flightpath |cRXP_WARN_then follow the arrow to continue.|r
.complete 47099,4 
step << !KulTiran
.goto 1161,67.18,22.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taelia|r |cFFfa9602next to you.|r
.turnin 47099 >>Turn in Get Your Bearings
.accept 46729 >>Accept The Old Knight
.target Taelia
step << !KulTiran
.goto 1161,67.13,23.06
>>Enter the |cFFfa9602Harbormaster's Office.|r
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic|r
.complete 46729,1 
.timer 13,The Old Knight RP
step << !KulTiran
.isOnQuest 46729
.goto 1161,67.99,21.88
>>|cRXP_WARN_Wait for the brief roleplay, which will be completed when the timer runs out.|r
.gossipoption 48242 >>Talk to |cRXP_FRIENDLY_Cyrus Crestfall|r
.timer 83,Cyrus Tale RP
.target Cyrus Crestfall
step
#label WorkersR
.goto 1161,67.08,23.7,5,0
.goto 1161,68.59,25.26,15,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Davey Brindle|r and |TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_FRIENDLY_Formal Invitation|r |cFFfa9602on the table|r, as well as |cRXP_FRIENDLY_Wanted Poster|r
.accept 50699 >>Accept Worker's Rights
.goto 895,67.40,24.14
.accept 48070 >>Accept The Norwington Festival
.goto 895,67.14,24.80,-1
.accept 51358 >>Accept WANTED: Gryphon 'Nappers
.goto 895,66.84,24.36,-1
.target Davey Brindle
step
#completewith next
+|cRXP_WARN_Open any |cRXP_PICK_"Small Treasure Chests"|r you come across, as they provide a substantial amount of XP|r
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Maynard Algerson|r and |cRXP_FRIENDLY_Benjamin Algerson|r
.turnin 50699 >>Turn in Worker's Rights
.accept 49465 >>Accept Maximizing Resources
.accept 49452 >>Accept Inventory Deficit
.goto 895,68.92,20.43,10,0
.goto 895,68.93,20.59
.accept 49451 >>Accept Time Off Requests
.goto 895,68.89,20.44,5,0
.goto 895,68.89,19.84
.target Maynard Algerson
.target Benjamin Algerson
step
#completewith Wood-Adorned Skull
>>Kill |cRXP_ENEMY_Timberbough Invaders|r and |cRXP_ENEMY_Timberfang Lurkers|r and loot them for their |cRXP_LOOT_Skulls|r
.complete 49465,1 
.mob Timberbough Invader
.mob Timberfang Lurker
step
.goto 895,68.41,19.7
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Reclaimed Axe|r
.complete 49452,1,1 
step
.goto 895,68.17,18.95
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with the |cRXP_PICK_Entangled Lumberjack.|r
.complete 49451,1,1 
.target Entangled Lumberjack
step
.goto 895,68.06,18.9
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Reclaimed Axe|r
.complete 49452,1,2 
step
.goto 895,67.64,19.38
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with the |cRXP_PICK_Entangled Lumberjack.|r
.complete 49451,1,2 
.target Entangled Lumberjack
step
.goto 895,67.37,19.44
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with the |cRXP_PICK_Entangled Lumberjack.|r
.complete 49451,1,3 
.target Entangled Lumberjack
step
.goto 895,67.4,19.36
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Reclaimed Axe|r
.complete 49452,1,3 
step
.goto 895,67.41,18.84
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Reclaimed Axe|r
.complete 49452,1,4 
step
.goto 895,67.43,18.6
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with the |cRXP_PICK_Entangled Lumberjack.|r
.complete 49451,1,4 
.target Entangled Lumberjack
step
.goto 895,67.53,18.07
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Reclaimed Axe|r
.complete 49452,1,5 
step
.goto 895,67.27,17.9
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with the |cRXP_PICK_Entangled Lumberjack.|r
.complete 49451,1,5 
.target Entangled Lumberjack
step
#label Wood-Adorned Skull
.goto 895,66.62,17.32
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lyssa Treewarden|r
.accept 49453 >>Accept Give a Dam
.accept 48557 >>Accept Sowing Saplings
.target Lyssa Treewarden
step
#completewith Loamy Soil
>>Kill |cRXP_ENEMY_Timberbough Invaders|r and |cRXP_ENEMY_Timberfang Lurkers|r and loot them for their |cRXP_LOOT_Skulls|r
.complete 49465,1 
.mob Timberbough Invader
.mob Timberfang Lurker
step
#completewith Loamy Soil
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_PICK_Woodchewing Beavers|r
.complete 49453,1 
.target Woodchewing Beaver
step
.goto 895,66.55,16.8
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Loamy Soil |r|cFFfa9602on the ground.|r
.complete 48557,1,1 
step
.goto 895,66.29,16.2
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Loamy Soil |r|cFFfa9602on the ground.|r
.complete 48557,1,2 
step
.goto 895,66.51,15.65
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Loamy Soil |r|cFFfa9602on the ground.|r
.complete 48557,1,3 
step
#label Loamy Soil
.goto 895,66.7,16.61
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Loamy Soil |r|cFFfa9602on the ground.|r
.complete 48557,1,4 
step
#completewith next
>>Kill |cRXP_ENEMY_Timberbough Invaders|r and |cRXP_ENEMY_Timberfang Lurkers|r and loot them for their |cRXP_LOOT_Skulls|r
.complete 49465,1 
.mob Timberbough Invader
.mob Timberfang Lurker
step
.goto 895,68.93,20.59
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_PICK_Woodchewing Beavers|r
.complete 49453,1 
.target Woodchewing Beaver
step
.goto 895,68.93,20.59
>>Kill |cRXP_ENEMY_Timberbough Invaders|r and |cRXP_ENEMY_Timberfang Lurkers|r and loot them for their |cRXP_LOOT_Skulls|r
.complete 49465,1 
.mob Timberbough Invader
.mob Timberfang Lurker
step
.goto 895,66.62,17.32
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lyssa Treewarden|r
.turnin 49453 >>Turn in Give a Dam
.turnin 48557 >>Turn in Sowing Saplings
.target Lyssa Treewarden
step
.goto 895,68.92,20.43,10,0
.goto 895,68.93,20.59
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Maynard Algerson|r
.turnin 49465 >>Turn in Maximizing Resources
.turnin 49452 >>Turn in Inventory Deficit
.turnin 49451 >>Turn in Time Off Requests
.accept 48369 >>Accept Emergent Strategy
.target Maynard Algerson
step
.goto 895,68.9,20.44,5,0
.goto 895,70.09,18.58
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Benjamin Algerson|r
.turnin 48369 >>Turn in Emergent Strategy
.accept 49468 >>Accept Required Webinar
.accept 49454 >>Accept Pest Prevention
.accept 49450 >>Accept Incident Reports
.target Benjamin Algerson
step
#completewith Webbed Lumberjack freed
>>Kill |cRXP_ENEMY_Enthralled Ashclaws|r, |cRXP_ENEMY_Enthralled Mossfangs,|r and |cRXP_ENEMY_Mossfang Eggs|r
.complete 49450,1 
.complete 49454,1 
.mob Enthralled Ashclaw
.mob Enthralled Mossfang
.mob Mossfang Egg
step
.goto 895,70.63,18.07
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with the |cRXP_PICK_Webbed Lumberjack|r
.complete 49468,1,1 
.target Webbed Lumberjack
step
.goto 895,71.29,17.98
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with the |cRXP_PICK_Webbed Lumberjack|r
.complete 49468,1,2 
.target Webbed Lumberjack
step
.goto 895,71.84,18.17
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with the |cRXP_PICK_Webbed Lumberjack|r
.complete 49468,1,3 
.target Webbed Lumberjack
step
.goto 895,72.33,17.87
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with the |cRXP_PICK_Webbed Lumberjack|r
.complete 49468,1,4 
.target Webbed Lumberjack
step
.goto 895,72.96,17.55
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Terrence Foster|r
.accept 50058 >>Accept The Witch's Pet
.target Terrence Foster
step
.goto 895,73.49,18.71
>>Kill the |cRXP_ENEMY_Mossfang Matriarch|r
>>|cRXP_WARN_Avoid her Venom Wave frontal cone|r
.complete 50058,1 
.mob Mossfang Matriarch
step
#label Webbed Lumberjack freed
.goto 895,73.61,19.07
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with the |cRXP_PICK_Webbed Lumberjack|r
.complete 49468,1,5 
.target Webbed Lumberjack
step
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 50058 >>Turn in The Witch's Pet
step
.goto 895,72.93,17.72,10,0
.goto 895,71.54,17.67,20,0
.goto 895,70.89,18.52,20,0
.goto 895,70.09,18.58
>>Kill |cRXP_ENEMY_Enthralled Ashclaws|r, |cRXP_ENEMY_Enthralled Mossfangs,|r and |cRXP_ENEMY_Mossfang Eggs|r
.complete 49450,1 
.complete 49454,1 
.mob Enthralled Ashclaw
.mob Enthralled Mossfang
.mob Mossfang Egg
step
.goto 895,70.09,18.58
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Benjamin Algerson|r
.turnin 49468 >>Turn in Required Webinar
.turnin 49454 >>Turn in Pest Prevention
.turnin 49450 >>Turn in Incident Reports
.accept 49467 >>Accept Witch of the Woods
.target Benjamin Algerson
step
.goto 895,70.45,13.75
>>Kill the |cRXP_ENEMY_Witch of the Woods|r and loot her for the |cRXP_LOOT_Locket|r
>>|cRXP_WARN_Avoid her Crawling Swarm frontal cone|r
.complete 49467,1 
.mob Witch of the Woods
step
.goto 895,68.85,13.17
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Maynard Algerson|r
.turnin 49467 >>Turn in Witch of the Woods
.target Maynard Algerson
step
.isOnQuest 51358
.goto 895,67.38,22.07,20 >> Enter the |cFFfa9602Cave|r
step
.goto 895,67.2,21.70
>>Kill |cRXP_ENEMY_Boris|r and |cRXP_ENEMY_Lindel.|r
>>This quest is challenging. |cRXP_WARN_Skip this step if you are unable to defeat them.|r
.complete 51358,1 
.complete 51358,2 
.mob Lindel the Snatcher
.mob Silent Boris
step
.goto 895,66.93,23.07
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mariah McKee|r
.fp Hatherford >>Get the Hatherford Flight Path
.target Mariah McKee
step
.isOnQuest 51358
.goto 895,66.42,24.42,10 >> Enter |cFFfa9602the House|r
step
.goto 895,66.27,24.28
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dandy Jones|r
.turnin 51358 >>Turn in WANTED: Gryphon 'Nappers
.target Dandy Jones
.isQuestComplete 51358
step
.goto 895,66.32,24.80
.abandon 51358 >>Abandon WANTED: Gryphon 'Nappers
step
#completewith next
.goto 895,66.42,24.42,5 >> Leave the |cFFfa9602the House|r
step
.goto 895,66.32,24.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Hatherford Guard.|r
.accept 50700 >>Accept Drust in Time
.target Hatherford Guard
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Drogrin Alewhisker|r and |cRXP_FRIENDLY_Recruit Brutis.|r
.turnin 50700 >>Turn in Drust in Time
.accept 49225 >>Accept Chasing the Leader
.accept 49229 >>Accept The Ruins Fought Back
.goto 895,62.73,29.95
.accept 49234 >>Accept A Marine Out of Water
.goto 895,62.95,29.92
.target Drogrin Alewhisker
.target Recruit Brutis
step
#completewith BirchT
>>Kill |cRXP_ENEMY_Ancient Protectors|r
.complete 49229,1 
.mob Ancient Protector
step
#completewith next
.goto 1171,44.51,88.32,15,0
.goto 1171,40.22,71.90,15 >>Go |cFFfa9602inside the cave|r
step
#label BirchT
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Birch Tomlin|r and |cRXP_FRIENDLY_Pendi Cranklefuse|r
.accept 49233 >>Accept I'm a Druid, Not a Priest
.goto 1171,50.39,70.36
.accept 49232 >>Accept Salvaging a Disaster
.goto 1171,51.27,70.58
.target Birch Tomlin
.target Pendi Cranklefuse
step
#completewith Ancient Protector
>>Kill |cRXP_ENEMY_Ancient Protectors|r
.complete 49229,1 
.mob Ancient Protector
step
#completewith Ancient Protector
>>Use the |T329590:0|t[Repurposed Gilnean Staff] on |cRXP_ENEMY_Cursed Raiders|r
.complete 49233,1 
.use 153350
.mob Cursed Raider
step
.goto 1171,57.34,65.78
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Drust Relic|r
.complete 49232,1,1 
step
.goto 1171,64.17,53.31,20,0
.goto 1171,58.63,37.76
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hilde Firebreaker|r
.turnin 49225 >>Turn in Chasing the Leader
.accept 49260 >>Accept Backup While I Pack Up
.target Hilde Firebreaker
step
#completewith Ancient Protector
>>You aren't required to defend Firebreaker; you can simply proceed and the quest will complete automatically. |cRXP_WARN_However, be aware that if you die before this quest is completed, you'll have to start it over.|r
.complete 49260,1 
step
.goto 1171,62.59,55.61,10,0
.goto 1171,41.39,50.8
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Drust Relic|r
.complete 49232,1,2 
step
.goto 1172,44.19,69.85
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Drust Relic|r
.complete 49232,1,3 
step
.goto 1172,59.84,18.18
>>Kill |cRXP_ENEMY_Awakened Guardian|r
.complete 49234,1 
.mob Awakened Guardian
step
.goto 1172,59.55,13.12
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Drust Relic|r
.complete 49232,1,4 
step
.goto 1171,46.34,54.89
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Drust Relic|r
.complete 49232,1,5 
step
.goto 1171,44.99,60.75
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Drust Relic|r
.complete 49232,1,6 
step
#label Ancient Protector
.goto 1171,64.17,53.31,15,0
.goto 1171,58.63,37.76
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hilde Firebreaker|r
.turnin 49260 >>Turn in Backup While I Pack Up
.target Hilde Firebreaker
.isQuestComplete 49260
step
#completewith next
>>Kill |cRXP_ENEMY_Ancient Protectors|r
.complete 49229,1 
.mob Ancient Protector
step
.goto 1171,51.27,70.58
>>Use the |T329590:0|t[Repurposed Gilnean Staff] on |cRXP_ENEMY_Cursed Raiders|r
.complete 49233,1 
.use 153350
.mob Cursed Raider
step
.goto 1171,51.27,70.58
>>Kill |cRXP_ENEMY_Ancient Protectors|r
.complete 49229,1 
.mob Ancient Protector
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Pendi Cranklefuse|r and |cRXP_FRIENDLY_Birch Tomlin|r
.turnin 49232 >>Turn in Salvaging a Disaster
.goto 1171,51.27,70.58
.turnin 49233 >>Turn in I'm a Druid, Not a Priest
.goto 1171,50.39,70.36
.target Pendi Cranklefuse
.target Birch Tomlin
step
#completewith next
.goto 1171,40.22,71.90,15,0
.goto 1171,44.51,88.32,15 >>Exit |cRXP_WARN_the cave|r
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Recruit Brutis|r and |cRXP_FRIENDLY_Drogrin Alewhisker|r
.turnin 49234 >>Turn in A Marine Out of Water
.goto 895,62.82,29.88
.turnin 49229 >>Turn in The Ruins Fought Back
.goto 895,62.73,29.95
.target Recruit Brutis
.target Drogrin Alewhisker
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Abbey Watkins|r and |cRXP_FRIENDLY_Harold Beckett|r
.turnin 48070 >>Turn in The Norwington Festival
.accept 48077 >>Accept The Stoat Hunt
.goto 895,55.45,24.67
.accept 48080 >>Accept An Element of Danger
.accept 48616 >>Accept Bolas and Birds
.goto 895,55.52,24.59
.target Abbey Watkins
.target Harold Beckett
step
#completewith Mudbrush
>>Use the |T135553:0|t[Bola Launcher] on |cRXP_ENEMY_Hollowbeak Falcons|r
.use 152643
.complete 48616,1 
.mob Hollowbeak Falcon
step
#completewith Mudbrush
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Stoat Den|r and kill |cRXP_ENEMY_Faintstep Stoat|r loot them for |T1029741:0|t|cRXP_LOOT_[Soft Stoat Pelt]|r
.complete 48077,1 
.mob Faintstep Stoat
step
#completewith Mudbrush
>>Kill |cRXP_ENEMY_Mudbrush Boar|r and loot them for |T133722:0|t|cRXP_LOOT_Rugged Boar Tusk|r
.complete 48080,1 
.mob Mudbrush Boar
step
.goto 895,56.26,23.88,15,0
.goto 895,56.9,23.44,10,0
.goto 895,56.31,25.08,10,0
.goto 895,56.19,26.51,10,0
.goto 895,58.03,27.5,10,0
.goto 895,58.3,25.4
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Caleb Batharen|r
.accept 48965 >>Accept Settle the Score
.target Caleb Batharen
step
.isOnQuest 48965
.goto 895,61.18,22.09 >> Enter the |cFFfa9602Cave|r
step
.goto 895,61.67,22.73
>>Kill |cRXP_ENEMY_Chartusk|r
.complete 48965,1 
step
#label Mudbrush
.goto 895,58.29,25.41
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Caleb Batharen|r
.turnin 48965 >>Turn in Settle the Score
.target Caleb Batharen
step
#completewith next
>>Use the |T135553:0|t[Bola Launcher] on |cRXP_ENEMY_Hollowbeak Falcons|r
.complete 48616,1 
.mob Hollowbeak Falcon
.use 152643
step
.goto 895,58.03,27.5,10,0
.goto 895,56.19,26.51,10,0
.goto 895,56.31,25.08,10,0
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Stoat Den|r and kill |cRXP_ENEMY_Faintstep Stoat|r loot them for |T1029741:0|t|cRXP_LOOT_[Soft Stoat Pelt]|r
.complete 48077,1 
.mob Faintstep Stoat
step
.goto 895,58.03,27.5,10,0
.goto 895,56.19,26.51,10,0
.goto 895,56.31,25.08,10,0
>>Use the |T135553:0|t[Bola Launcher] on |cRXP_ENEMY_Hollowbeak Falcons|r
.complete 48616,1 
.use 152643
.mob Hollowbeak Falcon
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Harold Beckett|r, |cRXP_FRIENDLY_Abbey Watkins|r and |cRXP_FRIENDLY_Melissa Kenny|r
.turnin 48616 >>Turn in Bolas and Birds
.turnin 48080 >>Turn in An Element of Danger
.goto 895,55.52,24.59
.turnin 48077,1 >>Turn in The Stoat Hunt
.goto 895,55.45,24.66
.accept 48670 >>Accept Runaway Rider
.goto 895,55.59,24.6
.target Harold Beckett
.target Abbey Watkins
.target Melissa Kenny
step
.goto 895,54.47,19.39
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Melissa Kenny|r
.turnin 48670 >>Turn in Runaway Rider
.accept 48196 >>Accept Following Eddie's Trail
.accept 48195 >>Accept Troublesome Troglodytes
.target Melissa Kenny
step
#completewith Stone Soup
>>Kill |cRXP_ENEMY_Grimestone Bullies|r and |cRXP_ENEMY_Grimestone Thrower|r
.complete 48195,1 
.complete 48195,2 
.mob Grimestone Bully
.mob Grimestone Thrower
step
.goto 895,56.09,17.95
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Hotshot's corpse|r
.complete 48196,1 
step
.goto 895,56.17,17.96
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Recipe Rock|r
>>|cRXP_WARN_Ideally accept this quest before killing the |cRXP_ENEMY_Grimestone Chefs|r|r
.accept 48778 >>Accept Stone Soup
step
#completewith Stone Soup
>>Kill |cRXP_ENEMY_Grimestone Chefs|r and loot them for |T237350:0|t|cRXP_LOOT_[Unidentifiable Meat]|r
.complete 48778,2 
.mob Grimestone Chef
step
.goto 895,56.15,17.99
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Soup Stone|r
.complete 48778,1,1 
step
.goto 895,55.95,17.51
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with the |cRXP_FRIENDLY_Trapped Saurolisk|r
.accept 48597 >>Accept Saurolisk Escape
.target Trapped Saurolisk
step
.goto 895,56.38,17.79
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Post|r to free |cRXP_FRIENDLY_Trapped Saurolisk|r
.complete 48597,1,1 
.target Trapped Saurolisk
step
.goto 895,56.44,16.72
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Soup Stone|r
.complete 48778,1,2 
step
.goto 895,56.47,16.67
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Post|r to free |cRXP_FRIENDLY_Trapped Saurolisk|r
.complete 48597,1,2 
.target Trapped Saurolisk
step
.goto 895,56.22,16.14
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Bag of Horse Treats|r
.complete 48196,2 
step
.goto 895,56.03,15.3
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Soup Stone|r
.complete 48778,1,3 
step
.goto 895,55.88,14.45
>>Kill |cRXP_ENEMY_Boneface the Giant|r and loot him for |T135233:0|t|cRXP_LOOT_Boneface's "Key"|r
.complete 48196,3 
.mob Boneface the Giant
step
.goto 895,55.89,14.47
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Post|r to free |cRXP_FRIENDLY_Trapped Saurolisk|r
.complete 48597,1,3 
.target Trapped Saurolisk
step
.goto 895,55.62,14.58
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Trogg Cage|r to free |cRXP_FRIENDLY_Eddie Norwington|r
.complete 48196,4 
.target Eddie Norwingto
step
.goto 895,55.61,14.57
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eddie Norwington|r
.turnin 48196 >>Turn in Following Eddie's Trail
.target Eddie Norwington
step
.goto 895,55.99,15.36,5,0
.goto 895,56.87,15.1
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Soup Stone|r
.complete 48778,1,4 
step
#completewith Stone Soup
>>Kill |cRXP_ENEMY_Grimestone Handlers|r and loot them for |T1526620:0|t|cRXP_LOOT_[Saurolisk Scale]|r
.complete 48778,3 
.mob Grimestone Handlers
step
.goto 895,58.07,14.57
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Stirring Bone|r
.complete 48778,4 
step
.goto 895,58.32,14.43
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Post|r to free |cRXP_FRIENDLY_Trapped Saurolisk|r
.complete 48597,1,4 
.target Trapped Saurolisk
step
.goto 895,58.44,15.27
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Post|r to free |cRXP_FRIENDLY_Trapped Saurolisk|r
.complete 48597,1,5 
.target Trapped Saurolisk
step
#label Stone Soup
.goto 895,58.18,15.63
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Post|r to free |cRXP_FRIENDLY_Trapped Saurolisk|r
.complete 48597,1,6 
.target Trapped Saurolisk
step
#completewith Bullies
>>Kill |cRXP_ENEMY_Grimestone Handlers|r and loot them for |T1526620:0|t|cRXP_LOOT_[Saurolisk Scale]|r
.complete 48778,3 
.mob Grimestone Handler
step
#completewith Bullies
>>Kill |cRXP_ENEMY_Grimestone Chefs|r and loot them for |T237350:0|t|cRXP_LOOT_[Unidentifiable Meat]|r
.complete 48778,2 
.mob Grimestone Chef
step
.goto 895,56.56,15.55
#label Bullies
>>Kill |cRXP_ENEMY_Grimestone Bullies|r and |cRXP_ENEMY_Grimestone Thrower|r
.complete 48195,1 
.complete 48195,2 
.mob Grimestone Bully
.mob Grimestone Thrower
step
#completewith next
>>Kill |cRXP_ENEMY_Grimestone Handlers|r and loot them for |T1526620:0|t|cRXP_LOOT_[Saurolisk Scale]|r
.goto 895,58.07,14.57
.complete 48778,3 
.mob Grimestone Handler
step
.goto 895,56.56,15.55
>>Kill |cRXP_ENEMY_Grimestone Chefs|r and loot them for |T237350:0|t|cRXP_LOOT_[Unidentifiable Meat]|r
.complete 48778,2 
.mob Grimestone Chef
step
.goto 895,56.56,15.55
>>Kill |cRXP_ENEMY_Grimestone Handlers|r and loot them for |T1526620:0|t|cRXP_LOOT_[Saurolisk Scale]|r
.complete 48778,3 
.mob Grimestone Handler
step
.goto 895,56.56,15.55
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Bubbling Cauldron|r
.turnin 48778 >>Turn in Stone Soup
step
.goto 895,54.47,19.39
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Melissa Kenny|r
.turnin 48195 >>Turn in Troublesome Troglodytes
.turnin 48597 >>Turn in Saurolisk Escape
.accept 48003 >>Accept The Lord's Behest
.target Melissa Kenny
step
.goto 895,51.57,27.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Aldrius Norwington|r
.turnin 48003 >>Turn in The Lord's Behest
.accept 48005 >>Accept Be Our Guest
.target Lord Aldrius Norwington
step
.goto 895,51.57,27.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Aldrius Norwington|r
.turnin 48003 >>Turn in The Lord's Behest
.accept 48005 >>Accept Be Our Guest
.target Lord Aldrius Norwington
step
.goto 895,51.45,26.10
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dolan Northfield|r
.target Dolan Northfield
.complete 48005,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Joma|r and |cRXP_FRIENDLY_Majo|r
.accept 48898 >>Accept Lucky Charm
.accept 48902 >>Accept Monstrous Energy
.goto 895,51.31,25.90
.accept 48899 >>Accept Safety First
.goto 895,51.29,25.87
.target Joma
.target Majo
step
.goto 895,49.74,25.22
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Arthur Seville|r
.complete 48005,2 
.target Arthur Seville
step
#completewith next
.goto 895,49.74,25.22
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Arthur Seville|r
.vendor 126600 >> |cRXP_WARN_Empty bags/restock on food and water at Arthur Seville if necessary|r
.target Arthur Seville
step
.goto 895,48.7,28.1
>>Stand on the arrow to make |cRXP_ENEMY_Lucktail|r spawn |cRXP_WARN_and damage it to 60%|r
.complete 48898,1 
.mob Lucktail
step
.goto 895,48.12,25.43
>>Follow the arrow and damage |cRXP_ENEMY_Lucktail|r to 30%
.complete 48898,2 
.mob Lucktail
step
#completewith LucktailWaterfall
>>Kill |cRXP_ENEMY_Venomscale Slitherer|r and loot them for |cRXP_LOOT_Pulsating Extract|r
*|cRXP_WARN_Kill every |cRXP_ENEMY_Venomscale Slitherer|r that you see in close proximity.|r
.complete 48902,1 
.mob Venomscale Slitherer
step
.goto 895,48.56,24.91
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Durable Seashell|r |cFFfa9602on the ground.|r
.complete 48899,1,1 
step
.goto 895,48.58,23.57
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Durable Seashell|r |cFFfa9602on the ground.|r
.complete 48899,1,2 
step
.goto 895,49.1,23.66
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Durable Seashell|r |cFFfa9602on the ground.|r
.complete 48899,1,3 
step
.goto 895,49.51,22.55
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Durable Seashell|r |cFFfa9602on the ground.|r
.complete 48899,1,4 
step
.goto 895,49.42,22.02
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Durable Seashell|r |cFFfa9602on the ground.|r
.complete 48899,1,5 
step
.goto 895,49.67,22.37
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Durable Seashell|r |cFFfa9602on the ground.|r
.complete 48899,1,6 
step
.goto 895,49.67,22.37
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Durable Seashell|r |cFFfa9602on the ground.|r
.complete 48899,1,7 
step
.goto 895,50.18,22.51
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Durable Seashell|r |cFFfa9602on the ground.|r
.complete 48899,1,8 
step
.goto 895,50.7,22.19
#label LucktailWaterfall
>>Kill |cRXP_ENEMY_Lucktail|r and loot him for |cRXP_LOOT_Lucktail's Tail|r
.complete 48898,3 
.mob Lucktail
step
.goto 895,47.63,23.92,15,0
.goto 895,50.7,22.19
>>Kill |cRXP_ENEMY_Venomscale Slitherer|r and loot them for |cRXP_LOOT_Pulsating Extract|r
.complete 48902,1 
.mob Venomscale Slitherer
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Joma|r and |cRXP_FRIENDLY_Majo|r
.turnin 48898 >>Turn in Lucky Charm
.turnin 48902 >>Turn in Monstrous Energy
.goto 895,51.32,25.90
.turnin 48899 >>Turn in Safety First
.accept 48903 >>Accept The Perfect Horse, of Course
.goto 895,51.28,25.87
.timer 27, Majo RP
.target Majo
.target Joma
step
#completewith
>>|cRXP_WARN_Hurry! If you move quickly, you can complete a few objectives before Majo reaches the stable.|r
.complete 48903,1 
.target Majo
step
#completewith next
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hestia Strongbolt|r
.fp >>Get the Norwington Estate Flight Path
.target Hestia Strongbolt
step
.goto 895,53.10,28.36
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Wanted Posters|r
.accept 48347 >>Accept Anglepoint Wharf
.accept 51367 >>Accept WANTED: Raging Earthguard
step
.goto 895,53.31,28.29
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Terry Rigglesmith|r |cFFfa9602inside the small house.|r
.complete 48005,4 
.target Terry Rigglesmith
step
.goto 895,53.48,28.75
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_George Mitchell|r |cFFfa9602outside the small house.|r
.complete 48005,3 
.target George Mitchell
step
.goto 895,51.68,25.67
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Goldie|r
.complete 48903,2 
.timer 5, Horse RP
.target Goldie
step
.goto 895,51.79,25.83
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Scout|r
.complete 48903,3 
.timer 5, Horse RP
.target Scout
step
.goto 895,51.87,25.98
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Avalon|r
.complete 48903,4 
.timer 5, Horse RP
.target Avalon
step
.goto 895,51.83,26.31
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Maxwell|r
.complete 48903,5 
.target Maxwell
step
.goto 895,51.81,26.14
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Majo|r
.complete 48903,6 
.target Majo
step
.goto 895,51.81,26.36
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Joma|r
.turnin 48903,1 >>Turn in The Perfect Horse, of Course
.target Joma
step
.goto 895,51.65,26.21
.vehicle >> Interact with |cRXP_FRIENDLY_Cooper|r
.target Cooper
.isOnQuest 48005
step
.goto 895,51.57,27.27
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Aldrius Norwington|r
.turnin 48005 >>Turn in Be Our Guest
.accept 48004 >>Accept Beginner Equitation
.target Lord Aldrius Norwington
step
.goto 895,51.41,26.86
>>Use |T132226:0|t(1)[Rapid Dash] |cRXP_WARN_to sprint|r and |T1661331:0|t(2)[Harpoon Jab] |cRXP_WARN_to jab gnolls.|r|
.complete 48004,2,1 
step
.goto 895,51.1,26.79
>>Use |T132226:0|t(1)[Rapid Dash] |cRXP_WARN_to sprint|r and |T1661331:0|t(2)[Harpoon Jab] |cRXP_WARN_to jab gnolls.|r|
.complete 48004,2,2 
step
.goto 895,50.8,26.66
>>Use |T132226:0|t(1)[Rapid Dash] |cRXP_WARN_to sprint|r and |T1661331:0|t(2)[Harpoon Jab] |cRXP_WARN_to jab gnolls.|r|
.complete 48004,2,3 
step
.goto 895,51.08,26.33
>>Use |T132226:0|t(1)[Rapid Dash] |cRXP_WARN_to sprint|r and |T1661331:0|t(2)[Harpoon Jab] |cRXP_WARN_to jab gnolls.|r|
.complete 48004,2,4 
step
.goto 895,51.41,26.87
>>Use |T132226:0|t(1)[Rapid Dash] |cRXP_WARN_to sprint|r and |T1661331:0|t(2)[Harpoon Jab] |cRXP_WARN_to jab gnolls.|r|
.complete 48004,2,5 
step
.goto 895,51.1,26.79
>>Use |T132226:0|t(1)[Rapid Dash] |cRXP_WARN_to sprint|r and |T1661331:0|t(2)[Harpoon Jab] |cRXP_WARN_to jab gnolls.|r|
.complete 48004,2,6 
step
#loop
.line 895,51.6,26.92,50.94,27.92,50.33,27.04,50.99,25.99,51.27,26.44
.goto 895,51.60,26.92,15,0
.goto 895,50.94,27.92,15,0
.goto 895,50.33,27.04,15,0
.goto 895,50.99,25.99,15,0
.goto 895,51.27,26.44,15,0
>>|cRXP_WARN_Target|r |cRXP_FRIENDLY_Paper Zeppelins|r and |cRXP_WARN_throw |T1661331:0|t(3)[Bolas] at them.|r
>>Use |T132226:0|t(1)[Rapid Dash] |cRXP_WARN_to sprint|r
.complete 48004,3 
.target Paper Zeppelin
step
.goto 895,50.9,26.81
>>|cRXP_WARN_You only have to jump near/along the fences, not necessarily OVER the fences.|r
>>Use |T132226:0|t(1)[Rapid Dash] |cRXP_WARN_to sprint|r
.complete 48004,4 
step
.goto 895,51.57,27.27
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Aldrius Norwington|r
.turnin 48004 >>Turn in Beginner Equitation
.accept 48087 >>Accept Equine Retrieval
.accept 48939 >>Accept Show Me What You've Got
.target Lord Aldrius Norwington
step
#completewith next
#title Challenge Explanation
+|cFFFF0000Read before proceeding;|r
+Initially, use |T132226:0|t(1)[Rapid Dash] |cRXP_WARN_to sprint and build stacks via fence jumps. Upon reaching 15 stacks, prioritize destroying Zeppelins with "Bolas" and jabbing Gnolls, while maintaining the buff by renewing it every 5 seconds.|r Keep "Rapid Dash" active for efficiency.
.isOnQuest 48939
step
.goto 895,51.52,27.03,5 >> |cRXP_WARN_Once you arrive at your destination, a timer will start. You'll have just 60 seconds to finish your challenge.|r
.timer 66, Challenge Time
.isOnQuest 48939
step
#loop
.line 895,51.61,26.92,50.94,27.9,50.33,27.05,50.99,26.02
.goto 895,51.61,26.92,10,0
.goto 895,50.94,27.90,10,0
.goto 895,50.33,27.05,10,0
.goto 895,50.99,26.02,10,0
>>Initially, use |T132226:0|t(1)[Rapid Dash] |cRXP_WARN_to sprint and build stacks via fence jumps. Upon reaching 15 stacks, prioritize destroying Zeppelins with "Bolas" and jabbing Gnolls, while maintaining the buff by renewing it every 5 seconds.|r Keep "Rapid Dash" active for efficiency.
.complete 48939,2
step
.goto 895,51.57,27.28
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Aldruis Norwington|r
.turnin 48939 >>Turn Show Me What You've Got
.target Lord Aldruis Norwington
step
.goto 895,52.57,28.72
.exitvehicle >> |cRXP_WARN_Dismount Cooper by pressing the |r[Exit] |cRXP_WARN_button on your action bars.|r
*|cRXP_WARN_Alternatively, you can use this macro;|r
.link /leavevehicle>> CLICK HERE FOR MACRO.
*|cRXP_WARN_It's recommended to safe this macro for future use.|r
step
.goto 895,53.16,30.7
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Rose|r
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic.|r
.complete 48087,1 
.target Rose
step
.goto 895,52.54,28.50
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Aldrius Norwington|r
.complete 48087,2 
.target Lord Aldrius Norwington
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Aldrius Norwington|r and |cRXP_FRIENDLY_Gora Layton|r
.turnin 48087 >>Turn in Equine Retrieval
.accept 48088 >>Accept No Party Like a Trogg Party
.goto 895,52.54,28.50
.accept 48089 >>Accept Mountain Sounds
.goto 895,52.48,28.55
.target Lord Aldrius Norwington
.target Gora Layton
step
#completewith Grimestone Intruders
>>Kill |cRXP_ENEMY_Grimestone intruders|r
.complete 48088,1 
.mob Grimestone Invader
step
.goto 895,52.5,28.52
>>Use |T134228:0|t[Battlehorn of the Mountain] |cRXP_WARN_near Kul Tirans|r
>>|cRXP_WARN_Don't mount |cRXP_FRIENDLY_Cooper|r as you will be faster without him.|r
.complete 48089,1,3 
.use 153357
step
#label Grimestone Intruders
.goto 895,51.61,29.59,15,0
.goto 895,51.01,28.48,15,0
.goto 895,50.96,27.04,15,0
.goto 895,51.63,25.97,15,0
.goto 895,53.06,28.64
>>Use |T134228:0|t[Battlehorn of the Mountain] to rally nearby Kul Tirans.
>>|cRXP_WARN_Don't mount |cRXP_FRIENDLY_Cooper|r as you will be faster without him.|r
.use 153357
.complete 48089,1 
step
#loop
.line 895,51.61,29.59,51.01,28.48,50.96,27.04,51.63,25.97,53.06,28.64
.goto 895,51.61,29.59,20,0
.goto 895,51.01,28.48,20,0
.goto 895,50.96,27.04,20,0
.goto 895,51.63,25.97,20,0
.goto 895,53.06,28.64,20,0
>>Kill |cRXP_ENEMY_Grimestone intruders|r
.complete 48088,1 
.mob Grimestone intruders
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gora Layton|r and |cRXP_FRIENDLY_Lord Aldrius Norwington.|r
.turnin 48088 >>Turn in No Party Like a Trogg Party
.goto 895,52.54,28.46
.turnin 48089 >>Turn in Mountain Sounds
.goto 895,52.49,28.55
.target Lord Aldrius Norwington
.target Gora Layton
step
.goto 895,51.67,29.66
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Job Flyer|r
.accept 49393 >>Accept The Roughnecks
step
.goto 895,47.26,32.37
>>Kill the |cRXP_ENEMY_Raging Earthguard|r |cRXP_WARN_However, if it proves too challenging, feel free to skip it.|r
.complete 51367,1 
.mob Raging Earthguard
step
.goto 895,49.56,30.20,15,0
.goto 895,49.46,31.27
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thomas Pinker|r
.accept 50026 >>Accept Save Our Shipmates
step
.goto 895,50.31,37.23
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Henry Hardwick|r
.turnin 50026 >>Turn in Save Our Shipmates
.accept 47755 >>Accept Captured and Enraptured
.accept 50002 >>Accept A Very Precious Cargo
.target Henry Hardwick
step
#completewith Joe
.use 151135 >>|T133700:0|tUse [Stein of Grog] on |cRXP_ENEMY_Enthralled Sailors.|r
.complete 47755,1 
.mob Enthralled Sailor
step
.goto 895,51.11,35.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Earless Joe|r
.accept 50059 >>Accept Can't Hear A Thing
.target Earless Joe
step
#label Anthemusa
.line 895,51.11,35.80,52.07,35.62,52.81,34.62,53.89,33.72,53.64,32.66
.goto 895,53.7,32.8,15,0
.goto 895,52.07,35.62,15,0
.goto 895,52.81,34.62,15,0
.goto 895,53.89,33.72,15,0
.goto 895,53.64,32.66
>>Kill |cRXP_ENEMY_Anthemusa|r
.complete 50059,1 
.mob Anthemusa
.use 151135
step
.goto 895,55.49,35.93
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Penny "Precious" Hardwick|r
.turnin 50002 >>Turn in A Very Precious Cargo
.target Penny "Precious" Hardwick
step
.line 895,55.49,35.94,53.87,35.19,51.59,35.02,51.11,35.8
.goto 895,53.87,35.19,15,0
.goto 895,51.59,35.02,15,0
.goto 895,51.11,35.8
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Earless Joe|r
.turnin 50059 >>Turn in Can't Hear A Thing
.target Earless Joe
step
.goto 895,50.31,37.23
.use 151135 >>|T133700:0|tUse [Stein of Grog] on |cRXP_ENEMY_Enthralled Sailors.|r
.complete 47755,1 
.mob Enthralled Sailor
step <<skip
#loop
.line 895,54.77,34.77,53.87,35.19,52.79,35.29,51.49,36.72,51.11,35.8,51.59,35.02,53.95,33.82,54.77,34.77
.goto 895,54.77,34.77,15,0
.goto 895,53.87,35.19,15,0
.goto 895,52.79,35.29,15,0
.goto 895,51.49,36.72,15,0
.goto 895,51.11,35.80,15,0
.goto 895,51.59,35.02,15,0
.goto 895,53.95,33.82,15,0
.goto 895,54.77,34.77,15,0
>>Finish killing Alluring Sirens and Lichenjaw Saurolisks. Click on the Shipwrecked Supplies and Siren Wind Chimes
.complete 50009,1 
step
.goto 895,50.31,37.23
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Henry Hardwick|r
.turnin 47755 >>Turn in Captured and Enraptured
.target Henry Hardwick
step
.goto 895,51.65,26.21
.vehicle >> Interact with |cRXP_FRIENDLY_Cooper|r
.target Cooper
.isOnQuest 51367
step
.goto 895,51.57,27.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Aldrius Norwington|r
.turnin 51367 >>Turn in WANTED: Raging Earthguard
.accept 49036 >>Accept Best In Show
.target Lord Aldrius Norwington
step
#completewith next
#title Challenge Explanation 2
+|cFFFF0000Read before proceeding;It's harder than before.|r
+Initially, use |T132226:0|t(1)[Rapid Dash] |cRXP_WARN_to sprint and build stacks via fence jumps. Upon reaching 15 stacks, prioritize destroying Zeppelins with "Bolas" and jabbing Gnolls, while maintaining the buff by renewing it every 5 seconds.|r Keep "Rapid Dash" active for efficiency.
.isOnQuest 49036
step
.goto 895,51.52,27.03,5 >> |cRXP_WARN_Once you arrive at your destination, a timer will start. You'll have just 60 seconds to finish your challenge.|r
.timer 66, Challenge Time
.isOnQuest 49036
step
#loop
.line 895,51.61,26.92,50.94,27.9,50.33,27.05,50.99,26.02
.goto 895,51.61,26.92,10,0
.goto 895,50.94,27.90,10,0
.goto 895,50.33,27.05,10,0
.goto 895,50.99,26.02,10,0
>>Initially, use |T132226:0|t(1)[Rapid Dash] |cRXP_WARN_to sprint and build stacks via fence jumps. Upon reaching 15 stacks, prioritize destroying Zeppelins with "Bolas" and jabbing Gnolls, while maintaining the buff by renewing it every 5 seconds.|r Keep "Rapid Dash" active for efficiency.
.complete 49036,2
step
.goto 895,51.57,27.28
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Aldruis Norwington|r
.turnin 49036 >>Turn in Best In Show
.target Lord Aldruis Norwington
step
.goto 895,52.57,28.72
.exitvehicle >> |cRXP_WARN_Dismount Cooper by pressing the |r[Exit] |cRXP_WARN_button on your action bars.|r
*|cRXP_WARN_Alternatively, you can use this macro;|r
.link /leavevehicle>> CLICK HERE FOR MACRO.
*|cRXP_WARN_It's recommended to safe this macro for future use.|r
step
#completewith next
.goto 895,42.48,23.01
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dagin|r
.fp >>Get the Roughneck Camp Flight Path
.target Dagin
step
.goto 895,42.16,22.99
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Wanted Poster|r
.accept 51368 >>Accept WANTED: The Hornet
step
#label HelloTagart
.goto 895,42.36,22.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tagart|r
.turnin 49393 >>Turn in The Roughnecks
.accept 49394 >>Accept Hold Still
.accept 49395 >>Accept The Bears and the Bees
.target Tagart
step
#completewith HelpingHenry
>>Use |T135649:0|t[Goat Shears] on |cRXP_ENEMY_Gentle Goats.|r
>>|cRXP_WARN_Goats may become hostile|r*.
.complete 49394,1 
.use 153596
.target Gentle Goat
step
#completewith HelpingHenry
>>Kill |cRXP_ENEMY_Scruffhide Bears|r
.complete 49395,2 
.mob Scruffhide Bear
step
.goto 895,45.39,20.32
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sticky Bee Honey|r
.complete 49395,1,1 
step
.goto 895,45.94,20.55
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sticky Bee Honey|r
.complete 49395,1,2 
step
.goto 895,46.49,19.59
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sticky Bee Honey|r
.complete 49395,1,3 
step
.goto 895,47.44,19.38
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sticky Bee Honey|r
.complete 49395,1,4 
step
.goto 895,47.1,18.7
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sticky Bee Honey|r
.complete 49395,1,5 
step
.goto 895,47.46,18.22,10,0
.goto 895,47.11,18.2
>>Kill the |cRXP_ENEMY_Hornet|r |cFFfa9602inside the cave|r|cRXP_WARN_If this quest can be very difficult; feel free to skip it|r
.complete 51368,1 
.mob The Hornet
step
.goto 895,47.44,18.04
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sticky Bee Honey|r
.complete 49395,1,6 
step
.goto 895,47.7,17.63
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_"Helpless" Henry|r
.accept 49412 >>Accept Helping Henry
.target "Helpless" Henry
step
.goto 895,48.18,18.11
>>Kill |cRXP_ENEMY_Brawr|r
.complete -49412,1 
.mob Brawr
step
#label HelpingHenry
.goto 895,47.68,17.68
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_"Helpless" Henry|r
.turnin -49412 >>Turn in Helping Henry
.target "Helpless" Henry
step
#completewith next
>>Use |T135649:0|t[Goat Shears] on |cRXP_ENEMY_Gentle Goats.|r
>>|cRXP_WARN_Goats may become hostile when shearing them|r.
.complete 49394,1 
.use 153596
.target Gentle Goat
step
.goto 895,42.36,22.27
>>Kill |cRXP_ENEMY_Scruffhide Bears|r
.complete 49395,2 
.mob Scruffhide Bear
step
.goto 895,42.36,22.27
>>Use |T135649:0|t[Goat Shears] on |cRXP_ENEMY_Gentle Goats.|r
>>|cRXP_WARN_Goats may become hostile when shearing them|r.
.complete 49394,1 
.use 153596
.target Gentle Goat
step
.goto 895,42.36,22.27
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jagart|r
.turnin 51368 >>Turn in WANTED: The Hornet
.turnin 49394 >>Turn in Hold Still
.turnin 49395 >>Turn in The Bears and the Bees
.isQuestComplete 51368
.target Jagart
step
.goto 895,42.36,22.27
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jagart|r
.turnin 49394 >>Turn in Hold Still
.turnin 49395 >>Turn in The Bears and the Bees
.target Jagart
step
#completewith HelloAgainTagart
.abandon 51368 >>Abandon WANTED: The Hornet
.isOnQuest 51368
step
.goto 895,42.49,22.71
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rulf|r
.accept 49735 >>Accept Protect the Nests
.accept 49710 >>Accept An Offering of Eggs
.target Rulf
step
#completewith Spotted Gryphon Egg
>>Kill |cRXP_ENEMY_Hungry Dewscales|r
.complete 49735,1 
.mob Hungry Dewscale
step
.goto 895,44.76,20.21
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_FRIENDLY_Spotted Gryphon Egg|r
.complete 49710,1,1 
step
.goto 895,45.87,18.48
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_FRIENDLY_Spotted Gryphon Egg|r
.complete 49710,1,2 
step
.goto 895,46.38,18.25
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_FRIENDLY_Spotted Gryphon Egg|r
.complete 49710,1,3 
step
#label Spotted Gryphon Egg
.goto 895,46.38,18.25
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_FRIENDLY_Spotted Gryphon Egg|r
.complete 49710,1.4 
step
.goto 895,47.94,16.47
>>Kill |cRXP_ENEMY_Hungry Dewscales|r
.complete 49735,1 
.mob Hungry Dewscales
step
.goto 895,47.94,16.47
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Gryphon Nest|r
.turnin 49710 >>Turn in An Offering of Eggs
step
.goto 895,47.85,16.39
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Shawn McClinter|r
.turnin 49735 >>Turn in Protect the Nests
.accept 49417 >>Accept Roughneck Riders
.target Shawn McClinter
step
.goto 895,47.91,18.53
>>Use |T1373906:0|t[Tether Shot] on |cRXP_FRIENDLY_Greatfeather|r
>>|cRXP_WARN_Use [1],[2],[3] on cooldown.|r
.complete 49417,1 
.use 153679
.target Greatfeather
step
#label HelloAgainTagart
.goto 895,42.36,22.27
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_cTagart|r
.turnin 49417,1 >>Turn in Roughneck Riders
.accept 49418 >>Accept Big Boss
.target Tagart
step
.goto 895,41.99,16.76
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Boss Tak|r
.turnin 49418 >>Turn in Big Boss
.accept 49433 >>Accept Wendies
.accept 49435 >>Accept Where'd They Go?
.target Boss Tak
step
.goto 895,42.27,15.49
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Bloodied Boot|r
.complete 49435,1 
step
#completewith next
>>Kill |cRXP_ENEMY_Savage Wendigos|r
.complete 49433,1 
.mob Savage Wendigo
step
.goto 895,43.68,15.24
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_"Helpless" Henry|r
.accept 49419 >>Accept Frozen
.target "Helpless" Henry
step
.goto 895,43.73,14.66
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Roughneck Supplies|r |cFFfa9602by the Supply Cart|r
.complete 49435,2 
step
.goto 895,44.91,15.50
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Griddon|r
.accept 49431 >>Accept Warm and Cozy
.target Griddon
step
#completewith Prince Rathaw
>>Kill |cRXP_LOOT_Steam Elementals|r and loot them for |cRXP_LOOT_Steamy Essence|r.
.complete 49431,1 
step
.goto 895,45.72,14.97
.cast 6478 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Steam Shards|r
.isOnQuest 49431
step
.goto 895,46.77,15.15
.cast 6478 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Steam Shards|r
.isOnQuest 49431
step
.goto 895,46.81,14.72
.cast 6478 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Steam Shards|r
.isOnQuest 49431
step
.goto 895,46.81,13.79
.cast 6478 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Steam Shards|r
.isOnQuest 49431
step
#label Prince Rathaw
.goto 895,48.67,14.62
>>Kill |cRXP_ENEMY_Prince Rathaw|r and loot him for |cRXP_ENEMY_Fiery Essence|r
.complete 49419,1 
.mob Prince Rathaw
step
.goto 895,44.91,15.5
>>Kill |cRXP_LOOT_Steam Elementals|r and loot them for |cRXP_LOOT_Steamy Essence|r.
.complete 49431,1 
step
.goto 895,44.91,15.5
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Griddon|r
.turnin 49431,1 >>Turn in Warm and Cozy
.target Griddon
step
.goto 895,43.68,15.25
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_"Helpless" Harry|r
.target "Helpless" Harry
.turnin 49419 >>Turn in Frozen
step
#completewith Rucksack
>>Kill |cRXP_ENEMY_Savage Wendigos|r
.complete 49433,1 
.mob Savage Wendigo
step
.goto 895,41.58,13.99
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Roughneck Axe|r
.complete 49435,3 
step
.goto 895,39.68,13.35
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Discarded Rucksack|r
.complete 49435,4 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Boss Tak|r |cFFfa9602next to you.|r
.turnin 49435 >>Turn in Where'd They Go?
.accept 49439 >>Accept Boss' Revenge
.target Boss Tak
step
#label Rucksack
.goto 895,39.33,12.37
>>Kill |cRXP_ENEMY_Whompus|r |cFFfa9602in the Cave.|r
.complete 49439,1 
.mob Whompus
step
.goto 895,42.27,15.49
>>Kill |cRXP_ENEMY_Savage Wendigos|r
.complete 49433,1 
.mob Savage Wendigo
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Boss Tak|r |cFFfa9602next to you.|r
.turnin 49433 >>Turn in Wendies
.turnin 49439 >>Turn in Boss' Revenge
.accept 49719 >>Accept Getting Paid
.target Boss Tak
step
.goto 895,42.37,22.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tagart|r
.turnin 49719 >>Turn in Getting Paid
.target Tagart
step
.goto 895,43.74,25.38,20,0
.goto 895,43.71,26.64,20,0
.goto 895,42.28,29.32
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brother Therold|r
.turnin 48347 >>Turn in Anglepoint Wharf
.accept 48540 >>Accept Aiding the Wharf
step
.goto 895,42.28,29.32
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brother Therold|r
.turnin 48347 >>Turn in Anglepoint Wharf
.accept 48540 >>Accept Aiding the Wharf
.target Brother Therold
step
.goto 895,43.23,29.67
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Bundle of Vellum|r on the barrel.
>>|cRXP_WARN_it's very small.|r
.complete 48540,2 
step
.goto 895,41.93,30.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hera Copeland|r
.complete 48540,1 
.skipgossip
.target Hera Copeland
step
.goto 895,41.79,30.04
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Jar of Blubber|r
.complete 48540,3 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brother Therold|r and |cRXP_FRIENDLY_Okri Putterwrench|r
.turnin 48540 >>Turn in Aiding the Wharf
.accept 48352 >>Accept A Cure from the Sea
.accept 49268 >>Accept Sharks in the Water
.goto 895,42.28,29.31
.accept 48348 >>Accept Stinging Barbs
.goto 895,42.19,29.32
.target Brother Therold
.target Okri Putterwrench
step
#completewith Intact Venomous Barb
>>Kill |cRXP_ENEMY_Invading Dreadmaw|r
>>|cRXP_WARN_Run on the seafloor for faster movement.|r
.complete 49268,1 
.mob Invading Dreadmaw
step
#completewith Intact Venomous Barb
>>Kill |cRXP_ENEMY_Barbtail Stingray|r and loot them for |T132274:0|t|cRXP_LOOT_[Intact Venomous Barb]|r
.complete 48348,1 
.mob Barbtail Stingray
step
.goto 895,41.7,29.07
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Seaweed|r on the seafloor.
>>|cRXP_WARN_Kill |cRXP_ENEMY_Invading Dreadmaw|r and |cRXP_ENEMY_Barbtail Stingray|r while picking up the |cRXP_PICK_Seaweed|r|r
.complete 48352,1,1 
step
.goto 895,41.47,28.98
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Seaweed|r on the seafloor.
>>|cRXP_WARN_Kill |cRXP_ENEMY_Invading Dreadmaw|r and |cRXP_ENEMY_Barbtail Stingray|r while picking up the |cRXP_PICK_Seaweed|r|r
.complete 48352,1,2 
step
.goto 895,40.93,28.25
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Seaweed|r on the seafloor.
>>|cRXP_WARN_Kill |cRXP_ENEMY_Invading Dreadmaw|r and |cRXP_ENEMY_Barbtail Stingray|r while picking up the |cRXP_PICK_Seaweed|r|r
.complete 48352,1,3 
step
.goto 895,40.12,28.58
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Seaweed|r on the seafloor.
>>|cRXP_WARN_Kill |cRXP_ENEMY_Invading Dreadmaw|r and |cRXP_ENEMY_Barbtail Stingray|r while picking up the |cRXP_PICK_Seaweed|r|r
.complete 48352,1,4 
step
.goto 895,40.24,29.19
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Seaweed|r on the seafloor.
>>|cRXP_WARN_Kill |cRXP_ENEMY_Invading Dreadmaw|r and |cRXP_ENEMY_Barbtail Stingray|r while picking up the |cRXP_PICK_Seaweed|r|r
.complete 48352,1,5 
step
.goto 895,40.26,29.79
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Seaweed|r on the seafloor.
>>|cRXP_WARN_Kill |cRXP_ENEMY_Invading Dreadmaw|r and |cRXP_ENEMY_Barbtail Stingray|r while picking up the |cRXP_PICK_Seaweed|r|r
.complete 48352,1,6 
step
.goto 895,40.86,29.55
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Seaweed|r on the seafloor.
>>|cRXP_WARN_Kill |cRXP_ENEMY_Invading Dreadmaw|r and |cRXP_ENEMY_Barbtail Stingray|r while picking up the |cRXP_PICK_Seaweed|r|r
.complete 48352,1,7 
step
#label Intact Venomous Barb
.goto 895,41.04,29.46
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Seaweed|r on the seafloor.
>>|cRXP_WARN_Kill |cRXP_ENEMY_Invading Dreadmaw|r and |cRXP_ENEMY_Barbtail Stingray|r while picking up the |cRXP_PICK_Seaweed|r|r
.complete 48352,1,8 
.mob Invading Dreadmaw
.mob Barbtail Stingray
step
#completewith next
>>Kill |cRXP_ENEMY_Invading Dreadmaw|r
>>|cRXP_WARN_Run on the seafloor for faster movement.|r
.complete 49268,1 
.mob Invading Dreadmaw
step
#loop
.line 895,40.58,30.41,40.09,30.9,41.04,31.54,41.78,31.05
.goto 895,40.58,30.41,15,0
.goto 895,40.09,30.90,15,0
.goto 895,41.04,31.54,15,0
.goto 895,41.78,31.05,15,0
>>Kill |cRXP_ENEMY_Barbtail Stingray|r and loot them for |T132274:0|t|cRXP_LOOT_[Intact Venomous Barb]|r
.complete 48348,1 
.mob Barbtail Stingray
step
#loop
.line 895,40.58,30.41,40.09,30.9,41.04,31.54,41.78,31.05
.goto 895,40.58,30.41,15,0
.goto 895,40.09,30.90,15,0
.goto 895,41.04,31.54,15,0
.goto 895,41.78,31.05,15,0
>>Kill |cRXP_ENEMY_Invading Dreadmaw|r
>>|cRXP_WARN_Run on the seafloor for faster movement.|r
.complete 49268,1 
.mob Invading Dreadmaw
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Okri Putterwrench|r and |cRXP_FRIENDLY_Brother Therold|r
.turnin 48348 >>Turn in Stinging Barbs
.goto 895,42.19,29.32
.turnin 48352,2 >>Turn in A Cure from the Sea
.turnin 49268 >>Turn in Sharks in the Water
.accept 49292 >>Accept Algae Shakes
.accept 48353 >>Accept Pulse of the Wharf
.goto 895,42.28,29.31
.target Okri Putterwrench
.target Brother Therold
step
.goto 895,42.61,27.42
>>Interact with |cRXP_FRIENDLY_Nauseated Villager|r to treat him.
>>|cRXP_WARN_Fly away quickly to avoid aggroing the |cRXP_ENEMY_Infectious Gutworm|r after treating |cRXP_FRIENDLY_Nauseated Villager|r |r
.use 153513
.complete 49292,1,1 
.target Nauseated Villager
step
.goto 895,42.30,26.62
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Julian Nichols|r
.complete 48353,1 
.skipgossip
.target Julian Nichols
step
.goto 895,42.24,27.42
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ginger Freelin|r
.complete 48353,2 
.skipgossip
.target Ginger Freelin
step
.goto 895,42.1,27.23
>>Interact with |cRXP_FRIENDLY_Nauseated Villager|r to treat him.
>>|cRXP_WARN_Fly away quickly to avoid aggroing the |cRXP_ENEMY_Infectious Gutworm|r after treating |cRXP_FRIENDLY_Nauseated Villager|r |r
.use 153513
.complete 49292,1,2 
.target Nauseated Villager
step
.goto 895,41.9,27.31
>>Interact with |cRXP_FRIENDLY_Nauseated Villager|r to treat him.
>>|cRXP_WARN_Fly away quickly to avoid aggroing the |cRXP_ENEMY_Infectious Gutworm|r after treating |cRXP_FRIENDLY_Nauseated Villager|r |r
.use 153513
.complete 49292,1,3 
.target Nauseated Villager
step
.isOnQuest 48353
.goto 895,41.68,26.98
.gossipoption 47948 >>Talk to |cRXP_FRIENDLY_Aaron Gutier|r
.timer 9, Time until |cRXP_ENEMY_Aaron Gutier's|r vulnerability.
.target Aaron Gutier
step
.goto 895,41.53,26.5
>>Interact with |cRXP_FRIENDLY_Nauseated Villager|r to treat him.
>>|cRXP_WARN_Fly away quickly to avoid aggroing the |cRXP_ENEMY_Infectious Gutworm|r after treating |cRXP_FRIENDLY_Nauseated Villager|r |r
.use 153513
.complete 49292,1,4 
.target Nauseated Villager
step
.goto 895,41.87,26.68
>>Interact with |cRXP_FRIENDLY_Nauseated Villager|r to treat him.
>>|cRXP_WARN_Fly away quickly to avoid aggroing the |cRXP_ENEMY_Infectious Gutworm|r after treating |cRXP_FRIENDLY_Nauseated Villager|r |r
.use 153513
.complete 49292,1,5 
.target Nauseated Villager
step
.goto 895,41.94,26.81
>>Interact with |cRXP_FRIENDLY_Nauseated Villager|r to treat him.
>>|cRXP_WARN_Fly away quickly to avoid aggroing the |cRXP_ENEMY_Infectious Gutworm|r after treating |cRXP_FRIENDLY_Nauseated Villager|r |r
.use 153513
.complete 49292,1,6 
.target Nauseated Villager
step
.goto 895,41.9,27.3
>>Interact with |cRXP_FRIENDLY_Nauseated Villager|r to treat him.
>>|cRXP_WARN_Fly away quickly to avoid aggroing the |cRXP_ENEMY_Infectious Gutworm|r after treating |cRXP_FRIENDLY_Nauseated Villager|r |r
.use 153513
.complete 49292,1,6 
.target Nauseated Villager
step
.goto 895,41.64,26.96
>>Kill |cRXP_ENEMY_Aaron Gutier|r
.complete 48353,3 
.mob Aaron Gutier
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brother Therold|r
.goto 895,41.29,27.00
.turnin 49292 >>Turn in Algae Shakes
.turnin 48353 >>Turn in Pulse of the Wharf
.accept 48355 >>Accept Evacuate the Premises
.accept 48354 >>Accept Tainted Shipments
.target Brother Therold
step
.goto 895,40.96,26.94
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Barrels of Fish|r
>>|cRXP_WARN_Kill |cRXP_ENEMY_Infesting Brainworm|r|r
.complete 48354,1,1 
.mob Infesting Brainworm
step
.goto 895,40.73,26.93
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Barrels of Fish|r
>>|cRXP_WARN_Kill |cRXP_ENEMY_Infesting Brainworm|r|r
.complete 48354,1,2 
.mob Infesting Brainworm
step
.goto 895,40.73,26.93
>>Use your |cRXP_WARN_[Extra Action Button]|r to evacuate |cRXP_FRIENDLY_Anglepoint Fishpacker|r
.complete 48355,1,2 
.target Anglepoint Fishpackers
step
.goto 895,40.39,26.86
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Barrels of Fish|r
>>|cRXP_WARN_Kill |cRXP_ENEMY_Infesting Brainworm|r|r
.complete 48354,1,3 
.mob Infesting Brainworm
step
.goto 895,40.73,26.93
>>Use your |cRXP_WARN_[Extra Action Button]|r to evacuate |cRXP_FRIENDLY_Anglepoint Fishpacker|r
.complete 48355,1,3 
.target Anglepoint Fishpackers
step
#completewith Barrel of Fish
>>Use your |cRXP_WARN_[Extra Action Button]|r to evacuate |cRXP_WARN_nearby|r |cRXP_FRIENDLY_Anglepoint Fishpacker|r
.complete 48355,1 
.target Anglepoint Fishpackers
step
.goto 895,39.94,27.13
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Barrels of Fish|r
>>|cRXP_WARN_Kill |cRXP_ENEMY_Infesting Brainworm|r|r
.complete 48354,1,4 
.mob Infesting Brainworm
step
#label Barrel of Fish
.goto 895,40.01,26.91
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Barrels of Fish|r
>>|cRXP_WARN_Kill |cRXP_ENEMY_Infesting Brainworm|r|r
.complete 48354,1,5 
.mob Infesting Brainworm
step
.goto 895,40.15,26.68,10,0
.goto 895,39.96,26.4,10,0
.goto 895,39.75,26.56
.goto 895,39.49,26.68
>>Use your |cRXP_WARN_[Extra Action Button]|r to evacuate |cRXP_WARN_nearby|r |cRXP_FRIENDLY_Anglepoint Fishpacker|r
.complete 48355,1 
.target Anglepoint Fishpackers
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brother Therold|r and |cRXP_FRIENDLY_Keegan Alby|r
.turnin 48354 >>Turn in Tainted Shipments
.turnin 48355 >>Turn in Evacuate the Premises
.accept 48356 >>Accept Possessive Headgear
.goto 895,39.49,26.68
.accept 48365 >>Accept The Young Lord Stormsong
.accept 48009 >>Accept Betrayal of the Guard
.goto 895,39.52,26.74
.target Keegan Alby
.target Brother Therold
step
#completewith Overseer Bates
>>Kill |cRXP_ENEMY_Mind-addled Enforcers|r, |cRXP_ENEMY_Possessed Dockworkers|r and |cRXP_ENEMY_Parasitic Mindstealers|r.
.complete 48356,1 
.complete 48009,1 
.mob Possessed Dockworkers
.mob Mind-addled Enforcers
.mob Parasitic Mindstealer
step
.goto 895,37.94,29.58,15,0
.goto 895,37.56,29.53
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Manager Yerold|r inside the building.
.accept 48008 >>Accept Dangerous Cargo
.accept 49299 >>Accept Enemy Within
.target Manager Yerold
step
.goto 895,38.03,29.81
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Barrels|r to burn |cRXP_PICK_Infested Cargo|r
.complete 48008,1,1 
step
.goto 895,39.49,31.67
>>Kill |cRXP_ENEMY_Brother Conway|r
.complete 48365,1 
.mob Brother Conway
step
.goto 895,38.09,30.54
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Barrels|r to burn |cRXP_PICK_Infested Cargo|r
.complete 48008,1,2 
step
.goto 895,37.62,29.69
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Barrels|r to burn |cRXP_PICK_Infested Cargo|r
.complete 48008,1,3
step
.goto 895,37.5,29.74
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Barrels|r to burn |cRXP_PICK_Infested Cargo|r
.complete 48008,1,4 
step
.goto 895,37.27,29.91
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Barrels|r to burn |cRXP_PICK_Infested Cargo|r
.complete 48008,1,5 
step
#label Overseer Bates
.goto 895,37.25,28.83
>>Kill |cRXP_ENEMY_Overseer Bates|r at the top of the stairs.
>>|cRXP_WARN_Sidestep/move away from his Void Swipe|r
.complete 49299,1 
.mob Overseer Bates
step
#loop
.line 895,36.84,30.21,37.38,31.11,38.21,31.79,39.23,31.02,38.87,28.98
.goto 895,36.84,30.21,30,0
.goto 895,37.38,31.11,30,0
.goto 895,38.21,31.79,30,0
.goto 895,39.23,31.02,30,0
.goto 895,38.87,28.98,30,0
>>Kill |cRXP_ENEMY_Mind-addled Enforcers|r, |cRXP_ENEMY_Possessed Dockworkers|r and |cRXP_ENEMY_Parasitic Mindstealers|r.
.complete 48356,1 
.complete 48009,1 
.mob Possessed Dockworkers
.mob Mind-addled Enforcers
.mob Parasitic Mindstealer
step
.goto 895,37.57,29.54
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Manager Yerold|r inside the building.
.turnin 48008 >>Turn in Dangerous Cargo
.turnin 49299,1 >>Turn in Enemy Within
.target Manager Yerold
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brother Therold|r and |cRXP_FRIENDLY_Keegan Alby|r
.turnin 48356 >>Turn in Possessive Headgear
.goto 895,37.98,29.5,8,0
.goto 895,39.50,26.68
.turnin 48009 >>Turn in Betrayal of the Guard
.turnin 48365 >>Turn in The Young Lord Stormsong
.goto 895,39.52,26.74
.target Keegan Alby
.target Brother Therold
step
.goto 895,39.54,26.7
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brannon Stormsong|r
.accept 48366 >>Accept Paddle to Safety
.target Brannon Stormsong
step
.goto 895,39.60,26.96
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Escape Rowboat|r
.complete 48366,1 
.timer 40, Rowboat Time
step
.goto 895,35.20,24.19
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brannon Stormsong|r
.turnin 48366 >>Turn in Paddle to Safety
.accept 48372 >>Accept Eldritch Invocations
.target Brannon Stormsong
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Keegan Alby|r and |cRXP_FRIENDLY_Brother Therold|r
.accept 48370 >>Accept Death in the Depths
.goto 895,35.25,24.17
.accept 48368 >>Accept Deep Sea Defilement
.goto 895,35.24,24.27
.target Keegan Alby
.target Brother Therold
step
.goto 895,34.95,24.21
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rosaline Madison|r
.accept 48367 >>Accept Those Aren't Fish Eggs
.target Rosaline Madison
step
#completewith Western Corrupting Pylon
>>Kill |cRXP_ENEMY_Deepwarden Followers|r and destroy |cRXP_ENEMY_Corrupted Eggs.|r
>>|cRXP_WARN_Run on the Seafloor for increased movement speed.|r
.complete 48367,1 
.complete 48370,1 
.mob Merciless Aberration
.mob K'thir Harbinger
.mob Willing Cultist
.mob Corrupted Egg
step
#completewith next
.isOnQuest 48368
.goto 895,33.86,25.77,15 >> Submerge into the water.
.goto 895,34.99,24.61,10 >> Enter the underwater cave.
step
.goto 895,35.39,24.32
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Pylon|r
.complete 48368,2 
step
#completewith next
.isOnQuest 48368
.goto 895,33.78,25.63,20 >> Leave the underwater cave.
step
#completewith next
.isOnQuest 48368
.isOnQuest 48367
.goto 895,33.9,26.1,15 >> Check for Corrupted Eggs 1
.goto 895,33.17,26.91,15 >> Check for Corrupted Eggs 2
.goto 895,32.25,27.34,15 >> Check for Corrupted Eggs 3
.goto 895,31.87,29.18,15 >> Check for Corrupted Eggs 4
.goto 895,30.84,30.25,20 >> Enter the underwater cave.
step
.goto 895,30.37,31.11
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Pylon|r
.complete 48368,1 
step
#completewith next
.isOnQuest 48367
.isOnQuest 48368
.goto 895,31.35,29.13,20 >> Leave the underwater cave.
.goto 895,32.01,26.68,15 >> Check for Corrupted Eggs 5
.goto 895,32.44,24.65,15 >> Check for Corrupted Eggs 6
.goto 895,32.8,24.01,15 >> Check for Corrupted Eggs 7
.goto 895,32.55,23.52,15 >> Check for Corrupted Eggs 8
.goto 895,31.86,22.69,15 >> Check for Corrupted Eggs 9
.goto 895,31.56,21.88,15 >> Check for Corrupted Eggs 1
.goto 895,30.3,20.17,15 >> Enter the underwater cave.
step
.goto 895,29.99,19.40
>>Kill |cRXP_ENEMY_Director Deepwarden|r
.complete 48372,1 
.mob Director Deepwarden
step
#label Western Corrupting Pylon
.goto 895,30,19.36
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Pylon|r
.complete 48368,3 
.mob Director Deepwarden
step
#loop
.line 895,31.56,21.88,31.86,22.69,32.55,23.52,32.8,24.0,32.44,24.65,32.01,26.68,31.87,29.18,32.25,27.34,33.17,26.9,33.9,26.1
.goto 895,31.56,21.88,20,0
.goto 895,31.86,22.69,20,0
.goto 895,32.55,23.52,20,0
.goto 895,32.80,24.00,20,0
.goto 895,32.44,24.65,20,0
.goto 895,32.01,26.68,20,0
.goto 895,31.87,29.18,20,0
.goto 895,32.25,27.34,20,0
.goto 895,33.17,26.90,20,0
.goto 895,33.90,26.10,20,0
>>Kill |cRXP_ENEMY_Deepwarden Followers|r and destroy |cRXP_ENEMY_Corrupted Eggs.|r
>>|cRXP_WARN_Run on the Seafloor for increased movement speed.|r
.complete 48367,1 
.complete 48370,1 
.mob Merciless Aberration
.mob K'thir Harbinger
.mob Willing Cultist
.mob Corrupted Egg
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brother Therold|r, |cRXP_FRIENDLY_Brannon Stormsong|r and |cRXP_FRIENDLY_Rosaline Madison.|r
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic.|r
.turnin 48368 >>Turn in Deep Sea Defilement
.goto 895,31.02,21.91,30,0
.goto 895,35.23,24.27
.turnin 48370 >>Turn in Death in the Depths
.turnin 48372 >>Turn in Eldritch Invocations
.goto 895,35.2,24.19
.turnin 48367 >>Turn in Those Aren't Fish Eggs
.accept 49302 >>Accept The Deadliest Catch
.goto 895,34.95,24.21
.target Brother Therold
.target Brannon Stormsong
.target Rosaline Madison
step
.hs >> Hearthstone |cFFfa9602to Boralus.|r
.isOnQuest 49302
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#name 8A_Tiragarde Sound Part 2
#displayname Chapter 8 - Tiragarde Sound [2]
#next 9A_Drustvar
<<Alliance
step
.goto 1161,73.52,13.72,5,0
.goto 1161,68.76,21.09,10,0
.goto 1161,67.43,21.39,10,0
.goto 1161,68.16,21.98
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taelia|r
.turnin 46729 >>Turn in The Old Knight
.accept 47186 >>Accept Sanctum of the Sages
.target Taelia
step
.goto 1161,67.99,21.90
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cyrus Crestfall|r
.accept 52128 >>Accept Ferry Pass
.turnin 52128 >>Turn in Ferry Pass
.target Cyrus Crestfall
step
.goto 1161,67.33,22.75,5,0
.goto 1161,67.48,21.11,5,0
.goto 1161,68.96,21.19,5,0
.goto 1161,70.74,16.24
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_7th Legion Magus|r
.complete 47186,1 
.skipgossip
.target 7th Legion Magus
step
.goto 1161,68.76,21.09,10,0
.goto 1161,67.43,21.39,10,0
.goto 1161,68.16,21.98
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taelia|r
.turnin 47186 >>Turn in Sanctum of the Sages
.accept 47189 >>Accept A Nation Divided
.target Taelia
step
.goto 1161,68.38,22.10
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Scouting Map|r, then click Tiragarde Sound and accept the quest.
.complete 47189,1 
.accept 47960 >>Accept Tiragarde Sound
step
.goto 1161,68.17,22.00
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taelia|r
.turnin 47189 >>Turn in A Nation Divided
.turnin 47960 >>Turn in Tiragarde Sound
.target Taelia
step
.goto 1161,68.04,22.18
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Genn Greymane|r
.accept 52654 >>Accept The War Campaign
.target Genn Greymane
step
.goto 1161,67.58,22.20
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flynn Fairwind|r
.accept 47181 >>Accept The Smoking Gun
.target Flynn Fairwind
step
.goto 1161,67.56,22.25
>>Press your |cRXP_WARN_[Extra Action Button]|r
.complete 47181,1 
step
.goto 1161,67.56,22.25
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flynn Fairwind|r
.turnin 47181 >>Turn in The Smoking Gun
.target Flynn Fairwind
step
.goto 1161,67.99,21.9
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cyrus Crestfall|r
.accept 47485 >>Accept The Ashvane Trading Company
.target Cyrus Crestfall
step
.goto 1161,67.09,23.4,10,0
.goto 1161,69.26,26.98
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Halford Wyrmbane|r
.turnin 52654 >>Turn in The War Campaign
.accept 52544 >>Accept The War Cache
.accept 51569 >>Accept The Zandalar Campaign
.target Halford Wyrmbane
step
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Zandalar Campaign table|r, then click Zuldazar and accept the quest
>>|TInterface/cursor/crosshair/interact.blp:20|Click on the Quest Complete pop-up in your Quest Tracker
.goto 1161,69.26,26.98
.accept 51570 >>Accept Foothold: Zuldazar
.turnin 51570 >>Turn in Foothold: Zuldazar
step
>>Select |cRXP_PICK_Zuldazar|r on the Map
.goto 1161,69.26,26.98
.complete 51569,1 
step
.goto 1161,69.26,26.98
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Halford Wyrmbane|r
.target Halford Wyrmbane
.turnin 51569 >>Turn in The Zandalar Campaign
.accept 51308 >>Accept Zuldazar Foothold
step
.goto 1161,69.27,26.98
.gossipoption 49384 >>Talk to |cRXP_FRIENDLY_Halford Wyrmbane|r
.timer 44, Halford Wyrmbane RP
.target Halford Wyrmbane
.isQuestAvailable 52462
step
#sticky
>>|cRXP_WARN_Hurry! If you move quickly, you can complete a few objectives before the roleplay is finished|r
.complete 51308,1 
step <<skip
#completewith next
.goto 1161,74.13,12.66
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wesley Rockhold|r
.target Wesley Rockhold
.home >>Set your Hearthstone to Boralus
step << !KulTiran
.goto 1161,77.18,16.46
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Crenzo Sparkshatter|r
.accept 52462 >>Accept A Load of Scrap
.target Crenzo Sparkshatter
step << !KulTiran
.goto 1161,77.18,16.46
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Scrap-O-Matic 1000.|r
>>|T1698808:0|tInsert the Tattered Pants and press scrap
.complete 52462,1 
step << !KulTiran
.goto 1161,77.18,16.46
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Crenzo Sparkshatter|r
.turnin 52462 >>Turn in A Load of Scrap
.target Crenzo Sparkshatter
step
.goto 1161,74.17,24.78
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Will Melborne|r but **DON'T USE THE FERRY!*
.complete 47485,1 
.target Will Melborne
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hawkmaster Lloyd|r and |cRXP_FRIENDLY_Tallis Skyheart|r |cFFfa9602inside the tent.|r
.accept 51226 >>Accept Death from Two Sides
.goto 895,80.63,42.07
.accept 49733 >>Accept Patching Up the Rear
.goto 895,81.10,42.49
.target Hawkmaster Lloyd
.target Tallis Skyheart
step
#completewith Injured Marine
>>Kill |cRXP_ENEMY_Brinefang Saurolisks|r
.complete 51226,1 
.mob Brinefang Saurolisk
step
.goto 895,80.81,41.48
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Injured Marines|r
.complete 49733,1,1 
.target Injured Marine
step
.goto 895,81.17,41.19
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Injured Marines|r
.complete 49733,1,2 
.target Injured Marine
step
.goto 895,81.85,40.54
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Injured Marines|r
.complete 49733,1,3 
.target Injured Marine
step
.goto 895,82.48,43.82
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Injured Marines|r
.complete 49733,1,4 
.target Injured Marine
step
#labelInjured Marine
.goto 895,82.21,44.06
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Injured Marines|r
.complete 49733,1,5 
.target Injured Marine
step
.goto 895,81.09,42.49
>>Kill |cRXP_ENEMY_Brinefang Saurolisks|r
.complete 51226,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tallis Skyheart|r, |cRXP_FRIENDLY_Officer Jovan|r |cFFfa9602inside the tent.|r and |cRXP_FRIENDLY_Hawkmaster Lloyd|r
.turnin 49733 >>Turn in Patching Up the Rear
.accept 49734 >>Accept Targeting a Turncoat
.accept 49716 >>Accept A Lesson on Trust
.goto 895,81.09,42.49
.turnin 51226 >>Turn in Death from Two Sides
.accept 49720 >>Accept Free Bird
.goto 895,80.62,42.03
.accept 50249 >>Accept A Boralus Triple Threat
.target Hawkmaster Lloyd
.target Tallis Skyheart
.target Officer Jovan
step
#completewith Seahawk freed
>>Kill |cRXP_ENEMY_Hardened Mutineer|r,|cRXP_ENEMY_Mutinous Falconer|r and |cRXP_ENEMY_Mutinous Halberdier|r loot them for |cRXP_LOOT_Marine Identification Badge.|r
.complete 49716,1 
.mob Hardened Mutineer
.mob Mutinous Falconer
.mob Mutinous Halberdier
step
.goto 895,79.95,38.75
>>Kill |cRXP_ENEMY_Fernn the Turncoat.|r
*|cRXP_WARN_Use your Extra Action Button on cooldown.|r
.complete 49734,1 
.mob Fernn the Turncoat
step
.goto 895,80.41,37.63
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Hawk Cage|r
.complete 49720,1,1 
step
.goto 895,80.17,37.13
>>Kill |cRXP_ENEMY_Stablemaster Diana|r
.complete 50249,2 
.mob Stablemaster Diana
step
.goto 895,79.28,36.89
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Hawk Cage|r
.complete 49720,1,2 
step
.goto 895,78.08,36.74
>>Kill |cRXP_PICK_Hayden the Madshot|r
|cRXP_WARN_*Use your Extra Action Button on cooldown.|r
.complete 50249,3 
.mob Hayden the Madshot
step
.goto 895,78.85,38.04
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Hawk Cage|r
.complete 49720,1,3 
step
.goto 895,79.11,37.92
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Hawk Cage|r
.complete 49720,1,4 
step
.goto 895,78.78,38.82
>>Kill |cRXP_ENEMY_Overseer Howling|r
|cRXP_WARN_*Use your Extra Action Button on cooldown.|r
.complete 50249,1 
.mob Overseer Howling
step
#label Seahawk freed
.goto 895,79.49,38.59
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Hawk Cage|r
.complete 49720,1,5 
step
.goto 895,80.17,37.13,10,0
.goto 895,78.08,36.74,10,0
.goto 895,79.49,38.59
>>Kill |cRXP_ENEMY_Hardened Mutineer|r,|cRXP_ENEMY_Mutinous Falconer|r and |cRXP_ENEMY_Mutinous Halberdier|r loot them for |cRXP_LOOT_Marine Identification Badge.|r
.complete 49716,1 
.mob Hardened Mutineer
.mob Mutinous Falconer
.mob Mutinous Halberdier
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hawkmaster Lloyd|r and |cRXP_FRIENDLY_Tallis Skyheart|r |cFFfa9602inside the tent.|r
.turnin 49720 >>Turn in Free Bird
.goto 895,80.62,42.05
.turnin 49734,2 >>Turn in Targeting a Turncoat
.turnin 49716 >>Turn in A Lesson on Trust
.turnin 50249 >>Turn in A Boralus Triple Threat
.goto 895,81.09,42.46
.target Hawkmaster Lloyd
.target Tallis Skyheart
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cagney|r and |cRXP_FRIENDLY_Olive|r
.turnin 47485 >>Turn in The Ashvane Trading Company
.accept 47486 >>Accept Suspicious Shipments
.accept 47487 >>Accept Labor Dispute
.goto 895,76.83,43.43
.accept 47488 >>Accept Small Haulers
.goto 895,76.82,43.49
.target Cagney
.target Olive
step
#completewith next
>>Kill |cRXP_ENEMY_Ashvane Company guards|r
.complete 47487,1 
.mob Company Enforcer
.mob Company Watchman
.mob Company Fusilier
step
.goto 895,79.02,45.78
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Posted Notice|r |cFFfa9602next to the door of the small house.|r
.accept 50573 >>Accept Message from the Management
step
#completewith Labor Dispute
>>Kill |cRXP_ENEMY_Ashvane Company guards|r
.complete 47487,1 
.mob Company Enforcer
.mob Company Watchman
.mob Company Fusilier
step
.goto 895,79.56,45.67
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Marked Goods|r
.complete 47486,1,1 
step
.goto 895,80.63,46.05
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Urchin Worker|r
.complete 47488,1,1 
.skipgossip
.target Urchin Worker
step
.goto 895,82.14,48.62
>>Kill |cRXP_ENEMY_Forgemaster Farthing|r and loot them for the |T1505961:0|t|cRXP_LOOT_Note.|r
.complete 50573,1 
.mob Forgemaster Farthing
step
.goto 895,82.11,48.54
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Marked Goods|r
.complete 47486,1,2 
step
.goto 895,81.93,48.72
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Urchin Worker|r
.complete 47488,1,2 
.skipgossip
.target Urchin Worker
step
.goto 895,81.51,49.11
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Marked Goods|r
.complete 47486,1,3 
step
.goto 895,81.34,49.39
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Urchin Worker|r
.complete 47488,1,3 
.skipgossip
.target Urchin Worker
step
.goto 895,81.1,49.33
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Marked Goods|r
.complete 47486,1,4 
step
.goto 895,80.77,49.57
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Urchin Worker|r
.complete 47488,1,4 
.skipgossip
.target Urchin Worker
step
.goto 895,80.46,48.83
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Urchin Worker|r
.complete 47488,1,5 
.skipgossip
.target Urchin Worker
step
.goto 895,80.03,47.53
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Urchin Worker|r
.complete 47488,1,6 
.skipgossip
.target Urchin Worker
step
.goto 895,80.18,47.27
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Marked Goods|r
.complete 47486,1,5 
step
.goto 895,79.13,46.96
>>Kill |cRXP_ENEMY_Taskmaster Williams|r |cFFfa9602inside the house|r and loot them for the |T1505962:0|t|cRXP_LOOT_Note.|r
.complete 50573,2 
.mob Taskmaster Williams
step
#loop
.line 895,79.68,48.71,,80.44,48.89,79.96,50.42,81.21,49.75
.goto 895,79.68,48.71,15,0
.goto 895,80.44,48.89,15,0
.goto 895,79.96,50.42,15,0
.goto 895,81.21,49.75,15,0
>>Kill |cRXP_ENEMY_Ashvane Company guards|r
.complete 47487,1 
.mob Company Enforcer
.mob Company Watchman
.mob Company Fusilier
step
#label Labor Dispute
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cagney|r and |cRXP_FRIENDLY_Flynn Fairwind|r
.turnin 47487 >>Turn in Labor Dispute
.goto 895,79.22,47.07,5,0
.goto 895,78.10,47.84
.turnin 47486 >>Turn in Suspicious Shipments
.turnin 47488 >>Turn in Small Haulers
.turnin 50573,1 >>Turn in Message from the Management
.accept 50531 >>Accept Under Their Noses
.goto 895,78.11,47.95
.target Cagney
.target Flynn Fairwind
step
.goto 895,75.85,49.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flynn Fairwind|r
.turnin 50531 >>Turn in Under Their Noses
.accept 53041 >>Accept Sampling the Goods
.target Flynn Fairwind
step
.goto 895,74.75,50.13
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_LOOT_Raw Azerite Sample|r
.complete 53041,2 
step
.goto 895,75.17,50.75
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Chemist Notes|r
.complete 53041,1 
.skipgossip
step
.goto 895,75.42,49.81,5,0
#completewith next
.vendor >>|cRXP_WARN_Empty bags/repair gear at|r |cRXP_FRIENDLY_Jen the Fixer|r |cRXP_WARN_if necessary|r
.target Jen the Fixer
step
.goto 895,75.55,49.94
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Wanted Poster.|r
.accept 50544 >>Accept The Hunters of Kennings Lodge
step
.goto 895,75.88,50.64,5,0
#completewith next
.vendor >>|cRXP_WARN_Empty bags/restock food and water at|r |cRXP_FRIENDLY_Lidia Plank|r |cRXP_WARN_if necessary|r
.target Lidia Plank
step
.goto 895,75.7,50.63
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Junior Miner Joe|r
.accept 50349 >>Accept An Overrun Mine
.target Junior Miner Joe
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Chief Miner Theock|r and |cRXP_FRIENDLY_Head Chemist Walters.|r
.turnin 50349 >>Turn in An Overrun Mine
.accept 50351 >>Accept Miner Operation
.goto 895,78.16,55.94
.accept 50352 >>Accept Pinch of Azerite
.goto 895,78.12,56.01
.target Chief Miner Theock
.target Head Chemist Walters
step
#completewith OrdnancePrim
>>Kill |cRXP_ENEMY_Animated Azerite|r, |cRXP_ENEMY_Bubbling Azerite|r, and |cRXP_ENEMY_Azerite Nibblers|r and loot them for |cRXP_LOOT_Azerite Dust.|r
.complete 50352,1 
.mob Animated Azerite
.mob Bubbling Azerite
.mob Azerite Nibbler
step
.goto 895,76.24,57.21,5 >> Enter the |cFFfa9602House.|r
.isOnQuest 50352
step
.goto 895,76.1,57.43
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_PICK_Walter's Chemistry Kit|r |cFFfa9602next to the wall shelf.|r
.complete 50352,2 
step
.goto 895,76.15,57.62,5 >> Leave the |cFFfa9602House.|r
.isOnQuest 50352
step
.goto 895,76.98,57.78
.gossipoption 48413 >>Talk to |cRXP_FRIENDLY_Civil Technician Alena|r
.isOnQuest 50351
.target Civil Technician Alena
.timer 7, Civil Technician Alena RP
step
#label OrdnancePrim
.goto 895,77.31,60.49
.gossipoption 48300 >>Talk to |cRXP_FRIENDLY_Ordnance Handler Prim|r
.timer 6, Ordnance Handler Prim RP
.target Ordnance Handler Prim
.isOnQuest 50351
step
.goto 895,75.56,59.37
>>Kill |cRXP_ENEMY_Animated Azerite|r, |cRXP_ENEMY_Bubbling Azerite|r, and |cRXP_ENEMY_Azerite Nibblers|r and loot them for |cRXP_LOOT_Azerite Dust.|r
.complete 50352,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ordnance Handler Prim|r and |cRXP_FRIENDLY_Civil Technician Alena.|r
.turnin 50351 >>Turn in Miner Operation
.turnin 50352 >>Turn in Pinch of Azerite
.goto 895,75.56,59.37
.accept 50356 >>Accept Rock Meet Dynamite
.target Ordnance Handler Prim
.target Civil Technician Alena
step
.goto 895,76.11,59.92,5 >> Enter |cFFfa9602the cave.|r
.isOnQuest 50356
step
.goto 895,76.16,60.32,10,0
.goto 895,76.51,60.59,8,0
.goto 895,76.61,59.90,8,0
.goto 895,76.27,59.31,10,0
.goto 895,74.96,59.94
>>Kill |cRXP_ENEMY_Earthshaper Brugaw|r.
>>|cRXP_WARN_Use your Extra Action Button on cooldown|r
.complete 50356,1 
.mob Earthshaper Brugaw
step
.goto 895,76.27,59.31,10,0
.goto 895,76.61,59.90,8,0
.goto 895,76.51,60.59,8,0
.goto 895,76.16,60.32,10,0
.goto 895,76.10,59.74,10 >> Leave |cFFfa9602the cave.|r
.isOnQuest 50356
step
.goto 895,78.14,55.95
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Chief Miner Theock|r
.turnin 50356 >>Turn in Rock Meet Dynamite
.target Chief Miner Theock
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alanna Holton|r and |cRXP_FRIENDLY_Lord Kennings.|r
.turnin 50544 >>Turn in The Hunters of Kennings Lodge
.accept 48874 >>Accept Pardon Our Rust
.goto 895,75.84,65.86
.accept 48873 >>Accept A Grizzly End
.accept 48879 >>Accept A Hunt for Hawk Eggs
.goto 895,75.82,65.79
.target Chief Miner Theock
.target Lord Kennings
step
.goto 895,76.13,65.52
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Weathered Job List|r
.accept 49028 >>Accept A Sweater for Rupert
.accept 49069 >>Accept WANTED: Ol' Frostclaw
step
#completewith Sprung Beartrap 1
>>Kill |cRXP_ENEMY_Guarded Quillrats|r and loot them for |cRXP_LOOT_Sturdy Quills|r
.complete 49028,1 
.mob Guarded Quillrat
step
#completewith Sprung Beartrap 2
>>Kill |cRXP_ENEMY_Monstrous Grizzlies|r and then use your |T463557:0|t[Simple Skinning Knife]
.complete 48873,1 
.use 152800
.mob Monstrous Grizzly
step
.goto 895,77.99,65.58
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sprung Beartrap|r
.complete 48874,1,1 
step
.goto 895,79.69,65.71,5 >> Enter |cFFfa9602the cave|r
.isOnQuest 49069
step
.goto 895,80.07,65.6
>>Kill |cRXP_ENEMY_Ol' Frostclaw|r
.complete 49069,1 
.mob Old Frostclaw
step
.goto 895,78.14,64.58
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sprung Beartrap|r
.complete 48874,1,2 
step
#label Sprung Beartrap 1
.goto 895,77.66,64.75
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sprung Beartrap|r
.complete 48874,1,3 
step
#completewith Sprung Beartrap 2
>>Kill |cRXP_ENEMY_Mountain Raccoons|r,|cRXP_ENEMY_Guarded Quillrats|r and loot them for |cRXP_LOOT_Fuzzy Tails|r,|cRXP_LOOT_Sturdy Quills.|r
.complete 49028,1 
.complete 49028,2 
.mob Mountain Raccoon
.mob Guarded Quillrat
step
#completewith Sprung Beartrap 2
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Hawk Eggs|r
.complete 48879,1 
step
.goto 895,77.85,64.41
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sprung Beartrap|r
.complete 48874,1,4 
step
#label Sprung Beartrap 2
.goto 895,77.42,62.82
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sprung Beartrap|r
.complete 48874,1,5 
step
#completewith Sprung Beartrap 3
>>Kill |cRXP_ENEMY_Monstrous Grizzlies|r and then use your |T463557:0|t[Simple Skinning Knife]
.complete 48873,1 
.use 152800
.mob Monstrous Grizzly
step
#completewith Sprung Beartrap 3
>>Kill |cRXP_ENEMY_Mountain Raccoons|r,|cRXP_ENEMY_Guarded Quillrats|r and loot them for |cRXP_LOOT_Fuzzy Tails|r,|cRXP_LOOT_Sturdy Quills.|r
.complete 49028,1 
.complete 49028,2 
.mob Mountain Raccoon
.mob Guarded Quillrat
step
#label Sprung Beartrap 3
.goto 895,77.52,62.83,10,0
.goto 895,76.83,62.42,10,0
.goto 895,76.73,61.82,10,0
.goto 895,76.34,61.02,10,0
.goto 895,75.91,61.08,10,0
.goto 895,75.16,61.11,10,0
.goto 895,74.54,61.1,10,0
.goto 895,75.13,61.95
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Hawk Eggs|r
.complete 48879,1 
step
#completewith next
>>Kill |cRXP_ENEMY_Monstrous Grizzlies|r and then use your |T463557:0|t[Simple Skinning Knife]
.complete 48873,1 
.use 152800
.mob Monstrous Grizzly
step
.goto 895,75.13,61.95,10,0
.goto 895,74.54,61.1,10,0
.goto 895,75.16,61.11,10,0
.goto 895,75.91,61.08,10,0
.goto 895,76.34,61.02,10,0
.goto 895,76.73,61.82,10,0
.goto 895,76.83,62.42,10,0
.goto 895,77.52,62.83
>>Kill |cRXP_ENEMY_Mountain Raccoons|r,|cRXP_ENEMY_Guarded Quillrats|r and loot them for |cRXP_LOOT_Fuzzy Tails|r,|cRXP_LOOT_Sturdy Quills.|r
.complete 49028,1 
.complete 49028,2 
.mob Mountain Raccoon
.mob Guarded Quillrat
step << skip
.cast 6478 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Hawk Eggs|r
step
.goto 895,76.68,65.04
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kolta|r
.turnin 49028 >>Turn in A Sweater for Rupert
.target Kolta
step
.goto 895,75.84,65.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Kennings|r and |cRXP_FRIENDLY_Alanna Holton|r
.turnin 48879 >>Turn in A Hunt for Hawk Eggs
.goto 895,75.82,65.78
.turnin 48873 >>Turn in A Grizzly End
.turnin 48874 >>Turn in Pardon Our Rust
.turnin 49069 >>Turn in WANTED: Ol' Frostclaw
.goto 895,75.85,65.87
.accept 49072 >>Accept Westward Noble
.target Alanna Holton
.target Lord Kennings
step
.goto 895,70.9,61.98
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Kennings.|r
.turnin 49072 >>Turn in Westward Noble
.accept 49039 >>Accept The Start of a Monster Hunt
.target Lord Kennings
step
.goto 895,70.88,61.68
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Smashed Crate.|r
.complete 49039,1 
step
.goto 895,70.81,61.43
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Disturbed Trap.|r
.complete 49039,3 
step
.goto 895,70.68,61.95
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Bloody Trail.|r
.complete 49039,2 
step
#label LordKennings
.goto 895,70.89,61.98
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Kennings|r
.turnin 49039 >>Turn in The Start of a Monster Hunt
.accept 48909 >>Accept Noble Responsibilities
.target Lord Kennings
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Kennings|r |cFFfa9602next to you.|r
.accept 49066 >>Accept Encase of Emergency
step
#completewith KuroktheLost
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Ice Block|r and kill |cRXP_ENEMY_Agitated Ice Shardling|r and loot them for |cRXP_LOOT_Pristine Ice Chunks|r
.complete 49066,1 
.mob Agitated Ice Shardling
step
.goto 895,70.32,62.93
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with the |cRXP_PICK_Cold Corpse|r
.complete 48909,1 
.target Cold Corpse
step
.goto 895,69.23,62.42
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with the |cRXP_PICK_Hunter Corpse|r
.complete 48909,2 
.target Hunter Corpse
step
.goto 895,68.89,63.93
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with the |cRXP_PICK_Dead Quillrat.|r
.complete 48909,3 
.target Dead Quillrat
step
.goto 895,68.2,65.13
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with the |cRXP_PICK_Fresh Stag Corpse|r
.complete 48909,4 
.target Fresh Stag Corpse
step
.goto 895,68.21,65.76,5 >> Enter the |cFFfa9602cave.|r
.isOnQuest 48909
step
#label KuroktheLost
.goto 895,68.07,66.50
>>Kill |cRXP_ENEMY_Kurok the Lost.|r
.complete 48909,5 
.mob Kurok the Lost
step
.goto 895,70.88,61.68,10,0
.goto 895,70.81,61.43,10,0
.goto 895,70.68,61.95,10,0
.goto 895,70.68,61.95
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Ice Block|r and kill |cRXP_ENEMY_Agitated Ice Shardling|r and loot them for |cRXP_LOOT_Pristine Ice Chunks|r
.complete 49066,1 
.mob Agitated Ice Shardling
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Kennings|r |cFFfa9602next to you|r
.turnin 49066 >>Turn in Encase of Emergency
.target Lord Kennings
step
.goto 895,75.84,65.87
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alanna Holton|r
.turnin 48909,1 >>Turn in Noble Responsibilities
.target Alanna Holton
step
.goto 895,75.85,49.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flynn Fairwind|r
.turnin 53041 >>Turn in Sampling the Goods
.accept 47489 >>Accept Stow and Go
.target Flynn Fairwind
step
.goto 895,75.84,49.13
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flynn Fairwind|r
.complete 47489,1 
.skipgossip
.target Flynn Fairwind
step
#completewith next
.goto 895,75.79,48.58
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jeb Johnson|r
.fp >>Get the Bridgeport Flight Path
.target Jeb Johnson
step
.goto 895,75.5,48.08,5 >>|cFFfa9602Board the Maiden's Virtue.|r
.isOnQuest 47489
step
.goto 895,75.5,48.08
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Barrel of Fish|r
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic.|r
.complete 47489,3 
step
.goto 895,85.56,83.62
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Beachcomber Bob|r
.turnin 47489 >>Turn in Stow and Go
.accept 49218 >>Accept The Castaways
.accept 48419 >>Accept Lured and Allured
.target Beachcomber Bob
step
.goto 895,85.46,80.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Stabby Jane|r
.turnin 49218 >>Turn in The Castaways
.target Stabby Jane
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Stabby Jane|r and |cRXP_FRIENDLY_Hungry Sam|r
.complete 48419,1 
.accept 49178 >>Accept My Favorite Things
.accept 49226 >>Accept Silencing the Sisters
.goto 895,85.46,80.81
.complete 49178,1 
.accept 49230 >>Accept Local Flavor
.goto 895,85.47,80.72
.skipgossip 128229,1
.skipgossip 128228,1
.target Stabby Jane
.target Hungry Sam
step
.goto 895,85.27,80.32
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Friendly Pete|r
.complete 49178,2 
.skipgossip
.target Friendly Pete
step
.goto 895,86.43,81.3
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Handy Bill|r
.complete 49178,3 
.skipgossip
.target Handy Bill
step
#completewith next
.goto 895,86.42,80.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Skinny Tim|r
.fp >>Get the Bridgeport Flight Path
.target Skinny Tim
step
.goto 895,86.35,79.74
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Keelson|r
.accept 48421 >>Accept Blood in the Tides
.target Captain Keelson
step
#completewith SilencingtheSisters
>>Kill |cRXP_ENEMY_Wailing Sirens.|r
>>Kill |cRXP_ENEMY_Tide Lurkers|r and loot them for |T237328:0|t|cRXP_LOOT_Juicy Lurker Tail.|r
.complete 48421,1 
.complete 49230,1 
.mob Wailing Siren
.mob Tide Lurker
step
.goto 895,88.26,78.14
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Silver Compass|r
.complete 49178,5 
step
.goto 895,90.13,74.38,15 >>|cRXP_WARN_Discover |cRXP_FRIENDLY_Flynn Fairwind|r|r
.target Flynn Fairwind
.isOnQuest 48419
step
.goto 895,90.13,74.38
>>Kill |cRXP_ENEMY_Lugeia|r
.complete 48419,3 
.mob Lugeia
step
.goto 895,88.28,72.92
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Steel Lunchbox|r
.complete 49178,4 
step
.goto 895,86.98,72.56,5 >> Enter |cFFfa9602the cave.|r
.isOnQuest 49178
step
.goto 895,86.51,72.5
>>Kill |cRXP_ENEMY_Nolpe|r and |cRXP_ENEMY_Patheope.|r
.complete 49226,2 
.complete 49226,1 
.mob Nolpe
.mob Patheope
step
.goto 895,87.11,72.64,8,0
.goto 895,87.98,75.01
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Glimmering Seaweed|r
.accept 49181 >>Accept Glimmering Locket
step
#label SilencingtheSisters
.goto 895,87.69,75.12
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Robot|r
.complete 49178,6 
step
.goto 895,85.47,80.82
>>Kill |cRXP_ENEMY_Wailing Sirens.|r
>>Kill |cRXP_ENEMY_Tide Lurkers|r and loot them for |T237328:0|t|cRXP_LOOT_Juicy Lurker Tail.|r
.complete 48421,1 
.complete 49230,1 
.mob Wailing Siren
.mob Tide Lurker
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Stabby Jane|r and |cRXP_FRIENDLY_Hungry Sam|r
.turnin 49178 >>Turn in My Favorite Things
.turnin 49226 >>Turn in Silencing the Sisters
.turnin 49181 >>Turn in Glimmering Locket
.goto 895,85.47,80.82
.turnin 49230 >>Turn in Local Flavor
.goto 895,85.47,80.72
.target Stabby Jane
.target Hungry Sam
step
.goto 895,85.72,76.63
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk |cRXP_FRIENDLY_Captain Keelson|r
.turnin 48421,2 >>Turn in Blood in the Tides
.target Captain Keelson
step
.goto 895,84.91,76.06
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flynn Fairwind|r
.turnin 48419 >>Turn in Lured and Allured
.accept 48505 >>Accept Lovesick and Lost
.target Flynn Fairwind
step
#completewith ToxicCommunity
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flynn Fairwind|r
>>|cRXP_WARN_Stay close to him. If you don't, he will stop until you're close.|r
.complete 48505,1 
.timer 8, Flynn RP
.skipgossip
.target Flynn Fairwind
step
.goto 895,82.74,72.82
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Skinner MacGuff|r
.target Skinner MacGuff
.accept 48516 >>Accept Toxic Community
step
>>Kill |cRXP_LOOT_Venomspine Saurolisks|r and loot them for |cRXP_LOOT_Marrowflies|r |cFFfa9602during the escort.|r
.complete 48516,1 
step
#label ToxicCommunity
.goto 895,82.75,72.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Skinner MacGuff|r
.turnin 48516 >>Turn in Toxic Community
step
.goto 895,80.21,75.25
>>|cRXP_WARN_Stay close to him. If you don't, he will stop until you're close.|r
.skipgossip
.complete 48505,1 
.target Flynn Fairwind
step
.goto 895,80.21,75.25
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flynn Fairwind|r
>>|cRXP_WARN_Wait for the brief roleplay, which will be completed when the timer runs out.|r
.turnin 48505 >>Turn in Lovesick and Lost
.accept 48539 >>Accept Freehold
.target Flynn Fairwind
step
.goto 895,80.17,75.3
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Spyglass|r on the rock.
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic.|r
.complete 48539,1 
step
.goto 895,80.19,75.27
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flynn Fairwind|r
.turnin 48539 >>Turn in Freehold
.accept 48773 >>Accept Papers, Please
.accept 48558 >>Accept The Irontide Crew
.target Flynn Fairwind
step
#completewith Dockmaster's Records
>>Kill |cRXP_ENEMY_Irontide Trickshot|r and loot them for |T133593:0|t|cRXP_LOOT_[Trickshot's Azerite Powder Horn].|r
>>Kill |cRXP_ENEMY_Irontide Cutthroat|r and loot them for |T135325:0|t|cRXP_LOOT_[Azerite Cutlass].|r
.complete 48558,1 
.complete 48558,2 
.mob Irontide Trickshot
.mob Irontide Cutthroat
step
.goto 895,79.19,76.32
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Geraldine|r
.accept 48774 >>Accept The Beatings Will Continue
.accept 48776 >>Accept Rig Robbing
.target Geraldine
step
#completewith Dockmaster's Records
>>Kill |cRXP_ENEMY_Irontide Overseer|r and |cRXP_ENEMY_Irontide Ruffian|r
.complete 48774,1 
.complete 48774,2 
.mob Irontide Trickshot
.mob Irontide Cutthroat
.mob Irontide Ruffian
step
.isOnQuest 48773
.goto 895,79.13,78.79
>>Kill |cRXP_ENEMY_Dockmaster Marl|r and loot him for |T237379:0|t|cRXP_LOOT_[Dockmaster's Key]|r
.collect 152722,1 
.mob Dockmaster Marl
step
.goto 895,79.13,78.79
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Dockmaster's Strongbox|r
.complete 48773,1 
step
.goto 895,78.6,77.86
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Azerite Cannonball|r
.accept 48606 >>Accept Loaded for Bear
step
.goto 895,78.57,77.82
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Azerite Cannonball|r
.collect 152628,2
.isOnQuest 48606
step
.goto 895,78.41,77.6
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Azerite Cannonball|r
.collect 152628,3
.isOnQuest 48606
step
.goto 895,78.44,77.69
.vehicle >>Click the |cRXP_PICK_Ashvane Cannon|r
.isOnQuest 48606
step
.goto 895,78,78.71
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Ashvane Cannon|r
.complete 48606,1,1 
step
.goto 895,78,78.71
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Ashvane Cannon|r
.complete 48606,1,3 
step
.goto 895,77.83,76.76
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Azerite Cannonball|r
.collect 152628,4
.isOnQuest 48606
step
.goto 895,77.81,76.72
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Azerite Cannonball|r
.collect 152628,5
.isOnQuest 48606
step
.goto 895,78.01,76.52
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Azerite Cannonball|r
.collect 152628,6
.isOnQuest 48606
step
.goto 895,77.73,76.65
.vehicle >>Click the |cRXP_PICK_Ashvane Cannon|r
.isOnQuest 48606
step
.goto 895,77.06,77.25
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Ashvane Cannon|r
.complete 48606,1,6 
step
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 48606 >>Turn in Loaded for Bear
step
.goto 895,77.04,76.28
#label Dockmaster's Records
.cast 252484 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Tangled Rigging.|r|cRXP_WARN_(1)|r
.isOnQuest 48776
step
.goto 895,77.27,75.88,10 >>|cRXP_WARN_Pull the rope away from the water.|r|cRXP_WARN_(1)|r
.isOnQuest 48776
step
.goto 895,77.04,76.28
.cast 252484 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Tangled Rigging.|r|cRXP_WARN_(2)|r
.isOnQuest 48776
step
.goto 895,77.27,75.88,9 >>|cRXP_WARN_Pull the rope away from the water.|r|cRXP_WARN_(2)|r
.isOnQuest 48776
step
.goto 895,77.04,76.28
.cast 252484 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Tangled Rigging.|r|cRXP_WARN_(3)|r
.isOnQuest 48776
step
.goto 895,77.27,75.88,12 >>|cRXP_WARN_Pull the rope away from the water.|r|cRXP_WARN_(3)|r
.isOnQuest 48776
step
.goto 895,77.04,76.28
.cast 252484 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Tangled Rigging.|r|cRXP_WARN_(4)|r
.isOnQuest 48776
step
.goto 895,77.27,75.88,11 >>|cRXP_WARN_Pull the rope away from the water.|r|cRXP_WARN_(4)|r
.isOnQuest 48776
step
.goto 895,77.04,76.28
.cast 252484 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Tangled Rigging.|r|cRXP_WARN_(5)|r
.isOnQuest 48776
step
.goto 895,77.27,75.88,12 >>|cRXP_WARN_Pull the rope away from the water.|r|cRXP_WARN_(5)|r
.isOnQuest 48776
step
.goto 895,77.17,76.04
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Bottle|r |cFFfa9602on the ground.|r
.complete 48776,1 
step
#completewith next
>>Kill |cRXP_ENEMY_Irontide Trickshot|r and loot them for |T133593:0|t|cRXP_LOOT_[Trickshot's Azerite Powder Horn].|r
>>Kill |cRXP_ENEMY_Irontide Cutthroat|r and loot them for |T135325:0|t|cRXP_LOOT_[Azerite Cutlass].|r
.complete 48558,1 
.complete 48558,2 
.mob Irontide Trickshot
.mob Irontide Cutthroat
step
.goto 895,79.21,76.34
>>Kill |cRXP_ENEMY_Irontide Overseer|r and |cRXP_ENEMY_Irontide Ruffian|r
.complete 48774,1 
.complete 48774,2 
.mob Irontide Trickshot
.mob Irontide Cutthroat
.mob Irontide Ruffian
step
.goto 895,79.21,76.34
>>Kill |cRXP_ENEMY_Irontide Trickshot|r and loot them for |T133593:0|t|cRXP_LOOT_[Trickshot's Azerite Powder Horn].|r
>>Kill |cRXP_ENEMY_Irontide Cutthroat|r and loot them for |T135325:0|t|cRXP_LOOT_[Azerite Cutlass].|r
.complete 48558,1 
.complete 48558,2 
.mob Irontide Trickshot
.mob Irontide Cutthroat
step
.goto 895,79.21,76.34
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Geraldine|r
.turnin 48774 >>Turn in The Beatings Will Continue
.turnin 48776 >>Turn in Rig Robbing
.target Geraldine
step
.goto 895,80.35,81.47
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flynn Fairwind|r
.turnin 48773 >>Turn in Papers, Please
.turnin 48558,2 >>Turn in The Irontide Crew
.accept 49239 >>Accept Dress to Impress
.target Flynn Fairwind
step
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 48606 >>Turn in Loaded for Bear
step
.goto 895,79.70,81.85
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Roko|r.
.accept 49290 >>Accept Aged to Perfection
.target Roko
step
.goto 895,79.81,82.37
>>Use your |cRXP_WARN_[Extra Action Button]|r to disguise yourself, then talk to the |cRXP_FRIENDLY_Irontide Recruiter.|r
.complete 49239,1 
.skipgossip
.target Irontide Recruiter
step
.goto 895,77.35,84.18,5,0
.goto 895,77.31,83.96
>>|cFFfa9602Enter the first building past the bridge on the right side.|r
.complete 49239,2 
.timer 23, Dead Man's Tale RP
step
#completewith next
.target Jill McHoonigan
.vendor >>|cRXP_WARN_During the roleplay, empty bags/restock food and water at |cRXP_FRIENDLY_Jill McHoonigan |r if necessary|r
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flynn Fairwind|r and |cRXP_FRIENDLY_Venrik.|r
>>|cRXP_WARN_Wait for the brief roleplay, which will be completed when the timer runs out.|r
.turnin 49239 >>Turn in Dress to Impress
.accept 49401 >>Accept Rodrigo's Roost
.goto 895,77.33,83.97
.accept 49398 >>Accept Raise a Glass!
.goto 895,77.36,83.92
.target Flynn Fairwind
.target Venrik
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Venrik|r
.complete 49398,1 
.skipgossip 128927,2
.target Venrik
step
>>|cRXP_WARN_Use the |T132815:0|t[Goat Milk]|r
.complete 49398,2 
.use 153600
step
.goto 895,77.36,83.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Venrik|r
.turnin 49398 >>Turn in Raise a Glass!
.target Venrik
step
.goto 895,77.03,82.89
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rodrigo|r
.accept 49402 >>Accept Flew the Coop
.target Rodrigo
step
#completewith Irontide Recruiting Poster
>>|cRXP_WARN_Use your|r [ExtraActionButton] |cRXP_WARN_on the |cRXP_FRIENDLY_Runaway Macaw|r |cFFfa9602in the sky.|r|r
.complete 49402,1 
.use 154878
step
.goto 895,77.03,82.89
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rodrigo|r
.complete 49401,1 
.skipgossip 129098,1
.target Rodrigo
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flynn Fairwind|r and |cRXP_FRIENDLY_Venrik|r
.turnin 49401 >>Turn in Rodrigo's Roost
.accept 49399 >>Accept The Big Job
.goto 895,77.33,83.97
.accept 49400 >>Accept Recruiting Efforts
.goto 895,77.36,83.92
.target Flynn Fairwind
.target Venrik
step
.goto 895,77.34,84.17,5,0
.goto 895,77.19,84.85
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sternly Worded Letter|r
.accept 49409 >>Accept Missing Treasure!
step
#completewith Irontide Recruiting Poster
>>Kill |cRXP_ENEMY_Bilge Rats|r, |cRXP_ENEMY_Cutwaters|r and |cRXP_ENEMY_Blacktooths|r and loot them for their |T1505940:0|t|cRXP_LOOT_Orders|r
>>|cRXP_WARN_Use your |r[ExtraActionButton] |cRXP_WARN_to disguise yourself and avoid being attacked. If you need to attack enemies, this will undo your disguise. Remember, you can reapply your disguise whenever you need it|r
.complete 49399,1 
.complete 49399,2 
.complete 49399,3 
.mob Cutwater Duelist
.mob Blacktooth Knuckleduster
.mob Blacktooth Scrapper
.mob Vulpera Padfoot
.use 254873
step
.goto 895,77.78,85.01
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ned|r
.skipgossip
.complete 49409,1 
.target Ned
step
.goto 895,77.77,85.27,5 >> Leave the |cFFfa9602house.|r
.isOnQuest 49409
step
.goto 895,77.29,85.84
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Irontide Recruiting Poster|r
>>|cRXP_WARN_Use your|r [ExtraActionButton] |cRXP_WARN_to disguise yourself to avoid being attacked.|r
.complete 49400,1,1 
step
.goto 895,76.85,85.8
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Irontide Recruiting Poster|r
>>|cRXP_WARN_Use your|r [ExtraActionButton] |cRXP_WARN_to disguise yourself to avoid being attacked.|r
.complete 49400,1,2 
step
.goto 895,76.75,85.93 >> Enter the |cFFfa9602House|r
.isOnQuest 49400
step
.goto 895,76.90,85.98
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Carentan|r
.turnin 49290 >>Turn in Aged to Perfection
.accept 49407 >>Accept Trixie Business
.target Carentan
step
.goto 895,76.52,84.91
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Irontide Recruiting Poster|r
>>|cRXP_WARN_Use your|r [ExtraActionButton] |cRXP_WARN_to disguise yourself to avoid being attacked.|r
.complete 49400,1,3 
step
.goto 895,76.38,84.32
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nub Nub|r
.skipgossip
.complete 49409,2 
.target Nub Nub
step
.goto 895,76.45,84.25,5,0
.goto 895,76.28,84.24,5,0
.goto 895,76.13,83.05
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nance Barmy|r
.skipgossip
.complete 49409,3 
.target Nance Barmy
step
.goto 895,76.47,82.63
.gossipoption 48508 >>Talk to |cRXP_FRIENDLY_First Mate Trixie Tornsail|r, |cRXP_WARN_then continue to follow the guide afterwards.|r
.timer 27, Trixie RP
.isOnQuest 49407
.target First Mate Trixie Tornsail
step
.goto 895,76.28,83.77
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Irontide Recruiting Poster|r
>>|cRXP_WARN_enemies may become hostile|r
.complete 49400,1,4 
step
.goto 895,76.77,82.65
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Irontide Recruiting Poster|r
>>|cRXP_WARN_enemies may become hostile|r
.complete 49400,1,5 
step
.goto 895,77.24,83.49
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Irontide Recruiting Poster|r
.complete 49400,1,6 
step
#completewith next
>>|cRXP_WARN_Follow |cRXP_FRIENDLY_First Mate Trixie Tornsail|r and wait for the brief roleplay, which will be completed when the timer runs out.|r
.isOnQuest 49407
.target First Mate Trixie Tornsail
step
.goto 895,76.47,82.63
>>Kill |cRXP_ENEMY_First Mate Trixie Tornsail|r
.complete 49407,1 
.mob First Mate Trixie Tornsail
step
.goto 895,75.62,80.57
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sandy Seaweed-covered Chest.|r
.complete 49409,4 
step
.goto 895,76.29,80.77
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Dirty Diamond.|r
.complete 49409,5 
step
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 49409 >>Turn in Missing Treasure!
step
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 49409 >>Turn in Missing Treasure!
step
.goto 895,77.04,82.9
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rodrigo|r
.turnin 49402 >>Turn in Flew the Coop
.accept 49403 >>Accept Rodrigo's Revenge
.target Rodrigo
.isQuestComplete 49402
step
.goto 895,77.06,82.62
.vehicle >>Interact with the |cRXP_FRIENDLY_Riding Macaw|r
.target Riding Macaw
.isOnQuest 49403
step
>>Use |T1500941:0|t[Vile Bombardment] on |cRXP_ENEMY_Pirates|r
.complete 49403,1 
.isOnQuest 49403
.mob Cutwater Duelist
.mob Blacktooth Knuckleduster
.mob Blacktooth Scrapper
.mob Vulpera Padfoot
step
.goto 895,77.36,83.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Venrik|r
.turnin 49399 >>Turn in The Big Job
.accept 49404 >>Accept Fairwind's "Friends"
.turnin 49400,1 >>Turn in Recruiting Efforts
.target Venrik
.isQuestComplete 49402,49400
step
.goto 895,77.04,82.89
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rodrigo|r
.turnin 49403 >>Turn in Rodrigo's Revenge
.target Rodrigo
.isOnQuest 49403
step
.goto 895,76.75,85.93,5 >> Enter the |cFFfa9602House|r
.isOnQuest 49407
step
.goto 895,76.90,85.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Carentan|r
.turnin 49407 >>Turn in Trixie Business
.accept 49522 >>Accept Carentan's Payment
.target Carentan
step
.goto 895,76.81,85.97
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Dusty Crate|r
>>|cRXP_WARN_You'll be stunned after for 10seconds|r
.complete 49522,1 
.timer 10, Stun RP
step
#label Irontide Recruiting Poster
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 49522 >>Turn in Carentan's Payment
.accept 49523 >>Accept A Bad Deal
step
#completewith next
>>|cRXP_WARN_Use your|r [ExtraActionButton] |cRXP_WARN_on the |cRXP_FRIENDLY_Runaway Macaw|r |cFFfa9602in the sky.|r|r
.complete 49402,1 
.use 154878
step
>>Kill |cRXP_ENEMY_Bilge Rats|r, |cRXP_ENEMY_Cutwaters|r and |cRXP_ENEMY_Blacktooths|r and loot them for their |T1505940:0|t|cRXP_LOOT_Orders|r
>>|cRXP_WARN_Use your |r[ExtraActionButton] |cRXP_WARN_to disguise yourself and avoid being attacked. If you need to attack enemies, this will undo your disguise. Remember, you can reapply your disguise whenever you need it|r
.complete 49399,1 
.complete 49399,2 
.complete 49399,3 
.mob Cutwater Duelist
.mob Blacktooth Knuckleduster
.mob Blacktooth Scrapper
.mob Vulpera Padfoot
.use 254873
step
>>|cRXP_WARN_Use your|r [ExtraActionButton] |cRXP_WARN_on the |cRXP_FRIENDLY_Runaway Macaw|r |cFFfa9602in the sky.|r|r
.complete 49402,1 
.use 154878
step
>>Use |T1500941:0|t[Vile Bombardment] on |cRXP_ENEMY_Pirates|r
.complete 49403,1 
.isOnQuest 49403
.mob Cutwater Duelist
.mob Blacktooth Knuckleduster
.mob Blacktooth Scrapper
.mob Vulpera Padfoot
step
.goto 895,77.36,83.92
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Venrik|r
.turnin 49399 >>Turn in The Big Job
.accept 49404 >>Accept Fairwind's "Friends"
.turnin 49400,1 >>Turn in Recruiting Efforts
.target Venrik
.isQuestComplete 49402,49400
step
.goto 895,77.04,82.9
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rodrigo|r
.turnin 49402 >>Turn in Flew the Coop
.accept 49403 >>Accept Rodrigo's Revenge
.target Rodrigo
.isQuestComplete 49402
step
.goto 895,77.06,82.62
.vehicle >>Interact with the |cRXP_FRIENDLY_Riding Macaw|r
.target Riding Macaw
.isOnQuest 49403
step
.goto 895,73.83,83.44,5 >>Enter |cFFfa9602the Ring of Booty.|r
.isOnQuest 49404
step
.goto 895,73.84,83.44
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Flynn Fairwind|r
.complete 49404,2 
.timer 42, Ring of Booty
.target Flynn Fairwind
step
.goto 895,73.56,83.43
>>|cRXP_WARN_Defend Flynn Fairwind.|r
.complete 49404,3 
.mob Cutwater Duelist
.mob Bristleback Horker
.mob Blacktooth Knuckleduster
.mob Cutwater Reaver
step
.goto 895,77.14,82.91
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taelia|r
>>|cRXP_WARN_If you are quick enough you can avoid being picked up by a |cRXP_FRIENDLY_Gryphon|r; it's faster to manually fly to |cRXP_FRIENDLY_Taelia|r then to fly with the |cRXP_FRIENDLY_Gryphon.|r|r
>>|cRXP_WARN_You might have to run first before you are able to fly to get out of combat.|r
.turnin 49404,1 >>Turn in Fairwind's "Friends"
.accept 49405 >>Accept Defenders of Daelin's Gate
.target Taelia
step
.goto 895,77.14,82.9
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Galeheart|r
.complete 49405,1 
.target Galeheart
.timer 62,Flight
step
>>|cRXP_WARN_Wait for the brief flight, which will be completed when the timer runs out.|r
.complete 49405,2 
step
.goto 895,60.92,59.17
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vigil Hill Refugee|r
.turnin 49405 >>Turn in Defenders of Daelin's Gate
.accept 52431 >>Accept No-Landing Zone
.target Vigil Hill Refugee
step
.goto 895,61.07,61.43
>>Kill |cRXP_ENEMY_Burnsy the Blade.|r
.complete 52431,1 
.timer 13, Wiley Jaki appears
.mob Burnsy the Blade
step
.goto 895,61.07,61.43
>>Kill |cRXP_ENEMY_Wiley Jaki.|r
.complete 52431,2 
.timer 13, Skullcrusher Cotner appears
.mob Wiley Jaki
step
.goto 895,61.07,61.43
>>Kill |cRXP_ENEMY_Skullcrusher Cotner.|r
.complete 52431,3 
.mob Skullcrusher Cotner
step
.goto 895,60.92,59.17
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Vigil Hill Refugee.|r
.turnin 52431 >>Turn in No-Landing Zone
.accept 49869 >>Accept A Desperate Defense
.target Vigil Hill Refugee
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Tarenfold|r and |cRXP_FRIENDLY_Taelia.|r
.turnin 49869 >>Turn in A Desperate Defense
.accept 52750 >>Accept Farmers Who Fight
.accept 49737 >>Accept Air Raid
.goto 895,56.67,61.19
.accept 52787 >>Accept Numbing the Pain
.goto 895,56.47,61.72
.target Lieutenant Tarenfold
.target Taelia
step
#completewith Vigil Hill Farmer
>>Kill |cRXP_ENEMY_Irontide Skyrider|r |cFFfa9602most of them are in the sky.|r
.complete 49737,1 
.mob Irontide Skyrider
step
.goto 895,55.98,61.27
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Evermoss Clump.|r
.complete 52787,1,1 
step
.goto 895,55.17,60.73
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Evermoss Clump.|r
.complete 52787,1,2 
step
.goto 895,55.16,60.4
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Evermoss Clump.|r
.complete 52787,1,3 
step
.goto 895,55.4,60.1
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Vigil Hill Farmer.|r
.complete 52750,1,1 
.target Vigil Hill Farmer
step
.goto 895,55.57,59.67
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Vigil Hill Farmer.|r
.complete 52750,1,2 
.target Vigil Hill Farmer
step
.goto 895,55.84,59.37
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Vigil Hill Farmer.|r
.complete 52750,1,3 
.target Vigil Hill Farmer
step
.goto 895,55.97,59.81
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Evermoss Clump|r
.complete 52787,1,4 
step
.goto 895,56.69,59.38
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Vigil Hill Farmer.|r
.complete 52750,1,4 
.target Vigil Hill Farmer
step
.goto 895,56.8,59.28
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Vigil Hill Farmer.|r
.complete 52750,1,5 
.target Vigil Hill Farmer
step
.goto 895,57.13,59.56
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Evermoss Clump.|r
.complete 52787,1,5 
step
#label Vigil Hill Farmer
.goto 895,57.02,59.89
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Vigil Hill Farmer.|r
.complete 52750,1,6 
.target Vigil Hill Farmer
step
#loop
.line 895,56.32,59.7,55.72,59.75,55.08,59.78,55.3,60.68
.goto 895,56.32,59.70,15,0
.goto 895,55.72,59.75,15,0
.goto 895,55.08,59.78,15,0
.goto 895,55.30,60.68,15,0
>>Kill |cRXP_ENEMY_Irontide Skyrider.|r
.complete 49737,1 
.mob Irontide Skyrider
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Tarenfold|r and |cRXP_FRIENDLY_Taelia.|r
.turnin 52750 >>Turn in Farmers Who Fight
.turnin 49737 >>Turn in Air Raid
.accept 49738 >>Accept Hands Off My Booty!
.goto 895,56.67,61.18
.turnin 52787 >>Turn in Numbing the Pain
.goto 895,56.48,61.73
.target Taelia
.target Lieutenant Tarenfold
step
.goto 895,56.2,64.47
.isOnQuest 49738
.vehicle >>Click the |cRXP_FRIENDLY_Vigil Hill Cannon|r to enter it.
.target Vigil Hill Cannon
step
>>Use |T1035038:0|t(1) to Kill |cRXP_ENEMY_Looters.|r
.complete 49738,1 
.mob Looters
step
.isOnQuest 49738
.exitvehicle >>|cRXP_WARN_Jump off the cannon by pressing the |r[Exit] |cRXP_WARN_button on your action bars.|r
>>|cRXP_WARN_Alternatively, you can use this macro;|r
.link /leavevehicle>> CLICK HERE FOR MACRO.
>>|cRXP_WARN_It's recommended to safe this macro for future use.|r
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Tarenfold|r and |cRXP_FRIENDLY_Taelia.|r
.turnin 49738,2 >>Turn in Hands Off My Booty!
.accept 49740 >>Accept Cease Fire!
.accept 49736 >>Accept For Kul Tiras!
.goto 895,56.67,61.18
.accept 49741 >>Accept Righteous Retribution
.goto 895,56.48,61.73
.target Lieutenant Tarenfold
.target Taelia
step <<skip
.goto 895,56.83,65.58
>>Use |T967530:0|t[Proudmoore Battle Standard]|r to inspire |cRXP_FRIENDLY_Vigil Hill Militia.|r
.complete 49736,1,2 
.use 156520
.target Vigil Hill Marine
step
.goto 895,57.15,65.94
>>Use |T967530:0|t[Proudmoore Battle Standard]|r to inspire |cRXP_FRIENDLY_Vigil Hill Militia.|r
.complete 49736,1,3 
.use 156520
.target Vigil Hill Marine
step
.goto 895,55.37,67.82
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Crate.|r
.complete 49741,1 
step
.goto 895,55.75,67.48
>>Go |cFFfa9602near the Campfire|r and use your |cRXP_WARN_[Extra Action Button].|r
.complete 49741,2 
step
.goto 895,57.13,67.21
>>Use |T967530:0|t[Proudmoore Battle Standard]|r to inspire |cRXP_FRIENDLY_Vigil Hill Militia.|r
>>|cRXP_WARN_You'll might have to wait for the cd to be back up again.|r
.complete 49736,1,8 
.use 156520
.target Vigil Hill Marine
step
.goto 895,57.68,67.37
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Captured Cannon.|r
.complete 49740,1,1 
.target Captured Cannon
step
.goto 895,58.43,67.08
>>Use |T967530:0|t[Proudmoore Battle Standard]|r to inspire |cRXP_FRIENDLY_Vigil Hill Militia.|r
.complete 49736,1,11 
.use 156520
.target Vigil Hill Marine
step
.isOnQuest 49741
.goto 895,59.09,66.6
.vehicle >>Click on the |cRXP_PICK_Boat.|r
step
>>When the |cRXP_WARN_[Extra Action Button]|r appears, press it.
.complete 49741,4 
step
.isOnQuest 49741
.exitvehicle >>|cRXP_WARN_Jump off the boat by pressing the |r[Exit] |cRXP_WARN_button on your action bars.|r
>>|cRXP_WARN_Alternatively, you can use this macro;|r
.link /leavevehicle>> CLICK HERE FOR MACRO.
>>|cRXP_WARN_It's recommended to safe this macro for future use.|r
step
.goto 895,57.56,71.58
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Gryphon.|r
.complete 49741,5 
.target Gryphon
step
>>Throw |T136173:0|t(1)[Azerite Bomb] on 5 |cRXP_ENEMY_Powder Barrels.|r
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic.|r
.complete 49741,6 
step
.goto 895,57.2,70.09
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Captured Cannon.|r
.complete 49740,1,2 
.target Captured Cannon
step
.goto 895,57.41,69.67
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Captured Cannon.|r
.complete 49740,1,3 
.target Captured Cannon
step
.goto 895,56.75,68.91
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Captured Cannon.|r
.complete 49740,1,4 
.target Captured Cannon
step
.goto 895,57.15,67.21
>>Use |T967530:0|t[Proudmoore Battle Standard]|r to inspire |cRXP_FRIENDLY_Vigil Hill Militia.|r
.complete 49736,1,15 
.use 156520
.target Vigil Hill Marine
step
.goto 895,58.61,61.52
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Meredith|r
.accept 49757 >>Accept Cat on a Hot Copper Roof
.target Meredith
step
.goto 895,58.86,61.34
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Scratchy|r twice.
.complete 49757,1 
.target Scratchy
step
.goto 895,58.6,61.52
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Meredith|r
.turnin 49757 >>Turn in Cat on a Hot Copper Roof
.target Meredith
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Tarenfold|r and |cRXP_FRIENDLY_Taelia.|r
.turnin 49740 >>Turn in Cease Fire!
.turnin 49736,2 >>Turn in For Kul Tiras!
.goto 895,56.67,61.19
.turnin 49741 >>Turn in Righteous Retribution
.accept 50110 >>Accept Bearers of Bad News
.goto 895,56.5,61.27
.target Taelia
.target Lieutenant Tarenfold
step
.goto 895,56.5,61.27
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Gryphon.|r
.complete 50110,1 
.timer 49, Flight Time
.target Gryphon
step
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 52544 >>Turn in The War Cache
.accept 53332 >>Accept Time of War
step
.goto 1161,49.12,75.73
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taelia.|r
.turnin 50110 >>Turn in Bearers of Bad News
.accept 50795 >>Accept Prepare for Trouble
.target Taelia
step
.goto 1161,49.29,76.53
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Proudmoore Guard.|r
.skipgossip
.complete 50795,1,1 
.target Proudmoore Guard
step
.goto 1161,49.16,79.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Proudmoore Guard.|r
.skipgossip
.complete 50795,1,2 
.target Proudmoore Guard
step
.goto 1161,48.17,81.13
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Proudmoore Guard.|r
.skipgossip
.complete 50795,1,3 
.target Proudmoore Guard
step
.goto 1161,47.42,81.48
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Proudmoore Guard.|r
.skipgossip
.complete 50795,1,4 
.target Proudmoore Guard
step
.goto 1161,47.40,81.53
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taelia|r |cFFfa9602next to you.|r
.turnin 50795 >>Turn in Prepare for Trouble
.accept 50787 >>Accept Make Our Case
.target Taelia
step
.goto 1161,48.57,83.98
>>Follow the Arrow
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic.|r
.complete 50787,1 
step
.goto 1161,50.01,87.57
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taelia.|r
.turnin 50795 >>Turn in Prepare for Trouble
.accept 50787 >>Accept Make Our Case
.target Taelia
step
.goto 1161,50.01,87.57
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taelia.|r
.turnin 50787 >>Turn in Make Our Case
.accept 50788 >>Accept Enemies Within
.accept 50789 >>Accept Clear the Air
.target Taelia
step
#completewith Smoking Payload
>>Kill |cRXP_ENEMY_Ashvane Conspirators.|r
.complete 50788,1 
.mob Ashvane Conspirator
step
.goto 1161,49.37,86.93
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Barrel.|r
.complete 50789,1,1 
step
.goto 1161,49.5,84.7
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Barrel.|r
.complete 50789,1,2 
step
.goto 1161,48.54,85.5
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Barrel.|r
.complete 50789,1,3 
step
#label Smoking Payload
.goto 1161,48.2,82.48
>>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Barrel.|r
.complete 50789,1,4 
step
#loop
.line 1161,49.37,86.93,49.5,84.7,48.54,85.5,48.2,82.48
.goto 1161,49.37,86.93,10,0
.goto 1161,49.50,84.70,10,0
.goto 1161,48.54,85.50,10,0
.goto 1161,48.20,82.48,10,0
>>Kill |cRXP_ENEMY_Ashvane Conspirators.|r
.complete 50788,1 
.mob Ashvane Conspirator
step
.goto 1161,47.76,81.39
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 50789 >>Turn in Clear the Air
.turnin 50788 >>Turn in Enemies Within
.accept 50790 >>Accept Hot Pursuit
step
.goto 1161,47.76,81.39
>>|TInterface/cursor/crosshair/interact.blp:20|tInteract with |cRXP_FRIENDLY_Proudmoore Charger.|r
.complete 50790,1 
.timer 82, Ashvane Pursuit
.target Proudmoore Charger
step
>>Spam |T236171:0|t(1) and |T136103:0|t(2) to sprint and jump over nearby obstacles.
.complete 50790,2 
step
>>|cRXP_WARN_BE QUICK!|r
.exitvehicle >> |cRXP_WARN_Leave the Horse by pressing the |r[Exit] |cRXP_WARN_button on your action bars.|r
*|cRXP_WARN_Alternatively, you can use this macro;|r
.link /leavevehicle>> CLICK HERE FOR MACRO.
*|cRXP_WARN_It's recommended to safe this macro for future use.|r
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taelia|r and |cRXP_FRIENDLY_Katherine Proudmoore.|r
.turnin 50790 >>Turn in Hot Pursuit
.goto 1161,48.26,80.67
.accept 50972 >>Accept Proudmoore's Parley
.goto 1161,48.42,80.87
.target Taelia
.target Katherine Proudmoore
step
.goto 1161,68.05,22.17
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Genn Greymane|r |cFFfa9602inside the Harbormaster's Office.|r
.turnin 50972,1 >>Turn in Proudmoore's Parley
.target Genn Greymane
step
.goto 1161,68.42,22.00
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Scouting Map|r
.accept 47961 >>Accept Drustvar
step
.goto 1161,68.16,21.98
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Taelia|r
.turnin 47961 >>Turn in Drustvar
.accept 48622 >>Accept The Vanishing Lord
.target Taelia
step
.goto 1161,69.27,26.90
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Halford Wyrmbane|r
.turnin 53332 >>Turn in Time for War
.target Halford Wyrmbane
step
.goto 1161,69.72,27.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Falstad Wildhammer|r
.accept 51714 >>Accept Mission from the King
.target Halford Wyrmbane
step
.goto 1161,70.72,27.10
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Mathias Shaw|r
.turnin 51714 >>Turn in Mission from the King
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#name 9A_Drustvar
#displayname Chapter 9 - Drustvar
#next ZA_WarCampaign
<<Alliance
step
>>Abandon this Quest to get a Teleport to near the next objectives
.abandon 49302
step
.goto 895,35.22,24.16
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rosaline Madison|r
.accept 49302 >>Accept The Deadliest Catch
step
.goto 895,35.29,24.57
.skipgossip 1
.complete 49302,1 
step
>>Click the |cRXP_PICK_Cannon|r
.goto 895,36.33,29.82
.complete 49302,2 
step
>>Shoot Harpoons at the Purple Bubbles
.complete 49302,3 
step
>>Click the |cRXP_PICK_Gryphon|r
.goto 895,36.77,29.71
.complete 49302,5 
step
.goto 895,42.47,29.35
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brannon Stormsong|r
.turnin 49302,1 >>Turn in The Deadliest Catch
step
.goto 896,62.54,23.94
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_David Maldus|r
.accept 48677,1 >>Accept Wicker Worship
step
.goto 896,59.45,21.91
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Autumnvale|r
.turnin 48677,1 >>Turn in Wicker Worship
.accept 48678,1 >>Accept Questionable Offerings
step
>>Deliver |cRXP_PICK_Entrails|r to Lord Autumvale
.goto 896,59.88,21.99
.complete 48678,1,1 
step
>>Deliver |cRXP_PICK_Wicker|r to Lord Autumvale
.goto 896,59.88,21.99
.complete 48678,1,2 
step
>>Deliver |cRXP_PICK_Bones|r to Lord Autumvale
.goto 896,59.89,21.96
.complete 48678,1,3 
step
>>Wait for the Roleplay Duration
.complete 48678,2 
step
.goto 896,59.45,21.91
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Autumnvale|r
.turnin 48678 >>Turn in Questionable Offerings
.accept 48679 >>Accept Mind the Hives
step
.goto 896,60.65,18.19,10,0 >>Go inside the Cave
.goto 896,60.62,17.77
.complete 48679,1 
step
>>Defend Edwin from the |cRXP_ENEMY_Bee's|r
.goto 896,60.62,17.77
.complete 48679,2 
step
.goto 896,60.65,18.19,10,0 >>Go outside the Cave
.goto 896,59.03,22.37
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Initiate Peony|r
.turnin 48679 >>Turn in Mind the Hives
.accept 48682 >>Accept A Simple Sacrifice
step
>>Kill |cRXP_ENEMY_Lord Autumnvale|r
.goto 896,56.50,24.05
.complete 48682,1 
step
.goto 896,56.49,24.01
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Edwin Maldus|r
.turnin 48682 >>Turn in A Simple Sacrifice
.accept 48683 >>Accept Changing Seasons
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Edwin Maldus|r
.goto 896,59.35,21.98
.complete 48683,1 
step
>>Click the |cRXP_PICK_Wickerman|r
.goto 896,59.35,21.98
.complete 48683,2 
step
.goto 896,59.35,21.98
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Edwin Maldus|r
.turnin 48683 >>Turn in Changing Seasons
step
.goto 896,63.25,27.05
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thomas Staughton|r
.accept 47946 >>Accept Save Their Bacon
.accept 47947 >>Accept Big Bad Wolves
.accept 47948 >>Accept Pork Chop
step
#sticky
#label bacon
.goto 896,64.07,31.70
>>Kill |cRXP_ENEMY_Beasts|r
.complete 47947,1 
step
>>Click on |cRXP_FRIENDLY_Pig Trevor|r
.goto 896,64.24,28.31
.complete 47946,1 
step
>>Click on |cRXP_FRIENDLY_Pig Travis|r
.goto 896,63.62,29.32
.complete 47946,2 
step
.goto 896,63.35,30.09
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Pig Effigy|r
.accept 47949 >>Accept That's Not My Fetish
step
>>Kill |cRXP_ENEMY_Roland|r
.goto 896,63.61,30.41
.complete 47948,1 
step
>>Click on |cRXP_FRIENDLY_Pig Purke|r
.goto 896,64.05,31.52
.complete 47946,4 
step
>>Click on |cRXP_FRIENDLY_Pig Kyle|r
.goto 896,64.70,30.21
.complete 47946,3 
step
#requires bacon
.goto 896,63.25,27.04
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thomas Staughton|r
.turnin 47946 >>Turn in Save Their Bacon
.turnin 47947 >>Turn in Big Bad Wolves
.turnin 47948,1 >>Turn in Pork Chop
.turnin 47949 >>Turn in That's Not My Fetish
.accept 47950 >>Accept Cured Ham
step
>>Use the Questitem in your Bags and throw the Pig Effigy in the Fire
.complete 47950,1 
.use 153432
step
.goto 896,63.25,27.05
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thomas Staughton|r
.turnin 47950 >>Turn in Cured Ham
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Cyril White by talking to Cyril White you skip the Ferry Step
.goto 896,56.14,35.29
.skipgossip 1
.complete 48622,2 
step
>>Click the |cRXP_PICK_Effigy|r
.goto 896,55.87,35.07
.complete 48622,3 
step
.goto 896,55.87,35.06
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cursed Effigy|r
.turnin 48622 >>Turn in The Vanishing Lord
step
.goto 896,56.13,35.30
>>Click the |cRXP_PICK_Major's Bulletin|r
.accept 47968 >>Accept Signs and Portents
step
>>Click the |cRXP_PICK_Letter|r
.goto 896,57.95,35.69
.complete 47968,2 
step
>>Click the |cRXP_PICK_Notebook|r
.goto 896,55.21,35.97
.complete 47968,3 
step
>>Click the |cRXP_PICK_Journal|r
.goto 896,55.27,35.48,5,0
.goto 896,53.22,35.13
.complete 47968,1 
step
.goto 896,55.64,35.74
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Fallhaven Ledger|r
.turnin 47968 >>Turn in Signs and Portents
.accept 47978 >>Accept The Wayward Crone
step
.goto 896,60.51,31.64
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Helena Gentle|r
.turnin 47978 >>Turn in The Wayward Crone
.accept 47979 >>Accept Witch Hunt
step
>>Click the |cRXP_PICK_Chair|r
.goto 896,60.48,31.59
.complete 47979,1 
.timer 13, Helene Gentle RP
step
.goto 896,60.58,31.47
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gentle's Spellbook|r
.accept 47981 >>Accept Cracking the Curse
step
.goto 896,60.85,30.64
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Fallhaven Villager|r
.accept 47980 >>Accept Furious Familiars
step
#sticky
#completewith Enthralled Wildlife
>>Kill the |cRXP_ENEMY_Wildlife|r in the Area
.complete 47980,1 
.mob Ensorcelled Bonepicker
.mob Bewitched Darkmaw
step
>>Click the |cRXP_PICK_Lesser Effigy|r
.goto 896,59.58,28.32
.complete 47981,1,1 
step
>>Kill |cRXP_ENEMY_Helena|r and Click the |cRXP_PICK_Lesser Effigy|r
.goto 896,57.79,28.14
.mob Helena
.complete 47979,2 
.complete 47981,1,2 
.goto 896,57.66,27.81
step
>>Click the |cRXP_PICK_Lesser Effigy|r
.goto 896,57.54,30.06
.complete 47981,1,3 
step
#label Enthralled Wildlife
>>Click the |cRXP_PICK_Lesser Effigy|r
.goto 896,56.15,29.09
.complete 47981,1,4 
step
#loop
.line 896,59.58,28.32,57.79,28.14,57.54,30.06,56.15,29.09
.goto 896,59.58,28.32,30,0
.goto 896,57.79,28.14,30,0
.goto 896,57.54,30.06,30,0
.goto 896,56.15,29.09,30,0
>>Kill the |cRXP_ENEMY_Wildlife|r in the Area
.complete 47980,1 
.mob Ensorcelled Bonepicker
.mob Bewitched Darkmaw
step
>>|cRXP_WARN_Select the option to turn in your quest from the pop-up in your quest log.|r
.turnin 47980 >>Turn in Furious Familiars
.turnin 47979 >>Turn in Witch Hunt
step
.goto 896,55.87,35.06
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cursed Effigy|r
.turnin 47981 >>Turn in Cracking the Curse
.accept 47982 >>Accept The Final Effigy
step
>>Click the |cRXP_PICK_Cursed Effigy|r
.goto 896,55.87,35.06
.complete 47982,1 
step
>>Kill the |cRXP_ENEMY_Deathcursed Terror|r
.complete 47982,2 
step
.goto 896,55.87,35.13
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cyril White|r
.turnin 47982,2 >>Turn in The Final Effigy
.accept 48108 >>Accept The Waycrest Daughter
step
.goto 896,55.74,34.99
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wanted Poster|r
.accept 51547 >>Accept WANTED: Rindlewoe
step
.goto 896,55.16,35.16
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Maude Rifthold|r
.accept 48948 >>Accept The North Pass Caverns
step
>>Kill |cRXP_ENEMY_Rindlewoe|r
>>|cRXP_WARN_Skip this Quest if it's too difficult|r
.goto 896,52.33,28.94
.complete 51547,1 
step
.goto 896,53.93,26.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thaddeus "Gramps" Rifthold|r
.turnin 48948 >>Turn in The North Pass Caverns
step
.goto 896,53.93,26.98
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thaddeus "Gramps" Rifthold|r
.accept 48793 >>Accept The Adventurer's Society
.accept 48792 >>Accept Menace to Society
step
#sticky
#label troggs
>>Kill Troggs
.complete 48792,1 
step
>>Click the |cRXP_PICK_Backpack|r
.goto 896,53.37,25.78
.skipgossip 1
.complete 48793,1 
step
>>Click the |cRXP_PICK_Scroll|r in the Cave
.goto 896,53.52,23.24
.complete 48793,2 
step
>>Click the |cRXP_PICK_Book|r
.goto 896,53.05,22.42
.complete 48793,3 
step
>>Click the |cRXP_PICK_Journal|r
.goto 896,51.81,24.14
.complete 48793,4 
step
.goto 896,51.37,23.27
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marcus Howlingdale|r
.turnin 48793 >>Turn in The Adventurer's Society
.accept 48804 >>Accept Mistakes Were Made
step
.goto 896,51.82,22.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tClick the |cRXP_PICK_Scroll|r
.accept 48805 >>Accept Research Recovery
step
>>Click the |cRXP_PICK_Disk|r
.goto 896,51.59,21.92
.complete 48805,2 
step
>>Interact with |cRXP_FRIENDLY_Amelia|r
.goto 896,51.66,21.46
.complete 48804,2 
step
>>Interact with |cRXP_FRIENDLY_Jonathan|r
.goto 896,52.67,20.97
.complete 48804,1 
step
.goto 896,50.76,20.22
.complete 48805,1 
step
>>Interact with |cRXP_FRIENDLY_Chase|r
.goto 896,50.64,22.09
.complete 48804,3 
step
>>Click the |cRXP_PICK_Shards|r
.goto 896,51.14,22.53
.complete 48805,3 
step
#requires troggs
.goto 896,50.61,24.30
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marcus Howlingdale|r
.turnin 48805 >>Turn in Research Recovery
.turnin 48804 >>Turn in Mistakes Were Made
.turnin 48792 >>Turn in Menace to Society
.accept 48853 >>Accept Terminal Degree
step
.goto 896,49.68,23.52
>>Kill |cRXP_ENEMY_Cragg|r
.complete 48853,1 
step
.goto 896,49.41,23.39
>>Interact with |cRXP_PICK_Nigel|r
.complete 48853,2 
step
.goto 896,50.59,24.42
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thaddeus "Gramps" Rifthold|r
.turnin 48853 >>Turn in Terminal Degree
step
.goto 896,55.87,35.13
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cyril White|r
.turnin 51547 >>Turn in WANTED: Rindlewoe
step
.goto 896,54.55,39.23
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Abby Lewis|r
.accept 47289 >>Accept Teddies and Tea
step
.goto 896,56.29,38.15
>>Click |cRXP_PICK_Plush 1|r
.complete 47289,3 
step
.goto 896,55.61,38.55
>>Click |cRXP_PICK_Plush 2|r
.complete 47289,1 
step
.goto 896,55.39,39.76
>>Click |cRXP_PICK_Plush 3|r
.complete 47289,2 
step
.goto 896,56.29,38.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Abby Lewis|r
.turnin 47289 >>Turn in Teddies and Tea
.accept 47428 >>Accept Kitty?
step
.goto 896,55.60,41.18
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Smoochums|r
.turnin 47428 >>Turn in Kitty?
step
.goto 896,54.55,39.23
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Abby Lewis|r
.accept 47289 >>Accept Teddies and Tea
step
.goto 896,55.39,39.76
.complete 47289,2 
step
.goto 896,55.61,38.55
.complete 47289,1 
step
.goto 896,56.29,38.15
.complete 47289,3 
step
.goto 896,56.29,38.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Abby Lewis|r
.turnin 47289 >>Turn in Teddies and Tea
.accept 47428 >>Accept Kitty?
step
.goto 896,55.60,41.18
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Smoochums|r
.turnin 47428 >>Turn in Kitty?
.accept 45079 >>Accept The Village of Glenbrook
step
.goto 896,55.53,45.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Samuel|r
.complete 45079,3 
step
.goto 896,57.16,46.42
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jonathan|r
.complete 45079,2 
step
.goto 896,53.15,44.43
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mary|r
.complete 45079,1 
step
.goto 896,54.74,49.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Annie Warren|r
.turnin 45079 >>Turn in The Village of Glenbrook
.accept 44785 >>Accept Tea Party
step
>>Follow the Waypoint
.goto 896,56.39,49.04
.complete 44785,1 
step
>>Click the |cRXP_PICK_Tea|r
.goto 896,58.19,47.90
.complete 44785,2 
step
>>Click the |cRXP_PICK_Monster|r
.goto 896,58.19,47.90
.complete 44785,3 
step
.goto 896,57.70,47.73
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Annie Warren|r
.turnin 44785 >>Turn in Tea Party
step
.goto 896,70.09,42.94
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Constable Henry Framer|r
.turnin 48108 >>Turn in The Waycrest Daughter
.accept 48283 >>Accept Standing Accused
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lucille Waycrest|r
.goto 896,70.09,42.94
.skipgossip 1
.complete 48283,1 
step
.goto 896,69.67,43.17
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal Everit Reade|r
.turnin 48283 >>Turn in Standing Accused
.accept 48109 >>Accept The Woods Have Eyes
.accept 48110 >>Accept In Case of Ambush
step
#sticky
#completewith Trap
>>Kill |cRXP_ENEMY_Ravens and Wolves|r
.complete 48109,2 
.complete 48109,1 
.mob Darkmaw Prowler
.mob Watchful Raven
step
.goto 896,68.97,44.00
>>Click the |cRXP_PICK_Trap|r
.complete 48110,1,1 
step
.goto 896,68.48,44.83
>>Click the |cRXP_PICK_Trap|r
.complete 48110,1,2 
step
.goto 896,68.03,44.76
>>Click the |cRXP_PICK_Trap|r
.complete 48110,1,3 
step
.goto 896,68.25,44.17
>>Click the |cRXP_PICK_Trap|r
.complete 48110,1,4 
step
.goto 896,67.57,43.01
>>Click the |cRXP_PICK_Trap|r
.complete 48110,1,5 
step
.goto 896,68.43,42.92
#label Trap
>>Click the |cRXP_PICK_Trap|r
.complete 48110,1,6 
step
>>Kill |cRXP_ENEMY_Ravens and Wolves|r
#loop
.line 896,68.97,44.00,68.48,44.83,68.03,44.76,68.25,44.17,67.57,43.01,68.43,42.92
.goto 896,68.97,44.00,30,0
.goto 896,68.48,44.83,30,0
.goto 896,68.03,44.76,30,0
.goto 896,68.25,44.17,30,0
.goto 896,67.57,43.01,30,0
.goto 896,68.43,42.92,30,0
.complete 48109,2 
.complete 48109,1 
.mob Darkmaw Prowler
.mob Watchful Raven
step
.goto 896,69.66,43.18
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marshal Everit Reade|r
.turnin 48109 >>Turn in The Woods Have Eyes
.turnin 48110 >>Turn in In Case of Ambush
step
.goto 896,70.08,42.82
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lucille Waycrest|r
.accept 48111 >>Accept Trial by Superstition
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Villager 1|r
.goto 896,69.89,42.83
.skipgossip 1
.complete 48111,1,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Villager 2|r
.goto 896,69.90,42.91
.skipgossip 1
.complete 48111,1,2 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Villager 3|r
.goto 896,69.98,42.99
.skipgossip 1
.complete 48111,1,3 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Villager 4|r
.goto 896,70.04,43.03
.skipgossip 1
.complete 48111,1,4 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Villager 5|
.goto 896,70.04,43.14
.skipgossip 1
.complete 48111,1,5 
step
.goto 896,70.08,42.83
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|trTalk to |cRXP_FRIENDLY_Lucille Waycrest|r
.turnin 48111 >>Turn in Trial by Superstition
.accept 48113 >>Accept A Pungent Solution
.accept 48165 >>Accept Harmful If Swallowed
.accept 48170 >>Accept Once Bitten, Twice Shy
step
>>Click the |cRXP_PICK_Jar|r
.goto 896,69.52,43.85
.complete 48170,1 
step
#completewith flies
>>Kill |cRXP_ENEMY_Saurolisks|r and Loot them for their |cRXP_LOOT_Glands|r
.complete 48165,1 
step
.goto 896,69.06,41.7
>>Click the |cRXP_PICK_Fly|r
.complete 48170,2,1 
step
.goto 896,68.7,41.33
>>Click the |cRXP_PICK_Fly|r
.complete 48170,2,2 
step
.goto 896,69.23,40.67
>>Click the |cRXP_PICK_Fly|r
.complete 48170,2,3 
step
.goto 896,69.02,40.16
>>Click the |cRXP_PICK_Fly|r
.complete 48170,2,4 
step
.goto 896,68.14,40.39
>>Click the |cRXP_PICK_Fly|r
.complete 48170,2,5 
step
#label flies
.goto 896,67.29,41.23
>>Click the |cRXP_PICK_Fly|r
.complete 48170,2,6 
step
.goto 896,66.91,42.17
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Adela Hawthorne|r
.accept 49242 >>Accept Quill or Be Quilled
step
#completewith next
>>Kill |cRXP_ENEMY_Quillrats|r
.complete 49242,1 
.mob Invasive Quillrat
step
>>Click the |cRXP_PICK_Onions|r on the Ground until you find the |cRXP_LOOT_Juicy Onion|r
#loop
.line 896,66.69,42.05,66.15,42.84,65.58,42.21,66.02,41.55
.goto 896,66.69,42.05,15,0
.goto 896,66.15,42.84,15,0
.goto 896,65.58,42.21,15,0
.goto 896,66.02,41.55,15,0
.complete 48113,1,1 
step
>>Kill |cRXP_ENEMY_Quillrats|r
#loop
.line 896,66.69,42.05,66.15,42.84,65.58,42.21,66.02,41.55
.goto 896,66.69,42.05,15,0
.goto 896,66.15,42.84,15,0
.goto 896,65.58,42.21,15,0
.goto 896,66.02,41.55,15,0
.complete 49242,1 
.mob Invasive Quillrat
step
.goto 896,66.93,42.16
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Adela Hawthorne|r
.turnin 49242 >>Turn in Quill or Be Quilled
step
#loop
.line 69.06,41.7,68.7,41.33,69.23,40.67,69.02,40.16,68.14,40.39
.goto 69.06,41.70,68.70,896,0
.goto 69.06,41.33,69.23,896,0
.goto 69.06,40.67,69.02,896,0
.goto 69.06,40.16,68.14,896,0
>>Kill |cRXP_ENEMY_Saurolisks|r and Loot them for their |cRXP_LOOT_Glands|r
.complete 48165,1 
step
.goto 896,70.07,42.82
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lucille Waycrest|r
.turnin 48113 >>Turn in A Pungent Solution
.turnin 48170 >>Turn in Once Bitten, Twice Shy
.turnin 48165 >>Turn in Harmful If Swallowed
step
.goto 896,71.80,50.41
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Art Hughie|r
.accept 48880 >>Accept Mean Gulls
.accept 48904 >>Accept Take the Bait
step
#completewith Guts
>>Kill |cRXP_ENEMY_Crabs|r Loot them for their |cRXP_LOOT_Meat|r
.complete 48904,1 
step
#completewith Guts
>>Kill Gulls
.complete 48880,1 
step
#completewith Guts
>>Click the Objects on the Ground
.complete 48882,1 
step
#label Guts
.goto 896,70.75,50.74
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Intact Mudfish|r
.accept 48882 >>Accept I Like Fish Guts and I Cannot Lie
step
#completewith Guts2
>>Kill |cRXP_ENEMY_Crabs|r Loot them for their |cRXP_LOOT_Meat|r
.complete 48904,1 
step
#completewith Guts2
>>Kill Gulls
.complete 48880,1 
step
#completewith Guts2
>>Click the Objects on the Ground
.complete 48882,1 
step
#label Guts2
.goto 896,71.14,52.34
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Fishing Rod|r
.accept 48881 >>Accept The Reel Deal
step
#completewith Guts3
>>Kill |cRXP_ENEMY_Crabs|r Loot them for their |cRXP_LOOT_Meat|r
.complete 48904,1 
step
#completewith Guts3
>>Kill Gulls
.complete 48880,1 
step
#completewith Guts3
>>Click the Objects on the Ground
.complete 48882,1 
step
#label Guts3
>>Click the Rod
.goto 896,71.24,51.68
.complete 48881,1,1 
step
#completewith Guts4
>>Kill |cRXP_ENEMY_Crabs|r Loot them for their |cRXP_LOOT_Meat|r
.complete 48904,1 
step
#completewith Guts4
>>Kill Gulls
.complete 48880,1 
step
#completewith Guts4
>>Click the Objects on the Ground
.complete 48882,1 
step
#label Guts4
>>Click the Rod
.goto 896,71.08,52.84
.complete 48881,1,2 
step
#completewith Guts5
>>Kill |cRXP_ENEMY_Crabs|r Loot them for their |cRXP_LOOT_Meat|r
.complete 48904,1 
step
#completewith Guts5
>>Kill Gulls
.complete 48880,1 
step
#completewith Guts5
>>Click the Objects on the Ground
.complete 48882,1 
step
#label Guts5
>>Click the Rod
.goto 896,70.83,53.43
.complete 48881,1,3 
step
#completewith Guts6
>>Kill |cRXP_ENEMY_Crabs|r Loot them for their |cRXP_LOOT_Meat|r
.complete 48904,1 
step
#completewith Guts6
>>Kill Gulls
.complete 48880,1 
step
#completewith Guts6
>>Click the Objects on the Ground
.complete 48882,1 
step
#label Guts6
>>Click the Rod
.goto 896,70.49,54.14
.complete 48881,1,4 
step
#completewith Guts7
>>Kill |cRXP_ENEMY_Crabs|r Loot them for their |cRXP_LOOT_Meat|r
.complete 48904,1 
step
#completewith Guts7
>>Kill Gulls
.complete 48880,1 
step
#completewith Guts7
>>Click the Objects on the Ground
.complete 48882,1 
step
#label Guts7
>>Click the Rod
.goto 896,70.11,55.07
.complete 48881,1,5 
step
.goto 896,69.69,55.52
>>Click the Quest Popup's in your Questlog to turn in the Quest
.turnin 48881 >>Turn in The Reel Deal
step
>>If you haven't finished it yet
.complete 48904,1 
.complete 48880,1 
.complete 48882,1 
step
.goto 896,71.80,50.42
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Art Hughie|r
.turnin 48880 >>Turn in Mean Gulls
.turnin 48882 >>Turn in I Like Fish Guts and I Cannot Lie
.turnin 48904 >>Turn in Take the Bait
.accept 48883 >>Accept Big Gulls Won't Die
step
>>Kill Brinebeak
.goto 896,71.46,49.11
.complete 48883,1 
step
.goto 896,71.81,50.41
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Art Hughie|r
.turnin 48883 >>Turn in Big Gulls Won't Die
step
.goto 896,62.62,42.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Caretaker Allen
.accept 48475 >>Accept Seeing Spirits
step
>>Click Graveblooms in the Area
.goto 896,60.31,44.88
.complete 48475,1 
step
>>Click the Ritual Urn
.goto 896,59.99,45.86
.complete 48475,2 
step
>>Click Aaron
.goto 896,60.75,46.60
.complete 48475,3 
step
.goto 896,60.75,46.60
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Aaron Cresterly|r
.turnin 48475 >>Turn in Seeing Spirits
.accept 48476 >>Accept Split Party
step
>>Kill Wicker-Bound Hunter
.goto 896,60.32,47.96
.complete 48476,1 
step
.goto 896,59.80,48.94
>>wait for the small roleplay
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Bridget Fairwater|r
.turnin 48476 >>Turn in Split Party
.accept 48477 >>Accept Looking For One More
step
>>Kill Sister Westwood
.goto 896,59.07,50.33
.complete 48477,1 
step
.goto 896,59.50,51.19
>>Wait for the Small Roleplay
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mercy Fairwater|r
.turnin 48477 >>Turn in Looking For One More
step
.goto 896,64.58,54.81
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rebecca Hale|r
.accept 52074 >>Accept Deliverance
step
.goto 896,61.91,59.29
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ranger Wons|r
.turnin 52074 >>Turn in Deliverance
.accept 48179 >>Accept Rescue Rangers
.accept 52075 >>Accept Boned
step
.goto 896,61.87,59.34
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thornspeaker Birchgrove|r
.accept 48182 >>Accept Total Cairnage
.accept 48183 >>Accept The Hills Are Alive
step
>>Kill the Skeletons
#completewith 1
.complete 52075,1 
step
>>Click the Injured Npcs or Heal the Npcs
#completewith 1
.complete 48179,1 
step
#completewith 1
>>Kill |cRXP_ENEMY_Elementals|r Loot them for their |cRXP_LOOT_Cores|r
.complete 48183,1 
step
#label 1
>>Click the Ancient Cairn
.goto 896,60.89,60.96
.complete 48182,1,1 
step
>>Kill Skeletons
#completewith 2
.complete 52075,1 
step
>>Click the Injured Npcs or Heal the Npcs
#completewith 2
.complete 48179,1 
step
#completewith 2
>>Kill |cRXP_ENEMY_Elementals|r Loot them for their |cRXP_LOOT_Cores|r
.complete 48183,1 
step
#label 2
>>Click the Ancient Cairn
.goto 896,62.55,64.68
.complete 48182,1,2 
step
>>Kill Skeletons
#completewith 3
.complete 52075,1 
step
>>Click the Injured Npcs or Heal the Npcs
#completewith 3
.complete 48179,1 
step
#completewith 3
>>Kill |cRXP_ENEMY_Elementals|r Loot them for their |cRXP_LOOT_Cores|r
.complete 48183,1 
step
#label 3
>>Click the Ancient Cairn
.goto 896,59.46,63.74
.complete 48182,1,3 
step
.goto 896,58.45,63.17
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Arthur Tradewind|r
.accept 48180 >>Accept Really Big Problem
step
>>There are Scrolls near the Sentinel to make the fight easier
>>Kill the Ancient Sentinel
.complete 48180,1 
step
>>Kill Skeletons
#completewith 4
.complete 52075,1 
step
>>Click the Injured Npcs or Heal the Npcs
#completewith 4
.complete 48179,1 
step
#completewith 4
>>Kill |cRXP_ENEMY_Elementals|r Loot them for their |cRXP_LOOT_Cores|r
.complete 48183,1 
step
#label 4
>>Click the Ancient Cairn
.goto 896,59.34,66.25
.complete 48182,1,4 
step
>>Kill Skeletons
#completewith 5
.complete 52075,1 
step
>>Click the Injured Npcs or Heal the Npcs
#completewith 5
.complete 48179,1 
step
#completewith 5
>>Kill |cRXP_ENEMY_Elementals|r Loot them for their |cRXP_LOOT_Cores|r
.complete 48183,1 
step
#label 5
>>Click the Major Ancient Cairn
.goto 896,59.14,67.88
.complete 48182,2
step
>>If you haven't finished it yet
.complete 52075,1 
.complete 48179,1 
.complete 48183,1 
step
.goto 896,61.88,59.33
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thornspeaker Birchgrove|r
.turnin 48180 >>Turn in Really Big Problem
.turnin 48182 >>Turn in Total Cairnage
.turnin 48183 >>Turn in The Hills Are Alive
step
.goto 896,61.91,59.29
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ranger Wons|r
.turnin 48179,2 >>Turn in Rescue Rangers
.turnin 52075 >>Turn in Boned
step
>>Use Hearthstone
#completewith next
.hs >> Hearthstone to Boralus
step
>>Done
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#name ZA_WarCampaign
#displayname Final Chapter - Zuldazar War Campaign
<<Alliance
step
#completewith Brigadier Thom
.goto 1161,67.96,26.66
.gossipoption 48168 >>Talk to |cRXP_FRIENDLY_Grand Admiral Jes-Tereth|r
.target Grand Admiral Jes-Tereth
step
#label Brigadier Thom
.goto 862,77.54,54.58
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brigadier Thom|r
.turnin 51308 >>Turn in Zuldazar Foothold
.accept 51201 >>Accept The Troll's Tale
.target Brigadier Thom
step
.goto 862,77.51,54.6
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_ENEMY_Captured Zandalari Troll|r
>>|cRXP_WARN_Press "Escape" on your keyboard to skip the cinematic.|r
.skipgossip 1
.complete 51201,1 
.target Captured Zandalari Troll
step
.goto 862,77.54,54.58
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brigadier Thom|r
.turnin 51201 >>Turn in The Troll's Tale
.accept 51190 >>Accept Granting a Reprieve
.accept 51544 >>Accept Disarming the Cannons
.target Brigadier Thom
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Medic Feorea|r and |cRXP_FRIENDLY_Degdod|r
.accept 51191 >>Accept Save Them All
.goto 862,77.13,55.54
.accept 51192 >>Accept A Lack of Surplus
.accept 51193 >>Accept That One's Mine
.goto 862,77.13,55.59
.target Degdod
.target Medic Feorea
step
#completewith ZandalariForsakens
>>Kill |cRXP_ENEMY_Zandalari|r and |cRXP_ENEMY_Forsakens.|r
.complete 51190,2 
.complete 51190,1 
.mob Zandalari Quickblade
.mob Forsaken Deathguard
.mob Zandalari Axe Thrower
.mob Bleak Conjurer
step
.goto 862,78.46,52.01
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Crate|r on the Ground.
.complete 51192,1,1 
step
.goto 862,78.51,51.95
>>Interact with the |cRXP_FRIENDLY_Injured Sailor|r
.complete 51191,1,1 
.use 160433
.target Injured Shipwrecked Sailor
step
.goto 862,78.55,53.05
>>Interact with the |cRXP_FRIENDLY_Injured Sailor|r
.complete 51191,1,2 
.use 160433
.target Injured Shipwrecked Sailor
step
.goto 862,79.00,53.96
>>Interact with the |cRXP_FRIENDLY_Injured Sailor|r
.complete 51191,1,3 
.use 160433
.target Injured Shipwrecked Sailor
step
.goto 862,79.71,53.63
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Crate|r on the Ground.
.complete 51192,1,2 
step
.goto 862,79.52,55.02
>>Interact with the |cRXP_FRIENDLY_Injured Sailor|r
.complete 51191,1,4 
.use 160433
.target Injured Shipwrecked Sailor
step
.goto 862,80.14,55.02
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Crate|r on the Ground.
.complete 51192,1,3 
step
.goto 862,80.19,55.26
>>Interact with the |cRXP_FRIENDLY_Injured Sailor|r
.complete 51191,1,5 
.use 160433
.target Injured Shipwrecked Sailor
step
.goto 862,80.96,54.31
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Crate|r on the Ground.
.complete 51192,1,4 
step
.goto 862,80.90,53.69
>>Interact with the |cRXP_FRIENDLY_Injured Sailor|r
.complete 51191,1,5 
.use 160433
.target Injured Shipwrecked Sailor
step
.goto 862,80.90,53.69
>>Interact with the |cRXP_FRIENDLY_Injured Sailor|r
.complete 51191,1,6 
.use 160433
.target Injured Shipwrecked Sailor
step
.goto 862,80.81,53.27
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Crate|r on the Ground.
.complete 51192,1,5 
step
.goto 862,80.93,53.44
>>Interact with the |cRXP_FRIENDLY_Injured Sailor|r
.complete 51191,1,7 
.use 160433
.target Injured Shipwrecked Sailor
step
.goto 862,80.89,53.39
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Crate|r on the Ground.
.complete 51192,1,6 
step
.goto 862,81.09,53.86
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Crate|r on the Ground.
.complete 51192,1,7 
step
.goto 862,81.47,53.84
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Crate|r on the Ground.
.complete 51192,1,8 
step
.goto 862,81.52,53.78
>>Interact with the |cRXP_FRIENDLY_Injured Sailor|r
.complete 51191,1,8 
.use 160433
.target Injured Shipwrecked Sailor
step
.goto 862,83.35,54.73
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Cannon|r
.complete 51544,1,1 
step
.goto 862,83.34,54.4
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Cannon|r
.complete 51544,1,2 
step
.goto 862,83.34,54.21
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Cannon|r
.complete 51544,1,3 
step
#label ZandalariForsakens
.goto 862,81.94,51.43
>>Kill|cRXP_ENEMY_ Major Alan Hawkins|r and loot him for his |T133041:0|t|cRXP_LOOT_Hammer|r
|cRXP_WARN_Kill the remaining Zandalari and Forsakens|r
.complete 51193,1 
step
#loop
.line 862,80.71,52.64;79.85,53.56,80.82,55.67,82.23,54.63
.goto 862,80.71,80.82,15,0
.goto 862,53.56,82.23,15,0
>>Kill |cRXP_ENEMY_Zandalari|r and |cRXP_ENEMY_Forsakens.|r
.complete 51190,2 
.complete 51190,1 
.mob Zandalari Quickblade
.mob Forsaken Deathguard
.mob Zandalari Axe Thrower
.mob Bleak Conjurer
step
.goto 862,77.54,54.58
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Brigadier Thom|r
.turnin 51190 >>Turn in Granting a Reprieve
.turnin 51544 >>Turn in Disarming the Cannons
.target Brigadier Thom
step
.goto 862,77.12,55.54
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Medic Feorea|r
.turnin 51191 >>Turn in Save Them All
.target Medic Feorea
step
.goto 862,77.13,55.59
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Degdod|r
.turnin 51192 >>Turn in A Lack of Surplus
.turnin 51193 >>Turn in That One's Mine
.target Degdod
step
.goto 862,77.50,55.22
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kelsey Steelspark|r
.accept 51418 >>Accept Xibala
.target Kelsey Steelspark
step
.goto 862,80.35,55.41
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_FRIENDLY_boat|r
.complete 51418,1 
.timer 128,Travel to Xibala RP
step
.goto 862,40.74,70.84
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Anvil-Thane Thurgaden|r
.turnin 51418 >>Turn in Xibala
.accept 51331 >>Accept Mole Machinations
.accept 51309 >>Accept Rocks of Ragnaros
.target Anvil-Thane Thurgaden
step
.goto 862,39.56,72.78
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Slag|r
.complete 51309,1,1 
step
.goto 862,39.62,72.86
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Slag|r
.complete 51309,1,2 
step
.goto 862,39.57,73.13
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Mole Machine|r
.complete 51331,1,1 
step
.goto 862,39.63,73.45
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Slag|r
.complete 51309,1,3 
step
.goto 862,39.63,73.52
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Slag|r
.complete 51309,1,4 
step
.goto 862,39.58,73.61
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Slag|r
.complete 51309,1,5 
step
.goto 862,39.37,73.7
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Mole Machine|r
.complete 51331,1,2 
step
.goto 862,39.15,73.86
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Slag|r
.complete 51309,1,6 
step
.goto 862,39.11,73.82
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Slag|r
.complete 51309,1,7 
step
.goto 862,39.05,73.79
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Slag|r
.complete 51309,1,8 
step
.goto 862,39.12,73.67
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Slag|r
.complete 51309,1,9 
step
.goto 862,39.1,72.98
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Mole Machine|r
.complete 51331,1,3 
step
.goto 862,39.03,72.35
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Mole Machine|r
.complete 51331,1,4 
step
.goto 862,40.74,70.85
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Anvil-Thane Thurgaden|r
.turnin 51331 >>Turn in Mole Machinations
.turnin 51309 >>Turn in Rocks of Ragnaros
.accept 51359 >>Accept Fragment of the Firelands
.target Anvil-Thane Thurgaden
step
.goto 862,40.65,70.88
>>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_FRIENDLY_Unstable Magma|r
.complete 51359,1 
.use 160058
.target Unstable Magma
step
.goto 862,32.92,69.69
>>To effectively kill the |cRXP_ENEMY_Goblins|r, use |T135808:0|t(2) when it's available and switch to |T525023:0|t(1) when |T135808:0|t(2) is on cooldown.
.complete 51359,2 
step
#completewith next
+Press the ability |T236372:0|tDismiss Magma Elemental
step
.goto 862,40.74,70.84
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Anvil-Thane Thurgaden|r
.turnin 51359 >>Turn in Fragment of the Firelands
.target Anvil-Thane Thurgaden
step
.goto 862,40.77,70.67
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kelsey Steelspark|r
.turnin 52003 >>Turn in Champion: Kelsey S
.accept 51968 >>Accept Talk to Boralus
.target Kelsey Steelspark
step
.goto 862,40.46,71.02
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Daria|r
.complete 51968,1 
.skipgossip 1
.target Daria Smithson
step
.goto 1161,69.29,26.99
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Halford Wyrmbane|r
.turnin 51968 >>Turn in Return to Boralus
.target Halford Wyrmbane
step
.next << 5
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Human Heritage Quests (A)
#displayname |cRXP_WARN_Chapter 4 -|r Human Heritage Quests
#next 6) Item Information (A)
<<Alliance Human
step
#include 4) Human Heritage Armor
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Nightelf Heritage Quests (A)
#displayname |cRXP_WARN_Chapter 4 -|r Nightelf Heritage Quests
#next 6) Item Information (A)
<<Alliance NightElf
step
#include 5) Nightelf Heritage Armor
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Dwarf Heritage Quests (A)
#displayname |cRXP_WARN_Chapter 4 -|r Dwarf Heritage Quests
#next 6) Item Information (A)
<<Alliance Dwarf
step
#include 5) Dwarf Heritage Armor
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Gnome Heritage Quests (A)
#displayname |cRXP_WARN_Chapter 4 -|r Gnome Heritage Quests
#next 6) Item Information (A)
<<Alliance Gnome
step
#include 5) Gnome Heritage Armor
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Worgen Heritage Quests (A)
#displayname |cRXP_WARN_Chapter 4 -|r Worgen Heritage Quests
#next 6) Item Information (A)
<<Alliance Worgen
step
#include 5) Worgen Heritage Armor
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 5) Draenei Heritage Quests (A)
#displayname |cRXP_WARN_Chapter 4 -|r Draenei Heritage Quests
#next 6) Item Information (A)
<<Alliance Draenei
step
#include 5) Draenei Heritage Armor
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 8) Turnin Route Hearthstone Locations (A)
#displayname |cRXP_WARN_Chapter 7 -|r Hearthstone Location for Turnins
#next 9) Turnin Route Alliance (A)
<< Alliance
step
#include 8) Turnin Route Hearthstone Locations
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 9) Turnin Route Alliance (A)
#displayname |cRXP_WARN_Chapter 8 -|r Turnin Route
<< Alliance
step
#include 9) Turnin Route Alliance
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP The War Within
#subgroup War Within Preparation
#name 9b) PoP-UP Quests Turnins (A)
#displayname |cRXP_WARN_Final Chapter -|r PoP-UP Quests Turnins
<< Alliance
step
#include 9b) PoP-UP Quests Turnins
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#subgroup Dragonflight (New Player)
#displayname Chapter 1 - The Waking Shores
#name a) The Waking Shores Fresh (A)
#next b) Ohn'ahran Plain Fresh (A)
<< Alliance
step
#include a) The Waking Shores Fresh
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP Speedrun Guide
#subgroup Dragonflight (New Player)
#name b) Ohn'ahran Plain Fresh (A)
#displayname Chapter 2 - Ohn'ahran Plains
#next c) The Azure Span Fresh (A)
<< Alliance
step
#include b) Ohn'ahran Plain Fresh
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP Speedrun Guide
#subgroup Dragonflight (New Player)
#displayname Chapter 3 - The Azure Span
#name c) The Azure Span Fresh (A)
#next d) Thaldraszus Fresh (A)
<< Alliance
step
#include c) The Azure Span Fresh
]])
RXPGuides.RegisterGuide([[
#df
#version 4
#group RestedXP Speedrun Guide
#subgroup Dragonflight (New Player)
#name d) Thaldraszus Fresh (A)
#displayname Chapter 4 - Thaldraszus
<< Alliance
step
#include d) Thaldraszus Fresh
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Only (70 -76)
#name a) Isle of Dorn Campaign (A)
#displayname |cRXP_WARN_Chapter 1|r - Isle of Dorn
#title Isle of Dorn Campaign
#next b) The Ringing Deeps Campaign (A)
#subweight 9
<< Alliance
step
#include a) Isle of Dorn Campaign
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Only (70 -76)
#name b) The Ringing Deeps Campaign (A)
#displayname |cRXP_WARN_Chapter 2|r - The Ringing Deeps
#title The Ringing Deeps Campaign
#next c) Hallowfall Campaign (A)
#subweight 9
<< Alliance
step
#include b) The Ringing Deeps Campaign
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Only (70 -76)
#name c) Hallowfall Campaign (A)
#displayname |cRXP_WARN_Chapter 3|r - Hallowfall
#title Hallowfall Campaign
#next d) Azj-kahet Campaign (A)
#subweight 9
<< Alliance
step
#include c) Hallowfall Campaign
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Only (70 -76)
#name d) Azj-kahet Campaign (A)
#displayname |cRXP_WARN_Chapter 4|r - Azj-kahet
#title Azj-kahet Campaign
#subweight 9
<< Alliance
step
#include d) Azj-kahet Campaign
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling (70-80)
#name a) Isle of Dorn Campaign + Side Quests (A)
#displayname |cRXP_WARN_Chapter 1|r - Isle of Dorn (1/2)
#title Isle of Dorn Leveling 1
#next b) The Ringing Deeps Campaign + Side Quests (A)
#subweight 8
<< Alliance
step
#include a) Isle of Dorn Campaign + Side Quests
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling (70-80)
#name b) The Ringing Deeps Campaign + Side Quests (A)
#displayname |cRXP_WARN_Chapter 2|r - The Ringing Deeps
#title The Ringing Deeps Leveling
#next c) Hallowfall Campaign + Side Quests (A)
#subweight 8
<< Alliance
step
#include b) The Ringing Deeps Campaign + Side Quests
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling (70-80)
#name c) Hallowfall Campaign + Side Quests (A)
#displayname |cRXP_WARN_Chapter 3|r - Hallowfall
#title Hallowfall Leveling
#next d) Azj-kahet Campaign + Side Quests (A)
#subweight 8
<< Alliance
step
#include c) Hallowfall Campaign + Side Quests
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling (70-80)
#name d) Azj-kahet Campaign + Side Quests (A)
#displayname |cRXP_WARN_Chapter 4|r - Azj-kahet
#next e) Isle of Dorn Campaign + Side Quests (A)
#title Azj-kahet Leveling
#subweight 8
<< Alliance
step
#include d) Azj-kahet Campaign + Side Quests
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling (70-80)
#name e) Isle of Dorn Campaign + Side Quests (A)
#displayname |cRXP_WARN_Chapter 5|r - Isle of Dorn (2/2)
#title Isle of Dorn Leveling 2
#subweight 8
<< Alliance
step
#include e) Isle of Dorn Campaign + Side Quests
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Adventure Mode (70-80)
#name a) Intro Scenario War Within (A)
#displayname |cRXP_WARN_Chapter 0|r - Intro Scenario (Optional)
#title Intro Scenario
#next a) Isle of Dorn Adventure Mode 1 (A)
<< Alliance
step
#include a) Intro Scenario War Within
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Adventure Mode (70-80)
#name a) Isle of Dorn Adventure Mode 1 (A)
#displayname |cRXP_WARN_Chapter 1|r - Isle of Dorn (1/2)
#title Isle of Dorn Adventure Mode 1
#next b) Azjkahet Adventure Mode 1 (A)
#subweight 7
<< Alliance
step
#include a) Isle of Dorn Adventure Mode 1
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Adventure Mode (70-80)
#name b) Azjkahet Adventure Mode 1 (A)
#displayname |cRXP_WARN_Chapter 2|r - Azj-kahet (1/2)
#title Azj-kahet Adventure Mode 1
#next c) Hallowfall Adventure Mode (A)
#subweight 7
<< Alliance
step
#include b) Azjkahet Adventure Mode 1
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Adventure Mode (70-80)
#name c) Hallowfall Adventure Mode (A)
#displayname |cRXP_WARN_Chapter 3|r - Hallowfall
#title Hallowfall Adventure Mode
#next d) Azjkahet Adventure Mode 2 (A)
#subweight 7
<< Alliance
step
#include c) Hallowfall Adventure Mode
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Adventure Mode (70-80)
#name d) Azjkahet Adventure Mode 2 (A)
#displayname |cRXP_WARN_Chapter 4|r - Azj-kahet (2/2)
#title Azj-kahet Adventure Mode 2
#next e) Isle of Dorn Adventure Mode 2 (A)
#subweight 7
<< Alliance
step
#include d) Azjkahet Adventure Mode 2
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Adventure Mode (70-80)
#name e) Isle of Dorn Adventure Mode 2 (A)
#displayname |cRXP_WARN_Chapter 5|r - Isle of Dorn (2/2)
#title Isle of Dorn Adventure Mode 2
#next f) The Ringing Deeps Adventure Mode (A)
#subweight 7
<< Alliance
step
#include e) Isle of Dorn Adventure Mode 2
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Adventure Mode (70-80)
#name f) The Ringing Deeps Adventure Mode (A)
#displayname |cRXP_WARN_Chapter 6|r - The Ringing Deeps
#title Ringing Deeps Adventure Mode
#subweight 7
<< Alliance
step
#include f) The Ringing Deeps Adventure Mode
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Only Multibox (70 -76)
#name a) Isle of Dorn Campaign Multibox (A)
#displayname |cRXP_WARN_Chapter 1|r - Isle of Dorn MB
#title Isle of Dorn Campaign MB
#next b) The Ringing Deeps Campaign Multibox (A)
#subweight 9
<< Alliance
step
#include a) Isle of Dorn Campaign Multibox
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Only Multibox (70 -76)
#name b) The Ringing Deeps Campaign Multibox (A)
#displayname |cRXP_WARN_Chapter 2|r - The Ringing Deeps MB
#title The Ringing Deeps Campaign MB
#next c) Hallowfall Campaign Multibox (A)
#subweight 9
<< Alliance
step
#include b) The Ringing Deeps Campaign Multibox
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Only Multibox (70 -76)
#name c) Hallowfall Campaign Multibox (A)
#displayname |cRXP_WARN_Chapter 3|r - Hallowfall MB
#title Hallowfall Campaign MB
#next d) Azj-kahet Campaign Multibox (A)
#subweight 9
<< Alliance
step
#include c) Hallowfall Campaign Multibox
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Only Multibox (70 -76)
#name d) Azj-kahet Campaign Multibox (A)
#displayname |cRXP_WARN_Chapter 4|r - Azj-kahet MB
#title Azj-kahet Campaign MB
#subweight 9
<< Alliance
step
#include d) Azj-kahet Campaign Multibox
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling Multibox (70-80)
#name a) Isle of Dorn Campaign + Side Quests MB (A)
#displayname |cRXP_WARN_Chapter 1|r - Isle of Dorn MB (1/2)
#title Isle of Dorn Leveling MB 1
#next b) The Ringing Deeps Campaign + Side Quests MB (A)
#subweight 8
<< Alliance
step
#include a) Isle of Dorn Campaign + Side Quests MB
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling Multibox (70-80)
#name b) The Ringing Deeps Campaign + Side Quests MB (A)
#displayname |cRXP_WARN_Chapter 2|r - The Ringing Deeps MB
#title Ringing Deeps Leveling MB
#next c) Hallowfall Campaign + Side Quests MB (A)
#subweight 8
<< Alliance
step
#include b) The Ringing Deeps Campaign + Side Quests MB
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling Multibox (70-80)
#name c) Hallowfall Campaign + Side Quests MB (A)
#displayname |cRXP_WARN_Chapter 3|r - Hallowfall MB
#title Hallowfall Leveling MB
#next d) Azj-kahet Campaign + Side Quests MB (A)
#subweight 8
<< Alliance
step
#include c) Hallowfall Campaign + Side Quests MB
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling Multibox (70-80)
#name d) Azj-kahet Campaign + Side Quests MB (A)
#displayname |cRXP_WARN_Chapter 4|r - Azj-kahet MB
#title Azj-kahet Leveling MB
#next e) Isle of Dorn Campaign + Side Quests MB (A)
#subweight 8
<< Alliance
step
#include d) Azj-kahet Campaign + Side Quests MB
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Campaign Leveling Multibox (70-80)
#name e) Isle of Dorn Campaign + Side Quests MB (A)
#displayname |cRXP_WARN_Chapter 5|r - Isle of Dorn MB (2/2)
#title Isle of Dorn Leveling MB 2
#subweight 8
<< Alliance
step
#include e) Isle of Dorn Campaign + Side Quests MB
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name a) Spores of Dread (A)
#displayname Spores of Dread
#subweight 4
<< Alliance
step
#include a) Spores of Dread
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name b) Behind Closed Doors (A)
#displayname Behind Closed Door
#subweight 4
<< Alliance
step
#include b) Behind Closed Doors
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name c) Seven Soldiers (A)
#displayname Seven Soldiers
#subweight 4
<< Alliance
step
#include c) Seven Soldiers
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name d) Lost Lord of the Storm (A)
#displayname Lost Lord of the Storm
#subweight 4
<< Alliance
step
#include d) Lost Lord of the Storm
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name e) Hope, An Anomaly (A)
#displayname Hope, An Anomaly
#subweight 4
<< Alliance
step
#include e) Hope, An Anomaly
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name f) The Hermit (A)
#displayname The Hermit
#subweight 4
<< Alliance
step
#include f) The Hermit
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name g) A Titanic Expedition (A)
#displayname A Titanic Expedition
#subweight 4
<< Alliance
step
#include g) A Titanic Expedition
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name h) Remember Me, Earthen (A)
#displayname Remember Me, Earthen
#subweight 4
<< Alliance
step
#include h) Remember Me, Earthen
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name i) All Ore Nothing (A)
#displayname All Ore Nothing
#subweight 4
<< Alliance
step
#include i) All Ore Nothing
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name i) Heart of Stone (A)
#displayname Heart of Stone
#subweight 4
<< Alliance
step
#include i) Heart of Stone
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name i) Cloud Fishing (A)
#displayname Cloud Fishing
#subweight 4
<< Alliance
step
#include i) Cloud Fishing
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Isle of Dorn Storylines
#name i) The Opalcreg (A)
#displayname The Opalcreg
#subweight 4
<< Alliance
step
#include i) The Opalcreg
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name e) Envenomed Invasion (A)
#displayname Envenomed Invasion
#title Envenomed Invasion
#subweight 3
<< Alliance
step
#include e) Envenomed Invasion
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name p) Frolicking in the Fetid Grotto (A)
#displayname Frolicking in the Fetid Grotto
#title Frolicking in the Fetid Grotto
#subweight 3
<< Alliance
step
#include p) Frolicking in the Fetid Grotto
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name d) Dread in the Den (A)
#displayname Dread in the Den
#subweight 3
<< Alliance
step
#include d) Dread in the Den
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name f) Fearbreaker (A)
#displayname Fearbreaker
#subweight 3
<< Alliance
step
#include f) Fearbreaker
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name n) Revenge in the Rumbling Wastes (A)
#displayname Revenge in the Rumbling Wastes
#subweight 3
<< Alliance
step
#include n) Revenge in the Rumbling Wastes
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name o) Tired of Rest (A)
#displayname Tired of Rest
#subweight 3
<< Alliance
step
#include o) Tired of Rest
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name c) Routine Maintenance (A)
#displayname Routine Maintenance
#subweight 3
<< Alliance
step
#include c) Routine Maintenance
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name g) Into the Fog (A)
#displayname Into the Fog
#subweight 3
<< Alliance
step
#include g) Into the Fog
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name m) Abysmal Extraction (A)
#displayname Abysmal Extraction
#subweight 3
<< Alliance
step
#include m) Abysmal Extraction
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name a) The Caretaker of Brunwin's Terrace (A)
#displayname The Caretaker of Brunwin's Terrace
#subweight 3
<< Alliance
step
#include a) The Caretaker of Brunwin's Terrace
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name h) Magma-nificence (A)
#displayname Magma-nificence
#subweight 3
<< Alliance
step
#include h) Magma-nificence
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name l) Rampage at Nibelgaz Mine (A)
#displayname Rampage at Nibelgaz Mine
#subweight 3
<< Alliance
step
#include l) Rampage at Nibelgaz Mine
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup The Ringing Deeps Storylines
#name k) Kobold Candles/Crew/Story (A)
#displayname Kobold Candles/Crew/Story
#subweight 3
<< Alliance
step
#include k) Kobold Candles/Crew/Story
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name a) Light of Velhan's Claim (A)
#displayname Light of Velhan's Claim
#subweight 2
<< Alliance
step
#include a) Light of Velhan's Claim
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name b) The Priory (A)
#displayname The Priory
#subweight 2
<< Alliance
step
#include b) The Priory
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name m) What Grows in the Dark (A)
#displayname What Grows in the Dark
#subweight 2
<< Alliance
step
#include m) What Grows in the Dark
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name l) The Mysterious Chef (A)
#displayname The Mysterious Chef
#subweight 2
<< Alliance
step
#include l) The Mysterious Chef
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name f) Crushing Depths (A)
#displayname Crushing Depths
#subweight 2
<< Alliance
step
#include f) Crushing Depths
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name n) Suspicious Minds (A)
#displayname Suspicious Minds
#subweight 2
<< Alliance
step
#include n) Suspicious Minds
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name e) The Sky's the Limit (A)
#displayname The Sky's the Limit
#subweight 2
<< Alliance
step
#include e) The Sky's the Limit
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name i) Apart for Purpose (A)
#displayname Apart for Purpose
#subweight 2
<< Alliance
step
#include i) Apart for Purpose
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name g) The Last Mage of Hallowfall (A)
#displayname The Last Mage of Hallowfall
#subweight 2
<< Alliance
step
#include g) The Last Mage of Hallowfall
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Hallowfall Storylines
#name c) Striking Steel (A)
#displayname Striking Steel
#subweight 2
<< Alliance
step
#include c) Striking Steel
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name h) The Second Front (A)
#displayname The Second Front
#subweight 1
<< Alliance
step
#include h) The Second Front
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name b) Pillar-nest Vosh (A)
#displayname Pillar-nest Vosh
#subweight 1
<< Alliance
step
#include b) Pillar-nest Vosh
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name m) Silken Ward (A)
#displayname Silken Ward
#subweight 1
<< Alliance
step
#include m) Silken Ward
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name n) Grieve & Weave (A)
#displayname Grieve & Weave
#subweight 1
<< Alliance
step
#include n) Grieve & Weave
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name i) Mr. Sunflower's Therapy (A)
#displayname Mr. Sunflower's Therapy
#subweight 1
<< Alliance
step
#include i) Mr. Sunflower's Therapy
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name c) Gutter Work (A)
#displayname Gutter Work
#subweight 1
<< Alliance
step
#include c) Gutter Work
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name j) The Wild Camp (A)
#displayname The Wild Camp
#subweight 1
<< Alliance
step
#include j) The Wild Camp
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name f) The Wormlands (A)
#displayname The Wormlands
#subweight 1
<< Alliance
step
#include f) The Wormlands
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name d) Melody of Madness (A)
#displayname Melody of Madness
#subweight 1
<< Alliance
step
#include d) Melody of Madness
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name l) Subterfuge in Silk (A)
#displayname Subterfuge in Silk
#subweight 1
<< Alliance
step
#include l) Subterfuge in Silk
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP The War Within
#subgroup Azj-kahet Storylines
#name a) Rak-Ush Swarmery (A)
#displayname Rak-Ush Swarmery
#subweight 1
<< Alliance
step
#include a) Rak-Ush Swarmery
]])
RXPGuides.RegisterGuide([[
#df
#version 1
#group RestedXP Speedrun Guide
#subgroup Dragonflight (New Player)
#displayname Chapter 1 - The Waking Shores
#name a) The Waking Shores Fresh
#next b) Ohn'ahran Plain Fresh
step << Horde
>>|cRXP_WARN_If this quest didn't automatically appear in your questlog.|r
*|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ebyssian|r
.goto 85,44.08,38.01
.accept 65435 >>Accept The Dragon Isles Await
.target Ebyssian
step << Horde
>>Use the |T134309:0|t[Lost Dragonscale]
.complete 65435,1 
.use 205458
step << Horde
.goto 84,44.08,37.99
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ebyssian|r
.complete 65435,2 
.target Ebyssian
step << Horde
.goto 84,44.08,37.99
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ebyssian|r
.turnin 65435 >>Turn in The Dragon Isles Await
.target Ebyssian
step << Horde
.goto 85,44.06,37.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ebyssian|r
.accept 65437 >>Accept Aspectral Invitation
.complete 65437,1 
.turnin 65437 >>Turn in Aspectral Invitation
.target Ebyssian
.skipgossipid 55582
step << Horde
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Naleida Rivergleam|r and |cRXP_FRIENDLY_Scalecommander Cindrethresh|r
.accept 65443 >>Accept Expeditionary Coordination
.goto 85,44.19,37.79
.accept 72256 >>Accept The Dark Talons
.goto 85,44.04,38.25
.target Naleidea Rivergleam
.target Scalecommander Cindrethresh
step << Horde
#completewith next
#label OrdersDeliveredKodethi
.goto 1,54.13,9.85,0,0
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kodethi|r
.complete 72256,1 
.target Kodethi
step << Horde
#completewith OrdersDeliveredKodethi
.goto 85,44.03,38.81
.zone 1 >>Click on the |cRXP_PICK_Portal to Dranosh'ar Blockade|r
step << Horde
#requires OrdersDeliveredKodethi
.goto 1,54.13,9.85
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kodethi|r
.complete 72256,1 
.target Kodethi
.skipgossipid 107450
step << Horde
.goto 1,54.02,13.05
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Pathfinder Tacha|r
.complete 65443,2 
.target Pathfinder Tacha
.skipgossipid 53882
step << Horde
.goto 1,55.97,13.22
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cataloger Coralie|r
.complete 65443,3 
.target Cataloger Coralie
.skipgossipid 54035
step << Horde
.goto 1,55.17,11.63
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Boss Magor|r
.complete 65443,1 
.target Boss Magor
.skipgossipid 53883
step << Horde
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Naleidea Rivergleam|r and |cRXP_FRIENDLY_Archmage Khadgar|r |cRXP_WARN_on top of the tower|r
.turnin 65443 >>Turn in Expeditionary Coordination
.turnin 72256 >>Turn in The Dark Talons
.timer 4,Roleplay Duration
.goto 1,55.81,12.66
.accept 65439 >>Accept Whispers on the Winds
.complete 65439,1 
.goto 1,55.92,12.61
.timer 3,Khadgar Appearance
.skipgossip 193450,1
.target Naleidea Rivergleam
.target Archmage Khadgar
step << Horde
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ebyssian|r and |cRXP_FRIENDLY_Naleidea Rivergleam|r
.turnin -65439 >>Turn in Whispers on the Winds
.turnin -70198 >>Turn in The Call of the Isles
.goto 1,55.85,12.74
.target +Ebyssian
.accept 65444 >>Accept To the Dragon Isles!
.goto 1,55.81,12.66
.target +Naleidea Rivergleam
step << Horde
#completewith next
+You can see the time to arrival above Skarukaru. If you can't see it, talk to her.
step << Horde
.goto 1,55.96,13.18
>>|cRXP_WARN_Wait for the Zeppelin to arrive|r
.complete 65444,1 
.skipgossip
.target Sharukaru
step << Horde
.zoneskip 2022
.isOnQuest 65444
.goto 1,55.99,13.33
.zone 1978 >>Go onto the Zeppelin when it arrives. Wait at the waypoint location
step << Horde
#label HordeArrivingInDragonIsles
.goto 2022,80.83,27.80
.complete 65444,2 
step << Horde
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Naleidea Rivergleam|r, |cRXP_FRIENDLY_Scalecommander Cindrethresh|r and |cRXP_FRIENDLY_Boss Magor|r
.turnin 65444 >>Turn in To the Dragon Isles!
.accept 65452 >>Accept Explorers in Peril
.goto 2022,80.62,27.60
.target +Naleidea Rivergleam
.accept 65453 >>Accept Primal Pests
.goto 2022,80.65,27.60
.target +Scalecommander Cindrethresh
.accept 65451 >>Accept Practice Materials
.goto 2022,80.60,27.65
.target +Boss Magor
step << Horde
#completewith WakingShoresExplorersInPeril
.goto 2022,79.24,25.84,0,0
>>Kill |cRXP_ENEMY_Big Proto Drakes|r
.complete 65453,1 
.mob Primal Proto-Drake
step << Horde
#completewith WakingShoresExplorersInPeril
>>Kill |cRXP_ENEMY_Primal Proto-Whelps|r. Loot them for their scales
.complete 65451,1 
.mob Primal Proto-Whelp
step << Horde
>>Click on the |cRXP_PICK_Protodragon Rib Cage|r
.groundgoto 2022,79.80,28.20,25,0
.goto 2022,80.37,26.34
.complete 65452,1 
step << Horde
.goto 2022,78.71,24.52
>>Click on |cRXP_FRIENDLY_Archivist Spearblossom|r
.complete 65452,2 
.target Archivist Spearblossom
step << Horde
#label WakingShoresExplorersInPeril
.goto 2022,77.37,29.77
>>Click on |cRXP_FRIENDLY_Spelunker Lazee|r hanging on the chain
.complete 65452,3 
.target Spelunker Lazee
step << Horde
#completewith next
.goto 2022,79.24,25.84,0,0
>>Kill |cRXP_ENEMY_Big Proto Drakes|r
.complete 65453,1 
.mob Primal Proto-Drake
step << Horde
#loop
.goto 2022,78.56,28.70,20,0
.goto 2022,79.20,28.94,20,0
.goto 2022,79.69,27.85,20,0
.goto 2022,79.53,27.06,20,0
.goto 2022,78.62,26.52,20,0
.goto 2022,77.47,26.72,20,0
>>Kill |cRXP_ENEMY_Primal Proto-Whelps|r. Loot them for their scales
.complete 65451,1 
.mob Primal Proto-Whelp
step << Horde
#loop
.goto 2022,78.56,28.70,20,0
.goto 2022,79.20,28.94,20,0
.goto 2022,79.69,27.85,20,0
.goto 2022,79.53,27.06,20,0
.goto 2022,78.62,26.52,20,0
.goto 2022,77.47,26.72,20,0
>>Kill |cRXP_ENEMY_Big Proto Drakes|r
.complete 65453,1 
.mob Primal Proto-Drake
step << Horde
.goto 2022,76.61,33.60
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Naleidea Rivergleam|r
.turnin 65452 >>Turn in Explorers in Peril
.accept 69910 >>Accept Where is Wrathion?
.target Naleidea Rivergleam
step << Alliance
>>|cRXP_WARN_If this quest didn't automatically appear in your questlog.|r
*|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wrathion|r
.goto 84,79.81,27.03
.accept 65436 >>Accept The Dragon Isles Await
.target Wrathion
step << Alliance
#completewith next
>>Use the |T134309:0|t[Lost Dragonscale]
.complete 65436,1 
.use 205458
step << Alliance
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wrathion|r in Stormwind
.goto 84,79.81,27.04
.turnin 65436 >>Turn in The Dragon Isles Await
step << Alliance
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wrathion|r
.accept 66577 >>Accept Aspectral Invitation
.complete 66577,1 
.turnin 66577 >>Turn in Aspectral Invitation
.goto 84,79.81,27.04
.skipgossip 189569,1
.target Wrathion
step << Alliance
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Scalecommander Azurathel|r and |cRXP_FRIENDLY_Toddy Whiskers|r
.accept 72240 >>Accept The Obsidian Warders
.goto 84,79.95,26.95
.target Scalecommander Azurathel
.accept 66589 >>Accept Expeditionary Coordination
.goto 84,79.73,27.35
.target Toddy Whiskers
step << Alliance
>>|cRXP_WARN_Step just outside the keep to mount up.|r
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thaelin Darkanvil|r
.goto 84,79.45,26.89,3,0
.goto 84,38.1,35.12
.skipgossip 1
.complete 66589,1 
.target Thaelin Darkanvil
step << Alliance
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cataloger Wulferd|r
.goto 84,32.89,34.63
.skipgossip
.complete 66589,3 
.target Cataloger Wulferd
step << Alliance
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dervishian|r
.goto 84,39.25,41.41
.skipgossip
.complete 72240,1 
.target Dervishian
step << Alliance
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Pathfinder Jeb|r
.goto 84,38.26,45.52
.skipgossip
.complete 66589,2 
.target Pathfinder Jeb
step << Alliance
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Toddy Whiskers|r
.goto 84,22.70,55.66
.turnin 66589 >>Turn in Expeditionary Coordination
.turnin 72240 >>Turn in The Obsidian Warders
.timer 5,RP
.target Toddy Whiskers
step << Alliance
.goto 84,22.94,56.24
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
.accept 66596 >>Accept Whispers on the Winds
.skipgossip
.complete 66596,1 
.target Archmage Khadgar
step << Alliance
.goto 84,22.92,56.04
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wrathion|r
.turnin 66596 >>Turn in Whispers on the Winds
.target Wrathion
step << Alliance
.goto 84,22.73,55.70
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Toddy Whiskers|r
.turnin -70197 >>Turn in The Call of the Isles
.accept 67700 >>Accept To the Dragon Isles!
.target Toddy Whiskers
step << Alliance
>>Wait for the arrival of the ship
.goto 84,22.36,55.98
.complete 67700,1 
step << Alliance
.isOnQuest 67700
.goto 84,20.82,53.83
.zone 1978 >>Go to the front of the ship on the large wood plank
step << Alliance
.goto 2022,82.13,31.88
>>|cRXP_WARN_Wait until the ship docks, or use dragonriding to fly directly to the waypoint.|r
.complete 67700,2 
step << Alliance
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Toddy Whiskers|r, |cRXP_FRIENDLY_Thaelin Darkanvil|r and |cRXP_FRIENDLY_Scalecommander Azurathel|r
.turnin 67700 >>Turn in To the Dragon Isles!
.accept 70122 >>Accept Explorers in Peril
.goto 2022,82.13,31.88
.accept 70124 >>Accept Practice Materials
.goto 2022,82.09,31.89
.accept 70123 >>Accept Primal Pests
.goto 2022,82.16,31.86
.target Toddy Whiskers
.target Thaelin Darkanvil
.target Scalecommander Azurathel
step << Alliance
#completewith WakingShoresExplorersInPerilCogcatcher
.goto 2022,82.47,32.10,10,0
.goto 2022,82.91,32.54,10 >>Follow the arrow up the mountain
step << Alliance
#completewith WakingShoresExplorersInPerilAlliance
>>Kill |cRXP_ENEMY_the Big Proto-Drakes|r
.complete 70123,1 
step << Alliance
#completewith WakingShoresExplorersInPerilAlliance
>>Kill |cRXP_ENEMY_Primal Proto-Whelps|r. Loot them for their scales
.complete 70124,1 
step << Alliance
#label WakingShoresExplorersInPerilCogcatcher
>>Rescue |cRXP_FRIENDLY_Professor Cogcatcher|r
.goto 2022,83.55,33.59
.complete 70122,1 
.target Professor Cogcatcher
step << Alliance
>>Rescue |cRXP_FRIENDLY_Archivist Rellid|r |cRXP_WARN_who's in the air|r
.goto 2022,83.01,36.30
.complete 70122,2 
.target Archivist Rellid
step << Alliance
#label WakingShoresExplorersInPerilAlliance
>>Rescue |cRXP_FRIENDLY_Spelunker Lockeye|r
.goto 2022,79.54,35.35
.complete 70122,3 
.target Spelunker Lockeye
step << Alliance
#completewith next
>>Kill |cRXP_ENEMY_the Big Proto-Drakes|r
.complete 70123,1 
step << Alliance
>>Kill |cRXP_ENEMY_Primal Proto-Whelps|r. Loot them for their scales
#loop
.goto 2022,79.90,33.73,25,0
.goto 2022,79.54,32.98,25,0
.goto 2022,79.90,32.16,25,0
.goto 2022,81.00,33.19,25,0
.goto 2022,81.74,32.97,25,0
.goto 2022,82.47,33.52,25,0
.goto 2022,83.31,33.70,25,0
.goto 2022,84.07,33.98,25,0
.goto 2022,84.29,34.94,25,0
.goto 2022,83.79,35.66,25,0
.goto 2022,82.84,35.93,25,0
.goto 2022,82.28,34.61,25,0
.complete 70124,1 
step << Alliance
>>Kill |cRXP_ENEMY_the Big Proto-Drakes|r
#loop
.goto 2022,79.90,33.73,25,0
.goto 2022,79.54,32.98,25,0
.goto 2022,79.90,32.16,25,0
.goto 2022,81.00,33.19,25,0
.goto 2022,81.74,32.97,25,0
.goto 2022,82.47,33.52,25,0
.goto 2022,83.31,33.70,25,0
.goto 2022,84.07,33.98,25,0
.goto 2022,84.29,34.94,25,0
.goto 2022,83.79,35.66,25,0
.goto 2022,82.84,35.93,25,0
.goto 2022,82.28,34.61,25,0
.complete 70123,1 
step << Alliance
.goto 2022,76.63,33.63
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Toddy Whiskers|r
.turnin 70122 >>Turn in Explorers in Peril
.accept 70125 >>Accept Where is Wrathion?
.target Toddy Whiskers
step
#completewith point1
+|cRXP_WARN_We Accept the quests in this area only during roleplay. Strictly follow the arrow for maximum efficieny.|r
step << Horde
#completewith WakingShorePractiveMaterialsHorde
#label InquireMissingDragons
#hidewindow
>>Complete the other steps
.goto 2022,76.58,33.66,0,0
.complete 69910,1 << Horde 
step << Alliance
#completewith WakingShorePractiveMaterialsAlliance
#label InquireMissingDragons
#hidewindow
>>Complete the other steps
.goto 2022,76.58,33.66,0,0
.complete 70125,1 << Alliance 
step
#completewith InquireMissingDragons
#label TalkToSendraxInquire
.goto 2022,76.58,33.66
.gossipoption 55636 >>Talk to |cRXP_FRIENDLY_Sendrax|r 
.timer 17,Roleplay Duration
.target Sendrax
step << Horde
#requires TalkToSendraxInquire
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Scalecommander Cindrethresh|r and |cRXP_FRIENDLY_Warlord Breka Grimaxe|r
.accept 66110 >>Accept Give Peace a Chance
.goto 2022,76.36,33.09
.target +Scalecommander Cindrethresh
.turnin 65453 >>Turn in Primal Pests
.goto 2022,76.28,33.02
.target +Warlord Breka Grimaxe
step << Horde
#label WakingShorePractiveMaterialsHorde
.goto 2022,75.94,33.25
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Boss Magor|r
.turnin 65451 >>Turn in Practice Materials
.target Boss Magor
step << Horde
.goto 2022,75.84,33.49
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Aster Cloudgaze|r
.accept 66101 >>Accept From Such Great Heights
.target Aster Cloudgaze
step << Horde
#label WakingShoreInquireMissingDragonsHorde
>>Wait for the roleplay
.goto 2022,76.58,33.66,0,0
.complete 69910,1 << Horde 
step << Alliance
#requires TalkToSendraxInquire
.goto 2022,76.49,34.34
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thaelin Darkanvil|r
.turnin 70124 >>Turn in Practice Materials
.target Thaelin Darkanvil
step << Dracthyr Alliance
.goto 2022,76.40,34.45
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Haephesta|r
.accept 70148 >>Accept Without Purpose
.target Haephesta
step << Dracthyr Alliance
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kholmar|r
.goto 2022,76.44,34.42
.gossipoption 56060
.skipgossip 192563,1
.complete 70148,1 
.target Kholmar Sunrunner
step << Dracthyr Alliance
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Toninaar|r
.goto 2022,76.69,34.78
.gossipoption 56063
.skipgossip 192558,1
.complete 70148,2 
.target Toninaar
step << Alliance
.goto 2022,76.73,34.56
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Garrick|r
.accept 67053 >>Accept Give Peace a Chance
.target Captain Garrick
step << Alliance
.goto 2022,76.75,34.41
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Scalecommander Azurathel|r
.turnin 70123 >>Turn in Primal Pests
.target Scalecommander Azurathel
step
#label point1
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sendrax|r
.goto 2022,76.58,33.66
.turnin 70125 >>Turn in Where is Wrathion? << Alliance
.turnin 69910 >>Turn in Where is Wrathion? << Horde
.accept 69911 >>Accept Excuse the Mess
.target Sendrax
step << Dracthyr Horde
.goto 2022,76.40,34.45
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Haephesta|r
.accept 70148 >>Accept Without Purpose
.target Haephesta
step << Dracthyr Horde
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kholmar Sunrunner|r
.goto 2022,76.44,34.42
.gossipoption 56060
.skipgossip 1
.complete 70148,1 
.target Kholmar Sunrunner
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ambassador Fastrasz|r
.goto 2022,76.33,35.62
.skipgossip 193393,2
.complete 69911,1 
.target Ambassador Fastrasz
step
>>Interact with the book
.goto 2022,76.28,35.62
.skipgossip 1
.complete 69911,2 
step
.goto 2022,75.61,34.17
>>Click on |cRXP_PICK_Alexstrasza's Welcome stone|r
.complete 69911,3 
step
.goto 2022,78.43,31.80
>>Click on the |cRXP_PICK_Brazier of Kinship|r
.complete 69911,4 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sendrax|r
.goto 2022,76.58,33.66
.turnin 69911 >>Turn in Excuse the Mess
.accept 69912 >>Accept My First Real Emergency!
.target Sendrax
step
#completewith next
+|cRXP_WARN_During the roleplay turn in and complete the specified quests|r.
step
#completewith WakingShoreFromSuchGreatHeights
#label SignalFlareSent
#hidewindow
>>Wait for the roleplay
.complete 69912,1 
step
#completewith SignalFlareSent
#label TalkToSendraxSignalFlare
.goto 2022,76.58,33.66
.gossipoption 55637 >>Talk to |cRXP_FRIENDLY_Sendrax|r
.timer 33,Roleplay Duration
.target Sendrax
step << Alliance
#requires TalkToSendraxSignalFlare
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Aster Cloudgaze|r
.goto 2022,75.84,33.49
.accept 66101 >>Accept From Such Great Heights
.target Aster Cloudgaze
step
#requires TalkToSendraxSignalFlare
>>Click on the |cRXP_PICK_Surveyor's Disc|r
.goto 2022,75.9,33.58
.complete 66101,1 
step
>>Use the first ability (1), then press Escape to cancel the cutscene.
.goto 2022,76.42,33.72
.complete 66101,2 
step
>>Use the second ability (2), then press Escape to cancel the cutscene.
.goto 2022,75.70,33.45
.complete 66101,3 
step
>>Use the third ability (3), then press Escape to cancel the cutscene.
.goto 2022,75.87,33.35
.complete 66101,4 
step
#completewith next
+|cRXP_WARN_Leave the vehicle immediately|r
step
#label WakingShoreFromSuchGreatHeights
.goto 2022,75.84,33.49
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Aster Cloudgaze|r
.turnin 66101 >>Turn in From Such Great Heights
.target Aster Cloudgaze
step << Alliance
.goto 2022,76.36,33.08
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Warlord |cRXP_FRIENDLY_Breka Grimaxe|r
.turnin 67053 >>Turn in Give Peace a Chance
.accept 70135 >>Accept Encroaching Elementals
.target Warlord Breka Grimaxe
step
#completewith next
.goto 2022,76.31,34.33,10 >>Follow the waypoint to trigger the next roleplay (which is proximity based)
step << Horde
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Garrick|r
.goto 2022,76.73,34.55
.turnin 66110 >>Turn in Give Peace a Chance
.accept 66111 >>Accept Encroaching Elementals
.target Captain Garrick
step << Dracthyr Horde
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Toninaar|r
.goto 2022,76.69,34.78
.gossipoption 56063
.skipgossip 192558,1
.complete 70148,2 
.target Toninaar
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grun Ashbeard|r
.goto 2022,76.35,34.64
.accept 66112 >>Accept Always Be Crafting
.target Grun Ashbeard
step
#completewith WakingShorePrimalEarthenCoreB
>>Kill mostly the |cRXP_ENEMY_Small Fire Elementals|r. The Earth elementals are a lot tougher.
.goto 2022,73.89,33.74,0,0
.complete 70135,1 << Alliance 
.complete 66111,1 << Horde 
step
#completewith next
#label WakingShorePrimalEarthenCoreA
>>Go into the Cave and kill |cRXP_ENEMY_Baron Crustcore|r. Loot him for the core
.goto 2022,74.88,39.31,0,0
.complete 66112,2 
.mob Baron Crustcore
step
#completewith WakingShorePrimalEarthenCoreA
.goto 2022,75.52,36.34,15,0
.goto 2022,75.78,37.01,10 >>Enter the cave
step
#requires WakingShorePrimalEarthenCoreA
#label WakingShorePrimalEarthenCoreB
>>Go into the Cave and kill |cRXP_ENEMY_Baron Crustcore|r. Loot him for the |T1016351:0|t[|cRXP_LOOT_Primal Earthen Core|r]
.goto 2022,74.88,39.31
.complete 66112,2 
.mob Baron Crustcore
step
#completewith next
#label MyFirstDjaradinAwoken
#hidewindow
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wrathion|r and |cRXP_FRIENDLY_Majordomo Selistra|r
.turnin 69912 >>Turn in My First Real Emergency!
.goto 2022,76.18,34.50,0,0
.target +Wrathion
.accept 69914 >>Accept The Djaradin Have Awoken
.goto 2022,76.22,34.53,0,0
.target +Majordomo Selistra
step
#completewith MyFirstDjaradinAwoken
.goto 2022,75.78,37.01,20 >>Leave the cave
step
#requires MyFirstDjaradinAwoken
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wrathion|r and |cRXP_FRIENDLY_Majordomo Selistra|r
.turnin 69912 >>Turn in My First Real Emergency!
.goto 2022,76.18,34.50
.target +Wrathion
.accept 69914 >>Accept The Djaradin Have Awoken
.goto 2022,76.22,34.53
.target +Majordomo Selistra
step
#completewith WakingShorePrimalEarthenCore
>>Wait for the roleplay
.skipgossip 193372,1
.complete 69914,1 
step
#completewith next
.goto 2022,76.22,34.53
.gossipoption 55872 >>Talk to |cRXP_FRIENDLY_Majordomo Selistra|r
.timer 50,Roleplay Duration
.target Majordomo Selistra
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Haephesta|r
.goto 2022,76.41,34.45
.accept 69965 >>Accept Quality Assurance
.target Haephesta
step << Dracthyr
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Aster Cloudgaze|r
.goto 2022,75.85,33.50
.skipgossip 187257,1
.complete 70148,3 
.target Aster Cloudgaze
step
#completewith WakingShoresQualityAssurance
>>Focus on killing the |cRXP_ENEMY_Small Fire Elementals|r
.complete 70135,1 << Alliance 
.complete 66111,1 << Horde 
.mob Encroaching Lava
.mob Primal Lava Elemental
step << Dracthyr
>>Interact with the Note on the Wall
.goto 2022,75.05,33.52
.complete 70148,4 
step
#title Geodes Excavated 1
>>Click on the |cRXP_PICK_Volcanic Geode|r
.goto 2022,74.57,33.51
.complete 69965,1,1 
step
#title Geodes Excavated 2
>>Click on the |cRXP_PICK_Volcanic Geode|r
.goto 2022,73.93,33.23
.complete 69965,1,2 
step
#title Geodes Excavated 3
>>Click on the |cRXP_PICK_Volcanic Geode|r
.goto 2022,73.56,32.21
.complete 69965,1,3 
step
#label WakingShorePrimalMoltenCore
>>Kill |cRXP_ENEMY_Baron Ashflow|r. Loot him for the core
.goto 2022,72.91,32.97
.complete 66112,1 
.mob Baron Ashflow
step
#title Geodes Excavated 4
>>Click on the |cRXP_PICK_Volcanic Geode|r
.goto 2022,72.88,33.73
.complete 69965,1,4 
step
#title Geodes Excavated 5
>>Click on the |cRXP_PICK_Volcanic Geode|r
.goto 2022,72.94,34.12
.complete 69965,1,5 
step
#label WakingShoresQualityAssurance
#title Geodes Excavated 6
>>Click on the |cRXP_PICK_Volcanic Geode|r
.goto 2022,73.63,33.89
.complete 69965,1 
step << Dracthyr
#completewith next
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Talon Ethrethi|r
.goto 2022,74.93,34.98
.skipgossip 194289,1
.complete 70148,5 
.target Talon Ethrethi
step
#loop
.goto 2022,73.62,33.39,25,0
.goto 2022,74.65,35.28,25,0
>>Kill mostly the |cRXP_ENEMY_Encroaching Lava|r
.complete 70135,1 << Alliance 
.complete 66111,1 << Horde 
.mob Encroaching Lava
.mob Primal Lava Elemental
step << Dracthyr
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Talon Ethrethi|r
.goto 2022,74.93,34.98
.skipgossip 194289,1
.complete 70148,5 
.target Talon Ethrethi
step
>>Wait for the roleplay
.goto 2022,76.22,34.53
.complete 69914,1 
step
#requires WakingShoresEncroachingElementals
.goto 2022,76.26,34.40
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sendrax|r
.turnin 69914 >>Turn in The Djaradin Have Awoken
.target Sendrax
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sendrax|r then immediately turn in the next quests
.accept 65760 >>Accept Reporting for Duty
.goto 2022,76.26,34.40
.target Sendrax
step
.goto 2022,76.35,34.64
>>Immediately go there
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grun Ashbeard|r
.turnin 66112 >>Turn in Always Be Crafting
.target Grun Ashbeard
step
.goto 2022,76.41,34.45
>>Immediately go there
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Haephesta|r
.turnin 69965 >>Turn in Quality Assurance
.turnin 70148 >>Turn in Without Purpose << Dracthyr
.target Haephesta
step << Alliance
.goto 2022,76.37,33.09
>>Immediately go there
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Warlord Breka Grimaxe|r
.turnin 70135 >>Turn in Encroaching Elementals
.target Warlord Breka Grimaxe
step << Horde
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Captain Garrick|r
.goto 2022,76.73,34.56
.turnin 66111 >>Turn in Encroaching Elementals
.target Captain Garrick
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sendrax|r
.goto 2022,76.27,34.41
.skipgossip 193363,3
.complete 65760,1 
.target Sendrax
step
>>|cRXP_WARN_Follow and stay close to |cRXP_FRIENDLY_Sendrax|r or the quest will not complete|r
.goto 2022,75.28,36.20,20,0
.goto 2022,73.20,35.96,20,0
.goto 2022,72.29,36.65,20,0
.goto 2022,71.25,40.67
.complete 65760,2 
.target Sendrax
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Commander Lethanak|r
.goto 2022,71.20,40.77
.turnin 65760 >>Turn in Reporting for Duty
.accept 65990 >>Accept Deliver Whelps From Evil
.accept 65989 >>Accept Invader Djaradin
.target Commander Lethanak
step
#completewith WhimperingWhelplingsSaved
.goto 2022,70.38,44.91,0,0
>>Focus on killing |cRXP_ENEMY_Qalashi Scavengers|r
.complete 65989,1 
.mob Qalashi Scavenger
.mob Qalashi Djaradin
step
.goto 2022,71.36,44.65
>>Save the |cRXP_FRIENDLY_Whimpering Whelpling|r
.complete 65990,1,1 
.target Whimpering Whelping
step
>>Save the |cRXP_FRIENDLY_Whimpering Whelpling|r
.goto 2022,70.97,46.21,10,0
.goto 2022,70.87,46.77,10,0
.goto 2022,71.12,46.98,10,0
.goto 2022,70.97,46.63
.complete 65990,1,2 
.target Whimpering Whelpling
step
>>Save the |cRXP_FRIENDLY_Whimpering Whelpling|r
.goto 2022,69.86,45.3
.complete 65990,1,3 
.target Whimpering Whelpling
step
#label WhimperingWhelplingsSaved
>>Save the |cRXP_FRIENDLY_Whimpering Whelpling|r
.goto 2022,69.38,43.26
.complete 65990,1 
.target Whimpering Whelpling
step
.goto 2022,70.38,44.91
>>Focus on killing |cRXP_ENEMY_Qalashi Scavengers|r
.complete 65989,1 
.mob Qalashi Scavenger
.mob Qalashi Djaradin
step
#requires WakingShoreInvaderDjaradin
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Commander Lethanak|r
.goto 2022,71.20,40.77
.turnin 65989 >>Turn in Invader Djaradin
.turnin 65990 >>Turn in Deliver Whelps From Evil
.accept 65991 >>Accept Time for a Reckoning
.target Commander Lethanak
step
.goto 2022,71.27,40.39
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mender Eskros|r
.accept 72122 >>Accept Erstwhile Ecologists
.target Mender Eskros
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ecologist Tharu|r and |cRXP_FRIENDLY_Ecologist Iskha|r
.turnin 72122 >>Turn in Erstwhile Ecologists
.accept 66105 >>Accept A Scalpel of a Solution
.goto 2022,74.43,42.13
.target +Ecologist Tharu
.accept 66107 >>Accept Wildlife Rescue
.goto 2022,74.52,42.17
.target +Ecologist Iskha
step
#completewith RampagingWaterWind
#hidewindow
#loop
.goto 2022,76.13,42.62,25,0
.goto 2022,76.74,43.78,25,0
.goto 2022,76.21,45.68,25,0
.goto 2022,78.03,45.84,25,0
.goto 2022,78.72,47.83,25,0
.goto 2022,79.16,49.12,25,0
.goto 2022,80.19,47.91,25,0
.goto 2022,79.03,46.29,25,0
+1
step
#completewith next
>>Kill |cRXP_ENEMY_Ramapging Water|r and |cRXP_ENEMY_Ramapging Wind|r
.complete 66105,1 
.complete 66105,2 
step
>>Click on the trapped animals. |cRXP_WARN_Follow the arrrow and focus on |cRXP_FRIENDLY_Cowering Crabs|r and |cRXP_FRIENDLY_Helpless Waterfowls|r|r
.complete 66107,1 
.target Cowering Crab
.target Helpless Waterfowl
step
#label RampagingWaterWind
>>Kill |cRXP_ENEMY_Rampaging Water|r and |cRXP_ENEMY_Rampaging Wind|r
.complete 66105,1 
.complete 66105,2 
.mob Rampaging Water
.mob Rampaging Wind
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ecologist Tharu|r and |cRXP_FRIENDLY_Ecologist Iskha|r
.turnin 66107 >>Turn in Wildlife Rescue
.goto 2022,74.51,42.18
.target +Ecologist Tharu
.turnin 66105 >>Turn in A Scalpel of a Solution
.accept 66104 >>Accept Forensic Ecology
.goto 2022,74.42,42.14
.target +Ecologist Iskha
step
>>Click on the corpses on the table
.goto 2022,74.46,42.20
.complete 66104,1 
.complete 66104,2 
step
>>Examine the shells on the table
.goto 2022,74.46,42.20
.complete 66104,3 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ecologist Iskha|r
.turnin 66104 >>Turn in Forensic Ecology
.accept 66108 >>Accept A Sledgehammer of a Solution
.goto 2022,74.43,42.14
.target Ecologist Iskha
step
>>Kill |cRXP_ENEMY_Whirglgurgl|r
.goto 2022,79.77,39.80
.complete 66108,2 
step
>>Kill |cRXP_ENEMY_Sogglmoggl|r
.goto 2022,80.08,44.10
.complete 66108,1 
step
.goto 2022,80.13,42.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Bubbled Duckling
.accept 66196 >>Accept A Quack For Help
.target Bubbled Duckling
step
>>Follow the arrow. You may have to wait some time for the duckling
.goto 2022,74.54,42.09
.complete 66196,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Ecologist Tharu and Forensic Ecology
.turnin 66196 >>Turn in A Quack For Help
.goto 2022,74.51,42.17
.turnin 66108 >>Turn in A Sledgehammer of a Solution
.goto 2022,74.42,42.14
.target Ecologist Tharu
.target Ecologist Iskha
step
#completewith WakingShoresKilljoyBlacktalinObsidian
>>Kill |cRXP_ENEMY_Djaradin|r around the camp.
*|cRXP_WARN_You can also kill Dragonhunter Igordan multiple times|r
.goto 2022,62.76,34.50,0,0
.accept 65994 >>Accept Djaradin Djustice (Bonus Objective)
.complete 65994,1 
.mob Qalashi Scoundrel
.mob Qalashi Ragetamer
.mob Qalashi Skirmisher
.mob Qalashi Flameshatter
.mob Qalashi Flamemuzzler
step
#completewith next
.groundgoto 2022,70.59,38.56,10,0
.groundgoto 2022,70.24,38.79,10 >>Follow the way up the mountain
step
#label WakingShoreTimeForReckoning
>>Climb the tower and wait for |cRXP_FRIENDLY_Wrathion|r
.goto 2022,68.12,36.87,20,0
.goto 2022,66.59,34.58
.complete 65991,1 
step
.goto 2022,66.36,35.01
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wrathion|r
.turnin 65991 >>Turn in Time for a Reckoning
.accept 65993 >>Accept Killjoy
.accept 65992 >>Accept Blacktalon Intel
.target Wrathion
step
#completewith WakingShoreDragonHunderIgordan
.goto 2022,65.65,35.16,20 >>Jump down
step
#label WakingShoreDragonHunderIgordan
.goto 2022,64.26,33.05
>>Kill |cRXP_ENEMY_Dragonhunter Igordan|r
.accept 66956 >>Accept Dragonhunter Igordan (Elite Objective)
.complete 66956,1 
.mob Dragonhunter Igordan
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Right|r
.goto 2022,65.09,29.35
.complete 65992,3 
.target Right
.skipgossipid 55298
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Left
.goto 2022,64.11,30.33,30,0
.goto 2022,63.43,28.87
.complete 65992,2 
.target Left
.skipgossipid 55297
step
>>Kill |cRXP_ENEMY_Meatgrinder Sotok|r. Loot him for the |T237451:0|t[|cRXP_LOOT_Qualashi Plans|r]
.goto 2022,62.96,29.43
.complete 65993,1 
.collect 193874,1,65995,1
.accept 65995 >>Accept The Obsidian Citadel
.mob Meatgrinder Sotok
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Talonstalker Kavia|r
.goto 2022,64.58,30.57,30,0
.goto 2022,64.41,33.29,30,0
.goto 2022,63.03,33.34
.skipgossipid 55335
.complete 65992,1 
.target Talonstalker Kavia
step
#label WakingShoresKilljoyBlacktalinObsidian
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tClimb the stairs .Talk to |cRXP_FRIENDLY_Wrathion|r
.goto 2022,62.62,32.67,24,0
.goto 2022,62.65,33.17
.turnin 65993 >>Turn in Killjoy
.turnin 65992 >>Turn in Blacktalon Intel
.turnin 65995 >>Turn in The Obsidian Citadel
.target Wrathion
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Majordomo Selistra
.goto 2022,62.76,33.11
.accept 65996 >>Accept Veteran Reinforcements
step
#loop
.goto 2022,62.17,34.69,40,0
.goto 2022,64.25,33.15,40,0
.goto 2022,66.00,36.88,40,0
.goto 2022,64.25,33.15,40,0
>>Kill |cRXP_ENEMY_Djaradin|r around the camp.
*|cRXP_WARN_You can also kill Dragonhunter Igordan multiple times|r
.accept 65994 >>Accept Djaradin Djustice (Bonus Objective)
.complete 65994,1 
.mob Dragonhunter Igordan
.mob Qalashi Scoundrel
.mob Qalashi Ragetamer
.mob Qalashi Skirmisher
.mob Qalashi Flameshatter
.mob Qalashi Flamemuzzler
.mob Qalashi Metalshaper
step
#requires WakingShoreDjaradinDjustice
#completewith next
+|cRXP_WARN_Reminder: You can keybind the 'Active Items'|r
+|cRXP_WARN_How to Keybind:|r Escape -> Options -> Keybindings -> RestedXP Guides -> Select and Bind Active Button 1,2,3 and 4
step
#requires WakingShoreDjaradinDjustice
>>Use the |T967530:0:0|t[Rejuvenating Draught] on |cRXP_FRIENDLY_Injured Drakonids|r
*Use a heal spell instead if possible
.use 193917
.goto 2022,60.99,35.63
.complete 65996,1,1 
.target Injured Drakonid
step
>>Use the |T967530:0:0|t[Rejuvenating Draught] on |cRXP_FRIENDLY_Injured Drakonids|r
*Use a heal spell instead if possible
.use 193917
.goto 2022,61.11,36.77
.complete 65996,1,2 
.target Injured Drakonid
step
>>Use the |T967530:0:0|t[Rejuvenating Draught] on |cRXP_FRIENDLY_Injured Drakonids|r
*Use a heal spell instead if possible
.use 193917
.goto 2022,59.04,34.84
.complete 65996,1,3 
.target Injured Drakonid
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Caretaker Ventraz|r
.goto 2022,59.11,34.86
.accept 66998 >>Accept Fighting Fire with... Water
.target Caretaker Ventraz
step
.isOnQuest 66998
>>Kill the |cRXP_ENEMY_Erupting Droplets|r and |cRXP_ENEMY_Erupting Lasher|r
.goto 2022,59.30,33.30
.complete 66998,1 
.mob Erupting Droplet
.mob Erupting Lasher
step
.isQuestComplete 66998
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Caretaker Ventraz|r
.goto 2022,59.10,34.84
.turnin 66998 >>Turn in Fighting Fire with... Water
.target Caretaker Ventraz
step
>>Use the |T967530:0:0|t[Rejuvenating Draught] on |cRXP_FRIENDLY_Injured Drakonids|r
*Use a heal spell instead if possible
.use 193917
.goto 2022,56.64,34.77
.complete 65996,1 
.target Injured Drakonid
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Caretaker Azkra|r
.goto 2022,54.99,30.76
.turnin 65996 >>Turn in Veteran Reinforcements
.accept 65997 >>Accept Chasing Sendrax
.target Caretaker Azkra
step
.goto 2022,54.99,30.77
>>|cRXP_WARN_Follow the arrow|r
.complete 65996,2 
.target Sendrax
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sendrax|r
.goto 2022,55.18,24.95
.complete 65997,1 
.target Sendrax
.skipgossipid 55225
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sendrax|r
.goto 2022,55.18,24.95
.turnin 65997 >>Turn in Chasing Sendrax
.accept 65998 >>Accept Future of the Flights
.accept 65999 >>Accept Red in Tooth and Claw
.target Sendrax
step
.goto 2022,55.26,24.69
>>Click on the |cRXP_PICK_book|r
.accept 66000 >>Accept Library of Alexstrasza
step
#completewith FiravaRekindler
>>Kill |cRXP_ENEMY_Primalists/Revenants/Taraseks|r while doing the other objectives
.goto 2022,56.37,22.32,0,0
.complete 65999,1 
.mob Primal Revenant
.mob Tarasek Elementalist
.mob Molten Elementalist
.mob Unleashed Lavaburst
.mob Swelling Fire Elemental
step
#completewith WakingShoreFutureoftheFlight
>>Kill |cRXP_ENEMY_Firava the Rekindler|r when you see her (patrolling in the area)
.goto 2022,56.97,25.28,0,0
.complete 70648,1 
.mob Firava the Rekindler
step
>>Click on the |cRXP_PICK_book|r
.goto 2022,53.36,22.39
.complete 66000,1,1 
step
>>Click on the |cRXP_PICK_book|r
.goto 2022,53.47,21.99
.complete 66000,1,2 
step
.goto 2022,54.12,22.01
>>Break the eggs and kill the |cRXP_ENEMY_Infused Ruby Whelplings|r
.complete 65998,1 
.complete 65998,2,3 
.mob Infused Ruby Whelpling
step
.goto 2022,55.16,22.71
>>Break the eggs and kill the |cRXP_ENEMY_Infused Ruby Whelplings|r
.complete 65998,2,6 
.mob Infused Ruby Whelpling
step
.goto 2022,54.89,21.36
>>Break the eggs and kill the |cRXP_ENEMY_Infused Ruby Whelplings|r
.complete 65998,2 
.mob Infused Ruby Whelpling
step
.goto 2022,54.62,20.36
>>Click on the |cRXP_PICK_book|r |cRXP_WARN_inside the tower|r
.complete 66000,1,3 
step
>>Click on the |cRXP_PICK_book|r |cRXP_WARN_inside the tower on the second floor|r
.goto 2022,55.08,20.77,10,0
.goto 2022,55.04,20.3,5,0
.goto 2022,54.6,20.62
.complete 66000,1,4 
step
#label WakingShoreFutureoftheFlight
.goto 2022,55.16,22.73
>>Break the eggs and kill the |cRXP_ENEMY_Infused Ruby Whelplings|r
.complete 65998,2 
.mob Infused Ruby Whelpling
step
#label FiravaRekindler
>>Kill |cRXP_ENEMY_Firava the Rekindler|r when you see her (patrolling in the area)
.goto 2022,56.97,25.28
.accept 70648 >>Accept Firava the Rekindler (Elite Objective)
.complete 70648,1 
.mob Firava the Rekindler
step
#loop
.goto 2022,57.41,23.37,40,0
.goto 2022,53.58,22.58,40,0
.goto 2022,55.42,20.71,40,0
>>Kill |cRXP_ENEMY_Primalists/Revenants/Taraseks|r while doing the other objectives
.complete 65999,1 
.mob Primal Revenant
.mob Tarasek Elementalist
.mob Molten Elementalist
.mob Unleashed Lavaburst
.mob Swelling Fire Elemental
step
#label WakingShoreDontTurnIn1
#completewith WakingShoreRedInToothAndClawLibraryofAlexstrasza
.goto 2022,56.24,22.14,10 >>|cRXP_WARN_DON'T TURN IN THE QUESTS|r until you're at the waypoint location
step
#requires WakingShoreRedInToothAndClaw
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Sendrax next to you
.goto 2022,56.24,22.14
.turnin 65998 >>Turn in Library of Alexstrasza
step
#label WakingShoreRedInToothAndClawLibraryofAlexstrasza
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sendrax|r next to you
.goto 2022,56.24,22.14
.turnin 65999 >>Turn in Red in Tooth and Claw
.turnin 66000 >>Turn in Library of Alexstrasza
.accept 66001 >>Accept A Last Hope
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sendrax|r
.goto 2022,56.24,22.06
.skipgossip
.timer 16,Roleplay Duration
.complete 66001,1 
step
>>Wait for the roleplay
.goto 2022,56.92,21.62
.complete 65998,1 
step
.itemcount 132516,1
#completewith next
.cooldown item,132516,>0,1
.cast 202844 >>Use |T1405809:0|t[Gunshoes] |cRXP_WARN_right before clicking on the egg|r
step
>>Interact with the egg
.goto 2022,56.92,21.61
.complete 66001,2 
step
>>|cRXP_WARN_Using any ability will drop the egg|r
.goto 2022,55.21,26.27,30,0
.goto 2022,54.99,30.77
.complete 66001,3 
.timer 18,Roleplay Duration
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Majordomo Selistra|r
.goto 2022,55.10,31.04
.skipgossip 1
.turnin 66001 >>Turn in A Last Hope
.accept 66114 >>Accept For the Benefit of the Queen
.target Majordomo Selistra
step
.goto 2022,55.10,31.03
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Majordomo Selistra|r
.skipgossipid 54941
.timer 67,Ride to the Ruby Lifeshrine
.complete 66114,1 
step
#completewith next
+You can skip the next cinematic.
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alexstraza the Life-Binder|r
.goto 2022,62.34,73.02
.skipgossip 187290,1
.complete 66114,2 
.target Alexstraza the Life-Binder
step
.goto 2022,62.34,73.02
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alexstrasza the Life-Binder|r
.turnin 66114 >>Turn in For the Benefit of the Queen
.accept 66115 >>Accept The Mandate of the Red
.accept 68795 >>Accept Dragonriding
.target Alexstraza the Life-Binder
step
.goto 2022,61.90,73.82
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lifecaller Tzadrak|r
.home >>Set your Hearthstone to Ruby Lifeshrine
.target Lifecaller Tzadrak
step
.goto 2022,61.90,73.82
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lifecaller Tzadrak|r
.accept 66825 >>Accept A Ruby Lifecalling
.target Lifecaller Tzadrak
step
.goto 2022,61.85,73.83
>>Click on the four object on the table|r
.complete 66825,1 
step
.goto 2022,61.89,73.82
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lifecaller Tzadrak|r
.turnin 66825 >>Turn in A Ruby Lifecalling
.target Lifecaller Tzadrak
step
.goto 2022,61.72,73.76
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dazakros|r
.accept 66879 >>Accept Hornstrider Havoc
.target Dazakros
step
#label WakingShoreMandateOfRed1
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Xius|r
.goto 2022,60.70,74.06
.complete 66115,1 
.target Xius
.skipgossipid 55288
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Akxall|r
.goto 2022,59.36,72.41
.complete 66115,2 
.target Akxali
.skipgossipid 55289
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Andestrasz|r
.goto 2022,59.92,69.98,40,0
.goto 2022,58.37,67.12
.skipgossipid 55643
.timer 26,Roleplay Duration
.complete 68795,1 
.target Lord Andestrasz
step
.goto 2022,57.85,66.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Veritistrasz|r
.accept 70132 >>Accept Stay a While
.target Veritistrasz
step
.goto 2022,57.85,66.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tUse the |cRXP_WARN_[ExtraActionButton]|r and talk to |cRXP_FRIENDLY_Veritistrasz|r again
.complete 70132,1 
.target Veritistrasz
.skipgossipid 63862
step
.goto 2022,57.85,66.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Veritistrasz|r
.complete 70132,2 
.target Veritistrasz
.skipgossip 194076,2
step
.goto 2022,57.85,66.80
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Veritistrasz|r
.turnin 70132 >>Turn in Stay a While
.target Veritistrasz
step
.goto 2022,57.66,66.89
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Andestrasz|r
.turnin 68795 >>Turn in Dragonriding
.accept 65118 >>Accept How to Glide with Your Dragon
.target Lord Andestrasz
step
#completewith DragonridingIntroA
+You can use |T134376:0|t[Bronze Timepiece] when you fail the quest
.use 188139
step
.goto 2022,57.66,66.89
>>Use the |T4622499:0:0|t[Renewed Proto-Drake] to learn your first Dragonriding mount and |cRXP_WARN_mount up|r.
.complete 65118,1 
.use 194034
step
>>|cRXP_WARN_Walk forward and glide through the yellow rings.|r
.goto 2022,57.42,60.00
.complete 65118,2 
.complete 65118,3 
step
.goto 2022,57.48,59.10
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Celormu|r
.turnin 65118 >>Turn in How To Glide with Your Dragon
.target Celormu
step
.goto 2022,57.66,66.88
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Andestrasz|r
.accept 65133 >>Accept How to Use Momentum with Your Dragon
.target Lord Andestrasz
step
.goto 2022,57.47,59.09
>>Walk forward, aim downwards and follow the yellow rings.
.complete 65133,1 
.complete 65133,2 
.complete 65133,3 
step
.goto 2022,57.48,59.09
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Celormu|r
.turnin 65133 >>Turn in How to Use Momentum with Your Dragon
.target Celormu
step
.goto 2022,57.66,66.89
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Andestrasz|r
.accept 77345 >>Accept The Need For Higher Velocities
.target Lord Andestrasz
step
>>Use your |cRXP_WARN_Dragonriding Mount|r
>>Follow the yellow rings. Use |T4640490:0|t[Surge Forward] after each one. Don't overuse it.
.complete 77345,1 
.complete 77345,2 
.goto 2022,56.97,62.83
.complete 77345,3 
.goto 2022,57.37,59.01
step
#label DragonridingIntroA
.goto 2022,57.47,59.10
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Celormu|r
.turnin 77345 >>Turn in The Need For Higher Velocities
.target Celormu
step
.goto 2022,57.66,66.89
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Andestrasz|r
.accept 68796 >>Accept The Skytop Observatory
.target Lord Andestrasz
step
.goto 2022,57.93,68.26
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Haephesta|r
.accept 67564 >>Accept Artisan's Courier
.target Haephesta
step
.goto 2022,60.23,72.18
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thomas Bright|r
.turnin 67564 >>Turn in Artisan's Courier
.accept 67100 >>Accept A Gift for Miguel
.target Thomas Bright
step
.goto 2022,60.23,72.18
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thomas Bright|r
.complete 67100,1 
.target Thomas Bright
.skipgossipid 55060
.skipgossipid 55065
.skipgossipid 55066
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Celormu|r
.goto 2022,57.72,66.72
.skipgossip 1
.timer 12,Roleplay Duration
.complete 68796,1 
.target Celormu
step
#completewith next
+You can open your spellbook, click on the Dragonriding skill and hover over the Dragonriding Basics skill if you want to read up on Dragonriding.
step
>>Make sure to fly through every ring
.complete 68796,2 
step
.goto 2022,75.18,54.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Andestrasz|r
.turnin 68796 >>Turn in The Skytop Observatory
.accept 68797 >>Accept A New Set of Horns
.accept 68798 >>Accept Skyriding Talents and You
.target Lord Andestrasz
step
#title Dragon Glyph: Skytop Observatory Rostrum
.goto 2022,74.33,57.56
.achievement 16575,2 >>Pick up the Dragon Glyph in the air
step
.goto 2022,74.57,56.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lithragosa|r and learn the first skill named 'Drake and Rider Training'
.complete 68798,1 
.complete 68798,2 
.complete 68798,3 
.target Lithragosa
.skipgossipid 55584
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Glensera|r
.goto 2022,74.11,57.93
.complete 68797,1 
.target Glensera
step
>>Click on the |cRXP_PICK_Rostrum of Transformation|r (the pentagon on the ground). Cancel it immediately
.goto 2022,74.03,58.16
.complete 68797,2 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to Celormu. |cRXP_WARN_Hold one vigor charge so you can get back faster|r
.goto 2022,73.25,52.06
.complete 68798,5 
.target Celormu
step
.goto 2022,75.17,54.97
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Andestrasz|r
.turnin 68797 >>Turn in A New Set of Horns
.turnin 68798 >>Turn in Skyriding Talents and You
.accept 68799 >>Accept Return to the Ruby Lifeshrine
.target Lord Andestrasz
step
>>Click on |cRXP_FRIENDLY_Relastrasza|r
.goto 2022,75.01,55.58
.complete 68799,1 
.target Relastrasza
step
#title Dragon Glyph: Skytop Observatory Tower
.goto 2022,75.24,57.09
.achievement 16575,1 >>Pick up the Dragon Glyph above you above the tower
step
#completewith next
+Follow the arrow with your dragonriding mount. Aim down
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elementalist Taiyang|r
.goto 2022,66.06,58.13
.accept 66435 >>Accept Site Salvage
.accept 66436 >>Accept Unearthed Troublemakers
.target Elementalist Taiyang
step
#completewith WakingShoreAKeyElement
.isWorldQuestAvailable 2022,67113
>>Pick up the Dragon Artifacts on the ground and kill |cRXP_ENEMY_Earth Elementals|r
.goto 2022,66.06,58.13,0,0
.complete 67113,1 
.complete 67113,2 
.mob Displaced Earth
.mob Unsettled Rubble
step
#completewith WakingShoreAKeyElement
>>Kill |cRXP_ENEMY_Earth Elementals|r
.goto 2022,66.06,58.13,0,0
.complete 66436,1 
.mob Displaced Earth
.mob Unsettled Rubble
step
#completewith next
>>Kill |cRXP_ENEMY_Earth Elementals|r. Loot Orb of Primal Stone. Click it in your bags
.collect 191904,1,66437,1
.accept 66437 >>Accept A Key Element
step
#title Explorer rescued (1/5)
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to a |cRXP_FRIENDLY_Beleaguered Explorer|r
.goto 2022,67.17,58.32
.complete 66435,1,1 
.target Beleaguered Explorer
.skipgossipid 54942
step
#title Explorer rescued (2/5)
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to a |cRXP_FRIENDLY_Beleaguered Explorer|r
.goto 2022,67.53,57.97
.complete 66435,1,2 
.target Beleaguered Explorer
.skipgossipid 54942
step
#title Explorer rescued (3/5)
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to a |cRXP_FRIENDLY_Beleaguered Explorer|r
.goto 2022,67.87,57.89
.complete 66435,1,3 
.target Beleaguered Explorer
.skipgossipid 54942
step
#title Explorer rescued (4/5)
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to a |cRXP_FRIENDLY_Beleaguered Explorer|r
.goto 2022,67.81,57.37
.complete 66435,1,4 
.target Beleaguered Explorer
.skipgossipid 54942
step
#title Explorer rescued (5/5)
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to a |cRXP_FRIENDLY_Beleaguered Explorer|r
.goto 2022,67.60,56.50
.complete 66435,1 
.target Beleaguered Explorer
.skipgossipid 54942
step
#label WakingShoreAKeyElement
>>Kill |cRXP_ENEMY_Earth Elementals|r. Loot Orb of Primal Stone
.collect 191904,1,66437,1
.goto 2022,67.56,55.45,20,0
.goto 2022,66.44,57.45,20,0
.goto 2022,67.46,58.75,20,0
.accept 66437 >>Accept A Key Element
step
>>Kill |cRXP_ENEMY_Earth Elementals|r
.goto 2022,67.56,55.45,20,0
.goto 2022,66.44,57.45,20,0
.goto 2022,67.46,58.75,20,0
.goto 2022,67.89,54.73,20,0
.goto 2022,66.06,58.13
.complete 66436,1 
.mob Displaced Earth
.mob Unsettled Rubble
step
.isWorldQuestAvailable 2022,67113
>>Pick up the Dragon Artifacts on the ground and kill |cRXP_ENEMY_Earth Elementals|r
.goto 2022,66.06,58.13,0,0
.complete 67113,1 
.complete 67113,2 
.mob Displaced Earth
.mob Unsettled Rubble
step
.goto 2022,66.59,56.08
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elementalist Taiyang|r
.turnin 66436 >>Turn in Unearthed Troublemakers
.turnin 66435 >>Turn in Site Salvage
.turnin 66437 >>Turn in A Key Element
.target Elementalist Taiyang
step
.goto 2022,66.59,56.08
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Examiner Tae'shara Bloodwatcher|r, |cRXP_FRIENDLY_Elementalist Taiyang|r, and |cRXP_FRIENDLY_Acadia Chistlestone|r
.accept 66438 >>Accept Lofty Goals
.accept 66441 >>Accept Distilled Effort
.accept 66439 >>Accept Rapid Fire Plans
.target Examiner Tae'shara Bloodwatcher
.target Elementalist Taiyang
.target Acadia Chistlestone
step
.goto 2022,70.49,56.85
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zikkori|r
.accept 70994 >>Accept Drainage Solutions
.target Zikkori
step
#completewith next
>>Throw |T3610505:0|t[Zikkori's Water Siphoning Device] under the |cRXP_FRIENDLY_Glittery Streams|r
.use 200747
.goto 2022,71.94,56.48,0,0
.complete 70994,1 
step
>>Kill |cRXP_ENEMY_Acequian|r. Loot it for the orb
.goto 2022,72.17,56.71
.complete 66441,1 
.mob Acequian
step
>>Throw |T3610505:0|t[Zikkori's Water Siphoning Device] under the |cRXP_FRIENDLY_Glittery Streams|r
.use 200747
.goto 2022,71.94,56.48,0,0
.complete 70994,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zikkori|r
.goto 2022,70.50,56.84
.turnin 70994 >>Turn in Drainage Solutions
.target Zikkori
step
#completewith FierySpirits
#hidewindow
#loop
.goto 2022,68.40,63.15,30,0
.goto 2022,68.26,64.59,30,0
.goto 2022,69.35,64.39,30,0
.goto 2022,69.84,65.71,30,0
+1
step
#completewith next
>>Kill |cRXP_ENEMY_Primalist Forces|r in the area. Loot them for the |cRXP_LOOT_Firey Spirits|r
.complete 67100,2 
.mob Primalist Magmashaper
.mob Destructive Flames
.mob Ashen Spark
step
>>Kill |cRXP_ENEMY_Primalist Forces|r in the area. Loot them for the |T135821:0|t[|cRXP_LOOT_Primal Flame Fragment|r]
.complete 66439,1 
.mob Primalist Magmashaper
.mob Destructive Flames
.mob Ashen Spark
step
#label FierySpirits
>>Kill |cRXP_ENEMY_Primalist Forces|r in the area. Loot them for the Firey Spirits
.complete 67100,2 
.mob Primalist Magmashaper
.mob Destructive Flames
.mob Ashen Spark
step
.goto 2022,70.64,63.13
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Scout Ri'tal|r
.complete 66438,1 
.target Scout Ri'tal
.skipgossipid 55167
step
>>|cRXP_WARN_Hug the right wall|r
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Scout Francisco|r
.goto 2022,70.14,61.53
.complete 66438,2 
.target Scout Francisco
.skipgossipid 55168
step
>>|cRXP_WARN_Hug the left wall, then follow the arrow. Dodge the whirlwinds|r
.goto 2022,69.39,61.86,10,0
.goto 2022,69.08,61.66,8,0
.goto 2022,68.27,61.54
.complete 66438,3 
step
>>Use the |T135821:0|t[Primal Flame Fragments]
.use 192545
.goto 2022,66.59,56.08
.complete 66439,2 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elementalist Taiyang|r
.goto 2022,66.59,56.08
.turnin 66438 >>Turn in Lofty Goals
.turnin 66439 >>Turn in Rapid Fire Plans
.turnin 66441 >>Turn in Distilled Effort
.accept 66442 >>Accept Let's Get Theoretical
.target Elementalist Taiyang
step
>>Wait at the waypoint until you can use the |cRXP_WARN_[ExtraActionButton]|r and use it
.goto 2022,66.56,56.06
.skipgossip
.complete 66442,1 
.complete 66442,2 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elementalist Taiyang|r
.goto 2022,66.51,55.96
.turnin 66442 >>Turn in Let's Get Theoretical
.accept 66447 >>Accept Beyond the Barrier
.target Elementalist Taiyang
step
>>Kill the |cRXP_ENEMY_Discrodant Watcher|r
.goto 2022,66.09,55.36
.complete 66447,1 
.mob Discordant Watcher
step
.goto 2022,66.12,54.94
>>Click on the |cRXP_PICK_Fragmented Dragon Record|r
.complete 66447,2 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Elementalist Taiyang|r
.goto 2022,65.88,57.47
.turnin 66447 >>Turn in Beyond the Barrier
.target Elementalist Taiyang
step
#completewith next
.hs >>Hearth to Ruby Lifeshrine
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alexstrasza the Life-Binder|r
.goto 2022,62.34,73.02
.turnin 68799 >>Turn in Return to the Ruby Lifeshrine
.target Alexstrasza the Life-Binder
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mother Elion|r
.goto 2022,61.6,68.71
.complete 66115,3 
.target Mother Elion
.skipgossipid 55258
step
.goto 2022,62.78,70.43
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zahkrana|r
.complete 66115,4 
.target Zahkrana
.skipgossip 55290
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zahkrana|r again
.goto 2022,62.78,70.43
.turnin 66115 >>Turn in The Mandate of the Red
.target Zahkrana
step
.goto 2022,62.18,70.57
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Amella|r
.accept 70061 >>Accept Training Wings
.target Amella
step
#completewith next
+Glide with your Dragonriding mount to the Ruby Whelpling
step
>>Click on the |cRXP_FRIENDLY_Ruby Whelpling|r
.goto 2022,61.09,71.46
.skipgossip 1
.complete 70061,1 
.target Ruby Whelpling
step
>>Spam |T135808:0|t[Burning Bark] (1) to kill enemies, it is aimed where you are looking.
>>Use |T2103883:0|t[Speed of Flight] (2) to speed up.
>>Kill the Enemies in the Area
.complete 70061,4 
.complete 70061,3 
.complete 70061,2 
step
#completewith next
.exitvehicle >>|cRXP_WARN_Leave the vehicle|r
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Majordomo Selistra|r and |cRXP_FRIENDLY_Alexstrasza the Life-Binder|r
.turnin 70061 >>Turn in Training Wings
.goto 2022,62.32,72.90
.target +Majordomo Selistra
.accept 66931 >>Accept Who Brought the Ruckus?
.goto 2022,62.34,73.02
.target +Alexstrasza the Life-Binder
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tFly to Thomas Bright and talk to him
.goto 2022,60.22,72.18
.turnin 67100 >>Turn in A Gift for Miguel
.target Thomas Bright
step
.goto 2022,59.46,72.72
>>|cRXP_WARN_Follow the arrow|r
.complete 66931,1 
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Majordomo Selistra|r
.goto 2022,59.49,72.61
.turnin 66931 >>Turn in Who Brought the Ruckus?
.accept 66116 >>Accept The Primary Threat
.target Majordomo Selistra
step
.goto 2022,59.44,75.87
>>Glide down to |cRXP_FRIENDLY_Commander Lethanak|r in the Frost Area below
.complete 66116,1 
.complete 66116,2 
.target Commander Lethanak
step
.goto 2022,59.41,75.88
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Commander Lethanak|r
.turnin 66116 >>Turn in The Primary Threat
.accept 66118 >>Accept Basalt Assault
.accept 66117 >>Accept Clear the Battlefield (Bonus Objective)
.target Commander Lethanak
step
#completewith WakingShoreCutOfftheHead
>>Kill the Enemies in the area while doing the other objectives. |cRXP_WARN_Don't try to finish it now. You can finish it later|r
.complete 66117,1 
step
>>Kill |cRXP_ENEMY_Terillod|r. Be careful not to get knocked off
.goto 2022,60.64,83.01
.accept 70751 >>Accept Terillod the Devout (Elite Objective)
.complete 70751,1 
.mob Terillod the Devout
step
>>Kill |cRXP_ENEMY_Enraged Cliffs|r
#loop
.goto 2022,61.27,79.10,35,0
.goto 2022,59.71,78.62,35,0
.goto 2022,57.82,76.81,35,0
.goto 2022,60.65,78.43,35,0
.complete 66118,1 
.mob Enraged Cliff
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Commander Lethanak|r and |cRXP_FRIENDLY_Majordomo Selistra|r
.turnin 66118 >>Turn in Basalt Assault
.accept 66122 >>Accept Proto-Fight
.target +Commander Lethanak
.goto 2022,59.41,75.88
.accept 66121 >>Accept Egg Evac
.goto 2022,59.49,76.16
.target +Majordomo Selistra
step
#completewith WakingShoreEggEvac
>>Use the |T135133:0:0|t[Ruby Spear] on |cRXP_ENEMY_Galestrike Proto-Dragons|r to weaken them
.complete 66122,2 
.use 192436
.mob Galestrike Proto-Dragon
step
.goto 2022,56.13,81.29
>>Click on the |cRXP_PICK_Bronze Egg|r
.complete 66121,1 
step
.goto 2022,57.32,80.64,65,0
.goto 2022,57.35,83.28
>>Click on the |cRXP_PICK_Azure Egg|r
.complete 66121,2 
step
.goto 2022,55.32,83.31
>>Click on the |cRXP_PICK_Emerald Egg|r
.complete 66121,3 
step
#label WakingShoreEggEvac
.goto 2022,54.99,80.95
>>Click on the |cRXP_PICK_Ruby Egg|r
.complete 66121,4 
step
.goto 2022,54.77,82.22
>>Kill |cRXP_ENEMY_Klozicc the Ascended|r
.accept 66960 >>Accept Klozicc the Ascended (Elite Objective)
.complete 66960,1 
.mob Klozicc the Ascended
step
#loop
.goto 2022,56.62,80.90,40,0
.goto 2022,55.51,83.37,40,0
.goto 2022,54.55,79.83,40,0
>>Use the |T135133:0:0|t[Ruby Spear] on |cRXP_ENEMY_Galestrike Proto-Dragons|r above you to weaken them
.complete 66122,2 
.use 192436
.mob Galestrike Proto-Dragon
step
.goto 2022,53.68,80.17
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Majordomo Selistra|r
.turnin 66122 >>Turn in Proto-Fight
.turnin 66121 >>Turn in Egg Evac
.accept 66123 >>Accept Cut Off the Head
.target Majordomo Selistra
step
>>Use the |T135133:0:0|t[Ruby Spear] on |cRXP_ENEMY_Jadzigeth|r to weaken him
.use 192436
.goto 2022,53.68,83.04
.complete 66123,1 
.mob Jadzigeth
step
#label WakingShoreCutOfftheHead
.goto 2022,53.67,80.15
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Majordomo Selistra|r
.turnin 66123 >>Turn in Cut Off the Head
.accept 66124 >>Accept Exeunt, Triumphant
.target Majordomo Selistra
step
>>Kill the Enemies in the Area while doing the other objectives
#loop
.goto 2022,56.62,80.90,40,0
.goto 2022,55.51,83.37,40,0
.goto 2022,54.55,79.83,40,0
.complete 66117,1 
step
.goto 2022,48.48,78.85
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hauler Bennet|r
.accept 66963 >>Accept Out For Delivery
.target Hauler Bennet
step
.goto 2022,46.14,78.54
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Majordomo Selistra|r
.complete 66124,1 
.target Majordomo Selistra
.skipgossipid 107159
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Majordomo Selistra|r and |cRXP_FRIENDLY_Alexstrasza the Life-Binder|r
.turnin 66124 >>Turn in Exeunt, Triumphant
.goto 2022,46.14,78.51
.target +Majordomo Selistra
.accept 66079 >>Accept Wrathion Awaits
.goto 2022,46.09,78.29
.target +Alexstrasza the Life-Binder
step
.goto 2022,48.48,82.71
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cataloger Wulferd|r
.turnin 66963 >>Turn in Out For Delivery
.accept 66524 >>Accept Amateur Protography
.target Cataloger Wulferd
step
.goto 2022,45.93,81.46
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Iyali|r
.accept 69897 >>Accept Behavior Analysis "Homework"
.target Iyali
step
.goto 2022,43.80,78.35
>>Use |T1109100:0|t[Wulferd's Award-Winning Camera] and then use Catalog (1) while looking at the |cRXP_ENEMY_Hungry Proto-Drake|r |cRXP_WARN_when he is directly in front of the waypoint position|r
.complete 66524,3 
.target Hungry Proto-Drake
.use 192465
step
>>Use |T1109100:0|t[Wulferd's Award-Winning Camera] and then use Catalog (1) while looking at the |cRXP_FRIENDLY_Optimistic Whelp|r when he starts flying
.target Optimistic Whelp
.use 192465
.goto 2022,44.86,78.05
.complete 66524,2 
.target Optimistic Whelp
step
#title Sleeping Whelp pet (1/3)
.goto 2022,42.55,79.36
>>Click on the |cRXP_FRIENDLY_Sleeping Whelp|r
.complete 69897,1,1 
.target Sleeping Whelp
step
#title Sleeping Whelp pet (2/3)
.goto 2022,42.40,82.57
>>Click on the |cRXP_FRIENDLY_Sleeping Whelp|r
.complete 69897,1,2 
.target Sleeping Whelp
step
>>Use |T1109100:0|t[Wulferd's Award-Winning Camera] and then use Catalog (1) while looking at the Proto-Dragon Egg
.use 192465
.goto 2022,43.38,82.77
.complete 66524,1 
step
#title Sleeping Whelp pet (3/3)
.goto 2022,43.53,84.96
>>Click on the |cRXP_FRIENDLY_Sleeping Whelp|r
.complete 69897,1 
.target Sleeping Whelp
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cataloger Wulferd|r and |cRXP_FRIENDLY_Dervishian|r
.turnin 66524 >>Turn in Amateur Protography
.accept 66525 >>Accept Competitive Protography
.goto 2022,39.03,83.25
.target +Cataloger Wulferd
.accept 66526 >>Accept Preserving the Wilds
.goto 2022,39.08,83.27
.target +Dervishian
step
#completewith next
>>Kill the |cRXP_ENEMY_Primalists|r in the area
.complete 66526,1 
step
>>Use |T1109100:0|t[Wulferd's Award-Winning Camera] and then use Catalog (1) while looking at the Infused Proto-Dragon Egg
.use 192465
.goto 2022,38.32,80.76
.complete 66525,1 
step
.goto 2022,38.60,81.24
>>Use |T1109100:0|t[Wulferd's Award-Winning Camera], look up and then use Catalog (1) while looking at the |cRXP_ENEMY_Infused Proto-Drake|r
>>|cRXP_WARN_If it doesn't work try to get closer|r
.complete 66525,2 
.use 192465
.mob Infused Proto-Drake
step
.goto 2022,38.32,80.76
>>Kill the |cRXP_ENEMY_Primalists|r in the area
.complete 66526,1 
.mob Windborne Primalist
.mob Earthbound Primalist
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dervishian|r and |cRXP_FRIENDLY_Cataloger Wulferd|r
.turnin 66525 >>Turn in Competitive Protography
.goto 2022,39.09,83.27
.target +Dervishian
.turnin 66526 >>Turn in Preserving the Wilds
.accept 66527 >>Accept Professional Protography
.goto 2022,39.02,83.23
.target +Cataloger Wulferd
step
.goto 2022,38.95,83.39
>>|cRXP_WARN_Jump onto the spring|r
.complete 66527,1 
step
.goto 2022,38.77,84.04
>>|cRXP_WARN_Follow the spotlights|r then use |T1109100:0|t[Wulferd's Award-Winning Camera] and then use Catalog (1)
.complete 66527,2 
.use 192465
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cataloger Wulferd|r and |cRXP_FRIENDLY_Dervishian|r
.turnin 66527 >>Turn in Professional Protography
.goto 2022,39.03,83.26
.target +Cataloger Wulferd
.accept 66528 >>Accept King Without a Crown
.goto 2022,39.09,83.27
.target +Dervishian
step
.goto 2022,38.84,83.51
>>Click on the |cRXP_PICK_Proto-Dragon Charred Foreclaw|r
.complete 66528,2 
step
.goto 2022,39.13,83.94
>>Click on the |cRXP_PICK_Proto-Dragon Severed Spine|r
.complete 66528,1 
step
.goto 2022,39.39,84.03
>>Click on the |cRXP_PICK_Proto-Dragon Cracked Rib|r
.complete 66528,3 
step
.goto 2022,39.08,83.28
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dervishian|r
.turnin 66528 >>Turn in King Without a Crown
.accept 66529 >>Accept A Thousand Words
.target Dervishian
step
.goto 2022,38.92,83.52
>>Use |T1109100:0|t[Wulferd's Award-Winning Camera] and use Catalog (1) while looking at Dervishian
.complete 66529,1 
.use 192465
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Dervishian|r
.goto 2022,38.72,83.69
.turnin 66529 >>Turn in A Thousand Words
.target Dervishian
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Wrathion|r and |cRXP_FRIENDLY_Scalecommander Emberthal|r after a short roleplay
.turnin 66079 >>Turn in Wrathion Awaits
.goto 2022,42.47,66.84
.target +Wrathion
.accept 72241 >>Accept Lessons from Our Past
.goto 2022,42.47,66.78
.target +Scalecommander Emberthal
step
.goto 2022,42.47,66.79
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Scalecommander|r
.complete 72241,1 
.target Scalecommander Emberthal
.skipgossip 192795,1
step
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Scalecommander Emberthal|r and |cRXP_FRIENDLY_Wrathion|r
.turnin 72241 >>Turn in Lessons from Our Past
.accept 66048 >>Accept Best Plans and Intentions
.goto 2022,42.47,66.78
.target +Scaleecommander Emberthal
.accept 66078 >>Accept Sharp Practice
.goto 2022,42.47,66.84
.target Wrathion
step
#completewith next
.gossipoption 55311 >>Talk to |cRXP_FRIENDLY_Fao the Relentless|r then click on the |cRXP_PICK_Blacktalon Battle Plans|r
.goto 2022,42.41,66.18
.target Fao the Relentless
step
.goto 2022,42.41,66.06
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Fao the Relentless|r then click on the |cRXP_PICK_Blacktalon Battle Plans|r
.complete 66048,1 
.target Fao the Relentless
.skipgossipid 55311
step
.goto 2022,42.82,66.86
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Forgemaster Bazentus|r
.complete 66048,4 
.target Forgemaster Bazentus
.skipgossipid 55309
.skipgossipid 55310
step
#completewith next
#label ArchivistEdresConsulted
#hidewindow
.complete 66048,2 
step
#completewith ArchivistEdresConsulted
.goto 2022,43.76,67.28
.gossipoption 55307 >>Talk to |cRXP_FRIENDLY_Archivist Edress|r
.target Archivist Edres
step
#requires ArchivistEdresConsulted
#completewith next
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Blacktalon Assassins|r and defeat them. You can aggro multiple at once.
.goto 2022,42.56,67.51,0,0
.complete 66078,1 
.skipgossipid 54628
step
#requires ArchivistEdresConsulted
.goto 2022,42.30,69.29
>>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Talonstalker Kavia|r then click on the |cRX