-- ================================================ -
-- ==============  GROUP: LEGION REMIX  =========== -
-- ================================================ -

---Tips & Tricks
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name 1a) Tips & Tricks
#displayname |cFF8888880|r - Tips & Tricks|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#next a) Intro

step
    +|cRXP_WARN_|cRXP_WARN_|T1411837:0|t[Infinite Power]|r|r is the Artifact Power of Legion Remix. It fuels your Artifact Weapon, allowing you to unlock upgrades and grow stronger as you play.
step
    +|cRXP_WARN_|T1411837:0|t[Infinite Power]|r is gained from most activities e.g looting enemies, completing quests, dungeons, treasures or reward boxes.
step
    +|cRXP_WARN_|T1411833:0|t[Infinite Knowledge]|r increases the rate at which you gain |cRXP_WARN_|T1411837:0|t[Infinite Power]|r |cRXP_WARN_(Artifact Power)|r. 
    *The more ranks of |cRXP_WARN_|T1411833:0|t[Infinite Knowledge]|r you have, the more |cRXP_WARN_|T1411837:0|t[Infinite Power]|r you earn from every activity.
step
    +Since every activity rewards more |cRXP_WARN_|T1411837:0|t[Infinite Power]|r with each rank of |cRXP_WARN_|T1411833:0|t[Infinite Knowledge]|r, it’s best to unlock as much |cRXP_WARN_|T1411833:0|t[Infinite Knowledge]|r as early as possible.
step
    +There are 36 total ranks of |cRXP_WARN_|T1411833:0|t[Infinite Knowledge]|r. In Phase 1, you can obtain 28 of them: 20 from World Content & Quests and 8 from Dungeons & Raids.
step
    +|cRXP_WARN_|T3193843:0|t[Perfected Epoch Mementos]|r are account-wide items that each grant a permanent +10% XP boost to all characters in your Warband.
step
    +You can obtain a total of 9, all earned through questing — primarily by completing each zone’s main campaign.
step
    +|cRXP_WARN_|T1411833:0|t[Infinite Knowledge]|r from World Content & Quest ranks are primarily obtained by completing a zone’s main story questline and its side storylines, collectively known as Lorerunner achievements.
step
    +The default speedrun guide covers some |cRXP_WARN_|T1411833:0|t[Infinite Knowledge]|r from World Content & Quests, and most |cRXP_WARN_|T3193843:0|t[Perfected Epoch Mementos]|r.
step
    +It’s recommended to save the ones we leave out until level 80 for maximum efficiency.
step
    +You can find our full main story questline guides under Legion Remix |cRXP_WARN_(10–80+)|r Campaigns for each zone. |cRXP_WARN_Recommended at level 80|r
step
    +You can find our full side story questline guides under Legion Remix |cRXP_WARN_(10–80+)|r Sojourner for each zone. |cRXP_WARN_Recommended at level 80|r
step
    +You can choose to follow a guide that walks you through both simultaneously under |cRXP_WARN_(10–80+)|r Lorerunner. |cRXP_WARN_Recommended at level 80|r.
step
    +It can be used as a substitute for the speedrunning guide, but it’s more efficient to use at 80.
step
    +Infinite Research Quests are daily quests with over 100 possible task variations. They are extremely valuable for gearing, as their rewards scale to your level.
step
    +If you miss a day of Infinite Research Quests, they will backlog. At the start you can store up to 6 quests, all the way up to 18 quests as you progress.
step
    +It’s highly recommended to ignore this system until level 80, unless you’ve already reached the 6-quest backlog.
step
    +Rewards scale with your level and item level. Completing them at level 80 gives powerful gear right away—best done at the end of your play session, since rewards also scale with ilvl.
step
    .goto 619,45.56,68.5
    +It’s recommended to activate Heroic Mode at the console in the Infinite Bazaar|cRXP_WARN_at Level 20 or above|r, as monsters slain in this mode grant 500% more experience and more loot.
    *>>You can use |T4571434:0|t[Temporal Retreat] |cRXP_WARN_at any time |rto return to the Normal Tier. You can find the spell in your spellbook.
step
    +You can leave Heroic Mode at any time without drawbacks by using the ability |cRXP_WARN_|T4571434:0|t[Temporal Retreat]|r, found in the General tab of your spellbook.
step
    +In Legion Remix, you can fly through sky orbs and airborne demons. It’s recommended to collect them when nearby, as they reward |cRXP_WARN_|T1411837:0|t[Infinite Power]|r and unlock a quest.
step
    +At level 70, there is a quest available in the Infinite Bazaar that grants your character 250% increased experience.
step
    +We will stockpile valuable quests, bonus objectives, and instant Order Hall completes until this point to maximize XP gains from level 70 to 80.
step
    +If you’re wondering why we are not completing a certain quest or objective right away, this is most likely the reason.
step
    +|cRXP_WARN_|T4638724:0|t[Bronze]|r returns, now used purely for cosmetic purposes. You can purchase cosmetics at the Infinite Bzaar.
step
    +The Scrapper returns! Any unwanted equipment can be scrapped for |cRXP_WARN_|T1411837:0|t[Infinite Power]|r and |cRXP_WARN_|T4638724:0|t[Bronze]|r. You can access this system at the Infinite Bazaar, or anytime by using the |cRXP_WARN_|T4643984:0|t[Unraveling Sands]|r ability.
step
    +To upgrade the item level of your weapon, you must use |cRXP_WARN_|T4548903:0|t[Artifactium Sand]|r or |cRXP_WARN_|T4548902:0|t[Mound of Artifactium Sand]|r. These can be obtained from most activities.
step
    +The Active Items window gives you quick access to specific items & spells used in Legion Remix, so you don’t need to open your full inventory.
    *In this test, all items and spells are shown, but during gameplay only the items you possess and the relevant spells will be displayed.
    .macro Artifactium Sand,4548903 >>1
    .macro Mound of Artifactium Sand,4548902 >>1
    .macro Mound of Artifactium Sand,4548902 >>1
    .macro Perfected Epoch Memento,3193843 >>1
    .macro Memento of Epoch Legends,1551372 >>1
    .macro Drake Treat,132165 >>1
    .macro Timeless Scroll of Chaos,4549163 >>1
    .macro Timeless Scroll of Fortitude,4549167 >>1
    .macro Timeless Scroll of Mystic Power,4549162 >>1
    .macro Timeless Scroll of Battle Shout,4549164 >>1
    .macro Timeless Scroll of the Wild,4549165 >>1
    .macro Timeless Scroll of Cleansing,4549192 >>1
    .macro Timeless Drums,4559222 >>1
    .macro Dreamweaver Champion's Insignia,1394953 >>1
    .macro Court of Farondis Champion's Insignia,1394952 >>1
    .macro Highmountain Tribe Champion's Insignia,1394954 >>1
    .macro Nightfallen Champion's Insignia,1394956 >>1
    .macro Wardens Champion's Insignia,1394958 >>1
    .macro Army of the Light Champion's Insignia,1708497 >>1
    .macro Valarjar Champion's Insignia,1394957 >>1
    .macro Legionfall Champion's Insignia,1585421 >>1
    .macro Argussian Reach Champion's Insignia,1708496 >>1
    .macro Temporal Retreat,4571434 >>1
    .macro Unraveling Sands,4643984 >>1
]])

---Intro
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name a) Intro
#displayname |cFF00FF001|r - Intro|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#next aa) Skyriding
#subweight 100

step
    #completewith Fixed Point in Time
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    .goto 627,72.46,45.90
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Moratari|r
    .accept 89404 >>Accept Time Crisis
    .target Moratari
step
    .goto 627,72.46,45.90
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Moratari|r
    .complete 89404,1 --1/1 Talk to Moratari
    .skipgossipid 133083
    .target Moratari
step
    .goto 627,67.03,43.15,5,0
    .goto 627,67.63,42.47
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
    .turnin 89404 >>Turn in Time Crisis
    .target Archmage Khadgar
    .accept 89405 >>Accept Mean Streets of Dalaran
step
    .goto 627,72.46,45.90
    .achievementComplete 42313,1
    +|cRXP_WARN_You’ve already completed the intro before. By clicking the text below, you’ll skip the intro for faster leveling|r.
    *Manually skip this step if you prefer to play through that content.
    .clicknext RestedXP Legion Remix\a) Intro Skip >>CLICK HERE FOR THE GUIDE.
step << Alliance
    .isOnQuest 89405
    #title |cFFFCDC00Check Note|r
    .goto 627,67.24,39.87,5,0
    .goto 627,67.59,39.09,5,0
    .goto 627,65.54,39.69,5,0
    .goto 627,65.45,39.37,5 >>Climb the Wall and Jump Down
    .timer 5,RP
step << Horde
    #completewith next
    #label Legion demons purged
    >>Kill |cRXP_ENEMY_Demons|r
    .complete 89405,1 --Legion demons purged (100%)
    .mob Felguard Invader
    .mob Felstalker
    .mob Felstalker Broodling
    .mob Imp Scout
    .mob Felfire Imp
step << Horde
    #title |cFFFCDC00Check Note|r
    #completewith Legion demons purged
    .goto 627,61.74,41.58,10,0
    .goto 627,59.3,43.95,10 >>Enter Dalaran City
step << Horde
    #requires Legion demons purged
    .goto 627,54.46,39,30,0
    .goto 627,50.45,33.52,15,0
    .goto 627,52.19,42.07,15,0
    .goto 627,45.67,54.09,15,0
    .goto 627,42.49,57.09,15,0
    .goto 627,33.85,54.79,15,0
    .goto 627,42.69,56.95
    >>Kill |cRXP_ENEMY_Demons|r
    .complete 89405,1 --Legion demons purged (100%)
    .mob Felguard Invader
    .mob Felstalker
    .mob Felstalker Broodling
    .mob Imp Scout
    .mob Felfire Imp
step << Alliance
    .goto 627,54.46,39,30,0
    .goto 627,50.45,33.52,15,0
    .goto 627,52.19,42.07,15,0
    .goto 627,45.67,54.09,15,0
    .goto 627,42.49,57.09,15,0
    .goto 627,33.85,54.79,15,0
    .goto 627,42.69,56.95
    >>Kill |cRXP_ENEMY_Demons|r
    .complete 89405,1 --Legion demons purged (100%)
    .mob Felguard Invader
    .mob Felstalker
    .mob Felstalker Broodling
    .mob Imp Scout
    .mob Felfire Imp
step
    .goto 627,49.08,46.96,5,0
    .goto 627,49.29,47.58
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r at the center of dalaran.
    .turnin 89405 >>Turn in Mean Streets of Dalaran
    .target Archmage Khadgar
    .accept 89406 >>Accept Seal and Protect
step
    #completewith Storm the Citadel2
    .achievementComplete 42313,1
    +You have the option to reconsider your choice until you get teleported out of dalaran.
    *|cRXP_WARN_You may manually skip this step if you prefer|r.
    .clicknext RestedXP Legion Remix\a) Intro Skip >>CLICK HERE FOR THE GUIDE.
step
    #completewith next
    #label Magical barriers
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Magical barrier|r |cRXP_WARN_from very far away|r.
    .complete 89406,2,1 --5/5 Magical barriers reinforced
step
    #completewith Magical barriers
    .goto 627,45.33,43.21,10 >>Leave Buildung
step
    #requires Magical barriers
    .goto 627,41.39,39.5,8,0
    .goto 627,41.98,37.77
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Magical barrier|r |cRXP_WARN_to your right from a far|r.
    .complete 89406,2,1 --5/5 Magical barriers reinforced
step
    .goto 627,37.69,34.76
    >>Stand on the Arrow Location and click on the |cRXP_PICK_Magical barrier|r infront of you.
    *|cRXP_WARN_Make sure to do this to receive credit for all three doors at once.|r
    .complete 89406,2,4 --5/5 Magical barriers rein}forced
step
    .goto 627,40.62,30.13,8,0
    .goto 627,41.24,31.57
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Magical barrier|r |cRXP_WARN_to your right from a far|r.
    .complete 89406,2,5 --5/5 Magical barriers reinforced
step
    .goto 627,42.26,27.69,2,0
    .goto 627,42.81,27.66
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r
    .complete 89406,3 --1/1 Talk to Momentus
    .skipgossipid 133082
    .skipgossipid 133050
    .skipgossipid 133081
    .target Momentus
step
    #label Seal and Protect
    .goto 627,42.81,27.66
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r
    .turnin 89406 >>Turn in Seal and Protect
    .target Momentus
    .accept 89407 >>Accept Thrift
    .accept 89408 >>Accept Threadbare
step
    #completewith next
    #label Frayed Temporal Threads1
    #title |cFFFCDC00Run through the Yellow Orbs|r
    .complete 89408,1,1 --12/12 Frayed Temporal Threads collected
step
    #completewith Frayed Temporal Threads1
    .goto 627,40.76,27.5,5 >>Enter Building
step
    #requires Frayed Temporal Threads1
    .goto 627,41.17,26.74
    #title |cFFFCDC00Run through the Yellow Orbs|r
    .complete 89408,1,1 --12/12 Frayed Temporal Threads collected
step
    .goto 627,40.69,24.04
    #title |cFFFCDC00Run through the Yellow Orbs|r
    .complete 89408,1,2 --12/12 Frayed Temporal Threads collected
step
    .goto 627,40.69,24.04
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Archeology Chest|r
    .complete 89407,1 --1/1 Dusty Stone Tablet
step
    .goto 627,40.22,25.16
    #title |cFFFCDC00Run through the Yellow Orbs|r
    .complete 89408,1,3 --12/12 Frayed Temporal Threads collected
step
    #completewith next
    #label Yellow Orbs1
    #title |cFFFCDC00Run through the Yellow Orbs|r
    .complete 89408,1,4 --12/12 Frayed Temporal Threads collected
step
    #completewith Yellow Orbs1
    #title |cFFFCDC00Leave Building|r
    .goto 627,40.61,27.39,5 >>Leave the building
step
    #requires Yellow Orbs1
    .goto 627,38.72,35.12
    #title |cFFFCDC00Run through the Yellow Orbs|r
    .complete 89408,1,4 --12/12 Frayed Temporal Threads collected
step
    .goto 627,39.63,38.61
    #title |cFFFCDC00Run through the Yellow Orbs|r
    .complete 89408,1,5 --12/12 Frayed Temporal Threads collected
step
    .goto 627,40.22,41.27
    #title |cFFFCDC00Run through the Yellow Orbs|r
    .complete 89408,1,6 --12/12 Frayed Temporal Threads collected
step
    .goto 627,38.36,40.37
    #title |cFFFCDC00Run through the Yellow Orbs|r
    .complete 89408,1,7 --12/12 Frayed Temporal Threads collected
step
    .goto 627,38.82,39.94
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Curio Lockbox|r |cRXP_WARN_to your right|r.
    .complete 89407,3 --1/1 Curious Curio
step
    #completewith next
    #label Yellow Orbs2
    #title |cFFFCDC00Run through the Yellow Orbs|r
    .complete 89408,1,8 --12/12 Frayed Temporal Threads collected
step
    #completewith Yellow Orbs2
    #title |cFFFCDC00Leave Building|r
    .goto 627,39.94,42.24,5 >>Leave the Building
step
    #requires Yellow Orbs2
    .goto 627,42.27,37.93
    #title |cFFFCDC00Run through the Yellow Orbs|r
    .complete 89408,1,8 --12/12 Frayed Temporal Threads collected
step
    .goto 627,44.76,32
    #title |cFFFCDC00Run through the Yellow Orbs|r
    .complete 89408,1,9 --12/12 Frayed Temporal Threads collected
step
    .goto 627,43.96,29.94
    #title |cFFFCDC00Run through the Yellow Orbs|r
    .complete 89408,1,10 --12/12 Frayed Temporal Threads collected
step
    .goto 627,45.98,25.49
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Weapon Crate|r
    .complete 89407,2 --1/1 Bent and Battered Blade
step
    .goto 627,46.46,25.91
    #title |cFFFCDC00Run through the Yellow Orbs|r
    .complete 89408,1,11 --12/12 Frayed Temporal Threads collected
step
    .goto 627,46.06,27.68
    #title |cFFFCDC00Run through the Yellow Orbs|r
    .complete 89408,1,12 --12/12 Frayed Temporal Threads collected
step
    #completewith next
    #label Turn in Thrift
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r
    .turnin 89407 >>Turn in Thrift
    .turnin 89408 >>Turn in Threadbare
    .accept 89409 >>Accept Infinite Bronze
    .disablecheckbox
    .target Momentus
step
    #completewith Turn in Thrift
    .goto 627,43.96,29.97,5 >>Leave Building
step
    #requires Turn in Thrift
    .goto 627,42.83,27.66
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r
    .turnin 89407 >>Turn in Thrift
    .target Momentus
    .turnin 89408 >>Turn in Threadbare
    .accept 89409 >>Accept Infinite Bronze
step
    #completewith next
    #label Arrived at Tanks for Everything
    #title |cFFFCDC00Follow the Arrow|r
    .complete 89409,1 --Arrived at Tanks for Everything
step
    #completewith Arrived at Tanks for Everything
    #title |cFFFCDC00Enter Building|r
    .goto 627,43.92,29.96,10 >>Enter the Building
step
    #requires Arrived at Tanks for Everything
    #completewith next
    #label Temporal fibers0
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Forge|r |cRXP_WARN_on the wall|r.
    .complete 89409,2 --1/1 Anchor materials prepared
step
    #completewith Temporal fibers0
    #requires Arrived at Tanks for Everything
    .goto 627,45.14,29.31
    #title |cFFFCDC00Follow the Arrow|r
    .complete 89409,1 --Arrived at Tanks for Everything
step
    #requires Temporal fibers0
    #completewith next
    #label Temporal fibers
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Temporal fibers|r on the anvil.
    .complete 89409,3 --1/1 Temporal fibers separated
step
    #requires Temporal fibers0
    #completewith Temporal fibers
    .goto 627,45.14,29.31
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Forge|r on the wall.
    .complete 89409,2 --1/1 Anchor materials prepared
step
    #requires Temporal fibers
    #completewith next
    #label Temporal fibers separated
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Bars|r |cRXP_WARN_on the table infront of you|r.
    .complete 89409,4 --1/1 Anchoring materials infused
step
    #requires Temporal fibers
    #completewith Temporal fibers separated
    .goto 627,45.14,29.31
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Temporal fibers|r on the anvil.
    .complete 89409,3 --1/1 Temporal fibers separated
step
    #requires Temporal fibers separated
    #completewith next
    #label Infinite Bronze forged
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Bronze|r on the anvil.
    .complete 89409,5 --1/1 Infinite Bronze forged
step
    #requires Temporal fibers separated
    #completewith Infinite Bronze forged
    .goto 627,45.14,29.31
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Bars|r |cRXP_WARN_on the table infront of you from a far|r.
    .complete 89409,4 --1/1 Anchoring materials infused
step
    #requires Infinite Bronze forged
    .goto 627,45.14,29.31
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick the |cRXP_PICK_Bronze|r on the anvil.
    .complete 89409,5 --1/1 Infinite Bronze forged
step
    #completewith next
    #label Infinite Bronze
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r
    .turnin 89409 >>Turn in Infinite Bronze
    .target Momentus
step
    #completewith Infinite Bronze
    #title |cFFFCDC00Leave Building|r
    .goto 627,43.49,30.07,8 >>Leave the Building
step
    #requires Infinite Bronze
    .goto 627,42.81,27.73
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r
    .turnin 89409 >>Turn in Infinite Bronze
    .accept 90659 >>Accept Something Borrowed
    .target Momentus
step
    .goto 627,42.81,27.73
    #title |cFFFF0000STOP|r
    *|cRXP_WARN_MAKE SURE YOU HAVE YOUR DESIRED SPEC SELECTED BEFORE PROCEEDING|r.
    *|cRXP_WARN_THIS UNLOCKS YOUR FIRST ARTIFACT WEAPON|r.
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r
    .complete 90659,2 --1/1 Speak to Momentus after choosing a talent specialization
    .target Momentus
    -- .skipgossipid 133562
step
    .goto 627,42.78,28.15
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Temporal Knot|r
    .complete 90659,3 --1/1 Artifact Swapped
    .macro Open Artifact Tree,1411839 >> /run SocketInventoryItem(16)
    .target Momentus
step
    .goto 627,42.17,28.44
    >>|cRXP_WARN_In the "Active Items" section|r:
    *There is a macro, use the macro, learn the skill, apply changes, and place the skill on your action bars.
    .complete 90659,4 --Purchase the Remix Time trait in your Artifact Weapon
    .macro Open Artifact Tree,1411839 >> /run SocketInventoryItem(16)
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r
    .turnin 90659 >>Turn in Something Borrowed
    .accept 89412 >>Accept Get Plenty of Exorcise
    .accept 90901 >>Accept As A Matter of Artifact
    .goto 627,42.46,28.05
    .target +Momentus
step 
    .isQuestComplete 90901
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r
    .turnin 90901 >>Turn in As A Matter of Artifact
    .goto 627,42.46,28.05
    .target +Momentus
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Erus|r
    .accept 89411 >>Accept Scavenger Hunting
    .goto 627,42.31,27.32
    .target +Erus
step
    #completewith Infinite Power
    >>Kill |cRXP_ENEMY_Demons|r. Loot them for |T134515:0|t[|cRXP_LOOT_Legion Armor Scraps|r] and |T1411837:0|t[|cRXP_LOOT_Infinite Power|r].
    .complete 89411,1 --1/1 Legion Armor Scraps
    .complete 90901,1 --250/250 Infinite Power gathered
    .mob Felstalker
    .mob Felguard Invader
step
    #completewith next
    #label Legion Portal Sealed
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal|r
    .complete 89412,1,1 --2/2 Legion Portal Sealed
    .target Legion Portal
step
    #completewith Legion Portal Sealed
    .goto 627,46.47,38.67,10,0
    .goto 627,50.89,40.49,8,0
    .goto 627,50.18,41.85,8,0
    .goto 627,48.33,40.01,8,0
    .goto 627,48.06,37.29,6 >>Enter Building and go upstairs
step
    #requires Legion Portal Sealed
    .goto 627,48.06,37.29
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal|r
    .complete 89412,1,1 --2/2 Legion Portal Sealed
    .target Legion Portal
step
    #completewith next
    #label Legion Portal Sealed2
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal|r
    .complete 89412,1,2 --2/2 Legion Portal Sealed
    .target Legion Portal
step
    #completewith Legion Portal Sealed2
    .goto 627,49.41,37.4,10,0
    .goto 627,58.07,46.32,20,0
    .goto 627,56.98,46.74,8,0
    .goto 627,56.86,46.8,5 >>Jump down and Enter the building
    #title |cFFFCDC00Enter Building|r
step
    #requires Legion Portal Sealed2
    #completewith next
    #label Infinite Power
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal|r
    .complete 89412,1,2 --2/2 Legion Portal Sealed
    .target Legion Portal
step
    #requires Legion Portal Sealed2
    #completewith Infinite Power
    .goto 627,54.74,47.14,2 >>Portal Click Range
step
    #requires Infinite Power
    .goto 627,53.1,47.46
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal|r
    .complete 89412,1,2 --2/2 Legion Portal Sealed
    .target Legion Portal
step
    #completewith next
    #hidewindow
    #label Scavenger Hunting
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r and |cRXP_FRIENDLY_Erus|r
    .turnin 89411 >>Turn in Scavenger Hunting
step
    #completewith Scavenger Hunting
    #title |cFFFCDC00Leave Building|r
    .goto 627,57.66,46.35,10 >>Leave the Building
step
    #requires Scavenger Hunting
    #loop
    .goto 627,49.49,32.77,30,0
    .goto 627,51.11,23.6,30,0
    .goto 627,42.29,39.36,30,0
    .goto 627,34.84,43.01,30,0
    >>Kill |cRXP_ENEMY_Demons|r. Loot them for |T134515:0|t[|cRXP_LOOT_Legion Armor Scraps|r] and |T1411837:0|t[|cRXP_LOOT_Infinite Power|r].
    .complete 89411,1 --1/1 Legion Armor Scraps
    .complete 90901,1 --250/250 Infinite Power gathered
    .mob Felstalker
    .mob Felguard Invader
step
    .goto 627,42.79,27.78
    >>|cRXP_WARN_Use the macro, learn the skills, apply changes, and place the skill on your action bars.|r
    .complete 90901,2 --250/250 Infinite Power gathered
    .macro Open Artifact Tree,1411839 >> /run SocketInventoryItem(16)
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Erus|r
    .turnin 89411 >>Turn in Scavenger Hunting
    .accept 89413 >>Accept Obliterate, Then Iterate
    .goto 627,42.34,27.40
    .target +Erus
step
    #completewith next
    #label Legion Armor Scraps
    >>Click on the |T134515:0|t[Legion Armor Scraps] to put it into the Scrapper and then press scrap.
    .complete 89413,2 --1/1 Scrap Legion Armor Scraps
step
    #completewith Legion Armor Scraps
    .goto 627,42.33,27.22
    .cast 1232807 >>Use [Unraveling Sands]
    *|cRXP_WARN_A button appeared in your UI. You can drag the ability to your action bars if you wish.|r
    .usespell 1232807
step
    #requires Legion Armor Scraps
    .goto 627,42.33,27.22
    >>|cRXP_WARN_You have summoned the |cRXP_PICK_Unraveling Sand|r|r (maybe inside |cRXP_FRIENDLY_Erus|r). Click it and click on the Scrap button.
    .complete 89413,2 --1/1 Scrap Legion Armor Scraps
    .scrap 251901
step
    .goto 627,42.33,27.22
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Erus|r
    .turnin 89413 >>Turn in Obliterate, Then Iterate
    .target Erus
step
    #label Storm the Citadel2
    .goto 627,42.73,27.78
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r
    .turnin 89412 >>Turn in Get Plenty of Exorcise
    .turnin 90901 >>Turn in As A Matter of Artifact
    .target +Momentus
step
    .goto 627,42.75,27.82
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r
    .accept 89414 >>Accept Not A Memento Too Soon
    .target Momentus
step
    #completewith next
    #label Not A Memento Too Soon
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
    .turnin 89414 >>Turn in Not A Memento Too Soon
    .accept 89415 >>Accept Storm the Citadel
    .disablecheckbox
    .target Archmage Khadgar
step
    #completewith Not A Memento Too Soon
    .goto 627,45.82,43.5,10 >>Enter the Building
    #title |cFFFCDC00Enter Building|r
step
    #requires Not A Memento Too Soon
    .goto 627,49,47.28
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
    .turnin 89414 >>Turn in Not A Memento Too Soon
    .target Archmage Khadgar
    .accept 89415 >>Accept Storm the Citadel
step
    #completewith next
    #hidewindow
    #label Fel Lord Nezmet
    >>Kill |cRXP_ENEMY_Fel Lord Nezmet|r
    .complete 89415,2 --1/1 Fel Lord Nezmet slain
    .mob Fel Lord Nezmet
step
    #completewith Fel Lord Nezmet
    #title |cFFFCDC00Leave Building|r
    .goto 627,46.28,53.18,10 >>Leave the Building
step
    #requires Fel Lord Nezmet
    #completewith next
    #label Fel Lord Nezmet2
    >>Kill |cRXP_ENEMY_Fel Lord Nezmet|r
    .complete 89415,2 --1/1 Fel Lord Nezmet slain
    .mob Fel Lord Nezmet
step
    #requires Fel Lord Nezmet
    #completewith Fel Lord Nezmet2
    .goto 627,31.54,48.93,10 >>Enter the Building
    #title |cFFFCDC00Enter Building|r
step
    #requires Fel Lord Nezmet2
    .goto 627,28.63,48.79
    >>Kill |cRXP_ENEMY_Fel Lord Nezmet|r
    .complete 89415,2 --1/1 Fel Lord Nezmet slain
    .mob Fel Lord Nezmet
step
    #completewith next
    #label Storm the Citadel
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
    .turnin 89415 >>Turn in Storm the Citadel
    .target Archmage Khadgar
step
    #completewith Storm the Citadel
    .goto 627,46.28,53.18,10 >>Enter the Building
    #title |cFFFCDC00Enter Building|r
step
    #requires Storm the Citadel
    .goto 627,49.54,48.02
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
    .turnin 89415 >>Turn in Storm the Citadel
    .target Archmage Khadgar
step
    .goto 627,51.03,48.13,-1
    .goto 627,72.42,45.93,-1
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Moratari|r
    .accept 89416 >>Accept Eternal Gratitude
    .target Moratari
step
    .goto 627,51.01,47.31
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal|r
    .complete 89416,1 --1/1 Portal used
step
    #completewith next
    #label Eternal Gratitude
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eternus|r
    .turnin 89416 >>Turn in Eternal Gratitude
    .target Eternus
    .accept 89417 >>Accept Infinite Meetings
step
    #title |cFFFCDC00Mount UP|r
    #completewith Eternal Gratitude
    .goto 619,45.65,67.63,2 >>Mount up now, as you are about to enter a no-mount zone.
step
    #requires Eternal Gratitude
    #completewith next
    #label Infinite Meetings
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eternus|r
    .turnin 89416 >>Turn in Eternal Gratitude
    .target Eternus
    .accept 89417 >>Accept Infinite Meetings
    .disablecheckbox
step
    #requires Eternal Gratitude
    #completewith Infinite Meetings
    .goto 619,45.69,68.36,3 >>Dragon Click/Interact Range
step
    #requires Infinite Meetings
    .goto 619,45.7,68.53
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eternus|r
    .turnin 89416 >>Turn in Eternal Gratitude
    .target Eternus
    .accept 89417 >>Accept Infinite Meetings
step
    #completewith skyride
    +|cRXP_WARN_You can skyride now|r.
step
    .goto 619,45.79,68.29,5,0
    .goto 619,45.82,68.31
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hemet Nesingwary XVII|r
    .complete 89417,4 --1/1 Meet Hemet
    .target Hemet Nesingwary XVII
    .skipgossipid 135505
step
    .goto 619,45.81,68.17,5,0
    .goto 619,45.84,68.18
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Horos|r
    .complete 89417,3 --1/1 Meet Horos
    .skipgossipid 135504
    .target Horos
step
    .goto 619,45.83,68.00
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r
    .complete 89417,2 --1/1 Meet Momentus, again
    .skipgossipid 133280
    .target Momentus
step
    .goto 619,45.96,67.89
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nostwin|r
    .complete 89417,1 --1/1 Meet Nostwin
    .skipgossipid 133270
step
    .goto 619,45.53,67.84
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Pythagorus|r
    .complete 89417,6 --1/1 Meet Pythagorus
    .skipgossipid 135503
    .target Pythagorus
step
    #label skyride
    .goto 619,45.48,68.38
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Larah Treebender|r
    .complete 89417,5 --1/1 Meet Larah
    .skipgossipid 135502
    .target Larah Treebender
step
    .goto 619,45.6,68.43,5,0
    .goto 619,45.69,68.54
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eternus|r |cRXP_WARN_from a far|r.
    .turnin 89417 >>Turn in Infinite Meetings
    .accept 89418 >>Accept A Fixed Point in Time
    .target Eternus
step
    #completewith next
    #hidewindow
    #label Krasus' Landing
    .complete 89418,1 --1/1 Fly with Moratari to Krasus' Landing
step
    #completewith Krasus' Landing
    #title |cFFFCDC00Spam Macro|r
    .goto 619,45.64,67.7
    .gossipoption 133297 >>|cRXP_WARN_In the "Active Items" section|r There is a macro, spam it after talking to |cRXP_FRIENDLY_Moratari|r.
    .timer 68,RP
    .target Moratari
    .macro Leave Vehicle,6656430 >> /leavevehicle
step
    #requires Krasus' Landing
    .isOnQuest 89418
    .goto 619,45.96,67.89
    #title |cFFFCDC00Spam Macro|r
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nostwin|r
    .home >>Set your Hearthstone to Dalaran
    .macro Leave Vehicle,6656430 >> /leavevehicle
step
    .goto 619,45.86,68.00
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lidamorrutu|r 
    *|cRXP_WARN_You can skip this and do it later; completing it at level 80 with higher ilvl gives better gear, but since it’s a daily, you might not want to miss it|r.
    .daily 92855 >>Accept in Make Haste, Not Waste
    .dailyturnin 92855 >>Turn in Make Haste, Not Waste
    .xp <11,1
    .achievementComplete 42301,1
    .target Lidamorrutu
step
    .goto 619,45.83,68.00
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r
    .accept 91955 >>Accept Just Between Us
    .target Momentus
step
    .isOnQuest 89418
    .goto 619,45.71,67.46
    .zone 627 >>Click on the |cRXP_PICK_Portal|r
step <<!DemonHunter
    #completewith next
    #label The Legion Returns
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archivist Elysiana|r.
    .accept 40519 >>Accept Legion: The Legion Returns << Alliance
    .accept 43926 >>Accept Legion: The Legion Returns << Horde
    .target Archivist Elysiana
    .skipgossipid 45296
step <<!DemonHunter
    #completewith The Legion Returns
    .goto 627,31.57,49.39,20 >>Enter the Violet Hold
step <<!DemonHunter
    #requires The Legion Returns
    #label Intro
    .goto 627,30.26,51.21
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archivist Elysiana|r.
    .accept 40519 >>Accept Legion: The Legion Returns << Alliance
    .accept 43926 >>Accept Legion: The Legion Returns << Horde
    .target Archivist Elysiana
    .skipgossipid 45296
step <<!DemonHunter
    #completewith next
    #label The Legion Returns2
    .cast 1257698 >>Use |T1528676:0|t[Elixir of Remembered Sight] to reveal herbs and ores on the minimap. Collect them when nearby to gain more Infinite Might and increase your overall power.
    .use 254320
    .aura 1257698
step <<!DemonHunter
    #completewith The Legion Returns2
    .goto 627,33.1,49.47,20 >>Leave the Violet Hold
step <<!DemonHunter
    #requires The Legion Returns2
    .goto 627,71.94,41.44
    .cast 1257698 >>Use |T1528676:0|t[Elixir of Remembered Sight] to reveal herbs and ores on the minimap. Collect them when nearby to gain more Infinite Might and increase your overall power.
    .use 254320
    .aura 1257698
step <<DemonHunter
    .goto 627,71.94,41.44
    .cast 1257698 >>Use |T1528676:0|t[Elixir of Remembered Sight] to reveal herbs and ores on the minimap. Collect them when nearby to gain more Infinite Might and increase your overall power.
    .use 254320
    .aura 1257698
step
    #label Fixed Point in Time
    .goto 627,71.94,41.44
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 89418,1 --1/1 Fly with Moratari to Krasus' Landing
step
    .goto 627,72.04,41.59
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Moratari|r
    .turnin 89418 >>Turn in A Fixed Point in Time
    .target Moratari
]])

---Intro Skip
RXPGuides.RegisterGuide([[
#retail
#version 1
#chapter
#group RestedXP Legion Remix
#name a) Intro Skip
#displayname |cFF00FF001|r - Intro Skip|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#next aa) Skyriding

step
    .goto 627,72.46,45.90
    .achievementComplete 42313,1
    .gossipoption 134056 >>Before talking to |cRXP_FRIENDLY_Moratari|r, make sure you have your desired specialization selected. 
    *|cRXP_WARN_This will grant you the Artifact Weapon for your chosen spec; you can obtain others later, but there’s no immediate access|r.
    .target Moratari

]])

---Skyriding
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#name aa) Skyriding
#displayname |cFF00FF002|r - Skyriding|r
#next ab) Order Hall Death Knight Part 1 << DeathKnight
#next ab) Order Hall Demon Hunter Part 1 << DemonHunter
#next ab) Order Hall Druid Part 1 << Druid
#next ab) Order Hall Hunter Part 1 << Hunter
#next ab) Order Hall Mage Part 1 << Mage
#next ab) Order Hall Monk Part 1 << Monk
#next ab) Order Hall Paladin Part 1 << Paladin
#next ab) Order Hall Priest Part 1 << Priest
#next ab) Order Hall Rogue Part 1 << Rogue
#next ab) Order Hall Shaman Part 1 << Shaman
#next ab) Order Hall Warlock Part 1 << Warlock
#next ab) Order Hall Warrior Part 1 << Warrior

step
    .goto 627,72.06,41.69
    .isQuestTurnedIn account,80018
    +|cRXP_WARN_You’ve already completed the Skyriding intro before. By clicking the text below, you’ll skip the Skyriding intro for faster leveling|r.
    *Manually skip this step if you prefer to play through that content.
    .clicknext RestedXP Legion Remix\aa) Skyriding Skip >>CLICK HERE FOR THE GUIDE
step
    #include RestedXP Legion Remix\a) Skyriding Panda


]])

---Skyriding Skip
RXPGuides.RegisterGuide([[
#retail
#version 1
#chapter
#group RestedXP Legion Remix
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#name aa) Skyriding Skip
#displayname |cFF00FF002|r - Skyriding Skip|r
#next ab) Order Hall Death Knight Part 1 << DeathKnight
#next ab) Order Hall Demon Hunter Part 1 << DemonHunter
#next ab) Order Hall Druid Part 1 << Druid
#next ab) Order Hall Hunter Part 1 << Hunter
#next ab) Order Hall Mage Part 1 << Mage
#next ab) Order Hall Monk Part 1 << Monk
#next ab) Order Hall Paladin Part 1 << Paladin
#next ab) Order Hall Priest Part 1 << Priest
#next ab) Order Hall Rogue Part 1 << Rogue
#next ab) Order Hall Shaman Part 1 << Shaman
#next ab) Order Hall Warlock Part 1 << Warlock
#next ab) Order Hall Warrior Part 1 << Warrior

step
    .goto 627,72.05,41.65
    .gossipoption 133762 >>Talk to |cRXP_FRIENDLY_Moratari|r
    .target Moratari



]])

---Monk Order Hall Intro 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#name ab) Order Hall Monk Part 1 
#displayname |cFF00FF003|r - Order Hall Intro 1|r

<< Monk

step
    .isQuestTurnedIn account,91955
    .achievementComplete 61108,1
    +|cRXP_WARN_You’ve already got the 10% XP bonus from the artifact questline. By clicking the text below, you’ll skip the Order Hall intro and parts of Azsuna for faster leveling|r.
    *Manually skip this step if you prefer to play through that content.
    .clicknext RestedXP Legion Remix\ae) First Zone 2 >>CLICK HERE FOR THE GUIDE.
step
    #completewith The Dawning Light
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #label MonkStart1
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Initiate Da-Nel|r |cRXP_WARN_next to you when in dalaran|r.
    .accept 12103 >>Accept Before the Storm
    .target Initiate Da-Nel
step
    .goto 627,38.75,64.25 << Alliance
    .goto 627,56.06,22.77 << Horde
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal|r
    .complete 12103,2 --1/1 Travel to Peak of Serenity by Zen Pilgrimage or Dalaran portal
step
    .goto 424,44.88,27.75
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_PICK_Master Hight|r
    .complete 12103,3 --1/1 Speak with Master Hight
    .timer 42,RP
    .target Master Hight
step
    .goto 424,45,27.6
    .isOnQuest 12103
    #title Wait at Door
    .countdown 32 >>|cRXP_WARN_Wait for the Roleplay|r.
step
    .isOnQuest 12103
    .goto 424,45,27.6
    #title Wait at Door
    >>Kill |cRXP_ENEMY_Infernal Destroyer|r |cRXP_WARN_after the roleplay|r.
    .scenario 1887,1
    .mob Infernal Destroyer
step
    #completewith Portal Master Jorvinax
    +You can't mount in this scenario
step
    .isInScenario 943
    #completewith next
    #label Vizznak
    .goto 424,44.64,27.73,30,0
    .goto 424,44.37,27.58,30,0
    .goto 424,43.65,27.49,30,0
    >>Enter the cave and kill |cRXP_ENEMY_Vizznak|r.
    .scenario 1896,1
    .mob Vizznak
step
    .isInScenario 943
    #completewith Vizznak
    .goto 424,43.45,27.64,40 >>Follow the Arrow
step
    .isInScenario 943
    #requires Vizznak
    .goto 424,43.45,27.64,20,0
    .goto 424,43.87,27.36
    >>Kill |cRXP_ENEMY_Vizznak|r and afterwards leave the cave.
    .scenario 1896,1
    .timer 23,RP
    .mob Vizznak
step
    .isInScenario 943
    #completewith next
    #label Number Nine Jia
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .scenario 1897,1
step
    .isInScenario 943
    #completewith Number Nine Jia
    .goto 424,43.87,27.36
    .cast 193726 >>Click on the |cRXP_PICK_Number Nine Jia|r
    .timer 21,RP
    .target Number Nine Jia
step
    .isInScenario 943
    #requires Number Nine Jia
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .scenario 1897,1
step
    .isInScenario 943
    #completewith next
    #label Morvath the Reaver
    .goto 424,45.3,26.4,10,0
    >>Kill |cRXP_ENEMY_Morvath the Reaver|r
    .scenario 1898,1
    .mob Morvath the Reaver
step
    .isInScenario 943
    #completewith Morvath the Reaver
    #hidewindow
    .goto 424,45.53,25.6,50 >>1
step
    .isInScenario 943
    #requires Morvath the Reaver
    .goto 424,45.53,25.6
    >>Kill |cRXP_ENEMY_Morvath the Reaver|r
    .scenario 1898,1
    .timer 35,RP
    .mob Morvath the Reaver
step
    .isInScenario 943
    .goto 424,45.28,26.4
    .countdown 35 >>Kill |cRXP_ENEMY_Infernal Invader|r
    .mob Infernal Invader
step
    .isInScenario 943
    .goto 424,45.09,26.57,10 >>Follow the Arrow
    .timer 20,RP
step
    .isInScenario 943
    .goto 424,44.69,26.7
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .scenario 1899,1
step
    #label Portal Master Jorvinax
    .isInScenario 943
    .goto 424,44.67,26.71
    >>Kill |cRXP_ENEMY_Portal Master Jorvinax|r
    .scenario 1900,1
    .mob Portal Master Jorvinax
step
    .isInScenario 943
    .goto 424,44.67,26.6
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Crystal|r
    .scenario 1901,1
step
    #completewith next
    #label Dawning Light
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Fearsome Jang|r
    .turnin 12103 >>Turn in Before the Storm
    .target Fearsome Jang
    .accept 40236 >>Accept The Dawning Light
    .disablecheckbox
step
    #title |cFFFCDC00Leave House|r
    #completewith Dawning Light
    .goto 709,57.44,59.16,5 >>Leave the House
step
    #requires Dawning Light
    #completewith next
    #label Dawning Light2
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Fearsome Jang|r
    .turnin 12103 >>Turn in Before the Storm
    .target Fearsome Jang
    .accept 40236 >>Accept The Dawning Light
    .disablecheckbox
step
    #requires Dawning Light
    #completewith Dawning Light2
    #title |cFFFCDC00Follow the Arrow|r
    .goto 709,56.05,59.36,25,0
    .goto 709,54.73,58.48,25,0
    .goto 709,51.58,57.48,25,0
    .goto 709,51.35,54.33,40 >>|cRXP_WARN_You can mount again, but not skyride|r.
step
    #requires Dawning Light2
    .goto 709,51.35,54.33
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Fearsome Jang|r
    .turnin 12103 >>Turn in Before the Storm
    .target Fearsome Jang
    .accept 40236 >>Accept The Dawning Light
    .timer 42,RP
step
    .goto 709,51.41,48.41
    #title |cFFFCDC00Follow the Arrow|r
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 40236,1 --1/1 Accompany Fearsome Jang
    .target Iron-Body Ponshu
    .timer 73.5,RP
step
    .goto 709,51.41,48.41
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 40236,2 --1/1 Establish the Order of The Broken Temple
    .target Iron-Body Ponshu
step
    #label The Dawning Light
    .goto 709,51.41,48.41
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Iron-Body Ponshu|r
    .turnin 40236 >>Turn in The Dawning Light
    .target Iron-Body Ponshu
step
    .isQuestAvailable 40636
    .goto 709,51.41,48.38
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Iron-Body Ponshu|r
    .accept 40636 >>Accept Prepare To Strike
    .target Iron-Body Ponshu
step
    .isQuestAvailable 40636
    .isQuestAvailable account,91955
    +Select one of the following guides for now:
    *|cRXP_WARN_IMPORTANT: Select the one you already have in order to gain an additional 10% xp (one time only)|r
    *|cRXP_WARN_You’ll be able to do the other questlines later|r
    *|cFFFF0000You can't progress if you don't select one|r.
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Windwalker >> Windwalker(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Brewmaster >> Brewmaster(Tank) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Mistweaver >> Mistweaver(Healer) Questline
    -- .clicknext RestedXP Legion Remix\ad) Infinite Bazaar >>Skip to the Infinite Bazaar (You loose the 10% xp bonus)
]])

---Monk Order Hall Intro 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#name ac) Order Hall Monk Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#next ad) Infinite Bazaar

<< Monk

step
    #completewith Dalaran
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #optional
    .isQuestAvailable 40636
    +|cRXP_WARN_You have to do the previous chapter first|r
    .clicknext RestedXP Legion Remix\ab) Order Hall Monk Part 1 >>Order Hall Monk Part 1 
step
    #completewith next
    #label Matter of Planning
    .goto 709,49.99,58.69,30,0
    .goto 709,51.04,57.64,30,0
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Iron-Body Ponshu|r
    .accept 40793 >>Accept A Matter of Planning
    .target Iron-Body Ponshu
step
    #completewith Matter of Planning
    #hidewindow
    .goto 709,51.41,48.4,60 >>1
step
    #requires Matter of Planning
    .goto 709,51.42,48.40
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Iron-Body Ponshu|r
    .accept 40793 >>Accept A Matter of Planning
    .target Iron-Body Ponshu
step
    #completewith next
    #label Turn in A Matter of Planning2
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Hsu|r
    .turnin 40793 >>Turn in A Matter of Planning
    .accept 40795 >>Accept The Fight Begins
    .disablecheckbox
    .target Master Hsu
step
    #completewith Turn in A Matter of Planning2
    #hidewindow
    .goto 709,51.46,54.08,20,0
    .goto 709,52.77,59.79,50 >>1
step
    #requires Turn in A Matter of Planning2
    .goto 709,52.77,59.79
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Hsu|r
    .turnin 40793 >>Turn in A Matter of Planning
    .accept 40795 >>Accept The Fight Begins
    .target Master Hsu
step
    .goto 709,52.92,60.17
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Scouting Map|r
    .complete 40795,1 --1/1 Assault Point Chosen
    .acceptmap 39718
    .accept 39718 >>Accept The Tranquil Forest
step
    #label The Fight Begins
    .goto 709,52.77,59.79
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Master Hsu|r
    .turnin 40795 >>Turn in The Fight Begins
    .target Master Hsu
step << Alliance
    #label Dalaran
    .goto 709,52.4,57.17
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal|r
    -- .complete 39735,1 --1/1 Travel to Dalaran 
    .complete 39718,1 --1/1 Travel to Dalaran 
    .timer 8,RP
step << Horde
    #label Dalaran
    .goto 709,52.4,57.17
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal|r
    .complete 39718,1 --1/1 Travel to Dalaran 
    .timer 8,RP
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Initiate Da-Nel|r |cRXP_WARN_next to you|r
    .accept 42186 >>Accept Growing Power
    .target Initiate Da-Nel
]])

---Death Knight Order Hall Intro 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ab) Order Hall Death Knight Part 1
#displayname |cFF00FF004|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route

<< DeathKnight

step
    .isQuestTurnedIn account,91955
    .achievementComplete 61108,1
    +|cRXP_WARN_You’ve already got the 10% XP bonus from the artifact questline. By clicking the text below, you’ll skip the Order Hall intro and parts of Azsuna for faster leveling|r.
    *Manually skip this step if you prefer to play through that content.
    .clicknext RestedXP Legion Remix\ae) First Zone 2 >>CLICK HERE FOR THE GUIDE.
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kaberk|r.
    *|cRXP_WARN_Note:|r This should get pushed to your quest log automatically while in Dalaran. If not then relog.
    .accept 40714 >>Accept The Call To War
    .target Kaberk
step
    .goto 627,73.11,46.90
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Duke Lankral|r.
    .turnin 40714 >>Turn in The Call To War
    .accept 40715 >>Accept A Pact of Necessity
    .target Duke Lankral
step
    .isQuestAvailable account,91955
    +Select one of the following guides for now:
    *|cRXP_WARN_IMPORTANT: Select the one you already have in order to gain an additional 10% xp (one time only)|r
    *|cRXP_WARN_You’ll be able to do the other questlines later|r
    *|cFFFF0000You can't progress if you don't select one|r.
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Frost DK >> Frost(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Unholy >> Unholy(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Blood >> Blood(Tank) Questline

]])

---Death Knight Order Hall Intro 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ac) Order Hall Death Knight Part 2
#displayname |cFF00CCFF3|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#next ad) Infinite Bazaar

<< DeathKnight

step
    #optional
    .isQuestAvailable 40715
    +|cRXP_WARN_You have to do the previous chapter first|r
    .clicknext RestedXP Legion Remix\ab) Order Hall Death Knight Part 1 >>Order Hall Death Knight Part 1
step
    .goto 648,50.97,50.71
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Highlord Darion Mograine|r
    .accept 39832 >>Accept Plans and Preparations
    .target Highlord Darion Mograine
step
    .goto 648,49.69,51.32
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Siouxsie the Banshee|r
    .turnin 39832 >>Turn in Plans and Preparations
    .target Siouxsie the Banshee
    .accept 39799 >>Accept Our Next Move
step
    .goto 648,49.69,51.32
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Scouting Map|r.
    .complete 39799,1 --1/1 Initial strike point chosen
    .acceptmap 39718
step
    .goto 648,49.56,51.34
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Siouxsie the Banshee|r
    .turnin 39799 >>Turn in Our Next Move
    .timer 47,Roleplay
    .target Siouxsie the Banshee
step
    .goto 648,51.01,50.70
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Highlord Darion Mograine|r.
    .accept 58989 >>Accept Runeforging 101
    .target Highlord Darion Mograine
step
    .goto 648,36.25,38.53    
    .complete 58989,1 --1/1 Use the portal to the 2nd floor (Optional)
step
    .goto 647,44.08,66.33
    >>Use |T237523:0|t[Runeforging] at the |cRXP_PICK_Rune Forge|r and apply a rune to your weapon
    .complete 58989,2 --1/1 Weapon emblazoned
    .usespell 53428
step
    #completewith next
    #label RuneforgingFourHorsemenA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Highlord Darion Mograine|r.
    .accept 42449 >>Accept Return of the Four Horsemen
    .turnin 58989 >>Turn in Runeforging 101
    .target Highlord Darion Mograine
step
    #completewith RuneforgingFourHorsemenA
    .goto 647,33.79,36.01
    .zone 648 >>|cRXP_WARN_Walk on top of the teleporter|r
step
    #requires RuneforgingFourHorsemenA
    .goto 648,50.97,50.75
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Highlord Darion Mograine|r.
    .accept 42449 >>Accept Return of the Four Horsemen
    .turnin 58989 >>Turn in Runeforging 101
    .target Highlord Darion Mograine
step
    .goto 648,50.93,50.62
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Highlord Darion Mograine|r
    .accept 42449 >>Accept Return of the Four Horsemen
    .target Highlord Darion Mograine
step
    #completewith next
    #label ReturnOfTheFourHorsemenA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thassarian|r
    .turnin 42449 >>Turn in Return of the Four Horsemen
    .accept 42484 >>Accept The Firstborn Rises
    .target Thassarian
step
    #completewith ReturnOfTheFourHorsemenA
    .goto 648,51.01,49.71
    .zone 1 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Infinitely Mysterious Portal|r
step
    #requires ReturnOfTheFourHorsemenA
    .goto 1,47.32,17.68
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thassarian|r
    .turnin 42449 >>Turn in Return of the Four Horsemen
    .accept 42484 >>Accept The Firstborn Rises
    .target Thassarian
step
    .goto 1,47.32,17.87
    >>Use the |T367599:0|t[|cRXP_WARN_ExtraActionButton|r]
    .complete 42484,1 --1/1 Nazgrim raised
step
    #completewith next
    #label TheFirstbornRisesA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Highlord Darion Mograine|r
    .turnin 42484 >>Turn in The Firstborn Rises
    .accept 43264 >>Accept Rise, Champions
    .target Highlord Darion Mograine
step
    #completewith TheFirstbornRisesA
    #title Use your |T135766:0|t[Deathgate]
    .goto 1,47.32,17.87
    .zone 648 >>Use |T135766:0|t[Deathgate] and click on it
    .macro DeathgateDK,135766 >>/cast spell:50977
step
    #requires TheFirstbornRisesA
    .goto 648,50.90,50.73
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Highlord Darion Mograine|r
    .turnin 42484 >>Turn in The Firstborn Rises
    .target Highlord Darion Mograine
    .accept 43264 >>Accept Rise, Champions
step
    .goto 648,56.02,30.47
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thassarian|r
    .accept 39816 >>Accept Champion: Thassarian
    .turnin 39816 >>Turn in Champion: Thassarian
    .complete 43264,1 --1/1 Enlist Thassarian
    .target Thassarian
step
    .goto 648,39.45,68.34
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nazgrim|r
    .accept 39818 >>Accept Champion: Nazgrim
    .turnin 39818 >>Turn in Champion: Nazgrim
    .complete 43264,2 --1/1 Enlist Nazgrim
    .target Nazgrim
step
    .goto 648,49.70,51.32
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Siouxsie the Banshee|r
    .turnin 43264 >>Turn in Rise, Champions
    .target Siouxsie the Banshee
step
    .zoneskip 648,1
    .goto 648,24.76,33.70
    .zone 627 >>Click on the |cRXP_PICK_Portal to Dalaran|r.
]])

---Demon Hunter Order Hall Intro 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ab) Order Hall Demon Hunter Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route

<< DemonHunter

step
    .isQuestTurnedIn account,91955
    .achievementComplete 61108,1
    +|cRXP_WARN_You’ve already got the 10% XP bonus from the artifact questline. By clicking the text below, you’ll skip the Order Hall intro and parts of Azsuna for faster leveling|r.
    *Manually skip this step if you prefer to play through that content.
    .clicknext RestedXP Legion Remix\ae) First Zone 2 >>CLICK HERE FOR THE GUIDE.
step
    #completewith Call of the Illidari
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
-- step
--     #optional
--     .convertquest 39261,39047
--     .convertquest 39261,39047
--     .convertquest 40814,40816
--     .convertquest 41221,41033
--     .convertquest 41037,41060
--     .convertquest 41062,41070
--     .convertquest 41067,41096
--     .convertquest 41069,41099
--     .convertquest 44383,44379
step
    #label Future of The Fel Hammer
    .goto 627,72.07,41.63
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Moratari|r
    .accept 90995 >>Accept The Future of The Fel Hammer
    .target Moratari
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Moratari|r
    .complete 90995,1 --1/1 Speak with Moratari to choose a champion
    .skipgossipid 134009
    .choose 1274666
    .target Moratari
step
    .goto 627,72.07,41.63
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Moratari|r
    .turnin 90995 >>Turn in The Future of The Fel Hammer
    .target Moratari
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kor'vas Bloodthorn|r |cRXP_WARN_next to you|r
    .accept 39261 >>Accept Call of the Illidari
    .target Kor'vas Bloodthorn
step
    #label Call of the Illidari
    .goto 627,74.97,48.97
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r
    .turnin 39261 >>Turn in Call of the Illidari
    .target Kayn Sunfury
step
    .isQuestAvailable 40814
    .goto 627,74.97,48.97
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r
    .target Kayn Sunfury
    .accept 40814 >>Accept The Power to Survive
step
    .isQuestAvailable 40814
    .isQuestAvailable account,91955
    +Select one of the following guides for now:
    *|cRXP_WARN_IMPORTANT: Select the one you already have in order to gain an additional 10% xp (one time only)|r
    *|cRXP_WARN_You’ll be able to do the other questlines later|r
    *|cFFFF0000You can't progress if you don't select one|r.
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Havoc >> Havoc(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Vengeance >> Vengeance(DPS) Questline
    -- .clicknext RestedXP Legion Remix\ad) Infinite Bazaar >>Skip to the Infinite Bazaar (You loose the 10% xp bonus)
]])

---Demon Hunter Order Hall Intro 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ac) Order Hall Demon Hunter Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#next ae) First Zone

<< DemonHunter

step
    #completewith Asha Ravensong
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #optional
    .isQuestAvailable 40814
    +|cRXP_WARN_You have to do the previous chapter first|r
    .clicknext RestedXP Legion Remix\ab) Order Hall Demon Hunter Part 1 >>Order Hall Demon Hunter Part 1
step
    #label Eternal Vigil
    .goto 627,73.86,46.11
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kor'vas Bloodthorn|r
    .target Kor'vas Bloodthorn
    .accept 42869 >>Accept Eternal Vigil
step
    .goto 627,95.12,65.97
    #title |cFFFCDC00Skyride; not glide|r
    .complete 42869,1 --Glide to Illidari Redoubt
step
    .goto 627,95.12,65.97
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jace Darkweaver|r
    .turnin 42869 >>Turn in Eternal Vigil
    .target Jace Darkweaver
    .accept 42872 >>Accept Securing the Way
step
    .goto 627,95.12,65.97
    >>Use the |cRXP_WARN_ExtraActionButton|r
    .complete 42872,1 --1/1 Have the prisoners' souls removed
    .usespell 217377
step
    .goto 627,97.66,68.89
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Gate|r.
    *|cRXP_WARN_You might have to click twice|r.
    .complete 42872,2 --1/1 Rip open a gateway to the Fel Hammer
step
    .goto 627,95.15,65.96
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jace Darkweaver|r
    .turnin 42872 >>Turn in Securing the Way
    .target Jace Darkweaver
step
    .goto 627,95.24,66.16
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Matron Mother Malevolence|r
    .accept 41221,41033 >>Accept Return to Mardum
    .target Matron Mother Malevolence
step
    .goto 627,97.66,68.89
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Gate|r.
    .complete 41221,1 --Board the Fel Hammer
step
    .goto 720,57.64,67.45
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r
    .turnin 41221 >>Turn in Return to Mardum
    .target Kayn Sunfury
    .accept 41037,41060 >>Accept Unbridled Power
step
    #completewith next
    #label Fel Hammer
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 41037,1 --1/1 Activate the Fel Hammer
step
    #completewith Fel Hammer
    .goto 720,58.84,65.90
    .cast 203269 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Console|r
    .timer 36.5,RP
step
    #requires Fel Hammer
    .goto 720,58.64,57.83
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 41037,1 --1/1 Activate the Fel Hammer
step
    .goto 720,58.65,57.96
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r
    .turnin 41037 >>Turn in Unbridled Power
    .target Kayn Sunfury
    .accept 41062,41070 >>Accept Spoils of Victory
step
    .goto 720,55.88,54.12
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Battlelord Gaardoun|r
    .complete 41062,1 --1/1 Speak to Battlelord Gaardoun
    .timer 29,RP
    .skipgossipid 45282
    .target Battlelord Gaardoun
step
    .goto 720,49.59,41.73,20,0
    .goto 720,46.7,53.07,20,0
    .goto 721,59.76,46.94
    #title |cFFFCDC00Follow the Arrow|r
    .complete 41062,2 --1/1 Follow Battlelord Gaardoun
step
    .goto 721,59.76,45.60
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Battlelord Gaardoun|r
    .turnin 41062 >>Turn in Spoils of Victory
    .target Battlelord Gaardoun
step
    .goto 721,59.33,51.37
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Allari the Souleater|r
    .accept 41066 >>Accept The Hunter's Gaze
    .target Allari the Souleater
step
    #completewith next
    #label Burning Legion
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 41066,1 --1/1 Gaze upon the Burning Legion
step
    #completewith Burning Legion
    .goto 721,58.93,52.97
    .gossipoption 45456 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Crucible|r
    .timer 40,RP
step
    #requires Burning Legion
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 41066,1 --1/1 Gaze upon the Burning Legion    
step
    .goto 721,59.34,51.31
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Allari the Souleater|r
    .turnin 41066 >>Turn in The Hunter's Gaze
    .target Allari the Souleater
    .accept 41067,41096 >>Accept Time is of the Essence
step
    #completewith next
    #label Time is of the Essence
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r
    .turnin 41067 >>Turn in Time is of the Essence
    .target Kayn Sunfury
    .accept 41069 >>Accept Direct Our Wrath
    .disablecheckbox
step
    #hidewindow
    #completewith Time is of the Essence
    .goto 720,70.06,55.41,15,0
    .goto 720,67.12,65.49,15,0
    .goto 720,58.59,57.91,5 >>1
step
    #requires Time is of the Essence
    .goto 720,58.59,57.91
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r
    .turnin 41067 >>Turn in Time is of the Essence
    .target Kayn Sunfury
    .accept 41069 >>Accept Direct Our Wrath
step
    .goto 720,58.56,53.23
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Scouting Map|r
    .complete 41069,1 --1/1 Assault Point Chosen
    .acceptmap 39718
    .accept 39718 >>Accept The Tranquil Forest
step
    .goto 720,58.57,57.82
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r
    .turnin 41069 >>Turn in Direct Our Wrath
    .target Kayn Sunfury
step
    .goto 720,56.07,54.11
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Battlelord Gaardoun|r
    .accept 42671 >>Accept Rise, Champions
    .target Battlelord Gaardoun
step
    .goto 720,58.62,57.92
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r
    .accept 42695 >>Accept Champion: Kayn Sunfury
    .turnin 42695 >>Turn in Champion: Kayn Sunfury
    .complete 42671,1 --Kayn Sunfury recruited
    .target Kayn Sunfury
step
    .goto 720,56.18,38.94
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Asha Ravensong|r
    .accept 42697 >>Accept Champion: Asha Ravensong
    .turnin 42697 >>Turn in Champion: Asha Ravensong
    .target Asha Ravensong
    .complete 42671,2 --Asha Ravensong recruited
step
    .goto 720,59.26,57.61
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kor'vas Bloodthorn|r
    .turnin 42671 >>Turn in Rise, Champions
    .target Kor'vas Bloodthorn
step
    .goto 720,59.26,57.61
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kor'vas Bloodthorn|r
    .accept 42677 >>Accept Things Gaardroun Needs
    .turnin 42677 >>Turn in Things Gaardroun Needs
    .target Kor'vas Bloodthorn
step
    .goto 720,59.26,57.61
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kor'vas Bloodthorn|r
    .target Kor'vas Bloodthorn
    .accept 42679 >>Accept Broken Warriors
    .turnin 42679 >>Turn in Broken Warriors
step
    .goto 720,59.26,57.61
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kor'vas Bloodthorn|r
    .target Kor'vas Bloodthorn
    .accept 42681 >>Accept Loramus, Is That You?
    .turnin 42681 >>Turn in Loramus, Is That You?
    .accept 42683 >>Accept Demonic Improvements
step
    #label Asha Ravensong
    .isQuestAvailable 44383
    .isQuestNotComplete 42681
    .goto 720,50.59,66.28,10,0
    .goto 720,46.79,55.5,10,0
    .goto 721,51.86,55.1,5,0
    .goto 721,55.22,62.07
    .gossipoption 45707 >>Talk to |cRXP_FRIENDLY_Loramus Thalipedes|r
    .timer 83,RP
    .target Loramus Thalipedes
step
    .zoneskip 720,1
    .isQuestTurnedIn 40814
    .isQuestAvailable 44383
    .isQuestAvailable 40247
    .goto 721,51.78,55.46,10,0
    .goto 720,46.98,56.68,10,0
    .goto 720,50.57,66.1,10,0
    .goto 720,58.62,57.88
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r
    .accept 44383 >>Accept In Pursuit of Power
    .target Kayn Sunfury
step
    .zoneskip 720,1
    .isQuestTurnedIn 40814
    .isQuestAvailable 44383
    .isOnQuest 44383,
    .goto 720,58.62,57.88
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r
    .complete 44383,1 --1/1 Choose a second artifact to pursue
    .choose 1390101
    .skipgossipid 45738
step
    .zoneskip 720,1
    .isQuestTurnedIn 40814
    .isQuestAvailable 44383
    .isQuestComplete 44383
    .goto 720,58.62,57.88
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r
    .turnin 44383 >>Turn in Pursuit of Power
    .target Kayn Sunfury
step
    .zoneskip 720,1
    .isQuestTurnedIn 40814
    .isQuestAvailable 44383
    .isQuestAvailable 40819
    .goto 721,51.78,55.46,10,0
    .goto 720,46.98,56.68,10,0
    .goto 720,50.57,66.1,10,0
    .goto 720,58.62,57.88
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r
    .accept 44383 >>Accept In Pursuit of Power
    .target Kayn Sunfury
step
    .zoneskip 720,1
    .isQuestTurnedIn 40814
    .isQuestAvailable 44383
    .isOnQuest 44383
    .goto 720,58.62,57.88
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r
    .complete 44383,1 --1/1 Choose a second artifact to pursue
    .choose 1390100
    .skipgossipid 45738
step
    .zoneskip 720,1
    .isQuestTurnedIn 40814
    .isQuestAvailable 44383
    .isQuestComplete 44383
    .goto 720,58.62,57.88
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r
    .turnin 44383 >>Turn in Pursuit of Power
    .target Kayn Sunfury
step
    .isQuestAvailable 40819
    .goto 720,58.6,57.83
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r
    .target Kayn Sunfury
    .accept 40819 >>Accept Making Arrangements
step
    .isQuestAvailable 40247
    .goto 720,58.6,57.83
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r
    .accept 40247 >>Accept Asking a Favor
    .target Kayn Sunfury
step
    #label Champion: Asha Ravensong
    .zoneskip 720,1
    .goto 720,59.19,91.77
    .zone 627 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal|r
step
    .isOnQuest 39718
    .goto 627,72.09,40.72
    .countdown 2 >>Move to the Portal
step
    .isOnQuest 39718
    .goto 627,72.09,40.72
    .zone 619 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal|r
step
    #include ad) Infinite Bazaar
]])

---Druid Order Hall Intro 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ab) Order Hall Druid Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route

<< Druid

step
    .isQuestTurnedIn account,91955
    .achievementComplete 61108,1
    +|cRXP_WARN_You’ve already got the 10% XP bonus from the artifact questline. By clicking the text below, you’ll skip the Order Hall intro and parts of Azsuna for faster leveling|r.
    *Manually skip this step if you prefer to play through that content.
    .clicknext RestedXP Legion Remix\ae) First Zone 2 >>CLICK HERE FOR THE GUIDE.
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archdruid Hamuul Runetotem|r |cRXP_WARN_next to you|r.
    *- |cRXP_WARN_Run around in Dalaran until he spawns|r
    .accept 40643 >>Accept A Summons From Moonglade
    .target Archdruid Hamuul Runetotem
step
    #completewith next
    #label SummonsFromMoongladeA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archdruid Hamuul Runetotem|r.
    .turnin 40643 >>Turn in A Summons From Moonglade
    .accept 41106 >>Accept Call of the Wilds
    .target Archdruid Hamuul Runetotem
step
    .zoneskip 80
    #completewith SummonsFromMoongladeA
    .cast 311897 >>Use the |T413582:0|t[Mossy Hearthstone]
    .use 173716
step
    #requires SummonsFromMoongladeA
    .goto 80,56.28,31.84
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archdruid Hamuul Runetotem|r.
    .turnin 40643 >>Turn in A Summons From Moonglade
    .accept 41106 >>Accept Call of the Wilds
    .target Archdruid Hamuul Runetotem
step
    .goto 80,43.59,53.16
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Zen'tabra|r
    .complete 41106,1 --1/1 Speak to Zen'tabra
    .target Zen'tabra
    .skipgossipid 45379
step
    .goto 80,55.26,71.03
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Pillow|r
    .complete 41106,2 --1/1 Find Naralex's Camp
step
    .goto 80,40.15,70.53
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|t|cRXP_WARN_Follow the arrow|r. Talk to |cRXP_FRIENDLY_Naralex|r.
    .complete 41106,3 --1/1 Locate and Speak to Naralex
    .target Naralex
    .skipgossipid 45378
step
    .goto 80,56.26,31.83
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archdruid Hamuul Runetotem|r
    .turnin 41106 >>Turn in Call of the Wilds
    .target Archdruid Hamuul Runetotem
    .accept 40644 >>Accept The Dreamway
step
    .goto 80,65.25,60.26
    >>|cRXP_WARN_Follow the arrow|r
    .complete 40644,1 --1/1 Accompany Archdruid Runetotem
    .timer 23,Malfurion Roleplay
step
    .goto 80,66.91,60.15
    >>|cRXP_WARN_Wait for the roleplay|r.
    .complete 40644,2 --1/1 Approach and listen to Malfurion
step
    .goto 80,66.93,60.15
    >>Use the |T136074:0|t[|cRXP_WARN_ExtraActionButton|r]
    .complete 40644,3 --1/1 Complete the Ritual
    .timer 8,Ritual Roleplay
step
    .goto 80,66.73,60.54
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Malfurion Stormrage|r
    .turnin 40644 >>Turn in The Dreamway
    .target Malfurion Stormrage
    .accept 40645 >>Accept To The Dreamgrove
step
    .goto 80,68.05,60.27
    >>|cRXP_WARN_Follow the arrow through the portal|r
    .complete 40645,1 --1/1 Enter the Emerald Dreamway
step
    .goto 715,38.47,45.18
    >>Ignore Remulos and follow the arrow to the next objective
    *|cRXP_WARN_DON'T KILL the |cRXP_ENEMY_Nightmare Blight|r yet|r.
    .complete 40645,2 --1/1 Travel with Remulos
step
    .goto 715,68.76,29.92
    >>Kill the |cRXP_ENEMY_Nightmare Blight|r
    .complete 40645,3 --1/1 Cleanse the Corruption
    .mob Nightmare Blight
step
    .goto 715,47.20,29.86,15,0
    .goto 715,45.60,23.46
    >>|cRXP_WARN_Follow the arrow through the portal|r
    .complete 40645,4 --1/1 Travel to the Dreamgrove
step
    .goto 747,44.50,51.06
    |cRXP_WARN_Follow the arrow|r.
    .complete 40645,5 --1/1 Meet the Archdruid
step
    .goto 747,44.50,51.06
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rensar Greathoof|r
    .turnin 40645 >>Turn in To The Dreamgrove
    .accept 40646 >>Accept Weapons of Legend
    .target Rensar Greathoof
step
    .isQuestAvailable 40646
    .isQuestAvailable account,91955
    +Select one of the following guides for now:
    *|cRXP_WARN_IMPORTANT: Select the one you already have in order to gain an additional 10% xp (one time only)|r
    *|cRXP_WARN_You’ll be able to do the other questlines later|r
    *|cFFFF0000You can't progress if you don't select one|r.
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Balance Druid >> Balance(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Feral Druid >> Feral(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Guardian Druid >> Guardian(Tank) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Restoration Druid >> Restoration(Healer) Questline
    -- .clicknext RestedXP Legion Remix\ad) Infinite Bazaar >>Skip to the Infinite Bazaar (You loose the 10% xp bonus)
]])

---Druid Order Hall Intro 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ac) Order Hall Druid Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#next ad) Infinite Bazaar

<< Druid

step
    #optional
    .isQuestAvailable 40646
    +|cRXP_WARN_You have to do the previous chapter first|r
    .clicknext RestedXP Legion Remix\ab) Order Hall Druid Part 1 >>Order Hall Druid Part 1
step
    .goto 747,44.49,51.11
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rensar Greathoof|r
    .accept 41255 >>Accept Sowing The Seed
    .target Rensar Greathoof
step
    .goto 747,30.89,53.66
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Seed of Ages|r
    .complete 41255,1 --1/1 Plant the Seed of Ages
step
    .goto 747,30.94,54.25
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Rensar Greathoof|r
    .turnin 41255 >>Turn in Sowing The Seed
    .accept 41332 >>Accept Ascending The Circle
    .timer 35,Greathoof Roleplay
    .target Rensar Greathoof
step
    #title |cFFFCDC00Check Note|r
    .goto 747,45.98,51.10
    *|cRXP_WARN_If you can't see |cRXP_FRIENDLY_Archdruid Greathoof|r then you have to reaccept the quest|r.
    .complete 41332,1 --1/1 Walk with Archdruid Greathoof
step
    .goto 747,46.00,51.07
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Malfurion|r
    .complete 41332,2 --1/1 Speak with Malfurion
    .target Malfurion
    .skipgossipid 45222
    .timer 28,Malfurion Roleplay
step
    .goto 747,46.00,51.07
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Malfurion Stormrage|r
    .turnin 41332 >>Turn in Ascending The Circle
    .accept 40652 >>Accept Word on the Winds
    .target Malfurion Stormrage
step
    .goto 747,52.56,51.43
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Skylord Omnuron|r
    .turnin 40652 >>Turn in Word on the Winds
    .accept 40653 >>Accept Making Trails
    .target Skylord Omnuron
step
    .goto 747,52.63,51.21
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_PICK_Scouting Map|r
    .acceptmap 39718
    .complete 40653,1 --1/1 Initial strike point chosen
step
    .goto 747,52.53,51.39
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Skylord Omnuron|r
    .turnin 40653 >>Turn in Making Trails
    .target Skylord Omnuron
step
    .zoneskip 747,1
    .goto 747,56.51,43.15
    .zone 627 >>Click on the |cRXP_PICK_Portal to Dalaran|r.
]])

---Hunter Order Hall Intro 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ab) Order Hall Hunter Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route

<< Hunter

step
    .isQuestTurnedIn account,91955
    .achievementComplete 61108,1
    +|cRXP_WARN_You’ve already got the 10% XP bonus from the artifact questline. By clicking the text below, you’ll skip the Order Hall intro and parts of Azsuna for faster leveling|r.
    *Manually skip this step if you prefer to play through that content.
    .clicknext RestedXP Legion Remix\ae) First Zone 2 >>CLICK HERE FOR THE GUIDE.
step
    .goto 627,58.61,45.85
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Snowfeather|r.
    *|cRXP_WARN_NOTE:|r Run around in Dalaran until it spawns next to you.
    .accept 40384 >>Accept Needs of the Hunters
    .target Snowfeather
step
    #completewith next
    #label NeedsOfTheHuntersA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Emmarel Shadewarden|r.
    .turnin 40384 >>Turn in Needs of the Hunters
    .accept 41415 >>Accept The Hunter's Call
    .target Emmarel Shadewarden
step
    #title |cFFFCDC00Enter House|r
    #completewith NeedsOfTheHuntersA
    .goto 627,58.99,51.87,6 >>|cRXP_WARN_Follow the arrow into the house.|r
step
    #requires NeedsOfTheHuntersA
    .goto 627,60.03,53.47
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Emmarel Shadewarden|r.
    .turnin 40384 >>Turn in Needs of the Hunters
    .accept 41415 >>Accept The Hunter's Call
    .target Emmarel Shadewarden
step
    #completewith next
    #label TheHuntersCallA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grif Wildheart|r.
    .complete 41415,1 --1/1 Speak to Grif Wildheart
    .target Grif Wildheart
    .skipgossipid 45259
step
    #title |cFFFCDC00Enter House|r
    #completewith TheHuntersCallA
    .goto 627,58.01,40.06,6 >>|cRXP_WARN_Follow the arrow into the house.|r
step
    #requires TheHuntersCallA
    .goto 627,59.19,37.95
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Grif Wildheart|r.
    .complete 41415,1 --1/1 Speak to Grif Wildheart
    .target Grif Wildheart
    .skipgossipid 45259
step
    #completewith next
    #label TheHuntersCallB    
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Apata Highmountain|r.
    .complete 41415,3 --1/1 Speak to Apata Highmountain
    .target Apata Highmountain
    .skipgossipid 45079
step
    #title |cFFFCDC00Enter House|r
    #completewith TheHuntersCallB
    .goto 627,53.38,61.34,6 >>|cRXP_WARN_Follow the arrow into the house.|r
step
    #requires TheHuntersCallB
    .goto 627,55.65,63.51
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Apata Highmountain|r.
    .complete 41415,3 --1/1 Speak to Apata Highmountain
    .target Apata Highmountain
    .skipgossipid 45079
step
    .goto 627,42.32,56.55
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Courier Larkspur|r.
    .complete 41415,2 --1/1 Speak to Courier Larkspur
    .target Courier Larkspur
    .skipgossipid 45240
step
    #completewith next
    #label TheHuntersCallC
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Emmarel Shadewarden|r.
    .turnin 41415 >>Turn in The Hunter's Call
    .accept 40618 >>Accept Weapons of Legend
    .target Emmarel Shadewarden
step
    #title |cFFFCDC00Enter House|r
    #completewith TheHuntersCallC
    .goto 627,58.99,51.87,6 >>|cRXP_WARN_Follow the arrow into the house.|r
step
    #requires TheHuntersCallC
    .goto 627,60.03,53.41
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Emmarel Shadewarden|r.
    .turnin 41415 >>Turn in The Hunter's Call
    .accept 40618 >>Accept Weapons of Legend
    .target Emmarel Shadewarden
step
    .isQuestAvailable 40618
    .isQuestAvailable account,91955
    .goto 627,60.03,53.41
    +Select one of the following guides for now:
    *|cRXP_WARN_IMPORTANT: Select the one you already have in order to gain an additional 10% xp (one time only)|r
    *|cRXP_WARN_You’ll be able to do the other questlines later|r
    *|cFFFF0000You can't progress if you don't select one|r.
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Beast Mastery >> Beast Mastery(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Marksmanship >> Marksmanship(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Survival >> Survival(DPS) Questline
    -- .clicknext RestedXP Legion Remix\ad) Infinite Bazaar >>Skip to the Infinite Bazaar (You loose the 10% xp bonus)
]])

---Hunter Order Hall Intro 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ac) Order Hall Hunter Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#next ad) Infinite Bazaar

<< Hunter

step
    #optional
    .isQuestAvailable 40618
    +|cRXP_WARN_You have to do the previous chapter first|r
    .clicknext RestedXP Legion Remix\ab) Order Hall Hunter Part 1 >>Hunter Order Hall Intro 1
step
    .goto 627,60.05,53.47
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Emmarel Shadewarden|r.
    .accept 40953 >>Accept On Eagle's Wings
    .target Emmarel Shadewarden
step
    #completewith next
    #label OnEaglesWingsA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_the flight master in Krasus' Landing|r.
    .complete 40953,1 --1/1 Speak to the flight master in Krasus' Landing
    .target the flight master in Krasus' Landing
    .skipgossipid 44178
step
    #title |cFFFCDC00Leave House|r
    #completewith OnEaglesWingsA
    .goto 627,58.43,51.10,6 >>|cRXP_WARN_Follow the arrow out of the house.|r
step
    #requires OnEaglesWingsA
    .goto 627,69.84,51.14
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Flight Master|r.
    .complete 40953,1 --1/1 Speak to the flight master in Krasus' Landing
    .timer 157,Flight Duration
    .skipgossipid 44178
step
    .goto 739,36.29,27.92
    >>|cRXP_WARN_Wait for the flight.|r
    .complete 40953,2 --1/1 Meet Emmarel Shadewarden at the Trueshot Lodge
step
    .goto 739,36.69,29.16
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Emmarel Shadewarden|r.
    .turnin 40953 >>Turn in On Eagle's Wings
    .target Emmarel Shadewarden
step
    .goto 739,36.85,29.02
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Emmarel Shadewarden|r.
    .accept 40954 >>Accept The Unseen Path
    .timer 73,Unseen Path Roleplay
    .target Emmarel Shadewarden
step
    .goto 739,43.49,24.59
    >>|cRXP_WARN_Wait for the roleplay.|r
    .complete 40954,1 --1/1 Hear the tale of the Unseen Path
step
    .goto 739,43.49,24.59
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Emmarel Shadewarden|r.
    .turnin 40954 >>Turn in The Unseen Path
    .accept 40955 >>Accept Oath of Service
    .target Emmarel Shadewarden
step
    .goto 739,44.20,27.03
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_PICK_Visage of Ohn'ahra|r.
    .complete 40955,1 --1/1 Take the oath
step
    .goto 739,43.44,24.61
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Emmarel Shadewarden|r.
    .turnin 40955 >>Turn in Oath of Service
    .accept 40958 >>Accept Tactical Matters
    .target Emmarel Shadewarden
step
    .goto 739,48.70,41.96,15,0
    .goto 739,45.87,47.50,15,0
    .goto 739,42.77,46.96
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tactician Tinderfell|r.
    .turnin 40958 >>Turn in Tactical Matters
    .accept 40959 >>Accept The Campaign Begins
    .target Tactician Tinderfell
step
    .goto 739,42.58,46.71
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Scouting Map|r.
    .complete 40959,1 --1/1 Initial strike point chosen
    .acceptmap 39718
step
    .goto 739,42.84,46.93
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tactician Tinderfell|r.
    .turnin 40959 >>Turn in The Campaign Begins
    .target Tactician Tinderfell
step
    .zoneskip 739,1
    .goto 739,48.63,43.48
    .zone 627 >>Click on the |cRXP_PICK_Portal to Dalaran|r.
]])

---Mage Order Hall Intro 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ab) Order Hall Mage Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route

<< Mage

step
    .isQuestTurnedIn account,91955
    .achievementComplete 61108,1
    +|cRXP_WARN_You’ve already got the 10% XP bonus from the artifact questline. By clicking the text below, you’ll skip the Order Hall intro and parts of Azsuna for faster leveling|r.
    *Manually skip this step if you prefer to play through that content.
    .clicknext RestedXP Legion Remix\ae) First Zone 2 >>CLICK HERE FOR THE GUIDE.
step
    #completewith Dreadlord's Prize
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #label OrderHallMage1
    .goto 627,56.99,46.76
    >>Enter Legion Dalaran
    .accept 41035 >>Accept Felstorm's Plea
step
    #completewith next
    #label Felstorm's Plea
    .goto 627,56.99,46.76,10,0
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Meryl Felstorm|r
    .turnin 41035 >>Turn in Felstorm's Plea
    .target Meryl Felstorm
    .accept 41036 >>Accept The Dreadlord's Prize
    .disablecheckbox
step
    #title |cFFFCDC00Enter House|r
    #completewith Felstorm's Plea
    .goto 627,53.71,47.36,25 >>Enter the House
step
    #requires Felstorm's Plea
    .goto 627,53.71,47.36
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Meryl Felstorm|r
    .turnin 41035 >>Turn in Felstorm's Plea
    .target Meryl Felstorm
    .accept 41036 >>Accept The Dreadlord's Prize
step
    .isOnQuest 41036
    .goto 627,57.2,47,10,0
    .goto 627,67.31,69.6
    .zone 723 >>Enter the Violet Hold
step
    .goto 723,50.88,63.63
    .isInScenario 1034
    >>Kill |cRXP_ENEMY_Kathra'natir|r and wait for the roleplay.
    .scenario 2175,1 --Battle with Kathra'nathir
    .mob Kathra'natir
step
    .isInScenario 1034
    .goto 723,38.79,52.92
    >>Use |T135739:0|t[Shimmer] or |T135736:0|t[Blink] through the Barrier
    .scenario 2176,1 --Void Barrier passed
    .usespell 1953
step
    .isInScenario 1034
    #loop
    .goto 723,38.79,52.92,30,0
    .goto 723,43.09,30.88,40,0
    .goto 723,52.48,32.31,40,0
    .goto 723,63.66,47.87,40,0
    >>Kill |cRXP_ENEMY_Siphoning Rift|r
    .scenario 2176,2 --Siphoning Rift slain
    .mob Siphoning Rift
step
    .goto 723,51.1,48.2
    .isInScenario 1034
    >>Click on the |cRXP_PICK_Forge|r
    .scenario 2177,1 --Activate the Forge of the Guardian
    .timer 10,RP
step
    .isInScenario 1034
    .goto 723,50.8,63.79
    >>Kill |cRXP_ENEMY_Kathra'natir|r
    .complete 41036,1 --1/1 Kathra'natir slain
    .timer 53,RP
step
    .isInScenario 1034
    .goto 723,50.96,48.12
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .scenario 2178,1 --Kathra'natir defeated
    .mob Kathra'natir
step
    .goto 723,50.96,48.12
    .isInScenario 1034
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .scenario 2181,1 --Listen to Meryl
step
    .isInScenario 1034
    .goto 723,50.96,48.12
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Forge|r
    .complete 41036,2 --1/1 Recover the Forge of the Guardian
    .timer 41,RP
step
    .isInScenario 1034
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 41036,3 --1/1 Listen to Meryl
step
    #label Dreadlord's Prize
    .goto 735,59.15,43.01
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Meryl Felstorm|r
    .turnin 41036 >>Turn in The Dreadlord's Prize
    .target Meryl Felstorm
step
    .isQuestAvailable 41085
    .goto 735,59.15,43.01
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Meryl Felstorm|r
    .target Meryl Felstorm
    .accept 41085 >>Accept A Mage's Weapon
step
    .isQuestAvailable 41085
    +Select one of the following guides for now:
    *|cRXP_WARN_IMPORTANT: Select the one you already have in order to gain an additional 10% xp (one time only)|r
    *|cRXP_WARN_You’ll be able to do the other questlines later|r
    *|cFFFF0000You can't progress if you don't select one|r.
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Fire >> Fire(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Arcane >> Arcane(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Frost Mage >> Frost(DPS) Questline
]])

---Mage Order Hall Intro 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ac) Order Hall Mage Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#next ad) Infinite Bazaar

<< Mage

step
    #completewith Champion: Archmage Modera
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #optional
    .isQuestAvailable 41085
    +|cRXP_WARN_You have to do the previous chapter first|r
    .clicknext RestedXP Legion Remix\ab) Order Hall Mage Part 1 >>Mage Order Hall Intro 1
step
    #label 
    >>Use |T1536440:0|t[Teleport: Hall of the Guardian].
    .accept 41114 >>Accept The Champion's Return
    .usespell 193759
step
    >>Use |T1536440:0|t[Teleport: Hall of the Guardian].
    .complete 41114,1 --1/1 Teleport to the Hall of the Guardian
    .usespell 193759
step
    #completewith next
    #label Champion's Return
    .goto 734,57.58,85.44,15,0
    .goto 734,53.53,68.82,15,0
    .goto 735,57.41,70.85,15,0
    .goto 735,57.91,51.72,15,0
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Meryl Felstorm|r
    .turnin 41114 >>Turn in The Champion's Return
    .target Meryl Felstorm
    .accept 41112 >>Accept The Great Akazamzarak
    .disablecheckbox
step
    #completewith Champion's Return
    #hidewindow
    .goto 735,56.58,33.79,40 >>1
step
    #requires Champion's Return
    .goto 735,56.58,33.79
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Meryl Felstorm|r
    .turnin 41114 >>Turn in The Champion's Return
    .target Meryl Felstorm
    .accept 41112 >>Accept The Great Akazamzarak
step
    #completewith next
    #label Akazamzarak bribed
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Bucket|r
    .complete 41112,2 --1/1 Akazamzarak bribed
step
    #completewith Akazamzarak bribed
    .goto 734,57.29,90.56 
    >>Use |T1535374:0|t[Teleport: Dalaran - Broken Isles] or click on the |cRXP_PICK_Portal|r.
    .complete 41112,1 --1/1 Portal to Dalaran Taken (Optional)
    .usespell 224869
step
    #requires Akazamzarak bribed
    .goto 627,48.34,63.52
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Bucket|r
    .complete 41112,2 --1/1 Akazamzarak bribed
step
    .goto 627,48.53,63.44
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_The Great Akazamzarak|r
    .turnin 41112 >>Turn in The Great Akazamzarak
    .target The Great Akazamzarak
    .accept 41113 >>Accept The Only Way to Travel
    .timer 8,RP
step
    #completewith next
    #label Only Way to Travel
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Meryl Felstorm|r
    .turnin 41113 >>Turn in The Only Way to Travel
    .target Meryl Felstorm
step
    #completewith Only Way to Travel
    .goto 627,48.73,63.37
    .zone 735 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal|r
    -- .cast 193759>>Use |T1536440:0|t[Teleport: Hall of the Guardian].
    -- .usespell 193759
step
    #requires Only Way to Travel
    -- .goto 734,57.58,85.44,15,0
    -- .goto 734,53.53,68.82,15,0
    -- .goto 735,57.41,70.85,15,0
    .goto 735,56.56,33.79
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Meryl Felstorm|r
    .turnin 41113 >>Turn in The Only Way to Travel
    .timer 31,RP
    .target Meryl Felstorm
step
    .goto 735,60.52,34.58
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Meryl Felstorm|r
    .accept 41124 >>Accept The Tirisgarde Reborn
    .timer 30,RP
    .target Meryl Felstorm
step
    #completewith next
    #label new title
    .goto 735,63.15,57.27,10,0
    .goto 734,77.67,51.46,10,0
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 41124,1 --1/1 Receive your new title
step
    #completewith new title
    .goto 734,81.61,60.37,30 >>Follow the Arrow
step
    #requires new title
    .goto 734,81.61,60.37
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 41124,1 --1/1 Receive your new title
step
    .goto 734,81.61,60.37
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_The Great Akazamzarak|r
    .turnin 41124 >>Turn in The Tirisgarde Reborn
    .target The Great Akazamzarak
    .accept 41141 >>Accept A Conjuror's Duty
step
    .goto 734,81.37,61.1
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Scouting Map|r
    .complete 41141,1 --1/1 Assault Point Chosen
    .acceptmap 39718
    .accept 39718 >>Accept The Tranquil Forest
step
    .goto 734,81.61,60.37
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_The Great Akazamzarak|r
    .turnin 41141 >>Turn in A Conjuror's Duty
    .target The Great Akazamzarak
step
    #completewith next
    #label Rise, Champions
    .goto 734,73.39,58.98,5,0
    .goto 734,71.31,62.45,5,0
    .goto 734,71.5,58.71,5,0
    .goto 735,71.47,78.45,5,0
    .goto 735,69.44,77.1,5,0
    .goto 735,69.67,63.63,5,0
    .goto 735,63.79,56.74,5,0
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Meryl Felstorm|r
    .accept 42663 >>Accept Rise, Champions
    .target Meryl Felstorm
step
    #completewith Rise, Champions
    #hidewindow
    .goto 735,55.31,38.13,40 >>1
step
    #requires Rise, Champions
    .goto 735,55.28,38.19
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Meryl Felstorm|r
    *|cRXP_WARN_If the npc isn't there, relog|r.
    .accept 42663 >>Accept Rise, Champions
    .target Meryl Felstorm
step
    .goto 735,56.33,37.74
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Kalec|r
    .accept 42662 >>Accept Champion: Archmage Kalec
    .turnin 42662 >>Turn in Champion: Archmage Kalec
    .target Archmage Kalec
    .complete 42663,1 --1/1 Recruit Archmage Kalec
step
    #label Champion: Archmage Modera
    .goto 735,55.29,39.43
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Modera|r
    .accept 42685 >>Accept Champion: Archmage Modera
    .turnin 42685 >>Turn in Champion: Archmage Modera
    .target Archmage Modera
    .complete 42663,2 --1/1 Recruit Archmage Modera
step
    .goto 735,55.35,38.18
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Meryl Felstorm|r
    .turnin 42663 >>Turn in Rise, Champions
    .target Meryl Felstorm
step
    #label OrderHallMage3
    .goto 734,57.31,90.57
    .zone 627 >>Use |T1535374:0|t[Teleport: Dalaran - Broken Isles] or click on the |cRXP_PICK_Portal|r.
    .usespell 224869
]])

---Paladin Order Hall Intro 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ab) Order Hall Paladin Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route

<< Paladin

step
    .isQuestTurnedIn account,91955
    .achievementComplete 61108,1
    +|cRXP_WARN_You’ve already got the 10% XP bonus from the artifact questline. By clicking the text below, you’ll skip the Order Hall intro and parts of Azsuna for faster leveling|r.
    *Manually skip this step if you prefer to play through that content.
    .clicknext RestedXP Legion Remix\ae) First Zone 2 >>CLICK HERE FOR THE GUIDE.
step
    #completewith Order Hall Paladin Part 1
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #label An Urgent Gathering
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Maxwell Tyrosus|r |cRXP_WARN_next to you|r.
    .accept 38710 >>Accept An Urgent Gathering
    .target Lord Maxwell Tyrosus
step
    .goto 627,58.51,42.13
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Maxwell Tyrosus|r
    .complete 38710,1 --1/1 Travard gathered
    .skipgossipid 45834
    .target Travard
step
    .goto 627,41.56,37.33
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Orik Trueheart|r
    .complete 38710,2 --1/1 Orik Trueheart gathered
    .skipgossipid 45835
    .target Orik Trueheart
step
    #label Order Hall Paladin Part 1
    .goto 627,74.92,48.21
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Maxwell Tyrosus|r
    .turnin 38710 >>Turn in An Urgent Gathering
    .target Lord Maxwell Tyrosus
    .accept 40408 >>Accept Weapons of Legend
step
    .isQuestAvailable 40408
    .goto 627,74.92,48.21
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Maxwell Tyrosus|r
    .target Lord Maxwell Tyrosus
    .accept 40408 >>Accept Weapons of Legend
step
    .isQuestAvailable 40408
    +Select one of the following guides for now:
    *|cRXP_WARN_IMPORTANT: Select the one you already have in order to gain an additional 10% xp (one time only)|r
    *|cRXP_WARN_You’ll be able to do the other questlines later|r
    *|cFFFF0000You can't progress if you don't select one|r.
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Retribution >> Retribution(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Paladin Protection >> Protection(Tank) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Holy Paladin >> Holy(Healer) Questline
    -- .clicknext RestedXP Legion Remix\ad) Infinite Bazaar >>Skip to the Infinite Bazaar (You loose the 10% xp bonus)
]])

---Paladin Order Hall Intro 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ac) Order Hall Paladin Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#next ad) Infinite Bazaar

<< Paladin

step
    #completewith Order Hall Paladin Part 2
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
-- step
--     >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eadric the Pure|r
--     .accept 44250 >>Accept Champion of the Light
--     .turnin 44250 >>Turn in Champion of the Light
--     .target Eadric the Pure
step
    #optional
    .isQuestAvailable 40408
    +|cRXP_WARN_You have to do the previous chapter first|r
    .clicknext RestedXP Legion Remix\ab) Order Hall Paladin Part 1 >>Paladin Order Hall Intro 1
step
    #label A United Force
    .goto 24,63.20,37.34
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Maxwell Tyrosus|r
    .target Lord Maxwell Tyrosus
    .accept 38566 >>Accept A United Force
    .timer 54,RP
step
    #title |cFFFCDC00Follow the Arrow|r
    .goto 24,74.71,20.51
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 38566,1 --1/1 Walk with Lord Maxwell Tyrosus
step
    .goto 24,74.71,20.51
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Book|r
    .complete 38566,2 --1/1 Inscribe your name in the Libram
    .timer 72,RP
step
    .goto 24,73.86,19.68
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 38566,3 --1/1 Establish the Order of the Silver Hand
step
    .goto 24,73.86,19.68
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Maxwell Tyrosus|r
    .turnin 38566 >>Turn in A United Force
    .target Lord Maxwell Tyrosus
    .accept 38933 >>Accept Logistical Matters
step
    #completewith next
    #label Logistical Matters
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Grayson Shadowbreaker|r
    .turnin 38933 >>Turn in Logistical Matters
    .target Lord Grayson Shadowbreaker
    .accept 39756 >>Accept A Sound Plan
step
    #completewith Logistical Matters
    #hidewindow
    .goto 24,46.35,65.51,20,0
    .goto 24,52.29,78.12,40 >>1
step
    #requires Logistical Matters
    .goto 24,52.38,78.15
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Grayson Shadowbreaker|r
    .turnin 38933 >>Turn in Logistical Matters
    .target Lord Grayson Shadowbreaker
    .accept 39756 >>Accept A Sound Plan
step
    .goto 24,53.37,78.68
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Scouting Map|r
    .complete 39756,1 --1/1 Assault Point Chosen
    .acceptmap 39718
    .accept 39718 >>Accept The Tranquil Forest
step
    .goto 24,53.37,78.68
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Scouting Map|r
    .complete 39756,1 --1/1 Initial strike point chosen
step
    .goto 24,52.29,78.07
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Grayson Shadowbreaker|r
    .turnin 39756 >>Turn in A Sound Plan
    .target Lord Grayson Shadowbreaker
step
    .goto 24,49.83,72.39
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Maxwell Tyrosus|r
    *|cRXP_WARN_If NPCS aren't there, relog|r
    .accept 39696 >>Accept Rise, Champions
    .turnin 39696 >>Turn in Rise, Champions
    .accept 42846 >>Accept The Blood Matriarch
    .target Lord Maxwell Tyrosus
step
    #label Order Hall Paladin Part 2
    .goto 24,38.22,64.73
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Liadrin|r
    .accept 42881 >>Accept Champion: Lady Liadrin
    .turnin 42881 >>Turn in Champion: Lady Liadrin
    .target Lady Liadrin
    .complete 42846,1 --1/1 Enlist Lady Liadrin
step
    .isOnQuest 42846
    .goto 24,37.79,63.92
    .zone 627 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal|r
]])

---Priest Order Hall Intro 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ab) Order Hall Priest Part 1
#displayname |cFF00FF004|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route

<< Priest

step
    .isQuestTurnedIn account,91955
    .achievementComplete 61108,1
    +|cRXP_WARN_You’ve already got the 10% XP bonus from the artifact questline. By clicking the text below, you’ll skip the Order Hall intro and parts of Azsuna for faster leveling|r.
    *Manually skip this step if you prefer to play through that content.
    .clicknext RestedXP Legion Remix\ae) First Zone 2 >>CLICK HERE FOR THE GUIDE.
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Hooded Priestess|r |cRXP_WARN_next to you|r.
    *|cRXP_WARN_Note:|r If she doesn't appear then try to relog.
    .accept 40705 >>Accept Priestly Matters
    .target Hooded Priestess
step
    >>Use |T413582:0|t[Faol's Hearthstone]
    .complete 40705,1 --1/1 Faol's Hearthstone used (Optional)
    .use 173373
step
    .goto 18,79.09,41.05
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alonsus Faol|r. << Horde
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calia|r. << Alliance
    .complete 40705,2 --1/1 Meet with the priest at Faol's Rest in Tirisfal Glades
    .timer 60,Alonsus Roleplay
    .target Alonsus Faol << Horde
    .target Calia << Alliance
    .skipgossipid 1 << Horde
    .skipgossipid 45465 << Alliance
step
    .goto 18,78.96,40.99
    >>|cRXP_WARN_Wait for the roleplay.|r
    .complete 40705,3 --1/1 Listen to Alonsus Faol
step
    .goto 18,78.96,40.99
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alonsus Faol|r
    .turnin 40705 >>Turn in Priestly Matters
    .accept 40706 >>Accept A Legend You Can Hold
    .target Alonsus Faol
step
    .isQuestAvailable 40706
    .isQuestAvailable account,91955
    .goto 18,78.96,40.99
    +Select one of the following guides for now:
    *|cRXP_WARN_IMPORTANT: Select the one you already have in order to gain an additional 10% xp (one time only)|r
    *|cRXP_WARN_You’ll be able to do the other questlines later|r
    *|cFFFF0000You can't progress if you don't select one|r.
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Shadow >> Shadow(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Holy Priest >> Holy(Healer) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Discipline >> Discipline(Healer) Questline
    -- .clicknext RestedXP Legion Remix\ad) Infinite Bazaar >>Skip to the Infinite Bazaar (You loose the 10% xp bonus)
]])

---Priest Order Hall Intro 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ac) Order Hall Priest Part 2
#displayname |cFF00CCFF4|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#next ad) Infinite Bazaar

<< Priest

step
    #optional
    .isQuestAvailable 40706
    +|cRXP_WARN_You have to do the previous chapter first|r
    .clicknext RestedXP Legion Remix\ab) Order Hall Priest Part 1>>Priest Order Hall Intro 1
step
    .goto 627,46.30,20.47
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Prophet Velen|r
    .accept 40938 >>Accept The Light and the Void
    .target Prophet Velen
step
    .zoneskip 629
    .isOnQuest 40938
    .goto 627,51.83,42.85,10,0
    .goto 627,49.25,47.64
    .zone 629 >>Use the teleporter in the center of Dalaran
step
    .goto 629,36.69,73.33
    >>|cRXP_WARN_Follow the arrow.|r
    *|cRXP_WARN_Note:|r. You can find the portal after using the teleporter in the middle of Dalaran if the arrow is incorrect for whatever reason.
    .complete 40938,1 --1/1 Follow Velen to the portal
step
    .goto 629,33.99,78.13
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal to Netherlight Temple|r.
    .complete 40938,2 --1/1 Take the portal to Netherlight Temple
step
    .goto 702,49.77,47.42
    >>|cRXP_WARN_Wait for the roleplay|r.
    .complete 40938,3 --1/1 Listen to Alonsus Faol
step
    .goto 702,49.77,47.42
    >>Use the |T135907:0|t[|cRXP_WARN_ExtraActionButton|r]
    .complete 40938,4 --1/1 Complete the Ritual of Light
    .timer 78,Roleplay
step
    .goto 702,49.76,31.63
    >>|cRXP_WARN_Wait for the roleplay.|r
    .complete 40938,5 --1/1 Be a part of the ceremony
step
    .goto 702,48.67,48.42
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alonsus Faol|r
    .turnin 40938 >>Turn in The Light and the Void
    .accept 41019 >>Accept Actions on Azeroth
    .target Alonsus Faol
step
    .goto 702,48.67,48.42
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Command Map|r.
    .complete 41019,1 --1/1 Area chosen
step
    .goto 702,48.67,48.42
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alonsus Faol|r
    .turnin 41019 >>Turn in Actions on Azeroth
    .target Alonsus Faol
step
    .goto 702,51.60,47.69
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alonsus Faol|r
    .accept 43270 >>Accept Rise, Champions
    .target Alonsus Faol
step
    .goto 702,51.83,49.06
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calia Menethil|r.
    .accept 43271 >>Accept Champion: Calia Menethil
    .turnin 43271 >>Turn in Champion: Calia Menethil
    .complete 43270,1 --1/1 Recruit Calia
    .target Calia Menethil
step
    .goto 702,57.57,25.74
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_High Priestess Ishanah|r.
    .accept 43272 >>Accept Champion: High Priestess Ishanah
    .turnin 43272 >>Turn in Champion: High Priestess Ishanah
    .complete 43270,2 --1/1 Recruit Ishanah
    .target High Priestess Ishanah
step
    .isNotOnQuest 43372
    .isQuestAvailable 43372
    .goto 702,51.55,47.76
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Alonsus Faol|r
    .turnin 43270 >>Turn in Rise, Champions
    .target Alonsus Faol
step
    .zoneskip 702,1
    .goto 702,49.79,80.59
    .zone 627 >>Click on the |cRXP_PICK_Portal to Dalaran|r.
]])

---Rogue Order Hall Intro 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ab) Order Hall Rogue Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route

<< Rogue

step
    .isQuestTurnedIn account,91955
    .achievementComplete 61108,1
    +|cRXP_WARN_You’ve already got the 10% XP bonus from the artifact questline. By clicking the text below, you’ll skip the Order Hall intro and parts of Azsuna for faster leveling|r.
    *Manually skip this step if you prefer to play through that content.
    .clicknext RestedXP Legion Remix\ae) First Zone 2 >>CLICK HERE FOR THE GUIDE.
step
    #completewith Order Hall Rogue Part 1
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #label Call of The Uncrowned
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ravenholdt Courier|r |cRXP_WARN_next to you|r.
    .accept 40832 >>Accept Call of The Uncrowned
    .target Ravenholdt Courier
step
    #completewith next
    #label whispered2
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 40832,1 --1/1 Letter read
    .target "Red" Jack Findle
step
    #completewith whispered2
    .isOnQuest 40832
    .cast 201253 >>Use |T134940:0|t[Sealed Letter]
    .timer 24,RP
    .use 133558
step
    #requires whispered2
    .holiday 324
    .goto 627,47.96,41.70
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Candy Bucket|r
    .turnin 43055 >>Turn in Candy Bucket 
    .target Candy Bucket
step << Alliance
    #requires whispered2
    .holiday 324
    .goto 627,41.63,64.10
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Candy Bucket|r
    .turnin 43056 >>Turn in Candy Bucket
step
    #requires whispered2
    #completewith next
    #label whispered
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 40832,1 --1/1 Letter read
    .target "Red" Jack Findle
step
    #requires whispered2
    #completewith whispered
    .goto 627,51.55,68.59,5 >>Enter the Shop
step
    #requires whispered
    .goto 627,53.21,71.04
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 40832,1 --1/1 Letter read
step
    .goto 627,53.21,71.04
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ravenholdt Courier|r
    .complete 40832,2 --1/1 Phrase whispered to "Red"
    .skipgossipid 45226
    .target "Red" Jack Findle
step
    #hidewindow
    #completewith Hall of Shadows
    #title |cFFFCDC00Follow the Arrow|r
    .goto 626,82.38,80.61,10,0
    .goto 626,87.1,89.67,15,0
    .goto 626,90.77,85.6,10,0
    .goto 626,78.67,65.93,15,0
    .goto 626,64.04,52.91,15,0
    .goto 626,52.67,56.93,10,0
    .goto 626,50.29,51.45,10,0
    .goto 626,42.4,68.44
    +1
step
    #title |cFFFCDC00Follow the Arrow|r
    .complete 40832,3 --1/1 Enter the Hall of Shadows
step
    #label Hall of Shadows
    #title |cFFFCDC00Follow the Arrow|r
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Torch|r to open the door to the secret room.
    .complete 40832,4 --1/1 Find 'The Uncrowned'
step
    .goto 626,41.37,77.95
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Jorach Ravenholdt|r
    .turnin 40832 >>Turn in Call of The Uncrowned
    .target Lord Jorach Ravenholdt
    .accept 40839 >>Accept The Final Shadow
step
    .goto 626,42.24,77.09
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Seat|r
    .complete 40839,1 --1/1 Take your seat
    .timer 83,RP
step
    .goto 626,41.37,77.95
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 40839,2 --1/1 Inducted into the Uncrowned
step
    #label Final Shadow
    .goto 626,41.37,77.95
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Jorach Ravenholdt|r
    .turnin 40839 >>Turn in The Final Shadow
    .target Lord Jorach Ravenholdt
    .accept 40840 >>Accept A Worthy Blade
step
    #label Order Hall Rogue Part 1
    .isQuestAvailable 40840
    .goto 626,41.37,77.95
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Jorach Ravenholdt|r
    .target Lord Jorach Ravenholdt
    .accept 40840 >>Accept A Worthy Blade
step
    .isOnQuest 40840
    .goto 626,41.7,75.76
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Fleet Admiral Tethys|r, |cRXP_FRIENDLY_Valeera Sanguinar|r,  and  |cRXP_FRIENDLY_Princess Tess Greymane|r.
    .complete 40840,2 --1/1 Valeera's plan considered
    .complete 40840,1 --1/1 Tethys' plan considered
    .complete 40840,3 --1/1 Tess' plan considered
    .skipgossipid 45256
    .skipgossipid 45235
    .skipgossipid 45103
    .target Fleet Admiral Tethys
    .target Valeera Sanguinar
    .target Princess Tess Greymane
step
    .isQuestAvailable 40840
    +Select one of the following guides for now:
    *|cRXP_WARN_IMPORTANT: Select the one you already have in order to gain an additional 10% xp (one time only)|r
    *|cRXP_WARN_You’ll be able to do the other questlines later|r
    *|cFFFF0000You can't progress if you don't select one|r.
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Assassination >> Assassination(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Outlaw >> Outlaw(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Subtlety >> Subtlety(DPS) Questline
    -- .clicknext RestedXP Legion Remix\ad) Infinite Bazaar >>Skip to the Infinite Bazaar (You loose the 10% xp bonus)
]])

---Rogue Order Hall Intro 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ac) Order Hall Rogue Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#next ad) Infinite Bazaar

<< Rogue

step
    #completewith Order Hall Rogue Part 2
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #optional
    .isQuestAvailable 40840
    +|cRXP_WARN_You have to do the previous chapter first|r
    .clicknext RestedXP Legion Remix\ab) Order Hall Rogue Part 1 >>Rogue Order Hall Intro 1
step
    #label Honoring Success
    .goto 626,41.48,77.92
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Jorach Ravenholdt|r
    .accept 40950 >>Accept Honoring Success
    .timer 24.5,RP
    .target Lord Jorach Ravenholdt
step
    .goto 626,41.82,75.39
    >>Use the |cRXP_WARN_ExtraActionButton|r
    .complete 40950,1 --1/1 Raise your glass
    .timer 56,RP
step
    .goto 626,42.48,68.46
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 40950,2 --1/1 Celebrate your victory
step
    .goto 626,42.48,68.46
    >>Defeat |cRXP_ENEMY_Vanessa VanCleef|r then return to |cRXP_FRIENDLY_Lord Jorach Ravenholdt|r
    .complete 40950,3 --1/1 Vanessa VanCleef defeated
    .mob Vanessa VanCleef
    .target Lord Jorach Ravenholdt
step
    .goto 626,41.48,78.29
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lord Jorach Ravenholdt|r
    .turnin 40950 >>Turn in Honoring Success
    .target Lord Jorach Ravenholdt
    .accept 40996 >>Accept Delegation
step
    #completewith next
    #label Lethal Efficiency
    .goto 626,44.67,56.99,10,0
    .goto 626,44.86,49.8,10,0
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nikki the Gossip|r
    .turnin 40996 >>Turn in Delegation
    .accept 40997 >>Accept Lethal Efficiency
    .disablecheckbox
    .target Nikki the Gossip
step
    #title |cFFFCDC00Follow the Arrow|r
    #completewith Lethal Efficiency
    .goto 626,37.79,44.86,25 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Torch|r to exit secret room.
step
    #requires Lethal Efficiency
    .goto 626,37.79,44.86
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nikki the Gossip|r
    .turnin 40996 >>Turn in Delegation
    .accept 40997 >>Accept Lethal Efficiency
    .target Nikki the Gossip
step
    .goto 626,37.39,44.22
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Scouting Map|r
    .complete 40997,1 --1/1 Assault Point Chosen
    .acceptmap 39718
    .accept 39718 >>Accept The Tranquil Forest
step
    #label Order Hall Rogue Part 2
    .goto 626,37.79,44.86
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nikki the Gossip|r
    .turnin 40997 >>Turn in Lethal Efficiency
    .target Nikki the Gossip
-- step
--     .goto 626,33.39,38.62,10,0
--     .goto 626,24.58,51.69,10,0
--     .goto 626,11.34,65.55,10,0
--     .goto 626,3.02,83.45,10,0
--     .goto 627,20.06,80.96,10 >>Leave the Sewer
step
    .goto 626,39.68,21.33
    .cast 6477 >>Click on the |cRXP_PICK_Knocker|r
]])

---Shaman Order Hall Intro 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ab) Order Hall Shaman Part 1
#displayname |cFF00FF004|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route

<< Shaman

step
    .isQuestTurnedIn account,91955
    .achievementComplete 61108,1
    +|cRXP_WARN_You’ve already got the 10% XP bonus from the artifact questline. By clicking the text below, you’ll skip the Order Hall intro and parts of Azsuna for faster leveling|r.
    *Manually skip this step if you prefer to play through that content.
    .clicknext RestedXP Legion Remix\ae) First Zone 2 >>CLICK HERE FOR THE GUIDE.
step
    .goto 627,47.31,33.47
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thrall|r
    .accept 39746 >>Accept A Ring Unbroken
    .target Thrall
step
    .goto 627,73.85,43.56
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_FRIENDLY_Stormbeak|r
    .complete 39746,1 --1/1 Fly to the Maelstrom with Mylra
    .target Stormbeak
step
    .isOnQuest 39746
    .goto 627,73.85,43.56
    .enterScenario 1038 >>Enter the |cRXP_PICK_Melee at the Maelstrom|r scenario.
step
    .isInScenario 1038
    .goto 725,31.52,76.24
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farseer Nobundo|r
    .scenario 2205,1 --1/1 Speak with Nobundo
    .target Farseer Nobundo
    .skipgossipid 45305
step
    .isInScenario 1038
    .goto 725,30.01,77.45
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Maelstrom Pillar|r
    .scenario 2206,3 --1/1 Help Rehgar and Erunak
step
    .isInScenario 1038
    .goto 725,33.66,81.85
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_FRIENDLY_Screech|r
    .scenario 2206,1 --1/1 Help the Dwarves
step
    .isInScenario 1038
    .goto 725,32.06,71.57
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Damp Campfire|r
    .scenario 2206,2 --1/1 Help the Tauren and Trolls
step
    #loop
    .goto 725,31.07,70.68,25,0
    .goto 725,30.11,84.72,25,0
    .goto 725,35.31,77.68,25,0
    .isInScenario 1038
    >>Kill the |cRXP_ENEMY_Infernals|r
    .scenario 2207,1 --5/5 Defeat the Infernals
    .mob Infernal
step
    .isInScenario 1038
    .goto 725,30.19,76.62
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_FRIENDLY_Tribemother Torra|r
    >>Use the |T135129:0|t[|cRXP_WARN_ExtraActionButton|r]
    .scenario 2208,1 --1/1 Use Torra's Spear to Bring Down the Felbat Falthus
    .target Tribemother Torra
step
    .isInScenario 1038
    .goto 725,30.01,77.44
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Maelstrom Pillar|r
    .scenario 2209,1 --1/1 Active the Maelstrom Pillar to Defeat Geth'xun
step
    .goto 725,29.91,77.48
    >>Complete the scenario
    .complete 39746,2 --Aid Shaman at the Maelstrom
step
    .goto 725,36.20,74.91
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thrall|r
    .turnin 39746 >>Turn in A Ring Unbroken
    .accept 41335 >>Accept The Elements Call...
    .target Thrall
step
    .isQuestAvailable 41335
    .isQuestAvailable account,91955
    +Select one of the following guides for now:
    *|cRXP_WARN_IMPORTANT: Select the one you already have in order to gain an additional 10% xp (one time only)|r
    *|cRXP_WARN_You’ll be able to do the other questlines later|r
    *|cFFFF0000You can't progress if you don't select one|r.
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Elemental >> Elemental(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Enhancement >> Enhancement(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Restoration Shaman >> Restoration(Healer) Questline
    -- .clicknext RestedXP Legion Remix\ad) Infinite Bazaar >>Skip to the Infinite Bazaar (You loose the 10% xp bonus)
]])

---Shaman Order Hall Intro 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ac) Order Hall Shaman Part 2
#displayname |cFF00FF003|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#next ad) Infinite Bazaar

<< Shaman

step
    #optional
    .isQuestAvailable 41335
    +|cRXP_WARN_You have to do the previous chapter first|r
    .clicknext RestedXP Legion Remix\ab) Order Hall Shaman Part 1 >>Shaman Order Hall Intro 1
step
    .goto 726,34.04,76.76
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Stormcaller Mylra|r
    .accept 40225 >>Accept A Ring Reforged
    .target Stormcaller Mylra
step
    .goto 726,30.25,77.50
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nobundo|r
    .complete 40225,1 --1/1 Speak to Nobundo
    .timer 24,Nobundo Roleplay
    .target Nobundo
    .skipgossipid 44785
step
    .goto 726,29.16,69.57
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Ancient Rockslide|r
    .complete 40225,2 --1/1 Unearth the Heart of Azeroth
step
    .goto 726,28.99,69.20
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farseer Nobundo|r
    .turnin 40225 >>Turn in A Ring Reforged
    .accept 41510 >>Accept Azeroth Needs You
    .target Farseer Nobundo
step
    .goto 726,33.49,59.38
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Scouting Map|r
    .complete 41510,1 --1/1 Initial strike point chosen
    .acceptmap 39718
step
    .goto 726,30.38,51.63
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Farseer Nobundo|r
    .turnin 41510 >>Turn in Azeroth Needs You
    .target Farseer Nobundo
step
    .zoneskip 726,1
    .goto 726,29.81,52.02
    .zone 627 >>Click on the |cRXP_PICK_Portal to Dalaran|r.
]])

---Warlock Order Hall Intro 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ab) Order Hall Warlock Part 1
#displayname |cFF00FF004|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route

<< Warlock

step
    .isQuestTurnedIn account,91955
    .achievementComplete 61108,1
    +|cRXP_WARN_You’ve already got the 10% XP bonus from the artifact questline. By clicking the text below, you’ll skip the Order Hall intro and parts of Azsuna for faster leveling|r.
    *Manually skip this step if you prefer to play through that content.
    .clicknext RestedXP Legion Remix\ae) First Zone 2 >>CLICK HERE FOR THE GUIDE.
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ritssyn Flamescowl|r
    .accept 40716 >>Accept The Sixth
    .target Ritssyn Flamescowl
step
    .goto 627,60.17,48.28,8,0
    .goto 628,74.22,66.56,8,0
    .goto 628,64.44,58.55,8,0
    .goto 628,57.87,60.00
    >>Click on the |cRXP_PICK_Dark Portal|r or |cRXP_WARN_follow the arrow.|r
    .complete 40716,1 --1/1 Enter Dalaran's Underbelly
step
    .goto 628,57.87,60.00
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ritssyn Flamescowl|r
    .turnin 40716 >>Turn in The Sixth
    .accept 40729 >>Accept The New Blood
    .timer 40,Ritssyn Roleplay
    .target Ritssyn Flamescowl
step
    .goto 628,59.79,69.11
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Summoning Portal|r after the roleplay.
    .complete 40729,1 --1/1 Ritual Perfomed
step
    .isOnQuest 40729
    .goto 628,57.87,60.00
    .enterScenario 962 >>Enter the |cRXP_PICK_Into the Mouth of the Nether|r scenario.
step
    .isInScenario 962
    .goto 718,34.99,63.04
    >>|cRXP_WARN_Wait for the roleplay.|r
    .scenario 1944,1 --Listen to Ritssyn
step
    .isInScenario 962
    #title Use the |T136154:0|t[ExtraActionButton]
    .goto 718,34.99,63.04
    >>Use the |T136154:0|t[|cRXP_WARN_ExtraActionButton|r] (Enslave Beshtal)
    .scenario 1945,1 --Beshtal enslaved
    .timer 42,Escape Roleplay
step
    .isInScenario 962
    .goto 718,34.76,60.83
    >>Kill |cRXP_ENEMY_Beshtal|r. |cRXP_WARN_Wait for the roleplay.|r
    .scenario 1945,2 --Escape the Jailer
-- TODO: cast 195039 to make the waypoint update faster
step
    .isInScenario 962
    .goto 718,24.43,59.90
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_FRIENDLY_Jubeka Shadowbreaker|r.
    .scenario 1949,1 --Jubeka Shadowbreaker freed
    .target Jubeka Shadowbreaker
step
    .isInScenario 962
    .goto 718,38.05,74.69
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_FRIENDLY_Zinnin Smythe|r.
    .scenario 1949,2 --Zinnin Smythe Freed
    .target Zinnin Smythe
step
    .isInScenario 962
    .goto 718,42.80,61.86
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_FRIENDLY_Shinfel Blightsworn|r.
    .scenario 1949,3 --Shinfel Blightsworn freed
    .target Shinfel Blightsworn
step
    #completewith MeetWithCalydusC
    #label MeetWithCalydusA
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the two |cRXP_PICK_Barrier Controls|r and run to |cRXP_FRIENDLY_Calydus|r.
    *|cRXP_WARN_NOTE:|r Skipping the barrier doesn't work.
    .scenario 1953,1 --Meet with Calydus
    .isInScenario 962
step
    #completewith MeetWithCalydusA
    #label MeetWithCalydusB
    #loop
    .goto 718,41.43,49.12,10,0
    .goto 718,37.70,47.07,10,0
    .cast 3365 >>Click on the |cRXP_PICK_Barrier Controls|r.
step
    #requires MeetWithCalydusB
    #completewith MeetWithCalydusA
    #label MeetWithCalydusC
    #loop
    .goto 718,37.70,47.07,10,0
    .goto 718,41.43,49.12,10,0
    .cast 3365 >>Click on the |cRXP_PICK_Barrier Controls|r.
step
    #requires MeetWithCalydusA
    .isInScenario 962
    .goto 718,41.88,41.38
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the two |cRXP_PICK_Barrier Controls|r and run to |cRXP_FRIENDLY_Calydus|r.
    *|cRXP_WARN_NOTE:|r Skipping the barrier doesn't work.
    .scenario 1953,1 --Meet with Calydus
step
    .isInScenario 962
    .goto 718,56.37,36.24
    >>Kill |cRXP_ENEMY_Nelach, the All-Seeing|r.
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Tome of Blighted Implements|r after a short roleplay.
    .scenario 1950,1 --Tome of Blighted Implements
    .mob Nelach, the All-Seeing
step
    .isInScenario 962
    .goto 718,49.05,29.56,20,0
    .goto 718,56.84,23.76,20,0
    .goto 718,67.86,36.76,20,0
    .goto 718,72.64,37.92
    >>Kill |cRXP_ENEMY_Xel'toth|r. |cRXP_WARN_Run through the portal.|r
    .scenario 1952,1 --Escape from Jagganoth's Lair
    .mob Xel'toth
step
    .goto 628,55.75,65.29
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calydus|r.
    .turnin 40729 >>Turn in The New Blood
    .accept 40684 >>Accept The Tome of Blighted Implements
    .target Calydus
step
    .isQuestAvailable 40684
    .isQuestAvailable account,91955
    +Select one of the following guides for now:
    *|cRXP_WARN_IMPORTANT: Select the one you already have in order to gain an additional 10% xp (one time only)|r
    *|cRXP_WARN_You’ll be able to do the other questlines later|r
    *|cFFFF0000You can't progress if you don't select one|r.
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Affliction >> Affliction(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Demonology >> Demonology(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Destruction >> Destruction(DPS) Questline
    -- .clicknext RestedXP Legion Remix\ad) Infinite Bazaar >>Skip to the Infinite Bazaar (You loose the 10% xp bonus)
]])

---Warlock Order Hall Intro 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ac) Order Hall Warlock Part 2
#displayname |cFF00CCFF3|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#next ad) Infinite Bazaar

<< Warlock

step
    #optional
    .isQuestAvailable 40684
    +|cRXP_WARN_You have to do the previous chapter first|r
    .clicknext RestedXP Legion Remix\ab) Order Hall Warlock Part 1 >>Warlock Order Hall Intro 1
step
    .goto 628,55.81,65.35
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calydus|r.
    .accept 40731 >>Accept The Heart of the Dreadscar
    .target Calydus
step
    #completewith next
    #label TheHeartOfTheDreadscarA
    #hidewindow
    .complete 40731,1 --1/1 Dreadscar Rift claimed
step
    #completewith TheHeartOfTheDreadscarA
    .goto 628,59.27,69.68
    .enterScenario 998 >>Enter the |cRXP_PICK_The Heart of the Dreadscar|r scenario.
step
    #requires TheHeartOfTheDreadscarA
    .goto 718,56.42,36.34
    .isInScenario 998
    >>Kill |cRXP_ENEMY_Jagganoth|r.
    .scenario 2057,1 --Jagganoth Defeated
    .mob Jagganoth
step
    .isInScenario 998
    .goto 718,56.42,36.34
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_PICK_Jagganoth|r.
    .scenario 2058,1 --Heart of the Overlord
    .goto 718,55.38,49.78,35,0
step
    .isInScenario 998
    .goto 718,54.60,48.57,15,0
    .goto 718,32.42,25.75
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Heart of the Overlord|r.
    .scenario 2059,1 --Heart placed above the altar
    .timer 40,Roleplay Duration
step
    .isInScenario 998
    .goto 718,35.97,30.99
    >>|cRXP_WARN_Wait for the roleplay.|r
    .scenario 2059,2 --Command Jagganoth's armies
    .complete 40731,1 --1/1 Dreadscar Rift claimed
step
    .goto 717,37.65,31.21
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calydus|r
    .turnin 40731 >>Turn in The Heart of the Dreadscar
    .accept 40823 >>Accept Rebuilding the Council
    .target Calydus
step
    #completewith next
    #hidewindow
    .cast 201060 >>1
    .timer 25,Ritssyn Roleplay
step
    .goto 717,31.87,56.73
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_PICK_Ritssyn Flamescowl|r.
    .complete 40823,1 --1/1 Ritssyn Resurrected
    .target Ritssyn Flamescowl
step
    .goto 717,30.89,58.31
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ritssyn Flamescowl|r
    .turnin 40823 >>Turn in Rebuilding the Council
    .target Ritssyn Flamescowl
    .accept 40824 >>Accept The Path of the Dreadscar
step
    .goto 717,45.15,37.72,15,0
    .goto 717,66.24,46.98
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Scouting Map|r.
    .accept 39718 >>Accept Paradise Lost
    .complete 40824,1 --1/1 Zone Chosen
    .acceptmap 39718
step
    .goto 717,65.74,47.79
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ritssyn Flamescowl|r
    .turnin 40824 >>Turn in The Path of the Dreadscar
    .target Ritssyn Flamescowl
step
    .goto 717,37.63,31.14
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Calydus|r
    .accept 42608 >>Accept Rise, Champions
    .accept 41750 >>Accept Champion: Calydus
    .turnin 41750 >>Turn in Champion: Calydus
    .complete 42608,1 --Recruit Calydus
    .target Calydus
step
    .goto 717,65.69,47.76
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ritssyn Flamescowl|r
    .accept 41748 >>Accept Champion: Ritssyn Flamescowl
    .turnin 41748 >>Turn in Champion: Ritssyn Flamescowl
    .complete 42608,2 --Recruit Ritssyn Flamescowl
    .target Ritssyn Flamescowl
step
    .goto 717,66.95,46.36
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Gakin the Darkbinder|r
    .turnin 42608 >>Turn in Rise, Champions
    .target Gakin the Darkbinder
step
    .zoneskip 717,1
    .goto 717,74.71,38.14
    .zone 628 >>|cRXP_WARN_Go through the portal to Dalaran.|r
step
    .zoneskip 628,1
    .goto 628,28.84,53.19,12,0
    .goto 628,19.50,57.61,10,0
    .goto 627,35.02,45.56
    .zone 627 >>|cRXP_WARN_Follow the way out of the canal.|r
]])

---Warrior Order Hall Intro 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ab) Order Hall Warrior Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route

<< Warrior

step
    .isQuestTurnedIn account,91955
    .achievementComplete 61108,1
    +|cRXP_WARN_You’ve already got the 10% XP bonus from the artifact questline. By clicking the text below, you’ll skip the Order Hall intro and parts of Azsuna for faster leveling|r.
    *Manually skip this step if you prefer to play through that content.
    .clicknext RestedXP Legion Remix\ae) First Zone 2 >>CLICK HERE FOR THE GUIDE.
step
    #completewith Order Hall Warrior Part 1
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step << Alliance
    #label OrderHallWarriorA1Start
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sergeant Dalton|r |cRXP_WARN_next to you|r.
    .accept 42814 >>Accept An Important Mission
    .target Sergeant Dalton
step << Horde
    #label OrderHallWarriorH1Start
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eitrigg|r |cRXP_WARN_next to you|r.
    .accept 41052 >>Accept A Desperate Plea
    .target Eitrigg
step
    #optional 
    .convertquest 42815,38904 << Horde
step << Horde
    .goto 627,75.06,46.25
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_High Overlord Saurfang|r
    .complete 41052,1 --1/1 Speak with High Overlord Saurfang
    .skipgossipid 45801
    .skipgossipid 45802
    .target High Overlord Saurfang
step << Horde
    .goto 627,75.06,46.25
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_High Overlord Saurfang|r
    .turnin 41052 >>Turn in A Desperate Plea
    .accept 38904 >>Accept Return to the Broken Shore
    .target High Overlord Saurfang
step << Alliance
    .goto 627,74.61,45.04
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Danath Trollbane|r
    .turnin 42814 >>Turn in An Important Mission
    .target Danath Trollbane
    .accept 42815 >>Accept Return to the Broken Shore
step << Alliance
    #completewith next
    #label Broken Shore
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 42815,1,1 --1/1 Take the flight to the Broken Shore
step << Alliance
    #completewith Broken Shore
    .goto 627,74.49,44.14
    .vehicle >>Click on the |cRXP_PICK_Elite Gryphon|r
    .timer 50,RP
    .target Elite Gryphon
step << Alliance
    #requires Broken Shore
    #label OrderHallWarriorA1End
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 42815,1,1 --1/1 Take the flight to the Broken Shore
step << Horde
    #completewith next
    #label Broken Shore
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 42815,1,1 --1/1 Take the flight to the Broken Shore
step << Horde
    #completewith Broken Shore
    .goto 627,75.06,47.18
    .vehicle >>Click on the |cRXP_PICK_Makka|r
    .timer 50,RP
    .target Makka
step << Horde
    #label OrderHallWarriorH1End
    #requires Broken Shore
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 42815,1,1 --1/1 Take the flight to the Broken Shore
step
    #label OrderHallWarrior1
    .isOnQuest 42815
    #title |cFFFCDC00Follow the Arrow|r
    .goto 676,50.86,28.18,15 >>|cRXP_WARN_Wait for the arrival at the shore|r.
step
    .goto 676,50.86,28.18
    .isOnQuest 42815
    #title |cFFFCDC00Follow the Arrow|r
    .scenario 1870,1 --Meet up with the vrykul.
step
    .goto 676,52,29.8,30,0
    .goto 676,50.1,29.77,30,0
    .goto 676,51.29,30.46
    .isInScenario 933
    >>Kill |cRXP_ENEMY_Legion forces|r
    .scenario 1871,1 --Legion forces eliminated
    .timer 30,RP
    .mob Fel Lord Dakuur
    .mob Impling Pursuer
    .mob Eredar Enslaver
step
    .isInScenario 933
    .goto 676,51.29,30.46
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .scenario 2225,1 --Approach Danica
    .timer 20,RP
    .target Danica the Reclaimer
step
    .isInScenario 933
    .goto 676,49.91,35.5
    .countdown 19 >>Follow the Arrow and |cRXP_WARN_wait for the Roleplay|r.
step
    .goto 676,50.1,32.07
    .isInScenario 933
    >>Kill |cRXP_ENEMY_Bezzeredes|r and his allies.
    .scenario 1872,1 --Defeat Bezzeredes and his allies.
    .timer 53,RP
    .mob Bezzeredes
    .mob Eredar Enslaver
step
    .goto 676,49.43,33.61
    .isInScenario 933
    >>Kill |cRXP_ENEMY_Malgalor|r
    .scenario 1873,1 --Defeat Malgalor
    .timer 21,RP
    .mob Malgalor
step
    >>|cRXP_WARN_Wait for the Roleplay|r.
    .complete 42815,2 --1/1 Prove your valor on the Broken Shore
step
    .goto 695,58.99,29.95
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Danica the Reclaimer|r
    .turnin 42815 >>Turn in Return to the Broken Shore
    .target Danica the Reclaimer
    .accept 39654 >>Accept Odyn and the Valarjar
    .timer 13,RP
step
    .goto 695,58.59,72.24
    #title |cFFFCDC00Follow the Arrow|r
    .complete 39654,1 --1/1 Follow Danica
step
    .goto 695,58.59,72.24
    #title |cFFFCDC00Follow the Arrow|r
    .complete 39654,2 --1/1 Go to the Great Mead Hall
step 
    #label Order Hall Warrior Part 1
    .goto 695,58.33,84.38
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Odyn|r
    .turnin 39654 >>Turn in Odyn and the Valarjar
    .accept 40579 >>Accept Weapons of Legend
    .target Odyn
step
    .isQuestAvailable 40579
    .goto 695,58.33,84.38
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Odyn|r
    .accept 40579 >>Accept Weapons of Legend
    .target Odyn
step
    .isQuestAvailable 40579
    -- .isQuestAvailable account,91955
    +Select one of the following guides for now:
    *|cRXP_WARN_IMPORTANT: Select the one you already have in order to gain an additional 10% xp (one time only)|r
    *|cRXP_WARN_You’ll be able to do the other questlines later|r
    *|cFFFF0000You can't progress if you don't select one|r.
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Arms >> Arms(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Fury >> Fury(DPS) Questline
    .clicknext RestedXP Legion Remix\z) Artifact Weapon: Warrior Protection >> Protection(Tank) Questline
    -- .clicknext RestedXP Legion Remix\ad) Infinite Bazaar >>Skip to the Infinite Bazaar (You loose the 10% xp bonus)
]])

---Warrior Order Hall Intro 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name ac) Order Hall Warrior Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#next ad) Infinite Bazaar

<< Warrior

step
    #completewith Accept The Eye of Odyn
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #optional
    .isQuestAvailable 40579
    +|cRXP_WARN_You have to do the previous chapter first|r
    .clicknext RestedXP Legion Remix\ab) Order Hall Warrior Part 1 >>Warrior Order Hall Intro 1
step
    #label OderHallPart2Start1
    .goto 695,59.58,83.93
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Danica the Reclaimer|r
    .accept 39214 >>Accept The Eye of Odyn
    .target Danica the Reclaimer
step
    #completewith next
    #label The Eye of Odyn
    .goto 695,58.99,32.4,20,0
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Skyseer Ghrent|r
    .turnin 39214 >>Turn in The Eye of Odyn
    .target Skyseer Ghrent
    .accept 40585 >>Accept Thus Begins the War
step
    #hidewindow
    #completewith The Eye of Odyn
    .goto 695,62.05,21.15,20 >>1
step
    #requires The Eye of Odyn
    .goto 695,59.75,13.38
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Skyseer Ghrent|r
    .turnin 39214 >>Turn in The Eye of Odyn
    .target Skyseer Ghrent
    .accept 40585 >>Accept Thus Begins the War
step
    .goto 695,59.22,13.43
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Scouting Map|r
    .complete 40585,1 --1/1 Assault Point Chosen
    .acceptmap 39718
    .accept 39718 >>Accept The Tranquil Forest
step
    .goto 695,59.77,13.44
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Skyseer Ghrent|r
    .turnin 40585 >>Turn in Thus Begins the War
    .target Skyseer Ghrent
-- step
--     .goto 695,56.16,27.13
--     >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Quartermaster Durnolf|r
--     .accept 44255 >>Accept Axe and You Shall Receive
--     .target Quartermaster Durnolf
--     .turnin 44255 >>Turn in Axe and You Shall Receive
step
    .goto 695,56.12,21.96,20,0
    .goto 695,58.97,34.45,20,0
    .goto 695,58.40,85.41
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Odyn|r
    .accept 42598 >>Accept Champions of Skyhold
    .target Odyn
step
    #completewith next
    #label Finna Bjornsdottir
    .goto 695,59.58,42.39,15,0
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Finna Bjornsdottir|r
    .turnin 42606 >>Turn in Champion: Finna Bjornsdottir
    .complete 42598,2 --1/1 Recruit Finna Bjornsdottir
    .target Finna Bjornsdottir
step
    #completewith Finna Bjornsdottir
    #hidewindow
    .goto 695,61.44,37.76,10 >>1
step
    #requires Finna Bjornsdottir
    #label Accept The Eye of Odyn
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Finna Bjornsdottir|r and |cRXP_FRIENDLY_Ragnvald Drakeborn|r.
    .turnin 42606 >>Turn in Champion: Finna Bjornsdottir
    .complete 42598,2 --1/1 Recruit Finna Bjornsdottir
    .goto 695,61.55,34.46
    .target +Finna Bjornsdottir
    .turnin 42605 >>Turn in Champion: Ragnvald Drakeborn
    .complete 42598,1 --1/1 Recruit Ragnvald Drakeborn
    .goto 695,61.24,33.78
    .target +Ragnvald Drakeborn
step
    .goto 695,58.37,24.88
    .gossipoption 44733 >>Talk to |cRXP_FRIENDLY_Aerylia|r
    .target Aerylia
]])

---Infinite Bazaar
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#name ad) Infinite Bazaar
#displayname |cFF00FF005|r - Infinite Bazaar|r
#next ae) First Zone



step
    #completewith Heroic World Tier
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
    .use 242617
-- step << Warrior/Mage/Horde Paladin/Rogue/Monk/Shaman/Hunter/Horde Priest
step
    .isQuestAvailable 91639
    .zoneskip 627,1
    .goto 627,72.07,40.6
    .cast 1233963 >>Click on the |cRXP_PICK_Portal|r.
step
    #label Meet Nostwin2
    #completewith next
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r
    .accept 91955 >>Accept Just Between Us
    .target Momentus
step
    #completewith Meet Nostwin2
    .goto 619,45.96,67.89
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nostwin|r |cRXP_WARN_twice|r.
    .home >>Set your Hearthstone to Dalaran
    .collect 254320,1 --Elixir of Remembered Sight
    .buy 254320,1 --Elixir of Remembered Sight
    .skipgossipid 135258
step
    #requires Meet Nostwin2
    .goto 619,45.83,68.00
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r
    .accept 91955 >>Accept Just Between Us
    .target Momentus
step
    .isQuestComplete 91955
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Momentus|r and |cRXP_FRIENDLY_Erus|r
    .turnin 91955 >>Turn in Just Between Us
    .goto 619,45.83,67.98
    .target Momentus
step
    .goto 619,45.86,68.00
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lidamorrutu|r 
    *|cRXP_WARN_You can skip this and do it later; completing it at level 80 with higher ilvl gives better gear, but since it’s a daily, you might not want to miss it|r.
    .daily 92855 >>Accept in Make Haste, Not Waste
    .dailyturnin 92855 >>Turn in Make Haste, Not Waste
    .xp <11,1
    .achievementComplete 42301,1
    .target Lidamorrutu
step
    #hidewindow
    #completewith next
    #label InfiniteChaosA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eternus|r
    .turnin 91437 >>Turn in Call for Participants
    .accept 91061 >>Accept Infinite Chaos
    .disablecheckbox
    .accept 91639 >>Accept Embrace Your Own Legend
    .disablecheckbox
    .target Eternus
step
    .zoneskip 619
    .zoneskip 627,1
    #completewith InfiniteChaosA
    .goto 627,72.06,40.49
    .cast 1233963 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal|r to the Infinite Bazaar
step
    #requires InfiniteChaosA
    .isOnQuest 91437
    .goto 619,45.61,68.46,25,0
    .goto 619,45.68,68.50
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eternus|r
    .turnin 91437 >>Turn in Call for Participants
    .accept 91639 >>Accept Embrace Your Own Legend
    .skipgossipid 1356t03
    .target Eternus
step
    .goto 619,45.61,68.46,25,0
    .goto 619,45.68,68.50
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eternus|r
    .accept 91639 >>Accept Embrace Your Own Legend
    .target Eternus
step <<!DemonHunter
    .goto 627,30.26,51.21
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eternus|r
    .accept 40519 >>Accept Legion: The Legion Returns << Alliance
    .accept 43926 >>Accept Legion: The Legion Returns << Horde
    .target Archivist Elysiana
    .skipgossipid 134831
    .skipgossipid 134865
step
    .goto 619,45.68,68.49
    .isQuestTurnedIn account,91721 
    .isQuestAvailable account,91722
    +|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eternus|r and select a quest based on your preference.
    .questcount <3,89540,91613,90100,90112,90113,89600,89679,90102,90103,89524,89590,89678,89541,89607,90114,89521,89539,89683,90109,89528,89543,89544,89545,89550,89553,89554,89556,89558,89597,92439,89465,89469,89476,89523,89527,89533,89538,89549,89552,89592,89594,89599,89601,89605,89680,90101,90108,90110,90111,89464,89466,89516,89518,89519,89522,89525,89526,89529,89530,89531,89532,89534,89535,89542,89546,89547,89548,89551,89555,89557,89591,89593,89595,89598,89602,89604,89606,89665,89676,89677,89682,90096,90098,90099,90115,91439,91441,91449,89517,89520,89536,89537,89644,89681,90097,91438,91443,91446,91612,91848,91849,89596,89603,89622,91440,91444,91445,91447,91448,92441,91847,92440,92442,89467,89468 >>Accept 1 of the 100 Quests.
    .target Eternus 
step
    .isQuestTurnedIn account,91722
    .goto 619,45.68,68.49
    +|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eternus|r and select a quest based on your preference.
    .questcount <4,89540,91613,90100,90112,90113,89600,89679,90102,90103,89524,89590,89678,89541,89607,90114,89521,89539,89683,90109,89528,89543,89544,89545,89550,89553,89554,89556,89558,89597,92439,89465,89469,89476,89523,89527,89533,89538,89549,89552,89592,89594,89599,89601,89605,89680,90101,90108,90110,90111,89464,89466,89516,89518,89519,89522,89525,89526,89529,89530,89531,89532,89534,89535,89542,89546,89547,89548,89551,89555,89557,89591,89593,89595,89598,89602,89604,89606,89665,89676,89677,89682,90096,90098,90099,90115,91439,91441,91449,89517,89520,89536,89537,89644,89681,90097,91438,91443,91446,91612,91848,91849,89596,89603,89622,91440,91444,91445,91447,91448,92441,91847,92440,92442,89467,89468 >>Accept 3 of the 100 Quests.
    .target Eternus 
step
    #completewith next
    #hidewindow
    #label Infinite Chaos
    .accept 91061 >>Accept Infinite Chaos
step
    #completewith Infinite Chaos
    .goto 619,45.68,68.50
    .gossipoption 135603 >>Talk to |cRXP_FRIENDLY_Eternus|r
    .target Eternus
step
    #requires Infinite Chaos
    #label Heroic World Tier
    .goto 619,45.57,68.48,20,0
    .goto 619,45.69,68.54
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Eternus|r
    .skipgossipid 135604
    .accept 91061 >>Accept Infinite Chaos
    .target Eternus
step
    .goto 619,45.57,68.48
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Console|r
    .complete 91061,2 --1/1 Use the Console of Infinite Chaos to enter the Heroic World Tier
step
    .cast 1257698 >>Use |T1528676:0|t[Elixir of Remembered Sight] to reveal herbs and ores on the minimap. Collect them when nearby to gain more Infinite Might and increase your overall power.
    .use 254320
    .aura 1257698
]])

---Azsuna 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#name ae) First Zone
#displayname |cFF00FF006|r - Azsuna|r
#next cb) Val'sharah Speedrun 2

step
    #completewith AzsunaSpeedrunY
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    .zoneskip 619,1
    .goto 619,45.71,67.46
    .zone 627 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Portal|r
step
    #completewith next
    #label Down to Azsuna
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r.
    .turnin 39718 >>Turn in Paradise Lost
    .accept 41220 >>Accept Down to Azsuna
    .disablecheckbox
    .target Archmage Khadgar
step
    #completewith Down to Azsuna
    .goto 619,45.57,68.48
    .cast 1241425 >>Use |T4571434:0|t[Temporal Retreat] to return to the Normal Tier. Consider enabling it again at level 20 or higher.
step
    #requires Down to Azsuna
    .goto 627,72.47,45.70
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r.
    .turnin 39718 >>Turn in Paradise Lost
    .accept 41220 >>Accept Down to Azsuna
    .disablecheckbox
    .target Archmage Khadgar
step
    #completewith Into the Fray
    +You can pick up an extra quest in the Broken Shore by flying into the demons in the sky only do this if it’s convenient.
step
    #include RestedXP Legion Remix\b) Behind Legion Lines@BehindLegionLinesA-BehindLegionLinesB
step
    .isQuestAvailable account,38316
    .goto 630,40.56,57.69
    .turnin 38316 >>Click on the |cRXP_PICK_Treasure Chest|r.
step
    #include RestedXP Legion Remix\b) Behind Legion Lines@BehindLegionLinesC-BehindLegionLinesD
step
    --BONUS OBJECTIVE
    #title Don't complete it |cFFFCDC00(See Note)|r
    .xp >80,1
    #loop
    .goto 630,39.05,48.22,40,0
    .goto 630,36.90,48.19,35,0
    .goto 630,38.66,60.14,35,0
    .goto 630,40.24,54.23,35,0
    >>Kill the |cRXP_ENEMY_Demons|r in the area.
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Legion Portals|r.
    *|cRXP_WARN_NOTE:|r We prepare this Bonus Objective for level 70 (you get a 200% xp buff when reach level 70).
    .complete 36811,1,75 --Lead the fight against the Legion (100%)
step
    #include RestedXP Legion Remix\b) Behind Legion Lines@BehindLegionLinesE-BehindLegionLinesZ
step
    .goto 630,43.55,43.42
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Khadgar|r.
    .accept 38443 >>Accept Journey to the Repose
    .target Archmage Khadgar
step
    .isOnQuest 38443
    .isQuestAvailable account,37713
    .goto 630,44.47,39.47
    .turnin 37713 >>Click on the |cRXP_PICK_Treasure Chest|r.
step
    .isOnQuest 38443
    .isQuestAvailable account,37831
    .goto 630,49.65,34.47
    .turnin 37831 >>Click on the |cRXP_PICK_Small Treasure Chest|r.
step
    #include RestedXP Legion Remix\b) Defending Azurewing Repose@DefendingAzurewingReposeAA-DefendingAzurewingReposeAB
step
    .isOnQuest 37853
    .isQuestAvailable account,42289
    .goto 630,51.52,24.33
    .turnin 42289 >>Click on the |cRXP_PICK_Treasure Chest|r.
step
    #include RestedXP Legion Remix\b) Defending Azurewing Repose@DefendingAzurewingReposeAC-DefendingAzurewingReposeB
step
    #include RestedXP Legion Remix\b) Defending Azurewing Repose@DefendingAzurewingReposeC-DefendingAzurewingReposeD
step
    #title |cFFFCDC00In the Cave|r
    .isOnQuest 37959
    .isQuestAvailable account,44104
    .goto 630,53.61,18.14
    .turnin 44104 >>Click on the |cRXP_PICK_Treasure Chest|r.
step
    #title |cFFFCDC00Top of the Tower|r
    .isOnQuest 37959
    .isQuestAvailable account,40711
    .goto 630,55.63,18.51
    .turnin 40711 >>Click on the |cRXP_PICK_Treasure Chest|r.
step
    #include RestedXP Legion Remix\b) Defending Azurewing Repose@DefendingAzurewingReposeE-DefendingAzurewingReposeF
step
    #title |cFFFCDC00Top of the Tower|r
    .isOnQuest 37862
    .isQuestAvailable account,37980
    .goto 630,58.38,12.27
    .turnin 37980 >>Click on the |cRXP_PICK_Treasure Chest|r.
step
    #include RestedXP Legion Remix\b) Defending Azurewing Repose@DefendingAzurewingReposeG-DefendingAzurewingReposeZ
step
    #include RestedXP Legion Remix\b) Azsuna versus Azshara@AzsunaVersusAzsharaA-AzsunaVersusAzsharaB
step
    .goto 630,47.05,41.48
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Irisse|r
    .accept 37492 >>Accept A Rather Long Walk
    .target Lady Irisse
step
    .goto 630,47.10,41.40
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Magister Garuhod|r
    .accept 37728 >>Accept Presentation is Everything
    .accept 37727 >>Accept The Magister of Mixology
    .target Magister Garuhod
step
    #loop
    .goto 630,50.17,39.68,30,0
    .goto 630,49.63,36.25,30,0
    .goto 630,50.87,33.55,45,0
    >>Kill |cRXP_ENEMY_Salteye Murlocs|r. Loot them for the |T442733:0|t[|cRXP_LOOT_Pilfered Night Elf Bones|r] and |T461806:0|t[|cRXP_LOOT_Okuna's Message|r]
    .complete 37257,1 --55/55 Pilfered Night Elf Bone
    .accept 38407 >>Accept Bottled Up
    .mob Salteye Spearguard
    .mob Salteye Beastfeeder
    .mob Salteye Hookblade
    .mob Salteye Tide-Shaman
    .mob Salteye Clam Vanquisher
step
    #include RestedXP Legion Remix\b) Crumbled Palace Cocktails@CrumbledPalaceCocktailsA-CrumbledPalaceCocktailsB
step
    .goto 630,51.71,36.56
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_FRIENDLY_Elder Aldryth|r
    .complete 37492,1 --1/1 Elder Aldryth found
    .target Elder Aldryth
step
    .isOnQuest 37492
    .isQuestAvailable account,42287
    .goto 630,54.40,36.35
    .turnin 42287 >>Click on the |cRXP_PICK_Small Treasure Chest|r.
step
    .isOnQuest 37492
    .isQuestAvailable account,37596
    .goto 630,53.03,37.27
    .turnin 37596 >>Click on the |cRXP_PICK_Small Treasure Chest|r.
step
    #label A Rather Long Walk
    .goto 630,47.05,41.48
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Irisse|r
    .turnin 38407 >>Turn in Bottled Up
    .turnin 37492 >>Turn in A Rather Long Walk
    .accept 37496 >>Accept Infiltrating Shipwreck Arena
    .target Lady Irisse
step
    .goto 630,47.10,41.41
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Magister Garuhod|r
    .turnin 37727 >>Turn in The Magister of Mixology
    .turnin 37728 >>Turn in Presentation is Everything
    .target Magister Garuhod
step
    #include RestedXP Legion Remix\b) Azsuna versus Azshara@AzsunaVersusAzsharaC-AzsunaVersusAzsharaD
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kallistia Starlance|r and |cRXP_FRIENDLY_Olothil Starlance|r
    .accept 42692 >>Accept Children of Nar'thalas
    .goto 630,53.28,45.31
    .target +Kallistia Starlance
    .accept 42693 >>Accept You Never Know Until You Scry
    .goto 630,53.39,45.43
    .target +Olothil Starlance
step
    .isOnQuest 37496
    .isQuestAvailable account,37828
    .goto 630,49.38,45.34
    .turnin 37828 >>Click on the |cRXP_PICK_Treasure Chest|r.
step
    #include RestedXP Legion Remix\b) Against Giants@AgainstGiantsA-AgainstGiantsAB
step
    #include RestedXP Legion Remix\b) Against Giants@AgainstGiantsAC-AgainstGiantsB
step
    #completewith OceanusCaveTreasureChestsA
    >>Use the |T1030902:0|t[|Pile of Weapons] near |cRXP_FRIENDLY_Shipwrecked Captives|r
    .complete 37565,1 --25/25 Shipwrecked Captives armed
    .use 118330
step
    .isOnQuest 37565
    .isQuestAvailable account,37649
    .goto 632,69.54,48.02
    .turnin 37649 >>Click on the |cRXP_PICK_Glimmering Treasure Chest|r.
step
    #label OceanusCaveTreasureChestsA
    .isOnQuest 37565
    .isQuestAvailable account,42291
    .goto 632,45.35,66.85
    .turnin 42291 >>Click on the |cRXP_PICK_Small Treasure Chest|r.
step
    #include RestedXP Legion Remix\b) Against Giants@AgainstGiantsC-AgainstGiantsD
step
    .isQuestAvailable account,37829
    .goto 630,53.16,64.44
    .turnin 37829 >>Click on the |cRXP_PICK_Small Treasure Chest|r.
step
    .goto 630,51.93,61.78
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Okuna Longtusk|r
    .turnin 37566 >>Turn in The Prince is Going Down
    .target Okuna Longtusk
step
    .isQuestTurnedIn 37538
    --BONUS OBJECTIVE
    #title Don't complete it |cFFFCDC00(See Note)|r
    .xp >80,1
    #loop
    .goto 630,50.57,60.91,25,0
    .goto 630,47.95,59.20,25,0
    .goto 630,44.36,56,47,25,0
    .goto 630,45.18,55.53,25,0
    .goto 632,27.02,54.02,25,0
    .goto 632,34.43,37.92,25,0
    .goto 632,54.97,62.45,35,0
    .goto 632,72.48,75.05,25,0
    >>Kill the |cRXP_ENEMY_Hatecoil Naga|r and the |cRXP_ENEMY_Cave Skrogs|r (20% progress).
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Skrog Weapons|r and |cRXP_PICK_Prince's Plunder|r.
    *|cRXP_WARN_NOTE:|r We prepare this Bonus Objective for level 70 (you get a 200% xp buff when reach level 70).
    .complete 37495,1,70 --Plunder Oceanus Cove (100%)
    .mob Hatecoil Slavemaster
step
    .goto 630,56.60,59.59
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mr. Shackle|r.
    .accept 37654 >>Accept Maritime Law
    .accept 37657 >>Accept Making the World Safe for Profit
    .target Mr. Shackle
step
    .convertquest 42268,42220 << Alliance
    .goto 630,57.90,58.79
    >>|cRXP_WARN_Follow the arrow|r. The quest will pop up at the waypoint location
    .accept 42268 >>Accept Shipwrecked Sailors << Horde
    .accept 42220 >>Accept Shipwrecked Sailors << Alliance
step
    .isQuestAvailable account,38365
    .goto 630,55.87,56.85
    .turnin 38365 >>Click on the |cRXP_PICK_Disputed Chest|r.
step
    .isQuestAvailable account,42272
    .goto 630,59.88,63.19
    .turnin 42272 >>Click on the |cRXP_PICK_Small Treasure Chest|r.
step
    .isQuestAvailable account,42273
    .goto 630,62.37,58.41
    .turnin 42273 >>Click on the |cRXP_PICK_Small Treasure Chest|r.
step
    #include RestedXP Legion Remix\b) Mak'rana and the Fate of the Queen's Reprisal@MakranaFateQueenReprisalA-MakranaFateQueenReprisalB
step << Horde
    .achievementIncomplete 42317,0
    #completewith next
    #label FateOfTheQueensReprisalCustomA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Advisor Stillwater|r
    .turnin 42244 >>Turn in Fate of the Queen's Reprisal
    .target Advisor Stillwater
step << Horde
    .achievementIncomplete 42317,0
    #completewith FateOfTheQueensReprisalCustomA
    #title |cFFFCDC00Enter the sanctum in Dalaran (See Note)|r
    *|cRXP_WARN_NOTE:|r We have to turn this quest in to get the 10% xp bonus at the end of the campaign.
    .goto 627,58.45,20.62,10 >>|cRXP_WARN_Enter the sanctum|r
step << Horde
    .achievementIncomplete 42317,0
    #requires FateOfTheQueensReprisalCustomA
    .goto 627,61.14,16.94
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Advisor Stillwater|r
    .turnin 42244 >>Turn in Fate of the Queen's Reprisal
    .target Advisor Stillwater
step << Alliance
    .achievementIncomplete 42317,0
    #completewith next
    #label FateOfTheQueensReprisalCustomB
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Surtees|r
    .turnin 40794 >>Turn in Fate of the Queen's Reprisal
    .target Lieutenant Surtees
step << Alliance
    .achievementIncomplete 42317,0
    #completewith FateOfTheQueensReprisalCustomB
    #title |cFFFCDC00Enter the sanctum in Dalaran (See Note)|r
    *|cRXP_WARN_NOTE:|r We have to turn this quest in to get the 10% xp bonus at the end of the campaign.
    .goto 627,34.48,66.51,15 >>|cRXP_WARN_Enter the enclave|r
step << Alliance
    .achievementIncomplete 42317,0
    #requires FateOfTheQueensReprisalCustomB
    .goto 627,29.40,75.66
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Surtees|r
    .turnin 40794 >>Turn in Fate of the Queen's Reprisal
    .target Lieutenant Surtees
step
    #include RestedXP Legion Remix\b) Mak'rana and the Fate of the Queen's Reprisal@MakranaFateQueenReprisalC-MakranaFateQueenReprisalZ
step
    .goto 630,55.74,48.42
    >>Kill |cRXP_ENEMY_Athissa|r |cRXP_WARN_inside the building.|r
    .complete 37486,1 --1/1 Athissa defeated
    .mob Athissa
step
    #loop
    .goto 630,55.90,43.94,30,0
    .goto 630,55.52,47.24,30,0
    .goto 630,52.94,43.89,35,0
    >>Kill the |cRXP_ENEMY_Hatecoil Naga|r and the |cRXP_ENEMY_Naga Brute|r. Loot them for the |T1028990:0|t[|cRXP_LOOT_Hatecoil Glyptics|r].
    .complete 42693,1 --3/3 Hatecoil Glyptic
    .mob Hatecoil Stormcaller
    .mob Hatecoil Riptail
    .mob Naga Brute
step
    .isOnQuest 42693
    .isQuestAvailable account,42282
    .goto 630,53.62,44.15
    .turnin 42282 >>Click on the |cRXP_PICK_Small Treasure Chest|r.
step
    .isOnQuest 42693
    .isQuestAvailable account,42283
    .goto 630,53.49,45.46
    .turnin 42283 >>Click on the |cRXP_PICK_Small Treasure Chest|r.
step
    #include RestedXP Legion Remix\b) Kirin Tor Reconnaissance@KirinTorReconnaissanceB-KirinTorReconnaissanceY
step
    --BONUS OBJECTIVE
    #title Don't complete it (See Note)
    .xp >80,1
    #loop
    .goto 630,55.18,45.72,35,0
    .goto 630,55.96,43.01,35,0
    .goto 630,53.81,40.48,35,0
    .goto 630,53.13,44.79,40,0
    >>Kill the |cRXP_ENEMY_Hatecoil forces|r.
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_FRIENDLY_Bound Citizens|r.
    *|cRXP_WARN_NOTE:|r We prepare this Bonus Objective for level 70 (you get a 200% xp buff when reach level 70).
    .complete 37466,1,75 --Defend against the Hatecoil (100%)
    .mob Hatecoil Riptail
    .mob Hatecoil Harpooner
    .mob Hatecoil Stormcaller
    .mob Brawlgoth
    .target Bound Citizen
step
    .goto 630,53.33,45.41
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Olothil Starlance|r
    .turnin 42694 >>Turn in Back from the Dead
    .target Olothil Starlance
step
    #include RestedXP Legion Remix\b) Azsuna versus Azshara@AzsunaVersusAzsharaF-AzsunaVersusAzsharaG
step
    .isOnQuest 37678
    .isQuestAvailable account,42284
    .goto 631,62.02,83.86
    .turnin 42284 >>Click on the |cRXP_PICK_Small Treasure Chest|r.
step
    #include RestedXP Legion Remix\b) Azsuna versus Azshara@AzsunaVersusAzsharaH-AzsunaVersusAzsharaI
step
    .isOnQuest 37469
    .isQuestAvailable account,42285
    .goto 631,71.68,21.74
    .turnin 42285 >>Click on the |cRXP_PICK_Small Treasure Chest|r.
step
    #include RestedXP Legion Remix\b) Azsuna versus Azshara@AzsunaVersusAzsharaJ-AzsunaVersusAzsharaZ
step
    .isQuestAvailable account,37830
    .goto 630,58.36,43.78
    .turnin 37830 >>Click on the |cRXP_PICK_Glimmering Treasure Chest|r.
step
    .isQuestAvailable account,42294
    .goto 630,62.80,44.79
    .turnin 42294 >>Click on the |cRXP_PICK_Small Treasure Chest|r.
step
    .isQuestAvailable account,40751
    .goto 630,66.06,43.45
    .turnin 40751 >>Click on the |cRXP_PICK_Small Treasure Chest|r.
step
    #label AzsunaSpeedrunY
    .isQuestAvailable account,42293
    .goto 630,63.65,39.17
    .turnin 42293 >>Click on the |cRXP_PICK_Small Treasure Chest|r.
step
    --BONUS OBJECTIVE
    #title Don't complete it (See Note)
    .xp >80,1
    #loop
    .goto 630,64.72,40.07,35,0
    .goto 630,62.49,44.98,45,0
    .goto 630,58.62,40.19,45,0
    .goto 630,62.44,36.43,45,0
    >>Kill the |cRXP_PICK_Hatecoil Naga|r and |cRXP_PICK_Hatecoil Skrog|r. Destroy the |cRXP_PICK_Murloc Hatcheries|r.
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_PICK_Coral Tridents|r to get an ExtraActionButton that helps you kill the |cRXP_PICK_Hatecoil Skrog|r
    *|cRXP_WARN_NOTE:|r We prepare this Bonus Objective for level 70 (you get a 200% xp buff when reach level 70).
    .complete 37779,1,70 --Disrupt the Hatecoil Warcamp (100%)
    .mob Hatecoil Skrog
    .mob Hatecoil Spitespeaker
    .mob Hatecoil Fathom-Stalker
    .mob Subjugated Murloc
]])

---Azsuna 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#chapter
#subgroup |cFFFCDC00(10-80)|r Speedrun Route
#name ae) First Zone 2
#displayname |cFF00FF006|r - Azsuna|r
#next cb) Val'sharah Speedrun 2

step
    #completewith Let's Make A DealZ
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #include RestedXP Legion Remix\ad) Infinite Bazaar
step
    #include b) Felblaze Ingress
step
    --BONUS OBJECTIVE
    #title Don't complete it (See Note)
    .xp >80,1
    #completewith KirinTorReconnaissanceZ
    >>Kill the |cRXP_ENEMY_Hatecoil forces|r.
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_FRIENDLY_Bound Citizens|r.
    *|cRXP_WARN_NOTE:|r We prepare this Bonus Objective for level 70 (you get a 200% xp buff when reach level 70).
    .complete 37466,1,75 --Defend against the Hatecoil (100%)
    .mob Hatecoil Riptail
    .mob Hatecoil Harpooner
    .mob Hatecoil Stormcaller
    .mob Brawlgoth
    .target Bound Citizen
step
    #include b) Kirin Tor Reconnaissance@KirinTorReconnaissanceB-Back from the Dead
step
    .goto 630,54.96,38.66
    >>Kill the |cRXP_ENEMY_Salteye Murlocs|r
    .complete 42694,2 --1/1 Search near the Academy
    .accept 38407 >>Accept Bottled Up
    .mob Salteye Hookblade
    .mob Salteye Shoresprinter
    .mob Salteye Tide-Shaman
step
    #label Back from the Dead
    .goto 630,53.33,45.41
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Olothil Starlance|r
    .turnin 42694 >>Turn in Back from the Dead
    .target Olothil Starlance
step
    .zoneskip 630,1
    --BONUS OBJECTIVE
    #title Don't complete it (See Note)
    .xp >80,1
    #loop
    .goto 630,55.18,45.72,35,0
    .goto 630,55.96,43.01,35,0
    .goto 630,53.81,40.48,35,0
    .goto 630,53.13,44.79,40,0
    >>Kill the |cRXP_ENEMY_Hatecoil forces|r.
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_FRIENDLY_Bound Citizens|r.
    *|cRXP_WARN_NOTE:|r We prepare this Bonus Objective for level 70 (you get a 200% xp buff when reach level 70).
    .complete 37466,1,75 --Defend against the Hatecoil (100%)
    .mob Hatecoil Riptail
    .mob Hatecoil Harpooner
    .mob Hatecoil Stormcaller
    .mob Brawlgoth
    .target Bound Citizen
step
    .goto 630,47.05,41.48
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Irisse|r
    .turnin 38407 >>Turn in Bottled Up
    .accept 37496 >>Accept Infiltrating Shipwreck Arena
    .target Lady Irisse
step
    #completewith Making the World Safe for ProfitZZ
    .isQuestTurnedIn 37538
    --BONUS OBJECTIVE
    #title Don't complete it |cFFFCDC00(See Note)|r
    .xp >80,1
    >>Kill the |cRXP_ENEMY_Hatecoil Naga|r and the |cRXP_ENEMY_Cave Skrogs|r (20% progress).
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Objects|r.
    *|cRXP_WARN_NOTE:|r We prepare this Bonus Objective for level 70 (you get a 200% xp buff when reach level 70).
    .complete 37495,1,70 --Plunder Oceanus Cove (100%)
    .mob Hatecoil Slavemaster
step
    #include RestedXP Legion Remix\b) Against Giants@Boss WhalebellyZ-AgainstGiantsB
step
    #completewith next
    >>Use the |T1030902:0|t[|Pile of Weapons] near |cRXP_FRIENDLY_Shipwrecked Captives|r
    .complete 37565,1 --25/25 Shipwrecked Captives armed
    .use 118330
step
    .goto 632,44.11,31.58,30,0
    .goto 632,61.58,44.74,30,0
    .goto 632,58.36,57.69,30,0
    .goto 632,62.43,69.11,30,0
    .goto 632,74.03,86.4,30,0
    .goto 630,50.34,60.48,30,0
    .goto 630,50.34,61.01
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Seska Seafang|r
    .accept 38857 >>Accept A Favor for Mr. Shackle
    .target Seska Seafang
step
    #completewith Grace the Green rescued
    >>Use the |T1030902:0|t[|Pile of Weapons] near |cRXP_FRIENDLY_Shipwrecked Captives|r
    .complete 37565,1 --25/25 Shipwrecked Captives armed
    .use 118330
step
    .goto 630,46.26,59.01
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Cage|r
    .complete 38857,2 --1/1 Gentle Rosh rescued
step
    .goto 630,48.91,62.95
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Cage|r
    .complete 38857,1 --1/1 Cleave Thunderhill rescued
step
    #label Grace the Green rescued
    .goto 630,51.38,60.99
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Cage|r
    .complete 38857,3 --1/1 Grace the Green rescued
step
    #completewith next
    .isQuestTurnedIn 37538
    --BONUS OBJECTIVE
    #title Don't complete it |cFFFCDC00(See Note)|r
    .xp >80,1
    >>Kill the |cRXP_ENEMY_Hatecoil Naga|r and the |cRXP_ENEMY_Cave Skrogs|r (20% progress).
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Objects|r.
    *|cRXP_WARN_NOTE:|r We prepare this Bonus Objective for level 70 (you get a 200% xp buff when reach level 70).
    .complete 37495,1,70 --Plunder Oceanus Cove (100%)
    .mob Hatecoil Slavemaster
step
    #loop
    .goto 630,50.57,60.96,35,0
    .goto 630,49.57,61.96,35,0
    .goto 630,47.95,62.4,35,0
    .goto 630,47.82,60.05,35,0
    .goto 630,47.15,58.35,35,0
    .goto 630,44.33,56.75,35,0
    .goto 630,45.87,59.6,35,0
    >>Use the |T1030902:0|t[|Pile of Weapons] near |cRXP_FRIENDLY_Shipwrecked Captives|r
    .complete 37565,1 --25/25 Shipwrecked Captives armed
    .use 118330
step
    .goto 630,53.44,62.95
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Okuna Longtusk|r
    .turnin 37565 >>Turn in The Right Weapon for the Job
    .accept 37566 >>Accept The Prince is Going Down
    .target Okuna Longtusk
step
    .goto 630,53.66,64.06
    >>Kill |cRXP_ENEMY_Prince Oceanus|r
    .complete 37566,1 --1/1 Prince Oceanus slain
    .mob Prince Oceanus
step
    Making the World Safe for ProfitZZ
    .goto 630,51.93,61.78
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Okuna Longtusk|r
    .turnin 37566 >>Turn in The Prince is Going Down
    .target Okuna Longtusk
 step
    .isQuestTurnedIn 37538
    --BONUS OBJECTIVE
    .zoneskip 630,1
    #title Don't complete it |cFFFCDC00(See Note)|r
    .xp >80,1
    #loop
    .goto 630,50.57,60.91,25,0
    .goto 630,47.95,59.20,25,0
    .goto 630,44.36,56,47,25,0
    .goto 630,45.18,55.53,25,0
    .goto 632,27.02,54.02,25,0
    .goto 632,34.43,37.92,25,0
    .goto 632,54.97,62.45,35,0
    .goto 632,72.48,75.05,25,0
    >>Kill the |cRXP_ENEMY_Hatecoil Naga|r and the |cRXP_ENEMY_Cave Skrogs|r (20% progress).
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Skrog Weapons|r and |cRXP_PICK_Prince's Plunder|r.
    *|cRXP_WARN_NOTE:|r We prepare this Bonus Objective for level 70 (you get a 200% xp buff when reach level 70).
    .complete 37495,1,70 --Plunder Oceanus Cove (100%)
    .mob Hatecoil Slavemaster
step
    .goto 630,56.61,59.60
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mr. Shackle|r
    .turnin 38857 >>Turn in A Favor for Mr. Shackle
    .accept 37654 >>Accept Maritime Law
    .accept 37657 >>Accept Making the World Safe for Profit
    .target Mr. Shackle
step
    #include RestedXP Legion Remix\b) Mak'rana and the Fate of the Queen's Reprisal@MakranaFateQueenReprisalAA-Making the World Safe for ProfitZ
step
    #loop
    .goto 630,61.13,50.71,20,0
    .goto 630,62.44,51.44,20,0
    .goto 630,63.48,51.32,20,0
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Daglop|r
    .accept 38460 >>Accept Let's Make A Deal
    .target Daglop
step
    #label Let's Make A DealZ
    #loop
    .goto 630,61.13,50.71,20,0
    .goto 630,62.44,51.44,20,0
    .goto 630,63.48,51.32,20,0
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Daglop|r
    .complete 38460,1 --1/1 Daglop's Contract Signed
    .target Daglop
    .skipgossipid 44158
step
    #loop
    .goto 630,61.13,50.71,20,0
    .goto 630,62.44,51.44,20,0
    .goto 630,63.48,51.32,20,0
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Daglop|r
    .turnin 38460 >>Turn in Let's Make A Deal
    .accept 38232 >>Accept Minion! Kill Them!
    .target Daglop
]])

-- ======================================
-- ==============  AZSUNA  ==============
-- ======================================

--Behind Legion Lines
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name b) Behind Legion Lines
#displayname |cFF00CCFF1|r - Behind Legion Lines
#internal

step
    #completewith BehindLegionLinesZ
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    .goto 627,72.47,45.70
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r.
    .turnin 39718 >>Turn in Paradise Lost
    .accept 41220 >>Accept Down to Azsuna
    .target Archmage Khadgar
step
    #label BehindLegionLinesA

    .goto 627,72.47,45.70
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r.
    .complete 41220,1 --1/1 Fly down with Khadgar
    .timer 83,Flight Duration
    .target Archmage Khadgar
    .skipgossipid 42697
    .skipgossipid 42698
step
    .isOnQuest 41220
    #optional
    .goto 630,45.10,42.91
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r.
    .turnin 41220 >>Turn in Down to Azsuna
    .accept 38834 >>Accept Into the Fray
    .target Archmage Khadgar
step
    #label Into the Fray
    .goto 630,45.10,42.91
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r.
    .accept 38834 >>Accept Into the Fray
    .target Archmage Khadgar
step
    .goto 630,43.56,43.46
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r.
    .turnin 38834 >>Turn in Into the Fray
    .target Kayn Sunfury
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Allari the Souleater|r and |cRXP_FRIENDLY_Jace Darkweaver|r.
    .accept 37653 >>Accept Demon Souls
    .goto 630,43.28,43.16
    .accept 37658 >>Accept Reignite the Wards
    .goto 630,43.15,43.60
    .target Allari the Souleater
    .target Jace Darkweaver
step
    #completewith NightborneReignitetheWards
    >>Kill the |cRXP_ENEMY_demons|r in the area. Use the |T134082:0|t[Soul Gem] next to their corpses to trap their souls.
    .use 122100
    .complete 37653,1 --8/8 Demon souls trapped
step
    #title North Ward
    >>Click on the |cRXP_PICK_Demon Ward|r.
    .goto 630,42.18,43.30
    .complete 37658,3 --1/1 North Ward reignited
step
    #title West Ward
    >>Click on the |cRXP_PICK_Demon Ward|r.
    .goto 630,41.84,44.93
    .complete 37658,2 --1/1 West Ward reignited
step
    #label NightborneReignitetheWards
    #title South Ward
    >>Click on the |cRXP_PICK_Demon Ward|r.
    .goto 630,42.38,46.47
    .complete 37658,1 --1/1 South Ward reignited
step
    >>Kill the |cRXP_ENEMY_demons|r in the area. Use the |T134082:0|t[Soul Gem] next to their corpses to trap their souls.
    .goto 630,41.96,44.58
    .use 122100
    .complete 37653,1 --8/8 Demon souls trapped
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Jace Darkweaver|r and |cRXP_FRIENDLY_Allari the Souleater|r.
    .turnin 37658 >>Turn in Reignite the Wards
    .goto 630,43.15,43.60
    .turnin 37653 >>Turn in Demon Souls
    .accept 37660 >>Accept The Scythe of Souls
    .timer 15,Allari RP
    .goto 630,43.28,43.16
    .target Jace Darkweaver
    .target Allari the Souleater
step
    .goto 630,44.38,44.64
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tWait for the RP. Talk to |cRXP_FRIENDLY_Allari the Souleater|r.
    .complete 37660,1 --1/1 Speak with Allari
    .target Allari the Souleater
    .skipgossip 90403,1
step
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Soul Gem|r.
    .complete 37660,2 --1/1 First demon soul released
    .goto 630,44.57,44.72
    .timer 11,Allari RP
    .complete 37660,3 --1/1 First demon soul compelled
    .goto 630,44.23,44.86
step
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Soul Gem|r.
    .complete 37660,4 --1/1 Second demon soul released
    .goto 630,44.23,44.86
    .timer 21,Allari RP
    .complete 37660,5 --1/1 Second demon soul compelled
    .goto 630,44.41,44.71
step
    .goto 630,44.41,44.71
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Soul Gem|r.
    .complete 37660,6 --1/1 Soul Gem entered
step
    >>Kill |cRXP_ENEMY_Questioner Arev'naal|r.
    .goto 630,44.43,44.78
    .complete 37660,7 --1/1 Arev'naal compelled
    .mob Questioner Arev'naal
step
    >>Fly back to |cRXP_FRIENDLY_Allari|r.
    .goto 630,43.29,43.16
    .complete 37660,9 --1/1 Meet back up with Allari
    .target Allari the Souleater
step
    .goto 630,43.29,43.16
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Allari the Souleater|r.
    .turnin 37660 >>Turn in The Scythe of Souls
    .target Allari the Souleater
step
    .goto 630,43.55,43.46
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r.
    .accept 36920 >>Accept From Within
    .target Kayn Sunfury
step
    .goto 630,41.24,50.51
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kor'vas Bloodthorn|r.
    .turnin 36920 >>Turn in From Within
    .accept 37450 >>Accept Saving Stellagosa
    .accept 37656 >>Accept Fel Machinations
    .target Kor'vas Bloodthorn
step
    #title Demon Hunter freed 1/6
    .goto 630,39.04,47.60
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Soul Harvester|r.
    .complete 37656,1,1 --1/6 Demon Hunter freed
step
    #title Demon Hunter freed 2/6
    .goto 630,39.29,46.52
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Soul Harvester|r.
    .complete 37656,1,2 --2/6 Demon Hunter freed
step
    #title Demon Hunter freed 3/6
    .goto 630,37.89,46.63
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Soul Harvester|r.
    .complete 37656,1,3 --3/6 Demon Hunter freed
-- TODO: Add cave waypoint
step
    #title Demon Hunter freed 4/6
    .goto 630,38.25,49.14
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Soul Harvester|r.
    .complete 37656,1,4 --4/6 Demon Hunter freed
step
    #title Demon Hunter freed 5/6
    .goto 630,37.15,48.71
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Soul Harvester|r.
    .complete 37656,1,5 --5/6 Demon Hunter freed
step
    #title Demon Hunter freed 6/6
    .goto 630,37.80,49.79
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Soul Harvester|r.
    .complete 37656,1 --6/6 Demon Hunter freed
step
    .goto 630,37.87,57.85
    >>Fly to |cRXP_FRIENDLY_Stellagosa|r
    .complete 37450,1 --1/1 Find Stellagosa
step
    #label BehindLegionLinesB
    .goto 630,40.54,56.37
    >>Kill |cRXP_ENEMY_Overseer Lykill|r. Loot him for |T134236:0|t[|cRXP_LOOT_Lykill's Key|r].
    .complete 37450,2 --1/1 Lykill's Key
    .mob Overseer Lykill
step
    #label BehindLegionLinesC
    #title Chains unlocked 1/3
    .goto 630,38.25,57.61
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Fel Lock|r.
    .complete 37450,3,1 --1/3 Chains unlocked
step
    #title Chains unlocked 2/3
    .goto 630,38.01,58.36
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Fel Lock|r.
    .complete 37450,3,2 --2/3 Chains unlocked
step
    #label ChainsUnlockedA
    #title Chains unlocked 3/3
    .goto 630,37.67,57.57
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Fel Lock|r.
    .complete 37450,3 --3/3 Chains unlocked
step
    #label BehindLegionLinesD
    .goto 630,37.85,57.90
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kor'vas Bloodthorn|r next to you.
    .turnin 37450 >>Turn in Saving Stellagosa
    .turnin 37656 >>Turn in Fel Machinations
    .accept 37449 >>Accept Dark Revelations
    .target Kor'vas Bloodthorn
step
    #label BehindLegionLinesE
    >>Wait for the RP. Kill |cRXP_ENEMY_Nightglaive the Traitor|r.
    .goto 630,35.46,52.96
    .complete 37449,1 --1/1 Nightglaive the Traitor slain
    .mob Nightglaive the Traitor
step
    >>|cRXP_WARN_Follow the arrow back to the Illidari Stand|r
    .goto 630,43.56,43.47
    .complete 37449,3 --1/1 Meet back at Illidari Stand
step
    #label BehindLegionLinesZ
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kayn Sunfury|r.
    .turnin 37449 >>Turn in Dark Revelations
    .goto 630,43.56,43.46
    .target Kayn Sunfury
]])

--Defending Azurewing Repose
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name b) Defending Azurewing Repose
#displayname |cFF00CCFF2|r - Defending Azurewing Repose
#internal

step
    #completewith DefendingAzurewingReposeZ
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #label DefendingAzurewingReposeA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Khadgar|r.
    .accept 38443 >>Accept Journey to the Repose
    .goto 630,43.55,43.42
    .target Archmage Khadgar
step
    #label DefendingAzurewingReposeAA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r in the Azurewing Repose.
    .goto 630,47.93,27.19
    .turnin 38443 >>Turn in Journey to the Repose
    .accept 37853 >>Accept The Death of the Eldest
    .target Archmage Khadgar
step
    #completewith next
    #label CracklingLeywormCoreA
    >>Kill |cRXP_ENEMY_Burrowing Leyworms|r. Loot them for their [|cRXP_LOOT_Core|r].
    .complete 37853,1 --6/6 Crackling Leyworm Core
    .mob Burrowing Leyworm
step
    #completewith CracklingLeywormCoreA
    .goto 630,48.37,21.96,40 >>Enter the Leyhollow cave
step
    #requires CracklingLeywormCoreA
    #label DefendingAzurewingReposeAB
    >>Kill |cRXP_ENEMY_Burrowing Leyworms|r. Loot them for the |T133255:0|t[|cRXP_LOOT_Crackling Leyworm Core|r].
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Exposed Ley Crystals|r.
    #loop
    .goto 630,49.58,21.41,30,0
    .goto 630,50.95,24.45,30,0
    .goto 630,51.13,21.88,30,0
    .goto 630,50.60,20.17,30,0
    .complete 37853,1 --6/6 Crackling Leyworm Core
    .mob Burrowing Leyworm
step
    #completewith next
    #label DefendingAzurewingReposeAC
    >>Use your ExtraActionButton to the the crystals into the pool
    .complete 37853,2 --1/1 Throw crystals into Senegos's pool
step
    #completewith DefendingAzurewingReposeAC
    .goto 630,48.37,21.96,30,0
    .goto 630,47.89,24.84,45 >>Leave the Leyhollow cave
step
    #requires DefendingAzurewingReposeAC
    >>Use your |T133255:0|t[|cRXP_WARN_ExtraActionButton|r] to the the crystals into the pool
    .goto 630,47.91,26.88
    .complete 37853,2 --1/1 Throw crystals into Senegos's pool
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Stellagosa|r and |cRXP_FRIENDLY_Emmigosa|r.
    .turnin 37853 >>Turn in The Death of the Eldest
    .goto 630,47.96,27.15
    .accept 37991 >>Accept Agapanthus
    .goto 630,48.00,27.13
    .target Stellagosa
    .target Emmigosa
step
    >>Fly to |cRXP_FRIENDLY_Agapanthus|r.
    .goto 630,48.88,26.42
    .complete 37991,1 --1/1 Investigate the visitors
step
    .goto 630,48.91,26.40
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Agapanthus|r.
    .turnin 37991 >>Turn in Agapanthus
    .accept 42271 >>Accept Their Dying Breaths
    .target Agapanthus
step
    #loop
    .goto 630,49.48,25.87,12,0
    .goto 630,49.96,25.59,12,0
    .goto 630,49.83,25.27,12,0
    .goto 630,49.49,25.29,12,0
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Cracked Ley Crystal|r.
    .complete 42271,1 --4/4 Cracked Ley Crystal
step
    .goto 630,48.86,26.46
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_FRIENDLY_Mana Drained Whelplings|r in any order.
    .complete 42271,2 --4/4 Mana-Drained Whelpling revived
    .target Mana Drained Whelpling
step
    .goto 630,48.86,26.46
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the remaining |cRXP_FRIENDLY_Mana Drained Whelplings|r.
    .complete 42271,3 --1/1 Grievously Wounded Whelpling
    .target Mana Drained Whelpling
step
    .goto 630,47.92,26.94
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Senegos|r.
    .turnin 42271 >>Turn in Their Dying Breaths
    .accept 37690 >>Accept Those Who Remember
    .accept 37855 >>Accept The Last of the Last
    .target Senegos
step
    #title |cFFFCDC00DON'T ENTER THE CAVE|r
    .goto 630,49.18,16.62
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Projection of Senegos|r.
    .turnin 37855 >>Turn in The Last of the Last
    .target Projection of Senegos
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Agapanthus|r and the |cRXP_FRIENDLY_Mana-Drained Whelpling|r.
    .accept 37856 >>Accept The Withered
    .goto 630,48.62,16.52
    .target +Agapanthus
    .accept 37859 >>Accept The Consumed
    .goto 630,49.39,15.53
    .target +Mana-Drained Whelpling
step
    .goto 630,49.67,15.36
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Dim Ley Crystal|r.
    .complete 37859,1 --1/1 Dim Ley Crystal
step
    #completewith DefendingAzurewingReposeB
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_FRIENDLY_Mana-Drained Whelpling|r.
    >>Kill the |cRXP_ENEMY_Withered|r in the area.
    .complete 37859,2 --10/10 Mana-Drained Whelpling revived
    .complete 37856,1 --12/12 Withered slain
    .mob Withered Exile
    .mob Withered Mana-Rager
    .target Mana-Drained Whelpling
step
    .goto 630,46.64,15.80
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Stellagosa|r.
    .accept 37957 >>Accept Runas the Shamed
    .target Stellagosa
step
    #completewith next
    #label RunasTheShamedA
    >>Defeat |cRXP_ENEMY_Runas the Shamed|r.
    .complete 37957,1 --1/1 Runas the Shamed slain
    .mob Runas the Shamed
step
    #title |cFFFCDC00Enter Cave|r
    #completewith RunasTheShamedA
    .goto 630,44.14,17.59,10 >>Enter the cave
step
    #requires RunasTheShamedA
    #label DefendingAzurewingReposeB
    .goto 630,42.84,17.34
    >>Defeat |cRXP_ENEMY_Runas the Shamed|r.
    .complete 37957,1 --1/1 Runas the Shamed slain
    .mob Runas the Shamed
step
    #label DefendingAzurewingReposeC
    #loop
    .goto 630,44.41,17.00,35,0
    .goto 630,46.76,16.27,35,0
    .goto 630,45.73,14.50,35,0
    .goto 630,48.57,14.79,45,0
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_FRIENDLY_Mana-Drained Whelpling|r.
    >>Kill the |cRXP_ENEMY_Withered|r in the area.
    .complete 37859,2 --10/10 Mana-Drained Whelpling revived
    .complete 37856,1 --12/12 Withered slain
    .mob Withered Exile
    .mob Withered Mana-Rager
    .target Mana-Drained Whelpling
step
    .goto 630,48.61,16.53
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Agapanthus|r.
    .turnin 37856 >>Turn in The Withered
    .target Agapanthus
step
    .goto 630,49.17,16.60
    >>Fly back to the |cRXP_FRIENDLY_Projection of Senegos|r.
    .complete 37957,2 --1/1 Escort Runas to Senegos
    .target Projection of Senegos
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Projection of Senegos|r and |cRXP_FRIENDLY_Runas the Shamed|r.
    .turnin 37859 >>Turn in The Consumed
    .turnin 37957 >>Turn in Runas the Shamed
    .goto 630,49.16,16.60
    .target +Projection of Senegos
    .accept 37857 >>Accept Runas Knows the Way
    .goto 630,49.22,16.09
    .target +Runas the Shamed
step
    #completewith next
    .goto 630,49.22,16.09
    .gossipoption 43454 >>Talk to |cRXP_FRIENDLY_Runas the Shamed|r and follow him.
    .target Runas the Shamed
step
    #title |cFFFCDC00Stay close to|r Runas
    .goto 630,53.65,16.79
    >>Follow |cRXP_FRIENDLY_Runas the Shamed|r. |cRXP_WARN_Stay close to him|r.
    .complete 37857,1 --1/1 Follow Runas
    .target Runas the Shamed
step
    #label DefendingAzurewingReposeD
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Projection of Senegos|r and |cRXP_FRIENDLY_Runas the Shamed|r.
    .turnin 37857 >>Turn in Runas Knows the Way
    .accept 37960 >>Accept Leyline Abuse
    .goto 630,53.37,16.26
    .target +Projection of Senegos
    .accept 37959 >>Accept The Hunger Returns
    .goto 630,53.78,16.80
    .target +Runas the Shamed
step
    #label DefendingAzurewingReposeE
    #completewith NightborneLeylineAbuse
    >>Kill |cRXP_ENEMY_Withered|r in the area. Loot them for the |T135998:0|t[|cRXP_LOOT_Charged Mana Jewels|r].
    .complete 37959,1 --4/4 Charged Mana Jewel
    .mob Withered Fanatic
    .mob Nightfallen Hungerer
    .mob Nightfallen Overseer
step
    >>Kill |cRXP_ENEMY_Ishkaneth|r.
    .goto 630,56.74,17.71
    .complete 37960,2 --1/1 Ishkaneth slain
    .mob Ishkaneth
step
    #label NightborneLeylineAbuse
    >>Kill |cRXP_ENEMY_Tyndrissen|r.
    .goto 630,57.69,15.72
    .complete 37960,1 --1/1 Tyndrissen slain
    .mob Tyndrissen
step
    #loop
    .goto 630,56.11,12.18,30,0
    .goto 630,54.90,18.19,30,0
    .goto 630,58.12,17.20,30,0
    .goto 630,56.11,12.18,30,0
    .goto 630,54.90,18.19,30,0
    .goto 630,58.12,17.20,30,0
    .goto 630,56.02,17.12,30,0
    >>Kill |cRXP_ENEMY_Withered|r in the area. Loot them for the |T135998:0|t[|cRXP_LOOT_Charged Mana Jewels|r].
    .complete 37959,1 --4/4 Charged Mana Jewel
    .mob Withered Fanatic
    .mob Withered Scavenger
    .mob Nightfallen Hungerer
    .mob Nightfallen Overseer
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Runas the Shamed|r. and |cRXP_FRIENDLY_Projection of Senegos|r.
    .turnin 37959 >>Turn in The Hunger Returns
    .goto 630,53.78,16.80
    .turnin 37960 >>Turn in Leyline Abuse
    .accept 37860 >>Accept You Scratch My Back...
    .accept 37861 >>Accept The Nightborne Prince
    .goto 630,53.37,16.26
    .target +Projection of Senegos
    .accept 37860 >>Accept You Scratch My Back...
    .goto 630,53.78,16.80
    .target +Runas the Shamed
step
    .goto 630,55.58,12.95
    >>Use the |T134539:0|t[|cRXP_WARN_ExtraActionButton|r] (Release Whelplings) and aim the circle at the pylon.
    .complete 37860,3 --1/1 Disable northwestern Mana Pylon
step
    .goto 630,55.98,14.06
    >>Use the |T134539:0|t[|cRXP_WARN_ExtraActionButton|r] (Release Whelplings) and aim the circle at the pylon.
    .complete 37860,2 --1/1 Disable central Mana Pylon
step
    .goto 630,56.46,15.14
    >>Use the |T134539:0|t[|cRXP_WARN_ExtraActionButton|r] (Release Whelplings) and aim the circle at the pylon.
    .complete 37860,1 --1/1 Disable southern Mana Pylon
step
    .goto 630,57.19,13.92
    >>Use the |T134539:0|t[|cRXP_WARN_ExtraActionButton|r] (Release Whelplings) and aim the circle at the pylon.
    .complete 37860,4 --1/1 Disable eastern Mana Pylon
step
    >>Click on the popup under your minimap.
    .turnin 37860 >>Turn in You Scratch My Back...
step
    .goto 630,57.73,12.63
    >>Kill |cRXP_ENEMY_Ael'Yith|r.
    .complete 37861,1 --1/1 Ael'Yith slain
    .mob Ael'Yith
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to the |cRXP_FRIENDLY_Stellagosa|r.
    .goto 630,57.56,13.63
    .turnin 37861 >>Turn in The Nightborne Prince
    .target Stellagosa
step
    #label DefendingAzurewingReposeF
    .goto 630,57.56,13.56
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Stellagosa|r
    .turnin 37861 >>Turn in The Nightborne Prince
    .accept 37862 >>Accept Still Alive
    .target Stellagosa
step
    #label DefendingAzurewingReposeG
    .goto 630,49.93,26.54
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Stellagosa|r
    .turnin 37862 >>Turn in Still Alive
    .accept 38015 >>Accept On the Brink
    .target Stellagosa
step
    .goto 630,49.65,26.81
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
    .accept 38014 >>Accept Feasting on the Dragon
    .target Archmage Khadgar
step
    #completewith OnTheBrinkA
    >>Kill the |cRXP_ENEMY_Withered forces|r
    .complete 38014,1 --15/15 Withered slain at Azurewing Repose
    .mob Withered Skulker
    .mob Withered Outcast
step
    #completewith next
    #label OnTheBrinkB
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_FRIENDLY_Berazus|r.
    .complete 38015,4 --1/1 Heal Berazus
    .target Berazus
step
    #completewith OnTheBrinkB
    #title |cFFFCDC00Enter Cave|r
    .goto 630,49.44,25.87,10 >>Enter the cave
step
    #requires OnTheBrinkB
    .goto 630,49.73,24.98
    >>Use the |T133255:0|t[Radiant Ley Crystal] on |cRXP_FRIENDLY_Berazus|r.
    .complete 38015,4 --1/1 Heal Berazus
    .target Berazus
    .use 138146
step
    .goto 630,48.67,27.90
    >>Use the |T133255:0|t[Radiant Ley Crystal] on |cRXP_FRIENDLY_Cedonu|r.
    .complete 38015,1 --1/1 Heal Cedonu
    .target Cedonu
    .use 138146
step
    .goto 630,47.98,27.13
    >>Use the |T133255:0|t[Radiant Ley Crystal] on |cRXP_FRIENDLY_Emmigosa|r.
    .complete 38015,3 --1/1 Heal Emmigosa
    .target Emmigosa
    .use 138146
step
    #label OnTheBrinkA
    .goto 630,47.26,26.33
    >>Use the |T133255:0|t[Radiant Ley Crystal] on |cRXP_FRIENDLY_Kharmeera|r.
    .complete 38015,2 --1/1 Heal Kharmeera
    .target Kharmeera
    .use 138146
step
    #loop
    .goto 630,47.90,28.21,35,0
    .goto 630,49.31,26.34,35,0
    .goto 630,48.25,25.53,45,0
    >>Kill the |cRXP_ENEMY_Withered forces|r
    .complete 38014,1 --15/15 Withered slain at Azurewing Repose
    .mob Withered Skulker
    .mob Withered Outcast
step
    .goto 630,49.64,26.81
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Archmage Khadgar|r
    .turnin 38014 >>Turn in Feasting on the Dragon
    .target Archmage Khadgar
step
    .goto 630,49.94,26.55
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Stellagosa|r
    .turnin 38015 >>Turn in On the Brink
    .accept 42567 >>Accept Cursed to Wither
    .target Stellagosa
step
    #completewith next
    #label CursedToWitherA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Runas the Shamed|r
    .turnin 42567 >>Turn in Cursed to Wither
    .accept 42756 >>Accept Hunger's End
    .target Runas the Shamed
step
    #completewith CursedToWitherA
    #title |cFFFCDC00Enter Cave|r
    .goto 630,48.03,24.56,40 >>|cRXP_WARN_Enter the cave|r
step
    #requires CursedToWitherA
    .goto 630,48.25,22.75
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Runas the Shamed|r
    .turnin 42567 >>Turn in Cursed to Wither
    .accept 42756 >>Accept Hunger's End
    .target Runas the Shamed
step
    .goto 630,48.14,27.22
    >>Kill |cRXP_ENEMY_Orbyth|r and |cRXP_ENEMY_Ael'Yith|r
    .complete 42756,1 --1/1 Orbyth slain
    .mob +Orbyth
    .complete 42756,2 --1/1 Ael'Yith slain
    .mob +Ael'Yith
step
    #label Defending Azurewing Repose
    .goto 630,48.05,25.81
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Senegos|r
    .turnin 42756 >>Turn in Hunger's End
    .target Senegos
]])

--Azsuna versus Azshara
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name b) Azsuna versus Azshara
#displayname |cFF00CCFF3|r - Azsuna versus Azshara
#internal

step
    #completewith AzsunaVersusAzsharaZ
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #label AzsunaVersusAzsharaA
    .goto 630,47.92,26.94
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Senegos|r.
    .accept 37690 >>Accept Those Who Remember
    .target Senegos
step
    .goto 630,48.38,34.54
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nightwatcher Idri|r
    .turnin 37690 >>Turn in Those Who Remember
    .accept 37256 >>Accept They Came From the Sea
    .target Nightwatcher Idri
step
    #completewith next
    >>Kill the |cRXP_ENEMY_Hatecoil Naga|r.
    .complete 37256,2 --8/8 Hatecoil naga slain
    .mob Hatecoil Raider
    .mob Hatecoil Enchantress
    .mob Hatecoil Gargantuan
step
    .goto 630,45.14,36.84
    >>Kill |cRXP_ENEMY_Fathom-Commander Zarrin|r. Loot him for the |T1391617:0|t[|cRXP_LOOT_Head of Fathom-Commander Zarrin]
    .complete 37256,1 --1/1 Head of Fathom-Commander Zarrin
    .mob Fathom-Commander Zarrin
step
    #loop
    .goto 630,45.46,39.30,40,0
    .goto 630,47.93,37.93,40,0
    .goto 630,45.85,34.37,45,0
    >>Kill the |cRXP_ENEMY_Hatecoil Naga|r.
    .complete 37256,2 --8/8 Hatecoil naga slain
    .mob Hatecoil Raider
    .mob Hatecoil Enchantress
    .mob Hatecoil Gargantuan
step
    .goto 630,48.39,34.54
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nightwatcher Idri|r
    .turnin 37256 >>Turn in They Came From the Sea
    .accept 37733 >>Accept Prince Farondis
    .target Nightwatcher Idri
step
    .goto 630,46.96,41.22
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Nightwatcher Idri|r
    .turnin 37733 >>Turn in Prince Farondis
    .target Nightwatcher Idri
step
    #label AzsunaVersusAzsharaB
    .goto 630,47.00,41.36
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Prince Farondis|r
    .accept 37257 >>Accept Our Very Bones
    .target Prince Farondis
step
    #loop
    .goto 630,50.17,39.68,30,0
    .goto 630,49.63,36.25,30,0
    .goto 630,50.87,33.55,45,0
    >>Kill |cRXP_ENEMY_Salteye Murlocs|r. Loot them for the |T442733:0|t[|cRXP_LOOT_Pilfered Night Elf Bones|r]
    .complete 37257,1 --55/55 Pilfered Night Elf Bone
    .mob Salteye Spearguard
    .mob Salteye Beastfeeder
    .mob Salteye Hookblade
    .mob Salteye Tide-Shaman
    .mob Salteye Clam Vanquisher
step
    #label AzsunaVersusAzsharaC
    .goto 630,47.00,41.36
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Prince Farondis|r
    .turnin 37257 >>Turn in Our Very Bones
    .accept 37497 >>Accept Trailing the Tidestone
    .target Prince Farondis
    .skipgossipid 43329
step
    #title |cFFFCDC00Stay close to Prince Farondis|r
    .goto 630,47.36,40.32,18,0
    .goto 630,51.80,44.30
    >>|cRXP_WARN_Stay close to |cRXP_FRIENDLY_Prince Farondis|r.|r. Kill the spawning |cRXP_ENEMY_Ambusher|r and |cRXP_ENEMY_Murlocs|r
    .complete 37497,1 --1/1 Escort Prince Farondis
    .mob Hatecoil Ambusher
    .mob Salteye Spearwaver
    .skipgossipid 43329
step
    #label AzsunaVersusAzsharaD
    .goto 630,51.79,44.30
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Prince Farondis|r
    .turnin 37497 >>Turn in Trailing the Tidestone
    .accept 37486 >>Accept Nar'thalas Still Suffers
    .target Prince Farondis
step
    #label AzsunaVersusAzsharaE
    .goto 630,55.74,48.42
    >>Kill |cRXP_ENEMY_Athissa|r
    .complete 37486,1 --1/1 Athissa defeated
    .mob Athissa
step
    #label AzsunaVersusAzsharaF
    .goto 630,51.79,44.30
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Prince Farondis|r
    .turnin 37486 >>Turn in Nar'thalas Still Suffers
    .accept 37467 >>Accept The Walk of Shame
    .target Prince Farondis
    .skipgossipid 43330
step
    #title Stay close to Prince  Farondis
    .goto 630,52.06,43.81,10,0
    .goto 630,52.40,43.70,10,0
    .goto 630,52.21,43.16,10,0
    .goto 630,52.26,42.92,10,0
    .goto 630,54.30,42.51,15,0
    .goto 630,54.19,42.02
    >>|cRXP_WARN_Stay close to |cRXP_FRIENDLY_Prince Farondis|r.|r. Kill the spawning |cRXP_ENEMY_Souls|r and |cRXP_ENEMY_Murlocs|r
    .complete 37467,1 --1/1 Escort Prince Farondis
    .mob Drowned Magister
    .mob Unbreathing Soul
    .mob Naga Brute
    .mob Salteye Shoresprinter
    .skipgossipid 43330
step
    .goto 630,54.19,42.02
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Prince Farondis|r
    .turnin 37467 >>Turn in The Walk of Shame
    .accept 37468 >>Accept Into the Academy
    .target Prince Farondis
step
    #completewith next
    #label IntoTheAcademyA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thyrillion|r and |cRXP_FRIENDLY_Andellis|r
    .turnin 37468 >>Turn in Into the Academy
    .accept 37736 >>Accept Dressing With Class
    .target +Thyrillion
    .accept 37678 >>Accept Hit the Books
    .target +Andellis
step
    #completewith IntoTheAcademyA
    .goto 631,63.05,87.74,20 >>|cRXP_WARN_Enter the academy|r
step
    #requires IntoTheAcademyA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thyrillion|r and |cRXP_FRIENDLY_Andellis|r
    .turnin 37468 >>Turn in Into the Academy
    .accept 37736 >>Accept Dressing With Class
    .goto 631,53.38,47.59
    .target +Thyrillion
    .accept 37678 >>Accept Hit the Books
    .goto 631,52.97,47.80
    .target +Andellis
step
    #completewith AzsunaVersusAzsharaH
    >>Kill the |cRXP_ENEMY_Ancient Tomes|r
    .complete 37678,1 --3/3 Ancient Tome slain
    .mob Ancient Tome
step
    .goto 631,55.05,51.49
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Academy Bookshelf|r
    .complete 37736,4 --1/1 Nar'thalas Academy Spellbook
step
    .goto 631,56.62,56.40
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Academy Hat|r
    >>|cRXP_WARN_Wait until the hat from the |cRXP_FRIENDLY_Drowned Student|r falls to the ground|r
    .complete 37736,1 --1/1 Nar'thalas Academy Hat
step
    #label AzsunaVersusAzsharaG
    .goto 631,58.38,68.63,10,0
    .goto 631,66.48,72.66
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Academy Wand|r
    .complete 37736,3 --1/1 Nar'thalas Academy Wand
step
    #label AzsunaVersusAzsharaH
    .goto 631,64.00,85.03,10,0
    .goto 631,59.73,84.49
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_FRIENDLY_Drowned Student|r
    .complete 37736,2 --1/1 Nar'thalas Academy Robes
step
    #loop
    .goto 631,54.59,79.60,15,0
    .goto 631,58.72,68.94,15,0
    .goto 631,66.59,75.69,15,0
    .goto 631,63.22,85.40,15,0
    >>Kill |cRXP_ENEMY_Ancient Tomes|r
    .complete 37678,1 --3/3 Ancient Tome slain
    .mob Ancient Tome
step
    .goto 631,58.08,67.71,10,0
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Andellis|r and |cRXP_FRIENDLY_Thyrillion|r
    .turnin 37678 >>Turn in Hit the Books
    .goto 631,52.97,47.80
    .target +Andellis
    .turnin 37736 >>Turn in Dressing With Class
    .accept 37518 >>Accept The Haunted Halls
    .goto 631,53.38,47.60
    .target +Thyrillion
step
    .goto 631,42.19,50.86,10,0
    .goto 631,28.86,42.41
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Academy Door|r
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Instructor Nidriel|r
    .turnin 37518 >>Turn in The Haunted Halls
    .accept 42370 >>Accept Wanding 101
    .target Instructor Nidriel
step
    .goto 631,33.35,51.26,15,0
    .goto 631,36.36,34.89,15,0
    .goto 631,33.96,43.89
    >>Use the |T135477:0|t[|cRXP_WARN_ExtraActionButton|r] while aiming at the |cRXP_PICK_Wand Targets|r
    .complete 42370,1 --10/10 Wand Target
step
    .goto 631,28.86,42.41
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Instructor Nidriel|r
    .turnin 42370 >>Turn in Wanding 101
    .target Instructor Nidriel
step
    .goto 631,30.27,45.33
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sythorne|r
    .accept 42371 >>Accept Study Hall: Combat Research
    .target Sythorne
step
    .goto 631,26.28,47.14
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Encyclopedia|r
    .complete 42371,1 --1/1 Encyclopedia Azsunica (K-M)
step
    .goto 631,30.21,44.83
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sythorne's Podium|r
    .complete 42371,2 --1/1 Place book on Sythorne's Podium
step
    .goto 631,32.61,42.80
    >>Kill |cRXP_ENEMY_Kobold Drawing|r
    .complete 42371,3 --1/1 Kobold Drawing slain
    .mob Kobold Drawing
step
    .goto 631,26.89,48.65
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Courtship Rituals of the Skrog|r
    .complete 42371,4 --1/1 Courtship Rituals of the Skrog
step
    .goto 631,30.23,44.80
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sythorne's Podium|r
    .complete 42371,5 --1/1 Place book on Sythorne's Podium
step
    .goto 631,32.61,42.80
    >>Kill |cRXP_ENEMY_Sea Skrog Drawing|r
    .complete 42371,6 --1/1 Sea Skrog Drawing slain
    .mob Sea Skrog Drawing
step
    .goto 631,26.69,47.20
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Draconic Compendium, Volume III|r
    .complete 42371,7 --1/1 Draconic Compendium, Volume III
step
    .goto 631,30.20,44.80
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sythorne's Podium|r
    .complete 42371,8 --1/1 Place book on Sythorne's Podium
step
    .goto 631,32.58,42.63
    >>Kill |cRXP_ENEMY_Senegos Drawing|r
    .complete 42371,9 --1/1 Senegos Drawing slain
    .mob Senegos Drawing
step
    .goto 631,30.33,45.27
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sythorne|r
    .turnin 42371 >>Turn in Study Hall: Combat Research
    .target Sythorne
step
    .goto 631,28.88,42.40
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Instructor Nidriel|r
    .accept 37729 >>Accept Pop Quiz: Advanced Rune Drawing
    .target Instructor Nidriel
step
    .goto 631,32.63,42.66
    >>|cRXP_WARN_Follow the circles on the ground|r
    .complete 37729,1 --1/1 Arcane Rune drawn
    .complete 37729,2 --1/1 Fire Rune drawn
    .complete 37729,3 --1/1 Frost Rune drawn
step
    .goto 631,28.91,42.48
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Instructor Nidriel|r
    .turnin 37729 >>Turn in Pop Quiz: Advanced Rune Drawing
    .accept 37730 >>Accept The Headmistress' Keys
    .target Instructor Nidriel
step
    #completewith next
    #label TidestoneVaultKeyA
    >>Kill |cRXP_ENEMY_Elya Azuremoon|r. Loot her for the |T348541:0|t[|cRXP_LOOT_Tidestone Vault Key|r]
    .complete 37730,1 --1/1 Tidestone Vault Key
    .mob Elya Azuremoon
step
    #completewith TidestoneVaultKeyA
    .goto 631,26.86,36.94
    .skipgossipid 45954
    .skipgossipid 45955
    .gossipoption 45956 >>Talk to |cRXP_FRIENDLY_Elya Azuremoon|r
step
    #requires TidestoneVaultKeyA
    .goto 631,26.10,37.23
    >>Kill |cRXP_ENEMY_Elya Azuremoon|r. Loot her for the |T348541:0|t[|cRXP_LOOT_Tidestone Vault Key|r]
    .complete 37730,1 --1/1 Tidestone Vault Key
    .mob Elya Azuremoon
step
    .goto 631,42.19,50.86,10,0
    .goto 631,53.39,47.60
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Academy Door|r
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Thyrillion|r
    .turnin 37730 >>Turn in The Headmistress' Keys
    .accept 37469 >>Accept The Tidestone: Shattered
    .target Thyrillion
step
    #completewith next
    #label TidestoneShardsA
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Tidestone Shards|r
step
    #completewith TidestoneShardsA
    .goto 631,64.36,32.54,10 >>Enter the Hall of Antiquities
step
    #loop
    .goto 631,64.55,29.60,10,0
    .goto 631,62.29,24.26,10,0
    .goto 631,66.74,26.83,10,0
    #requires TidestoneShardsA
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Tidestone Shards|r
    .complete 37469,1,3 --3/5 Tidestone Shards
    .mob Weeping Banshee
    .mob Spectral Student
step
    #label AzsunaVersusAzsharaI
    #loop
    .goto 631,73.01,27.03,10,0
    .goto 631,69.41,21.37,10,0
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Tidestone Shards|r
    .complete 37469,1 --5/5 Tidestone Shards
    .mob Weeping Banshee
    .mob Spectral Student
step
    #label AzsunaVersusAzsharaJ
    .goto 631,68.88,13.29
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Tidestone Core|r
    .turnin 37469 >>Turn in The Tidestone: Shattered
    .target Tidestone Core
    .timer 60,Roleplay Duration
step
    .goto 630,57.86,43.35
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Prince Farondis|r
    .accept 37530 >>Accept Save Yourself
    .target Prince Farondis
    .skipgossipid 43333
step
    .goto 630,57.86,43.35
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Prince Farondis|r
    .complete 37530,1 --1/1 Speak with Prince Farondis
    .target Prince Farondis
    .skipgossipid 43333
step
    #title |cFFFCDC00Follow the Arrow|r
    .goto 630,54.00,41.31
    >>|cRXP_WARN_Follow the arrow, don't press any buttons while waiting for the roleplay|r
    *- Use the |T135821:0|t[Meteor Storm] (2) and |T135812:0|t[Fireball] (1) to kill enemies
    *- Use |T135736:0|t[Blink] to move faster
    .complete 37530,2 --1/1 Approach the Academy
    .timer 16,Roleplay Duration
step
    #title |cFFFCDC00Follow the Arrow|r
    .goto 630,54.43,42.63,25,0
    .goto 630,55.23,41.53
    >>|cRXP_WARN_Follow the arrow|r
    *- Use |T135736:0|t[Blink] to move faster
    .complete 37530,3 --1/1 Pursue the naga
step
    .goto 630,55.45,41.08
    >>Use the |T135821:0|t[Meteor Storm] (2) and |T135812:0|t[Fireball] (1) to defeat |cRXP_ENEMY_Athissa|r and |cRXP_ENEMY_Parjesh|r
    *|cRXP_WARN_Dodge the water bubbles|r
    .complete 37530,4 --1/1 Defeat Athissa and Parjesh
    .mob Athissa
    .mob Parjesh
step
    #title |cFFFCDC00Follow the Arrow|r
    .goto 630,57.79,40.85,20,0
    .goto 630,58.12,41.07
    >>|cRXP_WARN_Follow the arrow|r
    *- Use the |T135821:0|t[Meteor Storm] (2) and |T135812:0|t[Fireball] (1) to kill enemies
    *- Use |T135736:0|t[Blink] to move faster
    .complete 37530,5 --1/1 Find the Hatecoil Slave Pen
    .timer 98,Roleplay Duration
step
    .goto 630,58.54,41.55
    >>Spam |T135736:0|t[Blink] (3) |cRXP_WARN_when you start walking backwards|r
    .complete 37530,6 --1/1 Defeat Queen Azshara
step
    .goto 630,57.88,43.12
    >>|cRXP_WARN_Follow the arrow|r
    .complete 37530,7 --1/1 Save yourself
step
    .goto 630,57.82,43.42
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_yourself|r
    .turnin 37530 >>Turn in Save Yourself
step
    .goto 630,57.86,43.35
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Prince Farondis|r
    .accept 37470 >>Accept The Head of the Snake
    .target Prince Farondis
step
    #completewith next
    #label AthissaSlainA
    >>Kill |cRXP_ENEMY_Athissa|r
    .complete 37470,1 --1/1 Athissa slain
    .mob Athissa
step
    #completewith AthissaSlainA
    #title |cFFFCDC00Leave Cave|r
    .goto 630,58.52,41.58,20 >>|cRXP_WARN_Leave the cave|r
step
    #requires AthissaSlainA
    .goto 630,62.73,41.18
    >>Kill |cRXP_ENEMY_Athissa|r
    *|cRXP_WARN_Dodge the bubbles and the waves|r
    .complete 37470,1 --1/1 Athissa slain
    .mob Athissa
step
    #label AzsunaVersusAzsharaZ
    .goto 630,61.70,41.09
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Prince Farondis|r
    *|cRXP_WARN_NOTE:|r You can complete this quest but we'll keep it until 70 and turn it in with the increased xp buff.
    .turnin 37470 >>Turn in The Head of the Snake
    .accept 38286 >>Accept Eye of Azshara: Wrath of Azshara
    .target Prince Farondis
]])

--Against Giants
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name b) Against Giants
#displayname |cFF00CCFF4|r - Against Giants
#internal

step
    #completewith AgainstGiantsZ
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #label AgainstGiantsA
    #loop
    .goto 630,50.17,39.68,30,0
    .goto 630,49.63,36.25,30,0
    .goto 630,50.87,33.55,45,0
    >>Kill |cRXP_ENEMY_Salteye Murlocs|r. Loot them for the |T461806:0|t[|cRXP_LOOT_Okuna's Message|r]
    .accept 38407 >>Accept Bottled Up
    .mob Salteye Spearguard
    .mob Salteye Beastfeeder
    .mob Salteye Hookblade
    .mob Salteye Tide-Shaman
    .mob Salteye Clam Vanquisher
step
    .goto 630,47.05,41.48
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Irisse|r
    .turnin 38407 >>Turn in Bottled Up
    .accept 37496 >>Accept Infiltrating Shipwreck Arena
    .target Lady Irisse
step
    #label Boss WhalebellyZ
    .goto 630,50.01,48.56
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Okuna Longtusk|r
    .turnin 37496 >>Turn in Infiltrating Shipwreck Arena
    .accept 37507 >>Accept Boss Whalebelly's in Charge
    .target Okuna Longtusk
step
    .goto 630,49.10,49.26
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Boss Whalebelly|r
    .complete 37507,1 --1/1 Speak with Boss Whalebelly
    .target Boss Whalebelly
    .skipgossipid 43780
step
    .goto 630,50.01,48.56
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Okuna Longtusk|r
    .turnin 37507 >>Turn in Boss Whalebelly's in Charge
    .accept 37528 >>Accept Let Sleeping Giants Lie
    .accept 37542 >>Accept No Time for Tryouts
    .target Okuna Longtusk
step
    #title |cFFFCDC00Fly to the waypoint|r
    .goto 630,49.34,50.70
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Giant's Stash of Weapons|r
    .complete 37528,1 --1/1 Giants' Stash of Weapons
step
    #completewith next
    #label NoTimeForTryoutsA
    >>Defeat |cRXP_ENEMY_Ooker Dooker|r
    .complete 37542,1 --1/1 Give Ooker Dooker a beatdown
    .mob Ooker Dooker
step
    #completewith NoTimeForTryoutsA
    #title |cFFFCDC00Enter Cave|r
    .goto 630,49.22,47.01,10 >>|cRXP_WARN_Enter the cave|r
step
    #requires NoTimeForTryoutsA
    .goto 630,49.22,46.63
    >>Defeat |cRXP_ENEMY_Ooker Dooker|r
    .complete 37542,1 --1/1 Give Ooker Dooker a beatdown
    .mob Ooker Dooker
step
    .goto 630,50.01,48.57
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Okuna Longtusk|r
    .turnin 37528 >>Turn in Let Sleeping Giants Lie
    .turnin 37542 >>Turn in No Time for Tryouts
    .accept 37510 >>Accept Sternfathom's Champion
    .target Okuna Longtusk
step
    .goto 630,47.93,48.67
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sternfathom|r
    .turnin 37510 >>Turn in Sternfathom's Champion
    .accept 37536 >>Accept Morale Booster
    .target Sternfathom
step
    #completewith next
    #label MoraleBoosterA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ooka Dooker|r
    .complete 37536,1 --1/1 Fighter Chow acquired
    .target Ooka Dooker
    .skipgossipid 42818
step
    #completewith MoraleBoosterA
    #title |cFFFCDC00Enter Cave|r
    .goto 630,50.06,49.07,12 >>|cRXP_WARN_Enter the cave|r
step
    #requires MoraleBoosterA
    #label AgainstGiantsAB
    .goto 630,50.26,49.76
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Ooka Dooker|r
    .complete 37536,1 --1/1 Fighter Chow acquired
    .target Ooka Dooker
    .skipgossipid 42818
step
    #completewith next
    #label AgainstGiantsAC
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sternfathom|r
    .turnin 37536 >>Turn in Morale Booster
    .accept 37538 >>Accept Round 1, Fight!
    .target Sternfathom
step
    #completewith AgainstGiantsAC
    #title |cFFFCDC00Leave Cave|r
    .goto 630,50.08,48.80,12 >>|cRXP_WARN_Leave the cave|r
step
    #requires AgainstGiantsAC
    .goto 630,47.91,48.75
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sternfathom|r
    .turnin 37536 >>Turn in Morale Booster
    .accept 37538 >>Accept Round 1, Fight!
    .target Sternfathom
    .skipgossipid 43712
step
    .goto 630,47.91,48.75
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Sternfathom|r
    .complete 37538,1 --1/1 Thrown into the arena
    .target Sternfathom
    .skipgossipid 43712
step
    .goto 630,48.16,49.16
    >>Defeat |cRXP_ENEMY_Captain Feargus|r, |cRXP_ENEMY_Golden Xue|r, and |cRXP_ENEMY_Boss Whalebelly|r
    .complete 37538,2 --1/1 Boss Whalebelly defeated
    .mob Captain Feargus
    .mob Golden Xue
    .mob Boss Whalebelly
step
    #label AgainstGiantsB
    .goto 632,43.81,24.62
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_PICK_Okuna Longtusk's Pack|r
    .turnin 37538 >>Turn in Round 1, Fight!
    .accept 37565 >>Accept The Right Weapon for the Job
    .target Okuna Longtusk's Pack
step
    #label AgainstGiantsC
    #loop
    .goto 632,72.48,75.05,25,0
    .goto 630,50.57,60.91,25,0
    .goto 630,47.95,59.20,25,0
    .goto 630,44.36,56,47,25,0
    .goto 630,45.18,55.53,25,0
    .goto 632,27.02,54.02,25,0
    .goto 632,34.43,37.92,25,0
    .goto 632,54.97,62.45,35,0
    >>Use the |T1030902:0|t[|Pile of Weapons] near |cRXP_FRIENDLY_Shipwrecked Captives|r
    .complete 37565,1 --25/25 Shipwrecked Captives armed
    .use 118330
step
    .goto 630,53.44,62.95
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Okuna Longtusk|r
    .turnin 37565 >>Turn in The Right Weapon for the Job
    .accept 37566 >>Accept The Prince is Going Down
    .target Okuna Longtusk
step
    #label AgainstGiantsD
    .goto 630,53.66,64.06
    >>Kill |cRXP_ENEMY_Prince Oceanus|r
    .complete 37566,1 --1/1 Prince Oceanus slain
    .mob Prince Oceanus
step
    #label AgainstGiantsZ
    .goto 630,51.93,61.78
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Okuna Longtusk|r
    .turnin 37566 >>Turn in The Prince is Going Down
    .target Okuna Longtusk
]])

--Mak'rana and the Fate of the Queen's Reprisal
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name b) Mak'rana and the Fate of the Queen's Reprisal
#displayname |cFF00CCFF5|r - Mak'rana and the Fate of the Queen's Reprisal
#internal

step
    #completewith MakranaFateQueenReprisalZ
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #label MakranaFateQueenReprisalA
    .goto 630,56.60,59.59
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mr. Shackle|r.
    .accept 37654 >>Accept Maritime Law
    .accept 37657 >>Accept Making the World Safe for Profit
    .target Mr. Shackle
step
    #label MakranaFateQueenReprisalAA
    .convertquest 42268,42220 << Alliance
    .goto 630,57.90,58.79
    >>|cRXP_WARN_Follow the arrow|r. The quest will pop up at the waypoint location
    .accept 42268 >>Accept Shipwrecked Sailors << Horde
    .accept 42220 >>Accept Shipwrecked Sailors << Alliance
step
    #completewith next
    >>Kill |cRXP_ENEMY_Giblins & Makruras|r.
    >>Rescue |cRXP_FRIENDLY_Queen's Reprisal Sailors|r. << Horde
    >>Kill |cRXP_ENEMY_Queen's Reprisal Sailors|r. << Alliance
    .complete 37657,1 --12/12 Giblin & Makrura slain
    .complete 42268,1 --10/10 Queen's Reprisal Sailors rescued
    .mob Bitterbrine Venomer
    .mob Bitterbrine Saltcaster
    .mob Mak'rana Warrior
    .mob Mak'rana Elder
    .target Queen's Reprisal Sailor
step
    .goto 630,64.25,56.14
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Looper Allen|r.
    .turnin 37654 >>Turn in Maritime Law
    .accept 37659 >>Accept The Captain's Foot Locker
    .target Looper Allen
step
    #completewith next
    #label TheCaptainsFootLocker
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_FRIENDLY_Captain's Foot Locker|r.
    .turnin 37659 >>Turn in The Captain's Foot Locker
    .accept 42244 >>Accept Fate of the Queen's Reprisal << Horde
    .accept 40794 >>Accept Fate of the Queen's Reprisal << Alliance
step
    #completewith TheCaptainsFootLocker
    .goto 630,65.30,57.02,8,0
    .goto 630,65.48,56.80,10 >>Enter the ship underwater through the hole
step
    #requires TheCaptainsFootLocker
    #label MakranaFateQueenReprisalB
    .goto 630,65.68,56.93
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_FRIENDLY_Captain's Foot Locker|r.
    .turnin 37659 >>Turn in The Captain's Foot Locker
    .accept 42244 >>Accept Fate of the Queen's Reprisal << Horde
    .accept 40794 >>Accept Fate of the Queen's Reprisal << Alliance
step
    #completewith NightborneMakingtheWorldSafeforProfit
    >>Kill |cRXP_ENEMY_Giblins & Makruras|r.
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_FRIENDLY_Queen's Reprisal Sailors|r. << Horde
    >>Kill |cRXP_ENEMY_Queen's Reprisal Sailors|r. << Alliance
    .complete 37657,1 --12/12 Giblin & Makrura slain
    .complete 42268,1 --10/10 Queen's Reprisal Sailors rescued
    .mob Bitterbrine Venomer
    .mob Bitterbrine Saltcaster
    .mob Mak'rana Warrior
    .mob Mak'rana Elder
    .target Queen's Reprisal Sailor
step
    #completewith next
    #label MakranaFateQueenReprisalC
    >>Kill |cRXP_ENEMY_Oublion|r.
    .complete 37657,2 --1/1 Deal with Queen Kraklaa
    .mob Oublion
step
    #completewith MakranaFateQueenReprisalC
    .goto 630,63.06,61.75,10 >>Enter the underwater cave
step
    #requires MakranaFateQueenReprisalC
    #label NightborneMakingtheWorldSafeforProfit
    .goto 630,63.81,63.82
    >>Kill |cRXP_ENEMY_Oublion|r.
    .complete 37657,2 --1/1 Deal with Queen Kraklaa
    .mob Oublion
step
    #loop
    .goto 630,63.83,57.40,45,0
    .goto 630,58.93,57.40,45,0
    .goto 630,59.03,62.38,45,0
    .goto 630,63.09,63.92,45,0
    >>Kill |cRXP_ENEMY_Giblins & Makruras|r.
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_FRIENDLY_Queen's Reprisal Sailors|r. << Horde
    >>Kill |cRXP_ENEMY_Queen's Reprisal Sailors|r. << Alliance
    .complete 37657,1 --12/12 Giblin & Makrura slain
    .complete 42268,1 --10/10 Queen's Reprisal Sailors rescued
    .mob Bitterbrine Venomer
    .mob Bitterbrine Saltcaster
    .mob Mak'rana Warrior
    .mob Mak'rana Elder
    .target Queen's Reprisal Sailor
step
    .goto 630,56.40,59.24
    >>|cRXP_WARN_Click on the popup under your minimap or search for the quest in your questlog to turn it in|r
    .turnin 42268 >>Turn in Shipwrecked Sailors
step
    #label Making the World Safe for ProfitZ
    .goto 630,56.61,59.61
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Mr. Shackle|r.
    .turnin 37657 >>Turn in Making the World Safe for Profit
    .target Mr. Shackle
step << Horde
    #completewith next
    #label FateOfTheQueensReprisalA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Advisor Stillwater|r
    .turnin 42244 >>Turn in Fate of the Queen's Reprisal
    .target Advisor Stillwater
step << Horde
    #completewith FateOfTheQueensReprisalA
    #title |cFFFCDC00Enter the Sanctum|r
    .goto 627,58.45,20.62,10 >>|cRXP_WARN_Enter the sanctum|r
step << Horde
    #requires FateOfTheQueensReprisalA
    #label MakranaFateQueenReprisalZ
    .goto 627,61.14,16.94
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Advisor Stillwater|r
    .turnin 42244 >>Turn in Fate of the Queen's Reprisal
    .target Advisor Stillwater
step << Alliance
    #completewith next
    #label FateOfTheQueensReprisalB
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Surtees|r
    .turnin 40794 >>Turn in Fate of the Queen's Reprisal
    .target Lieutenant Surtees
step << Alliance
    #completewith FateOfTheQueensReprisalB
    #title |cFFFCDC00Enter the Enclave|r
    .goto 627,34.48,66.51,15 >>|cRXP_WARN_Enter the enclave|r
step << Alliance
    #requires FateOfTheQueensReprisalB
    #label MakranaFateQueenReprisalZ
    .goto 627,29.40,75.66
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lieutenant Surtees|r
    .turnin 40794 >>Turn in Fate of the Queen's Reprisal
    .target Lieutenant Surtees
]])

-- ======================================
-- ======= SOJOURNER: AZSUNA ============
-- ======================================

--Challiane Vineyards
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name b) Challiane Vineyards
#subgroup |cFFFCDC00(10-80+)|r Sojourner
#displayname |cFF00CCFF1|r - Challiane Vineyards
#internal

step
    #completewith ChallianeVineyardsZ
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #label ChallianeVineyardsA
    .goto 630,40.78,9.32
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cellarman Voodani|r
    .accept 38203 >>Accept Challiane Vineyards
    .target Cellarman Voodani
step
    .goto 630,42.88,8.47
    >>Kill |cRXP_ENEMY_Grand Vintner Valiana|r. Loot them for the |T134327:0|t[|cRXP_LOOT_Nightrose Recipe: Part 3, Instructions|r].
    .complete 38203,3 --1/1 Nightrose Recipe: Part 3, Instructions
    .mob Grand Vintner Valiana
step
    #label ChallianeVineyardsAA
    .goto 630,45.47,12.84
    >>Kill |cRXP_ENEMY_Vintner Liastrin|r. Loot them for the |T134327:0|t[|cRXP_LOOT_Nightrose Recipe: Part 2, Preparation|r].
    .complete 38203,2 --1/1 Nightrose Recipe: Part 2, Preparation
    .mob Vintner Liastrin
step
    #label ChallianeVineyardsB
    .goto 630,47.15,8.25
    >>Kill |cRXP_ENEMY_Vintner Shalrala|r. Loot them for the |T134327:0|t[|cRXP_LOOT_Nightrose Recipe: Part 1, Ingredients|r].
    .complete 38203,1 --1/1 Nightrose Recipe: Part 1, Ingredients
    .mob Vintner Shalrala
step
    #label ChallianeVineyardsZ
    .goto 630,40.77,9.32
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Cellarman Voodani|r
    .turnin 38203 >>Turn in Challiane Vineyards
    .target Cellarman Voodani
]])

--Kirin Tor Reconnaissance
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name b) Kirin Tor Reconnaissance
#subgroup |cFFFCDC00(10-80+)|r Sojourner
#displayname |cFF00CCFF1|r - Kirin Tor Reconnaissance
#internal

step
    #completewith KirinTorReconnaissanceZ
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #label KirinTorReconnaissanceA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kallistia Starlance|r and |cRXP_FRIENDLY_Olothil Starlance|r
    .accept 42692 >>Accept Children of Nar'thalas
    .goto 630,53.28,45.31
    .target +Kallistia Starlance
    .accept 42693 >>Accept You Never Know Until You Scry
    .goto 630,53.39,45.43
    .target +Olothil Starlance
step
    #completewith Hatecoil Glyptic2
    >>Kill the |cRXP_ENEMY_Hatecoil Naga|r and the |cRXP_ENEMY_Naga Brute|r. Loot them for the |T1028990:0|t[|cRXP_LOOT_Hatecoil Glyptics|r].
    .complete 42693,1 --3/3 Hatecoil Glyptic
    .mob Hatecoil Stormcaller
    .mob Hatecoil Riptail
    .mob Naga Brute
step
    #label KirinTorReconnaissanceB
    .goto 630,51.90,44.93
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Ancient Highborne Tome|r
    .complete 42692,1 --1/1 First Ancient Highborne Tome
step
    .goto 630,51.99,43.85
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Ancient Highborne Tome|r
    *|cRXP_WARN_The waypoint will be wrong if you click on the tomes in a different order|r
    .complete 42692,2 --1/1 Second Ancient Highborne Tome
step
    #completewith next
    #label ChildrenOfNarthasB
    .goto 630,51.89,44.02,5,0
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Ancient Highborne Tome|r
    *|cRXP_WARN_The waypoint will be wrong if you click on the tomes in a different order|r
    .complete 42692,3 --1/1 Third Ancient Highborne Tome
step
    #completewith ChildrenOfNarthasB
    #title |cFFFCDC00Enter the ruins|r
    .goto 630,52.6,44.21,10 >>|cRXP_WARN_Enter the ruins|r
step
    #requires ChildrenOfNarthasB
    #label Hatecoil Glyptic2
    .goto 630,53.03,43.74
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Ancient Highborne Tome|r
    *|cRXP_WARN_The waypoint will be wrong if you click on the tomes in a different order|r
    .complete 42692,3 --1/1 Third Ancient Highborne Tome
step
    #loop
    .goto 630,55.90,43.94,30,0
    .goto 630,55.52,47.24,30,0
    .goto 630,52.94,43.89,35,0
    >>Kill the |cRXP_ENEMY_Hatecoil Naga|r and the |cRXP_ENEMY_Naga Brute|r. Loot them for the |T1028990:0|t[|cRXP_LOOT_Hatecoil Glyptics|r].
    .complete 42693,1 --3/3 Hatecoil Glyptic
    .mob Hatecoil Stormcaller
    .mob Hatecoil Riptail
    .mob Naga Brute
step
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Kallistia Starlance|r and |cRXP_FRIENDLY_Olothil Starlance|r
    .turnin 42692 >>Turn in Children of Nar'thalas
    .goto 630,53.27,45.31
    .target +Kallistia Starlance
    .turnin 42693 >>Turn in You Never Know Until You Scry
    .accept 42694 >>Accept Back from the Dead
    .goto 630,53.39,45.43
    .target +Olothil Starlance
step
    .goto 630,53.39,45.43
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Scrying Orb|r.
    .complete 42694,1 --1/1 Use Scrying Orb
step
    .goto 630,55.04,45.96
    >>Defend the |cRXP_FRIENDLY_Nar'thalas Citizens|r by killing the |cRXP_ENEMY_Hatecoil Riptail|r.
    .complete 42694,4 --1/1 Search near the plaza fountain
    .mob Hatecoil Riptail
step
    #label KirinTorReconnaissanceX
    .goto 630,56.18,42.29
    >>Kill |cRXP_ENEMY_Grulk|r
    .complete 42694,3 --1/1 Search the eastern colonnade
    .mob Grulk
step
    #label KirinTorReconnaissanceY
    .goto 630,54.96,38.66
    >>Kill the |cRXP_ENEMY_Salteye Murlocs|r
    .complete 42694,2 --1/1 Search near the Academy
    .mob Salteye Hookblade
    .mob Salteye Shoresprinter
    .mob Salteye Tide-Shaman
step
    #label KirinTorReconnaissanceZ
    .goto 630,53.33,45.41
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Olothil Starlance|r
    .turnin 42694 >>Turn in Back from the Dead
    .target Olothil Starlance
]])

--A Rather Long Walk
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name b) A Rather Long Walk
#subgroup |cFFFCDC00(10-80+)|r Sojourner
#subweight 99.97
#displayname |cFF00CCFF1|r - A Rather Long Walk
#internal

step
    #completewith A Rather Long Walk
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    .goto 630,47.05,41.48
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Irisse|r
    .accept 37492 >>Accept A Rather Long Walk
    .target Lady Irisse
step
    .goto 630,51.71,36.56
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on |cRXP_FRIENDLY_Elder Aldryth|r
    .complete 37492,1 --1/1 Elder Aldryth found
    .target Elder Aldryth
step
    #label A Rather Long Walk
    .goto 630,47.05,41.48
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Lady Irisse|r
    .turnin 37492 >>Turn in A Rather Long Walk
    .target Lady Irisse
]])

--Crumbled Palace Cocktails
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Legion Remix
#name b) Crumbled Palace Cocktails
#subgroup |cFFFCDC00(10-80+)|r Sojourner
#displayname |cFF00CCFF1|r - Crumbled Palace Cocktails
#internal

step
    #completewith Crumbled Palace Cocktails
    #hidewindow
    +test
    .use 245925 -- Artifactium Sand
    .use 249891 -- Mound of Artifactium Sand
    .use 246937 -- Perfected Epoch Memento
    .use 242516 -- Memento of Epoch Legends
    .use 238726 -- Drake Treat
    .use 217956 -- Timeless Scroll of Summoning
    .use 217730 -- Timeless Scroll of Chaos
    .use 217606 -- Timeless Scroll of Fortitude
    .use 217731 -- Timeless Scroll of Mystic Power
    .use 217608 -- Timeless Scroll of Battle Shout
    .use 217901 -- Timeless Drums
    .use 217607 -- Timeless Scroll of the Wild
    .use 217929 -- Timeless Scroll of Cleansing
    .use 246936 -- Resonant Epoch Memento
    .use 249786 -- Dreamweaver Champion's Insignia
    .use 249787 -- Court of Farondis Champion's Insignia
    .use 249785 -- Highmountain Tribe Champion's Insignia
    .use 249783 -- Nightfallen Champion's Insignia
    .use 249781 -- Wardens Champion's Insignia
    .use 249780 -- Army of the Light Champion's Insignia
    .use 249782 -- Valarjar Champion's Insignia
    .use 249784 -- Legionfall Champion's Insignia
    .use 249788 -- Argussian Reach Champion's Insignia
    .usespell 1241425 -- Temporal Retreat
step
    #label CrumbledPalaceCocktailsA
    .goto 630,47.10,41.41
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Magister Garuhod|r
    .accept 37727 >>Accept The Magister of Mixology
    .accept 37728 >>Accept Presentation is Everything
    .target Magister Garuhod
step
    .goto 630,51.76,32.84
    >>Kill |cRXP_ENEMY_Gangamesh|r |cRXP_WARN_in the cave|r. Loot it for the |T237297:0|t[|cRXP_LOOT_The Six Eyes of Gangamesh|r].
    .complete 37728,1 --1/1 The Six Eyes of Gangamesh
    .mob Gangamesh
step
    #label CrumbledPalaceCocktailsB
    #loop
    .goto 630,51.54,33.46,12,0
    .goto 630,51.79,33.73,12,0
    .goto 630,52.07,34.53,12,0
    .goto 630,52.61,34.49,12,0
    .goto 630,52.64,33.58,12,0
    .goto 630,52.81,33.07,12,0
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Arcane-Infused Eggs|r
    .complete 37727,1 --6/6 Arcane-Infused Egg
step
    #label Crumbled Palace Cocktails
    .goto 630,47.10,41.41
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Magister Garuhod|r
    .turnin 37727 >>Turn in The Magister of Mixology
    .turnin 37728 >>Turn in Presentation is Everything
    .target Magister Garuhod
]])

--Felblaze Ingress
RXPGuides.RegisterGuide([[
#retail
#version 1
#chapter
#group RestedXP Legion Remix
#name b) Felblaze Ingress
#subgroup |cFFFCDC00(10-80+)|r Sojourner
#displayname |cFF00CCFF6|r - Felblaze Ingress
#internal

step
    #label FelblazeIngressA
    .goto 630,63.85,28.93
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tehd Shoemaker|r
    .accept 42375 >>Accept Eye See You
    .target Tehd Shoemaker
step
    .isOnQuest 42375
    .goto 630,63.85,28.99
    .aura 212754,1 >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Eye of Kilrogg|r
    .target Eye of Kilrogg
step
    .goto 630,67.16,30.27
    >>|cRXP_WARN_The AddOn can't track your position while inside the eye|r
    >>|cRXP_WARN_Avoid the |cRXP_ENEMY_Eyes of Zoth|r
    .complete 42375,3 --1/1 Commander found
step
    .goto 630,66.97,27.78
    >>|cRXP_WARN_The AddOn can't track your position while inside the eye|r
    >>|cRXP_WARN_Avoid the |cRXP_ENEMY_Eyes of Zoth|r
    .complete 42375,1 --1/1 Main Portal scouted
step
    .goto 630,67.65,24.88
    >>|cRXP_WARN_The AddOn can't track your position while inside the eye|r
    >>|cRXP_WARN_Avoid the |cRXP_ENEMY_Eyes of Zoth|r
    .complete 42375,2 --1/1 Ritual site found
step
    #completewith next
    #label EyeSeeYouA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tehd Shoemaker|r
    .turnin 42375 >>Turn in Eye See You
    .accept 42369 >>Accept They're Doing it Wrong
    .target Tehd Shoemaker
step
    #completewith EyeSeeYouA
    .isOnQuest 42375
    .aura -212754 >>Cancel the buff
    .macro Cancel Bull,136155 >>/cancelaura 212754
step
    #requires EyeSeeYouA
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Tehd Shoemaker|r and |cRXP_FRIENDLY_Marius Felbane|r
    .turnin 42375 >>Turn in Eye See You
    .accept 42369 >>Accept They're Doing it Wrong
    .goto 630,63.85,28.94
    .target +Tehd Shoemaker
    .accept 42368 >>Accept Quantity Over Quality
    .accept 42367 >>Accept Arkethrax
    .goto 630,63.87,28.88
    .target +Marius Felbane
step
    #completewith TheyreDoingItWrongA
    >>Kill |cRXP_ENEMY_Felblaze demons|r
    .complete 42368,1 --10/10 Felblaze demons slain
    .mob Felblaze demons
    .mob Eredar Riftweaver
    .mob Felguard Invader
    .mob Chaos Spawn
step
    .goto 630,67.25,30.70
    >>Kill |cRXP_ENEMY_Arkethrax|r
    .complete 42367,1 --1/1 Arkethrax slain
    .mob Arkethrax
step
    #loop
    .goto 630,66.96,28.30,15,0
    .goto 630,66.86,27.36,15,0
    .goto 630,67.73,27.06,15,0
    .goto 630,67.87,28.12,15,0
    #label TheyreDoingItWrongA
    >>|TInterface/cursor/crosshair/interact.blp:20|tClick on the |cRXP_PICK_Sabotaged Portal Stabilizers|r
    .complete 42369,1 --4/4 Sabotaged Portal Stabilizers placed
step
    #label FelblazeIngressY
    #loop
    .goto 630,64.92,30.74,35,0
    .goto 630,66.09,24.49,35,0
    .goto 630,68.35,24.41,45,0
    >>Kill |cRXP_ENEMY_Felblaze demons|r
    .complete 42368,1 --10/10 Felblaze demons slain
    .mob Felblaze demons
    .mob Eredar Riftweaver
    .mob Felguard Invader
    .mob Chaos Spawn
step
    #label FelblazeIngressZ
    >>|Tinterface/worldmap/chatbubble_64grey.blp:20|tTalk to |cRXP_FRIENDLY_Marius Felbane|r and |cRXP_FRIENDLY_Tehd Shoemaker|r
    .turnin 42368 >>Turn in Quantity Over Quality
    .turnin 42367 >>Turn in Arkethrax
    .goto 630,63.87,28.88
    .target +Marius Felbane
    .turnin 42369 >>Turn in They're Doing it Wrong
    .goto 630,63.85,28.94
    .target +Tehd Shoemaker
]])

-- ================================================= -
-- ==============  GROUP: SPEED LEVELING: ========== -
-- ================================================= -

---Tips & Tricks
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name 2b) Tips & Tricks
#displayname |cFF8888880|r - Tips & Tricks|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next b) Intro

step
    #include RestedXP Legion Remix\1a) Tips & Tricks

]])

---Intro
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name b) Intro
#displayname |cFF00FF001|r - Intro|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next ba) Skyriding

step
    #include RestedXP Legion Remix\a) Intro
]])

---Skyriding
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#name ba) Skyriding
#displayname |cFF00FF002|r - Skyriding|r
#next bb) Order Hall Death Knight Part 1 << Death Knight
#next bb) Order Hall Demon Hunter Part 1 << Demon Hunter
#next bb) Order Hall Druid Part 1 << Druid
#next bb) Order Hall Hunter Part 1 << Hunter
#next bb) Order Hall Mage Part 1 << Mage
#next bb) Order Hall Monk Part 1 << Monk
#next bb) Order Hall Paladin Part 1 << Paladin
#next bb) Order Hall Priest Part 1 << Priest
#next bb) Order Hall Rogue Part 1 << Rogue
#next bb) Order Hall Shaman Part 1<< Shaman
#next bb) Order Hall Warlock Part 1 << Warlock
#next bb) Order Hall Warrior Part 1 << Warrior

step
    #include RestedXP Legion Remix\aa) Skyriding
]])

---Monk Part 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#name bb) Order Hall Monk Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#next bc) Order Hall Monk Part 2

<< Monk

step
    #include RestedXP Legion Remix\ab) Order Hall Monk Part 1
]])

---Monk Part 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#name bc) Order Hall Monk Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#next bd) Infinite Bazaar

<< Monk

step
    #include RestedXP Legion Remix\ac) Order Hall Monk Part 2
]])

---Death Knight 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bb) Order Hall Death Knight Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bc) Order Hall Death Knight Part 2

<< DeathKnight

step
    #include ab) Order Hall Death Knight Part 1

]])

---Death Knight 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bc) Order Hall Death Knight Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bd) Infinite Bazaar

<< DeathKnight

step
    #include ac) Order Hall Death Knight Part 2

]])

---Demon Hunter 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bb) Order Hall Demon Hunter Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bc) Order Hall Demon Hunter Part 2

<< Demon Hunter

step
    #include RestedXP Legion Remix\ab) Order Hall Demon Hunter Part 1


]])

---Demon Hunter 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bc) Order Hall Demon Hunter Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bd) Infinite Bazaar

<< Demon Hunter

step
    #include RestedXP Legion Remix\ac) Order Hall Demon Hunter Part 2


]])

---Druid 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bb) Order Hall Druid Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bc) Order Hall Druid Part 2

<< Druid

step
    #include RestedXP Legion Remix\ab) Order Hall Druid Part 1
]])

---Druid 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bc) Order Hall Druid Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bd) Infinite Bazaar

<< Druid

step
    #include RestedXP Legion Remix\ac) Order Hall Druid Part 2
]])

---Hunter 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bb) Order Hall Hunter Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bc) Order Hall Druid Part 2

<< Hunter

step
    #include RestedXP Legion Remix\ab) Order Hall Hunter Part 1
]])

---Hunter 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bc) Order Hall Hunter Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bd) Infinite Bazaar

<< Hunter

step
    #include RestedXP Legion Remix\ac) Order Hall Hunter Part 2
]])

---Mage 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bb) Order Hall Mage Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bc) Order Hall Mage Part 2

<< Mage

step
    #include RestedXP Legion Remix\ab) Order Hall Mage Part 1
]])

---Mage 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bc) Order Hall Mage Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bd) Infinite Bazaar

<< Mage

step
    #include RestedXP Legion Remix\ac) Order Hall Mage Part 2
]])

---Paladin 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bb) Order Hall Paladin Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bc) Order Hall Paladin Part 2

<< Paladin

step
    #include RestedXP Legion Remix\ab) Order Hall Paladin Part 1
]])

---Paladin 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bc) Order Hall Paladin Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bd) Infinite Bazaar

<< Paladin

step
    #include RestedXP Legion Remix\ac) Order Hall Paladin Part 2
]])

---Priest 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bb) Order Hall Priest Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bc) Order Hall Priest Part 2

<< Priest

step
    #include RestedXP Legion Remix\ab) Order Hall Priest Part 1
]])

---Priest 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bc) Order Hall Priest Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bd) Infinite Bazaar

<< Priest

step
    #include RestedXP Legion Remix\ac) Order Hall Priest Part 2
]])

---Rogue 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bb) Order Hall Rogue Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bc) Order Hall Rogue Part 2

<< Rogue

step
    #include RestedXP Legion Remix\ab) Order Hall Rogue Part 1


]])

---Rogue 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bc) Order Hall Rogue Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bd) Infinite Bazaar

<< Rogue

step
    #include RestedXP Legion Remix\ac) Order Hall Rogue Part 2


]])

---Shaman 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bb) Order Hall Shaman Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bc) Order Hall Shaman Part 2

<<Shaman

step
    #include RestedXP Legion Remix\ab) Order Hall Shaman Part 1
]])

---Shaman 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bc) Order Hall Shaman Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bd) Infinite Bazaar

<<Shaman

step
    #include RestedXP Legion Remix\ac) Order Hall Shaman Part 2
]])

---Warlock 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bb) Order Hall Warlock Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bc) Order Hall Warlock Part 2

<< Warlock

step
    #include RestedXP Legion Remix\ab) Order Hall Warlock Part 1
]])

---Warlock 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bc) Order Hall Warlock Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bd) Infinite Bazaar

<< Warlock

step
    #include RestedXP Legion Remix\ac) Order Hall Warlock Part 2
]])

---Warrior 1
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bb) Order Hall Warrior Part 1
#displayname |cFF00FF003|r - Order Hall Intro 1|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bc) Order Hall Warrior Part 2

<< Warrior

step
    #include RestedXP Legion Remix\ab) Order Hall Warrior Part 1
]])

---Warrior 2
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#name bc) Order Hall Warrior Part 2
#displayname |cFF00FF004|r - Order Hall Intro 2|r
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#next bd) Infinite Bazaar

<< Warrior

step
    #include RestedXP Legion Remix\ac) Order Hall Warrior Part 2
]])

---Infinite Bazaar
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#name bd) Infinite Bazaar
#displayname |cFF00FF005|r - Infinite Bazaar|r
#next be) First Zone

step
    #include RestedXP Legion Remix\ad) Infinite Bazaar
]])

---Azsuna
RXPGuides.RegisterGuide([[
#retail
#version 1
#group RestedXP Speed Leveling
#subgroup |cFFFCDC00(10-80)|r Legion Remix
#name be) First Zone
#displayname |cFF00FF006|r - Azsuna|r
#next cb) Val'sharah Speedrun

step
    #include RestedXP Legion Remix\ae) First Zone
]])