--[[--
	by ALA
--]]--
----------------------------------------------------------------------------------------------------
local __addon, __private = ...;
local MT = __private.MT;
local CT = __private.CT;
local VT = __private.VT;
local DT = __private.DT;

if CT.TOCVERSION >= 30000 or CT.TOCVERSION < 20500 then
	return;
end
-- if WOW_PROJECT_ID ~= WOW_PROJECT_BURNING_CRUSADE_CLASSIC then
-- 	return;
-- end

----------------------------------------------------------------------------------------------------

DT.MAX_LEVEL = 70;
DT.MAX_NUM_TIER = 9;
DT.MAX_NUM_COL = 4;
DT.MAX_NUM_TALENTS = 36;
DT.CUR_PHASE = 5;
--
DT.ClassSpec = {
	DRUID = {
		283,	--Balance,平衡
		281,	--Feral,野性战斗
		282,	--Restoration,恢复
	},
	HUNTER = {
		361,	--BeastMastery,野兽控制
		363,	--Marksmanship,射击
		362,	--Survival,生存
	},
	MAGE = {
		81,		--Arcane,奥术
		41,		--Fire,火焰
		61,		--Frost,冰霜
	},
	PALADIN = {
		382,	--Holy,神圣
		383,	--Protection,防护
		381,	--Discipline,惩戒
	},
	PRIEST = {
		201,	--Discipline,戒律
		202,	--Holy,神圣
		203,	--Shadow,暗影
	},
	ROGUE = {
		182,	--Assassination,刺杀
		181,	--Combat,战斗
		183,	--Subtlety,敏锐
	},
	SHAMAN = {
		261,	--Elemental,元素
		263,	--Enhancement,增强
		262,	--Restoration,恢复
	},
	WARLOCK = {
		302,	--Affliction,痛苦
		303,	--Demonology,恶魔学识
		301,	--Destruction,毁灭
	},
	WARRIOR = {
		161,	--Arms,武器
		164,	--Fury,狂怒
		163,	--Protection,防护
	},

};
--
	--	DT.TalentDB
	--1-----2----3---4---------5--------6-------7------8---------9--------10-----------11--------------------12
	--tier, col, id, maxPoint, reqTier, reqCol, reqId, Spell[5], texture, [icon index, req index in TreeTDB, req by index in TreeTDB](calculated after addon loaded)
--
DT.TalentDB = {
	DRUID = {
		[283] = {
			{ 0, 0,  762, 5, nil, nil,   nil, {  16814, 16815, 16816, 16817, 16818, }, "Interface\\Icons\\Spell_Nature_AbolishMagic", },
			{ 0, 1,  761, 1, nil, nil,   nil, {  16689,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_NaturesWrath", },
			{ 0, 2,  921, 4,   0,   1,   761, {  17245, 17247, 17248, 17249,   nil, }, "Interface\\Icons\\Spell_Nature_NaturesWrath", },
			{ 1, 0,  787, 3, nil, nil,   nil, {  16918, 16919, 16920,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_StrangleVines", },
			{ 1, 1, 1822, 2, nil, nil,   nil, {  35363, 35364,   nil,   nil,   nil, }, "Interface\\Icons\\INV_Staff_01", },
			{ 1, 2,  763, 2, nil, nil,   nil, {  16821, 16822,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_StarFall", },
			{ 2, 0,  782, 3, nil, nil,   nil, {  16836, 16839, 16840,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_Thorns", },
			{ 2, 2,  788, 1, nil, nil,   nil, {  5570,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_InsectSwarm", },
			{ 2, 3,  764, 2, nil, nil,   nil, {  16819, 16820,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_NatureTouchGrow", },
			{ 3, 1,  792, 5,   1,   1,  1822, {  16909, 16910, 16911, 16912, 16913, }, "Interface\\Icons\\Spell_Nature_Purge", },
			{ 3, 2,  784, 3, nil, nil,   nil, {  16850, 16923, 16924,   nil,   nil, }, "Interface\\Icons\\Spell_Arcane_StarFire", },
			{ 4, 0, 1782, 3, nil, nil,   nil, {  33589, 33590, 33591,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_LunarGuidance", },
			{ 4, 1,  789, 1, nil, nil,   nil, {  16880,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_NaturesBlessing", },
			{ 4, 2,  783, 3, nil, nil,   nil, {  16845, 16846, 16847,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_Sentinal", },
			{ 5, 1,  790, 5,   4,   1,   789, {  16896, 16897, 16899, 16900, 16901, }, "Interface\\Icons\\Spell_Nature_MoonGlow", },
			{ 5, 2, 1783, 2, nil, nil,   nil, {  33592, 33596,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_BalanceofPower", },
			{ 6, 0, 1784, 3, nil, nil,   nil, {  33597, 33599, 33956,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_Dreamstate", },
			{ 6, 1,  793, 1, nil, nil,   nil, {  24858,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_ForceOfNature", },
			{ 6, 2, 1785, 3, nil, nil,   nil, {  33600, 33601, 33602,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_FaerieFire", },
			{ 7, 1, 1786, 5, nil, nil,   nil, {  33603, 33604, 33605, 33606, 33607, }, "Interface\\Icons\\Ability_Druid_TwilightsWrath", },
			{ 8, 1, 1787, 1, nil, nil,   nil, {  33831,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_ForceofNature", },
		},
		[281] = {
			{ 0, 1,  796, 5, nil, nil,   nil, {  16934, 16935, 16936, 16937, 16938, }, "Interface\\Icons\\Ability_Hunter_Pet_Hyena", },
			{ 0, 2,  795, 5, nil, nil,   nil, {  16858, 16859, 16860, 16861, 16862, }, "Interface\\Icons\\Ability_Druid_DemoralizingRoar", },
			{ 1, 0,  799, 3, nil, nil,   nil, {  16947, 16948, 16949,   nil,   nil, }, "Interface\\Icons\\Ability_Ambush", },
			{ 1, 1,  797, 2, nil, nil,   nil, {  16940, 16941,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_Bash", },
			{ 1, 2,  794, 3, nil, nil,   nil, {  16929, 16930, 16931,   nil,   nil, }, "Interface\\Icons\\INV_Misc_Pelt_Bear_03", },
			{ 2, 0,  807, 2, nil, nil,   nil, {  17002, 24866,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_SpiritWolf", },
			{ 2, 1,  804, 1, nil, nil,   nil, {  16979,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_Pet_Bear", },
			{ 2, 2,  798, 3, nil, nil,   nil, {  16942, 16943, 16944,   nil,   nil, }, "Interface\\Icons\\INV_Misc_MonsterClaw_04", },
			{ 3, 0,  802, 2, nil, nil,   nil, {  16966, 16968,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_VampiricAura", },
			{ 3, 1,  803, 3, nil, nil,   nil, {  16972, 16974, 16975,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_Pet_Cat", },
			{ 3, 2,  801, 2,   2,   2,   798, {  37116, 37117,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Racial_Cannibalize", },
			{ 4, 0,  805, 2, nil, nil,   nil, {  16998, 16999,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_Ravage", },
			{ 4, 2, 1162, 1, nil, nil,   nil, {  16857,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_FaerieFire", },
			{ 4, 3, 1792, 2, nil, nil,   nil, {  33872, 33873,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_HealingInstincts", },
			{ 5, 1,  808, 5,   3,   1,   803, {  17003, 17004, 17005, 17006, 24894, }, "Interface\\Icons\\Spell_Holy_BlessingOfAgility", },
			{ 5, 2, 1794, 3, nil, nil,   nil, {  33853, 33855, 33856,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_Enrage", },
			{ 6, 0, 1793, 3, nil, nil,   nil, {  33851, 33852, 33957,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_PrimalTenacity", },
			{ 6, 1,  809, 1, nil, nil,   nil, {  17007,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_UnyeildingStamina", },
			{ 6, 2, 1798, 2,   6,   1,   809, {  34297, 34300,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_UnyeildingStamina", },
			{ 7, 2, 1795, 5, nil, nil,   nil, {  33859, 33866, 33867, 33868, 33869, }, "Interface\\Icons\\Ability_Druid_PredatoryInstincts", },
			{ 8, 1, 1796, 1,   6,   1,   809, {  33917,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_Mangle2", },
		},
		[282] = {
			{ 0, 1,  821, 5, nil, nil,   nil, {  17050, 17051, 17053, 17054, 17055, }, "Interface\\Icons\\Spell_Nature_Regeneration", },
			{ 0, 2,  822, 5, nil, nil,   nil, {  17056, 17058, 17059, 17060, 17061, }, "Interface\\Icons\\Spell_Holy_BlessingOfStamina", },
			{ 1, 0,  824, 5, nil, nil,   nil, {  17069, 17070, 17071, 17072, 17073, }, "Interface\\Icons\\Spell_Nature_HealingTouch", },
			{ 1, 1,  823, 5, nil, nil,   nil, {  17063, 17065, 17066, 17067, 17068, }, "Interface\\Icons\\Spell_Nature_HealingWaveGreater", },
			{ 1, 2,  826, 3, nil, nil,   nil, {  16833, 16834, 16835,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_WispSplode", },
			{ 2, 0,  829, 3, nil, nil,   nil, {  17106, 17107, 17108,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_WindWalkOn", },
			{ 2, 1,  841, 5, nil, nil,   nil, {  17118, 17119, 17120, 17121, 17122, }, "Interface\\Icons\\Ability_EyeOfTheOwl", },
			{ 2, 2,  827, 1, nil, nil,   nil, {  16864,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_CrystalBall", },
			{ 3, 1,  843, 5, nil, nil,   nil, {  24968, 24969, 24970, 24971, 24972, }, "Interface\\Icons\\Spell_Holy_ElunesGrace", },
			{ 3, 2,  830, 3, nil, nil,   nil, {  17111, 17112, 17113,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_Rejuvenation", },
			{ 4, 0,  831, 1,   2,   0,   829, {  17116,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_RavenForm", },
			{ 4, 1,  828, 5, nil, nil,   nil, {  17104, 24943, 24944, 24945, 24946, }, "Interface\\Icons\\Spell_Nature_ProtectionformNature", },
			{ 4, 3,  842, 2, nil, nil,   nil, {  17123, 17124,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_Tranquility", },
			{ 5, 0, 1788, 2, nil, nil,   nil, {  33879, 33880,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_EmpoweredTouch", },
			{ 5, 2,  825, 5,   3,   2,   830, {  17074, 17075, 17076, 17077, 17078, }, "Interface\\Icons\\Spell_Nature_ResistNature", },
			{ 6, 0, 1797, 3, nil, nil,   nil, {  34151, 34152, 34153,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_GiftoftheWaterSpirit", },
			{ 6, 1,  844, 1,   4,   1,   828, {  18562,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\INV_Relics_IdolofRejuvenation", },
			{ 6, 2, 1790, 3, nil, nil,   nil, {  33881, 33882, 33883,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_NaturalPerfection", },
			{ 7, 1, 1789, 5, nil, nil,   nil, {  33886, 33887, 33888, 33889, 33890, }, "Interface\\Icons\\Ability_Druid_EmpoweredRejuvination", },
			{ 8, 1, 1791, 1,   7,   1,  1789, {  33891,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_TreeofLife", },
		},
	},
	HUNTER = {
		[361] = {
			{ 0, 1, 1382, 5, nil, nil,   nil, {  19552, 19553, 19554, 19555, 19556, }, "Interface\\Icons\\Spell_Nature_RavenForm", },
			{ 0, 2, 1389, 5, nil, nil,   nil, {  19583, 19584, 19585, 19586, 19587, }, "Interface\\Icons\\Spell_Nature_Reincarnation", },
			{ 1, 0, 1624, 2, nil, nil,   nil, {  35029, 35030,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_SilentHunter", },
			{ 1, 1, 1381, 3, nil, nil,   nil, {  19549, 19550, 19551,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_AspectOfTheMonkey", },
			{ 1, 2, 1395, 3, nil, nil,   nil, {  19609, 19610, 19612,   nil,   nil, }, "Interface\\Icons\\INV_Misc_Pelt_Bear_03", },
			{ 1, 3, 1625, 2, nil, nil,   nil, {  24443, 19575,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_BeastSoothe", },
			{ 2, 0, 1384, 2, nil, nil,   nil, {  19559, 19560,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Mount_JungleTiger", },
			{ 2, 1, 1391, 1, nil, nil,   nil, {  19596,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_Dash", },
			{ 2, 2, 1396, 5, nil, nil,   nil, {  19616, 19617, 19618, 19619, 19620, }, "Interface\\Icons\\Ability_BullRush", },
			{ 3, 1, 1385, 2, nil, nil,   nil, {  19572, 19573,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_MendPet", },
			{ 3, 2, 1393, 5, nil, nil,   nil, {  19598, 19599, 19600, 19601, 19602, }, "Interface\\Icons\\INV_Misc_MonsterClaw_04", },
			{ 4, 0, 1388, 2, nil, nil,   nil, {  19578, 20895,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_DemoralizingRoar", },
			{ 4, 1, 1387, 1, nil, nil,   nil, {  19577,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Devour", },
			{ 4, 3, 1390, 2, nil, nil,   nil, {  19590, 19592,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_AbolishMagic", },
			{ 5, 0, 1799, 2, nil, nil,   nil, {  34453, 34454,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_AnimalHandler", },
			{ 5, 2, 1397, 5,   3,   2,  1393, {  19621, 19622, 19623, 19624, 19625, }, "Interface\\Icons\\INV_Misc_MonsterClaw_03", },
			{ 6, 0, 1800, 3, nil, nil,   nil, {  34455, 34459, 34460,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_FerociousInspiration", },
			{ 6, 1, 1386, 1,   4,   1,  1387, {  19574,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_FerociousBite", },
			{ 6, 2, 1801, 3, nil, nil,   nil, {  34462, 34464, 34465,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_CatlikeReflexes", },
			{ 7, 2, 1802, 5, nil, nil,   nil, {  34466, 34467, 34468, 34469, 34470, }, "Interface\\Icons\\Ability_Hunter_SerpentSwiftness", },
			{ 8, 1, 1803, 1,   6,   1,  1386, {  34692,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_BeastWithin", },
		},
		[362] = {
			{ 0, 0, 1623, 3, nil, nil,   nil, {  24293, 24294, 24295,   nil,   nil, }, "Interface\\Icons\\INV_Misc_Head_Dragon_Black", },
			{ 0, 1, 1301, 3, nil, nil,   nil, {  19151, 19152, 19153,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_PrayerOfHealing", },
			{ 0, 2, 1820, 3, nil, nil,   nil, {  19498, 19499, 19500,   nil,   nil, }, "Interface\\Icons\\Ability_TownWatch", },
			{ 0, 3, 1621, 2, nil, nil,   nil, {  19159, 19160,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Racial_BloodRage", },
			{ 1, 0, 1304, 3, nil, nil,   nil, {  19184, 19387, 19388,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_StrangleVines", },
			{ 1, 1, 1311, 5, nil, nil,   nil, {  19295, 19297, 19298, 19301, 19300, }, "Interface\\Icons\\Ability_Parry", },
			{ 1, 2, 1305, 3, nil, nil,   nil, {  19228, 19232, 19233,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_Trip", },
			{ 2, 0, 1306, 2, nil, nil,   nil, {  19239, 19245,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_TimeStop", },
			{ 2, 1, 1622, 5, nil, nil,   nil, {  19255, 19256, 19257, 19258, 19259, }, "Interface\\Icons\\Spell_Shadow_Twilight", },
			{ 2, 2, 1308, 1, nil, nil,   nil, {  19263,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Whirlwind", },
			{ 3, 0, 1322, 2, nil, nil,   nil, {  19376, 19377,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Ensnare", },
			{ 3, 1, 1310, 3, nil, nil,   nil, {  19290, 19294, 24283,   nil,   nil, }, "Interface\\Icons\\Ability_Kick", },
			{ 3, 3, 1309, 2, nil, nil,   nil, {  19286, 19287,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_FeignDeath", },
			{ 4, 0, 1810, 2, nil, nil,   nil, {  34494, 34496,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_SurvivalInstincts", },
			{ 4, 1, 1321, 3, nil, nil,   nil, {  19370, 19371, 19373,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_BlessingOfStamina", },
			{ 4, 2, 1312, 1,   2,   2,  1308, {  19306,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_Challange", },
			{ 5, 0, 1809, 3, nil, nil,   nil, {  34491, 34492, 34493,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_Resourcefulness", },
			{ 5, 2, 1303, 5, nil, nil,   nil, {  19168, 19180, 19181, 24296, 24297, }, "Interface\\Icons\\Spell_Nature_Invisibilty", },
			{ 6, 0, 1811, 3, nil, nil,   nil, {  34497, 34498, 34499,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_ThrilloftheHunt", },
			{ 6, 1, 1325, 1,   4,   1,  1321, {  19386,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\INV_Spear_02", },
			{ 6, 2, 1812, 3,   5,   2,  1303, {  34500, 34502, 34503,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_FindWeakness", },
			{ 7, 1, 1813, 5, nil, nil,   nil, {  34506, 34507, 34508, 34838, 34839, }, "Interface\\Icons\\Ability_Hunter_MasterTactitian", },
			{ 8, 1, 1814, 1,   7,   1,  1813, {  23989,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_Readiness", },
		},
		[363] = {
			{ 0, 1, 1341, 5, nil, nil,   nil, {  19407, 19412, 19413, 19414, 19415, }, "Interface\\Icons\\Spell_Frost_Stun", },
			{ 0, 2, 1344, 5, nil, nil,   nil, {  19426, 19427, 19429, 19430, 19431, }, "Interface\\Icons\\Ability_SearingArrow", },
			{ 1, 1, 1343, 5, nil, nil,   nil, {  19421, 19422, 19423, 19424, 19425, }, "Interface\\Icons\\Ability_Hunter_SniperShot", },
			{ 1, 2, 1342, 5, nil, nil,   nil, {  19416, 19417, 19418, 19419, 19420, }, "Interface\\Icons\\Spell_Frost_WizardMark", },
			{ 2, 0, 1818, 2, nil, nil,   nil, {  34950, 34954,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_GoForTheThroat", },
			{ 2, 1, 1346, 5, nil, nil,   nil, {  19454, 19455, 19456, 19457, 19458, }, "Interface\\Icons\\Ability_ImpalingBolt", },
			{ 2, 2, 1345, 1, nil, nil,   nil, {  19434,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\INV_Spear_07", },
			{ 2, 3, 1819, 2, nil, nil,   nil, {  34948, 34949,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_RapidKilling", },
			{ 3, 1, 1348, 5, nil, nil,   nil, {  19464, 19465, 19466, 19467, 19468, }, "Interface\\Icons\\Ability_Hunter_Quickshot", },
			{ 3, 2, 1349, 5,   2,   2,  1345, {  19485, 19487, 19488, 19489, 19490, }, "Interface\\Icons\\Ability_PierceDamage", },
			{ 4, 0, 1351, 3, nil, nil,   nil, {  35100, 35102, 35103,   nil,   nil, }, "Interface\\Icons\\Spell_Arcane_StarFire", },
			{ 4, 1, 1353, 1, nil, nil,   nil, {  19503,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_GolemStormBolt", },
			{ 4, 2, 1347, 3, nil, nil,   nil, {  19461, 19462, 24691,   nil,   nil, }, "Interface\\Icons\\Ability_UpgradeMoonGlaive", },
			{ 5, 0, 1804, 2, nil, nil,   nil, {  34475, 34476,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_CombatExperience", },
			{ 5, 3, 1362, 5, nil, nil,   nil, {  19507, 19508, 19509, 19510, 19511, }, "Interface\\Icons\\INV_Weapon_Rifle_06", },
			{ 6, 0, 1806, 3, nil, nil,   nil, {  34482, 34483, 34484,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_ZenArchery", },
			{ 6, 1, 1361, 1,   4,   1,  1353, {  19506,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_TrueShot", },
			{ 6, 2, 1821, 3,   4,   2,  1347, {  35104, 35110, 35111,   nil,   nil, }, "Interface\\Icons\\Ability_UpgradeMoonGlaive", },
			{ 7, 1, 1807, 5, nil, nil,   nil, {  34485, 34486, 34487, 34488, 34489, }, "Interface\\Icons\\Ability_Hunter_MasterMarksman", },
			{ 8, 1, 1808, 1,   7,   1,  1807, {  34490,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_TheBlackArrow", },
		},
	},
	MAGE = {
		[81] = {
			{ 0, 0,   74, 2, nil, nil,   nil, {  11210, 12592,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_DispelMagic", },
			{ 0, 1,   76, 5, nil, nil,   nil, {  11222, 12839, 12840, 12841, 12842, }, "Interface\\Icons\\Spell_Holy_Devotion", },
			{ 0, 2,   80, 5, nil, nil,   nil, {  11237, 12463, 12464, 16769, 16770, }, "Interface\\Icons\\Spell_Nature_StarFall", },
			{ 1, 0,   78, 2, nil, nil,   nil, {  6057,  6085,   nil,   nil,   nil, }, "Interface\\Icons\\INV_Wand_01", },
			{ 1, 1, 1650, 5, nil, nil,   nil, {  29441, 29444, 29445, 29446, 29447, }, "Interface\\Icons\\Spell_Nature_AstralRecalGroup", },
			{ 1, 2,   75, 5, nil, nil,   nil, {  11213, 12574, 12575, 12576, 12577, }, "Interface\\Icons\\Spell_Shadow_ManaBurn", },
			{ 2, 0,   82, 2, nil, nil,   nil, {  11247, 12606,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_AbolishMagic", },
			{ 2, 1,   81, 3, nil, nil,   nil, {  11242, 12467, 12469,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_WispSplode", },
			{ 2, 3,   85, 1, nil, nil,   nil, {  28574,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Arcane_ArcaneResilience", },
			{ 3, 0,   83, 2, nil, nil,   nil, {  11252, 12605,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_DetectLesserInvisibility", },
			{ 3, 1,   88, 2, nil, nil,   nil, {  11255, 12598,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_IceShock", },
			{ 3, 3, 1142, 3, nil, nil,   nil, {  18462, 18463, 18464,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_SiphonMana", },
			{ 4, 0, 1724, 2, nil, nil,   nil, {  31569, 31570,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Arcane_Blink", },
			{ 4, 1,   86, 1, nil, nil,   nil, {  12043,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_EnchantArmor", },
			{ 4, 3,   77, 5, nil, nil,   nil, {  11232, 12500, 12501, 12502, 12503, }, "Interface\\Icons\\Spell_Shadow_Charm", },
			{ 5, 0, 1726, 2, nil, nil,   nil, {  31574, 31575,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Arcane_PrismaticCloak", },
			{ 5, 1,  421, 3,   4,   1,    86, {  15058, 15059, 15060,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_Teleport", },
			{ 5, 2, 1725, 3,   1,   2,    75, {  31571, 31572, 31573,   nil,   nil, }, "Interface\\Icons\\Spell_Arcane_ArcanePotency", },
			{ 6, 0, 1727, 3, nil, nil,   nil, {  31579, 31582, 31583,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_StarFall", },
			{ 6, 1,   87, 1,   5,   1,   421, {  12042,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_Lightning", },
			{ 6, 2, 1826, 2, nil, nil,   nil, {  35578, 35581,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Arcane_ArcaneTorrent", },
			{ 7, 1, 1728, 5, nil, nil,   nil, {  31584, 31585, 31586, 31587, 31588, }, "Interface\\Icons\\Spell_Arcane_MindMastery", },
			{ 8, 1, 1729, 1, nil, nil,   nil, {  31589,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_Slow", },
		},
		[41] = {
			{ 0, 1,   26, 5, nil, nil,   nil, {  11069, 12338, 12339, 12340, 12341, }, "Interface\\Icons\\Spell_Fire_FlameBolt", },
			{ 0, 2,   30, 5, nil, nil,   nil, {  11103, 12357, 12358, 12359, 12360, }, "Interface\\Icons\\Spell_Fire_MeteorStorm", },
			{ 1, 0,   34, 5, nil, nil,   nil, {  11119, 11120, 12846, 12847, 12848, }, "Interface\\Icons\\Spell_Fire_Incinerate", },
			{ 1, 1,   28, 2, nil, nil,   nil, {  11100, 12353,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_Flare", },
			{ 1, 2,   27, 3, nil, nil,   nil, {  11078, 11080, 12342,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_Fireball", },
			{ 2, 0, 1141, 2, nil, nil,   nil, {  18459, 18460,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_FlameShock", },
			{ 2, 1,   31, 3, nil, nil,   nil, {  11108, 12349, 12350,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_SelfDestruct", },
			{ 2, 2,   29, 1, nil, nil,   nil, {  11366,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_Fireball02", },
			{ 2, 3,   23, 2, nil, nil,   nil, {  11083, 12351,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_Fire", },
			{ 3, 0,   25, 3, nil, nil,   nil, {  11095, 12872, 12873,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_SoulBurn", },
			{ 3, 1,   24, 2, nil, nil,   nil, {  11094, 13043,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_FireArmor", },
			{ 3, 3, 1639, 3, nil, nil,   nil, {  29074, 29075, 29076,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_MasterOfElements", },
			{ 4, 0, 1730, 3, nil, nil,   nil, {  31638, 31639, 31640,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_PlayingWithFire", },
			{ 4, 1,   33, 3, nil, nil,   nil, {  11115, 11367, 11368,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_WispHeal", },
			{ 4, 2,   32, 1,   2,   2,    29, {  11113,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_Excorcism_02", },
			{ 5, 0, 1731, 2, nil, nil,   nil, {  31641, 31642,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_BurningSpeed", },
			{ 5, 2,   35, 5, nil, nil,   nil, {  11124, 12378, 12398, 12399, 12400, }, "Interface\\Icons\\Spell_Fire_Immolation", },
			{ 6, 0, 1733, 3, nil, nil,   nil, {  34293, 34295, 34296,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_Burnout", },
			{ 6, 1,   36, 1,   4,   1,    33, {  11129,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_SealOfFire", },
			{ 6, 2, 1732, 2, nil, nil,   nil, {  31679, 31680,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_MoltenBlood", },
			{ 7, 2, 1734, 5, nil, nil,   nil, {  31656, 31657, 31658, 31659, 31660, }, "Interface\\Icons\\Spell_Fire_FlameBolt", },
			{ 8, 1, 1735, 1,   6,   1,    36, {  31661,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\INV_Misc_Head_Dragon_01", },
		},
		[61] = {
			{ 0, 0,   70, 2, nil, nil,   nil, {  11189, 28332,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_FrostWard", },
			{ 0, 1,   37, 5, nil, nil,   nil, {  11070, 12473, 16763, 16765, 16766, }, "Interface\\Icons\\Spell_Frost_FrostBolt02", },
			{ 0, 2, 1649, 3, nil, nil,   nil, {  29438, 29439, 29440,   nil,   nil, }, "Interface\\Icons\\Spell_Ice_MagicDamage", },
			{ 1, 0,   73, 5, nil, nil,   nil, {  11207, 12672, 15047, 15052, 15053, }, "Interface\\Icons\\Spell_Frost_IceShard", },
			{ 1, 1,   38, 3, nil, nil,   nil, {  11071, 12496, 12497,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_FrostArmor", },
			{ 1, 2,   62, 2, nil, nil,   nil, {  11165, 12475,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_FreezingBreath", },
			{ 1, 3,   65, 3, nil, nil,   nil, {  11175, 12569, 12571,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_Wisp", },
			{ 2, 0,   61, 3, nil, nil,   nil, {  11151, 12952, 12953,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_Frostbolt", },
			{ 2, 1,   69, 1, nil, nil,   nil, {  12472,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_ColdHearted", },
			{ 2, 3,   63, 3, nil, nil,   nil, {  11185, 12487, 12488,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_IceStorm", },
			{ 3, 0,  741, 2, nil, nil,   nil, {  16757, 16758,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_DarkRitual", },
			{ 3, 1,   66, 3, nil, nil,   nil, {  11160, 12518, 12519,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_Stun", },
			{ 3, 2,   67, 5,   1,   2,    62, {  11170, 12982, 12983, 12984, 12985, }, "Interface\\Icons\\Spell_Frost_FrostShock", },
			{ 4, 0, 1736, 3, nil, nil,   nil, {  31667, 31668, 31669,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_FrozenCore", },
			{ 4, 1,   72, 1, nil, nil,   nil, {  11958,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_WizardMark", },
			{ 4, 2,   64, 3, nil, nil,   nil, {  11190, 12489, 12490,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_Glacier", },
			{ 5, 0, 1737, 2, nil, nil,   nil, {  31670, 31672,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_IceFloes", },
			{ 5, 2,   68, 5, nil, nil,   nil, {  11180, 28592, 28593, 28594, 28595, }, "Interface\\Icons\\Spell_Frost_ChillingBlast", },
			{ 6, 1,   71, 1,   4,   1,    72, {  11426,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Ice_Lament", },
			{ 6, 2, 1738, 5, nil, nil,   nil, {  31674, 31675, 31676, 31677, 31678, }, "Interface\\Icons\\Spell_Frost_ArcticWinds", },
			{ 7, 1, 1740, 5, nil, nil,   nil, {  31682, 31683, 31684, 31685, 31686, }, "Interface\\Icons\\Spell_Frost_FrostBolt02", },
			{ 8, 1, 1741, 1, nil, nil,   nil, {  31687,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_SummonWaterElemental_2", },
		},
	},
	PALADIN = {
		[382] = {
			{ 0, 1, 1450, 5, nil, nil,   nil, {  20262, 20263, 20264, 20265, 20266, }, "Interface\\Icons\\Ability_GolemThunderClap", },
			{ 0, 2, 1449, 5, nil, nil,   nil, {  20257, 20258, 20259, 20260, 20261, }, "Interface\\Icons\\Spell_Nature_Sleep", },
			{ 1, 1, 1432, 5, nil, nil,   nil, {  20205, 20206, 20207, 20209, 20208, }, "Interface\\Icons\\Spell_Arcane_Blink", },
			{ 1, 2, 1463, 5, nil, nil,   nil, {  20224, 20225, 20330, 20331, 20332, }, "Interface\\Icons\\Ability_ThunderBolt", },
			{ 2, 0, 1444, 3, nil, nil,   nil, {  20237, 20238, 20239,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_HolyBolt", },
			{ 2, 1, 1435, 1, nil, nil,   nil, {  31821,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_AuraMastery", },
			{ 2, 2, 1443, 2, nil, nil,   nil, {  20234, 20235,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_LayOnHands", },
			{ 2, 3, 1628, 2, nil, nil,   nil, {  9453, 25836,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_UnyieldingFaith", },
			{ 3, 1, 1461, 5, nil, nil,   nil, {  20210, 20212, 20213, 20214, 20215, }, "Interface\\Icons\\Spell_Holy_GreaterHeal", },
			{ 3, 2, 1446, 2, nil, nil,   nil, {  20244, 20245,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_SealOfWisdom", },
			{ 4, 0, 1742, 3, nil, nil,   nil, {  31822, 31823, 31824,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_PureOfHeart", },
			{ 4, 1, 1433, 1,   3,   1,  1461, {  20216,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_Heal", },
			{ 4, 2, 1465, 3, nil, nil,   nil, {  20359, 20360, 20361,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_HealingAura", },
			{ 5, 0, 1743, 2, nil, nil,   nil, {  31825, 31826,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_PurifyingPower", },
			{ 5, 2, 1627, 5, nil, nil,   nil, {  5923,  5924,  5925,  5926, 25829, }, "Interface\\Icons\\Spell_Holy_Power", },
			{ 6, 0, 1745, 3, nil, nil,   nil, {  31833, 31835, 31836,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_LightsGrace", },
			{ 6, 1, 1502, 1,   4,   1,  1433, {  20473,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_SearingLight", },
			{ 6, 2, 1744, 3, nil, nil,   nil, {  31828, 31829, 31830,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_BlessedLife", },
			{ 7, 1, 1746, 5, nil, nil,   nil, {  31837, 31838, 31839, 31840, 31841, }, "Interface\\Icons\\Spell_Holy_HolyGuidance", },
			{ 8, 1, 1747, 1, nil, nil,   nil, {  31842,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_DivineIllumination", },
		},
		[383] = {
			{ 0, 1, 1422, 5, nil, nil,   nil, {  20138, 20139, 20140, 20141, 20142, }, "Interface\\Icons\\Spell_Holy_DevotionAura", },
			{ 0, 2, 1421, 5, nil, nil,   nil, {  20127, 20130, 20135, 20136, 20137, }, "Interface\\Icons\\Ability_Defend", },
			{ 1, 0, 1630, 3, nil, nil,   nil, {  20189, 20192, 20193,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_Ambush", },
			{ 1, 1, 1425, 2, nil, nil,   nil, {  20174, 20175,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_SealOfProtection", },
			{ 1, 3, 1423, 5, nil, nil,   nil, {  20143, 20144, 20145, 20146, 20147, }, "Interface\\Icons\\Spell_Holy_Devotion", },
			{ 2, 0, 1442, 1, nil, nil,   nil, {  20217,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Magic_MageArmor", },
			{ 2, 1, 1501, 3, nil, nil,   nil, {  20468, 20469, 20470,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_SealOfFury", },
			{ 2, 2, 1424, 3,   0,   2,  1421, {  20148, 20149, 20150,   nil,   nil, }, "Interface\\Icons\\INV_Shield_06", },
			{ 2, 3, 1629, 5, nil, nil,   nil, {  20096, 20097, 20098, 20099, 20100, }, "Interface\\Icons\\Spell_Magic_LesserInvisibilty", },
			{ 3, 0, 1748, 2, nil, nil,   nil, {  31844, 31845,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_Stoicism", },
			{ 3, 1, 1521, 3, nil, nil,   nil, {  20487, 20488, 20489,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_SealOfMight", },
			{ 3, 2, 1626, 3, nil, nil,   nil, {  20254, 20255, 20256,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_MindSooth", },
			{ 4, 0, 1749, 2, nil, nil,   nil, {  31846, 31847,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_ImprovedResistanceAuras", },
			{ 4, 1, 1431, 1, nil, nil,   nil, {  20911,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_LightningShield", },
			{ 4, 2, 1426, 5, nil, nil,   nil, {  20177, 20179, 20181, 20180, 20182, }, "Interface\\Icons\\Spell_Holy_BlessingOfStrength", },
			{ 5, 0, 1750, 2, nil, nil,   nil, {  31848, 31849,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_DivineIntervention", },
			{ 5, 2, 1429, 5, nil, nil,   nil, {  20196, 20197, 20198, 20199, 20200, }, "Interface\\Icons\\INV_Sword_20", },
			{ 6, 0, 1829, 2,   6,   1,  1430, {  41021, 41026,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_BlessingOfProtection", },
			{ 6, 1, 1430, 1,   4,   1,  1431, {  20925,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_BlessingOfProtection", },
			{ 6, 2, 1751, 5, nil, nil,   nil, {  31850, 31851, 31852, 31853, 31854, }, "Interface\\Icons\\Spell_Holy_ArdentDefender", },
			{ 7, 2, 1753, 5, nil, nil,   nil, {  31858, 31859, 31860, 31861, 31862, }, "Interface\\Icons\\Spell_Holy_WeaponMastery", },
			{ 8, 1, 1754, 1,   6,   1,  1430, {  31935,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_AvengersShield", },
		},
		[381] = {
			{ 0, 1, 1401, 5, nil, nil,   nil, {  20042, 20045, 20046, 20047, 20048, }, "Interface\\Icons\\Spell_Holy_FistOfJustice", },
			{ 0, 2, 1407, 5, nil, nil,   nil, {  20101, 20102, 20103, 20104, 20105, }, "Interface\\Icons\\Spell_Frost_WindWalkOn", },
			{ 1, 0, 1631, 2, nil, nil,   nil, {  25956, 25957,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_RighteousFury", },
			{ 1, 1, 1464, 3, nil, nil,   nil, {  20335, 20336, 20337,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_HolySmite", },
			{ 1, 2, 1403, 5, nil, nil,   nil, {  20060, 20061, 20062, 20063, 20064, }, "Interface\\Icons\\Ability_Parry", },
			{ 2, 0, 1633, 3, nil, nil,   nil, {  9452, 26016, 26021,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_Vindication", },
			{ 2, 1, 1411, 5, nil, nil,   nil, {  20117, 20118, 20119, 20120, 20121, }, "Interface\\Icons\\Spell_Holy_RetributionAura", },
			{ 2, 2, 1481, 1, nil, nil,   nil, {  20375,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_InnerRage", },
			{ 2, 3, 1634, 3, nil, nil,   nil, {  26022, 26023, 44414,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_PersuitofJustice", },
			{ 3, 0, 1632, 2, nil, nil,   nil, {  9799, 25988,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_EyeforanEye", },
			{ 3, 2, 1405, 2, nil, nil,   nil, {  20091, 20092,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_AuraOfLight", },
			{ 3, 3, 1755, 3, nil, nil,   nil, {  31866, 31867, 31868,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_Crusade", },
			{ 4, 0, 1410, 3, nil, nil,   nil, {  20111, 20112, 20113,   nil,   nil, }, "Interface\\Icons\\INV_Hammer_04", },
			{ 4, 2, 1409, 1, nil, nil,   nil, {  20218,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_MindVision", },
			{ 4, 3, 1756, 2,   4,   2,  1409, {  31869, 31870,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_MindVision", },
			{ 5, 1, 1402, 5,   2,   1,  1411, {  20049, 20056, 20057, 20058, 20059, }, "Interface\\Icons\\Ability_Racial_Avatar", },
			{ 5, 2, 1758, 3, nil, nil,   nil, {  31876, 31877, 31878,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_RighteousFury", },
			{ 6, 0, 1761, 3, nil, nil,   nil, {  32043, 35396, 35397,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_HolySmite", },
			{ 6, 1, 1441, 1, nil, nil,   nil, {  20066,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_PrayerOfHealing", },
			{ 6, 2, 1757, 3, nil, nil,   nil, {  31871, 31872, 31873,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_DivinePurpose", },
			{ 7, 1, 1759, 5,   6,   1,  1441, {  31879, 31880, 31881, 31882, 31883, }, "Interface\\Icons\\Spell_Holy_Fanaticism", },
			{ 8, 1, 1823, 1, nil, nil,   nil, {  35395,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_CrusaderStrike", },
		},
	},
	PRIEST = {
		[203] = {
			{ 0, 1,  465, 5, nil, nil,   nil, {  15270, 15335, 15336, 15337, 15338, }, "Interface\\Icons\\Spell_Shadow_Requiem", },
			{ 0, 2,  464, 5, nil, nil,   nil, {  15268, 15323, 15324, 15325, 15326, }, "Interface\\Icons\\Spell_Shadow_GatherShadows", },
			{ 1, 0,  466, 3, nil, nil,   nil, {  15318, 15272, 15320,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_ShadowWard", },
			{ 1, 1,  482, 2, nil, nil,   nil, {  15275, 15317,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_ShadowWordPain", },
			{ 1, 2,  463, 5, nil, nil,   nil, {  15260, 15327, 15328, 15329, 15330, }, "Interface\\Icons\\Spell_Shadow_BurningSpirit", },
			{ 2, 0,  542, 2, nil, nil,   nil, {  15392, 15448,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_PsychicScream", },
			{ 2, 1,  481, 5, nil, nil,   nil, {  15273, 15312, 15313, 15314, 15316, }, "Interface\\Icons\\Spell_Shadow_UnholyFrenzy", },
			{ 2, 2,  501, 1, nil, nil,   nil, {  15407,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_SiphonMana", },
			{ 3, 1,  483, 2, nil, nil,   nil, {  15274, 15311,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Magic_LesserInvisibilty", },
			{ 3, 2,  881, 2, nil, nil,   nil, {  17322, 17323,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_ChillTouch", },
			{ 3, 3,  461, 5, nil, nil,   nil, {  15257, 15331, 15332, 15333, 15334, }, "Interface\\Icons\\Spell_Shadow_BlackPlague", },
			{ 4, 0,  541, 1,   2,   0,   542, {  15487,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_ImpPhaseShift", },
			{ 4, 1,  484, 1, nil, nil,   nil, {  15286,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_UnsummonBuilding", },
			{ 4, 2, 1638, 2,   4,   1,   484, {  27839, 27840,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_ImprovedVampiricEmbrace", },
			{ 4, 3, 1777, 3, nil, nil,   nil, {  33213, 33214, 33215,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_FocusedMind", },
			{ 5, 0, 1781, 2, nil, nil,   nil, {  14910, 33371,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_GrimWard", },
			{ 5, 2,  462, 5, nil, nil,   nil, {  15259, 15307, 15308, 15309, 15310, }, "Interface\\Icons\\Spell_Shadow_Twilight", },
			{ 6, 1,  521, 1,   4,   1,   484, {  15473,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_Shadowform", },
			{ 6, 2, 1778, 5, nil, nil,   nil, {  33221, 33222, 33223, 33224, 33225, }, "Interface\\Icons\\Spell_Shadow_ShadowPower", },
			{ 7, 2, 1816, 5, nil, nil,   nil, {  33191, 33192, 33193, 33194, 33195, }, "Interface\\Icons\\Spell_Shadow_Misery", },
			{ 8, 1, 1779, 1,   6,   1,   521, {  34914,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_Stoicism", },
		},
		[202] = {
			{ 0, 0,  410, 2, nil, nil,   nil, {  14913, 15012,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_HealingFocus", },
			{ 0, 1,  406, 3, nil, nil,   nil, {  14908, 15020, 17191,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_Renew", },
			{ 0, 2,  401, 5, nil, nil,   nil, {  14889, 15008, 15009, 15010, 15011, }, "Interface\\Icons\\Spell_Holy_SealOfSalvation", },
			{ 1, 1,  411, 5, nil, nil,   nil, {  27900, 27901, 27902, 27903, 27904, }, "Interface\\Icons\\Spell_Holy_SpellWarding", },
			{ 1, 2, 1181, 5, nil, nil,   nil, {  18530, 18531, 18533, 18534, 18535, }, "Interface\\Icons\\Spell_Holy_SealOfWrath", },
			{ 2, 0,  442, 1, nil, nil,   nil, {  15237,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_HolyNova", },
			{ 2, 1, 1636, 3, nil, nil,   nil, {  27811, 27815, 27816,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_BlessedRecovery", },
			{ 2, 3,  361, 3, nil, nil,   nil, {  14892, 15362, 15363,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_LayOnHands", },
			{ 3, 0, 1635, 2, nil, nil,   nil, {  27789, 27790,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_Purify", },
			{ 3, 1,  408, 3, nil, nil,   nil, {  14912, 15013, 15014,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_Heal02", },
			{ 3, 2,  403, 2,   1,   2,  1181, {  14909, 15017,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_SearingLightPriest", },
			{ 4, 0,  413, 2, nil, nil,   nil, {  14911, 15018,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_PrayerOfHealing02", },
			{ 4, 1, 1561, 1, nil, nil,   nil, {  20711,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\INV_Enchant_EssenceEternalLarge", },
			{ 4, 2,  402, 5, nil, nil,   nil, {  14901, 15028, 15029, 15030, 15031, }, "Interface\\Icons\\Spell_Holy_SpiritualGuidence", },
			{ 5, 0, 1766, 2, nil, nil,   nil, {  33150, 33154,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_SurgeOfLight", },
			{ 5, 2,  404, 5, nil, nil,   nil, {  14898, 15349, 15354, 15355, 15356, }, "Interface\\Icons\\Spell_Nature_MoonGlow", },
			{ 6, 0, 1768, 3, nil, nil,   nil, {  34753, 34859, 34860,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_Fanaticism", },
			{ 6, 1, 1637, 1,   4,   1,  1561, {   724,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_SummonLightwell", },
			{ 6, 2, 1765, 3, nil, nil,   nil, {  33142, 33145, 33146,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_BlessedResillience", },
			{ 7, 1, 1767, 5, nil, nil,   nil, {  33158, 33159, 33160, 33161, 33162, }, "Interface\\Icons\\Spell_Holy_GreaterHeal", },
			{ 8, 1, 1815, 1, nil, nil,   nil, {  34861,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_CircleOfRenewal", },
		},
		[201] = {
			{ 0, 1,  342, 5, nil, nil,   nil, {  14522, 14788, 14789, 14790, 14791, }, "Interface\\Icons\\Spell_Magic_MageArmor", },
			{ 0, 2,  345, 5, nil, nil,   nil, {  14524, 14525, 14526, 14527, 14528, }, "Interface\\Icons\\INV_Wand_01", },
			{ 1, 0,  352, 5, nil, nil,   nil, {  14523, 14784, 14785, 14786, 14787, }, "Interface\\Icons\\Spell_Nature_ManaRegenTotem", },
			{ 1, 1,  344, 2, nil, nil,   nil, {  14749, 14767,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_WordFortitude", },
			{ 1, 2,  343, 3, nil, nil,   nil, {  14748, 14768, 14769,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_PowerWordShield", },
			{ 1, 3,  321, 2, nil, nil,   nil, {  14531, 14774,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_Tranquility", },
			{ 2, 0, 1769, 3, nil, nil,   nil, {  33167, 33171, 33172,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_Absolution", },
			{ 2, 1,  348, 1, nil, nil,   nil, {  14751,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_WindWalkOn", },
			{ 2, 2,  347, 3, nil, nil,   nil, {  14521, 14776, 14777,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_Sleep", },
			{ 3, 0,  346, 3, nil, nil,   nil, {  14747, 14770, 14771,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_InnerFire", },
			{ 3, 1,  341, 5, nil, nil,   nil, {  14520, 14780, 14781, 14782, 14783, }, "Interface\\Icons\\Ability_Hibernation", },
			{ 3, 3,  350, 2, nil, nil,   nil, {  14750, 14772,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_ManaBurn", },
			{ 4, 1, 1201, 5, nil, nil,   nil, {  18551, 18552, 18553, 18554, 18555, }, "Interface\\Icons\\Spell_Nature_EnchantArmor", },
			{ 4, 2,  351, 1,   2,   2,   347, {  14752,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_DivineSpirit", },
			{ 4, 3, 1770, 2,   4,   2,   351, {  33174, 33182,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_DivineSpirit", },
			{ 5, 0, 1771, 2, nil, nil,   nil, {  33186, 33190,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_FocusedPower", },
			{ 5, 2, 1202, 5, nil, nil,   nil, {  18544, 18547, 18548, 18549, 18550, }, "Interface\\Icons\\Spell_Nature_SlowingTotem", },
			{ 6, 0, 1858, 3, nil, nil,   nil, {  45234, 45243, 45244,   nil,   nil, }, "Interface\\Icons\\Spell_Arcane_FocusedPower", },
			{ 6, 1,  322, 1,   4,   1,  1201, {  10060,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_PowerInfusion", },
			{ 6, 2, 1773, 5, nil, nil,   nil, {  33201, 33202, 33203, 33204, 33205, }, "Interface\\Icons\\Spell_Holy_PowerWordShield", },
			{ 7, 1, 1772, 5, nil, nil,   nil, {  34908, 34909, 34910, 34911, 34912, }, "Interface\\Icons\\Spell_Arcane_MindMastery", },
			{ 8, 1, 1774, 1, nil, nil,   nil, {  33206,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_PainSupression", },
		},
	},
	ROGUE = {
		[182] = {
			{ 0, 0,  276, 3, nil, nil,   nil, {  14162, 14163, 14164,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_Eviscerate", },
			{ 0, 1,  272, 2, nil, nil,   nil, {  14144, 14148,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_FiegnDead", },
			{ 0, 2,  270, 5, nil, nil,   nil, {  14138, 14139, 14140, 14141, 14142, }, "Interface\\Icons\\Ability_Racial_BloodRage", },
			{ 1, 0,  273, 3, nil, nil,   nil, {  14156, 14160, 14161,   nil,   nil, }, "Interface\\Icons\\Ability_Druid_Disembowel", },
			{ 1, 1,  274, 2, nil, nil,   nil, {  14158, 14159,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_DeathScream", },
			{ 1, 3,  277, 3, nil, nil,   nil, {  13733, 13865, 13866,   nil,   nil, }, "Interface\\Icons\\Ability_BackStab", },
			{ 2, 0,  281, 1, nil, nil,   nil, {  14179,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_DecisiveStrike", },
			{ 2, 1,  278, 2, nil, nil,   nil, {  14168, 14169,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_Riposte", },
			{ 2, 2,  269, 5,   0,   2,   270, {  14128, 14132, 14135, 14136, 14137, }, "Interface\\Icons\\Ability_CriticalStrike", },
			{ 3, 1,  682, 5, nil, nil,   nil, {  16513, 16514, 16515, 16719, 16720, }, "Interface\\Icons\\Ability_Rogue_FeignDeath", },
			{ 3, 2,  268, 5, nil, nil,   nil, {  14113, 14114, 14115, 14116, 14117, }, "Interface\\Icons\\Ability_Poisons", },
			{ 4, 0, 1721, 2, nil, nil,   nil, {  31208, 31209,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_FleetFooted", },
			{ 4, 1,  280, 1, nil, nil,   nil, {  14177,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Ice_Lament", },
			{ 4, 2,  279, 3, nil, nil,   nil, {  14174, 14175, 14176,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_KidneyShot", },
			{ 4, 3, 1762, 2, nil, nil,   nil, {  31244, 31245,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_QuickRecovery", },
			{ 5, 1,  283, 5,   4,   1,   280, {  14186, 14190, 14193, 14194, 14195, }, "Interface\\Icons\\Spell_Shadow_ChillTouch", },
			{ 5, 2, 1715, 2, nil, nil,   nil, {  31226, 31227,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Creature_Poison_06", },
			{ 6, 1,  382, 1, nil, nil,   nil, {  14983,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_EarthBindTotem", },
			{ 6, 2, 1723, 5, nil, nil,   nil, {  31380, 31382, 31383, 31384, 31385, }, "Interface\\Icons\\Ability_Rogue_DeadenedNerves", },
			{ 7, 2, 1718, 5, nil, nil,   nil, {  31233, 31239, 31240, 31241, 31242, }, "Interface\\Icons\\Ability_Rogue_FindWeakness", },
			{ 8, 1, 1719, 1,   6,   1,   382, {  1329,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_ShadowStrikes", },
		},
		[181] = {
			{ 0, 0,  203, 3, nil, nil,   nil, {  13741, 13793, 13792,   nil,   nil, }, "Interface\\Icons\\Ability_Gouge", },
			{ 0, 1,  201, 2, nil, nil,   nil, {  13732, 13863,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_RitualOfSacrifice", },
			{ 0, 2,  186, 5, nil, nil,   nil, {  13712, 13788, 13789, 13790, 13791, }, "Interface\\Icons\\Spell_Nature_Invisibilty", },
			{ 1, 0, 1827, 3, nil, nil,   nil, {  14165, 14166, 14167,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_SliceDice", },
			{ 1, 1,  187, 5, nil, nil,   nil, {  13713, 13853, 13854, 13855, 13856, }, "Interface\\Icons\\Ability_Parry", },
			{ 1, 2,  181, 5, nil, nil,   nil, {  13705, 13832, 13843, 13844, 13845, }, "Interface\\Icons\\Ability_Marksmanship", },
			{ 2, 0,  204, 2, nil, nil,   nil, {  13742, 13872,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_ShadowWard", },
			{ 2, 1,  301, 1,   1,   1,   187, {  14251,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_Challange", },
			{ 2, 3,  222, 2, nil, nil,   nil, {  13743, 13875,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_Sprint", },
			{ 3, 0,  206, 2, nil, nil,   nil, {  13754, 13867,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Kick", },
			{ 3, 1,  182, 5, nil, nil,   nil, {  13706, 13804, 13805, 13806, 13807, }, "Interface\\Icons\\INV_Weapon_ShortBlade_05", },
			{ 3, 2,  221, 5,   1,   2,   181, {  13715, 13848, 13849, 13851, 13852, }, "Interface\\Icons\\Ability_DualWield", },
			{ 4, 0,  184, 5, nil, nil,   nil, {  13709, 13800, 13801, 13802, 13803, }, "Interface\\Icons\\INV_Mace_01", },
			{ 4, 1,  223, 1, nil, nil,   nil, {  13877,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_PunishingBlow", },
			{ 4, 2,  242, 5, nil, nil,   nil, {  13960, 13961, 13962, 13963, 13964, }, "Interface\\Icons\\INV_Sword_27", },
			{ 4, 3,  183, 5, nil, nil,   nil, {  13707, 13966, 13967, 13968, 13969, }, "Interface\\Icons\\INV_Gauntlets_04", },
			{ 5, 0, 1706, 2, nil, nil,   nil, {  31124, 31126,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_BladeTwisting", },
			{ 5, 1, 1703, 2,   4,   1,   223, {  30919, 30920,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_BlessingOfStrength", },
			{ 5, 2, 1122, 3, nil, nil,   nil, {  18427, 18428, 18429,   nil,   nil, }, "Interface\\Icons\\Ability_Racial_Avatar", },
			{ 6, 0, 1705, 2, nil, nil,   nil, {  31122, 31123,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_Revenge", },
			{ 6, 1,  205, 1, nil, nil,   nil, {  13750,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_ShadowWordDominate", },
			{ 6, 2, 1707, 2, nil, nil,   nil, {  31130, 31131,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_NervesOfSteel", },
			{ 7, 2, 1825, 5, nil, nil,   nil, {  35541, 35550, 35551, 35552, 35553, }, "Interface\\Icons\\INV_Weapon_Shortblade_38", },
			{ 8, 1, 1709, 1,   6,   1,   205, {  32601,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_SurpriseAttack", },
		},
		[183] = {
			{ 0, 1,  241, 5, nil, nil,   nil, {  13958, 13970, 13971, 13972, 13973, }, "Interface\\Icons\\Spell_Shadow_Charm", },
			{ 0, 2,  261, 5, nil, nil,   nil, {  14057, 14072, 14073, 14074, 14075, }, "Interface\\Icons\\Ability_Warrior_WarCry", },
			{ 1, 0, 1700, 2, nil, nil,   nil, {  30892, 30893,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_Feint", },
			{ 1, 1,  262, 2, nil, nil,   nil, {  14076, 14094,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Sap", },
			{ 1, 2,  244, 5, nil, nil,   nil, {  13975, 14062, 14063, 14064, 14065, }, "Interface\\Icons\\Ability_Stealth", },
			{ 2, 0,  245, 3, nil, nil,   nil, {  13976, 13979, 13980,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_Fumble", },
			{ 2, 1,  303, 1, nil, nil,   nil, {  14278,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_Curse", },
			{ 2, 2,  263, 3, nil, nil,   nil, {  14079, 14080, 14081,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_Ambush", },
			{ 3, 0,  246, 3, nil, nil,   nil, {  13983, 14070, 14071,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_MirrorImage", },
			{ 3, 1,  247, 2, nil, nil,   nil, {  13981, 14066,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Magic_LesserInvisibilty", },
			{ 3, 2, 1123, 3, nil, nil,   nil, {  14171, 14172, 14173,   nil,   nil, }, "Interface\\Icons\\INV_Sword_17", },
			{ 4, 0, 1701, 2, nil, nil,   nil, {  30894, 30895,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Ambush", },
			{ 4, 1,  284, 1, nil, nil,   nil, {  14185,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_AntiShadow", },
			{ 4, 2,  265, 2, nil, nil,   nil, {  14082, 14083,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_SummonSuccubus", },
			{ 4, 3,  681, 1,   3,   2,  1123, {  16511,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_LifeDrain", },
			{ 5, 0, 1713, 3, nil, nil,   nil, {  31221, 31222, 31223,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_MasterOfSubtlety", },
			{ 5, 2, 1702, 5, nil, nil,   nil, {  30902, 30903, 30904, 30905, 30906, }, "Interface\\Icons\\INV_Weapon_Crossbow_11", },
			{ 6, 0, 1711, 3, nil, nil,   nil, {  31211, 31212, 31213,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_EnvelopingShadows", },
			{ 6, 1,  381, 1,   4,   1,   284, {  14183,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_Possession", },
			{ 6, 2, 1722, 3, nil, nil,   nil, {  31228, 31229, 31230,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_CheatDeath", },
			{ 7, 1, 1712, 5,   6,   1,   381, {  31216, 31217, 31218, 31219, 31220, }, "Interface\\Icons\\Ability_Rogue_SinisterCalling", },
			{ 8, 1, 1714, 1, nil, nil,   nil, {  36554,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_Shadowstep", },
		},
	},
	SHAMAN = {
		[262] = {
			{ 0, 1,  586, 5, nil, nil,   nil, {  16182, 16226, 16227, 16228, 16229, }, "Interface\\Icons\\Spell_Nature_MagicImmunity", },
			{ 0, 2,  593, 5, nil, nil,   nil, {  16179, 16214, 16215, 16216, 16217, }, "Interface\\Icons\\Spell_Frost_ManaRecharge", },
			{ 1, 0,  589, 2, nil, nil,   nil, {  16184, 16209,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_Reincarnation", },
			{ 1, 1,  581, 3, nil, nil,   nil, {  16176, 16235, 16240,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_UndyingStrength", },
			{ 1, 2,  595, 5, nil, nil,   nil, {  16173, 16222, 16223, 16224, 16225, }, "Interface\\Icons\\Spell_Nature_MoonGlow", },
			{ 2, 0,  583, 3, nil, nil,   nil, {  16180, 16196, 16198,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_Stun", },
			{ 2, 1,  587, 5, nil, nil,   nil, {  16181, 16230, 16232, 16233, 16234, }, "Interface\\Icons\\Spell_Nature_HealingWaveLesser", },
			{ 2, 2,  582, 1, nil, nil,   nil, {  16189,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_NullWard", },
			{ 2, 3, 1646, 3, nil, nil,   nil, {  29187, 29189, 29191,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_HealingTouch", },
			{ 3, 1,  588, 5, nil, nil,   nil, {  16187, 16205, 16206, 16207, 16208, }, "Interface\\Icons\\Spell_Nature_ManaRegenTotem", },
			{ 3, 2,  594, 5, nil, nil,   nil, {  16194, 16218, 16219, 16220, 16221, }, "Interface\\Icons\\Spell_Nature_Tranquility", },
			{ 4, 0, 1648, 3, nil, nil,   nil, {  29206, 29205, 29202,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_HealingWay", },
			{ 4, 2,  591, 1, nil, nil,   nil, {  16188,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_RavenForm", },
			{ 4, 3, 1695, 3, nil, nil,   nil, {  30864, 30865, 30866,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_FocusedMind", },
			{ 5, 2,  592, 5, nil, nil,   nil, {  16178, 16210, 16211, 16212, 16213, }, "Interface\\Icons\\Spell_Frost_WizardMark", },
			{ 6, 1,  590, 1,   3,   1,   588, {  16190,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Frost_SummonWaterElemental", },
			{ 6, 2, 1699, 5, nil, nil,   nil, {  30881, 30883, 30884, 30885, 30886, }, "Interface\\Icons\\Spell_Nature_NatureGuardian", },
			{ 7, 1, 1696, 3, nil, nil,   nil, {  30867, 30868, 30869,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_NatureBlessing", },
			{ 7, 2, 1697, 2, nil, nil,   nil, {  30872, 30873,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_HealingWaveGreater", },
			{ 8, 1, 1698, 1,   7,   1,  1696, {   974,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_SkinofEarth", },
		},
		[263] = {
			{ 0, 1,  614, 5, nil, nil,   nil, {  17485, 17486, 17487, 17488, 17489, }, "Interface\\Icons\\Spell_Shadow_GrimWard", },
			{ 0, 2,  612, 5, nil, nil,   nil, {  16253, 16298, 16299, 16300, 16301, }, "Interface\\Icons\\INV_Shield_06", },
			{ 1, 0,  609, 2, nil, nil,   nil, {  16258, 16293,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_StoneSkinTotem", },
			{ 1, 1,  613, 5, nil, nil,   nil, {  16255, 16302, 16303, 16304, 16305, }, "Interface\\Icons\\Ability_ThunderBolt", },
			{ 1, 2,  605, 2, nil, nil,   nil, {  16262, 16287,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_SpiritWolf", },
			{ 1, 3,  607, 3, nil, nil,   nil, {  16261, 16290, 16291,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_LightningShield", },
			{ 2, 0,  610, 2, nil, nil,   nil, {  16259, 16295,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_EarthBindTotem", },
			{ 2, 2,  617, 1, nil, nil,   nil, {  43338,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_ElementalAbsorption", },
			{ 2, 3,  601, 5, nil, nil,   nil, {  16254, 16271, 16272, 16273, 16274, }, "Interface\\Icons\\Spell_Nature_MirrorImage", },
			{ 3, 1,  602, 5,   1,   1,   613, {  16256, 16281, 16282, 16283, 16284, }, "Interface\\Icons\\Ability_GhoulFrenzy", },
			{ 3, 2,  615, 5, nil, nil,   nil, {  16252, 16306, 16307, 16308, 16309, }, "Interface\\Icons\\Spell_Holy_Devotion", },
			{ 4, 0, 1647, 2, nil, nil,   nil, {  29192, 29193,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_EnchantWeapon", },
			{ 4, 1,  616, 1, nil, nil,   nil, {  16268,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Parry", },
			{ 4, 2,  611, 3, nil, nil,   nil, {  16266, 29079, 29080,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_FlameTounge", },
			{ 5, 0, 1691, 3, nil, nil,   nil, {  30812, 30813, 30814,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_MentalQuickness", },
			{ 5, 3, 1643, 5, nil, nil,   nil, {  29082, 29084, 29086, 29087, 29088, }, "Interface\\Icons\\Ability_Hunter_SwiftStrike", },
			{ 6, 0, 1692, 3,   6,   1,  1690, {  30816, 30818, 30819,   nil,   nil, }, "Interface\\Icons\\Ability_DualWieldSpecialization", },
			{ 6, 1, 1690, 1,   4,   1,   616, {  30798,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_DualWield", },
			{ 6, 2,  901, 1,   4,   2,   611, {  17364,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Shaman_Stormstrike", },
			{ 7, 1, 1689, 5, nil, nil,   nil, {  30802, 30808, 30809, 30810, 30811, }, "Interface\\Icons\\Spell_Nature_UnleashedRage", },
			{ 8, 1, 1693, 1, nil, nil,   nil, {  30823,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_ShamanRage", },
		},
		[261] = {
			{ 0, 1,  564, 5, nil, nil,   nil, {  16039, 16109, 16110, 16111, 16112, }, "Interface\\Icons\\Spell_Nature_WispSplode", },
			{ 0, 2,  563, 5, nil, nil,   nil, {  16035, 16105, 16106, 16107, 16108, }, "Interface\\Icons\\Spell_Fire_Fireball", },
			{ 1, 0,  572, 2, nil, nil,   nil, {  16043, 16130,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_StoneClawTotem", },
			{ 1, 1, 1640, 3, nil, nil,   nil, {  28996, 28997, 28998,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_SpiritArmor", },
			{ 1, 2,  561, 3, nil, nil,   nil, {  16038, 16160, 16161,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_Immolation", },
			{ 2, 0,  574, 1, nil, nil,   nil, {  16164,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_ManaBurn", },
			{ 2, 1,  575, 5, nil, nil,   nil, {  16040, 16113, 16114, 16115, 16116, }, "Interface\\Icons\\Spell_Frost_FrostWard", },
			{ 2, 2,  562, 5, nil, nil,   nil, {  16041, 16117, 16118, 16119, 16120, }, "Interface\\Icons\\Spell_Nature_CallStorm", },
			{ 3, 0,  567, 2, nil, nil,   nil, {  16086, 16544,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_SealOfFire", },
			{ 3, 1, 1642, 3, nil, nil,   nil, {  29062, 29064, 29065,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_SoulLeech_2", },
			{ 3, 3, 1645, 3, nil, nil,   nil, {  30160, 29179, 29180,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_ElementalDevastation", },
			{ 4, 0, 1641, 2, nil, nil,   nil, {  28999, 29000,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_StormReach", },
			{ 4, 1,  565, 1, nil, nil,   nil, {  16089,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_Volcano", },
			{ 4, 3, 1682, 5, nil, nil,   nil, {  30664, 30665, 30666, 30667, 30668, }, "Interface\\Icons\\Spell_Nature_UnrelentingStorm", },
			{ 5, 0, 1685, 3, nil, nil,   nil, {  30672, 30673, 30674,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_ElementalPrecision_1", },
			{ 5, 2,  721, 5,   2,   2,   562, {  16578, 16579, 16580, 16581, 16582, }, "Interface\\Icons\\Spell_Lightning_LightningBolt01", },
			{ 6, 1,  573, 1,   4,   1,   565, {  16166,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_WispHeal", },
			{ 6, 2, 1683, 3, nil, nil,   nil, {  30669, 30670, 30671,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_ElementalShields", },
			{ 7, 1, 1686, 5, nil, nil,   nil, {  30675, 30678, 30679, 30680, 30681, }, "Interface\\Icons\\Spell_Nature_LightningOverload", },
			{ 8, 1, 1687, 1,   7,   1,  1686, {  30706,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_TotemOfWrath", },
		},
	},
	WARLOCK = {
		[301] = {
			{ 0, 1,  944, 5, nil, nil,   nil, {  17793, 17796, 17801, 17802, 17803, }, "Interface\\Icons\\Spell_Shadow_ShadowBolt", },
			{ 0, 2,  941, 5, nil, nil,   nil, {  17778, 17779, 17780, 17781, 17782, }, "Interface\\Icons\\Spell_Fire_WindsofWoe", },
			{ 1, 1,  943, 5, nil, nil,   nil, {  17788, 17789, 17790, 17791, 17792, }, "Interface\\Icons\\Spell_Shadow_DeathPact", },
			{ 1, 2,  982, 5, nil, nil,   nil, {  18119, 18120, 18121, 18122, 18123, }, "Interface\\Icons\\Spell_Fire_Fire", },
			{ 2, 0,  983, 2, nil, nil,   nil, {  18126, 18127,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_FireBolt", },
			{ 2, 1,  984, 2, nil, nil,   nil, {  18128, 18129,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_Curse", },
			{ 2, 2,  981, 5, nil, nil,   nil, {  18130, 18131, 18132, 18133, 18134, }, "Interface\\Icons\\Spell_Fire_FlameShock", },
			{ 2, 3,  963, 1, nil, nil,   nil, {  17877,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_ScourgeBuild", },
			{ 3, 0,  985, 2, nil, nil,   nil, {  18135, 18136,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_LavaSpawn", },
			{ 3, 1,  964, 2, nil, nil,   nil, {  17917, 17918,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_CorpseExplode", },
			{ 3, 3,  965, 3, nil, nil,   nil, {  17927, 17929, 17930,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_SoulBurn", },
			{ 4, 0,  986, 2,   3,   0,   985, {  18096, 18073,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_Volcano", },
			{ 4, 1,  961, 5, nil, nil,   nil, {  17815, 17833, 17834, 17835, 17836, }, "Interface\\Icons\\Spell_Fire_Immolation", },
			{ 4, 2,  967, 1,   2,   2,   981, {  17959,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_ShadowWordPain", },
			{ 5, 0, 1679, 3, nil, nil,   nil, {  30299, 30301, 30302,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_NetherProtection", },
			{ 5, 2,  966, 5, nil, nil,   nil, {  17954, 17955, 17956, 17957, 17958, }, "Interface\\Icons\\Spell_Fire_SelfDestruct", },
			{ 6, 0, 1817, 3, nil, nil,   nil, {  34935, 34938, 34939,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_PlayingWithFire", },
			{ 6, 1,  968, 1,   4,   1,   961, {  17962,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Fire_Fireball", },
			{ 6, 2, 1678, 3, nil, nil,   nil, {  30293, 30295, 30296,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_SoulLeech_3", },
			{ 7, 1, 1677, 5, nil, nil,   nil, {  30288, 30289, 30290, 30291, 30292, }, "Interface\\Icons\\Spell_Shadow_ShadowandFlame", },
			{ 8, 1, 1676, 1,   7,   1,  1677, {  30283,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_Shadowfury", },
		},
		[302] = {
			{ 0, 1, 1005, 5, nil, nil,   nil, {  18174, 18175, 18176, 18177, 18178, }, "Interface\\Icons\\Spell_Shadow_UnsummonBuilding", },
			{ 0, 2, 1003, 5, nil, nil,   nil, {  17810, 17811, 17812, 17813, 17814, }, "Interface\\Icons\\Spell_Shadow_AbominationExplosion", },
			{ 1, 0, 1006, 2, nil, nil,   nil, {  18179, 18180,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_CurseOfMannoroth", },
			{ 1, 1, 1101, 2, nil, nil,   nil, {  18213, 18372,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_Haunting", },
			{ 1, 2, 1007, 2, nil, nil,   nil, {  18182, 18183,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_BurningSpirit", },
			{ 1, 3, 1004, 2, nil, nil,   nil, {  17804, 17805,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_LifeDrain02", },
			{ 2, 0, 1284, 2, nil, nil,   nil, {  18827, 18829,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_CurseOfSargeras", },
			{ 2, 1, 1001, 5, nil, nil,   nil, {  17783, 17784, 17785, 17786, 17787, }, "Interface\\Icons\\Spell_Shadow_FingerOfDeath", },
			{ 2, 2, 1061, 1, nil, nil,   nil, {  18288,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_Contagion", },
			{ 3, 0, 1021, 2, nil, nil,   nil, {  18218, 18219,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_CallofBone", },
			{ 3, 1, 1002, 2, nil, nil,   nil, {  18094, 18095,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_Twilight", },
			{ 3, 3, 1764, 3, nil, nil,   nil, {  32381, 32382, 32383,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_AbominationExplosion", },
			{ 4, 0, 1763, 5, nil, nil,   nil, {  32385, 32387, 32392, 32393, 32394, }, "Interface\\Icons\\Spell_Shadow_ShadowEmbrace", },
			{ 4, 1, 1041, 1, nil, nil,   nil, {  18265,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_Requiem", },
			{ 4, 2, 1081, 1,   2,   2,  1061, {  18223,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_GrimWard", },
			{ 5, 1, 1042, 5,   4,   1,  1041, {  18271, 18272, 18273, 18274, 18275, }, "Interface\\Icons\\Spell_Shadow_ShadeTrueSight", },
			{ 6, 1, 1669, 5, nil, nil,   nil, {  30060, 30061, 30062, 30063, 30064, }, "Interface\\Icons\\Spell_Shadow_PainfulAfflictions", },
			{ 6, 2, 1022, 1, nil, nil,   nil, {  18220,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_DarkRitual", },
			{ 7, 0, 1668, 2, nil, nil,   nil, {  30054, 30057,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_DeathScream", },
			{ 7, 2, 1667, 3, nil, nil,   nil, {  32477, 32483, 32484,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_CurseOfAchimonde", },
			{ 8, 1, 1670, 1,   6,   1,  1669, {  30108,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_UnstableAffliction_3", },
		},
		[303] = {
			{ 0, 0, 1221, 2, nil, nil,   nil, {  18692, 18693,   nil,   nil,   nil, }, "Interface\\Icons\\INV_Stone_04", },
			{ 0, 1, 1222, 3, nil, nil,   nil, {  18694, 18695, 18696,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_SummonImp", },
			{ 0, 2, 1223, 5, nil, nil,   nil, {  18697, 18698, 18699, 18700, 18701, }, "Interface\\Icons\\Spell_Shadow_Metamorphosis", },
			{ 1, 0, 1224, 2, nil, nil,   nil, {  18703, 18704,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_LifeDrain", },
			{ 1, 1, 1225, 3, nil, nil,   nil, {  18705, 18706, 18707,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_SummonVoidWalker", },
			{ 1, 2, 1242, 3, nil, nil,   nil, {  18731, 18743, 18744,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_MagicalSentry", },
			{ 2, 0, 1243, 3, nil, nil,   nil, {  18754, 18755, 18756,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_SummonSuccubus", },
			{ 2, 1, 1226, 1, nil, nil,   nil, {  18708,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_RemoveCurse", },
			{ 2, 2, 1241, 3, nil, nil,   nil, {  18748, 18749, 18750,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_AntiShadow", },
			{ 2, 3, 1671, 3, nil, nil,   nil, {  30143, 30144, 30145,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_RagingScream", },
			{ 3, 1, 1227, 2,   2,   1,  1226, {  18709, 18710,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_ImpPhaseShift", },
			{ 3, 2, 1262, 5, nil, nil,   nil, {  18769, 18770, 18771, 18772, 18773, }, "Interface\\Icons\\Spell_Shadow_ShadowWordDominate", },
			{ 4, 0, 1283, 2, nil, nil,   nil, {  18821, 18822,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_EnslaveDemon", },
			{ 4, 1, 1281, 1, nil, nil,   nil, {  18788,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_PsychicScream", },
			{ 4, 3, 1261, 2, nil, nil,   nil, {  18767, 18768,   nil,   nil,   nil, }, "Interface\\Icons\\INV_Ammo_FireTar", },
			{ 5, 0, 1681, 3, nil, nil,   nil, {  30326, 30327, 30328,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_ManaFeed", },
			{ 5, 2, 1244, 5,   3,   2,  1262, {  23785, 23822, 23823, 23824, 23825, }, "Interface\\Icons\\Spell_Shadow_ShadowPact", },
			{ 6, 0, 1680, 3, nil, nil,   nil, {  30319, 30320, 30321,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_DemonicFortitude", },
			{ 6, 1, 1282, 1,   4,   1,  1281, {  19028,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_GatherShadows", },
			{ 6, 2, 1263, 3, nil, nil,   nil, {  35691, 35692, 35693,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_ImprovedVampiricEmbrace", },
			{ 7, 1, 1673, 5, nil, nil,   nil, {  30242, 30245, 30246, 30247, 30248, }, "Interface\\Icons\\Spell_Shadow_DemonicTactics", },
			{ 8, 1, 1672, 1, nil, nil,   nil, {  30146,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_SummonFelGuard", },
		},
	},
	WARRIOR = {
		[161] = {
			{ 0, 0,  124, 3, nil, nil,   nil, {  12282, 12663, 12664,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_Ambush", },
			{ 0, 1,  130, 5, nil, nil,   nil, {  16462, 16463, 16464, 16465, 16466, }, "Interface\\Icons\\Ability_Parry", },
			{ 0, 2,  127, 3, nil, nil,   nil, {  12286, 12658, 12659,   nil,   nil, }, "Interface\\Icons\\Ability_Gouge", },
			{ 1, 0,  126, 2, nil, nil,   nil, {  12285, 12697,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_Charge", },
			{ 1, 1,  641, 5, nil, nil,   nil, {  12300, 12959, 12960, 12961, 12962, }, "Interface\\Icons\\Spell_Magic_MageArmor", },
			{ 1, 2,  128, 3, nil, nil,   nil, {  12287, 12665, 12666,   nil,   nil, }, "Interface\\Icons\\Ability_ThunderClap", },
			{ 2, 0,  131, 2, nil, nil,   nil, {  12290, 12963,   nil,   nil,   nil, }, "Interface\\Icons\\INV_Sword_05", },
			{ 2, 1,  137, 1, nil, nil,   nil, {  12296,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_BlessingOfStamina", },
			{ 2, 2,  121, 3, nil, nil,   nil, {  12834, 12849, 12867,   nil,   nil, }, "Interface\\Icons\\Ability_BackStab", },
			{ 3, 1,  136, 5, nil, nil,   nil, {  12163, 12711, 12712, 12713, 12714, }, "Interface\\Icons\\INV_Axe_09", },
			{ 3, 2,  662, 2,   2,   2,   121, {  16493, 16494,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_SearingArrow", },
			{ 4, 0,  132, 5, nil, nil,   nil, {  12700, 12781, 12783, 12784, 12785, }, "Interface\\Icons\\INV_Axe_06", },
			{ 4, 1,  133, 1, nil, nil,   nil, {  12292,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_DeathPact", },
			{ 4, 2,  125, 5, nil, nil,   nil, {  12284, 12701, 12702, 12703, 12704, }, "Interface\\Icons\\INV_Mace_01", },
			{ 4, 3,  123, 5, nil, nil,   nil, {  12281, 12812, 12813, 12814, 12815, }, "Interface\\Icons\\INV_Sword_27", },
			{ 5, 0,  134, 2, nil, nil,   nil, {  29888, 29889,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_Sprint", },
			{ 5, 2,  129, 3, nil, nil,   nil, {  12289, 12668, 23695,   nil,   nil, }, "Interface\\Icons\\Ability_ShockWave", },
			{ 5, 3, 1662, 3, nil, nil,   nil, {  29723, 29724, 29725,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_ImprovedDisciplines", },
			{ 6, 0, 1664, 2, nil, nil,   nil, {  29836, 29859,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_BloodFrenzy", },
			{ 6, 1,  135, 1,   4,   1,   133, {  12294,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_SavageBlow", },
			{ 6, 2, 1663, 2, nil, nil,   nil, {  29834, 29838,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Hunter_Harass", },
			{ 7, 1, 1824, 5,   6,   1,   135, {  35446, 35448, 35449, 35450, 35451, }, "Interface\\Icons\\Ability_Warrior_SavageBlow", },
			{ 8, 1, 1661, 1, nil, nil,   nil, {  29623,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_EndlessRage", },
		},
		[163] = {
			{ 0, 0,  142, 2, nil, nil,   nil, {  12301, 12818,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Racial_BloodRage", },
			{ 0, 1,  141, 3, nil, nil,   nil, {  12295, 12676, 12677,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_EnchantArmor", },
			{ 0, 2,  138, 5, nil, nil,   nil, {  12297, 12750, 12751, 12752, 12753, }, "Interface\\Icons\\Spell_Nature_MirrorImage", },
			{ 1, 1, 1601, 5, nil, nil,   nil, {  12298, 12724, 12725, 12726, 12727, }, "Interface\\Icons\\INV_Shield_06", },
			{ 1, 2,  140, 5, nil, nil,   nil, {  12299, 12761, 12762, 12763, 12764, }, "Interface\\Icons\\Spell_Holy_Devotion", },
			{ 2, 0,  153, 1, nil, nil,   nil, {  12975,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Holy_AshesToAshes", },
			{ 2, 1,  145, 1,   1,   1,  1601, {  12945,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Defend", },
			{ 2, 2,  147, 3, nil, nil,   nil, {  12797, 12799, 12800,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_Revenge", },
			{ 2, 3,  144, 3, nil, nil,   nil, {  12303, 12788, 12789,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_InnerRage", },
			{ 3, 0,  146, 3, nil, nil,   nil, {  12308, 12810, 12811,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_Sunder", },
			{ 3, 1,  151, 3, nil, nil,   nil, {  12313, 12804, 12807,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_Disarm", },
			{ 3, 2,  143, 2, nil, nil,   nil, {  12302, 12765,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_Reincarnation", },
			{ 4, 0,  150, 2, nil, nil,   nil, {  12312, 12803,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_ShieldWall", },
			{ 4, 1,  152, 1, nil, nil,   nil, {  12809,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_ThunderBolt", },
			{ 4, 2,  149, 2, nil, nil,   nil, {  12311, 12958,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_ShieldBash", },
			{ 5, 0, 1654, 3, nil, nil,   nil, {  29598, 29599, 29600,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_ShieldMastery", },
			{ 5, 2,  702, 5, nil, nil,   nil, {  16538, 16539, 16540, 16541, 16542, }, "Interface\\Icons\\INV_Sword_20", },
			{ 6, 0, 1652, 3, nil, nil,   nil, {  29593, 29594, 29595,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_DefensiveStance", },
			{ 6, 1,  148, 1,   4,   1,   152, {  23922,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\INV_Shield_05", },
			{ 6, 2, 1660, 3, nil, nil,   nil, {  29787, 29790, 29792,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_FocusedRage", },
			{ 7, 1, 1653, 5, nil, nil,   nil, {  29140, 29143, 29144, 29145, 29146, }, "Interface\\Icons\\INV_Helmet_21", },
			{ 8, 1, 1666, 1, nil, nil,   nil, {  20243,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\INV_Sword_11", },
		},
		[164] = {
			{ 0, 1,  158, 5, nil, nil,   nil, {  12321, 12835, 12836, 12837, 12838, }, "Interface\\Icons\\Spell_Nature_Purge", },
			{ 0, 2,  157, 5, nil, nil,   nil, {  12320, 12852, 12853, 12855, 12856, }, "Interface\\Icons\\Ability_Rogue_Eviscerate", },
			{ 1, 1,  161, 5, nil, nil,   nil, {  12324, 12876, 12877, 12878, 12879, }, "Interface\\Icons\\Ability_Warrior_WarCry", },
			{ 1, 2,  159, 5, nil, nil,   nil, {  12322, 12999, 13000, 13001, 13002, }, "Interface\\Icons\\Spell_Nature_StoneClawTotem", },
			{ 2, 0,  166, 3, nil, nil,   nil, {  12329, 12950, 20496,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_Cleave", },
			{ 2, 1,  160, 1, nil, nil,   nil, {  12323,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_DeathScream", },
			{ 2, 2,  661, 3, nil, nil,   nil, {  16487, 16489, 16492,   nil,   nil, }, "Interface\\Icons\\Spell_Shadow_SummonImp", },
			{ 2, 3,  154, 5, nil, nil,   nil, {  12318, 12857, 12858, 12860, 12861, }, "Interface\\Icons\\Spell_Nature_FocusedMind", },
			{ 3, 0, 1581, 5, nil, nil,   nil, {  23584, 23585, 23586, 23587, 23588, }, "Interface\\Icons\\Ability_DualWield", },
			{ 3, 1, 1542, 2, nil, nil,   nil, {  20502, 20503,   nil,   nil,   nil, }, "Interface\\Icons\\INV_Sword_48", },
			{ 3, 2,  155, 5, nil, nil,   nil, {  12317, 13045, 13046, 13047, 13048, }, "Interface\\Icons\\Spell_Shadow_UnholyFrenzy", },
			{ 4, 0,  168, 2, nil, nil,   nil, {  12862, 12330,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_DecisiveStrike", },
			{ 4, 1,  165, 1, nil, nil,   nil, {  12328,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Rogue_SliceDice", },
			{ 4, 3, 1543, 2, nil, nil,   nil, {  20504, 20505,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_WeaponMastery", },
			{ 5, 0, 1541, 2, nil, nil,   nil, {  20500, 20501,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_AncestralGuardian", },
			{ 5, 2,  156, 5,   3,   2,   155, {  12319, 12971, 12972, 12973, 12974, }, "Interface\\Icons\\Ability_GhoulFrenzy", },
			{ 6, 0, 1657, 3, nil, nil,   nil, {  29590, 29591, 29592,   nil,   nil, }, "Interface\\Icons\\Ability_Marksmanship", },
			{ 6, 1,  167, 1,   4,   1,   165, {  23881,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Spell_Nature_BloodLust", },
			{ 6, 2, 1655, 2, nil, nil,   nil, {  29721, 29776,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Whirlwind", },
			{ 7, 2, 1658, 5, nil, nil,   nil, {  29759, 29760, 29761, 29762, 29763, }, "Interface\\Icons\\Ability_Racial_Avatar", },
			{ 8, 1, 1659, 1,   6,   1,   167, {  29801,   nil,   nil,   nil,   nil, }, "Interface\\Icons\\Ability_Warrior_Rampage", },
		},
	},
};
--
	--	DT.SpellDB_P
	--1------2---3-----4------5-----6--------7-------8
	--level, id, cost, phase, name, passive, talent, class
	--	passive = true, talent = true, race = "", require = SpellID,
--
DT.SpellDB = {
	DRUID = {
		{ name = "治疗之触", { 1, 5185, 0, }, { 8, 5186, 200, }, { 14, 5187, 900, }, { 20, 5188, 2000, }, { 26, 5189, 4500, }, { 32, 6778, 8000, }, { 38, 8903, 12000, }, { 44, 9758, 18000, }, { 50, 9888, 23000, }, { 56, 9889, 30000, }, { 60, 25297, 34000, }, { 62, 26978, 43000, }, { 69, 26979, 90000, }, },
		{ name = "愤怒", { 1, 5176, 0, }, { 6, 5177, 100, }, { 14, 5178, 900, }, { 22, 5179, 3000, }, { 30, 5180, 6000, }, { 38, 6780, 12000, }, { 46, 8905, 20000, }, { 54, 9912, 28000, }, { 61, 26984, 39000, }, { 69, 26985, 90000, }, },
		{ name = "野性印记", { 1, 1126, 10, }, { 10, 5232, 300, }, { 20, 6756, 2000, }, { 30, 5234, 6000, }, { 40, 8907, 14000, }, { 50, 9884, 23000, }, { 60, 9885, 34000, }, { 70, 26990, 100000, }, },
		{ name = "回春术", { 4, 774, 100, }, { 10, 1058, 300, }, { 16, 1430, 1800, }, { 22, 2090, 3000, }, { 28, 2091, 5000, }, { 34, 3627, 10000, }, { 40, 8910, 14000, }, { 46, 9839, 20000, }, { 52, 9840, 26000, }, { 58, 9841, 32000, }, { 60, 25299, 34000, }, { 63, 26981, 48000, }, { 69, 26982, 90000, }, },
		{ name = "月火术", { 4, 8921, 100, }, { 10, 8924, 300, }, { 16, 8925, 1800, }, { 22, 8926, 3000, }, { 28, 8927, 5000, }, { 34, 8928, 10000, }, { 40, 8929, 14000, }, { 46, 9833, 20000, }, { 52, 9834, 26000, }, { 58, 9835, 32000, }, { 63, 26987, 48000, }, { 70, 26988, 100000, }, },
		{ name = "荆棘术", { 6, 467, 100, }, { 14, 782, 900, }, { 24, 1075, 4000, }, { 34, 8914, 10000, }, { 44, 9756, 18000, }, { 54, 9910, 28000, }, { 64, 26992, 53000, }, },
		{ name = "纠缠根须", { 8, 339, 200, }, { 18, 1062, 1900, }, { 28, 5195, 5000, }, { 38, 5196, 12000, }, { 48, 9852, 22000, }, { 58, 9853, 32000, }, { 68, 26989, 81000, }, },
		{ name = "熊形态", { 10, 5487, 0, }, },
		{ name = "传送：月光林地", { 10, 18960, 0, }, },
		{ name = "低吼", { 10, 6795, 0, }, },
		{ name = "重殴", { 10, 6807, 0, }, { 18, 6808, 1900, }, { 26, 6809, 4500, }, { 34, 8972, 10000, }, { 42, 9745, 16000, }, { 50, 9880, 23000, }, { 58, 9881, 32000, }, { 67, 26996, 73000, }, },
		{ name = "挫志咆哮", { 10, 99, 300, }, { 20, 1735, 2000, }, { 32, 9490, 8000, }, { 42, 9747, 16000, }, { 52, 9898, 26000, }, { 62, 26998, 43000, }, },
		{ name = "愈合", { 12, 8936, 800, }, { 18, 8938, 1900, }, { 24, 8939, 4000, }, { 30, 8940, 6000, }, { 36, 8941, 11000, }, { 42, 9750, 16000, }, { 48, 9856, 22000, }, { 54, 9857, 28000, }, { 60, 9858, 34000, }, { 65, 26980, 59000, }, },
		{ name = "激怒", { 12, 5229, 800, }, },
		{ name = "消毒术", { 14, 8946, 0, }, },
		{ name = "猛击", { 14, 5211, 900, }, { 30, 6798, 6000, }, { 46, 8983, 20000, }, },
		{ name = "水栖形态", { 16, 1066, 0, }, },
		{ name = "横扫", { 16, 779, 1800, }, { 24, 780, 4000, }, { 34, 769, 10000, }, { 44, 9754, 18000, }, { 54, 9908, 28000, }, { 64, 26997, 53000, }, },
		{ name = "精灵之火", { 18, 770, 1900, }, { 30, 778, 6000, }, { 42, 9749, 16000, }, { 54, 9907, 28000, }, { 66, 26993, 34000, }, },
		{ name = "休眠", { 18, 2637, 1900, }, { 38, 18657, 12000, }, { 58, 18658, 32000, }, },
		{ name = "猎豹形态", { 20, 768, 2000, }, },
		{ name = "潜行", { 20, 5215, 2000, }, { 40, 6783, 14000, }, { 60, 9913, 34000, }, },
		{ name = "星火术", { 20, 2912, 2000, }, { 26, 8949, 4500, }, { 34, 8950, 10000, }, { 42, 8951, 16000, }, { 50, 9875, 23000, }, { 58, 9876, 32000, }, { 60, 25298, 34000, }, { 67, 26986, 73000, }, },
		{ name = "割裂", { 20, 1079, 2000, }, { 28, 9492, 5000, }, { 36, 9493, 11000, }, { 44, 9752, 18000, }, { 52, 9894, 26000, }, { 60, 9896, 34000, }, { 67, 27008, 73000, }, },
		{ name = "复生", { 20, 20484, 2000, }, { 30, 20739, 6000, }, { 40, 20742, 14000, }, { 50, 20747, 23000, }, { 60, 20748, 34000, }, { 69, 26994, 90000, }, },
		{ name = "爪击", { 20, 1082, 2000, }, { 28, 3029, 5000, }, { 38, 5201, 12000, }, { 48, 9849, 22000, }, { 58, 9850, 32000, }, { 67, 27000, 73000, }, },
		{ name = "安抚动物", { 22, 2908, 3000, }, { 38, 8955, 12000, }, { 54, 9901, 28000, }, { 70, 26995, 100000, }, },
		{ name = "撕碎", { 22, 5221, 3000, }, { 30, 6800, 6000, }, { 38, 8992, 12000, }, { 46, 9829, 20000, }, { 54, 9830, 28000, }, { 61, 27001, 39000, }, { 70, 27002, 100000, }, },
		{ name = "解除诅咒", { 24, 2782, 4000, }, },
		{ name = "猛虎之怒", { 24, 5217, 4000, }, { 36, 6793, 11000, }, { 48, 9845, 22000, }, { 60, 9846, 34000, }, },
		{ name = "斜掠", { 24, 1822, 4000, }, { 34, 1823, 10000, }, { 44, 1824, 18000, }, { 54, 9904, 28000, }, { 64, 27003, 53000, }, },
		{ name = "急奔", { 26, 1850, 4500, }, { 46, 9821, 20000, }, { 65, 33357, 59000, }, },
		{ name = "驱毒术", { 26, 2893, 4500, }, },
		{ name = "挑战咆哮", { 28, 5209, 5000, }, },
		{ name = "畏缩", { 28, 8998, 5000, }, { 40, 9000, 14000, }, { 52, 9892, 26000, }, { 60, 31709, 34000, }, { 69, 27004, 90000, }, },
		{ name = "宁静", { 30, 740, 6000, }, { 40, 8918, 14000, }, { 50, 9862, 23000, }, { 60, 9863, 34000, }, { 70, 26983, 100000, }, },
		{ name = "旅行形态", { 30, 783, 6000, }, },
		{ name = "追踪人型生物", { 32, 5225, 8000, }, },
		{ name = "毁灭", { 32, 6785, 8000, }, { 42, 6787, 16000, }, { 50, 9866, 23000, }, { 58, 9867, 32000, }, { 66, 27005, 66000, }, },
		{ name = "凶猛撕咬", { 32, 22568, 8000, }, { 40, 22827, 14000, }, { 48, 22828, 22000, }, { 56, 22829, 30000, }, { 60, 31018, 30000, }, { 63, 24248, 48000, }, },
		{ name = "突袭", { 36, 9005, 11000, }, { 46, 9823, 20000, }, { 56, 9827, 30000, }, { 66, 27006, 66000, }, },
		{ name = "狂暴回复", { 36, 22842, 11000, }, { 46, 22895, 20000, }, { 56, 22896, 30000, }, { 65, 26999, 59000, }, },
		{ name = "巨熊形态", { 40, 9634, 14000, }, },
		{ name = "激活", { 40, 29166, 14000, }, },
		{ name = "飓风", { 40, 16914, 14000, }, { 50, 17401, 23000, }, { 60, 17402, 34000, }, { 70, 27012, 100000, }, },
		{ name = "豹之优雅", { 40, 20719, 14000, }, passive = true, },
		{ name = "树皮术", { 44, 22812, 18000, }, },
		{ name = "野性赐福", { 50, 21849, 23000, }, { 60, 21850, 34000, }, { 70, 26991, 0, }, },
		{ name = "割碎", { 62, 22570, 43000, }, },
		{ name = "生命绽放", { 64, 33763, 53000, }, },
		{ name = "割伤", { 66, 33745, 66000, }, },
		{ name = "飞行形态", { 68, 33943, 81000, }, },
		{ name = "迅捷飞行形态", { 70, 40120, 0, }, },
		{ name = "飓风术", { 70, 33786, 100000, }, },
		{ name = "生命之树", { -1, 33891, 0, }, talent = true, },
		{ name = "自然之力", { -1, 33831, 0, }, talent = true, },
		{ name = "野性冲锋", { -1, 16979, 0, }, talent = true, },
		{ name = "精灵之火（野性）", { -1, 16857, 0, }, { 30, 17390, 300, }, { 42, 17391, 800, }, { 54, 17392, 1400, }, { 66, 27011, 1700, }, talent = true, },
		{ name = "兽群领袖", { -1, 17007, 0, }, passive = true, talent = true, },
		{ name = "枭兽形态", { -1, 24858, 0, }, talent = true, },
		{ name = "自然之握", { -1, 16689, 0, }, { 18, 16810, 95, }, { 28, 16811, 250, }, { 38, 16812, 600, }, { 48, 16813, 1100, }, { 58, 17329, 1600, }, { 68, 27009, 1700, }, talent = true, },
		{ name = "虫群", { -1, 5570, 0, }, { 30, 24974, 300, }, { 40, 24975, 700, }, { 50, 24976, 1150, }, { 60, 24977, 1700, }, { 70, 27013, 2500, }, talent = true, },
		{ name = "迅捷治愈", { -1, 18562, 0, }, talent = true, },
		{ name = "裂伤（豹）", { -1, 33876, 0, nil, 33917, }, { 58, 33982, 1700, }, { 68, 33983, 1700, }, talent = true, require = 33917, },
		{ name = "裂伤（熊）", { -1, 33878, 0, nil, 33917, }, { 58, 33986, 1700, }, { 68, 33987, 1900, }, talent = true, require = 33917, },
		{ name = "自然赐福", { -1, 16880, 0, }, passive = true, talent = true, },
		{ name = "自然迅捷", { -1, 17116, 0, }, talent = true, },
		{ name = "清晰预兆", { -1, 16864, 0, }, talent = true, },
	},
	HUNTER = {
		{ name = "追踪野兽", { 1, 1494, 10, }, },
		{ name = "自动射击", { 1, 75, 0, }, },
		{ name = "猛禽一击", { 1, 2973, 0, }, { 8, 14260, 200, }, { 16, 14261, 1800, }, { 24, 14262, 7000, }, { 32, 14263, 10000, }, { 40, 14264, 18000, }, { 48, 14265, 32000, }, { 56, 14266, 46000, }, { 63, 27014, 87000, }, },
		{ name = "毒蛇钉刺", { 4, 1978, 100, }, { 10, 13549, 400, }, { 18, 13550, 2000, }, { 26, 13551, 7000, }, { 34, 13552, 12000, }, { 42, 13553, 24000, }, { 50, 13554, 36000, }, { 58, 13555, 48000, }, { 60, 25295, 50000, }, { 67, 27016, 140000, }, },
		{ name = "灵猴守护", { 4, 13163, 100, }, },
		{ name = "奥术射击", { 6, 3044, 100, }, { 12, 14281, 600, }, { 20, 14282, 2200, }, { 28, 14283, 8000, }, { 36, 14284, 14000, }, { 44, 14285, 26000, }, { 52, 14286, 40000, }, { 60, 14287, 50000, }, { 69, 27019, 170000, }, },
		{ name = "猎人印记", { 6, 1130, 100, }, { 22, 14323, 6000, }, { 40, 14324, 18000, }, { 58, 14325, 48000, }, },
		{ name = "招架", { 8, 3127, 200, }, passive = true, },
		{ name = "震荡射击", { 8, 5116, 200, }, },
		{ name = "追踪人型生物", { 10, 19883, 400, }, },
		{ name = "驯服野兽", { 10, 1515, 0, }, },
		{ name = "雄鹰守护", { 10, 13165, 400, }, { 18, 14318, 2000, }, { 28, 14319, 8000, }, { 38, 14320, 16000, }, { 48, 14321, 32000, }, { 58, 14322, 48000, }, { 60, 25296, 50000, }, { 68, 27044, 150000, }, },
		{ name = "解散野兽", { 10, 2641, 0, }, },
		{ name = "召唤宠物", { 10, 883, 0, }, },
		{ name = "喂养宠物", { 10, 6991, 0, }, },
		{ name = "训练野兽", { 10, 5149, 0, }, },
		{ name = "复活宠物", { 10, 982, 0, }, },
		{ name = "扰乱射击", { 12, 20736, 600, }, { 20, 14274, 2200, }, { 30, 15629, 8000, }, { 40, 15630, 18000, }, { 50, 15631, 36000, }, { 60, 15632, 50000, }, { 69, 27020, 170000, }, },
		{ name = "摔绊", { 12, 2974, 600, }, { 38, 14267, 16000, }, { 60, 14268, 50000, }, },
		{ name = "治疗宠物", { 12, 136, 600, }, { 20, 3111, 2200, }, { 28, 3661, 8000, }, { 36, 3662, 14000, }, { 44, 13542, 26000, }, { 52, 13543, 40000, }, { 60, 13544, 50000, }, { 68, 27046, 150000, }, },
		{ name = "恐吓野兽", { 14, 1513, 1200, }, { 30, 14326, 8000, }, { 46, 14327, 28000, }, },
		{ name = "野兽之眼", { 14, 1002, 1200, }, },
		{ name = "鹰眼术", { 14, 6197, 1200, }, },
		{ name = "猫鼬撕咬", { 16, 1495, 1800, }, { 30, 14269, 8000, }, { 44, 14270, 26000, }, { 58, 14271, 48000, }, { 70, 36916, 190000, }, },
		{ name = "献祭陷阱", { 16, 13795, 1800, }, { 26, 14302, 7000, }, { 36, 14303, 14000, }, { 46, 14304, 28000, }, { 56, 14305, 46000, }, { 65, 27023, 110000, }, },
		{ name = "追踪亡灵", { 18, 19884, 2000, }, },
		{ name = "多重射击", { 18, 2643, 2000, }, { 30, 14288, 8000, }, { 42, 14289, 24000, }, { 54, 14290, 42000, }, { 60, 25294, 50000, }, { 67, 27021, 140000, }, },
		{ name = "猎豹守护", { 20, 5118, 2200, }, },
		{ name = "双武器", { 20, 674, 2200, }, passive = true, },
		{ name = "逃脱", { 20, 781, 2200, }, { 34, 14272, 12000, }, { 48, 14273, 32000, }, { 62, 27015, 77000, }, },
		{ name = "冰冻陷阱", { 20, 1499, 2200, }, { 40, 14310, 18000, }, { 60, 14311, 50000, }, },
		{ name = "毒蝎钉刺", { 22, 3043, 6000, }, },
		{ name = "追踪隐藏生物", { 24, 19885, 7000, }, },
		{ name = "野兽知识", { 24, 1462, 7000, }, },
		{ name = "急速射击", { 26, 3045, 7000, }, },
		{ name = "追踪元素生物", { 26, 19880, 7000, }, },
		{ name = "冰霜陷阱", { 28, 13809, 8000, }, },
		{ name = "野兽守护", { 30, 13161, 8000, }, },
		{ name = "假死", { 30, 5384, 8000, }, },
		{ name = "照明弹", { 32, 1543, 10000, }, },
		{ name = "追踪恶魔", { 32, 19878, 10000, }, },
		{ name = "爆炸陷阱", { 34, 13813, 12000, }, { 44, 14316, 26000, }, { 54, 14317, 42000, }, { 61, 27025, 68000, }, },
		{ name = "蝰蛇钉刺", { 36, 3034, 14000, }, { 46, 14279, 28000, }, { 56, 14280, 46000, }, { 66, 27018, 120000, }, },
		{ name = "追踪巨人", { 40, 19882, 18000, }, },
		{ name = "锁甲", { 40, 8737, 18000, }, },
		{ name = "豹群守护", { 40, 13159, 18000, }, },
		{ name = "乱射", { 40, 1510, 18000, }, { 50, 14294, 36000, }, { 58, 14295, 48000, }, { 67, 27022, 140000, }, },
		{ name = "野性守护", { 46, 20043, 28000, }, { 56, 20190, 46000, }, { 68, 27045, 150000, }, },
		{ name = "追踪龙类", { 50, 19879, 36000, }, },
		{ name = "宁神射击", { 60, 19801, 50000, }, },
		{ name = "稳固射击", { 62, 34120, 77000, }, },
		{ name = "蝰蛇守护", { 64, 34074, 100000, }, },
		{ name = "杀戮命令", { 66, 34026, 120000, }, },
		{ name = "毒蛇陷阱", { 68, 34600, 150000, }, },
		{ name = "误导", { 70, 34477, 190000, }, },
		{ name = "准备就绪", { -1, 23989, 0, }, talent = true, },
		{ name = "翼龙钉刺", { -1, 19386, 0, }, { 50, 24132, 1800, }, { 60, 24133, 2500, }, { 70, 27068, 2700, }, talent = true, },
		{ name = "瞄准射击", { -1, 19434, 0, }, { 28, 20900, 400, }, { 36, 20901, 700, }, { 44, 20902, 1300, }, { 52, 20903, 2000, }, { 60, 20904, 2500, }, { 70, 27065, 2700, }, talent = true, },
		{ name = "狂野怒火", { -1, 19574, 0, }, talent = true, },
		{ name = "野兽迅捷", { -1, 19596, 0, }, passive = true, talent = true, },
		{ name = "胁迫", { -1, 19577, 0, }, talent = true, },
		{ name = "驱散射击", { -1, 19503, 0, }, talent = true, },
		{ name = "野兽之心", { -1, 34692, 0, }, passive = true, talent = true, },
		{ name = "强击光环", { -1, 19506, 0, }, { 50, 20905, 1800, }, { 60, 20906, 2500, }, { 70, 27066, 2700, }, talent = true, },
		{ name = "反击", { -1, 19306, 0, }, { 42, 20909, 1200, }, { 54, 20910, 2100, }, { 66, 27067, 2500, }, talent = true, },
		{ name = "威慑", { -1, 19263, 0, }, talent = true, },
		{ name = "沉默射击", { -1, 34490, 0, }, talent = true, },
	},
	MAGE = {
		{ name = "霜甲术", { 1, 168, 0, }, { 10, 7300, 400, }, { 20, 7301, 2000, }, },
		{ name = "火球术", { 1, 133, 0, }, { 6, 143, 100, }, { 12, 145, 600, }, { 18, 3140, 1800, }, { 24, 8400, 4000, }, { 30, 8401, 8000, }, { 36, 8402, 13000, }, { 42, 10148, 18000, }, { 48, 10149, 28000, }, { 54, 10150, 36000, }, { 60, 10151, 42000, }, { 62, 25306, 42000, }, { 66, 27070, 78000, }, },
		{ name = "奥术智慧", { 1, 1459, 10, }, { 14, 1460, 900, }, { 28, 1461, 7000, }, { 42, 10156, 18000, }, { 56, 10157, 38000, }, { 70, 27126, 120000, }, },
		{ name = "寒冰箭", { 4, 116, 100, }, { 8, 205, 200, }, { 14, 837, 900, }, { 20, 7322, 2000, }, { 26, 8406, 5000, }, { 32, 8407, 10000, }, { 38, 8408, 14000, }, { 44, 10179, 23000, }, { 50, 10180, 32000, }, { 56, 10181, 38000, }, { 60, 25304, 42000, }, { 63, 27071, 57000, }, { 69, 27072, 110000, }, },
		{ name = "造水术", { 4, 5504, 100, }, { 10, 5505, 400, }, { 20, 5506, 2000, }, { 30, 6127, 8000, }, { 40, 10138, 15000, }, { 50, 10139, 32000, }, { 60, 10140, 42000, }, { 65, 37420, 70000, }, { 70, 27090, 0, }, },
		{ name = "造食术", { 6, 587, 100, }, { 12, 597, 600, }, { 22, 990, 3000, }, { 32, 6129, 10000, }, { 42, 10144, 18000, }, { 52, 10145, 35000, }, { 60, 28612, 42000, }, { 70, 33717, 0, }, },
		{ name = "火焰冲击", { 6, 2136, 100, }, { 14, 2137, 900, }, { 22, 2138, 3000, }, { 30, 8412, 8000, }, { 38, 8413, 14000, }, { 46, 10197, 26000, }, { 54, 10199, 36000, }, { 61, 27078, 46000, }, { 70, 27079, 120000, }, },
		{ name = "变形术", { 8, 118, 200, }, { 20, 12824, 2000, }, { 40, 12825, 15000, }, { 60, 12826, 42000, }, },
		{ name = "奥术飞弹", { 8, 5143, 200, }, { 16, 5144, 1500, }, { 24, 5145, 4000, }, { 32, 8416, 10000, }, { 40, 8417, 15000, }, { 48, 10211, 28000, }, { 56, 10212, 38000, }, { 60, 25345, 42000, }, { 63, 27075, 57000, }, { 69, 38699, 87000, }, },
		{ name = "冰霜新星", { 10, 122, 400, }, { 26, 865, 5000, }, { 40, 6131, 15000, }, { 54, 10230, 36000, }, { 67, 27088, 87000, }, },
		{ name = "魔法抑制", { 12, 604, 600, }, { 24, 8450, 4000, }, { 36, 8451, 13000, }, { 48, 10173, 28000, }, { 60, 10174, 42000, }, { 67, 33944, 87000, }, },
		{ name = "缓落术", { 12, 130, 600, }, },
		{ name = "魔爆术", { 14, 1449, 900, }, { 22, 8437, 3000, }, { 30, 8438, 8000, }, { 38, 8439, 14000, }, { 46, 10201, 26000, }, { 54, 10202, 36000, }, { 62, 27080, 51000, }, { 70, 27082, 120000, }, },
		{ name = "烈焰风暴", { 16, 2120, 1500, }, { 24, 2121, 4000, }, { 32, 8422, 10000, }, { 40, 8423, 15000, }, { 48, 10215, 28000, }, { 56, 10216, 38000, }, { 64, 27086, 63000, }, },
		{ name = "魔法增效", { 18, 1008, 1800, }, { 30, 8455, 8000, }, { 42, 10169, 18000, }, { 54, 10170, 36000, }, { 63, 27130, 57000, }, { 69, 33946, 110000, }, },
		{ name = "解除次级诅咒", { 18, 475, 1800, }, },
		{ name = "传送：暴风城", { 20, 3561, 2000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送：铁炉堡", { 20, 3562, 2000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送：埃索达", { 20, 32271, 2000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送：奥格瑞玛", { 20, 3567, 2000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "传送：幽暗城", { 20, 3563, 2000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "传送：银月城", { 20, 32272, 2000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "法力护盾", { 20, 1463, 2000, }, { 28, 8494, 7000, }, { 36, 8495, 13000, }, { 44, 10191, 23000, }, { 52, 10192, 35000, }, { 60, 10193, 42000, }, { 68, 27131, 96000, }, },
		{ name = "闪现术", { 20, 1953, 2000, }, },
		{ name = "暴风雪", { 20, 10, 2000, }, { 28, 6141, 7000, }, { 36, 8427, 13000, }, { 44, 10185, 23000, }, { 52, 10186, 35000, }, { 60, 10187, 42000, }, { 68, 27085, 96000, }, },
		{ name = "防护火焰结界", { 20, 543, 2000, }, { 30, 8457, 8000, }, { 40, 8458, 15000, }, { 50, 10223, 32000, }, { 60, 10225, 42000, }, { 69, 27128, 110000, }, },
		{ name = "唤醒", { 20, 12051, 2000, }, },
		{ name = "灼烧", { 22, 2948, 3000, }, { 28, 8444, 7000, }, { 34, 8445, 12000, }, { 40, 8446, 15000, }, { 46, 10205, 26000, }, { 52, 10206, 35000, }, { 58, 10207, 40000, }, { 65, 27073, 70000, }, { 70, 27074, 120000, }, },
		{ name = "防护冰霜结界", { 22, 6143, 3000, }, { 32, 8461, 10000, }, { 42, 8462, 18000, }, { 52, 10177, 35000, }, { 60, 28609, 42000, }, { 70, 32796, 120000, }, },
		{ name = "法术反制", { 24, 2139, 4000, }, },
		{ name = "冰锥术", { 26, 120, 5000, }, { 34, 8492, 12000, }, { 42, 10159, 18000, }, { 50, 10160, 32000, }, { 58, 10161, 40000, }, { 65, 27087, 70000, }, },
		{ name = "制造魔法玛瑙", { 28, 759, 7000, }, },
		{ name = "冰甲术", { 30, 7302, 8000, }, { 40, 7320, 15000, }, { 50, 10219, 32000, }, { 60, 10220, 42000, }, { 69, 27124, 110000, }, },
		{ name = "传送：达纳苏斯", { 30, 3565, 8000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送：雷霆崖", { 30, 3566, 8000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "寒冰屏障", { 30, 45438, 8000, }, },
		{ name = "法师护甲", { 34, 6117, 13000, }, { 46, 22782, 28000, }, { 58, 22783, 40000, }, { 69, 27125, 110000, }, },
		{ name = "传送：塞拉摩", { 35, 49359, 2000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送门：塞拉摩", { 35, 49360, 15000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送：斯通纳德", { 35, 49358, 2000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "传送门：斯通纳德", { 35, 49361, 2000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "制造魔法翡翠", { 38, 3552, 14000, }, },
		{ name = "传送门：暴风城", { 40, 10059, 15000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送门：铁炉堡", { 40, 11416, 15000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送门：埃索达", { 40, 32266, 15000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送门：奥格瑞玛", { 40, 11417, 15000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "传送门：银月城", { 40, 32267, 15000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "传送门：幽暗城", { 40, 11418, 15000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "制造魔法黄水晶", { 48, 10053, 28000, }, },
		{ name = "传送门：达纳苏斯", { 50, 11419, 32000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送门：雷霆崖", { 50, 11420, 32000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "奥术光辉", { 56, 23028, 38000, }, { 70, 27127, 0, }, },
		{ name = "制造魔法红宝石", { 58, 10054, 40000, }, },
		{ name = "传送：沙塔斯", { 60, 33690, 20000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送：沙塔斯", { 60, 35715, 20000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "变形术", { 60, 28272, 0, }, },
		{ name = "变形术", { 60, 28271, 0, }, },
		{ name = "熔岩护甲", { 62, 30482, 51000, }, },
		{ name = "奥术冲击", { 64, 30451, 63000, }, },
		{ name = "传送门：沙塔斯", { 65, 33691, 150000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送门：沙塔斯", { 65, 35717, 150000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "冰枪术", { 66, 30455, 78000, }, },
		{ name = "制造魔法玉石", { 68, 27101, 96000, }, },
		{ name = "隐形术", { 68, 66, 96000, }, },
		{ name = "法术偷取", { 70, 30449, 120000, }, },
		{ name = "召唤餐桌", { 70, 43987, 120000, }, },
		{ name = "召唤水元素", { -1, 31687, 0, }, talent = true, },
		{ name = "奥术强化", { -1, 12042, 0, }, talent = true, },
		{ name = "减速", { -1, 31589, 0, }, talent = true, },
		{ name = "气定神闲", { -1, 12043, 0, }, talent = true, },
		{ name = "奥术坚韧", { -1, 28574, 0, }, passive = true, talent = true, },
		{ name = "冲击波", { -1, 11113, 0, }, { 36, 13018, 3250, }, { 44, 13019, 5750, }, { 52, 13020, 8750, }, { 60, 13021, 10500, }, { 65, 27133, 10500, }, { 70, 33933, 12500, }, talent = true, },
		{ name = "炎爆术", { -1, 11366, 0, }, { 24, 12505, 1000, }, { 30, 12522, 2000, }, { 36, 12523, 3250, }, { 42, 12524, 4500, }, { 48, 12525, 7000, }, { 54, 12526, 9000, }, { 60, 18809, 10500, }, { 66, 27132, 10500, }, { 70, 33938, 10500, }, talent = true, },
		{ name = "燃烧", { -1, 11129, 0, }, talent = true, },
		{ name = "急速冷却", { -1, 11958, 0, }, talent = true, },
		{ name = "冰冷血脉", { -1, 12472, 0, }, talent = true, },
		{ name = "龙息术", { -1, 31661, 0, }, { 56, 33041, 1900, }, { 64, 33042, 2200, }, { 70, 33043, 2500, }, talent = true, },
		{ name = "寒冰护体", { -1, 11426, 0, }, { 46, 13031, 1700, }, { 52, 13032, 1900, }, { 58, 13033, 2100, }, { 64, 27134, 2500, }, { 70, 33405, 10500, }, talent = true, },
	},
	PALADIN = {
		{ name = "圣光术", { 1, 635, 0, }, { 6, 639, 100, }, { 14, 647, 2000, }, { 22, 1026, 4000, }, { 30, 1042, 11000, }, { 38, 3472, 16000, }, { 46, 10328, 24000, }, { 54, 10329, 40000, }, { 60, 25292, 46000, }, { 62, 27135, 55000, }, { 70, 27136, 130000, }, },
		{ name = "虔诚光环", { 1, 465, 10, }, { 10, 10290, 300, }, { 20, 643, 4000, }, { 30, 10291, 11000, }, { 40, 1032, 20000, }, { 50, 10292, 28000, }, { 60, 10293, 46000, }, { 70, 27149, 130000, }, },
		{ name = "正义圣印", { 1, 21084, 0, }, { 10, 20287, 300, }, { 18, 20288, 3500, }, { 26, 20289, 6000, }, { 34, 20290, 13000, }, { 42, 20291, 21000, }, { 50, 20292, 28000, }, { 58, 20293, 44000, }, { 66, 27155, 83000, }, },
		{ name = "审判", { 4, 20271, 100, }, },
		{ name = "力量祝福", { 4, 19740, 100, }, { 12, 19834, 1000, }, { 22, 19835, 4000, }, { 32, 19836, 12000, }, { 42, 19837, 21000, }, { 52, 19838, 34000, }, { 60, 25291, 50000, }, { 70, 27140, 50000, }, },
		{ name = "十字军圣印", { 6, 21082, 100, }, { 12, 20162, 1000, }, { 22, 20305, 4000, }, { 32, 20306, 12000, }, { 42, 20307, 21000, }, { 52, 20308, 34000, }, { 61, 27158, 50000, }, },
		{ name = "圣佑术", { 6, 498, 100, }, { 18, 5573, 3500, }, },
		{ name = "纯净术", { 8, 1152, 100, }, },
		{ name = "制裁之锤", { 8, 853, 100, }, { 24, 5588, 5000, }, { 40, 5589, 20000, }, { 54, 10308, 40000, }, },
		{ name = "招架", { 8, 3127, 100, }, passive = true, },
		{ name = "保护祝福", { 10, 1022, 300, }, { 24, 5599, 5000, }, { 38, 10278, 16000, }, },
		{ name = "圣疗术", { 10, 633, 300, }, { 30, 2800, 11000, }, { 50, 10310, 28000, }, { 69, 27154, 110000, }, },
		{ name = "救赎", { 12, 7328, 0, }, { 24, 10322, 5000, }, { 36, 10324, 14000, }, { 48, 20772, 26000, }, { 60, 20773, 46000, }, },
		{ name = "正义防御", { 14, 31789, 4000, }, },
		{ name = "智慧祝福", { 14, 19742, 2000, }, { 24, 19850, 5000, }, { 34, 19852, 13000, }, { 44, 19853, 22000, }, { 54, 19854, 40000, }, { 60, 25290, 50000, }, { 65, 27142, 75000, }, },
		{ name = "正义之怒", { 16, 25780, 3000, }, },
		{ name = "惩罚光环", { 16, 7294, 3000, }, { 26, 10298, 6000, }, { 36, 10299, 14000, }, { 46, 10300, 24000, }, { 56, 10301, 42000, }, { 66, 27150, 83000, }, },
		{ name = "灵魂协调", { 18, 31785, 3500, }, { 66, 33776, 83000, }, },
		{ name = "自由祝福", { 18, 1044, 3500, }, },
		{ name = "感知亡灵", { 20, 5502, 0, }, },
		{ name = "圣光闪现", { 20, 19750, 4000, }, { 26, 19939, 6000, }, { 34, 19940, 13000, }, { 42, 19941, 21000, }, { 50, 19942, 28000, }, { 58, 19943, 44000, }, { 66, 27137, 83000, }, },
		{ name = "驱邪术", { 20, 879, 4000, }, { 28, 5614, 9000, }, { 36, 5615, 14000, }, { 44, 10312, 22000, }, { 52, 10313, 34000, }, { 60, 10314, 46000, }, { 68, 27138, 100000, }, },
		{ name = "奉献", { 20, 26573, 4000, }, { 30, 20116, 11000, }, { 40, 20922, 20000, }, { 50, 20923, 28000, }, { 60, 20924, 46000, }, { 70, 27173, 130000, }, },
		{ name = "专注光环", { 22, 19746, 4000, }, },
		{ name = "公正圣印", { 22, 20164, 4000, }, { 48, 31895, 26000, }, },
		{ name = "超度亡灵", { 24, 2878, 5000, }, { 38, 5627, 16000, }, },
		{ name = "拯救祝福", { 26, 1038, 6000, }, },
		{ name = "暗影抗性光环", { 28, 19876, 9000, }, { 40, 19895, 20000, }, { 52, 19896, 34000, }, { 63, 27151, 61000, }, },
		{ name = "光明圣印", { 30, 20165, 11000, }, { 40, 20347, 20000, }, { 50, 20348, 28000, }, { 60, 20349, 46000, }, { 69, 27160, 110000, }, },
		{ name = "神圣干涉", { 30, 19752, 11000, }, },
		{ name = "召唤军马", { 30, 13819, 10000, }, },
		{ name = "冰霜抗性光环", { 32, 19888, 12000, }, { 44, 19897, 22000, }, { 56, 19898, 42000, }, { 68, 27152, 100000, }, },
		{ name = "圣盾术", { 34, 642, 13000, }, { 50, 1020, 28000, }, },
		{ name = "火焰抗性光环", { 36, 19891, 14000, }, { 48, 19899, 26000, }, { 60, 19900, 46000, }, { 70, 27153, 130000, }, },
		{ name = "智慧圣印", { 38, 20166, 16000, }, { 48, 20356, 26000, }, { 58, 20357, 44000, }, { 67, 27166, 92000, }, },
		{ name = "板甲", { 40, 750, 20000, }, },
		{ name = "光明祝福", { 40, 19977, 20000, }, { 50, 19978, 28000, }, { 60, 19979, 46000, }, { 69, 27144, 110000, }, },
		{ name = "清洁术", { 42, 4987, 21000, }, },
		{ name = "愤怒之锤", { 44, 24275, 22000, }, { 52, 24274, 34000, }, { 60, 24239, 46000, }, { 68, 27180, 100000, }, },
		{ name = "牺牲祝福", { 46, 6940, 24000, }, { 54, 20729, 40000, }, { 62, 27147, 55000, }, { 70, 27148, 130000, }, },
		{ name = "神圣愤怒", { 50, 2812, 28000, }, { 60, 10318, 46000, }, { 69, 27139, 110000, }, },
		{ name = "强效力量祝福", { 52, 25782, 46000, }, { 60, 25916, 46000, }, { 70, 27141, 46000, }, },
		{ name = "超度邪恶", { 52, 10326, 34000, }, },
		{ name = "强效智慧祝福", { 54, 25894, 46000, }, { 60, 25918, 46000, }, { 65, 27143, 75000, }, },
		{ name = "强效光明祝福", { 60, 25890, 46000, }, { 69, 27145, 110000, }, },
		{ name = "强效王者祝福", { 60, 25898, 2300, }, },
		{ name = "强效庇护祝福", { 60, 25899, 2300, }, { 70, 27169, 2300, }, },
		{ name = "强效拯救祝福", { 60, 25895, 46000, }, },
		{ name = "十字军光环", { 62, 32223, 55000, }, },
		{ name = "复仇圣印", { 64, 31801, 67000, }, },
		{ name = "复仇之怒", { 70, 31884, 130000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "殉难圣印", { 70, 348700, 67000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "腐蚀圣印", { 70, 348704, 130000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "鲜血圣印", { 70, 31892, 67000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "十字军打击", { -1, 35395, 0, }, talent = true, },
		{ name = "神启", { -1, 31842, 0, }, talent = true, },
		{ name = "王者祝福", { -1, 20217, 0, }, talent = true, },
		{ name = "神圣震击", { -1, 20473, 0, }, { 48, 20929, 1300, }, { 56, 20930, 2100, }, { 64, 27174, 3350, }, { 70, 33072, 6500, }, talent = true, },
		{ name = "光环掌握", { -1, 31821, 0, }, talent = true, },
		{ name = "神恩术", { -1, 20216, 0, }, talent = true, },
		{ name = "庇护祝福", { -1, 20911, 0, }, { 40, 20912, 1000, }, { 50, 20913, 1400, }, { 60, 20914, 2300, }, { 70, 27168, 2300, }, talent = true, },
		{ name = "忏悔", { -1, 20066, 0, }, talent = true, },
		{ name = "圣洁光环", { -1, 20218, 0, }, talent = true, },
		{ name = "命令圣印", { -1, 20375, 0, }, { 30, 20915, 550, }, { 40, 20918, 1000, }, { 50, 20919, 1400, }, { 60, 20920, 2300, }, { 70, 27170, 2300, }, talent = true, },
		{ name = "复仇者之盾", { -1, 31935, 0, }, { 60, 32699, 2300, }, { 70, 32700, 2300, }, talent = true, },
		{ name = "神圣之盾", { -1, 20925, 0, }, { 50, 20927, 1400, }, { 60, 20928, 2300, }, { 70, 27179, 2300, }, talent = true, },
	},
	PRIEST = {
		{ name = "次级治疗术", { 1, 2050, 0, }, { 4, 2052, 100, }, { 10, 2053, 300, }, },
		{ name = "惩击", { 1, 585, 0, }, { 6, 591, 100, }, { 14, 598, 1200, }, { 22, 984, 4000, }, { 30, 1004, 10000, }, { 38, 6060, 16000, }, { 46, 10933, 26000, }, { 54, 10934, 40000, }, { 61, 25363, 53000, }, { 69, 25364, 65000, }, },
		{ name = "真言术：韧", { 1, 1243, 10, }, { 12, 1244, 800, }, { 24, 1245, 5000, }, { 36, 2791, 14000, }, { 48, 10937, 28000, }, { 60, 10938, 46000, }, { 70, 25389, 65000, }, },
		{ name = "暗言术：痛", { 4, 589, 100, }, { 10, 594, 300, }, { 18, 970, 2000, }, { 26, 992, 6000, }, { 34, 2767, 12000, }, { 42, 10892, 22000, }, { 50, 10893, 30000, }, { 58, 10894, 44000, }, { 65, 25367, 80000, }, { 70, 25368, 140000, }, },
		{ name = "真言术：盾", { 6, 17, 100, }, { 12, 592, 800, }, { 18, 600, 2000, }, { 24, 3747, 5000, }, { 30, 6065, 10000, }, { 36, 6066, 14000, }, { 42, 10898, 22000, }, { 48, 10899, 28000, }, { 54, 10900, 40000, }, { 60, 10901, 46000, }, { 65, 25217, 80000, }, { 70, 25218, 140000, }, },
		{ name = "恢复", { 8, 139, 200, }, { 14, 6074, 1200, }, { 20, 6075, 3000, }, { 26, 6076, 6000, }, { 32, 6077, 11000, }, { 38, 6078, 16000, }, { 44, 10927, 24000, }, { 50, 10928, 30000, }, { 56, 10929, 42000, }, { 60, 25315, 6500, }, { 65, 25221, 80000, }, { 70, 25222, 140000, }, },
		{ name = "渐隐术", { 8, 586, 200, }, { 20, 9578, 3000, }, { 30, 9579, 10000, }, { 40, 9592, 18000, }, { 50, 10941, 30000, }, { 60, 10942, 46000, }, { 66, 25429, 89000, }, },
		{ name = "星辰碎片", { 10, 10797, 90, }, { 18, 19296, 100, }, { 26, 19299, 300, }, { 34, 19302, 600, }, { 42, 19303, 1100, }, { 50, 19304, 1500, }, { 58, 19305, 2200, }, { 66, 25446, 6500, }, race = "NIGHTELF", },
		{ name = "虚弱妖术", { 10, 9035, 90, }, { 20, 19281, 150, }, { 30, 19282, 500, }, { 40, 19283, 900, }, { 50, 19284, 1500, }, { 60, 19285, 2300, }, { 70, 25470, 6500, }, race = "TROLL", },
		{ name = "希望符记", { 10, 32548, 100, }, race = "DRAENEI", },
		{ name = "绝望祷言", { 10, 13908, 90, }, { 18, 19236, 100, }, { 26, 19238, 300, }, { 34, 19240, 600, }, { 42, 19241, 1100, }, { 50, 19242, 1500, }, { 58, 19243, 2200, }, { 66, 25437, 6500, }, race = "HUMAN|DWARF", },
		{ name = "心灵震爆", { 10, 8092, 300, }, { 16, 8102, 1600, }, { 22, 8103, 4000, }, { 28, 8104, 8000, }, { 34, 8105, 12000, }, { 40, 8106, 18000, }, { 46, 10945, 26000, }, { 52, 10946, 38000, }, { 58, 10947, 44000, }, { 63, 25372, 65000, }, { 69, 25375, 65000, }, },
		{ name = "虚弱之触", { 10, 2652, 90, }, { 20, 19261, 150, }, { 30, 19262, 500, }, { 40, 19264, 900, }, { 50, 19265, 1500, }, { 60, 19266, 2300, }, { 70, 25461, 6500, }, race = "SCOURGE|BLOODELF", },
		{ name = "复活术", { 10, 2006, 300, }, { 22, 2010, 4000, }, { 34, 10880, 12000, }, { 46, 10881, 26000, }, { 58, 20770, 44000, }, { 68, 25435, 110000, }, },
		{ name = "心灵之火", { 12, 588, 800, }, { 20, 7128, 3000, }, { 30, 602, 10000, }, { 40, 1006, 18000, }, { 50, 10951, 30000, }, { 60, 10952, 46000, }, { 69, 25431, 65000, }, },
		{ name = "祛病术", { 14, 528, 1200, }, },
		{ name = "心灵尖啸", { 14, 8122, 1200, }, { 28, 8124, 8000, }, { 42, 10888, 22000, }, { 56, 10890, 42000, }, },
		{ name = "治疗术", { 16, 2054, 1600, }, { 22, 2055, 4000, }, { 28, 6063, 8000, }, { 34, 6064, 12000, }, },
		{ name = "驱散魔法", { 18, 527, 2000, }, { 36, 988, 14000, }, },
		{ name = "吞噬魔法", { 20, 32676, 100, }, race = "BLOODELF", },
		{ name = "噬灵瘟疫", { 20, 2944, 100, }, { 28, 19276, 400, }, { 36, 19277, 700, }, { 44, 19278, 1200, }, { 52, 19279, 1900, }, { 60, 19280, 2300, }, { 68, 25467, 6500, }, race = "SCOURGE", },
		{ name = "艾露恩的赐福", { 20, 2651, 100, }, race = "NIGHTELF", },
		{ name = "责罚", { 20, 44041, 100, }, { 30, 44043, 500, }, { 40, 44044, 900, }, { 50, 44045, 1500, }, { 60, 44046, 2300, }, { 70, 44047, 3250, }, race = "DWARF|DRAENEI", },
		{ name = "暗影守卫", { 20, 18137, 100, }, { 28, 19308, 400, }, { 36, 19309, 700, }, { 44, 19310, 1200, }, { 52, 19311, 1900, }, { 60, 19312, 2300, }, { 68, 25477, 6500, }, race = "TROLL", },
		{ name = "回馈", { 20, 13896, 100, }, { 30, 19271, 500, }, { 40, 19273, 900, }, { 50, 19274, 1500, }, { 60, 19275, 2300, }, { 70, 25441, 6500, }, race = "HUMAN", },
		{ name = "安抚心灵", { 20, 453, 3000, }, { 36, 8192, 14000, }, { 52, 10953, 38000, }, { 67, 25596, 99000, }, },
		{ name = "神圣之火", { 20, 14914, 3000, }, { 24, 15262, 5000, }, { 30, 15263, 10000, }, { 36, 15264, 14000, }, { 42, 15265, 22000, }, { 48, 15266, 28000, }, { 54, 15267, 40000, }, { 60, 15261, 46000, }, { 66, 25384, 65000, }, },
		{ name = "束缚亡灵", { 20, 9484, 3000, }, { 40, 9485, 18000, }, { 60, 10955, 46000, }, },
		{ name = "防护恐惧结界", { 20, 6346, 800, }, },
		{ name = "快速治疗", { 20, 2061, 3000, }, { 26, 9472, 6000, }, { 32, 9473, 11000, }, { 38, 9474, 16000, }, { 44, 10915, 24000, }, { 50, 10916, 30000, }, { 56, 10917, 42000, }, { 61, 25233, 53000, }, { 67, 25235, 99000, }, },
		{ name = "心灵视界", { 22, 2096, 4000, }, { 44, 10909, 24000, }, },
		{ name = "法力燃烧", { 24, 8129, 5000, }, { 32, 8131, 11000, }, { 40, 10874, 18000, }, { 48, 10875, 28000, }, { 56, 10876, 42000, }, { 63, 25379, 65000, }, { 70, 25380, 110000, }, },
		{ name = "精神控制", { 30, 605, 10000, }, { 44, 10911, 24000, }, { 58, 10912, 44000, }, },
		{ name = "防护暗影", { 30, 976, 10000, }, { 42, 10957, 22000, }, { 56, 10958, 42000, }, { 68, 25433, 110000, }, },
		{ name = "治疗祷言", { 30, 596, 10000, }, { 40, 996, 18000, }, { 50, 10960, 30000, }, { 60, 10961, 46000, }, { 60, 25316, 6500, }, { 68, 25308, 110000, }, },
		{ name = "驱除疾病", { 32, 552, 11000, }, },
		{ name = "漂浮术", { 34, 1706, 12000, }, },
		{ name = "强效治疗术", { 40, 2060, 18000, }, { 46, 10963, 26000, }, { 52, 10964, 38000, }, { 58, 10965, 44000, }, { 60, 25314, 65000, }, { 63, 25210, 65000, }, { 68, 25213, 110000, }, },
		{ name = "坚韧祷言", { 48, 21562, 28000, }, { 60, 21564, 46000, }, { 70, 25392, 0, }, },
		{ name = "暗影防护祷言", { 56, 27683, 42000, }, { 70, 39374, 0, }, },
		{ name = "精神祷言", { 60, 27681, 2300, }, { 70, 32999, 3400, }, },
		{ name = "暗言术：灭", { 62, 32379, 59000, }, { 70, 32996, 110000, }, },
		{ name = "联结治疗", { 64, 32546, 72000, }, },
		{ name = "暗影恶魔", { 66, 34433, 89000, }, },
		{ name = "愈合祷言", { 68, 33076, 110000, }, },
		{ name = "群体驱散", { 70, 32375, 110000, }, },
		{ name = "吸血鬼之触", { -1, 34914, 0, }, { 60, 34916, 2300, }, { 70, 34917, 2300, }, talent = true, },
		{ name = "能量灌注", { -1, 10060, 0, }, talent = true, },
		{ name = "痛苦压制", { -1, 33206, 0, }, talent = true, },
		{ name = "神圣之灵", { -1, 14752, 0, }, { 40, 14818, 900, }, { 50, 14819, 1500, }, { 60, 27841, 2300, }, { 70, 25312, 2300, }, talent = true, },
		{ name = "心灵专注", { -1, 14751, 0, }, talent = true, },
		{ name = "救赎之魂", { -1, 20711, 0, }, passive = true, talent = true, },
		{ name = "神圣新星", { -1, 15237, 0, }, { 28, 15430, 400, }, { 36, 15431, 700, }, { 44, 27799, 1200, }, { 52, 27800, 1900, }, { 60, 27801, 2300, }, { 68, 25331, 3250, }, talent = true, },
		{ name = "暗影形态", { -1, 15473, 0, }, talent = true, },
		{ name = "沉默", { -1, 15487, 0, }, talent = true, },
		{ name = "光明之泉", { -1, 724, 0, }, { 50, 27870, 1200, }, { 60, 27871, 1500, }, { 70, 28275, 1500, }, talent = true, },
		{ name = "吸血鬼的拥抱", { -1, 15286, 0, }, talent = true, },
		{ name = "治疗之环", { -1, 34861, 0, }, { 56, 34863, 2100, }, { 60, 34864, 2300, }, { 65, 34865, 2300, }, { 70, 34866, 2300, }, talent = true, },
		{ name = "精神鞭笞", { -1, 15407, 0, }, { 28, 17311, 400, }, { 36, 17312, 700, }, { 44, 17313, 1200, }, { 52, 17314, 1900, }, { 60, 18807, 2300, }, { 68, 25387, 6500, }, talent = true, },
	},
	ROGUE = {
		{ name = "影袭", { 1, 1752, 0, }, { 6, 1757, 100, }, { 14, 1758, 1200, }, { 22, 1759, 4000, }, { 30, 1760, 10000, }, { 38, 8621, 18000, }, { 46, 11293, 31000, }, { 54, 11294, 48000, }, { 62, 26861, 50000, }, { 70, 26862, 140000, }, },
		{ name = "刺骨", { 1, 2098, 0, }, { 8, 6760, 200, }, { 16, 6761, 1800, }, { 24, 6762, 5000, }, { 32, 8623, 12000, }, { 40, 8624, 20000, }, { 48, 11299, 33000, }, { 56, 11300, 50000, }, { 60, 31016, 65000, }, { 64, 26865, 140000, }, },
		{ name = "潜行", { 1, 1784, 10, }, { 20, 1785, 3000, }, { 40, 1786, 20000, }, { 60, 1787, 54000, }, },
		{ name = "背刺", { 4, 53, 100, }, { 12, 2589, 800, }, { 20, 2590, 3000, }, { 28, 2591, 8000, }, { 36, 8721, 16000, }, { 44, 11279, 29000, }, { 52, 11280, 46000, }, { 60, 11281, 54000, }, { 60, 25300, 54000, }, { 68, 26863, 110000, }, },
		{ name = "搜索", { 4, 921, 100, }, },
		{ name = "凿击", { 6, 1776, 100, }, { 18, 1777, 2900, }, { 32, 8629, 12000, }, { 46, 11285, 31000, }, { 60, 11286, 54000, }, { 67, 38764, 99000, }, },
		{ name = "闪避", { 8, 5277, 200, }, { 50, 26669, 35000, }, },
		{ name = "切割", { 10, 5171, 300, }, { 42, 6774, 27000, }, },
		{ name = "闷棍", { 10, 6770, 300, }, { 28, 2070, 8000, }, { 48, 11297, 33000, }, },
		{ name = "双武器", { 10, 674, 300, }, passive = true, },
		{ name = "疾跑", { 10, 2983, 300, }, { 34, 8696, 14000, }, { 58, 11305, 52000, }, },
		{ name = "脚踢", { 12, 1766, 800, }, { 26, 1767, 6000, }, { 42, 1768, 27000, }, { 58, 1769, 52000, }, { 69, 38768, 120000, }, },
		{ name = "招架", { 12, 3127, 800, }, passive = true, },
		{ name = "锁喉", { 14, 703, 1200, }, { 22, 8631, 4000, }, { 30, 8632, 10000, }, { 38, 8633, 18000, }, { 46, 11289, 31000, }, { 54, 11290, 48000, }, { 61, 26839, 50000, }, { 70, 26884, 140000, }, },
		{ name = "破甲", { 14, 8647, 1200, }, { 26, 8649, 6000, }, { 36, 8650, 16000, }, { 46, 11197, 31000, }, { 56, 11198, 50000, }, { 66, 26866, 99000, }, },
		{ name = "佯攻", { 16, 1966, 1800, }, { 28, 6768, 8000, }, { 40, 8637, 20000, }, { 52, 11303, 46000, }, { 60, 25302, 50000, }, { 64, 27448, 72000, }, },
		{ name = "开锁", { 16, 1804, 1800, }, },
		{ name = "伏击", { 18, 8676, 2900, }, { 26, 8724, 6000, }, { 34, 8725, 14000, }, { 42, 11267, 27000, }, { 50, 11268, 35000, }, { 58, 11269, 52000, }, { 66, 27441, 80000, }, },
		{ name = "毒药", { 20, 2842, 0, }, },
		{ name = "减速药膏", { 20, 3420, 3000, }, { 50, 3421, 35000, }, },
		{ name = "速效药膏", { 20, 8681, 0, }, { 28, 8687, 8000, }, { 36, 8691, 16000, }, { 44, 11341, 29000, }, { 52, 11342, 46000, }, { 60, 11343, 54000, }, { 68, 26892, 110000, }, },
		{ name = "割裂", { 20, 1943, 3000, }, { 28, 8639, 8000, }, { 36, 8640, 16000, }, { 44, 11273, 29000, }, { 52, 11274, 46000, }, { 60, 11275, 54000, }, { 68, 26867, 120000, }, },
		{ name = "扰乱", { 22, 1725, 4000, }, },
		{ name = "消失", { 22, 1856, 4000, }, { 42, 1857, 27000, }, { 62, 26889, 59000, }, },
		{ name = "麻痹药膏", { 24, 5763, 5000, }, { 38, 8694, 18000, }, { 52, 11400, 46000, }, },
		{ name = "侦测陷阱", { 24, 2836, 5000, }, passive = true, },
		{ name = "偷袭", { 26, 1833, 6000, }, },
		{ name = "致命药膏", { 30, 2835, 10000, }, { 38, 2837, 18000, }, { 46, 11357, 31000, }, { 54, 11358, 48000, }, { 60, 25347, 54000, }, { 62, 26969, 65000, }, { 70, 27282, 140000, }, },
		{ name = "解除陷阱", { 30, 1842, 10000, }, },
		{ name = "肾击", { 30, 408, 10000, }, { 50, 8643, 35000, }, },
		{ name = "致伤药膏", { 32, 13220, 12000, }, { 40, 13228, 20000, }, { 48, 13229, 33000, }, { 56, 13230, 50000, }, { 64, 27283, 80000, }, },
		{ name = "致盲", { 34, 2094, 14000, }, },
		{ name = "安全降落", { 40, 1860, 20000, }, passive = true, },
		{ name = "毒伤", { 62, 32645, 59000, }, { 69, 32684, 120000, }, },
		{ name = "致命投掷", { 64, 26679, 72000, }, },
		{ name = "暗影斗篷", { 66, 31224, 89000, }, },
		{ name = "麻醉药膏", { 68, 26786, 110000, }, },
		{ name = "毒刃", { 70, 5938, 140000, }, },
		{ name = "冲动", { -1, 13750, 0, }, talent = true, },
		{ name = "毁伤", { -1, 1329, 0, }, { 50, 34411, 5500, }, { 60, 34412, 6500, }, { 70, 34413, 7500, }, talent = true, },
		{ name = "精力", { -1, 14983, 0, }, passive = true, talent = true, },
		{ name = "突袭", { -1, 32601, 0, }, passive = true, talent = true, },
		{ name = "还击", { -1, 14251, 0, }, talent = true, },
		{ name = "暗影步", { -1, 36554, 0, }, talent = true, },
		{ name = "剑刃乱舞", { -1, 13877, 0, }, talent = true, },
		{ name = "鬼魅攻击", { -1, 14278, 0, }, talent = true, },
		{ name = "伺机待发", { -1, 14185, 0, }, talent = true, },
		{ name = "预谋", { -1, 14183, 0, }, talent = true, },
		{ name = "冷血", { -1, 14177, 0, }, talent = true, },
		{ name = "无情打击", { -1, 14179, 0, }, passive = true, talent = true, },
		{ name = "出血", { -1, 16511, 0, }, { 46, 17347, 385, }, { 58, 17348, 650, }, { 70, 26864, 2700, }, talent = true, },
	},
	SHAMAN = {
		{ name = "治疗波", { 1, 331, 0, }, { 6, 332, 100, }, { 12, 547, 800, }, { 18, 913, 2000, }, { 24, 939, 3500, }, { 32, 959, 8000, }, { 40, 8005, 12000, }, { 48, 10395, 22000, }, { 56, 10396, 30000, }, { 60, 25357, 6500, }, { 63, 25391, 42000, }, { 70, 25396, 88000, }, },
		{ name = "闪电箭", { 1, 403, 0, }, { 8, 529, 100, }, { 14, 548, 900, }, { 20, 915, 2200, }, { 26, 943, 4000, }, { 32, 6041, 8000, }, { 38, 10391, 11000, }, { 44, 10392, 18000, }, { 50, 15207, 24000, }, { 56, 15208, 30000, }, { 62, 25448, 38000, }, { 67, 25449, 64000, }, },
		{ name = "石化武器", { 1, 8017, 10, }, { 8, 8018, 100, }, { 16, 8019, 1800, }, { 24, 10399, 3500, }, { 34, 16314, 9000, }, { 44, 16315, 18000, }, { 54, 16316, 29000, }, { 62, 25479, 38000, }, { 70, 25485, 88000, }, },
		{ name = "地震术", { 4, 8042, 100, }, { 8, 8044, 100, }, { 14, 8045, 900, }, { 24, 8046, 3500, }, { 36, 10412, 10000, }, { 48, 10413, 22000, }, { 60, 10414, 34000, }, { 69, 25454, 79000, }, },
		{ name = "石肤图腾", { 4, 8071, 0, }, { 14, 8154, 900, }, { 24, 8155, 3500, }, { 34, 10406, 9000, }, { 44, 10407, 18000, }, { 54, 10408, 29000, }, { 63, 25508, 42000, }, { 70, 25509, 88000, }, },
		{ name = "地缚图腾", { 6, 2484, 100, }, },
		{ name = "闪电之盾", { 8, 324, 100, }, { 16, 325, 1800, }, { 24, 905, 3500, }, { 32, 945, 8000, }, { 40, 8134, 12000, }, { 48, 10431, 22000, }, { 56, 10432, 30000, }, { 63, 25469, 42000, }, { 70, 25472, 88000, }, },
		{ name = "石爪图腾", { 8, 5730, 100, }, { 18, 6390, 2000, }, { 28, 6391, 6000, }, { 38, 6392, 11000, }, { 48, 10427, 22000, }, { 58, 10428, 32000, }, { 67, 25525, 64000, }, },
		{ name = "大地之力图腾", { 10, 8075, 400, }, { 24, 8160, 3500, }, { 38, 8161, 11000, }, { 52, 10442, 27000, }, { 60, 25361, 34000, }, { 65, 25528, 52000, }, },
		{ name = "烈焰震击", { 10, 8050, 400, }, { 18, 8052, 2000, }, { 28, 8053, 6000, }, { 40, 10447, 12000, }, { 52, 10448, 27000, }, { 60, 29228, 65000, }, { 70, 25457, 88000, }, },
		{ name = "火舌武器", { 10, 8024, 400, }, { 18, 8027, 2000, }, { 26, 8030, 4000, }, { 36, 16339, 10000, }, { 46, 16341, 20000, }, { 56, 16342, 30000, }, { 64, 25489, 47000, }, },
		{ name = "灼热图腾", { 10, 3599, 0, }, { 20, 6363, 2200, }, { 30, 6364, 7000, }, { 40, 6365, 12000, }, { 50, 10437, 24000, }, { 60, 10438, 34000, }, { 69, 25533, 79000, }, },
		{ name = "火焰新星图腾", { 12, 1535, 800, }, { 22, 8498, 3000, }, { 32, 8499, 8000, }, { 42, 11314, 16000, }, { 52, 11315, 27000, }, { 61, 25546, 34000, }, { 70, 25547, 88000, }, },
		{ name = "净化术", { 12, 370, 800, }, { 32, 8012, 8000, }, },
		{ name = "先祖之魂", { 12, 2008, 800, }, { 24, 20609, 3500, }, { 36, 20610, 10000, }, { 48, 20776, 22000, }, { 60, 20777, 34000, }, },
		{ name = "消毒术", { 16, 526, 1800, }, },
		{ name = "战栗图腾", { 18, 8143, 2000, }, },
		{ name = "幽魂之狼", { 20, 2645, 2200, }, },
		{ name = "治疗之泉图腾", { 20, 5394, 0, }, { 30, 6375, 7000, }, { 40, 6377, 12000, }, { 50, 10462, 24000, }, { 60, 10463, 34000, }, { 69, 25567, 79000, }, },
		{ name = "冰封武器", { 20, 8033, 2200, }, { 28, 8038, 6000, }, { 38, 10456, 11000, }, { 48, 16355, 22000, }, { 58, 16356, 32000, }, { 66, 25500, 58000, }, },
		{ name = "次级治疗波", { 20, 8004, 2200, }, { 28, 8008, 6000, }, { 36, 8010, 10000, }, { 44, 10466, 18000, }, { 52, 10467, 27000, }, { 60, 10468, 34000, }, { 66, 25420, 58000, }, },
		{ name = "冰霜震击", { 20, 8056, 2200, }, { 34, 8058, 9000, }, { 46, 10472, 20000, }, { 58, 10473, 32000, }, { 68, 25464, 71000, }, },
		{ name = "清毒图腾", { 22, 8166, 3000, }, },
		{ name = "祛病术", { 22, 2870, 3000, }, },
		{ name = "水下呼吸", { 22, 131, 3000, }, },
		{ name = "抗寒图腾", { 24, 8181, 3500, }, { 38, 10478, 11000, }, { 54, 10479, 29000, }, { 67, 25560, 64000, }, },
		{ name = "法力之泉图腾", { 26, 5675, 4000, }, { 36, 10495, 10000, }, { 46, 10496, 20000, }, { 56, 10497, 30000, }, { 65, 25570, 52000, }, },
		{ name = "熔岩图腾", { 26, 8190, 4000, }, { 36, 10585, 10000, }, { 46, 10586, 20000, }, { 56, 10587, 30000, }, { 65, 25552, 52000, }, },
		{ name = "视界术", { 26, 6196, 4000, }, },
		{ name = "火舌图腾", { 28, 8227, 6000, }, { 38, 8249, 11000, }, { 48, 10526, 22000, }, { 58, 16387, 32000, }, { 67, 25557, 64000, }, },
		{ name = "水上行走", { 28, 546, 6000, }, },
		{ name = "抗火图腾", { 28, 8184, 6000, }, { 42, 10537, 16000, }, { 58, 10538, 32000, }, { 68, 25563, 71000, }, },
		{ name = "图腾召唤", { 30, 36936, 7000, }, },
		{ name = "风怒武器", { 30, 8232, 7000, }, { 40, 8235, 12000, }, { 50, 10486, 24000, }, { 60, 16362, 34000, }, { 68, 25505, 71000, }, },
		{ name = "根基图腾", { 30, 8177, 7000, }, },
		{ name = "复生", { 30, 20608, 7000, }, passive = true, },
		{ name = "星界传送", { 30, 556, 7000, }, },
		{ name = "自然抗性图腾", { 30, 10595, 7000, }, { 44, 10600, 18000, }, { 60, 10601, 34000, }, { 69, 25574, 79000, }, },
		{ name = "风怒图腾", { 32, 8512, 8000, }, { 42, 10613, 16000, }, { 52, 10614, 27000, }, { 61, 25585, 34000, }, { 70, 25587, 88000, }, },
		{ name = "闪电链", { 32, 421, 8000, }, { 40, 930, 12000, }, { 48, 2860, 22000, }, { 56, 10605, 30000, }, { 63, 25439, 42000, }, { 70, 25442, 88000, }, },
		{ name = "岗哨图腾", { 34, 6495, 9000, }, },
		{ name = "风墙图腾", { 36, 15107, 10000, }, { 46, 15111, 20000, }, { 56, 15112, 30000, }, { 65, 25577, 52000, }, },
		{ name = "祛病图腾", { 38, 8170, 11000, }, },
		{ name = "治疗链", { 40, 1064, 12000, }, { 46, 10622, 20000, }, { 54, 10623, 29000, }, { 61, 25422, 34000, }, { 68, 25423, 71000, }, },
		{ name = "锁甲", { 40, 8737, 12000, }, },
		{ name = "风之优雅图腾", { 42, 8835, 16000, }, { 56, 10627, 30000, }, { 60, 25359, 65000, }, },
		{ name = "宁静之风图腾", { 50, 25908, 24000, }, },
		{ name = "水之护盾", { 62, 24398, 38000, }, { 69, 33736, 79000, }, },
		{ name = "空气之怒图腾", { 64, 3738, 47000, }, },
		{ name = "土元素图腾", { 66, 2062, 58000, }, },
		{ name = "火元素图腾", { 68, 2894, 71000, }, },
		{ name = "英勇", { 70, 32182, 88000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "嗜血", { 70, 2825, 88000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "大地之盾", { -1, 974, 0, }, { 60, 32593, 1700, }, { 70, 32594, 2500, }, talent = true, },
		{ name = "灵魂武器", { -1, 16268, 0, }, passive = true, talent = true, },
		{ name = "双武器", { -1, 30798, 0, }, passive = true, talent = true, },
		{ name = "萨满专注", { -1, 43338, 0, }, passive = true, talent = true, },
		{ name = "元素掌握", { -1, 16166, 0, }, talent = true, },
		{ name = "天怒图腾", { -1, 30706, 0, }, talent = true, },
		{ name = "元素之怒", { -1, 16089, 0, }, passive = true, talent = true, },
		{ name = "风暴打击", { -1, 17364, 0, }, talent = true, },
		{ name = "元素集中", { -1, 16164, 0, }, passive = true, talent = true, },
		{ name = "自然迅捷", { -1, 16188, 0, }, talent = true, },
		{ name = "图腾掌握", { -1, 16189, 0, }, passive = true, talent = true, },
		{ name = "法力之潮图腾", { -1, 16190, 0, }, talent = true, },
	},
	WARLOCK = {
		{ name = "召唤小鬼", { 1, 688, 0, }, },
		{ name = "献祭", { 1, 348, 10, }, { 10, 707, 300, }, { 20, 1094, 2000, }, { 30, 2941, 6000, }, { 40, 11665, 11000, }, { 50, 11667, 15000, }, { 60, 11668, 26000, }, { 60, 25309, 26000, }, { 69, 27215, 70000, }, },
		{ name = "恶魔皮肤", { 1, 687, 0, }, { 10, 696, 300, }, },
		{ name = "暗影箭", { 1, 686, 0, }, { 6, 695, 100, }, { 12, 705, 600, }, { 20, 1088, 2000, }, { 28, 1106, 5000, }, { 36, 7641, 9000, }, { 44, 11659, 12000, }, { 52, 11660, 18000, }, { 60, 11661, 26000, }, { 62, 25307, 26000, }, { 69, 27209, 70000, }, },
		{ name = "虚弱诅咒", { 4, 702, 100, }, { 12, 1108, 600, }, { 22, 6205, 2500, }, { 32, 7646, 7000, }, { 42, 11707, 11000, }, { 52, 11708, 18000, }, { 61, 27224, 30000, }, { 69, 30909, 70000, }, },
		{ name = "腐蚀术", { 4, 172, 100, }, { 14, 6222, 900, }, { 24, 6223, 3000, }, { 34, 7648, 8000, }, { 44, 11671, 12000, }, { 54, 11672, 20000, }, { 60, 25311, 26000, }, { 65, 27216, 46000, }, },
		{ name = "生命分流", { 6, 1454, 100, }, { 16, 1455, 1080, }, { 26, 1456, 3600, }, { 36, 11687, 8100, }, { 46, 11688, 11700, }, { 56, 11689, 19800, }, { 68, 27222, 56700, }, },
		{ name = "恐惧", { 8, 5782, 200, }, { 32, 6213, 7000, }, { 56, 6215, 22000, }, },
		{ name = "痛苦诅咒", { 8, 980, 200, }, { 18, 1014, 1500, }, { 28, 6217, 5000, }, { 38, 11711, 10000, }, { 48, 11712, 14000, }, { 58, 11713, 24000, }, { 67, 27218, 57000, }, },
		{ name = "制造治疗石", { 10, 6201, 300, }, { 22, 6202, 2500, }, { 34, 5699, 8000, }, { 46, 11729, 13000, }, { 58, 11730, 24000, }, { 68, 27230, 63000, }, },
		{ name = "吸取灵魂", { 10, 1120, 300, }, { 24, 8288, 3000, }, { 38, 8289, 10000, }, { 52, 11675, 18000, }, { 67, 27217, 57000, }, },
		{ name = "召唤虚空行者", { 10, 697, 0, }, },
		{ name = "生命通道", { 12, 755, 600, }, { 20, 3698, 2000, }, { 28, 3699, 5000, }, { 36, 3700, 9000, }, { 44, 11693, 12000, }, { 52, 11694, 18000, }, { 60, 11695, 26000, }, { 67, 27259, 57000, }, },
		{ name = "鲁莽诅咒", { 14, 704, 900, }, { 28, 7658, 5000, }, { 42, 7659, 11000, }, { 56, 11717, 22000, }, { 69, 27226, 70000, }, },
		{ name = "吸取生命", { 14, 689, 900, }, { 22, 699, 2500, }, { 30, 709, 6000, }, { 38, 7651, 10000, }, { 46, 11699, 13000, }, { 54, 11700, 20000, }, { 62, 27219, 30000, }, { 69, 27220, 70000, }, },
		{ name = "魔息术", { 16, 5697, 1200, }, },
		{ name = "制造灵魂石", { 18, 693, 1500, }, { 30, 20752, 6000, }, { 40, 20755, 11000, }, { 50, 20756, 15000, }, { 60, 20757, 26000, }, { 70, 27238, 78000, }, },
		{ name = "灼热之痛", { 18, 5676, 1500, }, { 26, 17919, 4000, }, { 34, 17920, 8000, }, { 42, 17921, 11000, }, { 50, 17922, 15000, }, { 58, 17923, 24000, }, { 65, 27210, 46000, }, { 70, 30459, 78000, }, },
		{ name = "召唤仪式", { 20, 698, 2000, }, },
		{ name = "火焰之雨", { 20, 5740, 2000, }, { 34, 6219, 8000, }, { 46, 11677, 13000, }, { 58, 11678, 24000, }, { 69, 27212, 70000, }, },
		{ name = "召唤魅魔", { 20, 712, 0, }, },
		{ name = "召唤夜魔", { 20, 713, 0, }, },
		{ name = "魔甲术", { 20, 706, 2000, }, { 30, 1086, 6000, }, { 40, 11733, 11000, }, { 50, 11734, 15000, }, { 60, 11735, 26000, }, { 70, 27260, 78000, }, },
		{ name = "基尔罗格之眼", { 22, 126, 2500, }, },
		{ name = "吸取法力", { 24, 5138, 3000, }, { 34, 6226, 8000, }, { 44, 11703, 12000, }, { 54, 11704, 20000, }, { 63, 27221, 38000, }, { 70, 30908, 78000, }, },
		{ name = "感知恶魔", { 24, 5500, 3000, }, },
		{ name = "语言诅咒", { 26, 1714, 4000, }, { 50, 11719, 15000, }, },
		{ name = "侦测隐形", { 26, 132, 4000, }, },
		{ name = "制造火焰石", { 28, 6366, 5000, }, { 36, 17951, 9000, }, { 46, 17952, 13000, }, { 56, 17953, 22000, }, { 66, 27250, 51000, }, },
		{ name = "放逐术", { 28, 710, 5000, }, { 48, 18647, 14000, }, },
		{ name = "地狱火", { 30, 1122, 0, }, },
		{ name = "召唤地狱战马", { 30, 5784, 10000, }, },
		{ name = "地狱烈焰", { 30, 1949, 6000, }, { 42, 11683, 11000, }, { 54, 11684, 20000, }, { 68, 27213, 63000, }, },
		{ name = "奴役恶魔", { 30, 1098, 6000, }, { 44, 11725, 12000, }, { 58, 11726, 24000, }, },
		{ name = "召唤地狱猎犬", { 30, 691, 0, }, },
		{ name = "防护暗影结界", { 32, 6229, 7000, }, { 42, 11739, 11000, }, { 52, 11740, 18000, }, { 60, 28610, 34000, }, },
		{ name = "元素诅咒", { 32, 1490, 7000, }, { 46, 11721, 13000, }, { 60, 11722, 26000, }, { 69, 27228, 70000, }, },
		{ name = "制造法术石", { 36, 2362, 9000, }, { 48, 17727, 14000, }, { 60, 17728, 26000, }, { 66, 28172, 51000, }, },
		{ name = "恐惧嚎叫", { 40, 5484, 11000, }, { 54, 17928, 20000, }, },
		{ name = "死亡缠绕", { 42, 6789, 11000, }, { 50, 17925, 15000, }, { 58, 17926, 24000, }, { 68, 27223, 63000, }, },
		{ name = "灵魂之火", { 48, 6353, 14000, }, { 56, 17924, 22000, }, { 64, 27211, 42000, }, { 70, 30545, 78000, }, },
		{ name = "厄运诅咒", { 60, 603, 26000, }, { 70, 30910, 78000, }, },
		{ name = "召唤恐惧战马", { 60, 23161, 0, }, },
		{ name = "末日仪式", { 60, 18540, 0, }, },
		{ name = "邪甲术", { 62, 28176, 34000, }, { 69, 28189, 70000, }, },
		{ name = "烧尽", { 64, 29722, 42000, }, { 70, 32231, 78000, }, },
		{ name = "灵魂碎裂", { 66, 29858, 51000, }, },
		{ name = "灵魂仪式", { 68, 29893, 63000, }, },
		{ name = "腐蚀之种", { 70, 27243, 78000, }, },
		{ name = "暗影之怒", { -1, 30283, 0, }, { 60, 30413, 2500, }, { 70, 30414, 2500, }, talent = true, },
		{ name = "痛苦无常", { -1, 30108, 0, }, { 60, 30404, 2500, }, { 70, 30405, 2500, }, talent = true, },
		{ name = "恶魔支配", { -1, 18708, 0, }, talent = true, },
		{ name = "恶魔牺牲", { -1, 18788, 0, }, talent = true, },
		{ name = "黑暗契约", { -1, 18220, 0, }, { 50, 18937, 750, }, { 60, 18938, 1300, }, { 70, 27265, 1300, }, talent = true, },
		{ name = "诅咒增幅", { -1, 18288, 0, }, talent = true, },
		{ name = "疲劳诅咒", { -1, 18223, 0, }, talent = true, },
		{ name = "燃烧", { -1, 17962, 0, }, { 48, 18930, 700, }, { 54, 18931, 1000, }, { 60, 18932, 1300, }, { 65, 27266, 2300, }, { 70, 30912, 3900, }, talent = true, },
		{ name = "灵魂链接", { -1, 19028, 0, }, talent = true, },
		{ name = "生命虹吸", { -1, 18265, 0, }, { 38, 18879, 500, }, { 48, 18880, 700, }, { 58, 18881, 1200, }, { 63, 27264, 2500, }, { 70, 30911, 2500, }, talent = true, },
		{ name = "暗影灼烧", { -1, 17877, 0, }, { 24, 18867, 150, }, { 32, 18868, 350, }, { 40, 18869, 550, }, { 48, 18870, 700, }, { 56, 18871, 1100, }, { 63, 27263, 1300, }, { 70, 30546, 3900, }, talent = true, },
		{ name = "毁灭", { -1, 17959, 0, }, passive = true, talent = true, },
		{ name = "召唤恶魔卫士", { -1, 30146, 0, }, talent = true, },
	},
	WARRIOR = {
		{ name = "战斗姿态", { 1, 2457, 0, }, },
		{ name = "英勇打击", { 1, 78, 0, }, { 8, 284, 200, }, { 16, 285, 2000, }, { 24, 1608, 8000, }, { 32, 11564, 14000, }, { 40, 11565, 22000, }, { 48, 11566, 40000, }, { 56, 11567, 58000, }, { 60, 25286, 60000, }, { 66, 29707, 65000, }, },
		{ name = "战斗怒吼", { 1, 6673, 10, }, { 12, 5242, 1000, }, { 22, 6192, 6000, }, { 32, 11549, 14000, }, { 42, 11550, 32000, }, { 52, 11551, 54000, }, { 60, 25289, 65000, }, { 69, 2048, 65000, }, },
		{ name = "冲锋", { 4, 100, 100, }, { 26, 6178, 10000, }, { 46, 11578, 36000, }, },
		{ name = "撕裂", { 4, 772, 100, }, { 10, 6546, 600, }, { 20, 6547, 4000, }, { 30, 6548, 12000, }, { 40, 11572, 22000, }, { 50, 11573, 42000, }, { 60, 11574, 62000, }, { 68, 25208, 65000, }, },
		{ name = "雷霆一击", { 6, 6343, 100, }, { 18, 8198, 3000, }, { 28, 8204, 11000, }, { 38, 8205, 20000, }, { 48, 11580, 40000, }, { 58, 11581, 60000, }, { 67, 25264, 65000, }, },
		{ name = "招架", { 6, 3127, 100, }, passive = true, },
		{ name = "断筋", { 8, 1715, 200, }, { 32, 7372, 14000, }, { 54, 7373, 56000, }, { 67, 25212, 65000, }, },
		{ name = "破甲攻击", { 10, 7386, 0, }, { 22, 7405, 6000, }, { 34, 8380, 16000, }, { 46, 11596, 36000, }, { 58, 11597, 60000, }, { 67, 25225, 65000, }, },
		{ name = "防御姿态", { 10, 71, 0, }, },
		{ name = "嘲讽", { 10, 355, 0, }, },
		{ name = "血性狂暴", { 10, 2687, 600, }, },
		{ name = "盾击", { 12, 72, 1000, }, { 32, 1671, 14000, }, { 52, 1672, 54000, }, { 64, 29704, 60000, }, },
		{ name = "压制", { 12, 7384, 1000, }, { 28, 7887, 11000, }, { 44, 11584, 34000, }, { 60, 11585, 62000, }, },
		{ name = "复仇", { 14, 6572, 1500, }, { 24, 6574, 8000, }, { 34, 7379, 16000, }, { 44, 11600, 34000, }, { 54, 11601, 56000, }, { 60, 25288, 56000, }, { 63, 25269, 65000, }, { 70, 30357, 65000, }, },
		{ name = "挫志怒吼", { 14, 1160, 1500, }, { 24, 6190, 8000, }, { 34, 11554, 16000, }, { 44, 11555, 34000, }, { 54, 11556, 56000, }, { 62, 25202, 65000, }, { 70, 25203, 65000, }, },
		{ name = "盾牌格挡", { 16, 2565, 2000, }, },
		{ name = "惩戒痛击", { 16, 694, 2000, }, { 26, 7400, 10000, }, { 36, 7402, 18000, }, { 46, 20559, 36000, }, { 56, 20560, 58000, }, { 65, 25266, 65000, }, },
		{ name = "缴械", { 18, 676, 3000, }, },
		{ name = "反击风暴", { 20, 20230, 4000, }, },
		{ name = "姿态掌握", { 20, 12678, 4000, }, passive = true, },
		{ name = "双武器", { 20, 674, 4000, }, passive = true, },
		{ name = "顺劈斩", { 20, 845, 4000, }, { 30, 7369, 12000, }, { 40, 11608, 22000, }, { 50, 11609, 42000, }, { 60, 20569, 62000, }, { 68, 25231, 65000, }, },
		{ name = "破胆怒吼", { 22, 5246, 6000, }, },
		{ name = "斩杀", { 24, 5308, 8000, }, { 32, 20658, 14000, }, { 40, 20660, 22000, }, { 48, 20661, 40000, }, { 56, 20662, 58000, }, { 65, 25234, 65000, }, { 70, 25236, 65000, }, },
		{ name = "挑战怒吼", { 26, 1161, 10000, }, },
		{ name = "盾墙", { 28, 871, 11000, }, },
		{ name = "狂暴姿态", { 30, 2458, 0, }, },
		{ name = "拦截", { 30, 20252, 0, }, { 42, 20616, 32000, }, { 52, 20617, 54000, }, { 61, 25272, 65000, }, { 69, 25275, 65000, }, },
		{ name = "猛击", { 30, 1464, 12000, }, { 38, 8820, 20000, }, { 46, 11604, 36000, }, { 54, 11605, 56000, }, { 61, 25241, 65000, }, { 69, 25242, 65000, }, },
		{ name = "狂暴之怒", { 32, 18499, 14000, }, },
		{ name = "旋风斩", { 36, 1680, 18000, }, },
		{ name = "拳击", { 38, 6552, 20000, }, { 58, 6554, 60000, }, },
		{ name = "板甲", { 40, 750, 22000, }, },
		{ name = "鲁莽", { 50, 1719, 42000, }, },
		{ name = "乘胜追击", { 62, 34428, 58000, }, },
		{ name = "法术反射", { 64, 23920, 65000, }, },
		{ name = "命令怒吼", { 68, 469, 65000, }, },
		{ name = "援护", { 70, 3411, 65000, }, },
		{ name = "毁灭打击", { -1, 20243, 0, }, { 60, 30016, 3100, }, { 70, 30022, 3250, }, talent = true, },
		{ name = "无尽怒气", { -1, 29623, 0, }, passive = true, talent = true, },
		{ name = "刺耳怒吼", { -1, 12323, 0, }, talent = true, },
		{ name = "致死打击", { -1, 12294, 0, }, { 48, 21551, 2000, }, { 54, 21552, 2800, }, { 60, 21553, 3100, }, { 66, 25248, 3250, }, { 70, 30330, 3250, }, talent = true, },
		{ name = "愤怒掌控", { -1, 12296, 0, }, passive = true, talent = true, },
		{ name = "盾牌猛击", { -1, 23922, 0, }, { 48, 23923, 2000, }, { 54, 23924, 2800, }, { 60, 23925, 3100, }, { 66, 25258, 3250, }, { 70, 30356, 3250, }, talent = true, },
		{ name = "横扫攻击", { -1, 12328, 0, }, talent = true, },
		{ name = "死亡之愿", { -1, 12292, 0, }, talent = true, },
		{ name = "嗜血", { -1, 23881, 0, }, { 48, 23892, 2000, }, { 54, 23893, 2800, }, { 60, 23894, 3100, }, { 66, 25251, 3250, }, { 70, 30335, 3250, }, talent = true, },
		{ name = "震荡猛击", { -1, 12809, 0, }, talent = true, },
		{ name = "暴怒", { -1, 29801, 0, }, { 60, 30030, 3100, }, { 70, 30033, 3250, }, talent = true, },
		{ name = "破釜沉舟", { -1, 12975, 0, }, talent = true, },
	},
};

DT.TalentSpecIcon = {
	[41] = "Interface\\Icons\\spell_fire_firebolt02",
	[61] = "Interface\\Icons\\spell_frost_frostbolt02",
	[81] = "Interface\\Icons\\inv_misc_rune_03",
	[161] = "Interface\\Icons\\ability_rogue_eviscerate",--
	[163] = "Interface\\Icons\\ability_warrior_defensivestance",
	[164] = "Interface\\Icons\\ability_warrior_innerrage",
	[181] = "Interface\\Icons\\ability_backstab",
	[182] = "Interface\\Icons\\ability_rogue_eviscerate",--
	[183] = "Interface\\Icons\\Ability_Ambush",
	[201] = "Interface\\Icons\\spell_holy_wordfortitude",
	[202] = "Interface\\Icons\\spell_holy_holybolt",
	[203] = "Interface\\Icons\\spell_shadow_shadowwordpain",
	[261] = "Interface\\Icons\\spell_nature_lightning",
	[262] = "Interface\\Icons\\Spell_Nature_HealingWaveGreater",
	[263] = "Interface\\Icons\\spell_nature_lightningshield",
	[281] = "Interface\\Icons\\ability_racial_bearform",
	[282] = "Interface\\Icons\\Spell_Nature_HealingTouch",
	[283] = "Interface\\Icons\\spell_nature_starfall",
	[301] = "Interface\\Icons\\spell_shadow_rainoffire",
	[302] = "Interface\\Icons\\spell_shadow_deathcoil",
	[303] = "Interface\\Icons\\spell_shadow_metamorphosis",
	[361] = "Interface\\Icons\\Ability_Hunter_BeastTaming",
	[362] = "Interface\\Icons\\Ability_Hunter_SwiftStrike",
	[363] = "Interface\\Icons\\Ability_Marksmanship",
	[381] = "Interface\\Icons\\Spell_Holy_AuraOfLight",
	[382] = "Interface\\Icons\\Spell_Holy_HolyBolt",
	[383] = "Interface\\Icons\\Spell_Holy_DevotionAura",

	[398] = "Interface\\Icons\\Spell_Deathknight_BloodPresence",
	[399] = "Interface\\Icons\\Spell_Deathknight_FrostPresence",
	[400] = "Interface\\Icons\\Spell_Deathknight_UnholyPresence",
	[409] = "Interface\\Icons\\Ability_Hunter_Pet_Bear",
	[410] = "Interface\\Icons\\Ability_Druid_Swipe",
	[411] = "Interface\\Icons\\Ability_Hunter_CombatExperience",
};

DT.ClassBackground = {
	DEATHKNIGHT = {
		"Interface\\TalentFrame\\bg-deathknight-blood",
		"Interface\\TalentFrame\\bg-deathknight-frost",
		"Interface\\TalentFrame\\bg-deathknight-unholy",
	},
	DRUID = {
		"Interface\\TalentFrame\\bg-druid-balance",
		"Interface\\TalentFrame\\bg-druid-bear",
		"Interface\\TalentFrame\\bg-druid-cat",
		"Interface\\TalentFrame\\bg-druid-restoration",
	},
	HUNTER = {
		"Interface\\TalentFrame\\bg-hunter-beastmaster",
		"Interface\\TalentFrame\\bg-hunter-marksman",
		"Interface\\TalentFrame\\bg-hunter-survival",
	},
	MAGE = {
		"Interface\\TalentFrame\\bg-mage-arcane",
		"Interface\\TalentFrame\\bg-mage-fire",
		"Interface\\TalentFrame\\bg-mage-frost",
	},
	MONK = {
		"Interface\\TalentFrame\\bg-monk-battledancer",
		"Interface\\TalentFrame\\bg-monk-brewmaster",
		"Interface\\TalentFrame\\bg-monk-mistweaver",
	},
	PALADIN = {
		"Interface\\TalentFrame\\bg-paladin-holy",
		"Interface\\TalentFrame\\bg-paladin-protection",
		"Interface\\TalentFrame\\bg-paladin-retribution",
	},
	PRIEST = {
		"Interface\\TalentFrame\\bg-priest-discipline",
		"Interface\\TalentFrame\\bg-priest-holy",
		"Interface\\TalentFrame\\bg-priest-shadow",
	},
	ROGUE = {
		"Interface\\TalentFrame\\bg-rogue-assassination",
		"Interface\\TalentFrame\\bg-rogue-combat",
		"Interface\\TalentFrame\\bg-rogue-subtlety",
	},
	SHAMAN = {
		"Interface\\TalentFrame\\bg-shaman-elemental",
		"Interface\\TalentFrame\\bg-shaman-enhancement",
		"Interface\\TalentFrame\\bg-shaman-restoration",
	},
	WARLOCK = {
		"Interface\\TalentFrame\\bg-warlock-affliction",
		"Interface\\TalentFrame\\bg-warlock-demonology",
		"Interface\\TalentFrame\\bg-warlock-destruction",
	},
	WARRIOR = {
		"Interface\\TalentFrame\\bg-warrior-arms",
		"Interface\\TalentFrame\\bg-warrior-fury",
		"Interface\\TalentFrame\\bg-warrior-protection",
	},
};

DT.SpecBackground = {
		[283] = "Interface\\TalentFrame\\DruidBalance-TopLeft",
		[281] = "Interface\\TalentFrame\\DruidFeralCombat-TopLeft",
		[282] = "Interface\\TalentFrame\\DruidRestoration-TopLeft",
		[361] = "Interface\\TalentFrame\\HunterBeastMastery-TopLeft",
		[363] = "Interface\\TalentFrame\\HunterMarksmanship-TopLeft",
		[362] = "Interface\\TalentFrame\\HunterSurvival-TopLeft",
		[81] = "Interface\\TalentFrame\\MageArcane-TopLeft",
		[41] = "Interface\\TalentFrame\\MageFire-TopLeft",
		[61] = "Interface\\TalentFrame\\MageFrost-TopLeft",
		[382] = "Interface\\TalentFrame\\PaladinHoly-TopLeft",
		[383] = "Interface\\TalentFrame\\PaladinProtection-TopLeft",
		[381] = "Interface\\TalentFrame\\PaladinCombat-TopLeft",
		[201] = "Interface\\TalentFrame\\PriestDiscipline-TopLeft",
		[202] = "Interface\\TalentFrame\\PriestHoly-TopLeft",
		[203] = "Interface\\TalentFrame\\PriestShadow-TopLeft",
		[182] = "Interface\\TalentFrame\\RogueAssassination-TopLeft",
		[181] = "Interface\\TalentFrame\\RogueCombat-TopLeft",
		[183] = "Interface\\TalentFrame\\RogueSubtlety-TopLeft",
		[261] = "Interface\\TalentFrame\\ShamanElementalCombat-TopLeft",
		[263] = "Interface\\TalentFrame\\ShamanEnhancement-TopLeft",
		[262] = "Interface\\TalentFrame\\ShamanRestoration-TopLeft",
		[302] = "Interface\\TalentFrame\\WarlockCurses-TopLeft",
		[303] = "Interface\\TalentFrame\\WarlockSummoning-TopLeft",
		[301] = "Interface\\TalentFrame\\WarlockDestruction-TopLeft",
		[161] = "Interface\\TalentFrame\\WarriorArms-TopLeft",
		[164] = "Interface\\TalentFrame\\WarriorFury-TopLeft",
		[163] = "Interface\\TalentFrame\\WarriorProtection-TopLeft",
};

DT.PresetTalents = {
};

DT.LevelAvailablePointsTable = {  };
for i = 1, 9 do DT.LevelAvailablePointsTable[i] = 0; end
for i = 10, DT.MAX_LEVEL do DT.LevelAvailablePointsTable[i] = i - 9; end

DT.LevelAvailablePointsTableClass = {  };

DT.ItemLevelColor = {
	--	Kara/Mag/Gruul	115/125
	--	SC/TK			128/133/138/141
	--	BT/Hyjal		141/146/151/156
	--	ZAM				128/132/133
	--	SW				154/159/164
	step = {
		84,		--	灰色
		100,	--	白色
		115,	--	绿色
		128,	--	蓝色
		146,	--	紫色
		159,	--	橙色
	},
	list = {
		{ 0.5, 0.5, 0.5, },	--	灰色
		{ 1.0, 1.0, 1.0, },	--	白色
		{ 0.0, 1.0, 0.0, },	--	绿色
		{ 0.0, 0.5, 1.0, },	--	蓝色
		{ 0.6, 0.2, 1.0, },	--	紫色
		{ 1.0, 0.5, 0.0, },	--	橙色
	},
};

--	enchantID, spellID, itemID, classID, subClassMask, invTypeMask
local RawEnchantDB = {
	{ 15, 2831, 2304, 4, 30, 1050016, },
	{ 16, 2832, 2313, 4, 30, 1050016, },
	{ 17, 2833, 4265, 4, 30, 1050016, },
	{ 18, 10344, 8173, 4, 30, 1050016, },
	{ 24, 7443, 38769, 4, 31, 1048608, },
	{ 30, 3974, 4405, 2, 262156, nil, },
	{ 32, 3975, 4406, 2, 262156, nil, },
	{ 33, 3976, 4407, 2, 262156, nil, },
	{ 34, 7218, 6043, 2, 354, nil, },
	{ 36, 6296, 5421, 2, 189939, nil, },
	{ 37, 7220, 6041, 2, 173555, nil, },
	{ 41, 7418, 38679, 4, 31, 512, },
	{ 41, 7420, 38766, 4, 31, 1048608, },
	{ 43, 7216, 6042, 4, 96, nil, },
	{ 44, 7426, 38767, 4, 31, 1048608, },
	{ 63, 13538, 38798, 4, 31, 1048608, },
	{ 65, 7454, 38770, 4, 31, 65536, },
	{ 66, 7457, 38771, 4, 31, 512, },
	{ 66, 7863, 38785, 4, 31, 256, },
	{ 66, 13378, 38787, 4, 64, nil, },
	{ 241, 7745, 38772, 2, 1378, nil, },
	{ 241, 13503, 38794, 2, 189939, nil, },
	{ 242, 7748, 38773, 4, 31, 1048608, },
	{ 243, 7766, 38774, 4, 31, 512, },
	{ 246, 7776, 38776, 4, 31, 1048608, },
	{ 247, 7779, 38777, 4, 31, 512, },
	{ 247, 7867, 38786, 4, 31, 256, },
	{ 247, 13419, 38789, 4, 30, 65536, },
	{ 248, 7782, 38778, 4, 31, 512, },
	{ 249, 7786, 38779, 2, 189939, nil, },
	{ 250, 7788, 38780, 2, 189939, nil, },
	{ 254, 7857, 38782, 4, 31, 1048608, },
	{ 255, 7859, 38783, 4, 31, 512, },
	{ 255, 13380, 38788, 2, 1378, nil, },
	{ 255, 13485, 38792, 4, 64, nil, },
	{ 255, 13687, 38819, 4, 30, 256, },
	{ 256, 7861, 38784, 4, 31, 65536, },
	{ 368, 34004, 35432, 4, 30, 65536, },
	{ 369, 34001, 35423, 4, 30, 512, },
	{ 463, 9781, 7967, 4, 96, nil, },
	{ 464, 9783, 7969, 4, nil, 256, },
	{ 663, 12459, 10546, 2, 262156, nil, },
	{ 664, 12460, 10548, 2, 262156, nil, },
	{ 684, 33995, 35442, 4, 31, 1024, },
	{ 723, 7793, 38781, 2, 1378, nil, },
	{ 723, 13622, 38803, 4, 31, 512, },
	{ 724, 13501, 38793, 4, 31, 512, },
	{ 724, 13631, 38805, 4, 64, nil, },
	{ 724, 13644, 38810, 4, 30, 256, },
	{ 744, 13421, 38790, 4, nil, 65536, },
	{ 783, 7771, 38775, 4, 31, 65536, },
	{ 803, 13898, 38838, 2, 189939, nil, },
	{ 804, 13522, 38795, 4, 31, 65536, },
	{ 805, 13943, 38848, 2, 189939, nil, },
	{ 823, 13536, 38797, 4, 31, 512, },
	{ 843, 13607, 38799, 4, 31, 1048608, },
	{ 844, 13612, 38800, 4, 31, 1024, },
	{ 845, 13617, 38801, 4, 31, 1024, },
	{ 846, 24302, 19971, 2, 1048576, nil, },
	{ 846, 71692, 50816, 4, 31, 1024, },
	{ 847, 13626, 38804, 4, 31, 1048608, },
	{ 848, 13464, 38791, 4, 64, nil, },
	{ 848, 13635, 38806, 4, 30, 65536, },
	{ 849, 13637, 38807, 4, 31, 256, },
	{ 849, 13882, 38835, 4, 30, 65536, },
	{ 850, 13640, 38808, 4, 30, 1048608, },
	{ 851, 13642, 38809, 4, 30, 512, },
	{ 851, 13659, 38816, 4, 64, nil, },
	{ 851, 20024, 38864, 4, 30, 256, },
	{ 852, 13648, 38812, 4, 30, 512, },
	{ 852, 13817, 38828, 4, 64, nil, },
	{ 852, 13836, 38830, 4, 30, 256, },
	{ 853, 13653, 38813, 2, 189939, nil, },
	{ 854, 13655, 38814, 2, 189939, nil, },
	{ 856, 13661, 38817, 4, 30, 512, },
	{ 856, 13887, 38836, 4, 31, 1024, },
	{ 857, 13663, 38818, 4, 30, 1048608, },
	{ 863, 13689, 38820, 4, 64, nil, },
	{ 865, 13698, 38823, 4, 31, 1024, },
	{ 866, 13700, 38824, 4, 31, 1048608, },
	{ 884, 13746, 38825, 4, 30, 65536, },
	{ 903, 13794, 38826, 4, 30, 65536, },
	{ 904, 13815, 38827, 4, 31, 1024, },
	{ 904, 13935, 38844, 4, 30, 256, },
	{ 905, 13822, 38829, 4, 30, 512, },
	{ 906, 13841, 38831, 4, 31, 1024, },
	{ 907, 13846, 38832, 4, 30, 512, },
	{ 907, 13905, 38839, 4, 64, nil, },
	{ 908, 13858, 38833, 4, 31, 1048608, },
	{ 909, 13868, 38834, 4, 31, 1024, },
	{ 910, 25083, 38893, 4, 31, 65536, },
	{ 910, 359640, 187738, 4, 30, 65536, },
	{ 911, 13890, 38837, 4, 30, 256, },
	{ 912, 13915, 38840, 2, 189939, nil, },
	{ 913, 13917, 38841, 4, 31, 1048608, },
	{ 923, 13931, 38842, 4, 30, 512, },
	{ 924, 7428, 38768, 4, 31, 512, },
	{ 925, 13646, 38811, 4, 30, 512, },
	{ 926, 13933, 38843, 4, 64, nil, },
	{ 926, 359895, 187814, 4, 64, nil, },
	{ 927, 13939, 38846, 4, 30, 512, },
	{ 927, 20013, 38857, 4, 31, 1024, },
	{ 928, 13941, 38847, 4, 31, 1048608, },
	{ 929, 13945, 38849, 4, 30, 512, },
	{ 929, 20017, 38861, 4, 64, nil, },
	{ 929, 20020, 38862, 4, 30, 256, },
	{ 930, 13947, 38850, 4, 31, 1024, },
	{ 931, 13948, 38851, 4, 31, 1024, },
	{ 943, 13529, 38796, 2, 1378, nil, },
	{ 943, 13693, 38821, 2, 189939, nil, },
	{ 963, 13937, 38845, 2, 1378, nil, },
	{ 963, 27967, 35457, 2, 189939, nil, },
	{ 983, 44500, 38959, 4, 30, 65536, },
	{ 983, 44589, 38976, 4, 30, 256, },
	{ 1071, 34009, 35449, 4, 64, nil, },
	{ 1075, 44528, 38966, 4, 30, 256, },
	{ 1099, 60663, 44457, 4, 30, 65536, },
	{ 1103, 44633, 38995, 2, 177651, nil, },
	{ 1119, 44555, 38968, 4, 30, 512, },
	{ 1119, 47715, nil, 4, 30, 512, },
	{ 1128, 60653, 44455, 4, 64, nil, },
	{ 1144, 33990, 35431, 4, 31, 1048608, },
	{ 1147, 44508, 38961, 4, 30, 256, },
	{ 1147, 44593, 38980, 4, 30, 512, },
	{ 1257, 34005, 35433, 4, 30, 65536, },
	{ 1262, 44596, 38982, 4, 30, 65536, },
	{ 1354, 44556, 38969, 4, 30, 65536, },
	{ 1400, 44494, 38956, 4, 30, 65536, },
	{ 1441, 34006, 35434, 4, 30, 65536, },
	{ 1446, 44590, 38977, 4, 30, 65536, },
	{ 1483, 15340, 11622, 4, 31, 130, },
	{ 1503, 15389, 11642, 4, 31, 130, },
	{ 1504, 15391, 11643, 4, 31, 130, },
	{ 1505, 15394, 11644, 4, 31, 130, },
	{ 1506, 15397, 11645, 4, 31, 130, },
	{ 1507, 15400, 11646, 4, 31, 130, },
	{ 1508, 15402, 11647, 4, 31, 130, },
	{ 1509, 15404, 11648, 4, 31, 130, },
	{ 1510, 15406, 11649, 4, 31, 130, },
	{ 1593, 34002, 38938, 4, 30, 512, },
	{ 1593, 359639, 187737, 4, 30, 512, },
	{ 1594, 33996, 35438, 4, 31, 1024, },
	{ 1597, 60763, 44469, 4, 30, 256, },
	{ 1600, 60616, 38971, 4, 30, 512, },
	{ 1603, 60668, 44458, 4, 30, 1024, },
	{ 1606, 60621, 44453, 2, 189939, nil, },
	{ 1704, 16623, 12645, 4, 96, nil, },
	{ 1843, 19057, 15564, 4, 30, 1050016, },
	{ 1883, 20008, 38852, 4, 30, 512, },
	{ 1884, 20009, 38853, 4, 30, 512, },
	{ 1885, 20010, 38854, 4, 30, 512, },
	{ 1886, 20011, 38855, 4, 30, 512, },
	{ 1887, 20012, 38856, 4, 31, 1024, },
	{ 1887, 20023, 38863, 4, 30, 256, },
	{ 1888, 20014, 38858, 4, 30, 65536, },
	{ 1888, 27947, 35450, 4, 64, nil, },
	{ 1889, 20015, 38859, 4, 30, 65536, },
	{ 1890, 20016, 38860, 4, 64, nil, },
	{ 1891, 20025, 38865, 4, 31, 1048608, },
	{ 1891, 27905, 35426, 4, 30, 512, },
	{ 1892, 20026, 38866, 4, 31, 1048608, },
	{ 1893, 20028, 38867, 4, 31, 1048608, },
	{ 1894, 20029, 38868, 2, 189939, nil, },
	{ 1896, 20030, 38869, 2, 1378, nil, },
	{ 1897, 13695, 38822, 2, 1378, nil, },
	{ 1897, 20031, 38870, 2, 189939, nil, },
	{ 1898, 20032, 38871, 2, 189939, nil, },
	{ 1898, 27964, 38916, 2, 189939, nil, },
	{ 1899, 20033, 38872, 2, 189939, nil, },
	{ 1900, 20034, 38873, 2, 189939, nil, },
	{ 1903, 20035, 38874, 2, 1378, nil, },
	{ 1904, 20036, 38875, 2, 1378, nil, },
	{ 1951, 44591, 38978, 4, 30, 65536, },
	{ 1951, 46594, 38999, 4, 31, 1048608, },
	{ 1952, 44489, 38954, 4, 64, nil, },
	{ 1953, 47766, 39002, 4, 31, 1048608, },
	{ 2322, 33999, 35440, 4, 31, 1024, },
	{ 2326, 44635, 38997, 4, 30, 512, },
	{ 2332, 60767, 44470, 4, 30, 512, },
	{ 2381, 44509, 38962, 4, 30, 1048608, },
	{ 2443, 21931, 38876, 2, 196083, nil, },
	{ 2463, 13657, 38815, 4, 30, 65536, },
	{ 2483, 22593, 18169, 4, 30, 8, },
	{ 2484, 22594, 18170, 4, 30, 8, },
	{ 2485, 22598, 18171, 4, 30, 8, },
	{ 2486, 22597, 18172, 4, 30, 8, },
	{ 2487, 22596, 18173, 4, 30, 8, },
	{ 2488, 22599, 18182, 4, 30, 8, },
	{ 2503, 22725, 18251, 4, 30, 1050016, },
	{ 2504, 22749, 38877, 2, 58867, nil, },
	{ 2505, 22750, 38878, 2, 58867, nil, },
	{ 2523, 22779, 18283, 2, 262156, nil, },
	{ 2523, 30255, nil, 2, 262156, nil, },
	{ 2543, 22840, 18329, 4, 31, 130, },
	{ 2544, 22844, 18330, 4, 31, 130, },
	{ 2545, 22846, 18331, 4, 31, 130, },
	{ 2563, 23799, 38879, 2, 58867, nil, },
	{ 2564, 23800, 38880, 2, 58867, nil, },
	{ 2564, 25080, 38890, 4, 31, 1024, },
	{ 2564, 359641, 187739, 4, 30, 1024, },
	{ 2565, 23801, 38881, 4, 30, 512, },
	{ 2567, 23803, 38883, 2, 58867, nil, },
	{ 2567, 359642, 187740, 2, 58867, nil, },
	{ 2568, 23804, 38884, 2, 58867, nil, },
	{ 2583, 24149, 19782, 4, 31, 130, },
	{ 2584, 24160, 19783, 4, 31, 130, },
	{ 2587, 24163, 19786, 4, 31, 130, },
	{ 2588, 24164, 19787, 4, 31, 130, },
	{ 2589, 24165, 19788, 4, 31, 130, },
	{ 2590, 24167, 19789, 4, 31, 130, },
	{ 2591, 24168, 19790, 4, 31, 130, },
	{ 2603, 13620, 38802, 4, 31, 1024, },
	{ 2604, 24420, 20078, 4, 30, 8, },
	{ 2605, 24421, 20076, 4, 30, 8, },
	{ 2606, 24422, 20077, 4, 30, 8, },
	{ 2613, 25072, 38885, 4, 31, 1024, },
	{ 2613, 359858, 187801, 4, 31, 1024, },
	{ 2614, 25073, 38886, 4, 31, 1024, },
	{ 2615, 25074, 38887, 4, 31, 1024, },
	{ 2616, 25078, 38888, 4, 31, 1024, },
	{ 2617, 25079, 38889, 4, 31, 1024, },
	{ 2619, 25081, 38891, 4, 31, 65536, },
	{ 2619, 359950, 187815, 4, 30, 65536, },
	{ 2620, 25082, 38892, 4, 31, 65536, },
	{ 2620, 359949, 187807, 4, 30, 65536, },
	{ 2621, 25084, 38894, 4, 31, 65536, },
	{ 2621, 359847, 187800, 4, 30, 65536, },
	{ 2622, 25086, 38895, 4, 31, 65536, },
	{ 2646, 27837, 38896, 2, 1378, nil, },
	{ 2647, 27899, 35420, 4, 30, 512, },
	{ 2648, 27906, 35422, 4, 30, 512, },
	{ 2648, 47051, 39000, 4, 31, 65536, },
	{ 2649, 27914, 35421, 4, 30, 512, },
	{ 2649, 27950, 35417, 4, 30, 256, },
	{ 2650, 23802, 38882, 4, 30, 512, },
	{ 2650, 27911, 35427, 4, 30, 512, },
	{ 2650, 27917, 35425, 4, 30, 512, },
	{ 2653, 27944, 38904, 4, 64, nil, },
	{ 2654, 27945, 35448, 4, 64, nil, },
	{ 2655, 27946, 35451, 4, 64, nil, },
	{ 2656, 27948, 35419, 4, 30, 256, },
	{ 2657, 27951, 35400, 4, 30, 256, },
	{ 2658, 27954, 35418, 4, 30, 256, },
	{ 2659, 27957, 35428, 4, 31, 1048608, },
	{ 2661, 27960, 35429, 4, 31, 1048608, },
	{ 2661, 44616, 38987, 4, 30, 512, },
	{ 2662, 27961, 35437, 4, 30, 65536, },
	{ 2664, 27962, 35435, 4, 30, 65536, },
	{ 2666, 27968, 35455, 2, 58867, nil, },
	{ 2667, 27971, 35397, 2, 132450, nil, },
	{ 2668, 27972, 35459, 2, 189939, nil, },
	{ 2669, 27975, 35456, 2, 173555, nil, },
	{ 2670, 27977, 35396, 2, 132450, nil, },
	{ 2671, 27981, 35462, 2, 189939, nil, },
	{ 2672, 27982, 35460, 2, 189939, nil, },
	{ 2673, 27984, 35458, 2, 189939, nil, },
	{ 2674, 28003, 35461, 2, 189939, nil, },
	{ 2675, 28004, 35452, 2, 189939, nil, },
	{ 2679, 27913, 35424, 4, 30, 512, },
	{ 2681, 28161, 22635, 4, 31, 130, },
	{ 2682, 28163, 22636, 4, 31, 130, },
	{ 2683, 28165, 22638, 4, 31, 130, },
	{ 2714, 29454, 23530, 4, 96, nil, },
	{ 2715, 29475, 23547, 4, 30, 8, },
	{ 2716, 29480, 23549, 4, 30, 8, },
	{ 2717, 29483, 23548, 4, 30, 8, },
	{ 2721, 29467, 23545, 4, 30, 8, },
	{ 2722, 30250, 23764, 2, 262156, nil, },
	{ 2723, 30252, 23765, 2, 262156, nil, },
	{ 2724, 30258, nil, 2, 262156, nil, },
	{ 2724, 30260, 23766, 2, 262156, nil, },
	{ 2745, 31369, 24275, 4, 31, 128, },
	{ 2746, 31370, 24276, 4, 31, 128, },
	{ 2747, 31371, 24273, 4, 31, 128, },
	{ 2748, 31372, 24274, 4, 31, 128, },
	{ 2792, 32397, 25650, 4, 30, 1050016, },
	{ 2793, 32398, 25651, 4, 30, 1050016, },
	{ 2794, 32399, 25652, 4, 30, 1050016, },
	{ 2841, 44968, 34330, 4, 30, 1050026, },
	{ 2928, 27924, 35445, 4, nil, 2048, },
	{ 2929, 27920, 35447, 4, nil, 2048, },
	{ 2930, 27926, 35444, 4, nil, 2048, },
	{ 2931, 27927, 35446, 4, nil, 2048, },
	{ 2933, 33992, 35430, 4, 31, 1048608, },
	{ 2934, 33993, 35439, 4, 31, 1024, },
	{ 2935, 33994, 35443, 4, 31, 1024, },
	{ 2937, 33997, 35441, 4, 31, 1024, },
	{ 2938, 34003, 35436, 4, 30, 65536, },
	{ 2939, 34007, 35399, 4, 30, 256, },
	{ 2940, 34008, 35398, 4, 30, 256, },
	{ 2977, 35355, 28882, 4, 31, 8, },
	{ 2978, 35402, 28889, 4, 31, 8, },
	{ 2979, 35403, 28878, 4, 31, 8, },
	{ 2980, 35404, 28887, 4, 31, 8, },
	{ 2981, 35405, 28881, 4, 31, 8, },
	{ 2982, 35406, 28886, 4, 31, 8, },
	{ 2983, 35407, 28885, 4, 31, 8, },
	{ 2984, 35415, 29483, 4, 30, 1050016, },
	{ 2985, 35416, 29485, 4, 30, 1050016, },
	{ 2986, 35417, 28888, 4, 31, 8, },
	{ 2987, 35418, 29486, 4, 30, 1050016, },
	{ 2988, 35419, 29487, 4, 30, 1050016, },
	{ 2989, 35420, 29488, 4, 30, 1050016, },
	{ 2990, 35432, 28908, 4, 31, 8, },
	{ 2991, 35433, 28911, 4, 31, 8, },
	{ 2992, 35434, 28904, 4, 31, 8, },
	{ 2993, 35435, 28912, 4, 31, 8, },
	{ 2994, 35436, 28903, 4, 31, 8, },
	{ 2995, 35437, 28909, 4, 31, 8, },
	{ 2996, 35438, 28907, 4, 31, 8, },
	{ 2997, 35439, 28910, 4, 31, 8, },
	{ 2998, 35441, 29187, 4, 30, 8, },
	{ 2999, 35443, 29186, 4, 31, 2, },
	{ 3001, 35445, 29189, 4, 31, 2, },
	{ 3002, 35447, 29191, 4, 31, 2, },
	{ 3003, 35452, 29192, 4, 31, 2, },
	{ 3004, 35453, 29193, 4, 31, 2, },
	{ 3005, 35454, 29194, 4, 31, 2, },
	{ 3006, 35455, 29195, 4, 31, 2, },
	{ 3007, 35456, 29196, 4, 31, 2, },
	{ 3008, 35457, 29198, 4, 31, 2, },
	{ 3009, 35458, 29199, 4, 31, 2, },
	{ 3010, 35488, 29533, 4, 31, 128, },
	{ 3011, 35489, 29534, 4, 31, 128, },
	{ 3012, 35490, 29535, 4, 31, 128, },
	{ 3013, 35495, 29536, 4, 31, 128, },
	{ 3095, 37889, 30845, 4, 31, 2, },
	{ 3096, 37891, 30846, 4, 31, 2, },
	{ 3150, 33991, 38929, 4, 31, 1048608, },
	{ 3222, 42620, 35453, 2, 189939, nil, },
	{ 3222, 44529, 38967, 4, 30, 1024, },
	{ 3223, 42687, 33185, 2, 173555, nil, },
	{ 3225, 42974, 38948, 2, 189939, nil, },
	{ 3228, 44119, nil, 4, 30, 512, },
	{ 3229, 44383, 38949, 4, 64, nil, },
	{ 3229, 359685, 187783, 4, 64, nil, },
	{ 3230, 44483, 38950, 4, 30, 65536, },
	{ 3231, 44484, 38951, 4, 30, 1024, },
	{ 3231, 44598, 38984, 4, 30, 512, },
	{ 3232, 47901, 39006, 4, 30, 256, },
	{ 3233, 27958, 38912, 4, 31, 1048608, },
	{ 3234, 44488, 38953, 4, 31, 1024, },
	{ 3236, 44492, 38955, 4, 30, 1048608, },
	{ 3238, 44506, 38960, 4, 30, 1024, },
	{ 3239, 44524, 38965, 2, 177651, nil, },
	{ 3241, 44576, 38972, 2, 173555, nil, },
	{ 3243, 44582, 38973, 4, 30, 65536, },
	{ 3244, 44584, 38974, 4, 30, 256, },
	{ 3245, 44588, 38975, 4, 30, 1048608, },
	{ 3246, 44592, 38979, 4, 30, 1024, },
	{ 3247, 44595, 38981, 2, 132450, nil, },
	{ 3249, 44612, 38985, 4, 30, 1024, },
	{ 3251, 44621, 38988, 2, 173555, nil, },
	{ 3252, 44623, 38989, 4, 30, 1048608, },
	{ 3253, 44625, 38990, 4, 31, 1024, },
	{ 3256, 44631, 38993, 4, 30, 65536, },
	{ 3260, 44769, 34207, 4, 30, 1024, },
	{ 3269, 45697, 34836, 2, 1048576, nil, },
	{ 3273, 46578, 38998, 2, 189939, nil, },
	{ 3290, 52639, 39300, 4, nil, 65536, },
	{ 3294, 47672, 39001, 4, 30, 65536, },
	{ 3296, 47899, 39004, 4, 30, 65536, },
	{ 3297, 47900, 39005, 4, 30, 1048608, },
	{ 3297, 48036, nil, 4, 30, 1048608, },
	{ 3319, 50465, nil, 2, 41105, nil, },
	{ 3325, 50901, 38371, 4, 31, 128, },
	{ 3326, 50902, 38372, 4, 31, 128, },
	{ 3327, 50903, nil, 4, 31, 128, },
	{ 3327, 60583, nil, 4, 30, 128, },
	{ 3328, 50904, nil, 4, 31, 128, },
	{ 3328, 60584, nil, 4, 30, 128, },
	{ 3329, 50906, 38375, 4, 30, 1050026, },
	{ 3330, 50909, 38376, 4, 30, 1050026, },
	{ 3331, 50911, 38377, 4, 31, 128, },
	{ 3332, 50913, 38378, 4, 31, 128, },
	{ 3365, 53323, nil, 2, 1378, nil, },
	{ 3366, 53331, nil, 2, 189939, nil, },
	{ 3367, 53342, nil, 2, 1378, nil, },
	{ 3368, 53344, nil, 2, 189939, nil, },
	{ 3369, 53341, nil, 2, 189939, nil, },
	{ 3370, 53343, nil, 2, 189939, nil, },
	{ 3594, 54446, nil, 2, 32913, nil, },
	{ 3595, 54447, nil, 2, 32913, nil, },
	{ 3599, 54736, 40776, 4, 30, 64, },
	{ 3601, 54793, 40800, 4, 30, 64, },
	{ 3603, 54998, 41091, 4, 30, 1024, },
	{ 3604, 54999, nil, 4, 30, 1024, },
	{ 3605, 55002, 41111, 4, 30, 65536, },
	{ 3606, 55016, 41118, 4, 30, 256, },
	{ 3607, 55076, 41146, 2, 262156, nil, },
	{ 3608, 55135, 41167, 2, 262156, nil, },
	{ 3718, 55630, 41601, 4, 31, 128, },
	{ 3719, 55631, 41602, 4, 31, 128, },
	{ 3720, 55632, 41603, 4, 31, 128, },
	{ 3721, 55634, 41604, 4, 31, 128, },
	{ 3722, 55642, nil, 4, 30, 65536, },
	{ 3728, 55769, nil, 4, 30, 65536, },
	{ 3730, 55777, nil, 4, 30, 65536, },
	{ 3731, 55836, 41976, 2, 173555, nil, },
	{ 3748, 56353, 42500, 4, 96, nil, },
	{ 3754, 24162, 19785, 4, 31, 130, },
	{ 3755, 24161, 19784, 4, 31, 130, },
	{ 3756, 57683, 43097, 4, 30, 512, },
	{ 3757, 57690, nil, 4, 30, 512, },
	{ 3758, 57691, nil, 4, 30, 512, },
	{ 3759, 57692, 44559, 4, 30, 512, },
	{ 3760, 57694, 44560, 4, 30, 512, },
	{ 3761, 57696, 44561, 4, 30, 512, },
	{ 3762, 57699, 44562, 4, 30, 512, },
	{ 3763, 57701, 44563, 4, 30, 512, },
	{ 3775, 58126, 43302, 4, 31, 8, },
	{ 3776, 58128, 43303, 4, 31, 8, },
	{ 3777, 58129, 43304, 4, 31, 8, },
	{ 3788, 59619, 44497, 2, 177651, nil, },
	{ 3789, 59621, 44493, 2, 173555, nil, },
	{ 3790, 59625, 43987, 2, 173555, nil, },
	{ 3791, 59636, nil, 4, nil, 2048, },
	{ 3793, 59771, 44067, 4, 31, 8, },
	{ 3794, 59773, 44068, 4, 31, 8, },
	{ 3795, 59777, 44069, 4, 31, 2, },
	{ 3796, 59778, nil, 4, 31, 2, },
	{ 3797, 59784, 44075, 4, 31, 2, },
	{ 3806, 59927, 44129, 4, 31, 8, },
	{ 3807, 59928, 44130, 4, 31, 8, },
	{ 3808, 59934, 44133, 4, 31, 8, },
	{ 3809, 59936, 44134, 4, 31, 8, },
	{ 3810, 59937, 44135, 4, 31, 8, },
	{ 3811, 59941, 44136, 4, 31, 8, },
	{ 3812, 59944, 44137, 4, 31, 2, },
	{ 3813, 59945, 44138, 4, 31, 2, },
	{ 3814, 59946, 44139, 4, 31, 2, },
	{ 3815, 59947, 44140, 4, 31, 2, },
	{ 3816, 59948, 44141, 4, 31, 2, },
	{ 3817, 59954, 44149, 4, 31, 2, },
	{ 3818, 59955, 44150, 4, 31, 2, },
	{ 3819, 59960, 44152, 4, 31, 2, },
	{ 3820, 59970, 44159, 4, 31, 2, },
	{ 3822, 60581, 38373, 4, 31, 128, },
	{ 3823, 60582, 38374, 4, 31, 128, },
	{ 3824, 60606, 44449, 4, 30, 256, },
	{ 3825, 60609, 44456, 4, 30, 65536, },
	{ 3826, 60623, 38986, 4, 30, 256, },
	{ 3827, 60691, 44463, 2, 136546, nil, },
	{ 3828, 44630, 38992, 2, 132450, nil, },
	{ 3829, 44513, 38964, 4, 30, 1024, },
	{ 3830, 44629, 38991, 2, 177651, nil, },
	{ 3831, 47898, 39003, 4, 30, 65536, },
	{ 3832, 60692, 44465, 4, 30, 1048608, },
	{ 3833, 60707, 44466, 2, 189939, nil, },
	{ 3834, 60714, 44467, 2, 177651, nil, },
	{ 3835, 61117, nil, 4, 31, 8, },
	{ 3836, 61118, nil, 4, 31, 8, },
	{ 3837, 61119, nil, 4, 31, 8, },
	{ 3838, 61120, nil, 4, 31, 8, },
	{ 3839, 44645, nil, 4, nil, 2048, },
	{ 3840, 44636, nil, 4, nil, 2048, },
	{ 3842, 61271, 44701, 4, 31, 2, },
	{ 3843, 61468, 44739, 2, 262156, nil, },
	{ 3844, 44510, 38963, 2, 177651, nil, },
	{ 3845, 44575, 44815, 4, 30, 512, },
	{ 3846, 34010, 35454, 2, 189939, nil, },
	{ 3847, 62158, nil, 2, 1378, nil, },
	{ 3849, 62201, 44936, 4, 64, nil, },
	{ 3850, 62256, 44947, 4, 30, 512, },
	{ 3851, 62257, 44946, 2, 189939, nil, },
	{ 3852, 62384, 44957, 4, 31, 8, },
	{ 3853, 62447, 44963, 4, 31, 128, },
	{ 3854, 62948, 45056, 2, 1024, nil, },
	{ 3855, 62959, 45060, 2, 1024, nil, },
	{ 3858, 63746, 45628, 4, 30, 256, },
	{ 3859, 63765, nil, 4, 30, 65536, },
	{ 3860, 63770, nil, 4, 30, 1024, },
	{ 3869, 64441, 46026, 2, 189939, nil, },
	{ 3870, 64579, 46098, 2, 189939, nil, },
	{ 3872, 56039, nil, 4, 31, 128, },
	{ 3873, 56034, nil, 4, 31, 128, },
	{ 3875, 59929, 44131, 4, 31, 8, },
	{ 3876, 59932, 44132, 4, 31, 8, },
	{ 3878, 67839, nil, 4, nil, 2, },
	{ 3883, 70164, nil, 2, 32913, nil, },
};
--	[classID][enchantID] = { subClassMask, invTypeMask, spellID, itemID, }
local EnchantDB = {  };
for _, info in next, RawEnchantDB do
	local classID = info[4];
	if classID then
		local TO = EnchantDB[classID];
		if TO == nil then
			TO = {  };
			EnchantDB[classID] = TO;
		end
		local enchantID = info[1];
		local to = TO[enchantID];
		if to == nil then
			to = {  };
			TO[enchantID] = to;
		end
		to[#to + 1] = { info[5], info[6], info[2], info[3], };
	end
end
DT.EnchantDB = EnchantDB;
DT.EnchantableByLoc = {
	INVTYPE_HEAD = 1,
	INVTYPE_SHOULDER = 1,
	INVTYPE_CHEST = 1,
	INVTYPE_LEGS = 1,
	INVTYPE_FEET = 1,
	INVTYPE_WRIST = 1,
	INVTYPE_HAND = 1,
	INVTYPE_CLOAK = 1,
	INVTYPE_WEAPON = 1,
	INVTYPE_2HWEAPON = 1,
	INVTYPE_SHIELD = 1,
	INVTYPE_RANGED = 1,
	INVTYPE_ROBE = 1,
	INVTYPE_WEAPONMAINHAND = 1,
	INVTYPE_WEAPONOFFHAND = 1,
	INVTYPE_RANGEDRIGHT = 1,
};
local EnumItemClass = Enum and Enum.ItemClass or {
	Weapon = 2,
};
local EnumWSubClass = Enum and Enum.ItemWeaponSubclass or {
	Axe1H = 0,
	Axe2H = 1,
	Bows = 2,
	Guns = 3,
	Mace1H = 4,
	Mace2H = 5,
	Polearm = 6,
	Sword1H = 7,
	Sword2H = 8,
	Warglaive = 9,
	Staff = 10,
	Bearclaw = 11,
	Catclaw = 12,
	Unarmed = 13,
	Generic = 14,
	Dagger = 15,
	Thrown = 16,
	Obsolete3 = 17,
	Crossbow = 18,
	Wand = 19,
	Fishingpole = 20,
};
DT.UnenchantableByType = {
	[EnumItemClass.Weapon] = {
		[EnumWSubClass.Generic] = 1,
		[EnumWSubClass.Thrown] = 1,
		[EnumWSubClass.Wand] = 1,
		[EnumWSubClass.Fishingpole] = 1,
		[EnumWSubClass.Bows] = 'HUNTER',
		[EnumWSubClass.Guns] = 'HUNTER',
		[EnumWSubClass.Crossbow] = 'HUNTER',
	},
};

DT.ItemSet = {
	[1] = { 11729, 11726, 11728, 11731, 11730, },
	[41] = { 12940, 12939, },
	[65] = { 13218, 13183, },
	[81] = { 13390, 13388, 13391, 13392, 13389, },
	[121] = { 14637, 14636, 14640, 14638, 14641, },
	[122] = { 14631, 14629, 14632, 14633, 14626, },
	[123] = { 14614, 14616, 14615, 14611, 14612, },
	[124] = { 14624, 14622, 14620, 14623, 14621, },
	[141] = { 15053, 15054, 15055, },
	[142] = { 15056, 15057, 15058, 21278, },
	[143] = { 15062, 15063, },
	[144] = { 15066, 15067, },
	[161] = { 10399, 10403, 10402, 10401, 10400, },
	[162] = { 10412, 10411, 10413, 10410, 6473, },
	[163] = { 10329, 10332, 10328, 10331, 10330, 10333, },
	[181] = { 16685, 16683, 16686, 16684, 16687, 16689, 16688, 16682, },
	[182] = { 16696, 16691, 16697, 16693, 16692, 16695, 16694, 16690, },
	[183] = { 16702, 16703, 16699, 16701, 16700, 16704, 16698, 16705, },
	[184] = { 16713, 16711, 16710, 16721, 16708, 16709, 16712, 16707, },
	[185] = { 16716, 16715, 16714, 16720, 16706, 16718, 16719, 16717, },
	[186] = { 16680, 16675, 16681, 16677, 16674, 16678, 16679, 16676, },
	[187] = { 16673, 16670, 16671, 16667, 16672, 16668, 16669, 16666, },
	[188] = { 16723, 16725, 16722, 16726, 16724, 16728, 16729, 16727, },
	[189] = { 16736, 16734, 16735, 16730, 16737, 16731, 16732, 16733, },
	[201] = { 16802, 16799, 16795, 16800, 16801, 16796, 16797, 16798, },
	[202] = { 16811, 16813, 16817, 16812, 16814, 16816, 16815, 16819, },
	[203] = { 16806, 16804, 16805, 16810, 16809, 16807, 16808, 16803, },
	[204] = { 16827, 16824, 16825, 16820, 16821, 16826, 16822, 16823, },
	[205] = { 16828, 16829, 16830, 16833, 16831, 16834, 16835, 16836, },
	[206] = { 16851, 16849, 16850, 16845, 16848, 16852, 16846, 16847, },
	[207] = { 16838, 16837, 16840, 16841, 16844, 16839, 16842, 16843, },
	[208] = { 16858, 16859, 16857, 16853, 16860, 16854, 16855, 16856, },
	[209] = { 16864, 16861, 16865, 16863, 16866, 16867, 16868, 16862, },
	[210] = { 16818, 16918, 16912, 16914, 16917, 16913, 16915, 16916, },
	[211] = { 16925, 16926, 16919, 16921, 16920, 16922, 16924, 16923, },
	[212] = { 16933, 16927, 16934, 16928, 16930, 16931, 16929, 16932, },
	[213] = { 16910, 16906, 16911, 16905, 16907, 16908, 16909, 16832, },
	[214] = { 16903, 16898, 16904, 16897, 16900, 16899, 16901, 16902, },
	[215] = { 16936, 16935, 16942, 16940, 16941, 16939, 16938, 16937, },
	[216] = { 16944, 16943, 16950, 16945, 16948, 16949, 16947, 16946, },
	[217] = { 16952, 16951, 16958, 16955, 16956, 16954, 16957, 16953, },
	[218] = { 16959, 16966, 16964, 16963, 16962, 16961, 16965, 16960, },
	[221] = { 7950, 7948, 7952, 7951, 7953, 7949, },
	[241] = { 17082, 17064, },
	[261] = { 18203, 18202, 18204, 18205, },
	[281] = { 16509, 16510, 16513, 16515, 16514, 16516, },
	[282] = { 16405, 16406, 16430, 16431, 16429, 16432, },
	[301] = { 16519, 16518, 16522, 16523, 16521, 16524, },
	[321] = { 12424, 12426, 12425, 12422, 12427, 12429, 12428, },
	[341] = { 16485, 16487, 16491, 16490, 16489, 16492, },
	[342] = { 17616, 17617, 17612, 17611, 17613, 17610, },
	[343] = { 16369, 16391, 16413, 16414, 16416, 16415, },
	[344] = { 17594, 17596, 17600, 17599, 17598, 17601, },
	[345] = { 17576, 17577, 17572, 17571, 17570, 17573, },
	[346] = { 17562, 17564, 17568, 17567, 17569, 17566, },
	[347] = { 16498, 16499, 16505, 16508, 16506, 16507, },
	[348] = { 16392, 16396, 16417, 16419, 16420, 16418, },
	[361] = { 16531, 16530, 16525, 16527, 16526, 16528, },
	[362] = { 16425, 16426, 16401, 16403, 16428, 16427, },
	[381] = { 16423, 16424, 16422, 16421, 16393, 16397, },
	[382] = { 16494, 16496, 16504, 16502, 16503, 16501, },
	[383] = { 16541, 16542, 16544, 16545, 16548, 16543, },
	[384] = { 16477, 16478, 16480, 16483, 16484, 16479, },
	[386] = { 16577, 16578, 16580, 16573, 16574, 16579, },
	[387] = { 16536, 16533, 16535, 16539, 16540, 16534, },
	[388] = { 16441, 16444, 16443, 16437, 16440, 16442, },
	[389] = { 17604, 17603, 17605, 17608, 17607, 17602, },
	[390] = { 17623, 17625, 17622, 17624, 17618, 17620, },
	[391] = { 17586, 17588, 17593, 17591, 17590, 17592, },
	[392] = { 17581, 17580, 17583, 17584, 17579, 17578, },
	[393] = { 16563, 16561, 16562, 16564, 16560, 16558, },
	[394] = { 16453, 16457, 16455, 16446, 16454, 16456, },
	[395] = { 16466, 16465, 16468, 16462, 16463, 16467, },
	[396] = { 16569, 16571, 16567, 16565, 16566, 16568, },
	[397] = { 16452, 16451, 16449, 16459, 16448, 16450, },
	[398] = { 16554, 16555, 16552, 16551, 16549, 16550, },
	[401] = { 16410, 16409, 16433, 16435, 16434, 16436, },
	[402] = { 16473, 16474, 16476, 16472, 16471, 16475, },
	[421] = { 19682, 19683, 19684, },
	[441] = { 19685, 19687, 19686, },
	[442] = { 19688, 19689, },
	[443] = { 19690, 19691, 19692, },
	[444] = { 19693, 19694, 19695, },
	[461] = { 19865, 19866, },
	[462] = { 19905, 19893, },
	[463] = { 19896, 19910, },
	[464] = { 19873, 19912, },
	[465] = { 19863, 19920, },
	[466] = { 19898, 19925, },
	[467] = { 20041, 20048, 20057, },
	[468] = { 20042, 20049, 20058, },
	[469] = { 20043, 20050, 20055, },
	[470] = { 20044, 20051, 20056, },
	[471] = { 20052, 20045, 20059, },
	[472] = { 20053, 20046, 20060, },
	[473] = { 20054, 20047, 20061, },
	[474] = { 19951, 19577, 19824, 19823, 19822, },
	[475] = { 19952, 19588, 19827, 19826, 19825, },
	[476] = { 19609, 19956, 19830, 19829, 19828, },
	[477] = { 19621, 19953, 19833, 19832, 19831, },
	[478] = { 19617, 19954, 19836, 19835, 19834, },
	[479] = { 19613, 19955, 19840, 19839, 19838, },
	[480] = { 19594, 19958, 19843, 19842, 19841, },
	[481] = { 19605, 19957, 19848, 19849, 20033, },
	[482] = { 19601, 19959, 19846, 19845, 20034, },
	[483] = { 20158, 20154, 20150, },
	[484] = { 20195, 20199, 20203, },
	[485] = { 20176, 20159, 20163, },
	[486] = { 20186, 20190, 20194, },
	[487] = { 20204, 20208, 20212, },
	[488] = { 20167, 20171, 20175, },
	[489] = { 16984, 15050, 15052, 15051, },
	[490] = { 15045, 15046, 20296, },
	[491] = { 15048, 20295, 15049, },
	[492] = { 20406, 20408, 20407, },
	[493] = { 21355, 21353, 21354, 21356, 21357, },
	[494] = { 21408, 21409, 21407, },
	[495] = { 21394, 21392, 21393, },
	[496] = { 21331, 21329, 21333, 21332, 21330, },
	[497] = { 21359, 21360, 21361, 21362, 21364, },
	[498] = { 21405, 21406, 21404, },
	[499] = { 21337, 21338, 21335, 21334, 21336, },
	[500] = { 21416, 21417, 21418, },
	[501] = { 21372, 21373, 21374, 21375, 21376, },
	[502] = { 21400, 21398, 21399, },
	[503] = { 21344, 21347, 21346, 21343, 21345, },
	[504] = { 21414, 21413, 21415, },
	[505] = { 21389, 21387, 21388, 21390, 21391, },
	[506] = { 21397, 21395, 21396, },
	[507] = { 21349, 21350, 21348, 21352, 21351, },
	[508] = { 21410, 21411, 21412, },
	[509] = { 21366, 21365, 21370, 21368, 21367, },
	[510] = { 21403, 21401, 21402, },
	[511] = { 21994, 21995, 21996, 21997, 21998, 21999, 22000, 22001, },
	[512] = { 22002, 22003, 22004, 22005, 22006, 22007, 22008, 22009, },
	[513] = { 22106, 22107, 22108, 22109, 22110, 22111, 22112, 22113, },
	[514] = { 22078, 22079, 22080, 22081, 22082, 22083, 22084, 22085, },
	[515] = { 22010, 22011, 22061, 22013, 22015, 22016, 22017, 22060, },
	[516] = { 22086, 22087, 22088, 22089, 22090, 22091, 22092, 22093, },
	[517] = { 22062, 22063, 22064, 22065, 22066, 22067, 22068, 22069, },
	[518] = { 22070, 22071, 22072, 22073, 22074, 22075, 22076, 22077, },
	[519] = { 22095, 22096, 22097, 22098, 22099, 22100, 22101, 22102, },
	[520] = { 22306, 22311, 22313, 22302, 22304, 22305, 22303, 22301, },
	[521] = { 22492, 22494, 22493, 22490, 22489, 22491, 22488, 22495, 23064, },
	[522] = { 22864, 22856, 22879, 22880, 23257, 23258, },
	[523] = { 22423, 22416, 22421, 22422, 22418, 22417, 22419, 22420, 23059, },
	[524] = { 22483, 22476, 22481, 22478, 22477, 22479, 22480, 22482, 23060, },
	[525] = { 22518, 22519, 22514, 22517, 22513, 22512, 22516, 22515, 23061, },
	[526] = { 22502, 22503, 22498, 22501, 22497, 22496, 22500, 22499, 23062, },
	[527] = { 22468, 22470, 22469, 22466, 22465, 22467, 22464, 22471, 23065, },
	[528] = { 22430, 22431, 22426, 22428, 22427, 22429, 22425, 22424, 23066, },
	[529] = { 22510, 22511, 22506, 22509, 22505, 22504, 22508, 22507, 23063, },
	[530] = { 22440, 22442, 22441, 22438, 22437, 22439, 22436, 22443, 23067, },
	[533] = { 23090, 23087, 23078, },
	[534] = { 23081, 23089, 23093, },
	[535] = { 23088, 23082, 23092, },
	[536] = { 23091, 23084, 23085, },
	[537] = { 22868, 22858, 22872, 22873, 23244, 23243, },
	[538] = { 22857, 22867, 22876, 22887, 23259, 23260, },
	[539] = { 22863, 22852, 22877, 22878, 23253, 23254, },
	[540] = { 22869, 22859, 22882, 22885, 23261, 23262, },
	[541] = { 22865, 22855, 23255, 23256, 22881, 22884, },
	[542] = { 22870, 22860, 23263, 23264, 22883, 22886, },
	[543] = { 22843, 22862, 23251, 23252, 22874, 22875, },
	[544] = { 23272, 23273, 23274, 23275, 23276, 23277, },
	[545] = { 23300, 23301, 23286, 23287, 23314, 23315, },
	[546] = { 23304, 23305, 23290, 23291, 23318, 23319, },
	[547] = { 23296, 23297, 23282, 23283, 23310, 23311, },
	[548] = { 23298, 23299, 23284, 23285, 23312, 23313, },
	[549] = { 23302, 23303, 23288, 23289, 23316, 23317, },
	[550] = { 23292, 23293, 23278, 23279, 23306, 23307, },
	[551] = { 23294, 23295, 23280, 23281, 23308, 23309, },
	[552] = { 21848, 21847, 21846, },
	[553] = { 21871, 21869, 21870, },
	[554] = { 21875, 21874, 21873, },
	[555] = { 21855, 21854, 21852, 21851, 21849, 21853, 21850, },
	[556] = { 21862, 21861, 21859, 21860, },
	[557] = { 21865, 21864, 21863, },
	[558] = { 21868, 21866, 21867, },
	[559] = { 24266, 24262, },
	[560] = { 23489, 23488, 23487, 23482, 23484, },
	[561] = { 23490, 23491, 23493, 23494, },
	[562] = { 23507, 23508, 23506, },
	[563] = { 23509, 23512, 23511, 23510, },
	[564] = { 23513, 23516, 23514, 23515, },
	[565] = { 23523, 23525, 23524, },
	[566] = { 23522, 23521, 23520, 33173, },
	[567] = { 24544, 24549, 24545, 24547, 24546, },
	[568] = { 24556, 24553, 24555, 24554, 24552, },
	[569] = { 23519, 23518, 23517, },
	[570] = { 24255, 24249, },
	[571] = { 24264, 24261, },
	[572] = { 24267, 24263, },
	[573] = { 25685, 25686, 25687, },
	[574] = { 25691, 25690, 25689, },
	[575] = { 25695, 25697, 25696, },
	[576] = { 25694, 25693, 25692, },
	[577] = { 25834, 25833, 25830, 25832, 25831, },
	[578] = { 25997, 26000, 25998, 26001, 25999, },
	[579] = { 25854, 25855, 25857, 25856, 25858, },
	[580] = { 27469, 27470, 27471, 27472, 27473, },
	[581] = { 27707, 27708, 27709, 27710, 27711, },
	[582] = { 27702, 27703, 27704, 27705, 27706, },
	[583] = { 27879, 27880, 27881, 27882, 27883, },
	[584] = { 28126, 28127, 28128, 28129, 28130, },
	[585] = { 28136, 28137, 28138, 28139, 28140, },
	[586] = { 28334, 28335, 28331, 28332, 28333, },
	[587] = { 28831, 28832, 28833, 28834, 28835, },
	[588] = { 28851, 28852, 28853, 28854, 28855, },
	[589] = { 28679, 28680, 28681, 28724, 28683, },
	[590] = { 28699, 28700, 28701, 28702, 28703, },
	[591] = { 28624, 28625, 28626, 28627, 28628, },
	[592] = { 28817, 28818, 28819, 28820, 28821, },
	[593] = { 28689, 28690, 28691, 28692, 28693, },
	[594] = { 28841, 28842, 28843, 28844, 28845, },
	[595] = { 28613, 28614, 28615, 28616, 28617, },
	[596] = { 28805, 28806, 28807, 28808, 28809, },
	[597] = { 28704, 28705, 28706, 28707, 28708, },
	[598] = { 28856, 28857, 28858, 28859, 28860, },
	[599] = { 28714, 28715, 28716, 28717, 28718, },
	[600] = { 28866, 28867, 28868, 28869, 28870, },
	[601] = { 28618, 28619, 28620, 28622, 28623, },
	[602] = { 28811, 28812, 28813, 28814, 28815, },
	[603] = { 28694, 28695, 28696, 28697, 28698, },
	[604] = { 28846, 28847, 28848, 28849, 28850, },
	[605] = { 28684, 28685, 28686, 28687, 28688, },
	[606] = { 28836, 28837, 28838, 28839, 28840, },
	[607] = { 28709, 28710, 28711, 28712, 28713, },
	[608] = { 28861, 28862, 28863, 28864, 28865, },
	[609] = { 28719, 28720, 28721, 28722, 28723, },
	[610] = { 28871, 28872, 28873, 28874, 28875, },
	[611] = { 25657, 25656, 25655, 25654, },
	[612] = { 25661, 25659, 25662, 25660, },
	[613] = { 25668, 25669, 25670, 25671, },
	[614] = { 25673, 25674, 25675, 25676, },
	[615] = { 30186, 30187, 30188, 30200, 30201, },
	[616] = { 29516, 29517, 29515, },
	[617] = { 29521, 29520, 29519, },
	[618] = { 29523, 29524, 29522, },
	[619] = { 29527, 29526, 29525, },
	[620] = { 27509, 28414, 27908, 27776, 28204, },
	[621] = { 29046, 29045, 29044, 29048, 29047, },
	[622] = { 30144, 30145, 30146, 30148, 30149, },
	[623] = { 28203, 27535, 28285, 27839, 27739, },
	[624] = { 29062, 29061, 29065, 29063, 29064, },
	[625] = { 29066, 29068, 29067, 29069, 29070, },
	[626] = { 29071, 29073, 29072, 29074, 29075, },
	[627] = { 30134, 30135, 30136, 30137, 30138, },
	[628] = { 30123, 30125, 30124, 30126, 30127, },
	[629] = { 30129, 30130, 30132, 30133, 30131, },
	[630] = { 28231, 27510, 28349, 27909, 27802, },
	[631] = { 29032, 29029, 29028, 29030, 29031, },
	[632] = { 29033, 29035, 29034, 29036, 29037, },
	[633] = { 29038, 29039, 29040, 29043, 29042, },
	[634] = { 30164, 30165, 30166, 30167, 30168, },
	[635] = { 30169, 30170, 30171, 30172, 30173, },
	[636] = { 30185, 30189, 30190, 30192, 30194, },
	[637] = { 28348, 27468, 27873, 28202, 27737, },
	[638] = { 29087, 29086, 29090, 29088, 29089, },
	[639] = { 29093, 29094, 29091, 29092, 29095, },
	[640] = { 29096, 29097, 29099, 29100, 29098, },
	[641] = { 30222, 30223, 30228, 30229, 30230, },
	[642] = { 30216, 30217, 30219, 30220, 30221, },
	[643] = { 30231, 30232, 30233, 30234, 30235, },
	[644] = { 27537, 28415, 28232, 27778, 27948, },
	[645] = { 28963, 28968, 28966, 28967, 28964, },
	[646] = { 30211, 30212, 30213, 30215, 30214, },
	[647] = { 28278, 27508, 27738, 28229, 27838, },
	[648] = { 29076, 29080, 29078, 29079, 29077, },
	[649] = { 30206, 30205, 30207, 30210, 30196, },
	[650] = { 28228, 27474, 28275, 27874, 27801, },
	[651] = { 29085, 29081, 29083, 29082, 29084, },
	[652] = { 30139, 30140, 30141, 30142, 30143, },
	[653] = { 28205, 27475, 27977, 27803, 28350, },
	[654] = { 29012, 29011, 29017, 29015, 29016, },
	[655] = { 29021, 29019, 29020, 29022, 29023, },
	[656] = { 30113, 30115, 30114, 30116, 30117, },
	[657] = { 30120, 30118, 30119, 30121, 30122, },
	[658] = { 28193, 27465, 27907, 28191, 27796, },
	[659] = { 28264, 27531, 28224, 27837, 27797, },
	[660] = { 27936, 28401, 27528, 28192, 27713, },
	[661] = { 28403, 27497, 28225, 27870, 27771, },
	[662] = { 28413, 28230, 27536, 27775, 27875, },
	[663] = { 29055, 29049, 29054, 29050, 29053, },
	[664] = { 29057, 29059, 29056, 29058, 29060, },
	[665] = { 30153, 30152, 30151, 30154, 30150, },
	[666] = { 30160, 30161, 30162, 30159, 30163, },
	[667] = { 31339, 31338, },
	[668] = { 31028, 31026, 31027, 31029, 31030, 34575, 34448, 34558, },
	[669] = { 31004, 31001, 31003, 31005, 31006, 34549, 34443, 34570, },
	[670] = { 31050, 31051, 31053, 31054, 31052, 34564, 34436, 34541, },
	[671] = { 31056, 31055, 31058, 31059, 31057, 34574, 34447, 34557, },
	[672] = { 30972, 30975, 30969, 30977, 30979, 34546, 34441, 34569, },
	[673] = { 30976, 30974, 30970, 30978, 30980, 34568, 34442, 34547, },
	[674] = { 31061, 31064, 31067, 31070, 31065, 34434, 34528, 34563, },
	[675] = { 31068, 31063, 31060, 31069, 31066, 34562, 34527, 34435, },
	[676] = { 31042, 31034, 31039, 31044, 31048, 34556, 34444, 34573, },
	[677] = { 31043, 31035, 31040, 31046, 31049, 34572, 34446, 34555, },
	[678] = { 31041, 31032, 31037, 31045, 31047, 34571, 34445, 34554, },
	[679] = { 30991, 30987, 30985, 30995, 30998, 34488, 34433, 34560, },
	[680] = { 30990, 30982, 30993, 30997, 30989, 34561, 34431, 34485, },
	[681] = { 30992, 30983, 30988, 30994, 30996, 34432, 34487, 34559, },
	[682] = { 31018, 31011, 31015, 31021, 31024, 34567, 34439, 34545, },
	[683] = { 31016, 31007, 31012, 31019, 31022, 34543, 34438, 34565, },
	[684] = { 31017, 31008, 31014, 31020, 31023, 34542, 34437, 34566, },
	[685] = { 31375, 31376, 31377, 31378, 31379, },
	[686] = { 31396, 31397, 31400, 31406, 31407, },
	[687] = { 31409, 31410, 31411, 31412, 31413, },
	[688] = { 31589, 31590, 31591, 31592, 31593, },
	[689] = { 31584, 31585, 31586, 31587, 31588, },
	[690] = { 31613, 31614, 31616, 31618, 31619, },
	[691] = { 31622, 31623, 31620, 31624, 31625, },
	[692] = { 31626, 31627, 31621, 31628, 31629, },
	[693] = { 31630, 31631, 31632, 31633, 31634, },
	[694] = { 31635, 31636, 31637, 31638, 31639, },
	[695] = { 31640, 31641, 31642, 31643, 31644, },
	[696] = { 31646, 31647, 31648, 31649, 31650, },
	[697] = { 29600, 29601, 29602, 29603, 29604, 29605, },
	[698] = { 29612, 29613, 29614, 29615, 29616, 29617, },
	[699] = { 32838, 32837, },
	[717] = { 29608, 29606, 29611, 29609, 29607, 29610, },
	[718] = { 29599, 29595, 29597, 29596, 29598, 29594, },
	[719] = { 32946, 32945, },
	[737] = { 34703, 28189, },
	[738] = { 35328, 35329, 35330, 35331, 35332, },
	[739] = { 35333, 35334, 35335, 35336, 35337, },
	[740] = { 35338, 35339, 35340, 35341, 35342, },
	[741] = { 35343, 35344, 35345, 35346, 35347, },
	[742] = { 35356, 35357, 35358, 35360, 35359, },
	[743] = { 35371, 35372, 35373, 35375, 35374, },
	[744] = { 35361, 35362, 35363, 35365, 35364, },
	[745] = { 35366, 35367, 35368, 35369, 35370, },
	[746] = { 35386, 35387, 35388, 35389, 35390, },
	[747] = { 35391, 35392, 35393, 35394, 35395, },
	[748] = { 35381, 35382, 35383, 35384, 35385, },
	[749] = { 35376, 35377, 35378, 35379, 35380, },
	[750] = { 35407, 35408, 35409, 35410, 35411, },
	[751] = { 35402, 35403, 35404, 35405, 35406, },
	[752] = { 35412, 35413, 35414, 35415, 35416, },
};
DT.ItemSetThreshold = {
	[1] = { 2, 3, 4, 5, },
	[41] = { 2, },
	[65] = { 2, },
	[81] = { 2, 3, 3, 4, 5, 5, },
	[121] = { 2, 3, 4, 5, },
	[122] = { 2, 3, 4, 5, },
	[123] = { 2, 3, 4, 5, },
	[124] = { 2, 3, 4, 5, },
	[141] = { 3, },
	[142] = { 2, 3, 4, },
	[143] = { 2, },
	[144] = { 2, },
	[161] = { 2, 3, 4, 5, },
	[162] = { 2, 3, 4, 5, },
	[163] = { 2, 3, 4, 5, 6, },
	[181] = { 2, 4, 6, 8, },
	[182] = { 2, 4, 6, 8, },
	[183] = { 2, 4, 6, 8, },
	[184] = { 2, 4, 6, 8, },
	[185] = { 2, 4, 4, 6, 8, },
	[186] = { 2, 4, 6, 8, },
	[187] = { 2, 4, 6, 8, },
	[188] = { 2, 4, 6, 8, },
	[189] = { 2, 4, 6, 8, },
	[201] = { 3, 5, 8, },
	[202] = { 3, 5, 8, },
	[203] = { 3, 5, 8, },
	[204] = { 3, 5, 8, },
	[205] = { 3, 5, 8, },
	[206] = { 3, 5, 8, },
	[207] = { 3, 5, 8, },
	[208] = { 3, 5, 5, 8, },
	[209] = { 3, 5, 8, },
	[210] = { 3, 5, 8, },
	[211] = { 3, 5, 8, },
	[212] = { 3, 5, 8, },
	[213] = { 3, 5, 8, },
	[214] = { 3, 5, 8, },
	[215] = { 3, 5, 8, },
	[216] = { 3, 5, 8, },
	[217] = { 3, 5, 8, },
	[218] = { 3, 5, 8, },
	[221] = { 6, },
	[241] = { 2, },
	[261] = { 4, },
	[281] = { 2, 4, 6, },
	[282] = { 2, 4, 6, },
	[301] = { 2, 4, 6, },
	[321] = { 2, 4, 6, },
	[341] = { 2, 4, 6, },
	[342] = { 2, 4, 6, },
	[343] = { 2, 4, 6, },
	[344] = { 2, 4, 6, },
	[345] = { 2, 4, 6, },
	[346] = { 2, 4, 6, },
	[347] = { 2, 4, 6, },
	[348] = { 2, 4, 6, },
	[361] = { 2, 4, 6, },
	[362] = { 2, 4, 6, },
	[381] = { 2, 4, 6, },
	[382] = { 2, 4, 6, },
	[383] = { 2, 3, 6, },
	[384] = { 2, 3, 6, },
	[386] = { 2, 3, 6, },
	[387] = { 2, 3, 6, },
	[388] = { 2, 3, 6, },
	[389] = { 2, 3, 6, },
	[390] = { 2, 3, 6, },
	[391] = { 2, 3, 6, },
	[392] = { 2, 3, 6, },
	[393] = { 2, 3, 6, },
	[394] = { 2, 3, 6, },
	[395] = { 2, 3, 6, },
	[396] = { 2, 3, 6, },
	[397] = { 2, 3, 6, },
	[398] = { 2, 3, 6, },
	[401] = { 2, 2, 4, 6, },
	[402] = { 2, 3, 6, },
	[421] = { 3, },
	[441] = { 3, },
	[442] = { 2, 2, },
	[443] = { 3, },
	[444] = { 3, },
	[461] = { 2, },
	[462] = { 2, 2, },
	[463] = { 2, },
	[464] = { 2, },
	[465] = { 2, },
	[466] = { 2, },
	[467] = { 2, 3, },
	[468] = { 2, 3, },
	[469] = { 2, 3, },
	[470] = { 2, 3, },
	[471] = { 2, 3, },
	[472] = { 2, 3, },
	[473] = { 2, 3, },
	[474] = { 2, 3, 5, },
	[475] = { 2, 3, 5, },
	[476] = { 2, 3, 5, },
	[477] = { 2, 3, 5, },
	[478] = { 2, 3, 5, },
	[479] = { 2, 3, 5, },
	[480] = { 2, 3, 5, },
	[481] = { 2, 3, 5, },
	[482] = { 2, 3, 5, },
	[483] = { 2, 3, },
	[484] = { 2, 3, },
	[485] = { 2, 3, },
	[486] = { 2, 3, },
	[487] = { 2, 3, },
	[488] = { 2, 3, },
	[489] = { 2, 3, 4, },
	[490] = { 2, 3, },
	[491] = { 2, 3, },
	[492] = { 3, },
	[493] = { 3, 3, 5, },
	[494] = { 3, },
	[495] = { 3, },
	[496] = { 3, 5, },
	[497] = { 3, 5, },
	[498] = { 3, },
	[499] = { 3, 5, },
	[500] = { 3, },
	[501] = { 3, 5, },
	[502] = { 3, },
	[503] = { 3, 5, },
	[504] = { 3, },
	[505] = { 3, 5, },
	[506] = { 3, },
	[507] = { 3, 5, },
	[508] = { 3, },
	[509] = { 3, 5, },
	[510] = { 3, },
	[511] = { 2, 4, 6, 8, },
	[512] = { 2, 4, 6, 8, },
	[513] = { 2, 4, 6, 6, 8, },
	[514] = { 2, 4, 6, 8, },
	[515] = { 2, 4, 6, 8, },
	[516] = { 2, 4, 6, 8, },
	[517] = { 2, 4, 6, 8, },
	[518] = { 2, 4, 6, 8, },
	[519] = { 2, 4, 6, 8, },
	[520] = { 4, 8, },
	[521] = { 2, 4, 6, 8, },
	[522] = { 2, 4, 6, },
	[523] = { 2, 4, 6, 8, },
	[524] = { 2, 4, 6, 8, },
	[525] = { 2, 4, 6, 8, },
	[526] = { 2, 4, 6, 8, },
	[527] = { 2, 4, 6, 8, },
	[528] = { 2, 4, 6, 8, },
	[529] = { 2, 4, 6, 8, },
	[530] = { 2, 4, 6, 8, },
	[533] = { 3, },
	[534] = { 3, },
	[535] = { 3, },
	[536] = { 3, },
	[537] = { 2, 4, 6, },
	[538] = { 2, 4, 6, },
	[539] = { 2, 4, 6, },
	[540] = { 2, 4, 6, },
	[541] = { 2, 4, 6, },
	[542] = { 2, 4, 6, },
	[543] = { 2, 4, 6, },
	[544] = { 2, 4, 6, },
	[545] = { 2, 4, 6, },
	[546] = { 2, 4, 6, },
	[547] = { 2, 4, 6, },
	[548] = { 2, 4, 6, },
	[549] = { 2, 4, 6, },
	[550] = { 2, 4, 6, },
	[551] = { 2, 4, 6, },
	[552] = { 3, },
	[553] = { 3, },
	[554] = { 3, },
	[555] = { 2, 4, },
	[556] = { 3, },
	[557] = { 3, },
	[558] = { 3, },
	[559] = { 2, },
	[560] = { 2, 4, },
	[561] = { 2, 4, },
	[562] = { 3, },
	[563] = { 3, },
	[564] = { 3, },
	[565] = { 3, },
	[566] = { 2, },
	[567] = { 2, 4, },
	[568] = { 2, 4, },
	[569] = { 3, },
	[570] = { 2, },
	[571] = { 2, },
	[572] = { 2, },
	[573] = { 3, },
	[574] = { 3, },
	[575] = { 3, },
	[576] = { 3, },
	[577] = { 2, 4, },
	[578] = { 2, 4, },
	[579] = { 2, 4, },
	[580] = { 2, 4, },
	[581] = { 2, 4, },
	[582] = { 2, 4, },
	[583] = { 2, 4, },
	[584] = { 2, 4, },
	[585] = { 2, 4, },
	[586] = { 2, 4, },
	[587] = { 2, 4, },
	[588] = { 2, 4, },
	[589] = { 2, 4, },
	[590] = { 2, 4, },
	[591] = { 2, 4, },
	[592] = { 2, 4, },
	[593] = { 2, 4, },
	[594] = { 2, 4, },
	[595] = { 2, 4, },
	[596] = { 2, 4, },
	[597] = { 2, 4, },
	[598] = { 2, 4, },
	[599] = { 2, 4, },
	[600] = { 2, 4, },
	[601] = { 2, 4, },
	[602] = { 2, 4, },
	[603] = { 2, 4, },
	[604] = { 2, 4, },
	[605] = { 2, 4, },
	[606] = { 2, 4, },
	[607] = { 2, 4, },
	[608] = { 2, 4, },
	[609] = { 2, 4, },
	[610] = { 2, 4, },
	[611] = { 2, 4, },
	[612] = { 2, 4, },
	[613] = { 2, 4, },
	[614] = { 2, 4, },
	[615] = { 2, 4, },
	[616] = { 3, },
	[617] = { 3, },
	[618] = { 3, },
	[619] = { 3, },
	[620] = { 2, 4, },
	[621] = { 2, 4, },
	[622] = { 2, 4, },
	[623] = { 2, 4, },
	[624] = { 2, 4, },
	[625] = { 2, 4, },
	[626] = { 2, 4, },
	[627] = { 2, 4, },
	[628] = { 2, 4, },
	[629] = { 2, 4, },
	[630] = { 2, 4, },
	[631] = { 2, 4, },
	[632] = { 2, 4, },
	[633] = { 2, 4, },
	[634] = { 2, 4, },
	[635] = { 2, 4, },
	[636] = { 2, 4, },
	[637] = { 2, 4, },
	[638] = { 2, 4, },
	[639] = { 2, 4, },
	[640] = { 2, 2, 4, 4, },
	[641] = { 2, 4, },
	[642] = { 2, 4, },
	[643] = { 2, 4, },
	[644] = { 2, 4, },
	[645] = { 2, 2, 4, },
	[646] = { 2, 4, },
	[647] = { 2, 4, },
	[648] = { 2, 4, },
	[649] = { 2, 4, },
	[650] = { 2, 4, },
	[651] = { 2, 4, },
	[652] = { 2, 4, },
	[653] = { 2, 4, },
	[654] = { 2, 4, },
	[655] = { 2, 4, },
	[656] = { 2, 4, },
	[657] = { 2, 4, },
	[658] = { 2, 4, },
	[659] = { 2, 4, },
	[660] = { 2, 4, },
	[661] = { 2, 4, },
	[662] = { 2, 4, },
	[663] = { 2, 4, },
	[664] = { 2, 4, },
	[665] = { 2, 4, },
	[666] = { 2, 4, },
	[667] = { 2, },
	[668] = { 2, 4, },
	[669] = { 2, 4, },
	[670] = { 2, 4, },
	[671] = { 2, 4, },
	[672] = { 2, 4, },
	[673] = { 2, 4, },
	[674] = { 2, 4, },
	[675] = { 2, 4, },
	[676] = { 2, 4, },
	[677] = { 2, 4, },
	[678] = { 2, 4, },
	[679] = { 2, 4, },
	[680] = { 2, 4, },
	[681] = { 2, 4, },
	[682] = { 2, 4, },
	[683] = { 2, 4, },
	[684] = { 2, 4, },
	[685] = { 2, 4, },
	[686] = { 2, 4, },
	[687] = { 2, 4, },
	[688] = { 2, 4, },
	[689] = { 2, 4, },
	[690] = { 2, 4, },
	[691] = { 2, 4, },
	[692] = { 2, 4, },
	[693] = { 2, 4, },
	[694] = { 2, 4, },
	[695] = { 2, 4, },
	[696] = { 2, 4, },
	[697] = { 2, 3, 6, },
	[698] = { 2, 3, 6, },
	[699] = { 2, 2, },
	[700] = { 2, 4, },
	[701] = { 2, 4, },
	[702] = { 2, 4, },
	[703] = { 2, 4, },
	[704] = { 2, 4, },
	[705] = { 2, 4, },
	[706] = { 2, 4, },
	[707] = { 2, 4, },
	[708] = { 2, 4, },
	[709] = { 2, 4, },
	[710] = { 2, 4, },
	[711] = { 2, 4, },
	[712] = { 2, 4, },
	[713] = { 2, 4, },
	[714] = { 2, 4, },
	[715] = { 2, 4, },
	[716] = { 2, 4, },
	[717] = { 2, 3, 6, },
	[718] = { 2, 4, 6, },
	[719] = { 2, },
	[720] = { 2, 4, },
	[721] = { 2, 4, },
	[722] = { 2, 4, },
	[723] = { 2, 4, },
	[724] = { 2, 4, },
	[725] = { 2, 4, },
	[726] = { 2, 4, },
	[727] = { 2, 4, },
	[728] = { 2, 4, },
	[729] = { 2, 4, },
	[730] = { 2, 4, },
	[731] = { 2, 4, },
	[732] = { 2, 4, },
	[733] = { 2, 4, },
	[734] = { 2, 4, },
	[735] = { 2, 4, },
	[736] = { 2, 4, },
	[737] = { 2, },
	[738] = { 2, 4, },
	[739] = { 2, 4, },
	[740] = { 2, 4, },
	[741] = { 2, 4, },
	[742] = { 2, 4, },
	[743] = { 2, 4, },
	[744] = { 2, 4, },
	[745] = { 2, 4, },
	[746] = { 2, 4, },
	[747] = { 2, 4, },
	[748] = { 2, 4, },
	[749] = { 2, 4, },
	[750] = { 2, 4, },
	[751] = { 2, 4, },
	[752] = { 2, 4, },
};
local GetItemInfoInstant = GetItemInfoInstant;
for setID, set in next, DT.ItemSet do
	local h = {  };
	for i, id in next, set do
		local _, _, _, loc, icon = GetItemInfoInstant(id);
		if h[loc] then
			h = false;
			break;
		end
		h[loc] = i;
	end
	if h then
		for loc, i in next, h do
			set[loc] = i;
		end
	end
end
