--[[--
	by ALA @
--]]--
----------------------------------------------------------------------------------------------------
local __addon, __private = ...;
local MT = __private.MT;
local CT = __private.CT;
local VT = __private.VT;
local DT = __private.DT;

if CT.TOCVERSION >= 20000 or CT.TOCVERSION < 11400 then
	return;
end
-- if WOW_PROJECT_ID ~= WOW_PROJECT_CLASSIC then
-- 	return;
-- end

----------------------------------------------------------------------------------------------------

DT.MAX_LEVEL = 60;
DT.MAX_NUM_TIER = 7;
DT.MAX_NUM_COL = 4;
DT.MAX_NUM_TALENTS = 28;
DT.CUR_PHASE = 6;
--
DT.ClassSpec = {
	DRUID = {
		283,	--Balance,平衡
		281,	--Feral,野性战斗
		282,	--Restoration,恢复
	},
	HUNTER = {
		361,	--BeastMastery,野兽控制
		363,	--Marksmanship,射击
		362,	--Survival,生存
	},
	MAGE = {
		81,		--Arcane,奥术
		41,		--Fire,火焰
		61,		--Frost,冰霜
	},
	PALADIN = {
		382,	--Holy,神圣
		383,	--Protection,防护
		381,	--Discipline,惩戒
	},
	PRIEST = {
		201,	--Discipline,戒律
		202,	--Holy,神圣
		203,	--Shadow,暗影
	},
	ROGUE = {
		182,	--Assassination,刺杀
		181,	--Combat,战斗
		183,	--Subtlety,敏锐
	},
	SHAMAN = {
		261,	--Elemental,元素
		263,	--Enhancement,增强
		262,	--Restoration,恢复
	},
	WARLOCK = {
		302,	--Affliction,痛苦
		303,	--Demonology,恶魔学识
		301,	--Destruction,毁灭
	},
	WARRIOR = {
		161,	--Arms,武器
		164,	--Fury,狂怒
		163,	--Protection,防护
	},

};
--
	--	DT.TalentDB
	--1-----2----3---4---------5--------6-------7------8---------9--------10-----------11--------------------12
	--tier, col, id, maxPoint, reqTier, reqCol, reqId, Spell[5], texture, [icon index, req index in TreeTDB, req by index in TreeTDB](calculated after addon loaded)
--
DT.TalentDB = {
	DRUID = {
		[281] =
		{
			{ 0, 1,  796, 5, nil, nil,  nil, { 16934, 16935, 16936, 16937, 16938, }, "Interface\\icons\\ability_hunter_pet_hyena", },
			{ 0, 2,  795, 5, nil, nil,  nil, { 16858, 16859, 16860, 16861, 16862, }, "Interface\\icons\\ability_druid_demoralizingroar", },
			{ 1, 0,  799, 5, nil, nil,  nil, { 16947, 16948, 16949, 16950, 16951, }, "Interface\\icons\\ability_ambush", },
			{ 1, 1,  797, 2, nil, nil,  nil, { 16940, 16941,   nil,   nil,   nil, }, "Interface\\icons\\ability_druid_bash", },
			{ 1, 2,  794, 5, nil, nil,  nil, { 16929, 16930, 16931, 16932, 16933, }, "Interface\\icons\\inv_misc_pelt_bear_03", },
			{ 2, 0,  807, 2, nil, nil,  nil, { 17002, 24866,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_spiritwolf", },
			{ 2, 1,  804, 1, nil, nil,  nil, { 16979,   nil,   nil,   nil,   nil, }, "Interface\\icons\\ability_hunter_pet_bear", },
			{ 2, 2,  798, 3, nil, nil,  nil, { 16942, 16943, 16944,   nil,   nil, }, "Interface\\icons\\inv_misc_monsterclaw_04", },
			{ 3, 0,  802, 2, nil, nil,  nil, { 16966, 16968,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_vampiricaura", },
			{ 3, 1,  803, 3, nil, nil,  nil, { 16972, 16974, 16975,   nil,   nil, }, "Interface\\icons\\ability_hunter_pet_cat", },
			{ 3, 2,  800, 2,   2,   2,  798, { 16952, 16954,   nil,   nil,   nil, }, "Interface\\icons\\ability_ghoulfrenzy", },
			{ 3, 3,  801, 2,   2,   2,  798, { 16958, 16961,   nil,   nil,   nil, }, "Interface\\icons\\ability_racial_cannibalize", },
			{ 4, 0,  805, 2, nil, nil,  nil, { 16998, 16999,   nil,   nil,   nil, }, "Interface\\icons\\ability_druid_ravage", },
			{ 4, 2, 1162, 1, nil, nil,  nil, { 16857,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_faeriefire", },
			{ 5, 1,  808, 5,   3,   1,  803, { 17003, 17004, 17005, 17006, 24894, }, "Interface\\icons\\spell_holy_blessingofagility", },
			{ 6, 1,  809, 1, nil, nil,  nil, { 17007,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_unyeildingstamina", },
		},
		[282] =
		{
			{ 0, 1,  821, 5, nil, nil,  nil, { 17050, 17051, 17053, 17054, 17055, }, "Interface\\icons\\spell_nature_regeneration", },
			{ 0, 2,  822, 5, nil, nil,  nil, { 17056, 17058, 17059, 17060, 17061, }, "Interface\\icons\\spell_holy_blessingofstamina", },
			{ 1, 0,  824, 5, nil, nil,  nil, { 17069, 17070, 17071, 17072, 17073, }, "Interface\\icons\\spell_nature_healingtouch", },
			{ 1, 1,  823, 5, nil, nil,  nil, { 17063, 17065, 17066, 17067, 17068, }, "Interface\\icons\\spell_nature_healingwavegreater", },
			{ 1, 2,  826, 2, nil, nil,  nil, { 17079, 17082,   nil,   nil,   nil, }, "Interface\\icons\\ability_druid_enrage", },
			{ 2, 1,  829, 3, nil, nil,  nil, { 17106, 17107, 17108,   nil,   nil, }, "Interface\\icons\\spell_frost_windwalkon", },
			{ 2, 2,  827, 1, nil, nil,  nil, {  5570,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_insectswarm", },
			{ 2, 3,  841, 5, nil, nil,  nil, { 17118, 17119, 17120, 17121, 17122, }, "Interface\\icons\\ability_eyeoftheowl", },
			{ 3, 1,  843, 5, nil, nil,  nil, { 24968, 24969, 24970, 24971, 24972, }, "Interface\\icons\\spell_holy_elunesgrace", },
			{ 3, 3,  830, 3, nil, nil,  nil, { 17111, 17112, 17113,   nil,   nil, }, "Interface\\icons\\spell_nature_rejuvenation", },
			{ 4, 0,  831, 1,   1,   0,  824, { 17116,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_ravenform", },
			{ 4, 2,  828, 5,   2,   2,  827, { 17104, 24943, 24944, 24945, 24946, }, "Interface\\icons\\spell_nature_protectionformnature", },
			{ 4, 3,  842, 2, nil, nil,  nil, { 17123, 17124,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_tranquility", },
			{ 5, 2,  825, 5, nil, nil,  nil, { 17074, 17075, 17076, 17077, 17078, }, "Interface\\icons\\spell_nature_resistnature", },
			{ 6, 1,  844, 1,   3,   1,  843, { 18562,   nil,   nil,   nil,   nil, }, "Interface\\icons\\inv_relics_idolofrejuvenation", },
		},
		[283] =
		{
			{ 0, 0,  762, 5, nil, nil,  nil, { 16814, 16815, 16816, 16817, 16818, }, "Interface\\icons\\spell_nature_abolishmagic", },
			{ 0, 1,  761, 1, nil, nil,  nil, { 16689,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_natureswrath", },
			{ 0, 2,  921, 4,   0,   1,  761, { 17245, 17247, 17248, 17249,   nil, }, "Interface\\icons\\spell_nature_natureswrath", },
			{ 1, 0,  787, 3, nil, nil,  nil, { 16918, 16919, 16920,   nil,   nil, }, "Interface\\icons\\spell_nature_stranglevines", },
			{ 1, 1,  763, 5, nil, nil,  nil, { 16821, 16822, 16823, 16824, 16825, }, "Interface\\icons\\spell_nature_starfall", },
			{ 1, 2,  791, 5, nil, nil,  nil, { 16902, 16903, 16904, 16905, 16906, }, "Interface\\icons\\inv_staff_01", },
			{ 1, 3,  781, 3, nil, nil,  nil, { 16833, 16834, 16835,   nil,   nil, }, "Interface\\icons\\spell_nature_wispsplode", },
			{ 2, 0,  782, 3, nil, nil,  nil, { 16836, 16839, 16840,   nil,   nil, }, "Interface\\icons\\spell_nature_thorns", },
			{ 2, 2,  788, 1,   1,   2,  791, { 16864,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_crystalball", },
			{ 2, 3,  764, 2, nil, nil,  nil, { 16819, 16820,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_naturetouchgrow", },
			{ 3, 1,  792, 5,   1,   1,  763, { 16909, 16910, 16911, 16912, 16913, }, "Interface\\icons\\spell_nature_purge", },
			{ 3, 2,  784, 5, nil, nil,  nil, { 16850, 16923, 16924, 16925, 16926, }, "Interface\\icons\\spell_arcane_starfire", },
			{ 4, 1,  789, 1, nil, nil,  nil, { 16880,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_naturesblessing", },
			{ 4, 2,  783, 3, nil, nil,  nil, { 16845, 16846, 16847,   nil,   nil, }, "Interface\\icons\\spell_nature_sentinal", },
			{ 5, 1,  790, 5,   4,   1,  789, { 16896, 16897, 16899, 16900, 16901, }, "Interface\\icons\\spell_nature_moonglow", },
			{ 6, 1,  793, 1, nil, nil,  nil, { 24858,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_forceofnature", },
		},
	},
	HUNTER = {
		[361] =
		{
			{ 0, 1, 1382, 5, nil, nil,  nil, { 19552, 19553, 19554, 19555, 19556, }, "Interface\\icons\\spell_nature_ravenform", },
			{ 0, 2, 1389, 5, nil, nil,  nil, { 19583, 19584, 19585, 19586, 19587, }, "Interface\\icons\\spell_nature_reincarnation", },
			{ 1, 0, 1624, 2, nil, nil,  nil, { 19557, 19558,   nil,   nil,   nil, }, "Interface\\icons\\ability_eyeoftheowl", },
			{ 1, 1, 1381, 5, nil, nil,  nil, { 19549, 19550, 19551, 24386, 24387, }, "Interface\\icons\\ability_hunter_aspectofthemonkey", },
			{ 1, 2, 1395, 3, nil, nil,  nil, { 19609, 19610, 19612,   nil,   nil, }, "Interface\\icons\\inv_misc_pelt_bear_03", },
			{ 1, 3, 1625, 2, nil, nil,  nil, { 24443, 19575,   nil,   nil,   nil, }, "Interface\\icons\\ability_hunter_beastsoothe", },
			{ 2, 0, 1384, 2, nil, nil,  nil, { 19559, 19560,   nil,   nil,   nil, }, "Interface\\icons\\ability_mount_jungletiger", },
			{ 2, 1, 1391, 1, nil, nil,  nil, { 19596,   nil,   nil,   nil,   nil, }, "Interface\\icons\\ability_druid_dash", },
			{ 2, 2, 1396, 5, nil, nil,  nil, { 19616, 19617, 19618, 19619, 19620, }, "Interface\\icons\\ability_bullrush", },
			{ 3, 1, 1385, 2, nil, nil,  nil, { 19572, 19573,   nil,   nil,   nil, }, "Interface\\icons\\ability_hunter_mendpet", },
			{ 3, 2, 1393, 5, nil, nil,  nil, { 19598, 19599, 19600, 19601, 19602, }, "Interface\\icons\\inv_misc_monsterclaw_04", },
			{ 4, 0, 1388, 2, nil, nil,  nil, { 19578, 20895,   nil,   nil,   nil, }, "Interface\\icons\\ability_druid_demoralizingroar", },
			{ 4, 1, 1387, 1, nil, nil,  nil, { 19577,   nil,   nil,   nil,   nil, }, "Interface\\icons\\ability_devour", },
			{ 4, 3, 1390, 2, nil, nil,  nil, { 19590, 19592,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_abolishmagic", },
			{ 5, 2, 1397, 5,   3,   2, 1393, { 19621, 19622, 19623, 19624, 19625, }, "Interface\\icons\\inv_misc_monsterclaw_03", },
			{ 6, 1, 1386, 1,   4,   1, 1387, { 19574,   nil,   nil,   nil,   nil, }, "Interface\\icons\\ability_druid_ferociousbite", },
		},
		[362] =
		{
			{ 0, 0, 1623, 3, nil, nil,  nil, { 24293, 24294, 24295,   nil,   nil, }, "Interface\\icons\\inv_misc_head_dragon_black", },
			{ 0, 1, 1301, 3, nil, nil,  nil, { 19151, 19152, 19153,   nil,   nil, }, "Interface\\icons\\spell_holy_prayerofhealing", },
			{ 0, 2, 1311, 5, nil, nil,  nil, { 19295, 19297, 19298, 19301, 19300, }, "Interface\\icons\\ability_parry", },
			{ 1, 0, 1304, 5, nil, nil,  nil, { 19184, 19387, 19388, 19389, 19390, }, "Interface\\icons\\spell_nature_stranglevines", },
			{ 1, 1, 1621, 2, nil, nil,  nil, { 19159, 19160,   nil,   nil,   nil, }, "Interface\\icons\\ability_racial_bloodrage", },
			{ 1, 2, 1305, 5, nil, nil,  nil, { 19228, 19232, 19233, 19234, 19235, }, "Interface\\icons\\ability_rogue_trip", },
			{ 2, 0, 1306, 2, nil, nil,  nil, { 19239, 19245,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_timestop", },
			{ 2, 1, 1622, 5, nil, nil,  nil, { 19255, 19256, 19257, 19258, 19259, }, "Interface\\icons\\spell_shadow_twilight", },
			{ 2, 2, 1308, 1, nil, nil,  nil, { 19263,   nil,   nil,   nil,   nil, }, "Interface\\icons\\ability_whirlwind", },
			{ 3, 0, 1322, 2, nil, nil,  nil, { 19376, 19377,   nil,   nil,   nil, }, "Interface\\icons\\ability_ensnare", },
			{ 3, 1, 1310, 3, nil, nil,  nil, { 19290, 19294, 24283,   nil,   nil, }, "Interface\\icons\\ability_kick", },
			{ 3, 3, 1309, 2, nil, nil,  nil, { 19286, 19287,   nil,   nil,   nil, }, "Interface\\icons\\ability_rogue_feigndeath", },
			{ 4, 1, 1321, 3, nil, nil,  nil, { 19370, 19371, 19373,   nil,   nil, }, "Interface\\icons\\spell_holy_blessingofstamina", },
			{ 4, 2, 1312, 1,   2,   2, 1308, { 19306,   nil,   nil,   nil,   nil, }, "Interface\\icons\\ability_warrior_challange", },
			{ 5, 2, 1303, 5, nil, nil,  nil, { 19168, 19180, 19181, 24296, 24297, }, "Interface\\icons\\spell_nature_invisibilty", },
			{ 6, 1, 1325, 1,   4,   1, 1321, { 19386,   nil,   nil,   nil,   nil, }, "Interface\\icons\\inv_spear_02", },
		},
		[363] =
		{
			{ 0, 1, 1341, 5, nil, nil,  nil, { 19407, 19412, 19413, 19414, 19415, }, "Interface\\icons\\spell_frost_stun", },
			{ 0, 2, 1342, 5, nil, nil,  nil, { 19416, 19417, 19418, 19419, 19420, }, "Interface\\icons\\spell_frost_wizardmark", },
			{ 1, 1, 1343, 5, nil, nil,  nil, { 19421, 19422, 19423, 19424, 19425, }, "Interface\\icons\\ability_hunter_snipershot", },
			{ 1, 2, 1344, 5, nil, nil,  nil, { 19426, 19427, 19429, 19430, 19431, }, "Interface\\icons\\ability_searingarrow", },
			{ 2, 0, 1345, 1, nil, nil,  nil, { 19434,   nil,   nil,   nil,   nil, }, "Interface\\icons\\inv_spear_07", },
			{ 2, 1, 1346, 5, nil, nil,  nil, { 19454, 19455, 19456, 19457, 19458, }, "Interface\\icons\\ability_impalingbolt", },
			{ 2, 3, 1352, 3, nil, nil,  nil, { 19498, 19499, 19500,   nil,   nil, }, "Interface\\icons\\ability_townwatch", },
			{ 3, 1, 1348, 5, nil, nil,  nil, { 19464, 19465, 19466, 19467, 19468, }, "Interface\\icons\\ability_hunter_quickshot", },
			{ 3, 2, 1349, 5,   1,   2, 1344, { 19485, 19487, 19488, 19489, 19490, }, "Interface\\icons\\ability_piercedamage", },
			{ 4, 0, 1353, 1, nil, nil,  nil, { 19503,   nil,   nil,   nil,   nil, }, "Interface\\icons\\ability_golemstormbolt", },
			{ 4, 1, 1347, 3, nil, nil,  nil, { 19461, 19462, 24691,   nil,   nil, }, "Interface\\icons\\ability_upgrademoonglaive", },
			{ 4, 2, 1351, 3, nil, nil,  nil, { 19491, 19493, 19494,   nil,   nil, }, "Interface\\icons\\ability_hunter_criticalshot", },
			{ 5, 2, 1362, 5, nil, nil,  nil, { 19507, 19508, 19509, 19510, 19511, }, "Interface\\icons\\inv_weapon_rifle_06", },
			{ 6, 1, 1361, 1,   4,   1, 1347, { 19506,   nil,   nil,   nil,   nil, }, "Interface\\icons\\ability_trueshot", },
		},
	},
	MAGE = {
		[41] =
		{
			{ 0, 1,   26, 5, nil, nil,  nil, { 11069, 12338, 12339, 12340, 12341, }, "Interface\\icons\\spell_fire_flamebolt", },
			{ 0, 2,   30, 5, nil, nil,  nil, { 11103, 12357, 12358, 12359, 12360, }, "Interface\\icons\\spell_fire_meteorstorm", },
			{ 1, 0,   34, 5, nil, nil,  nil, { 11119, 11120, 12846, 12847, 12848, }, "Interface\\icons\\spell_fire_incinerate", },
			{ 1, 1,   28, 2, nil, nil,  nil, { 11100, 12353,   nil,   nil,   nil, }, "Interface\\icons\\spell_fire_flare", },
			{ 1, 2,   27, 3, nil, nil,  nil, { 11078, 11080, 12342,   nil,   nil, }, "Interface\\icons\\spell_fire_fireball", },
			{ 2, 0, 1141, 2, nil, nil,  nil, { 18459, 18460,   nil,   nil,   nil, }, "Interface\\icons\\spell_fire_flameshock", },
			{ 2, 1,   31, 3, nil, nil,  nil, { 11108, 12349, 12350,   nil,   nil, }, "Interface\\icons\\spell_fire_selfdestruct", },
			{ 2, 2,   29, 1, nil, nil,  nil, { 11366,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_fire_fireball02", },
			{ 2, 3,   23, 2, nil, nil,  nil, { 11083, 12351,   nil,   nil,   nil, }, "Interface\\icons\\spell_fire_fire", },
			{ 3, 0,   25, 3, nil, nil,  nil, { 11095, 12872, 12873,   nil,   nil, }, "Interface\\icons\\spell_fire_soulburn", },
			{ 3, 1,   24, 2, nil, nil,  nil, { 11094, 13043,   nil,   nil,   nil, }, "Interface\\icons\\spell_fire_firearmor", },
			{ 3, 3, 1639, 3, nil, nil,  nil, { 29074, 29075, 29076,   nil,   nil, }, "Interface\\icons\\spell_fire_masterofelements", },
			{ 4, 1,   33, 3, nil, nil,  nil, { 11115, 11367, 11368,   nil,   nil, }, "Interface\\icons\\spell_nature_wispheal", },
			{ 4, 2,   32, 1,   2,   2,   29, { 11113,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_excorcism_02", },
			{ 5, 2,   35, 5, nil, nil,  nil, { 11124, 12378, 12398, 12399, 12400, }, "Interface\\icons\\spell_fire_immolation", },
			{ 6, 1,   36, 1,   4,   1,   33, { 11129,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_fire_sealoffire", },
		},
		[61] =
		{
			{ 0, 0,   70, 2, nil, nil,  nil, { 11189, 28332,   nil,   nil,   nil, }, "Interface\\icons\\spell_frost_frostward", },
			{ 0, 1,   37, 5, nil, nil,  nil, { 11070, 12473, 16763, 16765, 16766, }, "Interface\\icons\\spell_frost_frostbolt02", },
			{ 0, 2, 1649, 3, nil, nil,  nil, { 29438, 29439, 29440,   nil,   nil, }, "Interface\\icons\\spell_ice_magicdamage", },
			{ 1, 0,   73, 5, nil, nil,  nil, { 11207, 12672, 15047, 15052, 15053, }, "Interface\\icons\\spell_frost_iceshard", },
			{ 1, 1,   38, 3, nil, nil,  nil, { 11071, 12496, 12497,   nil,   nil, }, "Interface\\icons\\spell_frost_frostarmor", },
			{ 1, 2,   62, 2, nil, nil,  nil, { 11165, 12475,   nil,   nil,   nil, }, "Interface\\icons\\spell_frost_freezingbreath", },
			{ 1, 3,   65, 3, nil, nil,  nil, { 11175, 12569, 12571,   nil,   nil, }, "Interface\\icons\\spell_frost_wisp", },
			{ 2, 0,   61, 3, nil, nil,  nil, { 11151, 12952, 12953,   nil,   nil, }, "Interface\\icons\\spell_frost_frostbolt", },
			{ 2, 1,   69, 1, nil, nil,  nil, { 12472,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_frost_wizardmark", },
			{ 2, 3,   63, 3, nil, nil,  nil, { 11185, 12487, 12488,   nil,   nil, }, "Interface\\icons\\spell_frost_icestorm", },
			{ 3, 0,  741, 2, nil, nil,  nil, { 16757, 16758,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_darkritual", },
			{ 3, 1,   66, 3, nil, nil,  nil, { 11160, 12518, 12519,   nil,   nil, }, "Interface\\icons\\spell_frost_stun", },
			{ 3, 2,   67, 5,   1,   2,   62, { 11170, 12982, 12983, 12984, 12985, }, "Interface\\icons\\spell_frost_frostshock", },
			{ 4, 1,   72, 1, nil, nil,  nil, { 11958,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_frost_frost", },
			{ 4, 2,   64, 3, nil, nil,  nil, { 11190, 12489, 12490,   nil,   nil, }, "Interface\\icons\\spell_frost_glacier", },
			{ 5, 2,   68, 5, nil, nil,  nil, { 11180, 28592, 28593, 28594, 28595, }, "Interface\\icons\\spell_frost_chillingblast", },
			{ 6, 1,   71, 1,   4,   1,   72, { 11426,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_ice_lament", },
		},
		[81] =
		{
			--{ 0, 0,   74, 2, nil, nil,  nil, {    66,    66,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_dispelmagic", },	--testing
			{ 0, 0,   74, 2, nil, nil,  nil, { 11210, 12592,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_dispelmagic", },
			{ 0, 1,   76, 5, nil, nil,  nil, { 11222, 12839, 12840, 12841, 12842, }, "Interface\\icons\\spell_holy_devotion", },
			{ 0, 2,   80, 5, nil, nil,  nil, { 11237, 12463, 12464, 16769, 16770, }, "Interface\\icons\\spell_nature_starfall", },
			{ 1, 0,   78, 2, nil, nil,  nil, {  6057,  6085,   nil,   nil,   nil, }, "Interface\\icons\\inv_wand_01", },
			{ 1, 1, 1650, 5, nil, nil,  nil, { 29441, 29444, 29445, 29446, 29447, }, "Interface\\icons\\spell_nature_astralrecalgroup", },
			{ 1, 2,   75, 5, nil, nil,  nil, { 11213, 12574, 12575, 12576, 12577, }, "Interface\\icons\\spell_shadow_manaburn", },
			{ 2, 0,   82, 2, nil, nil,  nil, { 11247, 12606,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_abolishmagic", },
			{ 2, 1,   81, 3, nil, nil,  nil, { 11242, 12467, 12469,   nil,   nil, }, "Interface\\icons\\spell_nature_wispsplode", },
			{ 2, 2,   85, 1, nil, nil,  nil, { 28574,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_arcane_arcaneresilience", },
			{ 3, 0,   83, 2, nil, nil,  nil, { 11252, 12605,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_detectlesserinvisibility", },
			{ 3, 1,   88, 2, nil, nil,  nil, { 11255, 12598,   nil,   nil,   nil, }, "Interface\\icons\\spell_frost_iceshock", },
			{ 3, 3, 1142, 3, nil, nil,  nil, { 18462, 18463, 18464,   nil,   nil, }, "Interface\\icons\\spell_shadow_siphonmana", },
			{ 4, 1,   86, 1, nil, nil,  nil, { 12043,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_enchantarmor", },
			{ 4, 2,   77, 5,   2,   2,   85, { 11232, 12500, 12501, 12502, 12503, }, "Interface\\icons\\spell_shadow_charm", },
			{ 5, 1,  421, 3,   4,   1,   86, { 15058, 15059, 15060,   nil,   nil, }, "Interface\\icons\\spell_shadow_teleport", },
			{ 6, 1,   87, 1,   5,   1,  421, { 12042,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_lightning", },
		},
	},
	PALADIN = {
		[381] =
		{
			{ 0, 1, 1401, 5, nil, nil,  nil, { 20042, 20045, 20046, 20047, 20048, }, "Interface\\icons\\spell_holy_fistofjustice", },
			{ 0, 2, 1407, 5, nil, nil,  nil, { 20101, 20102, 20103, 20104, 20105, }, "Interface\\icons\\spell_frost_windwalkon", },
			{ 1, 0, 1631, 2, nil, nil,  nil, { 25956, 25957,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_righteousfury", },
			{ 1, 1, 1464, 3, nil, nil,  nil, { 20335, 20336, 20337,   nil,   nil, }, "Interface\\icons\\spell_holy_holysmite", },
			{ 1, 2, 1403, 5, nil, nil,  nil, { 20060, 20061, 20062, 20063, 20064, }, "Interface\\icons\\ability_parry", },
			{ 2, 0, 1633, 3, nil, nil,  nil, {  9452, 26016, 26021,   nil,   nil, }, "Interface\\icons\\spell_holy_vindication", },
			{ 2, 1, 1411, 5, nil, nil,  nil, { 20117, 20118, 20119, 20120, 20121, }, "Interface\\icons\\spell_holy_retributionaura", },
			{ 2, 2, 1481, 1, nil, nil,  nil, { 20375,   nil,   nil,   nil,   nil, }, "Interface\\icons\\ability_warrior_innerrage", },
			{ 2, 3, 1634, 2, nil, nil,  nil, { 26022, 26023,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_persuitofjustice", },
			{ 3, 0, 1632, 2, nil, nil,  nil, {  9799, 25988,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_eyeforaneye", },
			{ 3, 2, 1405, 2, nil, nil,  nil, { 20091, 20092,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_auraoflight", },
			{ 4, 0, 1410, 3, nil, nil,  nil, { 20111, 20112, 20113,   nil,   nil, }, "Interface\\icons\\inv_hammer_04", },
			{ 4, 2, 1409, 1, nil, nil,  nil, { 20218,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_mindvision", },
			{ 5, 1, 1402, 5,   2,   1, 1411, { 20049, 20056, 20057, 20058, 20059, }, "Interface\\icons\\ability_racial_avatar", },
			{ 6, 1, 1441, 1, nil, nil,  nil, { 20066,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_prayerofhealing", },
		},
		[382] =
		{
			{ 0, 1, 1450, 5, nil, nil,  nil, { 20262, 20263, 20264, 20265, 20266, }, "Interface\\icons\\ability_golemthunderclap", },
			{ 0, 2, 1449, 5, nil, nil,  nil, { 20257, 20258, 20259, 20260, 20261, }, "Interface\\icons\\spell_nature_sleep", },
			{ 1, 1, 1432, 5, nil, nil,  nil, { 20205, 20206, 20207, 20209, 20208, }, "Interface\\icons\\spell_arcane_blink", },
			{ 1, 2, 1463, 5, nil, nil,  nil, { 20224, 20225, 20330, 20331, 20332, }, "Interface\\icons\\ability_thunderbolt", },
			{ 2, 0, 1444, 3, nil, nil,  nil, { 20237, 20238, 20239,   nil,   nil, }, "Interface\\icons\\spell_holy_holybolt", },
			{ 2, 1, 1435, 1, nil, nil,  nil, { 26573,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_innerfire", },
			{ 2, 2, 1443, 2, nil, nil,  nil, { 20234, 20235,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_layonhands", },
			{ 2, 3, 1628, 2, nil, nil,  nil, {  9453, 25836,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_unyieldingfaith", },
			{ 3, 1, 1461, 5, nil, nil,  nil, { 20210, 20212, 20213, 20214, 20215, }, "Interface\\icons\\spell_holy_greaterheal", },
			{ 3, 2, 1446, 2, nil, nil,  nil, { 20244, 20245,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_sealofwisdom", },
			{ 4, 1, 1433, 1,   3,   1, 1461, { 20216,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_heal", },
			{ 4, 2, 1465, 3, nil, nil,  nil, { 20359, 20360, 20361,   nil,   nil, }, "Interface\\icons\\spell_holy_healingaura", },
			{ 5, 2, 1627, 5, nil, nil,  nil, {  5923,  5924,  5925,  5926, 25829, }, "Interface\\icons\\spell_holy_power", },
			{ 6, 1, 1502, 1,   4,   1, 1433, { 20473,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_searinglight", },
		},
		[383] =
		{
			{ 0, 1, 1422, 5, nil, nil,  nil, { 20138, 20139, 20140, 20141, 20142, }, "Interface\\icons\\spell_holy_devotionaura", },
			{ 0, 2, 1421, 5, nil, nil,  nil, { 20127, 20130, 20135, 20136, 20137, }, "Interface\\icons\\ability_defend", },
			{ 1, 0, 1630, 3, nil, nil,  nil, { 20189, 20192, 20193,   nil,   nil, }, "Interface\\icons\\ability_rogue_ambush", },
			{ 1, 1, 1425, 2, nil, nil,  nil, { 20174, 20175,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_sealofprotection", },
			{ 1, 3, 1423, 5, nil, nil,  nil, { 20143, 20144, 20145, 20146, 20147, }, "Interface\\icons\\spell_holy_devotion", },
			{ 2, 0, 1442, 1, nil, nil,  nil, { 20217,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_magic_magearmor", },
			{ 2, 1, 1501, 3, nil, nil,  nil, { 20468, 20469, 20470,   nil,   nil, }, "Interface\\icons\\spell_holy_sealoffury", },
			{ 2, 2, 1424, 3,   0,   2, 1421, { 20148, 20149, 20150,   nil,   nil, }, "Interface\\icons\\inv_shield_06", },
			{ 2, 3, 1629, 5, nil, nil,  nil, { 20096, 20097, 20098, 20099, 20100, }, "Interface\\icons\\spell_magic_lesserinvisibilty", },
			{ 3, 1, 1521, 3, nil, nil,  nil, { 20487, 20488, 20489,   nil,   nil, }, "Interface\\icons\\spell_holy_sealofmight", },
			{ 3, 2, 1626, 3, nil, nil,  nil, { 20254, 20255, 20256,   nil,   nil, }, "Interface\\icons\\spell_holy_mindsooth", },
			{ 4, 1, 1431, 1, nil, nil,  nil, { 20911,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_lightningshield", },
			{ 4, 2, 1426, 5, nil, nil,  nil, { 20177, 20179, 20181, 20180, 20182, }, "Interface\\icons\\spell_holy_blessingofstrength", },
			{ 5, 2, 1429, 5, nil, nil,  nil, { 20196, 20197, 20198, 20199, 20200, }, "Interface\\icons\\inv_sword_20", },
			{ 6, 1, 1430, 1,   4,   1, 1431, { 20925,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_blessingofprotection", },
		},
	},
	PRIEST = {
		[201] =
		{
			{ 0, 1,  342, 5, nil, nil,  nil, { 14522, 14788, 14789, 14790, 14791, }, "Interface\\icons\\spell_magic_magearmor", },
			{ 0, 2,  345, 5, nil, nil,  nil, { 14524, 14525, 14526, 14527, 14528, }, "Interface\\icons\\inv_wand_01", },
			{ 1, 0,  352, 5, nil, nil,  nil, { 14523, 14784, 14785, 14786, 14787, }, "Interface\\icons\\spell_nature_manaregentotem", },
			{ 1, 1,  344, 2, nil, nil,  nil, { 14749, 14767,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_wordfortitude", },
			{ 1, 2,  343, 3, nil, nil,  nil, { 14748, 14768, 14769,   nil,   nil, }, "Interface\\icons\\spell_holy_powerwordshield", },
			{ 1, 3,  321, 2, nil, nil,  nil, { 14531, 14774,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_tranquility", },
			{ 2, 1,  348, 1, nil, nil,  nil, { 14751,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_frost_windwalkon", },
			{ 2, 2,  347, 3, nil, nil,  nil, { 14521, 14776, 14777,   nil,   nil, }, "Interface\\icons\\spell_nature_sleep", },
			{ 3, 0,  346, 3, nil, nil,  nil, { 14747, 14770, 14771,   nil,   nil, }, "Interface\\icons\\spell_holy_innerfire", },
			{ 3, 1,  341, 5, nil, nil,  nil, { 14520, 14780, 14781, 14782, 14783, }, "Interface\\icons\\ability_hibernation", },
			{ 3, 3,  350, 2, nil, nil,  nil, { 14750, 14772,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_manaburn", },
			{ 4, 1, 1201, 5, nil, nil,  nil, { 18551, 18552, 18553, 18554, 18555, }, "Interface\\icons\\spell_nature_enchantarmor", },
			{ 4, 2,  351, 1,   2,   2,  347, { 14752,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_divinespirit", },
			{ 5, 2, 1202, 5, nil, nil,  nil, { 18544, 18547, 18548, 18549, 18550, }, "Interface\\icons\\spell_nature_slowingtotem", },
			{ 6, 1,  322, 1,   4,   1, 1201, { 10060,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_powerinfusion", },
		},
		[202] =
		{
			{ 0, 0,  410, 2, nil, nil,  nil, { 14913, 15012,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_healingfocus", },
			{ 0, 1,  406, 3, nil, nil,  nil, { 14908, 15020, 17191,   nil,   nil, }, "Interface\\icons\\spell_holy_renew", },
			{ 0, 2,  401, 5, nil, nil,  nil, { 14889, 15008, 15009, 15010, 15011, }, "Interface\\icons\\spell_holy_sealofsalvation", },
			{ 1, 1,  411, 5, nil, nil,  nil, { 27900, 27901, 27902, 27903, 27904, }, "Interface\\icons\\spell_holy_spellwarding", },
			{ 1, 2, 1181, 5, nil, nil,  nil, { 18530, 18531, 18533, 18534, 18535, }, "Interface\\icons\\spell_holy_sealofwrath", },
			{ 2, 0,  442, 1, nil, nil,  nil, { 15237,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_holynova", },
			{ 2, 1, 1636, 3, nil, nil,  nil, { 27811, 27815, 27816,   nil,   nil, }, "Interface\\icons\\spell_holy_blessedrecovery", },
			{ 2, 3,  361, 3, nil, nil,  nil, { 14892, 15362, 15363,   nil,   nil, }, "Interface\\icons\\spell_holy_layonhands", },
			{ 3, 0, 1635, 2, nil, nil,  nil, { 27789, 27790,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_purify", },
			{ 3, 1,  408, 3, nil, nil,  nil, { 14912, 15013, 15014,   nil,   nil, }, "Interface\\icons\\spell_holy_heal02", },
			{ 3, 2,  403, 2,   1,   2, 1181, { 14909, 15017,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_searinglightpriest", },
			{ 4, 0,  413, 2, nil, nil,  nil, { 14911, 15018,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_prayerofhealing02", },
			{ 4, 1, 1561, 1, nil, nil,  nil, { 20711,   nil,   nil,   nil,   nil, }, "Interface\\icons\\inv_enchant_essenceeternallarge", },
			{ 4, 2,  402, 5, nil, nil,  nil, { 14901, 15028, 15029, 15030, 15031, }, "Interface\\icons\\spell_holy_spiritualguidence", },
			{ 5, 2,  404, 5, nil, nil,  nil, { 14898, 15349, 15354, 15355, 15356, }, "Interface\\icons\\spell_nature_moonglow", },
			{ 6, 1, 1637, 1,   4,   1, 1561, { 724,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_summonlightwell", },
		},
		[203] =
		{
			{ 0, 1,  465, 5, nil, nil,  nil, { 15270, 15335, 15336, 15337, 15338, }, "Interface\\icons\\spell_shadow_requiem", },
			{ 0, 2,  464, 5, nil, nil,  nil, { 15268, 15323, 15324, 15325, 15326, }, "Interface\\icons\\spell_shadow_gathershadows", },
			{ 1, 0,  466, 3, nil, nil,  nil, { 15318, 15272, 15320,   nil,   nil, }, "Interface\\icons\\spell_shadow_shadowward", },
			{ 1, 1,  482, 2, nil, nil,  nil, { 15275, 15317,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_shadowwordpain", },
			{ 1, 2,  463, 5, nil, nil,  nil, { 15260, 15327, 15328, 15329, 15330, }, "Interface\\icons\\spell_shadow_burningspirit", },
			{ 2, 0,  542, 2, nil, nil,  nil, { 15392, 15448,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_psychicscream", },
			{ 2, 1,  481, 5, nil, nil,  nil, { 15273, 15312, 15313, 15314, 15316, }, "Interface\\icons\\spell_shadow_unholyfrenzy", },
			{ 2, 2,  501, 1, nil, nil,  nil, { 15407,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_siphonmana", },
			{ 3, 1,  483, 2, nil, nil,  nil, { 15274, 15311,   nil,   nil,   nil, }, "Interface\\icons\\spell_magic_lesserinvisibilty", },
			{ 3, 2,  881, 3, nil, nil,  nil, { 17322, 17323, 17325,   nil,   nil, }, "Interface\\icons\\spell_shadow_chilltouch", },
			{ 3, 3,  461, 5, nil, nil,  nil, { 15257, 15331, 15332, 15333, 15334, }, "Interface\\icons\\spell_shadow_blackplague", },
			{ 4, 0,  541, 1,   2,   0,  542, { 15487,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_impphaseshift", },
			{ 4, 1,  484, 1, nil, nil,  nil, { 15286,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_unsummonbuilding", },
			{ 4, 2, 1638, 2,   4,   1,  484, { 27839, 27840,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_improvedvampiricembrace", },
			{ 5, 2,  462, 5, nil, nil,  nil, { 15259, 15307, 15308, 15309, 15310, }, "Interface\\icons\\spell_shadow_twilight", },
			{ 6, 1,  521, 1,   4,   1,  484, { 15473,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_shadowform", },
		},
	},
	ROGUE = {
		[181] =
		{
			{ 0, 0,  203, 3, nil, nil,  nil, { 13741, 13793, 13792,   nil,   nil, }, "Interface\\icons\\ability_gouge", },
			{ 0, 1,  201, 2, nil, nil,  nil, { 13732, 13863,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_ritualofsacrifice", },
			{ 0, 2,  186, 5, nil, nil,  nil, { 13712, 13788, 13789, 13790, 13791, }, "Interface\\icons\\spell_nature_invisibilty", },
			{ 1, 0,  202, 3, nil, nil,  nil, { 13733, 13865, 13866,   nil,   nil, }, "Interface\\icons\\ability_backstab", },
			{ 1, 1,  187, 5, nil, nil,  nil, { 13713, 13853, 13854, 13855, 13856, }, "Interface\\icons\\ability_parry", },
			{ 1, 2,  181, 5, nil, nil,  nil, { 13705, 13832, 13843, 13844, 13845, }, "Interface\\icons\\ability_marksmanship", },
			{ 2, 0,  204, 2, nil, nil,  nil, { 13742, 13872,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_shadowward", },
			{ 2, 1,  301, 1,   1,   1,  187, { 14251,   nil,   nil,   nil,   nil, }, "Interface\\icons\\ability_warrior_challange", },
			{ 2, 3,  222, 2, nil, nil,  nil, { 13743, 13875,   nil,   nil,   nil, }, "Interface\\icons\\ability_rogue_sprint", },
			{ 3, 0,  206, 2, nil, nil,  nil, { 13754, 13867,   nil,   nil,   nil, }, "Interface\\icons\\ability_kick", },
			{ 3, 1,  182, 5, nil, nil,  nil, { 13706, 13804, 13805, 13806, 13807, }, "Interface\\icons\\inv_weapon_shortblade_05", },
			{ 3, 2,  221, 5,   1,   2,  181, { 13715, 13848, 13849, 13851, 13852, }, "Interface\\icons\\ability_dualwield", },
			{ 4, 0,  184, 5, nil, nil,  nil, { 13709, 13800, 13801, 13802, 13803, }, "Interface\\icons\\inv_mace_01", },
			{ 4, 1,  223, 1, nil, nil,  nil, { 13877,   nil,   nil,   nil,   nil, }, "Interface\\icons\\ability_warrior_punishingblow", },
			{ 4, 2,  242, 5, nil, nil,  nil, { 13960, 13961, 13962, 13963, 13964, }, "Interface\\icons\\inv_sword_27", },
			{ 4, 3,  183, 5, nil, nil,  nil, { 13707, 13966, 13967, 13968, 13969, }, "Interface\\icons\\inv_gauntlets_04", },
			{ 5, 1, 1703, 2,   4,   1,  223, { 30919, 30920,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_blessingofstrength", },
			{ 5, 2, 1122, 3, nil, nil,  nil, { 18427, 18428, 18429,   nil,   nil, }, "Interface\\icons\\ability_racial_avatar", },
			{ 6, 1,  205, 1, nil, nil,  nil, { 13750,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_shadowworddominate", },
		},
		[182] =
		{
			{ 0, 0,  276, 3, nil, nil,  nil, { 14162, 14163, 14164,   nil,   nil, }, "Interface\\icons\\ability_rogue_eviscerate", },
			{ 0, 1,  272, 2, nil, nil,  nil, { 14144, 14148,   nil,   nil,   nil, }, "Interface\\icons\\ability_fiegndead", },
			{ 0, 2,  270, 5, nil, nil,  nil, { 14138, 14139, 14140, 14141, 14142, }, "Interface\\icons\\ability_racial_bloodrage", },
			{ 1, 0,  273, 3, nil, nil,  nil, { 14156, 14160, 14161,   nil,   nil, }, "Interface\\icons\\ability_druid_disembowel", },
			{ 1, 1,  274, 2, nil, nil,  nil, { 14158, 14159,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_deathscream", },
			{ 1, 3,  277, 3, nil, nil,  nil, { 14165, 14166, 14167,   nil,   nil, }, "Interface\\icons\\ability_rogue_slicedice", },
			{ 2, 0,  281, 1, nil, nil,  nil, { 14179,   nil,   nil,   nil,   nil, }, "Interface\\icons\\ability_warrior_decisivestrike", },
			{ 2, 1,  278, 2, nil, nil,  nil, { 14168, 14169,   nil,   nil,   nil, }, "Interface\\icons\\ability_warrior_riposte", },
			{ 2, 2,  269, 5,   0,   2,  270, { 14128, 14132, 14135, 14136, 14137, }, "Interface\\icons\\ability_criticalstrike", },
			{ 3, 1,  682, 5, nil, nil,  nil, { 16513, 16514, 16515, 16719, 16720, }, "Interface\\icons\\ability_rogue_feigndeath", },
			{ 3, 2,  268, 5, nil, nil,  nil, { 14113, 14114, 14115, 14116, 14117, }, "Interface\\icons\\ability_poisons", },
			{ 4, 1,  280, 1, nil, nil,  nil, { 14177,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_ice_lament", },
			{ 4, 2,  279, 3, nil, nil,  nil, { 14174, 14175, 14176,   nil,   nil, }, "Interface\\icons\\ability_rogue_kidneyshot", },
			{ 5, 1,  283, 5,   4,   1,  280, { 14186, 14190, 14193, 14194, 14195, }, "Interface\\icons\\spell_shadow_chilltouch", },
			{ 6, 1,  382, 1, nil, nil,  nil, { 14983,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_earthbindtotem", },
		},
		[183] =
		{
			{ 0, 1,  241, 5, nil, nil,  nil, { 13958, 13970, 13971, 13972, 13973, }, "Interface\\icons\\spell_shadow_charm", },
			{ 0, 2,  261, 5, nil, nil,  nil, { 14057, 14072, 14073, 14074, 14075, }, "Interface\\icons\\ability_warrior_warcry", },
			{ 1, 0, 1700, 2, nil, nil,  nil, { 30892, 30893,   nil,   nil,   nil, }, "Interface\\icons\\ability_rogue_feint", },
			{ 1, 1,  247, 2, nil, nil,  nil, { 13981, 14066,   nil,   nil,   nil, }, "Interface\\icons\\spell_magic_lesserinvisibilty", },
			{ 1, 2,  244, 5, nil, nil,  nil, { 13975, 14062, 14063, 14064, 14065, }, "Interface\\icons\\ability_stealth", },
			{ 2, 0,  245, 3, nil, nil,  nil, { 13976, 13979, 13980,   nil,   nil, }, "Interface\\icons\\spell_shadow_fumble", },
			{ 2, 1,  303, 1, nil, nil,  nil, { 14278,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_curse", },
			{ 2, 2,  263, 3, nil, nil,  nil, { 14079, 14080, 14081,   nil,   nil, }, "Interface\\icons\\ability_rogue_ambush", },
			{ 3, 0,  246, 3, nil, nil,  nil, { 13983, 14070, 14071,   nil,   nil, }, "Interface\\icons\\spell_nature_mirrorimage", },
			{ 3, 1,  262, 3, nil, nil,  nil, { 14076, 14094, 14095,   nil,   nil, }, "Interface\\icons\\ability_sap", },
			{ 3, 2, 1123, 3, nil, nil,  nil, { 14171, 14172, 14173,   nil,   nil, }, "Interface\\icons\\inv_sword_17", },
			{ 4, 0, 1701, 2, nil, nil,  nil, { 30894, 30895,   nil,   nil,   nil, }, "Interface\\icons\\ability_ambush", },
			{ 4, 1,  284, 1, nil, nil,  nil, { 14185,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_antishadow", },
			{ 4, 2,  265, 2, nil, nil,  nil, { 14082, 14083,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_summonsuccubus", },
			{ 4, 3,  681, 1,   3,   2, 1123, { 16511,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_lifedrain", },
			{ 5, 2, 1702, 5, nil, nil,  nil, { 30902, 30903, 30904, 30905, 30906, }, "Interface\\icons\\inv_weapon_crossbow_11", },
			{ 6, 1,  381, 1,   4,   1,  284, { 14183,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_possession", },
		},
	},
	SHAMAN = {
		[261] =
		{
			{ 0, 1,  564, 5, nil, nil,  nil, { 16039, 16109, 16110, 16111, 16112, }, "Interface\\icons\\spell_nature_wispsplode", },
			{ 0, 2,  563, 5, nil, nil,  nil, { 16035, 16105, 16106, 16107, 16108, }, "Interface\\icons\\spell_fire_fireball", },
			{ 1, 0,  572, 2, nil, nil,  nil, { 16043, 16130,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_stoneclawtotem", },
			{ 1, 1, 1640, 3, nil, nil,  nil, { 28996, 28997, 28998,   nil,   nil, }, "Interface\\icons\\spell_nature_spiritarmor", },
			{ 1, 2,  561, 3, nil, nil,  nil, { 16038, 16160, 16161,   nil,   nil, }, "Interface\\icons\\spell_fire_immolation", },
			{ 2, 0,  574, 1, nil, nil,  nil, { 16164,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_manaburn", },
			{ 2, 1,  575, 5, nil, nil,  nil, { 16040, 16113, 16114, 16115, 16116, }, "Interface\\icons\\spell_frost_frostward", },
			{ 2, 2,  562, 5, nil, nil,  nil, { 16041, 16117, 16118, 16119, 16120, }, "Interface\\icons\\spell_nature_callstorm", },
			{ 3, 0,  567, 2, nil, nil,  nil, { 16086, 16544,   nil,   nil,   nil, }, "Interface\\icons\\spell_fire_sealoffire", },
			{ 3, 1, 1642, 3, nil, nil,  nil, { 29062, 29064, 29065,   nil,   nil, }, "Interface\\icons\\spell_nature_eyeofthestorm", },
			{ 3, 3, 1645, 3, nil, nil,  nil, { 30160, 29179, 29180,   nil,   nil, }, "Interface\\icons\\spell_fire_elementaldevastation", },
			{ 4, 0, 1641, 2, nil, nil,  nil, { 28999, 29000,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_stormreach", },
			{ 4, 1,  565, 1, nil, nil,  nil, { 16089,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_fire_volcano", },
			{ 5, 2,  721, 5,   2,   2,  562, { 16578, 16579, 16580, 16581, 16582, }, "Interface\\icons\\spell_lightning_lightningbolt01", },
			{ 6, 1,  573, 1,   4,   1,  565, { 16166,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_wispheal", },
		},
		[262] =
		{
			{ 0, 1,  586, 5, nil, nil,  nil, { 16182, 16226, 16227, 16228, 16229, }, "Interface\\icons\\spell_nature_magicimmunity", },
			{ 0, 2,  593, 5, nil, nil,  nil, { 16179, 16214, 16215, 16216, 16217, }, "Interface\\icons\\spell_frost_manarecharge", },
			{ 1, 0,  589, 2, nil, nil,  nil, { 16184, 16209,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_reincarnation", },
			{ 1, 1,  581, 3, nil, nil,  nil, { 16176, 16235, 16240,   nil,   nil, }, "Interface\\icons\\spell_nature_undyingstrength", },
			{ 1, 2,  595, 5, nil, nil,  nil, { 16173, 16222, 16223, 16224, 16225, }, "Interface\\icons\\spell_nature_moonglow", },
			{ 2, 0,  583, 3, nil, nil,  nil, { 16180, 16196, 16198,   nil,   nil, }, "Interface\\icons\\spell_frost_stun", },
			{ 2, 1,  587, 5, nil, nil,  nil, { 16181, 16230, 16232, 16233, 16234, }, "Interface\\icons\\spell_nature_healingwavelesser", },
			{ 2, 2,  582, 1, nil, nil,  nil, { 16189,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_nullward", },
			{ 2, 3, 1646, 3, nil, nil,  nil, { 29187, 29189, 29191,   nil,   nil, }, "Interface\\icons\\spell_nature_healingtouch", },
			{ 3, 1,  588, 5, nil, nil,  nil, { 16187, 16205, 16206, 16207, 16208, }, "Interface\\icons\\spell_nature_manaregentotem", },
			{ 3, 2,  594, 5, nil, nil,  nil, { 16194, 16218, 16219, 16220, 16221, }, "Interface\\icons\\spell_nature_tranquility", },
			{ 4, 0, 1648, 3, nil, nil,  nil, { 29206, 29205, 29202,   nil,   nil, }, "Interface\\icons\\spell_nature_healingway", },
			{ 4, 2,  591, 1, nil, nil,  nil, { 16188,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_ravenform", },
			{ 5, 2,  592, 5, nil, nil,  nil, { 16178, 16210, 16211, 16212, 16213, }, "Interface\\icons\\spell_frost_wizardmark", },
			{ 6, 1,  590, 1,   3,   1,  588, { 16190,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_frost_summonwaterelemental", },
		},
		[263] =
		{
			{ 0, 1,  614, 5, nil, nil,  nil, { 17485, 17486, 17487, 17488, 17489, }, "Interface\\icons\\spell_shadow_grimward", },
			{ 0, 2,  612, 5, nil, nil,  nil, { 16253, 16298, 16299, 16300, 16301, }, "Interface\\icons\\inv_shield_06", },
			{ 1, 0,  609, 2, nil, nil,  nil, { 16258, 16293,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_stoneskintotem", },
			{ 1, 1,  613, 5, nil, nil,  nil, { 16255, 16302, 16303, 16304, 16305, }, "Interface\\icons\\ability_thunderbolt", },
			{ 1, 2,  605, 2, nil, nil,  nil, { 16262, 16287,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_spiritwolf", },
			{ 1, 3,  607, 3, nil, nil,  nil, { 16261, 16290, 16291,   nil,   nil, }, "Interface\\icons\\spell_nature_lightningshield", },
			{ 2, 0,  610, 2, nil, nil,  nil, { 16259, 16295,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_earthbindtotem", },
			{ 2, 2,  617, 1, nil, nil,  nil, { 16269,   nil,   nil,   nil,   nil, }, "Interface\\icons\\inv_axe_10", },
			{ 2, 3,  601, 5, nil, nil,  nil, { 16254, 16271, 16272, 16273, 16274, }, "Interface\\icons\\spell_nature_mirrorimage", },
			{ 3, 1,  602, 5,   1,   1,  613, { 16256, 16281, 16282, 16283, 16284, }, "Interface\\icons\\ability_ghoulfrenzy", },
			{ 3, 2,  615, 5, nil, nil,  nil, { 16252, 16306, 16307, 16308, 16309, }, "Interface\\icons\\spell_holy_devotion", },
			{ 4, 0, 1647, 2, nil, nil,  nil, { 29192, 29193,   nil,   nil,   nil, }, "Interface\\icons\\spell_fire_enchantweapon", },
			{ 4, 1,  611, 3, nil, nil,  nil, { 16266, 29079, 29080,   nil,   nil, }, "Interface\\icons\\spell_fire_flametounge", },
			{ 4, 2,  616, 1, nil, nil,  nil, { 16268,   nil,   nil,   nil,   nil, }, "Interface\\icons\\ability_parry", },
			{ 5, 2, 1643, 5, nil, nil,  nil, { 29082, 29084, 29086, 29087, 29088, }, "Interface\\icons\\ability_hunter_swiftstrike", },
			{ 6, 1,  901, 1,   4,   1,  611, { 17364,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_sealofmight", },
		},
	},
	WARLOCK = {
		[301] =
		{
			{ 0, 1,  944, 5, nil, nil,  nil, { 17793, 17796, 17801, 17802, 17803, }, "Interface\\icons\\spell_shadow_shadowbolt", },
			{ 0, 2,  941, 5, nil, nil,  nil, { 17778, 17779, 17780, 17781, 17782, }, "Interface\\icons\\spell_fire_windsofwoe", },
			{ 1, 1,  943, 5, nil, nil,  nil, { 17788, 17789, 17790, 17791, 17792, }, "Interface\\icons\\spell_shadow_deathpact", },
			{ 1, 2,  982, 5, nil, nil,  nil, { 18119, 18120, 18121, 18122, 18123, }, "Interface\\icons\\spell_fire_fire", },
			{ 2, 0,  983, 2, nil, nil,  nil, { 18126, 18127,   nil,   nil,   nil, }, "Interface\\icons\\spell_fire_firebolt", },
			{ 2, 1,  984, 2, nil, nil,  nil, { 18128, 18129,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_curse", },
			{ 2, 2,  981, 5, nil, nil,  nil, { 18130, 18131, 18132, 18133, 18134, }, "Interface\\icons\\spell_fire_flameshock", },
			{ 2, 3,  963, 1, nil, nil,  nil, { 17877,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_scourgebuild", },
			{ 3, 0,  985, 2, nil, nil,  nil, { 18135, 18136,   nil,   nil,   nil, }, "Interface\\icons\\spell_fire_lavaspawn", },
			{ 3, 1,  964, 2, nil, nil,  nil, { 17917, 17918,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_corpseexplode", },
			{ 3, 3,  965, 5, nil, nil,  nil, { 17927, 17929, 17930, 17931, 17932, }, "Interface\\icons\\spell_fire_soulburn", },
			{ 4, 0,  986, 2,   3,   0,  985, { 18096, 18073,   nil,   nil,   nil, }, "Interface\\icons\\spell_fire_volcano", },
			{ 4, 1,  961, 5, nil, nil,  nil, { 17815, 17833, 17834, 17835, 17836, }, "Interface\\icons\\spell_fire_immolation", },
			{ 4, 2,  967, 1,   2,   2,  981, { 17959,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_shadowwordpain", },
			{ 5, 2,  966, 5, nil, nil,  nil, { 17954, 17955, 17956, 17957, 17958, }, "Interface\\icons\\spell_fire_selfdestruct", },
			{ 6, 1,  968, 1,   4,   1,  961, { 17962,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_fire_fireball", },
		},
		[302] =
		{
			{ 0, 1, 1005, 5, nil, nil,  nil, { 18174, 18175, 18176, 18177, 18178, }, "Interface\\icons\\spell_shadow_unsummonbuilding", },
			{ 0, 2, 1003, 5, nil, nil,  nil, { 17810, 17811, 17812, 17813, 17814, }, "Interface\\icons\\spell_shadow_abominationexplosion", },
			{ 1, 0, 1006, 3, nil, nil,  nil, { 18179, 18180, 18181,   nil,   nil, }, "Interface\\icons\\spell_shadow_curseofmannoroth", },
			{ 1, 1, 1101, 2, nil, nil,  nil, { 18213, 18372,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_haunting", },
			{ 1, 2, 1007, 2, nil, nil,  nil, { 18182, 18183,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_burningspirit", },
			{ 1, 3, 1004, 5, nil, nil,  nil, { 17804, 17805, 17806, 17807, 17808, }, "Interface\\icons\\spell_shadow_lifedrain02", },
			{ 2, 0, 1284, 3, nil, nil,  nil, { 18827, 18829, 18830,   nil,   nil, }, "Interface\\icons\\spell_shadow_curseofsargeras", },
			{ 2, 1, 1001, 5, nil, nil,  nil, { 17783, 17784, 17785, 17786, 17787, }, "Interface\\icons\\spell_shadow_fingerofdeath", },
			{ 2, 2, 1061, 1, nil, nil,  nil, { 18288,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_contagion", },
			{ 3, 0, 1021, 2, nil, nil,  nil, { 18218, 18219,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_callofbone", },
			{ 3, 1, 1002, 2, nil, nil,  nil, { 18094, 18095,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_twilight", },
			{ 3, 3, 1121, 2, nil, nil,  nil, { 17864, 18393,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_siphonmana", },
			{ 4, 1, 1041, 1, nil, nil,  nil, { 18265,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_requiem", },
			{ 4, 2, 1081, 1,   2,   2, 1061, { 18223,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_grimward", },
			{ 4, 3, 1082, 4,   4,   2, 1081, { 18310, 18311, 18312, 18313,   nil, }, "Interface\\icons\\spell_shadow_grimward", },
			{ 5, 1, 1042, 5,   4,   1, 1041, { 18271, 18272, 18273, 18274, 18275, }, "Interface\\icons\\spell_shadow_shadetruesight", },
			{ 6, 1, 1022, 1, nil, nil,  nil, { 18220,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_darkritual", },
		},
		[303] =
		{
			{ 0, 0, 1221, 2, nil, nil,  nil, { 18692, 18693,   nil,   nil,   nil, }, "Interface\\icons\\inv_stone_04", },
			{ 0, 1, 1222, 3, nil, nil,  nil, { 18694, 18695, 18696,   nil,   nil, }, "Interface\\icons\\spell_shadow_summonimp", },
			{ 0, 2, 1223, 5, nil, nil,  nil, { 18697, 18698, 18699, 18700, 18701, }, "Interface\\icons\\spell_shadow_metamorphosis", },
			{ 1, 0, 1224, 2, nil, nil,  nil, { 18703, 18704,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_lifedrain", },
			{ 1, 1, 1225, 3, nil, nil,  nil, { 18705, 18706, 18707,   nil,   nil, }, "Interface\\icons\\spell_shadow_summonvoidwalker", },
			{ 1, 2, 1242, 5, nil, nil,  nil, { 18731, 18743, 18744, 18745, 18746, }, "Interface\\icons\\spell_holy_magicalsentry", },
			{ 2, 0, 1243, 3, nil, nil,  nil, { 18754, 18755, 18756,   nil,   nil, }, "Interface\\icons\\spell_shadow_summonsuccubus", },
			{ 2, 1, 1226, 1, nil, nil,  nil, { 18708,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_removecurse", },
			{ 2, 2, 1241, 5, nil, nil,  nil, { 18748, 18749, 18750, 18751, 18752, }, "Interface\\icons\\spell_shadow_antishadow", },
			{ 3, 1, 1227, 2,   2,   1, 1226, { 18709, 18710,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_impphaseshift", },
			{ 3, 2, 1262, 5, nil, nil,  nil, { 18769, 18770, 18771, 18772, 18773, }, "Interface\\icons\\spell_shadow_shadowworddominate", },
			{ 4, 0, 1283, 5, nil, nil,  nil, { 18821, 18822, 18823, 18824, 18825, }, "Interface\\icons\\spell_shadow_enslavedemon", },
			{ 4, 1, 1281, 1, nil, nil,  nil, { 18788,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_psychicscream", },
			{ 4, 3, 1261, 2, nil, nil,  nil, { 18767, 18768,   nil,   nil,   nil, }, "Interface\\icons\\inv_ammo_firetar", },
			{ 5, 2, 1244, 5,   3,   2, 1262, { 23785, 23822, 23823, 23824, 23825, }, "Interface\\icons\\spell_shadow_shadowpact", },
			{ 6, 1, 1282, 1,   4,   1, 1281, { 19028,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_gathershadows", },
			{ 6, 2, 1263, 2, nil, nil,  nil, { 18774, 18775,   nil,   nil,   nil, }, "Interface\\icons\\inv_misc_gem_sapphire_01", },
		},
	},
	WARRIOR = {
		[161] =
		{
			{ 0, 0,  124, 3, nil, nil,  nil, { 12282, 12663, 12664,   nil,   nil, }, "Interface\\icons\\ability_rogue_ambush", },
			{ 0, 1,  130, 5, nil, nil,  nil, { 16462, 16463, 16464, 16465, 16466, }, "Interface\\icons\\ability_parry", },
			{ 0, 2,  127, 3, nil, nil,  nil, { 12286, 12658, 12659,   nil,   nil, }, "Interface\\icons\\ability_gouge", },
			{ 1, 0,  126, 2, nil, nil,  nil, { 12285, 12697,   nil,   nil,   nil, }, "Interface\\icons\\ability_warrior_charge", },
			{ 1, 1,  641, 5, nil, nil,  nil, { 12295, 12676, 12677, 12678, 12679, }, "Interface\\icons\\spell_nature_enchantarmor", },
			{ 1, 3,  128, 3, nil, nil,  nil, { 12287, 12665, 12666,   nil,   nil, }, "Interface\\icons\\ability_thunderclap", },
			{ 2, 0,  131, 2, nil, nil,  nil, { 12290, 12963,   nil,   nil,   nil, }, "Interface\\icons\\inv_sword_05", },
			{ 2, 1,  137, 1,   1,   1,  641, { 12296,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_blessingofstamina", },
			{ 2, 2,  121, 3,   0,   2,  127, { 12834, 12849, 12867,   nil,   nil, }, "Interface\\icons\\ability_backstab", },
			{ 3, 1,  136, 5, nil, nil,  nil, { 12163, 12711, 12712, 12713, 12714, }, "Interface\\icons\\inv_axe_09", },
			{ 3, 2,  662, 2,   2,   2,  121, { 16493, 16494,   nil,   nil,   nil, }, "Interface\\icons\\ability_searingarrow", },
			{ 4, 0,  132, 5, nil, nil,  nil, { 12700, 12781, 12783, 12784, 12785, }, "Interface\\icons\\inv_axe_06", },
			{ 4, 1,  133, 1, nil, nil,  nil, { 12292,   nil,   nil,   nil,   nil, }, "Interface\\icons\\ability_rogue_slicedice", },
			{ 4, 2,  125, 5, nil, nil,  nil, { 12284, 12701, 12702, 12703, 12704, }, "Interface\\icons\\inv_mace_01", },
			{ 4, 3,  123, 5, nil, nil,  nil, { 12281, 12812, 12813, 12814, 12815, }, "Interface\\icons\\inv_sword_27", },
			{ 5, 0,  134, 5, nil, nil,  nil, { 12165, 12830, 12831, 12832, 12833, }, "Interface\\icons\\inv_weapon_halbard_01", },
			{ 5, 2,  129, 3, nil, nil,  nil, { 12289, 12668, 23695,   nil,   nil, }, "Interface\\icons\\ability_shockwave", },
			{ 6, 1,  135, 1,   4,   1,  133, { 12294,   nil,   nil,   nil,   nil, }, "Interface\\icons\\ability_warrior_savageblow", },
		},
		[163] =
		{
			{ 0, 1, 1601, 5, nil, nil,  nil, { 12298, 12724, 12725, 12726, 12727, }, "Interface\\icons\\inv_shield_06", },
			{ 0, 2,  138, 5, nil, nil,  nil, { 12297, 12750, 12751, 12752, 12753, }, "Interface\\icons\\spell_nature_mirrorimage", },
			{ 1, 0,  142, 2, nil, nil,  nil, { 12301, 12818,   nil,   nil,   nil, }, "Interface\\icons\\ability_racial_bloodrage", },
			{ 1, 2,  140, 5, nil, nil,  nil, { 12299, 12761, 12762, 12763, 12764, }, "Interface\\icons\\spell_holy_devotion", },
			{ 1, 3,  141, 5, nil, nil,  nil, { 12300, 12959, 12960, 12961, 12962, }, "Interface\\icons\\spell_magic_magearmor", },
			{ 2, 0,  153, 1,   1,   0,  142, { 12975,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_holy_ashestoashes", },
			{ 2, 1,  145, 3,   0,   1, 1601, { 12945, 12307, 12944,   nil,   nil, }, "Interface\\icons\\ability_defend", },
			{ 2, 2,  147, 3, nil, nil,  nil, { 12797, 12799, 12800,   nil,   nil, }, "Interface\\icons\\ability_warrior_revenge", },
			{ 2, 3,  144, 5, nil, nil,  nil, { 12303, 12788, 12789, 12791, 12792, }, "Interface\\icons\\ability_warrior_innerrage", },
			{ 3, 0,  146, 3, nil, nil,  nil, { 12308, 12810, 12811,   nil,   nil, }, "Interface\\icons\\ability_warrior_sunder", },
			{ 3, 1,  151, 3, nil, nil,  nil, { 12313, 12804, 12807,   nil,   nil, }, "Interface\\icons\\ability_warrior_disarm", },
			{ 3, 2,  143, 2, nil, nil,  nil, { 12302, 12765,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_reincarnation", },
			{ 4, 0,  150, 2, nil, nil,  nil, { 12312, 12803,   nil,   nil,   nil, }, "Interface\\icons\\ability_warrior_shieldwall", },
			{ 4, 1,  152, 1, nil, nil,  nil, { 12809,   nil,   nil,   nil,   nil, }, "Interface\\icons\\ability_thunderbolt", },
			{ 4, 2,  149, 2, nil, nil,  nil, { 12311, 12958,   nil,   nil,   nil, }, "Interface\\icons\\ability_warrior_shieldbash", },
			{ 5, 2,  702, 5, nil, nil,  nil, { 16538, 16539, 16540, 16541, 16542, }, "Interface\\icons\\inv_sword_20", },
			{ 6, 1,  148, 1,   4,   1,  152, { 23922,   nil,   nil,   nil,   nil, }, "Interface\\icons\\inv_shield_05", },
		},
		[164] =
		{
			{ 0, 1,  158, 5, nil, nil,  nil, { 12321, 12835, 12836, 12837, 12838, }, "Interface\\icons\\spell_nature_purge", },
			{ 0, 2,  157, 5, nil, nil,  nil, { 12320, 12852, 12853, 12855, 12856, }, "Interface\\icons\\ability_rogue_eviscerate", },
			{ 1, 1,  161, 5, nil, nil,  nil, { 12324, 12876, 12877, 12878, 12879, }, "Interface\\icons\\ability_warrior_warcry", },
			{ 1, 2,  159, 5, nil, nil,  nil, { 12322, 12999, 13000, 13001, 13002, }, "Interface\\icons\\spell_nature_stoneclawtotem", },
			{ 2, 0,  166, 3, nil, nil,  nil, { 12329, 12950, 20496,   nil,   nil, }, "Interface\\icons\\ability_warrior_cleave", },
			{ 2, 1,  160, 1, nil, nil,  nil, { 12323,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_deathscream", },
			{ 2, 2,  661, 3, nil, nil,  nil, { 16487, 16489, 16492,   nil,   nil, }, "Interface\\icons\\spell_shadow_summonimp", },
			{ 2, 3,  154, 5, nil, nil,  nil, { 12318, 12857, 12858, 12860, 12861, }, "Interface\\icons\\ability_warrior_battleshout", },
			{ 3, 0, 1581, 5, nil, nil,  nil, { 23584, 23585, 23586, 23587, 23588, }, "Interface\\icons\\ability_dualwield", },
			{ 3, 1, 1542, 2, nil, nil,  nil, { 20502, 20503,   nil,   nil,   nil, }, "Interface\\icons\\inv_sword_48", },
			{ 3, 2,  155, 5, nil, nil,  nil, { 12317, 13045, 13046, 13047, 13048, }, "Interface\\icons\\spell_shadow_unholyfrenzy", },
			{ 4, 0,  168, 5, nil, nil,  nil, { 12862, 12330, 20497, 20498, 20499, }, "Interface\\icons\\ability_warrior_decisivestrike", },
			{ 4, 1,  165, 1, nil, nil,  nil, { 12328,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_shadow_deathpact", },
			{ 4, 3, 1543, 2, nil, nil,  nil, { 20504, 20505,   nil,   nil,   nil, }, "Interface\\icons\\ability_rogue_sprint", },
			{ 5, 0, 1541, 2, nil, nil,  nil, { 20500, 20501,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_ancestralguardian", },
			{ 5, 2,  156, 5,   3,   2,  155, { 12319, 12971, 12972, 12973, 12974, }, "Interface\\icons\\ability_ghoulfrenzy", },
			{ 6, 1,  167, 1,   4,   1,  165, { 23881,   nil,   nil,   nil,   nil, }, "Interface\\icons\\spell_nature_bloodlust", },
		},
	},
};
--
	--	DT.SpellDB_P
	--1------2---3-----4------5-----6--------7-------8
	--level, id, cost, phase, name, passive, talent, class
	--	passive = true, talent = true, race = "", require = SpellID,
--
DT.SpellDB = {
	DRUID = {
		{ name = "愤怒", { 1, 5176, 0, }, { 6, 5177, 100, }, { 14, 5178, 900, }, { 22, 5179, 3000, }, { 30, 5180, 6000, }, { 38, 6780, 12000, }, { 46, 8905, 20000, }, { 54, 9912, 28000, }, },
		{ name = "野性印记", { 1, 1126, 10, }, { 10, 5232, 300, }, { 20, 6756, 2000, }, { 30, 5234, 6000, }, { 40, 8907, 14000, }, { 50, 9884, 23000, }, { 60, 9885, 34000, }, },
		{ name = "治疗之触", { 1, 5185, 0, }, { 8, 5186, 200, }, { 14, 5187, 900, }, { 20, 5188, 2000, }, { 26, 5189, 4500, }, { 32, 6778, 8000, }, { 38, 8903, 12000, }, { 44, 9758, 18000, }, { 50, 9888, 23000, }, { 56, 9889, 30000, }, { 60, 25297, 0, 5, }, },
		{ name = "回春术", { 4, 774, 100, }, { 10, 1058, 300, }, { 16, 1430, 1800, }, { 22, 2090, 3000, }, { 28, 2091, 5000, }, { 34, 3627, 10000, }, { 40, 8910, 14000, }, { 46, 9839, 20000, }, { 52, 9840, 26000, }, { 58, 9841, 32000, }, { 60, 25299, 0, 5, }, },
		{ name = "月火术", { 4, 8921, 100, }, { 10, 8924, 300, }, { 16, 8925, 1800, }, { 22, 8926, 3000, }, { 28, 8927, 5000, }, { 34, 8928, 10000, }, { 40, 8929, 14000, }, { 46, 9833, 20000, }, { 52, 9834, 26000, }, { 58, 9835, 32000, }, },
		{ name = "荆棘术", { 6, 467, 100, }, { 14, 782, 900, }, { 24, 1075, 4000, }, { 34, 8914, 10000, }, { 44, 9756, 18000, }, { 54, 9910, 28000, }, },
		{ name = "纠缠根须", { 8, 339, 200, }, { 18, 1062, 1900, }, { 28, 5195, 5000, }, { 38, 5196, 12000, }, { 48, 9852, 22000, }, { 58, 9853, 32000, }, },
		{ name = "熊形态", { 10, 5487, 0, }, { 40, 9634, 14000, }, },
		{ name = "低吼", { 10, 6795, 0, }, },
		{ name = "传送：月光林地", { 10, 18960, 0, }, },
		{ name = "槌击", { 10, 6807, 0, }, { 18, 6808, 1900, }, { 26, 6809, 4500, }, { 34, 8972, 10000, }, { 42, 9745, 16000, }, { 50, 9880, 23000, }, { 58, 9881, 32000, }, },
		{ name = "挫志咆哮", { 10, 99, 300, }, { 20, 1735, 2000, }, { 32, 9490, 8000, }, { 42, 9747, 16000, }, { 52, 9898, 26000, }, },
		{ name = "愈合", { 12, 8936, 800, }, { 18, 8938, 1900, }, { 24, 8939, 4000, }, { 30, 8940, 6000, }, { 36, 8941, 11000, }, { 42, 9750, 16000, }, { 48, 9856, 22000, }, { 54, 9857, 28000, }, { 60, 9858, 34000, }, },
		{ name = "狂怒", { 12, 5229, 800, }, },
		{ name = "重击", { 14, 5211, 900, }, { 30, 6798, 6000, }, { 46, 8983, 20000, }, },
		{ name = "消毒术", { 14, 8946, 0, }, },
		{ name = "挥击", { 16, 779, 1800, }, { 24, 780, 4000, }, { 34, 769, 10000, }, { 44, 9754, 18000, }, { 54, 9908, 28000, }, },
		{ name = "水栖形态", { 16, 1066, 0, }, },
		{ name = "休眠", { 18, 2637, 1900, }, { 38, 18657, 12000, }, { 58, 18658, 32000, }, },
		{ name = "精灵之火", { 18, 770, 1900, }, { 30, 778, 6000, }, { 42, 9749, 16000, }, { 54, 9907, 28000, }, },
		{ name = "爪击", { 20, 1082, 2000, }, { 28, 3029, 5000, }, { 38, 5201, 12000, }, { 48, 9849, 22000, }, { 58, 9850, 32000, }, },
		{ name = "星火术", { 20, 2912, 2000, }, { 26, 8949, 4500, }, { 34, 8950, 10000, }, { 42, 8951, 16000, }, { 50, 9875, 23000, }, { 58, 9876, 32000, }, { 60, 25298, 0, 5, }, },
		{ name = "撕扯", { 20, 1079, 2000, }, { 28, 9492, 5000, }, { 36, 9493, 11000, }, { 44, 9752, 18000, }, { 52, 9894, 26000, }, { 60, 9896, 34000, }, },
		{ name = "复生", { 20, 20484, 2000, }, { 30, 20739, 6000, }, { 40, 20742, 14000, }, { 50, 20747, 23000, }, { 60, 20748, 34000, }, },
		{ name = "潜行", { 20, 5215, 2000, }, { 40, 6783, 14000, }, { 60, 9913, 34000, }, },
		{ name = "猎豹形态", { 20, 768, 2000, }, },
		{ name = "安抚动物", { 22, 2908, 3000, }, { 38, 8955, 12000, }, { 54, 9901, 28000, }, },
		{ name = "撕碎", { 22, 5221, 3000, }, { 30, 6800, 6000, }, { 38, 8992, 12000, }, { 46, 9829, 20000, }, { 54, 9830, 28000, }, },
		{ name = "扫击", { 24, 1822, 4000, }, { 34, 1823, 10000, }, { 44, 1824, 18000, }, { 54, 9904, 28000, }, },
		{ name = "解除诅咒", { 24, 2782, 4000, }, },
		{ name = "猛虎之怒", { 24, 5217, 4000, }, { 36, 6793, 11000, }, { 48, 9845, 22000, }, { 60, 9846, 34000, }, },
		{ name = "急奔", { 26, 1850, 4500, }, { 46, 9821, 20000, }, },
		{ name = "驱毒术", { 26, 2893, 4500, }, },
		{ name = "挑战咆哮", { 28, 5209, 5000, }, },
		{ name = "畏缩", { 28, 8998, 5000, }, { 40, 9000, 14000, }, { 52, 9892, 26000, }, },
		{ name = "旅行形态", { 30, 783, 6000, }, },
		{ name = "宁静", { 30, 740, 6000, }, { 40, 8918, 14000, }, { 50, 9862, 23000, }, { 60, 9863, 34000, }, },
		{ name = "凶猛撕咬", { 32, 22568, 8000, }, { 40, 22827, 14000, }, { 48, 22828, 22000, }, { 56, 22829, 30000, }, { 60, 31018, 0, }, },
		{ name = "毁灭", { 32, 6785, 8000, }, { 42, 6787, 16000, }, { 50, 9866, 23000, }, { 58, 9867, 32000, }, },
		{ name = "追踪人型生物", { 32, 5225, 8000, }, },
		{ name = "狂暴回复", { 36, 22842, 11000, }, { 46, 22895, 20000, }, { 56, 22896, 30000, }, },
		{ name = "突袭", { 36, 9005, 11000, }, { 46, 9823, 20000, }, { 56, 9827, 30000, }, },
		{ name = "飓风", { 40, 16914, 14000, }, { 50, 17401, 23000, }, { 60, 17402, 34000, }, },
		{ name = "豹之优雅", { 40, 20719, 14000, }, passive = true, },
		{ name = "激活", { 40, 29166, 14000, }, },
		{ name = "树皮术", { 44, 22812, 18000, }, },
		{ name = "野性赐福", { 50, 21849, 0, }, { 60, 21850, 0, }, },
		{ name = "自然之握", { -1, 16689, 0, }, { 18, 16810, 95, }, { 28, 16811, 250, }, { 38, 16812, 600, }, { 48, 16813, 1100, }, { 58, 17329, 1600, }, talent = true, },
		{ name = "清晰预兆", { -1, 16864, 0, }, talent = true, },
		{ name = "野性冲锋", { -1, 16979, 0, }, talent = true, },
		{ name = "虫群", { -1, 5570, 0, }, { 30, 24974, 300, }, { 40, 24975, 700, }, { 50, 24976, 1150, }, { 60, 24977, 1700, }, talent = true, },
		{ name = "自然之赐", { -1, 16880, 0, }, passive = true, talent = true, },
		{ name = "精灵之火（野性）", { -1, 16857, 0, }, { 30, 17390, 300, }, { 42, 17391, 800, }, { 54, 17392, 1400, }, talent = true, },
		{ name = "自然迅捷", { -1, 17116, 0, }, talent = true, },
		{ name = "枭兽形态", { -1, 24858, 0, }, talent = true, },
		{ name = "兽群领袖", { -1, 17007, 0, }, passive = true, talent = true, },
		{ name = "迅捷治愈", { -1, 18562, 0, }, talent = true, },
	},
	HUNTER = {
		{ name = "准备就绪", { 0, 23989, 0, }, },
		{ name = "自动射击", { 1, 75, 0, }, },
		{ name = "猛禽一击", { 1, 2973, 0, }, { 8, 14260, 200, }, { 16, 14261, 1800, }, { 24, 14262, 7000, }, { 32, 14263, 10000, }, { 40, 14264, 18000, }, { 48, 14265, 32000, }, { 56, 14266, 46000, }, },
		{ name = "追踪野兽", { 1, 1494, 10, }, },
		{ name = "灵猴守护", { 4, 13163, 100, }, },
		{ name = "毒蛇钉刺", { 4, 1978, 100, }, { 10, 13549, 400, }, { 18, 13550, 2000, }, { 26, 13551, 7000, }, { 34, 13552, 12000, }, { 42, 13553, 24000, }, { 50, 13554, 36000, }, { 58, 13555, 48000, }, { 60, 25295, 0, 5, }, },
		{ name = "奥术射击", { 6, 3044, 100, }, { 12, 14281, 600, }, { 20, 14282, 2200, }, { 28, 14283, 8000, }, { 36, 14284, 14000, }, { 44, 14285, 26000, }, { 52, 14286, 40000, }, { 60, 14287, 50000, }, },
		{ name = "猎人印记", { 6, 1130, 100, }, { 22, 14323, 6000, }, { 40, 14324, 18000, }, { 58, 14325, 48000, }, },
		{ name = "震荡射击", { 8, 5116, 200, }, },
		{ name = "招架", { 8, 3127, 200, }, passive = true, },
		{ name = "复活宠物", { 10, 982, 0, }, },
		{ name = "驯服野兽", { 10, 1515, 0, }, },
		{ name = "追踪人型生物", { 10, 19883, 400, }, },
		{ name = "喂养宠物", { 10, 6991, 0, }, },
		{ name = "雄鹰守护", { 10, 13165, 400, }, { 18, 14318, 2000, }, { 28, 14319, 8000, }, { 38, 14320, 16000, }, { 48, 14321, 32000, }, { 58, 14322, 48000, }, { 60, 25296, 0, 5, }, },
		{ name = "解散野兽", { 10, 2641, 0, }, },
		{ name = "召唤宠物", { 10, 883, 0, }, },
		{ name = "摔绊", { 12, 2974, 600, }, { 38, 14267, 16000, }, { 60, 14268, 50000, }, },
		{ name = "扰乱射击", { 12, 20736, 600, }, { 20, 14274, 2200, }, { 30, 15629, 8000, }, { 40, 15630, 18000, }, { 50, 15631, 36000, }, { 60, 15632, 50000, }, },
		{ name = "治疗宠物", { 12, 136, 600, }, { 20, 3111, 2200, }, { 28, 3661, 8000, }, { 36, 3662, 14000, }, { 44, 13542, 26000, }, { 52, 13543, 40000, }, { 60, 13544, 50000, }, },
		{ name = "野兽之眼", { 14, 1002, 1200, }, },
		{ name = "恐吓野兽", { 14, 1513, 1200, }, { 30, 14326, 8000, }, { 46, 14327, 28000, }, },
		{ name = "鹰眼术", { 14, 6197, 1200, }, },
		{ name = "猫鼬撕咬", { 16, 1495, 1800, }, { 30, 14269, 8000, }, { 44, 14270, 26000, }, { 58, 14271, 48000, }, },
		{ name = "献祭陷阱", { 16, 13795, 1800, }, { 26, 14302, 7000, }, { 36, 14303, 14000, }, { 46, 14304, 28000, }, { 56, 14305, 46000, }, },
		{ name = "追踪亡灵", { 18, 19884, 2000, }, },
		{ name = "多重射击", { 18, 2643, 2000, }, { 30, 14288, 8000, }, { 42, 14289, 24000, }, { 54, 14290, 42000, }, { 60, 25294, 0, 5, }, },
		{ name = "逃脱", { 20, 781, 2200, }, { 34, 14272, 12000, }, { 48, 14273, 32000, }, },
		{ name = "冰冻陷阱", { 20, 1499, 2200, }, { 40, 14310, 18000, }, { 60, 14311, 50000, }, },
		{ name = "猎豹守护", { 20, 5118, 2200, }, },
		{ name = "双武器", { 20, 674, 2200, }, passive = true, },
		{ name = "毒蝎钉刺", { 22, 3043, 6000, }, { 32, 14275, 10000, }, { 42, 14276, 24000, }, { 52, 14277, 40000, }, },
		{ name = "追踪隐藏生物", { 24, 19885, 7000, }, },
		{ name = "野兽知识", { 24, 1462, 7000, }, },
		{ name = "追踪元素生物", { 26, 19880, 7000, }, },
		{ name = "急速射击", { 26, 3045, 7000, }, },
		{ name = "冰霜陷阱", { 28, 13809, 8000, }, },
		{ name = "假死", { 30, 5384, 8000, }, },
		{ name = "野兽守护", { 30, 13161, 8000, }, },
		{ name = "追踪恶魔", { 32, 19878, 10000, }, },
		{ name = "照明弹", { 32, 1543, 10000, }, },
		{ name = "爆炸陷阱", { 34, 13813, 12000, }, { 44, 14316, 26000, }, { 54, 14317, 42000, }, },
		{ name = "蝰蛇钉刺", { 36, 3034, 14000, }, { 46, 14279, 28000, }, { 56, 14280, 46000, }, },
		{ name = "乱射", { 40, 1510, 18000, }, { 50, 14294, 36000, }, { 58, 14295, 48000, }, },
		{ name = "锁甲", { 40, 8737, 18000, }, passive = true, },
		{ name = "追踪巨人", { 40, 19882, 18000, }, },
		{ name = "豹群守护", { 40, 13159, 18000, }, },
		{ name = "野性守护", { 46, 20043, 28000, }, { 56, 20190, 46000, }, },
		{ name = "追踪龙类", { 50, 19879, 36000, }, },
		{ name = "宁神射击", { 60, 19801, 0, }, },
		{ name = "野兽迅捷", { -1, 19596, 0, }, passive = true, talent = true, },
		{ name = "瞄准射击", { -1, 19434, 0, }, { 28, 20900, 400, }, { 36, 20901, 700, }, { 44, 20902, 1300, }, { 52, 20903, 2000, }, { 60, 20904, 2500, }, talent = true, },
		{ name = "威慑", { -1, 19263, 0, }, talent = true, },
		{ name = "胁迫", { -1, 19577, 0, }, talent = true, },
		{ name = "驱散射击", { -1, 19503, 0, }, talent = true, },
		{ name = "反击", { -1, 19306, 0, }, { 42, 20909, 1200, }, { 54, 20910, 2100, }, talent = true, },
		{ name = "狂野怒火", { -1, 19574, 0, }, talent = true, },
		{ name = "强击光环", { -1, 19506, 0, }, { 50, 20905, 1800, }, { 60, 20906, 2500, }, talent = true, },
		{ name = "翼龙钉刺", { -1, 19386, 0, }, { 50, 24132, 1800, }, { 60, 24133, 2500, }, talent = true, },
	},
	MAGE = {
		{ name = "奥术智慧", { 1, 1459, 10, }, { 14, 1460, 900, }, { 28, 1461, 7000, }, { 42, 10156, 18000, }, { 56, 10157, 38000, }, },
		{ name = "火球术", { 1, 133, 0, }, { 6, 143, 100, }, { 12, 145, 600, }, { 18, 3140, 1800, }, { 24, 8400, 4000, }, { 30, 8401, 8000, }, { 36, 8402, 13000, }, { 42, 10148, 18000, }, { 48, 10149, 28000, }, { 54, 10150, 36000, }, { 60, 10151, 42000, }, { 60, 25306, 0, 5, }, },
		{ name = "霜甲术", { 1, 168, 0, }, { 10, 7300, 400, }, { 20, 7301, 2000, }, },
		{ name = "造水术", { 4, 5504, 100, }, { 10, 5505, 400, }, { 20, 5506, 2000, }, { 30, 6127, 8000, }, { 40, 10138, 15000, }, { 50, 10139, 32000, }, { 60, 10140, 0, }, },
		{ name = "寒冰箭", { 4, 116, 100, }, { 8, 205, 200, }, { 14, 837, 900, }, { 20, 7322, 2000, }, { 26, 8406, 5000, }, { 32, 8407, 10000, }, { 38, 8408, 14000, }, { 44, 10179, 23000, }, { 50, 10180, 32000, }, { 56, 10181, 38000, }, { 60, 25304, 0, 5, }, },
		{ name = "造食术", { 6, 587, 100, }, { 12, 597, 600, }, { 22, 990, 3000, }, { 32, 6129, 10000, }, { 42, 10144, 18000, }, { 52, 10145, 35000, }, { 60, 28612, 0, }, },
		{ name = "火焰冲击", { 6, 2136, 100, }, { 14, 2137, 900, }, { 22, 2138, 3000, }, { 30, 8412, 8000, }, { 38, 8413, 14000, }, { 46, 10197, 26000, }, { 54, 10199, 36000, }, },
		{ name = "奥术飞弹", { 8, 5143, 200, }, { 16, 5144, 1500, }, { 24, 5145, 4000, }, { 32, 8416, 10000, }, { 40, 8417, 15000, }, { 48, 10211, 28000, }, { 56, 10212, 38000, }, { 60, 25345, 0, 5, }, },
		{ name = "变形术", { 8, 118, 200, }, { 20, 12824, 2000, }, { 40, 12825, 15000, }, { 60, 12826, 42000, }, },
		{ name = "冰霜新星", { 10, 122, 400, }, { 26, 865, 5000, }, { 40, 6131, 15000, }, { 54, 10230, 36000, }, },
		{ name = "魔法抑制", { 12, 604, 600, }, { 24, 8450, 4000, }, { 36, 8451, 13000, }, { 48, 10173, 28000, }, { 60, 10174, 42000, }, },
		{ name = "缓落术", { 12, 130, 600, }, },
		{ name = "魔爆术", { 14, 1449, 900, }, { 22, 8437, 3000, }, { 30, 8438, 8000, }, { 38, 8439, 14000, }, { 46, 10201, 26000, }, { 54, 10202, 36000, }, },
		{ name = "侦测魔法", { 16, 2855, 1500, }, },
		{ name = "烈焰风暴", { 16, 2120, 1500, }, { 24, 2121, 4000, }, { 32, 8422, 10000, }, { 40, 8423, 15000, }, { 48, 10215, 28000, }, { 56, 10216, 38000, }, },
		{ name = "解除次级诅咒", { 18, 475, 1800, }, },
		{ name = "魔法增效", { 18, 1008, 1800, }, { 30, 8455, 8000, }, { 42, 10169, 18000, }, { 54, 10170, 36000, }, },
		{ name = "传送：幽暗城", { 20, 3563, 2000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "法力护盾", { 20, 1463, 2000, }, { 28, 8494, 7000, }, { 36, 8495, 13000, }, { 44, 10191, 23000, }, { 52, 10192, 35000, }, { 60, 10193, 42000, }, },
		{ name = "暴风雪", { 20, 10, 2000, }, { 28, 6141, 7000, }, { 36, 8427, 13000, }, { 44, 10185, 23000, }, { 52, 10186, 35000, }, { 60, 10187, 42000, }, },
		{ name = "防护火焰结界", { 20, 543, 2000, }, { 30, 8457, 8000, }, { 40, 8458, 15000, }, { 50, 10223, 32000, }, { 60, 10225, 42000, }, },
		{ name = "唤醒", { 20, 12051, 2000, }, },
		{ name = "传送：奥格瑞玛", { 20, 3567, 2000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "传送：暴风城", { 20, 3561, 2000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送：铁炉堡", { 20, 3562, 2000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "闪现术", { 20, 1953, 2000, }, },
		{ name = "防护冰霜结界", { 22, 6143, 3000, }, { 32, 8461, 10000, }, { 42, 8462, 18000, }, { 52, 10177, 35000, }, { 60, 28609, 0, }, },
		{ name = "灼烧", { 22, 2948, 3000, }, { 28, 8444, 7000, }, { 34, 8445, 12000, }, { 40, 8446, 15000, }, { 46, 10205, 26000, }, { 52, 10206, 35000, }, { 58, 10207, 40000, }, },
		{ name = "法术反制", { 24, 2139, 4000, }, },
		{ name = "冰锥术", { 26, 120, 5000, }, { 34, 8492, 12000, }, { 42, 10159, 18000, }, { 50, 10160, 32000, }, { 58, 10161, 40000, }, },
		{ name = "制造魔法玛瑙", { 28, 759, 7000, }, },
		{ name = "传送：雷霆崖", { 30, 3566, 8000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "传送：达纳苏斯", { 30, 3565, 8000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "冰甲术", { 30, 7302, 8000, }, { 40, 7320, 15000, }, { 50, 10219, 32000, }, { 60, 10220, 42000, }, },
		{ name = "魔甲术", { 34, 6117, 13000, }, { 46, 22782, 28000, }, { 58, 22783, 40000, }, },
		{ name = "制造魔法翡翠", { 38, 3552, 14000, }, },
		{ name = "传送门：暴风城", { 40, 10059, 15000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送门：幽暗城", { 40, 11418, 15000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "传送门：奥格瑞玛", { 40, 11417, 15000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "传送门：铁炉堡", { 40, 11416, 15000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "制造魔法黄水晶", { 48, 10053, 28000, }, },
		{ name = "传送门：达纳苏斯", { 50, 11419, 32000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送门：雷霆崖", { 50, 11420, 32000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "奥术光辉", { 56, 23028, 0, }, },
		{ name = "制造魔法红宝石", { 58, 10054, 40000, }, },
		{ name = "变形术", { 60, 28272, 0, }, },
		{ name = "变形术", { 60, 28271, 0, }, },
		{ name = "奥术充沛", { -1, 28574, 0, }, passive = true, talent = true, },
		{ name = "炎爆术", { -1, 11366, 0, }, { 24, 12505, 200, }, { 30, 12522, 400, }, { 36, 12523, 650, }, { 42, 12524, 900, }, { 48, 12525, 1400, }, { 54, 12526, 1800, }, { 60, 18809, 2100, }, talent = true, },
		{ name = "急速冷却", { -1, 12472, 0, }, talent = true, },
		{ name = "气定神闲", { -1, 12043, 0, }, talent = true, },
		{ name = "冲击波", { -1, 11113, 0, }, { 36, 13018, 650, }, { 44, 13019, 1150, }, { 52, 13020, 1750, }, { 60, 13021, 2100, }, talent = true, },
		{ name = "寒冰屏障", { -1, 11958, 0, }, talent = true, },
		{ name = "奥术强化", { -1, 12042, 0, }, talent = true, },
		{ name = "燃烧", { -1, 11129, 0, }, talent = true, },
		{ name = "寒冰护体", { -1, 11426, 0, }, { 46, 13031, 6500, }, { 52, 13032, 8750, }, { 58, 13033, 9000, }, talent = true, },
	},
	PALADIN = {
		{ name = "圣光术", { 1, 635, 0, }, { 6, 639, 100, }, { 14, 647, 2000, }, { 22, 1026, 4000, }, { 30, 1042, 11000, }, { 38, 3472, 16000, }, { 46, 10328, 24000, }, { 54, 10329, 40000, }, { 60, 25292, 0, 5, }, },
		{ name = "正义圣印", { 1, 21084, 0, }, { 10, 20287, 300, }, { 18, 20288, 3500, }, { 26, 20289, 6000, }, { 34, 20290, 13000, }, { 42, 20291, 21000, }, { 50, 20292, 28000, }, { 58, 20293, 44000, }, },
		{ name = "虔诚光环", { 1, 465, 10, }, { 10, 10290, 300, }, { 20, 643, 4000, }, { 30, 10291, 11000, }, { 40, 1032, 20000, }, { 50, 10292, 28000, }, { 60, 10293, 46000, }, },
		{ name = "力量祝福", { 4, 19740, 100, }, { 12, 19834, 1000, }, { 22, 19835, 4000, }, { 32, 19836, 12000, }, { 42, 19837, 21000, }, { 52, 19838, 34000, }, { 60, 25291, 0, 5, }, },
		{ name = "审判", { 4, 20271, 100, }, },
		{ name = "圣佑术", { 6, 498, 100, }, { 18, 5573, 3500, }, },
		{ name = "十字军圣印", { 6, 21082, 100, }, { 12, 20162, 1000, }, { 22, 20305, 4000, }, { 32, 20306, 12000, }, { 42, 20307, 21000, }, { 52, 20308, 34000, }, },
		{ name = "纯净术", { 8, 1152, 100, }, },
		{ name = "招架", { 8, 3127, 100, }, passive = true, },
		{ name = "制裁之锤", { 8, 853, 100, }, { 24, 5588, 5000, }, { 40, 5589, 20000, }, { 54, 10308, 40000, }, },
		{ name = "保护祝福", { 10, 1022, 300, }, { 24, 5599, 5000, }, { 38, 10278, 16000, }, },
		{ name = "圣疗术", { 10, 633, 300, }, { 30, 2800, 11000, }, { 50, 10310, 28000, }, },
		{ name = "救赎", { 12, 7328, 0, }, { 24, 10322, 5000, }, { 36, 10324, 14000, }, { 48, 20772, 26000, }, { 60, 20773, 46000, }, },
		{ name = "智慧祝福", { 14, 19742, 2000, }, { 24, 19850, 5000, }, { 34, 19852, 13000, }, { 44, 19853, 22000, }, { 54, 19854, 40000, }, { 60, 25290, 0, 5, }, },
		{ name = "惩罚光环", { 16, 7294, 3000, }, { 26, 10298, 6000, }, { 36, 10299, 14000, }, { 46, 10300, 24000, }, { 56, 10301, 42000, }, },
		{ name = "正义之怒", { 16, 25780, 3000, }, },
		{ name = "自由祝福", { 18, 1044, 3500, }, },
		{ name = "圣光闪现", { 20, 19750, 4000, }, { 26, 19939, 6000, }, { 34, 19940, 13000, }, { 42, 19941, 21000, }, { 50, 19942, 28000, }, { 58, 19943, 44000, }, },
		{ name = "感知亡灵", { 20, 5502, 0, }, },
		{ name = "驱邪术", { 20, 879, 4000, }, { 28, 5614, 9000, }, { 36, 5615, 14000, }, { 44, 10312, 22000, }, { 52, 10313, 34000, }, { 60, 10314, 46000, }, },
		{ name = "专注光环", { 22, 19746, 4000, }, },
		{ name = "公正圣印", { 22, 20164, 4000, }, },
		{ name = "超度亡灵", { 24, 2878, 5000, }, { 38, 5627, 16000, }, { 52, 10326, 34000, }, },
		{ name = "拯救祝福", { 26, 1038, 6000, }, },
		{ name = "暗影抗性光环", { 28, 19876, 9000, }, { 40, 19895, 20000, }, { 52, 19896, 34000, }, },
		{ name = "光明圣印", { 30, 20165, 11000, }, { 40, 20347, 20000, }, { 50, 20348, 28000, }, { 60, 20349, 46000, }, },
		{ name = "神圣干涉", { 30, 19752, 11000, }, },
		{ name = "冰霜抗性光环", { 32, 19888, 12000, }, { 44, 19897, 22000, }, { 56, 19898, 42000, }, },
		{ name = "圣盾术", { 34, 642, 13000, }, { 50, 1020, 28000, }, },
		{ name = "火焰抗性光环", { 36, 19891, 14000, }, { 48, 19899, 26000, }, { 60, 19900, 46000, }, },
		{ name = "智慧圣印", { 38, 20166, 16000, }, { 48, 20356, 26000, }, { 58, 20357, 44000, }, },
		{ name = "板甲", { 40, 750, 20000, }, passive = true, },
		{ name = "召唤军马", { 40, 13819, 0, }, },
		{ name = "光明祝福", { 40, 19977, 20000, }, { 50, 19978, 28000, }, { 60, 19979, 46000, }, },
		{ name = "清洁术", { 42, 4987, 21000, }, },
		{ name = "愤怒之锤", { 44, 24275, 22000, }, { 52, 24274, 34000, }, { 60, 24239, 46000, }, },
		{ name = "牺牲祝福", { 46, 6940, 24000, }, { 54, 20729, 40000, }, },
		{ name = "神圣愤怒", { 50, 2812, 28000, }, { 60, 10318, 46000, }, },
		{ name = "强效力量祝福", { 52, 25782, 46000, }, { 60, 25916, 46000, }, },
		{ name = "强效智慧祝福", { 54, 25894, 46000, }, { 60, 25918, 46000, }, },
		{ name = "召唤战马", { 60, 23214, 0, }, },
		{ name = "强效拯救祝福", { 60, 25895, 46000, }, },
		{ name = "强效光明祝福", { 60, 25890, 46000, }, },
		{ name = "奉献", { -1, 26573, 0, }, { 30, 20116, 200, }, { 40, 20922, 1000, }, { 50, 20923, 1400, }, { 60, 20924, 2300, }, talent = true, },
		{ name = "王者祝福", { -1, 20217, 0, }, talent = true, },
		{ name = "命令圣印", { -1, 20375, 0, }, { 30, 20915, 550, }, { 40, 20918, 1000, }, { 50, 20919, 1400, }, { 60, 20920, 2300, }, talent = true, },
		{ name = "神恩术", { -1, 20216, 0, }, talent = true, },
		{ name = "庇护祝福", { -1, 20911, 0, }, { 40, 20912, 1000, }, { 50, 20913, 1400, }, { 60, 20914, 2300, }, talent = true, },
		{ name = "圣洁光环", { -1, 20218, 0, }, talent = true, },
		{ name = "神圣震击", { -1, 20473, 0, }, { 48, 20929, 1170, }, { 56, 20930, 2100, }, talent = true, },
		{ name = "神圣之盾", { -1, 20925, 0, }, { 50, 20927, 1260, }, { 60, 20928, 2070, }, talent = true, },
		{ name = "忏悔", { -1, 20066, 0, }, talent = true, },
		{ name = "强效王者祝福", { 60, 25898, 2300 , }, talent = true, require = 20217, },
		{ name = "强效庇护祝福", { 60, 25899, 2300, }, talent = true, require = 20911, },
	},
	PRIEST = {
		{ name = "真言术：韧", { 1, 1243, 10, }, { 12, 1244, 800, }, { 24, 1245, 5000, }, { 36, 2791, 14000, }, { 48, 10937, 28000, }, { 60, 10938, 46000, }, },
		{ name = "惩击", { 1, 585, 0, }, { 6, 591, 100, }, { 14, 598, 1200, }, { 22, 984, 4000, }, { 30, 1004, 10000, }, { 38, 6060, 16000, }, { 46, 10933, 26000, }, { 54, 10934, 40000, }, },
		{ name = "次级治疗术", { 1, 2050, 0, }, { 4, 2052, 100, }, { 10, 2053, 300, }, },
		{ name = "暗言术：痛", { 4, 589, 100, }, { 10, 594, 300, }, { 18, 970, 2000, }, { 26, 992, 6000, }, { 34, 2767, 12000, }, { 42, 10892, 22000, }, { 50, 10893, 30000, }, { 58, 10894, 44000, }, },
		{ name = "真言术：盾", { 6, 17, 100, }, { 12, 592, 800, }, { 18, 600, 2000, }, { 24, 3747, 5000, }, { 30, 6065, 10000, }, { 36, 6066, 14000, }, { 42, 10898, 22000, }, { 48, 10899, 28000, }, { 54, 10900, 40000, }, { 60, 10901, 46000, }, },
		{ name = "渐隐术", { 8, 586, 200, }, { 20, 9578, 3000, }, { 30, 9579, 10000, }, { 40, 9592, 18000, }, { 50, 10941, 30000, }, { 60, 10942, 46000, }, },
		{ name = "恢复", { 8, 139, 200, }, { 14, 6074, 1200, }, { 20, 6075, 3000, }, { 26, 6076, 6000, }, { 32, 6077, 11000, }, { 38, 6078, 16000, }, { 44, 10927, 24000, }, { 50, 10928, 30000, }, { 56, 10929, 42000, }, { 60, 25315, 0, 5, }, },
		{ name = "绝望祷言", race = "HUMAN|DWARF", { 10, 13908, 0, }, { 18, 19236, 100, }, { 26, 19238, 300, }, { 34, 19240, 600, }, { 42, 19241, 1100, }, { 50, 19242, 1500, }, { 58, 19243, 2200, }, },
		{ name = "星辰碎片", race = "NIGHTELF", { 10, 10797, 0, }, { 18, 19296, 100, }, { 26, 19299, 300, }, { 34, 19302, 600, }, { 42, 19303, 1100, }, { 50, 19304, 1500, }, { 58, 19305, 2200, }, },
		{ name = "虚弱之触", race = "SCOURGE", { 10, 2652, 0, }, { 20, 19261, 150, }, { 30, 19262, 500, }, { 40, 19264, 900, }, { 50, 19265, 1500, }, { 60, 19266, 2300, }, },
		{ name = "虚弱妖术", race = "TROLL", { 10, 9035, 0, }, { 20, 19281, 150, }, { 30, 19282, 500, }, { 40, 19283, 900, }, { 50, 19284, 1500, }, { 60, 19285, 2300, }, },
		{ name = "复活术", { 10, 2006, 300, }, { 22, 2010, 4000, }, { 34, 10880, 12000, }, { 46, 10881, 26000, }, { 58, 20770, 44000, }, },
		{ name = "心灵震爆", { 10, 8092, 300, }, { 16, 8102, 1600, }, { 22, 8103, 4000, }, { 28, 8104, 8000, }, { 34, 8105, 12000, }, { 40, 8106, 18000, }, { 46, 10945, 26000, }, { 52, 10946, 38000, }, { 58, 10947, 44000, }, },
		{ name = "心灵之火", { 12, 588, 800, }, { 20, 7128, 3000, }, { 30, 602, 10000, }, { 40, 1006, 18000, }, { 50, 10951, 30000, }, { 60, 10952, 46000, }, },
		{ name = "心灵尖啸", { 14, 8122, 1200, }, { 28, 8124, 8000, }, { 42, 10888, 22000, }, { 56, 10890, 42000, }, },
		{ name = "祛病术", { 14, 528, 1200, }, },
		{ name = "治疗术", { 16, 2054, 1600, }, { 22, 2055, 4000, }, { 28, 6063, 8000, }, { 34, 6064, 12000, }, },
		{ name = "驱散魔法", { 18, 527, 2000, }, { 36, 988, 14000, }, },
		{ name = "回馈", race = "HUMAN", { 20, 13896, 0, }, { 30, 19271, 500, }, { 40, 19273, 900, }, { 50, 19274, 1500, }, { 60, 19275, 2300, }, },
		{ name = "防护恐惧结界", race = "DWARF", { 20, 6346, 0, }, },
		{ name = "艾露恩的赐福", race = "NIGHTELF", { 20, 2651, 0, }, { 30, 19289, 500, }, { 40, 19291, 900, }, { 50, 19292, 1500, }, { 60, 19293, 2300, }, },
		{ name = "噬灵瘟疫", race = "SCOURGE", { 20, 2944, 0, }, { 28, 19276, 400, }, { 36, 19277, 700, }, { 44, 19278, 1200, }, { 52, 19279, 1900, }, { 60, 19280, 2300, }, },
		{ name = "暗影守卫", race = "TROLL", { 20, 18137, 0, }, { 28, 19308, 400, }, { 36, 19309, 700, }, { 44, 19310, 1200, }, { 52, 19311, 1900, }, { 60, 19312, 2300, }, },
		{ name = "神圣之火", { 20, 14914, 3000, }, { 24, 15262, 5000, }, { 30, 15263, 10000, }, { 36, 15264, 14000, }, { 42, 15265, 22000, }, { 48, 15266, 28000, }, { 54, 15267, 40000, }, { 60, 15261, 46000, }, },
		{ name = "快速治疗", { 20, 2061, 3000, }, { 26, 9472, 6000, }, { 32, 9473, 11000, }, { 38, 9474, 16000, }, { 44, 10915, 24000, }, { 50, 10916, 30000, }, { 56, 10917, 42000, }, },
		{ name = "安抚心灵", { 20, 453, 3000, }, { 36, 8192, 14000, }, { 52, 10953, 38000, }, },
		{ name = "束缚亡灵", { 20, 9484, 3000, }, { 40, 9485, 18000, }, { 60, 10955, 46000, }, },
		{ name = "心灵视界", { 22, 2096, 4000, }, { 44, 10909, 24000, }, },
		{ name = "法力燃烧", { 24, 8129, 5000, }, { 32, 8131, 11000, }, { 40, 10874, 18000, }, { 48, 10875, 28000, }, { 56, 10876, 42000, }, },
		{ name = "治疗祷言", { 30, 596, 10000, }, { 40, 996, 18000, }, { 50, 10960, 30000, }, { 60, 10961, 46000, }, { 60, 25316, 0, 5, }, },
		{ name = "精神控制", { 30, 605, 10000, }, { 44, 10911, 24000, }, { 58, 10912, 44000, }, },
		{ name = "防护暗影", { 30, 976, 10000, }, { 42, 10957, 22000, }, { 56, 10958, 42000, }, },
		{ name = "驱除疾病", { 32, 552, 11000, }, },
		{ name = "漂浮术", { 34, 1706, 12000, }, },
		{ name = "强效治疗术", { 40, 2060, 18000, }, { 46, 10963, 26000, }, { 52, 10964, 38000, }, { 58, 10965, 44000, }, { 60, 25314, 0, 5, }, },
		{ name = "坚韧祷言", { 48, 21562, 0, }, { 60, 21564, 0, }, },
		{ name = "暗影防护祷言", { 56, 27683, 0, }, },
		{ name = "心灵专注", { -1, 14751, 0, }, talent = true, },
		{ name = "神圣新星", { -1, 15237, 0, }, { 28, 15430, 400, }, { 36, 15431, 700, }, { 44, 27799, 1200, }, { 52, 27800, 1900, }, { 60, 27801, 2300, }, talent = true, },
		{ name = "精神鞭笞", { -1, 15407, 0, }, { 28, 17311, 400, }, { 36, 17312, 700, }, { 44, 17313, 1200, }, { 52, 17314, 1900, }, { 60, 18807, 2300, }, talent = true, },
		{ name = "神圣之灵", { -1, 14752, 0, }, { 40, 14818, 900, }, { 50, 14819, 1500, }, { 60, 27841, 2300, }, talent = true, },
		{ name = "救赎之魂", { -1, 20711, 0, }, passive = true, talent = true, },
		{ name = "沉默", { -1, 15487, 0, }, talent = true, },
		{ name = "吸血鬼的拥抱", { -1, 15286, 0, }, talent = true, },
		{ name = "能量灌注", { -1, 10060, 0, }, talent = true, },
		{ name = "光明之泉", { -1, 724, 0, }, { 50, 27870, 1200, }, { 60, 27871, 1500, }, talent = true, },
		{ name = "暗影形态", { -1, 15473, 0, }, talent = true, },
		{ name = "精神祷言", { 60, 27681, 2300, }, talent = true, require = 14752, },
	},
	ROGUE = {
		{ name = "刺骨", { 1, 2098, 0, }, { 8, 6760, 200, }, { 16, 6761, 1800, }, { 24, 6762, 5000, }, { 32, 8623, 12000, }, { 40, 8624, 20000, }, { 48, 11299, 33000, }, { 56, 11300, 50000, }, { 60, 31016, 0, }, },
		{ name = "邪恶攻击", { 1, 1752, 0, }, { 6, 1757, 100, }, { 14, 1758, 1200, }, { 22, 1759, 4000, }, { 30, 1760, 10000, }, { 38, 8621, 18000, }, { 46, 11293, 31000, }, { 54, 11294, 48000, }, },
		{ name = "潜行", { 1, 1784, 10, }, { 20, 1785, 3000, }, { 40, 1786, 20000, }, { 60, 1787, 54000, }, },
		{ name = "搜索", { 4, 921, 100, }, },
		{ name = "背刺", { 4, 53, 100, }, { 12, 2589, 800, }, { 20, 2590, 3000, }, { 28, 2591, 8000, }, { 36, 8721, 16000, }, { 44, 11279, 29000, }, { 52, 11280, 46000, }, { 60, 11281, 54000, }, { 60, 25300, 0, 5, }, },
		{ name = "凿击", { 6, 1776, 100, }, { 18, 1777, 2900, }, { 32, 8629, 12000, }, { 46, 11285, 31000, }, { 60, 11286, 54000, }, },
		{ name = "闪避", { 8, 5277, 200, }, },
		{ name = "疾跑", { 10, 2983, 300, }, { 34, 8696, 14000, }, { 58, 11305, 52000, }, },
		{ name = "闷棍", { 10, 6770, 300, }, { 28, 2070, 8000, }, { 48, 11297, 33000, }, },
		{ name = "双武器", { 10, 674, 300, }, passive = true, },
		{ name = "切割", { 10, 5171, 300, }, { 42, 6774, 27000, }, },
		{ name = "脚踢", { 12, 1766, 800, }, { 26, 1767, 6000, }, { 42, 1768, 27000, }, { 58, 1769, 52000, }, },
		{ name = "招架", { 12, 3127, 800, }, passive = true, },
		{ name = "破甲", { 14, 8647, 1200, }, { 26, 8649, 6000, }, { 36, 8650, 16000, }, { 46, 11197, 31000, }, { 56, 11198, 50000, }, },
		{ name = "绞喉", { 14, 703, 1200, }, { 22, 8631, 4000, }, { 30, 8632, 10000, }, { 38, 8633, 18000, }, { 46, 11289, 31000, }, { 54, 11290, 48000, }, },
		{ name = "开锁", { 16, 1804, 1800, }, },
		{ name = "佯攻", { 16, 1966, 1800, }, { 28, 6768, 8000, }, { 40, 8637, 20000, }, { 52, 11303, 46000, }, { 60, 25302, 0, 5, }, },
		{ name = "伏击", { 18, 8676, 2900, }, { 26, 8724, 6000, }, { 34, 8725, 14000, }, { 42, 11267, 27000, }, { 50, 11268, 35000, }, { 58, 11269, 52000, }, },
		{ name = "速效毒药", { 20, 8681, 0, }, { 28, 8687, 8000, }, { 36, 8691, 16000, }, { 44, 11341, 29000, }, { 52, 11342, 46000, }, { 60, 11343, 54000, }, },
		{ name = "致残毒药", { 20, 3420, 3000, }, { 50, 3421, 35000, }, },
		{ name = "割裂", { 20, 1943, 3000, }, { 28, 8639, 8000, }, { 36, 8640, 16000, }, { 44, 11273, 29000, }, { 52, 11274, 46000, }, { 60, 11275, 54000, }, },
		{ name = "毒药", { 20, 2842, 0, }, },
		{ name = "扰乱", { 22, 1725, 4000, }, },
		{ name = "消失", { 22, 1856, 4000, }, { 42, 1857, 27000, }, },
		{ name = "麻痹毒药", { 24, 5763, 5000, }, { 38, 8694, 18000, }, { 52, 11400, 46000, }, },
		{ name = "侦测陷阱", { 24, 2836, 5000, }, passive = true, },
		{ name = "偷袭", { 26, 1833, 6000, }, },
		{ name = "解除陷阱", { 30, 1842, 10000, }, },
		{ name = "致命毒药", { 30, 2835, 10000, }, { 38, 2837, 18000, }, { 46, 11357, 31000, }, { 54, 11358, 48000, }, { 60, 25347, 0, 5, }, },
		{ name = "肾击", { 30, 408, 10000, }, { 50, 8643, 35000, }, },
		{ name = "致伤毒药", { 32, 13220, 12000, }, { 40, 13228, 20000, }, { 48, 13229, 33000, }, { 56, 13230, 50000, }, },
		{ name = "致盲粉", { 34, 6510, 14000, }, },
		{ name = "致盲", { 34, 2094, 14000, }, },
		{ name = "安全降落", { 40, 1860, 20000, }, passive = true, },
		{ name = "无情打击", { -1, 14179, 0, }, passive = true, talent = true, },
		{ name = "还击", { -1, 14251, 0, }, talent = true, },
		{ name = "鬼魅攻击", { -1, 14278, 0, }, talent = true, },
		{ name = "冷血", { -1, 14177, 0, }, talent = true, },
		{ name = "剑刃乱舞", { -1, 13877, 0, }, talent = true, },
		{ name = "伺机待发", { -1, 14185, 0, }, talent = true, },
		{ name = "出血", { -1, 16511, 0, }, { 46, 17347, 7750, }, { 58, 17348, 13000, }, talent = true, },
		{ name = "精力", { -1, 14983, 0, }, passive = true, talent = true, },
		{ name = "冲动", { -1, 13750, 0, }, talent = true, },
		{ name = "预谋", { -1, 14183, 0, }, talent = true, },
	},
	SHAMAN = {
		{ name = "闪电箭", { 1, 403, 0, }, { 8, 529, 100, }, { 14, 548, 900, }, { 20, 915, 2200, }, { 26, 943, 4000, }, { 32, 6041, 8000, }, { 38, 10391, 11000, }, { 44, 10392, 18000, }, { 50, 15207, 24000, }, { 56, 15208, 30000, }, },
		{ name = "石化武器", { 1, 8017, 10, }, { 8, 8018, 100, }, { 16, 8019, 1800, }, { 24, 10399, 3500, }, { 34, 16314, 9000, }, { 44, 16315, 18000, }, { 54, 16316, 29000, }, },
		{ name = "治疗波", { 1, 331, 0, }, { 6, 332, 100, }, { 12, 547, 800, }, { 18, 913, 2000, }, { 24, 939, 3500, }, { 32, 959, 8000, }, { 40, 8005, 12000, }, { 48, 10395, 22000, }, { 56, 10396, 30000, }, { 60, 25357, 0, 5, }, },
		{ name = "石肤图腾", { 4, 8071, 0, }, { 14, 8154, 900, }, { 24, 8155, 3500, }, { 34, 10406, 9000, }, { 44, 10407, 18000, }, { 54, 10408, 29000, }, },
		{ name = "地震术", { 4, 8042, 100, }, { 8, 8044, 100, }, { 14, 8045, 900, }, { 24, 8046, 3500, }, { 36, 10412, 10000, }, { 48, 10413, 22000, }, { 60, 10414, 34000, }, },
		{ name = "地缚图腾", { 6, 2484, 100, }, },
		{ name = "闪电之盾", { 8, 324, 100, }, { 16, 325, 1800, }, { 24, 905, 3500, }, { 32, 945, 8000, }, { 40, 8134, 12000, }, { 48, 10431, 22000, }, { 56, 10432, 30000, }, },
		{ name = "石爪图腾", { 8, 5730, 100, }, { 18, 6390, 2000, }, { 28, 6391, 6000, }, { 38, 6392, 11000, }, { 48, 10427, 22000, }, { 58, 10428, 32000, }, },
		{ name = "火舌武器", { 10, 8024, 400, }, { 18, 8027, 2000, }, { 26, 8030, 4000, }, { 36, 16339, 10000, }, { 46, 16341, 20000, }, { 56, 16342, 30000, }, },
		{ name = "大地之力图腾", { 10, 8075, 400, }, { 24, 8160, 3500, }, { 38, 8161, 11000, }, { 52, 10442, 27000, }, { 60, 25361, 0, 5, }, },
		{ name = "灼热图腾", { 10, 3599, 0, }, { 20, 6363, 2200, }, { 30, 6364, 7000, }, { 40, 6365, 12000, }, { 50, 10437, 24000, }, { 60, 10438, 34000, }, },
		{ name = "烈焰震击", { 10, 8050, 400, }, { 18, 8052, 2000, }, { 28, 8053, 6000, }, { 40, 10447, 12000, }, { 52, 10448, 27000, }, { 60, 29228, 0, }, },
		{ name = "净化术", { 12, 370, 800, }, { 32, 8012, 8000, }, },
		{ name = "火焰新星图腾", { 12, 1535, 800, }, { 22, 8498, 3000, }, { 32, 8499, 8000, }, { 42, 11314, 16000, }, { 52, 11315, 27000, }, },
		{ name = "先祖之魂", { 12, 2008, 800, }, { 24, 20609, 3500, }, { 36, 20610, 10000, }, { 48, 20776, 22000, }, { 60, 20777, 34000, }, },
		{ name = "消毒术", { 16, 526, 1800, }, },
		{ name = "战栗图腾", { 18, 8143, 2000, }, },
		{ name = "冰霜震击", { 20, 8056, 2200, }, { 34, 8058, 9000, }, { 46, 10472, 20000, }, { 58, 10473, 32000, }, },
		{ name = "幽魂之狼", { 20, 2645, 2200, }, },
		{ name = "冰封武器", { 20, 8033, 2200, }, { 28, 8038, 6000, }, { 38, 10456, 11000, }, { 48, 16355, 22000, }, { 58, 16356, 32000, }, },
		{ name = "次级治疗波", { 20, 8004, 2200, }, { 28, 8008, 6000, }, { 36, 8010, 10000, }, { 44, 10466, 18000, }, { 52, 10467, 27000, }, { 60, 10468, 34000, }, },
		{ name = "治疗之泉图腾", { 20, 5394, 0, }, { 30, 6375, 7000, }, { 40, 6377, 12000, }, { 50, 10462, 24000, }, { 60, 10463, 34000, }, },
		{ name = "祛病术", { 22, 2870, 3000, }, },
		{ name = "清毒图腾", { 22, 8166, 3000, }, },
		{ name = "水下呼吸", { 22, 131, 3000, }, },
		{ name = "抗寒图腾", { 24, 8181, 3500, }, { 38, 10478, 11000, }, { 54, 10479, 29000, }, },
		{ name = "视界术", { 26, 6196, 4000, }, },
		{ name = "熔岩图腾", { 26, 8190, 4000, }, { 36, 10585, 10000, }, { 46, 10586, 20000, }, { 56, 10587, 30000, }, },
		{ name = "法力之泉图腾", { 26, 5675, 4000, }, { 36, 10495, 10000, }, { 46, 10496, 20000, }, { 56, 10497, 30000, }, },
		{ name = "抗火图腾", { 28, 8184, 6000, }, { 42, 10537, 16000, }, { 58, 10538, 32000, }, },
		{ name = "水上行走", { 28, 546, 6000, }, },
		{ name = "火舌图腾", { 28, 8227, 6000, }, { 38, 8249, 11000, }, { 48, 10526, 22000, }, { 58, 16387, 32000, }, },
		{ name = "自然抗性图腾", { 30, 10595, 7000, }, { 44, 10600, 18000, }, { 60, 10601, 34000, }, },
		{ name = "风怒武器", { 30, 8232, 7000, }, { 40, 8235, 12000, }, { 50, 10486, 24000, }, { 60, 16362, 34000, }, },
		{ name = "根基图腾", { 30, 8177, 7000, }, },
		{ name = "复生", { 30, 20608, 7000, }, passive = true, },
		{ name = "星界传送", { 30, 556, 7000, }, },
		{ name = "闪电链", { 32, 421, 8000, }, { 40, 930, 12000, }, { 48, 2860, 22000, }, { 56, 10605, 30000, }, },
		{ name = "风怒图腾", { 32, 8512, 8000, }, { 42, 10613, 16000, }, { 52, 10614, 27000, }, },
		{ name = "岗哨图腾", { 34, 6495, 9000, }, },
		{ name = "风墙图腾", { 36, 15107, 10000, }, { 46, 15111, 20000, }, { 56, 15112, 30000, }, },
		{ name = "祛病图腾", { 38, 8170, 11000, }, },
		{ name = "锁甲", { 40, 8737, 12000, }, },
		{ name = "治疗链", { 40, 1064, 12000, }, { 46, 10622, 20000, }, { 54, 10623, 29000, }, },
		{ name = "风之优雅图腾", { 42, 8835, 16000, }, { 56, 10627, 30000, }, { 60, 25359, 0, 5, }, },
		{ name = "宁静之风图腾", { 50, 25908, 24000, }, },
		{ name = "元素集中", { -1, 16164, 0, }, passive = true, talent = true, },
		{ name = "双手斧和锤", { -1, 16269, 0, }, passive = true, talent = true, },
		{ name = "图腾掌握", { -1, 16189, 0, }, passive = true, talent = true, },
		{ name = "元素之怒", { -1, 16089, 0, }, passive = true, talent = true, },
		{ name = "招架", { -1, 16268, 0, }, passive = true, talent = true, },
		{ name = "自然迅捷", { -1, 16188, 0, }, talent = true, },
		{ name = "元素掌握", { -1, 16166, 0, }, talent = true, },
		{ name = "风暴打击", { -1, 17364, 0, }, talent = true, },
		{ name = "法力之潮图腾", { -1, 16190, 0, }, { 48, 17354, 55000, }, { 58, 17359, 80000, }, talent = true, },
	},
	WARLOCK = {
		{ name = "恶魔皮肤", { 1, 687, 0, }, { 10, 696, 300, }, },
		{ name = "献祭", { 1, 348, 10, }, { 10, 707, 300, }, { 20, 1094, 2000, }, { 30, 2941, 6000, }, { 40, 11665, 11000, }, { 50, 11667, 15000, }, { 60, 11668, 26000, }, { 60, 25309, 0, 5, }, },
		{ name = "暗影箭", { 1, 686, 0, }, { 6, 695, 100, }, { 12, 705, 600, }, { 20, 1088, 2000, }, { 28, 1106, 5000, }, { 36, 7641, 9000, }, { 44, 11659, 12000, }, { 52, 11660, 18000, }, { 60, 11661, 26000, }, { 60, 25307, 0, 5, }, },
		{ name = "召唤小鬼", { 1, 688, 0, }, },
		{ name = "虚弱诅咒", { 4, 702, 100, }, { 12, 1108, 600, }, { 22, 6205, 2500, }, { 32, 7646, 7000, }, { 42, 11707, 11000, }, { 52, 11708, 18000, }, },
		{ name = "腐蚀术", { 4, 172, 100, }, { 14, 6222, 900, }, { 24, 6223, 3000, }, { 34, 7648, 8000, }, { 44, 11671, 12000, }, { 54, 11672, 20000, }, { 60, 25311, 0, 5, }, },
		{ name = "生命分流", { 6, 1454, 100, }, { 16, 1455, 1200, }, { 26, 1456, 4000, }, { 36, 11687, 9000, }, { 46, 11688, 13000, }, { 56, 11689, 22000, }, },
		{ name = "痛苦诅咒", { 8, 980, 200, }, { 18, 1014, 1500, }, { 28, 6217, 5000, }, { 38, 11711, 10000, }, { 48, 11712, 14000, }, { 58, 11713, 24000, }, },
		{ name = "恐惧术", { 8, 5782, 200, }, { 32, 6213, 7000, }, { 56, 6215, 22000, }, },
		{ name = "制造治疗石", { 10, 6201, 300, }, { 22, 6202, 2500, }, { 34, 5699, 8000, }, { 46, 11729, 13000, }, { 58, 11730, 24000, }, },
		{ name = "召唤虚空行者", { 10, 697, 0, }, },
		{ name = "吸取灵魂", { 10, 1120, 300, }, { 24, 8288, 3000, }, { 38, 8289, 10000, }, { 52, 11675, 18000, }, },
		{ name = "生命通道", { 12, 755, 600, }, { 20, 3698, 2000, }, { 28, 3699, 5000, }, { 36, 3700, 9000, }, { 44, 11693, 12000, }, { 52, 11694, 18000, }, { 60, 11695, 26000, }, },
		{ name = "鲁莽诅咒", { 14, 704, 900, }, { 28, 7658, 5000, }, { 42, 7659, 11000, }, { 56, 11717, 22000, }, },
		{ name = "吸取生命", { 14, 689, 900, }, { 22, 699, 2500, }, { 30, 709, 6000, }, { 38, 7651, 10000, }, { 46, 11699, 13000, }, { 54, 11700, 20000, }, },
		{ name = "魔息术", { 16, 5697, 1200, }, },
		{ name = "灼热之痛", { 18, 5676, 1500, }, { 26, 17919, 4000, }, { 34, 17920, 8000, }, { 42, 17921, 11000, }, { 50, 17922, 15000, }, { 58, 17923, 24000, }, },
		{ name = "制造灵魂石", { 18, 693, 1500, }, { 30, 20752, 6000, }, { 40, 20755, 11000, }, { 50, 20756, 15000, }, { 60, 20757, 26000, }, },
		{ name = "召唤仪式", { 20, 698, 2000, }, },
		{ name = "魔甲术", { 20, 706, 2000, }, { 30, 1086, 6000, }, { 40, 11733, 11000, }, { 50, 11734, 15000, }, { 60, 11735, 26000, }, },
		{ name = "火焰之雨", { 20, 5740, 2000, }, { 34, 6219, 8000, }, { 46, 11677, 13000, }, { 58, 11678, 24000, }, },
		{ name = "召唤魅魔", { 20, 712, 0, }, },
		{ name = "召唤夜魔", { 20, 713, 0, }, },
		{ name = "基尔罗格之眼", { 22, 126, 2500, }, },
		{ name = "感知恶魔", { 24, 5500, 3000, }, },
		{ name = "吸取法力", { 24, 5138, 3000, }, { 34, 6226, 8000, }, { 44, 11703, 12000, }, { 54, 11704, 20000, }, },
		{ name = "侦测隐形", { 26, 132, 4000, }, { 38, 2970, 10000, }, { 50, 11743, 15000, }, },
		{ name = "语言诅咒", { 26, 1714, 4000, }, { 50, 11719, 15000, }, },
		{ name = "放逐术", { 28, 710, 5000, }, { 48, 18647, 14000, }, },
		{ name = "制造火焰石", { 28, 6366, 5000, }, { 36, 17951, 9000, }, { 46, 17952, 13000, }, { 56, 17953, 22000, }, },
		{ name = "奴役恶魔", { 30, 1098, 6000, }, { 44, 11725, 12000, }, { 58, 11726, 24000, }, },
		{ name = "召唤地狱猎犬", { 30, 691, 0, }, },
		{ name = "地狱烈焰", { 30, 1949, 6000, }, { 42, 11683, 11000, }, { 54, 11684, 20000, }, },
		{ name = "防护暗影结界", { 32, 6229, 7000, }, { 42, 11739, 11000, }, { 52, 11740, 18000, }, { 60, 28610, 0, }, },
		{ name = "元素诅咒", { 32, 1490, 7000, }, { 46, 11721, 13000, }, { 60, 11722, 26000, }, },
		{ name = "制造法术石", { 36, 2362, 9000, }, { 48, 17727, 14000, }, { 60, 17728, 26000, }, },
		{ name = "恐惧嚎叫", { 40, 5484, 11000, }, { 54, 17928, 20000, }, },
		{ name = "召唤地狱战马", { 40, 5784, 0, }, },
		{ name = "死亡缠绕", { 42, 6789, 11000, }, { 50, 17925, 15000, }, { 58, 17926, 24000, }, },
		{ name = "暗影诅咒", { 44, 17862, 12000, }, { 56, 17937, 22000, }, },
		{ name = "灵魂之火", { 48, 6353, 14000, }, { 56, 17924, 22000, }, },
		{ name = "地狱火", { 50, 1122, 0, }, },
		{ name = "末日仪式", { 60, 18540, 0, }, },
		{ name = "厄运诅咒", { 60, 603, 26000, }, },
		{ name = "召唤恐惧战马", { 60, 23161, 0, }, },
		{ name = "诅咒增幅", { -1, 18288, 0, }, talent = true, },
		{ name = "恶魔支配", { -1, 18708, 0, }, talent = true, },
		{ name = "暗影灼烧", { -1, 17877, 0, }, { 24, 18867, 150, }, { 32, 18868, 350, }, { 40, 18869, 550, }, { 48, 18870, 700, }, { 56, 18871, 22000, }, talent = true, },
		{ name = "生命虹吸", { -1, 18265, 0, }, { 38, 18879, 500, }, { 48, 18880, 700, }, { 58, 18881, 1200, }, talent = true, },
		{ name = "疲劳诅咒", { -1, 18223, 0, }, talent = true, },
		{ name = "恶魔牺牲", { -1, 18788, 0, }, talent = true, },
		{ name = "毁灭", { -1, 17959, 0, }, passive = true, talent = true, },
		{ name = "黑暗契约", { -1, 18220, 0, }, { 50, 18937, 750, }, { 60, 18938, 1300, }, talent = true, },
		{ name = "灵魂链接", { -1, 19028, 0, }, talent = true, },
		{ name = "燃烧", { -1, 17962, 0, }, { 48, 18930, 700, }, { 54, 18931, 1000, }, { 60, 18932, 1300, }, talent = true, },
	},
	WARRIOR = {
		{ name = "英勇打击", { 1, 78, 0, }, { 8, 284, 200, }, { 16, 285, 2000, }, { 24, 1608, 8000, }, { 32, 11564, 14000, }, { 40, 11565, 22000, }, { 48, 11566, 40000, }, { 56, 11567, 58000, }, { 60, 25286, 0, 5, }, },
		{ name = "战斗姿态", { 1, 2457, 0, }, },
		{ name = "战斗怒吼", { 1, 6673, 10, }, { 12, 5242, 1000, }, { 22, 6192, 6000, }, { 32, 11549, 14000, }, { 42, 11550, 32000, }, { 52, 11551, 54000, }, { 60, 25289, 0, 5, }, },
		{ name = "冲锋", { 4, 100, 100, }, { 26, 6178, 10000, }, { 46, 11578, 36000, }, },
		{ name = "撕裂", { 4, 772, 100, }, { 10, 6546, 600, }, { 20, 6547, 4000, }, { 30, 6548, 12000, }, { 40, 11572, 22000, }, { 50, 11573, 42000, }, { 60, 11574, 62000, }, },
		{ name = "雷霆一击", { 6, 6343, 100, }, { 18, 8198, 3000, }, { 28, 8204, 11000, }, { 38, 8205, 20000, }, { 48, 11580, 40000, }, { 58, 11581, 60000, }, },
		{ name = "招架", { 6, 3127, 100, }, passive = true, },
		{ name = "断筋", { 8, 1715, 200, }, { 32, 7372, 14000, }, { 54, 7373, 56000, }, },
		{ name = "嘲讽", { 10, 355, 0, }, },
		{ name = "破甲攻击", { 10, 7386, 0, }, { 22, 7405, 6000, }, { 34, 8380, 16000, }, { 46, 11596, 36000, }, { 58, 11597, 60000, }, },
		{ name = "防御姿态", { 10, 71, 0, }, },
		{ name = "血性狂暴", { 10, 2687, 600, }, },
		{ name = "压制", { 12, 7384, 1000, }, { 28, 7887, 11000, }, { 44, 11584, 34000, }, { 60, 11585, 62000, }, },
		{ name = "盾击", { 12, 72, 1000, }, { 32, 1671, 14000, }, { 52, 1672, 54000, }, },
		{ name = "挫志怒吼", { 14, 1160, 1500, }, { 24, 6190, 8000, }, { 34, 11554, 16000, }, { 44, 11555, 34000, }, { 54, 11556, 56000, }, },
		{ name = "复仇", { 14, 6572, 1500, }, { 24, 6574, 8000, }, { 34, 7379, 16000, }, { 44, 11600, 34000, }, { 54, 11601, 56000, }, { 60, 25288, 0, 5, }, },
		{ name = "盾牌格挡", { 16, 2565, 2000, }, },
		{ name = "惩戒痛击", { 16, 694, 2000, }, { 26, 7400, 10000, }, { 36, 7402, 18000, }, { 46, 20559, 36000, }, { 56, 20560, 58000, }, },
		{ name = "缴械", { 18, 676, 3000, }, },
		{ name = "双武器", { 20, 674, 4000, }, passive = true, },
		{ name = "反击风暴", { 20, 20230, 4000, }, },
		{ name = "顺劈斩", { 20, 845, 4000, }, { 30, 7369, 12000, }, { 40, 11608, 22000, }, { 50, 11609, 42000, }, { 60, 20569, 62000, }, },
		{ name = "破胆怒吼", { 22, 5246, 6000, }, },
		{ name = "斩杀", { 24, 5308, 8000, }, { 32, 20658, 14000, }, { 40, 20660, 22000, }, { 48, 20661, 40000, }, { 56, 20662, 58000, }, },
		{ name = "挑战怒吼", { 26, 1161, 10000, }, },
		{ name = "盾墙", { 28, 871, 11000, }, },
		{ name = "拦截", { 30, 20252, 0, }, { 42, 20616, 32000, }, { 52, 20617, 54000, }, },
		{ name = "猛击", { 30, 1464, 12000, }, { 38, 8820, 20000, }, { 46, 11604, 36000, }, { 54, 11605, 56000, }, },
		{ name = "狂暴姿态", { 30, 2458, 0, }, },
		{ name = "狂暴之怒", { 32, 18499, 14000, }, },
		{ name = "旋风斩", { 36, 1680, 18000, }, },
		{ name = "拳击", { 38, 6552, 20000, }, { 58, 6554, 60000, }, },
		{ name = "板甲", { 40, 750, 22000, }, passive = true, },
		{ name = "鲁莽", { 50, 1719, 42000, }, },
		{ name = "愤怒掌控", { -1, 12296, 0, }, passive = true, talent = true, },
		{ name = "刺耳怒吼", { -1, 12323, 0, }, talent = true, },
		{ name = "破釜沉舟", { -1, 12975, 0, }, talent = true, },
		{ name = "横扫攻击", { -1, 12292, 0, }, talent = true, },
		{ name = "死亡之愿", { -1, 12328, 0, }, talent = true, },
		{ name = "震荡猛击", { -1, 12809, 0, }, talent = true, },
		{ name = "嗜血", { -1, 23881, 0, }, { 48, 23892, 2000, }, { 54, 23893, 2800, }, { 60, 23894, 3100, }, talent = true, },
		{ name = "致死打击", { -1, 12294, 0, }, { 48, 21551, 200, }, { 54, 21552, 2800, }, { 60, 21553, 3100, }, talent = true, },
		{ name = "盾牌猛击", { -1, 23922, 0, }, { 48, 23923, 200, }, { 54, 23924, 2800, }, { 60, 23925, 3100, }, talent = true, },
	},
};

DT.TalentSpecIcon = {
	[41] = "Interface\\Icons\\spell_fire_firebolt02",
	[61] = "Interface\\Icons\\spell_frost_frostbolt02",
	[81] = "Interface\\Icons\\inv_misc_rune_03",
	[161] = "Interface\\Icons\\ability_rogue_eviscerate",--
	[163] = "Interface\\Icons\\ability_warrior_defensivestance",
	[164] = "Interface\\Icons\\ability_warrior_innerrage",
	[181] = "Interface\\Icons\\ability_backstab",
	[182] = "Interface\\Icons\\ability_rogue_eviscerate",--
	[183] = "Interface\\Icons\\Ability_Ambush",
	[201] = "Interface\\Icons\\spell_holy_wordfortitude",
	[202] = "Interface\\Icons\\spell_holy_holybolt",
	[203] = "Interface\\Icons\\spell_shadow_shadowwordpain",
	[261] = "Interface\\Icons\\spell_nature_lightning",
	[262] = "Interface\\Icons\\Spell_Nature_HealingWaveGreater",
	[263] = "Interface\\Icons\\spell_nature_lightningshield",
	[281] = "Interface\\Icons\\ability_racial_bearform",
	[282] = "Interface\\Icons\\Spell_Nature_HealingTouch",
	[283] = "Interface\\Icons\\spell_nature_starfall",
	[301] = "Interface\\Icons\\spell_shadow_rainoffire",
	[302] = "Interface\\Icons\\spell_shadow_deathcoil",
	[303] = "Interface\\Icons\\spell_shadow_metamorphosis",
	[361] = "Interface\\Icons\\Ability_Hunter_BeastTaming",
	[362] = "Interface\\Icons\\Ability_Hunter_SwiftStrike",
	[363] = "Interface\\Icons\\Ability_Marksmanship",
	[381] = "Interface\\Icons\\Spell_Holy_AuraOfLight",
	[382] = "Interface\\Icons\\Spell_Holy_HolyBolt",
	[383] = "Interface\\Icons\\Spell_Holy_DevotionAura",

	[398] = "Interface\\Icons\\Spell_Deathknight_BloodPresence",
	[399] = "Interface\\Icons\\Spell_Deathknight_FrostPresence",
	[400] = "Interface\\Icons\\Spell_Deathknight_UnholyPresence",
	[409] = "Interface\\Icons\\Ability_Hunter_Pet_Bear",
	[410] = "Interface\\Icons\\Ability_Druid_Swipe",
	[411] = "Interface\\Icons\\Ability_Hunter_CombatExperience",
};

DT.ClassBackground = {
	DEATHKNIGHT = {
		"Interface\\TalentFrame\\bg-deathknight-blood",
		"Interface\\TalentFrame\\bg-deathknight-frost",
		"Interface\\TalentFrame\\bg-deathknight-unholy",
	},
	DRUID = {
		"Interface\\TalentFrame\\bg-druid-balance",
		"Interface\\TalentFrame\\bg-druid-bear",
		"Interface\\TalentFrame\\bg-druid-cat",
		"Interface\\TalentFrame\\bg-druid-restoration",
	},
	HUNTER = {
		"Interface\\TalentFrame\\bg-hunter-beastmaster",
		"Interface\\TalentFrame\\bg-hunter-marksman",
		"Interface\\TalentFrame\\bg-hunter-survival",
	},
	MAGE = {
		"Interface\\TalentFrame\\bg-mage-arcane",
		"Interface\\TalentFrame\\bg-mage-fire",
		"Interface\\TalentFrame\\bg-mage-frost",
	},
	MONK = {
		"Interface\\TalentFrame\\bg-monk-battledancer",
		"Interface\\TalentFrame\\bg-monk-brewmaster",
		"Interface\\TalentFrame\\bg-monk-mistweaver",
	},
	PALADIN = {
		"Interface\\TalentFrame\\bg-paladin-holy",
		"Interface\\TalentFrame\\bg-paladin-protection",
		"Interface\\TalentFrame\\bg-paladin-retribution",
	},
	PRIEST = {
		"Interface\\TalentFrame\\bg-priest-discipline",
		"Interface\\TalentFrame\\bg-priest-holy",
		"Interface\\TalentFrame\\bg-priest-shadow",
	},
	ROGUE = {
		"Interface\\TalentFrame\\bg-rogue-assassination",
		"Interface\\TalentFrame\\bg-rogue-combat",
		"Interface\\TalentFrame\\bg-rogue-subtlety",
	},
	SHAMAN = {
		"Interface\\TalentFrame\\bg-shaman-elemental",
		"Interface\\TalentFrame\\bg-shaman-enhancement",
		"Interface\\TalentFrame\\bg-shaman-restoration",
	},
	WARLOCK = {
		"Interface\\TalentFrame\\bg-warlock-affliction",
		"Interface\\TalentFrame\\bg-warlock-demonology",
		"Interface\\TalentFrame\\bg-warlock-destruction",
	},
	WARRIOR = {
		"Interface\\TalentFrame\\bg-warrior-arms",
		"Interface\\TalentFrame\\bg-warrior-fury",
		"Interface\\TalentFrame\\bg-warrior-protection",
	},
};

DT.SpecBackground = {
		[283] = "Interface\\TalentFrame\\DruidBalance-TopLeft",
		[281] = "Interface\\TalentFrame\\DruidFeralCombat-TopLeft",
		[282] = "Interface\\TalentFrame\\DruidRestoration-TopLeft",
		[361] = "Interface\\TalentFrame\\HunterBeastMastery-TopLeft",
		[363] = "Interface\\TalentFrame\\HunterMarksmanship-TopLeft",
		[362] = "Interface\\TalentFrame\\HunterSurvival-TopLeft",
		[81] = "Interface\\TalentFrame\\MageArcane-TopLeft",
		[41] = "Interface\\TalentFrame\\MageFire-TopLeft",
		[61] = "Interface\\TalentFrame\\MageFrost-TopLeft",
		[382] = "Interface\\TalentFrame\\PaladinHoly-TopLeft",
		[383] = "Interface\\TalentFrame\\PaladinProtection-TopLeft",
		[381] = "Interface\\TalentFrame\\PaladinCombat-TopLeft",
		[201] = "Interface\\TalentFrame\\PriestDiscipline-TopLeft",
		[202] = "Interface\\TalentFrame\\PriestHoly-TopLeft",
		[203] = "Interface\\TalentFrame\\PriestShadow-TopLeft",
		[182] = "Interface\\TalentFrame\\RogueAssassination-TopLeft",
		[181] = "Interface\\TalentFrame\\RogueCombat-TopLeft",
		[183] = "Interface\\TalentFrame\\RogueSubtlety-TopLeft",
		[261] = "Interface\\TalentFrame\\ShamanElementalCombat-TopLeft",
		[263] = "Interface\\TalentFrame\\ShamanEnhancement-TopLeft",
		[262] = "Interface\\TalentFrame\\ShamanRestoration-TopLeft",
		[302] = "Interface\\TalentFrame\\WarlockCurses-TopLeft",
		[303] = "Interface\\TalentFrame\\WarlockSummoning-TopLeft",
		[301] = "Interface\\TalentFrame\\WarlockDestruction-TopLeft",
		[161] = "Interface\\TalentFrame\\WarriorArms-TopLeft",
		[164] = "Interface\\TalentFrame\\WarriorFury-TopLeft",
		[163] = "Interface\\TalentFrame\\WarriorProtection-TopLeft",
};

DT.PresetTalents = {
	DRUID = {
		H = {
			E = {
				"https://classic.wowhead.com/talent-calc/druid/5140000302--505203105315051",
				"https://classic.wowhead.com/talent-calc/druid/51000533120013--505103105115",
				"https://classic.wowhead.com/talent-calc/druid/4140050312001--50510310501504",
				"https://classic.wowhead.com/talent-calc/druid/-503050130302215-05501310501",
			},
			P = {
				"https://classic.wowhead.com/talent-calc/druid/0140002-5002321-055103105315011",
				"https://classic.wowhead.com/talent-calc/druid/-500242130320215-05501310231",
			},
		},
		D = {
			E = {
				"https://classic.wowhead.com/talent-calc/druid/0142503002551351--5005031",
				"https://classic.wowhead.com/talent-calc/druid/510050300250135--50502310131",
				"https://classic.wowhead.com/talent-calc/druid/014005301-5500021323202151-05",
			},
			P = {
				"https://classic.wowhead.com/talent-calc/druid/0143503002551351--5005021",
			},
		},
		T = {
			E = {
				"https://classic.wowhead.com/talent-calc/druid/014005001-5050501303022151-05002",
				"https://classic.wowhead.com/talent-calc/druid/014005001-5050301323222151-05",
			},
		},
	},
	HUNTER = {
		D = {
			E = {
				"https://classic.wowhead.com/talent-calc/hunter/2-05251030513051-33202004103",
				"https://classic.wowhead.com/talent-calc/hunter/55000000505-05251030513051",
				"https://classic.wowhead.com/talent-calc/hunter/-05151030501-332020251030315",
			},
			P = {
				"https://classic.wowhead.com/talent-calc/hunter/-5105103051-005025051030315",
				"https://classic.wowhead.com/talent-calc/hunter/5300020150501-51051030513-005",
			},
		}
	},
	MAGE = {
		D = {
			E = {
				"https://classic.wowhead.com/talent-calc/mage/2300450310031531--053500030013",
				"https://classic.wowhead.com/talent-calc/mage/230045200003--05350013122301051",
				"https://classic.wowhead.com/talent-calc/mage/230025-5052023123033151-003",
			},
			P = {
				"https://classic.wowhead.com/talent-calc/mage/20500520102--05053232112051301",
				"https://classic.wowhead.com/talent-calc/mage/-05520201230031-050132301120513",
			},
		},
	},
	PALADIN = {
		H = {
			E = {
				"https://classic.wowhead.com/talent-calc/paladin/05503122521351-503201-5",
				"https://classic.wowhead.com/talent-calc/paladin/05503122521051-50325100003",
				"https://classic.wowhead.com/talent-calc/paladin/0550312152105-503251000131",
			},
			P = {
				"https://classic.wowhead.com/talent-calc/paladin/05503122521051-5032510003",
				"https://classic.wowhead.com/talent-calc/paladin/05503122521051-5002-05205",
			},
		},
		D = {
			E = {
				"https://classic.wowhead.com/talent-calc/paladin/505001-503-542300512003151",
				"https://classic.wowhead.com/talent-calc/paladin/5550010002--552300512003151",
				"https://classic.wowhead.com/talent-calc/paladin/52-503201-552300512003151",
			},
			P = {
				"https://classic.wowhead.com/talent-calc/paladin/505-5032-542000512203151",
				"https://classic.wowhead.com/talent-calc/paladin/1-5032510013005-5420005122031",
			},
		},
		T = {
			E = {
				"https://classic.wowhead.com/talent-calc/paladin/050501-553050335001001-05004",
			},
		},
	},
	PRIEST = {
		H = {
			E = {
				"https://classic.wowhead.com/talent-calc/priest/5012301305001-025051031300055",
				"https://classic.wowhead.com/talent-calc/priest/505230130505101-0250510313",
			},
			P = {
				"https://classic.wowhead.com/talent-calc/priest/500232130515051-2150511003",
				"https://classic.wowhead.com/talent-calc/priest/500232133101-225051132300105",
			},
		},
		D = {
			E = {
				"https://classic.wowhead.com/talent-calc/priest/0512301305--5032500103501051",
				"https://classic.wowhead.com/talent-calc/priest/50520013--5032504103501051",
			},
			P = {
				"https://classic.wowhead.com/talent-calc/priest/5002321--0502525103511251",
				"https://classic.wowhead.com/talent-calc/priest/500232132025151-00545100202",
			},
		},
	},
	ROGUE = {
		D = {
			E = {
				"https://classic.wowhead.com/talent-calc/rogue/005323105-3210052020050150231",
				"https://classic.wowhead.com/talent-calc/rogue/00532310505105-320305002001-05",
			},
			P = {
				"https://classic.wowhead.com/talent-calc/rogue/305320115001-3-500253000332121",
				"https://classic.wowhead.com/talent-calc/rogue/005320105-320302002-05024303030012",
			},
		},
	},
	SHAMAN = {
		H = {
			E = {
				"https://classic.wowhead.com/talent-calc/shaman/-5-552350510553151",
				"https://classic.wowhead.com/talent-calc/shaman/-5120202-550300510553151",
			},
			P = {
				"https://classic.wowhead.com/talent-calc/shaman/5003215013001--05033301015315",
				"https://classic.wowhead.com/talent-calc/shaman/5003-05002-05035351005315",
			},
		},
		D = {
			E = {
				"https://classic.wowhead.com/talent-calc/shaman/550331050002151--05204301005",
				"https://classic.wowhead.com/talent-calc/shaman/-5025002105023051-0510530105",
			},
			P = {
				"https://classic.wowhead.com/talent-calc/shaman/55000135030215--0523031100501",
				"https://classic.wowhead.com/talent-calc/shaman/05023140003-5015202105023151",
			},
		},
	},
	WARLOCK = {
		D = {
			E = {
				"https://classic.wowhead.com/talent-calc/warlock/25002-2050300142301-52500051020001",
				"https://classic.wowhead.com/talent-calc/warlock/5530203012201105--50502051020001",
				"https://classic.wowhead.com/talent-calc/warlock/01-234035010250004-50502051020001",
			},
			P = {
				"https://classic.wowhead.com/talent-calc/warlock/35000232122-2050310152501051",
				"https://classic.wowhead.com/talent-calc/warlock/35-2050310152501051-50500011",
				"https://classic.wowhead.com/talent-calc/warlock/3500023212201135--50520051020001",
				"https://classic.wowhead.com/talent-calc/warlock/35000231122-001-5052005102005141",
			},
		},
	},
	WARRIOR = {
		D = {
			E = {
				"https://classic.wowhead.com/talent-calc/warrior/20305011302-05050005525010051",
				"https://classic.wowhead.com/talent-calc/warrior/20305011322-05050005005510051",
				"https://classic.wowhead.com/talent-calc/warrior/20305011332-05052005025010051",
			},
			P = {
				"https://classic.wowhead.com/talent-calc/warrior/023050213320105031-55000131005",

			},
		},
		T = {
			E = {
				"https://classic.wowhead.com/talent-calc/warrior/05005001-05-50250113530211051",
				"https://classic.wowhead.com/talent-calc/warrior/-05050105125010051-5023011053",
			},
		},
	},
};

DT.LevelAvailablePointsTable = {  };
for i = 1, 9 do DT.LevelAvailablePointsTable[i] = 0; end
for i = 10, DT.MAX_LEVEL do DT.LevelAvailablePointsTable[i] = i - 9; end

DT.LevelAvailablePointsTableClass = {  };

DT.ItemLevelColor = {
	step = {
		0,	--	灰色
		0,	--	白色
		48,	--	绿色
		60,	--	蓝色
		63,	--	紫色
		84,	--	橙色
	},
	list = {
		{ 0.5, 0.5, 0.5, },	--	灰色
		{ 1.0, 1.0, 1.0, },	--	白色
		{ 0.0, 1.0, 0.0, },	--	绿色
		{ 0.0, 0.5, 1.0, },	--	蓝色
		{ 0.6, 0.2, 1.0, },	--	紫色
		{ 1.0, 0.5, 0.0, },	--	橙色
	},
};

--	enchantID, spellID, itemID, classID, subClassMask, invTypeMask
local RawEnchantDB = {
	{ 15, 2831, 2304, 4, 30, 1050016, },
	{ 16, 2832, 2313, 4, 30, 1050016, },
	{ 17, 2833, 4265, 4, 30, 1050016, },
	{ 18, 10344, 8173, 4, 30, 1050016, },
	{ 24, 7443, nil, 4, 31, 1048608, },
	{ 30, 3974, 4405, 2, 262156, nil, },
	{ 32, 3975, 4406, 2, 262156, nil, },
	{ 33, 3976, 4407, 2, 262156, nil, },
	{ 34, 7218, 6043, 2, 354, nil, },
	{ 36, 6296, 5421, 2, 189939, nil, },
	{ 37, 7220, 6041, 2, 173555, nil, },
	{ 41, 7418, nil, 4, 31, 512, },
	{ 41, 7420, nil, 4, 31, 1048608, },
	{ 43, 7216, 6042, 4, 96, nil, },
	{ 44, 7426, nil, 4, 31, 1048608, },
	{ 63, 13538, nil, 4, 31, 1048608, },
	{ 65, 7454, nil, 4, 31, 65536, },
	{ 66, 7457, nil, 4, 31, 512, },
	{ 66, 7863, nil, 4, 31, 256, },
	{ 66, 13378, nil, 4, 64, nil, },
	{ 241, 7745, nil, 2, 1378, nil, },
	{ 241, 13503, nil, 2, 189939, nil, },
	{ 242, 7748, nil, 4, 31, 1048608, },
	{ 243, 7766, nil, 4, 31, 512, },
	{ 246, 7776, nil, 4, 31, 1048608, },
	{ 247, 7779, nil, 4, 31, 512, },
	{ 247, 7867, nil, 4, 31, 256, },
	{ 247, 13419, nil, 2, nil, 65536, },
	{ 248, 7782, nil, 4, 31, 512, },
	{ 249, 7786, nil, 2, 189939, nil, },
	{ 250, 7788, nil, 2, 189939, nil, },
	{ 254, 7857, nil, 4, 31, 1048608, },
	{ 255, 7859, nil, 4, 31, 512, },
	{ 255, 13380, nil, 2, 1378, nil, },
	{ 255, 13485, nil, 4, nil, 16384, },
	{ 255, 13687, nil, 4, 30, 256, },
	{ 256, 7861, nil, 4, 31, 65536, },
	{ 463, 9781, 7967, 4, 96, nil, },
	{ 464, 9783, 7969, 4, nil, 256, },
	{ 663, 12459, 10546, 2, 262156, nil, },
	{ 664, 12460, 10548, 2, 262156, nil, },
	{ 723, 7793, nil, 2, 1378, nil, },
	{ 723, 13622, nil, 4, 31, 512, },
	{ 724, 13501, nil, 4, 31, 512, },
	{ 724, 13631, nil, 4, 64, nil, },
	{ 724, 13644, nil, 4, 30, 256, },
	{ 744, 13421, nil, 4, nil, 65536, },
	{ 783, 7771, nil, 4, 31, 65536, },
	{ 803, 13898, nil, 2, 189939, nil, },
	{ 804, 13522, nil, 4, 31, 65536, },
	{ 805, 13943, nil, 2, 189939, nil, },
	{ 823, 13536, nil, 4, 31, 512, },
	{ 843, 13607, nil, 4, 31, 1048608, },
	{ 844, 13612, nil, 4, 31, 1024, },
	{ 845, 13617, nil, 4, 31, 1024, },
	{ 846, 13620, nil, 4, 31, 1024, },
	{ 847, 13626, nil, 4, 31, 1048608, },
	{ 848, 13464, nil, 4, nil, 16384, },
	{ 848, 13635, nil, 4, 30, 65536, },
	{ 849, 13637, nil, 4, 31, 256, },
	{ 849, 13882, nil, 4, 30, 65536, },
	{ 850, 13640, nil, 4, 30, 1048608, },
	{ 851, 13642, nil, 4, 30, 512, },
	{ 851, 13659, nil, 4, 64, nil, },
	{ 851, 20024, nil, 4, 30, 256, },
	{ 852, 13648, nil, 4, 30, 512, },
	{ 852, 13817, nil, 4, 64, nil, },
	{ 852, 13836, nil, 4, 30, 256, },
	{ 853, 13653, nil, 2, 189939, nil, },
	{ 854, 13655, nil, 2, 189939, nil, },
	{ 856, 13661, nil, 4, 30, 512, },
	{ 856, 13887, nil, 4, 31, 1024, },
	{ 857, 13663, nil, 4, 30, 1048608, },
	{ 863, 13689, nil, 4, 64, nil, },
	{ 865, 13698, nil, 4, 31, 1024, },
	{ 866, 13700, nil, 4, 31, 1048608, },
	{ 884, 13746, nil, 4, 30, 65536, },
	{ 903, 13794, nil, 4, 30, 65536, },
	{ 904, 13815, nil, 4, 31, 1024, },
	{ 904, 13935, nil, 4, 30, 256, },
	{ 905, 13822, nil, 4, 30, 512, },
	{ 906, 13841, nil, 4, 31, 1024, },
	{ 907, 13846, nil, 4, 30, 512, },
	{ 907, 13905, nil, 4, 64, nil, },
	{ 908, 13858, nil, 4, 31, 1048608, },
	{ 909, 13868, nil, 4, 31, 1024, },
	{ 910, 25083, nil, 4, 31, 65536, },
	{ 911, 13890, nil, 4, 30, 256, },
	{ 912, 13915, nil, 2, 189939, nil, },
	{ 913, 13917, nil, 4, 31, 1048608, },
	{ 923, 13931, nil, 4, 30, 512, },
	{ 924, 7428, nil, 4, 31, 512, },
	{ 924, 398538, nil, 4, 31, 512, },
	{ 925, 13646, nil, 4, 30, 512, },
	{ 926, 13933, nil, 4, 64, nil, },
	{ 927, 13939, nil, 4, 30, 512, },
	{ 927, 20013, nil, 4, 31, 1024, },
	{ 928, 13941, nil, 4, 31, 1048608, },
	{ 929, 13945, nil, 4, 30, 512, },
	{ 929, 20017, nil, 4, 64, nil, },
	{ 929, 20020, nil, 4, 30, 256, },
	{ 930, 13947, nil, 4, 31, 1024, },
	{ 931, 13948, nil, 4, 31, 1024, },
	{ 943, 13529, nil, 2, 1378, nil, },
	{ 943, 13693, nil, 2, 189939, nil, },
	{ 963, 13937, nil, 2, 1378, nil, },
	{ 1483, 15340, 11622, 4, 30, 130, },
	{ 1503, 15389, 11642, 4, 30, 130, },
	{ 1504, 15391, 11643, 4, 30, 130, },
	{ 1505, 15394, 11644, 4, 30, 130, },
	{ 1506, 15397, 11645, 4, 30, 130, },
	{ 1507, 15400, 11646, 4, 30, 130, },
	{ 1508, 15402, 11647, 4, 30, 130, },
	{ 1509, 15404, 11648, 4, 30, 130, },
	{ 1510, 15406, 11649, 4, 30, 130, },
	{ 1704, 16623, 12645, 4, 96, nil, },
	{ 1843, 19057, 15564, 4, 30, 1050016, },
	{ 1883, 20008, nil, 4, 30, 512, },
	{ 1884, 20009, nil, 4, 30, 512, },
	{ 1885, 20010, nil, 4, 30, 512, },
	{ 1886, 20011, nil, 4, 30, 512, },
	{ 1887, 20012, nil, 4, 31, 1024, },
	{ 1887, 20023, nil, 4, 30, 256, },
	{ 1888, 20014, nil, 4, 30, 65536, },
	{ 1889, 20015, nil, 4, 30, 65536, },
	{ 1890, 20016, nil, 4, 64, nil, },
	{ 1891, 20025, nil, 4, 31, 1048608, },
	{ 1892, 20026, nil, 4, 31, 1048608, },
	{ 1893, 20028, nil, 4, 31, 1048608, },
	{ 1894, 20029, nil, 2, 189939, nil, },
	{ 1896, 20030, nil, 2, 1378, nil, },
	{ 1897, 13695, nil, 2, 1378, nil, },
	{ 1897, 20031, nil, 2, 189939, nil, },
	{ 1898, 20032, nil, 2, 189939, nil, },
	{ 1899, 20033, nil, 2, 189939, nil, },
	{ 1900, 20034, nil, 2, 189939, nil, },
	{ 1903, 20035, nil, 2, 1378, nil, },
	{ 1904, 20036, nil, 2, 1378, nil, },
	{ 2443, 21931, nil, 2, 196083, nil, },
	{ 2463, 13657, nil, 4, 30, 65536, },
	{ 2483, 22593, 18169, 4, 30, 8, },
	{ 2484, 22594, 18170, 4, 30, 8, },
	{ 2485, 22598, 18171, 4, 30, 8, },
	{ 2486, 22597, 18172, 4, 30, 8, },
	{ 2487, 22596, 18173, 4, 30, 8, },
	{ 2488, 22599, 18182, 4, 30, 8, },
	{ 2503, 22725, 18251, 4, 30, 1050016, },
	{ 2504, 22749, nil, 2, 58867, nil, },
	{ 2505, 22750, nil, 2, 58867, nil, },
	{ 2523, 22779, 18283, 2, 262156, nil, },
	{ 2543, 22840, 18329, 4, 31, 130, },
	{ 2544, 22844, 18330, 4, 31, 130, },
	{ 2545, 22846, 18331, 4, 31, 130, },
	{ 2563, 23799, nil, 2, 58867, nil, },
	{ 2564, 23800, nil, 2, 58867, nil, },
	{ 2564, 25080, nil, 4, 31, 1024, },
	{ 2565, 23801, nil, 4, 30, 512, },
	{ 2566, 23802, nil, 4, 30, 512, },
	{ 2567, 23803, nil, 2, 58867, nil, },
	{ 2568, 23804, nil, 2, 58867, nil, },
	{ 2583, 24149, 19782, 4, 31, 130, },
	{ 2584, 24160, 19783, 4, 31, 130, },
	{ 2585, 24161, 19784, 4, 31, 130, },
	{ 2586, 24162, 19785, 4, 31, 130, },
	{ 2587, 24163, 19786, 4, 31, 130, },
	{ 2588, 24164, 19787, 4, 31, 130, },
	{ 2589, 24165, 19788, 4, 31, 130, },
	{ 2590, 24167, 19789, 4, 31, 130, },
	{ 2591, 24168, 19790, 4, 31, 130, },
	{ 2603, 24302, 19971, 2, 1048576, nil, },
	{ 2604, 24420, 20078, 4, 30, 8, },
	{ 2605, 24421, 20076, 4, 30, 8, },
	{ 2606, 24422, 20077, 4, 30, 8, },
	{ 2613, 25072, nil, 4, 31, 1024, },
	{ 2614, 25073, nil, 4, 31, 1024, },
	{ 2615, 25074, nil, 4, 31, 1024, },
	{ 2616, 25078, nil, 4, 31, 1024, },
	{ 2617, 25079, nil, 4, 31, 1024, },
	{ 2619, 25081, nil, 4, 31, 65536, },
	{ 2620, 25082, nil, 4, 31, 65536, },
	{ 2621, 25084, nil, 4, 31, 65536, },
	{ 2622, 25086, nil, 4, 31, 65536, },
	{ 2646, 27837, nil, 2, 1378, nil, },
	{ 2681, 28161, 22635, 4, 31, 130, },
	{ 2682, 28163, 22636, 4, 31, 130, },
	{ 2683, 28165, 22638, 4, 31, 130, },
	{ 2715, 29475, 23547, 4, 30, 8, },
	{ 2716, 29480, 23549, 4, 30, 8, },
	{ 2717, 29483, 23548, 4, 30, 8, },
	{ 2721, 29467, 23545, 4, 30, 8, },
	{ 7123, 432139, nil, 4, 30, 8, },
	{ 7124, 432190, 212568, 4, 6, 2, },
	{ 7210, 435481, nil, 2, 189939, nil, },
	{ 7223, 435903, nil, 4, 31, 1048608, },
	{ 7325, 446459, 221322, 4, 30, 8, },
	{ 7326, 446472, 221323, 4, 30, 8, },
	{ 7328, 446451, 221321, 4, 30, 8, },
	{ 7563, 460963, 227819, 4, 30, 8, },
	{ 7564, 461129, 227926, 4, 31, 65536, },
	{ 7603, 463871, nil, 4, 64, nil, },
	{ 7613, 468314, 231354, 4, 31, 130, },
	{ 7614, 468318, 231355, 4, 31, 130, },
	{ 7615, 468321, 231357, 4, 31, 130, },
	{ 7616, 468323, 231358, 4, 31, 130, },
	{ 7617, 468325, 231359, 4, 31, 130, },
	{ 7618, 468328, 231361, 4, 31, 130, },
	{ 7619, 468330, 231362, 4, 31, 130, },
	{ 7620, 468332, 231363, 4, 31, 130, },
	{ 7621, 468339, 231364, 4, 31, 130, },
	{ 7622, 468342, 231366, 4, 31, 130, },
	{ 7623, 468344, 231367, 4, 31, 130, },
	{ 7624, 468347, 231368, 4, 31, 130, },
	{ 7625, 468349, 231370, 4, 31, 130, },
	{ 7626, 468351, 231371, 4, 31, 130, },
	{ 7627, 468354, 231372, 4, 31, 130, },
	{ 7628, 468359, 231373, 4, 31, 130, },
	{ 7629, 468362, 231375, 4, 31, 130, },
	{ 7630, 468365, 231376, 4, 31, 130, },
	{ 7631, 468368, 231377, 4, 31, 130, },
	{ 7632, 468373, 231379, 4, 31, 130, },
	{ 7633, 468376, 231381, 4, 31, 130, },
	{ 7634, 468380, 231383, 4, 31, 130, },
	{ 7635, 468383, 231384, 4, 31, 130, },
	{ 7645, 1213616, nil, 4, 31, 1048608, },
	{ 7646, 1213622, nil, 4, 31, 1024, },
	{ 7647, 1213626, nil, 4, 31, 1024, },
	{ 7648, 1213829, 233802, 4, 30, 1050016, },
	{ 7649, 1213833, 233803, 4, 30, 1050016, },
	{ 7655, 1217189, 235526, 4, 30, 512, },
	{ 7656, 1217203, 235528, 4, 30, 512, },
	{ 7657, 1217206, 235529, 2, 262156, nil, },
	{ 7659, 1219577, nil, 4, nil, 8388608, },
	{ 7660, 1219578, nil, 4, nil, 8388608, },
	{ 7661, 1219579, nil, 4, nil, 8388608, },
	{ 7662, 1219580, nil, 2, 1378, nil, },
	{ 7663, 1219581, nil, 4, nil, 16384, },
	{ 7664, 1220623, nil, 4, nil, 16384, },
	{ 7665, 1220624, nil, 4, nil, 512, },
	{ 7666, 1219586, nil, 4, nil, 1024, },
	{ 7667, 1219587, nil, 4, nil, 65536, },
	{ 7882, 1219507, 236323, 4, 30, 8, },
	{ 7883, 1219510, 236324, 4, 30, 8, },
	{ 7884, 1219512, 236326, 4, 30, 8, },
	{ 7885, 1219511, 236325, 4, 30, 8, },
	{ 7919, 1226210, 238786, 4, 30, 64, },
	{ 7920, 1226211, 238787, 4, nil, 64, },
	{ 7921, 1226212, 238788, 4, nil, 64, },
	{ 7940, 1231128, 241191, 2, 189939, nil, },
	{ 7941, 1231139, 241195, 2, 1378, nil, },
	{ 7942, 1231164, 241201, 2, 189939, nil, },
	{ 7943, 1232172, 242361, 2, 189939, nil, },
	{ 7944, 1235011, 243198, 2, 262156, nil, },
	{ 8057, 1237064, 244353, 2, 262156, nil, },
};
--	[classID][enchantID] = { subClassMask, invTypeMask, spellID, itemID, }
local EnchantDB = {  };
for _, info in next, RawEnchantDB do
	local classID = info[4];
	if classID then
		local TO = EnchantDB[classID];
		if TO == nil then
			TO = {  };
			EnchantDB[classID] = TO;
		end
		local enchantID = info[1];
		local to = TO[enchantID];
		if to == nil then
			to = {  };
			TO[enchantID] = to;
		end
		to[#to + 1] = { info[5], info[6], info[2], info[3], };
	end
end
DT.EnchantDB = EnchantDB;
DT.EnchantableByLoc = {
	INVTYPE_HEAD = 1,
	INVTYPE_SHOULDER = 1,
	INVTYPE_CHEST = 1,
	INVTYPE_LEGS = 1,
	INVTYPE_FEET = 1,
	INVTYPE_WRIST = 1,
	INVTYPE_HAND = 1,
	INVTYPE_CLOAK = 1,
	INVTYPE_WEAPON = 1,
	INVTYPE_2HWEAPON = 1,
	INVTYPE_SHIELD = 1,
	INVTYPE_RANGED = 1,
	INVTYPE_ROBE = 1,
	INVTYPE_WEAPONMAINHAND = 1,
	INVTYPE_WEAPONOFFHAND = 1,
	INVTYPE_RANGEDRIGHT = 1,
};
local EnumItemClass = Enum and Enum.ItemClass or {
	Weapon = 2,
};
local EnumWSubClass = Enum and Enum.ItemWeaponSubclass or {
	Axe1H = 0,
	Axe2H = 1,
	Bows = 2,
	Guns = 3,
	Mace1H = 4,
	Mace2H = 5,
	Polearm = 6,
	Sword1H = 7,
	Sword2H = 8,
	Warglaive = 9,
	Staff = 10,
	Bearclaw = 11,
	Catclaw = 12,
	Unarmed = 13,
	Generic = 14,
	Dagger = 15,
	Thrown = 16,
	Obsolete3 = 17,
	Crossbow = 18,
	Wand = 19,
	Fishingpole = 20,
};
DT.UnenchantableByType = {
	[EnumItemClass.Weapon] = {
		[EnumWSubClass.Generic] = 1,
		[EnumWSubClass.Thrown] = 1,
		[EnumWSubClass.Wand] = 1,
		[EnumWSubClass.Fishingpole] = 1,
		[EnumWSubClass.Bows] = 'HUNTER',
		[EnumWSubClass.Guns] = 'HUNTER',
		[EnumWSubClass.Crossbow] = 'HUNTER',
	},
};

DT.ItemSet = {
	[1] = { 11729, 11726, 11728, 11731, 11730, },
	[41] = { 12940, 12939, },
	[65] = { 13218, 13183, },
	[81] = { 13390, 13388, 13391, 13392, 13389, },
	[121] = { 14637, 14636, 14640, 14638, 14641, },
	[122] = { 14631, 14629, 14632, 14633, 14626, },
	[123] = { 14614, 14616, 14615, 14611, 14612, },
	[124] = { 14624, 14622, 14620, 14623, 14621, },
	[141] = { 15053, 15054, 15055, },
	[142] = { 15056, 15057, 15058, 21278, },
	[143] = { 15062, 15063, },
	[144] = { 15066, 15067, },
	[161] = { 10399, 10403, 10402, 10401, 10400, },
	[162] = { 10412, 10411, 10413, 10410, 6473, },
	[163] = { 10329, 10332, 10328, 10331, 10330, 10333, },
	[181] = { 16685, 16683, 16686, 16684, 16687, 16689, 16688, 16682, },
	[182] = { 16696, 16691, 16697, 16693, 16692, 16695, 16694, 16690, },
	[183] = { 16702, 16703, 16699, 16701, 16700, 16704, 16698, 16705, },
	[184] = { 16713, 16711, 16710, 16721, 16708, 16709, 16712, 16707, },
	[185] = { 16716, 16715, 16714, 16720, 16706, 16718, 16719, 16717, },
	[186] = { 16680, 16675, 16681, 16677, 16674, 16678, 16679, 16676, },
	[187] = { 16673, 16670, 16671, 16667, 16672, 16668, 16669, 16666, },
	[188] = { 16723, 16725, 16722, 16726, 16724, 16728, 16729, 16727, },
	[189] = { 16736, 16734, 16735, 16730, 16737, 16731, 16732, 16733, },
	[201] = { 16802, 16799, 16795, 16800, 16801, 16796, 16797, 16798, },
	[202] = { 16811, 16813, 16817, 16812, 16814, 16816, 16815, 16819, },
	[203] = { 16806, 16804, 16805, 16810, 16809, 16807, 16808, 16803, },
	[204] = { 16827, 16824, 16825, 16820, 16821, 16826, 16822, 16823, },
	[205] = { 16828, 16829, 16830, 16833, 16831, 16834, 16835, 16836, },
	[206] = { 16851, 16849, 16850, 16845, 16848, 16852, 16846, 16847, },
	[207] = { 16838, 16837, 16840, 16841, 16844, 16839, 16842, 16843, },
	[208] = { 16858, 16859, 16857, 16853, 16860, 16854, 16855, 16856, },
	[209] = { 16864, 16861, 16865, 16863, 16866, 16867, 16868, 16862, },
	[210] = { 16818, 16918, 16912, 16914, 16917, 16913, 16915, 16916, },
	[211] = { 16925, 16926, 16919, 16921, 16920, 16922, 16924, 16923, },
	[212] = { 16933, 16927, 16934, 16928, 16930, 16931, 16929, 16932, },
	[213] = { 16910, 16906, 16911, 16905, 16907, 16908, 16909, 16832, },
	[214] = { 16903, 16898, 16904, 16897, 16900, 16899, 16901, 16902, },
	[215] = { 16936, 16935, 16942, 16940, 16941, 16939, 16938, 16937, },
	[216] = { 16944, 16943, 16950, 16945, 16948, 16949, 16947, 16946, },
	[217] = { 16952, 16951, 16958, 16955, 16956, 16954, 16957, 16953, },
	[218] = { 16959, 16966, 16964, 16963, 16962, 16961, 16965, 16960, },
	[221] = { 7950, 7948, 7952, 7951, 7953, 7949, },
	[241] = { 17082, 17064, },
	[261] = { 18203, 18202, 18204, 18205, },
	[281] = { 16509, 16510, 16513, 16515, 16514, 16516, },
	[282] = { 16405, 16406, 16430, 16431, 16429, 16432, },
	[301] = { 16519, 16518, 16522, 16523, 16521, 16524, },
	[321] = { 12424, 12426, 12425, 12422, 12427, 12429, 12428, },
	[341] = { 16485, 16487, 16491, 16490, 16489, 16492, },
	[342] = { 17616, 17617, 17612, 17611, 17613, 17610, },
	[343] = { 16369, 16391, 16413, 16414, 16416, 16415, },
	[344] = { 17594, 17596, 17600, 17599, 17598, 17601, },
	[345] = { 17576, 17577, 17572, 17571, 17570, 17573, },
	[346] = { 17562, 17564, 17568, 17567, 17569, 17566, },
	[347] = { 16498, 16499, 16505, 16508, 16506, 16507, },
	[348] = { 16392, 16396, 16417, 16419, 16420, 16418, },
	[361] = { 16531, 16530, 16525, 16527, 16526, 16528, },
	[362] = { 16425, 16426, 16401, 16403, 16428, 16427, },
	[381] = { 16423, 16424, 16422, 16421, 16393, 16397, },
	[382] = { 16494, 16496, 16504, 16502, 16503, 16501, },
	[383] = { 16541, 16542, 16544, 16545, 16548, 16543, },
	[384] = { 16477, 16478, 16480, 16483, 16484, 16479, },
	[386] = { 16577, 16578, 16580, 16573, 16574, 16579, },
	[387] = { 16536, 16533, 16535, 16539, 16540, 16534, },
	[388] = { 16441, 16444, 16443, 16437, 16440, 16442, },
	[389] = { 17604, 17603, 17605, 17608, 17607, 17602, },
	[390] = { 17623, 17625, 17622, 17624, 17618, 17620, },
	[391] = { 17586, 17588, 17593, 17591, 17590, 17592, },
	[392] = { 17581, 17580, 17583, 17584, 17579, 17578, },
	[393] = { 16563, 16561, 16562, 16564, 16560, 16558, },
	[394] = { 16453, 16457, 16455, 16446, 16454, 16456, },
	[395] = { 16466, 16465, 16468, 16462, 16463, 16467, },
	[396] = { 16569, 16571, 16567, 16565, 16566, 16568, },
	[397] = { 16452, 16451, 16449, 16459, 16448, 16450, },
	[398] = { 16554, 16555, 16552, 16551, 16549, 16550, },
	[401] = { 16410, 16409, 16433, 16435, 16434, 16436, },
	[402] = { 16473, 16474, 16476, 16472, 16471, 16475, },
	[421] = { 19682, 19683, 19684, },
	[441] = { 19685, 19687, 19686, },
	[442] = { 19688, 19689, },
	[443] = { 19690, 19691, 19692, },
	[444] = { 19693, 19694, 19695, },
	[461] = { 19865, 19866, },
	[462] = { 19905, 19893, },
	[463] = { 19896, 19910, },
	[464] = { 19873, 19912, },
	[465] = { 19863, 19920, },
	[466] = { 19898, 19925, },
	[467] = { 20041, 20048, 20057, },
	[468] = { 20042, 20049, 20058, },
	[469] = { 20043, 20050, 20055, },
	[470] = { 20044, 20051, 20056, },
	[471] = { 20052, 20045, 20059, },
	[472] = { 20053, 20046, 20060, },
	[473] = { 20054, 20047, 20061, },
	[474] = { 19951, 19577, 19824, 19823, 19822, },
	[475] = { 19952, 19588, 19827, 19826, 19825, },
	[476] = { 19609, 19956, 19830, 19829, 19828, },
	[477] = { 19621, 19953, 19833, 19832, 19831, },
	[478] = { 19617, 19954, 19836, 19835, 19834, },
	[479] = { 19613, 19955, 19840, 19839, 19838, },
	[480] = { 19594, 19958, 19843, 19842, 19841, },
	[481] = { 19605, 19957, 19848, 19849, 20033, },
	[482] = { 19601, 19959, 19846, 19845, 20034, },
	[483] = { 20158, 20154, 20150, },
	[484] = { 20195, 20199, 20203, },
	[485] = { 20176, 20159, 20163, },
	[486] = { 20186, 20190, 20194, },
	[487] = { 20204, 20208, 20212, },
	[488] = { 20167, 20171, 20175, },
	[489] = { 16984, 15050, 15052, 15051, },
	[490] = { 15045, 15046, 20296, },
	[491] = { 15048, 20295, 15049, },
	[492] = { 20406, 20408, 20407, },
	[493] = { 21355, 21353, 21354, 21356, 21357, },
	[494] = { 21408, 21409, 21407, },
	[495] = { 21394, 21392, 21393, },
	[496] = { 21331, 21329, 21333, 21332, 21330, },
	[497] = { 21359, 21360, 21361, 21362, 21364, },
	[498] = { 21405, 21406, 21404, },
	[499] = { 21337, 21338, 21335, 21334, 21336, },
	[500] = { 21416, 21417, 21418, },
	[501] = { 21372, 21373, 21374, 21375, 21376, },
	[502] = { 21400, 21398, 21399, },
	[503] = { 21344, 21347, 21346, 21343, 21345, },
	[504] = { 21414, 21413, 21415, },
	[505] = { 21389, 21387, 21388, 21390, 21391, },
	[506] = { 21397, 21395, 21396, },
	[507] = { 21349, 21350, 21348, 21352, 21351, },
	[508] = { 21410, 21411, 21412, },
	[509] = { 21366, 21365, 21370, 21368, 21367, },
	[510] = { 21403, 21401, 21402, },
	[511] = { 21994, 21995, 21996, 21997, 21998, 21999, 22000, 22001, },
	[512] = { 22002, 22003, 22004, 22005, 22006, 22007, 22008, 22009, },
	[513] = { 22106, 22107, 22108, 22109, 22110, 22111, 22112, 22113, },
	[514] = { 22078, 22079, 22080, 22081, 22082, 22083, 22084, 22085, },
	[515] = { 22010, 22011, 22061, 22013, 22015, 22016, 22017, 22060, },
	[516] = { 22086, 22087, 22088, 22089, 22090, 22091, 22092, 22093, },
	[517] = { 22062, 22063, 22064, 22065, 22066, 22067, 22068, 22069, },
	[518] = { 22070, 22071, 22072, 22073, 22074, 22075, 22076, 22077, },
	[519] = { 22095, 22096, 22097, 22098, 22099, 22100, 22101, 22102, },
	[520] = { 22306, 22311, 22313, 22302, 22304, 22305, 22303, 22301, },
	[521] = { 22492, 22494, 22493, 22490, 22489, 22491, 22488, 22495, 23064, },
	[522] = { 22864, 22856, 22879, 22880, 23257, 23258, },
	[523] = { 22423, 22416, 22421, 22422, 22418, 22417, 22419, 22420, 23059, },
	[524] = { 22483, 22476, 22481, 22478, 22477, 22479, 22480, 22482, 23060, },
	[525] = { 22518, 22519, 22514, 22517, 22513, 22512, 22516, 22515, 23061, },
	[526] = { 22502, 22503, 22498, 22501, 22497, 22496, 22500, 22499, 23062, },
	[527] = { 22468, 22470, 22469, 22466, 22465, 22467, 22464, 22471, 23065, },
	[528] = { 22430, 22431, 22426, 22428, 22427, 22429, 22425, 22424, 23066, },
	[529] = { 22510, 22511, 22506, 22509, 22505, 22504, 22508, 22507, 23063, },
	[530] = { 22440, 22442, 22441, 22438, 22437, 22439, 22436, 22443, 23067, },
	[533] = { 23090, 23087, 23078, },
	[534] = { 23081, 23089, 23093, },
	[535] = { 23088, 23082, 23092, },
	[536] = { 23091, 23084, 23085, },
	[537] = { 22868, 22858, 22872, 22873, 23244, 23243, },
	[538] = { 22857, 22867, 22876, 22887, 23259, 23260, },
	[539] = { 22863, 22852, 22877, 22878, 23253, 23254, },
	[540] = { 22869, 22859, 22882, 22885, 23261, 23262, },
	[541] = { 22865, 22855, 23255, 23256, 22881, 22884, },
	[542] = { 22870, 22860, 23263, 23264, 22883, 22886, },
	[543] = { 22843, 22862, 23251, 23252, 22874, 22875, },
	[544] = { 23272, 23273, 23274, 23275, 23276, 23277, },
	[545] = { 23300, 23301, 23286, 23287, 23314, 23315, },
	[546] = { 23304, 23305, 23290, 23291, 23318, 23319, },
	[547] = { 23296, 23297, 23282, 23283, 23310, 23311, },
	[548] = { 23298, 23299, 23284, 23285, 23312, 23313, },
	[549] = { 23302, 23303, 23288, 23289, 23316, 23317, },
	[550] = { 23292, 23293, 23278, 23279, 23306, 23307, },
	[551] = { 23294, 23295, 23280, 23281, 23308, 23309, },
	[1570] = { 209683, 209671, 209669, },
	[1571] = { 211263, },
	[1577] = { 211506, 211504, 211505, },
	[1578] = { 211510, 211511, 211512, },
	[1579] = { 211507, 211508, 211509, },
	[1584] = { 215377, 215379, 215378, },
	[1585] = { 213313, 213332, 213341, },
	[1586] = { 213312, 213331, 213342, },
	[1587] = { 213311, 213336, 213329, },
	[1588] = { 213310, 213328, 213337, },
	[1589] = { 213316, 213330, 213335, },
	[1590] = { 213314, 213339, 213333, },
	[1591] = { 213315, 213334, 213338, },
	[1592] = { 216486, 216485, 216484, },
	[1618] = { 220803, 220796, 220807, 220800, 220801, 220798, },
	[1619] = { 220794, 220797, 220804, 220795, 220806, 220799, },
	[1620] = { 220810, 220808, 220813, 220809, 220811, 220812, },
	[1621] = { 220819, 220818, 220815, 220816, 220814, 220817, },
	[1622] = { 220820, 220823, 220826, 220834, 220835, 220831, },
	[1623] = { 220848, 220849, 220844, 220847, 220846, 220845, },
	[1624] = { 220842, 220841, 220838, 220839, 220840, 220843, },
	[1625] = { 220824, 220821, 220830, 220836, 220827, 220833, },
	[1626] = { 220828, 220832, 220825, 220822, 220829, 220837, },
	[1627] = { 220851, 220853, 220861, 220857, 220855, 220859, },
	[1628] = { 220854, 220858, 220850, 220852, 220860, 220856, },
	[1629] = { 220875, 220877, 220885, 220881, 220879, 220883, },
	[1630] = { 220878, 220882, 220874, 220876, 220884, 220880, },
	[1631] = { 220873, 220871, 220863, 220867, 220865, 220869, },
	[1632] = { 220864, 220868, 220872, 220870, 220862, 220866, },
	[1633] = { 220907, 220905, 220909, 220908, 220906, 220904, },
	[1634] = { 220888, 220886, 220889, 220887, 220891, 220890, },
	[1635] = { 220899, 220901, 220900, 220898, 220903, 220902, },
	[1636] = { 220892, 220893, 220896, 220894, 220895, 220897, },
	[1637] = { 220783, 220781, 220784, },
	[1638] = { 220683, 220684, 220685, },
	[1639] = { 220680, 220679, 220681, },
	[1640] = { 220779, 220778, 220780, },
	[1641] = { 220676, 220678, 220677, },
	[1642] = { 220672, 220673, 220675, },
	[1643] = { 220669, 220671, 220670, },
	[1644] = { 220665, 220663, 220664, },
	[1645] = { 220657, 220658, 220659, },
	[1646] = { 220660, 220661, 220662, },
	[1647] = { 220666, 220667, 220668, },
	[1648] = { 220650, 220651, 220652, },
	[1649] = { 220653, 220654, 220656, },
	[1650] = { 220642, 220643, 220648, },
	[1651] = { 220588, 220589, },
	[1652] = { 221381, 221380, 221379, 221378, 221377, 221376, },
	[1653] = { 221387, 221386, 221385, 221384, 221383, 221382, },
	[1654] = { 221393, 221392, 221391, 221390, 221389, 221388, },
	[1655] = { 221399, 221398, 221397, 221396, 221395, 221394, },
	[1656] = { 221405, 221404, 221403, 221402, 221401, 221400, },
	[1657] = { 221411, 221410, 221409, 221408, 221407, 221406, },
	[1658] = { 221417, 221416, 221415, 221414, 221413, 221412, },
	[1659] = { 221424, 221423, 221422, 221421, 221420, 221419, },
	[1660] = { 221431, 221430, 221429, 221427, 221426, 221425, },
	[1661] = { 221438, 221437, 221436, 221435, 221434, 221432, },
	[1664] = { 221785, },
	[1665] = { 223078, 223077, 223076, 223075, 223074, 223073, },
	[1666] = { 226712, 226713, 226714, 226708, 226711, 226709, 226710, 226715, },
	[1667] = { 226821, 226822, 226820, 226819, 226818, 226817, 226816, 226815, },
	[1668] = { 226718, 226717, 226722, 226720, 226721, 226716, 226719, 226723, },
	[1669] = { 226903, 226904, 226902, 226901, 226900, 226899, 226898, 226897, },
	[1670] = { 226724, 226725, 226730, 226728, 226731, 226727, 226726, 226729, },
	[1671] = { 226943, 226944, 226942, 226941, 226940, 226939, 226938, 226937, },
	[1672] = { 226732, 226738, 226739, 226734, 226737, 226733, 226736, 226735, },
	[1673] = { 226999, 227000, 226998, 226997, 226996, 226995, 226994, 226993, },
	[1674] = { 226744, 226742, 226746, 226740, 226741, 226745, 226743, 226747, },
	[1675] = { 226967, 226968, 226966, 226965, 226964, 226963, 226961, 226962, },
	[1676] = { 226851, 226852, 226850, 226849, 226848, 226847, 226846, 226845, },
	[1677] = { 226701, 226703, 226704, 226707, 226702, 226705, 226706, 226700, },
	[1678] = { 226751, 226752, 226755, 226754, 226748, 226750, 226753, 226749, },
	[1679] = { 227039, 227040, 227038, 227037, 227036, 227035, 227034, 227033, },
	[1680] = { 226761, 226759, 226760, 226756, 226762, 226757, 226763, 226758, },
	[1681] = { 226927, 226928, 226926, 226925, 226924, 226923, 226922, 226921, },
	[1682] = { 226765, 226764, 226766, 226770, 226771, 226769, 226767, 226768, },
	[1698] = { 226658, 226657, 226656, 226654, 226653, 226651, 226652, 226655, },
	[1699] = { 226662, 226664, 226660, 226659, 226665, 226663, 226666, 226661, },
	[1700] = { 226650, 226645, 226649, 226648, 226647, 226646, 226644, 221785, },
	[1701] = { 226675, 226670, 226669, 226671, 226674, 226667, 226673, 226668, },
	[1702] = { 226529, 226531, 226530, 226534, 226527, 226528, 226533, 226532, },
	[1703] = { 226537, 226535, 226542, 226536, 226540, 226538, 226543, 226541, },
	[1704] = { 226555, 226558, 226557, 226562, 226556, 226561, 226560, 226559, },
	[1705] = { 226570, 226563, 226569, 226564, 226565, 226568, 226566, 226567, },
	[1706] = { 226592, 226593, 226589, 226610, 226591, 226590, 226594, 226588, },
	[1707] = { 226601, 226602, 226599, 226597, 226600, 226598, 221783, 226596, },
	[1708] = { 226604, 226595, 226608, 226607, 226606, 226605, 226609, 226603, },
	[1709] = { 226571, 226573, 226577, 226572, 226576, 226574, 226575, 226578, },
	[1710] = { 226580, 226584, 226582, 226585, 226583, 226586, 226581, 226579, },
	[1711] = { 226440, 226442, 226447, 226443, 226446, 226441, 226445, 226444, },
	[1712] = { 226476, 226473, 226475, 226480, 226479, 226478, 226477, 226474, },
	[1713] = { 226616, 226613, 226618, 226611, 226615, 226612, 226614, 226617, },
	[1714] = { 226621, 226623, 226624, 226619, 226622, 226625, 226620, 226626, },
	[1715] = { 226636, 226642, 226639, 226635, 226641, 226637, 226638, 226640, },
	[1716] = { 226630, 226629, 226632, 226628, 226631, 226627, 226633, 226634, },
	[1717] = { 226551, 226553, 226552, 226549, 226547, 226548, 226550, 226554, },
	[1718] = { 216920, 216918, 216922, 216924, 216921, 216923, 216925, 216919, },
	[1719] = { 226485, 226484, 226489, 226486, 226488, 226490, 226491, 226487, },
	[1720] = { 226499, 226497, 226494, 226495, 226493, 226492, 226498, 226496, },
	[1721] = { 231535, 231534, 231530, 231533, 231531, 231532, },
	[1722] = { 231684, 231687, 231686, 231683, 231685, 231688, },
	[1723] = { 231681, 231678, 231679, 231680, 231677, 231682, },
	[1724] = { 231674, 231672, 231675, 231673, 231671, 231676, },
	[1725] = { 231571, 231572, 231573, 231574, 231570, 231575, },
	[1726] = { 231568, 231565, 231566, 231567, 231564, 231569, },
	[1727] = { 231596, 231601, 231594, 231595, 231598, 231597, },
	[1728] = { 231612, 231611, 231615, 231610, 231614, 231613, },
	[1729] = { 231632, 231631, 231635, 231630, 231634, 231633, },
	[1730] = { 231553, 231551, 231549, 231554, 231552, 231555, },
	[1731] = { 231654, 231657, 231653, 231655, 231658, 231656, },
	[1732] = { 231659, 231663, 231662, 231661, 231664, 231660, },
	[1733] = { 231669, 231665, 231668, 231670, 231666, 231667, },
	[1734] = { 231591, 231592, 231590, 231588, 231589, 231593, },
	[1735] = { 231696, 231695, 231699, 231698, 231700, 231697, },
	[1736] = { 231701, 231705, 231702, 231706, 231704, 231703, },
	[1737] = { 231690, 231689, 231693, 231694, 231691, 231692, },
	[1738] = { 231562, 231557, 231563, 231558, 231561, 231560, },
	[1739] = { 231580, 231576, 231581, 231577, 231579, 231578, },
	[1740] = { 231604, 231602, 231603, 231606, 231607, 231605, },
	[1741] = { 231616, 231621, 231618, 231617, 231619, 231620, },
	[1742] = { 231622, 231628, 231624, 231623, 231626, 231627, },
	[1743] = { 231545, 231547, 231543, 231548, 231546, 231544, },
	[1744] = { 231649, 231648, 231651, 231650, 231647, 231652, },
	[1745] = { 231641, 231640, 231645, 231643, 231646, 231639, },
	[1746] = { 231584, 231582, 231583, 231585, 231586, 231587, },
	[1747] = { 231538, 231537, 231536, 231540, 231539, 231541, },
	[1748] = { 227188, 227187, 227186, 227184, 227189, 227185, },
	[1749] = { 227204, 227203, 227205, 227207, 227206, 227202, },
	[1750] = { 227180, 227181, 227174, 227175, 227179, 227177, },
	[1751] = { 227081, 227082, 227080, 227078, 227083, 227079, },
	[1752] = { 227074, 227075, 227067, 227069, 227071, 227073, },
	[1753] = { 227117, 227110, 227105, 227104, 227107, 227106, },
	[1754] = { 227133, 227134, 227132, 227130, 227131, 227135, },
	[1755] = { 227126, 227127, 227118, 227120, 227123, 227124, },
	[1756] = { 227063, 227062, 227057, 227056, 227060, 227059, },
	[1757] = { 227163, 227164, 227162, 227160, 227165, 227161, },
	[1758] = { 227170, 227169, 227166, 227168, 227171, 227167, },
	[1759] = { 227158, 227159, 227155, 227154, 227157, 227156, },
	[1760] = { 227099, 227098, 227090, 227092, 227097, 227094, },
	[1761] = { 227050, 227051, 227043, 227042, 227049, 227048, },
	[1762] = { 227195, 227191, 227194, 227193, 227192, 227190, },
	[1763] = { 227200, 227196, 227198, 227197, 227199, 227201, },
	[1764] = { 227176, 227178, 227183, 227182, 227173, 227172, },
	[1765] = { 227089, 227085, 227087, 227088, 227086, 227084, },
	[1766] = { 227070, 227072, 227076, 227077, 227066, 227068, },
	[1767] = { 227109, 227108, 227116, 227112, 227103, 227102, },
	[1768] = { 227137, 227141, 227139, 227140, 227138, 227136, },
	[1769] = { 227125, 227122, 227128, 227129, 227121, 227119, },
	[1770] = { 227058, 227061, 227065, 227064, 227055, 227054, },
	[1774] = { 227095, 227096, 227100, 227101, 227093, 227091, },
	[1775] = { 227046, 227047, 227053, 227052, 227044, 227045, },
	[1776] = { 227151, 227150, 227152, 227153, 227149, 227148, },
	[1777] = { 227142, 227143, 227147, 227146, 227144, 227145, },
	[1778] = { 226879, 226880, 226878, 226877, 226876, 226875, 226874, 226873, },
	[1779] = { 228145, 228146, 228147, },
	[1780] = { 228297, 228298, },
	[1781] = { 228350, 228349, 228360, 228759, },
	[1782] = { 228528, 228524, 228529, 228527, 228525, },
	[1783] = { 228573, 228592, },
	[1784] = { 228653, 228652, },
	[1785] = { 228596, 228597, 228598, 228681, 228066, 228700, 228038, 228547, },
	[1786] = { 227999, 228008, 228002, 228006, 228000, },
	[1787] = { 228009, 228011, 228018, 228010, 228013, },
	[1788] = { 228014, 227998, 228020, 228012, 228003, },
	[1789] = { 227868, 227867, 227866, },
	[1790] = { 227875, 227874, 227873, },
	[1791] = { 227879, 227878, 227877, },
	[1792] = { 227829, 227851, 227852, 227853, },
	[1793] = { 227848, 227847, },
	[1795] = { 230867, 231001, },
	[1796] = { 230915, 231000, },
	[1797] = { 230921, 230929, },
	[1798] = { 230934, 230925, },
	[1799] = { 230943, 230999, },
	[1800] = { 231309, 230992, },
	[1801] = { 231246, 231247, 231248, 231249, 231250, 231251, 231252, 231253, },
	[1802] = { 231230, 231231, 231232, 231233, 231234, 231235, 231236, 231237, },
	[1803] = { 231254, 231255, 231256, 231257, 231258, 231259, 231260, 231261, },
	[1804] = { 231238, 231239, 231240, 231241, 231242, 231243, 231244, 231245, },
	[1805] = { 231062, 231061, 231060, 231059, 231058, 231057, 231056, 231055, },
	[1806] = { 231071, 231070, 231069, 231068, 231067, 231066, 231065, 231063, },
	[1807] = { 231105, 231101, 231102, 231103, 231104, 231106, 231100, 231107, },
	[1808] = { 231113, 231109, 231110, 231111, 231112, 231114, 231108, 231115, },
	[1809] = { 231197, 231196, 231195, 231194, 231193, 231192, 231191, 231190, },
	[1810] = { 231181, 231180, 231179, 231178, 231177, 231176, 231175, 231174, },
	[1811] = { 231187, 231189, 231188, 231186, 231185, 231184, 231183, 231182, },
	[1812] = { 231159, 231155, 231156, 231157, 231158, 231160, 231161, 231162, },
	[1813] = { 231169, 231165, 231166, 231167, 231168, 231170, 231171, 231172, },
	[1814] = { 231040, 231041, 231042, 231043, 231044, 231039, 231045, 231046, },
	[1815] = { 231048, 231049, 231050, 231051, 231052, 231047, 231053, 231054, },
	[1816] = { 231205, 231204, 231198, 231203, 231202, 231201, 231200, 231199, },
	[1817] = { 231221, 231220, 231214, 231219, 231218, 231217, 231216, 231215, },
	[1818] = { 231229, 231228, 231222, 231227, 231226, 231225, 231224, 231223, },
	[1819] = { 231213, 231212, 231206, 231211, 231210, 231209, 231208, 231207, },
	[1820] = { 231076, 231072, 231073, 231074, 231075, 231077, 231078, 231079, },
	[1821] = { 231095, 231090, 231091, 231092, 231093, 231096, 231097, 231098, },
	[1822] = { 231030, 231029, 231028, 231027, 231026, 231025, 231024, 231023, },
	[1823] = { 231038, 231037, 231036, 231035, 231034, 231033, 231032, 231031, },
	[1824] = { 231319, 231318, 231317, 231316, 231280, },
	[1825] = { 231323, 231322, 231321, 231320, 231288, },
	[1826] = { 231327, 231325, 231326, 231324, 231282, },
	[1827] = { 231329, 231330, 231331, 231285, 231328, },
	[1828] = { 231335, 231334, 231333, 231332, 231283, },
	[1829] = { 231339, 231338, 231337, 231336, 231287, },
	[1830] = { 231343, 231342, 231341, 231340, 231281, },
	[1831] = { 231349, 231348, 231347, 231346, 231284, },
	[1832] = { 231353, 231352, 231351, 231350, 231286, },
	[1835] = { 233723, 233722, 233721, 233720, 233719, },
	[1836] = { 233718, 233717, 233716, 233715, 233714, },
	[1837] = { 233412, 233413, 233415, 233416, 233414, },
	[1838] = { 233709, 233713, 233711, 233710, 233712, },
	[1839] = { 233410, 233409, 233411, 233408, 233407, },
	[1840] = { 233666, 233668, 233664, 233667, 233665, },
	[1841] = { 233404, 233403, 233406, 233405, 233402, },
	[1842] = { 233676, 233677, 233674, 233675, 233678, },
	[1843] = { 233687, 233684, 233688, 233685, 233686, },
	[1844] = { 233692, 233689, 233693, 233690, 233691, },
	[1845] = { 233398, 233401, 233397, 233400, 233399, },
	[1846] = { 233682, 233681, 233679, 233683, 233680, },
	[1847] = { 233393, 233394, 233396, 233392, 233395, },
	[1848] = { 233388, 233387, 233389, 233390, 233391, },
	[1849] = { 233661, 233663, 233659, 233662, 233660, },
	[1850] = { 233385, 233383, 233386, 233382, 233384, },
	[1851] = { 233705, 233707, 233704, 233708, 233706, },
	[1852] = { 233695, 233697, 233694, 233698, 233696, },
	[1853] = { 233700, 233702, 233699, 233703, 233701, },
	[1854] = { 233381, 233379, 233378, 233377, 233380, },
	[1855] = { 233669, 233671, 233672, 233673, 233670, },
	[1856] = { 233653, 233658, 233651, 233654, 233652, },
	[1857] = { 233375, 233376, 233373, 233374, 233372, },
	[1858] = { 233418, 233419, 233417, },
	[1859] = { 233421, 233420, 233422, },
	[1860] = { 233424, 233425, 233423, },
	[1861] = { 233427, 233428, 233426, },
	[1862] = { 233430, 233431, 233429, },
	[1863] = { 233433, 233432, 233434, },
	[1864] = { 233436, 233437, 233435, },
	[1865] = { 233438, 233440, 233439, },
	[1866] = { 233442, 233441, 233443, },
	[1881] = { 235893, 235894, },
	[1882] = { 236007, 236008, 236005, 236011, 236006, 236009, 236012, 236010, 236013, },
	[1883] = { 236016, 236017, 236014, 236020, 236015, 236018, 236021, 236019, 236022, },
	[1884] = { 236072, 236070, 236069, 236071, 236075, 236068, 236073, 236076, 236074, },
	[1885] = { 236064, 236065, 236066, 236060, 236059, 236061, 236063, 236062, 236067, },
	[1886] = { 236165, 236163, 236169, 236162, 236164, 236168, 236160, 236166, 236167, },
	[1887] = { 236144, 236145, 236147, 236148, 236143, 236146, 236149, 236142, 236150, },
	[1888] = { 236174, 236172, 236179, 236171, 236173, 236177, 236170, 236175, 236176, },
	[1889] = { 236155, 236153, 236159, 236152, 236154, 236158, 236151, 236156, 236157, },
	[1890] = { 236037, 236035, 236039, 236032, 236036, 236033, 236040, 236038, 236034, },
	[1891] = { 236025, 236026, 236023, 236029, 236024, 236027, 236030, 236028, 236031, },
	[1892] = { 236103, 236102, 236098, 236101, 236099, 236100, 236104, 236097, 236105, },
	[1893] = { 236110, 236108, 236107, 236109, 236113, 236106, 236111, 236114, 236112, },
	[1894] = { 236137, 236135, 236141, 236134, 236136, 236140, 236133, 236138, 236139, },
	[1895] = { 236117, 236122, 236115, 236120, 236121, 236123, 236119, 236118, 236116, },
	[1896] = { 236128, 236126, 236132, 236125, 236127, 236131, 236124, 236129, 236130, },
	[1897] = { 236091, 236089, 236088, 236090, 236094, 236087, 236092, 236095, 236093, },
	[1898] = { 236083, 236084, 236078, 236079, 236080, 236077, 236082, 236081, 236085, },
	[1899] = { 236046, 236044, 236043, 236048, 236045, 236049, 236042, 236047, 236041, },
	[1900] = { 236054, 236052, 236058, 236051, 236053, 236057, 236050, 236055, 236056, },
	[1901] = { 236205, 236203, 236209, 236202, 236204, 236208, 236201, 236206, 236207, },
	[1902] = { 236182, 236189, 236186, 236187, 236188, 236185, 236183, 236184, 236190, },
	[1903] = { 236214, 236212, 236218, 236211, 236213, 236217, 236210, 236215, 236216, },
	[1904] = { 236196, 236194, 236200, 236193, 236195, 236199, 236192, 236197, 236198, },
	[1905] = { 236707, 236713, 236711, },
	[1906] = { 236709, 236710, 236715, },
	[1907] = { 236708, 236714, 236712, },
	[1908] = { 236718, 236717, 236716, },
	[1909] = { 236748, 236747, 236746, },
	[1910] = { 236745, 236744, 236743, },
	[1911] = { 236734, 236735, 236736, },
	[1912] = { 236737, 236738, 236739, },
	[1913] = { 236742, 236741, 236740, },
	[1914] = { 236727, 236726, 236725, },
	[1915] = { 236730, 236729, 236728, },
	[1916] = { 236733, 236732, 236731, },
	[1917] = { 236721, 236720, 236719, },
	[1918] = { 236724, 236723, 236722, },
	[1932] = { 239517, 239516, 239519, 239513, 239518, 239515, 239512, 239514, },
	[1933] = { 239525, 239524, 239527, 239521, 239526, 239523, 239520, 239522, },
	[1934] = { 239560, 239559, 239562, 239556, 239561, 239558, 239555, 239557, },
	[1935] = { 239550, 239552, 239548, 239554, 239551, 239553, 239547, 239549, },
	[1936] = { 239532, 239534, 239529, 239535, 239533, 239530, 239536, 239531, },
	[1937] = { 239540, 239542, 239543, 239538, 239541, 239537, 239544, 239539, },
	[1938] = { 239575, 239581, 239582, 239577, 239572, 239583, 239574, 239565, },
	[1939] = { 239585, 239586, 239590, 239587, 239589, 239588, 239584, 239591, },
	[1940] = { 240027, 240025, 240030, 240024, 240026, 240029, 240023, 240028, },
	[1941] = { 240040, 240021, 240039, 240043, 240020, 240022, 240042, 240041, },
	[1942] = { 240035, 240033, 240038, 240032, 240034, 240037, 240031, 240036, },
	[1943] = { 240056, 240054, 240053, 240055, 240058, 240052, 240057, 240059, },
	[1944] = { 240048, 240046, 240045, 240047, 240050, 240044, 240049, 240051, },
	[1945] = { 240064, 240062, 240067, 240061, 240063, 240066, 240060, 240065, },
	[1946] = { 240072, 240070, 240075, 240069, 240071, 240074, 240068, 240073, },
	[1947] = { 240088, 240086, 240091, 240085, 240087, 240090, 240084, 240089, },
	[1948] = { 240080, 240078, 240083, 240077, 240079, 240082, 240076, 240081, },
	[1949] = { 240104, 240106, 240101, 240107, 240105, 240102, 240108, 240103, },
	[1950] = { 240096, 240098, 240092, 240099, 240097, 240093, 240100, 240095, },
	[1951] = { 240131, 240135, 240128, 240136, 240134, 240129, 240137, 240130, },
	[1952] = { 240123, 240125, 240109, 240126, 240124, 240110, 240127, 240122, },
	[1953] = { 240148, 240150, 240151, 240149, 240153, 240152, 240147, 240146, },
	[1954] = { 240141, 240143, 240144, 240142, 240139, 240145, 240140, 240138, },
	[1955] = { 236343, 240853, },
	[1956] = { 240922, 240923, },
	[1959] = { 240854, 240852, },
};
DT.ItemSetThreshold = {
	[1] = { 2, 3, 4, 5, },
	[41] = { 2, },
	[65] = { 2, },
	[81] = { 2, 3, 3, 4, 5, 5, },
	[121] = { 2, 3, 4, 5, },
	[122] = { 2, 3, 4, 5, },
	[123] = { 2, 3, 4, 5, },
	[124] = { 2, 3, 4, 5, },
	[141] = { 3, },
	[142] = { 2, 3, 4, },
	[143] = { 2, },
	[144] = { 2, },
	[161] = { 2, 3, 4, 5, },
	[162] = { 2, 3, 4, 5, },
	[163] = { 2, 3, 4, 5, 6, },
	[181] = { 2, 4, 6, 8, },
	[182] = { 2, 4, 6, 8, },
	[183] = { 2, 4, 6, 8, },
	[184] = { 2, 4, 6, 8, },
	[185] = { 2, 4, 4, 6, 8, },
	[186] = { 2, 4, 6, 8, },
	[187] = { 2, 4, 6, 8, },
	[188] = { 2, 4, 6, 8, },
	[189] = { 2, 4, 6, 8, },
	[201] = { 3, 5, 8, },
	[202] = { 3, 5, 8, },
	[203] = { 3, 5, 8, },
	[204] = { 3, 5, 8, },
	[205] = { 3, 5, 8, },
	[206] = { 3, 5, 8, },
	[207] = { 3, 5, 8, },
	[208] = { 3, 5, 5, 8, },
	[209] = { 3, 5, 8, },
	[210] = { 3, 5, 8, },
	[211] = { 3, 5, 8, },
	[212] = { 3, 5, 8, },
	[213] = { 3, 5, 8, },
	[214] = { 3, 5, 8, },
	[215] = { 3, 5, 8, },
	[216] = { 3, 5, 8, },
	[217] = { 3, 5, 8, },
	[218] = { 3, 5, 8, },
	[221] = { 6, },
	[241] = { 2, },
	[261] = { 4, },
	[281] = { 2, 4, 6, },
	[282] = { 2, 4, 6, },
	[301] = { 2, 4, 6, },
	[321] = { 2, 4, 6, },
	[341] = { 2, 4, 6, },
	[342] = { 2, 4, 6, },
	[343] = { 2, 4, 6, },
	[344] = { 2, 4, 6, },
	[345] = { 2, 4, 6, },
	[346] = { 2, 4, 6, },
	[347] = { 2, 4, 6, },
	[348] = { 2, 4, 6, },
	[361] = { 2, 4, 6, },
	[362] = { 2, 4, 6, },
	[381] = { 2, 4, 6, },
	[382] = { 2, 4, 6, },
	[383] = { 2, 3, 6, },
	[384] = { 2, 3, 6, },
	[386] = { 2, 3, 6, },
	[387] = { 2, 3, 6, },
	[388] = { 2, 3, 6, },
	[389] = { 2, 3, 6, },
	[390] = { 2, 3, 6, },
	[391] = { 2, 3, 6, },
	[392] = { 2, 3, 6, },
	[393] = { 2, 3, 6, },
	[394] = { 2, 3, 6, },
	[395] = { 2, 3, 6, },
	[396] = { 2, 3, 6, },
	[397] = { 2, 3, 6, },
	[398] = { 2, 3, 6, },
	[401] = { 2, 2, 4, 6, },
	[402] = { 2, 3, 6, },
	[421] = { 3, },
	[441] = { 3, },
	[442] = { 2, 2, },
	[443] = { 3, },
	[444] = { 3, },
	[461] = { 2, },
	[462] = { 2, 2, },
	[463] = { 2, },
	[464] = { 2, },
	[465] = { 2, },
	[466] = { 2, },
	[467] = { 2, 3, },
	[468] = { 2, 3, },
	[469] = { 2, 3, },
	[470] = { 2, 3, },
	[471] = { 2, 3, },
	[472] = { 2, 3, },
	[473] = { 2, 3, },
	[474] = { 2, 3, 5, },
	[475] = { 2, 3, 5, },
	[476] = { 2, 3, 5, },
	[477] = { 2, 3, 5, },
	[478] = { 2, 3, 5, },
	[479] = { 2, 3, 5, },
	[480] = { 2, 3, 5, },
	[481] = { 2, 3, 5, },
	[482] = { 2, 3, 5, },
	[483] = { 2, 3, },
	[484] = { 2, 3, },
	[485] = { 2, 3, },
	[486] = { 2, 3, },
	[487] = { 2, 3, },
	[488] = { 2, 3, },
	[489] = { 2, 3, 4, },
	[490] = { 2, 3, },
	[491] = { 2, 3, },
	[492] = { 3, },
	[493] = { 3, 3, 5, },
	[494] = { 3, },
	[495] = { 3, },
	[496] = { 3, 5, },
	[497] = { 3, 5, },
	[498] = { 3, },
	[499] = { 3, 5, },
	[500] = { 3, },
	[501] = { 3, 5, },
	[502] = { 3, },
	[503] = { 3, 5, },
	[504] = { 3, },
	[505] = { 3, 5, },
	[506] = { 3, },
	[507] = { 3, 5, },
	[508] = { 3, },
	[509] = { 3, 5, },
	[510] = { 3, },
	[511] = { 2, 4, 6, 8, },
	[512] = { 2, 4, 6, 8, },
	[513] = { 2, 4, 6, 6, 8, },
	[514] = { 2, 4, 6, 8, },
	[515] = { 2, 4, 6, 8, },
	[516] = { 2, 4, 6, 8, },
	[517] = { 2, 4, 6, 8, },
	[518] = { 2, 4, 6, 8, },
	[519] = { 2, 4, 6, 8, },
	[520] = { 4, 8, },
	[521] = { 2, 4, 6, 8, },
	[522] = { 2, 4, 6, },
	[523] = { 2, 4, 6, 8, },
	[524] = { 2, 4, 6, 8, },
	[525] = { 2, 4, 6, 8, },
	[526] = { 2, 4, 6, 8, },
	[527] = { 2, 4, 6, 8, },
	[528] = { 2, 4, 6, 8, },
	[529] = { 2, 4, 6, 8, },
	[530] = { 2, 4, 6, 8, },
	[533] = { 3, },
	[534] = { 3, },
	[535] = { 3, },
	[536] = { 3, },
	[537] = { 2, 4, 6, },
	[538] = { 2, 4, 6, },
	[539] = { 2, 4, 6, },
	[540] = { 2, 4, 6, },
	[541] = { 2, 4, 6, },
	[542] = { 2, 4, 6, },
	[543] = { 2, 4, 6, },
	[544] = { 2, 4, 6, },
	[545] = { 2, 4, 6, },
	[546] = { 2, 4, 6, },
	[547] = { 2, 4, 6, },
	[548] = { 2, 4, 6, },
	[549] = { 2, 4, 6, },
	[550] = { 2, 4, 6, },
	[551] = { 2, 4, 6, },
	[1570] = { 2, 3, },
	[1571] = { 3, 5, 8, },
	[1576] = { 3, 5, 8, },
	[1577] = { 2, 3, },
	[1578] = { 2, 3, },
	[1579] = { 2, 3, },
	[1584] = { 2, 2, 3, },
	[1585] = { 2, 3, 3, },
	[1586] = { 2, 3, },
	[1587] = { 2, 2, 3, },
	[1588] = { 2, 3, },
	[1589] = { 2, 2, 3, },
	[1590] = { 2, 3, },
	[1591] = { 2, 3, },
	[1592] = { 2, 3, },
	[1593] = { 3, 5, 8, },
	[1618] = { 3, 6, },
	[1619] = { 3, 6, },
	[1620] = { 3, 6, },
	[1621] = { 3, 6, },
	[1622] = { 3, 6, },
	[1623] = { 3, 6, },
	[1624] = { 3, 6, },
	[1625] = { 3, 6, },
	[1626] = { 3, 6, },
	[1627] = { 3, 6, },
	[1628] = { 3, 6, },
	[1629] = { 3, 6, },
	[1630] = { 3, 6, },
	[1631] = { 3, 6, },
	[1632] = { 3, 6, },
	[1633] = { 3, 6, },
	[1634] = { 3, 6, },
	[1635] = { 3, 6, },
	[1636] = { 3, 6, },
	[1637] = { 2, 3, },
	[1638] = { 2, 3, },
	[1639] = { 2, 3, },
	[1640] = { 2, 3, 3, },
	[1641] = { 2, 3, },
	[1642] = { 2, 3, },
	[1643] = { 2, 3, },
	[1644] = { 2, 3, },
	[1645] = { 2, 3, },
	[1646] = { 2, 3, 3, },
	[1647] = { 2, 3, 3, },
	[1648] = { 2, 3, },
	[1649] = { 2, 3, },
	[1650] = { 2, 3, },
	[1651] = { 2, },
	[1652] = { 3, 6, },
	[1653] = { 3, 6, },
	[1654] = { 3, 6, },
	[1655] = { 3, 6, },
	[1656] = { 3, 6, },
	[1657] = { 3, 6, },
	[1658] = { 3, 6, },
	[1659] = { 3, 6, },
	[1660] = { 3, 6, },
	[1661] = { 3, 6, },
	[1662] = { 3, 5, 8, },
	[1663] = { 3, 5, 8, },
	[1664] = { 3, 5, 8, },
	[1665] = { 3, 6, },
	[1666] = { 2, 4, 6, 8, },
	[1667] = { 2, 4, 6, 8, },
	[1668] = { 2, 4, 6, 8, },
	[1669] = { 2, 4, 6, 8, },
	[1670] = { 2, 4, 6, 8, },
	[1671] = { 2, 4, 6, 8, },
	[1672] = { 2, 4, 6, 8, },
	[1673] = { 2, 4, 6, 8, },
	[1674] = { 2, 4, 6, 8, },
	[1675] = { 2, 4, 6, 8, },
	[1676] = { 2, 4, 6, 8, },
	[1677] = { 2, 4, 6, 8, },
	[1678] = { 2, 4, 6, 8, },
	[1679] = { 2, 4, 6, 8, },
	[1680] = { 2, 4, 6, 8, },
	[1681] = { 2, 4, 6, 8, },
	[1682] = { 2, 4, 6, 8, },
	[1698] = { 2, 4, 6, },
	[1699] = { 2, 4, 6, },
	[1700] = { 2, 4, 6, },
	[1701] = { 2, 4, 6, },
	[1702] = { 2, 4, 6, },
	[1703] = { 2, 4, 6, },
	[1704] = { 2, 4, 6, },
	[1705] = { 2, 4, 6, },
	[1706] = { 2, 4, 6, },
	[1707] = { 2, 4, 6, },
	[1708] = { 2, 4, 6, },
	[1709] = { 2, 4, 6, },
	[1710] = { 2, 4, 6, },
	[1711] = { 2, 4, 6, },
	[1712] = { 2, 4, 6, },
	[1713] = { 2, 4, 6, },
	[1714] = { 2, 4, 6, },
	[1715] = { 2, 4, 6, },
	[1716] = { 2, 4, 6, },
	[1717] = { 2, 4, 6, },
	[1718] = { 2, 4, 6, },
	[1719] = { 2, 4, 6, },
	[1720] = { 2, 4, 6, },
	[1721] = { 2, 3, 6, },
	[1722] = { 2, 3, 6, },
	[1723] = { 2, 3, 6, },
	[1724] = { 2, 3, 6, },
	[1725] = { 2, 3, 6, },
	[1726] = { 2, 3, 6, },
	[1727] = { 2, 3, 6, },
	[1728] = { 2, 3, 6, },
	[1729] = { 2, 3, 6, },
	[1730] = { 2, 3, 6, },
	[1731] = { 2, 3, 6, },
	[1732] = { 2, 3, 6, },
	[1733] = { 2, 3, 6, },
	[1734] = { 2, 3, 6, },
	[1735] = { 2, 3, 6, },
	[1736] = { 2, 3, 6, },
	[1737] = { 2, 3, 6, },
	[1738] = { 2, 3, 6, },
	[1739] = { 2, 3, 6, },
	[1740] = { 2, 3, 6, },
	[1741] = { 2, 3, 6, },
	[1742] = { 2, 3, 6, },
	[1743] = { 2, 3, 6, },
	[1744] = { 2, 3, 6, },
	[1745] = { 2, 3, 6, },
	[1746] = { 2, 3, 6, },
	[1747] = { 2, 3, 6, },
	[1748] = { 2, 4, 6, },
	[1749] = { 2, 4, 6, },
	[1750] = { 2, 4, 6, },
	[1751] = { 2, 4, 6, },
	[1752] = { 2, 4, 6, },
	[1753] = { 2, 4, 6, },
	[1754] = { 2, 4, 6, },
	[1755] = { 2, 4, 6, },
	[1756] = { 2, 4, 6, },
	[1757] = { 2, 4, 6, },
	[1758] = { 2, 4, 6, },
	[1759] = { 2, 4, 6, },
	[1760] = { 2, 4, 6, },
	[1761] = { 2, 4, 6, },
	[1762] = { 2, 4, 6, },
	[1763] = { 2, 4, 6, },
	[1764] = { 2, 4, 6, },
	[1765] = { 2, 4, 6, },
	[1766] = { 2, 4, 6, },
	[1767] = { 2, 4, 6, },
	[1768] = { 2, 4, 6, },
	[1769] = { 2, 4, 6, },
	[1770] = { 2, 4, 6, },
	[1774] = { 2, 4, 6, },
	[1775] = { 2, 4, 6, },
	[1776] = { 2, 4, 6, },
	[1777] = { 2, 4, 6, },
	[1778] = { 2, 4, 6, 8, },
	[1779] = { 2, 3, },
	[1780] = { 2, 2, 2, },
	[1781] = { 2, 3, 4, },
	[1782] = { 2, 3, 3, 4, 5, 5, },
	[1783] = { 2, 2, },
	[1784] = { 2, },
	[1785] = { 2, 4, 6, },
	[1786] = { 2, 3, 4, 5, },
	[1787] = { 2, 3, 4, 5, },
	[1788] = { 2, 3, 4, 5, },
	[1789] = { 2, 3, },
	[1790] = { 2, 3, },
	[1791] = { 2, 3, },
	[1792] = { 2, 3, 4, },
	[1793] = { 2, 2, },
	[1795] = { 2, 2, },
	[1796] = { 2, },
	[1797] = { 2, },
	[1798] = { 2, },
	[1799] = { 2, },
	[1800] = { 2, 2, },
	[1801] = { 2, 4, 6, },
	[1802] = { 2, 4, 6, },
	[1803] = { 2, 4, 6, },
	[1804] = { 2, 4, 6, },
	[1805] = { 2, 4, 6, },
	[1806] = { 2, 4, 6, },
	[1807] = { 2, 4, 6, },
	[1808] = { 2, 4, 6, },
	[1809] = { 2, 4, 6, },
	[1810] = { 2, 4, 6, },
	[1811] = { 2, 4, 6, },
	[1812] = { 2, 4, 6, },
	[1813] = { 2, 4, 6, },
	[1814] = { 2, 4, 6, },
	[1815] = { 2, 4, 6, },
	[1816] = { 2, 4, 6, },
	[1817] = { 2, 4, 6, },
	[1818] = { 2, 4, 6, },
	[1819] = { 2, 4, 6, },
	[1820] = { 2, 4, 6, },
	[1821] = { 2, 4, 6, },
	[1822] = { 2, 4, 6, },
	[1823] = { 2, 4, 6, },
	[1824] = { 2, 3, 5, },
	[1825] = { 2, 3, 5, },
	[1826] = { 2, 3, 5, },
	[1827] = { 2, 3, 5, },
	[1828] = { 2, 3, 5, },
	[1829] = { 2, 3, 5, },
	[1830] = { 2, 3, 5, },
	[1831] = { 2, 3, 5, },
	[1832] = { 2, 3, 5, },
	[1835] = { 2, 4, },
	[1836] = { 2, 4, },
	[1837] = { 2, 4, },
	[1838] = { 2, 4, },
	[1839] = { 2, 4, },
	[1840] = { 2, 4, },
	[1841] = { 2, 4, },
	[1842] = { 2, 4, },
	[1843] = { 2, 4, },
	[1844] = { 2, 4, },
	[1845] = { 2, 4, },
	[1846] = { 2, 4, },
	[1847] = { 2, 4, },
	[1848] = { 2, 4, },
	[1849] = { 2, 4, },
	[1850] = { 2, 4, },
	[1851] = { 2, 4, },
	[1852] = { 2, 4, },
	[1853] = { 2, 4, },
	[1854] = { 2, 4, },
	[1855] = { 2, 4, },
	[1856] = { 2, 4, },
	[1857] = { 2, 4, },
	[1858] = { 3, },
	[1859] = { 3, },
	[1860] = { 3, },
	[1861] = { 3, },
	[1862] = { 3, },
	[1863] = { 3, },
	[1864] = { 3, },
	[1865] = { 3, },
	[1866] = { 3, },
	[1881] = { 2, },
	[1882] = { 2, 4, 6, },
	[1883] = { 2, 4, 6, },
	[1884] = { 2, 4, 6, },
	[1885] = { 2, 4, 6, },
	[1886] = { 2, 4, 6, },
	[1887] = { 2, 4, 6, },
	[1888] = { 2, 4, 6, },
	[1889] = { 2, 4, 6, },
	[1890] = { 2, 4, 6, },
	[1891] = { 2, 4, 6, },
	[1892] = { 2, 4, 6, },
	[1893] = { 2, 4, 6, },
	[1894] = { 2, 4, 6, },
	[1895] = { 2, 4, 6, },
	[1896] = { 2, 4, 6, },
	[1897] = { 2, 4, 6, },
	[1898] = { 2, 4, 6, },
	[1899] = { 2, 4, 6, },
	[1900] = { 2, 4, 6, },
	[1901] = { 2, 4, 6, },
	[1902] = { 2, 4, 6, },
	[1903] = { 2, 4, 6, },
	[1904] = { 2, 4, 6, },
	[1905] = { 2, },
	[1906] = { 2, },
	[1907] = { 2, },
	[1908] = { 2, },
	[1909] = { 2, },
	[1910] = { 2, },
	[1911] = { 2, },
	[1912] = { 2, },
	[1913] = { 2, },
	[1914] = { 2, },
	[1915] = { 2, },
	[1916] = { 2, },
	[1917] = { 2, },
	[1918] = { 2, },
	[1932] = { 2, 4, 6, },
	[1933] = { 2, 4, 6, },
	[1934] = { 2, 4, 6, },
	[1935] = { 2, 4, 6, },
	[1936] = { 2, 4, 6, },
	[1937] = { 2, 4, 6, },
	[1938] = { 2, 4, 6, },
	[1939] = { 2, 4, 6, },
	[1940] = { 2, 4, 6, },
	[1941] = { 2, 4, 6, },
	[1942] = { 2, 4, 6, },
	[1943] = { 2, 4, 6, },
	[1944] = { 2, 4, 6, },
	[1945] = { 2, 4, 6, },
	[1946] = { 2, 4, 6, },
	[1947] = { 2, 4, 6, },
	[1948] = { 2, 4, 6, },
	[1949] = { 2, 4, 6, },
	[1950] = { 2, 4, 6, },
	[1951] = { 2, 4, 6, },
	[1952] = { 2, 4, 6, },
	[1953] = { 2, 4, 6, },
	[1954] = { 2, 4, 6, },
	[1955] = { 2, },
	[1956] = { 2, },
	[1959] = { 2, },
};
local GetItemInfoInstant = GetItemInfoInstant;
for setID, set in next, DT.ItemSet do
	local h = {  };
	for i, id in next, set do
		local _, _, _, loc, icon = GetItemInfoInstant(id);
		if h[loc] then
			h = false;
			break;
		end
		h[loc] = i;
	end
	if h then
		for loc, i in next, h do
			set[loc] = i;
		end
	end
end
